// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon ElastiCache
///
/// Client for invoking operations on Amazon ElastiCache. Each operation on Amazon ElastiCache is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_elasticache::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_elasticache::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_elasticache::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddTagsToResource`](crate::client::fluent_builders::AddTagsToResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_name(impl Into<String>)`](crate::client::fluent_builders::AddTagsToResource::resource_name) / [`set_resource_name(Option<String>)`](crate::client::fluent_builders::AddTagsToResource::set_resource_name): <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be added, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>. ElastiCache resources are <i>cluster</i> and <i>snapshot</i>.</p>  <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Service Namespaces</a>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::AddTagsToResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::AddTagsToResource::set_tags): <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    /// - On success, responds with [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput) with field(s):
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::AddTagsToResourceOutput::tag_list): <p>A list of tags as key-value pairs.</p>
    /// - On failure, responds with [`SdkError<AddTagsToResourceError>`](crate::error::AddTagsToResourceError)
    pub fn add_tags_to_resource(&self) -> fluent_builders::AddTagsToResource {
        fluent_builders::AddTagsToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AuthorizeCacheSecurityGroupIngress`](crate::client::fluent_builders::AuthorizeCacheSecurityGroupIngress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_security_group_name(impl Into<String>)`](crate::client::fluent_builders::AuthorizeCacheSecurityGroupIngress::cache_security_group_name) / [`set_cache_security_group_name(Option<String>)`](crate::client::fluent_builders::AuthorizeCacheSecurityGroupIngress::set_cache_security_group_name): <p>The cache security group that allows network ingress.</p>
    ///   - [`ec2_security_group_name(impl Into<String>)`](crate::client::fluent_builders::AuthorizeCacheSecurityGroupIngress::ec2_security_group_name) / [`set_ec2_security_group_name(Option<String>)`](crate::client::fluent_builders::AuthorizeCacheSecurityGroupIngress::set_ec2_security_group_name): <p>The Amazon EC2 security group to be authorized for ingress to the cache security group.</p>
    ///   - [`ec2_security_group_owner_id(impl Into<String>)`](crate::client::fluent_builders::AuthorizeCacheSecurityGroupIngress::ec2_security_group_owner_id) / [`set_ec2_security_group_owner_id(Option<String>)`](crate::client::fluent_builders::AuthorizeCacheSecurityGroupIngress::set_ec2_security_group_owner_id): <p>The Amazon account number of the Amazon EC2 security group owner. Note that this is not the same thing as an Amazon access key ID - you must provide a valid Amazon account number for this parameter.</p>
    /// - On success, responds with [`AuthorizeCacheSecurityGroupIngressOutput`](crate::output::AuthorizeCacheSecurityGroupIngressOutput) with field(s):
    ///   - [`cache_security_group(Option<CacheSecurityGroup>)`](crate::output::AuthorizeCacheSecurityGroupIngressOutput::cache_security_group): <p>Represents the output of one of the following operations:</p>  <ul>   <li> <p> <code>AuthorizeCacheSecurityGroupIngress</code> </p> </li>   <li> <p> <code>CreateCacheSecurityGroup</code> </p> </li>   <li> <p> <code>RevokeCacheSecurityGroupIngress</code> </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<AuthorizeCacheSecurityGroupIngressError>`](crate::error::AuthorizeCacheSecurityGroupIngressError)
    pub fn authorize_cache_security_group_ingress(
        &self,
    ) -> fluent_builders::AuthorizeCacheSecurityGroupIngress {
        fluent_builders::AuthorizeCacheSecurityGroupIngress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchApplyUpdateAction`](crate::client::fluent_builders::BatchApplyUpdateAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_group_ids(Vec<String>)`](crate::client::fluent_builders::BatchApplyUpdateAction::replication_group_ids) / [`set_replication_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchApplyUpdateAction::set_replication_group_ids): <p>The replication group IDs</p>
    ///   - [`cache_cluster_ids(Vec<String>)`](crate::client::fluent_builders::BatchApplyUpdateAction::cache_cluster_ids) / [`set_cache_cluster_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchApplyUpdateAction::set_cache_cluster_ids): <p>The cache cluster IDs</p>
    ///   - [`service_update_name(impl Into<String>)`](crate::client::fluent_builders::BatchApplyUpdateAction::service_update_name) / [`set_service_update_name(Option<String>)`](crate::client::fluent_builders::BatchApplyUpdateAction::set_service_update_name): <p>The unique ID of the service update</p>
    /// - On success, responds with [`BatchApplyUpdateActionOutput`](crate::output::BatchApplyUpdateActionOutput) with field(s):
    ///   - [`processed_update_actions(Option<Vec<ProcessedUpdateAction>>)`](crate::output::BatchApplyUpdateActionOutput::processed_update_actions): <p>Update actions that have been processed successfully</p>
    ///   - [`unprocessed_update_actions(Option<Vec<UnprocessedUpdateAction>>)`](crate::output::BatchApplyUpdateActionOutput::unprocessed_update_actions): <p>Update actions that haven't been processed successfully</p>
    /// - On failure, responds with [`SdkError<BatchApplyUpdateActionError>`](crate::error::BatchApplyUpdateActionError)
    pub fn batch_apply_update_action(&self) -> fluent_builders::BatchApplyUpdateAction {
        fluent_builders::BatchApplyUpdateAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchStopUpdateAction`](crate::client::fluent_builders::BatchStopUpdateAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_group_ids(Vec<String>)`](crate::client::fluent_builders::BatchStopUpdateAction::replication_group_ids) / [`set_replication_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchStopUpdateAction::set_replication_group_ids): <p>The replication group IDs</p>
    ///   - [`cache_cluster_ids(Vec<String>)`](crate::client::fluent_builders::BatchStopUpdateAction::cache_cluster_ids) / [`set_cache_cluster_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchStopUpdateAction::set_cache_cluster_ids): <p>The cache cluster IDs</p>
    ///   - [`service_update_name(impl Into<String>)`](crate::client::fluent_builders::BatchStopUpdateAction::service_update_name) / [`set_service_update_name(Option<String>)`](crate::client::fluent_builders::BatchStopUpdateAction::set_service_update_name): <p>The unique ID of the service update</p>
    /// - On success, responds with [`BatchStopUpdateActionOutput`](crate::output::BatchStopUpdateActionOutput) with field(s):
    ///   - [`processed_update_actions(Option<Vec<ProcessedUpdateAction>>)`](crate::output::BatchStopUpdateActionOutput::processed_update_actions): <p>Update actions that have been processed successfully</p>
    ///   - [`unprocessed_update_actions(Option<Vec<UnprocessedUpdateAction>>)`](crate::output::BatchStopUpdateActionOutput::unprocessed_update_actions): <p>Update actions that haven't been processed successfully</p>
    /// - On failure, responds with [`SdkError<BatchStopUpdateActionError>`](crate::error::BatchStopUpdateActionError)
    pub fn batch_stop_update_action(&self) -> fluent_builders::BatchStopUpdateAction {
        fluent_builders::BatchStopUpdateAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CompleteMigration`](crate::client::fluent_builders::CompleteMigration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_group_id(impl Into<String>)`](crate::client::fluent_builders::CompleteMigration::replication_group_id) / [`set_replication_group_id(Option<String>)`](crate::client::fluent_builders::CompleteMigration::set_replication_group_id): <p>The ID of the replication group to which data is being migrated.</p>
    ///   - [`force(bool)`](crate::client::fluent_builders::CompleteMigration::force) / [`set_force(bool)`](crate::client::fluent_builders::CompleteMigration::set_force): <p>Forces the migration to stop without ensuring that data is in sync. It is recommended to use this option only to abort the migration and not recommended when application wants to continue migration to ElastiCache.</p>
    /// - On success, responds with [`CompleteMigrationOutput`](crate::output::CompleteMigrationOutput) with field(s):
    ///   - [`replication_group(Option<ReplicationGroup>)`](crate::output::CompleteMigrationOutput::replication_group): <p>Contains all of the attributes of a specific Redis replication group.</p>
    /// - On failure, responds with [`SdkError<CompleteMigrationError>`](crate::error::CompleteMigrationError)
    pub fn complete_migration(&self) -> fluent_builders::CompleteMigration {
        fluent_builders::CompleteMigration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopySnapshot`](crate::client::fluent_builders::CopySnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_snapshot_name(impl Into<String>)`](crate::client::fluent_builders::CopySnapshot::source_snapshot_name) / [`set_source_snapshot_name(Option<String>)`](crate::client::fluent_builders::CopySnapshot::set_source_snapshot_name): <p>The name of an existing snapshot from which to make a copy.</p>
    ///   - [`target_snapshot_name(impl Into<String>)`](crate::client::fluent_builders::CopySnapshot::target_snapshot_name) / [`set_target_snapshot_name(Option<String>)`](crate::client::fluent_builders::CopySnapshot::set_target_snapshot_name): <p>A name for the snapshot copy. ElastiCache does not permit overwriting a snapshot, therefore this name must be unique within its context - ElastiCache or an Amazon S3 bucket if exporting.</p>
    ///   - [`target_bucket(impl Into<String>)`](crate::client::fluent_builders::CopySnapshot::target_bucket) / [`set_target_bucket(Option<String>)`](crate::client::fluent_builders::CopySnapshot::set_target_bucket): <p>The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access.</p>  <p>When using this parameter to export a snapshot, be sure Amazon ElastiCache has the needed permissions to this S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access">Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the <i>Amazon ElastiCache User Guide</i>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html">Exporting a Snapshot</a> in the <i>Amazon ElastiCache User Guide</i>.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CopySnapshot::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CopySnapshot::set_kms_key_id): <p>The ID of the KMS key used to encrypt the target snapshot.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CopySnapshot::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CopySnapshot::set_tags): <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    /// - On success, responds with [`CopySnapshotOutput`](crate::output::CopySnapshotOutput) with field(s):
    ///   - [`snapshot(Option<Snapshot>)`](crate::output::CopySnapshotOutput::snapshot): <p>Represents a copy of an entire Redis cluster as of the time when the snapshot was taken.</p>
    /// - On failure, responds with [`SdkError<CopySnapshotError>`](crate::error::CopySnapshotError)
    pub fn copy_snapshot(&self) -> fluent_builders::CopySnapshot {
        fluent_builders::CopySnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCacheCluster`](crate::client::fluent_builders::CreateCacheCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_cluster_id(impl Into<String>)`](crate::client::fluent_builders::CreateCacheCluster::cache_cluster_id) / [`set_cache_cluster_id(Option<String>)`](crate::client::fluent_builders::CreateCacheCluster::set_cache_cluster_id): <p>The node group (shard) identifier. This parameter is stored as a lowercase string.</p>  <p> <b>Constraints:</b> </p>  <ul>   <li> <p>A name must contain from 1 to 50 alphanumeric characters or hyphens.</p> </li>   <li> <p>The first character must be a letter.</p> </li>   <li> <p>A name cannot end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>
    ///   - [`replication_group_id(impl Into<String>)`](crate::client::fluent_builders::CreateCacheCluster::replication_group_id) / [`set_replication_group_id(Option<String>)`](crate::client::fluent_builders::CreateCacheCluster::set_replication_group_id): <p>The ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.</p>  <p>If the specified replication group is Multi-AZ enabled and the Availability Zone is not specified, the cluster is created in Availability Zones that provide the best spread of read replicas across Availability Zones.</p> <note>   <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>  </note>
    ///   - [`az_mode(AzMode)`](crate::client::fluent_builders::CreateCacheCluster::az_mode) / [`set_az_mode(Option<AzMode>)`](crate::client::fluent_builders::CreateCacheCluster::set_az_mode): <p>Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region.</p>  <p>This parameter is only supported for Memcached clusters.</p>  <p>If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes <code>single-az</code> mode.</p>
    ///   - [`preferred_availability_zone(impl Into<String>)`](crate::client::fluent_builders::CreateCacheCluster::preferred_availability_zone) / [`set_preferred_availability_zone(Option<String>)`](crate::client::fluent_builders::CreateCacheCluster::set_preferred_availability_zone): <p>The EC2 Availability Zone in which the cluster is created.</p>  <p>All nodes belonging to this cluster are placed in the preferred Availability Zone. If you want to create your nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code>.</p>  <p>Default: System chosen Availability Zone.</p>
    ///   - [`preferred_availability_zones(Vec<String>)`](crate::client::fluent_builders::CreateCacheCluster::preferred_availability_zones) / [`set_preferred_availability_zones(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCacheCluster::set_preferred_availability_zones): <p>A list of the Availability Zones in which cache nodes are created. The order of the zones in the list is not important.</p>  <p>This option is only supported on Memcached.</p> <note>   <p>If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group.</p>   <p>The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.</p>  </note>  <p>If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code> instead, or repeat the Availability Zone multiple times in the list.</p>  <p>Default: System chosen Availability Zones.</p>
    ///   - [`num_cache_nodes(i32)`](crate::client::fluent_builders::CreateCacheCluster::num_cache_nodes) / [`set_num_cache_nodes(Option<i32>)`](crate::client::fluent_builders::CreateCacheCluster::set_num_cache_nodes): <p>The initial number of cache nodes that the cluster has.</p>  <p>For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.</p>  <p>If you need more than 40 nodes for your Memcached cluster, please fill out the ElastiCache Limit Increase Request form at <a href="http://aws.amazon.com/contact-us/elasticache-node-limit-request/">http://aws.amazon.com/contact-us/elasticache-node-limit-request/</a>.</p>
    ///   - [`cache_node_type(impl Into<String>)`](crate::client::fluent_builders::CreateCacheCluster::cache_node_type) / [`set_cache_node_type(Option<String>)`](crate::client::fluent_builders::CreateCacheCluster::set_cache_node_type): <p>The compute and memory capacity of the nodes in the node group (shard).</p>  <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>  <ul>   <li> <p>General purpose:</p>    <ul>     <li> <p>Current generation: </p> <p> <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>       <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>      </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>     <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>    </ul> </li>   <li> <p>Compute optimized:</p>    <ul>     <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>    </ul> </li>   <li> <p>Memory optimized:</p>    <ul>     <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>       <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>      </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>     <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>    </ul> </li>  </ul>  <p> <b>Additional node type info</b> </p>  <ul>   <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>   <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>   <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>   <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>  </ul>
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::CreateCacheCluster::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::CreateCacheCluster::set_engine): <p>The name of the cache engine to be used for this cluster.</p>  <p>Valid values for this parameter are: <code>memcached</code> | <code>redis</code> </p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::CreateCacheCluster::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::CreateCacheCluster::set_engine_version): <p>The version number of the cache engine to be used for this cluster. To view the supported cache engine versions, use the DescribeCacheEngineVersions operation.</p>  <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version. </p>
    ///   - [`cache_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateCacheCluster::cache_parameter_group_name) / [`set_cache_parameter_group_name(Option<String>)`](crate::client::fluent_builders::CreateCacheCluster::set_cache_parameter_group_name): <p>The name of the parameter group to associate with this cluster. If this argument is omitted, the default parameter group for the specified engine is used. You cannot use any parameter group which has <code>cluster-enabled='yes'</code> when creating a cluster.</p>
    ///   - [`cache_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateCacheCluster::cache_subnet_group_name) / [`set_cache_subnet_group_name(Option<String>)`](crate::client::fluent_builders::CreateCacheCluster::set_cache_subnet_group_name): <p>The name of the subnet group to be used for the cluster.</p>  <p>Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).</p> <important>   <p>If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet Groups</a>.</p>  </important>
    ///   - [`cache_security_group_names(Vec<String>)`](crate::client::fluent_builders::CreateCacheCluster::cache_security_group_names) / [`set_cache_security_group_names(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCacheCluster::set_cache_security_group_names): <p>A list of security group names to associate with this cluster.</p>  <p>Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>
    ///   - [`security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateCacheCluster::security_group_ids) / [`set_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCacheCluster::set_security_group_ids): <p>One or more VPC security groups associated with the cluster.</p>  <p>Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateCacheCluster::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateCacheCluster::set_tags): <p>A list of tags to be added to this resource.</p>
    ///   - [`snapshot_arns(Vec<String>)`](crate::client::fluent_builders::CreateCacheCluster::snapshot_arns) / [`set_snapshot_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCacheCluster::set_snapshot_arns): <p>A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis RDB snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard). The Amazon S3 object name in the ARN cannot contain any commas.</p> <note>   <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>  </note>  <p>Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code> </p>
    ///   - [`snapshot_name(impl Into<String>)`](crate::client::fluent_builders::CreateCacheCluster::snapshot_name) / [`set_snapshot_name(Option<String>)`](crate::client::fluent_builders::CreateCacheCluster::set_snapshot_name): <p>The name of a Redis snapshot from which to restore data into the new node group (shard). The snapshot status changes to <code>restoring</code> while the new node group (shard) is being created.</p> <note>   <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>  </note>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::CreateCacheCluster::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::CreateCacheCluster::set_preferred_maintenance_window): <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. </p>
    ///   - [`port(i32)`](crate::client::fluent_builders::CreateCacheCluster::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::CreateCacheCluster::set_port): <p>The port number on which each of the cache nodes accepts connections.</p>
    ///   - [`notification_topic_arn(impl Into<String>)`](crate::client::fluent_builders::CreateCacheCluster::notification_topic_arn) / [`set_notification_topic_arn(Option<String>)`](crate::client::fluent_builders::CreateCacheCluster::set_notification_topic_arn): <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p> <note>   <p>The Amazon SNS topic owner must be the same as the cluster owner.</p>  </note>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::CreateCacheCluster::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(Option<bool>)`](crate::client::fluent_builders::CreateCacheCluster::set_auto_minor_version_upgrade): <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
    ///   - [`snapshot_retention_limit(i32)`](crate::client::fluent_builders::CreateCacheCluster::snapshot_retention_limit) / [`set_snapshot_retention_limit(Option<i32>)`](crate::client::fluent_builders::CreateCacheCluster::set_snapshot_retention_limit): <p>The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5 days before being deleted.</p> <note>   <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>  </note>  <p>Default: 0 (i.e., automatic backups are disabled for this cache cluster).</p>
    ///   - [`snapshot_window(impl Into<String>)`](crate::client::fluent_builders::CreateCacheCluster::snapshot_window) / [`set_snapshot_window(Option<String>)`](crate::client::fluent_builders::CreateCacheCluster::set_snapshot_window): <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).</p>  <p>Example: <code>05:00-09:00</code> </p>  <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p> <note>   <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>  </note>
    ///   - [`auth_token(impl Into<String>)`](crate::client::fluent_builders::CreateCacheCluster::auth_token) / [`set_auth_token(Option<String>)`](crate::client::fluent_builders::CreateCacheCluster::set_auth_token): <p> <b>Reserved parameter.</b> The password used to access a password protected server.</p>  <p>Password constraints:</p>  <ul>   <li> <p>Must be only printable ASCII characters.</p> </li>   <li> <p>Must be at least 16 characters and no more than 128 characters in length.</p> </li>   <li> <p>The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special characters cannot be used in the AUTH token.</p> </li>  </ul>  <p>For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at http://redis.io/commands/AUTH.</p>
    ///   - [`outpost_mode(OutpostMode)`](crate::client::fluent_builders::CreateCacheCluster::outpost_mode) / [`set_outpost_mode(Option<OutpostMode>)`](crate::client::fluent_builders::CreateCacheCluster::set_outpost_mode): <p>Specifies whether the nodes in the cluster are created in a single outpost or across multiple outposts.</p>
    ///   - [`preferred_outpost_arn(impl Into<String>)`](crate::client::fluent_builders::CreateCacheCluster::preferred_outpost_arn) / [`set_preferred_outpost_arn(Option<String>)`](crate::client::fluent_builders::CreateCacheCluster::set_preferred_outpost_arn): <p>The outpost ARN in which the cache cluster is created.</p>
    ///   - [`preferred_outpost_arns(Vec<String>)`](crate::client::fluent_builders::CreateCacheCluster::preferred_outpost_arns) / [`set_preferred_outpost_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCacheCluster::set_preferred_outpost_arns): <p>The outpost ARNs in which the cache cluster is created.</p>
    ///   - [`log_delivery_configurations(Vec<LogDeliveryConfigurationRequest>)`](crate::client::fluent_builders::CreateCacheCluster::log_delivery_configurations) / [`set_log_delivery_configurations(Option<Vec<LogDeliveryConfigurationRequest>>)`](crate::client::fluent_builders::CreateCacheCluster::set_log_delivery_configurations): <p>Specifies the destination, format and type of the logs. </p>
    /// - On success, responds with [`CreateCacheClusterOutput`](crate::output::CreateCacheClusterOutput) with field(s):
    ///   - [`cache_cluster(Option<CacheCluster>)`](crate::output::CreateCacheClusterOutput::cache_cluster): <p>Contains all of the attributes of a specific cluster.</p>
    /// - On failure, responds with [`SdkError<CreateCacheClusterError>`](crate::error::CreateCacheClusterError)
    pub fn create_cache_cluster(&self) -> fluent_builders::CreateCacheCluster {
        fluent_builders::CreateCacheCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCacheParameterGroup`](crate::client::fluent_builders::CreateCacheParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateCacheParameterGroup::cache_parameter_group_name) / [`set_cache_parameter_group_name(Option<String>)`](crate::client::fluent_builders::CreateCacheParameterGroup::set_cache_parameter_group_name): <p>A user-specified name for the cache parameter group.</p>
    ///   - [`cache_parameter_group_family(impl Into<String>)`](crate::client::fluent_builders::CreateCacheParameterGroup::cache_parameter_group_family) / [`set_cache_parameter_group_family(Option<String>)`](crate::client::fluent_builders::CreateCacheParameterGroup::set_cache_parameter_group_family): <p>The name of the cache parameter group family that the cache parameter group can be used with.</p>  <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateCacheParameterGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateCacheParameterGroup::set_description): <p>A user-specified description for the cache parameter group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateCacheParameterGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateCacheParameterGroup::set_tags): <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    /// - On success, responds with [`CreateCacheParameterGroupOutput`](crate::output::CreateCacheParameterGroupOutput) with field(s):
    ///   - [`cache_parameter_group(Option<CacheParameterGroup>)`](crate::output::CreateCacheParameterGroupOutput::cache_parameter_group): <p>Represents the output of a <code>CreateCacheParameterGroup</code> operation.</p>
    /// - On failure, responds with [`SdkError<CreateCacheParameterGroupError>`](crate::error::CreateCacheParameterGroupError)
    pub fn create_cache_parameter_group(&self) -> fluent_builders::CreateCacheParameterGroup {
        fluent_builders::CreateCacheParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCacheSecurityGroup`](crate::client::fluent_builders::CreateCacheSecurityGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_security_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateCacheSecurityGroup::cache_security_group_name) / [`set_cache_security_group_name(Option<String>)`](crate::client::fluent_builders::CreateCacheSecurityGroup::set_cache_security_group_name): <p>A name for the cache security group. This value is stored as a lowercase string.</p>  <p>Constraints: Must contain no more than 255 alphanumeric characters. Cannot be the word "Default".</p>  <p>Example: <code>mysecuritygroup</code> </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateCacheSecurityGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateCacheSecurityGroup::set_description): <p>A description for the cache security group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateCacheSecurityGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateCacheSecurityGroup::set_tags): <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    /// - On success, responds with [`CreateCacheSecurityGroupOutput`](crate::output::CreateCacheSecurityGroupOutput) with field(s):
    ///   - [`cache_security_group(Option<CacheSecurityGroup>)`](crate::output::CreateCacheSecurityGroupOutput::cache_security_group): <p>Represents the output of one of the following operations:</p>  <ul>   <li> <p> <code>AuthorizeCacheSecurityGroupIngress</code> </p> </li>   <li> <p> <code>CreateCacheSecurityGroup</code> </p> </li>   <li> <p> <code>RevokeCacheSecurityGroupIngress</code> </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<CreateCacheSecurityGroupError>`](crate::error::CreateCacheSecurityGroupError)
    pub fn create_cache_security_group(&self) -> fluent_builders::CreateCacheSecurityGroup {
        fluent_builders::CreateCacheSecurityGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCacheSubnetGroup`](crate::client::fluent_builders::CreateCacheSubnetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateCacheSubnetGroup::cache_subnet_group_name) / [`set_cache_subnet_group_name(Option<String>)`](crate::client::fluent_builders::CreateCacheSubnetGroup::set_cache_subnet_group_name): <p>A name for the cache subnet group. This value is stored as a lowercase string.</p>  <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>  <p>Example: <code>mysubnetgroup</code> </p>
    ///   - [`cache_subnet_group_description(impl Into<String>)`](crate::client::fluent_builders::CreateCacheSubnetGroup::cache_subnet_group_description) / [`set_cache_subnet_group_description(Option<String>)`](crate::client::fluent_builders::CreateCacheSubnetGroup::set_cache_subnet_group_description): <p>A description for the cache subnet group.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::CreateCacheSubnetGroup::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCacheSubnetGroup::set_subnet_ids): <p>A list of VPC subnet IDs for the cache subnet group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateCacheSubnetGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateCacheSubnetGroup::set_tags): <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    /// - On success, responds with [`CreateCacheSubnetGroupOutput`](crate::output::CreateCacheSubnetGroupOutput) with field(s):
    ///   - [`cache_subnet_group(Option<CacheSubnetGroup>)`](crate::output::CreateCacheSubnetGroupOutput::cache_subnet_group): <p>Represents the output of one of the following operations:</p>  <ul>   <li> <p> <code>CreateCacheSubnetGroup</code> </p> </li>   <li> <p> <code>ModifyCacheSubnetGroup</code> </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<CreateCacheSubnetGroupError>`](crate::error::CreateCacheSubnetGroupError)
    pub fn create_cache_subnet_group(&self) -> fluent_builders::CreateCacheSubnetGroup {
        fluent_builders::CreateCacheSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGlobalReplicationGroup`](crate::client::fluent_builders::CreateGlobalReplicationGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_replication_group_id_suffix(impl Into<String>)`](crate::client::fluent_builders::CreateGlobalReplicationGroup::global_replication_group_id_suffix) / [`set_global_replication_group_id_suffix(Option<String>)`](crate::client::fluent_builders::CreateGlobalReplicationGroup::set_global_replication_group_id_suffix): <p>The suffix name of a Global datastore. Amazon ElastiCache automatically applies a prefix to the Global datastore ID when it is created. Each Amazon Region has its own prefix. For instance, a Global datastore ID created in the US-West-1 region will begin with "dsdfu" along with the suffix name you provide. The suffix, combined with the auto-generated prefix, guarantees uniqueness of the Global datastore name across multiple regions. </p>  <p>For a full list of Amazon Regions and their respective Global datastore iD prefixes, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastores-CLI.html">Using the Amazon CLI with Global datastores </a>.</p>
    ///   - [`global_replication_group_description(impl Into<String>)`](crate::client::fluent_builders::CreateGlobalReplicationGroup::global_replication_group_description) / [`set_global_replication_group_description(Option<String>)`](crate::client::fluent_builders::CreateGlobalReplicationGroup::set_global_replication_group_description): <p>Provides details of the Global datastore</p>
    ///   - [`primary_replication_group_id(impl Into<String>)`](crate::client::fluent_builders::CreateGlobalReplicationGroup::primary_replication_group_id) / [`set_primary_replication_group_id(Option<String>)`](crate::client::fluent_builders::CreateGlobalReplicationGroup::set_primary_replication_group_id): <p>The name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.</p>
    /// - On success, responds with [`CreateGlobalReplicationGroupOutput`](crate::output::CreateGlobalReplicationGroupOutput) with field(s):
    ///   - [`global_replication_group(Option<GlobalReplicationGroup>)`](crate::output::CreateGlobalReplicationGroupOutput::global_replication_group): <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary cluster automatically replicates updates to the secondary cluster.</p>  <ul>   <li> <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore, which is what you use to associate a secondary cluster.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<CreateGlobalReplicationGroupError>`](crate::error::CreateGlobalReplicationGroupError)
    pub fn create_global_replication_group(&self) -> fluent_builders::CreateGlobalReplicationGroup {
        fluent_builders::CreateGlobalReplicationGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateReplicationGroup`](crate::client::fluent_builders::CreateReplicationGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_group_id(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationGroup::replication_group_id) / [`set_replication_group_id(Option<String>)`](crate::client::fluent_builders::CreateReplicationGroup::set_replication_group_id): <p>The replication group identifier. This parameter is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>A name must contain from 1 to 40 alphanumeric characters or hyphens.</p> </li>   <li> <p>The first character must be a letter.</p> </li>   <li> <p>A name cannot end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>
    ///   - [`replication_group_description(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationGroup::replication_group_description) / [`set_replication_group_description(Option<String>)`](crate::client::fluent_builders::CreateReplicationGroup::set_replication_group_description): <p>A user-created description for the replication group.</p>
    ///   - [`global_replication_group_id(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationGroup::global_replication_group_id) / [`set_global_replication_group_id(Option<String>)`](crate::client::fluent_builders::CreateReplicationGroup::set_global_replication_group_id): <p>The name of the Global datastore</p>
    ///   - [`primary_cluster_id(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationGroup::primary_cluster_id) / [`set_primary_cluster_id(Option<String>)`](crate::client::fluent_builders::CreateReplicationGroup::set_primary_cluster_id): <p>The identifier of the cluster that serves as the primary for this replication group. This cluster must already exist and have a status of <code>available</code>.</p>  <p>This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or <code>ReplicasPerNodeGroup</code> is specified.</p>
    ///   - [`automatic_failover_enabled(bool)`](crate::client::fluent_builders::CreateReplicationGroup::automatic_failover_enabled) / [`set_automatic_failover_enabled(Option<bool>)`](crate::client::fluent_builders::CreateReplicationGroup::set_automatic_failover_enabled): <p>Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.</p>  <p> <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.</p>  <p>Default: false</p>
    ///   - [`multi_az_enabled(bool)`](crate::client::fluent_builders::CreateReplicationGroup::multi_az_enabled) / [`set_multi_az_enabled(Option<bool>)`](crate::client::fluent_builders::CreateReplicationGroup::set_multi_az_enabled): <p>A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a>.</p>
    ///   - [`num_cache_clusters(i32)`](crate::client::fluent_builders::CreateReplicationGroup::num_cache_clusters) / [`set_num_cache_clusters(Option<i32>)`](crate::client::fluent_builders::CreateReplicationGroup::set_num_cache_clusters): <p>The number of clusters this replication group initially has.</p>  <p>This parameter is not used if there is more than one node group (shard). You should use <code>ReplicasPerNodeGroup</code> instead.</p>  <p>If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1), or you can explicitly set it to a value between 2 and 6.</p>  <p>The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).</p>
    ///   - [`preferred_cache_cluster_a_zs(Vec<String>)`](crate::client::fluent_builders::CreateReplicationGroup::preferred_cache_cluster_a_zs) / [`set_preferred_cache_cluster_a_zs(Option<Vec<String>>)`](crate::client::fluent_builders::CreateReplicationGroup::set_preferred_cache_cluster_a_zs): <p>A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in the first AZ in the list.</p>  <p>This parameter is not used if there is more than one node group (shard). You should use <code>NodeGroupConfiguration</code> instead.</p> <note>   <p>If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in Availability Zones associated with the subnets in the selected subnet group.</p>   <p>The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.</p>  </note>  <p>Default: system chosen Availability Zones.</p>
    ///   - [`num_node_groups(i32)`](crate::client::fluent_builders::CreateReplicationGroup::num_node_groups) / [`set_num_node_groups(Option<i32>)`](crate::client::fluent_builders::CreateReplicationGroup::set_num_node_groups): <p>An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled) replication group. For Redis (cluster mode disabled) either omit this parameter or set it to 1.</p>  <p>Default: 1</p>
    ///   - [`replicas_per_node_group(i32)`](crate::client::fluent_builders::CreateReplicationGroup::replicas_per_node_group) / [`set_replicas_per_node_group(Option<i32>)`](crate::client::fluent_builders::CreateReplicationGroup::set_replicas_per_node_group): <p>An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values are 0 to 5.</p>
    ///   - [`node_group_configuration(Vec<NodeGroupConfiguration>)`](crate::client::fluent_builders::CreateReplicationGroup::node_group_configuration) / [`set_node_group_configuration(Option<Vec<NodeGroupConfiguration>>)`](crate::client::fluent_builders::CreateReplicationGroup::set_node_group_configuration): <p>A list of node group (shard) configuration options. Each node group (shard) configuration has the following members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>, <code>ReplicaCount</code>, and <code>Slots</code>.</p>  <p>If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you can use this parameter to individually configure each node group (shard), or you can omit this parameter. However, it is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You must configure each node group (shard) using this parameter because you must specify the slots for each node group.</p>
    ///   - [`cache_node_type(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationGroup::cache_node_type) / [`set_cache_node_type(Option<String>)`](crate::client::fluent_builders::CreateReplicationGroup::set_cache_node_type): <p>The compute and memory capacity of the nodes in the node group (shard).</p>  <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>  <ul>   <li> <p>General purpose:</p>    <ul>     <li> <p>Current generation: </p> <p> <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>       <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>      </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>     <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>    </ul> </li>   <li> <p>Compute optimized:</p>    <ul>     <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>    </ul> </li>   <li> <p>Memory optimized with data tiering:</p>    <ul>     <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>    </ul> </li>   <li> <p>Memory optimized:</p>    <ul>     <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>       <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>      </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>     <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>    </ul> </li>  </ul>  <p> <b>Additional node type info</b> </p>  <ul>   <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>   <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>   <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>   <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>  </ul>
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationGroup::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::CreateReplicationGroup::set_engine): <p>The name of the cache engine to be used for the clusters in this replication group. Must be Redis.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationGroup::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::CreateReplicationGroup::set_engine_version): <p>The version number of the cache engine to be used for the clusters in this replication group. To view the supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.</p>  <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version. </p>
    ///   - [`cache_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationGroup::cache_parameter_group_name) / [`set_cache_parameter_group_name(Option<String>)`](crate::client::fluent_builders::CreateReplicationGroup::set_cache_parameter_group_name): <p>The name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used.</p>  <p>If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter group, we recommend that you specify the parameter group by name. </p>  <ul>   <li> <p>To create a Redis (cluster mode disabled) replication group, use <code>CacheParameterGroupName=default.redis3.2</code>.</p> </li>   <li> <p>To create a Redis (cluster mode enabled) replication group, use <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.</p> </li>  </ul>
    ///   - [`cache_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationGroup::cache_subnet_group_name) / [`set_cache_subnet_group_name(Option<String>)`](crate::client::fluent_builders::CreateReplicationGroup::set_cache_subnet_group_name): <p>The name of the cache subnet group to be used for the replication group.</p> <important>   <p>If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet Groups</a>.</p>  </important>
    ///   - [`cache_security_group_names(Vec<String>)`](crate::client::fluent_builders::CreateReplicationGroup::cache_security_group_names) / [`set_cache_security_group_names(Option<Vec<String>>)`](crate::client::fluent_builders::CreateReplicationGroup::set_cache_security_group_names): <p>A list of cache security group names to associate with this replication group.</p>
    ///   - [`security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateReplicationGroup::security_group_ids) / [`set_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateReplicationGroup::set_security_group_ids): <p>One or more Amazon VPC security groups associated with this replication group.</p>  <p>Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon VPC).</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateReplicationGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateReplicationGroup::set_tags): <p>A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=<code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=<code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=<code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.</p>
    ///   - [`snapshot_arns(Vec<String>)`](crate::client::fluent_builders::CreateReplicationGroup::snapshot_arns) / [`set_snapshot_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateReplicationGroup::set_snapshot_arns): <p>A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot contain any commas. The new replication group will have the number of node groups (console: shards) specified by the parameter <i>NumNodeGroups</i> or the number of node groups configured by <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.</p>  <p>Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code> </p>
    ///   - [`snapshot_name(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationGroup::snapshot_name) / [`set_snapshot_name(Option<String>)`](crate::client::fluent_builders::CreateReplicationGroup::set_snapshot_name): <p>The name of a snapshot from which to restore data into the new replication group. The snapshot status changes to <code>restoring</code> while the new replication group is being created.</p>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationGroup::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::CreateReplicationGroup::set_preferred_maintenance_window): <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for <code>ddd</code> are:</p>  <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>  <p>Valid values for <code>ddd</code> are:</p>  <ul>   <li> <p> <code>sun</code> </p> </li>   <li> <p> <code>mon</code> </p> </li>   <li> <p> <code>tue</code> </p> </li>   <li> <p> <code>wed</code> </p> </li>   <li> <p> <code>thu</code> </p> </li>   <li> <p> <code>fri</code> </p> </li>   <li> <p> <code>sat</code> </p> </li>  </ul>  <p>Example: <code>sun:23:00-mon:01:30</code> </p>
    ///   - [`port(i32)`](crate::client::fluent_builders::CreateReplicationGroup::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::CreateReplicationGroup::set_port): <p>The port number on which each member of the replication group accepts connections.</p>
    ///   - [`notification_topic_arn(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationGroup::notification_topic_arn) / [`set_notification_topic_arn(Option<String>)`](crate::client::fluent_builders::CreateReplicationGroup::set_notification_topic_arn): <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p> <note>   <p>The Amazon SNS topic owner must be the same as the cluster owner.</p>  </note>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::CreateReplicationGroup::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(Option<bool>)`](crate::client::fluent_builders::CreateReplicationGroup::set_auto_minor_version_upgrade): <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
    ///   - [`snapshot_retention_limit(i32)`](crate::client::fluent_builders::CreateReplicationGroup::snapshot_retention_limit) / [`set_snapshot_retention_limit(Option<i32>)`](crate::client::fluent_builders::CreateReplicationGroup::set_snapshot_retention_limit): <p>The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>  <p>Default: 0 (i.e., automatic backups are disabled for this cluster).</p>
    ///   - [`snapshot_window(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationGroup::snapshot_window) / [`set_snapshot_window(Option<String>)`](crate::client::fluent_builders::CreateReplicationGroup::set_snapshot_window): <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).</p>  <p>Example: <code>05:00-09:00</code> </p>  <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p>
    ///   - [`auth_token(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationGroup::auth_token) / [`set_auth_token(Option<String>)`](crate::client::fluent_builders::CreateReplicationGroup::set_auth_token): <p> <b>Reserved parameter.</b> The password used to access a password protected server.</p>  <p> <code>AuthToken</code> can be specified only on replication groups where <code>TransitEncryptionEnabled</code> is <code>true</code>.</p> <important>   <p>For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.</p>  </important>  <p>Password constraints:</p>  <ul>   <li> <p>Must be only printable ASCII characters.</p> </li>   <li> <p>Must be at least 16 characters and no more than 128 characters in length.</p> </li>   <li> <p>The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special characters cannot be used in the AUTH token.</p> </li>  </ul>  <p>For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at http://redis.io/commands/AUTH.</p>
    ///   - [`transit_encryption_enabled(bool)`](crate::client::fluent_builders::CreateReplicationGroup::transit_encryption_enabled) / [`set_transit_encryption_enabled(Option<bool>)`](crate::client::fluent_builders::CreateReplicationGroup::set_transit_encryption_enabled): <p>A flag that enables in-transit encryption when set to <code>true</code>.</p>  <p>You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to <code>true</code> when you create a cluster.</p>  <p>This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is being created in an Amazon VPC.</p>  <p>If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.</p>  <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>  <p>Default: <code>false</code> </p> <important>   <p>For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.</p>  </important>
    ///   - [`at_rest_encryption_enabled(bool)`](crate::client::fluent_builders::CreateReplicationGroup::at_rest_encryption_enabled) / [`set_at_rest_encryption_enabled(Option<bool>)`](crate::client::fluent_builders::CreateReplicationGroup::set_at_rest_encryption_enabled): <p>A flag that enables encryption at rest when set to <code>true</code>.</p>  <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group. </p>  <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>  <p>Default: <code>false</code> </p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationGroup::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateReplicationGroup::set_kms_key_id): <p>The ID of the KMS key used to encrypt the disk in the cluster.</p>
    ///   - [`user_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateReplicationGroup::user_group_ids) / [`set_user_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateReplicationGroup::set_user_group_ids): <p>The user group to associate with the replication group.</p>
    ///   - [`log_delivery_configurations(Vec<LogDeliveryConfigurationRequest>)`](crate::client::fluent_builders::CreateReplicationGroup::log_delivery_configurations) / [`set_log_delivery_configurations(Option<Vec<LogDeliveryConfigurationRequest>>)`](crate::client::fluent_builders::CreateReplicationGroup::set_log_delivery_configurations): <p>Specifies the destination, format and type of the logs.</p>
    ///   - [`data_tiering_enabled(bool)`](crate::client::fluent_builders::CreateReplicationGroup::data_tiering_enabled) / [`set_data_tiering_enabled(Option<bool>)`](crate::client::fluent_builders::CreateReplicationGroup::set_data_tiering_enabled): <p>Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.</p>
    /// - On success, responds with [`CreateReplicationGroupOutput`](crate::output::CreateReplicationGroupOutput) with field(s):
    ///   - [`replication_group(Option<ReplicationGroup>)`](crate::output::CreateReplicationGroupOutput::replication_group): <p>Contains all of the attributes of a specific Redis replication group.</p>
    /// - On failure, responds with [`SdkError<CreateReplicationGroupError>`](crate::error::CreateReplicationGroupError)
    pub fn create_replication_group(&self) -> fluent_builders::CreateReplicationGroup {
        fluent_builders::CreateReplicationGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSnapshot`](crate::client::fluent_builders::CreateSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_group_id(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::replication_group_id) / [`set_replication_group_id(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_replication_group_id): <p>The identifier of an existing replication group. The snapshot is created from this replication group.</p>
    ///   - [`cache_cluster_id(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::cache_cluster_id) / [`set_cache_cluster_id(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_cache_cluster_id): <p>The identifier of an existing cluster. The snapshot is created from this cluster.</p>
    ///   - [`snapshot_name(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::snapshot_name) / [`set_snapshot_name(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_snapshot_name): <p>A name for the snapshot being created.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshot::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateSnapshot::set_kms_key_id): <p>The ID of the KMS key used to encrypt the snapshot.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateSnapshot::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateSnapshot::set_tags): <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    /// - On success, responds with [`CreateSnapshotOutput`](crate::output::CreateSnapshotOutput) with field(s):
    ///   - [`snapshot(Option<Snapshot>)`](crate::output::CreateSnapshotOutput::snapshot): <p>Represents a copy of an entire Redis cluster as of the time when the snapshot was taken.</p>
    /// - On failure, responds with [`SdkError<CreateSnapshotError>`](crate::error::CreateSnapshotError)
    pub fn create_snapshot(&self) -> fluent_builders::CreateSnapshot {
        fluent_builders::CreateSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUser`](crate::client::fluent_builders::CreateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::CreateUser::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::CreateUser::set_user_id): <p>The ID of the user.</p>
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::CreateUser::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::CreateUser::set_user_name): <p>The username of the user.</p>
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::CreateUser::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::CreateUser::set_engine): <p>The current supported value is Redis. </p>
    ///   - [`passwords(Vec<String>)`](crate::client::fluent_builders::CreateUser::passwords) / [`set_passwords(Option<Vec<String>>)`](crate::client::fluent_builders::CreateUser::set_passwords): <p>Passwords used for this user. You can create up to two passwords for each user.</p>
    ///   - [`access_string(impl Into<String>)`](crate::client::fluent_builders::CreateUser::access_string) / [`set_access_string(Option<String>)`](crate::client::fluent_builders::CreateUser::set_access_string): <p>Access permissions string used for this user.</p>
    ///   - [`no_password_required(bool)`](crate::client::fluent_builders::CreateUser::no_password_required) / [`set_no_password_required(Option<bool>)`](crate::client::fluent_builders::CreateUser::set_no_password_required): <p>Indicates a password is not required for this user.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateUser::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateUser::set_tags): <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    /// - On success, responds with [`CreateUserOutput`](crate::output::CreateUserOutput) with field(s):
    ///   - [`user_id(Option<String>)`](crate::output::CreateUserOutput::user_id): <p>The ID of the user.</p>
    ///   - [`user_name(Option<String>)`](crate::output::CreateUserOutput::user_name): <p>The username of the user.</p>
    ///   - [`status(Option<String>)`](crate::output::CreateUserOutput::status): <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
    ///   - [`engine(Option<String>)`](crate::output::CreateUserOutput::engine): <p>The current supported value is Redis.</p>
    ///   - [`minimum_engine_version(Option<String>)`](crate::output::CreateUserOutput::minimum_engine_version): <p>The minimum engine version required, which is Redis 6.0</p>
    ///   - [`access_string(Option<String>)`](crate::output::CreateUserOutput::access_string): <p>Access permissions string used for this user.</p>
    ///   - [`user_group_ids(Option<Vec<String>>)`](crate::output::CreateUserOutput::user_group_ids): <p>Returns a list of the user group IDs the user belongs to.</p>
    ///   - [`authentication(Option<Authentication>)`](crate::output::CreateUserOutput::authentication): <p>Denotes whether the user requires a password to authenticate.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateUserOutput::arn): <p>The Amazon Resource Name (ARN) of the user.</p>
    /// - On failure, responds with [`SdkError<CreateUserError>`](crate::error::CreateUserError)
    pub fn create_user(&self) -> fluent_builders::CreateUser {
        fluent_builders::CreateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUserGroup`](crate::client::fluent_builders::CreateUserGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_group_id(impl Into<String>)`](crate::client::fluent_builders::CreateUserGroup::user_group_id) / [`set_user_group_id(Option<String>)`](crate::client::fluent_builders::CreateUserGroup::set_user_group_id): <p>The ID of the user group.</p>
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::CreateUserGroup::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::CreateUserGroup::set_engine): <p>The current supported value is Redis. </p>
    ///   - [`user_ids(Vec<String>)`](crate::client::fluent_builders::CreateUserGroup::user_ids) / [`set_user_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateUserGroup::set_user_ids): <p>The list of user IDs that belong to the user group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateUserGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateUserGroup::set_tags): <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    /// - On success, responds with [`CreateUserGroupOutput`](crate::output::CreateUserGroupOutput) with field(s):
    ///   - [`user_group_id(Option<String>)`](crate::output::CreateUserGroupOutput::user_group_id): <p>The ID of the user group.</p>
    ///   - [`status(Option<String>)`](crate::output::CreateUserGroupOutput::status): <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
    ///   - [`engine(Option<String>)`](crate::output::CreateUserGroupOutput::engine): <p>The current supported value is Redis. </p>
    ///   - [`user_ids(Option<Vec<String>>)`](crate::output::CreateUserGroupOutput::user_ids): <p>The list of user IDs that belong to the user group.</p>
    ///   - [`minimum_engine_version(Option<String>)`](crate::output::CreateUserGroupOutput::minimum_engine_version): <p>The minimum engine version required, which is Redis 6.0</p>
    ///   - [`pending_changes(Option<UserGroupPendingChanges>)`](crate::output::CreateUserGroupOutput::pending_changes): <p>A list of updates being applied to the user group.</p>
    ///   - [`replication_groups(Option<Vec<String>>)`](crate::output::CreateUserGroupOutput::replication_groups): <p>A list of replication groups that the user group can access.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateUserGroupOutput::arn): <p>The Amazon Resource Name (ARN) of the user group.</p>
    /// - On failure, responds with [`SdkError<CreateUserGroupError>`](crate::error::CreateUserGroupError)
    pub fn create_user_group(&self) -> fluent_builders::CreateUserGroup {
        fluent_builders::CreateUserGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DecreaseNodeGroupsInGlobalReplicationGroup`](crate::client::fluent_builders::DecreaseNodeGroupsInGlobalReplicationGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_replication_group_id(impl Into<String>)`](crate::client::fluent_builders::DecreaseNodeGroupsInGlobalReplicationGroup::global_replication_group_id) / [`set_global_replication_group_id(Option<String>)`](crate::client::fluent_builders::DecreaseNodeGroupsInGlobalReplicationGroup::set_global_replication_group_id): <p>The name of the Global datastore</p>
    ///   - [`node_group_count(i32)`](crate::client::fluent_builders::DecreaseNodeGroupsInGlobalReplicationGroup::node_group_count) / [`set_node_group_count(i32)`](crate::client::fluent_builders::DecreaseNodeGroupsInGlobalReplicationGroup::set_node_group_count): <p>The number of node groups (shards) that results from the modification of the shard configuration</p>
    ///   - [`global_node_groups_to_remove(Vec<String>)`](crate::client::fluent_builders::DecreaseNodeGroupsInGlobalReplicationGroup::global_node_groups_to_remove) / [`set_global_node_groups_to_remove(Option<Vec<String>>)`](crate::client::fluent_builders::DecreaseNodeGroupsInGlobalReplicationGroup::set_global_node_groups_to_remove): <p>If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. GlobalNodeGroupsToRemove is a list of NodeGroupIds to remove from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by GlobalNodeGroupsToRemove from the cluster. </p>
    ///   - [`global_node_groups_to_retain(Vec<String>)`](crate::client::fluent_builders::DecreaseNodeGroupsInGlobalReplicationGroup::global_node_groups_to_retain) / [`set_global_node_groups_to_retain(Option<Vec<String>>)`](crate::client::fluent_builders::DecreaseNodeGroupsInGlobalReplicationGroup::set_global_node_groups_to_retain): <p>If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. GlobalNodeGroupsToRetain is a list of NodeGroupIds to retain from the cluster. ElastiCache for Redis will attempt to retain all node groups listed by GlobalNodeGroupsToRetain from the cluster. </p>
    ///   - [`apply_immediately(bool)`](crate::client::fluent_builders::DecreaseNodeGroupsInGlobalReplicationGroup::apply_immediately) / [`set_apply_immediately(bool)`](crate::client::fluent_builders::DecreaseNodeGroupsInGlobalReplicationGroup::set_apply_immediately): <p>Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for this parameter is true. </p>
    /// - On success, responds with [`DecreaseNodeGroupsInGlobalReplicationGroupOutput`](crate::output::DecreaseNodeGroupsInGlobalReplicationGroupOutput) with field(s):
    ///   - [`global_replication_group(Option<GlobalReplicationGroup>)`](crate::output::DecreaseNodeGroupsInGlobalReplicationGroupOutput::global_replication_group): <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary cluster automatically replicates updates to the secondary cluster.</p>  <ul>   <li> <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore, which is what you use to associate a secondary cluster.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<DecreaseNodeGroupsInGlobalReplicationGroupError>`](crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError)
    pub fn decrease_node_groups_in_global_replication_group(
        &self,
    ) -> fluent_builders::DecreaseNodeGroupsInGlobalReplicationGroup {
        fluent_builders::DecreaseNodeGroupsInGlobalReplicationGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DecreaseReplicaCount`](crate::client::fluent_builders::DecreaseReplicaCount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_group_id(impl Into<String>)`](crate::client::fluent_builders::DecreaseReplicaCount::replication_group_id) / [`set_replication_group_id(Option<String>)`](crate::client::fluent_builders::DecreaseReplicaCount::set_replication_group_id): <p>The id of the replication group from which you want to remove replica nodes.</p>
    ///   - [`new_replica_count(i32)`](crate::client::fluent_builders::DecreaseReplicaCount::new_replica_count) / [`set_new_replica_count(Option<i32>)`](crate::client::fluent_builders::DecreaseReplicaCount::set_new_replica_count): <p>The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups.</p>  <p>The minimum number of replicas in a shard or replication group is:</p>  <ul>   <li> <p>Redis (cluster mode disabled)</p>    <ul>     <li> <p>If Multi-AZ is enabled: 1</p> </li>     <li> <p>If Multi-AZ is not enabled: 0</p> </li>    </ul> </li>   <li> <p>Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)</p> </li>  </ul>
    ///   - [`replica_configuration(Vec<ConfigureShard>)`](crate::client::fluent_builders::DecreaseReplicaCount::replica_configuration) / [`set_replica_configuration(Option<Vec<ConfigureShard>>)`](crate::client::fluent_builders::DecreaseReplicaCount::set_replica_configuration): <p>A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members: <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.</p>
    ///   - [`replicas_to_remove(Vec<String>)`](crate::client::fluent_builders::DecreaseReplicaCount::replicas_to_remove) / [`set_replicas_to_remove(Option<Vec<String>>)`](crate::client::fluent_builders::DecreaseReplicaCount::set_replicas_to_remove): <p>A list of the node ids to remove from the replication group or node group (shard).</p>
    ///   - [`apply_immediately(bool)`](crate::client::fluent_builders::DecreaseReplicaCount::apply_immediately) / [`set_apply_immediately(bool)`](crate::client::fluent_builders::DecreaseReplicaCount::set_apply_immediately): <p>If <code>True</code>, the number of replica nodes is decreased immediately. <code>ApplyImmediately=False</code> is not currently supported.</p>
    /// - On success, responds with [`DecreaseReplicaCountOutput`](crate::output::DecreaseReplicaCountOutput) with field(s):
    ///   - [`replication_group(Option<ReplicationGroup>)`](crate::output::DecreaseReplicaCountOutput::replication_group): <p>Contains all of the attributes of a specific Redis replication group.</p>
    /// - On failure, responds with [`SdkError<DecreaseReplicaCountError>`](crate::error::DecreaseReplicaCountError)
    pub fn decrease_replica_count(&self) -> fluent_builders::DecreaseReplicaCount {
        fluent_builders::DecreaseReplicaCount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCacheCluster`](crate::client::fluent_builders::DeleteCacheCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_cluster_id(impl Into<String>)`](crate::client::fluent_builders::DeleteCacheCluster::cache_cluster_id) / [`set_cache_cluster_id(Option<String>)`](crate::client::fluent_builders::DeleteCacheCluster::set_cache_cluster_id): <p>The cluster identifier for the cluster to be deleted. This parameter is not case sensitive.</p>
    ///   - [`final_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteCacheCluster::final_snapshot_identifier) / [`set_final_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DeleteCacheCluster::set_final_snapshot_identifier): <p>The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. ElastiCache creates the snapshot, and then deletes the cluster immediately afterward.</p>
    /// - On success, responds with [`DeleteCacheClusterOutput`](crate::output::DeleteCacheClusterOutput) with field(s):
    ///   - [`cache_cluster(Option<CacheCluster>)`](crate::output::DeleteCacheClusterOutput::cache_cluster): <p>Contains all of the attributes of a specific cluster.</p>
    /// - On failure, responds with [`SdkError<DeleteCacheClusterError>`](crate::error::DeleteCacheClusterError)
    pub fn delete_cache_cluster(&self) -> fluent_builders::DeleteCacheCluster {
        fluent_builders::DeleteCacheCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCacheParameterGroup`](crate::client::fluent_builders::DeleteCacheParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteCacheParameterGroup::cache_parameter_group_name) / [`set_cache_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DeleteCacheParameterGroup::set_cache_parameter_group_name): <p>The name of the cache parameter group to delete.</p> <note>   <p>The specified cache security group must not be associated with any clusters.</p>  </note>
    /// - On success, responds with [`DeleteCacheParameterGroupOutput`](crate::output::DeleteCacheParameterGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteCacheParameterGroupError>`](crate::error::DeleteCacheParameterGroupError)
    pub fn delete_cache_parameter_group(&self) -> fluent_builders::DeleteCacheParameterGroup {
        fluent_builders::DeleteCacheParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCacheSecurityGroup`](crate::client::fluent_builders::DeleteCacheSecurityGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_security_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteCacheSecurityGroup::cache_security_group_name) / [`set_cache_security_group_name(Option<String>)`](crate::client::fluent_builders::DeleteCacheSecurityGroup::set_cache_security_group_name): <p>The name of the cache security group to delete.</p> <note>   <p>You cannot delete the default security group.</p>  </note>
    /// - On success, responds with [`DeleteCacheSecurityGroupOutput`](crate::output::DeleteCacheSecurityGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteCacheSecurityGroupError>`](crate::error::DeleteCacheSecurityGroupError)
    pub fn delete_cache_security_group(&self) -> fluent_builders::DeleteCacheSecurityGroup {
        fluent_builders::DeleteCacheSecurityGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCacheSubnetGroup`](crate::client::fluent_builders::DeleteCacheSubnetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteCacheSubnetGroup::cache_subnet_group_name) / [`set_cache_subnet_group_name(Option<String>)`](crate::client::fluent_builders::DeleteCacheSubnetGroup::set_cache_subnet_group_name): <p>The name of the cache subnet group to delete.</p>  <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>
    /// - On success, responds with [`DeleteCacheSubnetGroupOutput`](crate::output::DeleteCacheSubnetGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteCacheSubnetGroupError>`](crate::error::DeleteCacheSubnetGroupError)
    pub fn delete_cache_subnet_group(&self) -> fluent_builders::DeleteCacheSubnetGroup {
        fluent_builders::DeleteCacheSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGlobalReplicationGroup`](crate::client::fluent_builders::DeleteGlobalReplicationGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_replication_group_id(impl Into<String>)`](crate::client::fluent_builders::DeleteGlobalReplicationGroup::global_replication_group_id) / [`set_global_replication_group_id(Option<String>)`](crate::client::fluent_builders::DeleteGlobalReplicationGroup::set_global_replication_group_id): <p>The name of the Global datastore</p>
    ///   - [`retain_primary_replication_group(bool)`](crate::client::fluent_builders::DeleteGlobalReplicationGroup::retain_primary_replication_group) / [`set_retain_primary_replication_group(bool)`](crate::client::fluent_builders::DeleteGlobalReplicationGroup::set_retain_primary_replication_group): <p>The primary replication group is retained as a standalone replication group. </p>
    /// - On success, responds with [`DeleteGlobalReplicationGroupOutput`](crate::output::DeleteGlobalReplicationGroupOutput) with field(s):
    ///   - [`global_replication_group(Option<GlobalReplicationGroup>)`](crate::output::DeleteGlobalReplicationGroupOutput::global_replication_group): <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary cluster automatically replicates updates to the secondary cluster.</p>  <ul>   <li> <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore, which is what you use to associate a secondary cluster.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<DeleteGlobalReplicationGroupError>`](crate::error::DeleteGlobalReplicationGroupError)
    pub fn delete_global_replication_group(&self) -> fluent_builders::DeleteGlobalReplicationGroup {
        fluent_builders::DeleteGlobalReplicationGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteReplicationGroup`](crate::client::fluent_builders::DeleteReplicationGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_group_id(impl Into<String>)`](crate::client::fluent_builders::DeleteReplicationGroup::replication_group_id) / [`set_replication_group_id(Option<String>)`](crate::client::fluent_builders::DeleteReplicationGroup::set_replication_group_id): <p>The identifier for the cluster to be deleted. This parameter is not case sensitive.</p>
    ///   - [`retain_primary_cluster(bool)`](crate::client::fluent_builders::DeleteReplicationGroup::retain_primary_cluster) / [`set_retain_primary_cluster(Option<bool>)`](crate::client::fluent_builders::DeleteReplicationGroup::set_retain_primary_cluster): <p>If set to <code>true</code>, all of the read replicas are deleted, but the primary node is retained.</p>
    ///   - [`final_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteReplicationGroup::final_snapshot_identifier) / [`set_final_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DeleteReplicationGroup::set_final_snapshot_identifier): <p>The name of a final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster, rather than one of the replicas; this is to ensure that it captures the freshest data. After the final snapshot is taken, the replication group is immediately deleted.</p>
    /// - On success, responds with [`DeleteReplicationGroupOutput`](crate::output::DeleteReplicationGroupOutput) with field(s):
    ///   - [`replication_group(Option<ReplicationGroup>)`](crate::output::DeleteReplicationGroupOutput::replication_group): <p>Contains all of the attributes of a specific Redis replication group.</p>
    /// - On failure, responds with [`SdkError<DeleteReplicationGroupError>`](crate::error::DeleteReplicationGroupError)
    pub fn delete_replication_group(&self) -> fluent_builders::DeleteReplicationGroup {
        fluent_builders::DeleteReplicationGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSnapshot`](crate::client::fluent_builders::DeleteSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`snapshot_name(impl Into<String>)`](crate::client::fluent_builders::DeleteSnapshot::snapshot_name) / [`set_snapshot_name(Option<String>)`](crate::client::fluent_builders::DeleteSnapshot::set_snapshot_name): <p>The name of the snapshot to be deleted.</p>
    /// - On success, responds with [`DeleteSnapshotOutput`](crate::output::DeleteSnapshotOutput) with field(s):
    ///   - [`snapshot(Option<Snapshot>)`](crate::output::DeleteSnapshotOutput::snapshot): <p>Represents a copy of an entire Redis cluster as of the time when the snapshot was taken.</p>
    /// - On failure, responds with [`SdkError<DeleteSnapshotError>`](crate::error::DeleteSnapshotError)
    pub fn delete_snapshot(&self) -> fluent_builders::DeleteSnapshot {
        fluent_builders::DeleteSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUser`](crate::client::fluent_builders::DeleteUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUser::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::DeleteUser::set_user_id): <p>The ID of the user.</p>
    /// - On success, responds with [`DeleteUserOutput`](crate::output::DeleteUserOutput) with field(s):
    ///   - [`user_id(Option<String>)`](crate::output::DeleteUserOutput::user_id): <p>The ID of the user.</p>
    ///   - [`user_name(Option<String>)`](crate::output::DeleteUserOutput::user_name): <p>The username of the user.</p>
    ///   - [`status(Option<String>)`](crate::output::DeleteUserOutput::status): <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
    ///   - [`engine(Option<String>)`](crate::output::DeleteUserOutput::engine): <p>The current supported value is Redis.</p>
    ///   - [`minimum_engine_version(Option<String>)`](crate::output::DeleteUserOutput::minimum_engine_version): <p>The minimum engine version required, which is Redis 6.0</p>
    ///   - [`access_string(Option<String>)`](crate::output::DeleteUserOutput::access_string): <p>Access permissions string used for this user.</p>
    ///   - [`user_group_ids(Option<Vec<String>>)`](crate::output::DeleteUserOutput::user_group_ids): <p>Returns a list of the user group IDs the user belongs to.</p>
    ///   - [`authentication(Option<Authentication>)`](crate::output::DeleteUserOutput::authentication): <p>Denotes whether the user requires a password to authenticate.</p>
    ///   - [`arn(Option<String>)`](crate::output::DeleteUserOutput::arn): <p>The Amazon Resource Name (ARN) of the user.</p>
    /// - On failure, responds with [`SdkError<DeleteUserError>`](crate::error::DeleteUserError)
    pub fn delete_user(&self) -> fluent_builders::DeleteUser {
        fluent_builders::DeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUserGroup`](crate::client::fluent_builders::DeleteUserGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_group_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUserGroup::user_group_id) / [`set_user_group_id(Option<String>)`](crate::client::fluent_builders::DeleteUserGroup::set_user_group_id): <p>The ID of the user group.</p>
    /// - On success, responds with [`DeleteUserGroupOutput`](crate::output::DeleteUserGroupOutput) with field(s):
    ///   - [`user_group_id(Option<String>)`](crate::output::DeleteUserGroupOutput::user_group_id): <p>The ID of the user group.</p>
    ///   - [`status(Option<String>)`](crate::output::DeleteUserGroupOutput::status): <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
    ///   - [`engine(Option<String>)`](crate::output::DeleteUserGroupOutput::engine): <p>The current supported value is Redis. </p>
    ///   - [`user_ids(Option<Vec<String>>)`](crate::output::DeleteUserGroupOutput::user_ids): <p>The list of user IDs that belong to the user group.</p>
    ///   - [`minimum_engine_version(Option<String>)`](crate::output::DeleteUserGroupOutput::minimum_engine_version): <p>The minimum engine version required, which is Redis 6.0</p>
    ///   - [`pending_changes(Option<UserGroupPendingChanges>)`](crate::output::DeleteUserGroupOutput::pending_changes): <p>A list of updates being applied to the user group.</p>
    ///   - [`replication_groups(Option<Vec<String>>)`](crate::output::DeleteUserGroupOutput::replication_groups): <p>A list of replication groups that the user group can access.</p>
    ///   - [`arn(Option<String>)`](crate::output::DeleteUserGroupOutput::arn): <p>The Amazon Resource Name (ARN) of the user group.</p>
    /// - On failure, responds with [`SdkError<DeleteUserGroupError>`](crate::error::DeleteUserGroupError)
    pub fn delete_user_group(&self) -> fluent_builders::DeleteUserGroup {
        fluent_builders::DeleteUserGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCacheClusters`](crate::client::fluent_builders::DescribeCacheClusters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeCacheClusters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_cluster_id(impl Into<String>)`](crate::client::fluent_builders::DescribeCacheClusters::cache_cluster_id) / [`set_cache_cluster_id(Option<String>)`](crate::client::fluent_builders::DescribeCacheClusters::set_cache_cluster_id): <p>The user-supplied cluster identifier. If this parameter is specified, only information about that specific cluster is returned. This parameter isn't case sensitive.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeCacheClusters::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeCacheClusters::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: minimum 20; maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeCacheClusters::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeCacheClusters::set_marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`show_cache_node_info(bool)`](crate::client::fluent_builders::DescribeCacheClusters::show_cache_node_info) / [`set_show_cache_node_info(Option<bool>)`](crate::client::fluent_builders::DescribeCacheClusters::set_show_cache_node_info): <p>An optional flag that can be included in the <code>DescribeCacheCluster</code> request to retrieve information about the individual cache nodes.</p>
    ///   - [`show_cache_clusters_not_in_replication_groups(bool)`](crate::client::fluent_builders::DescribeCacheClusters::show_cache_clusters_not_in_replication_groups) / [`set_show_cache_clusters_not_in_replication_groups(Option<bool>)`](crate::client::fluent_builders::DescribeCacheClusters::set_show_cache_clusters_not_in_replication_groups): <p>An optional flag that can be included in the <code>DescribeCacheCluster</code> request to show only nodes (API/CLI: clusters) that are not members of a replication group. In practice, this mean Memcached and single node Redis clusters.</p>
    /// - On success, responds with [`DescribeCacheClustersOutput`](crate::output::DescribeCacheClustersOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeCacheClustersOutput::marker): <p>Provides an identifier to allow retrieval of paginated results.</p>
    ///   - [`cache_clusters(Option<Vec<CacheCluster>>)`](crate::output::DescribeCacheClustersOutput::cache_clusters): <p>A list of clusters. Each item in the list contains detailed information about one cluster.</p>
    /// - On failure, responds with [`SdkError<DescribeCacheClustersError>`](crate::error::DescribeCacheClustersError)
    pub fn describe_cache_clusters(&self) -> fluent_builders::DescribeCacheClusters {
        fluent_builders::DescribeCacheClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCacheEngineVersions`](crate::client::fluent_builders::DescribeCacheEngineVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeCacheEngineVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::DescribeCacheEngineVersions::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::DescribeCacheEngineVersions::set_engine): <p>The cache engine to return. Valid values: <code>memcached</code> | <code>redis</code> </p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::DescribeCacheEngineVersions::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::DescribeCacheEngineVersions::set_engine_version): <p>The cache engine version to return.</p>  <p>Example: <code>1.4.14</code> </p>
    ///   - [`cache_parameter_group_family(impl Into<String>)`](crate::client::fluent_builders::DescribeCacheEngineVersions::cache_parameter_group_family) / [`set_cache_parameter_group_family(Option<String>)`](crate::client::fluent_builders::DescribeCacheEngineVersions::set_cache_parameter_group_family): <p>The name of a specific cache parameter group family to return details for.</p>  <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis6.2</code> </p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 alphanumeric characters</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeCacheEngineVersions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeCacheEngineVersions::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: minimum 20; maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeCacheEngineVersions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeCacheEngineVersions::set_marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`default_only(bool)`](crate::client::fluent_builders::DescribeCacheEngineVersions::default_only) / [`set_default_only(bool)`](crate::client::fluent_builders::DescribeCacheEngineVersions::set_default_only): <p>If <code>true</code>, specifies that only the default version of the specified engine or engine and major version combination is to be returned.</p>
    /// - On success, responds with [`DescribeCacheEngineVersionsOutput`](crate::output::DescribeCacheEngineVersionsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeCacheEngineVersionsOutput::marker): <p>Provides an identifier to allow retrieval of paginated results.</p>
    ///   - [`cache_engine_versions(Option<Vec<CacheEngineVersion>>)`](crate::output::DescribeCacheEngineVersionsOutput::cache_engine_versions): <p>A list of cache engine version details. Each element in the list contains detailed information about one cache engine version.</p>
    /// - On failure, responds with [`SdkError<DescribeCacheEngineVersionsError>`](crate::error::DescribeCacheEngineVersionsError)
    pub fn describe_cache_engine_versions(&self) -> fluent_builders::DescribeCacheEngineVersions {
        fluent_builders::DescribeCacheEngineVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCacheParameterGroups`](crate::client::fluent_builders::DescribeCacheParameterGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeCacheParameterGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeCacheParameterGroups::cache_parameter_group_name) / [`set_cache_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DescribeCacheParameterGroups::set_cache_parameter_group_name): <p>The name of a specific cache parameter group to return details for.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeCacheParameterGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeCacheParameterGroups::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: minimum 20; maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeCacheParameterGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeCacheParameterGroups::set_marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeCacheParameterGroupsOutput`](crate::output::DescribeCacheParameterGroupsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeCacheParameterGroupsOutput::marker): <p>Provides an identifier to allow retrieval of paginated results.</p>
    ///   - [`cache_parameter_groups(Option<Vec<CacheParameterGroup>>)`](crate::output::DescribeCacheParameterGroupsOutput::cache_parameter_groups): <p>A list of cache parameter groups. Each element in the list contains detailed information about one cache parameter group.</p>
    /// - On failure, responds with [`SdkError<DescribeCacheParameterGroupsError>`](crate::error::DescribeCacheParameterGroupsError)
    pub fn describe_cache_parameter_groups(&self) -> fluent_builders::DescribeCacheParameterGroups {
        fluent_builders::DescribeCacheParameterGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCacheParameters`](crate::client::fluent_builders::DescribeCacheParameters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeCacheParameters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeCacheParameters::cache_parameter_group_name) / [`set_cache_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DescribeCacheParameters::set_cache_parameter_group_name): <p>The name of a specific cache parameter group to return details for.</p>
    ///   - [`source(impl Into<String>)`](crate::client::fluent_builders::DescribeCacheParameters::source) / [`set_source(Option<String>)`](crate::client::fluent_builders::DescribeCacheParameters::set_source): <p>The parameter types to return.</p>  <p>Valid values: <code>user</code> | <code>system</code> | <code>engine-default</code> </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeCacheParameters::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeCacheParameters::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: minimum 20; maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeCacheParameters::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeCacheParameters::set_marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeCacheParametersOutput`](crate::output::DescribeCacheParametersOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeCacheParametersOutput::marker): <p>Provides an identifier to allow retrieval of paginated results.</p>
    ///   - [`parameters(Option<Vec<Parameter>>)`](crate::output::DescribeCacheParametersOutput::parameters): <p>A list of <code>Parameter</code> instances.</p>
    ///   - [`cache_node_type_specific_parameters(Option<Vec<CacheNodeTypeSpecificParameter>>)`](crate::output::DescribeCacheParametersOutput::cache_node_type_specific_parameters): <p>A list of parameters specific to a particular cache node type. Each element in the list contains detailed information about one parameter.</p>
    /// - On failure, responds with [`SdkError<DescribeCacheParametersError>`](crate::error::DescribeCacheParametersError)
    pub fn describe_cache_parameters(&self) -> fluent_builders::DescribeCacheParameters {
        fluent_builders::DescribeCacheParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCacheSecurityGroups`](crate::client::fluent_builders::DescribeCacheSecurityGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeCacheSecurityGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_security_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeCacheSecurityGroups::cache_security_group_name) / [`set_cache_security_group_name(Option<String>)`](crate::client::fluent_builders::DescribeCacheSecurityGroups::set_cache_security_group_name): <p>The name of the cache security group to return details for.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeCacheSecurityGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeCacheSecurityGroups::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: minimum 20; maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeCacheSecurityGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeCacheSecurityGroups::set_marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeCacheSecurityGroupsOutput`](crate::output::DescribeCacheSecurityGroupsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeCacheSecurityGroupsOutput::marker): <p>Provides an identifier to allow retrieval of paginated results.</p>
    ///   - [`cache_security_groups(Option<Vec<CacheSecurityGroup>>)`](crate::output::DescribeCacheSecurityGroupsOutput::cache_security_groups): <p>A list of cache security groups. Each element in the list contains detailed information about one group.</p>
    /// - On failure, responds with [`SdkError<DescribeCacheSecurityGroupsError>`](crate::error::DescribeCacheSecurityGroupsError)
    pub fn describe_cache_security_groups(&self) -> fluent_builders::DescribeCacheSecurityGroups {
        fluent_builders::DescribeCacheSecurityGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCacheSubnetGroups`](crate::client::fluent_builders::DescribeCacheSubnetGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeCacheSubnetGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeCacheSubnetGroups::cache_subnet_group_name) / [`set_cache_subnet_group_name(Option<String>)`](crate::client::fluent_builders::DescribeCacheSubnetGroups::set_cache_subnet_group_name): <p>The name of the cache subnet group to return details for.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeCacheSubnetGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeCacheSubnetGroups::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: minimum 20; maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeCacheSubnetGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeCacheSubnetGroups::set_marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeCacheSubnetGroupsOutput`](crate::output::DescribeCacheSubnetGroupsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeCacheSubnetGroupsOutput::marker): <p>Provides an identifier to allow retrieval of paginated results.</p>
    ///   - [`cache_subnet_groups(Option<Vec<CacheSubnetGroup>>)`](crate::output::DescribeCacheSubnetGroupsOutput::cache_subnet_groups): <p>A list of cache subnet groups. Each element in the list contains detailed information about one group.</p>
    /// - On failure, responds with [`SdkError<DescribeCacheSubnetGroupsError>`](crate::error::DescribeCacheSubnetGroupsError)
    pub fn describe_cache_subnet_groups(&self) -> fluent_builders::DescribeCacheSubnetGroups {
        fluent_builders::DescribeCacheSubnetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEngineDefaultParameters`](crate::client::fluent_builders::DescribeEngineDefaultParameters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEngineDefaultParameters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_parameter_group_family(impl Into<String>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::cache_parameter_group_family) / [`set_cache_parameter_group_family(Option<String>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::set_cache_parameter_group_family): <p>The name of the cache parameter group family.</p>  <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis6.2</code> </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: minimum 20; maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::set_marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeEngineDefaultParametersOutput`](crate::output::DescribeEngineDefaultParametersOutput) with field(s):
    ///   - [`engine_defaults(Option<EngineDefaults>)`](crate::output::DescribeEngineDefaultParametersOutput::engine_defaults): <p>Represents the output of a <code>DescribeEngineDefaultParameters</code> operation.</p>
    /// - On failure, responds with [`SdkError<DescribeEngineDefaultParametersError>`](crate::error::DescribeEngineDefaultParametersError)
    pub fn describe_engine_default_parameters(
        &self,
    ) -> fluent_builders::DescribeEngineDefaultParameters {
        fluent_builders::DescribeEngineDefaultParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEvents`](crate::client::fluent_builders::DescribeEvents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEvents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::source_identifier) / [`set_source_identifier(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_source_identifier): <p>The identifier of the event source for which events are returned. If not specified, all sources are included in the response.</p>
    ///   - [`source_type(SourceType)`](crate::client::fluent_builders::DescribeEvents::source_type) / [`set_source_type(Option<SourceType>)`](crate::client::fluent_builders::DescribeEvents::set_source_type): <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::DescribeEvents::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeEvents::set_start_time): <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format.</p>  <p> <b>Example:</b> 2017-03-30T07:03:49.555Z</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::DescribeEvents::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeEvents::set_end_time): <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format.</p>  <p> <b>Example:</b> 2017-03-30T07:03:49.555Z</p>
    ///   - [`duration(i32)`](crate::client::fluent_builders::DescribeEvents::duration) / [`set_duration(Option<i32>)`](crate::client::fluent_builders::DescribeEvents::set_duration): <p>The number of minutes worth of events to retrieve.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEvents::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEvents::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: minimum 20; maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeEventsOutput`](crate::output::DescribeEventsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeEventsOutput::marker): <p>Provides an identifier to allow retrieval of paginated results.</p>
    ///   - [`events(Option<Vec<Event>>)`](crate::output::DescribeEventsOutput::events): <p>A list of events. Each element in the list contains detailed information about one event.</p>
    /// - On failure, responds with [`SdkError<DescribeEventsError>`](crate::error::DescribeEventsError)
    pub fn describe_events(&self) -> fluent_builders::DescribeEvents {
        fluent_builders::DescribeEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeGlobalReplicationGroups`](crate::client::fluent_builders::DescribeGlobalReplicationGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeGlobalReplicationGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_replication_group_id(impl Into<String>)`](crate::client::fluent_builders::DescribeGlobalReplicationGroups::global_replication_group_id) / [`set_global_replication_group_id(Option<String>)`](crate::client::fluent_builders::DescribeGlobalReplicationGroups::set_global_replication_group_id): <p>The name of the Global datastore</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeGlobalReplicationGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeGlobalReplicationGroups::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeGlobalReplicationGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeGlobalReplicationGroups::set_marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
    ///   - [`show_member_info(bool)`](crate::client::fluent_builders::DescribeGlobalReplicationGroups::show_member_info) / [`set_show_member_info(Option<bool>)`](crate::client::fluent_builders::DescribeGlobalReplicationGroups::set_show_member_info): <p>Returns the list of members that comprise the Global datastore.</p>
    /// - On success, responds with [`DescribeGlobalReplicationGroupsOutput`](crate::output::DescribeGlobalReplicationGroupsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeGlobalReplicationGroupsOutput::marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>
    ///   - [`global_replication_groups(Option<Vec<GlobalReplicationGroup>>)`](crate::output::DescribeGlobalReplicationGroupsOutput::global_replication_groups): <p>Indicates the slot configuration and global identifier for each slice group.</p>
    /// - On failure, responds with [`SdkError<DescribeGlobalReplicationGroupsError>`](crate::error::DescribeGlobalReplicationGroupsError)
    pub fn describe_global_replication_groups(
        &self,
    ) -> fluent_builders::DescribeGlobalReplicationGroups {
        fluent_builders::DescribeGlobalReplicationGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReplicationGroups`](crate::client::fluent_builders::DescribeReplicationGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReplicationGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_group_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReplicationGroups::replication_group_id) / [`set_replication_group_id(Option<String>)`](crate::client::fluent_builders::DescribeReplicationGroups::set_replication_group_id): <p>The identifier for the replication group to be described. This parameter is not case sensitive.</p>  <p>If you do not specify this parameter, information about all replication groups is returned.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeReplicationGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeReplicationGroups::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: minimum 20; maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeReplicationGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeReplicationGroups::set_marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeReplicationGroupsOutput`](crate::output::DescribeReplicationGroupsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeReplicationGroupsOutput::marker): <p>Provides an identifier to allow retrieval of paginated results.</p>
    ///   - [`replication_groups(Option<Vec<ReplicationGroup>>)`](crate::output::DescribeReplicationGroupsOutput::replication_groups): <p>A list of replication groups. Each item in the list contains detailed information about one replication group.</p>
    /// - On failure, responds with [`SdkError<DescribeReplicationGroupsError>`](crate::error::DescribeReplicationGroupsError)
    pub fn describe_replication_groups(&self) -> fluent_builders::DescribeReplicationGroups {
        fluent_builders::DescribeReplicationGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReservedCacheNodes`](crate::client::fluent_builders::DescribeReservedCacheNodes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReservedCacheNodes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_cache_node_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodes::reserved_cache_node_id) / [`set_reserved_cache_node_id(Option<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodes::set_reserved_cache_node_id): <p>The reserved cache node identifier filter value. Use this parameter to show only the reservation that matches the specified reservation ID.</p>
    ///   - [`reserved_cache_nodes_offering_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodes::reserved_cache_nodes_offering_id) / [`set_reserved_cache_nodes_offering_id(Option<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodes::set_reserved_cache_nodes_offering_id): <p>The offering identifier filter value. Use this parameter to show only purchased reservations matching the specified offering identifier.</p>
    ///   - [`cache_node_type(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodes::cache_node_type) / [`set_cache_node_type(Option<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodes::set_cache_node_type): <p>The cache node type filter value. Use this parameter to show only those reservations matching the specified cache node type.</p>  <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>  <ul>   <li> <p>General purpose:</p>    <ul>     <li> <p>Current generation: </p> <p> <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>       <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>      </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>     <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>    </ul> </li>   <li> <p>Compute optimized:</p>    <ul>     <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>    </ul> </li>   <li> <p>Memory optimized with data tiering:</p>    <ul>     <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>    </ul> </li>   <li> <p>Memory optimized:</p>    <ul>     <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>       <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>      </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>     <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>    </ul> </li>  </ul>  <p> <b>Additional node type info</b> </p>  <ul>   <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>   <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>   <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>   <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>  </ul>
    ///   - [`duration(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodes::duration) / [`set_duration(Option<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodes::set_duration): <p>The duration filter value, specified in years or seconds. Use this parameter to show only reservations for this duration.</p>  <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>
    ///   - [`product_description(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodes::product_description) / [`set_product_description(Option<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodes::set_product_description): <p>The product description filter value. Use this parameter to show only those reservations matching the specified product description.</p>
    ///   - [`offering_type(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodes::offering_type) / [`set_offering_type(Option<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodes::set_offering_type): <p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type.</p>  <p>Valid values: <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization"|"All Upfront"|"Partial Upfront"| "No Upfront"</code> </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeReservedCacheNodes::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeReservedCacheNodes::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: minimum 20; maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodes::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodes::set_marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeReservedCacheNodesOutput`](crate::output::DescribeReservedCacheNodesOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeReservedCacheNodesOutput::marker): <p>Provides an identifier to allow retrieval of paginated results.</p>
    ///   - [`reserved_cache_nodes(Option<Vec<ReservedCacheNode>>)`](crate::output::DescribeReservedCacheNodesOutput::reserved_cache_nodes): <p>A list of reserved cache nodes. Each element in the list contains detailed information about one node.</p>
    /// - On failure, responds with [`SdkError<DescribeReservedCacheNodesError>`](crate::error::DescribeReservedCacheNodesError)
    pub fn describe_reserved_cache_nodes(&self) -> fluent_builders::DescribeReservedCacheNodes {
        fluent_builders::DescribeReservedCacheNodes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReservedCacheNodesOfferings`](crate::client::fluent_builders::DescribeReservedCacheNodesOfferings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReservedCacheNodesOfferings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_cache_nodes_offering_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodesOfferings::reserved_cache_nodes_offering_id) / [`set_reserved_cache_nodes_offering_id(Option<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodesOfferings::set_reserved_cache_nodes_offering_id): <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p>  <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>
    ///   - [`cache_node_type(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodesOfferings::cache_node_type) / [`set_cache_node_type(Option<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodesOfferings::set_cache_node_type): <p>The cache node type filter value. Use this parameter to show only the available offerings matching the specified cache node type.</p>  <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>  <ul>   <li> <p>General purpose:</p>    <ul>     <li> <p>Current generation: </p> <p> <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward) <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>       <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>      </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>     <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>    </ul> </li>   <li> <p>Compute optimized:</p>    <ul>     <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>    </ul> </li>   <li> <p>Memory optimized with data tiering:</p>    <ul>     <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>    </ul> </li>   <li> <p>Memory optimized:</p>    <ul>     <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>       <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>      </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>     <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>    </ul> </li>  </ul>  <p> <b>Additional node type info</b> </p>  <ul>   <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>   <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>   <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>   <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>  </ul>
    ///   - [`duration(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodesOfferings::duration) / [`set_duration(Option<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodesOfferings::set_duration): <p>Duration filter value, specified in years or seconds. Use this parameter to show only reservations for a given duration.</p>  <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>
    ///   - [`product_description(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodesOfferings::product_description) / [`set_product_description(Option<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodesOfferings::set_product_description): <p>The product description filter value. Use this parameter to show only the available offerings matching the specified product description.</p>
    ///   - [`offering_type(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodesOfferings::offering_type) / [`set_offering_type(Option<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodesOfferings::set_offering_type): <p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type.</p>  <p>Valid Values: <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization" |"All Upfront"|"Partial Upfront"| "No Upfront"</code> </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeReservedCacheNodesOfferings::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeReservedCacheNodesOfferings::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: minimum 20; maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodesOfferings::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeReservedCacheNodesOfferings::set_marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeReservedCacheNodesOfferingsOutput`](crate::output::DescribeReservedCacheNodesOfferingsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeReservedCacheNodesOfferingsOutput::marker): <p>Provides an identifier to allow retrieval of paginated results.</p>
    ///   - [`reserved_cache_nodes_offerings(Option<Vec<ReservedCacheNodesOffering>>)`](crate::output::DescribeReservedCacheNodesOfferingsOutput::reserved_cache_nodes_offerings): <p>A list of reserved cache node offerings. Each element in the list contains detailed information about one offering.</p>
    /// - On failure, responds with [`SdkError<DescribeReservedCacheNodesOfferingsError>`](crate::error::DescribeReservedCacheNodesOfferingsError)
    pub fn describe_reserved_cache_nodes_offerings(
        &self,
    ) -> fluent_builders::DescribeReservedCacheNodesOfferings {
        fluent_builders::DescribeReservedCacheNodesOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeServiceUpdates`](crate::client::fluent_builders::DescribeServiceUpdates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeServiceUpdates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_update_name(impl Into<String>)`](crate::client::fluent_builders::DescribeServiceUpdates::service_update_name) / [`set_service_update_name(Option<String>)`](crate::client::fluent_builders::DescribeServiceUpdates::set_service_update_name): <p>The unique ID of the service update</p>
    ///   - [`service_update_status(Vec<ServiceUpdateStatus>)`](crate::client::fluent_builders::DescribeServiceUpdates::service_update_status) / [`set_service_update_status(Option<Vec<ServiceUpdateStatus>>)`](crate::client::fluent_builders::DescribeServiceUpdates::set_service_update_status): <p>The status of the service update</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeServiceUpdates::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeServiceUpdates::set_max_records): <p>The maximum number of records to include in the response</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeServiceUpdates::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeServiceUpdates::set_marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeServiceUpdatesOutput`](crate::output::DescribeServiceUpdatesOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeServiceUpdatesOutput::marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`service_updates(Option<Vec<ServiceUpdate>>)`](crate::output::DescribeServiceUpdatesOutput::service_updates): <p>A list of service updates</p>
    /// - On failure, responds with [`SdkError<DescribeServiceUpdatesError>`](crate::error::DescribeServiceUpdatesError)
    pub fn describe_service_updates(&self) -> fluent_builders::DescribeServiceUpdates {
        fluent_builders::DescribeServiceUpdates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSnapshots`](crate::client::fluent_builders::DescribeSnapshots) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSnapshots::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_group_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshots::replication_group_id) / [`set_replication_group_id(Option<String>)`](crate::client::fluent_builders::DescribeSnapshots::set_replication_group_id): <p>A user-supplied replication group identifier. If this parameter is specified, only snapshots associated with that specific replication group are described.</p>
    ///   - [`cache_cluster_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshots::cache_cluster_id) / [`set_cache_cluster_id(Option<String>)`](crate::client::fluent_builders::DescribeSnapshots::set_cache_cluster_id): <p>A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.</p>
    ///   - [`snapshot_name(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshots::snapshot_name) / [`set_snapshot_name(Option<String>)`](crate::client::fluent_builders::DescribeSnapshots::set_snapshot_name): <p>A user-supplied name of the snapshot. If this parameter is specified, only this snapshot are described.</p>
    ///   - [`snapshot_source(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshots::snapshot_source) / [`set_snapshot_source(Option<String>)`](crate::client::fluent_builders::DescribeSnapshots::set_snapshot_source): <p>If set to <code>system</code>, the output shows snapshots that were automatically created by ElastiCache. If set to <code>user</code> the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshots::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeSnapshots::set_marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeSnapshots::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeSnapshots::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 50</p>  <p>Constraints: minimum 20; maximum 50.</p>
    ///   - [`show_node_group_config(bool)`](crate::client::fluent_builders::DescribeSnapshots::show_node_group_config) / [`set_show_node_group_config(Option<bool>)`](crate::client::fluent_builders::DescribeSnapshots::set_show_node_group_config): <p>A Boolean value which if true, the node group (shard) configuration is included in the snapshot description.</p>
    /// - On success, responds with [`DescribeSnapshotsOutput`](crate::output::DescribeSnapshotsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeSnapshotsOutput::marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`snapshots(Option<Vec<Snapshot>>)`](crate::output::DescribeSnapshotsOutput::snapshots): <p>A list of snapshots. Each item in the list contains detailed information about one snapshot.</p>
    /// - On failure, responds with [`SdkError<DescribeSnapshotsError>`](crate::error::DescribeSnapshotsError)
    pub fn describe_snapshots(&self) -> fluent_builders::DescribeSnapshots {
        fluent_builders::DescribeSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUpdateActions`](crate::client::fluent_builders::DescribeUpdateActions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeUpdateActions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`service_update_name(impl Into<String>)`](crate::client::fluent_builders::DescribeUpdateActions::service_update_name) / [`set_service_update_name(Option<String>)`](crate::client::fluent_builders::DescribeUpdateActions::set_service_update_name): <p>The unique ID of the service update</p>
    ///   - [`replication_group_ids(Vec<String>)`](crate::client::fluent_builders::DescribeUpdateActions::replication_group_ids) / [`set_replication_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeUpdateActions::set_replication_group_ids): <p>The replication group IDs</p>
    ///   - [`cache_cluster_ids(Vec<String>)`](crate::client::fluent_builders::DescribeUpdateActions::cache_cluster_ids) / [`set_cache_cluster_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeUpdateActions::set_cache_cluster_ids): <p>The cache cluster IDs</p>
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::DescribeUpdateActions::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::DescribeUpdateActions::set_engine): <p>The Elasticache engine to which the update applies. Either Redis or Memcached </p>
    ///   - [`service_update_status(Vec<ServiceUpdateStatus>)`](crate::client::fluent_builders::DescribeUpdateActions::service_update_status) / [`set_service_update_status(Option<Vec<ServiceUpdateStatus>>)`](crate::client::fluent_builders::DescribeUpdateActions::set_service_update_status): <p>The status of the service update</p>
    ///   - [`service_update_time_range(TimeRangeFilter)`](crate::client::fluent_builders::DescribeUpdateActions::service_update_time_range) / [`set_service_update_time_range(Option<TimeRangeFilter>)`](crate::client::fluent_builders::DescribeUpdateActions::set_service_update_time_range): <p>The range of time specified to search for service updates that are in available status</p>
    ///   - [`update_action_status(Vec<UpdateActionStatus>)`](crate::client::fluent_builders::DescribeUpdateActions::update_action_status) / [`set_update_action_status(Option<Vec<UpdateActionStatus>>)`](crate::client::fluent_builders::DescribeUpdateActions::set_update_action_status): <p>The status of the update action.</p>
    ///   - [`show_node_level_update_status(bool)`](crate::client::fluent_builders::DescribeUpdateActions::show_node_level_update_status) / [`set_show_node_level_update_status(Option<bool>)`](crate::client::fluent_builders::DescribeUpdateActions::set_show_node_level_update_status): <p>Dictates whether to include node level update status in the response </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeUpdateActions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeUpdateActions::set_max_records): <p>The maximum number of records to include in the response</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeUpdateActions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeUpdateActions::set_marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeUpdateActionsOutput`](crate::output::DescribeUpdateActionsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeUpdateActionsOutput::marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`update_actions(Option<Vec<UpdateAction>>)`](crate::output::DescribeUpdateActionsOutput::update_actions): <p>Returns a list of update actions</p>
    /// - On failure, responds with [`SdkError<DescribeUpdateActionsError>`](crate::error::DescribeUpdateActionsError)
    pub fn describe_update_actions(&self) -> fluent_builders::DescribeUpdateActions {
        fluent_builders::DescribeUpdateActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUserGroups`](crate::client::fluent_builders::DescribeUserGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeUserGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_group_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUserGroups::user_group_id) / [`set_user_group_id(Option<String>)`](crate::client::fluent_builders::DescribeUserGroups::set_user_group_id): <p>The ID of the user group.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeUserGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeUserGroups::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeUserGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeUserGroups::set_marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>
    /// - On success, responds with [`DescribeUserGroupsOutput`](crate::output::DescribeUserGroupsOutput) with field(s):
    ///   - [`user_groups(Option<Vec<UserGroup>>)`](crate::output::DescribeUserGroupsOutput::user_groups): <p>Returns a list of user groups.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeUserGroupsOutput::marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>
    /// - On failure, responds with [`SdkError<DescribeUserGroupsError>`](crate::error::DescribeUserGroupsError)
    pub fn describe_user_groups(&self) -> fluent_builders::DescribeUserGroups {
        fluent_builders::DescribeUserGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUsers`](crate::client::fluent_builders::DescribeUsers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeUsers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::DescribeUsers::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::DescribeUsers::set_engine): <p>The Redis engine. </p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUsers::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::DescribeUsers::set_user_id): <p>The ID of the user.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeUsers::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeUsers::set_filters): <p>Filter to determine the list of User IDs to return.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeUsers::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeUsers::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeUsers::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeUsers::set_marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>
    /// - On success, responds with [`DescribeUsersOutput`](crate::output::DescribeUsersOutput) with field(s):
    ///   - [`users(Option<Vec<User>>)`](crate::output::DescribeUsersOutput::users): <p>A list of users.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeUsersOutput::marker): <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>
    /// - On failure, responds with [`SdkError<DescribeUsersError>`](crate::error::DescribeUsersError)
    pub fn describe_users(&self) -> fluent_builders::DescribeUsers {
        fluent_builders::DescribeUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateGlobalReplicationGroup`](crate::client::fluent_builders::DisassociateGlobalReplicationGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_replication_group_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateGlobalReplicationGroup::global_replication_group_id) / [`set_global_replication_group_id(Option<String>)`](crate::client::fluent_builders::DisassociateGlobalReplicationGroup::set_global_replication_group_id): <p>The name of the Global datastore</p>
    ///   - [`replication_group_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateGlobalReplicationGroup::replication_group_id) / [`set_replication_group_id(Option<String>)`](crate::client::fluent_builders::DisassociateGlobalReplicationGroup::set_replication_group_id): <p>The name of the secondary cluster you wish to remove from the Global datastore</p>
    ///   - [`replication_group_region(impl Into<String>)`](crate::client::fluent_builders::DisassociateGlobalReplicationGroup::replication_group_region) / [`set_replication_group_region(Option<String>)`](crate::client::fluent_builders::DisassociateGlobalReplicationGroup::set_replication_group_region): <p>The Amazon region of secondary cluster you wish to remove from the Global datastore</p>
    /// - On success, responds with [`DisassociateGlobalReplicationGroupOutput`](crate::output::DisassociateGlobalReplicationGroupOutput) with field(s):
    ///   - [`global_replication_group(Option<GlobalReplicationGroup>)`](crate::output::DisassociateGlobalReplicationGroupOutput::global_replication_group): <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary cluster automatically replicates updates to the secondary cluster.</p>  <ul>   <li> <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore, which is what you use to associate a secondary cluster.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<DisassociateGlobalReplicationGroupError>`](crate::error::DisassociateGlobalReplicationGroupError)
    pub fn disassociate_global_replication_group(
        &self,
    ) -> fluent_builders::DisassociateGlobalReplicationGroup {
        fluent_builders::DisassociateGlobalReplicationGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`FailoverGlobalReplicationGroup`](crate::client::fluent_builders::FailoverGlobalReplicationGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_replication_group_id(impl Into<String>)`](crate::client::fluent_builders::FailoverGlobalReplicationGroup::global_replication_group_id) / [`set_global_replication_group_id(Option<String>)`](crate::client::fluent_builders::FailoverGlobalReplicationGroup::set_global_replication_group_id): <p>The name of the Global datastore</p>
    ///   - [`primary_region(impl Into<String>)`](crate::client::fluent_builders::FailoverGlobalReplicationGroup::primary_region) / [`set_primary_region(Option<String>)`](crate::client::fluent_builders::FailoverGlobalReplicationGroup::set_primary_region): <p>The Amazon region of the primary cluster of the Global datastore</p>
    ///   - [`primary_replication_group_id(impl Into<String>)`](crate::client::fluent_builders::FailoverGlobalReplicationGroup::primary_replication_group_id) / [`set_primary_replication_group_id(Option<String>)`](crate::client::fluent_builders::FailoverGlobalReplicationGroup::set_primary_replication_group_id): <p>The name of the primary replication group</p>
    /// - On success, responds with [`FailoverGlobalReplicationGroupOutput`](crate::output::FailoverGlobalReplicationGroupOutput) with field(s):
    ///   - [`global_replication_group(Option<GlobalReplicationGroup>)`](crate::output::FailoverGlobalReplicationGroupOutput::global_replication_group): <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary cluster automatically replicates updates to the secondary cluster.</p>  <ul>   <li> <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore, which is what you use to associate a secondary cluster.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<FailoverGlobalReplicationGroupError>`](crate::error::FailoverGlobalReplicationGroupError)
    pub fn failover_global_replication_group(
        &self,
    ) -> fluent_builders::FailoverGlobalReplicationGroup {
        fluent_builders::FailoverGlobalReplicationGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`IncreaseNodeGroupsInGlobalReplicationGroup`](crate::client::fluent_builders::IncreaseNodeGroupsInGlobalReplicationGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_replication_group_id(impl Into<String>)`](crate::client::fluent_builders::IncreaseNodeGroupsInGlobalReplicationGroup::global_replication_group_id) / [`set_global_replication_group_id(Option<String>)`](crate::client::fluent_builders::IncreaseNodeGroupsInGlobalReplicationGroup::set_global_replication_group_id): <p>The name of the Global datastore</p>
    ///   - [`node_group_count(i32)`](crate::client::fluent_builders::IncreaseNodeGroupsInGlobalReplicationGroup::node_group_count) / [`set_node_group_count(i32)`](crate::client::fluent_builders::IncreaseNodeGroupsInGlobalReplicationGroup::set_node_group_count): <p>The number of node groups you wish to add</p>
    ///   - [`regional_configurations(Vec<RegionalConfiguration>)`](crate::client::fluent_builders::IncreaseNodeGroupsInGlobalReplicationGroup::regional_configurations) / [`set_regional_configurations(Option<Vec<RegionalConfiguration>>)`](crate::client::fluent_builders::IncreaseNodeGroupsInGlobalReplicationGroup::set_regional_configurations): <p>Describes the replication group IDs, the Amazon regions where they are stored and the shard configuration for each that comprise the Global datastore</p>
    ///   - [`apply_immediately(bool)`](crate::client::fluent_builders::IncreaseNodeGroupsInGlobalReplicationGroup::apply_immediately) / [`set_apply_immediately(bool)`](crate::client::fluent_builders::IncreaseNodeGroupsInGlobalReplicationGroup::set_apply_immediately): <p>Indicates that the process begins immediately. At present, the only permitted value for this parameter is true.</p>
    /// - On success, responds with [`IncreaseNodeGroupsInGlobalReplicationGroupOutput`](crate::output::IncreaseNodeGroupsInGlobalReplicationGroupOutput) with field(s):
    ///   - [`global_replication_group(Option<GlobalReplicationGroup>)`](crate::output::IncreaseNodeGroupsInGlobalReplicationGroupOutput::global_replication_group): <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary cluster automatically replicates updates to the secondary cluster.</p>  <ul>   <li> <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore, which is what you use to associate a secondary cluster.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<IncreaseNodeGroupsInGlobalReplicationGroupError>`](crate::error::IncreaseNodeGroupsInGlobalReplicationGroupError)
    pub fn increase_node_groups_in_global_replication_group(
        &self,
    ) -> fluent_builders::IncreaseNodeGroupsInGlobalReplicationGroup {
        fluent_builders::IncreaseNodeGroupsInGlobalReplicationGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`IncreaseReplicaCount`](crate::client::fluent_builders::IncreaseReplicaCount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_group_id(impl Into<String>)`](crate::client::fluent_builders::IncreaseReplicaCount::replication_group_id) / [`set_replication_group_id(Option<String>)`](crate::client::fluent_builders::IncreaseReplicaCount::set_replication_group_id): <p>The id of the replication group to which you want to add replica nodes.</p>
    ///   - [`new_replica_count(i32)`](crate::client::fluent_builders::IncreaseReplicaCount::new_replica_count) / [`set_new_replica_count(Option<i32>)`](crate::client::fluent_builders::IncreaseReplicaCount::set_new_replica_count): <p>The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups.</p>
    ///   - [`replica_configuration(Vec<ConfigureShard>)`](crate::client::fluent_builders::IncreaseReplicaCount::replica_configuration) / [`set_replica_configuration(Option<Vec<ConfigureShard>>)`](crate::client::fluent_builders::IncreaseReplicaCount::set_replica_configuration): <p>A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members: <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.</p>
    ///   - [`apply_immediately(bool)`](crate::client::fluent_builders::IncreaseReplicaCount::apply_immediately) / [`set_apply_immediately(bool)`](crate::client::fluent_builders::IncreaseReplicaCount::set_apply_immediately): <p>If <code>True</code>, the number of replica nodes is increased immediately. <code>ApplyImmediately=False</code> is not currently supported.</p>
    /// - On success, responds with [`IncreaseReplicaCountOutput`](crate::output::IncreaseReplicaCountOutput) with field(s):
    ///   - [`replication_group(Option<ReplicationGroup>)`](crate::output::IncreaseReplicaCountOutput::replication_group): <p>Contains all of the attributes of a specific Redis replication group.</p>
    /// - On failure, responds with [`SdkError<IncreaseReplicaCountError>`](crate::error::IncreaseReplicaCountError)
    pub fn increase_replica_count(&self) -> fluent_builders::IncreaseReplicaCount {
        fluent_builders::IncreaseReplicaCount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAllowedNodeTypeModifications`](crate::client::fluent_builders::ListAllowedNodeTypeModifications) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_cluster_id(impl Into<String>)`](crate::client::fluent_builders::ListAllowedNodeTypeModifications::cache_cluster_id) / [`set_cache_cluster_id(Option<String>)`](crate::client::fluent_builders::ListAllowedNodeTypeModifications::set_cache_cluster_id): <p>The name of the cluster you want to scale up to a larger node instanced type. ElastiCache uses the cluster id to identify the current node type of this cluster and from that to create a list of node types you can scale up to.</p> <important>   <p>You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.</p>  </important>
    ///   - [`replication_group_id(impl Into<String>)`](crate::client::fluent_builders::ListAllowedNodeTypeModifications::replication_group_id) / [`set_replication_group_id(Option<String>)`](crate::client::fluent_builders::ListAllowedNodeTypeModifications::set_replication_group_id): <p>The name of the replication group want to scale up to a larger node type. ElastiCache uses the replication group id to identify the current node type being used by this replication group, and from that to create a list of node types you can scale up to.</p> <important>   <p>You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.</p>  </important>
    /// - On success, responds with [`ListAllowedNodeTypeModificationsOutput`](crate::output::ListAllowedNodeTypeModificationsOutput) with field(s):
    ///   - [`scale_up_modifications(Option<Vec<String>>)`](crate::output::ListAllowedNodeTypeModificationsOutput::scale_up_modifications): <p>A string list, each element of which specifies a cache node type which you can use to scale your cluster or replication group.</p>  <p>When scaling up a Redis cluster or replication group using <code>ModifyCacheCluster</code> or <code>ModifyReplicationGroup</code>, use a value from this list for the <code>CacheNodeType</code> parameter.</p>
    ///   - [`scale_down_modifications(Option<Vec<String>>)`](crate::output::ListAllowedNodeTypeModificationsOutput::scale_down_modifications): <p>A string list, each element of which specifies a cache node type which you can use to scale your cluster or replication group. When scaling down a Redis cluster or replication group using ModifyCacheCluster or ModifyReplicationGroup, use a value from this list for the CacheNodeType parameter. </p>
    /// - On failure, responds with [`SdkError<ListAllowedNodeTypeModificationsError>`](crate::error::ListAllowedNodeTypeModificationsError)
    pub fn list_allowed_node_type_modifications(
        &self,
    ) -> fluent_builders::ListAllowedNodeTypeModifications {
        fluent_builders::ListAllowedNodeTypeModifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_name(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_name) / [`set_resource_name(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_name): <p>The Amazon Resource Name (ARN) of the resource for which you want the list of tags, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p>  <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tag_list): <p>A list of tags as key-value pairs.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyCacheCluster`](crate::client::fluent_builders::ModifyCacheCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_cluster_id(impl Into<String>)`](crate::client::fluent_builders::ModifyCacheCluster::cache_cluster_id) / [`set_cache_cluster_id(Option<String>)`](crate::client::fluent_builders::ModifyCacheCluster::set_cache_cluster_id): <p>The cluster identifier. This value is stored as a lowercase string.</p>
    ///   - [`num_cache_nodes(i32)`](crate::client::fluent_builders::ModifyCacheCluster::num_cache_nodes) / [`set_num_cache_nodes(Option<i32>)`](crate::client::fluent_builders::ModifyCacheCluster::set_num_cache_nodes): <p>The number of cache nodes that the cluster should have. If the value for <code>NumCacheNodes</code> is greater than the sum of the number of current cache nodes and the number of cache nodes pending creation (which may be zero), more nodes are added. If the value is less than the number of existing cache nodes, nodes are removed. If the value is equal to the number of current cache nodes, any pending add or remove requests are canceled.</p>  <p>If you are removing cache nodes, you must use the <code>CacheNodeIdsToRemove</code> parameter to provide the IDs of the specific cache nodes to remove.</p>  <p>For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.</p> <note>   <p>Adding or removing Memcached cache nodes can be applied immediately or as a pending operation (see <code>ApplyImmediately</code>).</p>   <p>A pending operation to modify the number of cache nodes in a cluster during its maintenance window, whether by adding or removing nodes in accordance with the scale out architecture, is not queued. The customer's latest request to add or remove nodes to the cluster overrides any previous pending operations to modify the number of cache nodes in the cluster. For example, a request to remove 2 nodes would override a previous pending operation to remove 3 nodes. Similarly, a request to add 2 nodes would override a previous pending operation to remove 3 nodes and vice versa. As Memcached cache nodes may now be provisioned in different Availability Zones with flexible cache node placement, a request to add nodes does not automatically override a previous pending operation to add nodes. The customer can modify the previous pending operation to add more nodes or explicitly cancel the pending request and retry the new request. To cancel pending operations to modify the number of cache nodes in a cluster, use the <code>ModifyCacheCluster</code> request and set <code>NumCacheNodes</code> equal to the number of cache nodes currently in the cluster.</p>  </note>
    ///   - [`cache_node_ids_to_remove(Vec<String>)`](crate::client::fluent_builders::ModifyCacheCluster::cache_node_ids_to_remove) / [`set_cache_node_ids_to_remove(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyCacheCluster::set_cache_node_ids_to_remove): <p>A list of cache node IDs to be removed. A node ID is a numeric identifier (0001, 0002, etc.). This parameter is only valid when <code>NumCacheNodes</code> is less than the existing number of cache nodes. The number of cache node IDs supplied in this parameter must match the difference between the existing number of cache nodes in the cluster or pending cache nodes, whichever is greater, and the value of <code>NumCacheNodes</code> in the request.</p>  <p>For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of cache nodes in this <code>ModifyCacheCluster</code> call is 5, you must list 2 (7 - 5) cache node IDs to remove.</p>
    ///   - [`az_mode(AzMode)`](crate::client::fluent_builders::ModifyCacheCluster::az_mode) / [`set_az_mode(Option<AzMode>)`](crate::client::fluent_builders::ModifyCacheCluster::set_az_mode): <p>Specifies whether the new nodes in this Memcached cluster are all created in a single Availability Zone or created across multiple Availability Zones.</p>  <p>Valid values: <code>single-az</code> | <code>cross-az</code>.</p>  <p>This option is only supported for Memcached clusters.</p> <note>   <p>You cannot specify <code>single-az</code> if the Memcached cluster already has cache nodes in different Availability Zones. If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone.</p>   <p>Only newly created nodes are located in different Availability Zones. </p>  </note>
    ///   - [`new_availability_zones(Vec<String>)`](crate::client::fluent_builders::ModifyCacheCluster::new_availability_zones) / [`set_new_availability_zones(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyCacheCluster::set_new_availability_zones): <note>   <p>This option is only supported on Memcached clusters.</p>  </note>  <p>The list of Availability Zones where the new Memcached cache nodes are created.</p>  <p>This parameter is only valid when <code>NumCacheNodes</code> in the request is greater than the sum of the number of active cache nodes and the number of cache nodes pending creation (which may be zero). The number of Availability Zones supplied in this list must match the cache nodes being added in this request.</p>  <p>Scenarios:</p>  <ul>   <li> <p> <b>Scenario 1:</b> You have 3 active nodes and wish to add 2 nodes. Specify <code>NumCacheNodes=5</code> (3 + 2) and optionally specify two Availability Zones for the two new nodes.</p> </li>   <li> <p> <b>Scenario 2:</b> You have 3 active nodes and 2 nodes pending creation (from the scenario 1 call) and want to add 1 more node. Specify <code>NumCacheNodes=6</code> ((3 + 2) + 1) and optionally specify an Availability Zone for the new node.</p> </li>   <li> <p> <b>Scenario 3:</b> You want to cancel all pending operations. Specify <code>NumCacheNodes=3</code> to cancel all pending operations.</p> </li>  </ul>  <p>The Availability Zone placement of nodes pending creation cannot be modified. If you wish to cancel any nodes pending creation, add 0 nodes by setting <code>NumCacheNodes</code> to the number of current nodes.</p>  <p>If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone. Only newly created nodes can be located in different Availability Zones. For guidance on how to move existing Memcached nodes to different Availability Zones, see the <b>Availability Zone Considerations</b> section of <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html">Cache Node Considerations for Memcached</a>.</p>  <p> <b>Impact of new add/remove requests upon pending requests</b> </p>  <ul>   <li> <p>Scenario-1</p>    <ul>     <li> <p>Pending Action: Delete</p> </li>     <li> <p>New Request: Delete</p> </li>     <li> <p>Result: The new delete, pending or immediate, replaces the pending delete.</p> </li>    </ul> </li>   <li> <p>Scenario-2</p>    <ul>     <li> <p>Pending Action: Delete</p> </li>     <li> <p>New Request: Create</p> </li>     <li> <p>Result: The new create, pending or immediate, replaces the pending delete.</p> </li>    </ul> </li>   <li> <p>Scenario-3</p>    <ul>     <li> <p>Pending Action: Create</p> </li>     <li> <p>New Request: Delete</p> </li>     <li> <p>Result: The new delete, pending or immediate, replaces the pending create.</p> </li>    </ul> </li>   <li> <p>Scenario-4</p>    <ul>     <li> <p>Pending Action: Create</p> </li>     <li> <p>New Request: Create</p> </li>     <li> <p>Result: The new create is added to the pending create.</p> <important>       <p> <b>Important:</b> If the new create request is <b>Apply Immediately - Yes</b>, all creates are performed immediately. If the new create request is <b>Apply Immediately - No</b>, all creates are pending.</p>      </important> </li>    </ul> </li>  </ul>
    ///   - [`cache_security_group_names(Vec<String>)`](crate::client::fluent_builders::ModifyCacheCluster::cache_security_group_names) / [`set_cache_security_group_names(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyCacheCluster::set_cache_security_group_names): <p>A list of cache security group names to authorize on this cluster. This change is asynchronously applied as soon as possible.</p>  <p>You can use this parameter only with clusters that are created outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>  <p>Constraints: Must contain no more than 255 alphanumeric characters. Must not be "Default".</p>
    ///   - [`security_group_ids(Vec<String>)`](crate::client::fluent_builders::ModifyCacheCluster::security_group_ids) / [`set_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyCacheCluster::set_security_group_ids): <p>Specifies the VPC Security Groups associated with the cluster.</p>  <p>This parameter can be used only with clusters that are created in an Amazon Virtual Private Cloud (Amazon VPC).</p>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::ModifyCacheCluster::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::ModifyCacheCluster::set_preferred_maintenance_window): <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>  <p>Valid values for <code>ddd</code> are:</p>  <ul>   <li> <p> <code>sun</code> </p> </li>   <li> <p> <code>mon</code> </p> </li>   <li> <p> <code>tue</code> </p> </li>   <li> <p> <code>wed</code> </p> </li>   <li> <p> <code>thu</code> </p> </li>   <li> <p> <code>fri</code> </p> </li>   <li> <p> <code>sat</code> </p> </li>  </ul>  <p>Example: <code>sun:23:00-mon:01:30</code> </p>
    ///   - [`notification_topic_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyCacheCluster::notification_topic_arn) / [`set_notification_topic_arn(Option<String>)`](crate::client::fluent_builders::ModifyCacheCluster::set_notification_topic_arn): <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>   <p>The Amazon SNS topic owner must be same as the cluster owner.</p>  </note>
    ///   - [`cache_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyCacheCluster::cache_parameter_group_name) / [`set_cache_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ModifyCacheCluster::set_cache_parameter_group_name): <p>The name of the cache parameter group to apply to this cluster. This change is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.</p>
    ///   - [`notification_topic_status(impl Into<String>)`](crate::client::fluent_builders::ModifyCacheCluster::notification_topic_status) / [`set_notification_topic_status(Option<String>)`](crate::client::fluent_builders::ModifyCacheCluster::set_notification_topic_status): <p>The status of the Amazon SNS notification topic. Notifications are sent only if the status is <code>active</code>.</p>  <p>Valid values: <code>active</code> | <code>inactive</code> </p>
    ///   - [`apply_immediately(bool)`](crate::client::fluent_builders::ModifyCacheCluster::apply_immediately) / [`set_apply_immediately(bool)`](crate::client::fluent_builders::ModifyCacheCluster::set_apply_immediately): <p>If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the cluster.</p>  <p>If <code>false</code>, changes to the cluster are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.</p> <important>   <p>If you perform a <code>ModifyCacheCluster</code> before a pending modification is applied, the pending modification is replaced by the newer modification.</p>  </important>  <p>Valid values: <code>true</code> | <code>false</code> </p>  <p>Default: <code>false</code> </p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::ModifyCacheCluster::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::ModifyCacheCluster::set_engine_version): <p>The upgraded version of the cache engine to be run on the cache nodes.</p>  <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version. </p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::ModifyCacheCluster::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(Option<bool>)`](crate::client::fluent_builders::ModifyCacheCluster::set_auto_minor_version_upgrade): <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
    ///   - [`snapshot_retention_limit(i32)`](crate::client::fluent_builders::ModifyCacheCluster::snapshot_retention_limit) / [`set_snapshot_retention_limit(Option<i32>)`](crate::client::fluent_builders::ModifyCacheCluster::set_snapshot_retention_limit): <p>The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p> <note>   <p>If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.</p>  </note>
    ///   - [`snapshot_window(impl Into<String>)`](crate::client::fluent_builders::ModifyCacheCluster::snapshot_window) / [`set_snapshot_window(Option<String>)`](crate::client::fluent_builders::ModifyCacheCluster::set_snapshot_window): <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster. </p>
    ///   - [`cache_node_type(impl Into<String>)`](crate::client::fluent_builders::ModifyCacheCluster::cache_node_type) / [`set_cache_node_type(Option<String>)`](crate::client::fluent_builders::ModifyCacheCluster::set_cache_node_type): <p>A valid cache node type that you want to scale this cluster up to.</p>
    ///   - [`auth_token(impl Into<String>)`](crate::client::fluent_builders::ModifyCacheCluster::auth_token) / [`set_auth_token(Option<String>)`](crate::client::fluent_builders::ModifyCacheCluster::set_auth_token): <p>Reserved parameter. The password used to access a password protected server. This parameter must be specified with the <code>auth-token-update</code> parameter. Password constraints:</p>  <ul>   <li> <p>Must be only printable ASCII characters</p> </li>   <li> <p>Must be at least 16 characters and no more than 128 characters in length</p> </li>   <li> <p>Cannot contain any of the following characters: '/', '"', or '@', '%'</p> </li>  </ul>  <p> For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.</p>
    ///   - [`auth_token_update_strategy(AuthTokenUpdateStrategyType)`](crate::client::fluent_builders::ModifyCacheCluster::auth_token_update_strategy) / [`set_auth_token_update_strategy(Option<AuthTokenUpdateStrategyType>)`](crate::client::fluent_builders::ModifyCacheCluster::set_auth_token_update_strategy): <p>Specifies the strategy to use to update the AUTH token. This parameter must be specified with the <code>auth-token</code> parameter. Possible values:</p>  <ul>   <li> <p>Rotate</p> </li>   <li> <p>Set</p> </li>  </ul>  <p> For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis AUTH</a> </p>
    ///   - [`log_delivery_configurations(Vec<LogDeliveryConfigurationRequest>)`](crate::client::fluent_builders::ModifyCacheCluster::log_delivery_configurations) / [`set_log_delivery_configurations(Option<Vec<LogDeliveryConfigurationRequest>>)`](crate::client::fluent_builders::ModifyCacheCluster::set_log_delivery_configurations): <p>Specifies the destination, format and type of the logs.</p>
    /// - On success, responds with [`ModifyCacheClusterOutput`](crate::output::ModifyCacheClusterOutput) with field(s):
    ///   - [`cache_cluster(Option<CacheCluster>)`](crate::output::ModifyCacheClusterOutput::cache_cluster): <p>Contains all of the attributes of a specific cluster.</p>
    /// - On failure, responds with [`SdkError<ModifyCacheClusterError>`](crate::error::ModifyCacheClusterError)
    pub fn modify_cache_cluster(&self) -> fluent_builders::ModifyCacheCluster {
        fluent_builders::ModifyCacheCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyCacheParameterGroup`](crate::client::fluent_builders::ModifyCacheParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyCacheParameterGroup::cache_parameter_group_name) / [`set_cache_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ModifyCacheParameterGroup::set_cache_parameter_group_name): <p>The name of the cache parameter group to modify.</p>
    ///   - [`parameter_name_values(Vec<ParameterNameValue>)`](crate::client::fluent_builders::ModifyCacheParameterGroup::parameter_name_values) / [`set_parameter_name_values(Option<Vec<ParameterNameValue>>)`](crate::client::fluent_builders::ModifyCacheParameterGroup::set_parameter_name_values): <p>An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be modified per request.</p>
    /// - On success, responds with [`ModifyCacheParameterGroupOutput`](crate::output::ModifyCacheParameterGroupOutput) with field(s):
    ///   - [`cache_parameter_group_name(Option<String>)`](crate::output::ModifyCacheParameterGroupOutput::cache_parameter_group_name): <p>The name of the cache parameter group.</p>
    /// - On failure, responds with [`SdkError<ModifyCacheParameterGroupError>`](crate::error::ModifyCacheParameterGroupError)
    pub fn modify_cache_parameter_group(&self) -> fluent_builders::ModifyCacheParameterGroup {
        fluent_builders::ModifyCacheParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyCacheSubnetGroup`](crate::client::fluent_builders::ModifyCacheSubnetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyCacheSubnetGroup::cache_subnet_group_name) / [`set_cache_subnet_group_name(Option<String>)`](crate::client::fluent_builders::ModifyCacheSubnetGroup::set_cache_subnet_group_name): <p>The name for the cache subnet group. This value is stored as a lowercase string.</p>  <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>  <p>Example: <code>mysubnetgroup</code> </p>
    ///   - [`cache_subnet_group_description(impl Into<String>)`](crate::client::fluent_builders::ModifyCacheSubnetGroup::cache_subnet_group_description) / [`set_cache_subnet_group_description(Option<String>)`](crate::client::fluent_builders::ModifyCacheSubnetGroup::set_cache_subnet_group_description): <p>A description of the cache subnet group.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::ModifyCacheSubnetGroup::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyCacheSubnetGroup::set_subnet_ids): <p>The EC2 subnet IDs for the cache subnet group.</p>
    /// - On success, responds with [`ModifyCacheSubnetGroupOutput`](crate::output::ModifyCacheSubnetGroupOutput) with field(s):
    ///   - [`cache_subnet_group(Option<CacheSubnetGroup>)`](crate::output::ModifyCacheSubnetGroupOutput::cache_subnet_group): <p>Represents the output of one of the following operations:</p>  <ul>   <li> <p> <code>CreateCacheSubnetGroup</code> </p> </li>   <li> <p> <code>ModifyCacheSubnetGroup</code> </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<ModifyCacheSubnetGroupError>`](crate::error::ModifyCacheSubnetGroupError)
    pub fn modify_cache_subnet_group(&self) -> fluent_builders::ModifyCacheSubnetGroup {
        fluent_builders::ModifyCacheSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyGlobalReplicationGroup`](crate::client::fluent_builders::ModifyGlobalReplicationGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_replication_group_id(impl Into<String>)`](crate::client::fluent_builders::ModifyGlobalReplicationGroup::global_replication_group_id) / [`set_global_replication_group_id(Option<String>)`](crate::client::fluent_builders::ModifyGlobalReplicationGroup::set_global_replication_group_id): <p>The name of the Global datastore</p>
    ///   - [`apply_immediately(bool)`](crate::client::fluent_builders::ModifyGlobalReplicationGroup::apply_immediately) / [`set_apply_immediately(bool)`](crate::client::fluent_builders::ModifyGlobalReplicationGroup::set_apply_immediately): <p>This parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible. Modifications to Global Replication Groups cannot be requested to be applied in PreferredMaintenceWindow. </p>
    ///   - [`cache_node_type(impl Into<String>)`](crate::client::fluent_builders::ModifyGlobalReplicationGroup::cache_node_type) / [`set_cache_node_type(Option<String>)`](crate::client::fluent_builders::ModifyGlobalReplicationGroup::set_cache_node_type): <p>A valid cache node type that you want to scale this Global datastore to.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::ModifyGlobalReplicationGroup::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::ModifyGlobalReplicationGroup::set_engine_version): <p>The upgraded version of the cache engine to be run on the clusters in the Global datastore. </p>
    ///   - [`cache_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyGlobalReplicationGroup::cache_parameter_group_name) / [`set_cache_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ModifyGlobalReplicationGroup::set_cache_parameter_group_name): <p>The name of the cache parameter group to use with the Global datastore. It must be compatible with the major engine version used by the Global datastore.</p>
    ///   - [`global_replication_group_description(impl Into<String>)`](crate::client::fluent_builders::ModifyGlobalReplicationGroup::global_replication_group_description) / [`set_global_replication_group_description(Option<String>)`](crate::client::fluent_builders::ModifyGlobalReplicationGroup::set_global_replication_group_description): <p>A description of the Global datastore</p>
    ///   - [`automatic_failover_enabled(bool)`](crate::client::fluent_builders::ModifyGlobalReplicationGroup::automatic_failover_enabled) / [`set_automatic_failover_enabled(Option<bool>)`](crate::client::fluent_builders::ModifyGlobalReplicationGroup::set_automatic_failover_enabled): <p>Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure. </p>
    /// - On success, responds with [`ModifyGlobalReplicationGroupOutput`](crate::output::ModifyGlobalReplicationGroupOutput) with field(s):
    ///   - [`global_replication_group(Option<GlobalReplicationGroup>)`](crate::output::ModifyGlobalReplicationGroupOutput::global_replication_group): <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary cluster automatically replicates updates to the secondary cluster.</p>  <ul>   <li> <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore, which is what you use to associate a secondary cluster.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<ModifyGlobalReplicationGroupError>`](crate::error::ModifyGlobalReplicationGroupError)
    pub fn modify_global_replication_group(&self) -> fluent_builders::ModifyGlobalReplicationGroup {
        fluent_builders::ModifyGlobalReplicationGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyReplicationGroup`](crate::client::fluent_builders::ModifyReplicationGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_group_id(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::replication_group_id) / [`set_replication_group_id(Option<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_replication_group_id): <p>The identifier of the replication group to modify.</p>
    ///   - [`replication_group_description(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::replication_group_description) / [`set_replication_group_description(Option<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_replication_group_description): <p>A description for the replication group. Maximum length is 255 characters.</p>
    ///   - [`primary_cluster_id(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::primary_cluster_id) / [`set_primary_cluster_id(Option<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_primary_cluster_id): <p>For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the specified cluster in the specified replication group to the primary role. The nodes of all other clusters in the replication group are read replicas.</p>
    ///   - [`snapshotting_cluster_id(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::snapshotting_cluster_id) / [`set_snapshotting_cluster_id(Option<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_snapshotting_cluster_id): <p>The cluster ID that is used as the daily snapshot source for the replication group. This parameter cannot be set for Redis (cluster mode enabled) replication groups.</p>
    ///   - [`automatic_failover_enabled(bool)`](crate::client::fluent_builders::ModifyReplicationGroup::automatic_failover_enabled) / [`set_automatic_failover_enabled(Option<bool>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_automatic_failover_enabled): <p>Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure.</p>  <p>Valid values: <code>true</code> | <code>false</code> </p>
    ///   - [`multi_az_enabled(bool)`](crate::client::fluent_builders::ModifyReplicationGroup::multi_az_enabled) / [`set_multi_az_enabled(Option<bool>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_multi_az_enabled): <p>A flag to indicate MultiAZ is enabled.</p>
    ///   - [`node_group_id(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::node_group_id) / [`set_node_group_id(Option<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_node_group_id): <p>Deprecated. This parameter is not used.</p>
    ///   - [`cache_security_group_names(Vec<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::cache_security_group_names) / [`set_cache_security_group_names(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_cache_security_group_names): <p>A list of cache security group names to authorize for the clusters in this replication group. This change is asynchronously applied as soon as possible.</p>  <p>This parameter can be used only with replication group containing clusters running outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>  <p>Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.</p>
    ///   - [`security_group_ids(Vec<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::security_group_ids) / [`set_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_security_group_ids): <p>Specifies the VPC Security Groups associated with the clusters in the replication group.</p>  <p>This parameter can be used only with replication group containing clusters running in an Amazon Virtual Private Cloud (Amazon VPC).</p>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_preferred_maintenance_window): <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>  <p>Valid values for <code>ddd</code> are:</p>  <ul>   <li> <p> <code>sun</code> </p> </li>   <li> <p> <code>mon</code> </p> </li>   <li> <p> <code>tue</code> </p> </li>   <li> <p> <code>wed</code> </p> </li>   <li> <p> <code>thu</code> </p> </li>   <li> <p> <code>fri</code> </p> </li>   <li> <p> <code>sat</code> </p> </li>  </ul>  <p>Example: <code>sun:23:00-mon:01:30</code> </p>
    ///   - [`notification_topic_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::notification_topic_arn) / [`set_notification_topic_arn(Option<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_notification_topic_arn): <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>   <p>The Amazon SNS topic owner must be same as the replication group owner. </p>  </note>
    ///   - [`cache_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::cache_parameter_group_name) / [`set_cache_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_cache_parameter_group_name): <p>The name of the cache parameter group to apply to all of the clusters in this replication group. This change is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.</p>
    ///   - [`notification_topic_status(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::notification_topic_status) / [`set_notification_topic_status(Option<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_notification_topic_status): <p>The status of the Amazon SNS notification topic for the replication group. Notifications are sent only if the status is <code>active</code>.</p>  <p>Valid values: <code>active</code> | <code>inactive</code> </p>
    ///   - [`apply_immediately(bool)`](crate::client::fluent_builders::ModifyReplicationGroup::apply_immediately) / [`set_apply_immediately(bool)`](crate::client::fluent_builders::ModifyReplicationGroup::set_apply_immediately): <p>If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the replication group.</p>  <p>If <code>false</code>, changes to the nodes in the replication group are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.</p>  <p>Valid values: <code>true</code> | <code>false</code> </p>  <p>Default: <code>false</code> </p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_engine_version): <p>The upgraded version of the cache engine to be run on the clusters in the replication group.</p>  <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing replication group and create it anew with the earlier engine version. </p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::ModifyReplicationGroup::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(Option<bool>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_auto_minor_version_upgrade): <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
    ///   - [`snapshot_retention_limit(i32)`](crate::client::fluent_builders::ModifyReplicationGroup::snapshot_retention_limit) / [`set_snapshot_retention_limit(Option<i32>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_snapshot_retention_limit): <p>The number of days for which ElastiCache retains automatic node group (shard) snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>  <p> <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>
    ///   - [`snapshot_window(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::snapshot_window) / [`set_snapshot_window(Option<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_snapshot_window): <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node group (shard) specified by <code>SnapshottingClusterId</code>.</p>  <p>Example: <code>05:00-09:00</code> </p>  <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p>
    ///   - [`cache_node_type(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::cache_node_type) / [`set_cache_node_type(Option<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_cache_node_type): <p>A valid cache node type that you want to scale this replication group to.</p>
    ///   - [`auth_token(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::auth_token) / [`set_auth_token(Option<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_auth_token): <p>Reserved parameter. The password used to access a password protected server. This parameter must be specified with the <code>auth-token-update-strategy </code> parameter. Password constraints:</p>  <ul>   <li> <p>Must be only printable ASCII characters</p> </li>   <li> <p>Must be at least 16 characters and no more than 128 characters in length</p> </li>   <li> <p>Cannot contain any of the following characters: '/', '"', or '@', '%'</p> </li>  </ul>  <p> For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.</p>
    ///   - [`auth_token_update_strategy(AuthTokenUpdateStrategyType)`](crate::client::fluent_builders::ModifyReplicationGroup::auth_token_update_strategy) / [`set_auth_token_update_strategy(Option<AuthTokenUpdateStrategyType>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_auth_token_update_strategy): <p>Specifies the strategy to use to update the AUTH token. This parameter must be specified with the <code>auth-token</code> parameter. Possible values:</p>  <ul>   <li> <p>Rotate</p> </li>   <li> <p>Set</p> </li>  </ul>  <p> For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis AUTH</a> </p>
    ///   - [`user_group_ids_to_add(Vec<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::user_group_ids_to_add) / [`set_user_group_ids_to_add(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_user_group_ids_to_add): <p>The ID of the user group you are associating with the replication group.</p>
    ///   - [`user_group_ids_to_remove(Vec<String>)`](crate::client::fluent_builders::ModifyReplicationGroup::user_group_ids_to_remove) / [`set_user_group_ids_to_remove(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_user_group_ids_to_remove): <p>The ID of the user group to disassociate from the replication group, meaning the users in the group no longer can access the replication group.</p>
    ///   - [`remove_user_groups(bool)`](crate::client::fluent_builders::ModifyReplicationGroup::remove_user_groups) / [`set_remove_user_groups(Option<bool>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_remove_user_groups): <p>Removes the user group associated with this replication group.</p>
    ///   - [`log_delivery_configurations(Vec<LogDeliveryConfigurationRequest>)`](crate::client::fluent_builders::ModifyReplicationGroup::log_delivery_configurations) / [`set_log_delivery_configurations(Option<Vec<LogDeliveryConfigurationRequest>>)`](crate::client::fluent_builders::ModifyReplicationGroup::set_log_delivery_configurations): <p>Specifies the destination, format and type of the logs.</p>
    /// - On success, responds with [`ModifyReplicationGroupOutput`](crate::output::ModifyReplicationGroupOutput) with field(s):
    ///   - [`replication_group(Option<ReplicationGroup>)`](crate::output::ModifyReplicationGroupOutput::replication_group): <p>Contains all of the attributes of a specific Redis replication group.</p>
    /// - On failure, responds with [`SdkError<ModifyReplicationGroupError>`](crate::error::ModifyReplicationGroupError)
    pub fn modify_replication_group(&self) -> fluent_builders::ModifyReplicationGroup {
        fluent_builders::ModifyReplicationGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyReplicationGroupShardConfiguration`](crate::client::fluent_builders::ModifyReplicationGroupShardConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_group_id(impl Into<String>)`](crate::client::fluent_builders::ModifyReplicationGroupShardConfiguration::replication_group_id) / [`set_replication_group_id(Option<String>)`](crate::client::fluent_builders::ModifyReplicationGroupShardConfiguration::set_replication_group_id): <p>The name of the Redis (cluster mode enabled) cluster (replication group) on which the shards are to be configured.</p>
    ///   - [`node_group_count(i32)`](crate::client::fluent_builders::ModifyReplicationGroupShardConfiguration::node_group_count) / [`set_node_group_count(i32)`](crate::client::fluent_builders::ModifyReplicationGroupShardConfiguration::set_node_group_count): <p>The number of node groups (shards) that results from the modification of the shard configuration.</p>
    ///   - [`apply_immediately(bool)`](crate::client::fluent_builders::ModifyReplicationGroupShardConfiguration::apply_immediately) / [`set_apply_immediately(bool)`](crate::client::fluent_builders::ModifyReplicationGroupShardConfiguration::set_apply_immediately): <p>Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for this parameter is <code>true</code>.</p>  <p>Value: true</p>
    ///   - [`resharding_configuration(Vec<ReshardingConfiguration>)`](crate::client::fluent_builders::ModifyReplicationGroupShardConfiguration::resharding_configuration) / [`set_resharding_configuration(Option<Vec<ReshardingConfiguration>>)`](crate::client::fluent_builders::ModifyReplicationGroupShardConfiguration::set_resharding_configuration): <p>Specifies the preferred availability zones for each node group in the cluster. If the value of <code>NodeGroupCount</code> is greater than the current number of node groups (shards), you can use this parameter to specify the preferred availability zones of the cluster's shards. If you omit this parameter ElastiCache selects availability zones for you.</p>  <p>You can specify this parameter only if the value of <code>NodeGroupCount</code> is greater than the current number of node groups (shards).</p>
    ///   - [`node_groups_to_remove(Vec<String>)`](crate::client::fluent_builders::ModifyReplicationGroupShardConfiguration::node_groups_to_remove) / [`set_node_groups_to_remove(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyReplicationGroupShardConfiguration::set_node_groups_to_remove): <p>If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required. <code>NodeGroupsToRemove</code> is a list of <code>NodeGroupId</code>s to remove from the cluster.</p>  <p>ElastiCache for Redis will attempt to remove all node groups listed by <code>NodeGroupsToRemove</code> from the cluster.</p>
    ///   - [`node_groups_to_retain(Vec<String>)`](crate::client::fluent_builders::ModifyReplicationGroupShardConfiguration::node_groups_to_retain) / [`set_node_groups_to_retain(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyReplicationGroupShardConfiguration::set_node_groups_to_retain): <p>If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required. <code>NodeGroupsToRetain</code> is a list of <code>NodeGroupId</code>s to retain in the cluster.</p>  <p>ElastiCache for Redis will attempt to remove all node groups except those listed by <code>NodeGroupsToRetain</code> from the cluster.</p>
    /// - On success, responds with [`ModifyReplicationGroupShardConfigurationOutput`](crate::output::ModifyReplicationGroupShardConfigurationOutput) with field(s):
    ///   - [`replication_group(Option<ReplicationGroup>)`](crate::output::ModifyReplicationGroupShardConfigurationOutput::replication_group): <p>Contains all of the attributes of a specific Redis replication group.</p>
    /// - On failure, responds with [`SdkError<ModifyReplicationGroupShardConfigurationError>`](crate::error::ModifyReplicationGroupShardConfigurationError)
    pub fn modify_replication_group_shard_configuration(
        &self,
    ) -> fluent_builders::ModifyReplicationGroupShardConfiguration {
        fluent_builders::ModifyReplicationGroupShardConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyUser`](crate::client::fluent_builders::ModifyUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::ModifyUser::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::ModifyUser::set_user_id): <p>The ID of the user.</p>
    ///   - [`access_string(impl Into<String>)`](crate::client::fluent_builders::ModifyUser::access_string) / [`set_access_string(Option<String>)`](crate::client::fluent_builders::ModifyUser::set_access_string): <p>Access permissions string used for this user.</p>
    ///   - [`append_access_string(impl Into<String>)`](crate::client::fluent_builders::ModifyUser::append_access_string) / [`set_append_access_string(Option<String>)`](crate::client::fluent_builders::ModifyUser::set_append_access_string): <p>Adds additional user permissions to the access string.</p>
    ///   - [`passwords(Vec<String>)`](crate::client::fluent_builders::ModifyUser::passwords) / [`set_passwords(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyUser::set_passwords): <p>The passwords belonging to the user. You are allowed up to two.</p>
    ///   - [`no_password_required(bool)`](crate::client::fluent_builders::ModifyUser::no_password_required) / [`set_no_password_required(Option<bool>)`](crate::client::fluent_builders::ModifyUser::set_no_password_required): <p>Indicates no password is required for the user.</p>
    /// - On success, responds with [`ModifyUserOutput`](crate::output::ModifyUserOutput) with field(s):
    ///   - [`user_id(Option<String>)`](crate::output::ModifyUserOutput::user_id): <p>The ID of the user.</p>
    ///   - [`user_name(Option<String>)`](crate::output::ModifyUserOutput::user_name): <p>The username of the user.</p>
    ///   - [`status(Option<String>)`](crate::output::ModifyUserOutput::status): <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
    ///   - [`engine(Option<String>)`](crate::output::ModifyUserOutput::engine): <p>The current supported value is Redis.</p>
    ///   - [`minimum_engine_version(Option<String>)`](crate::output::ModifyUserOutput::minimum_engine_version): <p>The minimum engine version required, which is Redis 6.0</p>
    ///   - [`access_string(Option<String>)`](crate::output::ModifyUserOutput::access_string): <p>Access permissions string used for this user.</p>
    ///   - [`user_group_ids(Option<Vec<String>>)`](crate::output::ModifyUserOutput::user_group_ids): <p>Returns a list of the user group IDs the user belongs to.</p>
    ///   - [`authentication(Option<Authentication>)`](crate::output::ModifyUserOutput::authentication): <p>Denotes whether the user requires a password to authenticate.</p>
    ///   - [`arn(Option<String>)`](crate::output::ModifyUserOutput::arn): <p>The Amazon Resource Name (ARN) of the user.</p>
    /// - On failure, responds with [`SdkError<ModifyUserError>`](crate::error::ModifyUserError)
    pub fn modify_user(&self) -> fluent_builders::ModifyUser {
        fluent_builders::ModifyUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyUserGroup`](crate::client::fluent_builders::ModifyUserGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_group_id(impl Into<String>)`](crate::client::fluent_builders::ModifyUserGroup::user_group_id) / [`set_user_group_id(Option<String>)`](crate::client::fluent_builders::ModifyUserGroup::set_user_group_id): <p>The ID of the user group.</p>
    ///   - [`user_ids_to_add(Vec<String>)`](crate::client::fluent_builders::ModifyUserGroup::user_ids_to_add) / [`set_user_ids_to_add(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyUserGroup::set_user_ids_to_add): <p>The list of user IDs to add to the user group.</p>
    ///   - [`user_ids_to_remove(Vec<String>)`](crate::client::fluent_builders::ModifyUserGroup::user_ids_to_remove) / [`set_user_ids_to_remove(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyUserGroup::set_user_ids_to_remove): <p>The list of user IDs to remove from the user group.</p>
    /// - On success, responds with [`ModifyUserGroupOutput`](crate::output::ModifyUserGroupOutput) with field(s):
    ///   - [`user_group_id(Option<String>)`](crate::output::ModifyUserGroupOutput::user_group_id): <p>The ID of the user group.</p>
    ///   - [`status(Option<String>)`](crate::output::ModifyUserGroupOutput::status): <p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>
    ///   - [`engine(Option<String>)`](crate::output::ModifyUserGroupOutput::engine): <p>The current supported value is Redis. </p>
    ///   - [`user_ids(Option<Vec<String>>)`](crate::output::ModifyUserGroupOutput::user_ids): <p>The list of user IDs that belong to the user group.</p>
    ///   - [`minimum_engine_version(Option<String>)`](crate::output::ModifyUserGroupOutput::minimum_engine_version): <p>The minimum engine version required, which is Redis 6.0</p>
    ///   - [`pending_changes(Option<UserGroupPendingChanges>)`](crate::output::ModifyUserGroupOutput::pending_changes): <p>A list of updates being applied to the user group.</p>
    ///   - [`replication_groups(Option<Vec<String>>)`](crate::output::ModifyUserGroupOutput::replication_groups): <p>A list of replication groups that the user group can access.</p>
    ///   - [`arn(Option<String>)`](crate::output::ModifyUserGroupOutput::arn): <p>The Amazon Resource Name (ARN) of the user group.</p>
    /// - On failure, responds with [`SdkError<ModifyUserGroupError>`](crate::error::ModifyUserGroupError)
    pub fn modify_user_group(&self) -> fluent_builders::ModifyUserGroup {
        fluent_builders::ModifyUserGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PurchaseReservedCacheNodesOffering`](crate::client::fluent_builders::PurchaseReservedCacheNodesOffering) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_cache_nodes_offering_id(impl Into<String>)`](crate::client::fluent_builders::PurchaseReservedCacheNodesOffering::reserved_cache_nodes_offering_id) / [`set_reserved_cache_nodes_offering_id(Option<String>)`](crate::client::fluent_builders::PurchaseReservedCacheNodesOffering::set_reserved_cache_nodes_offering_id): <p>The ID of the reserved cache node offering to purchase.</p>  <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>
    ///   - [`reserved_cache_node_id(impl Into<String>)`](crate::client::fluent_builders::PurchaseReservedCacheNodesOffering::reserved_cache_node_id) / [`set_reserved_cache_node_id(Option<String>)`](crate::client::fluent_builders::PurchaseReservedCacheNodesOffering::set_reserved_cache_node_id): <p>A customer-specified identifier to track this reservation.</p> <note>   <p>The Reserved Cache Node ID is an unique customer-specified identifier to track this reservation. If this parameter is not specified, ElastiCache automatically generates an identifier for the reservation.</p>  </note>  <p>Example: myreservationID</p>
    ///   - [`cache_node_count(i32)`](crate::client::fluent_builders::PurchaseReservedCacheNodesOffering::cache_node_count) / [`set_cache_node_count(Option<i32>)`](crate::client::fluent_builders::PurchaseReservedCacheNodesOffering::set_cache_node_count): <p>The number of cache node instances to reserve.</p>  <p>Default: <code>1</code> </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::PurchaseReservedCacheNodesOffering::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::PurchaseReservedCacheNodesOffering::set_tags): <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
    /// - On success, responds with [`PurchaseReservedCacheNodesOfferingOutput`](crate::output::PurchaseReservedCacheNodesOfferingOutput) with field(s):
    ///   - [`reserved_cache_node(Option<ReservedCacheNode>)`](crate::output::PurchaseReservedCacheNodesOfferingOutput::reserved_cache_node): <p>Represents the output of a <code>PurchaseReservedCacheNodesOffering</code> operation.</p>
    /// - On failure, responds with [`SdkError<PurchaseReservedCacheNodesOfferingError>`](crate::error::PurchaseReservedCacheNodesOfferingError)
    pub fn purchase_reserved_cache_nodes_offering(
        &self,
    ) -> fluent_builders::PurchaseReservedCacheNodesOffering {
        fluent_builders::PurchaseReservedCacheNodesOffering::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RebalanceSlotsInGlobalReplicationGroup`](crate::client::fluent_builders::RebalanceSlotsInGlobalReplicationGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_replication_group_id(impl Into<String>)`](crate::client::fluent_builders::RebalanceSlotsInGlobalReplicationGroup::global_replication_group_id) / [`set_global_replication_group_id(Option<String>)`](crate::client::fluent_builders::RebalanceSlotsInGlobalReplicationGroup::set_global_replication_group_id): <p>The name of the Global datastore</p>
    ///   - [`apply_immediately(bool)`](crate::client::fluent_builders::RebalanceSlotsInGlobalReplicationGroup::apply_immediately) / [`set_apply_immediately(bool)`](crate::client::fluent_builders::RebalanceSlotsInGlobalReplicationGroup::set_apply_immediately): <p>If <code>True</code>, redistribution is applied immediately.</p>
    /// - On success, responds with [`RebalanceSlotsInGlobalReplicationGroupOutput`](crate::output::RebalanceSlotsInGlobalReplicationGroupOutput) with field(s):
    ///   - [`global_replication_group(Option<GlobalReplicationGroup>)`](crate::output::RebalanceSlotsInGlobalReplicationGroupOutput::global_replication_group): <p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary cluster automatically replicates updates to the secondary cluster.</p>  <ul>   <li> <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore, which is what you use to associate a secondary cluster.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<RebalanceSlotsInGlobalReplicationGroupError>`](crate::error::RebalanceSlotsInGlobalReplicationGroupError)
    pub fn rebalance_slots_in_global_replication_group(
        &self,
    ) -> fluent_builders::RebalanceSlotsInGlobalReplicationGroup {
        fluent_builders::RebalanceSlotsInGlobalReplicationGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RebootCacheCluster`](crate::client::fluent_builders::RebootCacheCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_cluster_id(impl Into<String>)`](crate::client::fluent_builders::RebootCacheCluster::cache_cluster_id) / [`set_cache_cluster_id(Option<String>)`](crate::client::fluent_builders::RebootCacheCluster::set_cache_cluster_id): <p>The cluster identifier. This parameter is stored as a lowercase string.</p>
    ///   - [`cache_node_ids_to_reboot(Vec<String>)`](crate::client::fluent_builders::RebootCacheCluster::cache_node_ids_to_reboot) / [`set_cache_node_ids_to_reboot(Option<Vec<String>>)`](crate::client::fluent_builders::RebootCacheCluster::set_cache_node_ids_to_reboot): <p>A list of cache node IDs to reboot. A node ID is a numeric identifier (0001, 0002, etc.). To reboot an entire cluster, specify all of the cache node IDs.</p>
    /// - On success, responds with [`RebootCacheClusterOutput`](crate::output::RebootCacheClusterOutput) with field(s):
    ///   - [`cache_cluster(Option<CacheCluster>)`](crate::output::RebootCacheClusterOutput::cache_cluster): <p>Contains all of the attributes of a specific cluster.</p>
    /// - On failure, responds with [`SdkError<RebootCacheClusterError>`](crate::error::RebootCacheClusterError)
    pub fn reboot_cache_cluster(&self) -> fluent_builders::RebootCacheCluster {
        fluent_builders::RebootCacheCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveTagsFromResource`](crate::client::fluent_builders::RemoveTagsFromResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_name(impl Into<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::resource_name) / [`set_resource_name(Option<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::set_resource_name): <p>The Amazon Resource Name (ARN) of the resource from which you want the tags removed, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p>  <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Service Namespaces</a>.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveTagsFromResource::set_tag_keys): <p>A list of <code>TagKeys</code> identifying the tags you want removed from the named resource.</p>
    /// - On success, responds with [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput) with field(s):
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::RemoveTagsFromResourceOutput::tag_list): <p>A list of tags as key-value pairs.</p>
    /// - On failure, responds with [`SdkError<RemoveTagsFromResourceError>`](crate::error::RemoveTagsFromResourceError)
    pub fn remove_tags_from_resource(&self) -> fluent_builders::RemoveTagsFromResource {
        fluent_builders::RemoveTagsFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResetCacheParameterGroup`](crate::client::fluent_builders::ResetCacheParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ResetCacheParameterGroup::cache_parameter_group_name) / [`set_cache_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ResetCacheParameterGroup::set_cache_parameter_group_name): <p>The name of the cache parameter group to reset.</p>
    ///   - [`reset_all_parameters(bool)`](crate::client::fluent_builders::ResetCacheParameterGroup::reset_all_parameters) / [`set_reset_all_parameters(bool)`](crate::client::fluent_builders::ResetCacheParameterGroup::set_reset_all_parameters): <p>If <code>true</code>, all parameters in the cache parameter group are reset to their default values. If <code>false</code>, only the parameters listed by <code>ParameterNameValues</code> are reset to their default values.</p>  <p>Valid values: <code>true</code> | <code>false</code> </p>
    ///   - [`parameter_name_values(Vec<ParameterNameValue>)`](crate::client::fluent_builders::ResetCacheParameterGroup::parameter_name_values) / [`set_parameter_name_values(Option<Vec<ParameterNameValue>>)`](crate::client::fluent_builders::ResetCacheParameterGroup::set_parameter_name_values): <p>An array of parameter names to reset to their default values. If <code>ResetAllParameters</code> is <code>true</code>, do not use <code>ParameterNameValues</code>. If <code>ResetAllParameters</code> is <code>false</code>, you must specify the name of at least one parameter to reset.</p>
    /// - On success, responds with [`ResetCacheParameterGroupOutput`](crate::output::ResetCacheParameterGroupOutput) with field(s):
    ///   - [`cache_parameter_group_name(Option<String>)`](crate::output::ResetCacheParameterGroupOutput::cache_parameter_group_name): <p>The name of the cache parameter group.</p>
    /// - On failure, responds with [`SdkError<ResetCacheParameterGroupError>`](crate::error::ResetCacheParameterGroupError)
    pub fn reset_cache_parameter_group(&self) -> fluent_builders::ResetCacheParameterGroup {
        fluent_builders::ResetCacheParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RevokeCacheSecurityGroupIngress`](crate::client::fluent_builders::RevokeCacheSecurityGroupIngress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cache_security_group_name(impl Into<String>)`](crate::client::fluent_builders::RevokeCacheSecurityGroupIngress::cache_security_group_name) / [`set_cache_security_group_name(Option<String>)`](crate::client::fluent_builders::RevokeCacheSecurityGroupIngress::set_cache_security_group_name): <p>The name of the cache security group to revoke ingress from.</p>
    ///   - [`ec2_security_group_name(impl Into<String>)`](crate::client::fluent_builders::RevokeCacheSecurityGroupIngress::ec2_security_group_name) / [`set_ec2_security_group_name(Option<String>)`](crate::client::fluent_builders::RevokeCacheSecurityGroupIngress::set_ec2_security_group_name): <p>The name of the Amazon EC2 security group to revoke access from.</p>
    ///   - [`ec2_security_group_owner_id(impl Into<String>)`](crate::client::fluent_builders::RevokeCacheSecurityGroupIngress::ec2_security_group_owner_id) / [`set_ec2_security_group_owner_id(Option<String>)`](crate::client::fluent_builders::RevokeCacheSecurityGroupIngress::set_ec2_security_group_owner_id): <p>The Amazon account number of the Amazon EC2 security group owner. Note that this is not the same thing as an Amazon access key ID - you must provide a valid Amazon account number for this parameter.</p>
    /// - On success, responds with [`RevokeCacheSecurityGroupIngressOutput`](crate::output::RevokeCacheSecurityGroupIngressOutput) with field(s):
    ///   - [`cache_security_group(Option<CacheSecurityGroup>)`](crate::output::RevokeCacheSecurityGroupIngressOutput::cache_security_group): <p>Represents the output of one of the following operations:</p>  <ul>   <li> <p> <code>AuthorizeCacheSecurityGroupIngress</code> </p> </li>   <li> <p> <code>CreateCacheSecurityGroup</code> </p> </li>   <li> <p> <code>RevokeCacheSecurityGroupIngress</code> </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<RevokeCacheSecurityGroupIngressError>`](crate::error::RevokeCacheSecurityGroupIngressError)
    pub fn revoke_cache_security_group_ingress(
        &self,
    ) -> fluent_builders::RevokeCacheSecurityGroupIngress {
        fluent_builders::RevokeCacheSecurityGroupIngress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartMigration`](crate::client::fluent_builders::StartMigration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_group_id(impl Into<String>)`](crate::client::fluent_builders::StartMigration::replication_group_id) / [`set_replication_group_id(Option<String>)`](crate::client::fluent_builders::StartMigration::set_replication_group_id): <p>The ID of the replication group to which data should be migrated.</p>
    ///   - [`customer_node_endpoint_list(Vec<CustomerNodeEndpoint>)`](crate::client::fluent_builders::StartMigration::customer_node_endpoint_list) / [`set_customer_node_endpoint_list(Option<Vec<CustomerNodeEndpoint>>)`](crate::client::fluent_builders::StartMigration::set_customer_node_endpoint_list): <p>List of endpoints from which data should be migrated. For Redis (cluster mode disabled), list should have only one element.</p>
    /// - On success, responds with [`StartMigrationOutput`](crate::output::StartMigrationOutput) with field(s):
    ///   - [`replication_group(Option<ReplicationGroup>)`](crate::output::StartMigrationOutput::replication_group): <p>Contains all of the attributes of a specific Redis replication group.</p>
    /// - On failure, responds with [`SdkError<StartMigrationError>`](crate::error::StartMigrationError)
    pub fn start_migration(&self) -> fluent_builders::StartMigration {
        fluent_builders::StartMigration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TestFailover`](crate::client::fluent_builders::TestFailover) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_group_id(impl Into<String>)`](crate::client::fluent_builders::TestFailover::replication_group_id) / [`set_replication_group_id(Option<String>)`](crate::client::fluent_builders::TestFailover::set_replication_group_id): <p>The name of the replication group (console: cluster) whose automatic failover is being tested by this operation.</p>
    ///   - [`node_group_id(impl Into<String>)`](crate::client::fluent_builders::TestFailover::node_group_id) / [`set_node_group_id(Option<String>)`](crate::client::fluent_builders::TestFailover::set_node_group_id): <p>The name of the node group (called shard in the console) in this replication group on which automatic failover is to be tested. You may test automatic failover on up to 5 node groups in any rolling 24-hour period.</p>
    /// - On success, responds with [`TestFailoverOutput`](crate::output::TestFailoverOutput) with field(s):
    ///   - [`replication_group(Option<ReplicationGroup>)`](crate::output::TestFailoverOutput::replication_group): <p>Contains all of the attributes of a specific Redis replication group.</p>
    /// - On failure, responds with [`SdkError<TestFailoverError>`](crate::error::TestFailoverError)
    pub fn test_failover(&self) -> fluent_builders::TestFailover {
        fluent_builders::TestFailover::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddTagsToResource`.
    ///
    /// <p>A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html">Resource-level permissions</a>.</p>
    /// <p> For example, you can use cost-allocation tags to your ElastiCache resources, Amazon generates a cost allocation report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply tags that represent business categories (such as cost centers, application names, or owners) to organize your costs across multiple services.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Tagging.html">Using Cost Allocation Tags in Amazon ElastiCache</a> in the <i>ElastiCache User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTagsToResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_tags_to_resource_input::Builder,
    }
    impl AddTagsToResource {
        /// Creates a new `AddTagsToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be added, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>. ElastiCache resources are <i>cluster</i> and <i>snapshot</i>.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Service Namespaces</a>.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which the tags are to be added, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>. ElastiCache resources are <i>cluster</i> and <i>snapshot</i>.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Service Namespaces</a>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AuthorizeCacheSecurityGroupIngress`.
    ///
    /// <p>Allows network ingress to a cache security group. Applications using ElastiCache must be running on Amazon EC2, and Amazon EC2 security groups are used as the authorization mechanism.</p> <note>
    /// <p>You cannot authorize ingress from an Amazon EC2 security group in one region to an ElastiCache cluster in another region.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AuthorizeCacheSecurityGroupIngress {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::authorize_cache_security_group_ingress_input::Builder,
    }
    impl AuthorizeCacheSecurityGroupIngress {
        /// Creates a new `AuthorizeCacheSecurityGroupIngress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AuthorizeCacheSecurityGroupIngressOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AuthorizeCacheSecurityGroupIngressError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cache security group that allows network ingress.</p>
        pub fn cache_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_security_group_name(input.into());
            self
        }
        /// <p>The cache security group that allows network ingress.</p>
        pub fn set_cache_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_security_group_name(input);
            self
        }
        /// <p>The Amazon EC2 security group to be authorized for ingress to the cache security group.</p>
        pub fn ec2_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_security_group_name(input.into());
            self
        }
        /// <p>The Amazon EC2 security group to be authorized for ingress to the cache security group.</p>
        pub fn set_ec2_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_name(input);
            self
        }
        /// <p>The Amazon account number of the Amazon EC2 security group owner. Note that this is not the same thing as an Amazon access key ID - you must provide a valid Amazon account number for this parameter.</p>
        pub fn ec2_security_group_owner_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.ec2_security_group_owner_id(input.into());
            self
        }
        /// <p>The Amazon account number of the Amazon EC2 security group owner. Note that this is not the same thing as an Amazon access key ID - you must provide a valid Amazon account number for this parameter.</p>
        pub fn set_ec2_security_group_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_owner_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchApplyUpdateAction`.
    ///
    /// <p>Apply the service update. For more information on service updates and applying them, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/applying-updates.html">Applying Service Updates</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchApplyUpdateAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_apply_update_action_input::Builder,
    }
    impl BatchApplyUpdateAction {
        /// Creates a new `BatchApplyUpdateAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchApplyUpdateActionOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchApplyUpdateActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ReplicationGroupIds`.
        ///
        /// To override the contents of this collection use [`set_replication_group_ids`](Self::set_replication_group_ids).
        ///
        /// <p>The replication group IDs</p>
        pub fn replication_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_ids(input.into());
            self
        }
        /// <p>The replication group IDs</p>
        pub fn set_replication_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_ids(input);
            self
        }
        /// Appends an item to `CacheClusterIds`.
        ///
        /// To override the contents of this collection use [`set_cache_cluster_ids`](Self::set_cache_cluster_ids).
        ///
        /// <p>The cache cluster IDs</p>
        pub fn cache_cluster_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_cluster_ids(input.into());
            self
        }
        /// <p>The cache cluster IDs</p>
        pub fn set_cache_cluster_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cache_cluster_ids(input);
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn service_update_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_update_name(input.into());
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn set_service_update_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_update_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchStopUpdateAction`.
    ///
    /// <p>Stop the service update. For more information on service updates and stopping them, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/stopping-self-service-updates.html">Stopping Service Updates</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchStopUpdateAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_stop_update_action_input::Builder,
    }
    impl BatchStopUpdateAction {
        /// Creates a new `BatchStopUpdateAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchStopUpdateActionOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchStopUpdateActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ReplicationGroupIds`.
        ///
        /// To override the contents of this collection use [`set_replication_group_ids`](Self::set_replication_group_ids).
        ///
        /// <p>The replication group IDs</p>
        pub fn replication_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_ids(input.into());
            self
        }
        /// <p>The replication group IDs</p>
        pub fn set_replication_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_ids(input);
            self
        }
        /// Appends an item to `CacheClusterIds`.
        ///
        /// To override the contents of this collection use [`set_cache_cluster_ids`](Self::set_cache_cluster_ids).
        ///
        /// <p>The cache cluster IDs</p>
        pub fn cache_cluster_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_cluster_ids(input.into());
            self
        }
        /// <p>The cache cluster IDs</p>
        pub fn set_cache_cluster_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cache_cluster_ids(input);
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn service_update_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_update_name(input.into());
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn set_service_update_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_update_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CompleteMigration`.
    ///
    /// <p>Complete the migration of data.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CompleteMigration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::complete_migration_input::Builder,
    }
    impl CompleteMigration {
        /// Creates a new `CompleteMigration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CompleteMigrationOutput,
            aws_smithy_http::result::SdkError<crate::error::CompleteMigrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the replication group to which data is being migrated.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_id(input.into());
            self
        }
        /// <p>The ID of the replication group to which data is being migrated.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_id(input);
            self
        }
        /// <p>Forces the migration to stop without ensuring that data is in sync. It is recommended to use this option only to abort the migration and not recommended when application wants to continue migration to ElastiCache.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>Forces the migration to stop without ensuring that data is in sync. It is recommended to use this option only to abort the migration and not recommended when application wants to continue migration to ElastiCache.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopySnapshot`.
    ///
    /// <p>Makes a copy of an existing snapshot.</p> <note>
    /// <p>This operation is valid for Redis only.</p>
    /// </note> <important>
    /// <p>Users or groups that have permissions to use the <code>CopySnapshot</code> operation can create their own Amazon S3 buckets and copy snapshots to it. To control access to your snapshots, use an IAM policy to control who has the ability to use the <code>CopySnapshot</code> operation. For more information about using IAM to control the use of ElastiCache operations, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html">Exporting Snapshots</a> and <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.html">Authentication &amp; Access Control</a>.</p>
    /// </important>
    /// <p>You could receive the following error messages.</p>
    /// <p class="title"> <b>Error Messages</b> </p>
    /// <ul>
    /// <li> <p> <b>Error Message:</b> The S3 bucket %s is outside of the region.</p> <p> <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket">Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.</p> </li>
    /// <li> <p> <b>Error Message:</b> The S3 bucket %s does not exist.</p> <p> <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket">Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.</p> </li>
    /// <li> <p> <b>Error Message:</b> The S3 bucket %s is not owned by the authenticated user.</p> <p> <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket">Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.</p> </li>
    /// <li> <p> <b>Error Message:</b> The authenticated user does not have sufficient permissions to perform the desired activity.</p> <p> <b>Solution:</b> Contact your system administrator to get the needed permissions.</p> </li>
    /// <li> <p> <b>Error Message:</b> The S3 bucket %s already contains an object with key %s.</p> <p> <b>Solution:</b> Give the <code>TargetSnapshotName</code> a new and unique value. If exporting a snapshot, you could alternatively create a new Amazon S3 bucket and use this same value for <code>TargetSnapshotName</code>.</p> </li>
    /// <li> <p> <b>Error Message: </b> ElastiCache has not been granted READ permissions %s on the S3 Bucket.</p> <p> <b>Solution:</b> Add List and Read permissions on the bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access">Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.</p> </li>
    /// <li> <p> <b>Error Message: </b> ElastiCache has not been granted WRITE permissions %s on the S3 Bucket.</p> <p> <b>Solution:</b> Add Upload/Delete permissions on the bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access">Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.</p> </li>
    /// <li> <p> <b>Error Message: </b> ElastiCache has not been granted READ_ACP permissions %s on the S3 Bucket.</p> <p> <b>Solution:</b> Add View Permissions on the bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access">Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopySnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::copy_snapshot_input::Builder,
    }
    impl CopySnapshot {
        /// Creates a new `CopySnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopySnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CopySnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of an existing snapshot from which to make a copy.</p>
        pub fn source_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_snapshot_name(input.into());
            self
        }
        /// <p>The name of an existing snapshot from which to make a copy.</p>
        pub fn set_source_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_snapshot_name(input);
            self
        }
        /// <p>A name for the snapshot copy. ElastiCache does not permit overwriting a snapshot, therefore this name must be unique within its context - ElastiCache or an Amazon S3 bucket if exporting.</p>
        pub fn target_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_snapshot_name(input.into());
            self
        }
        /// <p>A name for the snapshot copy. ElastiCache does not permit overwriting a snapshot, therefore this name must be unique within its context - ElastiCache or an Amazon S3 bucket if exporting.</p>
        pub fn set_target_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_snapshot_name(input);
            self
        }
        /// <p>The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access.</p>
        /// <p>When using this parameter to export a snapshot, be sure Amazon ElastiCache has the needed permissions to this S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access">Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the <i>Amazon ElastiCache User Guide</i>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html">Exporting a Snapshot</a> in the <i>Amazon ElastiCache User Guide</i>.</p>
        pub fn target_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_bucket(input.into());
            self
        }
        /// <p>The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access.</p>
        /// <p>When using this parameter to export a snapshot, be sure Amazon ElastiCache has the needed permissions to this S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access">Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the <i>Amazon ElastiCache User Guide</i>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html">Exporting a Snapshot</a> in the <i>Amazon ElastiCache User Guide</i>.</p>
        pub fn set_target_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_bucket(input);
            self
        }
        /// <p>The ID of the KMS key used to encrypt the target snapshot.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The ID of the KMS key used to encrypt the target snapshot.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCacheCluster`.
    ///
    /// <p>Creates a cluster. All nodes in the cluster run the same protocol-compliant cache engine software, either Memcached or Redis.</p>
    /// <p>This operation is not supported for Redis (cluster mode enabled) clusters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCacheCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cache_cluster_input::Builder,
    }
    impl CreateCacheCluster {
        /// Creates a new `CreateCacheCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCacheClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCacheClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The node group (shard) identifier. This parameter is stored as a lowercase string.</p>
        /// <p> <b>Constraints:</b> </p>
        /// <ul>
        /// <li> <p>A name must contain from 1 to 50 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>The first character must be a letter.</p> </li>
        /// <li> <p>A name cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_cluster_id(input.into());
            self
        }
        /// <p>The node group (shard) identifier. This parameter is stored as a lowercase string.</p>
        /// <p> <b>Constraints:</b> </p>
        /// <ul>
        /// <li> <p>A name must contain from 1 to 50 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>The first character must be a letter.</p> </li>
        /// <li> <p>A name cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_cluster_id(input);
            self
        }
        /// <p>The ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.</p>
        /// <p>If the specified replication group is Multi-AZ enabled and the Availability Zone is not specified, the cluster is created in Availability Zones that provide the best spread of read replicas across Availability Zones.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_id(input.into());
            self
        }
        /// <p>The ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.</p>
        /// <p>If the specified replication group is Multi-AZ enabled and the Availability Zone is not specified, the cluster is created in Availability Zones that provide the best spread of read replicas across Availability Zones.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_id(input);
            self
        }
        /// <p>Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region.</p>
        /// <p>This parameter is only supported for Memcached clusters.</p>
        /// <p>If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes <code>single-az</code> mode.</p>
        pub fn az_mode(mut self, input: crate::model::AzMode) -> Self {
            self.inner = self.inner.az_mode(input);
            self
        }
        /// <p>Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region.</p>
        /// <p>This parameter is only supported for Memcached clusters.</p>
        /// <p>If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes <code>single-az</code> mode.</p>
        pub fn set_az_mode(mut self, input: std::option::Option<crate::model::AzMode>) -> Self {
            self.inner = self.inner.set_az_mode(input);
            self
        }
        /// <p>The EC2 Availability Zone in which the cluster is created.</p>
        /// <p>All nodes belonging to this cluster are placed in the preferred Availability Zone. If you want to create your nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code>.</p>
        /// <p>Default: System chosen Availability Zone.</p>
        pub fn preferred_availability_zone(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_availability_zone(input.into());
            self
        }
        /// <p>The EC2 Availability Zone in which the cluster is created.</p>
        /// <p>All nodes belonging to this cluster are placed in the preferred Availability Zone. If you want to create your nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code>.</p>
        /// <p>Default: System chosen Availability Zone.</p>
        pub fn set_preferred_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_availability_zone(input);
            self
        }
        /// Appends an item to `PreferredAvailabilityZones`.
        ///
        /// To override the contents of this collection use [`set_preferred_availability_zones`](Self::set_preferred_availability_zones).
        ///
        /// <p>A list of the Availability Zones in which cache nodes are created. The order of the zones in the list is not important.</p>
        /// <p>This option is only supported on Memcached.</p> <note>
        /// <p>If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group.</p>
        /// <p>The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.</p>
        /// </note>
        /// <p>If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code> instead, or repeat the Availability Zone multiple times in the list.</p>
        /// <p>Default: System chosen Availability Zones.</p>
        pub fn preferred_availability_zones(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_availability_zones(input.into());
            self
        }
        /// <p>A list of the Availability Zones in which cache nodes are created. The order of the zones in the list is not important.</p>
        /// <p>This option is only supported on Memcached.</p> <note>
        /// <p>If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group.</p>
        /// <p>The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.</p>
        /// </note>
        /// <p>If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code> instead, or repeat the Availability Zone multiple times in the list.</p>
        /// <p>Default: System chosen Availability Zones.</p>
        pub fn set_preferred_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_preferred_availability_zones(input);
            self
        }
        /// <p>The initial number of cache nodes that the cluster has.</p>
        /// <p>For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.</p>
        /// <p>If you need more than 40 nodes for your Memcached cluster, please fill out the ElastiCache Limit Increase Request form at <a href="http://aws.amazon.com/contact-us/elasticache-node-limit-request/">http://aws.amazon.com/contact-us/elasticache-node-limit-request/</a>.</p>
        pub fn num_cache_nodes(mut self, input: i32) -> Self {
            self.inner = self.inner.num_cache_nodes(input);
            self
        }
        /// <p>The initial number of cache nodes that the cluster has.</p>
        /// <p>For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.</p>
        /// <p>If you need more than 40 nodes for your Memcached cluster, please fill out the ElastiCache Limit Increase Request form at <a href="http://aws.amazon.com/contact-us/elasticache-node-limit-request/">http://aws.amazon.com/contact-us/elasticache-node-limit-request/</a>.</p>
        pub fn set_num_cache_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_num_cache_nodes(input);
            self
        }
        /// <p>The compute and memory capacity of the nodes in the node group (shard).</p>
        /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li> <p>General purpose:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Compute optimized:</p>
        /// <ul>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p> <b>Additional node type info</b> </p>
        /// <ul>
        /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
        /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
        /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
        /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
        /// </ul>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_node_type(input.into());
            self
        }
        /// <p>The compute and memory capacity of the nodes in the node group (shard).</p>
        /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li> <p>General purpose:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Compute optimized:</p>
        /// <ul>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p> <b>Additional node type info</b> </p>
        /// <ul>
        /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
        /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
        /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
        /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
        /// </ul>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_node_type(input);
            self
        }
        /// <p>The name of the cache engine to be used for this cluster.</p>
        /// <p>Valid values for this parameter are: <code>memcached</code> | <code>redis</code> </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(input.into());
            self
        }
        /// <p>The name of the cache engine to be used for this cluster.</p>
        /// <p>Valid values for this parameter are: <code>memcached</code> | <code>redis</code> </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The version number of the cache engine to be used for this cluster. To view the supported cache engine versions, use the DescribeCacheEngineVersions operation.</p>
        /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version. </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The version number of the cache engine to be used for this cluster. To view the supported cache engine versions, use the DescribeCacheEngineVersions operation.</p>
        /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version. </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The name of the parameter group to associate with this cluster. If this argument is omitted, the default parameter group for the specified engine is used. You cannot use any parameter group which has <code>cluster-enabled='yes'</code> when creating a cluster.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the parameter group to associate with this cluster. If this argument is omitted, the default parameter group for the specified engine is used. You cannot use any parameter group which has <code>cluster-enabled='yes'</code> when creating a cluster.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_parameter_group_name(input);
            self
        }
        /// <p>The name of the subnet group to be used for the cluster.</p>
        /// <p>Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).</p> <important>
        /// <p>If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet Groups</a>.</p>
        /// </important>
        pub fn cache_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_subnet_group_name(input.into());
            self
        }
        /// <p>The name of the subnet group to be used for the cluster.</p>
        /// <p>Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).</p> <important>
        /// <p>If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet Groups</a>.</p>
        /// </important>
        pub fn set_cache_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_subnet_group_name(input);
            self
        }
        /// Appends an item to `CacheSecurityGroupNames`.
        ///
        /// To override the contents of this collection use [`set_cache_security_group_names`](Self::set_cache_security_group_names).
        ///
        /// <p>A list of security group names to associate with this cluster.</p>
        /// <p>Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn cache_security_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_security_group_names(input.into());
            self
        }
        /// <p>A list of security group names to associate with this cluster.</p>
        /// <p>Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn set_cache_security_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cache_security_group_names(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>One or more VPC security groups associated with the cluster.</p>
        /// <p>Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>One or more VPC security groups associated with the cluster.</p>
        /// <p>Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `SnapshotArns`.
        ///
        /// To override the contents of this collection use [`set_snapshot_arns`](Self::set_snapshot_arns).
        ///
        /// <p>A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis RDB snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard). The Amazon S3 object name in the ARN cannot contain any commas.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        /// <p>Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code> </p>
        pub fn snapshot_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_arns(input.into());
            self
        }
        /// <p>A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis RDB snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard). The Amazon S3 object name in the ARN cannot contain any commas.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        /// <p>Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code> </p>
        pub fn set_snapshot_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_arns(input);
            self
        }
        /// <p>The name of a Redis snapshot from which to restore data into the new node group (shard). The snapshot status changes to <code>restoring</code> while the new node group (shard) is being created.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_name(input.into());
            self
        }
        /// <p>The name of a Redis snapshot from which to restore data into the new node group (shard). The snapshot status changes to <code>restoring</code> while the new node group (shard) is being created.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_name(input);
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. </p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_maintenance_window(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. </p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The port number on which each of the cache nodes accepts connections.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port number on which each of the cache nodes accepts connections.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p> <note>
        /// <p>The Amazon SNS topic owner must be the same as the cluster owner.</p>
        /// </note>
        pub fn notification_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_topic_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p> <note>
        /// <p>The Amazon SNS topic owner must be the same as the cluster owner.</p>
        /// </note>
        pub fn set_notification_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_topic_arn(input);
            self
        }
        /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(input);
            self
        }
        /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5 days before being deleted.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        /// <p>Default: 0 (i.e., automatic backups are disabled for this cache cluster).</p>
        pub fn snapshot_retention_limit(mut self, input: i32) -> Self {
            self.inner = self.inner.snapshot_retention_limit(input);
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5 days before being deleted.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        /// <p>Default: 0 (i.e., automatic backups are disabled for this cache cluster).</p>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_snapshot_retention_limit(input);
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).</p>
        /// <p>Example: <code>05:00-09:00</code> </p>
        /// <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        pub fn snapshot_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_window(input.into());
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).</p>
        /// <p>Example: <code>05:00-09:00</code> </p>
        /// <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p> <note>
        /// <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p>
        /// </note>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_window(input);
            self
        }
        /// <p> <b>Reserved parameter.</b> The password used to access a password protected server.</p>
        /// <p>Password constraints:</p>
        /// <ul>
        /// <li> <p>Must be only printable ASCII characters.</p> </li>
        /// <li> <p>Must be at least 16 characters and no more than 128 characters in length.</p> </li>
        /// <li> <p>The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special characters cannot be used in the AUTH token.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at http://redis.io/commands/AUTH.</p>
        pub fn auth_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auth_token(input.into());
            self
        }
        /// <p> <b>Reserved parameter.</b> The password used to access a password protected server.</p>
        /// <p>Password constraints:</p>
        /// <ul>
        /// <li> <p>Must be only printable ASCII characters.</p> </li>
        /// <li> <p>Must be at least 16 characters and no more than 128 characters in length.</p> </li>
        /// <li> <p>The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special characters cannot be used in the AUTH token.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at http://redis.io/commands/AUTH.</p>
        pub fn set_auth_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_auth_token(input);
            self
        }
        /// <p>Specifies whether the nodes in the cluster are created in a single outpost or across multiple outposts.</p>
        pub fn outpost_mode(mut self, input: crate::model::OutpostMode) -> Self {
            self.inner = self.inner.outpost_mode(input);
            self
        }
        /// <p>Specifies whether the nodes in the cluster are created in a single outpost or across multiple outposts.</p>
        pub fn set_outpost_mode(
            mut self,
            input: std::option::Option<crate::model::OutpostMode>,
        ) -> Self {
            self.inner = self.inner.set_outpost_mode(input);
            self
        }
        /// <p>The outpost ARN in which the cache cluster is created.</p>
        pub fn preferred_outpost_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_outpost_arn(input.into());
            self
        }
        /// <p>The outpost ARN in which the cache cluster is created.</p>
        pub fn set_preferred_outpost_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_outpost_arn(input);
            self
        }
        /// Appends an item to `PreferredOutpostArns`.
        ///
        /// To override the contents of this collection use [`set_preferred_outpost_arns`](Self::set_preferred_outpost_arns).
        ///
        /// <p>The outpost ARNs in which the cache cluster is created.</p>
        pub fn preferred_outpost_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_outpost_arns(input.into());
            self
        }
        /// <p>The outpost ARNs in which the cache cluster is created.</p>
        pub fn set_preferred_outpost_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_preferred_outpost_arns(input);
            self
        }
        /// Appends an item to `LogDeliveryConfigurations`.
        ///
        /// To override the contents of this collection use [`set_log_delivery_configurations`](Self::set_log_delivery_configurations).
        ///
        /// <p>Specifies the destination, format and type of the logs. </p>
        pub fn log_delivery_configurations(
            mut self,
            input: crate::model::LogDeliveryConfigurationRequest,
        ) -> Self {
            self.inner = self.inner.log_delivery_configurations(input);
            self
        }
        /// <p>Specifies the destination, format and type of the logs. </p>
        pub fn set_log_delivery_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LogDeliveryConfigurationRequest>,
            >,
        ) -> Self {
            self.inner = self.inner.set_log_delivery_configurations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCacheParameterGroup`.
    ///
    /// <p>Creates a new Amazon ElastiCache cache parameter group. An ElastiCache cache parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster or replication group using the CacheParameterGroup.</p>
    /// <p>A newly created CacheParameterGroup is an exact duplicate of the default parameter group for the CacheParameterGroupFamily. To customize the newly created CacheParameterGroup you can change the values of specific parameters. For more information, see:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheParameterGroup.html">ModifyCacheParameterGroup</a> in the ElastiCache API Reference.</p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ParameterGroups.html">Parameters and Parameter Groups</a> in the ElastiCache User Guide.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCacheParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cache_parameter_group_input::Builder,
    }
    impl CreateCacheParameterGroup {
        /// Creates a new `CreateCacheParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCacheParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCacheParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-specified name for the cache parameter group.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_parameter_group_name(input.into());
            self
        }
        /// <p>A user-specified name for the cache parameter group.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_parameter_group_name(input);
            self
        }
        /// <p>The name of the cache parameter group family that the cache parameter group can be used with.</p>
        /// <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> </p>
        pub fn cache_parameter_group_family(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cache_parameter_group_family(input.into());
            self
        }
        /// <p>The name of the cache parameter group family that the cache parameter group can be used with.</p>
        /// <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> </p>
        pub fn set_cache_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_parameter_group_family(input);
            self
        }
        /// <p>A user-specified description for the cache parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A user-specified description for the cache parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCacheSecurityGroup`.
    ///
    /// <p>Creates a new cache security group. Use a cache security group to control access to one or more clusters.</p>
    /// <p>Cache security groups are only used when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC). If you are creating a cluster inside of a VPC, use a cache subnet group instead. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSubnetGroup.html">CreateCacheSubnetGroup</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCacheSecurityGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cache_security_group_input::Builder,
    }
    impl CreateCacheSecurityGroup {
        /// Creates a new `CreateCacheSecurityGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCacheSecurityGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCacheSecurityGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the cache security group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters. Cannot be the word "Default".</p>
        /// <p>Example: <code>mysecuritygroup</code> </p>
        pub fn cache_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_security_group_name(input.into());
            self
        }
        /// <p>A name for the cache security group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters. Cannot be the word "Default".</p>
        /// <p>Example: <code>mysecuritygroup</code> </p>
        pub fn set_cache_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_security_group_name(input);
            self
        }
        /// <p>A description for the cache security group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the cache security group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCacheSubnetGroup`.
    ///
    /// <p>Creates a new cache subnet group.</p>
    /// <p>Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCacheSubnetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cache_subnet_group_input::Builder,
    }
    impl CreateCacheSubnetGroup {
        /// Creates a new `CreateCacheSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCacheSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCacheSubnetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the cache subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>
        /// <p>Example: <code>mysubnetgroup</code> </p>
        pub fn cache_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_subnet_group_name(input.into());
            self
        }
        /// <p>A name for the cache subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>
        /// <p>Example: <code>mysubnetgroup</code> </p>
        pub fn set_cache_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_subnet_group_name(input);
            self
        }
        /// <p>A description for the cache subnet group.</p>
        pub fn cache_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cache_subnet_group_description(input.into());
            self
        }
        /// <p>A description for the cache subnet group.</p>
        pub fn set_cache_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_subnet_group_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of VPC subnet IDs for the cache subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>A list of VPC subnet IDs for the cache subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGlobalReplicationGroup`.
    ///
    /// <p>Global Datastore for Redis offers fully managed, fast, reliable and secure cross-region replication. Using Global Datastore for Redis, you can create cross-region read replica clusters for ElastiCache for Redis to enable low-latency reads and disaster recovery across regions. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastore.html">Replication Across Regions Using Global Datastore</a>. </p>
    /// <ul>
    /// <li> <p>The <b>GlobalReplicationGroupIdSuffix</b> is the name of the Global datastore.</p> </li>
    /// <li> <p>The <b>PrimaryReplicationGroupId</b> represents the name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGlobalReplicationGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_global_replication_group_input::Builder,
    }
    impl CreateGlobalReplicationGroup {
        /// Creates a new `CreateGlobalReplicationGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGlobalReplicationGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGlobalReplicationGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The suffix name of a Global datastore. Amazon ElastiCache automatically applies a prefix to the Global datastore ID when it is created. Each Amazon Region has its own prefix. For instance, a Global datastore ID created in the US-West-1 region will begin with "dsdfu" along with the suffix name you provide. The suffix, combined with the auto-generated prefix, guarantees uniqueness of the Global datastore name across multiple regions. </p>
        /// <p>For a full list of Amazon Regions and their respective Global datastore iD prefixes, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastores-CLI.html">Using the Amazon CLI with Global datastores </a>.</p>
        pub fn global_replication_group_id_suffix(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.global_replication_group_id_suffix(input.into());
            self
        }
        /// <p>The suffix name of a Global datastore. Amazon ElastiCache automatically applies a prefix to the Global datastore ID when it is created. Each Amazon Region has its own prefix. For instance, a Global datastore ID created in the US-West-1 region will begin with "dsdfu" along with the suffix name you provide. The suffix, combined with the auto-generated prefix, guarantees uniqueness of the Global datastore name across multiple regions. </p>
        /// <p>For a full list of Amazon Regions and their respective Global datastore iD prefixes, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastores-CLI.html">Using the Amazon CLI with Global datastores </a>.</p>
        pub fn set_global_replication_group_id_suffix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_replication_group_id_suffix(input);
            self
        }
        /// <p>Provides details of the Global datastore</p>
        pub fn global_replication_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .global_replication_group_description(input.into());
            self
        }
        /// <p>Provides details of the Global datastore</p>
        pub fn set_global_replication_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_replication_group_description(input);
            self
        }
        /// <p>The name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.</p>
        pub fn primary_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.primary_replication_group_id(input.into());
            self
        }
        /// <p>The name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.</p>
        pub fn set_primary_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_primary_replication_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReplicationGroup`.
    ///
    /// <p>Creates a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group.</p>
    /// <p>This API can be used to create a standalone regional replication group or a secondary replication group associated with a Global datastore.</p>
    /// <p>A Redis (cluster mode disabled) replication group is a collection of clusters, where one of the clusters is a read/write primary and the others are read-only replicas. Writes to the primary are asynchronously propagated to the replicas.</p>
    /// <p>A Redis cluster-mode enabled cluster is comprised of from 1 to 90 shards (API/CLI: node groups). Each shard has a primary node and up to 5 read-only replica nodes. The configuration can range from 90 shards and 0 replicas to 15 shards and 5 replicas, which is the maximum number or replicas allowed. </p>
    /// <p>The node or shard limit can be increased to a maximum of 500 per cluster if the Redis engine version is 5.0.6 or higher. For example, you can choose to configure a 500 node cluster that ranges between 83 shards (one primary and 5 replicas per shard) and 500 shards (single primary and no replicas). Make sure there are enough available IP addresses to accommodate the increase. Common pitfalls include the subnets in the subnet group have too small a CIDR range or the subnets are shared and heavily used by other clusters. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.Creating.html">Creating a Subnet Group</a>. For versions below 5.0.6, the limit is 250 per cluster.</p>
    /// <p>To request a limit increase, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">Amazon Service Limits</a> and choose the limit type <b>Nodes per cluster per instance type</b>. </p>
    /// <p>When a Redis (cluster mode disabled) replication group has been successfully created, you can add one or more read replicas to it, up to a total of 5 read replicas. If you need to increase or decrease the number of node groups (console: shards), you can avail yourself of ElastiCache for Redis' scaling. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Scaling.html">Scaling ElastiCache for Redis Clusters</a> in the <i>ElastiCache User Guide</i>.</p> <note>
    /// <p>This operation is valid for Redis only.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReplicationGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_replication_group_input::Builder,
    }
    impl CreateReplicationGroup {
        /// Creates a new `CreateReplicationGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReplicationGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReplicationGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The replication group identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>A name must contain from 1 to 40 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>The first character must be a letter.</p> </li>
        /// <li> <p>A name cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_id(input.into());
            self
        }
        /// <p>The replication group identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>A name must contain from 1 to 40 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>The first character must be a letter.</p> </li>
        /// <li> <p>A name cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_id(input);
            self
        }
        /// <p>A user-created description for the replication group.</p>
        pub fn replication_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_group_description(input.into());
            self
        }
        /// <p>A user-created description for the replication group.</p>
        pub fn set_replication_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_description(input);
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.global_replication_group_id(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_replication_group_id(input);
            self
        }
        /// <p>The identifier of the cluster that serves as the primary for this replication group. This cluster must already exist and have a status of <code>available</code>.</p>
        /// <p>This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or <code>ReplicasPerNodeGroup</code> is specified.</p>
        pub fn primary_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.primary_cluster_id(input.into());
            self
        }
        /// <p>The identifier of the cluster that serves as the primary for this replication group. This cluster must already exist and have a status of <code>available</code>.</p>
        /// <p>This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or <code>ReplicasPerNodeGroup</code> is specified.</p>
        pub fn set_primary_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_primary_cluster_id(input);
            self
        }
        /// <p>Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.</p>
        /// <p> <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.</p>
        /// <p>Default: false</p>
        pub fn automatic_failover_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.automatic_failover_enabled(input);
            self
        }
        /// <p>Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.</p>
        /// <p> <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.</p>
        /// <p>Default: false</p>
        pub fn set_automatic_failover_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_automatic_failover_enabled(input);
            self
        }
        /// <p>A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a>.</p>
        pub fn multi_az_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.multi_az_enabled(input);
            self
        }
        /// <p>A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a>.</p>
        pub fn set_multi_az_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_multi_az_enabled(input);
            self
        }
        /// <p>The number of clusters this replication group initially has.</p>
        /// <p>This parameter is not used if there is more than one node group (shard). You should use <code>ReplicasPerNodeGroup</code> instead.</p>
        /// <p>If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1), or you can explicitly set it to a value between 2 and 6.</p>
        /// <p>The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).</p>
        pub fn num_cache_clusters(mut self, input: i32) -> Self {
            self.inner = self.inner.num_cache_clusters(input);
            self
        }
        /// <p>The number of clusters this replication group initially has.</p>
        /// <p>This parameter is not used if there is more than one node group (shard). You should use <code>ReplicasPerNodeGroup</code> instead.</p>
        /// <p>If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1), or you can explicitly set it to a value between 2 and 6.</p>
        /// <p>The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).</p>
        pub fn set_num_cache_clusters(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_num_cache_clusters(input);
            self
        }
        /// Appends an item to `PreferredCacheClusterAZs`.
        ///
        /// To override the contents of this collection use [`set_preferred_cache_cluster_a_zs`](Self::set_preferred_cache_cluster_a_zs).
        ///
        /// <p>A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in the first AZ in the list.</p>
        /// <p>This parameter is not used if there is more than one node group (shard). You should use <code>NodeGroupConfiguration</code> instead.</p> <note>
        /// <p>If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in Availability Zones associated with the subnets in the selected subnet group.</p>
        /// <p>The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.</p>
        /// </note>
        /// <p>Default: system chosen Availability Zones.</p>
        pub fn preferred_cache_cluster_a_zs(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_cache_cluster_a_zs(input.into());
            self
        }
        /// <p>A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in the first AZ in the list.</p>
        /// <p>This parameter is not used if there is more than one node group (shard). You should use <code>NodeGroupConfiguration</code> instead.</p> <note>
        /// <p>If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in Availability Zones associated with the subnets in the selected subnet group.</p>
        /// <p>The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.</p>
        /// </note>
        /// <p>Default: system chosen Availability Zones.</p>
        pub fn set_preferred_cache_cluster_a_zs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_preferred_cache_cluster_a_zs(input);
            self
        }
        /// <p>An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled) replication group. For Redis (cluster mode disabled) either omit this parameter or set it to 1.</p>
        /// <p>Default: 1</p>
        pub fn num_node_groups(mut self, input: i32) -> Self {
            self.inner = self.inner.num_node_groups(input);
            self
        }
        /// <p>An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled) replication group. For Redis (cluster mode disabled) either omit this parameter or set it to 1.</p>
        /// <p>Default: 1</p>
        pub fn set_num_node_groups(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_num_node_groups(input);
            self
        }
        /// <p>An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values are 0 to 5.</p>
        pub fn replicas_per_node_group(mut self, input: i32) -> Self {
            self.inner = self.inner.replicas_per_node_group(input);
            self
        }
        /// <p>An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values are 0 to 5.</p>
        pub fn set_replicas_per_node_group(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_replicas_per_node_group(input);
            self
        }
        /// Appends an item to `NodeGroupConfiguration`.
        ///
        /// To override the contents of this collection use [`set_node_group_configuration`](Self::set_node_group_configuration).
        ///
        /// <p>A list of node group (shard) configuration options. Each node group (shard) configuration has the following members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>, <code>ReplicaCount</code>, and <code>Slots</code>.</p>
        /// <p>If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you can use this parameter to individually configure each node group (shard), or you can omit this parameter. However, it is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You must configure each node group (shard) using this parameter because you must specify the slots for each node group.</p>
        pub fn node_group_configuration(
            mut self,
            input: crate::model::NodeGroupConfiguration,
        ) -> Self {
            self.inner = self.inner.node_group_configuration(input);
            self
        }
        /// <p>A list of node group (shard) configuration options. Each node group (shard) configuration has the following members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>, <code>ReplicaCount</code>, and <code>Slots</code>.</p>
        /// <p>If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you can use this parameter to individually configure each node group (shard), or you can omit this parameter. However, it is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You must configure each node group (shard) using this parameter because you must specify the slots for each node group.</p>
        pub fn set_node_group_configuration(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NodeGroupConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_node_group_configuration(input);
            self
        }
        /// <p>The compute and memory capacity of the nodes in the node group (shard).</p>
        /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li> <p>General purpose:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Compute optimized:</p>
        /// <ul>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p> <b>Additional node type info</b> </p>
        /// <ul>
        /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
        /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
        /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
        /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
        /// </ul>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_node_type(input.into());
            self
        }
        /// <p>The compute and memory capacity of the nodes in the node group (shard).</p>
        /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li> <p>General purpose:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Compute optimized:</p>
        /// <ul>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p> <b>Additional node type info</b> </p>
        /// <ul>
        /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
        /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
        /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
        /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
        /// </ul>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_node_type(input);
            self
        }
        /// <p>The name of the cache engine to be used for the clusters in this replication group. Must be Redis.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(input.into());
            self
        }
        /// <p>The name of the cache engine to be used for the clusters in this replication group. Must be Redis.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The version number of the cache engine to be used for the clusters in this replication group. To view the supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.</p>
        /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version. </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The version number of the cache engine to be used for the clusters in this replication group. To view the supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.</p>
        /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version. </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used.</p>
        /// <p>If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter group, we recommend that you specify the parameter group by name. </p>
        /// <ul>
        /// <li> <p>To create a Redis (cluster mode disabled) replication group, use <code>CacheParameterGroupName=default.redis3.2</code>.</p> </li>
        /// <li> <p>To create a Redis (cluster mode enabled) replication group, use <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.</p> </li>
        /// </ul>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used.</p>
        /// <p>If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter group, we recommend that you specify the parameter group by name. </p>
        /// <ul>
        /// <li> <p>To create a Redis (cluster mode disabled) replication group, use <code>CacheParameterGroupName=default.redis3.2</code>.</p> </li>
        /// <li> <p>To create a Redis (cluster mode enabled) replication group, use <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.</p> </li>
        /// </ul>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_parameter_group_name(input);
            self
        }
        /// <p>The name of the cache subnet group to be used for the replication group.</p> <important>
        /// <p>If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet Groups</a>.</p>
        /// </important>
        pub fn cache_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_subnet_group_name(input.into());
            self
        }
        /// <p>The name of the cache subnet group to be used for the replication group.</p> <important>
        /// <p>If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet Groups</a>.</p>
        /// </important>
        pub fn set_cache_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_subnet_group_name(input);
            self
        }
        /// Appends an item to `CacheSecurityGroupNames`.
        ///
        /// To override the contents of this collection use [`set_cache_security_group_names`](Self::set_cache_security_group_names).
        ///
        /// <p>A list of cache security group names to associate with this replication group.</p>
        pub fn cache_security_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_security_group_names(input.into());
            self
        }
        /// <p>A list of cache security group names to associate with this replication group.</p>
        pub fn set_cache_security_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cache_security_group_names(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>One or more Amazon VPC security groups associated with this replication group.</p>
        /// <p>Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>One or more Amazon VPC security groups associated with this replication group.</p>
        /// <p>Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=<code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=<code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=<code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=<code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=<code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=<code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `SnapshotArns`.
        ///
        /// To override the contents of this collection use [`set_snapshot_arns`](Self::set_snapshot_arns).
        ///
        /// <p>A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot contain any commas. The new replication group will have the number of node groups (console: shards) specified by the parameter <i>NumNodeGroups</i> or the number of node groups configured by <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.</p>
        /// <p>Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code> </p>
        pub fn snapshot_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_arns(input.into());
            self
        }
        /// <p>A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot contain any commas. The new replication group will have the number of node groups (console: shards) specified by the parameter <i>NumNodeGroups</i> or the number of node groups configured by <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.</p>
        /// <p>Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code> </p>
        pub fn set_snapshot_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_arns(input);
            self
        }
        /// <p>The name of a snapshot from which to restore data into the new replication group. The snapshot status changes to <code>restoring</code> while the new replication group is being created.</p>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_name(input.into());
            self
        }
        /// <p>The name of a snapshot from which to restore data into the new replication group. The snapshot status changes to <code>restoring</code> while the new replication group is being created.</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_name(input);
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for <code>ddd</code> are:</p>
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
        /// <p>Valid values for <code>ddd</code> are:</p>
        /// <ul>
        /// <li> <p> <code>sun</code> </p> </li>
        /// <li> <p> <code>mon</code> </p> </li>
        /// <li> <p> <code>tue</code> </p> </li>
        /// <li> <p> <code>wed</code> </p> </li>
        /// <li> <p> <code>thu</code> </p> </li>
        /// <li> <p> <code>fri</code> </p> </li>
        /// <li> <p> <code>sat</code> </p> </li>
        /// </ul>
        /// <p>Example: <code>sun:23:00-mon:01:30</code> </p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_maintenance_window(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for <code>ddd</code> are:</p>
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
        /// <p>Valid values for <code>ddd</code> are:</p>
        /// <ul>
        /// <li> <p> <code>sun</code> </p> </li>
        /// <li> <p> <code>mon</code> </p> </li>
        /// <li> <p> <code>tue</code> </p> </li>
        /// <li> <p> <code>wed</code> </p> </li>
        /// <li> <p> <code>thu</code> </p> </li>
        /// <li> <p> <code>fri</code> </p> </li>
        /// <li> <p> <code>sat</code> </p> </li>
        /// </ul>
        /// <p>Example: <code>sun:23:00-mon:01:30</code> </p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The port number on which each member of the replication group accepts connections.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port number on which each member of the replication group accepts connections.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p> <note>
        /// <p>The Amazon SNS topic owner must be the same as the cluster owner.</p>
        /// </note>
        pub fn notification_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_topic_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p> <note>
        /// <p>The Amazon SNS topic owner must be the same as the cluster owner.</p>
        /// </note>
        pub fn set_notification_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_topic_arn(input);
            self
        }
        /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(input);
            self
        }
        /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        /// <p>Default: 0 (i.e., automatic backups are disabled for this cluster).</p>
        pub fn snapshot_retention_limit(mut self, input: i32) -> Self {
            self.inner = self.inner.snapshot_retention_limit(input);
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        /// <p>Default: 0 (i.e., automatic backups are disabled for this cluster).</p>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_snapshot_retention_limit(input);
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).</p>
        /// <p>Example: <code>05:00-09:00</code> </p>
        /// <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p>
        pub fn snapshot_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_window(input.into());
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).</p>
        /// <p>Example: <code>05:00-09:00</code> </p>
        /// <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_window(input);
            self
        }
        /// <p> <b>Reserved parameter.</b> The password used to access a password protected server.</p>
        /// <p> <code>AuthToken</code> can be specified only on replication groups where <code>TransitEncryptionEnabled</code> is <code>true</code>.</p> <important>
        /// <p>For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.</p>
        /// </important>
        /// <p>Password constraints:</p>
        /// <ul>
        /// <li> <p>Must be only printable ASCII characters.</p> </li>
        /// <li> <p>Must be at least 16 characters and no more than 128 characters in length.</p> </li>
        /// <li> <p>The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special characters cannot be used in the AUTH token.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at http://redis.io/commands/AUTH.</p>
        pub fn auth_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auth_token(input.into());
            self
        }
        /// <p> <b>Reserved parameter.</b> The password used to access a password protected server.</p>
        /// <p> <code>AuthToken</code> can be specified only on replication groups where <code>TransitEncryptionEnabled</code> is <code>true</code>.</p> <important>
        /// <p>For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.</p>
        /// </important>
        /// <p>Password constraints:</p>
        /// <ul>
        /// <li> <p>Must be only printable ASCII characters.</p> </li>
        /// <li> <p>Must be at least 16 characters and no more than 128 characters in length.</p> </li>
        /// <li> <p>The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special characters cannot be used in the AUTH token.</p> </li>
        /// </ul>
        /// <p>For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at http://redis.io/commands/AUTH.</p>
        pub fn set_auth_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_auth_token(input);
            self
        }
        /// <p>A flag that enables in-transit encryption when set to <code>true</code>.</p>
        /// <p>You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to <code>true</code> when you create a cluster.</p>
        /// <p>This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is being created in an Amazon VPC.</p>
        /// <p>If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.</p>
        /// <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        /// <p>Default: <code>false</code> </p> <important>
        /// <p>For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.</p>
        /// </important>
        pub fn transit_encryption_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.transit_encryption_enabled(input);
            self
        }
        /// <p>A flag that enables in-transit encryption when set to <code>true</code>.</p>
        /// <p>You cannot modify the value of <code>TransitEncryptionEnabled</code> after the cluster is created. To enable in-transit encryption on a cluster you must set <code>TransitEncryptionEnabled</code> to <code>true</code> when you create a cluster.</p>
        /// <p>This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is being created in an Amazon VPC.</p>
        /// <p>If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.</p>
        /// <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        /// <p>Default: <code>false</code> </p> <important>
        /// <p>For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.</p>
        /// </important>
        pub fn set_transit_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_transit_encryption_enabled(input);
            self
        }
        /// <p>A flag that enables encryption at rest when set to <code>true</code>.</p>
        /// <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group. </p>
        /// <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn at_rest_encryption_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.at_rest_encryption_enabled(input);
            self
        }
        /// <p>A flag that enables encryption at rest when set to <code>true</code>.</p>
        /// <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group. </p>
        /// <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version <code>3.2.6</code>, <code>4.x</code> or later.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn set_at_rest_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_at_rest_encryption_enabled(input);
            self
        }
        /// <p>The ID of the KMS key used to encrypt the disk in the cluster.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The ID of the KMS key used to encrypt the disk in the cluster.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `UserGroupIds`.
        ///
        /// To override the contents of this collection use [`set_user_group_ids`](Self::set_user_group_ids).
        ///
        /// <p>The user group to associate with the replication group.</p>
        pub fn user_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_group_ids(input.into());
            self
        }
        /// <p>The user group to associate with the replication group.</p>
        pub fn set_user_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_group_ids(input);
            self
        }
        /// Appends an item to `LogDeliveryConfigurations`.
        ///
        /// To override the contents of this collection use [`set_log_delivery_configurations`](Self::set_log_delivery_configurations).
        ///
        /// <p>Specifies the destination, format and type of the logs.</p>
        pub fn log_delivery_configurations(
            mut self,
            input: crate::model::LogDeliveryConfigurationRequest,
        ) -> Self {
            self.inner = self.inner.log_delivery_configurations(input);
            self
        }
        /// <p>Specifies the destination, format and type of the logs.</p>
        pub fn set_log_delivery_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LogDeliveryConfigurationRequest>,
            >,
        ) -> Self {
            self.inner = self.inner.set_log_delivery_configurations(input);
            self
        }
        /// <p>Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.</p>
        pub fn data_tiering_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.data_tiering_enabled(input);
            self
        }
        /// <p>Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.</p>
        pub fn set_data_tiering_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_data_tiering_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSnapshot`.
    ///
    /// <p>Creates a copy of an entire cluster or replication group at a specific moment in time.</p> <note>
    /// <p>This operation is valid for Redis only.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_snapshot_input::Builder,
    }
    impl CreateSnapshot {
        /// Creates a new `CreateSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of an existing replication group. The snapshot is created from this replication group.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_id(input.into());
            self
        }
        /// <p>The identifier of an existing replication group. The snapshot is created from this replication group.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_id(input);
            self
        }
        /// <p>The identifier of an existing cluster. The snapshot is created from this cluster.</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_cluster_id(input.into());
            self
        }
        /// <p>The identifier of an existing cluster. The snapshot is created from this cluster.</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_cluster_id(input);
            self
        }
        /// <p>A name for the snapshot being created.</p>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_name(input.into());
            self
        }
        /// <p>A name for the snapshot being created.</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_name(input);
            self
        }
        /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The ID of the KMS key used to encrypt the snapshot.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUser`.
    ///
    /// <p>For Redis engine version 6.0 onwards: Creates a Redis user. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access Control (RBAC)</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_user_input::Builder,
    }
    impl CreateUser {
        /// Creates a new `CreateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The username of the user.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The username of the user.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The current supported value is Redis. </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(input.into());
            self
        }
        /// <p>The current supported value is Redis. </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// Appends an item to `Passwords`.
        ///
        /// To override the contents of this collection use [`set_passwords`](Self::set_passwords).
        ///
        /// <p>Passwords used for this user. You can create up to two passwords for each user.</p>
        pub fn passwords(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.passwords(input.into());
            self
        }
        /// <p>Passwords used for this user. You can create up to two passwords for each user.</p>
        pub fn set_passwords(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_passwords(input);
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn access_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_string(input.into());
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn set_access_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_string(input);
            self
        }
        /// <p>Indicates a password is not required for this user.</p>
        pub fn no_password_required(mut self, input: bool) -> Self {
            self.inner = self.inner.no_password_required(input);
            self
        }
        /// <p>Indicates a password is not required for this user.</p>
        pub fn set_no_password_required(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_no_password_required(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUserGroup`.
    ///
    /// <p>For Redis engine version 6.0 onwards: Creates a Redis user group. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access Control (RBAC)</a> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUserGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_user_group_input::Builder,
    }
    impl CreateUserGroup {
        /// Creates a new `CreateUserGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the user group.</p>
        pub fn user_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_group_id(input.into());
            self
        }
        /// <p>The ID of the user group.</p>
        pub fn set_user_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_group_id(input);
            self
        }
        /// <p>The current supported value is Redis. </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(input.into());
            self
        }
        /// <p>The current supported value is Redis. </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// Appends an item to `UserIds`.
        ///
        /// To override the contents of this collection use [`set_user_ids`](Self::set_user_ids).
        ///
        /// <p>The list of user IDs that belong to the user group.</p>
        pub fn user_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_ids(input.into());
            self
        }
        /// <p>The list of user IDs that belong to the user group.</p>
        pub fn set_user_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DecreaseNodeGroupsInGlobalReplicationGroup`.
    ///
    /// <p>Decreases the number of node groups in a Global datastore</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DecreaseNodeGroupsInGlobalReplicationGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::decrease_node_groups_in_global_replication_group_input::Builder,
    }
    impl DecreaseNodeGroupsInGlobalReplicationGroup {
        /// Creates a new `DecreaseNodeGroupsInGlobalReplicationGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DecreaseNodeGroupsInGlobalReplicationGroupOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.global_replication_group_id(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_replication_group_id(input);
            self
        }
        /// <p>The number of node groups (shards) that results from the modification of the shard configuration</p>
        pub fn node_group_count(mut self, input: i32) -> Self {
            self.inner = self.inner.node_group_count(input);
            self
        }
        /// <p>The number of node groups (shards) that results from the modification of the shard configuration</p>
        pub fn set_node_group_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_node_group_count(input);
            self
        }
        /// Appends an item to `GlobalNodeGroupsToRemove`.
        ///
        /// To override the contents of this collection use [`set_global_node_groups_to_remove`](Self::set_global_node_groups_to_remove).
        ///
        /// <p>If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. GlobalNodeGroupsToRemove is a list of NodeGroupIds to remove from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by GlobalNodeGroupsToRemove from the cluster. </p>
        pub fn global_node_groups_to_remove(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.global_node_groups_to_remove(input.into());
            self
        }
        /// <p>If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. GlobalNodeGroupsToRemove is a list of NodeGroupIds to remove from the cluster. ElastiCache for Redis will attempt to remove all node groups listed by GlobalNodeGroupsToRemove from the cluster. </p>
        pub fn set_global_node_groups_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_global_node_groups_to_remove(input);
            self
        }
        /// Appends an item to `GlobalNodeGroupsToRetain`.
        ///
        /// To override the contents of this collection use [`set_global_node_groups_to_retain`](Self::set_global_node_groups_to_retain).
        ///
        /// <p>If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. GlobalNodeGroupsToRetain is a list of NodeGroupIds to retain from the cluster. ElastiCache for Redis will attempt to retain all node groups listed by GlobalNodeGroupsToRetain from the cluster. </p>
        pub fn global_node_groups_to_retain(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.global_node_groups_to_retain(input.into());
            self
        }
        /// <p>If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. GlobalNodeGroupsToRetain is a list of NodeGroupIds to retain from the cluster. ElastiCache for Redis will attempt to retain all node groups listed by GlobalNodeGroupsToRetain from the cluster. </p>
        pub fn set_global_node_groups_to_retain(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_global_node_groups_to_retain(input);
            self
        }
        /// <p>Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for this parameter is true. </p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.inner = self.inner.apply_immediately(input);
            self
        }
        /// <p>Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for this parameter is true. </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_immediately(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DecreaseReplicaCount`.
    ///
    /// <p>Dynamically decreases the number of replicas in a Redis (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This operation is performed with no cluster down time.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DecreaseReplicaCount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::decrease_replica_count_input::Builder,
    }
    impl DecreaseReplicaCount {
        /// Creates a new `DecreaseReplicaCount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DecreaseReplicaCountOutput,
            aws_smithy_http::result::SdkError<crate::error::DecreaseReplicaCountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The id of the replication group from which you want to remove replica nodes.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_id(input.into());
            self
        }
        /// <p>The id of the replication group from which you want to remove replica nodes.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_id(input);
            self
        }
        /// <p>The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups.</p>
        /// <p>The minimum number of replicas in a shard or replication group is:</p>
        /// <ul>
        /// <li> <p>Redis (cluster mode disabled)</p>
        /// <ul>
        /// <li> <p>If Multi-AZ is enabled: 1</p> </li>
        /// <li> <p>If Multi-AZ is not enabled: 0</p> </li>
        /// </ul> </li>
        /// <li> <p>Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)</p> </li>
        /// </ul>
        pub fn new_replica_count(mut self, input: i32) -> Self {
            self.inner = self.inner.new_replica_count(input);
            self
        }
        /// <p>The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups.</p>
        /// <p>The minimum number of replicas in a shard or replication group is:</p>
        /// <ul>
        /// <li> <p>Redis (cluster mode disabled)</p>
        /// <ul>
        /// <li> <p>If Multi-AZ is enabled: 1</p> </li>
        /// <li> <p>If Multi-AZ is not enabled: 0</p> </li>
        /// </ul> </li>
        /// <li> <p>Redis (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)</p> </li>
        /// </ul>
        pub fn set_new_replica_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_new_replica_count(input);
            self
        }
        /// Appends an item to `ReplicaConfiguration`.
        ///
        /// To override the contents of this collection use [`set_replica_configuration`](Self::set_replica_configuration).
        ///
        /// <p>A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members: <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.</p>
        pub fn replica_configuration(mut self, input: crate::model::ConfigureShard) -> Self {
            self.inner = self.inner.replica_configuration(input);
            self
        }
        /// <p>A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members: <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.</p>
        pub fn set_replica_configuration(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigureShard>>,
        ) -> Self {
            self.inner = self.inner.set_replica_configuration(input);
            self
        }
        /// Appends an item to `ReplicasToRemove`.
        ///
        /// To override the contents of this collection use [`set_replicas_to_remove`](Self::set_replicas_to_remove).
        ///
        /// <p>A list of the node ids to remove from the replication group or node group (shard).</p>
        pub fn replicas_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replicas_to_remove(input.into());
            self
        }
        /// <p>A list of the node ids to remove from the replication group or node group (shard).</p>
        pub fn set_replicas_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_replicas_to_remove(input);
            self
        }
        /// <p>If <code>True</code>, the number of replica nodes is decreased immediately. <code>ApplyImmediately=False</code> is not currently supported.</p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.inner = self.inner.apply_immediately(input);
            self
        }
        /// <p>If <code>True</code>, the number of replica nodes is decreased immediately. <code>ApplyImmediately=False</code> is not currently supported.</p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_immediately(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCacheCluster`.
    ///
    /// <p>Deletes a previously provisioned cluster. <code>DeleteCacheCluster</code> deletes all associated cache nodes, node endpoints and the cluster itself. When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the cluster; you cannot cancel or revert this operation.</p>
    /// <p>This operation is not valid for:</p>
    /// <ul>
    /// <li> <p>Redis (cluster mode enabled) clusters</p> </li>
    /// <li> <p>Redis (cluster mode disabled) clusters</p> </li>
    /// <li> <p>A cluster that is the last read replica of a replication group</p> </li>
    /// <li> <p>A cluster that is the primary node of a replication group</p> </li>
    /// <li> <p>A node group (shard) that has Multi-AZ mode enabled</p> </li>
    /// <li> <p>A cluster from a Redis (cluster mode enabled) replication group</p> </li>
    /// <li> <p>A cluster that is not in the <code>available</code> state</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCacheCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_cache_cluster_input::Builder,
    }
    impl DeleteCacheCluster {
        /// Creates a new `DeleteCacheCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCacheClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCacheClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier for the cluster to be deleted. This parameter is not case sensitive.</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_cluster_id(input.into());
            self
        }
        /// <p>The cluster identifier for the cluster to be deleted. This parameter is not case sensitive.</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_cluster_id(input);
            self
        }
        /// <p>The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. ElastiCache creates the snapshot, and then deletes the cluster immediately afterward.</p>
        pub fn final_snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.final_snapshot_identifier(input.into());
            self
        }
        /// <p>The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. ElastiCache creates the snapshot, and then deletes the cluster immediately afterward.</p>
        pub fn set_final_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_final_snapshot_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCacheParameterGroup`.
    ///
    /// <p>Deletes the specified cache parameter group. You cannot delete a cache parameter group if it is associated with any cache clusters. You cannot delete the default cache parameter groups in your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCacheParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_cache_parameter_group_input::Builder,
    }
    impl DeleteCacheParameterGroup {
        /// Creates a new `DeleteCacheParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCacheParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCacheParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cache parameter group to delete.</p> <note>
        /// <p>The specified cache security group must not be associated with any clusters.</p>
        /// </note>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the cache parameter group to delete.</p> <note>
        /// <p>The specified cache security group must not be associated with any clusters.</p>
        /// </note>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_parameter_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCacheSecurityGroup`.
    ///
    /// <p>Deletes a cache security group.</p> <note>
    /// <p>You cannot delete a cache security group if it is associated with any clusters.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCacheSecurityGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_cache_security_group_input::Builder,
    }
    impl DeleteCacheSecurityGroup {
        /// Creates a new `DeleteCacheSecurityGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCacheSecurityGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCacheSecurityGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cache security group to delete.</p> <note>
        /// <p>You cannot delete the default security group.</p>
        /// </note>
        pub fn cache_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_security_group_name(input.into());
            self
        }
        /// <p>The name of the cache security group to delete.</p> <note>
        /// <p>You cannot delete the default security group.</p>
        /// </note>
        pub fn set_cache_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_security_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCacheSubnetGroup`.
    ///
    /// <p>Deletes a cache subnet group.</p> <note>
    /// <p>You cannot delete a default cache subnet group or one that is associated with any clusters.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCacheSubnetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_cache_subnet_group_input::Builder,
    }
    impl DeleteCacheSubnetGroup {
        /// Creates a new `DeleteCacheSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCacheSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCacheSubnetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cache subnet group to delete.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>
        pub fn cache_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_subnet_group_name(input.into());
            self
        }
        /// <p>The name of the cache subnet group to delete.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>
        pub fn set_cache_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_subnet_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGlobalReplicationGroup`.
    ///
    /// <p>Deleting a Global datastore is a two-step process: </p>
    /// <ul>
    /// <li> <p>First, you must <code>DisassociateGlobalReplicationGroup</code> to remove the secondary clusters in the Global datastore.</p> </li>
    /// <li> <p>Once the Global datastore contains only the primary cluster, you can use the <code>DeleteGlobalReplicationGroup</code> API to delete the Global datastore while retainining the primary cluster using <code>RetainPrimaryReplicationGroup=true</code>.</p> </li>
    /// </ul>
    /// <p>Since the Global Datastore has only a primary cluster, you can delete the Global Datastore while retaining the primary by setting <code>RetainPrimaryReplicationGroup=true</code>. The primary cluster is never deleted when deleting a Global Datastore. It can only be deleted when it no longer is associated with any Global Datastore.</p>
    /// <p>When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the selected resources; you cannot cancel or revert this operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGlobalReplicationGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_global_replication_group_input::Builder,
    }
    impl DeleteGlobalReplicationGroup {
        /// Creates a new `DeleteGlobalReplicationGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGlobalReplicationGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGlobalReplicationGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.global_replication_group_id(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_replication_group_id(input);
            self
        }
        /// <p>The primary replication group is retained as a standalone replication group. </p>
        pub fn retain_primary_replication_group(mut self, input: bool) -> Self {
            self.inner = self.inner.retain_primary_replication_group(input);
            self
        }
        /// <p>The primary replication group is retained as a standalone replication group. </p>
        pub fn set_retain_primary_replication_group(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_retain_primary_replication_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReplicationGroup`.
    ///
    /// <p>Deletes an existing replication group. By default, this operation deletes the entire replication group, including the primary/primaries and all of the read replicas. If the replication group has only one primary, you can optionally delete only the read replicas, while retaining the primary by setting <code>RetainPrimaryCluster=true</code>.</p>
    /// <p>When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the selected resources; you cannot cancel or revert this operation.</p> <note>
    /// <p>This operation is valid for Redis only.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReplicationGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_replication_group_input::Builder,
    }
    impl DeleteReplicationGroup {
        /// Creates a new `DeleteReplicationGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReplicationGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReplicationGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the cluster to be deleted. This parameter is not case sensitive.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_id(input.into());
            self
        }
        /// <p>The identifier for the cluster to be deleted. This parameter is not case sensitive.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_id(input);
            self
        }
        /// <p>If set to <code>true</code>, all of the read replicas are deleted, but the primary node is retained.</p>
        pub fn retain_primary_cluster(mut self, input: bool) -> Self {
            self.inner = self.inner.retain_primary_cluster(input);
            self
        }
        /// <p>If set to <code>true</code>, all of the read replicas are deleted, but the primary node is retained.</p>
        pub fn set_retain_primary_cluster(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_retain_primary_cluster(input);
            self
        }
        /// <p>The name of a final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster, rather than one of the replicas; this is to ensure that it captures the freshest data. After the final snapshot is taken, the replication group is immediately deleted.</p>
        pub fn final_snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.final_snapshot_identifier(input.into());
            self
        }
        /// <p>The name of a final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster, rather than one of the replicas; this is to ensure that it captures the freshest data. After the final snapshot is taken, the replication group is immediately deleted.</p>
        pub fn set_final_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_final_snapshot_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSnapshot`.
    ///
    /// <p>Deletes an existing snapshot. When you receive a successful response from this operation, ElastiCache immediately begins deleting the snapshot; you cannot cancel or revert this operation.</p> <note>
    /// <p>This operation is valid for Redis only.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_snapshot_input::Builder,
    }
    impl DeleteSnapshot {
        /// Creates a new `DeleteSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the snapshot to be deleted.</p>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_name(input.into());
            self
        }
        /// <p>The name of the snapshot to be deleted.</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUser`.
    ///
    /// <p>For Redis engine version 6.0 onwards: Deletes a user. The user will be removed from all user groups and in turn removed from all replication groups. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access Control (RBAC)</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_user_input::Builder,
    }
    impl DeleteUser {
        /// Creates a new `DeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserGroup`.
    ///
    /// <p>For Redis engine version 6.0 onwards: Deletes a user group. The user group must first be disassociated from the replication group before it can be deleted. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access Control (RBAC)</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUserGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_user_group_input::Builder,
    }
    impl DeleteUserGroup {
        /// Creates a new `DeleteUserGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the user group.</p>
        pub fn user_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_group_id(input.into());
            self
        }
        /// <p>The ID of the user group.</p>
        pub fn set_user_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCacheClusters`.
    ///
    /// <p>Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cache cluster if a cluster identifier is supplied.</p>
    /// <p>By default, abbreviated information about the clusters is returned. You can use the optional <i>ShowCacheNodeInfo</i> flag to retrieve detailed information about the cache nodes associated with the clusters. These details include the DNS address and port for the cache node endpoint.</p>
    /// <p>If the cluster is in the <i>creating</i> state, only cluster-level information is displayed until all of the nodes are successfully provisioned.</p>
    /// <p>If the cluster is in the <i>deleting</i> state, only cluster-level information is displayed.</p>
    /// <p>If cache nodes are currently being added to the cluster, node endpoint information and creation time for the additional nodes are not displayed until they are completely provisioned. When the cluster state is <i>available</i>, the cluster is ready for use.</p>
    /// <p>If cache nodes are currently being removed from the cluster, no endpoint information for the removed nodes is displayed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCacheClusters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cache_clusters_input::Builder,
    }
    impl DescribeCacheClusters {
        /// Creates a new `DescribeCacheClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCacheClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCacheClustersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeCacheClustersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeCacheClustersPaginator {
            crate::paginator::DescribeCacheClustersPaginator::new(self.handle, self.inner)
        }
        /// <p>The user-supplied cluster identifier. If this parameter is specified, only information about that specific cluster is returned. This parameter isn't case sensitive.</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_cluster_id(input.into());
            self
        }
        /// <p>The user-supplied cluster identifier. If this parameter is specified, only information about that specific cluster is returned. This parameter isn't case sensitive.</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_cluster_id(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>An optional flag that can be included in the <code>DescribeCacheCluster</code> request to retrieve information about the individual cache nodes.</p>
        pub fn show_cache_node_info(mut self, input: bool) -> Self {
            self.inner = self.inner.show_cache_node_info(input);
            self
        }
        /// <p>An optional flag that can be included in the <code>DescribeCacheCluster</code> request to retrieve information about the individual cache nodes.</p>
        pub fn set_show_cache_node_info(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_show_cache_node_info(input);
            self
        }
        /// <p>An optional flag that can be included in the <code>DescribeCacheCluster</code> request to show only nodes (API/CLI: clusters) that are not members of a replication group. In practice, this mean Memcached and single node Redis clusters.</p>
        pub fn show_cache_clusters_not_in_replication_groups(mut self, input: bool) -> Self {
            self.inner = self
                .inner
                .show_cache_clusters_not_in_replication_groups(input);
            self
        }
        /// <p>An optional flag that can be included in the <code>DescribeCacheCluster</code> request to show only nodes (API/CLI: clusters) that are not members of a replication group. In practice, this mean Memcached and single node Redis clusters.</p>
        pub fn set_show_cache_clusters_not_in_replication_groups(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self
                .inner
                .set_show_cache_clusters_not_in_replication_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCacheEngineVersions`.
    ///
    /// <p>Returns a list of the available cache engines and their versions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCacheEngineVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cache_engine_versions_input::Builder,
    }
    impl DescribeCacheEngineVersions {
        /// Creates a new `DescribeCacheEngineVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCacheEngineVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCacheEngineVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeCacheEngineVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeCacheEngineVersionsPaginator {
            crate::paginator::DescribeCacheEngineVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The cache engine to return. Valid values: <code>memcached</code> | <code>redis</code> </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(input.into());
            self
        }
        /// <p>The cache engine to return. Valid values: <code>memcached</code> | <code>redis</code> </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The cache engine version to return.</p>
        /// <p>Example: <code>1.4.14</code> </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The cache engine version to return.</p>
        /// <p>Example: <code>1.4.14</code> </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The name of a specific cache parameter group family to return details for.</p>
        /// <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis6.2</code> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 alphanumeric characters</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn cache_parameter_group_family(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cache_parameter_group_family(input.into());
            self
        }
        /// <p>The name of a specific cache parameter group family to return details for.</p>
        /// <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis6.2</code> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 alphanumeric characters</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn set_cache_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_parameter_group_family(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>If <code>true</code>, specifies that only the default version of the specified engine or engine and major version combination is to be returned.</p>
        pub fn default_only(mut self, input: bool) -> Self {
            self.inner = self.inner.default_only(input);
            self
        }
        /// <p>If <code>true</code>, specifies that only the default version of the specified engine or engine and major version combination is to be returned.</p>
        pub fn set_default_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_default_only(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCacheParameterGroups`.
    ///
    /// <p>Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list contains only the descriptions for that group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCacheParameterGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cache_parameter_groups_input::Builder,
    }
    impl DescribeCacheParameterGroups {
        /// Creates a new `DescribeCacheParameterGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCacheParameterGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCacheParameterGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeCacheParameterGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeCacheParameterGroupsPaginator {
            crate::paginator::DescribeCacheParameterGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of a specific cache parameter group to return details for.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_parameter_group_name(input.into());
            self
        }
        /// <p>The name of a specific cache parameter group to return details for.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_parameter_group_name(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCacheParameters`.
    ///
    /// <p>Returns the detailed parameter list for a particular cache parameter group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCacheParameters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cache_parameters_input::Builder,
    }
    impl DescribeCacheParameters {
        /// Creates a new `DescribeCacheParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCacheParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCacheParametersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeCacheParametersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeCacheParametersPaginator {
            crate::paginator::DescribeCacheParametersPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of a specific cache parameter group to return details for.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_parameter_group_name(input.into());
            self
        }
        /// <p>The name of a specific cache parameter group to return details for.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_parameter_group_name(input);
            self
        }
        /// <p>The parameter types to return.</p>
        /// <p>Valid values: <code>user</code> | <code>system</code> | <code>engine-default</code> </p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(input.into());
            self
        }
        /// <p>The parameter types to return.</p>
        /// <p>Valid values: <code>user</code> | <code>system</code> | <code>engine-default</code> </p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCacheSecurityGroups`.
    ///
    /// <p>Returns a list of cache security group descriptions. If a cache security group name is specified, the list contains only the description of that group. This applicable only when you have ElastiCache in Classic setup </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCacheSecurityGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cache_security_groups_input::Builder,
    }
    impl DescribeCacheSecurityGroups {
        /// Creates a new `DescribeCacheSecurityGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCacheSecurityGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCacheSecurityGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeCacheSecurityGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeCacheSecurityGroupsPaginator {
            crate::paginator::DescribeCacheSecurityGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the cache security group to return details for.</p>
        pub fn cache_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_security_group_name(input.into());
            self
        }
        /// <p>The name of the cache security group to return details for.</p>
        pub fn set_cache_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_security_group_name(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCacheSubnetGroups`.
    ///
    /// <p>Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache clusters now launch in VPC by default. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCacheSubnetGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cache_subnet_groups_input::Builder,
    }
    impl DescribeCacheSubnetGroups {
        /// Creates a new `DescribeCacheSubnetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCacheSubnetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCacheSubnetGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeCacheSubnetGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeCacheSubnetGroupsPaginator {
            crate::paginator::DescribeCacheSubnetGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the cache subnet group to return details for.</p>
        pub fn cache_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_subnet_group_name(input.into());
            self
        }
        /// <p>The name of the cache subnet group to return details for.</p>
        pub fn set_cache_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_subnet_group_name(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEngineDefaultParameters`.
    ///
    /// <p>Returns the default engine and system parameter information for the specified cache engine.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEngineDefaultParameters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_engine_default_parameters_input::Builder,
    }
    impl DescribeEngineDefaultParameters {
        /// Creates a new `DescribeEngineDefaultParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEngineDefaultParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEngineDefaultParametersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEngineDefaultParametersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEngineDefaultParametersPaginator {
            crate::paginator::DescribeEngineDefaultParametersPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the cache parameter group family.</p>
        /// <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis6.2</code> </p>
        pub fn cache_parameter_group_family(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cache_parameter_group_family(input.into());
            self
        }
        /// <p>The name of the cache parameter group family.</p>
        /// <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis6.2</code> </p>
        pub fn set_cache_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_parameter_group_family(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEvents`.
    ///
    /// <p>Returns events related to clusters, cache security groups, and cache parameter groups. You can obtain events specific to a particular cluster, cache security group, or cache parameter group by providing the name as a parameter.</p>
    /// <p>By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if necessary.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_events_input::Builder,
    }
    impl DescribeEvents {
        /// Creates a new `DescribeEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEventsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEventsPaginator {
            crate::paginator::DescribeEventsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, all sources are included in the response.</p>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_identifier(input.into());
            self
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, all sources are included in the response.</p>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_identifier(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.inner = self.inner.source_type(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format.</p>
        /// <p> <b>Example:</b> 2017-03-30T07:03:49.555Z</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format.</p>
        /// <p> <b>Example:</b> 2017-03-30T07:03:49.555Z</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format.</p>
        /// <p> <b>Example:</b> 2017-03-30T07:03:49.555Z</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format.</p>
        /// <p> <b>Example:</b> 2017-03-30T07:03:49.555Z</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The number of minutes worth of events to retrieve.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.inner = self.inner.duration(input);
            self
        }
        /// <p>The number of minutes worth of events to retrieve.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGlobalReplicationGroups`.
    ///
    /// <p>Returns information about a particular global replication group. If no identifier is specified, returns information about all Global datastores. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeGlobalReplicationGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_global_replication_groups_input::Builder,
    }
    impl DescribeGlobalReplicationGroups {
        /// Creates a new `DescribeGlobalReplicationGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGlobalReplicationGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGlobalReplicationGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeGlobalReplicationGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeGlobalReplicationGroupsPaginator {
            crate::paginator::DescribeGlobalReplicationGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.global_replication_group_id(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_replication_group_id(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Returns the list of members that comprise the Global datastore.</p>
        pub fn show_member_info(mut self, input: bool) -> Self {
            self.inner = self.inner.show_member_info(input);
            self
        }
        /// <p>Returns the list of members that comprise the Global datastore.</p>
        pub fn set_show_member_info(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_show_member_info(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationGroups`.
    ///
    /// <p>Returns information about a particular replication group. If no identifier is specified, <code>DescribeReplicationGroups</code> returns information about all replication groups.</p> <note>
    /// <p>This operation is valid for Redis only.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReplicationGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_replication_groups_input::Builder,
    }
    impl DescribeReplicationGroups {
        /// Creates a new `DescribeReplicationGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReplicationGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReplicationGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeReplicationGroupsPaginator {
            crate::paginator::DescribeReplicationGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier for the replication group to be described. This parameter is not case sensitive.</p>
        /// <p>If you do not specify this parameter, information about all replication groups is returned.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_id(input.into());
            self
        }
        /// <p>The identifier for the replication group to be described. This parameter is not case sensitive.</p>
        /// <p>If you do not specify this parameter, information about all replication groups is returned.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_id(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservedCacheNodes`.
    ///
    /// <p>Returns information about reserved cache nodes for this account, or about a specified reserved cache node.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReservedCacheNodes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_reserved_cache_nodes_input::Builder,
    }
    impl DescribeReservedCacheNodes {
        /// Creates a new `DescribeReservedCacheNodes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservedCacheNodesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReservedCacheNodesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReservedCacheNodesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeReservedCacheNodesPaginator {
            crate::paginator::DescribeReservedCacheNodesPaginator::new(self.handle, self.inner)
        }
        /// <p>The reserved cache node identifier filter value. Use this parameter to show only the reservation that matches the specified reservation ID.</p>
        pub fn reserved_cache_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reserved_cache_node_id(input.into());
            self
        }
        /// <p>The reserved cache node identifier filter value. Use this parameter to show only the reservation that matches the specified reservation ID.</p>
        pub fn set_reserved_cache_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_cache_node_id(input);
            self
        }
        /// <p>The offering identifier filter value. Use this parameter to show only purchased reservations matching the specified offering identifier.</p>
        pub fn reserved_cache_nodes_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.reserved_cache_nodes_offering_id(input.into());
            self
        }
        /// <p>The offering identifier filter value. Use this parameter to show only purchased reservations matching the specified offering identifier.</p>
        pub fn set_reserved_cache_nodes_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_cache_nodes_offering_id(input);
            self
        }
        /// <p>The cache node type filter value. Use this parameter to show only those reservations matching the specified cache node type.</p>
        /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li> <p>General purpose:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Compute optimized:</p>
        /// <ul>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p> <b>Additional node type info</b> </p>
        /// <ul>
        /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
        /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
        /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
        /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
        /// </ul>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_node_type(input.into());
            self
        }
        /// <p>The cache node type filter value. Use this parameter to show only those reservations matching the specified cache node type.</p>
        /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li> <p>General purpose:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Compute optimized:</p>
        /// <ul>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p> <b>Additional node type info</b> </p>
        /// <ul>
        /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
        /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
        /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
        /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
        /// </ul>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_node_type(input);
            self
        }
        /// <p>The duration filter value, specified in years or seconds. Use this parameter to show only reservations for this duration.</p>
        /// <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>
        pub fn duration(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.duration(input.into());
            self
        }
        /// <p>The duration filter value, specified in years or seconds. Use this parameter to show only reservations for this duration.</p>
        /// <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>
        pub fn set_duration(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// <p>The product description filter value. Use this parameter to show only those reservations matching the specified product description.</p>
        pub fn product_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_description(input.into());
            self
        }
        /// <p>The product description filter value. Use this parameter to show only those reservations matching the specified product description.</p>
        pub fn set_product_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_product_description(input);
            self
        }
        /// <p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type.</p>
        /// <p>Valid values: <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization"|"All Upfront"|"Partial Upfront"| "No Upfront"</code> </p>
        pub fn offering_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.offering_type(input.into());
            self
        }
        /// <p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type.</p>
        /// <p>Valid values: <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization"|"All Upfront"|"Partial Upfront"| "No Upfront"</code> </p>
        pub fn set_offering_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_offering_type(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservedCacheNodesOfferings`.
    ///
    /// <p>Lists available reserved cache node offerings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReservedCacheNodesOfferings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_reserved_cache_nodes_offerings_input::Builder,
    }
    impl DescribeReservedCacheNodesOfferings {
        /// Creates a new `DescribeReservedCacheNodesOfferings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservedCacheNodesOfferingsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeReservedCacheNodesOfferingsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReservedCacheNodesOfferingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeReservedCacheNodesOfferingsPaginator {
            crate::paginator::DescribeReservedCacheNodesOfferingsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p>
        /// <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>
        pub fn reserved_cache_nodes_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.reserved_cache_nodes_offering_id(input.into());
            self
        }
        /// <p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p>
        /// <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>
        pub fn set_reserved_cache_nodes_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_cache_nodes_offering_id(input);
            self
        }
        /// <p>The cache node type filter value. Use this parameter to show only the available offerings matching the specified cache node type.</p>
        /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li> <p>General purpose:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward) <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Compute optimized:</p>
        /// <ul>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p> <b>Additional node type info</b> </p>
        /// <ul>
        /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
        /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
        /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
        /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
        /// </ul>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_node_type(input.into());
            self
        }
        /// <p>The cache node type filter value. Use this parameter to show only the available offerings matching the specified cache node type.</p>
        /// <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p>
        /// <ul>
        /// <li> <p>General purpose:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>M6g node types:</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward) <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Compute optimized:</p>
        /// <ul>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized with data tiering:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6gd node types</b> (available only for Redis engine version 6.2 onward).</p> <p> <code>cache.r6gd.xlarge</code>, <code>cache.r6gd.2xlarge</code>, <code>cache.r6gd.4xlarge</code>, <code>cache.r6gd.8xlarge</code>, <code>cache.r6gd.12xlarge</code>, <code>cache.r6gd.16xlarge</code> </p> </li>
        /// </ul> </li>
        /// <li> <p>Memory optimized:</p>
        /// <ul>
        /// <li> <p>Current generation: </p> <p> <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).</p> <p> <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <note>
        /// <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p>
        /// </note> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li>
        /// <li> <p>Previous generation: (not recommended)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p> <b>Additional node type info</b> </p>
        /// <ul>
        /// <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li>
        /// <li> <p>Redis append-only files (AOF) are not supported for T1 or T2 instances.</p> </li>
        /// <li> <p>Redis Multi-AZ with automatic failover is not supported on T1 instances.</p> </li>
        /// <li> <p>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</p> </li>
        /// </ul>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_node_type(input);
            self
        }
        /// <p>Duration filter value, specified in years or seconds. Use this parameter to show only reservations for a given duration.</p>
        /// <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>
        pub fn duration(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.duration(input.into());
            self
        }
        /// <p>Duration filter value, specified in years or seconds. Use this parameter to show only reservations for a given duration.</p>
        /// <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>
        pub fn set_duration(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// <p>The product description filter value. Use this parameter to show only the available offerings matching the specified product description.</p>
        pub fn product_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_description(input.into());
            self
        }
        /// <p>The product description filter value. Use this parameter to show only the available offerings matching the specified product description.</p>
        pub fn set_product_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_product_description(input);
            self
        }
        /// <p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type.</p>
        /// <p>Valid Values: <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization" |"All Upfront"|"Partial Upfront"| "No Upfront"</code> </p>
        pub fn offering_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.offering_type(input.into());
            self
        }
        /// <p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type.</p>
        /// <p>Valid Values: <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization" |"All Upfront"|"Partial Upfront"| "No Upfront"</code> </p>
        pub fn set_offering_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_offering_type(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20; maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeServiceUpdates`.
    ///
    /// <p>Returns details of the service updates</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeServiceUpdates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_service_updates_input::Builder,
    }
    impl DescribeServiceUpdates {
        /// Creates a new `DescribeServiceUpdates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeServiceUpdatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeServiceUpdatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeServiceUpdatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeServiceUpdatesPaginator {
            crate::paginator::DescribeServiceUpdatesPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique ID of the service update</p>
        pub fn service_update_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_update_name(input.into());
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn set_service_update_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_update_name(input);
            self
        }
        /// Appends an item to `ServiceUpdateStatus`.
        ///
        /// To override the contents of this collection use [`set_service_update_status`](Self::set_service_update_status).
        ///
        /// <p>The status of the service update</p>
        pub fn service_update_status(mut self, input: crate::model::ServiceUpdateStatus) -> Self {
            self.inner = self.inner.service_update_status(input);
            self
        }
        /// <p>The status of the service update</p>
        pub fn set_service_update_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceUpdateStatus>>,
        ) -> Self {
            self.inner = self.inner.set_service_update_status(input);
            self
        }
        /// <p>The maximum number of records to include in the response</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSnapshots`.
    ///
    /// <p>Returns information about cluster or replication group snapshots. By default, <code>DescribeSnapshots</code> lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with a particular cache cluster.</p> <note>
    /// <p>This operation is valid for Redis only.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSnapshots {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_snapshots_input::Builder,
    }
    impl DescribeSnapshots {
        /// Creates a new `DescribeSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeSnapshotsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeSnapshotsPaginator {
            crate::paginator::DescribeSnapshotsPaginator::new(self.handle, self.inner)
        }
        /// <p>A user-supplied replication group identifier. If this parameter is specified, only snapshots associated with that specific replication group are described.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_id(input.into());
            self
        }
        /// <p>A user-supplied replication group identifier. If this parameter is specified, only snapshots associated with that specific replication group are described.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_id(input);
            self
        }
        /// <p>A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_cluster_id(input.into());
            self
        }
        /// <p>A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_cluster_id(input);
            self
        }
        /// <p>A user-supplied name of the snapshot. If this parameter is specified, only this snapshot are described.</p>
        pub fn snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_name(input.into());
            self
        }
        /// <p>A user-supplied name of the snapshot. If this parameter is specified, only this snapshot are described.</p>
        pub fn set_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_name(input);
            self
        }
        /// <p>If set to <code>system</code>, the output shows snapshots that were automatically created by ElastiCache. If set to <code>user</code> the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.</p>
        pub fn snapshot_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_source(input.into());
            self
        }
        /// <p>If set to <code>system</code>, the output shows snapshots that were automatically created by ElastiCache. If set to <code>user</code> the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.</p>
        pub fn set_snapshot_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_source(input);
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 50</p>
        /// <p>Constraints: minimum 20; maximum 50.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 50</p>
        /// <p>Constraints: minimum 20; maximum 50.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>A Boolean value which if true, the node group (shard) configuration is included in the snapshot description.</p>
        pub fn show_node_group_config(mut self, input: bool) -> Self {
            self.inner = self.inner.show_node_group_config(input);
            self
        }
        /// <p>A Boolean value which if true, the node group (shard) configuration is included in the snapshot description.</p>
        pub fn set_show_node_group_config(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_show_node_group_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUpdateActions`.
    ///
    /// <p>Returns details of the update actions </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUpdateActions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_update_actions_input::Builder,
    }
    impl DescribeUpdateActions {
        /// Creates a new `DescribeUpdateActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUpdateActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUpdateActionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeUpdateActionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeUpdateActionsPaginator {
            crate::paginator::DescribeUpdateActionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique ID of the service update</p>
        pub fn service_update_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_update_name(input.into());
            self
        }
        /// <p>The unique ID of the service update</p>
        pub fn set_service_update_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_update_name(input);
            self
        }
        /// Appends an item to `ReplicationGroupIds`.
        ///
        /// To override the contents of this collection use [`set_replication_group_ids`](Self::set_replication_group_ids).
        ///
        /// <p>The replication group IDs</p>
        pub fn replication_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_ids(input.into());
            self
        }
        /// <p>The replication group IDs</p>
        pub fn set_replication_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_ids(input);
            self
        }
        /// Appends an item to `CacheClusterIds`.
        ///
        /// To override the contents of this collection use [`set_cache_cluster_ids`](Self::set_cache_cluster_ids).
        ///
        /// <p>The cache cluster IDs</p>
        pub fn cache_cluster_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_cluster_ids(input.into());
            self
        }
        /// <p>The cache cluster IDs</p>
        pub fn set_cache_cluster_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cache_cluster_ids(input);
            self
        }
        /// <p>The Elasticache engine to which the update applies. Either Redis or Memcached </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(input.into());
            self
        }
        /// <p>The Elasticache engine to which the update applies. Either Redis or Memcached </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// Appends an item to `ServiceUpdateStatus`.
        ///
        /// To override the contents of this collection use [`set_service_update_status`](Self::set_service_update_status).
        ///
        /// <p>The status of the service update</p>
        pub fn service_update_status(mut self, input: crate::model::ServiceUpdateStatus) -> Self {
            self.inner = self.inner.service_update_status(input);
            self
        }
        /// <p>The status of the service update</p>
        pub fn set_service_update_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceUpdateStatus>>,
        ) -> Self {
            self.inner = self.inner.set_service_update_status(input);
            self
        }
        /// <p>The range of time specified to search for service updates that are in available status</p>
        pub fn service_update_time_range(mut self, input: crate::model::TimeRangeFilter) -> Self {
            self.inner = self.inner.service_update_time_range(input);
            self
        }
        /// <p>The range of time specified to search for service updates that are in available status</p>
        pub fn set_service_update_time_range(
            mut self,
            input: std::option::Option<crate::model::TimeRangeFilter>,
        ) -> Self {
            self.inner = self.inner.set_service_update_time_range(input);
            self
        }
        /// Appends an item to `UpdateActionStatus`.
        ///
        /// To override the contents of this collection use [`set_update_action_status`](Self::set_update_action_status).
        ///
        /// <p>The status of the update action.</p>
        pub fn update_action_status(mut self, input: crate::model::UpdateActionStatus) -> Self {
            self.inner = self.inner.update_action_status(input);
            self
        }
        /// <p>The status of the update action.</p>
        pub fn set_update_action_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateActionStatus>>,
        ) -> Self {
            self.inner = self.inner.set_update_action_status(input);
            self
        }
        /// <p>Dictates whether to include node level update status in the response </p>
        pub fn show_node_level_update_status(mut self, input: bool) -> Self {
            self.inner = self.inner.show_node_level_update_status(input);
            self
        }
        /// <p>Dictates whether to include node level update status in the response </p>
        pub fn set_show_node_level_update_status(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_show_node_level_update_status(input);
            self
        }
        /// <p>The maximum number of records to include in the response</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUserGroups`.
    ///
    /// <p>Returns a list of user groups.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUserGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_user_groups_input::Builder,
    }
    impl DescribeUserGroups {
        /// Creates a new `DescribeUserGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeUserGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeUserGroupsPaginator {
            crate::paginator::DescribeUserGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the user group.</p>
        pub fn user_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_group_id(input.into());
            self
        }
        /// <p>The ID of the user group.</p>
        pub fn set_user_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_group_id(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUsers`.
    ///
    /// <p>Returns a list of users.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUsers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_users_input::Builder,
    }
    impl DescribeUsers {
        /// Creates a new `DescribeUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUsersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeUsersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeUsersPaginator {
            crate::paginator::DescribeUsersPaginator::new(self.handle, self.inner)
        }
        /// <p>The Redis engine. </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(input.into());
            self
        }
        /// <p>The Redis engine. </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filter to determine the list of User IDs to return.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filter to determine the list of User IDs to return.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateGlobalReplicationGroup`.
    ///
    /// <p>Remove a secondary cluster from the Global datastore using the Global datastore name. The secondary cluster will no longer receive updates from the primary cluster, but will remain as a standalone cluster in that Amazon region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateGlobalReplicationGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_global_replication_group_input::Builder,
    }
    impl DisassociateGlobalReplicationGroup {
        /// Creates a new `DisassociateGlobalReplicationGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateGlobalReplicationGroupOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateGlobalReplicationGroupError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.global_replication_group_id(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_replication_group_id(input);
            self
        }
        /// <p>The name of the secondary cluster you wish to remove from the Global datastore</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_id(input.into());
            self
        }
        /// <p>The name of the secondary cluster you wish to remove from the Global datastore</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_id(input);
            self
        }
        /// <p>The Amazon region of secondary cluster you wish to remove from the Global datastore</p>
        pub fn replication_group_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_region(input.into());
            self
        }
        /// <p>The Amazon region of secondary cluster you wish to remove from the Global datastore</p>
        pub fn set_replication_group_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_region(input);
            self
        }
    }
    /// Fluent builder constructing a request to `FailoverGlobalReplicationGroup`.
    ///
    /// <p>Used to failover the primary region to a selected secondary region. The selected secondary region will become primary, and all other clusters will become secondary.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct FailoverGlobalReplicationGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::failover_global_replication_group_input::Builder,
    }
    impl FailoverGlobalReplicationGroup {
        /// Creates a new `FailoverGlobalReplicationGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::FailoverGlobalReplicationGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::FailoverGlobalReplicationGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.global_replication_group_id(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_replication_group_id(input);
            self
        }
        /// <p>The Amazon region of the primary cluster of the Global datastore</p>
        pub fn primary_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.primary_region(input.into());
            self
        }
        /// <p>The Amazon region of the primary cluster of the Global datastore</p>
        pub fn set_primary_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_primary_region(input);
            self
        }
        /// <p>The name of the primary replication group</p>
        pub fn primary_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.primary_replication_group_id(input.into());
            self
        }
        /// <p>The name of the primary replication group</p>
        pub fn set_primary_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_primary_replication_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `IncreaseNodeGroupsInGlobalReplicationGroup`.
    ///
    /// <p>Increase the number of node groups in the Global datastore</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct IncreaseNodeGroupsInGlobalReplicationGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::increase_node_groups_in_global_replication_group_input::Builder,
    }
    impl IncreaseNodeGroupsInGlobalReplicationGroup {
        /// Creates a new `IncreaseNodeGroupsInGlobalReplicationGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::IncreaseNodeGroupsInGlobalReplicationGroupOutput,
            aws_smithy_http::result::SdkError<
                crate::error::IncreaseNodeGroupsInGlobalReplicationGroupError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.global_replication_group_id(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_replication_group_id(input);
            self
        }
        /// <p>The number of node groups you wish to add</p>
        pub fn node_group_count(mut self, input: i32) -> Self {
            self.inner = self.inner.node_group_count(input);
            self
        }
        /// <p>The number of node groups you wish to add</p>
        pub fn set_node_group_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_node_group_count(input);
            self
        }
        /// Appends an item to `RegionalConfigurations`.
        ///
        /// To override the contents of this collection use [`set_regional_configurations`](Self::set_regional_configurations).
        ///
        /// <p>Describes the replication group IDs, the Amazon regions where they are stored and the shard configuration for each that comprise the Global datastore</p>
        pub fn regional_configurations(
            mut self,
            input: crate::model::RegionalConfiguration,
        ) -> Self {
            self.inner = self.inner.regional_configurations(input);
            self
        }
        /// <p>Describes the replication group IDs, the Amazon regions where they are stored and the shard configuration for each that comprise the Global datastore</p>
        pub fn set_regional_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegionalConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_regional_configurations(input);
            self
        }
        /// <p>Indicates that the process begins immediately. At present, the only permitted value for this parameter is true.</p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.inner = self.inner.apply_immediately(input);
            self
        }
        /// <p>Indicates that the process begins immediately. At present, the only permitted value for this parameter is true.</p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_immediately(input);
            self
        }
    }
    /// Fluent builder constructing a request to `IncreaseReplicaCount`.
    ///
    /// <p>Dynamically increases the number of replicas in a Redis (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This operation is performed with no cluster down time.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct IncreaseReplicaCount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::increase_replica_count_input::Builder,
    }
    impl IncreaseReplicaCount {
        /// Creates a new `IncreaseReplicaCount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::IncreaseReplicaCountOutput,
            aws_smithy_http::result::SdkError<crate::error::IncreaseReplicaCountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The id of the replication group to which you want to add replica nodes.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_id(input.into());
            self
        }
        /// <p>The id of the replication group to which you want to add replica nodes.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_id(input);
            self
        }
        /// <p>The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups.</p>
        pub fn new_replica_count(mut self, input: i32) -> Self {
            self.inner = self.inner.new_replica_count(input);
            self
        }
        /// <p>The number of read replica nodes you want at the completion of this operation. For Redis (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group's node groups.</p>
        pub fn set_new_replica_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_new_replica_count(input);
            self
        }
        /// Appends an item to `ReplicaConfiguration`.
        ///
        /// To override the contents of this collection use [`set_replica_configuration`](Self::set_replica_configuration).
        ///
        /// <p>A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members: <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.</p>
        pub fn replica_configuration(mut self, input: crate::model::ConfigureShard) -> Self {
            self.inner = self.inner.replica_configuration(input);
            self
        }
        /// <p>A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members: <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.</p>
        pub fn set_replica_configuration(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigureShard>>,
        ) -> Self {
            self.inner = self.inner.set_replica_configuration(input);
            self
        }
        /// <p>If <code>True</code>, the number of replica nodes is increased immediately. <code>ApplyImmediately=False</code> is not currently supported.</p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.inner = self.inner.apply_immediately(input);
            self
        }
        /// <p>If <code>True</code>, the number of replica nodes is increased immediately. <code>ApplyImmediately=False</code> is not currently supported.</p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_immediately(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAllowedNodeTypeModifications`.
    ///
    /// <p>Lists all available node types that you can scale your Redis cluster's or replication group's current node type.</p>
    /// <p>When you use the <code>ModifyCacheCluster</code> or <code>ModifyReplicationGroup</code> operations to scale your cluster or replication group, the value of the <code>CacheNodeType</code> parameter must be one of the node types returned by this operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAllowedNodeTypeModifications {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_allowed_node_type_modifications_input::Builder,
    }
    impl ListAllowedNodeTypeModifications {
        /// Creates a new `ListAllowedNodeTypeModifications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAllowedNodeTypeModificationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAllowedNodeTypeModificationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster you want to scale up to a larger node instanced type. ElastiCache uses the cluster id to identify the current node type of this cluster and from that to create a list of node types you can scale up to.</p> <important>
        /// <p>You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.</p>
        /// </important>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_cluster_id(input.into());
            self
        }
        /// <p>The name of the cluster you want to scale up to a larger node instanced type. ElastiCache uses the cluster id to identify the current node type of this cluster and from that to create a list of node types you can scale up to.</p> <important>
        /// <p>You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.</p>
        /// </important>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_cluster_id(input);
            self
        }
        /// <p>The name of the replication group want to scale up to a larger node type. ElastiCache uses the replication group id to identify the current node type being used by this replication group, and from that to create a list of node types you can scale up to.</p> <important>
        /// <p>You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.</p>
        /// </important>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_id(input.into());
            self
        }
        /// <p>The name of the replication group want to scale up to a larger node type. ElastiCache uses the replication group id to identify the current node type being used by this replication group, and from that to create a list of node types you can scale up to.</p> <important>
        /// <p>You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.</p>
        /// </important>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags currently on a named resource.</p>
    /// <p> A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html">Resource-level permissions</a>.</p>
    /// <p>If the cluster is not in the <i>available</i> state, <code>ListTagsForResource</code> returns an error.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want the list of tags, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want the list of tags, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyCacheCluster`.
    ///
    /// <p>Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration parameters by specifying the parameters and the new values.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyCacheCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_cache_cluster_input::Builder,
    }
    impl ModifyCacheCluster {
        /// Creates a new `ModifyCacheCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyCacheClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyCacheClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier. This value is stored as a lowercase string.</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_cluster_id(input.into());
            self
        }
        /// <p>The cluster identifier. This value is stored as a lowercase string.</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_cluster_id(input);
            self
        }
        /// <p>The number of cache nodes that the cluster should have. If the value for <code>NumCacheNodes</code> is greater than the sum of the number of current cache nodes and the number of cache nodes pending creation (which may be zero), more nodes are added. If the value is less than the number of existing cache nodes, nodes are removed. If the value is equal to the number of current cache nodes, any pending add or remove requests are canceled.</p>
        /// <p>If you are removing cache nodes, you must use the <code>CacheNodeIdsToRemove</code> parameter to provide the IDs of the specific cache nodes to remove.</p>
        /// <p>For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.</p> <note>
        /// <p>Adding or removing Memcached cache nodes can be applied immediately or as a pending operation (see <code>ApplyImmediately</code>).</p>
        /// <p>A pending operation to modify the number of cache nodes in a cluster during its maintenance window, whether by adding or removing nodes in accordance with the scale out architecture, is not queued. The customer's latest request to add or remove nodes to the cluster overrides any previous pending operations to modify the number of cache nodes in the cluster. For example, a request to remove 2 nodes would override a previous pending operation to remove 3 nodes. Similarly, a request to add 2 nodes would override a previous pending operation to remove 3 nodes and vice versa. As Memcached cache nodes may now be provisioned in different Availability Zones with flexible cache node placement, a request to add nodes does not automatically override a previous pending operation to add nodes. The customer can modify the previous pending operation to add more nodes or explicitly cancel the pending request and retry the new request. To cancel pending operations to modify the number of cache nodes in a cluster, use the <code>ModifyCacheCluster</code> request and set <code>NumCacheNodes</code> equal to the number of cache nodes currently in the cluster.</p>
        /// </note>
        pub fn num_cache_nodes(mut self, input: i32) -> Self {
            self.inner = self.inner.num_cache_nodes(input);
            self
        }
        /// <p>The number of cache nodes that the cluster should have. If the value for <code>NumCacheNodes</code> is greater than the sum of the number of current cache nodes and the number of cache nodes pending creation (which may be zero), more nodes are added. If the value is less than the number of existing cache nodes, nodes are removed. If the value is equal to the number of current cache nodes, any pending add or remove requests are canceled.</p>
        /// <p>If you are removing cache nodes, you must use the <code>CacheNodeIdsToRemove</code> parameter to provide the IDs of the specific cache nodes to remove.</p>
        /// <p>For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.</p> <note>
        /// <p>Adding or removing Memcached cache nodes can be applied immediately or as a pending operation (see <code>ApplyImmediately</code>).</p>
        /// <p>A pending operation to modify the number of cache nodes in a cluster during its maintenance window, whether by adding or removing nodes in accordance with the scale out architecture, is not queued. The customer's latest request to add or remove nodes to the cluster overrides any previous pending operations to modify the number of cache nodes in the cluster. For example, a request to remove 2 nodes would override a previous pending operation to remove 3 nodes. Similarly, a request to add 2 nodes would override a previous pending operation to remove 3 nodes and vice versa. As Memcached cache nodes may now be provisioned in different Availability Zones with flexible cache node placement, a request to add nodes does not automatically override a previous pending operation to add nodes. The customer can modify the previous pending operation to add more nodes or explicitly cancel the pending request and retry the new request. To cancel pending operations to modify the number of cache nodes in a cluster, use the <code>ModifyCacheCluster</code> request and set <code>NumCacheNodes</code> equal to the number of cache nodes currently in the cluster.</p>
        /// </note>
        pub fn set_num_cache_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_num_cache_nodes(input);
            self
        }
        /// Appends an item to `CacheNodeIdsToRemove`.
        ///
        /// To override the contents of this collection use [`set_cache_node_ids_to_remove`](Self::set_cache_node_ids_to_remove).
        ///
        /// <p>A list of cache node IDs to be removed. A node ID is a numeric identifier (0001, 0002, etc.). This parameter is only valid when <code>NumCacheNodes</code> is less than the existing number of cache nodes. The number of cache node IDs supplied in this parameter must match the difference between the existing number of cache nodes in the cluster or pending cache nodes, whichever is greater, and the value of <code>NumCacheNodes</code> in the request.</p>
        /// <p>For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of cache nodes in this <code>ModifyCacheCluster</code> call is 5, you must list 2 (7 - 5) cache node IDs to remove.</p>
        pub fn cache_node_ids_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_node_ids_to_remove(input.into());
            self
        }
        /// <p>A list of cache node IDs to be removed. A node ID is a numeric identifier (0001, 0002, etc.). This parameter is only valid when <code>NumCacheNodes</code> is less than the existing number of cache nodes. The number of cache node IDs supplied in this parameter must match the difference between the existing number of cache nodes in the cluster or pending cache nodes, whichever is greater, and the value of <code>NumCacheNodes</code> in the request.</p>
        /// <p>For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of cache nodes in this <code>ModifyCacheCluster</code> call is 5, you must list 2 (7 - 5) cache node IDs to remove.</p>
        pub fn set_cache_node_ids_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cache_node_ids_to_remove(input);
            self
        }
        /// <p>Specifies whether the new nodes in this Memcached cluster are all created in a single Availability Zone or created across multiple Availability Zones.</p>
        /// <p>Valid values: <code>single-az</code> | <code>cross-az</code>.</p>
        /// <p>This option is only supported for Memcached clusters.</p> <note>
        /// <p>You cannot specify <code>single-az</code> if the Memcached cluster already has cache nodes in different Availability Zones. If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone.</p>
        /// <p>Only newly created nodes are located in different Availability Zones. </p>
        /// </note>
        pub fn az_mode(mut self, input: crate::model::AzMode) -> Self {
            self.inner = self.inner.az_mode(input);
            self
        }
        /// <p>Specifies whether the new nodes in this Memcached cluster are all created in a single Availability Zone or created across multiple Availability Zones.</p>
        /// <p>Valid values: <code>single-az</code> | <code>cross-az</code>.</p>
        /// <p>This option is only supported for Memcached clusters.</p> <note>
        /// <p>You cannot specify <code>single-az</code> if the Memcached cluster already has cache nodes in different Availability Zones. If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone.</p>
        /// <p>Only newly created nodes are located in different Availability Zones. </p>
        /// </note>
        pub fn set_az_mode(mut self, input: std::option::Option<crate::model::AzMode>) -> Self {
            self.inner = self.inner.set_az_mode(input);
            self
        }
        /// Appends an item to `NewAvailabilityZones`.
        ///
        /// To override the contents of this collection use [`set_new_availability_zones`](Self::set_new_availability_zones).
        ///
        /// <note>
        /// <p>This option is only supported on Memcached clusters.</p>
        /// </note>
        /// <p>The list of Availability Zones where the new Memcached cache nodes are created.</p>
        /// <p>This parameter is only valid when <code>NumCacheNodes</code> in the request is greater than the sum of the number of active cache nodes and the number of cache nodes pending creation (which may be zero). The number of Availability Zones supplied in this list must match the cache nodes being added in this request.</p>
        /// <p>Scenarios:</p>
        /// <ul>
        /// <li> <p> <b>Scenario 1:</b> You have 3 active nodes and wish to add 2 nodes. Specify <code>NumCacheNodes=5</code> (3 + 2) and optionally specify two Availability Zones for the two new nodes.</p> </li>
        /// <li> <p> <b>Scenario 2:</b> You have 3 active nodes and 2 nodes pending creation (from the scenario 1 call) and want to add 1 more node. Specify <code>NumCacheNodes=6</code> ((3 + 2) + 1) and optionally specify an Availability Zone for the new node.</p> </li>
        /// <li> <p> <b>Scenario 3:</b> You want to cancel all pending operations. Specify <code>NumCacheNodes=3</code> to cancel all pending operations.</p> </li>
        /// </ul>
        /// <p>The Availability Zone placement of nodes pending creation cannot be modified. If you wish to cancel any nodes pending creation, add 0 nodes by setting <code>NumCacheNodes</code> to the number of current nodes.</p>
        /// <p>If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone. Only newly created nodes can be located in different Availability Zones. For guidance on how to move existing Memcached nodes to different Availability Zones, see the <b>Availability Zone Considerations</b> section of <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html">Cache Node Considerations for Memcached</a>.</p>
        /// <p> <b>Impact of new add/remove requests upon pending requests</b> </p>
        /// <ul>
        /// <li> <p>Scenario-1</p>
        /// <ul>
        /// <li> <p>Pending Action: Delete</p> </li>
        /// <li> <p>New Request: Delete</p> </li>
        /// <li> <p>Result: The new delete, pending or immediate, replaces the pending delete.</p> </li>
        /// </ul> </li>
        /// <li> <p>Scenario-2</p>
        /// <ul>
        /// <li> <p>Pending Action: Delete</p> </li>
        /// <li> <p>New Request: Create</p> </li>
        /// <li> <p>Result: The new create, pending or immediate, replaces the pending delete.</p> </li>
        /// </ul> </li>
        /// <li> <p>Scenario-3</p>
        /// <ul>
        /// <li> <p>Pending Action: Create</p> </li>
        /// <li> <p>New Request: Delete</p> </li>
        /// <li> <p>Result: The new delete, pending or immediate, replaces the pending create.</p> </li>
        /// </ul> </li>
        /// <li> <p>Scenario-4</p>
        /// <ul>
        /// <li> <p>Pending Action: Create</p> </li>
        /// <li> <p>New Request: Create</p> </li>
        /// <li> <p>Result: The new create is added to the pending create.</p> <important>
        /// <p> <b>Important:</b> If the new create request is <b>Apply Immediately - Yes</b>, all creates are performed immediately. If the new create request is <b>Apply Immediately - No</b>, all creates are pending.</p>
        /// </important> </li>
        /// </ul> </li>
        /// </ul>
        pub fn new_availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_availability_zones(input.into());
            self
        }
        /// <note>
        /// <p>This option is only supported on Memcached clusters.</p>
        /// </note>
        /// <p>The list of Availability Zones where the new Memcached cache nodes are created.</p>
        /// <p>This parameter is only valid when <code>NumCacheNodes</code> in the request is greater than the sum of the number of active cache nodes and the number of cache nodes pending creation (which may be zero). The number of Availability Zones supplied in this list must match the cache nodes being added in this request.</p>
        /// <p>Scenarios:</p>
        /// <ul>
        /// <li> <p> <b>Scenario 1:</b> You have 3 active nodes and wish to add 2 nodes. Specify <code>NumCacheNodes=5</code> (3 + 2) and optionally specify two Availability Zones for the two new nodes.</p> </li>
        /// <li> <p> <b>Scenario 2:</b> You have 3 active nodes and 2 nodes pending creation (from the scenario 1 call) and want to add 1 more node. Specify <code>NumCacheNodes=6</code> ((3 + 2) + 1) and optionally specify an Availability Zone for the new node.</p> </li>
        /// <li> <p> <b>Scenario 3:</b> You want to cancel all pending operations. Specify <code>NumCacheNodes=3</code> to cancel all pending operations.</p> </li>
        /// </ul>
        /// <p>The Availability Zone placement of nodes pending creation cannot be modified. If you wish to cancel any nodes pending creation, add 0 nodes by setting <code>NumCacheNodes</code> to the number of current nodes.</p>
        /// <p>If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone. Only newly created nodes can be located in different Availability Zones. For guidance on how to move existing Memcached nodes to different Availability Zones, see the <b>Availability Zone Considerations</b> section of <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html">Cache Node Considerations for Memcached</a>.</p>
        /// <p> <b>Impact of new add/remove requests upon pending requests</b> </p>
        /// <ul>
        /// <li> <p>Scenario-1</p>
        /// <ul>
        /// <li> <p>Pending Action: Delete</p> </li>
        /// <li> <p>New Request: Delete</p> </li>
        /// <li> <p>Result: The new delete, pending or immediate, replaces the pending delete.</p> </li>
        /// </ul> </li>
        /// <li> <p>Scenario-2</p>
        /// <ul>
        /// <li> <p>Pending Action: Delete</p> </li>
        /// <li> <p>New Request: Create</p> </li>
        /// <li> <p>Result: The new create, pending or immediate, replaces the pending delete.</p> </li>
        /// </ul> </li>
        /// <li> <p>Scenario-3</p>
        /// <ul>
        /// <li> <p>Pending Action: Create</p> </li>
        /// <li> <p>New Request: Delete</p> </li>
        /// <li> <p>Result: The new delete, pending or immediate, replaces the pending create.</p> </li>
        /// </ul> </li>
        /// <li> <p>Scenario-4</p>
        /// <ul>
        /// <li> <p>Pending Action: Create</p> </li>
        /// <li> <p>New Request: Create</p> </li>
        /// <li> <p>Result: The new create is added to the pending create.</p> <important>
        /// <p> <b>Important:</b> If the new create request is <b>Apply Immediately - Yes</b>, all creates are performed immediately. If the new create request is <b>Apply Immediately - No</b>, all creates are pending.</p>
        /// </important> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_new_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_new_availability_zones(input);
            self
        }
        /// Appends an item to `CacheSecurityGroupNames`.
        ///
        /// To override the contents of this collection use [`set_cache_security_group_names`](Self::set_cache_security_group_names).
        ///
        /// <p>A list of cache security group names to authorize on this cluster. This change is asynchronously applied as soon as possible.</p>
        /// <p>You can use this parameter only with clusters that are created outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters. Must not be "Default".</p>
        pub fn cache_security_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_security_group_names(input.into());
            self
        }
        /// <p>A list of cache security group names to authorize on this cluster. This change is asynchronously applied as soon as possible.</p>
        /// <p>You can use this parameter only with clusters that are created outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters. Must not be "Default".</p>
        pub fn set_cache_security_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cache_security_group_names(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>Specifies the VPC Security Groups associated with the cluster.</p>
        /// <p>This parameter can be used only with clusters that are created in an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>Specifies the VPC Security Groups associated with the cluster.</p>
        /// <p>This parameter can be used only with clusters that are created in an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
        /// <p>Valid values for <code>ddd</code> are:</p>
        /// <ul>
        /// <li> <p> <code>sun</code> </p> </li>
        /// <li> <p> <code>mon</code> </p> </li>
        /// <li> <p> <code>tue</code> </p> </li>
        /// <li> <p> <code>wed</code> </p> </li>
        /// <li> <p> <code>thu</code> </p> </li>
        /// <li> <p> <code>fri</code> </p> </li>
        /// <li> <p> <code>sat</code> </p> </li>
        /// </ul>
        /// <p>Example: <code>sun:23:00-mon:01:30</code> </p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_maintenance_window(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
        /// <p>Valid values for <code>ddd</code> are:</p>
        /// <ul>
        /// <li> <p> <code>sun</code> </p> </li>
        /// <li> <p> <code>mon</code> </p> </li>
        /// <li> <p> <code>tue</code> </p> </li>
        /// <li> <p> <code>wed</code> </p> </li>
        /// <li> <p> <code>thu</code> </p> </li>
        /// <li> <p> <code>fri</code> </p> </li>
        /// <li> <p> <code>sat</code> </p> </li>
        /// </ul>
        /// <p>Example: <code>sun:23:00-mon:01:30</code> </p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>
        /// <p>The Amazon SNS topic owner must be same as the cluster owner.</p>
        /// </note>
        pub fn notification_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_topic_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>
        /// <p>The Amazon SNS topic owner must be same as the cluster owner.</p>
        /// </note>
        pub fn set_notification_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_topic_arn(input);
            self
        }
        /// <p>The name of the cache parameter group to apply to this cluster. This change is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the cache parameter group to apply to this cluster. This change is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_parameter_group_name(input);
            self
        }
        /// <p>The status of the Amazon SNS notification topic. Notifications are sent only if the status is <code>active</code>.</p>
        /// <p>Valid values: <code>active</code> | <code>inactive</code> </p>
        pub fn notification_topic_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_topic_status(input.into());
            self
        }
        /// <p>The status of the Amazon SNS notification topic. Notifications are sent only if the status is <code>active</code>.</p>
        /// <p>Valid values: <code>active</code> | <code>inactive</code> </p>
        pub fn set_notification_topic_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_topic_status(input);
            self
        }
        /// <p>If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the cluster.</p>
        /// <p>If <code>false</code>, changes to the cluster are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.</p> <important>
        /// <p>If you perform a <code>ModifyCacheCluster</code> before a pending modification is applied, the pending modification is replaced by the newer modification.</p>
        /// </important>
        /// <p>Valid values: <code>true</code> | <code>false</code> </p>
        /// <p>Default: <code>false</code> </p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.inner = self.inner.apply_immediately(input);
            self
        }
        /// <p>If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the cluster.</p>
        /// <p>If <code>false</code>, changes to the cluster are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.</p> <important>
        /// <p>If you perform a <code>ModifyCacheCluster</code> before a pending modification is applied, the pending modification is replaced by the newer modification.</p>
        /// </important>
        /// <p>Valid values: <code>true</code> | <code>false</code> </p>
        /// <p>Default: <code>false</code> </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_immediately(input);
            self
        }
        /// <p>The upgraded version of the cache engine to be run on the cache nodes.</p>
        /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version. </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The upgraded version of the cache engine to be run on the cache nodes.</p>
        /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version. </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(input);
            self
        }
        /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p> <note>
        /// <p>If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.</p>
        /// </note>
        pub fn snapshot_retention_limit(mut self, input: i32) -> Self {
            self.inner = self.inner.snapshot_retention_limit(input);
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p> <note>
        /// <p>If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.</p>
        /// </note>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_snapshot_retention_limit(input);
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster. </p>
        pub fn snapshot_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_window(input.into());
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster. </p>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_window(input);
            self
        }
        /// <p>A valid cache node type that you want to scale this cluster up to.</p>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_node_type(input.into());
            self
        }
        /// <p>A valid cache node type that you want to scale this cluster up to.</p>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_node_type(input);
            self
        }
        /// <p>Reserved parameter. The password used to access a password protected server. This parameter must be specified with the <code>auth-token-update</code> parameter. Password constraints:</p>
        /// <ul>
        /// <li> <p>Must be only printable ASCII characters</p> </li>
        /// <li> <p>Must be at least 16 characters and no more than 128 characters in length</p> </li>
        /// <li> <p>Cannot contain any of the following characters: '/', '"', or '@', '%'</p> </li>
        /// </ul>
        /// <p> For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.</p>
        pub fn auth_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auth_token(input.into());
            self
        }
        /// <p>Reserved parameter. The password used to access a password protected server. This parameter must be specified with the <code>auth-token-update</code> parameter. Password constraints:</p>
        /// <ul>
        /// <li> <p>Must be only printable ASCII characters</p> </li>
        /// <li> <p>Must be at least 16 characters and no more than 128 characters in length</p> </li>
        /// <li> <p>Cannot contain any of the following characters: '/', '"', or '@', '%'</p> </li>
        /// </ul>
        /// <p> For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.</p>
        pub fn set_auth_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_auth_token(input);
            self
        }
        /// <p>Specifies the strategy to use to update the AUTH token. This parameter must be specified with the <code>auth-token</code> parameter. Possible values:</p>
        /// <ul>
        /// <li> <p>Rotate</p> </li>
        /// <li> <p>Set</p> </li>
        /// </ul>
        /// <p> For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis AUTH</a> </p>
        pub fn auth_token_update_strategy(
            mut self,
            input: crate::model::AuthTokenUpdateStrategyType,
        ) -> Self {
            self.inner = self.inner.auth_token_update_strategy(input);
            self
        }
        /// <p>Specifies the strategy to use to update the AUTH token. This parameter must be specified with the <code>auth-token</code> parameter. Possible values:</p>
        /// <ul>
        /// <li> <p>Rotate</p> </li>
        /// <li> <p>Set</p> </li>
        /// </ul>
        /// <p> For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis AUTH</a> </p>
        pub fn set_auth_token_update_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthTokenUpdateStrategyType>,
        ) -> Self {
            self.inner = self.inner.set_auth_token_update_strategy(input);
            self
        }
        /// Appends an item to `LogDeliveryConfigurations`.
        ///
        /// To override the contents of this collection use [`set_log_delivery_configurations`](Self::set_log_delivery_configurations).
        ///
        /// <p>Specifies the destination, format and type of the logs.</p>
        pub fn log_delivery_configurations(
            mut self,
            input: crate::model::LogDeliveryConfigurationRequest,
        ) -> Self {
            self.inner = self.inner.log_delivery_configurations(input);
            self
        }
        /// <p>Specifies the destination, format and type of the logs.</p>
        pub fn set_log_delivery_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LogDeliveryConfigurationRequest>,
            >,
        ) -> Self {
            self.inner = self.inner.set_log_delivery_configurations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyCacheParameterGroup`.
    ///
    /// <p>Modifies the parameters of a cache parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyCacheParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_cache_parameter_group_input::Builder,
    }
    impl ModifyCacheParameterGroup {
        /// Creates a new `ModifyCacheParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyCacheParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyCacheParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cache parameter group to modify.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the cache parameter group to modify.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_parameter_group_name(input);
            self
        }
        /// Appends an item to `ParameterNameValues`.
        ///
        /// To override the contents of this collection use [`set_parameter_name_values`](Self::set_parameter_name_values).
        ///
        /// <p>An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be modified per request.</p>
        pub fn parameter_name_values(mut self, input: crate::model::ParameterNameValue) -> Self {
            self.inner = self.inner.parameter_name_values(input);
            self
        }
        /// <p>An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be modified per request.</p>
        pub fn set_parameter_name_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterNameValue>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_name_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyCacheSubnetGroup`.
    ///
    /// <p>Modifies an existing cache subnet group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyCacheSubnetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_cache_subnet_group_input::Builder,
    }
    impl ModifyCacheSubnetGroup {
        /// Creates a new `ModifyCacheSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyCacheSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyCacheSubnetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the cache subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>
        /// <p>Example: <code>mysubnetgroup</code> </p>
        pub fn cache_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_subnet_group_name(input.into());
            self
        }
        /// <p>The name for the cache subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>
        /// <p>Example: <code>mysubnetgroup</code> </p>
        pub fn set_cache_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_subnet_group_name(input);
            self
        }
        /// <p>A description of the cache subnet group.</p>
        pub fn cache_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cache_subnet_group_description(input.into());
            self
        }
        /// <p>A description of the cache subnet group.</p>
        pub fn set_cache_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_subnet_group_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The EC2 subnet IDs for the cache subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>The EC2 subnet IDs for the cache subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyGlobalReplicationGroup`.
    ///
    /// <p>Modifies the settings for a Global datastore.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyGlobalReplicationGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_global_replication_group_input::Builder,
    }
    impl ModifyGlobalReplicationGroup {
        /// Creates a new `ModifyGlobalReplicationGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyGlobalReplicationGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyGlobalReplicationGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.global_replication_group_id(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_replication_group_id(input);
            self
        }
        /// <p>This parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible. Modifications to Global Replication Groups cannot be requested to be applied in PreferredMaintenceWindow. </p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.inner = self.inner.apply_immediately(input);
            self
        }
        /// <p>This parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible. Modifications to Global Replication Groups cannot be requested to be applied in PreferredMaintenceWindow. </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_immediately(input);
            self
        }
        /// <p>A valid cache node type that you want to scale this Global datastore to.</p>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_node_type(input.into());
            self
        }
        /// <p>A valid cache node type that you want to scale this Global datastore to.</p>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_node_type(input);
            self
        }
        /// <p>The upgraded version of the cache engine to be run on the clusters in the Global datastore. </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The upgraded version of the cache engine to be run on the clusters in the Global datastore. </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The name of the cache parameter group to use with the Global datastore. It must be compatible with the major engine version used by the Global datastore.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the cache parameter group to use with the Global datastore. It must be compatible with the major engine version used by the Global datastore.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_parameter_group_name(input);
            self
        }
        /// <p>A description of the Global datastore</p>
        pub fn global_replication_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .global_replication_group_description(input.into());
            self
        }
        /// <p>A description of the Global datastore</p>
        pub fn set_global_replication_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_replication_group_description(input);
            self
        }
        /// <p>Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure. </p>
        pub fn automatic_failover_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.automatic_failover_enabled(input);
            self
        }
        /// <p>Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure. </p>
        pub fn set_automatic_failover_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_automatic_failover_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyReplicationGroup`.
    ///
    /// <p>Modifies the settings for a replication group.</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/scaling-redis-cluster-mode-enabled.html">Scaling for Amazon ElastiCache for Redis (cluster mode enabled)</a> in the ElastiCache User Guide</p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyReplicationGroupShardConfiguration.html">ModifyReplicationGroupShardConfiguration</a> in the ElastiCache API Reference</p> </li>
    /// </ul> <note>
    /// <p>This operation is valid for Redis only.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyReplicationGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_replication_group_input::Builder,
    }
    impl ModifyReplicationGroup {
        /// Creates a new `ModifyReplicationGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyReplicationGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyReplicationGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the replication group to modify.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_id(input.into());
            self
        }
        /// <p>The identifier of the replication group to modify.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_id(input);
            self
        }
        /// <p>A description for the replication group. Maximum length is 255 characters.</p>
        pub fn replication_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_group_description(input.into());
            self
        }
        /// <p>A description for the replication group. Maximum length is 255 characters.</p>
        pub fn set_replication_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_description(input);
            self
        }
        /// <p>For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the specified cluster in the specified replication group to the primary role. The nodes of all other clusters in the replication group are read replicas.</p>
        pub fn primary_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.primary_cluster_id(input.into());
            self
        }
        /// <p>For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the specified cluster in the specified replication group to the primary role. The nodes of all other clusters in the replication group are read replicas.</p>
        pub fn set_primary_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_primary_cluster_id(input);
            self
        }
        /// <p>The cluster ID that is used as the daily snapshot source for the replication group. This parameter cannot be set for Redis (cluster mode enabled) replication groups.</p>
        pub fn snapshotting_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshotting_cluster_id(input.into());
            self
        }
        /// <p>The cluster ID that is used as the daily snapshot source for the replication group. This parameter cannot be set for Redis (cluster mode enabled) replication groups.</p>
        pub fn set_snapshotting_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshotting_cluster_id(input);
            self
        }
        /// <p>Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure.</p>
        /// <p>Valid values: <code>true</code> | <code>false</code> </p>
        pub fn automatic_failover_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.automatic_failover_enabled(input);
            self
        }
        /// <p>Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure.</p>
        /// <p>Valid values: <code>true</code> | <code>false</code> </p>
        pub fn set_automatic_failover_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_automatic_failover_enabled(input);
            self
        }
        /// <p>A flag to indicate MultiAZ is enabled.</p>
        pub fn multi_az_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.multi_az_enabled(input);
            self
        }
        /// <p>A flag to indicate MultiAZ is enabled.</p>
        pub fn set_multi_az_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_multi_az_enabled(input);
            self
        }
        /// <p>Deprecated. This parameter is not used.</p>
        pub fn node_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_group_id(input.into());
            self
        }
        /// <p>Deprecated. This parameter is not used.</p>
        pub fn set_node_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_node_group_id(input);
            self
        }
        /// Appends an item to `CacheSecurityGroupNames`.
        ///
        /// To override the contents of this collection use [`set_cache_security_group_names`](Self::set_cache_security_group_names).
        ///
        /// <p>A list of cache security group names to authorize for the clusters in this replication group. This change is asynchronously applied as soon as possible.</p>
        /// <p>This parameter can be used only with replication group containing clusters running outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.</p>
        pub fn cache_security_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_security_group_names(input.into());
            self
        }
        /// <p>A list of cache security group names to authorize for the clusters in this replication group. This change is asynchronously applied as soon as possible.</p>
        /// <p>This parameter can be used only with replication group containing clusters running outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.</p>
        pub fn set_cache_security_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cache_security_group_names(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>Specifies the VPC Security Groups associated with the clusters in the replication group.</p>
        /// <p>This parameter can be used only with replication group containing clusters running in an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>Specifies the VPC Security Groups associated with the clusters in the replication group.</p>
        /// <p>This parameter can be used only with replication group containing clusters running in an Amazon Virtual Private Cloud (Amazon VPC).</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
        /// <p>Valid values for <code>ddd</code> are:</p>
        /// <ul>
        /// <li> <p> <code>sun</code> </p> </li>
        /// <li> <p> <code>mon</code> </p> </li>
        /// <li> <p> <code>tue</code> </p> </li>
        /// <li> <p> <code>wed</code> </p> </li>
        /// <li> <p> <code>thu</code> </p> </li>
        /// <li> <p> <code>fri</code> </p> </li>
        /// <li> <p> <code>sat</code> </p> </li>
        /// </ul>
        /// <p>Example: <code>sun:23:00-mon:01:30</code> </p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_maintenance_window(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p>
        /// <p>Valid values for <code>ddd</code> are:</p>
        /// <ul>
        /// <li> <p> <code>sun</code> </p> </li>
        /// <li> <p> <code>mon</code> </p> </li>
        /// <li> <p> <code>tue</code> </p> </li>
        /// <li> <p> <code>wed</code> </p> </li>
        /// <li> <p> <code>thu</code> </p> </li>
        /// <li> <p> <code>fri</code> </p> </li>
        /// <li> <p> <code>sat</code> </p> </li>
        /// </ul>
        /// <p>Example: <code>sun:23:00-mon:01:30</code> </p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>
        /// <p>The Amazon SNS topic owner must be same as the replication group owner. </p>
        /// </note>
        pub fn notification_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_topic_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note>
        /// <p>The Amazon SNS topic owner must be same as the replication group owner. </p>
        /// </note>
        pub fn set_notification_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_topic_arn(input);
            self
        }
        /// <p>The name of the cache parameter group to apply to all of the clusters in this replication group. This change is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the cache parameter group to apply to all of the clusters in this replication group. This change is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_parameter_group_name(input);
            self
        }
        /// <p>The status of the Amazon SNS notification topic for the replication group. Notifications are sent only if the status is <code>active</code>.</p>
        /// <p>Valid values: <code>active</code> | <code>inactive</code> </p>
        pub fn notification_topic_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notification_topic_status(input.into());
            self
        }
        /// <p>The status of the Amazon SNS notification topic for the replication group. Notifications are sent only if the status is <code>active</code>.</p>
        /// <p>Valid values: <code>active</code> | <code>inactive</code> </p>
        pub fn set_notification_topic_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notification_topic_status(input);
            self
        }
        /// <p>If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the replication group.</p>
        /// <p>If <code>false</code>, changes to the nodes in the replication group are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.</p>
        /// <p>Valid values: <code>true</code> | <code>false</code> </p>
        /// <p>Default: <code>false</code> </p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.inner = self.inner.apply_immediately(input);
            self
        }
        /// <p>If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the replication group.</p>
        /// <p>If <code>false</code>, changes to the nodes in the replication group are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.</p>
        /// <p>Valid values: <code>true</code> | <code>false</code> </p>
        /// <p>Default: <code>false</code> </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_immediately(input);
            self
        }
        /// <p>The upgraded version of the cache engine to be run on the clusters in the replication group.</p>
        /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing replication group and create it anew with the earlier engine version. </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The upgraded version of the cache engine to be run on the clusters in the replication group.</p>
        /// <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing replication group and create it anew with the earlier engine version. </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(input);
            self
        }
        /// <p>&nbsp;If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.&nbsp; </p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic node group (shard) snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        /// <p> <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>
        pub fn snapshot_retention_limit(mut self, input: i32) -> Self {
            self.inner = self.inner.snapshot_retention_limit(input);
            self
        }
        /// <p>The number of days for which ElastiCache retains automatic node group (shard) snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>
        /// <p> <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>
        pub fn set_snapshot_retention_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_snapshot_retention_limit(input);
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node group (shard) specified by <code>SnapshottingClusterId</code>.</p>
        /// <p>Example: <code>05:00-09:00</code> </p>
        /// <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p>
        pub fn snapshot_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_window(input.into());
            self
        }
        /// <p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node group (shard) specified by <code>SnapshottingClusterId</code>.</p>
        /// <p>Example: <code>05:00-09:00</code> </p>
        /// <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p>
        pub fn set_snapshot_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_window(input);
            self
        }
        /// <p>A valid cache node type that you want to scale this replication group to.</p>
        pub fn cache_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_node_type(input.into());
            self
        }
        /// <p>A valid cache node type that you want to scale this replication group to.</p>
        pub fn set_cache_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_node_type(input);
            self
        }
        /// <p>Reserved parameter. The password used to access a password protected server. This parameter must be specified with the <code>auth-token-update-strategy </code> parameter. Password constraints:</p>
        /// <ul>
        /// <li> <p>Must be only printable ASCII characters</p> </li>
        /// <li> <p>Must be at least 16 characters and no more than 128 characters in length</p> </li>
        /// <li> <p>Cannot contain any of the following characters: '/', '"', or '@', '%'</p> </li>
        /// </ul>
        /// <p> For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.</p>
        pub fn auth_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auth_token(input.into());
            self
        }
        /// <p>Reserved parameter. The password used to access a password protected server. This parameter must be specified with the <code>auth-token-update-strategy </code> parameter. Password constraints:</p>
        /// <ul>
        /// <li> <p>Must be only printable ASCII characters</p> </li>
        /// <li> <p>Must be at least 16 characters and no more than 128 characters in length</p> </li>
        /// <li> <p>Cannot contain any of the following characters: '/', '"', or '@', '%'</p> </li>
        /// </ul>
        /// <p> For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.</p>
        pub fn set_auth_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_auth_token(input);
            self
        }
        /// <p>Specifies the strategy to use to update the AUTH token. This parameter must be specified with the <code>auth-token</code> parameter. Possible values:</p>
        /// <ul>
        /// <li> <p>Rotate</p> </li>
        /// <li> <p>Set</p> </li>
        /// </ul>
        /// <p> For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis AUTH</a> </p>
        pub fn auth_token_update_strategy(
            mut self,
            input: crate::model::AuthTokenUpdateStrategyType,
        ) -> Self {
            self.inner = self.inner.auth_token_update_strategy(input);
            self
        }
        /// <p>Specifies the strategy to use to update the AUTH token. This parameter must be specified with the <code>auth-token</code> parameter. Possible values:</p>
        /// <ul>
        /// <li> <p>Rotate</p> </li>
        /// <li> <p>Set</p> </li>
        /// </ul>
        /// <p> For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis AUTH</a> </p>
        pub fn set_auth_token_update_strategy(
            mut self,
            input: std::option::Option<crate::model::AuthTokenUpdateStrategyType>,
        ) -> Self {
            self.inner = self.inner.set_auth_token_update_strategy(input);
            self
        }
        /// Appends an item to `UserGroupIdsToAdd`.
        ///
        /// To override the contents of this collection use [`set_user_group_ids_to_add`](Self::set_user_group_ids_to_add).
        ///
        /// <p>The ID of the user group you are associating with the replication group.</p>
        pub fn user_group_ids_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_group_ids_to_add(input.into());
            self
        }
        /// <p>The ID of the user group you are associating with the replication group.</p>
        pub fn set_user_group_ids_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_group_ids_to_add(input);
            self
        }
        /// Appends an item to `UserGroupIdsToRemove`.
        ///
        /// To override the contents of this collection use [`set_user_group_ids_to_remove`](Self::set_user_group_ids_to_remove).
        ///
        /// <p>The ID of the user group to disassociate from the replication group, meaning the users in the group no longer can access the replication group.</p>
        pub fn user_group_ids_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_group_ids_to_remove(input.into());
            self
        }
        /// <p>The ID of the user group to disassociate from the replication group, meaning the users in the group no longer can access the replication group.</p>
        pub fn set_user_group_ids_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_group_ids_to_remove(input);
            self
        }
        /// <p>Removes the user group associated with this replication group.</p>
        pub fn remove_user_groups(mut self, input: bool) -> Self {
            self.inner = self.inner.remove_user_groups(input);
            self
        }
        /// <p>Removes the user group associated with this replication group.</p>
        pub fn set_remove_user_groups(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_remove_user_groups(input);
            self
        }
        /// Appends an item to `LogDeliveryConfigurations`.
        ///
        /// To override the contents of this collection use [`set_log_delivery_configurations`](Self::set_log_delivery_configurations).
        ///
        /// <p>Specifies the destination, format and type of the logs.</p>
        pub fn log_delivery_configurations(
            mut self,
            input: crate::model::LogDeliveryConfigurationRequest,
        ) -> Self {
            self.inner = self.inner.log_delivery_configurations(input);
            self
        }
        /// <p>Specifies the destination, format and type of the logs.</p>
        pub fn set_log_delivery_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LogDeliveryConfigurationRequest>,
            >,
        ) -> Self {
            self.inner = self.inner.set_log_delivery_configurations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyReplicationGroupShardConfiguration`.
    ///
    /// <p>Modifies a replication group's shards (node groups) by allowing you to add shards, remove shards, or rebalance the keyspaces among existing shards.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyReplicationGroupShardConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_replication_group_shard_configuration_input::Builder,
    }
    impl ModifyReplicationGroupShardConfiguration {
        /// Creates a new `ModifyReplicationGroupShardConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyReplicationGroupShardConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ModifyReplicationGroupShardConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Redis (cluster mode enabled) cluster (replication group) on which the shards are to be configured.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_id(input.into());
            self
        }
        /// <p>The name of the Redis (cluster mode enabled) cluster (replication group) on which the shards are to be configured.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_id(input);
            self
        }
        /// <p>The number of node groups (shards) that results from the modification of the shard configuration.</p>
        pub fn node_group_count(mut self, input: i32) -> Self {
            self.inner = self.inner.node_group_count(input);
            self
        }
        /// <p>The number of node groups (shards) that results from the modification of the shard configuration.</p>
        pub fn set_node_group_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_node_group_count(input);
            self
        }
        /// <p>Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for this parameter is <code>true</code>.</p>
        /// <p>Value: true</p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.inner = self.inner.apply_immediately(input);
            self
        }
        /// <p>Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for this parameter is <code>true</code>.</p>
        /// <p>Value: true</p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_immediately(input);
            self
        }
        /// Appends an item to `ReshardingConfiguration`.
        ///
        /// To override the contents of this collection use [`set_resharding_configuration`](Self::set_resharding_configuration).
        ///
        /// <p>Specifies the preferred availability zones for each node group in the cluster. If the value of <code>NodeGroupCount</code> is greater than the current number of node groups (shards), you can use this parameter to specify the preferred availability zones of the cluster's shards. If you omit this parameter ElastiCache selects availability zones for you.</p>
        /// <p>You can specify this parameter only if the value of <code>NodeGroupCount</code> is greater than the current number of node groups (shards).</p>
        pub fn resharding_configuration(
            mut self,
            input: crate::model::ReshardingConfiguration,
        ) -> Self {
            self.inner = self.inner.resharding_configuration(input);
            self
        }
        /// <p>Specifies the preferred availability zones for each node group in the cluster. If the value of <code>NodeGroupCount</code> is greater than the current number of node groups (shards), you can use this parameter to specify the preferred availability zones of the cluster's shards. If you omit this parameter ElastiCache selects availability zones for you.</p>
        /// <p>You can specify this parameter only if the value of <code>NodeGroupCount</code> is greater than the current number of node groups (shards).</p>
        pub fn set_resharding_configuration(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReshardingConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_resharding_configuration(input);
            self
        }
        /// Appends an item to `NodeGroupsToRemove`.
        ///
        /// To override the contents of this collection use [`set_node_groups_to_remove`](Self::set_node_groups_to_remove).
        ///
        /// <p>If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required. <code>NodeGroupsToRemove</code> is a list of <code>NodeGroupId</code>s to remove from the cluster.</p>
        /// <p>ElastiCache for Redis will attempt to remove all node groups listed by <code>NodeGroupsToRemove</code> from the cluster.</p>
        pub fn node_groups_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_groups_to_remove(input.into());
            self
        }
        /// <p>If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required. <code>NodeGroupsToRemove</code> is a list of <code>NodeGroupId</code>s to remove from the cluster.</p>
        /// <p>ElastiCache for Redis will attempt to remove all node groups listed by <code>NodeGroupsToRemove</code> from the cluster.</p>
        pub fn set_node_groups_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_node_groups_to_remove(input);
            self
        }
        /// Appends an item to `NodeGroupsToRetain`.
        ///
        /// To override the contents of this collection use [`set_node_groups_to_retain`](Self::set_node_groups_to_retain).
        ///
        /// <p>If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required. <code>NodeGroupsToRetain</code> is a list of <code>NodeGroupId</code>s to retain in the cluster.</p>
        /// <p>ElastiCache for Redis will attempt to remove all node groups except those listed by <code>NodeGroupsToRetain</code> from the cluster.</p>
        pub fn node_groups_to_retain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_groups_to_retain(input.into());
            self
        }
        /// <p>If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required. <code>NodeGroupsToRetain</code> is a list of <code>NodeGroupId</code>s to retain in the cluster.</p>
        /// <p>ElastiCache for Redis will attempt to remove all node groups except those listed by <code>NodeGroupsToRetain</code> from the cluster.</p>
        pub fn set_node_groups_to_retain(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_node_groups_to_retain(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyUser`.
    ///
    /// <p>Changes user password(s) and/or access string.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyUser {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_user_input::Builder,
    }
    impl ModifyUser {
        /// Creates a new `ModifyUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyUserOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyUserError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The ID of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn access_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_string(input.into());
            self
        }
        /// <p>Access permissions string used for this user.</p>
        pub fn set_access_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_string(input);
            self
        }
        /// <p>Adds additional user permissions to the access string.</p>
        pub fn append_access_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.append_access_string(input.into());
            self
        }
        /// <p>Adds additional user permissions to the access string.</p>
        pub fn set_append_access_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_append_access_string(input);
            self
        }
        /// Appends an item to `Passwords`.
        ///
        /// To override the contents of this collection use [`set_passwords`](Self::set_passwords).
        ///
        /// <p>The passwords belonging to the user. You are allowed up to two.</p>
        pub fn passwords(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.passwords(input.into());
            self
        }
        /// <p>The passwords belonging to the user. You are allowed up to two.</p>
        pub fn set_passwords(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_passwords(input);
            self
        }
        /// <p>Indicates no password is required for the user.</p>
        pub fn no_password_required(mut self, input: bool) -> Self {
            self.inner = self.inner.no_password_required(input);
            self
        }
        /// <p>Indicates no password is required for the user.</p>
        pub fn set_no_password_required(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_no_password_required(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyUserGroup`.
    ///
    /// <p>Changes the list of users that belong to the user group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyUserGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_user_group_input::Builder,
    }
    impl ModifyUserGroup {
        /// Creates a new `ModifyUserGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyUserGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyUserGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the user group.</p>
        pub fn user_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_group_id(input.into());
            self
        }
        /// <p>The ID of the user group.</p>
        pub fn set_user_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_group_id(input);
            self
        }
        /// Appends an item to `UserIdsToAdd`.
        ///
        /// To override the contents of this collection use [`set_user_ids_to_add`](Self::set_user_ids_to_add).
        ///
        /// <p>The list of user IDs to add to the user group.</p>
        pub fn user_ids_to_add(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_ids_to_add(input.into());
            self
        }
        /// <p>The list of user IDs to add to the user group.</p>
        pub fn set_user_ids_to_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_ids_to_add(input);
            self
        }
        /// Appends an item to `UserIdsToRemove`.
        ///
        /// To override the contents of this collection use [`set_user_ids_to_remove`](Self::set_user_ids_to_remove).
        ///
        /// <p>The list of user IDs to remove from the user group.</p>
        pub fn user_ids_to_remove(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_ids_to_remove(input.into());
            self
        }
        /// <p>The list of user IDs to remove from the user group.</p>
        pub fn set_user_ids_to_remove(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_user_ids_to_remove(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PurchaseReservedCacheNodesOffering`.
    ///
    /// <p>Allows you to purchase a reserved cache node offering. Reserved nodes are not eligible for cancellation and are non-refundable. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/reserved-nodes.html">Managing Costs with Reserved Nodes</a> for Redis or <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/reserved-nodes.html">Managing Costs with Reserved Nodes</a> for Memcached.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PurchaseReservedCacheNodesOffering {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::purchase_reserved_cache_nodes_offering_input::Builder,
    }
    impl PurchaseReservedCacheNodesOffering {
        /// Creates a new `PurchaseReservedCacheNodesOffering`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PurchaseReservedCacheNodesOfferingOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PurchaseReservedCacheNodesOfferingError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the reserved cache node offering to purchase.</p>
        /// <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>
        pub fn reserved_cache_nodes_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.reserved_cache_nodes_offering_id(input.into());
            self
        }
        /// <p>The ID of the reserved cache node offering to purchase.</p>
        /// <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>
        pub fn set_reserved_cache_nodes_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_cache_nodes_offering_id(input);
            self
        }
        /// <p>A customer-specified identifier to track this reservation.</p> <note>
        /// <p>The Reserved Cache Node ID is an unique customer-specified identifier to track this reservation. If this parameter is not specified, ElastiCache automatically generates an identifier for the reservation.</p>
        /// </note>
        /// <p>Example: myreservationID</p>
        pub fn reserved_cache_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reserved_cache_node_id(input.into());
            self
        }
        /// <p>A customer-specified identifier to track this reservation.</p> <note>
        /// <p>The Reserved Cache Node ID is an unique customer-specified identifier to track this reservation. If this parameter is not specified, ElastiCache automatically generates an identifier for the reservation.</p>
        /// </note>
        /// <p>Example: myreservationID</p>
        pub fn set_reserved_cache_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_cache_node_id(input);
            self
        }
        /// <p>The number of cache node instances to reserve.</p>
        /// <p>Default: <code>1</code> </p>
        pub fn cache_node_count(mut self, input: i32) -> Self {
            self.inner = self.inner.cache_node_count(input);
            self
        }
        /// <p>The number of cache node instances to reserve.</p>
        /// <p>Default: <code>1</code> </p>
        pub fn set_cache_node_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_cache_node_count(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebalanceSlotsInGlobalReplicationGroup`.
    ///
    /// <p>Redistribute slots to ensure uniform distribution across existing shards in the cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RebalanceSlotsInGlobalReplicationGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::rebalance_slots_in_global_replication_group_input::Builder,
    }
    impl RebalanceSlotsInGlobalReplicationGroup {
        /// Creates a new `RebalanceSlotsInGlobalReplicationGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebalanceSlotsInGlobalReplicationGroupOutput,
            aws_smithy_http::result::SdkError<
                crate::error::RebalanceSlotsInGlobalReplicationGroupError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Global datastore</p>
        pub fn global_replication_group_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.global_replication_group_id(input.into());
            self
        }
        /// <p>The name of the Global datastore</p>
        pub fn set_global_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_replication_group_id(input);
            self
        }
        /// <p>If <code>True</code>, redistribution is applied immediately.</p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.inner = self.inner.apply_immediately(input);
            self
        }
        /// <p>If <code>True</code>, redistribution is applied immediately.</p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_immediately(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebootCacheCluster`.
    ///
    /// <p>Reboots some, or all, of the cache nodes within a provisioned cluster. This operation applies any modified cache parameter groups to the cluster. The reboot operation takes place as soon as possible, and results in a momentary outage to the cluster. During the reboot, the cluster status is set to REBOOTING.</p>
    /// <p>The reboot causes the contents of the cache (for each cache node being rebooted) to be lost.</p>
    /// <p>When the reboot is complete, a cluster event is created.</p>
    /// <p>Rebooting a cluster is currently supported on Memcached and Redis (cluster mode disabled) clusters. Rebooting is not supported on Redis (cluster mode enabled) clusters.</p>
    /// <p>If you make changes to parameters that require a Redis (cluster mode enabled) cluster reboot for the changes to be applied, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes.rebooting.html">Rebooting a Cluster</a> for an alternate process.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RebootCacheCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reboot_cache_cluster_input::Builder,
    }
    impl RebootCacheCluster {
        /// Creates a new `RebootCacheCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebootCacheClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::RebootCacheClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier. This parameter is stored as a lowercase string.</p>
        pub fn cache_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_cluster_id(input.into());
            self
        }
        /// <p>The cluster identifier. This parameter is stored as a lowercase string.</p>
        pub fn set_cache_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_cluster_id(input);
            self
        }
        /// Appends an item to `CacheNodeIdsToReboot`.
        ///
        /// To override the contents of this collection use [`set_cache_node_ids_to_reboot`](Self::set_cache_node_ids_to_reboot).
        ///
        /// <p>A list of cache node IDs to reboot. A node ID is a numeric identifier (0001, 0002, etc.). To reboot an entire cluster, specify all of the cache node IDs.</p>
        pub fn cache_node_ids_to_reboot(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_node_ids_to_reboot(input.into());
            self
        }
        /// <p>A list of cache node IDs to reboot. A node ID is a numeric identifier (0001, 0002, etc.). To reboot an entire cluster, specify all of the cache node IDs.</p>
        pub fn set_cache_node_ids_to_reboot(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cache_node_ids_to_reboot(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTagsFromResource`.
    ///
    /// <p>Removes the tags identified by the <code>TagKeys</code> list from the named resource. A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html">Resource-level permissions</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveTagsFromResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_tags_from_resource_input::Builder,
    }
    impl RemoveTagsFromResource {
        /// Creates a new `RemoveTagsFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which you want the tags removed, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Service Namespaces</a>.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which you want the tags removed, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Service Namespaces</a>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of <code>TagKeys</code> identifying the tags you want removed from the named resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of <code>TagKeys</code> identifying the tags you want removed from the named resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetCacheParameterGroup`.
    ///
    /// <p>Modifies the parameters of a cache parameter group to the engine or system default value. You can reset specific parameters by submitting a list of parameter names. To reset the entire cache parameter group, specify the <code>ResetAllParameters</code> and <code>CacheParameterGroupName</code> parameters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResetCacheParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reset_cache_parameter_group_input::Builder,
    }
    impl ResetCacheParameterGroup {
        /// Creates a new `ResetCacheParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetCacheParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetCacheParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cache parameter group to reset.</p>
        pub fn cache_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the cache parameter group to reset.</p>
        pub fn set_cache_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_parameter_group_name(input);
            self
        }
        /// <p>If <code>true</code>, all parameters in the cache parameter group are reset to their default values. If <code>false</code>, only the parameters listed by <code>ParameterNameValues</code> are reset to their default values.</p>
        /// <p>Valid values: <code>true</code> | <code>false</code> </p>
        pub fn reset_all_parameters(mut self, input: bool) -> Self {
            self.inner = self.inner.reset_all_parameters(input);
            self
        }
        /// <p>If <code>true</code>, all parameters in the cache parameter group are reset to their default values. If <code>false</code>, only the parameters listed by <code>ParameterNameValues</code> are reset to their default values.</p>
        /// <p>Valid values: <code>true</code> | <code>false</code> </p>
        pub fn set_reset_all_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reset_all_parameters(input);
            self
        }
        /// Appends an item to `ParameterNameValues`.
        ///
        /// To override the contents of this collection use [`set_parameter_name_values`](Self::set_parameter_name_values).
        ///
        /// <p>An array of parameter names to reset to their default values. If <code>ResetAllParameters</code> is <code>true</code>, do not use <code>ParameterNameValues</code>. If <code>ResetAllParameters</code> is <code>false</code>, you must specify the name of at least one parameter to reset.</p>
        pub fn parameter_name_values(mut self, input: crate::model::ParameterNameValue) -> Self {
            self.inner = self.inner.parameter_name_values(input);
            self
        }
        /// <p>An array of parameter names to reset to their default values. If <code>ResetAllParameters</code> is <code>true</code>, do not use <code>ParameterNameValues</code>. If <code>ResetAllParameters</code> is <code>false</code>, you must specify the name of at least one parameter to reset.</p>
        pub fn set_parameter_name_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ParameterNameValue>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_name_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokeCacheSecurityGroupIngress`.
    ///
    /// <p>Revokes ingress from a cache security group. Use this operation to disallow access from an Amazon EC2 security group that had been previously authorized.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RevokeCacheSecurityGroupIngress {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::revoke_cache_security_group_ingress_input::Builder,
    }
    impl RevokeCacheSecurityGroupIngress {
        /// Creates a new `RevokeCacheSecurityGroupIngress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokeCacheSecurityGroupIngressOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokeCacheSecurityGroupIngressError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cache security group to revoke ingress from.</p>
        pub fn cache_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_security_group_name(input.into());
            self
        }
        /// <p>The name of the cache security group to revoke ingress from.</p>
        pub fn set_cache_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_security_group_name(input);
            self
        }
        /// <p>The name of the Amazon EC2 security group to revoke access from.</p>
        pub fn ec2_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_security_group_name(input.into());
            self
        }
        /// <p>The name of the Amazon EC2 security group to revoke access from.</p>
        pub fn set_ec2_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_name(input);
            self
        }
        /// <p>The Amazon account number of the Amazon EC2 security group owner. Note that this is not the same thing as an Amazon access key ID - you must provide a valid Amazon account number for this parameter.</p>
        pub fn ec2_security_group_owner_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.ec2_security_group_owner_id(input.into());
            self
        }
        /// <p>The Amazon account number of the Amazon EC2 security group owner. Note that this is not the same thing as an Amazon access key ID - you must provide a valid Amazon account number for this parameter.</p>
        pub fn set_ec2_security_group_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_owner_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartMigration`.
    ///
    /// <p>Start the migration of data.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartMigration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_migration_input::Builder,
    }
    impl StartMigration {
        /// Creates a new `StartMigration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartMigrationOutput,
            aws_smithy_http::result::SdkError<crate::error::StartMigrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the replication group to which data should be migrated.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_id(input.into());
            self
        }
        /// <p>The ID of the replication group to which data should be migrated.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_id(input);
            self
        }
        /// Appends an item to `CustomerNodeEndpointList`.
        ///
        /// To override the contents of this collection use [`set_customer_node_endpoint_list`](Self::set_customer_node_endpoint_list).
        ///
        /// <p>List of endpoints from which data should be migrated. For Redis (cluster mode disabled), list should have only one element.</p>
        pub fn customer_node_endpoint_list(
            mut self,
            input: crate::model::CustomerNodeEndpoint,
        ) -> Self {
            self.inner = self.inner.customer_node_endpoint_list(input);
            self
        }
        /// <p>List of endpoints from which data should be migrated. For Redis (cluster mode disabled), list should have only one element.</p>
        pub fn set_customer_node_endpoint_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomerNodeEndpoint>>,
        ) -> Self {
            self.inner = self.inner.set_customer_node_endpoint_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestFailover`.
    ///
    /// <p>Represents the input of a <code>TestFailover</code> operation which test automatic failover on a specified node group (called shard in the console) in a replication group (called cluster in the console).</p>
    /// <p>This API is designed for testing the behavior of your application in case of ElastiCache failover. It is not designed to be an operational tool for initiating a failover to overcome a problem you may have with the cluster. Moreover, in certain conditions such as large-scale operational events, Amazon may block this API. </p>
    /// <p class="title"> <b>Note the following</b> </p>
    /// <ul>
    /// <li> <p>A customer can use this operation to test automatic failover on up to 5 shards (called node groups in the ElastiCache API and Amazon CLI) in any rolling 24-hour period.</p> </li>
    /// <li> <p>If calling this operation on shards in different clusters (called replication groups in the API and CLI), the calls can be made concurrently.</p> <p> </p> </li>
    /// <li> <p>If calling this operation multiple times on different shards in the same Redis (cluster mode enabled) replication group, the first node replacement must complete before a subsequent call can be made.</p> </li>
    /// <li> <p>To determine whether the node replacement is complete you can check Events using the Amazon ElastiCache console, the Amazon CLI, or the ElastiCache API. Look for the following automatic failover related events, listed here in order of occurrance:</p>
    /// <ol>
    /// <li> <p>Replication group message: <code>Test Failover API called for node group
    /// <node-group-id></node-group-id></code> </p> </li>
    /// <li> <p>Cache cluster message: <code>Failover from primary node
    /// <primary-node-id>
    /// to replica node
    /// <node-id>
    /// completed
    /// </node-id>
    /// </primary-node-id></code> </p> </li>
    /// <li> <p>Replication group message: <code>Failover from primary node
    /// <primary-node-id>
    /// to replica node
    /// <node-id>
    /// completed
    /// </node-id>
    /// </primary-node-id></code> </p> </li>
    /// <li> <p>Cache cluster message: <code>Recovering cache nodes
    /// <node-id></node-id></code> </p> </li>
    /// <li> <p>Cache cluster message: <code>Finished recovery for cache nodes
    /// <node-id></node-id></code> </p> </li>
    /// </ol> <p>For more information see:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ECEvents.Viewing.html">Viewing ElastiCache Events</a> in the <i>ElastiCache User Guide</i> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeEvents.html">DescribeEvents</a> in the ElastiCache API Reference</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>Also see, <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html#auto-failover-test">Testing Multi-AZ </a> in the <i>ElastiCache User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TestFailover {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::test_failover_input::Builder,
    }
    impl TestFailover {
        /// Creates a new `TestFailover`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestFailoverOutput,
            aws_smithy_http::result::SdkError<crate::error::TestFailoverError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the replication group (console: cluster) whose automatic failover is being tested by this operation.</p>
        pub fn replication_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_group_id(input.into());
            self
        }
        /// <p>The name of the replication group (console: cluster) whose automatic failover is being tested by this operation.</p>
        pub fn set_replication_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_group_id(input);
            self
        }
        /// <p>The name of the node group (called shard in the console) in this replication group on which automatic failover is to be tested. You may test automatic failover on up to 5 node groups in any rolling 24-hour period.</p>
        pub fn node_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_group_id(input.into());
            self
        }
        /// <p>The name of the node group (called shard in the console) in this replication group on which automatic failover is to be tested. You may test automatic failover on up to 5 node groups in any rolling 24-hour period.</p>
        pub fn set_node_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_node_group_id(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
