// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddTagsToResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_tags_to_resource`](crate::client::Client::add_tags_to_resource).
///
/// See [`crate::client::fluent_builders::AddTagsToResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddTagsToResource {
    _private: (),
}
impl AddTagsToResource {
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    pub fn builder() -> crate::input::add_tags_to_resource_input::Builder {
        crate::input::add_tags_to_resource_input::Builder::default()
    }
    /// Creates a new `AddTagsToResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddTagsToResource {
    type Output = std::result::Result<
        crate::output::AddTagsToResourceOutput,
        crate::error::AddTagsToResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_tags_to_resource_error(response)
        } else {
            crate::operation_deser::parse_add_tags_to_resource_response(response)
        }
    }
}

/// Operation shape for `AuthorizeCacheSecurityGroupIngress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`authorize_cache_security_group_ingress`](crate::client::Client::authorize_cache_security_group_ingress).
///
/// See [`crate::client::fluent_builders::AuthorizeCacheSecurityGroupIngress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AuthorizeCacheSecurityGroupIngress {
    _private: (),
}
impl AuthorizeCacheSecurityGroupIngress {
    /// Creates a new builder-style object to manufacture [`AuthorizeCacheSecurityGroupIngressInput`](crate::input::AuthorizeCacheSecurityGroupIngressInput)
    pub fn builder() -> crate::input::authorize_cache_security_group_ingress_input::Builder {
        crate::input::authorize_cache_security_group_ingress_input::Builder::default()
    }
    /// Creates a new `AuthorizeCacheSecurityGroupIngress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AuthorizeCacheSecurityGroupIngress {
    type Output = std::result::Result<
        crate::output::AuthorizeCacheSecurityGroupIngressOutput,
        crate::error::AuthorizeCacheSecurityGroupIngressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_authorize_cache_security_group_ingress_error(response)
        } else {
            crate::operation_deser::parse_authorize_cache_security_group_ingress_response(response)
        }
    }
}

/// Operation shape for `BatchApplyUpdateAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_apply_update_action`](crate::client::Client::batch_apply_update_action).
///
/// See [`crate::client::fluent_builders::BatchApplyUpdateAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchApplyUpdateAction {
    _private: (),
}
impl BatchApplyUpdateAction {
    /// Creates a new builder-style object to manufacture [`BatchApplyUpdateActionInput`](crate::input::BatchApplyUpdateActionInput)
    pub fn builder() -> crate::input::batch_apply_update_action_input::Builder {
        crate::input::batch_apply_update_action_input::Builder::default()
    }
    /// Creates a new `BatchApplyUpdateAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchApplyUpdateAction {
    type Output = std::result::Result<
        crate::output::BatchApplyUpdateActionOutput,
        crate::error::BatchApplyUpdateActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_apply_update_action_error(response)
        } else {
            crate::operation_deser::parse_batch_apply_update_action_response(response)
        }
    }
}

/// Operation shape for `BatchStopUpdateAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_stop_update_action`](crate::client::Client::batch_stop_update_action).
///
/// See [`crate::client::fluent_builders::BatchStopUpdateAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchStopUpdateAction {
    _private: (),
}
impl BatchStopUpdateAction {
    /// Creates a new builder-style object to manufacture [`BatchStopUpdateActionInput`](crate::input::BatchStopUpdateActionInput)
    pub fn builder() -> crate::input::batch_stop_update_action_input::Builder {
        crate::input::batch_stop_update_action_input::Builder::default()
    }
    /// Creates a new `BatchStopUpdateAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchStopUpdateAction {
    type Output = std::result::Result<
        crate::output::BatchStopUpdateActionOutput,
        crate::error::BatchStopUpdateActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_stop_update_action_error(response)
        } else {
            crate::operation_deser::parse_batch_stop_update_action_response(response)
        }
    }
}

/// Operation shape for `CompleteMigration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`complete_migration`](crate::client::Client::complete_migration).
///
/// See [`crate::client::fluent_builders::CompleteMigration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CompleteMigration {
    _private: (),
}
impl CompleteMigration {
    /// Creates a new builder-style object to manufacture [`CompleteMigrationInput`](crate::input::CompleteMigrationInput)
    pub fn builder() -> crate::input::complete_migration_input::Builder {
        crate::input::complete_migration_input::Builder::default()
    }
    /// Creates a new `CompleteMigration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CompleteMigration {
    type Output = std::result::Result<
        crate::output::CompleteMigrationOutput,
        crate::error::CompleteMigrationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_complete_migration_error(response)
        } else {
            crate::operation_deser::parse_complete_migration_response(response)
        }
    }
}

/// Operation shape for `CopySnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_snapshot`](crate::client::Client::copy_snapshot).
///
/// See [`crate::client::fluent_builders::CopySnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopySnapshot {
    _private: (),
}
impl CopySnapshot {
    /// Creates a new builder-style object to manufacture [`CopySnapshotInput`](crate::input::CopySnapshotInput)
    pub fn builder() -> crate::input::copy_snapshot_input::Builder {
        crate::input::copy_snapshot_input::Builder::default()
    }
    /// Creates a new `CopySnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopySnapshot {
    type Output =
        std::result::Result<crate::output::CopySnapshotOutput, crate::error::CopySnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_snapshot_error(response)
        } else {
            crate::operation_deser::parse_copy_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateCacheCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cache_cluster`](crate::client::Client::create_cache_cluster).
///
/// See [`crate::client::fluent_builders::CreateCacheCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCacheCluster {
    _private: (),
}
impl CreateCacheCluster {
    /// Creates a new builder-style object to manufacture [`CreateCacheClusterInput`](crate::input::CreateCacheClusterInput)
    pub fn builder() -> crate::input::create_cache_cluster_input::Builder {
        crate::input::create_cache_cluster_input::Builder::default()
    }
    /// Creates a new `CreateCacheCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCacheCluster {
    type Output = std::result::Result<
        crate::output::CreateCacheClusterOutput,
        crate::error::CreateCacheClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_cache_cluster_error(response)
        } else {
            crate::operation_deser::parse_create_cache_cluster_response(response)
        }
    }
}

/// Operation shape for `CreateCacheParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cache_parameter_group`](crate::client::Client::create_cache_parameter_group).
///
/// See [`crate::client::fluent_builders::CreateCacheParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCacheParameterGroup {
    _private: (),
}
impl CreateCacheParameterGroup {
    /// Creates a new builder-style object to manufacture [`CreateCacheParameterGroupInput`](crate::input::CreateCacheParameterGroupInput)
    pub fn builder() -> crate::input::create_cache_parameter_group_input::Builder {
        crate::input::create_cache_parameter_group_input::Builder::default()
    }
    /// Creates a new `CreateCacheParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCacheParameterGroup {
    type Output = std::result::Result<
        crate::output::CreateCacheParameterGroupOutput,
        crate::error::CreateCacheParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_cache_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_create_cache_parameter_group_response(response)
        }
    }
}

/// Operation shape for `CreateCacheSecurityGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cache_security_group`](crate::client::Client::create_cache_security_group).
///
/// See [`crate::client::fluent_builders::CreateCacheSecurityGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCacheSecurityGroup {
    _private: (),
}
impl CreateCacheSecurityGroup {
    /// Creates a new builder-style object to manufacture [`CreateCacheSecurityGroupInput`](crate::input::CreateCacheSecurityGroupInput)
    pub fn builder() -> crate::input::create_cache_security_group_input::Builder {
        crate::input::create_cache_security_group_input::Builder::default()
    }
    /// Creates a new `CreateCacheSecurityGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCacheSecurityGroup {
    type Output = std::result::Result<
        crate::output::CreateCacheSecurityGroupOutput,
        crate::error::CreateCacheSecurityGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_cache_security_group_error(response)
        } else {
            crate::operation_deser::parse_create_cache_security_group_response(response)
        }
    }
}

/// Operation shape for `CreateCacheSubnetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cache_subnet_group`](crate::client::Client::create_cache_subnet_group).
///
/// See [`crate::client::fluent_builders::CreateCacheSubnetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCacheSubnetGroup {
    _private: (),
}
impl CreateCacheSubnetGroup {
    /// Creates a new builder-style object to manufacture [`CreateCacheSubnetGroupInput`](crate::input::CreateCacheSubnetGroupInput)
    pub fn builder() -> crate::input::create_cache_subnet_group_input::Builder {
        crate::input::create_cache_subnet_group_input::Builder::default()
    }
    /// Creates a new `CreateCacheSubnetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCacheSubnetGroup {
    type Output = std::result::Result<
        crate::output::CreateCacheSubnetGroupOutput,
        crate::error::CreateCacheSubnetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_cache_subnet_group_error(response)
        } else {
            crate::operation_deser::parse_create_cache_subnet_group_response(response)
        }
    }
}

/// Operation shape for `CreateGlobalReplicationGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_global_replication_group`](crate::client::Client::create_global_replication_group).
///
/// See [`crate::client::fluent_builders::CreateGlobalReplicationGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGlobalReplicationGroup {
    _private: (),
}
impl CreateGlobalReplicationGroup {
    /// Creates a new builder-style object to manufacture [`CreateGlobalReplicationGroupInput`](crate::input::CreateGlobalReplicationGroupInput)
    pub fn builder() -> crate::input::create_global_replication_group_input::Builder {
        crate::input::create_global_replication_group_input::Builder::default()
    }
    /// Creates a new `CreateGlobalReplicationGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGlobalReplicationGroup {
    type Output = std::result::Result<
        crate::output::CreateGlobalReplicationGroupOutput,
        crate::error::CreateGlobalReplicationGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_global_replication_group_error(response)
        } else {
            crate::operation_deser::parse_create_global_replication_group_response(response)
        }
    }
}

/// Operation shape for `CreateReplicationGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_replication_group`](crate::client::Client::create_replication_group).
///
/// See [`crate::client::fluent_builders::CreateReplicationGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateReplicationGroup {
    _private: (),
}
impl CreateReplicationGroup {
    /// Creates a new builder-style object to manufacture [`CreateReplicationGroupInput`](crate::input::CreateReplicationGroupInput)
    pub fn builder() -> crate::input::create_replication_group_input::Builder {
        crate::input::create_replication_group_input::Builder::default()
    }
    /// Creates a new `CreateReplicationGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateReplicationGroup {
    type Output = std::result::Result<
        crate::output::CreateReplicationGroupOutput,
        crate::error::CreateReplicationGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_replication_group_error(response)
        } else {
            crate::operation_deser::parse_create_replication_group_response(response)
        }
    }
}

/// Operation shape for `CreateSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_snapshot`](crate::client::Client::create_snapshot).
///
/// See [`crate::client::fluent_builders::CreateSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSnapshot {
    _private: (),
}
impl CreateSnapshot {
    /// Creates a new builder-style object to manufacture [`CreateSnapshotInput`](crate::input::CreateSnapshotInput)
    pub fn builder() -> crate::input::create_snapshot_input::Builder {
        crate::input::create_snapshot_input::Builder::default()
    }
    /// Creates a new `CreateSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSnapshot {
    type Output =
        std::result::Result<crate::output::CreateSnapshotOutput, crate::error::CreateSnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_snapshot_error(response)
        } else {
            crate::operation_deser::parse_create_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user`](crate::client::Client::create_user).
///
/// See [`crate::client::fluent_builders::CreateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUser {
    _private: (),
}
impl CreateUser {
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
    /// Creates a new `CreateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUser {
    type Output =
        std::result::Result<crate::output::CreateUserOutput, crate::error::CreateUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_user_error(response)
        } else {
            crate::operation_deser::parse_create_user_response(response)
        }
    }
}

/// Operation shape for `CreateUserGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user_group`](crate::client::Client::create_user_group).
///
/// See [`crate::client::fluent_builders::CreateUserGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUserGroup {
    _private: (),
}
impl CreateUserGroup {
    /// Creates a new builder-style object to manufacture [`CreateUserGroupInput`](crate::input::CreateUserGroupInput)
    pub fn builder() -> crate::input::create_user_group_input::Builder {
        crate::input::create_user_group_input::Builder::default()
    }
    /// Creates a new `CreateUserGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUserGroup {
    type Output = std::result::Result<
        crate::output::CreateUserGroupOutput,
        crate::error::CreateUserGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_user_group_error(response)
        } else {
            crate::operation_deser::parse_create_user_group_response(response)
        }
    }
}

/// Operation shape for `DecreaseNodeGroupsInGlobalReplicationGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`decrease_node_groups_in_global_replication_group`](crate::client::Client::decrease_node_groups_in_global_replication_group).
///
/// See [`crate::client::fluent_builders::DecreaseNodeGroupsInGlobalReplicationGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DecreaseNodeGroupsInGlobalReplicationGroup {
    _private: (),
}
impl DecreaseNodeGroupsInGlobalReplicationGroup {
    /// Creates a new builder-style object to manufacture [`DecreaseNodeGroupsInGlobalReplicationGroupInput`](crate::input::DecreaseNodeGroupsInGlobalReplicationGroupInput)
    pub fn builder() -> crate::input::decrease_node_groups_in_global_replication_group_input::Builder
    {
        crate::input::decrease_node_groups_in_global_replication_group_input::Builder::default()
    }
    /// Creates a new `DecreaseNodeGroupsInGlobalReplicationGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DecreaseNodeGroupsInGlobalReplicationGroup {
    type Output = std::result::Result<
        crate::output::DecreaseNodeGroupsInGlobalReplicationGroupOutput,
        crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_decrease_node_groups_in_global_replication_group_error(
                response,
            )
        } else {
            crate::operation_deser::parse_decrease_node_groups_in_global_replication_group_response(
                response,
            )
        }
    }
}

/// Operation shape for `DecreaseReplicaCount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`decrease_replica_count`](crate::client::Client::decrease_replica_count).
///
/// See [`crate::client::fluent_builders::DecreaseReplicaCount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DecreaseReplicaCount {
    _private: (),
}
impl DecreaseReplicaCount {
    /// Creates a new builder-style object to manufacture [`DecreaseReplicaCountInput`](crate::input::DecreaseReplicaCountInput)
    pub fn builder() -> crate::input::decrease_replica_count_input::Builder {
        crate::input::decrease_replica_count_input::Builder::default()
    }
    /// Creates a new `DecreaseReplicaCount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DecreaseReplicaCount {
    type Output = std::result::Result<
        crate::output::DecreaseReplicaCountOutput,
        crate::error::DecreaseReplicaCountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_decrease_replica_count_error(response)
        } else {
            crate::operation_deser::parse_decrease_replica_count_response(response)
        }
    }
}

/// Operation shape for `DeleteCacheCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_cache_cluster`](crate::client::Client::delete_cache_cluster).
///
/// See [`crate::client::fluent_builders::DeleteCacheCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCacheCluster {
    _private: (),
}
impl DeleteCacheCluster {
    /// Creates a new builder-style object to manufacture [`DeleteCacheClusterInput`](crate::input::DeleteCacheClusterInput)
    pub fn builder() -> crate::input::delete_cache_cluster_input::Builder {
        crate::input::delete_cache_cluster_input::Builder::default()
    }
    /// Creates a new `DeleteCacheCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCacheCluster {
    type Output = std::result::Result<
        crate::output::DeleteCacheClusterOutput,
        crate::error::DeleteCacheClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_cache_cluster_error(response)
        } else {
            crate::operation_deser::parse_delete_cache_cluster_response(response)
        }
    }
}

/// Operation shape for `DeleteCacheParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_cache_parameter_group`](crate::client::Client::delete_cache_parameter_group).
///
/// See [`crate::client::fluent_builders::DeleteCacheParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCacheParameterGroup {
    _private: (),
}
impl DeleteCacheParameterGroup {
    /// Creates a new builder-style object to manufacture [`DeleteCacheParameterGroupInput`](crate::input::DeleteCacheParameterGroupInput)
    pub fn builder() -> crate::input::delete_cache_parameter_group_input::Builder {
        crate::input::delete_cache_parameter_group_input::Builder::default()
    }
    /// Creates a new `DeleteCacheParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCacheParameterGroup {
    type Output = std::result::Result<
        crate::output::DeleteCacheParameterGroupOutput,
        crate::error::DeleteCacheParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_cache_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_delete_cache_parameter_group_response(response)
        }
    }
}

/// Operation shape for `DeleteCacheSecurityGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_cache_security_group`](crate::client::Client::delete_cache_security_group).
///
/// See [`crate::client::fluent_builders::DeleteCacheSecurityGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCacheSecurityGroup {
    _private: (),
}
impl DeleteCacheSecurityGroup {
    /// Creates a new builder-style object to manufacture [`DeleteCacheSecurityGroupInput`](crate::input::DeleteCacheSecurityGroupInput)
    pub fn builder() -> crate::input::delete_cache_security_group_input::Builder {
        crate::input::delete_cache_security_group_input::Builder::default()
    }
    /// Creates a new `DeleteCacheSecurityGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCacheSecurityGroup {
    type Output = std::result::Result<
        crate::output::DeleteCacheSecurityGroupOutput,
        crate::error::DeleteCacheSecurityGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_cache_security_group_error(response)
        } else {
            crate::operation_deser::parse_delete_cache_security_group_response(response)
        }
    }
}

/// Operation shape for `DeleteCacheSubnetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_cache_subnet_group`](crate::client::Client::delete_cache_subnet_group).
///
/// See [`crate::client::fluent_builders::DeleteCacheSubnetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCacheSubnetGroup {
    _private: (),
}
impl DeleteCacheSubnetGroup {
    /// Creates a new builder-style object to manufacture [`DeleteCacheSubnetGroupInput`](crate::input::DeleteCacheSubnetGroupInput)
    pub fn builder() -> crate::input::delete_cache_subnet_group_input::Builder {
        crate::input::delete_cache_subnet_group_input::Builder::default()
    }
    /// Creates a new `DeleteCacheSubnetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCacheSubnetGroup {
    type Output = std::result::Result<
        crate::output::DeleteCacheSubnetGroupOutput,
        crate::error::DeleteCacheSubnetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_cache_subnet_group_error(response)
        } else {
            crate::operation_deser::parse_delete_cache_subnet_group_response(response)
        }
    }
}

/// Operation shape for `DeleteGlobalReplicationGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_global_replication_group`](crate::client::Client::delete_global_replication_group).
///
/// See [`crate::client::fluent_builders::DeleteGlobalReplicationGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGlobalReplicationGroup {
    _private: (),
}
impl DeleteGlobalReplicationGroup {
    /// Creates a new builder-style object to manufacture [`DeleteGlobalReplicationGroupInput`](crate::input::DeleteGlobalReplicationGroupInput)
    pub fn builder() -> crate::input::delete_global_replication_group_input::Builder {
        crate::input::delete_global_replication_group_input::Builder::default()
    }
    /// Creates a new `DeleteGlobalReplicationGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGlobalReplicationGroup {
    type Output = std::result::Result<
        crate::output::DeleteGlobalReplicationGroupOutput,
        crate::error::DeleteGlobalReplicationGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_global_replication_group_error(response)
        } else {
            crate::operation_deser::parse_delete_global_replication_group_response(response)
        }
    }
}

/// Operation shape for `DeleteReplicationGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_replication_group`](crate::client::Client::delete_replication_group).
///
/// See [`crate::client::fluent_builders::DeleteReplicationGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteReplicationGroup {
    _private: (),
}
impl DeleteReplicationGroup {
    /// Creates a new builder-style object to manufacture [`DeleteReplicationGroupInput`](crate::input::DeleteReplicationGroupInput)
    pub fn builder() -> crate::input::delete_replication_group_input::Builder {
        crate::input::delete_replication_group_input::Builder::default()
    }
    /// Creates a new `DeleteReplicationGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteReplicationGroup {
    type Output = std::result::Result<
        crate::output::DeleteReplicationGroupOutput,
        crate::error::DeleteReplicationGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_replication_group_error(response)
        } else {
            crate::operation_deser::parse_delete_replication_group_response(response)
        }
    }
}

/// Operation shape for `DeleteSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_snapshot`](crate::client::Client::delete_snapshot).
///
/// See [`crate::client::fluent_builders::DeleteSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSnapshot {
    _private: (),
}
impl DeleteSnapshot {
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotInput`](crate::input::DeleteSnapshotInput)
    pub fn builder() -> crate::input::delete_snapshot_input::Builder {
        crate::input::delete_snapshot_input::Builder::default()
    }
    /// Creates a new `DeleteSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSnapshot {
    type Output =
        std::result::Result<crate::output::DeleteSnapshotOutput, crate::error::DeleteSnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_snapshot_error(response)
        } else {
            crate::operation_deser::parse_delete_snapshot_response(response)
        }
    }
}

/// Operation shape for `DeleteUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user`](crate::client::Client::delete_user).
///
/// See [`crate::client::fluent_builders::DeleteUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUser {
    _private: (),
}
impl DeleteUser {
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
    /// Creates a new `DeleteUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUser {
    type Output =
        std::result::Result<crate::output::DeleteUserOutput, crate::error::DeleteUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_error(response)
        } else {
            crate::operation_deser::parse_delete_user_response(response)
        }
    }
}

/// Operation shape for `DeleteUserGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user_group`](crate::client::Client::delete_user_group).
///
/// See [`crate::client::fluent_builders::DeleteUserGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUserGroup {
    _private: (),
}
impl DeleteUserGroup {
    /// Creates a new builder-style object to manufacture [`DeleteUserGroupInput`](crate::input::DeleteUserGroupInput)
    pub fn builder() -> crate::input::delete_user_group_input::Builder {
        crate::input::delete_user_group_input::Builder::default()
    }
    /// Creates a new `DeleteUserGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUserGroup {
    type Output = std::result::Result<
        crate::output::DeleteUserGroupOutput,
        crate::error::DeleteUserGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_group_error(response)
        } else {
            crate::operation_deser::parse_delete_user_group_response(response)
        }
    }
}

/// Operation shape for `DescribeCacheClusters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cache_clusters`](crate::client::Client::describe_cache_clusters).
///
/// See [`crate::client::fluent_builders::DescribeCacheClusters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCacheClusters {
    _private: (),
}
impl DescribeCacheClusters {
    /// Creates a new builder-style object to manufacture [`DescribeCacheClustersInput`](crate::input::DescribeCacheClustersInput)
    pub fn builder() -> crate::input::describe_cache_clusters_input::Builder {
        crate::input::describe_cache_clusters_input::Builder::default()
    }
    /// Creates a new `DescribeCacheClusters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCacheClusters {
    type Output = std::result::Result<
        crate::output::DescribeCacheClustersOutput,
        crate::error::DescribeCacheClustersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cache_clusters_error(response)
        } else {
            crate::operation_deser::parse_describe_cache_clusters_response(response)
        }
    }
}

/// Operation shape for `DescribeCacheEngineVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cache_engine_versions`](crate::client::Client::describe_cache_engine_versions).
///
/// See [`crate::client::fluent_builders::DescribeCacheEngineVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCacheEngineVersions {
    _private: (),
}
impl DescribeCacheEngineVersions {
    /// Creates a new builder-style object to manufacture [`DescribeCacheEngineVersionsInput`](crate::input::DescribeCacheEngineVersionsInput)
    pub fn builder() -> crate::input::describe_cache_engine_versions_input::Builder {
        crate::input::describe_cache_engine_versions_input::Builder::default()
    }
    /// Creates a new `DescribeCacheEngineVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCacheEngineVersions {
    type Output = std::result::Result<
        crate::output::DescribeCacheEngineVersionsOutput,
        crate::error::DescribeCacheEngineVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cache_engine_versions_error(response)
        } else {
            crate::operation_deser::parse_describe_cache_engine_versions_response(response)
        }
    }
}

/// Operation shape for `DescribeCacheParameterGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cache_parameter_groups`](crate::client::Client::describe_cache_parameter_groups).
///
/// See [`crate::client::fluent_builders::DescribeCacheParameterGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCacheParameterGroups {
    _private: (),
}
impl DescribeCacheParameterGroups {
    /// Creates a new builder-style object to manufacture [`DescribeCacheParameterGroupsInput`](crate::input::DescribeCacheParameterGroupsInput)
    pub fn builder() -> crate::input::describe_cache_parameter_groups_input::Builder {
        crate::input::describe_cache_parameter_groups_input::Builder::default()
    }
    /// Creates a new `DescribeCacheParameterGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCacheParameterGroups {
    type Output = std::result::Result<
        crate::output::DescribeCacheParameterGroupsOutput,
        crate::error::DescribeCacheParameterGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cache_parameter_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_cache_parameter_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeCacheParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cache_parameters`](crate::client::Client::describe_cache_parameters).
///
/// See [`crate::client::fluent_builders::DescribeCacheParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCacheParameters {
    _private: (),
}
impl DescribeCacheParameters {
    /// Creates a new builder-style object to manufacture [`DescribeCacheParametersInput`](crate::input::DescribeCacheParametersInput)
    pub fn builder() -> crate::input::describe_cache_parameters_input::Builder {
        crate::input::describe_cache_parameters_input::Builder::default()
    }
    /// Creates a new `DescribeCacheParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCacheParameters {
    type Output = std::result::Result<
        crate::output::DescribeCacheParametersOutput,
        crate::error::DescribeCacheParametersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cache_parameters_error(response)
        } else {
            crate::operation_deser::parse_describe_cache_parameters_response(response)
        }
    }
}

/// Operation shape for `DescribeCacheSecurityGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cache_security_groups`](crate::client::Client::describe_cache_security_groups).
///
/// See [`crate::client::fluent_builders::DescribeCacheSecurityGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCacheSecurityGroups {
    _private: (),
}
impl DescribeCacheSecurityGroups {
    /// Creates a new builder-style object to manufacture [`DescribeCacheSecurityGroupsInput`](crate::input::DescribeCacheSecurityGroupsInput)
    pub fn builder() -> crate::input::describe_cache_security_groups_input::Builder {
        crate::input::describe_cache_security_groups_input::Builder::default()
    }
    /// Creates a new `DescribeCacheSecurityGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCacheSecurityGroups {
    type Output = std::result::Result<
        crate::output::DescribeCacheSecurityGroupsOutput,
        crate::error::DescribeCacheSecurityGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cache_security_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_cache_security_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeCacheSubnetGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cache_subnet_groups`](crate::client::Client::describe_cache_subnet_groups).
///
/// See [`crate::client::fluent_builders::DescribeCacheSubnetGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCacheSubnetGroups {
    _private: (),
}
impl DescribeCacheSubnetGroups {
    /// Creates a new builder-style object to manufacture [`DescribeCacheSubnetGroupsInput`](crate::input::DescribeCacheSubnetGroupsInput)
    pub fn builder() -> crate::input::describe_cache_subnet_groups_input::Builder {
        crate::input::describe_cache_subnet_groups_input::Builder::default()
    }
    /// Creates a new `DescribeCacheSubnetGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCacheSubnetGroups {
    type Output = std::result::Result<
        crate::output::DescribeCacheSubnetGroupsOutput,
        crate::error::DescribeCacheSubnetGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cache_subnet_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_cache_subnet_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeEngineDefaultParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_engine_default_parameters`](crate::client::Client::describe_engine_default_parameters).
///
/// See [`crate::client::fluent_builders::DescribeEngineDefaultParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEngineDefaultParameters {
    _private: (),
}
impl DescribeEngineDefaultParameters {
    /// Creates a new builder-style object to manufacture [`DescribeEngineDefaultParametersInput`](crate::input::DescribeEngineDefaultParametersInput)
    pub fn builder() -> crate::input::describe_engine_default_parameters_input::Builder {
        crate::input::describe_engine_default_parameters_input::Builder::default()
    }
    /// Creates a new `DescribeEngineDefaultParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEngineDefaultParameters {
    type Output = std::result::Result<
        crate::output::DescribeEngineDefaultParametersOutput,
        crate::error::DescribeEngineDefaultParametersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_engine_default_parameters_error(response)
        } else {
            crate::operation_deser::parse_describe_engine_default_parameters_response(response)
        }
    }
}

/// Operation shape for `DescribeEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_events`](crate::client::Client::describe_events).
///
/// See [`crate::client::fluent_builders::DescribeEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEvents {
    _private: (),
}
impl DescribeEvents {
    /// Creates a new builder-style object to manufacture [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    pub fn builder() -> crate::input::describe_events_input::Builder {
        crate::input::describe_events_input::Builder::default()
    }
    /// Creates a new `DescribeEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEvents {
    type Output =
        std::result::Result<crate::output::DescribeEventsOutput, crate::error::DescribeEventsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_events_error(response)
        } else {
            crate::operation_deser::parse_describe_events_response(response)
        }
    }
}

/// Operation shape for `DescribeGlobalReplicationGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_global_replication_groups`](crate::client::Client::describe_global_replication_groups).
///
/// See [`crate::client::fluent_builders::DescribeGlobalReplicationGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGlobalReplicationGroups {
    _private: (),
}
impl DescribeGlobalReplicationGroups {
    /// Creates a new builder-style object to manufacture [`DescribeGlobalReplicationGroupsInput`](crate::input::DescribeGlobalReplicationGroupsInput)
    pub fn builder() -> crate::input::describe_global_replication_groups_input::Builder {
        crate::input::describe_global_replication_groups_input::Builder::default()
    }
    /// Creates a new `DescribeGlobalReplicationGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGlobalReplicationGroups {
    type Output = std::result::Result<
        crate::output::DescribeGlobalReplicationGroupsOutput,
        crate::error::DescribeGlobalReplicationGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_global_replication_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_global_replication_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeReplicationGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_replication_groups`](crate::client::Client::describe_replication_groups).
///
/// See [`crate::client::fluent_builders::DescribeReplicationGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReplicationGroups {
    _private: (),
}
impl DescribeReplicationGroups {
    /// Creates a new builder-style object to manufacture [`DescribeReplicationGroupsInput`](crate::input::DescribeReplicationGroupsInput)
    pub fn builder() -> crate::input::describe_replication_groups_input::Builder {
        crate::input::describe_replication_groups_input::Builder::default()
    }
    /// Creates a new `DescribeReplicationGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReplicationGroups {
    type Output = std::result::Result<
        crate::output::DescribeReplicationGroupsOutput,
        crate::error::DescribeReplicationGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_replication_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_replication_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeReservedCacheNodes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_reserved_cache_nodes`](crate::client::Client::describe_reserved_cache_nodes).
///
/// See [`crate::client::fluent_builders::DescribeReservedCacheNodes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReservedCacheNodes {
    _private: (),
}
impl DescribeReservedCacheNodes {
    /// Creates a new builder-style object to manufacture [`DescribeReservedCacheNodesInput`](crate::input::DescribeReservedCacheNodesInput)
    pub fn builder() -> crate::input::describe_reserved_cache_nodes_input::Builder {
        crate::input::describe_reserved_cache_nodes_input::Builder::default()
    }
    /// Creates a new `DescribeReservedCacheNodes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReservedCacheNodes {
    type Output = std::result::Result<
        crate::output::DescribeReservedCacheNodesOutput,
        crate::error::DescribeReservedCacheNodesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_reserved_cache_nodes_error(response)
        } else {
            crate::operation_deser::parse_describe_reserved_cache_nodes_response(response)
        }
    }
}

/// Operation shape for `DescribeReservedCacheNodesOfferings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_reserved_cache_nodes_offerings`](crate::client::Client::describe_reserved_cache_nodes_offerings).
///
/// See [`crate::client::fluent_builders::DescribeReservedCacheNodesOfferings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReservedCacheNodesOfferings {
    _private: (),
}
impl DescribeReservedCacheNodesOfferings {
    /// Creates a new builder-style object to manufacture [`DescribeReservedCacheNodesOfferingsInput`](crate::input::DescribeReservedCacheNodesOfferingsInput)
    pub fn builder() -> crate::input::describe_reserved_cache_nodes_offerings_input::Builder {
        crate::input::describe_reserved_cache_nodes_offerings_input::Builder::default()
    }
    /// Creates a new `DescribeReservedCacheNodesOfferings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReservedCacheNodesOfferings {
    type Output = std::result::Result<
        crate::output::DescribeReservedCacheNodesOfferingsOutput,
        crate::error::DescribeReservedCacheNodesOfferingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_reserved_cache_nodes_offerings_error(response)
        } else {
            crate::operation_deser::parse_describe_reserved_cache_nodes_offerings_response(response)
        }
    }
}

/// Operation shape for `DescribeServiceUpdates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_service_updates`](crate::client::Client::describe_service_updates).
///
/// See [`crate::client::fluent_builders::DescribeServiceUpdates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeServiceUpdates {
    _private: (),
}
impl DescribeServiceUpdates {
    /// Creates a new builder-style object to manufacture [`DescribeServiceUpdatesInput`](crate::input::DescribeServiceUpdatesInput)
    pub fn builder() -> crate::input::describe_service_updates_input::Builder {
        crate::input::describe_service_updates_input::Builder::default()
    }
    /// Creates a new `DescribeServiceUpdates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeServiceUpdates {
    type Output = std::result::Result<
        crate::output::DescribeServiceUpdatesOutput,
        crate::error::DescribeServiceUpdatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_service_updates_error(response)
        } else {
            crate::operation_deser::parse_describe_service_updates_response(response)
        }
    }
}

/// Operation shape for `DescribeSnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_snapshots`](crate::client::Client::describe_snapshots).
///
/// See [`crate::client::fluent_builders::DescribeSnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSnapshots {
    _private: (),
}
impl DescribeSnapshots {
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotsInput`](crate::input::DescribeSnapshotsInput)
    pub fn builder() -> crate::input::describe_snapshots_input::Builder {
        crate::input::describe_snapshots_input::Builder::default()
    }
    /// Creates a new `DescribeSnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSnapshots {
    type Output = std::result::Result<
        crate::output::DescribeSnapshotsOutput,
        crate::error::DescribeSnapshotsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_snapshots_error(response)
        } else {
            crate::operation_deser::parse_describe_snapshots_response(response)
        }
    }
}

/// Operation shape for `DescribeUpdateActions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_update_actions`](crate::client::Client::describe_update_actions).
///
/// See [`crate::client::fluent_builders::DescribeUpdateActions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUpdateActions {
    _private: (),
}
impl DescribeUpdateActions {
    /// Creates a new builder-style object to manufacture [`DescribeUpdateActionsInput`](crate::input::DescribeUpdateActionsInput)
    pub fn builder() -> crate::input::describe_update_actions_input::Builder {
        crate::input::describe_update_actions_input::Builder::default()
    }
    /// Creates a new `DescribeUpdateActions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUpdateActions {
    type Output = std::result::Result<
        crate::output::DescribeUpdateActionsOutput,
        crate::error::DescribeUpdateActionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_update_actions_error(response)
        } else {
            crate::operation_deser::parse_describe_update_actions_response(response)
        }
    }
}

/// Operation shape for `DescribeUserGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_user_groups`](crate::client::Client::describe_user_groups).
///
/// See [`crate::client::fluent_builders::DescribeUserGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUserGroups {
    _private: (),
}
impl DescribeUserGroups {
    /// Creates a new builder-style object to manufacture [`DescribeUserGroupsInput`](crate::input::DescribeUserGroupsInput)
    pub fn builder() -> crate::input::describe_user_groups_input::Builder {
        crate::input::describe_user_groups_input::Builder::default()
    }
    /// Creates a new `DescribeUserGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUserGroups {
    type Output = std::result::Result<
        crate::output::DescribeUserGroupsOutput,
        crate::error::DescribeUserGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_user_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_user_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeUsers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_users`](crate::client::Client::describe_users).
///
/// See [`crate::client::fluent_builders::DescribeUsers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUsers {
    _private: (),
}
impl DescribeUsers {
    /// Creates a new builder-style object to manufacture [`DescribeUsersInput`](crate::input::DescribeUsersInput)
    pub fn builder() -> crate::input::describe_users_input::Builder {
        crate::input::describe_users_input::Builder::default()
    }
    /// Creates a new `DescribeUsers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUsers {
    type Output =
        std::result::Result<crate::output::DescribeUsersOutput, crate::error::DescribeUsersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_users_error(response)
        } else {
            crate::operation_deser::parse_describe_users_response(response)
        }
    }
}

/// Operation shape for `DisassociateGlobalReplicationGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_global_replication_group`](crate::client::Client::disassociate_global_replication_group).
///
/// See [`crate::client::fluent_builders::DisassociateGlobalReplicationGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateGlobalReplicationGroup {
    _private: (),
}
impl DisassociateGlobalReplicationGroup {
    /// Creates a new builder-style object to manufacture [`DisassociateGlobalReplicationGroupInput`](crate::input::DisassociateGlobalReplicationGroupInput)
    pub fn builder() -> crate::input::disassociate_global_replication_group_input::Builder {
        crate::input::disassociate_global_replication_group_input::Builder::default()
    }
    /// Creates a new `DisassociateGlobalReplicationGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateGlobalReplicationGroup {
    type Output = std::result::Result<
        crate::output::DisassociateGlobalReplicationGroupOutput,
        crate::error::DisassociateGlobalReplicationGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_global_replication_group_error(response)
        } else {
            crate::operation_deser::parse_disassociate_global_replication_group_response(response)
        }
    }
}

/// Operation shape for `FailoverGlobalReplicationGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`failover_global_replication_group`](crate::client::Client::failover_global_replication_group).
///
/// See [`crate::client::fluent_builders::FailoverGlobalReplicationGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct FailoverGlobalReplicationGroup {
    _private: (),
}
impl FailoverGlobalReplicationGroup {
    /// Creates a new builder-style object to manufacture [`FailoverGlobalReplicationGroupInput`](crate::input::FailoverGlobalReplicationGroupInput)
    pub fn builder() -> crate::input::failover_global_replication_group_input::Builder {
        crate::input::failover_global_replication_group_input::Builder::default()
    }
    /// Creates a new `FailoverGlobalReplicationGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for FailoverGlobalReplicationGroup {
    type Output = std::result::Result<
        crate::output::FailoverGlobalReplicationGroupOutput,
        crate::error::FailoverGlobalReplicationGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_failover_global_replication_group_error(response)
        } else {
            crate::operation_deser::parse_failover_global_replication_group_response(response)
        }
    }
}

/// Operation shape for `IncreaseNodeGroupsInGlobalReplicationGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`increase_node_groups_in_global_replication_group`](crate::client::Client::increase_node_groups_in_global_replication_group).
///
/// See [`crate::client::fluent_builders::IncreaseNodeGroupsInGlobalReplicationGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct IncreaseNodeGroupsInGlobalReplicationGroup {
    _private: (),
}
impl IncreaseNodeGroupsInGlobalReplicationGroup {
    /// Creates a new builder-style object to manufacture [`IncreaseNodeGroupsInGlobalReplicationGroupInput`](crate::input::IncreaseNodeGroupsInGlobalReplicationGroupInput)
    pub fn builder() -> crate::input::increase_node_groups_in_global_replication_group_input::Builder
    {
        crate::input::increase_node_groups_in_global_replication_group_input::Builder::default()
    }
    /// Creates a new `IncreaseNodeGroupsInGlobalReplicationGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for IncreaseNodeGroupsInGlobalReplicationGroup {
    type Output = std::result::Result<
        crate::output::IncreaseNodeGroupsInGlobalReplicationGroupOutput,
        crate::error::IncreaseNodeGroupsInGlobalReplicationGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_increase_node_groups_in_global_replication_group_error(
                response,
            )
        } else {
            crate::operation_deser::parse_increase_node_groups_in_global_replication_group_response(
                response,
            )
        }
    }
}

/// Operation shape for `IncreaseReplicaCount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`increase_replica_count`](crate::client::Client::increase_replica_count).
///
/// See [`crate::client::fluent_builders::IncreaseReplicaCount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct IncreaseReplicaCount {
    _private: (),
}
impl IncreaseReplicaCount {
    /// Creates a new builder-style object to manufacture [`IncreaseReplicaCountInput`](crate::input::IncreaseReplicaCountInput)
    pub fn builder() -> crate::input::increase_replica_count_input::Builder {
        crate::input::increase_replica_count_input::Builder::default()
    }
    /// Creates a new `IncreaseReplicaCount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for IncreaseReplicaCount {
    type Output = std::result::Result<
        crate::output::IncreaseReplicaCountOutput,
        crate::error::IncreaseReplicaCountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_increase_replica_count_error(response)
        } else {
            crate::operation_deser::parse_increase_replica_count_response(response)
        }
    }
}

/// Operation shape for `ListAllowedNodeTypeModifications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_allowed_node_type_modifications`](crate::client::Client::list_allowed_node_type_modifications).
///
/// See [`crate::client::fluent_builders::ListAllowedNodeTypeModifications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAllowedNodeTypeModifications {
    _private: (),
}
impl ListAllowedNodeTypeModifications {
    /// Creates a new builder-style object to manufacture [`ListAllowedNodeTypeModificationsInput`](crate::input::ListAllowedNodeTypeModificationsInput)
    pub fn builder() -> crate::input::list_allowed_node_type_modifications_input::Builder {
        crate::input::list_allowed_node_type_modifications_input::Builder::default()
    }
    /// Creates a new `ListAllowedNodeTypeModifications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAllowedNodeTypeModifications {
    type Output = std::result::Result<
        crate::output::ListAllowedNodeTypeModificationsOutput,
        crate::error::ListAllowedNodeTypeModificationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_allowed_node_type_modifications_error(response)
        } else {
            crate::operation_deser::parse_list_allowed_node_type_modifications_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ModifyCacheCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_cache_cluster`](crate::client::Client::modify_cache_cluster).
///
/// See [`crate::client::fluent_builders::ModifyCacheCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyCacheCluster {
    _private: (),
}
impl ModifyCacheCluster {
    /// Creates a new builder-style object to manufacture [`ModifyCacheClusterInput`](crate::input::ModifyCacheClusterInput)
    pub fn builder() -> crate::input::modify_cache_cluster_input::Builder {
        crate::input::modify_cache_cluster_input::Builder::default()
    }
    /// Creates a new `ModifyCacheCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyCacheCluster {
    type Output = std::result::Result<
        crate::output::ModifyCacheClusterOutput,
        crate::error::ModifyCacheClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_cache_cluster_error(response)
        } else {
            crate::operation_deser::parse_modify_cache_cluster_response(response)
        }
    }
}

/// Operation shape for `ModifyCacheParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_cache_parameter_group`](crate::client::Client::modify_cache_parameter_group).
///
/// See [`crate::client::fluent_builders::ModifyCacheParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyCacheParameterGroup {
    _private: (),
}
impl ModifyCacheParameterGroup {
    /// Creates a new builder-style object to manufacture [`ModifyCacheParameterGroupInput`](crate::input::ModifyCacheParameterGroupInput)
    pub fn builder() -> crate::input::modify_cache_parameter_group_input::Builder {
        crate::input::modify_cache_parameter_group_input::Builder::default()
    }
    /// Creates a new `ModifyCacheParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyCacheParameterGroup {
    type Output = std::result::Result<
        crate::output::ModifyCacheParameterGroupOutput,
        crate::error::ModifyCacheParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_cache_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_modify_cache_parameter_group_response(response)
        }
    }
}

/// Operation shape for `ModifyCacheSubnetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_cache_subnet_group`](crate::client::Client::modify_cache_subnet_group).
///
/// See [`crate::client::fluent_builders::ModifyCacheSubnetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyCacheSubnetGroup {
    _private: (),
}
impl ModifyCacheSubnetGroup {
    /// Creates a new builder-style object to manufacture [`ModifyCacheSubnetGroupInput`](crate::input::ModifyCacheSubnetGroupInput)
    pub fn builder() -> crate::input::modify_cache_subnet_group_input::Builder {
        crate::input::modify_cache_subnet_group_input::Builder::default()
    }
    /// Creates a new `ModifyCacheSubnetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyCacheSubnetGroup {
    type Output = std::result::Result<
        crate::output::ModifyCacheSubnetGroupOutput,
        crate::error::ModifyCacheSubnetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_cache_subnet_group_error(response)
        } else {
            crate::operation_deser::parse_modify_cache_subnet_group_response(response)
        }
    }
}

/// Operation shape for `ModifyGlobalReplicationGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_global_replication_group`](crate::client::Client::modify_global_replication_group).
///
/// See [`crate::client::fluent_builders::ModifyGlobalReplicationGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyGlobalReplicationGroup {
    _private: (),
}
impl ModifyGlobalReplicationGroup {
    /// Creates a new builder-style object to manufacture [`ModifyGlobalReplicationGroupInput`](crate::input::ModifyGlobalReplicationGroupInput)
    pub fn builder() -> crate::input::modify_global_replication_group_input::Builder {
        crate::input::modify_global_replication_group_input::Builder::default()
    }
    /// Creates a new `ModifyGlobalReplicationGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyGlobalReplicationGroup {
    type Output = std::result::Result<
        crate::output::ModifyGlobalReplicationGroupOutput,
        crate::error::ModifyGlobalReplicationGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_global_replication_group_error(response)
        } else {
            crate::operation_deser::parse_modify_global_replication_group_response(response)
        }
    }
}

/// Operation shape for `ModifyReplicationGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_replication_group`](crate::client::Client::modify_replication_group).
///
/// See [`crate::client::fluent_builders::ModifyReplicationGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyReplicationGroup {
    _private: (),
}
impl ModifyReplicationGroup {
    /// Creates a new builder-style object to manufacture [`ModifyReplicationGroupInput`](crate::input::ModifyReplicationGroupInput)
    pub fn builder() -> crate::input::modify_replication_group_input::Builder {
        crate::input::modify_replication_group_input::Builder::default()
    }
    /// Creates a new `ModifyReplicationGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyReplicationGroup {
    type Output = std::result::Result<
        crate::output::ModifyReplicationGroupOutput,
        crate::error::ModifyReplicationGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_replication_group_error(response)
        } else {
            crate::operation_deser::parse_modify_replication_group_response(response)
        }
    }
}

/// Operation shape for `ModifyReplicationGroupShardConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_replication_group_shard_configuration`](crate::client::Client::modify_replication_group_shard_configuration).
///
/// See [`crate::client::fluent_builders::ModifyReplicationGroupShardConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyReplicationGroupShardConfiguration {
    _private: (),
}
impl ModifyReplicationGroupShardConfiguration {
    /// Creates a new builder-style object to manufacture [`ModifyReplicationGroupShardConfigurationInput`](crate::input::ModifyReplicationGroupShardConfigurationInput)
    pub fn builder() -> crate::input::modify_replication_group_shard_configuration_input::Builder {
        crate::input::modify_replication_group_shard_configuration_input::Builder::default()
    }
    /// Creates a new `ModifyReplicationGroupShardConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyReplicationGroupShardConfiguration {
    type Output = std::result::Result<
        crate::output::ModifyReplicationGroupShardConfigurationOutput,
        crate::error::ModifyReplicationGroupShardConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_replication_group_shard_configuration_error(
                response,
            )
        } else {
            crate::operation_deser::parse_modify_replication_group_shard_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `ModifyUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_user`](crate::client::Client::modify_user).
///
/// See [`crate::client::fluent_builders::ModifyUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyUser {
    _private: (),
}
impl ModifyUser {
    /// Creates a new builder-style object to manufacture [`ModifyUserInput`](crate::input::ModifyUserInput)
    pub fn builder() -> crate::input::modify_user_input::Builder {
        crate::input::modify_user_input::Builder::default()
    }
    /// Creates a new `ModifyUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyUser {
    type Output =
        std::result::Result<crate::output::ModifyUserOutput, crate::error::ModifyUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_user_error(response)
        } else {
            crate::operation_deser::parse_modify_user_response(response)
        }
    }
}

/// Operation shape for `ModifyUserGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_user_group`](crate::client::Client::modify_user_group).
///
/// See [`crate::client::fluent_builders::ModifyUserGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyUserGroup {
    _private: (),
}
impl ModifyUserGroup {
    /// Creates a new builder-style object to manufacture [`ModifyUserGroupInput`](crate::input::ModifyUserGroupInput)
    pub fn builder() -> crate::input::modify_user_group_input::Builder {
        crate::input::modify_user_group_input::Builder::default()
    }
    /// Creates a new `ModifyUserGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyUserGroup {
    type Output = std::result::Result<
        crate::output::ModifyUserGroupOutput,
        crate::error::ModifyUserGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_user_group_error(response)
        } else {
            crate::operation_deser::parse_modify_user_group_response(response)
        }
    }
}

/// Operation shape for `PurchaseReservedCacheNodesOffering`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`purchase_reserved_cache_nodes_offering`](crate::client::Client::purchase_reserved_cache_nodes_offering).
///
/// See [`crate::client::fluent_builders::PurchaseReservedCacheNodesOffering`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PurchaseReservedCacheNodesOffering {
    _private: (),
}
impl PurchaseReservedCacheNodesOffering {
    /// Creates a new builder-style object to manufacture [`PurchaseReservedCacheNodesOfferingInput`](crate::input::PurchaseReservedCacheNodesOfferingInput)
    pub fn builder() -> crate::input::purchase_reserved_cache_nodes_offering_input::Builder {
        crate::input::purchase_reserved_cache_nodes_offering_input::Builder::default()
    }
    /// Creates a new `PurchaseReservedCacheNodesOffering` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PurchaseReservedCacheNodesOffering {
    type Output = std::result::Result<
        crate::output::PurchaseReservedCacheNodesOfferingOutput,
        crate::error::PurchaseReservedCacheNodesOfferingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_purchase_reserved_cache_nodes_offering_error(response)
        } else {
            crate::operation_deser::parse_purchase_reserved_cache_nodes_offering_response(response)
        }
    }
}

/// Operation shape for `RebalanceSlotsInGlobalReplicationGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`rebalance_slots_in_global_replication_group`](crate::client::Client::rebalance_slots_in_global_replication_group).
///
/// See [`crate::client::fluent_builders::RebalanceSlotsInGlobalReplicationGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RebalanceSlotsInGlobalReplicationGroup {
    _private: (),
}
impl RebalanceSlotsInGlobalReplicationGroup {
    /// Creates a new builder-style object to manufacture [`RebalanceSlotsInGlobalReplicationGroupInput`](crate::input::RebalanceSlotsInGlobalReplicationGroupInput)
    pub fn builder() -> crate::input::rebalance_slots_in_global_replication_group_input::Builder {
        crate::input::rebalance_slots_in_global_replication_group_input::Builder::default()
    }
    /// Creates a new `RebalanceSlotsInGlobalReplicationGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RebalanceSlotsInGlobalReplicationGroup {
    type Output = std::result::Result<
        crate::output::RebalanceSlotsInGlobalReplicationGroupOutput,
        crate::error::RebalanceSlotsInGlobalReplicationGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_rebalance_slots_in_global_replication_group_error(
                response,
            )
        } else {
            crate::operation_deser::parse_rebalance_slots_in_global_replication_group_response(
                response,
            )
        }
    }
}

/// Operation shape for `RebootCacheCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reboot_cache_cluster`](crate::client::Client::reboot_cache_cluster).
///
/// See [`crate::client::fluent_builders::RebootCacheCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RebootCacheCluster {
    _private: (),
}
impl RebootCacheCluster {
    /// Creates a new builder-style object to manufacture [`RebootCacheClusterInput`](crate::input::RebootCacheClusterInput)
    pub fn builder() -> crate::input::reboot_cache_cluster_input::Builder {
        crate::input::reboot_cache_cluster_input::Builder::default()
    }
    /// Creates a new `RebootCacheCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RebootCacheCluster {
    type Output = std::result::Result<
        crate::output::RebootCacheClusterOutput,
        crate::error::RebootCacheClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reboot_cache_cluster_error(response)
        } else {
            crate::operation_deser::parse_reboot_cache_cluster_response(response)
        }
    }
}

/// Operation shape for `RemoveTagsFromResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_tags_from_resource`](crate::client::Client::remove_tags_from_resource).
///
/// See [`crate::client::fluent_builders::RemoveTagsFromResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveTagsFromResource {
    _private: (),
}
impl RemoveTagsFromResource {
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    pub fn builder() -> crate::input::remove_tags_from_resource_input::Builder {
        crate::input::remove_tags_from_resource_input::Builder::default()
    }
    /// Creates a new `RemoveTagsFromResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveTagsFromResource {
    type Output = std::result::Result<
        crate::output::RemoveTagsFromResourceOutput,
        crate::error::RemoveTagsFromResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_tags_from_resource_error(response)
        } else {
            crate::operation_deser::parse_remove_tags_from_resource_response(response)
        }
    }
}

/// Operation shape for `ResetCacheParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_cache_parameter_group`](crate::client::Client::reset_cache_parameter_group).
///
/// See [`crate::client::fluent_builders::ResetCacheParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetCacheParameterGroup {
    _private: (),
}
impl ResetCacheParameterGroup {
    /// Creates a new builder-style object to manufacture [`ResetCacheParameterGroupInput`](crate::input::ResetCacheParameterGroupInput)
    pub fn builder() -> crate::input::reset_cache_parameter_group_input::Builder {
        crate::input::reset_cache_parameter_group_input::Builder::default()
    }
    /// Creates a new `ResetCacheParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetCacheParameterGroup {
    type Output = std::result::Result<
        crate::output::ResetCacheParameterGroupOutput,
        crate::error::ResetCacheParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_cache_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_reset_cache_parameter_group_response(response)
        }
    }
}

/// Operation shape for `RevokeCacheSecurityGroupIngress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`revoke_cache_security_group_ingress`](crate::client::Client::revoke_cache_security_group_ingress).
///
/// See [`crate::client::fluent_builders::RevokeCacheSecurityGroupIngress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RevokeCacheSecurityGroupIngress {
    _private: (),
}
impl RevokeCacheSecurityGroupIngress {
    /// Creates a new builder-style object to manufacture [`RevokeCacheSecurityGroupIngressInput`](crate::input::RevokeCacheSecurityGroupIngressInput)
    pub fn builder() -> crate::input::revoke_cache_security_group_ingress_input::Builder {
        crate::input::revoke_cache_security_group_ingress_input::Builder::default()
    }
    /// Creates a new `RevokeCacheSecurityGroupIngress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RevokeCacheSecurityGroupIngress {
    type Output = std::result::Result<
        crate::output::RevokeCacheSecurityGroupIngressOutput,
        crate::error::RevokeCacheSecurityGroupIngressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_revoke_cache_security_group_ingress_error(response)
        } else {
            crate::operation_deser::parse_revoke_cache_security_group_ingress_response(response)
        }
    }
}

/// Operation shape for `StartMigration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_migration`](crate::client::Client::start_migration).
///
/// See [`crate::client::fluent_builders::StartMigration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartMigration {
    _private: (),
}
impl StartMigration {
    /// Creates a new builder-style object to manufacture [`StartMigrationInput`](crate::input::StartMigrationInput)
    pub fn builder() -> crate::input::start_migration_input::Builder {
        crate::input::start_migration_input::Builder::default()
    }
    /// Creates a new `StartMigration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartMigration {
    type Output =
        std::result::Result<crate::output::StartMigrationOutput, crate::error::StartMigrationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_migration_error(response)
        } else {
            crate::operation_deser::parse_start_migration_response(response)
        }
    }
}

/// Operation shape for `TestFailover`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`test_failover`](crate::client::Client::test_failover).
///
/// See [`crate::client::fluent_builders::TestFailover`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TestFailover {
    _private: (),
}
impl TestFailover {
    /// Creates a new builder-style object to manufacture [`TestFailoverInput`](crate::input::TestFailoverInput)
    pub fn builder() -> crate::input::test_failover_input::Builder {
        crate::input::test_failover_input::Builder::default()
    }
    /// Creates a new `TestFailover` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TestFailover {
    type Output =
        std::result::Result<crate::output::TestFailoverOutput, crate::error::TestFailoverError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_test_failover_error(response)
        } else {
            crate::operation_deser::parse_test_failover_response(response)
        }
    }
}
