// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The customer has exceeded the allowed rate of API calls.</p>
    ApiCallRateForCustomerExceededFault(crate::error::ApiCallRateForCustomerExceededFault),
    /// <p>The specified Amazon EC2 security group is already authorized for the specified cache security group.</p>
    AuthorizationAlreadyExistsFault(crate::error::AuthorizationAlreadyExistsFault),
    /// <p>The specified Amazon EC2 security group is not authorized for the specified cache security group.</p>
    AuthorizationNotFoundFault(crate::error::AuthorizationNotFoundFault),
    /// <p>You already have a cluster with the given identifier.</p>
    CacheClusterAlreadyExistsFault(crate::error::CacheClusterAlreadyExistsFault),
    /// <p>The requested cluster ID does not refer to an existing cluster.</p>
    CacheClusterNotFoundFault(crate::error::CacheClusterNotFoundFault),
    /// <p>A cache parameter group with the requested name already exists.</p>
    CacheParameterGroupAlreadyExistsFault(crate::error::CacheParameterGroupAlreadyExistsFault),
    /// <p>The requested cache parameter group name does not refer to an existing cache parameter group.</p>
    CacheParameterGroupNotFoundFault(crate::error::CacheParameterGroupNotFoundFault),
    /// <p>The request cannot be processed because it would exceed the maximum number of cache security groups.</p>
    CacheParameterGroupQuotaExceededFault(crate::error::CacheParameterGroupQuotaExceededFault),
    /// <p>A cache security group with the specified name already exists.</p>
    CacheSecurityGroupAlreadyExistsFault(crate::error::CacheSecurityGroupAlreadyExistsFault),
    /// <p>The requested cache security group name does not refer to an existing cache security group.</p>
    CacheSecurityGroupNotFoundFault(crate::error::CacheSecurityGroupNotFoundFault),
    /// <p>The request cannot be processed because it would exceed the allowed number of cache security groups.</p>
    CacheSecurityGroupQuotaExceededFault(crate::error::CacheSecurityGroupQuotaExceededFault),
    /// <p>The requested cache subnet group name is already in use by an existing cache subnet group.</p>
    CacheSubnetGroupAlreadyExistsFault(crate::error::CacheSubnetGroupAlreadyExistsFault),
    /// <p>The requested cache subnet group is currently in use.</p>
    CacheSubnetGroupInUse(crate::error::CacheSubnetGroupInUse),
    /// <p>The requested cache subnet group name does not refer to an existing cache subnet group.</p>
    CacheSubnetGroupNotFoundFault(crate::error::CacheSubnetGroupNotFoundFault),
    /// <p>The request cannot be processed because it would exceed the allowed number of cache subnet groups.</p>
    CacheSubnetGroupQuotaExceededFault(crate::error::CacheSubnetGroupQuotaExceededFault),
    /// <p>The request cannot be processed because it would exceed the allowed number of subnets in a cache subnet group.</p>
    CacheSubnetQuotaExceededFault(crate::error::CacheSubnetQuotaExceededFault),
    /// <p>The request cannot be processed because it would exceed the allowed number of clusters per customer.</p>
    ClusterQuotaForCustomerExceededFault(crate::error::ClusterQuotaForCustomerExceededFault),
    /// <p>The default user assigned to the user group.</p>
    DefaultUserAssociatedToUserGroupFault(crate::error::DefaultUserAssociatedToUserGroupFault),
    /// <p>You must add default user to a user group.</p>
    DefaultUserRequired(crate::error::DefaultUserRequired),
    /// <p>A user with this username already exists.</p>
    DuplicateUserNameFault(crate::error::DuplicateUserNameFault),
    /// <p>The Global datastore name already exists.</p>
    GlobalReplicationGroupAlreadyExistsFault(
        crate::error::GlobalReplicationGroupAlreadyExistsFault,
    ),
    /// <p>The Global datastore does not exist</p>
    GlobalReplicationGroupNotFoundFault(crate::error::GlobalReplicationGroupNotFoundFault),
    /// <p>The requested cache node type is not available in the specified Availability Zone.
    /// For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY">InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</p>
    InsufficientCacheClusterCapacityFault(crate::error::InsufficientCacheClusterCapacityFault),
    /// <p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>
    InvalidArnFault(crate::error::InvalidArnFault),
    /// <p>The requested cluster is not in the <code>available</code> state.</p>
    InvalidCacheClusterStateFault(crate::error::InvalidCacheClusterStateFault),
    /// <p>The current state of the cache parameter group does not allow the requested operation to occur.</p>
    InvalidCacheParameterGroupStateFault(crate::error::InvalidCacheParameterGroupStateFault),
    /// <p>The current state of the cache security group does not allow deletion.</p>
    InvalidCacheSecurityGroupStateFault(crate::error::InvalidCacheSecurityGroupStateFault),
    /// <p>The Global datastore is not available or in primary-only state.</p>
    InvalidGlobalReplicationGroupStateFault(crate::error::InvalidGlobalReplicationGroupStateFault),
    /// <p>The KMS key supplied is not valid.</p>
    InvalidKmsKeyFault(crate::error::InvalidKmsKeyFault),
    /// <p>Two or more incompatible parameters were specified.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value for a parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The requested replication group is not in the <code>available</code> state.</p>
    InvalidReplicationGroupStateFault(crate::error::InvalidReplicationGroupStateFault),
    /// <p>The current state of the snapshot does not allow the requested operation to occur.</p>
    InvalidSnapshotStateFault(crate::error::InvalidSnapshotStateFault),
    /// <p>An invalid subnet identifier was specified.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The user group is not in an active state.</p>
    InvalidUserGroupStateFault(crate::error::InvalidUserGroupStateFault),
    /// <p>The user is not in active state.</p>
    InvalidUserStateFault(crate::error::InvalidUserStateFault),
    /// <p>The VPC network is in an invalid state.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>The operation was not performed because no changes were required.</p>
    NoOperationFault(crate::error::NoOperationFault),
    /// <p>The node group specified by the <code>NodeGroupId</code> parameter could not be found.
    /// Please verify that the node group exists and that you spelled the <code>NodeGroupId</code> value correctly.</p>
    NodeGroupNotFoundFault(crate::error::NodeGroupNotFoundFault),
    /// <p>The request cannot be processed because it would exceed the maximum allowed number
    /// of node groups (shards) in a single replication group. The default maximum is 90</p>
    NodeGroupsPerReplicationGroupQuotaExceededFault(
        crate::error::NodeGroupsPerReplicationGroupQuotaExceededFault,
    ),
    /// <p>The request cannot be processed because it would exceed the allowed number of cache nodes in a single cluster.</p>
    NodeQuotaForClusterExceededFault(crate::error::NodeQuotaForClusterExceededFault),
    /// <p>The request cannot be processed because it would exceed the allowed number of cache nodes per customer.</p>
    NodeQuotaForCustomerExceededFault(crate::error::NodeQuotaForCustomerExceededFault),
    /// <p>The specified replication group already exists.</p>
    ReplicationGroupAlreadyExistsFault(crate::error::ReplicationGroupAlreadyExistsFault),
    /// <p>The targeted replication group is not available. </p>
    ReplicationGroupAlreadyUnderMigrationFault(
        crate::error::ReplicationGroupAlreadyUnderMigrationFault,
    ),
    /// <p>The specified replication group does not exist.</p>
    ReplicationGroupNotFoundFault(crate::error::ReplicationGroupNotFoundFault),
    /// <p>The designated replication group is not available for data migration.</p>
    ReplicationGroupNotUnderMigrationFault(crate::error::ReplicationGroupNotUnderMigrationFault),
    /// <p>You already have a reservation with the given identifier.</p>
    ReservedCacheNodeAlreadyExistsFault(crate::error::ReservedCacheNodeAlreadyExistsFault),
    /// <p>The requested reserved cache node was not found.</p>
    ReservedCacheNodeNotFoundFault(crate::error::ReservedCacheNodeNotFoundFault),
    /// <p>The request cannot be processed because it would exceed the user's cache node quota.</p>
    ReservedCacheNodeQuotaExceededFault(crate::error::ReservedCacheNodeQuotaExceededFault),
    /// <p>The requested cache node offering does not exist.</p>
    ReservedCacheNodesOfferingNotFoundFault(crate::error::ReservedCacheNodesOfferingNotFoundFault),
    /// <p>The specified service linked role (SLR) was not found.</p>
    ServiceLinkedRoleNotFoundFault(crate::error::ServiceLinkedRoleNotFoundFault),
    /// <p>The service update doesn't exist</p>
    ServiceUpdateNotFoundFault(crate::error::ServiceUpdateNotFoundFault),
    /// <p>You already have a snapshot with the given name.</p>
    SnapshotAlreadyExistsFault(crate::error::SnapshotAlreadyExistsFault),
    /// <p>You attempted one of the following operations:</p>
    /// <ul>
    /// <li>
    /// <p>Creating a snapshot of a Redis cluster running on a <code>cache.t1.micro</code> cache
    /// node.</p>
    /// </li>
    /// <li>
    /// <p>Creating a snapshot of a cluster that is running Memcached rather than Redis.</p>
    /// </li>
    /// </ul>
    /// <p>Neither of these are supported by ElastiCache.</p>
    SnapshotFeatureNotSupportedFault(crate::error::SnapshotFeatureNotSupportedFault),
    /// <p>The requested snapshot name does not refer to an existing snapshot.</p>
    SnapshotNotFoundFault(crate::error::SnapshotNotFoundFault),
    /// <p>The request cannot be processed because it would exceed the maximum number of snapshots.</p>
    SnapshotQuotaExceededFault(crate::error::SnapshotQuotaExceededFault),
    /// <p>The requested subnet is being used by another cache subnet group.</p>
    SubnetInUse(crate::error::SubnetInUse),
    /// <p>At least one subnet ID does not match the other subnet IDs. This mismatch typically occurs when a
    /// user sets one subnet ID to a regional Availability Zone and a different one to an outpost. Or when a user sets the subnet ID to an Outpost when not subscribed on this service.</p>
    SubnetNotAllowedFault(crate::error::SubnetNotAllowedFault),
    /// <p>The requested tag was not found on this resource.</p>
    TagNotFoundFault(crate::error::TagNotFoundFault),
    /// <p>The request cannot be processed because it would cause the resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource is 50.</p>
    TagQuotaPerResourceExceeded(crate::error::TagQuotaPerResourceExceeded),
    /// <p>The <code>TestFailover</code> action is not available.</p>
    TestFailoverNotAvailableFault(crate::error::TestFailoverNotAvailableFault),
    /// <p>A user with this ID already exists.</p>
    UserAlreadyExistsFault(crate::error::UserAlreadyExistsFault),
    /// <p>The user group with this ID already exists.</p>
    UserGroupAlreadyExistsFault(crate::error::UserGroupAlreadyExistsFault),
    /// <p>The user group was not found or does not exist</p>
    UserGroupNotFoundFault(crate::error::UserGroupNotFoundFault),
    /// <p>The number of users exceeds the user group limit.</p>
    UserGroupQuotaExceededFault(crate::error::UserGroupQuotaExceededFault),
    /// <p>The user does not exist or could not be found.</p>
    UserNotFoundFault(crate::error::UserNotFoundFault),
    /// <p>The quota of users has been exceeded.</p>
    UserQuotaExceededFault(crate::error::UserQuotaExceededFault),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::ApiCallRateForCustomerExceededFault(inner) => inner.fmt(f),
            Error::AuthorizationAlreadyExistsFault(inner) => inner.fmt(f),
            Error::AuthorizationNotFoundFault(inner) => inner.fmt(f),
            Error::CacheClusterAlreadyExistsFault(inner) => inner.fmt(f),
            Error::CacheClusterNotFoundFault(inner) => inner.fmt(f),
            Error::CacheParameterGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::CacheParameterGroupNotFoundFault(inner) => inner.fmt(f),
            Error::CacheParameterGroupQuotaExceededFault(inner) => inner.fmt(f),
            Error::CacheSecurityGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::CacheSecurityGroupNotFoundFault(inner) => inner.fmt(f),
            Error::CacheSecurityGroupQuotaExceededFault(inner) => inner.fmt(f),
            Error::CacheSubnetGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::CacheSubnetGroupInUse(inner) => inner.fmt(f),
            Error::CacheSubnetGroupNotFoundFault(inner) => inner.fmt(f),
            Error::CacheSubnetGroupQuotaExceededFault(inner) => inner.fmt(f),
            Error::CacheSubnetQuotaExceededFault(inner) => inner.fmt(f),
            Error::ClusterQuotaForCustomerExceededFault(inner) => inner.fmt(f),
            Error::DefaultUserAssociatedToUserGroupFault(inner) => inner.fmt(f),
            Error::DefaultUserRequired(inner) => inner.fmt(f),
            Error::DuplicateUserNameFault(inner) => inner.fmt(f),
            Error::GlobalReplicationGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::GlobalReplicationGroupNotFoundFault(inner) => inner.fmt(f),
            Error::InsufficientCacheClusterCapacityFault(inner) => inner.fmt(f),
            Error::InvalidArnFault(inner) => inner.fmt(f),
            Error::InvalidCacheClusterStateFault(inner) => inner.fmt(f),
            Error::InvalidCacheParameterGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidCacheSecurityGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidGlobalReplicationGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidKmsKeyFault(inner) => inner.fmt(f),
            Error::InvalidParameterCombinationException(inner) => inner.fmt(f),
            Error::InvalidParameterValueException(inner) => inner.fmt(f),
            Error::InvalidReplicationGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidSnapshotStateFault(inner) => inner.fmt(f),
            Error::InvalidSubnet(inner) => inner.fmt(f),
            Error::InvalidUserGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidUserStateFault(inner) => inner.fmt(f),
            Error::InvalidVpcNetworkStateFault(inner) => inner.fmt(f),
            Error::NoOperationFault(inner) => inner.fmt(f),
            Error::NodeGroupNotFoundFault(inner) => inner.fmt(f),
            Error::NodeGroupsPerReplicationGroupQuotaExceededFault(inner) => inner.fmt(f),
            Error::NodeQuotaForClusterExceededFault(inner) => inner.fmt(f),
            Error::NodeQuotaForCustomerExceededFault(inner) => inner.fmt(f),
            Error::ReplicationGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::ReplicationGroupAlreadyUnderMigrationFault(inner) => inner.fmt(f),
            Error::ReplicationGroupNotFoundFault(inner) => inner.fmt(f),
            Error::ReplicationGroupNotUnderMigrationFault(inner) => inner.fmt(f),
            Error::ReservedCacheNodeAlreadyExistsFault(inner) => inner.fmt(f),
            Error::ReservedCacheNodeNotFoundFault(inner) => inner.fmt(f),
            Error::ReservedCacheNodeQuotaExceededFault(inner) => inner.fmt(f),
            Error::ReservedCacheNodesOfferingNotFoundFault(inner) => inner.fmt(f),
            Error::ServiceLinkedRoleNotFoundFault(inner) => inner.fmt(f),
            Error::ServiceUpdateNotFoundFault(inner) => inner.fmt(f),
            Error::SnapshotAlreadyExistsFault(inner) => inner.fmt(f),
            Error::SnapshotFeatureNotSupportedFault(inner) => inner.fmt(f),
            Error::SnapshotNotFoundFault(inner) => inner.fmt(f),
            Error::SnapshotQuotaExceededFault(inner) => inner.fmt(f),
            Error::SubnetInUse(inner) => inner.fmt(f),
            Error::SubnetNotAllowedFault(inner) => inner.fmt(f),
            Error::TagNotFoundFault(inner) => inner.fmt(f),
            Error::TagQuotaPerResourceExceeded(inner) => inner.fmt(f),
            Error::TestFailoverNotAvailableFault(inner) => inner.fmt(f),
            Error::UserAlreadyExistsFault(inner) => inner.fmt(f),
            Error::UserGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::UserGroupNotFoundFault(inner) => inner.fmt(f),
            Error::UserGroupQuotaExceededFault(inner) => inner.fmt(f),
            Error::UserNotFoundFault(inner) => inner.fmt(f),
            Error::UserQuotaExceededFault(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddTagsToResourceErrorKind::CacheClusterNotFoundFault(inner) => {
                    Error::CacheClusterNotFoundFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::CacheParameterGroupNotFoundFault(
                    inner,
                ) => Error::CacheParameterGroupNotFoundFault(inner),
                crate::error::AddTagsToResourceErrorKind::CacheSecurityGroupNotFoundFault(
                    inner,
                ) => Error::CacheSecurityGroupNotFoundFault(inner),
                crate::error::AddTagsToResourceErrorKind::CacheSubnetGroupNotFoundFault(inner) => {
                    Error::CacheSubnetGroupNotFoundFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::InvalidArnFault(inner) => {
                    Error::InvalidArnFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::InvalidReplicationGroupStateFault(
                    inner,
                ) => Error::InvalidReplicationGroupStateFault(inner),
                crate::error::AddTagsToResourceErrorKind::ReplicationGroupNotFoundFault(inner) => {
                    Error::ReplicationGroupNotFoundFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::ReservedCacheNodeNotFoundFault(inner) => {
                    Error::ReservedCacheNodeNotFoundFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::SnapshotNotFoundFault(inner) => {
                    Error::SnapshotNotFoundFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::TagQuotaPerResourceExceeded(inner) => {
                    Error::TagQuotaPerResourceExceeded(inner)
                }
                crate::error::AddTagsToResourceErrorKind::UserGroupNotFoundFault(inner) => {
                    Error::UserGroupNotFoundFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::UserNotFoundFault(inner) => {
                    Error::UserNotFoundFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::AuthorizeCacheSecurityGroupIngressError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AuthorizeCacheSecurityGroupIngressError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AuthorizeCacheSecurityGroupIngressErrorKind::AuthorizationAlreadyExistsFault(inner) => Error::AuthorizationAlreadyExistsFault(inner),
                crate::error::AuthorizeCacheSecurityGroupIngressErrorKind::CacheSecurityGroupNotFoundFault(inner) => Error::CacheSecurityGroupNotFoundFault(inner),
                crate::error::AuthorizeCacheSecurityGroupIngressErrorKind::InvalidCacheSecurityGroupStateFault(inner) => Error::InvalidCacheSecurityGroupStateFault(inner),
                crate::error::AuthorizeCacheSecurityGroupIngressErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::AuthorizeCacheSecurityGroupIngressErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::AuthorizeCacheSecurityGroupIngressErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchApplyUpdateActionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchApplyUpdateActionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchApplyUpdateActionErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::BatchApplyUpdateActionErrorKind::ServiceUpdateNotFoundFault(
                    inner,
                ) => Error::ServiceUpdateNotFoundFault(inner),
                crate::error::BatchApplyUpdateActionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchStopUpdateActionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchStopUpdateActionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BatchStopUpdateActionErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::BatchStopUpdateActionErrorKind::ServiceUpdateNotFoundFault(inner) => {
                    Error::ServiceUpdateNotFoundFault(inner)
                }
                crate::error::BatchStopUpdateActionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CompleteMigrationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CompleteMigrationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CompleteMigrationErrorKind::InvalidReplicationGroupStateFault(inner) => Error::InvalidReplicationGroupStateFault(inner),
                crate::error::CompleteMigrationErrorKind::ReplicationGroupNotFoundFault(inner) => Error::ReplicationGroupNotFoundFault(inner),
                crate::error::CompleteMigrationErrorKind::ReplicationGroupNotUnderMigrationFault(inner) => Error::ReplicationGroupNotUnderMigrationFault(inner),
                crate::error::CompleteMigrationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CopySnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CopySnapshotError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CopySnapshotErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::CopySnapshotErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CopySnapshotErrorKind::InvalidSnapshotStateFault(inner) => {
                    Error::InvalidSnapshotStateFault(inner)
                }
                crate::error::CopySnapshotErrorKind::SnapshotAlreadyExistsFault(inner) => {
                    Error::SnapshotAlreadyExistsFault(inner)
                }
                crate::error::CopySnapshotErrorKind::SnapshotNotFoundFault(inner) => {
                    Error::SnapshotNotFoundFault(inner)
                }
                crate::error::CopySnapshotErrorKind::SnapshotQuotaExceededFault(inner) => {
                    Error::SnapshotQuotaExceededFault(inner)
                }
                crate::error::CopySnapshotErrorKind::TagQuotaPerResourceExceeded(inner) => {
                    Error::TagQuotaPerResourceExceeded(inner)
                }
                crate::error::CopySnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCacheClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateCacheClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateCacheClusterErrorKind::CacheClusterAlreadyExistsFault(inner) => Error::CacheClusterAlreadyExistsFault(inner),
                crate::error::CreateCacheClusterErrorKind::CacheParameterGroupNotFoundFault(inner) => Error::CacheParameterGroupNotFoundFault(inner),
                crate::error::CreateCacheClusterErrorKind::CacheSecurityGroupNotFoundFault(inner) => Error::CacheSecurityGroupNotFoundFault(inner),
                crate::error::CreateCacheClusterErrorKind::CacheSubnetGroupNotFoundFault(inner) => Error::CacheSubnetGroupNotFoundFault(inner),
                crate::error::CreateCacheClusterErrorKind::ClusterQuotaForCustomerExceededFault(inner) => Error::ClusterQuotaForCustomerExceededFault(inner),
                crate::error::CreateCacheClusterErrorKind::InsufficientCacheClusterCapacityFault(inner) => Error::InsufficientCacheClusterCapacityFault(inner),
                crate::error::CreateCacheClusterErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::CreateCacheClusterErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::CreateCacheClusterErrorKind::InvalidReplicationGroupStateFault(inner) => Error::InvalidReplicationGroupStateFault(inner),
                crate::error::CreateCacheClusterErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::CreateCacheClusterErrorKind::NodeQuotaForClusterExceededFault(inner) => Error::NodeQuotaForClusterExceededFault(inner),
                crate::error::CreateCacheClusterErrorKind::NodeQuotaForCustomerExceededFault(inner) => Error::NodeQuotaForCustomerExceededFault(inner),
                crate::error::CreateCacheClusterErrorKind::ReplicationGroupNotFoundFault(inner) => Error::ReplicationGroupNotFoundFault(inner),
                crate::error::CreateCacheClusterErrorKind::TagQuotaPerResourceExceeded(inner) => Error::TagQuotaPerResourceExceeded(inner),
                crate::error::CreateCacheClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCacheParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateCacheParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateCacheParameterGroupErrorKind::CacheParameterGroupAlreadyExistsFault(inner) => Error::CacheParameterGroupAlreadyExistsFault(inner),
                crate::error::CreateCacheParameterGroupErrorKind::CacheParameterGroupQuotaExceededFault(inner) => Error::CacheParameterGroupQuotaExceededFault(inner),
                crate::error::CreateCacheParameterGroupErrorKind::InvalidCacheParameterGroupStateFault(inner) => Error::InvalidCacheParameterGroupStateFault(inner),
                crate::error::CreateCacheParameterGroupErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::CreateCacheParameterGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::CreateCacheParameterGroupErrorKind::TagQuotaPerResourceExceeded(inner) => Error::TagQuotaPerResourceExceeded(inner),
                crate::error::CreateCacheParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCacheSecurityGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateCacheSecurityGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateCacheSecurityGroupErrorKind::CacheSecurityGroupAlreadyExistsFault(inner) => Error::CacheSecurityGroupAlreadyExistsFault(inner),
                crate::error::CreateCacheSecurityGroupErrorKind::CacheSecurityGroupQuotaExceededFault(inner) => Error::CacheSecurityGroupQuotaExceededFault(inner),
                crate::error::CreateCacheSecurityGroupErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::CreateCacheSecurityGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::CreateCacheSecurityGroupErrorKind::TagQuotaPerResourceExceeded(inner) => Error::TagQuotaPerResourceExceeded(inner),
                crate::error::CreateCacheSecurityGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCacheSubnetGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateCacheSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateCacheSubnetGroupErrorKind::CacheSubnetGroupAlreadyExistsFault(inner) => Error::CacheSubnetGroupAlreadyExistsFault(inner),
                crate::error::CreateCacheSubnetGroupErrorKind::CacheSubnetGroupQuotaExceededFault(inner) => Error::CacheSubnetGroupQuotaExceededFault(inner),
                crate::error::CreateCacheSubnetGroupErrorKind::CacheSubnetQuotaExceededFault(inner) => Error::CacheSubnetQuotaExceededFault(inner),
                crate::error::CreateCacheSubnetGroupErrorKind::InvalidSubnet(inner) => Error::InvalidSubnet(inner),
                crate::error::CreateCacheSubnetGroupErrorKind::SubnetNotAllowedFault(inner) => Error::SubnetNotAllowedFault(inner),
                crate::error::CreateCacheSubnetGroupErrorKind::TagQuotaPerResourceExceeded(inner) => Error::TagQuotaPerResourceExceeded(inner),
                crate::error::CreateCacheSubnetGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateGlobalReplicationGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateGlobalReplicationGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateGlobalReplicationGroupErrorKind::GlobalReplicationGroupAlreadyExistsFault(inner) => Error::GlobalReplicationGroupAlreadyExistsFault(inner),
                crate::error::CreateGlobalReplicationGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::CreateGlobalReplicationGroupErrorKind::InvalidReplicationGroupStateFault(inner) => Error::InvalidReplicationGroupStateFault(inner),
                crate::error::CreateGlobalReplicationGroupErrorKind::ReplicationGroupNotFoundFault(inner) => Error::ReplicationGroupNotFoundFault(inner),
                crate::error::CreateGlobalReplicationGroupErrorKind::ServiceLinkedRoleNotFoundFault(inner) => Error::ServiceLinkedRoleNotFoundFault(inner),
                crate::error::CreateGlobalReplicationGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateReplicationGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateReplicationGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateReplicationGroupErrorKind::CacheClusterNotFoundFault(inner) => Error::CacheClusterNotFoundFault(inner),
                crate::error::CreateReplicationGroupErrorKind::CacheParameterGroupNotFoundFault(inner) => Error::CacheParameterGroupNotFoundFault(inner),
                crate::error::CreateReplicationGroupErrorKind::CacheSecurityGroupNotFoundFault(inner) => Error::CacheSecurityGroupNotFoundFault(inner),
                crate::error::CreateReplicationGroupErrorKind::CacheSubnetGroupNotFoundFault(inner) => Error::CacheSubnetGroupNotFoundFault(inner),
                crate::error::CreateReplicationGroupErrorKind::ClusterQuotaForCustomerExceededFault(inner) => Error::ClusterQuotaForCustomerExceededFault(inner),
                crate::error::CreateReplicationGroupErrorKind::GlobalReplicationGroupNotFoundFault(inner) => Error::GlobalReplicationGroupNotFoundFault(inner),
                crate::error::CreateReplicationGroupErrorKind::InsufficientCacheClusterCapacityFault(inner) => Error::InsufficientCacheClusterCapacityFault(inner),
                crate::error::CreateReplicationGroupErrorKind::InvalidCacheClusterStateFault(inner) => Error::InvalidCacheClusterStateFault(inner),
                crate::error::CreateReplicationGroupErrorKind::InvalidGlobalReplicationGroupStateFault(inner) => Error::InvalidGlobalReplicationGroupStateFault(inner),
                crate::error::CreateReplicationGroupErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::CreateReplicationGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::CreateReplicationGroupErrorKind::InvalidUserGroupStateFault(inner) => Error::InvalidUserGroupStateFault(inner),
                crate::error::CreateReplicationGroupErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::CreateReplicationGroupErrorKind::NodeGroupsPerReplicationGroupQuotaExceededFault(inner) => Error::NodeGroupsPerReplicationGroupQuotaExceededFault(inner),
                crate::error::CreateReplicationGroupErrorKind::NodeQuotaForClusterExceededFault(inner) => Error::NodeQuotaForClusterExceededFault(inner),
                crate::error::CreateReplicationGroupErrorKind::NodeQuotaForCustomerExceededFault(inner) => Error::NodeQuotaForCustomerExceededFault(inner),
                crate::error::CreateReplicationGroupErrorKind::ReplicationGroupAlreadyExistsFault(inner) => Error::ReplicationGroupAlreadyExistsFault(inner),
                crate::error::CreateReplicationGroupErrorKind::TagQuotaPerResourceExceeded(inner) => Error::TagQuotaPerResourceExceeded(inner),
                crate::error::CreateReplicationGroupErrorKind::UserGroupNotFoundFault(inner) => Error::UserGroupNotFoundFault(inner),
                crate::error::CreateReplicationGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateSnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateSnapshotError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateSnapshotErrorKind::CacheClusterNotFoundFault(inner) => {
                    Error::CacheClusterNotFoundFault(inner)
                }
                crate::error::CreateSnapshotErrorKind::InvalidCacheClusterStateFault(inner) => {
                    Error::InvalidCacheClusterStateFault(inner)
                }
                crate::error::CreateSnapshotErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::CreateSnapshotErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateSnapshotErrorKind::InvalidReplicationGroupStateFault(inner) => {
                    Error::InvalidReplicationGroupStateFault(inner)
                }
                crate::error::CreateSnapshotErrorKind::ReplicationGroupNotFoundFault(inner) => {
                    Error::ReplicationGroupNotFoundFault(inner)
                }
                crate::error::CreateSnapshotErrorKind::SnapshotAlreadyExistsFault(inner) => {
                    Error::SnapshotAlreadyExistsFault(inner)
                }
                crate::error::CreateSnapshotErrorKind::SnapshotFeatureNotSupportedFault(inner) => {
                    Error::SnapshotFeatureNotSupportedFault(inner)
                }
                crate::error::CreateSnapshotErrorKind::SnapshotQuotaExceededFault(inner) => {
                    Error::SnapshotQuotaExceededFault(inner)
                }
                crate::error::CreateSnapshotErrorKind::TagQuotaPerResourceExceeded(inner) => {
                    Error::TagQuotaPerResourceExceeded(inner)
                }
                crate::error::CreateSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateUserError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateUserError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateUserErrorKind::DuplicateUserNameFault(inner) => {
                    Error::DuplicateUserNameFault(inner)
                }
                crate::error::CreateUserErrorKind::InvalidParameterCombinationException(inner) => {
                    Error::InvalidParameterCombinationException(inner)
                }
                crate::error::CreateUserErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateUserErrorKind::TagQuotaPerResourceExceeded(inner) => {
                    Error::TagQuotaPerResourceExceeded(inner)
                }
                crate::error::CreateUserErrorKind::UserAlreadyExistsFault(inner) => {
                    Error::UserAlreadyExistsFault(inner)
                }
                crate::error::CreateUserErrorKind::UserQuotaExceededFault(inner) => {
                    Error::UserQuotaExceededFault(inner)
                }
                crate::error::CreateUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateUserGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateUserGroupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateUserGroupErrorKind::DefaultUserRequired(inner) => {
                    Error::DefaultUserRequired(inner)
                }
                crate::error::CreateUserGroupErrorKind::DuplicateUserNameFault(inner) => {
                    Error::DuplicateUserNameFault(inner)
                }
                crate::error::CreateUserGroupErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateUserGroupErrorKind::TagQuotaPerResourceExceeded(inner) => {
                    Error::TagQuotaPerResourceExceeded(inner)
                }
                crate::error::CreateUserGroupErrorKind::UserGroupAlreadyExistsFault(inner) => {
                    Error::UserGroupAlreadyExistsFault(inner)
                }
                crate::error::CreateUserGroupErrorKind::UserGroupQuotaExceededFault(inner) => {
                    Error::UserGroupQuotaExceededFault(inner)
                }
                crate::error::CreateUserGroupErrorKind::UserNotFoundFault(inner) => {
                    Error::UserNotFoundFault(inner)
                }
                crate::error::CreateUserGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DecreaseNodeGroupsInGlobalReplicationGroupError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DecreaseNodeGroupsInGlobalReplicationGroupErrorKind::GlobalReplicationGroupNotFoundFault(inner) => Error::GlobalReplicationGroupNotFoundFault(inner),
                crate::error::DecreaseNodeGroupsInGlobalReplicationGroupErrorKind::InvalidGlobalReplicationGroupStateFault(inner) => Error::InvalidGlobalReplicationGroupStateFault(inner),
                crate::error::DecreaseNodeGroupsInGlobalReplicationGroupErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DecreaseNodeGroupsInGlobalReplicationGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DecreaseNodeGroupsInGlobalReplicationGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DecreaseReplicaCountError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DecreaseReplicaCountError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DecreaseReplicaCountErrorKind::ClusterQuotaForCustomerExceededFault(inner) => Error::ClusterQuotaForCustomerExceededFault(inner),
                crate::error::DecreaseReplicaCountErrorKind::InsufficientCacheClusterCapacityFault(inner) => Error::InsufficientCacheClusterCapacityFault(inner),
                crate::error::DecreaseReplicaCountErrorKind::InvalidCacheClusterStateFault(inner) => Error::InvalidCacheClusterStateFault(inner),
                crate::error::DecreaseReplicaCountErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DecreaseReplicaCountErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DecreaseReplicaCountErrorKind::InvalidReplicationGroupStateFault(inner) => Error::InvalidReplicationGroupStateFault(inner),
                crate::error::DecreaseReplicaCountErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::DecreaseReplicaCountErrorKind::NodeGroupsPerReplicationGroupQuotaExceededFault(inner) => Error::NodeGroupsPerReplicationGroupQuotaExceededFault(inner),
                crate::error::DecreaseReplicaCountErrorKind::NodeQuotaForCustomerExceededFault(inner) => Error::NodeQuotaForCustomerExceededFault(inner),
                crate::error::DecreaseReplicaCountErrorKind::NoOperationFault(inner) => Error::NoOperationFault(inner),
                crate::error::DecreaseReplicaCountErrorKind::ReplicationGroupNotFoundFault(inner) => Error::ReplicationGroupNotFoundFault(inner),
                crate::error::DecreaseReplicaCountErrorKind::ServiceLinkedRoleNotFoundFault(inner) => Error::ServiceLinkedRoleNotFoundFault(inner),
                crate::error::DecreaseReplicaCountErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCacheClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteCacheClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteCacheClusterErrorKind::CacheClusterNotFoundFault(inner) => {
                    Error::CacheClusterNotFoundFault(inner)
                }
                crate::error::DeleteCacheClusterErrorKind::InvalidCacheClusterStateFault(inner) => {
                    Error::InvalidCacheClusterStateFault(inner)
                }
                crate::error::DeleteCacheClusterErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::DeleteCacheClusterErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::DeleteCacheClusterErrorKind::SnapshotAlreadyExistsFault(inner) => {
                    Error::SnapshotAlreadyExistsFault(inner)
                }
                crate::error::DeleteCacheClusterErrorKind::SnapshotFeatureNotSupportedFault(
                    inner,
                ) => Error::SnapshotFeatureNotSupportedFault(inner),
                crate::error::DeleteCacheClusterErrorKind::SnapshotQuotaExceededFault(inner) => {
                    Error::SnapshotQuotaExceededFault(inner)
                }
                crate::error::DeleteCacheClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCacheParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteCacheParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteCacheParameterGroupErrorKind::CacheParameterGroupNotFoundFault(inner) => Error::CacheParameterGroupNotFoundFault(inner),
                crate::error::DeleteCacheParameterGroupErrorKind::InvalidCacheParameterGroupStateFault(inner) => Error::InvalidCacheParameterGroupStateFault(inner),
                crate::error::DeleteCacheParameterGroupErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DeleteCacheParameterGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DeleteCacheParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCacheSecurityGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteCacheSecurityGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteCacheSecurityGroupErrorKind::CacheSecurityGroupNotFoundFault(inner) => Error::CacheSecurityGroupNotFoundFault(inner),
                crate::error::DeleteCacheSecurityGroupErrorKind::InvalidCacheSecurityGroupStateFault(inner) => Error::InvalidCacheSecurityGroupStateFault(inner),
                crate::error::DeleteCacheSecurityGroupErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DeleteCacheSecurityGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DeleteCacheSecurityGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCacheSubnetGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteCacheSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteCacheSubnetGroupErrorKind::CacheSubnetGroupInUse(inner) => {
                    Error::CacheSubnetGroupInUse(inner)
                }
                crate::error::DeleteCacheSubnetGroupErrorKind::CacheSubnetGroupNotFoundFault(
                    inner,
                ) => Error::CacheSubnetGroupNotFoundFault(inner),
                crate::error::DeleteCacheSubnetGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteGlobalReplicationGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteGlobalReplicationGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteGlobalReplicationGroupErrorKind::GlobalReplicationGroupNotFoundFault(inner) => Error::GlobalReplicationGroupNotFoundFault(inner),
                crate::error::DeleteGlobalReplicationGroupErrorKind::InvalidGlobalReplicationGroupStateFault(inner) => Error::InvalidGlobalReplicationGroupStateFault(inner),
                crate::error::DeleteGlobalReplicationGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DeleteGlobalReplicationGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteReplicationGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteReplicationGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteReplicationGroupErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DeleteReplicationGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DeleteReplicationGroupErrorKind::InvalidReplicationGroupStateFault(inner) => Error::InvalidReplicationGroupStateFault(inner),
                crate::error::DeleteReplicationGroupErrorKind::ReplicationGroupNotFoundFault(inner) => Error::ReplicationGroupNotFoundFault(inner),
                crate::error::DeleteReplicationGroupErrorKind::SnapshotAlreadyExistsFault(inner) => Error::SnapshotAlreadyExistsFault(inner),
                crate::error::DeleteReplicationGroupErrorKind::SnapshotFeatureNotSupportedFault(inner) => Error::SnapshotFeatureNotSupportedFault(inner),
                crate::error::DeleteReplicationGroupErrorKind::SnapshotQuotaExceededFault(inner) => Error::SnapshotQuotaExceededFault(inner),
                crate::error::DeleteReplicationGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteSnapshotErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::DeleteSnapshotErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DeleteSnapshotErrorKind::InvalidSnapshotStateFault(inner) => {
                    Error::InvalidSnapshotStateFault(inner)
                }
                crate::error::DeleteSnapshotErrorKind::SnapshotNotFoundFault(inner) => {
                    Error::SnapshotNotFoundFault(inner)
                }
                crate::error::DeleteSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteUserError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteUserError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteUserErrorKind::DefaultUserAssociatedToUserGroupFault(inner) => {
                    Error::DefaultUserAssociatedToUserGroupFault(inner)
                }
                crate::error::DeleteUserErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DeleteUserErrorKind::InvalidUserStateFault(inner) => {
                    Error::InvalidUserStateFault(inner)
                }
                crate::error::DeleteUserErrorKind::UserNotFoundFault(inner) => {
                    Error::UserNotFoundFault(inner)
                }
                crate::error::DeleteUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteUserGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteUserGroupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteUserGroupErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DeleteUserGroupErrorKind::InvalidUserGroupStateFault(inner) => {
                    Error::InvalidUserGroupStateFault(inner)
                }
                crate::error::DeleteUserGroupErrorKind::UserGroupNotFoundFault(inner) => {
                    Error::UserGroupNotFoundFault(inner)
                }
                crate::error::DeleteUserGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCacheClustersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeCacheClustersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeCacheClustersErrorKind::CacheClusterNotFoundFault(inner) => Error::CacheClusterNotFoundFault(inner),
                crate::error::DescribeCacheClustersErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeCacheClustersErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeCacheClustersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCacheEngineVersionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeCacheEngineVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeCacheEngineVersionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCacheParameterGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeCacheParameterGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeCacheParameterGroupsErrorKind::CacheParameterGroupNotFoundFault(inner) => Error::CacheParameterGroupNotFoundFault(inner),
                crate::error::DescribeCacheParameterGroupsErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeCacheParameterGroupsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeCacheParameterGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCacheParametersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeCacheParametersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeCacheParametersErrorKind::CacheParameterGroupNotFoundFault(inner) => Error::CacheParameterGroupNotFoundFault(inner),
                crate::error::DescribeCacheParametersErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeCacheParametersErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeCacheParametersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCacheSecurityGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeCacheSecurityGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeCacheSecurityGroupsErrorKind::CacheSecurityGroupNotFoundFault(inner) => Error::CacheSecurityGroupNotFoundFault(inner),
                crate::error::DescribeCacheSecurityGroupsErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeCacheSecurityGroupsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeCacheSecurityGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCacheSubnetGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeCacheSubnetGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeCacheSubnetGroupsErrorKind::CacheSubnetGroupNotFoundFault(
                    inner,
                ) => Error::CacheSubnetGroupNotFoundFault(inner),
                crate::error::DescribeCacheSubnetGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeEngineDefaultParametersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeEngineDefaultParametersError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeEngineDefaultParametersErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeEngineDefaultParametersErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeEngineDefaultParametersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeEventsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventsErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeEventsErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DescribeEventsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeGlobalReplicationGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeGlobalReplicationGroupsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeGlobalReplicationGroupsErrorKind::GlobalReplicationGroupNotFoundFault(inner) => Error::GlobalReplicationGroupNotFoundFault(inner),
                crate::error::DescribeGlobalReplicationGroupsErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeGlobalReplicationGroupsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeGlobalReplicationGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeReplicationGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeReplicationGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeReplicationGroupsErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeReplicationGroupsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeReplicationGroupsErrorKind::ReplicationGroupNotFoundFault(inner) => Error::ReplicationGroupNotFoundFault(inner),
                crate::error::DescribeReplicationGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeReservedCacheNodesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeReservedCacheNodesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeReservedCacheNodesErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeReservedCacheNodesErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeReservedCacheNodesErrorKind::ReservedCacheNodeNotFoundFault(inner) => Error::ReservedCacheNodeNotFoundFault(inner),
                crate::error::DescribeReservedCacheNodesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeReservedCacheNodesOfferingsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeReservedCacheNodesOfferingsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeReservedCacheNodesOfferingsErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeReservedCacheNodesOfferingsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeReservedCacheNodesOfferingsErrorKind::ReservedCacheNodesOfferingNotFoundFault(inner) => Error::ReservedCacheNodesOfferingNotFoundFault(inner),
                crate::error::DescribeReservedCacheNodesOfferingsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeServiceUpdatesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeServiceUpdatesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeServiceUpdatesErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeServiceUpdatesErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeServiceUpdatesErrorKind::ServiceUpdateNotFoundFault(inner) => Error::ServiceUpdateNotFoundFault(inner),
                crate::error::DescribeServiceUpdatesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeSnapshotsErrorKind::CacheClusterNotFoundFault(inner) => {
                    Error::CacheClusterNotFoundFault(inner)
                }
                crate::error::DescribeSnapshotsErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeSnapshotsErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DescribeSnapshotsErrorKind::SnapshotNotFoundFault(inner) => {
                    Error::SnapshotNotFoundFault(inner)
                }
                crate::error::DescribeSnapshotsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeUpdateActionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeUpdateActionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeUpdateActionsErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeUpdateActionsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DescribeUpdateActionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeUserGroupsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeUserGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeUserGroupsErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeUserGroupsErrorKind::UserGroupNotFoundFault(inner) => {
                    Error::UserGroupNotFoundFault(inner)
                }
                crate::error::DescribeUserGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeUsersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeUsersError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeUsersErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::DescribeUsersErrorKind::UserNotFoundFault(inner) => {
                    Error::UserNotFoundFault(inner)
                }
                crate::error::DescribeUsersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::DisassociateGlobalReplicationGroupError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DisassociateGlobalReplicationGroupError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DisassociateGlobalReplicationGroupErrorKind::GlobalReplicationGroupNotFoundFault(inner) => Error::GlobalReplicationGroupNotFoundFault(inner),
                crate::error::DisassociateGlobalReplicationGroupErrorKind::InvalidGlobalReplicationGroupStateFault(inner) => Error::InvalidGlobalReplicationGroupStateFault(inner),
                crate::error::DisassociateGlobalReplicationGroupErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::DisassociateGlobalReplicationGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DisassociateGlobalReplicationGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::FailoverGlobalReplicationGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::FailoverGlobalReplicationGroupError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::FailoverGlobalReplicationGroupErrorKind::GlobalReplicationGroupNotFoundFault(inner) => Error::GlobalReplicationGroupNotFoundFault(inner),
                crate::error::FailoverGlobalReplicationGroupErrorKind::InvalidGlobalReplicationGroupStateFault(inner) => Error::InvalidGlobalReplicationGroupStateFault(inner),
                crate::error::FailoverGlobalReplicationGroupErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::FailoverGlobalReplicationGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::FailoverGlobalReplicationGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::IncreaseNodeGroupsInGlobalReplicationGroupError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::IncreaseNodeGroupsInGlobalReplicationGroupError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::IncreaseNodeGroupsInGlobalReplicationGroupErrorKind::GlobalReplicationGroupNotFoundFault(inner) => Error::GlobalReplicationGroupNotFoundFault(inner),
                crate::error::IncreaseNodeGroupsInGlobalReplicationGroupErrorKind::InvalidGlobalReplicationGroupStateFault(inner) => Error::InvalidGlobalReplicationGroupStateFault(inner),
                crate::error::IncreaseNodeGroupsInGlobalReplicationGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::IncreaseNodeGroupsInGlobalReplicationGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::IncreaseReplicaCountError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::IncreaseReplicaCountError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::IncreaseReplicaCountErrorKind::ClusterQuotaForCustomerExceededFault(inner) => Error::ClusterQuotaForCustomerExceededFault(inner),
                crate::error::IncreaseReplicaCountErrorKind::InsufficientCacheClusterCapacityFault(inner) => Error::InsufficientCacheClusterCapacityFault(inner),
                crate::error::IncreaseReplicaCountErrorKind::InvalidCacheClusterStateFault(inner) => Error::InvalidCacheClusterStateFault(inner),
                crate::error::IncreaseReplicaCountErrorKind::InvalidKmsKeyFault(inner) => Error::InvalidKmsKeyFault(inner),
                crate::error::IncreaseReplicaCountErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::IncreaseReplicaCountErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::IncreaseReplicaCountErrorKind::InvalidReplicationGroupStateFault(inner) => Error::InvalidReplicationGroupStateFault(inner),
                crate::error::IncreaseReplicaCountErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::IncreaseReplicaCountErrorKind::NodeGroupsPerReplicationGroupQuotaExceededFault(inner) => Error::NodeGroupsPerReplicationGroupQuotaExceededFault(inner),
                crate::error::IncreaseReplicaCountErrorKind::NodeQuotaForCustomerExceededFault(inner) => Error::NodeQuotaForCustomerExceededFault(inner),
                crate::error::IncreaseReplicaCountErrorKind::NoOperationFault(inner) => Error::NoOperationFault(inner),
                crate::error::IncreaseReplicaCountErrorKind::ReplicationGroupNotFoundFault(inner) => Error::ReplicationGroupNotFoundFault(inner),
                crate::error::IncreaseReplicaCountErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListAllowedNodeTypeModificationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListAllowedNodeTypeModificationsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListAllowedNodeTypeModificationsErrorKind::CacheClusterNotFoundFault(inner) => Error::CacheClusterNotFoundFault(inner),
                crate::error::ListAllowedNodeTypeModificationsErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::ListAllowedNodeTypeModificationsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::ListAllowedNodeTypeModificationsErrorKind::ReplicationGroupNotFoundFault(inner) => Error::ReplicationGroupNotFoundFault(inner),
                crate::error::ListAllowedNodeTypeModificationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::CacheClusterNotFoundFault(inner) => {
                    Error::CacheClusterNotFoundFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::CacheParameterGroupNotFoundFault(
                    inner,
                ) => Error::CacheParameterGroupNotFoundFault(inner),
                crate::error::ListTagsForResourceErrorKind::CacheSecurityGroupNotFoundFault(
                    inner,
                ) => Error::CacheSecurityGroupNotFoundFault(inner),
                crate::error::ListTagsForResourceErrorKind::CacheSubnetGroupNotFoundFault(
                    inner,
                ) => Error::CacheSubnetGroupNotFoundFault(inner),
                crate::error::ListTagsForResourceErrorKind::InvalidArnFault(inner) => {
                    Error::InvalidArnFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidReplicationGroupStateFault(
                    inner,
                ) => Error::InvalidReplicationGroupStateFault(inner),
                crate::error::ListTagsForResourceErrorKind::ReplicationGroupNotFoundFault(
                    inner,
                ) => Error::ReplicationGroupNotFoundFault(inner),
                crate::error::ListTagsForResourceErrorKind::ReservedCacheNodeNotFoundFault(
                    inner,
                ) => Error::ReservedCacheNodeNotFoundFault(inner),
                crate::error::ListTagsForResourceErrorKind::SnapshotNotFoundFault(inner) => {
                    Error::SnapshotNotFoundFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::UserGroupNotFoundFault(inner) => {
                    Error::UserGroupNotFoundFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::UserNotFoundFault(inner) => {
                    Error::UserNotFoundFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyCacheClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyCacheClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyCacheClusterErrorKind::CacheClusterNotFoundFault(inner) => Error::CacheClusterNotFoundFault(inner),
                crate::error::ModifyCacheClusterErrorKind::CacheParameterGroupNotFoundFault(inner) => Error::CacheParameterGroupNotFoundFault(inner),
                crate::error::ModifyCacheClusterErrorKind::CacheSecurityGroupNotFoundFault(inner) => Error::CacheSecurityGroupNotFoundFault(inner),
                crate::error::ModifyCacheClusterErrorKind::InsufficientCacheClusterCapacityFault(inner) => Error::InsufficientCacheClusterCapacityFault(inner),
                crate::error::ModifyCacheClusterErrorKind::InvalidCacheClusterStateFault(inner) => Error::InvalidCacheClusterStateFault(inner),
                crate::error::ModifyCacheClusterErrorKind::InvalidCacheSecurityGroupStateFault(inner) => Error::InvalidCacheSecurityGroupStateFault(inner),
                crate::error::ModifyCacheClusterErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::ModifyCacheClusterErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::ModifyCacheClusterErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::ModifyCacheClusterErrorKind::NodeQuotaForClusterExceededFault(inner) => Error::NodeQuotaForClusterExceededFault(inner),
                crate::error::ModifyCacheClusterErrorKind::NodeQuotaForCustomerExceededFault(inner) => Error::NodeQuotaForCustomerExceededFault(inner),
                crate::error::ModifyCacheClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyCacheParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyCacheParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyCacheParameterGroupErrorKind::CacheParameterGroupNotFoundFault(inner) => Error::CacheParameterGroupNotFoundFault(inner),
                crate::error::ModifyCacheParameterGroupErrorKind::InvalidCacheParameterGroupStateFault(inner) => Error::InvalidCacheParameterGroupStateFault(inner),
                crate::error::ModifyCacheParameterGroupErrorKind::InvalidGlobalReplicationGroupStateFault(inner) => Error::InvalidGlobalReplicationGroupStateFault(inner),
                crate::error::ModifyCacheParameterGroupErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::ModifyCacheParameterGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::ModifyCacheParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyCacheSubnetGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyCacheSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyCacheSubnetGroupErrorKind::CacheSubnetGroupNotFoundFault(
                    inner,
                ) => Error::CacheSubnetGroupNotFoundFault(inner),
                crate::error::ModifyCacheSubnetGroupErrorKind::CacheSubnetQuotaExceededFault(
                    inner,
                ) => Error::CacheSubnetQuotaExceededFault(inner),
                crate::error::ModifyCacheSubnetGroupErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::ModifyCacheSubnetGroupErrorKind::SubnetInUse(inner) => {
                    Error::SubnetInUse(inner)
                }
                crate::error::ModifyCacheSubnetGroupErrorKind::SubnetNotAllowedFault(inner) => {
                    Error::SubnetNotAllowedFault(inner)
                }
                crate::error::ModifyCacheSubnetGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyGlobalReplicationGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyGlobalReplicationGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyGlobalReplicationGroupErrorKind::GlobalReplicationGroupNotFoundFault(inner) => Error::GlobalReplicationGroupNotFoundFault(inner),
                crate::error::ModifyGlobalReplicationGroupErrorKind::InvalidGlobalReplicationGroupStateFault(inner) => Error::InvalidGlobalReplicationGroupStateFault(inner),
                crate::error::ModifyGlobalReplicationGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::ModifyGlobalReplicationGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyReplicationGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyReplicationGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyReplicationGroupErrorKind::CacheClusterNotFoundFault(inner) => Error::CacheClusterNotFoundFault(inner),
                crate::error::ModifyReplicationGroupErrorKind::CacheParameterGroupNotFoundFault(inner) => Error::CacheParameterGroupNotFoundFault(inner),
                crate::error::ModifyReplicationGroupErrorKind::CacheSecurityGroupNotFoundFault(inner) => Error::CacheSecurityGroupNotFoundFault(inner),
                crate::error::ModifyReplicationGroupErrorKind::InsufficientCacheClusterCapacityFault(inner) => Error::InsufficientCacheClusterCapacityFault(inner),
                crate::error::ModifyReplicationGroupErrorKind::InvalidCacheClusterStateFault(inner) => Error::InvalidCacheClusterStateFault(inner),
                crate::error::ModifyReplicationGroupErrorKind::InvalidCacheSecurityGroupStateFault(inner) => Error::InvalidCacheSecurityGroupStateFault(inner),
                crate::error::ModifyReplicationGroupErrorKind::InvalidKmsKeyFault(inner) => Error::InvalidKmsKeyFault(inner),
                crate::error::ModifyReplicationGroupErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::ModifyReplicationGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::ModifyReplicationGroupErrorKind::InvalidReplicationGroupStateFault(inner) => Error::InvalidReplicationGroupStateFault(inner),
                crate::error::ModifyReplicationGroupErrorKind::InvalidUserGroupStateFault(inner) => Error::InvalidUserGroupStateFault(inner),
                crate::error::ModifyReplicationGroupErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::ModifyReplicationGroupErrorKind::NodeQuotaForClusterExceededFault(inner) => Error::NodeQuotaForClusterExceededFault(inner),
                crate::error::ModifyReplicationGroupErrorKind::NodeQuotaForCustomerExceededFault(inner) => Error::NodeQuotaForCustomerExceededFault(inner),
                crate::error::ModifyReplicationGroupErrorKind::ReplicationGroupNotFoundFault(inner) => Error::ReplicationGroupNotFoundFault(inner),
                crate::error::ModifyReplicationGroupErrorKind::UserGroupNotFoundFault(inner) => Error::UserGroupNotFoundFault(inner),
                crate::error::ModifyReplicationGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::ModifyReplicationGroupShardConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ModifyReplicationGroupShardConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyReplicationGroupShardConfigurationErrorKind::InsufficientCacheClusterCapacityFault(inner) => Error::InsufficientCacheClusterCapacityFault(inner),
                crate::error::ModifyReplicationGroupShardConfigurationErrorKind::InvalidCacheClusterStateFault(inner) => Error::InvalidCacheClusterStateFault(inner),
                crate::error::ModifyReplicationGroupShardConfigurationErrorKind::InvalidKmsKeyFault(inner) => Error::InvalidKmsKeyFault(inner),
                crate::error::ModifyReplicationGroupShardConfigurationErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::ModifyReplicationGroupShardConfigurationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::ModifyReplicationGroupShardConfigurationErrorKind::InvalidReplicationGroupStateFault(inner) => Error::InvalidReplicationGroupStateFault(inner),
                crate::error::ModifyReplicationGroupShardConfigurationErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::ModifyReplicationGroupShardConfigurationErrorKind::NodeGroupsPerReplicationGroupQuotaExceededFault(inner) => Error::NodeGroupsPerReplicationGroupQuotaExceededFault(inner),
                crate::error::ModifyReplicationGroupShardConfigurationErrorKind::NodeQuotaForCustomerExceededFault(inner) => Error::NodeQuotaForCustomerExceededFault(inner),
                crate::error::ModifyReplicationGroupShardConfigurationErrorKind::ReplicationGroupNotFoundFault(inner) => Error::ReplicationGroupNotFoundFault(inner),
                crate::error::ModifyReplicationGroupShardConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyUserError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ModifyUserError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyUserErrorKind::InvalidParameterCombinationException(inner) => {
                    Error::InvalidParameterCombinationException(inner)
                }
                crate::error::ModifyUserErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::ModifyUserErrorKind::InvalidUserStateFault(inner) => {
                    Error::InvalidUserStateFault(inner)
                }
                crate::error::ModifyUserErrorKind::UserNotFoundFault(inner) => {
                    Error::UserNotFoundFault(inner)
                }
                crate::error::ModifyUserErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyUserGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ModifyUserGroupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyUserGroupErrorKind::DefaultUserRequired(inner) => {
                    Error::DefaultUserRequired(inner)
                }
                crate::error::ModifyUserGroupErrorKind::DuplicateUserNameFault(inner) => {
                    Error::DuplicateUserNameFault(inner)
                }
                crate::error::ModifyUserGroupErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::ModifyUserGroupErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::ModifyUserGroupErrorKind::InvalidUserGroupStateFault(inner) => {
                    Error::InvalidUserGroupStateFault(inner)
                }
                crate::error::ModifyUserGroupErrorKind::UserGroupNotFoundFault(inner) => {
                    Error::UserGroupNotFoundFault(inner)
                }
                crate::error::ModifyUserGroupErrorKind::UserNotFoundFault(inner) => {
                    Error::UserNotFoundFault(inner)
                }
                crate::error::ModifyUserGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::PurchaseReservedCacheNodesOfferingError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::PurchaseReservedCacheNodesOfferingError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PurchaseReservedCacheNodesOfferingErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::PurchaseReservedCacheNodesOfferingErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::PurchaseReservedCacheNodesOfferingErrorKind::ReservedCacheNodeAlreadyExistsFault(inner) => Error::ReservedCacheNodeAlreadyExistsFault(inner),
                crate::error::PurchaseReservedCacheNodesOfferingErrorKind::ReservedCacheNodeQuotaExceededFault(inner) => Error::ReservedCacheNodeQuotaExceededFault(inner),
                crate::error::PurchaseReservedCacheNodesOfferingErrorKind::ReservedCacheNodesOfferingNotFoundFault(inner) => Error::ReservedCacheNodesOfferingNotFoundFault(inner),
                crate::error::PurchaseReservedCacheNodesOfferingErrorKind::TagQuotaPerResourceExceeded(inner) => Error::TagQuotaPerResourceExceeded(inner),
                crate::error::PurchaseReservedCacheNodesOfferingErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::RebalanceSlotsInGlobalReplicationGroupError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::RebalanceSlotsInGlobalReplicationGroupError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RebalanceSlotsInGlobalReplicationGroupErrorKind::GlobalReplicationGroupNotFoundFault(inner) => Error::GlobalReplicationGroupNotFoundFault(inner),
                crate::error::RebalanceSlotsInGlobalReplicationGroupErrorKind::InvalidGlobalReplicationGroupStateFault(inner) => Error::InvalidGlobalReplicationGroupStateFault(inner),
                crate::error::RebalanceSlotsInGlobalReplicationGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::RebalanceSlotsInGlobalReplicationGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RebootCacheClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RebootCacheClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RebootCacheClusterErrorKind::CacheClusterNotFoundFault(inner) => {
                    Error::CacheClusterNotFoundFault(inner)
                }
                crate::error::RebootCacheClusterErrorKind::InvalidCacheClusterStateFault(inner) => {
                    Error::InvalidCacheClusterStateFault(inner)
                }
                crate::error::RebootCacheClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RemoveTagsFromResourceErrorKind::CacheClusterNotFoundFault(inner) => Error::CacheClusterNotFoundFault(inner),
                crate::error::RemoveTagsFromResourceErrorKind::CacheParameterGroupNotFoundFault(inner) => Error::CacheParameterGroupNotFoundFault(inner),
                crate::error::RemoveTagsFromResourceErrorKind::CacheSecurityGroupNotFoundFault(inner) => Error::CacheSecurityGroupNotFoundFault(inner),
                crate::error::RemoveTagsFromResourceErrorKind::CacheSubnetGroupNotFoundFault(inner) => Error::CacheSubnetGroupNotFoundFault(inner),
                crate::error::RemoveTagsFromResourceErrorKind::InvalidArnFault(inner) => Error::InvalidArnFault(inner),
                crate::error::RemoveTagsFromResourceErrorKind::InvalidReplicationGroupStateFault(inner) => Error::InvalidReplicationGroupStateFault(inner),
                crate::error::RemoveTagsFromResourceErrorKind::ReplicationGroupNotFoundFault(inner) => Error::ReplicationGroupNotFoundFault(inner),
                crate::error::RemoveTagsFromResourceErrorKind::ReservedCacheNodeNotFoundFault(inner) => Error::ReservedCacheNodeNotFoundFault(inner),
                crate::error::RemoveTagsFromResourceErrorKind::SnapshotNotFoundFault(inner) => Error::SnapshotNotFoundFault(inner),
                crate::error::RemoveTagsFromResourceErrorKind::TagNotFoundFault(inner) => Error::TagNotFoundFault(inner),
                crate::error::RemoveTagsFromResourceErrorKind::UserGroupNotFoundFault(inner) => Error::UserGroupNotFoundFault(inner),
                crate::error::RemoveTagsFromResourceErrorKind::UserNotFoundFault(inner) => Error::UserNotFoundFault(inner),
                crate::error::RemoveTagsFromResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ResetCacheParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ResetCacheParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ResetCacheParameterGroupErrorKind::CacheParameterGroupNotFoundFault(inner) => Error::CacheParameterGroupNotFoundFault(inner),
                crate::error::ResetCacheParameterGroupErrorKind::InvalidCacheParameterGroupStateFault(inner) => Error::InvalidCacheParameterGroupStateFault(inner),
                crate::error::ResetCacheParameterGroupErrorKind::InvalidGlobalReplicationGroupStateFault(inner) => Error::InvalidGlobalReplicationGroupStateFault(inner),
                crate::error::ResetCacheParameterGroupErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::ResetCacheParameterGroupErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::ResetCacheParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::RevokeCacheSecurityGroupIngressError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::RevokeCacheSecurityGroupIngressError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RevokeCacheSecurityGroupIngressErrorKind::AuthorizationNotFoundFault(inner) => Error::AuthorizationNotFoundFault(inner),
                crate::error::RevokeCacheSecurityGroupIngressErrorKind::CacheSecurityGroupNotFoundFault(inner) => Error::CacheSecurityGroupNotFoundFault(inner),
                crate::error::RevokeCacheSecurityGroupIngressErrorKind::InvalidCacheSecurityGroupStateFault(inner) => Error::InvalidCacheSecurityGroupStateFault(inner),
                crate::error::RevokeCacheSecurityGroupIngressErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::RevokeCacheSecurityGroupIngressErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::RevokeCacheSecurityGroupIngressErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartMigrationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StartMigrationError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartMigrationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::StartMigrationErrorKind::InvalidReplicationGroupStateFault(inner) => Error::InvalidReplicationGroupStateFault(inner),
                crate::error::StartMigrationErrorKind::ReplicationGroupAlreadyUnderMigrationFault(inner) => Error::ReplicationGroupAlreadyUnderMigrationFault(inner),
                crate::error::StartMigrationErrorKind::ReplicationGroupNotFoundFault(inner) => Error::ReplicationGroupNotFoundFault(inner),
                crate::error::StartMigrationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TestFailoverError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TestFailoverError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TestFailoverErrorKind::ApiCallRateForCustomerExceededFault(inner) => {
                    Error::ApiCallRateForCustomerExceededFault(inner)
                }
                crate::error::TestFailoverErrorKind::InvalidCacheClusterStateFault(inner) => {
                    Error::InvalidCacheClusterStateFault(inner)
                }
                crate::error::TestFailoverErrorKind::InvalidKmsKeyFault(inner) => {
                    Error::InvalidKmsKeyFault(inner)
                }
                crate::error::TestFailoverErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::TestFailoverErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::TestFailoverErrorKind::InvalidReplicationGroupStateFault(inner) => {
                    Error::InvalidReplicationGroupStateFault(inner)
                }
                crate::error::TestFailoverErrorKind::NodeGroupNotFoundFault(inner) => {
                    Error::NodeGroupNotFoundFault(inner)
                }
                crate::error::TestFailoverErrorKind::ReplicationGroupNotFoundFault(inner) => {
                    Error::ReplicationGroupNotFoundFault(inner)
                }
                crate::error::TestFailoverErrorKind::TestFailoverNotAvailableFault(inner) => {
                    Error::TestFailoverNotAvailableFault(inner)
                }
                crate::error::TestFailoverErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
