// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateEncryptionConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_encryption_config`](crate::client::Client::associate_encryption_config).
///
/// See [`crate::client::fluent_builders::AssociateEncryptionConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateEncryptionConfig {
    _private: (),
}
impl AssociateEncryptionConfig {
    /// Creates a new builder-style object to manufacture [`AssociateEncryptionConfigInput`](crate::input::AssociateEncryptionConfigInput)
    pub fn builder() -> crate::input::associate_encryption_config_input::Builder {
        crate::input::associate_encryption_config_input::Builder::default()
    }
    /// Creates a new `AssociateEncryptionConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateEncryptionConfig {
    type Output = std::result::Result<
        crate::output::AssociateEncryptionConfigOutput,
        crate::error::AssociateEncryptionConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_encryption_config_error(response)
        } else {
            crate::operation_deser::parse_associate_encryption_config_response(response)
        }
    }
}

/// Operation shape for `AssociateIdentityProviderConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_identity_provider_config`](crate::client::Client::associate_identity_provider_config).
///
/// See [`crate::client::fluent_builders::AssociateIdentityProviderConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateIdentityProviderConfig {
    _private: (),
}
impl AssociateIdentityProviderConfig {
    /// Creates a new builder-style object to manufacture [`AssociateIdentityProviderConfigInput`](crate::input::AssociateIdentityProviderConfigInput)
    pub fn builder() -> crate::input::associate_identity_provider_config_input::Builder {
        crate::input::associate_identity_provider_config_input::Builder::default()
    }
    /// Creates a new `AssociateIdentityProviderConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateIdentityProviderConfig {
    type Output = std::result::Result<
        crate::output::AssociateIdentityProviderConfigOutput,
        crate::error::AssociateIdentityProviderConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_identity_provider_config_error(response)
        } else {
            crate::operation_deser::parse_associate_identity_provider_config_response(response)
        }
    }
}

/// Operation shape for `CreateAddon`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_addon`](crate::client::Client::create_addon).
///
/// See [`crate::client::fluent_builders::CreateAddon`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAddon {
    _private: (),
}
impl CreateAddon {
    /// Creates a new builder-style object to manufacture [`CreateAddonInput`](crate::input::CreateAddonInput)
    pub fn builder() -> crate::input::create_addon_input::Builder {
        crate::input::create_addon_input::Builder::default()
    }
    /// Creates a new `CreateAddon` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAddon {
    type Output =
        std::result::Result<crate::output::CreateAddonOutput, crate::error::CreateAddonError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_addon_error(response)
        } else {
            crate::operation_deser::parse_create_addon_response(response)
        }
    }
}

/// Operation shape for `CreateCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cluster`](crate::client::Client::create_cluster).
///
/// See [`crate::client::fluent_builders::CreateCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCluster {
    _private: (),
}
impl CreateCluster {
    /// Creates a new builder-style object to manufacture [`CreateClusterInput`](crate::input::CreateClusterInput)
    pub fn builder() -> crate::input::create_cluster_input::Builder {
        crate::input::create_cluster_input::Builder::default()
    }
    /// Creates a new `CreateCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCluster {
    type Output =
        std::result::Result<crate::output::CreateClusterOutput, crate::error::CreateClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_cluster_error(response)
        } else {
            crate::operation_deser::parse_create_cluster_response(response)
        }
    }
}

/// Operation shape for `CreateFargateProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_fargate_profile`](crate::client::Client::create_fargate_profile).
///
/// See [`crate::client::fluent_builders::CreateFargateProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFargateProfile {
    _private: (),
}
impl CreateFargateProfile {
    /// Creates a new builder-style object to manufacture [`CreateFargateProfileInput`](crate::input::CreateFargateProfileInput)
    pub fn builder() -> crate::input::create_fargate_profile_input::Builder {
        crate::input::create_fargate_profile_input::Builder::default()
    }
    /// Creates a new `CreateFargateProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFargateProfile {
    type Output = std::result::Result<
        crate::output::CreateFargateProfileOutput,
        crate::error::CreateFargateProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_fargate_profile_error(response)
        } else {
            crate::operation_deser::parse_create_fargate_profile_response(response)
        }
    }
}

/// Operation shape for `CreateNodegroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_nodegroup`](crate::client::Client::create_nodegroup).
///
/// See [`crate::client::fluent_builders::CreateNodegroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNodegroup {
    _private: (),
}
impl CreateNodegroup {
    /// Creates a new builder-style object to manufacture [`CreateNodegroupInput`](crate::input::CreateNodegroupInput)
    pub fn builder() -> crate::input::create_nodegroup_input::Builder {
        crate::input::create_nodegroup_input::Builder::default()
    }
    /// Creates a new `CreateNodegroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNodegroup {
    type Output = std::result::Result<
        crate::output::CreateNodegroupOutput,
        crate::error::CreateNodegroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_nodegroup_error(response)
        } else {
            crate::operation_deser::parse_create_nodegroup_response(response)
        }
    }
}

/// Operation shape for `DeleteAddon`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_addon`](crate::client::Client::delete_addon).
///
/// See [`crate::client::fluent_builders::DeleteAddon`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAddon {
    _private: (),
}
impl DeleteAddon {
    /// Creates a new builder-style object to manufacture [`DeleteAddonInput`](crate::input::DeleteAddonInput)
    pub fn builder() -> crate::input::delete_addon_input::Builder {
        crate::input::delete_addon_input::Builder::default()
    }
    /// Creates a new `DeleteAddon` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAddon {
    type Output =
        std::result::Result<crate::output::DeleteAddonOutput, crate::error::DeleteAddonError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_addon_error(response)
        } else {
            crate::operation_deser::parse_delete_addon_response(response)
        }
    }
}

/// Operation shape for `DeleteCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_cluster`](crate::client::Client::delete_cluster).
///
/// See [`crate::client::fluent_builders::DeleteCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCluster {
    _private: (),
}
impl DeleteCluster {
    /// Creates a new builder-style object to manufacture [`DeleteClusterInput`](crate::input::DeleteClusterInput)
    pub fn builder() -> crate::input::delete_cluster_input::Builder {
        crate::input::delete_cluster_input::Builder::default()
    }
    /// Creates a new `DeleteCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCluster {
    type Output =
        std::result::Result<crate::output::DeleteClusterOutput, crate::error::DeleteClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_cluster_error(response)
        } else {
            crate::operation_deser::parse_delete_cluster_response(response)
        }
    }
}

/// Operation shape for `DeleteFargateProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_fargate_profile`](crate::client::Client::delete_fargate_profile).
///
/// See [`crate::client::fluent_builders::DeleteFargateProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFargateProfile {
    _private: (),
}
impl DeleteFargateProfile {
    /// Creates a new builder-style object to manufacture [`DeleteFargateProfileInput`](crate::input::DeleteFargateProfileInput)
    pub fn builder() -> crate::input::delete_fargate_profile_input::Builder {
        crate::input::delete_fargate_profile_input::Builder::default()
    }
    /// Creates a new `DeleteFargateProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFargateProfile {
    type Output = std::result::Result<
        crate::output::DeleteFargateProfileOutput,
        crate::error::DeleteFargateProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_fargate_profile_error(response)
        } else {
            crate::operation_deser::parse_delete_fargate_profile_response(response)
        }
    }
}

/// Operation shape for `DeleteNodegroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_nodegroup`](crate::client::Client::delete_nodegroup).
///
/// See [`crate::client::fluent_builders::DeleteNodegroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNodegroup {
    _private: (),
}
impl DeleteNodegroup {
    /// Creates a new builder-style object to manufacture [`DeleteNodegroupInput`](crate::input::DeleteNodegroupInput)
    pub fn builder() -> crate::input::delete_nodegroup_input::Builder {
        crate::input::delete_nodegroup_input::Builder::default()
    }
    /// Creates a new `DeleteNodegroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNodegroup {
    type Output = std::result::Result<
        crate::output::DeleteNodegroupOutput,
        crate::error::DeleteNodegroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_nodegroup_error(response)
        } else {
            crate::operation_deser::parse_delete_nodegroup_response(response)
        }
    }
}

/// Operation shape for `DeregisterCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_cluster`](crate::client::Client::deregister_cluster).
///
/// See [`crate::client::fluent_builders::DeregisterCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterCluster {
    _private: (),
}
impl DeregisterCluster {
    /// Creates a new builder-style object to manufacture [`DeregisterClusterInput`](crate::input::DeregisterClusterInput)
    pub fn builder() -> crate::input::deregister_cluster_input::Builder {
        crate::input::deregister_cluster_input::Builder::default()
    }
    /// Creates a new `DeregisterCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterCluster {
    type Output = std::result::Result<
        crate::output::DeregisterClusterOutput,
        crate::error::DeregisterClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_cluster_error(response)
        } else {
            crate::operation_deser::parse_deregister_cluster_response(response)
        }
    }
}

/// Operation shape for `DescribeAddon`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_addon`](crate::client::Client::describe_addon).
///
/// See [`crate::client::fluent_builders::DescribeAddon`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAddon {
    _private: (),
}
impl DescribeAddon {
    /// Creates a new builder-style object to manufacture [`DescribeAddonInput`](crate::input::DescribeAddonInput)
    pub fn builder() -> crate::input::describe_addon_input::Builder {
        crate::input::describe_addon_input::Builder::default()
    }
    /// Creates a new `DescribeAddon` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAddon {
    type Output =
        std::result::Result<crate::output::DescribeAddonOutput, crate::error::DescribeAddonError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_addon_error(response)
        } else {
            crate::operation_deser::parse_describe_addon_response(response)
        }
    }
}

/// Operation shape for `DescribeAddonVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_addon_versions`](crate::client::Client::describe_addon_versions).
///
/// See [`crate::client::fluent_builders::DescribeAddonVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAddonVersions {
    _private: (),
}
impl DescribeAddonVersions {
    /// Creates a new builder-style object to manufacture [`DescribeAddonVersionsInput`](crate::input::DescribeAddonVersionsInput)
    pub fn builder() -> crate::input::describe_addon_versions_input::Builder {
        crate::input::describe_addon_versions_input::Builder::default()
    }
    /// Creates a new `DescribeAddonVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAddonVersions {
    type Output = std::result::Result<
        crate::output::DescribeAddonVersionsOutput,
        crate::error::DescribeAddonVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_addon_versions_error(response)
        } else {
            crate::operation_deser::parse_describe_addon_versions_response(response)
        }
    }
}

/// Operation shape for `DescribeCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cluster`](crate::client::Client::describe_cluster).
///
/// See [`crate::client::fluent_builders::DescribeCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCluster {
    _private: (),
}
impl DescribeCluster {
    /// Creates a new builder-style object to manufacture [`DescribeClusterInput`](crate::input::DescribeClusterInput)
    pub fn builder() -> crate::input::describe_cluster_input::Builder {
        crate::input::describe_cluster_input::Builder::default()
    }
    /// Creates a new `DescribeCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCluster {
    type Output = std::result::Result<
        crate::output::DescribeClusterOutput,
        crate::error::DescribeClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cluster_error(response)
        } else {
            crate::operation_deser::parse_describe_cluster_response(response)
        }
    }
}

/// Operation shape for `DescribeFargateProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fargate_profile`](crate::client::Client::describe_fargate_profile).
///
/// See [`crate::client::fluent_builders::DescribeFargateProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFargateProfile {
    _private: (),
}
impl DescribeFargateProfile {
    /// Creates a new builder-style object to manufacture [`DescribeFargateProfileInput`](crate::input::DescribeFargateProfileInput)
    pub fn builder() -> crate::input::describe_fargate_profile_input::Builder {
        crate::input::describe_fargate_profile_input::Builder::default()
    }
    /// Creates a new `DescribeFargateProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFargateProfile {
    type Output = std::result::Result<
        crate::output::DescribeFargateProfileOutput,
        crate::error::DescribeFargateProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fargate_profile_error(response)
        } else {
            crate::operation_deser::parse_describe_fargate_profile_response(response)
        }
    }
}

/// Operation shape for `DescribeIdentityProviderConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_identity_provider_config`](crate::client::Client::describe_identity_provider_config).
///
/// See [`crate::client::fluent_builders::DescribeIdentityProviderConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeIdentityProviderConfig {
    _private: (),
}
impl DescribeIdentityProviderConfig {
    /// Creates a new builder-style object to manufacture [`DescribeIdentityProviderConfigInput`](crate::input::DescribeIdentityProviderConfigInput)
    pub fn builder() -> crate::input::describe_identity_provider_config_input::Builder {
        crate::input::describe_identity_provider_config_input::Builder::default()
    }
    /// Creates a new `DescribeIdentityProviderConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeIdentityProviderConfig {
    type Output = std::result::Result<
        crate::output::DescribeIdentityProviderConfigOutput,
        crate::error::DescribeIdentityProviderConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_identity_provider_config_error(response)
        } else {
            crate::operation_deser::parse_describe_identity_provider_config_response(response)
        }
    }
}

/// Operation shape for `DescribeNodegroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_nodegroup`](crate::client::Client::describe_nodegroup).
///
/// See [`crate::client::fluent_builders::DescribeNodegroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNodegroup {
    _private: (),
}
impl DescribeNodegroup {
    /// Creates a new builder-style object to manufacture [`DescribeNodegroupInput`](crate::input::DescribeNodegroupInput)
    pub fn builder() -> crate::input::describe_nodegroup_input::Builder {
        crate::input::describe_nodegroup_input::Builder::default()
    }
    /// Creates a new `DescribeNodegroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNodegroup {
    type Output = std::result::Result<
        crate::output::DescribeNodegroupOutput,
        crate::error::DescribeNodegroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_nodegroup_error(response)
        } else {
            crate::operation_deser::parse_describe_nodegroup_response(response)
        }
    }
}

/// Operation shape for `DescribeUpdate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_update`](crate::client::Client::describe_update).
///
/// See [`crate::client::fluent_builders::DescribeUpdate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUpdate {
    _private: (),
}
impl DescribeUpdate {
    /// Creates a new builder-style object to manufacture [`DescribeUpdateInput`](crate::input::DescribeUpdateInput)
    pub fn builder() -> crate::input::describe_update_input::Builder {
        crate::input::describe_update_input::Builder::default()
    }
    /// Creates a new `DescribeUpdate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUpdate {
    type Output =
        std::result::Result<crate::output::DescribeUpdateOutput, crate::error::DescribeUpdateError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_update_error(response)
        } else {
            crate::operation_deser::parse_describe_update_response(response)
        }
    }
}

/// Operation shape for `DisassociateIdentityProviderConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_identity_provider_config`](crate::client::Client::disassociate_identity_provider_config).
///
/// See [`crate::client::fluent_builders::DisassociateIdentityProviderConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateIdentityProviderConfig {
    _private: (),
}
impl DisassociateIdentityProviderConfig {
    /// Creates a new builder-style object to manufacture [`DisassociateIdentityProviderConfigInput`](crate::input::DisassociateIdentityProviderConfigInput)
    pub fn builder() -> crate::input::disassociate_identity_provider_config_input::Builder {
        crate::input::disassociate_identity_provider_config_input::Builder::default()
    }
    /// Creates a new `DisassociateIdentityProviderConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateIdentityProviderConfig {
    type Output = std::result::Result<
        crate::output::DisassociateIdentityProviderConfigOutput,
        crate::error::DisassociateIdentityProviderConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_identity_provider_config_error(response)
        } else {
            crate::operation_deser::parse_disassociate_identity_provider_config_response(response)
        }
    }
}

/// Operation shape for `ListAddons`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_addons`](crate::client::Client::list_addons).
///
/// See [`crate::client::fluent_builders::ListAddons`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAddons {
    _private: (),
}
impl ListAddons {
    /// Creates a new builder-style object to manufacture [`ListAddonsInput`](crate::input::ListAddonsInput)
    pub fn builder() -> crate::input::list_addons_input::Builder {
        crate::input::list_addons_input::Builder::default()
    }
    /// Creates a new `ListAddons` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAddons {
    type Output =
        std::result::Result<crate::output::ListAddonsOutput, crate::error::ListAddonsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_addons_error(response)
        } else {
            crate::operation_deser::parse_list_addons_response(response)
        }
    }
}

/// Operation shape for `ListClusters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_clusters`](crate::client::Client::list_clusters).
///
/// See [`crate::client::fluent_builders::ListClusters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListClusters {
    _private: (),
}
impl ListClusters {
    /// Creates a new builder-style object to manufacture [`ListClustersInput`](crate::input::ListClustersInput)
    pub fn builder() -> crate::input::list_clusters_input::Builder {
        crate::input::list_clusters_input::Builder::default()
    }
    /// Creates a new `ListClusters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListClusters {
    type Output =
        std::result::Result<crate::output::ListClustersOutput, crate::error::ListClustersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_clusters_error(response)
        } else {
            crate::operation_deser::parse_list_clusters_response(response)
        }
    }
}

/// Operation shape for `ListFargateProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_fargate_profiles`](crate::client::Client::list_fargate_profiles).
///
/// See [`crate::client::fluent_builders::ListFargateProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFargateProfiles {
    _private: (),
}
impl ListFargateProfiles {
    /// Creates a new builder-style object to manufacture [`ListFargateProfilesInput`](crate::input::ListFargateProfilesInput)
    pub fn builder() -> crate::input::list_fargate_profiles_input::Builder {
        crate::input::list_fargate_profiles_input::Builder::default()
    }
    /// Creates a new `ListFargateProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFargateProfiles {
    type Output = std::result::Result<
        crate::output::ListFargateProfilesOutput,
        crate::error::ListFargateProfilesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_fargate_profiles_error(response)
        } else {
            crate::operation_deser::parse_list_fargate_profiles_response(response)
        }
    }
}

/// Operation shape for `ListIdentityProviderConfigs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_identity_provider_configs`](crate::client::Client::list_identity_provider_configs).
///
/// See [`crate::client::fluent_builders::ListIdentityProviderConfigs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIdentityProviderConfigs {
    _private: (),
}
impl ListIdentityProviderConfigs {
    /// Creates a new builder-style object to manufacture [`ListIdentityProviderConfigsInput`](crate::input::ListIdentityProviderConfigsInput)
    pub fn builder() -> crate::input::list_identity_provider_configs_input::Builder {
        crate::input::list_identity_provider_configs_input::Builder::default()
    }
    /// Creates a new `ListIdentityProviderConfigs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIdentityProviderConfigs {
    type Output = std::result::Result<
        crate::output::ListIdentityProviderConfigsOutput,
        crate::error::ListIdentityProviderConfigsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_identity_provider_configs_error(response)
        } else {
            crate::operation_deser::parse_list_identity_provider_configs_response(response)
        }
    }
}

/// Operation shape for `ListNodegroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_nodegroups`](crate::client::Client::list_nodegroups).
///
/// See [`crate::client::fluent_builders::ListNodegroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListNodegroups {
    _private: (),
}
impl ListNodegroups {
    /// Creates a new builder-style object to manufacture [`ListNodegroupsInput`](crate::input::ListNodegroupsInput)
    pub fn builder() -> crate::input::list_nodegroups_input::Builder {
        crate::input::list_nodegroups_input::Builder::default()
    }
    /// Creates a new `ListNodegroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListNodegroups {
    type Output =
        std::result::Result<crate::output::ListNodegroupsOutput, crate::error::ListNodegroupsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_nodegroups_error(response)
        } else {
            crate::operation_deser::parse_list_nodegroups_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListUpdates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_updates`](crate::client::Client::list_updates).
///
/// See [`crate::client::fluent_builders::ListUpdates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUpdates {
    _private: (),
}
impl ListUpdates {
    /// Creates a new builder-style object to manufacture [`ListUpdatesInput`](crate::input::ListUpdatesInput)
    pub fn builder() -> crate::input::list_updates_input::Builder {
        crate::input::list_updates_input::Builder::default()
    }
    /// Creates a new `ListUpdates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUpdates {
    type Output =
        std::result::Result<crate::output::ListUpdatesOutput, crate::error::ListUpdatesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_updates_error(response)
        } else {
            crate::operation_deser::parse_list_updates_response(response)
        }
    }
}

/// Operation shape for `RegisterCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_cluster`](crate::client::Client::register_cluster).
///
/// See [`crate::client::fluent_builders::RegisterCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterCluster {
    _private: (),
}
impl RegisterCluster {
    /// Creates a new builder-style object to manufacture [`RegisterClusterInput`](crate::input::RegisterClusterInput)
    pub fn builder() -> crate::input::register_cluster_input::Builder {
        crate::input::register_cluster_input::Builder::default()
    }
    /// Creates a new `RegisterCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterCluster {
    type Output = std::result::Result<
        crate::output::RegisterClusterOutput,
        crate::error::RegisterClusterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_cluster_error(response)
        } else {
            crate::operation_deser::parse_register_cluster_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAddon`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_addon`](crate::client::Client::update_addon).
///
/// See [`crate::client::fluent_builders::UpdateAddon`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAddon {
    _private: (),
}
impl UpdateAddon {
    /// Creates a new builder-style object to manufacture [`UpdateAddonInput`](crate::input::UpdateAddonInput)
    pub fn builder() -> crate::input::update_addon_input::Builder {
        crate::input::update_addon_input::Builder::default()
    }
    /// Creates a new `UpdateAddon` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAddon {
    type Output =
        std::result::Result<crate::output::UpdateAddonOutput, crate::error::UpdateAddonError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_addon_error(response)
        } else {
            crate::operation_deser::parse_update_addon_response(response)
        }
    }
}

/// Operation shape for `UpdateClusterConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_cluster_config`](crate::client::Client::update_cluster_config).
///
/// See [`crate::client::fluent_builders::UpdateClusterConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateClusterConfig {
    _private: (),
}
impl UpdateClusterConfig {
    /// Creates a new builder-style object to manufacture [`UpdateClusterConfigInput`](crate::input::UpdateClusterConfigInput)
    pub fn builder() -> crate::input::update_cluster_config_input::Builder {
        crate::input::update_cluster_config_input::Builder::default()
    }
    /// Creates a new `UpdateClusterConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateClusterConfig {
    type Output = std::result::Result<
        crate::output::UpdateClusterConfigOutput,
        crate::error::UpdateClusterConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_cluster_config_error(response)
        } else {
            crate::operation_deser::parse_update_cluster_config_response(response)
        }
    }
}

/// Operation shape for `UpdateClusterVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_cluster_version`](crate::client::Client::update_cluster_version).
///
/// See [`crate::client::fluent_builders::UpdateClusterVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateClusterVersion {
    _private: (),
}
impl UpdateClusterVersion {
    /// Creates a new builder-style object to manufacture [`UpdateClusterVersionInput`](crate::input::UpdateClusterVersionInput)
    pub fn builder() -> crate::input::update_cluster_version_input::Builder {
        crate::input::update_cluster_version_input::Builder::default()
    }
    /// Creates a new `UpdateClusterVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateClusterVersion {
    type Output = std::result::Result<
        crate::output::UpdateClusterVersionOutput,
        crate::error::UpdateClusterVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_cluster_version_error(response)
        } else {
            crate::operation_deser::parse_update_cluster_version_response(response)
        }
    }
}

/// Operation shape for `UpdateNodegroupConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_nodegroup_config`](crate::client::Client::update_nodegroup_config).
///
/// See [`crate::client::fluent_builders::UpdateNodegroupConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateNodegroupConfig {
    _private: (),
}
impl UpdateNodegroupConfig {
    /// Creates a new builder-style object to manufacture [`UpdateNodegroupConfigInput`](crate::input::UpdateNodegroupConfigInput)
    pub fn builder() -> crate::input::update_nodegroup_config_input::Builder {
        crate::input::update_nodegroup_config_input::Builder::default()
    }
    /// Creates a new `UpdateNodegroupConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateNodegroupConfig {
    type Output = std::result::Result<
        crate::output::UpdateNodegroupConfigOutput,
        crate::error::UpdateNodegroupConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_nodegroup_config_error(response)
        } else {
            crate::operation_deser::parse_update_nodegroup_config_response(response)
        }
    }
}

/// Operation shape for `UpdateNodegroupVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_nodegroup_version`](crate::client::Client::update_nodegroup_version).
///
/// See [`crate::client::fluent_builders::UpdateNodegroupVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateNodegroupVersion {
    _private: (),
}
impl UpdateNodegroupVersion {
    /// Creates a new builder-style object to manufacture [`UpdateNodegroupVersionInput`](crate::input::UpdateNodegroupVersionInput)
    pub fn builder() -> crate::input::update_nodegroup_version_input::Builder {
        crate::input::update_nodegroup_version_input::Builder::default()
    }
    /// Creates a new `UpdateNodegroupVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateNodegroupVersion {
    type Output = std::result::Result<
        crate::output::UpdateNodegroupVersionOutput,
        crate::error::UpdateNodegroupVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_nodegroup_version_error(response)
        } else {
            crate::operation_deser::parse_update_nodegroup_version_response(response)
        }
    }
}
