// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateEncryptionConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateEncryptionConfigError {
    /// Kind of error that occurred.
    pub kind: AssociateEncryptionConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateEncryptionConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateEncryptionConfigErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is invalid given the state of the cluster. Check the state of the cluster and the associated operations.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateEncryptionConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateEncryptionConfigErrorKind::ClientException(_inner) => _inner.fmt(f),
            AssociateEncryptionConfigErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AssociateEncryptionConfigErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AssociateEncryptionConfigErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            AssociateEncryptionConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateEncryptionConfigErrorKind::ServerException(_inner) => _inner.fmt(f),
            AssociateEncryptionConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateEncryptionConfigError {
    fn code(&self) -> Option<&str> {
        AssociateEncryptionConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateEncryptionConfigError {
    /// Creates a new `AssociateEncryptionConfigError`.
    pub fn new(kind: AssociateEncryptionConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateEncryptionConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateEncryptionConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateEncryptionConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateEncryptionConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateEncryptionConfigErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateEncryptionConfigErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateEncryptionConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateEncryptionConfigErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateEncryptionConfigErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateEncryptionConfigErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateEncryptionConfigErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateEncryptionConfigErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateEncryptionConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateEncryptionConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateEncryptionConfigErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateEncryptionConfigErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for AssociateEncryptionConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateEncryptionConfigErrorKind::ClientException(_inner) => Some(_inner),
            AssociateEncryptionConfigErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AssociateEncryptionConfigErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AssociateEncryptionConfigErrorKind::ResourceInUseException(_inner) => Some(_inner),
            AssociateEncryptionConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateEncryptionConfigErrorKind::ServerException(_inner) => Some(_inner),
            AssociateEncryptionConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateIdentityProviderConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateIdentityProviderConfigError {
    /// Kind of error that occurred.
    pub kind: AssociateIdentityProviderConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateIdentityProviderConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateIdentityProviderConfigErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is invalid given the state of the cluster. Check the state of the cluster and the associated operations.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateIdentityProviderConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateIdentityProviderConfigErrorKind::ClientException(_inner) => _inner.fmt(f),
            AssociateIdentityProviderConfigErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            AssociateIdentityProviderConfigErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            AssociateIdentityProviderConfigErrorKind::ResourceInUseException(_inner) => {
                _inner.fmt(f)
            }
            AssociateIdentityProviderConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateIdentityProviderConfigErrorKind::ServerException(_inner) => _inner.fmt(f),
            AssociateIdentityProviderConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateIdentityProviderConfigError {
    fn code(&self) -> Option<&str> {
        AssociateIdentityProviderConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateIdentityProviderConfigError {
    /// Creates a new `AssociateIdentityProviderConfigError`.
    pub fn new(
        kind: AssociateIdentityProviderConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateIdentityProviderConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateIdentityProviderConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateIdentityProviderConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateIdentityProviderConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateIdentityProviderConfigErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateIdentityProviderConfigErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateIdentityProviderConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateIdentityProviderConfigErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateIdentityProviderConfigErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateIdentityProviderConfigErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateIdentityProviderConfigErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateIdentityProviderConfigErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateIdentityProviderConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateIdentityProviderConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateIdentityProviderConfigErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateIdentityProviderConfigErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for AssociateIdentityProviderConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateIdentityProviderConfigErrorKind::ClientException(_inner) => Some(_inner),
            AssociateIdentityProviderConfigErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            AssociateIdentityProviderConfigErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            AssociateIdentityProviderConfigErrorKind::ResourceInUseException(_inner) => {
                Some(_inner)
            }
            AssociateIdentityProviderConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateIdentityProviderConfigErrorKind::ServerException(_inner) => Some(_inner),
            AssociateIdentityProviderConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAddon` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAddonError {
    /// Kind of error that occurred.
    pub kind: CreateAddonErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAddon` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAddonErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is invalid given the state of the cluster. Check the state of the cluster and the associated operations.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAddonError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAddonErrorKind::ClientException(_inner) => _inner.fmt(f),
            CreateAddonErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateAddonErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateAddonErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateAddonErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateAddonErrorKind::ServerException(_inner) => _inner.fmt(f),
            CreateAddonErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAddonError {
    fn code(&self) -> Option<&str> {
        CreateAddonError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAddonError {
    /// Creates a new `CreateAddonError`.
    pub fn new(kind: CreateAddonErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAddonError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAddonErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAddonError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAddonErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAddonErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, CreateAddonErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `CreateAddonErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAddonErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAddonErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CreateAddonErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateAddonErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, CreateAddonErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `CreateAddonErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAddonErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAddonErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, CreateAddonErrorKind::ServerException(_))
    }
}
impl std::error::Error for CreateAddonError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAddonErrorKind::ClientException(_inner) => Some(_inner),
            CreateAddonErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateAddonErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateAddonErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateAddonErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateAddonErrorKind::ServerException(_inner) => Some(_inner),
            CreateAddonErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateClusterError {
    /// Kind of error that occurred.
    pub kind: CreateClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateClusterErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>You have encountered a service limit on the specified resource.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The service is unavailable. Back off and retry the operation.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>At least one of your specified cluster subnets is in an Availability Zone that does not support Amazon EKS. The exception output specifies the supported Availability Zones for your account, from which you can choose subnets for your cluster.</p>
    UnsupportedAvailabilityZoneException(crate::error::UnsupportedAvailabilityZoneException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateClusterErrorKind::ClientException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ServerException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::UnsupportedAvailabilityZoneException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateClusterError {
    fn code(&self) -> Option<&str> {
        CreateClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateClusterError {
    /// Creates a new `CreateClusterError`.
    pub fn new(kind: CreateClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, CreateClusterErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, CreateClusterErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::UnsupportedAvailabilityZoneException`.
    pub fn is_unsupported_availability_zone_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::UnsupportedAvailabilityZoneException(_)
        )
    }
}
impl std::error::Error for CreateClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateClusterErrorKind::ClientException(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateClusterErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateClusterErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateClusterErrorKind::ServerException(_inner) => Some(_inner),
            CreateClusterErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateClusterErrorKind::UnsupportedAvailabilityZoneException(_inner) => Some(_inner),
            CreateClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFargateProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFargateProfileError {
    /// Kind of error that occurred.
    pub kind: CreateFargateProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFargateProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFargateProfileErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is invalid given the state of the cluster. Check the state of the cluster and the associated operations.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You have encountered a service limit on the specified resource.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>At least one of your specified cluster subnets is in an Availability Zone that does not support Amazon EKS. The exception output specifies the supported Availability Zones for your account, from which you can choose subnets for your cluster.</p>
    UnsupportedAvailabilityZoneException(crate::error::UnsupportedAvailabilityZoneException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFargateProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFargateProfileErrorKind::ClientException(_inner) => _inner.fmt(f),
            CreateFargateProfileErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateFargateProfileErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateFargateProfileErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateFargateProfileErrorKind::ServerException(_inner) => _inner.fmt(f),
            CreateFargateProfileErrorKind::UnsupportedAvailabilityZoneException(_inner) => {
                _inner.fmt(f)
            }
            CreateFargateProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFargateProfileError {
    fn code(&self) -> Option<&str> {
        CreateFargateProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFargateProfileError {
    /// Creates a new `CreateFargateProfileError`.
    pub fn new(kind: CreateFargateProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFargateProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFargateProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFargateProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFargateProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFargateProfileErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFargateProfileErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFargateProfileErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFargateProfileErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFargateProfileErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFargateProfileErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFargateProfileErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFargateProfileErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFargateProfileErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFargateProfileErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFargateProfileErrorKind::UnsupportedAvailabilityZoneException`.
    pub fn is_unsupported_availability_zone_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFargateProfileErrorKind::UnsupportedAvailabilityZoneException(_)
        )
    }
}
impl std::error::Error for CreateFargateProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFargateProfileErrorKind::ClientException(_inner) => Some(_inner),
            CreateFargateProfileErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateFargateProfileErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateFargateProfileErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateFargateProfileErrorKind::ServerException(_inner) => Some(_inner),
            CreateFargateProfileErrorKind::UnsupportedAvailabilityZoneException(_inner) => {
                Some(_inner)
            }
            CreateFargateProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateNodegroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateNodegroupError {
    /// Kind of error that occurred.
    pub kind: CreateNodegroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateNodegroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateNodegroupErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is invalid given the state of the cluster. Check the state of the cluster and the associated operations.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>You have encountered a service limit on the specified resource.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The service is unavailable. Back off and retry the operation.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateNodegroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateNodegroupErrorKind::ClientException(_inner) => _inner.fmt(f),
            CreateNodegroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateNodegroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateNodegroupErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            CreateNodegroupErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateNodegroupErrorKind::ServerException(_inner) => _inner.fmt(f),
            CreateNodegroupErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateNodegroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateNodegroupError {
    fn code(&self) -> Option<&str> {
        CreateNodegroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateNodegroupError {
    /// Creates a new `CreateNodegroupError`.
    pub fn new(kind: CreateNodegroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateNodegroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateNodegroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateNodegroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateNodegroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateNodegroupErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, CreateNodegroupErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `CreateNodegroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNodegroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNodegroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNodegroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNodegroupErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNodegroupErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNodegroupErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNodegroupErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNodegroupErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, CreateNodegroupErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `CreateNodegroupErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNodegroupErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateNodegroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateNodegroupErrorKind::ClientException(_inner) => Some(_inner),
            CreateNodegroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateNodegroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateNodegroupErrorKind::ResourceInUseException(_inner) => Some(_inner),
            CreateNodegroupErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateNodegroupErrorKind::ServerException(_inner) => Some(_inner),
            CreateNodegroupErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateNodegroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAddon` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAddonError {
    /// Kind of error that occurred.
    pub kind: DeleteAddonErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAddon` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAddonErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is invalid given the state of the cluster. Check the state of the cluster and the associated operations.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAddonError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAddonErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeleteAddonErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteAddonErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteAddonErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAddonErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeleteAddonErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAddonError {
    fn code(&self) -> Option<&str> {
        DeleteAddonError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAddonError {
    /// Creates a new `DeleteAddonError`.
    pub fn new(kind: DeleteAddonErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAddonError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAddonErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAddonError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAddonErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAddonErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DeleteAddonErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DeleteAddonErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAddonErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAddonErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteAddonErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteAddonErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAddonErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAddonErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteAddonErrorKind::ServerException(_))
    }
}
impl std::error::Error for DeleteAddonError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAddonErrorKind::ClientException(_inner) => Some(_inner),
            DeleteAddonErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteAddonErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteAddonErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAddonErrorKind::ServerException(_inner) => Some(_inner),
            DeleteAddonErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteClusterError {
    /// Kind of error that occurred.
    pub kind: DeleteClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteClusterErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The service is unavailable. Back off and retry the operation.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteClusterErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteClusterError {
    fn code(&self) -> Option<&str> {
        DeleteClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteClusterError {
    /// Creates a new `DeleteClusterError`.
    pub fn new(kind: DeleteClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DeleteClusterErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteClusterErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteClusterErrorKind::ClientException(_inner) => Some(_inner),
            DeleteClusterErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteClusterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteClusterErrorKind::ServerException(_inner) => Some(_inner),
            DeleteClusterErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFargateProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFargateProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteFargateProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFargateProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFargateProfileErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFargateProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFargateProfileErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeleteFargateProfileErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteFargateProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFargateProfileErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeleteFargateProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFargateProfileError {
    fn code(&self) -> Option<&str> {
        DeleteFargateProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFargateProfileError {
    /// Creates a new `DeleteFargateProfileError`.
    pub fn new(kind: DeleteFargateProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFargateProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFargateProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFargateProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFargateProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFargateProfileErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFargateProfileErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFargateProfileErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFargateProfileErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFargateProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFargateProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFargateProfileErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFargateProfileErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DeleteFargateProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFargateProfileErrorKind::ClientException(_inner) => Some(_inner),
            DeleteFargateProfileErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteFargateProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFargateProfileErrorKind::ServerException(_inner) => Some(_inner),
            DeleteFargateProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteNodegroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteNodegroupError {
    /// Kind of error that occurred.
    pub kind: DeleteNodegroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteNodegroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteNodegroupErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The service is unavailable. Back off and retry the operation.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteNodegroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteNodegroupErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeleteNodegroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteNodegroupErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteNodegroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteNodegroupErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeleteNodegroupErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteNodegroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteNodegroupError {
    fn code(&self) -> Option<&str> {
        DeleteNodegroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteNodegroupError {
    /// Creates a new `DeleteNodegroupError`.
    pub fn new(kind: DeleteNodegroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteNodegroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteNodegroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteNodegroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteNodegroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteNodegroupErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DeleteNodegroupErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DeleteNodegroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNodegroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNodegroupErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNodegroupErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNodegroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNodegroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNodegroupErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteNodegroupErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteNodegroupErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNodegroupErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteNodegroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteNodegroupErrorKind::ClientException(_inner) => Some(_inner),
            DeleteNodegroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteNodegroupErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteNodegroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteNodegroupErrorKind::ServerException(_inner) => Some(_inner),
            DeleteNodegroupErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteNodegroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterClusterError {
    /// Kind of error that occurred.
    pub kind: DeregisterClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterClusterErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The service is unavailable. Back off and retry the operation.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterClusterErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeregisterClusterErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeregisterClusterErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeregisterClusterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeregisterClusterErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeregisterClusterErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeregisterClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterClusterError {
    fn code(&self) -> Option<&str> {
        DeregisterClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterClusterError {
    /// Creates a new `DeregisterClusterError`.
    pub fn new(kind: DeregisterClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterClusterErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterClusterErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterClusterErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DeregisterClusterErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DeregisterClusterErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterClusterErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterClusterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterClusterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterClusterErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DeregisterClusterErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `DeregisterClusterErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterClusterErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeregisterClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterClusterErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeregisterClusterErrorKind::ClientException(_inner) => Some(_inner),
            DeregisterClusterErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeregisterClusterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeregisterClusterErrorKind::ServerException(_inner) => Some(_inner),
            DeregisterClusterErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeregisterClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAddon` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAddonError {
    /// Kind of error that occurred.
    pub kind: DescribeAddonErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAddon` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAddonErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is invalid given the state of the cluster. Check the state of the cluster and the associated operations.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAddonError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAddonErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeAddonErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeAddonErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeAddonErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAddonErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeAddonErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAddonError {
    fn code(&self) -> Option<&str> {
        DescribeAddonError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAddonError {
    /// Creates a new `DescribeAddonError`.
    pub fn new(kind: DescribeAddonErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAddonError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAddonErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAddonError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAddonErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAddonErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DescribeAddonErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DescribeAddonErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAddonErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAddonErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAddonErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAddonErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAddonErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAddonErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DescribeAddonErrorKind::ServerException(_))
    }
}
impl std::error::Error for DescribeAddonError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAddonErrorKind::ClientException(_inner) => Some(_inner),
            DescribeAddonErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeAddonErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeAddonErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAddonErrorKind::ServerException(_inner) => Some(_inner),
            DescribeAddonErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAddonVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAddonVersionsError {
    /// Kind of error that occurred.
    pub kind: DescribeAddonVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAddonVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAddonVersionsErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAddonVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAddonVersionsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeAddonVersionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAddonVersionsErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeAddonVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAddonVersionsError {
    fn code(&self) -> Option<&str> {
        DescribeAddonVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAddonVersionsError {
    /// Creates a new `DescribeAddonVersionsError`.
    pub fn new(kind: DescribeAddonVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAddonVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAddonVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAddonVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAddonVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAddonVersionsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAddonVersionsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAddonVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAddonVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAddonVersionsErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAddonVersionsErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DescribeAddonVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAddonVersionsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeAddonVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAddonVersionsErrorKind::ServerException(_inner) => Some(_inner),
            DescribeAddonVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClusterError {
    /// Kind of error that occurred.
    pub kind: DescribeClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClusterErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The service is unavailable. Back off and retry the operation.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClusterErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeClusterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeClusterErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeClusterErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClusterError {
    fn code(&self) -> Option<&str> {
        DescribeClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClusterError {
    /// Creates a new `DescribeClusterError`.
    pub fn new(kind: DescribeClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeClusterErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DescribeClusterErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DescribeClusterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClusterErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DescribeClusterErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `DescribeClusterErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClusterErrorKind::ClientException(_inner) => Some(_inner),
            DescribeClusterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeClusterErrorKind::ServerException(_inner) => Some(_inner),
            DescribeClusterErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFargateProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFargateProfileError {
    /// Kind of error that occurred.
    pub kind: DescribeFargateProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFargateProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFargateProfileErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFargateProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFargateProfileErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeFargateProfileErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeFargateProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeFargateProfileErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeFargateProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFargateProfileError {
    fn code(&self) -> Option<&str> {
        DescribeFargateProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFargateProfileError {
    /// Creates a new `DescribeFargateProfileError`.
    pub fn new(kind: DescribeFargateProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFargateProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFargateProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFargateProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFargateProfileErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFargateProfileErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFargateProfileErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFargateProfileErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFargateProfileErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFargateProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFargateProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFargateProfileErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFargateProfileErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DescribeFargateProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFargateProfileErrorKind::ClientException(_inner) => Some(_inner),
            DescribeFargateProfileErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeFargateProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeFargateProfileErrorKind::ServerException(_inner) => Some(_inner),
            DescribeFargateProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeIdentityProviderConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeIdentityProviderConfigError {
    /// Kind of error that occurred.
    pub kind: DescribeIdentityProviderConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeIdentityProviderConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeIdentityProviderConfigErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The service is unavailable. Back off and retry the operation.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeIdentityProviderConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeIdentityProviderConfigErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeIdentityProviderConfigErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DescribeIdentityProviderConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeIdentityProviderConfigErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeIdentityProviderConfigErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DescribeIdentityProviderConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeIdentityProviderConfigError {
    fn code(&self) -> Option<&str> {
        DescribeIdentityProviderConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeIdentityProviderConfigError {
    /// Creates a new `DescribeIdentityProviderConfigError`.
    pub fn new(
        kind: DescribeIdentityProviderConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeIdentityProviderConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeIdentityProviderConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeIdentityProviderConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeIdentityProviderConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeIdentityProviderConfigErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIdentityProviderConfigErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIdentityProviderConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIdentityProviderConfigErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIdentityProviderConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIdentityProviderConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIdentityProviderConfigErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIdentityProviderConfigErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIdentityProviderConfigErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIdentityProviderConfigErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeIdentityProviderConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeIdentityProviderConfigErrorKind::ClientException(_inner) => Some(_inner),
            DescribeIdentityProviderConfigErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DescribeIdentityProviderConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeIdentityProviderConfigErrorKind::ServerException(_inner) => Some(_inner),
            DescribeIdentityProviderConfigErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            DescribeIdentityProviderConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeNodegroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeNodegroupError {
    /// Kind of error that occurred.
    pub kind: DescribeNodegroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeNodegroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeNodegroupErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The service is unavailable. Back off and retry the operation.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeNodegroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeNodegroupErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeNodegroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeNodegroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeNodegroupErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeNodegroupErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeNodegroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeNodegroupError {
    fn code(&self) -> Option<&str> {
        DescribeNodegroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeNodegroupError {
    /// Creates a new `DescribeNodegroupError`.
    pub fn new(kind: DescribeNodegroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeNodegroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeNodegroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeNodegroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeNodegroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeNodegroupErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DescribeNodegroupErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DescribeNodegroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNodegroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNodegroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNodegroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNodegroupErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DescribeNodegroupErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `DescribeNodegroupErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNodegroupErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeNodegroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeNodegroupErrorKind::ClientException(_inner) => Some(_inner),
            DescribeNodegroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeNodegroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeNodegroupErrorKind::ServerException(_inner) => Some(_inner),
            DescribeNodegroupErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeNodegroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUpdate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUpdateError {
    /// Kind of error that occurred.
    pub kind: DescribeUpdateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUpdate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUpdateErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUpdateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUpdateErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeUpdateErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeUpdateErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeUpdateErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeUpdateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUpdateError {
    fn code(&self) -> Option<&str> {
        DescribeUpdateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUpdateError {
    /// Creates a new `DescribeUpdateError`.
    pub fn new(kind: DescribeUpdateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUpdateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUpdateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUpdateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUpdateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeUpdateErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DescribeUpdateErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DescribeUpdateErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUpdateErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUpdateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUpdateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUpdateErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DescribeUpdateErrorKind::ServerException(_))
    }
}
impl std::error::Error for DescribeUpdateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUpdateErrorKind::ClientException(_inner) => Some(_inner),
            DescribeUpdateErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeUpdateErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeUpdateErrorKind::ServerException(_inner) => Some(_inner),
            DescribeUpdateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateIdentityProviderConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateIdentityProviderConfigError {
    /// Kind of error that occurred.
    pub kind: DisassociateIdentityProviderConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateIdentityProviderConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateIdentityProviderConfigErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is invalid given the state of the cluster. Check the state of the cluster and the associated operations.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateIdentityProviderConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateIdentityProviderConfigErrorKind::ClientException(_inner) => _inner.fmt(f),
            DisassociateIdentityProviderConfigErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateIdentityProviderConfigErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateIdentityProviderConfigErrorKind::ResourceInUseException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateIdentityProviderConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateIdentityProviderConfigErrorKind::ServerException(_inner) => _inner.fmt(f),
            DisassociateIdentityProviderConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateIdentityProviderConfigError {
    fn code(&self) -> Option<&str> {
        DisassociateIdentityProviderConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateIdentityProviderConfigError {
    /// Creates a new `DisassociateIdentityProviderConfigError`.
    pub fn new(
        kind: DisassociateIdentityProviderConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateIdentityProviderConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateIdentityProviderConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateIdentityProviderConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateIdentityProviderConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateIdentityProviderConfigErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateIdentityProviderConfigErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateIdentityProviderConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateIdentityProviderConfigErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateIdentityProviderConfigErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateIdentityProviderConfigErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateIdentityProviderConfigErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateIdentityProviderConfigErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateIdentityProviderConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateIdentityProviderConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateIdentityProviderConfigErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateIdentityProviderConfigErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DisassociateIdentityProviderConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateIdentityProviderConfigErrorKind::ClientException(_inner) => Some(_inner),
            DisassociateIdentityProviderConfigErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DisassociateIdentityProviderConfigErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DisassociateIdentityProviderConfigErrorKind::ResourceInUseException(_inner) => {
                Some(_inner)
            }
            DisassociateIdentityProviderConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateIdentityProviderConfigErrorKind::ServerException(_inner) => Some(_inner),
            DisassociateIdentityProviderConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAddons` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAddonsError {
    /// Kind of error that occurred.
    pub kind: ListAddonsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAddons` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAddonsErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is invalid given the state of the cluster. Check the state of the cluster and the associated operations.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAddonsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAddonsErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListAddonsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListAddonsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListAddonsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAddonsErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListAddonsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAddonsError {
    fn code(&self) -> Option<&str> {
        ListAddonsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAddonsError {
    /// Creates a new `ListAddonsError`.
    pub fn new(kind: ListAddonsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAddonsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAddonsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAddonsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAddonsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAddonsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ListAddonsErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ListAddonsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAddonsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAddonsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListAddonsErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListAddonsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAddonsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAddonsErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, ListAddonsErrorKind::ServerException(_))
    }
}
impl std::error::Error for ListAddonsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAddonsErrorKind::ClientException(_inner) => Some(_inner),
            ListAddonsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListAddonsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListAddonsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAddonsErrorKind::ServerException(_inner) => Some(_inner),
            ListAddonsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListClustersError {
    /// Kind of error that occurred.
    pub kind: ListClustersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListClustersErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The service is unavailable. Back off and retry the operation.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListClustersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListClustersErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListClustersErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListClustersErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListClustersErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListClustersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListClustersError {
    fn code(&self) -> Option<&str> {
        ListClustersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListClustersError {
    /// Creates a new `ListClustersError`.
    pub fn new(kind: ListClustersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListClustersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListClustersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListClustersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListClustersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListClustersErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ListClustersErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ListClustersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClustersErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListClustersErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, ListClustersErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `ListClustersErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClustersErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListClustersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListClustersErrorKind::ClientException(_inner) => Some(_inner),
            ListClustersErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListClustersErrorKind::ServerException(_inner) => Some(_inner),
            ListClustersErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListClustersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFargateProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFargateProfilesError {
    /// Kind of error that occurred.
    pub kind: ListFargateProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFargateProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFargateProfilesErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFargateProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFargateProfilesErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListFargateProfilesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListFargateProfilesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListFargateProfilesErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListFargateProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFargateProfilesError {
    fn code(&self) -> Option<&str> {
        ListFargateProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFargateProfilesError {
    /// Creates a new `ListFargateProfilesError`.
    pub fn new(kind: ListFargateProfilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFargateProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFargateProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFargateProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFargateProfilesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFargateProfilesErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ListFargateProfilesErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ListFargateProfilesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFargateProfilesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFargateProfilesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFargateProfilesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFargateProfilesErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, ListFargateProfilesErrorKind::ServerException(_))
    }
}
impl std::error::Error for ListFargateProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFargateProfilesErrorKind::ClientException(_inner) => Some(_inner),
            ListFargateProfilesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListFargateProfilesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListFargateProfilesErrorKind::ServerException(_inner) => Some(_inner),
            ListFargateProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListIdentityProviderConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIdentityProviderConfigsError {
    /// Kind of error that occurred.
    pub kind: ListIdentityProviderConfigsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIdentityProviderConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIdentityProviderConfigsErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The service is unavailable. Back off and retry the operation.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIdentityProviderConfigsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIdentityProviderConfigsErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListIdentityProviderConfigsErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            ListIdentityProviderConfigsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListIdentityProviderConfigsErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListIdentityProviderConfigsErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            ListIdentityProviderConfigsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIdentityProviderConfigsError {
    fn code(&self) -> Option<&str> {
        ListIdentityProviderConfigsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIdentityProviderConfigsError {
    /// Creates a new `ListIdentityProviderConfigsError`.
    pub fn new(kind: ListIdentityProviderConfigsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIdentityProviderConfigsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIdentityProviderConfigsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIdentityProviderConfigsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIdentityProviderConfigsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListIdentityProviderConfigsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIdentityProviderConfigsErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIdentityProviderConfigsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIdentityProviderConfigsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIdentityProviderConfigsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIdentityProviderConfigsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIdentityProviderConfigsErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIdentityProviderConfigsErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIdentityProviderConfigsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIdentityProviderConfigsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListIdentityProviderConfigsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIdentityProviderConfigsErrorKind::ClientException(_inner) => Some(_inner),
            ListIdentityProviderConfigsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListIdentityProviderConfigsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListIdentityProviderConfigsErrorKind::ServerException(_inner) => Some(_inner),
            ListIdentityProviderConfigsErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            ListIdentityProviderConfigsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListNodegroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListNodegroupsError {
    /// Kind of error that occurred.
    pub kind: ListNodegroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListNodegroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListNodegroupsErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The service is unavailable. Back off and retry the operation.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListNodegroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListNodegroupsErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListNodegroupsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListNodegroupsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListNodegroupsErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListNodegroupsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListNodegroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListNodegroupsError {
    fn code(&self) -> Option<&str> {
        ListNodegroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListNodegroupsError {
    /// Creates a new `ListNodegroupsError`.
    pub fn new(kind: ListNodegroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListNodegroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListNodegroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListNodegroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListNodegroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListNodegroupsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ListNodegroupsErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ListNodegroupsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNodegroupsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNodegroupsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNodegroupsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNodegroupsErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, ListNodegroupsErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `ListNodegroupsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNodegroupsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListNodegroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListNodegroupsErrorKind::ClientException(_inner) => Some(_inner),
            ListNodegroupsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListNodegroupsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListNodegroupsErrorKind::ServerException(_inner) => Some(_inner),
            ListNodegroupsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListNodegroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>This exception is thrown if the request contains a semantic error. The precise meaning will depend on the API, and will be documented in the error message.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUpdates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUpdatesError {
    /// Kind of error that occurred.
    pub kind: ListUpdatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUpdates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUpdatesErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUpdatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUpdatesErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListUpdatesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListUpdatesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListUpdatesErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListUpdatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUpdatesError {
    fn code(&self) -> Option<&str> {
        ListUpdatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUpdatesError {
    /// Creates a new `ListUpdatesError`.
    pub fn new(kind: ListUpdatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUpdatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUpdatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUpdatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUpdatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUpdatesErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ListUpdatesErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ListUpdatesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUpdatesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUpdatesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUpdatesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUpdatesErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, ListUpdatesErrorKind::ServerException(_))
    }
}
impl std::error::Error for ListUpdatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUpdatesErrorKind::ClientException(_inner) => Some(_inner),
            ListUpdatesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListUpdatesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListUpdatesErrorKind::ServerException(_inner) => Some(_inner),
            ListUpdatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterClusterError {
    /// Kind of error that occurred.
    pub kind: RegisterClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterClusterErrorKind {
    /// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>You have encountered a service limit on the specified resource.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>Required resources (such as service-linked roles) were created and are still propagating. Retry later.</p>
    ResourcePropagationDelayException(crate::error::ResourcePropagationDelayException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The service is unavailable. Back off and retry the operation.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterClusterErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RegisterClusterErrorKind::ClientException(_inner) => _inner.fmt(f),
            RegisterClusterErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            RegisterClusterErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            RegisterClusterErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            RegisterClusterErrorKind::ResourcePropagationDelayException(_inner) => _inner.fmt(f),
            RegisterClusterErrorKind::ServerException(_inner) => _inner.fmt(f),
            RegisterClusterErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            RegisterClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterClusterError {
    fn code(&self) -> Option<&str> {
        RegisterClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterClusterError {
    /// Creates a new `RegisterClusterError`.
    pub fn new(kind: RegisterClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterClusterErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterClusterErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterClusterErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, RegisterClusterErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `RegisterClusterErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterClusterErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterClusterErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterClusterErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterClusterErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterClusterErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterClusterErrorKind::ResourcePropagationDelayException`.
    pub fn is_resource_propagation_delay_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterClusterErrorKind::ResourcePropagationDelayException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterClusterErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, RegisterClusterErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `RegisterClusterErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterClusterErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for RegisterClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterClusterErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RegisterClusterErrorKind::ClientException(_inner) => Some(_inner),
            RegisterClusterErrorKind::InvalidParameterException(_inner) => Some(_inner),
            RegisterClusterErrorKind::ResourceInUseException(_inner) => Some(_inner),
            RegisterClusterErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            RegisterClusterErrorKind::ResourcePropagationDelayException(_inner) => Some(_inner),
            RegisterClusterErrorKind::ServerException(_inner) => Some(_inner),
            RegisterClusterErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            RegisterClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>This exception is thrown if the request contains a semantic error. The precise meaning will depend on the API, and will be documented in the error message.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>This exception is thrown if the request contains a semantic error. The precise meaning will depend on the API, and will be documented in the error message.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAddon` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAddonError {
    /// Kind of error that occurred.
    pub kind: UpdateAddonErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAddon` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAddonErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is invalid given the state of the cluster. Check the state of the cluster and the associated operations.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAddonError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAddonErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateAddonErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateAddonErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateAddonErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateAddonErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAddonErrorKind::ServerException(_inner) => _inner.fmt(f),
            UpdateAddonErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAddonError {
    fn code(&self) -> Option<&str> {
        UpdateAddonError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAddonError {
    /// Creates a new `UpdateAddonError`.
    pub fn new(kind: UpdateAddonErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAddonError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAddonErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAddonError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAddonErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAddonErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, UpdateAddonErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `UpdateAddonErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAddonErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAddonErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateAddonErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateAddonErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, UpdateAddonErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `UpdateAddonErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAddonErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAddonErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateAddonErrorKind::ServerException(_))
    }
}
impl std::error::Error for UpdateAddonError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAddonErrorKind::ClientException(_inner) => Some(_inner),
            UpdateAddonErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateAddonErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateAddonErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateAddonErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAddonErrorKind::ServerException(_inner) => Some(_inner),
            UpdateAddonErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateClusterConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateClusterConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateClusterConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateClusterConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateClusterConfigErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is invalid given the state of the cluster. Check the state of the cluster and the associated operations.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateClusterConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateClusterConfigErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateClusterConfigErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateClusterConfigErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateClusterConfigErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateClusterConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateClusterConfigErrorKind::ServerException(_inner) => _inner.fmt(f),
            UpdateClusterConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateClusterConfigError {
    fn code(&self) -> Option<&str> {
        UpdateClusterConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateClusterConfigError {
    /// Creates a new `UpdateClusterConfigError`.
    pub fn new(kind: UpdateClusterConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateClusterConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateClusterConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateClusterConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateClusterConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateClusterConfigErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, UpdateClusterConfigErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `UpdateClusterConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterConfigErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterConfigErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterConfigErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterConfigErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterConfigErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterConfigErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateClusterConfigErrorKind::ServerException(_))
    }
}
impl std::error::Error for UpdateClusterConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateClusterConfigErrorKind::ClientException(_inner) => Some(_inner),
            UpdateClusterConfigErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateClusterConfigErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateClusterConfigErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateClusterConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateClusterConfigErrorKind::ServerException(_inner) => Some(_inner),
            UpdateClusterConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateClusterVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateClusterVersionError {
    /// Kind of error that occurred.
    pub kind: UpdateClusterVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateClusterVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateClusterVersionErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is invalid given the state of the cluster. Check the state of the cluster and the associated operations.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateClusterVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateClusterVersionErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateClusterVersionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateClusterVersionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateClusterVersionErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateClusterVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateClusterVersionErrorKind::ServerException(_inner) => _inner.fmt(f),
            UpdateClusterVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateClusterVersionError {
    fn code(&self) -> Option<&str> {
        UpdateClusterVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateClusterVersionError {
    /// Creates a new `UpdateClusterVersionError`.
    pub fn new(kind: UpdateClusterVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateClusterVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateClusterVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateClusterVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateClusterVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateClusterVersionErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterVersionErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterVersionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterVersionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterVersionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterVersionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterVersionErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterVersionErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterVersionErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterVersionErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for UpdateClusterVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateClusterVersionErrorKind::ClientException(_inner) => Some(_inner),
            UpdateClusterVersionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateClusterVersionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateClusterVersionErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateClusterVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateClusterVersionErrorKind::ServerException(_inner) => Some(_inner),
            UpdateClusterVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateNodegroupConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateNodegroupConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateNodegroupConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateNodegroupConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateNodegroupConfigErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is invalid given the state of the cluster. Check the state of the cluster and the associated operations.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateNodegroupConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateNodegroupConfigErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateNodegroupConfigErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateNodegroupConfigErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateNodegroupConfigErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateNodegroupConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateNodegroupConfigErrorKind::ServerException(_inner) => _inner.fmt(f),
            UpdateNodegroupConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateNodegroupConfigError {
    fn code(&self) -> Option<&str> {
        UpdateNodegroupConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateNodegroupConfigError {
    /// Creates a new `UpdateNodegroupConfigError`.
    pub fn new(kind: UpdateNodegroupConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateNodegroupConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateNodegroupConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateNodegroupConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateNodegroupConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateNodegroupConfigErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNodegroupConfigErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNodegroupConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNodegroupConfigErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNodegroupConfigErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNodegroupConfigErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNodegroupConfigErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNodegroupConfigErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNodegroupConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNodegroupConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNodegroupConfigErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNodegroupConfigErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for UpdateNodegroupConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateNodegroupConfigErrorKind::ClientException(_inner) => Some(_inner),
            UpdateNodegroupConfigErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateNodegroupConfigErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateNodegroupConfigErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateNodegroupConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateNodegroupConfigErrorKind::ServerException(_inner) => Some(_inner),
            UpdateNodegroupConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateNodegroupVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateNodegroupVersionError {
    /// Kind of error that occurred.
    pub kind: UpdateNodegroupVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateNodegroupVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateNodegroupVersionErrorKind {
    /// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is invalid given the state of the cluster. Check the state of the cluster and the associated operations.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateNodegroupVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateNodegroupVersionErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateNodegroupVersionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateNodegroupVersionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateNodegroupVersionErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateNodegroupVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateNodegroupVersionErrorKind::ServerException(_inner) => _inner.fmt(f),
            UpdateNodegroupVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateNodegroupVersionError {
    fn code(&self) -> Option<&str> {
        UpdateNodegroupVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateNodegroupVersionError {
    /// Creates a new `UpdateNodegroupVersionError`.
    pub fn new(kind: UpdateNodegroupVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateNodegroupVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateNodegroupVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateNodegroupVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateNodegroupVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateNodegroupVersionErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNodegroupVersionErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNodegroupVersionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNodegroupVersionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNodegroupVersionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNodegroupVersionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNodegroupVersionErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNodegroupVersionErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNodegroupVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNodegroupVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNodegroupVersionErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNodegroupVersionErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for UpdateNodegroupVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateNodegroupVersionErrorKind::ClientException(_inner) => Some(_inner),
            UpdateNodegroupVersionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateNodegroupVersionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateNodegroupVersionErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateNodegroupVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateNodegroupVersionErrorKind::ServerException(_inner) => Some(_inner),
            UpdateNodegroupVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>These errors are usually caused by a server-side issue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerException {
    /// <p>The Amazon EKS cluster associated with the exception.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The Amazon EKS managed node group associated with the exception.</p>
    pub nodegroup_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub addon_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl ServerException {
    /// <p>The Amazon EKS cluster associated with the exception.</p>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
    /// <p>The Amazon EKS managed node group associated with the exception.</p>
    pub fn nodegroup_name(&self) -> std::option::Option<&str> {
        self.nodegroup_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn addon_name(&self) -> std::option::Option<&str> {
        self.addon_name.as_deref()
    }
}
impl std::fmt::Debug for ServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerException");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("nodegroup_name", &self.nodegroup_name);
        formatter.field("addon_name", &self.addon_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServerException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServerException {}
/// See [`ServerException`](crate::error::ServerException)
pub mod server_exception {
    /// A builder for [`ServerException`](crate::error::ServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) nodegroup_name: std::option::Option<std::string::String>,
        pub(crate) addon_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon EKS cluster associated with the exception.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The Amazon EKS cluster associated with the exception.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The Amazon EKS managed node group associated with the exception.</p>
        pub fn nodegroup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.nodegroup_name = Some(input.into());
            self
        }
        /// <p>The Amazon EKS managed node group associated with the exception.</p>
        pub fn set_nodegroup_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nodegroup_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn addon_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.addon_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_addon_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.addon_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerException`](crate::error::ServerException)
        pub fn build(self) -> crate::error::ServerException {
            crate::error::ServerException {
                cluster_name: self.cluster_name,
                nodegroup_name: self.nodegroup_name,
                addon_name: self.addon_name,
                message: self.message,
            }
        }
    }
}
impl ServerException {
    /// Creates a new builder-style object to manufacture [`ServerException`](crate::error::ServerException)
    pub fn builder() -> crate::error::server_exception::Builder {
        crate::error::server_exception::Builder::default()
    }
}

/// <p>The specified resource could not be found. You can view your available clusters with <code>ListClusters</code>. You can view your available managed node groups with <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Region-specific.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>The Amazon EKS cluster associated with the exception.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The Amazon EKS managed node group associated with the exception.</p>
    pub nodegroup_name: std::option::Option<std::string::String>,
    /// <p>The Fargate profile associated with the exception.</p>
    pub fargate_profile_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub addon_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// <p>The Amazon EKS cluster associated with the exception.</p>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
    /// <p>The Amazon EKS managed node group associated with the exception.</p>
    pub fn nodegroup_name(&self) -> std::option::Option<&str> {
        self.nodegroup_name.as_deref()
    }
    /// <p>The Fargate profile associated with the exception.</p>
    pub fn fargate_profile_name(&self) -> std::option::Option<&str> {
        self.fargate_profile_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn addon_name(&self) -> std::option::Option<&str> {
        self.addon_name.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("nodegroup_name", &self.nodegroup_name);
        formatter.field("fargate_profile_name", &self.fargate_profile_name);
        formatter.field("addon_name", &self.addon_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) nodegroup_name: std::option::Option<std::string::String>,
        pub(crate) fargate_profile_name: std::option::Option<std::string::String>,
        pub(crate) addon_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon EKS cluster associated with the exception.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The Amazon EKS cluster associated with the exception.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The Amazon EKS managed node group associated with the exception.</p>
        pub fn nodegroup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.nodegroup_name = Some(input.into());
            self
        }
        /// <p>The Amazon EKS managed node group associated with the exception.</p>
        pub fn set_nodegroup_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nodegroup_name = input;
            self
        }
        /// <p>The Fargate profile associated with the exception.</p>
        pub fn fargate_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.fargate_profile_name = Some(input.into());
            self
        }
        /// <p>The Fargate profile associated with the exception.</p>
        pub fn set_fargate_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.fargate_profile_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn addon_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.addon_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_addon_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.addon_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                cluster_name: self.cluster_name,
                nodegroup_name: self.nodegroup_name,
                fargate_profile_name: self.fargate_profile_name,
                addon_name: self.addon_name,
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The specified resource is in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    /// <p>The Amazon EKS cluster associated with the exception.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The Amazon EKS managed node group associated with the exception.</p>
    pub nodegroup_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub addon_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl ResourceInUseException {
    /// <p>The Amazon EKS cluster associated with the exception.</p>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
    /// <p>The Amazon EKS managed node group associated with the exception.</p>
    pub fn nodegroup_name(&self) -> std::option::Option<&str> {
        self.nodegroup_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn addon_name(&self) -> std::option::Option<&str> {
        self.addon_name.as_deref()
    }
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("nodegroup_name", &self.nodegroup_name);
        formatter.field("addon_name", &self.addon_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) nodegroup_name: std::option::Option<std::string::String>,
        pub(crate) addon_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon EKS cluster associated with the exception.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The Amazon EKS cluster associated with the exception.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The Amazon EKS managed node group associated with the exception.</p>
        pub fn nodegroup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.nodegroup_name = Some(input.into());
            self
        }
        /// <p>The Amazon EKS managed node group associated with the exception.</p>
        pub fn set_nodegroup_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nodegroup_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn addon_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.addon_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_addon_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.addon_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                cluster_name: self.cluster_name,
                nodegroup_name: self.nodegroup_name,
                addon_name: self.addon_name,
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>The request is invalid given the state of the cluster. Check the state of the cluster and the associated operations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    /// <p>The Amazon EKS cluster associated with the exception.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The Amazon EKS managed node group associated with the exception.</p>
    pub nodegroup_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub addon_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl InvalidRequestException {
    /// <p>The Amazon EKS cluster associated with the exception.</p>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
    /// <p>The Amazon EKS managed node group associated with the exception.</p>
    pub fn nodegroup_name(&self) -> std::option::Option<&str> {
        self.nodegroup_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn addon_name(&self) -> std::option::Option<&str> {
        self.addon_name.as_deref()
    }
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("nodegroup_name", &self.nodegroup_name);
        formatter.field("addon_name", &self.addon_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) nodegroup_name: std::option::Option<std::string::String>,
        pub(crate) addon_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon EKS cluster associated with the exception.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The Amazon EKS cluster associated with the exception.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The Amazon EKS managed node group associated with the exception.</p>
        pub fn nodegroup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.nodegroup_name = Some(input.into());
            self
        }
        /// <p>The Amazon EKS managed node group associated with the exception.</p>
        pub fn set_nodegroup_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nodegroup_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn addon_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.addon_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_addon_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.addon_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                cluster_name: self.cluster_name,
                nodegroup_name: self.nodegroup_name,
                addon_name: self.addon_name,
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterException {
    /// <p>The Amazon EKS cluster associated with the exception.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The Amazon EKS managed node group associated with the exception.</p>
    pub nodegroup_name: std::option::Option<std::string::String>,
    /// <p>The Fargate profile associated with the exception.</p>
    pub fargate_profile_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub addon_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl InvalidParameterException {
    /// <p>The Amazon EKS cluster associated with the exception.</p>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
    /// <p>The Amazon EKS managed node group associated with the exception.</p>
    pub fn nodegroup_name(&self) -> std::option::Option<&str> {
        self.nodegroup_name.as_deref()
    }
    /// <p>The Fargate profile associated with the exception.</p>
    pub fn fargate_profile_name(&self) -> std::option::Option<&str> {
        self.fargate_profile_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn addon_name(&self) -> std::option::Option<&str> {
        self.addon_name.as_deref()
    }
}
impl std::fmt::Debug for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterException");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("nodegroup_name", &self.nodegroup_name);
        formatter.field("fargate_profile_name", &self.fargate_profile_name);
        formatter.field("addon_name", &self.addon_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterException {}
/// See [`InvalidParameterException`](crate::error::InvalidParameterException)
pub mod invalid_parameter_exception {
    /// A builder for [`InvalidParameterException`](crate::error::InvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) nodegroup_name: std::option::Option<std::string::String>,
        pub(crate) fargate_profile_name: std::option::Option<std::string::String>,
        pub(crate) addon_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon EKS cluster associated with the exception.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The Amazon EKS cluster associated with the exception.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The Amazon EKS managed node group associated with the exception.</p>
        pub fn nodegroup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.nodegroup_name = Some(input.into());
            self
        }
        /// <p>The Amazon EKS managed node group associated with the exception.</p>
        pub fn set_nodegroup_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nodegroup_name = input;
            self
        }
        /// <p>The Fargate profile associated with the exception.</p>
        pub fn fargate_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.fargate_profile_name = Some(input.into());
            self
        }
        /// <p>The Fargate profile associated with the exception.</p>
        pub fn set_fargate_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.fargate_profile_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn addon_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.addon_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_addon_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.addon_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterException`](crate::error::InvalidParameterException)
        pub fn build(self) -> crate::error::InvalidParameterException {
            crate::error::InvalidParameterException {
                cluster_name: self.cluster_name,
                nodegroup_name: self.nodegroup_name,
                fargate_profile_name: self.fargate_profile_name,
                addon_name: self.addon_name,
                message: self.message,
            }
        }
    }
}
impl InvalidParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterException`](crate::error::InvalidParameterException)
    pub fn builder() -> crate::error::invalid_parameter_exception::Builder {
        crate::error::invalid_parameter_exception::Builder::default()
    }
}

/// <p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn't have permissions to use the action or resource or specifying an identifier that is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClientException {
    /// <p>The Amazon EKS cluster associated with the exception.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The Amazon EKS managed node group associated with the exception.</p>
    pub nodegroup_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub addon_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl ClientException {
    /// <p>The Amazon EKS cluster associated with the exception.</p>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
    /// <p>The Amazon EKS managed node group associated with the exception.</p>
    pub fn nodegroup_name(&self) -> std::option::Option<&str> {
        self.nodegroup_name.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn addon_name(&self) -> std::option::Option<&str> {
        self.addon_name.as_deref()
    }
}
impl std::fmt::Debug for ClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClientException");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("nodegroup_name", &self.nodegroup_name);
        formatter.field("addon_name", &self.addon_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClientException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClientException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClientException {}
/// See [`ClientException`](crate::error::ClientException)
pub mod client_exception {
    /// A builder for [`ClientException`](crate::error::ClientException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) nodegroup_name: std::option::Option<std::string::String>,
        pub(crate) addon_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon EKS cluster associated with the exception.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The Amazon EKS cluster associated with the exception.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The Amazon EKS managed node group associated with the exception.</p>
        pub fn nodegroup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.nodegroup_name = Some(input.into());
            self
        }
        /// <p>The Amazon EKS managed node group associated with the exception.</p>
        pub fn set_nodegroup_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nodegroup_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn addon_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.addon_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_addon_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.addon_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClientException`](crate::error::ClientException)
        pub fn build(self) -> crate::error::ClientException {
            crate::error::ClientException {
                cluster_name: self.cluster_name,
                nodegroup_name: self.nodegroup_name,
                addon_name: self.addon_name,
                message: self.message,
            }
        }
    }
}
impl ClientException {
    /// Creates a new builder-style object to manufacture [`ClientException`](crate::error::ClientException)
    pub fn builder() -> crate::error::client_exception::Builder {
        crate::error::client_exception::Builder::default()
    }
}

/// <p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>This exception is thrown if the request contains a semantic error. The precise meaning will depend on the API, and will be documented in the error message.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>The service is unavailable. Back off and retry the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// <p>Required resources (such as service-linked roles) were created and are still propagating. Retry later.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourcePropagationDelayException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourcePropagationDelayException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourcePropagationDelayException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourcePropagationDelayException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourcePropagationDelayException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourcePropagationDelayException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourcePropagationDelayException {}
/// See [`ResourcePropagationDelayException`](crate::error::ResourcePropagationDelayException)
pub mod resource_propagation_delay_exception {
    /// A builder for [`ResourcePropagationDelayException`](crate::error::ResourcePropagationDelayException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourcePropagationDelayException`](crate::error::ResourcePropagationDelayException)
        pub fn build(self) -> crate::error::ResourcePropagationDelayException {
            crate::error::ResourcePropagationDelayException {
                message: self.message,
            }
        }
    }
}
impl ResourcePropagationDelayException {
    /// Creates a new builder-style object to manufacture [`ResourcePropagationDelayException`](crate::error::ResourcePropagationDelayException)
    pub fn builder() -> crate::error::resource_propagation_delay_exception::Builder {
        crate::error::resource_propagation_delay_exception::Builder::default()
    }
}

/// <p>You have encountered a service limit on the specified resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceLimitExceededException {
    /// <p>The Amazon EKS cluster associated with the exception.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The Amazon EKS managed node group associated with the exception.</p>
    pub nodegroup_name: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl ResourceLimitExceededException {
    /// <p>The Amazon EKS cluster associated with the exception.</p>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
    /// <p>The Amazon EKS managed node group associated with the exception.</p>
    pub fn nodegroup_name(&self) -> std::option::Option<&str> {
        self.nodegroup_name.as_deref()
    }
}
impl std::fmt::Debug for ResourceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceLimitExceededException");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("nodegroup_name", &self.nodegroup_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceLimitExceededException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceLimitExceededException {}
/// See [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
pub mod resource_limit_exceeded_exception {
    /// A builder for [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) nodegroup_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon EKS cluster associated with the exception.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The Amazon EKS cluster associated with the exception.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The Amazon EKS managed node group associated with the exception.</p>
        pub fn nodegroup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.nodegroup_name = Some(input.into());
            self
        }
        /// <p>The Amazon EKS managed node group associated with the exception.</p>
        pub fn set_nodegroup_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nodegroup_name = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
        pub fn build(self) -> crate::error::ResourceLimitExceededException {
            crate::error::ResourceLimitExceededException {
                cluster_name: self.cluster_name,
                nodegroup_name: self.nodegroup_name,
                message: self.message,
            }
        }
    }
}
impl ResourceLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
    pub fn builder() -> crate::error::resource_limit_exceeded_exception::Builder {
        crate::error::resource_limit_exceeded_exception::Builder::default()
    }
}

/// <p>You don't have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>At least one of your specified cluster subnets is in an Availability Zone that does not support Amazon EKS. The exception output specifies the supported Availability Zones for your account, from which you can choose subnets for your cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedAvailabilityZoneException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon EKS cluster associated with the exception.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The Amazon EKS managed node group associated with the exception.</p>
    pub nodegroup_name: std::option::Option<std::string::String>,
    /// <p>The supported Availability Zones for your account. Choose subnets in these Availability Zones for your cluster.</p>
    pub valid_zones: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UnsupportedAvailabilityZoneException {
    /// <p>The Amazon EKS cluster associated with the exception.</p>
    pub fn cluster_name(&self) -> std::option::Option<&str> {
        self.cluster_name.as_deref()
    }
    /// <p>The Amazon EKS managed node group associated with the exception.</p>
    pub fn nodegroup_name(&self) -> std::option::Option<&str> {
        self.nodegroup_name.as_deref()
    }
    /// <p>The supported Availability Zones for your account. Choose subnets in these Availability Zones for your cluster.</p>
    pub fn valid_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.valid_zones.as_deref()
    }
}
impl std::fmt::Debug for UnsupportedAvailabilityZoneException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedAvailabilityZoneException");
        formatter.field("message", &self.message);
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("nodegroup_name", &self.nodegroup_name);
        formatter.field("valid_zones", &self.valid_zones);
        formatter.finish()
    }
}
impl UnsupportedAvailabilityZoneException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedAvailabilityZoneException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedAvailabilityZoneException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedAvailabilityZoneException {}
/// See [`UnsupportedAvailabilityZoneException`](crate::error::UnsupportedAvailabilityZoneException)
pub mod unsupported_availability_zone_exception {
    /// A builder for [`UnsupportedAvailabilityZoneException`](crate::error::UnsupportedAvailabilityZoneException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) nodegroup_name: std::option::Option<std::string::String>,
        pub(crate) valid_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The Amazon EKS cluster associated with the exception.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The Amazon EKS cluster associated with the exception.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The Amazon EKS managed node group associated with the exception.</p>
        pub fn nodegroup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.nodegroup_name = Some(input.into());
            self
        }
        /// <p>The Amazon EKS managed node group associated with the exception.</p>
        pub fn set_nodegroup_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nodegroup_name = input;
            self
        }
        /// Appends an item to `valid_zones`.
        ///
        /// To override the contents of this collection use [`set_valid_zones`](Self::set_valid_zones).
        ///
        /// <p>The supported Availability Zones for your account. Choose subnets in these Availability Zones for your cluster.</p>
        pub fn valid_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.valid_zones.unwrap_or_default();
            v.push(input.into());
            self.valid_zones = Some(v);
            self
        }
        /// <p>The supported Availability Zones for your account. Choose subnets in these Availability Zones for your cluster.</p>
        pub fn set_valid_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.valid_zones = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedAvailabilityZoneException`](crate::error::UnsupportedAvailabilityZoneException)
        pub fn build(self) -> crate::error::UnsupportedAvailabilityZoneException {
            crate::error::UnsupportedAvailabilityZoneException {
                message: self.message,
                cluster_name: self.cluster_name,
                nodegroup_name: self.nodegroup_name,
                valid_zones: self.valid_zones,
            }
        }
    }
}
impl UnsupportedAvailabilityZoneException {
    /// Creates a new builder-style object to manufacture [`UnsupportedAvailabilityZoneException`](crate::error::UnsupportedAvailabilityZoneException)
    pub fn builder() -> crate::error::unsupported_availability_zone_exception::Builder {
        crate::error::unsupported_availability_zone_exception::Builder::default()
    }
}
