// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Elastic Kubernetes Service
///
/// Client for invoking operations on Amazon Elastic Kubernetes Service. Each operation on Amazon Elastic Kubernetes Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_eks::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_eks::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_eks::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateEncryptionConfig`](crate::client::fluent_builders::AssociateEncryptionConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::AssociateEncryptionConfig::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::AssociateEncryptionConfig::set_cluster_name): <p>The name of the cluster that you are associating with encryption configuration.</p>
    ///   - [`encryption_config(Vec<EncryptionConfig>)`](crate::client::fluent_builders::AssociateEncryptionConfig::encryption_config) / [`set_encryption_config(Option<Vec<EncryptionConfig>>)`](crate::client::fluent_builders::AssociateEncryptionConfig::set_encryption_config): <p>The configuration you are using for encryption.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::AssociateEncryptionConfig::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::AssociateEncryptionConfig::set_client_request_token): <p>The client request token you are using with the encryption configuration.</p>
    /// - On success, responds with [`AssociateEncryptionConfigOutput`](crate::output::AssociateEncryptionConfigOutput) with field(s):
    ///   - [`update(Option<Update>)`](crate::output::AssociateEncryptionConfigOutput::update): <p>An object representing an asynchronous update.</p>
    /// - On failure, responds with [`SdkError<AssociateEncryptionConfigError>`](crate::error::AssociateEncryptionConfigError)
    pub fn associate_encryption_config(&self) -> fluent_builders::AssociateEncryptionConfig {
        fluent_builders::AssociateEncryptionConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateIdentityProviderConfig`](crate::client::fluent_builders::AssociateIdentityProviderConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::AssociateIdentityProviderConfig::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::AssociateIdentityProviderConfig::set_cluster_name): <p>The name of the cluster to associate the configuration to.</p>
    ///   - [`oidc(OidcIdentityProviderConfigRequest)`](crate::client::fluent_builders::AssociateIdentityProviderConfig::oidc) / [`set_oidc(Option<OidcIdentityProviderConfigRequest>)`](crate::client::fluent_builders::AssociateIdentityProviderConfig::set_oidc): <p>An object that represents an OpenID Connect (OIDC) identity provider configuration.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::AssociateIdentityProviderConfig::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::AssociateIdentityProviderConfig::set_tags): <p>The metadata to apply to the configuration to assist with categorization and organization. Each tag consists of a key and an optional value. You define both.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::AssociateIdentityProviderConfig::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::AssociateIdentityProviderConfig::set_client_request_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`AssociateIdentityProviderConfigOutput`](crate::output::AssociateIdentityProviderConfigOutput) with field(s):
    ///   - [`update(Option<Update>)`](crate::output::AssociateIdentityProviderConfigOutput::update): <p>An object representing an asynchronous update.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::AssociateIdentityProviderConfigOutput::tags): <p>The tags for the resource.</p>
    /// - On failure, responds with [`SdkError<AssociateIdentityProviderConfigError>`](crate::error::AssociateIdentityProviderConfigError)
    pub fn associate_identity_provider_config(
        &self,
    ) -> fluent_builders::AssociateIdentityProviderConfig {
        fluent_builders::AssociateIdentityProviderConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAddon`](crate::client::fluent_builders::CreateAddon) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::CreateAddon::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::CreateAddon::set_cluster_name): <p>The name of the cluster to create the add-on for.</p>
    ///   - [`addon_name(impl Into<String>)`](crate::client::fluent_builders::CreateAddon::addon_name) / [`set_addon_name(Option<String>)`](crate::client::fluent_builders::CreateAddon::set_addon_name): <p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html"> <code>DescribeAddonVersions</code> </a>.</p>
    ///   - [`addon_version(impl Into<String>)`](crate::client::fluent_builders::CreateAddon::addon_version) / [`set_addon_version(Option<String>)`](crate::client::fluent_builders::CreateAddon::set_addon_version): <p>The version of the add-on. The version must match one of the versions returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html"> <code>DescribeAddonVersions</code> </a>.</p>
    ///   - [`service_account_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateAddon::service_account_role_arn) / [`set_service_account_role_arn(Option<String>)`](crate::client::fluent_builders::CreateAddon::set_service_account_role_arn): <p>The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM role</a> in the <i>Amazon EKS User Guide</i>.</p> <note>   <p>To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html">Enabling IAM roles for service accounts on your cluster</a> in the <i>Amazon EKS User Guide</i>.</p>  </note>
    ///   - [`resolve_conflicts(ResolveConflicts)`](crate::client::fluent_builders::CreateAddon::resolve_conflicts) / [`set_resolve_conflicts(Option<ResolveConflicts>)`](crate::client::fluent_builders::CreateAddon::set_resolve_conflicts): <p>How to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateAddon::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateAddon::set_client_request_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateAddon::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateAddon::set_tags): <p>The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value. You define both.</p>
    /// - On success, responds with [`CreateAddonOutput`](crate::output::CreateAddonOutput) with field(s):
    ///   - [`addon(Option<Addon>)`](crate::output::CreateAddonOutput::addon): <p>An Amazon EKS add-on. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html">Amazon EKS add-ons</a> in the <i>Amazon EKS User Guide</i>.</p>
    /// - On failure, responds with [`SdkError<CreateAddonError>`](crate::error::CreateAddonError)
    pub fn create_addon(&self) -> fluent_builders::CreateAddon {
        fluent_builders::CreateAddon::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCluster`](crate::client::fluent_builders::CreateCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_name): <p>The unique name to give to your cluster.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_version): <p>The desired Kubernetes version for your cluster. If you don't specify a value here, the latest version available in Amazon EKS is used.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to Amazon Web Services API operations on your behalf. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html">Amazon EKS Service IAM Role</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>
    ///   - [`resources_vpc_config(VpcConfigRequest)`](crate::client::fluent_builders::CreateCluster::resources_vpc_config) / [`set_resources_vpc_config(Option<VpcConfigRequest>)`](crate::client::fluent_builders::CreateCluster::set_resources_vpc_config): <p>The VPC configuration that's used by the cluster control plane. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group Considerations</a> in the <i>Amazon EKS User Guide</i>. You must specify at least two subnets. You can specify up to five security groups. However, we recommend that you use a dedicated security group for your cluster control plane.</p>
    ///   - [`kubernetes_network_config(KubernetesNetworkConfigRequest)`](crate::client::fluent_builders::CreateCluster::kubernetes_network_config) / [`set_kubernetes_network_config(Option<KubernetesNetworkConfigRequest>)`](crate::client::fluent_builders::CreateCluster::set_kubernetes_network_config): <p>The Kubernetes network configuration for the cluster.</p>
    ///   - [`logging(Logging)`](crate::client::fluent_builders::CreateCluster::logging) / [`set_logging(Option<Logging>)`](crate::client::fluent_builders::CreateCluster::set_logging): <p>Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster control plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note>   <p>CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.</p>  </note>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_client_request_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateCluster::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateCluster::set_tags): <p>The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value. You define both.</p>
    ///   - [`encryption_config(Vec<EncryptionConfig>)`](crate::client::fluent_builders::CreateCluster::encryption_config) / [`set_encryption_config(Option<Vec<EncryptionConfig>>)`](crate::client::fluent_builders::CreateCluster::set_encryption_config): <p>The encryption configuration for the cluster.</p>
    /// - On success, responds with [`CreateClusterOutput`](crate::output::CreateClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::CreateClusterOutput::cluster): <p>The full description of your new cluster.</p>
    /// - On failure, responds with [`SdkError<CreateClusterError>`](crate::error::CreateClusterError)
    pub fn create_cluster(&self) -> fluent_builders::CreateCluster {
        fluent_builders::CreateCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFargateProfile`](crate::client::fluent_builders::CreateFargateProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fargate_profile_name(impl Into<String>)`](crate::client::fluent_builders::CreateFargateProfile::fargate_profile_name) / [`set_fargate_profile_name(Option<String>)`](crate::client::fluent_builders::CreateFargateProfile::set_fargate_profile_name): <p>The name of the Fargate profile.</p>
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::CreateFargateProfile::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::CreateFargateProfile::set_cluster_name): <p>The name of the Amazon EKS cluster to apply the Fargate profile to.</p>
    ///   - [`pod_execution_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateFargateProfile::pod_execution_role_arn) / [`set_pod_execution_role_arn(Option<String>)`](crate::client::fluent_builders::CreateFargateProfile::set_pod_execution_role_arn): <p>The Amazon Resource Name (ARN) of the pod execution role to use for pods that match the selectors in the Fargate profile. The pod execution role allows Fargate infrastructure to register with your cluster as a node, and it provides read access to Amazon ECR image repositories. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html">Pod Execution Role</a> in the <i>Amazon EKS User Guide</i>.</p>
    ///   - [`subnets(Vec<String>)`](crate::client::fluent_builders::CreateFargateProfile::subnets) / [`set_subnets(Option<Vec<String>>)`](crate::client::fluent_builders::CreateFargateProfile::set_subnets): <p>The IDs of subnets to launch your pods into. At this time, pods running on Fargate are not assigned public IP addresses, so only private subnets (with no direct route to an Internet Gateway) are accepted for this parameter.</p>
    ///   - [`selectors(Vec<FargateProfileSelector>)`](crate::client::fluent_builders::CreateFargateProfile::selectors) / [`set_selectors(Option<Vec<FargateProfileSelector>>)`](crate::client::fluent_builders::CreateFargateProfile::set_selectors): <p>The selectors to match for pods to use this Fargate profile. Each selector must have an associated namespace. Optionally, you can also specify labels for a namespace. You may specify up to five selectors in a Fargate profile.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateFargateProfile::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateFargateProfile::set_client_request_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateFargateProfile::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateFargateProfile::set_tags): <p>The metadata to apply to the Fargate profile to assist with categorization and organization. Each tag consists of a key and an optional value. You define both. Fargate profile tags do not propagate to any other resources associated with the Fargate profile, such as the pods that are scheduled with it.</p>
    /// - On success, responds with [`CreateFargateProfileOutput`](crate::output::CreateFargateProfileOutput) with field(s):
    ///   - [`fargate_profile(Option<FargateProfile>)`](crate::output::CreateFargateProfileOutput::fargate_profile): <p>The full description of your new Fargate profile.</p>
    /// - On failure, responds with [`SdkError<CreateFargateProfileError>`](crate::error::CreateFargateProfileError)
    pub fn create_fargate_profile(&self) -> fluent_builders::CreateFargateProfile {
        fluent_builders::CreateFargateProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateNodegroup`](crate::client::fluent_builders::CreateNodegroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::CreateNodegroup::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::CreateNodegroup::set_cluster_name): <p>The name of the cluster to create the node group in.</p>
    ///   - [`nodegroup_name(impl Into<String>)`](crate::client::fluent_builders::CreateNodegroup::nodegroup_name) / [`set_nodegroup_name(Option<String>)`](crate::client::fluent_builders::CreateNodegroup::set_nodegroup_name): <p>The unique name to give your node group.</p>
    ///   - [`scaling_config(NodegroupScalingConfig)`](crate::client::fluent_builders::CreateNodegroup::scaling_config) / [`set_scaling_config(Option<NodegroupScalingConfig>)`](crate::client::fluent_builders::CreateNodegroup::set_scaling_config): <p>The scaling configuration details for the Auto Scaling group that is created for your node group.</p>
    ///   - [`disk_size(i32)`](crate::client::fluent_builders::CreateNodegroup::disk_size) / [`set_disk_size(Option<i32>)`](crate::client::fluent_builders::CreateNodegroup::set_disk_size): <p>The root device disk size (in GiB) for your node group instances. The default disk size is 20 GiB. If you specify <code>launchTemplate</code>, then don't specify <code>diskSize</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
    ///   - [`subnets(Vec<String>)`](crate::client::fluent_builders::CreateNodegroup::subnets) / [`set_subnets(Option<Vec<String>>)`](crate::client::fluent_builders::CreateNodegroup::set_subnets): <p>The subnets to use for the Auto Scaling group that is created for your node group. If you specify <code>launchTemplate</code>, then don't specify <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html"> <code>SubnetId</code> </a> in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
    ///   - [`instance_types(Vec<String>)`](crate::client::fluent_builders::CreateNodegroup::instance_types) / [`set_instance_types(Option<Vec<String>>)`](crate::client::fluent_builders::CreateNodegroup::set_instance_types): <p>Specify the instance types for a node group. If you specify a GPU instance type, be sure to specify <code>AL2_x86_64_GPU</code> with the <code>amiType</code> parameter. If you specify <code>launchTemplate</code>, then you can specify zero or one instance type in your launch template <i>or</i> you can specify 0-20 instance types for <code>instanceTypes</code>. If however, you specify an instance type in your launch template <i>and</i> specify any <code>instanceTypes</code>, the node group deployment will fail. If you don't specify an instance type in a launch template or for <code>instanceTypes</code>, then <code>t3.medium</code> is used, by default. If you specify <code>Spot</code> for <code>capacityType</code>, then we recommend specifying multiple values for <code>instanceTypes</code>. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types">Managed node group capacity types</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the <i>Amazon EKS User Guide</i>.</p>
    ///   - [`ami_type(AmiTypes)`](crate::client::fluent_builders::CreateNodegroup::ami_type) / [`set_ami_type(Option<AmiTypes>)`](crate::client::fluent_builders::CreateNodegroup::set_ami_type): <p>The AMI type for your node group. GPU instance types should use the <code>AL2_x86_64_GPU</code> AMI type. Non-GPU instances should use the <code>AL2_x86_64</code> AMI type. Arm instances should use the <code>AL2_ARM_64</code> AMI type. All types use the Amazon EKS optimized Amazon Linux 2 AMI. If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify <code>amiType</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
    ///   - [`remote_access(RemoteAccessConfig)`](crate::client::fluent_builders::CreateNodegroup::remote_access) / [`set_remote_access(Option<RemoteAccessConfig>)`](crate::client::fluent_builders::CreateNodegroup::set_remote_access): <p>The remote access (SSH) configuration to use with your node group. If you specify <code>launchTemplate</code>, then don't specify <code>remoteAccess</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
    ///   - [`node_role(impl Into<String>)`](crate::client::fluent_builders::CreateNodegroup::node_role) / [`set_node_role(Option<String>)`](crate::client::fluent_builders::CreateNodegroup::set_node_role): <p>The Amazon Resource Name (ARN) of the IAM role to associate with your node group. The Amazon EKS worker node <code>kubelet</code> daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive permissions for these API calls through an IAM instance profile and associated policies. Before you can launch nodes and register them into a cluster, you must create an IAM role for those nodes to use when they are launched. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html">Amazon EKS node IAM role</a> in the <i> <i>Amazon EKS User Guide</i> </i>. If you specify <code>launchTemplate</code>, then don't specify <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html"> <code>IamInstanceProfile</code> </a> in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
    ///   - [`labels(HashMap<String, String>)`](crate::client::fluent_builders::CreateNodegroup::labels) / [`set_labels(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateNodegroup::set_labels): <p>The Kubernetes labels to be applied to the nodes in the node group when they are created.</p>
    ///   - [`taints(Vec<Taint>)`](crate::client::fluent_builders::CreateNodegroup::taints) / [`set_taints(Option<Vec<Taint>>)`](crate::client::fluent_builders::CreateNodegroup::set_taints): <p>The Kubernetes taints to be applied to the nodes in the node group.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateNodegroup::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateNodegroup::set_tags): <p>The metadata to apply to the node group to assist with categorization and organization. Each tag consists of a key and an optional value. You define both. Node group tags do not propagate to any other resources associated with the node group, such as the Amazon EC2 instances or subnets.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateNodegroup::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateNodegroup::set_client_request_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`launch_template(LaunchTemplateSpecification)`](crate::client::fluent_builders::CreateNodegroup::launch_template) / [`set_launch_template(Option<LaunchTemplateSpecification>)`](crate::client::fluent_builders::CreateNodegroup::set_launch_template): <p>An object representing a node group's launch template specification. If specified, then do not specify <code>instanceTypes</code>, <code>diskSize</code>, or <code>remoteAccess</code> and make sure that the launch template meets the requirements in <code>launchTemplateSpecification</code>.</p>
    ///   - [`update_config(NodegroupUpdateConfig)`](crate::client::fluent_builders::CreateNodegroup::update_config) / [`set_update_config(Option<NodegroupUpdateConfig>)`](crate::client::fluent_builders::CreateNodegroup::set_update_config): <p>The node group update configuration.</p>
    ///   - [`capacity_type(CapacityTypes)`](crate::client::fluent_builders::CreateNodegroup::capacity_type) / [`set_capacity_type(Option<CapacityTypes>)`](crate::client::fluent_builders::CreateNodegroup::set_capacity_type): <p>The capacity type for your node group.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::CreateNodegroup::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::CreateNodegroup::set_version): <p>The Kubernetes version to use for your managed nodes. By default, the Kubernetes version of the cluster is used, and this is the only accepted specified value. If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify <code>version</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
    ///   - [`release_version(impl Into<String>)`](crate::client::fluent_builders::CreateNodegroup::release_version) / [`set_release_version(Option<String>)`](crate::client::fluent_builders::CreateNodegroup::set_release_version): <p>The AMI version of the Amazon EKS optimized AMI to use with your node group. By default, the latest available AMI version for the node group's current Kubernetes version is used. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized Amazon Linux 2 AMI versions</a> in the <i>Amazon EKS User Guide</i>. If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify <code>releaseVersion</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
    /// - On success, responds with [`CreateNodegroupOutput`](crate::output::CreateNodegroupOutput) with field(s):
    ///   - [`nodegroup(Option<Nodegroup>)`](crate::output::CreateNodegroupOutput::nodegroup): <p>The full description of your new node group.</p>
    /// - On failure, responds with [`SdkError<CreateNodegroupError>`](crate::error::CreateNodegroupError)
    pub fn create_nodegroup(&self) -> fluent_builders::CreateNodegroup {
        fluent_builders::CreateNodegroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAddon`](crate::client::fluent_builders::DeleteAddon) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::DeleteAddon::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::DeleteAddon::set_cluster_name): <p>The name of the cluster to delete the add-on from.</p>
    ///   - [`addon_name(impl Into<String>)`](crate::client::fluent_builders::DeleteAddon::addon_name) / [`set_addon_name(Option<String>)`](crate::client::fluent_builders::DeleteAddon::set_addon_name): <p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>
    ///   - [`preserve(bool)`](crate::client::fluent_builders::DeleteAddon::preserve) / [`set_preserve(bool)`](crate::client::fluent_builders::DeleteAddon::set_preserve): <p>Specifying this option preserves the add-on software on your cluster but Amazon EKS stops managing any settings for the add-on. If an IAM account is associated with the add-on, it is not removed.</p>
    /// - On success, responds with [`DeleteAddonOutput`](crate::output::DeleteAddonOutput) with field(s):
    ///   - [`addon(Option<Addon>)`](crate::output::DeleteAddonOutput::addon): <p>An Amazon EKS add-on. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html">Amazon EKS add-ons</a> in the <i>Amazon EKS User Guide</i>.</p>
    /// - On failure, responds with [`SdkError<DeleteAddonError>`](crate::error::DeleteAddonError)
    pub fn delete_addon(&self) -> fluent_builders::DeleteAddon {
        fluent_builders::DeleteAddon::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCluster`](crate::client::fluent_builders::DeleteCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteCluster::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteCluster::set_name): <p>The name of the cluster to delete.</p>
    /// - On success, responds with [`DeleteClusterOutput`](crate::output::DeleteClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::DeleteClusterOutput::cluster): <p>The full description of the cluster to delete.</p>
    /// - On failure, responds with [`SdkError<DeleteClusterError>`](crate::error::DeleteClusterError)
    pub fn delete_cluster(&self) -> fluent_builders::DeleteCluster {
        fluent_builders::DeleteCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFargateProfile`](crate::client::fluent_builders::DeleteFargateProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::DeleteFargateProfile::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::DeleteFargateProfile::set_cluster_name): <p>The name of the Amazon EKS cluster associated with the Fargate profile to delete.</p>
    ///   - [`fargate_profile_name(impl Into<String>)`](crate::client::fluent_builders::DeleteFargateProfile::fargate_profile_name) / [`set_fargate_profile_name(Option<String>)`](crate::client::fluent_builders::DeleteFargateProfile::set_fargate_profile_name): <p>The name of the Fargate profile to delete.</p>
    /// - On success, responds with [`DeleteFargateProfileOutput`](crate::output::DeleteFargateProfileOutput) with field(s):
    ///   - [`fargate_profile(Option<FargateProfile>)`](crate::output::DeleteFargateProfileOutput::fargate_profile): <p>The deleted Fargate profile.</p>
    /// - On failure, responds with [`SdkError<DeleteFargateProfileError>`](crate::error::DeleteFargateProfileError)
    pub fn delete_fargate_profile(&self) -> fluent_builders::DeleteFargateProfile {
        fluent_builders::DeleteFargateProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNodegroup`](crate::client::fluent_builders::DeleteNodegroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::DeleteNodegroup::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::DeleteNodegroup::set_cluster_name): <p>The name of the Amazon EKS cluster that is associated with your node group.</p>
    ///   - [`nodegroup_name(impl Into<String>)`](crate::client::fluent_builders::DeleteNodegroup::nodegroup_name) / [`set_nodegroup_name(Option<String>)`](crate::client::fluent_builders::DeleteNodegroup::set_nodegroup_name): <p>The name of the node group to delete.</p>
    /// - On success, responds with [`DeleteNodegroupOutput`](crate::output::DeleteNodegroupOutput) with field(s):
    ///   - [`nodegroup(Option<Nodegroup>)`](crate::output::DeleteNodegroupOutput::nodegroup): <p>The full description of your deleted node group.</p>
    /// - On failure, responds with [`SdkError<DeleteNodegroupError>`](crate::error::DeleteNodegroupError)
    pub fn delete_nodegroup(&self) -> fluent_builders::DeleteNodegroup {
        fluent_builders::DeleteNodegroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterCluster`](crate::client::fluent_builders::DeregisterCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeregisterCluster::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeregisterCluster::set_name): <p>The name of the connected cluster to deregister.</p>
    /// - On success, responds with [`DeregisterClusterOutput`](crate::output::DeregisterClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::DeregisterClusterOutput::cluster): <p>An object representing an Amazon EKS cluster.</p>
    /// - On failure, responds with [`SdkError<DeregisterClusterError>`](crate::error::DeregisterClusterError)
    pub fn deregister_cluster(&self) -> fluent_builders::DeregisterCluster {
        fluent_builders::DeregisterCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAddon`](crate::client::fluent_builders::DescribeAddon) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::DescribeAddon::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::DescribeAddon::set_cluster_name): <p>The name of the cluster.</p>
    ///   - [`addon_name(impl Into<String>)`](crate::client::fluent_builders::DescribeAddon::addon_name) / [`set_addon_name(Option<String>)`](crate::client::fluent_builders::DescribeAddon::set_addon_name): <p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>
    /// - On success, responds with [`DescribeAddonOutput`](crate::output::DescribeAddonOutput) with field(s):
    ///   - [`addon(Option<Addon>)`](crate::output::DescribeAddonOutput::addon): <p>An Amazon EKS add-on. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html">Amazon EKS add-ons</a> in the <i>Amazon EKS User Guide</i>.</p>
    /// - On failure, responds with [`SdkError<DescribeAddonError>`](crate::error::DescribeAddonError)
    pub fn describe_addon(&self) -> fluent_builders::DescribeAddon {
        fluent_builders::DescribeAddon::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAddonVersions`](crate::client::fluent_builders::DescribeAddonVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeAddonVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`kubernetes_version(impl Into<String>)`](crate::client::fluent_builders::DescribeAddonVersions::kubernetes_version) / [`set_kubernetes_version(Option<String>)`](crate::client::fluent_builders::DescribeAddonVersions::set_kubernetes_version): <p>The Kubernetes versions that the add-on can be used with.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeAddonVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeAddonVersions::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeAddonVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeAddonVersions::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeAddonVersionsRequest</code> where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>   <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p>  </note>
    ///   - [`addon_name(impl Into<String>)`](crate::client::fluent_builders::DescribeAddonVersions::addon_name) / [`set_addon_name(Option<String>)`](crate::client::fluent_builders::DescribeAddonVersions::set_addon_name): <p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>
    /// - On success, responds with [`DescribeAddonVersionsOutput`](crate::output::DescribeAddonVersionsOutput) with field(s):
    ///   - [`addons(Option<Vec<AddonInfo>>)`](crate::output::DescribeAddonVersionsOutput::addons): <p>The list of available versions with Kubernetes version compatibility.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAddonVersionsOutput::next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeAddonVersionsResponse</code> where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>   <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p>  </note>
    /// - On failure, responds with [`SdkError<DescribeAddonVersionsError>`](crate::error::DescribeAddonVersionsError)
    pub fn describe_addon_versions(&self) -> fluent_builders::DescribeAddonVersions {
        fluent_builders::DescribeAddonVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCluster`](crate::client::fluent_builders::DescribeCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeCluster::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeCluster::set_name): <p>The name of the cluster to describe.</p>
    /// - On success, responds with [`DescribeClusterOutput`](crate::output::DescribeClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::DescribeClusterOutput::cluster): <p>The full description of your specified cluster.</p>
    /// - On failure, responds with [`SdkError<DescribeClusterError>`](crate::error::DescribeClusterError)
    pub fn describe_cluster(&self) -> fluent_builders::DescribeCluster {
        fluent_builders::DescribeCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFargateProfile`](crate::client::fluent_builders::DescribeFargateProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::DescribeFargateProfile::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::DescribeFargateProfile::set_cluster_name): <p>The name of the Amazon EKS cluster associated with the Fargate profile.</p>
    ///   - [`fargate_profile_name(impl Into<String>)`](crate::client::fluent_builders::DescribeFargateProfile::fargate_profile_name) / [`set_fargate_profile_name(Option<String>)`](crate::client::fluent_builders::DescribeFargateProfile::set_fargate_profile_name): <p>The name of the Fargate profile to describe.</p>
    /// - On success, responds with [`DescribeFargateProfileOutput`](crate::output::DescribeFargateProfileOutput) with field(s):
    ///   - [`fargate_profile(Option<FargateProfile>)`](crate::output::DescribeFargateProfileOutput::fargate_profile): <p>The full description of your Fargate profile.</p>
    /// - On failure, responds with [`SdkError<DescribeFargateProfileError>`](crate::error::DescribeFargateProfileError)
    pub fn describe_fargate_profile(&self) -> fluent_builders::DescribeFargateProfile {
        fluent_builders::DescribeFargateProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIdentityProviderConfig`](crate::client::fluent_builders::DescribeIdentityProviderConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::DescribeIdentityProviderConfig::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::DescribeIdentityProviderConfig::set_cluster_name): <p>The cluster name that the identity provider configuration is associated to.</p>
    ///   - [`identity_provider_config(IdentityProviderConfig)`](crate::client::fluent_builders::DescribeIdentityProviderConfig::identity_provider_config) / [`set_identity_provider_config(Option<IdentityProviderConfig>)`](crate::client::fluent_builders::DescribeIdentityProviderConfig::set_identity_provider_config): <p>An object that represents an identity provider configuration.</p>
    /// - On success, responds with [`DescribeIdentityProviderConfigOutput`](crate::output::DescribeIdentityProviderConfigOutput) with field(s):
    ///   - [`identity_provider_config(Option<IdentityProviderConfigResponse>)`](crate::output::DescribeIdentityProviderConfigOutput::identity_provider_config): <p>The object that represents an OpenID Connect (OIDC) identity provider configuration.</p>
    /// - On failure, responds with [`SdkError<DescribeIdentityProviderConfigError>`](crate::error::DescribeIdentityProviderConfigError)
    pub fn describe_identity_provider_config(
        &self,
    ) -> fluent_builders::DescribeIdentityProviderConfig {
        fluent_builders::DescribeIdentityProviderConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeNodegroup`](crate::client::fluent_builders::DescribeNodegroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::DescribeNodegroup::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::DescribeNodegroup::set_cluster_name): <p>The name of the Amazon EKS cluster associated with the node group.</p>
    ///   - [`nodegroup_name(impl Into<String>)`](crate::client::fluent_builders::DescribeNodegroup::nodegroup_name) / [`set_nodegroup_name(Option<String>)`](crate::client::fluent_builders::DescribeNodegroup::set_nodegroup_name): <p>The name of the node group to describe.</p>
    /// - On success, responds with [`DescribeNodegroupOutput`](crate::output::DescribeNodegroupOutput) with field(s):
    ///   - [`nodegroup(Option<Nodegroup>)`](crate::output::DescribeNodegroupOutput::nodegroup): <p>The full description of your node group.</p>
    /// - On failure, responds with [`SdkError<DescribeNodegroupError>`](crate::error::DescribeNodegroupError)
    pub fn describe_nodegroup(&self) -> fluent_builders::DescribeNodegroup {
        fluent_builders::DescribeNodegroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUpdate`](crate::client::fluent_builders::DescribeUpdate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeUpdate::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeUpdate::set_name): <p>The name of the Amazon EKS cluster associated with the update.</p>
    ///   - [`update_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUpdate::update_id) / [`set_update_id(Option<String>)`](crate::client::fluent_builders::DescribeUpdate::set_update_id): <p>The ID of the update to describe.</p>
    ///   - [`nodegroup_name(impl Into<String>)`](crate::client::fluent_builders::DescribeUpdate::nodegroup_name) / [`set_nodegroup_name(Option<String>)`](crate::client::fluent_builders::DescribeUpdate::set_nodegroup_name): <p>The name of the Amazon EKS node group associated with the update.</p>
    ///   - [`addon_name(impl Into<String>)`](crate::client::fluent_builders::DescribeUpdate::addon_name) / [`set_addon_name(Option<String>)`](crate::client::fluent_builders::DescribeUpdate::set_addon_name): <p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>
    /// - On success, responds with [`DescribeUpdateOutput`](crate::output::DescribeUpdateOutput) with field(s):
    ///   - [`update(Option<Update>)`](crate::output::DescribeUpdateOutput::update): <p>The full description of the specified update.</p>
    /// - On failure, responds with [`SdkError<DescribeUpdateError>`](crate::error::DescribeUpdateError)
    pub fn describe_update(&self) -> fluent_builders::DescribeUpdate {
        fluent_builders::DescribeUpdate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateIdentityProviderConfig`](crate::client::fluent_builders::DisassociateIdentityProviderConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::DisassociateIdentityProviderConfig::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::DisassociateIdentityProviderConfig::set_cluster_name): <p>The name of the cluster to disassociate an identity provider from.</p>
    ///   - [`identity_provider_config(IdentityProviderConfig)`](crate::client::fluent_builders::DisassociateIdentityProviderConfig::identity_provider_config) / [`set_identity_provider_config(Option<IdentityProviderConfig>)`](crate::client::fluent_builders::DisassociateIdentityProviderConfig::set_identity_provider_config): <p>An object that represents an identity provider configuration.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::DisassociateIdentityProviderConfig::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::DisassociateIdentityProviderConfig::set_client_request_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`DisassociateIdentityProviderConfigOutput`](crate::output::DisassociateIdentityProviderConfigOutput) with field(s):
    ///   - [`update(Option<Update>)`](crate::output::DisassociateIdentityProviderConfigOutput::update): <p>An object representing an asynchronous update.</p>
    /// - On failure, responds with [`SdkError<DisassociateIdentityProviderConfigError>`](crate::error::DisassociateIdentityProviderConfigError)
    pub fn disassociate_identity_provider_config(
        &self,
    ) -> fluent_builders::DisassociateIdentityProviderConfig {
        fluent_builders::DisassociateIdentityProviderConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAddons`](crate::client::fluent_builders::ListAddons) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAddons::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::ListAddons::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::ListAddons::set_cluster_name): <p>The name of the cluster.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAddons::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAddons::set_max_results): <p>The maximum number of add-on results returned by <code>ListAddonsRequest</code> in paginated output. When you use this parameter, <code>ListAddonsRequest</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListAddonsRequest</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListAddonsRequest</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAddons::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAddons::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>ListAddonsRequest</code> where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>   <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p>  </note>
    /// - On success, responds with [`ListAddonsOutput`](crate::output::ListAddonsOutput) with field(s):
    ///   - [`addons(Option<Vec<String>>)`](crate::output::ListAddonsOutput::addons): <p>A list of available add-ons.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAddonsOutput::next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>ListAddonsResponse</code> where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>   <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p>  </note>
    /// - On failure, responds with [`SdkError<ListAddonsError>`](crate::error::ListAddonsError)
    pub fn list_addons(&self) -> fluent_builders::ListAddons {
        fluent_builders::ListAddons::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListClusters`](crate::client::fluent_builders::ListClusters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListClusters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListClusters::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListClusters::set_max_results): <p>The maximum number of cluster results returned by <code>ListClusters</code> in paginated output. When you use this parameter, <code>ListClusters</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListClusters</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListClusters</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListClusters::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListClusters::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>ListClusters</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>   <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p>  </note>
    ///   - [`include(Vec<String>)`](crate::client::fluent_builders::ListClusters::include) / [`set_include(Option<Vec<String>>)`](crate::client::fluent_builders::ListClusters::set_include): <p>Indicates whether external clusters are included in the returned list. Use '<code>all</code>' to return connected clusters, or blank to return only Amazon EKS clusters. '<code>all</code>' must be in lowercase otherwise an error occurs.</p>
    /// - On success, responds with [`ListClustersOutput`](crate::output::ListClustersOutput) with field(s):
    ///   - [`clusters(Option<Vec<String>>)`](crate::output::ListClustersOutput::clusters): <p>A list of all of the clusters for your account in the specified Region.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListClustersOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListClusters</code> request. When the results of a <code>ListClusters</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListClustersError>`](crate::error::ListClustersError)
    pub fn list_clusters(&self) -> fluent_builders::ListClusters {
        fluent_builders::ListClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFargateProfiles`](crate::client::fluent_builders::ListFargateProfiles) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFargateProfiles::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::ListFargateProfiles::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::ListFargateProfiles::set_cluster_name): <p>The name of the Amazon EKS cluster that you would like to list Fargate profiles in.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFargateProfiles::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFargateProfiles::set_max_results): <p>The maximum number of Fargate profile results returned by <code>ListFargateProfiles</code> in paginated output. When you use this parameter, <code>ListFargateProfiles</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListFargateProfiles</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListFargateProfiles</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFargateProfiles::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFargateProfiles::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>ListFargateProfiles</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    /// - On success, responds with [`ListFargateProfilesOutput`](crate::output::ListFargateProfilesOutput) with field(s):
    ///   - [`fargate_profile_names(Option<Vec<String>>)`](crate::output::ListFargateProfilesOutput::fargate_profile_names): <p>A list of all of the Fargate profiles associated with the specified cluster.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFargateProfilesOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListFargateProfiles</code> request. When the results of a <code>ListFargateProfiles</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListFargateProfilesError>`](crate::error::ListFargateProfilesError)
    pub fn list_fargate_profiles(&self) -> fluent_builders::ListFargateProfiles {
        fluent_builders::ListFargateProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIdentityProviderConfigs`](crate::client::fluent_builders::ListIdentityProviderConfigs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListIdentityProviderConfigs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::ListIdentityProviderConfigs::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::ListIdentityProviderConfigs::set_cluster_name): <p>The cluster name that you want to list identity provider configurations for.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListIdentityProviderConfigs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListIdentityProviderConfigs::set_max_results): <p>The maximum number of identity provider configurations returned by <code>ListIdentityProviderConfigs</code> in paginated output. When you use this parameter, <code>ListIdentityProviderConfigs</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListIdentityProviderConfigs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListIdentityProviderConfigs</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListIdentityProviderConfigs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListIdentityProviderConfigs::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>IdentityProviderConfigsRequest</code> where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    /// - On success, responds with [`ListIdentityProviderConfigsOutput`](crate::output::ListIdentityProviderConfigsOutput) with field(s):
    ///   - [`identity_provider_configs(Option<Vec<IdentityProviderConfig>>)`](crate::output::ListIdentityProviderConfigsOutput::identity_provider_configs): <p>The identity provider configurations for the cluster.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListIdentityProviderConfigsOutput::next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>ListIdentityProviderConfigsResponse</code> where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    /// - On failure, responds with [`SdkError<ListIdentityProviderConfigsError>`](crate::error::ListIdentityProviderConfigsError)
    pub fn list_identity_provider_configs(&self) -> fluent_builders::ListIdentityProviderConfigs {
        fluent_builders::ListIdentityProviderConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListNodegroups`](crate::client::fluent_builders::ListNodegroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListNodegroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::ListNodegroups::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::ListNodegroups::set_cluster_name): <p>The name of the Amazon EKS cluster that you would like to list node groups in.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListNodegroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListNodegroups::set_max_results): <p>The maximum number of node group results returned by <code>ListNodegroups</code> in paginated output. When you use this parameter, <code>ListNodegroups</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListNodegroups</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListNodegroups</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListNodegroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListNodegroups::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>ListNodegroups</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    /// - On success, responds with [`ListNodegroupsOutput`](crate::output::ListNodegroupsOutput) with field(s):
    ///   - [`nodegroups(Option<Vec<String>>)`](crate::output::ListNodegroupsOutput::nodegroups): <p>A list of all of the node groups associated with the specified cluster.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListNodegroupsOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListNodegroups</code> request. When the results of a <code>ListNodegroups</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListNodegroupsError>`](crate::error::ListNodegroupsError)
    pub fn list_nodegroups(&self) -> fluent_builders::ListNodegroups {
        fluent_builders::ListNodegroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are Amazon EKS clusters and managed node groups.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags for the resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUpdates`](crate::client::fluent_builders::ListUpdates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListUpdates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListUpdates::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListUpdates::set_name): <p>The name of the Amazon EKS cluster to list updates for.</p>
    ///   - [`nodegroup_name(impl Into<String>)`](crate::client::fluent_builders::ListUpdates::nodegroup_name) / [`set_nodegroup_name(Option<String>)`](crate::client::fluent_builders::ListUpdates::set_nodegroup_name): <p>The name of the Amazon EKS managed node group to list updates for.</p>
    ///   - [`addon_name(impl Into<String>)`](crate::client::fluent_builders::ListUpdates::addon_name) / [`set_addon_name(Option<String>)`](crate::client::fluent_builders::ListUpdates::set_addon_name): <p>The names of the installed add-ons that have available updates.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListUpdates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListUpdates::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>ListUpdates</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListUpdates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListUpdates::set_max_results): <p>The maximum number of update results returned by <code>ListUpdates</code> in paginated output. When you use this parameter, <code>ListUpdates</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListUpdates</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListUpdates</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    /// - On success, responds with [`ListUpdatesOutput`](crate::output::ListUpdatesOutput) with field(s):
    ///   - [`update_ids(Option<Vec<String>>)`](crate::output::ListUpdatesOutput::update_ids): <p>A list of all the updates for the specified cluster and Region.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListUpdatesOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListUpdates</code> request. When the results of a <code>ListUpdates</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListUpdatesError>`](crate::error::ListUpdatesError)
    pub fn list_updates(&self) -> fluent_builders::ListUpdates {
        fluent_builders::ListUpdates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterCluster`](crate::client::fluent_builders::RegisterCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::RegisterCluster::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::RegisterCluster::set_name): <p>Define a unique name for this cluster for your Region.</p>
    ///   - [`connector_config(ConnectorConfigRequest)`](crate::client::fluent_builders::RegisterCluster::connector_config) / [`set_connector_config(Option<ConnectorConfigRequest>)`](crate::client::fluent_builders::RegisterCluster::set_connector_config): <p>The configuration settings required to connect the Kubernetes cluster to the Amazon EKS control plane.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::RegisterCluster::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::RegisterCluster::set_client_request_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::RegisterCluster::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::RegisterCluster::set_tags): <p>The metadata that you apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Cluster tags do not propagate to any other resources associated with the cluster.</p>
    /// - On success, responds with [`RegisterClusterOutput`](crate::output::RegisterClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::RegisterClusterOutput::cluster): <p>An object representing an Amazon EKS cluster.</p>
    /// - On failure, responds with [`SdkError<RegisterClusterError>`](crate::error::RegisterClusterError)
    pub fn register_cluster(&self) -> fluent_builders::RegisterCluster {
        fluent_builders::RegisterCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to which to add tags. Currently, the supported resources are Amazon EKS clusters and managed node groups.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to add to the resource. A tag is an array of key-value pairs.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource from which to delete tags. Currently, the supported resources are Amazon EKS clusters and managed node groups.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The keys of the tags to be removed.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAddon`](crate::client::fluent_builders::UpdateAddon) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::UpdateAddon::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::UpdateAddon::set_cluster_name): <p>The name of the cluster.</p>
    ///   - [`addon_name(impl Into<String>)`](crate::client::fluent_builders::UpdateAddon::addon_name) / [`set_addon_name(Option<String>)`](crate::client::fluent_builders::UpdateAddon::set_addon_name): <p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>
    ///   - [`addon_version(impl Into<String>)`](crate::client::fluent_builders::UpdateAddon::addon_version) / [`set_addon_version(Option<String>)`](crate::client::fluent_builders::UpdateAddon::set_addon_version): <p>The version of the add-on. The version must match one of the versions returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html"> <code>DescribeAddonVersions</code> </a>.</p>
    ///   - [`service_account_role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAddon::service_account_role_arn) / [`set_service_account_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateAddon::set_service_account_role_arn): <p>The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM role</a> in the <i>Amazon EKS User Guide</i>.</p> <note>   <p>To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html">Enabling IAM roles for service accounts on your cluster</a> in the <i>Amazon EKS User Guide</i>.</p>  </note>
    ///   - [`resolve_conflicts(ResolveConflicts)`](crate::client::fluent_builders::UpdateAddon::resolve_conflicts) / [`set_resolve_conflicts(Option<ResolveConflicts>)`](crate::client::fluent_builders::UpdateAddon::set_resolve_conflicts): <p>How to resolve parameter value conflicts when applying the new version of the add-on to the cluster.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::UpdateAddon::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::UpdateAddon::set_client_request_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`UpdateAddonOutput`](crate::output::UpdateAddonOutput) with field(s):
    ///   - [`update(Option<Update>)`](crate::output::UpdateAddonOutput::update): <p>An object representing an asynchronous update.</p>
    /// - On failure, responds with [`SdkError<UpdateAddonError>`](crate::error::UpdateAddonError)
    pub fn update_addon(&self) -> fluent_builders::UpdateAddon {
        fluent_builders::UpdateAddon::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateClusterConfig`](crate::client::fluent_builders::UpdateClusterConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateClusterConfig::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateClusterConfig::set_name): <p>The name of the Amazon EKS cluster to update.</p>
    ///   - [`resources_vpc_config(VpcConfigRequest)`](crate::client::fluent_builders::UpdateClusterConfig::resources_vpc_config) / [`set_resources_vpc_config(Option<VpcConfigRequest>)`](crate::client::fluent_builders::UpdateClusterConfig::set_resources_vpc_config): <p>An object representing the VPC configuration to use for an Amazon EKS cluster.</p>
    ///   - [`logging(Logging)`](crate::client::fluent_builders::UpdateClusterConfig::logging) / [`set_logging(Option<Logging>)`](crate::client::fluent_builders::UpdateClusterConfig::set_logging): <p>Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS cluster control plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note>   <p>CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.</p>  </note>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::UpdateClusterConfig::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::UpdateClusterConfig::set_client_request_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`UpdateClusterConfigOutput`](crate::output::UpdateClusterConfigOutput) with field(s):
    ///   - [`update(Option<Update>)`](crate::output::UpdateClusterConfigOutput::update): <p>An object representing an asynchronous update.</p>
    /// - On failure, responds with [`SdkError<UpdateClusterConfigError>`](crate::error::UpdateClusterConfigError)
    pub fn update_cluster_config(&self) -> fluent_builders::UpdateClusterConfig {
        fluent_builders::UpdateClusterConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateClusterVersion`](crate::client::fluent_builders::UpdateClusterVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateClusterVersion::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateClusterVersion::set_name): <p>The name of the Amazon EKS cluster to update.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::UpdateClusterVersion::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::UpdateClusterVersion::set_version): <p>The desired Kubernetes version following a successful update.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::UpdateClusterVersion::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::UpdateClusterVersion::set_client_request_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`UpdateClusterVersionOutput`](crate::output::UpdateClusterVersionOutput) with field(s):
    ///   - [`update(Option<Update>)`](crate::output::UpdateClusterVersionOutput::update): <p>The full description of the specified update</p>
    /// - On failure, responds with [`SdkError<UpdateClusterVersionError>`](crate::error::UpdateClusterVersionError)
    pub fn update_cluster_version(&self) -> fluent_builders::UpdateClusterVersion {
        fluent_builders::UpdateClusterVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateNodegroupConfig`](crate::client::fluent_builders::UpdateNodegroupConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::UpdateNodegroupConfig::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::UpdateNodegroupConfig::set_cluster_name): <p>The name of the Amazon EKS cluster that the managed node group resides in.</p>
    ///   - [`nodegroup_name(impl Into<String>)`](crate::client::fluent_builders::UpdateNodegroupConfig::nodegroup_name) / [`set_nodegroup_name(Option<String>)`](crate::client::fluent_builders::UpdateNodegroupConfig::set_nodegroup_name): <p>The name of the managed node group to update.</p>
    ///   - [`labels(UpdateLabelsPayload)`](crate::client::fluent_builders::UpdateNodegroupConfig::labels) / [`set_labels(Option<UpdateLabelsPayload>)`](crate::client::fluent_builders::UpdateNodegroupConfig::set_labels): <p>The Kubernetes labels to be applied to the nodes in the node group after the update.</p>
    ///   - [`taints(UpdateTaintsPayload)`](crate::client::fluent_builders::UpdateNodegroupConfig::taints) / [`set_taints(Option<UpdateTaintsPayload>)`](crate::client::fluent_builders::UpdateNodegroupConfig::set_taints): <p>The Kubernetes taints to be applied to the nodes in the node group after the update.</p>
    ///   - [`scaling_config(NodegroupScalingConfig)`](crate::client::fluent_builders::UpdateNodegroupConfig::scaling_config) / [`set_scaling_config(Option<NodegroupScalingConfig>)`](crate::client::fluent_builders::UpdateNodegroupConfig::set_scaling_config): <p>The scaling configuration details for the Auto Scaling group after the update.</p>
    ///   - [`update_config(NodegroupUpdateConfig)`](crate::client::fluent_builders::UpdateNodegroupConfig::update_config) / [`set_update_config(Option<NodegroupUpdateConfig>)`](crate::client::fluent_builders::UpdateNodegroupConfig::set_update_config): <p>The node group update configuration.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::UpdateNodegroupConfig::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::UpdateNodegroupConfig::set_client_request_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`UpdateNodegroupConfigOutput`](crate::output::UpdateNodegroupConfigOutput) with field(s):
    ///   - [`update(Option<Update>)`](crate::output::UpdateNodegroupConfigOutput::update): <p>An object representing an asynchronous update.</p>
    /// - On failure, responds with [`SdkError<UpdateNodegroupConfigError>`](crate::error::UpdateNodegroupConfigError)
    pub fn update_nodegroup_config(&self) -> fluent_builders::UpdateNodegroupConfig {
        fluent_builders::UpdateNodegroupConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateNodegroupVersion`](crate::client::fluent_builders::UpdateNodegroupVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::UpdateNodegroupVersion::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::UpdateNodegroupVersion::set_cluster_name): <p>The name of the Amazon EKS cluster that is associated with the managed node group to update.</p>
    ///   - [`nodegroup_name(impl Into<String>)`](crate::client::fluent_builders::UpdateNodegroupVersion::nodegroup_name) / [`set_nodegroup_name(Option<String>)`](crate::client::fluent_builders::UpdateNodegroupVersion::set_nodegroup_name): <p>The name of the managed node group to update.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::UpdateNodegroupVersion::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::UpdateNodegroupVersion::set_version): <p>The Kubernetes version to update to. If no version is specified, then the Kubernetes version of the node group does not change. You can specify the Kubernetes version of the cluster to update the node group to the latest AMI version of the cluster's Kubernetes version. If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify <code>version</code>, or the node group update will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
    ///   - [`release_version(impl Into<String>)`](crate::client::fluent_builders::UpdateNodegroupVersion::release_version) / [`set_release_version(Option<String>)`](crate::client::fluent_builders::UpdateNodegroupVersion::set_release_version): <p>The AMI version of the Amazon EKS optimized AMI to use for the update. By default, the latest available AMI version for the node group's Kubernetes version is used. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized Amazon Linux 2 AMI versions </a> in the <i>Amazon EKS User Guide</i>. If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify <code>releaseVersion</code>, or the node group update will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
    ///   - [`launch_template(LaunchTemplateSpecification)`](crate::client::fluent_builders::UpdateNodegroupVersion::launch_template) / [`set_launch_template(Option<LaunchTemplateSpecification>)`](crate::client::fluent_builders::UpdateNodegroupVersion::set_launch_template): <p>An object representing a node group's launch template specification. You can only update a node group using a launch template if the node group was originally deployed with a launch template.</p>
    ///   - [`force(bool)`](crate::client::fluent_builders::UpdateNodegroupVersion::force) / [`set_force(bool)`](crate::client::fluent_builders::UpdateNodegroupVersion::set_force): <p>Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue. If an update fails because pods could not be drained, you can force the update after it fails to terminate the old node whether or not any pods are running on the node.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::UpdateNodegroupVersion::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::UpdateNodegroupVersion::set_client_request_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`UpdateNodegroupVersionOutput`](crate::output::UpdateNodegroupVersionOutput) with field(s):
    ///   - [`update(Option<Update>)`](crate::output::UpdateNodegroupVersionOutput::update): <p>An object representing an asynchronous update.</p>
    /// - On failure, responds with [`SdkError<UpdateNodegroupVersionError>`](crate::error::UpdateNodegroupVersionError)
    pub fn update_nodegroup_version(&self) -> fluent_builders::UpdateNodegroupVersion {
        fluent_builders::UpdateNodegroupVersion::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateEncryptionConfig`.
    ///
    /// <p>Associate encryption configuration to an existing cluster.</p>
    /// <p>You can use this API to enable encryption on existing clusters which do not have encryption already enabled. This allows you to implement a defense-in-depth security strategy without migrating applications to new Amazon EKS clusters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateEncryptionConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_encryption_config_input::Builder,
    }
    impl AssociateEncryptionConfig {
        /// Creates a new `AssociateEncryptionConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateEncryptionConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateEncryptionConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster that you are associating with encryption configuration.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the cluster that you are associating with encryption configuration.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// Appends an item to `encryptionConfig`.
        ///
        /// To override the contents of this collection use [`set_encryption_config`](Self::set_encryption_config).
        ///
        /// <p>The configuration you are using for encryption.</p>
        pub fn encryption_config(mut self, input: crate::model::EncryptionConfig) -> Self {
            self.inner = self.inner.encryption_config(input);
            self
        }
        /// <p>The configuration you are using for encryption.</p>
        pub fn set_encryption_config(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EncryptionConfig>>,
        ) -> Self {
            self.inner = self.inner.set_encryption_config(input);
            self
        }
        /// <p>The client request token you are using with the encryption configuration.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>The client request token you are using with the encryption configuration.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateIdentityProviderConfig`.
    ///
    /// <p>Associate an identity provider configuration to a cluster.</p>
    /// <p>If you want to authenticate identities using an identity provider, you can create an identity provider configuration and associate it to your cluster. After configuring authentication to your cluster you can create Kubernetes <code>roles</code> and <code>clusterroles</code> to assign permissions to the roles, and then bind the roles to the identities using Kubernetes <code>rolebindings</code> and <code>clusterrolebindings</code>. For more information see <a href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/">Using RBAC Authorization</a> in the Kubernetes documentation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateIdentityProviderConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_identity_provider_config_input::Builder,
    }
    impl AssociateIdentityProviderConfig {
        /// Creates a new `AssociateIdentityProviderConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateIdentityProviderConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateIdentityProviderConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster to associate the configuration to.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the cluster to associate the configuration to.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>An object that represents an OpenID Connect (OIDC) identity provider configuration.</p>
        pub fn oidc(mut self, input: crate::model::OidcIdentityProviderConfigRequest) -> Self {
            self.inner = self.inner.oidc(input);
            self
        }
        /// <p>An object that represents an OpenID Connect (OIDC) identity provider configuration.</p>
        pub fn set_oidc(
            mut self,
            input: std::option::Option<crate::model::OidcIdentityProviderConfigRequest>,
        ) -> Self {
            self.inner = self.inner.set_oidc(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata to apply to the configuration to assist with categorization and organization. Each tag consists of a key and an optional value. You define both.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The metadata to apply to the configuration to assist with categorization and organization. Each tag consists of a key and an optional value. You define both.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAddon`.
    ///
    /// <p>Creates an Amazon EKS add-on.</p>
    /// <p>Amazon EKS add-ons help to automate the provisioning and lifecycle management of common operational software for Amazon EKS clusters. Amazon EKS add-ons require clusters running version 1.18 or later because Amazon EKS add-ons rely on the Server-side Apply Kubernetes feature, which is only available in Kubernetes 1.18 and later. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html">Amazon EKS add-ons</a> in the <i>Amazon EKS User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAddon {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_addon_input::Builder,
    }
    impl CreateAddon {
        /// Creates a new `CreateAddon`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAddonOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAddonError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster to create the add-on for.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the cluster to create the add-on for.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html"> <code>DescribeAddonVersions</code> </a>.</p>
        pub fn addon_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.addon_name(input.into());
            self
        }
        /// <p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html"> <code>DescribeAddonVersions</code> </a>.</p>
        pub fn set_addon_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_addon_name(input);
            self
        }
        /// <p>The version of the add-on. The version must match one of the versions returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html"> <code>DescribeAddonVersions</code> </a>.</p>
        pub fn addon_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.addon_version(input.into());
            self
        }
        /// <p>The version of the add-on. The version must match one of the versions returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html"> <code>DescribeAddonVersions</code> </a>.</p>
        pub fn set_addon_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_addon_version(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM role</a> in the <i>Amazon EKS User Guide</i>.</p> <note>
        /// <p>To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html">Enabling IAM roles for service accounts on your cluster</a> in the <i>Amazon EKS User Guide</i>.</p>
        /// </note>
        pub fn service_account_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_account_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM role</a> in the <i>Amazon EKS User Guide</i>.</p> <note>
        /// <p>To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html">Enabling IAM roles for service accounts on your cluster</a> in the <i>Amazon EKS User Guide</i>.</p>
        /// </note>
        pub fn set_service_account_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_account_role_arn(input);
            self
        }
        /// <p>How to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on.</p>
        pub fn resolve_conflicts(mut self, input: crate::model::ResolveConflicts) -> Self {
            self.inner = self.inner.resolve_conflicts(input);
            self
        }
        /// <p>How to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on.</p>
        pub fn set_resolve_conflicts(
            mut self,
            input: std::option::Option<crate::model::ResolveConflicts>,
        ) -> Self {
            self.inner = self.inner.set_resolve_conflicts(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value. You define both.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value. You define both.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCluster`.
    ///
    /// <p>Creates an Amazon EKS control plane. </p>
    /// <p>The Amazon EKS control plane consists of control plane instances that run the Kubernetes software, such as <code>etcd</code> and the API server. The control plane runs in an account managed by Amazon Web Services, and the Kubernetes API is exposed by the Amazon EKS API server endpoint. Each Amazon EKS cluster control plane is single tenant and unique. It runs on its own set of Amazon EC2 instances.</p>
    /// <p>The cluster control plane is provisioned across multiple Availability Zones and fronted by an Elastic Load Balancing Network Load Balancer. Amazon EKS also provisions elastic network interfaces in your VPC subnets to provide connectivity from the control plane instances to the nodes (for example, to support <code>kubectl exec</code>, <code>logs</code>, and <code>proxy</code> data flows).</p>
    /// <p>Amazon EKS nodes run in your Amazon Web Services account and connect to your cluster's control plane over the Kubernetes API server endpoint and a certificate file that is created for your cluster.</p>
    /// <p>In most cases, it takes several minutes to create a cluster. After you create an Amazon EKS cluster, you must configure your Kubernetes tooling to communicate with the API server and launch nodes into your cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/managing-auth.html">Managing Cluster Authentication</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html">Launching Amazon EKS nodes</a> in the <i>Amazon EKS User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cluster_input::Builder,
    }
    impl CreateCluster {
        /// Creates a new `CreateCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name to give to your cluster.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The unique name to give to your cluster.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The desired Kubernetes version for your cluster. If you don't specify a value here, the latest version available in Amazon EKS is used.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The desired Kubernetes version for your cluster. If you don't specify a value here, the latest version available in Amazon EKS is used.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to Amazon Web Services API operations on your behalf. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html">Amazon EKS Service IAM Role</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to Amazon Web Services API operations on your behalf. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html">Amazon EKS Service IAM Role</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The VPC configuration that's used by the cluster control plane. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group Considerations</a> in the <i>Amazon EKS User Guide</i>. You must specify at least two subnets. You can specify up to five security groups. However, we recommend that you use a dedicated security group for your cluster control plane.</p>
        pub fn resources_vpc_config(mut self, input: crate::model::VpcConfigRequest) -> Self {
            self.inner = self.inner.resources_vpc_config(input);
            self
        }
        /// <p>The VPC configuration that's used by the cluster control plane. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group Considerations</a> in the <i>Amazon EKS User Guide</i>. You must specify at least two subnets. You can specify up to five security groups. However, we recommend that you use a dedicated security group for your cluster control plane.</p>
        pub fn set_resources_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfigRequest>,
        ) -> Self {
            self.inner = self.inner.set_resources_vpc_config(input);
            self
        }
        /// <p>The Kubernetes network configuration for the cluster.</p>
        pub fn kubernetes_network_config(
            mut self,
            input: crate::model::KubernetesNetworkConfigRequest,
        ) -> Self {
            self.inner = self.inner.kubernetes_network_config(input);
            self
        }
        /// <p>The Kubernetes network configuration for the cluster.</p>
        pub fn set_kubernetes_network_config(
            mut self,
            input: std::option::Option<crate::model::KubernetesNetworkConfigRequest>,
        ) -> Self {
            self.inner = self.inner.set_kubernetes_network_config(input);
            self
        }
        /// <p>Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster control plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note>
        /// <p>CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.</p>
        /// </note>
        pub fn logging(mut self, input: crate::model::Logging) -> Self {
            self.inner = self.inner.logging(input);
            self
        }
        /// <p>Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster control plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note>
        /// <p>CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.</p>
        /// </note>
        pub fn set_logging(mut self, input: std::option::Option<crate::model::Logging>) -> Self {
            self.inner = self.inner.set_logging(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value. You define both.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value. You define both.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `encryptionConfig`.
        ///
        /// To override the contents of this collection use [`set_encryption_config`](Self::set_encryption_config).
        ///
        /// <p>The encryption configuration for the cluster.</p>
        pub fn encryption_config(mut self, input: crate::model::EncryptionConfig) -> Self {
            self.inner = self.inner.encryption_config(input);
            self
        }
        /// <p>The encryption configuration for the cluster.</p>
        pub fn set_encryption_config(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EncryptionConfig>>,
        ) -> Self {
            self.inner = self.inner.set_encryption_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFargateProfile`.
    ///
    /// <p>Creates an Fargate profile for your Amazon EKS cluster. You must have at least one Fargate profile in a cluster to be able to run pods on Fargate.</p>
    /// <p>The Fargate profile allows an administrator to declare which pods run on Fargate and specify which pods run on which Fargate profile. This declaration is done through the profile’s selectors. Each profile can have up to five selectors that contain a namespace and labels. A namespace is required for every selector. The label field consists of multiple optional key-value pairs. Pods that match the selectors are scheduled on Fargate. If a to-be-scheduled pod matches any of the selectors in the Fargate profile, then that pod is run on Fargate.</p>
    /// <p>When you create a Fargate profile, you must specify a pod execution role to use with the pods that are scheduled with the profile. This role is added to the cluster's Kubernetes <a href="https://kubernetes.io/docs/admin/authorization/rbac/">Role Based Access Control</a> (RBAC) for authorization so that the <code>kubelet</code> that is running on the Fargate infrastructure can register with your Amazon EKS cluster so that it can appear in your cluster as a node. The pod execution role also provides IAM permissions to the Fargate infrastructure to allow read access to Amazon ECR image repositories. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html">Pod Execution Role</a> in the <i>Amazon EKS User Guide</i>.</p>
    /// <p>Fargate profiles are immutable. However, you can create a new updated profile to replace an existing profile and then delete the original after the updated profile has finished creating.</p>
    /// <p>If any Fargate profiles in a cluster are in the <code>DELETING</code> status, you must wait for that Fargate profile to finish deleting before you can create any other profiles in that cluster.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/fargate-profile.html">Fargate Profile</a> in the <i>Amazon EKS User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFargateProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_fargate_profile_input::Builder,
    }
    impl CreateFargateProfile {
        /// Creates a new `CreateFargateProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFargateProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFargateProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Fargate profile.</p>
        pub fn fargate_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fargate_profile_name(input.into());
            self
        }
        /// <p>The name of the Fargate profile.</p>
        pub fn set_fargate_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_fargate_profile_name(input);
            self
        }
        /// <p>The name of the Amazon EKS cluster to apply the Fargate profile to.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the Amazon EKS cluster to apply the Fargate profile to.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pod execution role to use for pods that match the selectors in the Fargate profile. The pod execution role allows Fargate infrastructure to register with your cluster as a node, and it provides read access to Amazon ECR image repositories. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html">Pod Execution Role</a> in the <i>Amazon EKS User Guide</i>.</p>
        pub fn pod_execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pod_execution_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pod execution role to use for pods that match the selectors in the Fargate profile. The pod execution role allows Fargate infrastructure to register with your cluster as a node, and it provides read access to Amazon ECR image repositories. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html">Pod Execution Role</a> in the <i>Amazon EKS User Guide</i>.</p>
        pub fn set_pod_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pod_execution_role_arn(input);
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The IDs of subnets to launch your pods into. At this time, pods running on Fargate are not assigned public IP addresses, so only private subnets (with no direct route to an Internet Gateway) are accepted for this parameter.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnets(input.into());
            self
        }
        /// <p>The IDs of subnets to launch your pods into. At this time, pods running on Fargate are not assigned public IP addresses, so only private subnets (with no direct route to an Internet Gateway) are accepted for this parameter.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnets(input);
            self
        }
        /// Appends an item to `selectors`.
        ///
        /// To override the contents of this collection use [`set_selectors`](Self::set_selectors).
        ///
        /// <p>The selectors to match for pods to use this Fargate profile. Each selector must have an associated namespace. Optionally, you can also specify labels for a namespace. You may specify up to five selectors in a Fargate profile.</p>
        pub fn selectors(mut self, input: crate::model::FargateProfileSelector) -> Self {
            self.inner = self.inner.selectors(input);
            self
        }
        /// <p>The selectors to match for pods to use this Fargate profile. Each selector must have an associated namespace. Optionally, you can also specify labels for a namespace. You may specify up to five selectors in a Fargate profile.</p>
        pub fn set_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FargateProfileSelector>>,
        ) -> Self {
            self.inner = self.inner.set_selectors(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata to apply to the Fargate profile to assist with categorization and organization. Each tag consists of a key and an optional value. You define both. Fargate profile tags do not propagate to any other resources associated with the Fargate profile, such as the pods that are scheduled with it.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The metadata to apply to the Fargate profile to assist with categorization and organization. Each tag consists of a key and an optional value. You define both. Fargate profile tags do not propagate to any other resources associated with the Fargate profile, such as the pods that are scheduled with it.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNodegroup`.
    ///
    /// <p>Creates a managed node group for an Amazon EKS cluster. You can only create a node group for your cluster that is equal to the current Kubernetes version for the cluster. All node groups are created with the latest AMI release version for the respective minor Kubernetes version of the cluster, unless you deploy a custom AMI using a launch template. For more information about using launch templates, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a>.</p>
    /// <p>An Amazon EKS managed node group is an Amazon EC2 Auto Scaling group and associated Amazon EC2 instances that are managed by Amazon Web Services for an Amazon EKS cluster. Each node group uses a version of the Amazon EKS optimized Amazon Linux 2 AMI. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html">Managed Node Groups</a> in the <i>Amazon EKS User Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNodegroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_nodegroup_input::Builder,
    }
    impl CreateNodegroup {
        /// Creates a new `CreateNodegroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNodegroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNodegroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster to create the node group in.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the cluster to create the node group in.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The unique name to give your node group.</p>
        pub fn nodegroup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.nodegroup_name(input.into());
            self
        }
        /// <p>The unique name to give your node group.</p>
        pub fn set_nodegroup_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_nodegroup_name(input);
            self
        }
        /// <p>The scaling configuration details for the Auto Scaling group that is created for your node group.</p>
        pub fn scaling_config(mut self, input: crate::model::NodegroupScalingConfig) -> Self {
            self.inner = self.inner.scaling_config(input);
            self
        }
        /// <p>The scaling configuration details for the Auto Scaling group that is created for your node group.</p>
        pub fn set_scaling_config(
            mut self,
            input: std::option::Option<crate::model::NodegroupScalingConfig>,
        ) -> Self {
            self.inner = self.inner.set_scaling_config(input);
            self
        }
        /// <p>The root device disk size (in GiB) for your node group instances. The default disk size is 20 GiB. If you specify <code>launchTemplate</code>, then don't specify <code>diskSize</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
        pub fn disk_size(mut self, input: i32) -> Self {
            self.inner = self.inner.disk_size(input);
            self
        }
        /// <p>The root device disk size (in GiB) for your node group instances. The default disk size is 20 GiB. If you specify <code>launchTemplate</code>, then don't specify <code>diskSize</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
        pub fn set_disk_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_disk_size(input);
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The subnets to use for the Auto Scaling group that is created for your node group. If you specify <code>launchTemplate</code>, then don't specify <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html"> <code>SubnetId</code> </a> in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnets(input.into());
            self
        }
        /// <p>The subnets to use for the Auto Scaling group that is created for your node group. If you specify <code>launchTemplate</code>, then don't specify <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html"> <code>SubnetId</code> </a> in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnets(input);
            self
        }
        /// Appends an item to `instanceTypes`.
        ///
        /// To override the contents of this collection use [`set_instance_types`](Self::set_instance_types).
        ///
        /// <p>Specify the instance types for a node group. If you specify a GPU instance type, be sure to specify <code>AL2_x86_64_GPU</code> with the <code>amiType</code> parameter. If you specify <code>launchTemplate</code>, then you can specify zero or one instance type in your launch template <i>or</i> you can specify 0-20 instance types for <code>instanceTypes</code>. If however, you specify an instance type in your launch template <i>and</i> specify any <code>instanceTypes</code>, the node group deployment will fail. If you don't specify an instance type in a launch template or for <code>instanceTypes</code>, then <code>t3.medium</code> is used, by default. If you specify <code>Spot</code> for <code>capacityType</code>, then we recommend specifying multiple values for <code>instanceTypes</code>. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types">Managed node group capacity types</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the <i>Amazon EKS User Guide</i>.</p>
        pub fn instance_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_types(input.into());
            self
        }
        /// <p>Specify the instance types for a node group. If you specify a GPU instance type, be sure to specify <code>AL2_x86_64_GPU</code> with the <code>amiType</code> parameter. If you specify <code>launchTemplate</code>, then you can specify zero or one instance type in your launch template <i>or</i> you can specify 0-20 instance types for <code>instanceTypes</code>. If however, you specify an instance type in your launch template <i>and</i> specify any <code>instanceTypes</code>, the node group deployment will fail. If you don't specify an instance type in a launch template or for <code>instanceTypes</code>, then <code>t3.medium</code> is used, by default. If you specify <code>Spot</code> for <code>capacityType</code>, then we recommend specifying multiple values for <code>instanceTypes</code>. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types">Managed node group capacity types</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the <i>Amazon EKS User Guide</i>.</p>
        pub fn set_instance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_types(input);
            self
        }
        /// <p>The AMI type for your node group. GPU instance types should use the <code>AL2_x86_64_GPU</code> AMI type. Non-GPU instances should use the <code>AL2_x86_64</code> AMI type. Arm instances should use the <code>AL2_ARM_64</code> AMI type. All types use the Amazon EKS optimized Amazon Linux 2 AMI. If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify <code>amiType</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
        pub fn ami_type(mut self, input: crate::model::AmiTypes) -> Self {
            self.inner = self.inner.ami_type(input);
            self
        }
        /// <p>The AMI type for your node group. GPU instance types should use the <code>AL2_x86_64_GPU</code> AMI type. Non-GPU instances should use the <code>AL2_x86_64</code> AMI type. Arm instances should use the <code>AL2_ARM_64</code> AMI type. All types use the Amazon EKS optimized Amazon Linux 2 AMI. If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify <code>amiType</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
        pub fn set_ami_type(mut self, input: std::option::Option<crate::model::AmiTypes>) -> Self {
            self.inner = self.inner.set_ami_type(input);
            self
        }
        /// <p>The remote access (SSH) configuration to use with your node group. If you specify <code>launchTemplate</code>, then don't specify <code>remoteAccess</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
        pub fn remote_access(mut self, input: crate::model::RemoteAccessConfig) -> Self {
            self.inner = self.inner.remote_access(input);
            self
        }
        /// <p>The remote access (SSH) configuration to use with your node group. If you specify <code>launchTemplate</code>, then don't specify <code>remoteAccess</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
        pub fn set_remote_access(
            mut self,
            input: std::option::Option<crate::model::RemoteAccessConfig>,
        ) -> Self {
            self.inner = self.inner.set_remote_access(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with your node group. The Amazon EKS worker node <code>kubelet</code> daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive permissions for these API calls through an IAM instance profile and associated policies. Before you can launch nodes and register them into a cluster, you must create an IAM role for those nodes to use when they are launched. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html">Amazon EKS node IAM role</a> in the <i> <i>Amazon EKS User Guide</i> </i>. If you specify <code>launchTemplate</code>, then don't specify <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html"> <code>IamInstanceProfile</code> </a> in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
        pub fn node_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_role(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with your node group. The Amazon EKS worker node <code>kubelet</code> daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive permissions for these API calls through an IAM instance profile and associated policies. Before you can launch nodes and register them into a cluster, you must create an IAM role for those nodes to use when they are launched. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html">Amazon EKS node IAM role</a> in the <i> <i>Amazon EKS User Guide</i> </i>. If you specify <code>launchTemplate</code>, then don't specify <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html"> <code>IamInstanceProfile</code> </a> in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
        pub fn set_node_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_role(input);
            self
        }
        /// Adds a key-value pair to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>The Kubernetes labels to be applied to the nodes in the node group when they are created.</p>
        pub fn labels(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.labels(k.into(), v.into());
            self
        }
        /// <p>The Kubernetes labels to be applied to the nodes in the node group when they are created.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_labels(input);
            self
        }
        /// Appends an item to `taints`.
        ///
        /// To override the contents of this collection use [`set_taints`](Self::set_taints).
        ///
        /// <p>The Kubernetes taints to be applied to the nodes in the node group.</p>
        pub fn taints(mut self, input: crate::model::Taint) -> Self {
            self.inner = self.inner.taints(input);
            self
        }
        /// <p>The Kubernetes taints to be applied to the nodes in the node group.</p>
        pub fn set_taints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Taint>>,
        ) -> Self {
            self.inner = self.inner.set_taints(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata to apply to the node group to assist with categorization and organization. Each tag consists of a key and an optional value. You define both. Node group tags do not propagate to any other resources associated with the node group, such as the Amazon EC2 instances or subnets.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The metadata to apply to the node group to assist with categorization and organization. Each tag consists of a key and an optional value. You define both. Node group tags do not propagate to any other resources associated with the node group, such as the Amazon EC2 instances or subnets.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>An object representing a node group's launch template specification. If specified, then do not specify <code>instanceTypes</code>, <code>diskSize</code>, or <code>remoteAccess</code> and make sure that the launch template meets the requirements in <code>launchTemplateSpecification</code>.</p>
        pub fn launch_template(mut self, input: crate::model::LaunchTemplateSpecification) -> Self {
            self.inner = self.inner.launch_template(input);
            self
        }
        /// <p>An object representing a node group's launch template specification. If specified, then do not specify <code>instanceTypes</code>, <code>diskSize</code>, or <code>remoteAccess</code> and make sure that the launch template meets the requirements in <code>launchTemplateSpecification</code>.</p>
        pub fn set_launch_template(
            mut self,
            input: std::option::Option<crate::model::LaunchTemplateSpecification>,
        ) -> Self {
            self.inner = self.inner.set_launch_template(input);
            self
        }
        /// <p>The node group update configuration.</p>
        pub fn update_config(mut self, input: crate::model::NodegroupUpdateConfig) -> Self {
            self.inner = self.inner.update_config(input);
            self
        }
        /// <p>The node group update configuration.</p>
        pub fn set_update_config(
            mut self,
            input: std::option::Option<crate::model::NodegroupUpdateConfig>,
        ) -> Self {
            self.inner = self.inner.set_update_config(input);
            self
        }
        /// <p>The capacity type for your node group.</p>
        pub fn capacity_type(mut self, input: crate::model::CapacityTypes) -> Self {
            self.inner = self.inner.capacity_type(input);
            self
        }
        /// <p>The capacity type for your node group.</p>
        pub fn set_capacity_type(
            mut self,
            input: std::option::Option<crate::model::CapacityTypes>,
        ) -> Self {
            self.inner = self.inner.set_capacity_type(input);
            self
        }
        /// <p>The Kubernetes version to use for your managed nodes. By default, the Kubernetes version of the cluster is used, and this is the only accepted specified value. If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify <code>version</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The Kubernetes version to use for your managed nodes. By default, the Kubernetes version of the cluster is used, and this is the only accepted specified value. If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify <code>version</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
        /// <p>The AMI version of the Amazon EKS optimized AMI to use with your node group. By default, the latest available AMI version for the node group's current Kubernetes version is used. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized Amazon Linux 2 AMI versions</a> in the <i>Amazon EKS User Guide</i>. If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify <code>releaseVersion</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
        pub fn release_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.release_version(input.into());
            self
        }
        /// <p>The AMI version of the Amazon EKS optimized AMI to use with your node group. By default, the latest available AMI version for the node group's current Kubernetes version is used. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized Amazon Linux 2 AMI versions</a> in the <i>Amazon EKS User Guide</i>. If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify <code>releaseVersion</code>, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
        pub fn set_release_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_release_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAddon`.
    ///
    /// <p>Delete an Amazon EKS add-on.</p>
    /// <p>When you remove the add-on, it will also be deleted from the cluster. You can always manually start an add-on on the cluster using the Kubernetes API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAddon {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_addon_input::Builder,
    }
    impl DeleteAddon {
        /// Creates a new `DeleteAddon`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAddonOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAddonError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster to delete the add-on from.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the cluster to delete the add-on from.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>
        pub fn addon_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.addon_name(input.into());
            self
        }
        /// <p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>
        pub fn set_addon_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_addon_name(input);
            self
        }
        /// <p>Specifying this option preserves the add-on software on your cluster but Amazon EKS stops managing any settings for the add-on. If an IAM account is associated with the add-on, it is not removed.</p>
        pub fn preserve(mut self, input: bool) -> Self {
            self.inner = self.inner.preserve(input);
            self
        }
        /// <p>Specifying this option preserves the add-on software on your cluster but Amazon EKS stops managing any settings for the add-on. If an IAM account is associated with the add-on, it is not removed.</p>
        pub fn set_preserve(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_preserve(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCluster`.
    ///
    /// <p>Deletes the Amazon EKS cluster control plane.</p>
    /// <p>If you have active services in your cluster that are associated with a load balancer, you must delete those services before deleting the cluster so that the load balancers are deleted properly. Otherwise, you can have orphaned resources in your VPC that prevent you from being able to delete the VPC. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/delete-cluster.html">Deleting a Cluster</a> in the <i>Amazon EKS User Guide</i>.</p>
    /// <p>If you have managed node groups or Fargate profiles attached to the cluster, you must delete them first. For more information, see <code>DeleteNodegroup</code> and <code>DeleteFargateProfile</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_cluster_input::Builder,
    }
    impl DeleteCluster {
        /// Creates a new `DeleteCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the cluster to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFargateProfile`.
    ///
    /// <p>Deletes an Fargate profile.</p>
    /// <p>When you delete a Fargate profile, any pods running on Fargate that were created with the profile are deleted. If those pods match another Fargate profile, then they are scheduled on Fargate with that profile. If they no longer match any Fargate profiles, then they are not scheduled on Fargate and they may remain in a pending state.</p>
    /// <p>Only one Fargate profile in a cluster can be in the <code>DELETING</code> status at a time. You must wait for a Fargate profile to finish deleting before you can delete any other profiles in that cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFargateProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_fargate_profile_input::Builder,
    }
    impl DeleteFargateProfile {
        /// Creates a new `DeleteFargateProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFargateProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFargateProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon EKS cluster associated with the Fargate profile to delete.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the Amazon EKS cluster associated with the Fargate profile to delete.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The name of the Fargate profile to delete.</p>
        pub fn fargate_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fargate_profile_name(input.into());
            self
        }
        /// <p>The name of the Fargate profile to delete.</p>
        pub fn set_fargate_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_fargate_profile_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNodegroup`.
    ///
    /// <p>Deletes an Amazon EKS node group for a cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteNodegroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_nodegroup_input::Builder,
    }
    impl DeleteNodegroup {
        /// Creates a new `DeleteNodegroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNodegroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNodegroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon EKS cluster that is associated with your node group.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the Amazon EKS cluster that is associated with your node group.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The name of the node group to delete.</p>
        pub fn nodegroup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.nodegroup_name(input.into());
            self
        }
        /// <p>The name of the node group to delete.</p>
        pub fn set_nodegroup_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_nodegroup_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterCluster`.
    ///
    /// <p>Deregisters a connected cluster to remove it from the Amazon EKS control plane.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deregister_cluster_input::Builder,
    }
    impl DeregisterCluster {
        /// Creates a new `DeregisterCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the connected cluster to deregister.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the connected cluster to deregister.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAddon`.
    ///
    /// <p>Describes an Amazon EKS add-on.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAddon {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_addon_input::Builder,
    }
    impl DescribeAddon {
        /// Creates a new `DescribeAddon`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAddonOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAddonError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the cluster.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>
        pub fn addon_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.addon_name(input.into());
            self
        }
        /// <p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>
        pub fn set_addon_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_addon_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAddonVersions`.
    ///
    /// <p>Describes the Kubernetes versions that the add-on can be used with.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAddonVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_addon_versions_input::Builder,
    }
    impl DescribeAddonVersions {
        /// Creates a new `DescribeAddonVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAddonVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAddonVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeAddonVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeAddonVersionsPaginator {
            crate::paginator::DescribeAddonVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Kubernetes versions that the add-on can be used with.</p>
        pub fn kubernetes_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kubernetes_version(input.into());
            self
        }
        /// <p>The Kubernetes versions that the add-on can be used with.</p>
        pub fn set_kubernetes_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_kubernetes_version(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeAddonVersionsRequest</code> where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeAddonVersionsRequest</code> where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>
        pub fn addon_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.addon_name(input.into());
            self
        }
        /// <p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>
        pub fn set_addon_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_addon_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCluster`.
    ///
    /// <p>Returns descriptive information about an Amazon EKS cluster.</p>
    /// <p>The API server endpoint and certificate authority data returned by this operation are required for <code>kubelet</code> and <code>kubectl</code> to communicate with your Kubernetes API server. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html">Create a kubeconfig for Amazon EKS</a>.</p> <note>
    /// <p>The API server endpoint and certificate authority data aren't available until the cluster reaches the <code>ACTIVE</code> state.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cluster_input::Builder,
    }
    impl DescribeCluster {
        /// Creates a new `DescribeCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster to describe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the cluster to describe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFargateProfile`.
    ///
    /// <p>Returns descriptive information about an Fargate profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFargateProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_fargate_profile_input::Builder,
    }
    impl DescribeFargateProfile {
        /// Creates a new `DescribeFargateProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFargateProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFargateProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon EKS cluster associated with the Fargate profile.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the Amazon EKS cluster associated with the Fargate profile.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The name of the Fargate profile to describe.</p>
        pub fn fargate_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fargate_profile_name(input.into());
            self
        }
        /// <p>The name of the Fargate profile to describe.</p>
        pub fn set_fargate_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_fargate_profile_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIdentityProviderConfig`.
    ///
    /// <p>Returns descriptive information about an identity provider configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeIdentityProviderConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_identity_provider_config_input::Builder,
    }
    impl DescribeIdentityProviderConfig {
        /// Creates a new `DescribeIdentityProviderConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIdentityProviderConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIdentityProviderConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster name that the identity provider configuration is associated to.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The cluster name that the identity provider configuration is associated to.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>An object that represents an identity provider configuration.</p>
        pub fn identity_provider_config(
            mut self,
            input: crate::model::IdentityProviderConfig,
        ) -> Self {
            self.inner = self.inner.identity_provider_config(input);
            self
        }
        /// <p>An object that represents an identity provider configuration.</p>
        pub fn set_identity_provider_config(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderConfig>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNodegroup`.
    ///
    /// <p>Returns descriptive information about an Amazon EKS node group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeNodegroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_nodegroup_input::Builder,
    }
    impl DescribeNodegroup {
        /// Creates a new `DescribeNodegroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNodegroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeNodegroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon EKS cluster associated with the node group.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the Amazon EKS cluster associated with the node group.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The name of the node group to describe.</p>
        pub fn nodegroup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.nodegroup_name(input.into());
            self
        }
        /// <p>The name of the node group to describe.</p>
        pub fn set_nodegroup_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_nodegroup_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUpdate`.
    ///
    /// <p>Returns descriptive information about an update against your Amazon EKS cluster or associated managed node group.</p>
    /// <p>When the status of the update is <code>Succeeded</code>, the update is complete. If an update fails, the status is <code>Failed</code>, and an error detail explains the reason for the failure.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUpdate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_update_input::Builder,
    }
    impl DescribeUpdate {
        /// Creates a new `DescribeUpdate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUpdateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUpdateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon EKS cluster associated with the update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Amazon EKS cluster associated with the update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The ID of the update to describe.</p>
        pub fn update_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.update_id(input.into());
            self
        }
        /// <p>The ID of the update to describe.</p>
        pub fn set_update_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_update_id(input);
            self
        }
        /// <p>The name of the Amazon EKS node group associated with the update.</p>
        pub fn nodegroup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.nodegroup_name(input.into());
            self
        }
        /// <p>The name of the Amazon EKS node group associated with the update.</p>
        pub fn set_nodegroup_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_nodegroup_name(input);
            self
        }
        /// <p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>
        pub fn addon_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.addon_name(input.into());
            self
        }
        /// <p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>
        pub fn set_addon_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_addon_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateIdentityProviderConfig`.
    ///
    /// <p>Disassociates an identity provider configuration from a cluster. If you disassociate an identity provider from your cluster, users included in the provider can no longer access the cluster. However, you can still access the cluster with Amazon Web Services IAM users.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateIdentityProviderConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_identity_provider_config_input::Builder,
    }
    impl DisassociateIdentityProviderConfig {
        /// Creates a new `DisassociateIdentityProviderConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateIdentityProviderConfigOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateIdentityProviderConfigError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster to disassociate an identity provider from.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the cluster to disassociate an identity provider from.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>An object that represents an identity provider configuration.</p>
        pub fn identity_provider_config(
            mut self,
            input: crate::model::IdentityProviderConfig,
        ) -> Self {
            self.inner = self.inner.identity_provider_config(input);
            self
        }
        /// <p>An object that represents an identity provider configuration.</p>
        pub fn set_identity_provider_config(
            mut self,
            input: std::option::Option<crate::model::IdentityProviderConfig>,
        ) -> Self {
            self.inner = self.inner.set_identity_provider_config(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAddons`.
    ///
    /// <p>Lists the available add-ons.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAddons {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_addons_input::Builder,
    }
    impl ListAddons {
        /// Creates a new `ListAddons`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAddonsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAddonsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAddonsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAddonsPaginator {
            crate::paginator::ListAddonsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the cluster.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the cluster.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The maximum number of add-on results returned by <code>ListAddonsRequest</code> in paginated output. When you use this parameter, <code>ListAddonsRequest</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListAddonsRequest</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListAddonsRequest</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of add-on results returned by <code>ListAddonsRequest</code> in paginated output. When you use this parameter, <code>ListAddonsRequest</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListAddonsRequest</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListAddonsRequest</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListAddonsRequest</code> where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListAddonsRequest</code> where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListClusters`.
    ///
    /// <p>Lists the Amazon EKS clusters in your Amazon Web Services account in the specified Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListClusters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_clusters_input::Builder,
    }
    impl ListClusters {
        /// Creates a new `ListClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListClustersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListClustersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListClustersPaginator {
            crate::paginator::ListClustersPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of cluster results returned by <code>ListClusters</code> in paginated output. When you use this parameter, <code>ListClusters</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListClusters</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListClusters</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of cluster results returned by <code>ListClusters</code> in paginated output. When you use this parameter, <code>ListClusters</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListClusters</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListClusters</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListClusters</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListClusters</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `include`.
        ///
        /// To override the contents of this collection use [`set_include`](Self::set_include).
        ///
        /// <p>Indicates whether external clusters are included in the returned list. Use '<code>all</code>' to return connected clusters, or blank to return only Amazon EKS clusters. '<code>all</code>' must be in lowercase otherwise an error occurs.</p>
        pub fn include(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.include(input.into());
            self
        }
        /// <p>Indicates whether external clusters are included in the returned list. Use '<code>all</code>' to return connected clusters, or blank to return only Amazon EKS clusters. '<code>all</code>' must be in lowercase otherwise an error occurs.</p>
        pub fn set_include(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_include(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFargateProfiles`.
    ///
    /// <p>Lists the Fargate profiles associated with the specified cluster in your Amazon Web Services account in the specified Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFargateProfiles {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_fargate_profiles_input::Builder,
    }
    impl ListFargateProfiles {
        /// Creates a new `ListFargateProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFargateProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFargateProfilesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFargateProfilesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFargateProfilesPaginator {
            crate::paginator::ListFargateProfilesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the Amazon EKS cluster that you would like to list Fargate profiles in.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the Amazon EKS cluster that you would like to list Fargate profiles in.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The maximum number of Fargate profile results returned by <code>ListFargateProfiles</code> in paginated output. When you use this parameter, <code>ListFargateProfiles</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListFargateProfiles</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListFargateProfiles</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of Fargate profile results returned by <code>ListFargateProfiles</code> in paginated output. When you use this parameter, <code>ListFargateProfiles</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListFargateProfiles</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListFargateProfiles</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListFargateProfiles</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListFargateProfiles</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIdentityProviderConfigs`.
    ///
    /// <p>A list of identity provider configurations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIdentityProviderConfigs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_identity_provider_configs_input::Builder,
    }
    impl ListIdentityProviderConfigs {
        /// Creates a new `ListIdentityProviderConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIdentityProviderConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIdentityProviderConfigsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListIdentityProviderConfigsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListIdentityProviderConfigsPaginator {
            crate::paginator::ListIdentityProviderConfigsPaginator::new(self.handle, self.inner)
        }
        /// <p>The cluster name that you want to list identity provider configurations for.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The cluster name that you want to list identity provider configurations for.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The maximum number of identity provider configurations returned by <code>ListIdentityProviderConfigs</code> in paginated output. When you use this parameter, <code>ListIdentityProviderConfigs</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListIdentityProviderConfigs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListIdentityProviderConfigs</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of identity provider configurations returned by <code>ListIdentityProviderConfigs</code> in paginated output. When you use this parameter, <code>ListIdentityProviderConfigs</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListIdentityProviderConfigs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListIdentityProviderConfigs</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>IdentityProviderConfigsRequest</code> where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>IdentityProviderConfigsRequest</code> where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNodegroups`.
    ///
    /// <p>Lists the Amazon EKS managed node groups associated with the specified cluster in your Amazon Web Services account in the specified Region. Self-managed node groups are not listed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListNodegroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_nodegroups_input::Builder,
    }
    impl ListNodegroups {
        /// Creates a new `ListNodegroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNodegroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNodegroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListNodegroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListNodegroupsPaginator {
            crate::paginator::ListNodegroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the Amazon EKS cluster that you would like to list node groups in.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the Amazon EKS cluster that you would like to list node groups in.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The maximum number of node group results returned by <code>ListNodegroups</code> in paginated output. When you use this parameter, <code>ListNodegroups</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListNodegroups</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListNodegroups</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of node group results returned by <code>ListNodegroups</code> in paginated output. When you use this parameter, <code>ListNodegroups</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListNodegroups</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListNodegroups</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListNodegroups</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListNodegroups</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List the tags for an Amazon EKS resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are Amazon EKS clusters and managed node groups.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are Amazon EKS clusters and managed node groups.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUpdates`.
    ///
    /// <p>Lists the updates associated with an Amazon EKS cluster or managed node group in your Amazon Web Services account, in the specified Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUpdates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_updates_input::Builder,
    }
    impl ListUpdates {
        /// Creates a new `ListUpdates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUpdatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUpdatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListUpdatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListUpdatesPaginator {
            crate::paginator::ListUpdatesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the Amazon EKS cluster to list updates for.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Amazon EKS cluster to list updates for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the Amazon EKS managed node group to list updates for.</p>
        pub fn nodegroup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.nodegroup_name(input.into());
            self
        }
        /// <p>The name of the Amazon EKS managed node group to list updates for.</p>
        pub fn set_nodegroup_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_nodegroup_name(input);
            self
        }
        /// <p>The names of the installed add-ons that have available updates.</p>
        pub fn addon_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.addon_name(input.into());
            self
        }
        /// <p>The names of the installed add-ons that have available updates.</p>
        pub fn set_addon_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_addon_name(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListUpdates</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListUpdates</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of update results returned by <code>ListUpdates</code> in paginated output. When you use this parameter, <code>ListUpdates</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListUpdates</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListUpdates</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of update results returned by <code>ListUpdates</code> in paginated output. When you use this parameter, <code>ListUpdates</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListUpdates</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListUpdates</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterCluster`.
    ///
    /// <p>Connects a Kubernetes cluster to the Amazon EKS control plane. </p>
    /// <p>Any Kubernetes cluster can be connected to the Amazon EKS control plane to view current information about the cluster and its nodes. </p>
    /// <p>Cluster connection requires two steps. First, send a <code> <code>RegisterClusterRequest</code> </code> to add it to the Amazon EKS control plane.</p>
    /// <p>Second, a <a href="https://amazon-eks.s3.us-west-2.amazonaws.com/eks-connector/manifests/eks-connector/latest/eks-connector.yaml">Manifest</a> containing the <code>activationID</code> and <code>activationCode</code> must be applied to the Kubernetes cluster through it's native provider to provide visibility.</p>
    /// <p>After the Manifest is updated and applied, then the connected cluster is visible to the Amazon EKS control plane. If the Manifest is not applied within three days, then the connected cluster will no longer be visible and must be deregistered. See <code>DeregisterCluster</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_cluster_input::Builder,
    }
    impl RegisterCluster {
        /// Creates a new `RegisterCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Define a unique name for this cluster for your Region.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Define a unique name for this cluster for your Region.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The configuration settings required to connect the Kubernetes cluster to the Amazon EKS control plane.</p>
        pub fn connector_config(mut self, input: crate::model::ConnectorConfigRequest) -> Self {
            self.inner = self.inner.connector_config(input);
            self
        }
        /// <p>The configuration settings required to connect the Kubernetes cluster to the Amazon EKS control plane.</p>
        pub fn set_connector_config(
            mut self,
            input: std::option::Option<crate::model::ConnectorConfigRequest>,
        ) -> Self {
            self.inner = self.inner.set_connector_config(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Cluster tags do not propagate to any other resources associated with the cluster.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The metadata that you apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Cluster tags do not propagate to any other resources associated with the cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well. Tags that you create for Amazon EKS resources do not propagate to any other resources associated with the cluster. For example, if you tag a cluster with this operation, that tag does not automatically propagate to the subnets and nodes associated with the cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which to add tags. Currently, the supported resources are Amazon EKS clusters and managed node groups.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which to add tags. Currently, the supported resources are Amazon EKS clusters and managed node groups.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes specified tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which to delete tags. Currently, the supported resources are Amazon EKS clusters and managed node groups.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which to delete tags. Currently, the supported resources are Amazon EKS clusters and managed node groups.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAddon`.
    ///
    /// <p>Updates an Amazon EKS add-on.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAddon {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_addon_input::Builder,
    }
    impl UpdateAddon {
        /// Creates a new `UpdateAddon`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAddonOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAddonError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the cluster.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>
        pub fn addon_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.addon_name(input.into());
            self
        }
        /// <p>The name of the add-on. The name must match one of the names returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html"> <code>ListAddons</code> </a>.</p>
        pub fn set_addon_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_addon_name(input);
            self
        }
        /// <p>The version of the add-on. The version must match one of the versions returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html"> <code>DescribeAddonVersions</code> </a>.</p>
        pub fn addon_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.addon_version(input.into());
            self
        }
        /// <p>The version of the add-on. The version must match one of the versions returned by <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html"> <code>DescribeAddonVersions</code> </a>.</p>
        pub fn set_addon_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_addon_version(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM role</a> in the <i>Amazon EKS User Guide</i>.</p> <note>
        /// <p>To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html">Enabling IAM roles for service accounts on your cluster</a> in the <i>Amazon EKS User Guide</i>.</p>
        /// </note>
        pub fn service_account_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_account_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html">Amazon EKS node IAM role</a> in the <i>Amazon EKS User Guide</i>.</p> <note>
        /// <p>To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html">Enabling IAM roles for service accounts on your cluster</a> in the <i>Amazon EKS User Guide</i>.</p>
        /// </note>
        pub fn set_service_account_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_account_role_arn(input);
            self
        }
        /// <p>How to resolve parameter value conflicts when applying the new version of the add-on to the cluster.</p>
        pub fn resolve_conflicts(mut self, input: crate::model::ResolveConflicts) -> Self {
            self.inner = self.inner.resolve_conflicts(input);
            self
        }
        /// <p>How to resolve parameter value conflicts when applying the new version of the add-on to the cluster.</p>
        pub fn set_resolve_conflicts(
            mut self,
            input: std::option::Option<crate::model::ResolveConflicts>,
        ) -> Self {
            self.inner = self.inner.set_resolve_conflicts(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateClusterConfig`.
    ///
    /// <p>Updates an Amazon EKS cluster configuration. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with the <code>DescribeUpdate</code> API operation.</p>
    /// <p>You can use this API operation to enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster Control Plane Logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note>
    /// <p>CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.</p>
    /// </note>
    /// <p>You can also use this API operation to enable or disable public and private access to your cluster's Kubernetes API server endpoint. By default, public access is enabled, and private access is disabled. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster endpoint access control</a> in the <i> <i>Amazon EKS User Guide</i> </i>. </p> <important>
    /// <p>You can't update the subnets or security group IDs for an existing cluster.</p>
    /// </important>
    /// <p>Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster status moves to <code>UPDATING</code> (this status transition is eventually consistent). When the update is complete (either <code>Failed</code> or <code>Successful</code>), the cluster status moves to <code>Active</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateClusterConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_cluster_config_input::Builder,
    }
    impl UpdateClusterConfig {
        /// Creates a new `UpdateClusterConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateClusterConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateClusterConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon EKS cluster to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Amazon EKS cluster to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An object representing the VPC configuration to use for an Amazon EKS cluster.</p>
        pub fn resources_vpc_config(mut self, input: crate::model::VpcConfigRequest) -> Self {
            self.inner = self.inner.resources_vpc_config(input);
            self
        }
        /// <p>An object representing the VPC configuration to use for an Amazon EKS cluster.</p>
        pub fn set_resources_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfigRequest>,
        ) -> Self {
            self.inner = self.inner.set_resources_vpc_config(input);
            self
        }
        /// <p>Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS cluster control plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note>
        /// <p>CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.</p>
        /// </note>
        pub fn logging(mut self, input: crate::model::Logging) -> Self {
            self.inner = self.inner.logging(input);
            self
        }
        /// <p>Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS cluster control plane logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note>
        /// <p>CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">CloudWatch Pricing</a>.</p>
        /// </note>
        pub fn set_logging(mut self, input: std::option::Option<crate::model::Logging>) -> Self {
            self.inner = self.inner.set_logging(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateClusterVersion`.
    ///
    /// <p>Updates an Amazon EKS cluster to the specified Kubernetes version. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with the <code>DescribeUpdate</code> API operation.</p>
    /// <p>Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster status moves to <code>UPDATING</code> (this status transition is eventually consistent). When the update is complete (either <code>Failed</code> or <code>Successful</code>), the cluster status moves to <code>Active</code>.</p>
    /// <p>If your cluster has managed node groups attached to it, all of your node groups’ Kubernetes versions must match the cluster’s Kubernetes version in order to update the cluster to a new Kubernetes version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateClusterVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_cluster_version_input::Builder,
    }
    impl UpdateClusterVersion {
        /// Creates a new `UpdateClusterVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateClusterVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateClusterVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon EKS cluster to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Amazon EKS cluster to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The desired Kubernetes version following a successful update.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The desired Kubernetes version following a successful update.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNodegroupConfig`.
    ///
    /// <p>Updates an Amazon EKS managed node group configuration. Your node group continues to function during the update. The response output includes an update ID that you can use to track the status of your node group update with the <code>DescribeUpdate</code> API operation. Currently you can update the Kubernetes labels for a node group or the scaling configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateNodegroupConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_nodegroup_config_input::Builder,
    }
    impl UpdateNodegroupConfig {
        /// Creates a new `UpdateNodegroupConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNodegroupConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNodegroupConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon EKS cluster that the managed node group resides in.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the Amazon EKS cluster that the managed node group resides in.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The name of the managed node group to update.</p>
        pub fn nodegroup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.nodegroup_name(input.into());
            self
        }
        /// <p>The name of the managed node group to update.</p>
        pub fn set_nodegroup_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_nodegroup_name(input);
            self
        }
        /// <p>The Kubernetes labels to be applied to the nodes in the node group after the update.</p>
        pub fn labels(mut self, input: crate::model::UpdateLabelsPayload) -> Self {
            self.inner = self.inner.labels(input);
            self
        }
        /// <p>The Kubernetes labels to be applied to the nodes in the node group after the update.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<crate::model::UpdateLabelsPayload>,
        ) -> Self {
            self.inner = self.inner.set_labels(input);
            self
        }
        /// <p>The Kubernetes taints to be applied to the nodes in the node group after the update.</p>
        pub fn taints(mut self, input: crate::model::UpdateTaintsPayload) -> Self {
            self.inner = self.inner.taints(input);
            self
        }
        /// <p>The Kubernetes taints to be applied to the nodes in the node group after the update.</p>
        pub fn set_taints(
            mut self,
            input: std::option::Option<crate::model::UpdateTaintsPayload>,
        ) -> Self {
            self.inner = self.inner.set_taints(input);
            self
        }
        /// <p>The scaling configuration details for the Auto Scaling group after the update.</p>
        pub fn scaling_config(mut self, input: crate::model::NodegroupScalingConfig) -> Self {
            self.inner = self.inner.scaling_config(input);
            self
        }
        /// <p>The scaling configuration details for the Auto Scaling group after the update.</p>
        pub fn set_scaling_config(
            mut self,
            input: std::option::Option<crate::model::NodegroupScalingConfig>,
        ) -> Self {
            self.inner = self.inner.set_scaling_config(input);
            self
        }
        /// <p>The node group update configuration.</p>
        pub fn update_config(mut self, input: crate::model::NodegroupUpdateConfig) -> Self {
            self.inner = self.inner.update_config(input);
            self
        }
        /// <p>The node group update configuration.</p>
        pub fn set_update_config(
            mut self,
            input: std::option::Option<crate::model::NodegroupUpdateConfig>,
        ) -> Self {
            self.inner = self.inner.set_update_config(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNodegroupVersion`.
    ///
    /// <p>Updates the Kubernetes version or AMI version of an Amazon EKS managed node group.</p>
    /// <p>You can update a node group using a launch template only if the node group was originally deployed with a launch template. If you need to update a custom AMI in a node group that was deployed with a launch template, then update your custom AMI, specify the new ID in a new version of the launch template, and then update the node group to the new version of the launch template.</p>
    /// <p>If you update without a launch template, then you can update to the latest available AMI version of a node group's current Kubernetes version by not specifying a Kubernetes version in the request. You can update to the latest AMI version of your cluster's current Kubernetes version by specifying your cluster's Kubernetes version in the request. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized Amazon Linux 2 AMI versions</a> in the <i>Amazon EKS User Guide</i>.</p>
    /// <p>You cannot roll back a node group to an earlier Kubernetes version or AMI version.</p>
    /// <p>When a node in a managed node group is terminated due to a scaling action or update, the pods in that node are drained first. Amazon EKS attempts to drain the nodes gracefully and will fail if it is unable to do so. You can <code>force</code> the update if Amazon EKS is unable to drain the nodes as a result of a pod disruption budget issue.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateNodegroupVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_nodegroup_version_input::Builder,
    }
    impl UpdateNodegroupVersion {
        /// Creates a new `UpdateNodegroupVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNodegroupVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNodegroupVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon EKS cluster that is associated with the managed node group to update.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of the Amazon EKS cluster that is associated with the managed node group to update.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// <p>The name of the managed node group to update.</p>
        pub fn nodegroup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.nodegroup_name(input.into());
            self
        }
        /// <p>The name of the managed node group to update.</p>
        pub fn set_nodegroup_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_nodegroup_name(input);
            self
        }
        /// <p>The Kubernetes version to update to. If no version is specified, then the Kubernetes version of the node group does not change. You can specify the Kubernetes version of the cluster to update the node group to the latest AMI version of the cluster's Kubernetes version. If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify <code>version</code>, or the node group update will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The Kubernetes version to update to. If no version is specified, then the Kubernetes version of the node group does not change. You can specify the Kubernetes version of the cluster to update the node group to the latest AMI version of the cluster's Kubernetes version. If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify <code>version</code>, or the node group update will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
        /// <p>The AMI version of the Amazon EKS optimized AMI to use for the update. By default, the latest available AMI version for the node group's Kubernetes version is used. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized Amazon Linux 2 AMI versions </a> in the <i>Amazon EKS User Guide</i>. If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify <code>releaseVersion</code>, or the node group update will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
        pub fn release_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.release_version(input.into());
            self
        }
        /// <p>The AMI version of the Amazon EKS optimized AMI to use for the update. By default, the latest available AMI version for the node group's Kubernetes version is used. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS optimized Amazon Linux 2 AMI versions </a> in the <i>Amazon EKS User Guide</i>. If you specify <code>launchTemplate</code>, and your launch template uses a custom AMI, then don't specify <code>releaseVersion</code>, or the node group update will fail. For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
        pub fn set_release_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_release_version(input);
            self
        }
        /// <p>An object representing a node group's launch template specification. You can only update a node group using a launch template if the node group was originally deployed with a launch template.</p>
        pub fn launch_template(mut self, input: crate::model::LaunchTemplateSpecification) -> Self {
            self.inner = self.inner.launch_template(input);
            self
        }
        /// <p>An object representing a node group's launch template specification. You can only update a node group using a launch template if the node group was originally deployed with a launch template.</p>
        pub fn set_launch_template(
            mut self,
            input: std::option::Option<crate::model::LaunchTemplateSpecification>,
        ) -> Self {
            self.inner = self.inner.set_launch_template(input);
            self
        }
        /// <p>Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue. If an update fails because pods could not be drained, you can force the update after it fails to terminate the old node whether or not any pods are running on the node.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue. If an update fails because pods could not be drained, you can force the update after it fails to terminate the old node whether or not any pods are running on the node.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
