// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>An object representing an asynchronous update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Update {
    /// <p>A UUID that is used to track the update.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The current status of the update.</p>
    pub status: std::option::Option<crate::model::UpdateStatus>,
    /// <p>The type of the update.</p>
    pub r#type: std::option::Option<crate::model::UpdateType>,
    /// <p>A key-value map that contains the parameters associated with the update.</p>
    pub params: std::option::Option<std::vec::Vec<crate::model::UpdateParam>>,
    /// <p>The Unix epoch timestamp in seconds for when the update was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Any errors associated with a <code>Failed</code> update.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::ErrorDetail>>,
}
impl std::fmt::Debug for Update {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Update");
        formatter.field("id", &self.id);
        formatter.field("status", &self.status);
        formatter.field("r#type", &self.r#type);
        formatter.field("params", &self.params);
        formatter.field("created_at", &self.created_at);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`Update`](crate::model::Update)
pub mod update {
    /// A builder for [`Update`](crate::model::Update)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::UpdateStatus>,
        pub(crate) r#type: std::option::Option<crate::model::UpdateType>,
        pub(crate) params: std::option::Option<std::vec::Vec<crate::model::UpdateParam>>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::ErrorDetail>>,
    }
    impl Builder {
        /// <p>A UUID that is used to track the update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>A UUID that is used to track the update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The current status of the update.</p>
        pub fn status(mut self, input: crate::model::UpdateStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the update.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::UpdateStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The type of the update.</p>
        pub fn r#type(mut self, input: crate::model::UpdateType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the update.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::UpdateType>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `params`.
        ///
        /// To override the contents of this collection use [`set_params`](Self::set_params).
        ///
        /// <p>A key-value map that contains the parameters associated with the update.</p>
        pub fn params(mut self, input: impl Into<crate::model::UpdateParam>) -> Self {
            let mut v = self.params.unwrap_or_default();
            v.push(input.into());
            self.params = Some(v);
            self
        }
        /// <p>A key-value map that contains the parameters associated with the update.</p>
        pub fn set_params(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateParam>>,
        ) -> Self {
            self.params = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the update was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the update was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Any errors associated with a <code>Failed</code> update.</p>
        pub fn errors(mut self, input: impl Into<crate::model::ErrorDetail>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>Any errors associated with a <code>Failed</code> update.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ErrorDetail>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`Update`](crate::model::Update)
        pub fn build(self) -> crate::model::Update {
            crate::model::Update {
                id: self.id,
                status: self.status,
                r#type: self.r#type,
                params: self.params,
                created_at: self.created_at,
                errors: self.errors,
            }
        }
    }
}
impl Update {
    /// Creates a new builder-style object to manufacture [`Update`](crate::model::Update)
    pub fn builder() -> crate::model::update::Builder {
        crate::model::update::Builder::default()
    }
}

/// <p>An object representing an error when an asynchronous operation fails.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorDetail {
    /// <p>A brief description of the error. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>SubnetNotFound</b>: We couldn't find one of the
    /// subnets associated with the cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>SecurityGroupNotFound</b>: We couldn't find one
    /// of the security groups associated with the cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>EniLimitReached</b>: You have reached the elastic
    /// network interface limit for your account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>IpNotAvailable</b>: A subnet associated with the
    /// cluster doesn't have any free IP addresses.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>AccessDenied</b>: You don't have permissions to
    /// perform the specified operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>OperationNotPermitted</b>: The service role
    /// associated with the cluster doesn't have the required access permissions for
    /// Amazon EKS.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>VpcIdNotFound</b>: We couldn't find the VPC
    /// associated with the cluster.</p>
    /// </li>
    /// </ul>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
    /// <p>A more complete description of the error.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>An optional field that contains the resource IDs associated with the error.</p>
    pub resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ErrorDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorDetail");
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.field("resource_ids", &self.resource_ids);
        formatter.finish()
    }
}
/// See [`ErrorDetail`](crate::model::ErrorDetail)
pub mod error_detail {
    /// A builder for [`ErrorDetail`](crate::model::ErrorDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A brief description of the error. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>SubnetNotFound</b>: We couldn't find one of the
        /// subnets associated with the cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>SecurityGroupNotFound</b>: We couldn't find one
        /// of the security groups associated with the cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EniLimitReached</b>: You have reached the elastic
        /// network interface limit for your account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>IpNotAvailable</b>: A subnet associated with the
        /// cluster doesn't have any free IP addresses.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AccessDenied</b>: You don't have permissions to
        /// perform the specified operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>OperationNotPermitted</b>: The service role
        /// associated with the cluster doesn't have the required access permissions for
        /// Amazon EKS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>VpcIdNotFound</b>: We couldn't find the VPC
        /// associated with the cluster.</p>
        /// </li>
        /// </ul>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>A brief description of the error. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>SubnetNotFound</b>: We couldn't find one of the
        /// subnets associated with the cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>SecurityGroupNotFound</b>: We couldn't find one
        /// of the security groups associated with the cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EniLimitReached</b>: You have reached the elastic
        /// network interface limit for your account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>IpNotAvailable</b>: A subnet associated with the
        /// cluster doesn't have any free IP addresses.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AccessDenied</b>: You don't have permissions to
        /// perform the specified operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>OperationNotPermitted</b>: The service role
        /// associated with the cluster doesn't have the required access permissions for
        /// Amazon EKS.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>VpcIdNotFound</b>: We couldn't find the VPC
        /// associated with the cluster.</p>
        /// </li>
        /// </ul>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>A more complete description of the error.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>A more complete description of the error.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Appends an item to `resource_ids`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>An optional field that contains the resource IDs associated with the error.</p>
        pub fn resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_ids.unwrap_or_default();
            v.push(input.into());
            self.resource_ids = Some(v);
            self
        }
        /// <p>An optional field that contains the resource IDs associated with the error.</p>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorDetail`](crate::model::ErrorDetail)
        pub fn build(self) -> crate::model::ErrorDetail {
            crate::model::ErrorDetail {
                error_code: self.error_code,
                error_message: self.error_message,
                resource_ids: self.resource_ids,
            }
        }
    }
}
impl ErrorDetail {
    /// Creates a new builder-style object to manufacture [`ErrorDetail`](crate::model::ErrorDetail)
    pub fn builder() -> crate::model::error_detail::Builder {
        crate::model::error_detail::Builder::default()
    }
}

/// _Note: `ErrorCode::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    AdmissionRequestDenied,
    #[allow(missing_docs)] // documentation missing in model
    ClusterUnreachable,
    #[allow(missing_docs)] // documentation missing in model
    ConfigurationConflict,
    #[allow(missing_docs)] // documentation missing in model
    EniLimitReached,
    #[allow(missing_docs)] // documentation missing in model
    InsufficientFreeAddresses,
    #[allow(missing_docs)] // documentation missing in model
    InsufficientNumberOfReplicas,
    #[allow(missing_docs)] // documentation missing in model
    IpNotAvailable,
    #[allow(missing_docs)] // documentation missing in model
    K8SResourceNotFound,
    #[allow(missing_docs)] // documentation missing in model
    NodeCreationFailure,
    #[allow(missing_docs)] // documentation missing in model
    OperationNotPermitted,
    #[allow(missing_docs)] // documentation missing in model
    PodEvictionFailure,
    #[allow(missing_docs)] // documentation missing in model
    SecurityGroupNotFound,
    #[allow(missing_docs)] // documentation missing in model
    SubnetNotFound,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    #[allow(missing_docs)] // documentation missing in model
    UnsupportedAddonModification,
    #[allow(missing_docs)] // documentation missing in model
    VpcIdNotFound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "AccessDenied" => ErrorCode::AccessDenied,
            "AdmissionRequestDenied" => ErrorCode::AdmissionRequestDenied,
            "ClusterUnreachable" => ErrorCode::ClusterUnreachable,
            "ConfigurationConflict" => ErrorCode::ConfigurationConflict,
            "EniLimitReached" => ErrorCode::EniLimitReached,
            "InsufficientFreeAddresses" => ErrorCode::InsufficientFreeAddresses,
            "InsufficientNumberOfReplicas" => ErrorCode::InsufficientNumberOfReplicas,
            "IpNotAvailable" => ErrorCode::IpNotAvailable,
            "K8sResourceNotFound" => ErrorCode::K8SResourceNotFound,
            "NodeCreationFailure" => ErrorCode::NodeCreationFailure,
            "OperationNotPermitted" => ErrorCode::OperationNotPermitted,
            "PodEvictionFailure" => ErrorCode::PodEvictionFailure,
            "SecurityGroupNotFound" => ErrorCode::SecurityGroupNotFound,
            "SubnetNotFound" => ErrorCode::SubnetNotFound,
            "Unknown" => ErrorCode::UnknownValue,
            "UnsupportedAddonModification" => ErrorCode::UnsupportedAddonModification,
            "VpcIdNotFound" => ErrorCode::VpcIdNotFound,
            other => ErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorCode::from(s))
    }
}
impl ErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorCode::AccessDenied => "AccessDenied",
            ErrorCode::AdmissionRequestDenied => "AdmissionRequestDenied",
            ErrorCode::ClusterUnreachable => "ClusterUnreachable",
            ErrorCode::ConfigurationConflict => "ConfigurationConflict",
            ErrorCode::EniLimitReached => "EniLimitReached",
            ErrorCode::InsufficientFreeAddresses => "InsufficientFreeAddresses",
            ErrorCode::InsufficientNumberOfReplicas => "InsufficientNumberOfReplicas",
            ErrorCode::IpNotAvailable => "IpNotAvailable",
            ErrorCode::K8SResourceNotFound => "K8sResourceNotFound",
            ErrorCode::NodeCreationFailure => "NodeCreationFailure",
            ErrorCode::OperationNotPermitted => "OperationNotPermitted",
            ErrorCode::PodEvictionFailure => "PodEvictionFailure",
            ErrorCode::SecurityGroupNotFound => "SecurityGroupNotFound",
            ErrorCode::SubnetNotFound => "SubnetNotFound",
            ErrorCode::UnknownValue => "Unknown",
            ErrorCode::UnsupportedAddonModification => "UnsupportedAddonModification",
            ErrorCode::VpcIdNotFound => "VpcIdNotFound",
            ErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccessDenied",
            "AdmissionRequestDenied",
            "ClusterUnreachable",
            "ConfigurationConflict",
            "EniLimitReached",
            "InsufficientFreeAddresses",
            "InsufficientNumberOfReplicas",
            "IpNotAvailable",
            "K8sResourceNotFound",
            "NodeCreationFailure",
            "OperationNotPermitted",
            "PodEvictionFailure",
            "SecurityGroupNotFound",
            "SubnetNotFound",
            "Unknown",
            "UnsupportedAddonModification",
            "VpcIdNotFound",
        ]
    }
}
impl AsRef<str> for ErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing the details of an update request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateParam {
    /// <p>The keys associated with an update request.</p>
    pub r#type: std::option::Option<crate::model::UpdateParamType>,
    /// <p>The value of the keys submitted as part of an update request.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateParam {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateParam");
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`UpdateParam`](crate::model::UpdateParam)
pub mod update_param {
    /// A builder for [`UpdateParam`](crate::model::UpdateParam)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::UpdateParamType>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The keys associated with an update request.</p>
        pub fn r#type(mut self, input: crate::model::UpdateParamType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The keys associated with an update request.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::UpdateParamType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The value of the keys submitted as part of an update request.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the keys submitted as part of an update request.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateParam`](crate::model::UpdateParam)
        pub fn build(self) -> crate::model::UpdateParam {
            crate::model::UpdateParam {
                r#type: self.r#type,
                value: self.value,
            }
        }
    }
}
impl UpdateParam {
    /// Creates a new builder-style object to manufacture [`UpdateParam`](crate::model::UpdateParam)
    pub fn builder() -> crate::model::update_param::Builder {
        crate::model::update_param::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UpdateParamType {
    #[allow(missing_docs)] // documentation missing in model
    AddonVersion,
    #[allow(missing_docs)] // documentation missing in model
    ClusterLogging,
    #[allow(missing_docs)] // documentation missing in model
    DesiredSize,
    #[allow(missing_docs)] // documentation missing in model
    EncryptionConfig,
    #[allow(missing_docs)] // documentation missing in model
    EndpointPrivateAccess,
    #[allow(missing_docs)] // documentation missing in model
    EndpointPublicAccess,
    #[allow(missing_docs)] // documentation missing in model
    IdentityProviderConfig,
    #[allow(missing_docs)] // documentation missing in model
    LabelsToAdd,
    #[allow(missing_docs)] // documentation missing in model
    LabelsToRemove,
    #[allow(missing_docs)] // documentation missing in model
    LaunchTemplateName,
    #[allow(missing_docs)] // documentation missing in model
    LaunchTemplateVersion,
    #[allow(missing_docs)] // documentation missing in model
    MaxSize,
    #[allow(missing_docs)] // documentation missing in model
    MaxUnavailable,
    #[allow(missing_docs)] // documentation missing in model
    MaxUnavailablePercentage,
    #[allow(missing_docs)] // documentation missing in model
    MinSize,
    #[allow(missing_docs)] // documentation missing in model
    PlatformVersion,
    #[allow(missing_docs)] // documentation missing in model
    PublicAccessCidrs,
    #[allow(missing_docs)] // documentation missing in model
    ReleaseVersion,
    #[allow(missing_docs)] // documentation missing in model
    ResolveConflicts,
    #[allow(missing_docs)] // documentation missing in model
    ServiceAccountRoleArn,
    #[allow(missing_docs)] // documentation missing in model
    TaintsToAdd,
    #[allow(missing_docs)] // documentation missing in model
    TaintsToRemove,
    #[allow(missing_docs)] // documentation missing in model
    Version,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UpdateParamType {
    fn from(s: &str) -> Self {
        match s {
            "AddonVersion" => UpdateParamType::AddonVersion,
            "ClusterLogging" => UpdateParamType::ClusterLogging,
            "DesiredSize" => UpdateParamType::DesiredSize,
            "EncryptionConfig" => UpdateParamType::EncryptionConfig,
            "EndpointPrivateAccess" => UpdateParamType::EndpointPrivateAccess,
            "EndpointPublicAccess" => UpdateParamType::EndpointPublicAccess,
            "IdentityProviderConfig" => UpdateParamType::IdentityProviderConfig,
            "LabelsToAdd" => UpdateParamType::LabelsToAdd,
            "LabelsToRemove" => UpdateParamType::LabelsToRemove,
            "LaunchTemplateName" => UpdateParamType::LaunchTemplateName,
            "LaunchTemplateVersion" => UpdateParamType::LaunchTemplateVersion,
            "MaxSize" => UpdateParamType::MaxSize,
            "MaxUnavailable" => UpdateParamType::MaxUnavailable,
            "MaxUnavailablePercentage" => UpdateParamType::MaxUnavailablePercentage,
            "MinSize" => UpdateParamType::MinSize,
            "PlatformVersion" => UpdateParamType::PlatformVersion,
            "PublicAccessCidrs" => UpdateParamType::PublicAccessCidrs,
            "ReleaseVersion" => UpdateParamType::ReleaseVersion,
            "ResolveConflicts" => UpdateParamType::ResolveConflicts,
            "ServiceAccountRoleArn" => UpdateParamType::ServiceAccountRoleArn,
            "TaintsToAdd" => UpdateParamType::TaintsToAdd,
            "TaintsToRemove" => UpdateParamType::TaintsToRemove,
            "Version" => UpdateParamType::Version,
            other => UpdateParamType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UpdateParamType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UpdateParamType::from(s))
    }
}
impl UpdateParamType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UpdateParamType::AddonVersion => "AddonVersion",
            UpdateParamType::ClusterLogging => "ClusterLogging",
            UpdateParamType::DesiredSize => "DesiredSize",
            UpdateParamType::EncryptionConfig => "EncryptionConfig",
            UpdateParamType::EndpointPrivateAccess => "EndpointPrivateAccess",
            UpdateParamType::EndpointPublicAccess => "EndpointPublicAccess",
            UpdateParamType::IdentityProviderConfig => "IdentityProviderConfig",
            UpdateParamType::LabelsToAdd => "LabelsToAdd",
            UpdateParamType::LabelsToRemove => "LabelsToRemove",
            UpdateParamType::LaunchTemplateName => "LaunchTemplateName",
            UpdateParamType::LaunchTemplateVersion => "LaunchTemplateVersion",
            UpdateParamType::MaxSize => "MaxSize",
            UpdateParamType::MaxUnavailable => "MaxUnavailable",
            UpdateParamType::MaxUnavailablePercentage => "MaxUnavailablePercentage",
            UpdateParamType::MinSize => "MinSize",
            UpdateParamType::PlatformVersion => "PlatformVersion",
            UpdateParamType::PublicAccessCidrs => "PublicAccessCidrs",
            UpdateParamType::ReleaseVersion => "ReleaseVersion",
            UpdateParamType::ResolveConflicts => "ResolveConflicts",
            UpdateParamType::ServiceAccountRoleArn => "ServiceAccountRoleArn",
            UpdateParamType::TaintsToAdd => "TaintsToAdd",
            UpdateParamType::TaintsToRemove => "TaintsToRemove",
            UpdateParamType::Version => "Version",
            UpdateParamType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AddonVersion",
            "ClusterLogging",
            "DesiredSize",
            "EncryptionConfig",
            "EndpointPrivateAccess",
            "EndpointPublicAccess",
            "IdentityProviderConfig",
            "LabelsToAdd",
            "LabelsToRemove",
            "LaunchTemplateName",
            "LaunchTemplateVersion",
            "MaxSize",
            "MaxUnavailable",
            "MaxUnavailablePercentage",
            "MinSize",
            "PlatformVersion",
            "PublicAccessCidrs",
            "ReleaseVersion",
            "ResolveConflicts",
            "ServiceAccountRoleArn",
            "TaintsToAdd",
            "TaintsToRemove",
            "Version",
        ]
    }
}
impl AsRef<str> for UpdateParamType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UpdateType {
    #[allow(missing_docs)] // documentation missing in model
    AddonUpdate,
    #[allow(missing_docs)] // documentation missing in model
    AssociateEncryptionConfig,
    #[allow(missing_docs)] // documentation missing in model
    AssociateIdentityProviderConfig,
    #[allow(missing_docs)] // documentation missing in model
    ConfigUpdate,
    #[allow(missing_docs)] // documentation missing in model
    DisassociateIdentityProviderConfig,
    #[allow(missing_docs)] // documentation missing in model
    EndpointAccessUpdate,
    #[allow(missing_docs)] // documentation missing in model
    LoggingUpdate,
    #[allow(missing_docs)] // documentation missing in model
    VersionUpdate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UpdateType {
    fn from(s: &str) -> Self {
        match s {
            "AddonUpdate" => UpdateType::AddonUpdate,
            "AssociateEncryptionConfig" => UpdateType::AssociateEncryptionConfig,
            "AssociateIdentityProviderConfig" => UpdateType::AssociateIdentityProviderConfig,
            "ConfigUpdate" => UpdateType::ConfigUpdate,
            "DisassociateIdentityProviderConfig" => UpdateType::DisassociateIdentityProviderConfig,
            "EndpointAccessUpdate" => UpdateType::EndpointAccessUpdate,
            "LoggingUpdate" => UpdateType::LoggingUpdate,
            "VersionUpdate" => UpdateType::VersionUpdate,
            other => UpdateType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UpdateType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UpdateType::from(s))
    }
}
impl UpdateType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UpdateType::AddonUpdate => "AddonUpdate",
            UpdateType::AssociateEncryptionConfig => "AssociateEncryptionConfig",
            UpdateType::AssociateIdentityProviderConfig => "AssociateIdentityProviderConfig",
            UpdateType::ConfigUpdate => "ConfigUpdate",
            UpdateType::DisassociateIdentityProviderConfig => "DisassociateIdentityProviderConfig",
            UpdateType::EndpointAccessUpdate => "EndpointAccessUpdate",
            UpdateType::LoggingUpdate => "LoggingUpdate",
            UpdateType::VersionUpdate => "VersionUpdate",
            UpdateType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AddonUpdate",
            "AssociateEncryptionConfig",
            "AssociateIdentityProviderConfig",
            "ConfigUpdate",
            "DisassociateIdentityProviderConfig",
            "EndpointAccessUpdate",
            "LoggingUpdate",
            "VersionUpdate",
        ]
    }
}
impl AsRef<str> for UpdateType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UpdateStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Successful,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UpdateStatus {
    fn from(s: &str) -> Self {
        match s {
            "Cancelled" => UpdateStatus::Cancelled,
            "Failed" => UpdateStatus::Failed,
            "InProgress" => UpdateStatus::InProgress,
            "Successful" => UpdateStatus::Successful,
            other => UpdateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UpdateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UpdateStatus::from(s))
    }
}
impl UpdateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UpdateStatus::Cancelled => "Cancelled",
            UpdateStatus::Failed => "Failed",
            UpdateStatus::InProgress => "InProgress",
            UpdateStatus::Successful => "Successful",
            UpdateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Cancelled", "Failed", "InProgress", "Successful"]
    }
}
impl AsRef<str> for UpdateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing a node group launch template specification. The launch template
/// cannot include <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html">
/// <code>SubnetId</code>
/// </a>, <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html">
/// <code>IamInstanceProfile</code>
/// </a>, <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html">
/// <code>RequestSpotInstances</code>
/// </a>, <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_HibernationOptionsRequest.html">
/// <code>HibernationOptions</code>
/// </a>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TerminateInstances.html">
/// <code>TerminateInstances</code>
/// </a>, or the node group  deployment or
/// update will fail. For more information about launch templates, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html">
/// <code>CreateLaunchTemplate</code>
/// </a> in the Amazon EC2 API Reference.
/// For more information about using launch templates with Amazon EKS, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html">Launch template support</a> in the Amazon EKS User Guide.</p>
/// <p>Specify either <code>name</code> or <code>id</code>, but not both.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchTemplateSpecification {
    /// <p>The name of the launch template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the launch template to use. If no version is specified, then the
    /// template's default version is used.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The ID of the launch template.</p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LaunchTemplateSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchTemplateSpecification");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`LaunchTemplateSpecification`](crate::model::LaunchTemplateSpecification)
pub mod launch_template_specification {
    /// A builder for [`LaunchTemplateSpecification`](crate::model::LaunchTemplateSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the launch template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the launch template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the launch template to use. If no version is specified, then the
        /// template's default version is used.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the launch template to use. If no version is specified, then the
        /// template's default version is used.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The ID of the launch template.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the launch template.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchTemplateSpecification`](crate::model::LaunchTemplateSpecification)
        pub fn build(self) -> crate::model::LaunchTemplateSpecification {
            crate::model::LaunchTemplateSpecification {
                name: self.name,
                version: self.version,
                id: self.id,
            }
        }
    }
}
impl LaunchTemplateSpecification {
    /// Creates a new builder-style object to manufacture [`LaunchTemplateSpecification`](crate::model::LaunchTemplateSpecification)
    pub fn builder() -> crate::model::launch_template_specification::Builder {
        crate::model::launch_template_specification::Builder::default()
    }
}

/// <p>The node group update configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodegroupUpdateConfig {
    /// <p>The maximum number of nodes unavailable at once during a version update. Nodes will be updated in parallel.
    /// This value or <code>maxUnavailablePercentage</code> is required to have a value.The maximum number
    /// is 100.</p>
    pub max_unavailable: std::option::Option<i32>,
    /// <p>The maximum percentage of nodes unavailable during a version update. This percentage of nodes will be
    /// updated in parallel, up to 100 nodes at once. This value or <code>maxUnavailable</code> is required to have a value.</p>
    pub max_unavailable_percentage: std::option::Option<i32>,
}
impl std::fmt::Debug for NodegroupUpdateConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodegroupUpdateConfig");
        formatter.field("max_unavailable", &self.max_unavailable);
        formatter.field(
            "max_unavailable_percentage",
            &self.max_unavailable_percentage,
        );
        formatter.finish()
    }
}
/// See [`NodegroupUpdateConfig`](crate::model::NodegroupUpdateConfig)
pub mod nodegroup_update_config {
    /// A builder for [`NodegroupUpdateConfig`](crate::model::NodegroupUpdateConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_unavailable: std::option::Option<i32>,
        pub(crate) max_unavailable_percentage: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The maximum number of nodes unavailable at once during a version update. Nodes will be updated in parallel.
        /// This value or <code>maxUnavailablePercentage</code> is required to have a value.The maximum number
        /// is 100.</p>
        pub fn max_unavailable(mut self, input: i32) -> Self {
            self.max_unavailable = Some(input);
            self
        }
        /// <p>The maximum number of nodes unavailable at once during a version update. Nodes will be updated in parallel.
        /// This value or <code>maxUnavailablePercentage</code> is required to have a value.The maximum number
        /// is 100.</p>
        pub fn set_max_unavailable(mut self, input: std::option::Option<i32>) -> Self {
            self.max_unavailable = input;
            self
        }
        /// <p>The maximum percentage of nodes unavailable during a version update. This percentage of nodes will be
        /// updated in parallel, up to 100 nodes at once. This value or <code>maxUnavailable</code> is required to have a value.</p>
        pub fn max_unavailable_percentage(mut self, input: i32) -> Self {
            self.max_unavailable_percentage = Some(input);
            self
        }
        /// <p>The maximum percentage of nodes unavailable during a version update. This percentage of nodes will be
        /// updated in parallel, up to 100 nodes at once. This value or <code>maxUnavailable</code> is required to have a value.</p>
        pub fn set_max_unavailable_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.max_unavailable_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`NodegroupUpdateConfig`](crate::model::NodegroupUpdateConfig)
        pub fn build(self) -> crate::model::NodegroupUpdateConfig {
            crate::model::NodegroupUpdateConfig {
                max_unavailable: self.max_unavailable,
                max_unavailable_percentage: self.max_unavailable_percentage,
            }
        }
    }
}
impl NodegroupUpdateConfig {
    /// Creates a new builder-style object to manufacture [`NodegroupUpdateConfig`](crate::model::NodegroupUpdateConfig)
    pub fn builder() -> crate::model::nodegroup_update_config::Builder {
        crate::model::nodegroup_update_config::Builder::default()
    }
}

/// <p>An object representing the scaling configuration details for the Auto Scaling group
/// that is associated with your node group. When creating a node group, you must specify
/// all or none of the properties. When updating a node group, you can specify any or none
/// of the properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodegroupScalingConfig {
    /// <p>The minimum number of nodes that the managed node group can scale in to.</p>
    pub min_size: std::option::Option<i32>,
    /// <p>The maximum number of nodes that the managed node group can scale out to. For
    /// information about the maximum number that you can specify, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html">Amazon EKS service
    /// quotas</a> in the <i>Amazon EKS User Guide</i>.</p>
    pub max_size: std::option::Option<i32>,
    /// <p>The current number of nodes that the managed node group should maintain.</p>
    pub desired_size: std::option::Option<i32>,
}
impl std::fmt::Debug for NodegroupScalingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodegroupScalingConfig");
        formatter.field("min_size", &self.min_size);
        formatter.field("max_size", &self.max_size);
        formatter.field("desired_size", &self.desired_size);
        formatter.finish()
    }
}
/// See [`NodegroupScalingConfig`](crate::model::NodegroupScalingConfig)
pub mod nodegroup_scaling_config {
    /// A builder for [`NodegroupScalingConfig`](crate::model::NodegroupScalingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min_size: std::option::Option<i32>,
        pub(crate) max_size: std::option::Option<i32>,
        pub(crate) desired_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The minimum number of nodes that the managed node group can scale in to.</p>
        pub fn min_size(mut self, input: i32) -> Self {
            self.min_size = Some(input);
            self
        }
        /// <p>The minimum number of nodes that the managed node group can scale in to.</p>
        pub fn set_min_size(mut self, input: std::option::Option<i32>) -> Self {
            self.min_size = input;
            self
        }
        /// <p>The maximum number of nodes that the managed node group can scale out to. For
        /// information about the maximum number that you can specify, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html">Amazon EKS service
        /// quotas</a> in the <i>Amazon EKS User Guide</i>.</p>
        pub fn max_size(mut self, input: i32) -> Self {
            self.max_size = Some(input);
            self
        }
        /// <p>The maximum number of nodes that the managed node group can scale out to. For
        /// information about the maximum number that you can specify, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html">Amazon EKS service
        /// quotas</a> in the <i>Amazon EKS User Guide</i>.</p>
        pub fn set_max_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_size = input;
            self
        }
        /// <p>The current number of nodes that the managed node group should maintain.</p>
        pub fn desired_size(mut self, input: i32) -> Self {
            self.desired_size = Some(input);
            self
        }
        /// <p>The current number of nodes that the managed node group should maintain.</p>
        pub fn set_desired_size(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_size = input;
            self
        }
        /// Consumes the builder and constructs a [`NodegroupScalingConfig`](crate::model::NodegroupScalingConfig)
        pub fn build(self) -> crate::model::NodegroupScalingConfig {
            crate::model::NodegroupScalingConfig {
                min_size: self.min_size,
                max_size: self.max_size,
                desired_size: self.desired_size,
            }
        }
    }
}
impl NodegroupScalingConfig {
    /// Creates a new builder-style object to manufacture [`NodegroupScalingConfig`](crate::model::NodegroupScalingConfig)
    pub fn builder() -> crate::model::nodegroup_scaling_config::Builder {
        crate::model::nodegroup_scaling_config::Builder::default()
    }
}

/// <p>An object representing the details of an update to a taints payload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTaintsPayload {
    /// <p>Kubernetes taints to be added or updated.</p>
    pub add_or_update_taints: std::option::Option<std::vec::Vec<crate::model::Taint>>,
    /// <p>Kubernetes taints to be removed.</p>
    pub remove_taints: std::option::Option<std::vec::Vec<crate::model::Taint>>,
}
impl std::fmt::Debug for UpdateTaintsPayload {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTaintsPayload");
        formatter.field("add_or_update_taints", &self.add_or_update_taints);
        formatter.field("remove_taints", &self.remove_taints);
        formatter.finish()
    }
}
/// See [`UpdateTaintsPayload`](crate::model::UpdateTaintsPayload)
pub mod update_taints_payload {
    /// A builder for [`UpdateTaintsPayload`](crate::model::UpdateTaintsPayload)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) add_or_update_taints: std::option::Option<std::vec::Vec<crate::model::Taint>>,
        pub(crate) remove_taints: std::option::Option<std::vec::Vec<crate::model::Taint>>,
    }
    impl Builder {
        /// Appends an item to `add_or_update_taints`.
        ///
        /// To override the contents of this collection use [`set_add_or_update_taints`](Self::set_add_or_update_taints).
        ///
        /// <p>Kubernetes taints to be added or updated.</p>
        pub fn add_or_update_taints(mut self, input: impl Into<crate::model::Taint>) -> Self {
            let mut v = self.add_or_update_taints.unwrap_or_default();
            v.push(input.into());
            self.add_or_update_taints = Some(v);
            self
        }
        /// <p>Kubernetes taints to be added or updated.</p>
        pub fn set_add_or_update_taints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Taint>>,
        ) -> Self {
            self.add_or_update_taints = input;
            self
        }
        /// Appends an item to `remove_taints`.
        ///
        /// To override the contents of this collection use [`set_remove_taints`](Self::set_remove_taints).
        ///
        /// <p>Kubernetes taints to be removed.</p>
        pub fn remove_taints(mut self, input: impl Into<crate::model::Taint>) -> Self {
            let mut v = self.remove_taints.unwrap_or_default();
            v.push(input.into());
            self.remove_taints = Some(v);
            self
        }
        /// <p>Kubernetes taints to be removed.</p>
        pub fn set_remove_taints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Taint>>,
        ) -> Self {
            self.remove_taints = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTaintsPayload`](crate::model::UpdateTaintsPayload)
        pub fn build(self) -> crate::model::UpdateTaintsPayload {
            crate::model::UpdateTaintsPayload {
                add_or_update_taints: self.add_or_update_taints,
                remove_taints: self.remove_taints,
            }
        }
    }
}
impl UpdateTaintsPayload {
    /// Creates a new builder-style object to manufacture [`UpdateTaintsPayload`](crate::model::UpdateTaintsPayload)
    pub fn builder() -> crate::model::update_taints_payload::Builder {
        crate::model::update_taints_payload::Builder::default()
    }
}

/// <p>A property that allows a node to repel a set of pods.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Taint {
    /// <p>The key of the taint.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the taint.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The effect of the taint.</p>
    pub effect: std::option::Option<crate::model::TaintEffect>,
}
impl std::fmt::Debug for Taint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Taint");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("effect", &self.effect);
        formatter.finish()
    }
}
/// See [`Taint`](crate::model::Taint)
pub mod taint {
    /// A builder for [`Taint`](crate::model::Taint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) effect: std::option::Option<crate::model::TaintEffect>,
    }
    impl Builder {
        /// <p>The key of the taint.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the taint.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the taint.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the taint.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The effect of the taint.</p>
        pub fn effect(mut self, input: crate::model::TaintEffect) -> Self {
            self.effect = Some(input);
            self
        }
        /// <p>The effect of the taint.</p>
        pub fn set_effect(mut self, input: std::option::Option<crate::model::TaintEffect>) -> Self {
            self.effect = input;
            self
        }
        /// Consumes the builder and constructs a [`Taint`](crate::model::Taint)
        pub fn build(self) -> crate::model::Taint {
            crate::model::Taint {
                key: self.key,
                value: self.value,
                effect: self.effect,
            }
        }
    }
}
impl Taint {
    /// Creates a new builder-style object to manufacture [`Taint`](crate::model::Taint)
    pub fn builder() -> crate::model::taint::Builder {
        crate::model::taint::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TaintEffect {
    #[allow(missing_docs)] // documentation missing in model
    NoExecute,
    #[allow(missing_docs)] // documentation missing in model
    NoSchedule,
    #[allow(missing_docs)] // documentation missing in model
    PreferNoSchedule,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TaintEffect {
    fn from(s: &str) -> Self {
        match s {
            "NO_EXECUTE" => TaintEffect::NoExecute,
            "NO_SCHEDULE" => TaintEffect::NoSchedule,
            "PREFER_NO_SCHEDULE" => TaintEffect::PreferNoSchedule,
            other => TaintEffect::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TaintEffect {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TaintEffect::from(s))
    }
}
impl TaintEffect {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TaintEffect::NoExecute => "NO_EXECUTE",
            TaintEffect::NoSchedule => "NO_SCHEDULE",
            TaintEffect::PreferNoSchedule => "PREFER_NO_SCHEDULE",
            TaintEffect::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NO_EXECUTE", "NO_SCHEDULE", "PREFER_NO_SCHEDULE"]
    }
}
impl AsRef<str> for TaintEffect {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing a Kubernetes label change for a managed node group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLabelsPayload {
    /// <p>Kubernetes labels to be added or updated.</p>
    pub add_or_update_labels:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Kubernetes labels to be removed.</p>
    pub remove_labels: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UpdateLabelsPayload {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLabelsPayload");
        formatter.field("add_or_update_labels", &self.add_or_update_labels);
        formatter.field("remove_labels", &self.remove_labels);
        formatter.finish()
    }
}
/// See [`UpdateLabelsPayload`](crate::model::UpdateLabelsPayload)
pub mod update_labels_payload {
    /// A builder for [`UpdateLabelsPayload`](crate::model::UpdateLabelsPayload)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) add_or_update_labels: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) remove_labels: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Adds a key-value pair to `add_or_update_labels`.
        ///
        /// To override the contents of this collection use [`set_add_or_update_labels`](Self::set_add_or_update_labels).
        ///
        /// <p>Kubernetes labels to be added or updated.</p>
        pub fn add_or_update_labels(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.add_or_update_labels.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.add_or_update_labels = Some(hash_map);
            self
        }
        /// <p>Kubernetes labels to be added or updated.</p>
        pub fn set_add_or_update_labels(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.add_or_update_labels = input;
            self
        }
        /// Appends an item to `remove_labels`.
        ///
        /// To override the contents of this collection use [`set_remove_labels`](Self::set_remove_labels).
        ///
        /// <p>Kubernetes labels to be removed.</p>
        pub fn remove_labels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.remove_labels.unwrap_or_default();
            v.push(input.into());
            self.remove_labels = Some(v);
            self
        }
        /// <p>Kubernetes labels to be removed.</p>
        pub fn set_remove_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.remove_labels = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLabelsPayload`](crate::model::UpdateLabelsPayload)
        pub fn build(self) -> crate::model::UpdateLabelsPayload {
            crate::model::UpdateLabelsPayload {
                add_or_update_labels: self.add_or_update_labels,
                remove_labels: self.remove_labels,
            }
        }
    }
}
impl UpdateLabelsPayload {
    /// Creates a new builder-style object to manufacture [`UpdateLabelsPayload`](crate::model::UpdateLabelsPayload)
    pub fn builder() -> crate::model::update_labels_payload::Builder {
        crate::model::update_labels_payload::Builder::default()
    }
}

/// <p>An object representing the logging configuration for resources in your cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Logging {
    /// <p>The cluster control plane logging configuration for your cluster.</p>
    pub cluster_logging: std::option::Option<std::vec::Vec<crate::model::LogSetup>>,
}
impl std::fmt::Debug for Logging {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Logging");
        formatter.field("cluster_logging", &self.cluster_logging);
        formatter.finish()
    }
}
/// See [`Logging`](crate::model::Logging)
pub mod logging {
    /// A builder for [`Logging`](crate::model::Logging)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_logging: std::option::Option<std::vec::Vec<crate::model::LogSetup>>,
    }
    impl Builder {
        /// Appends an item to `cluster_logging`.
        ///
        /// To override the contents of this collection use [`set_cluster_logging`](Self::set_cluster_logging).
        ///
        /// <p>The cluster control plane logging configuration for your cluster.</p>
        pub fn cluster_logging(mut self, input: impl Into<crate::model::LogSetup>) -> Self {
            let mut v = self.cluster_logging.unwrap_or_default();
            v.push(input.into());
            self.cluster_logging = Some(v);
            self
        }
        /// <p>The cluster control plane logging configuration for your cluster.</p>
        pub fn set_cluster_logging(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LogSetup>>,
        ) -> Self {
            self.cluster_logging = input;
            self
        }
        /// Consumes the builder and constructs a [`Logging`](crate::model::Logging)
        pub fn build(self) -> crate::model::Logging {
            crate::model::Logging {
                cluster_logging: self.cluster_logging,
            }
        }
    }
}
impl Logging {
    /// Creates a new builder-style object to manufacture [`Logging`](crate::model::Logging)
    pub fn builder() -> crate::model::logging::Builder {
        crate::model::logging::Builder::default()
    }
}

/// <p>An object representing the enabled or disabled Kubernetes control plane logs for your
/// cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogSetup {
    /// <p>The available cluster control plane log types.</p>
    pub types: std::option::Option<std::vec::Vec<crate::model::LogType>>,
    /// <p>If a log type is enabled, that log type exports its control plane logs to CloudWatch Logs. If a
    /// log type isn't enabled, that log type doesn't export its control plane logs. Each
    /// individual log type can be enabled or disabled independently.</p>
    pub enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for LogSetup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogSetup");
        formatter.field("types", &self.types);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`LogSetup`](crate::model::LogSetup)
pub mod log_setup {
    /// A builder for [`LogSetup`](crate::model::LogSetup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) types: std::option::Option<std::vec::Vec<crate::model::LogType>>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `types`.
        ///
        /// To override the contents of this collection use [`set_types`](Self::set_types).
        ///
        /// <p>The available cluster control plane log types.</p>
        pub fn types(mut self, input: impl Into<crate::model::LogType>) -> Self {
            let mut v = self.types.unwrap_or_default();
            v.push(input.into());
            self.types = Some(v);
            self
        }
        /// <p>The available cluster control plane log types.</p>
        pub fn set_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LogType>>,
        ) -> Self {
            self.types = input;
            self
        }
        /// <p>If a log type is enabled, that log type exports its control plane logs to CloudWatch Logs. If a
        /// log type isn't enabled, that log type doesn't export its control plane logs. Each
        /// individual log type can be enabled or disabled independently.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>If a log type is enabled, that log type exports its control plane logs to CloudWatch Logs. If a
        /// log type isn't enabled, that log type doesn't export its control plane logs. Each
        /// individual log type can be enabled or disabled independently.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`LogSetup`](crate::model::LogSetup)
        pub fn build(self) -> crate::model::LogSetup {
            crate::model::LogSetup {
                types: self.types,
                enabled: self.enabled,
            }
        }
    }
}
impl LogSetup {
    /// Creates a new builder-style object to manufacture [`LogSetup`](crate::model::LogSetup)
    pub fn builder() -> crate::model::log_setup::Builder {
        crate::model::log_setup::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogType {
    #[allow(missing_docs)] // documentation missing in model
    Api,
    #[allow(missing_docs)] // documentation missing in model
    Audit,
    #[allow(missing_docs)] // documentation missing in model
    Authenticator,
    #[allow(missing_docs)] // documentation missing in model
    ControllerManager,
    #[allow(missing_docs)] // documentation missing in model
    Scheduler,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogType {
    fn from(s: &str) -> Self {
        match s {
            "api" => LogType::Api,
            "audit" => LogType::Audit,
            "authenticator" => LogType::Authenticator,
            "controllerManager" => LogType::ControllerManager,
            "scheduler" => LogType::Scheduler,
            other => LogType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogType::from(s))
    }
}
impl LogType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogType::Api => "api",
            LogType::Audit => "audit",
            LogType::Authenticator => "authenticator",
            LogType::ControllerManager => "controllerManager",
            LogType::Scheduler => "scheduler",
            LogType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "api",
            "audit",
            "authenticator",
            "controllerManager",
            "scheduler",
        ]
    }
}
impl AsRef<str> for LogType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing the VPC configuration to use for an Amazon EKS cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConfigRequest {
    /// <p>Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account elastic network
    /// interfaces in these subnets to allow communication between your nodes and the Kubernetes
    /// control plane.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specify one or more security groups for the cross-account elastic network interfaces
    /// that Amazon EKS creates to use that allow communication between your nodes and the Kubernetes
    /// control plane. If you don't specify any security groups, then familiarize yourself with
    /// the difference between Amazon EKS defaults for clusters deployed with Kubernetes:</p>
    /// <ul>
    /// <li>
    /// <p>1.14 Amazon EKS platform version <code>eks.2</code> and earlier</p>
    /// </li>
    /// <li>
    /// <p>1.14 Amazon EKS platform version <code>eks.3</code> and later </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Amazon EKS security group
    /// considerations</a> in the <i>
    /// <i>Amazon EKS User Guide</i>
    /// </i>.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Set this value to <code>false</code> to disable public access to your cluster's
    /// Kubernetes API server endpoint. If you disable public access, your cluster's Kubernetes
    /// API server can only receive requests from within the cluster VPC. The default value for
    /// this parameter is <code>true</code>, which enables public access for your Kubernetes API
    /// server. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
    /// endpoint access control</a> in the <i>
    /// <i>Amazon EKS User Guide</i>
    /// </i>.</p>
    pub endpoint_public_access: std::option::Option<bool>,
    /// <p>Set this value to <code>true</code> to enable private access for your cluster's
    /// Kubernetes API server endpoint. If you enable private access, Kubernetes API requests
    /// from within your cluster's VPC use the private VPC endpoint. The default value for this
    /// parameter is <code>false</code>, which disables private access for your Kubernetes API
    /// server. If you disable private access and you have nodes or Fargate pods in the
    /// cluster, then ensure that <code>publicAccessCidrs</code> includes the necessary CIDR
    /// blocks for communication with the nodes or Fargate pods. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
    /// endpoint access control</a> in the <i>
    /// <i>Amazon EKS User Guide</i>
    /// </i>.</p>
    pub endpoint_private_access: std::option::Option<bool>,
    /// <p>The CIDR blocks that are allowed access to your cluster's public Kubernetes API server
    /// endpoint. Communication to the endpoint from addresses outside of the CIDR blocks that
    /// you specify is denied. The default value is <code>0.0.0.0/0</code>. If you've disabled
    /// private endpoint access and you have nodes or Fargate pods in the cluster, then ensure
    /// that you specify the necessary CIDR blocks. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
    /// endpoint access control</a> in the <i>
    /// <i>Amazon EKS User Guide</i>
    /// </i>.</p>
    pub public_access_cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for VpcConfigRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConfigRequest");
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("endpoint_public_access", &self.endpoint_public_access);
        formatter.field("endpoint_private_access", &self.endpoint_private_access);
        formatter.field("public_access_cidrs", &self.public_access_cidrs);
        formatter.finish()
    }
}
/// See [`VpcConfigRequest`](crate::model::VpcConfigRequest)
pub mod vpc_config_request {
    /// A builder for [`VpcConfigRequest`](crate::model::VpcConfigRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) endpoint_public_access: std::option::Option<bool>,
        pub(crate) endpoint_private_access: std::option::Option<bool>,
        pub(crate) public_access_cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account elastic network
        /// interfaces in these subnets to allow communication between your nodes and the Kubernetes
        /// control plane.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account elastic network
        /// interfaces in these subnets to allow communication between your nodes and the Kubernetes
        /// control plane.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>Specify one or more security groups for the cross-account elastic network interfaces
        /// that Amazon EKS creates to use that allow communication between your nodes and the Kubernetes
        /// control plane. If you don't specify any security groups, then familiarize yourself with
        /// the difference between Amazon EKS defaults for clusters deployed with Kubernetes:</p>
        /// <ul>
        /// <li>
        /// <p>1.14 Amazon EKS platform version <code>eks.2</code> and earlier</p>
        /// </li>
        /// <li>
        /// <p>1.14 Amazon EKS platform version <code>eks.3</code> and later </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Amazon EKS security group
        /// considerations</a> in the <i>
        /// <i>Amazon EKS User Guide</i>
        /// </i>.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>Specify one or more security groups for the cross-account elastic network interfaces
        /// that Amazon EKS creates to use that allow communication between your nodes and the Kubernetes
        /// control plane. If you don't specify any security groups, then familiarize yourself with
        /// the difference between Amazon EKS defaults for clusters deployed with Kubernetes:</p>
        /// <ul>
        /// <li>
        /// <p>1.14 Amazon EKS platform version <code>eks.2</code> and earlier</p>
        /// </li>
        /// <li>
        /// <p>1.14 Amazon EKS platform version <code>eks.3</code> and later </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Amazon EKS security group
        /// considerations</a> in the <i>
        /// <i>Amazon EKS User Guide</i>
        /// </i>.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>Set this value to <code>false</code> to disable public access to your cluster's
        /// Kubernetes API server endpoint. If you disable public access, your cluster's Kubernetes
        /// API server can only receive requests from within the cluster VPC. The default value for
        /// this parameter is <code>true</code>, which enables public access for your Kubernetes API
        /// server. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
        /// endpoint access control</a> in the <i>
        /// <i>Amazon EKS User Guide</i>
        /// </i>.</p>
        pub fn endpoint_public_access(mut self, input: bool) -> Self {
            self.endpoint_public_access = Some(input);
            self
        }
        /// <p>Set this value to <code>false</code> to disable public access to your cluster's
        /// Kubernetes API server endpoint. If you disable public access, your cluster's Kubernetes
        /// API server can only receive requests from within the cluster VPC. The default value for
        /// this parameter is <code>true</code>, which enables public access for your Kubernetes API
        /// server. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
        /// endpoint access control</a> in the <i>
        /// <i>Amazon EKS User Guide</i>
        /// </i>.</p>
        pub fn set_endpoint_public_access(mut self, input: std::option::Option<bool>) -> Self {
            self.endpoint_public_access = input;
            self
        }
        /// <p>Set this value to <code>true</code> to enable private access for your cluster's
        /// Kubernetes API server endpoint. If you enable private access, Kubernetes API requests
        /// from within your cluster's VPC use the private VPC endpoint. The default value for this
        /// parameter is <code>false</code>, which disables private access for your Kubernetes API
        /// server. If you disable private access and you have nodes or Fargate pods in the
        /// cluster, then ensure that <code>publicAccessCidrs</code> includes the necessary CIDR
        /// blocks for communication with the nodes or Fargate pods. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
        /// endpoint access control</a> in the <i>
        /// <i>Amazon EKS User Guide</i>
        /// </i>.</p>
        pub fn endpoint_private_access(mut self, input: bool) -> Self {
            self.endpoint_private_access = Some(input);
            self
        }
        /// <p>Set this value to <code>true</code> to enable private access for your cluster's
        /// Kubernetes API server endpoint. If you enable private access, Kubernetes API requests
        /// from within your cluster's VPC use the private VPC endpoint. The default value for this
        /// parameter is <code>false</code>, which disables private access for your Kubernetes API
        /// server. If you disable private access and you have nodes or Fargate pods in the
        /// cluster, then ensure that <code>publicAccessCidrs</code> includes the necessary CIDR
        /// blocks for communication with the nodes or Fargate pods. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
        /// endpoint access control</a> in the <i>
        /// <i>Amazon EKS User Guide</i>
        /// </i>.</p>
        pub fn set_endpoint_private_access(mut self, input: std::option::Option<bool>) -> Self {
            self.endpoint_private_access = input;
            self
        }
        /// Appends an item to `public_access_cidrs`.
        ///
        /// To override the contents of this collection use [`set_public_access_cidrs`](Self::set_public_access_cidrs).
        ///
        /// <p>The CIDR blocks that are allowed access to your cluster's public Kubernetes API server
        /// endpoint. Communication to the endpoint from addresses outside of the CIDR blocks that
        /// you specify is denied. The default value is <code>0.0.0.0/0</code>. If you've disabled
        /// private endpoint access and you have nodes or Fargate pods in the cluster, then ensure
        /// that you specify the necessary CIDR blocks. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
        /// endpoint access control</a> in the <i>
        /// <i>Amazon EKS User Guide</i>
        /// </i>.</p>
        pub fn public_access_cidrs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.public_access_cidrs.unwrap_or_default();
            v.push(input.into());
            self.public_access_cidrs = Some(v);
            self
        }
        /// <p>The CIDR blocks that are allowed access to your cluster's public Kubernetes API server
        /// endpoint. Communication to the endpoint from addresses outside of the CIDR blocks that
        /// you specify is denied. The default value is <code>0.0.0.0/0</code>. If you've disabled
        /// private endpoint access and you have nodes or Fargate pods in the cluster, then ensure
        /// that you specify the necessary CIDR blocks. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
        /// endpoint access control</a> in the <i>
        /// <i>Amazon EKS User Guide</i>
        /// </i>.</p>
        pub fn set_public_access_cidrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.public_access_cidrs = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConfigRequest`](crate::model::VpcConfigRequest)
        pub fn build(self) -> crate::model::VpcConfigRequest {
            crate::model::VpcConfigRequest {
                subnet_ids: self.subnet_ids,
                security_group_ids: self.security_group_ids,
                endpoint_public_access: self.endpoint_public_access,
                endpoint_private_access: self.endpoint_private_access,
                public_access_cidrs: self.public_access_cidrs,
            }
        }
    }
}
impl VpcConfigRequest {
    /// Creates a new builder-style object to manufacture [`VpcConfigRequest`](crate::model::VpcConfigRequest)
    pub fn builder() -> crate::model::vpc_config_request::Builder {
        crate::model::vpc_config_request::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResolveConflicts {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Overwrite,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResolveConflicts {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => ResolveConflicts::None,
            "OVERWRITE" => ResolveConflicts::Overwrite,
            other => ResolveConflicts::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResolveConflicts {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResolveConflicts::from(s))
    }
}
impl ResolveConflicts {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResolveConflicts::None => "NONE",
            ResolveConflicts::Overwrite => "OVERWRITE",
            ResolveConflicts::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "OVERWRITE"]
    }
}
impl AsRef<str> for ResolveConflicts {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing an Amazon EKS cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Cluster {
    /// <p>The name of the cluster.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the cluster.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Unix epoch timestamp in seconds for when the cluster was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Kubernetes server version for the cluster.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The endpoint for your Kubernetes API server.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control
    /// plane to make calls to Amazon Web Services API operations on your behalf.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The VPC configuration used by the cluster control plane. Amazon EKS VPC resources have
    /// specific requirements to work properly with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC
    /// Considerations</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group Considerations</a> in the
    /// <i>Amazon EKS User Guide</i>.</p>
    pub resources_vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
    /// <p>The Kubernetes network configuration for the cluster.</p>
    pub kubernetes_network_config:
        std::option::Option<crate::model::KubernetesNetworkConfigResponse>,
    /// <p>The logging configuration for your cluster.</p>
    pub logging: std::option::Option<crate::model::Logging>,
    /// <p>The identity provider information for the cluster.</p>
    pub identity: std::option::Option<crate::model::Identity>,
    /// <p>The current status of the cluster.</p>
    pub status: std::option::Option<crate::model::ClusterStatus>,
    /// <p>The <code>certificate-authority-data</code> for your cluster.</p>
    pub certificate_authority: std::option::Option<crate::model::Certificate>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The platform version of your Amazon EKS cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/platform-versions.html">Platform
    /// Versions</a> in the <i>
    /// <i>Amazon EKS User Guide</i>
    /// </i>.</p>
    pub platform_version: std::option::Option<std::string::String>,
    /// <p>The metadata that you apply to the cluster to assist with categorization and
    /// organization. Each tag consists of a key and an optional value, both of which you
    /// define. Cluster tags do not propagate to any other resources associated with the
    /// cluster.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The encryption configuration for the cluster.</p>
    pub encryption_config: std::option::Option<std::vec::Vec<crate::model::EncryptionConfig>>,
    /// <p>The configuration used to connect to a cluster for registration.</p>
    pub connector_config: std::option::Option<crate::model::ConnectorConfigResponse>,
}
impl std::fmt::Debug for Cluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Cluster");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("version", &self.version);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("resources_vpc_config", &self.resources_vpc_config);
        formatter.field("kubernetes_network_config", &self.kubernetes_network_config);
        formatter.field("logging", &self.logging);
        formatter.field("identity", &self.identity);
        formatter.field("status", &self.status);
        formatter.field("certificate_authority", &self.certificate_authority);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("platform_version", &self.platform_version);
        formatter.field("tags", &self.tags);
        formatter.field("encryption_config", &self.encryption_config);
        formatter.field("connector_config", &self.connector_config);
        formatter.finish()
    }
}
/// See [`Cluster`](crate::model::Cluster)
pub mod cluster {
    /// A builder for [`Cluster`](crate::model::Cluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) resources_vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
        pub(crate) kubernetes_network_config:
            std::option::Option<crate::model::KubernetesNetworkConfigResponse>,
        pub(crate) logging: std::option::Option<crate::model::Logging>,
        pub(crate) identity: std::option::Option<crate::model::Identity>,
        pub(crate) status: std::option::Option<crate::model::ClusterStatus>,
        pub(crate) certificate_authority: std::option::Option<crate::model::Certificate>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) platform_version: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) encryption_config:
            std::option::Option<std::vec::Vec<crate::model::EncryptionConfig>>,
        pub(crate) connector_config: std::option::Option<crate::model::ConnectorConfigResponse>,
    }
    impl Builder {
        /// <p>The name of the cluster.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the cluster.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the cluster was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the cluster was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Kubernetes server version for the cluster.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The Kubernetes server version for the cluster.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The endpoint for your Kubernetes API server.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint for your Kubernetes API server.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control
        /// plane to make calls to Amazon Web Services API operations on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control
        /// plane to make calls to Amazon Web Services API operations on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The VPC configuration used by the cluster control plane. Amazon EKS VPC resources have
        /// specific requirements to work properly with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC
        /// Considerations</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group Considerations</a> in the
        /// <i>Amazon EKS User Guide</i>.</p>
        pub fn resources_vpc_config(mut self, input: crate::model::VpcConfigResponse) -> Self {
            self.resources_vpc_config = Some(input);
            self
        }
        /// <p>The VPC configuration used by the cluster control plane. Amazon EKS VPC resources have
        /// specific requirements to work properly with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC
        /// Considerations</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group Considerations</a> in the
        /// <i>Amazon EKS User Guide</i>.</p>
        pub fn set_resources_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfigResponse>,
        ) -> Self {
            self.resources_vpc_config = input;
            self
        }
        /// <p>The Kubernetes network configuration for the cluster.</p>
        pub fn kubernetes_network_config(
            mut self,
            input: crate::model::KubernetesNetworkConfigResponse,
        ) -> Self {
            self.kubernetes_network_config = Some(input);
            self
        }
        /// <p>The Kubernetes network configuration for the cluster.</p>
        pub fn set_kubernetes_network_config(
            mut self,
            input: std::option::Option<crate::model::KubernetesNetworkConfigResponse>,
        ) -> Self {
            self.kubernetes_network_config = input;
            self
        }
        /// <p>The logging configuration for your cluster.</p>
        pub fn logging(mut self, input: crate::model::Logging) -> Self {
            self.logging = Some(input);
            self
        }
        /// <p>The logging configuration for your cluster.</p>
        pub fn set_logging(mut self, input: std::option::Option<crate::model::Logging>) -> Self {
            self.logging = input;
            self
        }
        /// <p>The identity provider information for the cluster.</p>
        pub fn identity(mut self, input: crate::model::Identity) -> Self {
            self.identity = Some(input);
            self
        }
        /// <p>The identity provider information for the cluster.</p>
        pub fn set_identity(mut self, input: std::option::Option<crate::model::Identity>) -> Self {
            self.identity = input;
            self
        }
        /// <p>The current status of the cluster.</p>
        pub fn status(mut self, input: crate::model::ClusterStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the cluster.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ClusterStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The <code>certificate-authority-data</code> for your cluster.</p>
        pub fn certificate_authority(mut self, input: crate::model::Certificate) -> Self {
            self.certificate_authority = Some(input);
            self
        }
        /// <p>The <code>certificate-authority-data</code> for your cluster.</p>
        pub fn set_certificate_authority(
            mut self,
            input: std::option::Option<crate::model::Certificate>,
        ) -> Self {
            self.certificate_authority = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The platform version of your Amazon EKS cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/platform-versions.html">Platform
        /// Versions</a> in the <i>
        /// <i>Amazon EKS User Guide</i>
        /// </i>.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_version = Some(input.into());
            self
        }
        /// <p>The platform version of your Amazon EKS cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/platform-versions.html">Platform
        /// Versions</a> in the <i>
        /// <i>Amazon EKS User Guide</i>
        /// </i>.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_version = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the cluster to assist with categorization and
        /// organization. Each tag consists of a key and an optional value, both of which you
        /// define. Cluster tags do not propagate to any other resources associated with the
        /// cluster.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The metadata that you apply to the cluster to assist with categorization and
        /// organization. Each tag consists of a key and an optional value, both of which you
        /// define. Cluster tags do not propagate to any other resources associated with the
        /// cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `encryption_config`.
        ///
        /// To override the contents of this collection use [`set_encryption_config`](Self::set_encryption_config).
        ///
        /// <p>The encryption configuration for the cluster.</p>
        pub fn encryption_config(
            mut self,
            input: impl Into<crate::model::EncryptionConfig>,
        ) -> Self {
            let mut v = self.encryption_config.unwrap_or_default();
            v.push(input.into());
            self.encryption_config = Some(v);
            self
        }
        /// <p>The encryption configuration for the cluster.</p>
        pub fn set_encryption_config(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EncryptionConfig>>,
        ) -> Self {
            self.encryption_config = input;
            self
        }
        /// <p>The configuration used to connect to a cluster for registration.</p>
        pub fn connector_config(mut self, input: crate::model::ConnectorConfigResponse) -> Self {
            self.connector_config = Some(input);
            self
        }
        /// <p>The configuration used to connect to a cluster for registration.</p>
        pub fn set_connector_config(
            mut self,
            input: std::option::Option<crate::model::ConnectorConfigResponse>,
        ) -> Self {
            self.connector_config = input;
            self
        }
        /// Consumes the builder and constructs a [`Cluster`](crate::model::Cluster)
        pub fn build(self) -> crate::model::Cluster {
            crate::model::Cluster {
                name: self.name,
                arn: self.arn,
                created_at: self.created_at,
                version: self.version,
                endpoint: self.endpoint,
                role_arn: self.role_arn,
                resources_vpc_config: self.resources_vpc_config,
                kubernetes_network_config: self.kubernetes_network_config,
                logging: self.logging,
                identity: self.identity,
                status: self.status,
                certificate_authority: self.certificate_authority,
                client_request_token: self.client_request_token,
                platform_version: self.platform_version,
                tags: self.tags,
                encryption_config: self.encryption_config,
                connector_config: self.connector_config,
            }
        }
    }
}
impl Cluster {
    /// Creates a new builder-style object to manufacture [`Cluster`](crate::model::Cluster)
    pub fn builder() -> crate::model::cluster::Builder {
        crate::model::cluster::Builder::default()
    }
}

/// <p>The full description of your connected cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorConfigResponse {
    /// <p>A unique ID associated with the cluster for registration purposes.</p>
    pub activation_id: std::option::Option<std::string::String>,
    /// <p>A unique code associated with the cluster for registration purposes.</p>
    pub activation_code: std::option::Option<std::string::String>,
    /// <p>The expiration time of the connected cluster. The cluster's YAML file must be applied through the native
    /// provider.</p>
    pub activation_expiry: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The cluster's cloud service provider.</p>
    pub provider: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the role that is used by the EKS connector to communicate with AWS services from the connected Kubernetes cluster.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConnectorConfigResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorConfigResponse");
        formatter.field("activation_id", &self.activation_id);
        formatter.field("activation_code", &self.activation_code);
        formatter.field("activation_expiry", &self.activation_expiry);
        formatter.field("provider", &self.provider);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`ConnectorConfigResponse`](crate::model::ConnectorConfigResponse)
pub mod connector_config_response {
    /// A builder for [`ConnectorConfigResponse`](crate::model::ConnectorConfigResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activation_id: std::option::Option<std::string::String>,
        pub(crate) activation_code: std::option::Option<std::string::String>,
        pub(crate) activation_expiry: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) provider: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique ID associated with the cluster for registration purposes.</p>
        pub fn activation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.activation_id = Some(input.into());
            self
        }
        /// <p>A unique ID associated with the cluster for registration purposes.</p>
        pub fn set_activation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.activation_id = input;
            self
        }
        /// <p>A unique code associated with the cluster for registration purposes.</p>
        pub fn activation_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.activation_code = Some(input.into());
            self
        }
        /// <p>A unique code associated with the cluster for registration purposes.</p>
        pub fn set_activation_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.activation_code = input;
            self
        }
        /// <p>The expiration time of the connected cluster. The cluster's YAML file must be applied through the native
        /// provider.</p>
        pub fn activation_expiry(mut self, input: aws_smithy_types::Instant) -> Self {
            self.activation_expiry = Some(input);
            self
        }
        /// <p>The expiration time of the connected cluster. The cluster's YAML file must be applied through the native
        /// provider.</p>
        pub fn set_activation_expiry(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.activation_expiry = input;
            self
        }
        /// <p>The cluster's cloud service provider.</p>
        pub fn provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider = Some(input.into());
            self
        }
        /// <p>The cluster's cloud service provider.</p>
        pub fn set_provider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.provider = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role that is used by the EKS connector to communicate with AWS services from the connected Kubernetes cluster.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role that is used by the EKS connector to communicate with AWS services from the connected Kubernetes cluster.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorConfigResponse`](crate::model::ConnectorConfigResponse)
        pub fn build(self) -> crate::model::ConnectorConfigResponse {
            crate::model::ConnectorConfigResponse {
                activation_id: self.activation_id,
                activation_code: self.activation_code,
                activation_expiry: self.activation_expiry,
                provider: self.provider,
                role_arn: self.role_arn,
            }
        }
    }
}
impl ConnectorConfigResponse {
    /// Creates a new builder-style object to manufacture [`ConnectorConfigResponse`](crate::model::ConnectorConfigResponse)
    pub fn builder() -> crate::model::connector_config_response::Builder {
        crate::model::connector_config_response::Builder::default()
    }
}

/// <p>The encryption configuration for the cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionConfig {
    /// <p>Specifies the resources to be encrypted. The only supported value is "secrets".</p>
    pub resources: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Key Management Service (KMS) key. Either the ARN or the alias can be used.</p>
    pub provider: std::option::Option<crate::model::Provider>,
}
impl std::fmt::Debug for EncryptionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionConfig");
        formatter.field("resources", &self.resources);
        formatter.field("provider", &self.provider);
        formatter.finish()
    }
}
/// See [`EncryptionConfig`](crate::model::EncryptionConfig)
pub mod encryption_config {
    /// A builder for [`EncryptionConfig`](crate::model::EncryptionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resources: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) provider: std::option::Option<crate::model::Provider>,
    }
    impl Builder {
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>Specifies the resources to be encrypted. The only supported value is "secrets".</p>
        pub fn resources(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>Specifies the resources to be encrypted. The only supported value is "secrets".</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>Key Management Service (KMS) key. Either the ARN or the alias can be used.</p>
        pub fn provider(mut self, input: crate::model::Provider) -> Self {
            self.provider = Some(input);
            self
        }
        /// <p>Key Management Service (KMS) key. Either the ARN or the alias can be used.</p>
        pub fn set_provider(mut self, input: std::option::Option<crate::model::Provider>) -> Self {
            self.provider = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionConfig`](crate::model::EncryptionConfig)
        pub fn build(self) -> crate::model::EncryptionConfig {
            crate::model::EncryptionConfig {
                resources: self.resources,
                provider: self.provider,
            }
        }
    }
}
impl EncryptionConfig {
    /// Creates a new builder-style object to manufacture [`EncryptionConfig`](crate::model::EncryptionConfig)
    pub fn builder() -> crate::model::encryption_config::Builder {
        crate::model::encryption_config::Builder::default()
    }
}

/// <p>Identifies the Key Management Service (KMS) key used to encrypt the secrets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Provider {
    /// <p>Amazon Resource Name (ARN) or alias of the KMS key. The KMS key must be symmetric, created in the same
    /// region as the cluster, and if the KMS key was created in a different account, the user
    /// must have access to the KMS key. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html">Allowing
    /// Users in Other Accounts to Use a KMS key</a> in the <i>Key Management Service
    /// Developer Guide</i>.</p>
    pub key_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Provider {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Provider");
        formatter.field("key_arn", &self.key_arn);
        formatter.finish()
    }
}
/// See [`Provider`](crate::model::Provider)
pub mod provider {
    /// A builder for [`Provider`](crate::model::Provider)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) or alias of the KMS key. The KMS key must be symmetric, created in the same
        /// region as the cluster, and if the KMS key was created in a different account, the user
        /// must have access to the KMS key. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html">Allowing
        /// Users in Other Accounts to Use a KMS key</a> in the <i>Key Management Service
        /// Developer Guide</i>.</p>
        pub fn key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) or alias of the KMS key. The KMS key must be symmetric, created in the same
        /// region as the cluster, and if the KMS key was created in a different account, the user
        /// must have access to the KMS key. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html">Allowing
        /// Users in Other Accounts to Use a KMS key</a> in the <i>Key Management Service
        /// Developer Guide</i>.</p>
        pub fn set_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Provider`](crate::model::Provider)
        pub fn build(self) -> crate::model::Provider {
            crate::model::Provider {
                key_arn: self.key_arn,
            }
        }
    }
}
impl Provider {
    /// Creates a new builder-style object to manufacture [`Provider`](crate::model::Provider)
    pub fn builder() -> crate::model::provider::Builder {
        crate::model::provider::Builder::default()
    }
}

/// <p>An object representing the <code>certificate-authority-data</code> for your
/// cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Certificate {
    /// <p>The Base64-encoded certificate data required to communicate with your cluster. Add
    /// this to the <code>certificate-authority-data</code> section of the
    /// <code>kubeconfig</code> file for your cluster.</p>
    pub data: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Certificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Certificate");
        formatter.field("data", &self.data);
        formatter.finish()
    }
}
/// See [`Certificate`](crate::model::Certificate)
pub mod certificate {
    /// A builder for [`Certificate`](crate::model::Certificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Base64-encoded certificate data required to communicate with your cluster. Add
        /// this to the <code>certificate-authority-data</code> section of the
        /// <code>kubeconfig</code> file for your cluster.</p>
        pub fn data(mut self, input: impl Into<std::string::String>) -> Self {
            self.data = Some(input.into());
            self
        }
        /// <p>The Base64-encoded certificate data required to communicate with your cluster. Add
        /// this to the <code>certificate-authority-data</code> section of the
        /// <code>kubeconfig</code> file for your cluster.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data = input;
            self
        }
        /// Consumes the builder and constructs a [`Certificate`](crate::model::Certificate)
        pub fn build(self) -> crate::model::Certificate {
            crate::model::Certificate { data: self.data }
        }
    }
}
impl Certificate {
    /// Creates a new builder-style object to manufacture [`Certificate`](crate::model::Certificate)
    pub fn builder() -> crate::model::certificate::Builder {
        crate::model::certificate::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ClusterStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ClusterStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ClusterStatus::Active,
            "CREATING" => ClusterStatus::Creating,
            "DELETING" => ClusterStatus::Deleting,
            "FAILED" => ClusterStatus::Failed,
            "PENDING" => ClusterStatus::Pending,
            "UPDATING" => ClusterStatus::Updating,
            other => ClusterStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ClusterStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ClusterStatus::from(s))
    }
}
impl ClusterStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ClusterStatus::Active => "ACTIVE",
            ClusterStatus::Creating => "CREATING",
            ClusterStatus::Deleting => "DELETING",
            ClusterStatus::Failed => "FAILED",
            ClusterStatus::Pending => "PENDING",
            ClusterStatus::Updating => "UPDATING",
            ClusterStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE", "CREATING", "DELETING", "FAILED", "PENDING", "UPDATING",
        ]
    }
}
impl AsRef<str> for ClusterStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing an identity provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Identity {
    /// <p>An object representing the <a href="https://openid.net/connect/">OpenID
    /// Connect</a> identity provider information.</p>
    pub oidc: std::option::Option<crate::model::Oidc>,
}
impl std::fmt::Debug for Identity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Identity");
        formatter.field("oidc", &self.oidc);
        formatter.finish()
    }
}
/// See [`Identity`](crate::model::Identity)
pub mod identity {
    /// A builder for [`Identity`](crate::model::Identity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) oidc: std::option::Option<crate::model::Oidc>,
    }
    impl Builder {
        /// <p>An object representing the <a href="https://openid.net/connect/">OpenID
        /// Connect</a> identity provider information.</p>
        pub fn oidc(mut self, input: crate::model::Oidc) -> Self {
            self.oidc = Some(input);
            self
        }
        /// <p>An object representing the <a href="https://openid.net/connect/">OpenID
        /// Connect</a> identity provider information.</p>
        pub fn set_oidc(mut self, input: std::option::Option<crate::model::Oidc>) -> Self {
            self.oidc = input;
            self
        }
        /// Consumes the builder and constructs a [`Identity`](crate::model::Identity)
        pub fn build(self) -> crate::model::Identity {
            crate::model::Identity { oidc: self.oidc }
        }
    }
}
impl Identity {
    /// Creates a new builder-style object to manufacture [`Identity`](crate::model::Identity)
    pub fn builder() -> crate::model::identity::Builder {
        crate::model::identity::Builder::default()
    }
}

/// <p>An object representing the <a href="https://openid.net/connect/">OpenID
/// Connect</a> (OIDC) identity provider information for the cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Oidc {
    /// <p>The issuer URL for the OIDC identity provider.</p>
    pub issuer: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Oidc {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Oidc");
        formatter.field("issuer", &self.issuer);
        formatter.finish()
    }
}
/// See [`Oidc`](crate::model::Oidc)
pub mod oidc {
    /// A builder for [`Oidc`](crate::model::Oidc)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) issuer: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The issuer URL for the OIDC identity provider.</p>
        pub fn issuer(mut self, input: impl Into<std::string::String>) -> Self {
            self.issuer = Some(input.into());
            self
        }
        /// <p>The issuer URL for the OIDC identity provider.</p>
        pub fn set_issuer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.issuer = input;
            self
        }
        /// Consumes the builder and constructs a [`Oidc`](crate::model::Oidc)
        pub fn build(self) -> crate::model::Oidc {
            crate::model::Oidc {
                issuer: self.issuer,
            }
        }
    }
}
impl Oidc {
    /// Creates a new builder-style object to manufacture [`Oidc`](crate::model::Oidc)
    pub fn builder() -> crate::model::oidc::Builder {
        crate::model::oidc::Builder::default()
    }
}

/// <p>The Kubernetes network configuration for the cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KubernetesNetworkConfigResponse {
    /// <p>The CIDR block that Kubernetes service IP addresses are assigned from. If you didn't
    /// specify a CIDR block when you created the cluster, then Kubernetes assigns addresses
    /// from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks. If this was specified, then
    /// it was specified when the cluster was created and it cannot be changed.</p>
    pub service_ipv4_cidr: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KubernetesNetworkConfigResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KubernetesNetworkConfigResponse");
        formatter.field("service_ipv4_cidr", &self.service_ipv4_cidr);
        formatter.finish()
    }
}
/// See [`KubernetesNetworkConfigResponse`](crate::model::KubernetesNetworkConfigResponse)
pub mod kubernetes_network_config_response {
    /// A builder for [`KubernetesNetworkConfigResponse`](crate::model::KubernetesNetworkConfigResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_ipv4_cidr: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The CIDR block that Kubernetes service IP addresses are assigned from. If you didn't
        /// specify a CIDR block when you created the cluster, then Kubernetes assigns addresses
        /// from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks. If this was specified, then
        /// it was specified when the cluster was created and it cannot be changed.</p>
        pub fn service_ipv4_cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_ipv4_cidr = Some(input.into());
            self
        }
        /// <p>The CIDR block that Kubernetes service IP addresses are assigned from. If you didn't
        /// specify a CIDR block when you created the cluster, then Kubernetes assigns addresses
        /// from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks. If this was specified, then
        /// it was specified when the cluster was created and it cannot be changed.</p>
        pub fn set_service_ipv4_cidr(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_ipv4_cidr = input;
            self
        }
        /// Consumes the builder and constructs a [`KubernetesNetworkConfigResponse`](crate::model::KubernetesNetworkConfigResponse)
        pub fn build(self) -> crate::model::KubernetesNetworkConfigResponse {
            crate::model::KubernetesNetworkConfigResponse {
                service_ipv4_cidr: self.service_ipv4_cidr,
            }
        }
    }
}
impl KubernetesNetworkConfigResponse {
    /// Creates a new builder-style object to manufacture [`KubernetesNetworkConfigResponse`](crate::model::KubernetesNetworkConfigResponse)
    pub fn builder() -> crate::model::kubernetes_network_config_response::Builder {
        crate::model::kubernetes_network_config_response::Builder::default()
    }
}

/// <p>An object representing an Amazon EKS cluster VPC configuration response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConfigResponse {
    /// <p>The subnets associated with your cluster.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The security groups associated with the cross-account elastic network interfaces that
    /// are used to allow communication between your nodes and the Kubernetes control
    /// plane.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The cluster security group that was created by Amazon EKS for the cluster. Managed node
    /// groups use this security group for control-plane-to-data-plane communication.</p>
    pub cluster_security_group_id: std::option::Option<std::string::String>,
    /// <p>The VPC associated with your cluster.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>This parameter indicates whether the Amazon EKS public API server endpoint is enabled. If
    /// the Amazon EKS public API server endpoint is disabled, your cluster's Kubernetes API server
    /// can only receive requests that originate from within the cluster VPC.</p>
    pub endpoint_public_access: bool,
    /// <p>This parameter indicates whether the Amazon EKS private API server endpoint is enabled. If
    /// the Amazon EKS private API server endpoint is enabled, Kubernetes API requests that originate
    /// from within your cluster's VPC use the private VPC endpoint instead of traversing the
    /// internet. If this value is disabled and you have nodes or Fargate pods in the cluster,
    /// then ensure that <code>publicAccessCidrs</code> includes the necessary CIDR blocks for
    /// communication with the nodes or Fargate pods. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
    /// endpoint access control</a> in the <i>
    /// <i>Amazon EKS User Guide</i>
    /// </i>.</p>
    pub endpoint_private_access: bool,
    /// <p>The CIDR blocks that are allowed access to your cluster's public Kubernetes API server
    /// endpoint. Communication to the endpoint from addresses outside of the listed CIDR blocks
    /// is denied. The default value is <code>0.0.0.0/0</code>. If you've disabled private
    /// endpoint access and you have nodes or Fargate pods in the cluster, then ensure that the
    /// necessary CIDR blocks are listed. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
    /// endpoint access control</a> in the <i>
    /// <i>Amazon EKS User Guide</i>
    /// </i>.</p>
    pub public_access_cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for VpcConfigResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConfigResponse");
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("cluster_security_group_id", &self.cluster_security_group_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("endpoint_public_access", &self.endpoint_public_access);
        formatter.field("endpoint_private_access", &self.endpoint_private_access);
        formatter.field("public_access_cidrs", &self.public_access_cidrs);
        formatter.finish()
    }
}
/// See [`VpcConfigResponse`](crate::model::VpcConfigResponse)
pub mod vpc_config_response {
    /// A builder for [`VpcConfigResponse`](crate::model::VpcConfigResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cluster_security_group_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) endpoint_public_access: std::option::Option<bool>,
        pub(crate) endpoint_private_access: std::option::Option<bool>,
        pub(crate) public_access_cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The subnets associated with your cluster.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The subnets associated with your cluster.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The security groups associated with the cross-account elastic network interfaces that
        /// are used to allow communication between your nodes and the Kubernetes control
        /// plane.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The security groups associated with the cross-account elastic network interfaces that
        /// are used to allow communication between your nodes and the Kubernetes control
        /// plane.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>The cluster security group that was created by Amazon EKS for the cluster. Managed node
        /// groups use this security group for control-plane-to-data-plane communication.</p>
        pub fn cluster_security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_security_group_id = Some(input.into());
            self
        }
        /// <p>The cluster security group that was created by Amazon EKS for the cluster. Managed node
        /// groups use this security group for control-plane-to-data-plane communication.</p>
        pub fn set_cluster_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_security_group_id = input;
            self
        }
        /// <p>The VPC associated with your cluster.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The VPC associated with your cluster.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>This parameter indicates whether the Amazon EKS public API server endpoint is enabled. If
        /// the Amazon EKS public API server endpoint is disabled, your cluster's Kubernetes API server
        /// can only receive requests that originate from within the cluster VPC.</p>
        pub fn endpoint_public_access(mut self, input: bool) -> Self {
            self.endpoint_public_access = Some(input);
            self
        }
        /// <p>This parameter indicates whether the Amazon EKS public API server endpoint is enabled. If
        /// the Amazon EKS public API server endpoint is disabled, your cluster's Kubernetes API server
        /// can only receive requests that originate from within the cluster VPC.</p>
        pub fn set_endpoint_public_access(mut self, input: std::option::Option<bool>) -> Self {
            self.endpoint_public_access = input;
            self
        }
        /// <p>This parameter indicates whether the Amazon EKS private API server endpoint is enabled. If
        /// the Amazon EKS private API server endpoint is enabled, Kubernetes API requests that originate
        /// from within your cluster's VPC use the private VPC endpoint instead of traversing the
        /// internet. If this value is disabled and you have nodes or Fargate pods in the cluster,
        /// then ensure that <code>publicAccessCidrs</code> includes the necessary CIDR blocks for
        /// communication with the nodes or Fargate pods. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
        /// endpoint access control</a> in the <i>
        /// <i>Amazon EKS User Guide</i>
        /// </i>.</p>
        pub fn endpoint_private_access(mut self, input: bool) -> Self {
            self.endpoint_private_access = Some(input);
            self
        }
        /// <p>This parameter indicates whether the Amazon EKS private API server endpoint is enabled. If
        /// the Amazon EKS private API server endpoint is enabled, Kubernetes API requests that originate
        /// from within your cluster's VPC use the private VPC endpoint instead of traversing the
        /// internet. If this value is disabled and you have nodes or Fargate pods in the cluster,
        /// then ensure that <code>publicAccessCidrs</code> includes the necessary CIDR blocks for
        /// communication with the nodes or Fargate pods. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
        /// endpoint access control</a> in the <i>
        /// <i>Amazon EKS User Guide</i>
        /// </i>.</p>
        pub fn set_endpoint_private_access(mut self, input: std::option::Option<bool>) -> Self {
            self.endpoint_private_access = input;
            self
        }
        /// Appends an item to `public_access_cidrs`.
        ///
        /// To override the contents of this collection use [`set_public_access_cidrs`](Self::set_public_access_cidrs).
        ///
        /// <p>The CIDR blocks that are allowed access to your cluster's public Kubernetes API server
        /// endpoint. Communication to the endpoint from addresses outside of the listed CIDR blocks
        /// is denied. The default value is <code>0.0.0.0/0</code>. If you've disabled private
        /// endpoint access and you have nodes or Fargate pods in the cluster, then ensure that the
        /// necessary CIDR blocks are listed. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
        /// endpoint access control</a> in the <i>
        /// <i>Amazon EKS User Guide</i>
        /// </i>.</p>
        pub fn public_access_cidrs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.public_access_cidrs.unwrap_or_default();
            v.push(input.into());
            self.public_access_cidrs = Some(v);
            self
        }
        /// <p>The CIDR blocks that are allowed access to your cluster's public Kubernetes API server
        /// endpoint. Communication to the endpoint from addresses outside of the listed CIDR blocks
        /// is denied. The default value is <code>0.0.0.0/0</code>. If you've disabled private
        /// endpoint access and you have nodes or Fargate pods in the cluster, then ensure that the
        /// necessary CIDR blocks are listed. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS cluster
        /// endpoint access control</a> in the <i>
        /// <i>Amazon EKS User Guide</i>
        /// </i>.</p>
        pub fn set_public_access_cidrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.public_access_cidrs = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConfigResponse`](crate::model::VpcConfigResponse)
        pub fn build(self) -> crate::model::VpcConfigResponse {
            crate::model::VpcConfigResponse {
                subnet_ids: self.subnet_ids,
                security_group_ids: self.security_group_ids,
                cluster_security_group_id: self.cluster_security_group_id,
                vpc_id: self.vpc_id,
                endpoint_public_access: self.endpoint_public_access.unwrap_or_default(),
                endpoint_private_access: self.endpoint_private_access.unwrap_or_default(),
                public_access_cidrs: self.public_access_cidrs,
            }
        }
    }
}
impl VpcConfigResponse {
    /// Creates a new builder-style object to manufacture [`VpcConfigResponse`](crate::model::VpcConfigResponse)
    pub fn builder() -> crate::model::vpc_config_response::Builder {
        crate::model::vpc_config_response::Builder::default()
    }
}

/// <p>The configuration sent to a cluster for configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorConfigRequest {
    /// <p>The Amazon Resource Name (ARN) of the role that is authorized to request the connector configuration.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The cloud provider for the target cluster to connect.</p>
    pub provider: std::option::Option<crate::model::ConnectorConfigProvider>,
}
impl std::fmt::Debug for ConnectorConfigRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorConfigRequest");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("provider", &self.provider);
        formatter.finish()
    }
}
/// See [`ConnectorConfigRequest`](crate::model::ConnectorConfigRequest)
pub mod connector_config_request {
    /// A builder for [`ConnectorConfigRequest`](crate::model::ConnectorConfigRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) provider: std::option::Option<crate::model::ConnectorConfigProvider>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the role that is authorized to request the connector configuration.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role that is authorized to request the connector configuration.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The cloud provider for the target cluster to connect.</p>
        pub fn provider(mut self, input: crate::model::ConnectorConfigProvider) -> Self {
            self.provider = Some(input);
            self
        }
        /// <p>The cloud provider for the target cluster to connect.</p>
        pub fn set_provider(
            mut self,
            input: std::option::Option<crate::model::ConnectorConfigProvider>,
        ) -> Self {
            self.provider = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorConfigRequest`](crate::model::ConnectorConfigRequest)
        pub fn build(self) -> crate::model::ConnectorConfigRequest {
            crate::model::ConnectorConfigRequest {
                role_arn: self.role_arn,
                provider: self.provider,
            }
        }
    }
}
impl ConnectorConfigRequest {
    /// Creates a new builder-style object to manufacture [`ConnectorConfigRequest`](crate::model::ConnectorConfigRequest)
    pub fn builder() -> crate::model::connector_config_request::Builder {
        crate::model::connector_config_request::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectorConfigProvider {
    #[allow(missing_docs)] // documentation missing in model
    Aks,
    #[allow(missing_docs)] // documentation missing in model
    Anthos,
    #[allow(missing_docs)] // documentation missing in model
    Ec2,
    #[allow(missing_docs)] // documentation missing in model
    EksAnywhere,
    #[allow(missing_docs)] // documentation missing in model
    Gke,
    #[allow(missing_docs)] // documentation missing in model
    Openshift,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    Rancher,
    #[allow(missing_docs)] // documentation missing in model
    Tanzu,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectorConfigProvider {
    fn from(s: &str) -> Self {
        match s {
            "AKS" => ConnectorConfigProvider::Aks,
            "ANTHOS" => ConnectorConfigProvider::Anthos,
            "EC2" => ConnectorConfigProvider::Ec2,
            "EKS_ANYWHERE" => ConnectorConfigProvider::EksAnywhere,
            "GKE" => ConnectorConfigProvider::Gke,
            "OPENSHIFT" => ConnectorConfigProvider::Openshift,
            "OTHER" => ConnectorConfigProvider::Other,
            "RANCHER" => ConnectorConfigProvider::Rancher,
            "TANZU" => ConnectorConfigProvider::Tanzu,
            other => ConnectorConfigProvider::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectorConfigProvider {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectorConfigProvider::from(s))
    }
}
impl ConnectorConfigProvider {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectorConfigProvider::Aks => "AKS",
            ConnectorConfigProvider::Anthos => "ANTHOS",
            ConnectorConfigProvider::Ec2 => "EC2",
            ConnectorConfigProvider::EksAnywhere => "EKS_ANYWHERE",
            ConnectorConfigProvider::Gke => "GKE",
            ConnectorConfigProvider::Openshift => "OPENSHIFT",
            ConnectorConfigProvider::Other => "OTHER",
            ConnectorConfigProvider::Rancher => "RANCHER",
            ConnectorConfigProvider::Tanzu => "TANZU",
            ConnectorConfigProvider::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AKS",
            "ANTHOS",
            "EC2",
            "EKS_ANYWHERE",
            "GKE",
            "OPENSHIFT",
            "OTHER",
            "RANCHER",
            "TANZU",
        ]
    }
}
impl AsRef<str> for ConnectorConfigProvider {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing an identity provider configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdentityProviderConfig {
    /// <p>The type of the identity provider configuration.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The name of the identity provider configuration.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IdentityProviderConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdentityProviderConfig");
        formatter.field("r#type", &self.r#type);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`IdentityProviderConfig`](crate::model::IdentityProviderConfig)
pub mod identity_provider_config {
    /// A builder for [`IdentityProviderConfig`](crate::model::IdentityProviderConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the identity provider configuration.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the identity provider configuration.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the identity provider configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the identity provider configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`IdentityProviderConfig`](crate::model::IdentityProviderConfig)
        pub fn build(self) -> crate::model::IdentityProviderConfig {
            crate::model::IdentityProviderConfig {
                r#type: self.r#type,
                name: self.name,
            }
        }
    }
}
impl IdentityProviderConfig {
    /// Creates a new builder-style object to manufacture [`IdentityProviderConfig`](crate::model::IdentityProviderConfig)
    pub fn builder() -> crate::model::identity_provider_config::Builder {
        crate::model::identity_provider_config::Builder::default()
    }
}

/// <p>An object representing an Amazon EKS managed node group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Nodegroup {
    /// <p>The name associated with an Amazon EKS managed node group.</p>
    pub nodegroup_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) associated with the managed node group.</p>
    pub nodegroup_arn: std::option::Option<std::string::String>,
    /// <p>The name of the cluster that the managed node group resides in.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The Kubernetes version of the managed node group.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>If the node group was deployed using a launch template with a custom AMI, then this is
    /// the AMI ID that was specified in the launch template. For node groups that weren't
    /// deployed using a launch template, this is the version of the Amazon EKS optimized AMI that
    /// the node group was deployed with.</p>
    pub release_version: std::option::Option<std::string::String>,
    /// <p>The Unix epoch timestamp in seconds for when the managed node group was
    /// created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Unix epoch timestamp in seconds for when the managed node group was last
    /// modified.</p>
    pub modified_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The current status of the managed node group.</p>
    pub status: std::option::Option<crate::model::NodegroupStatus>,
    /// <p>The capacity type of your managed node group.</p>
    pub capacity_type: std::option::Option<crate::model::CapacityTypes>,
    /// <p>The scaling configuration details for the Auto Scaling group that is associated with
    /// your node group.</p>
    pub scaling_config: std::option::Option<crate::model::NodegroupScalingConfig>,
    /// <p>If the node group wasn't deployed with a launch template, then this is the instance
    /// type that is associated with the node group. If the node group was deployed with a
    /// launch template, then this is <code>null</code>.</p>
    pub instance_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The subnets that were specified for the Auto Scaling group that is associated with
    /// your node group.</p>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If the node group wasn't deployed with a launch template, then this is the remote
    /// access configuration that is associated with the node group. If the node group was
    /// deployed with a launch template, then this is <code>null</code>.</p>
    pub remote_access: std::option::Option<crate::model::RemoteAccessConfig>,
    /// <p>If the node group was deployed using a launch template with a custom AMI, then this is
    /// <code>CUSTOM</code>. For node groups that weren't deployed using a launch template,
    /// this is the AMI type that was specified in the node group configuration.</p>
    pub ami_type: std::option::Option<crate::model::AmiTypes>,
    /// <p>The IAM role associated with your node group. The Amazon EKS node <code>kubelet</code>
    /// daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive permissions for these API
    /// calls through an IAM instance profile and associated policies.</p>
    pub node_role: std::option::Option<std::string::String>,
    /// <p>The Kubernetes labels applied to the nodes in the node group.</p>
    /// <note>
    /// <p>Only labels that are applied with the Amazon EKS API are shown here. There may be other
    /// Kubernetes labels applied to the nodes in this group.</p>
    /// </note>
    pub labels:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Kubernetes taints to be applied to the nodes in the node group when they are
    /// created. Effect is one of <code>No_Schedule</code>, <code>Prefer_No_Schedule</code>, or <code>No_Execute</code>. Kubernetes taints
    /// can be used together with tolerations to control how workloads are scheduled to your
    /// nodes.</p>
    pub taints: std::option::Option<std::vec::Vec<crate::model::Taint>>,
    /// <p>The resources associated with the node group, such as Auto Scaling groups and security
    /// groups for remote access.</p>
    pub resources: std::option::Option<crate::model::NodegroupResources>,
    /// <p>If the node group wasn't deployed with a launch template, then this is the disk size
    /// in the node group configuration. If the node group was deployed with a launch template,
    /// then this is <code>null</code>.</p>
    pub disk_size: std::option::Option<i32>,
    /// <p>The health status of the node group. If there are issues with your node group's
    /// health, they are listed here.</p>
    pub health: std::option::Option<crate::model::NodegroupHealth>,
    /// <p>The node group update configuration.</p>
    pub update_config: std::option::Option<crate::model::NodegroupUpdateConfig>,
    /// <p>If a launch template was used to create the node group, then this is the launch
    /// template that was used.</p>
    pub launch_template: std::option::Option<crate::model::LaunchTemplateSpecification>,
    /// <p>The metadata applied to the node group to assist with categorization and organization.
    /// Each tag consists of a key and an optional value, both of which you define. Node group
    /// tags do not propagate to any other resources associated with the node group, such as the
    /// Amazon EC2 instances or subnets. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for Nodegroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Nodegroup");
        formatter.field("nodegroup_name", &self.nodegroup_name);
        formatter.field("nodegroup_arn", &self.nodegroup_arn);
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("version", &self.version);
        formatter.field("release_version", &self.release_version);
        formatter.field("created_at", &self.created_at);
        formatter.field("modified_at", &self.modified_at);
        formatter.field("status", &self.status);
        formatter.field("capacity_type", &self.capacity_type);
        formatter.field("scaling_config", &self.scaling_config);
        formatter.field("instance_types", &self.instance_types);
        formatter.field("subnets", &self.subnets);
        formatter.field("remote_access", &self.remote_access);
        formatter.field("ami_type", &self.ami_type);
        formatter.field("node_role", &self.node_role);
        formatter.field("labels", &self.labels);
        formatter.field("taints", &self.taints);
        formatter.field("resources", &self.resources);
        formatter.field("disk_size", &self.disk_size);
        formatter.field("health", &self.health);
        formatter.field("update_config", &self.update_config);
        formatter.field("launch_template", &self.launch_template);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Nodegroup`](crate::model::Nodegroup)
pub mod nodegroup {
    /// A builder for [`Nodegroup`](crate::model::Nodegroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) nodegroup_name: std::option::Option<std::string::String>,
        pub(crate) nodegroup_arn: std::option::Option<std::string::String>,
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) release_version: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) modified_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::NodegroupStatus>,
        pub(crate) capacity_type: std::option::Option<crate::model::CapacityTypes>,
        pub(crate) scaling_config: std::option::Option<crate::model::NodegroupScalingConfig>,
        pub(crate) instance_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) remote_access: std::option::Option<crate::model::RemoteAccessConfig>,
        pub(crate) ami_type: std::option::Option<crate::model::AmiTypes>,
        pub(crate) node_role: std::option::Option<std::string::String>,
        pub(crate) labels: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) taints: std::option::Option<std::vec::Vec<crate::model::Taint>>,
        pub(crate) resources: std::option::Option<crate::model::NodegroupResources>,
        pub(crate) disk_size: std::option::Option<i32>,
        pub(crate) health: std::option::Option<crate::model::NodegroupHealth>,
        pub(crate) update_config: std::option::Option<crate::model::NodegroupUpdateConfig>,
        pub(crate) launch_template: std::option::Option<crate::model::LaunchTemplateSpecification>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name associated with an Amazon EKS managed node group.</p>
        pub fn nodegroup_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.nodegroup_name = Some(input.into());
            self
        }
        /// <p>The name associated with an Amazon EKS managed node group.</p>
        pub fn set_nodegroup_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nodegroup_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the managed node group.</p>
        pub fn nodegroup_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.nodegroup_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) associated with the managed node group.</p>
        pub fn set_nodegroup_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nodegroup_arn = input;
            self
        }
        /// <p>The name of the cluster that the managed node group resides in.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster that the managed node group resides in.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The Kubernetes version of the managed node group.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The Kubernetes version of the managed node group.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>If the node group was deployed using a launch template with a custom AMI, then this is
        /// the AMI ID that was specified in the launch template. For node groups that weren't
        /// deployed using a launch template, this is the version of the Amazon EKS optimized AMI that
        /// the node group was deployed with.</p>
        pub fn release_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.release_version = Some(input.into());
            self
        }
        /// <p>If the node group was deployed using a launch template with a custom AMI, then this is
        /// the AMI ID that was specified in the launch template. For node groups that weren't
        /// deployed using a launch template, this is the version of the Amazon EKS optimized AMI that
        /// the node group was deployed with.</p>
        pub fn set_release_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.release_version = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the managed node group was
        /// created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the managed node group was
        /// created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the managed node group was last
        /// modified.</p>
        pub fn modified_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.modified_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the managed node group was last
        /// modified.</p>
        pub fn set_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.modified_at = input;
            self
        }
        /// <p>The current status of the managed node group.</p>
        pub fn status(mut self, input: crate::model::NodegroupStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the managed node group.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NodegroupStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The capacity type of your managed node group.</p>
        pub fn capacity_type(mut self, input: crate::model::CapacityTypes) -> Self {
            self.capacity_type = Some(input);
            self
        }
        /// <p>The capacity type of your managed node group.</p>
        pub fn set_capacity_type(
            mut self,
            input: std::option::Option<crate::model::CapacityTypes>,
        ) -> Self {
            self.capacity_type = input;
            self
        }
        /// <p>The scaling configuration details for the Auto Scaling group that is associated with
        /// your node group.</p>
        pub fn scaling_config(mut self, input: crate::model::NodegroupScalingConfig) -> Self {
            self.scaling_config = Some(input);
            self
        }
        /// <p>The scaling configuration details for the Auto Scaling group that is associated with
        /// your node group.</p>
        pub fn set_scaling_config(
            mut self,
            input: std::option::Option<crate::model::NodegroupScalingConfig>,
        ) -> Self {
            self.scaling_config = input;
            self
        }
        /// Appends an item to `instance_types`.
        ///
        /// To override the contents of this collection use [`set_instance_types`](Self::set_instance_types).
        ///
        /// <p>If the node group wasn't deployed with a launch template, then this is the instance
        /// type that is associated with the node group. If the node group was deployed with a
        /// launch template, then this is <code>null</code>.</p>
        pub fn instance_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_types.unwrap_or_default();
            v.push(input.into());
            self.instance_types = Some(v);
            self
        }
        /// <p>If the node group wasn't deployed with a launch template, then this is the instance
        /// type that is associated with the node group. If the node group was deployed with a
        /// launch template, then this is <code>null</code>.</p>
        pub fn set_instance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_types = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The subnets that were specified for the Auto Scaling group that is associated with
        /// your node group.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>The subnets that were specified for the Auto Scaling group that is associated with
        /// your node group.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// <p>If the node group wasn't deployed with a launch template, then this is the remote
        /// access configuration that is associated with the node group. If the node group was
        /// deployed with a launch template, then this is <code>null</code>.</p>
        pub fn remote_access(mut self, input: crate::model::RemoteAccessConfig) -> Self {
            self.remote_access = Some(input);
            self
        }
        /// <p>If the node group wasn't deployed with a launch template, then this is the remote
        /// access configuration that is associated with the node group. If the node group was
        /// deployed with a launch template, then this is <code>null</code>.</p>
        pub fn set_remote_access(
            mut self,
            input: std::option::Option<crate::model::RemoteAccessConfig>,
        ) -> Self {
            self.remote_access = input;
            self
        }
        /// <p>If the node group was deployed using a launch template with a custom AMI, then this is
        /// <code>CUSTOM</code>. For node groups that weren't deployed using a launch template,
        /// this is the AMI type that was specified in the node group configuration.</p>
        pub fn ami_type(mut self, input: crate::model::AmiTypes) -> Self {
            self.ami_type = Some(input);
            self
        }
        /// <p>If the node group was deployed using a launch template with a custom AMI, then this is
        /// <code>CUSTOM</code>. For node groups that weren't deployed using a launch template,
        /// this is the AMI type that was specified in the node group configuration.</p>
        pub fn set_ami_type(mut self, input: std::option::Option<crate::model::AmiTypes>) -> Self {
            self.ami_type = input;
            self
        }
        /// <p>The IAM role associated with your node group. The Amazon EKS node <code>kubelet</code>
        /// daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive permissions for these API
        /// calls through an IAM instance profile and associated policies.</p>
        pub fn node_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_role = Some(input.into());
            self
        }
        /// <p>The IAM role associated with your node group. The Amazon EKS node <code>kubelet</code>
        /// daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive permissions for these API
        /// calls through an IAM instance profile and associated policies.</p>
        pub fn set_node_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_role = input;
            self
        }
        /// Adds a key-value pair to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>The Kubernetes labels applied to the nodes in the node group.</p>
        /// <note>
        /// <p>Only labels that are applied with the Amazon EKS API are shown here. There may be other
        /// Kubernetes labels applied to the nodes in this group.</p>
        /// </note>
        pub fn labels(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.labels.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.labels = Some(hash_map);
            self
        }
        /// <p>The Kubernetes labels applied to the nodes in the node group.</p>
        /// <note>
        /// <p>Only labels that are applied with the Amazon EKS API are shown here. There may be other
        /// Kubernetes labels applied to the nodes in this group.</p>
        /// </note>
        pub fn set_labels(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.labels = input;
            self
        }
        /// Appends an item to `taints`.
        ///
        /// To override the contents of this collection use [`set_taints`](Self::set_taints).
        ///
        /// <p>The Kubernetes taints to be applied to the nodes in the node group when they are
        /// created. Effect is one of <code>No_Schedule</code>, <code>Prefer_No_Schedule</code>, or <code>No_Execute</code>. Kubernetes taints
        /// can be used together with tolerations to control how workloads are scheduled to your
        /// nodes.</p>
        pub fn taints(mut self, input: impl Into<crate::model::Taint>) -> Self {
            let mut v = self.taints.unwrap_or_default();
            v.push(input.into());
            self.taints = Some(v);
            self
        }
        /// <p>The Kubernetes taints to be applied to the nodes in the node group when they are
        /// created. Effect is one of <code>No_Schedule</code>, <code>Prefer_No_Schedule</code>, or <code>No_Execute</code>. Kubernetes taints
        /// can be used together with tolerations to control how workloads are scheduled to your
        /// nodes.</p>
        pub fn set_taints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Taint>>,
        ) -> Self {
            self.taints = input;
            self
        }
        /// <p>The resources associated with the node group, such as Auto Scaling groups and security
        /// groups for remote access.</p>
        pub fn resources(mut self, input: crate::model::NodegroupResources) -> Self {
            self.resources = Some(input);
            self
        }
        /// <p>The resources associated with the node group, such as Auto Scaling groups and security
        /// groups for remote access.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<crate::model::NodegroupResources>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>If the node group wasn't deployed with a launch template, then this is the disk size
        /// in the node group configuration. If the node group was deployed with a launch template,
        /// then this is <code>null</code>.</p>
        pub fn disk_size(mut self, input: i32) -> Self {
            self.disk_size = Some(input);
            self
        }
        /// <p>If the node group wasn't deployed with a launch template, then this is the disk size
        /// in the node group configuration. If the node group was deployed with a launch template,
        /// then this is <code>null</code>.</p>
        pub fn set_disk_size(mut self, input: std::option::Option<i32>) -> Self {
            self.disk_size = input;
            self
        }
        /// <p>The health status of the node group. If there are issues with your node group's
        /// health, they are listed here.</p>
        pub fn health(mut self, input: crate::model::NodegroupHealth) -> Self {
            self.health = Some(input);
            self
        }
        /// <p>The health status of the node group. If there are issues with your node group's
        /// health, they are listed here.</p>
        pub fn set_health(
            mut self,
            input: std::option::Option<crate::model::NodegroupHealth>,
        ) -> Self {
            self.health = input;
            self
        }
        /// <p>The node group update configuration.</p>
        pub fn update_config(mut self, input: crate::model::NodegroupUpdateConfig) -> Self {
            self.update_config = Some(input);
            self
        }
        /// <p>The node group update configuration.</p>
        pub fn set_update_config(
            mut self,
            input: std::option::Option<crate::model::NodegroupUpdateConfig>,
        ) -> Self {
            self.update_config = input;
            self
        }
        /// <p>If a launch template was used to create the node group, then this is the launch
        /// template that was used.</p>
        pub fn launch_template(mut self, input: crate::model::LaunchTemplateSpecification) -> Self {
            self.launch_template = Some(input);
            self
        }
        /// <p>If a launch template was used to create the node group, then this is the launch
        /// template that was used.</p>
        pub fn set_launch_template(
            mut self,
            input: std::option::Option<crate::model::LaunchTemplateSpecification>,
        ) -> Self {
            self.launch_template = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata applied to the node group to assist with categorization and organization.
        /// Each tag consists of a key and an optional value, both of which you define. Node group
        /// tags do not propagate to any other resources associated with the node group, such as the
        /// Amazon EC2 instances or subnets. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The metadata applied to the node group to assist with categorization and organization.
        /// Each tag consists of a key and an optional value, both of which you define. Node group
        /// tags do not propagate to any other resources associated with the node group, such as the
        /// Amazon EC2 instances or subnets. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Nodegroup`](crate::model::Nodegroup)
        pub fn build(self) -> crate::model::Nodegroup {
            crate::model::Nodegroup {
                nodegroup_name: self.nodegroup_name,
                nodegroup_arn: self.nodegroup_arn,
                cluster_name: self.cluster_name,
                version: self.version,
                release_version: self.release_version,
                created_at: self.created_at,
                modified_at: self.modified_at,
                status: self.status,
                capacity_type: self.capacity_type,
                scaling_config: self.scaling_config,
                instance_types: self.instance_types,
                subnets: self.subnets,
                remote_access: self.remote_access,
                ami_type: self.ami_type,
                node_role: self.node_role,
                labels: self.labels,
                taints: self.taints,
                resources: self.resources,
                disk_size: self.disk_size,
                health: self.health,
                update_config: self.update_config,
                launch_template: self.launch_template,
                tags: self.tags,
            }
        }
    }
}
impl Nodegroup {
    /// Creates a new builder-style object to manufacture [`Nodegroup`](crate::model::Nodegroup)
    pub fn builder() -> crate::model::nodegroup::Builder {
        crate::model::nodegroup::Builder::default()
    }
}

/// <p>An object representing the health status of the node group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodegroupHealth {
    /// <p>Any issues that are associated with the node group. </p>
    pub issues: std::option::Option<std::vec::Vec<crate::model::Issue>>,
}
impl std::fmt::Debug for NodegroupHealth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodegroupHealth");
        formatter.field("issues", &self.issues);
        formatter.finish()
    }
}
/// See [`NodegroupHealth`](crate::model::NodegroupHealth)
pub mod nodegroup_health {
    /// A builder for [`NodegroupHealth`](crate::model::NodegroupHealth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) issues: std::option::Option<std::vec::Vec<crate::model::Issue>>,
    }
    impl Builder {
        /// Appends an item to `issues`.
        ///
        /// To override the contents of this collection use [`set_issues`](Self::set_issues).
        ///
        /// <p>Any issues that are associated with the node group. </p>
        pub fn issues(mut self, input: impl Into<crate::model::Issue>) -> Self {
            let mut v = self.issues.unwrap_or_default();
            v.push(input.into());
            self.issues = Some(v);
            self
        }
        /// <p>Any issues that are associated with the node group. </p>
        pub fn set_issues(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Issue>>,
        ) -> Self {
            self.issues = input;
            self
        }
        /// Consumes the builder and constructs a [`NodegroupHealth`](crate::model::NodegroupHealth)
        pub fn build(self) -> crate::model::NodegroupHealth {
            crate::model::NodegroupHealth {
                issues: self.issues,
            }
        }
    }
}
impl NodegroupHealth {
    /// Creates a new builder-style object to manufacture [`NodegroupHealth`](crate::model::NodegroupHealth)
    pub fn builder() -> crate::model::nodegroup_health::Builder {
        crate::model::nodegroup_health::Builder::default()
    }
}

/// <p>An object representing an issue with an Amazon EKS resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Issue {
    /// <p>A brief description of the error.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>AccessDenied</b>: Amazon EKS or one or more of your
    /// managed nodes is failing to authenticate or authorize with your Kubernetes
    /// cluster API server.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>AsgInstanceLaunchFailures</b>: Your Auto Scaling group is
    /// experiencing failures while attempting to launch instances.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>AutoScalingGroupNotFound</b>: We couldn't find
    /// the Auto Scaling group associated with the managed node group. You may be able to
    /// recreate an Auto Scaling group with the same settings to recover.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>ClusterUnreachable</b>: Amazon EKS or one or more of
    /// your managed nodes is unable to to communicate with your Kubernetes cluster API
    /// server. This can happen if there are network disruptions or if API servers are
    /// timing out processing requests. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Ec2LaunchTemplateNotFound</b>: We couldn't find
    /// the Amazon EC2 launch template for your managed node group. You may be able to
    /// recreate a launch template with the same settings to recover.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Ec2LaunchTemplateVersionMismatch</b>: The Amazon EC2
    /// launch template version for your managed node group does not match the version
    /// that Amazon EKS created. You may be able to revert to the version that Amazon EKS created
    /// to recover.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Ec2SecurityGroupDeletionFailure</b>: We could not
    /// delete the remote access security group for your managed node group. Remove any
    /// dependencies from the security group.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Ec2SecurityGroupNotFound</b>: We couldn't find
    /// the cluster security group for the cluster. You must recreate your
    /// cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Ec2SubnetInvalidConfiguration</b>: One or more
    /// Amazon EC2 subnets specified for a node group do not automatically assign public IP
    /// addresses to instances launched into it. If you want your instances to be
    /// assigned a public IP address, then you need to enable the <code>auto-assign
    /// public IP address</code> setting for the subnet. See <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html#subnet-public-ip">Modifying
    /// the public IPv4 addressing attribute for your subnet</a> in the Amazon
    /// VPC User Guide.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>IamInstanceProfileNotFound</b>: We couldn't find
    /// the IAM instance profile for your managed node group. You may be able to
    /// recreate an instance profile with the same settings to recover.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>IamNodeRoleNotFound</b>: We couldn't find the
    /// IAM role for your managed node group. You may be able to recreate an IAM role
    /// with the same settings to recover.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>InstanceLimitExceeded</b>: Your Amazon Web Services account is
    /// unable to launch any more instances of the specified instance type. You may be
    /// able to request an Amazon EC2 instance limit increase to recover.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>InsufficientFreeAddresses</b>: One or more of the
    /// subnets associated with your managed node group does not have enough available
    /// IP addresses for new nodes.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>InternalFailure</b>: These errors are usually
    /// caused by an Amazon EKS server-side issue.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>NodeCreationFailure</b>: Your launched instances
    /// are unable to register with your Amazon EKS cluster. Common causes of this failure
    /// are insufficient <a href="https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html">node IAM role</a>
    /// permissions or lack of outbound internet access for the nodes. </p>
    /// </li>
    /// </ul>
    pub code: std::option::Option<crate::model::NodegroupIssueCode>,
    /// <p>The error message associated with the issue.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services resources that are afflicted by this issue.</p>
    pub resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for Issue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Issue");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("resource_ids", &self.resource_ids);
        formatter.finish()
    }
}
/// See [`Issue`](crate::model::Issue)
pub mod issue {
    /// A builder for [`Issue`](crate::model::Issue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::NodegroupIssueCode>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A brief description of the error.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>AccessDenied</b>: Amazon EKS or one or more of your
        /// managed nodes is failing to authenticate or authorize with your Kubernetes
        /// cluster API server.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AsgInstanceLaunchFailures</b>: Your Auto Scaling group is
        /// experiencing failures while attempting to launch instances.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AutoScalingGroupNotFound</b>: We couldn't find
        /// the Auto Scaling group associated with the managed node group. You may be able to
        /// recreate an Auto Scaling group with the same settings to recover.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>ClusterUnreachable</b>: Amazon EKS or one or more of
        /// your managed nodes is unable to to communicate with your Kubernetes cluster API
        /// server. This can happen if there are network disruptions or if API servers are
        /// timing out processing requests. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Ec2LaunchTemplateNotFound</b>: We couldn't find
        /// the Amazon EC2 launch template for your managed node group. You may be able to
        /// recreate a launch template with the same settings to recover.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Ec2LaunchTemplateVersionMismatch</b>: The Amazon EC2
        /// launch template version for your managed node group does not match the version
        /// that Amazon EKS created. You may be able to revert to the version that Amazon EKS created
        /// to recover.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Ec2SecurityGroupDeletionFailure</b>: We could not
        /// delete the remote access security group for your managed node group. Remove any
        /// dependencies from the security group.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Ec2SecurityGroupNotFound</b>: We couldn't find
        /// the cluster security group for the cluster. You must recreate your
        /// cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Ec2SubnetInvalidConfiguration</b>: One or more
        /// Amazon EC2 subnets specified for a node group do not automatically assign public IP
        /// addresses to instances launched into it. If you want your instances to be
        /// assigned a public IP address, then you need to enable the <code>auto-assign
        /// public IP address</code> setting for the subnet. See <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html#subnet-public-ip">Modifying
        /// the public IPv4 addressing attribute for your subnet</a> in the Amazon
        /// VPC User Guide.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>IamInstanceProfileNotFound</b>: We couldn't find
        /// the IAM instance profile for your managed node group. You may be able to
        /// recreate an instance profile with the same settings to recover.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>IamNodeRoleNotFound</b>: We couldn't find the
        /// IAM role for your managed node group. You may be able to recreate an IAM role
        /// with the same settings to recover.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>InstanceLimitExceeded</b>: Your Amazon Web Services account is
        /// unable to launch any more instances of the specified instance type. You may be
        /// able to request an Amazon EC2 instance limit increase to recover.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>InsufficientFreeAddresses</b>: One or more of the
        /// subnets associated with your managed node group does not have enough available
        /// IP addresses for new nodes.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>InternalFailure</b>: These errors are usually
        /// caused by an Amazon EKS server-side issue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>NodeCreationFailure</b>: Your launched instances
        /// are unable to register with your Amazon EKS cluster. Common causes of this failure
        /// are insufficient <a href="https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html">node IAM role</a>
        /// permissions or lack of outbound internet access for the nodes. </p>
        /// </li>
        /// </ul>
        pub fn code(mut self, input: crate::model::NodegroupIssueCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>A brief description of the error.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>AccessDenied</b>: Amazon EKS or one or more of your
        /// managed nodes is failing to authenticate or authorize with your Kubernetes
        /// cluster API server.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AsgInstanceLaunchFailures</b>: Your Auto Scaling group is
        /// experiencing failures while attempting to launch instances.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AutoScalingGroupNotFound</b>: We couldn't find
        /// the Auto Scaling group associated with the managed node group. You may be able to
        /// recreate an Auto Scaling group with the same settings to recover.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>ClusterUnreachable</b>: Amazon EKS or one or more of
        /// your managed nodes is unable to to communicate with your Kubernetes cluster API
        /// server. This can happen if there are network disruptions or if API servers are
        /// timing out processing requests. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Ec2LaunchTemplateNotFound</b>: We couldn't find
        /// the Amazon EC2 launch template for your managed node group. You may be able to
        /// recreate a launch template with the same settings to recover.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Ec2LaunchTemplateVersionMismatch</b>: The Amazon EC2
        /// launch template version for your managed node group does not match the version
        /// that Amazon EKS created. You may be able to revert to the version that Amazon EKS created
        /// to recover.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Ec2SecurityGroupDeletionFailure</b>: We could not
        /// delete the remote access security group for your managed node group. Remove any
        /// dependencies from the security group.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Ec2SecurityGroupNotFound</b>: We couldn't find
        /// the cluster security group for the cluster. You must recreate your
        /// cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Ec2SubnetInvalidConfiguration</b>: One or more
        /// Amazon EC2 subnets specified for a node group do not automatically assign public IP
        /// addresses to instances launched into it. If you want your instances to be
        /// assigned a public IP address, then you need to enable the <code>auto-assign
        /// public IP address</code> setting for the subnet. See <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html#subnet-public-ip">Modifying
        /// the public IPv4 addressing attribute for your subnet</a> in the Amazon
        /// VPC User Guide.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>IamInstanceProfileNotFound</b>: We couldn't find
        /// the IAM instance profile for your managed node group. You may be able to
        /// recreate an instance profile with the same settings to recover.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>IamNodeRoleNotFound</b>: We couldn't find the
        /// IAM role for your managed node group. You may be able to recreate an IAM role
        /// with the same settings to recover.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>InstanceLimitExceeded</b>: Your Amazon Web Services account is
        /// unable to launch any more instances of the specified instance type. You may be
        /// able to request an Amazon EC2 instance limit increase to recover.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>InsufficientFreeAddresses</b>: One or more of the
        /// subnets associated with your managed node group does not have enough available
        /// IP addresses for new nodes.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>InternalFailure</b>: These errors are usually
        /// caused by an Amazon EKS server-side issue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>NodeCreationFailure</b>: Your launched instances
        /// are unable to register with your Amazon EKS cluster. Common causes of this failure
        /// are insufficient <a href="https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html">node IAM role</a>
        /// permissions or lack of outbound internet access for the nodes. </p>
        /// </li>
        /// </ul>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::NodegroupIssueCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>The error message associated with the issue.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message associated with the issue.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `resource_ids`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>The Amazon Web Services resources that are afflicted by this issue.</p>
        pub fn resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_ids.unwrap_or_default();
            v.push(input.into());
            self.resource_ids = Some(v);
            self
        }
        /// <p>The Amazon Web Services resources that are afflicted by this issue.</p>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`Issue`](crate::model::Issue)
        pub fn build(self) -> crate::model::Issue {
            crate::model::Issue {
                code: self.code,
                message: self.message,
                resource_ids: self.resource_ids,
            }
        }
    }
}
impl Issue {
    /// Creates a new builder-style object to manufacture [`Issue`](crate::model::Issue)
    pub fn builder() -> crate::model::issue::Builder {
        crate::model::issue::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NodegroupIssueCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    AsgInstanceLaunchFailures,
    #[allow(missing_docs)] // documentation missing in model
    AutoScalingGroupInvalidConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    AutoScalingGroupNotFound,
    #[allow(missing_docs)] // documentation missing in model
    ClusterUnreachable,
    #[allow(missing_docs)] // documentation missing in model
    Ec2LaunchTemplateNotFound,
    #[allow(missing_docs)] // documentation missing in model
    Ec2LaunchTemplateVersionMismatch,
    #[allow(missing_docs)] // documentation missing in model
    Ec2SecurityGroupDeletionFailure,
    #[allow(missing_docs)] // documentation missing in model
    Ec2SecurityGroupNotFound,
    #[allow(missing_docs)] // documentation missing in model
    Ec2SubnetInvalidConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    Ec2SubnetNotFound,
    #[allow(missing_docs)] // documentation missing in model
    IamInstanceProfileNotFound,
    #[allow(missing_docs)] // documentation missing in model
    IamLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    IamNodeRoleNotFound,
    #[allow(missing_docs)] // documentation missing in model
    InstanceLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    InsufficientFreeAddresses,
    #[allow(missing_docs)] // documentation missing in model
    InternalFailure,
    #[allow(missing_docs)] // documentation missing in model
    NodeCreationFailure,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NodegroupIssueCode {
    fn from(s: &str) -> Self {
        match s {
            "AccessDenied" => NodegroupIssueCode::AccessDenied,
            "AsgInstanceLaunchFailures" => NodegroupIssueCode::AsgInstanceLaunchFailures,
            "AutoScalingGroupInvalidConfiguration" => {
                NodegroupIssueCode::AutoScalingGroupInvalidConfiguration
            }
            "AutoScalingGroupNotFound" => NodegroupIssueCode::AutoScalingGroupNotFound,
            "ClusterUnreachable" => NodegroupIssueCode::ClusterUnreachable,
            "Ec2LaunchTemplateNotFound" => NodegroupIssueCode::Ec2LaunchTemplateNotFound,
            "Ec2LaunchTemplateVersionMismatch" => {
                NodegroupIssueCode::Ec2LaunchTemplateVersionMismatch
            }
            "Ec2SecurityGroupDeletionFailure" => {
                NodegroupIssueCode::Ec2SecurityGroupDeletionFailure
            }
            "Ec2SecurityGroupNotFound" => NodegroupIssueCode::Ec2SecurityGroupNotFound,
            "Ec2SubnetInvalidConfiguration" => NodegroupIssueCode::Ec2SubnetInvalidConfiguration,
            "Ec2SubnetNotFound" => NodegroupIssueCode::Ec2SubnetNotFound,
            "IamInstanceProfileNotFound" => NodegroupIssueCode::IamInstanceProfileNotFound,
            "IamLimitExceeded" => NodegroupIssueCode::IamLimitExceeded,
            "IamNodeRoleNotFound" => NodegroupIssueCode::IamNodeRoleNotFound,
            "InstanceLimitExceeded" => NodegroupIssueCode::InstanceLimitExceeded,
            "InsufficientFreeAddresses" => NodegroupIssueCode::InsufficientFreeAddresses,
            "InternalFailure" => NodegroupIssueCode::InternalFailure,
            "NodeCreationFailure" => NodegroupIssueCode::NodeCreationFailure,
            other => NodegroupIssueCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NodegroupIssueCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NodegroupIssueCode::from(s))
    }
}
impl NodegroupIssueCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NodegroupIssueCode::AccessDenied => "AccessDenied",
            NodegroupIssueCode::AsgInstanceLaunchFailures => "AsgInstanceLaunchFailures",
            NodegroupIssueCode::AutoScalingGroupInvalidConfiguration => {
                "AutoScalingGroupInvalidConfiguration"
            }
            NodegroupIssueCode::AutoScalingGroupNotFound => "AutoScalingGroupNotFound",
            NodegroupIssueCode::ClusterUnreachable => "ClusterUnreachable",
            NodegroupIssueCode::Ec2LaunchTemplateNotFound => "Ec2LaunchTemplateNotFound",
            NodegroupIssueCode::Ec2LaunchTemplateVersionMismatch => {
                "Ec2LaunchTemplateVersionMismatch"
            }
            NodegroupIssueCode::Ec2SecurityGroupDeletionFailure => {
                "Ec2SecurityGroupDeletionFailure"
            }
            NodegroupIssueCode::Ec2SecurityGroupNotFound => "Ec2SecurityGroupNotFound",
            NodegroupIssueCode::Ec2SubnetInvalidConfiguration => "Ec2SubnetInvalidConfiguration",
            NodegroupIssueCode::Ec2SubnetNotFound => "Ec2SubnetNotFound",
            NodegroupIssueCode::IamInstanceProfileNotFound => "IamInstanceProfileNotFound",
            NodegroupIssueCode::IamLimitExceeded => "IamLimitExceeded",
            NodegroupIssueCode::IamNodeRoleNotFound => "IamNodeRoleNotFound",
            NodegroupIssueCode::InstanceLimitExceeded => "InstanceLimitExceeded",
            NodegroupIssueCode::InsufficientFreeAddresses => "InsufficientFreeAddresses",
            NodegroupIssueCode::InternalFailure => "InternalFailure",
            NodegroupIssueCode::NodeCreationFailure => "NodeCreationFailure",
            NodegroupIssueCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccessDenied",
            "AsgInstanceLaunchFailures",
            "AutoScalingGroupInvalidConfiguration",
            "AutoScalingGroupNotFound",
            "ClusterUnreachable",
            "Ec2LaunchTemplateNotFound",
            "Ec2LaunchTemplateVersionMismatch",
            "Ec2SecurityGroupDeletionFailure",
            "Ec2SecurityGroupNotFound",
            "Ec2SubnetInvalidConfiguration",
            "Ec2SubnetNotFound",
            "IamInstanceProfileNotFound",
            "IamLimitExceeded",
            "IamNodeRoleNotFound",
            "InstanceLimitExceeded",
            "InsufficientFreeAddresses",
            "InternalFailure",
            "NodeCreationFailure",
        ]
    }
}
impl AsRef<str> for NodegroupIssueCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing the resources associated with the node group, such as Auto
/// Scaling groups and security groups for remote access.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodegroupResources {
    /// <p>The Auto Scaling groups associated with the node group.</p>
    pub auto_scaling_groups: std::option::Option<std::vec::Vec<crate::model::AutoScalingGroup>>,
    /// <p>The remote access security group associated with the node group. This security group
    /// controls SSH access to the nodes.</p>
    pub remote_access_security_group: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NodegroupResources {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodegroupResources");
        formatter.field("auto_scaling_groups", &self.auto_scaling_groups);
        formatter.field(
            "remote_access_security_group",
            &self.remote_access_security_group,
        );
        formatter.finish()
    }
}
/// See [`NodegroupResources`](crate::model::NodegroupResources)
pub mod nodegroup_resources {
    /// A builder for [`NodegroupResources`](crate::model::NodegroupResources)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_groups:
            std::option::Option<std::vec::Vec<crate::model::AutoScalingGroup>>,
        pub(crate) remote_access_security_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `auto_scaling_groups`.
        ///
        /// To override the contents of this collection use [`set_auto_scaling_groups`](Self::set_auto_scaling_groups).
        ///
        /// <p>The Auto Scaling groups associated with the node group.</p>
        pub fn auto_scaling_groups(
            mut self,
            input: impl Into<crate::model::AutoScalingGroup>,
        ) -> Self {
            let mut v = self.auto_scaling_groups.unwrap_or_default();
            v.push(input.into());
            self.auto_scaling_groups = Some(v);
            self
        }
        /// <p>The Auto Scaling groups associated with the node group.</p>
        pub fn set_auto_scaling_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutoScalingGroup>>,
        ) -> Self {
            self.auto_scaling_groups = input;
            self
        }
        /// <p>The remote access security group associated with the node group. This security group
        /// controls SSH access to the nodes.</p>
        pub fn remote_access_security_group(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.remote_access_security_group = Some(input.into());
            self
        }
        /// <p>The remote access security group associated with the node group. This security group
        /// controls SSH access to the nodes.</p>
        pub fn set_remote_access_security_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.remote_access_security_group = input;
            self
        }
        /// Consumes the builder and constructs a [`NodegroupResources`](crate::model::NodegroupResources)
        pub fn build(self) -> crate::model::NodegroupResources {
            crate::model::NodegroupResources {
                auto_scaling_groups: self.auto_scaling_groups,
                remote_access_security_group: self.remote_access_security_group,
            }
        }
    }
}
impl NodegroupResources {
    /// Creates a new builder-style object to manufacture [`NodegroupResources`](crate::model::NodegroupResources)
    pub fn builder() -> crate::model::nodegroup_resources::Builder {
        crate::model::nodegroup_resources::Builder::default()
    }
}

/// <p>An Auto Scaling group that is associated with an Amazon EKS managed node group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingGroup {
    /// <p>The name of the Auto Scaling group associated with an Amazon EKS managed node group.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AutoScalingGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingGroup");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`AutoScalingGroup`](crate::model::AutoScalingGroup)
pub mod auto_scaling_group {
    /// A builder for [`AutoScalingGroup`](crate::model::AutoScalingGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group associated with an Amazon EKS managed node group.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group associated with an Amazon EKS managed node group.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingGroup`](crate::model::AutoScalingGroup)
        pub fn build(self) -> crate::model::AutoScalingGroup {
            crate::model::AutoScalingGroup { name: self.name }
        }
    }
}
impl AutoScalingGroup {
    /// Creates a new builder-style object to manufacture [`AutoScalingGroup`](crate::model::AutoScalingGroup)
    pub fn builder() -> crate::model::auto_scaling_group::Builder {
        crate::model::auto_scaling_group::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AmiTypes {
    #[allow(missing_docs)] // documentation missing in model
    Al2Arm64,
    #[allow(missing_docs)] // documentation missing in model
    Al2X8664,
    #[allow(missing_docs)] // documentation missing in model
    Al2X8664Gpu,
    #[allow(missing_docs)] // documentation missing in model
    BottlerocketArm64,
    #[allow(missing_docs)] // documentation missing in model
    BottlerocketX8664,
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AmiTypes {
    fn from(s: &str) -> Self {
        match s {
            "AL2_ARM_64" => AmiTypes::Al2Arm64,
            "AL2_x86_64" => AmiTypes::Al2X8664,
            "AL2_x86_64_GPU" => AmiTypes::Al2X8664Gpu,
            "BOTTLEROCKET_ARM_64" => AmiTypes::BottlerocketArm64,
            "BOTTLEROCKET_x86_64" => AmiTypes::BottlerocketX8664,
            "CUSTOM" => AmiTypes::Custom,
            other => AmiTypes::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AmiTypes {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AmiTypes::from(s))
    }
}
impl AmiTypes {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AmiTypes::Al2Arm64 => "AL2_ARM_64",
            AmiTypes::Al2X8664 => "AL2_x86_64",
            AmiTypes::Al2X8664Gpu => "AL2_x86_64_GPU",
            AmiTypes::BottlerocketArm64 => "BOTTLEROCKET_ARM_64",
            AmiTypes::BottlerocketX8664 => "BOTTLEROCKET_x86_64",
            AmiTypes::Custom => "CUSTOM",
            AmiTypes::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AL2_ARM_64",
            "AL2_x86_64",
            "AL2_x86_64_GPU",
            "BOTTLEROCKET_ARM_64",
            "BOTTLEROCKET_x86_64",
            "CUSTOM",
        ]
    }
}
impl AsRef<str> for AmiTypes {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing the remote access configuration for the managed node
/// group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoteAccessConfig {
    /// <p>The Amazon EC2 SSH key that provides access for SSH communication with the nodes in the
    /// managed node group. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key
    /// pairs and Linux instances</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux Instances</i>.</p>
    pub ec2_ssh_key: std::option::Option<std::string::String>,
    /// <p>The security groups that are allowed SSH access (port 22) to the nodes. If you specify
    /// an Amazon EC2 SSH key but do not specify a source security group when you create a managed
    /// node group, then port 22 on the nodes is opened to the internet (0.0.0.0/0). For more
    /// information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Security Groups for Your VPC</a> in the
    /// <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    pub source_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for RemoteAccessConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoteAccessConfig");
        formatter.field("ec2_ssh_key", &self.ec2_ssh_key);
        formatter.field("source_security_groups", &self.source_security_groups);
        formatter.finish()
    }
}
/// See [`RemoteAccessConfig`](crate::model::RemoteAccessConfig)
pub mod remote_access_config {
    /// A builder for [`RemoteAccessConfig`](crate::model::RemoteAccessConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ec2_ssh_key: std::option::Option<std::string::String>,
        pub(crate) source_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon EC2 SSH key that provides access for SSH communication with the nodes in the
        /// managed node group. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key
        /// pairs and Linux instances</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux Instances</i>.</p>
        pub fn ec2_ssh_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_ssh_key = Some(input.into());
            self
        }
        /// <p>The Amazon EC2 SSH key that provides access for SSH communication with the nodes in the
        /// managed node group. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key
        /// pairs and Linux instances</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux Instances</i>.</p>
        pub fn set_ec2_ssh_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ec2_ssh_key = input;
            self
        }
        /// Appends an item to `source_security_groups`.
        ///
        /// To override the contents of this collection use [`set_source_security_groups`](Self::set_source_security_groups).
        ///
        /// <p>The security groups that are allowed SSH access (port 22) to the nodes. If you specify
        /// an Amazon EC2 SSH key but do not specify a source security group when you create a managed
        /// node group, then port 22 on the nodes is opened to the internet (0.0.0.0/0). For more
        /// information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Security Groups for Your VPC</a> in the
        /// <i>Amazon Virtual Private Cloud User Guide</i>.</p>
        pub fn source_security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_security_groups.unwrap_or_default();
            v.push(input.into());
            self.source_security_groups = Some(v);
            self
        }
        /// <p>The security groups that are allowed SSH access (port 22) to the nodes. If you specify
        /// an Amazon EC2 SSH key but do not specify a source security group when you create a managed
        /// node group, then port 22 on the nodes is opened to the internet (0.0.0.0/0). For more
        /// information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Security Groups for Your VPC</a> in the
        /// <i>Amazon Virtual Private Cloud User Guide</i>.</p>
        pub fn set_source_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_security_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoteAccessConfig`](crate::model::RemoteAccessConfig)
        pub fn build(self) -> crate::model::RemoteAccessConfig {
            crate::model::RemoteAccessConfig {
                ec2_ssh_key: self.ec2_ssh_key,
                source_security_groups: self.source_security_groups,
            }
        }
    }
}
impl RemoteAccessConfig {
    /// Creates a new builder-style object to manufacture [`RemoteAccessConfig`](crate::model::RemoteAccessConfig)
    pub fn builder() -> crate::model::remote_access_config::Builder {
        crate::model::remote_access_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CapacityTypes {
    #[allow(missing_docs)] // documentation missing in model
    OnDemand,
    #[allow(missing_docs)] // documentation missing in model
    Spot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CapacityTypes {
    fn from(s: &str) -> Self {
        match s {
            "ON_DEMAND" => CapacityTypes::OnDemand,
            "SPOT" => CapacityTypes::Spot,
            other => CapacityTypes::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CapacityTypes {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CapacityTypes::from(s))
    }
}
impl CapacityTypes {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CapacityTypes::OnDemand => "ON_DEMAND",
            CapacityTypes::Spot => "SPOT",
            CapacityTypes::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ON_DEMAND", "SPOT"]
    }
}
impl AsRef<str> for CapacityTypes {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NodegroupStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Degraded,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NodegroupStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => NodegroupStatus::Active,
            "CREATE_FAILED" => NodegroupStatus::CreateFailed,
            "CREATING" => NodegroupStatus::Creating,
            "DEGRADED" => NodegroupStatus::Degraded,
            "DELETE_FAILED" => NodegroupStatus::DeleteFailed,
            "DELETING" => NodegroupStatus::Deleting,
            "UPDATING" => NodegroupStatus::Updating,
            other => NodegroupStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NodegroupStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NodegroupStatus::from(s))
    }
}
impl NodegroupStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NodegroupStatus::Active => "ACTIVE",
            NodegroupStatus::CreateFailed => "CREATE_FAILED",
            NodegroupStatus::Creating => "CREATING",
            NodegroupStatus::Degraded => "DEGRADED",
            NodegroupStatus::DeleteFailed => "DELETE_FAILED",
            NodegroupStatus::Deleting => "DELETING",
            NodegroupStatus::Updating => "UPDATING",
            NodegroupStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATE_FAILED",
            "CREATING",
            "DEGRADED",
            "DELETE_FAILED",
            "DELETING",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for NodegroupStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The full description of your identity configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdentityProviderConfigResponse {
    /// <p>An object that represents an OpenID Connect (OIDC) identity provider
    /// configuration.</p>
    pub oidc: std::option::Option<crate::model::OidcIdentityProviderConfig>,
}
impl std::fmt::Debug for IdentityProviderConfigResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdentityProviderConfigResponse");
        formatter.field("oidc", &self.oidc);
        formatter.finish()
    }
}
/// See [`IdentityProviderConfigResponse`](crate::model::IdentityProviderConfigResponse)
pub mod identity_provider_config_response {
    /// A builder for [`IdentityProviderConfigResponse`](crate::model::IdentityProviderConfigResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) oidc: std::option::Option<crate::model::OidcIdentityProviderConfig>,
    }
    impl Builder {
        /// <p>An object that represents an OpenID Connect (OIDC) identity provider
        /// configuration.</p>
        pub fn oidc(mut self, input: crate::model::OidcIdentityProviderConfig) -> Self {
            self.oidc = Some(input);
            self
        }
        /// <p>An object that represents an OpenID Connect (OIDC) identity provider
        /// configuration.</p>
        pub fn set_oidc(
            mut self,
            input: std::option::Option<crate::model::OidcIdentityProviderConfig>,
        ) -> Self {
            self.oidc = input;
            self
        }
        /// Consumes the builder and constructs a [`IdentityProviderConfigResponse`](crate::model::IdentityProviderConfigResponse)
        pub fn build(self) -> crate::model::IdentityProviderConfigResponse {
            crate::model::IdentityProviderConfigResponse { oidc: self.oidc }
        }
    }
}
impl IdentityProviderConfigResponse {
    /// Creates a new builder-style object to manufacture [`IdentityProviderConfigResponse`](crate::model::IdentityProviderConfigResponse)
    pub fn builder() -> crate::model::identity_provider_config_response::Builder {
        crate::model::identity_provider_config_response::Builder::default()
    }
}

/// <p>An object that represents the configuration for an OpenID Connect (OIDC) identity
/// provider. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OidcIdentityProviderConfig {
    /// <p>The name of the configuration.</p>
    pub identity_provider_config_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the configuration.</p>
    pub identity_provider_config_arn: std::option::Option<std::string::String>,
    /// <p>The cluster that the configuration is associated to.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The URL of the OIDC identity provider that allows the API server to discover public
    /// signing keys for verifying tokens.</p>
    pub issuer_url: std::option::Option<std::string::String>,
    /// <p>This is also known as <i>audience</i>. The ID of the client application
    /// that makes authentication requests to the OIDC identity provider.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The JSON Web token (JWT) claim that is used as the username.</p>
    pub username_claim: std::option::Option<std::string::String>,
    /// <p>The prefix that is prepended to username claims to prevent clashes with existing
    /// names. The prefix can't contain <code>system:</code>
    /// </p>
    pub username_prefix: std::option::Option<std::string::String>,
    /// <p>The JSON web token (JWT) claim that the provider uses to return your groups.</p>
    pub groups_claim: std::option::Option<std::string::String>,
    /// <p>The prefix that is prepended to group claims to prevent clashes with existing names
    /// (such as <code>system:</code> groups). For example, the value<code> oidc:</code> creates
    /// group names like <code>oidc:engineering</code> and <code>oidc:infra</code>. The prefix
    /// can't contain <code>system:</code>
    /// </p>
    pub groups_prefix: std::option::Option<std::string::String>,
    /// <p>The key-value pairs that describe required claims in the identity token. If set, each
    /// claim is verified to be present in the token with a matching value.</p>
    pub required_claims:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The metadata to apply to the provider configuration to assist with categorization and
    /// organization. Each tag consists of a key and an optional value, both of which you
    /// defined.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The status of the OIDC identity provider.</p>
    pub status: std::option::Option<crate::model::ConfigStatus>,
}
impl std::fmt::Debug for OidcIdentityProviderConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OidcIdentityProviderConfig");
        formatter.field(
            "identity_provider_config_name",
            &self.identity_provider_config_name,
        );
        formatter.field(
            "identity_provider_config_arn",
            &self.identity_provider_config_arn,
        );
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("issuer_url", &self.issuer_url);
        formatter.field("client_id", &self.client_id);
        formatter.field("username_claim", &self.username_claim);
        formatter.field("username_prefix", &self.username_prefix);
        formatter.field("groups_claim", &self.groups_claim);
        formatter.field("groups_prefix", &self.groups_prefix);
        formatter.field("required_claims", &self.required_claims);
        formatter.field("tags", &self.tags);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`OidcIdentityProviderConfig`](crate::model::OidcIdentityProviderConfig)
pub mod oidc_identity_provider_config {
    /// A builder for [`OidcIdentityProviderConfig`](crate::model::OidcIdentityProviderConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_provider_config_name: std::option::Option<std::string::String>,
        pub(crate) identity_provider_config_arn: std::option::Option<std::string::String>,
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) issuer_url: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) username_claim: std::option::Option<std::string::String>,
        pub(crate) username_prefix: std::option::Option<std::string::String>,
        pub(crate) groups_claim: std::option::Option<std::string::String>,
        pub(crate) groups_prefix: std::option::Option<std::string::String>,
        pub(crate) required_claims: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) status: std::option::Option<crate::model::ConfigStatus>,
    }
    impl Builder {
        /// <p>The name of the configuration.</p>
        pub fn identity_provider_config_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.identity_provider_config_name = Some(input.into());
            self
        }
        /// <p>The name of the configuration.</p>
        pub fn set_identity_provider_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_provider_config_name = input;
            self
        }
        /// <p>The ARN of the configuration.</p>
        pub fn identity_provider_config_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.identity_provider_config_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the configuration.</p>
        pub fn set_identity_provider_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_provider_config_arn = input;
            self
        }
        /// <p>The cluster that the configuration is associated to.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The cluster that the configuration is associated to.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The URL of the OIDC identity provider that allows the API server to discover public
        /// signing keys for verifying tokens.</p>
        pub fn issuer_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.issuer_url = Some(input.into());
            self
        }
        /// <p>The URL of the OIDC identity provider that allows the API server to discover public
        /// signing keys for verifying tokens.</p>
        pub fn set_issuer_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.issuer_url = input;
            self
        }
        /// <p>This is also known as <i>audience</i>. The ID of the client application
        /// that makes authentication requests to the OIDC identity provider.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>This is also known as <i>audience</i>. The ID of the client application
        /// that makes authentication requests to the OIDC identity provider.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The JSON Web token (JWT) claim that is used as the username.</p>
        pub fn username_claim(mut self, input: impl Into<std::string::String>) -> Self {
            self.username_claim = Some(input.into());
            self
        }
        /// <p>The JSON Web token (JWT) claim that is used as the username.</p>
        pub fn set_username_claim(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.username_claim = input;
            self
        }
        /// <p>The prefix that is prepended to username claims to prevent clashes with existing
        /// names. The prefix can't contain <code>system:</code>
        /// </p>
        pub fn username_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.username_prefix = Some(input.into());
            self
        }
        /// <p>The prefix that is prepended to username claims to prevent clashes with existing
        /// names. The prefix can't contain <code>system:</code>
        /// </p>
        pub fn set_username_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.username_prefix = input;
            self
        }
        /// <p>The JSON web token (JWT) claim that the provider uses to return your groups.</p>
        pub fn groups_claim(mut self, input: impl Into<std::string::String>) -> Self {
            self.groups_claim = Some(input.into());
            self
        }
        /// <p>The JSON web token (JWT) claim that the provider uses to return your groups.</p>
        pub fn set_groups_claim(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.groups_claim = input;
            self
        }
        /// <p>The prefix that is prepended to group claims to prevent clashes with existing names
        /// (such as <code>system:</code> groups). For example, the value<code> oidc:</code> creates
        /// group names like <code>oidc:engineering</code> and <code>oidc:infra</code>. The prefix
        /// can't contain <code>system:</code>
        /// </p>
        pub fn groups_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.groups_prefix = Some(input.into());
            self
        }
        /// <p>The prefix that is prepended to group claims to prevent clashes with existing names
        /// (such as <code>system:</code> groups). For example, the value<code> oidc:</code> creates
        /// group names like <code>oidc:engineering</code> and <code>oidc:infra</code>. The prefix
        /// can't contain <code>system:</code>
        /// </p>
        pub fn set_groups_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.groups_prefix = input;
            self
        }
        /// Adds a key-value pair to `required_claims`.
        ///
        /// To override the contents of this collection use [`set_required_claims`](Self::set_required_claims).
        ///
        /// <p>The key-value pairs that describe required claims in the identity token. If set, each
        /// claim is verified to be present in the token with a matching value.</p>
        pub fn required_claims(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.required_claims.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.required_claims = Some(hash_map);
            self
        }
        /// <p>The key-value pairs that describe required claims in the identity token. If set, each
        /// claim is verified to be present in the token with a matching value.</p>
        pub fn set_required_claims(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.required_claims = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata to apply to the provider configuration to assist with categorization and
        /// organization. Each tag consists of a key and an optional value, both of which you
        /// defined.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The metadata to apply to the provider configuration to assist with categorization and
        /// organization. Each tag consists of a key and an optional value, both of which you
        /// defined.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The status of the OIDC identity provider.</p>
        pub fn status(mut self, input: crate::model::ConfigStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the OIDC identity provider.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ConfigStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`OidcIdentityProviderConfig`](crate::model::OidcIdentityProviderConfig)
        pub fn build(self) -> crate::model::OidcIdentityProviderConfig {
            crate::model::OidcIdentityProviderConfig {
                identity_provider_config_name: self.identity_provider_config_name,
                identity_provider_config_arn: self.identity_provider_config_arn,
                cluster_name: self.cluster_name,
                issuer_url: self.issuer_url,
                client_id: self.client_id,
                username_claim: self.username_claim,
                username_prefix: self.username_prefix,
                groups_claim: self.groups_claim,
                groups_prefix: self.groups_prefix,
                required_claims: self.required_claims,
                tags: self.tags,
                status: self.status,
            }
        }
    }
}
impl OidcIdentityProviderConfig {
    /// Creates a new builder-style object to manufacture [`OidcIdentityProviderConfig`](crate::model::OidcIdentityProviderConfig)
    pub fn builder() -> crate::model::oidc_identity_provider_config::Builder {
        crate::model::oidc_identity_provider_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfigStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfigStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ConfigStatus::Active,
            "CREATING" => ConfigStatus::Creating,
            "DELETING" => ConfigStatus::Deleting,
            other => ConfigStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfigStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfigStatus::from(s))
    }
}
impl ConfigStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfigStatus::Active => "ACTIVE",
            ConfigStatus::Creating => "CREATING",
            ConfigStatus::Deleting => "DELETING",
            ConfigStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETING"]
    }
}
impl AsRef<str> for ConfigStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing an Fargate profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FargateProfile {
    /// <p>The name of the Fargate profile.</p>
    pub fargate_profile_name: std::option::Option<std::string::String>,
    /// <p>The full Amazon Resource Name (ARN) of the Fargate profile.</p>
    pub fargate_profile_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon EKS cluster that the Fargate profile belongs to.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The Unix epoch timestamp in seconds for when the Fargate profile was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of the pod execution role to use for pods that match the selectors in
    /// the Fargate profile. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html">Pod
    /// Execution Role</a> in the <i>Amazon EKS User Guide</i>.</p>
    pub pod_execution_role_arn: std::option::Option<std::string::String>,
    /// <p>The IDs of subnets to launch pods into.</p>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The selectors to match for pods to use this Fargate profile.</p>
    pub selectors: std::option::Option<std::vec::Vec<crate::model::FargateProfileSelector>>,
    /// <p>The current status of the Fargate profile.</p>
    pub status: std::option::Option<crate::model::FargateProfileStatus>,
    /// <p>The metadata applied to the Fargate profile to assist with categorization and
    /// organization. Each tag consists of a key and an optional value, both of which you
    /// define. Fargate profile tags do not propagate to any other resources associated with the
    /// Fargate profile, such as the pods that are scheduled with it.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for FargateProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FargateProfile");
        formatter.field("fargate_profile_name", &self.fargate_profile_name);
        formatter.field("fargate_profile_arn", &self.fargate_profile_arn);
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("created_at", &self.created_at);
        formatter.field("pod_execution_role_arn", &self.pod_execution_role_arn);
        formatter.field("subnets", &self.subnets);
        formatter.field("selectors", &self.selectors);
        formatter.field("status", &self.status);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`FargateProfile`](crate::model::FargateProfile)
pub mod fargate_profile {
    /// A builder for [`FargateProfile`](crate::model::FargateProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fargate_profile_name: std::option::Option<std::string::String>,
        pub(crate) fargate_profile_arn: std::option::Option<std::string::String>,
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) pod_execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) selectors:
            std::option::Option<std::vec::Vec<crate::model::FargateProfileSelector>>,
        pub(crate) status: std::option::Option<crate::model::FargateProfileStatus>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the Fargate profile.</p>
        pub fn fargate_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.fargate_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the Fargate profile.</p>
        pub fn set_fargate_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.fargate_profile_name = input;
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the Fargate profile.</p>
        pub fn fargate_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fargate_profile_arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the Fargate profile.</p>
        pub fn set_fargate_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.fargate_profile_arn = input;
            self
        }
        /// <p>The name of the Amazon EKS cluster that the Fargate profile belongs to.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon EKS cluster that the Fargate profile belongs to.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the Fargate profile was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix epoch timestamp in seconds for when the Fargate profile was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pod execution role to use for pods that match the selectors in
        /// the Fargate profile. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html">Pod
        /// Execution Role</a> in the <i>Amazon EKS User Guide</i>.</p>
        pub fn pod_execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pod_execution_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pod execution role to use for pods that match the selectors in
        /// the Fargate profile. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html">Pod
        /// Execution Role</a> in the <i>Amazon EKS User Guide</i>.</p>
        pub fn set_pod_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pod_execution_role_arn = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The IDs of subnets to launch pods into.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>The IDs of subnets to launch pods into.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Appends an item to `selectors`.
        ///
        /// To override the contents of this collection use [`set_selectors`](Self::set_selectors).
        ///
        /// <p>The selectors to match for pods to use this Fargate profile.</p>
        pub fn selectors(mut self, input: impl Into<crate::model::FargateProfileSelector>) -> Self {
            let mut v = self.selectors.unwrap_or_default();
            v.push(input.into());
            self.selectors = Some(v);
            self
        }
        /// <p>The selectors to match for pods to use this Fargate profile.</p>
        pub fn set_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FargateProfileSelector>>,
        ) -> Self {
            self.selectors = input;
            self
        }
        /// <p>The current status of the Fargate profile.</p>
        pub fn status(mut self, input: crate::model::FargateProfileStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the Fargate profile.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FargateProfileStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata applied to the Fargate profile to assist with categorization and
        /// organization. Each tag consists of a key and an optional value, both of which you
        /// define. Fargate profile tags do not propagate to any other resources associated with the
        /// Fargate profile, such as the pods that are scheduled with it.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The metadata applied to the Fargate profile to assist with categorization and
        /// organization. Each tag consists of a key and an optional value, both of which you
        /// define. Fargate profile tags do not propagate to any other resources associated with the
        /// Fargate profile, such as the pods that are scheduled with it.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`FargateProfile`](crate::model::FargateProfile)
        pub fn build(self) -> crate::model::FargateProfile {
            crate::model::FargateProfile {
                fargate_profile_name: self.fargate_profile_name,
                fargate_profile_arn: self.fargate_profile_arn,
                cluster_name: self.cluster_name,
                created_at: self.created_at,
                pod_execution_role_arn: self.pod_execution_role_arn,
                subnets: self.subnets,
                selectors: self.selectors,
                status: self.status,
                tags: self.tags,
            }
        }
    }
}
impl FargateProfile {
    /// Creates a new builder-style object to manufacture [`FargateProfile`](crate::model::FargateProfile)
    pub fn builder() -> crate::model::fargate_profile::Builder {
        crate::model::fargate_profile::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FargateProfileStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FargateProfileStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => FargateProfileStatus::Active,
            "CREATE_FAILED" => FargateProfileStatus::CreateFailed,
            "CREATING" => FargateProfileStatus::Creating,
            "DELETE_FAILED" => FargateProfileStatus::DeleteFailed,
            "DELETING" => FargateProfileStatus::Deleting,
            other => FargateProfileStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FargateProfileStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FargateProfileStatus::from(s))
    }
}
impl FargateProfileStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FargateProfileStatus::Active => "ACTIVE",
            FargateProfileStatus::CreateFailed => "CREATE_FAILED",
            FargateProfileStatus::Creating => "CREATING",
            FargateProfileStatus::DeleteFailed => "DELETE_FAILED",
            FargateProfileStatus::Deleting => "DELETING",
            FargateProfileStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATE_FAILED",
            "CREATING",
            "DELETE_FAILED",
            "DELETING",
        ]
    }
}
impl AsRef<str> for FargateProfileStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing an Fargate profile selector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FargateProfileSelector {
    /// <p>The Kubernetes namespace that the selector should match.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The Kubernetes labels that the selector should match. A pod must contain all of the
    /// labels that are specified in the selector for it to be considered a match.</p>
    pub labels:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for FargateProfileSelector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FargateProfileSelector");
        formatter.field("namespace", &self.namespace);
        formatter.field("labels", &self.labels);
        formatter.finish()
    }
}
/// See [`FargateProfileSelector`](crate::model::FargateProfileSelector)
pub mod fargate_profile_selector {
    /// A builder for [`FargateProfileSelector`](crate::model::FargateProfileSelector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) labels: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Kubernetes namespace that the selector should match.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The Kubernetes namespace that the selector should match.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Adds a key-value pair to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>The Kubernetes labels that the selector should match. A pod must contain all of the
        /// labels that are specified in the selector for it to be considered a match.</p>
        pub fn labels(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.labels.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.labels = Some(hash_map);
            self
        }
        /// <p>The Kubernetes labels that the selector should match. A pod must contain all of the
        /// labels that are specified in the selector for it to be considered a match.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.labels = input;
            self
        }
        /// Consumes the builder and constructs a [`FargateProfileSelector`](crate::model::FargateProfileSelector)
        pub fn build(self) -> crate::model::FargateProfileSelector {
            crate::model::FargateProfileSelector {
                namespace: self.namespace,
                labels: self.labels,
            }
        }
    }
}
impl FargateProfileSelector {
    /// Creates a new builder-style object to manufacture [`FargateProfileSelector`](crate::model::FargateProfileSelector)
    pub fn builder() -> crate::model::fargate_profile_selector::Builder {
        crate::model::fargate_profile_selector::Builder::default()
    }
}

/// <p>Information about an add-on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddonInfo {
    /// <p>The name of the add-on.</p>
    pub addon_name: std::option::Option<std::string::String>,
    /// <p>The type of the add-on.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>An object that represents information about available add-on versions and compatible
    /// Kubernetes versions.</p>
    pub addon_versions: std::option::Option<std::vec::Vec<crate::model::AddonVersionInfo>>,
}
impl std::fmt::Debug for AddonInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddonInfo");
        formatter.field("addon_name", &self.addon_name);
        formatter.field("r#type", &self.r#type);
        formatter.field("addon_versions", &self.addon_versions);
        formatter.finish()
    }
}
/// See [`AddonInfo`](crate::model::AddonInfo)
pub mod addon_info {
    /// A builder for [`AddonInfo`](crate::model::AddonInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) addon_name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) addon_versions:
            std::option::Option<std::vec::Vec<crate::model::AddonVersionInfo>>,
    }
    impl Builder {
        /// <p>The name of the add-on.</p>
        pub fn addon_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.addon_name = Some(input.into());
            self
        }
        /// <p>The name of the add-on.</p>
        pub fn set_addon_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.addon_name = input;
            self
        }
        /// <p>The type of the add-on.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the add-on.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `addon_versions`.
        ///
        /// To override the contents of this collection use [`set_addon_versions`](Self::set_addon_versions).
        ///
        /// <p>An object that represents information about available add-on versions and compatible
        /// Kubernetes versions.</p>
        pub fn addon_versions(mut self, input: impl Into<crate::model::AddonVersionInfo>) -> Self {
            let mut v = self.addon_versions.unwrap_or_default();
            v.push(input.into());
            self.addon_versions = Some(v);
            self
        }
        /// <p>An object that represents information about available add-on versions and compatible
        /// Kubernetes versions.</p>
        pub fn set_addon_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddonVersionInfo>>,
        ) -> Self {
            self.addon_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`AddonInfo`](crate::model::AddonInfo)
        pub fn build(self) -> crate::model::AddonInfo {
            crate::model::AddonInfo {
                addon_name: self.addon_name,
                r#type: self.r#type,
                addon_versions: self.addon_versions,
            }
        }
    }
}
impl AddonInfo {
    /// Creates a new builder-style object to manufacture [`AddonInfo`](crate::model::AddonInfo)
    pub fn builder() -> crate::model::addon_info::Builder {
        crate::model::addon_info::Builder::default()
    }
}

/// <p>Information about an add-on version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddonVersionInfo {
    /// <p>The version of the add-on.</p>
    pub addon_version: std::option::Option<std::string::String>,
    /// <p>The architectures that the version supports.</p>
    pub architecture: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An object that represents the compatibilities of a version.</p>
    pub compatibilities: std::option::Option<std::vec::Vec<crate::model::Compatibility>>,
}
impl std::fmt::Debug for AddonVersionInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddonVersionInfo");
        formatter.field("addon_version", &self.addon_version);
        formatter.field("architecture", &self.architecture);
        formatter.field("compatibilities", &self.compatibilities);
        formatter.finish()
    }
}
/// See [`AddonVersionInfo`](crate::model::AddonVersionInfo)
pub mod addon_version_info {
    /// A builder for [`AddonVersionInfo`](crate::model::AddonVersionInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) addon_version: std::option::Option<std::string::String>,
        pub(crate) architecture: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) compatibilities: std::option::Option<std::vec::Vec<crate::model::Compatibility>>,
    }
    impl Builder {
        /// <p>The version of the add-on.</p>
        pub fn addon_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.addon_version = Some(input.into());
            self
        }
        /// <p>The version of the add-on.</p>
        pub fn set_addon_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.addon_version = input;
            self
        }
        /// Appends an item to `architecture`.
        ///
        /// To override the contents of this collection use [`set_architecture`](Self::set_architecture).
        ///
        /// <p>The architectures that the version supports.</p>
        pub fn architecture(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.architecture.unwrap_or_default();
            v.push(input.into());
            self.architecture = Some(v);
            self
        }
        /// <p>The architectures that the version supports.</p>
        pub fn set_architecture(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.architecture = input;
            self
        }
        /// Appends an item to `compatibilities`.
        ///
        /// To override the contents of this collection use [`set_compatibilities`](Self::set_compatibilities).
        ///
        /// <p>An object that represents the compatibilities of a version.</p>
        pub fn compatibilities(mut self, input: impl Into<crate::model::Compatibility>) -> Self {
            let mut v = self.compatibilities.unwrap_or_default();
            v.push(input.into());
            self.compatibilities = Some(v);
            self
        }
        /// <p>An object that represents the compatibilities of a version.</p>
        pub fn set_compatibilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Compatibility>>,
        ) -> Self {
            self.compatibilities = input;
            self
        }
        /// Consumes the builder and constructs a [`AddonVersionInfo`](crate::model::AddonVersionInfo)
        pub fn build(self) -> crate::model::AddonVersionInfo {
            crate::model::AddonVersionInfo {
                addon_version: self.addon_version,
                architecture: self.architecture,
                compatibilities: self.compatibilities,
            }
        }
    }
}
impl AddonVersionInfo {
    /// Creates a new builder-style object to manufacture [`AddonVersionInfo`](crate::model::AddonVersionInfo)
    pub fn builder() -> crate::model::addon_version_info::Builder {
        crate::model::addon_version_info::Builder::default()
    }
}

/// <p>Compatibility information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Compatibility {
    /// <p>The supported Kubernetes version of the cluster.</p>
    pub cluster_version: std::option::Option<std::string::String>,
    /// <p>The supported compute platform.</p>
    pub platform_versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The supported default version.</p>
    pub default_version: bool,
}
impl std::fmt::Debug for Compatibility {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Compatibility");
        formatter.field("cluster_version", &self.cluster_version);
        formatter.field("platform_versions", &self.platform_versions);
        formatter.field("default_version", &self.default_version);
        formatter.finish()
    }
}
/// See [`Compatibility`](crate::model::Compatibility)
pub mod compatibility {
    /// A builder for [`Compatibility`](crate::model::Compatibility)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_version: std::option::Option<std::string::String>,
        pub(crate) platform_versions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) default_version: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The supported Kubernetes version of the cluster.</p>
        pub fn cluster_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_version = Some(input.into());
            self
        }
        /// <p>The supported Kubernetes version of the cluster.</p>
        pub fn set_cluster_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_version = input;
            self
        }
        /// Appends an item to `platform_versions`.
        ///
        /// To override the contents of this collection use [`set_platform_versions`](Self::set_platform_versions).
        ///
        /// <p>The supported compute platform.</p>
        pub fn platform_versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.platform_versions.unwrap_or_default();
            v.push(input.into());
            self.platform_versions = Some(v);
            self
        }
        /// <p>The supported compute platform.</p>
        pub fn set_platform_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.platform_versions = input;
            self
        }
        /// <p>The supported default version.</p>
        pub fn default_version(mut self, input: bool) -> Self {
            self.default_version = Some(input);
            self
        }
        /// <p>The supported default version.</p>
        pub fn set_default_version(mut self, input: std::option::Option<bool>) -> Self {
            self.default_version = input;
            self
        }
        /// Consumes the builder and constructs a [`Compatibility`](crate::model::Compatibility)
        pub fn build(self) -> crate::model::Compatibility {
            crate::model::Compatibility {
                cluster_version: self.cluster_version,
                platform_versions: self.platform_versions,
                default_version: self.default_version.unwrap_or_default(),
            }
        }
    }
}
impl Compatibility {
    /// Creates a new builder-style object to manufacture [`Compatibility`](crate::model::Compatibility)
    pub fn builder() -> crate::model::compatibility::Builder {
        crate::model::compatibility::Builder::default()
    }
}

/// <p>An Amazon EKS add-on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Addon {
    /// <p>The name of the add-on.</p>
    pub addon_name: std::option::Option<std::string::String>,
    /// <p>The name of the cluster.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The status of the add-on.</p>
    pub status: std::option::Option<crate::model::AddonStatus>,
    /// <p>The version of the add-on.</p>
    pub addon_version: std::option::Option<std::string::String>,
    /// <p>An object that represents the health of the add-on.</p>
    pub health: std::option::Option<crate::model::AddonHealth>,
    /// <p>The Amazon Resource Name (ARN) of the add-on.</p>
    pub addon_arn: std::option::Option<std::string::String>,
    /// <p>The date and time that the add-on was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the add-on was last modified.</p>
    pub modified_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role that is bound to the Kubernetes service account used
    /// by the add-on.</p>
    pub service_account_role_arn: std::option::Option<std::string::String>,
    /// <p>The metadata that you apply to the add-on to assist with categorization and
    /// organization. Each tag consists of a key and an optional value, both of which you
    /// define. Add-on tags do not propagate to any other resources associated with the cluster.
    /// </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for Addon {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Addon");
        formatter.field("addon_name", &self.addon_name);
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("status", &self.status);
        formatter.field("addon_version", &self.addon_version);
        formatter.field("health", &self.health);
        formatter.field("addon_arn", &self.addon_arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("modified_at", &self.modified_at);
        formatter.field("service_account_role_arn", &self.service_account_role_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Addon`](crate::model::Addon)
pub mod addon {
    /// A builder for [`Addon`](crate::model::Addon)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) addon_name: std::option::Option<std::string::String>,
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AddonStatus>,
        pub(crate) addon_version: std::option::Option<std::string::String>,
        pub(crate) health: std::option::Option<crate::model::AddonHealth>,
        pub(crate) addon_arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) modified_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) service_account_role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the add-on.</p>
        pub fn addon_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.addon_name = Some(input.into());
            self
        }
        /// <p>The name of the add-on.</p>
        pub fn set_addon_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.addon_name = input;
            self
        }
        /// <p>The name of the cluster.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The status of the add-on.</p>
        pub fn status(mut self, input: crate::model::AddonStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the add-on.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::AddonStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The version of the add-on.</p>
        pub fn addon_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.addon_version = Some(input.into());
            self
        }
        /// <p>The version of the add-on.</p>
        pub fn set_addon_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.addon_version = input;
            self
        }
        /// <p>An object that represents the health of the add-on.</p>
        pub fn health(mut self, input: crate::model::AddonHealth) -> Self {
            self.health = Some(input);
            self
        }
        /// <p>An object that represents the health of the add-on.</p>
        pub fn set_health(mut self, input: std::option::Option<crate::model::AddonHealth>) -> Self {
            self.health = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the add-on.</p>
        pub fn addon_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.addon_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the add-on.</p>
        pub fn set_addon_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.addon_arn = input;
            self
        }
        /// <p>The date and time that the add-on was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time that the add-on was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The date and time that the add-on was last modified.</p>
        pub fn modified_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.modified_at = Some(input);
            self
        }
        /// <p>The date and time that the add-on was last modified.</p>
        pub fn set_modified_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.modified_at = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that is bound to the Kubernetes service account used
        /// by the add-on.</p>
        pub fn service_account_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_account_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that is bound to the Kubernetes service account used
        /// by the add-on.</p>
        pub fn set_service_account_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_account_role_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the add-on to assist with categorization and
        /// organization. Each tag consists of a key and an optional value, both of which you
        /// define. Add-on tags do not propagate to any other resources associated with the cluster.
        /// </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The metadata that you apply to the add-on to assist with categorization and
        /// organization. Each tag consists of a key and an optional value, both of which you
        /// define. Add-on tags do not propagate to any other resources associated with the cluster.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Addon`](crate::model::Addon)
        pub fn build(self) -> crate::model::Addon {
            crate::model::Addon {
                addon_name: self.addon_name,
                cluster_name: self.cluster_name,
                status: self.status,
                addon_version: self.addon_version,
                health: self.health,
                addon_arn: self.addon_arn,
                created_at: self.created_at,
                modified_at: self.modified_at,
                service_account_role_arn: self.service_account_role_arn,
                tags: self.tags,
            }
        }
    }
}
impl Addon {
    /// Creates a new builder-style object to manufacture [`Addon`](crate::model::Addon)
    pub fn builder() -> crate::model::addon::Builder {
        crate::model::addon::Builder::default()
    }
}

/// <p>The health of the add-on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddonHealth {
    /// <p>An object that represents the add-on's health issues.</p>
    pub issues: std::option::Option<std::vec::Vec<crate::model::AddonIssue>>,
}
impl std::fmt::Debug for AddonHealth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddonHealth");
        formatter.field("issues", &self.issues);
        formatter.finish()
    }
}
/// See [`AddonHealth`](crate::model::AddonHealth)
pub mod addon_health {
    /// A builder for [`AddonHealth`](crate::model::AddonHealth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) issues: std::option::Option<std::vec::Vec<crate::model::AddonIssue>>,
    }
    impl Builder {
        /// Appends an item to `issues`.
        ///
        /// To override the contents of this collection use [`set_issues`](Self::set_issues).
        ///
        /// <p>An object that represents the add-on's health issues.</p>
        pub fn issues(mut self, input: impl Into<crate::model::AddonIssue>) -> Self {
            let mut v = self.issues.unwrap_or_default();
            v.push(input.into());
            self.issues = Some(v);
            self
        }
        /// <p>An object that represents the add-on's health issues.</p>
        pub fn set_issues(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddonIssue>>,
        ) -> Self {
            self.issues = input;
            self
        }
        /// Consumes the builder and constructs a [`AddonHealth`](crate::model::AddonHealth)
        pub fn build(self) -> crate::model::AddonHealth {
            crate::model::AddonHealth {
                issues: self.issues,
            }
        }
    }
}
impl AddonHealth {
    /// Creates a new builder-style object to manufacture [`AddonHealth`](crate::model::AddonHealth)
    pub fn builder() -> crate::model::addon_health::Builder {
        crate::model::addon_health::Builder::default()
    }
}

/// <p>An issue related to an add-on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddonIssue {
    /// <p>A code that describes the type of issue.</p>
    pub code: std::option::Option<crate::model::AddonIssueCode>,
    /// <p>A message that provides details about the issue and what might cause it.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The resource IDs of the issue.</p>
    pub resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for AddonIssue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddonIssue");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("resource_ids", &self.resource_ids);
        formatter.finish()
    }
}
/// See [`AddonIssue`](crate::model::AddonIssue)
pub mod addon_issue {
    /// A builder for [`AddonIssue`](crate::model::AddonIssue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::AddonIssueCode>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A code that describes the type of issue.</p>
        pub fn code(mut self, input: crate::model::AddonIssueCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>A code that describes the type of issue.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::AddonIssueCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>A message that provides details about the issue and what might cause it.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides details about the issue and what might cause it.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `resource_ids`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>The resource IDs of the issue.</p>
        pub fn resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_ids.unwrap_or_default();
            v.push(input.into());
            self.resource_ids = Some(v);
            self
        }
        /// <p>The resource IDs of the issue.</p>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`AddonIssue`](crate::model::AddonIssue)
        pub fn build(self) -> crate::model::AddonIssue {
            crate::model::AddonIssue {
                code: self.code,
                message: self.message,
                resource_ids: self.resource_ids,
            }
        }
    }
}
impl AddonIssue {
    /// Creates a new builder-style object to manufacture [`AddonIssue`](crate::model::AddonIssue)
    pub fn builder() -> crate::model::addon_issue::Builder {
        crate::model::addon_issue::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AddonIssueCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    AdmissionRequestDenied,
    #[allow(missing_docs)] // documentation missing in model
    ClusterUnreachable,
    #[allow(missing_docs)] // documentation missing in model
    ConfigurationConflict,
    #[allow(missing_docs)] // documentation missing in model
    InsufficientNumberOfReplicas,
    #[allow(missing_docs)] // documentation missing in model
    InternalFailure,
    #[allow(missing_docs)] // documentation missing in model
    K8SResourceNotFound,
    #[allow(missing_docs)] // documentation missing in model
    UnsupportedAddonModification,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AddonIssueCode {
    fn from(s: &str) -> Self {
        match s {
            "AccessDenied" => AddonIssueCode::AccessDenied,
            "AdmissionRequestDenied" => AddonIssueCode::AdmissionRequestDenied,
            "ClusterUnreachable" => AddonIssueCode::ClusterUnreachable,
            "ConfigurationConflict" => AddonIssueCode::ConfigurationConflict,
            "InsufficientNumberOfReplicas" => AddonIssueCode::InsufficientNumberOfReplicas,
            "InternalFailure" => AddonIssueCode::InternalFailure,
            "K8sResourceNotFound" => AddonIssueCode::K8SResourceNotFound,
            "UnsupportedAddonModification" => AddonIssueCode::UnsupportedAddonModification,
            other => AddonIssueCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AddonIssueCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AddonIssueCode::from(s))
    }
}
impl AddonIssueCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AddonIssueCode::AccessDenied => "AccessDenied",
            AddonIssueCode::AdmissionRequestDenied => "AdmissionRequestDenied",
            AddonIssueCode::ClusterUnreachable => "ClusterUnreachable",
            AddonIssueCode::ConfigurationConflict => "ConfigurationConflict",
            AddonIssueCode::InsufficientNumberOfReplicas => "InsufficientNumberOfReplicas",
            AddonIssueCode::InternalFailure => "InternalFailure",
            AddonIssueCode::K8SResourceNotFound => "K8sResourceNotFound",
            AddonIssueCode::UnsupportedAddonModification => "UnsupportedAddonModification",
            AddonIssueCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccessDenied",
            "AdmissionRequestDenied",
            "ClusterUnreachable",
            "ConfigurationConflict",
            "InsufficientNumberOfReplicas",
            "InternalFailure",
            "K8sResourceNotFound",
            "UnsupportedAddonModification",
        ]
    }
}
impl AsRef<str> for AddonIssueCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AddonStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Degraded,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AddonStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => AddonStatus::Active,
            "CREATE_FAILED" => AddonStatus::CreateFailed,
            "CREATING" => AddonStatus::Creating,
            "DEGRADED" => AddonStatus::Degraded,
            "DELETE_FAILED" => AddonStatus::DeleteFailed,
            "DELETING" => AddonStatus::Deleting,
            "UPDATING" => AddonStatus::Updating,
            other => AddonStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AddonStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AddonStatus::from(s))
    }
}
impl AddonStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AddonStatus::Active => "ACTIVE",
            AddonStatus::CreateFailed => "CREATE_FAILED",
            AddonStatus::Creating => "CREATING",
            AddonStatus::Degraded => "DEGRADED",
            AddonStatus::DeleteFailed => "DELETE_FAILED",
            AddonStatus::Deleting => "DELETING",
            AddonStatus::Updating => "UPDATING",
            AddonStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATE_FAILED",
            "CREATING",
            "DEGRADED",
            "DELETE_FAILED",
            "DELETING",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for AddonStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The Kubernetes network configuration for the cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KubernetesNetworkConfigRequest {
    /// <p>The CIDR block to assign Kubernetes service IP addresses from. If you don't specify a
    /// block, Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR
    /// blocks. We recommend that you specify a block that does not overlap with resources in
    /// other networks that are peered or connected to your VPC. The block must meet the
    /// following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Within one of the following private IP address blocks: 10.0.0.0/8,
    /// 172.16.0.0.0/12, or 192.168.0.0/16.</p>
    /// </li>
    /// <li>
    /// <p>Doesn't overlap with any CIDR block assigned to the VPC that you selected for
    /// VPC.</p>
    /// </li>
    /// <li>
    /// <p>Between /24 and /12.</p>
    /// </li>
    /// </ul>
    /// <important>
    /// <p>You can only specify a custom CIDR block when you create a cluster and can't
    /// change this value once the cluster is created.</p>
    /// </important>
    pub service_ipv4_cidr: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KubernetesNetworkConfigRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KubernetesNetworkConfigRequest");
        formatter.field("service_ipv4_cidr", &self.service_ipv4_cidr);
        formatter.finish()
    }
}
/// See [`KubernetesNetworkConfigRequest`](crate::model::KubernetesNetworkConfigRequest)
pub mod kubernetes_network_config_request {
    /// A builder for [`KubernetesNetworkConfigRequest`](crate::model::KubernetesNetworkConfigRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_ipv4_cidr: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The CIDR block to assign Kubernetes service IP addresses from. If you don't specify a
        /// block, Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR
        /// blocks. We recommend that you specify a block that does not overlap with resources in
        /// other networks that are peered or connected to your VPC. The block must meet the
        /// following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Within one of the following private IP address blocks: 10.0.0.0/8,
        /// 172.16.0.0.0/12, or 192.168.0.0/16.</p>
        /// </li>
        /// <li>
        /// <p>Doesn't overlap with any CIDR block assigned to the VPC that you selected for
        /// VPC.</p>
        /// </li>
        /// <li>
        /// <p>Between /24 and /12.</p>
        /// </li>
        /// </ul>
        /// <important>
        /// <p>You can only specify a custom CIDR block when you create a cluster and can't
        /// change this value once the cluster is created.</p>
        /// </important>
        pub fn service_ipv4_cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_ipv4_cidr = Some(input.into());
            self
        }
        /// <p>The CIDR block to assign Kubernetes service IP addresses from. If you don't specify a
        /// block, Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR
        /// blocks. We recommend that you specify a block that does not overlap with resources in
        /// other networks that are peered or connected to your VPC. The block must meet the
        /// following requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Within one of the following private IP address blocks: 10.0.0.0/8,
        /// 172.16.0.0.0/12, or 192.168.0.0/16.</p>
        /// </li>
        /// <li>
        /// <p>Doesn't overlap with any CIDR block assigned to the VPC that you selected for
        /// VPC.</p>
        /// </li>
        /// <li>
        /// <p>Between /24 and /12.</p>
        /// </li>
        /// </ul>
        /// <important>
        /// <p>You can only specify a custom CIDR block when you create a cluster and can't
        /// change this value once the cluster is created.</p>
        /// </important>
        pub fn set_service_ipv4_cidr(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_ipv4_cidr = input;
            self
        }
        /// Consumes the builder and constructs a [`KubernetesNetworkConfigRequest`](crate::model::KubernetesNetworkConfigRequest)
        pub fn build(self) -> crate::model::KubernetesNetworkConfigRequest {
            crate::model::KubernetesNetworkConfigRequest {
                service_ipv4_cidr: self.service_ipv4_cidr,
            }
        }
    }
}
impl KubernetesNetworkConfigRequest {
    /// Creates a new builder-style object to manufacture [`KubernetesNetworkConfigRequest`](crate::model::KubernetesNetworkConfigRequest)
    pub fn builder() -> crate::model::kubernetes_network_config_request::Builder {
        crate::model::kubernetes_network_config_request::Builder::default()
    }
}

/// <p>An object representing an OpenID Connect (OIDC) configuration. Before associating an
/// OIDC identity provider to your cluster, review the considerations in <a href="https://docs.aws.amazon.com/eks/latest/userguide/authenticate-oidc-identity-provider.html">Authenticating
/// users for your cluster from an OpenID Connect identity provider</a> in the
/// <i>Amazon EKS User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OidcIdentityProviderConfigRequest {
    /// <p>The name of the OIDC provider configuration.</p>
    pub identity_provider_config_name: std::option::Option<std::string::String>,
    /// <p>The URL of the OpenID identity provider that allows the API server to discover public
    /// signing keys for verifying tokens. The URL must begin with <code>https://</code> and
    /// should correspond to the <code>iss</code> claim in the provider's OIDC ID tokens. Per
    /// the OIDC standard, path components are allowed but query parameters are not. Typically
    /// the URL consists of only a hostname, like <code>https://server.example.org</code> or
    /// <code>https://example.com</code>. This URL should point to the level below
    /// <code>.well-known/openid-configuration</code> and must be publicly accessible over
    /// the internet.</p>
    pub issuer_url: std::option::Option<std::string::String>,
    /// <p>This is also known as <i>audience</i>. The ID for the client application
    /// that makes authentication requests to the OpenID identity provider.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The JSON Web Token (JWT) claim to use as the username. The default is
    /// <code>sub</code>, which is expected to be a unique identifier of the end user. You can
    /// choose other claims, such as <code>email</code> or <code>name</code>, depending on the
    /// OpenID identity provider. Claims other than <code>email</code> are prefixed with the
    /// issuer URL to prevent naming clashes with other plug-ins.</p>
    pub username_claim: std::option::Option<std::string::String>,
    /// <p>The prefix that is prepended to username claims to prevent clashes with existing
    /// names. If you do not provide this field, and <code>username</code> is a value other than
    /// <code>email</code>, the prefix defaults to <code>issuerurl#</code>. You can use the
    /// value <code>-</code> to disable all prefixing.</p>
    pub username_prefix: std::option::Option<std::string::String>,
    /// <p>The JWT claim that the provider uses to return your groups.</p>
    pub groups_claim: std::option::Option<std::string::String>,
    /// <p>The prefix that is prepended to group claims to prevent clashes with existing names
    /// (such as <code>system:</code> groups). For example, the value<code> oidc:</code> will
    /// create group names like <code>oidc:engineering</code> and
    /// <code>oidc:infra</code>.</p>
    pub groups_prefix: std::option::Option<std::string::String>,
    /// <p>The key value pairs that describe required claims in the identity token. If set, each
    /// claim is verified to be present in the token with a matching value. For the maximum
    /// number of claims that you can require, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html">Amazon EKS service quotas</a> in the
    /// <i>Amazon EKS User Guide</i>.</p>
    pub required_claims:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for OidcIdentityProviderConfigRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OidcIdentityProviderConfigRequest");
        formatter.field(
            "identity_provider_config_name",
            &self.identity_provider_config_name,
        );
        formatter.field("issuer_url", &self.issuer_url);
        formatter.field("client_id", &self.client_id);
        formatter.field("username_claim", &self.username_claim);
        formatter.field("username_prefix", &self.username_prefix);
        formatter.field("groups_claim", &self.groups_claim);
        formatter.field("groups_prefix", &self.groups_prefix);
        formatter.field("required_claims", &self.required_claims);
        formatter.finish()
    }
}
/// See [`OidcIdentityProviderConfigRequest`](crate::model::OidcIdentityProviderConfigRequest)
pub mod oidc_identity_provider_config_request {
    /// A builder for [`OidcIdentityProviderConfigRequest`](crate::model::OidcIdentityProviderConfigRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identity_provider_config_name: std::option::Option<std::string::String>,
        pub(crate) issuer_url: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) username_claim: std::option::Option<std::string::String>,
        pub(crate) username_prefix: std::option::Option<std::string::String>,
        pub(crate) groups_claim: std::option::Option<std::string::String>,
        pub(crate) groups_prefix: std::option::Option<std::string::String>,
        pub(crate) required_claims: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the OIDC provider configuration.</p>
        pub fn identity_provider_config_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.identity_provider_config_name = Some(input.into());
            self
        }
        /// <p>The name of the OIDC provider configuration.</p>
        pub fn set_identity_provider_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_provider_config_name = input;
            self
        }
        /// <p>The URL of the OpenID identity provider that allows the API server to discover public
        /// signing keys for verifying tokens. The URL must begin with <code>https://</code> and
        /// should correspond to the <code>iss</code> claim in the provider's OIDC ID tokens. Per
        /// the OIDC standard, path components are allowed but query parameters are not. Typically
        /// the URL consists of only a hostname, like <code>https://server.example.org</code> or
        /// <code>https://example.com</code>. This URL should point to the level below
        /// <code>.well-known/openid-configuration</code> and must be publicly accessible over
        /// the internet.</p>
        pub fn issuer_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.issuer_url = Some(input.into());
            self
        }
        /// <p>The URL of the OpenID identity provider that allows the API server to discover public
        /// signing keys for verifying tokens. The URL must begin with <code>https://</code> and
        /// should correspond to the <code>iss</code> claim in the provider's OIDC ID tokens. Per
        /// the OIDC standard, path components are allowed but query parameters are not. Typically
        /// the URL consists of only a hostname, like <code>https://server.example.org</code> or
        /// <code>https://example.com</code>. This URL should point to the level below
        /// <code>.well-known/openid-configuration</code> and must be publicly accessible over
        /// the internet.</p>
        pub fn set_issuer_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.issuer_url = input;
            self
        }
        /// <p>This is also known as <i>audience</i>. The ID for the client application
        /// that makes authentication requests to the OpenID identity provider.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>This is also known as <i>audience</i>. The ID for the client application
        /// that makes authentication requests to the OpenID identity provider.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The JSON Web Token (JWT) claim to use as the username. The default is
        /// <code>sub</code>, which is expected to be a unique identifier of the end user. You can
        /// choose other claims, such as <code>email</code> or <code>name</code>, depending on the
        /// OpenID identity provider. Claims other than <code>email</code> are prefixed with the
        /// issuer URL to prevent naming clashes with other plug-ins.</p>
        pub fn username_claim(mut self, input: impl Into<std::string::String>) -> Self {
            self.username_claim = Some(input.into());
            self
        }
        /// <p>The JSON Web Token (JWT) claim to use as the username. The default is
        /// <code>sub</code>, which is expected to be a unique identifier of the end user. You can
        /// choose other claims, such as <code>email</code> or <code>name</code>, depending on the
        /// OpenID identity provider. Claims other than <code>email</code> are prefixed with the
        /// issuer URL to prevent naming clashes with other plug-ins.</p>
        pub fn set_username_claim(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.username_claim = input;
            self
        }
        /// <p>The prefix that is prepended to username claims to prevent clashes with existing
        /// names. If you do not provide this field, and <code>username</code> is a value other than
        /// <code>email</code>, the prefix defaults to <code>issuerurl#</code>. You can use the
        /// value <code>-</code> to disable all prefixing.</p>
        pub fn username_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.username_prefix = Some(input.into());
            self
        }
        /// <p>The prefix that is prepended to username claims to prevent clashes with existing
        /// names. If you do not provide this field, and <code>username</code> is a value other than
        /// <code>email</code>, the prefix defaults to <code>issuerurl#</code>. You can use the
        /// value <code>-</code> to disable all prefixing.</p>
        pub fn set_username_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.username_prefix = input;
            self
        }
        /// <p>The JWT claim that the provider uses to return your groups.</p>
        pub fn groups_claim(mut self, input: impl Into<std::string::String>) -> Self {
            self.groups_claim = Some(input.into());
            self
        }
        /// <p>The JWT claim that the provider uses to return your groups.</p>
        pub fn set_groups_claim(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.groups_claim = input;
            self
        }
        /// <p>The prefix that is prepended to group claims to prevent clashes with existing names
        /// (such as <code>system:</code> groups). For example, the value<code> oidc:</code> will
        /// create group names like <code>oidc:engineering</code> and
        /// <code>oidc:infra</code>.</p>
        pub fn groups_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.groups_prefix = Some(input.into());
            self
        }
        /// <p>The prefix that is prepended to group claims to prevent clashes with existing names
        /// (such as <code>system:</code> groups). For example, the value<code> oidc:</code> will
        /// create group names like <code>oidc:engineering</code> and
        /// <code>oidc:infra</code>.</p>
        pub fn set_groups_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.groups_prefix = input;
            self
        }
        /// Adds a key-value pair to `required_claims`.
        ///
        /// To override the contents of this collection use [`set_required_claims`](Self::set_required_claims).
        ///
        /// <p>The key value pairs that describe required claims in the identity token. If set, each
        /// claim is verified to be present in the token with a matching value. For the maximum
        /// number of claims that you can require, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html">Amazon EKS service quotas</a> in the
        /// <i>Amazon EKS User Guide</i>.</p>
        pub fn required_claims(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.required_claims.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.required_claims = Some(hash_map);
            self
        }
        /// <p>The key value pairs that describe required claims in the identity token. If set, each
        /// claim is verified to be present in the token with a matching value. For the maximum
        /// number of claims that you can require, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html">Amazon EKS service quotas</a> in the
        /// <i>Amazon EKS User Guide</i>.</p>
        pub fn set_required_claims(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.required_claims = input;
            self
        }
        /// Consumes the builder and constructs a [`OidcIdentityProviderConfigRequest`](crate::model::OidcIdentityProviderConfigRequest)
        pub fn build(self) -> crate::model::OidcIdentityProviderConfigRequest {
            crate::model::OidcIdentityProviderConfigRequest {
                identity_provider_config_name: self.identity_provider_config_name,
                issuer_url: self.issuer_url,
                client_id: self.client_id,
                username_claim: self.username_claim,
                username_prefix: self.username_prefix,
                groups_claim: self.groups_claim,
                groups_prefix: self.groups_prefix,
                required_claims: self.required_claims,
            }
        }
    }
}
impl OidcIdentityProviderConfigRequest {
    /// Creates a new builder-style object to manufacture [`OidcIdentityProviderConfigRequest`](crate::model::OidcIdentityProviderConfigRequest)
    pub fn builder() -> crate::model::oidc_identity_provider_config_request::Builder {
        crate::model::oidc_identity_provider_config_request::Builder::default()
    }
}
