// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Elastic File System
///
/// Client for invoking operations on Amazon Elastic File System. Each operation on Amazon Elastic File System is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_efs::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_efs::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_efs::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateAccessPoint`](crate::client::fluent_builders::CreateAccessPoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateAccessPoint::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateAccessPoint::set_client_token): <p>A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent creation.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateAccessPoint::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateAccessPoint::set_tags): <p>Creates tags associated with the access point. Each tag is a key-value pair, each key must be unique. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::CreateAccessPoint::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::CreateAccessPoint::set_file_system_id): <p>The ID of the EFS file system that the access point provides access to.</p>
    ///   - [`posix_user(PosixUser)`](crate::client::fluent_builders::CreateAccessPoint::posix_user) / [`set_posix_user(Option<PosixUser>)`](crate::client::fluent_builders::CreateAccessPoint::set_posix_user): <p>The operating system user and group applied to all file system requests made using the access point.</p>
    ///   - [`root_directory(RootDirectory)`](crate::client::fluent_builders::CreateAccessPoint::root_directory) / [`set_root_directory(Option<RootDirectory>)`](crate::client::fluent_builders::CreateAccessPoint::set_root_directory): <p>Specifies the directory on the Amazon EFS file system that the access point exposes as the root directory of your file system to NFS clients using the access point. The clients using the access point can only access the root directory and below. If the <code>RootDirectory</code> &gt; <code>Path</code> specified does not exist, EFS creates it and applies the <code>CreationInfo</code> settings when a client connects to an access point. When specifying a <code>RootDirectory</code>, you need to provide the <code>Path</code>, and the <code>CreationInfo</code>.</p>  <p>Amazon EFS creates a root directory only if you have provided the CreationInfo: OwnUid, OwnGID, and permissions for the directory. If you do not provide this information, Amazon EFS does not create the root directory. If the root directory does not exist, attempts to mount using the access point will fail.</p>
    /// - On success, responds with [`CreateAccessPointOutput`](crate::output::CreateAccessPointOutput) with field(s):
    ///   - [`client_token(Option<String>)`](crate::output::CreateAccessPointOutput::client_token): <p>The opaque string specified in the request to ensure idempotent creation.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateAccessPointOutput::name): <p>The name of the access point. This is the value of the <code>Name</code> tag.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreateAccessPointOutput::tags): <p>The tags associated with the access point, presented as an array of Tag objects.</p>
    ///   - [`access_point_id(Option<String>)`](crate::output::CreateAccessPointOutput::access_point_id): <p>The ID of the access point, assigned by Amazon EFS.</p>
    ///   - [`access_point_arn(Option<String>)`](crate::output::CreateAccessPointOutput::access_point_arn): <p>The unique Amazon Resource Name (ARN) associated with the access point.</p>
    ///   - [`file_system_id(Option<String>)`](crate::output::CreateAccessPointOutput::file_system_id): <p>The ID of the EFS file system that the access point applies to.</p>
    ///   - [`posix_user(Option<PosixUser>)`](crate::output::CreateAccessPointOutput::posix_user): <p>The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point that is used for all file operations by NFS clients using the access point.</p>
    ///   - [`root_directory(Option<RootDirectory>)`](crate::output::CreateAccessPointOutput::root_directory): <p>The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS clients using the access point.</p>
    ///   - [`owner_id(Option<String>)`](crate::output::CreateAccessPointOutput::owner_id): <p>Identified the Amazon Web Services account that owns the access point resource.</p>
    ///   - [`life_cycle_state(Option<LifeCycleState>)`](crate::output::CreateAccessPointOutput::life_cycle_state): <p>Identifies the lifecycle phase of the access point.</p>
    /// - On failure, responds with [`SdkError<CreateAccessPointError>`](crate::error::CreateAccessPointError)
    pub fn create_access_point(&self) -> fluent_builders::CreateAccessPoint {
        fluent_builders::CreateAccessPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFileSystem`](crate::client::fluent_builders::CreateFileSystem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`creation_token(impl Into<String>)`](crate::client::fluent_builders::CreateFileSystem::creation_token) / [`set_creation_token(Option<String>)`](crate::client::fluent_builders::CreateFileSystem::set_creation_token): <p>A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.</p>
    ///   - [`performance_mode(PerformanceMode)`](crate::client::fluent_builders::CreateFileSystem::performance_mode) / [`set_performance_mode(Option<PerformanceMode>)`](crate::client::fluent_builders::CreateFileSystem::set_performance_mode): <p>The performance mode of the file system. We recommend <code>generalPurpose</code> performance mode for most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed after the file system has been created.</p> <note>   <p>The <code>maxIO</code> mode is not supported on file systems using One Zone storage classes.</p>  </note>
    ///   - [`encrypted(bool)`](crate::client::fluent_builders::CreateFileSystem::encrypted) / [`set_encrypted(Option<bool>)`](crate::client::fluent_builders::CreateFileSystem::set_encrypted): <p>A Boolean value that, if true, creates an encrypted file system. When creating an encrypted file system, you have the option of specifying an existing Key Management Service key (KMS key). If you don't specify a KMS key, then the default KMS key for Amazon EFS, <code>/aws/elasticfilesystem</code>, is used to protect the encrypted file system. </p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateFileSystem::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateFileSystem::set_kms_key_id): <p>The ID of the KMS key that you want to use to protect the encrypted file system. This parameter is only required if you want to use a non-default KMS key. If this parameter is not specified, the default KMS key for Amazon EFS is used. You can specify a KMS key ID using the following formats:</p>  <ul>   <li> <p>Key ID - A unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p> </li>   <li> <p>ARN - An Amazon Resource Name (ARN) for the key, for example <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p> </li>   <li> <p>Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code>.</p> </li>   <li> <p>Key alias ARN - An ARN for a key alias, for example <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.</p> </li>  </ul>  <p>If you use <code>KmsKeyId</code>, you must set the <code>CreateFileSystemRequest$Encrypted</code> parameter to true.</p> <important>   <p>EFS accepts only symmetric KMS keys. You cannot use asymmetric KMS keys with Amazon EFS file systems.</p>  </important>
    ///   - [`throughput_mode(ThroughputMode)`](crate::client::fluent_builders::CreateFileSystem::throughput_mode) / [`set_throughput_mode(Option<ThroughputMode>)`](crate::client::fluent_builders::CreateFileSystem::set_throughput_mode): <p>Specifies the throughput mode for the file system, either <code>bursting</code> or <code>provisioned</code>. If you set <code>ThroughputMode</code> to <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughputInMibps</code>. After you create the file system, you can decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes, as long as it’s been more than 24 hours since the last decrease or throughput mode change. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying throughput with provisioned mode</a> in the <i>Amazon EFS User Guide</i>. </p>  <p>Default is <code>bursting</code>.</p>
    ///   - [`provisioned_throughput_in_mibps(f64)`](crate::client::fluent_builders::CreateFileSystem::provisioned_throughput_in_mibps) / [`set_provisioned_throughput_in_mibps(Option<f64>)`](crate::client::fluent_builders::CreateFileSystem::set_provisioned_throughput_in_mibps): <p>The throughput, measured in MiB/s, that you want to provision for a file system that you're creating. Valid values are 1-1024. Required if <code>ThroughputMode</code> is set to <code>provisioned</code>. The upper limit for throughput is 1024 MiB/s. To increase this limit, contact Amazon Web Services Support. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS quotas that you can increase</a> in the <i>Amazon EFS User Guide</i>.</p>
    ///   - [`availability_zone_name(impl Into<String>)`](crate::client::fluent_builders::CreateFileSystem::availability_zone_name) / [`set_availability_zone_name(Option<String>)`](crate::client::fluent_builders::CreateFileSystem::set_availability_zone_name): <p>Used to create a file system that uses One Zone storage classes. It specifies the Amazon Web Services Availability Zone in which to create the file system. Use the format <code>us-east-1a</code> to specify the Availability Zone. For more information about One Zone storage classes, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p> <note>   <p>One Zone storage classes are not available in all Availability Zones in Amazon Web Services Regions where Amazon EFS is available.</p>  </note>
    ///   - [`backup(bool)`](crate::client::fluent_builders::CreateFileSystem::backup) / [`set_backup(Option<bool>)`](crate::client::fluent_builders::CreateFileSystem::set_backup): <p>Specifies whether automatic backups are enabled on the file system that you are creating. Set the value to <code>true</code> to enable automatic backups. If you are creating a file system that uses One Zone storage classes, automatic backups are enabled by default. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups">Automatic backups</a> in the <i>Amazon EFS User Guide</i>.</p>  <p>Default is <code>false</code>. However, if you specify an <code>AvailabilityZoneName</code>, the default is <code>true</code>.</p> <note>   <p>Backup is not available in all Amazon Web Services Regions where Amazon EFS is available.</p>  </note>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateFileSystem::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateFileSystem::set_tags): <p>Use to create one or more tags associated with the file system. Each tag is a user-defined key-value pair. Name your file system on creation by including a <code>"Key":"Name","Value":"{value}"</code> key-value pair. Each key must be unique. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
    /// - On success, responds with [`CreateFileSystemOutput`](crate::output::CreateFileSystemOutput) with field(s):
    ///   - [`owner_id(Option<String>)`](crate::output::CreateFileSystemOutput::owner_id): <p>The Amazon Web Services account that created the file system. If the file system was created by an IAM user, the parent account to which the user belongs is the owner.</p>
    ///   - [`creation_token(Option<String>)`](crate::output::CreateFileSystemOutput::creation_token): <p>The opaque string specified in the request.</p>
    ///   - [`file_system_id(Option<String>)`](crate::output::CreateFileSystemOutput::file_system_id): <p>The ID of the file system, assigned by Amazon EFS.</p>
    ///   - [`file_system_arn(Option<String>)`](crate::output::CreateFileSystemOutput::file_system_arn): <p>The Amazon Resource Name (ARN) for the EFS file system, in the format <code>arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i> </code>. Example with sample data: <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567</code> </p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::CreateFileSystemOutput::creation_time): <p>The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).</p>
    ///   - [`life_cycle_state(Option<LifeCycleState>)`](crate::output::CreateFileSystemOutput::life_cycle_state): <p>The lifecycle phase of the file system.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateFileSystemOutput::name): <p>You can add tags to a file system, including a <code>Name</code> tag. For more information, see <code>CreateFileSystem</code>. If the file system has a <code>Name</code> tag, Amazon EFS returns the value in this field. </p>
    ///   - [`number_of_mount_targets(i32)`](crate::output::CreateFileSystemOutput::number_of_mount_targets): <p>The current number of mount targets that the file system has. For more information, see <code>CreateMountTarget</code>.</p>
    ///   - [`size_in_bytes(Option<FileSystemSize>)`](crate::output::CreateFileSystemOutput::size_in_bytes): <p>The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code> field, and the time at which that size was determined in its <code>Timestamp</code> field. The <code>Timestamp</code> value is the integer number of seconds since 1970-01-01T00:00:00Z. The <code>SizeInBytes</code> value doesn't represent the size of a consistent snapshot of the file system, but it is eventually consistent when there are no writes to the file system. That is, <code>SizeInBytes</code> represents actual size only if the file system is not modified for a period longer than a couple of hours. Otherwise, the value is not the exact size that the file system was at any point in time. </p>
    ///   - [`performance_mode(Option<PerformanceMode>)`](crate::output::CreateFileSystemOutput::performance_mode): <p>The performance mode of the file system.</p>
    ///   - [`encrypted(Option<bool>)`](crate::output::CreateFileSystemOutput::encrypted): <p>A Boolean value that, if true, indicates that the file system is encrypted.</p>
    ///   - [`kms_key_id(Option<String>)`](crate::output::CreateFileSystemOutput::kms_key_id): <p>The ID of an KMS key used to protect the encrypted file system.</p>
    ///   - [`throughput_mode(Option<ThroughputMode>)`](crate::output::CreateFileSystemOutput::throughput_mode): <p>Displays the file system's throughput mode. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a> in the <i>Amazon EFS User Guide</i>. </p>
    ///   - [`provisioned_throughput_in_mibps(Option<f64>)`](crate::output::CreateFileSystemOutput::provisioned_throughput_in_mibps): <p>The amount of provisioned throughput, measured in MiB/s, for the file system. Valid for file systems using <code>ThroughputMode</code> set to <code>provisioned</code>.</p>
    ///   - [`availability_zone_name(Option<String>)`](crate::output::CreateFileSystemOutput::availability_zone_name): <p>Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid only for file systems using One Zone storage classes. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p>
    ///   - [`availability_zone_id(Option<String>)`](crate::output::CreateFileSystemOutput::availability_zone_id): <p>The unique and consistent identifier of the Availability Zone in which the file system's One Zone storage classes exist. For example, <code>use1-az1</code> is an Availability Zone ID for the us-east-1 Amazon Web Services Region, and it has the same location in every Amazon Web Services account.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreateFileSystemOutput::tags): <p>The tags associated with the file system, presented as an array of <code>Tag</code> objects.</p>
    /// - On failure, responds with [`SdkError<CreateFileSystemError>`](crate::error::CreateFileSystemError)
    pub fn create_file_system(&self) -> fluent_builders::CreateFileSystem {
        fluent_builders::CreateFileSystem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMountTarget`](crate::client::fluent_builders::CreateMountTarget) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::CreateMountTarget::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::CreateMountTarget::set_file_system_id): <p>The ID of the file system for which to create the mount target.</p>
    ///   - [`subnet_id(impl Into<String>)`](crate::client::fluent_builders::CreateMountTarget::subnet_id) / [`set_subnet_id(Option<String>)`](crate::client::fluent_builders::CreateMountTarget::set_subnet_id): <p>The ID of the subnet to add the mount target in. For file systems that use One Zone storage classes, use the subnet that is associated with the file system's Availability Zone.</p>
    ///   - [`ip_address(impl Into<String>)`](crate::client::fluent_builders::CreateMountTarget::ip_address) / [`set_ip_address(Option<String>)`](crate::client::fluent_builders::CreateMountTarget::set_ip_address): <p>Valid IPv4 address within the address range of the specified subnet.</p>
    ///   - [`security_groups(Vec<String>)`](crate::client::fluent_builders::CreateMountTarget::security_groups) / [`set_security_groups(Option<Vec<String>>)`](crate::client::fluent_builders::CreateMountTarget::set_security_groups): <p>Up to five VPC security group IDs, of the form <code>sg-xxxxxxxx</code>. These must be for the same VPC as subnet specified.</p>
    /// - On success, responds with [`CreateMountTargetOutput`](crate::output::CreateMountTargetOutput) with field(s):
    ///   - [`owner_id(Option<String>)`](crate::output::CreateMountTargetOutput::owner_id): <p>Amazon Web Services account ID that owns the resource.</p>
    ///   - [`mount_target_id(Option<String>)`](crate::output::CreateMountTargetOutput::mount_target_id): <p>System-assigned mount target ID.</p>
    ///   - [`file_system_id(Option<String>)`](crate::output::CreateMountTargetOutput::file_system_id): <p>The ID of the file system for which the mount target is intended.</p>
    ///   - [`subnet_id(Option<String>)`](crate::output::CreateMountTargetOutput::subnet_id): <p>The ID of the mount target's subnet.</p>
    ///   - [`life_cycle_state(Option<LifeCycleState>)`](crate::output::CreateMountTargetOutput::life_cycle_state): <p>Lifecycle state of the mount target.</p>
    ///   - [`ip_address(Option<String>)`](crate::output::CreateMountTargetOutput::ip_address): <p>Address at which the file system can be mounted by using the mount target.</p>
    ///   - [`network_interface_id(Option<String>)`](crate::output::CreateMountTargetOutput::network_interface_id): <p>The ID of the network interface that Amazon EFS created when it created the mount target.</p>
    ///   - [`availability_zone_id(Option<String>)`](crate::output::CreateMountTargetOutput::availability_zone_id): <p>The unique and consistent identifier of the Availability Zone that the mount target resides in. For example, <code>use1-az1</code> is an AZ ID for the us-east-1 Region and it has the same location in every Amazon Web Services account.</p>
    ///   - [`availability_zone_name(Option<String>)`](crate::output::CreateMountTargetOutput::availability_zone_name): <p>The name of the Availability Zone in which the mount target is located. Availability Zones are independently mapped to names for each Amazon Web Services account. For example, the Availability Zone <code>us-east-1a</code> for your Amazon Web Services account might not be the same location as <code>us-east-1a</code> for another Amazon Web Services account.</p>
    ///   - [`vpc_id(Option<String>)`](crate::output::CreateMountTargetOutput::vpc_id): <p>The virtual private cloud (VPC) ID that the mount target is configured in.</p>
    /// - On failure, responds with [`SdkError<CreateMountTargetError>`](crate::error::CreateMountTargetError)
    pub fn create_mount_target(&self) -> fluent_builders::CreateMountTarget {
        fluent_builders::CreateMountTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateReplicationConfiguration`](crate::client::fluent_builders::CreateReplicationConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_file_system_id(impl Into<String>)`](crate::client::fluent_builders::CreateReplicationConfiguration::source_file_system_id) / [`set_source_file_system_id(Option<String>)`](crate::client::fluent_builders::CreateReplicationConfiguration::set_source_file_system_id): <p>Specifies the Amazon EFS file system that you want to replicate. This file system cannot already be a source or destination file system in another replication configuration.</p>
    ///   - [`destinations(Vec<DestinationToCreate>)`](crate::client::fluent_builders::CreateReplicationConfiguration::destinations) / [`set_destinations(Option<Vec<DestinationToCreate>>)`](crate::client::fluent_builders::CreateReplicationConfiguration::set_destinations): <p>An array of destination configuration objects. Only one destination configuration object is supported.</p>
    /// - On success, responds with [`CreateReplicationConfigurationOutput`](crate::output::CreateReplicationConfigurationOutput) with field(s):
    ///   - [`source_file_system_id(Option<String>)`](crate::output::CreateReplicationConfigurationOutput::source_file_system_id): <p>The ID of the source Amazon EFS file system that is being replicated.</p>
    ///   - [`source_file_system_region(Option<String>)`](crate::output::CreateReplicationConfigurationOutput::source_file_system_region): <p>The Amazon Web Services Region in which the source Amazon EFS file system is located.</p>
    ///   - [`source_file_system_arn(Option<String>)`](crate::output::CreateReplicationConfigurationOutput::source_file_system_arn): <p>The ARN of the current source file system in the replication configuration.</p>
    ///   - [`original_source_file_system_arn(Option<String>)`](crate::output::CreateReplicationConfigurationOutput::original_source_file_system_arn): <p>The Amazon Resource Name (ARN) of the original source Amazon EFS file system in the replication configuration.</p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::CreateReplicationConfigurationOutput::creation_time): <p>Describes when the replication configuration was created.</p>
    ///   - [`destinations(Option<Vec<Destination>>)`](crate::output::CreateReplicationConfigurationOutput::destinations): <p>Array of destination objects. Only one destination object is supported.</p>
    /// - On failure, responds with [`SdkError<CreateReplicationConfigurationError>`](crate::error::CreateReplicationConfigurationError)
    pub fn create_replication_configuration(
        &self,
    ) -> fluent_builders::CreateReplicationConfiguration {
        fluent_builders::CreateReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTags`](crate::client::fluent_builders::CreateTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::CreateTags::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::CreateTags::set_file_system_id): <p>The ID of the file system whose tags you want to modify (String). This operation modifies the tags only, not the file system.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateTags::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateTags::set_tags): <p>An array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value pair. </p>
    /// - On success, responds with [`CreateTagsOutput`](crate::output::CreateTagsOutput)

    /// - On failure, responds with [`SdkError<CreateTagsError>`](crate::error::CreateTagsError)
    pub fn create_tags(&self) -> fluent_builders::CreateTags {
        fluent_builders::CreateTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAccessPoint`](crate::client::fluent_builders::DeleteAccessPoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`access_point_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAccessPoint::access_point_id) / [`set_access_point_id(Option<String>)`](crate::client::fluent_builders::DeleteAccessPoint::set_access_point_id): <p>The ID of the access point that you want to delete.</p>
    /// - On success, responds with [`DeleteAccessPointOutput`](crate::output::DeleteAccessPointOutput)

    /// - On failure, responds with [`SdkError<DeleteAccessPointError>`](crate::error::DeleteAccessPointError)
    pub fn delete_access_point(&self) -> fluent_builders::DeleteAccessPoint {
        fluent_builders::DeleteAccessPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFileSystem`](crate::client::fluent_builders::DeleteFileSystem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFileSystem::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::DeleteFileSystem::set_file_system_id): <p>The ID of the file system you want to delete.</p>
    /// - On success, responds with [`DeleteFileSystemOutput`](crate::output::DeleteFileSystemOutput)

    /// - On failure, responds with [`SdkError<DeleteFileSystemError>`](crate::error::DeleteFileSystemError)
    pub fn delete_file_system(&self) -> fluent_builders::DeleteFileSystem {
        fluent_builders::DeleteFileSystem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFileSystemPolicy`](crate::client::fluent_builders::DeleteFileSystemPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFileSystemPolicy::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::DeleteFileSystemPolicy::set_file_system_id): <p>Specifies the EFS file system for which to delete the <code>FileSystemPolicy</code>.</p>
    /// - On success, responds with [`DeleteFileSystemPolicyOutput`](crate::output::DeleteFileSystemPolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteFileSystemPolicyError>`](crate::error::DeleteFileSystemPolicyError)
    pub fn delete_file_system_policy(&self) -> fluent_builders::DeleteFileSystemPolicy {
        fluent_builders::DeleteFileSystemPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMountTarget`](crate::client::fluent_builders::DeleteMountTarget) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`mount_target_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMountTarget::mount_target_id) / [`set_mount_target_id(Option<String>)`](crate::client::fluent_builders::DeleteMountTarget::set_mount_target_id): <p>The ID of the mount target to delete (String).</p>
    /// - On success, responds with [`DeleteMountTargetOutput`](crate::output::DeleteMountTargetOutput)

    /// - On failure, responds with [`SdkError<DeleteMountTargetError>`](crate::error::DeleteMountTargetError)
    pub fn delete_mount_target(&self) -> fluent_builders::DeleteMountTarget {
        fluent_builders::DeleteMountTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteReplicationConfiguration`](crate::client::fluent_builders::DeleteReplicationConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_file_system_id(impl Into<String>)`](crate::client::fluent_builders::DeleteReplicationConfiguration::source_file_system_id) / [`set_source_file_system_id(Option<String>)`](crate::client::fluent_builders::DeleteReplicationConfiguration::set_source_file_system_id): <p>The ID of the source file system in the replication configuration.</p>
    /// - On success, responds with [`DeleteReplicationConfigurationOutput`](crate::output::DeleteReplicationConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteReplicationConfigurationError>`](crate::error::DeleteReplicationConfigurationError)
    pub fn delete_replication_configuration(
        &self,
    ) -> fluent_builders::DeleteReplicationConfiguration {
        fluent_builders::DeleteReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTags`](crate::client::fluent_builders::DeleteTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTags::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::DeleteTags::set_file_system_id): <p>The ID of the file system whose tags you want to delete (String).</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::DeleteTags::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteTags::set_tag_keys): <p>A list of tag keys to delete.</p>
    /// - On success, responds with [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)

    /// - On failure, responds with [`SdkError<DeleteTagsError>`](crate::error::DeleteTagsError)
    pub fn delete_tags(&self) -> fluent_builders::DeleteTags {
        fluent_builders::DeleteTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccessPoints`](crate::client::fluent_builders::DescribeAccessPoints) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeAccessPoints::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeAccessPoints::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeAccessPoints::set_max_results): <p>(Optional) When retrieving all access points for a file system, you can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response. The default value is 100. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeAccessPoints::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeAccessPoints::set_next_token): <p> <code>NextToken</code> is present if the response is paginated. You can use <code>NextMarker</code> in the subsequent request to fetch the next page of access point descriptions.</p>
    ///   - [`access_point_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAccessPoints::access_point_id) / [`set_access_point_id(Option<String>)`](crate::client::fluent_builders::DescribeAccessPoints::set_access_point_id): <p>(Optional) Specifies an EFS access point to describe in the response; mutually exclusive with <code>FileSystemId</code>.</p>
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAccessPoints::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::DescribeAccessPoints::set_file_system_id): <p>(Optional) If you provide a <code>FileSystemId</code>, EFS returns all access points for that file system; mutually exclusive with <code>AccessPointId</code>.</p>
    /// - On success, responds with [`DescribeAccessPointsOutput`](crate::output::DescribeAccessPointsOutput) with field(s):
    ///   - [`access_points(Option<Vec<AccessPointDescription>>)`](crate::output::DescribeAccessPointsOutput::access_points): <p>An array of access point descriptions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAccessPointsOutput::next_token): <p>Present if there are more access points than returned in the response. You can use the NextMarker in the subsequent request to fetch the additional descriptions.</p>
    /// - On failure, responds with [`SdkError<DescribeAccessPointsError>`](crate::error::DescribeAccessPointsError)
    pub fn describe_access_points(&self) -> fluent_builders::DescribeAccessPoints {
        fluent_builders::DescribeAccessPoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccountPreferences`](crate::client::fluent_builders::DescribeAccountPreferences) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeAccountPreferences::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeAccountPreferences::set_next_token): <p>(Optional) You can use <code>NextToken</code> in a subsequent request to fetch the next page of Amazon Web Services account preferences if the response payload was paginated.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeAccountPreferences::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeAccountPreferences::set_max_results): <p>(Optional) When retrieving account preferences, you can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response. The default value is 100. </p>
    /// - On success, responds with [`DescribeAccountPreferencesOutput`](crate::output::DescribeAccountPreferencesOutput) with field(s):
    ///   - [`resource_id_preference(Option<ResourceIdPreference>)`](crate::output::DescribeAccountPreferencesOutput::resource_id_preference): <p>Describes the resource ID preference setting for the Amazon Web Services account associated with the user making the request, in the current Amazon Web Services Region.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAccountPreferencesOutput::next_token): <p>Present if there are more records than returned in the response. You can use the <code>NextToken</code> in the subsequent request to fetch the additional descriptions.</p>
    /// - On failure, responds with [`SdkError<DescribeAccountPreferencesError>`](crate::error::DescribeAccountPreferencesError)
    pub fn describe_account_preferences(&self) -> fluent_builders::DescribeAccountPreferences {
        fluent_builders::DescribeAccountPreferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBackupPolicy`](crate::client::fluent_builders::DescribeBackupPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBackupPolicy::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::DescribeBackupPolicy::set_file_system_id): <p>Specifies which EFS file system to retrieve the <code>BackupPolicy</code> for.</p>
    /// - On success, responds with [`DescribeBackupPolicyOutput`](crate::output::DescribeBackupPolicyOutput) with field(s):
    ///   - [`backup_policy(Option<BackupPolicy>)`](crate::output::DescribeBackupPolicyOutput::backup_policy): <p>Describes the file system's backup policy, indicating whether automatic backups are turned on or off..</p>
    /// - On failure, responds with [`SdkError<DescribeBackupPolicyError>`](crate::error::DescribeBackupPolicyError)
    pub fn describe_backup_policy(&self) -> fluent_builders::DescribeBackupPolicy {
        fluent_builders::DescribeBackupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFileSystemPolicy`](crate::client::fluent_builders::DescribeFileSystemPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFileSystemPolicy::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::DescribeFileSystemPolicy::set_file_system_id): <p>Specifies which EFS file system to retrieve the <code>FileSystemPolicy</code> for.</p>
    /// - On success, responds with [`DescribeFileSystemPolicyOutput`](crate::output::DescribeFileSystemPolicyOutput) with field(s):
    ///   - [`file_system_id(Option<String>)`](crate::output::DescribeFileSystemPolicyOutput::file_system_id): <p>Specifies the EFS file system to which the <code>FileSystemPolicy</code> applies.</p>
    ///   - [`policy(Option<String>)`](crate::output::DescribeFileSystemPolicyOutput::policy): <p>The JSON formatted <code>FileSystemPolicy</code> for the EFS file system.</p>
    /// - On failure, responds with [`SdkError<DescribeFileSystemPolicyError>`](crate::error::DescribeFileSystemPolicyError)
    pub fn describe_file_system_policy(&self) -> fluent_builders::DescribeFileSystemPolicy {
        fluent_builders::DescribeFileSystemPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFileSystems`](crate::client::fluent_builders::DescribeFileSystems) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeFileSystems::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_items(i32)`](crate::client::fluent_builders::DescribeFileSystems::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::DescribeFileSystems::set_max_items): <p>(Optional) Specifies the maximum number of file systems to return in the response (integer). This number is automatically set to 100. The response is paginated at 100 per page if you have more than 100 file systems. </p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeFileSystems::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeFileSystems::set_marker): <p>(Optional) Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation (String). If present, specifies to continue the list from where the returning call had left off. </p>
    ///   - [`creation_token(impl Into<String>)`](crate::client::fluent_builders::DescribeFileSystems::creation_token) / [`set_creation_token(Option<String>)`](crate::client::fluent_builders::DescribeFileSystems::set_creation_token): <p>(Optional) Restricts the list to the file system with this creation token (String). You specify a creation token when you create an Amazon EFS file system.</p>
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFileSystems::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::DescribeFileSystems::set_file_system_id): <p>(Optional) ID of the file system whose description you want to retrieve (String).</p>
    /// - On success, responds with [`DescribeFileSystemsOutput`](crate::output::DescribeFileSystemsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeFileSystemsOutput::marker): <p>Present if provided by caller in the request (String).</p>
    ///   - [`file_systems(Option<Vec<FileSystemDescription>>)`](crate::output::DescribeFileSystemsOutput::file_systems): <p>An array of file system descriptions.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::DescribeFileSystemsOutput::next_marker): <p>Present if there are more file systems than returned in the response (String). You can use the <code>NextMarker</code> in the subsequent request to fetch the descriptions.</p>
    /// - On failure, responds with [`SdkError<DescribeFileSystemsError>`](crate::error::DescribeFileSystemsError)
    pub fn describe_file_systems(&self) -> fluent_builders::DescribeFileSystems {
        fluent_builders::DescribeFileSystems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLifecycleConfiguration`](crate::client::fluent_builders::DescribeLifecycleConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::DescribeLifecycleConfiguration::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::DescribeLifecycleConfiguration::set_file_system_id): <p>The ID of the file system whose <code>LifecycleConfiguration</code> object you want to retrieve (String).</p>
    /// - On success, responds with [`DescribeLifecycleConfigurationOutput`](crate::output::DescribeLifecycleConfigurationOutput) with field(s):
    ///   - [`lifecycle_policies(Option<Vec<LifecyclePolicy>>)`](crate::output::DescribeLifecycleConfigurationOutput::lifecycle_policies): <p>An array of lifecycle management policies. EFS supports a maximum of one policy per file system.</p>
    /// - On failure, responds with [`SdkError<DescribeLifecycleConfigurationError>`](crate::error::DescribeLifecycleConfigurationError)
    pub fn describe_lifecycle_configuration(
        &self,
    ) -> fluent_builders::DescribeLifecycleConfiguration {
        fluent_builders::DescribeLifecycleConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMountTargets`](crate::client::fluent_builders::DescribeMountTargets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_items(i32)`](crate::client::fluent_builders::DescribeMountTargets::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::DescribeMountTargets::set_max_items): <p>(Optional) Maximum number of mount targets to return in the response. Currently, this number is automatically set to 10, and other values are ignored. The response is paginated at 100 per page if you have more than 100 mount targets.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeMountTargets::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeMountTargets::set_marker): <p>(Optional) Opaque pagination token returned from a previous <code>DescribeMountTargets</code> operation (String). If present, it specifies to continue the list from where the previous returning call left off.</p>
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::DescribeMountTargets::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::DescribeMountTargets::set_file_system_id): <p>(Optional) ID of the file system whose mount targets you want to list (String). It must be included in your request if an <code>AccessPointId</code> or <code>MountTargetId</code> is not included. Accepts either a file system ID or ARN as input.</p>
    ///   - [`mount_target_id(impl Into<String>)`](crate::client::fluent_builders::DescribeMountTargets::mount_target_id) / [`set_mount_target_id(Option<String>)`](crate::client::fluent_builders::DescribeMountTargets::set_mount_target_id): <p>(Optional) ID of the mount target that you want to have described (String). It must be included in your request if <code>FileSystemId</code> is not included. Accepts either a mount target ID or ARN as input.</p>
    ///   - [`access_point_id(impl Into<String>)`](crate::client::fluent_builders::DescribeMountTargets::access_point_id) / [`set_access_point_id(Option<String>)`](crate::client::fluent_builders::DescribeMountTargets::set_access_point_id): <p>(Optional) The ID of the access point whose mount targets that you want to list. It must be included in your request if a <code>FileSystemId</code> or <code>MountTargetId</code> is not included in your request. Accepts either an access point ID or ARN as input.</p>
    /// - On success, responds with [`DescribeMountTargetsOutput`](crate::output::DescribeMountTargetsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeMountTargetsOutput::marker): <p>If the request included the <code>Marker</code>, the response returns that value in this field.</p>
    ///   - [`mount_targets(Option<Vec<MountTargetDescription>>)`](crate::output::DescribeMountTargetsOutput::mount_targets): <p>Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::DescribeMountTargetsOutput::next_marker): <p>If a value is present, there are more mount targets to return. In a subsequent request, you can provide <code>Marker</code> in your request with this value to retrieve the next set of mount targets.</p>
    /// - On failure, responds with [`SdkError<DescribeMountTargetsError>`](crate::error::DescribeMountTargetsError)
    pub fn describe_mount_targets(&self) -> fluent_builders::DescribeMountTargets {
        fluent_builders::DescribeMountTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMountTargetSecurityGroups`](crate::client::fluent_builders::DescribeMountTargetSecurityGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`mount_target_id(impl Into<String>)`](crate::client::fluent_builders::DescribeMountTargetSecurityGroups::mount_target_id) / [`set_mount_target_id(Option<String>)`](crate::client::fluent_builders::DescribeMountTargetSecurityGroups::set_mount_target_id): <p>The ID of the mount target whose security groups you want to retrieve.</p>
    /// - On success, responds with [`DescribeMountTargetSecurityGroupsOutput`](crate::output::DescribeMountTargetSecurityGroupsOutput) with field(s):
    ///   - [`security_groups(Option<Vec<String>>)`](crate::output::DescribeMountTargetSecurityGroupsOutput::security_groups): <p>An array of security groups.</p>
    /// - On failure, responds with [`SdkError<DescribeMountTargetSecurityGroupsError>`](crate::error::DescribeMountTargetSecurityGroupsError)
    pub fn describe_mount_target_security_groups(
        &self,
    ) -> fluent_builders::DescribeMountTargetSecurityGroups {
        fluent_builders::DescribeMountTargetSecurityGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReplicationConfigurations`](crate::client::fluent_builders::DescribeReplicationConfigurations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReplicationConfigurations::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::DescribeReplicationConfigurations::set_file_system_id): <p>You can retrieve replication configurations for a specific file system by providing a file system ID.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeReplicationConfigurations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeReplicationConfigurations::set_next_token): <p> <code>NextToken</code> is present if the response is paginated. You can use <code>NextMarker</code> in a subsequent request to fetch the next page of output.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeReplicationConfigurations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeReplicationConfigurations::set_max_results): <p>(Optional) You can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response. The default value is 100. </p>
    /// - On success, responds with [`DescribeReplicationConfigurationsOutput`](crate::output::DescribeReplicationConfigurationsOutput) with field(s):
    ///   - [`replications(Option<Vec<ReplicationConfigurationDescription>>)`](crate::output::DescribeReplicationConfigurationsOutput::replications): <p>The collection of replication configurations returned.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeReplicationConfigurationsOutput::next_token): <p>You can use the <code>NextToken</code> from the previous response in a subsequent request to fetch the additional descriptions.</p>
    /// - On failure, responds with [`SdkError<DescribeReplicationConfigurationsError>`](crate::error::DescribeReplicationConfigurationsError)
    pub fn describe_replication_configurations(
        &self,
    ) -> fluent_builders::DescribeReplicationConfigurations {
        fluent_builders::DescribeReplicationConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTags`](crate::client::fluent_builders::DescribeTags) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTags::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_items(i32)`](crate::client::fluent_builders::DescribeTags::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::DescribeTags::set_max_items): <p>(Optional) The maximum number of file system tags to return in the response. Currently, this number is automatically set to 100, and other values are ignored. The response is paginated at 100 per page if you have more than 100 tags.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeTags::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeTags::set_marker): <p>(Optional) An opaque pagination token returned from a previous <code>DescribeTags</code> operation (String). If present, it specifies to continue the list from where the previous call left off.</p>
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTags::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::DescribeTags::set_file_system_id): <p>The ID of the file system whose tag set you want to retrieve.</p>
    /// - On success, responds with [`DescribeTagsOutput`](crate::output::DescribeTagsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeTagsOutput::marker): <p>If the request included a <code>Marker</code>, the response returns that value in this field.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::DescribeTagsOutput::tags): <p>Returns tags associated with the file system as an array of <code>Tag</code> objects. </p>
    ///   - [`next_marker(Option<String>)`](crate::output::DescribeTagsOutput::next_marker): <p>If a value is present, there are more tags to return. In a subsequent request, you can provide the value of <code>NextMarker</code> as the value of the <code>Marker</code> parameter in your next request to retrieve the next set of tags.</p>
    /// - On failure, responds with [`SdkError<DescribeTagsError>`](crate::error::DescribeTagsError)
    pub fn describe_tags(&self) -> fluent_builders::DescribeTags {
        fluent_builders::DescribeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTagsForResource::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_id): <p>Specifies the EFS resource you want to retrieve tags for. You can retrieve tags for EFS file systems and access points using this API endpoint.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTagsForResource::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTagsForResource::set_max_results): <p>(Optional) Specifies the maximum number of tag objects to return in the response. The default value is 100.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>(Optional) You can use <code>NextToken</code> in a subsequent request to fetch the next page of access point descriptions if the response payload was paginated.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>An array of the tags for the specified EFS resource.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p> <code>NextToken</code> is present if the response payload is paginated. You can use <code>NextToken</code> in a subsequent request to fetch the next page of access point descriptions.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyMountTargetSecurityGroups`](crate::client::fluent_builders::ModifyMountTargetSecurityGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`mount_target_id(impl Into<String>)`](crate::client::fluent_builders::ModifyMountTargetSecurityGroups::mount_target_id) / [`set_mount_target_id(Option<String>)`](crate::client::fluent_builders::ModifyMountTargetSecurityGroups::set_mount_target_id): <p>The ID of the mount target whose security groups you want to modify.</p>
    ///   - [`security_groups(Vec<String>)`](crate::client::fluent_builders::ModifyMountTargetSecurityGroups::security_groups) / [`set_security_groups(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyMountTargetSecurityGroups::set_security_groups): <p>An array of up to five VPC security group IDs.</p>
    /// - On success, responds with [`ModifyMountTargetSecurityGroupsOutput`](crate::output::ModifyMountTargetSecurityGroupsOutput)

    /// - On failure, responds with [`SdkError<ModifyMountTargetSecurityGroupsError>`](crate::error::ModifyMountTargetSecurityGroupsError)
    pub fn modify_mount_target_security_groups(
        &self,
    ) -> fluent_builders::ModifyMountTargetSecurityGroups {
        fluent_builders::ModifyMountTargetSecurityGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAccountPreferences`](crate::client::fluent_builders::PutAccountPreferences) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id_type(ResourceIdType)`](crate::client::fluent_builders::PutAccountPreferences::resource_id_type) / [`set_resource_id_type(Option<ResourceIdType>)`](crate::client::fluent_builders::PutAccountPreferences::set_resource_id_type): <p>Specifies the EFS resource ID preference to set for the user's Amazon Web Services account, in the current Amazon Web Services Region, either <code>LONG_ID</code> (17 characters), or <code>SHORT_ID</code> (8 characters).</p> <note>   <p>Starting in October, 2021, you will receive an error when setting the account preference to <code>SHORT_ID</code>. Contact Amazon Web Services support if you receive an error and need to use short IDs for file system and mount target resources.</p>  </note>
    /// - On success, responds with [`PutAccountPreferencesOutput`](crate::output::PutAccountPreferencesOutput) with field(s):
    ///   - [`resource_id_preference(Option<ResourceIdPreference>)`](crate::output::PutAccountPreferencesOutput::resource_id_preference): <p>Describes the resource type and its ID preference for the user's Amazon Web Services account, in the current Amazon Web Services Region.</p>
    /// - On failure, responds with [`SdkError<PutAccountPreferencesError>`](crate::error::PutAccountPreferencesError)
    pub fn put_account_preferences(&self) -> fluent_builders::PutAccountPreferences {
        fluent_builders::PutAccountPreferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBackupPolicy`](crate::client::fluent_builders::PutBackupPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::PutBackupPolicy::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::PutBackupPolicy::set_file_system_id): <p>Specifies which EFS file system to update the backup policy for.</p>
    ///   - [`backup_policy(BackupPolicy)`](crate::client::fluent_builders::PutBackupPolicy::backup_policy) / [`set_backup_policy(Option<BackupPolicy>)`](crate::client::fluent_builders::PutBackupPolicy::set_backup_policy): <p>The backup policy included in the <code>PutBackupPolicy</code> request.</p>
    /// - On success, responds with [`PutBackupPolicyOutput`](crate::output::PutBackupPolicyOutput) with field(s):
    ///   - [`backup_policy(Option<BackupPolicy>)`](crate::output::PutBackupPolicyOutput::backup_policy): <p>Describes the file system's backup policy, indicating whether automatic backups are turned on or off..</p>
    /// - On failure, responds with [`SdkError<PutBackupPolicyError>`](crate::error::PutBackupPolicyError)
    pub fn put_backup_policy(&self) -> fluent_builders::PutBackupPolicy {
        fluent_builders::PutBackupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutFileSystemPolicy`](crate::client::fluent_builders::PutFileSystemPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::PutFileSystemPolicy::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::PutFileSystemPolicy::set_file_system_id): <p>The ID of the EFS file system that you want to create or update the <code>FileSystemPolicy</code> for.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutFileSystemPolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutFileSystemPolicy::set_policy): <p>The <code>FileSystemPolicy</code> that you're creating. Accepts a JSON formatted policy definition. EFS file system policies have a 20,000 character limit. To find out more about the elements that make up a file system policy, see <a href="https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies">EFS Resource-based Policies</a>. </p>
    ///   - [`bypass_policy_lockout_safety_check(bool)`](crate::client::fluent_builders::PutFileSystemPolicy::bypass_policy_lockout_safety_check) / [`set_bypass_policy_lockout_safety_check(bool)`](crate::client::fluent_builders::PutFileSystemPolicy::set_bypass_policy_lockout_safety_check): <p>(Optional) A flag to indicate whether to bypass the <code>FileSystemPolicy</code> lockout safety check. The policy lockout safety check determines whether the policy in the request will prevent the principal making the request will be locked out from making future <code>PutFileSystemPolicy</code> requests on the file system. Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent the principal that is making the request from making a subsequent <code>PutFileSystemPolicy</code> request on the file system. The default value is False. </p>
    /// - On success, responds with [`PutFileSystemPolicyOutput`](crate::output::PutFileSystemPolicyOutput) with field(s):
    ///   - [`file_system_id(Option<String>)`](crate::output::PutFileSystemPolicyOutput::file_system_id): <p>Specifies the EFS file system to which the <code>FileSystemPolicy</code> applies.</p>
    ///   - [`policy(Option<String>)`](crate::output::PutFileSystemPolicyOutput::policy): <p>The JSON formatted <code>FileSystemPolicy</code> for the EFS file system.</p>
    /// - On failure, responds with [`SdkError<PutFileSystemPolicyError>`](crate::error::PutFileSystemPolicyError)
    pub fn put_file_system_policy(&self) -> fluent_builders::PutFileSystemPolicy {
        fluent_builders::PutFileSystemPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutLifecycleConfiguration`](crate::client::fluent_builders::PutLifecycleConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::PutLifecycleConfiguration::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::PutLifecycleConfiguration::set_file_system_id): <p>The ID of the file system for which you are creating the <code>LifecycleConfiguration</code> object (String).</p>
    ///   - [`lifecycle_policies(Vec<LifecyclePolicy>)`](crate::client::fluent_builders::PutLifecycleConfiguration::lifecycle_policies) / [`set_lifecycle_policies(Option<Vec<LifecyclePolicy>>)`](crate::client::fluent_builders::PutLifecycleConfiguration::set_lifecycle_policies): <p>An array of <code>LifecyclePolicy</code> objects that define the file system's <code>LifecycleConfiguration</code> object. A <code>LifecycleConfiguration</code> object informs EFS lifecycle management and intelligent tiering of the following:</p>  <ul>   <li> <p>When to move files in the file system from primary storage to the IA storage class.</p> </li>   <li> <p>When to move files that are in IA storage to primary storage.</p> </li>  </ul> <note>   <p>When using the <code>put-lifecycle-configuration</code> CLI command or the <code>PutLifecycleConfiguration</code> API action, Amazon EFS requires that each <code>LifecyclePolicy</code> object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code>, <code>TransitionToPrimaryStorageClass</code>. See the example requests in the following section for more information.</p>  </note>
    /// - On success, responds with [`PutLifecycleConfigurationOutput`](crate::output::PutLifecycleConfigurationOutput) with field(s):
    ///   - [`lifecycle_policies(Option<Vec<LifecyclePolicy>>)`](crate::output::PutLifecycleConfigurationOutput::lifecycle_policies): <p>An array of lifecycle management policies. EFS supports a maximum of one policy per file system.</p>
    /// - On failure, responds with [`SdkError<PutLifecycleConfigurationError>`](crate::error::PutLifecycleConfigurationError)
    pub fn put_lifecycle_configuration(&self) -> fluent_builders::PutLifecycleConfiguration {
        fluent_builders::PutLifecycleConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_id): <p>The ID specifying the EFS resource that you want to create a tag for.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>An array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value pair.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_id): <p>Specifies the EFS resource that you want to remove tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The keys of the key-value tag pairs that you want to remove from the specified EFS resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFileSystem`](crate::client::fluent_builders::UpdateFileSystem) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`file_system_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFileSystem::file_system_id) / [`set_file_system_id(Option<String>)`](crate::client::fluent_builders::UpdateFileSystem::set_file_system_id): <p>The ID of the file system that you want to update.</p>
    ///   - [`throughput_mode(ThroughputMode)`](crate::client::fluent_builders::UpdateFileSystem::throughput_mode) / [`set_throughput_mode(Option<ThroughputMode>)`](crate::client::fluent_builders::UpdateFileSystem::set_throughput_mode): <p>(Optional) Updates the file system's throughput mode. If you're not updating your throughput mode, you don't need to provide this value in your request. If you are changing the <code>ThroughputMode</code> to <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughputInMibps</code>.</p>
    ///   - [`provisioned_throughput_in_mibps(f64)`](crate::client::fluent_builders::UpdateFileSystem::provisioned_throughput_in_mibps) / [`set_provisioned_throughput_in_mibps(Option<f64>)`](crate::client::fluent_builders::UpdateFileSystem::set_provisioned_throughput_in_mibps): <p>(Optional) Sets the amount of provisioned throughput, in MiB/s, for the file system. Valid values are 1-1024. If you are changing the throughput mode to provisioned, you must also provide the amount of provisioned throughput. Required if <code>ThroughputMode</code> is changed to <code>provisioned</code> on update.</p>
    /// - On success, responds with [`UpdateFileSystemOutput`](crate::output::UpdateFileSystemOutput) with field(s):
    ///   - [`owner_id(Option<String>)`](crate::output::UpdateFileSystemOutput::owner_id): <p>The Amazon Web Services account that created the file system. If the file system was created by an IAM user, the parent account to which the user belongs is the owner.</p>
    ///   - [`creation_token(Option<String>)`](crate::output::UpdateFileSystemOutput::creation_token): <p>The opaque string specified in the request.</p>
    ///   - [`file_system_id(Option<String>)`](crate::output::UpdateFileSystemOutput::file_system_id): <p>The ID of the file system, assigned by Amazon EFS.</p>
    ///   - [`file_system_arn(Option<String>)`](crate::output::UpdateFileSystemOutput::file_system_arn): <p>The Amazon Resource Name (ARN) for the EFS file system, in the format <code>arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i> </code>. Example with sample data: <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567</code> </p>
    ///   - [`creation_time(Option<DateTime>)`](crate::output::UpdateFileSystemOutput::creation_time): <p>The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).</p>
    ///   - [`life_cycle_state(Option<LifeCycleState>)`](crate::output::UpdateFileSystemOutput::life_cycle_state): <p>The lifecycle phase of the file system.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateFileSystemOutput::name): <p>You can add tags to a file system, including a <code>Name</code> tag. For more information, see <code>CreateFileSystem</code>. If the file system has a <code>Name</code> tag, Amazon EFS returns the value in this field. </p>
    ///   - [`number_of_mount_targets(i32)`](crate::output::UpdateFileSystemOutput::number_of_mount_targets): <p>The current number of mount targets that the file system has. For more information, see <code>CreateMountTarget</code>.</p>
    ///   - [`size_in_bytes(Option<FileSystemSize>)`](crate::output::UpdateFileSystemOutput::size_in_bytes): <p>The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code> field, and the time at which that size was determined in its <code>Timestamp</code> field. The <code>Timestamp</code> value is the integer number of seconds since 1970-01-01T00:00:00Z. The <code>SizeInBytes</code> value doesn't represent the size of a consistent snapshot of the file system, but it is eventually consistent when there are no writes to the file system. That is, <code>SizeInBytes</code> represents actual size only if the file system is not modified for a period longer than a couple of hours. Otherwise, the value is not the exact size that the file system was at any point in time. </p>
    ///   - [`performance_mode(Option<PerformanceMode>)`](crate::output::UpdateFileSystemOutput::performance_mode): <p>The performance mode of the file system.</p>
    ///   - [`encrypted(Option<bool>)`](crate::output::UpdateFileSystemOutput::encrypted): <p>A Boolean value that, if true, indicates that the file system is encrypted.</p>
    ///   - [`kms_key_id(Option<String>)`](crate::output::UpdateFileSystemOutput::kms_key_id): <p>The ID of an KMS key used to protect the encrypted file system.</p>
    ///   - [`throughput_mode(Option<ThroughputMode>)`](crate::output::UpdateFileSystemOutput::throughput_mode): <p>Displays the file system's throughput mode. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a> in the <i>Amazon EFS User Guide</i>. </p>
    ///   - [`provisioned_throughput_in_mibps(Option<f64>)`](crate::output::UpdateFileSystemOutput::provisioned_throughput_in_mibps): <p>The amount of provisioned throughput, measured in MiB/s, for the file system. Valid for file systems using <code>ThroughputMode</code> set to <code>provisioned</code>.</p>
    ///   - [`availability_zone_name(Option<String>)`](crate::output::UpdateFileSystemOutput::availability_zone_name): <p>Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid only for file systems using One Zone storage classes. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p>
    ///   - [`availability_zone_id(Option<String>)`](crate::output::UpdateFileSystemOutput::availability_zone_id): <p>The unique and consistent identifier of the Availability Zone in which the file system's One Zone storage classes exist. For example, <code>use1-az1</code> is an Availability Zone ID for the us-east-1 Amazon Web Services Region, and it has the same location in every Amazon Web Services account.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::UpdateFileSystemOutput::tags): <p>The tags associated with the file system, presented as an array of <code>Tag</code> objects.</p>
    /// - On failure, responds with [`SdkError<UpdateFileSystemError>`](crate::error::UpdateFileSystemError)
    pub fn update_file_system(&self) -> fluent_builders::UpdateFileSystem {
        fluent_builders::UpdateFileSystem::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateAccessPoint`.
    ///
    /// <p>Creates an EFS access point. An access point is an application-specific view into an EFS file system that applies an operating system user and group, and a file system path, to any file system request made through the access point. The operating system user and group override any identity information provided by the NFS client. The file system path is exposed as the access point's root directory. Applications using the access point can only access data in its own directory and below. To learn more, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">Mounting a file system using EFS access points</a>.</p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:CreateAccessPoint</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAccessPoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_access_point_input::Builder,
    }
    impl CreateAccessPoint {
        /// Creates a new `CreateAccessPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccessPointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccessPointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent creation.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent creation.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Creates tags associated with the access point. Each tag is a key-value pair, each key must be unique. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Creates tags associated with the access point. Each tag is a key-value pair, each key must be unique. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The ID of the EFS file system that the access point provides access to.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>The ID of the EFS file system that the access point provides access to.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>The operating system user and group applied to all file system requests made using the access point.</p>
        pub fn posix_user(mut self, input: crate::model::PosixUser) -> Self {
            self.inner = self.inner.posix_user(input);
            self
        }
        /// <p>The operating system user and group applied to all file system requests made using the access point.</p>
        pub fn set_posix_user(
            mut self,
            input: std::option::Option<crate::model::PosixUser>,
        ) -> Self {
            self.inner = self.inner.set_posix_user(input);
            self
        }
        /// <p>Specifies the directory on the Amazon EFS file system that the access point exposes as the root directory of your file system to NFS clients using the access point. The clients using the access point can only access the root directory and below. If the <code>RootDirectory</code> &gt; <code>Path</code> specified does not exist, EFS creates it and applies the <code>CreationInfo</code> settings when a client connects to an access point. When specifying a <code>RootDirectory</code>, you need to provide the <code>Path</code>, and the <code>CreationInfo</code>.</p>
        /// <p>Amazon EFS creates a root directory only if you have provided the CreationInfo: OwnUid, OwnGID, and permissions for the directory. If you do not provide this information, Amazon EFS does not create the root directory. If the root directory does not exist, attempts to mount using the access point will fail.</p>
        pub fn root_directory(mut self, input: crate::model::RootDirectory) -> Self {
            self.inner = self.inner.root_directory(input);
            self
        }
        /// <p>Specifies the directory on the Amazon EFS file system that the access point exposes as the root directory of your file system to NFS clients using the access point. The clients using the access point can only access the root directory and below. If the <code>RootDirectory</code> &gt; <code>Path</code> specified does not exist, EFS creates it and applies the <code>CreationInfo</code> settings when a client connects to an access point. When specifying a <code>RootDirectory</code>, you need to provide the <code>Path</code>, and the <code>CreationInfo</code>.</p>
        /// <p>Amazon EFS creates a root directory only if you have provided the CreationInfo: OwnUid, OwnGID, and permissions for the directory. If you do not provide this information, Amazon EFS does not create the root directory. If the root directory does not exist, attempts to mount using the access point will fail.</p>
        pub fn set_root_directory(
            mut self,
            input: std::option::Option<crate::model::RootDirectory>,
        ) -> Self {
            self.inner = self.inner.set_root_directory(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFileSystem`.
    ///
    /// <p>Creates a new, empty file system. The operation requires a creation token in the request that Amazon EFS uses to ensure idempotent creation (calling the operation with same creation token has no effect). If a file system does not currently exist that is owned by the caller's Amazon Web Services account with the specified creation token, this operation does the following:</p>
    /// <ul>
    /// <li> <p>Creates a new, empty file system. The file system will have an Amazon EFS assigned ID, and an initial lifecycle state <code>creating</code>.</p> </li>
    /// <li> <p>Returns with the description of the created file system.</p> </li>
    /// </ul>
    /// <p>Otherwise, this operation returns a <code>FileSystemAlreadyExists</code> error with the ID of the existing file system.</p> <note>
    /// <p>For basic use cases, you can use a randomly generated UUID for the creation token.</p>
    /// </note>
    /// <p> The idempotent operation allows you to retry a <code>CreateFileSystem</code> call without risk of creating an extra file system. This can happen when an initial call fails in a way that leaves it uncertain whether or not a file system was actually created. An example might be that a transport level timeout occurred or your connection was reset. As long as you use the same creation token, if the initial call had succeeded in creating a file system, the client can learn of its existence from the <code>FileSystemAlreadyExists</code> error.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/creating-using-create-fs.html#creating-using-create-fs-part1">Creating a file system</a> in the <i>Amazon EFS User Guide</i>.</p> <note>
    /// <p>The <code>CreateFileSystem</code> call returns while the file system's lifecycle state is still <code>creating</code>. You can check the file system creation status by calling the <code>DescribeFileSystems</code> operation, which among other things returns the file system state.</p>
    /// </note>
    /// <p>This operation accepts an optional <code>PerformanceMode</code> parameter that you choose for your file system. We recommend <code>generalPurpose</code> performance mode for most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed after the file system has been created. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#performancemodes.html">Amazon EFS performance modes</a>.</p>
    /// <p>You can set the throughput mode for the file system using the <code>ThroughputMode</code> parameter.</p>
    /// <p>After the file system is fully created, Amazon EFS sets its lifecycle state to <code>available</code>, at which point you can create one or more mount targets for the file system in your VPC. For more information, see <code>CreateMountTarget</code>. You mount your Amazon EFS file system on an EC2 instances in your VPC by using the mount target. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html">Amazon EFS: How it Works</a>. </p>
    /// <p> This operation requires permissions for the <code>elasticfilesystem:CreateFileSystem</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFileSystem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_file_system_input::Builder,
    }
    impl CreateFileSystem {
        /// Creates a new `CreateFileSystem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFileSystemOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFileSystemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.</p>
        pub fn creation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creation_token(input.into());
            self
        }
        /// <p>A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.</p>
        pub fn set_creation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creation_token(input);
            self
        }
        /// <p>The performance mode of the file system. We recommend <code>generalPurpose</code> performance mode for most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed after the file system has been created.</p> <note>
        /// <p>The <code>maxIO</code> mode is not supported on file systems using One Zone storage classes.</p>
        /// </note>
        pub fn performance_mode(mut self, input: crate::model::PerformanceMode) -> Self {
            self.inner = self.inner.performance_mode(input);
            self
        }
        /// <p>The performance mode of the file system. We recommend <code>generalPurpose</code> performance mode for most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed after the file system has been created.</p> <note>
        /// <p>The <code>maxIO</code> mode is not supported on file systems using One Zone storage classes.</p>
        /// </note>
        pub fn set_performance_mode(
            mut self,
            input: std::option::Option<crate::model::PerformanceMode>,
        ) -> Self {
            self.inner = self.inner.set_performance_mode(input);
            self
        }
        /// <p>A Boolean value that, if true, creates an encrypted file system. When creating an encrypted file system, you have the option of specifying an existing Key Management Service key (KMS key). If you don't specify a KMS key, then the default KMS key for Amazon EFS, <code>/aws/elasticfilesystem</code>, is used to protect the encrypted file system. </p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.inner = self.inner.encrypted(input);
            self
        }
        /// <p>A Boolean value that, if true, creates an encrypted file system. When creating an encrypted file system, you have the option of specifying an existing Key Management Service key (KMS key). If you don't specify a KMS key, then the default KMS key for Amazon EFS, <code>/aws/elasticfilesystem</code>, is used to protect the encrypted file system. </p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_encrypted(input);
            self
        }
        /// <p>The ID of the KMS key that you want to use to protect the encrypted file system. This parameter is only required if you want to use a non-default KMS key. If this parameter is not specified, the default KMS key for Amazon EFS is used. You can specify a KMS key ID using the following formats:</p>
        /// <ul>
        /// <li> <p>Key ID - A unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p> </li>
        /// <li> <p>ARN - An Amazon Resource Name (ARN) for the key, for example <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p> </li>
        /// <li> <p>Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code>.</p> </li>
        /// <li> <p>Key alias ARN - An ARN for a key alias, for example <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.</p> </li>
        /// </ul>
        /// <p>If you use <code>KmsKeyId</code>, you must set the <code>CreateFileSystemRequest$Encrypted</code> parameter to true.</p> <important>
        /// <p>EFS accepts only symmetric KMS keys. You cannot use asymmetric KMS keys with Amazon EFS file systems.</p>
        /// </important>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The ID of the KMS key that you want to use to protect the encrypted file system. This parameter is only required if you want to use a non-default KMS key. If this parameter is not specified, the default KMS key for Amazon EFS is used. You can specify a KMS key ID using the following formats:</p>
        /// <ul>
        /// <li> <p>Key ID - A unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p> </li>
        /// <li> <p>ARN - An Amazon Resource Name (ARN) for the key, for example <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p> </li>
        /// <li> <p>Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code>.</p> </li>
        /// <li> <p>Key alias ARN - An ARN for a key alias, for example <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.</p> </li>
        /// </ul>
        /// <p>If you use <code>KmsKeyId</code>, you must set the <code>CreateFileSystemRequest$Encrypted</code> parameter to true.</p> <important>
        /// <p>EFS accepts only symmetric KMS keys. You cannot use asymmetric KMS keys with Amazon EFS file systems.</p>
        /// </important>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>Specifies the throughput mode for the file system, either <code>bursting</code> or <code>provisioned</code>. If you set <code>ThroughputMode</code> to <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughputInMibps</code>. After you create the file system, you can decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes, as long as it’s been more than 24 hours since the last decrease or throughput mode change. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying throughput with provisioned mode</a> in the <i>Amazon EFS User Guide</i>. </p>
        /// <p>Default is <code>bursting</code>.</p>
        pub fn throughput_mode(mut self, input: crate::model::ThroughputMode) -> Self {
            self.inner = self.inner.throughput_mode(input);
            self
        }
        /// <p>Specifies the throughput mode for the file system, either <code>bursting</code> or <code>provisioned</code>. If you set <code>ThroughputMode</code> to <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughputInMibps</code>. After you create the file system, you can decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes, as long as it’s been more than 24 hours since the last decrease or throughput mode change. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying throughput with provisioned mode</a> in the <i>Amazon EFS User Guide</i>. </p>
        /// <p>Default is <code>bursting</code>.</p>
        pub fn set_throughput_mode(
            mut self,
            input: std::option::Option<crate::model::ThroughputMode>,
        ) -> Self {
            self.inner = self.inner.set_throughput_mode(input);
            self
        }
        /// <p>The throughput, measured in MiB/s, that you want to provision for a file system that you're creating. Valid values are 1-1024. Required if <code>ThroughputMode</code> is set to <code>provisioned</code>. The upper limit for throughput is 1024 MiB/s. To increase this limit, contact Amazon Web Services Support. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS quotas that you can increase</a> in the <i>Amazon EFS User Guide</i>.</p>
        pub fn provisioned_throughput_in_mibps(mut self, input: f64) -> Self {
            self.inner = self.inner.provisioned_throughput_in_mibps(input);
            self
        }
        /// <p>The throughput, measured in MiB/s, that you want to provision for a file system that you're creating. Valid values are 1-1024. Required if <code>ThroughputMode</code> is set to <code>provisioned</code>. The upper limit for throughput is 1024 MiB/s. To increase this limit, contact Amazon Web Services Support. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS quotas that you can increase</a> in the <i>Amazon EFS User Guide</i>.</p>
        pub fn set_provisioned_throughput_in_mibps(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_throughput_in_mibps(input);
            self
        }
        /// <p>Used to create a file system that uses One Zone storage classes. It specifies the Amazon Web Services Availability Zone in which to create the file system. Use the format <code>us-east-1a</code> to specify the Availability Zone. For more information about One Zone storage classes, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p> <note>
        /// <p>One Zone storage classes are not available in all Availability Zones in Amazon Web Services Regions where Amazon EFS is available.</p>
        /// </note>
        pub fn availability_zone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone_name(input.into());
            self
        }
        /// <p>Used to create a file system that uses One Zone storage classes. It specifies the Amazon Web Services Availability Zone in which to create the file system. Use the format <code>us-east-1a</code> to specify the Availability Zone. For more information about One Zone storage classes, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p> <note>
        /// <p>One Zone storage classes are not available in all Availability Zones in Amazon Web Services Regions where Amazon EFS is available.</p>
        /// </note>
        pub fn set_availability_zone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone_name(input);
            self
        }
        /// <p>Specifies whether automatic backups are enabled on the file system that you are creating. Set the value to <code>true</code> to enable automatic backups. If you are creating a file system that uses One Zone storage classes, automatic backups are enabled by default. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups">Automatic backups</a> in the <i>Amazon EFS User Guide</i>.</p>
        /// <p>Default is <code>false</code>. However, if you specify an <code>AvailabilityZoneName</code>, the default is <code>true</code>.</p> <note>
        /// <p>Backup is not available in all Amazon Web Services Regions where Amazon EFS is available.</p>
        /// </note>
        pub fn backup(mut self, input: bool) -> Self {
            self.inner = self.inner.backup(input);
            self
        }
        /// <p>Specifies whether automatic backups are enabled on the file system that you are creating. Set the value to <code>true</code> to enable automatic backups. If you are creating a file system that uses One Zone storage classes, automatic backups are enabled by default. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups">Automatic backups</a> in the <i>Amazon EFS User Guide</i>.</p>
        /// <p>Default is <code>false</code>. However, if you specify an <code>AvailabilityZoneName</code>, the default is <code>true</code>.</p> <note>
        /// <p>Backup is not available in all Amazon Web Services Regions where Amazon EFS is available.</p>
        /// </note>
        pub fn set_backup(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_backup(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Use to create one or more tags associated with the file system. Each tag is a user-defined key-value pair. Name your file system on creation by including a <code>"Key":"Name","Value":"{value}"</code> key-value pair. Each key must be unique. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Use to create one or more tags associated with the file system. Each tag is a user-defined key-value pair. Name your file system on creation by including a <code>"Key":"Name","Value":"{value}"</code> key-value pair. Each key must be unique. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMountTarget`.
    ///
    /// <p>Creates a mount target for a file system. You can then mount the file system on EC2 instances by using the mount target.</p>
    /// <p>You can create one mount target in each Availability Zone in your VPC. All EC2 instances in a VPC within a given Availability Zone share a single mount target for a given file system. If you have multiple subnets in an Availability Zone, you create a mount target in one of the subnets. EC2 instances do not need to be in the same subnet as the mount target in order to access their file system.</p>
    /// <p>You can create only one mount target for an EFS file system using One Zone storage classes. You must create that mount target in the same Availability Zone in which the file system is located. Use the <code>AvailabilityZoneName</code> and <code>AvailabiltyZoneId</code> properties in the <code>DescribeFileSystems</code> response object to get this information. Use the <code>subnetId</code> associated with the file system's Availability Zone when creating the mount target.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html">Amazon EFS: How it Works</a>. </p>
    /// <p>To create a mount target for a file system, the file system's lifecycle state must be <code>available</code>. For more information, see <code>DescribeFileSystems</code>.</p>
    /// <p>In the request, provide the following:</p>
    /// <ul>
    /// <li> <p>The file system ID for which you are creating the mount target.</p> </li>
    /// <li> <p>A subnet ID, which determines the following:</p>
    /// <ul>
    /// <li> <p>The VPC in which Amazon EFS creates the mount target</p> </li>
    /// <li> <p>The Availability Zone in which Amazon EFS creates the mount target</p> </li>
    /// <li> <p>The IP address range from which Amazon EFS selects the IP address of the mount target (if you don't specify an IP address in the request)</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>After creating the mount target, Amazon EFS returns a response that includes, a <code>MountTargetId</code> and an <code>IpAddress</code>. You use this IP address when mounting the file system in an EC2 instance. You can also use the mount target's DNS name when mounting the file system. The EC2 instance on which you mount the file system by using the mount target can resolve the mount target's DNS name to its IP address. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html#how-it-works-implementation">How it Works: Implementation Overview</a>. </p>
    /// <p>Note that you can create mount targets for a file system in only one VPC, and there can be only one mount target per Availability Zone. That is, if the file system already has one or more mount targets created for it, the subnet specified in the request to add another mount target must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>Must belong to the same VPC as the subnets of the existing mount targets</p> </li>
    /// <li> <p>Must not be in the same Availability Zone as any of the subnets of the existing mount targets</p> </li>
    /// </ul>
    /// <p>If the request satisfies the requirements, Amazon EFS does the following:</p>
    /// <ul>
    /// <li> <p>Creates a new mount target in the specified subnet.</p> </li>
    /// <li> <p>Also creates a new network interface in the subnet as follows:</p>
    /// <ul>
    /// <li> <p>If the request provides an <code>IpAddress</code>, Amazon EFS assigns that IP address to the network interface. Otherwise, Amazon EFS assigns a free address in the subnet (in the same way that the Amazon EC2 <code>CreateNetworkInterface</code> call does when a request does not specify a primary private IP address).</p> </li>
    /// <li> <p>If the request provides <code>SecurityGroups</code>, this network interface is associated with those security groups. Otherwise, it belongs to the default security group for the subnet's VPC.</p> </li>
    /// <li> <p>Assigns the description <code>Mount target <i>fsmt-id</i> for file system <i>fs-id</i> </code> where <code> <i>fsmt-id</i> </code> is the mount target ID, and <code> <i>fs-id</i> </code> is the <code>FileSystemId</code>.</p> </li>
    /// <li> <p>Sets the <code>requesterManaged</code> property of the network interface to <code>true</code>, and the <code>requesterId</code> value to <code>EFS</code>.</p> </li>
    /// </ul> <p>Each Amazon EFS mount target has one corresponding requester-managed EC2 network interface. After the network interface is created, Amazon EFS sets the <code>NetworkInterfaceId</code> field in the mount target's description to the network interface ID, and the <code>IpAddress</code> field to its address. If network interface creation fails, the entire <code>CreateMountTarget</code> operation fails.</p> </li>
    /// </ul> <note>
    /// <p>The <code>CreateMountTarget</code> call returns only after creating the network interface, but while the mount target state is still <code>creating</code>, you can check the mount target creation status by calling the <code>DescribeMountTargets</code> operation, which among other things returns the mount target state.</p>
    /// </note>
    /// <p>We recommend that you create a mount target in each of the Availability Zones. There are cost considerations for using a file system in an Availability Zone through a mount target created in another Availability Zone. For more information, see <a href="http://aws.amazon.com/efs/">Amazon EFS</a>. In addition, by always using a mount target local to the instance's Availability Zone, you eliminate a partial failure scenario. If the Availability Zone in which your mount target is created goes down, then you can't access your file system through that mount target. </p>
    /// <p>This operation requires permissions for the following action on the file system:</p>
    /// <ul>
    /// <li> <p> <code>elasticfilesystem:CreateMountTarget</code> </p> </li>
    /// </ul>
    /// <p>This operation also requires permissions for the following Amazon EC2 actions:</p>
    /// <ul>
    /// <li> <p> <code>ec2:DescribeSubnets</code> </p> </li>
    /// <li> <p> <code>ec2:DescribeNetworkInterfaces</code> </p> </li>
    /// <li> <p> <code>ec2:CreateNetworkInterface</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMountTarget {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_mount_target_input::Builder,
    }
    impl CreateMountTarget {
        /// Creates a new `CreateMountTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMountTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMountTargetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the file system for which to create the mount target.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>The ID of the file system for which to create the mount target.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>The ID of the subnet to add the mount target in. For file systems that use One Zone storage classes, use the subnet that is associated with the file system's Availability Zone.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(input.into());
            self
        }
        /// <p>The ID of the subnet to add the mount target in. For file systems that use One Zone storage classes, use the subnet that is associated with the file system's Availability Zone.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// <p>Valid IPv4 address within the address range of the specified subnet.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_address(input.into());
            self
        }
        /// <p>Valid IPv4 address within the address range of the specified subnet.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_address(input);
            self
        }
        /// Appends an item to `SecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>Up to five VPC security group IDs, of the form <code>sg-xxxxxxxx</code>. These must be for the same VPC as subnet specified.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_groups(input.into());
            self
        }
        /// <p>Up to five VPC security group IDs, of the form <code>sg-xxxxxxxx</code>. These must be for the same VPC as subnet specified.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReplicationConfiguration`.
    ///
    /// <p>Creates a replication configuration that replicates an existing EFS file system to a new, read-only file system. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-replication.html">Amazon EFS replication</a>. The replication configuration specifies the following:</p>
    /// <ul>
    /// <li> <p> <b>Source file system</b> - an existing EFS file system that you want replicated. The source file system cannot be a destination file system in an existing replication configuration.</p> </li>
    /// <li> <p> <b>Destination file system configuration</b> - the configuration of the destination file system to which the source file system will be replicated. There can only be one destination file system in a replication configuration.</p>
    /// <ul>
    /// <li> <p> <b>Amazon Web Services Region</b> - The Amazon Web Services Region in which the destination file system is created. EFS Replication is available in all Amazon Web Services Region that Amazon EFS is available in, except the following regions: Asia Pacific (Hong Kong) Europe (Milan), Middle East (Bahrain), Africa (Cape Town), and Asia Pacific (Jakarta).</p> </li>
    /// <li> <p> <b>Availability zone</b> - If you want the destination file system to use One Zone availability and durability, you must specify the Availability Zone to create the file system in. For more information about EFS storage classes, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html"> Amazon EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p> </li>
    /// <li> <p> <b>Encryption</b> - All destination file systems are created with encryption at rest enabled. You can specify the KMS key that is used to encrypt the destination file system. Your service-managed KMS key for Amazon EFS is used if you don't specify a KMS key. You cannot change this after the file system is created.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>The following properties are set by default:</p>
    /// <ul>
    /// <li> <p> <b>Performance mode</b> - The destination file system's performance mode will match that of the source file system, unless the destination file system uses One Zone storage. In that case, the <i>General Purpose</i> performance mode is used. The Performance mode cannot be changed.</p> </li>
    /// <li> <p> <b>Throughput mode</b> - The destination file system use the Bursting throughput mode by default. You can modify the throughput mode once the file system is created.</p> </li>
    /// </ul>
    /// <p>The following properties are turned off by default:</p>
    /// <ul>
    /// <li> <p> <b>Lifecycle management</b> - EFS lifecycle management and intelligent tiering are not enabled on the destination file system. You can enable EFS lifecycle management and intelligent tiering after the destination file system is created.</p> </li>
    /// <li> <p> <b>Automatic backups</b> - Automatic daily backups not enabled on the destination file system. You can change this setting after the file system is created.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-replication.html">Amazon EFS replication</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReplicationConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_replication_configuration_input::Builder,
    }
    impl CreateReplicationConfiguration {
        /// Creates a new `CreateReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReplicationConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the Amazon EFS file system that you want to replicate. This file system cannot already be a source or destination file system in another replication configuration.</p>
        pub fn source_file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_file_system_id(input.into());
            self
        }
        /// <p>Specifies the Amazon EFS file system that you want to replicate. This file system cannot already be a source or destination file system in another replication configuration.</p>
        pub fn set_source_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_file_system_id(input);
            self
        }
        /// Appends an item to `Destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// <p>An array of destination configuration objects. Only one destination configuration object is supported.</p>
        pub fn destinations(mut self, input: crate::model::DestinationToCreate) -> Self {
            self.inner = self.inner.destinations(input);
            self
        }
        /// <p>An array of destination configuration objects. Only one destination configuration object is supported.</p>
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DestinationToCreate>>,
        ) -> Self {
            self.inner = self.inner.set_destinations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTags`.
    ///
    /// <note>
    /// <p>DEPRECATED - CreateTags is deprecated and not maintained. Please use the API action to create tags for EFS resources.</p>
    /// </note>
    /// <p>Creates or overwrites tags associated with a file system. Each tag is a key-value pair. If a tag key specified in the request already exists on the file system, this operation overwrites its value with the value provided in the request. If you add the <code>Name</code> tag to your file system, Amazon EFS returns it in the response to the <code>DescribeFileSystems</code> operation. </p>
    /// <p>This operation requires permission for the <code>elasticfilesystem:CreateTags</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_tags_input::Builder,
    }
    impl CreateTags {
        /// Creates a new `CreateTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the file system whose tags you want to modify (String). This operation modifies the tags only, not the file system.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>The ID of the file system whose tags you want to modify (String). This operation modifies the tags only, not the file system.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value pair. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value pair. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccessPoint`.
    ///
    /// <p>Deletes the specified access point. After deletion is complete, new clients can no longer connect to the access points. Clients connected to the access point at the time of deletion will continue to function until they terminate their connection.</p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:DeleteAccessPoint</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAccessPoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_access_point_input::Builder,
    }
    impl DeleteAccessPoint {
        /// Creates a new `DeleteAccessPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccessPointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccessPointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the access point that you want to delete.</p>
        pub fn access_point_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_point_id(input.into());
            self
        }
        /// <p>The ID of the access point that you want to delete.</p>
        pub fn set_access_point_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_point_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFileSystem`.
    ///
    /// <p>Deletes a file system, permanently severing access to its contents. Upon return, the file system no longer exists and you can't access any contents of the deleted file system.</p>
    /// <p> You can't delete a file system that is in use. That is, if the file system has any mount targets, you must first delete them. For more information, see <code>DescribeMountTargets</code> and <code>DeleteMountTarget</code>. </p> <note>
    /// <p>The <code>DeleteFileSystem</code> call returns while the file system state is still <code>deleting</code>. You can check the file system deletion status by calling the <code>DescribeFileSystems</code> operation, which returns a list of file systems in your account. If you pass file system ID or creation token for the deleted file system, the <code>DescribeFileSystems</code> returns a <code>404 FileSystemNotFound</code> error.</p>
    /// </note>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:DeleteFileSystem</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFileSystem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_file_system_input::Builder,
    }
    impl DeleteFileSystem {
        /// Creates a new `DeleteFileSystem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFileSystemOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFileSystemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the file system you want to delete.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>The ID of the file system you want to delete.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFileSystemPolicy`.
    ///
    /// <p>Deletes the <code>FileSystemPolicy</code> for the specified file system. The default <code>FileSystemPolicy</code> goes into effect once the existing policy is deleted. For more information about the default file system policy, see <a href="https://docs.aws.amazon.com/efs/latest/ug/res-based-policies-efs.html">Using Resource-based Policies with EFS</a>.</p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:DeleteFileSystemPolicy</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFileSystemPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_file_system_policy_input::Builder,
    }
    impl DeleteFileSystemPolicy {
        /// Creates a new `DeleteFileSystemPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFileSystemPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFileSystemPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the EFS file system for which to delete the <code>FileSystemPolicy</code>.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>Specifies the EFS file system for which to delete the <code>FileSystemPolicy</code>.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMountTarget`.
    ///
    /// <p>Deletes the specified mount target.</p>
    /// <p>This operation forcibly breaks any mounts of the file system by using the mount target that is being deleted, which might disrupt instances or applications using those mounts. To avoid applications getting cut off abruptly, you might consider unmounting any mounts of the mount target, if feasible. The operation also deletes the associated network interface. Uncommitted writes might be lost, but breaking a mount target using this operation does not corrupt the file system itself. The file system you created remains. You can mount an EC2 instance in your VPC by using another mount target.</p>
    /// <p>This operation requires permissions for the following action on the file system:</p>
    /// <ul>
    /// <li> <p> <code>elasticfilesystem:DeleteMountTarget</code> </p> </li>
    /// </ul> <note>
    /// <p>The <code>DeleteMountTarget</code> call returns while the mount target state is still <code>deleting</code>. You can check the mount target deletion by calling the <code>DescribeMountTargets</code> operation, which returns a list of mount target descriptions for the given file system. </p>
    /// </note>
    /// <p>The operation also requires permissions for the following Amazon EC2 action on the mount target's network interface:</p>
    /// <ul>
    /// <li> <p> <code>ec2:DeleteNetworkInterface</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMountTarget {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_mount_target_input::Builder,
    }
    impl DeleteMountTarget {
        /// Creates a new `DeleteMountTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMountTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMountTargetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the mount target to delete (String).</p>
        pub fn mount_target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mount_target_id(input.into());
            self
        }
        /// <p>The ID of the mount target to delete (String).</p>
        pub fn set_mount_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mount_target_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReplicationConfiguration`.
    ///
    /// <p>Deletes an existing replication configuration. To delete a replication configuration, you must make the request from the Amazon Web Services Region in which the destination file system is located. Deleting a replication configuration ends the replication process. You can write to the destination file system once it's status becomes <code>Writeable</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReplicationConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_replication_configuration_input::Builder,
    }
    impl DeleteReplicationConfiguration {
        /// Creates a new `DeleteReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReplicationConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the source file system in the replication configuration.</p>
        pub fn source_file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_file_system_id(input.into());
            self
        }
        /// <p>The ID of the source file system in the replication configuration.</p>
        pub fn set_source_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_file_system_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTags`.
    ///
    /// <note>
    /// <p>DEPRECATED - DeleteTags is deprecated and not maintained. Please use the API action to remove tags from EFS resources.</p>
    /// </note>
    /// <p>Deletes the specified tags from a file system. If the <code>DeleteTags</code> request includes a tag key that doesn't exist, Amazon EFS ignores it and doesn't cause an error. For more information about tags and related restrictions, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Tag restrictions</a> in the <i>Billing and Cost Management User Guide</i>.</p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:DeleteTags</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_tags_input::Builder,
    }
    impl DeleteTags {
        /// Creates a new `DeleteTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the file system whose tags you want to delete (String).</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>The ID of the file system whose tags you want to delete (String).</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to delete.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of tag keys to delete.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccessPoints`.
    ///
    /// <p>Returns the description of a specific Amazon EFS access point if the <code>AccessPointId</code> is provided. If you provide an EFS <code>FileSystemId</code>, it returns descriptions of all access points for that file system. You can provide either an <code>AccessPointId</code> or a <code>FileSystemId</code> in the request, but not both. </p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:DescribeAccessPoints</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccessPoints {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_access_points_input::Builder,
    }
    impl DescribeAccessPoints {
        /// Creates a new `DescribeAccessPoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccessPointsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccessPointsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeAccessPointsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeAccessPointsPaginator {
            crate::paginator::DescribeAccessPointsPaginator::new(self.handle, self.inner)
        }
        /// <p>(Optional) When retrieving all access points for a file system, you can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response. The default value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>(Optional) When retrieving all access points for a file system, you can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> <code>NextToken</code> is present if the response is paginated. You can use <code>NextMarker</code> in the subsequent request to fetch the next page of access point descriptions.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> <code>NextToken</code> is present if the response is paginated. You can use <code>NextMarker</code> in the subsequent request to fetch the next page of access point descriptions.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>(Optional) Specifies an EFS access point to describe in the response; mutually exclusive with <code>FileSystemId</code>.</p>
        pub fn access_point_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_point_id(input.into());
            self
        }
        /// <p>(Optional) Specifies an EFS access point to describe in the response; mutually exclusive with <code>FileSystemId</code>.</p>
        pub fn set_access_point_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_point_id(input);
            self
        }
        /// <p>(Optional) If you provide a <code>FileSystemId</code>, EFS returns all access points for that file system; mutually exclusive with <code>AccessPointId</code>.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>(Optional) If you provide a <code>FileSystemId</code>, EFS returns all access points for that file system; mutually exclusive with <code>AccessPointId</code>.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountPreferences`.
    ///
    /// <p>Returns the account preferences settings for the Amazon Web Services account associated with the user making the request, in the current Amazon Web Services Region. For more information, see <a href="efs/latest/ug/manage-efs-resource-ids.html">Managing Amazon EFS resource IDs</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountPreferences {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_account_preferences_input::Builder,
    }
    impl DescribeAccountPreferences {
        /// Creates a new `DescribeAccountPreferences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountPreferencesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountPreferencesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) You can use <code>NextToken</code> in a subsequent request to fetch the next page of Amazon Web Services account preferences if the response payload was paginated.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>(Optional) You can use <code>NextToken</code> in a subsequent request to fetch the next page of Amazon Web Services account preferences if the response payload was paginated.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>(Optional) When retrieving account preferences, you can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response. The default value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>(Optional) When retrieving account preferences, you can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBackupPolicy`.
    ///
    /// <p>Returns the backup policy for the specified EFS file system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBackupPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_backup_policy_input::Builder,
    }
    impl DescribeBackupPolicy {
        /// Creates a new `DescribeBackupPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBackupPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBackupPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies which EFS file system to retrieve the <code>BackupPolicy</code> for.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>Specifies which EFS file system to retrieve the <code>BackupPolicy</code> for.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFileSystemPolicy`.
    ///
    /// <p>Returns the <code>FileSystemPolicy</code> for the specified EFS file system.</p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:DescribeFileSystemPolicy</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFileSystemPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_file_system_policy_input::Builder,
    }
    impl DescribeFileSystemPolicy {
        /// Creates a new `DescribeFileSystemPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFileSystemPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFileSystemPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies which EFS file system to retrieve the <code>FileSystemPolicy</code> for.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>Specifies which EFS file system to retrieve the <code>FileSystemPolicy</code> for.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFileSystems`.
    ///
    /// <p>Returns the description of a specific Amazon EFS file system if either the file system <code>CreationToken</code> or the <code>FileSystemId</code> is provided. Otherwise, it returns descriptions of all file systems owned by the caller's Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.</p>
    /// <p>When retrieving all file system descriptions, you can optionally specify the <code>MaxItems</code> parameter to limit the number of descriptions in a response. Currently, this number is automatically set to 10. If more file system descriptions remain, Amazon EFS returns a <code>NextMarker</code>, an opaque token, in the response. In this case, you should send a subsequent request with the <code>Marker</code> request parameter set to the value of <code>NextMarker</code>. </p>
    /// <p>To retrieve a list of your file system descriptions, this operation is used in an iterative process, where <code>DescribeFileSystems</code> is called first without the <code>Marker</code> and then the operation continues to call it with the <code>Marker</code> parameter set to the value of the <code>NextMarker</code> from the previous response until the response has no <code>NextMarker</code>. </p>
    /// <p> The order of file systems returned in the response of one <code>DescribeFileSystems</code> call and the order of file systems returned across the responses of a multi-call iteration is unspecified. </p>
    /// <p> This operation requires permissions for the <code>elasticfilesystem:DescribeFileSystems</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFileSystems {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_file_systems_input::Builder,
    }
    impl DescribeFileSystems {
        /// Creates a new `DescribeFileSystems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFileSystemsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFileSystemsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeFileSystemsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeFileSystemsPaginator {
            crate::paginator::DescribeFileSystemsPaginator::new(self.handle, self.inner)
        }
        /// <p>(Optional) Specifies the maximum number of file systems to return in the response (integer). This number is automatically set to 100. The response is paginated at 100 per page if you have more than 100 file systems. </p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>(Optional) Specifies the maximum number of file systems to return in the response (integer). This number is automatically set to 100. The response is paginated at 100 per page if you have more than 100 file systems. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation (String). If present, specifies to continue the list from where the returning call had left off. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation (String). If present, specifies to continue the list from where the returning call had left off. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>(Optional) Restricts the list to the file system with this creation token (String). You specify a creation token when you create an Amazon EFS file system.</p>
        pub fn creation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creation_token(input.into());
            self
        }
        /// <p>(Optional) Restricts the list to the file system with this creation token (String). You specify a creation token when you create an Amazon EFS file system.</p>
        pub fn set_creation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creation_token(input);
            self
        }
        /// <p>(Optional) ID of the file system whose description you want to retrieve (String).</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>(Optional) ID of the file system whose description you want to retrieve (String).</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLifecycleConfiguration`.
    ///
    /// <p>Returns the current <code>LifecycleConfiguration</code> object for the specified Amazon EFS file system. EFS lifecycle management uses the <code>LifecycleConfiguration</code> object to identify which files to move to the EFS Infrequent Access (IA) storage class. For a file system without a <code>LifecycleConfiguration</code> object, the call returns an empty array in the response.</p>
    /// <p>When EFS Intelligent Tiering is enabled, <code>TransitionToPrimaryStorageClass</code> has a value of <code>AFTER_1_ACCESS</code>.</p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:DescribeLifecycleConfiguration</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLifecycleConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_lifecycle_configuration_input::Builder,
    }
    impl DescribeLifecycleConfiguration {
        /// Creates a new `DescribeLifecycleConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLifecycleConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLifecycleConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the file system whose <code>LifecycleConfiguration</code> object you want to retrieve (String).</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>The ID of the file system whose <code>LifecycleConfiguration</code> object you want to retrieve (String).</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMountTargets`.
    ///
    /// <p>Returns the descriptions of all the current mount targets, or a specific mount target, for a file system. When requesting all of the current mount targets, the order of mount targets returned in the response is unspecified.</p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:DescribeMountTargets</code> action, on either the file system ID that you specify in <code>FileSystemId</code>, or on the file system of the mount target that you specify in <code>MountTargetId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMountTargets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_mount_targets_input::Builder,
    }
    impl DescribeMountTargets {
        /// Creates a new `DescribeMountTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMountTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMountTargetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) Maximum number of mount targets to return in the response. Currently, this number is automatically set to 10, and other values are ignored. The response is paginated at 100 per page if you have more than 100 mount targets.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>(Optional) Maximum number of mount targets to return in the response. Currently, this number is automatically set to 10, and other values are ignored. The response is paginated at 100 per page if you have more than 100 mount targets.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous <code>DescribeMountTargets</code> operation (String). If present, it specifies to continue the list from where the previous returning call left off.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous <code>DescribeMountTargets</code> operation (String). If present, it specifies to continue the list from where the previous returning call left off.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>(Optional) ID of the file system whose mount targets you want to list (String). It must be included in your request if an <code>AccessPointId</code> or <code>MountTargetId</code> is not included. Accepts either a file system ID or ARN as input.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>(Optional) ID of the file system whose mount targets you want to list (String). It must be included in your request if an <code>AccessPointId</code> or <code>MountTargetId</code> is not included. Accepts either a file system ID or ARN as input.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>(Optional) ID of the mount target that you want to have described (String). It must be included in your request if <code>FileSystemId</code> is not included. Accepts either a mount target ID or ARN as input.</p>
        pub fn mount_target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mount_target_id(input.into());
            self
        }
        /// <p>(Optional) ID of the mount target that you want to have described (String). It must be included in your request if <code>FileSystemId</code> is not included. Accepts either a mount target ID or ARN as input.</p>
        pub fn set_mount_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mount_target_id(input);
            self
        }
        /// <p>(Optional) The ID of the access point whose mount targets that you want to list. It must be included in your request if a <code>FileSystemId</code> or <code>MountTargetId</code> is not included in your request. Accepts either an access point ID or ARN as input.</p>
        pub fn access_point_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_point_id(input.into());
            self
        }
        /// <p>(Optional) The ID of the access point whose mount targets that you want to list. It must be included in your request if a <code>FileSystemId</code> or <code>MountTargetId</code> is not included in your request. Accepts either an access point ID or ARN as input.</p>
        pub fn set_access_point_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_point_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMountTargetSecurityGroups`.
    ///
    /// <p>Returns the security groups currently in effect for a mount target. This operation requires that the network interface of the mount target has been created and the lifecycle state of the mount target is not <code>deleted</code>.</p>
    /// <p>This operation requires permissions for the following actions:</p>
    /// <ul>
    /// <li> <p> <code>elasticfilesystem:DescribeMountTargetSecurityGroups</code> action on the mount target's file system. </p> </li>
    /// <li> <p> <code>ec2:DescribeNetworkInterfaceAttribute</code> action on the mount target's network interface. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMountTargetSecurityGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_mount_target_security_groups_input::Builder,
    }
    impl DescribeMountTargetSecurityGroups {
        /// Creates a new `DescribeMountTargetSecurityGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMountTargetSecurityGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMountTargetSecurityGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the mount target whose security groups you want to retrieve.</p>
        pub fn mount_target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mount_target_id(input.into());
            self
        }
        /// <p>The ID of the mount target whose security groups you want to retrieve.</p>
        pub fn set_mount_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mount_target_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationConfigurations`.
    ///
    /// <p>Retrieves the replication configurations for either a specific file system, or all configurations for the Amazon Web Services account in an Amazon Web Services Region if a file system is not specified.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReplicationConfigurations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_replication_configurations_input::Builder,
    }
    impl DescribeReplicationConfigurations {
        /// Creates a new `DescribeReplicationConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReplicationConfigurationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>You can retrieve replication configurations for a specific file system by providing a file system ID.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>You can retrieve replication configurations for a specific file system by providing a file system ID.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p> <code>NextToken</code> is present if the response is paginated. You can use <code>NextMarker</code> in a subsequent request to fetch the next page of output.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> <code>NextToken</code> is present if the response is paginated. You can use <code>NextMarker</code> in a subsequent request to fetch the next page of output.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>(Optional) You can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response. The default value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>(Optional) You can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTags`.
    ///
    /// <note>
    /// <p>DEPRECATED - The DeleteTags action is deprecated and not maintained. Please use the API action to remove tags from EFS resources.</p>
    /// </note>
    /// <p>Returns the tags associated with a file system. The order of tags returned in the response of one <code>DescribeTags</code> call and the order of tags returned across the responses of a multiple-call iteration (when using pagination) is unspecified. </p>
    /// <p> This operation requires permissions for the <code>elasticfilesystem:DescribeTags</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_tags_input::Builder,
    }
    impl DescribeTags {
        /// Creates a new `DescribeTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeTagsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeTagsPaginator {
            crate::paginator::DescribeTagsPaginator::new(self.handle, self.inner)
        }
        /// <p>(Optional) The maximum number of file system tags to return in the response. Currently, this number is automatically set to 100, and other values are ignored. The response is paginated at 100 per page if you have more than 100 tags.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>(Optional) The maximum number of file system tags to return in the response. Currently, this number is automatically set to 100, and other values are ignored. The response is paginated at 100 per page if you have more than 100 tags.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>(Optional) An opaque pagination token returned from a previous <code>DescribeTags</code> operation (String). If present, it specifies to continue the list from where the previous call left off.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>(Optional) An opaque pagination token returned from a previous <code>DescribeTags</code> operation (String). If present, it specifies to continue the list from where the previous call left off.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The ID of the file system whose tag set you want to retrieve.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>The ID of the file system whose tag set you want to retrieve.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags for a top-level EFS resource. You must provide the ID of the resource that you want to retrieve the tags for.</p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:DescribeAccessPoints</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsForResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsForResourcePaginator {
            crate::paginator::ListTagsForResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies the EFS resource you want to retrieve tags for. You can retrieve tags for EFS file systems and access points using this API endpoint.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>Specifies the EFS resource you want to retrieve tags for. You can retrieve tags for EFS file systems and access points using this API endpoint.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>(Optional) Specifies the maximum number of tag objects to return in the response. The default value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>(Optional) Specifies the maximum number of tag objects to return in the response. The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>(Optional) You can use <code>NextToken</code> in a subsequent request to fetch the next page of access point descriptions if the response payload was paginated.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>(Optional) You can use <code>NextToken</code> in a subsequent request to fetch the next page of access point descriptions if the response payload was paginated.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyMountTargetSecurityGroups`.
    ///
    /// <p>Modifies the set of security groups in effect for a mount target.</p>
    /// <p>When you create a mount target, Amazon EFS also creates a new network interface. For more information, see <code>CreateMountTarget</code>. This operation replaces the security groups in effect for the network interface associated with a mount target, with the <code>SecurityGroups</code> provided in the request. This operation requires that the network interface of the mount target has been created and the lifecycle state of the mount target is not <code>deleted</code>. </p>
    /// <p>The operation requires permissions for the following actions:</p>
    /// <ul>
    /// <li> <p> <code>elasticfilesystem:ModifyMountTargetSecurityGroups</code> action on the mount target's file system. </p> </li>
    /// <li> <p> <code>ec2:ModifyNetworkInterfaceAttribute</code> action on the mount target's network interface. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyMountTargetSecurityGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_mount_target_security_groups_input::Builder,
    }
    impl ModifyMountTargetSecurityGroups {
        /// Creates a new `ModifyMountTargetSecurityGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyMountTargetSecurityGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyMountTargetSecurityGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the mount target whose security groups you want to modify.</p>
        pub fn mount_target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mount_target_id(input.into());
            self
        }
        /// <p>The ID of the mount target whose security groups you want to modify.</p>
        pub fn set_mount_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mount_target_id(input);
            self
        }
        /// Appends an item to `SecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>An array of up to five VPC security group IDs.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_groups(input.into());
            self
        }
        /// <p>An array of up to five VPC security group IDs.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccountPreferences`.
    ///
    /// <p>Use this operation to set the account preference in the current Amazon Web Services Region to use long 17 character (63 bit) or short 8 character (32 bit) resource IDs for new EFS file system and mount target resources. All existing resource IDs are not affected by any changes you make. You can set the ID preference during the opt-in period as EFS transitions to long resource IDs. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/manage-efs-resource-ids.html">Managing Amazon EFS resource IDs</a>.</p> <note>
    /// <p>Starting in October, 2021, you will receive an error if you try to set the account preference to use the short 8 character format resource ID. Contact Amazon Web Services support if you receive an error and need to use short IDs for file system and mount target resources.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAccountPreferences {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_account_preferences_input::Builder,
    }
    impl PutAccountPreferences {
        /// Creates a new `PutAccountPreferences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccountPreferencesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAccountPreferencesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the EFS resource ID preference to set for the user's Amazon Web Services account, in the current Amazon Web Services Region, either <code>LONG_ID</code> (17 characters), or <code>SHORT_ID</code> (8 characters).</p> <note>
        /// <p>Starting in October, 2021, you will receive an error when setting the account preference to <code>SHORT_ID</code>. Contact Amazon Web Services support if you receive an error and need to use short IDs for file system and mount target resources.</p>
        /// </note>
        pub fn resource_id_type(mut self, input: crate::model::ResourceIdType) -> Self {
            self.inner = self.inner.resource_id_type(input);
            self
        }
        /// <p>Specifies the EFS resource ID preference to set for the user's Amazon Web Services account, in the current Amazon Web Services Region, either <code>LONG_ID</code> (17 characters), or <code>SHORT_ID</code> (8 characters).</p> <note>
        /// <p>Starting in October, 2021, you will receive an error when setting the account preference to <code>SHORT_ID</code>. Contact Amazon Web Services support if you receive an error and need to use short IDs for file system and mount target resources.</p>
        /// </note>
        pub fn set_resource_id_type(
            mut self,
            input: std::option::Option<crate::model::ResourceIdType>,
        ) -> Self {
            self.inner = self.inner.set_resource_id_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBackupPolicy`.
    ///
    /// <p>Updates the file system's backup policy. Use this action to start or stop automatic backups of the file system. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBackupPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_backup_policy_input::Builder,
    }
    impl PutBackupPolicy {
        /// Creates a new `PutBackupPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBackupPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBackupPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies which EFS file system to update the backup policy for.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>Specifies which EFS file system to update the backup policy for.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>The backup policy included in the <code>PutBackupPolicy</code> request.</p>
        pub fn backup_policy(mut self, input: crate::model::BackupPolicy) -> Self {
            self.inner = self.inner.backup_policy(input);
            self
        }
        /// <p>The backup policy included in the <code>PutBackupPolicy</code> request.</p>
        pub fn set_backup_policy(
            mut self,
            input: std::option::Option<crate::model::BackupPolicy>,
        ) -> Self {
            self.inner = self.inner.set_backup_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutFileSystemPolicy`.
    ///
    /// <p>Applies an Amazon EFS <code>FileSystemPolicy</code> to an Amazon EFS file system. A file system policy is an IAM resource-based policy and can contain multiple policy statements. A file system always has exactly one file system policy, which can be the default policy or an explicit policy set or updated using this API operation. EFS file system policies have a 20,000 character limit. When an explicit policy is set, it overrides the default policy. For more information about the default file system policy, see <a href="https://docs.aws.amazon.com/efs/latest/ug/iam-access-control-nfs-efs.html#default-filesystempolicy">Default EFS File System Policy</a>. </p> <note>
    /// <p>EFS file system policies have a 20,000 character limit.</p>
    /// </note>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:PutFileSystemPolicy</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutFileSystemPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_file_system_policy_input::Builder,
    }
    impl PutFileSystemPolicy {
        /// Creates a new `PutFileSystemPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutFileSystemPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutFileSystemPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the EFS file system that you want to create or update the <code>FileSystemPolicy</code> for.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>The ID of the EFS file system that you want to create or update the <code>FileSystemPolicy</code> for.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>The <code>FileSystemPolicy</code> that you're creating. Accepts a JSON formatted policy definition. EFS file system policies have a 20,000 character limit. To find out more about the elements that make up a file system policy, see <a href="https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies">EFS Resource-based Policies</a>. </p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The <code>FileSystemPolicy</code> that you're creating. Accepts a JSON formatted policy definition. EFS file system policies have a 20,000 character limit. To find out more about the elements that make up a file system policy, see <a href="https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies">EFS Resource-based Policies</a>. </p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// <p>(Optional) A flag to indicate whether to bypass the <code>FileSystemPolicy</code> lockout safety check. The policy lockout safety check determines whether the policy in the request will prevent the principal making the request will be locked out from making future <code>PutFileSystemPolicy</code> requests on the file system. Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent the principal that is making the request from making a subsequent <code>PutFileSystemPolicy</code> request on the file system. The default value is False. </p>
        pub fn bypass_policy_lockout_safety_check(mut self, input: bool) -> Self {
            self.inner = self.inner.bypass_policy_lockout_safety_check(input);
            self
        }
        /// <p>(Optional) A flag to indicate whether to bypass the <code>FileSystemPolicy</code> lockout safety check. The policy lockout safety check determines whether the policy in the request will prevent the principal making the request will be locked out from making future <code>PutFileSystemPolicy</code> requests on the file system. Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent the principal that is making the request from making a subsequent <code>PutFileSystemPolicy</code> request on the file system. The default value is False. </p>
        pub fn set_bypass_policy_lockout_safety_check(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_bypass_policy_lockout_safety_check(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLifecycleConfiguration`.
    ///
    /// <p>Enables lifecycle management by creating a new <code>LifecycleConfiguration</code> object. A <code>LifecycleConfiguration</code> object defines when files in an Amazon EFS file system are automatically transitioned to the lower-cost EFS Infrequent Access (IA) storage class. To enable EFS Intelligent Tiering, set the value of <code>TransitionToPrimaryStorageClass</code> to <code>AFTER_1_ACCESS</code>. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/lifecycle-management-efs.html">EFS Lifecycle Management</a>.</p>
    /// <p>Each Amazon EFS file system supports one lifecycle configuration, which applies to all files in the file system. If a <code>LifecycleConfiguration</code> object already exists for the specified file system, a <code>PutLifecycleConfiguration</code> call modifies the existing configuration. A <code>PutLifecycleConfiguration</code> call with an empty <code>LifecyclePolicies</code> array in the request body deletes any existing <code>LifecycleConfiguration</code> and turns off lifecycle management for the file system.</p>
    /// <p>In the request, specify the following: </p>
    /// <ul>
    /// <li> <p>The ID for the file system for which you are enabling, disabling, or modifying lifecycle management.</p> </li>
    /// <li> <p>A <code>LifecyclePolicies</code> array of <code>LifecyclePolicy</code> objects that define when files are moved to the IA storage class. Amazon EFS requires that each <code>LifecyclePolicy</code> object have only have a single transition, so the <code>LifecyclePolicies</code> array needs to be structured with separate <code>LifecyclePolicy</code> objects. See the example requests in the following section for more information.</p> </li>
    /// </ul>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:PutLifecycleConfiguration</code> operation.</p>
    /// <p>To apply a <code>LifecycleConfiguration</code> object to an encrypted file system, you need the same Key Management Service permissions as when you created the encrypted file system. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutLifecycleConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_lifecycle_configuration_input::Builder,
    }
    impl PutLifecycleConfiguration {
        /// Creates a new `PutLifecycleConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLifecycleConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLifecycleConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the file system for which you are creating the <code>LifecycleConfiguration</code> object (String).</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>The ID of the file system for which you are creating the <code>LifecycleConfiguration</code> object (String).</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// Appends an item to `LifecyclePolicies`.
        ///
        /// To override the contents of this collection use [`set_lifecycle_policies`](Self::set_lifecycle_policies).
        ///
        /// <p>An array of <code>LifecyclePolicy</code> objects that define the file system's <code>LifecycleConfiguration</code> object. A <code>LifecycleConfiguration</code> object informs EFS lifecycle management and intelligent tiering of the following:</p>
        /// <ul>
        /// <li> <p>When to move files in the file system from primary storage to the IA storage class.</p> </li>
        /// <li> <p>When to move files that are in IA storage to primary storage.</p> </li>
        /// </ul> <note>
        /// <p>When using the <code>put-lifecycle-configuration</code> CLI command or the <code>PutLifecycleConfiguration</code> API action, Amazon EFS requires that each <code>LifecyclePolicy</code> object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code>, <code>TransitionToPrimaryStorageClass</code>. See the example requests in the following section for more information.</p>
        /// </note>
        pub fn lifecycle_policies(mut self, input: crate::model::LifecyclePolicy) -> Self {
            self.inner = self.inner.lifecycle_policies(input);
            self
        }
        /// <p>An array of <code>LifecyclePolicy</code> objects that define the file system's <code>LifecycleConfiguration</code> object. A <code>LifecycleConfiguration</code> object informs EFS lifecycle management and intelligent tiering of the following:</p>
        /// <ul>
        /// <li> <p>When to move files in the file system from primary storage to the IA storage class.</p> </li>
        /// <li> <p>When to move files that are in IA storage to primary storage.</p> </li>
        /// </ul> <note>
        /// <p>When using the <code>put-lifecycle-configuration</code> CLI command or the <code>PutLifecycleConfiguration</code> API action, Amazon EFS requires that each <code>LifecyclePolicy</code> object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code>, <code>TransitionToPrimaryStorageClass</code>. See the example requests in the following section for more information.</p>
        /// </note>
        pub fn set_lifecycle_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LifecyclePolicy>>,
        ) -> Self {
            self.inner = self.inner.set_lifecycle_policies(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Creates a tag for an EFS resource. You can create tags for EFS file systems and access points using this API operation.</p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:TagResource</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID specifying the EFS resource that you want to create a tag for.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID specifying the EFS resource that you want to create a tag for.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value pair.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from an EFS resource. You can remove tags from EFS file systems and access points using this API operation.</p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:UntagResource</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the EFS resource that you want to remove tags from.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>Specifies the EFS resource that you want to remove tags from.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the key-value tag pairs that you want to remove from the specified EFS resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of the key-value tag pairs that you want to remove from the specified EFS resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFileSystem`.
    ///
    /// <p>Updates the throughput mode or the amount of provisioned throughput of an existing file system.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFileSystem {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_file_system_input::Builder,
    }
    impl UpdateFileSystem {
        /// Creates a new `UpdateFileSystem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFileSystemOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFileSystemError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the file system that you want to update.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(input.into());
            self
        }
        /// <p>The ID of the file system that you want to update.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>(Optional) Updates the file system's throughput mode. If you're not updating your throughput mode, you don't need to provide this value in your request. If you are changing the <code>ThroughputMode</code> to <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughputInMibps</code>.</p>
        pub fn throughput_mode(mut self, input: crate::model::ThroughputMode) -> Self {
            self.inner = self.inner.throughput_mode(input);
            self
        }
        /// <p>(Optional) Updates the file system's throughput mode. If you're not updating your throughput mode, you don't need to provide this value in your request. If you are changing the <code>ThroughputMode</code> to <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughputInMibps</code>.</p>
        pub fn set_throughput_mode(
            mut self,
            input: std::option::Option<crate::model::ThroughputMode>,
        ) -> Self {
            self.inner = self.inner.set_throughput_mode(input);
            self
        }
        /// <p>(Optional) Sets the amount of provisioned throughput, in MiB/s, for the file system. Valid values are 1-1024. If you are changing the throughput mode to provisioned, you must also provide the amount of provisioned throughput. Required if <code>ThroughputMode</code> is changed to <code>provisioned</code> on update.</p>
        pub fn provisioned_throughput_in_mibps(mut self, input: f64) -> Self {
            self.inner = self.inner.provisioned_throughput_in_mibps(input);
            self
        }
        /// <p>(Optional) Sets the amount of provisioned throughput, in MiB/s, for the file system. Valid values are 1-1024. If you are changing the throughput mode to provisioned, you must also provide the amount of provisioned throughput. Required if <code>ThroughputMode</code> is changed to <code>provisioned</code> on update.</p>
        pub fn set_provisioned_throughput_in_mibps(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_throughput_in_mibps(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
