// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A description of the file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFileSystemOutput {
    /// <p>The Amazon Web Services account that created the file system. If the file system was created by an IAM user, the parent account to which the user belongs is the owner.</p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>The opaque string specified in the request.</p>
    pub creation_token: std::option::Option<std::string::String>,
    /// <p>The ID of the file system, assigned by Amazon EFS.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the EFS file system, in the format <code>arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i> </code>. Example with sample data: <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567</code> </p>
    pub file_system_arn: std::option::Option<std::string::String>,
    /// <p>The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The lifecycle phase of the file system.</p>
    pub life_cycle_state: std::option::Option<crate::model::LifeCycleState>,
    /// <p>You can add tags to a file system, including a <code>Name</code> tag. For more information, see <code>CreateFileSystem</code>. If the file system has a <code>Name</code> tag, Amazon EFS returns the value in this field. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current number of mount targets that the file system has. For more information, see <code>CreateMountTarget</code>.</p>
    pub number_of_mount_targets: i32,
    /// <p>The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code> field, and the time at which that size was determined in its <code>Timestamp</code> field. The <code>Timestamp</code> value is the integer number of seconds since 1970-01-01T00:00:00Z. The <code>SizeInBytes</code> value doesn't represent the size of a consistent snapshot of the file system, but it is eventually consistent when there are no writes to the file system. That is, <code>SizeInBytes</code> represents actual size only if the file system is not modified for a period longer than a couple of hours. Otherwise, the value is not the exact size that the file system was at any point in time. </p>
    pub size_in_bytes: std::option::Option<crate::model::FileSystemSize>,
    /// <p>The performance mode of the file system.</p>
    pub performance_mode: std::option::Option<crate::model::PerformanceMode>,
    /// <p>A Boolean value that, if true, indicates that the file system is encrypted.</p>
    pub encrypted: std::option::Option<bool>,
    /// <p>The ID of an KMS key used to protect the encrypted file system.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Displays the file system's throughput mode. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a> in the <i>Amazon EFS User Guide</i>. </p>
    pub throughput_mode: std::option::Option<crate::model::ThroughputMode>,
    /// <p>The amount of provisioned throughput, measured in MiB/s, for the file system. Valid for file systems using <code>ThroughputMode</code> set to <code>provisioned</code>.</p>
    pub provisioned_throughput_in_mibps: std::option::Option<f64>,
    /// <p>Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid only for file systems using One Zone storage classes. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p>
    pub availability_zone_name: std::option::Option<std::string::String>,
    /// <p>The unique and consistent identifier of the Availability Zone in which the file system's One Zone storage classes exist. For example, <code>use1-az1</code> is an Availability Zone ID for the us-east-1 Amazon Web Services Region, and it has the same location in every Amazon Web Services account.</p>
    pub availability_zone_id: std::option::Option<std::string::String>,
    /// <p>The tags associated with the file system, presented as an array of <code>Tag</code> objects.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl UpdateFileSystemOutput {
    /// <p>The Amazon Web Services account that created the file system. If the file system was created by an IAM user, the parent account to which the user belongs is the owner.</p>
    pub fn owner_id(&self) -> std::option::Option<&str> {
        self.owner_id.as_deref()
    }
    /// <p>The opaque string specified in the request.</p>
    pub fn creation_token(&self) -> std::option::Option<&str> {
        self.creation_token.as_deref()
    }
    /// <p>The ID of the file system, assigned by Amazon EFS.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the EFS file system, in the format <code>arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i> </code>. Example with sample data: <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567</code> </p>
    pub fn file_system_arn(&self) -> std::option::Option<&str> {
        self.file_system_arn.as_deref()
    }
    /// <p>The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The lifecycle phase of the file system.</p>
    pub fn life_cycle_state(&self) -> std::option::Option<&crate::model::LifeCycleState> {
        self.life_cycle_state.as_ref()
    }
    /// <p>You can add tags to a file system, including a <code>Name</code> tag. For more information, see <code>CreateFileSystem</code>. If the file system has a <code>Name</code> tag, Amazon EFS returns the value in this field. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current number of mount targets that the file system has. For more information, see <code>CreateMountTarget</code>.</p>
    pub fn number_of_mount_targets(&self) -> i32 {
        self.number_of_mount_targets
    }
    /// <p>The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code> field, and the time at which that size was determined in its <code>Timestamp</code> field. The <code>Timestamp</code> value is the integer number of seconds since 1970-01-01T00:00:00Z. The <code>SizeInBytes</code> value doesn't represent the size of a consistent snapshot of the file system, but it is eventually consistent when there are no writes to the file system. That is, <code>SizeInBytes</code> represents actual size only if the file system is not modified for a period longer than a couple of hours. Otherwise, the value is not the exact size that the file system was at any point in time. </p>
    pub fn size_in_bytes(&self) -> std::option::Option<&crate::model::FileSystemSize> {
        self.size_in_bytes.as_ref()
    }
    /// <p>The performance mode of the file system.</p>
    pub fn performance_mode(&self) -> std::option::Option<&crate::model::PerformanceMode> {
        self.performance_mode.as_ref()
    }
    /// <p>A Boolean value that, if true, indicates that the file system is encrypted.</p>
    pub fn encrypted(&self) -> std::option::Option<bool> {
        self.encrypted
    }
    /// <p>The ID of an KMS key used to protect the encrypted file system.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>Displays the file system's throughput mode. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a> in the <i>Amazon EFS User Guide</i>. </p>
    pub fn throughput_mode(&self) -> std::option::Option<&crate::model::ThroughputMode> {
        self.throughput_mode.as_ref()
    }
    /// <p>The amount of provisioned throughput, measured in MiB/s, for the file system. Valid for file systems using <code>ThroughputMode</code> set to <code>provisioned</code>.</p>
    pub fn provisioned_throughput_in_mibps(&self) -> std::option::Option<f64> {
        self.provisioned_throughput_in_mibps
    }
    /// <p>Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid only for file systems using One Zone storage classes. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p>
    pub fn availability_zone_name(&self) -> std::option::Option<&str> {
        self.availability_zone_name.as_deref()
    }
    /// <p>The unique and consistent identifier of the Availability Zone in which the file system's One Zone storage classes exist. For example, <code>use1-az1</code> is an Availability Zone ID for the us-east-1 Amazon Web Services Region, and it has the same location in every Amazon Web Services account.</p>
    pub fn availability_zone_id(&self) -> std::option::Option<&str> {
        self.availability_zone_id.as_deref()
    }
    /// <p>The tags associated with the file system, presented as an array of <code>Tag</code> objects.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for UpdateFileSystemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFileSystemOutput");
        formatter.field("owner_id", &self.owner_id);
        formatter.field("creation_token", &self.creation_token);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("file_system_arn", &self.file_system_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("life_cycle_state", &self.life_cycle_state);
        formatter.field("name", &self.name);
        formatter.field("number_of_mount_targets", &self.number_of_mount_targets);
        formatter.field("size_in_bytes", &self.size_in_bytes);
        formatter.field("performance_mode", &self.performance_mode);
        formatter.field("encrypted", &self.encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("throughput_mode", &self.throughput_mode);
        formatter.field(
            "provisioned_throughput_in_mibps",
            &self.provisioned_throughput_in_mibps,
        );
        formatter.field("availability_zone_name", &self.availability_zone_name);
        formatter.field("availability_zone_id", &self.availability_zone_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateFileSystemOutput`](crate::output::UpdateFileSystemOutput)
pub mod update_file_system_output {
    /// A builder for [`UpdateFileSystemOutput`](crate::output::UpdateFileSystemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) creation_token: std::option::Option<std::string::String>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) file_system_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) life_cycle_state: std::option::Option<crate::model::LifeCycleState>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) number_of_mount_targets: std::option::Option<i32>,
        pub(crate) size_in_bytes: std::option::Option<crate::model::FileSystemSize>,
        pub(crate) performance_mode: std::option::Option<crate::model::PerformanceMode>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) throughput_mode: std::option::Option<crate::model::ThroughputMode>,
        pub(crate) provisioned_throughput_in_mibps: std::option::Option<f64>,
        pub(crate) availability_zone_name: std::option::Option<std::string::String>,
        pub(crate) availability_zone_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account that created the file system. If the file system was created by an IAM user, the parent account to which the user belongs is the owner.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account that created the file system. If the file system was created by an IAM user, the parent account to which the user belongs is the owner.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>The opaque string specified in the request.</p>
        pub fn creation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_token = Some(input.into());
            self
        }
        /// <p>The opaque string specified in the request.</p>
        pub fn set_creation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_token = input;
            self
        }
        /// <p>The ID of the file system, assigned by Amazon EFS.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system, assigned by Amazon EFS.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the EFS file system, in the format <code>arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i> </code>. Example with sample data: <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567</code> </p>
        pub fn file_system_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the EFS file system, in the format <code>arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i> </code>. Example with sample data: <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567</code> </p>
        pub fn set_file_system_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_arn = input;
            self
        }
        /// <p>The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The lifecycle phase of the file system.</p>
        pub fn life_cycle_state(mut self, input: crate::model::LifeCycleState) -> Self {
            self.life_cycle_state = Some(input);
            self
        }
        /// <p>The lifecycle phase of the file system.</p>
        pub fn set_life_cycle_state(
            mut self,
            input: std::option::Option<crate::model::LifeCycleState>,
        ) -> Self {
            self.life_cycle_state = input;
            self
        }
        /// <p>You can add tags to a file system, including a <code>Name</code> tag. For more information, see <code>CreateFileSystem</code>. If the file system has a <code>Name</code> tag, Amazon EFS returns the value in this field. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>You can add tags to a file system, including a <code>Name</code> tag. For more information, see <code>CreateFileSystem</code>. If the file system has a <code>Name</code> tag, Amazon EFS returns the value in this field. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current number of mount targets that the file system has. For more information, see <code>CreateMountTarget</code>.</p>
        pub fn number_of_mount_targets(mut self, input: i32) -> Self {
            self.number_of_mount_targets = Some(input);
            self
        }
        /// <p>The current number of mount targets that the file system has. For more information, see <code>CreateMountTarget</code>.</p>
        pub fn set_number_of_mount_targets(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_mount_targets = input;
            self
        }
        /// <p>The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code> field, and the time at which that size was determined in its <code>Timestamp</code> field. The <code>Timestamp</code> value is the integer number of seconds since 1970-01-01T00:00:00Z. The <code>SizeInBytes</code> value doesn't represent the size of a consistent snapshot of the file system, but it is eventually consistent when there are no writes to the file system. That is, <code>SizeInBytes</code> represents actual size only if the file system is not modified for a period longer than a couple of hours. Otherwise, the value is not the exact size that the file system was at any point in time. </p>
        pub fn size_in_bytes(mut self, input: crate::model::FileSystemSize) -> Self {
            self.size_in_bytes = Some(input);
            self
        }
        /// <p>The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code> field, and the time at which that size was determined in its <code>Timestamp</code> field. The <code>Timestamp</code> value is the integer number of seconds since 1970-01-01T00:00:00Z. The <code>SizeInBytes</code> value doesn't represent the size of a consistent snapshot of the file system, but it is eventually consistent when there are no writes to the file system. That is, <code>SizeInBytes</code> represents actual size only if the file system is not modified for a period longer than a couple of hours. Otherwise, the value is not the exact size that the file system was at any point in time. </p>
        pub fn set_size_in_bytes(
            mut self,
            input: std::option::Option<crate::model::FileSystemSize>,
        ) -> Self {
            self.size_in_bytes = input;
            self
        }
        /// <p>The performance mode of the file system.</p>
        pub fn performance_mode(mut self, input: crate::model::PerformanceMode) -> Self {
            self.performance_mode = Some(input);
            self
        }
        /// <p>The performance mode of the file system.</p>
        pub fn set_performance_mode(
            mut self,
            input: std::option::Option<crate::model::PerformanceMode>,
        ) -> Self {
            self.performance_mode = input;
            self
        }
        /// <p>A Boolean value that, if true, indicates that the file system is encrypted.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>A Boolean value that, if true, indicates that the file system is encrypted.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The ID of an KMS key used to protect the encrypted file system.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of an KMS key used to protect the encrypted file system.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Displays the file system's throughput mode. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a> in the <i>Amazon EFS User Guide</i>. </p>
        pub fn throughput_mode(mut self, input: crate::model::ThroughputMode) -> Self {
            self.throughput_mode = Some(input);
            self
        }
        /// <p>Displays the file system's throughput mode. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a> in the <i>Amazon EFS User Guide</i>. </p>
        pub fn set_throughput_mode(
            mut self,
            input: std::option::Option<crate::model::ThroughputMode>,
        ) -> Self {
            self.throughput_mode = input;
            self
        }
        /// <p>The amount of provisioned throughput, measured in MiB/s, for the file system. Valid for file systems using <code>ThroughputMode</code> set to <code>provisioned</code>.</p>
        pub fn provisioned_throughput_in_mibps(mut self, input: f64) -> Self {
            self.provisioned_throughput_in_mibps = Some(input);
            self
        }
        /// <p>The amount of provisioned throughput, measured in MiB/s, for the file system. Valid for file systems using <code>ThroughputMode</code> set to <code>provisioned</code>.</p>
        pub fn set_provisioned_throughput_in_mibps(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.provisioned_throughput_in_mibps = input;
            self
        }
        /// <p>Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid only for file systems using One Zone storage classes. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p>
        pub fn availability_zone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_name = Some(input.into());
            self
        }
        /// <p>Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid only for file systems using One Zone storage classes. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p>
        pub fn set_availability_zone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_name = input;
            self
        }
        /// <p>The unique and consistent identifier of the Availability Zone in which the file system's One Zone storage classes exist. For example, <code>use1-az1</code> is an Availability Zone ID for the us-east-1 Amazon Web Services Region, and it has the same location in every Amazon Web Services account.</p>
        pub fn availability_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_id = Some(input.into());
            self
        }
        /// <p>The unique and consistent identifier of the Availability Zone in which the file system's One Zone storage classes exist. For example, <code>use1-az1</code> is an Availability Zone ID for the us-east-1 Amazon Web Services Region, and it has the same location in every Amazon Web Services account.</p>
        pub fn set_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the file system, presented as an array of <code>Tag</code> objects.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the file system, presented as an array of <code>Tag</code> objects.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFileSystemOutput`](crate::output::UpdateFileSystemOutput)
        pub fn build(self) -> crate::output::UpdateFileSystemOutput {
            crate::output::UpdateFileSystemOutput {
                owner_id: self.owner_id,
                creation_token: self.creation_token,
                file_system_id: self.file_system_id,
                file_system_arn: self.file_system_arn,
                creation_time: self.creation_time,
                life_cycle_state: self.life_cycle_state,
                name: self.name,
                number_of_mount_targets: self.number_of_mount_targets.unwrap_or_default(),
                size_in_bytes: self.size_in_bytes,
                performance_mode: self.performance_mode,
                encrypted: self.encrypted,
                kms_key_id: self.kms_key_id,
                throughput_mode: self.throughput_mode,
                provisioned_throughput_in_mibps: self.provisioned_throughput_in_mibps,
                availability_zone_name: self.availability_zone_name,
                availability_zone_id: self.availability_zone_id,
                tags: self.tags,
            }
        }
    }
}
impl UpdateFileSystemOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFileSystemOutput`](crate::output::UpdateFileSystemOutput)
    pub fn builder() -> crate::output::update_file_system_output::Builder {
        crate::output::update_file_system_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutLifecycleConfigurationOutput {
    /// <p>An array of lifecycle management policies. EFS supports a maximum of one policy per file system.</p>
    pub lifecycle_policies: std::option::Option<std::vec::Vec<crate::model::LifecyclePolicy>>,
}
impl PutLifecycleConfigurationOutput {
    /// <p>An array of lifecycle management policies. EFS supports a maximum of one policy per file system.</p>
    pub fn lifecycle_policies(&self) -> std::option::Option<&[crate::model::LifecyclePolicy]> {
        self.lifecycle_policies.as_deref()
    }
}
impl std::fmt::Debug for PutLifecycleConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutLifecycleConfigurationOutput");
        formatter.field("lifecycle_policies", &self.lifecycle_policies);
        formatter.finish()
    }
}
/// See [`PutLifecycleConfigurationOutput`](crate::output::PutLifecycleConfigurationOutput)
pub mod put_lifecycle_configuration_output {
    /// A builder for [`PutLifecycleConfigurationOutput`](crate::output::PutLifecycleConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lifecycle_policies:
            std::option::Option<std::vec::Vec<crate::model::LifecyclePolicy>>,
    }
    impl Builder {
        /// Appends an item to `lifecycle_policies`.
        ///
        /// To override the contents of this collection use [`set_lifecycle_policies`](Self::set_lifecycle_policies).
        ///
        /// <p>An array of lifecycle management policies. EFS supports a maximum of one policy per file system.</p>
        pub fn lifecycle_policies(mut self, input: crate::model::LifecyclePolicy) -> Self {
            let mut v = self.lifecycle_policies.unwrap_or_default();
            v.push(input);
            self.lifecycle_policies = Some(v);
            self
        }
        /// <p>An array of lifecycle management policies. EFS supports a maximum of one policy per file system.</p>
        pub fn set_lifecycle_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LifecyclePolicy>>,
        ) -> Self {
            self.lifecycle_policies = input;
            self
        }
        /// Consumes the builder and constructs a [`PutLifecycleConfigurationOutput`](crate::output::PutLifecycleConfigurationOutput)
        pub fn build(self) -> crate::output::PutLifecycleConfigurationOutput {
            crate::output::PutLifecycleConfigurationOutput {
                lifecycle_policies: self.lifecycle_policies,
            }
        }
    }
}
impl PutLifecycleConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutLifecycleConfigurationOutput`](crate::output::PutLifecycleConfigurationOutput)
    pub fn builder() -> crate::output::put_lifecycle_configuration_output::Builder {
        crate::output::put_lifecycle_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutFileSystemPolicyOutput {
    /// <p>Specifies the EFS file system to which the <code>FileSystemPolicy</code> applies.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The JSON formatted <code>FileSystemPolicy</code> for the EFS file system.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl PutFileSystemPolicyOutput {
    /// <p>Specifies the EFS file system to which the <code>FileSystemPolicy</code> applies.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>The JSON formatted <code>FileSystemPolicy</code> for the EFS file system.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for PutFileSystemPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutFileSystemPolicyOutput");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`PutFileSystemPolicyOutput`](crate::output::PutFileSystemPolicyOutput)
pub mod put_file_system_policy_output {
    /// A builder for [`PutFileSystemPolicyOutput`](crate::output::PutFileSystemPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the EFS file system to which the <code>FileSystemPolicy</code> applies.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>Specifies the EFS file system to which the <code>FileSystemPolicy</code> applies.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The JSON formatted <code>FileSystemPolicy</code> for the EFS file system.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The JSON formatted <code>FileSystemPolicy</code> for the EFS file system.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutFileSystemPolicyOutput`](crate::output::PutFileSystemPolicyOutput)
        pub fn build(self) -> crate::output::PutFileSystemPolicyOutput {
            crate::output::PutFileSystemPolicyOutput {
                file_system_id: self.file_system_id,
                policy: self.policy,
            }
        }
    }
}
impl PutFileSystemPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutFileSystemPolicyOutput`](crate::output::PutFileSystemPolicyOutput)
    pub fn builder() -> crate::output::put_file_system_policy_output::Builder {
        crate::output::put_file_system_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBackupPolicyOutput {
    /// <p>Describes the file system's backup policy, indicating whether automatic backups are turned on or off..</p>
    pub backup_policy: std::option::Option<crate::model::BackupPolicy>,
}
impl PutBackupPolicyOutput {
    /// <p>Describes the file system's backup policy, indicating whether automatic backups are turned on or off..</p>
    pub fn backup_policy(&self) -> std::option::Option<&crate::model::BackupPolicy> {
        self.backup_policy.as_ref()
    }
}
impl std::fmt::Debug for PutBackupPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBackupPolicyOutput");
        formatter.field("backup_policy", &self.backup_policy);
        formatter.finish()
    }
}
/// See [`PutBackupPolicyOutput`](crate::output::PutBackupPolicyOutput)
pub mod put_backup_policy_output {
    /// A builder for [`PutBackupPolicyOutput`](crate::output::PutBackupPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_policy: std::option::Option<crate::model::BackupPolicy>,
    }
    impl Builder {
        /// <p>Describes the file system's backup policy, indicating whether automatic backups are turned on or off..</p>
        pub fn backup_policy(mut self, input: crate::model::BackupPolicy) -> Self {
            self.backup_policy = Some(input);
            self
        }
        /// <p>Describes the file system's backup policy, indicating whether automatic backups are turned on or off..</p>
        pub fn set_backup_policy(
            mut self,
            input: std::option::Option<crate::model::BackupPolicy>,
        ) -> Self {
            self.backup_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBackupPolicyOutput`](crate::output::PutBackupPolicyOutput)
        pub fn build(self) -> crate::output::PutBackupPolicyOutput {
            crate::output::PutBackupPolicyOutput {
                backup_policy: self.backup_policy,
            }
        }
    }
}
impl PutBackupPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutBackupPolicyOutput`](crate::output::PutBackupPolicyOutput)
    pub fn builder() -> crate::output::put_backup_policy_output::Builder {
        crate::output::put_backup_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAccountPreferencesOutput {
    /// <p>Describes the resource type and its ID preference for the user's Amazon Web Services account, in the current Amazon Web Services Region.</p>
    pub resource_id_preference: std::option::Option<crate::model::ResourceIdPreference>,
}
impl PutAccountPreferencesOutput {
    /// <p>Describes the resource type and its ID preference for the user's Amazon Web Services account, in the current Amazon Web Services Region.</p>
    pub fn resource_id_preference(
        &self,
    ) -> std::option::Option<&crate::model::ResourceIdPreference> {
        self.resource_id_preference.as_ref()
    }
}
impl std::fmt::Debug for PutAccountPreferencesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAccountPreferencesOutput");
        formatter.field("resource_id_preference", &self.resource_id_preference);
        formatter.finish()
    }
}
/// See [`PutAccountPreferencesOutput`](crate::output::PutAccountPreferencesOutput)
pub mod put_account_preferences_output {
    /// A builder for [`PutAccountPreferencesOutput`](crate::output::PutAccountPreferencesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id_preference: std::option::Option<crate::model::ResourceIdPreference>,
    }
    impl Builder {
        /// <p>Describes the resource type and its ID preference for the user's Amazon Web Services account, in the current Amazon Web Services Region.</p>
        pub fn resource_id_preference(mut self, input: crate::model::ResourceIdPreference) -> Self {
            self.resource_id_preference = Some(input);
            self
        }
        /// <p>Describes the resource type and its ID preference for the user's Amazon Web Services account, in the current Amazon Web Services Region.</p>
        pub fn set_resource_id_preference(
            mut self,
            input: std::option::Option<crate::model::ResourceIdPreference>,
        ) -> Self {
            self.resource_id_preference = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAccountPreferencesOutput`](crate::output::PutAccountPreferencesOutput)
        pub fn build(self) -> crate::output::PutAccountPreferencesOutput {
            crate::output::PutAccountPreferencesOutput {
                resource_id_preference: self.resource_id_preference,
            }
        }
    }
}
impl PutAccountPreferencesOutput {
    /// Creates a new builder-style object to manufacture [`PutAccountPreferencesOutput`](crate::output::PutAccountPreferencesOutput)
    pub fn builder() -> crate::output::put_account_preferences_output::Builder {
        crate::output::put_account_preferences_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyMountTargetSecurityGroupsOutput {}
impl std::fmt::Debug for ModifyMountTargetSecurityGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyMountTargetSecurityGroupsOutput");
        formatter.finish()
    }
}
/// See [`ModifyMountTargetSecurityGroupsOutput`](crate::output::ModifyMountTargetSecurityGroupsOutput)
pub mod modify_mount_target_security_groups_output {
    /// A builder for [`ModifyMountTargetSecurityGroupsOutput`](crate::output::ModifyMountTargetSecurityGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ModifyMountTargetSecurityGroupsOutput`](crate::output::ModifyMountTargetSecurityGroupsOutput)
        pub fn build(self) -> crate::output::ModifyMountTargetSecurityGroupsOutput {
            crate::output::ModifyMountTargetSecurityGroupsOutput {}
        }
    }
}
impl ModifyMountTargetSecurityGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ModifyMountTargetSecurityGroupsOutput`](crate::output::ModifyMountTargetSecurityGroupsOutput)
    pub fn builder() -> crate::output::modify_mount_target_security_groups_output::Builder {
        crate::output::modify_mount_target_security_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>An array of the tags for the specified EFS resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p> <code>NextToken</code> is present if the response payload is paginated. You can use <code>NextToken</code> in a subsequent request to fetch the next page of access point descriptions.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceOutput {
    /// <p>An array of the tags for the specified EFS resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p> <code>NextToken</code> is present if the response payload is paginated. You can use <code>NextToken</code> in a subsequent request to fetch the next page of access point descriptions.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of the tags for the specified EFS resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of the tags for the specified EFS resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p> <code>NextToken</code> is present if the response payload is paginated. You can use <code>NextToken</code> in a subsequent request to fetch the next page of access point descriptions.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> <code>NextToken</code> is present if the response payload is paginated. You can use <code>NextToken</code> in a subsequent request to fetch the next page of access point descriptions.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTagsOutput {
    /// <p>If the request included a <code>Marker</code>, the response returns that value in this field.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Returns tags associated with the file system as an array of <code>Tag</code> objects. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>If a value is present, there are more tags to return. In a subsequent request, you can provide the value of <code>NextMarker</code> as the value of the <code>Marker</code> parameter in your next request to retrieve the next set of tags.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl DescribeTagsOutput {
    /// <p>If the request included a <code>Marker</code>, the response returns that value in this field.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Returns tags associated with the file system as an array of <code>Tag</code> objects. </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>If a value is present, there are more tags to return. In a subsequent request, you can provide the value of <code>NextMarker</code> as the value of the <code>Marker</code> parameter in your next request to retrieve the next set of tags.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTagsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("tags", &self.tags);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
pub mod describe_tags_output {
    /// A builder for [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>If the request included a <code>Marker</code>, the response returns that value in this field.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>If the request included a <code>Marker</code>, the response returns that value in this field.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Returns tags associated with the file system as an array of <code>Tag</code> objects. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Returns tags associated with the file system as an array of <code>Tag</code> objects. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>If a value is present, there are more tags to return. In a subsequent request, you can provide the value of <code>NextMarker</code> as the value of the <code>Marker</code> parameter in your next request to retrieve the next set of tags.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If a value is present, there are more tags to return. In a subsequent request, you can provide the value of <code>NextMarker</code> as the value of the <code>Marker</code> parameter in your next request to retrieve the next set of tags.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
        pub fn build(self) -> crate::output::DescribeTagsOutput {
            crate::output::DescribeTagsOutput {
                marker: self.marker,
                tags: self.tags,
                next_marker: self.next_marker,
            }
        }
    }
}
impl DescribeTagsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
    pub fn builder() -> crate::output::describe_tags_output::Builder {
        crate::output::describe_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReplicationConfigurationsOutput {
    /// <p>The collection of replication configurations returned.</p>
    pub replications:
        std::option::Option<std::vec::Vec<crate::model::ReplicationConfigurationDescription>>,
    /// <p>You can use the <code>NextToken</code> from the previous response in a subsequent request to fetch the additional descriptions.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeReplicationConfigurationsOutput {
    /// <p>The collection of replication configurations returned.</p>
    pub fn replications(
        &self,
    ) -> std::option::Option<&[crate::model::ReplicationConfigurationDescription]> {
        self.replications.as_deref()
    }
    /// <p>You can use the <code>NextToken</code> from the previous response in a subsequent request to fetch the additional descriptions.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeReplicationConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReplicationConfigurationsOutput");
        formatter.field("replications", &self.replications);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeReplicationConfigurationsOutput`](crate::output::DescribeReplicationConfigurationsOutput)
pub mod describe_replication_configurations_output {
    /// A builder for [`DescribeReplicationConfigurationsOutput`](crate::output::DescribeReplicationConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replications:
            std::option::Option<std::vec::Vec<crate::model::ReplicationConfigurationDescription>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `replications`.
        ///
        /// To override the contents of this collection use [`set_replications`](Self::set_replications).
        ///
        /// <p>The collection of replication configurations returned.</p>
        pub fn replications(
            mut self,
            input: crate::model::ReplicationConfigurationDescription,
        ) -> Self {
            let mut v = self.replications.unwrap_or_default();
            v.push(input);
            self.replications = Some(v);
            self
        }
        /// <p>The collection of replication configurations returned.</p>
        pub fn set_replications(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReplicationConfigurationDescription>,
            >,
        ) -> Self {
            self.replications = input;
            self
        }
        /// <p>You can use the <code>NextToken</code> from the previous response in a subsequent request to fetch the additional descriptions.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>You can use the <code>NextToken</code> from the previous response in a subsequent request to fetch the additional descriptions.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReplicationConfigurationsOutput`](crate::output::DescribeReplicationConfigurationsOutput)
        pub fn build(self) -> crate::output::DescribeReplicationConfigurationsOutput {
            crate::output::DescribeReplicationConfigurationsOutput {
                replications: self.replications,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeReplicationConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReplicationConfigurationsOutput`](crate::output::DescribeReplicationConfigurationsOutput)
    pub fn builder() -> crate::output::describe_replication_configurations_output::Builder {
        crate::output::describe_replication_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMountTargetSecurityGroupsOutput {
    /// <p>An array of security groups.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeMountTargetSecurityGroupsOutput {
    /// <p>An array of security groups.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
}
impl std::fmt::Debug for DescribeMountTargetSecurityGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMountTargetSecurityGroupsOutput");
        formatter.field("security_groups", &self.security_groups);
        formatter.finish()
    }
}
/// See [`DescribeMountTargetSecurityGroupsOutput`](crate::output::DescribeMountTargetSecurityGroupsOutput)
pub mod describe_mount_target_security_groups_output {
    /// A builder for [`DescribeMountTargetSecurityGroupsOutput`](crate::output::DescribeMountTargetSecurityGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>An array of security groups.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>An array of security groups.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMountTargetSecurityGroupsOutput`](crate::output::DescribeMountTargetSecurityGroupsOutput)
        pub fn build(self) -> crate::output::DescribeMountTargetSecurityGroupsOutput {
            crate::output::DescribeMountTargetSecurityGroupsOutput {
                security_groups: self.security_groups,
            }
        }
    }
}
impl DescribeMountTargetSecurityGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMountTargetSecurityGroupsOutput`](crate::output::DescribeMountTargetSecurityGroupsOutput)
    pub fn builder() -> crate::output::describe_mount_target_security_groups_output::Builder {
        crate::output::describe_mount_target_security_groups_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMountTargetsOutput {
    /// <p>If the request included the <code>Marker</code>, the response returns that value in this field.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.</p>
    pub mount_targets: std::option::Option<std::vec::Vec<crate::model::MountTargetDescription>>,
    /// <p>If a value is present, there are more mount targets to return. In a subsequent request, you can provide <code>Marker</code> in your request with this value to retrieve the next set of mount targets.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl DescribeMountTargetsOutput {
    /// <p>If the request included the <code>Marker</code>, the response returns that value in this field.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.</p>
    pub fn mount_targets(&self) -> std::option::Option<&[crate::model::MountTargetDescription]> {
        self.mount_targets.as_deref()
    }
    /// <p>If a value is present, there are more mount targets to return. In a subsequent request, you can provide <code>Marker</code> in your request with this value to retrieve the next set of mount targets.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeMountTargetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMountTargetsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("mount_targets", &self.mount_targets);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`DescribeMountTargetsOutput`](crate::output::DescribeMountTargetsOutput)
pub mod describe_mount_targets_output {
    /// A builder for [`DescribeMountTargetsOutput`](crate::output::DescribeMountTargetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) mount_targets:
            std::option::Option<std::vec::Vec<crate::model::MountTargetDescription>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>If the request included the <code>Marker</code>, the response returns that value in this field.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>If the request included the <code>Marker</code>, the response returns that value in this field.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `mount_targets`.
        ///
        /// To override the contents of this collection use [`set_mount_targets`](Self::set_mount_targets).
        ///
        /// <p>Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.</p>
        pub fn mount_targets(mut self, input: crate::model::MountTargetDescription) -> Self {
            let mut v = self.mount_targets.unwrap_or_default();
            v.push(input);
            self.mount_targets = Some(v);
            self
        }
        /// <p>Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.</p>
        pub fn set_mount_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MountTargetDescription>>,
        ) -> Self {
            self.mount_targets = input;
            self
        }
        /// <p>If a value is present, there are more mount targets to return. In a subsequent request, you can provide <code>Marker</code> in your request with this value to retrieve the next set of mount targets.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>If a value is present, there are more mount targets to return. In a subsequent request, you can provide <code>Marker</code> in your request with this value to retrieve the next set of mount targets.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMountTargetsOutput`](crate::output::DescribeMountTargetsOutput)
        pub fn build(self) -> crate::output::DescribeMountTargetsOutput {
            crate::output::DescribeMountTargetsOutput {
                marker: self.marker,
                mount_targets: self.mount_targets,
                next_marker: self.next_marker,
            }
        }
    }
}
impl DescribeMountTargetsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMountTargetsOutput`](crate::output::DescribeMountTargetsOutput)
    pub fn builder() -> crate::output::describe_mount_targets_output::Builder {
        crate::output::describe_mount_targets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLifecycleConfigurationOutput {
    /// <p>An array of lifecycle management policies. EFS supports a maximum of one policy per file system.</p>
    pub lifecycle_policies: std::option::Option<std::vec::Vec<crate::model::LifecyclePolicy>>,
}
impl DescribeLifecycleConfigurationOutput {
    /// <p>An array of lifecycle management policies. EFS supports a maximum of one policy per file system.</p>
    pub fn lifecycle_policies(&self) -> std::option::Option<&[crate::model::LifecyclePolicy]> {
        self.lifecycle_policies.as_deref()
    }
}
impl std::fmt::Debug for DescribeLifecycleConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLifecycleConfigurationOutput");
        formatter.field("lifecycle_policies", &self.lifecycle_policies);
        formatter.finish()
    }
}
/// See [`DescribeLifecycleConfigurationOutput`](crate::output::DescribeLifecycleConfigurationOutput)
pub mod describe_lifecycle_configuration_output {
    /// A builder for [`DescribeLifecycleConfigurationOutput`](crate::output::DescribeLifecycleConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lifecycle_policies:
            std::option::Option<std::vec::Vec<crate::model::LifecyclePolicy>>,
    }
    impl Builder {
        /// Appends an item to `lifecycle_policies`.
        ///
        /// To override the contents of this collection use [`set_lifecycle_policies`](Self::set_lifecycle_policies).
        ///
        /// <p>An array of lifecycle management policies. EFS supports a maximum of one policy per file system.</p>
        pub fn lifecycle_policies(mut self, input: crate::model::LifecyclePolicy) -> Self {
            let mut v = self.lifecycle_policies.unwrap_or_default();
            v.push(input);
            self.lifecycle_policies = Some(v);
            self
        }
        /// <p>An array of lifecycle management policies. EFS supports a maximum of one policy per file system.</p>
        pub fn set_lifecycle_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LifecyclePolicy>>,
        ) -> Self {
            self.lifecycle_policies = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLifecycleConfigurationOutput`](crate::output::DescribeLifecycleConfigurationOutput)
        pub fn build(self) -> crate::output::DescribeLifecycleConfigurationOutput {
            crate::output::DescribeLifecycleConfigurationOutput {
                lifecycle_policies: self.lifecycle_policies,
            }
        }
    }
}
impl DescribeLifecycleConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLifecycleConfigurationOutput`](crate::output::DescribeLifecycleConfigurationOutput)
    pub fn builder() -> crate::output::describe_lifecycle_configuration_output::Builder {
        crate::output::describe_lifecycle_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFileSystemsOutput {
    /// <p>Present if provided by caller in the request (String).</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>An array of file system descriptions.</p>
    pub file_systems: std::option::Option<std::vec::Vec<crate::model::FileSystemDescription>>,
    /// <p>Present if there are more file systems than returned in the response (String). You can use the <code>NextMarker</code> in the subsequent request to fetch the descriptions.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl DescribeFileSystemsOutput {
    /// <p>Present if provided by caller in the request (String).</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>An array of file system descriptions.</p>
    pub fn file_systems(&self) -> std::option::Option<&[crate::model::FileSystemDescription]> {
        self.file_systems.as_deref()
    }
    /// <p>Present if there are more file systems than returned in the response (String). You can use the <code>NextMarker</code> in the subsequent request to fetch the descriptions.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeFileSystemsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFileSystemsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("file_systems", &self.file_systems);
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`DescribeFileSystemsOutput`](crate::output::DescribeFileSystemsOutput)
pub mod describe_file_systems_output {
    /// A builder for [`DescribeFileSystemsOutput`](crate::output::DescribeFileSystemsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) file_systems:
            std::option::Option<std::vec::Vec<crate::model::FileSystemDescription>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Present if provided by caller in the request (String).</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Present if provided by caller in the request (String).</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `file_systems`.
        ///
        /// To override the contents of this collection use [`set_file_systems`](Self::set_file_systems).
        ///
        /// <p>An array of file system descriptions.</p>
        pub fn file_systems(mut self, input: crate::model::FileSystemDescription) -> Self {
            let mut v = self.file_systems.unwrap_or_default();
            v.push(input);
            self.file_systems = Some(v);
            self
        }
        /// <p>An array of file system descriptions.</p>
        pub fn set_file_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileSystemDescription>>,
        ) -> Self {
            self.file_systems = input;
            self
        }
        /// <p>Present if there are more file systems than returned in the response (String). You can use the <code>NextMarker</code> in the subsequent request to fetch the descriptions.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>Present if there are more file systems than returned in the response (String). You can use the <code>NextMarker</code> in the subsequent request to fetch the descriptions.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFileSystemsOutput`](crate::output::DescribeFileSystemsOutput)
        pub fn build(self) -> crate::output::DescribeFileSystemsOutput {
            crate::output::DescribeFileSystemsOutput {
                marker: self.marker,
                file_systems: self.file_systems,
                next_marker: self.next_marker,
            }
        }
    }
}
impl DescribeFileSystemsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFileSystemsOutput`](crate::output::DescribeFileSystemsOutput)
    pub fn builder() -> crate::output::describe_file_systems_output::Builder {
        crate::output::describe_file_systems_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFileSystemPolicyOutput {
    /// <p>Specifies the EFS file system to which the <code>FileSystemPolicy</code> applies.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The JSON formatted <code>FileSystemPolicy</code> for the EFS file system.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl DescribeFileSystemPolicyOutput {
    /// <p>Specifies the EFS file system to which the <code>FileSystemPolicy</code> applies.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>The JSON formatted <code>FileSystemPolicy</code> for the EFS file system.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for DescribeFileSystemPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFileSystemPolicyOutput");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`DescribeFileSystemPolicyOutput`](crate::output::DescribeFileSystemPolicyOutput)
pub mod describe_file_system_policy_output {
    /// A builder for [`DescribeFileSystemPolicyOutput`](crate::output::DescribeFileSystemPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the EFS file system to which the <code>FileSystemPolicy</code> applies.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>Specifies the EFS file system to which the <code>FileSystemPolicy</code> applies.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The JSON formatted <code>FileSystemPolicy</code> for the EFS file system.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The JSON formatted <code>FileSystemPolicy</code> for the EFS file system.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFileSystemPolicyOutput`](crate::output::DescribeFileSystemPolicyOutput)
        pub fn build(self) -> crate::output::DescribeFileSystemPolicyOutput {
            crate::output::DescribeFileSystemPolicyOutput {
                file_system_id: self.file_system_id,
                policy: self.policy,
            }
        }
    }
}
impl DescribeFileSystemPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFileSystemPolicyOutput`](crate::output::DescribeFileSystemPolicyOutput)
    pub fn builder() -> crate::output::describe_file_system_policy_output::Builder {
        crate::output::describe_file_system_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBackupPolicyOutput {
    /// <p>Describes the file system's backup policy, indicating whether automatic backups are turned on or off..</p>
    pub backup_policy: std::option::Option<crate::model::BackupPolicy>,
}
impl DescribeBackupPolicyOutput {
    /// <p>Describes the file system's backup policy, indicating whether automatic backups are turned on or off..</p>
    pub fn backup_policy(&self) -> std::option::Option<&crate::model::BackupPolicy> {
        self.backup_policy.as_ref()
    }
}
impl std::fmt::Debug for DescribeBackupPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBackupPolicyOutput");
        formatter.field("backup_policy", &self.backup_policy);
        formatter.finish()
    }
}
/// See [`DescribeBackupPolicyOutput`](crate::output::DescribeBackupPolicyOutput)
pub mod describe_backup_policy_output {
    /// A builder for [`DescribeBackupPolicyOutput`](crate::output::DescribeBackupPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) backup_policy: std::option::Option<crate::model::BackupPolicy>,
    }
    impl Builder {
        /// <p>Describes the file system's backup policy, indicating whether automatic backups are turned on or off..</p>
        pub fn backup_policy(mut self, input: crate::model::BackupPolicy) -> Self {
            self.backup_policy = Some(input);
            self
        }
        /// <p>Describes the file system's backup policy, indicating whether automatic backups are turned on or off..</p>
        pub fn set_backup_policy(
            mut self,
            input: std::option::Option<crate::model::BackupPolicy>,
        ) -> Self {
            self.backup_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBackupPolicyOutput`](crate::output::DescribeBackupPolicyOutput)
        pub fn build(self) -> crate::output::DescribeBackupPolicyOutput {
            crate::output::DescribeBackupPolicyOutput {
                backup_policy: self.backup_policy,
            }
        }
    }
}
impl DescribeBackupPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBackupPolicyOutput`](crate::output::DescribeBackupPolicyOutput)
    pub fn builder() -> crate::output::describe_backup_policy_output::Builder {
        crate::output::describe_backup_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountPreferencesOutput {
    /// <p>Describes the resource ID preference setting for the Amazon Web Services account associated with the user making the request, in the current Amazon Web Services Region.</p>
    pub resource_id_preference: std::option::Option<crate::model::ResourceIdPreference>,
    /// <p>Present if there are more records than returned in the response. You can use the <code>NextToken</code> in the subsequent request to fetch the additional descriptions.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeAccountPreferencesOutput {
    /// <p>Describes the resource ID preference setting for the Amazon Web Services account associated with the user making the request, in the current Amazon Web Services Region.</p>
    pub fn resource_id_preference(
        &self,
    ) -> std::option::Option<&crate::model::ResourceIdPreference> {
        self.resource_id_preference.as_ref()
    }
    /// <p>Present if there are more records than returned in the response. You can use the <code>NextToken</code> in the subsequent request to fetch the additional descriptions.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeAccountPreferencesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountPreferencesOutput");
        formatter.field("resource_id_preference", &self.resource_id_preference);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeAccountPreferencesOutput`](crate::output::DescribeAccountPreferencesOutput)
pub mod describe_account_preferences_output {
    /// A builder for [`DescribeAccountPreferencesOutput`](crate::output::DescribeAccountPreferencesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id_preference: std::option::Option<crate::model::ResourceIdPreference>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Describes the resource ID preference setting for the Amazon Web Services account associated with the user making the request, in the current Amazon Web Services Region.</p>
        pub fn resource_id_preference(mut self, input: crate::model::ResourceIdPreference) -> Self {
            self.resource_id_preference = Some(input);
            self
        }
        /// <p>Describes the resource ID preference setting for the Amazon Web Services account associated with the user making the request, in the current Amazon Web Services Region.</p>
        pub fn set_resource_id_preference(
            mut self,
            input: std::option::Option<crate::model::ResourceIdPreference>,
        ) -> Self {
            self.resource_id_preference = input;
            self
        }
        /// <p>Present if there are more records than returned in the response. You can use the <code>NextToken</code> in the subsequent request to fetch the additional descriptions.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Present if there are more records than returned in the response. You can use the <code>NextToken</code> in the subsequent request to fetch the additional descriptions.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountPreferencesOutput`](crate::output::DescribeAccountPreferencesOutput)
        pub fn build(self) -> crate::output::DescribeAccountPreferencesOutput {
            crate::output::DescribeAccountPreferencesOutput {
                resource_id_preference: self.resource_id_preference,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeAccountPreferencesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAccountPreferencesOutput`](crate::output::DescribeAccountPreferencesOutput)
    pub fn builder() -> crate::output::describe_account_preferences_output::Builder {
        crate::output::describe_account_preferences_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccessPointsOutput {
    /// <p>An array of access point descriptions.</p>
    pub access_points: std::option::Option<std::vec::Vec<crate::model::AccessPointDescription>>,
    /// <p>Present if there are more access points than returned in the response. You can use the NextMarker in the subsequent request to fetch the additional descriptions.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeAccessPointsOutput {
    /// <p>An array of access point descriptions.</p>
    pub fn access_points(&self) -> std::option::Option<&[crate::model::AccessPointDescription]> {
        self.access_points.as_deref()
    }
    /// <p>Present if there are more access points than returned in the response. You can use the NextMarker in the subsequent request to fetch the additional descriptions.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeAccessPointsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccessPointsOutput");
        formatter.field("access_points", &self.access_points);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeAccessPointsOutput`](crate::output::DescribeAccessPointsOutput)
pub mod describe_access_points_output {
    /// A builder for [`DescribeAccessPointsOutput`](crate::output::DescribeAccessPointsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_points:
            std::option::Option<std::vec::Vec<crate::model::AccessPointDescription>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `access_points`.
        ///
        /// To override the contents of this collection use [`set_access_points`](Self::set_access_points).
        ///
        /// <p>An array of access point descriptions.</p>
        pub fn access_points(mut self, input: crate::model::AccessPointDescription) -> Self {
            let mut v = self.access_points.unwrap_or_default();
            v.push(input);
            self.access_points = Some(v);
            self
        }
        /// <p>An array of access point descriptions.</p>
        pub fn set_access_points(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessPointDescription>>,
        ) -> Self {
            self.access_points = input;
            self
        }
        /// <p>Present if there are more access points than returned in the response. You can use the NextMarker in the subsequent request to fetch the additional descriptions.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Present if there are more access points than returned in the response. You can use the NextMarker in the subsequent request to fetch the additional descriptions.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccessPointsOutput`](crate::output::DescribeAccessPointsOutput)
        pub fn build(self) -> crate::output::DescribeAccessPointsOutput {
            crate::output::DescribeAccessPointsOutput {
                access_points: self.access_points,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeAccessPointsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAccessPointsOutput`](crate::output::DescribeAccessPointsOutput)
    pub fn builder() -> crate::output::describe_access_points_output::Builder {
        crate::output::describe_access_points_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTagsOutput {}
impl std::fmt::Debug for DeleteTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTagsOutput");
        formatter.finish()
    }
}
/// See [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
pub mod delete_tags_output {
    /// A builder for [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
        pub fn build(self) -> crate::output::DeleteTagsOutput {
            crate::output::DeleteTagsOutput {}
        }
    }
}
impl DeleteTagsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
    pub fn builder() -> crate::output::delete_tags_output::Builder {
        crate::output::delete_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReplicationConfigurationOutput {}
impl std::fmt::Debug for DeleteReplicationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReplicationConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteReplicationConfigurationOutput`](crate::output::DeleteReplicationConfigurationOutput)
pub mod delete_replication_configuration_output {
    /// A builder for [`DeleteReplicationConfigurationOutput`](crate::output::DeleteReplicationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteReplicationConfigurationOutput`](crate::output::DeleteReplicationConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteReplicationConfigurationOutput {
            crate::output::DeleteReplicationConfigurationOutput {}
        }
    }
}
impl DeleteReplicationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteReplicationConfigurationOutput`](crate::output::DeleteReplicationConfigurationOutput)
    pub fn builder() -> crate::output::delete_replication_configuration_output::Builder {
        crate::output::delete_replication_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMountTargetOutput {}
impl std::fmt::Debug for DeleteMountTargetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMountTargetOutput");
        formatter.finish()
    }
}
/// See [`DeleteMountTargetOutput`](crate::output::DeleteMountTargetOutput)
pub mod delete_mount_target_output {
    /// A builder for [`DeleteMountTargetOutput`](crate::output::DeleteMountTargetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteMountTargetOutput`](crate::output::DeleteMountTargetOutput)
        pub fn build(self) -> crate::output::DeleteMountTargetOutput {
            crate::output::DeleteMountTargetOutput {}
        }
    }
}
impl DeleteMountTargetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteMountTargetOutput`](crate::output::DeleteMountTargetOutput)
    pub fn builder() -> crate::output::delete_mount_target_output::Builder {
        crate::output::delete_mount_target_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFileSystemPolicyOutput {}
impl std::fmt::Debug for DeleteFileSystemPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFileSystemPolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteFileSystemPolicyOutput`](crate::output::DeleteFileSystemPolicyOutput)
pub mod delete_file_system_policy_output {
    /// A builder for [`DeleteFileSystemPolicyOutput`](crate::output::DeleteFileSystemPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFileSystemPolicyOutput`](crate::output::DeleteFileSystemPolicyOutput)
        pub fn build(self) -> crate::output::DeleteFileSystemPolicyOutput {
            crate::output::DeleteFileSystemPolicyOutput {}
        }
    }
}
impl DeleteFileSystemPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFileSystemPolicyOutput`](crate::output::DeleteFileSystemPolicyOutput)
    pub fn builder() -> crate::output::delete_file_system_policy_output::Builder {
        crate::output::delete_file_system_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFileSystemOutput {}
impl std::fmt::Debug for DeleteFileSystemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFileSystemOutput");
        formatter.finish()
    }
}
/// See [`DeleteFileSystemOutput`](crate::output::DeleteFileSystemOutput)
pub mod delete_file_system_output {
    /// A builder for [`DeleteFileSystemOutput`](crate::output::DeleteFileSystemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFileSystemOutput`](crate::output::DeleteFileSystemOutput)
        pub fn build(self) -> crate::output::DeleteFileSystemOutput {
            crate::output::DeleteFileSystemOutput {}
        }
    }
}
impl DeleteFileSystemOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFileSystemOutput`](crate::output::DeleteFileSystemOutput)
    pub fn builder() -> crate::output::delete_file_system_output::Builder {
        crate::output::delete_file_system_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccessPointOutput {}
impl std::fmt::Debug for DeleteAccessPointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccessPointOutput");
        formatter.finish()
    }
}
/// See [`DeleteAccessPointOutput`](crate::output::DeleteAccessPointOutput)
pub mod delete_access_point_output {
    /// A builder for [`DeleteAccessPointOutput`](crate::output::DeleteAccessPointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAccessPointOutput`](crate::output::DeleteAccessPointOutput)
        pub fn build(self) -> crate::output::DeleteAccessPointOutput {
            crate::output::DeleteAccessPointOutput {}
        }
    }
}
impl DeleteAccessPointOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAccessPointOutput`](crate::output::DeleteAccessPointOutput)
    pub fn builder() -> crate::output::delete_access_point_output::Builder {
        crate::output::delete_access_point_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTagsOutput {}
impl std::fmt::Debug for CreateTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTagsOutput");
        formatter.finish()
    }
}
/// See [`CreateTagsOutput`](crate::output::CreateTagsOutput)
pub mod create_tags_output {
    /// A builder for [`CreateTagsOutput`](crate::output::CreateTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateTagsOutput`](crate::output::CreateTagsOutput)
        pub fn build(self) -> crate::output::CreateTagsOutput {
            crate::output::CreateTagsOutput {}
        }
    }
}
impl CreateTagsOutput {
    /// Creates a new builder-style object to manufacture [`CreateTagsOutput`](crate::output::CreateTagsOutput)
    pub fn builder() -> crate::output::create_tags_output::Builder {
        crate::output::create_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReplicationConfigurationOutput {
    /// <p>The ID of the source Amazon EFS file system that is being replicated.</p>
    pub source_file_system_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region in which the source Amazon EFS file system is located.</p>
    pub source_file_system_region: std::option::Option<std::string::String>,
    /// <p>The ARN of the current source file system in the replication configuration.</p>
    pub source_file_system_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the original source Amazon EFS file system in the replication configuration.</p>
    pub original_source_file_system_arn: std::option::Option<std::string::String>,
    /// <p>Describes when the replication configuration was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Array of destination objects. Only one destination object is supported.</p>
    pub destinations: std::option::Option<std::vec::Vec<crate::model::Destination>>,
}
impl CreateReplicationConfigurationOutput {
    /// <p>The ID of the source Amazon EFS file system that is being replicated.</p>
    pub fn source_file_system_id(&self) -> std::option::Option<&str> {
        self.source_file_system_id.as_deref()
    }
    /// <p>The Amazon Web Services Region in which the source Amazon EFS file system is located.</p>
    pub fn source_file_system_region(&self) -> std::option::Option<&str> {
        self.source_file_system_region.as_deref()
    }
    /// <p>The ARN of the current source file system in the replication configuration.</p>
    pub fn source_file_system_arn(&self) -> std::option::Option<&str> {
        self.source_file_system_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the original source Amazon EFS file system in the replication configuration.</p>
    pub fn original_source_file_system_arn(&self) -> std::option::Option<&str> {
        self.original_source_file_system_arn.as_deref()
    }
    /// <p>Describes when the replication configuration was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Array of destination objects. Only one destination object is supported.</p>
    pub fn destinations(&self) -> std::option::Option<&[crate::model::Destination]> {
        self.destinations.as_deref()
    }
}
impl std::fmt::Debug for CreateReplicationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReplicationConfigurationOutput");
        formatter.field("source_file_system_id", &self.source_file_system_id);
        formatter.field("source_file_system_region", &self.source_file_system_region);
        formatter.field("source_file_system_arn", &self.source_file_system_arn);
        formatter.field(
            "original_source_file_system_arn",
            &self.original_source_file_system_arn,
        );
        formatter.field("creation_time", &self.creation_time);
        formatter.field("destinations", &self.destinations);
        formatter.finish()
    }
}
/// See [`CreateReplicationConfigurationOutput`](crate::output::CreateReplicationConfigurationOutput)
pub mod create_replication_configuration_output {
    /// A builder for [`CreateReplicationConfigurationOutput`](crate::output::CreateReplicationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_file_system_id: std::option::Option<std::string::String>,
        pub(crate) source_file_system_region: std::option::Option<std::string::String>,
        pub(crate) source_file_system_arn: std::option::Option<std::string::String>,
        pub(crate) original_source_file_system_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) destinations: std::option::Option<std::vec::Vec<crate::model::Destination>>,
    }
    impl Builder {
        /// <p>The ID of the source Amazon EFS file system that is being replicated.</p>
        pub fn source_file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the source Amazon EFS file system that is being replicated.</p>
        pub fn set_source_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_file_system_id = input;
            self
        }
        /// <p>The Amazon Web Services Region in which the source Amazon EFS file system is located.</p>
        pub fn source_file_system_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_file_system_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region in which the source Amazon EFS file system is located.</p>
        pub fn set_source_file_system_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_file_system_region = input;
            self
        }
        /// <p>The ARN of the current source file system in the replication configuration.</p>
        pub fn source_file_system_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_file_system_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the current source file system in the replication configuration.</p>
        pub fn set_source_file_system_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_file_system_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the original source Amazon EFS file system in the replication configuration.</p>
        pub fn original_source_file_system_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.original_source_file_system_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the original source Amazon EFS file system in the replication configuration.</p>
        pub fn set_original_source_file_system_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.original_source_file_system_arn = input;
            self
        }
        /// <p>Describes when the replication configuration was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>Describes when the replication configuration was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// <p>Array of destination objects. Only one destination object is supported.</p>
        pub fn destinations(mut self, input: crate::model::Destination) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input);
            self.destinations = Some(v);
            self
        }
        /// <p>Array of destination objects. Only one destination object is supported.</p>
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Destination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReplicationConfigurationOutput`](crate::output::CreateReplicationConfigurationOutput)
        pub fn build(self) -> crate::output::CreateReplicationConfigurationOutput {
            crate::output::CreateReplicationConfigurationOutput {
                source_file_system_id: self.source_file_system_id,
                source_file_system_region: self.source_file_system_region,
                source_file_system_arn: self.source_file_system_arn,
                original_source_file_system_arn: self.original_source_file_system_arn,
                creation_time: self.creation_time,
                destinations: self.destinations,
            }
        }
    }
}
impl CreateReplicationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`CreateReplicationConfigurationOutput`](crate::output::CreateReplicationConfigurationOutput)
    pub fn builder() -> crate::output::create_replication_configuration_output::Builder {
        crate::output::create_replication_configuration_output::Builder::default()
    }
}

/// <p>Provides a description of a mount target.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMountTargetOutput {
    /// <p>Amazon Web Services account ID that owns the resource.</p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>System-assigned mount target ID.</p>
    pub mount_target_id: std::option::Option<std::string::String>,
    /// <p>The ID of the file system for which the mount target is intended.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The ID of the mount target's subnet.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>Lifecycle state of the mount target.</p>
    pub life_cycle_state: std::option::Option<crate::model::LifeCycleState>,
    /// <p>Address at which the file system can be mounted by using the mount target.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The ID of the network interface that Amazon EFS created when it created the mount target.</p>
    pub network_interface_id: std::option::Option<std::string::String>,
    /// <p>The unique and consistent identifier of the Availability Zone that the mount target resides in. For example, <code>use1-az1</code> is an AZ ID for the us-east-1 Region and it has the same location in every Amazon Web Services account.</p>
    pub availability_zone_id: std::option::Option<std::string::String>,
    /// <p>The name of the Availability Zone in which the mount target is located. Availability Zones are independently mapped to names for each Amazon Web Services account. For example, the Availability Zone <code>us-east-1a</code> for your Amazon Web Services account might not be the same location as <code>us-east-1a</code> for another Amazon Web Services account.</p>
    pub availability_zone_name: std::option::Option<std::string::String>,
    /// <p>The virtual private cloud (VPC) ID that the mount target is configured in.</p>
    pub vpc_id: std::option::Option<std::string::String>,
}
impl CreateMountTargetOutput {
    /// <p>Amazon Web Services account ID that owns the resource.</p>
    pub fn owner_id(&self) -> std::option::Option<&str> {
        self.owner_id.as_deref()
    }
    /// <p>System-assigned mount target ID.</p>
    pub fn mount_target_id(&self) -> std::option::Option<&str> {
        self.mount_target_id.as_deref()
    }
    /// <p>The ID of the file system for which the mount target is intended.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>The ID of the mount target's subnet.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>Lifecycle state of the mount target.</p>
    pub fn life_cycle_state(&self) -> std::option::Option<&crate::model::LifeCycleState> {
        self.life_cycle_state.as_ref()
    }
    /// <p>Address at which the file system can be mounted by using the mount target.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>The ID of the network interface that Amazon EFS created when it created the mount target.</p>
    pub fn network_interface_id(&self) -> std::option::Option<&str> {
        self.network_interface_id.as_deref()
    }
    /// <p>The unique and consistent identifier of the Availability Zone that the mount target resides in. For example, <code>use1-az1</code> is an AZ ID for the us-east-1 Region and it has the same location in every Amazon Web Services account.</p>
    pub fn availability_zone_id(&self) -> std::option::Option<&str> {
        self.availability_zone_id.as_deref()
    }
    /// <p>The name of the Availability Zone in which the mount target is located. Availability Zones are independently mapped to names for each Amazon Web Services account. For example, the Availability Zone <code>us-east-1a</code> for your Amazon Web Services account might not be the same location as <code>us-east-1a</code> for another Amazon Web Services account.</p>
    pub fn availability_zone_name(&self) -> std::option::Option<&str> {
        self.availability_zone_name.as_deref()
    }
    /// <p>The virtual private cloud (VPC) ID that the mount target is configured in.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
}
impl std::fmt::Debug for CreateMountTargetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMountTargetOutput");
        formatter.field("owner_id", &self.owner_id);
        formatter.field("mount_target_id", &self.mount_target_id);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("life_cycle_state", &self.life_cycle_state);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("network_interface_id", &self.network_interface_id);
        formatter.field("availability_zone_id", &self.availability_zone_id);
        formatter.field("availability_zone_name", &self.availability_zone_name);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.finish()
    }
}
/// See [`CreateMountTargetOutput`](crate::output::CreateMountTargetOutput)
pub mod create_mount_target_output {
    /// A builder for [`CreateMountTargetOutput`](crate::output::CreateMountTargetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) mount_target_id: std::option::Option<std::string::String>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) life_cycle_state: std::option::Option<crate::model::LifeCycleState>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) availability_zone_id: std::option::Option<std::string::String>,
        pub(crate) availability_zone_name: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Web Services account ID that owns the resource.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>Amazon Web Services account ID that owns the resource.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>System-assigned mount target ID.</p>
        pub fn mount_target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.mount_target_id = Some(input.into());
            self
        }
        /// <p>System-assigned mount target ID.</p>
        pub fn set_mount_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mount_target_id = input;
            self
        }
        /// <p>The ID of the file system for which the mount target is intended.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system for which the mount target is intended.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The ID of the mount target's subnet.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the mount target's subnet.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>Lifecycle state of the mount target.</p>
        pub fn life_cycle_state(mut self, input: crate::model::LifeCycleState) -> Self {
            self.life_cycle_state = Some(input);
            self
        }
        /// <p>Lifecycle state of the mount target.</p>
        pub fn set_life_cycle_state(
            mut self,
            input: std::option::Option<crate::model::LifeCycleState>,
        ) -> Self {
            self.life_cycle_state = input;
            self
        }
        /// <p>Address at which the file system can be mounted by using the mount target.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>Address at which the file system can be mounted by using the mount target.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The ID of the network interface that Amazon EFS created when it created the mount target.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the network interface that Amazon EFS created when it created the mount target.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>The unique and consistent identifier of the Availability Zone that the mount target resides in. For example, <code>use1-az1</code> is an AZ ID for the us-east-1 Region and it has the same location in every Amazon Web Services account.</p>
        pub fn availability_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_id = Some(input.into());
            self
        }
        /// <p>The unique and consistent identifier of the Availability Zone that the mount target resides in. For example, <code>use1-az1</code> is an AZ ID for the us-east-1 Region and it has the same location in every Amazon Web Services account.</p>
        pub fn set_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_id = input;
            self
        }
        /// <p>The name of the Availability Zone in which the mount target is located. Availability Zones are independently mapped to names for each Amazon Web Services account. For example, the Availability Zone <code>us-east-1a</code> for your Amazon Web Services account might not be the same location as <code>us-east-1a</code> for another Amazon Web Services account.</p>
        pub fn availability_zone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_name = Some(input.into());
            self
        }
        /// <p>The name of the Availability Zone in which the mount target is located. Availability Zones are independently mapped to names for each Amazon Web Services account. For example, the Availability Zone <code>us-east-1a</code> for your Amazon Web Services account might not be the same location as <code>us-east-1a</code> for another Amazon Web Services account.</p>
        pub fn set_availability_zone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_name = input;
            self
        }
        /// <p>The virtual private cloud (VPC) ID that the mount target is configured in.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The virtual private cloud (VPC) ID that the mount target is configured in.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMountTargetOutput`](crate::output::CreateMountTargetOutput)
        pub fn build(self) -> crate::output::CreateMountTargetOutput {
            crate::output::CreateMountTargetOutput {
                owner_id: self.owner_id,
                mount_target_id: self.mount_target_id,
                file_system_id: self.file_system_id,
                subnet_id: self.subnet_id,
                life_cycle_state: self.life_cycle_state,
                ip_address: self.ip_address,
                network_interface_id: self.network_interface_id,
                availability_zone_id: self.availability_zone_id,
                availability_zone_name: self.availability_zone_name,
                vpc_id: self.vpc_id,
            }
        }
    }
}
impl CreateMountTargetOutput {
    /// Creates a new builder-style object to manufacture [`CreateMountTargetOutput`](crate::output::CreateMountTargetOutput)
    pub fn builder() -> crate::output::create_mount_target_output::Builder {
        crate::output::create_mount_target_output::Builder::default()
    }
}

/// <p>A description of the file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFileSystemOutput {
    /// <p>The Amazon Web Services account that created the file system. If the file system was created by an IAM user, the parent account to which the user belongs is the owner.</p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>The opaque string specified in the request.</p>
    pub creation_token: std::option::Option<std::string::String>,
    /// <p>The ID of the file system, assigned by Amazon EFS.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the EFS file system, in the format <code>arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i> </code>. Example with sample data: <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567</code> </p>
    pub file_system_arn: std::option::Option<std::string::String>,
    /// <p>The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The lifecycle phase of the file system.</p>
    pub life_cycle_state: std::option::Option<crate::model::LifeCycleState>,
    /// <p>You can add tags to a file system, including a <code>Name</code> tag. For more information, see <code>CreateFileSystem</code>. If the file system has a <code>Name</code> tag, Amazon EFS returns the value in this field. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current number of mount targets that the file system has. For more information, see <code>CreateMountTarget</code>.</p>
    pub number_of_mount_targets: i32,
    /// <p>The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code> field, and the time at which that size was determined in its <code>Timestamp</code> field. The <code>Timestamp</code> value is the integer number of seconds since 1970-01-01T00:00:00Z. The <code>SizeInBytes</code> value doesn't represent the size of a consistent snapshot of the file system, but it is eventually consistent when there are no writes to the file system. That is, <code>SizeInBytes</code> represents actual size only if the file system is not modified for a period longer than a couple of hours. Otherwise, the value is not the exact size that the file system was at any point in time. </p>
    pub size_in_bytes: std::option::Option<crate::model::FileSystemSize>,
    /// <p>The performance mode of the file system.</p>
    pub performance_mode: std::option::Option<crate::model::PerformanceMode>,
    /// <p>A Boolean value that, if true, indicates that the file system is encrypted.</p>
    pub encrypted: std::option::Option<bool>,
    /// <p>The ID of an KMS key used to protect the encrypted file system.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Displays the file system's throughput mode. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a> in the <i>Amazon EFS User Guide</i>. </p>
    pub throughput_mode: std::option::Option<crate::model::ThroughputMode>,
    /// <p>The amount of provisioned throughput, measured in MiB/s, for the file system. Valid for file systems using <code>ThroughputMode</code> set to <code>provisioned</code>.</p>
    pub provisioned_throughput_in_mibps: std::option::Option<f64>,
    /// <p>Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid only for file systems using One Zone storage classes. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p>
    pub availability_zone_name: std::option::Option<std::string::String>,
    /// <p>The unique and consistent identifier of the Availability Zone in which the file system's One Zone storage classes exist. For example, <code>use1-az1</code> is an Availability Zone ID for the us-east-1 Amazon Web Services Region, and it has the same location in every Amazon Web Services account.</p>
    pub availability_zone_id: std::option::Option<std::string::String>,
    /// <p>The tags associated with the file system, presented as an array of <code>Tag</code> objects.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateFileSystemOutput {
    /// <p>The Amazon Web Services account that created the file system. If the file system was created by an IAM user, the parent account to which the user belongs is the owner.</p>
    pub fn owner_id(&self) -> std::option::Option<&str> {
        self.owner_id.as_deref()
    }
    /// <p>The opaque string specified in the request.</p>
    pub fn creation_token(&self) -> std::option::Option<&str> {
        self.creation_token.as_deref()
    }
    /// <p>The ID of the file system, assigned by Amazon EFS.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the EFS file system, in the format <code>arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i> </code>. Example with sample data: <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567</code> </p>
    pub fn file_system_arn(&self) -> std::option::Option<&str> {
        self.file_system_arn.as_deref()
    }
    /// <p>The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The lifecycle phase of the file system.</p>
    pub fn life_cycle_state(&self) -> std::option::Option<&crate::model::LifeCycleState> {
        self.life_cycle_state.as_ref()
    }
    /// <p>You can add tags to a file system, including a <code>Name</code> tag. For more information, see <code>CreateFileSystem</code>. If the file system has a <code>Name</code> tag, Amazon EFS returns the value in this field. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current number of mount targets that the file system has. For more information, see <code>CreateMountTarget</code>.</p>
    pub fn number_of_mount_targets(&self) -> i32 {
        self.number_of_mount_targets
    }
    /// <p>The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code> field, and the time at which that size was determined in its <code>Timestamp</code> field. The <code>Timestamp</code> value is the integer number of seconds since 1970-01-01T00:00:00Z. The <code>SizeInBytes</code> value doesn't represent the size of a consistent snapshot of the file system, but it is eventually consistent when there are no writes to the file system. That is, <code>SizeInBytes</code> represents actual size only if the file system is not modified for a period longer than a couple of hours. Otherwise, the value is not the exact size that the file system was at any point in time. </p>
    pub fn size_in_bytes(&self) -> std::option::Option<&crate::model::FileSystemSize> {
        self.size_in_bytes.as_ref()
    }
    /// <p>The performance mode of the file system.</p>
    pub fn performance_mode(&self) -> std::option::Option<&crate::model::PerformanceMode> {
        self.performance_mode.as_ref()
    }
    /// <p>A Boolean value that, if true, indicates that the file system is encrypted.</p>
    pub fn encrypted(&self) -> std::option::Option<bool> {
        self.encrypted
    }
    /// <p>The ID of an KMS key used to protect the encrypted file system.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>Displays the file system's throughput mode. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a> in the <i>Amazon EFS User Guide</i>. </p>
    pub fn throughput_mode(&self) -> std::option::Option<&crate::model::ThroughputMode> {
        self.throughput_mode.as_ref()
    }
    /// <p>The amount of provisioned throughput, measured in MiB/s, for the file system. Valid for file systems using <code>ThroughputMode</code> set to <code>provisioned</code>.</p>
    pub fn provisioned_throughput_in_mibps(&self) -> std::option::Option<f64> {
        self.provisioned_throughput_in_mibps
    }
    /// <p>Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid only for file systems using One Zone storage classes. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p>
    pub fn availability_zone_name(&self) -> std::option::Option<&str> {
        self.availability_zone_name.as_deref()
    }
    /// <p>The unique and consistent identifier of the Availability Zone in which the file system's One Zone storage classes exist. For example, <code>use1-az1</code> is an Availability Zone ID for the us-east-1 Amazon Web Services Region, and it has the same location in every Amazon Web Services account.</p>
    pub fn availability_zone_id(&self) -> std::option::Option<&str> {
        self.availability_zone_id.as_deref()
    }
    /// <p>The tags associated with the file system, presented as an array of <code>Tag</code> objects.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateFileSystemOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFileSystemOutput");
        formatter.field("owner_id", &self.owner_id);
        formatter.field("creation_token", &self.creation_token);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("file_system_arn", &self.file_system_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("life_cycle_state", &self.life_cycle_state);
        formatter.field("name", &self.name);
        formatter.field("number_of_mount_targets", &self.number_of_mount_targets);
        formatter.field("size_in_bytes", &self.size_in_bytes);
        formatter.field("performance_mode", &self.performance_mode);
        formatter.field("encrypted", &self.encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("throughput_mode", &self.throughput_mode);
        formatter.field(
            "provisioned_throughput_in_mibps",
            &self.provisioned_throughput_in_mibps,
        );
        formatter.field("availability_zone_name", &self.availability_zone_name);
        formatter.field("availability_zone_id", &self.availability_zone_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateFileSystemOutput`](crate::output::CreateFileSystemOutput)
pub mod create_file_system_output {
    /// A builder for [`CreateFileSystemOutput`](crate::output::CreateFileSystemOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) creation_token: std::option::Option<std::string::String>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) file_system_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) life_cycle_state: std::option::Option<crate::model::LifeCycleState>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) number_of_mount_targets: std::option::Option<i32>,
        pub(crate) size_in_bytes: std::option::Option<crate::model::FileSystemSize>,
        pub(crate) performance_mode: std::option::Option<crate::model::PerformanceMode>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) throughput_mode: std::option::Option<crate::model::ThroughputMode>,
        pub(crate) provisioned_throughput_in_mibps: std::option::Option<f64>,
        pub(crate) availability_zone_name: std::option::Option<std::string::String>,
        pub(crate) availability_zone_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account that created the file system. If the file system was created by an IAM user, the parent account to which the user belongs is the owner.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account that created the file system. If the file system was created by an IAM user, the parent account to which the user belongs is the owner.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>The opaque string specified in the request.</p>
        pub fn creation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_token = Some(input.into());
            self
        }
        /// <p>The opaque string specified in the request.</p>
        pub fn set_creation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_token = input;
            self
        }
        /// <p>The ID of the file system, assigned by Amazon EFS.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system, assigned by Amazon EFS.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the EFS file system, in the format <code>arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i> </code>. Example with sample data: <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567</code> </p>
        pub fn file_system_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the EFS file system, in the format <code>arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i> </code>. Example with sample data: <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567</code> </p>
        pub fn set_file_system_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_arn = input;
            self
        }
        /// <p>The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The lifecycle phase of the file system.</p>
        pub fn life_cycle_state(mut self, input: crate::model::LifeCycleState) -> Self {
            self.life_cycle_state = Some(input);
            self
        }
        /// <p>The lifecycle phase of the file system.</p>
        pub fn set_life_cycle_state(
            mut self,
            input: std::option::Option<crate::model::LifeCycleState>,
        ) -> Self {
            self.life_cycle_state = input;
            self
        }
        /// <p>You can add tags to a file system, including a <code>Name</code> tag. For more information, see <code>CreateFileSystem</code>. If the file system has a <code>Name</code> tag, Amazon EFS returns the value in this field. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>You can add tags to a file system, including a <code>Name</code> tag. For more information, see <code>CreateFileSystem</code>. If the file system has a <code>Name</code> tag, Amazon EFS returns the value in this field. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current number of mount targets that the file system has. For more information, see <code>CreateMountTarget</code>.</p>
        pub fn number_of_mount_targets(mut self, input: i32) -> Self {
            self.number_of_mount_targets = Some(input);
            self
        }
        /// <p>The current number of mount targets that the file system has. For more information, see <code>CreateMountTarget</code>.</p>
        pub fn set_number_of_mount_targets(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_mount_targets = input;
            self
        }
        /// <p>The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code> field, and the time at which that size was determined in its <code>Timestamp</code> field. The <code>Timestamp</code> value is the integer number of seconds since 1970-01-01T00:00:00Z. The <code>SizeInBytes</code> value doesn't represent the size of a consistent snapshot of the file system, but it is eventually consistent when there are no writes to the file system. That is, <code>SizeInBytes</code> represents actual size only if the file system is not modified for a period longer than a couple of hours. Otherwise, the value is not the exact size that the file system was at any point in time. </p>
        pub fn size_in_bytes(mut self, input: crate::model::FileSystemSize) -> Self {
            self.size_in_bytes = Some(input);
            self
        }
        /// <p>The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code> field, and the time at which that size was determined in its <code>Timestamp</code> field. The <code>Timestamp</code> value is the integer number of seconds since 1970-01-01T00:00:00Z. The <code>SizeInBytes</code> value doesn't represent the size of a consistent snapshot of the file system, but it is eventually consistent when there are no writes to the file system. That is, <code>SizeInBytes</code> represents actual size only if the file system is not modified for a period longer than a couple of hours. Otherwise, the value is not the exact size that the file system was at any point in time. </p>
        pub fn set_size_in_bytes(
            mut self,
            input: std::option::Option<crate::model::FileSystemSize>,
        ) -> Self {
            self.size_in_bytes = input;
            self
        }
        /// <p>The performance mode of the file system.</p>
        pub fn performance_mode(mut self, input: crate::model::PerformanceMode) -> Self {
            self.performance_mode = Some(input);
            self
        }
        /// <p>The performance mode of the file system.</p>
        pub fn set_performance_mode(
            mut self,
            input: std::option::Option<crate::model::PerformanceMode>,
        ) -> Self {
            self.performance_mode = input;
            self
        }
        /// <p>A Boolean value that, if true, indicates that the file system is encrypted.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>A Boolean value that, if true, indicates that the file system is encrypted.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The ID of an KMS key used to protect the encrypted file system.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of an KMS key used to protect the encrypted file system.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Displays the file system's throughput mode. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a> in the <i>Amazon EFS User Guide</i>. </p>
        pub fn throughput_mode(mut self, input: crate::model::ThroughputMode) -> Self {
            self.throughput_mode = Some(input);
            self
        }
        /// <p>Displays the file system's throughput mode. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a> in the <i>Amazon EFS User Guide</i>. </p>
        pub fn set_throughput_mode(
            mut self,
            input: std::option::Option<crate::model::ThroughputMode>,
        ) -> Self {
            self.throughput_mode = input;
            self
        }
        /// <p>The amount of provisioned throughput, measured in MiB/s, for the file system. Valid for file systems using <code>ThroughputMode</code> set to <code>provisioned</code>.</p>
        pub fn provisioned_throughput_in_mibps(mut self, input: f64) -> Self {
            self.provisioned_throughput_in_mibps = Some(input);
            self
        }
        /// <p>The amount of provisioned throughput, measured in MiB/s, for the file system. Valid for file systems using <code>ThroughputMode</code> set to <code>provisioned</code>.</p>
        pub fn set_provisioned_throughput_in_mibps(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.provisioned_throughput_in_mibps = input;
            self
        }
        /// <p>Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid only for file systems using One Zone storage classes. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p>
        pub fn availability_zone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_name = Some(input.into());
            self
        }
        /// <p>Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid only for file systems using One Zone storage classes. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p>
        pub fn set_availability_zone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_name = input;
            self
        }
        /// <p>The unique and consistent identifier of the Availability Zone in which the file system's One Zone storage classes exist. For example, <code>use1-az1</code> is an Availability Zone ID for the us-east-1 Amazon Web Services Region, and it has the same location in every Amazon Web Services account.</p>
        pub fn availability_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_id = Some(input.into());
            self
        }
        /// <p>The unique and consistent identifier of the Availability Zone in which the file system's One Zone storage classes exist. For example, <code>use1-az1</code> is an Availability Zone ID for the us-east-1 Amazon Web Services Region, and it has the same location in every Amazon Web Services account.</p>
        pub fn set_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the file system, presented as an array of <code>Tag</code> objects.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the file system, presented as an array of <code>Tag</code> objects.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFileSystemOutput`](crate::output::CreateFileSystemOutput)
        pub fn build(self) -> crate::output::CreateFileSystemOutput {
            crate::output::CreateFileSystemOutput {
                owner_id: self.owner_id,
                creation_token: self.creation_token,
                file_system_id: self.file_system_id,
                file_system_arn: self.file_system_arn,
                creation_time: self.creation_time,
                life_cycle_state: self.life_cycle_state,
                name: self.name,
                number_of_mount_targets: self.number_of_mount_targets.unwrap_or_default(),
                size_in_bytes: self.size_in_bytes,
                performance_mode: self.performance_mode,
                encrypted: self.encrypted,
                kms_key_id: self.kms_key_id,
                throughput_mode: self.throughput_mode,
                provisioned_throughput_in_mibps: self.provisioned_throughput_in_mibps,
                availability_zone_name: self.availability_zone_name,
                availability_zone_id: self.availability_zone_id,
                tags: self.tags,
            }
        }
    }
}
impl CreateFileSystemOutput {
    /// Creates a new builder-style object to manufacture [`CreateFileSystemOutput`](crate::output::CreateFileSystemOutput)
    pub fn builder() -> crate::output::create_file_system_output::Builder {
        crate::output::create_file_system_output::Builder::default()
    }
}

/// <p>Provides a description of an EFS file system access point.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccessPointOutput {
    /// <p>The opaque string specified in the request to ensure idempotent creation.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The name of the access point. This is the value of the <code>Name</code> tag.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The tags associated with the access point, presented as an array of Tag objects.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The ID of the access point, assigned by Amazon EFS.</p>
    pub access_point_id: std::option::Option<std::string::String>,
    /// <p>The unique Amazon Resource Name (ARN) associated with the access point.</p>
    pub access_point_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the EFS file system that the access point applies to.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point that is used for all file operations by NFS clients using the access point.</p>
    pub posix_user: std::option::Option<crate::model::PosixUser>,
    /// <p>The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS clients using the access point.</p>
    pub root_directory: std::option::Option<crate::model::RootDirectory>,
    /// <p>Identified the Amazon Web Services account that owns the access point resource.</p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>Identifies the lifecycle phase of the access point.</p>
    pub life_cycle_state: std::option::Option<crate::model::LifeCycleState>,
}
impl CreateAccessPointOutput {
    /// <p>The opaque string specified in the request to ensure idempotent creation.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The name of the access point. This is the value of the <code>Name</code> tag.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The tags associated with the access point, presented as an array of Tag objects.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The ID of the access point, assigned by Amazon EFS.</p>
    pub fn access_point_id(&self) -> std::option::Option<&str> {
        self.access_point_id.as_deref()
    }
    /// <p>The unique Amazon Resource Name (ARN) associated with the access point.</p>
    pub fn access_point_arn(&self) -> std::option::Option<&str> {
        self.access_point_arn.as_deref()
    }
    /// <p>The ID of the EFS file system that the access point applies to.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point that is used for all file operations by NFS clients using the access point.</p>
    pub fn posix_user(&self) -> std::option::Option<&crate::model::PosixUser> {
        self.posix_user.as_ref()
    }
    /// <p>The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS clients using the access point.</p>
    pub fn root_directory(&self) -> std::option::Option<&crate::model::RootDirectory> {
        self.root_directory.as_ref()
    }
    /// <p>Identified the Amazon Web Services account that owns the access point resource.</p>
    pub fn owner_id(&self) -> std::option::Option<&str> {
        self.owner_id.as_deref()
    }
    /// <p>Identifies the lifecycle phase of the access point.</p>
    pub fn life_cycle_state(&self) -> std::option::Option<&crate::model::LifeCycleState> {
        self.life_cycle_state.as_ref()
    }
}
impl std::fmt::Debug for CreateAccessPointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccessPointOutput");
        formatter.field("client_token", &self.client_token);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.field("access_point_id", &self.access_point_id);
        formatter.field("access_point_arn", &self.access_point_arn);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("posix_user", &self.posix_user);
        formatter.field("root_directory", &self.root_directory);
        formatter.field("owner_id", &self.owner_id);
        formatter.field("life_cycle_state", &self.life_cycle_state);
        formatter.finish()
    }
}
/// See [`CreateAccessPointOutput`](crate::output::CreateAccessPointOutput)
pub mod create_access_point_output {
    /// A builder for [`CreateAccessPointOutput`](crate::output::CreateAccessPointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) access_point_id: std::option::Option<std::string::String>,
        pub(crate) access_point_arn: std::option::Option<std::string::String>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) posix_user: std::option::Option<crate::model::PosixUser>,
        pub(crate) root_directory: std::option::Option<crate::model::RootDirectory>,
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) life_cycle_state: std::option::Option<crate::model::LifeCycleState>,
    }
    impl Builder {
        /// <p>The opaque string specified in the request to ensure idempotent creation.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The opaque string specified in the request to ensure idempotent creation.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The name of the access point. This is the value of the <code>Name</code> tag.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the access point. This is the value of the <code>Name</code> tag.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the access point, presented as an array of Tag objects.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the access point, presented as an array of Tag objects.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The ID of the access point, assigned by Amazon EFS.</p>
        pub fn access_point_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_point_id = Some(input.into());
            self
        }
        /// <p>The ID of the access point, assigned by Amazon EFS.</p>
        pub fn set_access_point_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_point_id = input;
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) associated with the access point.</p>
        pub fn access_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_point_arn = Some(input.into());
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) associated with the access point.</p>
        pub fn set_access_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_point_arn = input;
            self
        }
        /// <p>The ID of the EFS file system that the access point applies to.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the EFS file system that the access point applies to.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point that is used for all file operations by NFS clients using the access point.</p>
        pub fn posix_user(mut self, input: crate::model::PosixUser) -> Self {
            self.posix_user = Some(input);
            self
        }
        /// <p>The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point that is used for all file operations by NFS clients using the access point.</p>
        pub fn set_posix_user(
            mut self,
            input: std::option::Option<crate::model::PosixUser>,
        ) -> Self {
            self.posix_user = input;
            self
        }
        /// <p>The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS clients using the access point.</p>
        pub fn root_directory(mut self, input: crate::model::RootDirectory) -> Self {
            self.root_directory = Some(input);
            self
        }
        /// <p>The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS clients using the access point.</p>
        pub fn set_root_directory(
            mut self,
            input: std::option::Option<crate::model::RootDirectory>,
        ) -> Self {
            self.root_directory = input;
            self
        }
        /// <p>Identified the Amazon Web Services account that owns the access point resource.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>Identified the Amazon Web Services account that owns the access point resource.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>Identifies the lifecycle phase of the access point.</p>
        pub fn life_cycle_state(mut self, input: crate::model::LifeCycleState) -> Self {
            self.life_cycle_state = Some(input);
            self
        }
        /// <p>Identifies the lifecycle phase of the access point.</p>
        pub fn set_life_cycle_state(
            mut self,
            input: std::option::Option<crate::model::LifeCycleState>,
        ) -> Self {
            self.life_cycle_state = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccessPointOutput`](crate::output::CreateAccessPointOutput)
        pub fn build(self) -> crate::output::CreateAccessPointOutput {
            crate::output::CreateAccessPointOutput {
                client_token: self.client_token,
                name: self.name,
                tags: self.tags,
                access_point_id: self.access_point_id,
                access_point_arn: self.access_point_arn,
                file_system_id: self.file_system_id,
                posix_user: self.posix_user,
                root_directory: self.root_directory,
                owner_id: self.owner_id,
                life_cycle_state: self.life_cycle_state,
            }
        }
    }
}
impl CreateAccessPointOutput {
    /// Creates a new builder-style object to manufacture [`CreateAccessPointOutput`](crate::output::CreateAccessPointOutput)
    pub fn builder() -> crate::output::create_access_point_output::Builder {
        crate::output::create_access_point_output::Builder::default()
    }
}
