// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateAccessPoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_access_point`](crate::client::Client::create_access_point).
///
/// See [`crate::client::fluent_builders::CreateAccessPoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAccessPoint {
    _private: (),
}
impl CreateAccessPoint {
    /// Creates a new builder-style object to manufacture [`CreateAccessPointInput`](crate::input::CreateAccessPointInput)
    pub fn builder() -> crate::input::create_access_point_input::Builder {
        crate::input::create_access_point_input::Builder::default()
    }
    /// Creates a new `CreateAccessPoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAccessPoint {
    type Output = std::result::Result<
        crate::output::CreateAccessPointOutput,
        crate::error::CreateAccessPointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_access_point_error(response)
        } else {
            crate::operation_deser::parse_create_access_point_response(response)
        }
    }
}

/// Operation shape for `CreateFileSystem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_file_system`](crate::client::Client::create_file_system).
///
/// See [`crate::client::fluent_builders::CreateFileSystem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFileSystem {
    _private: (),
}
impl CreateFileSystem {
    /// Creates a new builder-style object to manufacture [`CreateFileSystemInput`](crate::input::CreateFileSystemInput)
    pub fn builder() -> crate::input::create_file_system_input::Builder {
        crate::input::create_file_system_input::Builder::default()
    }
    /// Creates a new `CreateFileSystem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFileSystem {
    type Output = std::result::Result<
        crate::output::CreateFileSystemOutput,
        crate::error::CreateFileSystemError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_file_system_error(response)
        } else {
            crate::operation_deser::parse_create_file_system_response(response)
        }
    }
}

/// Operation shape for `CreateMountTarget`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_mount_target`](crate::client::Client::create_mount_target).
///
/// See [`crate::client::fluent_builders::CreateMountTarget`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMountTarget {
    _private: (),
}
impl CreateMountTarget {
    /// Creates a new builder-style object to manufacture [`CreateMountTargetInput`](crate::input::CreateMountTargetInput)
    pub fn builder() -> crate::input::create_mount_target_input::Builder {
        crate::input::create_mount_target_input::Builder::default()
    }
    /// Creates a new `CreateMountTarget` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMountTarget {
    type Output = std::result::Result<
        crate::output::CreateMountTargetOutput,
        crate::error::CreateMountTargetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_mount_target_error(response)
        } else {
            crate::operation_deser::parse_create_mount_target_response(response)
        }
    }
}

/// Operation shape for `CreateReplicationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_replication_configuration`](crate::client::Client::create_replication_configuration).
///
/// See [`crate::client::fluent_builders::CreateReplicationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateReplicationConfiguration {
    _private: (),
}
impl CreateReplicationConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateReplicationConfigurationInput`](crate::input::CreateReplicationConfigurationInput)
    pub fn builder() -> crate::input::create_replication_configuration_input::Builder {
        crate::input::create_replication_configuration_input::Builder::default()
    }
    /// Creates a new `CreateReplicationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateReplicationConfiguration {
    type Output = std::result::Result<
        crate::output::CreateReplicationConfigurationOutput,
        crate::error::CreateReplicationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_replication_configuration_error(response)
        } else {
            crate::operation_deser::parse_create_replication_configuration_response(response)
        }
    }
}

/// Operation shape for `CreateTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_tags`](crate::client::Client::create_tags).
///
/// See [`crate::client::fluent_builders::CreateTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTags {
    _private: (),
}
impl CreateTags {
    /// Creates a new builder-style object to manufacture [`CreateTagsInput`](crate::input::CreateTagsInput)
    pub fn builder() -> crate::input::create_tags_input::Builder {
        crate::input::create_tags_input::Builder::default()
    }
    /// Creates a new `CreateTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTags {
    type Output =
        std::result::Result<crate::output::CreateTagsOutput, crate::error::CreateTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_create_tags_error(response)
        } else {
            crate::operation_deser::parse_create_tags_response(response)
        }
    }
}

/// Operation shape for `DeleteAccessPoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_access_point`](crate::client::Client::delete_access_point).
///
/// See [`crate::client::fluent_builders::DeleteAccessPoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAccessPoint {
    _private: (),
}
impl DeleteAccessPoint {
    /// Creates a new builder-style object to manufacture [`DeleteAccessPointInput`](crate::input::DeleteAccessPointInput)
    pub fn builder() -> crate::input::delete_access_point_input::Builder {
        crate::input::delete_access_point_input::Builder::default()
    }
    /// Creates a new `DeleteAccessPoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAccessPoint {
    type Output = std::result::Result<
        crate::output::DeleteAccessPointOutput,
        crate::error::DeleteAccessPointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_access_point_error(response)
        } else {
            crate::operation_deser::parse_delete_access_point_response(response)
        }
    }
}

/// Operation shape for `DeleteFileSystem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_file_system`](crate::client::Client::delete_file_system).
///
/// See [`crate::client::fluent_builders::DeleteFileSystem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFileSystem {
    _private: (),
}
impl DeleteFileSystem {
    /// Creates a new builder-style object to manufacture [`DeleteFileSystemInput`](crate::input::DeleteFileSystemInput)
    pub fn builder() -> crate::input::delete_file_system_input::Builder {
        crate::input::delete_file_system_input::Builder::default()
    }
    /// Creates a new `DeleteFileSystem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFileSystem {
    type Output = std::result::Result<
        crate::output::DeleteFileSystemOutput,
        crate::error::DeleteFileSystemError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_file_system_error(response)
        } else {
            crate::operation_deser::parse_delete_file_system_response(response)
        }
    }
}

/// Operation shape for `DeleteFileSystemPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_file_system_policy`](crate::client::Client::delete_file_system_policy).
///
/// See [`crate::client::fluent_builders::DeleteFileSystemPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFileSystemPolicy {
    _private: (),
}
impl DeleteFileSystemPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteFileSystemPolicyInput`](crate::input::DeleteFileSystemPolicyInput)
    pub fn builder() -> crate::input::delete_file_system_policy_input::Builder {
        crate::input::delete_file_system_policy_input::Builder::default()
    }
    /// Creates a new `DeleteFileSystemPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFileSystemPolicy {
    type Output = std::result::Result<
        crate::output::DeleteFileSystemPolicyOutput,
        crate::error::DeleteFileSystemPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_file_system_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_file_system_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteMountTarget`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_mount_target`](crate::client::Client::delete_mount_target).
///
/// See [`crate::client::fluent_builders::DeleteMountTarget`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMountTarget {
    _private: (),
}
impl DeleteMountTarget {
    /// Creates a new builder-style object to manufacture [`DeleteMountTargetInput`](crate::input::DeleteMountTargetInput)
    pub fn builder() -> crate::input::delete_mount_target_input::Builder {
        crate::input::delete_mount_target_input::Builder::default()
    }
    /// Creates a new `DeleteMountTarget` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMountTarget {
    type Output = std::result::Result<
        crate::output::DeleteMountTargetOutput,
        crate::error::DeleteMountTargetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_mount_target_error(response)
        } else {
            crate::operation_deser::parse_delete_mount_target_response(response)
        }
    }
}

/// Operation shape for `DeleteReplicationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_replication_configuration`](crate::client::Client::delete_replication_configuration).
///
/// See [`crate::client::fluent_builders::DeleteReplicationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteReplicationConfiguration {
    _private: (),
}
impl DeleteReplicationConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteReplicationConfigurationInput`](crate::input::DeleteReplicationConfigurationInput)
    pub fn builder() -> crate::input::delete_replication_configuration_input::Builder {
        crate::input::delete_replication_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteReplicationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteReplicationConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteReplicationConfigurationOutput,
        crate::error::DeleteReplicationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_replication_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_replication_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_tags`](crate::client::Client::delete_tags).
///
/// See [`crate::client::fluent_builders::DeleteTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTags {
    _private: (),
}
impl DeleteTags {
    /// Creates a new builder-style object to manufacture [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    pub fn builder() -> crate::input::delete_tags_input::Builder {
        crate::input::delete_tags_input::Builder::default()
    }
    /// Creates a new `DeleteTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTags {
    type Output =
        std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_tags_error(response)
        } else {
            crate::operation_deser::parse_delete_tags_response(response)
        }
    }
}

/// Operation shape for `DescribeAccessPoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_access_points`](crate::client::Client::describe_access_points).
///
/// See [`crate::client::fluent_builders::DescribeAccessPoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccessPoints {
    _private: (),
}
impl DescribeAccessPoints {
    /// Creates a new builder-style object to manufacture [`DescribeAccessPointsInput`](crate::input::DescribeAccessPointsInput)
    pub fn builder() -> crate::input::describe_access_points_input::Builder {
        crate::input::describe_access_points_input::Builder::default()
    }
    /// Creates a new `DescribeAccessPoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccessPoints {
    type Output = std::result::Result<
        crate::output::DescribeAccessPointsOutput,
        crate::error::DescribeAccessPointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_access_points_error(response)
        } else {
            crate::operation_deser::parse_describe_access_points_response(response)
        }
    }
}

/// Operation shape for `DescribeAccountPreferences`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account_preferences`](crate::client::Client::describe_account_preferences).
///
/// See [`crate::client::fluent_builders::DescribeAccountPreferences`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccountPreferences {
    _private: (),
}
impl DescribeAccountPreferences {
    /// Creates a new builder-style object to manufacture [`DescribeAccountPreferencesInput`](crate::input::DescribeAccountPreferencesInput)
    pub fn builder() -> crate::input::describe_account_preferences_input::Builder {
        crate::input::describe_account_preferences_input::Builder::default()
    }
    /// Creates a new `DescribeAccountPreferences` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccountPreferences {
    type Output = std::result::Result<
        crate::output::DescribeAccountPreferencesOutput,
        crate::error::DescribeAccountPreferencesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_preferences_error(response)
        } else {
            crate::operation_deser::parse_describe_account_preferences_response(response)
        }
    }
}

/// Operation shape for `DescribeBackupPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_backup_policy`](crate::client::Client::describe_backup_policy).
///
/// See [`crate::client::fluent_builders::DescribeBackupPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeBackupPolicy {
    _private: (),
}
impl DescribeBackupPolicy {
    /// Creates a new builder-style object to manufacture [`DescribeBackupPolicyInput`](crate::input::DescribeBackupPolicyInput)
    pub fn builder() -> crate::input::describe_backup_policy_input::Builder {
        crate::input::describe_backup_policy_input::Builder::default()
    }
    /// Creates a new `DescribeBackupPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeBackupPolicy {
    type Output = std::result::Result<
        crate::output::DescribeBackupPolicyOutput,
        crate::error::DescribeBackupPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_backup_policy_error(response)
        } else {
            crate::operation_deser::parse_describe_backup_policy_response(response)
        }
    }
}

/// Operation shape for `DescribeFileSystemPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_file_system_policy`](crate::client::Client::describe_file_system_policy).
///
/// See [`crate::client::fluent_builders::DescribeFileSystemPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFileSystemPolicy {
    _private: (),
}
impl DescribeFileSystemPolicy {
    /// Creates a new builder-style object to manufacture [`DescribeFileSystemPolicyInput`](crate::input::DescribeFileSystemPolicyInput)
    pub fn builder() -> crate::input::describe_file_system_policy_input::Builder {
        crate::input::describe_file_system_policy_input::Builder::default()
    }
    /// Creates a new `DescribeFileSystemPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFileSystemPolicy {
    type Output = std::result::Result<
        crate::output::DescribeFileSystemPolicyOutput,
        crate::error::DescribeFileSystemPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_file_system_policy_error(response)
        } else {
            crate::operation_deser::parse_describe_file_system_policy_response(response)
        }
    }
}

/// Operation shape for `DescribeFileSystems`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_file_systems`](crate::client::Client::describe_file_systems).
///
/// See [`crate::client::fluent_builders::DescribeFileSystems`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFileSystems {
    _private: (),
}
impl DescribeFileSystems {
    /// Creates a new builder-style object to manufacture [`DescribeFileSystemsInput`](crate::input::DescribeFileSystemsInput)
    pub fn builder() -> crate::input::describe_file_systems_input::Builder {
        crate::input::describe_file_systems_input::Builder::default()
    }
    /// Creates a new `DescribeFileSystems` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFileSystems {
    type Output = std::result::Result<
        crate::output::DescribeFileSystemsOutput,
        crate::error::DescribeFileSystemsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_file_systems_error(response)
        } else {
            crate::operation_deser::parse_describe_file_systems_response(response)
        }
    }
}

/// Operation shape for `DescribeLifecycleConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_lifecycle_configuration`](crate::client::Client::describe_lifecycle_configuration).
///
/// See [`crate::client::fluent_builders::DescribeLifecycleConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLifecycleConfiguration {
    _private: (),
}
impl DescribeLifecycleConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeLifecycleConfigurationInput`](crate::input::DescribeLifecycleConfigurationInput)
    pub fn builder() -> crate::input::describe_lifecycle_configuration_input::Builder {
        crate::input::describe_lifecycle_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeLifecycleConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLifecycleConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeLifecycleConfigurationOutput,
        crate::error::DescribeLifecycleConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_lifecycle_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_lifecycle_configuration_response(response)
        }
    }
}

/// Operation shape for `DescribeMountTargets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_mount_targets`](crate::client::Client::describe_mount_targets).
///
/// See [`crate::client::fluent_builders::DescribeMountTargets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMountTargets {
    _private: (),
}
impl DescribeMountTargets {
    /// Creates a new builder-style object to manufacture [`DescribeMountTargetsInput`](crate::input::DescribeMountTargetsInput)
    pub fn builder() -> crate::input::describe_mount_targets_input::Builder {
        crate::input::describe_mount_targets_input::Builder::default()
    }
    /// Creates a new `DescribeMountTargets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMountTargets {
    type Output = std::result::Result<
        crate::output::DescribeMountTargetsOutput,
        crate::error::DescribeMountTargetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_mount_targets_error(response)
        } else {
            crate::operation_deser::parse_describe_mount_targets_response(response)
        }
    }
}

/// Operation shape for `DescribeMountTargetSecurityGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_mount_target_security_groups`](crate::client::Client::describe_mount_target_security_groups).
///
/// See [`crate::client::fluent_builders::DescribeMountTargetSecurityGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMountTargetSecurityGroups {
    _private: (),
}
impl DescribeMountTargetSecurityGroups {
    /// Creates a new builder-style object to manufacture [`DescribeMountTargetSecurityGroupsInput`](crate::input::DescribeMountTargetSecurityGroupsInput)
    pub fn builder() -> crate::input::describe_mount_target_security_groups_input::Builder {
        crate::input::describe_mount_target_security_groups_input::Builder::default()
    }
    /// Creates a new `DescribeMountTargetSecurityGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMountTargetSecurityGroups {
    type Output = std::result::Result<
        crate::output::DescribeMountTargetSecurityGroupsOutput,
        crate::error::DescribeMountTargetSecurityGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_mount_target_security_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_mount_target_security_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeReplicationConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_replication_configurations`](crate::client::Client::describe_replication_configurations).
///
/// See [`crate::client::fluent_builders::DescribeReplicationConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReplicationConfigurations {
    _private: (),
}
impl DescribeReplicationConfigurations {
    /// Creates a new builder-style object to manufacture [`DescribeReplicationConfigurationsInput`](crate::input::DescribeReplicationConfigurationsInput)
    pub fn builder() -> crate::input::describe_replication_configurations_input::Builder {
        crate::input::describe_replication_configurations_input::Builder::default()
    }
    /// Creates a new `DescribeReplicationConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReplicationConfigurations {
    type Output = std::result::Result<
        crate::output::DescribeReplicationConfigurationsOutput,
        crate::error::DescribeReplicationConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_replication_configurations_error(response)
        } else {
            crate::operation_deser::parse_describe_replication_configurations_response(response)
        }
    }
}

/// Operation shape for `DescribeTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_tags`](crate::client::Client::describe_tags).
///
/// See [`crate::client::fluent_builders::DescribeTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTags {
    _private: (),
}
impl DescribeTags {
    /// Creates a new builder-style object to manufacture [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    pub fn builder() -> crate::input::describe_tags_input::Builder {
        crate::input::describe_tags_input::Builder::default()
    }
    /// Creates a new `DescribeTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTags {
    type Output =
        std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_tags_error(response)
        } else {
            crate::operation_deser::parse_describe_tags_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ModifyMountTargetSecurityGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_mount_target_security_groups`](crate::client::Client::modify_mount_target_security_groups).
///
/// See [`crate::client::fluent_builders::ModifyMountTargetSecurityGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyMountTargetSecurityGroups {
    _private: (),
}
impl ModifyMountTargetSecurityGroups {
    /// Creates a new builder-style object to manufacture [`ModifyMountTargetSecurityGroupsInput`](crate::input::ModifyMountTargetSecurityGroupsInput)
    pub fn builder() -> crate::input::modify_mount_target_security_groups_input::Builder {
        crate::input::modify_mount_target_security_groups_input::Builder::default()
    }
    /// Creates a new `ModifyMountTargetSecurityGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyMountTargetSecurityGroups {
    type Output = std::result::Result<
        crate::output::ModifyMountTargetSecurityGroupsOutput,
        crate::error::ModifyMountTargetSecurityGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_modify_mount_target_security_groups_error(response)
        } else {
            crate::operation_deser::parse_modify_mount_target_security_groups_response(response)
        }
    }
}

/// Operation shape for `PutAccountPreferences`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_account_preferences`](crate::client::Client::put_account_preferences).
///
/// See [`crate::client::fluent_builders::PutAccountPreferences`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAccountPreferences {
    _private: (),
}
impl PutAccountPreferences {
    /// Creates a new builder-style object to manufacture [`PutAccountPreferencesInput`](crate::input::PutAccountPreferencesInput)
    pub fn builder() -> crate::input::put_account_preferences_input::Builder {
        crate::input::put_account_preferences_input::Builder::default()
    }
    /// Creates a new `PutAccountPreferences` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAccountPreferences {
    type Output = std::result::Result<
        crate::output::PutAccountPreferencesOutput,
        crate::error::PutAccountPreferencesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_account_preferences_error(response)
        } else {
            crate::operation_deser::parse_put_account_preferences_response(response)
        }
    }
}

/// Operation shape for `PutBackupPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_backup_policy`](crate::client::Client::put_backup_policy).
///
/// See [`crate::client::fluent_builders::PutBackupPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBackupPolicy {
    _private: (),
}
impl PutBackupPolicy {
    /// Creates a new builder-style object to manufacture [`PutBackupPolicyInput`](crate::input::PutBackupPolicyInput)
    pub fn builder() -> crate::input::put_backup_policy_input::Builder {
        crate::input::put_backup_policy_input::Builder::default()
    }
    /// Creates a new `PutBackupPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBackupPolicy {
    type Output = std::result::Result<
        crate::output::PutBackupPolicyOutput,
        crate::error::PutBackupPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_backup_policy_error(response)
        } else {
            crate::operation_deser::parse_put_backup_policy_response(response)
        }
    }
}

/// Operation shape for `PutFileSystemPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_file_system_policy`](crate::client::Client::put_file_system_policy).
///
/// See [`crate::client::fluent_builders::PutFileSystemPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutFileSystemPolicy {
    _private: (),
}
impl PutFileSystemPolicy {
    /// Creates a new builder-style object to manufacture [`PutFileSystemPolicyInput`](crate::input::PutFileSystemPolicyInput)
    pub fn builder() -> crate::input::put_file_system_policy_input::Builder {
        crate::input::put_file_system_policy_input::Builder::default()
    }
    /// Creates a new `PutFileSystemPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutFileSystemPolicy {
    type Output = std::result::Result<
        crate::output::PutFileSystemPolicyOutput,
        crate::error::PutFileSystemPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_file_system_policy_error(response)
        } else {
            crate::operation_deser::parse_put_file_system_policy_response(response)
        }
    }
}

/// Operation shape for `PutLifecycleConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_lifecycle_configuration`](crate::client::Client::put_lifecycle_configuration).
///
/// See [`crate::client::fluent_builders::PutLifecycleConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutLifecycleConfiguration {
    _private: (),
}
impl PutLifecycleConfiguration {
    /// Creates a new builder-style object to manufacture [`PutLifecycleConfigurationInput`](crate::input::PutLifecycleConfigurationInput)
    pub fn builder() -> crate::input::put_lifecycle_configuration_input::Builder {
        crate::input::put_lifecycle_configuration_input::Builder::default()
    }
    /// Creates a new `PutLifecycleConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutLifecycleConfiguration {
    type Output = std::result::Result<
        crate::output::PutLifecycleConfigurationOutput,
        crate::error::PutLifecycleConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_lifecycle_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_lifecycle_configuration_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateFileSystem`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_file_system`](crate::client::Client::update_file_system).
///
/// See [`crate::client::fluent_builders::UpdateFileSystem`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFileSystem {
    _private: (),
}
impl UpdateFileSystem {
    /// Creates a new builder-style object to manufacture [`UpdateFileSystemInput`](crate::input::UpdateFileSystemInput)
    pub fn builder() -> crate::input::update_file_system_input::Builder {
        crate::input::update_file_system_input::Builder::default()
    }
    /// Creates a new `UpdateFileSystem` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFileSystem {
    type Output = std::result::Result<
        crate::output::UpdateFileSystemOutput,
        crate::error::UpdateFileSystemError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_file_system_error(response)
        } else {
            crate::operation_deser::parse_update_file_system_response(response)
        }
    }
}
