// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_access_point_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAccessPointOutput, crate::error::CreateAccessPointError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAccessPointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateAccessPointError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessPointAlreadyExists" => crate::error::CreateAccessPointError {
            meta: generic,
            kind: crate::error::CreateAccessPointErrorKind::AccessPointAlreadyExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_point_already_exists::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_point_already_exists_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAccessPointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccessPointLimitExceeded" => crate::error::CreateAccessPointError {
            meta: generic,
            kind: crate::error::CreateAccessPointErrorKind::AccessPointLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_point_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_point_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAccessPointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BadRequest" => crate::error::CreateAccessPointError {
            meta: generic,
            kind: crate::error::CreateAccessPointErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateAccessPointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::CreateAccessPointError {
            meta: generic,
            kind: crate::error::CreateAccessPointErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAccessPointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncorrectFileSystemLifeCycleState" => crate::error::CreateAccessPointError {
            meta: generic,
            kind: crate::error::CreateAccessPointErrorKind::IncorrectFileSystemLifeCycleState({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::incorrect_file_system_life_cycle_state::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incorrect_file_system_life_cycle_state_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAccessPointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::CreateAccessPointError {
            meta: generic,
            kind: crate::error::CreateAccessPointErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAccessPointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateAccessPointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_access_point_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAccessPointOutput, crate::error::CreateAccessPointError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_access_point_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_access_point(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAccessPointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_file_system_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateFileSystemOutput, crate::error::CreateFileSystemError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateFileSystemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateFileSystemError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::CreateFileSystemError {
            meta: generic,
            kind: crate::error::CreateFileSystemErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemAlreadyExists" => crate::error::CreateFileSystemError {
            meta: generic,
            kind: crate::error::CreateFileSystemErrorKind::FileSystemAlreadyExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_already_exists::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_already_exists_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemLimitExceeded" => crate::error::CreateFileSystemError {
            meta: generic,
            kind: crate::error::CreateFileSystemErrorKind::FileSystemLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientThroughputCapacity" => crate::error::CreateFileSystemError {
            meta: generic,
            kind: crate::error::CreateFileSystemErrorKind::InsufficientThroughputCapacity({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_throughput_capacity::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_throughput_capacity_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::CreateFileSystemError {
            meta: generic,
            kind: crate::error::CreateFileSystemErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThroughputLimitExceeded" => crate::error::CreateFileSystemError {
            meta: generic,
            kind: crate::error::CreateFileSystemErrorKind::ThroughputLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throughput_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throughput_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedAvailabilityZone" => crate::error::CreateFileSystemError {
            meta: generic,
            kind: crate::error::CreateFileSystemErrorKind::UnsupportedAvailabilityZone({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_availability_zone::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_availability_zone_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateFileSystemError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_file_system_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateFileSystemOutput, crate::error::CreateFileSystemError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_file_system_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_file_system(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateFileSystemError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_mount_target_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateMountTargetOutput, crate::error::CreateMountTargetError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateMountTargetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateMountTargetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AvailabilityZonesMismatch" => crate::error::CreateMountTargetError {
            meta: generic,
            kind: crate::error::CreateMountTargetErrorKind::AvailabilityZonesMismatch({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::availability_zones_mismatch::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_availability_zones_mismatch_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMountTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BadRequest" => crate::error::CreateMountTargetError {
            meta: generic,
            kind: crate::error::CreateMountTargetErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateMountTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::CreateMountTargetError {
            meta: generic,
            kind: crate::error::CreateMountTargetErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMountTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncorrectFileSystemLifeCycleState" => crate::error::CreateMountTargetError {
            meta: generic,
            kind: crate::error::CreateMountTargetErrorKind::IncorrectFileSystemLifeCycleState({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::incorrect_file_system_life_cycle_state::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incorrect_file_system_life_cycle_state_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMountTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::CreateMountTargetError {
            meta: generic,
            kind: crate::error::CreateMountTargetErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMountTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IpAddressInUse" => {
            crate::error::CreateMountTargetError {
                meta: generic,
                kind: crate::error::CreateMountTargetErrorKind::IpAddressInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::ip_address_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_ip_address_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMountTargetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "MountTargetConflict" => crate::error::CreateMountTargetError {
            meta: generic,
            kind: crate::error::CreateMountTargetErrorKind::MountTargetConflict({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::mount_target_conflict::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_mount_target_conflict_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMountTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NetworkInterfaceLimitExceeded" => crate::error::CreateMountTargetError {
            meta: generic,
            kind: crate::error::CreateMountTargetErrorKind::NetworkInterfaceLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::network_interface_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_network_interface_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMountTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoFreeAddressesInSubnet" => crate::error::CreateMountTargetError {
            meta: generic,
            kind: crate::error::CreateMountTargetErrorKind::NoFreeAddressesInSubnet({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_free_addresses_in_subnet::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_no_free_addresses_in_subnet_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMountTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SecurityGroupLimitExceeded" => crate::error::CreateMountTargetError {
            meta: generic,
            kind: crate::error::CreateMountTargetErrorKind::SecurityGroupLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::security_group_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_security_group_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMountTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SecurityGroupNotFound" => crate::error::CreateMountTargetError {
            meta: generic,
            kind: crate::error::CreateMountTargetErrorKind::SecurityGroupNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::security_group_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_security_group_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMountTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SubnetNotFound" => {
            crate::error::CreateMountTargetError {
                meta: generic,
                kind: crate::error::CreateMountTargetErrorKind::SubnetNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::subnet_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_subnet_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMountTargetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedAvailabilityZone" => crate::error::CreateMountTargetError {
            meta: generic,
            kind: crate::error::CreateMountTargetErrorKind::UnsupportedAvailabilityZone({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_availability_zone::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_availability_zone_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMountTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateMountTargetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_mount_target_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateMountTargetOutput, crate::error::CreateMountTargetError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_mount_target_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_mount_target(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateMountTargetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTagsOutput, crate::error::CreateTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::CreateTagsError {
            meta: generic,
            kind: crate::error::CreateTagsErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::CreateTagsError {
            meta: generic,
            kind: crate::error::CreateTagsErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::CreateTagsError {
            meta: generic,
            kind: crate::error::CreateTagsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTagsOutput, crate::error::CreateTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_access_point_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAccessPointOutput, crate::error::DeleteAccessPointError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAccessPointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAccessPointError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessPointNotFound" => crate::error::DeleteAccessPointError {
            meta: generic,
            kind: crate::error::DeleteAccessPointErrorKind::AccessPointNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_point_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_point_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAccessPointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BadRequest" => crate::error::DeleteAccessPointError {
            meta: generic,
            kind: crate::error::DeleteAccessPointErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteAccessPointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DeleteAccessPointError {
            meta: generic,
            kind: crate::error::DeleteAccessPointErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAccessPointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAccessPointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_access_point_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAccessPointOutput, crate::error::DeleteAccessPointError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_access_point_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_file_system_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteFileSystemOutput, crate::error::DeleteFileSystemError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteFileSystemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteFileSystemError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::DeleteFileSystemError {
            meta: generic,
            kind: crate::error::DeleteFileSystemErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemInUse" => {
            crate::error::DeleteFileSystemError {
                meta: generic,
                kind: crate::error::DeleteFileSystemErrorKind::FileSystemInUse({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::file_system_in_use::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_file_system_in_use_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFileSystemError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "FileSystemNotFound" => crate::error::DeleteFileSystemError {
            meta: generic,
            kind: crate::error::DeleteFileSystemErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DeleteFileSystemError {
            meta: generic,
            kind: crate::error::DeleteFileSystemErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteFileSystemError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_file_system_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteFileSystemOutput, crate::error::DeleteFileSystemError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_file_system_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_file_system_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFileSystemPolicyOutput,
    crate::error::DeleteFileSystemPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteFileSystemPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteFileSystemPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "FileSystemNotFound" => crate::error::DeleteFileSystemPolicyError {
            meta: generic,
            kind: crate::error::DeleteFileSystemPolicyErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFileSystemPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncorrectFileSystemLifeCycleState" => {
            crate::error::DeleteFileSystemPolicyError {
                meta: generic,
                kind:
                    crate::error::DeleteFileSystemPolicyErrorKind::IncorrectFileSystemLifeCycleState(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::incorrect_file_system_life_cycle_state::Builder::default();
                                let _ = response;
                                output = crate::json_deser::deser_structure_crate_error_incorrect_file_system_life_cycle_state_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFileSystemPolicyError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "InternalServerError" => crate::error::DeleteFileSystemPolicyError {
            meta: generic,
            kind: crate::error::DeleteFileSystemPolicyErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFileSystemPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteFileSystemPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_file_system_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFileSystemPolicyOutput,
    crate::error::DeleteFileSystemPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_file_system_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_mount_target_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteMountTargetOutput, crate::error::DeleteMountTargetError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteMountTargetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteMountTargetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::DeleteMountTargetError {
            meta: generic,
            kind: crate::error::DeleteMountTargetErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteMountTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DependencyTimeout" => {
            crate::error::DeleteMountTargetError {
                meta: generic,
                kind: crate::error::DeleteMountTargetErrorKind::DependencyTimeout({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::dependency_timeout::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_dependency_timeout_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteMountTargetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerError" => crate::error::DeleteMountTargetError {
            meta: generic,
            kind: crate::error::DeleteMountTargetErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteMountTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MountTargetNotFound" => crate::error::DeleteMountTargetError {
            meta: generic,
            kind: crate::error::DeleteMountTargetErrorKind::MountTargetNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::mount_target_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_mount_target_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteMountTargetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteMountTargetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_mount_target_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteMountTargetOutput, crate::error::DeleteMountTargetError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_mount_target_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::DeleteTagsError {
            meta: generic,
            kind: crate::error::DeleteTagsErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::DeleteTagsError {
            meta: generic,
            kind: crate::error::DeleteTagsErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DeleteTagsError {
            meta: generic,
            kind: crate::error::DeleteTagsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_access_points_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccessPointsOutput,
    crate::error::DescribeAccessPointsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAccessPointsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeAccessPointsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessPointNotFound" => crate::error::DescribeAccessPointsError {
            meta: generic,
            kind: crate::error::DescribeAccessPointsErrorKind::AccessPointNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_point_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_point_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAccessPointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BadRequest" => crate::error::DescribeAccessPointsError {
            meta: generic,
            kind: crate::error::DescribeAccessPointsErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeAccessPointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::DescribeAccessPointsError {
            meta: generic,
            kind: crate::error::DescribeAccessPointsErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAccessPointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DescribeAccessPointsError {
            meta: generic,
            kind: crate::error::DescribeAccessPointsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAccessPointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeAccessPointsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_access_points_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccessPointsOutput,
    crate::error::DescribeAccessPointsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_access_points_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_access_points(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAccessPointsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_preferences_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountPreferencesOutput,
    crate::error::DescribeAccountPreferencesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAccountPreferencesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeAccountPreferencesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerError" => crate::error::DescribeAccountPreferencesError {
            meta: generic,
            kind: crate::error::DescribeAccountPreferencesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeAccountPreferencesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeAccountPreferencesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_preferences_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountPreferencesOutput,
    crate::error::DescribeAccountPreferencesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_account_preferences_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_account_preferences(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAccountPreferencesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_backup_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeBackupPolicyOutput,
    crate::error::DescribeBackupPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeBackupPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeBackupPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::DescribeBackupPolicyError {
            meta: generic,
            kind: crate::error::DescribeBackupPolicyErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeBackupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::DescribeBackupPolicyError {
            meta: generic,
            kind: crate::error::DescribeBackupPolicyErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBackupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DescribeBackupPolicyError {
            meta: generic,
            kind: crate::error::DescribeBackupPolicyErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBackupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyNotFound" => {
            crate::error::DescribeBackupPolicyError {
                meta: generic,
                kind: crate::error::DescribeBackupPolicyErrorKind::PolicyNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::policy_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_policy_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBackupPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ValidationException" => crate::error::DescribeBackupPolicyError {
            meta: generic,
            kind: crate::error::DescribeBackupPolicyErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBackupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeBackupPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_backup_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeBackupPolicyOutput,
    crate::error::DescribeBackupPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_backup_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_backup_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeBackupPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_file_system_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeFileSystemPolicyOutput,
    crate::error::DescribeFileSystemPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeFileSystemPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeFileSystemPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "FileSystemNotFound" => crate::error::DescribeFileSystemPolicyError {
            meta: generic,
            kind: crate::error::DescribeFileSystemPolicyErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeFileSystemPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DescribeFileSystemPolicyError {
            meta: generic,
            kind: crate::error::DescribeFileSystemPolicyErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeFileSystemPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyNotFound" => {
            crate::error::DescribeFileSystemPolicyError {
                meta: generic,
                kind: crate::error::DescribeFileSystemPolicyErrorKind::PolicyNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::policy_not_found::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_policy_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeFileSystemPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeFileSystemPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_file_system_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeFileSystemPolicyOutput,
    crate::error::DescribeFileSystemPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_file_system_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_file_system_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeFileSystemPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_file_systems_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeFileSystemsOutput,
    crate::error::DescribeFileSystemsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeFileSystemsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeFileSystemsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::DescribeFileSystemsError {
            meta: generic,
            kind: crate::error::DescribeFileSystemsErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeFileSystemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::DescribeFileSystemsError {
            meta: generic,
            kind: crate::error::DescribeFileSystemsErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeFileSystemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DescribeFileSystemsError {
            meta: generic,
            kind: crate::error::DescribeFileSystemsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeFileSystemsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeFileSystemsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_file_systems_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeFileSystemsOutput,
    crate::error::DescribeFileSystemsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_file_systems_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_file_systems(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeFileSystemsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_lifecycle_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLifecycleConfigurationOutput,
    crate::error::DescribeLifecycleConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLifecycleConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeLifecycleConfigurationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::DescribeLifecycleConfigurationError {
            meta: generic,
            kind: crate::error::DescribeLifecycleConfigurationErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeLifecycleConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::DescribeLifecycleConfigurationError {
            meta: generic,
            kind: crate::error::DescribeLifecycleConfigurationErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLifecycleConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DescribeLifecycleConfigurationError {
            meta: generic,
            kind: crate::error::DescribeLifecycleConfigurationErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeLifecycleConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeLifecycleConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_lifecycle_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLifecycleConfigurationOutput,
    crate::error::DescribeLifecycleConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_lifecycle_configuration_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_lifecycle_configuration(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeLifecycleConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_mount_targets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeMountTargetsOutput,
    crate::error::DescribeMountTargetsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeMountTargetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeMountTargetsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessPointNotFound" => crate::error::DescribeMountTargetsError {
            meta: generic,
            kind: crate::error::DescribeMountTargetsErrorKind::AccessPointNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_point_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_point_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeMountTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BadRequest" => crate::error::DescribeMountTargetsError {
            meta: generic,
            kind: crate::error::DescribeMountTargetsErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeMountTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::DescribeMountTargetsError {
            meta: generic,
            kind: crate::error::DescribeMountTargetsErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeMountTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DescribeMountTargetsError {
            meta: generic,
            kind: crate::error::DescribeMountTargetsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeMountTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MountTargetNotFound" => crate::error::DescribeMountTargetsError {
            meta: generic,
            kind: crate::error::DescribeMountTargetsErrorKind::MountTargetNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::mount_target_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_mount_target_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeMountTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeMountTargetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_mount_targets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeMountTargetsOutput,
    crate::error::DescribeMountTargetsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_mount_targets_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_mount_targets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeMountTargetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_mount_target_security_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeMountTargetSecurityGroupsOutput,
    crate::error::DescribeMountTargetSecurityGroupsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeMountTargetSecurityGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeMountTargetSecurityGroupsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::DescribeMountTargetSecurityGroupsError {
            meta: generic,
            kind: crate::error::DescribeMountTargetSecurityGroupsErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeMountTargetSecurityGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncorrectMountTargetState" => crate::error::DescribeMountTargetSecurityGroupsError {
            meta: generic,
            kind:
                crate::error::DescribeMountTargetSecurityGroupsErrorKind::IncorrectMountTargetState(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::incorrect_mount_target_state::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_incorrect_mount_target_state_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeMountTargetSecurityGroupsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InternalServerError" => crate::error::DescribeMountTargetSecurityGroupsError {
            meta: generic,
            kind: crate::error::DescribeMountTargetSecurityGroupsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeMountTargetSecurityGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MountTargetNotFound" => crate::error::DescribeMountTargetSecurityGroupsError {
            meta: generic,
            kind: crate::error::DescribeMountTargetSecurityGroupsErrorKind::MountTargetNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::mount_target_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_mount_target_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeMountTargetSecurityGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeMountTargetSecurityGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_mount_target_security_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeMountTargetSecurityGroupsOutput,
    crate::error::DescribeMountTargetSecurityGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_mount_target_security_groups_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_mount_target_security_groups(response.body().as_ref(), output).map_err(crate::error::DescribeMountTargetSecurityGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_tags_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessPointNotFound" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::AccessPointNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_point_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_point_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BadRequest" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_mount_target_security_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyMountTargetSecurityGroupsOutput,
    crate::error::ModifyMountTargetSecurityGroupsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyMountTargetSecurityGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyMountTargetSecurityGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::ModifyMountTargetSecurityGroupsError {
            meta: generic,
            kind: crate::error::ModifyMountTargetSecurityGroupsErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ModifyMountTargetSecurityGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncorrectMountTargetState" => crate::error::ModifyMountTargetSecurityGroupsError {
            meta: generic,
            kind: crate::error::ModifyMountTargetSecurityGroupsErrorKind::IncorrectMountTargetState(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::incorrect_mount_target_state::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_incorrect_mount_target_state_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyMountTargetSecurityGroupsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InternalServerError" => crate::error::ModifyMountTargetSecurityGroupsError {
            meta: generic,
            kind: crate::error::ModifyMountTargetSecurityGroupsErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyMountTargetSecurityGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MountTargetNotFound" => crate::error::ModifyMountTargetSecurityGroupsError {
            meta: generic,
            kind: crate::error::ModifyMountTargetSecurityGroupsErrorKind::MountTargetNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::mount_target_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_mount_target_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyMountTargetSecurityGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SecurityGroupLimitExceeded" => crate::error::ModifyMountTargetSecurityGroupsError {
            meta: generic,
            kind:
                crate::error::ModifyMountTargetSecurityGroupsErrorKind::SecurityGroupLimitExceeded(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::security_group_limit_exceeded::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_security_group_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyMountTargetSecurityGroupsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "SecurityGroupNotFound" => crate::error::ModifyMountTargetSecurityGroupsError {
            meta: generic,
            kind: crate::error::ModifyMountTargetSecurityGroupsErrorKind::SecurityGroupNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::security_group_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_security_group_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::ModifyMountTargetSecurityGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyMountTargetSecurityGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_mount_target_security_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyMountTargetSecurityGroupsOutput,
    crate::error::ModifyMountTargetSecurityGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::modify_mount_target_security_groups_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_account_preferences_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutAccountPreferencesOutput,
    crate::error::PutAccountPreferencesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutAccountPreferencesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutAccountPreferencesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::PutAccountPreferencesError {
            meta: generic,
            kind: crate::error::PutAccountPreferencesErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::PutAccountPreferencesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::PutAccountPreferencesError {
            meta: generic,
            kind: crate::error::PutAccountPreferencesErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::PutAccountPreferencesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutAccountPreferencesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_account_preferences_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutAccountPreferencesOutput,
    crate::error::PutAccountPreferencesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_account_preferences_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_account_preferences(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutAccountPreferencesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_backup_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutBackupPolicyOutput, crate::error::PutBackupPolicyError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBackupPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutBackupPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::PutBackupPolicyError {
            meta: generic,
            kind: crate::error::PutBackupPolicyErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::PutBackupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::PutBackupPolicyError {
            meta: generic,
            kind: crate::error::PutBackupPolicyErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::PutBackupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncorrectFileSystemLifeCycleState" => crate::error::PutBackupPolicyError {
            meta: generic,
            kind: crate::error::PutBackupPolicyErrorKind::IncorrectFileSystemLifeCycleState({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::incorrect_file_system_life_cycle_state::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incorrect_file_system_life_cycle_state_json_err(response.body().as_ref(), output).map_err(crate::error::PutBackupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::PutBackupPolicyError {
            meta: generic,
            kind: crate::error::PutBackupPolicyErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::PutBackupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::PutBackupPolicyError {
            meta: generic,
            kind: crate::error::PutBackupPolicyErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutBackupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutBackupPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_backup_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutBackupPolicyOutput, crate::error::PutBackupPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_backup_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_backup_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutBackupPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_file_system_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutFileSystemPolicyOutput,
    crate::error::PutFileSystemPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutFileSystemPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutFileSystemPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "FileSystemNotFound" => crate::error::PutFileSystemPolicyError {
            meta: generic,
            kind: crate::error::PutFileSystemPolicyErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::PutFileSystemPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncorrectFileSystemLifeCycleState" => crate::error::PutFileSystemPolicyError {
            meta: generic,
            kind: crate::error::PutFileSystemPolicyErrorKind::IncorrectFileSystemLifeCycleState({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::incorrect_file_system_life_cycle_state::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incorrect_file_system_life_cycle_state_json_err(response.body().as_ref(), output).map_err(crate::error::PutFileSystemPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::PutFileSystemPolicyError {
            meta: generic,
            kind: crate::error::PutFileSystemPolicyErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::PutFileSystemPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidPolicyException" => crate::error::PutFileSystemPolicyError {
            meta: generic,
            kind: crate::error::PutFileSystemPolicyErrorKind::InvalidPolicyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_policy_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_policy_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutFileSystemPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutFileSystemPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_file_system_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutFileSystemPolicyOutput,
    crate::error::PutFileSystemPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_file_system_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_file_system_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutFileSystemPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_lifecycle_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutLifecycleConfigurationOutput,
    crate::error::PutLifecycleConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutLifecycleConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutLifecycleConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::PutLifecycleConfigurationError {
            meta: generic,
            kind: crate::error::PutLifecycleConfigurationErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::PutLifecycleConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::PutLifecycleConfigurationError {
            meta: generic,
            kind: crate::error::PutLifecycleConfigurationErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::PutLifecycleConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncorrectFileSystemLifeCycleState" => crate::error::PutLifecycleConfigurationError {
            meta: generic,
            kind:
                crate::error::PutLifecycleConfigurationErrorKind::IncorrectFileSystemLifeCycleState(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::incorrect_file_system_life_cycle_state::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_incorrect_file_system_life_cycle_state_json_err(response.body().as_ref(), output).map_err(crate::error::PutLifecycleConfigurationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InternalServerError" => crate::error::PutLifecycleConfigurationError {
            meta: generic,
            kind: crate::error::PutLifecycleConfigurationErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::PutLifecycleConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutLifecycleConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_lifecycle_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutLifecycleConfigurationOutput,
    crate::error::PutLifecycleConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_lifecycle_configuration_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_lifecycle_configuration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutLifecycleConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessPointNotFound" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::AccessPointNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_point_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_point_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BadRequest" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessPointNotFound" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::AccessPointNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_point_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_point_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BadRequest" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_file_system_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateFileSystemOutput, crate::error::UpdateFileSystemError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateFileSystemError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateFileSystemError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequest" => crate::error::UpdateFileSystemError {
            meta: generic,
            kind: crate::error::UpdateFileSystemErrorKind::BadRequest({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UpdateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "FileSystemNotFound" => crate::error::UpdateFileSystemError {
            meta: generic,
            kind: crate::error::UpdateFileSystemErrorKind::FileSystemNotFound({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::file_system_not_found::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_file_system_not_found_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IncorrectFileSystemLifeCycleState" => crate::error::UpdateFileSystemError {
            meta: generic,
            kind: crate::error::UpdateFileSystemErrorKind::IncorrectFileSystemLifeCycleState({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::incorrect_file_system_life_cycle_state::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_incorrect_file_system_life_cycle_state_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientThroughputCapacity" => crate::error::UpdateFileSystemError {
            meta: generic,
            kind: crate::error::UpdateFileSystemErrorKind::InsufficientThroughputCapacity({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_throughput_capacity::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_insufficient_throughput_capacity_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerError" => crate::error::UpdateFileSystemError {
            meta: generic,
            kind: crate::error::UpdateFileSystemErrorKind::InternalServerError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_error::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_error_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThroughputLimitExceeded" => crate::error::UpdateFileSystemError {
            meta: generic,
            kind: crate::error::UpdateFileSystemErrorKind::ThroughputLimitExceeded({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throughput_limit_exceeded::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throughput_limit_exceeded_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFileSystemError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequests" => {
            crate::error::UpdateFileSystemError {
                meta: generic,
                kind: crate::error::UpdateFileSystemErrorKind::TooManyRequests({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::too_many_requests::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_too_many_requests_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFileSystemError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateFileSystemError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_file_system_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateFileSystemOutput, crate::error::UpdateFileSystemError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_file_system_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_file_system(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateFileSystemError::unhandled)?;
        output.build()
    })
}
