// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>Returned if the access point you are trying to create already exists, with the
    /// creation token you provided in the request.</p>
    AccessPointAlreadyExists(crate::error::AccessPointAlreadyExists),
    /// <p>Returned if the Amazon Web Services account has already created the maximum number of access points
    /// allowed per file system.</p>
    AccessPointLimitExceeded(crate::error::AccessPointLimitExceeded),
    /// <p>Returned if the specified <code>AccessPointId</code> value doesn't exist in the
    /// requester's Amazon Web Services account.</p>
    AccessPointNotFound(crate::error::AccessPointNotFound),
    /// <p>Returned if the Availability Zone that was specified for a mount target is different from the Availability Zone that was specified for One Zone storage classes.
    /// For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/availability-durability.html">Regional and One Zone storage redundancy</a>.</p>
    AvailabilityZonesMismatch(crate::error::AvailabilityZonesMismatch),
    /// <p>Returned if the request is malformed or contains an error such as an invalid
    /// parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>The service timed out trying to fulfill the request, and the client should try the
    /// call again.</p>
    DependencyTimeout(crate::error::DependencyTimeout),
    /// <p>Returned if the file system you are trying to create already exists, with the
    /// creation token you provided.</p>
    FileSystemAlreadyExists(crate::error::FileSystemAlreadyExists),
    /// <p>Returned if a file system has mount targets.</p>
    FileSystemInUse(crate::error::FileSystemInUse),
    /// <p>Returned if the Amazon Web Services account has already created the maximum number of file systems
    /// allowed per account.</p>
    FileSystemLimitExceeded(crate::error::FileSystemLimitExceeded),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the
    /// requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if the file system's lifecycle state is not "available".</p>
    IncorrectFileSystemLifeCycleState(crate::error::IncorrectFileSystemLifeCycleState),
    /// <p>Returned if the mount target is not in the correct state for the
    /// operation.</p>
    IncorrectMountTargetState(crate::error::IncorrectMountTargetState),
    /// <p>Returned if there's not enough capacity to provision additional throughput. This value
    /// might be returned when you try to create a file system in provisioned throughput mode,
    /// when you attempt to increase the provisioned throughput of an existing file system, or
    /// when you attempt to change an existing file system from bursting to provisioned
    /// throughput mode. Try again later.</p>
    InsufficientThroughputCapacity(crate::error::InsufficientThroughputCapacity),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Returned if the <code>FileSystemPolicy</code> is is malformed or contains an error such as an invalid
    /// parameter value or a missing required parameter. Returned in the case of a policy lockout safety check error.</p>
    InvalidPolicyException(crate::error::InvalidPolicyException),
    /// <p>Returned if the request specified an <code>IpAddress</code> that is already in use
    /// in the subnet.</p>
    IpAddressInUse(crate::error::IpAddressInUse),
    /// <p>Returned if the mount target would violate one of the specified restrictions based
    /// on the file system's existing mount targets.</p>
    MountTargetConflict(crate::error::MountTargetConflict),
    /// <p>Returned if there is no mount target with the specified ID found in the
    /// caller's Amazon Web Services account.</p>
    MountTargetNotFound(crate::error::MountTargetNotFound),
    /// <p>The calling account has reached the limit for elastic network interfaces for the
    /// specific Amazon Web Services Region. The client should try to delete some elastic network interfaces or
    /// get the account limit raised. For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Appendix_Limits.html">Amazon VPC Limits</a>
    /// in the <i>Amazon VPC User Guide </i> (see the Network interfaces per VPC
    /// entry in the table). </p>
    NetworkInterfaceLimitExceeded(crate::error::NetworkInterfaceLimitExceeded),
    /// <p>Returned if <code>IpAddress</code> was not specified in the request and there are
    /// no free IP addresses in the subnet.</p>
    NoFreeAddressesInSubnet(crate::error::NoFreeAddressesInSubnet),
    /// <p>Returned if the default file system policy is in effect for the EFS file system specified.</p>
    PolicyNotFound(crate::error::PolicyNotFound),
    /// <p>Returned if the size of <code>SecurityGroups</code> specified in the request is
    /// greater than five.</p>
    SecurityGroupLimitExceeded(crate::error::SecurityGroupLimitExceeded),
    /// <p>Returned if one of the specified security groups doesn't exist in the subnet's
    /// VPC.</p>
    SecurityGroupNotFound(crate::error::SecurityGroupNotFound),
    /// <p>Returned if there is no subnet with ID <code>SubnetId</code> provided in the
    /// request.</p>
    SubnetNotFound(crate::error::SubnetNotFound),
    /// <p>Returned if the throughput mode or amount of provisioned throughput can't be changed
    /// because the throughput limit of 1024 MiB/s has been reached.</p>
    ThroughputLimitExceeded(crate::error::ThroughputLimitExceeded),
    /// <p>Returned if you don’t wait at least 24 hours before changing the throughput mode, or
    /// decreasing the Provisioned Throughput value.</p>
    TooManyRequests(crate::error::TooManyRequests),
    /// <p>Returned if the requested Amazon EFS functionality is not available in the specified Availability Zone.</p>
    UnsupportedAvailabilityZone(crate::error::UnsupportedAvailabilityZone),
    /// <p>Returned if the Backup service is not available in the Amazon Web Services Region in which the request was made.</p>
    ValidationException(crate::error::ValidationException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessPointAlreadyExists(inner) => inner.fmt(f),
            Error::AccessPointLimitExceeded(inner) => inner.fmt(f),
            Error::AccessPointNotFound(inner) => inner.fmt(f),
            Error::AvailabilityZonesMismatch(inner) => inner.fmt(f),
            Error::BadRequest(inner) => inner.fmt(f),
            Error::DependencyTimeout(inner) => inner.fmt(f),
            Error::FileSystemAlreadyExists(inner) => inner.fmt(f),
            Error::FileSystemInUse(inner) => inner.fmt(f),
            Error::FileSystemLimitExceeded(inner) => inner.fmt(f),
            Error::FileSystemNotFound(inner) => inner.fmt(f),
            Error::IncorrectFileSystemLifeCycleState(inner) => inner.fmt(f),
            Error::IncorrectMountTargetState(inner) => inner.fmt(f),
            Error::InsufficientThroughputCapacity(inner) => inner.fmt(f),
            Error::InternalServerError(inner) => inner.fmt(f),
            Error::InvalidPolicyException(inner) => inner.fmt(f),
            Error::IpAddressInUse(inner) => inner.fmt(f),
            Error::MountTargetConflict(inner) => inner.fmt(f),
            Error::MountTargetNotFound(inner) => inner.fmt(f),
            Error::NetworkInterfaceLimitExceeded(inner) => inner.fmt(f),
            Error::NoFreeAddressesInSubnet(inner) => inner.fmt(f),
            Error::PolicyNotFound(inner) => inner.fmt(f),
            Error::SecurityGroupLimitExceeded(inner) => inner.fmt(f),
            Error::SecurityGroupNotFound(inner) => inner.fmt(f),
            Error::SubnetNotFound(inner) => inner.fmt(f),
            Error::ThroughputLimitExceeded(inner) => inner.fmt(f),
            Error::TooManyRequests(inner) => inner.fmt(f),
            Error::UnsupportedAvailabilityZone(inner) => inner.fmt(f),
            Error::ValidationException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateAccessPointError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateAccessPointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateAccessPointErrorKind::AccessPointAlreadyExists(inner) => {
                    Error::AccessPointAlreadyExists(inner)
                }
                crate::error::CreateAccessPointErrorKind::AccessPointLimitExceeded(inner) => {
                    Error::AccessPointLimitExceeded(inner)
                }
                crate::error::CreateAccessPointErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::CreateAccessPointErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::CreateAccessPointErrorKind::IncorrectFileSystemLifeCycleState(
                    inner,
                ) => Error::IncorrectFileSystemLifeCycleState(inner),
                crate::error::CreateAccessPointErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateAccessPointErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateFileSystemError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateFileSystemError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateFileSystemErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::CreateFileSystemErrorKind::FileSystemAlreadyExists(inner) => {
                    Error::FileSystemAlreadyExists(inner)
                }
                crate::error::CreateFileSystemErrorKind::FileSystemLimitExceeded(inner) => {
                    Error::FileSystemLimitExceeded(inner)
                }
                crate::error::CreateFileSystemErrorKind::InsufficientThroughputCapacity(inner) => {
                    Error::InsufficientThroughputCapacity(inner)
                }
                crate::error::CreateFileSystemErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateFileSystemErrorKind::ThroughputLimitExceeded(inner) => {
                    Error::ThroughputLimitExceeded(inner)
                }
                crate::error::CreateFileSystemErrorKind::UnsupportedAvailabilityZone(inner) => {
                    Error::UnsupportedAvailabilityZone(inner)
                }
                crate::error::CreateFileSystemErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateMountTargetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateMountTargetError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateMountTargetErrorKind::AvailabilityZonesMismatch(inner) => {
                    Error::AvailabilityZonesMismatch(inner)
                }
                crate::error::CreateMountTargetErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::CreateMountTargetErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::CreateMountTargetErrorKind::IncorrectFileSystemLifeCycleState(
                    inner,
                ) => Error::IncorrectFileSystemLifeCycleState(inner),
                crate::error::CreateMountTargetErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateMountTargetErrorKind::IpAddressInUse(inner) => {
                    Error::IpAddressInUse(inner)
                }
                crate::error::CreateMountTargetErrorKind::MountTargetConflict(inner) => {
                    Error::MountTargetConflict(inner)
                }
                crate::error::CreateMountTargetErrorKind::NetworkInterfaceLimitExceeded(inner) => {
                    Error::NetworkInterfaceLimitExceeded(inner)
                }
                crate::error::CreateMountTargetErrorKind::NoFreeAddressesInSubnet(inner) => {
                    Error::NoFreeAddressesInSubnet(inner)
                }
                crate::error::CreateMountTargetErrorKind::SecurityGroupLimitExceeded(inner) => {
                    Error::SecurityGroupLimitExceeded(inner)
                }
                crate::error::CreateMountTargetErrorKind::SecurityGroupNotFound(inner) => {
                    Error::SecurityGroupNotFound(inner)
                }
                crate::error::CreateMountTargetErrorKind::SubnetNotFound(inner) => {
                    Error::SubnetNotFound(inner)
                }
                crate::error::CreateMountTargetErrorKind::UnsupportedAvailabilityZone(inner) => {
                    Error::UnsupportedAvailabilityZone(inner)
                }
                crate::error::CreateMountTargetErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateTagsErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::CreateTagsErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::CreateTagsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAccessPointError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteAccessPointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteAccessPointErrorKind::AccessPointNotFound(inner) => {
                    Error::AccessPointNotFound(inner)
                }
                crate::error::DeleteAccessPointErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::DeleteAccessPointErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteAccessPointErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteFileSystemError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteFileSystemError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteFileSystemErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::DeleteFileSystemErrorKind::FileSystemInUse(inner) => {
                    Error::FileSystemInUse(inner)
                }
                crate::error::DeleteFileSystemErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::DeleteFileSystemErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteFileSystemErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteFileSystemPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteFileSystemPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteFileSystemPolicyErrorKind::FileSystemNotFound(inner) => Error::FileSystemNotFound(inner),
                crate::error::DeleteFileSystemPolicyErrorKind::IncorrectFileSystemLifeCycleState(inner) => Error::IncorrectFileSystemLifeCycleState(inner),
                crate::error::DeleteFileSystemPolicyErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DeleteFileSystemPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteMountTargetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteMountTargetError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteMountTargetErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::DeleteMountTargetErrorKind::DependencyTimeout(inner) => {
                    Error::DependencyTimeout(inner)
                }
                crate::error::DeleteMountTargetErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteMountTargetErrorKind::MountTargetNotFound(inner) => {
                    Error::MountTargetNotFound(inner)
                }
                crate::error::DeleteMountTargetErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTagsErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::DeleteTagsErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::DeleteTagsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAccessPointsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAccessPointsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAccessPointsErrorKind::AccessPointNotFound(inner) => {
                    Error::AccessPointNotFound(inner)
                }
                crate::error::DescribeAccessPointsErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::DescribeAccessPointsErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::DescribeAccessPointsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeAccessPointsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAccountPreferencesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAccountPreferencesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAccountPreferencesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeAccountPreferencesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeBackupPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeBackupPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeBackupPolicyErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::DescribeBackupPolicyErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::DescribeBackupPolicyErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeBackupPolicyErrorKind::PolicyNotFound(inner) => {
                    Error::PolicyNotFound(inner)
                }
                crate::error::DescribeBackupPolicyErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::DescribeBackupPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeFileSystemPolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeFileSystemPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeFileSystemPolicyErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::DescribeFileSystemPolicyErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeFileSystemPolicyErrorKind::PolicyNotFound(inner) => {
                    Error::PolicyNotFound(inner)
                }
                crate::error::DescribeFileSystemPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeFileSystemsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeFileSystemsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeFileSystemsErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::DescribeFileSystemsErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::DescribeFileSystemsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeFileSystemsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeLifecycleConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeLifecycleConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeLifecycleConfigurationErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::DescribeLifecycleConfigurationErrorKind::FileSystemNotFound(
                    inner,
                ) => Error::FileSystemNotFound(inner),
                crate::error::DescribeLifecycleConfigurationErrorKind::InternalServerError(
                    inner,
                ) => Error::InternalServerError(inner),
                crate::error::DescribeLifecycleConfigurationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeMountTargetsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeMountTargetsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeMountTargetsErrorKind::AccessPointNotFound(inner) => {
                    Error::AccessPointNotFound(inner)
                }
                crate::error::DescribeMountTargetsErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::DescribeMountTargetsErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::DescribeMountTargetsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeMountTargetsErrorKind::MountTargetNotFound(inner) => {
                    Error::MountTargetNotFound(inner)
                }
                crate::error::DescribeMountTargetsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeMountTargetSecurityGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeMountTargetSecurityGroupsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeMountTargetSecurityGroupsErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::DescribeMountTargetSecurityGroupsErrorKind::IncorrectMountTargetState(inner) => Error::IncorrectMountTargetState(inner),
                crate::error::DescribeMountTargetSecurityGroupsErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeMountTargetSecurityGroupsErrorKind::MountTargetNotFound(inner) => Error::MountTargetNotFound(inner),
                crate::error::DescribeMountTargetSecurityGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTagsErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::DescribeTagsErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::DescribeTagsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::AccessPointNotFound(inner) => {
                    Error::AccessPointNotFound(inner)
                }
                crate::error::ListTagsForResourceErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::ListTagsForResourceErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ModifyMountTargetSecurityGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ModifyMountTargetSecurityGroupsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyMountTargetSecurityGroupsErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::ModifyMountTargetSecurityGroupsErrorKind::IncorrectMountTargetState(inner) => Error::IncorrectMountTargetState(inner),
                crate::error::ModifyMountTargetSecurityGroupsErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::ModifyMountTargetSecurityGroupsErrorKind::MountTargetNotFound(inner) => Error::MountTargetNotFound(inner),
                crate::error::ModifyMountTargetSecurityGroupsErrorKind::SecurityGroupLimitExceeded(inner) => Error::SecurityGroupLimitExceeded(inner),
                crate::error::ModifyMountTargetSecurityGroupsErrorKind::SecurityGroupNotFound(inner) => Error::SecurityGroupNotFound(inner),
                crate::error::ModifyMountTargetSecurityGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutAccountPreferencesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutAccountPreferencesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutAccountPreferencesErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::PutAccountPreferencesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::PutAccountPreferencesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutBackupPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PutBackupPolicyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutBackupPolicyErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::PutBackupPolicyErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::PutBackupPolicyErrorKind::IncorrectFileSystemLifeCycleState(
                    inner,
                ) => Error::IncorrectFileSystemLifeCycleState(inner),
                crate::error::PutBackupPolicyErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::PutBackupPolicyErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::PutBackupPolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutFileSystemPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutFileSystemPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutFileSystemPolicyErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::PutFileSystemPolicyErrorKind::IncorrectFileSystemLifeCycleState(
                    inner,
                ) => Error::IncorrectFileSystemLifeCycleState(inner),
                crate::error::PutFileSystemPolicyErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::PutFileSystemPolicyErrorKind::InvalidPolicyException(inner) => {
                    Error::InvalidPolicyException(inner)
                }
                crate::error::PutFileSystemPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutLifecycleConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutLifecycleConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutLifecycleConfigurationErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::PutLifecycleConfigurationErrorKind::FileSystemNotFound(inner) => Error::FileSystemNotFound(inner),
                crate::error::PutLifecycleConfigurationErrorKind::IncorrectFileSystemLifeCycleState(inner) => Error::IncorrectFileSystemLifeCycleState(inner),
                crate::error::PutLifecycleConfigurationErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::PutLifecycleConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::AccessPointNotFound(inner) => {
                    Error::AccessPointNotFound(inner)
                }
                crate::error::TagResourceErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::TagResourceErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::TagResourceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::AccessPointNotFound(inner) => {
                    Error::AccessPointNotFound(inner)
                }
                crate::error::UntagResourceErrorKind::BadRequest(inner) => Error::BadRequest(inner),
                crate::error::UntagResourceErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::UntagResourceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateFileSystemError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateFileSystemError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateFileSystemErrorKind::BadRequest(inner) => {
                    Error::BadRequest(inner)
                }
                crate::error::UpdateFileSystemErrorKind::FileSystemNotFound(inner) => {
                    Error::FileSystemNotFound(inner)
                }
                crate::error::UpdateFileSystemErrorKind::IncorrectFileSystemLifeCycleState(
                    inner,
                ) => Error::IncorrectFileSystemLifeCycleState(inner),
                crate::error::UpdateFileSystemErrorKind::InsufficientThroughputCapacity(inner) => {
                    Error::InsufficientThroughputCapacity(inner)
                }
                crate::error::UpdateFileSystemErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UpdateFileSystemErrorKind::ThroughputLimitExceeded(inner) => {
                    Error::ThroughputLimitExceeded(inner)
                }
                crate::error::UpdateFileSystemErrorKind::TooManyRequests(inner) => {
                    Error::TooManyRequests(inner)
                }
                crate::error::UpdateFileSystemErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
