// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateAccessPoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAccessPointError {
    /// Kind of error that occurred.
    pub kind: CreateAccessPointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAccessPoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAccessPointErrorKind {
    /// <p>Returned if the access point that you are trying to create already exists, with the creation token you provided in the request.</p>
    AccessPointAlreadyExists(crate::error::AccessPointAlreadyExists),
    /// <p>Returned if the Amazon Web Services account has already created the maximum number of access points allowed per file system. For more informaton, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#limits-efs-resources-per-account-per-region">https://docs.aws.amazon.com/efs/latest/ug/limits.html#limits-efs-resources-per-account-per-region</a>.</p>
    AccessPointLimitExceeded(crate::error::AccessPointLimitExceeded),
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if the file system's lifecycle state is not "available".</p>
    IncorrectFileSystemLifeCycleState(crate::error::IncorrectFileSystemLifeCycleState),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Returned when the <code>CreateAccessPoint</code> API action is called too quickly and the number of Access Points in the account is nearing the limit of 120.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAccessPointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAccessPointErrorKind::AccessPointAlreadyExists(_inner) => _inner.fmt(f),
            CreateAccessPointErrorKind::AccessPointLimitExceeded(_inner) => _inner.fmt(f),
            CreateAccessPointErrorKind::BadRequest(_inner) => _inner.fmt(f),
            CreateAccessPointErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            CreateAccessPointErrorKind::IncorrectFileSystemLifeCycleState(_inner) => _inner.fmt(f),
            CreateAccessPointErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateAccessPointErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateAccessPointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAccessPointError {
    fn code(&self) -> Option<&str> {
        CreateAccessPointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAccessPointError {
    /// Creates a new `CreateAccessPointError`.
    pub fn new(kind: CreateAccessPointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAccessPointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAccessPointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAccessPointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAccessPointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAccessPointErrorKind::AccessPointAlreadyExists`.
    pub fn is_access_point_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccessPointErrorKind::AccessPointAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccessPointErrorKind::AccessPointLimitExceeded`.
    pub fn is_access_point_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccessPointErrorKind::AccessPointLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccessPointErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, CreateAccessPointErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `CreateAccessPointErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccessPointErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccessPointErrorKind::IncorrectFileSystemLifeCycleState`.
    pub fn is_incorrect_file_system_life_cycle_state(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccessPointErrorKind::IncorrectFileSystemLifeCycleState(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccessPointErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccessPointErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccessPointErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccessPointErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateAccessPointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAccessPointErrorKind::AccessPointAlreadyExists(_inner) => Some(_inner),
            CreateAccessPointErrorKind::AccessPointLimitExceeded(_inner) => Some(_inner),
            CreateAccessPointErrorKind::BadRequest(_inner) => Some(_inner),
            CreateAccessPointErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            CreateAccessPointErrorKind::IncorrectFileSystemLifeCycleState(_inner) => Some(_inner),
            CreateAccessPointErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateAccessPointErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateAccessPointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFileSystem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFileSystemError {
    /// Kind of error that occurred.
    pub kind: CreateFileSystemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFileSystem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFileSystemErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the file system you are trying to create already exists, with the creation token you provided.</p>
    FileSystemAlreadyExists(crate::error::FileSystemAlreadyExists),
    /// <p>Returned if the Amazon Web Services account has already created the maximum number of file systems allowed per account.</p>
    FileSystemLimitExceeded(crate::error::FileSystemLimitExceeded),
    /// <p>Returned if there's not enough capacity to provision additional throughput. This value might be returned when you try to create a file system in provisioned throughput mode, when you attempt to increase the provisioned throughput of an existing file system, or when you attempt to change an existing file system from Bursting Throughput to Provisioned Throughput mode. Try again later.</p>
    InsufficientThroughputCapacity(crate::error::InsufficientThroughputCapacity),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Returned if the throughput mode or amount of provisioned throughput can't be changed because the throughput limit of 1024 MiB/s has been reached.</p>
    ThroughputLimitExceeded(crate::error::ThroughputLimitExceeded),
    /// <p>Returned if the requested Amazon EFS functionality is not available in the specified Availability Zone.</p>
    UnsupportedAvailabilityZone(crate::error::UnsupportedAvailabilityZone),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFileSystemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFileSystemErrorKind::BadRequest(_inner) => _inner.fmt(f),
            CreateFileSystemErrorKind::FileSystemAlreadyExists(_inner) => _inner.fmt(f),
            CreateFileSystemErrorKind::FileSystemLimitExceeded(_inner) => _inner.fmt(f),
            CreateFileSystemErrorKind::InsufficientThroughputCapacity(_inner) => _inner.fmt(f),
            CreateFileSystemErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateFileSystemErrorKind::ThroughputLimitExceeded(_inner) => _inner.fmt(f),
            CreateFileSystemErrorKind::UnsupportedAvailabilityZone(_inner) => _inner.fmt(f),
            CreateFileSystemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFileSystemError {
    fn code(&self) -> Option<&str> {
        CreateFileSystemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFileSystemError {
    /// Creates a new `CreateFileSystemError`.
    pub fn new(kind: CreateFileSystemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFileSystemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFileSystemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFileSystemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFileSystemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFileSystemErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, CreateFileSystemErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `CreateFileSystemErrorKind::FileSystemAlreadyExists`.
    pub fn is_file_system_already_exists(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemErrorKind::FileSystemAlreadyExists(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemErrorKind::FileSystemLimitExceeded`.
    pub fn is_file_system_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemErrorKind::FileSystemLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemErrorKind::InsufficientThroughputCapacity`.
    pub fn is_insufficient_throughput_capacity(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemErrorKind::InsufficientThroughputCapacity(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemErrorKind::ThroughputLimitExceeded`.
    pub fn is_throughput_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemErrorKind::ThroughputLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFileSystemErrorKind::UnsupportedAvailabilityZone`.
    pub fn is_unsupported_availability_zone(&self) -> bool {
        matches!(
            &self.kind,
            CreateFileSystemErrorKind::UnsupportedAvailabilityZone(_)
        )
    }
}
impl std::error::Error for CreateFileSystemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFileSystemErrorKind::BadRequest(_inner) => Some(_inner),
            CreateFileSystemErrorKind::FileSystemAlreadyExists(_inner) => Some(_inner),
            CreateFileSystemErrorKind::FileSystemLimitExceeded(_inner) => Some(_inner),
            CreateFileSystemErrorKind::InsufficientThroughputCapacity(_inner) => Some(_inner),
            CreateFileSystemErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateFileSystemErrorKind::ThroughputLimitExceeded(_inner) => Some(_inner),
            CreateFileSystemErrorKind::UnsupportedAvailabilityZone(_inner) => Some(_inner),
            CreateFileSystemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMountTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMountTargetError {
    /// Kind of error that occurred.
    pub kind: CreateMountTargetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMountTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMountTargetErrorKind {
    /// <p>Returned if the Availability Zone that was specified for a mount target is different from the Availability Zone that was specified for One Zone storage. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/availability-durability.html">Regional and One Zone storage redundancy</a>.</p>
    AvailabilityZonesMismatch(crate::error::AvailabilityZonesMismatch),
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if the file system's lifecycle state is not "available".</p>
    IncorrectFileSystemLifeCycleState(crate::error::IncorrectFileSystemLifeCycleState),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Returned if the request specified an <code>IpAddress</code> that is already in use in the subnet.</p>
    IpAddressInUse(crate::error::IpAddressInUse),
    /// <p>Returned if the mount target would violate one of the specified restrictions based on the file system's existing mount targets.</p>
    MountTargetConflict(crate::error::MountTargetConflict),
    /// <p>The calling account has reached the limit for elastic network interfaces for the specific Amazon Web Services Region. Either delete some network interfaces or request that the account quota be raised. For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Appendix_Limits.html">Amazon VPC Quotas</a> in the <i>Amazon VPC User Guide</i> (see the <b>Network interfaces per Region</b> entry in the <b>Network interfaces</b> table). </p>
    NetworkInterfaceLimitExceeded(crate::error::NetworkInterfaceLimitExceeded),
    /// <p>Returned if <code>IpAddress</code> was not specified in the request and there are no free IP addresses in the subnet.</p>
    NoFreeAddressesInSubnet(crate::error::NoFreeAddressesInSubnet),
    /// <p>Returned if the size of <code>SecurityGroups</code> specified in the request is greater than five.</p>
    SecurityGroupLimitExceeded(crate::error::SecurityGroupLimitExceeded),
    /// <p>Returned if one of the specified security groups doesn't exist in the subnet's virtual private cloud (VPC).</p>
    SecurityGroupNotFound(crate::error::SecurityGroupNotFound),
    /// <p>Returned if there is no subnet with ID <code>SubnetId</code> provided in the request.</p>
    SubnetNotFound(crate::error::SubnetNotFound),
    /// <p>Returned if the requested Amazon EFS functionality is not available in the specified Availability Zone.</p>
    UnsupportedAvailabilityZone(crate::error::UnsupportedAvailabilityZone),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMountTargetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMountTargetErrorKind::AvailabilityZonesMismatch(_inner) => _inner.fmt(f),
            CreateMountTargetErrorKind::BadRequest(_inner) => _inner.fmt(f),
            CreateMountTargetErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            CreateMountTargetErrorKind::IncorrectFileSystemLifeCycleState(_inner) => _inner.fmt(f),
            CreateMountTargetErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateMountTargetErrorKind::IpAddressInUse(_inner) => _inner.fmt(f),
            CreateMountTargetErrorKind::MountTargetConflict(_inner) => _inner.fmt(f),
            CreateMountTargetErrorKind::NetworkInterfaceLimitExceeded(_inner) => _inner.fmt(f),
            CreateMountTargetErrorKind::NoFreeAddressesInSubnet(_inner) => _inner.fmt(f),
            CreateMountTargetErrorKind::SecurityGroupLimitExceeded(_inner) => _inner.fmt(f),
            CreateMountTargetErrorKind::SecurityGroupNotFound(_inner) => _inner.fmt(f),
            CreateMountTargetErrorKind::SubnetNotFound(_inner) => _inner.fmt(f),
            CreateMountTargetErrorKind::UnsupportedAvailabilityZone(_inner) => _inner.fmt(f),
            CreateMountTargetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMountTargetError {
    fn code(&self) -> Option<&str> {
        CreateMountTargetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMountTargetError {
    /// Creates a new `CreateMountTargetError`.
    pub fn new(kind: CreateMountTargetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMountTargetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMountTargetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMountTargetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMountTargetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMountTargetErrorKind::AvailabilityZonesMismatch`.
    pub fn is_availability_zones_mismatch(&self) -> bool {
        matches!(
            &self.kind,
            CreateMountTargetErrorKind::AvailabilityZonesMismatch(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMountTargetErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, CreateMountTargetErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `CreateMountTargetErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            CreateMountTargetErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMountTargetErrorKind::IncorrectFileSystemLifeCycleState`.
    pub fn is_incorrect_file_system_life_cycle_state(&self) -> bool {
        matches!(
            &self.kind,
            CreateMountTargetErrorKind::IncorrectFileSystemLifeCycleState(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMountTargetErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateMountTargetErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMountTargetErrorKind::IpAddressInUse`.
    pub fn is_ip_address_in_use(&self) -> bool {
        matches!(&self.kind, CreateMountTargetErrorKind::IpAddressInUse(_))
    }
    /// Returns `true` if the error kind is `CreateMountTargetErrorKind::MountTargetConflict`.
    pub fn is_mount_target_conflict(&self) -> bool {
        matches!(
            &self.kind,
            CreateMountTargetErrorKind::MountTargetConflict(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMountTargetErrorKind::NetworkInterfaceLimitExceeded`.
    pub fn is_network_interface_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateMountTargetErrorKind::NetworkInterfaceLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMountTargetErrorKind::NoFreeAddressesInSubnet`.
    pub fn is_no_free_addresses_in_subnet(&self) -> bool {
        matches!(
            &self.kind,
            CreateMountTargetErrorKind::NoFreeAddressesInSubnet(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMountTargetErrorKind::SecurityGroupLimitExceeded`.
    pub fn is_security_group_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateMountTargetErrorKind::SecurityGroupLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMountTargetErrorKind::SecurityGroupNotFound`.
    pub fn is_security_group_not_found(&self) -> bool {
        matches!(
            &self.kind,
            CreateMountTargetErrorKind::SecurityGroupNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMountTargetErrorKind::SubnetNotFound`.
    pub fn is_subnet_not_found(&self) -> bool {
        matches!(&self.kind, CreateMountTargetErrorKind::SubnetNotFound(_))
    }
    /// Returns `true` if the error kind is `CreateMountTargetErrorKind::UnsupportedAvailabilityZone`.
    pub fn is_unsupported_availability_zone(&self) -> bool {
        matches!(
            &self.kind,
            CreateMountTargetErrorKind::UnsupportedAvailabilityZone(_)
        )
    }
}
impl std::error::Error for CreateMountTargetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMountTargetErrorKind::AvailabilityZonesMismatch(_inner) => Some(_inner),
            CreateMountTargetErrorKind::BadRequest(_inner) => Some(_inner),
            CreateMountTargetErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            CreateMountTargetErrorKind::IncorrectFileSystemLifeCycleState(_inner) => Some(_inner),
            CreateMountTargetErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateMountTargetErrorKind::IpAddressInUse(_inner) => Some(_inner),
            CreateMountTargetErrorKind::MountTargetConflict(_inner) => Some(_inner),
            CreateMountTargetErrorKind::NetworkInterfaceLimitExceeded(_inner) => Some(_inner),
            CreateMountTargetErrorKind::NoFreeAddressesInSubnet(_inner) => Some(_inner),
            CreateMountTargetErrorKind::SecurityGroupLimitExceeded(_inner) => Some(_inner),
            CreateMountTargetErrorKind::SecurityGroupNotFound(_inner) => Some(_inner),
            CreateMountTargetErrorKind::SubnetNotFound(_inner) => Some(_inner),
            CreateMountTargetErrorKind::UnsupportedAvailabilityZone(_inner) => Some(_inner),
            CreateMountTargetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateReplicationConfigurationError {
    /// Kind of error that occurred.
    pub kind: CreateReplicationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateReplicationConfigurationErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the Amazon Web Services account has already created the maximum number of file systems allowed per account.</p>
    FileSystemLimitExceeded(crate::error::FileSystemLimitExceeded),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if the file system's lifecycle state is not "available".</p>
    IncorrectFileSystemLifeCycleState(crate::error::IncorrectFileSystemLifeCycleState),
    /// <p>Returned if there's not enough capacity to provision additional throughput. This value might be returned when you try to create a file system in provisioned throughput mode, when you attempt to increase the provisioned throughput of an existing file system, or when you attempt to change an existing file system from Bursting Throughput to Provisioned Throughput mode. Try again later.</p>
    InsufficientThroughputCapacity(crate::error::InsufficientThroughputCapacity),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Returned if the specified file system does not have a replication configuration.</p>
    ReplicationNotFound(crate::error::ReplicationNotFound),
    /// <p>Returned if the throughput mode or amount of provisioned throughput can't be changed because the throughput limit of 1024 MiB/s has been reached.</p>
    ThroughputLimitExceeded(crate::error::ThroughputLimitExceeded),
    /// <p>Returned if the requested Amazon EFS functionality is not available in the specified Availability Zone.</p>
    UnsupportedAvailabilityZone(crate::error::UnsupportedAvailabilityZone),
    /// <p>Returned if the Backup service is not available in the Amazon Web Services Region in which the request was made.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateReplicationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateReplicationConfigurationErrorKind::BadRequest(_inner) => _inner.fmt(f),
            CreateReplicationConfigurationErrorKind::FileSystemLimitExceeded(_inner) => {
                _inner.fmt(f)
            }
            CreateReplicationConfigurationErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            CreateReplicationConfigurationErrorKind::IncorrectFileSystemLifeCycleState(_inner) => {
                _inner.fmt(f)
            }
            CreateReplicationConfigurationErrorKind::InsufficientThroughputCapacity(_inner) => {
                _inner.fmt(f)
            }
            CreateReplicationConfigurationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateReplicationConfigurationErrorKind::ReplicationNotFound(_inner) => _inner.fmt(f),
            CreateReplicationConfigurationErrorKind::ThroughputLimitExceeded(_inner) => {
                _inner.fmt(f)
            }
            CreateReplicationConfigurationErrorKind::UnsupportedAvailabilityZone(_inner) => {
                _inner.fmt(f)
            }
            CreateReplicationConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateReplicationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateReplicationConfigurationError {
    fn code(&self) -> Option<&str> {
        CreateReplicationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateReplicationConfigurationError {
    /// Creates a new `CreateReplicationConfigurationError`.
    pub fn new(
        kind: CreateReplicationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateReplicationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateReplicationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateReplicationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateReplicationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationErrorKind::FileSystemLimitExceeded`.
    pub fn is_file_system_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationErrorKind::FileSystemLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationErrorKind::IncorrectFileSystemLifeCycleState`.
    pub fn is_incorrect_file_system_life_cycle_state(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationErrorKind::IncorrectFileSystemLifeCycleState(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationErrorKind::InsufficientThroughputCapacity`.
    pub fn is_insufficient_throughput_capacity(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationErrorKind::InsufficientThroughputCapacity(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationErrorKind::ReplicationNotFound`.
    pub fn is_replication_not_found(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationErrorKind::ReplicationNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationErrorKind::ThroughputLimitExceeded`.
    pub fn is_throughput_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationErrorKind::ThroughputLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationErrorKind::UnsupportedAvailabilityZone`.
    pub fn is_unsupported_availability_zone(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationErrorKind::UnsupportedAvailabilityZone(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateReplicationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateReplicationConfigurationErrorKind::BadRequest(_inner) => Some(_inner),
            CreateReplicationConfigurationErrorKind::FileSystemLimitExceeded(_inner) => {
                Some(_inner)
            }
            CreateReplicationConfigurationErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            CreateReplicationConfigurationErrorKind::IncorrectFileSystemLifeCycleState(_inner) => {
                Some(_inner)
            }
            CreateReplicationConfigurationErrorKind::InsufficientThroughputCapacity(_inner) => {
                Some(_inner)
            }
            CreateReplicationConfigurationErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateReplicationConfigurationErrorKind::ReplicationNotFound(_inner) => Some(_inner),
            CreateReplicationConfigurationErrorKind::ThroughputLimitExceeded(_inner) => {
                Some(_inner)
            }
            CreateReplicationConfigurationErrorKind::UnsupportedAvailabilityZone(_inner) => {
                Some(_inner)
            }
            CreateReplicationConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            CreateReplicationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTagsError {
    /// Kind of error that occurred.
    pub kind: CreateTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTagsErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTagsErrorKind::BadRequest(_inner) => _inner.fmt(f),
            CreateTagsErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            CreateTagsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            CreateTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTagsError {
    fn code(&self) -> Option<&str> {
        CreateTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTagsError {
    /// Creates a new `CreateTagsError`.
    pub fn new(kind: CreateTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTagsErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, CreateTagsErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `CreateTagsErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(&self.kind, CreateTagsErrorKind::FileSystemNotFound(_))
    }
    /// Returns `true` if the error kind is `CreateTagsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, CreateTagsErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for CreateTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTagsErrorKind::BadRequest(_inner) => Some(_inner),
            CreateTagsErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            CreateTagsErrorKind::InternalServerError(_inner) => Some(_inner),
            CreateTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAccessPoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAccessPointError {
    /// Kind of error that occurred.
    pub kind: DeleteAccessPointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAccessPoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAccessPointErrorKind {
    /// <p>Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    AccessPointNotFound(crate::error::AccessPointNotFound),
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAccessPointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAccessPointErrorKind::AccessPointNotFound(_inner) => _inner.fmt(f),
            DeleteAccessPointErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DeleteAccessPointErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteAccessPointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAccessPointError {
    fn code(&self) -> Option<&str> {
        DeleteAccessPointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAccessPointError {
    /// Creates a new `DeleteAccessPointError`.
    pub fn new(kind: DeleteAccessPointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAccessPointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAccessPointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAccessPointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAccessPointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAccessPointErrorKind::AccessPointNotFound`.
    pub fn is_access_point_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccessPointErrorKind::AccessPointNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccessPointErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DeleteAccessPointErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DeleteAccessPointErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccessPointErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DeleteAccessPointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAccessPointErrorKind::AccessPointNotFound(_inner) => Some(_inner),
            DeleteAccessPointErrorKind::BadRequest(_inner) => Some(_inner),
            DeleteAccessPointErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteAccessPointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFileSystem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFileSystemError {
    /// Kind of error that occurred.
    pub kind: DeleteFileSystemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFileSystem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFileSystemErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if a file system has mount targets.</p>
    FileSystemInUse(crate::error::FileSystemInUse),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFileSystemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFileSystemErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DeleteFileSystemErrorKind::FileSystemInUse(_inner) => _inner.fmt(f),
            DeleteFileSystemErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            DeleteFileSystemErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteFileSystemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFileSystemError {
    fn code(&self) -> Option<&str> {
        DeleteFileSystemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFileSystemError {
    /// Creates a new `DeleteFileSystemError`.
    pub fn new(kind: DeleteFileSystemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFileSystemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFileSystemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFileSystemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFileSystemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFileSystemErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DeleteFileSystemErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DeleteFileSystemErrorKind::FileSystemInUse`.
    pub fn is_file_system_in_use(&self) -> bool {
        matches!(&self.kind, DeleteFileSystemErrorKind::FileSystemInUse(_))
    }
    /// Returns `true` if the error kind is `DeleteFileSystemErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(&self.kind, DeleteFileSystemErrorKind::FileSystemNotFound(_))
    }
    /// Returns `true` if the error kind is `DeleteFileSystemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileSystemErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DeleteFileSystemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFileSystemErrorKind::BadRequest(_inner) => Some(_inner),
            DeleteFileSystemErrorKind::FileSystemInUse(_inner) => Some(_inner),
            DeleteFileSystemErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DeleteFileSystemErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteFileSystemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFileSystemPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFileSystemPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteFileSystemPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFileSystemPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFileSystemPolicyErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if the file system's lifecycle state is not "available".</p>
    IncorrectFileSystemLifeCycleState(crate::error::IncorrectFileSystemLifeCycleState),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFileSystemPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFileSystemPolicyErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DeleteFileSystemPolicyErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            DeleteFileSystemPolicyErrorKind::IncorrectFileSystemLifeCycleState(_inner) => {
                _inner.fmt(f)
            }
            DeleteFileSystemPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteFileSystemPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFileSystemPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteFileSystemPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFileSystemPolicyError {
    /// Creates a new `DeleteFileSystemPolicyError`.
    pub fn new(kind: DeleteFileSystemPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFileSystemPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFileSystemPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFileSystemPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFileSystemPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFileSystemPolicyErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DeleteFileSystemPolicyErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DeleteFileSystemPolicyErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileSystemPolicyErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileSystemPolicyErrorKind::IncorrectFileSystemLifeCycleState`.
    pub fn is_incorrect_file_system_life_cycle_state(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileSystemPolicyErrorKind::IncorrectFileSystemLifeCycleState(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileSystemPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileSystemPolicyErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DeleteFileSystemPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFileSystemPolicyErrorKind::BadRequest(_inner) => Some(_inner),
            DeleteFileSystemPolicyErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DeleteFileSystemPolicyErrorKind::IncorrectFileSystemLifeCycleState(_inner) => {
                Some(_inner)
            }
            DeleteFileSystemPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteFileSystemPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMountTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMountTargetError {
    /// Kind of error that occurred.
    pub kind: DeleteMountTargetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMountTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMountTargetErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>The service timed out trying to fulfill the request, and the client should try the call again.</p>
    DependencyTimeout(crate::error::DependencyTimeout),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Returned if there is no mount target with the specified ID found in the caller's Amazon Web Services account.</p>
    MountTargetNotFound(crate::error::MountTargetNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMountTargetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMountTargetErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DeleteMountTargetErrorKind::DependencyTimeout(_inner) => _inner.fmt(f),
            DeleteMountTargetErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteMountTargetErrorKind::MountTargetNotFound(_inner) => _inner.fmt(f),
            DeleteMountTargetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMountTargetError {
    fn code(&self) -> Option<&str> {
        DeleteMountTargetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMountTargetError {
    /// Creates a new `DeleteMountTargetError`.
    pub fn new(kind: DeleteMountTargetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMountTargetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMountTargetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMountTargetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMountTargetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMountTargetErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DeleteMountTargetErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DeleteMountTargetErrorKind::DependencyTimeout`.
    pub fn is_dependency_timeout(&self) -> bool {
        matches!(&self.kind, DeleteMountTargetErrorKind::DependencyTimeout(_))
    }
    /// Returns `true` if the error kind is `DeleteMountTargetErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMountTargetErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMountTargetErrorKind::MountTargetNotFound`.
    pub fn is_mount_target_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMountTargetErrorKind::MountTargetNotFound(_)
        )
    }
}
impl std::error::Error for DeleteMountTargetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMountTargetErrorKind::BadRequest(_inner) => Some(_inner),
            DeleteMountTargetErrorKind::DependencyTimeout(_inner) => Some(_inner),
            DeleteMountTargetErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteMountTargetErrorKind::MountTargetNotFound(_inner) => Some(_inner),
            DeleteMountTargetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteReplicationConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteReplicationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteReplicationConfigurationErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Returned if the specified file system does not have a replication configuration.</p>
    ReplicationNotFound(crate::error::ReplicationNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteReplicationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteReplicationConfigurationErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DeleteReplicationConfigurationErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            DeleteReplicationConfigurationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteReplicationConfigurationErrorKind::ReplicationNotFound(_inner) => _inner.fmt(f),
            DeleteReplicationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteReplicationConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteReplicationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteReplicationConfigurationError {
    /// Creates a new `DeleteReplicationConfigurationError`.
    pub fn new(
        kind: DeleteReplicationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteReplicationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteReplicationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteReplicationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteReplicationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteReplicationConfigurationErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationConfigurationErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReplicationConfigurationErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationConfigurationErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReplicationConfigurationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationConfigurationErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReplicationConfigurationErrorKind::ReplicationNotFound`.
    pub fn is_replication_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationConfigurationErrorKind::ReplicationNotFound(_)
        )
    }
}
impl std::error::Error for DeleteReplicationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteReplicationConfigurationErrorKind::BadRequest(_inner) => Some(_inner),
            DeleteReplicationConfigurationErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DeleteReplicationConfigurationErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteReplicationConfigurationErrorKind::ReplicationNotFound(_inner) => Some(_inner),
            DeleteReplicationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTagsError {
    /// Kind of error that occurred.
    pub kind: DeleteTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTagsErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTagsErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTagsError {
    fn code(&self) -> Option<&str> {
        DeleteTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTagsError {
    /// Creates a new `DeleteTagsError`.
    pub fn new(kind: DeleteTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DeleteTagsErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(&self.kind, DeleteTagsErrorKind::FileSystemNotFound(_))
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DeleteTagsErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for DeleteTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTagsErrorKind::BadRequest(_inner) => Some(_inner),
            DeleteTagsErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DeleteTagsErrorKind::InternalServerError(_inner) => Some(_inner),
            DeleteTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccessPoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccessPointsError {
    /// Kind of error that occurred.
    pub kind: DescribeAccessPointsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccessPoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccessPointsErrorKind {
    /// <p>Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    AccessPointNotFound(crate::error::AccessPointNotFound),
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccessPointsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccessPointsErrorKind::AccessPointNotFound(_inner) => _inner.fmt(f),
            DescribeAccessPointsErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DescribeAccessPointsErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            DescribeAccessPointsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeAccessPointsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccessPointsError {
    fn code(&self) -> Option<&str> {
        DescribeAccessPointsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccessPointsError {
    /// Creates a new `DescribeAccessPointsError`.
    pub fn new(kind: DescribeAccessPointsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccessPointsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccessPointsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccessPointsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccessPointsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAccessPointsErrorKind::AccessPointNotFound`.
    pub fn is_access_point_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccessPointsErrorKind::AccessPointNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccessPointsErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DescribeAccessPointsErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DescribeAccessPointsErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccessPointsErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAccessPointsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccessPointsErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeAccessPointsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccessPointsErrorKind::AccessPointNotFound(_inner) => Some(_inner),
            DescribeAccessPointsErrorKind::BadRequest(_inner) => Some(_inner),
            DescribeAccessPointsErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DescribeAccessPointsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeAccessPointsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccountPreferences` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountPreferencesError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountPreferencesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountPreferences` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountPreferencesErrorKind {
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountPreferencesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountPreferencesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeAccountPreferencesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountPreferencesError {
    fn code(&self) -> Option<&str> {
        DescribeAccountPreferencesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountPreferencesError {
    /// Creates a new `DescribeAccountPreferencesError`.
    pub fn new(kind: DescribeAccountPreferencesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountPreferencesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountPreferencesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountPreferencesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountPreferencesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAccountPreferencesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAccountPreferencesErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeAccountPreferencesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountPreferencesErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeAccountPreferencesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBackupPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBackupPolicyError {
    /// Kind of error that occurred.
    pub kind: DescribeBackupPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBackupPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBackupPolicyErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Returned if the default file system policy is in effect for the EFS file system specified.</p>
    PolicyNotFound(crate::error::PolicyNotFound),
    /// <p>Returned if the Backup service is not available in the Amazon Web Services Region in which the request was made.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBackupPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBackupPolicyErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DescribeBackupPolicyErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            DescribeBackupPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeBackupPolicyErrorKind::PolicyNotFound(_inner) => _inner.fmt(f),
            DescribeBackupPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeBackupPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBackupPolicyError {
    fn code(&self) -> Option<&str> {
        DescribeBackupPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBackupPolicyError {
    /// Creates a new `DescribeBackupPolicyError`.
    pub fn new(kind: DescribeBackupPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBackupPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBackupPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBackupPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBackupPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBackupPolicyErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DescribeBackupPolicyErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DescribeBackupPolicyErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBackupPolicyErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBackupPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBackupPolicyErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBackupPolicyErrorKind::PolicyNotFound`.
    pub fn is_policy_not_found(&self) -> bool {
        matches!(&self.kind, DescribeBackupPolicyErrorKind::PolicyNotFound(_))
    }
    /// Returns `true` if the error kind is `DescribeBackupPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBackupPolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeBackupPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBackupPolicyErrorKind::BadRequest(_inner) => Some(_inner),
            DescribeBackupPolicyErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DescribeBackupPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeBackupPolicyErrorKind::PolicyNotFound(_inner) => Some(_inner),
            DescribeBackupPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeBackupPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFileSystemPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFileSystemPolicyError {
    /// Kind of error that occurred.
    pub kind: DescribeFileSystemPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFileSystemPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFileSystemPolicyErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Returned if the default file system policy is in effect for the EFS file system specified.</p>
    PolicyNotFound(crate::error::PolicyNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFileSystemPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFileSystemPolicyErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DescribeFileSystemPolicyErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            DescribeFileSystemPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeFileSystemPolicyErrorKind::PolicyNotFound(_inner) => _inner.fmt(f),
            DescribeFileSystemPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFileSystemPolicyError {
    fn code(&self) -> Option<&str> {
        DescribeFileSystemPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFileSystemPolicyError {
    /// Creates a new `DescribeFileSystemPolicyError`.
    pub fn new(kind: DescribeFileSystemPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFileSystemPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFileSystemPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFileSystemPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFileSystemPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFileSystemPolicyErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DescribeFileSystemPolicyErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DescribeFileSystemPolicyErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFileSystemPolicyErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFileSystemPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFileSystemPolicyErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFileSystemPolicyErrorKind::PolicyNotFound`.
    pub fn is_policy_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFileSystemPolicyErrorKind::PolicyNotFound(_)
        )
    }
}
impl std::error::Error for DescribeFileSystemPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFileSystemPolicyErrorKind::BadRequest(_inner) => Some(_inner),
            DescribeFileSystemPolicyErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DescribeFileSystemPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeFileSystemPolicyErrorKind::PolicyNotFound(_inner) => Some(_inner),
            DescribeFileSystemPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFileSystems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFileSystemsError {
    /// Kind of error that occurred.
    pub kind: DescribeFileSystemsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFileSystems` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFileSystemsErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFileSystemsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFileSystemsErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DescribeFileSystemsErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            DescribeFileSystemsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeFileSystemsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFileSystemsError {
    fn code(&self) -> Option<&str> {
        DescribeFileSystemsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFileSystemsError {
    /// Creates a new `DescribeFileSystemsError`.
    pub fn new(kind: DescribeFileSystemsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFileSystemsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFileSystemsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFileSystemsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFileSystemsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFileSystemsErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DescribeFileSystemsErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DescribeFileSystemsErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFileSystemsErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFileSystemsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFileSystemsErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeFileSystemsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFileSystemsErrorKind::BadRequest(_inner) => Some(_inner),
            DescribeFileSystemsErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DescribeFileSystemsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeFileSystemsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLifecycleConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLifecycleConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeLifecycleConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLifecycleConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLifecycleConfigurationErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLifecycleConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLifecycleConfigurationErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DescribeLifecycleConfigurationErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            DescribeLifecycleConfigurationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeLifecycleConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLifecycleConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeLifecycleConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLifecycleConfigurationError {
    /// Creates a new `DescribeLifecycleConfigurationError`.
    pub fn new(
        kind: DescribeLifecycleConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLifecycleConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLifecycleConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLifecycleConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLifecycleConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLifecycleConfigurationErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLifecycleConfigurationErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLifecycleConfigurationErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLifecycleConfigurationErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLifecycleConfigurationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLifecycleConfigurationErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for DescribeLifecycleConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLifecycleConfigurationErrorKind::BadRequest(_inner) => Some(_inner),
            DescribeLifecycleConfigurationErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DescribeLifecycleConfigurationErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeLifecycleConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMountTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMountTargetsError {
    /// Kind of error that occurred.
    pub kind: DescribeMountTargetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMountTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMountTargetsErrorKind {
    /// <p>Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    AccessPointNotFound(crate::error::AccessPointNotFound),
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Returned if there is no mount target with the specified ID found in the caller's Amazon Web Services account.</p>
    MountTargetNotFound(crate::error::MountTargetNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMountTargetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMountTargetsErrorKind::AccessPointNotFound(_inner) => _inner.fmt(f),
            DescribeMountTargetsErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DescribeMountTargetsErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            DescribeMountTargetsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeMountTargetsErrorKind::MountTargetNotFound(_inner) => _inner.fmt(f),
            DescribeMountTargetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMountTargetsError {
    fn code(&self) -> Option<&str> {
        DescribeMountTargetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMountTargetsError {
    /// Creates a new `DescribeMountTargetsError`.
    pub fn new(kind: DescribeMountTargetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMountTargetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMountTargetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMountTargetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMountTargetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMountTargetsErrorKind::AccessPointNotFound`.
    pub fn is_access_point_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMountTargetsErrorKind::AccessPointNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMountTargetsErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DescribeMountTargetsErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DescribeMountTargetsErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMountTargetsErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMountTargetsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMountTargetsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMountTargetsErrorKind::MountTargetNotFound`.
    pub fn is_mount_target_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMountTargetsErrorKind::MountTargetNotFound(_)
        )
    }
}
impl std::error::Error for DescribeMountTargetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMountTargetsErrorKind::AccessPointNotFound(_inner) => Some(_inner),
            DescribeMountTargetsErrorKind::BadRequest(_inner) => Some(_inner),
            DescribeMountTargetsErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DescribeMountTargetsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeMountTargetsErrorKind::MountTargetNotFound(_inner) => Some(_inner),
            DescribeMountTargetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMountTargetSecurityGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMountTargetSecurityGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeMountTargetSecurityGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMountTargetSecurityGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMountTargetSecurityGroupsErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the mount target is not in the correct state for the operation.</p>
    IncorrectMountTargetState(crate::error::IncorrectMountTargetState),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Returned if there is no mount target with the specified ID found in the caller's Amazon Web Services account.</p>
    MountTargetNotFound(crate::error::MountTargetNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMountTargetSecurityGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMountTargetSecurityGroupsErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DescribeMountTargetSecurityGroupsErrorKind::IncorrectMountTargetState(_inner) => {
                _inner.fmt(f)
            }
            DescribeMountTargetSecurityGroupsErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DescribeMountTargetSecurityGroupsErrorKind::MountTargetNotFound(_inner) => {
                _inner.fmt(f)
            }
            DescribeMountTargetSecurityGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMountTargetSecurityGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeMountTargetSecurityGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMountTargetSecurityGroupsError {
    /// Creates a new `DescribeMountTargetSecurityGroupsError`.
    pub fn new(
        kind: DescribeMountTargetSecurityGroupsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMountTargetSecurityGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMountTargetSecurityGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMountTargetSecurityGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMountTargetSecurityGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMountTargetSecurityGroupsErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMountTargetSecurityGroupsErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMountTargetSecurityGroupsErrorKind::IncorrectMountTargetState`.
    pub fn is_incorrect_mount_target_state(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMountTargetSecurityGroupsErrorKind::IncorrectMountTargetState(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMountTargetSecurityGroupsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMountTargetSecurityGroupsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMountTargetSecurityGroupsErrorKind::MountTargetNotFound`.
    pub fn is_mount_target_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMountTargetSecurityGroupsErrorKind::MountTargetNotFound(_)
        )
    }
}
impl std::error::Error for DescribeMountTargetSecurityGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMountTargetSecurityGroupsErrorKind::BadRequest(_inner) => Some(_inner),
            DescribeMountTargetSecurityGroupsErrorKind::IncorrectMountTargetState(_inner) => {
                Some(_inner)
            }
            DescribeMountTargetSecurityGroupsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeMountTargetSecurityGroupsErrorKind::MountTargetNotFound(_inner) => Some(_inner),
            DescribeMountTargetSecurityGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReplicationConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReplicationConfigurationsError {
    /// Kind of error that occurred.
    pub kind: DescribeReplicationConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReplicationConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReplicationConfigurationsErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Returned if the specified file system does not have a replication configuration.</p>
    ReplicationNotFound(crate::error::ReplicationNotFound),
    /// <p>Returned if the Backup service is not available in the Amazon Web Services Region in which the request was made.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReplicationConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReplicationConfigurationsErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DescribeReplicationConfigurationsErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            DescribeReplicationConfigurationsErrorKind::InternalServerError(_inner) => {
                _inner.fmt(f)
            }
            DescribeReplicationConfigurationsErrorKind::ReplicationNotFound(_inner) => {
                _inner.fmt(f)
            }
            DescribeReplicationConfigurationsErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeReplicationConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReplicationConfigurationsError {
    fn code(&self) -> Option<&str> {
        DescribeReplicationConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReplicationConfigurationsError {
    /// Creates a new `DescribeReplicationConfigurationsError`.
    pub fn new(
        kind: DescribeReplicationConfigurationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReplicationConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReplicationConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReplicationConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReplicationConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReplicationConfigurationsErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationConfigurationsErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReplicationConfigurationsErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationConfigurationsErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReplicationConfigurationsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationConfigurationsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReplicationConfigurationsErrorKind::ReplicationNotFound`.
    pub fn is_replication_not_found(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationConfigurationsErrorKind::ReplicationNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReplicationConfigurationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationConfigurationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeReplicationConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReplicationConfigurationsErrorKind::BadRequest(_inner) => Some(_inner),
            DescribeReplicationConfigurationsErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DescribeReplicationConfigurationsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeReplicationConfigurationsErrorKind::ReplicationNotFound(_inner) => Some(_inner),
            DescribeReplicationConfigurationsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeReplicationConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTagsError {
    /// Kind of error that occurred.
    pub kind: DescribeTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTagsErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTagsErrorKind::BadRequest(_inner) => _inner.fmt(f),
            DescribeTagsErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            DescribeTagsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            DescribeTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTagsError {
    fn code(&self) -> Option<&str> {
        DescribeTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTagsError {
    /// Creates a new `DescribeTagsError`.
    pub fn new(kind: DescribeTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTagsErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, DescribeTagsErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `DescribeTagsErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(&self.kind, DescribeTagsErrorKind::FileSystemNotFound(_))
    }
    /// Returns `true` if the error kind is `DescribeTagsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, DescribeTagsErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for DescribeTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTagsErrorKind::BadRequest(_inner) => Some(_inner),
            DescribeTagsErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            DescribeTagsErrorKind::InternalServerError(_inner) => Some(_inner),
            DescribeTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    AccessPointNotFound(crate::error::AccessPointNotFound),
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessPointNotFound(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::BadRequest(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessPointNotFound`.
    pub fn is_access_point_not_found(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessPointNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, ListTagsForResourceErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessPointNotFound(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::BadRequest(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyMountTargetSecurityGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyMountTargetSecurityGroupsError {
    /// Kind of error that occurred.
    pub kind: ModifyMountTargetSecurityGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyMountTargetSecurityGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyMountTargetSecurityGroupsErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the mount target is not in the correct state for the operation.</p>
    IncorrectMountTargetState(crate::error::IncorrectMountTargetState),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Returned if there is no mount target with the specified ID found in the caller's Amazon Web Services account.</p>
    MountTargetNotFound(crate::error::MountTargetNotFound),
    /// <p>Returned if the size of <code>SecurityGroups</code> specified in the request is greater than five.</p>
    SecurityGroupLimitExceeded(crate::error::SecurityGroupLimitExceeded),
    /// <p>Returned if one of the specified security groups doesn't exist in the subnet's virtual private cloud (VPC).</p>
    SecurityGroupNotFound(crate::error::SecurityGroupNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyMountTargetSecurityGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyMountTargetSecurityGroupsErrorKind::BadRequest(_inner) => _inner.fmt(f),
            ModifyMountTargetSecurityGroupsErrorKind::IncorrectMountTargetState(_inner) => {
                _inner.fmt(f)
            }
            ModifyMountTargetSecurityGroupsErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            ModifyMountTargetSecurityGroupsErrorKind::MountTargetNotFound(_inner) => _inner.fmt(f),
            ModifyMountTargetSecurityGroupsErrorKind::SecurityGroupLimitExceeded(_inner) => {
                _inner.fmt(f)
            }
            ModifyMountTargetSecurityGroupsErrorKind::SecurityGroupNotFound(_inner) => {
                _inner.fmt(f)
            }
            ModifyMountTargetSecurityGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyMountTargetSecurityGroupsError {
    fn code(&self) -> Option<&str> {
        ModifyMountTargetSecurityGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyMountTargetSecurityGroupsError {
    /// Creates a new `ModifyMountTargetSecurityGroupsError`.
    pub fn new(
        kind: ModifyMountTargetSecurityGroupsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyMountTargetSecurityGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyMountTargetSecurityGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyMountTargetSecurityGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyMountTargetSecurityGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyMountTargetSecurityGroupsErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            ModifyMountTargetSecurityGroupsErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyMountTargetSecurityGroupsErrorKind::IncorrectMountTargetState`.
    pub fn is_incorrect_mount_target_state(&self) -> bool {
        matches!(
            &self.kind,
            ModifyMountTargetSecurityGroupsErrorKind::IncorrectMountTargetState(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyMountTargetSecurityGroupsErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            ModifyMountTargetSecurityGroupsErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyMountTargetSecurityGroupsErrorKind::MountTargetNotFound`.
    pub fn is_mount_target_not_found(&self) -> bool {
        matches!(
            &self.kind,
            ModifyMountTargetSecurityGroupsErrorKind::MountTargetNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyMountTargetSecurityGroupsErrorKind::SecurityGroupLimitExceeded`.
    pub fn is_security_group_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            ModifyMountTargetSecurityGroupsErrorKind::SecurityGroupLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyMountTargetSecurityGroupsErrorKind::SecurityGroupNotFound`.
    pub fn is_security_group_not_found(&self) -> bool {
        matches!(
            &self.kind,
            ModifyMountTargetSecurityGroupsErrorKind::SecurityGroupNotFound(_)
        )
    }
}
impl std::error::Error for ModifyMountTargetSecurityGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyMountTargetSecurityGroupsErrorKind::BadRequest(_inner) => Some(_inner),
            ModifyMountTargetSecurityGroupsErrorKind::IncorrectMountTargetState(_inner) => {
                Some(_inner)
            }
            ModifyMountTargetSecurityGroupsErrorKind::InternalServerError(_inner) => Some(_inner),
            ModifyMountTargetSecurityGroupsErrorKind::MountTargetNotFound(_inner) => Some(_inner),
            ModifyMountTargetSecurityGroupsErrorKind::SecurityGroupLimitExceeded(_inner) => {
                Some(_inner)
            }
            ModifyMountTargetSecurityGroupsErrorKind::SecurityGroupNotFound(_inner) => Some(_inner),
            ModifyMountTargetSecurityGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutAccountPreferences` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutAccountPreferencesError {
    /// Kind of error that occurred.
    pub kind: PutAccountPreferencesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutAccountPreferences` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutAccountPreferencesErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutAccountPreferencesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutAccountPreferencesErrorKind::BadRequest(_inner) => _inner.fmt(f),
            PutAccountPreferencesErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            PutAccountPreferencesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutAccountPreferencesError {
    fn code(&self) -> Option<&str> {
        PutAccountPreferencesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutAccountPreferencesError {
    /// Creates a new `PutAccountPreferencesError`.
    pub fn new(kind: PutAccountPreferencesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutAccountPreferencesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutAccountPreferencesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutAccountPreferencesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutAccountPreferencesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutAccountPreferencesErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, PutAccountPreferencesErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `PutAccountPreferencesErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            PutAccountPreferencesErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for PutAccountPreferencesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutAccountPreferencesErrorKind::BadRequest(_inner) => Some(_inner),
            PutAccountPreferencesErrorKind::InternalServerError(_inner) => Some(_inner),
            PutAccountPreferencesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutBackupPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutBackupPolicyError {
    /// Kind of error that occurred.
    pub kind: PutBackupPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutBackupPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutBackupPolicyErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if the file system's lifecycle state is not "available".</p>
    IncorrectFileSystemLifeCycleState(crate::error::IncorrectFileSystemLifeCycleState),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Returned if the Backup service is not available in the Amazon Web Services Region in which the request was made.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutBackupPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutBackupPolicyErrorKind::BadRequest(_inner) => _inner.fmt(f),
            PutBackupPolicyErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            PutBackupPolicyErrorKind::IncorrectFileSystemLifeCycleState(_inner) => _inner.fmt(f),
            PutBackupPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            PutBackupPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutBackupPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutBackupPolicyError {
    fn code(&self) -> Option<&str> {
        PutBackupPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutBackupPolicyError {
    /// Creates a new `PutBackupPolicyError`.
    pub fn new(kind: PutBackupPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutBackupPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutBackupPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutBackupPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutBackupPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutBackupPolicyErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, PutBackupPolicyErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `PutBackupPolicyErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(&self.kind, PutBackupPolicyErrorKind::FileSystemNotFound(_))
    }
    /// Returns `true` if the error kind is `PutBackupPolicyErrorKind::IncorrectFileSystemLifeCycleState`.
    pub fn is_incorrect_file_system_life_cycle_state(&self) -> bool {
        matches!(
            &self.kind,
            PutBackupPolicyErrorKind::IncorrectFileSystemLifeCycleState(_)
        )
    }
    /// Returns `true` if the error kind is `PutBackupPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, PutBackupPolicyErrorKind::InternalServerError(_))
    }
    /// Returns `true` if the error kind is `PutBackupPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, PutBackupPolicyErrorKind::ValidationException(_))
    }
}
impl std::error::Error for PutBackupPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutBackupPolicyErrorKind::BadRequest(_inner) => Some(_inner),
            PutBackupPolicyErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            PutBackupPolicyErrorKind::IncorrectFileSystemLifeCycleState(_inner) => Some(_inner),
            PutBackupPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            PutBackupPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            PutBackupPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutFileSystemPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutFileSystemPolicyError {
    /// Kind of error that occurred.
    pub kind: PutFileSystemPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutFileSystemPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutFileSystemPolicyErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if the file system's lifecycle state is not "available".</p>
    IncorrectFileSystemLifeCycleState(crate::error::IncorrectFileSystemLifeCycleState),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Returned if the <code>FileSystemPolicy</code> is malformed or contains an error such as a parameter value that is not valid or a missing required parameter. Returned in the case of a policy lockout safety check error.</p>
    InvalidPolicyException(crate::error::InvalidPolicyException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutFileSystemPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutFileSystemPolicyErrorKind::BadRequest(_inner) => _inner.fmt(f),
            PutFileSystemPolicyErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            PutFileSystemPolicyErrorKind::IncorrectFileSystemLifeCycleState(_inner) => {
                _inner.fmt(f)
            }
            PutFileSystemPolicyErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            PutFileSystemPolicyErrorKind::InvalidPolicyException(_inner) => _inner.fmt(f),
            PutFileSystemPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutFileSystemPolicyError {
    fn code(&self) -> Option<&str> {
        PutFileSystemPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutFileSystemPolicyError {
    /// Creates a new `PutFileSystemPolicyError`.
    pub fn new(kind: PutFileSystemPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutFileSystemPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutFileSystemPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutFileSystemPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutFileSystemPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutFileSystemPolicyErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, PutFileSystemPolicyErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `PutFileSystemPolicyErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            PutFileSystemPolicyErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileSystemPolicyErrorKind::IncorrectFileSystemLifeCycleState`.
    pub fn is_incorrect_file_system_life_cycle_state(&self) -> bool {
        matches!(
            &self.kind,
            PutFileSystemPolicyErrorKind::IncorrectFileSystemLifeCycleState(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileSystemPolicyErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            PutFileSystemPolicyErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileSystemPolicyErrorKind::InvalidPolicyException`.
    pub fn is_invalid_policy_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileSystemPolicyErrorKind::InvalidPolicyException(_)
        )
    }
}
impl std::error::Error for PutFileSystemPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutFileSystemPolicyErrorKind::BadRequest(_inner) => Some(_inner),
            PutFileSystemPolicyErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            PutFileSystemPolicyErrorKind::IncorrectFileSystemLifeCycleState(_inner) => Some(_inner),
            PutFileSystemPolicyErrorKind::InternalServerError(_inner) => Some(_inner),
            PutFileSystemPolicyErrorKind::InvalidPolicyException(_inner) => Some(_inner),
            PutFileSystemPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutLifecycleConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutLifecycleConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutLifecycleConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutLifecycleConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutLifecycleConfigurationErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if the file system's lifecycle state is not "available".</p>
    IncorrectFileSystemLifeCycleState(crate::error::IncorrectFileSystemLifeCycleState),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutLifecycleConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutLifecycleConfigurationErrorKind::BadRequest(_inner) => _inner.fmt(f),
            PutLifecycleConfigurationErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            PutLifecycleConfigurationErrorKind::IncorrectFileSystemLifeCycleState(_inner) => {
                _inner.fmt(f)
            }
            PutLifecycleConfigurationErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            PutLifecycleConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutLifecycleConfigurationError {
    fn code(&self) -> Option<&str> {
        PutLifecycleConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutLifecycleConfigurationError {
    /// Creates a new `PutLifecycleConfigurationError`.
    pub fn new(kind: PutLifecycleConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutLifecycleConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutLifecycleConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutLifecycleConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutLifecycleConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutLifecycleConfigurationErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(
            &self.kind,
            PutLifecycleConfigurationErrorKind::BadRequest(_)
        )
    }
    /// Returns `true` if the error kind is `PutLifecycleConfigurationErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(
            &self.kind,
            PutLifecycleConfigurationErrorKind::FileSystemNotFound(_)
        )
    }
    /// Returns `true` if the error kind is `PutLifecycleConfigurationErrorKind::IncorrectFileSystemLifeCycleState`.
    pub fn is_incorrect_file_system_life_cycle_state(&self) -> bool {
        matches!(
            &self.kind,
            PutLifecycleConfigurationErrorKind::IncorrectFileSystemLifeCycleState(_)
        )
    }
    /// Returns `true` if the error kind is `PutLifecycleConfigurationErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            PutLifecycleConfigurationErrorKind::InternalServerError(_)
        )
    }
}
impl std::error::Error for PutLifecycleConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutLifecycleConfigurationErrorKind::BadRequest(_inner) => Some(_inner),
            PutLifecycleConfigurationErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            PutLifecycleConfigurationErrorKind::IncorrectFileSystemLifeCycleState(_inner) => {
                Some(_inner)
            }
            PutLifecycleConfigurationErrorKind::InternalServerError(_inner) => Some(_inner),
            PutLifecycleConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    AccessPointNotFound(crate::error::AccessPointNotFound),
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessPointNotFound(_inner) => _inner.fmt(f),
            TagResourceErrorKind::BadRequest(_inner) => _inner.fmt(f),
            TagResourceErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessPointNotFound`.
    pub fn is_access_point_not_found(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessPointNotFound(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::FileSystemNotFound(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessPointNotFound(_inner) => Some(_inner),
            TagResourceErrorKind::BadRequest(_inner) => Some(_inner),
            TagResourceErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    AccessPointNotFound(crate::error::AccessPointNotFound),
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessPointNotFound(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::BadRequest(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessPointNotFound`.
    pub fn is_access_point_not_found(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessPointNotFound(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::FileSystemNotFound(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InternalServerError(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessPointNotFound(_inner) => Some(_inner),
            UntagResourceErrorKind::BadRequest(_inner) => Some(_inner),
            UntagResourceErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerError(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFileSystem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFileSystemError {
    /// Kind of error that occurred.
    pub kind: UpdateFileSystemErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFileSystem` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFileSystemErrorKind {
    /// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
    BadRequest(crate::error::BadRequest),
    /// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
    FileSystemNotFound(crate::error::FileSystemNotFound),
    /// <p>Returned if the file system's lifecycle state is not "available".</p>
    IncorrectFileSystemLifeCycleState(crate::error::IncorrectFileSystemLifeCycleState),
    /// <p>Returned if there's not enough capacity to provision additional throughput. This value might be returned when you try to create a file system in provisioned throughput mode, when you attempt to increase the provisioned throughput of an existing file system, or when you attempt to change an existing file system from Bursting Throughput to Provisioned Throughput mode. Try again later.</p>
    InsufficientThroughputCapacity(crate::error::InsufficientThroughputCapacity),
    /// <p>Returned if an error occurred on the server side.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>Returned if the throughput mode or amount of provisioned throughput can't be changed because the throughput limit of 1024 MiB/s has been reached.</p>
    ThroughputLimitExceeded(crate::error::ThroughputLimitExceeded),
    /// <p>Returned if you don’t wait at least 24 hours before either changing the throughput mode, or decreasing the Provisioned Throughput value.</p>
    TooManyRequests(crate::error::TooManyRequests),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFileSystemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFileSystemErrorKind::BadRequest(_inner) => _inner.fmt(f),
            UpdateFileSystemErrorKind::FileSystemNotFound(_inner) => _inner.fmt(f),
            UpdateFileSystemErrorKind::IncorrectFileSystemLifeCycleState(_inner) => _inner.fmt(f),
            UpdateFileSystemErrorKind::InsufficientThroughputCapacity(_inner) => _inner.fmt(f),
            UpdateFileSystemErrorKind::InternalServerError(_inner) => _inner.fmt(f),
            UpdateFileSystemErrorKind::ThroughputLimitExceeded(_inner) => _inner.fmt(f),
            UpdateFileSystemErrorKind::TooManyRequests(_inner) => _inner.fmt(f),
            UpdateFileSystemErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFileSystemError {
    fn code(&self) -> Option<&str> {
        UpdateFileSystemError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFileSystemError {
    /// Creates a new `UpdateFileSystemError`.
    pub fn new(kind: UpdateFileSystemErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFileSystemError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFileSystemErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFileSystemError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFileSystemErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFileSystemErrorKind::BadRequest`.
    pub fn is_bad_request(&self) -> bool {
        matches!(&self.kind, UpdateFileSystemErrorKind::BadRequest(_))
    }
    /// Returns `true` if the error kind is `UpdateFileSystemErrorKind::FileSystemNotFound`.
    pub fn is_file_system_not_found(&self) -> bool {
        matches!(&self.kind, UpdateFileSystemErrorKind::FileSystemNotFound(_))
    }
    /// Returns `true` if the error kind is `UpdateFileSystemErrorKind::IncorrectFileSystemLifeCycleState`.
    pub fn is_incorrect_file_system_life_cycle_state(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFileSystemErrorKind::IncorrectFileSystemLifeCycleState(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFileSystemErrorKind::InsufficientThroughputCapacity`.
    pub fn is_insufficient_throughput_capacity(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFileSystemErrorKind::InsufficientThroughputCapacity(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFileSystemErrorKind::InternalServerError`.
    pub fn is_internal_server_error(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFileSystemErrorKind::InternalServerError(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFileSystemErrorKind::ThroughputLimitExceeded`.
    pub fn is_throughput_limit_exceeded(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFileSystemErrorKind::ThroughputLimitExceeded(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFileSystemErrorKind::TooManyRequests`.
    pub fn is_too_many_requests(&self) -> bool {
        matches!(&self.kind, UpdateFileSystemErrorKind::TooManyRequests(_))
    }
}
impl std::error::Error for UpdateFileSystemError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFileSystemErrorKind::BadRequest(_inner) => Some(_inner),
            UpdateFileSystemErrorKind::FileSystemNotFound(_inner) => Some(_inner),
            UpdateFileSystemErrorKind::IncorrectFileSystemLifeCycleState(_inner) => Some(_inner),
            UpdateFileSystemErrorKind::InsufficientThroughputCapacity(_inner) => Some(_inner),
            UpdateFileSystemErrorKind::InternalServerError(_inner) => Some(_inner),
            UpdateFileSystemErrorKind::ThroughputLimitExceeded(_inner) => Some(_inner),
            UpdateFileSystemErrorKind::TooManyRequests(_inner) => Some(_inner),
            UpdateFileSystemErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Returned if you don’t wait at least 24 hours before either changing the throughput mode, or decreasing the Provisioned Throughput value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequests {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl TooManyRequests {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for TooManyRequests {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequests");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequests {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequests {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequests")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequests {}
/// See [`TooManyRequests`](crate::error::TooManyRequests)
pub mod too_many_requests {
    /// A builder for [`TooManyRequests`](crate::error::TooManyRequests)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequests`](crate::error::TooManyRequests)
        pub fn build(self) -> crate::error::TooManyRequests {
            crate::error::TooManyRequests {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl TooManyRequests {
    /// Creates a new builder-style object to manufacture [`TooManyRequests`](crate::error::TooManyRequests)
    pub fn builder() -> crate::error::too_many_requests::Builder {
        crate::error::too_many_requests::Builder::default()
    }
}

/// <p>Returned if the throughput mode or amount of provisioned throughput can't be changed because the throughput limit of 1024 MiB/s has been reached.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThroughputLimitExceeded {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ThroughputLimitExceeded {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for ThroughputLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThroughputLimitExceeded");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThroughputLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThroughputLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThroughputLimitExceeded")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThroughputLimitExceeded {}
/// See [`ThroughputLimitExceeded`](crate::error::ThroughputLimitExceeded)
pub mod throughput_limit_exceeded {
    /// A builder for [`ThroughputLimitExceeded`](crate::error::ThroughputLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThroughputLimitExceeded`](crate::error::ThroughputLimitExceeded)
        pub fn build(self) -> crate::error::ThroughputLimitExceeded {
            crate::error::ThroughputLimitExceeded {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl ThroughputLimitExceeded {
    /// Creates a new builder-style object to manufacture [`ThroughputLimitExceeded`](crate::error::ThroughputLimitExceeded)
    pub fn builder() -> crate::error::throughput_limit_exceeded::Builder {
        crate::error::throughput_limit_exceeded::Builder::default()
    }
}

/// <p>Returned if an error occurred on the server side.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerError {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl InternalServerError {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerError");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerError")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerError {}
/// See [`InternalServerError`](crate::error::InternalServerError)
pub mod internal_server_error {
    /// A builder for [`InternalServerError`](crate::error::InternalServerError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerError`](crate::error::InternalServerError)
        pub fn build(self) -> crate::error::InternalServerError {
            crate::error::InternalServerError {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl InternalServerError {
    /// Creates a new builder-style object to manufacture [`InternalServerError`](crate::error::InternalServerError)
    pub fn builder() -> crate::error::internal_server_error::Builder {
        crate::error::internal_server_error::Builder::default()
    }
}

/// <p>Returned if there's not enough capacity to provision additional throughput. This value might be returned when you try to create a file system in provisioned throughput mode, when you attempt to increase the provisioned throughput of an existing file system, or when you attempt to change an existing file system from Bursting Throughput to Provisioned Throughput mode. Try again later.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientThroughputCapacity {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl InsufficientThroughputCapacity {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for InsufficientThroughputCapacity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientThroughputCapacity");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientThroughputCapacity {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientThroughputCapacity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientThroughputCapacity")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientThroughputCapacity {}
/// See [`InsufficientThroughputCapacity`](crate::error::InsufficientThroughputCapacity)
pub mod insufficient_throughput_capacity {
    /// A builder for [`InsufficientThroughputCapacity`](crate::error::InsufficientThroughputCapacity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientThroughputCapacity`](crate::error::InsufficientThroughputCapacity)
        pub fn build(self) -> crate::error::InsufficientThroughputCapacity {
            crate::error::InsufficientThroughputCapacity {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl InsufficientThroughputCapacity {
    /// Creates a new builder-style object to manufacture [`InsufficientThroughputCapacity`](crate::error::InsufficientThroughputCapacity)
    pub fn builder() -> crate::error::insufficient_throughput_capacity::Builder {
        crate::error::insufficient_throughput_capacity::Builder::default()
    }
}

/// <p>Returned if the file system's lifecycle state is not "available".</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncorrectFileSystemLifeCycleState {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl IncorrectFileSystemLifeCycleState {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for IncorrectFileSystemLifeCycleState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncorrectFileSystemLifeCycleState");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IncorrectFileSystemLifeCycleState {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IncorrectFileSystemLifeCycleState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IncorrectFileSystemLifeCycleState")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for IncorrectFileSystemLifeCycleState {}
/// See [`IncorrectFileSystemLifeCycleState`](crate::error::IncorrectFileSystemLifeCycleState)
pub mod incorrect_file_system_life_cycle_state {
    /// A builder for [`IncorrectFileSystemLifeCycleState`](crate::error::IncorrectFileSystemLifeCycleState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IncorrectFileSystemLifeCycleState`](crate::error::IncorrectFileSystemLifeCycleState)
        pub fn build(self) -> crate::error::IncorrectFileSystemLifeCycleState {
            crate::error::IncorrectFileSystemLifeCycleState {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl IncorrectFileSystemLifeCycleState {
    /// Creates a new builder-style object to manufacture [`IncorrectFileSystemLifeCycleState`](crate::error::IncorrectFileSystemLifeCycleState)
    pub fn builder() -> crate::error::incorrect_file_system_life_cycle_state::Builder {
        crate::error::incorrect_file_system_life_cycle_state::Builder::default()
    }
}

/// <p>Returned if the specified <code>FileSystemId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileSystemNotFound {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl FileSystemNotFound {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for FileSystemNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileSystemNotFound");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FileSystemNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FileSystemNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FileSystemNotFound")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for FileSystemNotFound {}
/// See [`FileSystemNotFound`](crate::error::FileSystemNotFound)
pub mod file_system_not_found {
    /// A builder for [`FileSystemNotFound`](crate::error::FileSystemNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FileSystemNotFound`](crate::error::FileSystemNotFound)
        pub fn build(self) -> crate::error::FileSystemNotFound {
            crate::error::FileSystemNotFound {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl FileSystemNotFound {
    /// Creates a new builder-style object to manufacture [`FileSystemNotFound`](crate::error::FileSystemNotFound)
    pub fn builder() -> crate::error::file_system_not_found::Builder {
        crate::error::file_system_not_found::Builder::default()
    }
}

/// <p>Returned if the request is malformed or contains an error such as an invalid parameter value or a missing required parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequest {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl BadRequest {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for BadRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequest");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequest {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequest")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequest {}
/// See [`BadRequest`](crate::error::BadRequest)
pub mod bad_request {
    /// A builder for [`BadRequest`](crate::error::BadRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequest`](crate::error::BadRequest)
        pub fn build(self) -> crate::error::BadRequest {
            crate::error::BadRequest {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl BadRequest {
    /// Creates a new builder-style object to manufacture [`BadRequest`](crate::error::BadRequest)
    pub fn builder() -> crate::error::bad_request::Builder {
        crate::error::bad_request::Builder::default()
    }
}

/// <p>Returned if the specified <code>AccessPointId</code> value doesn't exist in the requester's Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessPointNotFound {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl AccessPointNotFound {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for AccessPointNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessPointNotFound");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessPointNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessPointNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessPointNotFound")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessPointNotFound {}
/// See [`AccessPointNotFound`](crate::error::AccessPointNotFound)
pub mod access_point_not_found {
    /// A builder for [`AccessPointNotFound`](crate::error::AccessPointNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessPointNotFound`](crate::error::AccessPointNotFound)
        pub fn build(self) -> crate::error::AccessPointNotFound {
            crate::error::AccessPointNotFound {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl AccessPointNotFound {
    /// Creates a new builder-style object to manufacture [`AccessPointNotFound`](crate::error::AccessPointNotFound)
    pub fn builder() -> crate::error::access_point_not_found::Builder {
        crate::error::access_point_not_found::Builder::default()
    }
}

/// <p>Returned if the <code>FileSystemPolicy</code> is malformed or contains an error such as a parameter value that is not valid or a missing required parameter. Returned in the case of a policy lockout safety check error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidPolicyException {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl InvalidPolicyException {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for InvalidPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidPolicyException");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidPolicyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidPolicyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidPolicyException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidPolicyException {}
/// See [`InvalidPolicyException`](crate::error::InvalidPolicyException)
pub mod invalid_policy_exception {
    /// A builder for [`InvalidPolicyException`](crate::error::InvalidPolicyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidPolicyException`](crate::error::InvalidPolicyException)
        pub fn build(self) -> crate::error::InvalidPolicyException {
            crate::error::InvalidPolicyException {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl InvalidPolicyException {
    /// Creates a new builder-style object to manufacture [`InvalidPolicyException`](crate::error::InvalidPolicyException)
    pub fn builder() -> crate::error::invalid_policy_exception::Builder {
        crate::error::invalid_policy_exception::Builder::default()
    }
}

/// <p>Returned if the Backup service is not available in the Amazon Web Services Region in which the request was made.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ValidationException {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>Returned if one of the specified security groups doesn't exist in the subnet's virtual private cloud (VPC).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityGroupNotFound {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl SecurityGroupNotFound {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for SecurityGroupNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityGroupNotFound");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SecurityGroupNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SecurityGroupNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SecurityGroupNotFound")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for SecurityGroupNotFound {}
/// See [`SecurityGroupNotFound`](crate::error::SecurityGroupNotFound)
pub mod security_group_not_found {
    /// A builder for [`SecurityGroupNotFound`](crate::error::SecurityGroupNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityGroupNotFound`](crate::error::SecurityGroupNotFound)
        pub fn build(self) -> crate::error::SecurityGroupNotFound {
            crate::error::SecurityGroupNotFound {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl SecurityGroupNotFound {
    /// Creates a new builder-style object to manufacture [`SecurityGroupNotFound`](crate::error::SecurityGroupNotFound)
    pub fn builder() -> crate::error::security_group_not_found::Builder {
        crate::error::security_group_not_found::Builder::default()
    }
}

/// <p>Returned if the size of <code>SecurityGroups</code> specified in the request is greater than five.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityGroupLimitExceeded {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl SecurityGroupLimitExceeded {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for SecurityGroupLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityGroupLimitExceeded");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SecurityGroupLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SecurityGroupLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SecurityGroupLimitExceeded")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for SecurityGroupLimitExceeded {}
/// See [`SecurityGroupLimitExceeded`](crate::error::SecurityGroupLimitExceeded)
pub mod security_group_limit_exceeded {
    /// A builder for [`SecurityGroupLimitExceeded`](crate::error::SecurityGroupLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityGroupLimitExceeded`](crate::error::SecurityGroupLimitExceeded)
        pub fn build(self) -> crate::error::SecurityGroupLimitExceeded {
            crate::error::SecurityGroupLimitExceeded {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl SecurityGroupLimitExceeded {
    /// Creates a new builder-style object to manufacture [`SecurityGroupLimitExceeded`](crate::error::SecurityGroupLimitExceeded)
    pub fn builder() -> crate::error::security_group_limit_exceeded::Builder {
        crate::error::security_group_limit_exceeded::Builder::default()
    }
}

/// <p>Returned if there is no mount target with the specified ID found in the caller's Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MountTargetNotFound {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl MountTargetNotFound {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for MountTargetNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MountTargetNotFound");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MountTargetNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MountTargetNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MountTargetNotFound")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for MountTargetNotFound {}
/// See [`MountTargetNotFound`](crate::error::MountTargetNotFound)
pub mod mount_target_not_found {
    /// A builder for [`MountTargetNotFound`](crate::error::MountTargetNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MountTargetNotFound`](crate::error::MountTargetNotFound)
        pub fn build(self) -> crate::error::MountTargetNotFound {
            crate::error::MountTargetNotFound {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl MountTargetNotFound {
    /// Creates a new builder-style object to manufacture [`MountTargetNotFound`](crate::error::MountTargetNotFound)
    pub fn builder() -> crate::error::mount_target_not_found::Builder {
        crate::error::mount_target_not_found::Builder::default()
    }
}

/// <p>Returned if the mount target is not in the correct state for the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncorrectMountTargetState {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl IncorrectMountTargetState {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for IncorrectMountTargetState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncorrectMountTargetState");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IncorrectMountTargetState {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IncorrectMountTargetState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IncorrectMountTargetState")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for IncorrectMountTargetState {}
/// See [`IncorrectMountTargetState`](crate::error::IncorrectMountTargetState)
pub mod incorrect_mount_target_state {
    /// A builder for [`IncorrectMountTargetState`](crate::error::IncorrectMountTargetState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IncorrectMountTargetState`](crate::error::IncorrectMountTargetState)
        pub fn build(self) -> crate::error::IncorrectMountTargetState {
            crate::error::IncorrectMountTargetState {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl IncorrectMountTargetState {
    /// Creates a new builder-style object to manufacture [`IncorrectMountTargetState`](crate::error::IncorrectMountTargetState)
    pub fn builder() -> crate::error::incorrect_mount_target_state::Builder {
        crate::error::incorrect_mount_target_state::Builder::default()
    }
}

/// <p>Returned if the specified file system does not have a replication configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationNotFound {
    /// <p>ReplicationNotFound</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ReplicationNotFound {
    /// <p>ReplicationNotFound</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for ReplicationNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationNotFound");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReplicationNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReplicationNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ReplicationNotFound")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReplicationNotFound {}
/// See [`ReplicationNotFound`](crate::error::ReplicationNotFound)
pub mod replication_not_found {
    /// A builder for [`ReplicationNotFound`](crate::error::ReplicationNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ReplicationNotFound</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>ReplicationNotFound</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationNotFound`](crate::error::ReplicationNotFound)
        pub fn build(self) -> crate::error::ReplicationNotFound {
            crate::error::ReplicationNotFound {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl ReplicationNotFound {
    /// Creates a new builder-style object to manufacture [`ReplicationNotFound`](crate::error::ReplicationNotFound)
    pub fn builder() -> crate::error::replication_not_found::Builder {
        crate::error::replication_not_found::Builder::default()
    }
}

/// <p>Returned if the default file system policy is in effect for the EFS file system specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyNotFound {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl PolicyNotFound {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for PolicyNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyNotFound");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PolicyNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PolicyNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PolicyNotFound")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for PolicyNotFound {}
/// See [`PolicyNotFound`](crate::error::PolicyNotFound)
pub mod policy_not_found {
    /// A builder for [`PolicyNotFound`](crate::error::PolicyNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyNotFound`](crate::error::PolicyNotFound)
        pub fn build(self) -> crate::error::PolicyNotFound {
            crate::error::PolicyNotFound {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl PolicyNotFound {
    /// Creates a new builder-style object to manufacture [`PolicyNotFound`](crate::error::PolicyNotFound)
    pub fn builder() -> crate::error::policy_not_found::Builder {
        crate::error::policy_not_found::Builder::default()
    }
}

/// <p>The service timed out trying to fulfill the request, and the client should try the call again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DependencyTimeout {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl DependencyTimeout {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for DependencyTimeout {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DependencyTimeout");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DependencyTimeout {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DependencyTimeout {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DependencyTimeout")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for DependencyTimeout {}
/// See [`DependencyTimeout`](crate::error::DependencyTimeout)
pub mod dependency_timeout {
    /// A builder for [`DependencyTimeout`](crate::error::DependencyTimeout)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DependencyTimeout`](crate::error::DependencyTimeout)
        pub fn build(self) -> crate::error::DependencyTimeout {
            crate::error::DependencyTimeout {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl DependencyTimeout {
    /// Creates a new builder-style object to manufacture [`DependencyTimeout`](crate::error::DependencyTimeout)
    pub fn builder() -> crate::error::dependency_timeout::Builder {
        crate::error::dependency_timeout::Builder::default()
    }
}

/// <p>Returned if a file system has mount targets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileSystemInUse {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl FileSystemInUse {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for FileSystemInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileSystemInUse");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FileSystemInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FileSystemInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FileSystemInUse")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for FileSystemInUse {}
/// See [`FileSystemInUse`](crate::error::FileSystemInUse)
pub mod file_system_in_use {
    /// A builder for [`FileSystemInUse`](crate::error::FileSystemInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FileSystemInUse`](crate::error::FileSystemInUse)
        pub fn build(self) -> crate::error::FileSystemInUse {
            crate::error::FileSystemInUse {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl FileSystemInUse {
    /// Creates a new builder-style object to manufacture [`FileSystemInUse`](crate::error::FileSystemInUse)
    pub fn builder() -> crate::error::file_system_in_use::Builder {
        crate::error::file_system_in_use::Builder::default()
    }
}

/// <p>Returned if the requested Amazon EFS functionality is not available in the specified Availability Zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedAvailabilityZone {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl UnsupportedAvailabilityZone {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for UnsupportedAvailabilityZone {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedAvailabilityZone");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedAvailabilityZone {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedAvailabilityZone {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedAvailabilityZone")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedAvailabilityZone {}
/// See [`UnsupportedAvailabilityZone`](crate::error::UnsupportedAvailabilityZone)
pub mod unsupported_availability_zone {
    /// A builder for [`UnsupportedAvailabilityZone`](crate::error::UnsupportedAvailabilityZone)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedAvailabilityZone`](crate::error::UnsupportedAvailabilityZone)
        pub fn build(self) -> crate::error::UnsupportedAvailabilityZone {
            crate::error::UnsupportedAvailabilityZone {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl UnsupportedAvailabilityZone {
    /// Creates a new builder-style object to manufacture [`UnsupportedAvailabilityZone`](crate::error::UnsupportedAvailabilityZone)
    pub fn builder() -> crate::error::unsupported_availability_zone::Builder {
        crate::error::unsupported_availability_zone::Builder::default()
    }
}

/// <p>Returned if the Amazon Web Services account has already created the maximum number of file systems allowed per account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileSystemLimitExceeded {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl FileSystemLimitExceeded {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for FileSystemLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileSystemLimitExceeded");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FileSystemLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FileSystemLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FileSystemLimitExceeded")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for FileSystemLimitExceeded {}
/// See [`FileSystemLimitExceeded`](crate::error::FileSystemLimitExceeded)
pub mod file_system_limit_exceeded {
    /// A builder for [`FileSystemLimitExceeded`](crate::error::FileSystemLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FileSystemLimitExceeded`](crate::error::FileSystemLimitExceeded)
        pub fn build(self) -> crate::error::FileSystemLimitExceeded {
            crate::error::FileSystemLimitExceeded {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl FileSystemLimitExceeded {
    /// Creates a new builder-style object to manufacture [`FileSystemLimitExceeded`](crate::error::FileSystemLimitExceeded)
    pub fn builder() -> crate::error::file_system_limit_exceeded::Builder {
        crate::error::file_system_limit_exceeded::Builder::default()
    }
}

/// <p>Returned if there is no subnet with ID <code>SubnetId</code> provided in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetNotFound {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl SubnetNotFound {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for SubnetNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetNotFound");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetNotFound")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetNotFound {}
/// See [`SubnetNotFound`](crate::error::SubnetNotFound)
pub mod subnet_not_found {
    /// A builder for [`SubnetNotFound`](crate::error::SubnetNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetNotFound`](crate::error::SubnetNotFound)
        pub fn build(self) -> crate::error::SubnetNotFound {
            crate::error::SubnetNotFound {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl SubnetNotFound {
    /// Creates a new builder-style object to manufacture [`SubnetNotFound`](crate::error::SubnetNotFound)
    pub fn builder() -> crate::error::subnet_not_found::Builder {
        crate::error::subnet_not_found::Builder::default()
    }
}

/// <p>Returned if <code>IpAddress</code> was not specified in the request and there are no free IP addresses in the subnet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoFreeAddressesInSubnet {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl NoFreeAddressesInSubnet {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for NoFreeAddressesInSubnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoFreeAddressesInSubnet");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoFreeAddressesInSubnet {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoFreeAddressesInSubnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoFreeAddressesInSubnet")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoFreeAddressesInSubnet {}
/// See [`NoFreeAddressesInSubnet`](crate::error::NoFreeAddressesInSubnet)
pub mod no_free_addresses_in_subnet {
    /// A builder for [`NoFreeAddressesInSubnet`](crate::error::NoFreeAddressesInSubnet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoFreeAddressesInSubnet`](crate::error::NoFreeAddressesInSubnet)
        pub fn build(self) -> crate::error::NoFreeAddressesInSubnet {
            crate::error::NoFreeAddressesInSubnet {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl NoFreeAddressesInSubnet {
    /// Creates a new builder-style object to manufacture [`NoFreeAddressesInSubnet`](crate::error::NoFreeAddressesInSubnet)
    pub fn builder() -> crate::error::no_free_addresses_in_subnet::Builder {
        crate::error::no_free_addresses_in_subnet::Builder::default()
    }
}

/// <p>The calling account has reached the limit for elastic network interfaces for the specific Amazon Web Services Region. Either delete some network interfaces or request that the account quota be raised. For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Appendix_Limits.html">Amazon VPC Quotas</a> in the <i>Amazon VPC User Guide</i> (see the <b>Network interfaces per Region</b> entry in the <b>Network interfaces</b> table). </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkInterfaceLimitExceeded {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl NetworkInterfaceLimitExceeded {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for NetworkInterfaceLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkInterfaceLimitExceeded");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NetworkInterfaceLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NetworkInterfaceLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NetworkInterfaceLimitExceeded")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for NetworkInterfaceLimitExceeded {}
/// See [`NetworkInterfaceLimitExceeded`](crate::error::NetworkInterfaceLimitExceeded)
pub mod network_interface_limit_exceeded {
    /// A builder for [`NetworkInterfaceLimitExceeded`](crate::error::NetworkInterfaceLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkInterfaceLimitExceeded`](crate::error::NetworkInterfaceLimitExceeded)
        pub fn build(self) -> crate::error::NetworkInterfaceLimitExceeded {
            crate::error::NetworkInterfaceLimitExceeded {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl NetworkInterfaceLimitExceeded {
    /// Creates a new builder-style object to manufacture [`NetworkInterfaceLimitExceeded`](crate::error::NetworkInterfaceLimitExceeded)
    pub fn builder() -> crate::error::network_interface_limit_exceeded::Builder {
        crate::error::network_interface_limit_exceeded::Builder::default()
    }
}

/// <p>Returned if the mount target would violate one of the specified restrictions based on the file system's existing mount targets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MountTargetConflict {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl MountTargetConflict {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for MountTargetConflict {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MountTargetConflict");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MountTargetConflict {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MountTargetConflict {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MountTargetConflict")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for MountTargetConflict {}
/// See [`MountTargetConflict`](crate::error::MountTargetConflict)
pub mod mount_target_conflict {
    /// A builder for [`MountTargetConflict`](crate::error::MountTargetConflict)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MountTargetConflict`](crate::error::MountTargetConflict)
        pub fn build(self) -> crate::error::MountTargetConflict {
            crate::error::MountTargetConflict {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl MountTargetConflict {
    /// Creates a new builder-style object to manufacture [`MountTargetConflict`](crate::error::MountTargetConflict)
    pub fn builder() -> crate::error::mount_target_conflict::Builder {
        crate::error::mount_target_conflict::Builder::default()
    }
}

/// <p>Returned if the request specified an <code>IpAddress</code> that is already in use in the subnet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpAddressInUse {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl IpAddressInUse {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for IpAddressInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpAddressInUse");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IpAddressInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IpAddressInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IpAddressInUse")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for IpAddressInUse {}
/// See [`IpAddressInUse`](crate::error::IpAddressInUse)
pub mod ip_address_in_use {
    /// A builder for [`IpAddressInUse`](crate::error::IpAddressInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IpAddressInUse`](crate::error::IpAddressInUse)
        pub fn build(self) -> crate::error::IpAddressInUse {
            crate::error::IpAddressInUse {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl IpAddressInUse {
    /// Creates a new builder-style object to manufacture [`IpAddressInUse`](crate::error::IpAddressInUse)
    pub fn builder() -> crate::error::ip_address_in_use::Builder {
        crate::error::ip_address_in_use::Builder::default()
    }
}

/// <p>Returned if the Availability Zone that was specified for a mount target is different from the Availability Zone that was specified for One Zone storage. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/availability-durability.html">Regional and One Zone storage redundancy</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AvailabilityZonesMismatch {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl AvailabilityZonesMismatch {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for AvailabilityZonesMismatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AvailabilityZonesMismatch");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AvailabilityZonesMismatch {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AvailabilityZonesMismatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AvailabilityZonesMismatch")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for AvailabilityZonesMismatch {}
/// See [`AvailabilityZonesMismatch`](crate::error::AvailabilityZonesMismatch)
pub mod availability_zones_mismatch {
    /// A builder for [`AvailabilityZonesMismatch`](crate::error::AvailabilityZonesMismatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AvailabilityZonesMismatch`](crate::error::AvailabilityZonesMismatch)
        pub fn build(self) -> crate::error::AvailabilityZonesMismatch {
            crate::error::AvailabilityZonesMismatch {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl AvailabilityZonesMismatch {
    /// Creates a new builder-style object to manufacture [`AvailabilityZonesMismatch`](crate::error::AvailabilityZonesMismatch)
    pub fn builder() -> crate::error::availability_zones_mismatch::Builder {
        crate::error::availability_zones_mismatch::Builder::default()
    }
}

/// <p>Returned if the file system you are trying to create already exists, with the creation token you provided.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileSystemAlreadyExists {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub file_system_id: std::option::Option<std::string::String>,
}
impl FileSystemAlreadyExists {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
}
impl std::fmt::Debug for FileSystemAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileSystemAlreadyExists");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.finish()
    }
}
impl FileSystemAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FileSystemAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FileSystemAlreadyExists")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for FileSystemAlreadyExists {}
/// See [`FileSystemAlreadyExists`](crate::error::FileSystemAlreadyExists)
pub mod file_system_already_exists {
    /// A builder for [`FileSystemAlreadyExists`](crate::error::FileSystemAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// Consumes the builder and constructs a [`FileSystemAlreadyExists`](crate::error::FileSystemAlreadyExists)
        pub fn build(self) -> crate::error::FileSystemAlreadyExists {
            crate::error::FileSystemAlreadyExists {
                error_code: self.error_code,
                message: self.message,
                file_system_id: self.file_system_id,
            }
        }
    }
}
impl FileSystemAlreadyExists {
    /// Creates a new builder-style object to manufacture [`FileSystemAlreadyExists`](crate::error::FileSystemAlreadyExists)
    pub fn builder() -> crate::error::file_system_already_exists::Builder {
        crate::error::file_system_already_exists::Builder::default()
    }
}

/// <p>Returned when the <code>CreateAccessPoint</code> API action is called too quickly and the number of Access Points in the account is nearing the limit of 120.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ThrottlingException {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>Returned if the Amazon Web Services account has already created the maximum number of access points allowed per file system. For more informaton, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#limits-efs-resources-per-account-per-region">https://docs.aws.amazon.com/efs/latest/ug/limits.html#limits-efs-resources-per-account-per-region</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessPointLimitExceeded {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl AccessPointLimitExceeded {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for AccessPointLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessPointLimitExceeded");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessPointLimitExceeded {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessPointLimitExceeded {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessPointLimitExceeded")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessPointLimitExceeded {}
/// See [`AccessPointLimitExceeded`](crate::error::AccessPointLimitExceeded)
pub mod access_point_limit_exceeded {
    /// A builder for [`AccessPointLimitExceeded`](crate::error::AccessPointLimitExceeded)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessPointLimitExceeded`](crate::error::AccessPointLimitExceeded)
        pub fn build(self) -> crate::error::AccessPointLimitExceeded {
            crate::error::AccessPointLimitExceeded {
                error_code: self.error_code,
                message: self.message,
            }
        }
    }
}
impl AccessPointLimitExceeded {
    /// Creates a new builder-style object to manufacture [`AccessPointLimitExceeded`](crate::error::AccessPointLimitExceeded)
    pub fn builder() -> crate::error::access_point_limit_exceeded::Builder {
        crate::error::access_point_limit_exceeded::Builder::default()
    }
}

/// <p>Returned if the access point that you are trying to create already exists, with the creation token you provided in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessPointAlreadyExists {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub access_point_id: std::option::Option<std::string::String>,
}
impl AccessPointAlreadyExists {
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn access_point_id(&self) -> std::option::Option<&str> {
        self.access_point_id.as_deref()
    }
}
impl std::fmt::Debug for AccessPointAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessPointAlreadyExists");
        formatter.field("error_code", &self.error_code);
        formatter.field("message", &self.message);
        formatter.field("access_point_id", &self.access_point_id);
        formatter.finish()
    }
}
impl AccessPointAlreadyExists {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessPointAlreadyExists {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessPointAlreadyExists")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessPointAlreadyExists {}
/// See [`AccessPointAlreadyExists`](crate::error::AccessPointAlreadyExists)
pub mod access_point_already_exists {
    /// A builder for [`AccessPointAlreadyExists`](crate::error::AccessPointAlreadyExists)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) access_point_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn access_point_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_point_id = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_access_point_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_point_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessPointAlreadyExists`](crate::error::AccessPointAlreadyExists)
        pub fn build(self) -> crate::error::AccessPointAlreadyExists {
            crate::error::AccessPointAlreadyExists {
                error_code: self.error_code,
                message: self.message,
                access_point_id: self.access_point_id,
            }
        }
    }
}
impl AccessPointAlreadyExists {
    /// Creates a new builder-style object to manufacture [`AccessPointAlreadyExists`](crate::error::AccessPointAlreadyExists)
    pub fn builder() -> crate::error::access_point_already_exists::Builder {
        crate::error::access_point_already_exists::Builder::default()
    }
}
