// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateAccessPointInput`](crate::input::CreateAccessPointInput)
pub mod create_access_point_input {
    /// A builder for [`CreateAccessPointInput`](crate::input::CreateAccessPointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) posix_user: std::option::Option<crate::model::PosixUser>,
        pub(crate) root_directory: std::option::Option<crate::model::RootDirectory>,
    }
    impl Builder {
        /// <p>A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent
        /// creation.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent
        /// creation.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Creates tags associated with the access point. Each tag is a key-value pair, each key must be unique. For more
        /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
        /// in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Creates tags associated with the access point. Each tag is a key-value pair, each key must be unique. For more
        /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
        /// in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The ID of the EFS file system that the access point provides access to.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the EFS file system that the access point provides access to.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The operating system user and
        /// group applied to all file system requests made using the access point.</p>
        pub fn posix_user(mut self, input: crate::model::PosixUser) -> Self {
            self.posix_user = Some(input);
            self
        }
        /// <p>The operating system user and
        /// group applied to all file system requests made using the access point.</p>
        pub fn set_posix_user(
            mut self,
            input: std::option::Option<crate::model::PosixUser>,
        ) -> Self {
            self.posix_user = input;
            self
        }
        /// <p>Specifies the directory on the Amazon EFS file system that the access point exposes as
        /// the root directory of your file system to NFS clients using the access point.
        /// The clients using the access point can only access the root directory and below.
        /// If the <code>RootDirectory</code> > <code>Path</code> specified does not exist,
        /// EFS creates it and applies the <code>CreationInfo</code> settings when a client connects to an access point.
        /// When specifying a <code>RootDirectory</code>, you need to provide the <code>Path</code>, and the <code>CreationInfo</code>.</p>
        /// <p>Amazon EFS creates a root directory only if you have provided the  CreationInfo: OwnUid, OwnGID, and permissions for the directory.
        /// If  you do not provide this information, Amazon EFS does not create the root directory. If the root directory does not exist, attempts to mount
        /// using the access point will fail.</p>
        pub fn root_directory(mut self, input: crate::model::RootDirectory) -> Self {
            self.root_directory = Some(input);
            self
        }
        /// <p>Specifies the directory on the Amazon EFS file system that the access point exposes as
        /// the root directory of your file system to NFS clients using the access point.
        /// The clients using the access point can only access the root directory and below.
        /// If the <code>RootDirectory</code> > <code>Path</code> specified does not exist,
        /// EFS creates it and applies the <code>CreationInfo</code> settings when a client connects to an access point.
        /// When specifying a <code>RootDirectory</code>, you need to provide the <code>Path</code>, and the <code>CreationInfo</code>.</p>
        /// <p>Amazon EFS creates a root directory only if you have provided the  CreationInfo: OwnUid, OwnGID, and permissions for the directory.
        /// If  you do not provide this information, Amazon EFS does not create the root directory. If the root directory does not exist, attempts to mount
        /// using the access point will fail.</p>
        pub fn set_root_directory(
            mut self,
            input: std::option::Option<crate::model::RootDirectory>,
        ) -> Self {
            self.root_directory = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccessPointInput`](crate::input::CreateAccessPointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAccessPointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAccessPointInput {
                client_token: self.client_token,
                tags: self.tags,
                file_system_id: self.file_system_id,
                posix_user: self.posix_user,
                root_directory: self.root_directory,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAccessPointInputOperationOutputAlias = crate::operation::CreateAccessPoint;
#[doc(hidden)]
pub type CreateAccessPointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAccessPointInput {
    /// Consumes the builder and constructs an Operation<[`CreateAccessPoint`](crate::operation::CreateAccessPoint)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAccessPoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAccessPointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2015-02-01/access-points").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAccessPointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAccessPointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_access_point(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAccessPoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAccessPoint",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAccessPointInput`](crate::input::CreateAccessPointInput)
    pub fn builder() -> crate::input::create_access_point_input::Builder {
        crate::input::create_access_point_input::Builder::default()
    }
}

/// See [`CreateFileSystemInput`](crate::input::CreateFileSystemInput)
pub mod create_file_system_input {
    /// A builder for [`CreateFileSystemInput`](crate::input::CreateFileSystemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_token: std::option::Option<std::string::String>,
        pub(crate) performance_mode: std::option::Option<crate::model::PerformanceMode>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) throughput_mode: std::option::Option<crate::model::ThroughputMode>,
        pub(crate) provisioned_throughput_in_mibps: std::option::Option<f64>,
        pub(crate) availability_zone_name: std::option::Option<std::string::String>,
        pub(crate) backup: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent
        /// creation.</p>
        pub fn creation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_token = Some(input.into());
            self
        }
        /// <p>A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent
        /// creation.</p>
        pub fn set_creation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_token = input;
            self
        }
        /// <p>The performance mode of the file system. We recommend <code>generalPurpose</code>
        /// performance mode for most file systems. File systems using the <code>maxIO</code> performance
        /// mode can scale to higher levels of aggregate throughput and operations per second with a
        /// tradeoff of slightly higher latencies for most file operations. The performance mode
        /// can't be changed after the file system has been created.</p>
        /// <note>
        /// <p>The <code>maxIO</code> mode is not supported on file systems using One Zone storage classes.</p>
        /// </note>
        pub fn performance_mode(mut self, input: crate::model::PerformanceMode) -> Self {
            self.performance_mode = Some(input);
            self
        }
        /// <p>The performance mode of the file system. We recommend <code>generalPurpose</code>
        /// performance mode for most file systems. File systems using the <code>maxIO</code> performance
        /// mode can scale to higher levels of aggregate throughput and operations per second with a
        /// tradeoff of slightly higher latencies for most file operations. The performance mode
        /// can't be changed after the file system has been created.</p>
        /// <note>
        /// <p>The <code>maxIO</code> mode is not supported on file systems using One Zone storage classes.</p>
        /// </note>
        pub fn set_performance_mode(
            mut self,
            input: std::option::Option<crate::model::PerformanceMode>,
        ) -> Self {
            self.performance_mode = input;
            self
        }
        /// <p>A Boolean value that, if true, creates an encrypted file system. When creating an
        /// encrypted file system, you have the option of specifying <a>CreateFileSystemRequest$KmsKeyId</a> for an existing Key Management Service (KMS
        /// customer master key (CMK). If you don't specify a CMK, then the default CMK for
        /// Amazon EFS, <code>/aws/elasticfilesystem</code>, is used to protect the encrypted file system.
        /// </p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>A Boolean value that, if true, creates an encrypted file system. When creating an
        /// encrypted file system, you have the option of specifying <a>CreateFileSystemRequest$KmsKeyId</a> for an existing Key Management Service (KMS
        /// customer master key (CMK). If you don't specify a CMK, then the default CMK for
        /// Amazon EFS, <code>/aws/elasticfilesystem</code>, is used to protect the encrypted file system.
        /// </p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The ID of the KMS CMK that you want to use to protect the encrypted file system. This
        /// parameter is only required if you want to use a non-default KMS key. If this parameter is not
        /// specified, the default CMK for Amazon EFS is used. This ID can be in one of the following
        /// formats:</p>
        /// <ul>
        /// <li>
        /// <p>Key ID - A unique identifier of the key, for example
        /// <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        /// </li>
        /// <li>
        /// <p>ARN - An Amazon Resource Name (ARN) for the key, for example
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        /// </li>
        /// <li>
        /// <p>Key alias - A previously created display name for a key, for example
        /// <code>alias/projectKey1</code>.</p>
        /// </li>
        /// <li>
        /// <p>Key alias ARN - An ARN for a key alias, for example
        /// <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>KmsKeyId</code> is specified, the <a>CreateFileSystemRequest$Encrypted</a> parameter must be set to true.</p>
        /// <important>
        /// <p>EFS accepts only symmetric KMS keys. You cannot use asymmetric KMS keys with EFS file systems.</p>
        /// </important>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS CMK that you want to use to protect the encrypted file system. This
        /// parameter is only required if you want to use a non-default KMS key. If this parameter is not
        /// specified, the default CMK for Amazon EFS is used. This ID can be in one of the following
        /// formats:</p>
        /// <ul>
        /// <li>
        /// <p>Key ID - A unique identifier of the key, for example
        /// <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        /// </li>
        /// <li>
        /// <p>ARN - An Amazon Resource Name (ARN) for the key, for example
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        /// </li>
        /// <li>
        /// <p>Key alias - A previously created display name for a key, for example
        /// <code>alias/projectKey1</code>.</p>
        /// </li>
        /// <li>
        /// <p>Key alias ARN - An ARN for a key alias, for example
        /// <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>KmsKeyId</code> is specified, the <a>CreateFileSystemRequest$Encrypted</a> parameter must be set to true.</p>
        /// <important>
        /// <p>EFS accepts only symmetric KMS keys. You cannot use asymmetric KMS keys with EFS file systems.</p>
        /// </important>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Specifies the throughput mode for the file system, either <code>bursting</code> or
        /// <code>provisioned</code>. If you set <code>ThroughputMode</code> to
        /// <code>provisioned</code>, you must also set a value for
        /// <code>ProvisionedThroughputInMibps</code>. After you create the file system, you can
        /// decrease your file system's throughput in Provisioned Throughput mode or change between
        /// the throughput modes, as long as it’s been more than 24 hours since the last decrease or
        /// throughput mode change. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying throughput with
        /// provisioned mode</a> in the <i>Amazon EFS User Guide</i>. </p>
        /// <p>Default is <code>bursting</code>.</p>
        pub fn throughput_mode(mut self, input: crate::model::ThroughputMode) -> Self {
            self.throughput_mode = Some(input);
            self
        }
        /// <p>Specifies the throughput mode for the file system, either <code>bursting</code> or
        /// <code>provisioned</code>. If you set <code>ThroughputMode</code> to
        /// <code>provisioned</code>, you must also set a value for
        /// <code>ProvisionedThroughputInMibps</code>. After you create the file system, you can
        /// decrease your file system's throughput in Provisioned Throughput mode or change between
        /// the throughput modes, as long as it’s been more than 24 hours since the last decrease or
        /// throughput mode change. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying throughput with
        /// provisioned mode</a> in the <i>Amazon EFS User Guide</i>. </p>
        /// <p>Default is <code>bursting</code>.</p>
        pub fn set_throughput_mode(
            mut self,
            input: std::option::Option<crate::model::ThroughputMode>,
        ) -> Self {
            self.throughput_mode = input;
            self
        }
        /// <p>The throughput, measured in MiB/s, that you want to provision for a file system that
        /// you're creating. Valid values are 1-1024. Required if <code>ThroughputMode</code> is set
        /// to <code>provisioned</code>. The upper limit for throughput is 1024 MiB/s. To increase this
        /// limit, contact Amazon Web Services Support. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS quotas that you can increase</a>
        /// in the <i>Amazon EFS User Guide</i>.</p>
        pub fn provisioned_throughput_in_mibps(mut self, input: f64) -> Self {
            self.provisioned_throughput_in_mibps = Some(input);
            self
        }
        /// <p>The throughput, measured in MiB/s, that you want to provision for a file system that
        /// you're creating. Valid values are 1-1024. Required if <code>ThroughputMode</code> is set
        /// to <code>provisioned</code>. The upper limit for throughput is 1024 MiB/s. To increase this
        /// limit, contact Amazon Web Services Support. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS quotas that you can increase</a>
        /// in the <i>Amazon EFS User Guide</i>.</p>
        pub fn set_provisioned_throughput_in_mibps(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.provisioned_throughput_in_mibps = input;
            self
        }
        /// <p>Used to create a file system that uses One Zone storage classes. It specifies the Amazon Web Services
        /// Availability Zone in which to create the file system. Use the format <code>us-east-1a</code>
        /// to specify the Availability Zone. For
        /// more information about One Zone storage classes, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p>
        /// <note>
        /// <p>One Zone storage classes are not available in all Availability Zones in Amazon Web Services Regions where
        /// Amazon EFS is available.</p>
        /// </note>
        pub fn availability_zone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_name = Some(input.into());
            self
        }
        /// <p>Used to create a file system that uses One Zone storage classes. It specifies the Amazon Web Services
        /// Availability Zone in which to create the file system. Use the format <code>us-east-1a</code>
        /// to specify the Availability Zone. For
        /// more information about One Zone storage classes, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p>
        /// <note>
        /// <p>One Zone storage classes are not available in all Availability Zones in Amazon Web Services Regions where
        /// Amazon EFS is available.</p>
        /// </note>
        pub fn set_availability_zone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_name = input;
            self
        }
        /// <p>Specifies whether automatic backups are enabled on the file system that you are creating.
        /// Set the value to <code>true</code> to enable automatic backups. If you are creating a file
        /// system that uses One Zone storage classes, automatic backups are enabled by default. For more
        /// information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups">Automatic backups</a> in the
        /// <i>Amazon EFS User Guide</i>.</p>
        /// <p>Default is <code>false</code>. However, if you specify an <code>AvailabilityZoneName</code>,
        /// the default is <code>true</code>.</p>
        /// <note>
        /// <p>Backup is not available in all Amazon Web Services Regionswhere Amazon EFS is available.</p>
        /// </note>
        pub fn backup(mut self, input: bool) -> Self {
            self.backup = Some(input);
            self
        }
        /// <p>Specifies whether automatic backups are enabled on the file system that you are creating.
        /// Set the value to <code>true</code> to enable automatic backups. If you are creating a file
        /// system that uses One Zone storage classes, automatic backups are enabled by default. For more
        /// information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups">Automatic backups</a> in the
        /// <i>Amazon EFS User Guide</i>.</p>
        /// <p>Default is <code>false</code>. However, if you specify an <code>AvailabilityZoneName</code>,
        /// the default is <code>true</code>.</p>
        /// <note>
        /// <p>Backup is not available in all Amazon Web Services Regionswhere Amazon EFS is available.</p>
        /// </note>
        pub fn set_backup(mut self, input: std::option::Option<bool>) -> Self {
            self.backup = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Use to create one or more tags associated with the file system. Each
        /// tag is a user-defined key-value pair. Name your file system on creation by including a
        /// <code>"Key":"Name","Value":"{value}"</code> key-value pair. Each key must be unique. For more
        /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
        /// in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Use to create one or more tags associated with the file system. Each
        /// tag is a user-defined key-value pair. Name your file system on creation by including a
        /// <code>"Key":"Name","Value":"{value}"</code> key-value pair. Each key must be unique. For more
        /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
        /// in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFileSystemInput`](crate::input::CreateFileSystemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFileSystemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFileSystemInput {
                creation_token: self.creation_token,
                performance_mode: self.performance_mode,
                encrypted: self.encrypted,
                kms_key_id: self.kms_key_id,
                throughput_mode: self.throughput_mode,
                provisioned_throughput_in_mibps: self.provisioned_throughput_in_mibps,
                availability_zone_name: self.availability_zone_name,
                backup: self.backup,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFileSystemInputOperationOutputAlias = crate::operation::CreateFileSystem;
#[doc(hidden)]
pub type CreateFileSystemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateFileSystemInput {
    /// Consumes the builder and constructs an Operation<[`CreateFileSystem`](crate::operation::CreateFileSystem)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFileSystem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFileSystemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2015-02-01/file-systems").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFileSystemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFileSystemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.creation_token.is_none() {
            self.creation_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_file_system(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFileSystem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFileSystem",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFileSystemInput`](crate::input::CreateFileSystemInput)
    pub fn builder() -> crate::input::create_file_system_input::Builder {
        crate::input::create_file_system_input::Builder::default()
    }
}

/// See [`CreateMountTargetInput`](crate::input::CreateMountTargetInput)
pub mod create_mount_target_input {
    /// A builder for [`CreateMountTargetInput`](crate::input::CreateMountTargetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the file system for which to create the mount target.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system for which to create the mount target.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The ID of the subnet to add the mount target in. For file systems that use One Zone storage classes, use the subnet
        /// that is associated with the file system's Availability Zone.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the subnet to add the mount target in. For file systems that use One Zone storage classes, use the subnet
        /// that is associated with the file system's Availability Zone.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>Valid IPv4 address within the address range of the specified subnet.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>Valid IPv4 address within the address range of the specified subnet.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>Up to five VPC security group IDs, of the form <code>sg-xxxxxxxx</code>. These must be
        /// for the same VPC as subnet specified.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>Up to five VPC security group IDs, of the form <code>sg-xxxxxxxx</code>. These must be
        /// for the same VPC as subnet specified.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMountTargetInput`](crate::input::CreateMountTargetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMountTargetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMountTargetInput {
                file_system_id: self.file_system_id,
                subnet_id: self.subnet_id,
                ip_address: self.ip_address,
                security_groups: self.security_groups,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMountTargetInputOperationOutputAlias = crate::operation::CreateMountTarget;
#[doc(hidden)]
pub type CreateMountTargetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateMountTargetInput {
    /// Consumes the builder and constructs an Operation<[`CreateMountTarget`](crate::operation::CreateMountTarget)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMountTarget,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMountTargetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2015-02-01/mount-targets").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMountTargetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMountTargetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_mount_target(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMountTarget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMountTarget",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMountTargetInput`](crate::input::CreateMountTargetInput)
    pub fn builder() -> crate::input::create_mount_target_input::Builder {
        crate::input::create_mount_target_input::Builder::default()
    }
}

/// See [`CreateTagsInput`](crate::input::CreateTagsInput)
pub mod create_tags_input {
    /// A builder for [`CreateTagsInput`](crate::input::CreateTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the file system whose tags you want to modify (String). This operation modifies
        /// the tags only, not the file system.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system whose tags you want to modify (String). This operation modifies
        /// the tags only, not the file system.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value
        /// pair. </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value
        /// pair. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTagsInput`](crate::input::CreateTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTagsInput {
                file_system_id: self.file_system_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTagsInputOperationOutputAlias = crate::operation::CreateTags;
#[doc(hidden)]
pub type CreateTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTagsInput {
    /// Consumes the builder and constructs an Operation<[`CreateTags`](crate::operation::CreateTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.file_system_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "file_system_id",
                        details: "cannot be empty or unset",
                    })?;
            let file_system_id = aws_smithy_http::label::fmt_string(input_1, false);
            if file_system_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "file_system_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/create-tags/{FileSystemId}",
                FileSystemId = file_system_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTags",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTagsInput`](crate::input::CreateTagsInput)
    pub fn builder() -> crate::input::create_tags_input::Builder {
        crate::input::create_tags_input::Builder::default()
    }
}

/// See [`DeleteAccessPointInput`](crate::input::DeleteAccessPointInput)
pub mod delete_access_point_input {
    /// A builder for [`DeleteAccessPointInput`](crate::input::DeleteAccessPointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_point_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the access point that you want to delete.</p>
        pub fn access_point_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_point_id = Some(input.into());
            self
        }
        /// <p>The ID of the access point that you want to delete.</p>
        pub fn set_access_point_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_point_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAccessPointInput`](crate::input::DeleteAccessPointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAccessPointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAccessPointInput {
                access_point_id: self.access_point_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAccessPointInputOperationOutputAlias = crate::operation::DeleteAccessPoint;
#[doc(hidden)]
pub type DeleteAccessPointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAccessPointInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAccessPoint`](crate::operation::DeleteAccessPoint)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAccessPoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAccessPointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.access_point_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "access_point_id",
                        details: "cannot be empty or unset",
                    })?;
            let access_point_id = aws_smithy_http::label::fmt_string(input_2, false);
            if access_point_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "access_point_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/access-points/{AccessPointId}",
                AccessPointId = access_point_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAccessPointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAccessPointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAccessPoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAccessPoint",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAccessPointInput`](crate::input::DeleteAccessPointInput)
    pub fn builder() -> crate::input::delete_access_point_input::Builder {
        crate::input::delete_access_point_input::Builder::default()
    }
}

/// See [`DeleteFileSystemInput`](crate::input::DeleteFileSystemInput)
pub mod delete_file_system_input {
    /// A builder for [`DeleteFileSystemInput`](crate::input::DeleteFileSystemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the file system you want to delete.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system you want to delete.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFileSystemInput`](crate::input::DeleteFileSystemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFileSystemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFileSystemInput {
                file_system_id: self.file_system_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFileSystemInputOperationOutputAlias = crate::operation::DeleteFileSystem;
#[doc(hidden)]
pub type DeleteFileSystemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteFileSystemInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFileSystem`](crate::operation::DeleteFileSystem)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFileSystem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFileSystemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.file_system_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "file_system_id",
                        details: "cannot be empty or unset",
                    })?;
            let file_system_id = aws_smithy_http::label::fmt_string(input_3, false);
            if file_system_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "file_system_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/file-systems/{FileSystemId}",
                FileSystemId = file_system_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFileSystemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFileSystemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFileSystem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFileSystem",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFileSystemInput`](crate::input::DeleteFileSystemInput)
    pub fn builder() -> crate::input::delete_file_system_input::Builder {
        crate::input::delete_file_system_input::Builder::default()
    }
}

/// See [`DeleteFileSystemPolicyInput`](crate::input::DeleteFileSystemPolicyInput)
pub mod delete_file_system_policy_input {
    /// A builder for [`DeleteFileSystemPolicyInput`](crate::input::DeleteFileSystemPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the EFS file system for which to delete the <code>FileSystemPolicy</code>.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>Specifies the EFS file system for which to delete the <code>FileSystemPolicy</code>.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFileSystemPolicyInput`](crate::input::DeleteFileSystemPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFileSystemPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFileSystemPolicyInput {
                file_system_id: self.file_system_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFileSystemPolicyInputOperationOutputAlias = crate::operation::DeleteFileSystemPolicy;
#[doc(hidden)]
pub type DeleteFileSystemPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteFileSystemPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFileSystemPolicy`](crate::operation::DeleteFileSystemPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFileSystemPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFileSystemPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.file_system_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "file_system_id",
                        details: "cannot be empty or unset",
                    })?;
            let file_system_id = aws_smithy_http::label::fmt_string(input_4, false);
            if file_system_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "file_system_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/file-systems/{FileSystemId}/policy",
                FileSystemId = file_system_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFileSystemPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFileSystemPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFileSystemPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFileSystemPolicy",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFileSystemPolicyInput`](crate::input::DeleteFileSystemPolicyInput)
    pub fn builder() -> crate::input::delete_file_system_policy_input::Builder {
        crate::input::delete_file_system_policy_input::Builder::default()
    }
}

/// See [`DeleteMountTargetInput`](crate::input::DeleteMountTargetInput)
pub mod delete_mount_target_input {
    /// A builder for [`DeleteMountTargetInput`](crate::input::DeleteMountTargetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mount_target_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the mount target to delete (String).</p>
        pub fn mount_target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.mount_target_id = Some(input.into());
            self
        }
        /// <p>The ID of the mount target to delete (String).</p>
        pub fn set_mount_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mount_target_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMountTargetInput`](crate::input::DeleteMountTargetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMountTargetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMountTargetInput {
                mount_target_id: self.mount_target_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMountTargetInputOperationOutputAlias = crate::operation::DeleteMountTarget;
#[doc(hidden)]
pub type DeleteMountTargetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteMountTargetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMountTarget`](crate::operation::DeleteMountTarget)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMountTarget,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteMountTargetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.mount_target_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mount_target_id",
                        details: "cannot be empty or unset",
                    })?;
            let mount_target_id = aws_smithy_http::label::fmt_string(input_5, false);
            if mount_target_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "mount_target_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/mount-targets/{MountTargetId}",
                MountTargetId = mount_target_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteMountTargetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteMountTargetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMountTarget::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMountTarget",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteMountTargetInput`](crate::input::DeleteMountTargetInput)
    pub fn builder() -> crate::input::delete_mount_target_input::Builder {
        crate::input::delete_mount_target_input::Builder::default()
    }
}

/// See [`DeleteTagsInput`](crate::input::DeleteTagsInput)
pub mod delete_tags_input {
    /// A builder for [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the file system whose tags you want to delete (String).</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system whose tags you want to delete (String).</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to delete.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of tag keys to delete.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTagsInput`](crate::input::DeleteTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTagsInput {
                file_system_id: self.file_system_id,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTagsInputOperationOutputAlias = crate::operation::DeleteTags;
#[doc(hidden)]
pub type DeleteTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTagsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTags`](crate::operation::DeleteTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.file_system_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "file_system_id",
                        details: "cannot be empty or unset",
                    })?;
            let file_system_id = aws_smithy_http::label::fmt_string(input_6, false);
            if file_system_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "file_system_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/delete-tags/{FileSystemId}",
                FileSystemId = file_system_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTags",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    pub fn builder() -> crate::input::delete_tags_input::Builder {
        crate::input::delete_tags_input::Builder::default()
    }
}

/// See [`DescribeAccessPointsInput`](crate::input::DescribeAccessPointsInput)
pub mod describe_access_points_input {
    /// A builder for [`DescribeAccessPointsInput`](crate::input::DescribeAccessPointsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) access_point_id: std::option::Option<std::string::String>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>(Optional) When retrieving all access points for a file system,
        /// you can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response.  
        /// The default value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>(Optional) When retrieving all access points for a file system,
        /// you can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response.  
        /// The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>
        /// <code>NextToken</code> is present if the response is paginated. You can use <code>NextMarker</code> in the subsequent request to fetch the next page of access point descriptions.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// <code>NextToken</code> is present if the response is paginated. You can use <code>NextMarker</code> in the subsequent request to fetch the next page of access point descriptions.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>(Optional) Specifies an EFS access point to describe in the response; mutually exclusive with <code>FileSystemId</code>.</p>
        pub fn access_point_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_point_id = Some(input.into());
            self
        }
        /// <p>(Optional) Specifies an EFS access point to describe in the response; mutually exclusive with <code>FileSystemId</code>.</p>
        pub fn set_access_point_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_point_id = input;
            self
        }
        /// <p>(Optional) If you provide a <code>FileSystemId</code>, EFS returns all access points for that file system; mutually exclusive with <code>AccessPointId</code>.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>(Optional) If you provide a <code>FileSystemId</code>, EFS returns all access points for that file system; mutually exclusive with <code>AccessPointId</code>.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccessPointsInput`](crate::input::DescribeAccessPointsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccessPointsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccessPointsInput {
                max_results: self.max_results,
                next_token: self.next_token,
                access_point_id: self.access_point_id,
                file_system_id: self.file_system_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAccessPointsInputOperationOutputAlias = crate::operation::DescribeAccessPoints;
#[doc(hidden)]
pub type DescribeAccessPointsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAccessPointsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccessPoints`](crate::operation::DescribeAccessPoints)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccessPoints,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAccessPointsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2015-02-01/access-points").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribeAccessPointsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_7) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_7).encode(),
                );
            }
            if let Some(inner_8) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_8));
            }
            if let Some(inner_9) = &_input.access_point_id {
                query.push_kv(
                    "AccessPointId",
                    &aws_smithy_http::query::fmt_string(&inner_9),
                );
            }
            if let Some(inner_10) = &_input.file_system_id {
                query.push_kv(
                    "FileSystemId",
                    &aws_smithy_http::query::fmt_string(&inner_10),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAccessPointsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAccessPointsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccessPoints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccessPoints",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccessPointsInput`](crate::input::DescribeAccessPointsInput)
    pub fn builder() -> crate::input::describe_access_points_input::Builder {
        crate::input::describe_access_points_input::Builder::default()
    }
}

/// See [`DescribeAccountPreferencesInput`](crate::input::DescribeAccountPreferencesInput)
pub mod describe_account_preferences_input {
    /// A builder for [`DescribeAccountPreferencesInput`](crate::input::DescribeAccountPreferencesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>(Optional) You can use <code>NextToken</code> in a subsequent request to fetch the next page of
        /// Amazon Web Services account preferences if the response payload was paginated.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>(Optional) You can use <code>NextToken</code> in a subsequent request to fetch the next page of
        /// Amazon Web Services account preferences if the response payload was paginated.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>(Optional) When retrieving account preferences,
        /// you can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response.  
        /// The default value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>(Optional) When retrieving account preferences,
        /// you can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response.  
        /// The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountPreferencesInput`](crate::input::DescribeAccountPreferencesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountPreferencesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountPreferencesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountPreferencesInputOperationOutputAlias =
    crate::operation::DescribeAccountPreferences;
#[doc(hidden)]
pub type DescribeAccountPreferencesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAccountPreferencesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountPreferences`](crate::operation::DescribeAccountPreferences)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountPreferences,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAccountPreferencesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2015-02-01/account-preferences").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAccountPreferencesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAccountPreferencesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_account_preferences(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountPreferences::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountPreferences",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountPreferencesInput`](crate::input::DescribeAccountPreferencesInput)
    pub fn builder() -> crate::input::describe_account_preferences_input::Builder {
        crate::input::describe_account_preferences_input::Builder::default()
    }
}

/// See [`DescribeBackupPolicyInput`](crate::input::DescribeBackupPolicyInput)
pub mod describe_backup_policy_input {
    /// A builder for [`DescribeBackupPolicyInput`](crate::input::DescribeBackupPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies which EFS file system to retrieve the <code>BackupPolicy</code> for.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>Specifies which EFS file system to retrieve the <code>BackupPolicy</code> for.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBackupPolicyInput`](crate::input::DescribeBackupPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBackupPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBackupPolicyInput {
                file_system_id: self.file_system_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBackupPolicyInputOperationOutputAlias = crate::operation::DescribeBackupPolicy;
#[doc(hidden)]
pub type DescribeBackupPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeBackupPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBackupPolicy`](crate::operation::DescribeBackupPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBackupPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBackupPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.file_system_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "file_system_id",
                        details: "cannot be empty or unset",
                    })?;
            let file_system_id = aws_smithy_http::label::fmt_string(input_11, false);
            if file_system_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "file_system_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/file-systems/{FileSystemId}/backup-policy",
                FileSystemId = file_system_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBackupPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBackupPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBackupPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBackupPolicy",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBackupPolicyInput`](crate::input::DescribeBackupPolicyInput)
    pub fn builder() -> crate::input::describe_backup_policy_input::Builder {
        crate::input::describe_backup_policy_input::Builder::default()
    }
}

/// See [`DescribeFileSystemPolicyInput`](crate::input::DescribeFileSystemPolicyInput)
pub mod describe_file_system_policy_input {
    /// A builder for [`DescribeFileSystemPolicyInput`](crate::input::DescribeFileSystemPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies which EFS file system to retrieve the <code>FileSystemPolicy</code> for.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>Specifies which EFS file system to retrieve the <code>FileSystemPolicy</code> for.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFileSystemPolicyInput`](crate::input::DescribeFileSystemPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFileSystemPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFileSystemPolicyInput {
                file_system_id: self.file_system_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFileSystemPolicyInputOperationOutputAlias =
    crate::operation::DescribeFileSystemPolicy;
#[doc(hidden)]
pub type DescribeFileSystemPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeFileSystemPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFileSystemPolicy`](crate::operation::DescribeFileSystemPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFileSystemPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFileSystemPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.file_system_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "file_system_id",
                        details: "cannot be empty or unset",
                    })?;
            let file_system_id = aws_smithy_http::label::fmt_string(input_12, false);
            if file_system_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "file_system_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/file-systems/{FileSystemId}/policy",
                FileSystemId = file_system_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFileSystemPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFileSystemPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFileSystemPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFileSystemPolicy",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFileSystemPolicyInput`](crate::input::DescribeFileSystemPolicyInput)
    pub fn builder() -> crate::input::describe_file_system_policy_input::Builder {
        crate::input::describe_file_system_policy_input::Builder::default()
    }
}

/// See [`DescribeFileSystemsInput`](crate::input::DescribeFileSystemsInput)
pub mod describe_file_systems_input {
    /// A builder for [`DescribeFileSystemsInput`](crate::input::DescribeFileSystemsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) creation_token: std::option::Option<std::string::String>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>(Optional) Specifies the maximum number of file systems to return in the response
        /// (integer). This number is automatically set to 100. The response is paginated at 100 per page if you have more than 100 file systems.
        /// </p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>(Optional) Specifies the maximum number of file systems to return in the response
        /// (integer). This number is automatically set to 100. The response is paginated at 100 per page if you have more than 100 file systems.
        /// </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous
        /// <code>DescribeFileSystems</code> operation (String). If present, specifies to continue the
        /// list from where the returning call had left off. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous
        /// <code>DescribeFileSystems</code> operation (String). If present, specifies to continue the
        /// list from where the returning call had left off. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>(Optional) Restricts the list to the file system with this creation token (String). You
        /// specify a creation token when you create an Amazon EFS file system.</p>
        pub fn creation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_token = Some(input.into());
            self
        }
        /// <p>(Optional) Restricts the list to the file system with this creation token (String). You
        /// specify a creation token when you create an Amazon EFS file system.</p>
        pub fn set_creation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_token = input;
            self
        }
        /// <p>(Optional) ID of the file system whose description you want to retrieve
        /// (String).</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>(Optional) ID of the file system whose description you want to retrieve
        /// (String).</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFileSystemsInput`](crate::input::DescribeFileSystemsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFileSystemsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFileSystemsInput {
                max_items: self.max_items,
                marker: self.marker,
                creation_token: self.creation_token,
                file_system_id: self.file_system_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFileSystemsInputOperationOutputAlias = crate::operation::DescribeFileSystems;
#[doc(hidden)]
pub type DescribeFileSystemsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeFileSystemsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFileSystems`](crate::operation::DescribeFileSystems)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFileSystems,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFileSystemsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2015-02-01/file-systems").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribeFileSystemsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_13) = &_input.max_items {
                query.push_kv(
                    "MaxItems",
                    &aws_smithy_types::primitive::Encoder::from(*inner_13).encode(),
                );
            }
            if let Some(inner_14) = &_input.marker {
                query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_14));
            }
            if let Some(inner_15) = &_input.creation_token {
                query.push_kv(
                    "CreationToken",
                    &aws_smithy_http::query::fmt_string(&inner_15),
                );
            }
            if let Some(inner_16) = &_input.file_system_id {
                query.push_kv(
                    "FileSystemId",
                    &aws_smithy_http::query::fmt_string(&inner_16),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFileSystemsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFileSystemsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFileSystems::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFileSystems",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFileSystemsInput`](crate::input::DescribeFileSystemsInput)
    pub fn builder() -> crate::input::describe_file_systems_input::Builder {
        crate::input::describe_file_systems_input::Builder::default()
    }
}

/// See [`DescribeLifecycleConfigurationInput`](crate::input::DescribeLifecycleConfigurationInput)
pub mod describe_lifecycle_configuration_input {
    /// A builder for [`DescribeLifecycleConfigurationInput`](crate::input::DescribeLifecycleConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the file system whose <code>LifecycleConfiguration</code> object you want to
        /// retrieve (String).</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system whose <code>LifecycleConfiguration</code> object you want to
        /// retrieve (String).</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLifecycleConfigurationInput`](crate::input::DescribeLifecycleConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLifecycleConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLifecycleConfigurationInput {
                file_system_id: self.file_system_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLifecycleConfigurationInputOperationOutputAlias =
    crate::operation::DescribeLifecycleConfiguration;
#[doc(hidden)]
pub type DescribeLifecycleConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeLifecycleConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLifecycleConfiguration`](crate::operation::DescribeLifecycleConfiguration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLifecycleConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLifecycleConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.file_system_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "file_system_id",
                        details: "cannot be empty or unset",
                    })?;
            let file_system_id = aws_smithy_http::label::fmt_string(input_17, false);
            if file_system_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "file_system_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/file-systems/{FileSystemId}/lifecycle-configuration",
                FileSystemId = file_system_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLifecycleConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLifecycleConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLifecycleConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLifecycleConfiguration",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLifecycleConfigurationInput`](crate::input::DescribeLifecycleConfigurationInput)
    pub fn builder() -> crate::input::describe_lifecycle_configuration_input::Builder {
        crate::input::describe_lifecycle_configuration_input::Builder::default()
    }
}

/// See [`DescribeMountTargetsInput`](crate::input::DescribeMountTargetsInput)
pub mod describe_mount_targets_input {
    /// A builder for [`DescribeMountTargetsInput`](crate::input::DescribeMountTargetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) mount_target_id: std::option::Option<std::string::String>,
        pub(crate) access_point_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>(Optional) Maximum number of mount targets to return in the response. Currently, this
        /// number is automatically set to
        /// 10, and other values are ignored. The response is paginated at 100 per page if you have more than 100 mount targets.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>(Optional) Maximum number of mount targets to return in the response. Currently, this
        /// number is automatically set to
        /// 10, and other values are ignored. The response is paginated at 100 per page if you have more than 100 mount targets.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous
        /// <code>DescribeMountTargets</code> operation (String). If present, it specifies to continue
        /// the list from where the previous returning call left off.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous
        /// <code>DescribeMountTargets</code> operation (String). If present, it specifies to continue
        /// the list from where the previous returning call left off.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>(Optional) ID of the file system whose mount targets you want to list (String). It must
        /// be included in your request if an <code>AccessPointId</code> or <code>MountTargetId</code> is not included. Accepts either a file system ID or ARN as input.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>(Optional) ID of the file system whose mount targets you want to list (String). It must
        /// be included in your request if an <code>AccessPointId</code> or <code>MountTargetId</code> is not included. Accepts either a file system ID or ARN as input.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>(Optional) ID of the mount target that you want to have described (String). It must be
        /// included in your request if <code>FileSystemId</code> is not included. Accepts either a mount target ID or ARN as input.</p>
        pub fn mount_target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.mount_target_id = Some(input.into());
            self
        }
        /// <p>(Optional) ID of the mount target that you want to have described (String). It must be
        /// included in your request if <code>FileSystemId</code> is not included. Accepts either a mount target ID or ARN as input.</p>
        pub fn set_mount_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mount_target_id = input;
            self
        }
        /// <p>(Optional) The ID of the access point whose mount targets that you want to list. It must be included in your request if a
        /// <code>FileSystemId</code> or <code>MountTargetId</code> is not included in your request. Accepts either an access point ID or ARN as input.</p>
        pub fn access_point_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_point_id = Some(input.into());
            self
        }
        /// <p>(Optional) The ID of the access point whose mount targets that you want to list. It must be included in your request if a
        /// <code>FileSystemId</code> or <code>MountTargetId</code> is not included in your request. Accepts either an access point ID or ARN as input.</p>
        pub fn set_access_point_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_point_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMountTargetsInput`](crate::input::DescribeMountTargetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMountTargetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMountTargetsInput {
                max_items: self.max_items,
                marker: self.marker,
                file_system_id: self.file_system_id,
                mount_target_id: self.mount_target_id,
                access_point_id: self.access_point_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMountTargetsInputOperationOutputAlias = crate::operation::DescribeMountTargets;
#[doc(hidden)]
pub type DescribeMountTargetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeMountTargetsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMountTargets`](crate::operation::DescribeMountTargets)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMountTargets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMountTargetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2015-02-01/mount-targets").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribeMountTargetsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_18) = &_input.max_items {
                query.push_kv(
                    "MaxItems",
                    &aws_smithy_types::primitive::Encoder::from(*inner_18).encode(),
                );
            }
            if let Some(inner_19) = &_input.marker {
                query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_19));
            }
            if let Some(inner_20) = &_input.file_system_id {
                query.push_kv(
                    "FileSystemId",
                    &aws_smithy_http::query::fmt_string(&inner_20),
                );
            }
            if let Some(inner_21) = &_input.mount_target_id {
                query.push_kv(
                    "MountTargetId",
                    &aws_smithy_http::query::fmt_string(&inner_21),
                );
            }
            if let Some(inner_22) = &_input.access_point_id {
                query.push_kv(
                    "AccessPointId",
                    &aws_smithy_http::query::fmt_string(&inner_22),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMountTargetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMountTargetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMountTargets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMountTargets",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMountTargetsInput`](crate::input::DescribeMountTargetsInput)
    pub fn builder() -> crate::input::describe_mount_targets_input::Builder {
        crate::input::describe_mount_targets_input::Builder::default()
    }
}

/// See [`DescribeMountTargetSecurityGroupsInput`](crate::input::DescribeMountTargetSecurityGroupsInput)
pub mod describe_mount_target_security_groups_input {
    /// A builder for [`DescribeMountTargetSecurityGroupsInput`](crate::input::DescribeMountTargetSecurityGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mount_target_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the mount target whose security groups you want to retrieve.</p>
        pub fn mount_target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.mount_target_id = Some(input.into());
            self
        }
        /// <p>The ID of the mount target whose security groups you want to retrieve.</p>
        pub fn set_mount_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mount_target_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMountTargetSecurityGroupsInput`](crate::input::DescribeMountTargetSecurityGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMountTargetSecurityGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMountTargetSecurityGroupsInput {
                mount_target_id: self.mount_target_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMountTargetSecurityGroupsInputOperationOutputAlias =
    crate::operation::DescribeMountTargetSecurityGroups;
#[doc(hidden)]
pub type DescribeMountTargetSecurityGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeMountTargetSecurityGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMountTargetSecurityGroups`](crate::operation::DescribeMountTargetSecurityGroups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMountTargetSecurityGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMountTargetSecurityGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.mount_target_id;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mount_target_id",
                        details: "cannot be empty or unset",
                    })?;
            let mount_target_id = aws_smithy_http::label::fmt_string(input_23, false);
            if mount_target_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "mount_target_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/mount-targets/{MountTargetId}/security-groups",
                MountTargetId = mount_target_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMountTargetSecurityGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMountTargetSecurityGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMountTargetSecurityGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMountTargetSecurityGroups",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMountTargetSecurityGroupsInput`](crate::input::DescribeMountTargetSecurityGroupsInput)
    pub fn builder() -> crate::input::describe_mount_target_security_groups_input::Builder {
        crate::input::describe_mount_target_security_groups_input::Builder::default()
    }
}

/// See [`DescribeTagsInput`](crate::input::DescribeTagsInput)
pub mod describe_tags_input {
    /// A builder for [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>(Optional) The maximum number of file system tags to return in the response. Currently,
        /// this number is automatically set to
        /// 100, and other values are ignored. The response is paginated at 100 per page if you have more than 100 tags.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>(Optional) The maximum number of file system tags to return in the response. Currently,
        /// this number is automatically set to
        /// 100, and other values are ignored. The response is paginated at 100 per page if you have more than 100 tags.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>(Optional) An opaque pagination token returned from a previous
        /// <code>DescribeTags</code> operation (String). If present, it specifies to continue the list
        /// from where the previous call left off.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>(Optional) An opaque pagination token returned from a previous
        /// <code>DescribeTags</code> operation (String). If present, it specifies to continue the list
        /// from where the previous call left off.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The ID of the file system whose tag set you want to retrieve.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system whose tag set you want to retrieve.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTagsInput`](crate::input::DescribeTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTagsInput {
                max_items: self.max_items,
                marker: self.marker,
                file_system_id: self.file_system_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTagsInputOperationOutputAlias = crate::operation::DescribeTags;
#[doc(hidden)]
pub type DescribeTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTagsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTags`](crate::operation::DescribeTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.file_system_id;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "file_system_id",
                        details: "cannot be empty or unset",
                    })?;
            let file_system_id = aws_smithy_http::label::fmt_string(input_24, false);
            if file_system_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "file_system_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/tags/{FileSystemId}",
                FileSystemId = file_system_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribeTagsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_25) = &_input.max_items {
                query.push_kv(
                    "MaxItems",
                    &aws_smithy_types::primitive::Encoder::from(*inner_25).encode(),
                );
            }
            if let Some(inner_26) = &_input.marker {
                query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_26));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTags",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    pub fn builder() -> crate::input::describe_tags_input::Builder {
        crate::input::describe_tags_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the EFS resource you want to retrieve tags for. You can retrieve tags for EFS file systems and access points using this API endpoint.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Specifies the EFS resource you want to retrieve tags for. You can retrieve tags for EFS file systems and access points using this API endpoint.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>(Optional) Specifies the maximum number of tag objects to return in the response. The default value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>(Optional) Specifies the maximum number of tag objects to return in the response. The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>(Optional) You can use <code>NextToken</code> in a subsequent request to fetch the next page of access point descriptions if the response payload was paginated.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>(Optional) You can use <code>NextToken</code> in a subsequent request to fetch the next page of access point descriptions if the response payload was paginated.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_id: self.resource_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.resource_id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_27, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/resource-tags/{ResourceId}",
                ResourceId = resource_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListTagsForResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_28) = &_input.max_results {
                query.push_kv(
                    "MaxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_28).encode(),
                );
            }
            if let Some(inner_29) = &_input.next_token {
                query.push_kv("NextToken", &aws_smithy_http::query::fmt_string(&inner_29));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ModifyMountTargetSecurityGroupsInput`](crate::input::ModifyMountTargetSecurityGroupsInput)
pub mod modify_mount_target_security_groups_input {
    /// A builder for [`ModifyMountTargetSecurityGroupsInput`](crate::input::ModifyMountTargetSecurityGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mount_target_id: std::option::Option<std::string::String>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the mount target whose security groups you want to modify.</p>
        pub fn mount_target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.mount_target_id = Some(input.into());
            self
        }
        /// <p>The ID of the mount target whose security groups you want to modify.</p>
        pub fn set_mount_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mount_target_id = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>An array of up to five VPC security group IDs.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>An array of up to five VPC security group IDs.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyMountTargetSecurityGroupsInput`](crate::input::ModifyMountTargetSecurityGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyMountTargetSecurityGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyMountTargetSecurityGroupsInput {
                mount_target_id: self.mount_target_id,
                security_groups: self.security_groups,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyMountTargetSecurityGroupsInputOperationOutputAlias =
    crate::operation::ModifyMountTargetSecurityGroups;
#[doc(hidden)]
pub type ModifyMountTargetSecurityGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyMountTargetSecurityGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ModifyMountTargetSecurityGroups`](crate::operation::ModifyMountTargetSecurityGroups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyMountTargetSecurityGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyMountTargetSecurityGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.mount_target_id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mount_target_id",
                        details: "cannot be empty or unset",
                    })?;
            let mount_target_id = aws_smithy_http::label::fmt_string(input_30, false);
            if mount_target_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "mount_target_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/mount-targets/{MountTargetId}/security-groups",
                MountTargetId = mount_target_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyMountTargetSecurityGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyMountTargetSecurityGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_mount_target_security_groups(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyMountTargetSecurityGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyMountTargetSecurityGroups",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyMountTargetSecurityGroupsInput`](crate::input::ModifyMountTargetSecurityGroupsInput)
    pub fn builder() -> crate::input::modify_mount_target_security_groups_input::Builder {
        crate::input::modify_mount_target_security_groups_input::Builder::default()
    }
}

/// See [`PutAccountPreferencesInput`](crate::input::PutAccountPreferencesInput)
pub mod put_account_preferences_input {
    /// A builder for [`PutAccountPreferencesInput`](crate::input::PutAccountPreferencesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id_type: std::option::Option<crate::model::ResourceIdType>,
    }
    impl Builder {
        /// <p>Specifies the EFS resource ID preference to set for the user's Amazon Web Services account, in the current Amazon Web Services Region,
        /// either <code>LONG_ID</code> (17 characters), or <code>SHORT_ID</code> (8 characters).</p>
        /// <note>
        /// <p>Starting in October, 2021, you will receive an error when setting the account preference to <code>SHORT_ID</code>.
        /// Contact Amazon Web Services support if you receive an error and need to use short IDs for file system and mount target resources.</p>
        /// </note>
        pub fn resource_id_type(mut self, input: crate::model::ResourceIdType) -> Self {
            self.resource_id_type = Some(input);
            self
        }
        /// <p>Specifies the EFS resource ID preference to set for the user's Amazon Web Services account, in the current Amazon Web Services Region,
        /// either <code>LONG_ID</code> (17 characters), or <code>SHORT_ID</code> (8 characters).</p>
        /// <note>
        /// <p>Starting in October, 2021, you will receive an error when setting the account preference to <code>SHORT_ID</code>.
        /// Contact Amazon Web Services support if you receive an error and need to use short IDs for file system and mount target resources.</p>
        /// </note>
        pub fn set_resource_id_type(
            mut self,
            input: std::option::Option<crate::model::ResourceIdType>,
        ) -> Self {
            self.resource_id_type = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAccountPreferencesInput`](crate::input::PutAccountPreferencesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAccountPreferencesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutAccountPreferencesInput {
                resource_id_type: self.resource_id_type,
            })
        }
    }
}
#[doc(hidden)]
pub type PutAccountPreferencesInputOperationOutputAlias = crate::operation::PutAccountPreferences;
#[doc(hidden)]
pub type PutAccountPreferencesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutAccountPreferencesInput {
    /// Consumes the builder and constructs an Operation<[`PutAccountPreferences`](crate::operation::PutAccountPreferences)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAccountPreferences,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutAccountPreferencesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2015-02-01/account-preferences").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutAccountPreferencesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutAccountPreferencesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_account_preferences(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAccountPreferences::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAccountPreferences",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutAccountPreferencesInput`](crate::input::PutAccountPreferencesInput)
    pub fn builder() -> crate::input::put_account_preferences_input::Builder {
        crate::input::put_account_preferences_input::Builder::default()
    }
}

/// See [`PutBackupPolicyInput`](crate::input::PutBackupPolicyInput)
pub mod put_backup_policy_input {
    /// A builder for [`PutBackupPolicyInput`](crate::input::PutBackupPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) backup_policy: std::option::Option<crate::model::BackupPolicy>,
    }
    impl Builder {
        /// <p>Specifies which EFS file system to update the backup policy for.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>Specifies which EFS file system to update the backup policy for.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The backup policy included in the <code>PutBackupPolicy</code> request.</p>
        pub fn backup_policy(mut self, input: crate::model::BackupPolicy) -> Self {
            self.backup_policy = Some(input);
            self
        }
        /// <p>The backup policy included in the <code>PutBackupPolicy</code> request.</p>
        pub fn set_backup_policy(
            mut self,
            input: std::option::Option<crate::model::BackupPolicy>,
        ) -> Self {
            self.backup_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBackupPolicyInput`](crate::input::PutBackupPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBackupPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBackupPolicyInput {
                file_system_id: self.file_system_id,
                backup_policy: self.backup_policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBackupPolicyInputOperationOutputAlias = crate::operation::PutBackupPolicy;
#[doc(hidden)]
pub type PutBackupPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutBackupPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutBackupPolicy`](crate::operation::PutBackupPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBackupPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBackupPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_31 = &_input.file_system_id;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "file_system_id",
                        details: "cannot be empty or unset",
                    })?;
            let file_system_id = aws_smithy_http::label::fmt_string(input_31, false);
            if file_system_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "file_system_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/file-systems/{FileSystemId}/backup-policy",
                FileSystemId = file_system_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBackupPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBackupPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_backup_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBackupPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBackupPolicy",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBackupPolicyInput`](crate::input::PutBackupPolicyInput)
    pub fn builder() -> crate::input::put_backup_policy_input::Builder {
        crate::input::put_backup_policy_input::Builder::default()
    }
}

/// See [`PutFileSystemPolicyInput`](crate::input::PutFileSystemPolicyInput)
pub mod put_file_system_policy_input {
    /// A builder for [`PutFileSystemPolicyInput`](crate::input::PutFileSystemPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) bypass_policy_lockout_safety_check: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the EFS file system that you want to create or update the <code>FileSystemPolicy</code> for.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the EFS file system that you want to create or update the <code>FileSystemPolicy</code> for.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The <code>FileSystemPolicy</code> that you're creating. Accepts a JSON formatted policy definition.
        /// EFS file system policies have a 20,000 character limit.
        /// To find out more about the elements that make up a file system policy, see
        /// <a href="https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies">EFS Resource-based Policies</a>.
        /// </p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The <code>FileSystemPolicy</code> that you're creating. Accepts a JSON formatted policy definition.
        /// EFS file system policies have a 20,000 character limit.
        /// To find out more about the elements that make up a file system policy, see
        /// <a href="https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies">EFS Resource-based Policies</a>.
        /// </p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p>(Optional) A flag to indicate whether to bypass the <code>FileSystemPolicy</code> lockout safety check. The policy lockout safety check
        /// determines whether the policy in the request will prevent the principal making the request will be locked out from making future <code>PutFileSystemPolicy</code> requests on the file system.
        /// Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent
        /// the principal that is making the request from making a subsequent <code>PutFileSystemPolicy</code> request on the file system.
        /// The default value is False.
        /// </p>
        pub fn bypass_policy_lockout_safety_check(mut self, input: bool) -> Self {
            self.bypass_policy_lockout_safety_check = Some(input);
            self
        }
        /// <p>(Optional) A flag to indicate whether to bypass the <code>FileSystemPolicy</code> lockout safety check. The policy lockout safety check
        /// determines whether the policy in the request will prevent the principal making the request will be locked out from making future <code>PutFileSystemPolicy</code> requests on the file system.
        /// Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent
        /// the principal that is making the request from making a subsequent <code>PutFileSystemPolicy</code> request on the file system.
        /// The default value is False.
        /// </p>
        pub fn set_bypass_policy_lockout_safety_check(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.bypass_policy_lockout_safety_check = input;
            self
        }
        /// Consumes the builder and constructs a [`PutFileSystemPolicyInput`](crate::input::PutFileSystemPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutFileSystemPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutFileSystemPolicyInput {
                file_system_id: self.file_system_id,
                policy: self.policy,
                bypass_policy_lockout_safety_check: self
                    .bypass_policy_lockout_safety_check
                    .unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type PutFileSystemPolicyInputOperationOutputAlias = crate::operation::PutFileSystemPolicy;
#[doc(hidden)]
pub type PutFileSystemPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutFileSystemPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutFileSystemPolicy`](crate::operation::PutFileSystemPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutFileSystemPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutFileSystemPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_32 = &_input.file_system_id;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "file_system_id",
                        details: "cannot be empty or unset",
                    })?;
            let file_system_id = aws_smithy_http::label::fmt_string(input_32, false);
            if file_system_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "file_system_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/file-systems/{FileSystemId}/policy",
                FileSystemId = file_system_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutFileSystemPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutFileSystemPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_file_system_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutFileSystemPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutFileSystemPolicy",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutFileSystemPolicyInput`](crate::input::PutFileSystemPolicyInput)
    pub fn builder() -> crate::input::put_file_system_policy_input::Builder {
        crate::input::put_file_system_policy_input::Builder::default()
    }
}

/// See [`PutLifecycleConfigurationInput`](crate::input::PutLifecycleConfigurationInput)
pub mod put_lifecycle_configuration_input {
    /// A builder for [`PutLifecycleConfigurationInput`](crate::input::PutLifecycleConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) lifecycle_policies:
            std::option::Option<std::vec::Vec<crate::model::LifecyclePolicy>>,
    }
    impl Builder {
        /// <p>The ID of the file system for which you are creating the
        /// <code>LifecycleConfiguration</code> object (String).</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system for which you are creating the
        /// <code>LifecycleConfiguration</code> object (String).</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// Appends an item to `lifecycle_policies`.
        ///
        /// To override the contents of this collection use [`set_lifecycle_policies`](Self::set_lifecycle_policies).
        ///
        /// <p>An array of <code>LifecyclePolicy</code> objects that define the file system's
        /// <code>LifecycleConfiguration</code> object. A <code>LifecycleConfiguration</code> object
        /// informs EFS lifecycle management and intelligent tiering of the following:</p>
        /// <ul>
        /// <li>
        /// <p>When to move files in the file system from primary storage to the IA storage class.</p>
        /// </li>
        /// <li>
        /// <p>When to move files that are in IA storage to primary storage.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>When using the <code>put-lifecycle-configuration</code> CLI command or the <code>PutLifecycleConfiguration</code> API action,
        /// Amazon EFS requires that each <code>LifecyclePolicy</code>
        /// object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as
        /// an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code>, <code>TransitionToPrimaryStorageClass</code>.
        /// See the example requests in the following section for more information.</p>
        /// </note>
        pub fn lifecycle_policies(
            mut self,
            input: impl Into<crate::model::LifecyclePolicy>,
        ) -> Self {
            let mut v = self.lifecycle_policies.unwrap_or_default();
            v.push(input.into());
            self.lifecycle_policies = Some(v);
            self
        }
        /// <p>An array of <code>LifecyclePolicy</code> objects that define the file system's
        /// <code>LifecycleConfiguration</code> object. A <code>LifecycleConfiguration</code> object
        /// informs EFS lifecycle management and intelligent tiering of the following:</p>
        /// <ul>
        /// <li>
        /// <p>When to move files in the file system from primary storage to the IA storage class.</p>
        /// </li>
        /// <li>
        /// <p>When to move files that are in IA storage to primary storage.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>When using the <code>put-lifecycle-configuration</code> CLI command or the <code>PutLifecycleConfiguration</code> API action,
        /// Amazon EFS requires that each <code>LifecyclePolicy</code>
        /// object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as
        /// an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code>, <code>TransitionToPrimaryStorageClass</code>.
        /// See the example requests in the following section for more information.</p>
        /// </note>
        pub fn set_lifecycle_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LifecyclePolicy>>,
        ) -> Self {
            self.lifecycle_policies = input;
            self
        }
        /// Consumes the builder and constructs a [`PutLifecycleConfigurationInput`](crate::input::PutLifecycleConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutLifecycleConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutLifecycleConfigurationInput {
                file_system_id: self.file_system_id,
                lifecycle_policies: self.lifecycle_policies,
            })
        }
    }
}
#[doc(hidden)]
pub type PutLifecycleConfigurationInputOperationOutputAlias =
    crate::operation::PutLifecycleConfiguration;
#[doc(hidden)]
pub type PutLifecycleConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutLifecycleConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutLifecycleConfiguration`](crate::operation::PutLifecycleConfiguration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutLifecycleConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutLifecycleConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_33 = &_input.file_system_id;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "file_system_id",
                        details: "cannot be empty or unset",
                    })?;
            let file_system_id = aws_smithy_http::label::fmt_string(input_33, false);
            if file_system_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "file_system_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/file-systems/{FileSystemId}/lifecycle-configuration",
                FileSystemId = file_system_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutLifecycleConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutLifecycleConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_lifecycle_configuration(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutLifecycleConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutLifecycleConfiguration",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutLifecycleConfigurationInput`](crate::input::PutLifecycleConfigurationInput)
    pub fn builder() -> crate::input::put_lifecycle_configuration_input::Builder {
        crate::input::put_lifecycle_configuration_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID specifying the EFS resource that you want to create a tag for.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID specifying the EFS resource that you want to create a tag for.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value
        /// pair.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value
        /// pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_id: self.resource_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_34 = &_input.resource_id;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_34, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/resource-tags/{ResourceId}",
                ResourceId = resource_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Specifies the EFS resource that you want to remove tags from.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Specifies the EFS resource that you want to remove tags from.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the key-value tag pairs that you want to remove from the specified EFS
        /// resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The keys of the key-value tag pairs that you want to remove from the specified EFS
        /// resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_id: self.resource_id,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_35 = &_input.resource_id;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_35, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/resource-tags/{ResourceId}",
                ResourceId = resource_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_36) = &_input.tag_keys {
                for inner_37 in inner_36 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_37));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateFileSystemInput`](crate::input::UpdateFileSystemInput)
pub mod update_file_system_input {
    /// A builder for [`UpdateFileSystemInput`](crate::input::UpdateFileSystemInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) throughput_mode: std::option::Option<crate::model::ThroughputMode>,
        pub(crate) provisioned_throughput_in_mibps: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The ID of the file system that you want to update.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system that you want to update.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>(Optional) Updates the file system's throughput mode. If you're not
        /// updating your throughput mode, you don't need to provide this value in your
        /// request. If you are changing the <code>ThroughputMode</code> to <code>provisioned</code>,
        /// you must also set a value for <code>ProvisionedThroughputInMibps</code>.</p>
        pub fn throughput_mode(mut self, input: crate::model::ThroughputMode) -> Self {
            self.throughput_mode = Some(input);
            self
        }
        /// <p>(Optional) Updates the file system's throughput mode. If you're not
        /// updating your throughput mode, you don't need to provide this value in your
        /// request. If you are changing the <code>ThroughputMode</code> to <code>provisioned</code>,
        /// you must also set a value for <code>ProvisionedThroughputInMibps</code>.</p>
        pub fn set_throughput_mode(
            mut self,
            input: std::option::Option<crate::model::ThroughputMode>,
        ) -> Self {
            self.throughput_mode = input;
            self
        }
        /// <p>(Optional) Sets the amount of provisioned throughput, in MiB/s, for the file
        /// system. Valid values are 1-1024. If you are changing the throughput mode to provisioned, you must also
        /// provide the amount of provisioned throughput. Required if <code>ThroughputMode</code> is changed
        /// to <code>provisioned</code> on update.</p>
        pub fn provisioned_throughput_in_mibps(mut self, input: f64) -> Self {
            self.provisioned_throughput_in_mibps = Some(input);
            self
        }
        /// <p>(Optional) Sets the amount of provisioned throughput, in MiB/s, for the file
        /// system. Valid values are 1-1024. If you are changing the throughput mode to provisioned, you must also
        /// provide the amount of provisioned throughput. Required if <code>ThroughputMode</code> is changed
        /// to <code>provisioned</code> on update.</p>
        pub fn set_provisioned_throughput_in_mibps(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.provisioned_throughput_in_mibps = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFileSystemInput`](crate::input::UpdateFileSystemInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFileSystemInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFileSystemInput {
                file_system_id: self.file_system_id,
                throughput_mode: self.throughput_mode,
                provisioned_throughput_in_mibps: self.provisioned_throughput_in_mibps,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFileSystemInputOperationOutputAlias = crate::operation::UpdateFileSystem;
#[doc(hidden)]
pub type UpdateFileSystemInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFileSystemInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFileSystem`](crate::operation::UpdateFileSystem)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFileSystem,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFileSystemInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_38 = &_input.file_system_id;
            let input_38 =
                input_38
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "file_system_id",
                        details: "cannot be empty or unset",
                    })?;
            let file_system_id = aws_smithy_http::label::fmt_string(input_38, false);
            if file_system_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "file_system_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2015-02-01/file-systems/{FileSystemId}",
                FileSystemId = file_system_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFileSystemInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFileSystemInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_file_system(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFileSystem::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFileSystem",
            "efs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFileSystemInput`](crate::input::UpdateFileSystemInput)
    pub fn builder() -> crate::input::update_file_system_input::Builder {
        crate::input::update_file_system_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFileSystemInput {
    /// <p>The ID of the file system that you want to update.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>(Optional) Updates the file system's throughput mode. If you're not
    /// updating your throughput mode, you don't need to provide this value in your
    /// request. If you are changing the <code>ThroughputMode</code> to <code>provisioned</code>,
    /// you must also set a value for <code>ProvisionedThroughputInMibps</code>.</p>
    pub throughput_mode: std::option::Option<crate::model::ThroughputMode>,
    /// <p>(Optional) Sets the amount of provisioned throughput, in MiB/s, for the file
    /// system. Valid values are 1-1024. If you are changing the throughput mode to provisioned, you must also
    /// provide the amount of provisioned throughput. Required if <code>ThroughputMode</code> is changed
    /// to <code>provisioned</code> on update.</p>
    pub provisioned_throughput_in_mibps: std::option::Option<f64>,
}
impl UpdateFileSystemInput {
    /// <p>The ID of the file system that you want to update.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>(Optional) Updates the file system's throughput mode. If you're not
    /// updating your throughput mode, you don't need to provide this value in your
    /// request. If you are changing the <code>ThroughputMode</code> to <code>provisioned</code>,
    /// you must also set a value for <code>ProvisionedThroughputInMibps</code>.</p>
    pub fn throughput_mode(&self) -> std::option::Option<&crate::model::ThroughputMode> {
        self.throughput_mode.as_ref()
    }
    /// <p>(Optional) Sets the amount of provisioned throughput, in MiB/s, for the file
    /// system. Valid values are 1-1024. If you are changing the throughput mode to provisioned, you must also
    /// provide the amount of provisioned throughput. Required if <code>ThroughputMode</code> is changed
    /// to <code>provisioned</code> on update.</p>
    pub fn provisioned_throughput_in_mibps(&self) -> std::option::Option<f64> {
        self.provisioned_throughput_in_mibps
    }
}
impl std::fmt::Debug for UpdateFileSystemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFileSystemInput");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("throughput_mode", &self.throughput_mode);
        formatter.field(
            "provisioned_throughput_in_mibps",
            &self.provisioned_throughput_in_mibps,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>Specifies the EFS resource that you want to remove tags from.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The keys of the key-value tag pairs that you want to remove from the specified EFS
    /// resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>Specifies the EFS resource that you want to remove tags from.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The keys of the key-value tag pairs that you want to remove from the specified EFS
    /// resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ID specifying the EFS resource that you want to create a tag for.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>An array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value
    /// pair.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The ID specifying the EFS resource that you want to create a tag for.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>An array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value
    /// pair.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutLifecycleConfigurationInput {
    /// <p>The ID of the file system for which you are creating the
    /// <code>LifecycleConfiguration</code> object (String).</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>An array of <code>LifecyclePolicy</code> objects that define the file system's
    /// <code>LifecycleConfiguration</code> object. A <code>LifecycleConfiguration</code> object
    /// informs EFS lifecycle management and intelligent tiering of the following:</p>
    /// <ul>
    /// <li>
    /// <p>When to move files in the file system from primary storage to the IA storage class.</p>
    /// </li>
    /// <li>
    /// <p>When to move files that are in IA storage to primary storage.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>When using the <code>put-lifecycle-configuration</code> CLI command or the <code>PutLifecycleConfiguration</code> API action,
    /// Amazon EFS requires that each <code>LifecyclePolicy</code>
    /// object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as
    /// an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code>, <code>TransitionToPrimaryStorageClass</code>.
    /// See the example requests in the following section for more information.</p>
    /// </note>
    pub lifecycle_policies: std::option::Option<std::vec::Vec<crate::model::LifecyclePolicy>>,
}
impl PutLifecycleConfigurationInput {
    /// <p>The ID of the file system for which you are creating the
    /// <code>LifecycleConfiguration</code> object (String).</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>An array of <code>LifecyclePolicy</code> objects that define the file system's
    /// <code>LifecycleConfiguration</code> object. A <code>LifecycleConfiguration</code> object
    /// informs EFS lifecycle management and intelligent tiering of the following:</p>
    /// <ul>
    /// <li>
    /// <p>When to move files in the file system from primary storage to the IA storage class.</p>
    /// </li>
    /// <li>
    /// <p>When to move files that are in IA storage to primary storage.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>When using the <code>put-lifecycle-configuration</code> CLI command or the <code>PutLifecycleConfiguration</code> API action,
    /// Amazon EFS requires that each <code>LifecyclePolicy</code>
    /// object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as
    /// an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code>, <code>TransitionToPrimaryStorageClass</code>.
    /// See the example requests in the following section for more information.</p>
    /// </note>
    pub fn lifecycle_policies(&self) -> std::option::Option<&[crate::model::LifecyclePolicy]> {
        self.lifecycle_policies.as_deref()
    }
}
impl std::fmt::Debug for PutLifecycleConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutLifecycleConfigurationInput");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("lifecycle_policies", &self.lifecycle_policies);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutFileSystemPolicyInput {
    /// <p>The ID of the EFS file system that you want to create or update the <code>FileSystemPolicy</code> for.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The <code>FileSystemPolicy</code> that you're creating. Accepts a JSON formatted policy definition.
    /// EFS file system policies have a 20,000 character limit.
    /// To find out more about the elements that make up a file system policy, see
    /// <a href="https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies">EFS Resource-based Policies</a>.
    /// </p>
    pub policy: std::option::Option<std::string::String>,
    /// <p>(Optional) A flag to indicate whether to bypass the <code>FileSystemPolicy</code> lockout safety check. The policy lockout safety check
    /// determines whether the policy in the request will prevent the principal making the request will be locked out from making future <code>PutFileSystemPolicy</code> requests on the file system.
    /// Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent
    /// the principal that is making the request from making a subsequent <code>PutFileSystemPolicy</code> request on the file system.
    /// The default value is False.
    /// </p>
    pub bypass_policy_lockout_safety_check: bool,
}
impl PutFileSystemPolicyInput {
    /// <p>The ID of the EFS file system that you want to create or update the <code>FileSystemPolicy</code> for.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>The <code>FileSystemPolicy</code> that you're creating. Accepts a JSON formatted policy definition.
    /// EFS file system policies have a 20,000 character limit.
    /// To find out more about the elements that make up a file system policy, see
    /// <a href="https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies">EFS Resource-based Policies</a>.
    /// </p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>(Optional) A flag to indicate whether to bypass the <code>FileSystemPolicy</code> lockout safety check. The policy lockout safety check
    /// determines whether the policy in the request will prevent the principal making the request will be locked out from making future <code>PutFileSystemPolicy</code> requests on the file system.
    /// Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent
    /// the principal that is making the request from making a subsequent <code>PutFileSystemPolicy</code> request on the file system.
    /// The default value is False.
    /// </p>
    pub fn bypass_policy_lockout_safety_check(&self) -> bool {
        self.bypass_policy_lockout_safety_check
    }
}
impl std::fmt::Debug for PutFileSystemPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutFileSystemPolicyInput");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("policy", &self.policy);
        formatter.field(
            "bypass_policy_lockout_safety_check",
            &self.bypass_policy_lockout_safety_check,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBackupPolicyInput {
    /// <p>Specifies which EFS file system to update the backup policy for.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The backup policy included in the <code>PutBackupPolicy</code> request.</p>
    pub backup_policy: std::option::Option<crate::model::BackupPolicy>,
}
impl PutBackupPolicyInput {
    /// <p>Specifies which EFS file system to update the backup policy for.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>The backup policy included in the <code>PutBackupPolicy</code> request.</p>
    pub fn backup_policy(&self) -> std::option::Option<&crate::model::BackupPolicy> {
        self.backup_policy.as_ref()
    }
}
impl std::fmt::Debug for PutBackupPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBackupPolicyInput");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("backup_policy", &self.backup_policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAccountPreferencesInput {
    /// <p>Specifies the EFS resource ID preference to set for the user's Amazon Web Services account, in the current Amazon Web Services Region,
    /// either <code>LONG_ID</code> (17 characters), or <code>SHORT_ID</code> (8 characters).</p>
    /// <note>
    /// <p>Starting in October, 2021, you will receive an error when setting the account preference to <code>SHORT_ID</code>.
    /// Contact Amazon Web Services support if you receive an error and need to use short IDs for file system and mount target resources.</p>
    /// </note>
    pub resource_id_type: std::option::Option<crate::model::ResourceIdType>,
}
impl PutAccountPreferencesInput {
    /// <p>Specifies the EFS resource ID preference to set for the user's Amazon Web Services account, in the current Amazon Web Services Region,
    /// either <code>LONG_ID</code> (17 characters), or <code>SHORT_ID</code> (8 characters).</p>
    /// <note>
    /// <p>Starting in October, 2021, you will receive an error when setting the account preference to <code>SHORT_ID</code>.
    /// Contact Amazon Web Services support if you receive an error and need to use short IDs for file system and mount target resources.</p>
    /// </note>
    pub fn resource_id_type(&self) -> std::option::Option<&crate::model::ResourceIdType> {
        self.resource_id_type.as_ref()
    }
}
impl std::fmt::Debug for PutAccountPreferencesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAccountPreferencesInput");
        formatter.field("resource_id_type", &self.resource_id_type);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyMountTargetSecurityGroupsInput {
    /// <p>The ID of the mount target whose security groups you want to modify.</p>
    pub mount_target_id: std::option::Option<std::string::String>,
    /// <p>An array of up to five VPC security group IDs.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ModifyMountTargetSecurityGroupsInput {
    /// <p>The ID of the mount target whose security groups you want to modify.</p>
    pub fn mount_target_id(&self) -> std::option::Option<&str> {
        self.mount_target_id.as_deref()
    }
    /// <p>An array of up to five VPC security group IDs.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
}
impl std::fmt::Debug for ModifyMountTargetSecurityGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyMountTargetSecurityGroupsInput");
        formatter.field("mount_target_id", &self.mount_target_id);
        formatter.field("security_groups", &self.security_groups);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>Specifies the EFS resource you want to retrieve tags for. You can retrieve tags for EFS file systems and access points using this API endpoint.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>(Optional) Specifies the maximum number of tag objects to return in the response. The default value is 100.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>(Optional) You can use <code>NextToken</code> in a subsequent request to fetch the next page of access point descriptions if the response payload was paginated.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>Specifies the EFS resource you want to retrieve tags for. You can retrieve tags for EFS file systems and access points using this API endpoint.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>(Optional) Specifies the maximum number of tag objects to return in the response. The default value is 100.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>(Optional) You can use <code>NextToken</code> in a subsequent request to fetch the next page of access point descriptions if the response payload was paginated.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTagsInput {
    /// <p>(Optional) The maximum number of file system tags to return in the response. Currently,
    /// this number is automatically set to
    /// 100, and other values are ignored. The response is paginated at 100 per page if you have more than 100 tags.</p>
    pub max_items: std::option::Option<i32>,
    /// <p>(Optional) An opaque pagination token returned from a previous
    /// <code>DescribeTags</code> operation (String). If present, it specifies to continue the list
    /// from where the previous call left off.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The ID of the file system whose tag set you want to retrieve.</p>
    pub file_system_id: std::option::Option<std::string::String>,
}
impl DescribeTagsInput {
    /// <p>(Optional) The maximum number of file system tags to return in the response. Currently,
    /// this number is automatically set to
    /// 100, and other values are ignored. The response is paginated at 100 per page if you have more than 100 tags.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
    /// <p>(Optional) An opaque pagination token returned from a previous
    /// <code>DescribeTags</code> operation (String). If present, it specifies to continue the list
    /// from where the previous call left off.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The ID of the file system whose tag set you want to retrieve.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTagsInput");
        formatter.field("max_items", &self.max_items);
        formatter.field("marker", &self.marker);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMountTargetSecurityGroupsInput {
    /// <p>The ID of the mount target whose security groups you want to retrieve.</p>
    pub mount_target_id: std::option::Option<std::string::String>,
}
impl DescribeMountTargetSecurityGroupsInput {
    /// <p>The ID of the mount target whose security groups you want to retrieve.</p>
    pub fn mount_target_id(&self) -> std::option::Option<&str> {
        self.mount_target_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeMountTargetSecurityGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMountTargetSecurityGroupsInput");
        formatter.field("mount_target_id", &self.mount_target_id);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMountTargetsInput {
    /// <p>(Optional) Maximum number of mount targets to return in the response. Currently, this
    /// number is automatically set to
    /// 10, and other values are ignored. The response is paginated at 100 per page if you have more than 100 mount targets.</p>
    pub max_items: std::option::Option<i32>,
    /// <p>(Optional) Opaque pagination token returned from a previous
    /// <code>DescribeMountTargets</code> operation (String). If present, it specifies to continue
    /// the list from where the previous returning call left off.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>(Optional) ID of the file system whose mount targets you want to list (String). It must
    /// be included in your request if an <code>AccessPointId</code> or <code>MountTargetId</code> is not included. Accepts either a file system ID or ARN as input.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>(Optional) ID of the mount target that you want to have described (String). It must be
    /// included in your request if <code>FileSystemId</code> is not included. Accepts either a mount target ID or ARN as input.</p>
    pub mount_target_id: std::option::Option<std::string::String>,
    /// <p>(Optional) The ID of the access point whose mount targets that you want to list. It must be included in your request if a
    /// <code>FileSystemId</code> or <code>MountTargetId</code> is not included in your request. Accepts either an access point ID or ARN as input.</p>
    pub access_point_id: std::option::Option<std::string::String>,
}
impl DescribeMountTargetsInput {
    /// <p>(Optional) Maximum number of mount targets to return in the response. Currently, this
    /// number is automatically set to
    /// 10, and other values are ignored. The response is paginated at 100 per page if you have more than 100 mount targets.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
    /// <p>(Optional) Opaque pagination token returned from a previous
    /// <code>DescribeMountTargets</code> operation (String). If present, it specifies to continue
    /// the list from where the previous returning call left off.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>(Optional) ID of the file system whose mount targets you want to list (String). It must
    /// be included in your request if an <code>AccessPointId</code> or <code>MountTargetId</code> is not included. Accepts either a file system ID or ARN as input.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>(Optional) ID of the mount target that you want to have described (String). It must be
    /// included in your request if <code>FileSystemId</code> is not included. Accepts either a mount target ID or ARN as input.</p>
    pub fn mount_target_id(&self) -> std::option::Option<&str> {
        self.mount_target_id.as_deref()
    }
    /// <p>(Optional) The ID of the access point whose mount targets that you want to list. It must be included in your request if a
    /// <code>FileSystemId</code> or <code>MountTargetId</code> is not included in your request. Accepts either an access point ID or ARN as input.</p>
    pub fn access_point_id(&self) -> std::option::Option<&str> {
        self.access_point_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeMountTargetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMountTargetsInput");
        formatter.field("max_items", &self.max_items);
        formatter.field("marker", &self.marker);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("mount_target_id", &self.mount_target_id);
        formatter.field("access_point_id", &self.access_point_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLifecycleConfigurationInput {
    /// <p>The ID of the file system whose <code>LifecycleConfiguration</code> object you want to
    /// retrieve (String).</p>
    pub file_system_id: std::option::Option<std::string::String>,
}
impl DescribeLifecycleConfigurationInput {
    /// <p>The ID of the file system whose <code>LifecycleConfiguration</code> object you want to
    /// retrieve (String).</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeLifecycleConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLifecycleConfigurationInput");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFileSystemsInput {
    /// <p>(Optional) Specifies the maximum number of file systems to return in the response
    /// (integer). This number is automatically set to 100. The response is paginated at 100 per page if you have more than 100 file systems.
    /// </p>
    pub max_items: std::option::Option<i32>,
    /// <p>(Optional) Opaque pagination token returned from a previous
    /// <code>DescribeFileSystems</code> operation (String). If present, specifies to continue the
    /// list from where the returning call had left off. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>(Optional) Restricts the list to the file system with this creation token (String). You
    /// specify a creation token when you create an Amazon EFS file system.</p>
    pub creation_token: std::option::Option<std::string::String>,
    /// <p>(Optional) ID of the file system whose description you want to retrieve
    /// (String).</p>
    pub file_system_id: std::option::Option<std::string::String>,
}
impl DescribeFileSystemsInput {
    /// <p>(Optional) Specifies the maximum number of file systems to return in the response
    /// (integer). This number is automatically set to 100. The response is paginated at 100 per page if you have more than 100 file systems.
    /// </p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
    /// <p>(Optional) Opaque pagination token returned from a previous
    /// <code>DescribeFileSystems</code> operation (String). If present, specifies to continue the
    /// list from where the returning call had left off. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>(Optional) Restricts the list to the file system with this creation token (String). You
    /// specify a creation token when you create an Amazon EFS file system.</p>
    pub fn creation_token(&self) -> std::option::Option<&str> {
        self.creation_token.as_deref()
    }
    /// <p>(Optional) ID of the file system whose description you want to retrieve
    /// (String).</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeFileSystemsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFileSystemsInput");
        formatter.field("max_items", &self.max_items);
        formatter.field("marker", &self.marker);
        formatter.field("creation_token", &self.creation_token);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFileSystemPolicyInput {
    /// <p>Specifies which EFS file system to retrieve the <code>FileSystemPolicy</code> for.</p>
    pub file_system_id: std::option::Option<std::string::String>,
}
impl DescribeFileSystemPolicyInput {
    /// <p>Specifies which EFS file system to retrieve the <code>FileSystemPolicy</code> for.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeFileSystemPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFileSystemPolicyInput");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBackupPolicyInput {
    /// <p>Specifies which EFS file system to retrieve the <code>BackupPolicy</code> for.</p>
    pub file_system_id: std::option::Option<std::string::String>,
}
impl DescribeBackupPolicyInput {
    /// <p>Specifies which EFS file system to retrieve the <code>BackupPolicy</code> for.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeBackupPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBackupPolicyInput");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountPreferencesInput {
    /// <p>(Optional) You can use <code>NextToken</code> in a subsequent request to fetch the next page of
    /// Amazon Web Services account preferences if the response payload was paginated.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>(Optional) When retrieving account preferences,
    /// you can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response.  
    /// The default value is 100. </p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeAccountPreferencesInput {
    /// <p>(Optional) You can use <code>NextToken</code> in a subsequent request to fetch the next page of
    /// Amazon Web Services account preferences if the response payload was paginated.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>(Optional) When retrieving account preferences,
    /// you can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response.  
    /// The default value is 100. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeAccountPreferencesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountPreferencesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccessPointsInput {
    /// <p>(Optional) When retrieving all access points for a file system,
    /// you can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response.  
    /// The default value is 100. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>
    /// <code>NextToken</code> is present if the response is paginated. You can use <code>NextMarker</code> in the subsequent request to fetch the next page of access point descriptions.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>(Optional) Specifies an EFS access point to describe in the response; mutually exclusive with <code>FileSystemId</code>.</p>
    pub access_point_id: std::option::Option<std::string::String>,
    /// <p>(Optional) If you provide a <code>FileSystemId</code>, EFS returns all access points for that file system; mutually exclusive with <code>AccessPointId</code>.</p>
    pub file_system_id: std::option::Option<std::string::String>,
}
impl DescribeAccessPointsInput {
    /// <p>(Optional) When retrieving all access points for a file system,
    /// you can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response.  
    /// The default value is 100. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>
    /// <code>NextToken</code> is present if the response is paginated. You can use <code>NextMarker</code> in the subsequent request to fetch the next page of access point descriptions.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>(Optional) Specifies an EFS access point to describe in the response; mutually exclusive with <code>FileSystemId</code>.</p>
    pub fn access_point_id(&self) -> std::option::Option<&str> {
        self.access_point_id.as_deref()
    }
    /// <p>(Optional) If you provide a <code>FileSystemId</code>, EFS returns all access points for that file system; mutually exclusive with <code>AccessPointId</code>.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeAccessPointsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccessPointsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("access_point_id", &self.access_point_id);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTagsInput {
    /// <p>The ID of the file system whose tags you want to delete (String).</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>A list of tag keys to delete.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DeleteTagsInput {
    /// <p>The ID of the file system whose tags you want to delete (String).</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>A list of tag keys to delete.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for DeleteTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTagsInput");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMountTargetInput {
    /// <p>The ID of the mount target to delete (String).</p>
    pub mount_target_id: std::option::Option<std::string::String>,
}
impl DeleteMountTargetInput {
    /// <p>The ID of the mount target to delete (String).</p>
    pub fn mount_target_id(&self) -> std::option::Option<&str> {
        self.mount_target_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteMountTargetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMountTargetInput");
        formatter.field("mount_target_id", &self.mount_target_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFileSystemPolicyInput {
    /// <p>Specifies the EFS file system for which to delete the <code>FileSystemPolicy</code>.</p>
    pub file_system_id: std::option::Option<std::string::String>,
}
impl DeleteFileSystemPolicyInput {
    /// <p>Specifies the EFS file system for which to delete the <code>FileSystemPolicy</code>.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteFileSystemPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFileSystemPolicyInput");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFileSystemInput {
    /// <p>The ID of the file system you want to delete.</p>
    pub file_system_id: std::option::Option<std::string::String>,
}
impl DeleteFileSystemInput {
    /// <p>The ID of the file system you want to delete.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteFileSystemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFileSystemInput");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccessPointInput {
    /// <p>The ID of the access point that you want to delete.</p>
    pub access_point_id: std::option::Option<std::string::String>,
}
impl DeleteAccessPointInput {
    /// <p>The ID of the access point that you want to delete.</p>
    pub fn access_point_id(&self) -> std::option::Option<&str> {
        self.access_point_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteAccessPointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccessPointInput");
        formatter.field("access_point_id", &self.access_point_id);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTagsInput {
    /// <p>The ID of the file system whose tags you want to modify (String). This operation modifies
    /// the tags only, not the file system.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>An array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value
    /// pair. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateTagsInput {
    /// <p>The ID of the file system whose tags you want to modify (String). This operation modifies
    /// the tags only, not the file system.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>An array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value
    /// pair. </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTagsInput");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMountTargetInput {
    /// <p>The ID of the file system for which to create the mount target.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The ID of the subnet to add the mount target in. For file systems that use One Zone storage classes, use the subnet
    /// that is associated with the file system's Availability Zone.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>Valid IPv4 address within the address range of the specified subnet.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>Up to five VPC security group IDs, of the form <code>sg-xxxxxxxx</code>. These must be
    /// for the same VPC as subnet specified.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CreateMountTargetInput {
    /// <p>The ID of the file system for which to create the mount target.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>The ID of the subnet to add the mount target in. For file systems that use One Zone storage classes, use the subnet
    /// that is associated with the file system's Availability Zone.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>Valid IPv4 address within the address range of the specified subnet.</p>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>Up to five VPC security group IDs, of the form <code>sg-xxxxxxxx</code>. These must be
    /// for the same VPC as subnet specified.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
}
impl std::fmt::Debug for CreateMountTargetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMountTargetInput");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("security_groups", &self.security_groups);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFileSystemInput {
    /// <p>A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent
    /// creation.</p>
    pub creation_token: std::option::Option<std::string::String>,
    /// <p>The performance mode of the file system. We recommend <code>generalPurpose</code>
    /// performance mode for most file systems. File systems using the <code>maxIO</code> performance
    /// mode can scale to higher levels of aggregate throughput and operations per second with a
    /// tradeoff of slightly higher latencies for most file operations. The performance mode
    /// can't be changed after the file system has been created.</p>
    /// <note>
    /// <p>The <code>maxIO</code> mode is not supported on file systems using One Zone storage classes.</p>
    /// </note>
    pub performance_mode: std::option::Option<crate::model::PerformanceMode>,
    /// <p>A Boolean value that, if true, creates an encrypted file system. When creating an
    /// encrypted file system, you have the option of specifying <a>CreateFileSystemRequest$KmsKeyId</a> for an existing Key Management Service (KMS
    /// customer master key (CMK). If you don't specify a CMK, then the default CMK for
    /// Amazon EFS, <code>/aws/elasticfilesystem</code>, is used to protect the encrypted file system.
    /// </p>
    pub encrypted: std::option::Option<bool>,
    /// <p>The ID of the KMS CMK that you want to use to protect the encrypted file system. This
    /// parameter is only required if you want to use a non-default KMS key. If this parameter is not
    /// specified, the default CMK for Amazon EFS is used. This ID can be in one of the following
    /// formats:</p>
    /// <ul>
    /// <li>
    /// <p>Key ID - A unique identifier of the key, for example
    /// <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
    /// </li>
    /// <li>
    /// <p>ARN - An Amazon Resource Name (ARN) for the key, for example
    /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
    /// </li>
    /// <li>
    /// <p>Key alias - A previously created display name for a key, for example
    /// <code>alias/projectKey1</code>.</p>
    /// </li>
    /// <li>
    /// <p>Key alias ARN - An ARN for a key alias, for example
    /// <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.</p>
    /// </li>
    /// </ul>
    /// <p>If <code>KmsKeyId</code> is specified, the <a>CreateFileSystemRequest$Encrypted</a> parameter must be set to true.</p>
    /// <important>
    /// <p>EFS accepts only symmetric KMS keys. You cannot use asymmetric KMS keys with EFS file systems.</p>
    /// </important>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Specifies the throughput mode for the file system, either <code>bursting</code> or
    /// <code>provisioned</code>. If you set <code>ThroughputMode</code> to
    /// <code>provisioned</code>, you must also set a value for
    /// <code>ProvisionedThroughputInMibps</code>. After you create the file system, you can
    /// decrease your file system's throughput in Provisioned Throughput mode or change between
    /// the throughput modes, as long as it’s been more than 24 hours since the last decrease or
    /// throughput mode change. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying throughput with
    /// provisioned mode</a> in the <i>Amazon EFS User Guide</i>. </p>
    /// <p>Default is <code>bursting</code>.</p>
    pub throughput_mode: std::option::Option<crate::model::ThroughputMode>,
    /// <p>The throughput, measured in MiB/s, that you want to provision for a file system that
    /// you're creating. Valid values are 1-1024. Required if <code>ThroughputMode</code> is set
    /// to <code>provisioned</code>. The upper limit for throughput is 1024 MiB/s. To increase this
    /// limit, contact Amazon Web Services Support. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS quotas that you can increase</a>
    /// in the <i>Amazon EFS User Guide</i>.</p>
    pub provisioned_throughput_in_mibps: std::option::Option<f64>,
    /// <p>Used to create a file system that uses One Zone storage classes. It specifies the Amazon Web Services
    /// Availability Zone in which to create the file system. Use the format <code>us-east-1a</code>
    /// to specify the Availability Zone. For
    /// more information about One Zone storage classes, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p>
    /// <note>
    /// <p>One Zone storage classes are not available in all Availability Zones in Amazon Web Services Regions where
    /// Amazon EFS is available.</p>
    /// </note>
    pub availability_zone_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether automatic backups are enabled on the file system that you are creating.
    /// Set the value to <code>true</code> to enable automatic backups. If you are creating a file
    /// system that uses One Zone storage classes, automatic backups are enabled by default. For more
    /// information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups">Automatic backups</a> in the
    /// <i>Amazon EFS User Guide</i>.</p>
    /// <p>Default is <code>false</code>. However, if you specify an <code>AvailabilityZoneName</code>,
    /// the default is <code>true</code>.</p>
    /// <note>
    /// <p>Backup is not available in all Amazon Web Services Regionswhere Amazon EFS is available.</p>
    /// </note>
    pub backup: std::option::Option<bool>,
    /// <p>Use to create one or more tags associated with the file system. Each
    /// tag is a user-defined key-value pair. Name your file system on creation by including a
    /// <code>"Key":"Name","Value":"{value}"</code> key-value pair. Each key must be unique. For more
    /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
    /// in the <i>Amazon Web Services General Reference Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateFileSystemInput {
    /// <p>A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent
    /// creation.</p>
    pub fn creation_token(&self) -> std::option::Option<&str> {
        self.creation_token.as_deref()
    }
    /// <p>The performance mode of the file system. We recommend <code>generalPurpose</code>
    /// performance mode for most file systems. File systems using the <code>maxIO</code> performance
    /// mode can scale to higher levels of aggregate throughput and operations per second with a
    /// tradeoff of slightly higher latencies for most file operations. The performance mode
    /// can't be changed after the file system has been created.</p>
    /// <note>
    /// <p>The <code>maxIO</code> mode is not supported on file systems using One Zone storage classes.</p>
    /// </note>
    pub fn performance_mode(&self) -> std::option::Option<&crate::model::PerformanceMode> {
        self.performance_mode.as_ref()
    }
    /// <p>A Boolean value that, if true, creates an encrypted file system. When creating an
    /// encrypted file system, you have the option of specifying <a>CreateFileSystemRequest$KmsKeyId</a> for an existing Key Management Service (KMS
    /// customer master key (CMK). If you don't specify a CMK, then the default CMK for
    /// Amazon EFS, <code>/aws/elasticfilesystem</code>, is used to protect the encrypted file system.
    /// </p>
    pub fn encrypted(&self) -> std::option::Option<bool> {
        self.encrypted
    }
    /// <p>The ID of the KMS CMK that you want to use to protect the encrypted file system. This
    /// parameter is only required if you want to use a non-default KMS key. If this parameter is not
    /// specified, the default CMK for Amazon EFS is used. This ID can be in one of the following
    /// formats:</p>
    /// <ul>
    /// <li>
    /// <p>Key ID - A unique identifier of the key, for example
    /// <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
    /// </li>
    /// <li>
    /// <p>ARN - An Amazon Resource Name (ARN) for the key, for example
    /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
    /// </li>
    /// <li>
    /// <p>Key alias - A previously created display name for a key, for example
    /// <code>alias/projectKey1</code>.</p>
    /// </li>
    /// <li>
    /// <p>Key alias ARN - An ARN for a key alias, for example
    /// <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.</p>
    /// </li>
    /// </ul>
    /// <p>If <code>KmsKeyId</code> is specified, the <a>CreateFileSystemRequest$Encrypted</a> parameter must be set to true.</p>
    /// <important>
    /// <p>EFS accepts only symmetric KMS keys. You cannot use asymmetric KMS keys with EFS file systems.</p>
    /// </important>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>Specifies the throughput mode for the file system, either <code>bursting</code> or
    /// <code>provisioned</code>. If you set <code>ThroughputMode</code> to
    /// <code>provisioned</code>, you must also set a value for
    /// <code>ProvisionedThroughputInMibps</code>. After you create the file system, you can
    /// decrease your file system's throughput in Provisioned Throughput mode or change between
    /// the throughput modes, as long as it’s been more than 24 hours since the last decrease or
    /// throughput mode change. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying throughput with
    /// provisioned mode</a> in the <i>Amazon EFS User Guide</i>. </p>
    /// <p>Default is <code>bursting</code>.</p>
    pub fn throughput_mode(&self) -> std::option::Option<&crate::model::ThroughputMode> {
        self.throughput_mode.as_ref()
    }
    /// <p>The throughput, measured in MiB/s, that you want to provision for a file system that
    /// you're creating. Valid values are 1-1024. Required if <code>ThroughputMode</code> is set
    /// to <code>provisioned</code>. The upper limit for throughput is 1024 MiB/s. To increase this
    /// limit, contact Amazon Web Services Support. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS quotas that you can increase</a>
    /// in the <i>Amazon EFS User Guide</i>.</p>
    pub fn provisioned_throughput_in_mibps(&self) -> std::option::Option<f64> {
        self.provisioned_throughput_in_mibps
    }
    /// <p>Used to create a file system that uses One Zone storage classes. It specifies the Amazon Web Services
    /// Availability Zone in which to create the file system. Use the format <code>us-east-1a</code>
    /// to specify the Availability Zone. For
    /// more information about One Zone storage classes, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p>
    /// <note>
    /// <p>One Zone storage classes are not available in all Availability Zones in Amazon Web Services Regions where
    /// Amazon EFS is available.</p>
    /// </note>
    pub fn availability_zone_name(&self) -> std::option::Option<&str> {
        self.availability_zone_name.as_deref()
    }
    /// <p>Specifies whether automatic backups are enabled on the file system that you are creating.
    /// Set the value to <code>true</code> to enable automatic backups. If you are creating a file
    /// system that uses One Zone storage classes, automatic backups are enabled by default. For more
    /// information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups">Automatic backups</a> in the
    /// <i>Amazon EFS User Guide</i>.</p>
    /// <p>Default is <code>false</code>. However, if you specify an <code>AvailabilityZoneName</code>,
    /// the default is <code>true</code>.</p>
    /// <note>
    /// <p>Backup is not available in all Amazon Web Services Regionswhere Amazon EFS is available.</p>
    /// </note>
    pub fn backup(&self) -> std::option::Option<bool> {
        self.backup
    }
    /// <p>Use to create one or more tags associated with the file system. Each
    /// tag is a user-defined key-value pair. Name your file system on creation by including a
    /// <code>"Key":"Name","Value":"{value}"</code> key-value pair. Each key must be unique. For more
    /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
    /// in the <i>Amazon Web Services General Reference Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateFileSystemInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFileSystemInput");
        formatter.field("creation_token", &self.creation_token);
        formatter.field("performance_mode", &self.performance_mode);
        formatter.field("encrypted", &self.encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("throughput_mode", &self.throughput_mode);
        formatter.field(
            "provisioned_throughput_in_mibps",
            &self.provisioned_throughput_in_mibps,
        );
        formatter.field("availability_zone_name", &self.availability_zone_name);
        formatter.field("backup", &self.backup);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccessPointInput {
    /// <p>A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent
    /// creation.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>Creates tags associated with the access point. Each tag is a key-value pair, each key must be unique. For more
    /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
    /// in the <i>Amazon Web Services General Reference Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The ID of the EFS file system that the access point provides access to.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The operating system user and
    /// group applied to all file system requests made using the access point.</p>
    pub posix_user: std::option::Option<crate::model::PosixUser>,
    /// <p>Specifies the directory on the Amazon EFS file system that the access point exposes as
    /// the root directory of your file system to NFS clients using the access point.
    /// The clients using the access point can only access the root directory and below.
    /// If the <code>RootDirectory</code> > <code>Path</code> specified does not exist,
    /// EFS creates it and applies the <code>CreationInfo</code> settings when a client connects to an access point.
    /// When specifying a <code>RootDirectory</code>, you need to provide the <code>Path</code>, and the <code>CreationInfo</code>.</p>
    /// <p>Amazon EFS creates a root directory only if you have provided the  CreationInfo: OwnUid, OwnGID, and permissions for the directory.
    /// If  you do not provide this information, Amazon EFS does not create the root directory. If the root directory does not exist, attempts to mount
    /// using the access point will fail.</p>
    pub root_directory: std::option::Option<crate::model::RootDirectory>,
}
impl CreateAccessPointInput {
    /// <p>A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent
    /// creation.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>Creates tags associated with the access point. Each tag is a key-value pair, each key must be unique. For more
    /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
    /// in the <i>Amazon Web Services General Reference Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The ID of the EFS file system that the access point provides access to.</p>
    pub fn file_system_id(&self) -> std::option::Option<&str> {
        self.file_system_id.as_deref()
    }
    /// <p>The operating system user and
    /// group applied to all file system requests made using the access point.</p>
    pub fn posix_user(&self) -> std::option::Option<&crate::model::PosixUser> {
        self.posix_user.as_ref()
    }
    /// <p>Specifies the directory on the Amazon EFS file system that the access point exposes as
    /// the root directory of your file system to NFS clients using the access point.
    /// The clients using the access point can only access the root directory and below.
    /// If the <code>RootDirectory</code> > <code>Path</code> specified does not exist,
    /// EFS creates it and applies the <code>CreationInfo</code> settings when a client connects to an access point.
    /// When specifying a <code>RootDirectory</code>, you need to provide the <code>Path</code>, and the <code>CreationInfo</code>.</p>
    /// <p>Amazon EFS creates a root directory only if you have provided the  CreationInfo: OwnUid, OwnGID, and permissions for the directory.
    /// If  you do not provide this information, Amazon EFS does not create the root directory. If the root directory does not exist, attempts to mount
    /// using the access point will fail.</p>
    pub fn root_directory(&self) -> std::option::Option<&crate::model::RootDirectory> {
        self.root_directory.as_ref()
    }
}
impl std::fmt::Debug for CreateAccessPointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccessPointInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("posix_user", &self.posix_user);
        formatter.field("root_directory", &self.root_directory);
        formatter.finish()
    }
}
