// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A tag is a key-value pair. Allowed characters are letters, white space, and numbers that
/// can be represented in UTF-8, and the following characters:<code> + - = . _ : /</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The tag key (String). The key can't start with <code>aws:</code>.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag key.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tag key (String). The key can't start with <code>aws:</code>.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag key (String). The key can't start with <code>aws:</code>.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag key.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag key.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ThroughputMode {
    #[allow(missing_docs)] // documentation missing in model
    Bursting,
    #[allow(missing_docs)] // documentation missing in model
    Provisioned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ThroughputMode {
    fn from(s: &str) -> Self {
        match s {
            "bursting" => ThroughputMode::Bursting,
            "provisioned" => ThroughputMode::Provisioned,
            other => ThroughputMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ThroughputMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ThroughputMode::from(s))
    }
}
impl ThroughputMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ThroughputMode::Bursting => "bursting",
            ThroughputMode::Provisioned => "provisioned",
            ThroughputMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["bursting", "provisioned"]
    }
}
impl AsRef<str> for ThroughputMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PerformanceMode {
    #[allow(missing_docs)] // documentation missing in model
    GeneralPurpose,
    #[allow(missing_docs)] // documentation missing in model
    MaxIo,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PerformanceMode {
    fn from(s: &str) -> Self {
        match s {
            "generalPurpose" => PerformanceMode::GeneralPurpose,
            "maxIO" => PerformanceMode::MaxIo,
            other => PerformanceMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PerformanceMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PerformanceMode::from(s))
    }
}
impl PerformanceMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PerformanceMode::GeneralPurpose => "generalPurpose",
            PerformanceMode::MaxIo => "maxIO",
            PerformanceMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["generalPurpose", "maxIO"]
    }
}
impl AsRef<str> for PerformanceMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The latest known metered size (in bytes) of data stored in the file system, in its
/// <code>Value</code> field, and the time at which that size was determined in its
/// <code>Timestamp</code> field. The value doesn't represent the size of a consistent
/// snapshot of the file system, but it is eventually consistent when there are no writes to the
/// file system. That is, the value represents the actual size only if the file system is not
/// modified for a period longer than a couple of hours. Otherwise, the value is not necessarily
/// the exact size the file system was at any instant in time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileSystemSize {
    /// <p>The latest known metered size (in bytes) of data stored in the file system.</p>
    pub value: i64,
    /// <p>The time at which the size of data, returned in the <code>Value</code> field, was
    /// determined. The value is the integer number of seconds since 1970-01-01T00:00:00Z.</p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The latest known metered size (in bytes) of data stored in the Infrequent Access
    /// storage class.</p>
    pub value_in_ia: std::option::Option<i64>,
    /// <p>The latest known metered size (in bytes) of data stored in the Standard storage
    /// class.</p>
    pub value_in_standard: std::option::Option<i64>,
}
impl std::fmt::Debug for FileSystemSize {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileSystemSize");
        formatter.field("value", &self.value);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("value_in_ia", &self.value_in_ia);
        formatter.field("value_in_standard", &self.value_in_standard);
        formatter.finish()
    }
}
/// See [`FileSystemSize`](crate::model::FileSystemSize)
pub mod file_system_size {
    /// A builder for [`FileSystemSize`](crate::model::FileSystemSize)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<i64>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) value_in_ia: std::option::Option<i64>,
        pub(crate) value_in_standard: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The latest known metered size (in bytes) of data stored in the file system.</p>
        pub fn value(mut self, input: i64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The latest known metered size (in bytes) of data stored in the file system.</p>
        pub fn set_value(mut self, input: std::option::Option<i64>) -> Self {
            self.value = input;
            self
        }
        /// <p>The time at which the size of data, returned in the <code>Value</code> field, was
        /// determined. The value is the integer number of seconds since 1970-01-01T00:00:00Z.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The time at which the size of data, returned in the <code>Value</code> field, was
        /// determined. The value is the integer number of seconds since 1970-01-01T00:00:00Z.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The latest known metered size (in bytes) of data stored in the Infrequent Access
        /// storage class.</p>
        pub fn value_in_ia(mut self, input: i64) -> Self {
            self.value_in_ia = Some(input);
            self
        }
        /// <p>The latest known metered size (in bytes) of data stored in the Infrequent Access
        /// storage class.</p>
        pub fn set_value_in_ia(mut self, input: std::option::Option<i64>) -> Self {
            self.value_in_ia = input;
            self
        }
        /// <p>The latest known metered size (in bytes) of data stored in the Standard storage
        /// class.</p>
        pub fn value_in_standard(mut self, input: i64) -> Self {
            self.value_in_standard = Some(input);
            self
        }
        /// <p>The latest known metered size (in bytes) of data stored in the Standard storage
        /// class.</p>
        pub fn set_value_in_standard(mut self, input: std::option::Option<i64>) -> Self {
            self.value_in_standard = input;
            self
        }
        /// Consumes the builder and constructs a [`FileSystemSize`](crate::model::FileSystemSize)
        pub fn build(self) -> crate::model::FileSystemSize {
            crate::model::FileSystemSize {
                value: self.value.unwrap_or_default(),
                timestamp: self.timestamp,
                value_in_ia: self.value_in_ia,
                value_in_standard: self.value_in_standard,
            }
        }
    }
}
impl FileSystemSize {
    /// Creates a new builder-style object to manufacture [`FileSystemSize`](crate::model::FileSystemSize)
    pub fn builder() -> crate::model::file_system_size::Builder {
        crate::model::file_system_size::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LifeCycleState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LifeCycleState {
    fn from(s: &str) -> Self {
        match s {
            "available" => LifeCycleState::Available,
            "creating" => LifeCycleState::Creating,
            "deleted" => LifeCycleState::Deleted,
            "deleting" => LifeCycleState::Deleting,
            "error" => LifeCycleState::Error,
            "updating" => LifeCycleState::Updating,
            other => LifeCycleState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LifeCycleState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LifeCycleState::from(s))
    }
}
impl LifeCycleState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LifeCycleState::Available => "available",
            LifeCycleState::Creating => "creating",
            LifeCycleState::Deleted => "deleted",
            LifeCycleState::Deleting => "deleting",
            LifeCycleState::Error => "error",
            LifeCycleState::Updating => "updating",
            LifeCycleState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "available",
            "creating",
            "deleted",
            "deleting",
            "error",
            "updating",
        ]
    }
}
impl AsRef<str> for LifeCycleState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a policy used by EFS lifecycle management and EFS intelligent tiering that specifies when to transition
/// files into and out of the file system's Infrequent Access (IA) storage class. For more information, see
/// <a href="https://docs.aws.amazon.com/efs/latest/ug/lifecycle-management-efs.html">EFS Intelligent‐Tiering and EFS Lifecycle Management</a>.</p>
/// <note>
/// <p>When using the <code>put-lifecycle-configuration</code> CLI command or the <code>PutLifecycleConfiguration</code> API action,
/// Amazon EFS requires that each <code>LifecyclePolicy</code>
/// object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as
/// an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code>,
/// <code>TransitionToPrimaryStorageClass</code>. For more information, see the request examples in <a>PutLifecycleConfiguration</a>.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecyclePolicy {
    /// <p>
    /// Describes the period of time that a file is not accessed, after which it transitions to IA storage. Metadata
    /// operations such as listing the contents of a directory don't count as file access
    /// events.</p>
    pub transition_to_ia: std::option::Option<crate::model::TransitionToIaRules>,
    /// <p>Describes when to transition a file from IA storage to primary storage. Metadata
    /// operations such as listing the contents of a directory don't count as file access
    /// events.</p>
    pub transition_to_primary_storage_class:
        std::option::Option<crate::model::TransitionToPrimaryStorageClassRules>,
}
impl std::fmt::Debug for LifecyclePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecyclePolicy");
        formatter.field("transition_to_ia", &self.transition_to_ia);
        formatter.field(
            "transition_to_primary_storage_class",
            &self.transition_to_primary_storage_class,
        );
        formatter.finish()
    }
}
/// See [`LifecyclePolicy`](crate::model::LifecyclePolicy)
pub mod lifecycle_policy {
    /// A builder for [`LifecyclePolicy`](crate::model::LifecyclePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transition_to_ia: std::option::Option<crate::model::TransitionToIaRules>,
        pub(crate) transition_to_primary_storage_class:
            std::option::Option<crate::model::TransitionToPrimaryStorageClassRules>,
    }
    impl Builder {
        /// <p>
        /// Describes the period of time that a file is not accessed, after which it transitions to IA storage. Metadata
        /// operations such as listing the contents of a directory don't count as file access
        /// events.</p>
        pub fn transition_to_ia(mut self, input: crate::model::TransitionToIaRules) -> Self {
            self.transition_to_ia = Some(input);
            self
        }
        /// <p>
        /// Describes the period of time that a file is not accessed, after which it transitions to IA storage. Metadata
        /// operations such as listing the contents of a directory don't count as file access
        /// events.</p>
        pub fn set_transition_to_ia(
            mut self,
            input: std::option::Option<crate::model::TransitionToIaRules>,
        ) -> Self {
            self.transition_to_ia = input;
            self
        }
        /// <p>Describes when to transition a file from IA storage to primary storage. Metadata
        /// operations such as listing the contents of a directory don't count as file access
        /// events.</p>
        pub fn transition_to_primary_storage_class(
            mut self,
            input: crate::model::TransitionToPrimaryStorageClassRules,
        ) -> Self {
            self.transition_to_primary_storage_class = Some(input);
            self
        }
        /// <p>Describes when to transition a file from IA storage to primary storage. Metadata
        /// operations such as listing the contents of a directory don't count as file access
        /// events.</p>
        pub fn set_transition_to_primary_storage_class(
            mut self,
            input: std::option::Option<crate::model::TransitionToPrimaryStorageClassRules>,
        ) -> Self {
            self.transition_to_primary_storage_class = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecyclePolicy`](crate::model::LifecyclePolicy)
        pub fn build(self) -> crate::model::LifecyclePolicy {
            crate::model::LifecyclePolicy {
                transition_to_ia: self.transition_to_ia,
                transition_to_primary_storage_class: self.transition_to_primary_storage_class,
            }
        }
    }
}
impl LifecyclePolicy {
    /// Creates a new builder-style object to manufacture [`LifecyclePolicy`](crate::model::LifecyclePolicy)
    pub fn builder() -> crate::model::lifecycle_policy::Builder {
        crate::model::lifecycle_policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransitionToPrimaryStorageClassRules {
    #[allow(missing_docs)] // documentation missing in model
    After1Access,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransitionToPrimaryStorageClassRules {
    fn from(s: &str) -> Self {
        match s {
            "AFTER_1_ACCESS" => TransitionToPrimaryStorageClassRules::After1Access,
            other => TransitionToPrimaryStorageClassRules::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransitionToPrimaryStorageClassRules {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransitionToPrimaryStorageClassRules::from(s))
    }
}
impl TransitionToPrimaryStorageClassRules {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransitionToPrimaryStorageClassRules::After1Access => "AFTER_1_ACCESS",
            TransitionToPrimaryStorageClassRules::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AFTER_1_ACCESS"]
    }
}
impl AsRef<str> for TransitionToPrimaryStorageClassRules {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransitionToIaRules {
    #[allow(missing_docs)] // documentation missing in model
    After14Days,
    #[allow(missing_docs)] // documentation missing in model
    After30Days,
    #[allow(missing_docs)] // documentation missing in model
    After60Days,
    #[allow(missing_docs)] // documentation missing in model
    After7Days,
    #[allow(missing_docs)] // documentation missing in model
    After90Days,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransitionToIaRules {
    fn from(s: &str) -> Self {
        match s {
            "AFTER_14_DAYS" => TransitionToIaRules::After14Days,
            "AFTER_30_DAYS" => TransitionToIaRules::After30Days,
            "AFTER_60_DAYS" => TransitionToIaRules::After60Days,
            "AFTER_7_DAYS" => TransitionToIaRules::After7Days,
            "AFTER_90_DAYS" => TransitionToIaRules::After90Days,
            other => TransitionToIaRules::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransitionToIaRules {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransitionToIaRules::from(s))
    }
}
impl TransitionToIaRules {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransitionToIaRules::After14Days => "AFTER_14_DAYS",
            TransitionToIaRules::After30Days => "AFTER_30_DAYS",
            TransitionToIaRules::After60Days => "AFTER_60_DAYS",
            TransitionToIaRules::After7Days => "AFTER_7_DAYS",
            TransitionToIaRules::After90Days => "AFTER_90_DAYS",
            TransitionToIaRules::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AFTER_14_DAYS",
            "AFTER_30_DAYS",
            "AFTER_60_DAYS",
            "AFTER_7_DAYS",
            "AFTER_90_DAYS",
        ]
    }
}
impl AsRef<str> for TransitionToIaRules {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The backup policy for the file system used to create automatic daily backups. If status has a value of
/// <code>ENABLED</code>, the file system is being automatically backed up. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups">Automatic backups</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupPolicy {
    /// <p>Describes the status of the file system's backup policy.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>ENABLED</code>
    /// </b> - EFS is automatically backing up the file system.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>ENABLING</code>
    /// </b> - EFS is turning on automatic backups for the file system.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DISABLED</code>
    /// </b> - automatic back ups are turned off for the file system.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DISABLING</code>
    /// </b> - EFS is turning off automatic backups for the file system.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::Status>,
}
impl std::fmt::Debug for BackupPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupPolicy");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`BackupPolicy`](crate::model::BackupPolicy)
pub mod backup_policy {
    /// A builder for [`BackupPolicy`](crate::model::BackupPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// <p>Describes the status of the file system's backup policy.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ENABLED</code>
        /// </b> - EFS is automatically backing up the file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ENABLING</code>
        /// </b> - EFS is turning on automatic backups for the file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DISABLED</code>
        /// </b> - automatic back ups are turned off for the file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DISABLING</code>
        /// </b> - EFS is turning off automatic backups for the file system.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Describes the status of the file system's backup policy.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ENABLED</code>
        /// </b> - EFS is automatically backing up the file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ENABLING</code>
        /// </b> - EFS is turning on automatic backups for the file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DISABLED</code>
        /// </b> - automatic back ups are turned off for the file system.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DISABLING</code>
        /// </b> - EFS is turning off automatic backups for the file system.</p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupPolicy`](crate::model::BackupPolicy)
        pub fn build(self) -> crate::model::BackupPolicy {
            crate::model::BackupPolicy {
                status: self.status,
            }
        }
    }
}
impl BackupPolicy {
    /// Creates a new builder-style object to manufacture [`BackupPolicy`](crate::model::BackupPolicy)
    pub fn builder() -> crate::model::backup_policy::Builder {
        crate::model::backup_policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Status {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Disabling,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Status {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => Status::Disabled,
            "DISABLING" => Status::Disabling,
            "ENABLED" => Status::Enabled,
            "ENABLING" => Status::Enabling,
            other => Status::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Status {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Status::from(s))
    }
}
impl Status {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Status::Disabled => "DISABLED",
            Status::Disabling => "DISABLING",
            Status::Enabled => "ENABLED",
            Status::Enabling => "ENABLING",
            Status::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "DISABLING", "ENABLED", "ENABLING"]
    }
}
impl AsRef<str> for Status {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the resource type and its ID preference for the user's Amazon Web Services account, in the current Amazon Web Services Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceIdPreference {
    /// <p>Identifies the EFS resource ID preference, either <code>LONG_ID</code> (17 characters) or <code>SHORT_ID</code> (8 characters).</p>
    pub resource_id_type: std::option::Option<crate::model::ResourceIdType>,
    /// <p>Identifies the Amazon EFS resources to which the ID preference setting applies, <code>FILE_SYSTEM</code> and <code>MOUNT_TARGET</code>.</p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
}
impl std::fmt::Debug for ResourceIdPreference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceIdPreference");
        formatter.field("resource_id_type", &self.resource_id_type);
        formatter.field("resources", &self.resources);
        formatter.finish()
    }
}
/// See [`ResourceIdPreference`](crate::model::ResourceIdPreference)
pub mod resource_id_preference {
    /// A builder for [`ResourceIdPreference`](crate::model::ResourceIdPreference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id_type: std::option::Option<crate::model::ResourceIdType>,
        pub(crate) resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    }
    impl Builder {
        /// <p>Identifies the EFS resource ID preference, either <code>LONG_ID</code> (17 characters) or <code>SHORT_ID</code> (8 characters).</p>
        pub fn resource_id_type(mut self, input: crate::model::ResourceIdType) -> Self {
            self.resource_id_type = Some(input);
            self
        }
        /// <p>Identifies the EFS resource ID preference, either <code>LONG_ID</code> (17 characters) or <code>SHORT_ID</code> (8 characters).</p>
        pub fn set_resource_id_type(
            mut self,
            input: std::option::Option<crate::model::ResourceIdType>,
        ) -> Self {
            self.resource_id_type = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>Identifies the Amazon EFS resources to which the ID preference setting applies, <code>FILE_SYSTEM</code> and <code>MOUNT_TARGET</code>.</p>
        pub fn resources(mut self, input: impl Into<crate::model::Resource>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>Identifies the Amazon EFS resources to which the ID preference setting applies, <code>FILE_SYSTEM</code> and <code>MOUNT_TARGET</code>.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceIdPreference`](crate::model::ResourceIdPreference)
        pub fn build(self) -> crate::model::ResourceIdPreference {
            crate::model::ResourceIdPreference {
                resource_id_type: self.resource_id_type,
                resources: self.resources,
            }
        }
    }
}
impl ResourceIdPreference {
    /// Creates a new builder-style object to manufacture [`ResourceIdPreference`](crate::model::ResourceIdPreference)
    pub fn builder() -> crate::model::resource_id_preference::Builder {
        crate::model::resource_id_preference::Builder::default()
    }
}

/// An EFS resource, for example a file system or a mount target.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Resource {
    #[allow(missing_docs)] // documentation missing in model
    FileSystem,
    #[allow(missing_docs)] // documentation missing in model
    MountTarget,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Resource {
    fn from(s: &str) -> Self {
        match s {
            "FILE_SYSTEM" => Resource::FileSystem,
            "MOUNT_TARGET" => Resource::MountTarget,
            other => Resource::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Resource {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Resource::from(s))
    }
}
impl Resource {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Resource::FileSystem => "FILE_SYSTEM",
            Resource::MountTarget => "MOUNT_TARGET",
            Resource::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FILE_SYSTEM", "MOUNT_TARGET"]
    }
}
impl AsRef<str> for Resource {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// A preference indicating a choice to use 63bit/32bit IDs for all applicable resources.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceIdType {
    #[allow(missing_docs)] // documentation missing in model
    LongId,
    #[allow(missing_docs)] // documentation missing in model
    ShortId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceIdType {
    fn from(s: &str) -> Self {
        match s {
            "LONG_ID" => ResourceIdType::LongId,
            "SHORT_ID" => ResourceIdType::ShortId,
            other => ResourceIdType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceIdType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceIdType::from(s))
    }
}
impl ResourceIdType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceIdType::LongId => "LONG_ID",
            ResourceIdType::ShortId => "SHORT_ID",
            ResourceIdType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LONG_ID", "SHORT_ID"]
    }
}
impl AsRef<str> for ResourceIdType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides a description of a mount target.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MountTargetDescription {
    /// <p>Amazon Web Services account ID that owns the resource.</p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>System-assigned mount target ID.</p>
    pub mount_target_id: std::option::Option<std::string::String>,
    /// <p>The ID of the file system for which the mount target is intended.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The ID of the mount target's subnet.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>Lifecycle state of the mount target.</p>
    pub life_cycle_state: std::option::Option<crate::model::LifeCycleState>,
    /// <p>Address at which the file system can be mounted by using the mount target.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The ID of the network interface that Amazon EFS created when it created the mount
    /// target.</p>
    pub network_interface_id: std::option::Option<std::string::String>,
    /// <p>The unique and consistent identifier of the Availability Zone that the mount target resides in.
    /// For example, <code>use1-az1</code> is an AZ ID for the us-east-1 Region and it has the same location in every Amazon Web Services account.</p>
    pub availability_zone_id: std::option::Option<std::string::String>,
    /// <p>The name of the Availability Zone in which the mount target is located. Availability Zones are
    /// independently mapped to names for each Amazon Web Services account. For example, the Availability Zone
    /// <code>us-east-1a</code> for your Amazon Web Services account might not be the same location as <code>us-east-1a</code> for another Amazon Web Services account.</p>
    pub availability_zone_name: std::option::Option<std::string::String>,
    /// <p>The virtual private cloud (VPC) ID that the mount target is configured in.</p>
    pub vpc_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MountTargetDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MountTargetDescription");
        formatter.field("owner_id", &self.owner_id);
        formatter.field("mount_target_id", &self.mount_target_id);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("life_cycle_state", &self.life_cycle_state);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("network_interface_id", &self.network_interface_id);
        formatter.field("availability_zone_id", &self.availability_zone_id);
        formatter.field("availability_zone_name", &self.availability_zone_name);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.finish()
    }
}
/// See [`MountTargetDescription`](crate::model::MountTargetDescription)
pub mod mount_target_description {
    /// A builder for [`MountTargetDescription`](crate::model::MountTargetDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) mount_target_id: std::option::Option<std::string::String>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) life_cycle_state: std::option::Option<crate::model::LifeCycleState>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) availability_zone_id: std::option::Option<std::string::String>,
        pub(crate) availability_zone_name: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Web Services account ID that owns the resource.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>Amazon Web Services account ID that owns the resource.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>System-assigned mount target ID.</p>
        pub fn mount_target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.mount_target_id = Some(input.into());
            self
        }
        /// <p>System-assigned mount target ID.</p>
        pub fn set_mount_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mount_target_id = input;
            self
        }
        /// <p>The ID of the file system for which the mount target is intended.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system for which the mount target is intended.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The ID of the mount target's subnet.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the mount target's subnet.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>Lifecycle state of the mount target.</p>
        pub fn life_cycle_state(mut self, input: crate::model::LifeCycleState) -> Self {
            self.life_cycle_state = Some(input);
            self
        }
        /// <p>Lifecycle state of the mount target.</p>
        pub fn set_life_cycle_state(
            mut self,
            input: std::option::Option<crate::model::LifeCycleState>,
        ) -> Self {
            self.life_cycle_state = input;
            self
        }
        /// <p>Address at which the file system can be mounted by using the mount target.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>Address at which the file system can be mounted by using the mount target.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The ID of the network interface that Amazon EFS created when it created the mount
        /// target.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the network interface that Amazon EFS created when it created the mount
        /// target.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>The unique and consistent identifier of the Availability Zone that the mount target resides in.
        /// For example, <code>use1-az1</code> is an AZ ID for the us-east-1 Region and it has the same location in every Amazon Web Services account.</p>
        pub fn availability_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_id = Some(input.into());
            self
        }
        /// <p>The unique and consistent identifier of the Availability Zone that the mount target resides in.
        /// For example, <code>use1-az1</code> is an AZ ID for the us-east-1 Region and it has the same location in every Amazon Web Services account.</p>
        pub fn set_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_id = input;
            self
        }
        /// <p>The name of the Availability Zone in which the mount target is located. Availability Zones are
        /// independently mapped to names for each Amazon Web Services account. For example, the Availability Zone
        /// <code>us-east-1a</code> for your Amazon Web Services account might not be the same location as <code>us-east-1a</code> for another Amazon Web Services account.</p>
        pub fn availability_zone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_name = Some(input.into());
            self
        }
        /// <p>The name of the Availability Zone in which the mount target is located. Availability Zones are
        /// independently mapped to names for each Amazon Web Services account. For example, the Availability Zone
        /// <code>us-east-1a</code> for your Amazon Web Services account might not be the same location as <code>us-east-1a</code> for another Amazon Web Services account.</p>
        pub fn set_availability_zone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_name = input;
            self
        }
        /// <p>The virtual private cloud (VPC) ID that the mount target is configured in.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The virtual private cloud (VPC) ID that the mount target is configured in.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MountTargetDescription`](crate::model::MountTargetDescription)
        pub fn build(self) -> crate::model::MountTargetDescription {
            crate::model::MountTargetDescription {
                owner_id: self.owner_id,
                mount_target_id: self.mount_target_id,
                file_system_id: self.file_system_id,
                subnet_id: self.subnet_id,
                life_cycle_state: self.life_cycle_state,
                ip_address: self.ip_address,
                network_interface_id: self.network_interface_id,
                availability_zone_id: self.availability_zone_id,
                availability_zone_name: self.availability_zone_name,
                vpc_id: self.vpc_id,
            }
        }
    }
}
impl MountTargetDescription {
    /// Creates a new builder-style object to manufacture [`MountTargetDescription`](crate::model::MountTargetDescription)
    pub fn builder() -> crate::model::mount_target_description::Builder {
        crate::model::mount_target_description::Builder::default()
    }
}

/// <p>A description of the file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileSystemDescription {
    /// <p>The Amazon Web Services account that created the file system. If the file system was created by an IAM
    /// user, the parent account to which the user belongs is the owner.</p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>The opaque string specified in the request.</p>
    pub creation_token: std::option::Option<std::string::String>,
    /// <p>The ID of the file system, assigned by Amazon EFS.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the EFS file system, in the format
    /// <code>arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i>
    /// </code>.
    /// Example with sample data: <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567</code>
    /// </p>
    pub file_system_arn: std::option::Option<std::string::String>,
    /// <p>The time that the file system was created, in seconds (since
    /// 1970-01-01T00:00:00Z).</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The lifecycle phase of the file system.</p>
    pub life_cycle_state: std::option::Option<crate::model::LifeCycleState>,
    /// <p>You can add tags to a file system, including a <code>Name</code> tag. For more
    /// information, see <a>CreateFileSystem</a>. If the file system has a <code>Name</code> tag, Amazon EFS returns
    /// the value in this field. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current number of mount targets that the file system has. For more information, see <a>CreateMountTarget</a>.</p>
    pub number_of_mount_targets: i32,
    /// <p>The latest known metered size (in bytes) of data stored in the file system, in its
    /// <code>Value</code> field, and the time at which that size was determined in its
    /// <code>Timestamp</code> field. The <code>Timestamp</code> value is the integer number of
    /// seconds since 1970-01-01T00:00:00Z. The <code>SizeInBytes</code> value doesn't represent
    /// the size of a consistent snapshot of the file system, but it is eventually consistent when
    /// there are no writes to the file system. That is, <code>SizeInBytes</code> represents actual
    /// size only if the file system is not modified for a period longer than a couple of hours.
    /// Otherwise, the value is not the exact size that the file system was at any point in time.
    /// </p>
    pub size_in_bytes: std::option::Option<crate::model::FileSystemSize>,
    /// <p>The performance mode of the file system.</p>
    pub performance_mode: std::option::Option<crate::model::PerformanceMode>,
    /// <p>A Boolean value that, if true, indicates that the file system is encrypted.</p>
    pub encrypted: std::option::Option<bool>,
    /// <p>The ID of an Key Management Service customer master key (CMK) that was
    /// used to protect the encrypted file system.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Displays the file system's throughput mode. For more information, see
    /// <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a>
    /// in the <i>Amazon EFS User Guide</i>.
    /// </p>
    pub throughput_mode: std::option::Option<crate::model::ThroughputMode>,
    /// <p>The amount of provisioned throughput, measured in MiB/s, for the file system. Valid for
    /// file systems using <code>ThroughputMode</code> set to <code>provisioned</code>.</p>
    pub provisioned_throughput_in_mibps: std::option::Option<f64>,
    /// <p>Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid only
    /// for file systems using One Zone storage classes. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a>
    /// in the <i>Amazon EFS User Guide</i>.</p>
    pub availability_zone_name: std::option::Option<std::string::String>,
    /// <p>The unique and consistent identifier of the Availability Zone in which the file system's
    /// One Zone storage classes exist. For example, <code>use1-az1</code> is an Availability Zone ID
    /// for the us-east-1 Amazon Web Services Region, and it has the same location in every Amazon Web Services account.</p>
    pub availability_zone_id: std::option::Option<std::string::String>,
    /// <p>The tags associated with the file system, presented as an array of <code>Tag</code>
    /// objects.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for FileSystemDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileSystemDescription");
        formatter.field("owner_id", &self.owner_id);
        formatter.field("creation_token", &self.creation_token);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("file_system_arn", &self.file_system_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("life_cycle_state", &self.life_cycle_state);
        formatter.field("name", &self.name);
        formatter.field("number_of_mount_targets", &self.number_of_mount_targets);
        formatter.field("size_in_bytes", &self.size_in_bytes);
        formatter.field("performance_mode", &self.performance_mode);
        formatter.field("encrypted", &self.encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("throughput_mode", &self.throughput_mode);
        formatter.field(
            "provisioned_throughput_in_mibps",
            &self.provisioned_throughput_in_mibps,
        );
        formatter.field("availability_zone_name", &self.availability_zone_name);
        formatter.field("availability_zone_id", &self.availability_zone_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`FileSystemDescription`](crate::model::FileSystemDescription)
pub mod file_system_description {
    /// A builder for [`FileSystemDescription`](crate::model::FileSystemDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) creation_token: std::option::Option<std::string::String>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) file_system_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) life_cycle_state: std::option::Option<crate::model::LifeCycleState>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) number_of_mount_targets: std::option::Option<i32>,
        pub(crate) size_in_bytes: std::option::Option<crate::model::FileSystemSize>,
        pub(crate) performance_mode: std::option::Option<crate::model::PerformanceMode>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) throughput_mode: std::option::Option<crate::model::ThroughputMode>,
        pub(crate) provisioned_throughput_in_mibps: std::option::Option<f64>,
        pub(crate) availability_zone_name: std::option::Option<std::string::String>,
        pub(crate) availability_zone_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account that created the file system. If the file system was created by an IAM
        /// user, the parent account to which the user belongs is the owner.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account that created the file system. If the file system was created by an IAM
        /// user, the parent account to which the user belongs is the owner.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>The opaque string specified in the request.</p>
        pub fn creation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_token = Some(input.into());
            self
        }
        /// <p>The opaque string specified in the request.</p>
        pub fn set_creation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_token = input;
            self
        }
        /// <p>The ID of the file system, assigned by Amazon EFS.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the file system, assigned by Amazon EFS.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the EFS file system, in the format
        /// <code>arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i>
        /// </code>.
        /// Example with sample data: <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567</code>
        /// </p>
        pub fn file_system_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the EFS file system, in the format
        /// <code>arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i>
        /// </code>.
        /// Example with sample data: <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567</code>
        /// </p>
        pub fn set_file_system_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_arn = input;
            self
        }
        /// <p>The time that the file system was created, in seconds (since
        /// 1970-01-01T00:00:00Z).</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the file system was created, in seconds (since
        /// 1970-01-01T00:00:00Z).</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The lifecycle phase of the file system.</p>
        pub fn life_cycle_state(mut self, input: crate::model::LifeCycleState) -> Self {
            self.life_cycle_state = Some(input);
            self
        }
        /// <p>The lifecycle phase of the file system.</p>
        pub fn set_life_cycle_state(
            mut self,
            input: std::option::Option<crate::model::LifeCycleState>,
        ) -> Self {
            self.life_cycle_state = input;
            self
        }
        /// <p>You can add tags to a file system, including a <code>Name</code> tag. For more
        /// information, see <a>CreateFileSystem</a>. If the file system has a <code>Name</code> tag, Amazon EFS returns
        /// the value in this field. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>You can add tags to a file system, including a <code>Name</code> tag. For more
        /// information, see <a>CreateFileSystem</a>. If the file system has a <code>Name</code> tag, Amazon EFS returns
        /// the value in this field. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current number of mount targets that the file system has. For more information, see <a>CreateMountTarget</a>.</p>
        pub fn number_of_mount_targets(mut self, input: i32) -> Self {
            self.number_of_mount_targets = Some(input);
            self
        }
        /// <p>The current number of mount targets that the file system has. For more information, see <a>CreateMountTarget</a>.</p>
        pub fn set_number_of_mount_targets(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_mount_targets = input;
            self
        }
        /// <p>The latest known metered size (in bytes) of data stored in the file system, in its
        /// <code>Value</code> field, and the time at which that size was determined in its
        /// <code>Timestamp</code> field. The <code>Timestamp</code> value is the integer number of
        /// seconds since 1970-01-01T00:00:00Z. The <code>SizeInBytes</code> value doesn't represent
        /// the size of a consistent snapshot of the file system, but it is eventually consistent when
        /// there are no writes to the file system. That is, <code>SizeInBytes</code> represents actual
        /// size only if the file system is not modified for a period longer than a couple of hours.
        /// Otherwise, the value is not the exact size that the file system was at any point in time.
        /// </p>
        pub fn size_in_bytes(mut self, input: crate::model::FileSystemSize) -> Self {
            self.size_in_bytes = Some(input);
            self
        }
        /// <p>The latest known metered size (in bytes) of data stored in the file system, in its
        /// <code>Value</code> field, and the time at which that size was determined in its
        /// <code>Timestamp</code> field. The <code>Timestamp</code> value is the integer number of
        /// seconds since 1970-01-01T00:00:00Z. The <code>SizeInBytes</code> value doesn't represent
        /// the size of a consistent snapshot of the file system, but it is eventually consistent when
        /// there are no writes to the file system. That is, <code>SizeInBytes</code> represents actual
        /// size only if the file system is not modified for a period longer than a couple of hours.
        /// Otherwise, the value is not the exact size that the file system was at any point in time.
        /// </p>
        pub fn set_size_in_bytes(
            mut self,
            input: std::option::Option<crate::model::FileSystemSize>,
        ) -> Self {
            self.size_in_bytes = input;
            self
        }
        /// <p>The performance mode of the file system.</p>
        pub fn performance_mode(mut self, input: crate::model::PerformanceMode) -> Self {
            self.performance_mode = Some(input);
            self
        }
        /// <p>The performance mode of the file system.</p>
        pub fn set_performance_mode(
            mut self,
            input: std::option::Option<crate::model::PerformanceMode>,
        ) -> Self {
            self.performance_mode = input;
            self
        }
        /// <p>A Boolean value that, if true, indicates that the file system is encrypted.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>A Boolean value that, if true, indicates that the file system is encrypted.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The ID of an Key Management Service customer master key (CMK) that was
        /// used to protect the encrypted file system.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of an Key Management Service customer master key (CMK) that was
        /// used to protect the encrypted file system.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Displays the file system's throughput mode. For more information, see
        /// <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a>
        /// in the <i>Amazon EFS User Guide</i>.
        /// </p>
        pub fn throughput_mode(mut self, input: crate::model::ThroughputMode) -> Self {
            self.throughput_mode = Some(input);
            self
        }
        /// <p>Displays the file system's throughput mode. For more information, see
        /// <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes">Throughput modes</a>
        /// in the <i>Amazon EFS User Guide</i>.
        /// </p>
        pub fn set_throughput_mode(
            mut self,
            input: std::option::Option<crate::model::ThroughputMode>,
        ) -> Self {
            self.throughput_mode = input;
            self
        }
        /// <p>The amount of provisioned throughput, measured in MiB/s, for the file system. Valid for
        /// file systems using <code>ThroughputMode</code> set to <code>provisioned</code>.</p>
        pub fn provisioned_throughput_in_mibps(mut self, input: f64) -> Self {
            self.provisioned_throughput_in_mibps = Some(input);
            self
        }
        /// <p>The amount of provisioned throughput, measured in MiB/s, for the file system. Valid for
        /// file systems using <code>ThroughputMode</code> set to <code>provisioned</code>.</p>
        pub fn set_provisioned_throughput_in_mibps(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.provisioned_throughput_in_mibps = input;
            self
        }
        /// <p>Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid only
        /// for file systems using One Zone storage classes. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a>
        /// in the <i>Amazon EFS User Guide</i>.</p>
        pub fn availability_zone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_name = Some(input.into());
            self
        }
        /// <p>Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid only
        /// for file systems using One Zone storage classes. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a>
        /// in the <i>Amazon EFS User Guide</i>.</p>
        pub fn set_availability_zone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_name = input;
            self
        }
        /// <p>The unique and consistent identifier of the Availability Zone in which the file system's
        /// One Zone storage classes exist. For example, <code>use1-az1</code> is an Availability Zone ID
        /// for the us-east-1 Amazon Web Services Region, and it has the same location in every Amazon Web Services account.</p>
        pub fn availability_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_id = Some(input.into());
            self
        }
        /// <p>The unique and consistent identifier of the Availability Zone in which the file system's
        /// One Zone storage classes exist. For example, <code>use1-az1</code> is an Availability Zone ID
        /// for the us-east-1 Amazon Web Services Region, and it has the same location in every Amazon Web Services account.</p>
        pub fn set_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the file system, presented as an array of <code>Tag</code>
        /// objects.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the file system, presented as an array of <code>Tag</code>
        /// objects.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`FileSystemDescription`](crate::model::FileSystemDescription)
        pub fn build(self) -> crate::model::FileSystemDescription {
            crate::model::FileSystemDescription {
                owner_id: self.owner_id,
                creation_token: self.creation_token,
                file_system_id: self.file_system_id,
                file_system_arn: self.file_system_arn,
                creation_time: self.creation_time,
                life_cycle_state: self.life_cycle_state,
                name: self.name,
                number_of_mount_targets: self.number_of_mount_targets.unwrap_or_default(),
                size_in_bytes: self.size_in_bytes,
                performance_mode: self.performance_mode,
                encrypted: self.encrypted,
                kms_key_id: self.kms_key_id,
                throughput_mode: self.throughput_mode,
                provisioned_throughput_in_mibps: self.provisioned_throughput_in_mibps,
                availability_zone_name: self.availability_zone_name,
                availability_zone_id: self.availability_zone_id,
                tags: self.tags,
            }
        }
    }
}
impl FileSystemDescription {
    /// Creates a new builder-style object to manufacture [`FileSystemDescription`](crate::model::FileSystemDescription)
    pub fn builder() -> crate::model::file_system_description::Builder {
        crate::model::file_system_description::Builder::default()
    }
}

/// <p>Provides a description of an EFS file system access point.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessPointDescription {
    /// <p>The opaque string specified in the request to ensure idempotent creation.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The name of the access point. This is the value of the <code>Name</code> tag.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The tags associated with the access point, presented as an array of Tag objects.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The ID of the access point, assigned by Amazon EFS.</p>
    pub access_point_id: std::option::Option<std::string::String>,
    /// <p>The  unique Amazon Resource Name (ARN) associated with the access point.</p>
    pub access_point_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the EFS file system that the access point applies to.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point that is used for all file operations by
    /// NFS clients using the access point.</p>
    pub posix_user: std::option::Option<crate::model::PosixUser>,
    /// <p>The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS clients using the access point.</p>
    pub root_directory: std::option::Option<crate::model::RootDirectory>,
    /// <p>Identified the Amazon Web Services account that owns the access point resource.</p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>Identifies the lifecycle phase of the access point.</p>
    pub life_cycle_state: std::option::Option<crate::model::LifeCycleState>,
}
impl std::fmt::Debug for AccessPointDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessPointDescription");
        formatter.field("client_token", &self.client_token);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.field("access_point_id", &self.access_point_id);
        formatter.field("access_point_arn", &self.access_point_arn);
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("posix_user", &self.posix_user);
        formatter.field("root_directory", &self.root_directory);
        formatter.field("owner_id", &self.owner_id);
        formatter.field("life_cycle_state", &self.life_cycle_state);
        formatter.finish()
    }
}
/// See [`AccessPointDescription`](crate::model::AccessPointDescription)
pub mod access_point_description {
    /// A builder for [`AccessPointDescription`](crate::model::AccessPointDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) access_point_id: std::option::Option<std::string::String>,
        pub(crate) access_point_arn: std::option::Option<std::string::String>,
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) posix_user: std::option::Option<crate::model::PosixUser>,
        pub(crate) root_directory: std::option::Option<crate::model::RootDirectory>,
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) life_cycle_state: std::option::Option<crate::model::LifeCycleState>,
    }
    impl Builder {
        /// <p>The opaque string specified in the request to ensure idempotent creation.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The opaque string specified in the request to ensure idempotent creation.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The name of the access point. This is the value of the <code>Name</code> tag.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the access point. This is the value of the <code>Name</code> tag.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the access point, presented as an array of Tag objects.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the access point, presented as an array of Tag objects.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The ID of the access point, assigned by Amazon EFS.</p>
        pub fn access_point_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_point_id = Some(input.into());
            self
        }
        /// <p>The ID of the access point, assigned by Amazon EFS.</p>
        pub fn set_access_point_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_point_id = input;
            self
        }
        /// <p>The  unique Amazon Resource Name (ARN) associated with the access point.</p>
        pub fn access_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_point_arn = Some(input.into());
            self
        }
        /// <p>The  unique Amazon Resource Name (ARN) associated with the access point.</p>
        pub fn set_access_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_point_arn = input;
            self
        }
        /// <p>The ID of the EFS file system that the access point applies to.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The ID of the EFS file system that the access point applies to.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point that is used for all file operations by
        /// NFS clients using the access point.</p>
        pub fn posix_user(mut self, input: crate::model::PosixUser) -> Self {
            self.posix_user = Some(input);
            self
        }
        /// <p>The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point that is used for all file operations by
        /// NFS clients using the access point.</p>
        pub fn set_posix_user(
            mut self,
            input: std::option::Option<crate::model::PosixUser>,
        ) -> Self {
            self.posix_user = input;
            self
        }
        /// <p>The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS clients using the access point.</p>
        pub fn root_directory(mut self, input: crate::model::RootDirectory) -> Self {
            self.root_directory = Some(input);
            self
        }
        /// <p>The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS clients using the access point.</p>
        pub fn set_root_directory(
            mut self,
            input: std::option::Option<crate::model::RootDirectory>,
        ) -> Self {
            self.root_directory = input;
            self
        }
        /// <p>Identified the Amazon Web Services account that owns the access point resource.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>Identified the Amazon Web Services account that owns the access point resource.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>Identifies the lifecycle phase of the access point.</p>
        pub fn life_cycle_state(mut self, input: crate::model::LifeCycleState) -> Self {
            self.life_cycle_state = Some(input);
            self
        }
        /// <p>Identifies the lifecycle phase of the access point.</p>
        pub fn set_life_cycle_state(
            mut self,
            input: std::option::Option<crate::model::LifeCycleState>,
        ) -> Self {
            self.life_cycle_state = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessPointDescription`](crate::model::AccessPointDescription)
        pub fn build(self) -> crate::model::AccessPointDescription {
            crate::model::AccessPointDescription {
                client_token: self.client_token,
                name: self.name,
                tags: self.tags,
                access_point_id: self.access_point_id,
                access_point_arn: self.access_point_arn,
                file_system_id: self.file_system_id,
                posix_user: self.posix_user,
                root_directory: self.root_directory,
                owner_id: self.owner_id,
                life_cycle_state: self.life_cycle_state,
            }
        }
    }
}
impl AccessPointDescription {
    /// Creates a new builder-style object to manufacture [`AccessPointDescription`](crate::model::AccessPointDescription)
    pub fn builder() -> crate::model::access_point_description::Builder {
        crate::model::access_point_description::Builder::default()
    }
}

/// <p>Specifies the directory on the Amazon EFS file system that the access point provides access to.
/// The access point exposes the specified file system path as
/// the root directory of your file system to applications using the access point.
/// NFS clients using the access point can only access data in the access point's <code>RootDirectory</code> and it's subdirectories.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RootDirectory {
    /// <p>Specifies the path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system.
    /// A path can have up to four subdirectories.  
    /// If the specified path does not exist, you are required to provide the <code>CreationInfo</code>.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>(Optional) Specifies the POSIX IDs and permissions to apply to the access point's <code>RootDirectory</code>.
    /// If the <code>RootDirectory</code> > <code>Path</code> specified does not exist,
    /// EFS creates the root directory using the <code>CreationInfo</code> settings when a client connects to an access point.
    /// When specifying the <code>CreationInfo</code>, you must provide values for all properties.
    /// </p>
    /// <important>
    /// <p>If you do not provide <code>CreationInfo</code> and the specified <code>RootDirectory</code> > <code>Path</code> does not exist,
    /// attempts to mount the file system using the access point will fail.</p>
    /// </important>
    pub creation_info: std::option::Option<crate::model::CreationInfo>,
}
impl std::fmt::Debug for RootDirectory {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RootDirectory");
        formatter.field("path", &self.path);
        formatter.field("creation_info", &self.creation_info);
        formatter.finish()
    }
}
/// See [`RootDirectory`](crate::model::RootDirectory)
pub mod root_directory {
    /// A builder for [`RootDirectory`](crate::model::RootDirectory)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) creation_info: std::option::Option<crate::model::CreationInfo>,
    }
    impl Builder {
        /// <p>Specifies the path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system.
        /// A path can have up to four subdirectories.  
        /// If the specified path does not exist, you are required to provide the <code>CreationInfo</code>.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>Specifies the path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system.
        /// A path can have up to four subdirectories.  
        /// If the specified path does not exist, you are required to provide the <code>CreationInfo</code>.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>(Optional) Specifies the POSIX IDs and permissions to apply to the access point's <code>RootDirectory</code>.
        /// If the <code>RootDirectory</code> > <code>Path</code> specified does not exist,
        /// EFS creates the root directory using the <code>CreationInfo</code> settings when a client connects to an access point.
        /// When specifying the <code>CreationInfo</code>, you must provide values for all properties.
        /// </p>
        /// <important>
        /// <p>If you do not provide <code>CreationInfo</code> and the specified <code>RootDirectory</code> > <code>Path</code> does not exist,
        /// attempts to mount the file system using the access point will fail.</p>
        /// </important>
        pub fn creation_info(mut self, input: crate::model::CreationInfo) -> Self {
            self.creation_info = Some(input);
            self
        }
        /// <p>(Optional) Specifies the POSIX IDs and permissions to apply to the access point's <code>RootDirectory</code>.
        /// If the <code>RootDirectory</code> > <code>Path</code> specified does not exist,
        /// EFS creates the root directory using the <code>CreationInfo</code> settings when a client connects to an access point.
        /// When specifying the <code>CreationInfo</code>, you must provide values for all properties.
        /// </p>
        /// <important>
        /// <p>If you do not provide <code>CreationInfo</code> and the specified <code>RootDirectory</code> > <code>Path</code> does not exist,
        /// attempts to mount the file system using the access point will fail.</p>
        /// </important>
        pub fn set_creation_info(
            mut self,
            input: std::option::Option<crate::model::CreationInfo>,
        ) -> Self {
            self.creation_info = input;
            self
        }
        /// Consumes the builder and constructs a [`RootDirectory`](crate::model::RootDirectory)
        pub fn build(self) -> crate::model::RootDirectory {
            crate::model::RootDirectory {
                path: self.path,
                creation_info: self.creation_info,
            }
        }
    }
}
impl RootDirectory {
    /// Creates a new builder-style object to manufacture [`RootDirectory`](crate::model::RootDirectory)
    pub fn builder() -> crate::model::root_directory::Builder {
        crate::model::root_directory::Builder::default()
    }
}

/// <p>Required if the <code>RootDirectory</code> > <code>Path</code> specified does not exist.
/// Specifies the POSIX IDs and permissions to apply to the access point's <code>RootDirectory</code> > <code>Path</code>.
/// If the access point root directory does not exist, EFS creates it with these settings when a client connects to the access point.
/// When specifying <code>CreationInfo</code>, you must include values for all properties.
/// </p>
/// <p>Amazon EFS creates a root directory only if you have provided the  CreationInfo: OwnUid, OwnGID, and permissions for the directory.
/// If  you do not provide this information, Amazon EFS does not create the root directory. If the root directory does not exist, attempts to mount
/// using the access point will fail.</p>
/// <important>
/// <p>If you do not provide <code>CreationInfo</code> and the specified <code>RootDirectory</code> does not exist,
/// attempts to mount the file system using the access point will fail.</p>
/// </important>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreationInfo {
    /// <p>Specifies the POSIX user ID to apply to the <code>RootDirectory</code>. Accepts values from 0 to 2^32 (4294967295).</p>
    pub owner_uid: std::option::Option<i64>,
    /// <p>Specifies the POSIX group ID to apply to the <code>RootDirectory</code>. Accepts values from 0 to 2^32 (4294967295).</p>
    pub owner_gid: std::option::Option<i64>,
    /// <p>Specifies the POSIX permissions to apply to the <code>RootDirectory</code>, in the format of an octal number representing the file's mode bits.</p>
    pub permissions: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreationInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreationInfo");
        formatter.field("owner_uid", &self.owner_uid);
        formatter.field("owner_gid", &self.owner_gid);
        formatter.field("permissions", &self.permissions);
        formatter.finish()
    }
}
/// See [`CreationInfo`](crate::model::CreationInfo)
pub mod creation_info {
    /// A builder for [`CreationInfo`](crate::model::CreationInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_uid: std::option::Option<i64>,
        pub(crate) owner_gid: std::option::Option<i64>,
        pub(crate) permissions: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the POSIX user ID to apply to the <code>RootDirectory</code>. Accepts values from 0 to 2^32 (4294967295).</p>
        pub fn owner_uid(mut self, input: i64) -> Self {
            self.owner_uid = Some(input);
            self
        }
        /// <p>Specifies the POSIX user ID to apply to the <code>RootDirectory</code>. Accepts values from 0 to 2^32 (4294967295).</p>
        pub fn set_owner_uid(mut self, input: std::option::Option<i64>) -> Self {
            self.owner_uid = input;
            self
        }
        /// <p>Specifies the POSIX group ID to apply to the <code>RootDirectory</code>. Accepts values from 0 to 2^32 (4294967295).</p>
        pub fn owner_gid(mut self, input: i64) -> Self {
            self.owner_gid = Some(input);
            self
        }
        /// <p>Specifies the POSIX group ID to apply to the <code>RootDirectory</code>. Accepts values from 0 to 2^32 (4294967295).</p>
        pub fn set_owner_gid(mut self, input: std::option::Option<i64>) -> Self {
            self.owner_gid = input;
            self
        }
        /// <p>Specifies the POSIX permissions to apply to the <code>RootDirectory</code>, in the format of an octal number representing the file's mode bits.</p>
        pub fn permissions(mut self, input: impl Into<std::string::String>) -> Self {
            self.permissions = Some(input.into());
            self
        }
        /// <p>Specifies the POSIX permissions to apply to the <code>RootDirectory</code>, in the format of an octal number representing the file's mode bits.</p>
        pub fn set_permissions(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.permissions = input;
            self
        }
        /// Consumes the builder and constructs a [`CreationInfo`](crate::model::CreationInfo)
        pub fn build(self) -> crate::model::CreationInfo {
            crate::model::CreationInfo {
                owner_uid: self.owner_uid,
                owner_gid: self.owner_gid,
                permissions: self.permissions,
            }
        }
    }
}
impl CreationInfo {
    /// Creates a new builder-style object to manufacture [`CreationInfo`](crate::model::CreationInfo)
    pub fn builder() -> crate::model::creation_info::Builder {
        crate::model::creation_info::Builder::default()
    }
}

/// <p>The full POSIX identity, including the user ID, group ID, and any secondary group IDs, on the access point that is used for all file system operations performed by
/// NFS clients using the access point.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PosixUser {
    /// <p>The POSIX user ID used for all file system operations using this access point.</p>
    pub uid: std::option::Option<i64>,
    /// <p>The POSIX group ID used for all file system operations using this access point.</p>
    pub gid: std::option::Option<i64>,
    /// <p>Secondary POSIX group IDs used for all file system operations using this access point.</p>
    pub secondary_gids: std::option::Option<std::vec::Vec<i64>>,
}
impl std::fmt::Debug for PosixUser {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PosixUser");
        formatter.field("uid", &self.uid);
        formatter.field("gid", &self.gid);
        formatter.field("secondary_gids", &self.secondary_gids);
        formatter.finish()
    }
}
/// See [`PosixUser`](crate::model::PosixUser)
pub mod posix_user {
    /// A builder for [`PosixUser`](crate::model::PosixUser)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uid: std::option::Option<i64>,
        pub(crate) gid: std::option::Option<i64>,
        pub(crate) secondary_gids: std::option::Option<std::vec::Vec<i64>>,
    }
    impl Builder {
        /// <p>The POSIX user ID used for all file system operations using this access point.</p>
        pub fn uid(mut self, input: i64) -> Self {
            self.uid = Some(input);
            self
        }
        /// <p>The POSIX user ID used for all file system operations using this access point.</p>
        pub fn set_uid(mut self, input: std::option::Option<i64>) -> Self {
            self.uid = input;
            self
        }
        /// <p>The POSIX group ID used for all file system operations using this access point.</p>
        pub fn gid(mut self, input: i64) -> Self {
            self.gid = Some(input);
            self
        }
        /// <p>The POSIX group ID used for all file system operations using this access point.</p>
        pub fn set_gid(mut self, input: std::option::Option<i64>) -> Self {
            self.gid = input;
            self
        }
        /// Appends an item to `secondary_gids`.
        ///
        /// To override the contents of this collection use [`set_secondary_gids`](Self::set_secondary_gids).
        ///
        /// <p>Secondary POSIX group IDs used for all file system operations using this access point.</p>
        pub fn secondary_gids(mut self, input: impl Into<i64>) -> Self {
            let mut v = self.secondary_gids.unwrap_or_default();
            v.push(input.into());
            self.secondary_gids = Some(v);
            self
        }
        /// <p>Secondary POSIX group IDs used for all file system operations using this access point.</p>
        pub fn set_secondary_gids(
            mut self,
            input: std::option::Option<std::vec::Vec<i64>>,
        ) -> Self {
            self.secondary_gids = input;
            self
        }
        /// Consumes the builder and constructs a [`PosixUser`](crate::model::PosixUser)
        pub fn build(self) -> crate::model::PosixUser {
            crate::model::PosixUser {
                uid: self.uid,
                gid: self.gid,
                secondary_gids: self.secondary_gids,
            }
        }
    }
}
impl PosixUser {
    /// Creates a new builder-style object to manufacture [`PosixUser`](crate::model::PosixUser)
    pub fn builder() -> crate::model::posix_user::Builder {
        crate::model::posix_user::Builder::default()
    }
}
