// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `MagnolioAPIService_v20150201`.
///
/// This client allows ergonomic access to a `MagnolioAPIService_v20150201`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateAccessPoint` operation.
    ///
    /// See [`CreateAccessPoint`](crate::client::fluent_builders::CreateAccessPoint) for more information about the
    /// operation and its arguments.
    pub fn create_access_point(&self) -> fluent_builders::CreateAccessPoint<C, M, R> {
        fluent_builders::CreateAccessPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFileSystem` operation.
    ///
    /// See [`CreateFileSystem`](crate::client::fluent_builders::CreateFileSystem) for more information about the
    /// operation and its arguments.
    pub fn create_file_system(&self) -> fluent_builders::CreateFileSystem<C, M, R> {
        fluent_builders::CreateFileSystem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMountTarget` operation.
    ///
    /// See [`CreateMountTarget`](crate::client::fluent_builders::CreateMountTarget) for more information about the
    /// operation and its arguments.
    pub fn create_mount_target(&self) -> fluent_builders::CreateMountTarget<C, M, R> {
        fluent_builders::CreateMountTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTags` operation.
    ///
    /// See [`CreateTags`](crate::client::fluent_builders::CreateTags) for more information about the
    /// operation and its arguments.
    pub fn create_tags(&self) -> fluent_builders::CreateTags<C, M, R> {
        fluent_builders::CreateTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAccessPoint` operation.
    ///
    /// See [`DeleteAccessPoint`](crate::client::fluent_builders::DeleteAccessPoint) for more information about the
    /// operation and its arguments.
    pub fn delete_access_point(&self) -> fluent_builders::DeleteAccessPoint<C, M, R> {
        fluent_builders::DeleteAccessPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFileSystem` operation.
    ///
    /// See [`DeleteFileSystem`](crate::client::fluent_builders::DeleteFileSystem) for more information about the
    /// operation and its arguments.
    pub fn delete_file_system(&self) -> fluent_builders::DeleteFileSystem<C, M, R> {
        fluent_builders::DeleteFileSystem::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFileSystemPolicy` operation.
    ///
    /// See [`DeleteFileSystemPolicy`](crate::client::fluent_builders::DeleteFileSystemPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_file_system_policy(&self) -> fluent_builders::DeleteFileSystemPolicy<C, M, R> {
        fluent_builders::DeleteFileSystemPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMountTarget` operation.
    ///
    /// See [`DeleteMountTarget`](crate::client::fluent_builders::DeleteMountTarget) for more information about the
    /// operation and its arguments.
    pub fn delete_mount_target(&self) -> fluent_builders::DeleteMountTarget<C, M, R> {
        fluent_builders::DeleteMountTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTags` operation.
    ///
    /// See [`DeleteTags`](crate::client::fluent_builders::DeleteTags) for more information about the
    /// operation and its arguments.
    pub fn delete_tags(&self) -> fluent_builders::DeleteTags<C, M, R> {
        fluent_builders::DeleteTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccessPoints` operation.
    ///
    /// See [`DescribeAccessPoints`](crate::client::fluent_builders::DescribeAccessPoints) for more information about the
    /// operation and its arguments.
    pub fn describe_access_points(&self) -> fluent_builders::DescribeAccessPoints<C, M, R> {
        fluent_builders::DescribeAccessPoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccountPreferences` operation.
    ///
    /// See [`DescribeAccountPreferences`](crate::client::fluent_builders::DescribeAccountPreferences) for more information about the
    /// operation and its arguments.
    pub fn describe_account_preferences(
        &self,
    ) -> fluent_builders::DescribeAccountPreferences<C, M, R> {
        fluent_builders::DescribeAccountPreferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBackupPolicy` operation.
    ///
    /// See [`DescribeBackupPolicy`](crate::client::fluent_builders::DescribeBackupPolicy) for more information about the
    /// operation and its arguments.
    pub fn describe_backup_policy(&self) -> fluent_builders::DescribeBackupPolicy<C, M, R> {
        fluent_builders::DescribeBackupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFileSystemPolicy` operation.
    ///
    /// See [`DescribeFileSystemPolicy`](crate::client::fluent_builders::DescribeFileSystemPolicy) for more information about the
    /// operation and its arguments.
    pub fn describe_file_system_policy(
        &self,
    ) -> fluent_builders::DescribeFileSystemPolicy<C, M, R> {
        fluent_builders::DescribeFileSystemPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFileSystems` operation.
    ///
    /// See [`DescribeFileSystems`](crate::client::fluent_builders::DescribeFileSystems) for more information about the
    /// operation and its arguments.
    pub fn describe_file_systems(&self) -> fluent_builders::DescribeFileSystems<C, M, R> {
        fluent_builders::DescribeFileSystems::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLifecycleConfiguration` operation.
    ///
    /// See [`DescribeLifecycleConfiguration`](crate::client::fluent_builders::DescribeLifecycleConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_lifecycle_configuration(
        &self,
    ) -> fluent_builders::DescribeLifecycleConfiguration<C, M, R> {
        fluent_builders::DescribeLifecycleConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMountTargets` operation.
    ///
    /// See [`DescribeMountTargets`](crate::client::fluent_builders::DescribeMountTargets) for more information about the
    /// operation and its arguments.
    pub fn describe_mount_targets(&self) -> fluent_builders::DescribeMountTargets<C, M, R> {
        fluent_builders::DescribeMountTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMountTargetSecurityGroups` operation.
    ///
    /// See [`DescribeMountTargetSecurityGroups`](crate::client::fluent_builders::DescribeMountTargetSecurityGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_mount_target_security_groups(
        &self,
    ) -> fluent_builders::DescribeMountTargetSecurityGroups<C, M, R> {
        fluent_builders::DescribeMountTargetSecurityGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTags` operation.
    ///
    /// See [`DescribeTags`](crate::client::fluent_builders::DescribeTags) for more information about the
    /// operation and its arguments.
    pub fn describe_tags(&self) -> fluent_builders::DescribeTags<C, M, R> {
        fluent_builders::DescribeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyMountTargetSecurityGroups` operation.
    ///
    /// See [`ModifyMountTargetSecurityGroups`](crate::client::fluent_builders::ModifyMountTargetSecurityGroups) for more information about the
    /// operation and its arguments.
    pub fn modify_mount_target_security_groups(
        &self,
    ) -> fluent_builders::ModifyMountTargetSecurityGroups<C, M, R> {
        fluent_builders::ModifyMountTargetSecurityGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutAccountPreferences` operation.
    ///
    /// See [`PutAccountPreferences`](crate::client::fluent_builders::PutAccountPreferences) for more information about the
    /// operation and its arguments.
    pub fn put_account_preferences(&self) -> fluent_builders::PutAccountPreferences<C, M, R> {
        fluent_builders::PutAccountPreferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutBackupPolicy` operation.
    ///
    /// See [`PutBackupPolicy`](crate::client::fluent_builders::PutBackupPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_backup_policy(&self) -> fluent_builders::PutBackupPolicy<C, M, R> {
        fluent_builders::PutBackupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutFileSystemPolicy` operation.
    ///
    /// See [`PutFileSystemPolicy`](crate::client::fluent_builders::PutFileSystemPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_file_system_policy(&self) -> fluent_builders::PutFileSystemPolicy<C, M, R> {
        fluent_builders::PutFileSystemPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutLifecycleConfiguration` operation.
    ///
    /// See [`PutLifecycleConfiguration`](crate::client::fluent_builders::PutLifecycleConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_lifecycle_configuration(
        &self,
    ) -> fluent_builders::PutLifecycleConfiguration<C, M, R> {
        fluent_builders::PutLifecycleConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFileSystem` operation.
    ///
    /// See [`UpdateFileSystem`](crate::client::fluent_builders::UpdateFileSystem) for more information about the
    /// operation and its arguments.
    pub fn update_file_system(&self) -> fluent_builders::UpdateFileSystem<C, M, R> {
        fluent_builders::UpdateFileSystem::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateAccessPoint`.
    ///
    /// <p>Creates an EFS access point. An access point is an application-specific view into an EFS
    /// file system that applies an operating system user and group, and a file system path, to any
    /// file system request made through the access point. The operating system user and group
    /// override any identity information provided by the NFS client. The file system path is exposed
    /// as the access point's root directory. Applications using the access point can only access data
    /// in its own directory and below. To learn more, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">Mounting a file system using EFS access
    /// points</a>.</p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:CreateAccessPoint</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAccessPoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_access_point_input::Builder,
    }
    impl<C, M, R> CreateAccessPoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAccessPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccessPointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccessPointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAccessPointInputOperationOutputAlias,
                crate::output::CreateAccessPointOutput,
                crate::error::CreateAccessPointError,
                crate::input::CreateAccessPointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent
        /// creation.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent
        /// creation.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Creates tags associated with the access point. Each tag is a key-value pair, each key must be unique. For more
        /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
        /// in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Creates tags associated with the access point. Each tag is a key-value pair, each key must be unique. For more
        /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
        /// in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The ID of the EFS file system that the access point provides access to.</p>
        pub fn file_system_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(inp);
            self
        }
        /// <p>The ID of the EFS file system that the access point provides access to.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>The operating system user and
        /// group applied to all file system requests made using the access point.</p>
        pub fn posix_user(mut self, inp: crate::model::PosixUser) -> Self {
            self.inner = self.inner.posix_user(inp);
            self
        }
        /// <p>The operating system user and
        /// group applied to all file system requests made using the access point.</p>
        pub fn set_posix_user(
            mut self,
            input: std::option::Option<crate::model::PosixUser>,
        ) -> Self {
            self.inner = self.inner.set_posix_user(input);
            self
        }
        /// <p>Specifies the directory on the Amazon EFS file system that the access point exposes as
        /// the root directory of your file system to NFS clients using the access point.
        /// The clients using the access point can only access the root directory and below.
        /// If the <code>RootDirectory</code> > <code>Path</code> specified does not exist,
        /// EFS creates it and applies the <code>CreationInfo</code> settings when a client connects to an access point.
        /// When specifying a <code>RootDirectory</code>, you need to provide the <code>Path</code>, and the <code>CreationInfo</code>.</p>
        /// <p>Amazon EFS creates a root directory only if you have provided the  CreationInfo: OwnUid, OwnGID, and permissions for the directory.
        /// If  you do not provide this information, Amazon EFS does not create the root directory. If the root directory does not exist, attempts to mount
        /// using the access point will fail.</p>
        pub fn root_directory(mut self, inp: crate::model::RootDirectory) -> Self {
            self.inner = self.inner.root_directory(inp);
            self
        }
        /// <p>Specifies the directory on the Amazon EFS file system that the access point exposes as
        /// the root directory of your file system to NFS clients using the access point.
        /// The clients using the access point can only access the root directory and below.
        /// If the <code>RootDirectory</code> > <code>Path</code> specified does not exist,
        /// EFS creates it and applies the <code>CreationInfo</code> settings when a client connects to an access point.
        /// When specifying a <code>RootDirectory</code>, you need to provide the <code>Path</code>, and the <code>CreationInfo</code>.</p>
        /// <p>Amazon EFS creates a root directory only if you have provided the  CreationInfo: OwnUid, OwnGID, and permissions for the directory.
        /// If  you do not provide this information, Amazon EFS does not create the root directory. If the root directory does not exist, attempts to mount
        /// using the access point will fail.</p>
        pub fn set_root_directory(
            mut self,
            input: std::option::Option<crate::model::RootDirectory>,
        ) -> Self {
            self.inner = self.inner.set_root_directory(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFileSystem`.
    ///
    /// <p>Creates a new, empty file system. The operation requires a creation token in the
    /// request that Amazon EFS uses to ensure idempotent creation (calling the operation with same
    /// creation token has no effect). If a file system does not currently exist that is owned by the
    /// caller's Amazon Web Services account with the specified creation token, this operation does the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>Creates a new, empty file system. The file system will have an Amazon EFS assigned
    /// ID, and an initial lifecycle state <code>creating</code>.</p>
    /// </li>
    /// <li>
    /// <p>Returns with the description of the created file system.</p>
    /// </li>
    /// </ul>
    /// <p>Otherwise, this operation returns a <code>FileSystemAlreadyExists</code> error with the
    /// ID of the existing file system.</p>
    /// <note>
    /// <p>For basic use cases, you can use a randomly generated UUID for the creation
    /// token.</p>
    /// </note>
    /// <p> The idempotent operation allows you to retry a <code>CreateFileSystem</code> call without
    /// risk of creating an extra file system. This can happen when an initial call fails in a way
    /// that leaves it uncertain whether or not a file system was actually created. An example might
    /// be that a transport level timeout occurred or your connection was reset. As long as you use
    /// the same creation token, if the initial call had succeeded in creating a file system, the
    /// client can learn of its existence from the <code>FileSystemAlreadyExists</code> error.</p>
    /// <p>For more information, see
    /// <a href="https://docs.aws.amazon.com/efs/latest/ug/creating-using-create-fs.html#creating-using-create-fs-part1">Creating a file system</a>
    /// in the <i>Amazon EFS User Guide</i>.</p>
    ///
    /// <note>
    /// <p>The <code>CreateFileSystem</code> call returns while the file system's lifecycle
    /// state is still <code>creating</code>. You can check the file system creation status by
    /// calling the <a>DescribeFileSystems</a> operation, which among other things returns the file
    /// system state.</p>
    /// </note>
    ///
    /// <p>This operation accepts an optional <code>PerformanceMode</code> parameter that you
    /// choose for your file system. We recommend <code>generalPurpose</code> performance mode for
    /// most file systems. File systems using the <code>maxIO</code> performance mode can scale to
    /// higher levels of aggregate throughput and operations per second with a tradeoff of slightly
    /// higher latencies for most file operations. The performance mode can't be changed after
    /// the file system has been created. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#performancemodes.html">Amazon EFS performance
    /// modes</a>.</p>
    ///
    /// <p>You can set the throughput mode for the file system using the <code>ThroughputMode</code> parameter.</p>
    ///
    /// <p>After the file system is fully created, Amazon EFS sets its lifecycle state to
    /// <code>available</code>, at which point you can create one or more mount targets for the file
    /// system in your VPC. For more information, see <a>CreateMountTarget</a>. You mount your Amazon EFS file system on an EC2 instances in
    /// your VPC by using the mount target. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html">Amazon EFS: How it Works</a>. </p>
    ///
    /// <p> This operation requires permissions for the
    /// <code>elasticfilesystem:CreateFileSystem</code> action. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFileSystem<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_file_system_input::Builder,
    }
    impl<C, M, R> CreateFileSystem<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFileSystem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFileSystemOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFileSystemError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFileSystemInputOperationOutputAlias,
                crate::output::CreateFileSystemOutput,
                crate::error::CreateFileSystemError,
                crate::input::CreateFileSystemInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent
        /// creation.</p>
        pub fn creation_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creation_token(inp);
            self
        }
        /// <p>A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent
        /// creation.</p>
        pub fn set_creation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creation_token(input);
            self
        }
        /// <p>The performance mode of the file system. We recommend <code>generalPurpose</code>
        /// performance mode for most file systems. File systems using the <code>maxIO</code> performance
        /// mode can scale to higher levels of aggregate throughput and operations per second with a
        /// tradeoff of slightly higher latencies for most file operations. The performance mode
        /// can't be changed after the file system has been created.</p>
        /// <note>
        /// <p>The <code>maxIO</code> mode is not supported on file systems using One Zone storage classes.</p>
        /// </note>
        pub fn performance_mode(mut self, inp: crate::model::PerformanceMode) -> Self {
            self.inner = self.inner.performance_mode(inp);
            self
        }
        /// <p>The performance mode of the file system. We recommend <code>generalPurpose</code>
        /// performance mode for most file systems. File systems using the <code>maxIO</code> performance
        /// mode can scale to higher levels of aggregate throughput and operations per second with a
        /// tradeoff of slightly higher latencies for most file operations. The performance mode
        /// can't be changed after the file system has been created.</p>
        /// <note>
        /// <p>The <code>maxIO</code> mode is not supported on file systems using One Zone storage classes.</p>
        /// </note>
        pub fn set_performance_mode(
            mut self,
            input: std::option::Option<crate::model::PerformanceMode>,
        ) -> Self {
            self.inner = self.inner.set_performance_mode(input);
            self
        }
        /// <p>A Boolean value that, if true, creates an encrypted file system. When creating an
        /// encrypted file system, you have the option of specifying <a>CreateFileSystemRequest$KmsKeyId</a> for an existing Key Management Service (KMS
        /// customer master key (CMK). If you don't specify a CMK, then the default CMK for
        /// Amazon EFS, <code>/aws/elasticfilesystem</code>, is used to protect the encrypted file system.
        /// </p>
        pub fn encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.encrypted(inp);
            self
        }
        /// <p>A Boolean value that, if true, creates an encrypted file system. When creating an
        /// encrypted file system, you have the option of specifying <a>CreateFileSystemRequest$KmsKeyId</a> for an existing Key Management Service (KMS
        /// customer master key (CMK). If you don't specify a CMK, then the default CMK for
        /// Amazon EFS, <code>/aws/elasticfilesystem</code>, is used to protect the encrypted file system.
        /// </p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_encrypted(input);
            self
        }
        /// <p>The ID of the KMS CMK that you want to use to protect the encrypted file system. This
        /// parameter is only required if you want to use a non-default KMS key. If this parameter is not
        /// specified, the default CMK for Amazon EFS is used. This ID can be in one of the following
        /// formats:</p>
        /// <ul>
        /// <li>
        /// <p>Key ID - A unique identifier of the key, for example
        /// <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        /// </li>
        /// <li>
        /// <p>ARN - An Amazon Resource Name (ARN) for the key, for example
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        /// </li>
        /// <li>
        /// <p>Key alias - A previously created display name for a key, for example
        /// <code>alias/projectKey1</code>.</p>
        /// </li>
        /// <li>
        /// <p>Key alias ARN - An ARN for a key alias, for example
        /// <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>KmsKeyId</code> is specified, the <a>CreateFileSystemRequest$Encrypted</a> parameter must be set to true.</p>
        /// <important>
        /// <p>EFS accepts only symmetric KMS keys. You cannot use asymmetric KMS keys with EFS file systems.</p>
        /// </important>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The ID of the KMS CMK that you want to use to protect the encrypted file system. This
        /// parameter is only required if you want to use a non-default KMS key. If this parameter is not
        /// specified, the default CMK for Amazon EFS is used. This ID can be in one of the following
        /// formats:</p>
        /// <ul>
        /// <li>
        /// <p>Key ID - A unique identifier of the key, for example
        /// <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        /// </li>
        /// <li>
        /// <p>ARN - An Amazon Resource Name (ARN) for the key, for example
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p>
        /// </li>
        /// <li>
        /// <p>Key alias - A previously created display name for a key, for example
        /// <code>alias/projectKey1</code>.</p>
        /// </li>
        /// <li>
        /// <p>Key alias ARN - An ARN for a key alias, for example
        /// <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>KmsKeyId</code> is specified, the <a>CreateFileSystemRequest$Encrypted</a> parameter must be set to true.</p>
        /// <important>
        /// <p>EFS accepts only symmetric KMS keys. You cannot use asymmetric KMS keys with EFS file systems.</p>
        /// </important>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>Specifies the throughput mode for the file system, either <code>bursting</code> or
        /// <code>provisioned</code>. If you set <code>ThroughputMode</code> to
        /// <code>provisioned</code>, you must also set a value for
        /// <code>ProvisionedThroughputInMibps</code>. After you create the file system, you can
        /// decrease your file system's throughput in Provisioned Throughput mode or change between
        /// the throughput modes, as long as it’s been more than 24 hours since the last decrease or
        /// throughput mode change. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying throughput with
        /// provisioned mode</a> in the <i>Amazon EFS User Guide</i>. </p>
        /// <p>Default is <code>bursting</code>.</p>
        pub fn throughput_mode(mut self, inp: crate::model::ThroughputMode) -> Self {
            self.inner = self.inner.throughput_mode(inp);
            self
        }
        /// <p>Specifies the throughput mode for the file system, either <code>bursting</code> or
        /// <code>provisioned</code>. If you set <code>ThroughputMode</code> to
        /// <code>provisioned</code>, you must also set a value for
        /// <code>ProvisionedThroughputInMibps</code>. After you create the file system, you can
        /// decrease your file system's throughput in Provisioned Throughput mode or change between
        /// the throughput modes, as long as it’s been more than 24 hours since the last decrease or
        /// throughput mode change. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying throughput with
        /// provisioned mode</a> in the <i>Amazon EFS User Guide</i>. </p>
        /// <p>Default is <code>bursting</code>.</p>
        pub fn set_throughput_mode(
            mut self,
            input: std::option::Option<crate::model::ThroughputMode>,
        ) -> Self {
            self.inner = self.inner.set_throughput_mode(input);
            self
        }
        /// <p>The throughput, measured in MiB/s, that you want to provision for a file system that
        /// you're creating. Valid values are 1-1024. Required if <code>ThroughputMode</code> is set
        /// to <code>provisioned</code>. The upper limit for throughput is 1024 MiB/s. To increase this
        /// limit, contact Amazon Web Services Support. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS quotas that you can increase</a>
        /// in the <i>Amazon EFS User Guide</i>.</p>
        pub fn provisioned_throughput_in_mibps(mut self, inp: f64) -> Self {
            self.inner = self.inner.provisioned_throughput_in_mibps(inp);
            self
        }
        /// <p>The throughput, measured in MiB/s, that you want to provision for a file system that
        /// you're creating. Valid values are 1-1024. Required if <code>ThroughputMode</code> is set
        /// to <code>provisioned</code>. The upper limit for throughput is 1024 MiB/s. To increase this
        /// limit, contact Amazon Web Services Support. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS quotas that you can increase</a>
        /// in the <i>Amazon EFS User Guide</i>.</p>
        pub fn set_provisioned_throughput_in_mibps(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_throughput_in_mibps(input);
            self
        }
        /// <p>Used to create a file system that uses One Zone storage classes. It specifies the Amazon Web Services
        /// Availability Zone in which to create the file system. Use the format <code>us-east-1a</code>
        /// to specify the Availability Zone. For
        /// more information about One Zone storage classes, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p>
        /// <note>
        /// <p>One Zone storage classes are not available in all Availability Zones in Amazon Web Services Regions where
        /// Amazon EFS is available.</p>
        /// </note>
        pub fn availability_zone_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone_name(inp);
            self
        }
        /// <p>Used to create a file system that uses One Zone storage classes. It specifies the Amazon Web Services
        /// Availability Zone in which to create the file system. Use the format <code>us-east-1a</code>
        /// to specify the Availability Zone. For
        /// more information about One Zone storage classes, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <i>Amazon EFS User Guide</i>.</p>
        /// <note>
        /// <p>One Zone storage classes are not available in all Availability Zones in Amazon Web Services Regions where
        /// Amazon EFS is available.</p>
        /// </note>
        pub fn set_availability_zone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone_name(input);
            self
        }
        /// <p>Specifies whether automatic backups are enabled on the file system that you are creating.
        /// Set the value to <code>true</code> to enable automatic backups. If you are creating a file
        /// system that uses One Zone storage classes, automatic backups are enabled by default. For more
        /// information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups">Automatic backups</a> in the
        /// <i>Amazon EFS User Guide</i>.</p>
        /// <p>Default is <code>false</code>. However, if you specify an <code>AvailabilityZoneName</code>,
        /// the default is <code>true</code>.</p>
        /// <note>
        /// <p>Backup is not available in all Amazon Web Services Regionswhere Amazon EFS is available.</p>
        /// </note>
        pub fn backup(mut self, inp: bool) -> Self {
            self.inner = self.inner.backup(inp);
            self
        }
        /// <p>Specifies whether automatic backups are enabled on the file system that you are creating.
        /// Set the value to <code>true</code> to enable automatic backups. If you are creating a file
        /// system that uses One Zone storage classes, automatic backups are enabled by default. For more
        /// information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups">Automatic backups</a> in the
        /// <i>Amazon EFS User Guide</i>.</p>
        /// <p>Default is <code>false</code>. However, if you specify an <code>AvailabilityZoneName</code>,
        /// the default is <code>true</code>.</p>
        /// <note>
        /// <p>Backup is not available in all Amazon Web Services Regionswhere Amazon EFS is available.</p>
        /// </note>
        pub fn set_backup(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_backup(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Use to create one or more tags associated with the file system. Each
        /// tag is a user-defined key-value pair. Name your file system on creation by including a
        /// <code>"Key":"Name","Value":"{value}"</code> key-value pair. Each key must be unique. For more
        /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
        /// in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Use to create one or more tags associated with the file system. Each
        /// tag is a user-defined key-value pair. Name your file system on creation by including a
        /// <code>"Key":"Name","Value":"{value}"</code> key-value pair. Each key must be unique. For more
        /// information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
        /// in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMountTarget`.
    ///
    /// <p>Creates a mount target for a file system. You can then mount the file system on EC2
    /// instances by using the mount target.</p>
    /// <p>You can create one mount target in each Availability Zone in your VPC. All EC2
    /// instances in a VPC within a given Availability Zone share a single mount target for a given
    /// file system. If you have multiple subnets in an Availability Zone, you create a mount target
    /// in one of the subnets. EC2 instances do not need to be in the same subnet as the mount target
    /// in order to access their file system.</p>
    /// <p>You can create only one mount target for an EFS file system using One Zone storage
    /// classes. You must create that mount target in the same Availability Zone in which the file
    /// system is located. Use the <code>AvailabilityZoneName</code> and
    /// <code>AvailabiltyZoneId</code> properties in the <a>DescribeFileSystems</a>
    /// response object to get this information. Use the <code>subnetId</code> associated with the
    /// file system's Availability Zone when creating the mount target.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html">Amazon EFS: How it Works</a>. </p>
    /// <p>To create a mount target for a file system, the file system's lifecycle state must be
    /// <code>available</code>. For more information, see <a>DescribeFileSystems</a>.</p>
    /// <p>In the request, provide the following:</p>
    /// <ul>
    /// <li>
    /// <p>The file system ID for which you are creating the mount
    /// target.</p>
    /// </li>
    /// <li>
    /// <p>A subnet ID, which determines the following:</p>
    /// <ul>
    /// <li>
    /// <p>The VPC in which Amazon EFS creates the mount target</p>
    /// </li>
    /// <li>
    /// <p>The Availability Zone in which Amazon EFS creates the mount target</p>
    /// </li>
    /// <li>
    /// <p>The IP address range from which Amazon EFS selects the IP address of the mount target
    /// (if you don't specify an IP address in the request)</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    ///
    /// <p>After creating the mount target, Amazon EFS returns a response that includes, a
    /// <code>MountTargetId</code> and an <code>IpAddress</code>. You use this IP address when
    /// mounting the file system in an EC2 instance. You can also use the mount target's DNS name
    /// when mounting the file system. The EC2 instance on which you mount the file system by using
    /// the mount target can resolve the mount target's DNS name to its IP address. For more
    /// information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html#how-it-works-implementation">How it Works:
    /// Implementation Overview</a>. </p>
    /// <p>Note that you can create mount targets for a file system in only one VPC, and there can
    /// be only one mount target per Availability Zone. That is, if the file system already has one or
    /// more mount targets created for it, the subnet specified in the request to add another mount
    /// target must meet the following requirements:</p>
    /// <ul>
    /// <li>
    /// <p>Must belong to the same VPC as the subnets of the existing mount targets</p>
    /// </li>
    /// <li>
    /// <p>Must not be in the same Availability Zone as any of the subnets of the existing
    /// mount targets</p>
    /// </li>
    /// </ul>
    ///
    /// <p>If the request satisfies the requirements, Amazon EFS does the following:</p>
    /// <ul>
    /// <li>
    /// <p>Creates a new mount target in the specified subnet.</p>
    /// </li>
    /// <li>
    /// <p>Also creates a new network interface in the subnet as follows:</p>
    /// <ul>
    /// <li>
    /// <p>If the request provides an <code>IpAddress</code>, Amazon EFS assigns that IP
    /// address to the network interface. Otherwise, Amazon EFS assigns a free address in the
    /// subnet (in the same way that the Amazon EC2 <code>CreateNetworkInterface</code> call
    /// does when a request does not specify a primary private IP address).</p>
    /// </li>
    /// <li>
    /// <p>If the request provides <code>SecurityGroups</code>, this network interface is
    /// associated with those security groups. Otherwise, it belongs to the default security
    /// group for the subnet's VPC.</p>
    /// </li>
    /// <li>
    /// <p>Assigns the description <code>Mount target <i>fsmt-id</i> for
    /// file system <i>fs-id</i>
    /// </code> where <code>
    /// <i>fsmt-id</i>
    /// </code> is the mount target ID, and <code>
    /// <i>fs-id</i>
    /// </code> is the <code>FileSystemId</code>.</p>
    /// </li>
    /// <li>
    /// <p>Sets the <code>requesterManaged</code> property of the network interface to
    /// <code>true</code>, and the <code>requesterId</code> value to
    /// <code>EFS</code>.</p>
    /// </li>
    /// </ul>
    /// <p>Each Amazon EFS mount target has one corresponding requester-managed EC2 network
    /// interface. After the network interface is created, Amazon EFS sets the
    /// <code>NetworkInterfaceId</code> field in the mount target's description to the
    /// network interface ID, and the <code>IpAddress</code> field to its address. If network
    /// interface creation fails, the entire <code>CreateMountTarget</code> operation
    /// fails.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>The <code>CreateMountTarget</code> call returns only after creating the network
    /// interface, but while the mount target state is still <code>creating</code>, you can check
    /// the mount target creation status by calling the <a>DescribeMountTargets</a> operation, which among other things returns the mount
    /// target state.</p>
    /// </note>
    /// <p>We recommend that you create a mount target in each of the Availability Zones. There
    /// are cost considerations for using a file system in an Availability Zone through a mount target
    /// created in another Availability Zone. For more information, see <a href="http://aws.amazon.com/efs/">Amazon EFS</a>. In addition, by always using a mount target local to the
    /// instance's Availability Zone, you eliminate a partial failure scenario. If the
    /// Availability Zone in which your mount target is created goes down, then you can't access
    /// your file system through that mount target. </p>
    /// <p>This operation requires permissions for the following action on the file
    /// system:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>elasticfilesystem:CreateMountTarget</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>This operation also requires permissions for the following Amazon EC2
    /// actions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeSubnets</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeNetworkInterfaces</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:CreateNetworkInterface</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateMountTarget<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_mount_target_input::Builder,
    }
    impl<C, M, R> CreateMountTarget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMountTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMountTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMountTargetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMountTargetInputOperationOutputAlias,
                crate::output::CreateMountTargetOutput,
                crate::error::CreateMountTargetError,
                crate::input::CreateMountTargetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the file system for which to create the mount target.</p>
        pub fn file_system_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(inp);
            self
        }
        /// <p>The ID of the file system for which to create the mount target.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>The ID of the subnet to add the mount target in. For file systems that use One Zone storage classes, use the subnet
        /// that is associated with the file system's Availability Zone.</p>
        pub fn subnet_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(inp);
            self
        }
        /// <p>The ID of the subnet to add the mount target in. For file systems that use One Zone storage classes, use the subnet
        /// that is associated with the file system's Availability Zone.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// <p>Valid IPv4 address within the address range of the specified subnet.</p>
        pub fn ip_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_address(inp);
            self
        }
        /// <p>Valid IPv4 address within the address range of the specified subnet.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_address(input);
            self
        }
        /// Appends an item to `SecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>Up to five VPC security group IDs, of the form <code>sg-xxxxxxxx</code>. These must be
        /// for the same VPC as subnet specified.</p>
        pub fn security_groups(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_groups(inp);
            self
        }
        /// <p>Up to five VPC security group IDs, of the form <code>sg-xxxxxxxx</code>. These must be
        /// for the same VPC as subnet specified.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTags`.
    ///
    /// <note>
    /// <p>DEPRECATED - CreateTags is deprecated and not maintained. Please use the
    /// API action to create tags for EFS resources.</p>
    /// </note>
    /// <p>Creates or overwrites tags associated with a file system. Each tag is a key-value pair. If
    /// a tag key specified in the request already exists on the file system, this operation
    /// overwrites its value with the value provided in the request. If you add the <code>Name</code>
    /// tag to your file system, Amazon EFS returns it in the response to the <a>DescribeFileSystems</a> operation. </p>
    /// <p>This operation requires permission for the <code>elasticfilesystem:CreateTags</code>
    /// action.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_tags_input::Builder,
    }
    impl<C, M, R> CreateTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTagsInputOperationOutputAlias,
                crate::output::CreateTagsOutput,
                crate::error::CreateTagsError,
                crate::input::CreateTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the file system whose tags you want to modify (String). This operation modifies
        /// the tags only, not the file system.</p>
        pub fn file_system_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(inp);
            self
        }
        /// <p>The ID of the file system whose tags you want to modify (String). This operation modifies
        /// the tags only, not the file system.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value
        /// pair. </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>An array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value
        /// pair. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccessPoint`.
    ///
    /// <p>Deletes the specified access point. After deletion is complete, new clients can no
    /// longer connect to the access points. Clients connected to the access point at the time of
    /// deletion will continue to function until they terminate their connection.</p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:DeleteAccessPoint</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAccessPoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_access_point_input::Builder,
    }
    impl<C, M, R> DeleteAccessPoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccessPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccessPointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccessPointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAccessPointInputOperationOutputAlias,
                crate::output::DeleteAccessPointOutput,
                crate::error::DeleteAccessPointError,
                crate::input::DeleteAccessPointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the access point that you want to delete.</p>
        pub fn access_point_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_point_id(inp);
            self
        }
        /// <p>The ID of the access point that you want to delete.</p>
        pub fn set_access_point_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_point_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFileSystem`.
    ///
    /// <p>Deletes a file system, permanently severing access to its contents. Upon return, the
    /// file system no longer exists and you can't access any contents of the deleted file
    /// system.</p>
    /// <p> You can't delete a file system that is in use. That is, if the file system has
    /// any mount targets, you must first delete them. For more information, see <a>DescribeMountTargets</a> and <a>DeleteMountTarget</a>. </p>
    ///
    /// <note>
    /// <p>The <code>DeleteFileSystem</code> call returns while the file system state is still
    /// <code>deleting</code>. You can check the file system deletion status by calling the <a>DescribeFileSystems</a> operation, which returns a list of file systems in your
    /// account. If you pass file system ID or creation token for the deleted file system, the <a>DescribeFileSystems</a> returns a <code>404 FileSystemNotFound</code>
    /// error.</p>
    /// </note>
    ///
    /// <p>This operation requires permissions for the
    /// <code>elasticfilesystem:DeleteFileSystem</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFileSystem<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_file_system_input::Builder,
    }
    impl<C, M, R> DeleteFileSystem<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFileSystem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFileSystemOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFileSystemError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFileSystemInputOperationOutputAlias,
                crate::output::DeleteFileSystemOutput,
                crate::error::DeleteFileSystemError,
                crate::input::DeleteFileSystemInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the file system you want to delete.</p>
        pub fn file_system_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(inp);
            self
        }
        /// <p>The ID of the file system you want to delete.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFileSystemPolicy`.
    ///
    /// <p>Deletes the <code>FileSystemPolicy</code> for the specified file system.
    /// The default <code>FileSystemPolicy</code> goes into effect once the existing policy is deleted.
    /// For more information about the default file system policy, see <a href="https://docs.aws.amazon.com/efs/latest/ug/res-based-policies-efs.html">Using Resource-based Policies with EFS</a>.</p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:DeleteFileSystemPolicy</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFileSystemPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_file_system_policy_input::Builder,
    }
    impl<C, M, R> DeleteFileSystemPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFileSystemPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFileSystemPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFileSystemPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFileSystemPolicyInputOperationOutputAlias,
                crate::output::DeleteFileSystemPolicyOutput,
                crate::error::DeleteFileSystemPolicyError,
                crate::input::DeleteFileSystemPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the EFS file system for which to delete the <code>FileSystemPolicy</code>.</p>
        pub fn file_system_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(inp);
            self
        }
        /// <p>Specifies the EFS file system for which to delete the <code>FileSystemPolicy</code>.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMountTarget`.
    ///
    /// <p>Deletes the specified mount target.</p>
    ///
    /// <p>This operation forcibly breaks any mounts of the file system by using the mount target
    /// that is being deleted, which might disrupt instances or applications using those mounts. To
    /// avoid applications getting cut off abruptly, you might consider unmounting any mounts of the
    /// mount target, if feasible. The operation also deletes the associated network interface.
    /// Uncommitted writes might be lost, but breaking a mount target using this operation does not
    /// corrupt the file system itself. The file system you created remains. You can mount an EC2
    /// instance in your VPC by using another mount target.</p>
    /// <p>This operation requires permissions for the following action on the file
    /// system:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>elasticfilesystem:DeleteMountTarget</code>
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <p>The <code>DeleteMountTarget</code> call returns while the mount target state is still
    /// <code>deleting</code>. You can check the mount target deletion by calling the <a>DescribeMountTargets</a> operation, which returns a list of mount target
    /// descriptions for the given file system. </p>
    /// </note>
    ///
    /// <p>The operation also requires permissions for the following Amazon EC2 action on the
    /// mount target's network interface:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ec2:DeleteNetworkInterface</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMountTarget<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_mount_target_input::Builder,
    }
    impl<C, M, R> DeleteMountTarget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMountTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMountTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMountTargetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMountTargetInputOperationOutputAlias,
                crate::output::DeleteMountTargetOutput,
                crate::error::DeleteMountTargetError,
                crate::input::DeleteMountTargetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the mount target to delete (String).</p>
        pub fn mount_target_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mount_target_id(inp);
            self
        }
        /// <p>The ID of the mount target to delete (String).</p>
        pub fn set_mount_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mount_target_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTags`.
    ///
    /// <note>
    /// <p>DEPRECATED - DeleteTags is deprecated and not maintained. Please use the
    /// API action to remove tags from EFS resources.</p>
    /// </note>
    /// <p>Deletes the specified tags from a file system. If the <code>DeleteTags</code> request
    /// includes a tag key that doesn't exist, Amazon EFS ignores it and doesn't cause an
    /// error. For more information about tags and related restrictions, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Tag restrictions</a> in the
    /// <i>Billing and Cost Management User Guide</i>.</p>
    ///
    /// <p>This operation requires permissions for the <code>elasticfilesystem:DeleteTags</code>
    /// action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_tags_input::Builder,
    }
    impl<C, M, R> DeleteTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTagsInputOperationOutputAlias,
                crate::output::DeleteTagsOutput,
                crate::error::DeleteTagsError,
                crate::input::DeleteTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the file system whose tags you want to delete (String).</p>
        pub fn file_system_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(inp);
            self
        }
        /// <p>The ID of the file system whose tags you want to delete (String).</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to delete.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of tag keys to delete.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccessPoints`.
    ///
    /// <p>Returns the description of a specific Amazon EFS access point if the <code>AccessPointId</code> is provided.
    /// If you provide an EFS <code>FileSystemId</code>, it returns descriptions of all access points for that file system.
    /// You can provide either an <code>AccessPointId</code> or a <code>FileSystemId</code> in the request, but not both. </p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:DescribeAccessPoints</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAccessPoints<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_access_points_input::Builder,
    }
    impl<C, M, R> DescribeAccessPoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccessPoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccessPointsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccessPointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccessPointsInputOperationOutputAlias,
                crate::output::DescribeAccessPointsOutput,
                crate::error::DescribeAccessPointsError,
                crate::input::DescribeAccessPointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) When retrieving all access points for a file system,
        /// you can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response.  
        /// The default value is 100. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>(Optional) When retrieving all access points for a file system,
        /// you can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response.  
        /// The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// <code>NextToken</code> is present if the response is paginated. You can use <code>NextMarker</code> in the subsequent request to fetch the next page of access point descriptions.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// <code>NextToken</code> is present if the response is paginated. You can use <code>NextMarker</code> in the subsequent request to fetch the next page of access point descriptions.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>(Optional) Specifies an EFS access point to describe in the response; mutually exclusive with <code>FileSystemId</code>.</p>
        pub fn access_point_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_point_id(inp);
            self
        }
        /// <p>(Optional) Specifies an EFS access point to describe in the response; mutually exclusive with <code>FileSystemId</code>.</p>
        pub fn set_access_point_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_point_id(input);
            self
        }
        /// <p>(Optional) If you provide a <code>FileSystemId</code>, EFS returns all access points for that file system; mutually exclusive with <code>AccessPointId</code>.</p>
        pub fn file_system_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(inp);
            self
        }
        /// <p>(Optional) If you provide a <code>FileSystemId</code>, EFS returns all access points for that file system; mutually exclusive with <code>AccessPointId</code>.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountPreferences`.
    ///
    /// <p>Returns the account preferences settings for the Amazon Web Services account associated with the user making the request, in the current Amazon Web Services Region.
    /// For more information, see <a href="efs/latest/ug/manage-efs-resource-ids.html">Managing Amazon EFS resource IDs</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAccountPreferences<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_preferences_input::Builder,
    }
    impl<C, M, R> DescribeAccountPreferences<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountPreferences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountPreferencesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountPreferencesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountPreferencesInputOperationOutputAlias,
                crate::output::DescribeAccountPreferencesOutput,
                crate::error::DescribeAccountPreferencesError,
                crate::input::DescribeAccountPreferencesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) You can use <code>NextToken</code> in a subsequent request to fetch the next page of
        /// Amazon Web Services account preferences if the response payload was paginated.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>(Optional) You can use <code>NextToken</code> in a subsequent request to fetch the next page of
        /// Amazon Web Services account preferences if the response payload was paginated.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>(Optional) When retrieving account preferences,
        /// you can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response.  
        /// The default value is 100. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>(Optional) When retrieving account preferences,
        /// you can optionally specify the <code>MaxItems</code> parameter to limit the number of objects returned in a response.  
        /// The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBackupPolicy`.
    ///
    /// <p>Returns the backup policy for the specified EFS file system.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBackupPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_backup_policy_input::Builder,
    }
    impl<C, M, R> DescribeBackupPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBackupPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBackupPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBackupPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBackupPolicyInputOperationOutputAlias,
                crate::output::DescribeBackupPolicyOutput,
                crate::error::DescribeBackupPolicyError,
                crate::input::DescribeBackupPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies which EFS file system to retrieve the <code>BackupPolicy</code> for.</p>
        pub fn file_system_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(inp);
            self
        }
        /// <p>Specifies which EFS file system to retrieve the <code>BackupPolicy</code> for.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFileSystemPolicy`.
    ///
    /// <p>Returns the <code>FileSystemPolicy</code> for the specified EFS file system.</p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:DescribeFileSystemPolicy</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFileSystemPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_file_system_policy_input::Builder,
    }
    impl<C, M, R> DescribeFileSystemPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFileSystemPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFileSystemPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFileSystemPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFileSystemPolicyInputOperationOutputAlias,
                crate::output::DescribeFileSystemPolicyOutput,
                crate::error::DescribeFileSystemPolicyError,
                crate::input::DescribeFileSystemPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies which EFS file system to retrieve the <code>FileSystemPolicy</code> for.</p>
        pub fn file_system_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(inp);
            self
        }
        /// <p>Specifies which EFS file system to retrieve the <code>FileSystemPolicy</code> for.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFileSystems`.
    ///
    /// <p>Returns the description of a specific Amazon EFS file system if either the file system
    /// <code>CreationToken</code> or the <code>FileSystemId</code> is provided. Otherwise, it
    /// returns descriptions of all file systems owned by the caller's Amazon Web Services account in the
    /// Amazon Web Services Region of the endpoint that you're calling.</p>
    ///
    /// <p>When retrieving all file system descriptions, you can optionally specify the
    /// <code>MaxItems</code> parameter to limit the number of descriptions in a response.
    /// Currently, this number is automatically set to 10. If more file system descriptions remain,
    /// Amazon EFS returns a <code>NextMarker</code>, an opaque token, in the response. In this case,
    /// you should send a subsequent request with the <code>Marker</code> request parameter set to the
    /// value of <code>NextMarker</code>. </p>
    ///
    /// <p>To retrieve a list of your file system descriptions, this operation is used in an
    /// iterative process, where <code>DescribeFileSystems</code> is called first without the
    /// <code>Marker</code> and then the operation continues to call it with the <code>Marker</code>
    /// parameter set to the value of the <code>NextMarker</code> from the previous response until the
    /// response has no <code>NextMarker</code>. </p>
    ///
    /// <p> The order of file systems returned in the response of one
    /// <code>DescribeFileSystems</code> call and the order of file systems returned across the
    /// responses of a multi-call iteration is unspecified. </p>
    /// <p> This operation requires permissions for the
    /// <code>elasticfilesystem:DescribeFileSystems</code> action. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFileSystems<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_file_systems_input::Builder,
    }
    impl<C, M, R> DescribeFileSystems<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFileSystems`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFileSystemsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFileSystemsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFileSystemsInputOperationOutputAlias,
                crate::output::DescribeFileSystemsOutput,
                crate::error::DescribeFileSystemsError,
                crate::input::DescribeFileSystemsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) Specifies the maximum number of file systems to return in the response
        /// (integer). This number is automatically set to 100. The response is paginated at 100 per page if you have more than 100 file systems.
        /// </p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>(Optional) Specifies the maximum number of file systems to return in the response
        /// (integer). This number is automatically set to 100. The response is paginated at 100 per page if you have more than 100 file systems.
        /// </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous
        /// <code>DescribeFileSystems</code> operation (String). If present, specifies to continue the
        /// list from where the returning call had left off. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous
        /// <code>DescribeFileSystems</code> operation (String). If present, specifies to continue the
        /// list from where the returning call had left off. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>(Optional) Restricts the list to the file system with this creation token (String). You
        /// specify a creation token when you create an Amazon EFS file system.</p>
        pub fn creation_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.creation_token(inp);
            self
        }
        /// <p>(Optional) Restricts the list to the file system with this creation token (String). You
        /// specify a creation token when you create an Amazon EFS file system.</p>
        pub fn set_creation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_creation_token(input);
            self
        }
        /// <p>(Optional) ID of the file system whose description you want to retrieve
        /// (String).</p>
        pub fn file_system_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(inp);
            self
        }
        /// <p>(Optional) ID of the file system whose description you want to retrieve
        /// (String).</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLifecycleConfiguration`.
    ///
    /// <p>Returns the current <code>LifecycleConfiguration</code> object for the specified Amazon
    /// EFS file system. EFS lifecycle management uses the <code>LifecycleConfiguration</code> object
    /// to identify which files to move to the EFS Infrequent Access (IA) storage class. For a file system
    /// without a <code>LifecycleConfiguration</code> object, the call returns an empty array in the
    /// response.</p>
    /// <p>When EFS Intelligent Tiering is enabled, <code>TransitionToPrimaryStorageClass</code> has a value of <code>AFTER_1_ACCESS</code>.</p>
    /// <p>This operation requires permissions for the
    /// <code>elasticfilesystem:DescribeLifecycleConfiguration</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLifecycleConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_lifecycle_configuration_input::Builder,
    }
    impl<C, M, R> DescribeLifecycleConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLifecycleConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLifecycleConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLifecycleConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLifecycleConfigurationInputOperationOutputAlias,
                crate::output::DescribeLifecycleConfigurationOutput,
                crate::error::DescribeLifecycleConfigurationError,
                crate::input::DescribeLifecycleConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the file system whose <code>LifecycleConfiguration</code> object you want to
        /// retrieve (String).</p>
        pub fn file_system_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(inp);
            self
        }
        /// <p>The ID of the file system whose <code>LifecycleConfiguration</code> object you want to
        /// retrieve (String).</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMountTargets`.
    ///
    /// <p>Returns the descriptions of all the current mount targets, or a specific mount target,
    /// for a file system. When requesting all of the current mount targets, the order of mount
    /// targets returned in the response is unspecified.</p>
    ///
    /// <p>This operation requires permissions for the
    /// <code>elasticfilesystem:DescribeMountTargets</code> action, on either the file system ID
    /// that you specify in <code>FileSystemId</code>, or on the file system of the mount target that
    /// you specify in <code>MountTargetId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeMountTargets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_mount_targets_input::Builder,
    }
    impl<C, M, R> DescribeMountTargets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMountTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMountTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMountTargetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMountTargetsInputOperationOutputAlias,
                crate::output::DescribeMountTargetsOutput,
                crate::error::DescribeMountTargetsError,
                crate::input::DescribeMountTargetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) Maximum number of mount targets to return in the response. Currently, this
        /// number is automatically set to
        /// 10, and other values are ignored. The response is paginated at 100 per page if you have more than 100 mount targets.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>(Optional) Maximum number of mount targets to return in the response. Currently, this
        /// number is automatically set to
        /// 10, and other values are ignored. The response is paginated at 100 per page if you have more than 100 mount targets.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous
        /// <code>DescribeMountTargets</code> operation (String). If present, it specifies to continue
        /// the list from where the previous returning call left off.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>(Optional) Opaque pagination token returned from a previous
        /// <code>DescribeMountTargets</code> operation (String). If present, it specifies to continue
        /// the list from where the previous returning call left off.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>(Optional) ID of the file system whose mount targets you want to list (String). It must
        /// be included in your request if an <code>AccessPointId</code> or <code>MountTargetId</code> is not included. Accepts either a file system ID or ARN as input.</p>
        pub fn file_system_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(inp);
            self
        }
        /// <p>(Optional) ID of the file system whose mount targets you want to list (String). It must
        /// be included in your request if an <code>AccessPointId</code> or <code>MountTargetId</code> is not included. Accepts either a file system ID or ARN as input.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>(Optional) ID of the mount target that you want to have described (String). It must be
        /// included in your request if <code>FileSystemId</code> is not included. Accepts either a mount target ID or ARN as input.</p>
        pub fn mount_target_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mount_target_id(inp);
            self
        }
        /// <p>(Optional) ID of the mount target that you want to have described (String). It must be
        /// included in your request if <code>FileSystemId</code> is not included. Accepts either a mount target ID or ARN as input.</p>
        pub fn set_mount_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mount_target_id(input);
            self
        }
        /// <p>(Optional) The ID of the access point whose mount targets that you want to list. It must be included in your request if a
        /// <code>FileSystemId</code> or <code>MountTargetId</code> is not included in your request. Accepts either an access point ID or ARN as input.</p>
        pub fn access_point_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_point_id(inp);
            self
        }
        /// <p>(Optional) The ID of the access point whose mount targets that you want to list. It must be included in your request if a
        /// <code>FileSystemId</code> or <code>MountTargetId</code> is not included in your request. Accepts either an access point ID or ARN as input.</p>
        pub fn set_access_point_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_point_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMountTargetSecurityGroups`.
    ///
    /// <p>Returns the security groups currently in effect for a mount target. This operation
    /// requires that the network interface of the mount target has been created and the lifecycle
    /// state of the mount target is not <code>deleted</code>.</p>
    /// <p>This operation requires permissions for the following actions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>elasticfilesystem:DescribeMountTargetSecurityGroups</code> action on the mount
    /// target's file system. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:DescribeNetworkInterfaceAttribute</code> action on the mount target's
    /// network interface. </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DescribeMountTargetSecurityGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_mount_target_security_groups_input::Builder,
    }
    impl<C, M, R> DescribeMountTargetSecurityGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMountTargetSecurityGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMountTargetSecurityGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMountTargetSecurityGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMountTargetSecurityGroupsInputOperationOutputAlias,
                crate::output::DescribeMountTargetSecurityGroupsOutput,
                crate::error::DescribeMountTargetSecurityGroupsError,
                crate::input::DescribeMountTargetSecurityGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the mount target whose security groups you want to retrieve.</p>
        pub fn mount_target_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mount_target_id(inp);
            self
        }
        /// <p>The ID of the mount target whose security groups you want to retrieve.</p>
        pub fn set_mount_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mount_target_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTags`.
    ///
    /// <note>
    /// <p>DEPRECATED - The DeleteTags action is deprecated and not maintained. Please use the
    /// API action to remove tags from EFS resources.</p>
    /// </note>
    /// <p>Returns the tags associated with a file system. The order of tags returned in the
    /// response of one <code>DescribeTags</code> call and the order of tags returned across the
    /// responses of a multiple-call iteration (when using pagination) is unspecified. </p>
    /// <p> This operation requires permissions for the
    /// <code>elasticfilesystem:DescribeTags</code> action. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_tags_input::Builder,
    }
    impl<C, M, R> DescribeTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTagsInputOperationOutputAlias,
                crate::output::DescribeTagsOutput,
                crate::error::DescribeTagsError,
                crate::input::DescribeTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>(Optional) The maximum number of file system tags to return in the response. Currently,
        /// this number is automatically set to
        /// 100, and other values are ignored. The response is paginated at 100 per page if you have more than 100 tags.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>(Optional) The maximum number of file system tags to return in the response. Currently,
        /// this number is automatically set to
        /// 100, and other values are ignored. The response is paginated at 100 per page if you have more than 100 tags.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>(Optional) An opaque pagination token returned from a previous
        /// <code>DescribeTags</code> operation (String). If present, it specifies to continue the list
        /// from where the previous call left off.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>(Optional) An opaque pagination token returned from a previous
        /// <code>DescribeTags</code> operation (String). If present, it specifies to continue the list
        /// from where the previous call left off.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The ID of the file system whose tag set you want to retrieve.</p>
        pub fn file_system_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(inp);
            self
        }
        /// <p>The ID of the file system whose tag set you want to retrieve.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags for a top-level EFS resource. You must provide the ID of the resource that you want to retrieve the tags for.</p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:DescribeAccessPoints</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the EFS resource you want to retrieve tags for. You can retrieve tags for EFS file systems and access points using this API endpoint.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>Specifies the EFS resource you want to retrieve tags for. You can retrieve tags for EFS file systems and access points using this API endpoint.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>(Optional) Specifies the maximum number of tag objects to return in the response. The default value is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>(Optional) Specifies the maximum number of tag objects to return in the response. The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>(Optional) You can use <code>NextToken</code> in a subsequent request to fetch the next page of access point descriptions if the response payload was paginated.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>(Optional) You can use <code>NextToken</code> in a subsequent request to fetch the next page of access point descriptions if the response payload was paginated.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyMountTargetSecurityGroups`.
    ///
    /// <p>Modifies the set of security groups in effect for a mount target.</p>
    /// <p>When you create a mount target, Amazon EFS also creates a new network interface. For
    /// more information, see <a>CreateMountTarget</a>. This operation replaces the security groups in effect for the
    /// network interface associated with a mount target, with the <code>SecurityGroups</code>
    /// provided in the request. This operation requires that the network interface of the mount
    /// target has been created and the lifecycle state of the mount target is not
    /// <code>deleted</code>. </p>
    /// <p>The operation requires permissions for the following actions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>elasticfilesystem:ModifyMountTargetSecurityGroups</code> action on the mount
    /// target's file system. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ec2:ModifyNetworkInterfaceAttribute</code> action on the mount target's network
    /// interface. </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct ModifyMountTargetSecurityGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_mount_target_security_groups_input::Builder,
    }
    impl<C, M, R> ModifyMountTargetSecurityGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyMountTargetSecurityGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyMountTargetSecurityGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyMountTargetSecurityGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyMountTargetSecurityGroupsInputOperationOutputAlias,
                crate::output::ModifyMountTargetSecurityGroupsOutput,
                crate::error::ModifyMountTargetSecurityGroupsError,
                crate::input::ModifyMountTargetSecurityGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the mount target whose security groups you want to modify.</p>
        pub fn mount_target_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mount_target_id(inp);
            self
        }
        /// <p>The ID of the mount target whose security groups you want to modify.</p>
        pub fn set_mount_target_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mount_target_id(input);
            self
        }
        /// Appends an item to `SecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>An array of up to five VPC security group IDs.</p>
        pub fn security_groups(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_groups(inp);
            self
        }
        /// <p>An array of up to five VPC security group IDs.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccountPreferences`.
    ///
    /// <p>Use this operation to set the account preference in the current Amazon Web Services Region to use long 17 character (63 bit) or short 8 character (32 bit) resource IDs for
    /// new EFS file system and mount target resources. All existing resource IDs are not affected by any changes you make. You can set the ID preference during the
    /// opt-in period as EFS transitions to long resource IDs. For more information,
    /// see <a href="https://docs.aws.amazon.com/efs/latest/ug/manage-efs-resource-ids.html">Managing Amazon EFS resource IDs</a>.</p>
    /// <note>
    /// <p>Starting in October, 2021, you will receive an error if you try to set the account preference to use the short 8 character format resource ID.
    /// Contact Amazon Web Services support if you receive an error and need to use short IDs for file system and mount target resources.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct PutAccountPreferences<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_account_preferences_input::Builder,
    }
    impl<C, M, R> PutAccountPreferences<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAccountPreferences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccountPreferencesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAccountPreferencesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAccountPreferencesInputOperationOutputAlias,
                crate::output::PutAccountPreferencesOutput,
                crate::error::PutAccountPreferencesError,
                crate::input::PutAccountPreferencesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the EFS resource ID preference to set for the user's Amazon Web Services account, in the current Amazon Web Services Region,
        /// either <code>LONG_ID</code> (17 characters), or <code>SHORT_ID</code> (8 characters).</p>
        /// <note>
        /// <p>Starting in October, 2021, you will receive an error when setting the account preference to <code>SHORT_ID</code>.
        /// Contact Amazon Web Services support if you receive an error and need to use short IDs for file system and mount target resources.</p>
        /// </note>
        pub fn resource_id_type(mut self, inp: crate::model::ResourceIdType) -> Self {
            self.inner = self.inner.resource_id_type(inp);
            self
        }
        /// <p>Specifies the EFS resource ID preference to set for the user's Amazon Web Services account, in the current Amazon Web Services Region,
        /// either <code>LONG_ID</code> (17 characters), or <code>SHORT_ID</code> (8 characters).</p>
        /// <note>
        /// <p>Starting in October, 2021, you will receive an error when setting the account preference to <code>SHORT_ID</code>.
        /// Contact Amazon Web Services support if you receive an error and need to use short IDs for file system and mount target resources.</p>
        /// </note>
        pub fn set_resource_id_type(
            mut self,
            input: std::option::Option<crate::model::ResourceIdType>,
        ) -> Self {
            self.inner = self.inner.set_resource_id_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBackupPolicy`.
    ///
    /// <p>Updates the file system's backup policy. Use this action to start or stop automatic backups of the file system. </p>
    #[derive(std::fmt::Debug)]
    pub struct PutBackupPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_backup_policy_input::Builder,
    }
    impl<C, M, R> PutBackupPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutBackupPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBackupPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBackupPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutBackupPolicyInputOperationOutputAlias,
                crate::output::PutBackupPolicyOutput,
                crate::error::PutBackupPolicyError,
                crate::input::PutBackupPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies which EFS file system to update the backup policy for.</p>
        pub fn file_system_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(inp);
            self
        }
        /// <p>Specifies which EFS file system to update the backup policy for.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>The backup policy included in the <code>PutBackupPolicy</code> request.</p>
        pub fn backup_policy(mut self, inp: crate::model::BackupPolicy) -> Self {
            self.inner = self.inner.backup_policy(inp);
            self
        }
        /// <p>The backup policy included in the <code>PutBackupPolicy</code> request.</p>
        pub fn set_backup_policy(
            mut self,
            input: std::option::Option<crate::model::BackupPolicy>,
        ) -> Self {
            self.inner = self.inner.set_backup_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutFileSystemPolicy`.
    ///
    /// <p>Applies an Amazon EFS <code>FileSystemPolicy</code> to an Amazon EFS file system.
    /// A file system policy is an IAM resource-based policy and can contain multiple policy statements.
    /// A file system always has exactly one file system policy, which can be the default policy or
    /// an explicit policy set or updated using this API operation.
    /// EFS file system policies have a 20,000 character limit.
    /// When an explicit policy is set, it overrides the default policy. For more information about the default file system policy, see
    /// <a href="https://docs.aws.amazon.com/efs/latest/ug/iam-access-control-nfs-efs.html#default-filesystempolicy">Default EFS File System Policy</a>.
    /// </p>
    /// <note>
    /// <p>EFS file system policies have a 20,000 character limit.</p>
    /// </note>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:PutFileSystemPolicy</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutFileSystemPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_file_system_policy_input::Builder,
    }
    impl<C, M, R> PutFileSystemPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutFileSystemPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutFileSystemPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutFileSystemPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutFileSystemPolicyInputOperationOutputAlias,
                crate::output::PutFileSystemPolicyOutput,
                crate::error::PutFileSystemPolicyError,
                crate::input::PutFileSystemPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the EFS file system that you want to create or update the <code>FileSystemPolicy</code> for.</p>
        pub fn file_system_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(inp);
            self
        }
        /// <p>The ID of the EFS file system that you want to create or update the <code>FileSystemPolicy</code> for.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>The <code>FileSystemPolicy</code> that you're creating. Accepts a JSON formatted policy definition.
        /// EFS file system policies have a 20,000 character limit.
        /// To find out more about the elements that make up a file system policy, see
        /// <a href="https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies">EFS Resource-based Policies</a>.
        /// </p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p>The <code>FileSystemPolicy</code> that you're creating. Accepts a JSON formatted policy definition.
        /// EFS file system policies have a 20,000 character limit.
        /// To find out more about the elements that make up a file system policy, see
        /// <a href="https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies">EFS Resource-based Policies</a>.
        /// </p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// <p>(Optional) A flag to indicate whether to bypass the <code>FileSystemPolicy</code> lockout safety check. The policy lockout safety check
        /// determines whether the policy in the request will prevent the principal making the request will be locked out from making future <code>PutFileSystemPolicy</code> requests on the file system.
        /// Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent
        /// the principal that is making the request from making a subsequent <code>PutFileSystemPolicy</code> request on the file system.
        /// The default value is False.
        /// </p>
        pub fn bypass_policy_lockout_safety_check(mut self, inp: bool) -> Self {
            self.inner = self.inner.bypass_policy_lockout_safety_check(inp);
            self
        }
        /// <p>(Optional) A flag to indicate whether to bypass the <code>FileSystemPolicy</code> lockout safety check. The policy lockout safety check
        /// determines whether the policy in the request will prevent the principal making the request will be locked out from making future <code>PutFileSystemPolicy</code> requests on the file system.
        /// Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent
        /// the principal that is making the request from making a subsequent <code>PutFileSystemPolicy</code> request on the file system.
        /// The default value is False.
        /// </p>
        pub fn set_bypass_policy_lockout_safety_check(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_bypass_policy_lockout_safety_check(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLifecycleConfiguration`.
    ///
    /// <p>Enables lifecycle management by creating a new <code>LifecycleConfiguration</code>
    /// object. A <code>LifecycleConfiguration</code> object defines when files in an Amazon EFS file
    /// system are automatically transitioned to the lower-cost EFS Infrequent Access (IA) storage class.
    /// To enable EFS Intelligent Tiering, set the value of <code>TransitionToPrimaryStorageClass</code> to <code>AFTER_1_ACCESS</code>.
    /// For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/lifecycle-management-efs.html">EFS Lifecycle Management</a>.</p>
    ///
    /// <p>Each Amazon EFS file system supports one lifecycle configuration, which applies to all files in the file system. If a
    /// <code>LifecycleConfiguration</code> object already exists for the specified file system, a
    /// <code>PutLifecycleConfiguration</code> call modifies the existing configuration. A
    /// <code>PutLifecycleConfiguration</code> call with an empty <code>LifecyclePolicies</code>
    /// array in the request body deletes any existing <code>LifecycleConfiguration</code> and
    /// turns off lifecycle management for the file system.</p>
    ///
    ///
    /// <p>In the request, specify the following: </p>
    /// <ul>
    /// <li>
    /// <p>The ID for the file system for which you are enabling, disabling, or modifying lifecycle management.</p>
    /// </li>
    /// <li>
    /// <p>A <code>LifecyclePolicies</code> array of <code>LifecyclePolicy</code> objects that
    /// define when files are moved to the IA storage class. Amazon EFS requires that each <code>LifecyclePolicy</code>
    /// object have only have a single transition, so the <code>LifecyclePolicies</code> array needs to be structured with separate
    /// <code>LifecyclePolicy</code> objects. See the example requests in the following section for more information.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>This operation requires permissions for the
    /// <code>elasticfilesystem:PutLifecycleConfiguration</code> operation.</p>
    /// <p>To apply a <code>LifecycleConfiguration</code> object to an encrypted file system, you
    /// need the same Key Management Service permissions as when you created the encrypted
    /// file system. </p>
    #[derive(std::fmt::Debug)]
    pub struct PutLifecycleConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_lifecycle_configuration_input::Builder,
    }
    impl<C, M, R> PutLifecycleConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutLifecycleConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLifecycleConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLifecycleConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutLifecycleConfigurationInputOperationOutputAlias,
                crate::output::PutLifecycleConfigurationOutput,
                crate::error::PutLifecycleConfigurationError,
                crate::input::PutLifecycleConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the file system for which you are creating the
        /// <code>LifecycleConfiguration</code> object (String).</p>
        pub fn file_system_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(inp);
            self
        }
        /// <p>The ID of the file system for which you are creating the
        /// <code>LifecycleConfiguration</code> object (String).</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// Appends an item to `LifecyclePolicies`.
        ///
        /// To override the contents of this collection use [`set_lifecycle_policies`](Self::set_lifecycle_policies).
        ///
        /// <p>An array of <code>LifecyclePolicy</code> objects that define the file system's
        /// <code>LifecycleConfiguration</code> object. A <code>LifecycleConfiguration</code> object
        /// informs EFS lifecycle management and intelligent tiering of the following:</p>
        /// <ul>
        /// <li>
        /// <p>When to move files in the file system from primary storage to the IA storage class.</p>
        /// </li>
        /// <li>
        /// <p>When to move files that are in IA storage to primary storage.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>When using the <code>put-lifecycle-configuration</code> CLI command or the <code>PutLifecycleConfiguration</code> API action,
        /// Amazon EFS requires that each <code>LifecyclePolicy</code>
        /// object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as
        /// an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code>, <code>TransitionToPrimaryStorageClass</code>.
        /// See the example requests in the following section for more information.</p>
        /// </note>
        pub fn lifecycle_policies(mut self, inp: impl Into<crate::model::LifecyclePolicy>) -> Self {
            self.inner = self.inner.lifecycle_policies(inp);
            self
        }
        /// <p>An array of <code>LifecyclePolicy</code> objects that define the file system's
        /// <code>LifecycleConfiguration</code> object. A <code>LifecycleConfiguration</code> object
        /// informs EFS lifecycle management and intelligent tiering of the following:</p>
        /// <ul>
        /// <li>
        /// <p>When to move files in the file system from primary storage to the IA storage class.</p>
        /// </li>
        /// <li>
        /// <p>When to move files that are in IA storage to primary storage.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>When using the <code>put-lifecycle-configuration</code> CLI command or the <code>PutLifecycleConfiguration</code> API action,
        /// Amazon EFS requires that each <code>LifecyclePolicy</code>
        /// object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as
        /// an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code>, <code>TransitionToPrimaryStorageClass</code>.
        /// See the example requests in the following section for more information.</p>
        /// </note>
        pub fn set_lifecycle_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LifecyclePolicy>>,
        ) -> Self {
            self.inner = self.inner.set_lifecycle_policies(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Creates a tag for an EFS resource. You can create tags for EFS file systems and access points using this API operation.</p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:TagResource</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID specifying the EFS resource that you want to create a tag for.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The ID specifying the EFS resource that you want to create a tag for.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value
        /// pair.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>An array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value
        /// pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from an EFS resource. You can remove tags from EFS file systems and access points using this API operation.</p>
    /// <p>This operation requires permissions for the <code>elasticfilesystem:UntagResource</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the EFS resource that you want to remove tags from.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>Specifies the EFS resource that you want to remove tags from.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the key-value tag pairs that you want to remove from the specified EFS
        /// resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The keys of the key-value tag pairs that you want to remove from the specified EFS
        /// resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFileSystem`.
    ///
    /// <p>Updates the throughput mode or the amount of provisioned throughput of an existing file
    /// system.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFileSystem<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_file_system_input::Builder,
    }
    impl<C, M, R> UpdateFileSystem<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFileSystem`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFileSystemOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFileSystemError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFileSystemInputOperationOutputAlias,
                crate::output::UpdateFileSystemOutput,
                crate::error::UpdateFileSystemError,
                crate::input::UpdateFileSystemInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the file system that you want to update.</p>
        pub fn file_system_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_system_id(inp);
            self
        }
        /// <p>The ID of the file system that you want to update.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_system_id(input);
            self
        }
        /// <p>(Optional) Updates the file system's throughput mode. If you're not
        /// updating your throughput mode, you don't need to provide this value in your
        /// request. If you are changing the <code>ThroughputMode</code> to <code>provisioned</code>,
        /// you must also set a value for <code>ProvisionedThroughputInMibps</code>.</p>
        pub fn throughput_mode(mut self, inp: crate::model::ThroughputMode) -> Self {
            self.inner = self.inner.throughput_mode(inp);
            self
        }
        /// <p>(Optional) Updates the file system's throughput mode. If you're not
        /// updating your throughput mode, you don't need to provide this value in your
        /// request. If you are changing the <code>ThroughputMode</code> to <code>provisioned</code>,
        /// you must also set a value for <code>ProvisionedThroughputInMibps</code>.</p>
        pub fn set_throughput_mode(
            mut self,
            input: std::option::Option<crate::model::ThroughputMode>,
        ) -> Self {
            self.inner = self.inner.set_throughput_mode(input);
            self
        }
        /// <p>(Optional) Sets the amount of provisioned throughput, in MiB/s, for the file
        /// system. Valid values are 1-1024. If you are changing the throughput mode to provisioned, you must also
        /// provide the amount of provisioned throughput. Required if <code>ThroughputMode</code> is changed
        /// to <code>provisioned</code> on update.</p>
        pub fn provisioned_throughput_in_mibps(mut self, inp: f64) -> Self {
            self.inner = self.inner.provisioned_throughput_in_mibps(inp);
            self
        }
        /// <p>(Optional) Sets the amount of provisioned throughput, in MiB/s, for the file
        /// system. Valid values are 1-1024. If you are changing the throughput mode to provisioned, you must also
        /// provide the amount of provisioned throughput. Required if <code>ThroughputMode</code> is changed
        /// to <code>provisioned</code> on update.</p>
        pub fn set_provisioned_throughput_in_mibps(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_throughput_in_mibps(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
