// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateCapacityProvider`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_capacity_provider`](crate::client::Client::create_capacity_provider).
///
/// See [`crate::client::fluent_builders::CreateCapacityProvider`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCapacityProvider {
    _private: (),
}
impl CreateCapacityProvider {
    /// Creates a new builder-style object to manufacture [`CreateCapacityProviderInput`](crate::input::CreateCapacityProviderInput)
    pub fn builder() -> crate::input::create_capacity_provider_input::Builder {
        crate::input::create_capacity_provider_input::Builder::default()
    }
    /// Creates a new `CreateCapacityProvider` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCapacityProvider {
    type Output = std::result::Result<
        crate::output::CreateCapacityProviderOutput,
        crate::error::CreateCapacityProviderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_capacity_provider_error(response)
        } else {
            crate::operation_deser::parse_create_capacity_provider_response(response)
        }
    }
}

/// Operation shape for `CreateCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cluster`](crate::client::Client::create_cluster).
///
/// See [`crate::client::fluent_builders::CreateCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCluster {
    _private: (),
}
impl CreateCluster {
    /// Creates a new builder-style object to manufacture [`CreateClusterInput`](crate::input::CreateClusterInput)
    pub fn builder() -> crate::input::create_cluster_input::Builder {
        crate::input::create_cluster_input::Builder::default()
    }
    /// Creates a new `CreateCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCluster {
    type Output =
        std::result::Result<crate::output::CreateClusterOutput, crate::error::CreateClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_cluster_error(response)
        } else {
            crate::operation_deser::parse_create_cluster_response(response)
        }
    }
}

/// Operation shape for `CreateService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_service`](crate::client::Client::create_service).
///
/// See [`crate::client::fluent_builders::CreateService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateService {
    _private: (),
}
impl CreateService {
    /// Creates a new builder-style object to manufacture [`CreateServiceInput`](crate::input::CreateServiceInput)
    pub fn builder() -> crate::input::create_service_input::Builder {
        crate::input::create_service_input::Builder::default()
    }
    /// Creates a new `CreateService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateService {
    type Output =
        std::result::Result<crate::output::CreateServiceOutput, crate::error::CreateServiceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_service_error(response)
        } else {
            crate::operation_deser::parse_create_service_response(response)
        }
    }
}

/// Operation shape for `CreateTaskSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_task_set`](crate::client::Client::create_task_set).
///
/// See [`crate::client::fluent_builders::CreateTaskSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTaskSet {
    _private: (),
}
impl CreateTaskSet {
    /// Creates a new builder-style object to manufacture [`CreateTaskSetInput`](crate::input::CreateTaskSetInput)
    pub fn builder() -> crate::input::create_task_set_input::Builder {
        crate::input::create_task_set_input::Builder::default()
    }
    /// Creates a new `CreateTaskSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTaskSet {
    type Output =
        std::result::Result<crate::output::CreateTaskSetOutput, crate::error::CreateTaskSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_task_set_error(response)
        } else {
            crate::operation_deser::parse_create_task_set_response(response)
        }
    }
}

/// Operation shape for `DeleteAccountSetting`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_account_setting`](crate::client::Client::delete_account_setting).
///
/// See [`crate::client::fluent_builders::DeleteAccountSetting`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAccountSetting {
    _private: (),
}
impl DeleteAccountSetting {
    /// Creates a new builder-style object to manufacture [`DeleteAccountSettingInput`](crate::input::DeleteAccountSettingInput)
    pub fn builder() -> crate::input::delete_account_setting_input::Builder {
        crate::input::delete_account_setting_input::Builder::default()
    }
    /// Creates a new `DeleteAccountSetting` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAccountSetting {
    type Output = std::result::Result<
        crate::output::DeleteAccountSettingOutput,
        crate::error::DeleteAccountSettingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_account_setting_error(response)
        } else {
            crate::operation_deser::parse_delete_account_setting_response(response)
        }
    }
}

/// Operation shape for `DeleteAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_attributes`](crate::client::Client::delete_attributes).
///
/// See [`crate::client::fluent_builders::DeleteAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAttributes {
    _private: (),
}
impl DeleteAttributes {
    /// Creates a new builder-style object to manufacture [`DeleteAttributesInput`](crate::input::DeleteAttributesInput)
    pub fn builder() -> crate::input::delete_attributes_input::Builder {
        crate::input::delete_attributes_input::Builder::default()
    }
    /// Creates a new `DeleteAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAttributes {
    type Output = std::result::Result<
        crate::output::DeleteAttributesOutput,
        crate::error::DeleteAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_attributes_error(response)
        } else {
            crate::operation_deser::parse_delete_attributes_response(response)
        }
    }
}

/// Operation shape for `DeleteCapacityProvider`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_capacity_provider`](crate::client::Client::delete_capacity_provider).
///
/// See [`crate::client::fluent_builders::DeleteCapacityProvider`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCapacityProvider {
    _private: (),
}
impl DeleteCapacityProvider {
    /// Creates a new builder-style object to manufacture [`DeleteCapacityProviderInput`](crate::input::DeleteCapacityProviderInput)
    pub fn builder() -> crate::input::delete_capacity_provider_input::Builder {
        crate::input::delete_capacity_provider_input::Builder::default()
    }
    /// Creates a new `DeleteCapacityProvider` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCapacityProvider {
    type Output = std::result::Result<
        crate::output::DeleteCapacityProviderOutput,
        crate::error::DeleteCapacityProviderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_capacity_provider_error(response)
        } else {
            crate::operation_deser::parse_delete_capacity_provider_response(response)
        }
    }
}

/// Operation shape for `DeleteCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_cluster`](crate::client::Client::delete_cluster).
///
/// See [`crate::client::fluent_builders::DeleteCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCluster {
    _private: (),
}
impl DeleteCluster {
    /// Creates a new builder-style object to manufacture [`DeleteClusterInput`](crate::input::DeleteClusterInput)
    pub fn builder() -> crate::input::delete_cluster_input::Builder {
        crate::input::delete_cluster_input::Builder::default()
    }
    /// Creates a new `DeleteCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCluster {
    type Output =
        std::result::Result<crate::output::DeleteClusterOutput, crate::error::DeleteClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_cluster_error(response)
        } else {
            crate::operation_deser::parse_delete_cluster_response(response)
        }
    }
}

/// Operation shape for `DeleteService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_service`](crate::client::Client::delete_service).
///
/// See [`crate::client::fluent_builders::DeleteService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteService {
    _private: (),
}
impl DeleteService {
    /// Creates a new builder-style object to manufacture [`DeleteServiceInput`](crate::input::DeleteServiceInput)
    pub fn builder() -> crate::input::delete_service_input::Builder {
        crate::input::delete_service_input::Builder::default()
    }
    /// Creates a new `DeleteService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteService {
    type Output =
        std::result::Result<crate::output::DeleteServiceOutput, crate::error::DeleteServiceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_service_error(response)
        } else {
            crate::operation_deser::parse_delete_service_response(response)
        }
    }
}

/// Operation shape for `DeleteTaskSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_task_set`](crate::client::Client::delete_task_set).
///
/// See [`crate::client::fluent_builders::DeleteTaskSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTaskSet {
    _private: (),
}
impl DeleteTaskSet {
    /// Creates a new builder-style object to manufacture [`DeleteTaskSetInput`](crate::input::DeleteTaskSetInput)
    pub fn builder() -> crate::input::delete_task_set_input::Builder {
        crate::input::delete_task_set_input::Builder::default()
    }
    /// Creates a new `DeleteTaskSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTaskSet {
    type Output =
        std::result::Result<crate::output::DeleteTaskSetOutput, crate::error::DeleteTaskSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_task_set_error(response)
        } else {
            crate::operation_deser::parse_delete_task_set_response(response)
        }
    }
}

/// Operation shape for `DeregisterContainerInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_container_instance`](crate::client::Client::deregister_container_instance).
///
/// See [`crate::client::fluent_builders::DeregisterContainerInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterContainerInstance {
    _private: (),
}
impl DeregisterContainerInstance {
    /// Creates a new builder-style object to manufacture [`DeregisterContainerInstanceInput`](crate::input::DeregisterContainerInstanceInput)
    pub fn builder() -> crate::input::deregister_container_instance_input::Builder {
        crate::input::deregister_container_instance_input::Builder::default()
    }
    /// Creates a new `DeregisterContainerInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterContainerInstance {
    type Output = std::result::Result<
        crate::output::DeregisterContainerInstanceOutput,
        crate::error::DeregisterContainerInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_container_instance_error(response)
        } else {
            crate::operation_deser::parse_deregister_container_instance_response(response)
        }
    }
}

/// Operation shape for `DeregisterTaskDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_task_definition`](crate::client::Client::deregister_task_definition).
///
/// See [`crate::client::fluent_builders::DeregisterTaskDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterTaskDefinition {
    _private: (),
}
impl DeregisterTaskDefinition {
    /// Creates a new builder-style object to manufacture [`DeregisterTaskDefinitionInput`](crate::input::DeregisterTaskDefinitionInput)
    pub fn builder() -> crate::input::deregister_task_definition_input::Builder {
        crate::input::deregister_task_definition_input::Builder::default()
    }
    /// Creates a new `DeregisterTaskDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterTaskDefinition {
    type Output = std::result::Result<
        crate::output::DeregisterTaskDefinitionOutput,
        crate::error::DeregisterTaskDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_task_definition_error(response)
        } else {
            crate::operation_deser::parse_deregister_task_definition_response(response)
        }
    }
}

/// Operation shape for `DescribeCapacityProviders`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_capacity_providers`](crate::client::Client::describe_capacity_providers).
///
/// See [`crate::client::fluent_builders::DescribeCapacityProviders`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCapacityProviders {
    _private: (),
}
impl DescribeCapacityProviders {
    /// Creates a new builder-style object to manufacture [`DescribeCapacityProvidersInput`](crate::input::DescribeCapacityProvidersInput)
    pub fn builder() -> crate::input::describe_capacity_providers_input::Builder {
        crate::input::describe_capacity_providers_input::Builder::default()
    }
    /// Creates a new `DescribeCapacityProviders` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCapacityProviders {
    type Output = std::result::Result<
        crate::output::DescribeCapacityProvidersOutput,
        crate::error::DescribeCapacityProvidersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_capacity_providers_error(response)
        } else {
            crate::operation_deser::parse_describe_capacity_providers_response(response)
        }
    }
}

/// Operation shape for `DescribeClusters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_clusters`](crate::client::Client::describe_clusters).
///
/// See [`crate::client::fluent_builders::DescribeClusters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClusters {
    _private: (),
}
impl DescribeClusters {
    /// Creates a new builder-style object to manufacture [`DescribeClustersInput`](crate::input::DescribeClustersInput)
    pub fn builder() -> crate::input::describe_clusters_input::Builder {
        crate::input::describe_clusters_input::Builder::default()
    }
    /// Creates a new `DescribeClusters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClusters {
    type Output = std::result::Result<
        crate::output::DescribeClustersOutput,
        crate::error::DescribeClustersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_clusters_error(response)
        } else {
            crate::operation_deser::parse_describe_clusters_response(response)
        }
    }
}

/// Operation shape for `DescribeContainerInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_container_instances`](crate::client::Client::describe_container_instances).
///
/// See [`crate::client::fluent_builders::DescribeContainerInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeContainerInstances {
    _private: (),
}
impl DescribeContainerInstances {
    /// Creates a new builder-style object to manufacture [`DescribeContainerInstancesInput`](crate::input::DescribeContainerInstancesInput)
    pub fn builder() -> crate::input::describe_container_instances_input::Builder {
        crate::input::describe_container_instances_input::Builder::default()
    }
    /// Creates a new `DescribeContainerInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeContainerInstances {
    type Output = std::result::Result<
        crate::output::DescribeContainerInstancesOutput,
        crate::error::DescribeContainerInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_container_instances_error(response)
        } else {
            crate::operation_deser::parse_describe_container_instances_response(response)
        }
    }
}

/// Operation shape for `DescribeServices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_services`](crate::client::Client::describe_services).
///
/// See [`crate::client::fluent_builders::DescribeServices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeServices {
    _private: (),
}
impl DescribeServices {
    /// Creates a new builder-style object to manufacture [`DescribeServicesInput`](crate::input::DescribeServicesInput)
    pub fn builder() -> crate::input::describe_services_input::Builder {
        crate::input::describe_services_input::Builder::default()
    }
    /// Creates a new `DescribeServices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeServices {
    type Output = std::result::Result<
        crate::output::DescribeServicesOutput,
        crate::error::DescribeServicesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_services_error(response)
        } else {
            crate::operation_deser::parse_describe_services_response(response)
        }
    }
}

/// Operation shape for `DescribeTaskDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_task_definition`](crate::client::Client::describe_task_definition).
///
/// See [`crate::client::fluent_builders::DescribeTaskDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTaskDefinition {
    _private: (),
}
impl DescribeTaskDefinition {
    /// Creates a new builder-style object to manufacture [`DescribeTaskDefinitionInput`](crate::input::DescribeTaskDefinitionInput)
    pub fn builder() -> crate::input::describe_task_definition_input::Builder {
        crate::input::describe_task_definition_input::Builder::default()
    }
    /// Creates a new `DescribeTaskDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTaskDefinition {
    type Output = std::result::Result<
        crate::output::DescribeTaskDefinitionOutput,
        crate::error::DescribeTaskDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_task_definition_error(response)
        } else {
            crate::operation_deser::parse_describe_task_definition_response(response)
        }
    }
}

/// Operation shape for `DescribeTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_tasks`](crate::client::Client::describe_tasks).
///
/// See [`crate::client::fluent_builders::DescribeTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTasks {
    _private: (),
}
impl DescribeTasks {
    /// Creates a new builder-style object to manufacture [`DescribeTasksInput`](crate::input::DescribeTasksInput)
    pub fn builder() -> crate::input::describe_tasks_input::Builder {
        crate::input::describe_tasks_input::Builder::default()
    }
    /// Creates a new `DescribeTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTasks {
    type Output =
        std::result::Result<crate::output::DescribeTasksOutput, crate::error::DescribeTasksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_tasks_error(response)
        } else {
            crate::operation_deser::parse_describe_tasks_response(response)
        }
    }
}

/// Operation shape for `DescribeTaskSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_task_sets`](crate::client::Client::describe_task_sets).
///
/// See [`crate::client::fluent_builders::DescribeTaskSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTaskSets {
    _private: (),
}
impl DescribeTaskSets {
    /// Creates a new builder-style object to manufacture [`DescribeTaskSetsInput`](crate::input::DescribeTaskSetsInput)
    pub fn builder() -> crate::input::describe_task_sets_input::Builder {
        crate::input::describe_task_sets_input::Builder::default()
    }
    /// Creates a new `DescribeTaskSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTaskSets {
    type Output = std::result::Result<
        crate::output::DescribeTaskSetsOutput,
        crate::error::DescribeTaskSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_task_sets_error(response)
        } else {
            crate::operation_deser::parse_describe_task_sets_response(response)
        }
    }
}

/// Operation shape for `DiscoverPollEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`discover_poll_endpoint`](crate::client::Client::discover_poll_endpoint).
///
/// See [`crate::client::fluent_builders::DiscoverPollEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DiscoverPollEndpoint {
    _private: (),
}
impl DiscoverPollEndpoint {
    /// Creates a new builder-style object to manufacture [`DiscoverPollEndpointInput`](crate::input::DiscoverPollEndpointInput)
    pub fn builder() -> crate::input::discover_poll_endpoint_input::Builder {
        crate::input::discover_poll_endpoint_input::Builder::default()
    }
    /// Creates a new `DiscoverPollEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DiscoverPollEndpoint {
    type Output = std::result::Result<
        crate::output::DiscoverPollEndpointOutput,
        crate::error::DiscoverPollEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_discover_poll_endpoint_error(response)
        } else {
            crate::operation_deser::parse_discover_poll_endpoint_response(response)
        }
    }
}

/// Operation shape for `ExecuteCommand`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`execute_command`](crate::client::Client::execute_command).
///
/// See [`crate::client::fluent_builders::ExecuteCommand`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExecuteCommand {
    _private: (),
}
impl ExecuteCommand {
    /// Creates a new builder-style object to manufacture [`ExecuteCommandInput`](crate::input::ExecuteCommandInput)
    pub fn builder() -> crate::input::execute_command_input::Builder {
        crate::input::execute_command_input::Builder::default()
    }
    /// Creates a new `ExecuteCommand` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExecuteCommand {
    type Output =
        std::result::Result<crate::output::ExecuteCommandOutput, crate::error::ExecuteCommandError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_execute_command_error(response)
        } else {
            crate::operation_deser::parse_execute_command_response(response)
        }
    }
}

/// Operation shape for `ListAccountSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_account_settings`](crate::client::Client::list_account_settings).
///
/// See [`crate::client::fluent_builders::ListAccountSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccountSettings {
    _private: (),
}
impl ListAccountSettings {
    /// Creates a new builder-style object to manufacture [`ListAccountSettingsInput`](crate::input::ListAccountSettingsInput)
    pub fn builder() -> crate::input::list_account_settings_input::Builder {
        crate::input::list_account_settings_input::Builder::default()
    }
    /// Creates a new `ListAccountSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccountSettings {
    type Output = std::result::Result<
        crate::output::ListAccountSettingsOutput,
        crate::error::ListAccountSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_account_settings_error(response)
        } else {
            crate::operation_deser::parse_list_account_settings_response(response)
        }
    }
}

/// Operation shape for `ListAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_attributes`](crate::client::Client::list_attributes).
///
/// See [`crate::client::fluent_builders::ListAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAttributes {
    _private: (),
}
impl ListAttributes {
    /// Creates a new builder-style object to manufacture [`ListAttributesInput`](crate::input::ListAttributesInput)
    pub fn builder() -> crate::input::list_attributes_input::Builder {
        crate::input::list_attributes_input::Builder::default()
    }
    /// Creates a new `ListAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAttributes {
    type Output =
        std::result::Result<crate::output::ListAttributesOutput, crate::error::ListAttributesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_attributes_error(response)
        } else {
            crate::operation_deser::parse_list_attributes_response(response)
        }
    }
}

/// Operation shape for `ListClusters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_clusters`](crate::client::Client::list_clusters).
///
/// See [`crate::client::fluent_builders::ListClusters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListClusters {
    _private: (),
}
impl ListClusters {
    /// Creates a new builder-style object to manufacture [`ListClustersInput`](crate::input::ListClustersInput)
    pub fn builder() -> crate::input::list_clusters_input::Builder {
        crate::input::list_clusters_input::Builder::default()
    }
    /// Creates a new `ListClusters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListClusters {
    type Output =
        std::result::Result<crate::output::ListClustersOutput, crate::error::ListClustersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_clusters_error(response)
        } else {
            crate::operation_deser::parse_list_clusters_response(response)
        }
    }
}

/// Operation shape for `ListContainerInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_container_instances`](crate::client::Client::list_container_instances).
///
/// See [`crate::client::fluent_builders::ListContainerInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListContainerInstances {
    _private: (),
}
impl ListContainerInstances {
    /// Creates a new builder-style object to manufacture [`ListContainerInstancesInput`](crate::input::ListContainerInstancesInput)
    pub fn builder() -> crate::input::list_container_instances_input::Builder {
        crate::input::list_container_instances_input::Builder::default()
    }
    /// Creates a new `ListContainerInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListContainerInstances {
    type Output = std::result::Result<
        crate::output::ListContainerInstancesOutput,
        crate::error::ListContainerInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_container_instances_error(response)
        } else {
            crate::operation_deser::parse_list_container_instances_response(response)
        }
    }
}

/// Operation shape for `ListServices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_services`](crate::client::Client::list_services).
///
/// See [`crate::client::fluent_builders::ListServices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListServices {
    _private: (),
}
impl ListServices {
    /// Creates a new builder-style object to manufacture [`ListServicesInput`](crate::input::ListServicesInput)
    pub fn builder() -> crate::input::list_services_input::Builder {
        crate::input::list_services_input::Builder::default()
    }
    /// Creates a new `ListServices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListServices {
    type Output =
        std::result::Result<crate::output::ListServicesOutput, crate::error::ListServicesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_services_error(response)
        } else {
            crate::operation_deser::parse_list_services_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTaskDefinitionFamilies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_task_definition_families`](crate::client::Client::list_task_definition_families).
///
/// See [`crate::client::fluent_builders::ListTaskDefinitionFamilies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTaskDefinitionFamilies {
    _private: (),
}
impl ListTaskDefinitionFamilies {
    /// Creates a new builder-style object to manufacture [`ListTaskDefinitionFamiliesInput`](crate::input::ListTaskDefinitionFamiliesInput)
    pub fn builder() -> crate::input::list_task_definition_families_input::Builder {
        crate::input::list_task_definition_families_input::Builder::default()
    }
    /// Creates a new `ListTaskDefinitionFamilies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTaskDefinitionFamilies {
    type Output = std::result::Result<
        crate::output::ListTaskDefinitionFamiliesOutput,
        crate::error::ListTaskDefinitionFamiliesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_task_definition_families_error(response)
        } else {
            crate::operation_deser::parse_list_task_definition_families_response(response)
        }
    }
}

/// Operation shape for `ListTaskDefinitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_task_definitions`](crate::client::Client::list_task_definitions).
///
/// See [`crate::client::fluent_builders::ListTaskDefinitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTaskDefinitions {
    _private: (),
}
impl ListTaskDefinitions {
    /// Creates a new builder-style object to manufacture [`ListTaskDefinitionsInput`](crate::input::ListTaskDefinitionsInput)
    pub fn builder() -> crate::input::list_task_definitions_input::Builder {
        crate::input::list_task_definitions_input::Builder::default()
    }
    /// Creates a new `ListTaskDefinitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTaskDefinitions {
    type Output = std::result::Result<
        crate::output::ListTaskDefinitionsOutput,
        crate::error::ListTaskDefinitionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_task_definitions_error(response)
        } else {
            crate::operation_deser::parse_list_task_definitions_response(response)
        }
    }
}

/// Operation shape for `ListTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tasks`](crate::client::Client::list_tasks).
///
/// See [`crate::client::fluent_builders::ListTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTasks {
    _private: (),
}
impl ListTasks {
    /// Creates a new builder-style object to manufacture [`ListTasksInput`](crate::input::ListTasksInput)
    pub fn builder() -> crate::input::list_tasks_input::Builder {
        crate::input::list_tasks_input::Builder::default()
    }
    /// Creates a new `ListTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTasks {
    type Output = std::result::Result<crate::output::ListTasksOutput, crate::error::ListTasksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tasks_error(response)
        } else {
            crate::operation_deser::parse_list_tasks_response(response)
        }
    }
}

/// Operation shape for `PutAccountSetting`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_account_setting`](crate::client::Client::put_account_setting).
///
/// See [`crate::client::fluent_builders::PutAccountSetting`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAccountSetting {
    _private: (),
}
impl PutAccountSetting {
    /// Creates a new builder-style object to manufacture [`PutAccountSettingInput`](crate::input::PutAccountSettingInput)
    pub fn builder() -> crate::input::put_account_setting_input::Builder {
        crate::input::put_account_setting_input::Builder::default()
    }
    /// Creates a new `PutAccountSetting` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAccountSetting {
    type Output = std::result::Result<
        crate::output::PutAccountSettingOutput,
        crate::error::PutAccountSettingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_account_setting_error(response)
        } else {
            crate::operation_deser::parse_put_account_setting_response(response)
        }
    }
}

/// Operation shape for `PutAccountSettingDefault`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_account_setting_default`](crate::client::Client::put_account_setting_default).
///
/// See [`crate::client::fluent_builders::PutAccountSettingDefault`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAccountSettingDefault {
    _private: (),
}
impl PutAccountSettingDefault {
    /// Creates a new builder-style object to manufacture [`PutAccountSettingDefaultInput`](crate::input::PutAccountSettingDefaultInput)
    pub fn builder() -> crate::input::put_account_setting_default_input::Builder {
        crate::input::put_account_setting_default_input::Builder::default()
    }
    /// Creates a new `PutAccountSettingDefault` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAccountSettingDefault {
    type Output = std::result::Result<
        crate::output::PutAccountSettingDefaultOutput,
        crate::error::PutAccountSettingDefaultError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_account_setting_default_error(response)
        } else {
            crate::operation_deser::parse_put_account_setting_default_response(response)
        }
    }
}

/// Operation shape for `PutAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_attributes`](crate::client::Client::put_attributes).
///
/// See [`crate::client::fluent_builders::PutAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAttributes {
    _private: (),
}
impl PutAttributes {
    /// Creates a new builder-style object to manufacture [`PutAttributesInput`](crate::input::PutAttributesInput)
    pub fn builder() -> crate::input::put_attributes_input::Builder {
        crate::input::put_attributes_input::Builder::default()
    }
    /// Creates a new `PutAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAttributes {
    type Output =
        std::result::Result<crate::output::PutAttributesOutput, crate::error::PutAttributesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_attributes_error(response)
        } else {
            crate::operation_deser::parse_put_attributes_response(response)
        }
    }
}

/// Operation shape for `PutClusterCapacityProviders`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_cluster_capacity_providers`](crate::client::Client::put_cluster_capacity_providers).
///
/// See [`crate::client::fluent_builders::PutClusterCapacityProviders`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutClusterCapacityProviders {
    _private: (),
}
impl PutClusterCapacityProviders {
    /// Creates a new builder-style object to manufacture [`PutClusterCapacityProvidersInput`](crate::input::PutClusterCapacityProvidersInput)
    pub fn builder() -> crate::input::put_cluster_capacity_providers_input::Builder {
        crate::input::put_cluster_capacity_providers_input::Builder::default()
    }
    /// Creates a new `PutClusterCapacityProviders` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutClusterCapacityProviders {
    type Output = std::result::Result<
        crate::output::PutClusterCapacityProvidersOutput,
        crate::error::PutClusterCapacityProvidersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_cluster_capacity_providers_error(response)
        } else {
            crate::operation_deser::parse_put_cluster_capacity_providers_response(response)
        }
    }
}

/// Operation shape for `RegisterContainerInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_container_instance`](crate::client::Client::register_container_instance).
///
/// See [`crate::client::fluent_builders::RegisterContainerInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterContainerInstance {
    _private: (),
}
impl RegisterContainerInstance {
    /// Creates a new builder-style object to manufacture [`RegisterContainerInstanceInput`](crate::input::RegisterContainerInstanceInput)
    pub fn builder() -> crate::input::register_container_instance_input::Builder {
        crate::input::register_container_instance_input::Builder::default()
    }
    /// Creates a new `RegisterContainerInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterContainerInstance {
    type Output = std::result::Result<
        crate::output::RegisterContainerInstanceOutput,
        crate::error::RegisterContainerInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_container_instance_error(response)
        } else {
            crate::operation_deser::parse_register_container_instance_response(response)
        }
    }
}

/// Operation shape for `RegisterTaskDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_task_definition`](crate::client::Client::register_task_definition).
///
/// See [`crate::client::fluent_builders::RegisterTaskDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterTaskDefinition {
    _private: (),
}
impl RegisterTaskDefinition {
    /// Creates a new builder-style object to manufacture [`RegisterTaskDefinitionInput`](crate::input::RegisterTaskDefinitionInput)
    pub fn builder() -> crate::input::register_task_definition_input::Builder {
        crate::input::register_task_definition_input::Builder::default()
    }
    /// Creates a new `RegisterTaskDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterTaskDefinition {
    type Output = std::result::Result<
        crate::output::RegisterTaskDefinitionOutput,
        crate::error::RegisterTaskDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_task_definition_error(response)
        } else {
            crate::operation_deser::parse_register_task_definition_response(response)
        }
    }
}

/// Operation shape for `RunTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`run_task`](crate::client::Client::run_task).
///
/// See [`crate::client::fluent_builders::RunTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RunTask {
    _private: (),
}
impl RunTask {
    /// Creates a new builder-style object to manufacture [`RunTaskInput`](crate::input::RunTaskInput)
    pub fn builder() -> crate::input::run_task_input::Builder {
        crate::input::run_task_input::Builder::default()
    }
    /// Creates a new `RunTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RunTask {
    type Output = std::result::Result<crate::output::RunTaskOutput, crate::error::RunTaskError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_run_task_error(response)
        } else {
            crate::operation_deser::parse_run_task_response(response)
        }
    }
}

/// Operation shape for `StartTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_task`](crate::client::Client::start_task).
///
/// See [`crate::client::fluent_builders::StartTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartTask {
    _private: (),
}
impl StartTask {
    /// Creates a new builder-style object to manufacture [`StartTaskInput`](crate::input::StartTaskInput)
    pub fn builder() -> crate::input::start_task_input::Builder {
        crate::input::start_task_input::Builder::default()
    }
    /// Creates a new `StartTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartTask {
    type Output = std::result::Result<crate::output::StartTaskOutput, crate::error::StartTaskError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_task_error(response)
        } else {
            crate::operation_deser::parse_start_task_response(response)
        }
    }
}

/// Operation shape for `StopTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_task`](crate::client::Client::stop_task).
///
/// See [`crate::client::fluent_builders::StopTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopTask {
    _private: (),
}
impl StopTask {
    /// Creates a new builder-style object to manufacture [`StopTaskInput`](crate::input::StopTaskInput)
    pub fn builder() -> crate::input::stop_task_input::Builder {
        crate::input::stop_task_input::Builder::default()
    }
    /// Creates a new `StopTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopTask {
    type Output = std::result::Result<crate::output::StopTaskOutput, crate::error::StopTaskError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_task_error(response)
        } else {
            crate::operation_deser::parse_stop_task_response(response)
        }
    }
}

/// Operation shape for `SubmitAttachmentStateChanges`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`submit_attachment_state_changes`](crate::client::Client::submit_attachment_state_changes).
///
/// See [`crate::client::fluent_builders::SubmitAttachmentStateChanges`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SubmitAttachmentStateChanges {
    _private: (),
}
impl SubmitAttachmentStateChanges {
    /// Creates a new builder-style object to manufacture [`SubmitAttachmentStateChangesInput`](crate::input::SubmitAttachmentStateChangesInput)
    pub fn builder() -> crate::input::submit_attachment_state_changes_input::Builder {
        crate::input::submit_attachment_state_changes_input::Builder::default()
    }
    /// Creates a new `SubmitAttachmentStateChanges` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SubmitAttachmentStateChanges {
    type Output = std::result::Result<
        crate::output::SubmitAttachmentStateChangesOutput,
        crate::error::SubmitAttachmentStateChangesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_submit_attachment_state_changes_error(response)
        } else {
            crate::operation_deser::parse_submit_attachment_state_changes_response(response)
        }
    }
}

/// Operation shape for `SubmitContainerStateChange`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`submit_container_state_change`](crate::client::Client::submit_container_state_change).
///
/// See [`crate::client::fluent_builders::SubmitContainerStateChange`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SubmitContainerStateChange {
    _private: (),
}
impl SubmitContainerStateChange {
    /// Creates a new builder-style object to manufacture [`SubmitContainerStateChangeInput`](crate::input::SubmitContainerStateChangeInput)
    pub fn builder() -> crate::input::submit_container_state_change_input::Builder {
        crate::input::submit_container_state_change_input::Builder::default()
    }
    /// Creates a new `SubmitContainerStateChange` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SubmitContainerStateChange {
    type Output = std::result::Result<
        crate::output::SubmitContainerStateChangeOutput,
        crate::error::SubmitContainerStateChangeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_submit_container_state_change_error(response)
        } else {
            crate::operation_deser::parse_submit_container_state_change_response(response)
        }
    }
}

/// Operation shape for `SubmitTaskStateChange`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`submit_task_state_change`](crate::client::Client::submit_task_state_change).
///
/// See [`crate::client::fluent_builders::SubmitTaskStateChange`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SubmitTaskStateChange {
    _private: (),
}
impl SubmitTaskStateChange {
    /// Creates a new builder-style object to manufacture [`SubmitTaskStateChangeInput`](crate::input::SubmitTaskStateChangeInput)
    pub fn builder() -> crate::input::submit_task_state_change_input::Builder {
        crate::input::submit_task_state_change_input::Builder::default()
    }
    /// Creates a new `SubmitTaskStateChange` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SubmitTaskStateChange {
    type Output = std::result::Result<
        crate::output::SubmitTaskStateChangeOutput,
        crate::error::SubmitTaskStateChangeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_submit_task_state_change_error(response)
        } else {
            crate::operation_deser::parse_submit_task_state_change_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateCapacityProvider`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_capacity_provider`](crate::client::Client::update_capacity_provider).
///
/// See [`crate::client::fluent_builders::UpdateCapacityProvider`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCapacityProvider {
    _private: (),
}
impl UpdateCapacityProvider {
    /// Creates a new builder-style object to manufacture [`UpdateCapacityProviderInput`](crate::input::UpdateCapacityProviderInput)
    pub fn builder() -> crate::input::update_capacity_provider_input::Builder {
        crate::input::update_capacity_provider_input::Builder::default()
    }
    /// Creates a new `UpdateCapacityProvider` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCapacityProvider {
    type Output = std::result::Result<
        crate::output::UpdateCapacityProviderOutput,
        crate::error::UpdateCapacityProviderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_capacity_provider_error(response)
        } else {
            crate::operation_deser::parse_update_capacity_provider_response(response)
        }
    }
}

/// Operation shape for `UpdateCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_cluster`](crate::client::Client::update_cluster).
///
/// See [`crate::client::fluent_builders::UpdateCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCluster {
    _private: (),
}
impl UpdateCluster {
    /// Creates a new builder-style object to manufacture [`UpdateClusterInput`](crate::input::UpdateClusterInput)
    pub fn builder() -> crate::input::update_cluster_input::Builder {
        crate::input::update_cluster_input::Builder::default()
    }
    /// Creates a new `UpdateCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCluster {
    type Output =
        std::result::Result<crate::output::UpdateClusterOutput, crate::error::UpdateClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_cluster_error(response)
        } else {
            crate::operation_deser::parse_update_cluster_response(response)
        }
    }
}

/// Operation shape for `UpdateClusterSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_cluster_settings`](crate::client::Client::update_cluster_settings).
///
/// See [`crate::client::fluent_builders::UpdateClusterSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateClusterSettings {
    _private: (),
}
impl UpdateClusterSettings {
    /// Creates a new builder-style object to manufacture [`UpdateClusterSettingsInput`](crate::input::UpdateClusterSettingsInput)
    pub fn builder() -> crate::input::update_cluster_settings_input::Builder {
        crate::input::update_cluster_settings_input::Builder::default()
    }
    /// Creates a new `UpdateClusterSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateClusterSettings {
    type Output = std::result::Result<
        crate::output::UpdateClusterSettingsOutput,
        crate::error::UpdateClusterSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_cluster_settings_error(response)
        } else {
            crate::operation_deser::parse_update_cluster_settings_response(response)
        }
    }
}

/// Operation shape for `UpdateContainerAgent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_container_agent`](crate::client::Client::update_container_agent).
///
/// See [`crate::client::fluent_builders::UpdateContainerAgent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateContainerAgent {
    _private: (),
}
impl UpdateContainerAgent {
    /// Creates a new builder-style object to manufacture [`UpdateContainerAgentInput`](crate::input::UpdateContainerAgentInput)
    pub fn builder() -> crate::input::update_container_agent_input::Builder {
        crate::input::update_container_agent_input::Builder::default()
    }
    /// Creates a new `UpdateContainerAgent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateContainerAgent {
    type Output = std::result::Result<
        crate::output::UpdateContainerAgentOutput,
        crate::error::UpdateContainerAgentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_container_agent_error(response)
        } else {
            crate::operation_deser::parse_update_container_agent_response(response)
        }
    }
}

/// Operation shape for `UpdateContainerInstancesState`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_container_instances_state`](crate::client::Client::update_container_instances_state).
///
/// See [`crate::client::fluent_builders::UpdateContainerInstancesState`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateContainerInstancesState {
    _private: (),
}
impl UpdateContainerInstancesState {
    /// Creates a new builder-style object to manufacture [`UpdateContainerInstancesStateInput`](crate::input::UpdateContainerInstancesStateInput)
    pub fn builder() -> crate::input::update_container_instances_state_input::Builder {
        crate::input::update_container_instances_state_input::Builder::default()
    }
    /// Creates a new `UpdateContainerInstancesState` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateContainerInstancesState {
    type Output = std::result::Result<
        crate::output::UpdateContainerInstancesStateOutput,
        crate::error::UpdateContainerInstancesStateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_container_instances_state_error(response)
        } else {
            crate::operation_deser::parse_update_container_instances_state_response(response)
        }
    }
}

/// Operation shape for `UpdateService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_service`](crate::client::Client::update_service).
///
/// See [`crate::client::fluent_builders::UpdateService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateService {
    _private: (),
}
impl UpdateService {
    /// Creates a new builder-style object to manufacture [`UpdateServiceInput`](crate::input::UpdateServiceInput)
    pub fn builder() -> crate::input::update_service_input::Builder {
        crate::input::update_service_input::Builder::default()
    }
    /// Creates a new `UpdateService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateService {
    type Output =
        std::result::Result<crate::output::UpdateServiceOutput, crate::error::UpdateServiceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_service_error(response)
        } else {
            crate::operation_deser::parse_update_service_response(response)
        }
    }
}

/// Operation shape for `UpdateServicePrimaryTaskSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_service_primary_task_set`](crate::client::Client::update_service_primary_task_set).
///
/// See [`crate::client::fluent_builders::UpdateServicePrimaryTaskSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateServicePrimaryTaskSet {
    _private: (),
}
impl UpdateServicePrimaryTaskSet {
    /// Creates a new builder-style object to manufacture [`UpdateServicePrimaryTaskSetInput`](crate::input::UpdateServicePrimaryTaskSetInput)
    pub fn builder() -> crate::input::update_service_primary_task_set_input::Builder {
        crate::input::update_service_primary_task_set_input::Builder::default()
    }
    /// Creates a new `UpdateServicePrimaryTaskSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateServicePrimaryTaskSet {
    type Output = std::result::Result<
        crate::output::UpdateServicePrimaryTaskSetOutput,
        crate::error::UpdateServicePrimaryTaskSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_service_primary_task_set_error(response)
        } else {
            crate::operation_deser::parse_update_service_primary_task_set_response(response)
        }
    }
}

/// Operation shape for `UpdateTaskSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_task_set`](crate::client::Client::update_task_set).
///
/// See [`crate::client::fluent_builders::UpdateTaskSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTaskSet {
    _private: (),
}
impl UpdateTaskSet {
    /// Creates a new builder-style object to manufacture [`UpdateTaskSetInput`](crate::input::UpdateTaskSetInput)
    pub fn builder() -> crate::input::update_task_set_input::Builder {
        crate::input::update_task_set_input::Builder::default()
    }
    /// Creates a new `UpdateTaskSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTaskSet {
    type Output =
        std::result::Result<crate::output::UpdateTaskSetOutput, crate::error::UpdateTaskSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_task_set_error(response)
        } else {
            crate::operation_deser::parse_update_task_set_response(response)
        }
    }
}
