// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>You don't have authorization to perform the requested action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>You can apply up to 10 custom attributes for each resource. You can view the
    /// attributes of a resource with <a>ListAttributes</a>. You can remove existing
    /// attributes on a resource with <a>DeleteAttributes</a>.</p>
    AttributeLimitExceededException(crate::error::AttributeLimitExceededException),
    /// <p>Your Amazon Web Services account was blocked. For more information, contact <a href="http://aws.amazon.com/contact-us/">
    /// Amazon Web Services Support</a>.</p>
    BlockedException(crate::error::BlockedException),
    /// <p>These errors are usually caused by a client action. This client action might be using
    /// an action or resource on behalf of a user that doesn't have permissions to use the
    /// action or resource,. Or, it might be specifying an identifier that isn't valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>You can't delete a cluster that has registered container instances. First, deregister
    /// the container instances before you can delete the cluster. For more information, see
    /// <a>DeregisterContainerInstance</a>.</p>
    ClusterContainsContainerInstancesException(
        crate::error::ClusterContainsContainerInstancesException,
    ),
    /// <p>You can't delete a cluster that contains services. First, update the service to reduce
    /// its desired task count to 0, and then delete the service. For more information, see
    /// <a>UpdateService</a> and <a>DeleteService</a>.</p>
    ClusterContainsServicesException(crate::error::ClusterContainsServicesException),
    /// <p>You can't delete a cluster that has active tasks.</p>
    ClusterContainsTasksException(crate::error::ClusterContainsTasksException),
    /// <p>The specified cluster wasn't found. You can view your available clusters with <a>ListClusters</a>. Amazon ECS clusters are Region specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter isn't valid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The limit for the resource was exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Amazon ECS can't determine the current version of the Amazon ECS container agent on the
    /// container instance and doesn't have enough information to proceed with an update. This
    /// could be because the agent running on the container instance is a previous or custom
    /// version that doesn't use our version information.</p>
    MissingVersionException(crate::error::MissingVersionException),
    /// <p>There's no update available for this Amazon ECS container agent. This might be because the
    /// agent is already running the latest version or because it's so old that there's no
    /// update path to the current version.</p>
    NoUpdateAvailableException(crate::error::NoUpdateAvailableException),
    /// <p>The specified platform version doesn't satisfy the required capabilities of the task
    /// definition.</p>
    PlatformTaskDefinitionIncompatibilityException(
        crate::error::PlatformTaskDefinitionIncompatibilityException,
    ),
    /// <p>The specified platform version doesn't exist.</p>
    PlatformUnknownException(crate::error::PlatformUnknownException),
    /// <p>The specified resource is in-use and can't be removed.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The specified service isn't active. You can't update a service that's inactive. If you
    /// have previously deleted a service, you can re-create it with <a>CreateService</a>.</p>
    ServiceNotActiveException(crate::error::ServiceNotActiveException),
    /// <p>The specified service wasn't found. You can view your available services with <a>ListServices</a>. Amazon ECS services are cluster specific and Region
    /// specific.</p>
    ServiceNotFoundException(crate::error::ServiceNotFoundException),
    /// <p>The target container isn't properly configured with the execute command agent or the
    /// container is no longer active or running.</p>
    TargetNotConnectedException(crate::error::TargetNotConnectedException),
    /// <p>The specified target wasn't found. You can view your available container instances
    /// with <a>ListContainerInstances</a>. Amazon ECS container instances are
    /// cluster-specific and Region-specific.</p>
    TargetNotFoundException(crate::error::TargetNotFoundException),
    /// <p>The specified task set wasn't found. You can view your available task sets with <a>DescribeTaskSets</a>. Task sets are specific to each cluster, service and
    /// Region.</p>
    TaskSetNotFoundException(crate::error::TaskSetNotFoundException),
    /// <p>The specified task isn't supported in this Region.</p>
    UnsupportedFeatureException(crate::error::UnsupportedFeatureException),
    /// <p>There's already a current Amazon ECS container agent update in progress on the container
    /// instance that's specified. If the container agent becomes disconnected while it's in a
    /// transitional stage, such as <code>PENDING</code> or <code>STAGING</code>, the update
    /// process can get stuck in that state. However, when the agent reconnects, it resumes
    /// where it stopped previously.</p>
    UpdateInProgressException(crate::error::UpdateInProgressException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDeniedException(inner) => inner.fmt(f),
            Error::AttributeLimitExceededException(inner) => inner.fmt(f),
            Error::BlockedException(inner) => inner.fmt(f),
            Error::ClientException(inner) => inner.fmt(f),
            Error::ClusterContainsContainerInstancesException(inner) => inner.fmt(f),
            Error::ClusterContainsServicesException(inner) => inner.fmt(f),
            Error::ClusterContainsTasksException(inner) => inner.fmt(f),
            Error::ClusterNotFoundException(inner) => inner.fmt(f),
            Error::InvalidParameterException(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::MissingVersionException(inner) => inner.fmt(f),
            Error::NoUpdateAvailableException(inner) => inner.fmt(f),
            Error::PlatformTaskDefinitionIncompatibilityException(inner) => inner.fmt(f),
            Error::PlatformUnknownException(inner) => inner.fmt(f),
            Error::ResourceInUseException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::ServerException(inner) => inner.fmt(f),
            Error::ServiceNotActiveException(inner) => inner.fmt(f),
            Error::ServiceNotFoundException(inner) => inner.fmt(f),
            Error::TargetNotConnectedException(inner) => inner.fmt(f),
            Error::TargetNotFoundException(inner) => inner.fmt(f),
            Error::TaskSetNotFoundException(inner) => inner.fmt(f),
            Error::UnsupportedFeatureException(inner) => inner.fmt(f),
            Error::UpdateInProgressException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCapacityProviderError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateCapacityProviderError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateCapacityProviderErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::CreateCapacityProviderErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreateCapacityProviderErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateCapacityProviderErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::CreateCapacityProviderErrorKind::UpdateInProgressException(inner) => {
                    Error::UpdateInProgressException(inner)
                }
                crate::error::CreateCapacityProviderErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateClusterErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::CreateClusterErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreateClusterErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::CreateClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateServiceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateServiceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateServiceErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateServiceErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::CreateServiceErrorKind::ClusterNotFoundException(inner) => Error::ClusterNotFoundException(inner),
                crate::error::CreateServiceErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::CreateServiceErrorKind::PlatformTaskDefinitionIncompatibilityException(inner) => Error::PlatformTaskDefinitionIncompatibilityException(inner),
                crate::error::CreateServiceErrorKind::PlatformUnknownException(inner) => Error::PlatformUnknownException(inner),
                crate::error::CreateServiceErrorKind::ServerException(inner) => Error::ServerException(inner),
                crate::error::CreateServiceErrorKind::UnsupportedFeatureException(inner) => Error::UnsupportedFeatureException(inner),
                crate::error::CreateServiceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTaskSetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateTaskSetError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateTaskSetErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateTaskSetErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::CreateTaskSetErrorKind::ClusterNotFoundException(inner) => Error::ClusterNotFoundException(inner),
                crate::error::CreateTaskSetErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::CreateTaskSetErrorKind::PlatformTaskDefinitionIncompatibilityException(inner) => Error::PlatformTaskDefinitionIncompatibilityException(inner),
                crate::error::CreateTaskSetErrorKind::PlatformUnknownException(inner) => Error::PlatformUnknownException(inner),
                crate::error::CreateTaskSetErrorKind::ServerException(inner) => Error::ServerException(inner),
                crate::error::CreateTaskSetErrorKind::ServiceNotActiveException(inner) => Error::ServiceNotActiveException(inner),
                crate::error::CreateTaskSetErrorKind::ServiceNotFoundException(inner) => Error::ServiceNotFoundException(inner),
                crate::error::CreateTaskSetErrorKind::UnsupportedFeatureException(inner) => Error::UnsupportedFeatureException(inner),
                crate::error::CreateTaskSetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAccountSettingError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteAccountSettingError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteAccountSettingErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DeleteAccountSettingErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteAccountSettingErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::DeleteAccountSettingErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAttributesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteAttributesErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::DeleteAttributesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteAttributesErrorKind::TargetNotFoundException(inner) => {
                    Error::TargetNotFoundException(inner)
                }
                crate::error::DeleteAttributesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCapacityProviderError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteCapacityProviderError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteCapacityProviderErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DeleteCapacityProviderErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteCapacityProviderErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::DeleteCapacityProviderErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteClusterErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::DeleteClusterErrorKind::ClusterContainsContainerInstancesException(inner) => Error::ClusterContainsContainerInstancesException(inner),
                crate::error::DeleteClusterErrorKind::ClusterContainsServicesException(inner) => Error::ClusterContainsServicesException(inner),
                crate::error::DeleteClusterErrorKind::ClusterContainsTasksException(inner) => Error::ClusterContainsTasksException(inner),
                crate::error::DeleteClusterErrorKind::ClusterNotFoundException(inner) => Error::ClusterNotFoundException(inner),
                crate::error::DeleteClusterErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DeleteClusterErrorKind::ServerException(inner) => Error::ServerException(inner),
                crate::error::DeleteClusterErrorKind::UpdateInProgressException(inner) => Error::UpdateInProgressException(inner),
                crate::error::DeleteClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteServiceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteServiceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteServiceErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DeleteServiceErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::DeleteServiceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteServiceErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::DeleteServiceErrorKind::ServiceNotFoundException(inner) => {
                    Error::ServiceNotFoundException(inner)
                }
                crate::error::DeleteServiceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTaskSetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteTaskSetError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTaskSetErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteTaskSetErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DeleteTaskSetErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::DeleteTaskSetErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteTaskSetErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::DeleteTaskSetErrorKind::ServiceNotActiveException(inner) => {
                    Error::ServiceNotActiveException(inner)
                }
                crate::error::DeleteTaskSetErrorKind::ServiceNotFoundException(inner) => {
                    Error::ServiceNotFoundException(inner)
                }
                crate::error::DeleteTaskSetErrorKind::TaskSetNotFoundException(inner) => {
                    Error::TaskSetNotFoundException(inner)
                }
                crate::error::DeleteTaskSetErrorKind::UnsupportedFeatureException(inner) => {
                    Error::UnsupportedFeatureException(inner)
                }
                crate::error::DeleteTaskSetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeregisterContainerInstanceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeregisterContainerInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeregisterContainerInstanceErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DeregisterContainerInstanceErrorKind::ClusterNotFoundException(
                    inner,
                ) => Error::ClusterNotFoundException(inner),
                crate::error::DeregisterContainerInstanceErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::DeregisterContainerInstanceErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::DeregisterContainerInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeregisterTaskDefinitionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeregisterTaskDefinitionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeregisterTaskDefinitionErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DeregisterTaskDefinitionErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::DeregisterTaskDefinitionErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::DeregisterTaskDefinitionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCapacityProvidersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeCapacityProvidersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeCapacityProvidersErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DescribeCapacityProvidersErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::DescribeCapacityProvidersErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::DescribeCapacityProvidersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeClustersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeClustersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeClustersErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DescribeClustersErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeClustersErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::DescribeClustersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeContainerInstancesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeContainerInstancesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeContainerInstancesErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DescribeContainerInstancesErrorKind::ClusterNotFoundException(
                    inner,
                ) => Error::ClusterNotFoundException(inner),
                crate::error::DescribeContainerInstancesErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::DescribeContainerInstancesErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::DescribeContainerInstancesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeServicesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeServicesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeServicesErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DescribeServicesErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::DescribeServicesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeServicesErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::DescribeServicesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTaskDefinitionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeTaskDefinitionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTaskDefinitionErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DescribeTaskDefinitionErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeTaskDefinitionErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::DescribeTaskDefinitionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTasksError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeTasksError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTasksErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DescribeTasksErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::DescribeTasksErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeTasksErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::DescribeTasksErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTaskSetsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeTaskSetsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTaskSetsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeTaskSetsErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DescribeTaskSetsErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::DescribeTaskSetsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeTaskSetsErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::DescribeTaskSetsErrorKind::ServiceNotActiveException(inner) => {
                    Error::ServiceNotActiveException(inner)
                }
                crate::error::DescribeTaskSetsErrorKind::ServiceNotFoundException(inner) => {
                    Error::ServiceNotFoundException(inner)
                }
                crate::error::DescribeTaskSetsErrorKind::UnsupportedFeatureException(inner) => {
                    Error::UnsupportedFeatureException(inner)
                }
                crate::error::DescribeTaskSetsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DiscoverPollEndpointError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DiscoverPollEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DiscoverPollEndpointErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DiscoverPollEndpointErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::DiscoverPollEndpointErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ExecuteCommandError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ExecuteCommandError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ExecuteCommandErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ExecuteCommandErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ExecuteCommandErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::ExecuteCommandErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ExecuteCommandErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::ExecuteCommandErrorKind::TargetNotConnectedException(inner) => {
                    Error::TargetNotConnectedException(inner)
                }
                crate::error::ExecuteCommandErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListAccountSettingsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListAccountSettingsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListAccountSettingsErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListAccountSettingsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListAccountSettingsErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::ListAccountSettingsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListAttributesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListAttributesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListAttributesErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::ListAttributesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListAttributesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListClustersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListClustersError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListClustersErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListClustersErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListClustersErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::ListClustersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListContainerInstancesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListContainerInstancesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListContainerInstancesErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListContainerInstancesErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::ListContainerInstancesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListContainerInstancesErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::ListContainerInstancesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListServicesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListServicesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListServicesErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListServicesErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::ListServicesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListServicesErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::ListServicesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTaskDefinitionFamiliesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTaskDefinitionFamiliesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTaskDefinitionFamiliesErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListTaskDefinitionFamiliesErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::ListTaskDefinitionFamiliesErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::ListTaskDefinitionFamiliesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTaskDefinitionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTaskDefinitionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTaskDefinitionsErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListTaskDefinitionsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListTaskDefinitionsErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::ListTaskDefinitionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTasksError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListTasksError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTasksErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListTasksErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::ListTasksErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListTasksErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::ListTasksErrorKind::ServiceNotFoundException(inner) => {
                    Error::ServiceNotFoundException(inner)
                }
                crate::error::ListTasksErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutAccountSettingError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutAccountSettingError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutAccountSettingErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::PutAccountSettingErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::PutAccountSettingErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::PutAccountSettingErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutAccountSettingDefaultError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutAccountSettingDefaultError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutAccountSettingDefaultErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::PutAccountSettingDefaultErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::PutAccountSettingDefaultErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::PutAccountSettingDefaultErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutAttributesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PutAttributesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutAttributesErrorKind::AttributeLimitExceededException(inner) => {
                    Error::AttributeLimitExceededException(inner)
                }
                crate::error::PutAttributesErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::PutAttributesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::PutAttributesErrorKind::TargetNotFoundException(inner) => {
                    Error::TargetNotFoundException(inner)
                }
                crate::error::PutAttributesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutClusterCapacityProvidersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutClusterCapacityProvidersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutClusterCapacityProvidersErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::PutClusterCapacityProvidersErrorKind::ClusterNotFoundException(
                    inner,
                ) => Error::ClusterNotFoundException(inner),
                crate::error::PutClusterCapacityProvidersErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::PutClusterCapacityProvidersErrorKind::ResourceInUseException(
                    inner,
                ) => Error::ResourceInUseException(inner),
                crate::error::PutClusterCapacityProvidersErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::PutClusterCapacityProvidersErrorKind::UpdateInProgressException(
                    inner,
                ) => Error::UpdateInProgressException(inner),
                crate::error::PutClusterCapacityProvidersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterContainerInstanceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RegisterContainerInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RegisterContainerInstanceErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::RegisterContainerInstanceErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::RegisterContainerInstanceErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::RegisterContainerInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterTaskDefinitionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RegisterTaskDefinitionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RegisterTaskDefinitionErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::RegisterTaskDefinitionErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::RegisterTaskDefinitionErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::RegisterTaskDefinitionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RunTaskError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RunTaskError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RunTaskErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::RunTaskErrorKind::BlockedException(inner) => {
                    Error::BlockedException(inner)
                }
                crate::error::RunTaskErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::RunTaskErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::RunTaskErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::RunTaskErrorKind::PlatformTaskDefinitionIncompatibilityException(
                    inner,
                ) => Error::PlatformTaskDefinitionIncompatibilityException(inner),
                crate::error::RunTaskErrorKind::PlatformUnknownException(inner) => {
                    Error::PlatformUnknownException(inner)
                }
                crate::error::RunTaskErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::RunTaskErrorKind::UnsupportedFeatureException(inner) => {
                    Error::UnsupportedFeatureException(inner)
                }
                crate::error::RunTaskErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartTaskError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StartTaskError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartTaskErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::StartTaskErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::StartTaskErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::StartTaskErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::StartTaskErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopTaskError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StopTaskError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopTaskErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::StopTaskErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::StopTaskErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::StopTaskErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::StopTaskErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SubmitAttachmentStateChangesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SubmitAttachmentStateChangesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SubmitAttachmentStateChangesErrorKind::AccessDeniedException(
                    inner,
                ) => Error::AccessDeniedException(inner),
                crate::error::SubmitAttachmentStateChangesErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::SubmitAttachmentStateChangesErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::SubmitAttachmentStateChangesErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::SubmitAttachmentStateChangesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SubmitContainerStateChangeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SubmitContainerStateChangeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SubmitContainerStateChangeErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::SubmitContainerStateChangeErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::SubmitContainerStateChangeErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::SubmitContainerStateChangeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SubmitTaskStateChangeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SubmitTaskStateChangeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SubmitTaskStateChangeErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::SubmitTaskStateChangeErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::SubmitTaskStateChangeErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::SubmitTaskStateChangeErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::SubmitTaskStateChangeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::TagResourceErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::TagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::TagResourceErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::UntagResourceErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UntagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UntagResourceErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateCapacityProviderError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateCapacityProviderError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateCapacityProviderErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::UpdateCapacityProviderErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UpdateCapacityProviderErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::UpdateCapacityProviderErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateClusterErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::UpdateClusterErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::UpdateClusterErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UpdateClusterErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::UpdateClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateClusterSettingsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateClusterSettingsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateClusterSettingsErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::UpdateClusterSettingsErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::UpdateClusterSettingsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UpdateClusterSettingsErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::UpdateClusterSettingsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateContainerAgentError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateContainerAgentError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateContainerAgentErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::UpdateContainerAgentErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::UpdateContainerAgentErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UpdateContainerAgentErrorKind::MissingVersionException(inner) => {
                    Error::MissingVersionException(inner)
                }
                crate::error::UpdateContainerAgentErrorKind::NoUpdateAvailableException(inner) => {
                    Error::NoUpdateAvailableException(inner)
                }
                crate::error::UpdateContainerAgentErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::UpdateContainerAgentErrorKind::UpdateInProgressException(inner) => {
                    Error::UpdateInProgressException(inner)
                }
                crate::error::UpdateContainerAgentErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateContainerInstancesStateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateContainerInstancesStateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateContainerInstancesStateErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::UpdateContainerInstancesStateErrorKind::ClusterNotFoundException(
                    inner,
                ) => Error::ClusterNotFoundException(inner),
                crate::error::UpdateContainerInstancesStateErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::UpdateContainerInstancesStateErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::UpdateContainerInstancesStateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateServiceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateServiceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateServiceErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::UpdateServiceErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::UpdateServiceErrorKind::ClusterNotFoundException(inner) => Error::ClusterNotFoundException(inner),
                crate::error::UpdateServiceErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::UpdateServiceErrorKind::PlatformTaskDefinitionIncompatibilityException(inner) => Error::PlatformTaskDefinitionIncompatibilityException(inner),
                crate::error::UpdateServiceErrorKind::PlatformUnknownException(inner) => Error::PlatformUnknownException(inner),
                crate::error::UpdateServiceErrorKind::ServerException(inner) => Error::ServerException(inner),
                crate::error::UpdateServiceErrorKind::ServiceNotActiveException(inner) => Error::ServiceNotActiveException(inner),
                crate::error::UpdateServiceErrorKind::ServiceNotFoundException(inner) => Error::ServiceNotFoundException(inner),
                crate::error::UpdateServiceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateServicePrimaryTaskSetError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateServicePrimaryTaskSetError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateServicePrimaryTaskSetErrorKind::AccessDeniedException(
                    inner,
                ) => Error::AccessDeniedException(inner),
                crate::error::UpdateServicePrimaryTaskSetErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::UpdateServicePrimaryTaskSetErrorKind::ClusterNotFoundException(
                    inner,
                ) => Error::ClusterNotFoundException(inner),
                crate::error::UpdateServicePrimaryTaskSetErrorKind::InvalidParameterException(
                    inner,
                ) => Error::InvalidParameterException(inner),
                crate::error::UpdateServicePrimaryTaskSetErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::UpdateServicePrimaryTaskSetErrorKind::ServiceNotActiveException(
                    inner,
                ) => Error::ServiceNotActiveException(inner),
                crate::error::UpdateServicePrimaryTaskSetErrorKind::ServiceNotFoundException(
                    inner,
                ) => Error::ServiceNotFoundException(inner),
                crate::error::UpdateServicePrimaryTaskSetErrorKind::TaskSetNotFoundException(
                    inner,
                ) => Error::TaskSetNotFoundException(inner),
                crate::error::UpdateServicePrimaryTaskSetErrorKind::UnsupportedFeatureException(
                    inner,
                ) => Error::UnsupportedFeatureException(inner),
                crate::error::UpdateServicePrimaryTaskSetErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateTaskSetError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateTaskSetError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateTaskSetErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateTaskSetErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::UpdateTaskSetErrorKind::ClusterNotFoundException(inner) => {
                    Error::ClusterNotFoundException(inner)
                }
                crate::error::UpdateTaskSetErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UpdateTaskSetErrorKind::ServerException(inner) => {
                    Error::ServerException(inner)
                }
                crate::error::UpdateTaskSetErrorKind::ServiceNotActiveException(inner) => {
                    Error::ServiceNotActiveException(inner)
                }
                crate::error::UpdateTaskSetErrorKind::ServiceNotFoundException(inner) => {
                    Error::ServiceNotFoundException(inner)
                }
                crate::error::UpdateTaskSetErrorKind::TaskSetNotFoundException(inner) => {
                    Error::TaskSetNotFoundException(inner)
                }
                crate::error::UpdateTaskSetErrorKind::UnsupportedFeatureException(inner) => {
                    Error::UnsupportedFeatureException(inner)
                }
                crate::error::UpdateTaskSetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
