// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTaskSetOutput {
    /// <p>Details about the task set.</p>
    pub task_set: std::option::Option<crate::model::TaskSet>,
}
impl UpdateTaskSetOutput {
    /// <p>Details about the task set.</p>
    pub fn task_set(&self) -> std::option::Option<&crate::model::TaskSet> {
        self.task_set.as_ref()
    }
}
impl std::fmt::Debug for UpdateTaskSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTaskSetOutput");
        formatter.field("task_set", &self.task_set);
        formatter.finish()
    }
}
/// See [`UpdateTaskSetOutput`](crate::output::UpdateTaskSetOutput)
pub mod update_task_set_output {
    /// A builder for [`UpdateTaskSetOutput`](crate::output::UpdateTaskSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_set: std::option::Option<crate::model::TaskSet>,
    }
    impl Builder {
        /// <p>Details about the task set.</p>
        pub fn task_set(mut self, input: crate::model::TaskSet) -> Self {
            self.task_set = Some(input);
            self
        }
        /// <p>Details about the task set.</p>
        pub fn set_task_set(mut self, input: std::option::Option<crate::model::TaskSet>) -> Self {
            self.task_set = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTaskSetOutput`](crate::output::UpdateTaskSetOutput)
        pub fn build(self) -> crate::output::UpdateTaskSetOutput {
            crate::output::UpdateTaskSetOutput {
                task_set: self.task_set,
            }
        }
    }
}
impl UpdateTaskSetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTaskSetOutput`](crate::output::UpdateTaskSetOutput)
    pub fn builder() -> crate::output::update_task_set_output::Builder {
        crate::output::update_task_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServicePrimaryTaskSetOutput {
    /// <p>etails about the task set.</p>
    pub task_set: std::option::Option<crate::model::TaskSet>,
}
impl UpdateServicePrimaryTaskSetOutput {
    /// <p>etails about the task set.</p>
    pub fn task_set(&self) -> std::option::Option<&crate::model::TaskSet> {
        self.task_set.as_ref()
    }
}
impl std::fmt::Debug for UpdateServicePrimaryTaskSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServicePrimaryTaskSetOutput");
        formatter.field("task_set", &self.task_set);
        formatter.finish()
    }
}
/// See [`UpdateServicePrimaryTaskSetOutput`](crate::output::UpdateServicePrimaryTaskSetOutput)
pub mod update_service_primary_task_set_output {
    /// A builder for [`UpdateServicePrimaryTaskSetOutput`](crate::output::UpdateServicePrimaryTaskSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_set: std::option::Option<crate::model::TaskSet>,
    }
    impl Builder {
        /// <p>etails about the task set.</p>
        pub fn task_set(mut self, input: crate::model::TaskSet) -> Self {
            self.task_set = Some(input);
            self
        }
        /// <p>etails about the task set.</p>
        pub fn set_task_set(mut self, input: std::option::Option<crate::model::TaskSet>) -> Self {
            self.task_set = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServicePrimaryTaskSetOutput`](crate::output::UpdateServicePrimaryTaskSetOutput)
        pub fn build(self) -> crate::output::UpdateServicePrimaryTaskSetOutput {
            crate::output::UpdateServicePrimaryTaskSetOutput {
                task_set: self.task_set,
            }
        }
    }
}
impl UpdateServicePrimaryTaskSetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateServicePrimaryTaskSetOutput`](crate::output::UpdateServicePrimaryTaskSetOutput)
    pub fn builder() -> crate::output::update_service_primary_task_set_output::Builder {
        crate::output::update_service_primary_task_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceOutput {
    /// <p>The full description of your service following the update call.</p>
    pub service: std::option::Option<crate::model::Service>,
}
impl UpdateServiceOutput {
    /// <p>The full description of your service following the update call.</p>
    pub fn service(&self) -> std::option::Option<&crate::model::Service> {
        self.service.as_ref()
    }
}
impl std::fmt::Debug for UpdateServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceOutput");
        formatter.field("service", &self.service);
        formatter.finish()
    }
}
/// See [`UpdateServiceOutput`](crate::output::UpdateServiceOutput)
pub mod update_service_output {
    /// A builder for [`UpdateServiceOutput`](crate::output::UpdateServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<crate::model::Service>,
    }
    impl Builder {
        /// <p>The full description of your service following the update call.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>The full description of your service following the update call.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceOutput`](crate::output::UpdateServiceOutput)
        pub fn build(self) -> crate::output::UpdateServiceOutput {
            crate::output::UpdateServiceOutput {
                service: self.service,
            }
        }
    }
}
impl UpdateServiceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateServiceOutput`](crate::output::UpdateServiceOutput)
    pub fn builder() -> crate::output::update_service_output::Builder {
        crate::output::update_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateContainerInstancesStateOutput {
    /// <p>The list of container instances.</p>
    pub container_instances: std::option::Option<std::vec::Vec<crate::model::ContainerInstance>>,
    /// <p>Any failures associated with the call.</p>
    pub failures: std::option::Option<std::vec::Vec<crate::model::Failure>>,
}
impl UpdateContainerInstancesStateOutput {
    /// <p>The list of container instances.</p>
    pub fn container_instances(&self) -> std::option::Option<&[crate::model::ContainerInstance]> {
        self.container_instances.as_deref()
    }
    /// <p>Any failures associated with the call.</p>
    pub fn failures(&self) -> std::option::Option<&[crate::model::Failure]> {
        self.failures.as_deref()
    }
}
impl std::fmt::Debug for UpdateContainerInstancesStateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateContainerInstancesStateOutput");
        formatter.field("container_instances", &self.container_instances);
        formatter.field("failures", &self.failures);
        formatter.finish()
    }
}
/// See [`UpdateContainerInstancesStateOutput`](crate::output::UpdateContainerInstancesStateOutput)
pub mod update_container_instances_state_output {
    /// A builder for [`UpdateContainerInstancesStateOutput`](crate::output::UpdateContainerInstancesStateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_instances:
            std::option::Option<std::vec::Vec<crate::model::ContainerInstance>>,
        pub(crate) failures: std::option::Option<std::vec::Vec<crate::model::Failure>>,
    }
    impl Builder {
        /// Appends an item to `container_instances`.
        ///
        /// To override the contents of this collection use [`set_container_instances`](Self::set_container_instances).
        ///
        /// <p>The list of container instances.</p>
        pub fn container_instances(mut self, input: crate::model::ContainerInstance) -> Self {
            let mut v = self.container_instances.unwrap_or_default();
            v.push(input);
            self.container_instances = Some(v);
            self
        }
        /// <p>The list of container instances.</p>
        pub fn set_container_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContainerInstance>>,
        ) -> Self {
            self.container_instances = input;
            self
        }
        /// Appends an item to `failures`.
        ///
        /// To override the contents of this collection use [`set_failures`](Self::set_failures).
        ///
        /// <p>Any failures associated with the call.</p>
        pub fn failures(mut self, input: crate::model::Failure) -> Self {
            let mut v = self.failures.unwrap_or_default();
            v.push(input);
            self.failures = Some(v);
            self
        }
        /// <p>Any failures associated with the call.</p>
        pub fn set_failures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Failure>>,
        ) -> Self {
            self.failures = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateContainerInstancesStateOutput`](crate::output::UpdateContainerInstancesStateOutput)
        pub fn build(self) -> crate::output::UpdateContainerInstancesStateOutput {
            crate::output::UpdateContainerInstancesStateOutput {
                container_instances: self.container_instances,
                failures: self.failures,
            }
        }
    }
}
impl UpdateContainerInstancesStateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateContainerInstancesStateOutput`](crate::output::UpdateContainerInstancesStateOutput)
    pub fn builder() -> crate::output::update_container_instances_state_output::Builder {
        crate::output::update_container_instances_state_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateContainerAgentOutput {
    /// <p>The container instance that the container agent was updated for.</p>
    pub container_instance: std::option::Option<crate::model::ContainerInstance>,
}
impl UpdateContainerAgentOutput {
    /// <p>The container instance that the container agent was updated for.</p>
    pub fn container_instance(&self) -> std::option::Option<&crate::model::ContainerInstance> {
        self.container_instance.as_ref()
    }
}
impl std::fmt::Debug for UpdateContainerAgentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateContainerAgentOutput");
        formatter.field("container_instance", &self.container_instance);
        formatter.finish()
    }
}
/// See [`UpdateContainerAgentOutput`](crate::output::UpdateContainerAgentOutput)
pub mod update_container_agent_output {
    /// A builder for [`UpdateContainerAgentOutput`](crate::output::UpdateContainerAgentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_instance: std::option::Option<crate::model::ContainerInstance>,
    }
    impl Builder {
        /// <p>The container instance that the container agent was updated for.</p>
        pub fn container_instance(mut self, input: crate::model::ContainerInstance) -> Self {
            self.container_instance = Some(input);
            self
        }
        /// <p>The container instance that the container agent was updated for.</p>
        pub fn set_container_instance(
            mut self,
            input: std::option::Option<crate::model::ContainerInstance>,
        ) -> Self {
            self.container_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateContainerAgentOutput`](crate::output::UpdateContainerAgentOutput)
        pub fn build(self) -> crate::output::UpdateContainerAgentOutput {
            crate::output::UpdateContainerAgentOutput {
                container_instance: self.container_instance,
            }
        }
    }
}
impl UpdateContainerAgentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateContainerAgentOutput`](crate::output::UpdateContainerAgentOutput)
    pub fn builder() -> crate::output::update_container_agent_output::Builder {
        crate::output::update_container_agent_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateClusterSettingsOutput {
    /// <p>Details about the cluster</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl UpdateClusterSettingsOutput {
    /// <p>Details about the cluster</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for UpdateClusterSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateClusterSettingsOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`UpdateClusterSettingsOutput`](crate::output::UpdateClusterSettingsOutput)
pub mod update_cluster_settings_output {
    /// A builder for [`UpdateClusterSettingsOutput`](crate::output::UpdateClusterSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>Details about the cluster</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>Details about the cluster</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateClusterSettingsOutput`](crate::output::UpdateClusterSettingsOutput)
        pub fn build(self) -> crate::output::UpdateClusterSettingsOutput {
            crate::output::UpdateClusterSettingsOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl UpdateClusterSettingsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateClusterSettingsOutput`](crate::output::UpdateClusterSettingsOutput)
    pub fn builder() -> crate::output::update_cluster_settings_output::Builder {
        crate::output::update_cluster_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateClusterOutput {
    /// <p>Details about the cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl UpdateClusterOutput {
    /// <p>Details about the cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for UpdateClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateClusterOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`UpdateClusterOutput`](crate::output::UpdateClusterOutput)
pub mod update_cluster_output {
    /// A builder for [`UpdateClusterOutput`](crate::output::UpdateClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>Details about the cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>Details about the cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateClusterOutput`](crate::output::UpdateClusterOutput)
        pub fn build(self) -> crate::output::UpdateClusterOutput {
            crate::output::UpdateClusterOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl UpdateClusterOutput {
    /// Creates a new builder-style object to manufacture [`UpdateClusterOutput`](crate::output::UpdateClusterOutput)
    pub fn builder() -> crate::output::update_cluster_output::Builder {
        crate::output::update_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCapacityProviderOutput {
    /// <p>Details about the capacity provider.</p>
    pub capacity_provider: std::option::Option<crate::model::CapacityProvider>,
}
impl UpdateCapacityProviderOutput {
    /// <p>Details about the capacity provider.</p>
    pub fn capacity_provider(&self) -> std::option::Option<&crate::model::CapacityProvider> {
        self.capacity_provider.as_ref()
    }
}
impl std::fmt::Debug for UpdateCapacityProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCapacityProviderOutput");
        formatter.field("capacity_provider", &self.capacity_provider);
        formatter.finish()
    }
}
/// See [`UpdateCapacityProviderOutput`](crate::output::UpdateCapacityProviderOutput)
pub mod update_capacity_provider_output {
    /// A builder for [`UpdateCapacityProviderOutput`](crate::output::UpdateCapacityProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity_provider: std::option::Option<crate::model::CapacityProvider>,
    }
    impl Builder {
        /// <p>Details about the capacity provider.</p>
        pub fn capacity_provider(mut self, input: crate::model::CapacityProvider) -> Self {
            self.capacity_provider = Some(input);
            self
        }
        /// <p>Details about the capacity provider.</p>
        pub fn set_capacity_provider(
            mut self,
            input: std::option::Option<crate::model::CapacityProvider>,
        ) -> Self {
            self.capacity_provider = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCapacityProviderOutput`](crate::output::UpdateCapacityProviderOutput)
        pub fn build(self) -> crate::output::UpdateCapacityProviderOutput {
            crate::output::UpdateCapacityProviderOutput {
                capacity_provider: self.capacity_provider,
            }
        }
    }
}
impl UpdateCapacityProviderOutput {
    /// Creates a new builder-style object to manufacture [`UpdateCapacityProviderOutput`](crate::output::UpdateCapacityProviderOutput)
    pub fn builder() -> crate::output::update_capacity_provider_output::Builder {
        crate::output::update_capacity_provider_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubmitTaskStateChangeOutput {
    /// <p>Acknowledgement of the state change.</p>
    pub acknowledgment: std::option::Option<std::string::String>,
}
impl SubmitTaskStateChangeOutput {
    /// <p>Acknowledgement of the state change.</p>
    pub fn acknowledgment(&self) -> std::option::Option<&str> {
        self.acknowledgment.as_deref()
    }
}
impl std::fmt::Debug for SubmitTaskStateChangeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubmitTaskStateChangeOutput");
        formatter.field("acknowledgment", &self.acknowledgment);
        formatter.finish()
    }
}
/// See [`SubmitTaskStateChangeOutput`](crate::output::SubmitTaskStateChangeOutput)
pub mod submit_task_state_change_output {
    /// A builder for [`SubmitTaskStateChangeOutput`](crate::output::SubmitTaskStateChangeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acknowledgment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Acknowledgement of the state change.</p>
        pub fn acknowledgment(mut self, input: impl Into<std::string::String>) -> Self {
            self.acknowledgment = Some(input.into());
            self
        }
        /// <p>Acknowledgement of the state change.</p>
        pub fn set_acknowledgment(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.acknowledgment = input;
            self
        }
        /// Consumes the builder and constructs a [`SubmitTaskStateChangeOutput`](crate::output::SubmitTaskStateChangeOutput)
        pub fn build(self) -> crate::output::SubmitTaskStateChangeOutput {
            crate::output::SubmitTaskStateChangeOutput {
                acknowledgment: self.acknowledgment,
            }
        }
    }
}
impl SubmitTaskStateChangeOutput {
    /// Creates a new builder-style object to manufacture [`SubmitTaskStateChangeOutput`](crate::output::SubmitTaskStateChangeOutput)
    pub fn builder() -> crate::output::submit_task_state_change_output::Builder {
        crate::output::submit_task_state_change_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubmitContainerStateChangeOutput {
    /// <p>Acknowledgement of the state change.</p>
    pub acknowledgment: std::option::Option<std::string::String>,
}
impl SubmitContainerStateChangeOutput {
    /// <p>Acknowledgement of the state change.</p>
    pub fn acknowledgment(&self) -> std::option::Option<&str> {
        self.acknowledgment.as_deref()
    }
}
impl std::fmt::Debug for SubmitContainerStateChangeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubmitContainerStateChangeOutput");
        formatter.field("acknowledgment", &self.acknowledgment);
        formatter.finish()
    }
}
/// See [`SubmitContainerStateChangeOutput`](crate::output::SubmitContainerStateChangeOutput)
pub mod submit_container_state_change_output {
    /// A builder for [`SubmitContainerStateChangeOutput`](crate::output::SubmitContainerStateChangeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acknowledgment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Acknowledgement of the state change.</p>
        pub fn acknowledgment(mut self, input: impl Into<std::string::String>) -> Self {
            self.acknowledgment = Some(input.into());
            self
        }
        /// <p>Acknowledgement of the state change.</p>
        pub fn set_acknowledgment(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.acknowledgment = input;
            self
        }
        /// Consumes the builder and constructs a [`SubmitContainerStateChangeOutput`](crate::output::SubmitContainerStateChangeOutput)
        pub fn build(self) -> crate::output::SubmitContainerStateChangeOutput {
            crate::output::SubmitContainerStateChangeOutput {
                acknowledgment: self.acknowledgment,
            }
        }
    }
}
impl SubmitContainerStateChangeOutput {
    /// Creates a new builder-style object to manufacture [`SubmitContainerStateChangeOutput`](crate::output::SubmitContainerStateChangeOutput)
    pub fn builder() -> crate::output::submit_container_state_change_output::Builder {
        crate::output::submit_container_state_change_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubmitAttachmentStateChangesOutput {
    /// <p>Acknowledgement of the state change.</p>
    pub acknowledgment: std::option::Option<std::string::String>,
}
impl SubmitAttachmentStateChangesOutput {
    /// <p>Acknowledgement of the state change.</p>
    pub fn acknowledgment(&self) -> std::option::Option<&str> {
        self.acknowledgment.as_deref()
    }
}
impl std::fmt::Debug for SubmitAttachmentStateChangesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubmitAttachmentStateChangesOutput");
        formatter.field("acknowledgment", &self.acknowledgment);
        formatter.finish()
    }
}
/// See [`SubmitAttachmentStateChangesOutput`](crate::output::SubmitAttachmentStateChangesOutput)
pub mod submit_attachment_state_changes_output {
    /// A builder for [`SubmitAttachmentStateChangesOutput`](crate::output::SubmitAttachmentStateChangesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acknowledgment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Acknowledgement of the state change.</p>
        pub fn acknowledgment(mut self, input: impl Into<std::string::String>) -> Self {
            self.acknowledgment = Some(input.into());
            self
        }
        /// <p>Acknowledgement of the state change.</p>
        pub fn set_acknowledgment(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.acknowledgment = input;
            self
        }
        /// Consumes the builder and constructs a [`SubmitAttachmentStateChangesOutput`](crate::output::SubmitAttachmentStateChangesOutput)
        pub fn build(self) -> crate::output::SubmitAttachmentStateChangesOutput {
            crate::output::SubmitAttachmentStateChangesOutput {
                acknowledgment: self.acknowledgment,
            }
        }
    }
}
impl SubmitAttachmentStateChangesOutput {
    /// Creates a new builder-style object to manufacture [`SubmitAttachmentStateChangesOutput`](crate::output::SubmitAttachmentStateChangesOutput)
    pub fn builder() -> crate::output::submit_attachment_state_changes_output::Builder {
        crate::output::submit_attachment_state_changes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopTaskOutput {
    /// <p>The task that was stopped.</p>
    pub task: std::option::Option<crate::model::Task>,
}
impl StopTaskOutput {
    /// <p>The task that was stopped.</p>
    pub fn task(&self) -> std::option::Option<&crate::model::Task> {
        self.task.as_ref()
    }
}
impl std::fmt::Debug for StopTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopTaskOutput");
        formatter.field("task", &self.task);
        formatter.finish()
    }
}
/// See [`StopTaskOutput`](crate::output::StopTaskOutput)
pub mod stop_task_output {
    /// A builder for [`StopTaskOutput`](crate::output::StopTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task: std::option::Option<crate::model::Task>,
    }
    impl Builder {
        /// <p>The task that was stopped.</p>
        pub fn task(mut self, input: crate::model::Task) -> Self {
            self.task = Some(input);
            self
        }
        /// <p>The task that was stopped.</p>
        pub fn set_task(mut self, input: std::option::Option<crate::model::Task>) -> Self {
            self.task = input;
            self
        }
        /// Consumes the builder and constructs a [`StopTaskOutput`](crate::output::StopTaskOutput)
        pub fn build(self) -> crate::output::StopTaskOutput {
            crate::output::StopTaskOutput { task: self.task }
        }
    }
}
impl StopTaskOutput {
    /// Creates a new builder-style object to manufacture [`StopTaskOutput`](crate::output::StopTaskOutput)
    pub fn builder() -> crate::output::stop_task_output::Builder {
        crate::output::stop_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTaskOutput {
    /// <p>A full description of the tasks that were started. Each task that was successfully placed on your container instances is described.</p>
    pub tasks: std::option::Option<std::vec::Vec<crate::model::Task>>,
    /// <p>Any failures associated with the call.</p>
    pub failures: std::option::Option<std::vec::Vec<crate::model::Failure>>,
}
impl StartTaskOutput {
    /// <p>A full description of the tasks that were started. Each task that was successfully placed on your container instances is described.</p>
    pub fn tasks(&self) -> std::option::Option<&[crate::model::Task]> {
        self.tasks.as_deref()
    }
    /// <p>Any failures associated with the call.</p>
    pub fn failures(&self) -> std::option::Option<&[crate::model::Failure]> {
        self.failures.as_deref()
    }
}
impl std::fmt::Debug for StartTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTaskOutput");
        formatter.field("tasks", &self.tasks);
        formatter.field("failures", &self.failures);
        formatter.finish()
    }
}
/// See [`StartTaskOutput`](crate::output::StartTaskOutput)
pub mod start_task_output {
    /// A builder for [`StartTaskOutput`](crate::output::StartTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tasks: std::option::Option<std::vec::Vec<crate::model::Task>>,
        pub(crate) failures: std::option::Option<std::vec::Vec<crate::model::Failure>>,
    }
    impl Builder {
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p>A full description of the tasks that were started. Each task that was successfully placed on your container instances is described.</p>
        pub fn tasks(mut self, input: crate::model::Task) -> Self {
            let mut v = self.tasks.unwrap_or_default();
            v.push(input);
            self.tasks = Some(v);
            self
        }
        /// <p>A full description of the tasks that were started. Each task that was successfully placed on your container instances is described.</p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Task>>,
        ) -> Self {
            self.tasks = input;
            self
        }
        /// Appends an item to `failures`.
        ///
        /// To override the contents of this collection use [`set_failures`](Self::set_failures).
        ///
        /// <p>Any failures associated with the call.</p>
        pub fn failures(mut self, input: crate::model::Failure) -> Self {
            let mut v = self.failures.unwrap_or_default();
            v.push(input);
            self.failures = Some(v);
            self
        }
        /// <p>Any failures associated with the call.</p>
        pub fn set_failures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Failure>>,
        ) -> Self {
            self.failures = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTaskOutput`](crate::output::StartTaskOutput)
        pub fn build(self) -> crate::output::StartTaskOutput {
            crate::output::StartTaskOutput {
                tasks: self.tasks,
                failures: self.failures,
            }
        }
    }
}
impl StartTaskOutput {
    /// Creates a new builder-style object to manufacture [`StartTaskOutput`](crate::output::StartTaskOutput)
    pub fn builder() -> crate::output::start_task_output::Builder {
        crate::output::start_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RunTaskOutput {
    /// <p>A full description of the tasks that were run. The tasks that were successfully placed on your cluster are described here.</p>
    pub tasks: std::option::Option<std::vec::Vec<crate::model::Task>>,
    /// <p>Any failures associated with the call.</p>
    pub failures: std::option::Option<std::vec::Vec<crate::model::Failure>>,
}
impl RunTaskOutput {
    /// <p>A full description of the tasks that were run. The tasks that were successfully placed on your cluster are described here.</p>
    pub fn tasks(&self) -> std::option::Option<&[crate::model::Task]> {
        self.tasks.as_deref()
    }
    /// <p>Any failures associated with the call.</p>
    pub fn failures(&self) -> std::option::Option<&[crate::model::Failure]> {
        self.failures.as_deref()
    }
}
impl std::fmt::Debug for RunTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RunTaskOutput");
        formatter.field("tasks", &self.tasks);
        formatter.field("failures", &self.failures);
        formatter.finish()
    }
}
/// See [`RunTaskOutput`](crate::output::RunTaskOutput)
pub mod run_task_output {
    /// A builder for [`RunTaskOutput`](crate::output::RunTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tasks: std::option::Option<std::vec::Vec<crate::model::Task>>,
        pub(crate) failures: std::option::Option<std::vec::Vec<crate::model::Failure>>,
    }
    impl Builder {
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p>A full description of the tasks that were run. The tasks that were successfully placed on your cluster are described here.</p>
        pub fn tasks(mut self, input: crate::model::Task) -> Self {
            let mut v = self.tasks.unwrap_or_default();
            v.push(input);
            self.tasks = Some(v);
            self
        }
        /// <p>A full description of the tasks that were run. The tasks that were successfully placed on your cluster are described here.</p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Task>>,
        ) -> Self {
            self.tasks = input;
            self
        }
        /// Appends an item to `failures`.
        ///
        /// To override the contents of this collection use [`set_failures`](Self::set_failures).
        ///
        /// <p>Any failures associated with the call.</p>
        pub fn failures(mut self, input: crate::model::Failure) -> Self {
            let mut v = self.failures.unwrap_or_default();
            v.push(input);
            self.failures = Some(v);
            self
        }
        /// <p>Any failures associated with the call.</p>
        pub fn set_failures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Failure>>,
        ) -> Self {
            self.failures = input;
            self
        }
        /// Consumes the builder and constructs a [`RunTaskOutput`](crate::output::RunTaskOutput)
        pub fn build(self) -> crate::output::RunTaskOutput {
            crate::output::RunTaskOutput {
                tasks: self.tasks,
                failures: self.failures,
            }
        }
    }
}
impl RunTaskOutput {
    /// Creates a new builder-style object to manufacture [`RunTaskOutput`](crate::output::RunTaskOutput)
    pub fn builder() -> crate::output::run_task_output::Builder {
        crate::output::run_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterTaskDefinitionOutput {
    /// <p>The full description of the registered task definition.</p>
    pub task_definition: std::option::Option<crate::model::TaskDefinition>,
    /// <p>The list of tags associated with the task definition.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl RegisterTaskDefinitionOutput {
    /// <p>The full description of the registered task definition.</p>
    pub fn task_definition(&self) -> std::option::Option<&crate::model::TaskDefinition> {
        self.task_definition.as_ref()
    }
    /// <p>The list of tags associated with the task definition.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for RegisterTaskDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterTaskDefinitionOutput");
        formatter.field("task_definition", &self.task_definition);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`RegisterTaskDefinitionOutput`](crate::output::RegisterTaskDefinitionOutput)
pub mod register_task_definition_output {
    /// A builder for [`RegisterTaskDefinitionOutput`](crate::output::RegisterTaskDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_definition: std::option::Option<crate::model::TaskDefinition>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The full description of the registered task definition.</p>
        pub fn task_definition(mut self, input: crate::model::TaskDefinition) -> Self {
            self.task_definition = Some(input);
            self
        }
        /// <p>The full description of the registered task definition.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<crate::model::TaskDefinition>,
        ) -> Self {
            self.task_definition = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags associated with the task definition.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags associated with the task definition.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterTaskDefinitionOutput`](crate::output::RegisterTaskDefinitionOutput)
        pub fn build(self) -> crate::output::RegisterTaskDefinitionOutput {
            crate::output::RegisterTaskDefinitionOutput {
                task_definition: self.task_definition,
                tags: self.tags,
            }
        }
    }
}
impl RegisterTaskDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`RegisterTaskDefinitionOutput`](crate::output::RegisterTaskDefinitionOutput)
    pub fn builder() -> crate::output::register_task_definition_output::Builder {
        crate::output::register_task_definition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterContainerInstanceOutput {
    /// <p>The container instance that was registered.</p>
    pub container_instance: std::option::Option<crate::model::ContainerInstance>,
}
impl RegisterContainerInstanceOutput {
    /// <p>The container instance that was registered.</p>
    pub fn container_instance(&self) -> std::option::Option<&crate::model::ContainerInstance> {
        self.container_instance.as_ref()
    }
}
impl std::fmt::Debug for RegisterContainerInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterContainerInstanceOutput");
        formatter.field("container_instance", &self.container_instance);
        formatter.finish()
    }
}
/// See [`RegisterContainerInstanceOutput`](crate::output::RegisterContainerInstanceOutput)
pub mod register_container_instance_output {
    /// A builder for [`RegisterContainerInstanceOutput`](crate::output::RegisterContainerInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_instance: std::option::Option<crate::model::ContainerInstance>,
    }
    impl Builder {
        /// <p>The container instance that was registered.</p>
        pub fn container_instance(mut self, input: crate::model::ContainerInstance) -> Self {
            self.container_instance = Some(input);
            self
        }
        /// <p>The container instance that was registered.</p>
        pub fn set_container_instance(
            mut self,
            input: std::option::Option<crate::model::ContainerInstance>,
        ) -> Self {
            self.container_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterContainerInstanceOutput`](crate::output::RegisterContainerInstanceOutput)
        pub fn build(self) -> crate::output::RegisterContainerInstanceOutput {
            crate::output::RegisterContainerInstanceOutput {
                container_instance: self.container_instance,
            }
        }
    }
}
impl RegisterContainerInstanceOutput {
    /// Creates a new builder-style object to manufacture [`RegisterContainerInstanceOutput`](crate::output::RegisterContainerInstanceOutput)
    pub fn builder() -> crate::output::register_container_instance_output::Builder {
        crate::output::register_container_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutClusterCapacityProvidersOutput {
    /// <p>Details about the cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl PutClusterCapacityProvidersOutput {
    /// <p>Details about the cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for PutClusterCapacityProvidersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutClusterCapacityProvidersOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`PutClusterCapacityProvidersOutput`](crate::output::PutClusterCapacityProvidersOutput)
pub mod put_cluster_capacity_providers_output {
    /// A builder for [`PutClusterCapacityProvidersOutput`](crate::output::PutClusterCapacityProvidersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>Details about the cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>Details about the cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`PutClusterCapacityProvidersOutput`](crate::output::PutClusterCapacityProvidersOutput)
        pub fn build(self) -> crate::output::PutClusterCapacityProvidersOutput {
            crate::output::PutClusterCapacityProvidersOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl PutClusterCapacityProvidersOutput {
    /// Creates a new builder-style object to manufacture [`PutClusterCapacityProvidersOutput`](crate::output::PutClusterCapacityProvidersOutput)
    pub fn builder() -> crate::output::put_cluster_capacity_providers_output::Builder {
        crate::output::put_cluster_capacity_providers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAttributesOutput {
    /// <p>The attributes applied to your resource.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
}
impl PutAttributesOutput {
    /// <p>The attributes applied to your resource.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::Attribute]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for PutAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAttributesOutput");
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`PutAttributesOutput`](crate::output::PutAttributesOutput)
pub mod put_attributes_output {
    /// A builder for [`PutAttributesOutput`](crate::output::PutAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes applied to your resource.</p>
        pub fn attributes(mut self, input: crate::model::Attribute) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input);
            self.attributes = Some(v);
            self
        }
        /// <p>The attributes applied to your resource.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAttributesOutput`](crate::output::PutAttributesOutput)
        pub fn build(self) -> crate::output::PutAttributesOutput {
            crate::output::PutAttributesOutput {
                attributes: self.attributes,
            }
        }
    }
}
impl PutAttributesOutput {
    /// Creates a new builder-style object to manufacture [`PutAttributesOutput`](crate::output::PutAttributesOutput)
    pub fn builder() -> crate::output::put_attributes_output::Builder {
        crate::output::put_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAccountSettingDefaultOutput {
    /// <p>The current setting for a resource.</p>
    pub setting: std::option::Option<crate::model::Setting>,
}
impl PutAccountSettingDefaultOutput {
    /// <p>The current setting for a resource.</p>
    pub fn setting(&self) -> std::option::Option<&crate::model::Setting> {
        self.setting.as_ref()
    }
}
impl std::fmt::Debug for PutAccountSettingDefaultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAccountSettingDefaultOutput");
        formatter.field("setting", &self.setting);
        formatter.finish()
    }
}
/// See [`PutAccountSettingDefaultOutput`](crate::output::PutAccountSettingDefaultOutput)
pub mod put_account_setting_default_output {
    /// A builder for [`PutAccountSettingDefaultOutput`](crate::output::PutAccountSettingDefaultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) setting: std::option::Option<crate::model::Setting>,
    }
    impl Builder {
        /// <p>The current setting for a resource.</p>
        pub fn setting(mut self, input: crate::model::Setting) -> Self {
            self.setting = Some(input);
            self
        }
        /// <p>The current setting for a resource.</p>
        pub fn set_setting(mut self, input: std::option::Option<crate::model::Setting>) -> Self {
            self.setting = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAccountSettingDefaultOutput`](crate::output::PutAccountSettingDefaultOutput)
        pub fn build(self) -> crate::output::PutAccountSettingDefaultOutput {
            crate::output::PutAccountSettingDefaultOutput {
                setting: self.setting,
            }
        }
    }
}
impl PutAccountSettingDefaultOutput {
    /// Creates a new builder-style object to manufacture [`PutAccountSettingDefaultOutput`](crate::output::PutAccountSettingDefaultOutput)
    pub fn builder() -> crate::output::put_account_setting_default_output::Builder {
        crate::output::put_account_setting_default_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAccountSettingOutput {
    /// <p>The current account setting for a resource.</p>
    pub setting: std::option::Option<crate::model::Setting>,
}
impl PutAccountSettingOutput {
    /// <p>The current account setting for a resource.</p>
    pub fn setting(&self) -> std::option::Option<&crate::model::Setting> {
        self.setting.as_ref()
    }
}
impl std::fmt::Debug for PutAccountSettingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAccountSettingOutput");
        formatter.field("setting", &self.setting);
        formatter.finish()
    }
}
/// See [`PutAccountSettingOutput`](crate::output::PutAccountSettingOutput)
pub mod put_account_setting_output {
    /// A builder for [`PutAccountSettingOutput`](crate::output::PutAccountSettingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) setting: std::option::Option<crate::model::Setting>,
    }
    impl Builder {
        /// <p>The current account setting for a resource.</p>
        pub fn setting(mut self, input: crate::model::Setting) -> Self {
            self.setting = Some(input);
            self
        }
        /// <p>The current account setting for a resource.</p>
        pub fn set_setting(mut self, input: std::option::Option<crate::model::Setting>) -> Self {
            self.setting = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAccountSettingOutput`](crate::output::PutAccountSettingOutput)
        pub fn build(self) -> crate::output::PutAccountSettingOutput {
            crate::output::PutAccountSettingOutput {
                setting: self.setting,
            }
        }
    }
}
impl PutAccountSettingOutput {
    /// Creates a new builder-style object to manufacture [`PutAccountSettingOutput`](crate::output::PutAccountSettingOutput)
    pub fn builder() -> crate::output::put_account_setting_output::Builder {
        crate::output::put_account_setting_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTasksOutput {
    /// <p>The list of task ARN entries for the <code>ListTasks</code> request.</p>
    pub task_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListTasks</code> request. When the results of a <code>ListTasks</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTasksOutput {
    /// <p>The list of task ARN entries for the <code>ListTasks</code> request.</p>
    pub fn task_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.task_arns.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListTasks</code> request. When the results of a <code>ListTasks</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTasksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTasksOutput");
        formatter.field("task_arns", &self.task_arns);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTasksOutput`](crate::output::ListTasksOutput)
pub mod list_tasks_output {
    /// A builder for [`ListTasksOutput`](crate::output::ListTasksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `task_arns`.
        ///
        /// To override the contents of this collection use [`set_task_arns`](Self::set_task_arns).
        ///
        /// <p>The list of task ARN entries for the <code>ListTasks</code> request.</p>
        pub fn task_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.task_arns.unwrap_or_default();
            v.push(input.into());
            self.task_arns = Some(v);
            self
        }
        /// <p>The list of task ARN entries for the <code>ListTasks</code> request.</p>
        pub fn set_task_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.task_arns = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListTasks</code> request. When the results of a <code>ListTasks</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListTasks</code> request. When the results of a <code>ListTasks</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTasksOutput`](crate::output::ListTasksOutput)
        pub fn build(self) -> crate::output::ListTasksOutput {
            crate::output::ListTasksOutput {
                task_arns: self.task_arns,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTasksOutput {
    /// Creates a new builder-style object to manufacture [`ListTasksOutput`](crate::output::ListTasksOutput)
    pub fn builder() -> crate::output::list_tasks_output::Builder {
        crate::output::list_tasks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTaskDefinitionsOutput {
    /// <p>The list of task definition Amazon Resource Name (ARN) entries for the <code>ListTaskDefinitions</code> request.</p>
    pub task_definition_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListTaskDefinitions</code> request. When the results of a <code>ListTaskDefinitions</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTaskDefinitionsOutput {
    /// <p>The list of task definition Amazon Resource Name (ARN) entries for the <code>ListTaskDefinitions</code> request.</p>
    pub fn task_definition_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.task_definition_arns.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListTaskDefinitions</code> request. When the results of a <code>ListTaskDefinitions</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTaskDefinitionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTaskDefinitionsOutput");
        formatter.field("task_definition_arns", &self.task_definition_arns);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTaskDefinitionsOutput`](crate::output::ListTaskDefinitionsOutput)
pub mod list_task_definitions_output {
    /// A builder for [`ListTaskDefinitionsOutput`](crate::output::ListTaskDefinitionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_definition_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `task_definition_arns`.
        ///
        /// To override the contents of this collection use [`set_task_definition_arns`](Self::set_task_definition_arns).
        ///
        /// <p>The list of task definition Amazon Resource Name (ARN) entries for the <code>ListTaskDefinitions</code> request.</p>
        pub fn task_definition_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.task_definition_arns.unwrap_or_default();
            v.push(input.into());
            self.task_definition_arns = Some(v);
            self
        }
        /// <p>The list of task definition Amazon Resource Name (ARN) entries for the <code>ListTaskDefinitions</code> request.</p>
        pub fn set_task_definition_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.task_definition_arns = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListTaskDefinitions</code> request. When the results of a <code>ListTaskDefinitions</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListTaskDefinitions</code> request. When the results of a <code>ListTaskDefinitions</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTaskDefinitionsOutput`](crate::output::ListTaskDefinitionsOutput)
        pub fn build(self) -> crate::output::ListTaskDefinitionsOutput {
            crate::output::ListTaskDefinitionsOutput {
                task_definition_arns: self.task_definition_arns,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTaskDefinitionsOutput {
    /// Creates a new builder-style object to manufacture [`ListTaskDefinitionsOutput`](crate::output::ListTaskDefinitionsOutput)
    pub fn builder() -> crate::output::list_task_definitions_output::Builder {
        crate::output::list_task_definitions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTaskDefinitionFamiliesOutput {
    /// <p>The list of task definition family names that match the <code>ListTaskDefinitionFamilies</code> request.</p>
    pub families: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListTaskDefinitionFamilies</code> request. When the results of a <code>ListTaskDefinitionFamilies</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTaskDefinitionFamiliesOutput {
    /// <p>The list of task definition family names that match the <code>ListTaskDefinitionFamilies</code> request.</p>
    pub fn families(&self) -> std::option::Option<&[std::string::String]> {
        self.families.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListTaskDefinitionFamilies</code> request. When the results of a <code>ListTaskDefinitionFamilies</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTaskDefinitionFamiliesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTaskDefinitionFamiliesOutput");
        formatter.field("families", &self.families);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTaskDefinitionFamiliesOutput`](crate::output::ListTaskDefinitionFamiliesOutput)
pub mod list_task_definition_families_output {
    /// A builder for [`ListTaskDefinitionFamiliesOutput`](crate::output::ListTaskDefinitionFamiliesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) families: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `families`.
        ///
        /// To override the contents of this collection use [`set_families`](Self::set_families).
        ///
        /// <p>The list of task definition family names that match the <code>ListTaskDefinitionFamilies</code> request.</p>
        pub fn families(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.families.unwrap_or_default();
            v.push(input.into());
            self.families = Some(v);
            self
        }
        /// <p>The list of task definition family names that match the <code>ListTaskDefinitionFamilies</code> request.</p>
        pub fn set_families(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.families = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListTaskDefinitionFamilies</code> request. When the results of a <code>ListTaskDefinitionFamilies</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListTaskDefinitionFamilies</code> request. When the results of a <code>ListTaskDefinitionFamilies</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTaskDefinitionFamiliesOutput`](crate::output::ListTaskDefinitionFamiliesOutput)
        pub fn build(self) -> crate::output::ListTaskDefinitionFamiliesOutput {
            crate::output::ListTaskDefinitionFamiliesOutput {
                families: self.families,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTaskDefinitionFamiliesOutput {
    /// Creates a new builder-style object to manufacture [`ListTaskDefinitionFamiliesOutput`](crate::output::ListTaskDefinitionFamiliesOutput)
    pub fn builder() -> crate::output::list_task_definition_families_output::Builder {
        crate::output::list_task_definition_families_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags for the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags for the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServicesOutput {
    /// <p>The list of full ARN entries for each service that's associated with the specified cluster.</p>
    pub service_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListServices</code> request. When the results of a <code>ListServices</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListServicesOutput {
    /// <p>The list of full ARN entries for each service that's associated with the specified cluster.</p>
    pub fn service_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.service_arns.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListServices</code> request. When the results of a <code>ListServices</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListServicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServicesOutput");
        formatter.field("service_arns", &self.service_arns);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListServicesOutput`](crate::output::ListServicesOutput)
pub mod list_services_output {
    /// A builder for [`ListServicesOutput`](crate::output::ListServicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `service_arns`.
        ///
        /// To override the contents of this collection use [`set_service_arns`](Self::set_service_arns).
        ///
        /// <p>The list of full ARN entries for each service that's associated with the specified cluster.</p>
        pub fn service_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.service_arns.unwrap_or_default();
            v.push(input.into());
            self.service_arns = Some(v);
            self
        }
        /// <p>The list of full ARN entries for each service that's associated with the specified cluster.</p>
        pub fn set_service_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.service_arns = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListServices</code> request. When the results of a <code>ListServices</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListServices</code> request. When the results of a <code>ListServices</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServicesOutput`](crate::output::ListServicesOutput)
        pub fn build(self) -> crate::output::ListServicesOutput {
            crate::output::ListServicesOutput {
                service_arns: self.service_arns,
                next_token: self.next_token,
            }
        }
    }
}
impl ListServicesOutput {
    /// Creates a new builder-style object to manufacture [`ListServicesOutput`](crate::output::ListServicesOutput)
    pub fn builder() -> crate::output::list_services_output::Builder {
        crate::output::list_services_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListContainerInstancesOutput {
    /// <p>The list of container instances with full ARN entries for each container instance associated with the specified cluster.</p>
    pub container_instance_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListContainerInstances</code> request. When the results of a <code>ListContainerInstances</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListContainerInstancesOutput {
    /// <p>The list of container instances with full ARN entries for each container instance associated with the specified cluster.</p>
    pub fn container_instance_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.container_instance_arns.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListContainerInstances</code> request. When the results of a <code>ListContainerInstances</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListContainerInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListContainerInstancesOutput");
        formatter.field("container_instance_arns", &self.container_instance_arns);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListContainerInstancesOutput`](crate::output::ListContainerInstancesOutput)
pub mod list_container_instances_output {
    /// A builder for [`ListContainerInstancesOutput`](crate::output::ListContainerInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_instance_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `container_instance_arns`.
        ///
        /// To override the contents of this collection use [`set_container_instance_arns`](Self::set_container_instance_arns).
        ///
        /// <p>The list of container instances with full ARN entries for each container instance associated with the specified cluster.</p>
        pub fn container_instance_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.container_instance_arns.unwrap_or_default();
            v.push(input.into());
            self.container_instance_arns = Some(v);
            self
        }
        /// <p>The list of container instances with full ARN entries for each container instance associated with the specified cluster.</p>
        pub fn set_container_instance_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.container_instance_arns = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListContainerInstances</code> request. When the results of a <code>ListContainerInstances</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListContainerInstances</code> request. When the results of a <code>ListContainerInstances</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContainerInstancesOutput`](crate::output::ListContainerInstancesOutput)
        pub fn build(self) -> crate::output::ListContainerInstancesOutput {
            crate::output::ListContainerInstancesOutput {
                container_instance_arns: self.container_instance_arns,
                next_token: self.next_token,
            }
        }
    }
}
impl ListContainerInstancesOutput {
    /// Creates a new builder-style object to manufacture [`ListContainerInstancesOutput`](crate::output::ListContainerInstancesOutput)
    pub fn builder() -> crate::output::list_container_instances_output::Builder {
        crate::output::list_container_instances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListClustersOutput {
    /// <p>The list of full Amazon Resource Name (ARN) entries for each cluster that's associated with your account.</p>
    pub cluster_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListClusters</code> request. When the results of a <code>ListClusters</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListClustersOutput {
    /// <p>The list of full Amazon Resource Name (ARN) entries for each cluster that's associated with your account.</p>
    pub fn cluster_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.cluster_arns.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListClusters</code> request. When the results of a <code>ListClusters</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListClustersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListClustersOutput");
        formatter.field("cluster_arns", &self.cluster_arns);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListClustersOutput`](crate::output::ListClustersOutput)
pub mod list_clusters_output {
    /// A builder for [`ListClustersOutput`](crate::output::ListClustersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `cluster_arns`.
        ///
        /// To override the contents of this collection use [`set_cluster_arns`](Self::set_cluster_arns).
        ///
        /// <p>The list of full Amazon Resource Name (ARN) entries for each cluster that's associated with your account.</p>
        pub fn cluster_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cluster_arns.unwrap_or_default();
            v.push(input.into());
            self.cluster_arns = Some(v);
            self
        }
        /// <p>The list of full Amazon Resource Name (ARN) entries for each cluster that's associated with your account.</p>
        pub fn set_cluster_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cluster_arns = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListClusters</code> request. When the results of a <code>ListClusters</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListClusters</code> request. When the results of a <code>ListClusters</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListClustersOutput`](crate::output::ListClustersOutput)
        pub fn build(self) -> crate::output::ListClustersOutput {
            crate::output::ListClustersOutput {
                cluster_arns: self.cluster_arns,
                next_token: self.next_token,
            }
        }
    }
}
impl ListClustersOutput {
    /// Creates a new builder-style object to manufacture [`ListClustersOutput`](crate::output::ListClustersOutput)
    pub fn builder() -> crate::output::list_clusters_output::Builder {
        crate::output::list_clusters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAttributesOutput {
    /// <p>A list of attribute objects that meet the criteria of the request.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListAttributes</code> request. When the results of a <code>ListAttributes</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAttributesOutput {
    /// <p>A list of attribute objects that meet the criteria of the request.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::Attribute]> {
        self.attributes.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListAttributes</code> request. When the results of a <code>ListAttributes</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAttributesOutput");
        formatter.field("attributes", &self.attributes);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAttributesOutput`](crate::output::ListAttributesOutput)
pub mod list_attributes_output {
    /// A builder for [`ListAttributesOutput`](crate::output::ListAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A list of attribute objects that meet the criteria of the request.</p>
        pub fn attributes(mut self, input: crate::model::Attribute) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input);
            self.attributes = Some(v);
            self
        }
        /// <p>A list of attribute objects that meet the criteria of the request.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListAttributes</code> request. When the results of a <code>ListAttributes</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListAttributes</code> request. When the results of a <code>ListAttributes</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAttributesOutput`](crate::output::ListAttributesOutput)
        pub fn build(self) -> crate::output::ListAttributesOutput {
            crate::output::ListAttributesOutput {
                attributes: self.attributes,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAttributesOutput {
    /// Creates a new builder-style object to manufacture [`ListAttributesOutput`](crate::output::ListAttributesOutput)
    pub fn builder() -> crate::output::list_attributes_output::Builder {
        crate::output::list_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccountSettingsOutput {
    /// <p>The account settings for the resource.</p>
    pub settings: std::option::Option<std::vec::Vec<crate::model::Setting>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListAccountSettings</code> request. When the results of a <code>ListAccountSettings</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAccountSettingsOutput {
    /// <p>The account settings for the resource.</p>
    pub fn settings(&self) -> std::option::Option<&[crate::model::Setting]> {
        self.settings.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListAccountSettings</code> request. When the results of a <code>ListAccountSettings</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAccountSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccountSettingsOutput");
        formatter.field("settings", &self.settings);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAccountSettingsOutput`](crate::output::ListAccountSettingsOutput)
pub mod list_account_settings_output {
    /// A builder for [`ListAccountSettingsOutput`](crate::output::ListAccountSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) settings: std::option::Option<std::vec::Vec<crate::model::Setting>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `settings`.
        ///
        /// To override the contents of this collection use [`set_settings`](Self::set_settings).
        ///
        /// <p>The account settings for the resource.</p>
        pub fn settings(mut self, input: crate::model::Setting) -> Self {
            let mut v = self.settings.unwrap_or_default();
            v.push(input);
            self.settings = Some(v);
            self
        }
        /// <p>The account settings for the resource.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Setting>>,
        ) -> Self {
            self.settings = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListAccountSettings</code> request. When the results of a <code>ListAccountSettings</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListAccountSettings</code> request. When the results of a <code>ListAccountSettings</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountSettingsOutput`](crate::output::ListAccountSettingsOutput)
        pub fn build(self) -> crate::output::ListAccountSettingsOutput {
            crate::output::ListAccountSettingsOutput {
                settings: self.settings,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAccountSettingsOutput {
    /// Creates a new builder-style object to manufacture [`ListAccountSettingsOutput`](crate::output::ListAccountSettingsOutput)
    pub fn builder() -> crate::output::list_account_settings_output::Builder {
        crate::output::list_account_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteCommandOutput {
    /// <p>The Amazon Resource Name (ARN) of the cluster.</p>
    pub cluster_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the container.</p>
    pub container_arn: std::option::Option<std::string::String>,
    /// <p>The name of the container.</p>
    pub container_name: std::option::Option<std::string::String>,
    /// <p>Determines whether the execute command session is running in interactive mode. Amazon ECS only supports initiating interactive sessions, so you must specify <code>true</code> for this value.</p>
    pub interactive: bool,
    /// <p>The details of the SSM session that was created for this instance of execute-command.</p>
    pub session: std::option::Option<crate::model::Session>,
    /// <p>The Amazon Resource Name (ARN) of the task.</p>
    pub task_arn: std::option::Option<std::string::String>,
}
impl ExecuteCommandOutput {
    /// <p>The Amazon Resource Name (ARN) of the cluster.</p>
    pub fn cluster_arn(&self) -> std::option::Option<&str> {
        self.cluster_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the container.</p>
    pub fn container_arn(&self) -> std::option::Option<&str> {
        self.container_arn.as_deref()
    }
    /// <p>The name of the container.</p>
    pub fn container_name(&self) -> std::option::Option<&str> {
        self.container_name.as_deref()
    }
    /// <p>Determines whether the execute command session is running in interactive mode. Amazon ECS only supports initiating interactive sessions, so you must specify <code>true</code> for this value.</p>
    pub fn interactive(&self) -> bool {
        self.interactive
    }
    /// <p>The details of the SSM session that was created for this instance of execute-command.</p>
    pub fn session(&self) -> std::option::Option<&crate::model::Session> {
        self.session.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the task.</p>
    pub fn task_arn(&self) -> std::option::Option<&str> {
        self.task_arn.as_deref()
    }
}
impl std::fmt::Debug for ExecuteCommandOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteCommandOutput");
        formatter.field("cluster_arn", &self.cluster_arn);
        formatter.field("container_arn", &self.container_arn);
        formatter.field("container_name", &self.container_name);
        formatter.field("interactive", &self.interactive);
        formatter.field("session", &self.session);
        formatter.field("task_arn", &self.task_arn);
        formatter.finish()
    }
}
/// See [`ExecuteCommandOutput`](crate::output::ExecuteCommandOutput)
pub mod execute_command_output {
    /// A builder for [`ExecuteCommandOutput`](crate::output::ExecuteCommandOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_arn: std::option::Option<std::string::String>,
        pub(crate) container_arn: std::option::Option<std::string::String>,
        pub(crate) container_name: std::option::Option<std::string::String>,
        pub(crate) interactive: std::option::Option<bool>,
        pub(crate) session: std::option::Option<crate::model::Session>,
        pub(crate) task_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the cluster.</p>
        pub fn cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container.</p>
        pub fn container_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container.</p>
        pub fn set_container_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_arn = input;
            self
        }
        /// <p>The name of the container.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_name = Some(input.into());
            self
        }
        /// <p>The name of the container.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_name = input;
            self
        }
        /// <p>Determines whether the execute command session is running in interactive mode. Amazon ECS only supports initiating interactive sessions, so you must specify <code>true</code> for this value.</p>
        pub fn interactive(mut self, input: bool) -> Self {
            self.interactive = Some(input);
            self
        }
        /// <p>Determines whether the execute command session is running in interactive mode. Amazon ECS only supports initiating interactive sessions, so you must specify <code>true</code> for this value.</p>
        pub fn set_interactive(mut self, input: std::option::Option<bool>) -> Self {
            self.interactive = input;
            self
        }
        /// <p>The details of the SSM session that was created for this instance of execute-command.</p>
        pub fn session(mut self, input: crate::model::Session) -> Self {
            self.session = Some(input);
            self
        }
        /// <p>The details of the SSM session that was created for this instance of execute-command.</p>
        pub fn set_session(mut self, input: std::option::Option<crate::model::Session>) -> Self {
            self.session = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task.</p>
        pub fn task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteCommandOutput`](crate::output::ExecuteCommandOutput)
        pub fn build(self) -> crate::output::ExecuteCommandOutput {
            crate::output::ExecuteCommandOutput {
                cluster_arn: self.cluster_arn,
                container_arn: self.container_arn,
                container_name: self.container_name,
                interactive: self.interactive.unwrap_or_default(),
                session: self.session,
                task_arn: self.task_arn,
            }
        }
    }
}
impl ExecuteCommandOutput {
    /// Creates a new builder-style object to manufacture [`ExecuteCommandOutput`](crate::output::ExecuteCommandOutput)
    pub fn builder() -> crate::output::execute_command_output::Builder {
        crate::output::execute_command_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DiscoverPollEndpointOutput {
    /// <p>The endpoint for the Amazon ECS agent to poll.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The telemetry endpoint for the Amazon ECS agent.</p>
    pub telemetry_endpoint: std::option::Option<std::string::String>,
}
impl DiscoverPollEndpointOutput {
    /// <p>The endpoint for the Amazon ECS agent to poll.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The telemetry endpoint for the Amazon ECS agent.</p>
    pub fn telemetry_endpoint(&self) -> std::option::Option<&str> {
        self.telemetry_endpoint.as_deref()
    }
}
impl std::fmt::Debug for DiscoverPollEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DiscoverPollEndpointOutput");
        formatter.field("endpoint", &self.endpoint);
        formatter.field("telemetry_endpoint", &self.telemetry_endpoint);
        formatter.finish()
    }
}
/// See [`DiscoverPollEndpointOutput`](crate::output::DiscoverPollEndpointOutput)
pub mod discover_poll_endpoint_output {
    /// A builder for [`DiscoverPollEndpointOutput`](crate::output::DiscoverPollEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) telemetry_endpoint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The endpoint for the Amazon ECS agent to poll.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint for the Amazon ECS agent to poll.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The telemetry endpoint for the Amazon ECS agent.</p>
        pub fn telemetry_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.telemetry_endpoint = Some(input.into());
            self
        }
        /// <p>The telemetry endpoint for the Amazon ECS agent.</p>
        pub fn set_telemetry_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.telemetry_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`DiscoverPollEndpointOutput`](crate::output::DiscoverPollEndpointOutput)
        pub fn build(self) -> crate::output::DiscoverPollEndpointOutput {
            crate::output::DiscoverPollEndpointOutput {
                endpoint: self.endpoint,
                telemetry_endpoint: self.telemetry_endpoint,
            }
        }
    }
}
impl DiscoverPollEndpointOutput {
    /// Creates a new builder-style object to manufacture [`DiscoverPollEndpointOutput`](crate::output::DiscoverPollEndpointOutput)
    pub fn builder() -> crate::output::discover_poll_endpoint_output::Builder {
        crate::output::discover_poll_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTaskSetsOutput {
    /// <p>The list of task sets described.</p>
    pub task_sets: std::option::Option<std::vec::Vec<crate::model::TaskSet>>,
    /// <p>Any failures associated with the call.</p>
    pub failures: std::option::Option<std::vec::Vec<crate::model::Failure>>,
}
impl DescribeTaskSetsOutput {
    /// <p>The list of task sets described.</p>
    pub fn task_sets(&self) -> std::option::Option<&[crate::model::TaskSet]> {
        self.task_sets.as_deref()
    }
    /// <p>Any failures associated with the call.</p>
    pub fn failures(&self) -> std::option::Option<&[crate::model::Failure]> {
        self.failures.as_deref()
    }
}
impl std::fmt::Debug for DescribeTaskSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTaskSetsOutput");
        formatter.field("task_sets", &self.task_sets);
        formatter.field("failures", &self.failures);
        formatter.finish()
    }
}
/// See [`DescribeTaskSetsOutput`](crate::output::DescribeTaskSetsOutput)
pub mod describe_task_sets_output {
    /// A builder for [`DescribeTaskSetsOutput`](crate::output::DescribeTaskSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_sets: std::option::Option<std::vec::Vec<crate::model::TaskSet>>,
        pub(crate) failures: std::option::Option<std::vec::Vec<crate::model::Failure>>,
    }
    impl Builder {
        /// Appends an item to `task_sets`.
        ///
        /// To override the contents of this collection use [`set_task_sets`](Self::set_task_sets).
        ///
        /// <p>The list of task sets described.</p>
        pub fn task_sets(mut self, input: crate::model::TaskSet) -> Self {
            let mut v = self.task_sets.unwrap_or_default();
            v.push(input);
            self.task_sets = Some(v);
            self
        }
        /// <p>The list of task sets described.</p>
        pub fn set_task_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TaskSet>>,
        ) -> Self {
            self.task_sets = input;
            self
        }
        /// Appends an item to `failures`.
        ///
        /// To override the contents of this collection use [`set_failures`](Self::set_failures).
        ///
        /// <p>Any failures associated with the call.</p>
        pub fn failures(mut self, input: crate::model::Failure) -> Self {
            let mut v = self.failures.unwrap_or_default();
            v.push(input);
            self.failures = Some(v);
            self
        }
        /// <p>Any failures associated with the call.</p>
        pub fn set_failures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Failure>>,
        ) -> Self {
            self.failures = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTaskSetsOutput`](crate::output::DescribeTaskSetsOutput)
        pub fn build(self) -> crate::output::DescribeTaskSetsOutput {
            crate::output::DescribeTaskSetsOutput {
                task_sets: self.task_sets,
                failures: self.failures,
            }
        }
    }
}
impl DescribeTaskSetsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTaskSetsOutput`](crate::output::DescribeTaskSetsOutput)
    pub fn builder() -> crate::output::describe_task_sets_output::Builder {
        crate::output::describe_task_sets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTasksOutput {
    /// <p>The list of tasks.</p>
    pub tasks: std::option::Option<std::vec::Vec<crate::model::Task>>,
    /// <p>Any failures associated with the call.</p>
    pub failures: std::option::Option<std::vec::Vec<crate::model::Failure>>,
}
impl DescribeTasksOutput {
    /// <p>The list of tasks.</p>
    pub fn tasks(&self) -> std::option::Option<&[crate::model::Task]> {
        self.tasks.as_deref()
    }
    /// <p>Any failures associated with the call.</p>
    pub fn failures(&self) -> std::option::Option<&[crate::model::Failure]> {
        self.failures.as_deref()
    }
}
impl std::fmt::Debug for DescribeTasksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTasksOutput");
        formatter.field("tasks", &self.tasks);
        formatter.field("failures", &self.failures);
        formatter.finish()
    }
}
/// See [`DescribeTasksOutput`](crate::output::DescribeTasksOutput)
pub mod describe_tasks_output {
    /// A builder for [`DescribeTasksOutput`](crate::output::DescribeTasksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tasks: std::option::Option<std::vec::Vec<crate::model::Task>>,
        pub(crate) failures: std::option::Option<std::vec::Vec<crate::model::Failure>>,
    }
    impl Builder {
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p>The list of tasks.</p>
        pub fn tasks(mut self, input: crate::model::Task) -> Self {
            let mut v = self.tasks.unwrap_or_default();
            v.push(input);
            self.tasks = Some(v);
            self
        }
        /// <p>The list of tasks.</p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Task>>,
        ) -> Self {
            self.tasks = input;
            self
        }
        /// Appends an item to `failures`.
        ///
        /// To override the contents of this collection use [`set_failures`](Self::set_failures).
        ///
        /// <p>Any failures associated with the call.</p>
        pub fn failures(mut self, input: crate::model::Failure) -> Self {
            let mut v = self.failures.unwrap_or_default();
            v.push(input);
            self.failures = Some(v);
            self
        }
        /// <p>Any failures associated with the call.</p>
        pub fn set_failures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Failure>>,
        ) -> Self {
            self.failures = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTasksOutput`](crate::output::DescribeTasksOutput)
        pub fn build(self) -> crate::output::DescribeTasksOutput {
            crate::output::DescribeTasksOutput {
                tasks: self.tasks,
                failures: self.failures,
            }
        }
    }
}
impl DescribeTasksOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTasksOutput`](crate::output::DescribeTasksOutput)
    pub fn builder() -> crate::output::describe_tasks_output::Builder {
        crate::output::describe_tasks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTaskDefinitionOutput {
    /// <p>The full task definition description.</p>
    pub task_definition: std::option::Option<crate::model::TaskDefinition>,
    /// <p>The metadata that's applied to the task definition to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.</p>
    /// <p>The following basic restrictions apply to tags:</p>
    /// <ul>
    /// <li> <p>Maximum number of tags per resource - 50</p> </li>
    /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
    /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
    /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
    /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
    /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl DescribeTaskDefinitionOutput {
    /// <p>The full task definition description.</p>
    pub fn task_definition(&self) -> std::option::Option<&crate::model::TaskDefinition> {
        self.task_definition.as_ref()
    }
    /// <p>The metadata that's applied to the task definition to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.</p>
    /// <p>The following basic restrictions apply to tags:</p>
    /// <ul>
    /// <li> <p>Maximum number of tags per resource - 50</p> </li>
    /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
    /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
    /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
    /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
    /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
    /// </ul>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for DescribeTaskDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTaskDefinitionOutput");
        formatter.field("task_definition", &self.task_definition);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeTaskDefinitionOutput`](crate::output::DescribeTaskDefinitionOutput)
pub mod describe_task_definition_output {
    /// A builder for [`DescribeTaskDefinitionOutput`](crate::output::DescribeTaskDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_definition: std::option::Option<crate::model::TaskDefinition>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The full task definition description.</p>
        pub fn task_definition(mut self, input: crate::model::TaskDefinition) -> Self {
            self.task_definition = Some(input);
            self
        }
        /// <p>The full task definition description.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<crate::model::TaskDefinition>,
        ) -> Self {
            self.task_definition = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that's applied to the task definition to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The metadata that's applied to the task definition to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTaskDefinitionOutput`](crate::output::DescribeTaskDefinitionOutput)
        pub fn build(self) -> crate::output::DescribeTaskDefinitionOutput {
            crate::output::DescribeTaskDefinitionOutput {
                task_definition: self.task_definition,
                tags: self.tags,
            }
        }
    }
}
impl DescribeTaskDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTaskDefinitionOutput`](crate::output::DescribeTaskDefinitionOutput)
    pub fn builder() -> crate::output::describe_task_definition_output::Builder {
        crate::output::describe_task_definition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServicesOutput {
    /// <p>The list of services described.</p>
    pub services: std::option::Option<std::vec::Vec<crate::model::Service>>,
    /// <p>Any failures associated with the call.</p>
    pub failures: std::option::Option<std::vec::Vec<crate::model::Failure>>,
}
impl DescribeServicesOutput {
    /// <p>The list of services described.</p>
    pub fn services(&self) -> std::option::Option<&[crate::model::Service]> {
        self.services.as_deref()
    }
    /// <p>Any failures associated with the call.</p>
    pub fn failures(&self) -> std::option::Option<&[crate::model::Failure]> {
        self.failures.as_deref()
    }
}
impl std::fmt::Debug for DescribeServicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServicesOutput");
        formatter.field("services", &self.services);
        formatter.field("failures", &self.failures);
        formatter.finish()
    }
}
/// See [`DescribeServicesOutput`](crate::output::DescribeServicesOutput)
pub mod describe_services_output {
    /// A builder for [`DescribeServicesOutput`](crate::output::DescribeServicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) services: std::option::Option<std::vec::Vec<crate::model::Service>>,
        pub(crate) failures: std::option::Option<std::vec::Vec<crate::model::Failure>>,
    }
    impl Builder {
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// <p>The list of services described.</p>
        pub fn services(mut self, input: crate::model::Service) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input);
            self.services = Some(v);
            self
        }
        /// <p>The list of services described.</p>
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Service>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// Appends an item to `failures`.
        ///
        /// To override the contents of this collection use [`set_failures`](Self::set_failures).
        ///
        /// <p>Any failures associated with the call.</p>
        pub fn failures(mut self, input: crate::model::Failure) -> Self {
            let mut v = self.failures.unwrap_or_default();
            v.push(input);
            self.failures = Some(v);
            self
        }
        /// <p>Any failures associated with the call.</p>
        pub fn set_failures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Failure>>,
        ) -> Self {
            self.failures = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeServicesOutput`](crate::output::DescribeServicesOutput)
        pub fn build(self) -> crate::output::DescribeServicesOutput {
            crate::output::DescribeServicesOutput {
                services: self.services,
                failures: self.failures,
            }
        }
    }
}
impl DescribeServicesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeServicesOutput`](crate::output::DescribeServicesOutput)
    pub fn builder() -> crate::output::describe_services_output::Builder {
        crate::output::describe_services_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeContainerInstancesOutput {
    /// <p>The list of container instances.</p>
    pub container_instances: std::option::Option<std::vec::Vec<crate::model::ContainerInstance>>,
    /// <p>Any failures associated with the call.</p>
    pub failures: std::option::Option<std::vec::Vec<crate::model::Failure>>,
}
impl DescribeContainerInstancesOutput {
    /// <p>The list of container instances.</p>
    pub fn container_instances(&self) -> std::option::Option<&[crate::model::ContainerInstance]> {
        self.container_instances.as_deref()
    }
    /// <p>Any failures associated with the call.</p>
    pub fn failures(&self) -> std::option::Option<&[crate::model::Failure]> {
        self.failures.as_deref()
    }
}
impl std::fmt::Debug for DescribeContainerInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeContainerInstancesOutput");
        formatter.field("container_instances", &self.container_instances);
        formatter.field("failures", &self.failures);
        formatter.finish()
    }
}
/// See [`DescribeContainerInstancesOutput`](crate::output::DescribeContainerInstancesOutput)
pub mod describe_container_instances_output {
    /// A builder for [`DescribeContainerInstancesOutput`](crate::output::DescribeContainerInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_instances:
            std::option::Option<std::vec::Vec<crate::model::ContainerInstance>>,
        pub(crate) failures: std::option::Option<std::vec::Vec<crate::model::Failure>>,
    }
    impl Builder {
        /// Appends an item to `container_instances`.
        ///
        /// To override the contents of this collection use [`set_container_instances`](Self::set_container_instances).
        ///
        /// <p>The list of container instances.</p>
        pub fn container_instances(mut self, input: crate::model::ContainerInstance) -> Self {
            let mut v = self.container_instances.unwrap_or_default();
            v.push(input);
            self.container_instances = Some(v);
            self
        }
        /// <p>The list of container instances.</p>
        pub fn set_container_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContainerInstance>>,
        ) -> Self {
            self.container_instances = input;
            self
        }
        /// Appends an item to `failures`.
        ///
        /// To override the contents of this collection use [`set_failures`](Self::set_failures).
        ///
        /// <p>Any failures associated with the call.</p>
        pub fn failures(mut self, input: crate::model::Failure) -> Self {
            let mut v = self.failures.unwrap_or_default();
            v.push(input);
            self.failures = Some(v);
            self
        }
        /// <p>Any failures associated with the call.</p>
        pub fn set_failures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Failure>>,
        ) -> Self {
            self.failures = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeContainerInstancesOutput`](crate::output::DescribeContainerInstancesOutput)
        pub fn build(self) -> crate::output::DescribeContainerInstancesOutput {
            crate::output::DescribeContainerInstancesOutput {
                container_instances: self.container_instances,
                failures: self.failures,
            }
        }
    }
}
impl DescribeContainerInstancesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeContainerInstancesOutput`](crate::output::DescribeContainerInstancesOutput)
    pub fn builder() -> crate::output::describe_container_instances_output::Builder {
        crate::output::describe_container_instances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClustersOutput {
    /// <p>The list of clusters.</p>
    pub clusters: std::option::Option<std::vec::Vec<crate::model::Cluster>>,
    /// <p>Any failures associated with the call.</p>
    pub failures: std::option::Option<std::vec::Vec<crate::model::Failure>>,
}
impl DescribeClustersOutput {
    /// <p>The list of clusters.</p>
    pub fn clusters(&self) -> std::option::Option<&[crate::model::Cluster]> {
        self.clusters.as_deref()
    }
    /// <p>Any failures associated with the call.</p>
    pub fn failures(&self) -> std::option::Option<&[crate::model::Failure]> {
        self.failures.as_deref()
    }
}
impl std::fmt::Debug for DescribeClustersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClustersOutput");
        formatter.field("clusters", &self.clusters);
        formatter.field("failures", &self.failures);
        formatter.finish()
    }
}
/// See [`DescribeClustersOutput`](crate::output::DescribeClustersOutput)
pub mod describe_clusters_output {
    /// A builder for [`DescribeClustersOutput`](crate::output::DescribeClustersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) clusters: std::option::Option<std::vec::Vec<crate::model::Cluster>>,
        pub(crate) failures: std::option::Option<std::vec::Vec<crate::model::Failure>>,
    }
    impl Builder {
        /// Appends an item to `clusters`.
        ///
        /// To override the contents of this collection use [`set_clusters`](Self::set_clusters).
        ///
        /// <p>The list of clusters.</p>
        pub fn clusters(mut self, input: crate::model::Cluster) -> Self {
            let mut v = self.clusters.unwrap_or_default();
            v.push(input);
            self.clusters = Some(v);
            self
        }
        /// <p>The list of clusters.</p>
        pub fn set_clusters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Cluster>>,
        ) -> Self {
            self.clusters = input;
            self
        }
        /// Appends an item to `failures`.
        ///
        /// To override the contents of this collection use [`set_failures`](Self::set_failures).
        ///
        /// <p>Any failures associated with the call.</p>
        pub fn failures(mut self, input: crate::model::Failure) -> Self {
            let mut v = self.failures.unwrap_or_default();
            v.push(input);
            self.failures = Some(v);
            self
        }
        /// <p>Any failures associated with the call.</p>
        pub fn set_failures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Failure>>,
        ) -> Self {
            self.failures = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClustersOutput`](crate::output::DescribeClustersOutput)
        pub fn build(self) -> crate::output::DescribeClustersOutput {
            crate::output::DescribeClustersOutput {
                clusters: self.clusters,
                failures: self.failures,
            }
        }
    }
}
impl DescribeClustersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeClustersOutput`](crate::output::DescribeClustersOutput)
    pub fn builder() -> crate::output::describe_clusters_output::Builder {
        crate::output::describe_clusters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCapacityProvidersOutput {
    /// <p>The list of capacity providers.</p>
    pub capacity_providers: std::option::Option<std::vec::Vec<crate::model::CapacityProvider>>,
    /// <p>Any failures associated with the call.</p>
    pub failures: std::option::Option<std::vec::Vec<crate::model::Failure>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>DescribeCapacityProviders</code> request. When the results of a <code>DescribeCapacityProviders</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeCapacityProvidersOutput {
    /// <p>The list of capacity providers.</p>
    pub fn capacity_providers(&self) -> std::option::Option<&[crate::model::CapacityProvider]> {
        self.capacity_providers.as_deref()
    }
    /// <p>Any failures associated with the call.</p>
    pub fn failures(&self) -> std::option::Option<&[crate::model::Failure]> {
        self.failures.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>DescribeCapacityProviders</code> request. When the results of a <code>DescribeCapacityProviders</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeCapacityProvidersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCapacityProvidersOutput");
        formatter.field("capacity_providers", &self.capacity_providers);
        formatter.field("failures", &self.failures);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeCapacityProvidersOutput`](crate::output::DescribeCapacityProvidersOutput)
pub mod describe_capacity_providers_output {
    /// A builder for [`DescribeCapacityProvidersOutput`](crate::output::DescribeCapacityProvidersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity_providers:
            std::option::Option<std::vec::Vec<crate::model::CapacityProvider>>,
        pub(crate) failures: std::option::Option<std::vec::Vec<crate::model::Failure>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `capacity_providers`.
        ///
        /// To override the contents of this collection use [`set_capacity_providers`](Self::set_capacity_providers).
        ///
        /// <p>The list of capacity providers.</p>
        pub fn capacity_providers(mut self, input: crate::model::CapacityProvider) -> Self {
            let mut v = self.capacity_providers.unwrap_or_default();
            v.push(input);
            self.capacity_providers = Some(v);
            self
        }
        /// <p>The list of capacity providers.</p>
        pub fn set_capacity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProvider>>,
        ) -> Self {
            self.capacity_providers = input;
            self
        }
        /// Appends an item to `failures`.
        ///
        /// To override the contents of this collection use [`set_failures`](Self::set_failures).
        ///
        /// <p>Any failures associated with the call.</p>
        pub fn failures(mut self, input: crate::model::Failure) -> Self {
            let mut v = self.failures.unwrap_or_default();
            v.push(input);
            self.failures = Some(v);
            self
        }
        /// <p>Any failures associated with the call.</p>
        pub fn set_failures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Failure>>,
        ) -> Self {
            self.failures = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>DescribeCapacityProviders</code> request. When the results of a <code>DescribeCapacityProviders</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>DescribeCapacityProviders</code> request. When the results of a <code>DescribeCapacityProviders</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCapacityProvidersOutput`](crate::output::DescribeCapacityProvidersOutput)
        pub fn build(self) -> crate::output::DescribeCapacityProvidersOutput {
            crate::output::DescribeCapacityProvidersOutput {
                capacity_providers: self.capacity_providers,
                failures: self.failures,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeCapacityProvidersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCapacityProvidersOutput`](crate::output::DescribeCapacityProvidersOutput)
    pub fn builder() -> crate::output::describe_capacity_providers_output::Builder {
        crate::output::describe_capacity_providers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterTaskDefinitionOutput {
    /// <p>The full description of the deregistered task.</p>
    pub task_definition: std::option::Option<crate::model::TaskDefinition>,
}
impl DeregisterTaskDefinitionOutput {
    /// <p>The full description of the deregistered task.</p>
    pub fn task_definition(&self) -> std::option::Option<&crate::model::TaskDefinition> {
        self.task_definition.as_ref()
    }
}
impl std::fmt::Debug for DeregisterTaskDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterTaskDefinitionOutput");
        formatter.field("task_definition", &self.task_definition);
        formatter.finish()
    }
}
/// See [`DeregisterTaskDefinitionOutput`](crate::output::DeregisterTaskDefinitionOutput)
pub mod deregister_task_definition_output {
    /// A builder for [`DeregisterTaskDefinitionOutput`](crate::output::DeregisterTaskDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_definition: std::option::Option<crate::model::TaskDefinition>,
    }
    impl Builder {
        /// <p>The full description of the deregistered task.</p>
        pub fn task_definition(mut self, input: crate::model::TaskDefinition) -> Self {
            self.task_definition = Some(input);
            self
        }
        /// <p>The full description of the deregistered task.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<crate::model::TaskDefinition>,
        ) -> Self {
            self.task_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterTaskDefinitionOutput`](crate::output::DeregisterTaskDefinitionOutput)
        pub fn build(self) -> crate::output::DeregisterTaskDefinitionOutput {
            crate::output::DeregisterTaskDefinitionOutput {
                task_definition: self.task_definition,
            }
        }
    }
}
impl DeregisterTaskDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterTaskDefinitionOutput`](crate::output::DeregisterTaskDefinitionOutput)
    pub fn builder() -> crate::output::deregister_task_definition_output::Builder {
        crate::output::deregister_task_definition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterContainerInstanceOutput {
    /// <p>The container instance that was deregistered.</p>
    pub container_instance: std::option::Option<crate::model::ContainerInstance>,
}
impl DeregisterContainerInstanceOutput {
    /// <p>The container instance that was deregistered.</p>
    pub fn container_instance(&self) -> std::option::Option<&crate::model::ContainerInstance> {
        self.container_instance.as_ref()
    }
}
impl std::fmt::Debug for DeregisterContainerInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterContainerInstanceOutput");
        formatter.field("container_instance", &self.container_instance);
        formatter.finish()
    }
}
/// See [`DeregisterContainerInstanceOutput`](crate::output::DeregisterContainerInstanceOutput)
pub mod deregister_container_instance_output {
    /// A builder for [`DeregisterContainerInstanceOutput`](crate::output::DeregisterContainerInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_instance: std::option::Option<crate::model::ContainerInstance>,
    }
    impl Builder {
        /// <p>The container instance that was deregistered.</p>
        pub fn container_instance(mut self, input: crate::model::ContainerInstance) -> Self {
            self.container_instance = Some(input);
            self
        }
        /// <p>The container instance that was deregistered.</p>
        pub fn set_container_instance(
            mut self,
            input: std::option::Option<crate::model::ContainerInstance>,
        ) -> Self {
            self.container_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterContainerInstanceOutput`](crate::output::DeregisterContainerInstanceOutput)
        pub fn build(self) -> crate::output::DeregisterContainerInstanceOutput {
            crate::output::DeregisterContainerInstanceOutput {
                container_instance: self.container_instance,
            }
        }
    }
}
impl DeregisterContainerInstanceOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterContainerInstanceOutput`](crate::output::DeregisterContainerInstanceOutput)
    pub fn builder() -> crate::output::deregister_container_instance_output::Builder {
        crate::output::deregister_container_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTaskSetOutput {
    /// <p>Details about the task set.</p>
    pub task_set: std::option::Option<crate::model::TaskSet>,
}
impl DeleteTaskSetOutput {
    /// <p>Details about the task set.</p>
    pub fn task_set(&self) -> std::option::Option<&crate::model::TaskSet> {
        self.task_set.as_ref()
    }
}
impl std::fmt::Debug for DeleteTaskSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTaskSetOutput");
        formatter.field("task_set", &self.task_set);
        formatter.finish()
    }
}
/// See [`DeleteTaskSetOutput`](crate::output::DeleteTaskSetOutput)
pub mod delete_task_set_output {
    /// A builder for [`DeleteTaskSetOutput`](crate::output::DeleteTaskSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_set: std::option::Option<crate::model::TaskSet>,
    }
    impl Builder {
        /// <p>Details about the task set.</p>
        pub fn task_set(mut self, input: crate::model::TaskSet) -> Self {
            self.task_set = Some(input);
            self
        }
        /// <p>Details about the task set.</p>
        pub fn set_task_set(mut self, input: std::option::Option<crate::model::TaskSet>) -> Self {
            self.task_set = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTaskSetOutput`](crate::output::DeleteTaskSetOutput)
        pub fn build(self) -> crate::output::DeleteTaskSetOutput {
            crate::output::DeleteTaskSetOutput {
                task_set: self.task_set,
            }
        }
    }
}
impl DeleteTaskSetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTaskSetOutput`](crate::output::DeleteTaskSetOutput)
    pub fn builder() -> crate::output::delete_task_set_output::Builder {
        crate::output::delete_task_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServiceOutput {
    /// <p>The full description of the deleted service.</p>
    pub service: std::option::Option<crate::model::Service>,
}
impl DeleteServiceOutput {
    /// <p>The full description of the deleted service.</p>
    pub fn service(&self) -> std::option::Option<&crate::model::Service> {
        self.service.as_ref()
    }
}
impl std::fmt::Debug for DeleteServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServiceOutput");
        formatter.field("service", &self.service);
        formatter.finish()
    }
}
/// See [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
pub mod delete_service_output {
    /// A builder for [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<crate::model::Service>,
    }
    impl Builder {
        /// <p>The full description of the deleted service.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>The full description of the deleted service.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
        pub fn build(self) -> crate::output::DeleteServiceOutput {
            crate::output::DeleteServiceOutput {
                service: self.service,
            }
        }
    }
}
impl DeleteServiceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
    pub fn builder() -> crate::output::delete_service_output::Builder {
        crate::output::delete_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteClusterOutput {
    /// <p>The full description of the deleted cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl DeleteClusterOutput {
    /// <p>The full description of the deleted cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for DeleteClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteClusterOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`DeleteClusterOutput`](crate::output::DeleteClusterOutput)
pub mod delete_cluster_output {
    /// A builder for [`DeleteClusterOutput`](crate::output::DeleteClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>The full description of the deleted cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>The full description of the deleted cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteClusterOutput`](crate::output::DeleteClusterOutput)
        pub fn build(self) -> crate::output::DeleteClusterOutput {
            crate::output::DeleteClusterOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl DeleteClusterOutput {
    /// Creates a new builder-style object to manufacture [`DeleteClusterOutput`](crate::output::DeleteClusterOutput)
    pub fn builder() -> crate::output::delete_cluster_output::Builder {
        crate::output::delete_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCapacityProviderOutput {
    /// <p>The details of the capacity provider.</p>
    pub capacity_provider: std::option::Option<crate::model::CapacityProvider>,
}
impl DeleteCapacityProviderOutput {
    /// <p>The details of the capacity provider.</p>
    pub fn capacity_provider(&self) -> std::option::Option<&crate::model::CapacityProvider> {
        self.capacity_provider.as_ref()
    }
}
impl std::fmt::Debug for DeleteCapacityProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCapacityProviderOutput");
        formatter.field("capacity_provider", &self.capacity_provider);
        formatter.finish()
    }
}
/// See [`DeleteCapacityProviderOutput`](crate::output::DeleteCapacityProviderOutput)
pub mod delete_capacity_provider_output {
    /// A builder for [`DeleteCapacityProviderOutput`](crate::output::DeleteCapacityProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity_provider: std::option::Option<crate::model::CapacityProvider>,
    }
    impl Builder {
        /// <p>The details of the capacity provider.</p>
        pub fn capacity_provider(mut self, input: crate::model::CapacityProvider) -> Self {
            self.capacity_provider = Some(input);
            self
        }
        /// <p>The details of the capacity provider.</p>
        pub fn set_capacity_provider(
            mut self,
            input: std::option::Option<crate::model::CapacityProvider>,
        ) -> Self {
            self.capacity_provider = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCapacityProviderOutput`](crate::output::DeleteCapacityProviderOutput)
        pub fn build(self) -> crate::output::DeleteCapacityProviderOutput {
            crate::output::DeleteCapacityProviderOutput {
                capacity_provider: self.capacity_provider,
            }
        }
    }
}
impl DeleteCapacityProviderOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCapacityProviderOutput`](crate::output::DeleteCapacityProviderOutput)
    pub fn builder() -> crate::output::delete_capacity_provider_output::Builder {
        crate::output::delete_capacity_provider_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAttributesOutput {
    /// <p>A list of attribute objects that were successfully deleted from your resource.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
}
impl DeleteAttributesOutput {
    /// <p>A list of attribute objects that were successfully deleted from your resource.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::Attribute]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for DeleteAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAttributesOutput");
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`DeleteAttributesOutput`](crate::output::DeleteAttributesOutput)
pub mod delete_attributes_output {
    /// A builder for [`DeleteAttributesOutput`](crate::output::DeleteAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A list of attribute objects that were successfully deleted from your resource.</p>
        pub fn attributes(mut self, input: crate::model::Attribute) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input);
            self.attributes = Some(v);
            self
        }
        /// <p>A list of attribute objects that were successfully deleted from your resource.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAttributesOutput`](crate::output::DeleteAttributesOutput)
        pub fn build(self) -> crate::output::DeleteAttributesOutput {
            crate::output::DeleteAttributesOutput {
                attributes: self.attributes,
            }
        }
    }
}
impl DeleteAttributesOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAttributesOutput`](crate::output::DeleteAttributesOutput)
    pub fn builder() -> crate::output::delete_attributes_output::Builder {
        crate::output::delete_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccountSettingOutput {
    /// <p>The account setting for the specified principal ARN.</p>
    pub setting: std::option::Option<crate::model::Setting>,
}
impl DeleteAccountSettingOutput {
    /// <p>The account setting for the specified principal ARN.</p>
    pub fn setting(&self) -> std::option::Option<&crate::model::Setting> {
        self.setting.as_ref()
    }
}
impl std::fmt::Debug for DeleteAccountSettingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccountSettingOutput");
        formatter.field("setting", &self.setting);
        formatter.finish()
    }
}
/// See [`DeleteAccountSettingOutput`](crate::output::DeleteAccountSettingOutput)
pub mod delete_account_setting_output {
    /// A builder for [`DeleteAccountSettingOutput`](crate::output::DeleteAccountSettingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) setting: std::option::Option<crate::model::Setting>,
    }
    impl Builder {
        /// <p>The account setting for the specified principal ARN.</p>
        pub fn setting(mut self, input: crate::model::Setting) -> Self {
            self.setting = Some(input);
            self
        }
        /// <p>The account setting for the specified principal ARN.</p>
        pub fn set_setting(mut self, input: std::option::Option<crate::model::Setting>) -> Self {
            self.setting = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAccountSettingOutput`](crate::output::DeleteAccountSettingOutput)
        pub fn build(self) -> crate::output::DeleteAccountSettingOutput {
            crate::output::DeleteAccountSettingOutput {
                setting: self.setting,
            }
        }
    }
}
impl DeleteAccountSettingOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAccountSettingOutput`](crate::output::DeleteAccountSettingOutput)
    pub fn builder() -> crate::output::delete_account_setting_output::Builder {
        crate::output::delete_account_setting_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTaskSetOutput {
    /// <p>Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code> deployment. A task set includes details such as the desired number of tasks, how many tasks are running, and whether the task set serves production traffic.</p>
    pub task_set: std::option::Option<crate::model::TaskSet>,
}
impl CreateTaskSetOutput {
    /// <p>Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code> deployment. A task set includes details such as the desired number of tasks, how many tasks are running, and whether the task set serves production traffic.</p>
    pub fn task_set(&self) -> std::option::Option<&crate::model::TaskSet> {
        self.task_set.as_ref()
    }
}
impl std::fmt::Debug for CreateTaskSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTaskSetOutput");
        formatter.field("task_set", &self.task_set);
        formatter.finish()
    }
}
/// See [`CreateTaskSetOutput`](crate::output::CreateTaskSetOutput)
pub mod create_task_set_output {
    /// A builder for [`CreateTaskSetOutput`](crate::output::CreateTaskSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_set: std::option::Option<crate::model::TaskSet>,
    }
    impl Builder {
        /// <p>Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code> deployment. A task set includes details such as the desired number of tasks, how many tasks are running, and whether the task set serves production traffic.</p>
        pub fn task_set(mut self, input: crate::model::TaskSet) -> Self {
            self.task_set = Some(input);
            self
        }
        /// <p>Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code> deployment. A task set includes details such as the desired number of tasks, how many tasks are running, and whether the task set serves production traffic.</p>
        pub fn set_task_set(mut self, input: std::option::Option<crate::model::TaskSet>) -> Self {
            self.task_set = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTaskSetOutput`](crate::output::CreateTaskSetOutput)
        pub fn build(self) -> crate::output::CreateTaskSetOutput {
            crate::output::CreateTaskSetOutput {
                task_set: self.task_set,
            }
        }
    }
}
impl CreateTaskSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateTaskSetOutput`](crate::output::CreateTaskSetOutput)
    pub fn builder() -> crate::output::create_task_set_output::Builder {
        crate::output::create_task_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServiceOutput {
    /// <p>The full description of your service following the create call.</p>
    /// <p>A service will return either a <code>capacityProviderStrategy</code> or <code>launchType</code> parameter, but not both, depending where one was specified when it was created.</p>
    /// <p>If a service is using the <code>ECS</code> deployment controller, the <code>deploymentController</code> and <code>taskSets</code> parameters will not be returned.</p>
    /// <p>if the service uses the <code>CODE_DEPLOY</code> deployment controller, the <code>deploymentController</code>, <code>taskSets</code> and <code>deployments</code> parameters will be returned, however the <code>deployments</code> parameter will be an empty list.</p>
    pub service: std::option::Option<crate::model::Service>,
}
impl CreateServiceOutput {
    /// <p>The full description of your service following the create call.</p>
    /// <p>A service will return either a <code>capacityProviderStrategy</code> or <code>launchType</code> parameter, but not both, depending where one was specified when it was created.</p>
    /// <p>If a service is using the <code>ECS</code> deployment controller, the <code>deploymentController</code> and <code>taskSets</code> parameters will not be returned.</p>
    /// <p>if the service uses the <code>CODE_DEPLOY</code> deployment controller, the <code>deploymentController</code>, <code>taskSets</code> and <code>deployments</code> parameters will be returned, however the <code>deployments</code> parameter will be an empty list.</p>
    pub fn service(&self) -> std::option::Option<&crate::model::Service> {
        self.service.as_ref()
    }
}
impl std::fmt::Debug for CreateServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServiceOutput");
        formatter.field("service", &self.service);
        formatter.finish()
    }
}
/// See [`CreateServiceOutput`](crate::output::CreateServiceOutput)
pub mod create_service_output {
    /// A builder for [`CreateServiceOutput`](crate::output::CreateServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<crate::model::Service>,
    }
    impl Builder {
        /// <p>The full description of your service following the create call.</p>
        /// <p>A service will return either a <code>capacityProviderStrategy</code> or <code>launchType</code> parameter, but not both, depending where one was specified when it was created.</p>
        /// <p>If a service is using the <code>ECS</code> deployment controller, the <code>deploymentController</code> and <code>taskSets</code> parameters will not be returned.</p>
        /// <p>if the service uses the <code>CODE_DEPLOY</code> deployment controller, the <code>deploymentController</code>, <code>taskSets</code> and <code>deployments</code> parameters will be returned, however the <code>deployments</code> parameter will be an empty list.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>The full description of your service following the create call.</p>
        /// <p>A service will return either a <code>capacityProviderStrategy</code> or <code>launchType</code> parameter, but not both, depending where one was specified when it was created.</p>
        /// <p>If a service is using the <code>ECS</code> deployment controller, the <code>deploymentController</code> and <code>taskSets</code> parameters will not be returned.</p>
        /// <p>if the service uses the <code>CODE_DEPLOY</code> deployment controller, the <code>deploymentController</code>, <code>taskSets</code> and <code>deployments</code> parameters will be returned, however the <code>deployments</code> parameter will be an empty list.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceOutput`](crate::output::CreateServiceOutput)
        pub fn build(self) -> crate::output::CreateServiceOutput {
            crate::output::CreateServiceOutput {
                service: self.service,
            }
        }
    }
}
impl CreateServiceOutput {
    /// Creates a new builder-style object to manufacture [`CreateServiceOutput`](crate::output::CreateServiceOutput)
    pub fn builder() -> crate::output::create_service_output::Builder {
        crate::output::create_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateClusterOutput {
    /// <p>The full description of your new cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl CreateClusterOutput {
    /// <p>The full description of your new cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for CreateClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateClusterOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`CreateClusterOutput`](crate::output::CreateClusterOutput)
pub mod create_cluster_output {
    /// A builder for [`CreateClusterOutput`](crate::output::CreateClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>The full description of your new cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>The full description of your new cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClusterOutput`](crate::output::CreateClusterOutput)
        pub fn build(self) -> crate::output::CreateClusterOutput {
            crate::output::CreateClusterOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl CreateClusterOutput {
    /// Creates a new builder-style object to manufacture [`CreateClusterOutput`](crate::output::CreateClusterOutput)
    pub fn builder() -> crate::output::create_cluster_output::Builder {
        crate::output::create_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCapacityProviderOutput {
    /// <p>The full description of the new capacity provider.</p>
    pub capacity_provider: std::option::Option<crate::model::CapacityProvider>,
}
impl CreateCapacityProviderOutput {
    /// <p>The full description of the new capacity provider.</p>
    pub fn capacity_provider(&self) -> std::option::Option<&crate::model::CapacityProvider> {
        self.capacity_provider.as_ref()
    }
}
impl std::fmt::Debug for CreateCapacityProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCapacityProviderOutput");
        formatter.field("capacity_provider", &self.capacity_provider);
        formatter.finish()
    }
}
/// See [`CreateCapacityProviderOutput`](crate::output::CreateCapacityProviderOutput)
pub mod create_capacity_provider_output {
    /// A builder for [`CreateCapacityProviderOutput`](crate::output::CreateCapacityProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity_provider: std::option::Option<crate::model::CapacityProvider>,
    }
    impl Builder {
        /// <p>The full description of the new capacity provider.</p>
        pub fn capacity_provider(mut self, input: crate::model::CapacityProvider) -> Self {
            self.capacity_provider = Some(input);
            self
        }
        /// <p>The full description of the new capacity provider.</p>
        pub fn set_capacity_provider(
            mut self,
            input: std::option::Option<crate::model::CapacityProvider>,
        ) -> Self {
            self.capacity_provider = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCapacityProviderOutput`](crate::output::CreateCapacityProviderOutput)
        pub fn build(self) -> crate::output::CreateCapacityProviderOutput {
            crate::output::CreateCapacityProviderOutput {
                capacity_provider: self.capacity_provider,
            }
        }
    }
}
impl CreateCapacityProviderOutput {
    /// Creates a new builder-style object to manufacture [`CreateCapacityProviderOutput`](crate::output::CreateCapacityProviderOutput)
    pub fn builder() -> crate::output::create_capacity_provider_output::Builder {
        crate::output::create_capacity_provider_output::Builder::default()
    }
}
