// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon EC2 Container Service
///
/// Client for invoking operations on Amazon EC2 Container Service. Each operation on Amazon EC2 Container Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_ecs::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_ecs::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_ecs::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateCapacityProvider`](crate::client::fluent_builders::CreateCapacityProvider) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateCapacityProvider::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateCapacityProvider::set_name): <p>The name of the capacity provider. Up to 255 characters are allowed. They include letters (both upper and lowercase letters), numbers, underscores (_), and hyphens (-). The name can't be prefixed with "<code>aws</code>", "<code>ecs</code>", or "<code>fargate</code>".</p>
    ///   - [`auto_scaling_group_provider(AutoScalingGroupProvider)`](crate::client::fluent_builders::CreateCapacityProvider::auto_scaling_group_provider) / [`set_auto_scaling_group_provider(Option<AutoScalingGroupProvider>)`](crate::client::fluent_builders::CreateCapacityProvider::set_auto_scaling_group_provider): <p>The details of the Auto Scaling group for the capacity provider.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateCapacityProvider::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateCapacityProvider::set_tags): <p>The metadata that you apply to the capacity provider to categorize and organize them more conveniently. Each tag consists of a key and an optional value. You define both of them.</p>  <p>The following basic restrictions apply to tags:</p>  <ul>   <li> <p>Maximum number of tags per resource - 50</p> </li>   <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>   <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>   <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>   <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>   <li> <p>Tag keys and values are case-sensitive.</p> </li>   <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>  </ul>
    /// - On success, responds with [`CreateCapacityProviderOutput`](crate::output::CreateCapacityProviderOutput) with field(s):
    ///   - [`capacity_provider(Option<CapacityProvider>)`](crate::output::CreateCapacityProviderOutput::capacity_provider): <p>The full description of the new capacity provider.</p>
    /// - On failure, responds with [`SdkError<CreateCapacityProviderError>`](crate::error::CreateCapacityProviderError)
    pub fn create_capacity_provider(&self) -> fluent_builders::CreateCapacityProvider {
        fluent_builders::CreateCapacityProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCluster`](crate::client::fluent_builders::CreateCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_name(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::cluster_name) / [`set_cluster_name(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_cluster_name): <p>The name of your cluster. If you don't specify a name for your cluster, you create a cluster that's named <code>default</code>. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateCluster::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateCluster::set_tags): <p>The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.</p>  <p>The following basic restrictions apply to tags:</p>  <ul>   <li> <p>Maximum number of tags per resource - 50</p> </li>   <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>   <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>   <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>   <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>   <li> <p>Tag keys and values are case-sensitive.</p> </li>   <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>  </ul>
    ///   - [`settings(Vec<ClusterSetting>)`](crate::client::fluent_builders::CreateCluster::settings) / [`set_settings(Option<Vec<ClusterSetting>>)`](crate::client::fluent_builders::CreateCluster::set_settings): <p>The setting to use when creating a cluster. This parameter is used to turn on CloudWatch Container Insights for a cluster. If this value is specified, it overrides the <code>containerInsights</code> value set with <code>PutAccountSetting</code> or <code>PutAccountSettingDefault</code>.</p>
    ///   - [`configuration(ClusterConfiguration)`](crate::client::fluent_builders::CreateCluster::configuration) / [`set_configuration(Option<ClusterConfiguration>)`](crate::client::fluent_builders::CreateCluster::set_configuration): <p>The <code>execute</code> command configuration for the cluster.</p>
    ///   - [`capacity_providers(Vec<String>)`](crate::client::fluent_builders::CreateCluster::capacity_providers) / [`set_capacity_providers(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCluster::set_capacity_providers): <p>The short name of one or more capacity providers to associate with the cluster. A capacity provider must be associated with a cluster before it can be included as part of the default capacity provider strategy of the cluster or used in a capacity provider strategy when calling the <code>CreateService</code> or <code>RunTask</code> actions.</p>  <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must be created but not associated with another cluster. New Auto Scaling group capacity providers can be created with the <code>CreateCapacityProvider</code> API operation.</p>  <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.</p>  <p>The <code>PutClusterCapacityProviders</code> API operation is used to update the list of available capacity providers for a cluster after the cluster is created.</p>
    ///   - [`default_capacity_provider_strategy(Vec<CapacityProviderStrategyItem>)`](crate::client::fluent_builders::CreateCluster::default_capacity_provider_strategy) / [`set_default_capacity_provider_strategy(Option<Vec<CapacityProviderStrategyItem>>)`](crate::client::fluent_builders::CreateCluster::set_default_capacity_provider_strategy): <p>The capacity provider strategy to set as the default for the cluster. After a default capacity provider strategy is set for a cluster, when you call the <code>RunTask</code> or <code>CreateService</code> APIs with no capacity provider strategy or launch type specified, the default capacity provider strategy for the cluster is used.</p>  <p>If a default capacity provider strategy isn't defined for a cluster when it was created, it can be defined later with the <code>PutClusterCapacityProviders</code> API operation.</p>
    /// - On success, responds with [`CreateClusterOutput`](crate::output::CreateClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::CreateClusterOutput::cluster): <p>The full description of your new cluster.</p>
    /// - On failure, responds with [`SdkError<CreateClusterError>`](crate::error::CreateClusterError)
    pub fn create_cluster(&self) -> fluent_builders::CreateCluster {
        fluent_builders::CreateCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateService`](crate::client::fluent_builders::CreateService) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::CreateService::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::CreateService::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that you run your service on. If you do not specify a cluster, the default cluster is assumed.</p>
    ///   - [`service_name(impl Into<String>)`](crate::client::fluent_builders::CreateService::service_name) / [`set_service_name(Option<String>)`](crate::client::fluent_builders::CreateService::set_service_name): <p>The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. Service names must be unique within a cluster, but you can have similarly named services in multiple clusters within a Region or across multiple Regions.</p>
    ///   - [`task_definition(impl Into<String>)`](crate::client::fluent_builders::CreateService::task_definition) / [`set_task_definition(Option<String>)`](crate::client::fluent_builders::CreateService::set_task_definition): <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task definition to run in your service. If a <code>revision</code> isn't specified, the latest <code>ACTIVE</code> revision is used.</p>  <p>A task definition must be specified if the service uses either the <code>ECS</code> or <code>CODE_DEPLOY</code> deployment controllers.</p>
    ///   - [`load_balancers(Vec<LoadBalancer>)`](crate::client::fluent_builders::CreateService::load_balancers) / [`set_load_balancers(Option<Vec<LoadBalancer>>)`](crate::client::fluent_builders::CreateService::set_load_balancers): <p>A load balancer object representing the load balancers to use with your service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service Load Balancing</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>  <p>If the service uses the rolling update (<code>ECS</code>) deployment controller and using either an Application Load Balancer or Network Load Balancer, you must specify one or more target group ARNs to attach to the service. The service-linked role is required for services that use multiple target groups. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>  <p>If the service uses the <code>CODE_DEPLOY</code> deployment controller, the service is required to use either an Application Load Balancer or Network Load Balancer. When creating an CodeDeploy deployment group, you specify two target groups (referred to as a <code>targetGroupPair</code>). During a deployment, CodeDeploy determines which task set in your service has the status <code>PRIMARY</code>, and it associates one target group with it. Then, it also associates the other target group with the replacement task set. The load balancer can also have up to two listeners: a required listener for production traffic and an optional listener that you can use to perform validation tests with Lambda functions before routing production traffic to it.</p>  <p>If you use the <code>CODE_DEPLOY</code> deployment controller, these values can be changed when updating the service.</p>  <p>For Application Load Balancers and Network Load Balancers, this object must contain the load balancer target group ARN, the container name, and the container port to access from the load balancer. The container name must be as it appears in a container definition. The load balancer name parameter must be omitted. When a task from this service is placed on a container instance, the container instance and port combination is registered as a target in the target group that's specified here.</p>  <p>For Classic Load Balancers, this object must contain the load balancer name, the container name , and the container port to access from the load balancer. The container name must be as it appears in a container definition. The target group ARN parameter must be omitted. When a task from this service is placed on a container instance, the container instance is registered with the load balancer that's specified here.</p>  <p>Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate launch type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers aren't supported. Also, when you create any target groups for these services, you must choose <code>ip</code> as the target type, not <code>instance</code>. This is because tasks that use the <code>awsvpc</code> network mode are associated with an elastic network interface, not an Amazon EC2 instance.</p>
    ///   - [`service_registries(Vec<ServiceRegistry>)`](crate::client::fluent_builders::CreateService::service_registries) / [`set_service_registries(Option<Vec<ServiceRegistry>>)`](crate::client::fluent_builders::CreateService::set_service_registries): <p>The details of the service discovery registry to associate with this service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service discovery</a>.</p> <note>   <p>Each service may be associated with one service registry. Multiple service registries for each service isn't supported.</p>  </note>
    ///   - [`desired_count(i32)`](crate::client::fluent_builders::CreateService::desired_count) / [`set_desired_count(Option<i32>)`](crate::client::fluent_builders::CreateService::set_desired_count): <p>The number of instantiations of the specified task definition to place and keep running on your cluster.</p>  <p>This is required if <code>schedulingStrategy</code> is <code>REPLICA</code> or isn't specified. If <code>schedulingStrategy</code> is <code>DAEMON</code> then this isn't required.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateService::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateService::set_client_token): <p>An identifier that you provide to ensure the idempotency of the request. It must be unique and is case sensitive. Up to 32 ASCII characters are allowed.</p>
    ///   - [`launch_type(LaunchType)`](crate::client::fluent_builders::CreateService::launch_type) / [`set_launch_type(Option<LaunchType>)`](crate::client::fluent_builders::CreateService::set_launch_type): <p>The infrastructure that you run your service on. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>  <p>The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand infrastructure.</p> <note>   <p>Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html">Fargate capacity providers</a> in the <i>Amazon ECS User Guide for Fargate</i>.</p>  </note>  <p>The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your cluster.</p>  <p>The <code>EXTERNAL</code> launch type runs your tasks on your on-premises server or virtual machine (VM) capacity registered to your cluster.</p>  <p>A service can use either a launch type or a capacity provider strategy. If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code> parameter must be omitted.</p>
    ///   - [`capacity_provider_strategy(Vec<CapacityProviderStrategyItem>)`](crate::client::fluent_builders::CreateService::capacity_provider_strategy) / [`set_capacity_provider_strategy(Option<Vec<CapacityProviderStrategyItem>>)`](crate::client::fluent_builders::CreateService::set_capacity_provider_strategy): <p>The capacity provider strategy to use for the service.</p>  <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.</p>  <p>A capacity provider strategy may contain a maximum of 6 capacity providers.</p>
    ///   - [`platform_version(impl Into<String>)`](crate::client::fluent_builders::CreateService::platform_version) / [`set_platform_version(Option<String>)`](crate::client::fluent_builders::CreateService::set_platform_version): <p>The platform version that your tasks in the service are running on. A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the <code>LATEST</code> platform version is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate platform versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    ///   - [`role(impl Into<String>)`](crate::client::fluent_builders::CreateService::role) / [`set_role(Option<String>)`](crate::client::fluent_builders::CreateService::set_role): <p>The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is only permitted if you are using a load balancer with your service and your task definition doesn't use the <code>awsvpc</code> network mode. If you specify the <code>role</code> parameter, you must also specify a load balancer object with the <code>loadBalancers</code> parameter.</p> <important>   <p>If your account has already created the Amazon ECS service-linked role, that role is used for your service unless you specify a role here. The service-linked role is required if your task definition uses the <code>awsvpc</code> network mode or if the service is configured to use service discovery, an external deployment controller, multiple target groups, or Elastic Inference accelerators in which case you don't specify a role here. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>  </important>  <p>If your specified role has a path other than <code>/</code>, then you must either specify the full role ARN (this is recommended) or prefix the role name with the path. For example, if a role with the name <code>bar</code> has a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as the role name. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">Friendly names and paths</a> in the <i>IAM User Guide</i>.</p>
    ///   - [`deployment_configuration(DeploymentConfiguration)`](crate::client::fluent_builders::CreateService::deployment_configuration) / [`set_deployment_configuration(Option<DeploymentConfiguration>)`](crate::client::fluent_builders::CreateService::set_deployment_configuration): <p>Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.</p>
    ///   - [`placement_constraints(Vec<PlacementConstraint>)`](crate::client::fluent_builders::CreateService::placement_constraints) / [`set_placement_constraints(Option<Vec<PlacementConstraint>>)`](crate::client::fluent_builders::CreateService::set_placement_constraints): <p>An array of placement constraint objects to use for tasks in your service. You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.</p>
    ///   - [`placement_strategy(Vec<PlacementStrategy>)`](crate::client::fluent_builders::CreateService::placement_strategy) / [`set_placement_strategy(Option<Vec<PlacementStrategy>>)`](crate::client::fluent_builders::CreateService::set_placement_strategy): <p>The placement strategy objects to use for tasks in your service. You can specify a maximum of 5 strategy rules for each service.</p>
    ///   - [`network_configuration(NetworkConfiguration)`](crate::client::fluent_builders::CreateService::network_configuration) / [`set_network_configuration(Option<NetworkConfiguration>)`](crate::client::fluent_builders::CreateService::set_network_configuration): <p>The network configuration for the service. This parameter is required for task definitions that use the <code>awsvpc</code> network mode to receive their own elastic network interface, and it isn't supported for other network modes. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    ///   - [`health_check_grace_period_seconds(i32)`](crate::client::fluent_builders::CreateService::health_check_grace_period_seconds) / [`set_health_check_grace_period_seconds(Option<i32>)`](crate::client::fluent_builders::CreateService::set_health_check_grace_period_seconds): <p>The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started. This is only used when your service is configured to use a load balancer. If your service has a load balancer defined and you don't specify a health check grace period value, the default value of <code>0</code> is used.</p>  <p>If you do not use an Elastic Load Balancing, we recomend that you use the <code>startPeriod</code> in the task definition healtch check parameters. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_HealthCheck.html">Health check</a>.</p>  <p>If your service's tasks take a while to start and respond to Elastic Load Balancing health checks, you can specify a health check grace period of up to 2,147,483,647 seconds (about 69 years). During that time, the Amazon ECS service scheduler ignores health check status. This grace period can prevent the service scheduler from marking tasks as unhealthy and stopping them before they have time to come up.</p>
    ///   - [`scheduling_strategy(SchedulingStrategy)`](crate::client::fluent_builders::CreateService::scheduling_strategy) / [`set_scheduling_strategy(Option<SchedulingStrategy>)`](crate::client::fluent_builders::CreateService::set_scheduling_strategy): <p>The scheduling strategy to use for the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>  <p>There are two service scheduler strategies available:</p>  <ul>   <li> <p> <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement strategies and constraints to customize task placement decisions. This scheduler strategy is required if the service uses the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types.</p> </li>   <li> <p> <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container instance that meets all of the task placement constraints that you specify in your cluster. The service scheduler also evaluates the task placement constraints for running tasks and will stop tasks that don't meet the placement constraints. When you're using this strategy, you don't need to specify a desired number of tasks, a task placement strategy, or use Service Auto Scaling policies.</p> <note>     <p>Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types don't support the <code>DAEMON</code> scheduling strategy.</p>    </note> </li>  </ul>
    ///   - [`deployment_controller(DeploymentController)`](crate::client::fluent_builders::CreateService::deployment_controller) / [`set_deployment_controller(Option<DeploymentController>)`](crate::client::fluent_builders::CreateService::set_deployment_controller): <p>The deployment controller to use for the service. If no deployment controller is specified, the default value of <code>ECS</code> is used.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateService::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateService::set_tags): <p>The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.</p>  <p>The following basic restrictions apply to tags:</p>  <ul>   <li> <p>Maximum number of tags per resource - 50</p> </li>   <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>   <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>   <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>   <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>   <li> <p>Tag keys and values are case-sensitive.</p> </li>   <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>  </ul>
    ///   - [`enable_ecs_managed_tags(bool)`](crate::client::fluent_builders::CreateService::enable_ecs_managed_tags) / [`set_enable_ecs_managed_tags(bool)`](crate::client::fluent_builders::CreateService::set_enable_ecs_managed_tags): <p>Specifies whether to turn on Amazon ECS managed tags for the tasks within the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    ///   - [`propagate_tags(PropagateTags)`](crate::client::fluent_builders::CreateService::propagate_tags) / [`set_propagate_tags(Option<PropagateTags>)`](crate::client::fluent_builders::CreateService::set_propagate_tags): <p>Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the <code>TagResource</code> API action.</p>
    ///   - [`enable_execute_command(bool)`](crate::client::fluent_builders::CreateService::enable_execute_command) / [`set_enable_execute_command(bool)`](crate::client::fluent_builders::CreateService::set_enable_execute_command): <p>Determines whether the execute command functionality is enabled for the service. If <code>true</code>, this enables execute command functionality on all containers in the service tasks.</p>
    /// - On success, responds with [`CreateServiceOutput`](crate::output::CreateServiceOutput) with field(s):
    ///   - [`service(Option<Service>)`](crate::output::CreateServiceOutput::service): <p>The full description of your service following the create call.</p>  <p>A service will return either a <code>capacityProviderStrategy</code> or <code>launchType</code> parameter, but not both, depending where one was specified when it was created.</p>  <p>If a service is using the <code>ECS</code> deployment controller, the <code>deploymentController</code> and <code>taskSets</code> parameters will not be returned.</p>  <p>if the service uses the <code>CODE_DEPLOY</code> deployment controller, the <code>deploymentController</code>, <code>taskSets</code> and <code>deployments</code> parameters will be returned, however the <code>deployments</code> parameter will be an empty list.</p>
    /// - On failure, responds with [`SdkError<CreateServiceError>`](crate::error::CreateServiceError)
    pub fn create_service(&self) -> fluent_builders::CreateService {
        fluent_builders::CreateService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTaskSet`](crate::client::fluent_builders::CreateTaskSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`service(impl Into<String>)`](crate::client::fluent_builders::CreateTaskSet::service) / [`set_service(Option<String>)`](crate::client::fluent_builders::CreateTaskSet::set_service): <p>The short name or full Amazon Resource Name (ARN) of the service to create the task set in.</p>
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::CreateTaskSet::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::CreateTaskSet::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the task set in.</p>
    ///   - [`external_id(impl Into<String>)`](crate::client::fluent_builders::CreateTaskSet::external_id) / [`set_external_id(Option<String>)`](crate::client::fluent_builders::CreateTaskSet::set_external_id): <p>An optional non-unique tag that identifies this task set in external systems. If the task set is associated with a service discovery registry, the tasks in this task set will have the <code>ECS_TASK_SET_EXTERNAL_ID</code> Cloud Map attribute set to the provided value.</p>
    ///   - [`task_definition(impl Into<String>)`](crate::client::fluent_builders::CreateTaskSet::task_definition) / [`set_task_definition(Option<String>)`](crate::client::fluent_builders::CreateTaskSet::set_task_definition): <p>The task definition for the tasks in the task set to use.</p>
    ///   - [`network_configuration(NetworkConfiguration)`](crate::client::fluent_builders::CreateTaskSet::network_configuration) / [`set_network_configuration(Option<NetworkConfiguration>)`](crate::client::fluent_builders::CreateTaskSet::set_network_configuration): <p>An object representing the network configuration for a task set.</p>
    ///   - [`load_balancers(Vec<LoadBalancer>)`](crate::client::fluent_builders::CreateTaskSet::load_balancers) / [`set_load_balancers(Option<Vec<LoadBalancer>>)`](crate::client::fluent_builders::CreateTaskSet::set_load_balancers): <p>A load balancer object representing the load balancer to use with the task set. The supported load balancer types are either an Application Load Balancer or a Network Load Balancer.</p>
    ///   - [`service_registries(Vec<ServiceRegistry>)`](crate::client::fluent_builders::CreateTaskSet::service_registries) / [`set_service_registries(Option<Vec<ServiceRegistry>>)`](crate::client::fluent_builders::CreateTaskSet::set_service_registries): <p>The details of the service discovery registries to assign to this task set. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service Discovery</a>.</p>
    ///   - [`launch_type(LaunchType)`](crate::client::fluent_builders::CreateTaskSet::launch_type) / [`set_launch_type(Option<LaunchType>)`](crate::client::fluent_builders::CreateTaskSet::set_launch_type): <p>The launch type that new tasks in the task set uses. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>  <p>If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code> parameter must be omitted.</p>
    ///   - [`capacity_provider_strategy(Vec<CapacityProviderStrategyItem>)`](crate::client::fluent_builders::CreateTaskSet::capacity_provider_strategy) / [`set_capacity_provider_strategy(Option<Vec<CapacityProviderStrategyItem>>)`](crate::client::fluent_builders::CreateTaskSet::set_capacity_provider_strategy): <p>The capacity provider strategy to use for the task set.</p>  <p>A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The <code>PutClusterCapacityProviders</code> API is used to associate a capacity provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status can be used.</p>  <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.</p>  <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the <code>CreateCapacityProvider</code> API operation.</p>  <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.</p>  <p>The <code>PutClusterCapacityProviders</code> API operation is used to update the list of available capacity providers for a cluster after the cluster is created.</p>
    ///   - [`platform_version(impl Into<String>)`](crate::client::fluent_builders::CreateTaskSet::platform_version) / [`set_platform_version(Option<String>)`](crate::client::fluent_builders::CreateTaskSet::set_platform_version): <p>The platform version that the tasks in the task set uses. A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the <code>LATEST</code> platform version is used.</p>
    ///   - [`scale(Scale)`](crate::client::fluent_builders::CreateTaskSet::scale) / [`set_scale(Option<Scale>)`](crate::client::fluent_builders::CreateTaskSet::set_scale): <p>A floating-point percentage of the desired number of tasks to place and keep running in the task set.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateTaskSet::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateTaskSet::set_client_token): <p>The identifier that you provide to ensure the idempotency of the request. It's case sensitive and must be unique. It can be up to 32 ASCII characters are allowed.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateTaskSet::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateTaskSet::set_tags): <p>The metadata that you apply to the task set to help you categorize and organize them. Each tag consists of a key and an optional value. You define both. When a service is deleted, the tags are deleted.</p>  <p>The following basic restrictions apply to tags:</p>  <ul>   <li> <p>Maximum number of tags per resource - 50</p> </li>   <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>   <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>   <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>   <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>   <li> <p>Tag keys and values are case-sensitive.</p> </li>   <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>  </ul>
    /// - On success, responds with [`CreateTaskSetOutput`](crate::output::CreateTaskSetOutput) with field(s):
    ///   - [`task_set(Option<TaskSet>)`](crate::output::CreateTaskSetOutput::task_set): <p>Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code> deployment. A task set includes details such as the desired number of tasks, how many tasks are running, and whether the task set serves production traffic.</p>
    /// - On failure, responds with [`SdkError<CreateTaskSetError>`](crate::error::CreateTaskSetError)
    pub fn create_task_set(&self) -> fluent_builders::CreateTaskSet {
        fluent_builders::CreateTaskSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAccountSetting`](crate::client::fluent_builders::DeleteAccountSetting) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(SettingName)`](crate::client::fluent_builders::DeleteAccountSetting::name) / [`set_name(Option<SettingName>)`](crate::client::fluent_builders::DeleteAccountSetting::set_name): <p>The resource name to disable the account setting for. If <code>serviceLongArnFormat</code> is specified, the ARN for your Amazon ECS services is affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS container instances is affected. If <code>awsvpcTrunking</code> is specified, the ENI limit for your Amazon ECS container instances is affected.</p>
    ///   - [`principal_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAccountSetting::principal_arn) / [`set_principal_arn(Option<String>)`](crate::client::fluent_builders::DeleteAccountSetting::set_principal_arn): <p>The Amazon Resource Name (ARN) of the principal. It can be an IAM user, IAM role, or the root user. If you specify the root user, it disables the account setting for all IAM users, IAM roles, and the root user of the account unless an IAM user or role explicitly overrides these settings. If this field is omitted, the setting is changed only for the authenticated user.</p>
    /// - On success, responds with [`DeleteAccountSettingOutput`](crate::output::DeleteAccountSettingOutput) with field(s):
    ///   - [`setting(Option<Setting>)`](crate::output::DeleteAccountSettingOutput::setting): <p>The account setting for the specified principal ARN.</p>
    /// - On failure, responds with [`SdkError<DeleteAccountSettingError>`](crate::error::DeleteAccountSettingError)
    pub fn delete_account_setting(&self) -> fluent_builders::DeleteAccountSetting {
        fluent_builders::DeleteAccountSetting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAttributes`](crate::client::fluent_builders::DeleteAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::DeleteAttributes::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::DeleteAttributes::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that contains the resource to delete attributes. If you do not specify a cluster, the default cluster is assumed.</p>
    ///   - [`attributes(Vec<Attribute>)`](crate::client::fluent_builders::DeleteAttributes::attributes) / [`set_attributes(Option<Vec<Attribute>>)`](crate::client::fluent_builders::DeleteAttributes::set_attributes): <p>The attributes to delete from your resource. You can specify up to 10 attributes for each request. For custom attributes, specify the attribute name and target ID, but don't specify the value. If you specify the target ID using the short form, you must also specify the target type.</p>
    /// - On success, responds with [`DeleteAttributesOutput`](crate::output::DeleteAttributesOutput) with field(s):
    ///   - [`attributes(Option<Vec<Attribute>>)`](crate::output::DeleteAttributesOutput::attributes): <p>A list of attribute objects that were successfully deleted from your resource.</p>
    /// - On failure, responds with [`SdkError<DeleteAttributesError>`](crate::error::DeleteAttributesError)
    pub fn delete_attributes(&self) -> fluent_builders::DeleteAttributes {
        fluent_builders::DeleteAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCapacityProvider`](crate::client::fluent_builders::DeleteCapacityProvider) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`capacity_provider(impl Into<String>)`](crate::client::fluent_builders::DeleteCapacityProvider::capacity_provider) / [`set_capacity_provider(Option<String>)`](crate::client::fluent_builders::DeleteCapacityProvider::set_capacity_provider): <p>The short name or full Amazon Resource Name (ARN) of the capacity provider to delete.</p>
    /// - On success, responds with [`DeleteCapacityProviderOutput`](crate::output::DeleteCapacityProviderOutput) with field(s):
    ///   - [`capacity_provider(Option<CapacityProvider>)`](crate::output::DeleteCapacityProviderOutput::capacity_provider): <p>The details of the capacity provider.</p>
    /// - On failure, responds with [`SdkError<DeleteCapacityProviderError>`](crate::error::DeleteCapacityProviderError)
    pub fn delete_capacity_provider(&self) -> fluent_builders::DeleteCapacityProvider {
        fluent_builders::DeleteCapacityProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCluster`](crate::client::fluent_builders::DeleteCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::DeleteCluster::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::DeleteCluster::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster to delete.</p>
    /// - On success, responds with [`DeleteClusterOutput`](crate::output::DeleteClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::DeleteClusterOutput::cluster): <p>The full description of the deleted cluster.</p>
    /// - On failure, responds with [`SdkError<DeleteClusterError>`](crate::error::DeleteClusterError)
    pub fn delete_cluster(&self) -> fluent_builders::DeleteCluster {
        fluent_builders::DeleteCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteService`](crate::client::fluent_builders::DeleteService) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::DeleteService::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::DeleteService::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to delete. If you do not specify a cluster, the default cluster is assumed.</p>
    ///   - [`service(impl Into<String>)`](crate::client::fluent_builders::DeleteService::service) / [`set_service(Option<String>)`](crate::client::fluent_builders::DeleteService::set_service): <p>The name of the service to delete.</p>
    ///   - [`force(bool)`](crate::client::fluent_builders::DeleteService::force) / [`set_force(Option<bool>)`](crate::client::fluent_builders::DeleteService::set_force): <p>If <code>true</code>, allows you to delete a service even if it wasn't scaled down to zero tasks. It's only necessary to use this if the service uses the <code>REPLICA</code> scheduling strategy.</p>
    /// - On success, responds with [`DeleteServiceOutput`](crate::output::DeleteServiceOutput) with field(s):
    ///   - [`service(Option<Service>)`](crate::output::DeleteServiceOutput::service): <p>The full description of the deleted service.</p>
    /// - On failure, responds with [`SdkError<DeleteServiceError>`](crate::error::DeleteServiceError)
    pub fn delete_service(&self) -> fluent_builders::DeleteService {
        fluent_builders::DeleteService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTaskSet`](crate::client::fluent_builders::DeleteTaskSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::DeleteTaskSet::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::DeleteTaskSet::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task set found in to delete.</p>
    ///   - [`service(impl Into<String>)`](crate::client::fluent_builders::DeleteTaskSet::service) / [`set_service(Option<String>)`](crate::client::fluent_builders::DeleteTaskSet::set_service): <p>The short name or full Amazon Resource Name (ARN) of the service that hosts the task set to delete.</p>
    ///   - [`task_set(impl Into<String>)`](crate::client::fluent_builders::DeleteTaskSet::task_set) / [`set_task_set(Option<String>)`](crate::client::fluent_builders::DeleteTaskSet::set_task_set): <p>The task set ID or full Amazon Resource Name (ARN) of the task set to delete.</p>
    ///   - [`force(bool)`](crate::client::fluent_builders::DeleteTaskSet::force) / [`set_force(Option<bool>)`](crate::client::fluent_builders::DeleteTaskSet::set_force): <p>If <code>true</code>, you can delete a task set even if it hasn't been scaled down to zero.</p>
    /// - On success, responds with [`DeleteTaskSetOutput`](crate::output::DeleteTaskSetOutput) with field(s):
    ///   - [`task_set(Option<TaskSet>)`](crate::output::DeleteTaskSetOutput::task_set): <p>Details about the task set.</p>
    /// - On failure, responds with [`SdkError<DeleteTaskSetError>`](crate::error::DeleteTaskSetError)
    pub fn delete_task_set(&self) -> fluent_builders::DeleteTaskSet {
        fluent_builders::DeleteTaskSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterContainerInstance`](crate::client::fluent_builders::DeregisterContainerInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::DeregisterContainerInstance::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::DeregisterContainerInstance::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instance to deregister. If you do not specify a cluster, the default cluster is assumed.</p>
    ///   - [`container_instance(impl Into<String>)`](crate::client::fluent_builders::DeregisterContainerInstance::container_instance) / [`set_container_instance(Option<String>)`](crate::client::fluent_builders::DeregisterContainerInstance::set_container_instance): <p>The container instance ID or full ARN of the container instance to deregister. The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the container instance, the Amazon Web Services account ID of the container instance owner, the <code>container-instance</code> namespace, and then the container instance ID. For example, <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.</p>
    ///   - [`force(bool)`](crate::client::fluent_builders::DeregisterContainerInstance::force) / [`set_force(Option<bool>)`](crate::client::fluent_builders::DeregisterContainerInstance::set_force): <p>Forces the container instance to be deregistered. If you have tasks running on the container instance when you deregister it with the <code>force</code> option, these tasks remain running until you terminate the instance or the tasks stop through some other means, but they're orphaned (no longer monitored or accounted for by Amazon ECS). If an orphaned task on your container instance is part of an Amazon ECS service, then the service scheduler starts another copy of that task, on a different container instance if possible. </p>  <p>Any containers in orphaned service tasks that are registered with a Classic Load Balancer or an Application Load Balancer target group are deregistered. They begin connection draining according to the settings on the load balancer or target group.</p>
    /// - On success, responds with [`DeregisterContainerInstanceOutput`](crate::output::DeregisterContainerInstanceOutput) with field(s):
    ///   - [`container_instance(Option<ContainerInstance>)`](crate::output::DeregisterContainerInstanceOutput::container_instance): <p>The container instance that was deregistered.</p>
    /// - On failure, responds with [`SdkError<DeregisterContainerInstanceError>`](crate::error::DeregisterContainerInstanceError)
    pub fn deregister_container_instance(&self) -> fluent_builders::DeregisterContainerInstance {
        fluent_builders::DeregisterContainerInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterTaskDefinition`](crate::client::fluent_builders::DeregisterTaskDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_definition(impl Into<String>)`](crate::client::fluent_builders::DeregisterTaskDefinition::task_definition) / [`set_task_definition(Option<String>)`](crate::client::fluent_builders::DeregisterTaskDefinition::set_task_definition): <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full Amazon Resource Name (ARN) of the task definition to deregister. You must specify a <code>revision</code>.</p>
    /// - On success, responds with [`DeregisterTaskDefinitionOutput`](crate::output::DeregisterTaskDefinitionOutput) with field(s):
    ///   - [`task_definition(Option<TaskDefinition>)`](crate::output::DeregisterTaskDefinitionOutput::task_definition): <p>The full description of the deregistered task.</p>
    /// - On failure, responds with [`SdkError<DeregisterTaskDefinitionError>`](crate::error::DeregisterTaskDefinitionError)
    pub fn deregister_task_definition(&self) -> fluent_builders::DeregisterTaskDefinition {
        fluent_builders::DeregisterTaskDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCapacityProviders`](crate::client::fluent_builders::DescribeCapacityProviders) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`capacity_providers(Vec<String>)`](crate::client::fluent_builders::DescribeCapacityProviders::capacity_providers) / [`set_capacity_providers(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeCapacityProviders::set_capacity_providers): <p>The short name or full Amazon Resource Name (ARN) of one or more capacity providers. Up to <code>100</code> capacity providers can be described in an action.</p>
    ///   - [`include(Vec<CapacityProviderField>)`](crate::client::fluent_builders::DescribeCapacityProviders::include) / [`set_include(Option<Vec<CapacityProviderField>>)`](crate::client::fluent_builders::DescribeCapacityProviders::set_include): <p>Specifies whether or not you want to see the resource tags for the capacity provider. If <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags aren't included in the response.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeCapacityProviders::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeCapacityProviders::set_max_results): <p>The maximum number of account setting results returned by <code>DescribeCapacityProviders</code> in paginated output. When this parameter is used, <code>DescribeCapacityProviders</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeCapacityProviders</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 10. If this parameter is not used, then <code>DescribeCapacityProviders</code> returns up to 10 results and a <code>nextToken</code> value if applicable.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeCapacityProviders::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeCapacityProviders::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeCapacityProviders</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>   <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>  </note>
    /// - On success, responds with [`DescribeCapacityProvidersOutput`](crate::output::DescribeCapacityProvidersOutput) with field(s):
    ///   - [`capacity_providers(Option<Vec<CapacityProvider>>)`](crate::output::DescribeCapacityProvidersOutput::capacity_providers): <p>The list of capacity providers.</p>
    ///   - [`failures(Option<Vec<Failure>>)`](crate::output::DescribeCapacityProvidersOutput::failures): <p>Any failures associated with the call.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeCapacityProvidersOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>DescribeCapacityProviders</code> request. When the results of a <code>DescribeCapacityProviders</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeCapacityProvidersError>`](crate::error::DescribeCapacityProvidersError)
    pub fn describe_capacity_providers(&self) -> fluent_builders::DescribeCapacityProviders {
        fluent_builders::DescribeCapacityProviders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClusters`](crate::client::fluent_builders::DescribeClusters) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`clusters(Vec<String>)`](crate::client::fluent_builders::DescribeClusters::clusters) / [`set_clusters(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeClusters::set_clusters): <p>A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries. If you do not specify a cluster, the default cluster is assumed.</p>
    ///   - [`include(Vec<ClusterField>)`](crate::client::fluent_builders::DescribeClusters::include) / [`set_include(Option<Vec<ClusterField>>)`](crate::client::fluent_builders::DescribeClusters::set_include): <p>Determines whether to include additional information about the clusters in the response. If this field is omitted, this information isn't included.</p>  <p>If <code>ATTACHMENTS</code> is specified, the attachments for the container instances or tasks within the cluster are included.</p>  <p>If <code>SETTINGS</code> is specified, the settings for the cluster are included.</p>  <p>If <code>CONFIGURATIONS</code> is specified, the configuration for the cluster is included.</p>  <p>If <code>STATISTICS</code> is specified, the task and service count is included, separated by launch type.</p>  <p>If <code>TAGS</code> is specified, the metadata tags associated with the cluster are included.</p>
    /// - On success, responds with [`DescribeClustersOutput`](crate::output::DescribeClustersOutput) with field(s):
    ///   - [`clusters(Option<Vec<Cluster>>)`](crate::output::DescribeClustersOutput::clusters): <p>The list of clusters.</p>
    ///   - [`failures(Option<Vec<Failure>>)`](crate::output::DescribeClustersOutput::failures): <p>Any failures associated with the call.</p>
    /// - On failure, responds with [`SdkError<DescribeClustersError>`](crate::error::DescribeClustersError)
    pub fn describe_clusters(&self) -> fluent_builders::DescribeClusters {
        fluent_builders::DescribeClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeContainerInstances`](crate::client::fluent_builders::DescribeContainerInstances) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::DescribeContainerInstances::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::DescribeContainerInstances::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the container instance or container instances you are describing were launched in any cluster other than the default cluster.</p>
    ///   - [`container_instances(Vec<String>)`](crate::client::fluent_builders::DescribeContainerInstances::container_instances) / [`set_container_instances(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeContainerInstances::set_container_instances): <p>A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.</p>
    ///   - [`include(Vec<ContainerInstanceField>)`](crate::client::fluent_builders::DescribeContainerInstances::include) / [`set_include(Option<Vec<ContainerInstanceField>>)`](crate::client::fluent_builders::DescribeContainerInstances::set_include): <p>Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is specified, the tags are included in the response. If <code>CONTAINER_INSTANCE_HEALTH</code> is specified, the container instance health is included in the response. If this field is omitted, tags and container instance health status aren't included in the response.</p>
    /// - On success, responds with [`DescribeContainerInstancesOutput`](crate::output::DescribeContainerInstancesOutput) with field(s):
    ///   - [`container_instances(Option<Vec<ContainerInstance>>)`](crate::output::DescribeContainerInstancesOutput::container_instances): <p>The list of container instances.</p>
    ///   - [`failures(Option<Vec<Failure>>)`](crate::output::DescribeContainerInstancesOutput::failures): <p>Any failures associated with the call.</p>
    /// - On failure, responds with [`SdkError<DescribeContainerInstancesError>`](crate::error::DescribeContainerInstancesError)
    pub fn describe_container_instances(&self) -> fluent_builders::DescribeContainerInstances {
        fluent_builders::DescribeContainerInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeServices`](crate::client::fluent_builders::DescribeServices) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::DescribeServices::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::DescribeServices::set_cluster): <p>The short name or full Amazon Resource Name (ARN)the cluster that hosts the service to describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the service or services you are describing were launched in any cluster other than the default cluster.</p>
    ///   - [`services(Vec<String>)`](crate::client::fluent_builders::DescribeServices::services) / [`set_services(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeServices::set_services): <p>A list of services to describe. You may specify up to 10 services to describe in a single operation.</p>
    ///   - [`include(Vec<ServiceField>)`](crate::client::fluent_builders::DescribeServices::include) / [`set_include(Option<Vec<ServiceField>>)`](crate::client::fluent_builders::DescribeServices::set_include): <p>Determines whether you want to see the resource tags for the service. If <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags aren't included in the response.</p>
    /// - On success, responds with [`DescribeServicesOutput`](crate::output::DescribeServicesOutput) with field(s):
    ///   - [`services(Option<Vec<Service>>)`](crate::output::DescribeServicesOutput::services): <p>The list of services described.</p>
    ///   - [`failures(Option<Vec<Failure>>)`](crate::output::DescribeServicesOutput::failures): <p>Any failures associated with the call.</p>
    /// - On failure, responds with [`SdkError<DescribeServicesError>`](crate::error::DescribeServicesError)
    pub fn describe_services(&self) -> fluent_builders::DescribeServices {
        fluent_builders::DescribeServices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTaskDefinition`](crate::client::fluent_builders::DescribeTaskDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_definition(impl Into<String>)`](crate::client::fluent_builders::DescribeTaskDefinition::task_definition) / [`set_task_definition(Option<String>)`](crate::client::fluent_builders::DescribeTaskDefinition::set_task_definition): <p>The <code>family</code> for the latest <code>ACTIVE</code> revision, <code>family</code> and <code>revision</code> (<code>family:revision</code>) for a specific revision in the family, or full Amazon Resource Name (ARN) of the task definition to describe.</p>
    ///   - [`include(Vec<TaskDefinitionField>)`](crate::client::fluent_builders::DescribeTaskDefinition::include) / [`set_include(Option<Vec<TaskDefinitionField>>)`](crate::client::fluent_builders::DescribeTaskDefinition::set_include): <p>Determines whether to see the resource tags for the task definition. If <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags aren't included in the response.</p>
    /// - On success, responds with [`DescribeTaskDefinitionOutput`](crate::output::DescribeTaskDefinitionOutput) with field(s):
    ///   - [`task_definition(Option<TaskDefinition>)`](crate::output::DescribeTaskDefinitionOutput::task_definition): <p>The full task definition description.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::DescribeTaskDefinitionOutput::tags): <p>The metadata that's applied to the task definition to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.</p>  <p>The following basic restrictions apply to tags:</p>  <ul>   <li> <p>Maximum number of tags per resource - 50</p> </li>   <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>   <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>   <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>   <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>   <li> <p>Tag keys and values are case-sensitive.</p> </li>   <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<DescribeTaskDefinitionError>`](crate::error::DescribeTaskDefinitionError)
    pub fn describe_task_definition(&self) -> fluent_builders::DescribeTaskDefinition {
        fluent_builders::DescribeTaskDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTasks`](crate::client::fluent_builders::DescribeTasks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::DescribeTasks::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::DescribeTasks::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task or tasks to describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the task or tasks you are describing were launched in any cluster other than the default cluster.</p>
    ///   - [`tasks(Vec<String>)`](crate::client::fluent_builders::DescribeTasks::tasks) / [`set_tasks(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTasks::set_tasks): <p>A list of up to 100 task IDs or full ARN entries.</p>
    ///   - [`include(Vec<TaskField>)`](crate::client::fluent_builders::DescribeTasks::include) / [`set_include(Option<Vec<TaskField>>)`](crate::client::fluent_builders::DescribeTasks::set_include): <p>Specifies whether you want to see the resource tags for the task. If <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags aren't included in the response.</p>
    /// - On success, responds with [`DescribeTasksOutput`](crate::output::DescribeTasksOutput) with field(s):
    ///   - [`tasks(Option<Vec<Task>>)`](crate::output::DescribeTasksOutput::tasks): <p>The list of tasks.</p>
    ///   - [`failures(Option<Vec<Failure>>)`](crate::output::DescribeTasksOutput::failures): <p>Any failures associated with the call.</p>
    /// - On failure, responds with [`SdkError<DescribeTasksError>`](crate::error::DescribeTasksError)
    pub fn describe_tasks(&self) -> fluent_builders::DescribeTasks {
        fluent_builders::DescribeTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTaskSets`](crate::client::fluent_builders::DescribeTaskSets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::DescribeTaskSets::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::DescribeTaskSets::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task sets exist in.</p>
    ///   - [`service(impl Into<String>)`](crate::client::fluent_builders::DescribeTaskSets::service) / [`set_service(Option<String>)`](crate::client::fluent_builders::DescribeTaskSets::set_service): <p>The short name or full Amazon Resource Name (ARN) of the service that the task sets exist in.</p>
    ///   - [`task_sets(Vec<String>)`](crate::client::fluent_builders::DescribeTaskSets::task_sets) / [`set_task_sets(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTaskSets::set_task_sets): <p>The ID or full Amazon Resource Name (ARN) of task sets to describe.</p>
    ///   - [`include(Vec<TaskSetField>)`](crate::client::fluent_builders::DescribeTaskSets::include) / [`set_include(Option<Vec<TaskSetField>>)`](crate::client::fluent_builders::DescribeTaskSets::set_include): <p>Specifies whether to see the resource tags for the task set. If <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags aren't included in the response.</p>
    /// - On success, responds with [`DescribeTaskSetsOutput`](crate::output::DescribeTaskSetsOutput) with field(s):
    ///   - [`task_sets(Option<Vec<TaskSet>>)`](crate::output::DescribeTaskSetsOutput::task_sets): <p>The list of task sets described.</p>
    ///   - [`failures(Option<Vec<Failure>>)`](crate::output::DescribeTaskSetsOutput::failures): <p>Any failures associated with the call.</p>
    /// - On failure, responds with [`SdkError<DescribeTaskSetsError>`](crate::error::DescribeTaskSetsError)
    pub fn describe_task_sets(&self) -> fluent_builders::DescribeTaskSets {
        fluent_builders::DescribeTaskSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DiscoverPollEndpoint`](crate::client::fluent_builders::DiscoverPollEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_instance(impl Into<String>)`](crate::client::fluent_builders::DiscoverPollEndpoint::container_instance) / [`set_container_instance(Option<String>)`](crate::client::fluent_builders::DiscoverPollEndpoint::set_container_instance): <p>The container instance ID or full ARN of the container instance. The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the container instance, the Amazon Web Services account ID of the container instance owner, the <code>container-instance</code> namespace, and then the container instance ID. For example, <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.</p>
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::DiscoverPollEndpoint::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::DiscoverPollEndpoint::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that the container instance belongs to.</p>
    /// - On success, responds with [`DiscoverPollEndpointOutput`](crate::output::DiscoverPollEndpointOutput) with field(s):
    ///   - [`endpoint(Option<String>)`](crate::output::DiscoverPollEndpointOutput::endpoint): <p>The endpoint for the Amazon ECS agent to poll.</p>
    ///   - [`telemetry_endpoint(Option<String>)`](crate::output::DiscoverPollEndpointOutput::telemetry_endpoint): <p>The telemetry endpoint for the Amazon ECS agent.</p>
    /// - On failure, responds with [`SdkError<DiscoverPollEndpointError>`](crate::error::DiscoverPollEndpointError)
    pub fn discover_poll_endpoint(&self) -> fluent_builders::DiscoverPollEndpoint {
        fluent_builders::DiscoverPollEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExecuteCommand`](crate::client::fluent_builders::ExecuteCommand) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::ExecuteCommand::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::ExecuteCommand::set_cluster): <p>The Amazon Resource Name (ARN) or short name of the cluster the task is running in. If you do not specify a cluster, the default cluster is assumed.</p>
    ///   - [`container(impl Into<String>)`](crate::client::fluent_builders::ExecuteCommand::container) / [`set_container(Option<String>)`](crate::client::fluent_builders::ExecuteCommand::set_container): <p>The name of the container to execute the command on. A container name only needs to be specified for tasks containing multiple containers.</p>
    ///   - [`command(impl Into<String>)`](crate::client::fluent_builders::ExecuteCommand::command) / [`set_command(Option<String>)`](crate::client::fluent_builders::ExecuteCommand::set_command): <p>The command to run on the container.</p>
    ///   - [`interactive(bool)`](crate::client::fluent_builders::ExecuteCommand::interactive) / [`set_interactive(bool)`](crate::client::fluent_builders::ExecuteCommand::set_interactive): <p>Use this flag to run your command in interactive mode.</p>
    ///   - [`task(impl Into<String>)`](crate::client::fluent_builders::ExecuteCommand::task) / [`set_task(Option<String>)`](crate::client::fluent_builders::ExecuteCommand::set_task): <p>The Amazon Resource Name (ARN) or ID of the task the container is part of.</p>
    /// - On success, responds with [`ExecuteCommandOutput`](crate::output::ExecuteCommandOutput) with field(s):
    ///   - [`cluster_arn(Option<String>)`](crate::output::ExecuteCommandOutput::cluster_arn): <p>The Amazon Resource Name (ARN) of the cluster.</p>
    ///   - [`container_arn(Option<String>)`](crate::output::ExecuteCommandOutput::container_arn): <p>The Amazon Resource Name (ARN) of the container.</p>
    ///   - [`container_name(Option<String>)`](crate::output::ExecuteCommandOutput::container_name): <p>The name of the container.</p>
    ///   - [`interactive(bool)`](crate::output::ExecuteCommandOutput::interactive): <p>Determines whether the execute command session is running in interactive mode. Amazon ECS only supports initiating interactive sessions, so you must specify <code>true</code> for this value.</p>
    ///   - [`session(Option<Session>)`](crate::output::ExecuteCommandOutput::session): <p>The details of the SSM session that was created for this instance of execute-command.</p>
    ///   - [`task_arn(Option<String>)`](crate::output::ExecuteCommandOutput::task_arn): <p>The Amazon Resource Name (ARN) of the task.</p>
    /// - On failure, responds with [`SdkError<ExecuteCommandError>`](crate::error::ExecuteCommandError)
    pub fn execute_command(&self) -> fluent_builders::ExecuteCommand {
        fluent_builders::ExecuteCommand::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccountSettings`](crate::client::fluent_builders::ListAccountSettings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAccountSettings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(SettingName)`](crate::client::fluent_builders::ListAccountSettings::name) / [`set_name(Option<SettingName>)`](crate::client::fluent_builders::ListAccountSettings::set_name): <p>The name of the account setting you want to list the settings for.</p>
    ///   - [`value(impl Into<String>)`](crate::client::fluent_builders::ListAccountSettings::value) / [`set_value(Option<String>)`](crate::client::fluent_builders::ListAccountSettings::set_value): <p>The value of the account settings to filter results with. You must also specify an account setting name to use this parameter.</p>
    ///   - [`principal_arn(impl Into<String>)`](crate::client::fluent_builders::ListAccountSettings::principal_arn) / [`set_principal_arn(Option<String>)`](crate::client::fluent_builders::ListAccountSettings::set_principal_arn): <p>The ARN of the principal, which can be an IAM user, IAM role, or the root user. If this field is omitted, the account settings are listed only for the authenticated user.</p> <note>   <p>Federated users assume the account setting of the root user and can't have explicit account settings set for them.</p>  </note>
    ///   - [`effective_settings(bool)`](crate::client::fluent_builders::ListAccountSettings::effective_settings) / [`set_effective_settings(bool)`](crate::client::fluent_builders::ListAccountSettings::set_effective_settings): <p>Determines whether to return the effective settings. If <code>true</code>, the account settings for the root user or the default setting for the <code>principalArn</code> are returned. If <code>false</code>, the account settings for the <code>principalArn</code> are returned if they're set. Otherwise, no account settings are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAccountSettings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAccountSettings::set_next_token): <p>The <code>nextToken</code> value returned from a <code>ListAccountSettings</code> request indicating that more results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was provided, it's possible the number of results to be fewer than <code>maxResults</code>.</p> <note>   <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>  </note>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAccountSettings::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListAccountSettings::set_max_results): <p>The maximum number of account setting results returned by <code>ListAccountSettings</code> in paginated output. When this parameter is used, <code>ListAccountSettings</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListAccountSettings</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 10. If this parameter isn't used, then <code>ListAccountSettings</code> returns up to 10 results and a <code>nextToken</code> value if applicable.</p>
    /// - On success, responds with [`ListAccountSettingsOutput`](crate::output::ListAccountSettingsOutput) with field(s):
    ///   - [`settings(Option<Vec<Setting>>)`](crate::output::ListAccountSettingsOutput::settings): <p>The account settings for the resource.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAccountSettingsOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListAccountSettings</code> request. When the results of a <code>ListAccountSettings</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListAccountSettingsError>`](crate::error::ListAccountSettingsError)
    pub fn list_account_settings(&self) -> fluent_builders::ListAccountSettings {
        fluent_builders::ListAccountSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAttributes`](crate::client::fluent_builders::ListAttributes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAttributes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::ListAttributes::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::ListAttributes::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster to list attributes. If you do not specify a cluster, the default cluster is assumed.</p>
    ///   - [`target_type(TargetType)`](crate::client::fluent_builders::ListAttributes::target_type) / [`set_target_type(Option<TargetType>)`](crate::client::fluent_builders::ListAttributes::set_target_type): <p>The type of the target to list attributes with.</p>
    ///   - [`attribute_name(impl Into<String>)`](crate::client::fluent_builders::ListAttributes::attribute_name) / [`set_attribute_name(Option<String>)`](crate::client::fluent_builders::ListAttributes::set_attribute_name): <p>The name of the attribute to filter the results with. </p>
    ///   - [`attribute_value(impl Into<String>)`](crate::client::fluent_builders::ListAttributes::attribute_value) / [`set_attribute_value(Option<String>)`](crate::client::fluent_builders::ListAttributes::set_attribute_value): <p>The value of the attribute to filter results with. You must also specify an attribute name to use this parameter.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAttributes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAttributes::set_next_token): <p>The <code>nextToken</code> value returned from a <code>ListAttributes</code> request indicating that more results are available to fulfill the request and further calls are needed. If <code>maxResults</code> was provided, it's possible the number of results to be fewer than <code>maxResults</code>.</p> <note>   <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>  </note>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAttributes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAttributes::set_max_results): <p>The maximum number of cluster results that <code>ListAttributes</code> returned in paginated output. When this parameter is used, <code>ListAttributes</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListAttributes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListAttributes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    /// - On success, responds with [`ListAttributesOutput`](crate::output::ListAttributesOutput) with field(s):
    ///   - [`attributes(Option<Vec<Attribute>>)`](crate::output::ListAttributesOutput::attributes): <p>A list of attribute objects that meet the criteria of the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAttributesOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListAttributes</code> request. When the results of a <code>ListAttributes</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListAttributesError>`](crate::error::ListAttributesError)
    pub fn list_attributes(&self) -> fluent_builders::ListAttributes {
        fluent_builders::ListAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListClusters`](crate::client::fluent_builders::ListClusters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListClusters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListClusters::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListClusters::set_next_token): <p>The <code>nextToken</code> value returned from a <code>ListClusters</code> request indicating that more results are available to fulfill the request and further calls are needed. If <code>maxResults</code> was provided, it's possible the number of results to be fewer than <code>maxResults</code>.</p> <note>   <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>  </note>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListClusters::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListClusters::set_max_results): <p>The maximum number of cluster results that <code>ListClusters</code> returned in paginated output. When this parameter is used, <code>ListClusters</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListClusters</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListClusters</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    /// - On success, responds with [`ListClustersOutput`](crate::output::ListClustersOutput) with field(s):
    ///   - [`cluster_arns(Option<Vec<String>>)`](crate::output::ListClustersOutput::cluster_arns): <p>The list of full Amazon Resource Name (ARN) entries for each cluster that's associated with your account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListClustersOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListClusters</code> request. When the results of a <code>ListClusters</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListClustersError>`](crate::error::ListClustersError)
    pub fn list_clusters(&self) -> fluent_builders::ListClusters {
        fluent_builders::ListClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListContainerInstances`](crate::client::fluent_builders::ListContainerInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListContainerInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::ListContainerInstances::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::ListContainerInstances::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to list. If you do not specify a cluster, the default cluster is assumed.</p>
    ///   - [`filter(impl Into<String>)`](crate::client::fluent_builders::ListContainerInstances::filter) / [`set_filter(Option<String>)`](crate::client::fluent_builders::ListContainerInstances::set_filter): <p>You can filter the results of a <code>ListContainerInstances</code> operation with cluster query language statements. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListContainerInstances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListContainerInstances::set_next_token): <p>The <code>nextToken</code> value returned from a <code>ListContainerInstances</code> request indicating that more results are available to fulfill the request and further calls are needed. If <code>maxResults</code> was provided, it's possible the number of results to be fewer than <code>maxResults</code>.</p> <note>   <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>  </note>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListContainerInstances::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListContainerInstances::set_max_results): <p>The maximum number of container instance results that <code>ListContainerInstances</code> returned in paginated output. When this parameter is used, <code>ListContainerInstances</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListContainerInstances</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListContainerInstances</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    ///   - [`status(ContainerInstanceStatus)`](crate::client::fluent_builders::ListContainerInstances::status) / [`set_status(Option<ContainerInstanceStatus>)`](crate::client::fluent_builders::ListContainerInstances::set_status): <p>Filters the container instances by status. For example, if you specify the <code>DRAINING</code> status, the results include only container instances that have been set to <code>DRAINING</code> using <code>UpdateContainerInstancesState</code>. If you don't specify this parameter, the default is to include container instances set to all states other than <code>INACTIVE</code>.</p>
    /// - On success, responds with [`ListContainerInstancesOutput`](crate::output::ListContainerInstancesOutput) with field(s):
    ///   - [`container_instance_arns(Option<Vec<String>>)`](crate::output::ListContainerInstancesOutput::container_instance_arns): <p>The list of container instances with full ARN entries for each container instance associated with the specified cluster.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListContainerInstancesOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListContainerInstances</code> request. When the results of a <code>ListContainerInstances</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListContainerInstancesError>`](crate::error::ListContainerInstancesError)
    pub fn list_container_instances(&self) -> fluent_builders::ListContainerInstances {
        fluent_builders::ListContainerInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListServices`](crate::client::fluent_builders::ListServices) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListServices::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::ListServices::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::ListServices::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the <code>ListServices</code> results. If you do not specify a cluster, the default cluster is assumed.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListServices::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListServices::set_next_token): <p>The <code>nextToken</code> value returned from a <code>ListServices</code> request indicating that more results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was provided, it is possible the number of results to be fewer than <code>maxResults</code>.</p> <note>   <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>  </note>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListServices::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListServices::set_max_results): <p>The maximum number of service results that <code>ListServices</code> returned in paginated output. When this parameter is used, <code>ListServices</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListServices</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListServices</code> returns up to 10 results and a <code>nextToken</code> value if applicable.</p>
    ///   - [`launch_type(LaunchType)`](crate::client::fluent_builders::ListServices::launch_type) / [`set_launch_type(Option<LaunchType>)`](crate::client::fluent_builders::ListServices::set_launch_type): <p>The launch type to use when filtering the <code>ListServices</code> results.</p>
    ///   - [`scheduling_strategy(SchedulingStrategy)`](crate::client::fluent_builders::ListServices::scheduling_strategy) / [`set_scheduling_strategy(Option<SchedulingStrategy>)`](crate::client::fluent_builders::ListServices::set_scheduling_strategy): <p>The scheduling strategy to use when filtering the <code>ListServices</code> results.</p>
    /// - On success, responds with [`ListServicesOutput`](crate::output::ListServicesOutput) with field(s):
    ///   - [`service_arns(Option<Vec<String>>)`](crate::output::ListServicesOutput::service_arns): <p>The list of full ARN entries for each service that's associated with the specified cluster.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListServicesOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListServices</code> request. When the results of a <code>ListServices</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListServicesError>`](crate::error::ListServicesError)
    pub fn list_services(&self) -> fluent_builders::ListServices {
        fluent_builders::ListServices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) that identifies the resource to list the tags for. Currently, the supported resources are Amazon ECS tasks, services, task definitions, clusters, and container instances.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags for the resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTaskDefinitionFamilies`](crate::client::fluent_builders::ListTaskDefinitionFamilies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTaskDefinitionFamilies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`family_prefix(impl Into<String>)`](crate::client::fluent_builders::ListTaskDefinitionFamilies::family_prefix) / [`set_family_prefix(Option<String>)`](crate::client::fluent_builders::ListTaskDefinitionFamilies::set_family_prefix): <p>The <code>familyPrefix</code> is a string that's used to filter the results of <code>ListTaskDefinitionFamilies</code>. If you specify a <code>familyPrefix</code>, only task definition family names that begin with the <code>familyPrefix</code> string are returned.</p>
    ///   - [`status(TaskDefinitionFamilyStatus)`](crate::client::fluent_builders::ListTaskDefinitionFamilies::status) / [`set_status(Option<TaskDefinitionFamilyStatus>)`](crate::client::fluent_builders::ListTaskDefinitionFamilies::set_status): <p>The task definition family status to filter the <code>ListTaskDefinitionFamilies</code> results with. By default, both <code>ACTIVE</code> and <code>INACTIVE</code> task definition families are listed. If this parameter is set to <code>ACTIVE</code>, only task definition families that have an <code>ACTIVE</code> task definition revision are returned. If this parameter is set to <code>INACTIVE</code>, only task definition families that do not have any <code>ACTIVE</code> task definition revisions are returned. If you paginate the resulting output, be sure to keep the <code>status</code> value constant in each subsequent request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTaskDefinitionFamilies::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTaskDefinitionFamilies::set_next_token): <p>The <code>nextToken</code> value returned from a <code>ListTaskDefinitionFamilies</code> request indicating that more results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was provided, it is possible the number of results to be fewer than <code>maxResults</code>.</p> <note>   <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>  </note>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTaskDefinitionFamilies::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTaskDefinitionFamilies::set_max_results): <p>The maximum number of task definition family results that <code>ListTaskDefinitionFamilies</code> returned in paginated output. When this parameter is used, <code>ListTaskDefinitions</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListTaskDefinitionFamilies</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListTaskDefinitionFamilies</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    /// - On success, responds with [`ListTaskDefinitionFamiliesOutput`](crate::output::ListTaskDefinitionFamiliesOutput) with field(s):
    ///   - [`families(Option<Vec<String>>)`](crate::output::ListTaskDefinitionFamiliesOutput::families): <p>The list of task definition family names that match the <code>ListTaskDefinitionFamilies</code> request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTaskDefinitionFamiliesOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListTaskDefinitionFamilies</code> request. When the results of a <code>ListTaskDefinitionFamilies</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListTaskDefinitionFamiliesError>`](crate::error::ListTaskDefinitionFamiliesError)
    pub fn list_task_definition_families(&self) -> fluent_builders::ListTaskDefinitionFamilies {
        fluent_builders::ListTaskDefinitionFamilies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTaskDefinitions`](crate::client::fluent_builders::ListTaskDefinitions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTaskDefinitions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`family_prefix(impl Into<String>)`](crate::client::fluent_builders::ListTaskDefinitions::family_prefix) / [`set_family_prefix(Option<String>)`](crate::client::fluent_builders::ListTaskDefinitions::set_family_prefix): <p>The full family name to filter the <code>ListTaskDefinitions</code> results with. Specifying a <code>familyPrefix</code> limits the listed task definitions to task definition revisions that belong to that family.</p>
    ///   - [`status(TaskDefinitionStatus)`](crate::client::fluent_builders::ListTaskDefinitions::status) / [`set_status(Option<TaskDefinitionStatus>)`](crate::client::fluent_builders::ListTaskDefinitions::set_status): <p>The task definition status to filter the <code>ListTaskDefinitions</code> results with. By default, only <code>ACTIVE</code> task definitions are listed. By setting this parameter to <code>INACTIVE</code>, you can view task definitions that are <code>INACTIVE</code> as long as an active task or service still references them. If you paginate the resulting output, be sure to keep the <code>status</code> value constant in each subsequent request.</p>
    ///   - [`sort(SortOrder)`](crate::client::fluent_builders::ListTaskDefinitions::sort) / [`set_sort(Option<SortOrder>)`](crate::client::fluent_builders::ListTaskDefinitions::set_sort): <p>The order to sort the results in. Valid values are <code>ASC</code> and <code>DESC</code>. By default, (<code>ASC</code>) task definitions are listed lexicographically by family name and in ascending numerical order by revision so that the newest task definitions in a family are listed last. Setting this parameter to <code>DESC</code> reverses the sort order on family name and revision. This is so that the newest task definitions in a family are listed first.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTaskDefinitions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTaskDefinitions::set_next_token): <p>The <code>nextToken</code> value returned from a <code>ListTaskDefinitions</code> request indicating that more results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was provided, it is possible the number of results to be fewer than <code>maxResults</code>.</p> <note>   <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>  </note>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTaskDefinitions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTaskDefinitions::set_max_results): <p>The maximum number of task definition results that <code>ListTaskDefinitions</code> returned in paginated output. When this parameter is used, <code>ListTaskDefinitions</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListTaskDefinitions</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListTaskDefinitions</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    /// - On success, responds with [`ListTaskDefinitionsOutput`](crate::output::ListTaskDefinitionsOutput) with field(s):
    ///   - [`task_definition_arns(Option<Vec<String>>)`](crate::output::ListTaskDefinitionsOutput::task_definition_arns): <p>The list of task definition Amazon Resource Name (ARN) entries for the <code>ListTaskDefinitions</code> request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTaskDefinitionsOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListTaskDefinitions</code> request. When the results of a <code>ListTaskDefinitions</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListTaskDefinitionsError>`](crate::error::ListTaskDefinitionsError)
    pub fn list_task_definitions(&self) -> fluent_builders::ListTaskDefinitions {
        fluent_builders::ListTaskDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTasks`](crate::client::fluent_builders::ListTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::ListTasks::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::ListTasks::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the <code>ListTasks</code> results. If you do not specify a cluster, the default cluster is assumed.</p>
    ///   - [`container_instance(impl Into<String>)`](crate::client::fluent_builders::ListTasks::container_instance) / [`set_container_instance(Option<String>)`](crate::client::fluent_builders::ListTasks::set_container_instance): <p>The container instance ID or full ARN of the container instance to use when filtering the <code>ListTasks</code> results. Specifying a <code>containerInstance</code> limits the results to tasks that belong to that container instance.</p>
    ///   - [`family(impl Into<String>)`](crate::client::fluent_builders::ListTasks::family) / [`set_family(Option<String>)`](crate::client::fluent_builders::ListTasks::set_family): <p>The name of the task definition family to use when filtering the <code>ListTasks</code> results. Specifying a <code>family</code> limits the results to tasks that belong to that family.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTasks::set_next_token): <p>The <code>nextToken</code> value returned from a <code>ListTasks</code> request indicating that more results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was provided, it's possible the number of results to be fewer than <code>maxResults</code>.</p> <note>   <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>  </note>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTasks::set_max_results): <p>The maximum number of task results that <code>ListTasks</code> returned in paginated output. When this parameter is used, <code>ListTasks</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListTasks</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListTasks</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    ///   - [`started_by(impl Into<String>)`](crate::client::fluent_builders::ListTasks::started_by) / [`set_started_by(Option<String>)`](crate::client::fluent_builders::ListTasks::set_started_by): <p>The <code>startedBy</code> value to filter the task results with. Specifying a <code>startedBy</code> value limits the results to tasks that were started with that value.</p>
    ///   - [`service_name(impl Into<String>)`](crate::client::fluent_builders::ListTasks::service_name) / [`set_service_name(Option<String>)`](crate::client::fluent_builders::ListTasks::set_service_name): <p>The name of the service to use when filtering the <code>ListTasks</code> results. Specifying a <code>serviceName</code> limits the results to tasks that belong to that service.</p>
    ///   - [`desired_status(DesiredStatus)`](crate::client::fluent_builders::ListTasks::desired_status) / [`set_desired_status(Option<DesiredStatus>)`](crate::client::fluent_builders::ListTasks::set_desired_status): <p>The task desired status to use when filtering the <code>ListTasks</code> results. Specifying a <code>desiredStatus</code> of <code>STOPPED</code> limits the results to tasks that Amazon ECS has set the desired status to <code>STOPPED</code>. This can be useful for debugging tasks that aren't starting properly or have died or finished. The default status filter is <code>RUNNING</code>, which shows tasks that Amazon ECS has set the desired status to <code>RUNNING</code>.</p> <note>   <p>Although you can filter results based on a desired status of <code>PENDING</code>, this doesn't return any results. Amazon ECS never sets the desired status of a task to that value (only a task's <code>lastStatus</code> may have a value of <code>PENDING</code>).</p>  </note>
    ///   - [`launch_type(LaunchType)`](crate::client::fluent_builders::ListTasks::launch_type) / [`set_launch_type(Option<LaunchType>)`](crate::client::fluent_builders::ListTasks::set_launch_type): <p>The launch type to use when filtering the <code>ListTasks</code> results.</p>
    /// - On success, responds with [`ListTasksOutput`](crate::output::ListTasksOutput) with field(s):
    ///   - [`task_arns(Option<Vec<String>>)`](crate::output::ListTasksOutput::task_arns): <p>The list of task ARN entries for the <code>ListTasks</code> request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTasksOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListTasks</code> request. When the results of a <code>ListTasks</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListTasksError>`](crate::error::ListTasksError)
    pub fn list_tasks(&self) -> fluent_builders::ListTasks {
        fluent_builders::ListTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAccountSetting`](crate::client::fluent_builders::PutAccountSetting) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(SettingName)`](crate::client::fluent_builders::PutAccountSetting::name) / [`set_name(Option<SettingName>)`](crate::client::fluent_builders::PutAccountSetting::set_name): <p>The Amazon ECS resource name for which to modify the account setting. If <code>serviceLongArnFormat</code> is specified, the ARN for your Amazon ECS services is affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS container instances is affected. If <code>awsvpcTrunking</code> is specified, the elastic network interface (ENI) limit for your Amazon ECS container instances is affected. If <code>containerInsights</code> is specified, the default setting for CloudWatch Container Insights for your clusters is affected.</p>
    ///   - [`value(impl Into<String>)`](crate::client::fluent_builders::PutAccountSetting::value) / [`set_value(Option<String>)`](crate::client::fluent_builders::PutAccountSetting::set_value): <p>The account setting value for the specified principal ARN. Accepted values are <code>enabled</code> and <code>disabled</code>.</p>
    ///   - [`principal_arn(impl Into<String>)`](crate::client::fluent_builders::PutAccountSetting::principal_arn) / [`set_principal_arn(Option<String>)`](crate::client::fluent_builders::PutAccountSetting::set_principal_arn): <p>The ARN of the principal, which can be an IAM user, IAM role, or the root user. If you specify the root user, it modifies the account setting for all IAM users, IAM roles, and the root user of the account unless an IAM user or role explicitly overrides these settings. If this field is omitted, the setting is changed only for the authenticated user.</p> <note>   <p>Federated users assume the account setting of the root user and can't have explicit account settings set for them.</p>  </note>
    /// - On success, responds with [`PutAccountSettingOutput`](crate::output::PutAccountSettingOutput) with field(s):
    ///   - [`setting(Option<Setting>)`](crate::output::PutAccountSettingOutput::setting): <p>The current account setting for a resource.</p>
    /// - On failure, responds with [`SdkError<PutAccountSettingError>`](crate::error::PutAccountSettingError)
    pub fn put_account_setting(&self) -> fluent_builders::PutAccountSetting {
        fluent_builders::PutAccountSetting::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAccountSettingDefault`](crate::client::fluent_builders::PutAccountSettingDefault) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(SettingName)`](crate::client::fluent_builders::PutAccountSettingDefault::name) / [`set_name(Option<SettingName>)`](crate::client::fluent_builders::PutAccountSettingDefault::set_name): <p>The resource name for which to modify the account setting. If <code>serviceLongArnFormat</code> is specified, the ARN for your Amazon ECS services is affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS container instances is affected. If <code>awsvpcTrunking</code> is specified, the ENI limit for your Amazon ECS container instances is affected. If <code>containerInsights</code> is specified, the default setting for CloudWatch Container Insights for your clusters is affected.</p>
    ///   - [`value(impl Into<String>)`](crate::client::fluent_builders::PutAccountSettingDefault::value) / [`set_value(Option<String>)`](crate::client::fluent_builders::PutAccountSettingDefault::set_value): <p>The account setting value for the specified principal ARN. Accepted values are <code>enabled</code> and <code>disabled</code>.</p>
    /// - On success, responds with [`PutAccountSettingDefaultOutput`](crate::output::PutAccountSettingDefaultOutput) with field(s):
    ///   - [`setting(Option<Setting>)`](crate::output::PutAccountSettingDefaultOutput::setting): <p>The current setting for a resource.</p>
    /// - On failure, responds with [`SdkError<PutAccountSettingDefaultError>`](crate::error::PutAccountSettingDefaultError)
    pub fn put_account_setting_default(&self) -> fluent_builders::PutAccountSettingDefault {
        fluent_builders::PutAccountSettingDefault::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAttributes`](crate::client::fluent_builders::PutAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::PutAttributes::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::PutAttributes::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that contains the resource to apply attributes. If you do not specify a cluster, the default cluster is assumed.</p>
    ///   - [`attributes(Vec<Attribute>)`](crate::client::fluent_builders::PutAttributes::attributes) / [`set_attributes(Option<Vec<Attribute>>)`](crate::client::fluent_builders::PutAttributes::set_attributes): <p>The attributes to apply to your resource. You can specify up to 10 custom attributes for each resource. You can specify up to 10 attributes in a single call.</p>
    /// - On success, responds with [`PutAttributesOutput`](crate::output::PutAttributesOutput) with field(s):
    ///   - [`attributes(Option<Vec<Attribute>>)`](crate::output::PutAttributesOutput::attributes): <p>The attributes applied to your resource.</p>
    /// - On failure, responds with [`SdkError<PutAttributesError>`](crate::error::PutAttributesError)
    pub fn put_attributes(&self) -> fluent_builders::PutAttributes {
        fluent_builders::PutAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutClusterCapacityProviders`](crate::client::fluent_builders::PutClusterCapacityProviders) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::PutClusterCapacityProviders::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::PutClusterCapacityProviders::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster to modify the capacity provider settings for. If you don't specify a cluster, the default cluster is assumed.</p>
    ///   - [`capacity_providers(Vec<String>)`](crate::client::fluent_builders::PutClusterCapacityProviders::capacity_providers) / [`set_capacity_providers(Option<Vec<String>>)`](crate::client::fluent_builders::PutClusterCapacityProviders::set_capacity_providers): <p>The name of one or more capacity providers to associate with the cluster.</p>  <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the <code>CreateCapacityProvider</code> API operation.</p>  <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.</p>
    ///   - [`default_capacity_provider_strategy(Vec<CapacityProviderStrategyItem>)`](crate::client::fluent_builders::PutClusterCapacityProviders::default_capacity_provider_strategy) / [`set_default_capacity_provider_strategy(Option<Vec<CapacityProviderStrategyItem>>)`](crate::client::fluent_builders::PutClusterCapacityProviders::set_default_capacity_provider_strategy): <p>The capacity provider strategy to use by default for the cluster.</p>  <p>When creating a service or running a task on a cluster, if no capacity provider or launch type is specified then the default capacity provider strategy for the cluster is used.</p>  <p>A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The <code>PutClusterCapacityProviders</code> API is used to associate a capacity provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status can be used.</p>  <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the <code>CreateCapacityProvider</code> API operation.</p>  <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.</p>
    /// - On success, responds with [`PutClusterCapacityProvidersOutput`](crate::output::PutClusterCapacityProvidersOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::PutClusterCapacityProvidersOutput::cluster): <p>Details about the cluster.</p>
    /// - On failure, responds with [`SdkError<PutClusterCapacityProvidersError>`](crate::error::PutClusterCapacityProvidersError)
    pub fn put_cluster_capacity_providers(&self) -> fluent_builders::PutClusterCapacityProviders {
        fluent_builders::PutClusterCapacityProviders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterContainerInstance`](crate::client::fluent_builders::RegisterContainerInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::RegisterContainerInstance::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::RegisterContainerInstance::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster to register your container instance with. If you do not specify a cluster, the default cluster is assumed.</p>
    ///   - [`instance_identity_document(impl Into<String>)`](crate::client::fluent_builders::RegisterContainerInstance::instance_identity_document) / [`set_instance_identity_document(Option<String>)`](crate::client::fluent_builders::RegisterContainerInstance::set_instance_identity_document): <p>The instance identity document for the EC2 instance to register. This document can be found by running the following command from the instance: <code>curl http://169.254.169.254/latest/dynamic/instance-identity/document/</code> </p>
    ///   - [`instance_identity_document_signature(impl Into<String>)`](crate::client::fluent_builders::RegisterContainerInstance::instance_identity_document_signature) / [`set_instance_identity_document_signature(Option<String>)`](crate::client::fluent_builders::RegisterContainerInstance::set_instance_identity_document_signature): <p>The instance identity document signature for the EC2 instance to register. This signature can be found by running the following command from the instance: <code>curl http://169.254.169.254/latest/dynamic/instance-identity/signature/</code> </p>
    ///   - [`total_resources(Vec<Resource>)`](crate::client::fluent_builders::RegisterContainerInstance::total_resources) / [`set_total_resources(Option<Vec<Resource>>)`](crate::client::fluent_builders::RegisterContainerInstance::set_total_resources): <p>The resources available on the instance.</p>
    ///   - [`version_info(VersionInfo)`](crate::client::fluent_builders::RegisterContainerInstance::version_info) / [`set_version_info(Option<VersionInfo>)`](crate::client::fluent_builders::RegisterContainerInstance::set_version_info): <p>The version information for the Amazon ECS container agent and Docker daemon that runs on the container instance.</p>
    ///   - [`container_instance_arn(impl Into<String>)`](crate::client::fluent_builders::RegisterContainerInstance::container_instance_arn) / [`set_container_instance_arn(Option<String>)`](crate::client::fluent_builders::RegisterContainerInstance::set_container_instance_arn): <p>The ARN of the container instance (if it was previously registered).</p>
    ///   - [`attributes(Vec<Attribute>)`](crate::client::fluent_builders::RegisterContainerInstance::attributes) / [`set_attributes(Option<Vec<Attribute>>)`](crate::client::fluent_builders::RegisterContainerInstance::set_attributes): <p>The container instance attributes that this container instance supports.</p>
    ///   - [`platform_devices(Vec<PlatformDevice>)`](crate::client::fluent_builders::RegisterContainerInstance::platform_devices) / [`set_platform_devices(Option<Vec<PlatformDevice>>)`](crate::client::fluent_builders::RegisterContainerInstance::set_platform_devices): <p>The devices that are available on the container instance. The only supported device type is a GPU.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::RegisterContainerInstance::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::RegisterContainerInstance::set_tags): <p>The metadata that you apply to the container instance to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.</p>  <p>The following basic restrictions apply to tags:</p>  <ul>   <li> <p>Maximum number of tags per resource - 50</p> </li>   <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>   <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>   <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>   <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>   <li> <p>Tag keys and values are case-sensitive.</p> </li>   <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>  </ul>
    /// - On success, responds with [`RegisterContainerInstanceOutput`](crate::output::RegisterContainerInstanceOutput) with field(s):
    ///   - [`container_instance(Option<ContainerInstance>)`](crate::output::RegisterContainerInstanceOutput::container_instance): <p>The container instance that was registered.</p>
    /// - On failure, responds with [`SdkError<RegisterContainerInstanceError>`](crate::error::RegisterContainerInstanceError)
    pub fn register_container_instance(&self) -> fluent_builders::RegisterContainerInstance {
        fluent_builders::RegisterContainerInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterTaskDefinition`](crate::client::fluent_builders::RegisterTaskDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`family(impl Into<String>)`](crate::client::fluent_builders::RegisterTaskDefinition::family) / [`set_family(Option<String>)`](crate::client::fluent_builders::RegisterTaskDefinition::set_family): <p>You must specify a <code>family</code> for a task definition. You can use it track multiple versions of the same task definition. The <code>family</code> is used as a name for your task definition. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed.</p>
    ///   - [`task_role_arn(impl Into<String>)`](crate::client::fluent_builders::RegisterTaskDefinition::task_role_arn) / [`set_task_role_arn(Option<String>)`](crate::client::fluent_builders::RegisterTaskDefinition::set_task_role_arn): <p>The short name or full Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in this task are granted the permissions that are specified in this role. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Roles for Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    ///   - [`execution_role_arn(impl Into<String>)`](crate::client::fluent_builders::RegisterTaskDefinition::execution_role_arn) / [`set_execution_role_arn(Option<String>)`](crate::client::fluent_builders::RegisterTaskDefinition::set_execution_role_arn): <p>The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make Amazon Web Services API calls on your behalf. The task execution IAM role is required depending on the requirements of your task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    ///   - [`network_mode(NetworkMode)`](crate::client::fluent_builders::RegisterTaskDefinition::network_mode) / [`set_network_mode(Option<NetworkMode>)`](crate::client::fluent_builders::RegisterTaskDefinition::set_network_mode): <p>The Docker networking mode to use for the containers in the task. The valid values are <code>none</code>, <code>bridge</code>, <code>awsvpc</code>, and <code>host</code>. If no network mode is specified, the default is <code>bridge</code>.</p>  <p>For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required. For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used. For Amazon ECS tasks on Amazon EC2 Windows instances, <code>   <default></default></code> or <code>awsvpc</code> can be used. If the network mode is set to <code>none</code>, you cannot specify port mappings in your container definitions, and the tasks containers do not have external connectivity. The <code>host</code> and <code>awsvpc</code> network modes offer the highest networking performance for containers because they use the EC2 network stack instead of the virtualized network stack provided by the <code>bridge</code> mode.</p>  <p>With the <code>host</code> and <code>awsvpc</code> network modes, exposed container ports are mapped directly to the corresponding host port (for the <code>host</code> network mode) or the attached elastic network interface port (for the <code>awsvpc</code> network mode), so you cannot take advantage of dynamic host port mappings. </p> <important>   <p>When using the <code>host</code> network mode, you should not run containers using the root user (UID 0). It is considered best practice to use a non-root user.</p>  </important>  <p>If the network mode is <code>awsvpc</code>, the task is allocated an elastic network interface, and you must specify a <code>NetworkConfiguration</code> value when you create a service or run a task with the task definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>  <p>If the network mode is <code>host</code>, you cannot run multiple instantiations of the same task on a single container instance when port mappings are used.</p>  <p>For more information, see <a href="https://docs.docker.com/engine/reference/run/#network-settings">Network settings</a> in the <i>Docker run reference</i>.</p>
    ///   - [`container_definitions(Vec<ContainerDefinition>)`](crate::client::fluent_builders::RegisterTaskDefinition::container_definitions) / [`set_container_definitions(Option<Vec<ContainerDefinition>>)`](crate::client::fluent_builders::RegisterTaskDefinition::set_container_definitions): <p>A list of container definitions in JSON format that describe the different containers that make up your task.</p>
    ///   - [`volumes(Vec<Volume>)`](crate::client::fluent_builders::RegisterTaskDefinition::volumes) / [`set_volumes(Option<Vec<Volume>>)`](crate::client::fluent_builders::RegisterTaskDefinition::set_volumes): <p>A list of volume definitions in JSON format that containers in your task might use.</p>
    ///   - [`placement_constraints(Vec<TaskDefinitionPlacementConstraint>)`](crate::client::fluent_builders::RegisterTaskDefinition::placement_constraints) / [`set_placement_constraints(Option<Vec<TaskDefinitionPlacementConstraint>>)`](crate::client::fluent_builders::RegisterTaskDefinition::set_placement_constraints): <p>An array of placement constraint objects to use for the task. You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.</p>
    ///   - [`requires_compatibilities(Vec<Compatibility>)`](crate::client::fluent_builders::RegisterTaskDefinition::requires_compatibilities) / [`set_requires_compatibilities(Option<Vec<Compatibility>>)`](crate::client::fluent_builders::RegisterTaskDefinition::set_requires_compatibilities): <p>The task launch type that Amazon ECS validates the task definition against. A client exception is returned if the task definition doesn't validate against the compatibilities specified. If no value is specified, the parameter is omitted from the response.</p>
    ///   - [`cpu(impl Into<String>)`](crate::client::fluent_builders::RegisterTaskDefinition::cpu) / [`set_cpu(Option<String>)`](crate::client::fluent_builders::RegisterTaskDefinition::set_cpu): <p>The number of CPU units used by the task. It can be expressed as an integer using CPU units (for example, <code>1024</code>) or as a string using vCPUs (for example, <code>1 vCPU</code> or <code>1 vcpu</code>) in a task definition. String values are converted to an integer indicating the CPU units when the task definition is registered.</p> <note>   <p>Task-level CPU and memory parameters are ignored for Windows containers. We recommend specifying container-level resources for Windows containers.</p>  </note>  <p>If you're using the EC2 launch type, this field is optional. Supported values are between <code>128</code> CPU units (<code>0.125</code> vCPUs) and <code>10240</code> CPU units (<code>10</code> vCPUs).</p>  <p>If you're using the Fargate launch type, this field is required and you must use one of the following values, which determines your range of supported values for the <code>memory</code> parameter:</p>  <p>The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.</p>  <ul>   <li> <p>256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)</p> </li>   <li> <p>512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)</p> </li>   <li> <p>1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)</p> </li>   <li> <p>2048 (2 vCPU) - Available <code>memory</code> values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)</p> </li>   <li> <p>4096 (4 vCPU) - Available <code>memory</code> values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)</p> </li>  </ul>
    ///   - [`memory(impl Into<String>)`](crate::client::fluent_builders::RegisterTaskDefinition::memory) / [`set_memory(Option<String>)`](crate::client::fluent_builders::RegisterTaskDefinition::set_memory): <p>The amount of memory (in MiB) used by the task. It can be expressed as an integer using MiB (for example ,<code>1024</code>) or as a string using GB (for example, <code>1GB</code> or <code>1 GB</code>) in a task definition. String values are converted to an integer indicating the MiB when the task definition is registered.</p> <note>   <p>Task-level CPU and memory parameters are ignored for Windows containers. We recommend specifying container-level resources for Windows containers.</p>  </note>  <p>If using the EC2 launch type, this field is optional.</p>  <p>If using the Fargate launch type, this field is required and you must use one of the following values. This determines your range of supported values for the <code>cpu</code> parameter.</p>  <p>The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.</p>  <ul>   <li> <p>512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)</p> </li>   <li> <p>1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)</p> </li>   <li> <p>2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available <code>cpu</code> values: 1024 (1 vCPU)</p> </li>   <li> <p>Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2 vCPU)</p> </li>   <li> <p>Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4 vCPU)</p> </li>  </ul>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::RegisterTaskDefinition::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::RegisterTaskDefinition::set_tags): <p>The metadata that you apply to the task definition to help you categorize and organize them. Each tag consists of a key and an optional value. You define both of them.</p>  <p>The following basic restrictions apply to tags:</p>  <ul>   <li> <p>Maximum number of tags per resource - 50</p> </li>   <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>   <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>   <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>   <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>   <li> <p>Tag keys and values are case-sensitive.</p> </li>   <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>  </ul>
    ///   - [`pid_mode(PidMode)`](crate::client::fluent_builders::RegisterTaskDefinition::pid_mode) / [`set_pid_mode(Option<PidMode>)`](crate::client::fluent_builders::RegisterTaskDefinition::set_pid_mode): <p>The process namespace to use for the containers in the task. The valid values are <code>host</code> or <code>task</code>. If <code>host</code> is specified, then all containers within the tasks that specified the <code>host</code> PID mode on the same container instance share the same process namespace with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task share the same process namespace. If no value is specified, the default is a private namespace. For more information, see <a href="https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the <i>Docker run reference</i>.</p>  <p>If the <code>host</code> PID mode is used, be aware that there is a heightened risk of undesired process namespace expose. For more information, see <a href="https://docs.docker.com/engine/security/security/">Docker security</a>.</p> <note>   <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>  </note>
    ///   - [`ipc_mode(IpcMode)`](crate::client::fluent_builders::RegisterTaskDefinition::ipc_mode) / [`set_ipc_mode(Option<IpcMode>)`](crate::client::fluent_builders::RegisterTaskDefinition::set_ipc_mode): <p>The IPC resource namespace to use for the containers in the task. The valid values are <code>host</code>, <code>task</code>, or <code>none</code>. If <code>host</code> is specified, then all containers within the tasks that specified the <code>host</code> IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task share the same IPC resources. If <code>none</code> is specified, then IPC resources within the containers of a task are private and not shared with other containers in a task or on the container instance. If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see <a href="https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC settings</a> in the <i>Docker run reference</i>.</p>  <p>If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of undesired IPC namespace expose. For more information, see <a href="https://docs.docker.com/engine/security/security/">Docker security</a>.</p>  <p>If you are setting namespaced kernel parameters using <code>systemControls</code> for the containers in the task, the following will apply to your IPC resource namespace. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System Controls</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>  <ul>   <li> <p>For tasks that use the <code>host</code> IPC mode, IPC namespace related <code>systemControls</code> are not supported.</p> </li>   <li> <p>For tasks that use the <code>task</code> IPC mode, IPC namespace related <code>systemControls</code> will apply to all containers within a task.</p> </li>  </ul> <note>   <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>  </note>
    ///   - [`proxy_configuration(ProxyConfiguration)`](crate::client::fluent_builders::RegisterTaskDefinition::proxy_configuration) / [`set_proxy_configuration(Option<ProxyConfiguration>)`](crate::client::fluent_builders::RegisterTaskDefinition::set_proxy_configuration): <p>The configuration details for the App Mesh proxy.</p>  <p>For tasks hosted on Amazon EC2 instances, the container instances require at least version <code>1.26.0</code> of the container agent and at least version <code>1.26.0-1</code> of the <code>ecs-init</code> package to use a proxy configuration. If your container instances are launched from the Amazon ECS-optimized AMI version <code>20190301</code> or later, then they contain the required versions of the container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-ami-versions.html">Amazon ECS-optimized AMI versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    ///   - [`inference_accelerators(Vec<InferenceAccelerator>)`](crate::client::fluent_builders::RegisterTaskDefinition::inference_accelerators) / [`set_inference_accelerators(Option<Vec<InferenceAccelerator>>)`](crate::client::fluent_builders::RegisterTaskDefinition::set_inference_accelerators): <p>The Elastic Inference accelerators to use for the containers in the task.</p>
    ///   - [`ephemeral_storage(EphemeralStorage)`](crate::client::fluent_builders::RegisterTaskDefinition::ephemeral_storage) / [`set_ephemeral_storage(Option<EphemeralStorage>)`](crate::client::fluent_builders::RegisterTaskDefinition::set_ephemeral_storage): <p>The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on Fargate. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/using_data_volumes.html">Fargate task storage</a> in the <i>Amazon ECS User Guide for Fargate</i>.</p> <note>   <p>This parameter is only supported for tasks hosted on Fargate using the following platform versions:</p>   <ul>    <li> <p>Linux platform version <code>1.4.0</code> or later.</p> </li>    <li> <p>Windows platform version <code>1.0.0</code> or later.</p> </li>   </ul>  </note>
    ///   - [`runtime_platform(RuntimePlatform)`](crate::client::fluent_builders::RegisterTaskDefinition::runtime_platform) / [`set_runtime_platform(Option<RuntimePlatform>)`](crate::client::fluent_builders::RegisterTaskDefinition::set_runtime_platform): <p>The operating system that your tasks definitions run on. A platform family is specified only for tasks using the Fargate launch type. </p>  <p>When you specify a task definition in a service, this value must match the <code>runtimePlatform</code> value of the service.</p>
    /// - On success, responds with [`RegisterTaskDefinitionOutput`](crate::output::RegisterTaskDefinitionOutput) with field(s):
    ///   - [`task_definition(Option<TaskDefinition>)`](crate::output::RegisterTaskDefinitionOutput::task_definition): <p>The full description of the registered task definition.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::RegisterTaskDefinitionOutput::tags): <p>The list of tags associated with the task definition.</p>
    /// - On failure, responds with [`SdkError<RegisterTaskDefinitionError>`](crate::error::RegisterTaskDefinitionError)
    pub fn register_task_definition(&self) -> fluent_builders::RegisterTaskDefinition {
        fluent_builders::RegisterTaskDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RunTask`](crate::client::fluent_builders::RunTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`capacity_provider_strategy(Vec<CapacityProviderStrategyItem>)`](crate::client::fluent_builders::RunTask::capacity_provider_strategy) / [`set_capacity_provider_strategy(Option<Vec<CapacityProviderStrategyItem>>)`](crate::client::fluent_builders::RunTask::set_capacity_provider_strategy): <p>The capacity provider strategy to use for the task.</p>  <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.</p>  <p>When you use cluster auto scaling, you must specify <code>capacityProviderStrategy</code> and not <code>launchType</code>. </p>  <p>A capacity provider strategy may contain a maximum of 6 capacity providers.</p>
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::RunTask::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::RunTask::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster to run your task on. If you do not specify a cluster, the default cluster is assumed.</p>
    ///   - [`count(i32)`](crate::client::fluent_builders::RunTask::count) / [`set_count(Option<i32>)`](crate::client::fluent_builders::RunTask::set_count): <p>The number of instantiations of the specified task to place on your cluster. You can specify up to 10 tasks for each call.</p>
    ///   - [`enable_ecs_managed_tags(bool)`](crate::client::fluent_builders::RunTask::enable_ecs_managed_tags) / [`set_enable_ecs_managed_tags(bool)`](crate::client::fluent_builders::RunTask::set_enable_ecs_managed_tags): <p>Specifies whether to use Amazon ECS managed tags for the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    ///   - [`enable_execute_command(bool)`](crate::client::fluent_builders::RunTask::enable_execute_command) / [`set_enable_execute_command(bool)`](crate::client::fluent_builders::RunTask::set_enable_execute_command): <p>Determines whether to use the execute command functionality for the containers in this task. If <code>true</code>, this enables execute command functionality on all containers in the task.</p>  <p>If <code>true</code>, then the task definition must have a task role, or you must provide one as an override.</p>
    ///   - [`group(impl Into<String>)`](crate::client::fluent_builders::RunTask::group) / [`set_group(Option<String>)`](crate::client::fluent_builders::RunTask::set_group): <p>The name of the task group to associate with the task. The default value is the family name of the task definition (for example, <code>family:my-family-name</code>).</p>
    ///   - [`launch_type(LaunchType)`](crate::client::fluent_builders::RunTask::launch_type) / [`set_launch_type(Option<LaunchType>)`](crate::client::fluent_builders::RunTask::set_launch_type): <p>The infrastructure to run your standalone task on. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>  <p>The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand infrastructure.</p> <note>   <p>Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html">Fargate capacity providers</a> in the <i>Amazon ECS User Guide for Fargate</i>.</p>  </note>  <p>The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your cluster.</p>  <p>The <code>EXTERNAL</code> launch type runs your tasks on your on-premises server or virtual machine (VM) capacity registered to your cluster.</p>  <p>A task can use either a launch type or a capacity provider strategy. If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code> parameter must be omitted.</p>  <p>When you use cluster auto scaling, you must specify <code>capacityProviderStrategy</code> and not <code>launchType</code>. </p>
    ///   - [`network_configuration(NetworkConfiguration)`](crate::client::fluent_builders::RunTask::network_configuration) / [`set_network_configuration(Option<NetworkConfiguration>)`](crate::client::fluent_builders::RunTask::set_network_configuration): <p>The network configuration for the task. This parameter is required for task definitions that use the <code>awsvpc</code> network mode to receive their own elastic network interface, and it isn't supported for other network modes. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    ///   - [`overrides(TaskOverride)`](crate::client::fluent_builders::RunTask::overrides) / [`set_overrides(Option<TaskOverride>)`](crate::client::fluent_builders::RunTask::set_overrides): <p>A list of container overrides in JSON format that specify the name of a container in the specified task definition and the overrides it should receive. You can override the default command for a container (that's specified in the task definition or Docker image) with a <code>command</code> override. You can also override existing environment variables (that are specified in the task definition or Docker image) on a container or add new environment variables to it with an <code>environment</code> override.</p>  <p>A total of 8192 characters are allowed for overrides. This limit includes the JSON formatting characters of the override structure.</p>
    ///   - [`placement_constraints(Vec<PlacementConstraint>)`](crate::client::fluent_builders::RunTask::placement_constraints) / [`set_placement_constraints(Option<Vec<PlacementConstraint>>)`](crate::client::fluent_builders::RunTask::set_placement_constraints): <p>An array of placement constraint objects to use for the task. You can specify up to 10 constraints for each task (including constraints in the task definition and those specified at runtime).</p>
    ///   - [`placement_strategy(Vec<PlacementStrategy>)`](crate::client::fluent_builders::RunTask::placement_strategy) / [`set_placement_strategy(Option<Vec<PlacementStrategy>>)`](crate::client::fluent_builders::RunTask::set_placement_strategy): <p>The placement strategy objects to use for the task. You can specify a maximum of 5 strategy rules for each task.</p>
    ///   - [`platform_version(impl Into<String>)`](crate::client::fluent_builders::RunTask::platform_version) / [`set_platform_version(Option<String>)`](crate::client::fluent_builders::RunTask::set_platform_version): <p>The platform version the task uses. A platform version is only specified for tasks hosted on Fargate. If one isn't specified, the <code>LATEST</code> platform version is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate platform versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    ///   - [`propagate_tags(PropagateTags)`](crate::client::fluent_builders::RunTask::propagate_tags) / [`set_propagate_tags(Option<PropagateTags>)`](crate::client::fluent_builders::RunTask::set_propagate_tags): <p>Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the <code>TagResource</code> API action.</p> <note>   <p>An error will be received if you specify the <code>SERVICE</code> option when running a task.</p>  </note>
    ///   - [`reference_id(impl Into<String>)`](crate::client::fluent_builders::RunTask::reference_id) / [`set_reference_id(Option<String>)`](crate::client::fluent_builders::RunTask::set_reference_id): <p>The reference ID to use for the task. The reference ID can have a maximum length of 1024 characters.</p>
    ///   - [`started_by(impl Into<String>)`](crate::client::fluent_builders::RunTask::started_by) / [`set_started_by(Option<String>)`](crate::client::fluent_builders::RunTask::set_started_by): <p>An optional tag specified when a task is started. For example, if you automatically trigger a task to run a batch process job, you could apply a unique identifier for that job to your task with the <code>startedBy</code> parameter. You can then identify which tasks belong to that job by filtering the results of a <code>ListTasks</code> call with the <code>startedBy</code> value. Up to 36 letters (uppercase and lowercase), numbers, hyphens (-), and underscores (_) are allowed.</p>  <p>If a task is started by an Amazon ECS service, then the <code>startedBy</code> parameter contains the deployment ID of the service that starts it.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::RunTask::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::RunTask::set_tags): <p>The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>  <p>The following basic restrictions apply to tags:</p>  <ul>   <li> <p>Maximum number of tags per resource - 50</p> </li>   <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>   <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>   <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>   <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>   <li> <p>Tag keys and values are case-sensitive.</p> </li>   <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>  </ul>
    ///   - [`task_definition(impl Into<String>)`](crate::client::fluent_builders::RunTask::task_definition) / [`set_task_definition(Option<String>)`](crate::client::fluent_builders::RunTask::set_task_definition): <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task definition to run. If a <code>revision</code> isn't specified, the latest <code>ACTIVE</code> revision is used.</p>  <p>When you create an IAM policy for run-task, you can set the resource to be the latest task definition revision, or a specific revision.</p>  <p>The full ARN value must match the value that you specified as the <code>Resource</code> of the IAM principal's permissions policy.</p>  <p>When you specify the policy resource as the latest task definition version (by setting the <code>Resource</code> in the policy to <code>arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName</code>), then set this value to <code>arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName</code>.</p>  <p>When you specify the policy resource as a specific task definition version (by setting the <code>Resource</code> in the policy to <code>arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:1</code> or <code>arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:*</code>), then set this value to <code>arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:1</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-resources">Policy Resources for Amazon ECS</a> in the Amazon Elastic Container Service developer Guide.</p>
    /// - On success, responds with [`RunTaskOutput`](crate::output::RunTaskOutput) with field(s):
    ///   - [`tasks(Option<Vec<Task>>)`](crate::output::RunTaskOutput::tasks): <p>A full description of the tasks that were run. The tasks that were successfully placed on your cluster are described here.</p>
    ///   - [`failures(Option<Vec<Failure>>)`](crate::output::RunTaskOutput::failures): <p>Any failures associated with the call.</p>
    /// - On failure, responds with [`SdkError<RunTaskError>`](crate::error::RunTaskError)
    pub fn run_task(&self) -> fluent_builders::RunTask {
        fluent_builders::RunTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartTask`](crate::client::fluent_builders::StartTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::StartTask::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::StartTask::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster where to start your task. If you do not specify a cluster, the default cluster is assumed.</p>
    ///   - [`container_instances(Vec<String>)`](crate::client::fluent_builders::StartTask::container_instances) / [`set_container_instances(Option<Vec<String>>)`](crate::client::fluent_builders::StartTask::set_container_instances): <p>The container instance IDs or full ARN entries for the container instances where you would like to place your task. You can specify up to 10 container instances.</p>
    ///   - [`enable_ecs_managed_tags(bool)`](crate::client::fluent_builders::StartTask::enable_ecs_managed_tags) / [`set_enable_ecs_managed_tags(bool)`](crate::client::fluent_builders::StartTask::set_enable_ecs_managed_tags): <p>Specifies whether to use Amazon ECS managed tags for the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    ///   - [`enable_execute_command(bool)`](crate::client::fluent_builders::StartTask::enable_execute_command) / [`set_enable_execute_command(bool)`](crate::client::fluent_builders::StartTask::set_enable_execute_command): <p>Whether or not the execute command functionality is enabled for the task. If <code>true</code>, this enables execute command functionality on all containers in the task.</p>
    ///   - [`group(impl Into<String>)`](crate::client::fluent_builders::StartTask::group) / [`set_group(Option<String>)`](crate::client::fluent_builders::StartTask::set_group): <p>The name of the task group to associate with the task. The default value is the family name of the task definition (for example, family:my-family-name).</p>
    ///   - [`network_configuration(NetworkConfiguration)`](crate::client::fluent_builders::StartTask::network_configuration) / [`set_network_configuration(Option<NetworkConfiguration>)`](crate::client::fluent_builders::StartTask::set_network_configuration): <p>The VPC subnet and security group configuration for tasks that receive their own elastic network interface by using the <code>awsvpc</code> networking mode.</p>
    ///   - [`overrides(TaskOverride)`](crate::client::fluent_builders::StartTask::overrides) / [`set_overrides(Option<TaskOverride>)`](crate::client::fluent_builders::StartTask::set_overrides): <p>A list of container overrides in JSON format that specify the name of a container in the specified task definition and the overrides it receives. You can override the default command for a container (that's specified in the task definition or Docker image) with a <code>command</code> override. You can also override existing environment variables (that are specified in the task definition or Docker image) on a container or add new environment variables to it with an <code>environment</code> override.</p> <note>   <p>A total of 8192 characters are allowed for overrides. This limit includes the JSON formatting characters of the override structure.</p>  </note>
    ///   - [`propagate_tags(PropagateTags)`](crate::client::fluent_builders::StartTask::propagate_tags) / [`set_propagate_tags(Option<PropagateTags>)`](crate::client::fluent_builders::StartTask::set_propagate_tags): <p>Specifies whether to propagate the tags from the task definition or the service to the task. If no value is specified, the tags aren't propagated.</p>
    ///   - [`reference_id(impl Into<String>)`](crate::client::fluent_builders::StartTask::reference_id) / [`set_reference_id(Option<String>)`](crate::client::fluent_builders::StartTask::set_reference_id): <p>The reference ID to use for the task.</p>
    ///   - [`started_by(impl Into<String>)`](crate::client::fluent_builders::StartTask::started_by) / [`set_started_by(Option<String>)`](crate::client::fluent_builders::StartTask::set_started_by): <p>An optional tag specified when a task is started. For example, if you automatically trigger a task to run a batch process job, you could apply a unique identifier for that job to your task with the <code>startedBy</code> parameter. You can then identify which tasks belong to that job by filtering the results of a <code>ListTasks</code> call with the <code>startedBy</code> value. Up to 36 letters (uppercase and lowercase), numbers, hyphens (-), and underscores (_) are allowed.</p>  <p>If a task is started by an Amazon ECS service, the <code>startedBy</code> parameter contains the deployment ID of the service that starts it.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::StartTask::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::StartTask::set_tags): <p>The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>  <p>The following basic restrictions apply to tags:</p>  <ul>   <li> <p>Maximum number of tags per resource - 50</p> </li>   <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>   <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>   <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>   <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>   <li> <p>Tag keys and values are case-sensitive.</p> </li>   <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>  </ul>
    ///   - [`task_definition(impl Into<String>)`](crate::client::fluent_builders::StartTask::task_definition) / [`set_task_definition(Option<String>)`](crate::client::fluent_builders::StartTask::set_task_definition): <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task definition to start. If a <code>revision</code> isn't specified, the latest <code>ACTIVE</code> revision is used.</p>
    /// - On success, responds with [`StartTaskOutput`](crate::output::StartTaskOutput) with field(s):
    ///   - [`tasks(Option<Vec<Task>>)`](crate::output::StartTaskOutput::tasks): <p>A full description of the tasks that were started. Each task that was successfully placed on your container instances is described.</p>
    ///   - [`failures(Option<Vec<Failure>>)`](crate::output::StartTaskOutput::failures): <p>Any failures associated with the call.</p>
    /// - On failure, responds with [`SdkError<StartTaskError>`](crate::error::StartTaskError)
    pub fn start_task(&self) -> fluent_builders::StartTask {
        fluent_builders::StartTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopTask`](crate::client::fluent_builders::StopTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::StopTask::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::StopTask::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task to stop. If you do not specify a cluster, the default cluster is assumed.</p>
    ///   - [`task(impl Into<String>)`](crate::client::fluent_builders::StopTask::task) / [`set_task(Option<String>)`](crate::client::fluent_builders::StopTask::set_task): <p>The task ID or full Amazon Resource Name (ARN) of the task to stop.</p>
    ///   - [`reason(impl Into<String>)`](crate::client::fluent_builders::StopTask::reason) / [`set_reason(Option<String>)`](crate::client::fluent_builders::StopTask::set_reason): <p>An optional message specified when a task is stopped. For example, if you're using a custom scheduler, you can use this parameter to specify the reason for stopping the task here, and the message appears in subsequent <code>DescribeTasks</code> API operations on this task. Up to 255 characters are allowed in this message.</p>
    /// - On success, responds with [`StopTaskOutput`](crate::output::StopTaskOutput) with field(s):
    ///   - [`task(Option<Task>)`](crate::output::StopTaskOutput::task): <p>The task that was stopped.</p>
    /// - On failure, responds with [`SdkError<StopTaskError>`](crate::error::StopTaskError)
    pub fn stop_task(&self) -> fluent_builders::StopTask {
        fluent_builders::StopTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SubmitAttachmentStateChanges`](crate::client::fluent_builders::SubmitAttachmentStateChanges) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::SubmitAttachmentStateChanges::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::SubmitAttachmentStateChanges::set_cluster): <p>The short name or full ARN of the cluster that hosts the container instance the attachment belongs to.</p>
    ///   - [`attachments(Vec<AttachmentStateChange>)`](crate::client::fluent_builders::SubmitAttachmentStateChanges::attachments) / [`set_attachments(Option<Vec<AttachmentStateChange>>)`](crate::client::fluent_builders::SubmitAttachmentStateChanges::set_attachments): <p>Any attachments associated with the state change request.</p>
    /// - On success, responds with [`SubmitAttachmentStateChangesOutput`](crate::output::SubmitAttachmentStateChangesOutput) with field(s):
    ///   - [`acknowledgment(Option<String>)`](crate::output::SubmitAttachmentStateChangesOutput::acknowledgment): <p>Acknowledgement of the state change.</p>
    /// - On failure, responds with [`SdkError<SubmitAttachmentStateChangesError>`](crate::error::SubmitAttachmentStateChangesError)
    pub fn submit_attachment_state_changes(&self) -> fluent_builders::SubmitAttachmentStateChanges {
        fluent_builders::SubmitAttachmentStateChanges::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SubmitContainerStateChange`](crate::client::fluent_builders::SubmitContainerStateChange) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::SubmitContainerStateChange::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::SubmitContainerStateChange::set_cluster): <p>The short name or full ARN of the cluster that hosts the container.</p>
    ///   - [`task(impl Into<String>)`](crate::client::fluent_builders::SubmitContainerStateChange::task) / [`set_task(Option<String>)`](crate::client::fluent_builders::SubmitContainerStateChange::set_task): <p>The task ID or full Amazon Resource Name (ARN) of the task that hosts the container.</p>
    ///   - [`container_name(impl Into<String>)`](crate::client::fluent_builders::SubmitContainerStateChange::container_name) / [`set_container_name(Option<String>)`](crate::client::fluent_builders::SubmitContainerStateChange::set_container_name): <p>The name of the container.</p>
    ///   - [`runtime_id(impl Into<String>)`](crate::client::fluent_builders::SubmitContainerStateChange::runtime_id) / [`set_runtime_id(Option<String>)`](crate::client::fluent_builders::SubmitContainerStateChange::set_runtime_id): <p>The ID of the Docker container.</p>
    ///   - [`status(impl Into<String>)`](crate::client::fluent_builders::SubmitContainerStateChange::status) / [`set_status(Option<String>)`](crate::client::fluent_builders::SubmitContainerStateChange::set_status): <p>The status of the state change request.</p>
    ///   - [`exit_code(i32)`](crate::client::fluent_builders::SubmitContainerStateChange::exit_code) / [`set_exit_code(Option<i32>)`](crate::client::fluent_builders::SubmitContainerStateChange::set_exit_code): <p>The exit code that's returned for the state change request.</p>
    ///   - [`reason(impl Into<String>)`](crate::client::fluent_builders::SubmitContainerStateChange::reason) / [`set_reason(Option<String>)`](crate::client::fluent_builders::SubmitContainerStateChange::set_reason): <p>The reason for the state change request.</p>
    ///   - [`network_bindings(Vec<NetworkBinding>)`](crate::client::fluent_builders::SubmitContainerStateChange::network_bindings) / [`set_network_bindings(Option<Vec<NetworkBinding>>)`](crate::client::fluent_builders::SubmitContainerStateChange::set_network_bindings): <p>The network bindings of the container.</p>
    /// - On success, responds with [`SubmitContainerStateChangeOutput`](crate::output::SubmitContainerStateChangeOutput) with field(s):
    ///   - [`acknowledgment(Option<String>)`](crate::output::SubmitContainerStateChangeOutput::acknowledgment): <p>Acknowledgement of the state change.</p>
    /// - On failure, responds with [`SdkError<SubmitContainerStateChangeError>`](crate::error::SubmitContainerStateChangeError)
    pub fn submit_container_state_change(&self) -> fluent_builders::SubmitContainerStateChange {
        fluent_builders::SubmitContainerStateChange::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SubmitTaskStateChange`](crate::client::fluent_builders::SubmitTaskStateChange) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::SubmitTaskStateChange::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::SubmitTaskStateChange::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task.</p>
    ///   - [`task(impl Into<String>)`](crate::client::fluent_builders::SubmitTaskStateChange::task) / [`set_task(Option<String>)`](crate::client::fluent_builders::SubmitTaskStateChange::set_task): <p>The task ID or full ARN of the task in the state change request.</p>
    ///   - [`status(impl Into<String>)`](crate::client::fluent_builders::SubmitTaskStateChange::status) / [`set_status(Option<String>)`](crate::client::fluent_builders::SubmitTaskStateChange::set_status): <p>The status of the state change request.</p>
    ///   - [`reason(impl Into<String>)`](crate::client::fluent_builders::SubmitTaskStateChange::reason) / [`set_reason(Option<String>)`](crate::client::fluent_builders::SubmitTaskStateChange::set_reason): <p>The reason for the state change request.</p>
    ///   - [`containers(Vec<ContainerStateChange>)`](crate::client::fluent_builders::SubmitTaskStateChange::containers) / [`set_containers(Option<Vec<ContainerStateChange>>)`](crate::client::fluent_builders::SubmitTaskStateChange::set_containers): <p>Any containers that's associated with the state change request.</p>
    ///   - [`attachments(Vec<AttachmentStateChange>)`](crate::client::fluent_builders::SubmitTaskStateChange::attachments) / [`set_attachments(Option<Vec<AttachmentStateChange>>)`](crate::client::fluent_builders::SubmitTaskStateChange::set_attachments): <p>Any attachments associated with the state change request.</p>
    ///   - [`managed_agents(Vec<ManagedAgentStateChange>)`](crate::client::fluent_builders::SubmitTaskStateChange::managed_agents) / [`set_managed_agents(Option<Vec<ManagedAgentStateChange>>)`](crate::client::fluent_builders::SubmitTaskStateChange::set_managed_agents): <p>The details for the managed agent that's associated with the task.</p>
    ///   - [`pull_started_at(DateTime)`](crate::client::fluent_builders::SubmitTaskStateChange::pull_started_at) / [`set_pull_started_at(Option<DateTime>)`](crate::client::fluent_builders::SubmitTaskStateChange::set_pull_started_at): <p>The Unix timestamp for the time when the container image pull started.</p>
    ///   - [`pull_stopped_at(DateTime)`](crate::client::fluent_builders::SubmitTaskStateChange::pull_stopped_at) / [`set_pull_stopped_at(Option<DateTime>)`](crate::client::fluent_builders::SubmitTaskStateChange::set_pull_stopped_at): <p>The Unix timestamp for the time when the container image pull completed.</p>
    ///   - [`execution_stopped_at(DateTime)`](crate::client::fluent_builders::SubmitTaskStateChange::execution_stopped_at) / [`set_execution_stopped_at(Option<DateTime>)`](crate::client::fluent_builders::SubmitTaskStateChange::set_execution_stopped_at): <p>The Unix timestamp for the time when the task execution stopped.</p>
    /// - On success, responds with [`SubmitTaskStateChangeOutput`](crate::output::SubmitTaskStateChangeOutput) with field(s):
    ///   - [`acknowledgment(Option<String>)`](crate::output::SubmitTaskStateChangeOutput::acknowledgment): <p>Acknowledgement of the state change.</p>
    /// - On failure, responds with [`SdkError<SubmitTaskStateChangeError>`](crate::error::SubmitTaskStateChangeError)
    pub fn submit_task_state_change(&self) -> fluent_builders::SubmitTaskStateChange {
        fluent_builders::SubmitTaskStateChange::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to add tags to. Currently, the supported resources are Amazon ECS capacity providers, tasks, services, task definitions, clusters, and container instances.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to add to the resource. A tag is an array of key-value pairs.</p>  <p>The following basic restrictions apply to tags:</p>  <ul>   <li> <p>Maximum number of tags per resource - 50</p> </li>   <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>   <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>   <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>   <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>   <li> <p>Tag keys and values are case-sensitive.</p> </li>   <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>  </ul>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to delete tags from. Currently, the supported resources are Amazon ECS capacity providers, tasks, services, task definitions, clusters, and container instances.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The keys of the tags to be removed.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCapacityProvider`](crate::client::fluent_builders::UpdateCapacityProvider) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateCapacityProvider::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateCapacityProvider::set_name): <p>The name of the capacity provider to update.</p>
    ///   - [`auto_scaling_group_provider(AutoScalingGroupProviderUpdate)`](crate::client::fluent_builders::UpdateCapacityProvider::auto_scaling_group_provider) / [`set_auto_scaling_group_provider(Option<AutoScalingGroupProviderUpdate>)`](crate::client::fluent_builders::UpdateCapacityProvider::set_auto_scaling_group_provider): <p>An object that represent the parameters to update for the Auto Scaling group capacity provider.</p>
    /// - On success, responds with [`UpdateCapacityProviderOutput`](crate::output::UpdateCapacityProviderOutput) with field(s):
    ///   - [`capacity_provider(Option<CapacityProvider>)`](crate::output::UpdateCapacityProviderOutput::capacity_provider): <p>Details about the capacity provider.</p>
    /// - On failure, responds with [`SdkError<UpdateCapacityProviderError>`](crate::error::UpdateCapacityProviderError)
    pub fn update_capacity_provider(&self) -> fluent_builders::UpdateCapacityProvider {
        fluent_builders::UpdateCapacityProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCluster`](crate::client::fluent_builders::UpdateCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::UpdateCluster::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::UpdateCluster::set_cluster): <p>The name of the cluster to modify the settings for.</p>
    ///   - [`settings(Vec<ClusterSetting>)`](crate::client::fluent_builders::UpdateCluster::settings) / [`set_settings(Option<Vec<ClusterSetting>>)`](crate::client::fluent_builders::UpdateCluster::set_settings): <p>The cluster settings for your cluster.</p>
    ///   - [`configuration(ClusterConfiguration)`](crate::client::fluent_builders::UpdateCluster::configuration) / [`set_configuration(Option<ClusterConfiguration>)`](crate::client::fluent_builders::UpdateCluster::set_configuration): <p>The execute command configuration for the cluster.</p>
    /// - On success, responds with [`UpdateClusterOutput`](crate::output::UpdateClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::UpdateClusterOutput::cluster): <p>Details about the cluster.</p>
    /// - On failure, responds with [`SdkError<UpdateClusterError>`](crate::error::UpdateClusterError)
    pub fn update_cluster(&self) -> fluent_builders::UpdateCluster {
        fluent_builders::UpdateCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateClusterSettings`](crate::client::fluent_builders::UpdateClusterSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::UpdateClusterSettings::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::UpdateClusterSettings::set_cluster): <p>The name of the cluster to modify the settings for.</p>
    ///   - [`settings(Vec<ClusterSetting>)`](crate::client::fluent_builders::UpdateClusterSettings::settings) / [`set_settings(Option<Vec<ClusterSetting>>)`](crate::client::fluent_builders::UpdateClusterSettings::set_settings): <p>The setting to use by default for a cluster. This parameter is used to turn on CloudWatch Container Insights for a cluster. If this value is specified, it overrides the <code>containerInsights</code> value set with <code>PutAccountSetting</code> or <code>PutAccountSettingDefault</code>.</p>
    /// - On success, responds with [`UpdateClusterSettingsOutput`](crate::output::UpdateClusterSettingsOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::UpdateClusterSettingsOutput::cluster): <p>Details about the cluster</p>
    /// - On failure, responds with [`SdkError<UpdateClusterSettingsError>`](crate::error::UpdateClusterSettingsError)
    pub fn update_cluster_settings(&self) -> fluent_builders::UpdateClusterSettings {
        fluent_builders::UpdateClusterSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateContainerAgent`](crate::client::fluent_builders::UpdateContainerAgent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::UpdateContainerAgent::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::UpdateContainerAgent::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that your container instance is running on. If you do not specify a cluster, the default cluster is assumed.</p>
    ///   - [`container_instance(impl Into<String>)`](crate::client::fluent_builders::UpdateContainerAgent::container_instance) / [`set_container_instance(Option<String>)`](crate::client::fluent_builders::UpdateContainerAgent::set_container_instance): <p>The container instance ID or full ARN entries for the container instance where you would like to update the Amazon ECS container agent.</p>
    /// - On success, responds with [`UpdateContainerAgentOutput`](crate::output::UpdateContainerAgentOutput) with field(s):
    ///   - [`container_instance(Option<ContainerInstance>)`](crate::output::UpdateContainerAgentOutput::container_instance): <p>The container instance that the container agent was updated for.</p>
    /// - On failure, responds with [`SdkError<UpdateContainerAgentError>`](crate::error::UpdateContainerAgentError)
    pub fn update_container_agent(&self) -> fluent_builders::UpdateContainerAgent {
        fluent_builders::UpdateContainerAgent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateContainerInstancesState`](crate::client::fluent_builders::UpdateContainerInstancesState) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::UpdateContainerInstancesState::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::UpdateContainerInstancesState::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instance to update. If you do not specify a cluster, the default cluster is assumed.</p>
    ///   - [`container_instances(Vec<String>)`](crate::client::fluent_builders::UpdateContainerInstancesState::container_instances) / [`set_container_instances(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateContainerInstancesState::set_container_instances): <p>A list of up to 10 container instance IDs or full ARN entries.</p>
    ///   - [`status(ContainerInstanceStatus)`](crate::client::fluent_builders::UpdateContainerInstancesState::status) / [`set_status(Option<ContainerInstanceStatus>)`](crate::client::fluent_builders::UpdateContainerInstancesState::set_status): <p>The container instance state to update the container instance with. The only valid values for this action are <code>ACTIVE</code> and <code>DRAINING</code>. A container instance can only be updated to <code>DRAINING</code> status once it has reached an <code>ACTIVE</code> state. If a container instance is in <code>REGISTERING</code>, <code>DEREGISTERING</code>, or <code>REGISTRATION_FAILED</code> state you can describe the container instance but can't update the container instance state.</p>
    /// - On success, responds with [`UpdateContainerInstancesStateOutput`](crate::output::UpdateContainerInstancesStateOutput) with field(s):
    ///   - [`container_instances(Option<Vec<ContainerInstance>>)`](crate::output::UpdateContainerInstancesStateOutput::container_instances): <p>The list of container instances.</p>
    ///   - [`failures(Option<Vec<Failure>>)`](crate::output::UpdateContainerInstancesStateOutput::failures): <p>Any failures associated with the call.</p>
    /// - On failure, responds with [`SdkError<UpdateContainerInstancesStateError>`](crate::error::UpdateContainerInstancesStateError)
    pub fn update_container_instances_state(
        &self,
    ) -> fluent_builders::UpdateContainerInstancesState {
        fluent_builders::UpdateContainerInstancesState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateService`](crate::client::fluent_builders::UpdateService) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::UpdateService::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::UpdateService::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that your service runs on. If you do not specify a cluster, the default cluster is assumed.</p>
    ///   - [`service(impl Into<String>)`](crate::client::fluent_builders::UpdateService::service) / [`set_service(Option<String>)`](crate::client::fluent_builders::UpdateService::set_service): <p>The name of the service to update.</p>
    ///   - [`desired_count(i32)`](crate::client::fluent_builders::UpdateService::desired_count) / [`set_desired_count(Option<i32>)`](crate::client::fluent_builders::UpdateService::set_desired_count): <p>The number of instantiations of the task to place and keep running in your service.</p>
    ///   - [`task_definition(impl Into<String>)`](crate::client::fluent_builders::UpdateService::task_definition) / [`set_task_definition(Option<String>)`](crate::client::fluent_builders::UpdateService::set_task_definition): <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task definition to run in your service. If a <code>revision</code> is not specified, the latest <code>ACTIVE</code> revision is used. If you modify the task definition with <code>UpdateService</code>, Amazon ECS spawns a task with the new version of the task definition and then stops an old task after the new version is running.</p>
    ///   - [`capacity_provider_strategy(Vec<CapacityProviderStrategyItem>)`](crate::client::fluent_builders::UpdateService::capacity_provider_strategy) / [`set_capacity_provider_strategy(Option<Vec<CapacityProviderStrategyItem>>)`](crate::client::fluent_builders::UpdateService::set_capacity_provider_strategy): <p>The capacity provider strategy to update the service to use.</p>  <p>if the service uses the default capacity provider strategy for the cluster, the service can be updated to use one or more capacity providers as opposed to the default capacity provider strategy. However, when a service is using a capacity provider strategy that's not the default capacity provider strategy, the service can't be updated to use the cluster's default capacity provider strategy.</p>  <p>A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The <code>PutClusterCapacityProviders</code> API is used to associate a capacity provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status can be used.</p>  <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the <code>CreateCapacityProvider</code> API operation.</p>  <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.</p>  <p>The <code>PutClusterCapacityProviders</code> API operation is used to update the list of available capacity providers for a cluster after the cluster is created.</p>  <p></p>
    ///   - [`deployment_configuration(DeploymentConfiguration)`](crate::client::fluent_builders::UpdateService::deployment_configuration) / [`set_deployment_configuration(Option<DeploymentConfiguration>)`](crate::client::fluent_builders::UpdateService::set_deployment_configuration): <p>Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.</p>
    ///   - [`network_configuration(NetworkConfiguration)`](crate::client::fluent_builders::UpdateService::network_configuration) / [`set_network_configuration(Option<NetworkConfiguration>)`](crate::client::fluent_builders::UpdateService::set_network_configuration): <p>An object representing the network configuration for the service.</p>
    ///   - [`placement_constraints(Vec<PlacementConstraint>)`](crate::client::fluent_builders::UpdateService::placement_constraints) / [`set_placement_constraints(Option<Vec<PlacementConstraint>>)`](crate::client::fluent_builders::UpdateService::set_placement_constraints): <p>An array of task placement constraint objects to update the service to use. If no value is specified, the existing placement constraints for the service will remain unchanged. If this value is specified, it will override any existing placement constraints defined for the service. To remove all existing placement constraints, specify an empty array.</p>  <p>You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.</p>
    ///   - [`placement_strategy(Vec<PlacementStrategy>)`](crate::client::fluent_builders::UpdateService::placement_strategy) / [`set_placement_strategy(Option<Vec<PlacementStrategy>>)`](crate::client::fluent_builders::UpdateService::set_placement_strategy): <p>The task placement strategy objects to update the service to use. If no value is specified, the existing placement strategy for the service will remain unchanged. If this value is specified, it will override the existing placement strategy defined for the service. To remove an existing placement strategy, specify an empty object.</p>  <p>You can specify a maximum of five strategy rules for each service.</p>
    ///   - [`platform_version(impl Into<String>)`](crate::client::fluent_builders::UpdateService::platform_version) / [`set_platform_version(Option<String>)`](crate::client::fluent_builders::UpdateService::set_platform_version): <p>The platform version that your tasks in the service run on. A platform version is only specified for tasks using the Fargate launch type. If a platform version is not specified, the <code>LATEST</code> platform version is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    ///   - [`force_new_deployment(bool)`](crate::client::fluent_builders::UpdateService::force_new_deployment) / [`set_force_new_deployment(bool)`](crate::client::fluent_builders::UpdateService::set_force_new_deployment): <p>Determines whether to force a new deployment of the service. By default, deployments aren't forced. You can use this option to start a new deployment with no service definition changes. For example, you can update a service's tasks to use a newer Docker image with the same image/tag combination (<code>my_image:latest</code>) or to roll Fargate tasks onto a newer platform version.</p>
    ///   - [`health_check_grace_period_seconds(i32)`](crate::client::fluent_builders::UpdateService::health_check_grace_period_seconds) / [`set_health_check_grace_period_seconds(Option<i32>)`](crate::client::fluent_builders::UpdateService::set_health_check_grace_period_seconds): <p>The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started. This is only valid if your service is configured to use a load balancer. If your service's tasks take a while to start and respond to Elastic Load Balancing health checks, you can specify a health check grace period of up to 2,147,483,647 seconds. During that time, the Amazon ECS service scheduler ignores the Elastic Load Balancing health check status. This grace period can prevent the ECS service scheduler from marking tasks as unhealthy and stopping them before they have time to come up.</p>
    ///   - [`enable_execute_command(bool)`](crate::client::fluent_builders::UpdateService::enable_execute_command) / [`set_enable_execute_command(Option<bool>)`](crate::client::fluent_builders::UpdateService::set_enable_execute_command): <p>If <code>true</code>, this enables execute command functionality on all task containers.</p>  <p>If you do not want to override the value that was set when the service was created, you can set this to <code>null</code> when performing this action.</p>
    ///   - [`enable_ecs_managed_tags(bool)`](crate::client::fluent_builders::UpdateService::enable_ecs_managed_tags) / [`set_enable_ecs_managed_tags(Option<bool>)`](crate::client::fluent_builders::UpdateService::set_enable_ecs_managed_tags): <p>Determines whether to turn on Amazon ECS managed tags for the tasks in the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>  <p>Only tasks launched after the update will reflect the update. To update the tags on all tasks, set <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the updated tags.</p>
    ///   - [`load_balancers(Vec<LoadBalancer>)`](crate::client::fluent_builders::UpdateService::load_balancers) / [`set_load_balancers(Option<Vec<LoadBalancer>>)`](crate::client::fluent_builders::UpdateService::set_load_balancers): <p>A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container name, and the container port to access from the load balancer. The container name is as it appears in a container definition.</p>  <p>When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the updated Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are running.</p>  <p>For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target groups. You can update from a single target group to multiple target groups and from multiple target groups to a single target group.</p>  <p>For services that use blue/green deployments, you can update Elastic Load Balancing target groups by using <code> <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> </code> through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For more information see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. </p>  <p>For services that use the external deployment controller, you can add, update, or remove load balancers by using <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html">CreateTaskSet</a>. Note that multiple target groups are not supported for external deployments. For more information see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. </p>  <p>You can remove existing <code>loadBalancers</code> by passing an empty list.</p>
    ///   - [`propagate_tags(PropagateTags)`](crate::client::fluent_builders::UpdateService::propagate_tags) / [`set_propagate_tags(Option<PropagateTags>)`](crate::client::fluent_builders::UpdateService::set_propagate_tags): <p>Determines whether to propagate the tags from the task definition or the service to the task. If no value is specified, the tags aren't propagated.</p>  <p>Only tasks launched after the update will reflect the update. To update the tags on all tasks, set <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the updated tags.</p>
    ///   - [`service_registries(Vec<ServiceRegistry>)`](crate::client::fluent_builders::UpdateService::service_registries) / [`set_service_registries(Option<Vec<ServiceRegistry>>)`](crate::client::fluent_builders::UpdateService::set_service_registries): <p>The details for the service discovery registries to assign to this service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service Discovery</a>.</p>  <p>When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with the updated service registries configuration, and then stops the old tasks when the new tasks are running.</p>  <p>You can remove existing <code>serviceRegistries</code> by passing an empty list.</p>
    /// - On success, responds with [`UpdateServiceOutput`](crate::output::UpdateServiceOutput) with field(s):
    ///   - [`service(Option<Service>)`](crate::output::UpdateServiceOutput::service): <p>The full description of your service following the update call.</p>
    /// - On failure, responds with [`SdkError<UpdateServiceError>`](crate::error::UpdateServiceError)
    pub fn update_service(&self) -> fluent_builders::UpdateService {
        fluent_builders::UpdateService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateServicePrimaryTaskSet`](crate::client::fluent_builders::UpdateServicePrimaryTaskSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::UpdateServicePrimaryTaskSet::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::UpdateServicePrimaryTaskSet::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task set exists in.</p>
    ///   - [`service(impl Into<String>)`](crate::client::fluent_builders::UpdateServicePrimaryTaskSet::service) / [`set_service(Option<String>)`](crate::client::fluent_builders::UpdateServicePrimaryTaskSet::set_service): <p>The short name or full Amazon Resource Name (ARN) of the service that the task set exists in.</p>
    ///   - [`primary_task_set(impl Into<String>)`](crate::client::fluent_builders::UpdateServicePrimaryTaskSet::primary_task_set) / [`set_primary_task_set(Option<String>)`](crate::client::fluent_builders::UpdateServicePrimaryTaskSet::set_primary_task_set): <p>The short name or full Amazon Resource Name (ARN) of the task set to set as the primary task set in the deployment.</p>
    /// - On success, responds with [`UpdateServicePrimaryTaskSetOutput`](crate::output::UpdateServicePrimaryTaskSetOutput) with field(s):
    ///   - [`task_set(Option<TaskSet>)`](crate::output::UpdateServicePrimaryTaskSetOutput::task_set): <p>etails about the task set.</p>
    /// - On failure, responds with [`SdkError<UpdateServicePrimaryTaskSetError>`](crate::error::UpdateServicePrimaryTaskSetError)
    pub fn update_service_primary_task_set(&self) -> fluent_builders::UpdateServicePrimaryTaskSet {
        fluent_builders::UpdateServicePrimaryTaskSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTaskSet`](crate::client::fluent_builders::UpdateTaskSet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster(impl Into<String>)`](crate::client::fluent_builders::UpdateTaskSet::cluster) / [`set_cluster(Option<String>)`](crate::client::fluent_builders::UpdateTaskSet::set_cluster): <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task set is found in.</p>
    ///   - [`service(impl Into<String>)`](crate::client::fluent_builders::UpdateTaskSet::service) / [`set_service(Option<String>)`](crate::client::fluent_builders::UpdateTaskSet::set_service): <p>The short name or full Amazon Resource Name (ARN) of the service that the task set is found in.</p>
    ///   - [`task_set(impl Into<String>)`](crate::client::fluent_builders::UpdateTaskSet::task_set) / [`set_task_set(Option<String>)`](crate::client::fluent_builders::UpdateTaskSet::set_task_set): <p>The short name or full Amazon Resource Name (ARN) of the task set to update.</p>
    ///   - [`scale(Scale)`](crate::client::fluent_builders::UpdateTaskSet::scale) / [`set_scale(Option<Scale>)`](crate::client::fluent_builders::UpdateTaskSet::set_scale): <p>A floating-point percentage of the desired number of tasks to place and keep running in the task set.</p>
    /// - On success, responds with [`UpdateTaskSetOutput`](crate::output::UpdateTaskSetOutput) with field(s):
    ///   - [`task_set(Option<TaskSet>)`](crate::output::UpdateTaskSetOutput::task_set): <p>Details about the task set.</p>
    /// - On failure, responds with [`SdkError<UpdateTaskSetError>`](crate::error::UpdateTaskSetError)
    pub fn update_task_set(&self) -> fluent_builders::UpdateTaskSet {
        fluent_builders::UpdateTaskSet::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateCapacityProvider`.
    ///
    /// <p>Creates a new capacity provider. Capacity providers are associated with an Amazon ECS cluster and are used in capacity provider strategies to facilitate cluster auto scaling.</p>
    /// <p>Only capacity providers that use an Auto Scaling group can be created. Amazon ECS tasks on Fargate use the <code>FARGATE</code> and <code>FARGATE_SPOT</code> capacity providers. These providers are available to all accounts in the Amazon Web Services Regions that Fargate supports.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCapacityProvider {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_capacity_provider_input::Builder,
    }
    impl CreateCapacityProvider {
        /// Creates a new `CreateCapacityProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCapacityProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCapacityProviderError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the capacity provider. Up to 255 characters are allowed. They include letters (both upper and lowercase letters), numbers, underscores (_), and hyphens (-). The name can't be prefixed with "<code>aws</code>", "<code>ecs</code>", or "<code>fargate</code>".</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the capacity provider. Up to 255 characters are allowed. They include letters (both upper and lowercase letters), numbers, underscores (_), and hyphens (-). The name can't be prefixed with "<code>aws</code>", "<code>ecs</code>", or "<code>fargate</code>".</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The details of the Auto Scaling group for the capacity provider.</p>
        pub fn auto_scaling_group_provider(
            mut self,
            input: crate::model::AutoScalingGroupProvider,
        ) -> Self {
            self.inner = self.inner.auto_scaling_group_provider(input);
            self
        }
        /// <p>The details of the Auto Scaling group for the capacity provider.</p>
        pub fn set_auto_scaling_group_provider(
            mut self,
            input: std::option::Option<crate::model::AutoScalingGroupProvider>,
        ) -> Self {
            self.inner = self.inner.set_auto_scaling_group_provider(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the capacity provider to categorize and organize them more conveniently. Each tag consists of a key and an optional value. You define both of them.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The metadata that you apply to the capacity provider to categorize and organize them more conveniently. Each tag consists of a key and an optional value. You define both of them.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCluster`.
    ///
    /// <p>Creates a new Amazon ECS cluster. By default, your account receives a <code>default</code> cluster when you launch your first container instance. However, you can create your own cluster with a unique name with the <code>CreateCluster</code> action.</p> <note>
    /// <p>When you call the <code>CreateCluster</code> API operation, Amazon ECS attempts to create the Amazon ECS service-linked role for your account. This is so that it can manage required resources in other Amazon Web Services services on your behalf. However, if the IAM user that makes the call doesn't have permissions to create the service-linked role, it isn't created. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using Service-Linked Roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cluster_input::Builder,
    }
    impl CreateCluster {
        /// Creates a new `CreateCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of your cluster. If you don't specify a name for your cluster, you create a cluster that's named <code>default</code>. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. </p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_name(input.into());
            self
        }
        /// <p>The name of your cluster. If you don't specify a name for your cluster, you create a cluster that's named <code>default</code>. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. </p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `settings`.
        ///
        /// To override the contents of this collection use [`set_settings`](Self::set_settings).
        ///
        /// <p>The setting to use when creating a cluster. This parameter is used to turn on CloudWatch Container Insights for a cluster. If this value is specified, it overrides the <code>containerInsights</code> value set with <code>PutAccountSetting</code> or <code>PutAccountSettingDefault</code>.</p>
        pub fn settings(mut self, input: crate::model::ClusterSetting) -> Self {
            self.inner = self.inner.settings(input);
            self
        }
        /// <p>The setting to use when creating a cluster. This parameter is used to turn on CloudWatch Container Insights for a cluster. If this value is specified, it overrides the <code>containerInsights</code> value set with <code>PutAccountSetting</code> or <code>PutAccountSettingDefault</code>.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterSetting>>,
        ) -> Self {
            self.inner = self.inner.set_settings(input);
            self
        }
        /// <p>The <code>execute</code> command configuration for the cluster.</p>
        pub fn configuration(mut self, input: crate::model::ClusterConfiguration) -> Self {
            self.inner = self.inner.configuration(input);
            self
        }
        /// <p>The <code>execute</code> command configuration for the cluster.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ClusterConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// Appends an item to `capacityProviders`.
        ///
        /// To override the contents of this collection use [`set_capacity_providers`](Self::set_capacity_providers).
        ///
        /// <p>The short name of one or more capacity providers to associate with the cluster. A capacity provider must be associated with a cluster before it can be included as part of the default capacity provider strategy of the cluster or used in a capacity provider strategy when calling the <code>CreateService</code> or <code>RunTask</code> actions.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must be created but not associated with another cluster. New Auto Scaling group capacity providers can be created with the <code>CreateCapacityProvider</code> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.</p>
        /// <p>The <code>PutClusterCapacityProviders</code> API operation is used to update the list of available capacity providers for a cluster after the cluster is created.</p>
        pub fn capacity_providers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.capacity_providers(input.into());
            self
        }
        /// <p>The short name of one or more capacity providers to associate with the cluster. A capacity provider must be associated with a cluster before it can be included as part of the default capacity provider strategy of the cluster or used in a capacity provider strategy when calling the <code>CreateService</code> or <code>RunTask</code> actions.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must be created but not associated with another cluster. New Auto Scaling group capacity providers can be created with the <code>CreateCapacityProvider</code> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.</p>
        /// <p>The <code>PutClusterCapacityProviders</code> API operation is used to update the list of available capacity providers for a cluster after the cluster is created.</p>
        pub fn set_capacity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_capacity_providers(input);
            self
        }
        /// Appends an item to `defaultCapacityProviderStrategy`.
        ///
        /// To override the contents of this collection use [`set_default_capacity_provider_strategy`](Self::set_default_capacity_provider_strategy).
        ///
        /// <p>The capacity provider strategy to set as the default for the cluster. After a default capacity provider strategy is set for a cluster, when you call the <code>RunTask</code> or <code>CreateService</code> APIs with no capacity provider strategy or launch type specified, the default capacity provider strategy for the cluster is used.</p>
        /// <p>If a default capacity provider strategy isn't defined for a cluster when it was created, it can be defined later with the <code>PutClusterCapacityProviders</code> API operation.</p>
        pub fn default_capacity_provider_strategy(
            mut self,
            input: crate::model::CapacityProviderStrategyItem,
        ) -> Self {
            self.inner = self.inner.default_capacity_provider_strategy(input);
            self
        }
        /// <p>The capacity provider strategy to set as the default for the cluster. After a default capacity provider strategy is set for a cluster, when you call the <code>RunTask</code> or <code>CreateService</code> APIs with no capacity provider strategy or launch type specified, the default capacity provider strategy for the cluster is used.</p>
        /// <p>If a default capacity provider strategy isn't defined for a cluster when it was created, it can be defined later with the <code>PutClusterCapacityProviders</code> API operation.</p>
        pub fn set_default_capacity_provider_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        ) -> Self {
            self.inner = self.inner.set_default_capacity_provider_strategy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateService`.
    ///
    /// <p>Runs and maintains your desired number of tasks from a specified task definition. If the number of tasks running in a service drops below the <code>desiredCount</code>, Amazon ECS runs another copy of the task in the specified cluster. To update an existing service, see the UpdateService action.</p>
    /// <p>In addition to maintaining the desired count of tasks in your service, you can optionally run your service behind one or more load balancers. The load balancers distribute traffic across the tasks that are associated with the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service Load Balancing</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>Tasks for services that don't use a load balancer are considered healthy if they're in the <code>RUNNING</code> state. Tasks for services that use a load balancer are considered healthy if they're in the <code>RUNNING</code> state and are reported as healthy by the load balancer.</p>
    /// <p>There are two service scheduler strategies available:</p>
    /// <ul>
    /// <li> <p> <code>REPLICA</code> - The replica scheduling strategy places and maintains your desired number of tasks across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement strategies and constraints to customize task placement decisions. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Service Scheduler Concepts</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p> </li>
    /// <li> <p> <code>DAEMON</code> - The daemon scheduling strategy deploys exactly one task on each active container instance that meets all of the task placement constraints that you specify in your cluster. The service scheduler also evaluates the task placement constraints for running tasks. It also stops tasks that don't meet the placement constraints. When using this strategy, you don't need to specify a desired number of tasks, a task placement strategy, or use Service Auto Scaling policies. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Service Scheduler Concepts</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p> </li>
    /// </ul>
    /// <p>You can optionally specify a deployment configuration for your service. The deployment is initiated by changing properties. For example, the deployment might be initiated by the task definition or by your desired count of a service. This is done with an <code>UpdateService</code> operation. The default value for a replica service for <code>minimumHealthyPercent</code> is 100%. The default value for a daemon service for <code>minimumHealthyPercent</code> is 0%.</p>
    /// <p>If a service uses the <code>ECS</code> deployment controller, the minimum healthy percent represents a lower limit on the number of tasks in a service that must remain in the <code>RUNNING</code> state during a deployment. Specifically, it represents it as a percentage of your desired number of tasks (rounded up to the nearest integer). This happens when any of your container instances are in the <code>DRAINING</code> state if the service contains tasks using the EC2 launch type. Using this parameter, you can deploy without using additional cluster capacity. For example, if you set your service to have desired number of four tasks and a minimum healthy percent of 50%, the scheduler might stop two existing tasks to free up cluster capacity before starting two new tasks. If they're in the <code>RUNNING</code> state, tasks for services that don't use a load balancer are considered healthy . If they're in the <code>RUNNING</code> state and reported as healthy by the load balancer, tasks for services that <i>do</i> use a load balancer are considered healthy . The default value for minimum healthy percent is 100%.</p>
    /// <p>If a service uses the <code>ECS</code> deployment controller, the <b>maximum percent</b> parameter represents an upper limit on the number of tasks in a service that are allowed in the <code>RUNNING</code> or <code>PENDING</code> state during a deployment. Specifically, it represents it as a percentage of the desired number of tasks (rounded down to the nearest integer). This happens when any of your container instances are in the <code>DRAINING</code> state if the service contains tasks using the EC2 launch type. Using this parameter, you can define the deployment batch size. For example, if your service has a desired number of four tasks and a maximum percent value of 200%, the scheduler may start four new tasks before stopping the four older tasks (provided that the cluster resources required to do this are available). The default value for maximum percent is 200%.</p>
    /// <p>If a service uses either the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types and tasks that use the EC2 launch type, the <b>minimum healthy percent</b> and <b>maximum percent</b> values are used only to define the lower and upper limit on the number of the tasks in the service that remain in the <code>RUNNING</code> state. This is while the container instances are in the <code>DRAINING</code> state. If the tasks in the service use the Fargate launch type, the minimum healthy percent and maximum percent values aren't used. This is the case even if they're currently visible when describing your service.</p>
    /// <p>When creating a service that uses the <code>EXTERNAL</code> deployment controller, you can specify only parameters that aren't controlled at the task set level. The only required parameter is the service name. You control your services using the <code>CreateTaskSet</code> operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>When the service scheduler launches new tasks, it determines task placement in your cluster using the following logic:</p>
    /// <ul>
    /// <li> <p>Determine which of the container instances in your cluster can support the task definition of your service. For example, they have the required CPU, memory, ports, and container instance attributes.</p> </li>
    /// <li> <p>By default, the service scheduler attempts to balance tasks across Availability Zones in this manner. This is the case even if you can choose a different placement strategy with the <code>placementStrategy</code> parameter.</p>
    /// <ul>
    /// <li> <p>Sort the valid container instances, giving priority to instances that have the fewest number of running tasks for this service in their respective Availability Zone. For example, if zone A has one running service task and zones B and C each have zero, valid container instances in either zone B or C are considered optimal for placement.</p> </li>
    /// <li> <p>Place the new service task on a valid container instance in an optimal Availability Zone based on the previous steps, favoring container instances with the fewest number of running tasks for this service.</p> </li>
    /// </ul> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateService {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_service_input::Builder,
    }
    impl CreateService {
        /// Creates a new `CreateService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateServiceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that you run your service on. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that you run your service on. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. Service names must be unique within a cluster, but you can have similarly named services in multiple clusters within a Region or across multiple Regions.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(input.into());
            self
        }
        /// <p>The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. Service names must be unique within a cluster, but you can have similarly named services in multiple clusters within a Region or across multiple Regions.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task definition to run in your service. If a <code>revision</code> isn't specified, the latest <code>ACTIVE</code> revision is used.</p>
        /// <p>A task definition must be specified if the service uses either the <code>ECS</code> or <code>CODE_DEPLOY</code> deployment controllers.</p>
        pub fn task_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_definition(input.into());
            self
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task definition to run in your service. If a <code>revision</code> isn't specified, the latest <code>ACTIVE</code> revision is used.</p>
        /// <p>A task definition must be specified if the service uses either the <code>ECS</code> or <code>CODE_DEPLOY</code> deployment controllers.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_task_definition(input);
            self
        }
        /// Appends an item to `loadBalancers`.
        ///
        /// To override the contents of this collection use [`set_load_balancers`](Self::set_load_balancers).
        ///
        /// <p>A load balancer object representing the load balancers to use with your service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service Load Balancing</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>If the service uses the rolling update (<code>ECS</code>) deployment controller and using either an Application Load Balancer or Network Load Balancer, you must specify one or more target group ARNs to attach to the service. The service-linked role is required for services that use multiple target groups. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>If the service uses the <code>CODE_DEPLOY</code> deployment controller, the service is required to use either an Application Load Balancer or Network Load Balancer. When creating an CodeDeploy deployment group, you specify two target groups (referred to as a <code>targetGroupPair</code>). During a deployment, CodeDeploy determines which task set in your service has the status <code>PRIMARY</code>, and it associates one target group with it. Then, it also associates the other target group with the replacement task set. The load balancer can also have up to two listeners: a required listener for production traffic and an optional listener that you can use to perform validation tests with Lambda functions before routing production traffic to it.</p>
        /// <p>If you use the <code>CODE_DEPLOY</code> deployment controller, these values can be changed when updating the service.</p>
        /// <p>For Application Load Balancers and Network Load Balancers, this object must contain the load balancer target group ARN, the container name, and the container port to access from the load balancer. The container name must be as it appears in a container definition. The load balancer name parameter must be omitted. When a task from this service is placed on a container instance, the container instance and port combination is registered as a target in the target group that's specified here.</p>
        /// <p>For Classic Load Balancers, this object must contain the load balancer name, the container name , and the container port to access from the load balancer. The container name must be as it appears in a container definition. The target group ARN parameter must be omitted. When a task from this service is placed on a container instance, the container instance is registered with the load balancer that's specified here.</p>
        /// <p>Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate launch type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers aren't supported. Also, when you create any target groups for these services, you must choose <code>ip</code> as the target type, not <code>instance</code>. This is because tasks that use the <code>awsvpc</code> network mode are associated with an elastic network interface, not an Amazon EC2 instance.</p>
        pub fn load_balancers(mut self, input: crate::model::LoadBalancer) -> Self {
            self.inner = self.inner.load_balancers(input);
            self
        }
        /// <p>A load balancer object representing the load balancers to use with your service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service Load Balancing</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>If the service uses the rolling update (<code>ECS</code>) deployment controller and using either an Application Load Balancer or Network Load Balancer, you must specify one or more target group ARNs to attach to the service. The service-linked role is required for services that use multiple target groups. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>If the service uses the <code>CODE_DEPLOY</code> deployment controller, the service is required to use either an Application Load Balancer or Network Load Balancer. When creating an CodeDeploy deployment group, you specify two target groups (referred to as a <code>targetGroupPair</code>). During a deployment, CodeDeploy determines which task set in your service has the status <code>PRIMARY</code>, and it associates one target group with it. Then, it also associates the other target group with the replacement task set. The load balancer can also have up to two listeners: a required listener for production traffic and an optional listener that you can use to perform validation tests with Lambda functions before routing production traffic to it.</p>
        /// <p>If you use the <code>CODE_DEPLOY</code> deployment controller, these values can be changed when updating the service.</p>
        /// <p>For Application Load Balancers and Network Load Balancers, this object must contain the load balancer target group ARN, the container name, and the container port to access from the load balancer. The container name must be as it appears in a container definition. The load balancer name parameter must be omitted. When a task from this service is placed on a container instance, the container instance and port combination is registered as a target in the target group that's specified here.</p>
        /// <p>For Classic Load Balancers, this object must contain the load balancer name, the container name , and the container port to access from the load balancer. The container name must be as it appears in a container definition. The target group ARN parameter must be omitted. When a task from this service is placed on a container instance, the container instance is registered with the load balancer that's specified here.</p>
        /// <p>Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate launch type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers aren't supported. Also, when you create any target groups for these services, you must choose <code>ip</code> as the target type, not <code>instance</code>. This is because tasks that use the <code>awsvpc</code> network mode are associated with an elastic network interface, not an Amazon EC2 instance.</p>
        pub fn set_load_balancers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
        ) -> Self {
            self.inner = self.inner.set_load_balancers(input);
            self
        }
        /// Appends an item to `serviceRegistries`.
        ///
        /// To override the contents of this collection use [`set_service_registries`](Self::set_service_registries).
        ///
        /// <p>The details of the service discovery registry to associate with this service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service discovery</a>.</p> <note>
        /// <p>Each service may be associated with one service registry. Multiple service registries for each service isn't supported.</p>
        /// </note>
        pub fn service_registries(mut self, input: crate::model::ServiceRegistry) -> Self {
            self.inner = self.inner.service_registries(input);
            self
        }
        /// <p>The details of the service discovery registry to associate with this service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service discovery</a>.</p> <note>
        /// <p>Each service may be associated with one service registry. Multiple service registries for each service isn't supported.</p>
        /// </note>
        pub fn set_service_registries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceRegistry>>,
        ) -> Self {
            self.inner = self.inner.set_service_registries(input);
            self
        }
        /// <p>The number of instantiations of the specified task definition to place and keep running on your cluster.</p>
        /// <p>This is required if <code>schedulingStrategy</code> is <code>REPLICA</code> or isn't specified. If <code>schedulingStrategy</code> is <code>DAEMON</code> then this isn't required.</p>
        pub fn desired_count(mut self, input: i32) -> Self {
            self.inner = self.inner.desired_count(input);
            self
        }
        /// <p>The number of instantiations of the specified task definition to place and keep running on your cluster.</p>
        /// <p>This is required if <code>schedulingStrategy</code> is <code>REPLICA</code> or isn't specified. If <code>schedulingStrategy</code> is <code>DAEMON</code> then this isn't required.</p>
        pub fn set_desired_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_desired_count(input);
            self
        }
        /// <p>An identifier that you provide to ensure the idempotency of the request. It must be unique and is case sensitive. Up to 32 ASCII characters are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>An identifier that you provide to ensure the idempotency of the request. It must be unique and is case sensitive. Up to 32 ASCII characters are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The infrastructure that you run your service on. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand infrastructure.</p> <note>
        /// <p>Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html">Fargate capacity providers</a> in the <i>Amazon ECS User Guide for Fargate</i>.</p>
        /// </note>
        /// <p>The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your cluster.</p>
        /// <p>The <code>EXTERNAL</code> launch type runs your tasks on your on-premises server or virtual machine (VM) capacity registered to your cluster.</p>
        /// <p>A service can use either a launch type or a capacity provider strategy. If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code> parameter must be omitted.</p>
        pub fn launch_type(mut self, input: crate::model::LaunchType) -> Self {
            self.inner = self.inner.launch_type(input);
            self
        }
        /// <p>The infrastructure that you run your service on. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand infrastructure.</p> <note>
        /// <p>Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html">Fargate capacity providers</a> in the <i>Amazon ECS User Guide for Fargate</i>.</p>
        /// </note>
        /// <p>The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your cluster.</p>
        /// <p>The <code>EXTERNAL</code> launch type runs your tasks on your on-premises server or virtual machine (VM) capacity registered to your cluster.</p>
        /// <p>A service can use either a launch type or a capacity provider strategy. If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code> parameter must be omitted.</p>
        pub fn set_launch_type(
            mut self,
            input: std::option::Option<crate::model::LaunchType>,
        ) -> Self {
            self.inner = self.inner.set_launch_type(input);
            self
        }
        /// Appends an item to `capacityProviderStrategy`.
        ///
        /// To override the contents of this collection use [`set_capacity_provider_strategy`](Self::set_capacity_provider_strategy).
        ///
        /// <p>The capacity provider strategy to use for the service.</p>
        /// <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.</p>
        /// <p>A capacity provider strategy may contain a maximum of 6 capacity providers.</p>
        pub fn capacity_provider_strategy(
            mut self,
            input: crate::model::CapacityProviderStrategyItem,
        ) -> Self {
            self.inner = self.inner.capacity_provider_strategy(input);
            self
        }
        /// <p>The capacity provider strategy to use for the service.</p>
        /// <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.</p>
        /// <p>A capacity provider strategy may contain a maximum of 6 capacity providers.</p>
        pub fn set_capacity_provider_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        ) -> Self {
            self.inner = self.inner.set_capacity_provider_strategy(input);
            self
        }
        /// <p>The platform version that your tasks in the service are running on. A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the <code>LATEST</code> platform version is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate platform versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_version(input.into());
            self
        }
        /// <p>The platform version that your tasks in the service are running on. A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the <code>LATEST</code> platform version is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate platform versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_platform_version(input);
            self
        }
        /// <p>The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is only permitted if you are using a load balancer with your service and your task definition doesn't use the <code>awsvpc</code> network mode. If you specify the <code>role</code> parameter, you must also specify a load balancer object with the <code>loadBalancers</code> parameter.</p> <important>
        /// <p>If your account has already created the Amazon ECS service-linked role, that role is used for your service unless you specify a role here. The service-linked role is required if your task definition uses the <code>awsvpc</code> network mode or if the service is configured to use service discovery, an external deployment controller, multiple target groups, or Elastic Inference accelerators in which case you don't specify a role here. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// </important>
        /// <p>If your specified role has a path other than <code>/</code>, then you must either specify the full role ARN (this is recommended) or prefix the role name with the path. For example, if a role with the name <code>bar</code> has a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as the role name. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">Friendly names and paths</a> in the <i>IAM User Guide</i>.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(input.into());
            self
        }
        /// <p>The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is only permitted if you are using a load balancer with your service and your task definition doesn't use the <code>awsvpc</code> network mode. If you specify the <code>role</code> parameter, you must also specify a load balancer object with the <code>loadBalancers</code> parameter.</p> <important>
        /// <p>If your account has already created the Amazon ECS service-linked role, that role is used for your service unless you specify a role here. The service-linked role is required if your task definition uses the <code>awsvpc</code> network mode or if the service is configured to use service discovery, an external deployment controller, multiple target groups, or Elastic Inference accelerators in which case you don't specify a role here. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using service-linked roles for Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// </important>
        /// <p>If your specified role has a path other than <code>/</code>, then you must either specify the full role ARN (this is recommended) or prefix the role name with the path. For example, if a role with the name <code>bar</code> has a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as the role name. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">Friendly names and paths</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.</p>
        pub fn deployment_configuration(
            mut self,
            input: crate::model::DeploymentConfiguration,
        ) -> Self {
            self.inner = self.inner.deployment_configuration(input);
            self
        }
        /// <p>Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.</p>
        pub fn set_deployment_configuration(
            mut self,
            input: std::option::Option<crate::model::DeploymentConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_deployment_configuration(input);
            self
        }
        /// Appends an item to `placementConstraints`.
        ///
        /// To override the contents of this collection use [`set_placement_constraints`](Self::set_placement_constraints).
        ///
        /// <p>An array of placement constraint objects to use for tasks in your service. You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.</p>
        pub fn placement_constraints(mut self, input: crate::model::PlacementConstraint) -> Self {
            self.inner = self.inner.placement_constraints(input);
            self
        }
        /// <p>An array of placement constraint objects to use for tasks in your service. You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.</p>
        pub fn set_placement_constraints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementConstraint>>,
        ) -> Self {
            self.inner = self.inner.set_placement_constraints(input);
            self
        }
        /// Appends an item to `placementStrategy`.
        ///
        /// To override the contents of this collection use [`set_placement_strategy`](Self::set_placement_strategy).
        ///
        /// <p>The placement strategy objects to use for tasks in your service. You can specify a maximum of 5 strategy rules for each service.</p>
        pub fn placement_strategy(mut self, input: crate::model::PlacementStrategy) -> Self {
            self.inner = self.inner.placement_strategy(input);
            self
        }
        /// <p>The placement strategy objects to use for tasks in your service. You can specify a maximum of 5 strategy rules for each service.</p>
        pub fn set_placement_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementStrategy>>,
        ) -> Self {
            self.inner = self.inner.set_placement_strategy(input);
            self
        }
        /// <p>The network configuration for the service. This parameter is required for task definitions that use the <code>awsvpc</code> network mode to receive their own elastic network interface, and it isn't supported for other network modes. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn network_configuration(mut self, input: crate::model::NetworkConfiguration) -> Self {
            self.inner = self.inner.network_configuration(input);
            self
        }
        /// <p>The network configuration for the service. This parameter is required for task definitions that use the <code>awsvpc</code> network mode to receive their own elastic network interface, and it isn't supported for other network modes. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_network_configuration(input);
            self
        }
        /// <p>The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started. This is only used when your service is configured to use a load balancer. If your service has a load balancer defined and you don't specify a health check grace period value, the default value of <code>0</code> is used.</p>
        /// <p>If you do not use an Elastic Load Balancing, we recomend that you use the <code>startPeriod</code> in the task definition healtch check parameters. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_HealthCheck.html">Health check</a>.</p>
        /// <p>If your service's tasks take a while to start and respond to Elastic Load Balancing health checks, you can specify a health check grace period of up to 2,147,483,647 seconds (about 69 years). During that time, the Amazon ECS service scheduler ignores health check status. This grace period can prevent the service scheduler from marking tasks as unhealthy and stopping them before they have time to come up.</p>
        pub fn health_check_grace_period_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.health_check_grace_period_seconds(input);
            self
        }
        /// <p>The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started. This is only used when your service is configured to use a load balancer. If your service has a load balancer defined and you don't specify a health check grace period value, the default value of <code>0</code> is used.</p>
        /// <p>If you do not use an Elastic Load Balancing, we recomend that you use the <code>startPeriod</code> in the task definition healtch check parameters. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_HealthCheck.html">Health check</a>.</p>
        /// <p>If your service's tasks take a while to start and respond to Elastic Load Balancing health checks, you can specify a health check grace period of up to 2,147,483,647 seconds (about 69 years). During that time, the Amazon ECS service scheduler ignores health check status. This grace period can prevent the service scheduler from marking tasks as unhealthy and stopping them before they have time to come up.</p>
        pub fn set_health_check_grace_period_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_health_check_grace_period_seconds(input);
            self
        }
        /// <p>The scheduling strategy to use for the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
        /// <p>There are two service scheduler strategies available:</p>
        /// <ul>
        /// <li> <p> <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement strategies and constraints to customize task placement decisions. This scheduler strategy is required if the service uses the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types.</p> </li>
        /// <li> <p> <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container instance that meets all of the task placement constraints that you specify in your cluster. The service scheduler also evaluates the task placement constraints for running tasks and will stop tasks that don't meet the placement constraints. When you're using this strategy, you don't need to specify a desired number of tasks, a task placement strategy, or use Service Auto Scaling policies.</p> <note>
        /// <p>Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types don't support the <code>DAEMON</code> scheduling strategy.</p>
        /// </note> </li>
        /// </ul>
        pub fn scheduling_strategy(mut self, input: crate::model::SchedulingStrategy) -> Self {
            self.inner = self.inner.scheduling_strategy(input);
            self
        }
        /// <p>The scheduling strategy to use for the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
        /// <p>There are two service scheduler strategies available:</p>
        /// <ul>
        /// <li> <p> <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement strategies and constraints to customize task placement decisions. This scheduler strategy is required if the service uses the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types.</p> </li>
        /// <li> <p> <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container instance that meets all of the task placement constraints that you specify in your cluster. The service scheduler also evaluates the task placement constraints for running tasks and will stop tasks that don't meet the placement constraints. When you're using this strategy, you don't need to specify a desired number of tasks, a task placement strategy, or use Service Auto Scaling policies.</p> <note>
        /// <p>Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types don't support the <code>DAEMON</code> scheduling strategy.</p>
        /// </note> </li>
        /// </ul>
        pub fn set_scheduling_strategy(
            mut self,
            input: std::option::Option<crate::model::SchedulingStrategy>,
        ) -> Self {
            self.inner = self.inner.set_scheduling_strategy(input);
            self
        }
        /// <p>The deployment controller to use for the service. If no deployment controller is specified, the default value of <code>ECS</code> is used.</p>
        pub fn deployment_controller(mut self, input: crate::model::DeploymentController) -> Self {
            self.inner = self.inner.deployment_controller(input);
            self
        }
        /// <p>The deployment controller to use for the service. If no deployment controller is specified, the default value of <code>ECS</code> is used.</p>
        pub fn set_deployment_controller(
            mut self,
            input: std::option::Option<crate::model::DeploymentController>,
        ) -> Self {
            self.inner = self.inner.set_deployment_controller(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies whether to turn on Amazon ECS managed tags for the tasks within the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn enable_ecs_managed_tags(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_ecs_managed_tags(input);
            self
        }
        /// <p>Specifies whether to turn on Amazon ECS managed tags for the tasks within the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_enable_ecs_managed_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_ecs_managed_tags(input);
            self
        }
        /// <p>Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the <code>TagResource</code> API action.</p>
        pub fn propagate_tags(mut self, input: crate::model::PropagateTags) -> Self {
            self.inner = self.inner.propagate_tags(input);
            self
        }
        /// <p>Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the <code>TagResource</code> API action.</p>
        pub fn set_propagate_tags(
            mut self,
            input: std::option::Option<crate::model::PropagateTags>,
        ) -> Self {
            self.inner = self.inner.set_propagate_tags(input);
            self
        }
        /// <p>Determines whether the execute command functionality is enabled for the service. If <code>true</code>, this enables execute command functionality on all containers in the service tasks.</p>
        pub fn enable_execute_command(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_execute_command(input);
            self
        }
        /// <p>Determines whether the execute command functionality is enabled for the service. If <code>true</code>, this enables execute command functionality on all containers in the service tasks.</p>
        pub fn set_enable_execute_command(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_execute_command(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTaskSet`.
    ///
    /// <p>Create a task set in the specified cluster and service. This is used when a service uses the <code>EXTERNAL</code> deployment controller type. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTaskSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_task_set_input::Builder,
    }
    impl CreateTaskSet {
        /// Creates a new `CreateTaskSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTaskSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTaskSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service to create the task set in.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service to create the task set in.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service(input);
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the task set in.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the task set in.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>An optional non-unique tag that identifies this task set in external systems. If the task set is associated with a service discovery registry, the tasks in this task set will have the <code>ECS_TASK_SET_EXTERNAL_ID</code> Cloud Map attribute set to the provided value.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_id(input.into());
            self
        }
        /// <p>An optional non-unique tag that identifies this task set in external systems. If the task set is associated with a service discovery registry, the tasks in this task set will have the <code>ECS_TASK_SET_EXTERNAL_ID</code> Cloud Map attribute set to the provided value.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_external_id(input);
            self
        }
        /// <p>The task definition for the tasks in the task set to use.</p>
        pub fn task_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_definition(input.into());
            self
        }
        /// <p>The task definition for the tasks in the task set to use.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_task_definition(input);
            self
        }
        /// <p>An object representing the network configuration for a task set.</p>
        pub fn network_configuration(mut self, input: crate::model::NetworkConfiguration) -> Self {
            self.inner = self.inner.network_configuration(input);
            self
        }
        /// <p>An object representing the network configuration for a task set.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_network_configuration(input);
            self
        }
        /// Appends an item to `loadBalancers`.
        ///
        /// To override the contents of this collection use [`set_load_balancers`](Self::set_load_balancers).
        ///
        /// <p>A load balancer object representing the load balancer to use with the task set. The supported load balancer types are either an Application Load Balancer or a Network Load Balancer.</p>
        pub fn load_balancers(mut self, input: crate::model::LoadBalancer) -> Self {
            self.inner = self.inner.load_balancers(input);
            self
        }
        /// <p>A load balancer object representing the load balancer to use with the task set. The supported load balancer types are either an Application Load Balancer or a Network Load Balancer.</p>
        pub fn set_load_balancers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
        ) -> Self {
            self.inner = self.inner.set_load_balancers(input);
            self
        }
        /// Appends an item to `serviceRegistries`.
        ///
        /// To override the contents of this collection use [`set_service_registries`](Self::set_service_registries).
        ///
        /// <p>The details of the service discovery registries to assign to this task set. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service Discovery</a>.</p>
        pub fn service_registries(mut self, input: crate::model::ServiceRegistry) -> Self {
            self.inner = self.inner.service_registries(input);
            self
        }
        /// <p>The details of the service discovery registries to assign to this task set. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service Discovery</a>.</p>
        pub fn set_service_registries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceRegistry>>,
        ) -> Self {
            self.inner = self.inner.set_service_registries(input);
            self
        }
        /// <p>The launch type that new tasks in the task set uses. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code> parameter must be omitted.</p>
        pub fn launch_type(mut self, input: crate::model::LaunchType) -> Self {
            self.inner = self.inner.launch_type(input);
            self
        }
        /// <p>The launch type that new tasks in the task set uses. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code> parameter must be omitted.</p>
        pub fn set_launch_type(
            mut self,
            input: std::option::Option<crate::model::LaunchType>,
        ) -> Self {
            self.inner = self.inner.set_launch_type(input);
            self
        }
        /// Appends an item to `capacityProviderStrategy`.
        ///
        /// To override the contents of this collection use [`set_capacity_provider_strategy`](Self::set_capacity_provider_strategy).
        ///
        /// <p>The capacity provider strategy to use for the task set.</p>
        /// <p>A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The <code>PutClusterCapacityProviders</code> API is used to associate a capacity provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status can be used.</p>
        /// <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the <code>CreateCapacityProvider</code> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.</p>
        /// <p>The <code>PutClusterCapacityProviders</code> API operation is used to update the list of available capacity providers for a cluster after the cluster is created.</p>
        pub fn capacity_provider_strategy(
            mut self,
            input: crate::model::CapacityProviderStrategyItem,
        ) -> Self {
            self.inner = self.inner.capacity_provider_strategy(input);
            self
        }
        /// <p>The capacity provider strategy to use for the task set.</p>
        /// <p>A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The <code>PutClusterCapacityProviders</code> API is used to associate a capacity provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status can be used.</p>
        /// <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the <code>CreateCapacityProvider</code> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.</p>
        /// <p>The <code>PutClusterCapacityProviders</code> API operation is used to update the list of available capacity providers for a cluster after the cluster is created.</p>
        pub fn set_capacity_provider_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        ) -> Self {
            self.inner = self.inner.set_capacity_provider_strategy(input);
            self
        }
        /// <p>The platform version that the tasks in the task set uses. A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the <code>LATEST</code> platform version is used.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_version(input.into());
            self
        }
        /// <p>The platform version that the tasks in the task set uses. A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the <code>LATEST</code> platform version is used.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_platform_version(input);
            self
        }
        /// <p>A floating-point percentage of the desired number of tasks to place and keep running in the task set.</p>
        pub fn scale(mut self, input: crate::model::Scale) -> Self {
            self.inner = self.inner.scale(input);
            self
        }
        /// <p>A floating-point percentage of the desired number of tasks to place and keep running in the task set.</p>
        pub fn set_scale(mut self, input: std::option::Option<crate::model::Scale>) -> Self {
            self.inner = self.inner.set_scale(input);
            self
        }
        /// <p>The identifier that you provide to ensure the idempotency of the request. It's case sensitive and must be unique. It can be up to 32 ASCII characters are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The identifier that you provide to ensure the idempotency of the request. It's case sensitive and must be unique. It can be up to 32 ASCII characters are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the task set to help you categorize and organize them. Each tag consists of a key and an optional value. You define both. When a service is deleted, the tags are deleted.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The metadata that you apply to the task set to help you categorize and organize them. Each tag consists of a key and an optional value. You define both. When a service is deleted, the tags are deleted.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccountSetting`.
    ///
    /// <p>Disables an account setting for a specified IAM user, IAM role, or the root user for an account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAccountSetting {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_account_setting_input::Builder,
    }
    impl DeleteAccountSetting {
        /// Creates a new `DeleteAccountSetting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccountSettingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccountSettingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource name to disable the account setting for. If <code>serviceLongArnFormat</code> is specified, the ARN for your Amazon ECS services is affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS container instances is affected. If <code>awsvpcTrunking</code> is specified, the ENI limit for your Amazon ECS container instances is affected.</p>
        pub fn name(mut self, input: crate::model::SettingName) -> Self {
            self.inner = self.inner.name(input);
            self
        }
        /// <p>The resource name to disable the account setting for. If <code>serviceLongArnFormat</code> is specified, the ARN for your Amazon ECS services is affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS container instances is affected. If <code>awsvpcTrunking</code> is specified, the ENI limit for your Amazon ECS container instances is affected.</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::SettingName>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the principal. It can be an IAM user, IAM role, or the root user. If you specify the root user, it disables the account setting for all IAM users, IAM roles, and the root user of the account unless an IAM user or role explicitly overrides these settings. If this field is omitted, the setting is changed only for the authenticated user.</p>
        pub fn principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the principal. It can be an IAM user, IAM role, or the root user. If you specify the root user, it disables the account setting for all IAM users, IAM roles, and the root user of the account unless an IAM user or role explicitly overrides these settings. If this field is omitted, the setting is changed only for the authenticated user.</p>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_principal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAttributes`.
    ///
    /// <p>Deletes one or more custom attributes from an Amazon ECS resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_attributes_input::Builder,
    }
    impl DeleteAttributes {
        /// Creates a new `DeleteAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that contains the resource to delete attributes. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that contains the resource to delete attributes. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes to delete from your resource. You can specify up to 10 attributes for each request. For custom attributes, specify the attribute name and target ID, but don't specify the value. If you specify the target ID using the short form, you must also specify the target type.</p>
        pub fn attributes(mut self, input: crate::model::Attribute) -> Self {
            self.inner = self.inner.attributes(input);
            self
        }
        /// <p>The attributes to delete from your resource. You can specify up to 10 attributes for each request. For custom attributes, specify the attribute name and target ID, but don't specify the value. If you specify the target ID using the short form, you must also specify the target type.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCapacityProvider`.
    ///
    /// <p>Deletes the specified capacity provider.</p> <note>
    /// <p>The <code>FARGATE</code> and <code>FARGATE_SPOT</code> capacity providers are reserved and can't be deleted. You can disassociate them from a cluster using either the <code>PutClusterCapacityProviders</code> API or by deleting the cluster.</p>
    /// </note>
    /// <p>Prior to a capacity provider being deleted, the capacity provider must be removed from the capacity provider strategy from all services. The <code>UpdateService</code> API can be used to remove a capacity provider from a service's capacity provider strategy. When updating a service, the <code>forceNewDeployment</code> option can be used to ensure that any tasks using the Amazon EC2 instance capacity provided by the capacity provider are transitioned to use the capacity from the remaining capacity providers. Only capacity providers that aren't associated with a cluster can be deleted. To remove a capacity provider from a cluster, you can either use <code>PutClusterCapacityProviders</code> or delete the cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCapacityProvider {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_capacity_provider_input::Builder,
    }
    impl DeleteCapacityProvider {
        /// Creates a new `DeleteCapacityProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCapacityProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCapacityProviderError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the capacity provider to delete.</p>
        pub fn capacity_provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.capacity_provider(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the capacity provider to delete.</p>
        pub fn set_capacity_provider(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_capacity_provider(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCluster`.
    ///
    /// <p>Deletes the specified cluster. The cluster transitions to the <code>INACTIVE</code> state. Clusters with an <code>INACTIVE</code> status might remain discoverable in your account for a period of time. However, this behavior is subject to change in the future. We don't recommend that you rely on <code>INACTIVE</code> clusters persisting.</p>
    /// <p>You must deregister all container instances from this cluster before you may delete it. You can list the container instances in a cluster with <code>ListContainerInstances</code> and deregister them with <code>DeregisterContainerInstance</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_cluster_input::Builder,
    }
    impl DeleteCluster {
        /// Creates a new `DeleteCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to delete.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to delete.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteService`.
    ///
    /// <p>Deletes a specified service within a cluster. You can delete a service if you have no running tasks in it and the desired task count is zero. If the service is actively maintaining tasks, you can't delete it, and you must update the service to a desired task count of zero. For more information, see <code>UpdateService</code>.</p> <note>
    /// <p>When you delete a service, if there are still running tasks that require cleanup, the service status moves from <code>ACTIVE</code> to <code>DRAINING</code>, and the service is no longer visible in the console or in the <code>ListServices</code> API operation. After all tasks have transitioned to either <code>STOPPING</code> or <code>STOPPED</code> status, the service status moves from <code>DRAINING</code> to <code>INACTIVE</code>. Services in the <code>DRAINING</code> or <code>INACTIVE</code> status can still be viewed with the <code>DescribeServices</code> API operation. However, in the future, <code>INACTIVE</code> services may be cleaned up and purged from Amazon ECS record keeping, and <code>DescribeServices</code> calls on those services return a <code>ServiceNotFoundException</code> error.</p>
    /// </note> <important>
    /// <p>If you attempt to create a new service with the same name as an existing service in either <code>ACTIVE</code> or <code>DRAINING</code> status, you receive an error.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteService {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_service_input::Builder,
    }
    impl DeleteService {
        /// Creates a new `DeleteService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteServiceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to delete. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to delete. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>The name of the service to delete.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service(input.into());
            self
        }
        /// <p>The name of the service to delete.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service(input);
            self
        }
        /// <p>If <code>true</code>, allows you to delete a service even if it wasn't scaled down to zero tasks. It's only necessary to use this if the service uses the <code>REPLICA</code> scheduling strategy.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>If <code>true</code>, allows you to delete a service even if it wasn't scaled down to zero tasks. It's only necessary to use this if the service uses the <code>REPLICA</code> scheduling strategy.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTaskSet`.
    ///
    /// <p>Deletes a specified task set within a service. This is used when a service uses the <code>EXTERNAL</code> deployment controller type. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTaskSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_task_set_input::Builder,
    }
    impl DeleteTaskSet {
        /// Creates a new `DeleteTaskSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTaskSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTaskSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task set found in to delete.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task set found in to delete.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service that hosts the task set to delete.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service that hosts the task set to delete.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service(input);
            self
        }
        /// <p>The task set ID or full Amazon Resource Name (ARN) of the task set to delete.</p>
        pub fn task_set(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_set(input.into());
            self
        }
        /// <p>The task set ID or full Amazon Resource Name (ARN) of the task set to delete.</p>
        pub fn set_task_set(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_set(input);
            self
        }
        /// <p>If <code>true</code>, you can delete a task set even if it hasn't been scaled down to zero.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>If <code>true</code>, you can delete a task set even if it hasn't been scaled down to zero.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterContainerInstance`.
    ///
    /// <p>Deregisters an Amazon ECS container instance from the specified cluster. This instance is no longer available to run tasks.</p>
    /// <p>If you intend to use the container instance for some other purpose after deregistration, we recommend that you stop all of the tasks running on the container instance before deregistration. That prevents any orphaned tasks from consuming resources.</p>
    /// <p>Deregistering a container instance removes the instance from a cluster, but it doesn't terminate the EC2 instance. If you are finished using the instance, be sure to terminate it in the Amazon EC2 console to stop billing.</p> <note>
    /// <p>If you terminate a running container instance, Amazon ECS automatically deregisters the instance from your cluster (stopped container instances or instances with disconnected agents aren't automatically deregistered when terminated).</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterContainerInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deregister_container_instance_input::Builder,
    }
    impl DeregisterContainerInstance {
        /// Creates a new `DeregisterContainerInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterContainerInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterContainerInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instance to deregister. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instance to deregister. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>The container instance ID or full ARN of the container instance to deregister. The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the container instance, the Amazon Web Services account ID of the container instance owner, the <code>container-instance</code> namespace, and then the container instance ID. For example, <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.</p>
        pub fn container_instance(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_instance(input.into());
            self
        }
        /// <p>The container instance ID or full ARN of the container instance to deregister. The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the container instance, the Amazon Web Services account ID of the container instance owner, the <code>container-instance</code> namespace, and then the container instance ID. For example, <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.</p>
        pub fn set_container_instance(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_instance(input);
            self
        }
        /// <p>Forces the container instance to be deregistered. If you have tasks running on the container instance when you deregister it with the <code>force</code> option, these tasks remain running until you terminate the instance or the tasks stop through some other means, but they're orphaned (no longer monitored or accounted for by Amazon ECS). If an orphaned task on your container instance is part of an Amazon ECS service, then the service scheduler starts another copy of that task, on a different container instance if possible. </p>
        /// <p>Any containers in orphaned service tasks that are registered with a Classic Load Balancer or an Application Load Balancer target group are deregistered. They begin connection draining according to the settings on the load balancer or target group.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>Forces the container instance to be deregistered. If you have tasks running on the container instance when you deregister it with the <code>force</code> option, these tasks remain running until you terminate the instance or the tasks stop through some other means, but they're orphaned (no longer monitored or accounted for by Amazon ECS). If an orphaned task on your container instance is part of an Amazon ECS service, then the service scheduler starts another copy of that task, on a different container instance if possible. </p>
        /// <p>Any containers in orphaned service tasks that are registered with a Classic Load Balancer or an Application Load Balancer target group are deregistered. They begin connection draining according to the settings on the load balancer or target group.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterTaskDefinition`.
    ///
    /// <p>Deregisters the specified task definition by family and revision. Upon deregistration, the task definition is marked as <code>INACTIVE</code>. Existing tasks and services that reference an <code>INACTIVE</code> task definition continue to run without disruption. Existing services that reference an <code>INACTIVE</code> task definition can still scale up or down by modifying the service's desired count.</p>
    /// <p>You can't use an <code>INACTIVE</code> task definition to run new tasks or create new services, and you can't update an existing service to reference an <code>INACTIVE</code> task definition. However, there may be up to a 10-minute window following deregistration where these restrictions have not yet taken effect.</p> <note>
    /// <p>At this time, <code>INACTIVE</code> task definitions remain discoverable in your account indefinitely. However, this behavior is subject to change in the future. We don't recommend that you rely on <code>INACTIVE</code> task definitions persisting beyond the lifecycle of any associated tasks and services.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterTaskDefinition {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deregister_task_definition_input::Builder,
    }
    impl DeregisterTaskDefinition {
        /// Creates a new `DeregisterTaskDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterTaskDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterTaskDefinitionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full Amazon Resource Name (ARN) of the task definition to deregister. You must specify a <code>revision</code>.</p>
        pub fn task_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_definition(input.into());
            self
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full Amazon Resource Name (ARN) of the task definition to deregister. You must specify a <code>revision</code>.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_task_definition(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCapacityProviders`.
    ///
    /// <p>Describes one or more of your capacity providers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCapacityProviders {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_capacity_providers_input::Builder,
    }
    impl DescribeCapacityProviders {
        /// Creates a new `DescribeCapacityProviders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCapacityProvidersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCapacityProvidersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `capacityProviders`.
        ///
        /// To override the contents of this collection use [`set_capacity_providers`](Self::set_capacity_providers).
        ///
        /// <p>The short name or full Amazon Resource Name (ARN) of one or more capacity providers. Up to <code>100</code> capacity providers can be described in an action.</p>
        pub fn capacity_providers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.capacity_providers(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of one or more capacity providers. Up to <code>100</code> capacity providers can be described in an action.</p>
        pub fn set_capacity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_capacity_providers(input);
            self
        }
        /// Appends an item to `include`.
        ///
        /// To override the contents of this collection use [`set_include`](Self::set_include).
        ///
        /// <p>Specifies whether or not you want to see the resource tags for the capacity provider. If <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags aren't included in the response.</p>
        pub fn include(mut self, input: crate::model::CapacityProviderField) -> Self {
            self.inner = self.inner.include(input);
            self
        }
        /// <p>Specifies whether or not you want to see the resource tags for the capacity provider. If <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags aren't included in the response.</p>
        pub fn set_include(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderField>>,
        ) -> Self {
            self.inner = self.inner.set_include(input);
            self
        }
        /// <p>The maximum number of account setting results returned by <code>DescribeCapacityProviders</code> in paginated output. When this parameter is used, <code>DescribeCapacityProviders</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeCapacityProviders</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 10. If this parameter is not used, then <code>DescribeCapacityProviders</code> returns up to 10 results and a <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of account setting results returned by <code>DescribeCapacityProviders</code> in paginated output. When this parameter is used, <code>DescribeCapacityProviders</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeCapacityProviders</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 10. If this parameter is not used, then <code>DescribeCapacityProviders</code> returns up to 10 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeCapacityProviders</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeCapacityProviders</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusters`.
    ///
    /// <p>Describes one or more of your clusters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeClusters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_clusters_input::Builder,
    }
    impl DescribeClusters {
        /// Creates a new `DescribeClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClustersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `clusters`.
        ///
        /// To override the contents of this collection use [`set_clusters`](Self::set_clusters).
        ///
        /// <p>A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn clusters(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.clusters(input.into());
            self
        }
        /// <p>A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_clusters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_clusters(input);
            self
        }
        /// Appends an item to `include`.
        ///
        /// To override the contents of this collection use [`set_include`](Self::set_include).
        ///
        /// <p>Determines whether to include additional information about the clusters in the response. If this field is omitted, this information isn't included.</p>
        /// <p>If <code>ATTACHMENTS</code> is specified, the attachments for the container instances or tasks within the cluster are included.</p>
        /// <p>If <code>SETTINGS</code> is specified, the settings for the cluster are included.</p>
        /// <p>If <code>CONFIGURATIONS</code> is specified, the configuration for the cluster is included.</p>
        /// <p>If <code>STATISTICS</code> is specified, the task and service count is included, separated by launch type.</p>
        /// <p>If <code>TAGS</code> is specified, the metadata tags associated with the cluster are included.</p>
        pub fn include(mut self, input: crate::model::ClusterField) -> Self {
            self.inner = self.inner.include(input);
            self
        }
        /// <p>Determines whether to include additional information about the clusters in the response. If this field is omitted, this information isn't included.</p>
        /// <p>If <code>ATTACHMENTS</code> is specified, the attachments for the container instances or tasks within the cluster are included.</p>
        /// <p>If <code>SETTINGS</code> is specified, the settings for the cluster are included.</p>
        /// <p>If <code>CONFIGURATIONS</code> is specified, the configuration for the cluster is included.</p>
        /// <p>If <code>STATISTICS</code> is specified, the task and service count is included, separated by launch type.</p>
        /// <p>If <code>TAGS</code> is specified, the metadata tags associated with the cluster are included.</p>
        pub fn set_include(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterField>>,
        ) -> Self {
            self.inner = self.inner.set_include(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeContainerInstances`.
    ///
    /// <p>Describes one or more container instances. Returns metadata about each container instance requested.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeContainerInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_container_instances_input::Builder,
    }
    impl DescribeContainerInstances {
        /// Creates a new `DescribeContainerInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeContainerInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeContainerInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the container instance or container instances you are describing were launched in any cluster other than the default cluster.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the container instance or container instances you are describing were launched in any cluster other than the default cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// Appends an item to `containerInstances`.
        ///
        /// To override the contents of this collection use [`set_container_instances`](Self::set_container_instances).
        ///
        /// <p>A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.</p>
        pub fn container_instances(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_instances(input.into());
            self
        }
        /// <p>A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.</p>
        pub fn set_container_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_container_instances(input);
            self
        }
        /// Appends an item to `include`.
        ///
        /// To override the contents of this collection use [`set_include`](Self::set_include).
        ///
        /// <p>Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is specified, the tags are included in the response. If <code>CONTAINER_INSTANCE_HEALTH</code> is specified, the container instance health is included in the response. If this field is omitted, tags and container instance health status aren't included in the response.</p>
        pub fn include(mut self, input: crate::model::ContainerInstanceField) -> Self {
            self.inner = self.inner.include(input);
            self
        }
        /// <p>Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is specified, the tags are included in the response. If <code>CONTAINER_INSTANCE_HEALTH</code> is specified, the container instance health is included in the response. If this field is omitted, tags and container instance health status aren't included in the response.</p>
        pub fn set_include(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContainerInstanceField>>,
        ) -> Self {
            self.inner = self.inner.set_include(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeServices`.
    ///
    /// <p>Describes the specified services running in your cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeServices {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_services_input::Builder,
    }
    impl DescribeServices {
        /// Creates a new `DescribeServices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeServicesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeServicesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN)the cluster that hosts the service to describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the service or services you are describing were launched in any cluster other than the default cluster.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN)the cluster that hosts the service to describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the service or services you are describing were launched in any cluster other than the default cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// <p>A list of services to describe. You may specify up to 10 services to describe in a single operation.</p>
        pub fn services(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.services(input.into());
            self
        }
        /// <p>A list of services to describe. You may specify up to 10 services to describe in a single operation.</p>
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_services(input);
            self
        }
        /// Appends an item to `include`.
        ///
        /// To override the contents of this collection use [`set_include`](Self::set_include).
        ///
        /// <p>Determines whether you want to see the resource tags for the service. If <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags aren't included in the response.</p>
        pub fn include(mut self, input: crate::model::ServiceField) -> Self {
            self.inner = self.inner.include(input);
            self
        }
        /// <p>Determines whether you want to see the resource tags for the service. If <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags aren't included in the response.</p>
        pub fn set_include(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceField>>,
        ) -> Self {
            self.inner = self.inner.set_include(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTaskDefinition`.
    ///
    /// <p>Describes a task definition. You can specify a <code>family</code> and <code>revision</code> to find information about a specific task definition, or you can simply specify the family to find the latest <code>ACTIVE</code> revision in that family.</p> <note>
    /// <p>You can only describe <code>INACTIVE</code> task definitions while an active task or service references them.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTaskDefinition {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_task_definition_input::Builder,
    }
    impl DescribeTaskDefinition {
        /// Creates a new `DescribeTaskDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTaskDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTaskDefinitionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>family</code> for the latest <code>ACTIVE</code> revision, <code>family</code> and <code>revision</code> (<code>family:revision</code>) for a specific revision in the family, or full Amazon Resource Name (ARN) of the task definition to describe.</p>
        pub fn task_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_definition(input.into());
            self
        }
        /// <p>The <code>family</code> for the latest <code>ACTIVE</code> revision, <code>family</code> and <code>revision</code> (<code>family:revision</code>) for a specific revision in the family, or full Amazon Resource Name (ARN) of the task definition to describe.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_task_definition(input);
            self
        }
        /// Appends an item to `include`.
        ///
        /// To override the contents of this collection use [`set_include`](Self::set_include).
        ///
        /// <p>Determines whether to see the resource tags for the task definition. If <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags aren't included in the response.</p>
        pub fn include(mut self, input: crate::model::TaskDefinitionField) -> Self {
            self.inner = self.inner.include(input);
            self
        }
        /// <p>Determines whether to see the resource tags for the task definition. If <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags aren't included in the response.</p>
        pub fn set_include(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TaskDefinitionField>>,
        ) -> Self {
            self.inner = self.inner.set_include(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTasks`.
    ///
    /// <p>Describes a specified task or tasks.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTasks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_tasks_input::Builder,
    }
    impl DescribeTasks {
        /// Creates a new `DescribeTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTasksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task or tasks to describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the task or tasks you are describing were launched in any cluster other than the default cluster.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task or tasks to describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the task or tasks you are describing were launched in any cluster other than the default cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p>A list of up to 100 task IDs or full ARN entries.</p>
        pub fn tasks(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tasks(input.into());
            self
        }
        /// <p>A list of up to 100 task IDs or full ARN entries.</p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tasks(input);
            self
        }
        /// Appends an item to `include`.
        ///
        /// To override the contents of this collection use [`set_include`](Self::set_include).
        ///
        /// <p>Specifies whether you want to see the resource tags for the task. If <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags aren't included in the response.</p>
        pub fn include(mut self, input: crate::model::TaskField) -> Self {
            self.inner = self.inner.include(input);
            self
        }
        /// <p>Specifies whether you want to see the resource tags for the task. If <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags aren't included in the response.</p>
        pub fn set_include(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TaskField>>,
        ) -> Self {
            self.inner = self.inner.set_include(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTaskSets`.
    ///
    /// <p>Describes the task sets in the specified cluster and service. This is used when a service uses the <code>EXTERNAL</code> deployment controller type. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTaskSets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_task_sets_input::Builder,
    }
    impl DescribeTaskSets {
        /// Creates a new `DescribeTaskSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTaskSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTaskSetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task sets exist in.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task sets exist in.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service that the task sets exist in.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service that the task sets exist in.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service(input);
            self
        }
        /// Appends an item to `taskSets`.
        ///
        /// To override the contents of this collection use [`set_task_sets`](Self::set_task_sets).
        ///
        /// <p>The ID or full Amazon Resource Name (ARN) of task sets to describe.</p>
        pub fn task_sets(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_sets(input.into());
            self
        }
        /// <p>The ID or full Amazon Resource Name (ARN) of task sets to describe.</p>
        pub fn set_task_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_task_sets(input);
            self
        }
        /// Appends an item to `include`.
        ///
        /// To override the contents of this collection use [`set_include`](Self::set_include).
        ///
        /// <p>Specifies whether to see the resource tags for the task set. If <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags aren't included in the response.</p>
        pub fn include(mut self, input: crate::model::TaskSetField) -> Self {
            self.inner = self.inner.include(input);
            self
        }
        /// <p>Specifies whether to see the resource tags for the task set. If <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags aren't included in the response.</p>
        pub fn set_include(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TaskSetField>>,
        ) -> Self {
            self.inner = self.inner.set_include(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DiscoverPollEndpoint`.
    ///
    /// <note>
    /// <p>This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.</p>
    /// </note>
    /// <p>Returns an endpoint for the Amazon ECS agent to poll for updates.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DiscoverPollEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::discover_poll_endpoint_input::Builder,
    }
    impl DiscoverPollEndpoint {
        /// Creates a new `DiscoverPollEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DiscoverPollEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DiscoverPollEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The container instance ID or full ARN of the container instance. The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the container instance, the Amazon Web Services account ID of the container instance owner, the <code>container-instance</code> namespace, and then the container instance ID. For example, <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.</p>
        pub fn container_instance(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_instance(input.into());
            self
        }
        /// <p>The container instance ID or full ARN of the container instance. The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the container instance, the Amazon Web Services account ID of the container instance owner, the <code>container-instance</code> namespace, and then the container instance ID. For example, <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.</p>
        pub fn set_container_instance(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_instance(input);
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that the container instance belongs to.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that the container instance belongs to.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExecuteCommand`.
    ///
    /// <p>Runs a command remotely on a container within a task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExecuteCommand {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::execute_command_input::Builder,
    }
    impl ExecuteCommand {
        /// Creates a new `ExecuteCommand`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteCommandOutput,
            aws_smithy_http::result::SdkError<crate::error::ExecuteCommandError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) or short name of the cluster the task is running in. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) or short name of the cluster the task is running in. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>The name of the container to execute the command on. A container name only needs to be specified for tasks containing multiple containers.</p>
        pub fn container(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container(input.into());
            self
        }
        /// <p>The name of the container to execute the command on. A container name only needs to be specified for tasks containing multiple containers.</p>
        pub fn set_container(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_container(input);
            self
        }
        /// <p>The command to run on the container.</p>
        pub fn command(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.command(input.into());
            self
        }
        /// <p>The command to run on the container.</p>
        pub fn set_command(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_command(input);
            self
        }
        /// <p>Use this flag to run your command in interactive mode.</p>
        pub fn interactive(mut self, input: bool) -> Self {
            self.inner = self.inner.interactive(input);
            self
        }
        /// <p>Use this flag to run your command in interactive mode.</p>
        pub fn set_interactive(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_interactive(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) or ID of the task the container is part of.</p>
        pub fn task(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) or ID of the task the container is part of.</p>
        pub fn set_task(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccountSettings`.
    ///
    /// <p>Lists the account settings for a specified principal.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccountSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_account_settings_input::Builder,
    }
    impl ListAccountSettings {
        /// Creates a new `ListAccountSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccountSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAccountSettingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAccountSettingsPaginator {
            crate::paginator::ListAccountSettingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the account setting you want to list the settings for.</p>
        pub fn name(mut self, input: crate::model::SettingName) -> Self {
            self.inner = self.inner.name(input);
            self
        }
        /// <p>The name of the account setting you want to list the settings for.</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::SettingName>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The value of the account settings to filter results with. You must also specify an account setting name to use this parameter.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.value(input.into());
            self
        }
        /// <p>The value of the account settings to filter results with. You must also specify an account setting name to use this parameter.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_value(input);
            self
        }
        /// <p>The ARN of the principal, which can be an IAM user, IAM role, or the root user. If this field is omitted, the account settings are listed only for the authenticated user.</p> <note>
        /// <p>Federated users assume the account setting of the root user and can't have explicit account settings set for them.</p>
        /// </note>
        pub fn principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_arn(input.into());
            self
        }
        /// <p>The ARN of the principal, which can be an IAM user, IAM role, or the root user. If this field is omitted, the account settings are listed only for the authenticated user.</p> <note>
        /// <p>Federated users assume the account setting of the root user and can't have explicit account settings set for them.</p>
        /// </note>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_principal_arn(input);
            self
        }
        /// <p>Determines whether to return the effective settings. If <code>true</code>, the account settings for the root user or the default setting for the <code>principalArn</code> are returned. If <code>false</code>, the account settings for the <code>principalArn</code> are returned if they're set. Otherwise, no account settings are returned.</p>
        pub fn effective_settings(mut self, input: bool) -> Self {
            self.inner = self.inner.effective_settings(input);
            self
        }
        /// <p>Determines whether to return the effective settings. If <code>true</code>, the account settings for the root user or the default setting for the <code>principalArn</code> are returned. If <code>false</code>, the account settings for the <code>principalArn</code> are returned if they're set. Otherwise, no account settings are returned.</p>
        pub fn set_effective_settings(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_effective_settings(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListAccountSettings</code> request indicating that more results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was provided, it's possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListAccountSettings</code> request indicating that more results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was provided, it's possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of account setting results returned by <code>ListAccountSettings</code> in paginated output. When this parameter is used, <code>ListAccountSettings</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListAccountSettings</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 10. If this parameter isn't used, then <code>ListAccountSettings</code> returns up to 10 results and a <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of account setting results returned by <code>ListAccountSettings</code> in paginated output. When this parameter is used, <code>ListAccountSettings</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListAccountSettings</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 10. If this parameter isn't used, then <code>ListAccountSettings</code> returns up to 10 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAttributes`.
    ///
    /// <p>Lists the attributes for Amazon ECS resources within a specified target type and cluster. When you specify a target type and cluster, <code>ListAttributes</code> returns a list of attribute objects, one for each attribute on each resource. You can filter the list of results to a single attribute name to only return results that have that name. You can also filter the results by attribute name and value. You can do this, for example, to see which container instances in a cluster are running a Linux AMI (<code>ecs.os-type=linux</code>). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_attributes_input::Builder,
    }
    impl ListAttributes {
        /// Creates a new `ListAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAttributesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAttributesPaginator {
            crate::paginator::ListAttributesPaginator::new(self.handle, self.inner)
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to list attributes. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to list attributes. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>The type of the target to list attributes with.</p>
        pub fn target_type(mut self, input: crate::model::TargetType) -> Self {
            self.inner = self.inner.target_type(input);
            self
        }
        /// <p>The type of the target to list attributes with.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::TargetType>,
        ) -> Self {
            self.inner = self.inner.set_target_type(input);
            self
        }
        /// <p>The name of the attribute to filter the results with. </p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_name(input.into());
            self
        }
        /// <p>The name of the attribute to filter the results with. </p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attribute_name(input);
            self
        }
        /// <p>The value of the attribute to filter results with. You must also specify an attribute name to use this parameter.</p>
        pub fn attribute_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_value(input.into());
            self
        }
        /// <p>The value of the attribute to filter results with. You must also specify an attribute name to use this parameter.</p>
        pub fn set_attribute_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attribute_value(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListAttributes</code> request indicating that more results are available to fulfill the request and further calls are needed. If <code>maxResults</code> was provided, it's possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListAttributes</code> request indicating that more results are available to fulfill the request and further calls are needed. If <code>maxResults</code> was provided, it's possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of cluster results that <code>ListAttributes</code> returned in paginated output. When this parameter is used, <code>ListAttributes</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListAttributes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListAttributes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of cluster results that <code>ListAttributes</code> returned in paginated output. When this parameter is used, <code>ListAttributes</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListAttributes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListAttributes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListClusters`.
    ///
    /// <p>Returns a list of existing clusters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListClusters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_clusters_input::Builder,
    }
    impl ListClusters {
        /// Creates a new `ListClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListClustersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListClustersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListClustersPaginator {
            crate::paginator::ListClustersPaginator::new(self.handle, self.inner)
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListClusters</code> request indicating that more results are available to fulfill the request and further calls are needed. If <code>maxResults</code> was provided, it's possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListClusters</code> request indicating that more results are available to fulfill the request and further calls are needed. If <code>maxResults</code> was provided, it's possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of cluster results that <code>ListClusters</code> returned in paginated output. When this parameter is used, <code>ListClusters</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListClusters</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListClusters</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of cluster results that <code>ListClusters</code> returned in paginated output. When this parameter is used, <code>ListClusters</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListClusters</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListClusters</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContainerInstances`.
    ///
    /// <p>Returns a list of container instances in a specified cluster. You can filter the results of a <code>ListContainerInstances</code> operation with cluster query language statements inside the <code>filter</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListContainerInstances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_container_instances_input::Builder,
    }
    impl ListContainerInstances {
        /// Creates a new `ListContainerInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContainerInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContainerInstancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListContainerInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListContainerInstancesPaginator {
            crate::paginator::ListContainerInstancesPaginator::new(self.handle, self.inner)
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to list. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to list. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>You can filter the results of a <code>ListContainerInstances</code> operation with cluster query language statements. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter(input.into());
            self
        }
        /// <p>You can filter the results of a <code>ListContainerInstances</code> operation with cluster query language statements. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_filter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListContainerInstances</code> request indicating that more results are available to fulfill the request and further calls are needed. If <code>maxResults</code> was provided, it's possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListContainerInstances</code> request indicating that more results are available to fulfill the request and further calls are needed. If <code>maxResults</code> was provided, it's possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of container instance results that <code>ListContainerInstances</code> returned in paginated output. When this parameter is used, <code>ListContainerInstances</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListContainerInstances</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListContainerInstances</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of container instance results that <code>ListContainerInstances</code> returned in paginated output. When this parameter is used, <code>ListContainerInstances</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListContainerInstances</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListContainerInstances</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Filters the container instances by status. For example, if you specify the <code>DRAINING</code> status, the results include only container instances that have been set to <code>DRAINING</code> using <code>UpdateContainerInstancesState</code>. If you don't specify this parameter, the default is to include container instances set to all states other than <code>INACTIVE</code>.</p>
        pub fn status(mut self, input: crate::model::ContainerInstanceStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>Filters the container instances by status. For example, if you specify the <code>DRAINING</code> status, the results include only container instances that have been set to <code>DRAINING</code> using <code>UpdateContainerInstancesState</code>. If you don't specify this parameter, the default is to include container instances set to all states other than <code>INACTIVE</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ContainerInstanceStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServices`.
    ///
    /// <p>Returns a list of services. You can filter the results by cluster, launch type, and scheduling strategy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListServices {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_services_input::Builder,
    }
    impl ListServices {
        /// Creates a new `ListServices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServicesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListServicesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListServicesPaginator {
            crate::paginator::ListServicesPaginator::new(self.handle, self.inner)
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the <code>ListServices</code> results. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the <code>ListServices</code> results. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListServices</code> request indicating that more results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was provided, it is possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListServices</code> request indicating that more results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was provided, it is possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of service results that <code>ListServices</code> returned in paginated output. When this parameter is used, <code>ListServices</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListServices</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListServices</code> returns up to 10 results and a <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of service results that <code>ListServices</code> returned in paginated output. When this parameter is used, <code>ListServices</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListServices</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListServices</code> returns up to 10 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The launch type to use when filtering the <code>ListServices</code> results.</p>
        pub fn launch_type(mut self, input: crate::model::LaunchType) -> Self {
            self.inner = self.inner.launch_type(input);
            self
        }
        /// <p>The launch type to use when filtering the <code>ListServices</code> results.</p>
        pub fn set_launch_type(
            mut self,
            input: std::option::Option<crate::model::LaunchType>,
        ) -> Self {
            self.inner = self.inner.set_launch_type(input);
            self
        }
        /// <p>The scheduling strategy to use when filtering the <code>ListServices</code> results.</p>
        pub fn scheduling_strategy(mut self, input: crate::model::SchedulingStrategy) -> Self {
            self.inner = self.inner.scheduling_strategy(input);
            self
        }
        /// <p>The scheduling strategy to use when filtering the <code>ListServices</code> results.</p>
        pub fn set_scheduling_strategy(
            mut self,
            input: std::option::Option<crate::model::SchedulingStrategy>,
        ) -> Self {
            self.inner = self.inner.set_scheduling_strategy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List the tags for an Amazon ECS resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource to list the tags for. Currently, the supported resources are Amazon ECS tasks, services, task definitions, clusters, and container instances.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource to list the tags for. Currently, the supported resources are Amazon ECS tasks, services, task definitions, clusters, and container instances.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTaskDefinitionFamilies`.
    ///
    /// <p>Returns a list of task definition families that are registered to your account. This list includes task definition families that no longer have any <code>ACTIVE</code> task definition revisions.</p>
    /// <p>You can filter out task definition families that don't contain any <code>ACTIVE</code> task definition revisions by setting the <code>status</code> parameter to <code>ACTIVE</code>. You can also filter the results with the <code>familyPrefix</code> parameter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTaskDefinitionFamilies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_task_definition_families_input::Builder,
    }
    impl ListTaskDefinitionFamilies {
        /// Creates a new `ListTaskDefinitionFamilies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTaskDefinitionFamiliesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTaskDefinitionFamiliesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTaskDefinitionFamiliesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTaskDefinitionFamiliesPaginator {
            crate::paginator::ListTaskDefinitionFamiliesPaginator::new(self.handle, self.inner)
        }
        /// <p>The <code>familyPrefix</code> is a string that's used to filter the results of <code>ListTaskDefinitionFamilies</code>. If you specify a <code>familyPrefix</code>, only task definition family names that begin with the <code>familyPrefix</code> string are returned.</p>
        pub fn family_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.family_prefix(input.into());
            self
        }
        /// <p>The <code>familyPrefix</code> is a string that's used to filter the results of <code>ListTaskDefinitionFamilies</code>. If you specify a <code>familyPrefix</code>, only task definition family names that begin with the <code>familyPrefix</code> string are returned.</p>
        pub fn set_family_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_family_prefix(input);
            self
        }
        /// <p>The task definition family status to filter the <code>ListTaskDefinitionFamilies</code> results with. By default, both <code>ACTIVE</code> and <code>INACTIVE</code> task definition families are listed. If this parameter is set to <code>ACTIVE</code>, only task definition families that have an <code>ACTIVE</code> task definition revision are returned. If this parameter is set to <code>INACTIVE</code>, only task definition families that do not have any <code>ACTIVE</code> task definition revisions are returned. If you paginate the resulting output, be sure to keep the <code>status</code> value constant in each subsequent request.</p>
        pub fn status(mut self, input: crate::model::TaskDefinitionFamilyStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The task definition family status to filter the <code>ListTaskDefinitionFamilies</code> results with. By default, both <code>ACTIVE</code> and <code>INACTIVE</code> task definition families are listed. If this parameter is set to <code>ACTIVE</code>, only task definition families that have an <code>ACTIVE</code> task definition revision are returned. If this parameter is set to <code>INACTIVE</code>, only task definition families that do not have any <code>ACTIVE</code> task definition revisions are returned. If you paginate the resulting output, be sure to keep the <code>status</code> value constant in each subsequent request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TaskDefinitionFamilyStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListTaskDefinitionFamilies</code> request indicating that more results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was provided, it is possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListTaskDefinitionFamilies</code> request indicating that more results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was provided, it is possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of task definition family results that <code>ListTaskDefinitionFamilies</code> returned in paginated output. When this parameter is used, <code>ListTaskDefinitions</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListTaskDefinitionFamilies</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListTaskDefinitionFamilies</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of task definition family results that <code>ListTaskDefinitionFamilies</code> returned in paginated output. When this parameter is used, <code>ListTaskDefinitions</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListTaskDefinitionFamilies</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListTaskDefinitionFamilies</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTaskDefinitions`.
    ///
    /// <p>Returns a list of task definitions that are registered to your account. You can filter the results by family name with the <code>familyPrefix</code> parameter or by status with the <code>status</code> parameter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTaskDefinitions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_task_definitions_input::Builder,
    }
    impl ListTaskDefinitions {
        /// Creates a new `ListTaskDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTaskDefinitionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTaskDefinitionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTaskDefinitionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTaskDefinitionsPaginator {
            crate::paginator::ListTaskDefinitionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The full family name to filter the <code>ListTaskDefinitions</code> results with. Specifying a <code>familyPrefix</code> limits the listed task definitions to task definition revisions that belong to that family.</p>
        pub fn family_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.family_prefix(input.into());
            self
        }
        /// <p>The full family name to filter the <code>ListTaskDefinitions</code> results with. Specifying a <code>familyPrefix</code> limits the listed task definitions to task definition revisions that belong to that family.</p>
        pub fn set_family_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_family_prefix(input);
            self
        }
        /// <p>The task definition status to filter the <code>ListTaskDefinitions</code> results with. By default, only <code>ACTIVE</code> task definitions are listed. By setting this parameter to <code>INACTIVE</code>, you can view task definitions that are <code>INACTIVE</code> as long as an active task or service still references them. If you paginate the resulting output, be sure to keep the <code>status</code> value constant in each subsequent request.</p>
        pub fn status(mut self, input: crate::model::TaskDefinitionStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The task definition status to filter the <code>ListTaskDefinitions</code> results with. By default, only <code>ACTIVE</code> task definitions are listed. By setting this parameter to <code>INACTIVE</code>, you can view task definitions that are <code>INACTIVE</code> as long as an active task or service still references them. If you paginate the resulting output, be sure to keep the <code>status</code> value constant in each subsequent request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TaskDefinitionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The order to sort the results in. Valid values are <code>ASC</code> and <code>DESC</code>. By default, (<code>ASC</code>) task definitions are listed lexicographically by family name and in ascending numerical order by revision so that the newest task definitions in a family are listed last. Setting this parameter to <code>DESC</code> reverses the sort order on family name and revision. This is so that the newest task definitions in a family are listed first.</p>
        pub fn sort(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort(input);
            self
        }
        /// <p>The order to sort the results in. Valid values are <code>ASC</code> and <code>DESC</code>. By default, (<code>ASC</code>) task definitions are listed lexicographically by family name and in ascending numerical order by revision so that the newest task definitions in a family are listed last. Setting this parameter to <code>DESC</code> reverses the sort order on family name and revision. This is so that the newest task definitions in a family are listed first.</p>
        pub fn set_sort(mut self, input: std::option::Option<crate::model::SortOrder>) -> Self {
            self.inner = self.inner.set_sort(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListTaskDefinitions</code> request indicating that more results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was provided, it is possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListTaskDefinitions</code> request indicating that more results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was provided, it is possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of task definition results that <code>ListTaskDefinitions</code> returned in paginated output. When this parameter is used, <code>ListTaskDefinitions</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListTaskDefinitions</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListTaskDefinitions</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of task definition results that <code>ListTaskDefinitions</code> returned in paginated output. When this parameter is used, <code>ListTaskDefinitions</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListTaskDefinitions</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListTaskDefinitions</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTasks`.
    ///
    /// <p>Returns a list of tasks. You can filter the results by cluster, task definition family, container instance, launch type, what IAM principal started the task, or by the desired status of the task.</p>
    /// <p>Recently stopped tasks might appear in the returned results. Currently, stopped tasks appear in the returned results for at least one hour.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTasks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tasks_input::Builder,
    }
    impl ListTasks {
        /// Creates a new `ListTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTasksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTasksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTasksPaginator {
            crate::paginator::ListTasksPaginator::new(self.handle, self.inner)
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the <code>ListTasks</code> results. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the <code>ListTasks</code> results. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>The container instance ID or full ARN of the container instance to use when filtering the <code>ListTasks</code> results. Specifying a <code>containerInstance</code> limits the results to tasks that belong to that container instance.</p>
        pub fn container_instance(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_instance(input.into());
            self
        }
        /// <p>The container instance ID or full ARN of the container instance to use when filtering the <code>ListTasks</code> results. Specifying a <code>containerInstance</code> limits the results to tasks that belong to that container instance.</p>
        pub fn set_container_instance(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_instance(input);
            self
        }
        /// <p>The name of the task definition family to use when filtering the <code>ListTasks</code> results. Specifying a <code>family</code> limits the results to tasks that belong to that family.</p>
        pub fn family(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.family(input.into());
            self
        }
        /// <p>The name of the task definition family to use when filtering the <code>ListTasks</code> results. Specifying a <code>family</code> limits the results to tasks that belong to that family.</p>
        pub fn set_family(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_family(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListTasks</code> request indicating that more results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was provided, it's possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListTasks</code> request indicating that more results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was provided, it's possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of task results that <code>ListTasks</code> returned in paginated output. When this parameter is used, <code>ListTasks</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListTasks</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListTasks</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of task results that <code>ListTasks</code> returned in paginated output. When this parameter is used, <code>ListTasks</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListTasks</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListTasks</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The <code>startedBy</code> value to filter the task results with. Specifying a <code>startedBy</code> value limits the results to tasks that were started with that value.</p>
        pub fn started_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.started_by(input.into());
            self
        }
        /// <p>The <code>startedBy</code> value to filter the task results with. Specifying a <code>startedBy</code> value limits the results to tasks that were started with that value.</p>
        pub fn set_started_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_started_by(input);
            self
        }
        /// <p>The name of the service to use when filtering the <code>ListTasks</code> results. Specifying a <code>serviceName</code> limits the results to tasks that belong to that service.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(input.into());
            self
        }
        /// <p>The name of the service to use when filtering the <code>ListTasks</code> results. Specifying a <code>serviceName</code> limits the results to tasks that belong to that service.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
        /// <p>The task desired status to use when filtering the <code>ListTasks</code> results. Specifying a <code>desiredStatus</code> of <code>STOPPED</code> limits the results to tasks that Amazon ECS has set the desired status to <code>STOPPED</code>. This can be useful for debugging tasks that aren't starting properly or have died or finished. The default status filter is <code>RUNNING</code>, which shows tasks that Amazon ECS has set the desired status to <code>RUNNING</code>.</p> <note>
        /// <p>Although you can filter results based on a desired status of <code>PENDING</code>, this doesn't return any results. Amazon ECS never sets the desired status of a task to that value (only a task's <code>lastStatus</code> may have a value of <code>PENDING</code>).</p>
        /// </note>
        pub fn desired_status(mut self, input: crate::model::DesiredStatus) -> Self {
            self.inner = self.inner.desired_status(input);
            self
        }
        /// <p>The task desired status to use when filtering the <code>ListTasks</code> results. Specifying a <code>desiredStatus</code> of <code>STOPPED</code> limits the results to tasks that Amazon ECS has set the desired status to <code>STOPPED</code>. This can be useful for debugging tasks that aren't starting properly or have died or finished. The default status filter is <code>RUNNING</code>, which shows tasks that Amazon ECS has set the desired status to <code>RUNNING</code>.</p> <note>
        /// <p>Although you can filter results based on a desired status of <code>PENDING</code>, this doesn't return any results. Amazon ECS never sets the desired status of a task to that value (only a task's <code>lastStatus</code> may have a value of <code>PENDING</code>).</p>
        /// </note>
        pub fn set_desired_status(
            mut self,
            input: std::option::Option<crate::model::DesiredStatus>,
        ) -> Self {
            self.inner = self.inner.set_desired_status(input);
            self
        }
        /// <p>The launch type to use when filtering the <code>ListTasks</code> results.</p>
        pub fn launch_type(mut self, input: crate::model::LaunchType) -> Self {
            self.inner = self.inner.launch_type(input);
            self
        }
        /// <p>The launch type to use when filtering the <code>ListTasks</code> results.</p>
        pub fn set_launch_type(
            mut self,
            input: std::option::Option<crate::model::LaunchType>,
        ) -> Self {
            self.inner = self.inner.set_launch_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccountSetting`.
    ///
    /// <p>Modifies an account setting. Account settings are set on a per-Region basis.</p>
    /// <p>If you change the account setting for the root user, the default settings for all of the IAM users and roles that no individual account setting was specified are reset for. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html">Account Settings</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>When <code>serviceLongArnFormat</code>, <code>taskLongArnFormat</code>, or <code>containerInstanceLongArnFormat</code> are specified, the Amazon Resource Name (ARN) and resource ID format of the resource type for a specified IAM user, IAM role, or the root user for an account is affected. The opt-in and opt-out account setting must be set for each Amazon ECS resource separately. The ARN and resource ID format of a resource is defined by the opt-in status of the IAM user or role that created the resource. You must turn on this setting to use Amazon ECS features such as resource tagging.</p>
    /// <p>When <code>awsvpcTrunking</code> is specified, the elastic network interface (ENI) limit for any new container instances that support the feature is changed. If <code>awsvpcTrunking</code> is enabled, any new container instances that support the feature are launched have the increased ENI limits available to them. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-eni.html">Elastic Network Interface Trunking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>When <code>containerInsights</code> is specified, the default setting indicating whether CloudWatch Container Insights is enabled for your clusters is changed. If <code>containerInsights</code> is enabled, any new clusters that are created will have Container Insights enabled unless you disable it during cluster creation. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html">CloudWatch Container Insights</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAccountSetting {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_account_setting_input::Builder,
    }
    impl PutAccountSetting {
        /// Creates a new `PutAccountSetting`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccountSettingOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAccountSettingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon ECS resource name for which to modify the account setting. If <code>serviceLongArnFormat</code> is specified, the ARN for your Amazon ECS services is affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS container instances is affected. If <code>awsvpcTrunking</code> is specified, the elastic network interface (ENI) limit for your Amazon ECS container instances is affected. If <code>containerInsights</code> is specified, the default setting for CloudWatch Container Insights for your clusters is affected.</p>
        pub fn name(mut self, input: crate::model::SettingName) -> Self {
            self.inner = self.inner.name(input);
            self
        }
        /// <p>The Amazon ECS resource name for which to modify the account setting. If <code>serviceLongArnFormat</code> is specified, the ARN for your Amazon ECS services is affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS container instances is affected. If <code>awsvpcTrunking</code> is specified, the elastic network interface (ENI) limit for your Amazon ECS container instances is affected. If <code>containerInsights</code> is specified, the default setting for CloudWatch Container Insights for your clusters is affected.</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::SettingName>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The account setting value for the specified principal ARN. Accepted values are <code>enabled</code> and <code>disabled</code>.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.value(input.into());
            self
        }
        /// <p>The account setting value for the specified principal ARN. Accepted values are <code>enabled</code> and <code>disabled</code>.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_value(input);
            self
        }
        /// <p>The ARN of the principal, which can be an IAM user, IAM role, or the root user. If you specify the root user, it modifies the account setting for all IAM users, IAM roles, and the root user of the account unless an IAM user or role explicitly overrides these settings. If this field is omitted, the setting is changed only for the authenticated user.</p> <note>
        /// <p>Federated users assume the account setting of the root user and can't have explicit account settings set for them.</p>
        /// </note>
        pub fn principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal_arn(input.into());
            self
        }
        /// <p>The ARN of the principal, which can be an IAM user, IAM role, or the root user. If you specify the root user, it modifies the account setting for all IAM users, IAM roles, and the root user of the account unless an IAM user or role explicitly overrides these settings. If this field is omitted, the setting is changed only for the authenticated user.</p> <note>
        /// <p>Federated users assume the account setting of the root user and can't have explicit account settings set for them.</p>
        /// </note>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_principal_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccountSettingDefault`.
    ///
    /// <p>Modifies an account setting for all IAM users on an account for whom no individual account setting has been specified. Account settings are set on a per-Region basis.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAccountSettingDefault {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_account_setting_default_input::Builder,
    }
    impl PutAccountSettingDefault {
        /// Creates a new `PutAccountSettingDefault`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccountSettingDefaultOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAccountSettingDefaultError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource name for which to modify the account setting. If <code>serviceLongArnFormat</code> is specified, the ARN for your Amazon ECS services is affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS container instances is affected. If <code>awsvpcTrunking</code> is specified, the ENI limit for your Amazon ECS container instances is affected. If <code>containerInsights</code> is specified, the default setting for CloudWatch Container Insights for your clusters is affected.</p>
        pub fn name(mut self, input: crate::model::SettingName) -> Self {
            self.inner = self.inner.name(input);
            self
        }
        /// <p>The resource name for which to modify the account setting. If <code>serviceLongArnFormat</code> is specified, the ARN for your Amazon ECS services is affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS container instances is affected. If <code>awsvpcTrunking</code> is specified, the ENI limit for your Amazon ECS container instances is affected. If <code>containerInsights</code> is specified, the default setting for CloudWatch Container Insights for your clusters is affected.</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::SettingName>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The account setting value for the specified principal ARN. Accepted values are <code>enabled</code> and <code>disabled</code>.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.value(input.into());
            self
        }
        /// <p>The account setting value for the specified principal ARN. Accepted values are <code>enabled</code> and <code>disabled</code>.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAttributes`.
    ///
    /// <p>Create or update an attribute on an Amazon ECS resource. If the attribute doesn't exist, it's created. If the attribute exists, its value is replaced with the specified value. To delete an attribute, use <code>DeleteAttributes</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes">Attributes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_attributes_input::Builder,
    }
    impl PutAttributes {
        /// Creates a new `PutAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that contains the resource to apply attributes. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that contains the resource to apply attributes. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes to apply to your resource. You can specify up to 10 custom attributes for each resource. You can specify up to 10 attributes in a single call.</p>
        pub fn attributes(mut self, input: crate::model::Attribute) -> Self {
            self.inner = self.inner.attributes(input);
            self
        }
        /// <p>The attributes to apply to your resource. You can specify up to 10 custom attributes for each resource. You can specify up to 10 attributes in a single call.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutClusterCapacityProviders`.
    ///
    /// <p>Modifies the available capacity providers and the default capacity provider strategy for a cluster.</p>
    /// <p>You must specify both the available capacity providers and a default capacity provider strategy for the cluster. If the specified cluster has existing capacity providers associated with it, you must specify all existing capacity providers in addition to any new ones you want to add. Any existing capacity providers that are associated with a cluster that are omitted from a <code>PutClusterCapacityProviders</code> API call will be disassociated with the cluster. You can only disassociate an existing capacity provider from a cluster if it's not being used by any existing tasks.</p>
    /// <p>When creating a service or running a task on a cluster, if no capacity provider or launch type is specified, then the cluster's default capacity provider strategy is used. We recommend that you define a default capacity provider strategy for your cluster. However, you must specify an empty array (<code>[]</code>) to bypass defining a default strategy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutClusterCapacityProviders {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_cluster_capacity_providers_input::Builder,
    }
    impl PutClusterCapacityProviders {
        /// Creates a new `PutClusterCapacityProviders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutClusterCapacityProvidersOutput,
            aws_smithy_http::result::SdkError<crate::error::PutClusterCapacityProvidersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to modify the capacity provider settings for. If you don't specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to modify the capacity provider settings for. If you don't specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// Appends an item to `capacityProviders`.
        ///
        /// To override the contents of this collection use [`set_capacity_providers`](Self::set_capacity_providers).
        ///
        /// <p>The name of one or more capacity providers to associate with the cluster.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the <code>CreateCapacityProvider</code> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.</p>
        pub fn capacity_providers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.capacity_providers(input.into());
            self
        }
        /// <p>The name of one or more capacity providers to associate with the cluster.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the <code>CreateCapacityProvider</code> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.</p>
        pub fn set_capacity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_capacity_providers(input);
            self
        }
        /// Appends an item to `defaultCapacityProviderStrategy`.
        ///
        /// To override the contents of this collection use [`set_default_capacity_provider_strategy`](Self::set_default_capacity_provider_strategy).
        ///
        /// <p>The capacity provider strategy to use by default for the cluster.</p>
        /// <p>When creating a service or running a task on a cluster, if no capacity provider or launch type is specified then the default capacity provider strategy for the cluster is used.</p>
        /// <p>A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The <code>PutClusterCapacityProviders</code> API is used to associate a capacity provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status can be used.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the <code>CreateCapacityProvider</code> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.</p>
        pub fn default_capacity_provider_strategy(
            mut self,
            input: crate::model::CapacityProviderStrategyItem,
        ) -> Self {
            self.inner = self.inner.default_capacity_provider_strategy(input);
            self
        }
        /// <p>The capacity provider strategy to use by default for the cluster.</p>
        /// <p>When creating a service or running a task on a cluster, if no capacity provider or launch type is specified then the default capacity provider strategy for the cluster is used.</p>
        /// <p>A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The <code>PutClusterCapacityProviders</code> API is used to associate a capacity provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status can be used.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the <code>CreateCapacityProvider</code> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.</p>
        pub fn set_default_capacity_provider_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        ) -> Self {
            self.inner = self.inner.set_default_capacity_provider_strategy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterContainerInstance`.
    ///
    /// <note>
    /// <p>This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.</p>
    /// </note>
    /// <p>Registers an EC2 instance into the specified cluster. This instance becomes available to place containers on.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterContainerInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_container_instance_input::Builder,
    }
    impl RegisterContainerInstance {
        /// Creates a new `RegisterContainerInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterContainerInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterContainerInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to register your container instance with. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to register your container instance with. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>The instance identity document for the EC2 instance to register. This document can be found by running the following command from the instance: <code>curl http://169.254.169.254/latest/dynamic/instance-identity/document/</code> </p>
        pub fn instance_identity_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_identity_document(input.into());
            self
        }
        /// <p>The instance identity document for the EC2 instance to register. This document can be found by running the following command from the instance: <code>curl http://169.254.169.254/latest/dynamic/instance-identity/document/</code> </p>
        pub fn set_instance_identity_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_identity_document(input);
            self
        }
        /// <p>The instance identity document signature for the EC2 instance to register. This signature can be found by running the following command from the instance: <code>curl http://169.254.169.254/latest/dynamic/instance-identity/signature/</code> </p>
        pub fn instance_identity_document_signature(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .instance_identity_document_signature(input.into());
            self
        }
        /// <p>The instance identity document signature for the EC2 instance to register. This signature can be found by running the following command from the instance: <code>curl http://169.254.169.254/latest/dynamic/instance-identity/signature/</code> </p>
        pub fn set_instance_identity_document_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_identity_document_signature(input);
            self
        }
        /// Appends an item to `totalResources`.
        ///
        /// To override the contents of this collection use [`set_total_resources`](Self::set_total_resources).
        ///
        /// <p>The resources available on the instance.</p>
        pub fn total_resources(mut self, input: crate::model::Resource) -> Self {
            self.inner = self.inner.total_resources(input);
            self
        }
        /// <p>The resources available on the instance.</p>
        pub fn set_total_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.inner = self.inner.set_total_resources(input);
            self
        }
        /// <p>The version information for the Amazon ECS container agent and Docker daemon that runs on the container instance.</p>
        pub fn version_info(mut self, input: crate::model::VersionInfo) -> Self {
            self.inner = self.inner.version_info(input);
            self
        }
        /// <p>The version information for the Amazon ECS container agent and Docker daemon that runs on the container instance.</p>
        pub fn set_version_info(
            mut self,
            input: std::option::Option<crate::model::VersionInfo>,
        ) -> Self {
            self.inner = self.inner.set_version_info(input);
            self
        }
        /// <p>The ARN of the container instance (if it was previously registered).</p>
        pub fn container_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the container instance (if it was previously registered).</p>
        pub fn set_container_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_instance_arn(input);
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The container instance attributes that this container instance supports.</p>
        pub fn attributes(mut self, input: crate::model::Attribute) -> Self {
            self.inner = self.inner.attributes(input);
            self
        }
        /// <p>The container instance attributes that this container instance supports.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
        /// Appends an item to `platformDevices`.
        ///
        /// To override the contents of this collection use [`set_platform_devices`](Self::set_platform_devices).
        ///
        /// <p>The devices that are available on the container instance. The only supported device type is a GPU.</p>
        pub fn platform_devices(mut self, input: crate::model::PlatformDevice) -> Self {
            self.inner = self.inner.platform_devices(input);
            self
        }
        /// <p>The devices that are available on the container instance. The only supported device type is a GPU.</p>
        pub fn set_platform_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlatformDevice>>,
        ) -> Self {
            self.inner = self.inner.set_platform_devices(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the container instance to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The metadata that you apply to the container instance to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterTaskDefinition`.
    ///
    /// <p>Registers a new task definition from the supplied <code>family</code> and <code>containerDefinitions</code>. Optionally, you can add data volumes to your containers with the <code>volumes</code> parameter. For more information about task definition parameters and defaults, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Amazon ECS Task Definitions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>You can specify an IAM role for your task with the <code>taskRoleArn</code> parameter. When you specify an IAM role for a task, its containers can then use the latest versions of the CLI or SDKs to make API requests to the Amazon Web Services services that are specified in the IAM policy that's associated with the role. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Roles for Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>You can specify a Docker networking mode for the containers in your task definition with the <code>networkMode</code> parameter. The available network modes correspond to those described in <a href="https://docs.docker.com/engine/reference/run/#/network-settings">Network settings</a> in the Docker run reference. If you specify the <code>awsvpc</code> network mode, the task is allocated an elastic network interface, and you must specify a <code>NetworkConfiguration</code> when you create a service or run a task with the task definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterTaskDefinition {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_task_definition_input::Builder,
    }
    impl RegisterTaskDefinition {
        /// Creates a new `RegisterTaskDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterTaskDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterTaskDefinitionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>You must specify a <code>family</code> for a task definition. You can use it track multiple versions of the same task definition. The <code>family</code> is used as a name for your task definition. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed.</p>
        pub fn family(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.family(input.into());
            self
        }
        /// <p>You must specify a <code>family</code> for a task definition. You can use it track multiple versions of the same task definition. The <code>family</code> is used as a name for your task definition. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed.</p>
        pub fn set_family(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_family(input);
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in this task are granted the permissions that are specified in this role. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Roles for Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn task_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_role_arn(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in this task are granted the permissions that are specified in this role. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Roles for Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_task_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_task_role_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make Amazon Web Services API calls on your behalf. The task execution IAM role is required depending on the requirements of your task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make Amazon Web Services API calls on your behalf. The task execution IAM role is required depending on the requirements of your task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_role_arn(input);
            self
        }
        /// <p>The Docker networking mode to use for the containers in the task. The valid values are <code>none</code>, <code>bridge</code>, <code>awsvpc</code>, and <code>host</code>. If no network mode is specified, the default is <code>bridge</code>.</p>
        /// <p>For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required. For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used. For Amazon ECS tasks on Amazon EC2 Windows instances, <code>
        /// <default></default></code> or <code>awsvpc</code> can be used. If the network mode is set to <code>none</code>, you cannot specify port mappings in your container definitions, and the tasks containers do not have external connectivity. The <code>host</code> and <code>awsvpc</code> network modes offer the highest networking performance for containers because they use the EC2 network stack instead of the virtualized network stack provided by the <code>bridge</code> mode.</p>
        /// <p>With the <code>host</code> and <code>awsvpc</code> network modes, exposed container ports are mapped directly to the corresponding host port (for the <code>host</code> network mode) or the attached elastic network interface port (for the <code>awsvpc</code> network mode), so you cannot take advantage of dynamic host port mappings. </p> <important>
        /// <p>When using the <code>host</code> network mode, you should not run containers using the root user (UID 0). It is considered best practice to use a non-root user.</p>
        /// </important>
        /// <p>If the network mode is <code>awsvpc</code>, the task is allocated an elastic network interface, and you must specify a <code>NetworkConfiguration</code> value when you create a service or run a task with the task definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>If the network mode is <code>host</code>, you cannot run multiple instantiations of the same task on a single container instance when port mappings are used.</p>
        /// <p>For more information, see <a href="https://docs.docker.com/engine/reference/run/#network-settings">Network settings</a> in the <i>Docker run reference</i>.</p>
        pub fn network_mode(mut self, input: crate::model::NetworkMode) -> Self {
            self.inner = self.inner.network_mode(input);
            self
        }
        /// <p>The Docker networking mode to use for the containers in the task. The valid values are <code>none</code>, <code>bridge</code>, <code>awsvpc</code>, and <code>host</code>. If no network mode is specified, the default is <code>bridge</code>.</p>
        /// <p>For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required. For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used. For Amazon ECS tasks on Amazon EC2 Windows instances, <code>
        /// <default></default></code> or <code>awsvpc</code> can be used. If the network mode is set to <code>none</code>, you cannot specify port mappings in your container definitions, and the tasks containers do not have external connectivity. The <code>host</code> and <code>awsvpc</code> network modes offer the highest networking performance for containers because they use the EC2 network stack instead of the virtualized network stack provided by the <code>bridge</code> mode.</p>
        /// <p>With the <code>host</code> and <code>awsvpc</code> network modes, exposed container ports are mapped directly to the corresponding host port (for the <code>host</code> network mode) or the attached elastic network interface port (for the <code>awsvpc</code> network mode), so you cannot take advantage of dynamic host port mappings. </p> <important>
        /// <p>When using the <code>host</code> network mode, you should not run containers using the root user (UID 0). It is considered best practice to use a non-root user.</p>
        /// </important>
        /// <p>If the network mode is <code>awsvpc</code>, the task is allocated an elastic network interface, and you must specify a <code>NetworkConfiguration</code> value when you create a service or run a task with the task definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>If the network mode is <code>host</code>, you cannot run multiple instantiations of the same task on a single container instance when port mappings are used.</p>
        /// <p>For more information, see <a href="https://docs.docker.com/engine/reference/run/#network-settings">Network settings</a> in the <i>Docker run reference</i>.</p>
        pub fn set_network_mode(
            mut self,
            input: std::option::Option<crate::model::NetworkMode>,
        ) -> Self {
            self.inner = self.inner.set_network_mode(input);
            self
        }
        /// Appends an item to `containerDefinitions`.
        ///
        /// To override the contents of this collection use [`set_container_definitions`](Self::set_container_definitions).
        ///
        /// <p>A list of container definitions in JSON format that describe the different containers that make up your task.</p>
        pub fn container_definitions(mut self, input: crate::model::ContainerDefinition) -> Self {
            self.inner = self.inner.container_definitions(input);
            self
        }
        /// <p>A list of container definitions in JSON format that describe the different containers that make up your task.</p>
        pub fn set_container_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContainerDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_container_definitions(input);
            self
        }
        /// Appends an item to `volumes`.
        ///
        /// To override the contents of this collection use [`set_volumes`](Self::set_volumes).
        ///
        /// <p>A list of volume definitions in JSON format that containers in your task might use.</p>
        pub fn volumes(mut self, input: crate::model::Volume) -> Self {
            self.inner = self.inner.volumes(input);
            self
        }
        /// <p>A list of volume definitions in JSON format that containers in your task might use.</p>
        pub fn set_volumes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Volume>>,
        ) -> Self {
            self.inner = self.inner.set_volumes(input);
            self
        }
        /// Appends an item to `placementConstraints`.
        ///
        /// To override the contents of this collection use [`set_placement_constraints`](Self::set_placement_constraints).
        ///
        /// <p>An array of placement constraint objects to use for the task. You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.</p>
        pub fn placement_constraints(
            mut self,
            input: crate::model::TaskDefinitionPlacementConstraint,
        ) -> Self {
            self.inner = self.inner.placement_constraints(input);
            self
        }
        /// <p>An array of placement constraint objects to use for the task. You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.</p>
        pub fn set_placement_constraints(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::TaskDefinitionPlacementConstraint>,
            >,
        ) -> Self {
            self.inner = self.inner.set_placement_constraints(input);
            self
        }
        /// Appends an item to `requiresCompatibilities`.
        ///
        /// To override the contents of this collection use [`set_requires_compatibilities`](Self::set_requires_compatibilities).
        ///
        /// <p>The task launch type that Amazon ECS validates the task definition against. A client exception is returned if the task definition doesn't validate against the compatibilities specified. If no value is specified, the parameter is omitted from the response.</p>
        pub fn requires_compatibilities(mut self, input: crate::model::Compatibility) -> Self {
            self.inner = self.inner.requires_compatibilities(input);
            self
        }
        /// <p>The task launch type that Amazon ECS validates the task definition against. A client exception is returned if the task definition doesn't validate against the compatibilities specified. If no value is specified, the parameter is omitted from the response.</p>
        pub fn set_requires_compatibilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Compatibility>>,
        ) -> Self {
            self.inner = self.inner.set_requires_compatibilities(input);
            self
        }
        /// <p>The number of CPU units used by the task. It can be expressed as an integer using CPU units (for example, <code>1024</code>) or as a string using vCPUs (for example, <code>1 vCPU</code> or <code>1 vcpu</code>) in a task definition. String values are converted to an integer indicating the CPU units when the task definition is registered.</p> <note>
        /// <p>Task-level CPU and memory parameters are ignored for Windows containers. We recommend specifying container-level resources for Windows containers.</p>
        /// </note>
        /// <p>If you're using the EC2 launch type, this field is optional. Supported values are between <code>128</code> CPU units (<code>0.125</code> vCPUs) and <code>10240</code> CPU units (<code>10</code> vCPUs).</p>
        /// <p>If you're using the Fargate launch type, this field is required and you must use one of the following values, which determines your range of supported values for the <code>memory</code> parameter:</p>
        /// <p>The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.</p>
        /// <ul>
        /// <li> <p>256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)</p> </li>
        /// <li> <p>512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)</p> </li>
        /// <li> <p>1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)</p> </li>
        /// <li> <p>2048 (2 vCPU) - Available <code>memory</code> values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)</p> </li>
        /// <li> <p>4096 (4 vCPU) - Available <code>memory</code> values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)</p> </li>
        /// </ul>
        pub fn cpu(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cpu(input.into());
            self
        }
        /// <p>The number of CPU units used by the task. It can be expressed as an integer using CPU units (for example, <code>1024</code>) or as a string using vCPUs (for example, <code>1 vCPU</code> or <code>1 vcpu</code>) in a task definition. String values are converted to an integer indicating the CPU units when the task definition is registered.</p> <note>
        /// <p>Task-level CPU and memory parameters are ignored for Windows containers. We recommend specifying container-level resources for Windows containers.</p>
        /// </note>
        /// <p>If you're using the EC2 launch type, this field is optional. Supported values are between <code>128</code> CPU units (<code>0.125</code> vCPUs) and <code>10240</code> CPU units (<code>10</code> vCPUs).</p>
        /// <p>If you're using the Fargate launch type, this field is required and you must use one of the following values, which determines your range of supported values for the <code>memory</code> parameter:</p>
        /// <p>The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.</p>
        /// <ul>
        /// <li> <p>256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)</p> </li>
        /// <li> <p>512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)</p> </li>
        /// <li> <p>1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)</p> </li>
        /// <li> <p>2048 (2 vCPU) - Available <code>memory</code> values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)</p> </li>
        /// <li> <p>4096 (4 vCPU) - Available <code>memory</code> values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)</p> </li>
        /// </ul>
        pub fn set_cpu(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cpu(input);
            self
        }
        /// <p>The amount of memory (in MiB) used by the task. It can be expressed as an integer using MiB (for example ,<code>1024</code>) or as a string using GB (for example, <code>1GB</code> or <code>1 GB</code>) in a task definition. String values are converted to an integer indicating the MiB when the task definition is registered.</p> <note>
        /// <p>Task-level CPU and memory parameters are ignored for Windows containers. We recommend specifying container-level resources for Windows containers.</p>
        /// </note>
        /// <p>If using the EC2 launch type, this field is optional.</p>
        /// <p>If using the Fargate launch type, this field is required and you must use one of the following values. This determines your range of supported values for the <code>cpu</code> parameter.</p>
        /// <p>The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.</p>
        /// <ul>
        /// <li> <p>512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)</p> </li>
        /// <li> <p>1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)</p> </li>
        /// <li> <p>2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available <code>cpu</code> values: 1024 (1 vCPU)</p> </li>
        /// <li> <p>Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2 vCPU)</p> </li>
        /// <li> <p>Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4 vCPU)</p> </li>
        /// </ul>
        pub fn memory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.memory(input.into());
            self
        }
        /// <p>The amount of memory (in MiB) used by the task. It can be expressed as an integer using MiB (for example ,<code>1024</code>) or as a string using GB (for example, <code>1GB</code> or <code>1 GB</code>) in a task definition. String values are converted to an integer indicating the MiB when the task definition is registered.</p> <note>
        /// <p>Task-level CPU and memory parameters are ignored for Windows containers. We recommend specifying container-level resources for Windows containers.</p>
        /// </note>
        /// <p>If using the EC2 launch type, this field is optional.</p>
        /// <p>If using the Fargate launch type, this field is required and you must use one of the following values. This determines your range of supported values for the <code>cpu</code> parameter.</p>
        /// <p>The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.</p>
        /// <ul>
        /// <li> <p>512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)</p> </li>
        /// <li> <p>1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)</p> </li>
        /// <li> <p>2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available <code>cpu</code> values: 1024 (1 vCPU)</p> </li>
        /// <li> <p>Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2 vCPU)</p> </li>
        /// <li> <p>Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4 vCPU)</p> </li>
        /// </ul>
        pub fn set_memory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_memory(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the task definition to help you categorize and organize them. Each tag consists of a key and an optional value. You define both of them.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The metadata that you apply to the task definition to help you categorize and organize them. Each tag consists of a key and an optional value. You define both of them.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The process namespace to use for the containers in the task. The valid values are <code>host</code> or <code>task</code>. If <code>host</code> is specified, then all containers within the tasks that specified the <code>host</code> PID mode on the same container instance share the same process namespace with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task share the same process namespace. If no value is specified, the default is a private namespace. For more information, see <a href="https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the <i>Docker run reference</i>.</p>
        /// <p>If the <code>host</code> PID mode is used, be aware that there is a heightened risk of undesired process namespace expose. For more information, see <a href="https://docs.docker.com/engine/security/security/">Docker security</a>.</p> <note>
        /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
        /// </note>
        pub fn pid_mode(mut self, input: crate::model::PidMode) -> Self {
            self.inner = self.inner.pid_mode(input);
            self
        }
        /// <p>The process namespace to use for the containers in the task. The valid values are <code>host</code> or <code>task</code>. If <code>host</code> is specified, then all containers within the tasks that specified the <code>host</code> PID mode on the same container instance share the same process namespace with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task share the same process namespace. If no value is specified, the default is a private namespace. For more information, see <a href="https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the <i>Docker run reference</i>.</p>
        /// <p>If the <code>host</code> PID mode is used, be aware that there is a heightened risk of undesired process namespace expose. For more information, see <a href="https://docs.docker.com/engine/security/security/">Docker security</a>.</p> <note>
        /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
        /// </note>
        pub fn set_pid_mode(mut self, input: std::option::Option<crate::model::PidMode>) -> Self {
            self.inner = self.inner.set_pid_mode(input);
            self
        }
        /// <p>The IPC resource namespace to use for the containers in the task. The valid values are <code>host</code>, <code>task</code>, or <code>none</code>. If <code>host</code> is specified, then all containers within the tasks that specified the <code>host</code> IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task share the same IPC resources. If <code>none</code> is specified, then IPC resources within the containers of a task are private and not shared with other containers in a task or on the container instance. If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see <a href="https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC settings</a> in the <i>Docker run reference</i>.</p>
        /// <p>If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of undesired IPC namespace expose. For more information, see <a href="https://docs.docker.com/engine/security/security/">Docker security</a>.</p>
        /// <p>If you are setting namespaced kernel parameters using <code>systemControls</code> for the containers in the task, the following will apply to your IPC resource namespace. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System Controls</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <ul>
        /// <li> <p>For tasks that use the <code>host</code> IPC mode, IPC namespace related <code>systemControls</code> are not supported.</p> </li>
        /// <li> <p>For tasks that use the <code>task</code> IPC mode, IPC namespace related <code>systemControls</code> will apply to all containers within a task.</p> </li>
        /// </ul> <note>
        /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
        /// </note>
        pub fn ipc_mode(mut self, input: crate::model::IpcMode) -> Self {
            self.inner = self.inner.ipc_mode(input);
            self
        }
        /// <p>The IPC resource namespace to use for the containers in the task. The valid values are <code>host</code>, <code>task</code>, or <code>none</code>. If <code>host</code> is specified, then all containers within the tasks that specified the <code>host</code> IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task share the same IPC resources. If <code>none</code> is specified, then IPC resources within the containers of a task are private and not shared with other containers in a task or on the container instance. If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see <a href="https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC settings</a> in the <i>Docker run reference</i>.</p>
        /// <p>If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of undesired IPC namespace expose. For more information, see <a href="https://docs.docker.com/engine/security/security/">Docker security</a>.</p>
        /// <p>If you are setting namespaced kernel parameters using <code>systemControls</code> for the containers in the task, the following will apply to your IPC resource namespace. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System Controls</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <ul>
        /// <li> <p>For tasks that use the <code>host</code> IPC mode, IPC namespace related <code>systemControls</code> are not supported.</p> </li>
        /// <li> <p>For tasks that use the <code>task</code> IPC mode, IPC namespace related <code>systemControls</code> will apply to all containers within a task.</p> </li>
        /// </ul> <note>
        /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
        /// </note>
        pub fn set_ipc_mode(mut self, input: std::option::Option<crate::model::IpcMode>) -> Self {
            self.inner = self.inner.set_ipc_mode(input);
            self
        }
        /// <p>The configuration details for the App Mesh proxy.</p>
        /// <p>For tasks hosted on Amazon EC2 instances, the container instances require at least version <code>1.26.0</code> of the container agent and at least version <code>1.26.0-1</code> of the <code>ecs-init</code> package to use a proxy configuration. If your container instances are launched from the Amazon ECS-optimized AMI version <code>20190301</code> or later, then they contain the required versions of the container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-ami-versions.html">Amazon ECS-optimized AMI versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn proxy_configuration(mut self, input: crate::model::ProxyConfiguration) -> Self {
            self.inner = self.inner.proxy_configuration(input);
            self
        }
        /// <p>The configuration details for the App Mesh proxy.</p>
        /// <p>For tasks hosted on Amazon EC2 instances, the container instances require at least version <code>1.26.0</code> of the container agent and at least version <code>1.26.0-1</code> of the <code>ecs-init</code> package to use a proxy configuration. If your container instances are launched from the Amazon ECS-optimized AMI version <code>20190301</code> or later, then they contain the required versions of the container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-ami-versions.html">Amazon ECS-optimized AMI versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_proxy_configuration(
            mut self,
            input: std::option::Option<crate::model::ProxyConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_proxy_configuration(input);
            self
        }
        /// Appends an item to `inferenceAccelerators`.
        ///
        /// To override the contents of this collection use [`set_inference_accelerators`](Self::set_inference_accelerators).
        ///
        /// <p>The Elastic Inference accelerators to use for the containers in the task.</p>
        pub fn inference_accelerators(mut self, input: crate::model::InferenceAccelerator) -> Self {
            self.inner = self.inner.inference_accelerators(input);
            self
        }
        /// <p>The Elastic Inference accelerators to use for the containers in the task.</p>
        pub fn set_inference_accelerators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InferenceAccelerator>>,
        ) -> Self {
            self.inner = self.inner.set_inference_accelerators(input);
            self
        }
        /// <p>The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on Fargate. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/using_data_volumes.html">Fargate task storage</a> in the <i>Amazon ECS User Guide for Fargate</i>.</p> <note>
        /// <p>This parameter is only supported for tasks hosted on Fargate using the following platform versions:</p>
        /// <ul>
        /// <li> <p>Linux platform version <code>1.4.0</code> or later.</p> </li>
        /// <li> <p>Windows platform version <code>1.0.0</code> or later.</p> </li>
        /// </ul>
        /// </note>
        pub fn ephemeral_storage(mut self, input: crate::model::EphemeralStorage) -> Self {
            self.inner = self.inner.ephemeral_storage(input);
            self
        }
        /// <p>The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on Fargate. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/using_data_volumes.html">Fargate task storage</a> in the <i>Amazon ECS User Guide for Fargate</i>.</p> <note>
        /// <p>This parameter is only supported for tasks hosted on Fargate using the following platform versions:</p>
        /// <ul>
        /// <li> <p>Linux platform version <code>1.4.0</code> or later.</p> </li>
        /// <li> <p>Windows platform version <code>1.0.0</code> or later.</p> </li>
        /// </ul>
        /// </note>
        pub fn set_ephemeral_storage(
            mut self,
            input: std::option::Option<crate::model::EphemeralStorage>,
        ) -> Self {
            self.inner = self.inner.set_ephemeral_storage(input);
            self
        }
        /// <p>The operating system that your tasks definitions run on. A platform family is specified only for tasks using the Fargate launch type. </p>
        /// <p>When you specify a task definition in a service, this value must match the <code>runtimePlatform</code> value of the service.</p>
        pub fn runtime_platform(mut self, input: crate::model::RuntimePlatform) -> Self {
            self.inner = self.inner.runtime_platform(input);
            self
        }
        /// <p>The operating system that your tasks definitions run on. A platform family is specified only for tasks using the Fargate launch type. </p>
        /// <p>When you specify a task definition in a service, this value must match the <code>runtimePlatform</code> value of the service.</p>
        pub fn set_runtime_platform(
            mut self,
            input: std::option::Option<crate::model::RuntimePlatform>,
        ) -> Self {
            self.inner = self.inner.set_runtime_platform(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RunTask`.
    ///
    /// <p>Starts a new task using the specified task definition.</p>
    /// <p>You can allow Amazon ECS to place tasks for you, or you can customize how Amazon ECS places tasks using placement constraints and placement strategies. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/scheduling_tasks.html">Scheduling Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>Alternatively, you can use <code>StartTask</code> to use your own scheduler or place tasks manually on specific container instances.</p>
    /// <p>The Amazon ECS API follows an eventual consistency model. This is because of the distributed nature of the system supporting the API. This means that the result of an API command you run that affects your Amazon ECS resources might not be immediately visible to all subsequent commands you run. Keep this in mind when you carry out an API command that immediately follows a previous API command.</p>
    /// <p>To manage eventual consistency, you can do the following:</p>
    /// <ul>
    /// <li> <p>Confirm the state of the resource before you run a command to modify it. Run the DescribeTasks command using an exponential backoff algorithm to ensure that you allow enough time for the previous command to propagate through the system. To do this, run the DescribeTasks command repeatedly, starting with a couple of seconds of wait time and increasing gradually up to five minutes of wait time.</p> </li>
    /// <li> <p>Add wait time between subsequent commands, even if the DescribeTasks command returns an accurate response. Apply an exponential backoff algorithm starting with a couple of seconds of wait time, and increase gradually up to about five minutes of wait time.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RunTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::run_task_input::Builder,
    }
    impl RunTask {
        /// Creates a new `RunTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RunTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::RunTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `capacityProviderStrategy`.
        ///
        /// To override the contents of this collection use [`set_capacity_provider_strategy`](Self::set_capacity_provider_strategy).
        ///
        /// <p>The capacity provider strategy to use for the task.</p>
        /// <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.</p>
        /// <p>When you use cluster auto scaling, you must specify <code>capacityProviderStrategy</code> and not <code>launchType</code>. </p>
        /// <p>A capacity provider strategy may contain a maximum of 6 capacity providers.</p>
        pub fn capacity_provider_strategy(
            mut self,
            input: crate::model::CapacityProviderStrategyItem,
        ) -> Self {
            self.inner = self.inner.capacity_provider_strategy(input);
            self
        }
        /// <p>The capacity provider strategy to use for the task.</p>
        /// <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.</p>
        /// <p>When you use cluster auto scaling, you must specify <code>capacityProviderStrategy</code> and not <code>launchType</code>. </p>
        /// <p>A capacity provider strategy may contain a maximum of 6 capacity providers.</p>
        pub fn set_capacity_provider_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        ) -> Self {
            self.inner = self.inner.set_capacity_provider_strategy(input);
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to run your task on. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to run your task on. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>The number of instantiations of the specified task to place on your cluster. You can specify up to 10 tasks for each call.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.inner = self.inner.count(input);
            self
        }
        /// <p>The number of instantiations of the specified task to place on your cluster. You can specify up to 10 tasks for each call.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_count(input);
            self
        }
        /// <p>Specifies whether to use Amazon ECS managed tags for the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn enable_ecs_managed_tags(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_ecs_managed_tags(input);
            self
        }
        /// <p>Specifies whether to use Amazon ECS managed tags for the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_enable_ecs_managed_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_ecs_managed_tags(input);
            self
        }
        /// <p>Determines whether to use the execute command functionality for the containers in this task. If <code>true</code>, this enables execute command functionality on all containers in the task.</p>
        /// <p>If <code>true</code>, then the task definition must have a task role, or you must provide one as an override.</p>
        pub fn enable_execute_command(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_execute_command(input);
            self
        }
        /// <p>Determines whether to use the execute command functionality for the containers in this task. If <code>true</code>, this enables execute command functionality on all containers in the task.</p>
        /// <p>If <code>true</code>, then the task definition must have a task role, or you must provide one as an override.</p>
        pub fn set_enable_execute_command(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_execute_command(input);
            self
        }
        /// <p>The name of the task group to associate with the task. The default value is the family name of the task definition (for example, <code>family:my-family-name</code>).</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(input.into());
            self
        }
        /// <p>The name of the task group to associate with the task. The default value is the family name of the task definition (for example, <code>family:my-family-name</code>).</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
        /// <p>The infrastructure to run your standalone task on. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand infrastructure.</p> <note>
        /// <p>Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html">Fargate capacity providers</a> in the <i>Amazon ECS User Guide for Fargate</i>.</p>
        /// </note>
        /// <p>The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your cluster.</p>
        /// <p>The <code>EXTERNAL</code> launch type runs your tasks on your on-premises server or virtual machine (VM) capacity registered to your cluster.</p>
        /// <p>A task can use either a launch type or a capacity provider strategy. If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code> parameter must be omitted.</p>
        /// <p>When you use cluster auto scaling, you must specify <code>capacityProviderStrategy</code> and not <code>launchType</code>. </p>
        pub fn launch_type(mut self, input: crate::model::LaunchType) -> Self {
            self.inner = self.inner.launch_type(input);
            self
        }
        /// <p>The infrastructure to run your standalone task on. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand infrastructure.</p> <note>
        /// <p>Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html">Fargate capacity providers</a> in the <i>Amazon ECS User Guide for Fargate</i>.</p>
        /// </note>
        /// <p>The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your cluster.</p>
        /// <p>The <code>EXTERNAL</code> launch type runs your tasks on your on-premises server or virtual machine (VM) capacity registered to your cluster.</p>
        /// <p>A task can use either a launch type or a capacity provider strategy. If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code> parameter must be omitted.</p>
        /// <p>When you use cluster auto scaling, you must specify <code>capacityProviderStrategy</code> and not <code>launchType</code>. </p>
        pub fn set_launch_type(
            mut self,
            input: std::option::Option<crate::model::LaunchType>,
        ) -> Self {
            self.inner = self.inner.set_launch_type(input);
            self
        }
        /// <p>The network configuration for the task. This parameter is required for task definitions that use the <code>awsvpc</code> network mode to receive their own elastic network interface, and it isn't supported for other network modes. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn network_configuration(mut self, input: crate::model::NetworkConfiguration) -> Self {
            self.inner = self.inner.network_configuration(input);
            self
        }
        /// <p>The network configuration for the task. This parameter is required for task definitions that use the <code>awsvpc</code> network mode to receive their own elastic network interface, and it isn't supported for other network modes. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task networking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_network_configuration(input);
            self
        }
        /// <p>A list of container overrides in JSON format that specify the name of a container in the specified task definition and the overrides it should receive. You can override the default command for a container (that's specified in the task definition or Docker image) with a <code>command</code> override. You can also override existing environment variables (that are specified in the task definition or Docker image) on a container or add new environment variables to it with an <code>environment</code> override.</p>
        /// <p>A total of 8192 characters are allowed for overrides. This limit includes the JSON formatting characters of the override structure.</p>
        pub fn overrides(mut self, input: crate::model::TaskOverride) -> Self {
            self.inner = self.inner.overrides(input);
            self
        }
        /// <p>A list of container overrides in JSON format that specify the name of a container in the specified task definition and the overrides it should receive. You can override the default command for a container (that's specified in the task definition or Docker image) with a <code>command</code> override. You can also override existing environment variables (that are specified in the task definition or Docker image) on a container or add new environment variables to it with an <code>environment</code> override.</p>
        /// <p>A total of 8192 characters are allowed for overrides. This limit includes the JSON formatting characters of the override structure.</p>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<crate::model::TaskOverride>,
        ) -> Self {
            self.inner = self.inner.set_overrides(input);
            self
        }
        /// Appends an item to `placementConstraints`.
        ///
        /// To override the contents of this collection use [`set_placement_constraints`](Self::set_placement_constraints).
        ///
        /// <p>An array of placement constraint objects to use for the task. You can specify up to 10 constraints for each task (including constraints in the task definition and those specified at runtime).</p>
        pub fn placement_constraints(mut self, input: crate::model::PlacementConstraint) -> Self {
            self.inner = self.inner.placement_constraints(input);
            self
        }
        /// <p>An array of placement constraint objects to use for the task. You can specify up to 10 constraints for each task (including constraints in the task definition and those specified at runtime).</p>
        pub fn set_placement_constraints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementConstraint>>,
        ) -> Self {
            self.inner = self.inner.set_placement_constraints(input);
            self
        }
        /// Appends an item to `placementStrategy`.
        ///
        /// To override the contents of this collection use [`set_placement_strategy`](Self::set_placement_strategy).
        ///
        /// <p>The placement strategy objects to use for the task. You can specify a maximum of 5 strategy rules for each task.</p>
        pub fn placement_strategy(mut self, input: crate::model::PlacementStrategy) -> Self {
            self.inner = self.inner.placement_strategy(input);
            self
        }
        /// <p>The placement strategy objects to use for the task. You can specify a maximum of 5 strategy rules for each task.</p>
        pub fn set_placement_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementStrategy>>,
        ) -> Self {
            self.inner = self.inner.set_placement_strategy(input);
            self
        }
        /// <p>The platform version the task uses. A platform version is only specified for tasks hosted on Fargate. If one isn't specified, the <code>LATEST</code> platform version is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate platform versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_version(input.into());
            self
        }
        /// <p>The platform version the task uses. A platform version is only specified for tasks hosted on Fargate. If one isn't specified, the <code>LATEST</code> platform version is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate platform versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_platform_version(input);
            self
        }
        /// <p>Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the <code>TagResource</code> API action.</p> <note>
        /// <p>An error will be received if you specify the <code>SERVICE</code> option when running a task.</p>
        /// </note>
        pub fn propagate_tags(mut self, input: crate::model::PropagateTags) -> Self {
            self.inner = self.inner.propagate_tags(input);
            self
        }
        /// <p>Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the <code>TagResource</code> API action.</p> <note>
        /// <p>An error will be received if you specify the <code>SERVICE</code> option when running a task.</p>
        /// </note>
        pub fn set_propagate_tags(
            mut self,
            input: std::option::Option<crate::model::PropagateTags>,
        ) -> Self {
            self.inner = self.inner.set_propagate_tags(input);
            self
        }
        /// <p>The reference ID to use for the task. The reference ID can have a maximum length of 1024 characters.</p>
        pub fn reference_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reference_id(input.into());
            self
        }
        /// <p>The reference ID to use for the task. The reference ID can have a maximum length of 1024 characters.</p>
        pub fn set_reference_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reference_id(input);
            self
        }
        /// <p>An optional tag specified when a task is started. For example, if you automatically trigger a task to run a batch process job, you could apply a unique identifier for that job to your task with the <code>startedBy</code> parameter. You can then identify which tasks belong to that job by filtering the results of a <code>ListTasks</code> call with the <code>startedBy</code> value. Up to 36 letters (uppercase and lowercase), numbers, hyphens (-), and underscores (_) are allowed.</p>
        /// <p>If a task is started by an Amazon ECS service, then the <code>startedBy</code> parameter contains the deployment ID of the service that starts it.</p>
        pub fn started_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.started_by(input.into());
            self
        }
        /// <p>An optional tag specified when a task is started. For example, if you automatically trigger a task to run a batch process job, you could apply a unique identifier for that job to your task with the <code>startedBy</code> parameter. You can then identify which tasks belong to that job by filtering the results of a <code>ListTasks</code> call with the <code>startedBy</code> value. Up to 36 letters (uppercase and lowercase), numbers, hyphens (-), and underscores (_) are allowed.</p>
        /// <p>If a task is started by an Amazon ECS service, then the <code>startedBy</code> parameter contains the deployment ID of the service that starts it.</p>
        pub fn set_started_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_started_by(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task definition to run. If a <code>revision</code> isn't specified, the latest <code>ACTIVE</code> revision is used.</p>
        /// <p>When you create an IAM policy for run-task, you can set the resource to be the latest task definition revision, or a specific revision.</p>
        /// <p>The full ARN value must match the value that you specified as the <code>Resource</code> of the IAM principal's permissions policy.</p>
        /// <p>When you specify the policy resource as the latest task definition version (by setting the <code>Resource</code> in the policy to <code>arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName</code>), then set this value to <code>arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName</code>.</p>
        /// <p>When you specify the policy resource as a specific task definition version (by setting the <code>Resource</code> in the policy to <code>arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:1</code> or <code>arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:*</code>), then set this value to <code>arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:1</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-resources">Policy Resources for Amazon ECS</a> in the Amazon Elastic Container Service developer Guide.</p>
        pub fn task_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_definition(input.into());
            self
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task definition to run. If a <code>revision</code> isn't specified, the latest <code>ACTIVE</code> revision is used.</p>
        /// <p>When you create an IAM policy for run-task, you can set the resource to be the latest task definition revision, or a specific revision.</p>
        /// <p>The full ARN value must match the value that you specified as the <code>Resource</code> of the IAM principal's permissions policy.</p>
        /// <p>When you specify the policy resource as the latest task definition version (by setting the <code>Resource</code> in the policy to <code>arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName</code>), then set this value to <code>arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName</code>.</p>
        /// <p>When you specify the policy resource as a specific task definition version (by setting the <code>Resource</code> in the policy to <code>arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:1</code> or <code>arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:*</code>), then set this value to <code>arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:1</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-resources">Policy Resources for Amazon ECS</a> in the Amazon Elastic Container Service developer Guide.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_task_definition(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartTask`.
    ///
    /// <p>Starts a new task from the specified task definition on the specified container instance or instances.</p>
    /// <p>Alternatively, you can use <code>RunTask</code> to place tasks for you. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/scheduling_tasks.html">Scheduling Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_task_input::Builder,
    }
    impl StartTask {
        /// Creates a new `StartTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::StartTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster where to start your task. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster where to start your task. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// Appends an item to `containerInstances`.
        ///
        /// To override the contents of this collection use [`set_container_instances`](Self::set_container_instances).
        ///
        /// <p>The container instance IDs or full ARN entries for the container instances where you would like to place your task. You can specify up to 10 container instances.</p>
        pub fn container_instances(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_instances(input.into());
            self
        }
        /// <p>The container instance IDs or full ARN entries for the container instances where you would like to place your task. You can specify up to 10 container instances.</p>
        pub fn set_container_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_container_instances(input);
            self
        }
        /// <p>Specifies whether to use Amazon ECS managed tags for the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn enable_ecs_managed_tags(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_ecs_managed_tags(input);
            self
        }
        /// <p>Specifies whether to use Amazon ECS managed tags for the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_enable_ecs_managed_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_ecs_managed_tags(input);
            self
        }
        /// <p>Whether or not the execute command functionality is enabled for the task. If <code>true</code>, this enables execute command functionality on all containers in the task.</p>
        pub fn enable_execute_command(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_execute_command(input);
            self
        }
        /// <p>Whether or not the execute command functionality is enabled for the task. If <code>true</code>, this enables execute command functionality on all containers in the task.</p>
        pub fn set_enable_execute_command(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_execute_command(input);
            self
        }
        /// <p>The name of the task group to associate with the task. The default value is the family name of the task definition (for example, family:my-family-name).</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(input.into());
            self
        }
        /// <p>The name of the task group to associate with the task. The default value is the family name of the task definition (for example, family:my-family-name).</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
        /// <p>The VPC subnet and security group configuration for tasks that receive their own elastic network interface by using the <code>awsvpc</code> networking mode.</p>
        pub fn network_configuration(mut self, input: crate::model::NetworkConfiguration) -> Self {
            self.inner = self.inner.network_configuration(input);
            self
        }
        /// <p>The VPC subnet and security group configuration for tasks that receive their own elastic network interface by using the <code>awsvpc</code> networking mode.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_network_configuration(input);
            self
        }
        /// <p>A list of container overrides in JSON format that specify the name of a container in the specified task definition and the overrides it receives. You can override the default command for a container (that's specified in the task definition or Docker image) with a <code>command</code> override. You can also override existing environment variables (that are specified in the task definition or Docker image) on a container or add new environment variables to it with an <code>environment</code> override.</p> <note>
        /// <p>A total of 8192 characters are allowed for overrides. This limit includes the JSON formatting characters of the override structure.</p>
        /// </note>
        pub fn overrides(mut self, input: crate::model::TaskOverride) -> Self {
            self.inner = self.inner.overrides(input);
            self
        }
        /// <p>A list of container overrides in JSON format that specify the name of a container in the specified task definition and the overrides it receives. You can override the default command for a container (that's specified in the task definition or Docker image) with a <code>command</code> override. You can also override existing environment variables (that are specified in the task definition or Docker image) on a container or add new environment variables to it with an <code>environment</code> override.</p> <note>
        /// <p>A total of 8192 characters are allowed for overrides. This limit includes the JSON formatting characters of the override structure.</p>
        /// </note>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<crate::model::TaskOverride>,
        ) -> Self {
            self.inner = self.inner.set_overrides(input);
            self
        }
        /// <p>Specifies whether to propagate the tags from the task definition or the service to the task. If no value is specified, the tags aren't propagated.</p>
        pub fn propagate_tags(mut self, input: crate::model::PropagateTags) -> Self {
            self.inner = self.inner.propagate_tags(input);
            self
        }
        /// <p>Specifies whether to propagate the tags from the task definition or the service to the task. If no value is specified, the tags aren't propagated.</p>
        pub fn set_propagate_tags(
            mut self,
            input: std::option::Option<crate::model::PropagateTags>,
        ) -> Self {
            self.inner = self.inner.set_propagate_tags(input);
            self
        }
        /// <p>The reference ID to use for the task.</p>
        pub fn reference_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reference_id(input.into());
            self
        }
        /// <p>The reference ID to use for the task.</p>
        pub fn set_reference_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reference_id(input);
            self
        }
        /// <p>An optional tag specified when a task is started. For example, if you automatically trigger a task to run a batch process job, you could apply a unique identifier for that job to your task with the <code>startedBy</code> parameter. You can then identify which tasks belong to that job by filtering the results of a <code>ListTasks</code> call with the <code>startedBy</code> value. Up to 36 letters (uppercase and lowercase), numbers, hyphens (-), and underscores (_) are allowed.</p>
        /// <p>If a task is started by an Amazon ECS service, the <code>startedBy</code> parameter contains the deployment ID of the service that starts it.</p>
        pub fn started_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.started_by(input.into());
            self
        }
        /// <p>An optional tag specified when a task is started. For example, if you automatically trigger a task to run a batch process job, you could apply a unique identifier for that job to your task with the <code>startedBy</code> parameter. You can then identify which tasks belong to that job by filtering the results of a <code>ListTasks</code> call with the <code>startedBy</code> value. Up to 36 letters (uppercase and lowercase), numbers, hyphens (-), and underscores (_) are allowed.</p>
        /// <p>If a task is started by an Amazon ECS service, the <code>startedBy</code> parameter contains the deployment ID of the service that starts it.</p>
        pub fn set_started_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_started_by(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task definition to start. If a <code>revision</code> isn't specified, the latest <code>ACTIVE</code> revision is used.</p>
        pub fn task_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_definition(input.into());
            self
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task definition to start. If a <code>revision</code> isn't specified, the latest <code>ACTIVE</code> revision is used.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_task_definition(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopTask`.
    ///
    /// <p>Stops a running task. Any tags associated with the task will be deleted.</p>
    /// <p>When <code>StopTask</code> is called on a task, the equivalent of <code>docker stop</code> is issued to the containers running in the task. This results in a <code>SIGTERM</code> value and a default 30-second timeout, after which the <code>SIGKILL</code> value is sent and the containers are forcibly stopped. If the container handles the <code>SIGTERM</code> value gracefully and exits within 30 seconds from receiving it, no <code>SIGKILL</code> value is sent.</p> <note>
    /// <p>The default 30-second timeout can be configured on the Amazon ECS container agent with the <code>ECS_CONTAINER_STOP_TIMEOUT</code> variable. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_task_input::Builder,
    }
    impl StopTask {
        /// Creates a new `StopTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::StopTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task to stop. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task to stop. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>The task ID or full Amazon Resource Name (ARN) of the task to stop.</p>
        pub fn task(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task(input.into());
            self
        }
        /// <p>The task ID or full Amazon Resource Name (ARN) of the task to stop.</p>
        pub fn set_task(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task(input);
            self
        }
        /// <p>An optional message specified when a task is stopped. For example, if you're using a custom scheduler, you can use this parameter to specify the reason for stopping the task here, and the message appears in subsequent <code>DescribeTasks</code> API operations on this task. Up to 255 characters are allowed in this message.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p>An optional message specified when a task is stopped. For example, if you're using a custom scheduler, you can use this parameter to specify the reason for stopping the task here, and the message appears in subsequent <code>DescribeTasks</code> API operations on this task. Up to 255 characters are allowed in this message.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SubmitAttachmentStateChanges`.
    ///
    /// <note>
    /// <p>This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.</p>
    /// </note>
    /// <p>Sent to acknowledge that an attachment changed states.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SubmitAttachmentStateChanges {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::submit_attachment_state_changes_input::Builder,
    }
    impl SubmitAttachmentStateChanges {
        /// Creates a new `SubmitAttachmentStateChanges`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SubmitAttachmentStateChangesOutput,
            aws_smithy_http::result::SdkError<crate::error::SubmitAttachmentStateChangesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full ARN of the cluster that hosts the container instance the attachment belongs to.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full ARN of the cluster that hosts the container instance the attachment belongs to.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// Appends an item to `attachments`.
        ///
        /// To override the contents of this collection use [`set_attachments`](Self::set_attachments).
        ///
        /// <p>Any attachments associated with the state change request.</p>
        pub fn attachments(mut self, input: crate::model::AttachmentStateChange) -> Self {
            self.inner = self.inner.attachments(input);
            self
        }
        /// <p>Any attachments associated with the state change request.</p>
        pub fn set_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttachmentStateChange>>,
        ) -> Self {
            self.inner = self.inner.set_attachments(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SubmitContainerStateChange`.
    ///
    /// <note>
    /// <p>This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.</p>
    /// </note>
    /// <p>Sent to acknowledge that a container changed states.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SubmitContainerStateChange {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::submit_container_state_change_input::Builder,
    }
    impl SubmitContainerStateChange {
        /// Creates a new `SubmitContainerStateChange`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SubmitContainerStateChangeOutput,
            aws_smithy_http::result::SdkError<crate::error::SubmitContainerStateChangeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full ARN of the cluster that hosts the container.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full ARN of the cluster that hosts the container.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>The task ID or full Amazon Resource Name (ARN) of the task that hosts the container.</p>
        pub fn task(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task(input.into());
            self
        }
        /// <p>The task ID or full Amazon Resource Name (ARN) of the task that hosts the container.</p>
        pub fn set_task(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task(input);
            self
        }
        /// <p>The name of the container.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(input.into());
            self
        }
        /// <p>The name of the container.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
        /// <p>The ID of the Docker container.</p>
        pub fn runtime_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.runtime_id(input.into());
            self
        }
        /// <p>The ID of the Docker container.</p>
        pub fn set_runtime_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_runtime_id(input);
            self
        }
        /// <p>The status of the state change request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status(input.into());
            self
        }
        /// <p>The status of the state change request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The exit code that's returned for the state change request.</p>
        pub fn exit_code(mut self, input: i32) -> Self {
            self.inner = self.inner.exit_code(input);
            self
        }
        /// <p>The exit code that's returned for the state change request.</p>
        pub fn set_exit_code(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_exit_code(input);
            self
        }
        /// <p>The reason for the state change request.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p>The reason for the state change request.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
        /// Appends an item to `networkBindings`.
        ///
        /// To override the contents of this collection use [`set_network_bindings`](Self::set_network_bindings).
        ///
        /// <p>The network bindings of the container.</p>
        pub fn network_bindings(mut self, input: crate::model::NetworkBinding) -> Self {
            self.inner = self.inner.network_bindings(input);
            self
        }
        /// <p>The network bindings of the container.</p>
        pub fn set_network_bindings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkBinding>>,
        ) -> Self {
            self.inner = self.inner.set_network_bindings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SubmitTaskStateChange`.
    ///
    /// <note>
    /// <p>This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.</p>
    /// </note>
    /// <p>Sent to acknowledge that a task changed states.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SubmitTaskStateChange {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::submit_task_state_change_input::Builder,
    }
    impl SubmitTaskStateChange {
        /// Creates a new `SubmitTaskStateChange`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SubmitTaskStateChangeOutput,
            aws_smithy_http::result::SdkError<crate::error::SubmitTaskStateChangeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>The task ID or full ARN of the task in the state change request.</p>
        pub fn task(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task(input.into());
            self
        }
        /// <p>The task ID or full ARN of the task in the state change request.</p>
        pub fn set_task(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task(input);
            self
        }
        /// <p>The status of the state change request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status(input.into());
            self
        }
        /// <p>The status of the state change request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The reason for the state change request.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reason(input.into());
            self
        }
        /// <p>The reason for the state change request.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_reason(input);
            self
        }
        /// Appends an item to `containers`.
        ///
        /// To override the contents of this collection use [`set_containers`](Self::set_containers).
        ///
        /// <p>Any containers that's associated with the state change request.</p>
        pub fn containers(mut self, input: crate::model::ContainerStateChange) -> Self {
            self.inner = self.inner.containers(input);
            self
        }
        /// <p>Any containers that's associated with the state change request.</p>
        pub fn set_containers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContainerStateChange>>,
        ) -> Self {
            self.inner = self.inner.set_containers(input);
            self
        }
        /// Appends an item to `attachments`.
        ///
        /// To override the contents of this collection use [`set_attachments`](Self::set_attachments).
        ///
        /// <p>Any attachments associated with the state change request.</p>
        pub fn attachments(mut self, input: crate::model::AttachmentStateChange) -> Self {
            self.inner = self.inner.attachments(input);
            self
        }
        /// <p>Any attachments associated with the state change request.</p>
        pub fn set_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttachmentStateChange>>,
        ) -> Self {
            self.inner = self.inner.set_attachments(input);
            self
        }
        /// Appends an item to `managedAgents`.
        ///
        /// To override the contents of this collection use [`set_managed_agents`](Self::set_managed_agents).
        ///
        /// <p>The details for the managed agent that's associated with the task.</p>
        pub fn managed_agents(mut self, input: crate::model::ManagedAgentStateChange) -> Self {
            self.inner = self.inner.managed_agents(input);
            self
        }
        /// <p>The details for the managed agent that's associated with the task.</p>
        pub fn set_managed_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ManagedAgentStateChange>>,
        ) -> Self {
            self.inner = self.inner.set_managed_agents(input);
            self
        }
        /// <p>The Unix timestamp for the time when the container image pull started.</p>
        pub fn pull_started_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.pull_started_at(input);
            self
        }
        /// <p>The Unix timestamp for the time when the container image pull started.</p>
        pub fn set_pull_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_pull_started_at(input);
            self
        }
        /// <p>The Unix timestamp for the time when the container image pull completed.</p>
        pub fn pull_stopped_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.pull_stopped_at(input);
            self
        }
        /// <p>The Unix timestamp for the time when the container image pull completed.</p>
        pub fn set_pull_stopped_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_pull_stopped_at(input);
            self
        }
        /// <p>The Unix timestamp for the time when the task execution stopped.</p>
        pub fn execution_stopped_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.execution_stopped_at(input);
            self
        }
        /// <p>The Unix timestamp for the time when the task execution stopped.</p>
        pub fn set_execution_stopped_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_execution_stopped_at(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags that are associated with that resource are deleted as well.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to add tags to. Currently, the supported resources are Amazon ECS capacity providers, tasks, services, task definitions, clusters, and container instances.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to add tags to. Currently, the supported resources are Amazon ECS capacity providers, tasks, services, task definitions, clusters, and container instances.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li> <p>Maximum number of tags per resource - 50</p> </li>
        /// <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li>
        /// <li> <p>Maximum key length - 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length - 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li>
        /// <li> <p>Tag keys and values are case-sensitive.</p> </li>
        /// <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes specified tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to delete tags from. Currently, the supported resources are Amazon ECS capacity providers, tasks, services, task definitions, clusters, and container instances.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to delete tags from. Currently, the supported resources are Amazon ECS capacity providers, tasks, services, task definitions, clusters, and container instances.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCapacityProvider`.
    ///
    /// <p>Modifies the parameters for a capacity provider.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCapacityProvider {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_capacity_provider_input::Builder,
    }
    impl UpdateCapacityProvider {
        /// Creates a new `UpdateCapacityProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCapacityProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCapacityProviderError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the capacity provider to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the capacity provider to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An object that represent the parameters to update for the Auto Scaling group capacity provider.</p>
        pub fn auto_scaling_group_provider(
            mut self,
            input: crate::model::AutoScalingGroupProviderUpdate,
        ) -> Self {
            self.inner = self.inner.auto_scaling_group_provider(input);
            self
        }
        /// <p>An object that represent the parameters to update for the Auto Scaling group capacity provider.</p>
        pub fn set_auto_scaling_group_provider(
            mut self,
            input: std::option::Option<crate::model::AutoScalingGroupProviderUpdate>,
        ) -> Self {
            self.inner = self.inner.set_auto_scaling_group_provider(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCluster`.
    ///
    /// <p>Updates the cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_cluster_input::Builder,
    }
    impl UpdateCluster {
        /// Creates a new `UpdateCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster to modify the settings for.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The name of the cluster to modify the settings for.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// Appends an item to `settings`.
        ///
        /// To override the contents of this collection use [`set_settings`](Self::set_settings).
        ///
        /// <p>The cluster settings for your cluster.</p>
        pub fn settings(mut self, input: crate::model::ClusterSetting) -> Self {
            self.inner = self.inner.settings(input);
            self
        }
        /// <p>The cluster settings for your cluster.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterSetting>>,
        ) -> Self {
            self.inner = self.inner.set_settings(input);
            self
        }
        /// <p>The execute command configuration for the cluster.</p>
        pub fn configuration(mut self, input: crate::model::ClusterConfiguration) -> Self {
            self.inner = self.inner.configuration(input);
            self
        }
        /// <p>The execute command configuration for the cluster.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ClusterConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateClusterSettings`.
    ///
    /// <p>Modifies the settings to use for a cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateClusterSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_cluster_settings_input::Builder,
    }
    impl UpdateClusterSettings {
        /// Creates a new `UpdateClusterSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateClusterSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateClusterSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster to modify the settings for.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The name of the cluster to modify the settings for.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// Appends an item to `settings`.
        ///
        /// To override the contents of this collection use [`set_settings`](Self::set_settings).
        ///
        /// <p>The setting to use by default for a cluster. This parameter is used to turn on CloudWatch Container Insights for a cluster. If this value is specified, it overrides the <code>containerInsights</code> value set with <code>PutAccountSetting</code> or <code>PutAccountSettingDefault</code>.</p>
        pub fn settings(mut self, input: crate::model::ClusterSetting) -> Self {
            self.inner = self.inner.settings(input);
            self
        }
        /// <p>The setting to use by default for a cluster. This parameter is used to turn on CloudWatch Container Insights for a cluster. If this value is specified, it overrides the <code>containerInsights</code> value set with <code>PutAccountSetting</code> or <code>PutAccountSettingDefault</code>.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterSetting>>,
        ) -> Self {
            self.inner = self.inner.set_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContainerAgent`.
    ///
    /// <p>Updates the Amazon ECS container agent on a specified container instance. Updating the Amazon ECS container agent doesn't interrupt running tasks or services on the container instance. The process for updating the agent differs depending on whether your container instance was launched with the Amazon ECS-optimized AMI or another operating system.</p> <note>
    /// <p>The <code>UpdateContainerAgent</code> API isn't supported for container instances using the Amazon ECS-optimized Amazon Linux 2 (arm64) AMI. To update the container agent, you can update the <code>ecs-init</code> package. This updates the agent. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/agent-update-ecs-ami.html">Updating the Amazon ECS container agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// </note>
    /// <p>The <code>UpdateContainerAgent</code> API requires an Amazon ECS-optimized AMI or Amazon Linux AMI with the <code>ecs-init</code> service installed and running. For help updating the Amazon ECS container agent on other operating systems, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html#manually_update_agent">Manually updating the Amazon ECS container agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateContainerAgent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_container_agent_input::Builder,
    }
    impl UpdateContainerAgent {
        /// Creates a new `UpdateContainerAgent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContainerAgentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContainerAgentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that your container instance is running on. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that your container instance is running on. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>The container instance ID or full ARN entries for the container instance where you would like to update the Amazon ECS container agent.</p>
        pub fn container_instance(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_instance(input.into());
            self
        }
        /// <p>The container instance ID or full ARN entries for the container instance where you would like to update the Amazon ECS container agent.</p>
        pub fn set_container_instance(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_instance(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContainerInstancesState`.
    ///
    /// <p>Modifies the status of an Amazon ECS container instance.</p>
    /// <p>Once a container instance has reached an <code>ACTIVE</code> state, you can change the status of a container instance to <code>DRAINING</code> to manually remove an instance from a cluster, for example to perform system updates, update the Docker daemon, or scale down the cluster size.</p> <important>
    /// <p>A container instance can't be changed to <code>DRAINING</code> until it has reached an <code>ACTIVE</code> status. If the instance is in any other status, an error will be received.</p>
    /// </important>
    /// <p>When you set a container instance to <code>DRAINING</code>, Amazon ECS prevents new tasks from being scheduled for placement on the container instance and replacement service tasks are started on other container instances in the cluster if the resources are available. Service tasks on the container instance that are in the <code>PENDING</code> state are stopped immediately.</p>
    /// <p>Service tasks on the container instance that are in the <code>RUNNING</code> state are stopped and replaced according to the service's deployment configuration parameters, <code>minimumHealthyPercent</code> and <code>maximumPercent</code>. You can change the deployment configuration of your service using <code>UpdateService</code>.</p>
    /// <ul>
    /// <li> <p>If <code>minimumHealthyPercent</code> is below 100%, the scheduler can ignore <code>desiredCount</code> temporarily during task replacement. For example, <code>desiredCount</code> is four tasks, a minimum of 50% allows the scheduler to stop two existing tasks before starting two new tasks. If the minimum is 100%, the service scheduler can't remove existing tasks until the replacement tasks are considered healthy. Tasks for services that do not use a load balancer are considered healthy if they're in the <code>RUNNING</code> state. Tasks for services that use a load balancer are considered healthy if they're in the <code>RUNNING</code> state and are reported as healthy by the load balancer.</p> </li>
    /// <li> <p>The <code>maximumPercent</code> parameter represents an upper limit on the number of running tasks during task replacement. You can use this to define the replacement batch size. For example, if <code>desiredCount</code> is four tasks, a maximum of 200% starts four new tasks before stopping the four tasks to be drained, provided that the cluster resources required to do this are available. If the maximum is 100%, then replacement tasks can't start until the draining tasks have stopped.</p> </li>
    /// </ul>
    /// <p>Any <code>PENDING</code> or <code>RUNNING</code> tasks that do not belong to a service aren't affected. You must wait for them to finish or stop them manually.</p>
    /// <p>A container instance has completed draining when it has no more <code>RUNNING</code> tasks. You can verify this using <code>ListTasks</code>.</p>
    /// <p>When a container instance has been drained, you can set a container instance to <code>ACTIVE</code> status and once it has reached that status the Amazon ECS scheduler can begin scheduling tasks on the instance again.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateContainerInstancesState {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_container_instances_state_input::Builder,
    }
    impl UpdateContainerInstancesState {
        /// Creates a new `UpdateContainerInstancesState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContainerInstancesStateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContainerInstancesStateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instance to update. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instance to update. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// Appends an item to `containerInstances`.
        ///
        /// To override the contents of this collection use [`set_container_instances`](Self::set_container_instances).
        ///
        /// <p>A list of up to 10 container instance IDs or full ARN entries.</p>
        pub fn container_instances(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_instances(input.into());
            self
        }
        /// <p>A list of up to 10 container instance IDs or full ARN entries.</p>
        pub fn set_container_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_container_instances(input);
            self
        }
        /// <p>The container instance state to update the container instance with. The only valid values for this action are <code>ACTIVE</code> and <code>DRAINING</code>. A container instance can only be updated to <code>DRAINING</code> status once it has reached an <code>ACTIVE</code> state. If a container instance is in <code>REGISTERING</code>, <code>DEREGISTERING</code>, or <code>REGISTRATION_FAILED</code> state you can describe the container instance but can't update the container instance state.</p>
        pub fn status(mut self, input: crate::model::ContainerInstanceStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The container instance state to update the container instance with. The only valid values for this action are <code>ACTIVE</code> and <code>DRAINING</code>. A container instance can only be updated to <code>DRAINING</code> status once it has reached an <code>ACTIVE</code> state. If a container instance is in <code>REGISTERING</code>, <code>DEREGISTERING</code>, or <code>REGISTRATION_FAILED</code> state you can describe the container instance but can't update the container instance state.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ContainerInstanceStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateService`.
    ///
    /// <important>
    /// <p>Updating the task placement strategies and constraints on an Amazon ECS service remains in preview and is a Beta Service as defined by and subject to the Beta Service Participation Service Terms located at <a href="https://aws.amazon.com/service-terms">https://aws.amazon.com/service-terms</a> ("Beta Terms"). These Beta Terms apply to your participation in this preview.</p>
    /// </important>
    /// <p>Modifies the parameters of a service.</p>
    /// <p>For services using the rolling update (<code>ECS</code>) you can update the desired count, deployment configuration, network configuration, load balancers, service registries, enable ECS managed tags option, propagate tags option, task placement constraints and strategies, and task definition. When you update any of these parameters, Amazon ECS starts new tasks with the new configuration. </p>
    /// <p>For services using the blue/green (<code>CODE_DEPLOY</code>) deployment controller, only the desired count, deployment configuration, health check grace period, task placement constraints and strategies, enable ECS managed tags option, and propagate tags can be updated using this API. If the network configuration, platform version, task definition, or load balancer need to be updated, create a new CodeDeploy deployment. For more information, see <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> in the <i>CodeDeploy API Reference</i>.</p>
    /// <p>For services using an external deployment controller, you can update only the desired count, task placement constraints and strategies, health check grace period, enable ECS managed tags option, and propagate tags option, using this API. If the launch type, load balancer, network configuration, platform version, or task definition need to be updated, create a new task set For more information, see <code>CreateTaskSet</code>.</p>
    /// <p>You can add to or subtract from the number of instantiations of a task definition in a service by specifying the cluster that the service is running in and a new <code>desiredCount</code> parameter.</p>
    /// <p>If you have updated the Docker image of your application, you can create a new task definition with that image and deploy it to your service. The service scheduler uses the minimum healthy percent and maximum percent parameters (in the service's deployment configuration) to determine the deployment strategy.</p> <note>
    /// <p>If your updated Docker image uses the same tag as what is in the existing task definition for your service (for example, <code>my_image:latest</code>), you don't need to create a new revision of your task definition. You can update the service using the <code>forceNewDeployment</code> option. The new tasks launched by the deployment pull the current image/tag combination from your repository when they start.</p>
    /// </note>
    /// <p>You can also update the deployment configuration of a service. When a deployment is triggered by updating the task definition of a service, the service scheduler uses the deployment configuration parameters, <code>minimumHealthyPercent</code> and <code>maximumPercent</code>, to determine the deployment strategy.</p>
    /// <ul>
    /// <li> <p>If <code>minimumHealthyPercent</code> is below 100%, the scheduler can ignore <code>desiredCount</code> temporarily during a deployment. For example, if <code>desiredCount</code> is four tasks, a minimum of 50% allows the scheduler to stop two existing tasks before starting two new tasks. Tasks for services that don't use a load balancer are considered healthy if they're in the <code>RUNNING</code> state. Tasks for services that use a load balancer are considered healthy if they're in the <code>RUNNING</code> state and are reported as healthy by the load balancer.</p> </li>
    /// <li> <p>The <code>maximumPercent</code> parameter represents an upper limit on the number of running tasks during a deployment. You can use it to define the deployment batch size. For example, if <code>desiredCount</code> is four tasks, a maximum of 200% starts four new tasks before stopping the four older tasks (provided that the cluster resources required to do this are available).</p> </li>
    /// </ul>
    /// <p>When <code>UpdateService</code> stops a task during a deployment, the equivalent of <code>docker stop</code> is issued to the containers running in the task. This results in a <code>SIGTERM</code> and a 30-second timeout. After this, <code>SIGKILL</code> is sent and the containers are forcibly stopped. If the container handles the <code>SIGTERM</code> gracefully and exits within 30 seconds from receiving it, no <code>SIGKILL</code> is sent.</p>
    /// <p>When the service scheduler launches new tasks, it determines task placement in your cluster with the following logic.</p>
    /// <ul>
    /// <li> <p>Determine which of the container instances in your cluster can support your service's task definition. For example, they have the required CPU, memory, ports, and container instance attributes.</p> </li>
    /// <li> <p>By default, the service scheduler attempts to balance tasks across Availability Zones in this manner even though you can choose a different placement strategy.</p>
    /// <ul>
    /// <li> <p>Sort the valid container instances by the fewest number of running tasks for this service in the same Availability Zone as the instance. For example, if zone A has one running service task and zones B and C each have zero, valid container instances in either zone B or C are considered optimal for placement.</p> </li>
    /// <li> <p>Place the new service task on a valid container instance in an optimal Availability Zone (based on the previous steps), favoring container instances with the fewest number of running tasks for this service.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>When the service scheduler stops running tasks, it attempts to maintain balance across the Availability Zones in your cluster using the following logic: </p>
    /// <ul>
    /// <li> <p>Sort the container instances by the largest number of running tasks for this service in the same Availability Zone as the instance. For example, if zone A has one running service task and zones B and C each have two, container instances in either zone B or C are considered optimal for termination.</p> </li>
    /// <li> <p>Stop the task on a container instance in an optimal Availability Zone (based on the previous steps), favoring container instances with the largest number of running tasks for this service.</p> </li>
    /// </ul> <note>
    /// <p>You must have a service-linked role when you update any of the following service properties. If you specified a custom IAM role when you created the service, Amazon ECS automatically replaces the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_Service.html#ECS-Type-Service-roleArn">roleARN</a> associated with the service with the ARN of your service-linked role. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Service-linked roles</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <ul>
    /// <li> <p> <code>loadBalancers,</code> </p> </li>
    /// <li> <p> <code>serviceRegistries</code> </p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateService {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_service_input::Builder,
    }
    impl UpdateService {
        /// Creates a new `UpdateService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServiceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that your service runs on. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that your service runs on. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>The name of the service to update.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service(input.into());
            self
        }
        /// <p>The name of the service to update.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service(input);
            self
        }
        /// <p>The number of instantiations of the task to place and keep running in your service.</p>
        pub fn desired_count(mut self, input: i32) -> Self {
            self.inner = self.inner.desired_count(input);
            self
        }
        /// <p>The number of instantiations of the task to place and keep running in your service.</p>
        pub fn set_desired_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_desired_count(input);
            self
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task definition to run in your service. If a <code>revision</code> is not specified, the latest <code>ACTIVE</code> revision is used. If you modify the task definition with <code>UpdateService</code>, Amazon ECS spawns a task with the new version of the task definition and then stops an old task after the new version is running.</p>
        pub fn task_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_definition(input.into());
            self
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task definition to run in your service. If a <code>revision</code> is not specified, the latest <code>ACTIVE</code> revision is used. If you modify the task definition with <code>UpdateService</code>, Amazon ECS spawns a task with the new version of the task definition and then stops an old task after the new version is running.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_task_definition(input);
            self
        }
        /// Appends an item to `capacityProviderStrategy`.
        ///
        /// To override the contents of this collection use [`set_capacity_provider_strategy`](Self::set_capacity_provider_strategy).
        ///
        /// <p>The capacity provider strategy to update the service to use.</p>
        /// <p>if the service uses the default capacity provider strategy for the cluster, the service can be updated to use one or more capacity providers as opposed to the default capacity provider strategy. However, when a service is using a capacity provider strategy that's not the default capacity provider strategy, the service can't be updated to use the cluster's default capacity provider strategy.</p>
        /// <p>A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The <code>PutClusterCapacityProviders</code> API is used to associate a capacity provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status can be used.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the <code>CreateCapacityProvider</code> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.</p>
        /// <p>The <code>PutClusterCapacityProviders</code> API operation is used to update the list of available capacity providers for a cluster after the cluster is created.</p>
        /// <p></p>
        pub fn capacity_provider_strategy(
            mut self,
            input: crate::model::CapacityProviderStrategyItem,
        ) -> Self {
            self.inner = self.inner.capacity_provider_strategy(input);
            self
        }
        /// <p>The capacity provider strategy to update the service to use.</p>
        /// <p>if the service uses the default capacity provider strategy for the cluster, the service can be updated to use one or more capacity providers as opposed to the default capacity provider strategy. However, when a service is using a capacity provider strategy that's not the default capacity provider strategy, the service can't be updated to use the cluster's default capacity provider strategy.</p>
        /// <p>A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The <code>PutClusterCapacityProviders</code> API is used to associate a capacity provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status can be used.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the <code>CreateCapacityProvider</code> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.</p>
        /// <p>The <code>PutClusterCapacityProviders</code> API operation is used to update the list of available capacity providers for a cluster after the cluster is created.</p>
        /// <p></p>
        pub fn set_capacity_provider_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        ) -> Self {
            self.inner = self.inner.set_capacity_provider_strategy(input);
            self
        }
        /// <p>Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.</p>
        pub fn deployment_configuration(
            mut self,
            input: crate::model::DeploymentConfiguration,
        ) -> Self {
            self.inner = self.inner.deployment_configuration(input);
            self
        }
        /// <p>Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.</p>
        pub fn set_deployment_configuration(
            mut self,
            input: std::option::Option<crate::model::DeploymentConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_deployment_configuration(input);
            self
        }
        /// <p>An object representing the network configuration for the service.</p>
        pub fn network_configuration(mut self, input: crate::model::NetworkConfiguration) -> Self {
            self.inner = self.inner.network_configuration(input);
            self
        }
        /// <p>An object representing the network configuration for the service.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_network_configuration(input);
            self
        }
        /// Appends an item to `placementConstraints`.
        ///
        /// To override the contents of this collection use [`set_placement_constraints`](Self::set_placement_constraints).
        ///
        /// <p>An array of task placement constraint objects to update the service to use. If no value is specified, the existing placement constraints for the service will remain unchanged. If this value is specified, it will override any existing placement constraints defined for the service. To remove all existing placement constraints, specify an empty array.</p>
        /// <p>You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.</p>
        pub fn placement_constraints(mut self, input: crate::model::PlacementConstraint) -> Self {
            self.inner = self.inner.placement_constraints(input);
            self
        }
        /// <p>An array of task placement constraint objects to update the service to use. If no value is specified, the existing placement constraints for the service will remain unchanged. If this value is specified, it will override any existing placement constraints defined for the service. To remove all existing placement constraints, specify an empty array.</p>
        /// <p>You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.</p>
        pub fn set_placement_constraints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementConstraint>>,
        ) -> Self {
            self.inner = self.inner.set_placement_constraints(input);
            self
        }
        /// Appends an item to `placementStrategy`.
        ///
        /// To override the contents of this collection use [`set_placement_strategy`](Self::set_placement_strategy).
        ///
        /// <p>The task placement strategy objects to update the service to use. If no value is specified, the existing placement strategy for the service will remain unchanged. If this value is specified, it will override the existing placement strategy defined for the service. To remove an existing placement strategy, specify an empty object.</p>
        /// <p>You can specify a maximum of five strategy rules for each service.</p>
        pub fn placement_strategy(mut self, input: crate::model::PlacementStrategy) -> Self {
            self.inner = self.inner.placement_strategy(input);
            self
        }
        /// <p>The task placement strategy objects to update the service to use. If no value is specified, the existing placement strategy for the service will remain unchanged. If this value is specified, it will override the existing placement strategy defined for the service. To remove an existing placement strategy, specify an empty object.</p>
        /// <p>You can specify a maximum of five strategy rules for each service.</p>
        pub fn set_placement_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementStrategy>>,
        ) -> Self {
            self.inner = self.inner.set_placement_strategy(input);
            self
        }
        /// <p>The platform version that your tasks in the service run on. A platform version is only specified for tasks using the Fargate launch type. If a platform version is not specified, the <code>LATEST</code> platform version is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_version(input.into());
            self
        }
        /// <p>The platform version that your tasks in the service run on. A platform version is only specified for tasks using the Fargate launch type. If a platform version is not specified, the <code>LATEST</code> platform version is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_platform_version(input);
            self
        }
        /// <p>Determines whether to force a new deployment of the service. By default, deployments aren't forced. You can use this option to start a new deployment with no service definition changes. For example, you can update a service's tasks to use a newer Docker image with the same image/tag combination (<code>my_image:latest</code>) or to roll Fargate tasks onto a newer platform version.</p>
        pub fn force_new_deployment(mut self, input: bool) -> Self {
            self.inner = self.inner.force_new_deployment(input);
            self
        }
        /// <p>Determines whether to force a new deployment of the service. By default, deployments aren't forced. You can use this option to start a new deployment with no service definition changes. For example, you can update a service's tasks to use a newer Docker image with the same image/tag combination (<code>my_image:latest</code>) or to roll Fargate tasks onto a newer platform version.</p>
        pub fn set_force_new_deployment(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_new_deployment(input);
            self
        }
        /// <p>The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started. This is only valid if your service is configured to use a load balancer. If your service's tasks take a while to start and respond to Elastic Load Balancing health checks, you can specify a health check grace period of up to 2,147,483,647 seconds. During that time, the Amazon ECS service scheduler ignores the Elastic Load Balancing health check status. This grace period can prevent the ECS service scheduler from marking tasks as unhealthy and stopping them before they have time to come up.</p>
        pub fn health_check_grace_period_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.health_check_grace_period_seconds(input);
            self
        }
        /// <p>The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started. This is only valid if your service is configured to use a load balancer. If your service's tasks take a while to start and respond to Elastic Load Balancing health checks, you can specify a health check grace period of up to 2,147,483,647 seconds. During that time, the Amazon ECS service scheduler ignores the Elastic Load Balancing health check status. This grace period can prevent the ECS service scheduler from marking tasks as unhealthy and stopping them before they have time to come up.</p>
        pub fn set_health_check_grace_period_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_health_check_grace_period_seconds(input);
            self
        }
        /// <p>If <code>true</code>, this enables execute command functionality on all task containers.</p>
        /// <p>If you do not want to override the value that was set when the service was created, you can set this to <code>null</code> when performing this action.</p>
        pub fn enable_execute_command(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_execute_command(input);
            self
        }
        /// <p>If <code>true</code>, this enables execute command functionality on all task containers.</p>
        /// <p>If you do not want to override the value that was set when the service was created, you can set this to <code>null</code> when performing this action.</p>
        pub fn set_enable_execute_command(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_execute_command(input);
            self
        }
        /// <p>Determines whether to turn on Amazon ECS managed tags for the tasks in the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>Only tasks launched after the update will reflect the update. To update the tags on all tasks, set <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the updated tags.</p>
        pub fn enable_ecs_managed_tags(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_ecs_managed_tags(input);
            self
        }
        /// <p>Determines whether to turn on Amazon ECS managed tags for the tasks in the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>Only tasks launched after the update will reflect the update. To update the tags on all tasks, set <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the updated tags.</p>
        pub fn set_enable_ecs_managed_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_ecs_managed_tags(input);
            self
        }
        /// Appends an item to `loadBalancers`.
        ///
        /// To override the contents of this collection use [`set_load_balancers`](Self::set_load_balancers).
        ///
        /// <p>A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container name, and the container port to access from the load balancer. The container name is as it appears in a container definition.</p>
        /// <p>When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the updated Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are running.</p>
        /// <p>For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target groups. You can update from a single target group to multiple target groups and from multiple target groups to a single target group.</p>
        /// <p>For services that use blue/green deployments, you can update Elastic Load Balancing target groups by using <code> <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> </code> through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For more information see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. </p>
        /// <p>For services that use the external deployment controller, you can add, update, or remove load balancers by using <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html">CreateTaskSet</a>. Note that multiple target groups are not supported for external deployments. For more information see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. </p>
        /// <p>You can remove existing <code>loadBalancers</code> by passing an empty list.</p>
        pub fn load_balancers(mut self, input: crate::model::LoadBalancer) -> Self {
            self.inner = self.inner.load_balancers(input);
            self
        }
        /// <p>A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container name, and the container port to access from the load balancer. The container name is as it appears in a container definition.</p>
        /// <p>When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the updated Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are running.</p>
        /// <p>For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target groups. You can update from a single target group to multiple target groups and from multiple target groups to a single target group.</p>
        /// <p>For services that use blue/green deployments, you can update Elastic Load Balancing target groups by using <code> <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> </code> through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For more information see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. </p>
        /// <p>For services that use the external deployment controller, you can add, update, or remove load balancers by using <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html">CreateTaskSet</a>. Note that multiple target groups are not supported for external deployments. For more information see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. </p>
        /// <p>You can remove existing <code>loadBalancers</code> by passing an empty list.</p>
        pub fn set_load_balancers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
        ) -> Self {
            self.inner = self.inner.set_load_balancers(input);
            self
        }
        /// <p>Determines whether to propagate the tags from the task definition or the service to the task. If no value is specified, the tags aren't propagated.</p>
        /// <p>Only tasks launched after the update will reflect the update. To update the tags on all tasks, set <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the updated tags.</p>
        pub fn propagate_tags(mut self, input: crate::model::PropagateTags) -> Self {
            self.inner = self.inner.propagate_tags(input);
            self
        }
        /// <p>Determines whether to propagate the tags from the task definition or the service to the task. If no value is specified, the tags aren't propagated.</p>
        /// <p>Only tasks launched after the update will reflect the update. To update the tags on all tasks, set <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the updated tags.</p>
        pub fn set_propagate_tags(
            mut self,
            input: std::option::Option<crate::model::PropagateTags>,
        ) -> Self {
            self.inner = self.inner.set_propagate_tags(input);
            self
        }
        /// Appends an item to `serviceRegistries`.
        ///
        /// To override the contents of this collection use [`set_service_registries`](Self::set_service_registries).
        ///
        /// <p>The details for the service discovery registries to assign to this service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service Discovery</a>.</p>
        /// <p>When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with the updated service registries configuration, and then stops the old tasks when the new tasks are running.</p>
        /// <p>You can remove existing <code>serviceRegistries</code> by passing an empty list.</p>
        pub fn service_registries(mut self, input: crate::model::ServiceRegistry) -> Self {
            self.inner = self.inner.service_registries(input);
            self
        }
        /// <p>The details for the service discovery registries to assign to this service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service Discovery</a>.</p>
        /// <p>When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with the updated service registries configuration, and then stops the old tasks when the new tasks are running.</p>
        /// <p>You can remove existing <code>serviceRegistries</code> by passing an empty list.</p>
        pub fn set_service_registries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceRegistry>>,
        ) -> Self {
            self.inner = self.inner.set_service_registries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateServicePrimaryTaskSet`.
    ///
    /// <p>Modifies which task set in a service is the primary task set. Any parameters that are updated on the primary task set in a service will transition to the service. This is used when a service uses the <code>EXTERNAL</code> deployment controller type. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateServicePrimaryTaskSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_service_primary_task_set_input::Builder,
    }
    impl UpdateServicePrimaryTaskSet {
        /// Creates a new `UpdateServicePrimaryTaskSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServicePrimaryTaskSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServicePrimaryTaskSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task set exists in.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task set exists in.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service that the task set exists in.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service that the task set exists in.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service(input);
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the task set to set as the primary task set in the deployment.</p>
        pub fn primary_task_set(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.primary_task_set(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the task set to set as the primary task set in the deployment.</p>
        pub fn set_primary_task_set(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_primary_task_set(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTaskSet`.
    ///
    /// <p>Modifies a task set. This is used when a service uses the <code>EXTERNAL</code> deployment controller type. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTaskSet {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_task_set_input::Builder,
    }
    impl UpdateTaskSet {
        /// Creates a new `UpdateTaskSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTaskSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTaskSetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task set is found in.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task set is found in.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster(input);
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service that the task set is found in.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service that the task set is found in.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service(input);
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the task set to update.</p>
        pub fn task_set(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_set(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the task set to update.</p>
        pub fn set_task_set(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_set(input);
            self
        }
        /// <p>A floating-point percentage of the desired number of tasks to place and keep running in the task set.</p>
        pub fn scale(mut self, input: crate::model::Scale) -> Self {
            self.inner = self.inner.scale(input);
            self
        }
        /// <p>A floating-point percentage of the desired number of tasks to place and keep running in the task set.</p>
        pub fn set_scale(mut self, input: std::option::Option<crate::model::Scale>) -> Self {
            self.inner = self.inner.set_scale(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
