// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateCapacityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCapacityProviderError {
    /// Kind of error that occurred.
    pub kind: CreateCapacityProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCapacityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCapacityProviderErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The limit for the resource has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>There is already a current Amazon ECS container agent update in progress on the specified
    /// container instance. If the container agent becomes disconnected while it is in a
    /// transitional stage, such as <code>PENDING</code> or <code>STAGING</code>, the update
    /// process can get stuck in that state. However, when the agent reconnects, it resumes
    /// where it stopped previously.</p>
    UpdateInProgressException(crate::error::UpdateInProgressException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCapacityProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCapacityProviderErrorKind::ClientException(_inner) => _inner.fmt(f),
            CreateCapacityProviderErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateCapacityProviderErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateCapacityProviderErrorKind::ServerException(_inner) => _inner.fmt(f),
            CreateCapacityProviderErrorKind::UpdateInProgressException(_inner) => _inner.fmt(f),
            CreateCapacityProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCapacityProviderError {
    fn code(&self) -> Option<&str> {
        CreateCapacityProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCapacityProviderError {
    /// Creates a new `CreateCapacityProviderError`.
    pub fn new(kind: CreateCapacityProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCapacityProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCapacityProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCapacityProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCapacityProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCapacityProviderErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCapacityProviderErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCapacityProviderErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCapacityProviderErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCapacityProviderErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCapacityProviderErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCapacityProviderErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCapacityProviderErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCapacityProviderErrorKind::UpdateInProgressException`.
    pub fn is_update_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCapacityProviderErrorKind::UpdateInProgressException(_)
        )
    }
}
impl std::error::Error for CreateCapacityProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCapacityProviderErrorKind::ClientException(_inner) => Some(_inner),
            CreateCapacityProviderErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateCapacityProviderErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateCapacityProviderErrorKind::ServerException(_inner) => Some(_inner),
            CreateCapacityProviderErrorKind::UpdateInProgressException(_inner) => Some(_inner),
            CreateCapacityProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateClusterError {
    /// Kind of error that occurred.
    pub kind: CreateClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateClusterErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateClusterErrorKind::ClientException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ServerException(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateClusterError {
    fn code(&self) -> Option<&str> {
        CreateClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateClusterError {
    /// Creates a new `CreateClusterError`.
    pub fn new(kind: CreateClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateClusterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, CreateClusterErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, CreateClusterErrorKind::ServerException(_))
    }
}
impl std::error::Error for CreateClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateClusterErrorKind::ClientException(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateClusterErrorKind::ServerException(_inner) => Some(_inner),
            CreateClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateServiceError {
    /// Kind of error that occurred.
    pub kind: CreateServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateServiceErrorKind {
    /// <p>You do not have authorization to perform the requested action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified platform version does not satisfy the task definition's required
    /// capabilities.</p>
    PlatformTaskDefinitionIncompatibilityException(
        crate::error::PlatformTaskDefinitionIncompatibilityException,
    ),
    /// <p>The specified platform version does not exist.</p>
    PlatformUnknownException(crate::error::PlatformUnknownException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The specified task is not supported in this Region.</p>
    UnsupportedFeatureException(crate::error::UnsupportedFeatureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateServiceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::ClientException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::PlatformTaskDefinitionIncompatibilityException(_inner) => {
                _inner.fmt(f)
            }
            CreateServiceErrorKind::PlatformUnknownException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::ServerException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::UnsupportedFeatureException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateServiceError {
    fn code(&self) -> Option<&str> {
        CreateServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateServiceError {
    /// Creates a new `CreateServiceError`.
    pub fn new(kind: CreateServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateServiceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateServiceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, CreateServiceErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::PlatformTaskDefinitionIncompatibilityException`.
    pub fn is_platform_task_definition_incompatibility_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceErrorKind::PlatformTaskDefinitionIncompatibilityException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::PlatformUnknownException`.
    pub fn is_platform_unknown_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceErrorKind::PlatformUnknownException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, CreateServiceErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `CreateServiceErrorKind::UnsupportedFeatureException`.
    pub fn is_unsupported_feature_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceErrorKind::UnsupportedFeatureException(_)
        )
    }
}
impl std::error::Error for CreateServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateServiceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateServiceErrorKind::ClientException(_inner) => Some(_inner),
            CreateServiceErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            CreateServiceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateServiceErrorKind::PlatformTaskDefinitionIncompatibilityException(_inner) => {
                Some(_inner)
            }
            CreateServiceErrorKind::PlatformUnknownException(_inner) => Some(_inner),
            CreateServiceErrorKind::ServerException(_inner) => Some(_inner),
            CreateServiceErrorKind::UnsupportedFeatureException(_inner) => Some(_inner),
            CreateServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTaskSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTaskSetError {
    /// Kind of error that occurred.
    pub kind: CreateTaskSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTaskSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTaskSetErrorKind {
    /// <p>You do not have authorization to perform the requested action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified platform version does not satisfy the task definition's required
    /// capabilities.</p>
    PlatformTaskDefinitionIncompatibilityException(
        crate::error::PlatformTaskDefinitionIncompatibilityException,
    ),
    /// <p>The specified platform version does not exist.</p>
    PlatformUnknownException(crate::error::PlatformUnknownException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The specified service is not active. You can't update a service that is inactive. If
    /// you have previously deleted a service, you can re-create it with <a>CreateService</a>.</p>
    ServiceNotActiveException(crate::error::ServiceNotActiveException),
    /// <p>The specified service could not be found. You can view your available services with
    /// <a>ListServices</a>. Amazon ECS services are cluster-specific and
    /// Region-specific.</p>
    ServiceNotFoundException(crate::error::ServiceNotFoundException),
    /// <p>The specified task is not supported in this Region.</p>
    UnsupportedFeatureException(crate::error::UnsupportedFeatureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTaskSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTaskSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateTaskSetErrorKind::ClientException(_inner) => _inner.fmt(f),
            CreateTaskSetErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            CreateTaskSetErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateTaskSetErrorKind::PlatformTaskDefinitionIncompatibilityException(_inner) => {
                _inner.fmt(f)
            }
            CreateTaskSetErrorKind::PlatformUnknownException(_inner) => _inner.fmt(f),
            CreateTaskSetErrorKind::ServerException(_inner) => _inner.fmt(f),
            CreateTaskSetErrorKind::ServiceNotActiveException(_inner) => _inner.fmt(f),
            CreateTaskSetErrorKind::ServiceNotFoundException(_inner) => _inner.fmt(f),
            CreateTaskSetErrorKind::UnsupportedFeatureException(_inner) => _inner.fmt(f),
            CreateTaskSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTaskSetError {
    fn code(&self) -> Option<&str> {
        CreateTaskSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTaskSetError {
    /// Creates a new `CreateTaskSetError`.
    pub fn new(kind: CreateTaskSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTaskSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTaskSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTaskSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTaskSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTaskSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateTaskSetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateTaskSetErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, CreateTaskSetErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `CreateTaskSetErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTaskSetErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTaskSetErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTaskSetErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTaskSetErrorKind::PlatformTaskDefinitionIncompatibilityException`.
    pub fn is_platform_task_definition_incompatibility_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTaskSetErrorKind::PlatformTaskDefinitionIncompatibilityException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTaskSetErrorKind::PlatformUnknownException`.
    pub fn is_platform_unknown_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTaskSetErrorKind::PlatformUnknownException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTaskSetErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, CreateTaskSetErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `CreateTaskSetErrorKind::ServiceNotActiveException`.
    pub fn is_service_not_active_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTaskSetErrorKind::ServiceNotActiveException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTaskSetErrorKind::ServiceNotFoundException`.
    pub fn is_service_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTaskSetErrorKind::ServiceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTaskSetErrorKind::UnsupportedFeatureException`.
    pub fn is_unsupported_feature_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTaskSetErrorKind::UnsupportedFeatureException(_)
        )
    }
}
impl std::error::Error for CreateTaskSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTaskSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateTaskSetErrorKind::ClientException(_inner) => Some(_inner),
            CreateTaskSetErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            CreateTaskSetErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateTaskSetErrorKind::PlatformTaskDefinitionIncompatibilityException(_inner) => {
                Some(_inner)
            }
            CreateTaskSetErrorKind::PlatformUnknownException(_inner) => Some(_inner),
            CreateTaskSetErrorKind::ServerException(_inner) => Some(_inner),
            CreateTaskSetErrorKind::ServiceNotActiveException(_inner) => Some(_inner),
            CreateTaskSetErrorKind::ServiceNotFoundException(_inner) => Some(_inner),
            CreateTaskSetErrorKind::UnsupportedFeatureException(_inner) => Some(_inner),
            CreateTaskSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAccountSetting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAccountSettingError {
    /// Kind of error that occurred.
    pub kind: DeleteAccountSettingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAccountSetting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAccountSettingErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAccountSettingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAccountSettingErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeleteAccountSettingErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteAccountSettingErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeleteAccountSettingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAccountSettingError {
    fn code(&self) -> Option<&str> {
        DeleteAccountSettingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAccountSettingError {
    /// Creates a new `DeleteAccountSettingError`.
    pub fn new(kind: DeleteAccountSettingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAccountSettingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAccountSettingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAccountSettingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAccountSettingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAccountSettingErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountSettingErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountSettingErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountSettingErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountSettingErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountSettingErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DeleteAccountSettingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAccountSettingErrorKind::ClientException(_inner) => Some(_inner),
            DeleteAccountSettingErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteAccountSettingErrorKind::ServerException(_inner) => Some(_inner),
            DeleteAccountSettingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAttributesError {
    /// Kind of error that occurred.
    pub kind: DeleteAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAttributesErrorKind {
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified target could not be found. You can view your available container
    /// instances with <a>ListContainerInstances</a>. Amazon ECS container instances are
    /// cluster-specific and Region-specific.</p>
    TargetNotFoundException(crate::error::TargetNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAttributesErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            DeleteAttributesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteAttributesErrorKind::TargetNotFoundException(_inner) => _inner.fmt(f),
            DeleteAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAttributesError {
    fn code(&self) -> Option<&str> {
        DeleteAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAttributesError {
    /// Creates a new `DeleteAttributesError`.
    pub fn new(kind: DeleteAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAttributesErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAttributesErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAttributesErrorKind::TargetNotFoundException`.
    pub fn is_target_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAttributesErrorKind::TargetNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAttributesErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            DeleteAttributesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteAttributesErrorKind::TargetNotFoundException(_inner) => Some(_inner),
            DeleteAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCapacityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCapacityProviderError {
    /// Kind of error that occurred.
    pub kind: DeleteCapacityProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCapacityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCapacityProviderErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCapacityProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCapacityProviderErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeleteCapacityProviderErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteCapacityProviderErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeleteCapacityProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCapacityProviderError {
    fn code(&self) -> Option<&str> {
        DeleteCapacityProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCapacityProviderError {
    /// Creates a new `DeleteCapacityProviderError`.
    pub fn new(kind: DeleteCapacityProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCapacityProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCapacityProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCapacityProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCapacityProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCapacityProviderErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCapacityProviderErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCapacityProviderErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCapacityProviderErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCapacityProviderErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCapacityProviderErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DeleteCapacityProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCapacityProviderErrorKind::ClientException(_inner) => Some(_inner),
            DeleteCapacityProviderErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteCapacityProviderErrorKind::ServerException(_inner) => Some(_inner),
            DeleteCapacityProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteClusterError {
    /// Kind of error that occurred.
    pub kind: DeleteClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteClusterErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>You cannot delete a cluster that has registered container instances. First, deregister
    /// the container instances before you can delete the cluster. For more information, see
    /// <a>DeregisterContainerInstance</a>.</p>
    ClusterContainsContainerInstancesException(
        crate::error::ClusterContainsContainerInstancesException,
    ),
    /// <p>You cannot delete a cluster that contains services. First, update the service to
    /// reduce its desired task count to 0 and then delete the service. For more information,
    /// see <a>UpdateService</a> and <a>DeleteService</a>.</p>
    ClusterContainsServicesException(crate::error::ClusterContainsServicesException),
    /// <p>You cannot delete a cluster that has active tasks.</p>
    ClusterContainsTasksException(crate::error::ClusterContainsTasksException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>There is already a current Amazon ECS container agent update in progress on the specified
    /// container instance. If the container agent becomes disconnected while it is in a
    /// transitional stage, such as <code>PENDING</code> or <code>STAGING</code>, the update
    /// process can get stuck in that state. However, when the agent reconnects, it resumes
    /// where it stopped previously.</p>
    UpdateInProgressException(crate::error::UpdateInProgressException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteClusterErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::ClusterContainsContainerInstancesException(_inner) => {
                _inner.fmt(f)
            }
            DeleteClusterErrorKind::ClusterContainsServicesException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::ClusterContainsTasksException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::UpdateInProgressException(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteClusterError {
    fn code(&self) -> Option<&str> {
        DeleteClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteClusterError {
    /// Creates a new `DeleteClusterError`.
    pub fn new(kind: DeleteClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteClusterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DeleteClusterErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ClusterContainsContainerInstancesException`.
    pub fn is_cluster_contains_container_instances_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::ClusterContainsContainerInstancesException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ClusterContainsServicesException`.
    pub fn is_cluster_contains_services_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::ClusterContainsServicesException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ClusterContainsTasksException`.
    pub fn is_cluster_contains_tasks_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::ClusterContainsTasksException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteClusterErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::UpdateInProgressException`.
    pub fn is_update_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::UpdateInProgressException(_)
        )
    }
}
impl std::error::Error for DeleteClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteClusterErrorKind::ClientException(_inner) => Some(_inner),
            DeleteClusterErrorKind::ClusterContainsContainerInstancesException(_inner) => {
                Some(_inner)
            }
            DeleteClusterErrorKind::ClusterContainsServicesException(_inner) => Some(_inner),
            DeleteClusterErrorKind::ClusterContainsTasksException(_inner) => Some(_inner),
            DeleteClusterErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            DeleteClusterErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteClusterErrorKind::ServerException(_inner) => Some(_inner),
            DeleteClusterErrorKind::UpdateInProgressException(_inner) => Some(_inner),
            DeleteClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteServiceError {
    /// Kind of error that occurred.
    pub kind: DeleteServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteServiceErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The specified service could not be found. You can view your available services with
    /// <a>ListServices</a>. Amazon ECS services are cluster-specific and
    /// Region-specific.</p>
    ServiceNotFoundException(crate::error::ServiceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteServiceErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::ServiceNotFoundException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteServiceError {
    fn code(&self) -> Option<&str> {
        DeleteServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteServiceError {
    /// Creates a new `DeleteServiceError`.
    pub fn new(kind: DeleteServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteServiceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DeleteServiceErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteServiceErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteServiceErrorKind::ServiceNotFoundException`.
    pub fn is_service_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceErrorKind::ServiceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteServiceErrorKind::ClientException(_inner) => Some(_inner),
            DeleteServiceErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            DeleteServiceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteServiceErrorKind::ServerException(_inner) => Some(_inner),
            DeleteServiceErrorKind::ServiceNotFoundException(_inner) => Some(_inner),
            DeleteServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTaskSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTaskSetError {
    /// Kind of error that occurred.
    pub kind: DeleteTaskSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTaskSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTaskSetErrorKind {
    /// <p>You do not have authorization to perform the requested action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The specified service is not active. You can't update a service that is inactive. If
    /// you have previously deleted a service, you can re-create it with <a>CreateService</a>.</p>
    ServiceNotActiveException(crate::error::ServiceNotActiveException),
    /// <p>The specified service could not be found. You can view your available services with
    /// <a>ListServices</a>. Amazon ECS services are cluster-specific and
    /// Region-specific.</p>
    ServiceNotFoundException(crate::error::ServiceNotFoundException),
    /// <p>The specified task set could not be found. You can view your available task sets with
    /// <a>DescribeTaskSets</a>. Task sets are specific to each cluster, service
    /// and Region.</p>
    TaskSetNotFoundException(crate::error::TaskSetNotFoundException),
    /// <p>The specified task is not supported in this Region.</p>
    UnsupportedFeatureException(crate::error::UnsupportedFeatureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTaskSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTaskSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteTaskSetErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeleteTaskSetErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            DeleteTaskSetErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteTaskSetErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeleteTaskSetErrorKind::ServiceNotActiveException(_inner) => _inner.fmt(f),
            DeleteTaskSetErrorKind::ServiceNotFoundException(_inner) => _inner.fmt(f),
            DeleteTaskSetErrorKind::TaskSetNotFoundException(_inner) => _inner.fmt(f),
            DeleteTaskSetErrorKind::UnsupportedFeatureException(_inner) => _inner.fmt(f),
            DeleteTaskSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTaskSetError {
    fn code(&self) -> Option<&str> {
        DeleteTaskSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTaskSetError {
    /// Creates a new `DeleteTaskSetError`.
    pub fn new(kind: DeleteTaskSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTaskSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTaskSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTaskSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTaskSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTaskSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteTaskSetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteTaskSetErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DeleteTaskSetErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DeleteTaskSetErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTaskSetErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTaskSetErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTaskSetErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTaskSetErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteTaskSetErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteTaskSetErrorKind::ServiceNotActiveException`.
    pub fn is_service_not_active_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTaskSetErrorKind::ServiceNotActiveException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTaskSetErrorKind::ServiceNotFoundException`.
    pub fn is_service_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTaskSetErrorKind::ServiceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTaskSetErrorKind::TaskSetNotFoundException`.
    pub fn is_task_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTaskSetErrorKind::TaskSetNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTaskSetErrorKind::UnsupportedFeatureException`.
    pub fn is_unsupported_feature_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTaskSetErrorKind::UnsupportedFeatureException(_)
        )
    }
}
impl std::error::Error for DeleteTaskSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTaskSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteTaskSetErrorKind::ClientException(_inner) => Some(_inner),
            DeleteTaskSetErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            DeleteTaskSetErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteTaskSetErrorKind::ServerException(_inner) => Some(_inner),
            DeleteTaskSetErrorKind::ServiceNotActiveException(_inner) => Some(_inner),
            DeleteTaskSetErrorKind::ServiceNotFoundException(_inner) => Some(_inner),
            DeleteTaskSetErrorKind::TaskSetNotFoundException(_inner) => Some(_inner),
            DeleteTaskSetErrorKind::UnsupportedFeatureException(_inner) => Some(_inner),
            DeleteTaskSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterContainerInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterContainerInstanceError {
    /// Kind of error that occurred.
    pub kind: DeregisterContainerInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterContainerInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterContainerInstanceErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterContainerInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterContainerInstanceErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeregisterContainerInstanceErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            DeregisterContainerInstanceErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterContainerInstanceErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeregisterContainerInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterContainerInstanceError {
    fn code(&self) -> Option<&str> {
        DeregisterContainerInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterContainerInstanceError {
    /// Creates a new `DeregisterContainerInstanceError`.
    pub fn new(kind: DeregisterContainerInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterContainerInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterContainerInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterContainerInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterContainerInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterContainerInstanceErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterContainerInstanceErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterContainerInstanceErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterContainerInstanceErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterContainerInstanceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterContainerInstanceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterContainerInstanceErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterContainerInstanceErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DeregisterContainerInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterContainerInstanceErrorKind::ClientException(_inner) => Some(_inner),
            DeregisterContainerInstanceErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            DeregisterContainerInstanceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeregisterContainerInstanceErrorKind::ServerException(_inner) => Some(_inner),
            DeregisterContainerInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterTaskDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterTaskDefinitionError {
    /// Kind of error that occurred.
    pub kind: DeregisterTaskDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterTaskDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterTaskDefinitionErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterTaskDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterTaskDefinitionErrorKind::ClientException(_inner) => _inner.fmt(f),
            DeregisterTaskDefinitionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeregisterTaskDefinitionErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeregisterTaskDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterTaskDefinitionError {
    fn code(&self) -> Option<&str> {
        DeregisterTaskDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterTaskDefinitionError {
    /// Creates a new `DeregisterTaskDefinitionError`.
    pub fn new(kind: DeregisterTaskDefinitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterTaskDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterTaskDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterTaskDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterTaskDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterTaskDefinitionErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterTaskDefinitionErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterTaskDefinitionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterTaskDefinitionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterTaskDefinitionErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterTaskDefinitionErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DeregisterTaskDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterTaskDefinitionErrorKind::ClientException(_inner) => Some(_inner),
            DeregisterTaskDefinitionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeregisterTaskDefinitionErrorKind::ServerException(_inner) => Some(_inner),
            DeregisterTaskDefinitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCapacityProviders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCapacityProvidersError {
    /// Kind of error that occurred.
    pub kind: DescribeCapacityProvidersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCapacityProviders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCapacityProvidersErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCapacityProvidersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCapacityProvidersErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeCapacityProvidersErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeCapacityProvidersErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeCapacityProvidersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCapacityProvidersError {
    fn code(&self) -> Option<&str> {
        DescribeCapacityProvidersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCapacityProvidersError {
    /// Creates a new `DescribeCapacityProvidersError`.
    pub fn new(kind: DescribeCapacityProvidersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCapacityProvidersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCapacityProvidersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCapacityProvidersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCapacityProvidersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCapacityProvidersErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCapacityProvidersErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCapacityProvidersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCapacityProvidersErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCapacityProvidersErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCapacityProvidersErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DescribeCapacityProvidersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCapacityProvidersErrorKind::ClientException(_inner) => Some(_inner),
            DescribeCapacityProvidersErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeCapacityProvidersErrorKind::ServerException(_inner) => Some(_inner),
            DescribeCapacityProvidersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClustersError {
    /// Kind of error that occurred.
    pub kind: DescribeClustersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClustersErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClustersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClustersErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeClustersErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeClustersErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeClustersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClustersError {
    fn code(&self) -> Option<&str> {
        DescribeClustersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClustersError {
    /// Creates a new `DescribeClustersError`.
    pub fn new(kind: DescribeClustersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClustersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClustersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClustersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClustersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeClustersErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DescribeClustersErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DescribeClustersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClustersErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClustersErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DescribeClustersErrorKind::ServerException(_))
    }
}
impl std::error::Error for DescribeClustersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClustersErrorKind::ClientException(_inner) => Some(_inner),
            DescribeClustersErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeClustersErrorKind::ServerException(_inner) => Some(_inner),
            DescribeClustersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeContainerInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeContainerInstancesError {
    /// Kind of error that occurred.
    pub kind: DescribeContainerInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeContainerInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeContainerInstancesErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeContainerInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeContainerInstancesErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeContainerInstancesErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            DescribeContainerInstancesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeContainerInstancesErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeContainerInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeContainerInstancesError {
    fn code(&self) -> Option<&str> {
        DescribeContainerInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeContainerInstancesError {
    /// Creates a new `DescribeContainerInstancesError`.
    pub fn new(kind: DescribeContainerInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeContainerInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeContainerInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeContainerInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeContainerInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeContainerInstancesErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContainerInstancesErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeContainerInstancesErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContainerInstancesErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeContainerInstancesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContainerInstancesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeContainerInstancesErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContainerInstancesErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DescribeContainerInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeContainerInstancesErrorKind::ClientException(_inner) => Some(_inner),
            DescribeContainerInstancesErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            DescribeContainerInstancesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeContainerInstancesErrorKind::ServerException(_inner) => Some(_inner),
            DescribeContainerInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeServicesError {
    /// Kind of error that occurred.
    pub kind: DescribeServicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeServicesErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeServicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeServicesErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeServicesErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            DescribeServicesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeServicesErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeServicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeServicesError {
    fn code(&self) -> Option<&str> {
        DescribeServicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeServicesError {
    /// Creates a new `DescribeServicesError`.
    pub fn new(kind: DescribeServicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeServicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeServicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeServicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeServicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeServicesErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DescribeServicesErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DescribeServicesErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServicesErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeServicesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServicesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeServicesErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DescribeServicesErrorKind::ServerException(_))
    }
}
impl std::error::Error for DescribeServicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeServicesErrorKind::ClientException(_inner) => Some(_inner),
            DescribeServicesErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            DescribeServicesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeServicesErrorKind::ServerException(_inner) => Some(_inner),
            DescribeServicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTaskDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTaskDefinitionError {
    /// Kind of error that occurred.
    pub kind: DescribeTaskDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTaskDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTaskDefinitionErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTaskDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTaskDefinitionErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeTaskDefinitionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeTaskDefinitionErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeTaskDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTaskDefinitionError {
    fn code(&self) -> Option<&str> {
        DescribeTaskDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTaskDefinitionError {
    /// Creates a new `DescribeTaskDefinitionError`.
    pub fn new(kind: DescribeTaskDefinitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTaskDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTaskDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTaskDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTaskDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTaskDefinitionErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTaskDefinitionErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTaskDefinitionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTaskDefinitionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTaskDefinitionErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTaskDefinitionErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DescribeTaskDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTaskDefinitionErrorKind::ClientException(_inner) => Some(_inner),
            DescribeTaskDefinitionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeTaskDefinitionErrorKind::ServerException(_inner) => Some(_inner),
            DescribeTaskDefinitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTasksError {
    /// Kind of error that occurred.
    pub kind: DescribeTasksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTasksErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTasksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTasksErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeTasksErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            DescribeTasksErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeTasksErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeTasksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTasksError {
    fn code(&self) -> Option<&str> {
        DescribeTasksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTasksError {
    /// Creates a new `DescribeTasksError`.
    pub fn new(kind: DescribeTasksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTasksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTasksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTasksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTasksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTasksErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DescribeTasksErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DescribeTasksErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTasksErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTasksErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTasksErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTasksErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DescribeTasksErrorKind::ServerException(_))
    }
}
impl std::error::Error for DescribeTasksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTasksErrorKind::ClientException(_inner) => Some(_inner),
            DescribeTasksErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            DescribeTasksErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeTasksErrorKind::ServerException(_inner) => Some(_inner),
            DescribeTasksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTaskSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTaskSetsError {
    /// Kind of error that occurred.
    pub kind: DescribeTaskSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTaskSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTaskSetsErrorKind {
    /// <p>You do not have authorization to perform the requested action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The specified service is not active. You can't update a service that is inactive. If
    /// you have previously deleted a service, you can re-create it with <a>CreateService</a>.</p>
    ServiceNotActiveException(crate::error::ServiceNotActiveException),
    /// <p>The specified service could not be found. You can view your available services with
    /// <a>ListServices</a>. Amazon ECS services are cluster-specific and
    /// Region-specific.</p>
    ServiceNotFoundException(crate::error::ServiceNotFoundException),
    /// <p>The specified task is not supported in this Region.</p>
    UnsupportedFeatureException(crate::error::UnsupportedFeatureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTaskSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTaskSetsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeTaskSetsErrorKind::ClientException(_inner) => _inner.fmt(f),
            DescribeTaskSetsErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            DescribeTaskSetsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeTaskSetsErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeTaskSetsErrorKind::ServiceNotActiveException(_inner) => _inner.fmt(f),
            DescribeTaskSetsErrorKind::ServiceNotFoundException(_inner) => _inner.fmt(f),
            DescribeTaskSetsErrorKind::UnsupportedFeatureException(_inner) => _inner.fmt(f),
            DescribeTaskSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTaskSetsError {
    fn code(&self) -> Option<&str> {
        DescribeTaskSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTaskSetsError {
    /// Creates a new `DescribeTaskSetsError`.
    pub fn new(kind: DescribeTaskSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTaskSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTaskSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTaskSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTaskSetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTaskSetsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTaskSetsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTaskSetsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, DescribeTaskSetsErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `DescribeTaskSetsErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTaskSetsErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTaskSetsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTaskSetsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTaskSetsErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DescribeTaskSetsErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `DescribeTaskSetsErrorKind::ServiceNotActiveException`.
    pub fn is_service_not_active_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTaskSetsErrorKind::ServiceNotActiveException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTaskSetsErrorKind::ServiceNotFoundException`.
    pub fn is_service_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTaskSetsErrorKind::ServiceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTaskSetsErrorKind::UnsupportedFeatureException`.
    pub fn is_unsupported_feature_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTaskSetsErrorKind::UnsupportedFeatureException(_)
        )
    }
}
impl std::error::Error for DescribeTaskSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTaskSetsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeTaskSetsErrorKind::ClientException(_inner) => Some(_inner),
            DescribeTaskSetsErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            DescribeTaskSetsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeTaskSetsErrorKind::ServerException(_inner) => Some(_inner),
            DescribeTaskSetsErrorKind::ServiceNotActiveException(_inner) => Some(_inner),
            DescribeTaskSetsErrorKind::ServiceNotFoundException(_inner) => Some(_inner),
            DescribeTaskSetsErrorKind::UnsupportedFeatureException(_inner) => Some(_inner),
            DescribeTaskSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DiscoverPollEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DiscoverPollEndpointError {
    /// Kind of error that occurred.
    pub kind: DiscoverPollEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DiscoverPollEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DiscoverPollEndpointErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DiscoverPollEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DiscoverPollEndpointErrorKind::ClientException(_inner) => _inner.fmt(f),
            DiscoverPollEndpointErrorKind::ServerException(_inner) => _inner.fmt(f),
            DiscoverPollEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DiscoverPollEndpointError {
    fn code(&self) -> Option<&str> {
        DiscoverPollEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DiscoverPollEndpointError {
    /// Creates a new `DiscoverPollEndpointError`.
    pub fn new(kind: DiscoverPollEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DiscoverPollEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DiscoverPollEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DiscoverPollEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DiscoverPollEndpointErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DiscoverPollEndpointErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            DiscoverPollEndpointErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `DiscoverPollEndpointErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DiscoverPollEndpointErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DiscoverPollEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DiscoverPollEndpointErrorKind::ClientException(_inner) => Some(_inner),
            DiscoverPollEndpointErrorKind::ServerException(_inner) => Some(_inner),
            DiscoverPollEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExecuteCommand` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExecuteCommandError {
    /// Kind of error that occurred.
    pub kind: ExecuteCommandErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExecuteCommand` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExecuteCommandErrorKind {
    /// <p>You do not have authorization to perform the requested action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The target container is not properly configured with the execute command agent or the
    /// container is no longer active or running.</p>
    TargetNotConnectedException(crate::error::TargetNotConnectedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExecuteCommandError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExecuteCommandErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ExecuteCommandErrorKind::ClientException(_inner) => _inner.fmt(f),
            ExecuteCommandErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            ExecuteCommandErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ExecuteCommandErrorKind::ServerException(_inner) => _inner.fmt(f),
            ExecuteCommandErrorKind::TargetNotConnectedException(_inner) => _inner.fmt(f),
            ExecuteCommandErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExecuteCommandError {
    fn code(&self) -> Option<&str> {
        ExecuteCommandError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExecuteCommandError {
    /// Creates a new `ExecuteCommandError`.
    pub fn new(kind: ExecuteCommandErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExecuteCommandError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExecuteCommandErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExecuteCommandError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExecuteCommandErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ExecuteCommandErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteCommandErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteCommandErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ExecuteCommandErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ExecuteCommandErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteCommandErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteCommandErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteCommandErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteCommandErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, ExecuteCommandErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `ExecuteCommandErrorKind::TargetNotConnectedException`.
    pub fn is_target_not_connected_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteCommandErrorKind::TargetNotConnectedException(_)
        )
    }
}
impl std::error::Error for ExecuteCommandError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExecuteCommandErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ExecuteCommandErrorKind::ClientException(_inner) => Some(_inner),
            ExecuteCommandErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            ExecuteCommandErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ExecuteCommandErrorKind::ServerException(_inner) => Some(_inner),
            ExecuteCommandErrorKind::TargetNotConnectedException(_inner) => Some(_inner),
            ExecuteCommandErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAccountSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAccountSettingsError {
    /// Kind of error that occurred.
    pub kind: ListAccountSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAccountSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAccountSettingsErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAccountSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAccountSettingsErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListAccountSettingsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListAccountSettingsErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListAccountSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAccountSettingsError {
    fn code(&self) -> Option<&str> {
        ListAccountSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAccountSettingsError {
    /// Creates a new `ListAccountSettingsError`.
    pub fn new(kind: ListAccountSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAccountSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAccountSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAccountSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAccountSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAccountSettingsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ListAccountSettingsErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ListAccountSettingsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountSettingsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccountSettingsErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, ListAccountSettingsErrorKind::ServerException(_))
    }
}
impl std::error::Error for ListAccountSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAccountSettingsErrorKind::ClientException(_inner) => Some(_inner),
            ListAccountSettingsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListAccountSettingsErrorKind::ServerException(_inner) => Some(_inner),
            ListAccountSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAttributesError {
    /// Kind of error that occurred.
    pub kind: ListAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAttributesErrorKind {
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAttributesErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            ListAttributesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAttributesError {
    fn code(&self) -> Option<&str> {
        ListAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAttributesError {
    /// Creates a new `ListAttributesError`.
    pub fn new(kind: ListAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAttributesErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttributesErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttributesErrorKind::InvalidParameterException(_)
        )
    }
}
impl std::error::Error for ListAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAttributesErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            ListAttributesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListClustersError {
    /// Kind of error that occurred.
    pub kind: ListClustersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListClustersErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListClustersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListClustersErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListClustersErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListClustersErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListClustersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListClustersError {
    fn code(&self) -> Option<&str> {
        ListClustersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListClustersError {
    /// Creates a new `ListClustersError`.
    pub fn new(kind: ListClustersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListClustersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListClustersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListClustersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListClustersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListClustersErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ListClustersErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ListClustersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClustersErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListClustersErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, ListClustersErrorKind::ServerException(_))
    }
}
impl std::error::Error for ListClustersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListClustersErrorKind::ClientException(_inner) => Some(_inner),
            ListClustersErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListClustersErrorKind::ServerException(_inner) => Some(_inner),
            ListClustersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListContainerInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListContainerInstancesError {
    /// Kind of error that occurred.
    pub kind: ListContainerInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListContainerInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListContainerInstancesErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListContainerInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListContainerInstancesErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListContainerInstancesErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            ListContainerInstancesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListContainerInstancesErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListContainerInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListContainerInstancesError {
    fn code(&self) -> Option<&str> {
        ListContainerInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListContainerInstancesError {
    /// Creates a new `ListContainerInstancesError`.
    pub fn new(kind: ListContainerInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListContainerInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListContainerInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListContainerInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListContainerInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListContainerInstancesErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContainerInstancesErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListContainerInstancesErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContainerInstancesErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListContainerInstancesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContainerInstancesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListContainerInstancesErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContainerInstancesErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for ListContainerInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListContainerInstancesErrorKind::ClientException(_inner) => Some(_inner),
            ListContainerInstancesErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            ListContainerInstancesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListContainerInstancesErrorKind::ServerException(_inner) => Some(_inner),
            ListContainerInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServicesError {
    /// Kind of error that occurred.
    pub kind: ListServicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServicesErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServicesErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServicesError {
    fn code(&self) -> Option<&str> {
        ListServicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListServicesError {
    /// Creates a new `ListServicesError`.
    pub fn new(kind: ListServicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ListServicesErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicesErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServicesErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, ListServicesErrorKind::ServerException(_))
    }
}
impl std::error::Error for ListServicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServicesErrorKind::ClientException(_inner) => Some(_inner),
            ListServicesErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            ListServicesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListServicesErrorKind::ServerException(_inner) => Some(_inner),
            ListServicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ListTagsForResourceErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, ListTagsForResourceErrorKind::ServerException(_))
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::ClientException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTaskDefinitionFamilies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTaskDefinitionFamiliesError {
    /// Kind of error that occurred.
    pub kind: ListTaskDefinitionFamiliesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTaskDefinitionFamilies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTaskDefinitionFamiliesErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTaskDefinitionFamiliesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTaskDefinitionFamiliesErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListTaskDefinitionFamiliesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListTaskDefinitionFamiliesErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListTaskDefinitionFamiliesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTaskDefinitionFamiliesError {
    fn code(&self) -> Option<&str> {
        ListTaskDefinitionFamiliesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTaskDefinitionFamiliesError {
    /// Creates a new `ListTaskDefinitionFamiliesError`.
    pub fn new(kind: ListTaskDefinitionFamiliesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTaskDefinitionFamiliesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTaskDefinitionFamiliesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTaskDefinitionFamiliesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTaskDefinitionFamiliesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTaskDefinitionFamiliesErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTaskDefinitionFamiliesErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTaskDefinitionFamiliesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTaskDefinitionFamiliesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTaskDefinitionFamiliesErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTaskDefinitionFamiliesErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for ListTaskDefinitionFamiliesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTaskDefinitionFamiliesErrorKind::ClientException(_inner) => Some(_inner),
            ListTaskDefinitionFamiliesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListTaskDefinitionFamiliesErrorKind::ServerException(_inner) => Some(_inner),
            ListTaskDefinitionFamiliesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTaskDefinitions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTaskDefinitionsError {
    /// Kind of error that occurred.
    pub kind: ListTaskDefinitionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTaskDefinitions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTaskDefinitionsErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTaskDefinitionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTaskDefinitionsErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListTaskDefinitionsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListTaskDefinitionsErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListTaskDefinitionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTaskDefinitionsError {
    fn code(&self) -> Option<&str> {
        ListTaskDefinitionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTaskDefinitionsError {
    /// Creates a new `ListTaskDefinitionsError`.
    pub fn new(kind: ListTaskDefinitionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTaskDefinitionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTaskDefinitionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTaskDefinitionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTaskDefinitionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTaskDefinitionsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ListTaskDefinitionsErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ListTaskDefinitionsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTaskDefinitionsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTaskDefinitionsErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, ListTaskDefinitionsErrorKind::ServerException(_))
    }
}
impl std::error::Error for ListTaskDefinitionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTaskDefinitionsErrorKind::ClientException(_inner) => Some(_inner),
            ListTaskDefinitionsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListTaskDefinitionsErrorKind::ServerException(_inner) => Some(_inner),
            ListTaskDefinitionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTasksError {
    /// Kind of error that occurred.
    pub kind: ListTasksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTasksErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The specified service could not be found. You can view your available services with
    /// <a>ListServices</a>. Amazon ECS services are cluster-specific and
    /// Region-specific.</p>
    ServiceNotFoundException(crate::error::ServiceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTasksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTasksErrorKind::ClientException(_inner) => _inner.fmt(f),
            ListTasksErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            ListTasksErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListTasksErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListTasksErrorKind::ServiceNotFoundException(_inner) => _inner.fmt(f),
            ListTasksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTasksError {
    fn code(&self) -> Option<&str> {
        ListTasksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTasksError {
    /// Creates a new `ListTasksError`.
    pub fn new(kind: ListTasksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTasksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTasksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTasksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTasksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTasksErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, ListTasksErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `ListTasksErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListTasksErrorKind::ClusterNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListTasksErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, ListTasksErrorKind::InvalidParameterException(_))
    }
    /// Returns `true` if the error kind is `ListTasksErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, ListTasksErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `ListTasksErrorKind::ServiceNotFoundException`.
    pub fn is_service_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListTasksErrorKind::ServiceNotFoundException(_))
    }
}
impl std::error::Error for ListTasksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTasksErrorKind::ClientException(_inner) => Some(_inner),
            ListTasksErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            ListTasksErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListTasksErrorKind::ServerException(_inner) => Some(_inner),
            ListTasksErrorKind::ServiceNotFoundException(_inner) => Some(_inner),
            ListTasksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutAccountSetting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutAccountSettingError {
    /// Kind of error that occurred.
    pub kind: PutAccountSettingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutAccountSetting` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutAccountSettingErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutAccountSettingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutAccountSettingErrorKind::ClientException(_inner) => _inner.fmt(f),
            PutAccountSettingErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutAccountSettingErrorKind::ServerException(_inner) => _inner.fmt(f),
            PutAccountSettingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutAccountSettingError {
    fn code(&self) -> Option<&str> {
        PutAccountSettingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutAccountSettingError {
    /// Creates a new `PutAccountSettingError`.
    pub fn new(kind: PutAccountSettingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutAccountSettingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutAccountSettingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutAccountSettingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutAccountSettingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutAccountSettingErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, PutAccountSettingErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `PutAccountSettingErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAccountSettingErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAccountSettingErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, PutAccountSettingErrorKind::ServerException(_))
    }
}
impl std::error::Error for PutAccountSettingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutAccountSettingErrorKind::ClientException(_inner) => Some(_inner),
            PutAccountSettingErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutAccountSettingErrorKind::ServerException(_inner) => Some(_inner),
            PutAccountSettingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutAccountSettingDefault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutAccountSettingDefaultError {
    /// Kind of error that occurred.
    pub kind: PutAccountSettingDefaultErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutAccountSettingDefault` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutAccountSettingDefaultErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutAccountSettingDefaultError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutAccountSettingDefaultErrorKind::ClientException(_inner) => _inner.fmt(f),
            PutAccountSettingDefaultErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutAccountSettingDefaultErrorKind::ServerException(_inner) => _inner.fmt(f),
            PutAccountSettingDefaultErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutAccountSettingDefaultError {
    fn code(&self) -> Option<&str> {
        PutAccountSettingDefaultError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutAccountSettingDefaultError {
    /// Creates a new `PutAccountSettingDefaultError`.
    pub fn new(kind: PutAccountSettingDefaultErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutAccountSettingDefaultError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutAccountSettingDefaultErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutAccountSettingDefaultError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutAccountSettingDefaultErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutAccountSettingDefaultErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAccountSettingDefaultErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAccountSettingDefaultErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAccountSettingDefaultErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAccountSettingDefaultErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAccountSettingDefaultErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for PutAccountSettingDefaultError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutAccountSettingDefaultErrorKind::ClientException(_inner) => Some(_inner),
            PutAccountSettingDefaultErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutAccountSettingDefaultErrorKind::ServerException(_inner) => Some(_inner),
            PutAccountSettingDefaultErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutAttributesError {
    /// Kind of error that occurred.
    pub kind: PutAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutAttributesErrorKind {
    /// <p>You can apply up to 10 custom attributes per resource. You can view the attributes of
    /// a resource with <a>ListAttributes</a>. You can remove existing attributes on
    /// a resource with <a>DeleteAttributes</a>.</p>
    AttributeLimitExceededException(crate::error::AttributeLimitExceededException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified target could not be found. You can view your available container
    /// instances with <a>ListContainerInstances</a>. Amazon ECS container instances are
    /// cluster-specific and Region-specific.</p>
    TargetNotFoundException(crate::error::TargetNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutAttributesErrorKind::AttributeLimitExceededException(_inner) => _inner.fmt(f),
            PutAttributesErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            PutAttributesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutAttributesErrorKind::TargetNotFoundException(_inner) => _inner.fmt(f),
            PutAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutAttributesError {
    fn code(&self) -> Option<&str> {
        PutAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutAttributesError {
    /// Creates a new `PutAttributesError`.
    pub fn new(kind: PutAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutAttributesErrorKind::AttributeLimitExceededException`.
    pub fn is_attribute_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAttributesErrorKind::AttributeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAttributesErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAttributesErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAttributesErrorKind::TargetNotFoundException`.
    pub fn is_target_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAttributesErrorKind::TargetNotFoundException(_)
        )
    }
}
impl std::error::Error for PutAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutAttributesErrorKind::AttributeLimitExceededException(_inner) => Some(_inner),
            PutAttributesErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            PutAttributesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutAttributesErrorKind::TargetNotFoundException(_inner) => Some(_inner),
            PutAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutClusterCapacityProviders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutClusterCapacityProvidersError {
    /// Kind of error that occurred.
    pub kind: PutClusterCapacityProvidersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutClusterCapacityProviders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutClusterCapacityProvidersErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource is in-use and cannot be removed.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>There is already a current Amazon ECS container agent update in progress on the specified
    /// container instance. If the container agent becomes disconnected while it is in a
    /// transitional stage, such as <code>PENDING</code> or <code>STAGING</code>, the update
    /// process can get stuck in that state. However, when the agent reconnects, it resumes
    /// where it stopped previously.</p>
    UpdateInProgressException(crate::error::UpdateInProgressException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutClusterCapacityProvidersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutClusterCapacityProvidersErrorKind::ClientException(_inner) => _inner.fmt(f),
            PutClusterCapacityProvidersErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            PutClusterCapacityProvidersErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            PutClusterCapacityProvidersErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            PutClusterCapacityProvidersErrorKind::ServerException(_inner) => _inner.fmt(f),
            PutClusterCapacityProvidersErrorKind::UpdateInProgressException(_inner) => {
                _inner.fmt(f)
            }
            PutClusterCapacityProvidersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutClusterCapacityProvidersError {
    fn code(&self) -> Option<&str> {
        PutClusterCapacityProvidersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutClusterCapacityProvidersError {
    /// Creates a new `PutClusterCapacityProvidersError`.
    pub fn new(kind: PutClusterCapacityProvidersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutClusterCapacityProvidersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutClusterCapacityProvidersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutClusterCapacityProvidersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutClusterCapacityProvidersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutClusterCapacityProvidersErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutClusterCapacityProvidersErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `PutClusterCapacityProvidersErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutClusterCapacityProvidersErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutClusterCapacityProvidersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutClusterCapacityProvidersErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutClusterCapacityProvidersErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutClusterCapacityProvidersErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `PutClusterCapacityProvidersErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutClusterCapacityProvidersErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutClusterCapacityProvidersErrorKind::UpdateInProgressException`.
    pub fn is_update_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutClusterCapacityProvidersErrorKind::UpdateInProgressException(_)
        )
    }
}
impl std::error::Error for PutClusterCapacityProvidersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutClusterCapacityProvidersErrorKind::ClientException(_inner) => Some(_inner),
            PutClusterCapacityProvidersErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            PutClusterCapacityProvidersErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutClusterCapacityProvidersErrorKind::ResourceInUseException(_inner) => Some(_inner),
            PutClusterCapacityProvidersErrorKind::ServerException(_inner) => Some(_inner),
            PutClusterCapacityProvidersErrorKind::UpdateInProgressException(_inner) => Some(_inner),
            PutClusterCapacityProvidersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterContainerInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterContainerInstanceError {
    /// Kind of error that occurred.
    pub kind: RegisterContainerInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterContainerInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterContainerInstanceErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterContainerInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterContainerInstanceErrorKind::ClientException(_inner) => _inner.fmt(f),
            RegisterContainerInstanceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            RegisterContainerInstanceErrorKind::ServerException(_inner) => _inner.fmt(f),
            RegisterContainerInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterContainerInstanceError {
    fn code(&self) -> Option<&str> {
        RegisterContainerInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterContainerInstanceError {
    /// Creates a new `RegisterContainerInstanceError`.
    pub fn new(kind: RegisterContainerInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterContainerInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterContainerInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterContainerInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterContainerInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterContainerInstanceErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterContainerInstanceErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterContainerInstanceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterContainerInstanceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterContainerInstanceErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterContainerInstanceErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for RegisterContainerInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterContainerInstanceErrorKind::ClientException(_inner) => Some(_inner),
            RegisterContainerInstanceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            RegisterContainerInstanceErrorKind::ServerException(_inner) => Some(_inner),
            RegisterContainerInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterTaskDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterTaskDefinitionError {
    /// Kind of error that occurred.
    pub kind: RegisterTaskDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterTaskDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterTaskDefinitionErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterTaskDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterTaskDefinitionErrorKind::ClientException(_inner) => _inner.fmt(f),
            RegisterTaskDefinitionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            RegisterTaskDefinitionErrorKind::ServerException(_inner) => _inner.fmt(f),
            RegisterTaskDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterTaskDefinitionError {
    fn code(&self) -> Option<&str> {
        RegisterTaskDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterTaskDefinitionError {
    /// Creates a new `RegisterTaskDefinitionError`.
    pub fn new(kind: RegisterTaskDefinitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterTaskDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterTaskDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterTaskDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterTaskDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterTaskDefinitionErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTaskDefinitionErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterTaskDefinitionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTaskDefinitionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterTaskDefinitionErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterTaskDefinitionErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for RegisterTaskDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterTaskDefinitionErrorKind::ClientException(_inner) => Some(_inner),
            RegisterTaskDefinitionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            RegisterTaskDefinitionErrorKind::ServerException(_inner) => Some(_inner),
            RegisterTaskDefinitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RunTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RunTaskError {
    /// Kind of error that occurred.
    pub kind: RunTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RunTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RunTaskErrorKind {
    /// <p>You do not have authorization to perform the requested action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Your Amazon Web Services account has been blocked. For more information, contact <a href="http://aws.amazon.com/contact-us/">
    /// Amazon Web Services Support</a>.</p>
    BlockedException(crate::error::BlockedException),
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified platform version does not satisfy the task definition's required
    /// capabilities.</p>
    PlatformTaskDefinitionIncompatibilityException(
        crate::error::PlatformTaskDefinitionIncompatibilityException,
    ),
    /// <p>The specified platform version does not exist.</p>
    PlatformUnknownException(crate::error::PlatformUnknownException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The specified task is not supported in this Region.</p>
    UnsupportedFeatureException(crate::error::UnsupportedFeatureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RunTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RunTaskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RunTaskErrorKind::BlockedException(_inner) => _inner.fmt(f),
            RunTaskErrorKind::ClientException(_inner) => _inner.fmt(f),
            RunTaskErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            RunTaskErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            RunTaskErrorKind::PlatformTaskDefinitionIncompatibilityException(_inner) => {
                _inner.fmt(f)
            }
            RunTaskErrorKind::PlatformUnknownException(_inner) => _inner.fmt(f),
            RunTaskErrorKind::ServerException(_inner) => _inner.fmt(f),
            RunTaskErrorKind::UnsupportedFeatureException(_inner) => _inner.fmt(f),
            RunTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RunTaskError {
    fn code(&self) -> Option<&str> {
        RunTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RunTaskError {
    /// Creates a new `RunTaskError`.
    pub fn new(kind: RunTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RunTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RunTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RunTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RunTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RunTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, RunTaskErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `RunTaskErrorKind::BlockedException`.
    pub fn is_blocked_exception(&self) -> bool {
        matches!(&self.kind, RunTaskErrorKind::BlockedException(_))
    }
    /// Returns `true` if the error kind is `RunTaskErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, RunTaskErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `RunTaskErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(&self.kind, RunTaskErrorKind::ClusterNotFoundException(_))
    }
    /// Returns `true` if the error kind is `RunTaskErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, RunTaskErrorKind::InvalidParameterException(_))
    }
    /// Returns `true` if the error kind is `RunTaskErrorKind::PlatformTaskDefinitionIncompatibilityException`.
    pub fn is_platform_task_definition_incompatibility_exception(&self) -> bool {
        matches!(
            &self.kind,
            RunTaskErrorKind::PlatformTaskDefinitionIncompatibilityException(_)
        )
    }
    /// Returns `true` if the error kind is `RunTaskErrorKind::PlatformUnknownException`.
    pub fn is_platform_unknown_exception(&self) -> bool {
        matches!(&self.kind, RunTaskErrorKind::PlatformUnknownException(_))
    }
    /// Returns `true` if the error kind is `RunTaskErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, RunTaskErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `RunTaskErrorKind::UnsupportedFeatureException`.
    pub fn is_unsupported_feature_exception(&self) -> bool {
        matches!(&self.kind, RunTaskErrorKind::UnsupportedFeatureException(_))
    }
}
impl std::error::Error for RunTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RunTaskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RunTaskErrorKind::BlockedException(_inner) => Some(_inner),
            RunTaskErrorKind::ClientException(_inner) => Some(_inner),
            RunTaskErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            RunTaskErrorKind::InvalidParameterException(_inner) => Some(_inner),
            RunTaskErrorKind::PlatformTaskDefinitionIncompatibilityException(_inner) => {
                Some(_inner)
            }
            RunTaskErrorKind::PlatformUnknownException(_inner) => Some(_inner),
            RunTaskErrorKind::ServerException(_inner) => Some(_inner),
            RunTaskErrorKind::UnsupportedFeatureException(_inner) => Some(_inner),
            RunTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartTaskError {
    /// Kind of error that occurred.
    pub kind: StartTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartTaskErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartTaskErrorKind::ClientException(_inner) => _inner.fmt(f),
            StartTaskErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            StartTaskErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StartTaskErrorKind::ServerException(_inner) => _inner.fmt(f),
            StartTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartTaskError {
    fn code(&self) -> Option<&str> {
        StartTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartTaskError {
    /// Creates a new `StartTaskError`.
    pub fn new(kind: StartTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartTaskErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, StartTaskErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `StartTaskErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(&self.kind, StartTaskErrorKind::ClusterNotFoundException(_))
    }
    /// Returns `true` if the error kind is `StartTaskErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, StartTaskErrorKind::InvalidParameterException(_))
    }
    /// Returns `true` if the error kind is `StartTaskErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, StartTaskErrorKind::ServerException(_))
    }
}
impl std::error::Error for StartTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartTaskErrorKind::ClientException(_inner) => Some(_inner),
            StartTaskErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            StartTaskErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartTaskErrorKind::ServerException(_inner) => Some(_inner),
            StartTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopTaskError {
    /// Kind of error that occurred.
    pub kind: StopTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopTaskErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopTaskErrorKind::ClientException(_inner) => _inner.fmt(f),
            StopTaskErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            StopTaskErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StopTaskErrorKind::ServerException(_inner) => _inner.fmt(f),
            StopTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopTaskError {
    fn code(&self) -> Option<&str> {
        StopTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopTaskError {
    /// Creates a new `StopTaskError`.
    pub fn new(kind: StopTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopTaskErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, StopTaskErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `StopTaskErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(&self.kind, StopTaskErrorKind::ClusterNotFoundException(_))
    }
    /// Returns `true` if the error kind is `StopTaskErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, StopTaskErrorKind::InvalidParameterException(_))
    }
    /// Returns `true` if the error kind is `StopTaskErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, StopTaskErrorKind::ServerException(_))
    }
}
impl std::error::Error for StopTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopTaskErrorKind::ClientException(_inner) => Some(_inner),
            StopTaskErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            StopTaskErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StopTaskErrorKind::ServerException(_inner) => Some(_inner),
            StopTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SubmitAttachmentStateChanges` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SubmitAttachmentStateChangesError {
    /// Kind of error that occurred.
    pub kind: SubmitAttachmentStateChangesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SubmitAttachmentStateChanges` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SubmitAttachmentStateChangesErrorKind {
    /// <p>You do not have authorization to perform the requested action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SubmitAttachmentStateChangesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SubmitAttachmentStateChangesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SubmitAttachmentStateChangesErrorKind::ClientException(_inner) => _inner.fmt(f),
            SubmitAttachmentStateChangesErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            SubmitAttachmentStateChangesErrorKind::ServerException(_inner) => _inner.fmt(f),
            SubmitAttachmentStateChangesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SubmitAttachmentStateChangesError {
    fn code(&self) -> Option<&str> {
        SubmitAttachmentStateChangesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SubmitAttachmentStateChangesError {
    /// Creates a new `SubmitAttachmentStateChangesError`.
    pub fn new(kind: SubmitAttachmentStateChangesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SubmitAttachmentStateChangesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SubmitAttachmentStateChangesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SubmitAttachmentStateChangesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SubmitAttachmentStateChangesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SubmitAttachmentStateChangesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubmitAttachmentStateChangesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SubmitAttachmentStateChangesErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubmitAttachmentStateChangesErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `SubmitAttachmentStateChangesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubmitAttachmentStateChangesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `SubmitAttachmentStateChangesErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubmitAttachmentStateChangesErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for SubmitAttachmentStateChangesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SubmitAttachmentStateChangesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SubmitAttachmentStateChangesErrorKind::ClientException(_inner) => Some(_inner),
            SubmitAttachmentStateChangesErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            SubmitAttachmentStateChangesErrorKind::ServerException(_inner) => Some(_inner),
            SubmitAttachmentStateChangesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SubmitContainerStateChange` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SubmitContainerStateChangeError {
    /// Kind of error that occurred.
    pub kind: SubmitContainerStateChangeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SubmitContainerStateChange` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SubmitContainerStateChangeErrorKind {
    /// <p>You do not have authorization to perform the requested action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SubmitContainerStateChangeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SubmitContainerStateChangeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SubmitContainerStateChangeErrorKind::ClientException(_inner) => _inner.fmt(f),
            SubmitContainerStateChangeErrorKind::ServerException(_inner) => _inner.fmt(f),
            SubmitContainerStateChangeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SubmitContainerStateChangeError {
    fn code(&self) -> Option<&str> {
        SubmitContainerStateChangeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SubmitContainerStateChangeError {
    /// Creates a new `SubmitContainerStateChangeError`.
    pub fn new(kind: SubmitContainerStateChangeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SubmitContainerStateChangeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SubmitContainerStateChangeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SubmitContainerStateChangeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SubmitContainerStateChangeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SubmitContainerStateChangeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubmitContainerStateChangeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SubmitContainerStateChangeErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubmitContainerStateChangeErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `SubmitContainerStateChangeErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubmitContainerStateChangeErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for SubmitContainerStateChangeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SubmitContainerStateChangeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SubmitContainerStateChangeErrorKind::ClientException(_inner) => Some(_inner),
            SubmitContainerStateChangeErrorKind::ServerException(_inner) => Some(_inner),
            SubmitContainerStateChangeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SubmitTaskStateChange` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SubmitTaskStateChangeError {
    /// Kind of error that occurred.
    pub kind: SubmitTaskStateChangeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SubmitTaskStateChange` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SubmitTaskStateChangeErrorKind {
    /// <p>You do not have authorization to perform the requested action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SubmitTaskStateChangeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SubmitTaskStateChangeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SubmitTaskStateChangeErrorKind::ClientException(_inner) => _inner.fmt(f),
            SubmitTaskStateChangeErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            SubmitTaskStateChangeErrorKind::ServerException(_inner) => _inner.fmt(f),
            SubmitTaskStateChangeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SubmitTaskStateChangeError {
    fn code(&self) -> Option<&str> {
        SubmitTaskStateChangeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SubmitTaskStateChangeError {
    /// Creates a new `SubmitTaskStateChangeError`.
    pub fn new(kind: SubmitTaskStateChangeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SubmitTaskStateChangeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SubmitTaskStateChangeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SubmitTaskStateChangeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SubmitTaskStateChangeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SubmitTaskStateChangeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubmitTaskStateChangeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SubmitTaskStateChangeErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubmitTaskStateChangeErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `SubmitTaskStateChangeErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubmitTaskStateChangeErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `SubmitTaskStateChangeErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            SubmitTaskStateChangeErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for SubmitTaskStateChangeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SubmitTaskStateChangeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SubmitTaskStateChangeErrorKind::ClientException(_inner) => Some(_inner),
            SubmitTaskStateChangeErrorKind::InvalidParameterException(_inner) => Some(_inner),
            SubmitTaskStateChangeErrorKind::ServerException(_inner) => Some(_inner),
            SubmitTaskStateChangeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::ClientException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ServerException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::ClientException(_inner) => Some(_inner),
            TagResourceErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ServerException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::ClientException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ServerException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::ClientException(_inner) => Some(_inner),
            UntagResourceErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCapacityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCapacityProviderError {
    /// Kind of error that occurred.
    pub kind: UpdateCapacityProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCapacityProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCapacityProviderErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCapacityProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCapacityProviderErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateCapacityProviderErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateCapacityProviderErrorKind::ServerException(_inner) => _inner.fmt(f),
            UpdateCapacityProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCapacityProviderError {
    fn code(&self) -> Option<&str> {
        UpdateCapacityProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCapacityProviderError {
    /// Creates a new `UpdateCapacityProviderError`.
    pub fn new(kind: UpdateCapacityProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCapacityProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCapacityProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCapacityProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCapacityProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateCapacityProviderErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCapacityProviderErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCapacityProviderErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCapacityProviderErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCapacityProviderErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCapacityProviderErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for UpdateCapacityProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCapacityProviderErrorKind::ClientException(_inner) => Some(_inner),
            UpdateCapacityProviderErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateCapacityProviderErrorKind::ServerException(_inner) => Some(_inner),
            UpdateCapacityProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateClusterError {
    /// Kind of error that occurred.
    pub kind: UpdateClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateClusterErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateClusterErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::ServerException(_inner) => _inner.fmt(f),
            UpdateClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateClusterError {
    fn code(&self) -> Option<&str> {
        UpdateClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateClusterError {
    /// Creates a new `UpdateClusterError`.
    pub fn new(kind: UpdateClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateClusterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateClusterErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, UpdateClusterErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `UpdateClusterErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateClusterErrorKind::ServerException(_))
    }
}
impl std::error::Error for UpdateClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateClusterErrorKind::ClientException(_inner) => Some(_inner),
            UpdateClusterErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            UpdateClusterErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateClusterErrorKind::ServerException(_inner) => Some(_inner),
            UpdateClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateClusterSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateClusterSettingsError {
    /// Kind of error that occurred.
    pub kind: UpdateClusterSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateClusterSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateClusterSettingsErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateClusterSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateClusterSettingsErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateClusterSettingsErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            UpdateClusterSettingsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateClusterSettingsErrorKind::ServerException(_inner) => _inner.fmt(f),
            UpdateClusterSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateClusterSettingsError {
    fn code(&self) -> Option<&str> {
        UpdateClusterSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateClusterSettingsError {
    /// Creates a new `UpdateClusterSettingsError`.
    pub fn new(kind: UpdateClusterSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateClusterSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateClusterSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateClusterSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateClusterSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateClusterSettingsErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterSettingsErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterSettingsErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterSettingsErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterSettingsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterSettingsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClusterSettingsErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClusterSettingsErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for UpdateClusterSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateClusterSettingsErrorKind::ClientException(_inner) => Some(_inner),
            UpdateClusterSettingsErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            UpdateClusterSettingsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateClusterSettingsErrorKind::ServerException(_inner) => Some(_inner),
            UpdateClusterSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateContainerAgent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateContainerAgentError {
    /// Kind of error that occurred.
    pub kind: UpdateContainerAgentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateContainerAgent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateContainerAgentErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Amazon ECS is unable to determine the current version of the Amazon ECS container agent on the
    /// container instance and does not have enough information to proceed with an update. This
    /// could be because the agent running on the container instance is an older or custom
    /// version that does not use our version information.</p>
    MissingVersionException(crate::error::MissingVersionException),
    /// <p>There is no update available for this Amazon ECS container agent. This could be because the
    /// agent is already running the latest version, or it is so old that there is no update
    /// path to the current version.</p>
    NoUpdateAvailableException(crate::error::NoUpdateAvailableException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>There is already a current Amazon ECS container agent update in progress on the specified
    /// container instance. If the container agent becomes disconnected while it is in a
    /// transitional stage, such as <code>PENDING</code> or <code>STAGING</code>, the update
    /// process can get stuck in that state. However, when the agent reconnects, it resumes
    /// where it stopped previously.</p>
    UpdateInProgressException(crate::error::UpdateInProgressException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateContainerAgentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateContainerAgentErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateContainerAgentErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            UpdateContainerAgentErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateContainerAgentErrorKind::MissingVersionException(_inner) => _inner.fmt(f),
            UpdateContainerAgentErrorKind::NoUpdateAvailableException(_inner) => _inner.fmt(f),
            UpdateContainerAgentErrorKind::ServerException(_inner) => _inner.fmt(f),
            UpdateContainerAgentErrorKind::UpdateInProgressException(_inner) => _inner.fmt(f),
            UpdateContainerAgentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateContainerAgentError {
    fn code(&self) -> Option<&str> {
        UpdateContainerAgentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateContainerAgentError {
    /// Creates a new `UpdateContainerAgentError`.
    pub fn new(kind: UpdateContainerAgentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateContainerAgentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateContainerAgentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateContainerAgentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateContainerAgentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateContainerAgentErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContainerAgentErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContainerAgentErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContainerAgentErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContainerAgentErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContainerAgentErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContainerAgentErrorKind::MissingVersionException`.
    pub fn is_missing_version_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContainerAgentErrorKind::MissingVersionException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContainerAgentErrorKind::NoUpdateAvailableException`.
    pub fn is_no_update_available_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContainerAgentErrorKind::NoUpdateAvailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContainerAgentErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContainerAgentErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContainerAgentErrorKind::UpdateInProgressException`.
    pub fn is_update_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContainerAgentErrorKind::UpdateInProgressException(_)
        )
    }
}
impl std::error::Error for UpdateContainerAgentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateContainerAgentErrorKind::ClientException(_inner) => Some(_inner),
            UpdateContainerAgentErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            UpdateContainerAgentErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateContainerAgentErrorKind::MissingVersionException(_inner) => Some(_inner),
            UpdateContainerAgentErrorKind::NoUpdateAvailableException(_inner) => Some(_inner),
            UpdateContainerAgentErrorKind::ServerException(_inner) => Some(_inner),
            UpdateContainerAgentErrorKind::UpdateInProgressException(_inner) => Some(_inner),
            UpdateContainerAgentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateContainerInstancesState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateContainerInstancesStateError {
    /// Kind of error that occurred.
    pub kind: UpdateContainerInstancesStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateContainerInstancesState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateContainerInstancesStateErrorKind {
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateContainerInstancesStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateContainerInstancesStateErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateContainerInstancesStateErrorKind::ClusterNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateContainerInstancesStateErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            UpdateContainerInstancesStateErrorKind::ServerException(_inner) => _inner.fmt(f),
            UpdateContainerInstancesStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateContainerInstancesStateError {
    fn code(&self) -> Option<&str> {
        UpdateContainerInstancesStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateContainerInstancesStateError {
    /// Creates a new `UpdateContainerInstancesStateError`.
    pub fn new(
        kind: UpdateContainerInstancesStateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateContainerInstancesStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateContainerInstancesStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateContainerInstancesStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateContainerInstancesStateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateContainerInstancesStateErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContainerInstancesStateErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContainerInstancesStateErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContainerInstancesStateErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContainerInstancesStateErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContainerInstancesStateErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContainerInstancesStateErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContainerInstancesStateErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for UpdateContainerInstancesStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateContainerInstancesStateErrorKind::ClientException(_inner) => Some(_inner),
            UpdateContainerInstancesStateErrorKind::ClusterNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateContainerInstancesStateErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            UpdateContainerInstancesStateErrorKind::ServerException(_inner) => Some(_inner),
            UpdateContainerInstancesStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServiceError {
    /// Kind of error that occurred.
    pub kind: UpdateServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServiceErrorKind {
    /// <p>You do not have authorization to perform the requested action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified platform version does not satisfy the task definition's required
    /// capabilities.</p>
    PlatformTaskDefinitionIncompatibilityException(
        crate::error::PlatformTaskDefinitionIncompatibilityException,
    ),
    /// <p>The specified platform version does not exist.</p>
    PlatformUnknownException(crate::error::PlatformUnknownException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The specified service is not active. You can't update a service that is inactive. If
    /// you have previously deleted a service, you can re-create it with <a>CreateService</a>.</p>
    ServiceNotActiveException(crate::error::ServiceNotActiveException),
    /// <p>The specified service could not be found. You can view your available services with
    /// <a>ListServices</a>. Amazon ECS services are cluster-specific and
    /// Region-specific.</p>
    ServiceNotFoundException(crate::error::ServiceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServiceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::PlatformTaskDefinitionIncompatibilityException(_inner) => {
                _inner.fmt(f)
            }
            UpdateServiceErrorKind::PlatformUnknownException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::ServerException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::ServiceNotActiveException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::ServiceNotFoundException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServiceError {
    fn code(&self) -> Option<&str> {
        UpdateServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateServiceError {
    /// Creates a new `UpdateServiceError`.
    pub fn new(kind: UpdateServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServiceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateServiceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, UpdateServiceErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::PlatformTaskDefinitionIncompatibilityException`.
    pub fn is_platform_task_definition_incompatibility_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceErrorKind::PlatformTaskDefinitionIncompatibilityException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::PlatformUnknownException`.
    pub fn is_platform_unknown_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceErrorKind::PlatformUnknownException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateServiceErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::ServiceNotActiveException`.
    pub fn is_service_not_active_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceErrorKind::ServiceNotActiveException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceErrorKind::ServiceNotFoundException`.
    pub fn is_service_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceErrorKind::ServiceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServiceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateServiceErrorKind::ClientException(_inner) => Some(_inner),
            UpdateServiceErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            UpdateServiceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateServiceErrorKind::PlatformTaskDefinitionIncompatibilityException(_inner) => {
                Some(_inner)
            }
            UpdateServiceErrorKind::PlatformUnknownException(_inner) => Some(_inner),
            UpdateServiceErrorKind::ServerException(_inner) => Some(_inner),
            UpdateServiceErrorKind::ServiceNotActiveException(_inner) => Some(_inner),
            UpdateServiceErrorKind::ServiceNotFoundException(_inner) => Some(_inner),
            UpdateServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateServicePrimaryTaskSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServicePrimaryTaskSetError {
    /// Kind of error that occurred.
    pub kind: UpdateServicePrimaryTaskSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateServicePrimaryTaskSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServicePrimaryTaskSetErrorKind {
    /// <p>You do not have authorization to perform the requested action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The specified service is not active. You can't update a service that is inactive. If
    /// you have previously deleted a service, you can re-create it with <a>CreateService</a>.</p>
    ServiceNotActiveException(crate::error::ServiceNotActiveException),
    /// <p>The specified service could not be found. You can view your available services with
    /// <a>ListServices</a>. Amazon ECS services are cluster-specific and
    /// Region-specific.</p>
    ServiceNotFoundException(crate::error::ServiceNotFoundException),
    /// <p>The specified task set could not be found. You can view your available task sets with
    /// <a>DescribeTaskSets</a>. Task sets are specific to each cluster, service
    /// and Region.</p>
    TaskSetNotFoundException(crate::error::TaskSetNotFoundException),
    /// <p>The specified task is not supported in this Region.</p>
    UnsupportedFeatureException(crate::error::UnsupportedFeatureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServicePrimaryTaskSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServicePrimaryTaskSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateServicePrimaryTaskSetErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateServicePrimaryTaskSetErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            UpdateServicePrimaryTaskSetErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            UpdateServicePrimaryTaskSetErrorKind::ServerException(_inner) => _inner.fmt(f),
            UpdateServicePrimaryTaskSetErrorKind::ServiceNotActiveException(_inner) => {
                _inner.fmt(f)
            }
            UpdateServicePrimaryTaskSetErrorKind::ServiceNotFoundException(_inner) => _inner.fmt(f),
            UpdateServicePrimaryTaskSetErrorKind::TaskSetNotFoundException(_inner) => _inner.fmt(f),
            UpdateServicePrimaryTaskSetErrorKind::UnsupportedFeatureException(_inner) => {
                _inner.fmt(f)
            }
            UpdateServicePrimaryTaskSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServicePrimaryTaskSetError {
    fn code(&self) -> Option<&str> {
        UpdateServicePrimaryTaskSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateServicePrimaryTaskSetError {
    /// Creates a new `UpdateServicePrimaryTaskSetError`.
    pub fn new(kind: UpdateServicePrimaryTaskSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServicePrimaryTaskSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServicePrimaryTaskSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServicePrimaryTaskSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServicePrimaryTaskSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateServicePrimaryTaskSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServicePrimaryTaskSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServicePrimaryTaskSetErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServicePrimaryTaskSetErrorKind::ClientException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServicePrimaryTaskSetErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServicePrimaryTaskSetErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServicePrimaryTaskSetErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServicePrimaryTaskSetErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServicePrimaryTaskSetErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServicePrimaryTaskSetErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServicePrimaryTaskSetErrorKind::ServiceNotActiveException`.
    pub fn is_service_not_active_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServicePrimaryTaskSetErrorKind::ServiceNotActiveException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServicePrimaryTaskSetErrorKind::ServiceNotFoundException`.
    pub fn is_service_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServicePrimaryTaskSetErrorKind::ServiceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServicePrimaryTaskSetErrorKind::TaskSetNotFoundException`.
    pub fn is_task_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServicePrimaryTaskSetErrorKind::TaskSetNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServicePrimaryTaskSetErrorKind::UnsupportedFeatureException`.
    pub fn is_unsupported_feature_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServicePrimaryTaskSetErrorKind::UnsupportedFeatureException(_)
        )
    }
}
impl std::error::Error for UpdateServicePrimaryTaskSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServicePrimaryTaskSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateServicePrimaryTaskSetErrorKind::ClientException(_inner) => Some(_inner),
            UpdateServicePrimaryTaskSetErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            UpdateServicePrimaryTaskSetErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateServicePrimaryTaskSetErrorKind::ServerException(_inner) => Some(_inner),
            UpdateServicePrimaryTaskSetErrorKind::ServiceNotActiveException(_inner) => Some(_inner),
            UpdateServicePrimaryTaskSetErrorKind::ServiceNotFoundException(_inner) => Some(_inner),
            UpdateServicePrimaryTaskSetErrorKind::TaskSetNotFoundException(_inner) => Some(_inner),
            UpdateServicePrimaryTaskSetErrorKind::UnsupportedFeatureException(_inner) => {
                Some(_inner)
            }
            UpdateServicePrimaryTaskSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateTaskSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTaskSetError {
    /// Kind of error that occurred.
    pub kind: UpdateTaskSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateTaskSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTaskSetErrorKind {
    /// <p>You do not have authorization to perform the requested action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>These errors are usually caused by a client action, such as using an action or
    /// resource on behalf of a user that doesn't have permissions to use the action or
    /// resource, or specifying an identifier that is not valid.</p>
    ClientException(crate::error::ClientException),
    /// <p>The specified cluster could not be found. You can view your available clusters with
    /// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
    ClusterNotFoundException(crate::error::ClusterNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The specified service is not active. You can't update a service that is inactive. If
    /// you have previously deleted a service, you can re-create it with <a>CreateService</a>.</p>
    ServiceNotActiveException(crate::error::ServiceNotActiveException),
    /// <p>The specified service could not be found. You can view your available services with
    /// <a>ListServices</a>. Amazon ECS services are cluster-specific and
    /// Region-specific.</p>
    ServiceNotFoundException(crate::error::ServiceNotFoundException),
    /// <p>The specified task set could not be found. You can view your available task sets with
    /// <a>DescribeTaskSets</a>. Task sets are specific to each cluster, service
    /// and Region.</p>
    TaskSetNotFoundException(crate::error::TaskSetNotFoundException),
    /// <p>The specified task is not supported in this Region.</p>
    UnsupportedFeatureException(crate::error::UnsupportedFeatureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTaskSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTaskSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateTaskSetErrorKind::ClientException(_inner) => _inner.fmt(f),
            UpdateTaskSetErrorKind::ClusterNotFoundException(_inner) => _inner.fmt(f),
            UpdateTaskSetErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateTaskSetErrorKind::ServerException(_inner) => _inner.fmt(f),
            UpdateTaskSetErrorKind::ServiceNotActiveException(_inner) => _inner.fmt(f),
            UpdateTaskSetErrorKind::ServiceNotFoundException(_inner) => _inner.fmt(f),
            UpdateTaskSetErrorKind::TaskSetNotFoundException(_inner) => _inner.fmt(f),
            UpdateTaskSetErrorKind::UnsupportedFeatureException(_inner) => _inner.fmt(f),
            UpdateTaskSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTaskSetError {
    fn code(&self) -> Option<&str> {
        UpdateTaskSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTaskSetError {
    /// Creates a new `UpdateTaskSetError`.
    pub fn new(kind: UpdateTaskSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTaskSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTaskSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTaskSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTaskSetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateTaskSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateTaskSetErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateTaskSetErrorKind::ClientException`.
    pub fn is_client_exception(&self) -> bool {
        matches!(&self.kind, UpdateTaskSetErrorKind::ClientException(_))
    }
    /// Returns `true` if the error kind is `UpdateTaskSetErrorKind::ClusterNotFoundException`.
    pub fn is_cluster_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTaskSetErrorKind::ClusterNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTaskSetErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTaskSetErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTaskSetErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateTaskSetErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `UpdateTaskSetErrorKind::ServiceNotActiveException`.
    pub fn is_service_not_active_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTaskSetErrorKind::ServiceNotActiveException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTaskSetErrorKind::ServiceNotFoundException`.
    pub fn is_service_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTaskSetErrorKind::ServiceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTaskSetErrorKind::TaskSetNotFoundException`.
    pub fn is_task_set_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTaskSetErrorKind::TaskSetNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateTaskSetErrorKind::UnsupportedFeatureException`.
    pub fn is_unsupported_feature_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTaskSetErrorKind::UnsupportedFeatureException(_)
        )
    }
}
impl std::error::Error for UpdateTaskSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTaskSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateTaskSetErrorKind::ClientException(_inner) => Some(_inner),
            UpdateTaskSetErrorKind::ClusterNotFoundException(_inner) => Some(_inner),
            UpdateTaskSetErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateTaskSetErrorKind::ServerException(_inner) => Some(_inner),
            UpdateTaskSetErrorKind::ServiceNotActiveException(_inner) => Some(_inner),
            UpdateTaskSetErrorKind::ServiceNotFoundException(_inner) => Some(_inner),
            UpdateTaskSetErrorKind::TaskSetNotFoundException(_inner) => Some(_inner),
            UpdateTaskSetErrorKind::UnsupportedFeatureException(_inner) => Some(_inner),
            UpdateTaskSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The specified task is not supported in this Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedFeatureException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedFeatureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedFeatureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedFeatureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedFeatureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedFeatureException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedFeatureException {}
/// See [`UnsupportedFeatureException`](crate::error::UnsupportedFeatureException)
pub mod unsupported_feature_exception {
    /// A builder for [`UnsupportedFeatureException`](crate::error::UnsupportedFeatureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedFeatureException`](crate::error::UnsupportedFeatureException)
        pub fn build(self) -> crate::error::UnsupportedFeatureException {
            crate::error::UnsupportedFeatureException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedFeatureException {
    /// Creates a new builder-style object to manufacture [`UnsupportedFeatureException`](crate::error::UnsupportedFeatureException)
    pub fn builder() -> crate::error::unsupported_feature_exception::Builder {
        crate::error::unsupported_feature_exception::Builder::default()
    }
}

/// <p>The specified task set could not be found. You can view your available task sets with
/// <a>DescribeTaskSets</a>. Task sets are specific to each cluster, service
/// and Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskSetNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TaskSetNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskSetNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TaskSetNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TaskSetNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TaskSetNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for TaskSetNotFoundException {}
/// See [`TaskSetNotFoundException`](crate::error::TaskSetNotFoundException)
pub mod task_set_not_found_exception {
    /// A builder for [`TaskSetNotFoundException`](crate::error::TaskSetNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskSetNotFoundException`](crate::error::TaskSetNotFoundException)
        pub fn build(self) -> crate::error::TaskSetNotFoundException {
            crate::error::TaskSetNotFoundException {
                message: self.message,
            }
        }
    }
}
impl TaskSetNotFoundException {
    /// Creates a new builder-style object to manufacture [`TaskSetNotFoundException`](crate::error::TaskSetNotFoundException)
    pub fn builder() -> crate::error::task_set_not_found_exception::Builder {
        crate::error::task_set_not_found_exception::Builder::default()
    }
}

/// <p>The specified service could not be found. You can view your available services with
/// <a>ListServices</a>. Amazon ECS services are cluster-specific and
/// Region-specific.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceNotFoundException {}
/// See [`ServiceNotFoundException`](crate::error::ServiceNotFoundException)
pub mod service_not_found_exception {
    /// A builder for [`ServiceNotFoundException`](crate::error::ServiceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceNotFoundException`](crate::error::ServiceNotFoundException)
        pub fn build(self) -> crate::error::ServiceNotFoundException {
            crate::error::ServiceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ServiceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ServiceNotFoundException`](crate::error::ServiceNotFoundException)
    pub fn builder() -> crate::error::service_not_found_exception::Builder {
        crate::error::service_not_found_exception::Builder::default()
    }
}

/// <p>The specified service is not active. You can't update a service that is inactive. If
/// you have previously deleted a service, you can re-create it with <a>CreateService</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceNotActiveException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceNotActiveException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceNotActiveException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceNotActiveException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceNotActiveException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceNotActiveException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceNotActiveException {}
/// See [`ServiceNotActiveException`](crate::error::ServiceNotActiveException)
pub mod service_not_active_exception {
    /// A builder for [`ServiceNotActiveException`](crate::error::ServiceNotActiveException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceNotActiveException`](crate::error::ServiceNotActiveException)
        pub fn build(self) -> crate::error::ServiceNotActiveException {
            crate::error::ServiceNotActiveException {
                message: self.message,
            }
        }
    }
}
impl ServiceNotActiveException {
    /// Creates a new builder-style object to manufacture [`ServiceNotActiveException`](crate::error::ServiceNotActiveException)
    pub fn builder() -> crate::error::service_not_active_exception::Builder {
        crate::error::service_not_active_exception::Builder::default()
    }
}

/// <p>These errors are usually caused by a server issue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServerException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServerException {}
/// See [`ServerException`](crate::error::ServerException)
pub mod server_exception {
    /// A builder for [`ServerException`](crate::error::ServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerException`](crate::error::ServerException)
        pub fn build(self) -> crate::error::ServerException {
            crate::error::ServerException {
                message: self.message,
            }
        }
    }
}
impl ServerException {
    /// Creates a new builder-style object to manufacture [`ServerException`](crate::error::ServerException)
    pub fn builder() -> crate::error::server_exception::Builder {
        crate::error::server_exception::Builder::default()
    }
}

/// <p>The specified parameter is invalid. Review the available parameters for the API
/// request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterException {}
/// See [`InvalidParameterException`](crate::error::InvalidParameterException)
pub mod invalid_parameter_exception {
    /// A builder for [`InvalidParameterException`](crate::error::InvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterException`](crate::error::InvalidParameterException)
        pub fn build(self) -> crate::error::InvalidParameterException {
            crate::error::InvalidParameterException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterException`](crate::error::InvalidParameterException)
    pub fn builder() -> crate::error::invalid_parameter_exception::Builder {
        crate::error::invalid_parameter_exception::Builder::default()
    }
}

/// <p>The specified cluster could not be found. You can view your available clusters with
/// <a>ListClusters</a>. Amazon ECS clusters are Region-specific.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterNotFoundException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterNotFoundException {}
/// See [`ClusterNotFoundException`](crate::error::ClusterNotFoundException)
pub mod cluster_not_found_exception {
    /// A builder for [`ClusterNotFoundException`](crate::error::ClusterNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterNotFoundException`](crate::error::ClusterNotFoundException)
        pub fn build(self) -> crate::error::ClusterNotFoundException {
            crate::error::ClusterNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ClusterNotFoundException {
    /// Creates a new builder-style object to manufacture [`ClusterNotFoundException`](crate::error::ClusterNotFoundException)
    pub fn builder() -> crate::error::cluster_not_found_exception::Builder {
        crate::error::cluster_not_found_exception::Builder::default()
    }
}

/// <p>These errors are usually caused by a client action, such as using an action or
/// resource on behalf of a user that doesn't have permissions to use the action or
/// resource, or specifying an identifier that is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClientException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClientException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClientException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClientException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClientException {}
/// See [`ClientException`](crate::error::ClientException)
pub mod client_exception {
    /// A builder for [`ClientException`](crate::error::ClientException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClientException`](crate::error::ClientException)
        pub fn build(self) -> crate::error::ClientException {
            crate::error::ClientException {
                message: self.message,
            }
        }
    }
}
impl ClientException {
    /// Creates a new builder-style object to manufacture [`ClientException`](crate::error::ClientException)
    pub fn builder() -> crate::error::client_exception::Builder {
        crate::error::client_exception::Builder::default()
    }
}

/// <p>You do not have authorization to perform the requested action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The specified platform version does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlatformUnknownException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PlatformUnknownException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlatformUnknownException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PlatformUnknownException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PlatformUnknownException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PlatformUnknownException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for PlatformUnknownException {}
/// See [`PlatformUnknownException`](crate::error::PlatformUnknownException)
pub mod platform_unknown_exception {
    /// A builder for [`PlatformUnknownException`](crate::error::PlatformUnknownException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PlatformUnknownException`](crate::error::PlatformUnknownException)
        pub fn build(self) -> crate::error::PlatformUnknownException {
            crate::error::PlatformUnknownException {
                message: self.message,
            }
        }
    }
}
impl PlatformUnknownException {
    /// Creates a new builder-style object to manufacture [`PlatformUnknownException`](crate::error::PlatformUnknownException)
    pub fn builder() -> crate::error::platform_unknown_exception::Builder {
        crate::error::platform_unknown_exception::Builder::default()
    }
}

/// <p>The specified platform version does not satisfy the task definition's required
/// capabilities.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlatformTaskDefinitionIncompatibilityException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PlatformTaskDefinitionIncompatibilityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlatformTaskDefinitionIncompatibilityException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PlatformTaskDefinitionIncompatibilityException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PlatformTaskDefinitionIncompatibilityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PlatformTaskDefinitionIncompatibilityException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for PlatformTaskDefinitionIncompatibilityException {}
/// See [`PlatformTaskDefinitionIncompatibilityException`](crate::error::PlatformTaskDefinitionIncompatibilityException)
pub mod platform_task_definition_incompatibility_exception {
    /// A builder for [`PlatformTaskDefinitionIncompatibilityException`](crate::error::PlatformTaskDefinitionIncompatibilityException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PlatformTaskDefinitionIncompatibilityException`](crate::error::PlatformTaskDefinitionIncompatibilityException)
        pub fn build(self) -> crate::error::PlatformTaskDefinitionIncompatibilityException {
            crate::error::PlatformTaskDefinitionIncompatibilityException {
                message: self.message,
            }
        }
    }
}
impl PlatformTaskDefinitionIncompatibilityException {
    /// Creates a new builder-style object to manufacture [`PlatformTaskDefinitionIncompatibilityException`](crate::error::PlatformTaskDefinitionIncompatibilityException)
    pub fn builder() -> crate::error::platform_task_definition_incompatibility_exception::Builder {
        crate::error::platform_task_definition_incompatibility_exception::Builder::default()
    }
}

/// <p>There is already a current Amazon ECS container agent update in progress on the specified
/// container instance. If the container agent becomes disconnected while it is in a
/// transitional stage, such as <code>PENDING</code> or <code>STAGING</code>, the update
/// process can get stuck in that state. However, when the agent reconnects, it resumes
/// where it stopped previously.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInProgressException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateInProgressException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UpdateInProgressException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UpdateInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UpdateInProgressException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for UpdateInProgressException {}
/// See [`UpdateInProgressException`](crate::error::UpdateInProgressException)
pub mod update_in_progress_exception {
    /// A builder for [`UpdateInProgressException`](crate::error::UpdateInProgressException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInProgressException`](crate::error::UpdateInProgressException)
        pub fn build(self) -> crate::error::UpdateInProgressException {
            crate::error::UpdateInProgressException {
                message: self.message,
            }
        }
    }
}
impl UpdateInProgressException {
    /// Creates a new builder-style object to manufacture [`UpdateInProgressException`](crate::error::UpdateInProgressException)
    pub fn builder() -> crate::error::update_in_progress_exception::Builder {
        crate::error::update_in_progress_exception::Builder::default()
    }
}

/// <p>There is no update available for this Amazon ECS container agent. This could be because the
/// agent is already running the latest version, or it is so old that there is no update
/// path to the current version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoUpdateAvailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoUpdateAvailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoUpdateAvailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoUpdateAvailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoUpdateAvailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoUpdateAvailableException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoUpdateAvailableException {}
/// See [`NoUpdateAvailableException`](crate::error::NoUpdateAvailableException)
pub mod no_update_available_exception {
    /// A builder for [`NoUpdateAvailableException`](crate::error::NoUpdateAvailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoUpdateAvailableException`](crate::error::NoUpdateAvailableException)
        pub fn build(self) -> crate::error::NoUpdateAvailableException {
            crate::error::NoUpdateAvailableException {
                message: self.message,
            }
        }
    }
}
impl NoUpdateAvailableException {
    /// Creates a new builder-style object to manufacture [`NoUpdateAvailableException`](crate::error::NoUpdateAvailableException)
    pub fn builder() -> crate::error::no_update_available_exception::Builder {
        crate::error::no_update_available_exception::Builder::default()
    }
}

/// <p>Amazon ECS is unable to determine the current version of the Amazon ECS container agent on the
/// container instance and does not have enough information to proceed with an update. This
/// could be because the agent running on the container instance is an older or custom
/// version that does not use our version information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MissingVersionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MissingVersionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MissingVersionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MissingVersionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MissingVersionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MissingVersionException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for MissingVersionException {}
/// See [`MissingVersionException`](crate::error::MissingVersionException)
pub mod missing_version_exception {
    /// A builder for [`MissingVersionException`](crate::error::MissingVersionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MissingVersionException`](crate::error::MissingVersionException)
        pub fn build(self) -> crate::error::MissingVersionException {
            crate::error::MissingVersionException {
                message: self.message,
            }
        }
    }
}
impl MissingVersionException {
    /// Creates a new builder-style object to manufacture [`MissingVersionException`](crate::error::MissingVersionException)
    pub fn builder() -> crate::error::missing_version_exception::Builder {
        crate::error::missing_version_exception::Builder::default()
    }
}

/// <p>The specified resource could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>Your Amazon Web Services account has been blocked. For more information, contact <a href="http://aws.amazon.com/contact-us/">
/// Amazon Web Services Support</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BlockedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BlockedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BlockedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BlockedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BlockedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BlockedException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for BlockedException {}
/// See [`BlockedException`](crate::error::BlockedException)
pub mod blocked_exception {
    /// A builder for [`BlockedException`](crate::error::BlockedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BlockedException`](crate::error::BlockedException)
        pub fn build(self) -> crate::error::BlockedException {
            crate::error::BlockedException {
                message: self.message,
            }
        }
    }
}
impl BlockedException {
    /// Creates a new builder-style object to manufacture [`BlockedException`](crate::error::BlockedException)
    pub fn builder() -> crate::error::blocked_exception::Builder {
        crate::error::blocked_exception::Builder::default()
    }
}

/// <p>The specified resource is in-use and cannot be removed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>The specified target could not be found. You can view your available container
/// instances with <a>ListContainerInstances</a>. Amazon ECS container instances are
/// cluster-specific and Region-specific.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TargetNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TargetNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TargetNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TargetNotFoundException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for TargetNotFoundException {}
/// See [`TargetNotFoundException`](crate::error::TargetNotFoundException)
pub mod target_not_found_exception {
    /// A builder for [`TargetNotFoundException`](crate::error::TargetNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetNotFoundException`](crate::error::TargetNotFoundException)
        pub fn build(self) -> crate::error::TargetNotFoundException {
            crate::error::TargetNotFoundException {
                message: self.message,
            }
        }
    }
}
impl TargetNotFoundException {
    /// Creates a new builder-style object to manufacture [`TargetNotFoundException`](crate::error::TargetNotFoundException)
    pub fn builder() -> crate::error::target_not_found_exception::Builder {
        crate::error::target_not_found_exception::Builder::default()
    }
}

/// <p>You can apply up to 10 custom attributes per resource. You can view the attributes of
/// a resource with <a>ListAttributes</a>. You can remove existing attributes on
/// a resource with <a>DeleteAttributes</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttributeLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AttributeLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttributeLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AttributeLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AttributeLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AttributeLimitExceededException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for AttributeLimitExceededException {}
/// See [`AttributeLimitExceededException`](crate::error::AttributeLimitExceededException)
pub mod attribute_limit_exceeded_exception {
    /// A builder for [`AttributeLimitExceededException`](crate::error::AttributeLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AttributeLimitExceededException`](crate::error::AttributeLimitExceededException)
        pub fn build(self) -> crate::error::AttributeLimitExceededException {
            crate::error::AttributeLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl AttributeLimitExceededException {
    /// Creates a new builder-style object to manufacture [`AttributeLimitExceededException`](crate::error::AttributeLimitExceededException)
    pub fn builder() -> crate::error::attribute_limit_exceeded_exception::Builder {
        crate::error::attribute_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The target container is not properly configured with the execute command agent or the
/// container is no longer active or running.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetNotConnectedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TargetNotConnectedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetNotConnectedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TargetNotConnectedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TargetNotConnectedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TargetNotConnectedException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for TargetNotConnectedException {}
/// See [`TargetNotConnectedException`](crate::error::TargetNotConnectedException)
pub mod target_not_connected_exception {
    /// A builder for [`TargetNotConnectedException`](crate::error::TargetNotConnectedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetNotConnectedException`](crate::error::TargetNotConnectedException)
        pub fn build(self) -> crate::error::TargetNotConnectedException {
            crate::error::TargetNotConnectedException {
                message: self.message,
            }
        }
    }
}
impl TargetNotConnectedException {
    /// Creates a new builder-style object to manufacture [`TargetNotConnectedException`](crate::error::TargetNotConnectedException)
    pub fn builder() -> crate::error::target_not_connected_exception::Builder {
        crate::error::target_not_connected_exception::Builder::default()
    }
}

/// <p>You cannot delete a cluster that has active tasks.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterContainsTasksException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterContainsTasksException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterContainsTasksException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterContainsTasksException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterContainsTasksException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterContainsTasksException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterContainsTasksException {}
/// See [`ClusterContainsTasksException`](crate::error::ClusterContainsTasksException)
pub mod cluster_contains_tasks_exception {
    /// A builder for [`ClusterContainsTasksException`](crate::error::ClusterContainsTasksException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterContainsTasksException`](crate::error::ClusterContainsTasksException)
        pub fn build(self) -> crate::error::ClusterContainsTasksException {
            crate::error::ClusterContainsTasksException {
                message: self.message,
            }
        }
    }
}
impl ClusterContainsTasksException {
    /// Creates a new builder-style object to manufacture [`ClusterContainsTasksException`](crate::error::ClusterContainsTasksException)
    pub fn builder() -> crate::error::cluster_contains_tasks_exception::Builder {
        crate::error::cluster_contains_tasks_exception::Builder::default()
    }
}

/// <p>You cannot delete a cluster that contains services. First, update the service to
/// reduce its desired task count to 0 and then delete the service. For more information,
/// see <a>UpdateService</a> and <a>DeleteService</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterContainsServicesException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterContainsServicesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterContainsServicesException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterContainsServicesException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterContainsServicesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterContainsServicesException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterContainsServicesException {}
/// See [`ClusterContainsServicesException`](crate::error::ClusterContainsServicesException)
pub mod cluster_contains_services_exception {
    /// A builder for [`ClusterContainsServicesException`](crate::error::ClusterContainsServicesException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterContainsServicesException`](crate::error::ClusterContainsServicesException)
        pub fn build(self) -> crate::error::ClusterContainsServicesException {
            crate::error::ClusterContainsServicesException {
                message: self.message,
            }
        }
    }
}
impl ClusterContainsServicesException {
    /// Creates a new builder-style object to manufacture [`ClusterContainsServicesException`](crate::error::ClusterContainsServicesException)
    pub fn builder() -> crate::error::cluster_contains_services_exception::Builder {
        crate::error::cluster_contains_services_exception::Builder::default()
    }
}

/// <p>You cannot delete a cluster that has registered container instances. First, deregister
/// the container instances before you can delete the cluster. For more information, see
/// <a>DeregisterContainerInstance</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterContainsContainerInstancesException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterContainsContainerInstancesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterContainsContainerInstancesException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterContainsContainerInstancesException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterContainsContainerInstancesException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterContainsContainerInstancesException")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterContainsContainerInstancesException {}
/// See [`ClusterContainsContainerInstancesException`](crate::error::ClusterContainsContainerInstancesException)
pub mod cluster_contains_container_instances_exception {
    /// A builder for [`ClusterContainsContainerInstancesException`](crate::error::ClusterContainsContainerInstancesException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterContainsContainerInstancesException`](crate::error::ClusterContainsContainerInstancesException)
        pub fn build(self) -> crate::error::ClusterContainsContainerInstancesException {
            crate::error::ClusterContainsContainerInstancesException {
                message: self.message,
            }
        }
    }
}
impl ClusterContainsContainerInstancesException {
    /// Creates a new builder-style object to manufacture [`ClusterContainsContainerInstancesException`](crate::error::ClusterContainsContainerInstancesException)
    pub fn builder() -> crate::error::cluster_contains_container_instances_exception::Builder {
        crate::error::cluster_contains_container_instances_exception::Builder::default()
    }
}

/// <p>The limit for the resource has been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}
