// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_capacity_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCapacityProviderOutput,
    crate::error::CreateCapacityProviderError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCapacityProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateCapacityProviderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::CreateCapacityProviderError {
                meta: generic,
                kind: crate::error::CreateCapacityProviderErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCapacityProviderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::CreateCapacityProviderError {
            meta: generic,
            kind: crate::error::CreateCapacityProviderErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCapacityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateCapacityProviderError {
            meta: generic,
            kind: crate::error::CreateCapacityProviderErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCapacityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::CreateCapacityProviderError {
                meta: generic,
                kind: crate::error::CreateCapacityProviderErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCapacityProviderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UpdateInProgressException" => crate::error::CreateCapacityProviderError {
            meta: generic,
            kind: crate::error::CreateCapacityProviderErrorKind::UpdateInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::update_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_update_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCapacityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateCapacityProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_capacity_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCapacityProviderOutput,
    crate::error::CreateCapacityProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_capacity_provider_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_capacity_provider(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateCapacityProviderError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateClusterOutput, crate::error::CreateClusterError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::CreateClusterError {
                meta: generic,
                kind: crate::error::CreateClusterErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::CreateClusterError {
                meta: generic,
                kind: crate::error::CreateClusterErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateClusterOutput, crate::error::CreateClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_cluster_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_service_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateServiceOutput, crate::error::CreateServiceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateServiceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateServiceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateServiceError {
            meta: generic,
            kind: crate::error::CreateServiceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::CreateServiceError {
                meta: generic,
                kind: crate::error::CreateServiceErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::CreateServiceError {
            meta: generic,
            kind: crate::error::CreateServiceErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateServiceError {
            meta: generic,
            kind: crate::error::CreateServiceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PlatformTaskDefinitionIncompatibilityException" => crate::error::CreateServiceError {
            meta: generic,
            kind:
                crate::error::CreateServiceErrorKind::PlatformTaskDefinitionIncompatibilityException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::platform_task_definition_incompatibility_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_platform_task_definition_incompatibility_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "PlatformUnknownException" => crate::error::CreateServiceError {
            meta: generic,
            kind: crate::error::CreateServiceErrorKind::PlatformUnknownException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::platform_unknown_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_platform_unknown_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::CreateServiceError {
                meta: generic,
                kind: crate::error::CreateServiceErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedFeatureException" => crate::error::CreateServiceError {
            meta: generic,
            kind: crate::error::CreateServiceErrorKind::UnsupportedFeatureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_feature_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_feature_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateServiceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_service_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateServiceOutput, crate::error::CreateServiceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_service_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_service(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateServiceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_task_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTaskSetOutput, crate::error::CreateTaskSetError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTaskSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTaskSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateTaskSetError {
            meta: generic,
            kind: crate::error::CreateTaskSetErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::CreateTaskSetError {
                meta: generic,
                kind: crate::error::CreateTaskSetErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTaskSetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::CreateTaskSetError {
            meta: generic,
            kind: crate::error::CreateTaskSetErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CreateTaskSetError {
            meta: generic,
            kind: crate::error::CreateTaskSetErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PlatformTaskDefinitionIncompatibilityException" => crate::error::CreateTaskSetError {
            meta: generic,
            kind:
                crate::error::CreateTaskSetErrorKind::PlatformTaskDefinitionIncompatibilityException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::platform_task_definition_incompatibility_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_platform_task_definition_incompatibility_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTaskSetError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "PlatformUnknownException" => crate::error::CreateTaskSetError {
            meta: generic,
            kind: crate::error::CreateTaskSetErrorKind::PlatformUnknownException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::platform_unknown_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_platform_unknown_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::CreateTaskSetError {
                meta: generic,
                kind: crate::error::CreateTaskSetErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTaskSetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServiceNotActiveException" => crate::error::CreateTaskSetError {
            meta: generic,
            kind: crate::error::CreateTaskSetErrorKind::ServiceNotActiveException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_not_active_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_not_active_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceNotFoundException" => crate::error::CreateTaskSetError {
            meta: generic,
            kind: crate::error::CreateTaskSetErrorKind::ServiceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedFeatureException" => crate::error::CreateTaskSetError {
            meta: generic,
            kind: crate::error::CreateTaskSetErrorKind::UnsupportedFeatureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_feature_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_feature_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateTaskSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_task_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTaskSetOutput, crate::error::CreateTaskSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_task_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_task_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateTaskSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_account_setting_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAccountSettingOutput,
    crate::error::DeleteAccountSettingError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAccountSettingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAccountSettingError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DeleteAccountSettingError {
                meta: generic,
                kind: crate::error::DeleteAccountSettingErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAccountSettingError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::DeleteAccountSettingError {
            meta: generic,
            kind: crate::error::DeleteAccountSettingErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAccountSettingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DeleteAccountSettingError {
                meta: generic,
                kind: crate::error::DeleteAccountSettingErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAccountSettingError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteAccountSettingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_account_setting_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAccountSettingOutput,
    crate::error::DeleteAccountSettingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_account_setting_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_account_setting(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteAccountSettingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAttributesOutput, crate::error::DeleteAttributesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAttributesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFoundException" => crate::error::DeleteAttributesError {
            meta: generic,
            kind: crate::error::DeleteAttributesErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteAttributesError {
            meta: generic,
            kind: crate::error::DeleteAttributesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TargetNotFoundException" => crate::error::DeleteAttributesError {
            meta: generic,
            kind: crate::error::DeleteAttributesErrorKind::TargetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::target_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_target_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAttributesOutput, crate::error::DeleteAttributesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_attributes_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_capacity_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCapacityProviderOutput,
    crate::error::DeleteCapacityProviderError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCapacityProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteCapacityProviderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DeleteCapacityProviderError {
                meta: generic,
                kind: crate::error::DeleteCapacityProviderErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCapacityProviderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::DeleteCapacityProviderError {
            meta: generic,
            kind: crate::error::DeleteCapacityProviderErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCapacityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DeleteCapacityProviderError {
                meta: generic,
                kind: crate::error::DeleteCapacityProviderErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCapacityProviderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteCapacityProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_capacity_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCapacityProviderOutput,
    crate::error::DeleteCapacityProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_capacity_provider_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_capacity_provider(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteCapacityProviderError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteClusterOutput, crate::error::DeleteClusterError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DeleteClusterError {
                meta: generic,
                kind: crate::error::DeleteClusterErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterContainsContainerInstancesException" => crate::error::DeleteClusterError {
            meta: generic,
            kind: crate::error::DeleteClusterErrorKind::ClusterContainsContainerInstancesException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::cluster_contains_container_instances_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_cluster_contains_container_instances_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ClusterContainsServicesException" => crate::error::DeleteClusterError {
            meta: generic,
            kind: crate::error::DeleteClusterErrorKind::ClusterContainsServicesException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_contains_services_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_contains_services_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterContainsTasksException" => crate::error::DeleteClusterError {
            meta: generic,
            kind: crate::error::DeleteClusterErrorKind::ClusterContainsTasksException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_contains_tasks_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_contains_tasks_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterNotFoundException" => crate::error::DeleteClusterError {
            meta: generic,
            kind: crate::error::DeleteClusterErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteClusterError {
            meta: generic,
            kind: crate::error::DeleteClusterErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DeleteClusterError {
                meta: generic,
                kind: crate::error::DeleteClusterErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UpdateInProgressException" => crate::error::DeleteClusterError {
            meta: generic,
            kind: crate::error::DeleteClusterErrorKind::UpdateInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::update_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_update_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteClusterOutput, crate::error::DeleteClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_cluster_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_service_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteServiceOutput, crate::error::DeleteServiceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteServiceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteServiceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DeleteServiceError {
                meta: generic,
                kind: crate::error::DeleteServiceErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteServiceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::DeleteServiceError {
            meta: generic,
            kind: crate::error::DeleteServiceErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteServiceError {
            meta: generic,
            kind: crate::error::DeleteServiceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DeleteServiceError {
                meta: generic,
                kind: crate::error::DeleteServiceErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteServiceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServiceNotFoundException" => crate::error::DeleteServiceError {
            meta: generic,
            kind: crate::error::DeleteServiceErrorKind::ServiceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteServiceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_service_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteServiceOutput, crate::error::DeleteServiceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_service_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_service(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteServiceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_task_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTaskSetOutput, crate::error::DeleteTaskSetError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTaskSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTaskSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteTaskSetError {
            meta: generic,
            kind: crate::error::DeleteTaskSetErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::DeleteTaskSetError {
                meta: generic,
                kind: crate::error::DeleteTaskSetErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTaskSetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::DeleteTaskSetError {
            meta: generic,
            kind: crate::error::DeleteTaskSetErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeleteTaskSetError {
            meta: generic,
            kind: crate::error::DeleteTaskSetErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DeleteTaskSetError {
                meta: generic,
                kind: crate::error::DeleteTaskSetErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTaskSetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServiceNotActiveException" => crate::error::DeleteTaskSetError {
            meta: generic,
            kind: crate::error::DeleteTaskSetErrorKind::ServiceNotActiveException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_not_active_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_not_active_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceNotFoundException" => crate::error::DeleteTaskSetError {
            meta: generic,
            kind: crate::error::DeleteTaskSetErrorKind::ServiceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TaskSetNotFoundException" => crate::error::DeleteTaskSetError {
            meta: generic,
            kind: crate::error::DeleteTaskSetErrorKind::TaskSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::task_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_task_set_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedFeatureException" => crate::error::DeleteTaskSetError {
            meta: generic,
            kind: crate::error::DeleteTaskSetErrorKind::UnsupportedFeatureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_feature_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_feature_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteTaskSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_task_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTaskSetOutput, crate::error::DeleteTaskSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_task_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_task_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteTaskSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_container_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterContainerInstanceOutput,
    crate::error::DeregisterContainerInstanceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeregisterContainerInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeregisterContainerInstanceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DeregisterContainerInstanceError {
                meta: generic,
                kind: crate::error::DeregisterContainerInstanceErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterContainerInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::DeregisterContainerInstanceError {
            meta: generic,
            kind: crate::error::DeregisterContainerInstanceErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterContainerInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DeregisterContainerInstanceError {
            meta: generic,
            kind: crate::error::DeregisterContainerInstanceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterContainerInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DeregisterContainerInstanceError {
                meta: generic,
                kind: crate::error::DeregisterContainerInstanceErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterContainerInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeregisterContainerInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_container_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterContainerInstanceOutput,
    crate::error::DeregisterContainerInstanceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::deregister_container_instance_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_deregister_container_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeregisterContainerInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_task_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterTaskDefinitionOutput,
    crate::error::DeregisterTaskDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeregisterTaskDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeregisterTaskDefinitionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DeregisterTaskDefinitionError {
                meta: generic,
                kind: crate::error::DeregisterTaskDefinitionErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterTaskDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::DeregisterTaskDefinitionError {
            meta: generic,
            kind: crate::error::DeregisterTaskDefinitionErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterTaskDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DeregisterTaskDefinitionError {
                meta: generic,
                kind: crate::error::DeregisterTaskDefinitionErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeregisterTaskDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeregisterTaskDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_task_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterTaskDefinitionOutput,
    crate::error::DeregisterTaskDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::deregister_task_definition_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_deregister_task_definition(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeregisterTaskDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_capacity_providers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCapacityProvidersOutput,
    crate::error::DescribeCapacityProvidersError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCapacityProvidersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeCapacityProvidersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DescribeCapacityProvidersError {
                meta: generic,
                kind: crate::error::DescribeCapacityProvidersErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCapacityProvidersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::DescribeCapacityProvidersError {
            meta: generic,
            kind: crate::error::DescribeCapacityProvidersErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCapacityProvidersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DescribeCapacityProvidersError {
                meta: generic,
                kind: crate::error::DescribeCapacityProvidersErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCapacityProvidersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeCapacityProvidersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_capacity_providers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCapacityProvidersOutput,
    crate::error::DescribeCapacityProvidersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_capacity_providers_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_capacity_providers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeCapacityProvidersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_clusters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeClustersOutput, crate::error::DescribeClustersError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeClustersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeClustersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DescribeClustersError {
                meta: generic,
                kind: crate::error::DescribeClustersErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeClustersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::DescribeClustersError {
            meta: generic,
            kind: crate::error::DescribeClustersErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeClustersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DescribeClustersError {
                meta: generic,
                kind: crate::error::DescribeClustersErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeClustersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeClustersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_clusters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeClustersOutput, crate::error::DescribeClustersError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_clusters_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_clusters(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeClustersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_container_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeContainerInstancesOutput,
    crate::error::DescribeContainerInstancesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeContainerInstancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeContainerInstancesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DescribeContainerInstancesError {
                meta: generic,
                kind: crate::error::DescribeContainerInstancesErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeContainerInstancesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::DescribeContainerInstancesError {
            meta: generic,
            kind: crate::error::DescribeContainerInstancesErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeContainerInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeContainerInstancesError {
            meta: generic,
            kind: crate::error::DescribeContainerInstancesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeContainerInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DescribeContainerInstancesError {
                meta: generic,
                kind: crate::error::DescribeContainerInstancesErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeContainerInstancesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeContainerInstancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_container_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeContainerInstancesOutput,
    crate::error::DescribeContainerInstancesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_container_instances_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_container_instances(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeContainerInstancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_services_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeServicesOutput, crate::error::DescribeServicesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeServicesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeServicesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DescribeServicesError {
                meta: generic,
                kind: crate::error::DescribeServicesErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeServicesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::DescribeServicesError {
            meta: generic,
            kind: crate::error::DescribeServicesErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeServicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeServicesError {
            meta: generic,
            kind: crate::error::DescribeServicesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeServicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DescribeServicesError {
                meta: generic,
                kind: crate::error::DescribeServicesErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeServicesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeServicesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_services_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeServicesOutput, crate::error::DescribeServicesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_services_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_services(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeServicesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_task_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTaskDefinitionOutput,
    crate::error::DescribeTaskDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTaskDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeTaskDefinitionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DescribeTaskDefinitionError {
                meta: generic,
                kind: crate::error::DescribeTaskDefinitionErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTaskDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::DescribeTaskDefinitionError {
            meta: generic,
            kind: crate::error::DescribeTaskDefinitionErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTaskDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DescribeTaskDefinitionError {
                meta: generic,
                kind: crate::error::DescribeTaskDefinitionErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTaskDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeTaskDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_task_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTaskDefinitionOutput,
    crate::error::DescribeTaskDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_task_definition_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_task_definition(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTaskDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tasks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTasksOutput, crate::error::DescribeTasksError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTasksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTasksError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DescribeTasksError {
                meta: generic,
                kind: crate::error::DescribeTasksErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTasksError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::DescribeTasksError {
            meta: generic,
            kind: crate::error::DescribeTasksErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeTasksError {
            meta: generic,
            kind: crate::error::DescribeTasksErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DescribeTasksError {
                meta: generic,
                kind: crate::error::DescribeTasksErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTasksError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeTasksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tasks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTasksOutput, crate::error::DescribeTasksError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_tasks_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_tasks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTasksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_task_sets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTaskSetsOutput, crate::error::DescribeTaskSetsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTaskSetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTaskSetsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DescribeTaskSetsError {
            meta: generic,
            kind: crate::error::DescribeTaskSetsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTaskSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::DescribeTaskSetsError {
                meta: generic,
                kind: crate::error::DescribeTaskSetsErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTaskSetsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::DescribeTaskSetsError {
            meta: generic,
            kind: crate::error::DescribeTaskSetsErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTaskSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeTaskSetsError {
            meta: generic,
            kind: crate::error::DescribeTaskSetsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTaskSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DescribeTaskSetsError {
                meta: generic,
                kind: crate::error::DescribeTaskSetsErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTaskSetsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServiceNotActiveException" => crate::error::DescribeTaskSetsError {
            meta: generic,
            kind: crate::error::DescribeTaskSetsErrorKind::ServiceNotActiveException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_not_active_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_not_active_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTaskSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceNotFoundException" => crate::error::DescribeTaskSetsError {
            meta: generic,
            kind: crate::error::DescribeTaskSetsErrorKind::ServiceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTaskSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedFeatureException" => crate::error::DescribeTaskSetsError {
            meta: generic,
            kind: crate::error::DescribeTaskSetsErrorKind::UnsupportedFeatureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_feature_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_feature_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTaskSetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTaskSetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_task_sets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTaskSetsOutput, crate::error::DescribeTaskSetsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_task_sets_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_task_sets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTaskSetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_discover_poll_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DiscoverPollEndpointOutput,
    crate::error::DiscoverPollEndpointError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DiscoverPollEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DiscoverPollEndpointError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::DiscoverPollEndpointError {
                meta: generic,
                kind: crate::error::DiscoverPollEndpointErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DiscoverPollEndpointError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::DiscoverPollEndpointError {
                meta: generic,
                kind: crate::error::DiscoverPollEndpointErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DiscoverPollEndpointError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DiscoverPollEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_discover_poll_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DiscoverPollEndpointOutput,
    crate::error::DiscoverPollEndpointError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::discover_poll_endpoint_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_discover_poll_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DiscoverPollEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_execute_command_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ExecuteCommandOutput, crate::error::ExecuteCommandError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ExecuteCommandError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ExecuteCommandError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ExecuteCommandError {
            meta: generic,
            kind: crate::error::ExecuteCommandErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteCommandError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::ExecuteCommandError {
                meta: generic,
                kind: crate::error::ExecuteCommandErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteCommandError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::ExecuteCommandError {
            meta: generic,
            kind: crate::error::ExecuteCommandErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteCommandError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ExecuteCommandError {
            meta: generic,
            kind: crate::error::ExecuteCommandErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteCommandError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::ExecuteCommandError {
                meta: generic,
                kind: crate::error::ExecuteCommandErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteCommandError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TargetNotConnectedException" => crate::error::ExecuteCommandError {
            meta: generic,
            kind: crate::error::ExecuteCommandErrorKind::TargetNotConnectedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::target_not_connected_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_target_not_connected_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExecuteCommandError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ExecuteCommandError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_execute_command_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ExecuteCommandOutput, crate::error::ExecuteCommandError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::execute_command_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_execute_command(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ExecuteCommandError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_account_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAccountSettingsOutput,
    crate::error::ListAccountSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAccountSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListAccountSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::ListAccountSettingsError {
                meta: generic,
                kind: crate::error::ListAccountSettingsErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountSettingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::ListAccountSettingsError {
            meta: generic,
            kind: crate::error::ListAccountSettingsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::ListAccountSettingsError {
                meta: generic,
                kind: crate::error::ListAccountSettingsErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAccountSettingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListAccountSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_account_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAccountSettingsOutput,
    crate::error::ListAccountSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_account_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_account_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAccountSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAttributesOutput, crate::error::ListAttributesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListAttributesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFoundException" => crate::error::ListAttributesError {
            meta: generic,
            kind: crate::error::ListAttributesErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListAttributesError {
            meta: generic,
            kind: crate::error::ListAttributesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAttributesOutput, crate::error::ListAttributesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_attributes_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_clusters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListClustersOutput, crate::error::ListClustersError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListClustersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListClustersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::ListClustersError {
                meta: generic,
                kind: crate::error::ListClustersErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListClustersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::ListClustersError {
            meta: generic,
            kind: crate::error::ListClustersErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListClustersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::ListClustersError {
                meta: generic,
                kind: crate::error::ListClustersErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListClustersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListClustersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_clusters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListClustersOutput, crate::error::ListClustersError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_clusters_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_clusters(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListClustersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_container_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListContainerInstancesOutput,
    crate::error::ListContainerInstancesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListContainerInstancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListContainerInstancesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::ListContainerInstancesError {
                meta: generic,
                kind: crate::error::ListContainerInstancesErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListContainerInstancesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::ListContainerInstancesError {
            meta: generic,
            kind: crate::error::ListContainerInstancesErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListContainerInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListContainerInstancesError {
            meta: generic,
            kind: crate::error::ListContainerInstancesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListContainerInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::ListContainerInstancesError {
                meta: generic,
                kind: crate::error::ListContainerInstancesErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListContainerInstancesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListContainerInstancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_container_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListContainerInstancesOutput,
    crate::error::ListContainerInstancesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_container_instances_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_container_instances(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListContainerInstancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_services_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListServicesOutput, crate::error::ListServicesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListServicesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListServicesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::ListServicesError {
                meta: generic,
                kind: crate::error::ListServicesErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListServicesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::ListServicesError {
            meta: generic,
            kind: crate::error::ListServicesErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListServicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListServicesError {
            meta: generic,
            kind: crate::error::ListServicesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListServicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::ListServicesError {
                meta: generic,
                kind: crate::error::ListServicesErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListServicesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListServicesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_services_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListServicesOutput, crate::error::ListServicesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_services_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_services(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListServicesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::ListTagsForResourceError {
                meta: generic,
                kind: crate::error::ListTagsForResourceErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::ListTagsForResourceError {
                meta: generic,
                kind: crate::error::ListTagsForResourceErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_task_definition_families_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTaskDefinitionFamiliesOutput,
    crate::error::ListTaskDefinitionFamiliesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTaskDefinitionFamiliesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListTaskDefinitionFamiliesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::ListTaskDefinitionFamiliesError {
                meta: generic,
                kind: crate::error::ListTaskDefinitionFamiliesErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTaskDefinitionFamiliesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::ListTaskDefinitionFamiliesError {
            meta: generic,
            kind: crate::error::ListTaskDefinitionFamiliesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTaskDefinitionFamiliesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::ListTaskDefinitionFamiliesError {
                meta: generic,
                kind: crate::error::ListTaskDefinitionFamiliesErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTaskDefinitionFamiliesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListTaskDefinitionFamiliesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_task_definition_families_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTaskDefinitionFamiliesOutput,
    crate::error::ListTaskDefinitionFamiliesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_task_definition_families_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_task_definition_families(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTaskDefinitionFamiliesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_task_definitions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTaskDefinitionsOutput,
    crate::error::ListTaskDefinitionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTaskDefinitionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTaskDefinitionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::ListTaskDefinitionsError {
                meta: generic,
                kind: crate::error::ListTaskDefinitionsErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTaskDefinitionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::ListTaskDefinitionsError {
            meta: generic,
            kind: crate::error::ListTaskDefinitionsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTaskDefinitionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::ListTaskDefinitionsError {
                meta: generic,
                kind: crate::error::ListTaskDefinitionsErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTaskDefinitionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListTaskDefinitionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_task_definitions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTaskDefinitionsOutput,
    crate::error::ListTaskDefinitionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_task_definitions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_task_definitions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTaskDefinitionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tasks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTasksOutput, crate::error::ListTasksError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTasksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTasksError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::ListTasksError {
                meta: generic,
                kind: crate::error::ListTasksErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTasksError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::ListTasksError {
            meta: generic,
            kind: crate::error::ListTasksErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::ListTasksError {
            meta: generic,
            kind: crate::error::ListTasksErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::ListTasksError {
                meta: generic,
                kind: crate::error::ListTasksErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTasksError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServiceNotFoundException" => crate::error::ListTasksError {
            meta: generic,
            kind: crate::error::ListTasksErrorKind::ServiceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTasksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tasks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTasksOutput, crate::error::ListTasksError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tasks_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tasks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTasksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_account_setting_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutAccountSettingOutput, crate::error::PutAccountSettingError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutAccountSettingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutAccountSettingError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::PutAccountSettingError {
                meta: generic,
                kind: crate::error::PutAccountSettingErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAccountSettingError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::PutAccountSettingError {
            meta: generic,
            kind: crate::error::PutAccountSettingErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAccountSettingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::PutAccountSettingError {
                meta: generic,
                kind: crate::error::PutAccountSettingErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAccountSettingError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::PutAccountSettingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_account_setting_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutAccountSettingOutput, crate::error::PutAccountSettingError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_account_setting_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_account_setting(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutAccountSettingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_account_setting_default_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutAccountSettingDefaultOutput,
    crate::error::PutAccountSettingDefaultError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutAccountSettingDefaultError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutAccountSettingDefaultError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::PutAccountSettingDefaultError {
                meta: generic,
                kind: crate::error::PutAccountSettingDefaultErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAccountSettingDefaultError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::PutAccountSettingDefaultError {
            meta: generic,
            kind: crate::error::PutAccountSettingDefaultErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAccountSettingDefaultError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::PutAccountSettingDefaultError {
                meta: generic,
                kind: crate::error::PutAccountSettingDefaultErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAccountSettingDefaultError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::PutAccountSettingDefaultError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_account_setting_default_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutAccountSettingDefaultOutput,
    crate::error::PutAccountSettingDefaultError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_account_setting_default_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_account_setting_default(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutAccountSettingDefaultError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutAttributesOutput, crate::error::PutAttributesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutAttributesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AttributeLimitExceededException" => crate::error::PutAttributesError {
            meta: generic,
            kind: crate::error::PutAttributesErrorKind::AttributeLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::attribute_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_attribute_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterNotFoundException" => crate::error::PutAttributesError {
            meta: generic,
            kind: crate::error::PutAttributesErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::PutAttributesError {
            meta: generic,
            kind: crate::error::PutAttributesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TargetNotFoundException" => crate::error::PutAttributesError {
            meta: generic,
            kind: crate::error::PutAttributesErrorKind::TargetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::target_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_target_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutAttributesOutput, crate::error::PutAttributesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_attributes_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_cluster_capacity_providers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutClusterCapacityProvidersOutput,
    crate::error::PutClusterCapacityProvidersError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutClusterCapacityProvidersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutClusterCapacityProvidersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::PutClusterCapacityProvidersError {
                meta: generic,
                kind: crate::error::PutClusterCapacityProvidersErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutClusterCapacityProvidersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::PutClusterCapacityProvidersError {
            meta: generic,
            kind: crate::error::PutClusterCapacityProvidersErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutClusterCapacityProvidersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::PutClusterCapacityProvidersError {
            meta: generic,
            kind: crate::error::PutClusterCapacityProvidersErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutClusterCapacityProvidersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::PutClusterCapacityProvidersError {
            meta: generic,
            kind: crate::error::PutClusterCapacityProvidersErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutClusterCapacityProvidersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::PutClusterCapacityProvidersError {
                meta: generic,
                kind: crate::error::PutClusterCapacityProvidersErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutClusterCapacityProvidersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UpdateInProgressException" => crate::error::PutClusterCapacityProvidersError {
            meta: generic,
            kind: crate::error::PutClusterCapacityProvidersErrorKind::UpdateInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::update_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_update_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutClusterCapacityProvidersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutClusterCapacityProvidersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_cluster_capacity_providers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutClusterCapacityProvidersOutput,
    crate::error::PutClusterCapacityProvidersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_cluster_capacity_providers_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_cluster_capacity_providers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutClusterCapacityProvidersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_container_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterContainerInstanceOutput,
    crate::error::RegisterContainerInstanceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RegisterContainerInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RegisterContainerInstanceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::RegisterContainerInstanceError {
                meta: generic,
                kind: crate::error::RegisterContainerInstanceErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterContainerInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::RegisterContainerInstanceError {
            meta: generic,
            kind: crate::error::RegisterContainerInstanceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterContainerInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::RegisterContainerInstanceError {
                meta: generic,
                kind: crate::error::RegisterContainerInstanceErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterContainerInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::RegisterContainerInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_container_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterContainerInstanceOutput,
    crate::error::RegisterContainerInstanceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::register_container_instance_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_register_container_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RegisterContainerInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_task_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterTaskDefinitionOutput,
    crate::error::RegisterTaskDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RegisterTaskDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RegisterTaskDefinitionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::RegisterTaskDefinitionError {
                meta: generic,
                kind: crate::error::RegisterTaskDefinitionErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterTaskDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::RegisterTaskDefinitionError {
            meta: generic,
            kind: crate::error::RegisterTaskDefinitionErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterTaskDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::RegisterTaskDefinitionError {
                meta: generic,
                kind: crate::error::RegisterTaskDefinitionErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterTaskDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::RegisterTaskDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_task_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterTaskDefinitionOutput,
    crate::error::RegisterTaskDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::register_task_definition_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_register_task_definition(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RegisterTaskDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_run_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RunTaskOutput, crate::error::RunTaskError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RunTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RunTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::RunTaskError {
            meta: generic,
            kind: crate::error::RunTaskErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RunTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BlockedException" => {
            crate::error::RunTaskError {
                meta: generic,
                kind: crate::error::RunTaskErrorKind::BlockedException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::blocked_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_blocked_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RunTaskError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClientException" => {
            crate::error::RunTaskError {
                meta: generic,
                kind: crate::error::RunTaskErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RunTaskError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::RunTaskError {
            meta: generic,
            kind: crate::error::RunTaskErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RunTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::RunTaskError {
            meta: generic,
            kind: crate::error::RunTaskErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RunTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PlatformTaskDefinitionIncompatibilityException" => crate::error::RunTaskError {
            meta: generic,
            kind: crate::error::RunTaskErrorKind::PlatformTaskDefinitionIncompatibilityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]let mut output = crate::error::platform_task_definition_incompatibility_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_platform_task_definition_incompatibility_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RunTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PlatformUnknownException" => crate::error::RunTaskError {
            meta: generic,
            kind: crate::error::RunTaskErrorKind::PlatformUnknownException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::platform_unknown_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_platform_unknown_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RunTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::RunTaskError {
                meta: generic,
                kind: crate::error::RunTaskErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RunTaskError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedFeatureException" => crate::error::RunTaskError {
            meta: generic,
            kind: crate::error::RunTaskErrorKind::UnsupportedFeatureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_feature_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_feature_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RunTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RunTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_run_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RunTaskOutput, crate::error::RunTaskError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::run_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_run_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RunTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartTaskOutput, crate::error::StartTaskError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::StartTaskError {
                meta: generic,
                kind: crate::error::StartTaskErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartTaskError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::StartTaskError {
            meta: generic,
            kind: crate::error::StartTaskErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::StartTaskError {
            meta: generic,
            kind: crate::error::StartTaskErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::StartTaskError {
                meta: generic,
                kind: crate::error::StartTaskErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartTaskError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::StartTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartTaskOutput, crate::error::StartTaskError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopTaskOutput, crate::error::StopTaskError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::StopTaskError {
                meta: generic,
                kind: crate::error::StopTaskErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopTaskError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::StopTaskError {
            meta: generic,
            kind: crate::error::StopTaskErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::StopTaskError {
            meta: generic,
            kind: crate::error::StopTaskErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::StopTaskError {
                meta: generic,
                kind: crate::error::StopTaskErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopTaskError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::StopTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopTaskOutput, crate::error::StopTaskError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_task_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_stop_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_submit_attachment_state_changes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SubmitAttachmentStateChangesOutput,
    crate::error::SubmitAttachmentStateChangesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SubmitAttachmentStateChangesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SubmitAttachmentStateChangesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::SubmitAttachmentStateChangesError {
            meta: generic,
            kind: crate::error::SubmitAttachmentStateChangesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SubmitAttachmentStateChangesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::SubmitAttachmentStateChangesError {
                meta: generic,
                kind: crate::error::SubmitAttachmentStateChangesErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SubmitAttachmentStateChangesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::SubmitAttachmentStateChangesError {
            meta: generic,
            kind: crate::error::SubmitAttachmentStateChangesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SubmitAttachmentStateChangesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::SubmitAttachmentStateChangesError {
                meta: generic,
                kind: crate::error::SubmitAttachmentStateChangesErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SubmitAttachmentStateChangesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::SubmitAttachmentStateChangesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_submit_attachment_state_changes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SubmitAttachmentStateChangesOutput,
    crate::error::SubmitAttachmentStateChangesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::submit_attachment_state_changes_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_submit_attachment_state_changes(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::SubmitAttachmentStateChangesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_submit_container_state_change_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SubmitContainerStateChangeOutput,
    crate::error::SubmitContainerStateChangeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SubmitContainerStateChangeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SubmitContainerStateChangeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::SubmitContainerStateChangeError {
            meta: generic,
            kind: crate::error::SubmitContainerStateChangeErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SubmitContainerStateChangeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::SubmitContainerStateChangeError {
                meta: generic,
                kind: crate::error::SubmitContainerStateChangeErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SubmitContainerStateChangeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServerException" => {
            crate::error::SubmitContainerStateChangeError {
                meta: generic,
                kind: crate::error::SubmitContainerStateChangeErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SubmitContainerStateChangeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::SubmitContainerStateChangeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_submit_container_state_change_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SubmitContainerStateChangeOutput,
    crate::error::SubmitContainerStateChangeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::submit_container_state_change_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_submit_container_state_change(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SubmitContainerStateChangeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_submit_task_state_change_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SubmitTaskStateChangeOutput,
    crate::error::SubmitTaskStateChangeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SubmitTaskStateChangeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SubmitTaskStateChangeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::SubmitTaskStateChangeError {
            meta: generic,
            kind: crate::error::SubmitTaskStateChangeErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SubmitTaskStateChangeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::SubmitTaskStateChangeError {
                meta: generic,
                kind: crate::error::SubmitTaskStateChangeErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SubmitTaskStateChangeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::SubmitTaskStateChangeError {
            meta: generic,
            kind: crate::error::SubmitTaskStateChangeErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SubmitTaskStateChangeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::SubmitTaskStateChangeError {
                meta: generic,
                kind: crate::error::SubmitTaskStateChangeErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SubmitTaskStateChangeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::SubmitTaskStateChangeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_submit_task_state_change_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SubmitTaskStateChangeOutput,
    crate::error::SubmitTaskStateChangeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::submit_task_state_change_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_submit_task_state_change(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SubmitTaskStateChangeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::TagResourceError {
                meta: generic,
                kind: crate::error::TagResourceErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::TagResourceError {
                meta: generic,
                kind: crate::error::TagResourceErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::UntagResourceError {
                meta: generic,
                kind: crate::error::UntagResourceErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::UntagResourceError {
                meta: generic,
                kind: crate::error::UntagResourceErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_capacity_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCapacityProviderOutput,
    crate::error::UpdateCapacityProviderError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateCapacityProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateCapacityProviderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::UpdateCapacityProviderError {
                meta: generic,
                kind: crate::error::UpdateCapacityProviderErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCapacityProviderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterException" => crate::error::UpdateCapacityProviderError {
            meta: generic,
            kind: crate::error::UpdateCapacityProviderErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCapacityProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::UpdateCapacityProviderError {
                meta: generic,
                kind: crate::error::UpdateCapacityProviderErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCapacityProviderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateCapacityProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_capacity_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCapacityProviderOutput,
    crate::error::UpdateCapacityProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_capacity_provider_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_capacity_provider(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateCapacityProviderError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateClusterOutput, crate::error::UpdateClusterError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::UpdateClusterError {
                meta: generic,
                kind: crate::error::UpdateClusterErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::UpdateClusterError {
            meta: generic,
            kind: crate::error::UpdateClusterErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateClusterError {
            meta: generic,
            kind: crate::error::UpdateClusterErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::UpdateClusterError {
                meta: generic,
                kind: crate::error::UpdateClusterErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateClusterOutput, crate::error::UpdateClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_cluster_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_cluster_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateClusterSettingsOutput,
    crate::error::UpdateClusterSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateClusterSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateClusterSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::UpdateClusterSettingsError {
                meta: generic,
                kind: crate::error::UpdateClusterSettingsErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateClusterSettingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::UpdateClusterSettingsError {
            meta: generic,
            kind: crate::error::UpdateClusterSettingsErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateClusterSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateClusterSettingsError {
            meta: generic,
            kind: crate::error::UpdateClusterSettingsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateClusterSettingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::UpdateClusterSettingsError {
                meta: generic,
                kind: crate::error::UpdateClusterSettingsErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateClusterSettingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateClusterSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_cluster_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateClusterSettingsOutput,
    crate::error::UpdateClusterSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_cluster_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_cluster_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateClusterSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_container_agent_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateContainerAgentOutput,
    crate::error::UpdateContainerAgentError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateContainerAgentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateContainerAgentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::UpdateContainerAgentError {
                meta: generic,
                kind: crate::error::UpdateContainerAgentErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContainerAgentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::UpdateContainerAgentError {
            meta: generic,
            kind: crate::error::UpdateContainerAgentErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContainerAgentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateContainerAgentError {
            meta: generic,
            kind: crate::error::UpdateContainerAgentErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContainerAgentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingVersionException" => crate::error::UpdateContainerAgentError {
            meta: generic,
            kind: crate::error::UpdateContainerAgentErrorKind::MissingVersionException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::missing_version_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_missing_version_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContainerAgentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoUpdateAvailableException" => crate::error::UpdateContainerAgentError {
            meta: generic,
            kind: crate::error::UpdateContainerAgentErrorKind::NoUpdateAvailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::no_update_available_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_no_update_available_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContainerAgentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::UpdateContainerAgentError {
                meta: generic,
                kind: crate::error::UpdateContainerAgentErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContainerAgentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UpdateInProgressException" => crate::error::UpdateContainerAgentError {
            meta: generic,
            kind: crate::error::UpdateContainerAgentErrorKind::UpdateInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::update_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_update_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContainerAgentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateContainerAgentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_container_agent_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateContainerAgentOutput,
    crate::error::UpdateContainerAgentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_container_agent_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_container_agent(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateContainerAgentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_container_instances_state_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateContainerInstancesStateOutput,
    crate::error::UpdateContainerInstancesStateError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateContainerInstancesStateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateContainerInstancesStateError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClientException" => {
            crate::error::UpdateContainerInstancesStateError {
                meta: generic,
                kind: crate::error::UpdateContainerInstancesStateErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContainerInstancesStateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::UpdateContainerInstancesStateError {
            meta: generic,
            kind: crate::error::UpdateContainerInstancesStateErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContainerInstancesStateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateContainerInstancesStateError {
            meta: generic,
            kind: crate::error::UpdateContainerInstancesStateErrorKind::InvalidParameterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContainerInstancesStateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ServerException" => {
            crate::error::UpdateContainerInstancesStateError {
                meta: generic,
                kind: crate::error::UpdateContainerInstancesStateErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateContainerInstancesStateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateContainerInstancesStateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_container_instances_state_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateContainerInstancesStateOutput,
    crate::error::UpdateContainerInstancesStateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_container_instances_state_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_update_container_instances_state(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::UpdateContainerInstancesStateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_service_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateServiceOutput, crate::error::UpdateServiceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateServiceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateServiceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateServiceError {
            meta: generic,
            kind: crate::error::UpdateServiceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::UpdateServiceError {
                meta: generic,
                kind: crate::error::UpdateServiceErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::UpdateServiceError {
            meta: generic,
            kind: crate::error::UpdateServiceErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateServiceError {
            meta: generic,
            kind: crate::error::UpdateServiceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PlatformTaskDefinitionIncompatibilityException" => crate::error::UpdateServiceError {
            meta: generic,
            kind:
                crate::error::UpdateServiceErrorKind::PlatformTaskDefinitionIncompatibilityException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::platform_task_definition_incompatibility_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_platform_task_definition_incompatibility_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "PlatformUnknownException" => crate::error::UpdateServiceError {
            meta: generic,
            kind: crate::error::UpdateServiceErrorKind::PlatformUnknownException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::platform_unknown_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_platform_unknown_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::UpdateServiceError {
                meta: generic,
                kind: crate::error::UpdateServiceErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServiceNotActiveException" => crate::error::UpdateServiceError {
            meta: generic,
            kind: crate::error::UpdateServiceErrorKind::ServiceNotActiveException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_not_active_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_not_active_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceNotFoundException" => crate::error::UpdateServiceError {
            meta: generic,
            kind: crate::error::UpdateServiceErrorKind::ServiceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateServiceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_service_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateServiceOutput, crate::error::UpdateServiceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_service_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_service(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateServiceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_service_primary_task_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateServicePrimaryTaskSetOutput,
    crate::error::UpdateServicePrimaryTaskSetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateServicePrimaryTaskSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateServicePrimaryTaskSetError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateServicePrimaryTaskSetError {
            meta: generic,
            kind: crate::error::UpdateServicePrimaryTaskSetErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServicePrimaryTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::UpdateServicePrimaryTaskSetError {
                meta: generic,
                kind: crate::error::UpdateServicePrimaryTaskSetErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServicePrimaryTaskSetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::UpdateServicePrimaryTaskSetError {
            meta: generic,
            kind: crate::error::UpdateServicePrimaryTaskSetErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServicePrimaryTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateServicePrimaryTaskSetError {
            meta: generic,
            kind: crate::error::UpdateServicePrimaryTaskSetErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServicePrimaryTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::UpdateServicePrimaryTaskSetError {
                meta: generic,
                kind: crate::error::UpdateServicePrimaryTaskSetErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServicePrimaryTaskSetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServiceNotActiveException" => crate::error::UpdateServicePrimaryTaskSetError {
            meta: generic,
            kind: crate::error::UpdateServicePrimaryTaskSetErrorKind::ServiceNotActiveException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_not_active_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_not_active_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServicePrimaryTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceNotFoundException" => crate::error::UpdateServicePrimaryTaskSetError {
            meta: generic,
            kind: crate::error::UpdateServicePrimaryTaskSetErrorKind::ServiceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServicePrimaryTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TaskSetNotFoundException" => crate::error::UpdateServicePrimaryTaskSetError {
            meta: generic,
            kind: crate::error::UpdateServicePrimaryTaskSetErrorKind::TaskSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::task_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_task_set_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServicePrimaryTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedFeatureException" => crate::error::UpdateServicePrimaryTaskSetError {
            meta: generic,
            kind: crate::error::UpdateServicePrimaryTaskSetErrorKind::UnsupportedFeatureException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unsupported_feature_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unsupported_feature_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateServicePrimaryTaskSetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::UpdateServicePrimaryTaskSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_service_primary_task_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateServicePrimaryTaskSetOutput,
    crate::error::UpdateServicePrimaryTaskSetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_service_primary_task_set_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_update_service_primary_task_set(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::UpdateServicePrimaryTaskSetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_task_set_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTaskSetOutput, crate::error::UpdateTaskSetError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateTaskSetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateTaskSetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::UpdateTaskSetError {
            meta: generic,
            kind: crate::error::UpdateTaskSetErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClientException" => {
            crate::error::UpdateTaskSetError {
                meta: generic,
                kind: crate::error::UpdateTaskSetErrorKind::ClientException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::client_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_client_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTaskSetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ClusterNotFoundException" => crate::error::UpdateTaskSetError {
            meta: generic,
            kind: crate::error::UpdateTaskSetErrorKind::ClusterNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_cluster_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UpdateTaskSetError {
            meta: generic,
            kind: crate::error::UpdateTaskSetErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::UpdateTaskSetError {
                meta: generic,
                kind: crate::error::UpdateTaskSetErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTaskSetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ServiceNotActiveException" => crate::error::UpdateTaskSetError {
            meta: generic,
            kind: crate::error::UpdateTaskSetErrorKind::ServiceNotActiveException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_not_active_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_not_active_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceNotFoundException" => crate::error::UpdateTaskSetError {
            meta: generic,
            kind: crate::error::UpdateTaskSetErrorKind::ServiceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TaskSetNotFoundException" => crate::error::UpdateTaskSetError {
            meta: generic,
            kind: crate::error::UpdateTaskSetErrorKind::TaskSetNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::task_set_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_task_set_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedFeatureException" => crate::error::UpdateTaskSetError {
            meta: generic,
            kind: crate::error::UpdateTaskSetErrorKind::UnsupportedFeatureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_feature_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_feature_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateTaskSetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateTaskSetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_task_set_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateTaskSetOutput, crate::error::UpdateTaskSetError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_task_set_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_task_set(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateTaskSetError::unhandled)?;
        output.build()
    })
}
