// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code>
/// deployment. An Amazon ECS task set includes details such as the desired number of tasks, how
/// many tasks are running, and whether the task set serves production traffic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskSet {
    /// <p>The ID of the task set.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the task set.</p>
    pub task_set_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the service the task set exists in.</p>
    pub service_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the cluster that the service that hosts the task set exists
    /// in.</p>
    pub cluster_arn: std::option::Option<std::string::String>,
    /// <p>The tag specified when a task set is started. If the task set is created by an CodeDeploy
    /// deployment, the <code>startedBy</code> parameter is <code>CODE_DEPLOY</code>. For a task
    /// set created for an external deployment, the startedBy field isn't used.</p>
    pub started_by: std::option::Option<std::string::String>,
    /// <p>The external ID associated with the task set.</p>
    /// <p>If a task set is created by an CodeDeploy deployment, the <code>externalId</code> parameter
    /// contains the CodeDeploy deployment ID.</p>
    /// <p>If a task set is created for an external deployment and is associated with a service
    /// discovery registry, the <code>externalId</code> parameter contains the
    /// <code>ECS_TASK_SET_EXTERNAL_ID</code> Cloud Map attribute.</p>
    pub external_id: std::option::Option<std::string::String>,
    /// <p>The status of the task set. The following describes each state:</p>
    /// <dl>
    /// <dt>PRIMARY</dt>
    /// <dd>
    /// <p>The task set is serving production traffic.</p>
    /// </dd>
    /// <dt>ACTIVE</dt>
    /// <dd>
    /// <p>The task set is not serving production traffic.</p>
    /// </dd>
    /// <dt>DRAINING</dt>
    /// <dd>
    /// <p>The tasks in the task set are being stopped and their corresponding
    /// targets are being deregistered from their target group.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<std::string::String>,
    /// <p>The task definition the task set is using.</p>
    pub task_definition: std::option::Option<std::string::String>,
    /// <p>The computed desired count for the task set. This is calculated by multiplying the
    /// service's <code>desiredCount</code> by the task set's <code>scale</code> percentage. The
    /// result is always rounded up. For example, if the computed desired count is 1.2, it
    /// rounds up to 2 tasks.</p>
    pub computed_desired_count: i32,
    /// <p>The number of tasks in the task set that are in the <code>PENDING</code> status during
    /// a deployment. A task in the <code>PENDING</code> state is preparing to enter the
    /// <code>RUNNING</code> state. A task set enters the <code>PENDING</code> status when
    /// it launches for the first time or when it is restarted after being in the
    /// <code>STOPPED</code> state.</p>
    pub pending_count: i32,
    /// <p>The number of tasks in the task set that are in the <code>RUNNING</code> status during
    /// a deployment. A task in the <code>RUNNING</code> state is running and ready for
    /// use.</p>
    pub running_count: i32,
    /// <p>The Unix timestamp for when the task set was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Unix timestamp for when the task set was last updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The launch type the tasks in the task set are using. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS
    /// launch types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub launch_type: std::option::Option<crate::model::LaunchType>,
    /// <p>The capacity provider strategy associated with the task set.</p>
    pub capacity_provider_strategy:
        std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
    /// <p>The Fargate platform version on which the tasks in the task set are running. A
    /// platform version is only specified for tasks run on Fargate. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate platform
    /// versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub platform_version: std::option::Option<std::string::String>,
    /// <p>The operating system  that your tasks in the set are running on. A platform family is specified only for tasks using the Fargate launch type. </p>
    /// <p> All tasks in the set must have the same value.</p>
    pub platform_family: std::option::Option<std::string::String>,
    /// <p>The network configuration for the task set.</p>
    pub network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
    /// <p>Details on a load balancer that is used with a task set.</p>
    pub load_balancers: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
    /// <p>The details of the service discovery registries to assign to this task set. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
    /// discovery</a>.</p>
    pub service_registries: std::option::Option<std::vec::Vec<crate::model::ServiceRegistry>>,
    /// <p>A floating-point percentage of the desired number of tasks to place and keep running
    /// in the task set.</p>
    pub scale: std::option::Option<crate::model::Scale>,
    /// <p>The stability status, which indicates whether the task set has reached a steady state.
    /// If the following conditions are met, the task set will be in
    /// <code>STEADY_STATE</code>:</p>
    /// <ul>
    /// <li>
    /// <p>The task <code>runningCount</code> is equal to the
    /// <code>computedDesiredCount</code>.</p>
    /// </li>
    /// <li>
    /// <p>The <code>pendingCount</code> is <code>0</code>.</p>
    /// </li>
    /// <li>
    /// <p>There are no tasks running on container instances in the <code>DRAINING</code>
    /// status.</p>
    /// </li>
    /// <li>
    /// <p>All tasks are reporting a healthy status from the load balancers, service
    /// discovery, and container health checks.</p>
    /// </li>
    /// </ul>
    /// <p>If any of those conditions are not met, the stability status returns
    /// <code>STABILIZING</code>.</p>
    pub stability_status: std::option::Option<crate::model::StabilityStatus>,
    /// <p>The Unix timestamp for when the task set stability status was retrieved.</p>
    pub stability_status_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The metadata that you apply to the task set to help you categorize and organize them.
    /// Each tag consists of a key and an optional value, both of which you define.</p>
    /// <p>The following basic restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of tags per resource - 50</p>
    /// </li>
    /// <li>
    /// <p>For each resource, each tag key must be unique, and each tag key can have only
    /// one value.</p>
    /// </li>
    /// <li>
    /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>If your tagging schema is used across multiple services and resources,
    /// remember that other services may have restrictions on allowed characters.
    /// Generally allowed characters are: letters, numbers, and spaces representable in
    /// UTF-8, and the following characters: + - = . _ : / @.</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
    /// combination of such as a prefix for either keys or values as it is reserved for
    /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
    /// this prefix do not count against your tags per resource limit.</p>
    /// </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for TaskSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskSet");
        formatter.field("id", &self.id);
        formatter.field("task_set_arn", &self.task_set_arn);
        formatter.field("service_arn", &self.service_arn);
        formatter.field("cluster_arn", &self.cluster_arn);
        formatter.field("started_by", &self.started_by);
        formatter.field("external_id", &self.external_id);
        formatter.field("status", &self.status);
        formatter.field("task_definition", &self.task_definition);
        formatter.field("computed_desired_count", &self.computed_desired_count);
        formatter.field("pending_count", &self.pending_count);
        formatter.field("running_count", &self.running_count);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("launch_type", &self.launch_type);
        formatter.field(
            "capacity_provider_strategy",
            &self.capacity_provider_strategy,
        );
        formatter.field("platform_version", &self.platform_version);
        formatter.field("platform_family", &self.platform_family);
        formatter.field("network_configuration", &self.network_configuration);
        formatter.field("load_balancers", &self.load_balancers);
        formatter.field("service_registries", &self.service_registries);
        formatter.field("scale", &self.scale);
        formatter.field("stability_status", &self.stability_status);
        formatter.field("stability_status_at", &self.stability_status_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`TaskSet`](crate::model::TaskSet)
pub mod task_set {
    /// A builder for [`TaskSet`](crate::model::TaskSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) task_set_arn: std::option::Option<std::string::String>,
        pub(crate) service_arn: std::option::Option<std::string::String>,
        pub(crate) cluster_arn: std::option::Option<std::string::String>,
        pub(crate) started_by: std::option::Option<std::string::String>,
        pub(crate) external_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) task_definition: std::option::Option<std::string::String>,
        pub(crate) computed_desired_count: std::option::Option<i32>,
        pub(crate) pending_count: std::option::Option<i32>,
        pub(crate) running_count: std::option::Option<i32>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) launch_type: std::option::Option<crate::model::LaunchType>,
        pub(crate) capacity_provider_strategy:
            std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        pub(crate) platform_version: std::option::Option<std::string::String>,
        pub(crate) platform_family: std::option::Option<std::string::String>,
        pub(crate) network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
        pub(crate) load_balancers: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
        pub(crate) service_registries:
            std::option::Option<std::vec::Vec<crate::model::ServiceRegistry>>,
        pub(crate) scale: std::option::Option<crate::model::Scale>,
        pub(crate) stability_status: std::option::Option<crate::model::StabilityStatus>,
        pub(crate) stability_status_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the task set.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the task set.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task set.</p>
        pub fn task_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_set_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task set.</p>
        pub fn set_task_set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_set_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service the task set exists in.</p>
        pub fn service_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service the task set exists in.</p>
        pub fn set_service_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster that the service that hosts the task set exists
        /// in.</p>
        pub fn cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster that the service that hosts the task set exists
        /// in.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_arn = input;
            self
        }
        /// <p>The tag specified when a task set is started. If the task set is created by an CodeDeploy
        /// deployment, the <code>startedBy</code> parameter is <code>CODE_DEPLOY</code>. For a task
        /// set created for an external deployment, the startedBy field isn't used.</p>
        pub fn started_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.started_by = Some(input.into());
            self
        }
        /// <p>The tag specified when a task set is started. If the task set is created by an CodeDeploy
        /// deployment, the <code>startedBy</code> parameter is <code>CODE_DEPLOY</code>. For a task
        /// set created for an external deployment, the startedBy field isn't used.</p>
        pub fn set_started_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.started_by = input;
            self
        }
        /// <p>The external ID associated with the task set.</p>
        /// <p>If a task set is created by an CodeDeploy deployment, the <code>externalId</code> parameter
        /// contains the CodeDeploy deployment ID.</p>
        /// <p>If a task set is created for an external deployment and is associated with a service
        /// discovery registry, the <code>externalId</code> parameter contains the
        /// <code>ECS_TASK_SET_EXTERNAL_ID</code> Cloud Map attribute.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>The external ID associated with the task set.</p>
        /// <p>If a task set is created by an CodeDeploy deployment, the <code>externalId</code> parameter
        /// contains the CodeDeploy deployment ID.</p>
        /// <p>If a task set is created for an external deployment and is associated with a service
        /// discovery registry, the <code>externalId</code> parameter contains the
        /// <code>ECS_TASK_SET_EXTERNAL_ID</code> Cloud Map attribute.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// <p>The status of the task set. The following describes each state:</p>
        /// <dl>
        /// <dt>PRIMARY</dt>
        /// <dd>
        /// <p>The task set is serving production traffic.</p>
        /// </dd>
        /// <dt>ACTIVE</dt>
        /// <dd>
        /// <p>The task set is not serving production traffic.</p>
        /// </dd>
        /// <dt>DRAINING</dt>
        /// <dd>
        /// <p>The tasks in the task set are being stopped and their corresponding
        /// targets are being deregistered from their target group.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the task set. The following describes each state:</p>
        /// <dl>
        /// <dt>PRIMARY</dt>
        /// <dd>
        /// <p>The task set is serving production traffic.</p>
        /// </dd>
        /// <dt>ACTIVE</dt>
        /// <dd>
        /// <p>The task set is not serving production traffic.</p>
        /// </dd>
        /// <dt>DRAINING</dt>
        /// <dd>
        /// <p>The tasks in the task set are being stopped and their corresponding
        /// targets are being deregistered from their target group.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The task definition the task set is using.</p>
        pub fn task_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_definition = Some(input.into());
            self
        }
        /// <p>The task definition the task set is using.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_definition = input;
            self
        }
        /// <p>The computed desired count for the task set. This is calculated by multiplying the
        /// service's <code>desiredCount</code> by the task set's <code>scale</code> percentage. The
        /// result is always rounded up. For example, if the computed desired count is 1.2, it
        /// rounds up to 2 tasks.</p>
        pub fn computed_desired_count(mut self, input: i32) -> Self {
            self.computed_desired_count = Some(input);
            self
        }
        /// <p>The computed desired count for the task set. This is calculated by multiplying the
        /// service's <code>desiredCount</code> by the task set's <code>scale</code> percentage. The
        /// result is always rounded up. For example, if the computed desired count is 1.2, it
        /// rounds up to 2 tasks.</p>
        pub fn set_computed_desired_count(mut self, input: std::option::Option<i32>) -> Self {
            self.computed_desired_count = input;
            self
        }
        /// <p>The number of tasks in the task set that are in the <code>PENDING</code> status during
        /// a deployment. A task in the <code>PENDING</code> state is preparing to enter the
        /// <code>RUNNING</code> state. A task set enters the <code>PENDING</code> status when
        /// it launches for the first time or when it is restarted after being in the
        /// <code>STOPPED</code> state.</p>
        pub fn pending_count(mut self, input: i32) -> Self {
            self.pending_count = Some(input);
            self
        }
        /// <p>The number of tasks in the task set that are in the <code>PENDING</code> status during
        /// a deployment. A task in the <code>PENDING</code> state is preparing to enter the
        /// <code>RUNNING</code> state. A task set enters the <code>PENDING</code> status when
        /// it launches for the first time or when it is restarted after being in the
        /// <code>STOPPED</code> state.</p>
        pub fn set_pending_count(mut self, input: std::option::Option<i32>) -> Self {
            self.pending_count = input;
            self
        }
        /// <p>The number of tasks in the task set that are in the <code>RUNNING</code> status during
        /// a deployment. A task in the <code>RUNNING</code> state is running and ready for
        /// use.</p>
        pub fn running_count(mut self, input: i32) -> Self {
            self.running_count = Some(input);
            self
        }
        /// <p>The number of tasks in the task set that are in the <code>RUNNING</code> status during
        /// a deployment. A task in the <code>RUNNING</code> state is running and ready for
        /// use.</p>
        pub fn set_running_count(mut self, input: std::option::Option<i32>) -> Self {
            self.running_count = input;
            self
        }
        /// <p>The Unix timestamp for when the task set was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the task set was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Unix timestamp for when the task set was last updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the task set was last updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The launch type the tasks in the task set are using. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS
        /// launch types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn launch_type(mut self, input: crate::model::LaunchType) -> Self {
            self.launch_type = Some(input);
            self
        }
        /// <p>The launch type the tasks in the task set are using. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS
        /// launch types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_launch_type(
            mut self,
            input: std::option::Option<crate::model::LaunchType>,
        ) -> Self {
            self.launch_type = input;
            self
        }
        /// Appends an item to `capacity_provider_strategy`.
        ///
        /// To override the contents of this collection use [`set_capacity_provider_strategy`](Self::set_capacity_provider_strategy).
        ///
        /// <p>The capacity provider strategy associated with the task set.</p>
        pub fn capacity_provider_strategy(
            mut self,
            input: impl Into<crate::model::CapacityProviderStrategyItem>,
        ) -> Self {
            let mut v = self.capacity_provider_strategy.unwrap_or_default();
            v.push(input.into());
            self.capacity_provider_strategy = Some(v);
            self
        }
        /// <p>The capacity provider strategy associated with the task set.</p>
        pub fn set_capacity_provider_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        ) -> Self {
            self.capacity_provider_strategy = input;
            self
        }
        /// <p>The Fargate platform version on which the tasks in the task set are running. A
        /// platform version is only specified for tasks run on Fargate. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate platform
        /// versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_version = Some(input.into());
            self
        }
        /// <p>The Fargate platform version on which the tasks in the task set are running. A
        /// platform version is only specified for tasks run on Fargate. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate platform
        /// versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_version = input;
            self
        }
        /// <p>The operating system  that your tasks in the set are running on. A platform family is specified only for tasks using the Fargate launch type. </p>
        /// <p> All tasks in the set must have the same value.</p>
        pub fn platform_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_family = Some(input.into());
            self
        }
        /// <p>The operating system  that your tasks in the set are running on. A platform family is specified only for tasks using the Fargate launch type. </p>
        /// <p> All tasks in the set must have the same value.</p>
        pub fn set_platform_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_family = input;
            self
        }
        /// <p>The network configuration for the task set.</p>
        pub fn network_configuration(mut self, input: crate::model::NetworkConfiguration) -> Self {
            self.network_configuration = Some(input);
            self
        }
        /// <p>The network configuration for the task set.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkConfiguration>,
        ) -> Self {
            self.network_configuration = input;
            self
        }
        /// Appends an item to `load_balancers`.
        ///
        /// To override the contents of this collection use [`set_load_balancers`](Self::set_load_balancers).
        ///
        /// <p>Details on a load balancer that is used with a task set.</p>
        pub fn load_balancers(mut self, input: impl Into<crate::model::LoadBalancer>) -> Self {
            let mut v = self.load_balancers.unwrap_or_default();
            v.push(input.into());
            self.load_balancers = Some(v);
            self
        }
        /// <p>Details on a load balancer that is used with a task set.</p>
        pub fn set_load_balancers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
        ) -> Self {
            self.load_balancers = input;
            self
        }
        /// Appends an item to `service_registries`.
        ///
        /// To override the contents of this collection use [`set_service_registries`](Self::set_service_registries).
        ///
        /// <p>The details of the service discovery registries to assign to this task set. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
        /// discovery</a>.</p>
        pub fn service_registries(
            mut self,
            input: impl Into<crate::model::ServiceRegistry>,
        ) -> Self {
            let mut v = self.service_registries.unwrap_or_default();
            v.push(input.into());
            self.service_registries = Some(v);
            self
        }
        /// <p>The details of the service discovery registries to assign to this task set. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
        /// discovery</a>.</p>
        pub fn set_service_registries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceRegistry>>,
        ) -> Self {
            self.service_registries = input;
            self
        }
        /// <p>A floating-point percentage of the desired number of tasks to place and keep running
        /// in the task set.</p>
        pub fn scale(mut self, input: crate::model::Scale) -> Self {
            self.scale = Some(input);
            self
        }
        /// <p>A floating-point percentage of the desired number of tasks to place and keep running
        /// in the task set.</p>
        pub fn set_scale(mut self, input: std::option::Option<crate::model::Scale>) -> Self {
            self.scale = input;
            self
        }
        /// <p>The stability status, which indicates whether the task set has reached a steady state.
        /// If the following conditions are met, the task set will be in
        /// <code>STEADY_STATE</code>:</p>
        /// <ul>
        /// <li>
        /// <p>The task <code>runningCount</code> is equal to the
        /// <code>computedDesiredCount</code>.</p>
        /// </li>
        /// <li>
        /// <p>The <code>pendingCount</code> is <code>0</code>.</p>
        /// </li>
        /// <li>
        /// <p>There are no tasks running on container instances in the <code>DRAINING</code>
        /// status.</p>
        /// </li>
        /// <li>
        /// <p>All tasks are reporting a healthy status from the load balancers, service
        /// discovery, and container health checks.</p>
        /// </li>
        /// </ul>
        /// <p>If any of those conditions are not met, the stability status returns
        /// <code>STABILIZING</code>.</p>
        pub fn stability_status(mut self, input: crate::model::StabilityStatus) -> Self {
            self.stability_status = Some(input);
            self
        }
        /// <p>The stability status, which indicates whether the task set has reached a steady state.
        /// If the following conditions are met, the task set will be in
        /// <code>STEADY_STATE</code>:</p>
        /// <ul>
        /// <li>
        /// <p>The task <code>runningCount</code> is equal to the
        /// <code>computedDesiredCount</code>.</p>
        /// </li>
        /// <li>
        /// <p>The <code>pendingCount</code> is <code>0</code>.</p>
        /// </li>
        /// <li>
        /// <p>There are no tasks running on container instances in the <code>DRAINING</code>
        /// status.</p>
        /// </li>
        /// <li>
        /// <p>All tasks are reporting a healthy status from the load balancers, service
        /// discovery, and container health checks.</p>
        /// </li>
        /// </ul>
        /// <p>If any of those conditions are not met, the stability status returns
        /// <code>STABILIZING</code>.</p>
        pub fn set_stability_status(
            mut self,
            input: std::option::Option<crate::model::StabilityStatus>,
        ) -> Self {
            self.stability_status = input;
            self
        }
        /// <p>The Unix timestamp for when the task set stability status was retrieved.</p>
        pub fn stability_status_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stability_status_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the task set stability status was retrieved.</p>
        pub fn set_stability_status_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stability_status_at = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the task set to help you categorize and organize them.
        /// Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The metadata that you apply to the task set to help you categorize and organize them.
        /// Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskSet`](crate::model::TaskSet)
        pub fn build(self) -> crate::model::TaskSet {
            crate::model::TaskSet {
                id: self.id,
                task_set_arn: self.task_set_arn,
                service_arn: self.service_arn,
                cluster_arn: self.cluster_arn,
                started_by: self.started_by,
                external_id: self.external_id,
                status: self.status,
                task_definition: self.task_definition,
                computed_desired_count: self.computed_desired_count.unwrap_or_default(),
                pending_count: self.pending_count.unwrap_or_default(),
                running_count: self.running_count.unwrap_or_default(),
                created_at: self.created_at,
                updated_at: self.updated_at,
                launch_type: self.launch_type,
                capacity_provider_strategy: self.capacity_provider_strategy,
                platform_version: self.platform_version,
                platform_family: self.platform_family,
                network_configuration: self.network_configuration,
                load_balancers: self.load_balancers,
                service_registries: self.service_registries,
                scale: self.scale,
                stability_status: self.stability_status,
                stability_status_at: self.stability_status_at,
                tags: self.tags,
            }
        }
    }
}
impl TaskSet {
    /// Creates a new builder-style object to manufacture [`TaskSet`](crate::model::TaskSet)
    pub fn builder() -> crate::model::task_set::Builder {
        crate::model::task_set::Builder::default()
    }
}

/// <p>The metadata that you apply to a resource to help you categorize and organize them.
/// Each tag consists of a key and an optional value, both of which you define.</p>
/// <p>The following basic restrictions apply to tags:</p>
/// <ul>
/// <li>
/// <p>Maximum number of tags per resource - 50</p>
/// </li>
/// <li>
/// <p>For each resource, each tag key must be unique, and each tag key can have only
/// one value.</p>
/// </li>
/// <li>
/// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
/// </li>
/// <li>
/// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
/// </li>
/// <li>
/// <p>If your tagging schema is used across multiple services and resources,
/// remember that other services may have restrictions on allowed characters.
/// Generally allowed characters are: letters, numbers, and spaces representable in
/// UTF-8, and the following characters: + - = . _ : / @.</p>
/// </li>
/// <li>
/// <p>Tag keys and values are case-sensitive.</p>
/// </li>
/// <li>
/// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
/// combination of such as a prefix for either keys or values as it is reserved for
/// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
/// this prefix do not count against your tags per resource limit.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>One part of a key-value pair that make up a tag. A <code>key</code> is a general label
    /// that acts like a category for more specific tag values.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The optional part of a key-value pair that make up a tag. A <code>value</code> acts as
    /// a descriptor within a tag category (key).</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>One part of a key-value pair that make up a tag. A <code>key</code> is a general label
        /// that acts like a category for more specific tag values.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>One part of a key-value pair that make up a tag. A <code>key</code> is a general label
        /// that acts like a category for more specific tag values.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The optional part of a key-value pair that make up a tag. A <code>value</code> acts as
        /// a descriptor within a tag category (key).</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The optional part of a key-value pair that make up a tag. A <code>value</code> acts as
        /// a descriptor within a tag category (key).</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StabilityStatus {
    #[allow(missing_docs)] // documentation missing in model
    Stabilizing,
    #[allow(missing_docs)] // documentation missing in model
    SteadyState,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StabilityStatus {
    fn from(s: &str) -> Self {
        match s {
            "STABILIZING" => StabilityStatus::Stabilizing,
            "STEADY_STATE" => StabilityStatus::SteadyState,
            other => StabilityStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StabilityStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StabilityStatus::from(s))
    }
}
impl StabilityStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StabilityStatus::Stabilizing => "STABILIZING",
            StabilityStatus::SteadyState => "STEADY_STATE",
            StabilityStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["STABILIZING", "STEADY_STATE"]
    }
}
impl AsRef<str> for StabilityStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A floating-point percentage of the desired number of tasks to place and keep running
/// in the task set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Scale {
    /// <p>The value, specified as a percent total of a service's <code>desiredCount</code>, to
    /// scale the task set. Accepted values are numbers between 0 and 100.</p>
    pub value: f64,
    /// <p>The unit of measure for the scale value.</p>
    pub unit: std::option::Option<crate::model::ScaleUnit>,
}
impl std::fmt::Debug for Scale {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Scale");
        formatter.field("value", &self.value);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`Scale`](crate::model::Scale)
pub mod scale {
    /// A builder for [`Scale`](crate::model::Scale)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<f64>,
        pub(crate) unit: std::option::Option<crate::model::ScaleUnit>,
    }
    impl Builder {
        /// <p>The value, specified as a percent total of a service's <code>desiredCount</code>, to
        /// scale the task set. Accepted values are numbers between 0 and 100.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value, specified as a percent total of a service's <code>desiredCount</code>, to
        /// scale the task set. Accepted values are numbers between 0 and 100.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// <p>The unit of measure for the scale value.</p>
        pub fn unit(mut self, input: crate::model::ScaleUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>The unit of measure for the scale value.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::ScaleUnit>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`Scale`](crate::model::Scale)
        pub fn build(self) -> crate::model::Scale {
            crate::model::Scale {
                value: self.value.unwrap_or_default(),
                unit: self.unit,
            }
        }
    }
}
impl Scale {
    /// Creates a new builder-style object to manufacture [`Scale`](crate::model::Scale)
    pub fn builder() -> crate::model::scale::Builder {
        crate::model::scale::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScaleUnit {
    #[allow(missing_docs)] // documentation missing in model
    Percent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScaleUnit {
    fn from(s: &str) -> Self {
        match s {
            "PERCENT" => ScaleUnit::Percent,
            other => ScaleUnit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScaleUnit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScaleUnit::from(s))
    }
}
impl ScaleUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScaleUnit::Percent => "PERCENT",
            ScaleUnit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PERCENT"]
    }
}
impl AsRef<str> for ScaleUnit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details of the service registry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceRegistry {
    /// <p>The Amazon Resource Name (ARN) of the service registry. The currently supported service registry is
    /// Cloud Map. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html">CreateService</a>.</p>
    pub registry_arn: std::option::Option<std::string::String>,
    /// <p>The port value used if your service discovery service specified an SRV record. This
    /// field may be used if both the <code>awsvpc</code> network mode and SRV records are
    /// used.</p>
    pub port: std::option::Option<i32>,
    /// <p>The container name value, already specified in the task definition, to be used for
    /// your service discovery service. If the task definition that your service task specifies
    /// uses the <code>bridge</code> or <code>host</code> network mode, you must specify a
    /// <code>containerName</code> and <code>containerPort</code> combination from the task
    /// definition. If the task definition that your service task specifies uses the
    /// <code>awsvpc</code> network mode and a type SRV DNS record is used, you must specify
    /// either a <code>containerName</code> and <code>containerPort</code> combination or a
    /// <code>port</code> value, but not both.</p>
    pub container_name: std::option::Option<std::string::String>,
    /// <p>The port value, already specified in the task definition, to be used for your service
    /// discovery service. If the task definition your service task specifies uses the
    /// <code>bridge</code> or <code>host</code> network mode, you must specify a
    /// <code>containerName</code> and <code>containerPort</code> combination from the task
    /// definition. If the task definition your service task specifies uses the
    /// <code>awsvpc</code> network mode and a type SRV DNS record is used, you must specify
    /// either a <code>containerName</code> and <code>containerPort</code> combination or a
    /// <code>port</code> value, but not both.</p>
    pub container_port: std::option::Option<i32>,
}
impl std::fmt::Debug for ServiceRegistry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceRegistry");
        formatter.field("registry_arn", &self.registry_arn);
        formatter.field("port", &self.port);
        formatter.field("container_name", &self.container_name);
        formatter.field("container_port", &self.container_port);
        formatter.finish()
    }
}
/// See [`ServiceRegistry`](crate::model::ServiceRegistry)
pub mod service_registry {
    /// A builder for [`ServiceRegistry`](crate::model::ServiceRegistry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_arn: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) container_name: std::option::Option<std::string::String>,
        pub(crate) container_port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the service registry. The currently supported service registry is
        /// Cloud Map. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html">CreateService</a>.</p>
        pub fn registry_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service registry. The currently supported service registry is
        /// Cloud Map. For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html">CreateService</a>.</p>
        pub fn set_registry_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_arn = input;
            self
        }
        /// <p>The port value used if your service discovery service specified an SRV record. This
        /// field may be used if both the <code>awsvpc</code> network mode and SRV records are
        /// used.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port value used if your service discovery service specified an SRV record. This
        /// field may be used if both the <code>awsvpc</code> network mode and SRV records are
        /// used.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The container name value, already specified in the task definition, to be used for
        /// your service discovery service. If the task definition that your service task specifies
        /// uses the <code>bridge</code> or <code>host</code> network mode, you must specify a
        /// <code>containerName</code> and <code>containerPort</code> combination from the task
        /// definition. If the task definition that your service task specifies uses the
        /// <code>awsvpc</code> network mode and a type SRV DNS record is used, you must specify
        /// either a <code>containerName</code> and <code>containerPort</code> combination or a
        /// <code>port</code> value, but not both.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_name = Some(input.into());
            self
        }
        /// <p>The container name value, already specified in the task definition, to be used for
        /// your service discovery service. If the task definition that your service task specifies
        /// uses the <code>bridge</code> or <code>host</code> network mode, you must specify a
        /// <code>containerName</code> and <code>containerPort</code> combination from the task
        /// definition. If the task definition that your service task specifies uses the
        /// <code>awsvpc</code> network mode and a type SRV DNS record is used, you must specify
        /// either a <code>containerName</code> and <code>containerPort</code> combination or a
        /// <code>port</code> value, but not both.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_name = input;
            self
        }
        /// <p>The port value, already specified in the task definition, to be used for your service
        /// discovery service. If the task definition your service task specifies uses the
        /// <code>bridge</code> or <code>host</code> network mode, you must specify a
        /// <code>containerName</code> and <code>containerPort</code> combination from the task
        /// definition. If the task definition your service task specifies uses the
        /// <code>awsvpc</code> network mode and a type SRV DNS record is used, you must specify
        /// either a <code>containerName</code> and <code>containerPort</code> combination or a
        /// <code>port</code> value, but not both.</p>
        pub fn container_port(mut self, input: i32) -> Self {
            self.container_port = Some(input);
            self
        }
        /// <p>The port value, already specified in the task definition, to be used for your service
        /// discovery service. If the task definition your service task specifies uses the
        /// <code>bridge</code> or <code>host</code> network mode, you must specify a
        /// <code>containerName</code> and <code>containerPort</code> combination from the task
        /// definition. If the task definition your service task specifies uses the
        /// <code>awsvpc</code> network mode and a type SRV DNS record is used, you must specify
        /// either a <code>containerName</code> and <code>containerPort</code> combination or a
        /// <code>port</code> value, but not both.</p>
        pub fn set_container_port(mut self, input: std::option::Option<i32>) -> Self {
            self.container_port = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceRegistry`](crate::model::ServiceRegistry)
        pub fn build(self) -> crate::model::ServiceRegistry {
            crate::model::ServiceRegistry {
                registry_arn: self.registry_arn,
                port: self.port,
                container_name: self.container_name,
                container_port: self.container_port,
            }
        }
    }
}
impl ServiceRegistry {
    /// Creates a new builder-style object to manufacture [`ServiceRegistry`](crate::model::ServiceRegistry)
    pub fn builder() -> crate::model::service_registry::Builder {
        crate::model::service_registry::Builder::default()
    }
}

/// <p>The load balancer configuration to use with a service or task set.</p>
/// <p>For specific notes and restrictions regarding the use of load balancers with services
/// and task sets, see the CreateService and CreateTaskSet actions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadBalancer {
    /// <p>The full Amazon Resource Name (ARN) of the Elastic Load Balancing target group or groups associated with a service or
    /// task set.</p>
    /// <p>A target group ARN is only specified when using an Application Load Balancer or Network Load Balancer. If you are using a
    /// Classic Load Balancer the target group ARN should be omitted.</p>
    /// <p>For services using the <code>ECS</code> deployment controller, you can specify one or
    /// multiple target groups. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Registering Multiple Target Groups with a Service</a> in
    /// the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>For services using the <code>CODE_DEPLOY</code> deployment controller, you are
    /// required to define two target groups for the load balancer. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-bluegreen.html">Blue/Green Deployment with CodeDeploy</a> in the
    /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <important>
    /// <p>If your service's task definition uses the <code>awsvpc</code> network mode (which
    /// is required for the Fargate launch type), you must choose
    /// <code>ip</code> as the target type, not <code>instance</code>, when creating
    /// your target groups because tasks that use the <code>awsvpc</code> network mode are
    /// associated with an elastic network interface, not an Amazon EC2 instance.</p>
    /// </important>
    pub target_group_arn: std::option::Option<std::string::String>,
    /// <p>The name of the load balancer to associate with the Amazon ECS service or task set.</p>
    /// <p>A load balancer name is only specified when using a Classic Load Balancer. If you are using an Application Load Balancer
    /// or a Network Load Balancer the load balancer name parameter should be omitted.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>The name of the container (as it appears in a container definition) to associate with
    /// the load balancer.</p>
    pub container_name: std::option::Option<std::string::String>,
    /// <p>The port on the container to associate with the load balancer. This port must
    /// correspond to a <code>containerPort</code> in the task definition the tasks in the
    /// service are using. For tasks that use the EC2 launch type, the container
    /// instance they are launched on must allow ingress traffic on the <code>hostPort</code> of
    /// the port mapping.</p>
    pub container_port: std::option::Option<i32>,
}
impl std::fmt::Debug for LoadBalancer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadBalancer");
        formatter.field("target_group_arn", &self.target_group_arn);
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("container_name", &self.container_name);
        formatter.field("container_port", &self.container_port);
        formatter.finish()
    }
}
/// See [`LoadBalancer`](crate::model::LoadBalancer)
pub mod load_balancer {
    /// A builder for [`LoadBalancer`](crate::model::LoadBalancer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_group_arn: std::option::Option<std::string::String>,
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) container_name: std::option::Option<std::string::String>,
        pub(crate) container_port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The full Amazon Resource Name (ARN) of the Elastic Load Balancing target group or groups associated with a service or
        /// task set.</p>
        /// <p>A target group ARN is only specified when using an Application Load Balancer or Network Load Balancer. If you are using a
        /// Classic Load Balancer the target group ARN should be omitted.</p>
        /// <p>For services using the <code>ECS</code> deployment controller, you can specify one or
        /// multiple target groups. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Registering Multiple Target Groups with a Service</a> in
        /// the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>For services using the <code>CODE_DEPLOY</code> deployment controller, you are
        /// required to define two target groups for the load balancer. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-bluegreen.html">Blue/Green Deployment with CodeDeploy</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <important>
        /// <p>If your service's task definition uses the <code>awsvpc</code> network mode (which
        /// is required for the Fargate launch type), you must choose
        /// <code>ip</code> as the target type, not <code>instance</code>, when creating
        /// your target groups because tasks that use the <code>awsvpc</code> network mode are
        /// associated with an elastic network interface, not an Amazon EC2 instance.</p>
        /// </important>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_group_arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the Elastic Load Balancing target group or groups associated with a service or
        /// task set.</p>
        /// <p>A target group ARN is only specified when using an Application Load Balancer or Network Load Balancer. If you are using a
        /// Classic Load Balancer the target group ARN should be omitted.</p>
        /// <p>For services using the <code>ECS</code> deployment controller, you can specify one or
        /// multiple target groups. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Registering Multiple Target Groups with a Service</a> in
        /// the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>For services using the <code>CODE_DEPLOY</code> deployment controller, you are
        /// required to define two target groups for the load balancer. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-bluegreen.html">Blue/Green Deployment with CodeDeploy</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <important>
        /// <p>If your service's task definition uses the <code>awsvpc</code> network mode (which
        /// is required for the Fargate launch type), you must choose
        /// <code>ip</code> as the target type, not <code>instance</code>, when creating
        /// your target groups because tasks that use the <code>awsvpc</code> network mode are
        /// associated with an elastic network interface, not an Amazon EC2 instance.</p>
        /// </important>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_group_arn = input;
            self
        }
        /// <p>The name of the load balancer to associate with the Amazon ECS service or task set.</p>
        /// <p>A load balancer name is only specified when using a Classic Load Balancer. If you are using an Application Load Balancer
        /// or a Network Load Balancer the load balancer name parameter should be omitted.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer to associate with the Amazon ECS service or task set.</p>
        /// <p>A load balancer name is only specified when using a Classic Load Balancer. If you are using an Application Load Balancer
        /// or a Network Load Balancer the load balancer name parameter should be omitted.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>The name of the container (as it appears in a container definition) to associate with
        /// the load balancer.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_name = Some(input.into());
            self
        }
        /// <p>The name of the container (as it appears in a container definition) to associate with
        /// the load balancer.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_name = input;
            self
        }
        /// <p>The port on the container to associate with the load balancer. This port must
        /// correspond to a <code>containerPort</code> in the task definition the tasks in the
        /// service are using. For tasks that use the EC2 launch type, the container
        /// instance they are launched on must allow ingress traffic on the <code>hostPort</code> of
        /// the port mapping.</p>
        pub fn container_port(mut self, input: i32) -> Self {
            self.container_port = Some(input);
            self
        }
        /// <p>The port on the container to associate with the load balancer. This port must
        /// correspond to a <code>containerPort</code> in the task definition the tasks in the
        /// service are using. For tasks that use the EC2 launch type, the container
        /// instance they are launched on must allow ingress traffic on the <code>hostPort</code> of
        /// the port mapping.</p>
        pub fn set_container_port(mut self, input: std::option::Option<i32>) -> Self {
            self.container_port = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadBalancer`](crate::model::LoadBalancer)
        pub fn build(self) -> crate::model::LoadBalancer {
            crate::model::LoadBalancer {
                target_group_arn: self.target_group_arn,
                load_balancer_name: self.load_balancer_name,
                container_name: self.container_name,
                container_port: self.container_port,
            }
        }
    }
}
impl LoadBalancer {
    /// Creates a new builder-style object to manufacture [`LoadBalancer`](crate::model::LoadBalancer)
    pub fn builder() -> crate::model::load_balancer::Builder {
        crate::model::load_balancer::Builder::default()
    }
}

/// <p>An object representing the network configuration for a task or service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkConfiguration {
    /// <p>The VPC subnets and security groups associated with a task.</p>
    /// <note>
    /// <p>All specified subnets and security groups must be from the same VPC.</p>
    /// </note>
    pub awsvpc_configuration: std::option::Option<crate::model::AwsVpcConfiguration>,
}
impl std::fmt::Debug for NetworkConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkConfiguration");
        formatter.field("awsvpc_configuration", &self.awsvpc_configuration);
        formatter.finish()
    }
}
/// See [`NetworkConfiguration`](crate::model::NetworkConfiguration)
pub mod network_configuration {
    /// A builder for [`NetworkConfiguration`](crate::model::NetworkConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) awsvpc_configuration: std::option::Option<crate::model::AwsVpcConfiguration>,
    }
    impl Builder {
        /// <p>The VPC subnets and security groups associated with a task.</p>
        /// <note>
        /// <p>All specified subnets and security groups must be from the same VPC.</p>
        /// </note>
        pub fn awsvpc_configuration(mut self, input: crate::model::AwsVpcConfiguration) -> Self {
            self.awsvpc_configuration = Some(input);
            self
        }
        /// <p>The VPC subnets and security groups associated with a task.</p>
        /// <note>
        /// <p>All specified subnets and security groups must be from the same VPC.</p>
        /// </note>
        pub fn set_awsvpc_configuration(
            mut self,
            input: std::option::Option<crate::model::AwsVpcConfiguration>,
        ) -> Self {
            self.awsvpc_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkConfiguration`](crate::model::NetworkConfiguration)
        pub fn build(self) -> crate::model::NetworkConfiguration {
            crate::model::NetworkConfiguration {
                awsvpc_configuration: self.awsvpc_configuration,
            }
        }
    }
}
impl NetworkConfiguration {
    /// Creates a new builder-style object to manufacture [`NetworkConfiguration`](crate::model::NetworkConfiguration)
    pub fn builder() -> crate::model::network_configuration::Builder {
        crate::model::network_configuration::Builder::default()
    }
}

/// <p>An object representing the networking details for a task or service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsVpcConfiguration {
    /// <p>The IDs of the subnets associated with the task or service. There is a limit of 16
    /// subnets that can be specified per <code>AwsVpcConfiguration</code>.</p>
    ///
    /// <note>
    /// <p>All specified subnets must be from the same VPC.</p>
    /// </note>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IDs of the security groups associated with the task or service. If you do not
    /// specify a security group, the default security group for the VPC is used. There is a
    /// limit of 5 security groups that can be specified per
    /// <code>AwsVpcConfiguration</code>.</p>
    ///
    /// <note>
    /// <p>All specified security groups must be from the same VPC.</p>
    /// </note>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Whether the task's elastic network interface receives a public IP address. The default
    /// value is <code>DISABLED</code>.</p>
    pub assign_public_ip: std::option::Option<crate::model::AssignPublicIp>,
}
impl std::fmt::Debug for AwsVpcConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsVpcConfiguration");
        formatter.field("subnets", &self.subnets);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("assign_public_ip", &self.assign_public_ip);
        formatter.finish()
    }
}
/// See [`AwsVpcConfiguration`](crate::model::AwsVpcConfiguration)
pub mod aws_vpc_configuration {
    /// A builder for [`AwsVpcConfiguration`](crate::model::AwsVpcConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) assign_public_ip: std::option::Option<crate::model::AssignPublicIp>,
    }
    impl Builder {
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The IDs of the subnets associated with the task or service. There is a limit of 16
        /// subnets that can be specified per <code>AwsVpcConfiguration</code>.</p>
        ///
        /// <note>
        /// <p>All specified subnets must be from the same VPC.</p>
        /// </note>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>The IDs of the subnets associated with the task or service. There is a limit of 16
        /// subnets that can be specified per <code>AwsVpcConfiguration</code>.</p>
        ///
        /// <note>
        /// <p>All specified subnets must be from the same VPC.</p>
        /// </note>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The IDs of the security groups associated with the task or service. If you do not
        /// specify a security group, the default security group for the VPC is used. There is a
        /// limit of 5 security groups that can be specified per
        /// <code>AwsVpcConfiguration</code>.</p>
        ///
        /// <note>
        /// <p>All specified security groups must be from the same VPC.</p>
        /// </note>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The IDs of the security groups associated with the task or service. If you do not
        /// specify a security group, the default security group for the VPC is used. There is a
        /// limit of 5 security groups that can be specified per
        /// <code>AwsVpcConfiguration</code>.</p>
        ///
        /// <note>
        /// <p>All specified security groups must be from the same VPC.</p>
        /// </note>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>Whether the task's elastic network interface receives a public IP address. The default
        /// value is <code>DISABLED</code>.</p>
        pub fn assign_public_ip(mut self, input: crate::model::AssignPublicIp) -> Self {
            self.assign_public_ip = Some(input);
            self
        }
        /// <p>Whether the task's elastic network interface receives a public IP address. The default
        /// value is <code>DISABLED</code>.</p>
        pub fn set_assign_public_ip(
            mut self,
            input: std::option::Option<crate::model::AssignPublicIp>,
        ) -> Self {
            self.assign_public_ip = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsVpcConfiguration`](crate::model::AwsVpcConfiguration)
        pub fn build(self) -> crate::model::AwsVpcConfiguration {
            crate::model::AwsVpcConfiguration {
                subnets: self.subnets,
                security_groups: self.security_groups,
                assign_public_ip: self.assign_public_ip,
            }
        }
    }
}
impl AwsVpcConfiguration {
    /// Creates a new builder-style object to manufacture [`AwsVpcConfiguration`](crate::model::AwsVpcConfiguration)
    pub fn builder() -> crate::model::aws_vpc_configuration::Builder {
        crate::model::aws_vpc_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssignPublicIp {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssignPublicIp {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => AssignPublicIp::Disabled,
            "ENABLED" => AssignPublicIp::Enabled,
            other => AssignPublicIp::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssignPublicIp {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssignPublicIp::from(s))
    }
}
impl AssignPublicIp {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssignPublicIp::Disabled => "DISABLED",
            AssignPublicIp::Enabled => "ENABLED",
            AssignPublicIp::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for AssignPublicIp {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details of a capacity provider strategy. A capacity provider strategy can be set
/// when using the <a>RunTask</a> or <a>CreateCluster</a> APIs or as
/// the default capacity provider strategy for a cluster with the <a>CreateCluster</a> API.</p>
/// <p>Only capacity providers that are already associated with a cluster and have an
/// <code>ACTIVE</code> or <code>UPDATING</code> status can be used in a capacity
/// provider strategy. The <a>PutClusterCapacityProviders</a> API is used to
/// associate a capacity provider with a cluster.</p>
/// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity
/// provider must already be created. New Auto Scaling group capacity providers can be
/// created with the <a>CreateCapacityProvider</a> API operation.</p>
/// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
/// <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are
/// available to all accounts and only need to be associated with a cluster to be used in a
/// capacity provider strategy.</p>
/// <p>A capacity provider strategy may contain a maximum of 6 capacity providers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CapacityProviderStrategyItem {
    /// <p>The short name of the capacity provider.</p>
    pub capacity_provider: std::option::Option<std::string::String>,
    /// <p>The <i>weight</i> value designates the relative percentage of the total
    /// number of tasks launched that should use the specified capacity provider. The
    /// <code>weight</code> value is taken into consideration after the <code>base</code>
    /// value, if defined, is satisfied.</p>
    /// <p>If no <code>weight</code> value is specified, the default value of <code>0</code> is
    /// used. When multiple capacity providers are specified within a capacity provider
    /// strategy, at least one of the capacity providers must have a weight value greater than
    /// zero and any capacity providers with a weight of <code>0</code> will not be used to
    /// place tasks. If you specify multiple capacity providers in a strategy that all have a
    /// weight of <code>0</code>, any <code>RunTask</code> or <code>CreateService</code> actions
    /// using the capacity provider strategy will fail.</p>
    /// <p>An example scenario for using weights is defining a strategy that contains two
    /// capacity providers and both have a weight of <code>1</code>, then when the
    /// <code>base</code> is satisfied, the tasks will be split evenly across the two
    /// capacity providers. Using that same logic, if you specify a weight of <code>1</code> for
    /// <i>capacityProviderA</i> and a weight of <code>4</code> for
    /// <i>capacityProviderB</i>, then for every one task that is run using
    /// <i>capacityProviderA</i>, four tasks would use
    /// <i>capacityProviderB</i>.</p>
    pub weight: i32,
    /// <p>The <i>base</i> value designates how many tasks, at a minimum, to run on
    /// the specified capacity provider. Only one capacity provider in a capacity provider
    /// strategy can have a <i>base</i> defined. If no value is specified, the
    /// default value of <code>0</code> is used.</p>
    pub base: i32,
}
impl std::fmt::Debug for CapacityProviderStrategyItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CapacityProviderStrategyItem");
        formatter.field("capacity_provider", &self.capacity_provider);
        formatter.field("weight", &self.weight);
        formatter.field("base", &self.base);
        formatter.finish()
    }
}
/// See [`CapacityProviderStrategyItem`](crate::model::CapacityProviderStrategyItem)
pub mod capacity_provider_strategy_item {
    /// A builder for [`CapacityProviderStrategyItem`](crate::model::CapacityProviderStrategyItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity_provider: std::option::Option<std::string::String>,
        pub(crate) weight: std::option::Option<i32>,
        pub(crate) base: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The short name of the capacity provider.</p>
        pub fn capacity_provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.capacity_provider = Some(input.into());
            self
        }
        /// <p>The short name of the capacity provider.</p>
        pub fn set_capacity_provider(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capacity_provider = input;
            self
        }
        /// <p>The <i>weight</i> value designates the relative percentage of the total
        /// number of tasks launched that should use the specified capacity provider. The
        /// <code>weight</code> value is taken into consideration after the <code>base</code>
        /// value, if defined, is satisfied.</p>
        /// <p>If no <code>weight</code> value is specified, the default value of <code>0</code> is
        /// used. When multiple capacity providers are specified within a capacity provider
        /// strategy, at least one of the capacity providers must have a weight value greater than
        /// zero and any capacity providers with a weight of <code>0</code> will not be used to
        /// place tasks. If you specify multiple capacity providers in a strategy that all have a
        /// weight of <code>0</code>, any <code>RunTask</code> or <code>CreateService</code> actions
        /// using the capacity provider strategy will fail.</p>
        /// <p>An example scenario for using weights is defining a strategy that contains two
        /// capacity providers and both have a weight of <code>1</code>, then when the
        /// <code>base</code> is satisfied, the tasks will be split evenly across the two
        /// capacity providers. Using that same logic, if you specify a weight of <code>1</code> for
        /// <i>capacityProviderA</i> and a weight of <code>4</code> for
        /// <i>capacityProviderB</i>, then for every one task that is run using
        /// <i>capacityProviderA</i>, four tasks would use
        /// <i>capacityProviderB</i>.</p>
        pub fn weight(mut self, input: i32) -> Self {
            self.weight = Some(input);
            self
        }
        /// <p>The <i>weight</i> value designates the relative percentage of the total
        /// number of tasks launched that should use the specified capacity provider. The
        /// <code>weight</code> value is taken into consideration after the <code>base</code>
        /// value, if defined, is satisfied.</p>
        /// <p>If no <code>weight</code> value is specified, the default value of <code>0</code> is
        /// used. When multiple capacity providers are specified within a capacity provider
        /// strategy, at least one of the capacity providers must have a weight value greater than
        /// zero and any capacity providers with a weight of <code>0</code> will not be used to
        /// place tasks. If you specify multiple capacity providers in a strategy that all have a
        /// weight of <code>0</code>, any <code>RunTask</code> or <code>CreateService</code> actions
        /// using the capacity provider strategy will fail.</p>
        /// <p>An example scenario for using weights is defining a strategy that contains two
        /// capacity providers and both have a weight of <code>1</code>, then when the
        /// <code>base</code> is satisfied, the tasks will be split evenly across the two
        /// capacity providers. Using that same logic, if you specify a weight of <code>1</code> for
        /// <i>capacityProviderA</i> and a weight of <code>4</code> for
        /// <i>capacityProviderB</i>, then for every one task that is run using
        /// <i>capacityProviderA</i>, four tasks would use
        /// <i>capacityProviderB</i>.</p>
        pub fn set_weight(mut self, input: std::option::Option<i32>) -> Self {
            self.weight = input;
            self
        }
        /// <p>The <i>base</i> value designates how many tasks, at a minimum, to run on
        /// the specified capacity provider. Only one capacity provider in a capacity provider
        /// strategy can have a <i>base</i> defined. If no value is specified, the
        /// default value of <code>0</code> is used.</p>
        pub fn base(mut self, input: i32) -> Self {
            self.base = Some(input);
            self
        }
        /// <p>The <i>base</i> value designates how many tasks, at a minimum, to run on
        /// the specified capacity provider. Only one capacity provider in a capacity provider
        /// strategy can have a <i>base</i> defined. If no value is specified, the
        /// default value of <code>0</code> is used.</p>
        pub fn set_base(mut self, input: std::option::Option<i32>) -> Self {
            self.base = input;
            self
        }
        /// Consumes the builder and constructs a [`CapacityProviderStrategyItem`](crate::model::CapacityProviderStrategyItem)
        pub fn build(self) -> crate::model::CapacityProviderStrategyItem {
            crate::model::CapacityProviderStrategyItem {
                capacity_provider: self.capacity_provider,
                weight: self.weight.unwrap_or_default(),
                base: self.base.unwrap_or_default(),
            }
        }
    }
}
impl CapacityProviderStrategyItem {
    /// Creates a new builder-style object to manufacture [`CapacityProviderStrategyItem`](crate::model::CapacityProviderStrategyItem)
    pub fn builder() -> crate::model::capacity_provider_strategy_item::Builder {
        crate::model::capacity_provider_strategy_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LaunchType {
    #[allow(missing_docs)] // documentation missing in model
    Ec2,
    #[allow(missing_docs)] // documentation missing in model
    External,
    #[allow(missing_docs)] // documentation missing in model
    Fargate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LaunchType {
    fn from(s: &str) -> Self {
        match s {
            "EC2" => LaunchType::Ec2,
            "EXTERNAL" => LaunchType::External,
            "FARGATE" => LaunchType::Fargate,
            other => LaunchType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LaunchType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LaunchType::from(s))
    }
}
impl LaunchType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LaunchType::Ec2 => "EC2",
            LaunchType::External => "EXTERNAL",
            LaunchType::Fargate => "FARGATE",
            LaunchType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EC2", "EXTERNAL", "FARGATE"]
    }
}
impl AsRef<str> for LaunchType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details on a service within a cluster</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Service {
    /// <p>The ARN that identifies the service. The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the service, the Amazon Web Services account ID of the service owner, the <code>service</code> namespace, and then the service name. For example, <code>arn:aws:ecs:region:012345678910:service/my-service</code>.</p>
    pub service_arn: std::option::Option<std::string::String>,
    /// <p>The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. Service names must be unique within
    /// a cluster, but you can have similarly named services in multiple clusters within a
    /// Region or across multiple Regions.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the cluster that hosts the service.</p>
    pub cluster_arn: std::option::Option<std::string::String>,
    /// <p>A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the
    /// container name (as it appears in a container definition), and the container port to
    /// access from the load balancer.</p>
    pub load_balancers: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
    /// <p>The details of the service discovery registries to assign to this service. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
    /// Discovery</a>.</p>
    pub service_registries: std::option::Option<std::vec::Vec<crate::model::ServiceRegistry>>,
    /// <p>The status of the service. The valid values are <code>ACTIVE</code>,
    /// <code>DRAINING</code>, or <code>INACTIVE</code>.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The desired number of instantiations of the task definition to keep running on the
    /// service. This value is specified when the service is created with <a>CreateService</a>, and it can be modified with <a>UpdateService</a>.</p>
    pub desired_count: i32,
    /// <p>The number of tasks in the cluster that are in the <code>RUNNING</code> state.</p>
    pub running_count: i32,
    /// <p>The number of tasks in the cluster that are in the <code>PENDING</code> state.</p>
    pub pending_count: i32,
    /// <p>The launch type the service is using. When using the DescribeServices API, this field
    /// is omitted if the service was created using a capacity provider strategy.</p>
    pub launch_type: std::option::Option<crate::model::LaunchType>,
    /// <p>The capacity provider strategy the service is using. When using the DescribeServices
    /// API, this field is omitted if the service was created using a launch type.</p>
    pub capacity_provider_strategy:
        std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
    /// <p>The platform version on which to run your service. A platform version is only
    /// specified for tasks hosted on Fargate. If one is not specified, the
    /// <code>LATEST</code> platform version is used by default. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
    /// Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub platform_version: std::option::Option<std::string::String>,
    /// <p>The operating system  that your tasks in the service are running on. A platform family is specified only for tasks using the Fargate launch type. </p>
    /// <p> All tasks that run as part of this service must use the same <code>platformFamily</code> value as the service, for example, <code>LINUX</code>.</p>
    pub platform_family: std::option::Option<std::string::String>,
    /// <p>The task definition to use for tasks in the service. This value is specified when the
    /// service is created with <a>CreateService</a>, and it can be modified with
    /// <a>UpdateService</a>.</p>
    pub task_definition: std::option::Option<std::string::String>,
    /// <p>Optional deployment parameters that control how many tasks run during the deployment
    /// and the ordering of stopping and starting tasks.</p>
    pub deployment_configuration: std::option::Option<crate::model::DeploymentConfiguration>,
    /// <p>Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code>
    /// deployment. An Amazon ECS task set includes details such as the desired number of tasks, how
    /// many tasks are running, and whether the task set serves production traffic.</p>
    pub task_sets: std::option::Option<std::vec::Vec<crate::model::TaskSet>>,
    /// <p>The current state of deployments for the service.</p>
    pub deployments: std::option::Option<std::vec::Vec<crate::model::Deployment>>,
    /// <p>The ARN of the IAM role associated with the service that allows the Amazon ECS container
    /// agent to register container instances with an Elastic Load Balancing load balancer.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The event stream for your service. A maximum of 100 of the latest events are
    /// displayed.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::ServiceEvent>>,
    /// <p>The Unix timestamp for when the service was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The placement constraints for the tasks in the service.</p>
    pub placement_constraints:
        std::option::Option<std::vec::Vec<crate::model::PlacementConstraint>>,
    /// <p>The placement strategy that determines how tasks for the service are placed.</p>
    pub placement_strategy: std::option::Option<std::vec::Vec<crate::model::PlacementStrategy>>,
    /// <p>The VPC subnet and security group configuration for tasks that receive their own
    /// elastic network interface by using the <code>awsvpc</code> networking mode.</p>
    pub network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
    /// <p>The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy
    /// Elastic Load Balancing target health checks after a task has first started.</p>
    pub health_check_grace_period_seconds: std::option::Option<i32>,
    /// <p>The scheduling strategy to use for the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
    /// <p>There are two service scheduler strategies available:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>REPLICA</code>-The replica scheduling strategy places and
    /// maintains the desired number of tasks across your cluster. By default, the
    /// service scheduler spreads tasks across Availability Zones. You can use task
    /// placement strategies and constraints to customize task placement
    /// decisions.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one
    /// task on each active container instance that meets all of the task placement
    /// constraints that you specify in your cluster. The service scheduler also
    /// evaluates the task placement constraints for running tasks and will stop tasks
    /// that do not meet the placement constraints.</p>
    /// <note>
    /// <p>Fargate tasks do not support the <code>DAEMON</code>
    /// scheduling strategy.</p>
    /// </note>
    /// </li>
    /// </ul>
    pub scheduling_strategy: std::option::Option<crate::model::SchedulingStrategy>,
    /// <p>The deployment controller type the service is using. When using the DescribeServices
    /// API, this field is omitted if the service is using the <code>ECS</code> deployment
    /// controller type.</p>
    pub deployment_controller: std::option::Option<crate::model::DeploymentController>,
    /// <p>The metadata that you apply to the service to help you categorize and organize them.
    /// Each tag consists of a key and an optional value, both of which you define.</p>
    /// <p>The following basic restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of tags per resource - 50</p>
    /// </li>
    /// <li>
    /// <p>For each resource, each tag key must be unique, and each tag key can have only
    /// one value.</p>
    /// </li>
    /// <li>
    /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>If your tagging schema is used across multiple services and resources,
    /// remember that other services may have restrictions on allowed characters.
    /// Generally allowed characters are: letters, numbers, and spaces representable in
    /// UTF-8, and the following characters: + - = . _ : / @.</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
    /// combination of such as a prefix for either keys or values as it is reserved for
    /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
    /// this prefix do not count against your tags per resource limit.</p>
    /// </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The principal that created the service.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>Specifies whether to enable Amazon ECS managed tags for the tasks in the service. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS
    /// Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub enable_ecs_managed_tags: bool,
    /// <p>Specifies whether to propagate the tags from the task definition or the service to the
    /// task. If no value is specified, the tags are not propagated.</p>
    pub propagate_tags: std::option::Option<crate::model::PropagateTags>,
    /// <p>Whether or not the execute command functionality is enabled for the service. If
    /// <code>true</code>, the execute command functionality is enabled for all containers
    /// in tasks as part of the service.</p>
    pub enable_execute_command: bool,
}
impl std::fmt::Debug for Service {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Service");
        formatter.field("service_arn", &self.service_arn);
        formatter.field("service_name", &self.service_name);
        formatter.field("cluster_arn", &self.cluster_arn);
        formatter.field("load_balancers", &self.load_balancers);
        formatter.field("service_registries", &self.service_registries);
        formatter.field("status", &self.status);
        formatter.field("desired_count", &self.desired_count);
        formatter.field("running_count", &self.running_count);
        formatter.field("pending_count", &self.pending_count);
        formatter.field("launch_type", &self.launch_type);
        formatter.field(
            "capacity_provider_strategy",
            &self.capacity_provider_strategy,
        );
        formatter.field("platform_version", &self.platform_version);
        formatter.field("platform_family", &self.platform_family);
        formatter.field("task_definition", &self.task_definition);
        formatter.field("deployment_configuration", &self.deployment_configuration);
        formatter.field("task_sets", &self.task_sets);
        formatter.field("deployments", &self.deployments);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("events", &self.events);
        formatter.field("created_at", &self.created_at);
        formatter.field("placement_constraints", &self.placement_constraints);
        formatter.field("placement_strategy", &self.placement_strategy);
        formatter.field("network_configuration", &self.network_configuration);
        formatter.field(
            "health_check_grace_period_seconds",
            &self.health_check_grace_period_seconds,
        );
        formatter.field("scheduling_strategy", &self.scheduling_strategy);
        formatter.field("deployment_controller", &self.deployment_controller);
        formatter.field("tags", &self.tags);
        formatter.field("created_by", &self.created_by);
        formatter.field("enable_ecs_managed_tags", &self.enable_ecs_managed_tags);
        formatter.field("propagate_tags", &self.propagate_tags);
        formatter.field("enable_execute_command", &self.enable_execute_command);
        formatter.finish()
    }
}
/// See [`Service`](crate::model::Service)
pub mod service {
    /// A builder for [`Service`](crate::model::Service)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_arn: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) cluster_arn: std::option::Option<std::string::String>,
        pub(crate) load_balancers: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
        pub(crate) service_registries:
            std::option::Option<std::vec::Vec<crate::model::ServiceRegistry>>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) desired_count: std::option::Option<i32>,
        pub(crate) running_count: std::option::Option<i32>,
        pub(crate) pending_count: std::option::Option<i32>,
        pub(crate) launch_type: std::option::Option<crate::model::LaunchType>,
        pub(crate) capacity_provider_strategy:
            std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        pub(crate) platform_version: std::option::Option<std::string::String>,
        pub(crate) platform_family: std::option::Option<std::string::String>,
        pub(crate) task_definition: std::option::Option<std::string::String>,
        pub(crate) deployment_configuration:
            std::option::Option<crate::model::DeploymentConfiguration>,
        pub(crate) task_sets: std::option::Option<std::vec::Vec<crate::model::TaskSet>>,
        pub(crate) deployments: std::option::Option<std::vec::Vec<crate::model::Deployment>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::ServiceEvent>>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) placement_constraints:
            std::option::Option<std::vec::Vec<crate::model::PlacementConstraint>>,
        pub(crate) placement_strategy:
            std::option::Option<std::vec::Vec<crate::model::PlacementStrategy>>,
        pub(crate) network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
        pub(crate) health_check_grace_period_seconds: std::option::Option<i32>,
        pub(crate) scheduling_strategy: std::option::Option<crate::model::SchedulingStrategy>,
        pub(crate) deployment_controller: std::option::Option<crate::model::DeploymentController>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) enable_ecs_managed_tags: std::option::Option<bool>,
        pub(crate) propagate_tags: std::option::Option<crate::model::PropagateTags>,
        pub(crate) enable_execute_command: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ARN that identifies the service. The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the service, the Amazon Web Services account ID of the service owner, the <code>service</code> namespace, and then the service name. For example, <code>arn:aws:ecs:region:012345678910:service/my-service</code>.</p>
        pub fn service_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_arn = Some(input.into());
            self
        }
        /// <p>The ARN that identifies the service. The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the service, the Amazon Web Services account ID of the service owner, the <code>service</code> namespace, and then the service name. For example, <code>arn:aws:ecs:region:012345678910:service/my-service</code>.</p>
        pub fn set_service_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_arn = input;
            self
        }
        /// <p>The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. Service names must be unique within
        /// a cluster, but you can have similarly named services in multiple clusters within a
        /// Region or across multiple Regions.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. Service names must be unique within
        /// a cluster, but you can have similarly named services in multiple clusters within a
        /// Region or across multiple Regions.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster that hosts the service.</p>
        pub fn cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the cluster that hosts the service.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_arn = input;
            self
        }
        /// Appends an item to `load_balancers`.
        ///
        /// To override the contents of this collection use [`set_load_balancers`](Self::set_load_balancers).
        ///
        /// <p>A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the
        /// container name (as it appears in a container definition), and the container port to
        /// access from the load balancer.</p>
        pub fn load_balancers(mut self, input: impl Into<crate::model::LoadBalancer>) -> Self {
            let mut v = self.load_balancers.unwrap_or_default();
            v.push(input.into());
            self.load_balancers = Some(v);
            self
        }
        /// <p>A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the
        /// container name (as it appears in a container definition), and the container port to
        /// access from the load balancer.</p>
        pub fn set_load_balancers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
        ) -> Self {
            self.load_balancers = input;
            self
        }
        /// Appends an item to `service_registries`.
        ///
        /// To override the contents of this collection use [`set_service_registries`](Self::set_service_registries).
        ///
        /// <p>The details of the service discovery registries to assign to this service. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
        /// Discovery</a>.</p>
        pub fn service_registries(
            mut self,
            input: impl Into<crate::model::ServiceRegistry>,
        ) -> Self {
            let mut v = self.service_registries.unwrap_or_default();
            v.push(input.into());
            self.service_registries = Some(v);
            self
        }
        /// <p>The details of the service discovery registries to assign to this service. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
        /// Discovery</a>.</p>
        pub fn set_service_registries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceRegistry>>,
        ) -> Self {
            self.service_registries = input;
            self
        }
        /// <p>The status of the service. The valid values are <code>ACTIVE</code>,
        /// <code>DRAINING</code>, or <code>INACTIVE</code>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the service. The valid values are <code>ACTIVE</code>,
        /// <code>DRAINING</code>, or <code>INACTIVE</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The desired number of instantiations of the task definition to keep running on the
        /// service. This value is specified when the service is created with <a>CreateService</a>, and it can be modified with <a>UpdateService</a>.</p>
        pub fn desired_count(mut self, input: i32) -> Self {
            self.desired_count = Some(input);
            self
        }
        /// <p>The desired number of instantiations of the task definition to keep running on the
        /// service. This value is specified when the service is created with <a>CreateService</a>, and it can be modified with <a>UpdateService</a>.</p>
        pub fn set_desired_count(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_count = input;
            self
        }
        /// <p>The number of tasks in the cluster that are in the <code>RUNNING</code> state.</p>
        pub fn running_count(mut self, input: i32) -> Self {
            self.running_count = Some(input);
            self
        }
        /// <p>The number of tasks in the cluster that are in the <code>RUNNING</code> state.</p>
        pub fn set_running_count(mut self, input: std::option::Option<i32>) -> Self {
            self.running_count = input;
            self
        }
        /// <p>The number of tasks in the cluster that are in the <code>PENDING</code> state.</p>
        pub fn pending_count(mut self, input: i32) -> Self {
            self.pending_count = Some(input);
            self
        }
        /// <p>The number of tasks in the cluster that are in the <code>PENDING</code> state.</p>
        pub fn set_pending_count(mut self, input: std::option::Option<i32>) -> Self {
            self.pending_count = input;
            self
        }
        /// <p>The launch type the service is using. When using the DescribeServices API, this field
        /// is omitted if the service was created using a capacity provider strategy.</p>
        pub fn launch_type(mut self, input: crate::model::LaunchType) -> Self {
            self.launch_type = Some(input);
            self
        }
        /// <p>The launch type the service is using. When using the DescribeServices API, this field
        /// is omitted if the service was created using a capacity provider strategy.</p>
        pub fn set_launch_type(
            mut self,
            input: std::option::Option<crate::model::LaunchType>,
        ) -> Self {
            self.launch_type = input;
            self
        }
        /// Appends an item to `capacity_provider_strategy`.
        ///
        /// To override the contents of this collection use [`set_capacity_provider_strategy`](Self::set_capacity_provider_strategy).
        ///
        /// <p>The capacity provider strategy the service is using. When using the DescribeServices
        /// API, this field is omitted if the service was created using a launch type.</p>
        pub fn capacity_provider_strategy(
            mut self,
            input: impl Into<crate::model::CapacityProviderStrategyItem>,
        ) -> Self {
            let mut v = self.capacity_provider_strategy.unwrap_or_default();
            v.push(input.into());
            self.capacity_provider_strategy = Some(v);
            self
        }
        /// <p>The capacity provider strategy the service is using. When using the DescribeServices
        /// API, this field is omitted if the service was created using a launch type.</p>
        pub fn set_capacity_provider_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        ) -> Self {
            self.capacity_provider_strategy = input;
            self
        }
        /// <p>The platform version on which to run your service. A platform version is only
        /// specified for tasks hosted on Fargate. If one is not specified, the
        /// <code>LATEST</code> platform version is used by default. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
        /// Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_version = Some(input.into());
            self
        }
        /// <p>The platform version on which to run your service. A platform version is only
        /// specified for tasks hosted on Fargate. If one is not specified, the
        /// <code>LATEST</code> platform version is used by default. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
        /// Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_version = input;
            self
        }
        /// <p>The operating system  that your tasks in the service are running on. A platform family is specified only for tasks using the Fargate launch type. </p>
        /// <p> All tasks that run as part of this service must use the same <code>platformFamily</code> value as the service, for example, <code>LINUX</code>.</p>
        pub fn platform_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_family = Some(input.into());
            self
        }
        /// <p>The operating system  that your tasks in the service are running on. A platform family is specified only for tasks using the Fargate launch type. </p>
        /// <p> All tasks that run as part of this service must use the same <code>platformFamily</code> value as the service, for example, <code>LINUX</code>.</p>
        pub fn set_platform_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_family = input;
            self
        }
        /// <p>The task definition to use for tasks in the service. This value is specified when the
        /// service is created with <a>CreateService</a>, and it can be modified with
        /// <a>UpdateService</a>.</p>
        pub fn task_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_definition = Some(input.into());
            self
        }
        /// <p>The task definition to use for tasks in the service. This value is specified when the
        /// service is created with <a>CreateService</a>, and it can be modified with
        /// <a>UpdateService</a>.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_definition = input;
            self
        }
        /// <p>Optional deployment parameters that control how many tasks run during the deployment
        /// and the ordering of stopping and starting tasks.</p>
        pub fn deployment_configuration(
            mut self,
            input: crate::model::DeploymentConfiguration,
        ) -> Self {
            self.deployment_configuration = Some(input);
            self
        }
        /// <p>Optional deployment parameters that control how many tasks run during the deployment
        /// and the ordering of stopping and starting tasks.</p>
        pub fn set_deployment_configuration(
            mut self,
            input: std::option::Option<crate::model::DeploymentConfiguration>,
        ) -> Self {
            self.deployment_configuration = input;
            self
        }
        /// Appends an item to `task_sets`.
        ///
        /// To override the contents of this collection use [`set_task_sets`](Self::set_task_sets).
        ///
        /// <p>Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code>
        /// deployment. An Amazon ECS task set includes details such as the desired number of tasks, how
        /// many tasks are running, and whether the task set serves production traffic.</p>
        pub fn task_sets(mut self, input: impl Into<crate::model::TaskSet>) -> Self {
            let mut v = self.task_sets.unwrap_or_default();
            v.push(input.into());
            self.task_sets = Some(v);
            self
        }
        /// <p>Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code>
        /// deployment. An Amazon ECS task set includes details such as the desired number of tasks, how
        /// many tasks are running, and whether the task set serves production traffic.</p>
        pub fn set_task_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TaskSet>>,
        ) -> Self {
            self.task_sets = input;
            self
        }
        /// Appends an item to `deployments`.
        ///
        /// To override the contents of this collection use [`set_deployments`](Self::set_deployments).
        ///
        /// <p>The current state of deployments for the service.</p>
        pub fn deployments(mut self, input: impl Into<crate::model::Deployment>) -> Self {
            let mut v = self.deployments.unwrap_or_default();
            v.push(input.into());
            self.deployments = Some(v);
            self
        }
        /// <p>The current state of deployments for the service.</p>
        pub fn set_deployments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Deployment>>,
        ) -> Self {
            self.deployments = input;
            self
        }
        /// <p>The ARN of the IAM role associated with the service that allows the Amazon ECS container
        /// agent to register container instances with an Elastic Load Balancing load balancer.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role associated with the service that allows the Amazon ECS container
        /// agent to register container instances with an Elastic Load Balancing load balancer.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>The event stream for your service. A maximum of 100 of the latest events are
        /// displayed.</p>
        pub fn events(mut self, input: impl Into<crate::model::ServiceEvent>) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input.into());
            self.events = Some(v);
            self
        }
        /// <p>The event stream for your service. A maximum of 100 of the latest events are
        /// displayed.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceEvent>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// <p>The Unix timestamp for when the service was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the service was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Appends an item to `placement_constraints`.
        ///
        /// To override the contents of this collection use [`set_placement_constraints`](Self::set_placement_constraints).
        ///
        /// <p>The placement constraints for the tasks in the service.</p>
        pub fn placement_constraints(
            mut self,
            input: impl Into<crate::model::PlacementConstraint>,
        ) -> Self {
            let mut v = self.placement_constraints.unwrap_or_default();
            v.push(input.into());
            self.placement_constraints = Some(v);
            self
        }
        /// <p>The placement constraints for the tasks in the service.</p>
        pub fn set_placement_constraints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementConstraint>>,
        ) -> Self {
            self.placement_constraints = input;
            self
        }
        /// Appends an item to `placement_strategy`.
        ///
        /// To override the contents of this collection use [`set_placement_strategy`](Self::set_placement_strategy).
        ///
        /// <p>The placement strategy that determines how tasks for the service are placed.</p>
        pub fn placement_strategy(
            mut self,
            input: impl Into<crate::model::PlacementStrategy>,
        ) -> Self {
            let mut v = self.placement_strategy.unwrap_or_default();
            v.push(input.into());
            self.placement_strategy = Some(v);
            self
        }
        /// <p>The placement strategy that determines how tasks for the service are placed.</p>
        pub fn set_placement_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementStrategy>>,
        ) -> Self {
            self.placement_strategy = input;
            self
        }
        /// <p>The VPC subnet and security group configuration for tasks that receive their own
        /// elastic network interface by using the <code>awsvpc</code> networking mode.</p>
        pub fn network_configuration(mut self, input: crate::model::NetworkConfiguration) -> Self {
            self.network_configuration = Some(input);
            self
        }
        /// <p>The VPC subnet and security group configuration for tasks that receive their own
        /// elastic network interface by using the <code>awsvpc</code> networking mode.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkConfiguration>,
        ) -> Self {
            self.network_configuration = input;
            self
        }
        /// <p>The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy
        /// Elastic Load Balancing target health checks after a task has first started.</p>
        pub fn health_check_grace_period_seconds(mut self, input: i32) -> Self {
            self.health_check_grace_period_seconds = Some(input);
            self
        }
        /// <p>The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy
        /// Elastic Load Balancing target health checks after a task has first started.</p>
        pub fn set_health_check_grace_period_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.health_check_grace_period_seconds = input;
            self
        }
        /// <p>The scheduling strategy to use for the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
        /// <p>There are two service scheduler strategies available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>REPLICA</code>-The replica scheduling strategy places and
        /// maintains the desired number of tasks across your cluster. By default, the
        /// service scheduler spreads tasks across Availability Zones. You can use task
        /// placement strategies and constraints to customize task placement
        /// decisions.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one
        /// task on each active container instance that meets all of the task placement
        /// constraints that you specify in your cluster. The service scheduler also
        /// evaluates the task placement constraints for running tasks and will stop tasks
        /// that do not meet the placement constraints.</p>
        /// <note>
        /// <p>Fargate tasks do not support the <code>DAEMON</code>
        /// scheduling strategy.</p>
        /// </note>
        /// </li>
        /// </ul>
        pub fn scheduling_strategy(mut self, input: crate::model::SchedulingStrategy) -> Self {
            self.scheduling_strategy = Some(input);
            self
        }
        /// <p>The scheduling strategy to use for the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
        /// <p>There are two service scheduler strategies available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>REPLICA</code>-The replica scheduling strategy places and
        /// maintains the desired number of tasks across your cluster. By default, the
        /// service scheduler spreads tasks across Availability Zones. You can use task
        /// placement strategies and constraints to customize task placement
        /// decisions.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one
        /// task on each active container instance that meets all of the task placement
        /// constraints that you specify in your cluster. The service scheduler also
        /// evaluates the task placement constraints for running tasks and will stop tasks
        /// that do not meet the placement constraints.</p>
        /// <note>
        /// <p>Fargate tasks do not support the <code>DAEMON</code>
        /// scheduling strategy.</p>
        /// </note>
        /// </li>
        /// </ul>
        pub fn set_scheduling_strategy(
            mut self,
            input: std::option::Option<crate::model::SchedulingStrategy>,
        ) -> Self {
            self.scheduling_strategy = input;
            self
        }
        /// <p>The deployment controller type the service is using. When using the DescribeServices
        /// API, this field is omitted if the service is using the <code>ECS</code> deployment
        /// controller type.</p>
        pub fn deployment_controller(mut self, input: crate::model::DeploymentController) -> Self {
            self.deployment_controller = Some(input);
            self
        }
        /// <p>The deployment controller type the service is using. When using the DescribeServices
        /// API, this field is omitted if the service is using the <code>ECS</code> deployment
        /// controller type.</p>
        pub fn set_deployment_controller(
            mut self,
            input: std::option::Option<crate::model::DeploymentController>,
        ) -> Self {
            self.deployment_controller = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the service to help you categorize and organize them.
        /// Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The metadata that you apply to the service to help you categorize and organize them.
        /// Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The principal that created the service.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The principal that created the service.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>Specifies whether to enable Amazon ECS managed tags for the tasks in the service. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS
        /// Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn enable_ecs_managed_tags(mut self, input: bool) -> Self {
            self.enable_ecs_managed_tags = Some(input);
            self
        }
        /// <p>Specifies whether to enable Amazon ECS managed tags for the tasks in the service. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS
        /// Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_enable_ecs_managed_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_ecs_managed_tags = input;
            self
        }
        /// <p>Specifies whether to propagate the tags from the task definition or the service to the
        /// task. If no value is specified, the tags are not propagated.</p>
        pub fn propagate_tags(mut self, input: crate::model::PropagateTags) -> Self {
            self.propagate_tags = Some(input);
            self
        }
        /// <p>Specifies whether to propagate the tags from the task definition or the service to the
        /// task. If no value is specified, the tags are not propagated.</p>
        pub fn set_propagate_tags(
            mut self,
            input: std::option::Option<crate::model::PropagateTags>,
        ) -> Self {
            self.propagate_tags = input;
            self
        }
        /// <p>Whether or not the execute command functionality is enabled for the service. If
        /// <code>true</code>, the execute command functionality is enabled for all containers
        /// in tasks as part of the service.</p>
        pub fn enable_execute_command(mut self, input: bool) -> Self {
            self.enable_execute_command = Some(input);
            self
        }
        /// <p>Whether or not the execute command functionality is enabled for the service. If
        /// <code>true</code>, the execute command functionality is enabled for all containers
        /// in tasks as part of the service.</p>
        pub fn set_enable_execute_command(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_execute_command = input;
            self
        }
        /// Consumes the builder and constructs a [`Service`](crate::model::Service)
        pub fn build(self) -> crate::model::Service {
            crate::model::Service {
                service_arn: self.service_arn,
                service_name: self.service_name,
                cluster_arn: self.cluster_arn,
                load_balancers: self.load_balancers,
                service_registries: self.service_registries,
                status: self.status,
                desired_count: self.desired_count.unwrap_or_default(),
                running_count: self.running_count.unwrap_or_default(),
                pending_count: self.pending_count.unwrap_or_default(),
                launch_type: self.launch_type,
                capacity_provider_strategy: self.capacity_provider_strategy,
                platform_version: self.platform_version,
                platform_family: self.platform_family,
                task_definition: self.task_definition,
                deployment_configuration: self.deployment_configuration,
                task_sets: self.task_sets,
                deployments: self.deployments,
                role_arn: self.role_arn,
                events: self.events,
                created_at: self.created_at,
                placement_constraints: self.placement_constraints,
                placement_strategy: self.placement_strategy,
                network_configuration: self.network_configuration,
                health_check_grace_period_seconds: self.health_check_grace_period_seconds,
                scheduling_strategy: self.scheduling_strategy,
                deployment_controller: self.deployment_controller,
                tags: self.tags,
                created_by: self.created_by,
                enable_ecs_managed_tags: self.enable_ecs_managed_tags.unwrap_or_default(),
                propagate_tags: self.propagate_tags,
                enable_execute_command: self.enable_execute_command.unwrap_or_default(),
            }
        }
    }
}
impl Service {
    /// Creates a new builder-style object to manufacture [`Service`](crate::model::Service)
    pub fn builder() -> crate::model::service::Builder {
        crate::model::service::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PropagateTags {
    #[allow(missing_docs)] // documentation missing in model
    Service,
    #[allow(missing_docs)] // documentation missing in model
    TaskDefinition,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PropagateTags {
    fn from(s: &str) -> Self {
        match s {
            "SERVICE" => PropagateTags::Service,
            "TASK_DEFINITION" => PropagateTags::TaskDefinition,
            other => PropagateTags::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PropagateTags {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PropagateTags::from(s))
    }
}
impl PropagateTags {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PropagateTags::Service => "SERVICE",
            PropagateTags::TaskDefinition => "TASK_DEFINITION",
            PropagateTags::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SERVICE", "TASK_DEFINITION"]
    }
}
impl AsRef<str> for PropagateTags {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The deployment controller to use for the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentController {
    /// <p>The deployment controller type to use.</p>
    /// <p>There are three deployment controller types available:</p>
    /// <dl>
    /// <dt>ECS</dt>
    /// <dd>
    /// <p>The rolling update (<code>ECS</code>) deployment type involves replacing
    /// the current running version of the container with the latest version. The
    /// number of containers Amazon ECS adds or removes from the service during a rolling
    /// update is controlled by adjusting the minimum and maximum number of healthy
    /// tasks allowed during a service deployment, as specified in the <a>DeploymentConfiguration</a>.</p>
    /// </dd>
    /// <dt>CODE_DEPLOY</dt>
    /// <dd>
    /// <p>The blue/green (<code>CODE_DEPLOY</code>) deployment type uses the
    /// blue/green deployment model powered by CodeDeploy, which allows you to verify a
    /// new deployment of a service before sending production traffic to it.</p>
    /// </dd>
    /// <dt>EXTERNAL</dt>
    /// <dd>
    /// <p>The external (<code>EXTERNAL</code>) deployment type enables you to use
    /// any third-party deployment controller for full control over the deployment
    /// process for an Amazon ECS service.</p>
    /// </dd>
    /// </dl>
    pub r#type: std::option::Option<crate::model::DeploymentControllerType>,
}
impl std::fmt::Debug for DeploymentController {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentController");
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`DeploymentController`](crate::model::DeploymentController)
pub mod deployment_controller {
    /// A builder for [`DeploymentController`](crate::model::DeploymentController)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::DeploymentControllerType>,
    }
    impl Builder {
        /// <p>The deployment controller type to use.</p>
        /// <p>There are three deployment controller types available:</p>
        /// <dl>
        /// <dt>ECS</dt>
        /// <dd>
        /// <p>The rolling update (<code>ECS</code>) deployment type involves replacing
        /// the current running version of the container with the latest version. The
        /// number of containers Amazon ECS adds or removes from the service during a rolling
        /// update is controlled by adjusting the minimum and maximum number of healthy
        /// tasks allowed during a service deployment, as specified in the <a>DeploymentConfiguration</a>.</p>
        /// </dd>
        /// <dt>CODE_DEPLOY</dt>
        /// <dd>
        /// <p>The blue/green (<code>CODE_DEPLOY</code>) deployment type uses the
        /// blue/green deployment model powered by CodeDeploy, which allows you to verify a
        /// new deployment of a service before sending production traffic to it.</p>
        /// </dd>
        /// <dt>EXTERNAL</dt>
        /// <dd>
        /// <p>The external (<code>EXTERNAL</code>) deployment type enables you to use
        /// any third-party deployment controller for full control over the deployment
        /// process for an Amazon ECS service.</p>
        /// </dd>
        /// </dl>
        pub fn r#type(mut self, input: crate::model::DeploymentControllerType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The deployment controller type to use.</p>
        /// <p>There are three deployment controller types available:</p>
        /// <dl>
        /// <dt>ECS</dt>
        /// <dd>
        /// <p>The rolling update (<code>ECS</code>) deployment type involves replacing
        /// the current running version of the container with the latest version. The
        /// number of containers Amazon ECS adds or removes from the service during a rolling
        /// update is controlled by adjusting the minimum and maximum number of healthy
        /// tasks allowed during a service deployment, as specified in the <a>DeploymentConfiguration</a>.</p>
        /// </dd>
        /// <dt>CODE_DEPLOY</dt>
        /// <dd>
        /// <p>The blue/green (<code>CODE_DEPLOY</code>) deployment type uses the
        /// blue/green deployment model powered by CodeDeploy, which allows you to verify a
        /// new deployment of a service before sending production traffic to it.</p>
        /// </dd>
        /// <dt>EXTERNAL</dt>
        /// <dd>
        /// <p>The external (<code>EXTERNAL</code>) deployment type enables you to use
        /// any third-party deployment controller for full control over the deployment
        /// process for an Amazon ECS service.</p>
        /// </dd>
        /// </dl>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DeploymentControllerType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentController`](crate::model::DeploymentController)
        pub fn build(self) -> crate::model::DeploymentController {
            crate::model::DeploymentController {
                r#type: self.r#type,
            }
        }
    }
}
impl DeploymentController {
    /// Creates a new builder-style object to manufacture [`DeploymentController`](crate::model::DeploymentController)
    pub fn builder() -> crate::model::deployment_controller::Builder {
        crate::model::deployment_controller::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentControllerType {
    #[allow(missing_docs)] // documentation missing in model
    CodeDeploy,
    #[allow(missing_docs)] // documentation missing in model
    Ecs,
    #[allow(missing_docs)] // documentation missing in model
    External,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentControllerType {
    fn from(s: &str) -> Self {
        match s {
            "CODE_DEPLOY" => DeploymentControllerType::CodeDeploy,
            "ECS" => DeploymentControllerType::Ecs,
            "EXTERNAL" => DeploymentControllerType::External,
            other => DeploymentControllerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentControllerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentControllerType::from(s))
    }
}
impl DeploymentControllerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentControllerType::CodeDeploy => "CODE_DEPLOY",
            DeploymentControllerType::Ecs => "ECS",
            DeploymentControllerType::External => "EXTERNAL",
            DeploymentControllerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CODE_DEPLOY", "ECS", "EXTERNAL"]
    }
}
impl AsRef<str> for DeploymentControllerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SchedulingStrategy {
    #[allow(missing_docs)] // documentation missing in model
    Daemon,
    #[allow(missing_docs)] // documentation missing in model
    Replica,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SchedulingStrategy {
    fn from(s: &str) -> Self {
        match s {
            "DAEMON" => SchedulingStrategy::Daemon,
            "REPLICA" => SchedulingStrategy::Replica,
            other => SchedulingStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SchedulingStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SchedulingStrategy::from(s))
    }
}
impl SchedulingStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SchedulingStrategy::Daemon => "DAEMON",
            SchedulingStrategy::Replica => "REPLICA",
            SchedulingStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DAEMON", "REPLICA"]
    }
}
impl AsRef<str> for SchedulingStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The task placement strategy for a task or service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html">Task Placement Strategies</a> in the
/// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlacementStrategy {
    /// <p>The type of placement strategy. The <code>random</code> placement strategy randomly
    /// places tasks on available candidates. The <code>spread</code> placement strategy spreads
    /// placement across available candidates evenly based on the <code>field</code> parameter.
    /// The <code>binpack</code> strategy places tasks on available candidates that have the
    /// least available amount of the resource that is specified with the <code>field</code>
    /// parameter. For example, if you binpack on memory, a task is placed on the instance with
    /// the least amount of remaining memory (but still enough to run the task).</p>
    pub r#type: std::option::Option<crate::model::PlacementStrategyType>,
    /// <p>The field to apply the placement strategy against. For the <code>spread</code>
    /// placement strategy, valid values are <code>instanceId</code> (or <code>host</code>,
    /// which has the same effect), or any platform or custom attribute that is applied to a
    /// container instance, such as <code>attribute:ecs.availability-zone</code>. For the
    /// <code>binpack</code> placement strategy, valid values are <code>cpu</code> and
    /// <code>memory</code>. For the <code>random</code> placement strategy, this field is
    /// not used.</p>
    pub field: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PlacementStrategy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlacementStrategy");
        formatter.field("r#type", &self.r#type);
        formatter.field("field", &self.field);
        formatter.finish()
    }
}
/// See [`PlacementStrategy`](crate::model::PlacementStrategy)
pub mod placement_strategy {
    /// A builder for [`PlacementStrategy`](crate::model::PlacementStrategy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::PlacementStrategyType>,
        pub(crate) field: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of placement strategy. The <code>random</code> placement strategy randomly
        /// places tasks on available candidates. The <code>spread</code> placement strategy spreads
        /// placement across available candidates evenly based on the <code>field</code> parameter.
        /// The <code>binpack</code> strategy places tasks on available candidates that have the
        /// least available amount of the resource that is specified with the <code>field</code>
        /// parameter. For example, if you binpack on memory, a task is placed on the instance with
        /// the least amount of remaining memory (but still enough to run the task).</p>
        pub fn r#type(mut self, input: crate::model::PlacementStrategyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of placement strategy. The <code>random</code> placement strategy randomly
        /// places tasks on available candidates. The <code>spread</code> placement strategy spreads
        /// placement across available candidates evenly based on the <code>field</code> parameter.
        /// The <code>binpack</code> strategy places tasks on available candidates that have the
        /// least available amount of the resource that is specified with the <code>field</code>
        /// parameter. For example, if you binpack on memory, a task is placed on the instance with
        /// the least amount of remaining memory (but still enough to run the task).</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::PlacementStrategyType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The field to apply the placement strategy against. For the <code>spread</code>
        /// placement strategy, valid values are <code>instanceId</code> (or <code>host</code>,
        /// which has the same effect), or any platform or custom attribute that is applied to a
        /// container instance, such as <code>attribute:ecs.availability-zone</code>. For the
        /// <code>binpack</code> placement strategy, valid values are <code>cpu</code> and
        /// <code>memory</code>. For the <code>random</code> placement strategy, this field is
        /// not used.</p>
        pub fn field(mut self, input: impl Into<std::string::String>) -> Self {
            self.field = Some(input.into());
            self
        }
        /// <p>The field to apply the placement strategy against. For the <code>spread</code>
        /// placement strategy, valid values are <code>instanceId</code> (or <code>host</code>,
        /// which has the same effect), or any platform or custom attribute that is applied to a
        /// container instance, such as <code>attribute:ecs.availability-zone</code>. For the
        /// <code>binpack</code> placement strategy, valid values are <code>cpu</code> and
        /// <code>memory</code>. For the <code>random</code> placement strategy, this field is
        /// not used.</p>
        pub fn set_field(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field = input;
            self
        }
        /// Consumes the builder and constructs a [`PlacementStrategy`](crate::model::PlacementStrategy)
        pub fn build(self) -> crate::model::PlacementStrategy {
            crate::model::PlacementStrategy {
                r#type: self.r#type,
                field: self.field,
            }
        }
    }
}
impl PlacementStrategy {
    /// Creates a new builder-style object to manufacture [`PlacementStrategy`](crate::model::PlacementStrategy)
    pub fn builder() -> crate::model::placement_strategy::Builder {
        crate::model::placement_strategy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PlacementStrategyType {
    #[allow(missing_docs)] // documentation missing in model
    Binpack,
    #[allow(missing_docs)] // documentation missing in model
    Random,
    #[allow(missing_docs)] // documentation missing in model
    Spread,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PlacementStrategyType {
    fn from(s: &str) -> Self {
        match s {
            "binpack" => PlacementStrategyType::Binpack,
            "random" => PlacementStrategyType::Random,
            "spread" => PlacementStrategyType::Spread,
            other => PlacementStrategyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PlacementStrategyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PlacementStrategyType::from(s))
    }
}
impl PlacementStrategyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PlacementStrategyType::Binpack => "binpack",
            PlacementStrategyType::Random => "random",
            PlacementStrategyType::Spread => "spread",
            PlacementStrategyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["binpack", "random", "spread"]
    }
}
impl AsRef<str> for PlacementStrategyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing a constraint on task placement. For more information, see
/// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html">Task Placement Constraints</a> in the
/// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
/// <note>
/// <p>If you are using the Fargate launch type, task placement constraints
/// are not supported.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlacementConstraint {
    /// <p>The type of constraint. Use <code>distinctInstance</code> to ensure that each task in
    /// a particular group is running on a different container instance. Use
    /// <code>memberOf</code> to restrict the selection to a group of valid
    /// candidates.</p>
    pub r#type: std::option::Option<crate::model::PlacementConstraintType>,
    /// <p>A cluster query language expression to apply to the constraint. The expression can
    /// have a maximum length of 2000 characters. You can't specify an expression if the
    /// constraint type is <code>distinctInstance</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster query language</a> in the
    /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub expression: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PlacementConstraint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlacementConstraint");
        formatter.field("r#type", &self.r#type);
        formatter.field("expression", &self.expression);
        formatter.finish()
    }
}
/// See [`PlacementConstraint`](crate::model::PlacementConstraint)
pub mod placement_constraint {
    /// A builder for [`PlacementConstraint`](crate::model::PlacementConstraint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::PlacementConstraintType>,
        pub(crate) expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of constraint. Use <code>distinctInstance</code> to ensure that each task in
        /// a particular group is running on a different container instance. Use
        /// <code>memberOf</code> to restrict the selection to a group of valid
        /// candidates.</p>
        pub fn r#type(mut self, input: crate::model::PlacementConstraintType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of constraint. Use <code>distinctInstance</code> to ensure that each task in
        /// a particular group is running on a different container instance. Use
        /// <code>memberOf</code> to restrict the selection to a group of valid
        /// candidates.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::PlacementConstraintType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A cluster query language expression to apply to the constraint. The expression can
        /// have a maximum length of 2000 characters. You can't specify an expression if the
        /// constraint type is <code>distinctInstance</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster query language</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>A cluster query language expression to apply to the constraint. The expression can
        /// have a maximum length of 2000 characters. You can't specify an expression if the
        /// constraint type is <code>distinctInstance</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster query language</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// Consumes the builder and constructs a [`PlacementConstraint`](crate::model::PlacementConstraint)
        pub fn build(self) -> crate::model::PlacementConstraint {
            crate::model::PlacementConstraint {
                r#type: self.r#type,
                expression: self.expression,
            }
        }
    }
}
impl PlacementConstraint {
    /// Creates a new builder-style object to manufacture [`PlacementConstraint`](crate::model::PlacementConstraint)
    pub fn builder() -> crate::model::placement_constraint::Builder {
        crate::model::placement_constraint::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PlacementConstraintType {
    #[allow(missing_docs)] // documentation missing in model
    DistinctInstance,
    #[allow(missing_docs)] // documentation missing in model
    MemberOf,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PlacementConstraintType {
    fn from(s: &str) -> Self {
        match s {
            "distinctInstance" => PlacementConstraintType::DistinctInstance,
            "memberOf" => PlacementConstraintType::MemberOf,
            other => PlacementConstraintType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PlacementConstraintType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PlacementConstraintType::from(s))
    }
}
impl PlacementConstraintType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PlacementConstraintType::DistinctInstance => "distinctInstance",
            PlacementConstraintType::MemberOf => "memberOf",
            PlacementConstraintType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["distinctInstance", "memberOf"]
    }
}
impl AsRef<str> for PlacementConstraintType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details on an event associated with a service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceEvent {
    /// <p>The ID string of the event.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Unix timestamp for when the event was triggered.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The event message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceEvent");
        formatter.field("id", &self.id);
        formatter.field("created_at", &self.created_at);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ServiceEvent`](crate::model::ServiceEvent)
pub mod service_event {
    /// A builder for [`ServiceEvent`](crate::model::ServiceEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID string of the event.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID string of the event.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Unix timestamp for when the event was triggered.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the event was triggered.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The event message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The event message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceEvent`](crate::model::ServiceEvent)
        pub fn build(self) -> crate::model::ServiceEvent {
            crate::model::ServiceEvent {
                id: self.id,
                created_at: self.created_at,
                message: self.message,
            }
        }
    }
}
impl ServiceEvent {
    /// Creates a new builder-style object to manufacture [`ServiceEvent`](crate::model::ServiceEvent)
    pub fn builder() -> crate::model::service_event::Builder {
        crate::model::service_event::Builder::default()
    }
}

/// <p>The details of an Amazon ECS service deployment. This is used only when a service uses the
/// <code>ECS</code> deployment controller type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Deployment {
    /// <p>The ID of the deployment.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The status of the deployment. The following describes each state:</p>
    /// <dl>
    /// <dt>PRIMARY</dt>
    /// <dd>
    /// <p>The most recent deployment of a service.</p>
    /// </dd>
    /// <dt>ACTIVE</dt>
    /// <dd>
    /// <p>A service deployment that still has running tasks, but are in the process
    /// of being replaced with a new <code>PRIMARY</code> deployment.</p>
    /// </dd>
    /// <dt>INACTIVE</dt>
    /// <dd>
    /// <p>A deployment that has been completely replaced.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<std::string::String>,
    /// <p>The most recent task definition that was specified for the tasks in the service to
    /// use.</p>
    pub task_definition: std::option::Option<std::string::String>,
    /// <p>The most recent desired count of tasks that was specified for the service to deploy or
    /// maintain.</p>
    pub desired_count: i32,
    /// <p>The number of tasks in the deployment that are in the <code>PENDING</code>
    /// status.</p>
    pub pending_count: i32,
    /// <p>The number of tasks in the deployment that are in the <code>RUNNING</code>
    /// status.</p>
    pub running_count: i32,
    /// <p>The number of consecutively failed tasks in the deployment. A task is considered a
    /// failure if the service scheduler can't launch the task, the task doesn't transition to a
    /// <code>RUNNING</code> state, or if it fails any of its defined health checks and is
    /// stopped.</p>
    /// <note>
    /// <p>Once a service deployment has one or more successfully running tasks, the failed
    /// task count resets to zero and stops being evaluated.</p>
    /// </note>
    pub failed_tasks: i32,
    /// <p>The Unix timestamp for when the service deployment was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Unix timestamp for when the service deployment was last updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The capacity provider strategy that the deployment is using.</p>
    pub capacity_provider_strategy:
        std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
    /// <p>The launch type the tasks in the service are using. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS
    /// Launch Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub launch_type: std::option::Option<crate::model::LaunchType>,
    /// <p>The platform version on which your tasks in the service are running. A platform
    /// version is only specified for tasks using the Fargate launch type. If one
    /// is not specified, the <code>LATEST</code> platform version is used by default. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
    /// Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub platform_version: std::option::Option<std::string::String>,
    /// <p>The operating system  that your tasks in the service, or tasks are running on. A platform family is specified only for tasks using the Fargate launch type. </p>
    /// <p> All tasks that run as part of this service must use the same <code>platformFamily</code> value as the service, for example, <code> LINUX.</code>.</p>
    pub platform_family: std::option::Option<std::string::String>,
    /// <p>The VPC subnet and security group configuration for tasks that receive their own
    /// elastic network interface by using the <code>awsvpc</code> networking mode.</p>
    pub network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
    /// <note>
    /// <p>The <code>rolloutState</code> of a service is only returned for services that use
    /// the rolling update (<code>ECS</code>) deployment type that are not behind a
    /// Classic Load Balancer.</p>
    /// </note>
    /// <p>The rollout state of the deployment. When a service deployment is started, it begins
    /// in an <code>IN_PROGRESS</code> state. When the service reaches a steady state, the
    /// deployment will transition to a <code>COMPLETED</code> state. If the service fails to
    /// reach a steady state and circuit breaker is enabled, the deployment will transition to a
    /// <code>FAILED</code> state. A deployment in <code>FAILED</code> state will launch no
    /// new tasks. For more information, see <a>DeploymentCircuitBreaker</a>.</p>
    pub rollout_state: std::option::Option<crate::model::DeploymentRolloutState>,
    /// <p>A description of the rollout state of a deployment.</p>
    pub rollout_state_reason: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Deployment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Deployment");
        formatter.field("id", &self.id);
        formatter.field("status", &self.status);
        formatter.field("task_definition", &self.task_definition);
        formatter.field("desired_count", &self.desired_count);
        formatter.field("pending_count", &self.pending_count);
        formatter.field("running_count", &self.running_count);
        formatter.field("failed_tasks", &self.failed_tasks);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field(
            "capacity_provider_strategy",
            &self.capacity_provider_strategy,
        );
        formatter.field("launch_type", &self.launch_type);
        formatter.field("platform_version", &self.platform_version);
        formatter.field("platform_family", &self.platform_family);
        formatter.field("network_configuration", &self.network_configuration);
        formatter.field("rollout_state", &self.rollout_state);
        formatter.field("rollout_state_reason", &self.rollout_state_reason);
        formatter.finish()
    }
}
/// See [`Deployment`](crate::model::Deployment)
pub mod deployment {
    /// A builder for [`Deployment`](crate::model::Deployment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) task_definition: std::option::Option<std::string::String>,
        pub(crate) desired_count: std::option::Option<i32>,
        pub(crate) pending_count: std::option::Option<i32>,
        pub(crate) running_count: std::option::Option<i32>,
        pub(crate) failed_tasks: std::option::Option<i32>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) capacity_provider_strategy:
            std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        pub(crate) launch_type: std::option::Option<crate::model::LaunchType>,
        pub(crate) platform_version: std::option::Option<std::string::String>,
        pub(crate) platform_family: std::option::Option<std::string::String>,
        pub(crate) network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
        pub(crate) rollout_state: std::option::Option<crate::model::DeploymentRolloutState>,
        pub(crate) rollout_state_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the deployment.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the deployment.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The status of the deployment. The following describes each state:</p>
        /// <dl>
        /// <dt>PRIMARY</dt>
        /// <dd>
        /// <p>The most recent deployment of a service.</p>
        /// </dd>
        /// <dt>ACTIVE</dt>
        /// <dd>
        /// <p>A service deployment that still has running tasks, but are in the process
        /// of being replaced with a new <code>PRIMARY</code> deployment.</p>
        /// </dd>
        /// <dt>INACTIVE</dt>
        /// <dd>
        /// <p>A deployment that has been completely replaced.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the deployment. The following describes each state:</p>
        /// <dl>
        /// <dt>PRIMARY</dt>
        /// <dd>
        /// <p>The most recent deployment of a service.</p>
        /// </dd>
        /// <dt>ACTIVE</dt>
        /// <dd>
        /// <p>A service deployment that still has running tasks, but are in the process
        /// of being replaced with a new <code>PRIMARY</code> deployment.</p>
        /// </dd>
        /// <dt>INACTIVE</dt>
        /// <dd>
        /// <p>A deployment that has been completely replaced.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The most recent task definition that was specified for the tasks in the service to
        /// use.</p>
        pub fn task_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_definition = Some(input.into());
            self
        }
        /// <p>The most recent task definition that was specified for the tasks in the service to
        /// use.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_definition = input;
            self
        }
        /// <p>The most recent desired count of tasks that was specified for the service to deploy or
        /// maintain.</p>
        pub fn desired_count(mut self, input: i32) -> Self {
            self.desired_count = Some(input);
            self
        }
        /// <p>The most recent desired count of tasks that was specified for the service to deploy or
        /// maintain.</p>
        pub fn set_desired_count(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_count = input;
            self
        }
        /// <p>The number of tasks in the deployment that are in the <code>PENDING</code>
        /// status.</p>
        pub fn pending_count(mut self, input: i32) -> Self {
            self.pending_count = Some(input);
            self
        }
        /// <p>The number of tasks in the deployment that are in the <code>PENDING</code>
        /// status.</p>
        pub fn set_pending_count(mut self, input: std::option::Option<i32>) -> Self {
            self.pending_count = input;
            self
        }
        /// <p>The number of tasks in the deployment that are in the <code>RUNNING</code>
        /// status.</p>
        pub fn running_count(mut self, input: i32) -> Self {
            self.running_count = Some(input);
            self
        }
        /// <p>The number of tasks in the deployment that are in the <code>RUNNING</code>
        /// status.</p>
        pub fn set_running_count(mut self, input: std::option::Option<i32>) -> Self {
            self.running_count = input;
            self
        }
        /// <p>The number of consecutively failed tasks in the deployment. A task is considered a
        /// failure if the service scheduler can't launch the task, the task doesn't transition to a
        /// <code>RUNNING</code> state, or if it fails any of its defined health checks and is
        /// stopped.</p>
        /// <note>
        /// <p>Once a service deployment has one or more successfully running tasks, the failed
        /// task count resets to zero and stops being evaluated.</p>
        /// </note>
        pub fn failed_tasks(mut self, input: i32) -> Self {
            self.failed_tasks = Some(input);
            self
        }
        /// <p>The number of consecutively failed tasks in the deployment. A task is considered a
        /// failure if the service scheduler can't launch the task, the task doesn't transition to a
        /// <code>RUNNING</code> state, or if it fails any of its defined health checks and is
        /// stopped.</p>
        /// <note>
        /// <p>Once a service deployment has one or more successfully running tasks, the failed
        /// task count resets to zero and stops being evaluated.</p>
        /// </note>
        pub fn set_failed_tasks(mut self, input: std::option::Option<i32>) -> Self {
            self.failed_tasks = input;
            self
        }
        /// <p>The Unix timestamp for when the service deployment was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the service deployment was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Unix timestamp for when the service deployment was last updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the service deployment was last updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Appends an item to `capacity_provider_strategy`.
        ///
        /// To override the contents of this collection use [`set_capacity_provider_strategy`](Self::set_capacity_provider_strategy).
        ///
        /// <p>The capacity provider strategy that the deployment is using.</p>
        pub fn capacity_provider_strategy(
            mut self,
            input: impl Into<crate::model::CapacityProviderStrategyItem>,
        ) -> Self {
            let mut v = self.capacity_provider_strategy.unwrap_or_default();
            v.push(input.into());
            self.capacity_provider_strategy = Some(v);
            self
        }
        /// <p>The capacity provider strategy that the deployment is using.</p>
        pub fn set_capacity_provider_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        ) -> Self {
            self.capacity_provider_strategy = input;
            self
        }
        /// <p>The launch type the tasks in the service are using. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS
        /// Launch Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn launch_type(mut self, input: crate::model::LaunchType) -> Self {
            self.launch_type = Some(input);
            self
        }
        /// <p>The launch type the tasks in the service are using. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS
        /// Launch Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_launch_type(
            mut self,
            input: std::option::Option<crate::model::LaunchType>,
        ) -> Self {
            self.launch_type = input;
            self
        }
        /// <p>The platform version on which your tasks in the service are running. A platform
        /// version is only specified for tasks using the Fargate launch type. If one
        /// is not specified, the <code>LATEST</code> platform version is used by default. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
        /// Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_version = Some(input.into());
            self
        }
        /// <p>The platform version on which your tasks in the service are running. A platform
        /// version is only specified for tasks using the Fargate launch type. If one
        /// is not specified, the <code>LATEST</code> platform version is used by default. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
        /// Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_version = input;
            self
        }
        /// <p>The operating system  that your tasks in the service, or tasks are running on. A platform family is specified only for tasks using the Fargate launch type. </p>
        /// <p> All tasks that run as part of this service must use the same <code>platformFamily</code> value as the service, for example, <code> LINUX.</code>.</p>
        pub fn platform_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_family = Some(input.into());
            self
        }
        /// <p>The operating system  that your tasks in the service, or tasks are running on. A platform family is specified only for tasks using the Fargate launch type. </p>
        /// <p> All tasks that run as part of this service must use the same <code>platformFamily</code> value as the service, for example, <code> LINUX.</code>.</p>
        pub fn set_platform_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_family = input;
            self
        }
        /// <p>The VPC subnet and security group configuration for tasks that receive their own
        /// elastic network interface by using the <code>awsvpc</code> networking mode.</p>
        pub fn network_configuration(mut self, input: crate::model::NetworkConfiguration) -> Self {
            self.network_configuration = Some(input);
            self
        }
        /// <p>The VPC subnet and security group configuration for tasks that receive their own
        /// elastic network interface by using the <code>awsvpc</code> networking mode.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkConfiguration>,
        ) -> Self {
            self.network_configuration = input;
            self
        }
        /// <note>
        /// <p>The <code>rolloutState</code> of a service is only returned for services that use
        /// the rolling update (<code>ECS</code>) deployment type that are not behind a
        /// Classic Load Balancer.</p>
        /// </note>
        /// <p>The rollout state of the deployment. When a service deployment is started, it begins
        /// in an <code>IN_PROGRESS</code> state. When the service reaches a steady state, the
        /// deployment will transition to a <code>COMPLETED</code> state. If the service fails to
        /// reach a steady state and circuit breaker is enabled, the deployment will transition to a
        /// <code>FAILED</code> state. A deployment in <code>FAILED</code> state will launch no
        /// new tasks. For more information, see <a>DeploymentCircuitBreaker</a>.</p>
        pub fn rollout_state(mut self, input: crate::model::DeploymentRolloutState) -> Self {
            self.rollout_state = Some(input);
            self
        }
        /// <note>
        /// <p>The <code>rolloutState</code> of a service is only returned for services that use
        /// the rolling update (<code>ECS</code>) deployment type that are not behind a
        /// Classic Load Balancer.</p>
        /// </note>
        /// <p>The rollout state of the deployment. When a service deployment is started, it begins
        /// in an <code>IN_PROGRESS</code> state. When the service reaches a steady state, the
        /// deployment will transition to a <code>COMPLETED</code> state. If the service fails to
        /// reach a steady state and circuit breaker is enabled, the deployment will transition to a
        /// <code>FAILED</code> state. A deployment in <code>FAILED</code> state will launch no
        /// new tasks. For more information, see <a>DeploymentCircuitBreaker</a>.</p>
        pub fn set_rollout_state(
            mut self,
            input: std::option::Option<crate::model::DeploymentRolloutState>,
        ) -> Self {
            self.rollout_state = input;
            self
        }
        /// <p>A description of the rollout state of a deployment.</p>
        pub fn rollout_state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.rollout_state_reason = Some(input.into());
            self
        }
        /// <p>A description of the rollout state of a deployment.</p>
        pub fn set_rollout_state_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rollout_state_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`Deployment`](crate::model::Deployment)
        pub fn build(self) -> crate::model::Deployment {
            crate::model::Deployment {
                id: self.id,
                status: self.status,
                task_definition: self.task_definition,
                desired_count: self.desired_count.unwrap_or_default(),
                pending_count: self.pending_count.unwrap_or_default(),
                running_count: self.running_count.unwrap_or_default(),
                failed_tasks: self.failed_tasks.unwrap_or_default(),
                created_at: self.created_at,
                updated_at: self.updated_at,
                capacity_provider_strategy: self.capacity_provider_strategy,
                launch_type: self.launch_type,
                platform_version: self.platform_version,
                platform_family: self.platform_family,
                network_configuration: self.network_configuration,
                rollout_state: self.rollout_state,
                rollout_state_reason: self.rollout_state_reason,
            }
        }
    }
}
impl Deployment {
    /// Creates a new builder-style object to manufacture [`Deployment`](crate::model::Deployment)
    pub fn builder() -> crate::model::deployment::Builder {
        crate::model::deployment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentRolloutState {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentRolloutState {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => DeploymentRolloutState::Completed,
            "FAILED" => DeploymentRolloutState::Failed,
            "IN_PROGRESS" => DeploymentRolloutState::InProgress,
            other => DeploymentRolloutState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentRolloutState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentRolloutState::from(s))
    }
}
impl DeploymentRolloutState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentRolloutState::Completed => "COMPLETED",
            DeploymentRolloutState::Failed => "FAILED",
            DeploymentRolloutState::InProgress => "IN_PROGRESS",
            DeploymentRolloutState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "FAILED", "IN_PROGRESS"]
    }
}
impl AsRef<str> for DeploymentRolloutState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Optional deployment parameters that control how many tasks run during a deployment and
/// the ordering of stopping and starting tasks.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentConfiguration {
    /// <note>
    /// <p>The deployment circuit breaker can only be used for services using the rolling
    /// update (<code>ECS</code>) deployment type.</p>
    /// </note>
    /// <p>The <b>deployment circuit breaker</b> determines whether a
    /// service deployment will fail if the service can't reach a steady state. If deployment
    /// circuit breaker is enabled, a service deployment will transition to a failed state and
    /// stop launching new tasks. If rollback is enabled, when a service deployment fails, the
    /// service is rolled back to the last deployment that completed successfully.</p>
    pub deployment_circuit_breaker: std::option::Option<crate::model::DeploymentCircuitBreaker>,
    /// <p>If a service is using the rolling update (<code>ECS</code>) deployment type, the
    /// <b>maximum percent</b> parameter represents an upper limit
    /// on the number of tasks in a service that are allowed in the <code>RUNNING</code> or
    /// <code>PENDING</code> state during a deployment, as a percentage of the desired
    /// number of tasks (rounded down to the nearest integer), and while any container instances
    /// are in the <code>DRAINING</code> state if the service contains tasks using the
    /// EC2 launch type. This parameter enables you to define the deployment batch
    /// size. For example, if your service has a desired number of four tasks and a maximum
    /// percent value of 200%, the scheduler may start four new tasks before stopping the four
    /// older tasks (provided that the cluster resources required to do this are available). The
    /// default value for maximum percent is 200%.</p>
    /// <p>If a service is using the blue/green (<code>CODE_DEPLOY</code>) or
    /// <code>EXTERNAL</code> deployment types and tasks that use the EC2
    /// launch type, the <b>maximum percent</b> value is set to the
    /// default value and is used to define the upper limit on the number of the tasks in the
    /// service that remain in the <code>RUNNING</code> state while the container instances are
    /// in the <code>DRAINING</code> state. If the tasks in the service use the
    /// Fargate launch type, the maximum percent value is not used, although it is
    /// returned when describing your service.</p>
    pub maximum_percent: std::option::Option<i32>,
    /// <p>If a service is using the rolling update (<code>ECS</code>) deployment type, the
    /// <b>minimum healthy percent</b> represents a lower limit on
    /// the number of tasks in a service that must remain in the <code>RUNNING</code> state
    /// during a deployment, as a percentage of the desired number of tasks (rounded up to the
    /// nearest integer), and while any container instances are in the <code>DRAINING</code>
    /// state if the service contains tasks using the EC2 launch type. This
    /// parameter enables you to deploy without using additional cluster capacity. For example,
    /// if your service has a desired number of four tasks and a minimum healthy percent of 50%,
    /// the scheduler may stop two existing tasks to free up cluster capacity before starting
    /// two new tasks. Tasks for services that <i>do not</i> use a load balancer
    /// are considered healthy if they are in the <code>RUNNING</code> state; tasks for services
    /// that <i>do</i> use a load balancer are considered healthy if they are in
    /// the <code>RUNNING</code> state and they are reported as healthy by the load balancer.
    /// The default value for minimum healthy percent is 100%.</p>
    /// <p>If a service is using the blue/green (<code>CODE_DEPLOY</code>) or
    /// <code>EXTERNAL</code> deployment types and tasks that use the EC2
    /// launch type, the <b>minimum healthy percent</b> value is set
    /// to the default value and is used to define the lower limit on the number of the tasks in
    /// the service that remain in the <code>RUNNING</code> state while the container instances
    /// are in the <code>DRAINING</code> state. If the tasks in the service use the
    /// Fargate launch type, the minimum healthy percent value is not used,
    /// although it is returned when describing your service.</p>
    pub minimum_healthy_percent: std::option::Option<i32>,
}
impl std::fmt::Debug for DeploymentConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentConfiguration");
        formatter.field(
            "deployment_circuit_breaker",
            &self.deployment_circuit_breaker,
        );
        formatter.field("maximum_percent", &self.maximum_percent);
        formatter.field("minimum_healthy_percent", &self.minimum_healthy_percent);
        formatter.finish()
    }
}
/// See [`DeploymentConfiguration`](crate::model::DeploymentConfiguration)
pub mod deployment_configuration {
    /// A builder for [`DeploymentConfiguration`](crate::model::DeploymentConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_circuit_breaker:
            std::option::Option<crate::model::DeploymentCircuitBreaker>,
        pub(crate) maximum_percent: std::option::Option<i32>,
        pub(crate) minimum_healthy_percent: std::option::Option<i32>,
    }
    impl Builder {
        /// <note>
        /// <p>The deployment circuit breaker can only be used for services using the rolling
        /// update (<code>ECS</code>) deployment type.</p>
        /// </note>
        /// <p>The <b>deployment circuit breaker</b> determines whether a
        /// service deployment will fail if the service can't reach a steady state. If deployment
        /// circuit breaker is enabled, a service deployment will transition to a failed state and
        /// stop launching new tasks. If rollback is enabled, when a service deployment fails, the
        /// service is rolled back to the last deployment that completed successfully.</p>
        pub fn deployment_circuit_breaker(
            mut self,
            input: crate::model::DeploymentCircuitBreaker,
        ) -> Self {
            self.deployment_circuit_breaker = Some(input);
            self
        }
        /// <note>
        /// <p>The deployment circuit breaker can only be used for services using the rolling
        /// update (<code>ECS</code>) deployment type.</p>
        /// </note>
        /// <p>The <b>deployment circuit breaker</b> determines whether a
        /// service deployment will fail if the service can't reach a steady state. If deployment
        /// circuit breaker is enabled, a service deployment will transition to a failed state and
        /// stop launching new tasks. If rollback is enabled, when a service deployment fails, the
        /// service is rolled back to the last deployment that completed successfully.</p>
        pub fn set_deployment_circuit_breaker(
            mut self,
            input: std::option::Option<crate::model::DeploymentCircuitBreaker>,
        ) -> Self {
            self.deployment_circuit_breaker = input;
            self
        }
        /// <p>If a service is using the rolling update (<code>ECS</code>) deployment type, the
        /// <b>maximum percent</b> parameter represents an upper limit
        /// on the number of tasks in a service that are allowed in the <code>RUNNING</code> or
        /// <code>PENDING</code> state during a deployment, as a percentage of the desired
        /// number of tasks (rounded down to the nearest integer), and while any container instances
        /// are in the <code>DRAINING</code> state if the service contains tasks using the
        /// EC2 launch type. This parameter enables you to define the deployment batch
        /// size. For example, if your service has a desired number of four tasks and a maximum
        /// percent value of 200%, the scheduler may start four new tasks before stopping the four
        /// older tasks (provided that the cluster resources required to do this are available). The
        /// default value for maximum percent is 200%.</p>
        /// <p>If a service is using the blue/green (<code>CODE_DEPLOY</code>) or
        /// <code>EXTERNAL</code> deployment types and tasks that use the EC2
        /// launch type, the <b>maximum percent</b> value is set to the
        /// default value and is used to define the upper limit on the number of the tasks in the
        /// service that remain in the <code>RUNNING</code> state while the container instances are
        /// in the <code>DRAINING</code> state. If the tasks in the service use the
        /// Fargate launch type, the maximum percent value is not used, although it is
        /// returned when describing your service.</p>
        pub fn maximum_percent(mut self, input: i32) -> Self {
            self.maximum_percent = Some(input);
            self
        }
        /// <p>If a service is using the rolling update (<code>ECS</code>) deployment type, the
        /// <b>maximum percent</b> parameter represents an upper limit
        /// on the number of tasks in a service that are allowed in the <code>RUNNING</code> or
        /// <code>PENDING</code> state during a deployment, as a percentage of the desired
        /// number of tasks (rounded down to the nearest integer), and while any container instances
        /// are in the <code>DRAINING</code> state if the service contains tasks using the
        /// EC2 launch type. This parameter enables you to define the deployment batch
        /// size. For example, if your service has a desired number of four tasks and a maximum
        /// percent value of 200%, the scheduler may start four new tasks before stopping the four
        /// older tasks (provided that the cluster resources required to do this are available). The
        /// default value for maximum percent is 200%.</p>
        /// <p>If a service is using the blue/green (<code>CODE_DEPLOY</code>) or
        /// <code>EXTERNAL</code> deployment types and tasks that use the EC2
        /// launch type, the <b>maximum percent</b> value is set to the
        /// default value and is used to define the upper limit on the number of the tasks in the
        /// service that remain in the <code>RUNNING</code> state while the container instances are
        /// in the <code>DRAINING</code> state. If the tasks in the service use the
        /// Fargate launch type, the maximum percent value is not used, although it is
        /// returned when describing your service.</p>
        pub fn set_maximum_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_percent = input;
            self
        }
        /// <p>If a service is using the rolling update (<code>ECS</code>) deployment type, the
        /// <b>minimum healthy percent</b> represents a lower limit on
        /// the number of tasks in a service that must remain in the <code>RUNNING</code> state
        /// during a deployment, as a percentage of the desired number of tasks (rounded up to the
        /// nearest integer), and while any container instances are in the <code>DRAINING</code>
        /// state if the service contains tasks using the EC2 launch type. This
        /// parameter enables you to deploy without using additional cluster capacity. For example,
        /// if your service has a desired number of four tasks and a minimum healthy percent of 50%,
        /// the scheduler may stop two existing tasks to free up cluster capacity before starting
        /// two new tasks. Tasks for services that <i>do not</i> use a load balancer
        /// are considered healthy if they are in the <code>RUNNING</code> state; tasks for services
        /// that <i>do</i> use a load balancer are considered healthy if they are in
        /// the <code>RUNNING</code> state and they are reported as healthy by the load balancer.
        /// The default value for minimum healthy percent is 100%.</p>
        /// <p>If a service is using the blue/green (<code>CODE_DEPLOY</code>) or
        /// <code>EXTERNAL</code> deployment types and tasks that use the EC2
        /// launch type, the <b>minimum healthy percent</b> value is set
        /// to the default value and is used to define the lower limit on the number of the tasks in
        /// the service that remain in the <code>RUNNING</code> state while the container instances
        /// are in the <code>DRAINING</code> state. If the tasks in the service use the
        /// Fargate launch type, the minimum healthy percent value is not used,
        /// although it is returned when describing your service.</p>
        pub fn minimum_healthy_percent(mut self, input: i32) -> Self {
            self.minimum_healthy_percent = Some(input);
            self
        }
        /// <p>If a service is using the rolling update (<code>ECS</code>) deployment type, the
        /// <b>minimum healthy percent</b> represents a lower limit on
        /// the number of tasks in a service that must remain in the <code>RUNNING</code> state
        /// during a deployment, as a percentage of the desired number of tasks (rounded up to the
        /// nearest integer), and while any container instances are in the <code>DRAINING</code>
        /// state if the service contains tasks using the EC2 launch type. This
        /// parameter enables you to deploy without using additional cluster capacity. For example,
        /// if your service has a desired number of four tasks and a minimum healthy percent of 50%,
        /// the scheduler may stop two existing tasks to free up cluster capacity before starting
        /// two new tasks. Tasks for services that <i>do not</i> use a load balancer
        /// are considered healthy if they are in the <code>RUNNING</code> state; tasks for services
        /// that <i>do</i> use a load balancer are considered healthy if they are in
        /// the <code>RUNNING</code> state and they are reported as healthy by the load balancer.
        /// The default value for minimum healthy percent is 100%.</p>
        /// <p>If a service is using the blue/green (<code>CODE_DEPLOY</code>) or
        /// <code>EXTERNAL</code> deployment types and tasks that use the EC2
        /// launch type, the <b>minimum healthy percent</b> value is set
        /// to the default value and is used to define the lower limit on the number of the tasks in
        /// the service that remain in the <code>RUNNING</code> state while the container instances
        /// are in the <code>DRAINING</code> state. If the tasks in the service use the
        /// Fargate launch type, the minimum healthy percent value is not used,
        /// although it is returned when describing your service.</p>
        pub fn set_minimum_healthy_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_healthy_percent = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentConfiguration`](crate::model::DeploymentConfiguration)
        pub fn build(self) -> crate::model::DeploymentConfiguration {
            crate::model::DeploymentConfiguration {
                deployment_circuit_breaker: self.deployment_circuit_breaker,
                maximum_percent: self.maximum_percent,
                minimum_healthy_percent: self.minimum_healthy_percent,
            }
        }
    }
}
impl DeploymentConfiguration {
    /// Creates a new builder-style object to manufacture [`DeploymentConfiguration`](crate::model::DeploymentConfiguration)
    pub fn builder() -> crate::model::deployment_configuration::Builder {
        crate::model::deployment_configuration::Builder::default()
    }
}

/// <note>
/// <p>The deployment circuit breaker can only be used for services using the rolling
/// update (<code>ECS</code>) deployment type that are not behind a Classic Load Balancer.</p>
/// </note>
/// <p>The <b>deployment circuit breaker</b> determines whether a
/// service deployment will fail if the service can't reach a steady state. If enabled, a
/// service deployment will transition to a failed state and stop launching new tasks. You
/// can also enable Amazon ECS to roll back your service to the last completed deployment after a
/// failure. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html">Rolling
/// update</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentCircuitBreaker {
    /// <p>Whether to enable the deployment circuit breaker logic for the service.</p>
    pub enable: bool,
    /// <p>Whether to enable Amazon ECS to roll back the service if a service deployment fails. If
    /// rollback is enabled, when a service deployment fails, the service is rolled back to the
    /// last deployment that completed successfully.</p>
    pub rollback: bool,
}
impl std::fmt::Debug for DeploymentCircuitBreaker {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentCircuitBreaker");
        formatter.field("enable", &self.enable);
        formatter.field("rollback", &self.rollback);
        formatter.finish()
    }
}
/// See [`DeploymentCircuitBreaker`](crate::model::DeploymentCircuitBreaker)
pub mod deployment_circuit_breaker {
    /// A builder for [`DeploymentCircuitBreaker`](crate::model::DeploymentCircuitBreaker)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enable: std::option::Option<bool>,
        pub(crate) rollback: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Whether to enable the deployment circuit breaker logic for the service.</p>
        pub fn enable(mut self, input: bool) -> Self {
            self.enable = Some(input);
            self
        }
        /// <p>Whether to enable the deployment circuit breaker logic for the service.</p>
        pub fn set_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.enable = input;
            self
        }
        /// <p>Whether to enable Amazon ECS to roll back the service if a service deployment fails. If
        /// rollback is enabled, when a service deployment fails, the service is rolled back to the
        /// last deployment that completed successfully.</p>
        pub fn rollback(mut self, input: bool) -> Self {
            self.rollback = Some(input);
            self
        }
        /// <p>Whether to enable Amazon ECS to roll back the service if a service deployment fails. If
        /// rollback is enabled, when a service deployment fails, the service is rolled back to the
        /// last deployment that completed successfully.</p>
        pub fn set_rollback(mut self, input: std::option::Option<bool>) -> Self {
            self.rollback = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentCircuitBreaker`](crate::model::DeploymentCircuitBreaker)
        pub fn build(self) -> crate::model::DeploymentCircuitBreaker {
            crate::model::DeploymentCircuitBreaker {
                enable: self.enable.unwrap_or_default(),
                rollback: self.rollback.unwrap_or_default(),
            }
        }
    }
}
impl DeploymentCircuitBreaker {
    /// Creates a new builder-style object to manufacture [`DeploymentCircuitBreaker`](crate::model::DeploymentCircuitBreaker)
    pub fn builder() -> crate::model::deployment_circuit_breaker::Builder {
        crate::model::deployment_circuit_breaker::Builder::default()
    }
}

/// <p>A failed resource. For a list of common causes, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/api_failures_messages.html">API failure
/// reasons</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Failure {
    /// <p>The Amazon Resource Name (ARN) of the failed resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The reason for the failure.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>The details of the failure.</p>
    pub detail: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Failure {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Failure");
        formatter.field("arn", &self.arn);
        formatter.field("reason", &self.reason);
        formatter.field("detail", &self.detail);
        formatter.finish()
    }
}
/// See [`Failure`](crate::model::Failure)
pub mod failure {
    /// A builder for [`Failure`](crate::model::Failure)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) detail: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the failed resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the failed resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The reason for the failure.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason for the failure.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p>The details of the failure.</p>
        pub fn detail(mut self, input: impl Into<std::string::String>) -> Self {
            self.detail = Some(input.into());
            self
        }
        /// <p>The details of the failure.</p>
        pub fn set_detail(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detail = input;
            self
        }
        /// Consumes the builder and constructs a [`Failure`](crate::model::Failure)
        pub fn build(self) -> crate::model::Failure {
            crate::model::Failure {
                arn: self.arn,
                reason: self.reason,
                detail: self.detail,
            }
        }
    }
}
impl Failure {
    /// Creates a new builder-style object to manufacture [`Failure`](crate::model::Failure)
    pub fn builder() -> crate::model::failure::Builder {
        crate::model::failure::Builder::default()
    }
}

/// <p>An EC2 instance that is running the Amazon ECS agent and has been registered with a
/// cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerInstance {
    /// <p>The Amazon Resource Name (ARN) of the container instance. The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the container instance, the Amazon Web Services account ID of the container instance owner, the <code>container-instance</code> namespace, and then the container instance ID. For example, <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.</p>
    pub container_instance_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the container instance. For Amazon EC2 instances, this value is the Amazon EC2
    /// instance ID. For external instances, this value is the Amazon Web Services Systems Manager managed instance ID.</p>
    pub ec2_instance_id: std::option::Option<std::string::String>,
    /// <p>The capacity provider associated with the container instance.</p>
    pub capacity_provider_name: std::option::Option<std::string::String>,
    /// <p>The version counter for the container instance. Every time a container instance
    /// experiences a change that triggers a CloudWatch event, the version counter is
    /// incremented. If you are replicating your Amazon ECS container instance state with CloudWatch
    /// Events, you can compare the version of a container instance reported by the Amazon ECS APIs
    /// with the version reported in CloudWatch Events for the container instance (inside the
    /// <code>detail</code> object) to verify that the version in your event stream is
    /// current.</p>
    pub version: i64,
    /// <p>The version information for the Amazon ECS container agent and Docker daemon running on the
    /// container instance.</p>
    pub version_info: std::option::Option<crate::model::VersionInfo>,
    /// <p>For CPU and memory resource types, this parameter describes the remaining CPU and
    /// memory that has not already been allocated to tasks and is therefore available for new
    /// tasks. For port resource types, this parameter describes the ports that were reserved by
    /// the Amazon ECS container agent (at instance registration time) and any task containers that
    /// have reserved port mappings on the host (with the <code>host</code> or
    /// <code>bridge</code> network mode). Any port that is not specified here is available
    /// for new tasks.</p>
    pub remaining_resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    /// <p>For CPU and memory resource types, this parameter describes the amount of each
    /// resource that was available on the container instance when the container agent
    /// registered it with Amazon ECS. This value represents the total amount of CPU and memory that
    /// can be allocated on this container instance to tasks. For port resource types, this
    /// parameter describes the ports that were reserved by the Amazon ECS container agent when it
    /// registered the container instance with Amazon ECS.</p>
    pub registered_resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    /// <p>The status of the container instance. The valid values are <code>REGISTERING</code>,
    /// <code>REGISTRATION_FAILED</code>, <code>ACTIVE</code>, <code>INACTIVE</code>,
    /// <code>DEREGISTERING</code>, or <code>DRAINING</code>.</p>
    /// <p>If your account has opted in to the <code>awsvpcTrunking</code> account setting, then
    /// any newly registered container instance will transition to a <code>REGISTERING</code>
    /// status while the trunk elastic network interface is provisioned for the instance. If the
    /// registration fails, the instance will transition to a <code>REGISTRATION_FAILED</code>
    /// status. You can describe the container instance and see the reason for failure in the
    /// <code>statusReason</code> parameter. Once the container instance is terminated, the
    /// instance transitions to a <code>DEREGISTERING</code> status while the trunk elastic
    /// network interface is deprovisioned. The instance then transitions to an
    /// <code>INACTIVE</code> status.</p>
    /// <p>The <code>ACTIVE</code> status indicates that the container instance can accept tasks.
    /// The <code>DRAINING</code> indicates that new tasks are not placed on the container
    /// instance and any service tasks running on the container instance are removed if
    /// possible. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-draining.html">Container Instance Draining</a> in the
    /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The reason that the container instance reached its current status.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>This parameter returns <code>true</code> if the agent is connected to Amazon ECS.
    /// Registered instances with an agent that may be unhealthy or stopped return
    /// <code>false</code>. Only instances connected to an agent can accept placement
    /// requests.</p>
    pub agent_connected: bool,
    /// <p>The number of tasks on the container instance that are in the <code>RUNNING</code>
    /// status.</p>
    pub running_tasks_count: i32,
    /// <p>The number of tasks on the container instance that are in the <code>PENDING</code>
    /// status.</p>
    pub pending_tasks_count: i32,
    /// <p>The status of the most recent agent update. If an update has never been requested,
    /// this value is <code>NULL</code>.</p>
    pub agent_update_status: std::option::Option<crate::model::AgentUpdateStatus>,
    /// <p>The attributes set for the container instance, either by the Amazon ECS container agent at
    /// instance registration or manually with the <a>PutAttributes</a>
    /// operation.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    /// <p>The Unix timestamp for when the container instance was registered.</p>
    pub registered_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The resources attached to a container instance, such as elastic network
    /// interfaces.</p>
    pub attachments: std::option::Option<std::vec::Vec<crate::model::Attachment>>,
    /// <p>The metadata that you apply to the container instance to help you categorize and
    /// organize them. Each tag consists of a key and an optional value, both of which you
    /// define.</p>
    /// <p>The following basic restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of tags per resource - 50</p>
    /// </li>
    /// <li>
    /// <p>For each resource, each tag key must be unique, and each tag key can have only
    /// one value.</p>
    /// </li>
    /// <li>
    /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>If your tagging schema is used across multiple services and resources,
    /// remember that other services may have restrictions on allowed characters.
    /// Generally allowed characters are: letters, numbers, and spaces representable in
    /// UTF-8, and the following characters: + - = . _ : / @.</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
    /// combination of such as a prefix for either keys or values as it is reserved for
    /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
    /// this prefix do not count against your tags per resource limit.</p>
    /// </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for ContainerInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerInstance");
        formatter.field("container_instance_arn", &self.container_instance_arn);
        formatter.field("ec2_instance_id", &self.ec2_instance_id);
        formatter.field("capacity_provider_name", &self.capacity_provider_name);
        formatter.field("version", &self.version);
        formatter.field("version_info", &self.version_info);
        formatter.field("remaining_resources", &self.remaining_resources);
        formatter.field("registered_resources", &self.registered_resources);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("agent_connected", &self.agent_connected);
        formatter.field("running_tasks_count", &self.running_tasks_count);
        formatter.field("pending_tasks_count", &self.pending_tasks_count);
        formatter.field("agent_update_status", &self.agent_update_status);
        formatter.field("attributes", &self.attributes);
        formatter.field("registered_at", &self.registered_at);
        formatter.field("attachments", &self.attachments);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ContainerInstance`](crate::model::ContainerInstance)
pub mod container_instance {
    /// A builder for [`ContainerInstance`](crate::model::ContainerInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_instance_arn: std::option::Option<std::string::String>,
        pub(crate) ec2_instance_id: std::option::Option<std::string::String>,
        pub(crate) capacity_provider_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) version_info: std::option::Option<crate::model::VersionInfo>,
        pub(crate) remaining_resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        pub(crate) registered_resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) agent_connected: std::option::Option<bool>,
        pub(crate) running_tasks_count: std::option::Option<i32>,
        pub(crate) pending_tasks_count: std::option::Option<i32>,
        pub(crate) agent_update_status: std::option::Option<crate::model::AgentUpdateStatus>,
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        pub(crate) registered_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) attachments: std::option::Option<std::vec::Vec<crate::model::Attachment>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the container instance. The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the container instance, the Amazon Web Services account ID of the container instance owner, the <code>container-instance</code> namespace, and then the container instance ID. For example, <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.</p>
        pub fn container_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container instance. The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the container instance, the Amazon Web Services account ID of the container instance owner, the <code>container-instance</code> namespace, and then the container instance ID. For example, <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.</p>
        pub fn set_container_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_instance_arn = input;
            self
        }
        /// <p>The ID of the container instance. For Amazon EC2 instances, this value is the Amazon EC2
        /// instance ID. For external instances, this value is the Amazon Web Services Systems Manager managed instance ID.</p>
        pub fn ec2_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the container instance. For Amazon EC2 instances, this value is the Amazon EC2
        /// instance ID. For external instances, this value is the Amazon Web Services Systems Manager managed instance ID.</p>
        pub fn set_ec2_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_instance_id = input;
            self
        }
        /// <p>The capacity provider associated with the container instance.</p>
        pub fn capacity_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.capacity_provider_name = Some(input.into());
            self
        }
        /// <p>The capacity provider associated with the container instance.</p>
        pub fn set_capacity_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capacity_provider_name = input;
            self
        }
        /// <p>The version counter for the container instance. Every time a container instance
        /// experiences a change that triggers a CloudWatch event, the version counter is
        /// incremented. If you are replicating your Amazon ECS container instance state with CloudWatch
        /// Events, you can compare the version of a container instance reported by the Amazon ECS APIs
        /// with the version reported in CloudWatch Events for the container instance (inside the
        /// <code>detail</code> object) to verify that the version in your event stream is
        /// current.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version counter for the container instance. Every time a container instance
        /// experiences a change that triggers a CloudWatch event, the version counter is
        /// incremented. If you are replicating your Amazon ECS container instance state with CloudWatch
        /// Events, you can compare the version of a container instance reported by the Amazon ECS APIs
        /// with the version reported in CloudWatch Events for the container instance (inside the
        /// <code>detail</code> object) to verify that the version in your event stream is
        /// current.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The version information for the Amazon ECS container agent and Docker daemon running on the
        /// container instance.</p>
        pub fn version_info(mut self, input: crate::model::VersionInfo) -> Self {
            self.version_info = Some(input);
            self
        }
        /// <p>The version information for the Amazon ECS container agent and Docker daemon running on the
        /// container instance.</p>
        pub fn set_version_info(
            mut self,
            input: std::option::Option<crate::model::VersionInfo>,
        ) -> Self {
            self.version_info = input;
            self
        }
        /// Appends an item to `remaining_resources`.
        ///
        /// To override the contents of this collection use [`set_remaining_resources`](Self::set_remaining_resources).
        ///
        /// <p>For CPU and memory resource types, this parameter describes the remaining CPU and
        /// memory that has not already been allocated to tasks and is therefore available for new
        /// tasks. For port resource types, this parameter describes the ports that were reserved by
        /// the Amazon ECS container agent (at instance registration time) and any task containers that
        /// have reserved port mappings on the host (with the <code>host</code> or
        /// <code>bridge</code> network mode). Any port that is not specified here is available
        /// for new tasks.</p>
        pub fn remaining_resources(mut self, input: impl Into<crate::model::Resource>) -> Self {
            let mut v = self.remaining_resources.unwrap_or_default();
            v.push(input.into());
            self.remaining_resources = Some(v);
            self
        }
        /// <p>For CPU and memory resource types, this parameter describes the remaining CPU and
        /// memory that has not already been allocated to tasks and is therefore available for new
        /// tasks. For port resource types, this parameter describes the ports that were reserved by
        /// the Amazon ECS container agent (at instance registration time) and any task containers that
        /// have reserved port mappings on the host (with the <code>host</code> or
        /// <code>bridge</code> network mode). Any port that is not specified here is available
        /// for new tasks.</p>
        pub fn set_remaining_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.remaining_resources = input;
            self
        }
        /// Appends an item to `registered_resources`.
        ///
        /// To override the contents of this collection use [`set_registered_resources`](Self::set_registered_resources).
        ///
        /// <p>For CPU and memory resource types, this parameter describes the amount of each
        /// resource that was available on the container instance when the container agent
        /// registered it with Amazon ECS. This value represents the total amount of CPU and memory that
        /// can be allocated on this container instance to tasks. For port resource types, this
        /// parameter describes the ports that were reserved by the Amazon ECS container agent when it
        /// registered the container instance with Amazon ECS.</p>
        pub fn registered_resources(mut self, input: impl Into<crate::model::Resource>) -> Self {
            let mut v = self.registered_resources.unwrap_or_default();
            v.push(input.into());
            self.registered_resources = Some(v);
            self
        }
        /// <p>For CPU and memory resource types, this parameter describes the amount of each
        /// resource that was available on the container instance when the container agent
        /// registered it with Amazon ECS. This value represents the total amount of CPU and memory that
        /// can be allocated on this container instance to tasks. For port resource types, this
        /// parameter describes the ports that were reserved by the Amazon ECS container agent when it
        /// registered the container instance with Amazon ECS.</p>
        pub fn set_registered_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.registered_resources = input;
            self
        }
        /// <p>The status of the container instance. The valid values are <code>REGISTERING</code>,
        /// <code>REGISTRATION_FAILED</code>, <code>ACTIVE</code>, <code>INACTIVE</code>,
        /// <code>DEREGISTERING</code>, or <code>DRAINING</code>.</p>
        /// <p>If your account has opted in to the <code>awsvpcTrunking</code> account setting, then
        /// any newly registered container instance will transition to a <code>REGISTERING</code>
        /// status while the trunk elastic network interface is provisioned for the instance. If the
        /// registration fails, the instance will transition to a <code>REGISTRATION_FAILED</code>
        /// status. You can describe the container instance and see the reason for failure in the
        /// <code>statusReason</code> parameter. Once the container instance is terminated, the
        /// instance transitions to a <code>DEREGISTERING</code> status while the trunk elastic
        /// network interface is deprovisioned. The instance then transitions to an
        /// <code>INACTIVE</code> status.</p>
        /// <p>The <code>ACTIVE</code> status indicates that the container instance can accept tasks.
        /// The <code>DRAINING</code> indicates that new tasks are not placed on the container
        /// instance and any service tasks running on the container instance are removed if
        /// possible. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-draining.html">Container Instance Draining</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the container instance. The valid values are <code>REGISTERING</code>,
        /// <code>REGISTRATION_FAILED</code>, <code>ACTIVE</code>, <code>INACTIVE</code>,
        /// <code>DEREGISTERING</code>, or <code>DRAINING</code>.</p>
        /// <p>If your account has opted in to the <code>awsvpcTrunking</code> account setting, then
        /// any newly registered container instance will transition to a <code>REGISTERING</code>
        /// status while the trunk elastic network interface is provisioned for the instance. If the
        /// registration fails, the instance will transition to a <code>REGISTRATION_FAILED</code>
        /// status. You can describe the container instance and see the reason for failure in the
        /// <code>statusReason</code> parameter. Once the container instance is terminated, the
        /// instance transitions to a <code>DEREGISTERING</code> status while the trunk elastic
        /// network interface is deprovisioned. The instance then transitions to an
        /// <code>INACTIVE</code> status.</p>
        /// <p>The <code>ACTIVE</code> status indicates that the container instance can accept tasks.
        /// The <code>DRAINING</code> indicates that new tasks are not placed on the container
        /// instance and any service tasks running on the container instance are removed if
        /// possible. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-draining.html">Container Instance Draining</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason that the container instance reached its current status.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>The reason that the container instance reached its current status.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>This parameter returns <code>true</code> if the agent is connected to Amazon ECS.
        /// Registered instances with an agent that may be unhealthy or stopped return
        /// <code>false</code>. Only instances connected to an agent can accept placement
        /// requests.</p>
        pub fn agent_connected(mut self, input: bool) -> Self {
            self.agent_connected = Some(input);
            self
        }
        /// <p>This parameter returns <code>true</code> if the agent is connected to Amazon ECS.
        /// Registered instances with an agent that may be unhealthy or stopped return
        /// <code>false</code>. Only instances connected to an agent can accept placement
        /// requests.</p>
        pub fn set_agent_connected(mut self, input: std::option::Option<bool>) -> Self {
            self.agent_connected = input;
            self
        }
        /// <p>The number of tasks on the container instance that are in the <code>RUNNING</code>
        /// status.</p>
        pub fn running_tasks_count(mut self, input: i32) -> Self {
            self.running_tasks_count = Some(input);
            self
        }
        /// <p>The number of tasks on the container instance that are in the <code>RUNNING</code>
        /// status.</p>
        pub fn set_running_tasks_count(mut self, input: std::option::Option<i32>) -> Self {
            self.running_tasks_count = input;
            self
        }
        /// <p>The number of tasks on the container instance that are in the <code>PENDING</code>
        /// status.</p>
        pub fn pending_tasks_count(mut self, input: i32) -> Self {
            self.pending_tasks_count = Some(input);
            self
        }
        /// <p>The number of tasks on the container instance that are in the <code>PENDING</code>
        /// status.</p>
        pub fn set_pending_tasks_count(mut self, input: std::option::Option<i32>) -> Self {
            self.pending_tasks_count = input;
            self
        }
        /// <p>The status of the most recent agent update. If an update has never been requested,
        /// this value is <code>NULL</code>.</p>
        pub fn agent_update_status(mut self, input: crate::model::AgentUpdateStatus) -> Self {
            self.agent_update_status = Some(input);
            self
        }
        /// <p>The status of the most recent agent update. If an update has never been requested,
        /// this value is <code>NULL</code>.</p>
        pub fn set_agent_update_status(
            mut self,
            input: std::option::Option<crate::model::AgentUpdateStatus>,
        ) -> Self {
            self.agent_update_status = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes set for the container instance, either by the Amazon ECS container agent at
        /// instance registration or manually with the <a>PutAttributes</a>
        /// operation.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::Attribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>The attributes set for the container instance, either by the Amazon ECS container agent at
        /// instance registration or manually with the <a>PutAttributes</a>
        /// operation.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The Unix timestamp for when the container instance was registered.</p>
        pub fn registered_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.registered_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the container instance was registered.</p>
        pub fn set_registered_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.registered_at = input;
            self
        }
        /// Appends an item to `attachments`.
        ///
        /// To override the contents of this collection use [`set_attachments`](Self::set_attachments).
        ///
        /// <p>The resources attached to a container instance, such as elastic network
        /// interfaces.</p>
        pub fn attachments(mut self, input: impl Into<crate::model::Attachment>) -> Self {
            let mut v = self.attachments.unwrap_or_default();
            v.push(input.into());
            self.attachments = Some(v);
            self
        }
        /// <p>The resources attached to a container instance, such as elastic network
        /// interfaces.</p>
        pub fn set_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attachment>>,
        ) -> Self {
            self.attachments = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the container instance to help you categorize and
        /// organize them. Each tag consists of a key and an optional value, both of which you
        /// define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The metadata that you apply to the container instance to help you categorize and
        /// organize them. Each tag consists of a key and an optional value, both of which you
        /// define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerInstance`](crate::model::ContainerInstance)
        pub fn build(self) -> crate::model::ContainerInstance {
            crate::model::ContainerInstance {
                container_instance_arn: self.container_instance_arn,
                ec2_instance_id: self.ec2_instance_id,
                capacity_provider_name: self.capacity_provider_name,
                version: self.version.unwrap_or_default(),
                version_info: self.version_info,
                remaining_resources: self.remaining_resources,
                registered_resources: self.registered_resources,
                status: self.status,
                status_reason: self.status_reason,
                agent_connected: self.agent_connected.unwrap_or_default(),
                running_tasks_count: self.running_tasks_count.unwrap_or_default(),
                pending_tasks_count: self.pending_tasks_count.unwrap_or_default(),
                agent_update_status: self.agent_update_status,
                attributes: self.attributes,
                registered_at: self.registered_at,
                attachments: self.attachments,
                tags: self.tags,
            }
        }
    }
}
impl ContainerInstance {
    /// Creates a new builder-style object to manufacture [`ContainerInstance`](crate::model::ContainerInstance)
    pub fn builder() -> crate::model::container_instance::Builder {
        crate::model::container_instance::Builder::default()
    }
}

/// <p>An object representing a container instance or task attachment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Attachment {
    /// <p>The unique identifier for the attachment.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of the attachment, such as <code>ElasticNetworkInterface</code>.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p> The status of the attachment. Valid values are <code>PRECREATED</code>,
    /// <code>CREATED</code>, <code>ATTACHING</code>, <code>ATTACHED</code>,
    /// <code>DETACHING</code>, <code>DETACHED</code>, and <code>DELETED</code>.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Details of the attachment. For elastic network interfaces, this includes the network
    /// interface ID, the MAC address, the subnet ID, and the private IPv4 address.</p>
    pub details: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
}
impl std::fmt::Debug for Attachment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Attachment");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.field("status", &self.status);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`Attachment`](crate::model::Attachment)
pub mod attachment {
    /// A builder for [`Attachment`](crate::model::Attachment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
    }
    impl Builder {
        /// <p>The unique identifier for the attachment.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the attachment.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of the attachment, such as <code>ElasticNetworkInterface</code>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the attachment, such as <code>ElasticNetworkInterface</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p> The status of the attachment. Valid values are <code>PRECREATED</code>,
        /// <code>CREATED</code>, <code>ATTACHING</code>, <code>ATTACHED</code>,
        /// <code>DETACHING</code>, <code>DETACHED</code>, and <code>DELETED</code>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p> The status of the attachment. Valid values are <code>PRECREATED</code>,
        /// <code>CREATED</code>, <code>ATTACHING</code>, <code>ATTACHED</code>,
        /// <code>DETACHING</code>, <code>DETACHED</code>, and <code>DELETED</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `details`.
        ///
        /// To override the contents of this collection use [`set_details`](Self::set_details).
        ///
        /// <p>Details of the attachment. For elastic network interfaces, this includes the network
        /// interface ID, the MAC address, the subnet ID, and the private IPv4 address.</p>
        pub fn details(mut self, input: impl Into<crate::model::KeyValuePair>) -> Self {
            let mut v = self.details.unwrap_or_default();
            v.push(input.into());
            self.details = Some(v);
            self
        }
        /// <p>Details of the attachment. For elastic network interfaces, this includes the network
        /// interface ID, the MAC address, the subnet ID, and the private IPv4 address.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
        ) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`Attachment`](crate::model::Attachment)
        pub fn build(self) -> crate::model::Attachment {
            crate::model::Attachment {
                id: self.id,
                r#type: self.r#type,
                status: self.status,
                details: self.details,
            }
        }
    }
}
impl Attachment {
    /// Creates a new builder-style object to manufacture [`Attachment`](crate::model::Attachment)
    pub fn builder() -> crate::model::attachment::Builder {
        crate::model::attachment::Builder::default()
    }
}

/// <p>A key-value pair object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyValuePair {
    /// <p>The name of the key-value pair. For environment variables, this is the name of the
    /// environment variable.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the key-value pair. For environment variables, this is the value of the
    /// environment variable.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KeyValuePair {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyValuePair");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`KeyValuePair`](crate::model::KeyValuePair)
pub mod key_value_pair {
    /// A builder for [`KeyValuePair`](crate::model::KeyValuePair)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the key-value pair. For environment variables, this is the name of the
        /// environment variable.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the key-value pair. For environment variables, this is the name of the
        /// environment variable.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the key-value pair. For environment variables, this is the value of the
        /// environment variable.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the key-value pair. For environment variables, this is the value of the
        /// environment variable.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyValuePair`](crate::model::KeyValuePair)
        pub fn build(self) -> crate::model::KeyValuePair {
            crate::model::KeyValuePair {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl KeyValuePair {
    /// Creates a new builder-style object to manufacture [`KeyValuePair`](crate::model::KeyValuePair)
    pub fn builder() -> crate::model::key_value_pair::Builder {
        crate::model::key_value_pair::Builder::default()
    }
}

/// <p>An attribute is a name-value pair associated with an Amazon ECS object. Attributes enable
/// you to extend the Amazon ECS data model by adding custom metadata to your resources. For more
/// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes">Attributes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Attribute {
    /// <p>The name of the attribute. The <code>name</code> must contain between 1 and 128
    /// characters and name may contain letters (uppercase and lowercase), numbers, hyphens,
    /// underscores, forward slashes, back slashes, or periods.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the attribute. The <code>value</code> must contain between 1 and 128
    /// characters and may contain letters (uppercase and lowercase), numbers, hyphens,
    /// underscores, periods, at signs (@), forward slashes, back slashes, colons, or spaces.
    /// The value cannot contain any leading or trailing whitespace.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The type of the target with which to attach the attribute. This parameter is required
    /// if you use the short form ID for a resource instead of the full ARN.</p>
    pub target_type: std::option::Option<crate::model::TargetType>,
    /// <p>The ID of the target. You can specify the short form ID for a resource or the full
    /// Amazon Resource Name (ARN).</p>
    pub target_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Attribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Attribute");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.field("target_type", &self.target_type);
        formatter.field("target_id", &self.target_id);
        formatter.finish()
    }
}
/// See [`Attribute`](crate::model::Attribute)
pub mod attribute {
    /// A builder for [`Attribute`](crate::model::Attribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) target_type: std::option::Option<crate::model::TargetType>,
        pub(crate) target_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the attribute. The <code>name</code> must contain between 1 and 128
        /// characters and name may contain letters (uppercase and lowercase), numbers, hyphens,
        /// underscores, forward slashes, back slashes, or periods.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the attribute. The <code>name</code> must contain between 1 and 128
        /// characters and name may contain letters (uppercase and lowercase), numbers, hyphens,
        /// underscores, forward slashes, back slashes, or periods.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the attribute. The <code>value</code> must contain between 1 and 128
        /// characters and may contain letters (uppercase and lowercase), numbers, hyphens,
        /// underscores, periods, at signs (@), forward slashes, back slashes, colons, or spaces.
        /// The value cannot contain any leading or trailing whitespace.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the attribute. The <code>value</code> must contain between 1 and 128
        /// characters and may contain letters (uppercase and lowercase), numbers, hyphens,
        /// underscores, periods, at signs (@), forward slashes, back slashes, colons, or spaces.
        /// The value cannot contain any leading or trailing whitespace.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The type of the target with which to attach the attribute. This parameter is required
        /// if you use the short form ID for a resource instead of the full ARN.</p>
        pub fn target_type(mut self, input: crate::model::TargetType) -> Self {
            self.target_type = Some(input);
            self
        }
        /// <p>The type of the target with which to attach the attribute. This parameter is required
        /// if you use the short form ID for a resource instead of the full ARN.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::TargetType>,
        ) -> Self {
            self.target_type = input;
            self
        }
        /// <p>The ID of the target. You can specify the short form ID for a resource or the full
        /// Amazon Resource Name (ARN).</p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p>The ID of the target. You can specify the short form ID for a resource or the full
        /// Amazon Resource Name (ARN).</p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Attribute`](crate::model::Attribute)
        pub fn build(self) -> crate::model::Attribute {
            crate::model::Attribute {
                name: self.name,
                value: self.value,
                target_type: self.target_type,
                target_id: self.target_id,
            }
        }
    }
}
impl Attribute {
    /// Creates a new builder-style object to manufacture [`Attribute`](crate::model::Attribute)
    pub fn builder() -> crate::model::attribute::Builder {
        crate::model::attribute::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetType {
    #[allow(missing_docs)] // documentation missing in model
    ContainerInstance,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetType {
    fn from(s: &str) -> Self {
        match s {
            "container-instance" => TargetType::ContainerInstance,
            other => TargetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetType::from(s))
    }
}
impl TargetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetType::ContainerInstance => "container-instance",
            TargetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["container-instance"]
    }
}
impl AsRef<str> for TargetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AgentUpdateStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Staged,
    #[allow(missing_docs)] // documentation missing in model
    Staging,
    #[allow(missing_docs)] // documentation missing in model
    Updated,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AgentUpdateStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => AgentUpdateStatus::Failed,
            "PENDING" => AgentUpdateStatus::Pending,
            "STAGED" => AgentUpdateStatus::Staged,
            "STAGING" => AgentUpdateStatus::Staging,
            "UPDATED" => AgentUpdateStatus::Updated,
            "UPDATING" => AgentUpdateStatus::Updating,
            other => AgentUpdateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AgentUpdateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AgentUpdateStatus::from(s))
    }
}
impl AgentUpdateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AgentUpdateStatus::Failed => "FAILED",
            AgentUpdateStatus::Pending => "PENDING",
            AgentUpdateStatus::Staged => "STAGED",
            AgentUpdateStatus::Staging => "STAGING",
            AgentUpdateStatus::Updated => "UPDATED",
            AgentUpdateStatus::Updating => "UPDATING",
            AgentUpdateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILED", "PENDING", "STAGED", "STAGING", "UPDATED", "UPDATING",
        ]
    }
}
impl AsRef<str> for AgentUpdateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the resources available for a container instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Resource {
    /// <p>The name of the resource, such as <code>CPU</code>, <code>MEMORY</code>,
    /// <code>PORTS</code>, <code>PORTS_UDP</code>, or a user-defined resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the resource, such as <code>INTEGER</code>, <code>DOUBLE</code>,
    /// <code>LONG</code>, or <code>STRINGSET</code>.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>When the <code>doubleValue</code> type is set, the value of the resource must be a
    /// double precision floating-point type.</p>
    pub double_value: f64,
    /// <p>When the <code>longValue</code> type is set, the value of the resource must be an
    /// extended precision floating-point type.</p>
    pub long_value: i64,
    /// <p>When the <code>integerValue</code> type is set, the value of the resource must be an
    /// integer.</p>
    pub integer_value: i32,
    /// <p>When the <code>stringSetValue</code> type is set, the value of the resource must be a
    /// string type.</p>
    pub string_set_value: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for Resource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Resource");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("double_value", &self.double_value);
        formatter.field("long_value", &self.long_value);
        formatter.field("integer_value", &self.integer_value);
        formatter.field("string_set_value", &self.string_set_value);
        formatter.finish()
    }
}
/// See [`Resource`](crate::model::Resource)
pub mod resource {
    /// A builder for [`Resource`](crate::model::Resource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) double_value: std::option::Option<f64>,
        pub(crate) long_value: std::option::Option<i64>,
        pub(crate) integer_value: std::option::Option<i32>,
        pub(crate) string_set_value: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the resource, such as <code>CPU</code>, <code>MEMORY</code>,
        /// <code>PORTS</code>, <code>PORTS_UDP</code>, or a user-defined resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource, such as <code>CPU</code>, <code>MEMORY</code>,
        /// <code>PORTS</code>, <code>PORTS_UDP</code>, or a user-defined resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the resource, such as <code>INTEGER</code>, <code>DOUBLE</code>,
        /// <code>LONG</code>, or <code>STRINGSET</code>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the resource, such as <code>INTEGER</code>, <code>DOUBLE</code>,
        /// <code>LONG</code>, or <code>STRINGSET</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>When the <code>doubleValue</code> type is set, the value of the resource must be a
        /// double precision floating-point type.</p>
        pub fn double_value(mut self, input: f64) -> Self {
            self.double_value = Some(input);
            self
        }
        /// <p>When the <code>doubleValue</code> type is set, the value of the resource must be a
        /// double precision floating-point type.</p>
        pub fn set_double_value(mut self, input: std::option::Option<f64>) -> Self {
            self.double_value = input;
            self
        }
        /// <p>When the <code>longValue</code> type is set, the value of the resource must be an
        /// extended precision floating-point type.</p>
        pub fn long_value(mut self, input: i64) -> Self {
            self.long_value = Some(input);
            self
        }
        /// <p>When the <code>longValue</code> type is set, the value of the resource must be an
        /// extended precision floating-point type.</p>
        pub fn set_long_value(mut self, input: std::option::Option<i64>) -> Self {
            self.long_value = input;
            self
        }
        /// <p>When the <code>integerValue</code> type is set, the value of the resource must be an
        /// integer.</p>
        pub fn integer_value(mut self, input: i32) -> Self {
            self.integer_value = Some(input);
            self
        }
        /// <p>When the <code>integerValue</code> type is set, the value of the resource must be an
        /// integer.</p>
        pub fn set_integer_value(mut self, input: std::option::Option<i32>) -> Self {
            self.integer_value = input;
            self
        }
        /// Appends an item to `string_set_value`.
        ///
        /// To override the contents of this collection use [`set_string_set_value`](Self::set_string_set_value).
        ///
        /// <p>When the <code>stringSetValue</code> type is set, the value of the resource must be a
        /// string type.</p>
        pub fn string_set_value(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.string_set_value.unwrap_or_default();
            v.push(input.into());
            self.string_set_value = Some(v);
            self
        }
        /// <p>When the <code>stringSetValue</code> type is set, the value of the resource must be a
        /// string type.</p>
        pub fn set_string_set_value(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.string_set_value = input;
            self
        }
        /// Consumes the builder and constructs a [`Resource`](crate::model::Resource)
        pub fn build(self) -> crate::model::Resource {
            crate::model::Resource {
                name: self.name,
                r#type: self.r#type,
                double_value: self.double_value.unwrap_or_default(),
                long_value: self.long_value.unwrap_or_default(),
                integer_value: self.integer_value.unwrap_or_default(),
                string_set_value: self.string_set_value,
            }
        }
    }
}
impl Resource {
    /// Creates a new builder-style object to manufacture [`Resource`](crate::model::Resource)
    pub fn builder() -> crate::model::resource::Builder {
        crate::model::resource::Builder::default()
    }
}

/// <p>The Docker and Amazon ECS container agent version information about a container
/// instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VersionInfo {
    /// <p>The version number of the Amazon ECS container agent.</p>
    pub agent_version: std::option::Option<std::string::String>,
    /// <p>The Git commit hash for the Amazon ECS container agent build on the <a href="https://github.com/aws/amazon-ecs-agent/commits/master">amazon-ecs-agent
    /// </a> GitHub repository.</p>
    pub agent_hash: std::option::Option<std::string::String>,
    /// <p>The Docker version running on the container instance.</p>
    pub docker_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for VersionInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VersionInfo");
        formatter.field("agent_version", &self.agent_version);
        formatter.field("agent_hash", &self.agent_hash);
        formatter.field("docker_version", &self.docker_version);
        formatter.finish()
    }
}
/// See [`VersionInfo`](crate::model::VersionInfo)
pub mod version_info {
    /// A builder for [`VersionInfo`](crate::model::VersionInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) agent_version: std::option::Option<std::string::String>,
        pub(crate) agent_hash: std::option::Option<std::string::String>,
        pub(crate) docker_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The version number of the Amazon ECS container agent.</p>
        pub fn agent_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_version = Some(input.into());
            self
        }
        /// <p>The version number of the Amazon ECS container agent.</p>
        pub fn set_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.agent_version = input;
            self
        }
        /// <p>The Git commit hash for the Amazon ECS container agent build on the <a href="https://github.com/aws/amazon-ecs-agent/commits/master">amazon-ecs-agent
        /// </a> GitHub repository.</p>
        pub fn agent_hash(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_hash = Some(input.into());
            self
        }
        /// <p>The Git commit hash for the Amazon ECS container agent build on the <a href="https://github.com/aws/amazon-ecs-agent/commits/master">amazon-ecs-agent
        /// </a> GitHub repository.</p>
        pub fn set_agent_hash(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.agent_hash = input;
            self
        }
        /// <p>The Docker version running on the container instance.</p>
        pub fn docker_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.docker_version = Some(input.into());
            self
        }
        /// <p>The Docker version running on the container instance.</p>
        pub fn set_docker_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.docker_version = input;
            self
        }
        /// Consumes the builder and constructs a [`VersionInfo`](crate::model::VersionInfo)
        pub fn build(self) -> crate::model::VersionInfo {
            crate::model::VersionInfo {
                agent_version: self.agent_version,
                agent_hash: self.agent_hash,
                docker_version: self.docker_version,
            }
        }
    }
}
impl VersionInfo {
    /// Creates a new builder-style object to manufacture [`VersionInfo`](crate::model::VersionInfo)
    pub fn builder() -> crate::model::version_info::Builder {
        crate::model::version_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContainerInstanceStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deregistering,
    #[allow(missing_docs)] // documentation missing in model
    Draining,
    #[allow(missing_docs)] // documentation missing in model
    Registering,
    #[allow(missing_docs)] // documentation missing in model
    RegistrationFailed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContainerInstanceStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ContainerInstanceStatus::Active,
            "DEREGISTERING" => ContainerInstanceStatus::Deregistering,
            "DRAINING" => ContainerInstanceStatus::Draining,
            "REGISTERING" => ContainerInstanceStatus::Registering,
            "REGISTRATION_FAILED" => ContainerInstanceStatus::RegistrationFailed,
            other => ContainerInstanceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContainerInstanceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContainerInstanceStatus::from(s))
    }
}
impl ContainerInstanceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContainerInstanceStatus::Active => "ACTIVE",
            ContainerInstanceStatus::Deregistering => "DEREGISTERING",
            ContainerInstanceStatus::Draining => "DRAINING",
            ContainerInstanceStatus::Registering => "REGISTERING",
            ContainerInstanceStatus::RegistrationFailed => "REGISTRATION_FAILED",
            ContainerInstanceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "DEREGISTERING",
            "DRAINING",
            "REGISTERING",
            "REGISTRATION_FAILED",
        ]
    }
}
impl AsRef<str> for ContainerInstanceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A regional grouping of one or more container instances on which you can run task
/// requests. Each account receives a default cluster the first time you use the Amazon ECS
/// service, but you may also create other clusters. Clusters may contain more than one
/// instance type simultaneously.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Cluster {
    /// <p>The Amazon Resource Name (ARN) that identifies the cluster. The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the cluster, the Amazon Web Services account ID of the cluster owner, the <code>cluster</code> namespace, and then the cluster name. For example, <code>arn:aws:ecs:region:012345678910:cluster/test</code>.</p>
    pub cluster_arn: std::option::Option<std::string::String>,
    /// <p>A user-generated string that you use to identify your cluster.</p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The execute command configuration for the cluster.</p>
    pub configuration: std::option::Option<crate::model::ClusterConfiguration>,
    /// <p>The status of the cluster. The following are the possible states that will be
    /// returned.</p>
    /// <dl>
    /// <dt>ACTIVE</dt>
    /// <dd>
    /// <p>The cluster is ready to accept tasks and if applicable you can register
    /// container instances with the cluster.</p>
    /// </dd>
    /// <dt>PROVISIONING</dt>
    /// <dd>
    /// <p>The cluster has capacity providers associated with it and the resources
    /// needed for the capacity provider are being created.</p>
    /// </dd>
    /// <dt>DEPROVISIONING</dt>
    /// <dd>
    /// <p>The cluster has capacity providers associated with it and the resources
    /// needed for the capacity provider are being deleted.</p>
    /// </dd>
    /// <dt>FAILED</dt>
    /// <dd>
    /// <p>The cluster has capacity providers associated with it and the resources
    /// needed for the capacity provider have failed to create.</p>
    /// </dd>
    /// <dt>INACTIVE</dt>
    /// <dd>
    /// <p>The cluster has been deleted. Clusters with an <code>INACTIVE</code>
    /// status may remain discoverable in your account for a period of time.
    /// However, this behavior is subject to change in the future, so you should not
    /// rely on <code>INACTIVE</code> clusters persisting.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<std::string::String>,
    /// <p>The number of container instances registered into the cluster. This includes container
    /// instances in both <code>ACTIVE</code> and <code>DRAINING</code> status.</p>
    pub registered_container_instances_count: i32,
    /// <p>The number of tasks in the cluster that are in the <code>RUNNING</code> state.</p>
    pub running_tasks_count: i32,
    /// <p>The number of tasks in the cluster that are in the <code>PENDING</code> state.</p>
    pub pending_tasks_count: i32,
    /// <p>The number of services that are running on the cluster in an <code>ACTIVE</code>
    /// state. You can view these services with <a>ListServices</a>.</p>
    pub active_services_count: i32,
    /// <p>Additional information about your clusters that are separated by launch type,
    /// including:</p>
    /// <ul>
    /// <li>
    /// <p>runningEC2TasksCount</p>
    /// </li>
    /// <li>
    /// <p>RunningFargateTasksCount</p>
    /// </li>
    /// <li>
    /// <p>pendingEC2TasksCount</p>
    /// </li>
    /// <li>
    /// <p>pendingFargateTasksCount</p>
    /// </li>
    /// <li>
    /// <p>activeEC2ServiceCount</p>
    /// </li>
    /// <li>
    /// <p>activeFargateServiceCount</p>
    /// </li>
    /// <li>
    /// <p>drainingEC2ServiceCount</p>
    /// </li>
    /// <li>
    /// <p>drainingFargateServiceCount</p>
    /// </li>
    /// </ul>
    pub statistics: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
    /// <p>The metadata that you apply to the cluster to help you categorize and organize them.
    /// Each tag consists of a key and an optional value, both of which you define.</p>
    /// <p>The following basic restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of tags per resource - 50</p>
    /// </li>
    /// <li>
    /// <p>For each resource, each tag key must be unique, and each tag key can have only
    /// one value.</p>
    /// </li>
    /// <li>
    /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>If your tagging schema is used across multiple services and resources,
    /// remember that other services may have restrictions on allowed characters.
    /// Generally allowed characters are: letters, numbers, and spaces representable in
    /// UTF-8, and the following characters: + - = . _ : / @.</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
    /// combination of such as a prefix for either keys or values as it is reserved for
    /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
    /// this prefix do not count against your tags per resource limit.</p>
    /// </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The settings for the cluster. This parameter indicates whether CloudWatch Container Insights
    /// is enabled or disabled for a cluster.</p>
    pub settings: std::option::Option<std::vec::Vec<crate::model::ClusterSetting>>,
    /// <p>The capacity providers associated with the cluster.</p>
    pub capacity_providers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The default capacity provider strategy for the cluster. When services or tasks are run
    /// in the cluster with no launch type or capacity provider strategy specified, the default
    /// capacity provider strategy is used.</p>
    pub default_capacity_provider_strategy:
        std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
    /// <p>The resources attached to a cluster. When using a capacity provider with a cluster,
    /// the Auto Scaling plan that is created will be returned as a cluster attachment.</p>
    pub attachments: std::option::Option<std::vec::Vec<crate::model::Attachment>>,
    /// <p>The status of the capacity providers associated with the cluster. The following are
    /// the states that will be returned:</p>
    /// <dl>
    /// <dt>UPDATE_IN_PROGRESS</dt>
    /// <dd>
    /// <p>The available capacity providers for the cluster are updating. This occurs
    /// when the Auto Scaling plan is provisioning or deprovisioning.</p>
    /// </dd>
    /// <dt>UPDATE_COMPLETE</dt>
    /// <dd>
    /// <p>The capacity providers have successfully updated.</p>
    /// </dd>
    /// <dt>UPDATE_FAILED</dt>
    /// <dd>
    /// <p>The capacity provider updates failed.</p>
    /// </dd>
    /// </dl>
    pub attachments_status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Cluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Cluster");
        formatter.field("cluster_arn", &self.cluster_arn);
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("configuration", &self.configuration);
        formatter.field("status", &self.status);
        formatter.field(
            "registered_container_instances_count",
            &self.registered_container_instances_count,
        );
        formatter.field("running_tasks_count", &self.running_tasks_count);
        formatter.field("pending_tasks_count", &self.pending_tasks_count);
        formatter.field("active_services_count", &self.active_services_count);
        formatter.field("statistics", &self.statistics);
        formatter.field("tags", &self.tags);
        formatter.field("settings", &self.settings);
        formatter.field("capacity_providers", &self.capacity_providers);
        formatter.field(
            "default_capacity_provider_strategy",
            &self.default_capacity_provider_strategy,
        );
        formatter.field("attachments", &self.attachments);
        formatter.field("attachments_status", &self.attachments_status);
        formatter.finish()
    }
}
/// See [`Cluster`](crate::model::Cluster)
pub mod cluster {
    /// A builder for [`Cluster`](crate::model::Cluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_arn: std::option::Option<std::string::String>,
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::ClusterConfiguration>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) registered_container_instances_count: std::option::Option<i32>,
        pub(crate) running_tasks_count: std::option::Option<i32>,
        pub(crate) pending_tasks_count: std::option::Option<i32>,
        pub(crate) active_services_count: std::option::Option<i32>,
        pub(crate) statistics: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) settings: std::option::Option<std::vec::Vec<crate::model::ClusterSetting>>,
        pub(crate) capacity_providers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) default_capacity_provider_strategy:
            std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        pub(crate) attachments: std::option::Option<std::vec::Vec<crate::model::Attachment>>,
        pub(crate) attachments_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the cluster. The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the cluster, the Amazon Web Services account ID of the cluster owner, the <code>cluster</code> namespace, and then the cluster name. For example, <code>arn:aws:ecs:region:012345678910:cluster/test</code>.</p>
        pub fn cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the cluster. The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the cluster, the Amazon Web Services account ID of the cluster owner, the <code>cluster</code> namespace, and then the cluster name. For example, <code>arn:aws:ecs:region:012345678910:cluster/test</code>.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_arn = input;
            self
        }
        /// <p>A user-generated string that you use to identify your cluster.</p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>A user-generated string that you use to identify your cluster.</p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// <p>The execute command configuration for the cluster.</p>
        pub fn configuration(mut self, input: crate::model::ClusterConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The execute command configuration for the cluster.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ClusterConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The status of the cluster. The following are the possible states that will be
        /// returned.</p>
        /// <dl>
        /// <dt>ACTIVE</dt>
        /// <dd>
        /// <p>The cluster is ready to accept tasks and if applicable you can register
        /// container instances with the cluster.</p>
        /// </dd>
        /// <dt>PROVISIONING</dt>
        /// <dd>
        /// <p>The cluster has capacity providers associated with it and the resources
        /// needed for the capacity provider are being created.</p>
        /// </dd>
        /// <dt>DEPROVISIONING</dt>
        /// <dd>
        /// <p>The cluster has capacity providers associated with it and the resources
        /// needed for the capacity provider are being deleted.</p>
        /// </dd>
        /// <dt>FAILED</dt>
        /// <dd>
        /// <p>The cluster has capacity providers associated with it and the resources
        /// needed for the capacity provider have failed to create.</p>
        /// </dd>
        /// <dt>INACTIVE</dt>
        /// <dd>
        /// <p>The cluster has been deleted. Clusters with an <code>INACTIVE</code>
        /// status may remain discoverable in your account for a period of time.
        /// However, this behavior is subject to change in the future, so you should not
        /// rely on <code>INACTIVE</code> clusters persisting.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the cluster. The following are the possible states that will be
        /// returned.</p>
        /// <dl>
        /// <dt>ACTIVE</dt>
        /// <dd>
        /// <p>The cluster is ready to accept tasks and if applicable you can register
        /// container instances with the cluster.</p>
        /// </dd>
        /// <dt>PROVISIONING</dt>
        /// <dd>
        /// <p>The cluster has capacity providers associated with it and the resources
        /// needed for the capacity provider are being created.</p>
        /// </dd>
        /// <dt>DEPROVISIONING</dt>
        /// <dd>
        /// <p>The cluster has capacity providers associated with it and the resources
        /// needed for the capacity provider are being deleted.</p>
        /// </dd>
        /// <dt>FAILED</dt>
        /// <dd>
        /// <p>The cluster has capacity providers associated with it and the resources
        /// needed for the capacity provider have failed to create.</p>
        /// </dd>
        /// <dt>INACTIVE</dt>
        /// <dd>
        /// <p>The cluster has been deleted. Clusters with an <code>INACTIVE</code>
        /// status may remain discoverable in your account for a period of time.
        /// However, this behavior is subject to change in the future, so you should not
        /// rely on <code>INACTIVE</code> clusters persisting.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The number of container instances registered into the cluster. This includes container
        /// instances in both <code>ACTIVE</code> and <code>DRAINING</code> status.</p>
        pub fn registered_container_instances_count(mut self, input: i32) -> Self {
            self.registered_container_instances_count = Some(input);
            self
        }
        /// <p>The number of container instances registered into the cluster. This includes container
        /// instances in both <code>ACTIVE</code> and <code>DRAINING</code> status.</p>
        pub fn set_registered_container_instances_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.registered_container_instances_count = input;
            self
        }
        /// <p>The number of tasks in the cluster that are in the <code>RUNNING</code> state.</p>
        pub fn running_tasks_count(mut self, input: i32) -> Self {
            self.running_tasks_count = Some(input);
            self
        }
        /// <p>The number of tasks in the cluster that are in the <code>RUNNING</code> state.</p>
        pub fn set_running_tasks_count(mut self, input: std::option::Option<i32>) -> Self {
            self.running_tasks_count = input;
            self
        }
        /// <p>The number of tasks in the cluster that are in the <code>PENDING</code> state.</p>
        pub fn pending_tasks_count(mut self, input: i32) -> Self {
            self.pending_tasks_count = Some(input);
            self
        }
        /// <p>The number of tasks in the cluster that are in the <code>PENDING</code> state.</p>
        pub fn set_pending_tasks_count(mut self, input: std::option::Option<i32>) -> Self {
            self.pending_tasks_count = input;
            self
        }
        /// <p>The number of services that are running on the cluster in an <code>ACTIVE</code>
        /// state. You can view these services with <a>ListServices</a>.</p>
        pub fn active_services_count(mut self, input: i32) -> Self {
            self.active_services_count = Some(input);
            self
        }
        /// <p>The number of services that are running on the cluster in an <code>ACTIVE</code>
        /// state. You can view these services with <a>ListServices</a>.</p>
        pub fn set_active_services_count(mut self, input: std::option::Option<i32>) -> Self {
            self.active_services_count = input;
            self
        }
        /// Appends an item to `statistics`.
        ///
        /// To override the contents of this collection use [`set_statistics`](Self::set_statistics).
        ///
        /// <p>Additional information about your clusters that are separated by launch type,
        /// including:</p>
        /// <ul>
        /// <li>
        /// <p>runningEC2TasksCount</p>
        /// </li>
        /// <li>
        /// <p>RunningFargateTasksCount</p>
        /// </li>
        /// <li>
        /// <p>pendingEC2TasksCount</p>
        /// </li>
        /// <li>
        /// <p>pendingFargateTasksCount</p>
        /// </li>
        /// <li>
        /// <p>activeEC2ServiceCount</p>
        /// </li>
        /// <li>
        /// <p>activeFargateServiceCount</p>
        /// </li>
        /// <li>
        /// <p>drainingEC2ServiceCount</p>
        /// </li>
        /// <li>
        /// <p>drainingFargateServiceCount</p>
        /// </li>
        /// </ul>
        pub fn statistics(mut self, input: impl Into<crate::model::KeyValuePair>) -> Self {
            let mut v = self.statistics.unwrap_or_default();
            v.push(input.into());
            self.statistics = Some(v);
            self
        }
        /// <p>Additional information about your clusters that are separated by launch type,
        /// including:</p>
        /// <ul>
        /// <li>
        /// <p>runningEC2TasksCount</p>
        /// </li>
        /// <li>
        /// <p>RunningFargateTasksCount</p>
        /// </li>
        /// <li>
        /// <p>pendingEC2TasksCount</p>
        /// </li>
        /// <li>
        /// <p>pendingFargateTasksCount</p>
        /// </li>
        /// <li>
        /// <p>activeEC2ServiceCount</p>
        /// </li>
        /// <li>
        /// <p>activeFargateServiceCount</p>
        /// </li>
        /// <li>
        /// <p>drainingEC2ServiceCount</p>
        /// </li>
        /// <li>
        /// <p>drainingFargateServiceCount</p>
        /// </li>
        /// </ul>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
        ) -> Self {
            self.statistics = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the cluster to help you categorize and organize them.
        /// Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The metadata that you apply to the cluster to help you categorize and organize them.
        /// Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `settings`.
        ///
        /// To override the contents of this collection use [`set_settings`](Self::set_settings).
        ///
        /// <p>The settings for the cluster. This parameter indicates whether CloudWatch Container Insights
        /// is enabled or disabled for a cluster.</p>
        pub fn settings(mut self, input: impl Into<crate::model::ClusterSetting>) -> Self {
            let mut v = self.settings.unwrap_or_default();
            v.push(input.into());
            self.settings = Some(v);
            self
        }
        /// <p>The settings for the cluster. This parameter indicates whether CloudWatch Container Insights
        /// is enabled or disabled for a cluster.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterSetting>>,
        ) -> Self {
            self.settings = input;
            self
        }
        /// Appends an item to `capacity_providers`.
        ///
        /// To override the contents of this collection use [`set_capacity_providers`](Self::set_capacity_providers).
        ///
        /// <p>The capacity providers associated with the cluster.</p>
        pub fn capacity_providers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.capacity_providers.unwrap_or_default();
            v.push(input.into());
            self.capacity_providers = Some(v);
            self
        }
        /// <p>The capacity providers associated with the cluster.</p>
        pub fn set_capacity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.capacity_providers = input;
            self
        }
        /// Appends an item to `default_capacity_provider_strategy`.
        ///
        /// To override the contents of this collection use [`set_default_capacity_provider_strategy`](Self::set_default_capacity_provider_strategy).
        ///
        /// <p>The default capacity provider strategy for the cluster. When services or tasks are run
        /// in the cluster with no launch type or capacity provider strategy specified, the default
        /// capacity provider strategy is used.</p>
        pub fn default_capacity_provider_strategy(
            mut self,
            input: impl Into<crate::model::CapacityProviderStrategyItem>,
        ) -> Self {
            let mut v = self.default_capacity_provider_strategy.unwrap_or_default();
            v.push(input.into());
            self.default_capacity_provider_strategy = Some(v);
            self
        }
        /// <p>The default capacity provider strategy for the cluster. When services or tasks are run
        /// in the cluster with no launch type or capacity provider strategy specified, the default
        /// capacity provider strategy is used.</p>
        pub fn set_default_capacity_provider_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        ) -> Self {
            self.default_capacity_provider_strategy = input;
            self
        }
        /// Appends an item to `attachments`.
        ///
        /// To override the contents of this collection use [`set_attachments`](Self::set_attachments).
        ///
        /// <p>The resources attached to a cluster. When using a capacity provider with a cluster,
        /// the Auto Scaling plan that is created will be returned as a cluster attachment.</p>
        pub fn attachments(mut self, input: impl Into<crate::model::Attachment>) -> Self {
            let mut v = self.attachments.unwrap_or_default();
            v.push(input.into());
            self.attachments = Some(v);
            self
        }
        /// <p>The resources attached to a cluster. When using a capacity provider with a cluster,
        /// the Auto Scaling plan that is created will be returned as a cluster attachment.</p>
        pub fn set_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attachment>>,
        ) -> Self {
            self.attachments = input;
            self
        }
        /// <p>The status of the capacity providers associated with the cluster. The following are
        /// the states that will be returned:</p>
        /// <dl>
        /// <dt>UPDATE_IN_PROGRESS</dt>
        /// <dd>
        /// <p>The available capacity providers for the cluster are updating. This occurs
        /// when the Auto Scaling plan is provisioning or deprovisioning.</p>
        /// </dd>
        /// <dt>UPDATE_COMPLETE</dt>
        /// <dd>
        /// <p>The capacity providers have successfully updated.</p>
        /// </dd>
        /// <dt>UPDATE_FAILED</dt>
        /// <dd>
        /// <p>The capacity provider updates failed.</p>
        /// </dd>
        /// </dl>
        pub fn attachments_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.attachments_status = Some(input.into());
            self
        }
        /// <p>The status of the capacity providers associated with the cluster. The following are
        /// the states that will be returned:</p>
        /// <dl>
        /// <dt>UPDATE_IN_PROGRESS</dt>
        /// <dd>
        /// <p>The available capacity providers for the cluster are updating. This occurs
        /// when the Auto Scaling plan is provisioning or deprovisioning.</p>
        /// </dd>
        /// <dt>UPDATE_COMPLETE</dt>
        /// <dd>
        /// <p>The capacity providers have successfully updated.</p>
        /// </dd>
        /// <dt>UPDATE_FAILED</dt>
        /// <dd>
        /// <p>The capacity provider updates failed.</p>
        /// </dd>
        /// </dl>
        pub fn set_attachments_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attachments_status = input;
            self
        }
        /// Consumes the builder and constructs a [`Cluster`](crate::model::Cluster)
        pub fn build(self) -> crate::model::Cluster {
            crate::model::Cluster {
                cluster_arn: self.cluster_arn,
                cluster_name: self.cluster_name,
                configuration: self.configuration,
                status: self.status,
                registered_container_instances_count: self
                    .registered_container_instances_count
                    .unwrap_or_default(),
                running_tasks_count: self.running_tasks_count.unwrap_or_default(),
                pending_tasks_count: self.pending_tasks_count.unwrap_or_default(),
                active_services_count: self.active_services_count.unwrap_or_default(),
                statistics: self.statistics,
                tags: self.tags,
                settings: self.settings,
                capacity_providers: self.capacity_providers,
                default_capacity_provider_strategy: self.default_capacity_provider_strategy,
                attachments: self.attachments,
                attachments_status: self.attachments_status,
            }
        }
    }
}
impl Cluster {
    /// Creates a new builder-style object to manufacture [`Cluster`](crate::model::Cluster)
    pub fn builder() -> crate::model::cluster::Builder {
        crate::model::cluster::Builder::default()
    }
}

/// <p>The settings to use when creating a cluster. This parameter is used to enable CloudWatch
/// Container Insights for a cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterSetting {
    /// <p>The name of the cluster setting. The only supported value is
    /// <code>containerInsights</code>.</p>
    pub name: std::option::Option<crate::model::ClusterSettingName>,
    /// <p>The value to set for the cluster setting. The supported values are
    /// <code>enabled</code> and <code>disabled</code>. If <code>enabled</code> is
    /// specified, CloudWatch Container Insights will be enabled for the cluster, otherwise it will be
    /// disabled unless the <code>containerInsights</code> account setting is enabled. If a
    /// cluster value is specified, it will override the <code>containerInsights</code> value
    /// set with <a>PutAccountSetting</a> or <a>PutAccountSettingDefault</a>.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterSetting");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ClusterSetting`](crate::model::ClusterSetting)
pub mod cluster_setting {
    /// A builder for [`ClusterSetting`](crate::model::ClusterSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::ClusterSettingName>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cluster setting. The only supported value is
        /// <code>containerInsights</code>.</p>
        pub fn name(mut self, input: crate::model::ClusterSettingName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the cluster setting. The only supported value is
        /// <code>containerInsights</code>.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::ClusterSettingName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The value to set for the cluster setting. The supported values are
        /// <code>enabled</code> and <code>disabled</code>. If <code>enabled</code> is
        /// specified, CloudWatch Container Insights will be enabled for the cluster, otherwise it will be
        /// disabled unless the <code>containerInsights</code> account setting is enabled. If a
        /// cluster value is specified, it will override the <code>containerInsights</code> value
        /// set with <a>PutAccountSetting</a> or <a>PutAccountSettingDefault</a>.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value to set for the cluster setting. The supported values are
        /// <code>enabled</code> and <code>disabled</code>. If <code>enabled</code> is
        /// specified, CloudWatch Container Insights will be enabled for the cluster, otherwise it will be
        /// disabled unless the <code>containerInsights</code> account setting is enabled. If a
        /// cluster value is specified, it will override the <code>containerInsights</code> value
        /// set with <a>PutAccountSetting</a> or <a>PutAccountSettingDefault</a>.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterSetting`](crate::model::ClusterSetting)
        pub fn build(self) -> crate::model::ClusterSetting {
            crate::model::ClusterSetting {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl ClusterSetting {
    /// Creates a new builder-style object to manufacture [`ClusterSetting`](crate::model::ClusterSetting)
    pub fn builder() -> crate::model::cluster_setting::Builder {
        crate::model::cluster_setting::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ClusterSettingName {
    #[allow(missing_docs)] // documentation missing in model
    ContainerInsights,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ClusterSettingName {
    fn from(s: &str) -> Self {
        match s {
            "containerInsights" => ClusterSettingName::ContainerInsights,
            other => ClusterSettingName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ClusterSettingName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ClusterSettingName::from(s))
    }
}
impl ClusterSettingName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ClusterSettingName::ContainerInsights => "containerInsights",
            ClusterSettingName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["containerInsights"]
    }
}
impl AsRef<str> for ClusterSettingName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The execute command configuration for the cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterConfiguration {
    /// <p>The details of the execute command configuration.</p>
    pub execute_command_configuration:
        std::option::Option<crate::model::ExecuteCommandConfiguration>,
}
impl std::fmt::Debug for ClusterConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterConfiguration");
        formatter.field(
            "execute_command_configuration",
            &self.execute_command_configuration,
        );
        formatter.finish()
    }
}
/// See [`ClusterConfiguration`](crate::model::ClusterConfiguration)
pub mod cluster_configuration {
    /// A builder for [`ClusterConfiguration`](crate::model::ClusterConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execute_command_configuration:
            std::option::Option<crate::model::ExecuteCommandConfiguration>,
    }
    impl Builder {
        /// <p>The details of the execute command configuration.</p>
        pub fn execute_command_configuration(
            mut self,
            input: crate::model::ExecuteCommandConfiguration,
        ) -> Self {
            self.execute_command_configuration = Some(input);
            self
        }
        /// <p>The details of the execute command configuration.</p>
        pub fn set_execute_command_configuration(
            mut self,
            input: std::option::Option<crate::model::ExecuteCommandConfiguration>,
        ) -> Self {
            self.execute_command_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterConfiguration`](crate::model::ClusterConfiguration)
        pub fn build(self) -> crate::model::ClusterConfiguration {
            crate::model::ClusterConfiguration {
                execute_command_configuration: self.execute_command_configuration,
            }
        }
    }
}
impl ClusterConfiguration {
    /// Creates a new builder-style object to manufacture [`ClusterConfiguration`](crate::model::ClusterConfiguration)
    pub fn builder() -> crate::model::cluster_configuration::Builder {
        crate::model::cluster_configuration::Builder::default()
    }
}

/// <p>The details of the execute command configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteCommandConfiguration {
    /// <p>Specify an Key Management Service key ID to encrypt the data between the local client
    /// and the container.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The log setting to use for redirecting logs for your execute command results. The
    /// following log settings are available.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code>: The execute command session is not logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DEFAULT</code>: The <code>awslogs</code> configuration in the task
    /// definition is used. If no logging parameter is specified, it defaults to this
    /// value. If no <code>awslogs</code> log driver is configured in the task
    /// definition, the output won't be logged.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OVERRIDE</code>: Specify the logging details as a part of
    /// <code>logConfiguration</code>. If the <code>OVERRIDE</code> logging option
    /// is specified, the <code>logConfiguration</code> is required.</p>
    /// </li>
    /// </ul>
    pub logging: std::option::Option<crate::model::ExecuteCommandLogging>,
    /// <p>The log configuration for the results of the execute command actions. The logs can be
    /// sent to CloudWatch Logs or an Amazon S3 bucket. When <code>logging=OVERRIDE</code> is
    /// specified, a <code>logConfiguration</code> must be provided.</p>
    pub log_configuration: std::option::Option<crate::model::ExecuteCommandLogConfiguration>,
}
impl std::fmt::Debug for ExecuteCommandConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteCommandConfiguration");
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("logging", &self.logging);
        formatter.field("log_configuration", &self.log_configuration);
        formatter.finish()
    }
}
/// See [`ExecuteCommandConfiguration`](crate::model::ExecuteCommandConfiguration)
pub mod execute_command_configuration {
    /// A builder for [`ExecuteCommandConfiguration`](crate::model::ExecuteCommandConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) logging: std::option::Option<crate::model::ExecuteCommandLogging>,
        pub(crate) log_configuration:
            std::option::Option<crate::model::ExecuteCommandLogConfiguration>,
    }
    impl Builder {
        /// <p>Specify an Key Management Service key ID to encrypt the data between the local client
        /// and the container.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>Specify an Key Management Service key ID to encrypt the data between the local client
        /// and the container.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The log setting to use for redirecting logs for your execute command results. The
        /// following log settings are available.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code>: The execute command session is not logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DEFAULT</code>: The <code>awslogs</code> configuration in the task
        /// definition is used. If no logging parameter is specified, it defaults to this
        /// value. If no <code>awslogs</code> log driver is configured in the task
        /// definition, the output won't be logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OVERRIDE</code>: Specify the logging details as a part of
        /// <code>logConfiguration</code>. If the <code>OVERRIDE</code> logging option
        /// is specified, the <code>logConfiguration</code> is required.</p>
        /// </li>
        /// </ul>
        pub fn logging(mut self, input: crate::model::ExecuteCommandLogging) -> Self {
            self.logging = Some(input);
            self
        }
        /// <p>The log setting to use for redirecting logs for your execute command results. The
        /// following log settings are available.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code>: The execute command session is not logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DEFAULT</code>: The <code>awslogs</code> configuration in the task
        /// definition is used. If no logging parameter is specified, it defaults to this
        /// value. If no <code>awslogs</code> log driver is configured in the task
        /// definition, the output won't be logged.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OVERRIDE</code>: Specify the logging details as a part of
        /// <code>logConfiguration</code>. If the <code>OVERRIDE</code> logging option
        /// is specified, the <code>logConfiguration</code> is required.</p>
        /// </li>
        /// </ul>
        pub fn set_logging(
            mut self,
            input: std::option::Option<crate::model::ExecuteCommandLogging>,
        ) -> Self {
            self.logging = input;
            self
        }
        /// <p>The log configuration for the results of the execute command actions. The logs can be
        /// sent to CloudWatch Logs or an Amazon S3 bucket. When <code>logging=OVERRIDE</code> is
        /// specified, a <code>logConfiguration</code> must be provided.</p>
        pub fn log_configuration(
            mut self,
            input: crate::model::ExecuteCommandLogConfiguration,
        ) -> Self {
            self.log_configuration = Some(input);
            self
        }
        /// <p>The log configuration for the results of the execute command actions. The logs can be
        /// sent to CloudWatch Logs or an Amazon S3 bucket. When <code>logging=OVERRIDE</code> is
        /// specified, a <code>logConfiguration</code> must be provided.</p>
        pub fn set_log_configuration(
            mut self,
            input: std::option::Option<crate::model::ExecuteCommandLogConfiguration>,
        ) -> Self {
            self.log_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteCommandConfiguration`](crate::model::ExecuteCommandConfiguration)
        pub fn build(self) -> crate::model::ExecuteCommandConfiguration {
            crate::model::ExecuteCommandConfiguration {
                kms_key_id: self.kms_key_id,
                logging: self.logging,
                log_configuration: self.log_configuration,
            }
        }
    }
}
impl ExecuteCommandConfiguration {
    /// Creates a new builder-style object to manufacture [`ExecuteCommandConfiguration`](crate::model::ExecuteCommandConfiguration)
    pub fn builder() -> crate::model::execute_command_configuration::Builder {
        crate::model::execute_command_configuration::Builder::default()
    }
}

/// <p>The log configuration for the results of the execute command actions. The logs can be
/// sent to CloudWatch Logs or an Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteCommandLogConfiguration {
    /// <p>The name of the CloudWatch log group to send logs to.</p>
    /// <note>
    /// <p>The CloudWatch log group must already be created.</p>
    /// </note>
    pub cloud_watch_log_group_name: std::option::Option<std::string::String>,
    /// <p>Whether or not to enable encryption on the CloudWatch logs. If not specified,
    /// encryption will be disabled.</p>
    pub cloud_watch_encryption_enabled: bool,
    /// <p>The name of the S3 bucket to send logs to.</p>
    /// <note>
    /// <p>The S3 bucket must already be created.</p>
    /// </note>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>Whether or not to use encryption on the S3 logs. If not specified,
    /// encryption is not used.</p>
    pub s3_encryption_enabled: bool,
    /// <p>An optional folder in the S3 bucket to place logs in.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExecuteCommandLogConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteCommandLogConfiguration");
        formatter.field(
            "cloud_watch_log_group_name",
            &self.cloud_watch_log_group_name,
        );
        formatter.field(
            "cloud_watch_encryption_enabled",
            &self.cloud_watch_encryption_enabled,
        );
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_encryption_enabled", &self.s3_encryption_enabled);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.finish()
    }
}
/// See [`ExecuteCommandLogConfiguration`](crate::model::ExecuteCommandLogConfiguration)
pub mod execute_command_log_configuration {
    /// A builder for [`ExecuteCommandLogConfiguration`](crate::model::ExecuteCommandLogConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_log_group_name: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_encryption_enabled: std::option::Option<bool>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_encryption_enabled: std::option::Option<bool>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the CloudWatch log group to send logs to.</p>
        /// <note>
        /// <p>The CloudWatch log group must already be created.</p>
        /// </note>
        pub fn cloud_watch_log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_log_group_name = Some(input.into());
            self
        }
        /// <p>The name of the CloudWatch log group to send logs to.</p>
        /// <note>
        /// <p>The CloudWatch log group must already be created.</p>
        /// </note>
        pub fn set_cloud_watch_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_log_group_name = input;
            self
        }
        /// <p>Whether or not to enable encryption on the CloudWatch logs. If not specified,
        /// encryption will be disabled.</p>
        pub fn cloud_watch_encryption_enabled(mut self, input: bool) -> Self {
            self.cloud_watch_encryption_enabled = Some(input);
            self
        }
        /// <p>Whether or not to enable encryption on the CloudWatch logs. If not specified,
        /// encryption will be disabled.</p>
        pub fn set_cloud_watch_encryption_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.cloud_watch_encryption_enabled = input;
            self
        }
        /// <p>The name of the S3 bucket to send logs to.</p>
        /// <note>
        /// <p>The S3 bucket must already be created.</p>
        /// </note>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket to send logs to.</p>
        /// <note>
        /// <p>The S3 bucket must already be created.</p>
        /// </note>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>Whether or not to use encryption on the S3 logs. If not specified,
        /// encryption is not used.</p>
        pub fn s3_encryption_enabled(mut self, input: bool) -> Self {
            self.s3_encryption_enabled = Some(input);
            self
        }
        /// <p>Whether or not to use encryption on the S3 logs. If not specified,
        /// encryption is not used.</p>
        pub fn set_s3_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.s3_encryption_enabled = input;
            self
        }
        /// <p>An optional folder in the S3 bucket to place logs in.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>An optional folder in the S3 bucket to place logs in.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteCommandLogConfiguration`](crate::model::ExecuteCommandLogConfiguration)
        pub fn build(self) -> crate::model::ExecuteCommandLogConfiguration {
            crate::model::ExecuteCommandLogConfiguration {
                cloud_watch_log_group_name: self.cloud_watch_log_group_name,
                cloud_watch_encryption_enabled: self
                    .cloud_watch_encryption_enabled
                    .unwrap_or_default(),
                s3_bucket_name: self.s3_bucket_name,
                s3_encryption_enabled: self.s3_encryption_enabled.unwrap_or_default(),
                s3_key_prefix: self.s3_key_prefix,
            }
        }
    }
}
impl ExecuteCommandLogConfiguration {
    /// Creates a new builder-style object to manufacture [`ExecuteCommandLogConfiguration`](crate::model::ExecuteCommandLogConfiguration)
    pub fn builder() -> crate::model::execute_command_log_configuration::Builder {
        crate::model::execute_command_log_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExecuteCommandLogging {
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Override,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExecuteCommandLogging {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT" => ExecuteCommandLogging::Default,
            "NONE" => ExecuteCommandLogging::None,
            "OVERRIDE" => ExecuteCommandLogging::Override,
            other => ExecuteCommandLogging::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExecuteCommandLogging {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExecuteCommandLogging::from(s))
    }
}
impl ExecuteCommandLogging {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExecuteCommandLogging::Default => "DEFAULT",
            ExecuteCommandLogging::None => "NONE",
            ExecuteCommandLogging::Override => "OVERRIDE",
            ExecuteCommandLogging::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEFAULT", "NONE", "OVERRIDE"]
    }
}
impl AsRef<str> for ExecuteCommandLogging {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details of a capacity provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CapacityProvider {
    /// <p>The Amazon Resource Name (ARN) that identifies the capacity provider.</p>
    pub capacity_provider_arn: std::option::Option<std::string::String>,
    /// <p>The name of the capacity provider.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current status of the capacity provider. Only capacity providers in an
    /// <code>ACTIVE</code> state can be used in a cluster. When a capacity provider is
    /// successfully deleted, it will have an <code>INACTIVE</code> status.</p>
    pub status: std::option::Option<crate::model::CapacityProviderStatus>,
    /// <p>The Auto Scaling group settings for the capacity provider.</p>
    pub auto_scaling_group_provider: std::option::Option<crate::model::AutoScalingGroupProvider>,
    /// <p>The update status of the capacity provider. The following are the possible states that
    /// will be returned.</p>
    /// <dl>
    /// <dt>DELETE_IN_PROGRESS</dt>
    /// <dd>
    /// <p>The capacity provider is in the process of being deleted.</p>
    /// </dd>
    /// <dt>DELETE_COMPLETE</dt>
    /// <dd>
    /// <p>The capacity provider has been successfully deleted and will have an
    /// <code>INACTIVE</code> status.</p>
    /// </dd>
    /// <dt>DELETE_FAILED</dt>
    /// <dd>
    /// <p>The capacity provider was unable to be deleted. The update status reason
    /// will provide further details about why the delete failed.</p>
    /// </dd>
    /// </dl>
    pub update_status: std::option::Option<crate::model::CapacityProviderUpdateStatus>,
    /// <p>The update status reason. This provides further details about the update status for
    /// the capacity provider.</p>
    pub update_status_reason: std::option::Option<std::string::String>,
    /// <p>The metadata that you apply to the capacity provider to help you categorize and
    /// organize it. Each tag consists of a key and an optional value, both of which you
    /// define.</p>
    /// <p>The following basic restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of tags per resource - 50</p>
    /// </li>
    /// <li>
    /// <p>For each resource, each tag key must be unique, and each tag key can have only
    /// one value.</p>
    /// </li>
    /// <li>
    /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>If your tagging schema is used across multiple services and resources,
    /// remember that other services may have restrictions on allowed characters.
    /// Generally allowed characters are: letters, numbers, and spaces representable in
    /// UTF-8, and the following characters: + - = . _ : / @.</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
    /// combination of such as a prefix for either keys or values as it is reserved for
    /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
    /// this prefix do not count against your tags per resource limit.</p>
    /// </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CapacityProvider {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CapacityProvider");
        formatter.field("capacity_provider_arn", &self.capacity_provider_arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field(
            "auto_scaling_group_provider",
            &self.auto_scaling_group_provider,
        );
        formatter.field("update_status", &self.update_status);
        formatter.field("update_status_reason", &self.update_status_reason);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CapacityProvider`](crate::model::CapacityProvider)
pub mod capacity_provider {
    /// A builder for [`CapacityProvider`](crate::model::CapacityProvider)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity_provider_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::CapacityProviderStatus>,
        pub(crate) auto_scaling_group_provider:
            std::option::Option<crate::model::AutoScalingGroupProvider>,
        pub(crate) update_status: std::option::Option<crate::model::CapacityProviderUpdateStatus>,
        pub(crate) update_status_reason: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the capacity provider.</p>
        pub fn capacity_provider_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.capacity_provider_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the capacity provider.</p>
        pub fn set_capacity_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capacity_provider_arn = input;
            self
        }
        /// <p>The name of the capacity provider.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the capacity provider.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current status of the capacity provider. Only capacity providers in an
        /// <code>ACTIVE</code> state can be used in a cluster. When a capacity provider is
        /// successfully deleted, it will have an <code>INACTIVE</code> status.</p>
        pub fn status(mut self, input: crate::model::CapacityProviderStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the capacity provider. Only capacity providers in an
        /// <code>ACTIVE</code> state can be used in a cluster. When a capacity provider is
        /// successfully deleted, it will have an <code>INACTIVE</code> status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CapacityProviderStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The Auto Scaling group settings for the capacity provider.</p>
        pub fn auto_scaling_group_provider(
            mut self,
            input: crate::model::AutoScalingGroupProvider,
        ) -> Self {
            self.auto_scaling_group_provider = Some(input);
            self
        }
        /// <p>The Auto Scaling group settings for the capacity provider.</p>
        pub fn set_auto_scaling_group_provider(
            mut self,
            input: std::option::Option<crate::model::AutoScalingGroupProvider>,
        ) -> Self {
            self.auto_scaling_group_provider = input;
            self
        }
        /// <p>The update status of the capacity provider. The following are the possible states that
        /// will be returned.</p>
        /// <dl>
        /// <dt>DELETE_IN_PROGRESS</dt>
        /// <dd>
        /// <p>The capacity provider is in the process of being deleted.</p>
        /// </dd>
        /// <dt>DELETE_COMPLETE</dt>
        /// <dd>
        /// <p>The capacity provider has been successfully deleted and will have an
        /// <code>INACTIVE</code> status.</p>
        /// </dd>
        /// <dt>DELETE_FAILED</dt>
        /// <dd>
        /// <p>The capacity provider was unable to be deleted. The update status reason
        /// will provide further details about why the delete failed.</p>
        /// </dd>
        /// </dl>
        pub fn update_status(mut self, input: crate::model::CapacityProviderUpdateStatus) -> Self {
            self.update_status = Some(input);
            self
        }
        /// <p>The update status of the capacity provider. The following are the possible states that
        /// will be returned.</p>
        /// <dl>
        /// <dt>DELETE_IN_PROGRESS</dt>
        /// <dd>
        /// <p>The capacity provider is in the process of being deleted.</p>
        /// </dd>
        /// <dt>DELETE_COMPLETE</dt>
        /// <dd>
        /// <p>The capacity provider has been successfully deleted and will have an
        /// <code>INACTIVE</code> status.</p>
        /// </dd>
        /// <dt>DELETE_FAILED</dt>
        /// <dd>
        /// <p>The capacity provider was unable to be deleted. The update status reason
        /// will provide further details about why the delete failed.</p>
        /// </dd>
        /// </dl>
        pub fn set_update_status(
            mut self,
            input: std::option::Option<crate::model::CapacityProviderUpdateStatus>,
        ) -> Self {
            self.update_status = input;
            self
        }
        /// <p>The update status reason. This provides further details about the update status for
        /// the capacity provider.</p>
        pub fn update_status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.update_status_reason = Some(input.into());
            self
        }
        /// <p>The update status reason. This provides further details about the update status for
        /// the capacity provider.</p>
        pub fn set_update_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.update_status_reason = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the capacity provider to help you categorize and
        /// organize it. Each tag consists of a key and an optional value, both of which you
        /// define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The metadata that you apply to the capacity provider to help you categorize and
        /// organize it. Each tag consists of a key and an optional value, both of which you
        /// define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CapacityProvider`](crate::model::CapacityProvider)
        pub fn build(self) -> crate::model::CapacityProvider {
            crate::model::CapacityProvider {
                capacity_provider_arn: self.capacity_provider_arn,
                name: self.name,
                status: self.status,
                auto_scaling_group_provider: self.auto_scaling_group_provider,
                update_status: self.update_status,
                update_status_reason: self.update_status_reason,
                tags: self.tags,
            }
        }
    }
}
impl CapacityProvider {
    /// Creates a new builder-style object to manufacture [`CapacityProvider`](crate::model::CapacityProvider)
    pub fn builder() -> crate::model::capacity_provider::Builder {
        crate::model::capacity_provider::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CapacityProviderUpdateStatus {
    #[allow(missing_docs)] // documentation missing in model
    DeleteComplete,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateComplete,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CapacityProviderUpdateStatus {
    fn from(s: &str) -> Self {
        match s {
            "DELETE_COMPLETE" => CapacityProviderUpdateStatus::DeleteComplete,
            "DELETE_FAILED" => CapacityProviderUpdateStatus::DeleteFailed,
            "DELETE_IN_PROGRESS" => CapacityProviderUpdateStatus::DeleteInProgress,
            "UPDATE_COMPLETE" => CapacityProviderUpdateStatus::UpdateComplete,
            "UPDATE_FAILED" => CapacityProviderUpdateStatus::UpdateFailed,
            "UPDATE_IN_PROGRESS" => CapacityProviderUpdateStatus::UpdateInProgress,
            other => CapacityProviderUpdateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CapacityProviderUpdateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CapacityProviderUpdateStatus::from(s))
    }
}
impl CapacityProviderUpdateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CapacityProviderUpdateStatus::DeleteComplete => "DELETE_COMPLETE",
            CapacityProviderUpdateStatus::DeleteFailed => "DELETE_FAILED",
            CapacityProviderUpdateStatus::DeleteInProgress => "DELETE_IN_PROGRESS",
            CapacityProviderUpdateStatus::UpdateComplete => "UPDATE_COMPLETE",
            CapacityProviderUpdateStatus::UpdateFailed => "UPDATE_FAILED",
            CapacityProviderUpdateStatus::UpdateInProgress => "UPDATE_IN_PROGRESS",
            CapacityProviderUpdateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DELETE_COMPLETE",
            "DELETE_FAILED",
            "DELETE_IN_PROGRESS",
            "UPDATE_COMPLETE",
            "UPDATE_FAILED",
            "UPDATE_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for CapacityProviderUpdateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details of the Auto Scaling group for the capacity provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingGroupProvider {
    /// <p>The Amazon Resource Name (ARN) that identifies the Auto Scaling group.</p>
    pub auto_scaling_group_arn: std::option::Option<std::string::String>,
    /// <p>The managed scaling settings for the Auto Scaling group capacity provider.</p>
    pub managed_scaling: std::option::Option<crate::model::ManagedScaling>,
    /// <p>The managed termination protection setting to use for the Auto Scaling group capacity
    /// provider. This determines whether the Auto Scaling group has managed termination
    /// protection.</p>
    /// <important>
    /// <p>When using managed termination protection, managed scaling must also be used
    /// otherwise managed termination protection will not work.</p>
    /// </important>
    /// <p>When managed termination protection is enabled, Amazon ECS prevents the Amazon EC2 instances in
    /// an Auto Scaling group that contain tasks from being terminated during a scale-in action.
    /// The Auto Scaling group and each instance in the Auto Scaling group must have instance
    /// protection from scale-in actions enabled as well. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection">Instance Protection</a> in the <i>Auto Scaling User Guide</i>.</p>
    /// <p>When managed termination protection is disabled, your Amazon EC2 instances are not
    /// protected from termination when the Auto Scaling group scales in.</p>
    pub managed_termination_protection:
        std::option::Option<crate::model::ManagedTerminationProtection>,
}
impl std::fmt::Debug for AutoScalingGroupProvider {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingGroupProvider");
        formatter.field("auto_scaling_group_arn", &self.auto_scaling_group_arn);
        formatter.field("managed_scaling", &self.managed_scaling);
        formatter.field(
            "managed_termination_protection",
            &self.managed_termination_protection,
        );
        formatter.finish()
    }
}
/// See [`AutoScalingGroupProvider`](crate::model::AutoScalingGroupProvider)
pub mod auto_scaling_group_provider {
    /// A builder for [`AutoScalingGroupProvider`](crate::model::AutoScalingGroupProvider)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_arn: std::option::Option<std::string::String>,
        pub(crate) managed_scaling: std::option::Option<crate::model::ManagedScaling>,
        pub(crate) managed_termination_protection:
            std::option::Option<crate::model::ManagedTerminationProtection>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the Auto Scaling group.</p>
        pub fn auto_scaling_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_arn = input;
            self
        }
        /// <p>The managed scaling settings for the Auto Scaling group capacity provider.</p>
        pub fn managed_scaling(mut self, input: crate::model::ManagedScaling) -> Self {
            self.managed_scaling = Some(input);
            self
        }
        /// <p>The managed scaling settings for the Auto Scaling group capacity provider.</p>
        pub fn set_managed_scaling(
            mut self,
            input: std::option::Option<crate::model::ManagedScaling>,
        ) -> Self {
            self.managed_scaling = input;
            self
        }
        /// <p>The managed termination protection setting to use for the Auto Scaling group capacity
        /// provider. This determines whether the Auto Scaling group has managed termination
        /// protection.</p>
        /// <important>
        /// <p>When using managed termination protection, managed scaling must also be used
        /// otherwise managed termination protection will not work.</p>
        /// </important>
        /// <p>When managed termination protection is enabled, Amazon ECS prevents the Amazon EC2 instances in
        /// an Auto Scaling group that contain tasks from being terminated during a scale-in action.
        /// The Auto Scaling group and each instance in the Auto Scaling group must have instance
        /// protection from scale-in actions enabled as well. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection">Instance Protection</a> in the <i>Auto Scaling User Guide</i>.</p>
        /// <p>When managed termination protection is disabled, your Amazon EC2 instances are not
        /// protected from termination when the Auto Scaling group scales in.</p>
        pub fn managed_termination_protection(
            mut self,
            input: crate::model::ManagedTerminationProtection,
        ) -> Self {
            self.managed_termination_protection = Some(input);
            self
        }
        /// <p>The managed termination protection setting to use for the Auto Scaling group capacity
        /// provider. This determines whether the Auto Scaling group has managed termination
        /// protection.</p>
        /// <important>
        /// <p>When using managed termination protection, managed scaling must also be used
        /// otherwise managed termination protection will not work.</p>
        /// </important>
        /// <p>When managed termination protection is enabled, Amazon ECS prevents the Amazon EC2 instances in
        /// an Auto Scaling group that contain tasks from being terminated during a scale-in action.
        /// The Auto Scaling group and each instance in the Auto Scaling group must have instance
        /// protection from scale-in actions enabled as well. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection">Instance Protection</a> in the <i>Auto Scaling User Guide</i>.</p>
        /// <p>When managed termination protection is disabled, your Amazon EC2 instances are not
        /// protected from termination when the Auto Scaling group scales in.</p>
        pub fn set_managed_termination_protection(
            mut self,
            input: std::option::Option<crate::model::ManagedTerminationProtection>,
        ) -> Self {
            self.managed_termination_protection = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingGroupProvider`](crate::model::AutoScalingGroupProvider)
        pub fn build(self) -> crate::model::AutoScalingGroupProvider {
            crate::model::AutoScalingGroupProvider {
                auto_scaling_group_arn: self.auto_scaling_group_arn,
                managed_scaling: self.managed_scaling,
                managed_termination_protection: self.managed_termination_protection,
            }
        }
    }
}
impl AutoScalingGroupProvider {
    /// Creates a new builder-style object to manufacture [`AutoScalingGroupProvider`](crate::model::AutoScalingGroupProvider)
    pub fn builder() -> crate::model::auto_scaling_group_provider::Builder {
        crate::model::auto_scaling_group_provider::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ManagedTerminationProtection {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ManagedTerminationProtection {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => ManagedTerminationProtection::Disabled,
            "ENABLED" => ManagedTerminationProtection::Enabled,
            other => ManagedTerminationProtection::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ManagedTerminationProtection {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ManagedTerminationProtection::from(s))
    }
}
impl ManagedTerminationProtection {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ManagedTerminationProtection::Disabled => "DISABLED",
            ManagedTerminationProtection::Enabled => "ENABLED",
            ManagedTerminationProtection::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for ManagedTerminationProtection {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The managed scaling settings for the Auto Scaling group capacity provider.</p>
/// <p>When managed scaling is enabled, Amazon ECS manages the scale-in and scale-out actions of
/// the Auto Scaling group. Amazon ECS manages a target tracking scaling policy using an
/// Amazon ECS-managed CloudWatch metric with the specified <code>targetCapacity</code> value as the
/// target value for the metric. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/asg-capacity-providers.html#asg-capacity-providers-managed-scaling">Using Managed Scaling</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
/// <p>If managed scaling is disabled, the user must manage the scaling of the Auto Scaling
/// group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ManagedScaling {
    /// <p>Whether or not to enable managed scaling for the capacity provider.</p>
    pub status: std::option::Option<crate::model::ManagedScalingStatus>,
    /// <p>The target capacity value for the capacity provider. The specified value must be
    /// greater than <code>0</code> and less than or equal to <code>100</code>. A value of
    /// <code>100</code> will result in the Amazon EC2 instances in your Auto Scaling group being
    /// completely utilized.</p>
    pub target_capacity: std::option::Option<i32>,
    /// <p>The minimum number of container instances that Amazon ECS will scale in or scale out at one
    /// time. If this parameter is omitted, the default value of <code>1</code> is used.</p>
    pub minimum_scaling_step_size: std::option::Option<i32>,
    /// <p>The maximum number of container instances that Amazon ECS will scale in or scale out at one
    /// time. If this parameter is omitted, the default value of <code>10000</code> is
    /// used.</p>
    pub maximum_scaling_step_size: std::option::Option<i32>,
    /// <p>The period of time, in seconds, after a newly launched Amazon EC2 instance can contribute
    /// to CloudWatch metrics for Auto Scaling group. If this parameter is omitted, the default value
    /// of <code>300</code> seconds is used.</p>
    pub instance_warmup_period: std::option::Option<i32>,
}
impl std::fmt::Debug for ManagedScaling {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ManagedScaling");
        formatter.field("status", &self.status);
        formatter.field("target_capacity", &self.target_capacity);
        formatter.field("minimum_scaling_step_size", &self.minimum_scaling_step_size);
        formatter.field("maximum_scaling_step_size", &self.maximum_scaling_step_size);
        formatter.field("instance_warmup_period", &self.instance_warmup_period);
        formatter.finish()
    }
}
/// See [`ManagedScaling`](crate::model::ManagedScaling)
pub mod managed_scaling {
    /// A builder for [`ManagedScaling`](crate::model::ManagedScaling)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::ManagedScalingStatus>,
        pub(crate) target_capacity: std::option::Option<i32>,
        pub(crate) minimum_scaling_step_size: std::option::Option<i32>,
        pub(crate) maximum_scaling_step_size: std::option::Option<i32>,
        pub(crate) instance_warmup_period: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Whether or not to enable managed scaling for the capacity provider.</p>
        pub fn status(mut self, input: crate::model::ManagedScalingStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Whether or not to enable managed scaling for the capacity provider.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ManagedScalingStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The target capacity value for the capacity provider. The specified value must be
        /// greater than <code>0</code> and less than or equal to <code>100</code>. A value of
        /// <code>100</code> will result in the Amazon EC2 instances in your Auto Scaling group being
        /// completely utilized.</p>
        pub fn target_capacity(mut self, input: i32) -> Self {
            self.target_capacity = Some(input);
            self
        }
        /// <p>The target capacity value for the capacity provider. The specified value must be
        /// greater than <code>0</code> and less than or equal to <code>100</code>. A value of
        /// <code>100</code> will result in the Amazon EC2 instances in your Auto Scaling group being
        /// completely utilized.</p>
        pub fn set_target_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.target_capacity = input;
            self
        }
        /// <p>The minimum number of container instances that Amazon ECS will scale in or scale out at one
        /// time. If this parameter is omitted, the default value of <code>1</code> is used.</p>
        pub fn minimum_scaling_step_size(mut self, input: i32) -> Self {
            self.minimum_scaling_step_size = Some(input);
            self
        }
        /// <p>The minimum number of container instances that Amazon ECS will scale in or scale out at one
        /// time. If this parameter is omitted, the default value of <code>1</code> is used.</p>
        pub fn set_minimum_scaling_step_size(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_scaling_step_size = input;
            self
        }
        /// <p>The maximum number of container instances that Amazon ECS will scale in or scale out at one
        /// time. If this parameter is omitted, the default value of <code>10000</code> is
        /// used.</p>
        pub fn maximum_scaling_step_size(mut self, input: i32) -> Self {
            self.maximum_scaling_step_size = Some(input);
            self
        }
        /// <p>The maximum number of container instances that Amazon ECS will scale in or scale out at one
        /// time. If this parameter is omitted, the default value of <code>10000</code> is
        /// used.</p>
        pub fn set_maximum_scaling_step_size(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_scaling_step_size = input;
            self
        }
        /// <p>The period of time, in seconds, after a newly launched Amazon EC2 instance can contribute
        /// to CloudWatch metrics for Auto Scaling group. If this parameter is omitted, the default value
        /// of <code>300</code> seconds is used.</p>
        pub fn instance_warmup_period(mut self, input: i32) -> Self {
            self.instance_warmup_period = Some(input);
            self
        }
        /// <p>The period of time, in seconds, after a newly launched Amazon EC2 instance can contribute
        /// to CloudWatch metrics for Auto Scaling group. If this parameter is omitted, the default value
        /// of <code>300</code> seconds is used.</p>
        pub fn set_instance_warmup_period(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_warmup_period = input;
            self
        }
        /// Consumes the builder and constructs a [`ManagedScaling`](crate::model::ManagedScaling)
        pub fn build(self) -> crate::model::ManagedScaling {
            crate::model::ManagedScaling {
                status: self.status,
                target_capacity: self.target_capacity,
                minimum_scaling_step_size: self.minimum_scaling_step_size,
                maximum_scaling_step_size: self.maximum_scaling_step_size,
                instance_warmup_period: self.instance_warmup_period,
            }
        }
    }
}
impl ManagedScaling {
    /// Creates a new builder-style object to manufacture [`ManagedScaling`](crate::model::ManagedScaling)
    pub fn builder() -> crate::model::managed_scaling::Builder {
        crate::model::managed_scaling::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ManagedScalingStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ManagedScalingStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => ManagedScalingStatus::Disabled,
            "ENABLED" => ManagedScalingStatus::Enabled,
            other => ManagedScalingStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ManagedScalingStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ManagedScalingStatus::from(s))
    }
}
impl ManagedScalingStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ManagedScalingStatus::Disabled => "DISABLED",
            ManagedScalingStatus::Enabled => "ENABLED",
            ManagedScalingStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for ManagedScalingStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CapacityProviderStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CapacityProviderStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => CapacityProviderStatus::Active,
            "INACTIVE" => CapacityProviderStatus::Inactive,
            other => CapacityProviderStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CapacityProviderStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CapacityProviderStatus::from(s))
    }
}
impl CapacityProviderStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CapacityProviderStatus::Active => "ACTIVE",
            CapacityProviderStatus::Inactive => "INACTIVE",
            CapacityProviderStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE"]
    }
}
impl AsRef<str> for CapacityProviderStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details of the Auto Scaling group capacity provider to update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingGroupProviderUpdate {
    /// <p>The managed scaling settings for the Auto Scaling group capacity provider.</p>
    pub managed_scaling: std::option::Option<crate::model::ManagedScaling>,
    /// <p>The managed termination protection setting to use for the Auto Scaling group capacity
    /// provider. This determines whether the Auto Scaling group has managed termination
    /// protection.</p>
    /// <important>
    /// <p>When using managed termination protection, managed scaling must also be used
    /// otherwise managed termination protection will not work.</p>
    /// </important>
    /// <p>When managed termination protection is enabled, Amazon ECS prevents the Amazon EC2 instances in
    /// an Auto Scaling group that contain tasks from being terminated during a scale-in action.
    /// The Auto Scaling group and each instance in the Auto Scaling group must have instance
    /// protection from scale-in actions enabled as well. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection">Instance Protection</a> in the <i>Auto Scaling User Guide</i>.</p>
    /// <p>When managed termination protection is disabled, your Amazon EC2 instances are not
    /// protected from termination when the Auto Scaling group scales in.</p>
    pub managed_termination_protection:
        std::option::Option<crate::model::ManagedTerminationProtection>,
}
impl std::fmt::Debug for AutoScalingGroupProviderUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingGroupProviderUpdate");
        formatter.field("managed_scaling", &self.managed_scaling);
        formatter.field(
            "managed_termination_protection",
            &self.managed_termination_protection,
        );
        formatter.finish()
    }
}
/// See [`AutoScalingGroupProviderUpdate`](crate::model::AutoScalingGroupProviderUpdate)
pub mod auto_scaling_group_provider_update {
    /// A builder for [`AutoScalingGroupProviderUpdate`](crate::model::AutoScalingGroupProviderUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) managed_scaling: std::option::Option<crate::model::ManagedScaling>,
        pub(crate) managed_termination_protection:
            std::option::Option<crate::model::ManagedTerminationProtection>,
    }
    impl Builder {
        /// <p>The managed scaling settings for the Auto Scaling group capacity provider.</p>
        pub fn managed_scaling(mut self, input: crate::model::ManagedScaling) -> Self {
            self.managed_scaling = Some(input);
            self
        }
        /// <p>The managed scaling settings for the Auto Scaling group capacity provider.</p>
        pub fn set_managed_scaling(
            mut self,
            input: std::option::Option<crate::model::ManagedScaling>,
        ) -> Self {
            self.managed_scaling = input;
            self
        }
        /// <p>The managed termination protection setting to use for the Auto Scaling group capacity
        /// provider. This determines whether the Auto Scaling group has managed termination
        /// protection.</p>
        /// <important>
        /// <p>When using managed termination protection, managed scaling must also be used
        /// otherwise managed termination protection will not work.</p>
        /// </important>
        /// <p>When managed termination protection is enabled, Amazon ECS prevents the Amazon EC2 instances in
        /// an Auto Scaling group that contain tasks from being terminated during a scale-in action.
        /// The Auto Scaling group and each instance in the Auto Scaling group must have instance
        /// protection from scale-in actions enabled as well. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection">Instance Protection</a> in the <i>Auto Scaling User Guide</i>.</p>
        /// <p>When managed termination protection is disabled, your Amazon EC2 instances are not
        /// protected from termination when the Auto Scaling group scales in.</p>
        pub fn managed_termination_protection(
            mut self,
            input: crate::model::ManagedTerminationProtection,
        ) -> Self {
            self.managed_termination_protection = Some(input);
            self
        }
        /// <p>The managed termination protection setting to use for the Auto Scaling group capacity
        /// provider. This determines whether the Auto Scaling group has managed termination
        /// protection.</p>
        /// <important>
        /// <p>When using managed termination protection, managed scaling must also be used
        /// otherwise managed termination protection will not work.</p>
        /// </important>
        /// <p>When managed termination protection is enabled, Amazon ECS prevents the Amazon EC2 instances in
        /// an Auto Scaling group that contain tasks from being terminated during a scale-in action.
        /// The Auto Scaling group and each instance in the Auto Scaling group must have instance
        /// protection from scale-in actions enabled as well. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection">Instance Protection</a> in the <i>Auto Scaling User Guide</i>.</p>
        /// <p>When managed termination protection is disabled, your Amazon EC2 instances are not
        /// protected from termination when the Auto Scaling group scales in.</p>
        pub fn set_managed_termination_protection(
            mut self,
            input: std::option::Option<crate::model::ManagedTerminationProtection>,
        ) -> Self {
            self.managed_termination_protection = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingGroupProviderUpdate`](crate::model::AutoScalingGroupProviderUpdate)
        pub fn build(self) -> crate::model::AutoScalingGroupProviderUpdate {
            crate::model::AutoScalingGroupProviderUpdate {
                managed_scaling: self.managed_scaling,
                managed_termination_protection: self.managed_termination_protection,
            }
        }
    }
}
impl AutoScalingGroupProviderUpdate {
    /// Creates a new builder-style object to manufacture [`AutoScalingGroupProviderUpdate`](crate::model::AutoScalingGroupProviderUpdate)
    pub fn builder() -> crate::model::auto_scaling_group_provider_update::Builder {
        crate::model::auto_scaling_group_provider_update::Builder::default()
    }
}

/// <p>An object representing a change in state for a managed agent.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ManagedAgentStateChange {
    /// <p>The name of the container associated with the managed agent.</p>
    pub container_name: std::option::Option<std::string::String>,
    /// <p>The name of the managed agent.</p>
    pub managed_agent_name: std::option::Option<crate::model::ManagedAgentName>,
    /// <p>The status of the managed agent.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The reason for the status of the managed agent.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ManagedAgentStateChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ManagedAgentStateChange");
        formatter.field("container_name", &self.container_name);
        formatter.field("managed_agent_name", &self.managed_agent_name);
        formatter.field("status", &self.status);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`ManagedAgentStateChange`](crate::model::ManagedAgentStateChange)
pub mod managed_agent_state_change {
    /// A builder for [`ManagedAgentStateChange`](crate::model::ManagedAgentStateChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_name: std::option::Option<std::string::String>,
        pub(crate) managed_agent_name: std::option::Option<crate::model::ManagedAgentName>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the container associated with the managed agent.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_name = Some(input.into());
            self
        }
        /// <p>The name of the container associated with the managed agent.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_name = input;
            self
        }
        /// <p>The name of the managed agent.</p>
        pub fn managed_agent_name(mut self, input: crate::model::ManagedAgentName) -> Self {
            self.managed_agent_name = Some(input);
            self
        }
        /// <p>The name of the managed agent.</p>
        pub fn set_managed_agent_name(
            mut self,
            input: std::option::Option<crate::model::ManagedAgentName>,
        ) -> Self {
            self.managed_agent_name = input;
            self
        }
        /// <p>The status of the managed agent.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the managed agent.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason for the status of the managed agent.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason for the status of the managed agent.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ManagedAgentStateChange`](crate::model::ManagedAgentStateChange)
        pub fn build(self) -> crate::model::ManagedAgentStateChange {
            crate::model::ManagedAgentStateChange {
                container_name: self.container_name,
                managed_agent_name: self.managed_agent_name,
                status: self.status,
                reason: self.reason,
            }
        }
    }
}
impl ManagedAgentStateChange {
    /// Creates a new builder-style object to manufacture [`ManagedAgentStateChange`](crate::model::ManagedAgentStateChange)
    pub fn builder() -> crate::model::managed_agent_state_change::Builder {
        crate::model::managed_agent_state_change::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ManagedAgentName {
    #[allow(missing_docs)] // documentation missing in model
    ExecuteCommandAgent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ManagedAgentName {
    fn from(s: &str) -> Self {
        match s {
            "ExecuteCommandAgent" => ManagedAgentName::ExecuteCommandAgent,
            other => ManagedAgentName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ManagedAgentName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ManagedAgentName::from(s))
    }
}
impl ManagedAgentName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ManagedAgentName::ExecuteCommandAgent => "ExecuteCommandAgent",
            ManagedAgentName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ExecuteCommandAgent"]
    }
}
impl AsRef<str> for ManagedAgentName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing a change in state for a task attachment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachmentStateChange {
    /// <p>The Amazon Resource Name (ARN) of the attachment.</p>
    pub attachment_arn: std::option::Option<std::string::String>,
    /// <p>The status of the attachment.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AttachmentStateChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachmentStateChange");
        formatter.field("attachment_arn", &self.attachment_arn);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`AttachmentStateChange`](crate::model::AttachmentStateChange)
pub mod attachment_state_change {
    /// A builder for [`AttachmentStateChange`](crate::model::AttachmentStateChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attachment_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the attachment.</p>
        pub fn attachment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.attachment_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the attachment.</p>
        pub fn set_attachment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attachment_arn = input;
            self
        }
        /// <p>The status of the attachment.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the attachment.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachmentStateChange`](crate::model::AttachmentStateChange)
        pub fn build(self) -> crate::model::AttachmentStateChange {
            crate::model::AttachmentStateChange {
                attachment_arn: self.attachment_arn,
                status: self.status,
            }
        }
    }
}
impl AttachmentStateChange {
    /// Creates a new builder-style object to manufacture [`AttachmentStateChange`](crate::model::AttachmentStateChange)
    pub fn builder() -> crate::model::attachment_state_change::Builder {
        crate::model::attachment_state_change::Builder::default()
    }
}

/// <p>An object representing a change in state for a container.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerStateChange {
    /// <p>The name of the container.</p>
    pub container_name: std::option::Option<std::string::String>,
    /// <p>The container image SHA 256 digest.</p>
    pub image_digest: std::option::Option<std::string::String>,
    /// <p>The ID of the Docker container.</p>
    pub runtime_id: std::option::Option<std::string::String>,
    /// <p>The exit code for the container, if the state change is a result of the container
    /// exiting.</p>
    pub exit_code: std::option::Option<i32>,
    /// <p>Any network bindings associated with the container.</p>
    pub network_bindings: std::option::Option<std::vec::Vec<crate::model::NetworkBinding>>,
    /// <p>The reason for the state change.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>The status of the container.</p>
    pub status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ContainerStateChange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerStateChange");
        formatter.field("container_name", &self.container_name);
        formatter.field("image_digest", &self.image_digest);
        formatter.field("runtime_id", &self.runtime_id);
        formatter.field("exit_code", &self.exit_code);
        formatter.field("network_bindings", &self.network_bindings);
        formatter.field("reason", &self.reason);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ContainerStateChange`](crate::model::ContainerStateChange)
pub mod container_state_change {
    /// A builder for [`ContainerStateChange`](crate::model::ContainerStateChange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_name: std::option::Option<std::string::String>,
        pub(crate) image_digest: std::option::Option<std::string::String>,
        pub(crate) runtime_id: std::option::Option<std::string::String>,
        pub(crate) exit_code: std::option::Option<i32>,
        pub(crate) network_bindings:
            std::option::Option<std::vec::Vec<crate::model::NetworkBinding>>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the container.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_name = Some(input.into());
            self
        }
        /// <p>The name of the container.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_name = input;
            self
        }
        /// <p>The container image SHA 256 digest.</p>
        pub fn image_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_digest = Some(input.into());
            self
        }
        /// <p>The container image SHA 256 digest.</p>
        pub fn set_image_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_digest = input;
            self
        }
        /// <p>The ID of the Docker container.</p>
        pub fn runtime_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.runtime_id = Some(input.into());
            self
        }
        /// <p>The ID of the Docker container.</p>
        pub fn set_runtime_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.runtime_id = input;
            self
        }
        /// <p>The exit code for the container, if the state change is a result of the container
        /// exiting.</p>
        pub fn exit_code(mut self, input: i32) -> Self {
            self.exit_code = Some(input);
            self
        }
        /// <p>The exit code for the container, if the state change is a result of the container
        /// exiting.</p>
        pub fn set_exit_code(mut self, input: std::option::Option<i32>) -> Self {
            self.exit_code = input;
            self
        }
        /// Appends an item to `network_bindings`.
        ///
        /// To override the contents of this collection use [`set_network_bindings`](Self::set_network_bindings).
        ///
        /// <p>Any network bindings associated with the container.</p>
        pub fn network_bindings(mut self, input: impl Into<crate::model::NetworkBinding>) -> Self {
            let mut v = self.network_bindings.unwrap_or_default();
            v.push(input.into());
            self.network_bindings = Some(v);
            self
        }
        /// <p>Any network bindings associated with the container.</p>
        pub fn set_network_bindings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkBinding>>,
        ) -> Self {
            self.network_bindings = input;
            self
        }
        /// <p>The reason for the state change.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason for the state change.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p>The status of the container.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the container.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerStateChange`](crate::model::ContainerStateChange)
        pub fn build(self) -> crate::model::ContainerStateChange {
            crate::model::ContainerStateChange {
                container_name: self.container_name,
                image_digest: self.image_digest,
                runtime_id: self.runtime_id,
                exit_code: self.exit_code,
                network_bindings: self.network_bindings,
                reason: self.reason,
                status: self.status,
            }
        }
    }
}
impl ContainerStateChange {
    /// Creates a new builder-style object to manufacture [`ContainerStateChange`](crate::model::ContainerStateChange)
    pub fn builder() -> crate::model::container_state_change::Builder {
        crate::model::container_state_change::Builder::default()
    }
}

/// <p>Details on the network bindings between a container and its host container instance.
/// After a task reaches the <code>RUNNING</code> status, manual and automatic host and
/// container port assignments are visible in the <code>networkBindings</code> section of
/// <a>DescribeTasks</a> API responses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkBinding {
    /// <p>The IP address that the container is bound to on the container instance.</p>
    pub bind_ip: std::option::Option<std::string::String>,
    /// <p>The port number on the container that is used with the network binding.</p>
    pub container_port: std::option::Option<i32>,
    /// <p>The port number on the host that is used with the network binding.</p>
    pub host_port: std::option::Option<i32>,
    /// <p>The protocol used for the network binding.</p>
    pub protocol: std::option::Option<crate::model::TransportProtocol>,
}
impl std::fmt::Debug for NetworkBinding {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkBinding");
        formatter.field("bind_ip", &self.bind_ip);
        formatter.field("container_port", &self.container_port);
        formatter.field("host_port", &self.host_port);
        formatter.field("protocol", &self.protocol);
        formatter.finish()
    }
}
/// See [`NetworkBinding`](crate::model::NetworkBinding)
pub mod network_binding {
    /// A builder for [`NetworkBinding`](crate::model::NetworkBinding)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bind_ip: std::option::Option<std::string::String>,
        pub(crate) container_port: std::option::Option<i32>,
        pub(crate) host_port: std::option::Option<i32>,
        pub(crate) protocol: std::option::Option<crate::model::TransportProtocol>,
    }
    impl Builder {
        /// <p>The IP address that the container is bound to on the container instance.</p>
        pub fn bind_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.bind_ip = Some(input.into());
            self
        }
        /// <p>The IP address that the container is bound to on the container instance.</p>
        pub fn set_bind_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bind_ip = input;
            self
        }
        /// <p>The port number on the container that is used with the network binding.</p>
        pub fn container_port(mut self, input: i32) -> Self {
            self.container_port = Some(input);
            self
        }
        /// <p>The port number on the container that is used with the network binding.</p>
        pub fn set_container_port(mut self, input: std::option::Option<i32>) -> Self {
            self.container_port = input;
            self
        }
        /// <p>The port number on the host that is used with the network binding.</p>
        pub fn host_port(mut self, input: i32) -> Self {
            self.host_port = Some(input);
            self
        }
        /// <p>The port number on the host that is used with the network binding.</p>
        pub fn set_host_port(mut self, input: std::option::Option<i32>) -> Self {
            self.host_port = input;
            self
        }
        /// <p>The protocol used for the network binding.</p>
        pub fn protocol(mut self, input: crate::model::TransportProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol used for the network binding.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::TransportProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkBinding`](crate::model::NetworkBinding)
        pub fn build(self) -> crate::model::NetworkBinding {
            crate::model::NetworkBinding {
                bind_ip: self.bind_ip,
                container_port: self.container_port,
                host_port: self.host_port,
                protocol: self.protocol,
            }
        }
    }
}
impl NetworkBinding {
    /// Creates a new builder-style object to manufacture [`NetworkBinding`](crate::model::NetworkBinding)
    pub fn builder() -> crate::model::network_binding::Builder {
        crate::model::network_binding::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransportProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Tcp,
    #[allow(missing_docs)] // documentation missing in model
    Udp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransportProtocol {
    fn from(s: &str) -> Self {
        match s {
            "tcp" => TransportProtocol::Tcp,
            "udp" => TransportProtocol::Udp,
            other => TransportProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransportProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransportProtocol::from(s))
    }
}
impl TransportProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransportProtocol::Tcp => "tcp",
            TransportProtocol::Udp => "udp",
            TransportProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["tcp", "udp"]
    }
}
impl AsRef<str> for TransportProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details on a task in a cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Task {
    /// <p>The Elastic Network Adapter associated with the task if the task uses the
    /// <code>awsvpc</code> network mode.</p>
    pub attachments: std::option::Option<std::vec::Vec<crate::model::Attachment>>,
    /// <p>The attributes of the task</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    /// <p>The availability zone of the task.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The capacity provider associated with the task.</p>
    pub capacity_provider_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the cluster that hosts the task.</p>
    pub cluster_arn: std::option::Option<std::string::String>,
    /// <p>The connectivity status of a task.</p>
    pub connectivity: std::option::Option<crate::model::Connectivity>,
    /// <p>The Unix timestamp for when the task last went into <code>CONNECTED</code>
    /// status.</p>
    pub connectivity_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ARN of the container instances that host the task.</p>
    pub container_instance_arn: std::option::Option<std::string::String>,
    /// <p>The containers associated with the task.</p>
    pub containers: std::option::Option<std::vec::Vec<crate::model::Container>>,
    /// <p>The number of CPU units used by the task as expressed in a task definition. It can be
    /// expressed as an integer using CPU units, for example <code>1024</code>. It can also be
    /// expressed as a string using vCPUs, for example <code>1 vCPU</code> or <code>1
    /// vcpu</code>. String values are converted to an integer indicating the CPU units when
    /// the task definition is registered.</p>
    /// <p>If you are using the EC2 launch type, this field is optional. Supported
    /// values are between <code>128</code> CPU units (<code>0.125</code> vCPUs) and
    /// <code>10240</code> CPU units (<code>10</code> vCPUs).</p>
    /// <p>If you are using the Fargate launch type, this field is required and you
    /// must use one of the following values, which determines your range of supported values
    /// for the <code>memory</code> parameter:</p>
    /// <ul>
    /// <li>
    /// <p>256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)</p>
    /// </li>
    /// <li>
    /// <p>512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)</p>
    /// </li>
    /// <li>
    /// <p>1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)</p>
    /// </li>
    /// <li>
    /// <p>2048 (2 vCPU) - Available <code>memory</code> values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)</p>
    /// </li>
    /// <li>
    /// <p>4096 (4 vCPU) - Available <code>memory</code> values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)</p>
    /// </li>
    /// </ul>
    pub cpu: std::option::Option<std::string::String>,
    /// <p>The Unix timestamp for when the task was created (the task entered the
    /// <code>PENDING</code> state).</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The desired status of the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task
    /// Lifecycle</a>.</p>
    pub desired_status: std::option::Option<std::string::String>,
    /// <p>Whether or not execute command functionality is enabled for this task. If
    /// <code>true</code>, this enables execute command functionality on all containers in
    /// the task.</p>
    pub enable_execute_command: bool,
    /// <p>The Unix timestamp for when the task execution stopped.</p>
    pub execution_stopped_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the task group associated with the task.</p>
    pub group: std::option::Option<std::string::String>,
    /// <p>The health status for the task, which is determined by the health of the essential
    /// containers in the task. If all essential containers in the task are reporting as
    /// <code>HEALTHY</code>, then the task status also reports as <code>HEALTHY</code>. If
    /// any essential containers in the task are reporting as <code>UNHEALTHY</code> or
    /// <code>UNKNOWN</code>, then the task status also reports as <code>UNHEALTHY</code> or
    /// <code>UNKNOWN</code>, accordingly.</p>
    /// <note>
    /// <p>The Amazon ECS container agent does not monitor or report on Docker health checks that
    /// are embedded in a container image (such as those specified in a parent image or from
    /// the image's Dockerfile) and not specified in the container definition. Health check
    /// parameters that are specified in a container definition override any Docker health
    /// checks that exist in the container image.</p>
    /// </note>
    pub health_status: std::option::Option<crate::model::HealthStatus>,
    /// <p>The Elastic Inference accelerator associated with the task.</p>
    pub inference_accelerators:
        std::option::Option<std::vec::Vec<crate::model::InferenceAccelerator>>,
    /// <p>The last known status of the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task
    /// Lifecycle</a>.</p>
    pub last_status: std::option::Option<std::string::String>,
    /// <p>The infrastructure on which your task is running. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS
    /// launch types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub launch_type: std::option::Option<crate::model::LaunchType>,
    /// <p>The amount of memory (in MiB) used by the task as expressed in a task definition. It
    /// can be expressed as an integer using MiB, for example <code>1024</code>. It can also be
    /// expressed as a string using GB, for example <code>1GB</code> or <code>1 GB</code>.
    /// String values are converted to an integer indicating the MiB when the task definition is
    /// registered.</p>
    /// <p>If you are using the EC2 launch type, this field is optional.</p>
    /// <p>If you are using the Fargate launch type, this field is required and you
    /// must use one of the following values, which determines your range of supported values
    /// for the <code>cpu</code> parameter:</p>
    /// <ul>
    /// <li>
    /// <p>512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)</p>
    /// </li>
    /// <li>
    /// <p>1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)</p>
    /// </li>
    /// <li>
    /// <p>2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available <code>cpu</code> values: 1024 (1 vCPU)</p>
    /// </li>
    /// <li>
    /// <p>Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2 vCPU)</p>
    /// </li>
    /// <li>
    /// <p>Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4 vCPU)</p>
    /// </li>
    /// </ul>
    pub memory: std::option::Option<std::string::String>,
    /// <p>One or more container overrides.</p>
    pub overrides: std::option::Option<crate::model::TaskOverride>,
    /// <p>The platform version on which your task is running. A platform version is only
    /// specified for tasks using the Fargate launch type. If one is not
    /// specified, the <code>LATEST</code> platform version is used by default. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
    /// Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub platform_version: std::option::Option<std::string::String>,
    /// <p>The operating system  that your tasks are running on. A platform family is specified only for tasks using the Fargate launch type. </p>
    /// <p> All tasks that run as part of this service must use the same <code>platformFamily</code> value as the service, for example, <code>LINUX.</code>.</p>
    pub platform_family: std::option::Option<std::string::String>,
    /// <p>The Unix timestamp for when the container image pull began.</p>
    pub pull_started_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Unix timestamp for when the container image pull completed.</p>
    pub pull_stopped_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Unix timestamp for when the task started (the task transitioned from the
    /// <code>PENDING</code> state to the <code>RUNNING</code> state).</p>
    pub started_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The tag specified when a task is started. If the task is started by an Amazon ECS service,
    /// then the <code>startedBy</code> parameter contains the deployment ID of the service that
    /// starts it.</p>
    pub started_by: std::option::Option<std::string::String>,
    /// <p>The stop code indicating why a task was stopped. The <code>stoppedReason</code> may
    /// contain additional details.</p>
    pub stop_code: std::option::Option<crate::model::TaskStopCode>,
    /// <p>The Unix timestamp for when the task was stopped (the task transitioned from the
    /// <code>RUNNING</code> state to the <code>STOPPED</code> state).</p>
    pub stopped_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The reason that the task was stopped.</p>
    pub stopped_reason: std::option::Option<std::string::String>,
    /// <p>The Unix timestamp for when the task stops (transitions from the <code>RUNNING</code>
    /// state to <code>STOPPED</code>).</p>
    pub stopping_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The metadata that you apply to the task to help you categorize and organize them. Each
    /// tag consists of a key and an optional value, both of which you define.</p>
    /// <p>The following basic restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of tags per resource - 50</p>
    /// </li>
    /// <li>
    /// <p>For each resource, each tag key must be unique, and each tag key can have only
    /// one value.</p>
    /// </li>
    /// <li>
    /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>If your tagging schema is used across multiple services and resources,
    /// remember that other services may have restrictions on allowed characters.
    /// Generally allowed characters are: letters, numbers, and spaces representable in
    /// UTF-8, and the following characters: + - = . _ : / @.</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
    /// combination of such as a prefix for either keys or values as it is reserved for
    /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
    /// this prefix do not count against your tags per resource limit.</p>
    /// </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The Amazon Resource Name (ARN) of the task.</p>
    pub task_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the task definition that creates the task.</p>
    pub task_definition_arn: std::option::Option<std::string::String>,
    /// <p>The version counter for the task. Every time a task experiences a change that triggers
    /// a CloudWatch event, the version counter is incremented. If you are replicating your Amazon ECS task
    /// state with CloudWatch Events, you can compare the version of a task reported by the Amazon ECS API
    /// actions with the version reported in CloudWatch Events for the task (inside the
    /// <code>detail</code> object) to verify that the version in your event stream is
    /// current.</p>
    pub version: i64,
    /// <p>The ephemeral storage settings for the task.</p>
    pub ephemeral_storage: std::option::Option<crate::model::EphemeralStorage>,
}
impl std::fmt::Debug for Task {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Task");
        formatter.field("attachments", &self.attachments);
        formatter.field("attributes", &self.attributes);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("capacity_provider_name", &self.capacity_provider_name);
        formatter.field("cluster_arn", &self.cluster_arn);
        formatter.field("connectivity", &self.connectivity);
        formatter.field("connectivity_at", &self.connectivity_at);
        formatter.field("container_instance_arn", &self.container_instance_arn);
        formatter.field("containers", &self.containers);
        formatter.field("cpu", &self.cpu);
        formatter.field("created_at", &self.created_at);
        formatter.field("desired_status", &self.desired_status);
        formatter.field("enable_execute_command", &self.enable_execute_command);
        formatter.field("execution_stopped_at", &self.execution_stopped_at);
        formatter.field("group", &self.group);
        formatter.field("health_status", &self.health_status);
        formatter.field("inference_accelerators", &self.inference_accelerators);
        formatter.field("last_status", &self.last_status);
        formatter.field("launch_type", &self.launch_type);
        formatter.field("memory", &self.memory);
        formatter.field("overrides", &self.overrides);
        formatter.field("platform_version", &self.platform_version);
        formatter.field("platform_family", &self.platform_family);
        formatter.field("pull_started_at", &self.pull_started_at);
        formatter.field("pull_stopped_at", &self.pull_stopped_at);
        formatter.field("started_at", &self.started_at);
        formatter.field("started_by", &self.started_by);
        formatter.field("stop_code", &self.stop_code);
        formatter.field("stopped_at", &self.stopped_at);
        formatter.field("stopped_reason", &self.stopped_reason);
        formatter.field("stopping_at", &self.stopping_at);
        formatter.field("tags", &self.tags);
        formatter.field("task_arn", &self.task_arn);
        formatter.field("task_definition_arn", &self.task_definition_arn);
        formatter.field("version", &self.version);
        formatter.field("ephemeral_storage", &self.ephemeral_storage);
        formatter.finish()
    }
}
/// See [`Task`](crate::model::Task)
pub mod task {
    /// A builder for [`Task`](crate::model::Task)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attachments: std::option::Option<std::vec::Vec<crate::model::Attachment>>,
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) capacity_provider_name: std::option::Option<std::string::String>,
        pub(crate) cluster_arn: std::option::Option<std::string::String>,
        pub(crate) connectivity: std::option::Option<crate::model::Connectivity>,
        pub(crate) connectivity_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) container_instance_arn: std::option::Option<std::string::String>,
        pub(crate) containers: std::option::Option<std::vec::Vec<crate::model::Container>>,
        pub(crate) cpu: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) desired_status: std::option::Option<std::string::String>,
        pub(crate) enable_execute_command: std::option::Option<bool>,
        pub(crate) execution_stopped_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) group: std::option::Option<std::string::String>,
        pub(crate) health_status: std::option::Option<crate::model::HealthStatus>,
        pub(crate) inference_accelerators:
            std::option::Option<std::vec::Vec<crate::model::InferenceAccelerator>>,
        pub(crate) last_status: std::option::Option<std::string::String>,
        pub(crate) launch_type: std::option::Option<crate::model::LaunchType>,
        pub(crate) memory: std::option::Option<std::string::String>,
        pub(crate) overrides: std::option::Option<crate::model::TaskOverride>,
        pub(crate) platform_version: std::option::Option<std::string::String>,
        pub(crate) platform_family: std::option::Option<std::string::String>,
        pub(crate) pull_started_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) pull_stopped_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) started_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) started_by: std::option::Option<std::string::String>,
        pub(crate) stop_code: std::option::Option<crate::model::TaskStopCode>,
        pub(crate) stopped_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) stopped_reason: std::option::Option<std::string::String>,
        pub(crate) stopping_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) task_arn: std::option::Option<std::string::String>,
        pub(crate) task_definition_arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) ephemeral_storage: std::option::Option<crate::model::EphemeralStorage>,
    }
    impl Builder {
        /// Appends an item to `attachments`.
        ///
        /// To override the contents of this collection use [`set_attachments`](Self::set_attachments).
        ///
        /// <p>The Elastic Network Adapter associated with the task if the task uses the
        /// <code>awsvpc</code> network mode.</p>
        pub fn attachments(mut self, input: impl Into<crate::model::Attachment>) -> Self {
            let mut v = self.attachments.unwrap_or_default();
            v.push(input.into());
            self.attachments = Some(v);
            self
        }
        /// <p>The Elastic Network Adapter associated with the task if the task uses the
        /// <code>awsvpc</code> network mode.</p>
        pub fn set_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attachment>>,
        ) -> Self {
            self.attachments = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes of the task</p>
        pub fn attributes(mut self, input: impl Into<crate::model::Attribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>The attributes of the task</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The availability zone of the task.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The availability zone of the task.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The capacity provider associated with the task.</p>
        pub fn capacity_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.capacity_provider_name = Some(input.into());
            self
        }
        /// <p>The capacity provider associated with the task.</p>
        pub fn set_capacity_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capacity_provider_name = input;
            self
        }
        /// <p>The ARN of the cluster that hosts the task.</p>
        pub fn cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the cluster that hosts the task.</p>
        pub fn set_cluster_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_arn = input;
            self
        }
        /// <p>The connectivity status of a task.</p>
        pub fn connectivity(mut self, input: crate::model::Connectivity) -> Self {
            self.connectivity = Some(input);
            self
        }
        /// <p>The connectivity status of a task.</p>
        pub fn set_connectivity(
            mut self,
            input: std::option::Option<crate::model::Connectivity>,
        ) -> Self {
            self.connectivity = input;
            self
        }
        /// <p>The Unix timestamp for when the task last went into <code>CONNECTED</code>
        /// status.</p>
        pub fn connectivity_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.connectivity_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the task last went into <code>CONNECTED</code>
        /// status.</p>
        pub fn set_connectivity_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.connectivity_at = input;
            self
        }
        /// <p>The ARN of the container instances that host the task.</p>
        pub fn container_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the container instances that host the task.</p>
        pub fn set_container_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_instance_arn = input;
            self
        }
        /// Appends an item to `containers`.
        ///
        /// To override the contents of this collection use [`set_containers`](Self::set_containers).
        ///
        /// <p>The containers associated with the task.</p>
        pub fn containers(mut self, input: impl Into<crate::model::Container>) -> Self {
            let mut v = self.containers.unwrap_or_default();
            v.push(input.into());
            self.containers = Some(v);
            self
        }
        /// <p>The containers associated with the task.</p>
        pub fn set_containers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Container>>,
        ) -> Self {
            self.containers = input;
            self
        }
        /// <p>The number of CPU units used by the task as expressed in a task definition. It can be
        /// expressed as an integer using CPU units, for example <code>1024</code>. It can also be
        /// expressed as a string using vCPUs, for example <code>1 vCPU</code> or <code>1
        /// vcpu</code>. String values are converted to an integer indicating the CPU units when
        /// the task definition is registered.</p>
        /// <p>If you are using the EC2 launch type, this field is optional. Supported
        /// values are between <code>128</code> CPU units (<code>0.125</code> vCPUs) and
        /// <code>10240</code> CPU units (<code>10</code> vCPUs).</p>
        /// <p>If you are using the Fargate launch type, this field is required and you
        /// must use one of the following values, which determines your range of supported values
        /// for the <code>memory</code> parameter:</p>
        /// <ul>
        /// <li>
        /// <p>256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)</p>
        /// </li>
        /// <li>
        /// <p>512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)</p>
        /// </li>
        /// <li>
        /// <p>1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)</p>
        /// </li>
        /// <li>
        /// <p>2048 (2 vCPU) - Available <code>memory</code> values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)</p>
        /// </li>
        /// <li>
        /// <p>4096 (4 vCPU) - Available <code>memory</code> values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)</p>
        /// </li>
        /// </ul>
        pub fn cpu(mut self, input: impl Into<std::string::String>) -> Self {
            self.cpu = Some(input.into());
            self
        }
        /// <p>The number of CPU units used by the task as expressed in a task definition. It can be
        /// expressed as an integer using CPU units, for example <code>1024</code>. It can also be
        /// expressed as a string using vCPUs, for example <code>1 vCPU</code> or <code>1
        /// vcpu</code>. String values are converted to an integer indicating the CPU units when
        /// the task definition is registered.</p>
        /// <p>If you are using the EC2 launch type, this field is optional. Supported
        /// values are between <code>128</code> CPU units (<code>0.125</code> vCPUs) and
        /// <code>10240</code> CPU units (<code>10</code> vCPUs).</p>
        /// <p>If you are using the Fargate launch type, this field is required and you
        /// must use one of the following values, which determines your range of supported values
        /// for the <code>memory</code> parameter:</p>
        /// <ul>
        /// <li>
        /// <p>256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)</p>
        /// </li>
        /// <li>
        /// <p>512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)</p>
        /// </li>
        /// <li>
        /// <p>1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)</p>
        /// </li>
        /// <li>
        /// <p>2048 (2 vCPU) - Available <code>memory</code> values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)</p>
        /// </li>
        /// <li>
        /// <p>4096 (4 vCPU) - Available <code>memory</code> values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)</p>
        /// </li>
        /// </ul>
        pub fn set_cpu(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cpu = input;
            self
        }
        /// <p>The Unix timestamp for when the task was created (the task entered the
        /// <code>PENDING</code> state).</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the task was created (the task entered the
        /// <code>PENDING</code> state).</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The desired status of the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task
        /// Lifecycle</a>.</p>
        pub fn desired_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.desired_status = Some(input.into());
            self
        }
        /// <p>The desired status of the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task
        /// Lifecycle</a>.</p>
        pub fn set_desired_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.desired_status = input;
            self
        }
        /// <p>Whether or not execute command functionality is enabled for this task. If
        /// <code>true</code>, this enables execute command functionality on all containers in
        /// the task.</p>
        pub fn enable_execute_command(mut self, input: bool) -> Self {
            self.enable_execute_command = Some(input);
            self
        }
        /// <p>Whether or not execute command functionality is enabled for this task. If
        /// <code>true</code>, this enables execute command functionality on all containers in
        /// the task.</p>
        pub fn set_enable_execute_command(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_execute_command = input;
            self
        }
        /// <p>The Unix timestamp for when the task execution stopped.</p>
        pub fn execution_stopped_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.execution_stopped_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the task execution stopped.</p>
        pub fn set_execution_stopped_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.execution_stopped_at = input;
            self
        }
        /// <p>The name of the task group associated with the task.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The name of the task group associated with the task.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// <p>The health status for the task, which is determined by the health of the essential
        /// containers in the task. If all essential containers in the task are reporting as
        /// <code>HEALTHY</code>, then the task status also reports as <code>HEALTHY</code>. If
        /// any essential containers in the task are reporting as <code>UNHEALTHY</code> or
        /// <code>UNKNOWN</code>, then the task status also reports as <code>UNHEALTHY</code> or
        /// <code>UNKNOWN</code>, accordingly.</p>
        /// <note>
        /// <p>The Amazon ECS container agent does not monitor or report on Docker health checks that
        /// are embedded in a container image (such as those specified in a parent image or from
        /// the image's Dockerfile) and not specified in the container definition. Health check
        /// parameters that are specified in a container definition override any Docker health
        /// checks that exist in the container image.</p>
        /// </note>
        pub fn health_status(mut self, input: crate::model::HealthStatus) -> Self {
            self.health_status = Some(input);
            self
        }
        /// <p>The health status for the task, which is determined by the health of the essential
        /// containers in the task. If all essential containers in the task are reporting as
        /// <code>HEALTHY</code>, then the task status also reports as <code>HEALTHY</code>. If
        /// any essential containers in the task are reporting as <code>UNHEALTHY</code> or
        /// <code>UNKNOWN</code>, then the task status also reports as <code>UNHEALTHY</code> or
        /// <code>UNKNOWN</code>, accordingly.</p>
        /// <note>
        /// <p>The Amazon ECS container agent does not monitor or report on Docker health checks that
        /// are embedded in a container image (such as those specified in a parent image or from
        /// the image's Dockerfile) and not specified in the container definition. Health check
        /// parameters that are specified in a container definition override any Docker health
        /// checks that exist in the container image.</p>
        /// </note>
        pub fn set_health_status(
            mut self,
            input: std::option::Option<crate::model::HealthStatus>,
        ) -> Self {
            self.health_status = input;
            self
        }
        /// Appends an item to `inference_accelerators`.
        ///
        /// To override the contents of this collection use [`set_inference_accelerators`](Self::set_inference_accelerators).
        ///
        /// <p>The Elastic Inference accelerator associated with the task.</p>
        pub fn inference_accelerators(
            mut self,
            input: impl Into<crate::model::InferenceAccelerator>,
        ) -> Self {
            let mut v = self.inference_accelerators.unwrap_or_default();
            v.push(input.into());
            self.inference_accelerators = Some(v);
            self
        }
        /// <p>The Elastic Inference accelerator associated with the task.</p>
        pub fn set_inference_accelerators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InferenceAccelerator>>,
        ) -> Self {
            self.inference_accelerators = input;
            self
        }
        /// <p>The last known status of the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task
        /// Lifecycle</a>.</p>
        pub fn last_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_status = Some(input.into());
            self
        }
        /// <p>The last known status of the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task
        /// Lifecycle</a>.</p>
        pub fn set_last_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_status = input;
            self
        }
        /// <p>The infrastructure on which your task is running. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS
        /// launch types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn launch_type(mut self, input: crate::model::LaunchType) -> Self {
            self.launch_type = Some(input);
            self
        }
        /// <p>The infrastructure on which your task is running. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS
        /// launch types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_launch_type(
            mut self,
            input: std::option::Option<crate::model::LaunchType>,
        ) -> Self {
            self.launch_type = input;
            self
        }
        /// <p>The amount of memory (in MiB) used by the task as expressed in a task definition. It
        /// can be expressed as an integer using MiB, for example <code>1024</code>. It can also be
        /// expressed as a string using GB, for example <code>1GB</code> or <code>1 GB</code>.
        /// String values are converted to an integer indicating the MiB when the task definition is
        /// registered.</p>
        /// <p>If you are using the EC2 launch type, this field is optional.</p>
        /// <p>If you are using the Fargate launch type, this field is required and you
        /// must use one of the following values, which determines your range of supported values
        /// for the <code>cpu</code> parameter:</p>
        /// <ul>
        /// <li>
        /// <p>512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available <code>cpu</code> values: 1024 (1 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4 vCPU)</p>
        /// </li>
        /// </ul>
        pub fn memory(mut self, input: impl Into<std::string::String>) -> Self {
            self.memory = Some(input.into());
            self
        }
        /// <p>The amount of memory (in MiB) used by the task as expressed in a task definition. It
        /// can be expressed as an integer using MiB, for example <code>1024</code>. It can also be
        /// expressed as a string using GB, for example <code>1GB</code> or <code>1 GB</code>.
        /// String values are converted to an integer indicating the MiB when the task definition is
        /// registered.</p>
        /// <p>If you are using the EC2 launch type, this field is optional.</p>
        /// <p>If you are using the Fargate launch type, this field is required and you
        /// must use one of the following values, which determines your range of supported values
        /// for the <code>cpu</code> parameter:</p>
        /// <ul>
        /// <li>
        /// <p>512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available <code>cpu</code> values: 1024 (1 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4 vCPU)</p>
        /// </li>
        /// </ul>
        pub fn set_memory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.memory = input;
            self
        }
        /// <p>One or more container overrides.</p>
        pub fn overrides(mut self, input: crate::model::TaskOverride) -> Self {
            self.overrides = Some(input);
            self
        }
        /// <p>One or more container overrides.</p>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<crate::model::TaskOverride>,
        ) -> Self {
            self.overrides = input;
            self
        }
        /// <p>The platform version on which your task is running. A platform version is only
        /// specified for tasks using the Fargate launch type. If one is not
        /// specified, the <code>LATEST</code> platform version is used by default. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
        /// Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_version = Some(input.into());
            self
        }
        /// <p>The platform version on which your task is running. A platform version is only
        /// specified for tasks using the Fargate launch type. If one is not
        /// specified, the <code>LATEST</code> platform version is used by default. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
        /// Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_version = input;
            self
        }
        /// <p>The operating system  that your tasks are running on. A platform family is specified only for tasks using the Fargate launch type. </p>
        /// <p> All tasks that run as part of this service must use the same <code>platformFamily</code> value as the service, for example, <code>LINUX.</code>.</p>
        pub fn platform_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_family = Some(input.into());
            self
        }
        /// <p>The operating system  that your tasks are running on. A platform family is specified only for tasks using the Fargate launch type. </p>
        /// <p> All tasks that run as part of this service must use the same <code>platformFamily</code> value as the service, for example, <code>LINUX.</code>.</p>
        pub fn set_platform_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_family = input;
            self
        }
        /// <p>The Unix timestamp for when the container image pull began.</p>
        pub fn pull_started_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.pull_started_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the container image pull began.</p>
        pub fn set_pull_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.pull_started_at = input;
            self
        }
        /// <p>The Unix timestamp for when the container image pull completed.</p>
        pub fn pull_stopped_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.pull_stopped_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the container image pull completed.</p>
        pub fn set_pull_stopped_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.pull_stopped_at = input;
            self
        }
        /// <p>The Unix timestamp for when the task started (the task transitioned from the
        /// <code>PENDING</code> state to the <code>RUNNING</code> state).</p>
        pub fn started_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the task started (the task transitioned from the
        /// <code>PENDING</code> state to the <code>RUNNING</code> state).</p>
        pub fn set_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_at = input;
            self
        }
        /// <p>The tag specified when a task is started. If the task is started by an Amazon ECS service,
        /// then the <code>startedBy</code> parameter contains the deployment ID of the service that
        /// starts it.</p>
        pub fn started_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.started_by = Some(input.into());
            self
        }
        /// <p>The tag specified when a task is started. If the task is started by an Amazon ECS service,
        /// then the <code>startedBy</code> parameter contains the deployment ID of the service that
        /// starts it.</p>
        pub fn set_started_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.started_by = input;
            self
        }
        /// <p>The stop code indicating why a task was stopped. The <code>stoppedReason</code> may
        /// contain additional details.</p>
        pub fn stop_code(mut self, input: crate::model::TaskStopCode) -> Self {
            self.stop_code = Some(input);
            self
        }
        /// <p>The stop code indicating why a task was stopped. The <code>stoppedReason</code> may
        /// contain additional details.</p>
        pub fn set_stop_code(
            mut self,
            input: std::option::Option<crate::model::TaskStopCode>,
        ) -> Self {
            self.stop_code = input;
            self
        }
        /// <p>The Unix timestamp for when the task was stopped (the task transitioned from the
        /// <code>RUNNING</code> state to the <code>STOPPED</code> state).</p>
        pub fn stopped_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stopped_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the task was stopped (the task transitioned from the
        /// <code>RUNNING</code> state to the <code>STOPPED</code> state).</p>
        pub fn set_stopped_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stopped_at = input;
            self
        }
        /// <p>The reason that the task was stopped.</p>
        pub fn stopped_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.stopped_reason = Some(input.into());
            self
        }
        /// <p>The reason that the task was stopped.</p>
        pub fn set_stopped_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.stopped_reason = input;
            self
        }
        /// <p>The Unix timestamp for when the task stops (transitions from the <code>RUNNING</code>
        /// state to <code>STOPPED</code>).</p>
        pub fn stopping_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.stopping_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the task stops (transitions from the <code>RUNNING</code>
        /// state to <code>STOPPED</code>).</p>
        pub fn set_stopping_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.stopping_at = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the task to help you categorize and organize them. Each
        /// tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The metadata that you apply to the task to help you categorize and organize them. Each
        /// tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task.</p>
        pub fn task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_arn = input;
            self
        }
        /// <p>The ARN of the task definition that creates the task.</p>
        pub fn task_definition_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_definition_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the task definition that creates the task.</p>
        pub fn set_task_definition_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_definition_arn = input;
            self
        }
        /// <p>The version counter for the task. Every time a task experiences a change that triggers
        /// a CloudWatch event, the version counter is incremented. If you are replicating your Amazon ECS task
        /// state with CloudWatch Events, you can compare the version of a task reported by the Amazon ECS API
        /// actions with the version reported in CloudWatch Events for the task (inside the
        /// <code>detail</code> object) to verify that the version in your event stream is
        /// current.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version counter for the task. Every time a task experiences a change that triggers
        /// a CloudWatch event, the version counter is incremented. If you are replicating your Amazon ECS task
        /// state with CloudWatch Events, you can compare the version of a task reported by the Amazon ECS API
        /// actions with the version reported in CloudWatch Events for the task (inside the
        /// <code>detail</code> object) to verify that the version in your event stream is
        /// current.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// <p>The ephemeral storage settings for the task.</p>
        pub fn ephemeral_storage(mut self, input: crate::model::EphemeralStorage) -> Self {
            self.ephemeral_storage = Some(input);
            self
        }
        /// <p>The ephemeral storage settings for the task.</p>
        pub fn set_ephemeral_storage(
            mut self,
            input: std::option::Option<crate::model::EphemeralStorage>,
        ) -> Self {
            self.ephemeral_storage = input;
            self
        }
        /// Consumes the builder and constructs a [`Task`](crate::model::Task)
        pub fn build(self) -> crate::model::Task {
            crate::model::Task {
                attachments: self.attachments,
                attributes: self.attributes,
                availability_zone: self.availability_zone,
                capacity_provider_name: self.capacity_provider_name,
                cluster_arn: self.cluster_arn,
                connectivity: self.connectivity,
                connectivity_at: self.connectivity_at,
                container_instance_arn: self.container_instance_arn,
                containers: self.containers,
                cpu: self.cpu,
                created_at: self.created_at,
                desired_status: self.desired_status,
                enable_execute_command: self.enable_execute_command.unwrap_or_default(),
                execution_stopped_at: self.execution_stopped_at,
                group: self.group,
                health_status: self.health_status,
                inference_accelerators: self.inference_accelerators,
                last_status: self.last_status,
                launch_type: self.launch_type,
                memory: self.memory,
                overrides: self.overrides,
                platform_version: self.platform_version,
                platform_family: self.platform_family,
                pull_started_at: self.pull_started_at,
                pull_stopped_at: self.pull_stopped_at,
                started_at: self.started_at,
                started_by: self.started_by,
                stop_code: self.stop_code,
                stopped_at: self.stopped_at,
                stopped_reason: self.stopped_reason,
                stopping_at: self.stopping_at,
                tags: self.tags,
                task_arn: self.task_arn,
                task_definition_arn: self.task_definition_arn,
                version: self.version.unwrap_or_default(),
                ephemeral_storage: self.ephemeral_storage,
            }
        }
    }
}
impl Task {
    /// Creates a new builder-style object to manufacture [`Task`](crate::model::Task)
    pub fn builder() -> crate::model::task::Builder {
        crate::model::task::Builder::default()
    }
}

/// <p>The amount of ephemeral storage to allocate for the task. This parameter is used to
/// expand the total amount of ephemeral storage available, beyond the default amount, for
/// tasks hosted on Fargate. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/using_data_volumes.html">Fargate task
/// storage</a> in the <i>Amazon ECS User Guide for Fargate</i>.</p>
/// <note>
/// <p>This parameter is only supported for tasks hosted on Fargate using the following platform versions:</p>
/// <ul>
/// <li>
/// <p>Linux platform
/// version <code>1.4.0</code> or later.</p>
/// </li>
/// <li>
/// <p>Windows platform
/// version <code>1.0.0</code> or later.</p>
/// </li>
/// </ul>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EphemeralStorage {
    /// <p>The total amount, in GiB, of ephemeral storage to set for the task. The minimum
    /// supported value is <code>21</code> GiB and the maximum supported value is
    /// <code>200</code> GiB.</p>
    pub size_in_gi_b: i32,
}
impl std::fmt::Debug for EphemeralStorage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EphemeralStorage");
        formatter.field("size_in_gi_b", &self.size_in_gi_b);
        formatter.finish()
    }
}
/// See [`EphemeralStorage`](crate::model::EphemeralStorage)
pub mod ephemeral_storage {
    /// A builder for [`EphemeralStorage`](crate::model::EphemeralStorage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) size_in_gi_b: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The total amount, in GiB, of ephemeral storage to set for the task. The minimum
        /// supported value is <code>21</code> GiB and the maximum supported value is
        /// <code>200</code> GiB.</p>
        pub fn size_in_gi_b(mut self, input: i32) -> Self {
            self.size_in_gi_b = Some(input);
            self
        }
        /// <p>The total amount, in GiB, of ephemeral storage to set for the task. The minimum
        /// supported value is <code>21</code> GiB and the maximum supported value is
        /// <code>200</code> GiB.</p>
        pub fn set_size_in_gi_b(mut self, input: std::option::Option<i32>) -> Self {
            self.size_in_gi_b = input;
            self
        }
        /// Consumes the builder and constructs a [`EphemeralStorage`](crate::model::EphemeralStorage)
        pub fn build(self) -> crate::model::EphemeralStorage {
            crate::model::EphemeralStorage {
                size_in_gi_b: self.size_in_gi_b.unwrap_or_default(),
            }
        }
    }
}
impl EphemeralStorage {
    /// Creates a new builder-style object to manufacture [`EphemeralStorage`](crate::model::EphemeralStorage)
    pub fn builder() -> crate::model::ephemeral_storage::Builder {
        crate::model::ephemeral_storage::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TaskStopCode {
    #[allow(missing_docs)] // documentation missing in model
    EssentialContainerExited,
    #[allow(missing_docs)] // documentation missing in model
    TaskFailedToStart,
    #[allow(missing_docs)] // documentation missing in model
    UserInitiated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TaskStopCode {
    fn from(s: &str) -> Self {
        match s {
            "EssentialContainerExited" => TaskStopCode::EssentialContainerExited,
            "TaskFailedToStart" => TaskStopCode::TaskFailedToStart,
            "UserInitiated" => TaskStopCode::UserInitiated,
            other => TaskStopCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TaskStopCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TaskStopCode::from(s))
    }
}
impl TaskStopCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TaskStopCode::EssentialContainerExited => "EssentialContainerExited",
            TaskStopCode::TaskFailedToStart => "TaskFailedToStart",
            TaskStopCode::UserInitiated => "UserInitiated",
            TaskStopCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EssentialContainerExited",
            "TaskFailedToStart",
            "UserInitiated",
        ]
    }
}
impl AsRef<str> for TaskStopCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The overrides associated with a task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskOverride {
    /// <p>One or more container overrides sent to a task.</p>
    pub container_overrides: std::option::Option<std::vec::Vec<crate::model::ContainerOverride>>,
    /// <p>The cpu override for the task.</p>
    pub cpu: std::option::Option<std::string::String>,
    /// <p>The Elastic Inference accelerator override for the task.</p>
    pub inference_accelerator_overrides:
        std::option::Option<std::vec::Vec<crate::model::InferenceAcceleratorOverride>>,
    /// <p>The Amazon Resource Name (ARN) of the task execution IAM role override for the task. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task
    /// execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>The memory override for the task.</p>
    pub memory: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in
    /// this task are granted the permissions that are specified in this role. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Role for Tasks</a>
    /// in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub task_role_arn: std::option::Option<std::string::String>,
    /// <p>The ephemeral storage setting override for the task.</p>
    /// <note>
    /// <p>This parameter is only supported for tasks hosted on Fargate using the following platform versions:</p>
    /// <ul>
    /// <li>
    /// <p>Linux platform
    /// version <code>1.4.0</code> or later.</p>
    /// </li>
    /// <li>
    /// <p>Windows platform
    /// version <code>1.0.0</code> or later.</p>
    /// </li>
    /// </ul>
    /// </note>
    pub ephemeral_storage: std::option::Option<crate::model::EphemeralStorage>,
}
impl std::fmt::Debug for TaskOverride {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskOverride");
        formatter.field("container_overrides", &self.container_overrides);
        formatter.field("cpu", &self.cpu);
        formatter.field(
            "inference_accelerator_overrides",
            &self.inference_accelerator_overrides,
        );
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("memory", &self.memory);
        formatter.field("task_role_arn", &self.task_role_arn);
        formatter.field("ephemeral_storage", &self.ephemeral_storage);
        formatter.finish()
    }
}
/// See [`TaskOverride`](crate::model::TaskOverride)
pub mod task_override {
    /// A builder for [`TaskOverride`](crate::model::TaskOverride)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_overrides:
            std::option::Option<std::vec::Vec<crate::model::ContainerOverride>>,
        pub(crate) cpu: std::option::Option<std::string::String>,
        pub(crate) inference_accelerator_overrides:
            std::option::Option<std::vec::Vec<crate::model::InferenceAcceleratorOverride>>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) memory: std::option::Option<std::string::String>,
        pub(crate) task_role_arn: std::option::Option<std::string::String>,
        pub(crate) ephemeral_storage: std::option::Option<crate::model::EphemeralStorage>,
    }
    impl Builder {
        /// Appends an item to `container_overrides`.
        ///
        /// To override the contents of this collection use [`set_container_overrides`](Self::set_container_overrides).
        ///
        /// <p>One or more container overrides sent to a task.</p>
        pub fn container_overrides(
            mut self,
            input: impl Into<crate::model::ContainerOverride>,
        ) -> Self {
            let mut v = self.container_overrides.unwrap_or_default();
            v.push(input.into());
            self.container_overrides = Some(v);
            self
        }
        /// <p>One or more container overrides sent to a task.</p>
        pub fn set_container_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContainerOverride>>,
        ) -> Self {
            self.container_overrides = input;
            self
        }
        /// <p>The cpu override for the task.</p>
        pub fn cpu(mut self, input: impl Into<std::string::String>) -> Self {
            self.cpu = Some(input.into());
            self
        }
        /// <p>The cpu override for the task.</p>
        pub fn set_cpu(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cpu = input;
            self
        }
        /// Appends an item to `inference_accelerator_overrides`.
        ///
        /// To override the contents of this collection use [`set_inference_accelerator_overrides`](Self::set_inference_accelerator_overrides).
        ///
        /// <p>The Elastic Inference accelerator override for the task.</p>
        pub fn inference_accelerator_overrides(
            mut self,
            input: impl Into<crate::model::InferenceAcceleratorOverride>,
        ) -> Self {
            let mut v = self.inference_accelerator_overrides.unwrap_or_default();
            v.push(input.into());
            self.inference_accelerator_overrides = Some(v);
            self
        }
        /// <p>The Elastic Inference accelerator override for the task.</p>
        pub fn set_inference_accelerator_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InferenceAcceleratorOverride>>,
        ) -> Self {
            self.inference_accelerator_overrides = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task execution IAM role override for the task. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task
        /// execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task execution IAM role override for the task. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task
        /// execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>The memory override for the task.</p>
        pub fn memory(mut self, input: impl Into<std::string::String>) -> Self {
            self.memory = Some(input.into());
            self
        }
        /// <p>The memory override for the task.</p>
        pub fn set_memory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.memory = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in
        /// this task are granted the permissions that are specified in this role. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Role for Tasks</a>
        /// in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn task_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in
        /// this task are granted the permissions that are specified in this role. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Role for Tasks</a>
        /// in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_task_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_role_arn = input;
            self
        }
        /// <p>The ephemeral storage setting override for the task.</p>
        /// <note>
        /// <p>This parameter is only supported for tasks hosted on Fargate using the following platform versions:</p>
        /// <ul>
        /// <li>
        /// <p>Linux platform
        /// version <code>1.4.0</code> or later.</p>
        /// </li>
        /// <li>
        /// <p>Windows platform
        /// version <code>1.0.0</code> or later.</p>
        /// </li>
        /// </ul>
        /// </note>
        pub fn ephemeral_storage(mut self, input: crate::model::EphemeralStorage) -> Self {
            self.ephemeral_storage = Some(input);
            self
        }
        /// <p>The ephemeral storage setting override for the task.</p>
        /// <note>
        /// <p>This parameter is only supported for tasks hosted on Fargate using the following platform versions:</p>
        /// <ul>
        /// <li>
        /// <p>Linux platform
        /// version <code>1.4.0</code> or later.</p>
        /// </li>
        /// <li>
        /// <p>Windows platform
        /// version <code>1.0.0</code> or later.</p>
        /// </li>
        /// </ul>
        /// </note>
        pub fn set_ephemeral_storage(
            mut self,
            input: std::option::Option<crate::model::EphemeralStorage>,
        ) -> Self {
            self.ephemeral_storage = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskOverride`](crate::model::TaskOverride)
        pub fn build(self) -> crate::model::TaskOverride {
            crate::model::TaskOverride {
                container_overrides: self.container_overrides,
                cpu: self.cpu,
                inference_accelerator_overrides: self.inference_accelerator_overrides,
                execution_role_arn: self.execution_role_arn,
                memory: self.memory,
                task_role_arn: self.task_role_arn,
                ephemeral_storage: self.ephemeral_storage,
            }
        }
    }
}
impl TaskOverride {
    /// Creates a new builder-style object to manufacture [`TaskOverride`](crate::model::TaskOverride)
    pub fn builder() -> crate::model::task_override::Builder {
        crate::model::task_override::Builder::default()
    }
}

/// <p>Details on an Elastic Inference accelerator task override. This parameter is used to
/// override the Elastic Inference accelerator specified in the task definition. For more
/// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-inference.html">Working with Amazon Elastic Inference on Amazon ECS</a> in the
/// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InferenceAcceleratorOverride {
    /// <p>The Elastic Inference accelerator device name to override for the task. This parameter
    /// must match a <code>deviceName</code> specified in the task definition.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>The Elastic Inference accelerator type to use.</p>
    pub device_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InferenceAcceleratorOverride {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InferenceAcceleratorOverride");
        formatter.field("device_name", &self.device_name);
        formatter.field("device_type", &self.device_type);
        formatter.finish()
    }
}
/// See [`InferenceAcceleratorOverride`](crate::model::InferenceAcceleratorOverride)
pub mod inference_accelerator_override {
    /// A builder for [`InferenceAcceleratorOverride`](crate::model::InferenceAcceleratorOverride)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) device_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Elastic Inference accelerator device name to override for the task. This parameter
        /// must match a <code>deviceName</code> specified in the task definition.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The Elastic Inference accelerator device name to override for the task. This parameter
        /// must match a <code>deviceName</code> specified in the task definition.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>The Elastic Inference accelerator type to use.</p>
        pub fn device_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_type = Some(input.into());
            self
        }
        /// <p>The Elastic Inference accelerator type to use.</p>
        pub fn set_device_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_type = input;
            self
        }
        /// Consumes the builder and constructs a [`InferenceAcceleratorOverride`](crate::model::InferenceAcceleratorOverride)
        pub fn build(self) -> crate::model::InferenceAcceleratorOverride {
            crate::model::InferenceAcceleratorOverride {
                device_name: self.device_name,
                device_type: self.device_type,
            }
        }
    }
}
impl InferenceAcceleratorOverride {
    /// Creates a new builder-style object to manufacture [`InferenceAcceleratorOverride`](crate::model::InferenceAcceleratorOverride)
    pub fn builder() -> crate::model::inference_accelerator_override::Builder {
        crate::model::inference_accelerator_override::Builder::default()
    }
}

/// <p>The overrides that should be sent to a container. An empty container override can be
/// passed in. An example of an empty container override would be
/// <code>{"containerOverrides": [ ] }</code>. If a non-empty container override is
/// specified, the <code>name</code> parameter must be included.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerOverride {
    /// <p>The name of the container that receives the override. This parameter is required if
    /// any override is specified.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The command to send to the container that overrides the default command from the
    /// Docker image or the task definition. You must also specify a container name.</p>
    pub command: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The environment variables to send to the container. You can add new environment
    /// variables, which are added to the container at launch, or you can override the existing
    /// environment variables from the Docker image or the task definition. You must also
    /// specify a container name.</p>
    pub environment: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
    /// <p>A list of files containing the environment variables to pass to a container, instead
    /// of the value from the container definition.</p>
    pub environment_files: std::option::Option<std::vec::Vec<crate::model::EnvironmentFile>>,
    /// <p>The number of <code>cpu</code> units reserved for the container, instead of the
    /// default value from the task definition. You must also specify a container name.</p>
    pub cpu: std::option::Option<i32>,
    /// <p>The hard limit (in MiB) of memory to present to the container, instead of the default
    /// value from the task definition. If your container attempts to exceed the memory
    /// specified here, the container is killed. You must also specify a container name.</p>
    pub memory: std::option::Option<i32>,
    /// <p>The soft limit (in MiB) of memory to reserve for the container, instead of the default
    /// value from the task definition. You must also specify a container name.</p>
    pub memory_reservation: std::option::Option<i32>,
    /// <p>The type and amount of a resource to assign to a container, instead of the default
    /// value from the task definition. The only supported resource is a GPU.</p>
    pub resource_requirements:
        std::option::Option<std::vec::Vec<crate::model::ResourceRequirement>>,
}
impl std::fmt::Debug for ContainerOverride {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerOverride");
        formatter.field("name", &self.name);
        formatter.field("command", &self.command);
        formatter.field("environment", &self.environment);
        formatter.field("environment_files", &self.environment_files);
        formatter.field("cpu", &self.cpu);
        formatter.field("memory", &self.memory);
        formatter.field("memory_reservation", &self.memory_reservation);
        formatter.field("resource_requirements", &self.resource_requirements);
        formatter.finish()
    }
}
/// See [`ContainerOverride`](crate::model::ContainerOverride)
pub mod container_override {
    /// A builder for [`ContainerOverride`](crate::model::ContainerOverride)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) command: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) environment: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
        pub(crate) environment_files:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentFile>>,
        pub(crate) cpu: std::option::Option<i32>,
        pub(crate) memory: std::option::Option<i32>,
        pub(crate) memory_reservation: std::option::Option<i32>,
        pub(crate) resource_requirements:
            std::option::Option<std::vec::Vec<crate::model::ResourceRequirement>>,
    }
    impl Builder {
        /// <p>The name of the container that receives the override. This parameter is required if
        /// any override is specified.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the container that receives the override. This parameter is required if
        /// any override is specified.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `command`.
        ///
        /// To override the contents of this collection use [`set_command`](Self::set_command).
        ///
        /// <p>The command to send to the container that overrides the default command from the
        /// Docker image or the task definition. You must also specify a container name.</p>
        pub fn command(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.command.unwrap_or_default();
            v.push(input.into());
            self.command = Some(v);
            self
        }
        /// <p>The command to send to the container that overrides the default command from the
        /// Docker image or the task definition. You must also specify a container name.</p>
        pub fn set_command(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.command = input;
            self
        }
        /// Appends an item to `environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>The environment variables to send to the container. You can add new environment
        /// variables, which are added to the container at launch, or you can override the existing
        /// environment variables from the Docker image or the task definition. You must also
        /// specify a container name.</p>
        pub fn environment(mut self, input: impl Into<crate::model::KeyValuePair>) -> Self {
            let mut v = self.environment.unwrap_or_default();
            v.push(input.into());
            self.environment = Some(v);
            self
        }
        /// <p>The environment variables to send to the container. You can add new environment
        /// variables, which are added to the container at launch, or you can override the existing
        /// environment variables from the Docker image or the task definition. You must also
        /// specify a container name.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Appends an item to `environment_files`.
        ///
        /// To override the contents of this collection use [`set_environment_files`](Self::set_environment_files).
        ///
        /// <p>A list of files containing the environment variables to pass to a container, instead
        /// of the value from the container definition.</p>
        pub fn environment_files(
            mut self,
            input: impl Into<crate::model::EnvironmentFile>,
        ) -> Self {
            let mut v = self.environment_files.unwrap_or_default();
            v.push(input.into());
            self.environment_files = Some(v);
            self
        }
        /// <p>A list of files containing the environment variables to pass to a container, instead
        /// of the value from the container definition.</p>
        pub fn set_environment_files(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentFile>>,
        ) -> Self {
            self.environment_files = input;
            self
        }
        /// <p>The number of <code>cpu</code> units reserved for the container, instead of the
        /// default value from the task definition. You must also specify a container name.</p>
        pub fn cpu(mut self, input: i32) -> Self {
            self.cpu = Some(input);
            self
        }
        /// <p>The number of <code>cpu</code> units reserved for the container, instead of the
        /// default value from the task definition. You must also specify a container name.</p>
        pub fn set_cpu(mut self, input: std::option::Option<i32>) -> Self {
            self.cpu = input;
            self
        }
        /// <p>The hard limit (in MiB) of memory to present to the container, instead of the default
        /// value from the task definition. If your container attempts to exceed the memory
        /// specified here, the container is killed. You must also specify a container name.</p>
        pub fn memory(mut self, input: i32) -> Self {
            self.memory = Some(input);
            self
        }
        /// <p>The hard limit (in MiB) of memory to present to the container, instead of the default
        /// value from the task definition. If your container attempts to exceed the memory
        /// specified here, the container is killed. You must also specify a container name.</p>
        pub fn set_memory(mut self, input: std::option::Option<i32>) -> Self {
            self.memory = input;
            self
        }
        /// <p>The soft limit (in MiB) of memory to reserve for the container, instead of the default
        /// value from the task definition. You must also specify a container name.</p>
        pub fn memory_reservation(mut self, input: i32) -> Self {
            self.memory_reservation = Some(input);
            self
        }
        /// <p>The soft limit (in MiB) of memory to reserve for the container, instead of the default
        /// value from the task definition. You must also specify a container name.</p>
        pub fn set_memory_reservation(mut self, input: std::option::Option<i32>) -> Self {
            self.memory_reservation = input;
            self
        }
        /// Appends an item to `resource_requirements`.
        ///
        /// To override the contents of this collection use [`set_resource_requirements`](Self::set_resource_requirements).
        ///
        /// <p>The type and amount of a resource to assign to a container, instead of the default
        /// value from the task definition. The only supported resource is a GPU.</p>
        pub fn resource_requirements(
            mut self,
            input: impl Into<crate::model::ResourceRequirement>,
        ) -> Self {
            let mut v = self.resource_requirements.unwrap_or_default();
            v.push(input.into());
            self.resource_requirements = Some(v);
            self
        }
        /// <p>The type and amount of a resource to assign to a container, instead of the default
        /// value from the task definition. The only supported resource is a GPU.</p>
        pub fn set_resource_requirements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceRequirement>>,
        ) -> Self {
            self.resource_requirements = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerOverride`](crate::model::ContainerOverride)
        pub fn build(self) -> crate::model::ContainerOverride {
            crate::model::ContainerOverride {
                name: self.name,
                command: self.command,
                environment: self.environment,
                environment_files: self.environment_files,
                cpu: self.cpu,
                memory: self.memory,
                memory_reservation: self.memory_reservation,
                resource_requirements: self.resource_requirements,
            }
        }
    }
}
impl ContainerOverride {
    /// Creates a new builder-style object to manufacture [`ContainerOverride`](crate::model::ContainerOverride)
    pub fn builder() -> crate::model::container_override::Builder {
        crate::model::container_override::Builder::default()
    }
}

/// <p>The type and amount of a resource to assign to a container. The supported resource
/// types are GPUs and Elastic Inference accelerators. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-gpu.html">Working with
/// GPUs on Amazon ECS</a> or <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-inference.html">Working with Amazon Elastic Inference on Amazon ECS</a> in the
/// <i>Amazon Elastic Container Service Developer Guide</i>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceRequirement {
    /// <p>The value for the specified resource type.</p>
    /// <p>If the <code>GPU</code> type is used, the value is the number of physical
    /// <code>GPUs</code> the Amazon ECS container agent will reserve for the container. The
    /// number of GPUs reserved for all containers in a task should not exceed the number of
    /// available GPUs on the container instance the task is launched on.</p>
    /// <p>If the <code>InferenceAccelerator</code> type is used, the <code>value</code> should
    /// match the <code>deviceName</code> for an <a>InferenceAccelerator</a>
    /// specified in a task definition.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The type of resource to assign to a container. The supported values are
    /// <code>GPU</code> or <code>InferenceAccelerator</code>.</p>
    pub r#type: std::option::Option<crate::model::ResourceType>,
}
impl std::fmt::Debug for ResourceRequirement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceRequirement");
        formatter.field("value", &self.value);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`ResourceRequirement`](crate::model::ResourceRequirement)
pub mod resource_requirement {
    /// A builder for [`ResourceRequirement`](crate::model::ResourceRequirement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ResourceType>,
    }
    impl Builder {
        /// <p>The value for the specified resource type.</p>
        /// <p>If the <code>GPU</code> type is used, the value is the number of physical
        /// <code>GPUs</code> the Amazon ECS container agent will reserve for the container. The
        /// number of GPUs reserved for all containers in a task should not exceed the number of
        /// available GPUs on the container instance the task is launched on.</p>
        /// <p>If the <code>InferenceAccelerator</code> type is used, the <code>value</code> should
        /// match the <code>deviceName</code> for an <a>InferenceAccelerator</a>
        /// specified in a task definition.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value for the specified resource type.</p>
        /// <p>If the <code>GPU</code> type is used, the value is the number of physical
        /// <code>GPUs</code> the Amazon ECS container agent will reserve for the container. The
        /// number of GPUs reserved for all containers in a task should not exceed the number of
        /// available GPUs on the container instance the task is launched on.</p>
        /// <p>If the <code>InferenceAccelerator</code> type is used, the <code>value</code> should
        /// match the <code>deviceName</code> for an <a>InferenceAccelerator</a>
        /// specified in a task definition.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The type of resource to assign to a container. The supported values are
        /// <code>GPU</code> or <code>InferenceAccelerator</code>.</p>
        pub fn r#type(mut self, input: crate::model::ResourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of resource to assign to a container. The supported values are
        /// <code>GPU</code> or <code>InferenceAccelerator</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ResourceType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceRequirement`](crate::model::ResourceRequirement)
        pub fn build(self) -> crate::model::ResourceRequirement {
            crate::model::ResourceRequirement {
                value: self.value,
                r#type: self.r#type,
            }
        }
    }
}
impl ResourceRequirement {
    /// Creates a new builder-style object to manufacture [`ResourceRequirement`](crate::model::ResourceRequirement)
    pub fn builder() -> crate::model::resource_requirement::Builder {
        crate::model::resource_requirement::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Gpu,
    #[allow(missing_docs)] // documentation missing in model
    InferenceAccelerator,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "GPU" => ResourceType::Gpu,
            "InferenceAccelerator" => ResourceType::InferenceAccelerator,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::Gpu => "GPU",
            ResourceType::InferenceAccelerator => "InferenceAccelerator",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GPU", "InferenceAccelerator"]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A list of files containing the environment variables to pass to a container. You can
/// specify up to ten environment files. The file must have a <code>.env</code> file
/// extension. Each line in an environment file should contain an environment variable in
/// <code>VARIABLE=VALUE</code> format. Lines beginning with <code>#</code> are treated
/// as comments and are ignored. For more information on the environment variable file
/// syntax, see <a href="https://docs.docker.com/compose/env-file/">Declare default
/// environment variables in file</a>.</p>
/// <p>If there are environment variables specified using the <code>environment</code>
/// parameter in a container definition, they take precedence over the variables contained
/// within an environment file. If multiple environment files are specified that contain the
/// same variable, they are processed from the top down. It is recommended to use unique
/// variable names. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html">Specifying environment
/// variables</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
/// <p>This parameter is only supported for tasks hosted on Fargate using the following platform versions:</p>
/// <ul>
/// <li>
/// <p>Linux platform
/// version <code>1.4.0</code> or later.</p>
/// </li>
/// <li>
/// <p>Windows platform
/// version <code>1.0.0</code> or later.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentFile {
    /// <p>The Amazon Resource Name (ARN) of the Amazon S3 object containing the environment
    /// variable file.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The file type to use. The only supported value is <code>s3</code>.</p>
    pub r#type: std::option::Option<crate::model::EnvironmentFileType>,
}
impl std::fmt::Debug for EnvironmentFile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentFile");
        formatter.field("value", &self.value);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`EnvironmentFile`](crate::model::EnvironmentFile)
pub mod environment_file {
    /// A builder for [`EnvironmentFile`](crate::model::EnvironmentFile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::EnvironmentFileType>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon S3 object containing the environment
        /// variable file.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon S3 object containing the environment
        /// variable file.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The file type to use. The only supported value is <code>s3</code>.</p>
        pub fn r#type(mut self, input: crate::model::EnvironmentFileType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The file type to use. The only supported value is <code>s3</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::EnvironmentFileType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentFile`](crate::model::EnvironmentFile)
        pub fn build(self) -> crate::model::EnvironmentFile {
            crate::model::EnvironmentFile {
                value: self.value,
                r#type: self.r#type,
            }
        }
    }
}
impl EnvironmentFile {
    /// Creates a new builder-style object to manufacture [`EnvironmentFile`](crate::model::EnvironmentFile)
    pub fn builder() -> crate::model::environment_file::Builder {
        crate::model::environment_file::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnvironmentFileType {
    #[allow(missing_docs)] // documentation missing in model
    S3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnvironmentFileType {
    fn from(s: &str) -> Self {
        match s {
            "s3" => EnvironmentFileType::S3,
            other => EnvironmentFileType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnvironmentFileType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnvironmentFileType::from(s))
    }
}
impl EnvironmentFileType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnvironmentFileType::S3 => "s3",
            EnvironmentFileType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["s3"]
    }
}
impl AsRef<str> for EnvironmentFileType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details on a Elastic Inference accelerator. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-inference.html">Working with
/// Amazon Elastic Inference on Amazon ECS</a> in the
/// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InferenceAccelerator {
    /// <p>The Elastic Inference accelerator device name. The <code>deviceName</code> must also
    /// be referenced in a container definition as a <a>ResourceRequirement</a>.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>The Elastic Inference accelerator type to use.</p>
    pub device_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InferenceAccelerator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InferenceAccelerator");
        formatter.field("device_name", &self.device_name);
        formatter.field("device_type", &self.device_type);
        formatter.finish()
    }
}
/// See [`InferenceAccelerator`](crate::model::InferenceAccelerator)
pub mod inference_accelerator {
    /// A builder for [`InferenceAccelerator`](crate::model::InferenceAccelerator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) device_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Elastic Inference accelerator device name. The <code>deviceName</code> must also
        /// be referenced in a container definition as a <a>ResourceRequirement</a>.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The Elastic Inference accelerator device name. The <code>deviceName</code> must also
        /// be referenced in a container definition as a <a>ResourceRequirement</a>.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>The Elastic Inference accelerator type to use.</p>
        pub fn device_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_type = Some(input.into());
            self
        }
        /// <p>The Elastic Inference accelerator type to use.</p>
        pub fn set_device_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_type = input;
            self
        }
        /// Consumes the builder and constructs a [`InferenceAccelerator`](crate::model::InferenceAccelerator)
        pub fn build(self) -> crate::model::InferenceAccelerator {
            crate::model::InferenceAccelerator {
                device_name: self.device_name,
                device_type: self.device_type,
            }
        }
    }
}
impl InferenceAccelerator {
    /// Creates a new builder-style object to manufacture [`InferenceAccelerator`](crate::model::InferenceAccelerator)
    pub fn builder() -> crate::model::inference_accelerator::Builder {
        crate::model::inference_accelerator::Builder::default()
    }
}

/// _Note: `HealthStatus::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HealthStatus {
    #[allow(missing_docs)] // documentation missing in model
    Healthy,
    #[allow(missing_docs)] // documentation missing in model
    Unhealthy,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HealthStatus {
    fn from(s: &str) -> Self {
        match s {
            "HEALTHY" => HealthStatus::Healthy,
            "UNHEALTHY" => HealthStatus::Unhealthy,
            "UNKNOWN" => HealthStatus::UnknownValue,
            other => HealthStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HealthStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HealthStatus::from(s))
    }
}
impl HealthStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HealthStatus::Healthy => "HEALTHY",
            HealthStatus::Unhealthy => "UNHEALTHY",
            HealthStatus::UnknownValue => "UNKNOWN",
            HealthStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HEALTHY", "UNHEALTHY", "UNKNOWN"]
    }
}
impl AsRef<str> for HealthStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A Docker container that is part of a task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Container {
    /// <p>The Amazon Resource Name (ARN) of the container.</p>
    pub container_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the task.</p>
    pub task_arn: std::option::Option<std::string::String>,
    /// <p>The name of the container.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The image used for the container.</p>
    pub image: std::option::Option<std::string::String>,
    /// <p>The container image manifest digest.</p>
    /// <note>
    /// <p>The <code>imageDigest</code> is only returned if the container is using an image
    /// hosted in Amazon ECR, otherwise it is omitted.</p>
    /// </note>
    pub image_digest: std::option::Option<std::string::String>,
    /// <p>The ID of the Docker container.</p>
    pub runtime_id: std::option::Option<std::string::String>,
    /// <p>The last known status of the container.</p>
    pub last_status: std::option::Option<std::string::String>,
    /// <p>The exit code returned from the container.</p>
    pub exit_code: std::option::Option<i32>,
    /// <p>A short (255 max characters) human-readable string to provide additional details about
    /// a running or stopped container.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>The network bindings associated with the container.</p>
    pub network_bindings: std::option::Option<std::vec::Vec<crate::model::NetworkBinding>>,
    /// <p>The network interfaces associated with the container.</p>
    pub network_interfaces: std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
    /// <p>The health status of the container. If health checks are not configured for this
    /// container in its task definition, then it reports the health status as
    /// <code>UNKNOWN</code>.</p>
    pub health_status: std::option::Option<crate::model::HealthStatus>,
    /// <p>The details of any Amazon ECS managed agents associated with the container.</p>
    pub managed_agents: std::option::Option<std::vec::Vec<crate::model::ManagedAgent>>,
    /// <p>The number of CPU units set for the container. The value will be <code>0</code> if no
    /// value was specified in the container definition when the task definition was
    /// registered.</p>
    pub cpu: std::option::Option<std::string::String>,
    /// <p>The hard limit (in MiB) of memory set for the container.</p>
    pub memory: std::option::Option<std::string::String>,
    /// <p>The soft limit (in MiB) of memory set for the container.</p>
    pub memory_reservation: std::option::Option<std::string::String>,
    /// <p>The IDs of each GPU assigned to the container.</p>
    pub gpu_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for Container {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Container");
        formatter.field("container_arn", &self.container_arn);
        formatter.field("task_arn", &self.task_arn);
        formatter.field("name", &self.name);
        formatter.field("image", &self.image);
        formatter.field("image_digest", &self.image_digest);
        formatter.field("runtime_id", &self.runtime_id);
        formatter.field("last_status", &self.last_status);
        formatter.field("exit_code", &self.exit_code);
        formatter.field("reason", &self.reason);
        formatter.field("network_bindings", &self.network_bindings);
        formatter.field("network_interfaces", &self.network_interfaces);
        formatter.field("health_status", &self.health_status);
        formatter.field("managed_agents", &self.managed_agents);
        formatter.field("cpu", &self.cpu);
        formatter.field("memory", &self.memory);
        formatter.field("memory_reservation", &self.memory_reservation);
        formatter.field("gpu_ids", &self.gpu_ids);
        formatter.finish()
    }
}
/// See [`Container`](crate::model::Container)
pub mod container {
    /// A builder for [`Container`](crate::model::Container)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_arn: std::option::Option<std::string::String>,
        pub(crate) task_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) image: std::option::Option<std::string::String>,
        pub(crate) image_digest: std::option::Option<std::string::String>,
        pub(crate) runtime_id: std::option::Option<std::string::String>,
        pub(crate) last_status: std::option::Option<std::string::String>,
        pub(crate) exit_code: std::option::Option<i32>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) network_bindings:
            std::option::Option<std::vec::Vec<crate::model::NetworkBinding>>,
        pub(crate) network_interfaces:
            std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
        pub(crate) health_status: std::option::Option<crate::model::HealthStatus>,
        pub(crate) managed_agents: std::option::Option<std::vec::Vec<crate::model::ManagedAgent>>,
        pub(crate) cpu: std::option::Option<std::string::String>,
        pub(crate) memory: std::option::Option<std::string::String>,
        pub(crate) memory_reservation: std::option::Option<std::string::String>,
        pub(crate) gpu_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the container.</p>
        pub fn container_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container.</p>
        pub fn set_container_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_arn = input;
            self
        }
        /// <p>The ARN of the task.</p>
        pub fn task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the task.</p>
        pub fn set_task_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_arn = input;
            self
        }
        /// <p>The name of the container.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the container.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The image used for the container.</p>
        pub fn image(mut self, input: impl Into<std::string::String>) -> Self {
            self.image = Some(input.into());
            self
        }
        /// <p>The image used for the container.</p>
        pub fn set_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image = input;
            self
        }
        /// <p>The container image manifest digest.</p>
        /// <note>
        /// <p>The <code>imageDigest</code> is only returned if the container is using an image
        /// hosted in Amazon ECR, otherwise it is omitted.</p>
        /// </note>
        pub fn image_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_digest = Some(input.into());
            self
        }
        /// <p>The container image manifest digest.</p>
        /// <note>
        /// <p>The <code>imageDigest</code> is only returned if the container is using an image
        /// hosted in Amazon ECR, otherwise it is omitted.</p>
        /// </note>
        pub fn set_image_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_digest = input;
            self
        }
        /// <p>The ID of the Docker container.</p>
        pub fn runtime_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.runtime_id = Some(input.into());
            self
        }
        /// <p>The ID of the Docker container.</p>
        pub fn set_runtime_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.runtime_id = input;
            self
        }
        /// <p>The last known status of the container.</p>
        pub fn last_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_status = Some(input.into());
            self
        }
        /// <p>The last known status of the container.</p>
        pub fn set_last_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_status = input;
            self
        }
        /// <p>The exit code returned from the container.</p>
        pub fn exit_code(mut self, input: i32) -> Self {
            self.exit_code = Some(input);
            self
        }
        /// <p>The exit code returned from the container.</p>
        pub fn set_exit_code(mut self, input: std::option::Option<i32>) -> Self {
            self.exit_code = input;
            self
        }
        /// <p>A short (255 max characters) human-readable string to provide additional details about
        /// a running or stopped container.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>A short (255 max characters) human-readable string to provide additional details about
        /// a running or stopped container.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `network_bindings`.
        ///
        /// To override the contents of this collection use [`set_network_bindings`](Self::set_network_bindings).
        ///
        /// <p>The network bindings associated with the container.</p>
        pub fn network_bindings(mut self, input: impl Into<crate::model::NetworkBinding>) -> Self {
            let mut v = self.network_bindings.unwrap_or_default();
            v.push(input.into());
            self.network_bindings = Some(v);
            self
        }
        /// <p>The network bindings associated with the container.</p>
        pub fn set_network_bindings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkBinding>>,
        ) -> Self {
            self.network_bindings = input;
            self
        }
        /// Appends an item to `network_interfaces`.
        ///
        /// To override the contents of this collection use [`set_network_interfaces`](Self::set_network_interfaces).
        ///
        /// <p>The network interfaces associated with the container.</p>
        pub fn network_interfaces(
            mut self,
            input: impl Into<crate::model::NetworkInterface>,
        ) -> Self {
            let mut v = self.network_interfaces.unwrap_or_default();
            v.push(input.into());
            self.network_interfaces = Some(v);
            self
        }
        /// <p>The network interfaces associated with the container.</p>
        pub fn set_network_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
        ) -> Self {
            self.network_interfaces = input;
            self
        }
        /// <p>The health status of the container. If health checks are not configured for this
        /// container in its task definition, then it reports the health status as
        /// <code>UNKNOWN</code>.</p>
        pub fn health_status(mut self, input: crate::model::HealthStatus) -> Self {
            self.health_status = Some(input);
            self
        }
        /// <p>The health status of the container. If health checks are not configured for this
        /// container in its task definition, then it reports the health status as
        /// <code>UNKNOWN</code>.</p>
        pub fn set_health_status(
            mut self,
            input: std::option::Option<crate::model::HealthStatus>,
        ) -> Self {
            self.health_status = input;
            self
        }
        /// Appends an item to `managed_agents`.
        ///
        /// To override the contents of this collection use [`set_managed_agents`](Self::set_managed_agents).
        ///
        /// <p>The details of any Amazon ECS managed agents associated with the container.</p>
        pub fn managed_agents(mut self, input: impl Into<crate::model::ManagedAgent>) -> Self {
            let mut v = self.managed_agents.unwrap_or_default();
            v.push(input.into());
            self.managed_agents = Some(v);
            self
        }
        /// <p>The details of any Amazon ECS managed agents associated with the container.</p>
        pub fn set_managed_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ManagedAgent>>,
        ) -> Self {
            self.managed_agents = input;
            self
        }
        /// <p>The number of CPU units set for the container. The value will be <code>0</code> if no
        /// value was specified in the container definition when the task definition was
        /// registered.</p>
        pub fn cpu(mut self, input: impl Into<std::string::String>) -> Self {
            self.cpu = Some(input.into());
            self
        }
        /// <p>The number of CPU units set for the container. The value will be <code>0</code> if no
        /// value was specified in the container definition when the task definition was
        /// registered.</p>
        pub fn set_cpu(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cpu = input;
            self
        }
        /// <p>The hard limit (in MiB) of memory set for the container.</p>
        pub fn memory(mut self, input: impl Into<std::string::String>) -> Self {
            self.memory = Some(input.into());
            self
        }
        /// <p>The hard limit (in MiB) of memory set for the container.</p>
        pub fn set_memory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.memory = input;
            self
        }
        /// <p>The soft limit (in MiB) of memory set for the container.</p>
        pub fn memory_reservation(mut self, input: impl Into<std::string::String>) -> Self {
            self.memory_reservation = Some(input.into());
            self
        }
        /// <p>The soft limit (in MiB) of memory set for the container.</p>
        pub fn set_memory_reservation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.memory_reservation = input;
            self
        }
        /// Appends an item to `gpu_ids`.
        ///
        /// To override the contents of this collection use [`set_gpu_ids`](Self::set_gpu_ids).
        ///
        /// <p>The IDs of each GPU assigned to the container.</p>
        pub fn gpu_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.gpu_ids.unwrap_or_default();
            v.push(input.into());
            self.gpu_ids = Some(v);
            self
        }
        /// <p>The IDs of each GPU assigned to the container.</p>
        pub fn set_gpu_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.gpu_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`Container`](crate::model::Container)
        pub fn build(self) -> crate::model::Container {
            crate::model::Container {
                container_arn: self.container_arn,
                task_arn: self.task_arn,
                name: self.name,
                image: self.image,
                image_digest: self.image_digest,
                runtime_id: self.runtime_id,
                last_status: self.last_status,
                exit_code: self.exit_code,
                reason: self.reason,
                network_bindings: self.network_bindings,
                network_interfaces: self.network_interfaces,
                health_status: self.health_status,
                managed_agents: self.managed_agents,
                cpu: self.cpu,
                memory: self.memory,
                memory_reservation: self.memory_reservation,
                gpu_ids: self.gpu_ids,
            }
        }
    }
}
impl Container {
    /// Creates a new builder-style object to manufacture [`Container`](crate::model::Container)
    pub fn builder() -> crate::model::container::Builder {
        crate::model::container::Builder::default()
    }
}

/// <p>Details about the managed agent status for the container.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ManagedAgent {
    /// <p>The Unix timestamp for when the managed agent was last started.</p>
    pub last_started_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the managed agent. When the execute command feature is enabled, the
    /// managed agent name is <code>ExecuteCommandAgent</code>.</p>
    pub name: std::option::Option<crate::model::ManagedAgentName>,
    /// <p>The reason for why the managed agent is in the state it is in.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>The last known status of the managed agent.</p>
    pub last_status: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ManagedAgent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ManagedAgent");
        formatter.field("last_started_at", &self.last_started_at);
        formatter.field("name", &self.name);
        formatter.field("reason", &self.reason);
        formatter.field("last_status", &self.last_status);
        formatter.finish()
    }
}
/// See [`ManagedAgent`](crate::model::ManagedAgent)
pub mod managed_agent {
    /// A builder for [`ManagedAgent`](crate::model::ManagedAgent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_started_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) name: std::option::Option<crate::model::ManagedAgentName>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) last_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Unix timestamp for when the managed agent was last started.</p>
        pub fn last_started_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_started_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the managed agent was last started.</p>
        pub fn set_last_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_started_at = input;
            self
        }
        /// <p>The name of the managed agent. When the execute command feature is enabled, the
        /// managed agent name is <code>ExecuteCommandAgent</code>.</p>
        pub fn name(mut self, input: crate::model::ManagedAgentName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the managed agent. When the execute command feature is enabled, the
        /// managed agent name is <code>ExecuteCommandAgent</code>.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::ManagedAgentName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The reason for why the managed agent is in the state it is in.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason for why the managed agent is in the state it is in.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// <p>The last known status of the managed agent.</p>
        pub fn last_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_status = Some(input.into());
            self
        }
        /// <p>The last known status of the managed agent.</p>
        pub fn set_last_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ManagedAgent`](crate::model::ManagedAgent)
        pub fn build(self) -> crate::model::ManagedAgent {
            crate::model::ManagedAgent {
                last_started_at: self.last_started_at,
                name: self.name,
                reason: self.reason,
                last_status: self.last_status,
            }
        }
    }
}
impl ManagedAgent {
    /// Creates a new builder-style object to manufacture [`ManagedAgent`](crate::model::ManagedAgent)
    pub fn builder() -> crate::model::managed_agent::Builder {
        crate::model::managed_agent::Builder::default()
    }
}

/// <p>An object representing the elastic network interface for tasks that use the
/// <code>awsvpc</code> network mode.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkInterface {
    /// <p>The attachment ID for the network interface.</p>
    pub attachment_id: std::option::Option<std::string::String>,
    /// <p>The private IPv4 address for the network interface.</p>
    pub private_ipv4_address: std::option::Option<std::string::String>,
    /// <p>The private IPv6 address for the network interface.</p>
    pub ipv6_address: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NetworkInterface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkInterface");
        formatter.field("attachment_id", &self.attachment_id);
        formatter.field("private_ipv4_address", &self.private_ipv4_address);
        formatter.field("ipv6_address", &self.ipv6_address);
        formatter.finish()
    }
}
/// See [`NetworkInterface`](crate::model::NetworkInterface)
pub mod network_interface {
    /// A builder for [`NetworkInterface`](crate::model::NetworkInterface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attachment_id: std::option::Option<std::string::String>,
        pub(crate) private_ipv4_address: std::option::Option<std::string::String>,
        pub(crate) ipv6_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The attachment ID for the network interface.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attachment_id = Some(input.into());
            self
        }
        /// <p>The attachment ID for the network interface.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attachment_id = input;
            self
        }
        /// <p>The private IPv4 address for the network interface.</p>
        pub fn private_ipv4_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ipv4_address = Some(input.into());
            self
        }
        /// <p>The private IPv4 address for the network interface.</p>
        pub fn set_private_ipv4_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ipv4_address = input;
            self
        }
        /// <p>The private IPv6 address for the network interface.</p>
        pub fn ipv6_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ipv6_address = Some(input.into());
            self
        }
        /// <p>The private IPv6 address for the network interface.</p>
        pub fn set_ipv6_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ipv6_address = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkInterface`](crate::model::NetworkInterface)
        pub fn build(self) -> crate::model::NetworkInterface {
            crate::model::NetworkInterface {
                attachment_id: self.attachment_id,
                private_ipv4_address: self.private_ipv4_address,
                ipv6_address: self.ipv6_address,
            }
        }
    }
}
impl NetworkInterface {
    /// Creates a new builder-style object to manufacture [`NetworkInterface`](crate::model::NetworkInterface)
    pub fn builder() -> crate::model::network_interface::Builder {
        crate::model::network_interface::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Connectivity {
    #[allow(missing_docs)] // documentation missing in model
    Connected,
    #[allow(missing_docs)] // documentation missing in model
    Disconnected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Connectivity {
    fn from(s: &str) -> Self {
        match s {
            "CONNECTED" => Connectivity::Connected,
            "DISCONNECTED" => Connectivity::Disconnected,
            other => Connectivity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Connectivity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Connectivity::from(s))
    }
}
impl Connectivity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Connectivity::Connected => "CONNECTED",
            Connectivity::Disconnected => "DISCONNECTED",
            Connectivity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONNECTED", "DISCONNECTED"]
    }
}
impl AsRef<str> for Connectivity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details of a task definition which describes the container and volume definitions
/// of an Amazon Elastic Container Service task. You can specify which Docker images to use, the required
/// resources, and other configurations related to launching the task definition through an
/// Amazon ECS service or task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskDefinition {
    /// <p>The full Amazon Resource Name (ARN) of the task definition.</p>
    pub task_definition_arn: std::option::Option<std::string::String>,
    /// <p>A list of container definitions in JSON format that describe the different containers
    /// that make up your task. For more information about container definition parameters and
    /// defaults, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Amazon ECS Task
    /// Definitions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub container_definitions:
        std::option::Option<std::vec::Vec<crate::model::ContainerDefinition>>,
    /// <p>The name of a family that this task definition is registered to. Up to 255 letters
    /// (uppercase and lowercase), numbers, hyphens, and underscores are allowed.</p>
    /// <p>A family groups multiple versions of a task definition. Amazon ECS gives the first task
    /// definition that you registered to a family a revision number of 1. Amazon ECS gives
    /// sequential revision numbers to each task definition that you add.</p>
    pub family: std::option::Option<std::string::String>,
    /// <p>The short name or full Amazon Resource Name (ARN) of the Identity and Access Management role that grants containers in the
    /// task permission to call Amazon Web Services APIs on your behalf. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">Amazon ECS
    /// Task Role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>IAM roles for tasks on Windows require that the <code>-EnableTaskIAMRole</code> option
    /// is set when you launch the Amazon ECS-optimized Windows AMI. Your containers must also run some
    /// configuration code in order to take advantage of the feature. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows_task_IAM_roles.html">Windows IAM roles
    /// for tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub task_role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent
    /// permission to make Amazon Web Services API calls on your behalf. The task execution IAM role is required
    /// depending on the requirements of your task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task
    /// execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>The Docker networking mode to use for the containers in the task. The valid values are
    /// <code>none</code>, <code>bridge</code>, <code>awsvpc</code>, and <code>host</code>.
    /// If no network mode is specified, the default is <code>bridge</code>.</p>
    /// <p>For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required.
    /// For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used.  For Amazon ECS tasks on Amazon EC2 Windows instances, <code><default></code> or <code>awsvpc</code> can be used. If the network
    /// mode is set to <code>none</code>, you cannot specify port mappings in your container
    /// definitions, and the tasks containers do not have external connectivity. The
    /// <code>host</code> and <code>awsvpc</code> network modes offer the highest networking
    /// performance for containers because they use the EC2 network stack instead of the
    /// virtualized network stack provided by the <code>bridge</code> mode.</p>
    /// <p>With the <code>host</code> and <code>awsvpc</code> network modes, exposed container
    /// ports are mapped directly to the corresponding host port (for the <code>host</code>
    /// network mode) or the attached elastic network interface port (for the
    /// <code>awsvpc</code> network mode), so you cannot take advantage of dynamic host port
    /// mappings. </p>
    /// <important>
    /// <p>When using the <code>host</code> network mode, you should not run
    /// containers using the root user (UID 0). It is considered best practice
    /// to use a non-root user.</p>
    /// </important>
    /// <p>If the network mode is <code>awsvpc</code>, the task is allocated an elastic network
    /// interface, and you must specify a <a>NetworkConfiguration</a> value when you create
    /// a service or run a task with the task definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the
    /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>If the network mode is <code>host</code>, you cannot run multiple instantiations of the
    /// same task on a single container instance when port mappings are used.</p>
    /// <p>For more information, see <a href="https://docs.docker.com/engine/reference/run/#network-settings">Network
    /// settings</a> in the <i>Docker run reference</i>.</p>
    pub network_mode: std::option::Option<crate::model::NetworkMode>,
    /// <p>The revision of the task in a particular family. The revision is a version number of a
    /// task definition in a family. When you register a task definition for the first time, the
    /// revision is <code>1</code>. Each time that you register a new revision of a task
    /// definition in the same family, the revision value always increases by one, even if you
    /// have deregistered previous revisions in this family.</p>
    pub revision: i32,
    /// <p>The list of data volume definitions for the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html">Using data volumes in tasks</a> in the
    /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <note>
    /// <p>The <code>host</code> and <code>sourcePath</code> parameters are not supported for
    /// tasks run on Fargate.</p>
    /// </note>
    pub volumes: std::option::Option<std::vec::Vec<crate::model::Volume>>,
    /// <p>The status of the task definition.</p>
    pub status: std::option::Option<crate::model::TaskDefinitionStatus>,
    /// <p>The container instance attributes required by your task. When an Amazon EC2 instance is
    /// registered to your cluster, the Amazon ECS container agent assigns some standard attributes
    /// to the instance. You can apply custom attributes, specified as key-value pairs using the
    /// Amazon ECS console or the <a>PutAttributes</a> API. These attributes are used when
    /// considering task placement for tasks hosted on Amazon EC2 instances. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes">Attributes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <note>
    /// <p>This parameter is not supported for tasks run on Fargate.</p>
    /// </note>
    pub requires_attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    /// <p>An array of placement constraint objects to use for tasks.</p>
    /// <note>
    /// <p>This parameter is not supported for tasks run on Fargate.</p>
    /// </note>
    pub placement_constraints:
        std::option::Option<std::vec::Vec<crate::model::TaskDefinitionPlacementConstraint>>,
    /// <p>The task launch types the task definition validated against during task definition
    /// registration. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a>
    /// in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub compatibilities: std::option::Option<std::vec::Vec<crate::model::Compatibility>>,
    /// <p>The operating system  that your task definitions are running on. A platform family is specified only for tasks using the Fargate launch type. </p>
    /// <p>When you specify a task in a service, this value must match the <code>runtimePlatform</code> value of the service.</p>
    pub runtime_platform: std::option::Option<crate::model::RuntimePlatform>,
    /// <p>The task launch types the task definition was validated against. To determine which
    /// task launch types the task definition is validated for, see the <a>TaskDefinition$compatibilities</a> parameter.</p>
    pub requires_compatibilities: std::option::Option<std::vec::Vec<crate::model::Compatibility>>,
    /// <p>The number of <code>cpu</code> units used by the task. If you are using the EC2 launch
    /// type, this field is optional and any value can be used. If you are using the Fargate
    /// launch type, this field is required and you must use one of the following values, which
    /// determines your range of valid values for the <code>memory</code> parameter:</p>
    /// <ul>
    /// <li>
    /// <p>256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)</p>
    /// </li>
    /// <li>
    /// <p>512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)</p>
    /// </li>
    /// <li>
    /// <p>1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)</p>
    /// </li>
    /// <li>
    /// <p>2048 (2 vCPU) - Available <code>memory</code> values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)</p>
    /// </li>
    /// <li>
    /// <p>4096 (4 vCPU) - Available <code>memory</code> values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)</p>
    /// </li>
    /// </ul>
    pub cpu: std::option::Option<std::string::String>,
    /// <p>The amount (in MiB) of memory used by the task.</p>
    /// <p>If your tasks will be run on Amazon EC2 instances, you must specify either a task-level
    /// memory value or a container-level memory value. This field is optional and any value can
    /// be used. If a task-level memory value is specified then the container-level memory value
    /// is optional. For more information regarding container-level memory and memory
    /// reservation, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html">ContainerDefinition</a>.</p>
    /// <p>If your tasks will be run on Fargate, this field is required and you must use one of
    /// the following values, which determines your range of valid values for the
    /// <code>cpu</code> parameter:</p>
    /// <ul>
    /// <li>
    /// <p>512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)</p>
    /// </li>
    /// <li>
    /// <p>1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)</p>
    /// </li>
    /// <li>
    /// <p>2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available <code>cpu</code> values: 1024 (1 vCPU)</p>
    /// </li>
    /// <li>
    /// <p>Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2 vCPU)</p>
    /// </li>
    /// <li>
    /// <p>Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4 vCPU)</p>
    /// </li>
    /// </ul>
    pub memory: std::option::Option<std::string::String>,
    /// <p>The Elastic Inference accelerator associated with the task.</p>
    pub inference_accelerators:
        std::option::Option<std::vec::Vec<crate::model::InferenceAccelerator>>,
    /// <p>The process namespace to use for the containers in the task. The valid
    /// values are <code>host</code> or <code>task</code>. If <code>host</code>
    /// is specified, then all containers within the tasks that specified the
    /// <code>host</code> PID mode on the same container instance share the
    /// same process namespace with the host Amazon EC2 instance. If <code>task</code> is
    /// specified, all containers within the specified task share the same
    /// process namespace. If no value is specified, the default is a private
    /// namespace. For more information, see <a href="https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the <i>Docker run
    /// reference</i>.</p>
    /// <p>If the <code>host</code> PID mode is used, be aware that there is a
    /// heightened risk of undesired process namespace expose. For more
    /// information, see <a href="https://docs.docker.com/engine/security/security/">Docker
    /// security</a>.</p>
    /// <note>
    /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
    /// </note>
    pub pid_mode: std::option::Option<crate::model::PidMode>,
    /// <p>The IPC resource namespace to use for the containers in the task. The valid values are
    /// <code>host</code>, <code>task</code>, or <code>none</code>. If <code>host</code> is
    /// specified, then all containers within the tasks that specified the <code>host</code> IPC
    /// mode on the same container instance share the same IPC resources with the host Amazon EC2
    /// instance. If <code>task</code> is specified, all containers within the specified task
    /// share the same IPC resources. If <code>none</code> is specified, then IPC resources
    /// within the containers of a task are private and not shared with other containers in a
    /// task or on the container instance. If no value is specified, then the IPC resource
    /// namespace sharing depends on the Docker daemon setting on the container instance. For
    /// more information, see <a href="https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC
    /// settings</a> in the <i>Docker run reference</i>.</p>
    /// <p>If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of
    /// undesired IPC namespace expose. For more information, see <a href="https://docs.docker.com/engine/security/security/">Docker
    /// security</a>.</p>
    /// <p>If you are setting namespaced kernel parameters using <code>systemControls</code> for
    /// the containers in the task, the following will apply to your IPC resource namespace. For
    /// more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System
    /// Controls</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <ul>
    /// <li>
    /// <p>For tasks that use the <code>host</code> IPC mode, IPC namespace related
    /// <code>systemControls</code> are not supported.</p>
    /// </li>
    /// <li>
    /// <p>For tasks that use the <code>task</code> IPC mode, IPC namespace related
    /// <code>systemControls</code> will apply to all containers within a
    /// task.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
    /// </note>
    pub ipc_mode: std::option::Option<crate::model::IpcMode>,
    /// <p>The configuration details for the App Mesh proxy.</p>
    /// <p>Your Amazon ECS container instances require at least version 1.26.0 of the container agent
    /// and at least version 1.26.0-1 of the <code>ecs-init</code> package to enable a proxy
    /// configuration. If your container instances are launched from the Amazon ECS-optimized AMI
    /// version <code>20190301</code> or later, then they contain the required versions of the
    /// container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub proxy_configuration: std::option::Option<crate::model::ProxyConfiguration>,
    /// <p>The Unix timestamp for when the task definition was registered.</p>
    pub registered_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Unix timestamp for when the task definition was deregistered.</p>
    pub deregistered_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The principal that registered the task definition.</p>
    pub registered_by: std::option::Option<std::string::String>,
    /// <p>The ephemeral storage settings to use for tasks run with the task definition.</p>
    pub ephemeral_storage: std::option::Option<crate::model::EphemeralStorage>,
}
impl std::fmt::Debug for TaskDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskDefinition");
        formatter.field("task_definition_arn", &self.task_definition_arn);
        formatter.field("container_definitions", &self.container_definitions);
        formatter.field("family", &self.family);
        formatter.field("task_role_arn", &self.task_role_arn);
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("network_mode", &self.network_mode);
        formatter.field("revision", &self.revision);
        formatter.field("volumes", &self.volumes);
        formatter.field("status", &self.status);
        formatter.field("requires_attributes", &self.requires_attributes);
        formatter.field("placement_constraints", &self.placement_constraints);
        formatter.field("compatibilities", &self.compatibilities);
        formatter.field("runtime_platform", &self.runtime_platform);
        formatter.field("requires_compatibilities", &self.requires_compatibilities);
        formatter.field("cpu", &self.cpu);
        formatter.field("memory", &self.memory);
        formatter.field("inference_accelerators", &self.inference_accelerators);
        formatter.field("pid_mode", &self.pid_mode);
        formatter.field("ipc_mode", &self.ipc_mode);
        formatter.field("proxy_configuration", &self.proxy_configuration);
        formatter.field("registered_at", &self.registered_at);
        formatter.field("deregistered_at", &self.deregistered_at);
        formatter.field("registered_by", &self.registered_by);
        formatter.field("ephemeral_storage", &self.ephemeral_storage);
        formatter.finish()
    }
}
/// See [`TaskDefinition`](crate::model::TaskDefinition)
pub mod task_definition {
    /// A builder for [`TaskDefinition`](crate::model::TaskDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_definition_arn: std::option::Option<std::string::String>,
        pub(crate) container_definitions:
            std::option::Option<std::vec::Vec<crate::model::ContainerDefinition>>,
        pub(crate) family: std::option::Option<std::string::String>,
        pub(crate) task_role_arn: std::option::Option<std::string::String>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) network_mode: std::option::Option<crate::model::NetworkMode>,
        pub(crate) revision: std::option::Option<i32>,
        pub(crate) volumes: std::option::Option<std::vec::Vec<crate::model::Volume>>,
        pub(crate) status: std::option::Option<crate::model::TaskDefinitionStatus>,
        pub(crate) requires_attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        pub(crate) placement_constraints:
            std::option::Option<std::vec::Vec<crate::model::TaskDefinitionPlacementConstraint>>,
        pub(crate) compatibilities: std::option::Option<std::vec::Vec<crate::model::Compatibility>>,
        pub(crate) runtime_platform: std::option::Option<crate::model::RuntimePlatform>,
        pub(crate) requires_compatibilities:
            std::option::Option<std::vec::Vec<crate::model::Compatibility>>,
        pub(crate) cpu: std::option::Option<std::string::String>,
        pub(crate) memory: std::option::Option<std::string::String>,
        pub(crate) inference_accelerators:
            std::option::Option<std::vec::Vec<crate::model::InferenceAccelerator>>,
        pub(crate) pid_mode: std::option::Option<crate::model::PidMode>,
        pub(crate) ipc_mode: std::option::Option<crate::model::IpcMode>,
        pub(crate) proxy_configuration: std::option::Option<crate::model::ProxyConfiguration>,
        pub(crate) registered_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) deregistered_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) registered_by: std::option::Option<std::string::String>,
        pub(crate) ephemeral_storage: std::option::Option<crate::model::EphemeralStorage>,
    }
    impl Builder {
        /// <p>The full Amazon Resource Name (ARN) of the task definition.</p>
        pub fn task_definition_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_definition_arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the task definition.</p>
        pub fn set_task_definition_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_definition_arn = input;
            self
        }
        /// Appends an item to `container_definitions`.
        ///
        /// To override the contents of this collection use [`set_container_definitions`](Self::set_container_definitions).
        ///
        /// <p>A list of container definitions in JSON format that describe the different containers
        /// that make up your task. For more information about container definition parameters and
        /// defaults, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Amazon ECS Task
        /// Definitions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn container_definitions(
            mut self,
            input: impl Into<crate::model::ContainerDefinition>,
        ) -> Self {
            let mut v = self.container_definitions.unwrap_or_default();
            v.push(input.into());
            self.container_definitions = Some(v);
            self
        }
        /// <p>A list of container definitions in JSON format that describe the different containers
        /// that make up your task. For more information about container definition parameters and
        /// defaults, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Amazon ECS Task
        /// Definitions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_container_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContainerDefinition>>,
        ) -> Self {
            self.container_definitions = input;
            self
        }
        /// <p>The name of a family that this task definition is registered to. Up to 255 letters
        /// (uppercase and lowercase), numbers, hyphens, and underscores are allowed.</p>
        /// <p>A family groups multiple versions of a task definition. Amazon ECS gives the first task
        /// definition that you registered to a family a revision number of 1. Amazon ECS gives
        /// sequential revision numbers to each task definition that you add.</p>
        pub fn family(mut self, input: impl Into<std::string::String>) -> Self {
            self.family = Some(input.into());
            self
        }
        /// <p>The name of a family that this task definition is registered to. Up to 255 letters
        /// (uppercase and lowercase), numbers, hyphens, and underscores are allowed.</p>
        /// <p>A family groups multiple versions of a task definition. Amazon ECS gives the first task
        /// definition that you registered to a family a revision number of 1. Amazon ECS gives
        /// sequential revision numbers to each task definition that you add.</p>
        pub fn set_family(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.family = input;
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the Identity and Access Management role that grants containers in the
        /// task permission to call Amazon Web Services APIs on your behalf. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">Amazon ECS
        /// Task Role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>IAM roles for tasks on Windows require that the <code>-EnableTaskIAMRole</code> option
        /// is set when you launch the Amazon ECS-optimized Windows AMI. Your containers must also run some
        /// configuration code in order to take advantage of the feature. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows_task_IAM_roles.html">Windows IAM roles
        /// for tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn task_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_role_arn = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the Identity and Access Management role that grants containers in the
        /// task permission to call Amazon Web Services APIs on your behalf. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">Amazon ECS
        /// Task Role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>IAM roles for tasks on Windows require that the <code>-EnableTaskIAMRole</code> option
        /// is set when you launch the Amazon ECS-optimized Windows AMI. Your containers must also run some
        /// configuration code in order to take advantage of the feature. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows_task_IAM_roles.html">Windows IAM roles
        /// for tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_task_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent
        /// permission to make Amazon Web Services API calls on your behalf. The task execution IAM role is required
        /// depending on the requirements of your task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task
        /// execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent
        /// permission to make Amazon Web Services API calls on your behalf. The task execution IAM role is required
        /// depending on the requirements of your task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task
        /// execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>The Docker networking mode to use for the containers in the task. The valid values are
        /// <code>none</code>, <code>bridge</code>, <code>awsvpc</code>, and <code>host</code>.
        /// If no network mode is specified, the default is <code>bridge</code>.</p>
        /// <p>For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required.
        /// For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used.  For Amazon ECS tasks on Amazon EC2 Windows instances, <code><default></code> or <code>awsvpc</code> can be used. If the network
        /// mode is set to <code>none</code>, you cannot specify port mappings in your container
        /// definitions, and the tasks containers do not have external connectivity. The
        /// <code>host</code> and <code>awsvpc</code> network modes offer the highest networking
        /// performance for containers because they use the EC2 network stack instead of the
        /// virtualized network stack provided by the <code>bridge</code> mode.</p>
        /// <p>With the <code>host</code> and <code>awsvpc</code> network modes, exposed container
        /// ports are mapped directly to the corresponding host port (for the <code>host</code>
        /// network mode) or the attached elastic network interface port (for the
        /// <code>awsvpc</code> network mode), so you cannot take advantage of dynamic host port
        /// mappings. </p>
        /// <important>
        /// <p>When using the <code>host</code> network mode, you should not run
        /// containers using the root user (UID 0). It is considered best practice
        /// to use a non-root user.</p>
        /// </important>
        /// <p>If the network mode is <code>awsvpc</code>, the task is allocated an elastic network
        /// interface, and you must specify a <a>NetworkConfiguration</a> value when you create
        /// a service or run a task with the task definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>If the network mode is <code>host</code>, you cannot run multiple instantiations of the
        /// same task on a single container instance when port mappings are used.</p>
        /// <p>For more information, see <a href="https://docs.docker.com/engine/reference/run/#network-settings">Network
        /// settings</a> in the <i>Docker run reference</i>.</p>
        pub fn network_mode(mut self, input: crate::model::NetworkMode) -> Self {
            self.network_mode = Some(input);
            self
        }
        /// <p>The Docker networking mode to use for the containers in the task. The valid values are
        /// <code>none</code>, <code>bridge</code>, <code>awsvpc</code>, and <code>host</code>.
        /// If no network mode is specified, the default is <code>bridge</code>.</p>
        /// <p>For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required.
        /// For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used.  For Amazon ECS tasks on Amazon EC2 Windows instances, <code><default></code> or <code>awsvpc</code> can be used. If the network
        /// mode is set to <code>none</code>, you cannot specify port mappings in your container
        /// definitions, and the tasks containers do not have external connectivity. The
        /// <code>host</code> and <code>awsvpc</code> network modes offer the highest networking
        /// performance for containers because they use the EC2 network stack instead of the
        /// virtualized network stack provided by the <code>bridge</code> mode.</p>
        /// <p>With the <code>host</code> and <code>awsvpc</code> network modes, exposed container
        /// ports are mapped directly to the corresponding host port (for the <code>host</code>
        /// network mode) or the attached elastic network interface port (for the
        /// <code>awsvpc</code> network mode), so you cannot take advantage of dynamic host port
        /// mappings. </p>
        /// <important>
        /// <p>When using the <code>host</code> network mode, you should not run
        /// containers using the root user (UID 0). It is considered best practice
        /// to use a non-root user.</p>
        /// </important>
        /// <p>If the network mode is <code>awsvpc</code>, the task is allocated an elastic network
        /// interface, and you must specify a <a>NetworkConfiguration</a> value when you create
        /// a service or run a task with the task definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>If the network mode is <code>host</code>, you cannot run multiple instantiations of the
        /// same task on a single container instance when port mappings are used.</p>
        /// <p>For more information, see <a href="https://docs.docker.com/engine/reference/run/#network-settings">Network
        /// settings</a> in the <i>Docker run reference</i>.</p>
        pub fn set_network_mode(
            mut self,
            input: std::option::Option<crate::model::NetworkMode>,
        ) -> Self {
            self.network_mode = input;
            self
        }
        /// <p>The revision of the task in a particular family. The revision is a version number of a
        /// task definition in a family. When you register a task definition for the first time, the
        /// revision is <code>1</code>. Each time that you register a new revision of a task
        /// definition in the same family, the revision value always increases by one, even if you
        /// have deregistered previous revisions in this family.</p>
        pub fn revision(mut self, input: i32) -> Self {
            self.revision = Some(input);
            self
        }
        /// <p>The revision of the task in a particular family. The revision is a version number of a
        /// task definition in a family. When you register a task definition for the first time, the
        /// revision is <code>1</code>. Each time that you register a new revision of a task
        /// definition in the same family, the revision value always increases by one, even if you
        /// have deregistered previous revisions in this family.</p>
        pub fn set_revision(mut self, input: std::option::Option<i32>) -> Self {
            self.revision = input;
            self
        }
        /// Appends an item to `volumes`.
        ///
        /// To override the contents of this collection use [`set_volumes`](Self::set_volumes).
        ///
        /// <p>The list of data volume definitions for the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html">Using data volumes in tasks</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <note>
        /// <p>The <code>host</code> and <code>sourcePath</code> parameters are not supported for
        /// tasks run on Fargate.</p>
        /// </note>
        pub fn volumes(mut self, input: impl Into<crate::model::Volume>) -> Self {
            let mut v = self.volumes.unwrap_or_default();
            v.push(input.into());
            self.volumes = Some(v);
            self
        }
        /// <p>The list of data volume definitions for the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html">Using data volumes in tasks</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <note>
        /// <p>The <code>host</code> and <code>sourcePath</code> parameters are not supported for
        /// tasks run on Fargate.</p>
        /// </note>
        pub fn set_volumes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Volume>>,
        ) -> Self {
            self.volumes = input;
            self
        }
        /// <p>The status of the task definition.</p>
        pub fn status(mut self, input: crate::model::TaskDefinitionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the task definition.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TaskDefinitionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `requires_attributes`.
        ///
        /// To override the contents of this collection use [`set_requires_attributes`](Self::set_requires_attributes).
        ///
        /// <p>The container instance attributes required by your task. When an Amazon EC2 instance is
        /// registered to your cluster, the Amazon ECS container agent assigns some standard attributes
        /// to the instance. You can apply custom attributes, specified as key-value pairs using the
        /// Amazon ECS console or the <a>PutAttributes</a> API. These attributes are used when
        /// considering task placement for tasks hosted on Amazon EC2 instances. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes">Attributes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <note>
        /// <p>This parameter is not supported for tasks run on Fargate.</p>
        /// </note>
        pub fn requires_attributes(mut self, input: impl Into<crate::model::Attribute>) -> Self {
            let mut v = self.requires_attributes.unwrap_or_default();
            v.push(input.into());
            self.requires_attributes = Some(v);
            self
        }
        /// <p>The container instance attributes required by your task. When an Amazon EC2 instance is
        /// registered to your cluster, the Amazon ECS container agent assigns some standard attributes
        /// to the instance. You can apply custom attributes, specified as key-value pairs using the
        /// Amazon ECS console or the <a>PutAttributes</a> API. These attributes are used when
        /// considering task placement for tasks hosted on Amazon EC2 instances. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes">Attributes</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <note>
        /// <p>This parameter is not supported for tasks run on Fargate.</p>
        /// </note>
        pub fn set_requires_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.requires_attributes = input;
            self
        }
        /// Appends an item to `placement_constraints`.
        ///
        /// To override the contents of this collection use [`set_placement_constraints`](Self::set_placement_constraints).
        ///
        /// <p>An array of placement constraint objects to use for tasks.</p>
        /// <note>
        /// <p>This parameter is not supported for tasks run on Fargate.</p>
        /// </note>
        pub fn placement_constraints(
            mut self,
            input: impl Into<crate::model::TaskDefinitionPlacementConstraint>,
        ) -> Self {
            let mut v = self.placement_constraints.unwrap_or_default();
            v.push(input.into());
            self.placement_constraints = Some(v);
            self
        }
        /// <p>An array of placement constraint objects to use for tasks.</p>
        /// <note>
        /// <p>This parameter is not supported for tasks run on Fargate.</p>
        /// </note>
        pub fn set_placement_constraints(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::TaskDefinitionPlacementConstraint>,
            >,
        ) -> Self {
            self.placement_constraints = input;
            self
        }
        /// Appends an item to `compatibilities`.
        ///
        /// To override the contents of this collection use [`set_compatibilities`](Self::set_compatibilities).
        ///
        /// <p>The task launch types the task definition validated against during task definition
        /// registration. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a>
        /// in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn compatibilities(mut self, input: impl Into<crate::model::Compatibility>) -> Self {
            let mut v = self.compatibilities.unwrap_or_default();
            v.push(input.into());
            self.compatibilities = Some(v);
            self
        }
        /// <p>The task launch types the task definition validated against during task definition
        /// registration. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a>
        /// in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_compatibilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Compatibility>>,
        ) -> Self {
            self.compatibilities = input;
            self
        }
        /// <p>The operating system  that your task definitions are running on. A platform family is specified only for tasks using the Fargate launch type. </p>
        /// <p>When you specify a task in a service, this value must match the <code>runtimePlatform</code> value of the service.</p>
        pub fn runtime_platform(mut self, input: crate::model::RuntimePlatform) -> Self {
            self.runtime_platform = Some(input);
            self
        }
        /// <p>The operating system  that your task definitions are running on. A platform family is specified only for tasks using the Fargate launch type. </p>
        /// <p>When you specify a task in a service, this value must match the <code>runtimePlatform</code> value of the service.</p>
        pub fn set_runtime_platform(
            mut self,
            input: std::option::Option<crate::model::RuntimePlatform>,
        ) -> Self {
            self.runtime_platform = input;
            self
        }
        /// Appends an item to `requires_compatibilities`.
        ///
        /// To override the contents of this collection use [`set_requires_compatibilities`](Self::set_requires_compatibilities).
        ///
        /// <p>The task launch types the task definition was validated against. To determine which
        /// task launch types the task definition is validated for, see the <a>TaskDefinition$compatibilities</a> parameter.</p>
        pub fn requires_compatibilities(
            mut self,
            input: impl Into<crate::model::Compatibility>,
        ) -> Self {
            let mut v = self.requires_compatibilities.unwrap_or_default();
            v.push(input.into());
            self.requires_compatibilities = Some(v);
            self
        }
        /// <p>The task launch types the task definition was validated against. To determine which
        /// task launch types the task definition is validated for, see the <a>TaskDefinition$compatibilities</a> parameter.</p>
        pub fn set_requires_compatibilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Compatibility>>,
        ) -> Self {
            self.requires_compatibilities = input;
            self
        }
        /// <p>The number of <code>cpu</code> units used by the task. If you are using the EC2 launch
        /// type, this field is optional and any value can be used. If you are using the Fargate
        /// launch type, this field is required and you must use one of the following values, which
        /// determines your range of valid values for the <code>memory</code> parameter:</p>
        /// <ul>
        /// <li>
        /// <p>256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)</p>
        /// </li>
        /// <li>
        /// <p>512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)</p>
        /// </li>
        /// <li>
        /// <p>1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)</p>
        /// </li>
        /// <li>
        /// <p>2048 (2 vCPU) - Available <code>memory</code> values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)</p>
        /// </li>
        /// <li>
        /// <p>4096 (4 vCPU) - Available <code>memory</code> values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)</p>
        /// </li>
        /// </ul>
        pub fn cpu(mut self, input: impl Into<std::string::String>) -> Self {
            self.cpu = Some(input.into());
            self
        }
        /// <p>The number of <code>cpu</code> units used by the task. If you are using the EC2 launch
        /// type, this field is optional and any value can be used. If you are using the Fargate
        /// launch type, this field is required and you must use one of the following values, which
        /// determines your range of valid values for the <code>memory</code> parameter:</p>
        /// <ul>
        /// <li>
        /// <p>256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)</p>
        /// </li>
        /// <li>
        /// <p>512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)</p>
        /// </li>
        /// <li>
        /// <p>1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)</p>
        /// </li>
        /// <li>
        /// <p>2048 (2 vCPU) - Available <code>memory</code> values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)</p>
        /// </li>
        /// <li>
        /// <p>4096 (4 vCPU) - Available <code>memory</code> values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)</p>
        /// </li>
        /// </ul>
        pub fn set_cpu(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cpu = input;
            self
        }
        /// <p>The amount (in MiB) of memory used by the task.</p>
        /// <p>If your tasks will be run on Amazon EC2 instances, you must specify either a task-level
        /// memory value or a container-level memory value. This field is optional and any value can
        /// be used. If a task-level memory value is specified then the container-level memory value
        /// is optional. For more information regarding container-level memory and memory
        /// reservation, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html">ContainerDefinition</a>.</p>
        /// <p>If your tasks will be run on Fargate, this field is required and you must use one of
        /// the following values, which determines your range of valid values for the
        /// <code>cpu</code> parameter:</p>
        /// <ul>
        /// <li>
        /// <p>512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available <code>cpu</code> values: 1024 (1 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4 vCPU)</p>
        /// </li>
        /// </ul>
        pub fn memory(mut self, input: impl Into<std::string::String>) -> Self {
            self.memory = Some(input.into());
            self
        }
        /// <p>The amount (in MiB) of memory used by the task.</p>
        /// <p>If your tasks will be run on Amazon EC2 instances, you must specify either a task-level
        /// memory value or a container-level memory value. This field is optional and any value can
        /// be used. If a task-level memory value is specified then the container-level memory value
        /// is optional. For more information regarding container-level memory and memory
        /// reservation, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html">ContainerDefinition</a>.</p>
        /// <p>If your tasks will be run on Fargate, this field is required and you must use one of
        /// the following values, which determines your range of valid values for the
        /// <code>cpu</code> parameter:</p>
        /// <ul>
        /// <li>
        /// <p>512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available <code>cpu</code> values: 1024 (1 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4 vCPU)</p>
        /// </li>
        /// </ul>
        pub fn set_memory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.memory = input;
            self
        }
        /// Appends an item to `inference_accelerators`.
        ///
        /// To override the contents of this collection use [`set_inference_accelerators`](Self::set_inference_accelerators).
        ///
        /// <p>The Elastic Inference accelerator associated with the task.</p>
        pub fn inference_accelerators(
            mut self,
            input: impl Into<crate::model::InferenceAccelerator>,
        ) -> Self {
            let mut v = self.inference_accelerators.unwrap_or_default();
            v.push(input.into());
            self.inference_accelerators = Some(v);
            self
        }
        /// <p>The Elastic Inference accelerator associated with the task.</p>
        pub fn set_inference_accelerators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InferenceAccelerator>>,
        ) -> Self {
            self.inference_accelerators = input;
            self
        }
        /// <p>The process namespace to use for the containers in the task. The valid
        /// values are <code>host</code> or <code>task</code>. If <code>host</code>
        /// is specified, then all containers within the tasks that specified the
        /// <code>host</code> PID mode on the same container instance share the
        /// same process namespace with the host Amazon EC2 instance. If <code>task</code> is
        /// specified, all containers within the specified task share the same
        /// process namespace. If no value is specified, the default is a private
        /// namespace. For more information, see <a href="https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the <i>Docker run
        /// reference</i>.</p>
        /// <p>If the <code>host</code> PID mode is used, be aware that there is a
        /// heightened risk of undesired process namespace expose. For more
        /// information, see <a href="https://docs.docker.com/engine/security/security/">Docker
        /// security</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
        /// </note>
        pub fn pid_mode(mut self, input: crate::model::PidMode) -> Self {
            self.pid_mode = Some(input);
            self
        }
        /// <p>The process namespace to use for the containers in the task. The valid
        /// values are <code>host</code> or <code>task</code>. If <code>host</code>
        /// is specified, then all containers within the tasks that specified the
        /// <code>host</code> PID mode on the same container instance share the
        /// same process namespace with the host Amazon EC2 instance. If <code>task</code> is
        /// specified, all containers within the specified task share the same
        /// process namespace. If no value is specified, the default is a private
        /// namespace. For more information, see <a href="https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the <i>Docker run
        /// reference</i>.</p>
        /// <p>If the <code>host</code> PID mode is used, be aware that there is a
        /// heightened risk of undesired process namespace expose. For more
        /// information, see <a href="https://docs.docker.com/engine/security/security/">Docker
        /// security</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
        /// </note>
        pub fn set_pid_mode(mut self, input: std::option::Option<crate::model::PidMode>) -> Self {
            self.pid_mode = input;
            self
        }
        /// <p>The IPC resource namespace to use for the containers in the task. The valid values are
        /// <code>host</code>, <code>task</code>, or <code>none</code>. If <code>host</code> is
        /// specified, then all containers within the tasks that specified the <code>host</code> IPC
        /// mode on the same container instance share the same IPC resources with the host Amazon EC2
        /// instance. If <code>task</code> is specified, all containers within the specified task
        /// share the same IPC resources. If <code>none</code> is specified, then IPC resources
        /// within the containers of a task are private and not shared with other containers in a
        /// task or on the container instance. If no value is specified, then the IPC resource
        /// namespace sharing depends on the Docker daemon setting on the container instance. For
        /// more information, see <a href="https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC
        /// settings</a> in the <i>Docker run reference</i>.</p>
        /// <p>If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of
        /// undesired IPC namespace expose. For more information, see <a href="https://docs.docker.com/engine/security/security/">Docker
        /// security</a>.</p>
        /// <p>If you are setting namespaced kernel parameters using <code>systemControls</code> for
        /// the containers in the task, the following will apply to your IPC resource namespace. For
        /// more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System
        /// Controls</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <ul>
        /// <li>
        /// <p>For tasks that use the <code>host</code> IPC mode, IPC namespace related
        /// <code>systemControls</code> are not supported.</p>
        /// </li>
        /// <li>
        /// <p>For tasks that use the <code>task</code> IPC mode, IPC namespace related
        /// <code>systemControls</code> will apply to all containers within a
        /// task.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
        /// </note>
        pub fn ipc_mode(mut self, input: crate::model::IpcMode) -> Self {
            self.ipc_mode = Some(input);
            self
        }
        /// <p>The IPC resource namespace to use for the containers in the task. The valid values are
        /// <code>host</code>, <code>task</code>, or <code>none</code>. If <code>host</code> is
        /// specified, then all containers within the tasks that specified the <code>host</code> IPC
        /// mode on the same container instance share the same IPC resources with the host Amazon EC2
        /// instance. If <code>task</code> is specified, all containers within the specified task
        /// share the same IPC resources. If <code>none</code> is specified, then IPC resources
        /// within the containers of a task are private and not shared with other containers in a
        /// task or on the container instance. If no value is specified, then the IPC resource
        /// namespace sharing depends on the Docker daemon setting on the container instance. For
        /// more information, see <a href="https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC
        /// settings</a> in the <i>Docker run reference</i>.</p>
        /// <p>If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of
        /// undesired IPC namespace expose. For more information, see <a href="https://docs.docker.com/engine/security/security/">Docker
        /// security</a>.</p>
        /// <p>If you are setting namespaced kernel parameters using <code>systemControls</code> for
        /// the containers in the task, the following will apply to your IPC resource namespace. For
        /// more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System
        /// Controls</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <ul>
        /// <li>
        /// <p>For tasks that use the <code>host</code> IPC mode, IPC namespace related
        /// <code>systemControls</code> are not supported.</p>
        /// </li>
        /// <li>
        /// <p>For tasks that use the <code>task</code> IPC mode, IPC namespace related
        /// <code>systemControls</code> will apply to all containers within a
        /// task.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
        /// </note>
        pub fn set_ipc_mode(mut self, input: std::option::Option<crate::model::IpcMode>) -> Self {
            self.ipc_mode = input;
            self
        }
        /// <p>The configuration details for the App Mesh proxy.</p>
        /// <p>Your Amazon ECS container instances require at least version 1.26.0 of the container agent
        /// and at least version 1.26.0-1 of the <code>ecs-init</code> package to enable a proxy
        /// configuration. If your container instances are launched from the Amazon ECS-optimized AMI
        /// version <code>20190301</code> or later, then they contain the required versions of the
        /// container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn proxy_configuration(mut self, input: crate::model::ProxyConfiguration) -> Self {
            self.proxy_configuration = Some(input);
            self
        }
        /// <p>The configuration details for the App Mesh proxy.</p>
        /// <p>Your Amazon ECS container instances require at least version 1.26.0 of the container agent
        /// and at least version 1.26.0-1 of the <code>ecs-init</code> package to enable a proxy
        /// configuration. If your container instances are launched from the Amazon ECS-optimized AMI
        /// version <code>20190301</code> or later, then they contain the required versions of the
        /// container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_proxy_configuration(
            mut self,
            input: std::option::Option<crate::model::ProxyConfiguration>,
        ) -> Self {
            self.proxy_configuration = input;
            self
        }
        /// <p>The Unix timestamp for when the task definition was registered.</p>
        pub fn registered_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.registered_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the task definition was registered.</p>
        pub fn set_registered_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.registered_at = input;
            self
        }
        /// <p>The Unix timestamp for when the task definition was deregistered.</p>
        pub fn deregistered_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.deregistered_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the task definition was deregistered.</p>
        pub fn set_deregistered_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.deregistered_at = input;
            self
        }
        /// <p>The principal that registered the task definition.</p>
        pub fn registered_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.registered_by = Some(input.into());
            self
        }
        /// <p>The principal that registered the task definition.</p>
        pub fn set_registered_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registered_by = input;
            self
        }
        /// <p>The ephemeral storage settings to use for tasks run with the task definition.</p>
        pub fn ephemeral_storage(mut self, input: crate::model::EphemeralStorage) -> Self {
            self.ephemeral_storage = Some(input);
            self
        }
        /// <p>The ephemeral storage settings to use for tasks run with the task definition.</p>
        pub fn set_ephemeral_storage(
            mut self,
            input: std::option::Option<crate::model::EphemeralStorage>,
        ) -> Self {
            self.ephemeral_storage = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskDefinition`](crate::model::TaskDefinition)
        pub fn build(self) -> crate::model::TaskDefinition {
            crate::model::TaskDefinition {
                task_definition_arn: self.task_definition_arn,
                container_definitions: self.container_definitions,
                family: self.family,
                task_role_arn: self.task_role_arn,
                execution_role_arn: self.execution_role_arn,
                network_mode: self.network_mode,
                revision: self.revision.unwrap_or_default(),
                volumes: self.volumes,
                status: self.status,
                requires_attributes: self.requires_attributes,
                placement_constraints: self.placement_constraints,
                compatibilities: self.compatibilities,
                runtime_platform: self.runtime_platform,
                requires_compatibilities: self.requires_compatibilities,
                cpu: self.cpu,
                memory: self.memory,
                inference_accelerators: self.inference_accelerators,
                pid_mode: self.pid_mode,
                ipc_mode: self.ipc_mode,
                proxy_configuration: self.proxy_configuration,
                registered_at: self.registered_at,
                deregistered_at: self.deregistered_at,
                registered_by: self.registered_by,
                ephemeral_storage: self.ephemeral_storage,
            }
        }
    }
}
impl TaskDefinition {
    /// Creates a new builder-style object to manufacture [`TaskDefinition`](crate::model::TaskDefinition)
    pub fn builder() -> crate::model::task_definition::Builder {
        crate::model::task_definition::Builder::default()
    }
}

/// <p>The configuration details for the App Mesh proxy.</p>
/// <p>For tasks using the EC2 launch type, the container instances require at
/// least version 1.26.0 of the container agent and at least version 1.26.0-1 of the
/// <code>ecs-init</code> package to enable a proxy configuration. If your container
/// instances are launched from the Amazon ECS-optimized AMI version <code>20190301</code> or
/// later, then they contain the required versions of the container agent and
/// <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProxyConfiguration {
    /// <p>The proxy type. The only supported value is <code>APPMESH</code>.</p>
    pub r#type: std::option::Option<crate::model::ProxyConfigurationType>,
    /// <p>The name of the container that will serve as the App Mesh proxy.</p>
    pub container_name: std::option::Option<std::string::String>,
    /// <p>The set of network configuration parameters to provide the Container Network Interface
    /// (CNI) plugin, specified as key-value pairs.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>IgnoredUID</code> - (Required) The user ID (UID) of the proxy
    /// container as defined by the <code>user</code> parameter in a container
    /// definition. This is used to ensure the proxy ignores its own traffic. If
    /// <code>IgnoredGID</code> is specified, this field can be empty.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IgnoredGID</code> - (Required) The group ID (GID) of the proxy
    /// container as defined by the <code>user</code> parameter in a container
    /// definition. This is used to ensure the proxy ignores its own traffic. If
    /// <code>IgnoredUID</code> is specified, this field can be empty.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AppPorts</code> - (Required) The list of ports that the
    /// application uses. Network traffic to these ports is forwarded to the
    /// <code>ProxyIngressPort</code> and <code>ProxyEgressPort</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ProxyIngressPort</code> - (Required) Specifies the port that
    /// incoming traffic to the <code>AppPorts</code> is directed to.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ProxyEgressPort</code> - (Required) Specifies the port that
    /// outgoing traffic from the <code>AppPorts</code> is directed to.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EgressIgnoredPorts</code> - (Required) The egress traffic going to
    /// the specified ports is ignored and not redirected to the
    /// <code>ProxyEgressPort</code>. It can be an empty list.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EgressIgnoredIPs</code> - (Required) The egress traffic going to
    /// the specified IP addresses is ignored and not redirected to the
    /// <code>ProxyEgressPort</code>. It can be an empty list.</p>
    /// </li>
    /// </ul>
    pub properties: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
}
impl std::fmt::Debug for ProxyConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProxyConfiguration");
        formatter.field("r#type", &self.r#type);
        formatter.field("container_name", &self.container_name);
        formatter.field("properties", &self.properties);
        formatter.finish()
    }
}
/// See [`ProxyConfiguration`](crate::model::ProxyConfiguration)
pub mod proxy_configuration {
    /// A builder for [`ProxyConfiguration`](crate::model::ProxyConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ProxyConfigurationType>,
        pub(crate) container_name: std::option::Option<std::string::String>,
        pub(crate) properties: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
    }
    impl Builder {
        /// <p>The proxy type. The only supported value is <code>APPMESH</code>.</p>
        pub fn r#type(mut self, input: crate::model::ProxyConfigurationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The proxy type. The only supported value is <code>APPMESH</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ProxyConfigurationType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the container that will serve as the App Mesh proxy.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_name = Some(input.into());
            self
        }
        /// <p>The name of the container that will serve as the App Mesh proxy.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_name = input;
            self
        }
        /// Appends an item to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>The set of network configuration parameters to provide the Container Network Interface
        /// (CNI) plugin, specified as key-value pairs.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IgnoredUID</code> - (Required) The user ID (UID) of the proxy
        /// container as defined by the <code>user</code> parameter in a container
        /// definition. This is used to ensure the proxy ignores its own traffic. If
        /// <code>IgnoredGID</code> is specified, this field can be empty.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IgnoredGID</code> - (Required) The group ID (GID) of the proxy
        /// container as defined by the <code>user</code> parameter in a container
        /// definition. This is used to ensure the proxy ignores its own traffic. If
        /// <code>IgnoredUID</code> is specified, this field can be empty.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AppPorts</code> - (Required) The list of ports that the
        /// application uses. Network traffic to these ports is forwarded to the
        /// <code>ProxyIngressPort</code> and <code>ProxyEgressPort</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ProxyIngressPort</code> - (Required) Specifies the port that
        /// incoming traffic to the <code>AppPorts</code> is directed to.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ProxyEgressPort</code> - (Required) Specifies the port that
        /// outgoing traffic from the <code>AppPorts</code> is directed to.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EgressIgnoredPorts</code> - (Required) The egress traffic going to
        /// the specified ports is ignored and not redirected to the
        /// <code>ProxyEgressPort</code>. It can be an empty list.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EgressIgnoredIPs</code> - (Required) The egress traffic going to
        /// the specified IP addresses is ignored and not redirected to the
        /// <code>ProxyEgressPort</code>. It can be an empty list.</p>
        /// </li>
        /// </ul>
        pub fn properties(mut self, input: impl Into<crate::model::KeyValuePair>) -> Self {
            let mut v = self.properties.unwrap_or_default();
            v.push(input.into());
            self.properties = Some(v);
            self
        }
        /// <p>The set of network configuration parameters to provide the Container Network Interface
        /// (CNI) plugin, specified as key-value pairs.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IgnoredUID</code> - (Required) The user ID (UID) of the proxy
        /// container as defined by the <code>user</code> parameter in a container
        /// definition. This is used to ensure the proxy ignores its own traffic. If
        /// <code>IgnoredGID</code> is specified, this field can be empty.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IgnoredGID</code> - (Required) The group ID (GID) of the proxy
        /// container as defined by the <code>user</code> parameter in a container
        /// definition. This is used to ensure the proxy ignores its own traffic. If
        /// <code>IgnoredUID</code> is specified, this field can be empty.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AppPorts</code> - (Required) The list of ports that the
        /// application uses. Network traffic to these ports is forwarded to the
        /// <code>ProxyIngressPort</code> and <code>ProxyEgressPort</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ProxyIngressPort</code> - (Required) Specifies the port that
        /// incoming traffic to the <code>AppPorts</code> is directed to.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ProxyEgressPort</code> - (Required) Specifies the port that
        /// outgoing traffic from the <code>AppPorts</code> is directed to.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EgressIgnoredPorts</code> - (Required) The egress traffic going to
        /// the specified ports is ignored and not redirected to the
        /// <code>ProxyEgressPort</code>. It can be an empty list.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EgressIgnoredIPs</code> - (Required) The egress traffic going to
        /// the specified IP addresses is ignored and not redirected to the
        /// <code>ProxyEgressPort</code>. It can be an empty list.</p>
        /// </li>
        /// </ul>
        pub fn set_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Consumes the builder and constructs a [`ProxyConfiguration`](crate::model::ProxyConfiguration)
        pub fn build(self) -> crate::model::ProxyConfiguration {
            crate::model::ProxyConfiguration {
                r#type: self.r#type,
                container_name: self.container_name,
                properties: self.properties,
            }
        }
    }
}
impl ProxyConfiguration {
    /// Creates a new builder-style object to manufacture [`ProxyConfiguration`](crate::model::ProxyConfiguration)
    pub fn builder() -> crate::model::proxy_configuration::Builder {
        crate::model::proxy_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProxyConfigurationType {
    #[allow(missing_docs)] // documentation missing in model
    Appmesh,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProxyConfigurationType {
    fn from(s: &str) -> Self {
        match s {
            "APPMESH" => ProxyConfigurationType::Appmesh,
            other => ProxyConfigurationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProxyConfigurationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProxyConfigurationType::from(s))
    }
}
impl ProxyConfigurationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProxyConfigurationType::Appmesh => "APPMESH",
            ProxyConfigurationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APPMESH"]
    }
}
impl AsRef<str> for ProxyConfigurationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IpcMode {
    #[allow(missing_docs)] // documentation missing in model
    Host,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Task,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IpcMode {
    fn from(s: &str) -> Self {
        match s {
            "host" => IpcMode::Host,
            "none" => IpcMode::None,
            "task" => IpcMode::Task,
            other => IpcMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IpcMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IpcMode::from(s))
    }
}
impl IpcMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IpcMode::Host => "host",
            IpcMode::None => "none",
            IpcMode::Task => "task",
            IpcMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["host", "none", "task"]
    }
}
impl AsRef<str> for IpcMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PidMode {
    #[allow(missing_docs)] // documentation missing in model
    Host,
    #[allow(missing_docs)] // documentation missing in model
    Task,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PidMode {
    fn from(s: &str) -> Self {
        match s {
            "host" => PidMode::Host,
            "task" => PidMode::Task,
            other => PidMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PidMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PidMode::from(s))
    }
}
impl PidMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PidMode::Host => "host",
            PidMode::Task => "task",
            PidMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["host", "task"]
    }
}
impl AsRef<str> for PidMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Compatibility {
    #[allow(missing_docs)] // documentation missing in model
    Ec2,
    #[allow(missing_docs)] // documentation missing in model
    External,
    #[allow(missing_docs)] // documentation missing in model
    Fargate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Compatibility {
    fn from(s: &str) -> Self {
        match s {
            "EC2" => Compatibility::Ec2,
            "EXTERNAL" => Compatibility::External,
            "FARGATE" => Compatibility::Fargate,
            other => Compatibility::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Compatibility {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Compatibility::from(s))
    }
}
impl Compatibility {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Compatibility::Ec2 => "EC2",
            Compatibility::External => "EXTERNAL",
            Compatibility::Fargate => "FARGATE",
            Compatibility::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EC2", "EXTERNAL", "FARGATE"]
    }
}
impl AsRef<str> for Compatibility {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the platform for the Amazon ECS service or task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RuntimePlatform {
    /// <p>The CPU architecture.</p>
    pub cpu_architecture: std::option::Option<crate::model::CpuArchitecture>,
    /// <p>The operating system.</p>
    pub operating_system_family: std::option::Option<crate::model::OsFamily>,
}
impl std::fmt::Debug for RuntimePlatform {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RuntimePlatform");
        formatter.field("cpu_architecture", &self.cpu_architecture);
        formatter.field("operating_system_family", &self.operating_system_family);
        formatter.finish()
    }
}
/// See [`RuntimePlatform`](crate::model::RuntimePlatform)
pub mod runtime_platform {
    /// A builder for [`RuntimePlatform`](crate::model::RuntimePlatform)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cpu_architecture: std::option::Option<crate::model::CpuArchitecture>,
        pub(crate) operating_system_family: std::option::Option<crate::model::OsFamily>,
    }
    impl Builder {
        /// <p>The CPU architecture.</p>
        pub fn cpu_architecture(mut self, input: crate::model::CpuArchitecture) -> Self {
            self.cpu_architecture = Some(input);
            self
        }
        /// <p>The CPU architecture.</p>
        pub fn set_cpu_architecture(
            mut self,
            input: std::option::Option<crate::model::CpuArchitecture>,
        ) -> Self {
            self.cpu_architecture = input;
            self
        }
        /// <p>The operating system.</p>
        pub fn operating_system_family(mut self, input: crate::model::OsFamily) -> Self {
            self.operating_system_family = Some(input);
            self
        }
        /// <p>The operating system.</p>
        pub fn set_operating_system_family(
            mut self,
            input: std::option::Option<crate::model::OsFamily>,
        ) -> Self {
            self.operating_system_family = input;
            self
        }
        /// Consumes the builder and constructs a [`RuntimePlatform`](crate::model::RuntimePlatform)
        pub fn build(self) -> crate::model::RuntimePlatform {
            crate::model::RuntimePlatform {
                cpu_architecture: self.cpu_architecture,
                operating_system_family: self.operating_system_family,
            }
        }
    }
}
impl RuntimePlatform {
    /// Creates a new builder-style object to manufacture [`RuntimePlatform`](crate::model::RuntimePlatform)
    pub fn builder() -> crate::model::runtime_platform::Builder {
        crate::model::runtime_platform::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OsFamily {
    #[allow(missing_docs)] // documentation missing in model
    Linux,
    #[allow(missing_docs)] // documentation missing in model
    WindowsServer2004Core,
    #[allow(missing_docs)] // documentation missing in model
    WindowsServer2016Full,
    #[allow(missing_docs)] // documentation missing in model
    WindowsServer2019Core,
    #[allow(missing_docs)] // documentation missing in model
    WindowsServer2019Full,
    #[allow(missing_docs)] // documentation missing in model
    WindowsServer2022Core,
    #[allow(missing_docs)] // documentation missing in model
    WindowsServer2022Full,
    #[allow(missing_docs)] // documentation missing in model
    WindowsServer20H2Core,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OsFamily {
    fn from(s: &str) -> Self {
        match s {
            "LINUX" => OsFamily::Linux,
            "WINDOWS_SERVER_2004_CORE" => OsFamily::WindowsServer2004Core,
            "WINDOWS_SERVER_2016_FULL" => OsFamily::WindowsServer2016Full,
            "WINDOWS_SERVER_2019_CORE" => OsFamily::WindowsServer2019Core,
            "WINDOWS_SERVER_2019_FULL" => OsFamily::WindowsServer2019Full,
            "WINDOWS_SERVER_2022_CORE" => OsFamily::WindowsServer2022Core,
            "WINDOWS_SERVER_2022_FULL" => OsFamily::WindowsServer2022Full,
            "WINDOWS_SERVER_20H2_CORE" => OsFamily::WindowsServer20H2Core,
            other => OsFamily::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OsFamily {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OsFamily::from(s))
    }
}
impl OsFamily {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OsFamily::Linux => "LINUX",
            OsFamily::WindowsServer2004Core => "WINDOWS_SERVER_2004_CORE",
            OsFamily::WindowsServer2016Full => "WINDOWS_SERVER_2016_FULL",
            OsFamily::WindowsServer2019Core => "WINDOWS_SERVER_2019_CORE",
            OsFamily::WindowsServer2019Full => "WINDOWS_SERVER_2019_FULL",
            OsFamily::WindowsServer2022Core => "WINDOWS_SERVER_2022_CORE",
            OsFamily::WindowsServer2022Full => "WINDOWS_SERVER_2022_FULL",
            OsFamily::WindowsServer20H2Core => "WINDOWS_SERVER_20H2_CORE",
            OsFamily::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "LINUX",
            "WINDOWS_SERVER_2004_CORE",
            "WINDOWS_SERVER_2016_FULL",
            "WINDOWS_SERVER_2019_CORE",
            "WINDOWS_SERVER_2019_FULL",
            "WINDOWS_SERVER_2022_CORE",
            "WINDOWS_SERVER_2022_FULL",
            "WINDOWS_SERVER_20H2_CORE",
        ]
    }
}
impl AsRef<str> for OsFamily {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CpuArchitecture {
    #[allow(missing_docs)] // documentation missing in model
    Arm64,
    #[allow(missing_docs)] // documentation missing in model
    X8664,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CpuArchitecture {
    fn from(s: &str) -> Self {
        match s {
            "ARM64" => CpuArchitecture::Arm64,
            "X86_64" => CpuArchitecture::X8664,
            other => CpuArchitecture::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CpuArchitecture {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CpuArchitecture::from(s))
    }
}
impl CpuArchitecture {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CpuArchitecture::Arm64 => "ARM64",
            CpuArchitecture::X8664 => "X86_64",
            CpuArchitecture::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ARM64", "X86_64"]
    }
}
impl AsRef<str> for CpuArchitecture {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing a constraint on task placement in the task definition. For more
/// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html">Task placement constraints</a> in the
/// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
/// <note>
/// <p>Task placement constraints are not supported for tasks run on Fargate.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaskDefinitionPlacementConstraint {
    /// <p>The type of constraint. The <code>MemberOf</code> constraint restricts selection to be
    /// from a group of valid candidates.</p>
    pub r#type: std::option::Option<crate::model::TaskDefinitionPlacementConstraintType>,
    /// <p>A cluster query language expression to apply to the constraint. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster query language</a> in the
    /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub expression: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TaskDefinitionPlacementConstraint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaskDefinitionPlacementConstraint");
        formatter.field("r#type", &self.r#type);
        formatter.field("expression", &self.expression);
        formatter.finish()
    }
}
/// See [`TaskDefinitionPlacementConstraint`](crate::model::TaskDefinitionPlacementConstraint)
pub mod task_definition_placement_constraint {
    /// A builder for [`TaskDefinitionPlacementConstraint`](crate::model::TaskDefinitionPlacementConstraint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::TaskDefinitionPlacementConstraintType>,
        pub(crate) expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of constraint. The <code>MemberOf</code> constraint restricts selection to be
        /// from a group of valid candidates.</p>
        pub fn r#type(
            mut self,
            input: crate::model::TaskDefinitionPlacementConstraintType,
        ) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of constraint. The <code>MemberOf</code> constraint restricts selection to be
        /// from a group of valid candidates.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::TaskDefinitionPlacementConstraintType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A cluster query language expression to apply to the constraint. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster query language</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>A cluster query language expression to apply to the constraint. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster query language</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// Consumes the builder and constructs a [`TaskDefinitionPlacementConstraint`](crate::model::TaskDefinitionPlacementConstraint)
        pub fn build(self) -> crate::model::TaskDefinitionPlacementConstraint {
            crate::model::TaskDefinitionPlacementConstraint {
                r#type: self.r#type,
                expression: self.expression,
            }
        }
    }
}
impl TaskDefinitionPlacementConstraint {
    /// Creates a new builder-style object to manufacture [`TaskDefinitionPlacementConstraint`](crate::model::TaskDefinitionPlacementConstraint)
    pub fn builder() -> crate::model::task_definition_placement_constraint::Builder {
        crate::model::task_definition_placement_constraint::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TaskDefinitionPlacementConstraintType {
    #[allow(missing_docs)] // documentation missing in model
    MemberOf,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TaskDefinitionPlacementConstraintType {
    fn from(s: &str) -> Self {
        match s {
            "memberOf" => TaskDefinitionPlacementConstraintType::MemberOf,
            other => TaskDefinitionPlacementConstraintType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TaskDefinitionPlacementConstraintType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TaskDefinitionPlacementConstraintType::from(s))
    }
}
impl TaskDefinitionPlacementConstraintType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TaskDefinitionPlacementConstraintType::MemberOf => "memberOf",
            TaskDefinitionPlacementConstraintType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["memberOf"]
    }
}
impl AsRef<str> for TaskDefinitionPlacementConstraintType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TaskDefinitionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TaskDefinitionStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => TaskDefinitionStatus::Active,
            "INACTIVE" => TaskDefinitionStatus::Inactive,
            other => TaskDefinitionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TaskDefinitionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TaskDefinitionStatus::from(s))
    }
}
impl TaskDefinitionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TaskDefinitionStatus::Active => "ACTIVE",
            TaskDefinitionStatus::Inactive => "INACTIVE",
            TaskDefinitionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE"]
    }
}
impl AsRef<str> for TaskDefinitionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A data volume used in a task definition. For tasks that use the Amazon Elastic File
/// System (Amazon EFS), specify an <code>efsVolumeConfiguration</code>. For Windows tasks
/// that use Amazon FSx for Windows File Server file system, specify a
/// <code>fsxWindowsFileServerVolumeConfiguration</code>. For tasks that use a Docker
/// volume, specify a <code>DockerVolumeConfiguration</code>. For tasks that use a bind
/// mount host volume, specify a <code>host</code> and optional <code>sourcePath</code>. For
/// more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html">Using Data Volumes in
/// Tasks</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Volume {
    /// <p>The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. This name is referenced in the
    /// <code>sourceVolume</code> parameter of container definition
    /// <code>mountPoints</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>This parameter is specified when you are using bind mount host volumes. The contents
    /// of the <code>host</code> parameter determine whether your bind mount host volume
    /// persists on the host container instance and where it is stored. If the <code>host</code>
    /// parameter is empty, then the Docker daemon assigns a host path for your data volume.
    /// However, the data is not guaranteed to persist after the containers associated with it
    /// stop running.</p>
    /// <p>Windows containers can mount whole directories on the same drive as
    /// <code>$env:ProgramData</code>. Windows containers cannot mount directories on a
    /// different drive, and mount point cannot be across drives. For example, you can mount
    /// <code>C:\my\path:C:\my\path</code> and <code>D:\:D:\</code>, but not
    /// <code>D:\my\path:C:\my\path</code> or <code>D:\:C:\my\path</code>.</p>
    pub host: std::option::Option<crate::model::HostVolumeProperties>,
    /// <p>This parameter is specified when you are using Docker volumes.</p>
    /// <p>Windows containers only support the use of the <code>local</code> driver. To use bind
    /// mounts, specify the <code>host</code> parameter instead.</p>
    /// <note>
    /// <p>Docker volumes are not supported by tasks run on Fargate.</p>
    /// </note>
    pub docker_volume_configuration: std::option::Option<crate::model::DockerVolumeConfiguration>,
    /// <p>This parameter is specified when you are using an Amazon Elastic File System file system for task
    /// storage.</p>
    pub efs_volume_configuration: std::option::Option<crate::model::EfsVolumeConfiguration>,
    /// <p>This parameter is specified when you are using Amazon FSx for Windows File Server file system for task
    /// storage.</p>
    pub fsx_windows_file_server_volume_configuration:
        std::option::Option<crate::model::FSxWindowsFileServerVolumeConfiguration>,
}
impl std::fmt::Debug for Volume {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Volume");
        formatter.field("name", &self.name);
        formatter.field("host", &self.host);
        formatter.field(
            "docker_volume_configuration",
            &self.docker_volume_configuration,
        );
        formatter.field("efs_volume_configuration", &self.efs_volume_configuration);
        formatter.field(
            "fsx_windows_file_server_volume_configuration",
            &self.fsx_windows_file_server_volume_configuration,
        );
        formatter.finish()
    }
}
/// See [`Volume`](crate::model::Volume)
pub mod volume {
    /// A builder for [`Volume`](crate::model::Volume)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) host: std::option::Option<crate::model::HostVolumeProperties>,
        pub(crate) docker_volume_configuration:
            std::option::Option<crate::model::DockerVolumeConfiguration>,
        pub(crate) efs_volume_configuration:
            std::option::Option<crate::model::EfsVolumeConfiguration>,
        pub(crate) fsx_windows_file_server_volume_configuration:
            std::option::Option<crate::model::FSxWindowsFileServerVolumeConfiguration>,
    }
    impl Builder {
        /// <p>The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. This name is referenced in the
        /// <code>sourceVolume</code> parameter of container definition
        /// <code>mountPoints</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. This name is referenced in the
        /// <code>sourceVolume</code> parameter of container definition
        /// <code>mountPoints</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>This parameter is specified when you are using bind mount host volumes. The contents
        /// of the <code>host</code> parameter determine whether your bind mount host volume
        /// persists on the host container instance and where it is stored. If the <code>host</code>
        /// parameter is empty, then the Docker daemon assigns a host path for your data volume.
        /// However, the data is not guaranteed to persist after the containers associated with it
        /// stop running.</p>
        /// <p>Windows containers can mount whole directories on the same drive as
        /// <code>$env:ProgramData</code>. Windows containers cannot mount directories on a
        /// different drive, and mount point cannot be across drives. For example, you can mount
        /// <code>C:\my\path:C:\my\path</code> and <code>D:\:D:\</code>, but not
        /// <code>D:\my\path:C:\my\path</code> or <code>D:\:C:\my\path</code>.</p>
        pub fn host(mut self, input: crate::model::HostVolumeProperties) -> Self {
            self.host = Some(input);
            self
        }
        /// <p>This parameter is specified when you are using bind mount host volumes. The contents
        /// of the <code>host</code> parameter determine whether your bind mount host volume
        /// persists on the host container instance and where it is stored. If the <code>host</code>
        /// parameter is empty, then the Docker daemon assigns a host path for your data volume.
        /// However, the data is not guaranteed to persist after the containers associated with it
        /// stop running.</p>
        /// <p>Windows containers can mount whole directories on the same drive as
        /// <code>$env:ProgramData</code>. Windows containers cannot mount directories on a
        /// different drive, and mount point cannot be across drives. For example, you can mount
        /// <code>C:\my\path:C:\my\path</code> and <code>D:\:D:\</code>, but not
        /// <code>D:\my\path:C:\my\path</code> or <code>D:\:C:\my\path</code>.</p>
        pub fn set_host(
            mut self,
            input: std::option::Option<crate::model::HostVolumeProperties>,
        ) -> Self {
            self.host = input;
            self
        }
        /// <p>This parameter is specified when you are using Docker volumes.</p>
        /// <p>Windows containers only support the use of the <code>local</code> driver. To use bind
        /// mounts, specify the <code>host</code> parameter instead.</p>
        /// <note>
        /// <p>Docker volumes are not supported by tasks run on Fargate.</p>
        /// </note>
        pub fn docker_volume_configuration(
            mut self,
            input: crate::model::DockerVolumeConfiguration,
        ) -> Self {
            self.docker_volume_configuration = Some(input);
            self
        }
        /// <p>This parameter is specified when you are using Docker volumes.</p>
        /// <p>Windows containers only support the use of the <code>local</code> driver. To use bind
        /// mounts, specify the <code>host</code> parameter instead.</p>
        /// <note>
        /// <p>Docker volumes are not supported by tasks run on Fargate.</p>
        /// </note>
        pub fn set_docker_volume_configuration(
            mut self,
            input: std::option::Option<crate::model::DockerVolumeConfiguration>,
        ) -> Self {
            self.docker_volume_configuration = input;
            self
        }
        /// <p>This parameter is specified when you are using an Amazon Elastic File System file system for task
        /// storage.</p>
        pub fn efs_volume_configuration(
            mut self,
            input: crate::model::EfsVolumeConfiguration,
        ) -> Self {
            self.efs_volume_configuration = Some(input);
            self
        }
        /// <p>This parameter is specified when you are using an Amazon Elastic File System file system for task
        /// storage.</p>
        pub fn set_efs_volume_configuration(
            mut self,
            input: std::option::Option<crate::model::EfsVolumeConfiguration>,
        ) -> Self {
            self.efs_volume_configuration = input;
            self
        }
        /// <p>This parameter is specified when you are using Amazon FSx for Windows File Server file system for task
        /// storage.</p>
        pub fn fsx_windows_file_server_volume_configuration(
            mut self,
            input: crate::model::FSxWindowsFileServerVolumeConfiguration,
        ) -> Self {
            self.fsx_windows_file_server_volume_configuration = Some(input);
            self
        }
        /// <p>This parameter is specified when you are using Amazon FSx for Windows File Server file system for task
        /// storage.</p>
        pub fn set_fsx_windows_file_server_volume_configuration(
            mut self,
            input: std::option::Option<crate::model::FSxWindowsFileServerVolumeConfiguration>,
        ) -> Self {
            self.fsx_windows_file_server_volume_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`Volume`](crate::model::Volume)
        pub fn build(self) -> crate::model::Volume {
            crate::model::Volume {
                name: self.name,
                host: self.host,
                docker_volume_configuration: self.docker_volume_configuration,
                efs_volume_configuration: self.efs_volume_configuration,
                fsx_windows_file_server_volume_configuration: self
                    .fsx_windows_file_server_volume_configuration,
            }
        }
    }
}
impl Volume {
    /// Creates a new builder-style object to manufacture [`Volume`](crate::model::Volume)
    pub fn builder() -> crate::model::volume::Builder {
        crate::model::volume::Builder::default()
    }
}

/// <p>This parameter is specified when you are using <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/what-is.html">Amazon FSx for Windows File Server</a> file system for task
/// storage.</p>
/// <p>For more information and the input format, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/wfsx-volumes.html">Amazon FSx for Windows File Server Volumes</a>
/// in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FSxWindowsFileServerVolumeConfiguration {
    /// <p>The Amazon FSx for Windows File Server file system ID to use.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The directory within the Amazon FSx for Windows File Server file system to mount as the root directory
    /// inside the host.</p>
    pub root_directory: std::option::Option<std::string::String>,
    /// <p>The authorization configuration details for the Amazon FSx for Windows File Server file system.</p>
    pub authorization_config:
        std::option::Option<crate::model::FSxWindowsFileServerAuthorizationConfig>,
}
impl std::fmt::Debug for FSxWindowsFileServerVolumeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FSxWindowsFileServerVolumeConfiguration");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("root_directory", &self.root_directory);
        formatter.field("authorization_config", &self.authorization_config);
        formatter.finish()
    }
}
/// See [`FSxWindowsFileServerVolumeConfiguration`](crate::model::FSxWindowsFileServerVolumeConfiguration)
pub mod f_sx_windows_file_server_volume_configuration {
    /// A builder for [`FSxWindowsFileServerVolumeConfiguration`](crate::model::FSxWindowsFileServerVolumeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) root_directory: std::option::Option<std::string::String>,
        pub(crate) authorization_config:
            std::option::Option<crate::model::FSxWindowsFileServerAuthorizationConfig>,
    }
    impl Builder {
        /// <p>The Amazon FSx for Windows File Server file system ID to use.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The Amazon FSx for Windows File Server file system ID to use.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The directory within the Amazon FSx for Windows File Server file system to mount as the root directory
        /// inside the host.</p>
        pub fn root_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.root_directory = Some(input.into());
            self
        }
        /// <p>The directory within the Amazon FSx for Windows File Server file system to mount as the root directory
        /// inside the host.</p>
        pub fn set_root_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.root_directory = input;
            self
        }
        /// <p>The authorization configuration details for the Amazon FSx for Windows File Server file system.</p>
        pub fn authorization_config(
            mut self,
            input: crate::model::FSxWindowsFileServerAuthorizationConfig,
        ) -> Self {
            self.authorization_config = Some(input);
            self
        }
        /// <p>The authorization configuration details for the Amazon FSx for Windows File Server file system.</p>
        pub fn set_authorization_config(
            mut self,
            input: std::option::Option<crate::model::FSxWindowsFileServerAuthorizationConfig>,
        ) -> Self {
            self.authorization_config = input;
            self
        }
        /// Consumes the builder and constructs a [`FSxWindowsFileServerVolumeConfiguration`](crate::model::FSxWindowsFileServerVolumeConfiguration)
        pub fn build(self) -> crate::model::FSxWindowsFileServerVolumeConfiguration {
            crate::model::FSxWindowsFileServerVolumeConfiguration {
                file_system_id: self.file_system_id,
                root_directory: self.root_directory,
                authorization_config: self.authorization_config,
            }
        }
    }
}
impl FSxWindowsFileServerVolumeConfiguration {
    /// Creates a new builder-style object to manufacture [`FSxWindowsFileServerVolumeConfiguration`](crate::model::FSxWindowsFileServerVolumeConfiguration)
    pub fn builder() -> crate::model::f_sx_windows_file_server_volume_configuration::Builder {
        crate::model::f_sx_windows_file_server_volume_configuration::Builder::default()
    }
}

/// <p>The authorization configuration details for Amazon FSx for Windows File Server file system. See <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_FSxWindowsFileServerVolumeConfiguration.html">FSxWindowsFileServerVolumeConfiguration</a> in the <i>Amazon Elastic
/// Container Service API Reference</i>.</p>
/// <p>For more information and the input format, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/wfsx-volumes.html">Amazon FSx for Windows File Server Volumes</a>
/// in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FSxWindowsFileServerAuthorizationConfig {
    /// <p>The authorization credential option to use. The authorization credential options can
    /// be provided using either the Amazon Resource Name (ARN) of an Secrets Manager secret or SSM
    /// Parameter Store parameter. The ARNs refer to the stored credentials.</p>
    pub credentials_parameter: std::option::Option<std::string::String>,
    /// <p>A fully qualified domain name hosted by an <a href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html">Directory Service</a> Managed Microsoft AD (Active Directory) or self-hosted AD on
    /// Amazon EC2.</p>
    pub domain: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FSxWindowsFileServerAuthorizationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FSxWindowsFileServerAuthorizationConfig");
        formatter.field("credentials_parameter", &self.credentials_parameter);
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`FSxWindowsFileServerAuthorizationConfig`](crate::model::FSxWindowsFileServerAuthorizationConfig)
pub mod f_sx_windows_file_server_authorization_config {
    /// A builder for [`FSxWindowsFileServerAuthorizationConfig`](crate::model::FSxWindowsFileServerAuthorizationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) credentials_parameter: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The authorization credential option to use. The authorization credential options can
        /// be provided using either the Amazon Resource Name (ARN) of an Secrets Manager secret or SSM
        /// Parameter Store parameter. The ARNs refer to the stored credentials.</p>
        pub fn credentials_parameter(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials_parameter = Some(input.into());
            self
        }
        /// <p>The authorization credential option to use. The authorization credential options can
        /// be provided using either the Amazon Resource Name (ARN) of an Secrets Manager secret or SSM
        /// Parameter Store parameter. The ARNs refer to the stored credentials.</p>
        pub fn set_credentials_parameter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.credentials_parameter = input;
            self
        }
        /// <p>A fully qualified domain name hosted by an <a href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html">Directory Service</a> Managed Microsoft AD (Active Directory) or self-hosted AD on
        /// Amazon EC2.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>A fully qualified domain name hosted by an <a href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html">Directory Service</a> Managed Microsoft AD (Active Directory) or self-hosted AD on
        /// Amazon EC2.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`FSxWindowsFileServerAuthorizationConfig`](crate::model::FSxWindowsFileServerAuthorizationConfig)
        pub fn build(self) -> crate::model::FSxWindowsFileServerAuthorizationConfig {
            crate::model::FSxWindowsFileServerAuthorizationConfig {
                credentials_parameter: self.credentials_parameter,
                domain: self.domain,
            }
        }
    }
}
impl FSxWindowsFileServerAuthorizationConfig {
    /// Creates a new builder-style object to manufacture [`FSxWindowsFileServerAuthorizationConfig`](crate::model::FSxWindowsFileServerAuthorizationConfig)
    pub fn builder() -> crate::model::f_sx_windows_file_server_authorization_config::Builder {
        crate::model::f_sx_windows_file_server_authorization_config::Builder::default()
    }
}

/// <p>This parameter is specified when you are using an Amazon Elastic File System file system for task
/// storage. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html">Amazon EFS Volumes</a> in the
/// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EfsVolumeConfiguration {
    /// <p>The Amazon EFS file system ID to use.</p>
    pub file_system_id: std::option::Option<std::string::String>,
    /// <p>The directory within the Amazon EFS file system to mount as the root directory inside the
    /// host. If this parameter is omitted, the root of the Amazon EFS volume will be used.
    /// Specifying <code>/</code> will have the same effect as omitting this parameter.</p>
    /// <important>
    /// <p>If an EFS access point is specified in the <code>authorizationConfig</code>, the
    /// root directory parameter must either be omitted or set to <code>/</code> which will
    /// enforce the path set on the EFS access point.</p>
    /// </important>
    pub root_directory: std::option::Option<std::string::String>,
    /// <p>Whether or not to enable encryption for Amazon EFS data in transit between the Amazon ECS host
    /// and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is
    /// used. If this parameter is omitted, the default value of <code>DISABLED</code> is used.
    /// For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html">Encrypting Data in Transit</a> in
    /// the <i>Amazon Elastic File System User Guide</i>.</p>
    pub transit_encryption: std::option::Option<crate::model::EfsTransitEncryption>,
    /// <p>The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS
    /// server. If you do not specify a transit encryption port, it will use the port selection
    /// strategy that the Amazon EFS mount helper uses. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html">EFS Mount
    /// Helper</a> in the <i>Amazon Elastic File System User Guide</i>.</p>
    pub transit_encryption_port: std::option::Option<i32>,
    /// <p>The authorization configuration details for the Amazon EFS file system.</p>
    pub authorization_config: std::option::Option<crate::model::EfsAuthorizationConfig>,
}
impl std::fmt::Debug for EfsVolumeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EfsVolumeConfiguration");
        formatter.field("file_system_id", &self.file_system_id);
        formatter.field("root_directory", &self.root_directory);
        formatter.field("transit_encryption", &self.transit_encryption);
        formatter.field("transit_encryption_port", &self.transit_encryption_port);
        formatter.field("authorization_config", &self.authorization_config);
        formatter.finish()
    }
}
/// See [`EfsVolumeConfiguration`](crate::model::EfsVolumeConfiguration)
pub mod efs_volume_configuration {
    /// A builder for [`EfsVolumeConfiguration`](crate::model::EfsVolumeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_system_id: std::option::Option<std::string::String>,
        pub(crate) root_directory: std::option::Option<std::string::String>,
        pub(crate) transit_encryption: std::option::Option<crate::model::EfsTransitEncryption>,
        pub(crate) transit_encryption_port: std::option::Option<i32>,
        pub(crate) authorization_config: std::option::Option<crate::model::EfsAuthorizationConfig>,
    }
    impl Builder {
        /// <p>The Amazon EFS file system ID to use.</p>
        pub fn file_system_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_system_id = Some(input.into());
            self
        }
        /// <p>The Amazon EFS file system ID to use.</p>
        pub fn set_file_system_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_system_id = input;
            self
        }
        /// <p>The directory within the Amazon EFS file system to mount as the root directory inside the
        /// host. If this parameter is omitted, the root of the Amazon EFS volume will be used.
        /// Specifying <code>/</code> will have the same effect as omitting this parameter.</p>
        /// <important>
        /// <p>If an EFS access point is specified in the <code>authorizationConfig</code>, the
        /// root directory parameter must either be omitted or set to <code>/</code> which will
        /// enforce the path set on the EFS access point.</p>
        /// </important>
        pub fn root_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.root_directory = Some(input.into());
            self
        }
        /// <p>The directory within the Amazon EFS file system to mount as the root directory inside the
        /// host. If this parameter is omitted, the root of the Amazon EFS volume will be used.
        /// Specifying <code>/</code> will have the same effect as omitting this parameter.</p>
        /// <important>
        /// <p>If an EFS access point is specified in the <code>authorizationConfig</code>, the
        /// root directory parameter must either be omitted or set to <code>/</code> which will
        /// enforce the path set on the EFS access point.</p>
        /// </important>
        pub fn set_root_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.root_directory = input;
            self
        }
        /// <p>Whether or not to enable encryption for Amazon EFS data in transit between the Amazon ECS host
        /// and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is
        /// used. If this parameter is omitted, the default value of <code>DISABLED</code> is used.
        /// For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html">Encrypting Data in Transit</a> in
        /// the <i>Amazon Elastic File System User Guide</i>.</p>
        pub fn transit_encryption(mut self, input: crate::model::EfsTransitEncryption) -> Self {
            self.transit_encryption = Some(input);
            self
        }
        /// <p>Whether or not to enable encryption for Amazon EFS data in transit between the Amazon ECS host
        /// and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is
        /// used. If this parameter is omitted, the default value of <code>DISABLED</code> is used.
        /// For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html">Encrypting Data in Transit</a> in
        /// the <i>Amazon Elastic File System User Guide</i>.</p>
        pub fn set_transit_encryption(
            mut self,
            input: std::option::Option<crate::model::EfsTransitEncryption>,
        ) -> Self {
            self.transit_encryption = input;
            self
        }
        /// <p>The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS
        /// server. If you do not specify a transit encryption port, it will use the port selection
        /// strategy that the Amazon EFS mount helper uses. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html">EFS Mount
        /// Helper</a> in the <i>Amazon Elastic File System User Guide</i>.</p>
        pub fn transit_encryption_port(mut self, input: i32) -> Self {
            self.transit_encryption_port = Some(input);
            self
        }
        /// <p>The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS
        /// server. If you do not specify a transit encryption port, it will use the port selection
        /// strategy that the Amazon EFS mount helper uses. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html">EFS Mount
        /// Helper</a> in the <i>Amazon Elastic File System User Guide</i>.</p>
        pub fn set_transit_encryption_port(mut self, input: std::option::Option<i32>) -> Self {
            self.transit_encryption_port = input;
            self
        }
        /// <p>The authorization configuration details for the Amazon EFS file system.</p>
        pub fn authorization_config(mut self, input: crate::model::EfsAuthorizationConfig) -> Self {
            self.authorization_config = Some(input);
            self
        }
        /// <p>The authorization configuration details for the Amazon EFS file system.</p>
        pub fn set_authorization_config(
            mut self,
            input: std::option::Option<crate::model::EfsAuthorizationConfig>,
        ) -> Self {
            self.authorization_config = input;
            self
        }
        /// Consumes the builder and constructs a [`EfsVolumeConfiguration`](crate::model::EfsVolumeConfiguration)
        pub fn build(self) -> crate::model::EfsVolumeConfiguration {
            crate::model::EfsVolumeConfiguration {
                file_system_id: self.file_system_id,
                root_directory: self.root_directory,
                transit_encryption: self.transit_encryption,
                transit_encryption_port: self.transit_encryption_port,
                authorization_config: self.authorization_config,
            }
        }
    }
}
impl EfsVolumeConfiguration {
    /// Creates a new builder-style object to manufacture [`EfsVolumeConfiguration`](crate::model::EfsVolumeConfiguration)
    pub fn builder() -> crate::model::efs_volume_configuration::Builder {
        crate::model::efs_volume_configuration::Builder::default()
    }
}

/// <p>The authorization configuration details for the Amazon EFS file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EfsAuthorizationConfig {
    /// <p>The Amazon EFS access point ID to use. If an access point is specified, the root directory
    /// value specified in the <code>EFSVolumeConfiguration</code> must either be omitted or set
    /// to <code>/</code> which will enforce the path set on the EFS access point. If an access
    /// point is used, transit encryption must be enabled in the
    /// <code>EFSVolumeConfiguration</code>. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">Working with Amazon
    /// EFS Access Points</a> in the <i>Amazon Elastic File System User Guide</i>.</p>
    pub access_point_id: std::option::Option<std::string::String>,
    /// <p>Whether or not to use the Amazon ECS task IAM role defined in a task definition when
    /// mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the
    /// <code>EFSVolumeConfiguration</code>. If this parameter is omitted, the default value
    /// of <code>DISABLED</code> is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html#efs-volume-accesspoints">Using
    /// Amazon EFS Access Points</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub iam: std::option::Option<crate::model::EfsAuthorizationConfigIam>,
}
impl std::fmt::Debug for EfsAuthorizationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EfsAuthorizationConfig");
        formatter.field("access_point_id", &self.access_point_id);
        formatter.field("iam", &self.iam);
        formatter.finish()
    }
}
/// See [`EfsAuthorizationConfig`](crate::model::EfsAuthorizationConfig)
pub mod efs_authorization_config {
    /// A builder for [`EfsAuthorizationConfig`](crate::model::EfsAuthorizationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_point_id: std::option::Option<std::string::String>,
        pub(crate) iam: std::option::Option<crate::model::EfsAuthorizationConfigIam>,
    }
    impl Builder {
        /// <p>The Amazon EFS access point ID to use. If an access point is specified, the root directory
        /// value specified in the <code>EFSVolumeConfiguration</code> must either be omitted or set
        /// to <code>/</code> which will enforce the path set on the EFS access point. If an access
        /// point is used, transit encryption must be enabled in the
        /// <code>EFSVolumeConfiguration</code>. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">Working with Amazon
        /// EFS Access Points</a> in the <i>Amazon Elastic File System User Guide</i>.</p>
        pub fn access_point_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_point_id = Some(input.into());
            self
        }
        /// <p>The Amazon EFS access point ID to use. If an access point is specified, the root directory
        /// value specified in the <code>EFSVolumeConfiguration</code> must either be omitted or set
        /// to <code>/</code> which will enforce the path set on the EFS access point. If an access
        /// point is used, transit encryption must be enabled in the
        /// <code>EFSVolumeConfiguration</code>. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">Working with Amazon
        /// EFS Access Points</a> in the <i>Amazon Elastic File System User Guide</i>.</p>
        pub fn set_access_point_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_point_id = input;
            self
        }
        /// <p>Whether or not to use the Amazon ECS task IAM role defined in a task definition when
        /// mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the
        /// <code>EFSVolumeConfiguration</code>. If this parameter is omitted, the default value
        /// of <code>DISABLED</code> is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html#efs-volume-accesspoints">Using
        /// Amazon EFS Access Points</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn iam(mut self, input: crate::model::EfsAuthorizationConfigIam) -> Self {
            self.iam = Some(input);
            self
        }
        /// <p>Whether or not to use the Amazon ECS task IAM role defined in a task definition when
        /// mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the
        /// <code>EFSVolumeConfiguration</code>. If this parameter is omitted, the default value
        /// of <code>DISABLED</code> is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html#efs-volume-accesspoints">Using
        /// Amazon EFS Access Points</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_iam(
            mut self,
            input: std::option::Option<crate::model::EfsAuthorizationConfigIam>,
        ) -> Self {
            self.iam = input;
            self
        }
        /// Consumes the builder and constructs a [`EfsAuthorizationConfig`](crate::model::EfsAuthorizationConfig)
        pub fn build(self) -> crate::model::EfsAuthorizationConfig {
            crate::model::EfsAuthorizationConfig {
                access_point_id: self.access_point_id,
                iam: self.iam,
            }
        }
    }
}
impl EfsAuthorizationConfig {
    /// Creates a new builder-style object to manufacture [`EfsAuthorizationConfig`](crate::model::EfsAuthorizationConfig)
    pub fn builder() -> crate::model::efs_authorization_config::Builder {
        crate::model::efs_authorization_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EfsAuthorizationConfigIam {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EfsAuthorizationConfigIam {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => EfsAuthorizationConfigIam::Disabled,
            "ENABLED" => EfsAuthorizationConfigIam::Enabled,
            other => EfsAuthorizationConfigIam::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EfsAuthorizationConfigIam {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EfsAuthorizationConfigIam::from(s))
    }
}
impl EfsAuthorizationConfigIam {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EfsAuthorizationConfigIam::Disabled => "DISABLED",
            EfsAuthorizationConfigIam::Enabled => "ENABLED",
            EfsAuthorizationConfigIam::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for EfsAuthorizationConfigIam {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EfsTransitEncryption {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EfsTransitEncryption {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => EfsTransitEncryption::Disabled,
            "ENABLED" => EfsTransitEncryption::Enabled,
            other => EfsTransitEncryption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EfsTransitEncryption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EfsTransitEncryption::from(s))
    }
}
impl EfsTransitEncryption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EfsTransitEncryption::Disabled => "DISABLED",
            EfsTransitEncryption::Enabled => "ENABLED",
            EfsTransitEncryption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for EfsTransitEncryption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This parameter is specified when you are using Docker volumes. Docker volumes are only
/// supported when you are using the EC2 launch type. Windows containers only
/// support the use of the <code>local</code> driver. To use bind mounts, specify a
/// <code>host</code> instead.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DockerVolumeConfiguration {
    /// <p>The scope for the Docker volume that determines its lifecycle. Docker volumes that are
    /// scoped to a <code>task</code> are automatically provisioned when the task starts and
    /// destroyed when the task stops. Docker volumes that are scoped as <code>shared</code>
    /// persist after the task stops.</p>
    pub scope: std::option::Option<crate::model::Scope>,
    /// <p>If this value is <code>true</code>, the Docker volume is created if it does not
    /// already exist.</p>
    /// <note>
    /// <p>This field is only used if the <code>scope</code> is <code>shared</code>.</p>
    /// </note>
    pub autoprovision: std::option::Option<bool>,
    /// <p>The Docker volume driver to use. The driver value must match the driver name provided
    /// by Docker because it is used for task placement. If the driver was installed using the
    /// Docker plugin CLI, use <code>docker plugin ls</code> to retrieve the driver name from
    /// your container instance. If the driver was installed using another method, use Docker
    /// plugin discovery to retrieve the driver name. For more information, see <a href="https://docs.docker.com/engine/extend/plugin_api/#plugin-discovery">Docker
    /// plugin discovery</a>. This parameter maps to <code>Driver</code> in the
    /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
    /// <code>xxdriver</code> option to <a href="https://docs.docker.com/engine/reference/commandline/volume_create/">docker
    /// volume create</a>.</p>
    pub driver: std::option::Option<std::string::String>,
    /// <p>A map of Docker driver-specific options passed through. This parameter maps to
    /// <code>DriverOpts</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of the
    /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>xxopt</code> option to <a href="https://docs.docker.com/engine/reference/commandline/volume_create/">docker
    /// volume create</a>.</p>
    pub driver_opts:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Custom metadata to add to your Docker volume. This parameter maps to
    /// <code>Labels</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of the
    /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>xxlabel</code> option to <a href="https://docs.docker.com/engine/reference/commandline/volume_create/">docker
    /// volume create</a>.</p>
    pub labels:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for DockerVolumeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DockerVolumeConfiguration");
        formatter.field("scope", &self.scope);
        formatter.field("autoprovision", &self.autoprovision);
        formatter.field("driver", &self.driver);
        formatter.field("driver_opts", &self.driver_opts);
        formatter.field("labels", &self.labels);
        formatter.finish()
    }
}
/// See [`DockerVolumeConfiguration`](crate::model::DockerVolumeConfiguration)
pub mod docker_volume_configuration {
    /// A builder for [`DockerVolumeConfiguration`](crate::model::DockerVolumeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scope: std::option::Option<crate::model::Scope>,
        pub(crate) autoprovision: std::option::Option<bool>,
        pub(crate) driver: std::option::Option<std::string::String>,
        pub(crate) driver_opts: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) labels: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The scope for the Docker volume that determines its lifecycle. Docker volumes that are
        /// scoped to a <code>task</code> are automatically provisioned when the task starts and
        /// destroyed when the task stops. Docker volumes that are scoped as <code>shared</code>
        /// persist after the task stops.</p>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.scope = Some(input);
            self
        }
        /// <p>The scope for the Docker volume that determines its lifecycle. Docker volumes that are
        /// scoped to a <code>task</code> are automatically provisioned when the task starts and
        /// destroyed when the task stops. Docker volumes that are scoped as <code>shared</code>
        /// persist after the task stops.</p>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.scope = input;
            self
        }
        /// <p>If this value is <code>true</code>, the Docker volume is created if it does not
        /// already exist.</p>
        /// <note>
        /// <p>This field is only used if the <code>scope</code> is <code>shared</code>.</p>
        /// </note>
        pub fn autoprovision(mut self, input: bool) -> Self {
            self.autoprovision = Some(input);
            self
        }
        /// <p>If this value is <code>true</code>, the Docker volume is created if it does not
        /// already exist.</p>
        /// <note>
        /// <p>This field is only used if the <code>scope</code> is <code>shared</code>.</p>
        /// </note>
        pub fn set_autoprovision(mut self, input: std::option::Option<bool>) -> Self {
            self.autoprovision = input;
            self
        }
        /// <p>The Docker volume driver to use. The driver value must match the driver name provided
        /// by Docker because it is used for task placement. If the driver was installed using the
        /// Docker plugin CLI, use <code>docker plugin ls</code> to retrieve the driver name from
        /// your container instance. If the driver was installed using another method, use Docker
        /// plugin discovery to retrieve the driver name. For more information, see <a href="https://docs.docker.com/engine/extend/plugin_api/#plugin-discovery">Docker
        /// plugin discovery</a>. This parameter maps to <code>Driver</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>xxdriver</code> option to <a href="https://docs.docker.com/engine/reference/commandline/volume_create/">docker
        /// volume create</a>.</p>
        pub fn driver(mut self, input: impl Into<std::string::String>) -> Self {
            self.driver = Some(input.into());
            self
        }
        /// <p>The Docker volume driver to use. The driver value must match the driver name provided
        /// by Docker because it is used for task placement. If the driver was installed using the
        /// Docker plugin CLI, use <code>docker plugin ls</code> to retrieve the driver name from
        /// your container instance. If the driver was installed using another method, use Docker
        /// plugin discovery to retrieve the driver name. For more information, see <a href="https://docs.docker.com/engine/extend/plugin_api/#plugin-discovery">Docker
        /// plugin discovery</a>. This parameter maps to <code>Driver</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>xxdriver</code> option to <a href="https://docs.docker.com/engine/reference/commandline/volume_create/">docker
        /// volume create</a>.</p>
        pub fn set_driver(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.driver = input;
            self
        }
        /// Adds a key-value pair to `driver_opts`.
        ///
        /// To override the contents of this collection use [`set_driver_opts`](Self::set_driver_opts).
        ///
        /// <p>A map of Docker driver-specific options passed through. This parameter maps to
        /// <code>DriverOpts</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>xxopt</code> option to <a href="https://docs.docker.com/engine/reference/commandline/volume_create/">docker
        /// volume create</a>.</p>
        pub fn driver_opts(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.driver_opts.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.driver_opts = Some(hash_map);
            self
        }
        /// <p>A map of Docker driver-specific options passed through. This parameter maps to
        /// <code>DriverOpts</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>xxopt</code> option to <a href="https://docs.docker.com/engine/reference/commandline/volume_create/">docker
        /// volume create</a>.</p>
        pub fn set_driver_opts(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.driver_opts = input;
            self
        }
        /// Adds a key-value pair to `labels`.
        ///
        /// To override the contents of this collection use [`set_labels`](Self::set_labels).
        ///
        /// <p>Custom metadata to add to your Docker volume. This parameter maps to
        /// <code>Labels</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>xxlabel</code> option to <a href="https://docs.docker.com/engine/reference/commandline/volume_create/">docker
        /// volume create</a>.</p>
        pub fn labels(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.labels.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.labels = Some(hash_map);
            self
        }
        /// <p>Custom metadata to add to your Docker volume. This parameter maps to
        /// <code>Labels</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/VolumeCreate">Create a volume</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>xxlabel</code> option to <a href="https://docs.docker.com/engine/reference/commandline/volume_create/">docker
        /// volume create</a>.</p>
        pub fn set_labels(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.labels = input;
            self
        }
        /// Consumes the builder and constructs a [`DockerVolumeConfiguration`](crate::model::DockerVolumeConfiguration)
        pub fn build(self) -> crate::model::DockerVolumeConfiguration {
            crate::model::DockerVolumeConfiguration {
                scope: self.scope,
                autoprovision: self.autoprovision,
                driver: self.driver,
                driver_opts: self.driver_opts,
                labels: self.labels,
            }
        }
    }
}
impl DockerVolumeConfiguration {
    /// Creates a new builder-style object to manufacture [`DockerVolumeConfiguration`](crate::model::DockerVolumeConfiguration)
    pub fn builder() -> crate::model::docker_volume_configuration::Builder {
        crate::model::docker_volume_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Scope {
    #[allow(missing_docs)] // documentation missing in model
    Shared,
    #[allow(missing_docs)] // documentation missing in model
    Task,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Scope {
    fn from(s: &str) -> Self {
        match s {
            "shared" => Scope::Shared,
            "task" => Scope::Task,
            other => Scope::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Scope {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Scope::from(s))
    }
}
impl Scope {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Scope::Shared => "shared",
            Scope::Task => "task",
            Scope::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["shared", "task"]
    }
}
impl AsRef<str> for Scope {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details on a container instance bind mount host volume.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HostVolumeProperties {
    /// <p>When the <code>host</code> parameter is used, specify a <code>sourcePath</code> to
    /// declare the path on the host container instance that is presented to the container. If
    /// this parameter is empty, then the Docker daemon has assigned a host path for you. If the
    /// <code>host</code> parameter contains a <code>sourcePath</code> file location, then
    /// the data volume persists at the specified location on the host container instance until
    /// you delete it manually. If the <code>sourcePath</code> value does not exist on the host
    /// container instance, the Docker daemon creates it. If the location does exist, the
    /// contents of the source path folder are exported.</p>
    /// <p>If you are using the Fargate launch type, the <code>sourcePath</code>
    /// parameter is not supported.</p>
    pub source_path: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HostVolumeProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HostVolumeProperties");
        formatter.field("source_path", &self.source_path);
        formatter.finish()
    }
}
/// See [`HostVolumeProperties`](crate::model::HostVolumeProperties)
pub mod host_volume_properties {
    /// A builder for [`HostVolumeProperties`](crate::model::HostVolumeProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>When the <code>host</code> parameter is used, specify a <code>sourcePath</code> to
        /// declare the path on the host container instance that is presented to the container. If
        /// this parameter is empty, then the Docker daemon has assigned a host path for you. If the
        /// <code>host</code> parameter contains a <code>sourcePath</code> file location, then
        /// the data volume persists at the specified location on the host container instance until
        /// you delete it manually. If the <code>sourcePath</code> value does not exist on the host
        /// container instance, the Docker daemon creates it. If the location does exist, the
        /// contents of the source path folder are exported.</p>
        /// <p>If you are using the Fargate launch type, the <code>sourcePath</code>
        /// parameter is not supported.</p>
        pub fn source_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_path = Some(input.into());
            self
        }
        /// <p>When the <code>host</code> parameter is used, specify a <code>sourcePath</code> to
        /// declare the path on the host container instance that is presented to the container. If
        /// this parameter is empty, then the Docker daemon has assigned a host path for you. If the
        /// <code>host</code> parameter contains a <code>sourcePath</code> file location, then
        /// the data volume persists at the specified location on the host container instance until
        /// you delete it manually. If the <code>sourcePath</code> value does not exist on the host
        /// container instance, the Docker daemon creates it. If the location does exist, the
        /// contents of the source path folder are exported.</p>
        /// <p>If you are using the Fargate launch type, the <code>sourcePath</code>
        /// parameter is not supported.</p>
        pub fn set_source_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_path = input;
            self
        }
        /// Consumes the builder and constructs a [`HostVolumeProperties`](crate::model::HostVolumeProperties)
        pub fn build(self) -> crate::model::HostVolumeProperties {
            crate::model::HostVolumeProperties {
                source_path: self.source_path,
            }
        }
    }
}
impl HostVolumeProperties {
    /// Creates a new builder-style object to manufacture [`HostVolumeProperties`](crate::model::HostVolumeProperties)
    pub fn builder() -> crate::model::host_volume_properties::Builder {
        crate::model::host_volume_properties::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NetworkMode {
    #[allow(missing_docs)] // documentation missing in model
    Awsvpc,
    #[allow(missing_docs)] // documentation missing in model
    Bridge,
    #[allow(missing_docs)] // documentation missing in model
    Host,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NetworkMode {
    fn from(s: &str) -> Self {
        match s {
            "awsvpc" => NetworkMode::Awsvpc,
            "bridge" => NetworkMode::Bridge,
            "host" => NetworkMode::Host,
            "none" => NetworkMode::None,
            other => NetworkMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NetworkMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NetworkMode::from(s))
    }
}
impl NetworkMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NetworkMode::Awsvpc => "awsvpc",
            NetworkMode::Bridge => "bridge",
            NetworkMode::Host => "host",
            NetworkMode::None => "none",
            NetworkMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["awsvpc", "bridge", "host", "none"]
    }
}
impl AsRef<str> for NetworkMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Container definitions are used in task definitions to describe the different
/// containers that are launched as part of a task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerDefinition {
    /// <p>The name of a container. If you are linking multiple containers together in a task
    /// definition, the <code>name</code> of one container can be entered in the
    /// <code>links</code> of another container to connect the containers.
    /// Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. This parameter maps to <code>name</code> in the
    /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
    /// <code>--name</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
    /// run</a>. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The image used to start a container. This string is passed directly to the Docker
    /// daemon. Images in the Docker Hub registry are available by default. Other repositories
    /// are specified with either <code>
    /// <i>repository-url</i>/<i>image</i>:<i>tag</i>
    /// </code> or <code>
    /// <i>repository-url</i>/<i>image</i>@<i>digest</i>
    /// </code>. Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to <code>Image</code> in the
    /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
    /// <code>IMAGE</code> parameter of <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
    /// run</a>.</p>
    /// <ul>
    /// <li>
    /// <p>When a new task starts, the Amazon ECS container agent pulls the latest version of
    /// the specified image and tag for the container to use. However, subsequent
    /// updates to a repository image are not propagated to already running
    /// tasks.</p>
    /// </li>
    /// <li>
    /// <p>Images in Amazon ECR repositories can be specified by either using the full
    /// <code>registry/repository:tag</code> or
    /// <code>registry/repository@digest</code>. For example,
    /// <code>012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>:latest</code>
    /// or
    /// <code>012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>@sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>Images in official repositories on Docker Hub use a single name (for example,
    /// <code>ubuntu</code> or <code>mongo</code>).</p>
    /// </li>
    /// <li>
    /// <p>Images in other repositories on Docker Hub are qualified with an organization
    /// name (for example, <code>amazon/amazon-ecs-agent</code>).</p>
    /// </li>
    /// <li>
    /// <p>Images in other online repositories are qualified further by a domain name
    /// (for example, <code>quay.io/assemblyline/ubuntu</code>).</p>
    /// </li>
    /// </ul>
    pub image: std::option::Option<std::string::String>,
    /// <p>The private repository authentication credentials to use.</p>
    pub repository_credentials: std::option::Option<crate::model::RepositoryCredentials>,
    /// <p>The number of <code>cpu</code> units reserved for the container. This parameter maps
    /// to <code>CpuShares</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
    /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--cpu-shares</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
    /// <p>This field is optional for tasks using the Fargate launch type, and the
    /// only requirement is that the total amount of CPU reserved for all containers within a
    /// task be lower than the task-level <code>cpu</code> value.</p>
    /// <note>
    /// <p>You can determine the number of CPU units that are available per EC2 instance type
    /// by multiplying the vCPUs listed for that instance type on the <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instances</a> detail page
    /// by 1,024.</p>
    /// </note>
    /// <p>Linux containers share unallocated CPU units with other containers on the container
    /// instance with the same ratio as their allocated amount. For example, if you run a
    /// single-container task on a single-core instance type with 512 CPU units specified for
    /// that container, and that is the only task running on the container instance, that
    /// container could use the full 1,024 CPU unit share at any given time. However, if you
    /// launched another copy of the same task on that container instance, each task would be
    /// guaranteed a minimum of 512 CPU units when needed, and each container could float to
    /// higher CPU usage if the other container was not using it, but if both tasks were 100%
    /// active all of the time, they would be limited to 512 CPU units.</p>
    /// <p>On Linux container instances, the Docker daemon on the container instance uses the CPU
    /// value to calculate the relative CPU share ratios for running containers. For more
    /// information, see <a href="https://docs.docker.com/engine/reference/run/#cpu-share-constraint">CPU share
    /// constraint</a> in the Docker documentation. The minimum valid CPU share value
    /// that the Linux kernel allows is 2. However, the CPU parameter is not required, and you
    /// can use CPU values below 2 in your container definitions. For CPU values below 2
    /// (including null), the behavior varies based on your Amazon ECS container agent
    /// version:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Agent versions less than or equal to 1.1.0:</b>
    /// Null and zero CPU values are passed to Docker as 0, which Docker then converts
    /// to 1,024 CPU shares. CPU values of 1 are passed to Docker as 1, which the Linux
    /// kernel converts to two CPU shares.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Agent versions greater than or equal to 1.2.0:</b>
    /// Null, zero, and CPU values of 1 are passed to Docker as 2.</p>
    /// </li>
    /// </ul>
    /// <p>On Windows container instances, the CPU limit is enforced as an absolute limit, or a
    /// quota. Windows containers only have access to the specified amount of CPU that is
    /// described in the task definition. A null or zero CPU value is passed to Docker as
    /// <code>0</code>, which Windows interprets as 1% of one CPU.</p>
    pub cpu: i32,
    /// <p>The amount (in MiB) of memory to present to the container. If your container attempts
    /// to exceed the memory specified here, the container is killed. The total amount of memory
    /// reserved for all containers within a task must be lower than the task
    /// <code>memory</code> value, if one is specified. This parameter maps to
    /// <code>Memory</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
    /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
    /// <p>If using the Fargate launch type, this parameter is optional.</p>
    /// <p>If using the EC2 launch type, you must specify either a task-level
    /// memory value or a container-level memory value. If you specify both a container-level
    /// <code>memory</code> and <code>memoryReservation</code> value, <code>memory</code>
    /// must be greater than <code>memoryReservation</code>. If you specify
    /// <code>memoryReservation</code>, then that value is subtracted from the available
    /// memory resources for the container instance on which the container is placed. Otherwise,
    /// the value of <code>memory</code> is used.</p>
    /// <p>The Docker daemon reserves a minimum of 4 MiB of memory for a container, so you should
    /// not specify fewer than 4 MiB of memory for your containers.</p>
    pub memory: std::option::Option<i32>,
    /// <p>The soft limit (in MiB) of memory to reserve for the container. When system memory is
    /// under heavy contention, Docker attempts to keep the container memory to this soft limit.
    /// However, your container can consume more memory when it needs to, up to either the hard
    /// limit specified with the <code>memory</code> parameter (if applicable), or all of the
    /// available memory on the container instance, whichever comes first. This parameter maps
    /// to <code>MemoryReservation</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
    /// the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--memory-reservation</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
    /// <p>If a task-level memory value is not specified, you must specify a non-zero integer for
    /// one or both of <code>memory</code> or <code>memoryReservation</code> in a container
    /// definition. If you specify both, <code>memory</code> must be greater than
    /// <code>memoryReservation</code>. If you specify <code>memoryReservation</code>, then
    /// that value is subtracted from the available memory resources for the container instance
    /// on which the container is placed. Otherwise, the value of <code>memory</code> is
    /// used.</p>
    /// <p>For example, if your container normally uses 128 MiB of memory, but occasionally
    /// bursts to 256 MiB of memory for short periods of time, you can set a
    /// <code>memoryReservation</code> of 128 MiB, and a <code>memory</code> hard limit of
    /// 300 MiB. This configuration would allow the container to only reserve 128 MiB of memory
    /// from the remaining resources on the container instance, but also allow the container to
    /// consume more memory resources when needed.</p>
    /// <p>The Docker daemon reserves a minimum of 4 MiB of memory for a container, so you should
    /// not specify fewer than 4 MiB of memory for your containers. </p>
    pub memory_reservation: std::option::Option<i32>,
    /// <p>The <code>links</code> parameter allows containers to communicate with each other
    /// without the need for port mappings. This parameter is only supported if the network mode
    /// of a task definition is <code>bridge</code>. The <code>name:internalName</code>
    /// construct is analogous to <code>name:alias</code> in Docker links.
    /// Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. For more information about linking Docker containers, go to
    /// <a href="https://docs.docker.com/network/links/">Legacy container links</a>
    /// in the Docker documentation. This parameter maps to <code>Links</code> in the
    /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
    /// <code>--link</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
    /// run</a>.</p>
    /// <note>
    /// <p>This parameter is not supported for Windows containers.</p>
    /// </note>
    /// <important>
    /// <p>Containers that are collocated on a single container instance may be able to
    /// communicate with each other without requiring links or host port mappings. Network
    /// isolation is achieved on the container instance using security groups and VPC
    /// settings.</p>
    /// </important>
    pub links: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of port mappings for the container. Port mappings allow containers to access
    /// ports on the host container instance to send or receive traffic.</p>
    /// <p>For task definitions that use the <code>awsvpc</code> network mode, you should only
    /// specify the <code>containerPort</code>. The <code>hostPort</code> can be left blank or
    /// it must be the same value as the <code>containerPort</code>.</p>
    /// <p>Port mappings on Windows use the <code>NetNAT</code> gateway address rather than
    /// <code>localhost</code>. There is no loopback for port mappings on Windows, so you
    /// cannot access a container's mapped port from the host itself. </p>
    /// <p>This parameter maps to <code>PortBindings</code> in the
    /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
    /// <code>--publish</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
    /// run</a>. If the network mode of a task definition is set to <code>none</code>,
    /// then you can't specify port mappings. If the network mode of a task definition is set to
    /// <code>host</code>, then host ports must either be undefined or they must match the
    /// container port in the port mapping.</p>
    /// <note>
    /// <p>After a task reaches the <code>RUNNING</code> status, manual and automatic host
    /// and container port assignments are visible in the <b>Network
    /// Bindings</b> section of a container description for a selected task in
    /// the Amazon ECS console. The assignments are also visible in the
    /// <code>networkBindings</code> section <a>DescribeTasks</a>
    /// responses.</p>
    /// </note>
    pub port_mappings: std::option::Option<std::vec::Vec<crate::model::PortMapping>>,
    /// <p>If the <code>essential</code> parameter of a container is marked as <code>true</code>,
    /// and that container fails or stops for any reason, all other containers that are part of
    /// the task are stopped. If the <code>essential</code> parameter of a container is marked
    /// as <code>false</code>, then its failure does not affect the rest of the containers in a
    /// task. If this parameter is omitted, a container is assumed to be essential.</p>
    /// <p>All tasks must have at least one essential container. If you have an application that
    /// is composed of multiple containers, you should group containers that are used for a
    /// common purpose into components, and separate the different components into multiple task
    /// definitions. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html">Application
    /// Architecture</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub essential: std::option::Option<bool>,
    /// <important>
    /// <p>Early versions of the Amazon ECS container agent do not properly handle
    /// <code>entryPoint</code> parameters. If you have problems using
    /// <code>entryPoint</code>, update your container agent or enter your commands and
    /// arguments as <code>command</code> array items instead.</p>
    /// </important>
    /// <p>The entry point that is passed to the container. This parameter maps to
    /// <code>Entrypoint</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
    /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--entrypoint</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>. For more information, see <a href="https://docs.docker.com/engine/reference/builder/#entrypoint">https://docs.docker.com/engine/reference/builder/#entrypoint</a>.</p>
    pub entry_point: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The command that is passed to the container. This parameter maps to <code>Cmd</code>
    /// in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
    /// <code>COMMAND</code> parameter to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
    /// run</a>. For more information, see <a href="https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/builder/#cmd</a>. If there are multiple arguments, each
    /// argument should be a separated string in the array.</p>
    pub command: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The environment variables to pass to a container. This parameter maps to
    /// <code>Env</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
    /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--env</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
    /// <important>
    /// <p>We do not recommend using plaintext environment variables for sensitive
    /// information, such as credential data.</p>
    /// </important>
    pub environment: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
    /// <p>A list of files containing the environment variables to pass to a container. This
    /// parameter maps to the <code>--env-file</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
    /// <p>You can specify up to ten environment files. The file must have a <code>.env</code>
    /// file extension. Each line in an environment file should contain an environment variable
    /// in <code>VARIABLE=VALUE</code> format. Lines beginning with <code>#</code> are treated
    /// as comments and are ignored. For more information on the environment variable file
    /// syntax, see <a href="https://docs.docker.com/compose/env-file/">Declare default
    /// environment variables in file</a>.</p>
    /// <p>If there are environment variables specified using the <code>environment</code>
    /// parameter in a container definition, they take precedence over the variables contained
    /// within an environment file. If multiple environment files are specified that contain the
    /// same variable, they are processed from the top down. It is recommended to use unique
    /// variable names. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html">Specifying Environment
    /// Variables</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub environment_files: std::option::Option<std::vec::Vec<crate::model::EnvironmentFile>>,
    /// <p>The mount points for data volumes in your container.</p>
    /// <p>This parameter maps to <code>Volumes</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
    /// section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--volume</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
    /// <p>Windows containers can mount whole directories on the same drive as
    /// <code>$env:ProgramData</code>. Windows containers cannot mount directories on a
    /// different drive, and mount point cannot be across drives.</p>
    pub mount_points: std::option::Option<std::vec::Vec<crate::model::MountPoint>>,
    /// <p>Data volumes to mount from another container. This parameter maps to
    /// <code>VolumesFrom</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
    /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--volumes-from</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
    pub volumes_from: std::option::Option<std::vec::Vec<crate::model::VolumeFrom>>,
    /// <p>Linux-specific modifications that are applied to the container, such as Linux kernel
    /// capabilities. For more information see <a>KernelCapabilities</a>.</p>
    /// <note>
    /// <p>This parameter is not supported for Windows containers.</p>
    /// </note>
    pub linux_parameters: std::option::Option<crate::model::LinuxParameters>,
    /// <p>The secrets to pass to the container. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying
    /// Sensitive Data</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub secrets: std::option::Option<std::vec::Vec<crate::model::Secret>>,
    /// <p>The dependencies defined for container startup and shutdown. A container can contain
    /// multiple dependencies. When a dependency is defined for container startup, for container
    /// shutdown it is reversed.</p>
    /// <p>For tasks using the EC2 launch type, the container instances require at
    /// least version 1.26.0 of the container agent to enable container dependencies. However,
    /// we recommend using the latest container agent version. For information about checking
    /// your agent version and updating to the latest version, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS
    /// Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are
    /// using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the
    /// <code>ecs-init</code> package. If your container instances are launched from version
    /// <code>20190301</code> or later, then they contain the required versions of the
    /// container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>For tasks using the Fargate launch type, the task or service requires the followiwng platforms:</p>
    /// <ul>
    /// <li>
    /// <p>Linux platform
    /// version <code>1.3.0</code> or later.</p>
    /// </li>
    /// <li>
    /// <p>Windows platform
    /// version <code>1.0.0</code> or later.</p>
    /// </li>
    /// </ul>
    pub depends_on: std::option::Option<std::vec::Vec<crate::model::ContainerDependency>>,
    /// <p>Time duration (in seconds) to wait before giving up on resolving dependencies for a
    /// container. For example, you specify two containers in a task definition with containerA
    /// having a dependency on containerB reaching a <code>COMPLETE</code>,
    /// <code>SUCCESS</code>, or <code>HEALTHY</code> status. If a <code>startTimeout</code>
    /// value is specified for containerB and it does not reach the desired status within that
    /// time then containerA will give up and not start. This results in the task transitioning
    /// to a <code>STOPPED</code> state.</p>
    /// <note>
    /// <p>When the <code>ECS_CONTAINER_START_TIMEOUT</code> container agent configuration
    /// variable is used, it is enforced indendently from this start timeout value.</p>
    /// </note>
    /// <p>For tasks using the Fargate launch type, the task or service requires the followiwng platforms:</p>
    /// <ul>
    /// <li>
    /// <p>Linux platform
    /// version <code>1.3.0</code> or later.</p>
    /// </li>
    /// <li>
    /// <p>Windows platform
    /// version <code>1.0.0</code> or later.</p>
    /// </li>
    /// </ul>
    /// <p>For tasks using the EC2 launch type, your container instances require at
    /// least version <code>1.26.0</code> of the container agent to enable a container start
    /// timeout value. However, we recommend using the latest container agent version. For
    /// information about checking your agent version and updating to the latest version, see
    /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS
    /// Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are
    /// using an Amazon ECS-optimized Linux AMI, your instance needs at least version <code>1.26.0-1</code> of
    /// the <code>ecs-init</code> package. If your container instances are launched from version
    /// <code>20190301</code> or later, then they contain the required versions of the
    /// container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub start_timeout: std::option::Option<i32>,
    /// <p>Time duration (in seconds) to wait before the container is forcefully killed if it
    /// doesn't exit normally on its own.</p>
    /// <p>For tasks using the Fargate launch type, the task or service requires the followiwng platforms:</p>
    /// <ul>
    /// <li>
    /// <p>Linux platform
    /// version <code>1.3.0</code> or later.</p>
    /// </li>
    /// <li>
    /// <p>Windows platform
    /// version <code>1.0.0</code> or later.</p>
    /// </li>
    /// </ul>
    /// <p>The max stop timeout value is 120 seconds and if the
    /// parameter is not specified, the default value of 30 seconds is used.</p>
    /// <p>For tasks using the EC2 launch type, if the <code>stopTimeout</code>
    /// parameter is not specified, the value set for the Amazon ECS container agent configuration
    /// variable <code>ECS_CONTAINER_STOP_TIMEOUT</code> is used by default. If neither the
    /// <code>stopTimeout</code> parameter or the <code>ECS_CONTAINER_STOP_TIMEOUT</code>
    /// agent configuration variable are set, then the default values of 30 seconds for Linux
    /// containers and 30 seconds on Windows containers are used. Your container instances
    /// require at least version 1.26.0 of the container agent to enable a container stop
    /// timeout value. However, we recommend using the latest container agent version. For
    /// information about checking your agent version and updating to the latest version, see
    /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS
    /// Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are
    /// using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the
    /// <code>ecs-init</code> package. If your container instances are launched from version
    /// <code>20190301</code> or later, then they contain the required versions of the
    /// container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub stop_timeout: std::option::Option<i32>,
    /// <p>The hostname to use for your container. This parameter maps to <code>Hostname</code>
    /// in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
    /// <code>--hostname</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
    /// run</a>.</p>
    /// <note>
    /// <p>The <code>hostname</code> parameter is not supported if you are using the
    /// <code>awsvpc</code> network mode.</p>
    /// </note>
    pub hostname: std::option::Option<std::string::String>,
    /// <p>The user to use inside the container. This parameter maps to <code>User</code> in the
    /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
    /// <code>--user</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
    /// run</a>.</p>
    /// <important>
    /// <p>When running tasks using the <code>host</code> network mode, you should not run
    /// containers using the root user (UID 0). It is considered best practice to use a
    /// non-root user.</p>
    /// </important>
    /// <p>You can specify the <code>user</code> using the following formats. If specifying a UID
    /// or GID, you must specify it as a positive integer.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>user</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>user:group</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>uid</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>uid:gid</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>user:gid</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>uid:group</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>This parameter is not supported for Windows containers.</p>
    /// </note>
    pub user: std::option::Option<std::string::String>,
    /// <p>The working directory in which to run commands inside the container. This parameter
    /// maps to <code>WorkingDir</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
    /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--workdir</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
    pub working_directory: std::option::Option<std::string::String>,
    /// <p>When this parameter is true, networking is disabled within the container. This
    /// parameter maps to <code>NetworkDisabled</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
    /// section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a>.</p>
    /// <note>
    /// <p>This parameter is not supported for Windows containers.</p>
    /// </note>
    pub disable_networking: std::option::Option<bool>,
    /// <p>When this parameter is true, the container is given elevated privileges on the host
    /// container instance (similar to the <code>root</code> user). This parameter maps to
    /// <code>Privileged</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
    /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--privileged</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
    /// <note>
    /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
    /// </note>
    pub privileged: std::option::Option<bool>,
    /// <p>When this parameter is true, the container is given read-only access to its root file
    /// system. This parameter maps to <code>ReadonlyRootfs</code> in the
    /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
    /// <code>--read-only</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
    /// run</a>.</p>
    /// <note>
    /// <p>This parameter is not supported for Windows containers.</p>
    /// </note>
    pub readonly_root_filesystem: std::option::Option<bool>,
    /// <p>A list of DNS servers that are presented to the container. This parameter maps to
    /// <code>Dns</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
    /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--dns</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
    /// <note>
    /// <p>This parameter is not supported for Windows containers.</p>
    /// </note>
    pub dns_servers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of DNS search domains that are presented to the container. This parameter maps
    /// to <code>DnsSearch</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
    /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--dns-search</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
    /// <note>
    /// <p>This parameter is not supported for Windows containers.</p>
    /// </note>
    pub dns_search_domains: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of hostnames and IP address mappings to append to the <code>/etc/hosts</code>
    /// file on the container. This parameter maps to <code>ExtraHosts</code> in the
    /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
    /// <code>--add-host</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
    /// run</a>.</p>
    /// <note>
    /// <p>This parameter is not supported for Windows containers or tasks that use the
    /// <code>awsvpc</code> network mode.</p>
    /// </note>
    pub extra_hosts: std::option::Option<std::vec::Vec<crate::model::HostEntry>>,
    /// <p>A list of strings to provide custom labels for SELinux and AppArmor multi-level
    /// security systems. This field is not valid for containers in tasks using the
    /// Fargate launch type.</p>
    /// <p>With Windows containers, this parameter can be used to reference a credential spec
    /// file when configuring a container for Active Directory authentication. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html">Using gMSAs for Windows
    /// Containers</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>This parameter maps to <code>SecurityOpt</code> in the
    /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
    /// <code>--security-opt</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
    /// run</a>.</p>
    /// <note>
    /// <p>The Amazon ECS container agent running on a container instance must register with the
    /// <code>ECS_SELINUX_CAPABLE=true</code> or <code>ECS_APPARMOR_CAPABLE=true</code>
    /// environment variables before containers placed on that instance can use these
    /// security options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container
    /// Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// </note>
    /// <p>For more information about valid values, see <a href="https://docs.docker.com/engine/reference/run/#security-configuration">Docker
    /// Run Security Configuration</a>. </p>
    /// <p>Valid values: "no-new-privileges" | "apparmor:PROFILE" | "label:value" |
    /// "credentialspec:CredentialSpecFilePath"</p>
    pub docker_security_options: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>When this parameter is <code>true</code>, this allows you to deploy containerized
    /// applications that require <code>stdin</code> or a <code>tty</code> to be allocated. This
    /// parameter maps to <code>OpenStdin</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
    /// section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--interactive</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
    pub interactive: std::option::Option<bool>,
    /// <p>When this parameter is <code>true</code>, a TTY is allocated. This parameter maps to
    /// <code>Tty</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
    /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--tty</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
    pub pseudo_terminal: std::option::Option<bool>,
    /// <p>A key/value map of labels to add to the container. This parameter maps to
    /// <code>Labels</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
    /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--label</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>. This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
    /// </p>
    pub docker_labels:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A list of <code>ulimits</code> to set in the container. If a ulimit value is specified
    /// in a task definition, it will override the default values set by Docker. This parameter
    /// maps to <code>Ulimits</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
    /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--ulimit</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>. Valid naming values are displayed
    /// in the <a>Ulimit</a> data type.</p>
    /// <p>Amazon ECS tasks hosted on Fargate use the default
    /// resource limit values set by the operating system with the exception of
    /// the <code>nofile</code> resource limit parameter which Fargate
    /// overrides. The <code>nofile</code> resource limit sets a restriction on
    /// the number of open files that a container can use. The default
    /// <code>nofile</code> soft limit is <code>1024</code> and hard limit
    /// is <code>4096</code>.</p>
    /// <p>This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
    /// </p>
    /// <note>
    /// <p>This parameter is not supported for Windows containers.</p>
    /// </note>
    pub ulimits: std::option::Option<std::vec::Vec<crate::model::Ulimit>>,
    /// <p>The log configuration specification for the container.</p>
    /// <p>This parameter maps to <code>LogConfig</code> in the
    /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
    /// <code>--log-driver</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
    /// run</a>. By default, containers use the same logging driver that the Docker
    /// daemon uses. However the container may use a different logging driver than the Docker
    /// daemon by specifying a log driver with this parameter in the container definition. To
    /// use a different logging driver for a container, the log system must be configured
    /// properly on the container instance (or on a different log server for remote logging
    /// options). For more information on the options for different supported log drivers, see
    /// <a href="https://docs.docker.com/engine/admin/logging/overview/">Configure
    /// logging drivers</a> in the Docker documentation.</p>
    /// <note>
    /// <p>Amazon ECS currently supports a subset of the logging drivers available to the Docker
    /// daemon (shown in the <a>LogConfiguration</a> data type). Additional log
    /// drivers may be available in future releases of the Amazon ECS container agent.</p>
    /// </note>
    /// <p>This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
    /// </p>
    /// <note>
    /// <p>The Amazon ECS container agent running on a container instance must register the
    /// logging drivers available on that instance with the
    /// <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before
    /// containers placed on that instance can use these log configuration options. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container
    /// Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// </note>
    pub log_configuration: std::option::Option<crate::model::LogConfiguration>,
    /// <p>The container health check command and associated configuration parameters for the
    /// container. This parameter maps to <code>HealthCheck</code> in the
    /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
    /// <code>HEALTHCHECK</code> parameter of <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
    /// run</a>.</p>
    pub health_check: std::option::Option<crate::model::HealthCheck>,
    /// <p>A list of namespaced kernel parameters to set in the container. This parameter maps to
    /// <code>Sysctls</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
    /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--sysctl</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
    /// <note>
    /// <p>It is not recommended that you specify network-related <code>systemControls</code>
    /// parameters for multiple containers in a single task that also uses either the
    /// <code>awsvpc</code> or <code>host</code> network modes. For tasks that use the
    /// <code>awsvpc</code> network mode, the container that is started last determines
    /// which <code>systemControls</code> parameters take effect. For tasks that use the
    /// <code>host</code> network mode, it changes the container instance's namespaced
    /// kernel parameters as well as the containers.</p>
    /// </note>
    pub system_controls: std::option::Option<std::vec::Vec<crate::model::SystemControl>>,
    /// <p>The type and amount of a resource to assign to a container. The only supported
    /// resource is a GPU.</p>
    pub resource_requirements:
        std::option::Option<std::vec::Vec<crate::model::ResourceRequirement>>,
    /// <p>The FireLens configuration for the container. This is used to specify and configure a
    /// log router for container logs. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom Log Routing</a>
    /// in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub firelens_configuration: std::option::Option<crate::model::FirelensConfiguration>,
}
impl std::fmt::Debug for ContainerDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerDefinition");
        formatter.field("name", &self.name);
        formatter.field("image", &self.image);
        formatter.field("repository_credentials", &self.repository_credentials);
        formatter.field("cpu", &self.cpu);
        formatter.field("memory", &self.memory);
        formatter.field("memory_reservation", &self.memory_reservation);
        formatter.field("links", &self.links);
        formatter.field("port_mappings", &self.port_mappings);
        formatter.field("essential", &self.essential);
        formatter.field("entry_point", &self.entry_point);
        formatter.field("command", &self.command);
        formatter.field("environment", &self.environment);
        formatter.field("environment_files", &self.environment_files);
        formatter.field("mount_points", &self.mount_points);
        formatter.field("volumes_from", &self.volumes_from);
        formatter.field("linux_parameters", &self.linux_parameters);
        formatter.field("secrets", &self.secrets);
        formatter.field("depends_on", &self.depends_on);
        formatter.field("start_timeout", &self.start_timeout);
        formatter.field("stop_timeout", &self.stop_timeout);
        formatter.field("hostname", &self.hostname);
        formatter.field("user", &self.user);
        formatter.field("working_directory", &self.working_directory);
        formatter.field("disable_networking", &self.disable_networking);
        formatter.field("privileged", &self.privileged);
        formatter.field("readonly_root_filesystem", &self.readonly_root_filesystem);
        formatter.field("dns_servers", &self.dns_servers);
        formatter.field("dns_search_domains", &self.dns_search_domains);
        formatter.field("extra_hosts", &self.extra_hosts);
        formatter.field("docker_security_options", &self.docker_security_options);
        formatter.field("interactive", &self.interactive);
        formatter.field("pseudo_terminal", &self.pseudo_terminal);
        formatter.field("docker_labels", &self.docker_labels);
        formatter.field("ulimits", &self.ulimits);
        formatter.field("log_configuration", &self.log_configuration);
        formatter.field("health_check", &self.health_check);
        formatter.field("system_controls", &self.system_controls);
        formatter.field("resource_requirements", &self.resource_requirements);
        formatter.field("firelens_configuration", &self.firelens_configuration);
        formatter.finish()
    }
}
/// See [`ContainerDefinition`](crate::model::ContainerDefinition)
pub mod container_definition {
    /// A builder for [`ContainerDefinition`](crate::model::ContainerDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) image: std::option::Option<std::string::String>,
        pub(crate) repository_credentials: std::option::Option<crate::model::RepositoryCredentials>,
        pub(crate) cpu: std::option::Option<i32>,
        pub(crate) memory: std::option::Option<i32>,
        pub(crate) memory_reservation: std::option::Option<i32>,
        pub(crate) links: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) port_mappings: std::option::Option<std::vec::Vec<crate::model::PortMapping>>,
        pub(crate) essential: std::option::Option<bool>,
        pub(crate) entry_point: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) command: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) environment: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
        pub(crate) environment_files:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentFile>>,
        pub(crate) mount_points: std::option::Option<std::vec::Vec<crate::model::MountPoint>>,
        pub(crate) volumes_from: std::option::Option<std::vec::Vec<crate::model::VolumeFrom>>,
        pub(crate) linux_parameters: std::option::Option<crate::model::LinuxParameters>,
        pub(crate) secrets: std::option::Option<std::vec::Vec<crate::model::Secret>>,
        pub(crate) depends_on:
            std::option::Option<std::vec::Vec<crate::model::ContainerDependency>>,
        pub(crate) start_timeout: std::option::Option<i32>,
        pub(crate) stop_timeout: std::option::Option<i32>,
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) user: std::option::Option<std::string::String>,
        pub(crate) working_directory: std::option::Option<std::string::String>,
        pub(crate) disable_networking: std::option::Option<bool>,
        pub(crate) privileged: std::option::Option<bool>,
        pub(crate) readonly_root_filesystem: std::option::Option<bool>,
        pub(crate) dns_servers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) dns_search_domains: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) extra_hosts: std::option::Option<std::vec::Vec<crate::model::HostEntry>>,
        pub(crate) docker_security_options: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) interactive: std::option::Option<bool>,
        pub(crate) pseudo_terminal: std::option::Option<bool>,
        pub(crate) docker_labels: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) ulimits: std::option::Option<std::vec::Vec<crate::model::Ulimit>>,
        pub(crate) log_configuration: std::option::Option<crate::model::LogConfiguration>,
        pub(crate) health_check: std::option::Option<crate::model::HealthCheck>,
        pub(crate) system_controls: std::option::Option<std::vec::Vec<crate::model::SystemControl>>,
        pub(crate) resource_requirements:
            std::option::Option<std::vec::Vec<crate::model::ResourceRequirement>>,
        pub(crate) firelens_configuration: std::option::Option<crate::model::FirelensConfiguration>,
    }
    impl Builder {
        /// <p>The name of a container. If you are linking multiple containers together in a task
        /// definition, the <code>name</code> of one container can be entered in the
        /// <code>links</code> of another container to connect the containers.
        /// Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. This parameter maps to <code>name</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--name</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a container. If you are linking multiple containers together in a task
        /// definition, the <code>name</code> of one container can be entered in the
        /// <code>links</code> of another container to connect the containers.
        /// Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. This parameter maps to <code>name</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--name</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The image used to start a container. This string is passed directly to the Docker
        /// daemon. Images in the Docker Hub registry are available by default. Other repositories
        /// are specified with either <code>
        /// <i>repository-url</i>/<i>image</i>:<i>tag</i>
        /// </code> or <code>
        /// <i>repository-url</i>/<i>image</i>@<i>digest</i>
        /// </code>. Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to <code>Image</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>IMAGE</code> parameter of <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <ul>
        /// <li>
        /// <p>When a new task starts, the Amazon ECS container agent pulls the latest version of
        /// the specified image and tag for the container to use. However, subsequent
        /// updates to a repository image are not propagated to already running
        /// tasks.</p>
        /// </li>
        /// <li>
        /// <p>Images in Amazon ECR repositories can be specified by either using the full
        /// <code>registry/repository:tag</code> or
        /// <code>registry/repository@digest</code>. For example,
        /// <code>012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>:latest</code>
        /// or
        /// <code>012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>@sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>Images in official repositories on Docker Hub use a single name (for example,
        /// <code>ubuntu</code> or <code>mongo</code>).</p>
        /// </li>
        /// <li>
        /// <p>Images in other repositories on Docker Hub are qualified with an organization
        /// name (for example, <code>amazon/amazon-ecs-agent</code>).</p>
        /// </li>
        /// <li>
        /// <p>Images in other online repositories are qualified further by a domain name
        /// (for example, <code>quay.io/assemblyline/ubuntu</code>).</p>
        /// </li>
        /// </ul>
        pub fn image(mut self, input: impl Into<std::string::String>) -> Self {
            self.image = Some(input.into());
            self
        }
        /// <p>The image used to start a container. This string is passed directly to the Docker
        /// daemon. Images in the Docker Hub registry are available by default. Other repositories
        /// are specified with either <code>
        /// <i>repository-url</i>/<i>image</i>:<i>tag</i>
        /// </code> or <code>
        /// <i>repository-url</i>/<i>image</i>@<i>digest</i>
        /// </code>. Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to <code>Image</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>IMAGE</code> parameter of <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <ul>
        /// <li>
        /// <p>When a new task starts, the Amazon ECS container agent pulls the latest version of
        /// the specified image and tag for the container to use. However, subsequent
        /// updates to a repository image are not propagated to already running
        /// tasks.</p>
        /// </li>
        /// <li>
        /// <p>Images in Amazon ECR repositories can be specified by either using the full
        /// <code>registry/repository:tag</code> or
        /// <code>registry/repository@digest</code>. For example,
        /// <code>012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>:latest</code>
        /// or
        /// <code>012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>@sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>Images in official repositories on Docker Hub use a single name (for example,
        /// <code>ubuntu</code> or <code>mongo</code>).</p>
        /// </li>
        /// <li>
        /// <p>Images in other repositories on Docker Hub are qualified with an organization
        /// name (for example, <code>amazon/amazon-ecs-agent</code>).</p>
        /// </li>
        /// <li>
        /// <p>Images in other online repositories are qualified further by a domain name
        /// (for example, <code>quay.io/assemblyline/ubuntu</code>).</p>
        /// </li>
        /// </ul>
        pub fn set_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image = input;
            self
        }
        /// <p>The private repository authentication credentials to use.</p>
        pub fn repository_credentials(
            mut self,
            input: crate::model::RepositoryCredentials,
        ) -> Self {
            self.repository_credentials = Some(input);
            self
        }
        /// <p>The private repository authentication credentials to use.</p>
        pub fn set_repository_credentials(
            mut self,
            input: std::option::Option<crate::model::RepositoryCredentials>,
        ) -> Self {
            self.repository_credentials = input;
            self
        }
        /// <p>The number of <code>cpu</code> units reserved for the container. This parameter maps
        /// to <code>CpuShares</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--cpu-shares</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <p>This field is optional for tasks using the Fargate launch type, and the
        /// only requirement is that the total amount of CPU reserved for all containers within a
        /// task be lower than the task-level <code>cpu</code> value.</p>
        /// <note>
        /// <p>You can determine the number of CPU units that are available per EC2 instance type
        /// by multiplying the vCPUs listed for that instance type on the <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instances</a> detail page
        /// by 1,024.</p>
        /// </note>
        /// <p>Linux containers share unallocated CPU units with other containers on the container
        /// instance with the same ratio as their allocated amount. For example, if you run a
        /// single-container task on a single-core instance type with 512 CPU units specified for
        /// that container, and that is the only task running on the container instance, that
        /// container could use the full 1,024 CPU unit share at any given time. However, if you
        /// launched another copy of the same task on that container instance, each task would be
        /// guaranteed a minimum of 512 CPU units when needed, and each container could float to
        /// higher CPU usage if the other container was not using it, but if both tasks were 100%
        /// active all of the time, they would be limited to 512 CPU units.</p>
        /// <p>On Linux container instances, the Docker daemon on the container instance uses the CPU
        /// value to calculate the relative CPU share ratios for running containers. For more
        /// information, see <a href="https://docs.docker.com/engine/reference/run/#cpu-share-constraint">CPU share
        /// constraint</a> in the Docker documentation. The minimum valid CPU share value
        /// that the Linux kernel allows is 2. However, the CPU parameter is not required, and you
        /// can use CPU values below 2 in your container definitions. For CPU values below 2
        /// (including null), the behavior varies based on your Amazon ECS container agent
        /// version:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Agent versions less than or equal to 1.1.0:</b>
        /// Null and zero CPU values are passed to Docker as 0, which Docker then converts
        /// to 1,024 CPU shares. CPU values of 1 are passed to Docker as 1, which the Linux
        /// kernel converts to two CPU shares.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Agent versions greater than or equal to 1.2.0:</b>
        /// Null, zero, and CPU values of 1 are passed to Docker as 2.</p>
        /// </li>
        /// </ul>
        /// <p>On Windows container instances, the CPU limit is enforced as an absolute limit, or a
        /// quota. Windows containers only have access to the specified amount of CPU that is
        /// described in the task definition. A null or zero CPU value is passed to Docker as
        /// <code>0</code>, which Windows interprets as 1% of one CPU.</p>
        pub fn cpu(mut self, input: i32) -> Self {
            self.cpu = Some(input);
            self
        }
        /// <p>The number of <code>cpu</code> units reserved for the container. This parameter maps
        /// to <code>CpuShares</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--cpu-shares</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <p>This field is optional for tasks using the Fargate launch type, and the
        /// only requirement is that the total amount of CPU reserved for all containers within a
        /// task be lower than the task-level <code>cpu</code> value.</p>
        /// <note>
        /// <p>You can determine the number of CPU units that are available per EC2 instance type
        /// by multiplying the vCPUs listed for that instance type on the <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instances</a> detail page
        /// by 1,024.</p>
        /// </note>
        /// <p>Linux containers share unallocated CPU units with other containers on the container
        /// instance with the same ratio as their allocated amount. For example, if you run a
        /// single-container task on a single-core instance type with 512 CPU units specified for
        /// that container, and that is the only task running on the container instance, that
        /// container could use the full 1,024 CPU unit share at any given time. However, if you
        /// launched another copy of the same task on that container instance, each task would be
        /// guaranteed a minimum of 512 CPU units when needed, and each container could float to
        /// higher CPU usage if the other container was not using it, but if both tasks were 100%
        /// active all of the time, they would be limited to 512 CPU units.</p>
        /// <p>On Linux container instances, the Docker daemon on the container instance uses the CPU
        /// value to calculate the relative CPU share ratios for running containers. For more
        /// information, see <a href="https://docs.docker.com/engine/reference/run/#cpu-share-constraint">CPU share
        /// constraint</a> in the Docker documentation. The minimum valid CPU share value
        /// that the Linux kernel allows is 2. However, the CPU parameter is not required, and you
        /// can use CPU values below 2 in your container definitions. For CPU values below 2
        /// (including null), the behavior varies based on your Amazon ECS container agent
        /// version:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Agent versions less than or equal to 1.1.0:</b>
        /// Null and zero CPU values are passed to Docker as 0, which Docker then converts
        /// to 1,024 CPU shares. CPU values of 1 are passed to Docker as 1, which the Linux
        /// kernel converts to two CPU shares.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Agent versions greater than or equal to 1.2.0:</b>
        /// Null, zero, and CPU values of 1 are passed to Docker as 2.</p>
        /// </li>
        /// </ul>
        /// <p>On Windows container instances, the CPU limit is enforced as an absolute limit, or a
        /// quota. Windows containers only have access to the specified amount of CPU that is
        /// described in the task definition. A null or zero CPU value is passed to Docker as
        /// <code>0</code>, which Windows interprets as 1% of one CPU.</p>
        pub fn set_cpu(mut self, input: std::option::Option<i32>) -> Self {
            self.cpu = input;
            self
        }
        /// <p>The amount (in MiB) of memory to present to the container. If your container attempts
        /// to exceed the memory specified here, the container is killed. The total amount of memory
        /// reserved for all containers within a task must be lower than the task
        /// <code>memory</code> value, if one is specified. This parameter maps to
        /// <code>Memory</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <p>If using the Fargate launch type, this parameter is optional.</p>
        /// <p>If using the EC2 launch type, you must specify either a task-level
        /// memory value or a container-level memory value. If you specify both a container-level
        /// <code>memory</code> and <code>memoryReservation</code> value, <code>memory</code>
        /// must be greater than <code>memoryReservation</code>. If you specify
        /// <code>memoryReservation</code>, then that value is subtracted from the available
        /// memory resources for the container instance on which the container is placed. Otherwise,
        /// the value of <code>memory</code> is used.</p>
        /// <p>The Docker daemon reserves a minimum of 4 MiB of memory for a container, so you should
        /// not specify fewer than 4 MiB of memory for your containers.</p>
        pub fn memory(mut self, input: i32) -> Self {
            self.memory = Some(input);
            self
        }
        /// <p>The amount (in MiB) of memory to present to the container. If your container attempts
        /// to exceed the memory specified here, the container is killed. The total amount of memory
        /// reserved for all containers within a task must be lower than the task
        /// <code>memory</code> value, if one is specified. This parameter maps to
        /// <code>Memory</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <p>If using the Fargate launch type, this parameter is optional.</p>
        /// <p>If using the EC2 launch type, you must specify either a task-level
        /// memory value or a container-level memory value. If you specify both a container-level
        /// <code>memory</code> and <code>memoryReservation</code> value, <code>memory</code>
        /// must be greater than <code>memoryReservation</code>. If you specify
        /// <code>memoryReservation</code>, then that value is subtracted from the available
        /// memory resources for the container instance on which the container is placed. Otherwise,
        /// the value of <code>memory</code> is used.</p>
        /// <p>The Docker daemon reserves a minimum of 4 MiB of memory for a container, so you should
        /// not specify fewer than 4 MiB of memory for your containers.</p>
        pub fn set_memory(mut self, input: std::option::Option<i32>) -> Self {
            self.memory = input;
            self
        }
        /// <p>The soft limit (in MiB) of memory to reserve for the container. When system memory is
        /// under heavy contention, Docker attempts to keep the container memory to this soft limit.
        /// However, your container can consume more memory when it needs to, up to either the hard
        /// limit specified with the <code>memory</code> parameter (if applicable), or all of the
        /// available memory on the container instance, whichever comes first. This parameter maps
        /// to <code>MemoryReservation</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
        /// the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--memory-reservation</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <p>If a task-level memory value is not specified, you must specify a non-zero integer for
        /// one or both of <code>memory</code> or <code>memoryReservation</code> in a container
        /// definition. If you specify both, <code>memory</code> must be greater than
        /// <code>memoryReservation</code>. If you specify <code>memoryReservation</code>, then
        /// that value is subtracted from the available memory resources for the container instance
        /// on which the container is placed. Otherwise, the value of <code>memory</code> is
        /// used.</p>
        /// <p>For example, if your container normally uses 128 MiB of memory, but occasionally
        /// bursts to 256 MiB of memory for short periods of time, you can set a
        /// <code>memoryReservation</code> of 128 MiB, and a <code>memory</code> hard limit of
        /// 300 MiB. This configuration would allow the container to only reserve 128 MiB of memory
        /// from the remaining resources on the container instance, but also allow the container to
        /// consume more memory resources when needed.</p>
        /// <p>The Docker daemon reserves a minimum of 4 MiB of memory for a container, so you should
        /// not specify fewer than 4 MiB of memory for your containers. </p>
        pub fn memory_reservation(mut self, input: i32) -> Self {
            self.memory_reservation = Some(input);
            self
        }
        /// <p>The soft limit (in MiB) of memory to reserve for the container. When system memory is
        /// under heavy contention, Docker attempts to keep the container memory to this soft limit.
        /// However, your container can consume more memory when it needs to, up to either the hard
        /// limit specified with the <code>memory</code> parameter (if applicable), or all of the
        /// available memory on the container instance, whichever comes first. This parameter maps
        /// to <code>MemoryReservation</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of
        /// the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--memory-reservation</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <p>If a task-level memory value is not specified, you must specify a non-zero integer for
        /// one or both of <code>memory</code> or <code>memoryReservation</code> in a container
        /// definition. If you specify both, <code>memory</code> must be greater than
        /// <code>memoryReservation</code>. If you specify <code>memoryReservation</code>, then
        /// that value is subtracted from the available memory resources for the container instance
        /// on which the container is placed. Otherwise, the value of <code>memory</code> is
        /// used.</p>
        /// <p>For example, if your container normally uses 128 MiB of memory, but occasionally
        /// bursts to 256 MiB of memory for short periods of time, you can set a
        /// <code>memoryReservation</code> of 128 MiB, and a <code>memory</code> hard limit of
        /// 300 MiB. This configuration would allow the container to only reserve 128 MiB of memory
        /// from the remaining resources on the container instance, but also allow the container to
        /// consume more memory resources when needed.</p>
        /// <p>The Docker daemon reserves a minimum of 4 MiB of memory for a container, so you should
        /// not specify fewer than 4 MiB of memory for your containers. </p>
        pub fn set_memory_reservation(mut self, input: std::option::Option<i32>) -> Self {
            self.memory_reservation = input;
            self
        }
        /// Appends an item to `links`.
        ///
        /// To override the contents of this collection use [`set_links`](Self::set_links).
        ///
        /// <p>The <code>links</code> parameter allows containers to communicate with each other
        /// without the need for port mappings. This parameter is only supported if the network mode
        /// of a task definition is <code>bridge</code>. The <code>name:internalName</code>
        /// construct is analogous to <code>name:alias</code> in Docker links.
        /// Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. For more information about linking Docker containers, go to
        /// <a href="https://docs.docker.com/network/links/">Legacy container links</a>
        /// in the Docker documentation. This parameter maps to <code>Links</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--link</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers.</p>
        /// </note>
        /// <important>
        /// <p>Containers that are collocated on a single container instance may be able to
        /// communicate with each other without requiring links or host port mappings. Network
        /// isolation is achieved on the container instance using security groups and VPC
        /// settings.</p>
        /// </important>
        pub fn links(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.links.unwrap_or_default();
            v.push(input.into());
            self.links = Some(v);
            self
        }
        /// <p>The <code>links</code> parameter allows containers to communicate with each other
        /// without the need for port mappings. This parameter is only supported if the network mode
        /// of a task definition is <code>bridge</code>. The <code>name:internalName</code>
        /// construct is analogous to <code>name:alias</code> in Docker links.
        /// Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. For more information about linking Docker containers, go to
        /// <a href="https://docs.docker.com/network/links/">Legacy container links</a>
        /// in the Docker documentation. This parameter maps to <code>Links</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--link</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers.</p>
        /// </note>
        /// <important>
        /// <p>Containers that are collocated on a single container instance may be able to
        /// communicate with each other without requiring links or host port mappings. Network
        /// isolation is achieved on the container instance using security groups and VPC
        /// settings.</p>
        /// </important>
        pub fn set_links(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.links = input;
            self
        }
        /// Appends an item to `port_mappings`.
        ///
        /// To override the contents of this collection use [`set_port_mappings`](Self::set_port_mappings).
        ///
        /// <p>The list of port mappings for the container. Port mappings allow containers to access
        /// ports on the host container instance to send or receive traffic.</p>
        /// <p>For task definitions that use the <code>awsvpc</code> network mode, you should only
        /// specify the <code>containerPort</code>. The <code>hostPort</code> can be left blank or
        /// it must be the same value as the <code>containerPort</code>.</p>
        /// <p>Port mappings on Windows use the <code>NetNAT</code> gateway address rather than
        /// <code>localhost</code>. There is no loopback for port mappings on Windows, so you
        /// cannot access a container's mapped port from the host itself. </p>
        /// <p>This parameter maps to <code>PortBindings</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--publish</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>. If the network mode of a task definition is set to <code>none</code>,
        /// then you can't specify port mappings. If the network mode of a task definition is set to
        /// <code>host</code>, then host ports must either be undefined or they must match the
        /// container port in the port mapping.</p>
        /// <note>
        /// <p>After a task reaches the <code>RUNNING</code> status, manual and automatic host
        /// and container port assignments are visible in the <b>Network
        /// Bindings</b> section of a container description for a selected task in
        /// the Amazon ECS console. The assignments are also visible in the
        /// <code>networkBindings</code> section <a>DescribeTasks</a>
        /// responses.</p>
        /// </note>
        pub fn port_mappings(mut self, input: impl Into<crate::model::PortMapping>) -> Self {
            let mut v = self.port_mappings.unwrap_or_default();
            v.push(input.into());
            self.port_mappings = Some(v);
            self
        }
        /// <p>The list of port mappings for the container. Port mappings allow containers to access
        /// ports on the host container instance to send or receive traffic.</p>
        /// <p>For task definitions that use the <code>awsvpc</code> network mode, you should only
        /// specify the <code>containerPort</code>. The <code>hostPort</code> can be left blank or
        /// it must be the same value as the <code>containerPort</code>.</p>
        /// <p>Port mappings on Windows use the <code>NetNAT</code> gateway address rather than
        /// <code>localhost</code>. There is no loopback for port mappings on Windows, so you
        /// cannot access a container's mapped port from the host itself. </p>
        /// <p>This parameter maps to <code>PortBindings</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--publish</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>. If the network mode of a task definition is set to <code>none</code>,
        /// then you can't specify port mappings. If the network mode of a task definition is set to
        /// <code>host</code>, then host ports must either be undefined or they must match the
        /// container port in the port mapping.</p>
        /// <note>
        /// <p>After a task reaches the <code>RUNNING</code> status, manual and automatic host
        /// and container port assignments are visible in the <b>Network
        /// Bindings</b> section of a container description for a selected task in
        /// the Amazon ECS console. The assignments are also visible in the
        /// <code>networkBindings</code> section <a>DescribeTasks</a>
        /// responses.</p>
        /// </note>
        pub fn set_port_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortMapping>>,
        ) -> Self {
            self.port_mappings = input;
            self
        }
        /// <p>If the <code>essential</code> parameter of a container is marked as <code>true</code>,
        /// and that container fails or stops for any reason, all other containers that are part of
        /// the task are stopped. If the <code>essential</code> parameter of a container is marked
        /// as <code>false</code>, then its failure does not affect the rest of the containers in a
        /// task. If this parameter is omitted, a container is assumed to be essential.</p>
        /// <p>All tasks must have at least one essential container. If you have an application that
        /// is composed of multiple containers, you should group containers that are used for a
        /// common purpose into components, and separate the different components into multiple task
        /// definitions. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html">Application
        /// Architecture</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn essential(mut self, input: bool) -> Self {
            self.essential = Some(input);
            self
        }
        /// <p>If the <code>essential</code> parameter of a container is marked as <code>true</code>,
        /// and that container fails or stops for any reason, all other containers that are part of
        /// the task are stopped. If the <code>essential</code> parameter of a container is marked
        /// as <code>false</code>, then its failure does not affect the rest of the containers in a
        /// task. If this parameter is omitted, a container is assumed to be essential.</p>
        /// <p>All tasks must have at least one essential container. If you have an application that
        /// is composed of multiple containers, you should group containers that are used for a
        /// common purpose into components, and separate the different components into multiple task
        /// definitions. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html">Application
        /// Architecture</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_essential(mut self, input: std::option::Option<bool>) -> Self {
            self.essential = input;
            self
        }
        /// Appends an item to `entry_point`.
        ///
        /// To override the contents of this collection use [`set_entry_point`](Self::set_entry_point).
        ///
        /// <important>
        /// <p>Early versions of the Amazon ECS container agent do not properly handle
        /// <code>entryPoint</code> parameters. If you have problems using
        /// <code>entryPoint</code>, update your container agent or enter your commands and
        /// arguments as <code>command</code> array items instead.</p>
        /// </important>
        /// <p>The entry point that is passed to the container. This parameter maps to
        /// <code>Entrypoint</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--entrypoint</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>. For more information, see <a href="https://docs.docker.com/engine/reference/builder/#entrypoint">https://docs.docker.com/engine/reference/builder/#entrypoint</a>.</p>
        pub fn entry_point(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.entry_point.unwrap_or_default();
            v.push(input.into());
            self.entry_point = Some(v);
            self
        }
        /// <important>
        /// <p>Early versions of the Amazon ECS container agent do not properly handle
        /// <code>entryPoint</code> parameters. If you have problems using
        /// <code>entryPoint</code>, update your container agent or enter your commands and
        /// arguments as <code>command</code> array items instead.</p>
        /// </important>
        /// <p>The entry point that is passed to the container. This parameter maps to
        /// <code>Entrypoint</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--entrypoint</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>. For more information, see <a href="https://docs.docker.com/engine/reference/builder/#entrypoint">https://docs.docker.com/engine/reference/builder/#entrypoint</a>.</p>
        pub fn set_entry_point(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.entry_point = input;
            self
        }
        /// Appends an item to `command`.
        ///
        /// To override the contents of this collection use [`set_command`](Self::set_command).
        ///
        /// <p>The command that is passed to the container. This parameter maps to <code>Cmd</code>
        /// in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>COMMAND</code> parameter to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>. For more information, see <a href="https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/builder/#cmd</a>. If there are multiple arguments, each
        /// argument should be a separated string in the array.</p>
        pub fn command(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.command.unwrap_or_default();
            v.push(input.into());
            self.command = Some(v);
            self
        }
        /// <p>The command that is passed to the container. This parameter maps to <code>Cmd</code>
        /// in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>COMMAND</code> parameter to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>. For more information, see <a href="https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/builder/#cmd</a>. If there are multiple arguments, each
        /// argument should be a separated string in the array.</p>
        pub fn set_command(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.command = input;
            self
        }
        /// Appends an item to `environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>The environment variables to pass to a container. This parameter maps to
        /// <code>Env</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--env</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <important>
        /// <p>We do not recommend using plaintext environment variables for sensitive
        /// information, such as credential data.</p>
        /// </important>
        pub fn environment(mut self, input: impl Into<crate::model::KeyValuePair>) -> Self {
            let mut v = self.environment.unwrap_or_default();
            v.push(input.into());
            self.environment = Some(v);
            self
        }
        /// <p>The environment variables to pass to a container. This parameter maps to
        /// <code>Env</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--env</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <important>
        /// <p>We do not recommend using plaintext environment variables for sensitive
        /// information, such as credential data.</p>
        /// </important>
        pub fn set_environment(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Appends an item to `environment_files`.
        ///
        /// To override the contents of this collection use [`set_environment_files`](Self::set_environment_files).
        ///
        /// <p>A list of files containing the environment variables to pass to a container. This
        /// parameter maps to the <code>--env-file</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <p>You can specify up to ten environment files. The file must have a <code>.env</code>
        /// file extension. Each line in an environment file should contain an environment variable
        /// in <code>VARIABLE=VALUE</code> format. Lines beginning with <code>#</code> are treated
        /// as comments and are ignored. For more information on the environment variable file
        /// syntax, see <a href="https://docs.docker.com/compose/env-file/">Declare default
        /// environment variables in file</a>.</p>
        /// <p>If there are environment variables specified using the <code>environment</code>
        /// parameter in a container definition, they take precedence over the variables contained
        /// within an environment file. If multiple environment files are specified that contain the
        /// same variable, they are processed from the top down. It is recommended to use unique
        /// variable names. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html">Specifying Environment
        /// Variables</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn environment_files(
            mut self,
            input: impl Into<crate::model::EnvironmentFile>,
        ) -> Self {
            let mut v = self.environment_files.unwrap_or_default();
            v.push(input.into());
            self.environment_files = Some(v);
            self
        }
        /// <p>A list of files containing the environment variables to pass to a container. This
        /// parameter maps to the <code>--env-file</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <p>You can specify up to ten environment files. The file must have a <code>.env</code>
        /// file extension. Each line in an environment file should contain an environment variable
        /// in <code>VARIABLE=VALUE</code> format. Lines beginning with <code>#</code> are treated
        /// as comments and are ignored. For more information on the environment variable file
        /// syntax, see <a href="https://docs.docker.com/compose/env-file/">Declare default
        /// environment variables in file</a>.</p>
        /// <p>If there are environment variables specified using the <code>environment</code>
        /// parameter in a container definition, they take precedence over the variables contained
        /// within an environment file. If multiple environment files are specified that contain the
        /// same variable, they are processed from the top down. It is recommended to use unique
        /// variable names. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html">Specifying Environment
        /// Variables</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_environment_files(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentFile>>,
        ) -> Self {
            self.environment_files = input;
            self
        }
        /// Appends an item to `mount_points`.
        ///
        /// To override the contents of this collection use [`set_mount_points`](Self::set_mount_points).
        ///
        /// <p>The mount points for data volumes in your container.</p>
        /// <p>This parameter maps to <code>Volumes</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
        /// section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--volume</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <p>Windows containers can mount whole directories on the same drive as
        /// <code>$env:ProgramData</code>. Windows containers cannot mount directories on a
        /// different drive, and mount point cannot be across drives.</p>
        pub fn mount_points(mut self, input: impl Into<crate::model::MountPoint>) -> Self {
            let mut v = self.mount_points.unwrap_or_default();
            v.push(input.into());
            self.mount_points = Some(v);
            self
        }
        /// <p>The mount points for data volumes in your container.</p>
        /// <p>This parameter maps to <code>Volumes</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
        /// section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--volume</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <p>Windows containers can mount whole directories on the same drive as
        /// <code>$env:ProgramData</code>. Windows containers cannot mount directories on a
        /// different drive, and mount point cannot be across drives.</p>
        pub fn set_mount_points(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MountPoint>>,
        ) -> Self {
            self.mount_points = input;
            self
        }
        /// Appends an item to `volumes_from`.
        ///
        /// To override the contents of this collection use [`set_volumes_from`](Self::set_volumes_from).
        ///
        /// <p>Data volumes to mount from another container. This parameter maps to
        /// <code>VolumesFrom</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--volumes-from</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        pub fn volumes_from(mut self, input: impl Into<crate::model::VolumeFrom>) -> Self {
            let mut v = self.volumes_from.unwrap_or_default();
            v.push(input.into());
            self.volumes_from = Some(v);
            self
        }
        /// <p>Data volumes to mount from another container. This parameter maps to
        /// <code>VolumesFrom</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--volumes-from</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        pub fn set_volumes_from(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VolumeFrom>>,
        ) -> Self {
            self.volumes_from = input;
            self
        }
        /// <p>Linux-specific modifications that are applied to the container, such as Linux kernel
        /// capabilities. For more information see <a>KernelCapabilities</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers.</p>
        /// </note>
        pub fn linux_parameters(mut self, input: crate::model::LinuxParameters) -> Self {
            self.linux_parameters = Some(input);
            self
        }
        /// <p>Linux-specific modifications that are applied to the container, such as Linux kernel
        /// capabilities. For more information see <a>KernelCapabilities</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers.</p>
        /// </note>
        pub fn set_linux_parameters(
            mut self,
            input: std::option::Option<crate::model::LinuxParameters>,
        ) -> Self {
            self.linux_parameters = input;
            self
        }
        /// Appends an item to `secrets`.
        ///
        /// To override the contents of this collection use [`set_secrets`](Self::set_secrets).
        ///
        /// <p>The secrets to pass to the container. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying
        /// Sensitive Data</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn secrets(mut self, input: impl Into<crate::model::Secret>) -> Self {
            let mut v = self.secrets.unwrap_or_default();
            v.push(input.into());
            self.secrets = Some(v);
            self
        }
        /// <p>The secrets to pass to the container. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying
        /// Sensitive Data</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_secrets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Secret>>,
        ) -> Self {
            self.secrets = input;
            self
        }
        /// Appends an item to `depends_on`.
        ///
        /// To override the contents of this collection use [`set_depends_on`](Self::set_depends_on).
        ///
        /// <p>The dependencies defined for container startup and shutdown. A container can contain
        /// multiple dependencies. When a dependency is defined for container startup, for container
        /// shutdown it is reversed.</p>
        /// <p>For tasks using the EC2 launch type, the container instances require at
        /// least version 1.26.0 of the container agent to enable container dependencies. However,
        /// we recommend using the latest container agent version. For information about checking
        /// your agent version and updating to the latest version, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS
        /// Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are
        /// using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the
        /// <code>ecs-init</code> package. If your container instances are launched from version
        /// <code>20190301</code> or later, then they contain the required versions of the
        /// container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>For tasks using the Fargate launch type, the task or service requires the followiwng platforms:</p>
        /// <ul>
        /// <li>
        /// <p>Linux platform
        /// version <code>1.3.0</code> or later.</p>
        /// </li>
        /// <li>
        /// <p>Windows platform
        /// version <code>1.0.0</code> or later.</p>
        /// </li>
        /// </ul>
        pub fn depends_on(mut self, input: impl Into<crate::model::ContainerDependency>) -> Self {
            let mut v = self.depends_on.unwrap_or_default();
            v.push(input.into());
            self.depends_on = Some(v);
            self
        }
        /// <p>The dependencies defined for container startup and shutdown. A container can contain
        /// multiple dependencies. When a dependency is defined for container startup, for container
        /// shutdown it is reversed.</p>
        /// <p>For tasks using the EC2 launch type, the container instances require at
        /// least version 1.26.0 of the container agent to enable container dependencies. However,
        /// we recommend using the latest container agent version. For information about checking
        /// your agent version and updating to the latest version, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS
        /// Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are
        /// using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the
        /// <code>ecs-init</code> package. If your container instances are launched from version
        /// <code>20190301</code> or later, then they contain the required versions of the
        /// container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>For tasks using the Fargate launch type, the task or service requires the followiwng platforms:</p>
        /// <ul>
        /// <li>
        /// <p>Linux platform
        /// version <code>1.3.0</code> or later.</p>
        /// </li>
        /// <li>
        /// <p>Windows platform
        /// version <code>1.0.0</code> or later.</p>
        /// </li>
        /// </ul>
        pub fn set_depends_on(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContainerDependency>>,
        ) -> Self {
            self.depends_on = input;
            self
        }
        /// <p>Time duration (in seconds) to wait before giving up on resolving dependencies for a
        /// container. For example, you specify two containers in a task definition with containerA
        /// having a dependency on containerB reaching a <code>COMPLETE</code>,
        /// <code>SUCCESS</code>, or <code>HEALTHY</code> status. If a <code>startTimeout</code>
        /// value is specified for containerB and it does not reach the desired status within that
        /// time then containerA will give up and not start. This results in the task transitioning
        /// to a <code>STOPPED</code> state.</p>
        /// <note>
        /// <p>When the <code>ECS_CONTAINER_START_TIMEOUT</code> container agent configuration
        /// variable is used, it is enforced indendently from this start timeout value.</p>
        /// </note>
        /// <p>For tasks using the Fargate launch type, the task or service requires the followiwng platforms:</p>
        /// <ul>
        /// <li>
        /// <p>Linux platform
        /// version <code>1.3.0</code> or later.</p>
        /// </li>
        /// <li>
        /// <p>Windows platform
        /// version <code>1.0.0</code> or later.</p>
        /// </li>
        /// </ul>
        /// <p>For tasks using the EC2 launch type, your container instances require at
        /// least version <code>1.26.0</code> of the container agent to enable a container start
        /// timeout value. However, we recommend using the latest container agent version. For
        /// information about checking your agent version and updating to the latest version, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS
        /// Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are
        /// using an Amazon ECS-optimized Linux AMI, your instance needs at least version <code>1.26.0-1</code> of
        /// the <code>ecs-init</code> package. If your container instances are launched from version
        /// <code>20190301</code> or later, then they contain the required versions of the
        /// container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn start_timeout(mut self, input: i32) -> Self {
            self.start_timeout = Some(input);
            self
        }
        /// <p>Time duration (in seconds) to wait before giving up on resolving dependencies for a
        /// container. For example, you specify two containers in a task definition with containerA
        /// having a dependency on containerB reaching a <code>COMPLETE</code>,
        /// <code>SUCCESS</code>, or <code>HEALTHY</code> status. If a <code>startTimeout</code>
        /// value is specified for containerB and it does not reach the desired status within that
        /// time then containerA will give up and not start. This results in the task transitioning
        /// to a <code>STOPPED</code> state.</p>
        /// <note>
        /// <p>When the <code>ECS_CONTAINER_START_TIMEOUT</code> container agent configuration
        /// variable is used, it is enforced indendently from this start timeout value.</p>
        /// </note>
        /// <p>For tasks using the Fargate launch type, the task or service requires the followiwng platforms:</p>
        /// <ul>
        /// <li>
        /// <p>Linux platform
        /// version <code>1.3.0</code> or later.</p>
        /// </li>
        /// <li>
        /// <p>Windows platform
        /// version <code>1.0.0</code> or later.</p>
        /// </li>
        /// </ul>
        /// <p>For tasks using the EC2 launch type, your container instances require at
        /// least version <code>1.26.0</code> of the container agent to enable a container start
        /// timeout value. However, we recommend using the latest container agent version. For
        /// information about checking your agent version and updating to the latest version, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS
        /// Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are
        /// using an Amazon ECS-optimized Linux AMI, your instance needs at least version <code>1.26.0-1</code> of
        /// the <code>ecs-init</code> package. If your container instances are launched from version
        /// <code>20190301</code> or later, then they contain the required versions of the
        /// container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_start_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.start_timeout = input;
            self
        }
        /// <p>Time duration (in seconds) to wait before the container is forcefully killed if it
        /// doesn't exit normally on its own.</p>
        /// <p>For tasks using the Fargate launch type, the task or service requires the followiwng platforms:</p>
        /// <ul>
        /// <li>
        /// <p>Linux platform
        /// version <code>1.3.0</code> or later.</p>
        /// </li>
        /// <li>
        /// <p>Windows platform
        /// version <code>1.0.0</code> or later.</p>
        /// </li>
        /// </ul>
        /// <p>The max stop timeout value is 120 seconds and if the
        /// parameter is not specified, the default value of 30 seconds is used.</p>
        /// <p>For tasks using the EC2 launch type, if the <code>stopTimeout</code>
        /// parameter is not specified, the value set for the Amazon ECS container agent configuration
        /// variable <code>ECS_CONTAINER_STOP_TIMEOUT</code> is used by default. If neither the
        /// <code>stopTimeout</code> parameter or the <code>ECS_CONTAINER_STOP_TIMEOUT</code>
        /// agent configuration variable are set, then the default values of 30 seconds for Linux
        /// containers and 30 seconds on Windows containers are used. Your container instances
        /// require at least version 1.26.0 of the container agent to enable a container stop
        /// timeout value. However, we recommend using the latest container agent version. For
        /// information about checking your agent version and updating to the latest version, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS
        /// Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are
        /// using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the
        /// <code>ecs-init</code> package. If your container instances are launched from version
        /// <code>20190301</code> or later, then they contain the required versions of the
        /// container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn stop_timeout(mut self, input: i32) -> Self {
            self.stop_timeout = Some(input);
            self
        }
        /// <p>Time duration (in seconds) to wait before the container is forcefully killed if it
        /// doesn't exit normally on its own.</p>
        /// <p>For tasks using the Fargate launch type, the task or service requires the followiwng platforms:</p>
        /// <ul>
        /// <li>
        /// <p>Linux platform
        /// version <code>1.3.0</code> or later.</p>
        /// </li>
        /// <li>
        /// <p>Windows platform
        /// version <code>1.0.0</code> or later.</p>
        /// </li>
        /// </ul>
        /// <p>The max stop timeout value is 120 seconds and if the
        /// parameter is not specified, the default value of 30 seconds is used.</p>
        /// <p>For tasks using the EC2 launch type, if the <code>stopTimeout</code>
        /// parameter is not specified, the value set for the Amazon ECS container agent configuration
        /// variable <code>ECS_CONTAINER_STOP_TIMEOUT</code> is used by default. If neither the
        /// <code>stopTimeout</code> parameter or the <code>ECS_CONTAINER_STOP_TIMEOUT</code>
        /// agent configuration variable are set, then the default values of 30 seconds for Linux
        /// containers and 30 seconds on Windows containers are used. Your container instances
        /// require at least version 1.26.0 of the container agent to enable a container stop
        /// timeout value. However, we recommend using the latest container agent version. For
        /// information about checking your agent version and updating to the latest version, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS
        /// Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are
        /// using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the
        /// <code>ecs-init</code> package. If your container instances are launched from version
        /// <code>20190301</code> or later, then they contain the required versions of the
        /// container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_stop_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.stop_timeout = input;
            self
        }
        /// <p>The hostname to use for your container. This parameter maps to <code>Hostname</code>
        /// in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--hostname</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <note>
        /// <p>The <code>hostname</code> parameter is not supported if you are using the
        /// <code>awsvpc</code> network mode.</p>
        /// </note>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// <p>The hostname to use for your container. This parameter maps to <code>Hostname</code>
        /// in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--hostname</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <note>
        /// <p>The <code>hostname</code> parameter is not supported if you are using the
        /// <code>awsvpc</code> network mode.</p>
        /// </note>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// <p>The user to use inside the container. This parameter maps to <code>User</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--user</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <important>
        /// <p>When running tasks using the <code>host</code> network mode, you should not run
        /// containers using the root user (UID 0). It is considered best practice to use a
        /// non-root user.</p>
        /// </important>
        /// <p>You can specify the <code>user</code> using the following formats. If specifying a UID
        /// or GID, you must specify it as a positive integer.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>user</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>user:group</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>uid</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>uid:gid</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>user:gid</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>uid:group</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This parameter is not supported for Windows containers.</p>
        /// </note>
        pub fn user(mut self, input: impl Into<std::string::String>) -> Self {
            self.user = Some(input.into());
            self
        }
        /// <p>The user to use inside the container. This parameter maps to <code>User</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--user</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <important>
        /// <p>When running tasks using the <code>host</code> network mode, you should not run
        /// containers using the root user (UID 0). It is considered best practice to use a
        /// non-root user.</p>
        /// </important>
        /// <p>You can specify the <code>user</code> using the following formats. If specifying a UID
        /// or GID, you must specify it as a positive integer.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>user</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>user:group</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>uid</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>uid:gid</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>user:gid</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>uid:group</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This parameter is not supported for Windows containers.</p>
        /// </note>
        pub fn set_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user = input;
            self
        }
        /// <p>The working directory in which to run commands inside the container. This parameter
        /// maps to <code>WorkingDir</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--workdir</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        pub fn working_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.working_directory = Some(input.into());
            self
        }
        /// <p>The working directory in which to run commands inside the container. This parameter
        /// maps to <code>WorkingDir</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--workdir</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        pub fn set_working_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.working_directory = input;
            self
        }
        /// <p>When this parameter is true, networking is disabled within the container. This
        /// parameter maps to <code>NetworkDisabled</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
        /// section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers.</p>
        /// </note>
        pub fn disable_networking(mut self, input: bool) -> Self {
            self.disable_networking = Some(input);
            self
        }
        /// <p>When this parameter is true, networking is disabled within the container. This
        /// parameter maps to <code>NetworkDisabled</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
        /// section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers.</p>
        /// </note>
        pub fn set_disable_networking(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_networking = input;
            self
        }
        /// <p>When this parameter is true, the container is given elevated privileges on the host
        /// container instance (similar to the <code>root</code> user). This parameter maps to
        /// <code>Privileged</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--privileged</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
        /// </note>
        pub fn privileged(mut self, input: bool) -> Self {
            self.privileged = Some(input);
            self
        }
        /// <p>When this parameter is true, the container is given elevated privileges on the host
        /// container instance (similar to the <code>root</code> user). This parameter maps to
        /// <code>Privileged</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--privileged</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
        /// </note>
        pub fn set_privileged(mut self, input: std::option::Option<bool>) -> Self {
            self.privileged = input;
            self
        }
        /// <p>When this parameter is true, the container is given read-only access to its root file
        /// system. This parameter maps to <code>ReadonlyRootfs</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--read-only</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers.</p>
        /// </note>
        pub fn readonly_root_filesystem(mut self, input: bool) -> Self {
            self.readonly_root_filesystem = Some(input);
            self
        }
        /// <p>When this parameter is true, the container is given read-only access to its root file
        /// system. This parameter maps to <code>ReadonlyRootfs</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--read-only</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers.</p>
        /// </note>
        pub fn set_readonly_root_filesystem(mut self, input: std::option::Option<bool>) -> Self {
            self.readonly_root_filesystem = input;
            self
        }
        /// Appends an item to `dns_servers`.
        ///
        /// To override the contents of this collection use [`set_dns_servers`](Self::set_dns_servers).
        ///
        /// <p>A list of DNS servers that are presented to the container. This parameter maps to
        /// <code>Dns</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--dns</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers.</p>
        /// </note>
        pub fn dns_servers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dns_servers.unwrap_or_default();
            v.push(input.into());
            self.dns_servers = Some(v);
            self
        }
        /// <p>A list of DNS servers that are presented to the container. This parameter maps to
        /// <code>Dns</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--dns</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers.</p>
        /// </note>
        pub fn set_dns_servers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dns_servers = input;
            self
        }
        /// Appends an item to `dns_search_domains`.
        ///
        /// To override the contents of this collection use [`set_dns_search_domains`](Self::set_dns_search_domains).
        ///
        /// <p>A list of DNS search domains that are presented to the container. This parameter maps
        /// to <code>DnsSearch</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--dns-search</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers.</p>
        /// </note>
        pub fn dns_search_domains(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dns_search_domains.unwrap_or_default();
            v.push(input.into());
            self.dns_search_domains = Some(v);
            self
        }
        /// <p>A list of DNS search domains that are presented to the container. This parameter maps
        /// to <code>DnsSearch</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--dns-search</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers.</p>
        /// </note>
        pub fn set_dns_search_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dns_search_domains = input;
            self
        }
        /// Appends an item to `extra_hosts`.
        ///
        /// To override the contents of this collection use [`set_extra_hosts`](Self::set_extra_hosts).
        ///
        /// <p>A list of hostnames and IP address mappings to append to the <code>/etc/hosts</code>
        /// file on the container. This parameter maps to <code>ExtraHosts</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--add-host</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers or tasks that use the
        /// <code>awsvpc</code> network mode.</p>
        /// </note>
        pub fn extra_hosts(mut self, input: impl Into<crate::model::HostEntry>) -> Self {
            let mut v = self.extra_hosts.unwrap_or_default();
            v.push(input.into());
            self.extra_hosts = Some(v);
            self
        }
        /// <p>A list of hostnames and IP address mappings to append to the <code>/etc/hosts</code>
        /// file on the container. This parameter maps to <code>ExtraHosts</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--add-host</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers or tasks that use the
        /// <code>awsvpc</code> network mode.</p>
        /// </note>
        pub fn set_extra_hosts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HostEntry>>,
        ) -> Self {
            self.extra_hosts = input;
            self
        }
        /// Appends an item to `docker_security_options`.
        ///
        /// To override the contents of this collection use [`set_docker_security_options`](Self::set_docker_security_options).
        ///
        /// <p>A list of strings to provide custom labels for SELinux and AppArmor multi-level
        /// security systems. This field is not valid for containers in tasks using the
        /// Fargate launch type.</p>
        /// <p>With Windows containers, this parameter can be used to reference a credential spec
        /// file when configuring a container for Active Directory authentication. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html">Using gMSAs for Windows
        /// Containers</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>This parameter maps to <code>SecurityOpt</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--security-opt</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <note>
        /// <p>The Amazon ECS container agent running on a container instance must register with the
        /// <code>ECS_SELINUX_CAPABLE=true</code> or <code>ECS_APPARMOR_CAPABLE=true</code>
        /// environment variables before containers placed on that instance can use these
        /// security options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container
        /// Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// </note>
        /// <p>For more information about valid values, see <a href="https://docs.docker.com/engine/reference/run/#security-configuration">Docker
        /// Run Security Configuration</a>. </p>
        /// <p>Valid values: "no-new-privileges" | "apparmor:PROFILE" | "label:value" |
        /// "credentialspec:CredentialSpecFilePath"</p>
        pub fn docker_security_options(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.docker_security_options.unwrap_or_default();
            v.push(input.into());
            self.docker_security_options = Some(v);
            self
        }
        /// <p>A list of strings to provide custom labels for SELinux and AppArmor multi-level
        /// security systems. This field is not valid for containers in tasks using the
        /// Fargate launch type.</p>
        /// <p>With Windows containers, this parameter can be used to reference a credential spec
        /// file when configuring a container for Active Directory authentication. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html">Using gMSAs for Windows
        /// Containers</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>This parameter maps to <code>SecurityOpt</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--security-opt</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <note>
        /// <p>The Amazon ECS container agent running on a container instance must register with the
        /// <code>ECS_SELINUX_CAPABLE=true</code> or <code>ECS_APPARMOR_CAPABLE=true</code>
        /// environment variables before containers placed on that instance can use these
        /// security options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container
        /// Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// </note>
        /// <p>For more information about valid values, see <a href="https://docs.docker.com/engine/reference/run/#security-configuration">Docker
        /// Run Security Configuration</a>. </p>
        /// <p>Valid values: "no-new-privileges" | "apparmor:PROFILE" | "label:value" |
        /// "credentialspec:CredentialSpecFilePath"</p>
        pub fn set_docker_security_options(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.docker_security_options = input;
            self
        }
        /// <p>When this parameter is <code>true</code>, this allows you to deploy containerized
        /// applications that require <code>stdin</code> or a <code>tty</code> to be allocated. This
        /// parameter maps to <code>OpenStdin</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
        /// section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--interactive</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        pub fn interactive(mut self, input: bool) -> Self {
            self.interactive = Some(input);
            self
        }
        /// <p>When this parameter is <code>true</code>, this allows you to deploy containerized
        /// applications that require <code>stdin</code> or a <code>tty</code> to be allocated. This
        /// parameter maps to <code>OpenStdin</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
        /// section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--interactive</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        pub fn set_interactive(mut self, input: std::option::Option<bool>) -> Self {
            self.interactive = input;
            self
        }
        /// <p>When this parameter is <code>true</code>, a TTY is allocated. This parameter maps to
        /// <code>Tty</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--tty</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        pub fn pseudo_terminal(mut self, input: bool) -> Self {
            self.pseudo_terminal = Some(input);
            self
        }
        /// <p>When this parameter is <code>true</code>, a TTY is allocated. This parameter maps to
        /// <code>Tty</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--tty</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        pub fn set_pseudo_terminal(mut self, input: std::option::Option<bool>) -> Self {
            self.pseudo_terminal = input;
            self
        }
        /// Adds a key-value pair to `docker_labels`.
        ///
        /// To override the contents of this collection use [`set_docker_labels`](Self::set_docker_labels).
        ///
        /// <p>A key/value map of labels to add to the container. This parameter maps to
        /// <code>Labels</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--label</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>. This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
        /// </p>
        pub fn docker_labels(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.docker_labels.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.docker_labels = Some(hash_map);
            self
        }
        /// <p>A key/value map of labels to add to the container. This parameter maps to
        /// <code>Labels</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--label</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>. This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
        /// </p>
        pub fn set_docker_labels(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.docker_labels = input;
            self
        }
        /// Appends an item to `ulimits`.
        ///
        /// To override the contents of this collection use [`set_ulimits`](Self::set_ulimits).
        ///
        /// <p>A list of <code>ulimits</code> to set in the container. If a ulimit value is specified
        /// in a task definition, it will override the default values set by Docker. This parameter
        /// maps to <code>Ulimits</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--ulimit</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>. Valid naming values are displayed
        /// in the <a>Ulimit</a> data type.</p>
        /// <p>Amazon ECS tasks hosted on Fargate use the default
        /// resource limit values set by the operating system with the exception of
        /// the <code>nofile</code> resource limit parameter which Fargate
        /// overrides. The <code>nofile</code> resource limit sets a restriction on
        /// the number of open files that a container can use. The default
        /// <code>nofile</code> soft limit is <code>1024</code> and hard limit
        /// is <code>4096</code>.</p>
        /// <p>This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
        /// </p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers.</p>
        /// </note>
        pub fn ulimits(mut self, input: impl Into<crate::model::Ulimit>) -> Self {
            let mut v = self.ulimits.unwrap_or_default();
            v.push(input.into());
            self.ulimits = Some(v);
            self
        }
        /// <p>A list of <code>ulimits</code> to set in the container. If a ulimit value is specified
        /// in a task definition, it will override the default values set by Docker. This parameter
        /// maps to <code>Ulimits</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--ulimit</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>. Valid naming values are displayed
        /// in the <a>Ulimit</a> data type.</p>
        /// <p>Amazon ECS tasks hosted on Fargate use the default
        /// resource limit values set by the operating system with the exception of
        /// the <code>nofile</code> resource limit parameter which Fargate
        /// overrides. The <code>nofile</code> resource limit sets a restriction on
        /// the number of open files that a container can use. The default
        /// <code>nofile</code> soft limit is <code>1024</code> and hard limit
        /// is <code>4096</code>.</p>
        /// <p>This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
        /// </p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers.</p>
        /// </note>
        pub fn set_ulimits(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ulimit>>,
        ) -> Self {
            self.ulimits = input;
            self
        }
        /// <p>The log configuration specification for the container.</p>
        /// <p>This parameter maps to <code>LogConfig</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--log-driver</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>. By default, containers use the same logging driver that the Docker
        /// daemon uses. However the container may use a different logging driver than the Docker
        /// daemon by specifying a log driver with this parameter in the container definition. To
        /// use a different logging driver for a container, the log system must be configured
        /// properly on the container instance (or on a different log server for remote logging
        /// options). For more information on the options for different supported log drivers, see
        /// <a href="https://docs.docker.com/engine/admin/logging/overview/">Configure
        /// logging drivers</a> in the Docker documentation.</p>
        /// <note>
        /// <p>Amazon ECS currently supports a subset of the logging drivers available to the Docker
        /// daemon (shown in the <a>LogConfiguration</a> data type). Additional log
        /// drivers may be available in future releases of the Amazon ECS container agent.</p>
        /// </note>
        /// <p>This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
        /// </p>
        /// <note>
        /// <p>The Amazon ECS container agent running on a container instance must register the
        /// logging drivers available on that instance with the
        /// <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before
        /// containers placed on that instance can use these log configuration options. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container
        /// Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// </note>
        pub fn log_configuration(mut self, input: crate::model::LogConfiguration) -> Self {
            self.log_configuration = Some(input);
            self
        }
        /// <p>The log configuration specification for the container.</p>
        /// <p>This parameter maps to <code>LogConfig</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--log-driver</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>. By default, containers use the same logging driver that the Docker
        /// daemon uses. However the container may use a different logging driver than the Docker
        /// daemon by specifying a log driver with this parameter in the container definition. To
        /// use a different logging driver for a container, the log system must be configured
        /// properly on the container instance (or on a different log server for remote logging
        /// options). For more information on the options for different supported log drivers, see
        /// <a href="https://docs.docker.com/engine/admin/logging/overview/">Configure
        /// logging drivers</a> in the Docker documentation.</p>
        /// <note>
        /// <p>Amazon ECS currently supports a subset of the logging drivers available to the Docker
        /// daemon (shown in the <a>LogConfiguration</a> data type). Additional log
        /// drivers may be available in future releases of the Amazon ECS container agent.</p>
        /// </note>
        /// <p>This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
        /// </p>
        /// <note>
        /// <p>The Amazon ECS container agent running on a container instance must register the
        /// logging drivers available on that instance with the
        /// <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before
        /// containers placed on that instance can use these log configuration options. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container
        /// Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// </note>
        pub fn set_log_configuration(
            mut self,
            input: std::option::Option<crate::model::LogConfiguration>,
        ) -> Self {
            self.log_configuration = input;
            self
        }
        /// <p>The container health check command and associated configuration parameters for the
        /// container. This parameter maps to <code>HealthCheck</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>HEALTHCHECK</code> parameter of <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        pub fn health_check(mut self, input: crate::model::HealthCheck) -> Self {
            self.health_check = Some(input);
            self
        }
        /// <p>The container health check command and associated configuration parameters for the
        /// container. This parameter maps to <code>HealthCheck</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>HEALTHCHECK</code> parameter of <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        pub fn set_health_check(
            mut self,
            input: std::option::Option<crate::model::HealthCheck>,
        ) -> Self {
            self.health_check = input;
            self
        }
        /// Appends an item to `system_controls`.
        ///
        /// To override the contents of this collection use [`set_system_controls`](Self::set_system_controls).
        ///
        /// <p>A list of namespaced kernel parameters to set in the container. This parameter maps to
        /// <code>Sysctls</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--sysctl</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <note>
        /// <p>It is not recommended that you specify network-related <code>systemControls</code>
        /// parameters for multiple containers in a single task that also uses either the
        /// <code>awsvpc</code> or <code>host</code> network modes. For tasks that use the
        /// <code>awsvpc</code> network mode, the container that is started last determines
        /// which <code>systemControls</code> parameters take effect. For tasks that use the
        /// <code>host</code> network mode, it changes the container instance's namespaced
        /// kernel parameters as well as the containers.</p>
        /// </note>
        pub fn system_controls(mut self, input: impl Into<crate::model::SystemControl>) -> Self {
            let mut v = self.system_controls.unwrap_or_default();
            v.push(input.into());
            self.system_controls = Some(v);
            self
        }
        /// <p>A list of namespaced kernel parameters to set in the container. This parameter maps to
        /// <code>Sysctls</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--sysctl</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <note>
        /// <p>It is not recommended that you specify network-related <code>systemControls</code>
        /// parameters for multiple containers in a single task that also uses either the
        /// <code>awsvpc</code> or <code>host</code> network modes. For tasks that use the
        /// <code>awsvpc</code> network mode, the container that is started last determines
        /// which <code>systemControls</code> parameters take effect. For tasks that use the
        /// <code>host</code> network mode, it changes the container instance's namespaced
        /// kernel parameters as well as the containers.</p>
        /// </note>
        pub fn set_system_controls(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SystemControl>>,
        ) -> Self {
            self.system_controls = input;
            self
        }
        /// Appends an item to `resource_requirements`.
        ///
        /// To override the contents of this collection use [`set_resource_requirements`](Self::set_resource_requirements).
        ///
        /// <p>The type and amount of a resource to assign to a container. The only supported
        /// resource is a GPU.</p>
        pub fn resource_requirements(
            mut self,
            input: impl Into<crate::model::ResourceRequirement>,
        ) -> Self {
            let mut v = self.resource_requirements.unwrap_or_default();
            v.push(input.into());
            self.resource_requirements = Some(v);
            self
        }
        /// <p>The type and amount of a resource to assign to a container. The only supported
        /// resource is a GPU.</p>
        pub fn set_resource_requirements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceRequirement>>,
        ) -> Self {
            self.resource_requirements = input;
            self
        }
        /// <p>The FireLens configuration for the container. This is used to specify and configure a
        /// log router for container logs. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom Log Routing</a>
        /// in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn firelens_configuration(
            mut self,
            input: crate::model::FirelensConfiguration,
        ) -> Self {
            self.firelens_configuration = Some(input);
            self
        }
        /// <p>The FireLens configuration for the container. This is used to specify and configure a
        /// log router for container logs. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom Log Routing</a>
        /// in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_firelens_configuration(
            mut self,
            input: std::option::Option<crate::model::FirelensConfiguration>,
        ) -> Self {
            self.firelens_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerDefinition`](crate::model::ContainerDefinition)
        pub fn build(self) -> crate::model::ContainerDefinition {
            crate::model::ContainerDefinition {
                name: self.name,
                image: self.image,
                repository_credentials: self.repository_credentials,
                cpu: self.cpu.unwrap_or_default(),
                memory: self.memory,
                memory_reservation: self.memory_reservation,
                links: self.links,
                port_mappings: self.port_mappings,
                essential: self.essential,
                entry_point: self.entry_point,
                command: self.command,
                environment: self.environment,
                environment_files: self.environment_files,
                mount_points: self.mount_points,
                volumes_from: self.volumes_from,
                linux_parameters: self.linux_parameters,
                secrets: self.secrets,
                depends_on: self.depends_on,
                start_timeout: self.start_timeout,
                stop_timeout: self.stop_timeout,
                hostname: self.hostname,
                user: self.user,
                working_directory: self.working_directory,
                disable_networking: self.disable_networking,
                privileged: self.privileged,
                readonly_root_filesystem: self.readonly_root_filesystem,
                dns_servers: self.dns_servers,
                dns_search_domains: self.dns_search_domains,
                extra_hosts: self.extra_hosts,
                docker_security_options: self.docker_security_options,
                interactive: self.interactive,
                pseudo_terminal: self.pseudo_terminal,
                docker_labels: self.docker_labels,
                ulimits: self.ulimits,
                log_configuration: self.log_configuration,
                health_check: self.health_check,
                system_controls: self.system_controls,
                resource_requirements: self.resource_requirements,
                firelens_configuration: self.firelens_configuration,
            }
        }
    }
}
impl ContainerDefinition {
    /// Creates a new builder-style object to manufacture [`ContainerDefinition`](crate::model::ContainerDefinition)
    pub fn builder() -> crate::model::container_definition::Builder {
        crate::model::container_definition::Builder::default()
    }
}

/// <p>The FireLens configuration for the container. This is used to specify and configure a
/// log router for container logs. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom Log Routing</a>
/// in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FirelensConfiguration {
    /// <p>The log router to use. The valid values are <code>fluentd</code> or
    /// <code>fluentbit</code>.</p>
    pub r#type: std::option::Option<crate::model::FirelensConfigurationType>,
    /// <p>The options to use when configuring the log router. This field is optional and can be
    /// used to specify a custom configuration file or to add additional metadata, such as the
    /// task, task definition, cluster, and container instance details to the log event. If
    /// specified, the syntax to use is
    /// <code>"options":{"enable-ecs-log-metadata":"true|false","config-file-type:"s3|file","config-file-value":"arn:aws:s3:::mybucket/fluent.conf|filepath"}</code>.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html#firelens-taskdef">Creating
    /// a Task Definition that Uses a FireLens Configuration</a> in the
    /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <note>
    /// <p>Tasks hosted on Fargate only support the <code>file</code> configuration file
    /// type.</p>
    /// </note>
    pub options:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for FirelensConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FirelensConfiguration");
        formatter.field("r#type", &self.r#type);
        formatter.field("options", &self.options);
        formatter.finish()
    }
}
/// See [`FirelensConfiguration`](crate::model::FirelensConfiguration)
pub mod firelens_configuration {
    /// A builder for [`FirelensConfiguration`](crate::model::FirelensConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::FirelensConfigurationType>,
        pub(crate) options: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The log router to use. The valid values are <code>fluentd</code> or
        /// <code>fluentbit</code>.</p>
        pub fn r#type(mut self, input: crate::model::FirelensConfigurationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The log router to use. The valid values are <code>fluentd</code> or
        /// <code>fluentbit</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::FirelensConfigurationType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Adds a key-value pair to `options`.
        ///
        /// To override the contents of this collection use [`set_options`](Self::set_options).
        ///
        /// <p>The options to use when configuring the log router. This field is optional and can be
        /// used to specify a custom configuration file or to add additional metadata, such as the
        /// task, task definition, cluster, and container instance details to the log event. If
        /// specified, the syntax to use is
        /// <code>"options":{"enable-ecs-log-metadata":"true|false","config-file-type:"s3|file","config-file-value":"arn:aws:s3:::mybucket/fluent.conf|filepath"}</code>.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html#firelens-taskdef">Creating
        /// a Task Definition that Uses a FireLens Configuration</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <note>
        /// <p>Tasks hosted on Fargate only support the <code>file</code> configuration file
        /// type.</p>
        /// </note>
        pub fn options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.options = Some(hash_map);
            self
        }
        /// <p>The options to use when configuring the log router. This field is optional and can be
        /// used to specify a custom configuration file or to add additional metadata, such as the
        /// task, task definition, cluster, and container instance details to the log event. If
        /// specified, the syntax to use is
        /// <code>"options":{"enable-ecs-log-metadata":"true|false","config-file-type:"s3|file","config-file-value":"arn:aws:s3:::mybucket/fluent.conf|filepath"}</code>.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html#firelens-taskdef">Creating
        /// a Task Definition that Uses a FireLens Configuration</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <note>
        /// <p>Tasks hosted on Fargate only support the <code>file</code> configuration file
        /// type.</p>
        /// </note>
        pub fn set_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.options = input;
            self
        }
        /// Consumes the builder and constructs a [`FirelensConfiguration`](crate::model::FirelensConfiguration)
        pub fn build(self) -> crate::model::FirelensConfiguration {
            crate::model::FirelensConfiguration {
                r#type: self.r#type,
                options: self.options,
            }
        }
    }
}
impl FirelensConfiguration {
    /// Creates a new builder-style object to manufacture [`FirelensConfiguration`](crate::model::FirelensConfiguration)
    pub fn builder() -> crate::model::firelens_configuration::Builder {
        crate::model::firelens_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FirelensConfigurationType {
    #[allow(missing_docs)] // documentation missing in model
    Fluentbit,
    #[allow(missing_docs)] // documentation missing in model
    Fluentd,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FirelensConfigurationType {
    fn from(s: &str) -> Self {
        match s {
            "fluentbit" => FirelensConfigurationType::Fluentbit,
            "fluentd" => FirelensConfigurationType::Fluentd,
            other => FirelensConfigurationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FirelensConfigurationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FirelensConfigurationType::from(s))
    }
}
impl FirelensConfigurationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FirelensConfigurationType::Fluentbit => "fluentbit",
            FirelensConfigurationType::Fluentd => "fluentd",
            FirelensConfigurationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["fluentbit", "fluentd"]
    }
}
impl AsRef<str> for FirelensConfigurationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A list of namespaced kernel parameters to set in the container. This parameter maps to
/// <code>Sysctls</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
/// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--sysctl</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
/// <p>It is not recommended that you specify network-related <code>systemControls</code>
/// parameters for multiple containers in a single task that also uses either the
/// <code>awsvpc</code> or <code>host</code> network mode for the following
/// reasons:</p>
/// <ul>
/// <li>
/// <p>For tasks that use the <code>awsvpc</code> network mode, if you set
/// <code>systemControls</code> for any container, it applies to all containers
/// in the task. If you set different <code>systemControls</code> for multiple
/// containers in a single task, the container that is started last determines which
/// <code>systemControls</code> take effect.</p>
/// </li>
/// <li>
/// <p>For tasks that use the <code>host</code> network mode, the
/// <code>systemControls</code> parameter applies to the container instance's
/// kernel parameter as well as that of all containers of any tasks running on that
/// container instance.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SystemControl {
    /// <p>The namespaced kernel parameter for which to set a <code>value</code>.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The value for the namespaced kernel parameter specified in
    /// <code>namespace</code>.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SystemControl {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SystemControl");
        formatter.field("namespace", &self.namespace);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`SystemControl`](crate::model::SystemControl)
pub mod system_control {
    /// A builder for [`SystemControl`](crate::model::SystemControl)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The namespaced kernel parameter for which to set a <code>value</code>.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespaced kernel parameter for which to set a <code>value</code>.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The value for the namespaced kernel parameter specified in
        /// <code>namespace</code>.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value for the namespaced kernel parameter specified in
        /// <code>namespace</code>.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`SystemControl`](crate::model::SystemControl)
        pub fn build(self) -> crate::model::SystemControl {
            crate::model::SystemControl {
                namespace: self.namespace,
                value: self.value,
            }
        }
    }
}
impl SystemControl {
    /// Creates a new builder-style object to manufacture [`SystemControl`](crate::model::SystemControl)
    pub fn builder() -> crate::model::system_control::Builder {
        crate::model::system_control::Builder::default()
    }
}

/// <p>An object representing a container health check. Health check parameters that are
/// specified in a container definition override any Docker health checks that exist in the
/// container image (such as those specified in a parent image or from the image's
/// Dockerfile).</p>
/// <p>You can view the health status of both individual containers and a task with the
/// DescribeTasks API operation or when viewing the task details in the console.</p>
/// <p>The following describes the possible <code>healthStatus</code> values for a
/// container:</p>
/// <ul>
/// <li>
/// <p>
/// <code>HEALTHY</code>-The container health check has passed
/// successfully.</p>
/// </li>
/// <li>
/// <p>
/// <code>UNHEALTHY</code>-The container health check has failed.</p>
/// </li>
/// <li>
/// <p>
/// <code>UNKNOWN</code>-The container health check is being evaluated or
/// there is no container health check defined.</p>
/// </li>
/// </ul>
/// <p>The following describes the possible <code>healthStatus</code> values for a task. The
/// container health check status of nonessential containers do not have an effect on the
/// health status of a task.</p>
/// <ul>
/// <li>
/// <p>
/// <code>HEALTHY</code>-All essential containers within the task have
/// passed their health checks.</p>
/// </li>
/// <li>
/// <p>
/// <code>UNHEALTHY</code>-One or more essential containers have failed
/// their health check.</p>
/// </li>
/// <li>
/// <p>
/// <code>UNKNOWN</code>-The essential containers within the task are still
/// having their health checks evaluated or there are no container health checks
/// defined.</p>
/// </li>
/// </ul>
/// <p>If a task is run manually, and not as part of a service, the task will continue its
/// lifecycle regardless of its health status. For tasks that are part of a service, if the
/// task reports as unhealthy then the task will be stopped and the service scheduler will
/// replace it.</p>
/// <p>The following are notes about container health check support:</p>
/// <ul>
/// <li>
/// <p>Container health checks require version 1.17.0 or greater of the Amazon ECS
/// container agent. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the
/// Amazon ECS Container Agent</a>.</p>
/// </li>
/// <li>
/// <p>Container health checks are supported for Fargate tasks if you
/// are using platform version 1.1.0 or greater. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate
/// Platform Versions</a>.</p>
/// </li>
/// <li>
/// <p>Container health checks are not supported for tasks that are part of a service
/// that is configured to use a Classic Load Balancer.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HealthCheck {
    /// <p>A string array representing the command that the container runs to determine if it is
    /// healthy. The string array must start with <code>CMD</code> to execute the command
    /// arguments directly, or <code>CMD-SHELL</code> to run the command with the container's
    /// default shell. </p>
    /// <p> When you use the Amazon Web Services Management Console JSON panel, the Command Line Interface, or the APIs, you should enclose the list of commands in brackets, as shown below.</p>
    /// <p>
    /// <code>[ "CMD-SHELL", "curl -f http://localhost/ || exit 1" ]</code>
    /// </p>
    /// <p>You do not need to include the brackets when you use the Amazon Web Services Management Consoleas shown below.</p>
    /// <p>
    /// <code> "CMD-SHELL", "curl -f http://localhost/ || exit 1" </code>
    /// </p>
    /// <p>An exit code of 0 indicates success, and non-zero exit code indicates failure. For
    /// more information, see <code>HealthCheck</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
    /// section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a>.</p>
    pub command: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The time period in seconds between each health check execution. You may specify
    /// between 5 and 300 seconds. The default value is 30 seconds.</p>
    pub interval: std::option::Option<i32>,
    /// <p>The time period in seconds to wait for a health check to succeed before it is
    /// considered a failure. You may specify between 2 and 60 seconds. The default value is
    /// 5.</p>
    pub timeout: std::option::Option<i32>,
    /// <p>The number of times to retry a failed health check before the container is considered
    /// unhealthy. You may specify between 1 and 10 retries. The default value is 3.</p>
    pub retries: std::option::Option<i32>,
    /// <p>The optional grace period within which to provide containers time to bootstrap before
    /// failed health checks count towards the maximum number of retries. You may specify
    /// between 0 and 300 seconds. The <code>startPeriod</code> is disabled by default.</p>
    /// <note>
    /// <p>If a health check succeeds within the <code>startPeriod</code>, then the container
    /// is considered healthy and any subsequent failures count toward the maximum number of
    /// retries.</p>
    /// </note>
    pub start_period: std::option::Option<i32>,
}
impl std::fmt::Debug for HealthCheck {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HealthCheck");
        formatter.field("command", &self.command);
        formatter.field("interval", &self.interval);
        formatter.field("timeout", &self.timeout);
        formatter.field("retries", &self.retries);
        formatter.field("start_period", &self.start_period);
        formatter.finish()
    }
}
/// See [`HealthCheck`](crate::model::HealthCheck)
pub mod health_check {
    /// A builder for [`HealthCheck`](crate::model::HealthCheck)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) command: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) interval: std::option::Option<i32>,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) retries: std::option::Option<i32>,
        pub(crate) start_period: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `command`.
        ///
        /// To override the contents of this collection use [`set_command`](Self::set_command).
        ///
        /// <p>A string array representing the command that the container runs to determine if it is
        /// healthy. The string array must start with <code>CMD</code> to execute the command
        /// arguments directly, or <code>CMD-SHELL</code> to run the command with the container's
        /// default shell. </p>
        /// <p> When you use the Amazon Web Services Management Console JSON panel, the Command Line Interface, or the APIs, you should enclose the list of commands in brackets, as shown below.</p>
        /// <p>
        /// <code>[ "CMD-SHELL", "curl -f http://localhost/ || exit 1" ]</code>
        /// </p>
        /// <p>You do not need to include the brackets when you use the Amazon Web Services Management Consoleas shown below.</p>
        /// <p>
        /// <code> "CMD-SHELL", "curl -f http://localhost/ || exit 1" </code>
        /// </p>
        /// <p>An exit code of 0 indicates success, and non-zero exit code indicates failure. For
        /// more information, see <code>HealthCheck</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
        /// section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a>.</p>
        pub fn command(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.command.unwrap_or_default();
            v.push(input.into());
            self.command = Some(v);
            self
        }
        /// <p>A string array representing the command that the container runs to determine if it is
        /// healthy. The string array must start with <code>CMD</code> to execute the command
        /// arguments directly, or <code>CMD-SHELL</code> to run the command with the container's
        /// default shell. </p>
        /// <p> When you use the Amazon Web Services Management Console JSON panel, the Command Line Interface, or the APIs, you should enclose the list of commands in brackets, as shown below.</p>
        /// <p>
        /// <code>[ "CMD-SHELL", "curl -f http://localhost/ || exit 1" ]</code>
        /// </p>
        /// <p>You do not need to include the brackets when you use the Amazon Web Services Management Consoleas shown below.</p>
        /// <p>
        /// <code> "CMD-SHELL", "curl -f http://localhost/ || exit 1" </code>
        /// </p>
        /// <p>An exit code of 0 indicates success, and non-zero exit code indicates failure. For
        /// more information, see <code>HealthCheck</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a>
        /// section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a>.</p>
        pub fn set_command(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.command = input;
            self
        }
        /// <p>The time period in seconds between each health check execution. You may specify
        /// between 5 and 300 seconds. The default value is 30 seconds.</p>
        pub fn interval(mut self, input: i32) -> Self {
            self.interval = Some(input);
            self
        }
        /// <p>The time period in seconds between each health check execution. You may specify
        /// between 5 and 300 seconds. The default value is 30 seconds.</p>
        pub fn set_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.interval = input;
            self
        }
        /// <p>The time period in seconds to wait for a health check to succeed before it is
        /// considered a failure. You may specify between 2 and 60 seconds. The default value is
        /// 5.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The time period in seconds to wait for a health check to succeed before it is
        /// considered a failure. You may specify between 2 and 60 seconds. The default value is
        /// 5.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>The number of times to retry a failed health check before the container is considered
        /// unhealthy. You may specify between 1 and 10 retries. The default value is 3.</p>
        pub fn retries(mut self, input: i32) -> Self {
            self.retries = Some(input);
            self
        }
        /// <p>The number of times to retry a failed health check before the container is considered
        /// unhealthy. You may specify between 1 and 10 retries. The default value is 3.</p>
        pub fn set_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.retries = input;
            self
        }
        /// <p>The optional grace period within which to provide containers time to bootstrap before
        /// failed health checks count towards the maximum number of retries. You may specify
        /// between 0 and 300 seconds. The <code>startPeriod</code> is disabled by default.</p>
        /// <note>
        /// <p>If a health check succeeds within the <code>startPeriod</code>, then the container
        /// is considered healthy and any subsequent failures count toward the maximum number of
        /// retries.</p>
        /// </note>
        pub fn start_period(mut self, input: i32) -> Self {
            self.start_period = Some(input);
            self
        }
        /// <p>The optional grace period within which to provide containers time to bootstrap before
        /// failed health checks count towards the maximum number of retries. You may specify
        /// between 0 and 300 seconds. The <code>startPeriod</code> is disabled by default.</p>
        /// <note>
        /// <p>If a health check succeeds within the <code>startPeriod</code>, then the container
        /// is considered healthy and any subsequent failures count toward the maximum number of
        /// retries.</p>
        /// </note>
        pub fn set_start_period(mut self, input: std::option::Option<i32>) -> Self {
            self.start_period = input;
            self
        }
        /// Consumes the builder and constructs a [`HealthCheck`](crate::model::HealthCheck)
        pub fn build(self) -> crate::model::HealthCheck {
            crate::model::HealthCheck {
                command: self.command,
                interval: self.interval,
                timeout: self.timeout,
                retries: self.retries,
                start_period: self.start_period,
            }
        }
    }
}
impl HealthCheck {
    /// Creates a new builder-style object to manufacture [`HealthCheck`](crate::model::HealthCheck)
    pub fn builder() -> crate::model::health_check::Builder {
        crate::model::health_check::Builder::default()
    }
}

/// <p>The log configuration for the container. This parameter maps to <code>LogConfig</code>
/// in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
/// <code>--log-driver</code> option to <a href="https://docs.docker.com/engine/reference/commandline/run/">
/// <code>docker
/// run</code>
/// </a>.</p>
/// <p>By default, containers use the same logging driver that the Docker daemon uses;
/// however the container may use a different logging driver than the Docker daemon by
/// specifying a log driver configuration in the container definition. For more information
/// on the options for different supported log drivers, see <a href="https://docs.docker.com/engine/admin/logging/overview/">Configure logging
/// drivers</a> in the Docker documentation.</p>
/// <p>The following should be noted when specifying a log configuration for your
/// containers:</p>
/// <ul>
/// <li>
/// <p>Amazon ECS currently supports a subset of the logging drivers available to the
/// Docker daemon (shown in the valid values below). Additional log drivers may be
/// available in future releases of the Amazon ECS container agent.</p>
/// </li>
/// <li>
/// <p>This parameter requires version 1.18 of the Docker Remote API or greater on
/// your container instance.</p>
/// </li>
/// <li>
/// <p>For tasks hosted on Amazon EC2 instances, the Amazon ECS container agent must register
/// the available logging drivers with the
/// <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before
/// containers placed on that instance can use these log configuration options. For
/// more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS container agent configuration</a> in the
/// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
/// </li>
/// <li>
/// <p>For tasks on Fargate, because you do not have access to the underlying
/// infrastructure your tasks are hosted on, any additional software needed will
/// have to be installed outside of the task. For example, the Fluentd output
/// aggregators or a remote host running Logstash to send Gelf logs to.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogConfiguration {
    /// <p>The log driver to use for the container.</p>
    /// <p>For tasks on Fargate, the supported log drivers are <code>awslogs</code>,
    /// <code>splunk</code>, and <code>awsfirelens</code>.</p>
    /// <p>For tasks hosted on Amazon EC2 instances, the supported log drivers are
    /// <code>awslogs</code>, <code>fluentd</code>, <code>gelf</code>,
    /// <code>json-file</code>, <code>journald</code>,
    /// <code>logentries</code>,<code>syslog</code>, <code>splunk</code>, and
    /// <code>awsfirelens</code>.</p>
    /// <p>For more information about using the <code>awslogs</code> log driver, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html">Using
    /// the awslogs log driver</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>For more information about using the <code>awsfirelens</code> log driver, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom log routing</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <note>
    /// <p>If you have a custom driver that is not listed, you can fork the Amazon ECS container
    /// agent project that is <a href="https://github.com/aws/amazon-ecs-agent">available
    /// on GitHub</a> and customize it to work with that driver. We encourage you to
    /// submit pull requests for changes that you would like to have included. However, we
    /// do not currently provide support for running modified copies of this
    /// software.</p>
    /// </note>
    pub log_driver: std::option::Option<crate::model::LogDriver>,
    /// <p>The configuration options to send to the log driver. This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
    /// </p>
    pub options:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The secrets to pass to the log configuration. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying
    /// Sensitive Data</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub secret_options: std::option::Option<std::vec::Vec<crate::model::Secret>>,
}
impl std::fmt::Debug for LogConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogConfiguration");
        formatter.field("log_driver", &self.log_driver);
        formatter.field("options", &self.options);
        formatter.field("secret_options", &self.secret_options);
        formatter.finish()
    }
}
/// See [`LogConfiguration`](crate::model::LogConfiguration)
pub mod log_configuration {
    /// A builder for [`LogConfiguration`](crate::model::LogConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_driver: std::option::Option<crate::model::LogDriver>,
        pub(crate) options: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) secret_options: std::option::Option<std::vec::Vec<crate::model::Secret>>,
    }
    impl Builder {
        /// <p>The log driver to use for the container.</p>
        /// <p>For tasks on Fargate, the supported log drivers are <code>awslogs</code>,
        /// <code>splunk</code>, and <code>awsfirelens</code>.</p>
        /// <p>For tasks hosted on Amazon EC2 instances, the supported log drivers are
        /// <code>awslogs</code>, <code>fluentd</code>, <code>gelf</code>,
        /// <code>json-file</code>, <code>journald</code>,
        /// <code>logentries</code>,<code>syslog</code>, <code>splunk</code>, and
        /// <code>awsfirelens</code>.</p>
        /// <p>For more information about using the <code>awslogs</code> log driver, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html">Using
        /// the awslogs log driver</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>For more information about using the <code>awsfirelens</code> log driver, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom log routing</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <note>
        /// <p>If you have a custom driver that is not listed, you can fork the Amazon ECS container
        /// agent project that is <a href="https://github.com/aws/amazon-ecs-agent">available
        /// on GitHub</a> and customize it to work with that driver. We encourage you to
        /// submit pull requests for changes that you would like to have included. However, we
        /// do not currently provide support for running modified copies of this
        /// software.</p>
        /// </note>
        pub fn log_driver(mut self, input: crate::model::LogDriver) -> Self {
            self.log_driver = Some(input);
            self
        }
        /// <p>The log driver to use for the container.</p>
        /// <p>For tasks on Fargate, the supported log drivers are <code>awslogs</code>,
        /// <code>splunk</code>, and <code>awsfirelens</code>.</p>
        /// <p>For tasks hosted on Amazon EC2 instances, the supported log drivers are
        /// <code>awslogs</code>, <code>fluentd</code>, <code>gelf</code>,
        /// <code>json-file</code>, <code>journald</code>,
        /// <code>logentries</code>,<code>syslog</code>, <code>splunk</code>, and
        /// <code>awsfirelens</code>.</p>
        /// <p>For more information about using the <code>awslogs</code> log driver, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html">Using
        /// the awslogs log driver</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>For more information about using the <code>awsfirelens</code> log driver, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom log routing</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <note>
        /// <p>If you have a custom driver that is not listed, you can fork the Amazon ECS container
        /// agent project that is <a href="https://github.com/aws/amazon-ecs-agent">available
        /// on GitHub</a> and customize it to work with that driver. We encourage you to
        /// submit pull requests for changes that you would like to have included. However, we
        /// do not currently provide support for running modified copies of this
        /// software.</p>
        /// </note>
        pub fn set_log_driver(
            mut self,
            input: std::option::Option<crate::model::LogDriver>,
        ) -> Self {
            self.log_driver = input;
            self
        }
        /// Adds a key-value pair to `options`.
        ///
        /// To override the contents of this collection use [`set_options`](Self::set_options).
        ///
        /// <p>The configuration options to send to the log driver. This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
        /// </p>
        pub fn options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.options = Some(hash_map);
            self
        }
        /// <p>The configuration options to send to the log driver. This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
        /// </p>
        pub fn set_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.options = input;
            self
        }
        /// Appends an item to `secret_options`.
        ///
        /// To override the contents of this collection use [`set_secret_options`](Self::set_secret_options).
        ///
        /// <p>The secrets to pass to the log configuration. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying
        /// Sensitive Data</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn secret_options(mut self, input: impl Into<crate::model::Secret>) -> Self {
            let mut v = self.secret_options.unwrap_or_default();
            v.push(input.into());
            self.secret_options = Some(v);
            self
        }
        /// <p>The secrets to pass to the log configuration. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying
        /// Sensitive Data</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_secret_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Secret>>,
        ) -> Self {
            self.secret_options = input;
            self
        }
        /// Consumes the builder and constructs a [`LogConfiguration`](crate::model::LogConfiguration)
        pub fn build(self) -> crate::model::LogConfiguration {
            crate::model::LogConfiguration {
                log_driver: self.log_driver,
                options: self.options,
                secret_options: self.secret_options,
            }
        }
    }
}
impl LogConfiguration {
    /// Creates a new builder-style object to manufacture [`LogConfiguration`](crate::model::LogConfiguration)
    pub fn builder() -> crate::model::log_configuration::Builder {
        crate::model::log_configuration::Builder::default()
    }
}

/// <p>An object representing the secret to expose to your container. Secrets can be exposed
/// to a container in the following ways:</p>
/// <ul>
/// <li>
/// <p>To inject sensitive data into your containers as environment variables, use
/// the <code>secrets</code> container definition parameter.</p>
/// </li>
/// <li>
/// <p>To reference sensitive information in the log configuration of a container,
/// use the <code>secretOptions</code> container definition parameter.</p>
/// </li>
/// </ul>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying
/// Sensitive Data</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Secret {
    /// <p>The name of the secret.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The secret to expose to the container. The supported values are either the full ARN of
    /// the Secrets Manager secret or the full ARN of the parameter in the SSM Parameter Store.</p>
    /// <note>
    /// <p>If the SSM Parameter Store parameter exists in the same Region as the task you
    /// are launching, then you can use either the full ARN or name of the parameter. If the
    /// parameter exists in a different Region, then the full ARN must be specified.</p>
    /// </note>
    pub value_from: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Secret {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Secret");
        formatter.field("name", &self.name);
        formatter.field("value_from", &self.value_from);
        formatter.finish()
    }
}
/// See [`Secret`](crate::model::Secret)
pub mod secret {
    /// A builder for [`Secret`](crate::model::Secret)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value_from: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the secret.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the secret.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The secret to expose to the container. The supported values are either the full ARN of
        /// the Secrets Manager secret or the full ARN of the parameter in the SSM Parameter Store.</p>
        /// <note>
        /// <p>If the SSM Parameter Store parameter exists in the same Region as the task you
        /// are launching, then you can use either the full ARN or name of the parameter. If the
        /// parameter exists in a different Region, then the full ARN must be specified.</p>
        /// </note>
        pub fn value_from(mut self, input: impl Into<std::string::String>) -> Self {
            self.value_from = Some(input.into());
            self
        }
        /// <p>The secret to expose to the container. The supported values are either the full ARN of
        /// the Secrets Manager secret or the full ARN of the parameter in the SSM Parameter Store.</p>
        /// <note>
        /// <p>If the SSM Parameter Store parameter exists in the same Region as the task you
        /// are launching, then you can use either the full ARN or name of the parameter. If the
        /// parameter exists in a different Region, then the full ARN must be specified.</p>
        /// </note>
        pub fn set_value_from(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value_from = input;
            self
        }
        /// Consumes the builder and constructs a [`Secret`](crate::model::Secret)
        pub fn build(self) -> crate::model::Secret {
            crate::model::Secret {
                name: self.name,
                value_from: self.value_from,
            }
        }
    }
}
impl Secret {
    /// Creates a new builder-style object to manufacture [`Secret`](crate::model::Secret)
    pub fn builder() -> crate::model::secret::Builder {
        crate::model::secret::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogDriver {
    #[allow(missing_docs)] // documentation missing in model
    Awsfirelens,
    #[allow(missing_docs)] // documentation missing in model
    Awslogs,
    #[allow(missing_docs)] // documentation missing in model
    Fluentd,
    #[allow(missing_docs)] // documentation missing in model
    Gelf,
    #[allow(missing_docs)] // documentation missing in model
    Journald,
    #[allow(missing_docs)] // documentation missing in model
    JsonFile,
    #[allow(missing_docs)] // documentation missing in model
    Splunk,
    #[allow(missing_docs)] // documentation missing in model
    Syslog,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogDriver {
    fn from(s: &str) -> Self {
        match s {
            "awsfirelens" => LogDriver::Awsfirelens,
            "awslogs" => LogDriver::Awslogs,
            "fluentd" => LogDriver::Fluentd,
            "gelf" => LogDriver::Gelf,
            "journald" => LogDriver::Journald,
            "json-file" => LogDriver::JsonFile,
            "splunk" => LogDriver::Splunk,
            "syslog" => LogDriver::Syslog,
            other => LogDriver::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogDriver {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogDriver::from(s))
    }
}
impl LogDriver {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogDriver::Awsfirelens => "awsfirelens",
            LogDriver::Awslogs => "awslogs",
            LogDriver::Fluentd => "fluentd",
            LogDriver::Gelf => "gelf",
            LogDriver::Journald => "journald",
            LogDriver::JsonFile => "json-file",
            LogDriver::Splunk => "splunk",
            LogDriver::Syslog => "syslog",
            LogDriver::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "awsfirelens",
            "awslogs",
            "fluentd",
            "gelf",
            "journald",
            "json-file",
            "splunk",
            "syslog",
        ]
    }
}
impl AsRef<str> for LogDriver {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The <code>ulimit</code> settings to pass to the container.</p>
/// <p>Amazon ECS tasks hosted on Fargate use the default
/// resource limit values set by the operating system with the exception of
/// the <code>nofile</code> resource limit parameter which Fargate
/// overrides. The <code>nofile</code> resource limit sets a restriction on
/// the number of open files that a container can use. The default
/// <code>nofile</code> soft limit is <code>1024</code> and hard limit
/// is <code>4096</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ulimit {
    /// <p>The <code>type</code> of the <code>ulimit</code>.</p>
    pub name: std::option::Option<crate::model::UlimitName>,
    /// <p>The soft limit for the ulimit type.</p>
    pub soft_limit: i32,
    /// <p>The hard limit for the ulimit type.</p>
    pub hard_limit: i32,
}
impl std::fmt::Debug for Ulimit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ulimit");
        formatter.field("name", &self.name);
        formatter.field("soft_limit", &self.soft_limit);
        formatter.field("hard_limit", &self.hard_limit);
        formatter.finish()
    }
}
/// See [`Ulimit`](crate::model::Ulimit)
pub mod ulimit {
    /// A builder for [`Ulimit`](crate::model::Ulimit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::UlimitName>,
        pub(crate) soft_limit: std::option::Option<i32>,
        pub(crate) hard_limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The <code>type</code> of the <code>ulimit</code>.</p>
        pub fn name(mut self, input: crate::model::UlimitName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The <code>type</code> of the <code>ulimit</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::UlimitName>) -> Self {
            self.name = input;
            self
        }
        /// <p>The soft limit for the ulimit type.</p>
        pub fn soft_limit(mut self, input: i32) -> Self {
            self.soft_limit = Some(input);
            self
        }
        /// <p>The soft limit for the ulimit type.</p>
        pub fn set_soft_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.soft_limit = input;
            self
        }
        /// <p>The hard limit for the ulimit type.</p>
        pub fn hard_limit(mut self, input: i32) -> Self {
            self.hard_limit = Some(input);
            self
        }
        /// <p>The hard limit for the ulimit type.</p>
        pub fn set_hard_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.hard_limit = input;
            self
        }
        /// Consumes the builder and constructs a [`Ulimit`](crate::model::Ulimit)
        pub fn build(self) -> crate::model::Ulimit {
            crate::model::Ulimit {
                name: self.name,
                soft_limit: self.soft_limit.unwrap_or_default(),
                hard_limit: self.hard_limit.unwrap_or_default(),
            }
        }
    }
}
impl Ulimit {
    /// Creates a new builder-style object to manufacture [`Ulimit`](crate::model::Ulimit)
    pub fn builder() -> crate::model::ulimit::Builder {
        crate::model::ulimit::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UlimitName {
    #[allow(missing_docs)] // documentation missing in model
    Core,
    #[allow(missing_docs)] // documentation missing in model
    Cpu,
    #[allow(missing_docs)] // documentation missing in model
    Data,
    #[allow(missing_docs)] // documentation missing in model
    Fsize,
    #[allow(missing_docs)] // documentation missing in model
    Locks,
    #[allow(missing_docs)] // documentation missing in model
    Memlock,
    #[allow(missing_docs)] // documentation missing in model
    Msgqueue,
    #[allow(missing_docs)] // documentation missing in model
    Nice,
    #[allow(missing_docs)] // documentation missing in model
    Nofile,
    #[allow(missing_docs)] // documentation missing in model
    Nproc,
    #[allow(missing_docs)] // documentation missing in model
    Rss,
    #[allow(missing_docs)] // documentation missing in model
    Rtprio,
    #[allow(missing_docs)] // documentation missing in model
    Rttime,
    #[allow(missing_docs)] // documentation missing in model
    Sigpending,
    #[allow(missing_docs)] // documentation missing in model
    Stack,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UlimitName {
    fn from(s: &str) -> Self {
        match s {
            "core" => UlimitName::Core,
            "cpu" => UlimitName::Cpu,
            "data" => UlimitName::Data,
            "fsize" => UlimitName::Fsize,
            "locks" => UlimitName::Locks,
            "memlock" => UlimitName::Memlock,
            "msgqueue" => UlimitName::Msgqueue,
            "nice" => UlimitName::Nice,
            "nofile" => UlimitName::Nofile,
            "nproc" => UlimitName::Nproc,
            "rss" => UlimitName::Rss,
            "rtprio" => UlimitName::Rtprio,
            "rttime" => UlimitName::Rttime,
            "sigpending" => UlimitName::Sigpending,
            "stack" => UlimitName::Stack,
            other => UlimitName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UlimitName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UlimitName::from(s))
    }
}
impl UlimitName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UlimitName::Core => "core",
            UlimitName::Cpu => "cpu",
            UlimitName::Data => "data",
            UlimitName::Fsize => "fsize",
            UlimitName::Locks => "locks",
            UlimitName::Memlock => "memlock",
            UlimitName::Msgqueue => "msgqueue",
            UlimitName::Nice => "nice",
            UlimitName::Nofile => "nofile",
            UlimitName::Nproc => "nproc",
            UlimitName::Rss => "rss",
            UlimitName::Rtprio => "rtprio",
            UlimitName::Rttime => "rttime",
            UlimitName::Sigpending => "sigpending",
            UlimitName::Stack => "stack",
            UlimitName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "core",
            "cpu",
            "data",
            "fsize",
            "locks",
            "memlock",
            "msgqueue",
            "nice",
            "nofile",
            "nproc",
            "rss",
            "rtprio",
            "rttime",
            "sigpending",
            "stack",
        ]
    }
}
impl AsRef<str> for UlimitName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Hostnames and IP address entries that are added to the <code>/etc/hosts</code> file of
/// a container via the <code>extraHosts</code> parameter of its <a>ContainerDefinition</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HostEntry {
    /// <p>The hostname to use in the <code>/etc/hosts</code> entry.</p>
    pub hostname: std::option::Option<std::string::String>,
    /// <p>The IP address to use in the <code>/etc/hosts</code> entry.</p>
    pub ip_address: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HostEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HostEntry");
        formatter.field("hostname", &self.hostname);
        formatter.field("ip_address", &self.ip_address);
        formatter.finish()
    }
}
/// See [`HostEntry`](crate::model::HostEntry)
pub mod host_entry {
    /// A builder for [`HostEntry`](crate::model::HostEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hostname: std::option::Option<std::string::String>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The hostname to use in the <code>/etc/hosts</code> entry.</p>
        pub fn hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.hostname = Some(input.into());
            self
        }
        /// <p>The hostname to use in the <code>/etc/hosts</code> entry.</p>
        pub fn set_hostname(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hostname = input;
            self
        }
        /// <p>The IP address to use in the <code>/etc/hosts</code> entry.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The IP address to use in the <code>/etc/hosts</code> entry.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// Consumes the builder and constructs a [`HostEntry`](crate::model::HostEntry)
        pub fn build(self) -> crate::model::HostEntry {
            crate::model::HostEntry {
                hostname: self.hostname,
                ip_address: self.ip_address,
            }
        }
    }
}
impl HostEntry {
    /// Creates a new builder-style object to manufacture [`HostEntry`](crate::model::HostEntry)
    pub fn builder() -> crate::model::host_entry::Builder {
        crate::model::host_entry::Builder::default()
    }
}

/// <p>The dependencies defined for container startup and shutdown. A container can contain
/// multiple dependencies. When a dependency is defined for container startup, for container
/// shutdown it is reversed.</p>
/// <p>Your Amazon ECS container instances require at least version 1.26.0 of the container agent
/// to enable container dependencies. However, we recommend using the latest container agent
/// version. For information about checking your agent version and updating to the latest
/// version, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html">Updating the Amazon ECS
/// Container Agent</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. If you are
/// using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the
/// <code>ecs-init</code> package. If your container instances are launched from version
/// <code>20190301</code> or later, then they contain the required versions of the
/// container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
/// <note>
/// <p>For tasks using the Fargate launch type, the task or service requires the followiwng platforms:</p>
/// <ul>
/// <li>
/// <p>Linux platform
/// version <code>1.3.0</code> or later.</p>
/// </li>
/// <li>
/// <p>Windows platform
/// version <code>1.0.0</code> or later.</p>
/// </li>
/// </ul>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerDependency {
    /// <p>The name of a container.</p>
    pub container_name: std::option::Option<std::string::String>,
    /// <p>The dependency condition of the container. The following are the available conditions
    /// and their behavior:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>START</code> - This condition emulates the behavior of links and
    /// volumes today. It validates that a dependent container is started before
    /// permitting other containers to start.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETE</code> - This condition validates that a dependent
    /// container runs to completion (exits) before permitting other containers to
    /// start. This can be useful for nonessential containers that run a script and then
    /// exit. This condition cannot be set on an essential container.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCESS</code> - This condition is the same as
    /// <code>COMPLETE</code>, but it also requires that the container exits with a
    /// <code>zero</code> status. This condition cannot be set on an essential
    /// container.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>HEALTHY</code> - This condition validates that the dependent
    /// container passes its Docker health check before permitting other containers to
    /// start. This requires that the dependent container has health checks configured.
    /// This condition is confirmed only at task startup.</p>
    /// </li>
    /// </ul>
    pub condition: std::option::Option<crate::model::ContainerCondition>,
}
impl std::fmt::Debug for ContainerDependency {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerDependency");
        formatter.field("container_name", &self.container_name);
        formatter.field("condition", &self.condition);
        formatter.finish()
    }
}
/// See [`ContainerDependency`](crate::model::ContainerDependency)
pub mod container_dependency {
    /// A builder for [`ContainerDependency`](crate::model::ContainerDependency)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_name: std::option::Option<std::string::String>,
        pub(crate) condition: std::option::Option<crate::model::ContainerCondition>,
    }
    impl Builder {
        /// <p>The name of a container.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_name = Some(input.into());
            self
        }
        /// <p>The name of a container.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_name = input;
            self
        }
        /// <p>The dependency condition of the container. The following are the available conditions
        /// and their behavior:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>START</code> - This condition emulates the behavior of links and
        /// volumes today. It validates that a dependent container is started before
        /// permitting other containers to start.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETE</code> - This condition validates that a dependent
        /// container runs to completion (exits) before permitting other containers to
        /// start. This can be useful for nonessential containers that run a script and then
        /// exit. This condition cannot be set on an essential container.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCESS</code> - This condition is the same as
        /// <code>COMPLETE</code>, but it also requires that the container exits with a
        /// <code>zero</code> status. This condition cannot be set on an essential
        /// container.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HEALTHY</code> - This condition validates that the dependent
        /// container passes its Docker health check before permitting other containers to
        /// start. This requires that the dependent container has health checks configured.
        /// This condition is confirmed only at task startup.</p>
        /// </li>
        /// </ul>
        pub fn condition(mut self, input: crate::model::ContainerCondition) -> Self {
            self.condition = Some(input);
            self
        }
        /// <p>The dependency condition of the container. The following are the available conditions
        /// and their behavior:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>START</code> - This condition emulates the behavior of links and
        /// volumes today. It validates that a dependent container is started before
        /// permitting other containers to start.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETE</code> - This condition validates that a dependent
        /// container runs to completion (exits) before permitting other containers to
        /// start. This can be useful for nonessential containers that run a script and then
        /// exit. This condition cannot be set on an essential container.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCESS</code> - This condition is the same as
        /// <code>COMPLETE</code>, but it also requires that the container exits with a
        /// <code>zero</code> status. This condition cannot be set on an essential
        /// container.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HEALTHY</code> - This condition validates that the dependent
        /// container passes its Docker health check before permitting other containers to
        /// start. This requires that the dependent container has health checks configured.
        /// This condition is confirmed only at task startup.</p>
        /// </li>
        /// </ul>
        pub fn set_condition(
            mut self,
            input: std::option::Option<crate::model::ContainerCondition>,
        ) -> Self {
            self.condition = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerDependency`](crate::model::ContainerDependency)
        pub fn build(self) -> crate::model::ContainerDependency {
            crate::model::ContainerDependency {
                container_name: self.container_name,
                condition: self.condition,
            }
        }
    }
}
impl ContainerDependency {
    /// Creates a new builder-style object to manufacture [`ContainerDependency`](crate::model::ContainerDependency)
    pub fn builder() -> crate::model::container_dependency::Builder {
        crate::model::container_dependency::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContainerCondition {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Healthy,
    #[allow(missing_docs)] // documentation missing in model
    Start,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContainerCondition {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE" => ContainerCondition::Complete,
            "HEALTHY" => ContainerCondition::Healthy,
            "START" => ContainerCondition::Start,
            "SUCCESS" => ContainerCondition::Success,
            other => ContainerCondition::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContainerCondition {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContainerCondition::from(s))
    }
}
impl ContainerCondition {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContainerCondition::Complete => "COMPLETE",
            ContainerCondition::Healthy => "HEALTHY",
            ContainerCondition::Start => "START",
            ContainerCondition::Success => "SUCCESS",
            ContainerCondition::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETE", "HEALTHY", "START", "SUCCESS"]
    }
}
impl AsRef<str> for ContainerCondition {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Linux-specific options that are applied to the container, such as Linux <a>KernelCapabilities</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LinuxParameters {
    /// <p>The Linux capabilities for the container that are added to or dropped from the default
    /// configuration provided by Docker.</p>
    /// <note>
    /// <p>For tasks that use the Fargate launch type,
    /// <code>capabilities</code> is supported for all platform versions but the
    /// <code>add</code> parameter is only supported if using platform version 1.4.0 or
    /// later.</p>
    /// </note>
    pub capabilities: std::option::Option<crate::model::KernelCapabilities>,
    /// <p>Any host devices to expose to the container. This parameter maps to
    /// <code>Devices</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
    /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--device</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
    /// <note>
    /// <p>If you are using tasks that use the Fargate launch type, the
    /// <code>devices</code> parameter is not supported.</p>
    /// </note>
    pub devices: std::option::Option<std::vec::Vec<crate::model::Device>>,
    /// <p>Run an <code>init</code> process inside the container that forwards signals and reaps
    /// processes. This parameter maps to the <code>--init</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>. This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
    /// </p>
    pub init_process_enabled: std::option::Option<bool>,
    /// <p>The value for the size (in MiB) of the <code>/dev/shm</code> volume. This parameter
    /// maps to the <code>--shm-size</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
    /// run</a>.</p>
    /// <note>
    /// <p>If you are using tasks that use the Fargate launch type, the
    /// <code>sharedMemorySize</code> parameter is not supported.</p>
    /// </note>
    pub shared_memory_size: std::option::Option<i32>,
    /// <p>The container path, mount options, and size (in MiB) of the tmpfs mount. This
    /// parameter maps to the <code>--tmpfs</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
    /// <note>
    /// <p>If you are using tasks that use the Fargate launch type, the
    /// <code>tmpfs</code> parameter is not supported.</p>
    /// </note>
    pub tmpfs: std::option::Option<std::vec::Vec<crate::model::Tmpfs>>,
    /// <p>The total amount of swap memory (in MiB) a container can use. This parameter will be
    /// translated to the <code>--memory-swap</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> where the value would be the sum of
    /// the container memory plus the <code>maxSwap</code> value.</p>
    /// <p>If a <code>maxSwap</code> value of <code>0</code> is specified, the container will not
    /// use swap. Accepted values are <code>0</code> or any positive integer. If the
    /// <code>maxSwap</code> parameter is omitted, the container will use the swap
    /// configuration for the container instance it is running on. A <code>maxSwap</code> value
    /// must be set for the <code>swappiness</code> parameter to be used.</p>
    /// <note>
    /// <p>If you are using tasks that use the Fargate launch type, the
    /// <code>maxSwap</code> parameter is not supported.</p>
    /// </note>
    pub max_swap: std::option::Option<i32>,
    /// <p>This allows you to tune a container's memory swappiness behavior. A
    /// <code>swappiness</code> value of <code>0</code> will cause swapping to not happen
    /// unless absolutely necessary. A <code>swappiness</code> value of <code>100</code> will
    /// cause pages to be swapped very aggressively. Accepted values are whole numbers between
    /// <code>0</code> and <code>100</code>. If the <code>swappiness</code> parameter is not
    /// specified, a default value of <code>60</code> is used. If a value is not specified for
    /// <code>maxSwap</code> then this parameter is ignored. This parameter maps to the
    /// <code>--memory-swappiness</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
    /// <note>
    /// <p>If you are using tasks that use the Fargate launch type, the
    /// <code>swappiness</code> parameter is not supported.</p>
    /// </note>
    pub swappiness: std::option::Option<i32>,
}
impl std::fmt::Debug for LinuxParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LinuxParameters");
        formatter.field("capabilities", &self.capabilities);
        formatter.field("devices", &self.devices);
        formatter.field("init_process_enabled", &self.init_process_enabled);
        formatter.field("shared_memory_size", &self.shared_memory_size);
        formatter.field("tmpfs", &self.tmpfs);
        formatter.field("max_swap", &self.max_swap);
        formatter.field("swappiness", &self.swappiness);
        formatter.finish()
    }
}
/// See [`LinuxParameters`](crate::model::LinuxParameters)
pub mod linux_parameters {
    /// A builder for [`LinuxParameters`](crate::model::LinuxParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capabilities: std::option::Option<crate::model::KernelCapabilities>,
        pub(crate) devices: std::option::Option<std::vec::Vec<crate::model::Device>>,
        pub(crate) init_process_enabled: std::option::Option<bool>,
        pub(crate) shared_memory_size: std::option::Option<i32>,
        pub(crate) tmpfs: std::option::Option<std::vec::Vec<crate::model::Tmpfs>>,
        pub(crate) max_swap: std::option::Option<i32>,
        pub(crate) swappiness: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Linux capabilities for the container that are added to or dropped from the default
        /// configuration provided by Docker.</p>
        /// <note>
        /// <p>For tasks that use the Fargate launch type,
        /// <code>capabilities</code> is supported for all platform versions but the
        /// <code>add</code> parameter is only supported if using platform version 1.4.0 or
        /// later.</p>
        /// </note>
        pub fn capabilities(mut self, input: crate::model::KernelCapabilities) -> Self {
            self.capabilities = Some(input);
            self
        }
        /// <p>The Linux capabilities for the container that are added to or dropped from the default
        /// configuration provided by Docker.</p>
        /// <note>
        /// <p>For tasks that use the Fargate launch type,
        /// <code>capabilities</code> is supported for all platform versions but the
        /// <code>add</code> parameter is only supported if using platform version 1.4.0 or
        /// later.</p>
        /// </note>
        pub fn set_capabilities(
            mut self,
            input: std::option::Option<crate::model::KernelCapabilities>,
        ) -> Self {
            self.capabilities = input;
            self
        }
        /// Appends an item to `devices`.
        ///
        /// To override the contents of this collection use [`set_devices`](Self::set_devices).
        ///
        /// <p>Any host devices to expose to the container. This parameter maps to
        /// <code>Devices</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--device</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <note>
        /// <p>If you are using tasks that use the Fargate launch type, the
        /// <code>devices</code> parameter is not supported.</p>
        /// </note>
        pub fn devices(mut self, input: impl Into<crate::model::Device>) -> Self {
            let mut v = self.devices.unwrap_or_default();
            v.push(input.into());
            self.devices = Some(v);
            self
        }
        /// <p>Any host devices to expose to the container. This parameter maps to
        /// <code>Devices</code> in the <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the
        /// <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--device</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <note>
        /// <p>If you are using tasks that use the Fargate launch type, the
        /// <code>devices</code> parameter is not supported.</p>
        /// </note>
        pub fn set_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Device>>,
        ) -> Self {
            self.devices = input;
            self
        }
        /// <p>Run an <code>init</code> process inside the container that forwards signals and reaps
        /// processes. This parameter maps to the <code>--init</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>. This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
        /// </p>
        pub fn init_process_enabled(mut self, input: bool) -> Self {
            self.init_process_enabled = Some(input);
            self
        }
        /// <p>Run an <code>init</code> process inside the container that forwards signals and reaps
        /// processes. This parameter maps to the <code>--init</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>. This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
        /// </p>
        pub fn set_init_process_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.init_process_enabled = input;
            self
        }
        /// <p>The value for the size (in MiB) of the <code>/dev/shm</code> volume. This parameter
        /// maps to the <code>--shm-size</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <note>
        /// <p>If you are using tasks that use the Fargate launch type, the
        /// <code>sharedMemorySize</code> parameter is not supported.</p>
        /// </note>
        pub fn shared_memory_size(mut self, input: i32) -> Self {
            self.shared_memory_size = Some(input);
            self
        }
        /// <p>The value for the size (in MiB) of the <code>/dev/shm</code> volume. This parameter
        /// maps to the <code>--shm-size</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <note>
        /// <p>If you are using tasks that use the Fargate launch type, the
        /// <code>sharedMemorySize</code> parameter is not supported.</p>
        /// </note>
        pub fn set_shared_memory_size(mut self, input: std::option::Option<i32>) -> Self {
            self.shared_memory_size = input;
            self
        }
        /// Appends an item to `tmpfs`.
        ///
        /// To override the contents of this collection use [`set_tmpfs`](Self::set_tmpfs).
        ///
        /// <p>The container path, mount options, and size (in MiB) of the tmpfs mount. This
        /// parameter maps to the <code>--tmpfs</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <note>
        /// <p>If you are using tasks that use the Fargate launch type, the
        /// <code>tmpfs</code> parameter is not supported.</p>
        /// </note>
        pub fn tmpfs(mut self, input: impl Into<crate::model::Tmpfs>) -> Self {
            let mut v = self.tmpfs.unwrap_or_default();
            v.push(input.into());
            self.tmpfs = Some(v);
            self
        }
        /// <p>The container path, mount options, and size (in MiB) of the tmpfs mount. This
        /// parameter maps to the <code>--tmpfs</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <note>
        /// <p>If you are using tasks that use the Fargate launch type, the
        /// <code>tmpfs</code> parameter is not supported.</p>
        /// </note>
        pub fn set_tmpfs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tmpfs>>,
        ) -> Self {
            self.tmpfs = input;
            self
        }
        /// <p>The total amount of swap memory (in MiB) a container can use. This parameter will be
        /// translated to the <code>--memory-swap</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> where the value would be the sum of
        /// the container memory plus the <code>maxSwap</code> value.</p>
        /// <p>If a <code>maxSwap</code> value of <code>0</code> is specified, the container will not
        /// use swap. Accepted values are <code>0</code> or any positive integer. If the
        /// <code>maxSwap</code> parameter is omitted, the container will use the swap
        /// configuration for the container instance it is running on. A <code>maxSwap</code> value
        /// must be set for the <code>swappiness</code> parameter to be used.</p>
        /// <note>
        /// <p>If you are using tasks that use the Fargate launch type, the
        /// <code>maxSwap</code> parameter is not supported.</p>
        /// </note>
        pub fn max_swap(mut self, input: i32) -> Self {
            self.max_swap = Some(input);
            self
        }
        /// <p>The total amount of swap memory (in MiB) a container can use. This parameter will be
        /// translated to the <code>--memory-swap</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a> where the value would be the sum of
        /// the container memory plus the <code>maxSwap</code> value.</p>
        /// <p>If a <code>maxSwap</code> value of <code>0</code> is specified, the container will not
        /// use swap. Accepted values are <code>0</code> or any positive integer. If the
        /// <code>maxSwap</code> parameter is omitted, the container will use the swap
        /// configuration for the container instance it is running on. A <code>maxSwap</code> value
        /// must be set for the <code>swappiness</code> parameter to be used.</p>
        /// <note>
        /// <p>If you are using tasks that use the Fargate launch type, the
        /// <code>maxSwap</code> parameter is not supported.</p>
        /// </note>
        pub fn set_max_swap(mut self, input: std::option::Option<i32>) -> Self {
            self.max_swap = input;
            self
        }
        /// <p>This allows you to tune a container's memory swappiness behavior. A
        /// <code>swappiness</code> value of <code>0</code> will cause swapping to not happen
        /// unless absolutely necessary. A <code>swappiness</code> value of <code>100</code> will
        /// cause pages to be swapped very aggressively. Accepted values are whole numbers between
        /// <code>0</code> and <code>100</code>. If the <code>swappiness</code> parameter is not
        /// specified, a default value of <code>60</code> is used. If a value is not specified for
        /// <code>maxSwap</code> then this parameter is ignored. This parameter maps to the
        /// <code>--memory-swappiness</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <note>
        /// <p>If you are using tasks that use the Fargate launch type, the
        /// <code>swappiness</code> parameter is not supported.</p>
        /// </note>
        pub fn swappiness(mut self, input: i32) -> Self {
            self.swappiness = Some(input);
            self
        }
        /// <p>This allows you to tune a container's memory swappiness behavior. A
        /// <code>swappiness</code> value of <code>0</code> will cause swapping to not happen
        /// unless absolutely necessary. A <code>swappiness</code> value of <code>100</code> will
        /// cause pages to be swapped very aggressively. Accepted values are whole numbers between
        /// <code>0</code> and <code>100</code>. If the <code>swappiness</code> parameter is not
        /// specified, a default value of <code>60</code> is used. If a value is not specified for
        /// <code>maxSwap</code> then this parameter is ignored. This parameter maps to the
        /// <code>--memory-swappiness</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker run</a>.</p>
        /// <note>
        /// <p>If you are using tasks that use the Fargate launch type, the
        /// <code>swappiness</code> parameter is not supported.</p>
        /// </note>
        pub fn set_swappiness(mut self, input: std::option::Option<i32>) -> Self {
            self.swappiness = input;
            self
        }
        /// Consumes the builder and constructs a [`LinuxParameters`](crate::model::LinuxParameters)
        pub fn build(self) -> crate::model::LinuxParameters {
            crate::model::LinuxParameters {
                capabilities: self.capabilities,
                devices: self.devices,
                init_process_enabled: self.init_process_enabled,
                shared_memory_size: self.shared_memory_size,
                tmpfs: self.tmpfs,
                max_swap: self.max_swap,
                swappiness: self.swappiness,
            }
        }
    }
}
impl LinuxParameters {
    /// Creates a new builder-style object to manufacture [`LinuxParameters`](crate::model::LinuxParameters)
    pub fn builder() -> crate::model::linux_parameters::Builder {
        crate::model::linux_parameters::Builder::default()
    }
}

/// <p>The container path, mount options, and size of the tmpfs mount.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tmpfs {
    /// <p>The absolute file path where the tmpfs volume is to be mounted.</p>
    pub container_path: std::option::Option<std::string::String>,
    /// <p>The maximum size (in MiB) of the tmpfs volume.</p>
    pub size: i32,
    /// <p>The list of tmpfs volume mount options.</p>
    /// <p>Valid values: <code>"defaults" | "ro" | "rw" | "suid" | "nosuid" | "dev" | "nodev" |
    /// "exec" | "noexec" | "sync" | "async" | "dirsync" | "remount" | "mand" | "nomand" |
    /// "atime" | "noatime" | "diratime" | "nodiratime" | "bind" | "rbind" | "unbindable" |
    /// "runbindable" | "private" | "rprivate" | "shared" | "rshared" | "slave" | "rslave" |
    /// "relatime" | "norelatime" | "strictatime" | "nostrictatime" | "mode" | "uid" | "gid"
    /// | "nr_inodes" | "nr_blocks" | "mpol"</code>
    /// </p>
    pub mount_options: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for Tmpfs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tmpfs");
        formatter.field("container_path", &self.container_path);
        formatter.field("size", &self.size);
        formatter.field("mount_options", &self.mount_options);
        formatter.finish()
    }
}
/// See [`Tmpfs`](crate::model::Tmpfs)
pub mod tmpfs {
    /// A builder for [`Tmpfs`](crate::model::Tmpfs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_path: std::option::Option<std::string::String>,
        pub(crate) size: std::option::Option<i32>,
        pub(crate) mount_options: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The absolute file path where the tmpfs volume is to be mounted.</p>
        pub fn container_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_path = Some(input.into());
            self
        }
        /// <p>The absolute file path where the tmpfs volume is to be mounted.</p>
        pub fn set_container_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_path = input;
            self
        }
        /// <p>The maximum size (in MiB) of the tmpfs volume.</p>
        pub fn size(mut self, input: i32) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The maximum size (in MiB) of the tmpfs volume.</p>
        pub fn set_size(mut self, input: std::option::Option<i32>) -> Self {
            self.size = input;
            self
        }
        /// Appends an item to `mount_options`.
        ///
        /// To override the contents of this collection use [`set_mount_options`](Self::set_mount_options).
        ///
        /// <p>The list of tmpfs volume mount options.</p>
        /// <p>Valid values: <code>"defaults" | "ro" | "rw" | "suid" | "nosuid" | "dev" | "nodev" |
        /// "exec" | "noexec" | "sync" | "async" | "dirsync" | "remount" | "mand" | "nomand" |
        /// "atime" | "noatime" | "diratime" | "nodiratime" | "bind" | "rbind" | "unbindable" |
        /// "runbindable" | "private" | "rprivate" | "shared" | "rshared" | "slave" | "rslave" |
        /// "relatime" | "norelatime" | "strictatime" | "nostrictatime" | "mode" | "uid" | "gid"
        /// | "nr_inodes" | "nr_blocks" | "mpol"</code>
        /// </p>
        pub fn mount_options(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.mount_options.unwrap_or_default();
            v.push(input.into());
            self.mount_options = Some(v);
            self
        }
        /// <p>The list of tmpfs volume mount options.</p>
        /// <p>Valid values: <code>"defaults" | "ro" | "rw" | "suid" | "nosuid" | "dev" | "nodev" |
        /// "exec" | "noexec" | "sync" | "async" | "dirsync" | "remount" | "mand" | "nomand" |
        /// "atime" | "noatime" | "diratime" | "nodiratime" | "bind" | "rbind" | "unbindable" |
        /// "runbindable" | "private" | "rprivate" | "shared" | "rshared" | "slave" | "rslave" |
        /// "relatime" | "norelatime" | "strictatime" | "nostrictatime" | "mode" | "uid" | "gid"
        /// | "nr_inodes" | "nr_blocks" | "mpol"</code>
        /// </p>
        pub fn set_mount_options(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.mount_options = input;
            self
        }
        /// Consumes the builder and constructs a [`Tmpfs`](crate::model::Tmpfs)
        pub fn build(self) -> crate::model::Tmpfs {
            crate::model::Tmpfs {
                container_path: self.container_path,
                size: self.size.unwrap_or_default(),
                mount_options: self.mount_options,
            }
        }
    }
}
impl Tmpfs {
    /// Creates a new builder-style object to manufacture [`Tmpfs`](crate::model::Tmpfs)
    pub fn builder() -> crate::model::tmpfs::Builder {
        crate::model::tmpfs::Builder::default()
    }
}

/// <p>An object representing a container instance host device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Device {
    /// <p>The path for the device on the host container instance.</p>
    pub host_path: std::option::Option<std::string::String>,
    /// <p>The path inside the container at which to expose the host device.</p>
    pub container_path: std::option::Option<std::string::String>,
    /// <p>The explicit permissions to provide to the container for the device. By default, the
    /// container has permissions for <code>read</code>, <code>write</code>, and
    /// <code>mknod</code> for the device.</p>
    pub permissions: std::option::Option<std::vec::Vec<crate::model::DeviceCgroupPermission>>,
}
impl std::fmt::Debug for Device {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Device");
        formatter.field("host_path", &self.host_path);
        formatter.field("container_path", &self.container_path);
        formatter.field("permissions", &self.permissions);
        formatter.finish()
    }
}
/// See [`Device`](crate::model::Device)
pub mod device {
    /// A builder for [`Device`](crate::model::Device)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host_path: std::option::Option<std::string::String>,
        pub(crate) container_path: std::option::Option<std::string::String>,
        pub(crate) permissions:
            std::option::Option<std::vec::Vec<crate::model::DeviceCgroupPermission>>,
    }
    impl Builder {
        /// <p>The path for the device on the host container instance.</p>
        pub fn host_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_path = Some(input.into());
            self
        }
        /// <p>The path for the device on the host container instance.</p>
        pub fn set_host_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host_path = input;
            self
        }
        /// <p>The path inside the container at which to expose the host device.</p>
        pub fn container_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_path = Some(input.into());
            self
        }
        /// <p>The path inside the container at which to expose the host device.</p>
        pub fn set_container_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_path = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>The explicit permissions to provide to the container for the device. By default, the
        /// container has permissions for <code>read</code>, <code>write</code>, and
        /// <code>mknod</code> for the device.</p>
        pub fn permissions(
            mut self,
            input: impl Into<crate::model::DeviceCgroupPermission>,
        ) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input.into());
            self.permissions = Some(v);
            self
        }
        /// <p>The explicit permissions to provide to the container for the device. By default, the
        /// container has permissions for <code>read</code>, <code>write</code>, and
        /// <code>mknod</code> for the device.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeviceCgroupPermission>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// Consumes the builder and constructs a [`Device`](crate::model::Device)
        pub fn build(self) -> crate::model::Device {
            crate::model::Device {
                host_path: self.host_path,
                container_path: self.container_path,
                permissions: self.permissions,
            }
        }
    }
}
impl Device {
    /// Creates a new builder-style object to manufacture [`Device`](crate::model::Device)
    pub fn builder() -> crate::model::device::Builder {
        crate::model::device::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceCgroupPermission {
    #[allow(missing_docs)] // documentation missing in model
    Mknod,
    #[allow(missing_docs)] // documentation missing in model
    Read,
    #[allow(missing_docs)] // documentation missing in model
    Write,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceCgroupPermission {
    fn from(s: &str) -> Self {
        match s {
            "mknod" => DeviceCgroupPermission::Mknod,
            "read" => DeviceCgroupPermission::Read,
            "write" => DeviceCgroupPermission::Write,
            other => DeviceCgroupPermission::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceCgroupPermission {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceCgroupPermission::from(s))
    }
}
impl DeviceCgroupPermission {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceCgroupPermission::Mknod => "mknod",
            DeviceCgroupPermission::Read => "read",
            DeviceCgroupPermission::Write => "write",
            DeviceCgroupPermission::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["mknod", "read", "write"]
    }
}
impl AsRef<str> for DeviceCgroupPermission {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The Linux capabilities for the container that are added to or dropped from the default
/// configuration provided by Docker. For more information on the default capabilities and
/// the non-default available capabilities, see <a href="https://docs.docker.com/engine/reference/run/#runtime-privilege-and-linux-capabilities">Runtime privilege and Linux capabilities</a> in the <i>Docker run
/// reference</i>. For more detailed information on these Linux capabilities, see
/// the <a href="http://man7.org/linux/man-pages/man7/capabilities.7.html">capabilities(7)</a> Linux manual page.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KernelCapabilities {
    /// <p>The Linux capabilities for the container that have been added to the default
    /// configuration provided by Docker. This parameter maps to <code>CapAdd</code> in the
    /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
    /// <code>--cap-add</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
    /// run</a>.</p>
    /// <note>
    /// <p>Tasks launched on Fargate only support adding the <code>SYS_PTRACE</code> kernel
    /// capability.</p>
    /// </note>
    /// <p>Valid values: <code>"ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" |
    /// "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK" |
    /// "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" | "MAC_OVERRIDE" |
    /// "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW" | "SETFCAP"
    /// | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT" | "SYS_CHROOT" |
    /// "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" | "SYS_RAWIO" |
    /// "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" |
    /// "WAKE_ALARM"</code>
    /// </p>
    pub add: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Linux capabilities for the container that have been removed from the default
    /// configuration provided by Docker. This parameter maps to <code>CapDrop</code> in the
    /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
    /// <code>--cap-drop</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
    /// run</a>.</p>
    /// <p>Valid values: <code>"ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" |
    /// "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK" |
    /// "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" | "MAC_OVERRIDE" |
    /// "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW" | "SETFCAP"
    /// | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT" | "SYS_CHROOT" |
    /// "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" | "SYS_RAWIO" |
    /// "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" |
    /// "WAKE_ALARM"</code>
    /// </p>
    pub drop: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for KernelCapabilities {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KernelCapabilities");
        formatter.field("add", &self.add);
        formatter.field("drop", &self.drop);
        formatter.finish()
    }
}
/// See [`KernelCapabilities`](crate::model::KernelCapabilities)
pub mod kernel_capabilities {
    /// A builder for [`KernelCapabilities`](crate::model::KernelCapabilities)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) add: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) drop: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `add`.
        ///
        /// To override the contents of this collection use [`set_add`](Self::set_add).
        ///
        /// <p>The Linux capabilities for the container that have been added to the default
        /// configuration provided by Docker. This parameter maps to <code>CapAdd</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--cap-add</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <note>
        /// <p>Tasks launched on Fargate only support adding the <code>SYS_PTRACE</code> kernel
        /// capability.</p>
        /// </note>
        /// <p>Valid values: <code>"ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" |
        /// "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK" |
        /// "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" | "MAC_OVERRIDE" |
        /// "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW" | "SETFCAP"
        /// | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT" | "SYS_CHROOT" |
        /// "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" | "SYS_RAWIO" |
        /// "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" |
        /// "WAKE_ALARM"</code>
        /// </p>
        pub fn add(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.add.unwrap_or_default();
            v.push(input.into());
            self.add = Some(v);
            self
        }
        /// <p>The Linux capabilities for the container that have been added to the default
        /// configuration provided by Docker. This parameter maps to <code>CapAdd</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--cap-add</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <note>
        /// <p>Tasks launched on Fargate only support adding the <code>SYS_PTRACE</code> kernel
        /// capability.</p>
        /// </note>
        /// <p>Valid values: <code>"ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" |
        /// "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK" |
        /// "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" | "MAC_OVERRIDE" |
        /// "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW" | "SETFCAP"
        /// | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT" | "SYS_CHROOT" |
        /// "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" | "SYS_RAWIO" |
        /// "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" |
        /// "WAKE_ALARM"</code>
        /// </p>
        pub fn set_add(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.add = input;
            self
        }
        /// Appends an item to `drop`.
        ///
        /// To override the contents of this collection use [`set_drop`](Self::set_drop).
        ///
        /// <p>The Linux capabilities for the container that have been removed from the default
        /// configuration provided by Docker. This parameter maps to <code>CapDrop</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--cap-drop</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <p>Valid values: <code>"ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" |
        /// "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK" |
        /// "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" | "MAC_OVERRIDE" |
        /// "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW" | "SETFCAP"
        /// | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT" | "SYS_CHROOT" |
        /// "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" | "SYS_RAWIO" |
        /// "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" |
        /// "WAKE_ALARM"</code>
        /// </p>
        pub fn drop(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.drop.unwrap_or_default();
            v.push(input.into());
            self.drop = Some(v);
            self
        }
        /// <p>The Linux capabilities for the container that have been removed from the default
        /// configuration provided by Docker. This parameter maps to <code>CapDrop</code> in the
        /// <a href="https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the
        /// <code>--cap-drop</code> option to <a href="https://docs.docker.com/engine/reference/run/#security-configuration">docker
        /// run</a>.</p>
        /// <p>Valid values: <code>"ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" |
        /// "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK" |
        /// "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" | "MAC_OVERRIDE" |
        /// "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW" | "SETFCAP"
        /// | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT" | "SYS_CHROOT" |
        /// "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" | "SYS_RAWIO" |
        /// "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" |
        /// "WAKE_ALARM"</code>
        /// </p>
        pub fn set_drop(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.drop = input;
            self
        }
        /// Consumes the builder and constructs a [`KernelCapabilities`](crate::model::KernelCapabilities)
        pub fn build(self) -> crate::model::KernelCapabilities {
            crate::model::KernelCapabilities {
                add: self.add,
                drop: self.drop,
            }
        }
    }
}
impl KernelCapabilities {
    /// Creates a new builder-style object to manufacture [`KernelCapabilities`](crate::model::KernelCapabilities)
    pub fn builder() -> crate::model::kernel_capabilities::Builder {
        crate::model::kernel_capabilities::Builder::default()
    }
}

/// <p>Details on a data volume from another container in the same task definition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VolumeFrom {
    /// <p>The name of another container within the same task definition from which to mount
    /// volumes.</p>
    pub source_container: std::option::Option<std::string::String>,
    /// <p>If this value is <code>true</code>, the container has read-only access to the volume.
    /// If this value is <code>false</code>, then the container can write to the volume. The
    /// default value is <code>false</code>.</p>
    pub read_only: std::option::Option<bool>,
}
impl std::fmt::Debug for VolumeFrom {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VolumeFrom");
        formatter.field("source_container", &self.source_container);
        formatter.field("read_only", &self.read_only);
        formatter.finish()
    }
}
/// See [`VolumeFrom`](crate::model::VolumeFrom)
pub mod volume_from {
    /// A builder for [`VolumeFrom`](crate::model::VolumeFrom)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_container: std::option::Option<std::string::String>,
        pub(crate) read_only: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of another container within the same task definition from which to mount
        /// volumes.</p>
        pub fn source_container(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_container = Some(input.into());
            self
        }
        /// <p>The name of another container within the same task definition from which to mount
        /// volumes.</p>
        pub fn set_source_container(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_container = input;
            self
        }
        /// <p>If this value is <code>true</code>, the container has read-only access to the volume.
        /// If this value is <code>false</code>, then the container can write to the volume. The
        /// default value is <code>false</code>.</p>
        pub fn read_only(mut self, input: bool) -> Self {
            self.read_only = Some(input);
            self
        }
        /// <p>If this value is <code>true</code>, the container has read-only access to the volume.
        /// If this value is <code>false</code>, then the container can write to the volume. The
        /// default value is <code>false</code>.</p>
        pub fn set_read_only(mut self, input: std::option::Option<bool>) -> Self {
            self.read_only = input;
            self
        }
        /// Consumes the builder and constructs a [`VolumeFrom`](crate::model::VolumeFrom)
        pub fn build(self) -> crate::model::VolumeFrom {
            crate::model::VolumeFrom {
                source_container: self.source_container,
                read_only: self.read_only,
            }
        }
    }
}
impl VolumeFrom {
    /// Creates a new builder-style object to manufacture [`VolumeFrom`](crate::model::VolumeFrom)
    pub fn builder() -> crate::model::volume_from::Builder {
        crate::model::volume_from::Builder::default()
    }
}

/// <p>Details on a volume mount point that is used in a container definition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MountPoint {
    /// <p>The name of the volume to mount. Must be a volume name referenced in the
    /// <code>name</code> parameter of task definition <code>volume</code>.</p>
    pub source_volume: std::option::Option<std::string::String>,
    /// <p>The path on the container to mount the host volume at.</p>
    pub container_path: std::option::Option<std::string::String>,
    /// <p>If this value is <code>true</code>, the container has read-only access to the volume.
    /// If this value is <code>false</code>, then the container can write to the volume. The
    /// default value is <code>false</code>.</p>
    pub read_only: std::option::Option<bool>,
}
impl std::fmt::Debug for MountPoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MountPoint");
        formatter.field("source_volume", &self.source_volume);
        formatter.field("container_path", &self.container_path);
        formatter.field("read_only", &self.read_only);
        formatter.finish()
    }
}
/// See [`MountPoint`](crate::model::MountPoint)
pub mod mount_point {
    /// A builder for [`MountPoint`](crate::model::MountPoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_volume: std::option::Option<std::string::String>,
        pub(crate) container_path: std::option::Option<std::string::String>,
        pub(crate) read_only: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the volume to mount. Must be a volume name referenced in the
        /// <code>name</code> parameter of task definition <code>volume</code>.</p>
        pub fn source_volume(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_volume = Some(input.into());
            self
        }
        /// <p>The name of the volume to mount. Must be a volume name referenced in the
        /// <code>name</code> parameter of task definition <code>volume</code>.</p>
        pub fn set_source_volume(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_volume = input;
            self
        }
        /// <p>The path on the container to mount the host volume at.</p>
        pub fn container_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_path = Some(input.into());
            self
        }
        /// <p>The path on the container to mount the host volume at.</p>
        pub fn set_container_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_path = input;
            self
        }
        /// <p>If this value is <code>true</code>, the container has read-only access to the volume.
        /// If this value is <code>false</code>, then the container can write to the volume. The
        /// default value is <code>false</code>.</p>
        pub fn read_only(mut self, input: bool) -> Self {
            self.read_only = Some(input);
            self
        }
        /// <p>If this value is <code>true</code>, the container has read-only access to the volume.
        /// If this value is <code>false</code>, then the container can write to the volume. The
        /// default value is <code>false</code>.</p>
        pub fn set_read_only(mut self, input: std::option::Option<bool>) -> Self {
            self.read_only = input;
            self
        }
        /// Consumes the builder and constructs a [`MountPoint`](crate::model::MountPoint)
        pub fn build(self) -> crate::model::MountPoint {
            crate::model::MountPoint {
                source_volume: self.source_volume,
                container_path: self.container_path,
                read_only: self.read_only,
            }
        }
    }
}
impl MountPoint {
    /// Creates a new builder-style object to manufacture [`MountPoint`](crate::model::MountPoint)
    pub fn builder() -> crate::model::mount_point::Builder {
        crate::model::mount_point::Builder::default()
    }
}

/// <p>Port mappings allow containers to access ports on the host container instance to send
/// or receive traffic. Port mappings are specified as part of the container
/// definition.</p>
/// <p>If you are using containers in a task with the <code>awsvpc</code> or
/// <code>host</code> network mode, exposed ports should be specified using
/// <code>containerPort</code>. The <code>hostPort</code> can be left blank or it must
/// be the same value as the <code>containerPort</code>.</p>
/// <note>
/// <p>You cannot expose the same container port for multiple protocols. An error will be
/// returned if this is attempted</p>
/// </note>
/// <p>After a task reaches the <code>RUNNING</code> status, manual and automatic host and
/// container port assignments are visible in the <code>networkBindings</code> section of
/// <a>DescribeTasks</a> API responses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortMapping {
    /// <p>The port number on the container that is bound to the user-specified or automatically
    /// assigned host port.</p>
    /// <p>If you are using containers in a task with the <code>awsvpc</code> or
    /// <code>host</code> network mode, exposed ports should be specified using
    /// <code>containerPort</code>.</p>
    /// <p>If you are using containers in a task with the <code>bridge</code> network mode and
    /// you specify a container port and not a host port, your container automatically receives
    /// a host port in the ephemeral port range. For more information, see
    /// <code>hostPort</code>. Port mappings that are automatically assigned in this way do not
    /// count toward the 100 reserved ports limit of a container instance.</p>
    pub container_port: std::option::Option<i32>,
    /// <p>The port number on the container instance to reserve for your container.</p>
    /// <p>If you are using containers in a task with the <code>awsvpc</code> or
    /// <code>host</code> network mode, the <code>hostPort</code> can either be left blank
    /// or set to the same value as the <code>containerPort</code>.</p>
    /// <p>If you are using containers in a task with the <code>bridge</code> network mode, you
    /// can specify a non-reserved host port for your container port mapping, or you can omit
    /// the <code>hostPort</code> (or set it to <code>0</code>) while specifying a
    /// <code>containerPort</code> and your container automatically receives a port in the
    /// ephemeral port range for your container instance operating system and Docker
    /// version.</p>
    /// <p>The default ephemeral port range for Docker version 1.6.0 and later is listed on the
    /// instance under <code>/proc/sys/net/ipv4/ip_local_port_range</code>. If this kernel
    /// parameter is unavailable, the default ephemeral port range from 49153 through 65535 is
    /// used. Do not attempt to specify a host port in the ephemeral port range as these are
    /// reserved for automatic assignment. In general, ports below 32768 are outside of the
    /// ephemeral port range.</p>
    /// <note>
    /// <p>The default ephemeral port range from 49153 through 65535 is always used for
    /// Docker versions before 1.6.0.</p>
    /// </note>
    /// <p>The default reserved ports are 22 for SSH, the Docker ports 2375 and 2376, and the
    /// Amazon ECS container agent ports 51678-51680. Any host port that was previously specified in
    /// a running task is also reserved while the task is running (after a task stops, the host
    /// port is released). The current reserved ports are displayed in the
    /// <code>remainingResources</code> of <a>DescribeContainerInstances</a>
    /// output. A container instance can have up to 100 reserved ports at a time, including the
    /// default reserved ports. Automatically assigned ports don't count toward the 100 reserved
    /// ports limit.</p>
    pub host_port: std::option::Option<i32>,
    /// <p>The protocol used for the port mapping. Valid values are <code>tcp</code> and
    /// <code>udp</code>. The default is <code>tcp</code>.</p>
    pub protocol: std::option::Option<crate::model::TransportProtocol>,
}
impl std::fmt::Debug for PortMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortMapping");
        formatter.field("container_port", &self.container_port);
        formatter.field("host_port", &self.host_port);
        formatter.field("protocol", &self.protocol);
        formatter.finish()
    }
}
/// See [`PortMapping`](crate::model::PortMapping)
pub mod port_mapping {
    /// A builder for [`PortMapping`](crate::model::PortMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_port: std::option::Option<i32>,
        pub(crate) host_port: std::option::Option<i32>,
        pub(crate) protocol: std::option::Option<crate::model::TransportProtocol>,
    }
    impl Builder {
        /// <p>The port number on the container that is bound to the user-specified or automatically
        /// assigned host port.</p>
        /// <p>If you are using containers in a task with the <code>awsvpc</code> or
        /// <code>host</code> network mode, exposed ports should be specified using
        /// <code>containerPort</code>.</p>
        /// <p>If you are using containers in a task with the <code>bridge</code> network mode and
        /// you specify a container port and not a host port, your container automatically receives
        /// a host port in the ephemeral port range. For more information, see
        /// <code>hostPort</code>. Port mappings that are automatically assigned in this way do not
        /// count toward the 100 reserved ports limit of a container instance.</p>
        pub fn container_port(mut self, input: i32) -> Self {
            self.container_port = Some(input);
            self
        }
        /// <p>The port number on the container that is bound to the user-specified or automatically
        /// assigned host port.</p>
        /// <p>If you are using containers in a task with the <code>awsvpc</code> or
        /// <code>host</code> network mode, exposed ports should be specified using
        /// <code>containerPort</code>.</p>
        /// <p>If you are using containers in a task with the <code>bridge</code> network mode and
        /// you specify a container port and not a host port, your container automatically receives
        /// a host port in the ephemeral port range. For more information, see
        /// <code>hostPort</code>. Port mappings that are automatically assigned in this way do not
        /// count toward the 100 reserved ports limit of a container instance.</p>
        pub fn set_container_port(mut self, input: std::option::Option<i32>) -> Self {
            self.container_port = input;
            self
        }
        /// <p>The port number on the container instance to reserve for your container.</p>
        /// <p>If you are using containers in a task with the <code>awsvpc</code> or
        /// <code>host</code> network mode, the <code>hostPort</code> can either be left blank
        /// or set to the same value as the <code>containerPort</code>.</p>
        /// <p>If you are using containers in a task with the <code>bridge</code> network mode, you
        /// can specify a non-reserved host port for your container port mapping, or you can omit
        /// the <code>hostPort</code> (or set it to <code>0</code>) while specifying a
        /// <code>containerPort</code> and your container automatically receives a port in the
        /// ephemeral port range for your container instance operating system and Docker
        /// version.</p>
        /// <p>The default ephemeral port range for Docker version 1.6.0 and later is listed on the
        /// instance under <code>/proc/sys/net/ipv4/ip_local_port_range</code>. If this kernel
        /// parameter is unavailable, the default ephemeral port range from 49153 through 65535 is
        /// used. Do not attempt to specify a host port in the ephemeral port range as these are
        /// reserved for automatic assignment. In general, ports below 32768 are outside of the
        /// ephemeral port range.</p>
        /// <note>
        /// <p>The default ephemeral port range from 49153 through 65535 is always used for
        /// Docker versions before 1.6.0.</p>
        /// </note>
        /// <p>The default reserved ports are 22 for SSH, the Docker ports 2375 and 2376, and the
        /// Amazon ECS container agent ports 51678-51680. Any host port that was previously specified in
        /// a running task is also reserved while the task is running (after a task stops, the host
        /// port is released). The current reserved ports are displayed in the
        /// <code>remainingResources</code> of <a>DescribeContainerInstances</a>
        /// output. A container instance can have up to 100 reserved ports at a time, including the
        /// default reserved ports. Automatically assigned ports don't count toward the 100 reserved
        /// ports limit.</p>
        pub fn host_port(mut self, input: i32) -> Self {
            self.host_port = Some(input);
            self
        }
        /// <p>The port number on the container instance to reserve for your container.</p>
        /// <p>If you are using containers in a task with the <code>awsvpc</code> or
        /// <code>host</code> network mode, the <code>hostPort</code> can either be left blank
        /// or set to the same value as the <code>containerPort</code>.</p>
        /// <p>If you are using containers in a task with the <code>bridge</code> network mode, you
        /// can specify a non-reserved host port for your container port mapping, or you can omit
        /// the <code>hostPort</code> (or set it to <code>0</code>) while specifying a
        /// <code>containerPort</code> and your container automatically receives a port in the
        /// ephemeral port range for your container instance operating system and Docker
        /// version.</p>
        /// <p>The default ephemeral port range for Docker version 1.6.0 and later is listed on the
        /// instance under <code>/proc/sys/net/ipv4/ip_local_port_range</code>. If this kernel
        /// parameter is unavailable, the default ephemeral port range from 49153 through 65535 is
        /// used. Do not attempt to specify a host port in the ephemeral port range as these are
        /// reserved for automatic assignment. In general, ports below 32768 are outside of the
        /// ephemeral port range.</p>
        /// <note>
        /// <p>The default ephemeral port range from 49153 through 65535 is always used for
        /// Docker versions before 1.6.0.</p>
        /// </note>
        /// <p>The default reserved ports are 22 for SSH, the Docker ports 2375 and 2376, and the
        /// Amazon ECS container agent ports 51678-51680. Any host port that was previously specified in
        /// a running task is also reserved while the task is running (after a task stops, the host
        /// port is released). The current reserved ports are displayed in the
        /// <code>remainingResources</code> of <a>DescribeContainerInstances</a>
        /// output. A container instance can have up to 100 reserved ports at a time, including the
        /// default reserved ports. Automatically assigned ports don't count toward the 100 reserved
        /// ports limit.</p>
        pub fn set_host_port(mut self, input: std::option::Option<i32>) -> Self {
            self.host_port = input;
            self
        }
        /// <p>The protocol used for the port mapping. Valid values are <code>tcp</code> and
        /// <code>udp</code>. The default is <code>tcp</code>.</p>
        pub fn protocol(mut self, input: crate::model::TransportProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol used for the port mapping. Valid values are <code>tcp</code> and
        /// <code>udp</code>. The default is <code>tcp</code>.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::TransportProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// Consumes the builder and constructs a [`PortMapping`](crate::model::PortMapping)
        pub fn build(self) -> crate::model::PortMapping {
            crate::model::PortMapping {
                container_port: self.container_port,
                host_port: self.host_port,
                protocol: self.protocol,
            }
        }
    }
}
impl PortMapping {
    /// Creates a new builder-style object to manufacture [`PortMapping`](crate::model::PortMapping)
    pub fn builder() -> crate::model::port_mapping::Builder {
        crate::model::port_mapping::Builder::default()
    }
}

/// <p>The repository credentials for private registry authentication.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryCredentials {
    /// <p>The Amazon Resource Name (ARN) of the secret containing the private repository
    /// credentials.</p>
    /// <note>
    /// <p>When you are using the Amazon ECS API, CLI, or Amazon Web Services SDK, if the secret exists in the
    /// same Region as the task that you are launching then you can use either the full ARN
    /// or the name of the secret. When you are using the Amazon Web Services Management Console, you must specify the
    /// full ARN of the secret.</p>
    /// </note>
    pub credentials_parameter: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RepositoryCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryCredentials");
        formatter.field("credentials_parameter", &self.credentials_parameter);
        formatter.finish()
    }
}
/// See [`RepositoryCredentials`](crate::model::RepositoryCredentials)
pub mod repository_credentials {
    /// A builder for [`RepositoryCredentials`](crate::model::RepositoryCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) credentials_parameter: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the secret containing the private repository
        /// credentials.</p>
        /// <note>
        /// <p>When you are using the Amazon ECS API, CLI, or Amazon Web Services SDK, if the secret exists in the
        /// same Region as the task that you are launching then you can use either the full ARN
        /// or the name of the secret. When you are using the Amazon Web Services Management Console, you must specify the
        /// full ARN of the secret.</p>
        /// </note>
        pub fn credentials_parameter(mut self, input: impl Into<std::string::String>) -> Self {
            self.credentials_parameter = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the secret containing the private repository
        /// credentials.</p>
        /// <note>
        /// <p>When you are using the Amazon ECS API, CLI, or Amazon Web Services SDK, if the secret exists in the
        /// same Region as the task that you are launching then you can use either the full ARN
        /// or the name of the secret. When you are using the Amazon Web Services Management Console, you must specify the
        /// full ARN of the secret.</p>
        /// </note>
        pub fn set_credentials_parameter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.credentials_parameter = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryCredentials`](crate::model::RepositoryCredentials)
        pub fn build(self) -> crate::model::RepositoryCredentials {
            crate::model::RepositoryCredentials {
                credentials_parameter: self.credentials_parameter,
            }
        }
    }
}
impl RepositoryCredentials {
    /// Creates a new builder-style object to manufacture [`RepositoryCredentials`](crate::model::RepositoryCredentials)
    pub fn builder() -> crate::model::repository_credentials::Builder {
        crate::model::repository_credentials::Builder::default()
    }
}

/// <p>The devices that are available on the container instance. The only supported device
/// type is a GPU.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlatformDevice {
    /// <p>The ID for the GPU(s) on the container instance. The available GPU IDs can also be
    /// obtained on the container instance in the
    /// <code>/var/lib/ecs/gpu/nvidia_gpu_info.json</code> file.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of device that is available on the container instance. The only supported
    /// value is <code>GPU</code>.</p>
    pub r#type: std::option::Option<crate::model::PlatformDeviceType>,
}
impl std::fmt::Debug for PlatformDevice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlatformDevice");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`PlatformDevice`](crate::model::PlatformDevice)
pub mod platform_device {
    /// A builder for [`PlatformDevice`](crate::model::PlatformDevice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::PlatformDeviceType>,
    }
    impl Builder {
        /// <p>The ID for the GPU(s) on the container instance. The available GPU IDs can also be
        /// obtained on the container instance in the
        /// <code>/var/lib/ecs/gpu/nvidia_gpu_info.json</code> file.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID for the GPU(s) on the container instance. The available GPU IDs can also be
        /// obtained on the container instance in the
        /// <code>/var/lib/ecs/gpu/nvidia_gpu_info.json</code> file.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of device that is available on the container instance. The only supported
        /// value is <code>GPU</code>.</p>
        pub fn r#type(mut self, input: crate::model::PlatformDeviceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of device that is available on the container instance. The only supported
        /// value is <code>GPU</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::PlatformDeviceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`PlatformDevice`](crate::model::PlatformDevice)
        pub fn build(self) -> crate::model::PlatformDevice {
            crate::model::PlatformDevice {
                id: self.id,
                r#type: self.r#type,
            }
        }
    }
}
impl PlatformDevice {
    /// Creates a new builder-style object to manufacture [`PlatformDevice`](crate::model::PlatformDevice)
    pub fn builder() -> crate::model::platform_device::Builder {
        crate::model::platform_device::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std