// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateCapacityProviderInput`](crate::input::CreateCapacityProviderInput)
pub mod create_capacity_provider_input {
    /// A builder for [`CreateCapacityProviderInput`](crate::input::CreateCapacityProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group_provider:
            std::option::Option<crate::model::AutoScalingGroupProvider>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the capacity provider. Up to 255 characters are allowed, including letters
        /// (upper and lowercase), numbers, underscores, and hyphens. The name cannot be prefixed
        /// with "<code>aws</code>", "<code>ecs</code>", or "<code>fargate</code>".</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the capacity provider. Up to 255 characters are allowed, including letters
        /// (upper and lowercase), numbers, underscores, and hyphens. The name cannot be prefixed
        /// with "<code>aws</code>", "<code>ecs</code>", or "<code>fargate</code>".</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The details of the Auto Scaling group for the capacity provider.</p>
        pub fn auto_scaling_group_provider(
            mut self,
            input: crate::model::AutoScalingGroupProvider,
        ) -> Self {
            self.auto_scaling_group_provider = Some(input);
            self
        }
        /// <p>The details of the Auto Scaling group for the capacity provider.</p>
        pub fn set_auto_scaling_group_provider(
            mut self,
            input: std::option::Option<crate::model::AutoScalingGroupProvider>,
        ) -> Self {
            self.auto_scaling_group_provider = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the capacity provider to help you categorize and
        /// organize them. Each tag consists of a key and an optional value, both of which you
        /// define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The metadata that you apply to the capacity provider to help you categorize and
        /// organize them. Each tag consists of a key and an optional value, both of which you
        /// define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCapacityProviderInput`](crate::input::CreateCapacityProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCapacityProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCapacityProviderInput {
                name: self.name,
                auto_scaling_group_provider: self.auto_scaling_group_provider,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCapacityProviderInputOperationOutputAlias = crate::operation::CreateCapacityProvider;
#[doc(hidden)]
pub type CreateCapacityProviderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateCapacityProviderInput {
    /// Consumes the builder and constructs an Operation<[`CreateCapacityProvider`](crate::operation::CreateCapacityProvider)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCapacityProvider,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCapacityProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCapacityProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCapacityProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.CreateCapacityProvider",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_capacity_provider(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCapacityProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCapacityProvider",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCapacityProviderInput`](crate::input::CreateCapacityProviderInput)
    pub fn builder() -> crate::input::create_capacity_provider_input::Builder {
        crate::input::create_capacity_provider_input::Builder::default()
    }
}

/// See [`CreateClusterInput`](crate::input::CreateClusterInput)
pub mod create_cluster_input {
    /// A builder for [`CreateClusterInput`](crate::input::CreateClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) settings: std::option::Option<std::vec::Vec<crate::model::ClusterSetting>>,
        pub(crate) configuration: std::option::Option<crate::model::ClusterConfiguration>,
        pub(crate) capacity_providers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) default_capacity_provider_strategy:
            std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
    }
    impl Builder {
        /// <p>The name of your cluster. If you do not specify a name for your cluster, you create a
        /// cluster named <code>default</code>. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. </p>
        pub fn cluster_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_name = Some(input.into());
            self
        }
        /// <p>The name of your cluster. If you do not specify a name for your cluster, you create a
        /// cluster named <code>default</code>. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. </p>
        pub fn set_cluster_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the cluster to help you categorize and organize them.
        /// Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The metadata that you apply to the cluster to help you categorize and organize them.
        /// Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `settings`.
        ///
        /// To override the contents of this collection use [`set_settings`](Self::set_settings).
        ///
        /// <p>The setting to use when creating a cluster. This parameter is used to enable CloudWatch
        /// Container Insights for a cluster. If this value is specified, it will override the
        /// <code>containerInsights</code> value set with <a>PutAccountSetting</a> or
        /// <a>PutAccountSettingDefault</a>.</p>
        pub fn settings(mut self, input: impl Into<crate::model::ClusterSetting>) -> Self {
            let mut v = self.settings.unwrap_or_default();
            v.push(input.into());
            self.settings = Some(v);
            self
        }
        /// <p>The setting to use when creating a cluster. This parameter is used to enable CloudWatch
        /// Container Insights for a cluster. If this value is specified, it will override the
        /// <code>containerInsights</code> value set with <a>PutAccountSetting</a> or
        /// <a>PutAccountSettingDefault</a>.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterSetting>>,
        ) -> Self {
            self.settings = input;
            self
        }
        /// <p>The execute command configuration for the cluster.</p>
        pub fn configuration(mut self, input: crate::model::ClusterConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The execute command configuration for the cluster.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ClusterConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Appends an item to `capacity_providers`.
        ///
        /// To override the contents of this collection use [`set_capacity_providers`](Self::set_capacity_providers).
        ///
        /// <p>The short name of one or more capacity providers to associate with the cluster. A
        /// capacity provider must be associated with a cluster before it can be included as part of
        /// the default capacity provider strategy of the cluster or used in a capacity provider
        /// strategy when calling the <a>CreateService</a> or <a>RunTask</a>
        /// actions.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity
        /// provider must already be created and not already associated with another cluster. New
        /// Auto Scaling group capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
        /// <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are
        /// available to all accounts and only need to be associated with a cluster to be
        /// used.</p>
        /// <p>The <a>PutClusterCapacityProviders</a> API operation is used to update the
        /// list of available capacity providers for a cluster after the cluster is created.</p>
        pub fn capacity_providers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.capacity_providers.unwrap_or_default();
            v.push(input.into());
            self.capacity_providers = Some(v);
            self
        }
        /// <p>The short name of one or more capacity providers to associate with the cluster. A
        /// capacity provider must be associated with a cluster before it can be included as part of
        /// the default capacity provider strategy of the cluster or used in a capacity provider
        /// strategy when calling the <a>CreateService</a> or <a>RunTask</a>
        /// actions.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity
        /// provider must already be created and not already associated with another cluster. New
        /// Auto Scaling group capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
        /// <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are
        /// available to all accounts and only need to be associated with a cluster to be
        /// used.</p>
        /// <p>The <a>PutClusterCapacityProviders</a> API operation is used to update the
        /// list of available capacity providers for a cluster after the cluster is created.</p>
        pub fn set_capacity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.capacity_providers = input;
            self
        }
        /// Appends an item to `default_capacity_provider_strategy`.
        ///
        /// To override the contents of this collection use [`set_default_capacity_provider_strategy`](Self::set_default_capacity_provider_strategy).
        ///
        /// <p>The capacity provider strategy to set as the default for the cluster. When a default
        /// capacity provider strategy is set for a cluster, when calling the <a>RunTask</a> or <a>CreateService</a> APIs with no capacity
        /// provider strategy or launch type specified, the default capacity provider strategy for
        /// the cluster is used.</p>
        /// <p>If a default capacity provider strategy is not defined for a cluster during creation,
        /// it can be defined later with the <a>PutClusterCapacityProviders</a> API
        /// operation.</p>
        pub fn default_capacity_provider_strategy(
            mut self,
            input: impl Into<crate::model::CapacityProviderStrategyItem>,
        ) -> Self {
            let mut v = self.default_capacity_provider_strategy.unwrap_or_default();
            v.push(input.into());
            self.default_capacity_provider_strategy = Some(v);
            self
        }
        /// <p>The capacity provider strategy to set as the default for the cluster. When a default
        /// capacity provider strategy is set for a cluster, when calling the <a>RunTask</a> or <a>CreateService</a> APIs with no capacity
        /// provider strategy or launch type specified, the default capacity provider strategy for
        /// the cluster is used.</p>
        /// <p>If a default capacity provider strategy is not defined for a cluster during creation,
        /// it can be defined later with the <a>PutClusterCapacityProviders</a> API
        /// operation.</p>
        pub fn set_default_capacity_provider_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        ) -> Self {
            self.default_capacity_provider_strategy = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClusterInput`](crate::input::CreateClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateClusterInput {
                cluster_name: self.cluster_name,
                tags: self.tags,
                settings: self.settings,
                configuration: self.configuration,
                capacity_providers: self.capacity_providers,
                default_capacity_provider_strategy: self.default_capacity_provider_strategy,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateClusterInputOperationOutputAlias = crate::operation::CreateCluster;
#[doc(hidden)]
pub type CreateClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateClusterInput {
    /// Consumes the builder and constructs an Operation<[`CreateCluster`](crate::operation::CreateCluster)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.CreateCluster",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_cluster(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCluster",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateClusterInput`](crate::input::CreateClusterInput)
    pub fn builder() -> crate::input::create_cluster_input::Builder {
        crate::input::create_cluster_input::Builder::default()
    }
}

/// See [`CreateServiceInput`](crate::input::CreateServiceInput)
pub mod create_service_input {
    /// A builder for [`CreateServiceInput`](crate::input::CreateServiceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) task_definition: std::option::Option<std::string::String>,
        pub(crate) load_balancers: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
        pub(crate) service_registries:
            std::option::Option<std::vec::Vec<crate::model::ServiceRegistry>>,
        pub(crate) desired_count: std::option::Option<i32>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) launch_type: std::option::Option<crate::model::LaunchType>,
        pub(crate) capacity_provider_strategy:
            std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        pub(crate) platform_version: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) deployment_configuration:
            std::option::Option<crate::model::DeploymentConfiguration>,
        pub(crate) placement_constraints:
            std::option::Option<std::vec::Vec<crate::model::PlacementConstraint>>,
        pub(crate) placement_strategy:
            std::option::Option<std::vec::Vec<crate::model::PlacementStrategy>>,
        pub(crate) network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
        pub(crate) health_check_grace_period_seconds: std::option::Option<i32>,
        pub(crate) scheduling_strategy: std::option::Option<crate::model::SchedulingStrategy>,
        pub(crate) deployment_controller: std::option::Option<crate::model::DeploymentController>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) enable_ecs_managed_tags: std::option::Option<bool>,
        pub(crate) propagate_tags: std::option::Option<crate::model::PropagateTags>,
        pub(crate) enable_execute_command: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster on which to run your service.
        /// If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster on which to run your service.
        /// If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. Service names must be unique within
        /// a cluster, but you can have similarly named services in multiple clusters within a
        /// Region or across multiple Regions.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. Service names must be unique within
        /// a cluster, but you can have similarly named services in multiple clusters within a
        /// Region or across multiple Regions.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or
        /// full ARN of the task definition to run in your service. If a <code>revision</code> is
        /// not specified, the latest <code>ACTIVE</code> revision is used.</p>
        /// <p>A task definition must be specified if the service is using either the
        /// <code>ECS</code> or <code>CODE_DEPLOY</code> deployment controllers.</p>
        pub fn task_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_definition = Some(input.into());
            self
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or
        /// full ARN of the task definition to run in your service. If a <code>revision</code> is
        /// not specified, the latest <code>ACTIVE</code> revision is used.</p>
        /// <p>A task definition must be specified if the service is using either the
        /// <code>ECS</code> or <code>CODE_DEPLOY</code> deployment controllers.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_definition = input;
            self
        }
        /// Appends an item to `load_balancers`.
        ///
        /// To override the contents of this collection use [`set_load_balancers`](Self::set_load_balancers).
        ///
        /// <p>A load balancer object representing the load balancers to use with your service. For
        /// more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service Load Balancing</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>If the service is using the rolling update (<code>ECS</code>) deployment controller
        /// and using either an Application Load Balancer or Network Load Balancer, you must specify one or more target group ARNs to
        /// attach to the service. The service-linked role is required for services that make use of
        /// multiple target groups. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using service-linked roles for Amazon ECS</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>If the service is using the <code>CODE_DEPLOY</code> deployment controller, the
        /// service is required to use either an Application Load Balancer or Network Load Balancer. When creating an CodeDeploy deployment
        /// group, you specify two target groups (referred to as a <code>targetGroupPair</code>).
        /// During a deployment, CodeDeploy determines which task set in your service has the status
        /// <code>PRIMARY</code> and associates one target group with it, and then associates
        /// the other target group with the replacement task set. The load balancer can also have up
        /// to two listeners: a required listener for production traffic and an optional listener
        /// that allows you perform validation tests with Lambda functions before routing production
        /// traffic to it.</p>
        /// <p>After you create a service using the <code>ECS</code> deployment controller, the load
        /// balancer name or target group ARN, container name, and container port specified in the
        /// service definition are immutable. If you are using the <code>CODE_DEPLOY</code>
        /// deployment controller, these values can be changed when updating the service.</p>
        /// <p>For Application Load Balancers and Network Load Balancers, this object must contain the load balancer target group ARN,
        /// the container name (as it appears in a container definition), and the container port to
        /// access from the load balancer. The load balancer name parameter must be omitted. When a
        /// task from this service is placed on a container instance, the container instance and
        /// port combination is registered as a target in the target group specified here.</p>
        /// <p>For Classic Load Balancers, this object must contain the load balancer name, the container name (as it
        /// appears in a container definition), and the container port to access from the load
        /// balancer. The target group ARN parameter must be omitted. When a task from this service
        /// is placed on a container instance, the container instance is registered with the load
        /// balancer specified here.</p>
        /// <p>Services with tasks that use the <code>awsvpc</code> network mode (for example, those
        /// with the Fargate launch type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers are
        /// not supported. Also, when you create any target groups for these services, you must
        /// choose <code>ip</code> as the target type, not <code>instance</code>, because tasks that
        /// use the <code>awsvpc</code> network mode are associated with an elastic network
        /// interface, not an Amazon EC2 instance.</p>
        pub fn load_balancers(mut self, input: impl Into<crate::model::LoadBalancer>) -> Self {
            let mut v = self.load_balancers.unwrap_or_default();
            v.push(input.into());
            self.load_balancers = Some(v);
            self
        }
        /// <p>A load balancer object representing the load balancers to use with your service. For
        /// more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service Load Balancing</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>If the service is using the rolling update (<code>ECS</code>) deployment controller
        /// and using either an Application Load Balancer or Network Load Balancer, you must specify one or more target group ARNs to
        /// attach to the service. The service-linked role is required for services that make use of
        /// multiple target groups. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using service-linked roles for Amazon ECS</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>If the service is using the <code>CODE_DEPLOY</code> deployment controller, the
        /// service is required to use either an Application Load Balancer or Network Load Balancer. When creating an CodeDeploy deployment
        /// group, you specify two target groups (referred to as a <code>targetGroupPair</code>).
        /// During a deployment, CodeDeploy determines which task set in your service has the status
        /// <code>PRIMARY</code> and associates one target group with it, and then associates
        /// the other target group with the replacement task set. The load balancer can also have up
        /// to two listeners: a required listener for production traffic and an optional listener
        /// that allows you perform validation tests with Lambda functions before routing production
        /// traffic to it.</p>
        /// <p>After you create a service using the <code>ECS</code> deployment controller, the load
        /// balancer name or target group ARN, container name, and container port specified in the
        /// service definition are immutable. If you are using the <code>CODE_DEPLOY</code>
        /// deployment controller, these values can be changed when updating the service.</p>
        /// <p>For Application Load Balancers and Network Load Balancers, this object must contain the load balancer target group ARN,
        /// the container name (as it appears in a container definition), and the container port to
        /// access from the load balancer. The load balancer name parameter must be omitted. When a
        /// task from this service is placed on a container instance, the container instance and
        /// port combination is registered as a target in the target group specified here.</p>
        /// <p>For Classic Load Balancers, this object must contain the load balancer name, the container name (as it
        /// appears in a container definition), and the container port to access from the load
        /// balancer. The target group ARN parameter must be omitted. When a task from this service
        /// is placed on a container instance, the container instance is registered with the load
        /// balancer specified here.</p>
        /// <p>Services with tasks that use the <code>awsvpc</code> network mode (for example, those
        /// with the Fargate launch type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers are
        /// not supported. Also, when you create any target groups for these services, you must
        /// choose <code>ip</code> as the target type, not <code>instance</code>, because tasks that
        /// use the <code>awsvpc</code> network mode are associated with an elastic network
        /// interface, not an Amazon EC2 instance.</p>
        pub fn set_load_balancers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
        ) -> Self {
            self.load_balancers = input;
            self
        }
        /// Appends an item to `service_registries`.
        ///
        /// To override the contents of this collection use [`set_service_registries`](Self::set_service_registries).
        ///
        /// <p>The details of the service discovery registry to associate with this service. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
        /// discovery</a>.</p>
        /// <note>
        /// <p>Each service may be associated with one service registry. Multiple service
        /// registries per service isn't supported.</p>
        /// </note>
        pub fn service_registries(
            mut self,
            input: impl Into<crate::model::ServiceRegistry>,
        ) -> Self {
            let mut v = self.service_registries.unwrap_or_default();
            v.push(input.into());
            self.service_registries = Some(v);
            self
        }
        /// <p>The details of the service discovery registry to associate with this service. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
        /// discovery</a>.</p>
        /// <note>
        /// <p>Each service may be associated with one service registry. Multiple service
        /// registries per service isn't supported.</p>
        /// </note>
        pub fn set_service_registries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceRegistry>>,
        ) -> Self {
            self.service_registries = input;
            self
        }
        /// <p>The number of instantiations of the specified task definition to place and keep
        /// running on your cluster.</p>
        /// <p>This is required if <code>schedulingStrategy</code> is <code>REPLICA</code> or is not
        /// specified. If <code>schedulingStrategy</code> is <code>DAEMON</code> then this is not
        /// required.</p>
        pub fn desired_count(mut self, input: i32) -> Self {
            self.desired_count = Some(input);
            self
        }
        /// <p>The number of instantiations of the specified task definition to place and keep
        /// running on your cluster.</p>
        /// <p>This is required if <code>schedulingStrategy</code> is <code>REPLICA</code> or is not
        /// specified. If <code>schedulingStrategy</code> is <code>DAEMON</code> then this is not
        /// required.</p>
        pub fn set_desired_count(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_count = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 32 ASCII characters are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 32 ASCII characters are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The infrastructure on which to run your service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS
        /// launch types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand
        /// infrastructure.</p>
        /// <note>
        /// <p>Fargate Spot infrastructure is available for use but a capacity provider
        /// strategy must be used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html">Fargate capacity providers</a> in the
        /// <i>Amazon ECS User Guide for Fargate</i>.</p>
        /// </note>
        /// <p>The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your
        /// cluster.</p>
        /// <p>The <code>EXTERNAL</code> launch type runs your tasks on your on-premise server or
        /// virtual machine (VM) capacity registered to your cluster.</p>
        /// <p>A service can use either a launch type or a capacity provider strategy. If a
        /// <code>launchType</code> is specified, the <code>capacityProviderStrategy</code>
        /// parameter must be omitted.</p>
        pub fn launch_type(mut self, input: crate::model::LaunchType) -> Self {
            self.launch_type = Some(input);
            self
        }
        /// <p>The infrastructure on which to run your service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS
        /// launch types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand
        /// infrastructure.</p>
        /// <note>
        /// <p>Fargate Spot infrastructure is available for use but a capacity provider
        /// strategy must be used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html">Fargate capacity providers</a> in the
        /// <i>Amazon ECS User Guide for Fargate</i>.</p>
        /// </note>
        /// <p>The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your
        /// cluster.</p>
        /// <p>The <code>EXTERNAL</code> launch type runs your tasks on your on-premise server or
        /// virtual machine (VM) capacity registered to your cluster.</p>
        /// <p>A service can use either a launch type or a capacity provider strategy. If a
        /// <code>launchType</code> is specified, the <code>capacityProviderStrategy</code>
        /// parameter must be omitted.</p>
        pub fn set_launch_type(
            mut self,
            input: std::option::Option<crate::model::LaunchType>,
        ) -> Self {
            self.launch_type = input;
            self
        }
        /// Appends an item to `capacity_provider_strategy`.
        ///
        /// To override the contents of this collection use [`set_capacity_provider_strategy`](Self::set_capacity_provider_strategy).
        ///
        /// <p>The capacity provider strategy to use for the service.</p>
        /// <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code>
        /// parameter must be omitted. If no <code>capacityProviderStrategy</code> or
        /// <code>launchType</code> is specified, the
        /// <code>defaultCapacityProviderStrategy</code> for the cluster is used.</p>
        /// <p>A capacity provider strategy may contain a maximum of 6 capacity providers.</p>
        pub fn capacity_provider_strategy(
            mut self,
            input: impl Into<crate::model::CapacityProviderStrategyItem>,
        ) -> Self {
            let mut v = self.capacity_provider_strategy.unwrap_or_default();
            v.push(input.into());
            self.capacity_provider_strategy = Some(v);
            self
        }
        /// <p>The capacity provider strategy to use for the service.</p>
        /// <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code>
        /// parameter must be omitted. If no <code>capacityProviderStrategy</code> or
        /// <code>launchType</code> is specified, the
        /// <code>defaultCapacityProviderStrategy</code> for the cluster is used.</p>
        /// <p>A capacity provider strategy may contain a maximum of 6 capacity providers.</p>
        pub fn set_capacity_provider_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        ) -> Self {
            self.capacity_provider_strategy = input;
            self
        }
        /// <p>The platform version that your tasks in the service are running on. A platform version
        /// is specified only for tasks using the Fargate launch type. If one isn't
        /// specified, the <code>LATEST</code> platform version is used by default. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate platform
        /// versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_version = Some(input.into());
            self
        }
        /// <p>The platform version that your tasks in the service are running on. A platform version
        /// is specified only for tasks using the Fargate launch type. If one isn't
        /// specified, the <code>LATEST</code> platform version is used by default. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate platform
        /// versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_version = input;
            self
        }
        /// <p>The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your
        /// load balancer on your behalf. This parameter is only permitted if you are using a load
        /// balancer with your service and your task definition does not use the <code>awsvpc</code>
        /// network mode. If you specify the <code>role</code> parameter, you must also specify a
        /// load balancer object with the <code>loadBalancers</code> parameter.</p>
        /// <important>
        /// <p>If your account has already created the Amazon ECS service-linked role, that role is
        /// used by default for your service unless you specify a role here. The service-linked
        /// role is required if your task definition uses the <code>awsvpc</code> network mode
        /// or if the service is configured to use service discovery, an external deployment
        /// controller, multiple target groups, or Elastic Inference accelerators in which case
        /// you should not specify a role here. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using
        /// service-linked roles for Amazon ECS</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// </important>
        /// <p>If your specified role has a path other than <code>/</code>, then you must either
        /// specify the full role ARN (this is recommended) or prefix the role name with the path.
        /// For example, if a role with the name <code>bar</code> has a path of <code>/foo/</code>
        /// then you would specify <code>/foo/bar</code> as the role name. For more information, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">Friendly names and paths</a> in the <i>IAM User Guide</i>.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your
        /// load balancer on your behalf. This parameter is only permitted if you are using a load
        /// balancer with your service and your task definition does not use the <code>awsvpc</code>
        /// network mode. If you specify the <code>role</code> parameter, you must also specify a
        /// load balancer object with the <code>loadBalancers</code> parameter.</p>
        /// <important>
        /// <p>If your account has already created the Amazon ECS service-linked role, that role is
        /// used by default for your service unless you specify a role here. The service-linked
        /// role is required if your task definition uses the <code>awsvpc</code> network mode
        /// or if the service is configured to use service discovery, an external deployment
        /// controller, multiple target groups, or Elastic Inference accelerators in which case
        /// you should not specify a role here. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using
        /// service-linked roles for Amazon ECS</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// </important>
        /// <p>If your specified role has a path other than <code>/</code>, then you must either
        /// specify the full role ARN (this is recommended) or prefix the role name with the path.
        /// For example, if a role with the name <code>bar</code> has a path of <code>/foo/</code>
        /// then you would specify <code>/foo/bar</code> as the role name. For more information, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">Friendly names and paths</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>Optional deployment parameters that control how many tasks run during the deployment
        /// and the ordering of stopping and starting tasks.</p>
        pub fn deployment_configuration(
            mut self,
            input: crate::model::DeploymentConfiguration,
        ) -> Self {
            self.deployment_configuration = Some(input);
            self
        }
        /// <p>Optional deployment parameters that control how many tasks run during the deployment
        /// and the ordering of stopping and starting tasks.</p>
        pub fn set_deployment_configuration(
            mut self,
            input: std::option::Option<crate::model::DeploymentConfiguration>,
        ) -> Self {
            self.deployment_configuration = input;
            self
        }
        /// Appends an item to `placement_constraints`.
        ///
        /// To override the contents of this collection use [`set_placement_constraints`](Self::set_placement_constraints).
        ///
        /// <p>An array of placement constraint objects to use for tasks in your service. You can
        /// specify a maximum of 10 constraints per task (this limit includes constraints in the
        /// task definition and those specified at runtime).</p>
        pub fn placement_constraints(
            mut self,
            input: impl Into<crate::model::PlacementConstraint>,
        ) -> Self {
            let mut v = self.placement_constraints.unwrap_or_default();
            v.push(input.into());
            self.placement_constraints = Some(v);
            self
        }
        /// <p>An array of placement constraint objects to use for tasks in your service. You can
        /// specify a maximum of 10 constraints per task (this limit includes constraints in the
        /// task definition and those specified at runtime).</p>
        pub fn set_placement_constraints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementConstraint>>,
        ) -> Self {
            self.placement_constraints = input;
            self
        }
        /// Appends an item to `placement_strategy`.
        ///
        /// To override the contents of this collection use [`set_placement_strategy`](Self::set_placement_strategy).
        ///
        /// <p>The placement strategy objects to use for tasks in your service. You can specify a
        /// maximum of 5 strategy rules per service.</p>
        pub fn placement_strategy(
            mut self,
            input: impl Into<crate::model::PlacementStrategy>,
        ) -> Self {
            let mut v = self.placement_strategy.unwrap_or_default();
            v.push(input.into());
            self.placement_strategy = Some(v);
            self
        }
        /// <p>The placement strategy objects to use for tasks in your service. You can specify a
        /// maximum of 5 strategy rules per service.</p>
        pub fn set_placement_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementStrategy>>,
        ) -> Self {
            self.placement_strategy = input;
            self
        }
        /// <p>The network configuration for the service. This parameter is required for task
        /// definitions that use the <code>awsvpc</code> network mode to receive their own elastic
        /// network interface, and it is not supported for other network modes. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task networking</a>
        /// in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn network_configuration(mut self, input: crate::model::NetworkConfiguration) -> Self {
            self.network_configuration = Some(input);
            self
        }
        /// <p>The network configuration for the service. This parameter is required for task
        /// definitions that use the <code>awsvpc</code> network mode to receive their own elastic
        /// network interface, and it is not supported for other network modes. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task networking</a>
        /// in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkConfiguration>,
        ) -> Self {
            self.network_configuration = input;
            self
        }
        /// <p>The period of time, in seconds, that the Amazon ECS service scheduler should ignore
        /// unhealthy Elastic Load Balancing target health checks after a task has first started. This is only used
        /// when your service is configured to use a load balancer. If your service has a load
        /// balancer defined and you don't specify a health check grace period value, the default
        /// value of <code>0</code> is used.</p>
        /// <p>If your service's tasks take a while to start and respond to Elastic Load Balancing health checks, you
        /// can specify a health check grace period of up to 2,147,483,647 seconds. During that
        /// time, the Amazon ECS service scheduler ignores health check status. This grace period can
        /// prevent the service scheduler from marking tasks as unhealthy and stopping them before
        /// they have time to come up.</p>
        pub fn health_check_grace_period_seconds(mut self, input: i32) -> Self {
            self.health_check_grace_period_seconds = Some(input);
            self
        }
        /// <p>The period of time, in seconds, that the Amazon ECS service scheduler should ignore
        /// unhealthy Elastic Load Balancing target health checks after a task has first started. This is only used
        /// when your service is configured to use a load balancer. If your service has a load
        /// balancer defined and you don't specify a health check grace period value, the default
        /// value of <code>0</code> is used.</p>
        /// <p>If your service's tasks take a while to start and respond to Elastic Load Balancing health checks, you
        /// can specify a health check grace period of up to 2,147,483,647 seconds. During that
        /// time, the Amazon ECS service scheduler ignores health check status. This grace period can
        /// prevent the service scheduler from marking tasks as unhealthy and stopping them before
        /// they have time to come up.</p>
        pub fn set_health_check_grace_period_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.health_check_grace_period_seconds = input;
            self
        }
        /// <p>The scheduling strategy to use for the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
        /// <p>There are two service scheduler strategies available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>REPLICA</code>-The replica scheduling strategy places and
        /// maintains the desired number of tasks across your cluster. By default, the
        /// service scheduler spreads tasks across Availability Zones. You can use task
        /// placement strategies and constraints to customize task placement decisions. This
        /// scheduler strategy is required if the service is using the
        /// <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller
        /// types.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one
        /// task on each active container instance that meets all of the task placement
        /// constraints that you specify in your cluster. The service scheduler also
        /// evaluates the task placement constraints for running tasks and will stop tasks
        /// that do not meet the placement constraints. When you're using this strategy, you
        /// don't need to specify a desired number of tasks, a task placement strategy, or
        /// use Service Auto Scaling policies.</p>
        /// <note>
        /// <p>Tasks using the Fargate launch type or the
        /// <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller
        /// types don't support the <code>DAEMON</code> scheduling strategy.</p>
        /// </note>
        /// </li>
        /// </ul>
        pub fn scheduling_strategy(mut self, input: crate::model::SchedulingStrategy) -> Self {
            self.scheduling_strategy = Some(input);
            self
        }
        /// <p>The scheduling strategy to use for the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
        /// <p>There are two service scheduler strategies available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>REPLICA</code>-The replica scheduling strategy places and
        /// maintains the desired number of tasks across your cluster. By default, the
        /// service scheduler spreads tasks across Availability Zones. You can use task
        /// placement strategies and constraints to customize task placement decisions. This
        /// scheduler strategy is required if the service is using the
        /// <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller
        /// types.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one
        /// task on each active container instance that meets all of the task placement
        /// constraints that you specify in your cluster. The service scheduler also
        /// evaluates the task placement constraints for running tasks and will stop tasks
        /// that do not meet the placement constraints. When you're using this strategy, you
        /// don't need to specify a desired number of tasks, a task placement strategy, or
        /// use Service Auto Scaling policies.</p>
        /// <note>
        /// <p>Tasks using the Fargate launch type or the
        /// <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller
        /// types don't support the <code>DAEMON</code> scheduling strategy.</p>
        /// </note>
        /// </li>
        /// </ul>
        pub fn set_scheduling_strategy(
            mut self,
            input: std::option::Option<crate::model::SchedulingStrategy>,
        ) -> Self {
            self.scheduling_strategy = input;
            self
        }
        /// <p>The deployment controller to use for the service. If no deployment controller is
        /// specified, the default value of <code>ECS</code> is used.</p>
        pub fn deployment_controller(mut self, input: crate::model::DeploymentController) -> Self {
            self.deployment_controller = Some(input);
            self
        }
        /// <p>The deployment controller to use for the service. If no deployment controller is
        /// specified, the default value of <code>ECS</code> is used.</p>
        pub fn set_deployment_controller(
            mut self,
            input: std::option::Option<crate::model::DeploymentController>,
        ) -> Self {
            self.deployment_controller = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the service to help you categorize and organize them.
        /// Each tag consists of a key and an optional value, both of which you define. When a
        /// service is deleted, the tags are deleted as well.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The metadata that you apply to the service to help you categorize and organize them.
        /// Each tag consists of a key and an optional value, both of which you define. When a
        /// service is deleted, the tags are deleted as well.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies whether to enable Amazon ECS managed tags for the tasks within the service. For
        /// more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS
        /// Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn enable_ecs_managed_tags(mut self, input: bool) -> Self {
            self.enable_ecs_managed_tags = Some(input);
            self
        }
        /// <p>Specifies whether to enable Amazon ECS managed tags for the tasks within the service. For
        /// more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS
        /// Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_enable_ecs_managed_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_ecs_managed_tags = input;
            self
        }
        /// <p>Specifies whether to propagate the tags from the task definition or the service to the
        /// tasks in the service. If no value is specified, the tags are not propagated. Tags can
        /// only be propagated to the tasks within the service during service creation. To add tags
        /// to a task after service creation or task creation, use the <a>TagResource</a> API
        /// action.</p>
        pub fn propagate_tags(mut self, input: crate::model::PropagateTags) -> Self {
            self.propagate_tags = Some(input);
            self
        }
        /// <p>Specifies whether to propagate the tags from the task definition or the service to the
        /// tasks in the service. If no value is specified, the tags are not propagated. Tags can
        /// only be propagated to the tasks within the service during service creation. To add tags
        /// to a task after service creation or task creation, use the <a>TagResource</a> API
        /// action.</p>
        pub fn set_propagate_tags(
            mut self,
            input: std::option::Option<crate::model::PropagateTags>,
        ) -> Self {
            self.propagate_tags = input;
            self
        }
        /// <p>Whether or not the execute command functionality is enabled for the service. If
        /// <code>true</code>, this enables execute command functionality on all containers in
        /// the service tasks.</p>
        pub fn enable_execute_command(mut self, input: bool) -> Self {
            self.enable_execute_command = Some(input);
            self
        }
        /// <p>Whether or not the execute command functionality is enabled for the service. If
        /// <code>true</code>, this enables execute command functionality on all containers in
        /// the service tasks.</p>
        pub fn set_enable_execute_command(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_execute_command = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceInput`](crate::input::CreateServiceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateServiceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateServiceInput {
                cluster: self.cluster,
                service_name: self.service_name,
                task_definition: self.task_definition,
                load_balancers: self.load_balancers,
                service_registries: self.service_registries,
                desired_count: self.desired_count,
                client_token: self.client_token,
                launch_type: self.launch_type,
                capacity_provider_strategy: self.capacity_provider_strategy,
                platform_version: self.platform_version,
                role: self.role,
                deployment_configuration: self.deployment_configuration,
                placement_constraints: self.placement_constraints,
                placement_strategy: self.placement_strategy,
                network_configuration: self.network_configuration,
                health_check_grace_period_seconds: self.health_check_grace_period_seconds,
                scheduling_strategy: self.scheduling_strategy,
                deployment_controller: self.deployment_controller,
                tags: self.tags,
                enable_ecs_managed_tags: self.enable_ecs_managed_tags.unwrap_or_default(),
                propagate_tags: self.propagate_tags,
                enable_execute_command: self.enable_execute_command.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateServiceInputOperationOutputAlias = crate::operation::CreateService;
#[doc(hidden)]
pub type CreateServiceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateServiceInput {
    /// Consumes the builder and constructs an Operation<[`CreateService`](crate::operation::CreateService)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateService,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateServiceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateServiceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateServiceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.CreateService",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_service(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateService::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateService",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateServiceInput`](crate::input::CreateServiceInput)
    pub fn builder() -> crate::input::create_service_input::Builder {
        crate::input::create_service_input::Builder::default()
    }
}

/// See [`CreateTaskSetInput`](crate::input::CreateTaskSetInput)
pub mod create_task_set_input {
    /// A builder for [`CreateTaskSetInput`](crate::input::CreateTaskSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) external_id: std::option::Option<std::string::String>,
        pub(crate) task_definition: std::option::Option<std::string::String>,
        pub(crate) network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
        pub(crate) load_balancers: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
        pub(crate) service_registries:
            std::option::Option<std::vec::Vec<crate::model::ServiceRegistry>>,
        pub(crate) launch_type: std::option::Option<crate::model::LaunchType>,
        pub(crate) capacity_provider_strategy:
            std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        pub(crate) platform_version: std::option::Option<std::string::String>,
        pub(crate) scale: std::option::Option<crate::model::Scale>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the service to create the task set in.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service to create the task set in.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the
        /// task set in.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the
        /// task set in.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>An optional non-unique tag that identifies this task set in external systems. If the
        /// task set is associated with a service discovery registry, the tasks in this task set
        /// will have the <code>ECS_TASK_SET_EXTERNAL_ID</code> Cloud Map attribute set to the provided
        /// value.</p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p>An optional non-unique tag that identifies this task set in external systems. If the
        /// task set is associated with a service discovery registry, the tasks in this task set
        /// will have the <code>ECS_TASK_SET_EXTERNAL_ID</code> Cloud Map attribute set to the provided
        /// value.</p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// <p>The task definition for the tasks in the task set to use.</p>
        pub fn task_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_definition = Some(input.into());
            self
        }
        /// <p>The task definition for the tasks in the task set to use.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_definition = input;
            self
        }
        /// <p>An object representing the network configuration for a task set.</p>
        pub fn network_configuration(mut self, input: crate::model::NetworkConfiguration) -> Self {
            self.network_configuration = Some(input);
            self
        }
        /// <p>An object representing the network configuration for a task set.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkConfiguration>,
        ) -> Self {
            self.network_configuration = input;
            self
        }
        /// Appends an item to `load_balancers`.
        ///
        /// To override the contents of this collection use [`set_load_balancers`](Self::set_load_balancers).
        ///
        /// <p>A load balancer object representing the load balancer to use with the task set. The
        /// supported load balancer types are either an Application Load Balancer or a Network Load Balancer.</p>
        pub fn load_balancers(mut self, input: impl Into<crate::model::LoadBalancer>) -> Self {
            let mut v = self.load_balancers.unwrap_or_default();
            v.push(input.into());
            self.load_balancers = Some(v);
            self
        }
        /// <p>A load balancer object representing the load balancer to use with the task set. The
        /// supported load balancer types are either an Application Load Balancer or a Network Load Balancer.</p>
        pub fn set_load_balancers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
        ) -> Self {
            self.load_balancers = input;
            self
        }
        /// Appends an item to `service_registries`.
        ///
        /// To override the contents of this collection use [`set_service_registries`](Self::set_service_registries).
        ///
        /// <p>The details of the service discovery registries to assign to this task set. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
        /// Discovery</a>.</p>
        pub fn service_registries(
            mut self,
            input: impl Into<crate::model::ServiceRegistry>,
        ) -> Self {
            let mut v = self.service_registries.unwrap_or_default();
            v.push(input.into());
            self.service_registries = Some(v);
            self
        }
        /// <p>The details of the service discovery registries to assign to this task set. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
        /// Discovery</a>.</p>
        pub fn set_service_registries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceRegistry>>,
        ) -> Self {
            self.service_registries = input;
            self
        }
        /// <p>The launch type that new tasks in the task set will use. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code>
        /// parameter must be omitted.</p>
        pub fn launch_type(mut self, input: crate::model::LaunchType) -> Self {
            self.launch_type = Some(input);
            self
        }
        /// <p>The launch type that new tasks in the task set will use. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code>
        /// parameter must be omitted.</p>
        pub fn set_launch_type(
            mut self,
            input: std::option::Option<crate::model::LaunchType>,
        ) -> Self {
            self.launch_type = input;
            self
        }
        /// Appends an item to `capacity_provider_strategy`.
        ///
        /// To override the contents of this collection use [`set_capacity_provider_strategy`](Self::set_capacity_provider_strategy).
        ///
        /// <p>The capacity provider strategy to use for the task set.</p>
        /// <p>A capacity provider strategy consists of one or more capacity providers along with the
        /// <code>base</code> and <code>weight</code> to assign to them. A capacity provider
        /// must be associated with the cluster to be used in a capacity provider strategy. The
        /// <a>PutClusterCapacityProviders</a> API is used to associate a capacity
        /// provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or
        /// <code>UPDATING</code> status can be used.</p>
        /// <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code>
        /// parameter must be omitted. If no <code>capacityProviderStrategy</code> or
        /// <code>launchType</code> is specified, the
        /// <code>defaultCapacityProviderStrategy</code> for the cluster is used.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity
        /// provider must already be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
        /// <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are
        /// available to all accounts and only need to be associated with a cluster to be
        /// used.</p>
        /// <p>The <a>PutClusterCapacityProviders</a> API operation is used to update the
        /// list of available capacity providers for a cluster after the cluster is created.</p>
        pub fn capacity_provider_strategy(
            mut self,
            input: impl Into<crate::model::CapacityProviderStrategyItem>,
        ) -> Self {
            let mut v = self.capacity_provider_strategy.unwrap_or_default();
            v.push(input.into());
            self.capacity_provider_strategy = Some(v);
            self
        }
        /// <p>The capacity provider strategy to use for the task set.</p>
        /// <p>A capacity provider strategy consists of one or more capacity providers along with the
        /// <code>base</code> and <code>weight</code> to assign to them. A capacity provider
        /// must be associated with the cluster to be used in a capacity provider strategy. The
        /// <a>PutClusterCapacityProviders</a> API is used to associate a capacity
        /// provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or
        /// <code>UPDATING</code> status can be used.</p>
        /// <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code>
        /// parameter must be omitted. If no <code>capacityProviderStrategy</code> or
        /// <code>launchType</code> is specified, the
        /// <code>defaultCapacityProviderStrategy</code> for the cluster is used.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity
        /// provider must already be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
        /// <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are
        /// available to all accounts and only need to be associated with a cluster to be
        /// used.</p>
        /// <p>The <a>PutClusterCapacityProviders</a> API operation is used to update the
        /// list of available capacity providers for a cluster after the cluster is created.</p>
        pub fn set_capacity_provider_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        ) -> Self {
            self.capacity_provider_strategy = input;
            self
        }
        /// <p>The platform version that the tasks in the task set should use. A platform version is
        /// specified only for tasks using the Fargate launch type. If one isn't
        /// specified, the <code>LATEST</code> platform version is used by default.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_version = Some(input.into());
            self
        }
        /// <p>The platform version that the tasks in the task set should use. A platform version is
        /// specified only for tasks using the Fargate launch type. If one isn't
        /// specified, the <code>LATEST</code> platform version is used by default.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_version = input;
            self
        }
        /// <p>A floating-point percentage of the desired number of tasks to place and keep running
        /// in the task set.</p>
        pub fn scale(mut self, input: crate::model::Scale) -> Self {
            self.scale = Some(input);
            self
        }
        /// <p>A floating-point percentage of the desired number of tasks to place and keep running
        /// in the task set.</p>
        pub fn set_scale(mut self, input: std::option::Option<crate::model::Scale>) -> Self {
            self.scale = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 32 ASCII characters are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. Up to 32 ASCII characters are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the task set to help you categorize and organize them.
        /// Each tag consists of a key and an optional value, both of which you define. When a
        /// service is deleted, the tags are deleted as well.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The metadata that you apply to the task set to help you categorize and organize them.
        /// Each tag consists of a key and an optional value, both of which you define. When a
        /// service is deleted, the tags are deleted as well.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTaskSetInput`](crate::input::CreateTaskSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTaskSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTaskSetInput {
                service: self.service,
                cluster: self.cluster,
                external_id: self.external_id,
                task_definition: self.task_definition,
                network_configuration: self.network_configuration,
                load_balancers: self.load_balancers,
                service_registries: self.service_registries,
                launch_type: self.launch_type,
                capacity_provider_strategy: self.capacity_provider_strategy,
                platform_version: self.platform_version,
                scale: self.scale,
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTaskSetInputOperationOutputAlias = crate::operation::CreateTaskSet;
#[doc(hidden)]
pub type CreateTaskSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTaskSetInput {
    /// Consumes the builder and constructs an Operation<[`CreateTaskSet`](crate::operation::CreateTaskSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTaskSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTaskSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTaskSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTaskSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.CreateTaskSet",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_task_set(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTaskSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTaskSet",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTaskSetInput`](crate::input::CreateTaskSetInput)
    pub fn builder() -> crate::input::create_task_set_input::Builder {
        crate::input::create_task_set_input::Builder::default()
    }
}

/// See [`DeleteAccountSettingInput`](crate::input::DeleteAccountSettingInput)
pub mod delete_account_setting_input {
    /// A builder for [`DeleteAccountSettingInput`](crate::input::DeleteAccountSettingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SettingName>,
        pub(crate) principal_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource name for which to disable the account setting. If
        /// <code>serviceLongArnFormat</code> is specified, the ARN for your Amazon ECS services is
        /// affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID for
        /// your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is
        /// specified, the ARN and resource ID for your Amazon ECS container instances is affected. If
        /// <code>awsvpcTrunking</code> is specified, the ENI limit for your Amazon ECS container
        /// instances is affected.</p>
        pub fn name(mut self, input: crate::model::SettingName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The resource name for which to disable the account setting. If
        /// <code>serviceLongArnFormat</code> is specified, the ARN for your Amazon ECS services is
        /// affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID for
        /// your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is
        /// specified, the ARN and resource ID for your Amazon ECS container instances is affected. If
        /// <code>awsvpcTrunking</code> is specified, the ENI limit for your Amazon ECS container
        /// instances is affected.</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::SettingName>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the principal, which can be an IAM user, IAM role, or the root user. If you
        /// specify the root user, it disables the account setting for all IAM users, IAM roles, and
        /// the root user of the account unless an IAM user or role explicitly overrides these
        /// settings. If this field is omitted, the setting is changed only for the authenticated
        /// user.</p>
        pub fn principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the principal, which can be an IAM user, IAM role, or the root user. If you
        /// specify the root user, it disables the account setting for all IAM users, IAM roles, and
        /// the root user of the account unless an IAM user or role explicitly overrides these
        /// settings. If this field is omitted, the setting is changed only for the authenticated
        /// user.</p>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.principal_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAccountSettingInput`](crate::input::DeleteAccountSettingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAccountSettingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAccountSettingInput {
                name: self.name,
                principal_arn: self.principal_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAccountSettingInputOperationOutputAlias = crate::operation::DeleteAccountSetting;
#[doc(hidden)]
pub type DeleteAccountSettingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAccountSettingInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAccountSetting`](crate::operation::DeleteAccountSetting)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAccountSetting,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAccountSettingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAccountSettingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAccountSettingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.DeleteAccountSetting",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_account_setting(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAccountSetting::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAccountSetting",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAccountSettingInput`](crate::input::DeleteAccountSettingInput)
    pub fn builder() -> crate::input::delete_account_setting_input::Builder {
        crate::input::delete_account_setting_input::Builder::default()
    }
}

/// See [`DeleteAttributesInput`](crate::input::DeleteAttributesInput)
pub mod delete_attributes_input {
    /// A builder for [`DeleteAttributesInput`](crate::input::DeleteAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that contains the resource to delete
        /// attributes. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that contains the resource to delete
        /// attributes. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes to delete from your resource. You can specify up to 10 attributes per
        /// request. For custom attributes, specify the attribute name and target ID, but do not
        /// specify the value. If you specify the target ID using the short form, you must also
        /// specify the target type.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::Attribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>The attributes to delete from your resource. You can specify up to 10 attributes per
        /// request. For custom attributes, specify the attribute name and target ID, but do not
        /// specify the value. If you specify the target ID using the short form, you must also
        /// specify the target type.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAttributesInput`](crate::input::DeleteAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAttributesInput {
                cluster: self.cluster,
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAttributesInputOperationOutputAlias = crate::operation::DeleteAttributes;
#[doc(hidden)]
pub type DeleteAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAttributesInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAttributes`](crate::operation::DeleteAttributes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.DeleteAttributes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_attributes(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAttributes",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAttributesInput`](crate::input::DeleteAttributesInput)
    pub fn builder() -> crate::input::delete_attributes_input::Builder {
        crate::input::delete_attributes_input::Builder::default()
    }
}

/// See [`DeleteCapacityProviderInput`](crate::input::DeleteCapacityProviderInput)
pub mod delete_capacity_provider_input {
    /// A builder for [`DeleteCapacityProviderInput`](crate::input::DeleteCapacityProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity_provider: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the capacity provider to delete.</p>
        pub fn capacity_provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.capacity_provider = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the capacity provider to delete.</p>
        pub fn set_capacity_provider(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capacity_provider = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCapacityProviderInput`](crate::input::DeleteCapacityProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCapacityProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCapacityProviderInput {
                capacity_provider: self.capacity_provider,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCapacityProviderInputOperationOutputAlias = crate::operation::DeleteCapacityProvider;
#[doc(hidden)]
pub type DeleteCapacityProviderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteCapacityProviderInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCapacityProvider`](crate::operation::DeleteCapacityProvider)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCapacityProvider,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCapacityProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCapacityProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCapacityProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.DeleteCapacityProvider",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_capacity_provider(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCapacityProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCapacityProvider",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCapacityProviderInput`](crate::input::DeleteCapacityProviderInput)
    pub fn builder() -> crate::input::delete_capacity_provider_input::Builder {
        crate::input::delete_capacity_provider_input::Builder::default()
    }
}

/// See [`DeleteClusterInput`](crate::input::DeleteClusterInput)
pub mod delete_cluster_input {
    /// A builder for [`DeleteClusterInput`](crate::input::DeleteClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to delete.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to delete.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteClusterInput`](crate::input::DeleteClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteClusterInput {
                cluster: self.cluster,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteClusterInputOperationOutputAlias = crate::operation::DeleteCluster;
#[doc(hidden)]
pub type DeleteClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteClusterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCluster`](crate::operation::DeleteCluster)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.DeleteCluster",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_cluster(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCluster",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteClusterInput`](crate::input::DeleteClusterInput)
    pub fn builder() -> crate::input::delete_cluster_input::Builder {
        crate::input::delete_cluster_input::Builder::default()
    }
}

/// See [`DeleteServiceInput`](crate::input::DeleteServiceInput)
pub mod delete_service_input {
    /// A builder for [`DeleteServiceInput`](crate::input::DeleteServiceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) force: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to delete.
        /// If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to delete.
        /// If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>The name of the service to delete.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p>The name of the service to delete.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// <p>If <code>true</code>, allows you to delete a service even if it has not been scaled
        /// down to zero tasks. It is only necessary to use this if the service is using the
        /// <code>REPLICA</code> scheduling strategy.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p>If <code>true</code>, allows you to delete a service even if it has not been scaled
        /// down to zero tasks. It is only necessary to use this if the service is using the
        /// <code>REPLICA</code> scheduling strategy.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteServiceInput`](crate::input::DeleteServiceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteServiceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteServiceInput {
                cluster: self.cluster,
                service: self.service,
                force: self.force,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteServiceInputOperationOutputAlias = crate::operation::DeleteService;
#[doc(hidden)]
pub type DeleteServiceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteServiceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteService`](crate::operation::DeleteService)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteService,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteServiceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteServiceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteServiceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.DeleteService",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_service(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteService::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteService",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteServiceInput`](crate::input::DeleteServiceInput)
    pub fn builder() -> crate::input::delete_service_input::Builder {
        crate::input::delete_service_input::Builder::default()
    }
}

/// See [`DeleteTaskSetInput`](crate::input::DeleteTaskSetInput)
pub mod delete_task_set_input {
    /// A builder for [`DeleteTaskSetInput`](crate::input::DeleteTaskSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) task_set: std::option::Option<std::string::String>,
        pub(crate) force: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task
        /// set exists in to delete.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task
        /// set exists in to delete.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service that hosts the task set to
        /// delete.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service that hosts the task set to
        /// delete.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// <p>The task set ID or full Amazon Resource Name (ARN) of the task set to delete.</p>
        pub fn task_set(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_set = Some(input.into());
            self
        }
        /// <p>The task set ID or full Amazon Resource Name (ARN) of the task set to delete.</p>
        pub fn set_task_set(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_set = input;
            self
        }
        /// <p>If <code>true</code>, this allows you to delete a task set even if it hasn't been
        /// scaled down to zero.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p>If <code>true</code>, this allows you to delete a task set even if it hasn't been
        /// scaled down to zero.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTaskSetInput`](crate::input::DeleteTaskSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTaskSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTaskSetInput {
                cluster: self.cluster,
                service: self.service,
                task_set: self.task_set,
                force: self.force,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTaskSetInputOperationOutputAlias = crate::operation::DeleteTaskSet;
#[doc(hidden)]
pub type DeleteTaskSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTaskSetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTaskSet`](crate::operation::DeleteTaskSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTaskSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTaskSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTaskSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTaskSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.DeleteTaskSet",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_task_set(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTaskSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTaskSet",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTaskSetInput`](crate::input::DeleteTaskSetInput)
    pub fn builder() -> crate::input::delete_task_set_input::Builder {
        crate::input::delete_task_set_input::Builder::default()
    }
}

/// See [`DeregisterContainerInstanceInput`](crate::input::DeregisterContainerInstanceInput)
pub mod deregister_container_instance_input {
    /// A builder for [`DeregisterContainerInstanceInput`](crate::input::DeregisterContainerInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) container_instance: std::option::Option<std::string::String>,
        pub(crate) force: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instance to
        /// deregister. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instance to
        /// deregister. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>The container instance ID or full ARN of the container instance to deregister.
        /// The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the container instance, the Amazon Web Services account ID of the container instance owner, the <code>container-instance</code> namespace, and then the container instance ID. For example, <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.</p>
        pub fn container_instance(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_instance = Some(input.into());
            self
        }
        /// <p>The container instance ID or full ARN of the container instance to deregister.
        /// The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the container instance, the Amazon Web Services account ID of the container instance owner, the <code>container-instance</code> namespace, and then the container instance ID. For example, <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.</p>
        pub fn set_container_instance(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_instance = input;
            self
        }
        /// <p>Forces the deregistration of the container instance. If you have tasks running on the
        /// container instance when you deregister it with the <code>force</code> option, these
        /// tasks remain running until you terminate the instance or the tasks stop through some
        /// other means, but they are orphaned (no longer monitored or accounted for by Amazon ECS). If
        /// an orphaned task on your container instance is part of an Amazon ECS service, then the
        /// service scheduler starts another copy of that task, on a different container instance if
        /// possible. </p>
        /// <p>Any containers in orphaned service tasks that are registered with a Classic Load Balancer or an Application Load Balancer
        /// target group are deregistered. They begin connection draining according to the settings
        /// on the load balancer or target group.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p>Forces the deregistration of the container instance. If you have tasks running on the
        /// container instance when you deregister it with the <code>force</code> option, these
        /// tasks remain running until you terminate the instance or the tasks stop through some
        /// other means, but they are orphaned (no longer monitored or accounted for by Amazon ECS). If
        /// an orphaned task on your container instance is part of an Amazon ECS service, then the
        /// service scheduler starts another copy of that task, on a different container instance if
        /// possible. </p>
        /// <p>Any containers in orphaned service tasks that are registered with a Classic Load Balancer or an Application Load Balancer
        /// target group are deregistered. They begin connection draining according to the settings
        /// on the load balancer or target group.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterContainerInstanceInput`](crate::input::DeregisterContainerInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterContainerInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterContainerInstanceInput {
                cluster: self.cluster,
                container_instance: self.container_instance,
                force: self.force,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterContainerInstanceInputOperationOutputAlias =
    crate::operation::DeregisterContainerInstance;
#[doc(hidden)]
pub type DeregisterContainerInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeregisterContainerInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterContainerInstance`](crate::operation::DeregisterContainerInstance)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterContainerInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterContainerInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterContainerInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterContainerInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.DeregisterContainerInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_container_instance(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterContainerInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterContainerInstance",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterContainerInstanceInput`](crate::input::DeregisterContainerInstanceInput)
    pub fn builder() -> crate::input::deregister_container_instance_input::Builder {
        crate::input::deregister_container_instance_input::Builder::default()
    }
}

/// See [`DeregisterTaskDefinitionInput`](crate::input::DeregisterTaskDefinitionInput)
pub mod deregister_task_definition_input {
    /// A builder for [`DeregisterTaskDefinitionInput`](crate::input::DeregisterTaskDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_definition: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or
        /// full Amazon Resource Name (ARN) of the task definition to deregister. You must specify a
        /// <code>revision</code>.</p>
        pub fn task_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_definition = Some(input.into());
            self
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or
        /// full Amazon Resource Name (ARN) of the task definition to deregister. You must specify a
        /// <code>revision</code>.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterTaskDefinitionInput`](crate::input::DeregisterTaskDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterTaskDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterTaskDefinitionInput {
                task_definition: self.task_definition,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterTaskDefinitionInputOperationOutputAlias =
    crate::operation::DeregisterTaskDefinition;
#[doc(hidden)]
pub type DeregisterTaskDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeregisterTaskDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterTaskDefinition`](crate::operation::DeregisterTaskDefinition)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterTaskDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterTaskDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterTaskDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterTaskDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.DeregisterTaskDefinition",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_task_definition(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterTaskDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterTaskDefinition",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterTaskDefinitionInput`](crate::input::DeregisterTaskDefinitionInput)
    pub fn builder() -> crate::input::deregister_task_definition_input::Builder {
        crate::input::deregister_task_definition_input::Builder::default()
    }
}

/// See [`DescribeCapacityProvidersInput`](crate::input::DescribeCapacityProvidersInput)
pub mod describe_capacity_providers_input {
    /// A builder for [`DescribeCapacityProvidersInput`](crate::input::DescribeCapacityProvidersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity_providers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) include: std::option::Option<std::vec::Vec<crate::model::CapacityProviderField>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `capacity_providers`.
        ///
        /// To override the contents of this collection use [`set_capacity_providers`](Self::set_capacity_providers).
        ///
        /// <p>The short name or full Amazon Resource Name (ARN) of one or more capacity providers. Up to
        /// <code>100</code> capacity providers can be described in an action.</p>
        pub fn capacity_providers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.capacity_providers.unwrap_or_default();
            v.push(input.into());
            self.capacity_providers = Some(v);
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of one or more capacity providers. Up to
        /// <code>100</code> capacity providers can be described in an action.</p>
        pub fn set_capacity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.capacity_providers = input;
            self
        }
        /// Appends an item to `include`.
        ///
        /// To override the contents of this collection use [`set_include`](Self::set_include).
        ///
        /// <p>Specifies whether or not you want to see the resource tags for the capacity provider.
        /// If <code>TAGS</code> is specified, the tags are included in the response. If this field
        /// is omitted, tags are not included in the response.</p>
        pub fn include(mut self, input: impl Into<crate::model::CapacityProviderField>) -> Self {
            let mut v = self.include.unwrap_or_default();
            v.push(input.into());
            self.include = Some(v);
            self
        }
        /// <p>Specifies whether or not you want to see the resource tags for the capacity provider.
        /// If <code>TAGS</code> is specified, the tags are included in the response. If this field
        /// is omitted, tags are not included in the response.</p>
        pub fn set_include(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderField>>,
        ) -> Self {
            self.include = input;
            self
        }
        /// <p>The maximum number of account setting results returned by
        /// <code>DescribeCapacityProviders</code> in paginated output. When this parameter is
        /// used, <code>DescribeCapacityProviders</code> only returns <code>maxResults</code>
        /// results in a single page along with a <code>nextToken</code> response element. The
        /// remaining results of the initial request can be seen by sending another
        /// <code>DescribeCapacityProviders</code> request with the returned
        /// <code>nextToken</code> value. This value can be between
        /// 1 and 10. If this
        /// parameter is not used, then <code>DescribeCapacityProviders</code> returns up to
        /// 10 results and a <code>nextToken</code> value
        /// if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of account setting results returned by
        /// <code>DescribeCapacityProviders</code> in paginated output. When this parameter is
        /// used, <code>DescribeCapacityProviders</code> only returns <code>maxResults</code>
        /// results in a single page along with a <code>nextToken</code> response element. The
        /// remaining results of the initial request can be seen by sending another
        /// <code>DescribeCapacityProviders</code> request with the returned
        /// <code>nextToken</code> value. This value can be between
        /// 1 and 10. If this
        /// parameter is not used, then <code>DescribeCapacityProviders</code> returns up to
        /// 10 results and a <code>nextToken</code> value
        /// if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeCapacityProviders</code> request where <code>maxResults</code> was
        /// used and the results exceeded the value of that parameter. Pagination continues from the
        /// end of the previous results that returned the <code>nextToken</code> value.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeCapacityProviders</code> request where <code>maxResults</code> was
        /// used and the results exceeded the value of that parameter. Pagination continues from the
        /// end of the previous results that returned the <code>nextToken</code> value.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCapacityProvidersInput`](crate::input::DescribeCapacityProvidersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCapacityProvidersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCapacityProvidersInput {
                capacity_providers: self.capacity_providers,
                include: self.include,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCapacityProvidersInputOperationOutputAlias =
    crate::operation::DescribeCapacityProviders;
#[doc(hidden)]
pub type DescribeCapacityProvidersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCapacityProvidersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCapacityProviders`](crate::operation::DescribeCapacityProviders)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCapacityProviders,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCapacityProvidersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCapacityProvidersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCapacityProvidersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.DescribeCapacityProviders",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_capacity_providers(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCapacityProviders::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCapacityProviders",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCapacityProvidersInput`](crate::input::DescribeCapacityProvidersInput)
    pub fn builder() -> crate::input::describe_capacity_providers_input::Builder {
        crate::input::describe_capacity_providers_input::Builder::default()
    }
}

/// See [`DescribeClustersInput`](crate::input::DescribeClustersInput)
pub mod describe_clusters_input {
    /// A builder for [`DescribeClustersInput`](crate::input::DescribeClustersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) clusters: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) include: std::option::Option<std::vec::Vec<crate::model::ClusterField>>,
    }
    impl Builder {
        /// Appends an item to `clusters`.
        ///
        /// To override the contents of this collection use [`set_clusters`](Self::set_clusters).
        ///
        /// <p>A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries.
        /// If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn clusters(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.clusters.unwrap_or_default();
            v.push(input.into());
            self.clusters = Some(v);
            self
        }
        /// <p>A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries.
        /// If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_clusters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.clusters = input;
            self
        }
        /// Appends an item to `include`.
        ///
        /// To override the contents of this collection use [`set_include`](Self::set_include).
        ///
        /// <p>Whether to include additional information about the clusters in the response. If this
        /// field is omitted, this information isn't included.</p>
        /// <p>If <code>ATTACHMENTS</code> is specified, the attachments for the container instances
        /// or tasks within the cluster are included.</p>
        /// <p>If <code>SETTINGS</code> is specified, the settings for the cluster are
        /// included.</p>
        /// <p>If <code>CONFIGURATIONS</code> is specified, the configuration for the cluster is
        /// included.</p>
        /// <p>If <code>STATISTICS</code> is specified, the task and service count is included,
        /// separated by launch type.</p>
        /// <p>If <code>TAGS</code> is specified, the metadata tags associated with the cluster are
        /// included.</p>
        pub fn include(mut self, input: impl Into<crate::model::ClusterField>) -> Self {
            let mut v = self.include.unwrap_or_default();
            v.push(input.into());
            self.include = Some(v);
            self
        }
        /// <p>Whether to include additional information about the clusters in the response. If this
        /// field is omitted, this information isn't included.</p>
        /// <p>If <code>ATTACHMENTS</code> is specified, the attachments for the container instances
        /// or tasks within the cluster are included.</p>
        /// <p>If <code>SETTINGS</code> is specified, the settings for the cluster are
        /// included.</p>
        /// <p>If <code>CONFIGURATIONS</code> is specified, the configuration for the cluster is
        /// included.</p>
        /// <p>If <code>STATISTICS</code> is specified, the task and service count is included,
        /// separated by launch type.</p>
        /// <p>If <code>TAGS</code> is specified, the metadata tags associated with the cluster are
        /// included.</p>
        pub fn set_include(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterField>>,
        ) -> Self {
            self.include = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClustersInput`](crate::input::DescribeClustersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeClustersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeClustersInput {
                clusters: self.clusters,
                include: self.include,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeClustersInputOperationOutputAlias = crate::operation::DescribeClusters;
#[doc(hidden)]
pub type DescribeClustersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeClustersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeClusters`](crate::operation::DescribeClusters)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeClusters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeClustersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeClustersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeClustersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.DescribeClusters",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_clusters(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeClusters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeClusters",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeClustersInput`](crate::input::DescribeClustersInput)
    pub fn builder() -> crate::input::describe_clusters_input::Builder {
        crate::input::describe_clusters_input::Builder::default()
    }
}

/// See [`DescribeContainerInstancesInput`](crate::input::DescribeContainerInstancesInput)
pub mod describe_container_instances_input {
    /// A builder for [`DescribeContainerInstancesInput`](crate::input::DescribeContainerInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) container_instances: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) include:
            std::option::Option<std::vec::Vec<crate::model::ContainerInstanceField>>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to
        /// describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the container instance
        /// or container instances you are describing were launched in any cluster other than the
        /// default cluster.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to
        /// describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the container instance
        /// or container instances you are describing were launched in any cluster other than the
        /// default cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// Appends an item to `container_instances`.
        ///
        /// To override the contents of this collection use [`set_container_instances`](Self::set_container_instances).
        ///
        /// <p>A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.</p>
        pub fn container_instances(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.container_instances.unwrap_or_default();
            v.push(input.into());
            self.container_instances = Some(v);
            self
        }
        /// <p>A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.</p>
        pub fn set_container_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.container_instances = input;
            self
        }
        /// Appends an item to `include`.
        ///
        /// To override the contents of this collection use [`set_include`](Self::set_include).
        ///
        /// <p>Specifies whether you want to see the resource tags for the container instance. If
        /// <code>TAGS</code> is specified, the tags are included in the response. If this field
        /// is omitted, tags are not included in the response.</p>
        pub fn include(mut self, input: impl Into<crate::model::ContainerInstanceField>) -> Self {
            let mut v = self.include.unwrap_or_default();
            v.push(input.into());
            self.include = Some(v);
            self
        }
        /// <p>Specifies whether you want to see the resource tags for the container instance. If
        /// <code>TAGS</code> is specified, the tags are included in the response. If this field
        /// is omitted, tags are not included in the response.</p>
        pub fn set_include(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContainerInstanceField>>,
        ) -> Self {
            self.include = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeContainerInstancesInput`](crate::input::DescribeContainerInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeContainerInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeContainerInstancesInput {
                cluster: self.cluster,
                container_instances: self.container_instances,
                include: self.include,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeContainerInstancesInputOperationOutputAlias =
    crate::operation::DescribeContainerInstances;
#[doc(hidden)]
pub type DescribeContainerInstancesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeContainerInstancesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeContainerInstances`](crate::operation::DescribeContainerInstances)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeContainerInstances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeContainerInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeContainerInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeContainerInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.DescribeContainerInstances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_container_instances(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeContainerInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeContainerInstances",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeContainerInstancesInput`](crate::input::DescribeContainerInstancesInput)
    pub fn builder() -> crate::input::describe_container_instances_input::Builder {
        crate::input::describe_container_instances_input::Builder::default()
    }
}

/// See [`DescribeServicesInput`](crate::input::DescribeServicesInput)
pub mod describe_services_input {
    /// A builder for [`DescribeServicesInput`](crate::input::DescribeServicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) services: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) include: std::option::Option<std::vec::Vec<crate::model::ServiceField>>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN)the cluster that hosts the service to describe.
        /// If you do not specify a cluster, the default cluster is assumed. This parameter is required if the service or services you are
        /// describing were launched in any cluster other than the default cluster.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN)the cluster that hosts the service to describe.
        /// If you do not specify a cluster, the default cluster is assumed. This parameter is required if the service or services you are
        /// describing were launched in any cluster other than the default cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// <p>A list of services to describe. You may specify up to 10 services to describe in a
        /// single operation.</p>
        pub fn services(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input.into());
            self.services = Some(v);
            self
        }
        /// <p>A list of services to describe. You may specify up to 10 services to describe in a
        /// single operation.</p>
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// Appends an item to `include`.
        ///
        /// To override the contents of this collection use [`set_include`](Self::set_include).
        ///
        /// <p>Specifies whether you want to see the resource tags for the service. If
        /// <code>TAGS</code> is specified, the tags are included in the response. If this field
        /// is omitted, tags are not included in the response.</p>
        pub fn include(mut self, input: impl Into<crate::model::ServiceField>) -> Self {
            let mut v = self.include.unwrap_or_default();
            v.push(input.into());
            self.include = Some(v);
            self
        }
        /// <p>Specifies whether you want to see the resource tags for the service. If
        /// <code>TAGS</code> is specified, the tags are included in the response. If this field
        /// is omitted, tags are not included in the response.</p>
        pub fn set_include(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceField>>,
        ) -> Self {
            self.include = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeServicesInput`](crate::input::DescribeServicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeServicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeServicesInput {
                cluster: self.cluster,
                services: self.services,
                include: self.include,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeServicesInputOperationOutputAlias = crate::operation::DescribeServices;
#[doc(hidden)]
pub type DescribeServicesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeServicesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeServices`](crate::operation::DescribeServices)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeServices,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeServicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeServicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeServicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.DescribeServices",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_services(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeServices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeServices",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeServicesInput`](crate::input::DescribeServicesInput)
    pub fn builder() -> crate::input::describe_services_input::Builder {
        crate::input::describe_services_input::Builder::default()
    }
}

/// See [`DescribeTaskDefinitionInput`](crate::input::DescribeTaskDefinitionInput)
pub mod describe_task_definition_input {
    /// A builder for [`DescribeTaskDefinitionInput`](crate::input::DescribeTaskDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_definition: std::option::Option<std::string::String>,
        pub(crate) include: std::option::Option<std::vec::Vec<crate::model::TaskDefinitionField>>,
    }
    impl Builder {
        /// <p>The <code>family</code> for the latest <code>ACTIVE</code> revision,
        /// <code>family</code> and <code>revision</code> (<code>family:revision</code>) for a
        /// specific revision in the family, or full Amazon Resource Name (ARN) of the task definition to
        /// describe.</p>
        pub fn task_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_definition = Some(input.into());
            self
        }
        /// <p>The <code>family</code> for the latest <code>ACTIVE</code> revision,
        /// <code>family</code> and <code>revision</code> (<code>family:revision</code>) for a
        /// specific revision in the family, or full Amazon Resource Name (ARN) of the task definition to
        /// describe.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_definition = input;
            self
        }
        /// Appends an item to `include`.
        ///
        /// To override the contents of this collection use [`set_include`](Self::set_include).
        ///
        /// <p>Specifies whether to see the resource tags for the task definition. If
        /// <code>TAGS</code> is specified, the tags are included in the response. If this field
        /// is omitted, tags are not included in the response.</p>
        pub fn include(mut self, input: impl Into<crate::model::TaskDefinitionField>) -> Self {
            let mut v = self.include.unwrap_or_default();
            v.push(input.into());
            self.include = Some(v);
            self
        }
        /// <p>Specifies whether to see the resource tags for the task definition. If
        /// <code>TAGS</code> is specified, the tags are included in the response. If this field
        /// is omitted, tags are not included in the response.</p>
        pub fn set_include(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TaskDefinitionField>>,
        ) -> Self {
            self.include = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTaskDefinitionInput`](crate::input::DescribeTaskDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTaskDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTaskDefinitionInput {
                task_definition: self.task_definition,
                include: self.include,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTaskDefinitionInputOperationOutputAlias = crate::operation::DescribeTaskDefinition;
#[doc(hidden)]
pub type DescribeTaskDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTaskDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTaskDefinition`](crate::operation::DescribeTaskDefinition)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTaskDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTaskDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTaskDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTaskDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.DescribeTaskDefinition",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_task_definition(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTaskDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTaskDefinition",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTaskDefinitionInput`](crate::input::DescribeTaskDefinitionInput)
    pub fn builder() -> crate::input::describe_task_definition_input::Builder {
        crate::input::describe_task_definition_input::Builder::default()
    }
}

/// See [`DescribeTasksInput`](crate::input::DescribeTasksInput)
pub mod describe_tasks_input {
    /// A builder for [`DescribeTasksInput`](crate::input::DescribeTasksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) tasks: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) include: std::option::Option<std::vec::Vec<crate::model::TaskField>>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task or tasks to
        /// describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the task or tasks you
        /// are describing were launched in any cluster other than the default cluster.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task or tasks to
        /// describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the task or tasks you
        /// are describing were launched in any cluster other than the default cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p>A list of up to 100 task IDs or full ARN entries.</p>
        pub fn tasks(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tasks.unwrap_or_default();
            v.push(input.into());
            self.tasks = Some(v);
            self
        }
        /// <p>A list of up to 100 task IDs or full ARN entries.</p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tasks = input;
            self
        }
        /// Appends an item to `include`.
        ///
        /// To override the contents of this collection use [`set_include`](Self::set_include).
        ///
        /// <p>Specifies whether you want to see the resource tags for the task. If <code>TAGS</code>
        /// is specified, the tags are included in the response. If this field is omitted, tags are
        /// not included in the response.</p>
        pub fn include(mut self, input: impl Into<crate::model::TaskField>) -> Self {
            let mut v = self.include.unwrap_or_default();
            v.push(input.into());
            self.include = Some(v);
            self
        }
        /// <p>Specifies whether you want to see the resource tags for the task. If <code>TAGS</code>
        /// is specified, the tags are included in the response. If this field is omitted, tags are
        /// not included in the response.</p>
        pub fn set_include(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TaskField>>,
        ) -> Self {
            self.include = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTasksInput`](crate::input::DescribeTasksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTasksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTasksInput {
                cluster: self.cluster,
                tasks: self.tasks,
                include: self.include,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTasksInputOperationOutputAlias = crate::operation::DescribeTasks;
#[doc(hidden)]
pub type DescribeTasksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTasksInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTasks`](crate::operation::DescribeTasks)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTasks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTasksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTasksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTasksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.DescribeTasks",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_tasks(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTasks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTasks",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTasksInput`](crate::input::DescribeTasksInput)
    pub fn builder() -> crate::input::describe_tasks_input::Builder {
        crate::input::describe_tasks_input::Builder::default()
    }
}

/// See [`DescribeTaskSetsInput`](crate::input::DescribeTaskSetsInput)
pub mod describe_task_sets_input {
    /// A builder for [`DescribeTaskSetsInput`](crate::input::DescribeTaskSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) task_sets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) include: std::option::Option<std::vec::Vec<crate::model::TaskSetField>>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task
        /// sets exist in.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task
        /// sets exist in.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service that the task sets exist in.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service that the task sets exist in.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// Appends an item to `task_sets`.
        ///
        /// To override the contents of this collection use [`set_task_sets`](Self::set_task_sets).
        ///
        /// <p>The ID or full Amazon Resource Name (ARN) of task sets to
        /// describe.</p>
        pub fn task_sets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.task_sets.unwrap_or_default();
            v.push(input.into());
            self.task_sets = Some(v);
            self
        }
        /// <p>The ID or full Amazon Resource Name (ARN) of task sets to
        /// describe.</p>
        pub fn set_task_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.task_sets = input;
            self
        }
        /// Appends an item to `include`.
        ///
        /// To override the contents of this collection use [`set_include`](Self::set_include).
        ///
        /// <p>Specifies whether to see the resource tags for the task set. If <code>TAGS</code> is
        /// specified, the tags are included in the response. If this field is omitted, tags are not
        /// included in the response.</p>
        pub fn include(mut self, input: impl Into<crate::model::TaskSetField>) -> Self {
            let mut v = self.include.unwrap_or_default();
            v.push(input.into());
            self.include = Some(v);
            self
        }
        /// <p>Specifies whether to see the resource tags for the task set. If <code>TAGS</code> is
        /// specified, the tags are included in the response. If this field is omitted, tags are not
        /// included in the response.</p>
        pub fn set_include(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TaskSetField>>,
        ) -> Self {
            self.include = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTaskSetsInput`](crate::input::DescribeTaskSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTaskSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTaskSetsInput {
                cluster: self.cluster,
                service: self.service,
                task_sets: self.task_sets,
                include: self.include,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTaskSetsInputOperationOutputAlias = crate::operation::DescribeTaskSets;
#[doc(hidden)]
pub type DescribeTaskSetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTaskSetsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTaskSets`](crate::operation::DescribeTaskSets)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTaskSets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTaskSetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTaskSetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTaskSetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.DescribeTaskSets",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_task_sets(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTaskSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTaskSets",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTaskSetsInput`](crate::input::DescribeTaskSetsInput)
    pub fn builder() -> crate::input::describe_task_sets_input::Builder {
        crate::input::describe_task_sets_input::Builder::default()
    }
}

/// See [`DiscoverPollEndpointInput`](crate::input::DiscoverPollEndpointInput)
pub mod discover_poll_endpoint_input {
    /// A builder for [`DiscoverPollEndpointInput`](crate::input::DiscoverPollEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_instance: std::option::Option<std::string::String>,
        pub(crate) cluster: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The container instance ID or full ARN of the container instance.
        /// The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the container instance, the Amazon Web Services account ID of the container instance owner, the <code>container-instance</code> namespace, and then the container instance ID. For example, <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.</p>
        pub fn container_instance(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_instance = Some(input.into());
            self
        }
        /// <p>The container instance ID or full ARN of the container instance.
        /// The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the container instance, the Amazon Web Services account ID of the container instance owner, the <code>container-instance</code> namespace, and then the container instance ID. For example, <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.</p>
        pub fn set_container_instance(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_instance = input;
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to which the container instance
        /// belongs.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to which the container instance
        /// belongs.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`DiscoverPollEndpointInput`](crate::input::DiscoverPollEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DiscoverPollEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DiscoverPollEndpointInput {
                container_instance: self.container_instance,
                cluster: self.cluster,
            })
        }
    }
}
#[doc(hidden)]
pub type DiscoverPollEndpointInputOperationOutputAlias = crate::operation::DiscoverPollEndpoint;
#[doc(hidden)]
pub type DiscoverPollEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DiscoverPollEndpointInput {
    /// Consumes the builder and constructs an Operation<[`DiscoverPollEndpoint`](crate::operation::DiscoverPollEndpoint)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DiscoverPollEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DiscoverPollEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DiscoverPollEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DiscoverPollEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.DiscoverPollEndpoint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_discover_poll_endpoint(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DiscoverPollEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DiscoverPollEndpoint",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DiscoverPollEndpointInput`](crate::input::DiscoverPollEndpointInput)
    pub fn builder() -> crate::input::discover_poll_endpoint_input::Builder {
        crate::input::discover_poll_endpoint_input::Builder::default()
    }
}

/// See [`ExecuteCommandInput`](crate::input::ExecuteCommandInput)
pub mod execute_command_input {
    /// A builder for [`ExecuteCommandInput`](crate::input::ExecuteCommandInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) container: std::option::Option<std::string::String>,
        pub(crate) command: std::option::Option<std::string::String>,
        pub(crate) interactive: std::option::Option<bool>,
        pub(crate) task: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) or short name of the cluster the task is running in.
        /// If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) or short name of the cluster the task is running in.
        /// If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>The name of the container to execute the command on. A container name only needs to be
        /// specified for tasks containing multiple containers.</p>
        pub fn container(mut self, input: impl Into<std::string::String>) -> Self {
            self.container = Some(input.into());
            self
        }
        /// <p>The name of the container to execute the command on. A container name only needs to be
        /// specified for tasks containing multiple containers.</p>
        pub fn set_container(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.container = input;
            self
        }
        /// <p>The command to run on the container.</p>
        pub fn command(mut self, input: impl Into<std::string::String>) -> Self {
            self.command = Some(input.into());
            self
        }
        /// <p>The command to run on the container.</p>
        pub fn set_command(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.command = input;
            self
        }
        /// <p>Use this flag to run your command in interactive mode.</p>
        pub fn interactive(mut self, input: bool) -> Self {
            self.interactive = Some(input);
            self
        }
        /// <p>Use this flag to run your command in interactive mode.</p>
        pub fn set_interactive(mut self, input: std::option::Option<bool>) -> Self {
            self.interactive = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) or ID of the task the container is part of.</p>
        pub fn task(mut self, input: impl Into<std::string::String>) -> Self {
            self.task = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) or ID of the task the container is part of.</p>
        pub fn set_task(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteCommandInput`](crate::input::ExecuteCommandInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExecuteCommandInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExecuteCommandInput {
                cluster: self.cluster,
                container: self.container,
                command: self.command,
                interactive: self.interactive.unwrap_or_default(),
                task: self.task,
            })
        }
    }
}
#[doc(hidden)]
pub type ExecuteCommandInputOperationOutputAlias = crate::operation::ExecuteCommand;
#[doc(hidden)]
pub type ExecuteCommandInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ExecuteCommandInput {
    /// Consumes the builder and constructs an Operation<[`ExecuteCommand`](crate::operation::ExecuteCommand)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExecuteCommand,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExecuteCommandInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExecuteCommandInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExecuteCommandInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.ExecuteCommand",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_execute_command(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExecuteCommand::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExecuteCommand",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExecuteCommandInput`](crate::input::ExecuteCommandInput)
    pub fn builder() -> crate::input::execute_command_input::Builder {
        crate::input::execute_command_input::Builder::default()
    }
}

/// See [`ListAccountSettingsInput`](crate::input::ListAccountSettingsInput)
pub mod list_account_settings_input {
    /// A builder for [`ListAccountSettingsInput`](crate::input::ListAccountSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SettingName>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) principal_arn: std::option::Option<std::string::String>,
        pub(crate) effective_settings: std::option::Option<bool>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the account setting you want to list the settings for.</p>
        pub fn name(mut self, input: crate::model::SettingName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the account setting you want to list the settings for.</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::SettingName>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the account settings with which to filter results. You must also specify
        /// an account setting name to use this parameter.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the account settings with which to filter results. You must also specify
        /// an account setting name to use this parameter.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The ARN of the principal, which can be an IAM user, IAM role, or the root user. If
        /// this field is omitted, the account settings are listed only for the authenticated
        /// user.</p>
        /// <note>
        /// <p>Federated users assume the account setting of the root user and can't have
        /// explicit account settings set for them.</p>
        /// </note>
        pub fn principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the principal, which can be an IAM user, IAM role, or the root user. If
        /// this field is omitted, the account settings are listed only for the authenticated
        /// user.</p>
        /// <note>
        /// <p>Federated users assume the account setting of the root user and can't have
        /// explicit account settings set for them.</p>
        /// </note>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.principal_arn = input;
            self
        }
        /// <p>Specifies whether to return the effective settings. If <code>true</code>, the account
        /// settings for the root user or the default setting for the <code>principalArn</code> are
        /// returned. If <code>false</code>, the account settings for the <code>principalArn</code>
        /// are returned if they are set. Otherwise, no account settings are returned.</p>
        pub fn effective_settings(mut self, input: bool) -> Self {
            self.effective_settings = Some(input);
            self
        }
        /// <p>Specifies whether to return the effective settings. If <code>true</code>, the account
        /// settings for the root user or the default setting for the <code>principalArn</code> are
        /// returned. If <code>false</code>, the account settings for the <code>principalArn</code>
        /// are returned if they are set. Otherwise, no account settings are returned.</p>
        pub fn set_effective_settings(mut self, input: std::option::Option<bool>) -> Self {
            self.effective_settings = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListAccountSettings</code>
        /// request indicating that more results are available to fulfill the request and further
        /// calls will be needed. If <code>maxResults</code> was provided, it is possible the number
        /// of results to be fewer than <code>maxResults</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListAccountSettings</code>
        /// request indicating that more results are available to fulfill the request and further
        /// calls will be needed. If <code>maxResults</code> was provided, it is possible the number
        /// of results to be fewer than <code>maxResults</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of account setting results returned by
        /// <code>ListAccountSettings</code> in paginated output. When this parameter is used,
        /// <code>ListAccountSettings</code> only returns <code>maxResults</code> results in a
        /// single page along with a <code>nextToken</code> response element. The remaining results
        /// of the initial request can be seen by sending another <code>ListAccountSettings</code>
        /// request with the returned <code>nextToken</code> value. This value can be between
        /// 1 and 10. If this
        /// parameter is not used, then <code>ListAccountSettings</code> returns up to
        /// 10 results and a <code>nextToken</code> value
        /// if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of account setting results returned by
        /// <code>ListAccountSettings</code> in paginated output. When this parameter is used,
        /// <code>ListAccountSettings</code> only returns <code>maxResults</code> results in a
        /// single page along with a <code>nextToken</code> response element. The remaining results
        /// of the initial request can be seen by sending another <code>ListAccountSettings</code>
        /// request with the returned <code>nextToken</code> value. This value can be between
        /// 1 and 10. If this
        /// parameter is not used, then <code>ListAccountSettings</code> returns up to
        /// 10 results and a <code>nextToken</code> value
        /// if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountSettingsInput`](crate::input::ListAccountSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccountSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccountSettingsInput {
                name: self.name,
                value: self.value,
                principal_arn: self.principal_arn,
                effective_settings: self.effective_settings.unwrap_or_default(),
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccountSettingsInputOperationOutputAlias = crate::operation::ListAccountSettings;
#[doc(hidden)]
pub type ListAccountSettingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAccountSettingsInput {
    /// Consumes the builder and constructs an Operation<[`ListAccountSettings`](crate::operation::ListAccountSettings)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccountSettings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAccountSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAccountSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAccountSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.ListAccountSettings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_account_settings(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccountSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccountSettings",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAccountSettingsInput`](crate::input::ListAccountSettingsInput)
    pub fn builder() -> crate::input::list_account_settings_input::Builder {
        crate::input::list_account_settings_input::Builder::default()
    }
}

/// See [`ListAttributesInput`](crate::input::ListAttributesInput)
pub mod list_attributes_input {
    /// A builder for [`ListAttributesInput`](crate::input::ListAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) target_type: std::option::Option<crate::model::TargetType>,
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) attribute_value: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to list attributes.
        /// If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to list attributes.
        /// If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>The type of the target with which to list attributes.</p>
        pub fn target_type(mut self, input: crate::model::TargetType) -> Self {
            self.target_type = Some(input);
            self
        }
        /// <p>The type of the target with which to list attributes.</p>
        pub fn set_target_type(
            mut self,
            input: std::option::Option<crate::model::TargetType>,
        ) -> Self {
            self.target_type = input;
            self
        }
        /// <p>The name of the attribute with which to filter the results. </p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the attribute with which to filter the results. </p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The value of the attribute with which to filter results. You must also specify an
        /// attribute name to use this parameter.</p>
        pub fn attribute_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_value = Some(input.into());
            self
        }
        /// <p>The value of the attribute with which to filter results. You must also specify an
        /// attribute name to use this parameter.</p>
        pub fn set_attribute_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_value = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListAttributes</code> request
        /// indicating that more results are available to fulfill the request and further calls will
        /// be needed. If <code>maxResults</code> was provided, it is possible the number of results
        /// to be fewer than <code>maxResults</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListAttributes</code> request
        /// indicating that more results are available to fulfill the request and further calls will
        /// be needed. If <code>maxResults</code> was provided, it is possible the number of results
        /// to be fewer than <code>maxResults</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of cluster results returned by <code>ListAttributes</code> in
        /// paginated output. When this parameter is used, <code>ListAttributes</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>ListAttributes</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 100. If this
        /// parameter is not used, then <code>ListAttributes</code> returns up to
        /// 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of cluster results returned by <code>ListAttributes</code> in
        /// paginated output. When this parameter is used, <code>ListAttributes</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>ListAttributes</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 100. If this
        /// parameter is not used, then <code>ListAttributes</code> returns up to
        /// 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAttributesInput`](crate::input::ListAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAttributesInput {
                cluster: self.cluster,
                target_type: self.target_type,
                attribute_name: self.attribute_name,
                attribute_value: self.attribute_value,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAttributesInputOperationOutputAlias = crate::operation::ListAttributes;
#[doc(hidden)]
pub type ListAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAttributesInput {
    /// Consumes the builder and constructs an Operation<[`ListAttributes`](crate::operation::ListAttributes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.ListAttributes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_attributes(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAttributes",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAttributesInput`](crate::input::ListAttributesInput)
    pub fn builder() -> crate::input::list_attributes_input::Builder {
        crate::input::list_attributes_input::Builder::default()
    }
}

/// See [`ListClustersInput`](crate::input::ListClustersInput)
pub mod list_clusters_input {
    /// A builder for [`ListClustersInput`](crate::input::ListClustersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The <code>nextToken</code> value returned from a <code>ListClusters</code> request
        /// indicating that more results are available to fulfill the request and further calls will
        /// be needed. If <code>maxResults</code> was provided, it is possible the number of results
        /// to be fewer than <code>maxResults</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListClusters</code> request
        /// indicating that more results are available to fulfill the request and further calls will
        /// be needed. If <code>maxResults</code> was provided, it is possible the number of results
        /// to be fewer than <code>maxResults</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of cluster results returned by <code>ListClusters</code> in
        /// paginated output. When this parameter is used, <code>ListClusters</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>ListClusters</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 100. If this
        /// parameter is not used, then <code>ListClusters</code> returns up to
        /// 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of cluster results returned by <code>ListClusters</code> in
        /// paginated output. When this parameter is used, <code>ListClusters</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>ListClusters</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 100. If this
        /// parameter is not used, then <code>ListClusters</code> returns up to
        /// 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListClustersInput`](crate::input::ListClustersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListClustersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListClustersInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListClustersInputOperationOutputAlias = crate::operation::ListClusters;
#[doc(hidden)]
pub type ListClustersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListClustersInput {
    /// Consumes the builder and constructs an Operation<[`ListClusters`](crate::operation::ListClusters)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListClusters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListClustersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListClustersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListClustersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.ListClusters",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_clusters(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListClusters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListClusters",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListClustersInput`](crate::input::ListClustersInput)
    pub fn builder() -> crate::input::list_clusters_input::Builder {
        crate::input::list_clusters_input::Builder::default()
    }
}

/// See [`ListContainerInstancesInput`](crate::input::ListContainerInstancesInput)
pub mod list_container_instances_input {
    /// A builder for [`ListContainerInstancesInput`](crate::input::ListContainerInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::ContainerInstanceStatus>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to
        /// list. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to
        /// list. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>You can filter the results of a <code>ListContainerInstances</code> operation with
        /// cluster query language statements. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter = Some(input.into());
            self
        }
        /// <p>You can filter the results of a <code>ListContainerInstances</code> operation with
        /// cluster query language statements. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_filter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListContainerInstances</code>
        /// request indicating that more results are available to fulfill the request and further
        /// calls will be needed. If <code>maxResults</code> was provided, it is possible the number
        /// of results to be fewer than <code>maxResults</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListContainerInstances</code>
        /// request indicating that more results are available to fulfill the request and further
        /// calls will be needed. If <code>maxResults</code> was provided, it is possible the number
        /// of results to be fewer than <code>maxResults</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of container instance results returned by
        /// <code>ListContainerInstances</code> in paginated output. When this parameter is
        /// used, <code>ListContainerInstances</code> only returns <code>maxResults</code> results
        /// in a single page along with a <code>nextToken</code> response element. The remaining
        /// results of the initial request can be seen by sending another
        /// <code>ListContainerInstances</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 100. If this
        /// parameter is not used, then <code>ListContainerInstances</code> returns up to
        /// 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of container instance results returned by
        /// <code>ListContainerInstances</code> in paginated output. When this parameter is
        /// used, <code>ListContainerInstances</code> only returns <code>maxResults</code> results
        /// in a single page along with a <code>nextToken</code> response element. The remaining
        /// results of the initial request can be seen by sending another
        /// <code>ListContainerInstances</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 100. If this
        /// parameter is not used, then <code>ListContainerInstances</code> returns up to
        /// 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Filters the container instances by status. For example, if you specify the
        /// <code>DRAINING</code> status, the results include only container instances that have
        /// been set to <code>DRAINING</code> using <a>UpdateContainerInstancesState</a>.
        /// If you do not specify this parameter, the default is to include container instances set
        /// to all states other than <code>INACTIVE</code>.</p>
        pub fn status(mut self, input: crate::model::ContainerInstanceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Filters the container instances by status. For example, if you specify the
        /// <code>DRAINING</code> status, the results include only container instances that have
        /// been set to <code>DRAINING</code> using <a>UpdateContainerInstancesState</a>.
        /// If you do not specify this parameter, the default is to include container instances set
        /// to all states other than <code>INACTIVE</code>.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ContainerInstanceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContainerInstancesInput`](crate::input::ListContainerInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListContainerInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListContainerInstancesInput {
                cluster: self.cluster,
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type ListContainerInstancesInputOperationOutputAlias = crate::operation::ListContainerInstances;
#[doc(hidden)]
pub type ListContainerInstancesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListContainerInstancesInput {
    /// Consumes the builder and constructs an Operation<[`ListContainerInstances`](crate::operation::ListContainerInstances)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListContainerInstances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListContainerInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListContainerInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListContainerInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.ListContainerInstances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_container_instances(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListContainerInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListContainerInstances",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListContainerInstancesInput`](crate::input::ListContainerInstancesInput)
    pub fn builder() -> crate::input::list_container_instances_input::Builder {
        crate::input::list_container_instances_input::Builder::default()
    }
}

/// See [`ListServicesInput`](crate::input::ListServicesInput)
pub mod list_services_input {
    /// A builder for [`ListServicesInput`](crate::input::ListServicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) launch_type: std::option::Option<crate::model::LaunchType>,
        pub(crate) scheduling_strategy: std::option::Option<crate::model::SchedulingStrategy>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the
        /// <code>ListServices</code> results. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the
        /// <code>ListServices</code> results. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListServices</code> request
        /// indicating that more results are available to fulfill the request and further calls will
        /// be needed. If <code>maxResults</code> was provided, it is possible the number of results
        /// to be fewer than <code>maxResults</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListServices</code> request
        /// indicating that more results are available to fulfill the request and further calls will
        /// be needed. If <code>maxResults</code> was provided, it is possible the number of results
        /// to be fewer than <code>maxResults</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of service results returned by <code>ListServices</code> in
        /// paginated output. When this parameter is used, <code>ListServices</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>ListServices</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 100. If
        /// this parameter is not used, then <code>ListServices</code> returns up to
        /// 10 results and a <code>nextToken</code> value if
        /// applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of service results returned by <code>ListServices</code> in
        /// paginated output. When this parameter is used, <code>ListServices</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>ListServices</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 100. If
        /// this parameter is not used, then <code>ListServices</code> returns up to
        /// 10 results and a <code>nextToken</code> value if
        /// applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The launch type to use when filtering the <code>ListServices</code> results.</p>
        pub fn launch_type(mut self, input: crate::model::LaunchType) -> Self {
            self.launch_type = Some(input);
            self
        }
        /// <p>The launch type to use when filtering the <code>ListServices</code> results.</p>
        pub fn set_launch_type(
            mut self,
            input: std::option::Option<crate::model::LaunchType>,
        ) -> Self {
            self.launch_type = input;
            self
        }
        /// <p>The scheduling strategy to use when filtering the <code>ListServices</code>
        /// results.</p>
        pub fn scheduling_strategy(mut self, input: crate::model::SchedulingStrategy) -> Self {
            self.scheduling_strategy = Some(input);
            self
        }
        /// <p>The scheduling strategy to use when filtering the <code>ListServices</code>
        /// results.</p>
        pub fn set_scheduling_strategy(
            mut self,
            input: std::option::Option<crate::model::SchedulingStrategy>,
        ) -> Self {
            self.scheduling_strategy = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServicesInput`](crate::input::ListServicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListServicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListServicesInput {
                cluster: self.cluster,
                next_token: self.next_token,
                max_results: self.max_results,
                launch_type: self.launch_type,
                scheduling_strategy: self.scheduling_strategy,
            })
        }
    }
}
#[doc(hidden)]
pub type ListServicesInputOperationOutputAlias = crate::operation::ListServices;
#[doc(hidden)]
pub type ListServicesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListServicesInput {
    /// Consumes the builder and constructs an Operation<[`ListServices`](crate::operation::ListServices)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListServices,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListServicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListServicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListServicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.ListServices",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_services(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListServices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListServices",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListServicesInput`](crate::input::ListServicesInput)
    pub fn builder() -> crate::input::list_services_input::Builder {
        crate::input::list_services_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the
        /// supported resources are Amazon ECS tasks, services, task definitions, clusters, and container
        /// instances.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the
        /// supported resources are Amazon ECS tasks, services, task definitions, clusters, and container
        /// instances.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTaskDefinitionFamiliesInput`](crate::input::ListTaskDefinitionFamiliesInput)
pub mod list_task_definition_families_input {
    /// A builder for [`ListTaskDefinitionFamiliesInput`](crate::input::ListTaskDefinitionFamiliesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) family_prefix: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TaskDefinitionFamilyStatus>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The <code>familyPrefix</code> is a string that is used to filter the results of
        /// <code>ListTaskDefinitionFamilies</code>. If you specify a <code>familyPrefix</code>,
        /// only task definition family names that begin with the <code>familyPrefix</code> string
        /// are returned.</p>
        pub fn family_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.family_prefix = Some(input.into());
            self
        }
        /// <p>The <code>familyPrefix</code> is a string that is used to filter the results of
        /// <code>ListTaskDefinitionFamilies</code>. If you specify a <code>familyPrefix</code>,
        /// only task definition family names that begin with the <code>familyPrefix</code> string
        /// are returned.</p>
        pub fn set_family_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.family_prefix = input;
            self
        }
        /// <p>The task definition family status with which to filter the
        /// <code>ListTaskDefinitionFamilies</code> results. By default, both
        /// <code>ACTIVE</code> and <code>INACTIVE</code> task definition families are listed.
        /// If this parameter is set to <code>ACTIVE</code>, only task definition families that have
        /// an <code>ACTIVE</code> task definition revision are returned. If this parameter is set
        /// to <code>INACTIVE</code>, only task definition families that do not have any
        /// <code>ACTIVE</code> task definition revisions are returned. If you paginate the
        /// resulting output, be sure to keep the <code>status</code> value constant in each
        /// subsequent request.</p>
        pub fn status(mut self, input: crate::model::TaskDefinitionFamilyStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The task definition family status with which to filter the
        /// <code>ListTaskDefinitionFamilies</code> results. By default, both
        /// <code>ACTIVE</code> and <code>INACTIVE</code> task definition families are listed.
        /// If this parameter is set to <code>ACTIVE</code>, only task definition families that have
        /// an <code>ACTIVE</code> task definition revision are returned. If this parameter is set
        /// to <code>INACTIVE</code>, only task definition families that do not have any
        /// <code>ACTIVE</code> task definition revisions are returned. If you paginate the
        /// resulting output, be sure to keep the <code>status</code> value constant in each
        /// subsequent request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TaskDefinitionFamilyStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a
        /// <code>ListTaskDefinitionFamilies</code> request indicating that more results are
        /// available to fulfill the request and further calls will be needed. If
        /// <code>maxResults</code> was provided, it is possible the number of results to be
        /// fewer than <code>maxResults</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a
        /// <code>ListTaskDefinitionFamilies</code> request indicating that more results are
        /// available to fulfill the request and further calls will be needed. If
        /// <code>maxResults</code> was provided, it is possible the number of results to be
        /// fewer than <code>maxResults</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of task definition family results returned by
        /// <code>ListTaskDefinitionFamilies</code> in paginated output. When this parameter is
        /// used, <code>ListTaskDefinitions</code> only returns <code>maxResults</code> results in a
        /// single page along with a <code>nextToken</code> response element. The remaining results
        /// of the initial request can be seen by sending another
        /// <code>ListTaskDefinitionFamilies</code> request with the returned
        /// <code>nextToken</code> value. This value can be between 1 and
        /// 100. If this parameter is not used, then
        /// <code>ListTaskDefinitionFamilies</code> returns up to 100 results
        /// and a <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of task definition family results returned by
        /// <code>ListTaskDefinitionFamilies</code> in paginated output. When this parameter is
        /// used, <code>ListTaskDefinitions</code> only returns <code>maxResults</code> results in a
        /// single page along with a <code>nextToken</code> response element. The remaining results
        /// of the initial request can be seen by sending another
        /// <code>ListTaskDefinitionFamilies</code> request with the returned
        /// <code>nextToken</code> value. This value can be between 1 and
        /// 100. If this parameter is not used, then
        /// <code>ListTaskDefinitionFamilies</code> returns up to 100 results
        /// and a <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTaskDefinitionFamiliesInput`](crate::input::ListTaskDefinitionFamiliesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTaskDefinitionFamiliesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTaskDefinitionFamiliesInput {
                family_prefix: self.family_prefix,
                status: self.status,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTaskDefinitionFamiliesInputOperationOutputAlias =
    crate::operation::ListTaskDefinitionFamilies;
#[doc(hidden)]
pub type ListTaskDefinitionFamiliesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTaskDefinitionFamiliesInput {
    /// Consumes the builder and constructs an Operation<[`ListTaskDefinitionFamilies`](crate::operation::ListTaskDefinitionFamilies)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTaskDefinitionFamilies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTaskDefinitionFamiliesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTaskDefinitionFamiliesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTaskDefinitionFamiliesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.ListTaskDefinitionFamilies",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_task_definition_families(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTaskDefinitionFamilies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTaskDefinitionFamilies",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTaskDefinitionFamiliesInput`](crate::input::ListTaskDefinitionFamiliesInput)
    pub fn builder() -> crate::input::list_task_definition_families_input::Builder {
        crate::input::list_task_definition_families_input::Builder::default()
    }
}

/// See [`ListTaskDefinitionsInput`](crate::input::ListTaskDefinitionsInput)
pub mod list_task_definitions_input {
    /// A builder for [`ListTaskDefinitionsInput`](crate::input::ListTaskDefinitionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) family_prefix: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TaskDefinitionStatus>,
        pub(crate) sort: std::option::Option<crate::model::SortOrder>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The full family name with which to filter the <code>ListTaskDefinitions</code>
        /// results. Specifying a <code>familyPrefix</code> limits the listed task definitions to
        /// task definition revisions that belong to that family.</p>
        pub fn family_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.family_prefix = Some(input.into());
            self
        }
        /// <p>The full family name with which to filter the <code>ListTaskDefinitions</code>
        /// results. Specifying a <code>familyPrefix</code> limits the listed task definitions to
        /// task definition revisions that belong to that family.</p>
        pub fn set_family_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.family_prefix = input;
            self
        }
        /// <p>The task definition status with which to filter the <code>ListTaskDefinitions</code>
        /// results. By default, only <code>ACTIVE</code> task definitions are listed. By setting
        /// this parameter to <code>INACTIVE</code>, you can view task definitions that are
        /// <code>INACTIVE</code> as long as an active task or service still references them. If
        /// you paginate the resulting output, be sure to keep the <code>status</code> value
        /// constant in each subsequent request.</p>
        pub fn status(mut self, input: crate::model::TaskDefinitionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The task definition status with which to filter the <code>ListTaskDefinitions</code>
        /// results. By default, only <code>ACTIVE</code> task definitions are listed. By setting
        /// this parameter to <code>INACTIVE</code>, you can view task definitions that are
        /// <code>INACTIVE</code> as long as an active task or service still references them. If
        /// you paginate the resulting output, be sure to keep the <code>status</code> value
        /// constant in each subsequent request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TaskDefinitionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The order in which to sort the results. Valid values are <code>ASC</code> and
        /// <code>DESC</code>. By default (<code>ASC</code>), task definitions are listed
        /// lexicographically by family name and in ascending numerical order by revision so that
        /// the newest task definitions in a family are listed last. Setting this parameter to
        /// <code>DESC</code> reverses the sort order on family name and revision so that the
        /// newest task definitions in a family are listed first.</p>
        pub fn sort(mut self, input: crate::model::SortOrder) -> Self {
            self.sort = Some(input);
            self
        }
        /// <p>The order in which to sort the results. Valid values are <code>ASC</code> and
        /// <code>DESC</code>. By default (<code>ASC</code>), task definitions are listed
        /// lexicographically by family name and in ascending numerical order by revision so that
        /// the newest task definitions in a family are listed last. Setting this parameter to
        /// <code>DESC</code> reverses the sort order on family name and revision so that the
        /// newest task definitions in a family are listed first.</p>
        pub fn set_sort(mut self, input: std::option::Option<crate::model::SortOrder>) -> Self {
            self.sort = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListTaskDefinitions</code>
        /// request indicating that more results are available to fulfill the request and further
        /// calls will be needed. If <code>maxResults</code> was provided, it is possible the number
        /// of results to be fewer than <code>maxResults</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListTaskDefinitions</code>
        /// request indicating that more results are available to fulfill the request and further
        /// calls will be needed. If <code>maxResults</code> was provided, it is possible the number
        /// of results to be fewer than <code>maxResults</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of task definition results returned by
        /// <code>ListTaskDefinitions</code> in paginated output. When this parameter is used,
        /// <code>ListTaskDefinitions</code> only returns <code>maxResults</code> results in a
        /// single page along with a <code>nextToken</code> response element. The remaining results
        /// of the initial request can be seen by sending another <code>ListTaskDefinitions</code>
        /// request with the returned <code>nextToken</code> value. This value can be between
        /// 1 and 100. If this parameter is not used, then
        /// <code>ListTaskDefinitions</code> returns up to 100 results and a
        /// <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of task definition results returned by
        /// <code>ListTaskDefinitions</code> in paginated output. When this parameter is used,
        /// <code>ListTaskDefinitions</code> only returns <code>maxResults</code> results in a
        /// single page along with a <code>nextToken</code> response element. The remaining results
        /// of the initial request can be seen by sending another <code>ListTaskDefinitions</code>
        /// request with the returned <code>nextToken</code> value. This value can be between
        /// 1 and 100. If this parameter is not used, then
        /// <code>ListTaskDefinitions</code> returns up to 100 results and a
        /// <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTaskDefinitionsInput`](crate::input::ListTaskDefinitionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTaskDefinitionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTaskDefinitionsInput {
                family_prefix: self.family_prefix,
                status: self.status,
                sort: self.sort,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTaskDefinitionsInputOperationOutputAlias = crate::operation::ListTaskDefinitions;
#[doc(hidden)]
pub type ListTaskDefinitionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTaskDefinitionsInput {
    /// Consumes the builder and constructs an Operation<[`ListTaskDefinitions`](crate::operation::ListTaskDefinitions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTaskDefinitions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTaskDefinitionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTaskDefinitionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTaskDefinitionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.ListTaskDefinitions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_task_definitions(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTaskDefinitions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTaskDefinitions",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTaskDefinitionsInput`](crate::input::ListTaskDefinitionsInput)
    pub fn builder() -> crate::input::list_task_definitions_input::Builder {
        crate::input::list_task_definitions_input::Builder::default()
    }
}

/// See [`ListTasksInput`](crate::input::ListTasksInput)
pub mod list_tasks_input {
    /// A builder for [`ListTasksInput`](crate::input::ListTasksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) container_instance: std::option::Option<std::string::String>,
        pub(crate) family: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) started_by: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) desired_status: std::option::Option<crate::model::DesiredStatus>,
        pub(crate) launch_type: std::option::Option<crate::model::LaunchType>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the
        /// <code>ListTasks</code> results. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the
        /// <code>ListTasks</code> results. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>The container instance ID or full ARN of the container instance to use when
        /// filtering the <code>ListTasks</code> results. Specifying a
        /// <code>containerInstance</code> limits the results to tasks that belong to that
        /// container instance.</p>
        pub fn container_instance(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_instance = Some(input.into());
            self
        }
        /// <p>The container instance ID or full ARN of the container instance to use when
        /// filtering the <code>ListTasks</code> results. Specifying a
        /// <code>containerInstance</code> limits the results to tasks that belong to that
        /// container instance.</p>
        pub fn set_container_instance(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_instance = input;
            self
        }
        /// <p>The name of the task definition family to use when filtering the
        /// <code>ListTasks</code> results. Specifying a <code>family</code> limits the results
        /// to tasks that belong to that family.</p>
        pub fn family(mut self, input: impl Into<std::string::String>) -> Self {
            self.family = Some(input.into());
            self
        }
        /// <p>The name of the task definition family to use when filtering the
        /// <code>ListTasks</code> results. Specifying a <code>family</code> limits the results
        /// to tasks that belong to that family.</p>
        pub fn set_family(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.family = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListTasks</code> request
        /// indicating that more results are available to fulfill the request and further calls will
        /// be needed. If <code>maxResults</code> was provided, it is possible the number of results
        /// to be fewer than <code>maxResults</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a <code>ListTasks</code> request
        /// indicating that more results are available to fulfill the request and further calls will
        /// be needed. If <code>maxResults</code> was provided, it is possible the number of results
        /// to be fewer than <code>maxResults</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of task results returned by <code>ListTasks</code> in paginated
        /// output. When this parameter is used, <code>ListTasks</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>ListTasks</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 100. If this parameter is
        /// not used, then <code>ListTasks</code> returns up to 100 results and a
        /// <code>nextToken</code> value if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of task results returned by <code>ListTasks</code> in paginated
        /// output. When this parameter is used, <code>ListTasks</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>ListTasks</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 100. If this parameter is
        /// not used, then <code>ListTasks</code> returns up to 100 results and a
        /// <code>nextToken</code> value if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The <code>startedBy</code> value with which to filter the task results. Specifying a
        /// <code>startedBy</code> value limits the results to tasks that were started with that
        /// value.</p>
        pub fn started_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.started_by = Some(input.into());
            self
        }
        /// <p>The <code>startedBy</code> value with which to filter the task results. Specifying a
        /// <code>startedBy</code> value limits the results to tasks that were started with that
        /// value.</p>
        pub fn set_started_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.started_by = input;
            self
        }
        /// <p>The name of the service to use when filtering the <code>ListTasks</code> results.
        /// Specifying a <code>serviceName</code> limits the results to tasks that belong to that
        /// service.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the service to use when filtering the <code>ListTasks</code> results.
        /// Specifying a <code>serviceName</code> limits the results to tasks that belong to that
        /// service.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The task desired status to use when filtering the <code>ListTasks</code> results.
        /// Specifying a <code>desiredStatus</code> of <code>STOPPED</code> limits the results to
        /// tasks that Amazon ECS has set the desired status to <code>STOPPED</code>. This can be useful
        /// for debugging tasks that are not starting properly or have died or finished. The default
        /// status filter is <code>RUNNING</code>, which shows tasks that Amazon ECS has set the desired
        /// status to <code>RUNNING</code>.</p>
        /// <note>
        /// <p>Although you can filter results based on a desired status of <code>PENDING</code>,
        /// this does not return any results. Amazon ECS never sets the desired status of a task to
        /// that value (only a task's <code>lastStatus</code> may have a value of
        /// <code>PENDING</code>).</p>
        /// </note>
        pub fn desired_status(mut self, input: crate::model::DesiredStatus) -> Self {
            self.desired_status = Some(input);
            self
        }
        /// <p>The task desired status to use when filtering the <code>ListTasks</code> results.
        /// Specifying a <code>desiredStatus</code> of <code>STOPPED</code> limits the results to
        /// tasks that Amazon ECS has set the desired status to <code>STOPPED</code>. This can be useful
        /// for debugging tasks that are not starting properly or have died or finished. The default
        /// status filter is <code>RUNNING</code>, which shows tasks that Amazon ECS has set the desired
        /// status to <code>RUNNING</code>.</p>
        /// <note>
        /// <p>Although you can filter results based on a desired status of <code>PENDING</code>,
        /// this does not return any results. Amazon ECS never sets the desired status of a task to
        /// that value (only a task's <code>lastStatus</code> may have a value of
        /// <code>PENDING</code>).</p>
        /// </note>
        pub fn set_desired_status(
            mut self,
            input: std::option::Option<crate::model::DesiredStatus>,
        ) -> Self {
            self.desired_status = input;
            self
        }
        /// <p>The launch type to use when filtering the <code>ListTasks</code> results.</p>
        pub fn launch_type(mut self, input: crate::model::LaunchType) -> Self {
            self.launch_type = Some(input);
            self
        }
        /// <p>The launch type to use when filtering the <code>ListTasks</code> results.</p>
        pub fn set_launch_type(
            mut self,
            input: std::option::Option<crate::model::LaunchType>,
        ) -> Self {
            self.launch_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTasksInput`](crate::input::ListTasksInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListTasksInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListTasksInput {
                cluster: self.cluster,
                container_instance: self.container_instance,
                family: self.family,
                next_token: self.next_token,
                max_results: self.max_results,
                started_by: self.started_by,
                service_name: self.service_name,
                desired_status: self.desired_status,
                launch_type: self.launch_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTasksInputOperationOutputAlias = crate::operation::ListTasks;
#[doc(hidden)]
pub type ListTasksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTasksInput {
    /// Consumes the builder and constructs an Operation<[`ListTasks`](crate::operation::ListTasks)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTasks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTasksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTasksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTasksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.ListTasks",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_tasks(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListTasks::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListTasks",
                    "ecs",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTasksInput`](crate::input::ListTasksInput)
    pub fn builder() -> crate::input::list_tasks_input::Builder {
        crate::input::list_tasks_input::Builder::default()
    }
}

/// See [`PutAccountSettingInput`](crate::input::PutAccountSettingInput)
pub mod put_account_setting_input {
    /// A builder for [`PutAccountSettingInput`](crate::input::PutAccountSettingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SettingName>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) principal_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon ECS resource name for which to modify the account setting. If
        /// <code>serviceLongArnFormat</code> is specified, the ARN for your Amazon ECS services is
        /// affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID for
        /// your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is
        /// specified, the ARN and resource ID for your Amazon ECS container instances is affected. If
        /// <code>awsvpcTrunking</code> is specified, the elastic network interface (ENI) limit
        /// for your Amazon ECS container instances is affected. If <code>containerInsights</code> is
        /// specified, the default setting for CloudWatch Container Insights for your clusters is
        /// affected.</p>
        pub fn name(mut self, input: crate::model::SettingName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The Amazon ECS resource name for which to modify the account setting. If
        /// <code>serviceLongArnFormat</code> is specified, the ARN for your Amazon ECS services is
        /// affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID for
        /// your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is
        /// specified, the ARN and resource ID for your Amazon ECS container instances is affected. If
        /// <code>awsvpcTrunking</code> is specified, the elastic network interface (ENI) limit
        /// for your Amazon ECS container instances is affected. If <code>containerInsights</code> is
        /// specified, the default setting for CloudWatch Container Insights for your clusters is
        /// affected.</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::SettingName>) -> Self {
            self.name = input;
            self
        }
        /// <p>The account setting value for the specified principal ARN. Accepted values are
        /// <code>enabled</code> and <code>disabled</code>.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The account setting value for the specified principal ARN. Accepted values are
        /// <code>enabled</code> and <code>disabled</code>.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The ARN of the principal, which can be an IAM user, IAM role, or the root user. If you
        /// specify the root user, it modifies the account setting for all IAM users, IAM roles, and
        /// the root user of the account unless an IAM user or role explicitly overrides these
        /// settings. If this field is omitted, the setting is changed only for the authenticated
        /// user.</p>
        /// <note>
        /// <p>Federated users assume the account setting of the root user and can't have
        /// explicit account settings set for them.</p>
        /// </note>
        pub fn principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the principal, which can be an IAM user, IAM role, or the root user. If you
        /// specify the root user, it modifies the account setting for all IAM users, IAM roles, and
        /// the root user of the account unless an IAM user or role explicitly overrides these
        /// settings. If this field is omitted, the setting is changed only for the authenticated
        /// user.</p>
        /// <note>
        /// <p>Federated users assume the account setting of the root user and can't have
        /// explicit account settings set for them.</p>
        /// </note>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.principal_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAccountSettingInput`](crate::input::PutAccountSettingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAccountSettingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutAccountSettingInput {
                name: self.name,
                value: self.value,
                principal_arn: self.principal_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type PutAccountSettingInputOperationOutputAlias = crate::operation::PutAccountSetting;
#[doc(hidden)]
pub type PutAccountSettingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutAccountSettingInput {
    /// Consumes the builder and constructs an Operation<[`PutAccountSetting`](crate::operation::PutAccountSetting)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAccountSetting,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutAccountSettingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutAccountSettingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutAccountSettingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.PutAccountSetting",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_account_setting(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAccountSetting::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAccountSetting",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutAccountSettingInput`](crate::input::PutAccountSettingInput)
    pub fn builder() -> crate::input::put_account_setting_input::Builder {
        crate::input::put_account_setting_input::Builder::default()
    }
}

/// See [`PutAccountSettingDefaultInput`](crate::input::PutAccountSettingDefaultInput)
pub mod put_account_setting_default_input {
    /// A builder for [`PutAccountSettingDefaultInput`](crate::input::PutAccountSettingDefaultInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SettingName>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource name for which to modify the account setting. If
        /// <code>serviceLongArnFormat</code> is specified, the ARN for your Amazon ECS services is
        /// affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID for
        /// your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is
        /// specified, the ARN and resource ID for your Amazon ECS container instances is affected. If
        /// <code>awsvpcTrunking</code> is specified, the ENI limit for your Amazon ECS container
        /// instances is affected. If <code>containerInsights</code> is specified, the default
        /// setting for CloudWatch Container Insights for your clusters is affected.</p>
        pub fn name(mut self, input: crate::model::SettingName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The resource name for which to modify the account setting. If
        /// <code>serviceLongArnFormat</code> is specified, the ARN for your Amazon ECS services is
        /// affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID for
        /// your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is
        /// specified, the ARN and resource ID for your Amazon ECS container instances is affected. If
        /// <code>awsvpcTrunking</code> is specified, the ENI limit for your Amazon ECS container
        /// instances is affected. If <code>containerInsights</code> is specified, the default
        /// setting for CloudWatch Container Insights for your clusters is affected.</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::SettingName>) -> Self {
            self.name = input;
            self
        }
        /// <p>The account setting value for the specified principal ARN. Accepted values are
        /// <code>enabled</code> and <code>disabled</code>.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The account setting value for the specified principal ARN. Accepted values are
        /// <code>enabled</code> and <code>disabled</code>.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAccountSettingDefaultInput`](crate::input::PutAccountSettingDefaultInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAccountSettingDefaultInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutAccountSettingDefaultInput {
                name: self.name,
                value: self.value,
            })
        }
    }
}
#[doc(hidden)]
pub type PutAccountSettingDefaultInputOperationOutputAlias =
    crate::operation::PutAccountSettingDefault;
#[doc(hidden)]
pub type PutAccountSettingDefaultInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutAccountSettingDefaultInput {
    /// Consumes the builder and constructs an Operation<[`PutAccountSettingDefault`](crate::operation::PutAccountSettingDefault)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAccountSettingDefault,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutAccountSettingDefaultInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutAccountSettingDefaultInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutAccountSettingDefaultInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.PutAccountSettingDefault",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_account_setting_default(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAccountSettingDefault::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAccountSettingDefault",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutAccountSettingDefaultInput`](crate::input::PutAccountSettingDefaultInput)
    pub fn builder() -> crate::input::put_account_setting_default_input::Builder {
        crate::input::put_account_setting_default_input::Builder::default()
    }
}

/// See [`PutAttributesInput`](crate::input::PutAttributesInput)
pub mod put_attributes_input {
    /// A builder for [`PutAttributesInput`](crate::input::PutAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that contains the resource to apply
        /// attributes. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that contains the resource to apply
        /// attributes. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes to apply to your resource. You can specify up to 10 custom attributes
        /// per resource. You can specify up to 10 attributes in a single call.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::Attribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>The attributes to apply to your resource. You can specify up to 10 custom attributes
        /// per resource. You can specify up to 10 attributes in a single call.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAttributesInput`](crate::input::PutAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutAttributesInput {
                cluster: self.cluster,
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type PutAttributesInputOperationOutputAlias = crate::operation::PutAttributes;
#[doc(hidden)]
pub type PutAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutAttributesInput {
    /// Consumes the builder and constructs an Operation<[`PutAttributes`](crate::operation::PutAttributes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.PutAttributes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_attributes(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAttributes",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutAttributesInput`](crate::input::PutAttributesInput)
    pub fn builder() -> crate::input::put_attributes_input::Builder {
        crate::input::put_attributes_input::Builder::default()
    }
}

/// See [`PutClusterCapacityProvidersInput`](crate::input::PutClusterCapacityProvidersInput)
pub mod put_cluster_capacity_providers_input {
    /// A builder for [`PutClusterCapacityProvidersInput`](crate::input::PutClusterCapacityProvidersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) capacity_providers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) default_capacity_provider_strategy:
            std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to modify the capacity provider
        /// settings for. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to modify the capacity provider
        /// settings for. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// Appends an item to `capacity_providers`.
        ///
        /// To override the contents of this collection use [`set_capacity_providers`](Self::set_capacity_providers).
        ///
        /// <p>The name of one or more capacity providers to associate with the cluster.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity
        /// provider must already be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
        /// <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are
        /// available to all accounts and only need to be associated with a cluster to be
        /// used.</p>
        pub fn capacity_providers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.capacity_providers.unwrap_or_default();
            v.push(input.into());
            self.capacity_providers = Some(v);
            self
        }
        /// <p>The name of one or more capacity providers to associate with the cluster.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity
        /// provider must already be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
        /// <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are
        /// available to all accounts and only need to be associated with a cluster to be
        /// used.</p>
        pub fn set_capacity_providers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.capacity_providers = input;
            self
        }
        /// Appends an item to `default_capacity_provider_strategy`.
        ///
        /// To override the contents of this collection use [`set_default_capacity_provider_strategy`](Self::set_default_capacity_provider_strategy).
        ///
        /// <p>The capacity provider strategy to use by default for the cluster.</p>
        /// <p>When creating a service or running a task on a cluster, if no capacity provider or
        /// launch type is specified then the default capacity provider strategy for the cluster is
        /// used.</p>
        /// <p>A capacity provider strategy consists of one or more capacity providers along with the
        /// <code>base</code> and <code>weight</code> to assign to them. A capacity provider
        /// must be associated with the cluster to be used in a capacity provider strategy. The
        /// <a>PutClusterCapacityProviders</a> API is used to associate a capacity
        /// provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or
        /// <code>UPDATING</code> status can be used.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity
        /// provider must already be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
        /// <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are
        /// available to all accounts and only need to be associated with a cluster to be
        /// used.</p>
        pub fn default_capacity_provider_strategy(
            mut self,
            input: impl Into<crate::model::CapacityProviderStrategyItem>,
        ) -> Self {
            let mut v = self.default_capacity_provider_strategy.unwrap_or_default();
            v.push(input.into());
            self.default_capacity_provider_strategy = Some(v);
            self
        }
        /// <p>The capacity provider strategy to use by default for the cluster.</p>
        /// <p>When creating a service or running a task on a cluster, if no capacity provider or
        /// launch type is specified then the default capacity provider strategy for the cluster is
        /// used.</p>
        /// <p>A capacity provider strategy consists of one or more capacity providers along with the
        /// <code>base</code> and <code>weight</code> to assign to them. A capacity provider
        /// must be associated with the cluster to be used in a capacity provider strategy. The
        /// <a>PutClusterCapacityProviders</a> API is used to associate a capacity
        /// provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or
        /// <code>UPDATING</code> status can be used.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity
        /// provider must already be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
        /// <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are
        /// available to all accounts and only need to be associated with a cluster to be
        /// used.</p>
        pub fn set_default_capacity_provider_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        ) -> Self {
            self.default_capacity_provider_strategy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutClusterCapacityProvidersInput`](crate::input::PutClusterCapacityProvidersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutClusterCapacityProvidersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutClusterCapacityProvidersInput {
                cluster: self.cluster,
                capacity_providers: self.capacity_providers,
                default_capacity_provider_strategy: self.default_capacity_provider_strategy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutClusterCapacityProvidersInputOperationOutputAlias =
    crate::operation::PutClusterCapacityProviders;
#[doc(hidden)]
pub type PutClusterCapacityProvidersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutClusterCapacityProvidersInput {
    /// Consumes the builder and constructs an Operation<[`PutClusterCapacityProviders`](crate::operation::PutClusterCapacityProviders)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutClusterCapacityProviders,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutClusterCapacityProvidersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutClusterCapacityProvidersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutClusterCapacityProvidersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.PutClusterCapacityProviders",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_cluster_capacity_providers(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutClusterCapacityProviders::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutClusterCapacityProviders",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutClusterCapacityProvidersInput`](crate::input::PutClusterCapacityProvidersInput)
    pub fn builder() -> crate::input::put_cluster_capacity_providers_input::Builder {
        crate::input::put_cluster_capacity_providers_input::Builder::default()
    }
}

/// See [`RegisterContainerInstanceInput`](crate::input::RegisterContainerInstanceInput)
pub mod register_container_instance_input {
    /// A builder for [`RegisterContainerInstanceInput`](crate::input::RegisterContainerInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) instance_identity_document: std::option::Option<std::string::String>,
        pub(crate) instance_identity_document_signature: std::option::Option<std::string::String>,
        pub(crate) total_resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        pub(crate) version_info: std::option::Option<crate::model::VersionInfo>,
        pub(crate) container_instance_arn: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        pub(crate) platform_devices:
            std::option::Option<std::vec::Vec<crate::model::PlatformDevice>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster with which to register your container
        /// instance. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster with which to register your container
        /// instance. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>The instance identity document for the EC2 instance to register. This document can be
        /// found by running the following command from the instance: <code>curl
        /// http://169.254.169.254/latest/dynamic/instance-identity/document/</code>
        /// </p>
        pub fn instance_identity_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_identity_document = Some(input.into());
            self
        }
        /// <p>The instance identity document for the EC2 instance to register. This document can be
        /// found by running the following command from the instance: <code>curl
        /// http://169.254.169.254/latest/dynamic/instance-identity/document/</code>
        /// </p>
        pub fn set_instance_identity_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_identity_document = input;
            self
        }
        /// <p>The instance identity document signature for the EC2 instance to register. This
        /// signature can be found by running the following command from the instance: <code>curl
        /// http://169.254.169.254/latest/dynamic/instance-identity/signature/</code>
        /// </p>
        pub fn instance_identity_document_signature(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.instance_identity_document_signature = Some(input.into());
            self
        }
        /// <p>The instance identity document signature for the EC2 instance to register. This
        /// signature can be found by running the following command from the instance: <code>curl
        /// http://169.254.169.254/latest/dynamic/instance-identity/signature/</code>
        /// </p>
        pub fn set_instance_identity_document_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_identity_document_signature = input;
            self
        }
        /// Appends an item to `total_resources`.
        ///
        /// To override the contents of this collection use [`set_total_resources`](Self::set_total_resources).
        ///
        /// <p>The resources available on the instance.</p>
        pub fn total_resources(mut self, input: impl Into<crate::model::Resource>) -> Self {
            let mut v = self.total_resources.unwrap_or_default();
            v.push(input.into());
            self.total_resources = Some(v);
            self
        }
        /// <p>The resources available on the instance.</p>
        pub fn set_total_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.total_resources = input;
            self
        }
        /// <p>The version information for the Amazon ECS container agent and Docker daemon running on the
        /// container instance.</p>
        pub fn version_info(mut self, input: crate::model::VersionInfo) -> Self {
            self.version_info = Some(input);
            self
        }
        /// <p>The version information for the Amazon ECS container agent and Docker daemon running on the
        /// container instance.</p>
        pub fn set_version_info(
            mut self,
            input: std::option::Option<crate::model::VersionInfo>,
        ) -> Self {
            self.version_info = input;
            self
        }
        /// <p>The ARN of the container instance (if it was previously registered).</p>
        pub fn container_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the container instance (if it was previously registered).</p>
        pub fn set_container_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_instance_arn = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The container instance attributes that this container instance supports.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::Attribute>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>The container instance attributes that this container instance supports.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Appends an item to `platform_devices`.
        ///
        /// To override the contents of this collection use [`set_platform_devices`](Self::set_platform_devices).
        ///
        /// <p>The devices that are available on the container instance. The only supported device
        /// type is a GPU.</p>
        pub fn platform_devices(mut self, input: impl Into<crate::model::PlatformDevice>) -> Self {
            let mut v = self.platform_devices.unwrap_or_default();
            v.push(input.into());
            self.platform_devices = Some(v);
            self
        }
        /// <p>The devices that are available on the container instance. The only supported device
        /// type is a GPU.</p>
        pub fn set_platform_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlatformDevice>>,
        ) -> Self {
            self.platform_devices = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the container instance to help you categorize and
        /// organize them. Each tag consists of a key and an optional value, both of which you
        /// define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The metadata that you apply to the container instance to help you categorize and
        /// organize them. Each tag consists of a key and an optional value, both of which you
        /// define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterContainerInstanceInput`](crate::input::RegisterContainerInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterContainerInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterContainerInstanceInput {
                cluster: self.cluster,
                instance_identity_document: self.instance_identity_document,
                instance_identity_document_signature: self.instance_identity_document_signature,
                total_resources: self.total_resources,
                version_info: self.version_info,
                container_instance_arn: self.container_instance_arn,
                attributes: self.attributes,
                platform_devices: self.platform_devices,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterContainerInstanceInputOperationOutputAlias =
    crate::operation::RegisterContainerInstance;
#[doc(hidden)]
pub type RegisterContainerInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterContainerInstanceInput {
    /// Consumes the builder and constructs an Operation<[`RegisterContainerInstance`](crate::operation::RegisterContainerInstance)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterContainerInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterContainerInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterContainerInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterContainerInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.RegisterContainerInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_container_instance(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterContainerInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterContainerInstance",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterContainerInstanceInput`](crate::input::RegisterContainerInstanceInput)
    pub fn builder() -> crate::input::register_container_instance_input::Builder {
        crate::input::register_container_instance_input::Builder::default()
    }
}

/// See [`RegisterTaskDefinitionInput`](crate::input::RegisterTaskDefinitionInput)
pub mod register_task_definition_input {
    /// A builder for [`RegisterTaskDefinitionInput`](crate::input::RegisterTaskDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) family: std::option::Option<std::string::String>,
        pub(crate) task_role_arn: std::option::Option<std::string::String>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) network_mode: std::option::Option<crate::model::NetworkMode>,
        pub(crate) container_definitions:
            std::option::Option<std::vec::Vec<crate::model::ContainerDefinition>>,
        pub(crate) volumes: std::option::Option<std::vec::Vec<crate::model::Volume>>,
        pub(crate) placement_constraints:
            std::option::Option<std::vec::Vec<crate::model::TaskDefinitionPlacementConstraint>>,
        pub(crate) requires_compatibilities:
            std::option::Option<std::vec::Vec<crate::model::Compatibility>>,
        pub(crate) cpu: std::option::Option<std::string::String>,
        pub(crate) memory: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) pid_mode: std::option::Option<crate::model::PidMode>,
        pub(crate) ipc_mode: std::option::Option<crate::model::IpcMode>,
        pub(crate) proxy_configuration: std::option::Option<crate::model::ProxyConfiguration>,
        pub(crate) inference_accelerators:
            std::option::Option<std::vec::Vec<crate::model::InferenceAccelerator>>,
        pub(crate) ephemeral_storage: std::option::Option<crate::model::EphemeralStorage>,
        pub(crate) runtime_platform: std::option::Option<crate::model::RuntimePlatform>,
    }
    impl Builder {
        /// <p>You must specify a <code>family</code> for a task definition, which allows you to
        /// track multiple versions of the same task definition. The <code>family</code> is used as
        /// a name for your task definition. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed.</p>
        pub fn family(mut self, input: impl Into<std::string::String>) -> Self {
            self.family = Some(input.into());
            self
        }
        /// <p>You must specify a <code>family</code> for a task definition, which allows you to
        /// track multiple versions of the same task definition. The <code>family</code> is used as
        /// a name for your task definition. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed.</p>
        pub fn set_family(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.family = input;
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the IAM role that containers in this task can
        /// assume. All containers in this task are granted the permissions that are specified in
        /// this role. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Roles for
        /// Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn task_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_role_arn = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the IAM role that containers in this task can
        /// assume. All containers in this task are granted the permissions that are specified in
        /// this role. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Roles for
        /// Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_task_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent
        /// permission to make Amazon Web Services API calls on your behalf. The task execution IAM role is required
        /// depending on the requirements of your task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task
        /// execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent
        /// permission to make Amazon Web Services API calls on your behalf. The task execution IAM role is required
        /// depending on the requirements of your task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task
        /// execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>The Docker networking mode to use for the containers in the task. The valid values are
        /// <code>none</code>, <code>bridge</code>, <code>awsvpc</code>, and <code>host</code>.
        /// If no network mode is specified, the default is <code>bridge</code>.</p>
        /// <p>For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required.
        /// For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used.  For Amazon ECS tasks on Amazon EC2 Windows instances, <code><default></code> or <code>awsvpc</code> can be used. If the network
        /// mode is set to <code>none</code>, you cannot specify port mappings in your container
        /// definitions, and the tasks containers do not have external connectivity. The
        /// <code>host</code> and <code>awsvpc</code> network modes offer the highest networking
        /// performance for containers because they use the EC2 network stack instead of the
        /// virtualized network stack provided by the <code>bridge</code> mode.</p>
        /// <p>With the <code>host</code> and <code>awsvpc</code> network modes, exposed container
        /// ports are mapped directly to the corresponding host port (for the <code>host</code>
        /// network mode) or the attached elastic network interface port (for the
        /// <code>awsvpc</code> network mode), so you cannot take advantage of dynamic host port
        /// mappings. </p>
        /// <important>
        /// <p>When using the <code>host</code> network mode, you should not run
        /// containers using the root user (UID 0). It is considered best practice
        /// to use a non-root user.</p>
        /// </important>
        /// <p>If the network mode is <code>awsvpc</code>, the task is allocated an elastic network
        /// interface, and you must specify a <a>NetworkConfiguration</a> value when you create
        /// a service or run a task with the task definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>If the network mode is <code>host</code>, you cannot run multiple instantiations of the
        /// same task on a single container instance when port mappings are used.</p>
        /// <p>For more information, see <a href="https://docs.docker.com/engine/reference/run/#network-settings">Network
        /// settings</a> in the <i>Docker run reference</i>.</p>
        pub fn network_mode(mut self, input: crate::model::NetworkMode) -> Self {
            self.network_mode = Some(input);
            self
        }
        /// <p>The Docker networking mode to use for the containers in the task. The valid values are
        /// <code>none</code>, <code>bridge</code>, <code>awsvpc</code>, and <code>host</code>.
        /// If no network mode is specified, the default is <code>bridge</code>.</p>
        /// <p>For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required.
        /// For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used.  For Amazon ECS tasks on Amazon EC2 Windows instances, <code><default></code> or <code>awsvpc</code> can be used. If the network
        /// mode is set to <code>none</code>, you cannot specify port mappings in your container
        /// definitions, and the tasks containers do not have external connectivity. The
        /// <code>host</code> and <code>awsvpc</code> network modes offer the highest networking
        /// performance for containers because they use the EC2 network stack instead of the
        /// virtualized network stack provided by the <code>bridge</code> mode.</p>
        /// <p>With the <code>host</code> and <code>awsvpc</code> network modes, exposed container
        /// ports are mapped directly to the corresponding host port (for the <code>host</code>
        /// network mode) or the attached elastic network interface port (for the
        /// <code>awsvpc</code> network mode), so you cannot take advantage of dynamic host port
        /// mappings. </p>
        /// <important>
        /// <p>When using the <code>host</code> network mode, you should not run
        /// containers using the root user (UID 0). It is considered best practice
        /// to use a non-root user.</p>
        /// </important>
        /// <p>If the network mode is <code>awsvpc</code>, the task is allocated an elastic network
        /// interface, and you must specify a <a>NetworkConfiguration</a> value when you create
        /// a service or run a task with the task definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>If the network mode is <code>host</code>, you cannot run multiple instantiations of the
        /// same task on a single container instance when port mappings are used.</p>
        /// <p>For more information, see <a href="https://docs.docker.com/engine/reference/run/#network-settings">Network
        /// settings</a> in the <i>Docker run reference</i>.</p>
        pub fn set_network_mode(
            mut self,
            input: std::option::Option<crate::model::NetworkMode>,
        ) -> Self {
            self.network_mode = input;
            self
        }
        /// Appends an item to `container_definitions`.
        ///
        /// To override the contents of this collection use [`set_container_definitions`](Self::set_container_definitions).
        ///
        /// <p>A list of container definitions in JSON format that describe the different containers
        /// that make up your task.</p>
        pub fn container_definitions(
            mut self,
            input: impl Into<crate::model::ContainerDefinition>,
        ) -> Self {
            let mut v = self.container_definitions.unwrap_or_default();
            v.push(input.into());
            self.container_definitions = Some(v);
            self
        }
        /// <p>A list of container definitions in JSON format that describe the different containers
        /// that make up your task.</p>
        pub fn set_container_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContainerDefinition>>,
        ) -> Self {
            self.container_definitions = input;
            self
        }
        /// Appends an item to `volumes`.
        ///
        /// To override the contents of this collection use [`set_volumes`](Self::set_volumes).
        ///
        /// <p>A list of volume definitions in JSON format that containers in your task may
        /// use.</p>
        pub fn volumes(mut self, input: impl Into<crate::model::Volume>) -> Self {
            let mut v = self.volumes.unwrap_or_default();
            v.push(input.into());
            self.volumes = Some(v);
            self
        }
        /// <p>A list of volume definitions in JSON format that containers in your task may
        /// use.</p>
        pub fn set_volumes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Volume>>,
        ) -> Self {
            self.volumes = input;
            self
        }
        /// Appends an item to `placement_constraints`.
        ///
        /// To override the contents of this collection use [`set_placement_constraints`](Self::set_placement_constraints).
        ///
        /// <p>An array of placement constraint objects to use for the task. You can specify a
        /// maximum of 10 constraints per task (this limit includes constraints in the task
        /// definition and those specified at runtime).</p>
        pub fn placement_constraints(
            mut self,
            input: impl Into<crate::model::TaskDefinitionPlacementConstraint>,
        ) -> Self {
            let mut v = self.placement_constraints.unwrap_or_default();
            v.push(input.into());
            self.placement_constraints = Some(v);
            self
        }
        /// <p>An array of placement constraint objects to use for the task. You can specify a
        /// maximum of 10 constraints per task (this limit includes constraints in the task
        /// definition and those specified at runtime).</p>
        pub fn set_placement_constraints(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::TaskDefinitionPlacementConstraint>,
            >,
        ) -> Self {
            self.placement_constraints = input;
            self
        }
        /// Appends an item to `requires_compatibilities`.
        ///
        /// To override the contents of this collection use [`set_requires_compatibilities`](Self::set_requires_compatibilities).
        ///
        /// <p>The task launch type that Amazon ECS should validate the task definition against. A client
        /// exception is returned if the task definition doesn't validate against the
        /// compatibilities specified. If no value is specified, the parameter is omitted from the
        /// response.</p>
        pub fn requires_compatibilities(
            mut self,
            input: impl Into<crate::model::Compatibility>,
        ) -> Self {
            let mut v = self.requires_compatibilities.unwrap_or_default();
            v.push(input.into());
            self.requires_compatibilities = Some(v);
            self
        }
        /// <p>The task launch type that Amazon ECS should validate the task definition against. A client
        /// exception is returned if the task definition doesn't validate against the
        /// compatibilities specified. If no value is specified, the parameter is omitted from the
        /// response.</p>
        pub fn set_requires_compatibilities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Compatibility>>,
        ) -> Self {
            self.requires_compatibilities = input;
            self
        }
        /// <p>The number of CPU units used by the task. It can be expressed as an integer using CPU
        /// units, for example <code>1024</code>, or as a string using vCPUs, for example <code>1
        /// vCPU</code> or <code>1 vcpu</code>, in a task definition. String values are
        /// converted to an integer indicating the CPU units when the task definition is
        /// registered.</p>
        /// <note>
        /// <p>Task-level CPU and memory parameters are ignored for Windows containers. We
        /// recommend specifying container-level resources for Windows containers.</p>
        /// </note>
        /// <p>If you are using the EC2 launch type, this field is optional. Supported
        /// values are between <code>128</code> CPU units (<code>0.125</code> vCPUs) and
        /// <code>10240</code> CPU units (<code>10</code> vCPUs).</p>
        /// <p>If you are using the Fargate launch type, this field is required and you
        /// must use one of the following values, which determines your range of supported values
        /// for the <code>memory</code> parameter:</p>
        /// <ul>
        /// <li>
        /// <p>256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)</p>
        /// </li>
        /// <li>
        /// <p>512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)</p>
        /// </li>
        /// <li>
        /// <p>1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)</p>
        /// </li>
        /// <li>
        /// <p>2048 (2 vCPU) - Available <code>memory</code> values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)</p>
        /// </li>
        /// <li>
        /// <p>4096 (4 vCPU) - Available <code>memory</code> values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)</p>
        /// </li>
        /// </ul>
        pub fn cpu(mut self, input: impl Into<std::string::String>) -> Self {
            self.cpu = Some(input.into());
            self
        }
        /// <p>The number of CPU units used by the task. It can be expressed as an integer using CPU
        /// units, for example <code>1024</code>, or as a string using vCPUs, for example <code>1
        /// vCPU</code> or <code>1 vcpu</code>, in a task definition. String values are
        /// converted to an integer indicating the CPU units when the task definition is
        /// registered.</p>
        /// <note>
        /// <p>Task-level CPU and memory parameters are ignored for Windows containers. We
        /// recommend specifying container-level resources for Windows containers.</p>
        /// </note>
        /// <p>If you are using the EC2 launch type, this field is optional. Supported
        /// values are between <code>128</code> CPU units (<code>0.125</code> vCPUs) and
        /// <code>10240</code> CPU units (<code>10</code> vCPUs).</p>
        /// <p>If you are using the Fargate launch type, this field is required and you
        /// must use one of the following values, which determines your range of supported values
        /// for the <code>memory</code> parameter:</p>
        /// <ul>
        /// <li>
        /// <p>256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)</p>
        /// </li>
        /// <li>
        /// <p>512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)</p>
        /// </li>
        /// <li>
        /// <p>1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)</p>
        /// </li>
        /// <li>
        /// <p>2048 (2 vCPU) - Available <code>memory</code> values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)</p>
        /// </li>
        /// <li>
        /// <p>4096 (4 vCPU) - Available <code>memory</code> values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)</p>
        /// </li>
        /// </ul>
        pub fn set_cpu(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cpu = input;
            self
        }
        /// <p>The amount of memory (in MiB) used by the task. It can be expressed as an integer
        /// using MiB, for example <code>1024</code>, or as a string using GB, for example
        /// <code>1GB</code> or <code>1 GB</code>, in a task definition. String values are
        /// converted to an integer indicating the MiB when the task definition is
        /// registered.</p>
        /// <note>
        /// <p>Task-level CPU and memory parameters are ignored for Windows containers. We
        /// recommend specifying container-level resources for Windows containers.</p>
        /// </note>
        /// <p>If using the EC2 launch type, this field is optional.</p>
        /// <p>If using the Fargate launch type, this field is required and you must
        /// use one of the following values, which determines your range of supported values for the
        /// <code>cpu</code> parameter:</p>
        /// <ul>
        /// <li>
        /// <p>512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available <code>cpu</code> values: 1024 (1 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4 vCPU)</p>
        /// </li>
        /// </ul>
        pub fn memory(mut self, input: impl Into<std::string::String>) -> Self {
            self.memory = Some(input.into());
            self
        }
        /// <p>The amount of memory (in MiB) used by the task. It can be expressed as an integer
        /// using MiB, for example <code>1024</code>, or as a string using GB, for example
        /// <code>1GB</code> or <code>1 GB</code>, in a task definition. String values are
        /// converted to an integer indicating the MiB when the task definition is
        /// registered.</p>
        /// <note>
        /// <p>Task-level CPU and memory parameters are ignored for Windows containers. We
        /// recommend specifying container-level resources for Windows containers.</p>
        /// </note>
        /// <p>If using the EC2 launch type, this field is optional.</p>
        /// <p>If using the Fargate launch type, this field is required and you must
        /// use one of the following values, which determines your range of supported values for the
        /// <code>cpu</code> parameter:</p>
        /// <ul>
        /// <li>
        /// <p>512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available <code>cpu</code> values: 1024 (1 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2 vCPU)</p>
        /// </li>
        /// <li>
        /// <p>Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4 vCPU)</p>
        /// </li>
        /// </ul>
        pub fn set_memory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.memory = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the task definition to help you categorize and organize
        /// them. Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The metadata that you apply to the task definition to help you categorize and organize
        /// them. Each tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The process namespace to use for the containers in the task. The valid
        /// values are <code>host</code> or <code>task</code>. If <code>host</code>
        /// is specified, then all containers within the tasks that specified the
        /// <code>host</code> PID mode on the same container instance share the
        /// same process namespace with the host Amazon EC2 instance. If <code>task</code> is
        /// specified, all containers within the specified task share the same
        /// process namespace. If no value is specified, the default is a private
        /// namespace. For more information, see <a href="https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the <i>Docker run
        /// reference</i>.</p>
        /// <p>If the <code>host</code> PID mode is used, be aware that there is a
        /// heightened risk of undesired process namespace expose. For more
        /// information, see <a href="https://docs.docker.com/engine/security/security/">Docker
        /// security</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
        /// </note>
        pub fn pid_mode(mut self, input: crate::model::PidMode) -> Self {
            self.pid_mode = Some(input);
            self
        }
        /// <p>The process namespace to use for the containers in the task. The valid
        /// values are <code>host</code> or <code>task</code>. If <code>host</code>
        /// is specified, then all containers within the tasks that specified the
        /// <code>host</code> PID mode on the same container instance share the
        /// same process namespace with the host Amazon EC2 instance. If <code>task</code> is
        /// specified, all containers within the specified task share the same
        /// process namespace. If no value is specified, the default is a private
        /// namespace. For more information, see <a href="https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the <i>Docker run
        /// reference</i>.</p>
        /// <p>If the <code>host</code> PID mode is used, be aware that there is a
        /// heightened risk of undesired process namespace expose. For more
        /// information, see <a href="https://docs.docker.com/engine/security/security/">Docker
        /// security</a>.</p>
        /// <note>
        /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
        /// </note>
        pub fn set_pid_mode(mut self, input: std::option::Option<crate::model::PidMode>) -> Self {
            self.pid_mode = input;
            self
        }
        /// <p>The IPC resource namespace to use for the containers in the task. The valid values are
        /// <code>host</code>, <code>task</code>, or <code>none</code>. If <code>host</code> is
        /// specified, then all containers within the tasks that specified the <code>host</code> IPC
        /// mode on the same container instance share the same IPC resources with the host Amazon EC2
        /// instance. If <code>task</code> is specified, all containers within the specified task
        /// share the same IPC resources. If <code>none</code> is specified, then IPC resources
        /// within the containers of a task are private and not shared with other containers in a
        /// task or on the container instance. If no value is specified, then the IPC resource
        /// namespace sharing depends on the Docker daemon setting on the container instance. For
        /// more information, see <a href="https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC
        /// settings</a> in the <i>Docker run reference</i>.</p>
        /// <p>If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of
        /// undesired IPC namespace expose. For more information, see <a href="https://docs.docker.com/engine/security/security/">Docker
        /// security</a>.</p>
        /// <p>If you are setting namespaced kernel parameters using <code>systemControls</code> for
        /// the containers in the task, the following will apply to your IPC resource namespace. For
        /// more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System
        /// Controls</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <ul>
        /// <li>
        /// <p>For tasks that use the <code>host</code> IPC mode, IPC namespace related
        /// <code>systemControls</code> are not supported.</p>
        /// </li>
        /// <li>
        /// <p>For tasks that use the <code>task</code> IPC mode, IPC namespace related
        /// <code>systemControls</code> will apply to all containers within a
        /// task.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
        /// </note>
        pub fn ipc_mode(mut self, input: crate::model::IpcMode) -> Self {
            self.ipc_mode = Some(input);
            self
        }
        /// <p>The IPC resource namespace to use for the containers in the task. The valid values are
        /// <code>host</code>, <code>task</code>, or <code>none</code>. If <code>host</code> is
        /// specified, then all containers within the tasks that specified the <code>host</code> IPC
        /// mode on the same container instance share the same IPC resources with the host Amazon EC2
        /// instance. If <code>task</code> is specified, all containers within the specified task
        /// share the same IPC resources. If <code>none</code> is specified, then IPC resources
        /// within the containers of a task are private and not shared with other containers in a
        /// task or on the container instance. If no value is specified, then the IPC resource
        /// namespace sharing depends on the Docker daemon setting on the container instance. For
        /// more information, see <a href="https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC
        /// settings</a> in the <i>Docker run reference</i>.</p>
        /// <p>If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of
        /// undesired IPC namespace expose. For more information, see <a href="https://docs.docker.com/engine/security/security/">Docker
        /// security</a>.</p>
        /// <p>If you are setting namespaced kernel parameters using <code>systemControls</code> for
        /// the containers in the task, the following will apply to your IPC resource namespace. For
        /// more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System
        /// Controls</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <ul>
        /// <li>
        /// <p>For tasks that use the <code>host</code> IPC mode, IPC namespace related
        /// <code>systemControls</code> are not supported.</p>
        /// </li>
        /// <li>
        /// <p>For tasks that use the <code>task</code> IPC mode, IPC namespace related
        /// <code>systemControls</code> will apply to all containers within a
        /// task.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
        /// </note>
        pub fn set_ipc_mode(mut self, input: std::option::Option<crate::model::IpcMode>) -> Self {
            self.ipc_mode = input;
            self
        }
        /// <p>The configuration details for the App Mesh proxy.</p>
        /// <p>For tasks hosted on Amazon EC2 instances, the container instances require at least version
        /// <code>1.26.0</code> of the container agent and at least version
        /// <code>1.26.0-1</code> of the <code>ecs-init</code> package to enable a proxy
        /// configuration. If your container instances are launched from the Amazon ECS-optimized
        /// AMI version <code>20190301</code> or later, then they contain the required versions of
        /// the container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-ami-versions.html">Amazon ECS-optimized AMI versions</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn proxy_configuration(mut self, input: crate::model::ProxyConfiguration) -> Self {
            self.proxy_configuration = Some(input);
            self
        }
        /// <p>The configuration details for the App Mesh proxy.</p>
        /// <p>For tasks hosted on Amazon EC2 instances, the container instances require at least version
        /// <code>1.26.0</code> of the container agent and at least version
        /// <code>1.26.0-1</code> of the <code>ecs-init</code> package to enable a proxy
        /// configuration. If your container instances are launched from the Amazon ECS-optimized
        /// AMI version <code>20190301</code> or later, then they contain the required versions of
        /// the container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-ami-versions.html">Amazon ECS-optimized AMI versions</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_proxy_configuration(
            mut self,
            input: std::option::Option<crate::model::ProxyConfiguration>,
        ) -> Self {
            self.proxy_configuration = input;
            self
        }
        /// Appends an item to `inference_accelerators`.
        ///
        /// To override the contents of this collection use [`set_inference_accelerators`](Self::set_inference_accelerators).
        ///
        /// <p>The Elastic Inference accelerators to use for the containers in the task.</p>
        pub fn inference_accelerators(
            mut self,
            input: impl Into<crate::model::InferenceAccelerator>,
        ) -> Self {
            let mut v = self.inference_accelerators.unwrap_or_default();
            v.push(input.into());
            self.inference_accelerators = Some(v);
            self
        }
        /// <p>The Elastic Inference accelerators to use for the containers in the task.</p>
        pub fn set_inference_accelerators(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InferenceAccelerator>>,
        ) -> Self {
            self.inference_accelerators = input;
            self
        }
        /// <p>The amount of ephemeral storage to allocate for the task. This parameter is used to
        /// expand the total amount of ephemeral storage available, beyond the default amount, for
        /// tasks hosted on Fargate. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/using_data_volumes.html">Fargate task
        /// storage</a> in the <i>Amazon ECS User Guide for Fargate</i>.</p>
        /// <note>
        /// <p>This parameter is only supported for tasks hosted on Fargate using the following platform versions:</p>
        /// <ul>
        /// <li>
        /// <p>Linux platform
        /// version <code>1.4.0</code> or later.</p>
        /// </li>
        /// <li>
        /// <p>Windows platform
        /// version <code>1.0.0</code> or later.</p>
        /// </li>
        /// </ul>
        /// </note>
        pub fn ephemeral_storage(mut self, input: crate::model::EphemeralStorage) -> Self {
            self.ephemeral_storage = Some(input);
            self
        }
        /// <p>The amount of ephemeral storage to allocate for the task. This parameter is used to
        /// expand the total amount of ephemeral storage available, beyond the default amount, for
        /// tasks hosted on Fargate. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/using_data_volumes.html">Fargate task
        /// storage</a> in the <i>Amazon ECS User Guide for Fargate</i>.</p>
        /// <note>
        /// <p>This parameter is only supported for tasks hosted on Fargate using the following platform versions:</p>
        /// <ul>
        /// <li>
        /// <p>Linux platform
        /// version <code>1.4.0</code> or later.</p>
        /// </li>
        /// <li>
        /// <p>Windows platform
        /// version <code>1.0.0</code> or later.</p>
        /// </li>
        /// </ul>
        /// </note>
        pub fn set_ephemeral_storage(
            mut self,
            input: std::option::Option<crate::model::EphemeralStorage>,
        ) -> Self {
            self.ephemeral_storage = input;
            self
        }
        /// <p>The operating system  that your tasks definitions run on. A platform family is specified only for tasks using the Fargate launch type. </p>
        /// <p>When you specify a task definition in a service, this value must match the <code>runtimePlatform</code> value of the service.</p>
        pub fn runtime_platform(mut self, input: crate::model::RuntimePlatform) -> Self {
            self.runtime_platform = Some(input);
            self
        }
        /// <p>The operating system  that your tasks definitions run on. A platform family is specified only for tasks using the Fargate launch type. </p>
        /// <p>When you specify a task definition in a service, this value must match the <code>runtimePlatform</code> value of the service.</p>
        pub fn set_runtime_platform(
            mut self,
            input: std::option::Option<crate::model::RuntimePlatform>,
        ) -> Self {
            self.runtime_platform = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterTaskDefinitionInput`](crate::input::RegisterTaskDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterTaskDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterTaskDefinitionInput {
                family: self.family,
                task_role_arn: self.task_role_arn,
                execution_role_arn: self.execution_role_arn,
                network_mode: self.network_mode,
                container_definitions: self.container_definitions,
                volumes: self.volumes,
                placement_constraints: self.placement_constraints,
                requires_compatibilities: self.requires_compatibilities,
                cpu: self.cpu,
                memory: self.memory,
                tags: self.tags,
                pid_mode: self.pid_mode,
                ipc_mode: self.ipc_mode,
                proxy_configuration: self.proxy_configuration,
                inference_accelerators: self.inference_accelerators,
                ephemeral_storage: self.ephemeral_storage,
                runtime_platform: self.runtime_platform,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterTaskDefinitionInputOperationOutputAlias = crate::operation::RegisterTaskDefinition;
#[doc(hidden)]
pub type RegisterTaskDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterTaskDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`RegisterTaskDefinition`](crate::operation::RegisterTaskDefinition)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterTaskDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterTaskDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterTaskDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterTaskDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.RegisterTaskDefinition",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_task_definition(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterTaskDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterTaskDefinition",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterTaskDefinitionInput`](crate::input::RegisterTaskDefinitionInput)
    pub fn builder() -> crate::input::register_task_definition_input::Builder {
        crate::input::register_task_definition_input::Builder::default()
    }
}

/// See [`RunTaskInput`](crate::input::RunTaskInput)
pub mod run_task_input {
    /// A builder for [`RunTaskInput`](crate::input::RunTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity_provider_strategy:
            std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) count: std::option::Option<i32>,
        pub(crate) enable_ecs_managed_tags: std::option::Option<bool>,
        pub(crate) enable_execute_command: std::option::Option<bool>,
        pub(crate) group: std::option::Option<std::string::String>,
        pub(crate) launch_type: std::option::Option<crate::model::LaunchType>,
        pub(crate) network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
        pub(crate) overrides: std::option::Option<crate::model::TaskOverride>,
        pub(crate) placement_constraints:
            std::option::Option<std::vec::Vec<crate::model::PlacementConstraint>>,
        pub(crate) placement_strategy:
            std::option::Option<std::vec::Vec<crate::model::PlacementStrategy>>,
        pub(crate) platform_version: std::option::Option<std::string::String>,
        pub(crate) propagate_tags: std::option::Option<crate::model::PropagateTags>,
        pub(crate) reference_id: std::option::Option<std::string::String>,
        pub(crate) started_by: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) task_definition: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `capacity_provider_strategy`.
        ///
        /// To override the contents of this collection use [`set_capacity_provider_strategy`](Self::set_capacity_provider_strategy).
        ///
        /// <p>The capacity provider strategy to use for the task.</p>
        /// <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code>
        /// parameter must be omitted. If no <code>capacityProviderStrategy</code> or
        /// <code>launchType</code> is specified, the
        /// <code>defaultCapacityProviderStrategy</code> for the cluster is used.</p>
        /// <p>When you use cluster auto scaling, you must specify <code>capacityProviderStrategy</code> and not <code>launchType</code>. </p>
        /// <p>A capacity provider strategy may contain a maximum of 6 capacity providers.</p>
        pub fn capacity_provider_strategy(
            mut self,
            input: impl Into<crate::model::CapacityProviderStrategyItem>,
        ) -> Self {
            let mut v = self.capacity_provider_strategy.unwrap_or_default();
            v.push(input.into());
            self.capacity_provider_strategy = Some(v);
            self
        }
        /// <p>The capacity provider strategy to use for the task.</p>
        /// <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code>
        /// parameter must be omitted. If no <code>capacityProviderStrategy</code> or
        /// <code>launchType</code> is specified, the
        /// <code>defaultCapacityProviderStrategy</code> for the cluster is used.</p>
        /// <p>When you use cluster auto scaling, you must specify <code>capacityProviderStrategy</code> and not <code>launchType</code>. </p>
        /// <p>A capacity provider strategy may contain a maximum of 6 capacity providers.</p>
        pub fn set_capacity_provider_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        ) -> Self {
            self.capacity_provider_strategy = input;
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster on which to run your task.
        /// If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster on which to run your task.
        /// If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>The number of instantiations of the specified task to place on your cluster. You can
        /// specify up to 10 tasks per call.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The number of instantiations of the specified task to place on your cluster. You can
        /// specify up to 10 tasks per call.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// <p>Specifies whether to enable Amazon ECS managed tags for the task. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS
        /// Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn enable_ecs_managed_tags(mut self, input: bool) -> Self {
            self.enable_ecs_managed_tags = Some(input);
            self
        }
        /// <p>Specifies whether to enable Amazon ECS managed tags for the task. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS
        /// Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_enable_ecs_managed_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_ecs_managed_tags = input;
            self
        }
        /// <p>Whether or not to enable the execute command functionality for the containers in this
        /// task. If <code>true</code>, this enables execute command functionality on all containers
        /// in the task.</p>
        pub fn enable_execute_command(mut self, input: bool) -> Self {
            self.enable_execute_command = Some(input);
            self
        }
        /// <p>Whether or not to enable the execute command functionality for the containers in this
        /// task. If <code>true</code>, this enables execute command functionality on all containers
        /// in the task.</p>
        pub fn set_enable_execute_command(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_execute_command = input;
            self
        }
        /// <p>The name of the task group to associate with the task. The default value is the family
        /// name of the task definition (for example, <code>family:my-family-name</code>).</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The name of the task group to associate with the task. The default value is the family
        /// name of the task definition (for example, <code>family:my-family-name</code>).</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// <p>The infrastructure on which to run your standalone task. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand
        /// infrastructure.</p>
        /// <note>
        /// <p>Fargate Spot infrastructure is available for use but a capacity provider
        /// strategy must be used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html">Fargate capacity providers</a> in the
        /// <i>Amazon ECS User Guide for Fargate</i>.</p>
        /// </note>
        /// <p>The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your
        /// cluster.</p>
        /// <p>The <code>EXTERNAL</code> launch type runs your tasks on your on-premise server or
        /// virtual machine (VM) capacity registered to your cluster.</p>
        /// <p>A task can use either a launch type or a capacity provider strategy. If a
        /// <code>launchType</code> is specified, the <code>capacityProviderStrategy</code>
        /// parameter must be omitted.</p>
        /// <p>When you use cluster auto scaling, you must specify <code>capacityProviderStrategy</code> and not <code>launchType</code>. </p>
        pub fn launch_type(mut self, input: crate::model::LaunchType) -> Self {
            self.launch_type = Some(input);
            self
        }
        /// <p>The infrastructure on which to run your standalone task. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        /// <p>The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand
        /// infrastructure.</p>
        /// <note>
        /// <p>Fargate Spot infrastructure is available for use but a capacity provider
        /// strategy must be used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html">Fargate capacity providers</a> in the
        /// <i>Amazon ECS User Guide for Fargate</i>.</p>
        /// </note>
        /// <p>The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your
        /// cluster.</p>
        /// <p>The <code>EXTERNAL</code> launch type runs your tasks on your on-premise server or
        /// virtual machine (VM) capacity registered to your cluster.</p>
        /// <p>A task can use either a launch type or a capacity provider strategy. If a
        /// <code>launchType</code> is specified, the <code>capacityProviderStrategy</code>
        /// parameter must be omitted.</p>
        /// <p>When you use cluster auto scaling, you must specify <code>capacityProviderStrategy</code> and not <code>launchType</code>. </p>
        pub fn set_launch_type(
            mut self,
            input: std::option::Option<crate::model::LaunchType>,
        ) -> Self {
            self.launch_type = input;
            self
        }
        /// <p>The network configuration for the task. This parameter is required for task
        /// definitions that use the <code>awsvpc</code> network mode to receive their own elastic
        /// network interface, and it is not supported for other network modes. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task networking</a>
        /// in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn network_configuration(mut self, input: crate::model::NetworkConfiguration) -> Self {
            self.network_configuration = Some(input);
            self
        }
        /// <p>The network configuration for the task. This parameter is required for task
        /// definitions that use the <code>awsvpc</code> network mode to receive their own elastic
        /// network interface, and it is not supported for other network modes. For more
        /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task networking</a>
        /// in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkConfiguration>,
        ) -> Self {
            self.network_configuration = input;
            self
        }
        /// <p>A list of container overrides in JSON format that specify the name of a container in
        /// the specified task definition and the overrides it should receive. You can override the
        /// default command for a container (that is specified in the task definition or Docker
        /// image) with a <code>command</code> override. You can also override existing environment
        /// variables (that are specified in the task definition or Docker image) on a container or
        /// add new environment variables to it with an <code>environment</code> override.</p>
        /// <p>A total of 8192 characters are allowed for overrides. This limit includes the JSON
        /// formatting characters of the override structure.</p>
        pub fn overrides(mut self, input: crate::model::TaskOverride) -> Self {
            self.overrides = Some(input);
            self
        }
        /// <p>A list of container overrides in JSON format that specify the name of a container in
        /// the specified task definition and the overrides it should receive. You can override the
        /// default command for a container (that is specified in the task definition or Docker
        /// image) with a <code>command</code> override. You can also override existing environment
        /// variables (that are specified in the task definition or Docker image) on a container or
        /// add new environment variables to it with an <code>environment</code> override.</p>
        /// <p>A total of 8192 characters are allowed for overrides. This limit includes the JSON
        /// formatting characters of the override structure.</p>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<crate::model::TaskOverride>,
        ) -> Self {
            self.overrides = input;
            self
        }
        /// Appends an item to `placement_constraints`.
        ///
        /// To override the contents of this collection use [`set_placement_constraints`](Self::set_placement_constraints).
        ///
        /// <p>An array of placement constraint objects to use for the task. You can specify up to 10
        /// constraints per task (including constraints in the task definition and those specified
        /// at runtime).</p>
        pub fn placement_constraints(
            mut self,
            input: impl Into<crate::model::PlacementConstraint>,
        ) -> Self {
            let mut v = self.placement_constraints.unwrap_or_default();
            v.push(input.into());
            self.placement_constraints = Some(v);
            self
        }
        /// <p>An array of placement constraint objects to use for the task. You can specify up to 10
        /// constraints per task (including constraints in the task definition and those specified
        /// at runtime).</p>
        pub fn set_placement_constraints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementConstraint>>,
        ) -> Self {
            self.placement_constraints = input;
            self
        }
        /// Appends an item to `placement_strategy`.
        ///
        /// To override the contents of this collection use [`set_placement_strategy`](Self::set_placement_strategy).
        ///
        /// <p>The placement strategy objects to use for the task. You can specify a maximum of 5
        /// strategy rules per task.</p>
        pub fn placement_strategy(
            mut self,
            input: impl Into<crate::model::PlacementStrategy>,
        ) -> Self {
            let mut v = self.placement_strategy.unwrap_or_default();
            v.push(input.into());
            self.placement_strategy = Some(v);
            self
        }
        /// <p>The placement strategy objects to use for the task. You can specify a maximum of 5
        /// strategy rules per task.</p>
        pub fn set_placement_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementStrategy>>,
        ) -> Self {
            self.placement_strategy = input;
            self
        }
        /// <p>The platform version the task should use. A platform version is only specified for
        /// tasks hosted on Fargate. If one is not specified, the <code>LATEST</code>
        /// platform version is used by default. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate platform versions</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_version = Some(input.into());
            self
        }
        /// <p>The platform version the task should use. A platform version is only specified for
        /// tasks hosted on Fargate. If one is not specified, the <code>LATEST</code>
        /// platform version is used by default. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate platform versions</a> in the
        /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_version = input;
            self
        }
        /// <p>Specifies whether to propagate the tags from the task definition to the task. If no
        /// value is specified, the tags are not propagated. Tags can only be propagated to the task
        /// during task creation. To add tags to a task after task creation, use the <a>TagResource</a> API action.</p>
        /// <note>
        /// <p>An error will be received if you specify the <code>SERVICE</code> option when
        /// running a task.</p>
        /// </note>
        pub fn propagate_tags(mut self, input: crate::model::PropagateTags) -> Self {
            self.propagate_tags = Some(input);
            self
        }
        /// <p>Specifies whether to propagate the tags from the task definition to the task. If no
        /// value is specified, the tags are not propagated. Tags can only be propagated to the task
        /// during task creation. To add tags to a task after task creation, use the <a>TagResource</a> API action.</p>
        /// <note>
        /// <p>An error will be received if you specify the <code>SERVICE</code> option when
        /// running a task.</p>
        /// </note>
        pub fn set_propagate_tags(
            mut self,
            input: std::option::Option<crate::model::PropagateTags>,
        ) -> Self {
            self.propagate_tags = input;
            self
        }
        /// <p>The reference ID to use for the task. The reference ID can have a maximum length of
        /// 1024 characters.</p>
        pub fn reference_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reference_id = Some(input.into());
            self
        }
        /// <p>The reference ID to use for the task. The reference ID can have a maximum length of
        /// 1024 characters.</p>
        pub fn set_reference_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reference_id = input;
            self
        }
        /// <p>An optional tag specified when a task is started. For example, if you automatically
        /// trigger a task to run a batch process job, you could apply a unique identifier for that
        /// job to your task with the <code>startedBy</code> parameter. You can then identify which
        /// tasks belong to that job by filtering the results of a <a>ListTasks</a> call
        /// with the <code>startedBy</code> value. Up to 36 letters (uppercase and lowercase),
        /// numbers, hyphens, and underscores are allowed.</p>
        /// <p>If a task is started by an Amazon ECS service, then the <code>startedBy</code> parameter
        /// contains the deployment ID of the service that starts it.</p>
        pub fn started_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.started_by = Some(input.into());
            self
        }
        /// <p>An optional tag specified when a task is started. For example, if you automatically
        /// trigger a task to run a batch process job, you could apply a unique identifier for that
        /// job to your task with the <code>startedBy</code> parameter. You can then identify which
        /// tasks belong to that job by filtering the results of a <a>ListTasks</a> call
        /// with the <code>startedBy</code> value. Up to 36 letters (uppercase and lowercase),
        /// numbers, hyphens, and underscores are allowed.</p>
        /// <p>If a task is started by an Amazon ECS service, then the <code>startedBy</code> parameter
        /// contains the deployment ID of the service that starts it.</p>
        pub fn set_started_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.started_by = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the task to help you categorize and organize them. Each
        /// tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The metadata that you apply to the task to help you categorize and organize them. Each
        /// tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or
        /// full ARN of the task definition to run. If a <code>revision</code> is not specified,
        /// the latest <code>ACTIVE</code> revision is used.</p>
        /// <p>The full ARN value must match the value that you specified ias the <code>Resource</code>
        /// of the IAM principal's permissions policy. For example, if the <code>Resource</code> is
        /// arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:*, the
        /// <code>taskDefinition</code> ARN value must be
        /// <code>arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName</code>.</p>
        pub fn task_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_definition = Some(input.into());
            self
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or
        /// full ARN of the task definition to run. If a <code>revision</code> is not specified,
        /// the latest <code>ACTIVE</code> revision is used.</p>
        /// <p>The full ARN value must match the value that you specified ias the <code>Resource</code>
        /// of the IAM principal's permissions policy. For example, if the <code>Resource</code> is
        /// arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:*, the
        /// <code>taskDefinition</code> ARN value must be
        /// <code>arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName</code>.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`RunTaskInput`](crate::input::RunTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::RunTaskInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::RunTaskInput {
                capacity_provider_strategy: self.capacity_provider_strategy,
                cluster: self.cluster,
                count: self.count,
                enable_ecs_managed_tags: self.enable_ecs_managed_tags.unwrap_or_default(),
                enable_execute_command: self.enable_execute_command.unwrap_or_default(),
                group: self.group,
                launch_type: self.launch_type,
                network_configuration: self.network_configuration,
                overrides: self.overrides,
                placement_constraints: self.placement_constraints,
                placement_strategy: self.placement_strategy,
                platform_version: self.platform_version,
                propagate_tags: self.propagate_tags,
                reference_id: self.reference_id,
                started_by: self.started_by,
                tags: self.tags,
                task_definition: self.task_definition,
            })
        }
    }
}
#[doc(hidden)]
pub type RunTaskInputOperationOutputAlias = crate::operation::RunTask;
#[doc(hidden)]
pub type RunTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RunTaskInput {
    /// Consumes the builder and constructs an Operation<[`RunTask`](crate::operation::RunTask)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RunTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RunTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RunTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RunTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.RunTask",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_run_task(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::RunTask::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("RunTask", "ecs"));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RunTaskInput`](crate::input::RunTaskInput)
    pub fn builder() -> crate::input::run_task_input::Builder {
        crate::input::run_task_input::Builder::default()
    }
}

/// See [`StartTaskInput`](crate::input::StartTaskInput)
pub mod start_task_input {
    /// A builder for [`StartTaskInput`](crate::input::StartTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) container_instances: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enable_ecs_managed_tags: std::option::Option<bool>,
        pub(crate) enable_execute_command: std::option::Option<bool>,
        pub(crate) group: std::option::Option<std::string::String>,
        pub(crate) network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
        pub(crate) overrides: std::option::Option<crate::model::TaskOverride>,
        pub(crate) propagate_tags: std::option::Option<crate::model::PropagateTags>,
        pub(crate) reference_id: std::option::Option<std::string::String>,
        pub(crate) started_by: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) task_definition: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster on which to start your task.
        /// If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster on which to start your task.
        /// If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// Appends an item to `container_instances`.
        ///
        /// To override the contents of this collection use [`set_container_instances`](Self::set_container_instances).
        ///
        /// <p>The container instance IDs or full ARN entries for the container instances on which
        /// you would like to place your task. You can specify up to 10 container instances.</p>
        pub fn container_instances(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.container_instances.unwrap_or_default();
            v.push(input.into());
            self.container_instances = Some(v);
            self
        }
        /// <p>The container instance IDs or full ARN entries for the container instances on which
        /// you would like to place your task. You can specify up to 10 container instances.</p>
        pub fn set_container_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.container_instances = input;
            self
        }
        /// <p>Specifies whether to enable Amazon ECS managed tags for the task. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS
        /// Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn enable_ecs_managed_tags(mut self, input: bool) -> Self {
            self.enable_ecs_managed_tags = Some(input);
            self
        }
        /// <p>Specifies whether to enable Amazon ECS managed tags for the task. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS
        /// Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_enable_ecs_managed_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_ecs_managed_tags = input;
            self
        }
        /// <p>Whether or not the execute command functionality is enabled for the task. If
        /// <code>true</code>, this enables execute command functionality on all containers in
        /// the task.</p>
        pub fn enable_execute_command(mut self, input: bool) -> Self {
            self.enable_execute_command = Some(input);
            self
        }
        /// <p>Whether or not the execute command functionality is enabled for the task. If
        /// <code>true</code>, this enables execute command functionality on all containers in
        /// the task.</p>
        pub fn set_enable_execute_command(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_execute_command = input;
            self
        }
        /// <p>The name of the task group to associate with the task. The default value is the family
        /// name of the task definition (for example, family:my-family-name).</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The name of the task group to associate with the task. The default value is the family
        /// name of the task definition (for example, family:my-family-name).</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// <p>The VPC subnet and security group configuration for tasks that receive their own
        /// elastic network interface by using the <code>awsvpc</code> networking mode.</p>
        pub fn network_configuration(mut self, input: crate::model::NetworkConfiguration) -> Self {
            self.network_configuration = Some(input);
            self
        }
        /// <p>The VPC subnet and security group configuration for tasks that receive their own
        /// elastic network interface by using the <code>awsvpc</code> networking mode.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkConfiguration>,
        ) -> Self {
            self.network_configuration = input;
            self
        }
        /// <p>A list of container overrides in JSON format that specify the name of a container in
        /// the specified task definition and the overrides it should receive. You can override the
        /// default command for a container (that is specified in the task definition or Docker
        /// image) with a <code>command</code> override. You can also override existing environment
        /// variables (that are specified in the task definition or Docker image) on a container or
        /// add new environment variables to it with an <code>environment</code> override.</p>
        /// <note>
        /// <p>A total of 8192 characters are allowed for overrides. This limit includes the JSON
        /// formatting characters of the override structure.</p>
        /// </note>
        pub fn overrides(mut self, input: crate::model::TaskOverride) -> Self {
            self.overrides = Some(input);
            self
        }
        /// <p>A list of container overrides in JSON format that specify the name of a container in
        /// the specified task definition and the overrides it should receive. You can override the
        /// default command for a container (that is specified in the task definition or Docker
        /// image) with a <code>command</code> override. You can also override existing environment
        /// variables (that are specified in the task definition or Docker image) on a container or
        /// add new environment variables to it with an <code>environment</code> override.</p>
        /// <note>
        /// <p>A total of 8192 characters are allowed for overrides. This limit includes the JSON
        /// formatting characters of the override structure.</p>
        /// </note>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<crate::model::TaskOverride>,
        ) -> Self {
            self.overrides = input;
            self
        }
        /// <p>Specifies whether to propagate the tags from the task definition or the service to the
        /// task. If no value is specified, the tags are not propagated.</p>
        pub fn propagate_tags(mut self, input: crate::model::PropagateTags) -> Self {
            self.propagate_tags = Some(input);
            self
        }
        /// <p>Specifies whether to propagate the tags from the task definition or the service to the
        /// task. If no value is specified, the tags are not propagated.</p>
        pub fn set_propagate_tags(
            mut self,
            input: std::option::Option<crate::model::PropagateTags>,
        ) -> Self {
            self.propagate_tags = input;
            self
        }
        /// <p>The reference ID to use for the task.</p>
        pub fn reference_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reference_id = Some(input.into());
            self
        }
        /// <p>The reference ID to use for the task.</p>
        pub fn set_reference_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reference_id = input;
            self
        }
        /// <p>An optional tag specified when a task is started. For example, if you automatically
        /// trigger a task to run a batch process job, you could apply a unique identifier for that
        /// job to your task with the <code>startedBy</code> parameter. You can then identify which
        /// tasks belong to that job by filtering the results of a <a>ListTasks</a> call
        /// with the <code>startedBy</code> value. Up to 36 letters (uppercase and lowercase),
        /// numbers, hyphens, and underscores are allowed.</p>
        /// <p>If a task is started by an Amazon ECS service, then the <code>startedBy</code> parameter
        /// contains the deployment ID of the service that starts it.</p>
        pub fn started_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.started_by = Some(input.into());
            self
        }
        /// <p>An optional tag specified when a task is started. For example, if you automatically
        /// trigger a task to run a batch process job, you could apply a unique identifier for that
        /// job to your task with the <code>startedBy</code> parameter. You can then identify which
        /// tasks belong to that job by filtering the results of a <a>ListTasks</a> call
        /// with the <code>startedBy</code> value. Up to 36 letters (uppercase and lowercase),
        /// numbers, hyphens, and underscores are allowed.</p>
        /// <p>If a task is started by an Amazon ECS service, then the <code>startedBy</code> parameter
        /// contains the deployment ID of the service that starts it.</p>
        pub fn set_started_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.started_by = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the task to help you categorize and organize them. Each
        /// tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The metadata that you apply to the task to help you categorize and organize them. Each
        /// tag consists of a key and an optional value, both of which you define.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or
        /// full ARN of the task definition to start. If a <code>revision</code> is not specified,
        /// the latest <code>ACTIVE</code> revision is used.</p>
        pub fn task_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_definition = Some(input.into());
            self
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or
        /// full ARN of the task definition to start. If a <code>revision</code> is not specified,
        /// the latest <code>ACTIVE</code> revision is used.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTaskInput`](crate::input::StartTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::StartTaskInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::StartTaskInput {
                cluster: self.cluster,
                container_instances: self.container_instances,
                enable_ecs_managed_tags: self.enable_ecs_managed_tags.unwrap_or_default(),
                enable_execute_command: self.enable_execute_command.unwrap_or_default(),
                group: self.group,
                network_configuration: self.network_configuration,
                overrides: self.overrides,
                propagate_tags: self.propagate_tags,
                reference_id: self.reference_id,
                started_by: self.started_by,
                tags: self.tags,
                task_definition: self.task_definition,
            })
        }
    }
}
#[doc(hidden)]
pub type StartTaskInputOperationOutputAlias = crate::operation::StartTask;
#[doc(hidden)]
pub type StartTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartTaskInput {
    /// Consumes the builder and constructs an Operation<[`StartTask`](crate::operation::StartTask)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.StartTask",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_start_task(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::StartTask::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "StartTask",
                    "ecs",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartTaskInput`](crate::input::StartTaskInput)
    pub fn builder() -> crate::input::start_task_input::Builder {
        crate::input::start_task_input::Builder::default()
    }
}

/// See [`StopTaskInput`](crate::input::StopTaskInput)
pub mod stop_task_input {
    /// A builder for [`StopTaskInput`](crate::input::StopTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) task: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task to stop.
        /// If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task to stop.
        /// If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>The task ID or full Amazon Resource Name (ARN) of the task to stop.</p>
        pub fn task(mut self, input: impl Into<std::string::String>) -> Self {
            self.task = Some(input.into());
            self
        }
        /// <p>The task ID or full Amazon Resource Name (ARN) of the task to stop.</p>
        pub fn set_task(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task = input;
            self
        }
        /// <p>An optional message specified when a task is stopped. For example, if you are using a
        /// custom scheduler, you can use this parameter to specify the reason for stopping the task
        /// here, and the message appears in subsequent <a>DescribeTasks</a> API
        /// operations on this task. Up to 255 characters are allowed in this message.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>An optional message specified when a task is stopped. For example, if you are using a
        /// custom scheduler, you can use this parameter to specify the reason for stopping the task
        /// here, and the message appears in subsequent <a>DescribeTasks</a> API
        /// operations on this task. Up to 255 characters are allowed in this message.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`StopTaskInput`](crate::input::StopTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::StopTaskInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::StopTaskInput {
                cluster: self.cluster,
                task: self.task,
                reason: self.reason,
            })
        }
    }
}
#[doc(hidden)]
pub type StopTaskInputOperationOutputAlias = crate::operation::StopTask;
#[doc(hidden)]
pub type StopTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopTaskInput {
    /// Consumes the builder and constructs an Operation<[`StopTask`](crate::operation::StopTask)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.StopTask",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_stop_task(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::StopTask::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("StopTask", "ecs"));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopTaskInput`](crate::input::StopTaskInput)
    pub fn builder() -> crate::input::stop_task_input::Builder {
        crate::input::stop_task_input::Builder::default()
    }
}

/// See [`SubmitAttachmentStateChangesInput`](crate::input::SubmitAttachmentStateChangesInput)
pub mod submit_attachment_state_changes_input {
    /// A builder for [`SubmitAttachmentStateChangesInput`](crate::input::SubmitAttachmentStateChangesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) attachments:
            std::option::Option<std::vec::Vec<crate::model::AttachmentStateChange>>,
    }
    impl Builder {
        /// <p>The short name or full ARN of the cluster that hosts the container instance the
        /// attachment belongs to.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full ARN of the cluster that hosts the container instance the
        /// attachment belongs to.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// Appends an item to `attachments`.
        ///
        /// To override the contents of this collection use [`set_attachments`](Self::set_attachments).
        ///
        /// <p>Any attachments associated with the state change request.</p>
        pub fn attachments(
            mut self,
            input: impl Into<crate::model::AttachmentStateChange>,
        ) -> Self {
            let mut v = self.attachments.unwrap_or_default();
            v.push(input.into());
            self.attachments = Some(v);
            self
        }
        /// <p>Any attachments associated with the state change request.</p>
        pub fn set_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttachmentStateChange>>,
        ) -> Self {
            self.attachments = input;
            self
        }
        /// Consumes the builder and constructs a [`SubmitAttachmentStateChangesInput`](crate::input::SubmitAttachmentStateChangesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SubmitAttachmentStateChangesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SubmitAttachmentStateChangesInput {
                cluster: self.cluster,
                attachments: self.attachments,
            })
        }
    }
}
#[doc(hidden)]
pub type SubmitAttachmentStateChangesInputOperationOutputAlias =
    crate::operation::SubmitAttachmentStateChanges;
#[doc(hidden)]
pub type SubmitAttachmentStateChangesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SubmitAttachmentStateChangesInput {
    /// Consumes the builder and constructs an Operation<[`SubmitAttachmentStateChanges`](crate::operation::SubmitAttachmentStateChanges)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SubmitAttachmentStateChanges,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SubmitAttachmentStateChangesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SubmitAttachmentStateChangesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SubmitAttachmentStateChangesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.SubmitAttachmentStateChanges",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_submit_attachment_state_changes(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SubmitAttachmentStateChanges::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SubmitAttachmentStateChanges",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SubmitAttachmentStateChangesInput`](crate::input::SubmitAttachmentStateChangesInput)
    pub fn builder() -> crate::input::submit_attachment_state_changes_input::Builder {
        crate::input::submit_attachment_state_changes_input::Builder::default()
    }
}

/// See [`SubmitContainerStateChangeInput`](crate::input::SubmitContainerStateChangeInput)
pub mod submit_container_state_change_input {
    /// A builder for [`SubmitContainerStateChangeInput`](crate::input::SubmitContainerStateChangeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) task: std::option::Option<std::string::String>,
        pub(crate) container_name: std::option::Option<std::string::String>,
        pub(crate) runtime_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) exit_code: std::option::Option<i32>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) network_bindings:
            std::option::Option<std::vec::Vec<crate::model::NetworkBinding>>,
    }
    impl Builder {
        /// <p>The short name or full ARN of the cluster that hosts the container.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full ARN of the cluster that hosts the container.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>The task ID or full Amazon Resource Name (ARN) of the task that hosts the container.</p>
        pub fn task(mut self, input: impl Into<std::string::String>) -> Self {
            self.task = Some(input.into());
            self
        }
        /// <p>The task ID or full Amazon Resource Name (ARN) of the task that hosts the container.</p>
        pub fn set_task(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task = input;
            self
        }
        /// <p>The name of the container.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_name = Some(input.into());
            self
        }
        /// <p>The name of the container.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_name = input;
            self
        }
        /// <p>The ID of the Docker container.</p>
        pub fn runtime_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.runtime_id = Some(input.into());
            self
        }
        /// <p>The ID of the Docker container.</p>
        pub fn set_runtime_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.runtime_id = input;
            self
        }
        /// <p>The status of the state change request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the state change request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The exit code returned for the state change request.</p>
        pub fn exit_code(mut self, input: i32) -> Self {
            self.exit_code = Some(input);
            self
        }
        /// <p>The exit code returned for the state change request.</p>
        pub fn set_exit_code(mut self, input: std::option::Option<i32>) -> Self {
            self.exit_code = input;
            self
        }
        /// <p>The reason for the state change request.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason for the state change request.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `network_bindings`.
        ///
        /// To override the contents of this collection use [`set_network_bindings`](Self::set_network_bindings).
        ///
        /// <p>The network bindings of the container.</p>
        pub fn network_bindings(mut self, input: impl Into<crate::model::NetworkBinding>) -> Self {
            let mut v = self.network_bindings.unwrap_or_default();
            v.push(input.into());
            self.network_bindings = Some(v);
            self
        }
        /// <p>The network bindings of the container.</p>
        pub fn set_network_bindings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkBinding>>,
        ) -> Self {
            self.network_bindings = input;
            self
        }
        /// Consumes the builder and constructs a [`SubmitContainerStateChangeInput`](crate::input::SubmitContainerStateChangeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SubmitContainerStateChangeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SubmitContainerStateChangeInput {
                cluster: self.cluster,
                task: self.task,
                container_name: self.container_name,
                runtime_id: self.runtime_id,
                status: self.status,
                exit_code: self.exit_code,
                reason: self.reason,
                network_bindings: self.network_bindings,
            })
        }
    }
}
#[doc(hidden)]
pub type SubmitContainerStateChangeInputOperationOutputAlias =
    crate::operation::SubmitContainerStateChange;
#[doc(hidden)]
pub type SubmitContainerStateChangeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SubmitContainerStateChangeInput {
    /// Consumes the builder and constructs an Operation<[`SubmitContainerStateChange`](crate::operation::SubmitContainerStateChange)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SubmitContainerStateChange,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SubmitContainerStateChangeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SubmitContainerStateChangeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SubmitContainerStateChangeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.SubmitContainerStateChange",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_submit_container_state_change(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SubmitContainerStateChange::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SubmitContainerStateChange",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SubmitContainerStateChangeInput`](crate::input::SubmitContainerStateChangeInput)
    pub fn builder() -> crate::input::submit_container_state_change_input::Builder {
        crate::input::submit_container_state_change_input::Builder::default()
    }
}

/// See [`SubmitTaskStateChangeInput`](crate::input::SubmitTaskStateChangeInput)
pub mod submit_task_state_change_input {
    /// A builder for [`SubmitTaskStateChangeInput`](crate::input::SubmitTaskStateChangeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) task: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) containers:
            std::option::Option<std::vec::Vec<crate::model::ContainerStateChange>>,
        pub(crate) attachments:
            std::option::Option<std::vec::Vec<crate::model::AttachmentStateChange>>,
        pub(crate) managed_agents:
            std::option::Option<std::vec::Vec<crate::model::ManagedAgentStateChange>>,
        pub(crate) pull_started_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) pull_stopped_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) execution_stopped_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>The task ID or full ARN of the task in the state change request.</p>
        pub fn task(mut self, input: impl Into<std::string::String>) -> Self {
            self.task = Some(input.into());
            self
        }
        /// <p>The task ID or full ARN of the task in the state change request.</p>
        pub fn set_task(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task = input;
            self
        }
        /// <p>The status of the state change request.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the state change request.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason for the state change request.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason for the state change request.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `containers`.
        ///
        /// To override the contents of this collection use [`set_containers`](Self::set_containers).
        ///
        /// <p>Any containers associated with the state change request.</p>
        pub fn containers(mut self, input: impl Into<crate::model::ContainerStateChange>) -> Self {
            let mut v = self.containers.unwrap_or_default();
            v.push(input.into());
            self.containers = Some(v);
            self
        }
        /// <p>Any containers associated with the state change request.</p>
        pub fn set_containers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContainerStateChange>>,
        ) -> Self {
            self.containers = input;
            self
        }
        /// Appends an item to `attachments`.
        ///
        /// To override the contents of this collection use [`set_attachments`](Self::set_attachments).
        ///
        /// <p>Any attachments associated with the state change request.</p>
        pub fn attachments(
            mut self,
            input: impl Into<crate::model::AttachmentStateChange>,
        ) -> Self {
            let mut v = self.attachments.unwrap_or_default();
            v.push(input.into());
            self.attachments = Some(v);
            self
        }
        /// <p>Any attachments associated with the state change request.</p>
        pub fn set_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttachmentStateChange>>,
        ) -> Self {
            self.attachments = input;
            self
        }
        /// Appends an item to `managed_agents`.
        ///
        /// To override the contents of this collection use [`set_managed_agents`](Self::set_managed_agents).
        ///
        /// <p>The details for the managed agent associated with the task.</p>
        pub fn managed_agents(
            mut self,
            input: impl Into<crate::model::ManagedAgentStateChange>,
        ) -> Self {
            let mut v = self.managed_agents.unwrap_or_default();
            v.push(input.into());
            self.managed_agents = Some(v);
            self
        }
        /// <p>The details for the managed agent associated with the task.</p>
        pub fn set_managed_agents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ManagedAgentStateChange>>,
        ) -> Self {
            self.managed_agents = input;
            self
        }
        /// <p>The Unix timestamp for when the container image pull began.</p>
        pub fn pull_started_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.pull_started_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the container image pull began.</p>
        pub fn set_pull_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.pull_started_at = input;
            self
        }
        /// <p>The Unix timestamp for when the container image pull completed.</p>
        pub fn pull_stopped_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.pull_stopped_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the container image pull completed.</p>
        pub fn set_pull_stopped_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.pull_stopped_at = input;
            self
        }
        /// <p>The Unix timestamp for when the task execution stopped.</p>
        pub fn execution_stopped_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.execution_stopped_at = Some(input);
            self
        }
        /// <p>The Unix timestamp for when the task execution stopped.</p>
        pub fn set_execution_stopped_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.execution_stopped_at = input;
            self
        }
        /// Consumes the builder and constructs a [`SubmitTaskStateChangeInput`](crate::input::SubmitTaskStateChangeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SubmitTaskStateChangeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SubmitTaskStateChangeInput {
                cluster: self.cluster,
                task: self.task,
                status: self.status,
                reason: self.reason,
                containers: self.containers,
                attachments: self.attachments,
                managed_agents: self.managed_agents,
                pull_started_at: self.pull_started_at,
                pull_stopped_at: self.pull_stopped_at,
                execution_stopped_at: self.execution_stopped_at,
            })
        }
    }
}
#[doc(hidden)]
pub type SubmitTaskStateChangeInputOperationOutputAlias = crate::operation::SubmitTaskStateChange;
#[doc(hidden)]
pub type SubmitTaskStateChangeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SubmitTaskStateChangeInput {
    /// Consumes the builder and constructs an Operation<[`SubmitTaskStateChange`](crate::operation::SubmitTaskStateChange)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SubmitTaskStateChange,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SubmitTaskStateChangeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SubmitTaskStateChangeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SubmitTaskStateChangeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.SubmitTaskStateChange",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_submit_task_state_change(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SubmitTaskStateChange::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SubmitTaskStateChange",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SubmitTaskStateChangeInput`](crate::input::SubmitTaskStateChangeInput)
    pub fn builder() -> crate::input::submit_task_state_change_input::Builder {
        crate::input::submit_task_state_change_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to which to add tags. Currently, the supported resources
        /// are Amazon ECS capacity providers, tasks, services, task definitions, clusters, and container
        /// instances.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which to add tags. Currently, the supported resources
        /// are Amazon ECS capacity providers, tasks, services, task definitions, clusters, and container
        /// instances.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs.</p>
        /// <p>The following basic restrictions apply to tags:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum number of tags per resource - 50</p>
        /// </li>
        /// <li>
        /// <p>For each resource, each tag key must be unique, and each tag key can have only
        /// one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>If your tagging schema is used across multiple services and resources,
        /// remember that other services may have restrictions on allowed characters.
        /// Generally allowed characters are: letters, numbers, and spaces representable in
        /// UTF-8, and the following characters: + - = . _ : / @.</p>
        /// </li>
        /// <li>
        /// <p>Tag keys and values are case-sensitive.</p>
        /// </li>
        /// <li>
        /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
        /// combination of such as a prefix for either keys or values as it is reserved for
        /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
        /// this prefix do not count against your tags per resource limit.</p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource from which to delete tags. Currently, the supported
        /// resources are Amazon ECS capacity providers, tasks, services, task definitions, clusters, and
        /// container instances.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which to delete tags. Currently, the supported
        /// resources are Amazon ECS capacity providers, tasks, services, task definitions, clusters, and
        /// container instances.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateCapacityProviderInput`](crate::input::UpdateCapacityProviderInput)
pub mod update_capacity_provider_input {
    /// A builder for [`UpdateCapacityProviderInput`](crate::input::UpdateCapacityProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group_provider:
            std::option::Option<crate::model::AutoScalingGroupProviderUpdate>,
    }
    impl Builder {
        /// <p>The name of the capacity provider to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the capacity provider to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An object representing the parameters to update for the Auto Scaling group capacity
        /// provider.</p>
        pub fn auto_scaling_group_provider(
            mut self,
            input: crate::model::AutoScalingGroupProviderUpdate,
        ) -> Self {
            self.auto_scaling_group_provider = Some(input);
            self
        }
        /// <p>An object representing the parameters to update for the Auto Scaling group capacity
        /// provider.</p>
        pub fn set_auto_scaling_group_provider(
            mut self,
            input: std::option::Option<crate::model::AutoScalingGroupProviderUpdate>,
        ) -> Self {
            self.auto_scaling_group_provider = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCapacityProviderInput`](crate::input::UpdateCapacityProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateCapacityProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateCapacityProviderInput {
                name: self.name,
                auto_scaling_group_provider: self.auto_scaling_group_provider,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateCapacityProviderInputOperationOutputAlias = crate::operation::UpdateCapacityProvider;
#[doc(hidden)]
pub type UpdateCapacityProviderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateCapacityProviderInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCapacityProvider`](crate::operation::UpdateCapacityProvider)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCapacityProvider,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateCapacityProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateCapacityProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateCapacityProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.UpdateCapacityProvider",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_capacity_provider(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCapacityProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCapacityProvider",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateCapacityProviderInput`](crate::input::UpdateCapacityProviderInput)
    pub fn builder() -> crate::input::update_capacity_provider_input::Builder {
        crate::input::update_capacity_provider_input::Builder::default()
    }
}

/// See [`UpdateClusterInput`](crate::input::UpdateClusterInput)
pub mod update_cluster_input {
    /// A builder for [`UpdateClusterInput`](crate::input::UpdateClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) settings: std::option::Option<std::vec::Vec<crate::model::ClusterSetting>>,
        pub(crate) configuration: std::option::Option<crate::model::ClusterConfiguration>,
    }
    impl Builder {
        /// <p>The name of the cluster to modify the settings for.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The name of the cluster to modify the settings for.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// Appends an item to `settings`.
        ///
        /// To override the contents of this collection use [`set_settings`](Self::set_settings).
        ///
        /// <p>The cluster settings for your cluster.</p>
        pub fn settings(mut self, input: impl Into<crate::model::ClusterSetting>) -> Self {
            let mut v = self.settings.unwrap_or_default();
            v.push(input.into());
            self.settings = Some(v);
            self
        }
        /// <p>The cluster settings for your cluster.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterSetting>>,
        ) -> Self {
            self.settings = input;
            self
        }
        /// <p>The execute command configuration for the cluster.</p>
        pub fn configuration(mut self, input: crate::model::ClusterConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The execute command configuration for the cluster.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ClusterConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateClusterInput`](crate::input::UpdateClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateClusterInput {
                cluster: self.cluster,
                settings: self.settings,
                configuration: self.configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateClusterInputOperationOutputAlias = crate::operation::UpdateCluster;
#[doc(hidden)]
pub type UpdateClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateClusterInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCluster`](crate::operation::UpdateCluster)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.UpdateCluster",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_cluster(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCluster",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateClusterInput`](crate::input::UpdateClusterInput)
    pub fn builder() -> crate::input::update_cluster_input::Builder {
        crate::input::update_cluster_input::Builder::default()
    }
}

/// See [`UpdateClusterSettingsInput`](crate::input::UpdateClusterSettingsInput)
pub mod update_cluster_settings_input {
    /// A builder for [`UpdateClusterSettingsInput`](crate::input::UpdateClusterSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) settings: std::option::Option<std::vec::Vec<crate::model::ClusterSetting>>,
    }
    impl Builder {
        /// <p>The name of the cluster to modify the settings for.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The name of the cluster to modify the settings for.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// Appends an item to `settings`.
        ///
        /// To override the contents of this collection use [`set_settings`](Self::set_settings).
        ///
        /// <p>The setting to use by default for a cluster. This parameter is used to enable CloudWatch
        /// Container Insights for a cluster. If this value is specified, it will override the
        /// <code>containerInsights</code> value set with <a>PutAccountSetting</a> or
        /// <a>PutAccountSettingDefault</a>.</p>
        pub fn settings(mut self, input: impl Into<crate::model::ClusterSetting>) -> Self {
            let mut v = self.settings.unwrap_or_default();
            v.push(input.into());
            self.settings = Some(v);
            self
        }
        /// <p>The setting to use by default for a cluster. This parameter is used to enable CloudWatch
        /// Container Insights for a cluster. If this value is specified, it will override the
        /// <code>containerInsights</code> value set with <a>PutAccountSetting</a> or
        /// <a>PutAccountSettingDefault</a>.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterSetting>>,
        ) -> Self {
            self.settings = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateClusterSettingsInput`](crate::input::UpdateClusterSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateClusterSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateClusterSettingsInput {
                cluster: self.cluster,
                settings: self.settings,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateClusterSettingsInputOperationOutputAlias = crate::operation::UpdateClusterSettings;
#[doc(hidden)]
pub type UpdateClusterSettingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateClusterSettingsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateClusterSettings`](crate::operation::UpdateClusterSettings)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateClusterSettings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateClusterSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateClusterSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateClusterSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.UpdateClusterSettings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_cluster_settings(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateClusterSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateClusterSettings",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateClusterSettingsInput`](crate::input::UpdateClusterSettingsInput)
    pub fn builder() -> crate::input::update_cluster_settings_input::Builder {
        crate::input::update_cluster_settings_input::Builder::default()
    }
}

/// See [`UpdateContainerAgentInput`](crate::input::UpdateContainerAgentInput)
pub mod update_container_agent_input {
    /// A builder for [`UpdateContainerAgentInput`](crate::input::UpdateContainerAgentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) container_instance: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that your container instance is
        /// running on. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that your container instance is
        /// running on. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>The container instance ID or full ARN entries for the container instance on which
        /// you would like to update the Amazon ECS container agent.</p>
        pub fn container_instance(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_instance = Some(input.into());
            self
        }
        /// <p>The container instance ID or full ARN entries for the container instance on which
        /// you would like to update the Amazon ECS container agent.</p>
        pub fn set_container_instance(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateContainerAgentInput`](crate::input::UpdateContainerAgentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateContainerAgentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateContainerAgentInput {
                cluster: self.cluster,
                container_instance: self.container_instance,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateContainerAgentInputOperationOutputAlias = crate::operation::UpdateContainerAgent;
#[doc(hidden)]
pub type UpdateContainerAgentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateContainerAgentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateContainerAgent`](crate::operation::UpdateContainerAgent)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateContainerAgent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateContainerAgentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateContainerAgentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateContainerAgentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.UpdateContainerAgent",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_container_agent(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateContainerAgent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateContainerAgent",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateContainerAgentInput`](crate::input::UpdateContainerAgentInput)
    pub fn builder() -> crate::input::update_container_agent_input::Builder {
        crate::input::update_container_agent_input::Builder::default()
    }
}

/// See [`UpdateContainerInstancesStateInput`](crate::input::UpdateContainerInstancesStateInput)
pub mod update_container_instances_state_input {
    /// A builder for [`UpdateContainerInstancesStateInput`](crate::input::UpdateContainerInstancesStateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) container_instances: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<crate::model::ContainerInstanceStatus>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instance to
        /// update. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instance to
        /// update. If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// Appends an item to `container_instances`.
        ///
        /// To override the contents of this collection use [`set_container_instances`](Self::set_container_instances).
        ///
        /// <p>A list of container instance IDs or full ARN entries.</p>
        pub fn container_instances(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.container_instances.unwrap_or_default();
            v.push(input.into());
            self.container_instances = Some(v);
            self
        }
        /// <p>A list of container instance IDs or full ARN entries.</p>
        pub fn set_container_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.container_instances = input;
            self
        }
        /// <p>The container instance state with which to update the container instance. The only
        /// valid values for this action are <code>ACTIVE</code> and <code>DRAINING</code>. A
        /// container instance can only be updated to <code>DRAINING</code> status once it has
        /// reached an <code>ACTIVE</code> state. If a container instance is in
        /// <code>REGISTERING</code>, <code>DEREGISTERING</code>, or
        /// <code>REGISTRATION_FAILED</code> state you can describe the container instance but
        /// will be unable to update the container instance state.</p>
        pub fn status(mut self, input: crate::model::ContainerInstanceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The container instance state with which to update the container instance. The only
        /// valid values for this action are <code>ACTIVE</code> and <code>DRAINING</code>. A
        /// container instance can only be updated to <code>DRAINING</code> status once it has
        /// reached an <code>ACTIVE</code> state. If a container instance is in
        /// <code>REGISTERING</code>, <code>DEREGISTERING</code>, or
        /// <code>REGISTRATION_FAILED</code> state you can describe the container instance but
        /// will be unable to update the container instance state.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ContainerInstanceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateContainerInstancesStateInput`](crate::input::UpdateContainerInstancesStateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateContainerInstancesStateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateContainerInstancesStateInput {
                cluster: self.cluster,
                container_instances: self.container_instances,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateContainerInstancesStateInputOperationOutputAlias =
    crate::operation::UpdateContainerInstancesState;
#[doc(hidden)]
pub type UpdateContainerInstancesStateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateContainerInstancesStateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateContainerInstancesState`](crate::operation::UpdateContainerInstancesState)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateContainerInstancesState,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateContainerInstancesStateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateContainerInstancesStateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateContainerInstancesStateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.UpdateContainerInstancesState",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_container_instances_state(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateContainerInstancesState::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateContainerInstancesState",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateContainerInstancesStateInput`](crate::input::UpdateContainerInstancesStateInput)
    pub fn builder() -> crate::input::update_container_instances_state_input::Builder {
        crate::input::update_container_instances_state_input::Builder::default()
    }
}

/// See [`UpdateServiceInput`](crate::input::UpdateServiceInput)
pub mod update_service_input {
    /// A builder for [`UpdateServiceInput`](crate::input::UpdateServiceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) desired_count: std::option::Option<i32>,
        pub(crate) task_definition: std::option::Option<std::string::String>,
        pub(crate) capacity_provider_strategy:
            std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        pub(crate) deployment_configuration:
            std::option::Option<crate::model::DeploymentConfiguration>,
        pub(crate) network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
        pub(crate) placement_constraints:
            std::option::Option<std::vec::Vec<crate::model::PlacementConstraint>>,
        pub(crate) placement_strategy:
            std::option::Option<std::vec::Vec<crate::model::PlacementStrategy>>,
        pub(crate) platform_version: std::option::Option<std::string::String>,
        pub(crate) force_new_deployment: std::option::Option<bool>,
        pub(crate) health_check_grace_period_seconds: std::option::Option<i32>,
        pub(crate) enable_execute_command: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that your service is running on.
        /// If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that your service is running on.
        /// If you do not specify a cluster, the default cluster is assumed.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>The name of the service to update.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p>The name of the service to update.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// <p>The number of instantiations of the task to place and keep running in your
        /// service.</p>
        pub fn desired_count(mut self, input: i32) -> Self {
            self.desired_count = Some(input);
            self
        }
        /// <p>The number of instantiations of the task to place and keep running in your
        /// service.</p>
        pub fn set_desired_count(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_count = input;
            self
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or
        /// full ARN of the task definition to run in your service. If a <code>revision</code> is
        /// not specified, the latest <code>ACTIVE</code> revision is used. If you modify the task
        /// definition with <code>UpdateService</code>, Amazon ECS spawns a task with the new version of
        /// the task definition and then stops an old task after the new version is running.</p>
        pub fn task_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_definition = Some(input.into());
            self
        }
        /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or
        /// full ARN of the task definition to run in your service. If a <code>revision</code> is
        /// not specified, the latest <code>ACTIVE</code> revision is used. If you modify the task
        /// definition with <code>UpdateService</code>, Amazon ECS spawns a task with the new version of
        /// the task definition and then stops an old task after the new version is running.</p>
        pub fn set_task_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_definition = input;
            self
        }
        /// Appends an item to `capacity_provider_strategy`.
        ///
        /// To override the contents of this collection use [`set_capacity_provider_strategy`](Self::set_capacity_provider_strategy).
        ///
        /// <p>The capacity provider strategy to update the service to use.</p>
        /// <p>If the service is using the default capacity provider strategy for the cluster, the
        /// service can be updated to use one or more capacity providers as opposed to the default
        /// capacity provider strategy. However, when a service is using a capacity provider
        /// strategy that is not the default capacity provider strategy, the service cannot be
        /// updated to use the cluster's default capacity provider strategy.</p>
        /// <p>A capacity provider strategy consists of one or more capacity providers along with the
        /// <code>base</code> and <code>weight</code> to assign to them. A capacity provider
        /// must be associated with the cluster to be used in a capacity provider strategy. The
        /// <a>PutClusterCapacityProviders</a> API is used to associate a capacity
        /// provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or
        /// <code>UPDATING</code> status can be used.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity
        /// provider must already be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
        /// <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are
        /// available to all accounts and only need to be associated with a cluster to be
        /// used.</p>
        /// <p>The <a>PutClusterCapacityProviders</a> API operation is used to update the
        /// list of available capacity providers for a cluster after the cluster is created.</p>
        /// <p></p>
        pub fn capacity_provider_strategy(
            mut self,
            input: impl Into<crate::model::CapacityProviderStrategyItem>,
        ) -> Self {
            let mut v = self.capacity_provider_strategy.unwrap_or_default();
            v.push(input.into());
            self.capacity_provider_strategy = Some(v);
            self
        }
        /// <p>The capacity provider strategy to update the service to use.</p>
        /// <p>If the service is using the default capacity provider strategy for the cluster, the
        /// service can be updated to use one or more capacity providers as opposed to the default
        /// capacity provider strategy. However, when a service is using a capacity provider
        /// strategy that is not the default capacity provider strategy, the service cannot be
        /// updated to use the cluster's default capacity provider strategy.</p>
        /// <p>A capacity provider strategy consists of one or more capacity providers along with the
        /// <code>base</code> and <code>weight</code> to assign to them. A capacity provider
        /// must be associated with the cluster to be used in a capacity provider strategy. The
        /// <a>PutClusterCapacityProviders</a> API is used to associate a capacity
        /// provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or
        /// <code>UPDATING</code> status can be used.</p>
        /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity
        /// provider must already be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.</p>
        /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
        /// <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are
        /// available to all accounts and only need to be associated with a cluster to be
        /// used.</p>
        /// <p>The <a>PutClusterCapacityProviders</a> API operation is used to update the
        /// list of available capacity providers for a cluster after the cluster is created.</p>
        /// <p></p>
        pub fn set_capacity_provider_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        ) -> Self {
            self.capacity_provider_strategy = input;
            self
        }
        /// <p>Optional deployment parameters that control how many tasks run during the deployment
        /// and the ordering of stopping and starting tasks.</p>
        pub fn deployment_configuration(
            mut self,
            input: crate::model::DeploymentConfiguration,
        ) -> Self {
            self.deployment_configuration = Some(input);
            self
        }
        /// <p>Optional deployment parameters that control how many tasks run during the deployment
        /// and the ordering of stopping and starting tasks.</p>
        pub fn set_deployment_configuration(
            mut self,
            input: std::option::Option<crate::model::DeploymentConfiguration>,
        ) -> Self {
            self.deployment_configuration = input;
            self
        }
        /// <p>An object representing the network configuration for the service.</p>
        pub fn network_configuration(mut self, input: crate::model::NetworkConfiguration) -> Self {
            self.network_configuration = Some(input);
            self
        }
        /// <p>An object representing the network configuration for the service.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkConfiguration>,
        ) -> Self {
            self.network_configuration = input;
            self
        }
        /// Appends an item to `placement_constraints`.
        ///
        /// To override the contents of this collection use [`set_placement_constraints`](Self::set_placement_constraints).
        ///
        /// <p>An array of task placement constraint objects to update the service to use. If no
        /// value is specified, the existing placement constraints for the service will remain
        /// unchanged. If this value is specified, it will override any existing placement
        /// constraints defined for the service. To remove all existing placement constraints,
        /// specify an empty array.</p>
        /// <p>You can specify a maximum of 10 constraints per task (this limit includes constraints
        /// in the task definition and those specified at runtime).</p>
        pub fn placement_constraints(
            mut self,
            input: impl Into<crate::model::PlacementConstraint>,
        ) -> Self {
            let mut v = self.placement_constraints.unwrap_or_default();
            v.push(input.into());
            self.placement_constraints = Some(v);
            self
        }
        /// <p>An array of task placement constraint objects to update the service to use. If no
        /// value is specified, the existing placement constraints for the service will remain
        /// unchanged. If this value is specified, it will override any existing placement
        /// constraints defined for the service. To remove all existing placement constraints,
        /// specify an empty array.</p>
        /// <p>You can specify a maximum of 10 constraints per task (this limit includes constraints
        /// in the task definition and those specified at runtime).</p>
        pub fn set_placement_constraints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementConstraint>>,
        ) -> Self {
            self.placement_constraints = input;
            self
        }
        /// Appends an item to `placement_strategy`.
        ///
        /// To override the contents of this collection use [`set_placement_strategy`](Self::set_placement_strategy).
        ///
        /// <p>The task placement strategy objects to update the service to use. If no value is
        /// specified, the existing placement strategy for the service will remain unchanged. If
        /// this value is specified, it will override the existing placement strategy defined for
        /// the service. To remove an existing placement strategy, specify an empty object.</p>
        /// <p>You can specify a maximum of five strategy rules per service.</p>
        pub fn placement_strategy(
            mut self,
            input: impl Into<crate::model::PlacementStrategy>,
        ) -> Self {
            let mut v = self.placement_strategy.unwrap_or_default();
            v.push(input.into());
            self.placement_strategy = Some(v);
            self
        }
        /// <p>The task placement strategy objects to update the service to use. If no value is
        /// specified, the existing placement strategy for the service will remain unchanged. If
        /// this value is specified, it will override the existing placement strategy defined for
        /// the service. To remove an existing placement strategy, specify an empty object.</p>
        /// <p>You can specify a maximum of five strategy rules per service.</p>
        pub fn set_placement_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementStrategy>>,
        ) -> Self {
            self.placement_strategy = input;
            self
        }
        /// <p>The platform version on which your tasks in the service are running. A platform
        /// version is only specified for tasks using the Fargate launch type. If a
        /// platform version is not specified, the <code>LATEST</code> platform version is used by
        /// default. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
        /// Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_version = Some(input.into());
            self
        }
        /// <p>The platform version on which your tasks in the service are running. A platform
        /// version is only specified for tasks using the Fargate launch type. If a
        /// platform version is not specified, the <code>LATEST</code> platform version is used by
        /// default. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
        /// Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_version = input;
            self
        }
        /// <p>Whether to force a new deployment of the service. Deployments are not forced by
        /// default. You can use this option to trigger a new deployment with no service definition
        /// changes. For example, you can update a service's tasks to use a newer Docker image with
        /// the same image/tag combination (<code>my_image:latest</code>) or to roll Fargate tasks
        /// onto a newer platform version.</p>
        pub fn force_new_deployment(mut self, input: bool) -> Self {
            self.force_new_deployment = Some(input);
            self
        }
        /// <p>Whether to force a new deployment of the service. Deployments are not forced by
        /// default. You can use this option to trigger a new deployment with no service definition
        /// changes. For example, you can update a service's tasks to use a newer Docker image with
        /// the same image/tag combination (<code>my_image:latest</code>) or to roll Fargate tasks
        /// onto a newer platform version.</p>
        pub fn set_force_new_deployment(mut self, input: std::option::Option<bool>) -> Self {
            self.force_new_deployment = input;
            self
        }
        /// <p>The period of time, in seconds, that the Amazon ECS service scheduler should ignore
        /// unhealthy Elastic Load Balancing target health checks after a task has first started. This is only valid
        /// if your service is configured to use a load balancer. If your service's tasks take a
        /// while to start and respond to Elastic Load Balancing health checks, you can specify a health check grace
        /// period of up to 2,147,483,647 seconds. During that time, the Amazon ECS service
        /// scheduler ignores the Elastic Load Balancing health check status. This grace period can prevent the ECS
        /// service scheduler from marking tasks as unhealthy and stopping them before they have
        /// time to come up.</p>
        pub fn health_check_grace_period_seconds(mut self, input: i32) -> Self {
            self.health_check_grace_period_seconds = Some(input);
            self
        }
        /// <p>The period of time, in seconds, that the Amazon ECS service scheduler should ignore
        /// unhealthy Elastic Load Balancing target health checks after a task has first started. This is only valid
        /// if your service is configured to use a load balancer. If your service's tasks take a
        /// while to start and respond to Elastic Load Balancing health checks, you can specify a health check grace
        /// period of up to 2,147,483,647 seconds. During that time, the Amazon ECS service
        /// scheduler ignores the Elastic Load Balancing health check status. This grace period can prevent the ECS
        /// service scheduler from marking tasks as unhealthy and stopping them before they have
        /// time to come up.</p>
        pub fn set_health_check_grace_period_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.health_check_grace_period_seconds = input;
            self
        }
        /// <p>If <code>true</code>, this enables execute command functionality on all task
        /// containers.</p>
        /// <p>If you do not want to override the value that was set when the service was created,
        /// you can set this to <code>null</code> when performing this action.</p>
        pub fn enable_execute_command(mut self, input: bool) -> Self {
            self.enable_execute_command = Some(input);
            self
        }
        /// <p>If <code>true</code>, this enables execute command functionality on all task
        /// containers.</p>
        /// <p>If you do not want to override the value that was set when the service was created,
        /// you can set this to <code>null</code> when performing this action.</p>
        pub fn set_enable_execute_command(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_execute_command = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceInput`](crate::input::UpdateServiceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateServiceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateServiceInput {
                cluster: self.cluster,
                service: self.service,
                desired_count: self.desired_count,
                task_definition: self.task_definition,
                capacity_provider_strategy: self.capacity_provider_strategy,
                deployment_configuration: self.deployment_configuration,
                network_configuration: self.network_configuration,
                placement_constraints: self.placement_constraints,
                placement_strategy: self.placement_strategy,
                platform_version: self.platform_version,
                force_new_deployment: self.force_new_deployment.unwrap_or_default(),
                health_check_grace_period_seconds: self.health_check_grace_period_seconds,
                enable_execute_command: self.enable_execute_command,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateServiceInputOperationOutputAlias = crate::operation::UpdateService;
#[doc(hidden)]
pub type UpdateServiceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateServiceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateService`](crate::operation::UpdateService)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateService,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateServiceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateServiceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateServiceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.UpdateService",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_service(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateService::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateService",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateServiceInput`](crate::input::UpdateServiceInput)
    pub fn builder() -> crate::input::update_service_input::Builder {
        crate::input::update_service_input::Builder::default()
    }
}

/// See [`UpdateServicePrimaryTaskSetInput`](crate::input::UpdateServicePrimaryTaskSetInput)
pub mod update_service_primary_task_set_input {
    /// A builder for [`UpdateServicePrimaryTaskSetInput`](crate::input::UpdateServicePrimaryTaskSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) primary_task_set: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task
        /// set exists in.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task
        /// set exists in.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service that the task set exists in.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service that the task set exists in.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the task set to set as the primary task set in the
        /// deployment.</p>
        pub fn primary_task_set(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_task_set = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the task set to set as the primary task set in the
        /// deployment.</p>
        pub fn set_primary_task_set(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_task_set = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServicePrimaryTaskSetInput`](crate::input::UpdateServicePrimaryTaskSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateServicePrimaryTaskSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateServicePrimaryTaskSetInput {
                cluster: self.cluster,
                service: self.service,
                primary_task_set: self.primary_task_set,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateServicePrimaryTaskSetInputOperationOutputAlias =
    crate::operation::UpdateServicePrimaryTaskSet;
#[doc(hidden)]
pub type UpdateServicePrimaryTaskSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateServicePrimaryTaskSetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateServicePrimaryTaskSet`](crate::operation::UpdateServicePrimaryTaskSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateServicePrimaryTaskSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateServicePrimaryTaskSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateServicePrimaryTaskSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateServicePrimaryTaskSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.UpdateServicePrimaryTaskSet",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_service_primary_task_set(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateServicePrimaryTaskSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateServicePrimaryTaskSet",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateServicePrimaryTaskSetInput`](crate::input::UpdateServicePrimaryTaskSetInput)
    pub fn builder() -> crate::input::update_service_primary_task_set_input::Builder {
        crate::input::update_service_primary_task_set_input::Builder::default()
    }
}

/// See [`UpdateTaskSetInput`](crate::input::UpdateTaskSetInput)
pub mod update_task_set_input {
    /// A builder for [`UpdateTaskSetInput`](crate::input::UpdateTaskSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<std::string::String>,
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) task_set: std::option::Option<std::string::String>,
        pub(crate) scale: std::option::Option<crate::model::Scale>,
    }
    impl Builder {
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task
        /// set exists in.</p>
        pub fn cluster(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task
        /// set exists in.</p>
        pub fn set_cluster(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster = input;
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service that the task set exists in.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the service that the task set exists in.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the task set to update.</p>
        pub fn task_set(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_set = Some(input.into());
            self
        }
        /// <p>The short name or full Amazon Resource Name (ARN) of the task set to update.</p>
        pub fn set_task_set(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_set = input;
            self
        }
        /// <p>A floating-point percentage of the desired number of tasks to place and keep running
        /// in the task set.</p>
        pub fn scale(mut self, input: crate::model::Scale) -> Self {
            self.scale = Some(input);
            self
        }
        /// <p>A floating-point percentage of the desired number of tasks to place and keep running
        /// in the task set.</p>
        pub fn set_scale(mut self, input: std::option::Option<crate::model::Scale>) -> Self {
            self.scale = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTaskSetInput`](crate::input::UpdateTaskSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTaskSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTaskSetInput {
                cluster: self.cluster,
                service: self.service,
                task_set: self.task_set,
                scale: self.scale,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTaskSetInputOperationOutputAlias = crate::operation::UpdateTaskSet;
#[doc(hidden)]
pub type UpdateTaskSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateTaskSetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTaskSet`](crate::operation::UpdateTaskSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTaskSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateTaskSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateTaskSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateTaskSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerServiceV20141113.UpdateTaskSet",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_task_set(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTaskSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTaskSet",
            "ecs",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateTaskSetInput`](crate::input::UpdateTaskSetInput)
    pub fn builder() -> crate::input::update_task_set_input::Builder {
        crate::input::update_task_set_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTaskSetInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task
    /// set exists in.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The short name or full Amazon Resource Name (ARN) of the service that the task set exists in.</p>
    pub service: std::option::Option<std::string::String>,
    /// <p>The short name or full Amazon Resource Name (ARN) of the task set to update.</p>
    pub task_set: std::option::Option<std::string::String>,
    /// <p>A floating-point percentage of the desired number of tasks to place and keep running
    /// in the task set.</p>
    pub scale: std::option::Option<crate::model::Scale>,
}
impl std::fmt::Debug for UpdateTaskSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTaskSetInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("service", &self.service);
        formatter.field("task_set", &self.task_set);
        formatter.field("scale", &self.scale);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServicePrimaryTaskSetInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task
    /// set exists in.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The short name or full Amazon Resource Name (ARN) of the service that the task set exists in.</p>
    pub service: std::option::Option<std::string::String>,
    /// <p>The short name or full Amazon Resource Name (ARN) of the task set to set as the primary task set in the
    /// deployment.</p>
    pub primary_task_set: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateServicePrimaryTaskSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServicePrimaryTaskSetInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("service", &self.service);
        formatter.field("primary_task_set", &self.primary_task_set);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that your service is running on.
    /// If you do not specify a cluster, the default cluster is assumed.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The name of the service to update.</p>
    pub service: std::option::Option<std::string::String>,
    /// <p>The number of instantiations of the task to place and keep running in your
    /// service.</p>
    pub desired_count: std::option::Option<i32>,
    /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or
    /// full ARN of the task definition to run in your service. If a <code>revision</code> is
    /// not specified, the latest <code>ACTIVE</code> revision is used. If you modify the task
    /// definition with <code>UpdateService</code>, Amazon ECS spawns a task with the new version of
    /// the task definition and then stops an old task after the new version is running.</p>
    pub task_definition: std::option::Option<std::string::String>,
    /// <p>The capacity provider strategy to update the service to use.</p>
    /// <p>If the service is using the default capacity provider strategy for the cluster, the
    /// service can be updated to use one or more capacity providers as opposed to the default
    /// capacity provider strategy. However, when a service is using a capacity provider
    /// strategy that is not the default capacity provider strategy, the service cannot be
    /// updated to use the cluster's default capacity provider strategy.</p>
    /// <p>A capacity provider strategy consists of one or more capacity providers along with the
    /// <code>base</code> and <code>weight</code> to assign to them. A capacity provider
    /// must be associated with the cluster to be used in a capacity provider strategy. The
    /// <a>PutClusterCapacityProviders</a> API is used to associate a capacity
    /// provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or
    /// <code>UPDATING</code> status can be used.</p>
    /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity
    /// provider must already be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.</p>
    /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
    /// <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are
    /// available to all accounts and only need to be associated with a cluster to be
    /// used.</p>
    /// <p>The <a>PutClusterCapacityProviders</a> API operation is used to update the
    /// list of available capacity providers for a cluster after the cluster is created.</p>
    /// <p></p>
    pub capacity_provider_strategy:
        std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
    /// <p>Optional deployment parameters that control how many tasks run during the deployment
    /// and the ordering of stopping and starting tasks.</p>
    pub deployment_configuration: std::option::Option<crate::model::DeploymentConfiguration>,
    /// <p>An object representing the network configuration for the service.</p>
    pub network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
    /// <p>An array of task placement constraint objects to update the service to use. If no
    /// value is specified, the existing placement constraints for the service will remain
    /// unchanged. If this value is specified, it will override any existing placement
    /// constraints defined for the service. To remove all existing placement constraints,
    /// specify an empty array.</p>
    /// <p>You can specify a maximum of 10 constraints per task (this limit includes constraints
    /// in the task definition and those specified at runtime).</p>
    pub placement_constraints:
        std::option::Option<std::vec::Vec<crate::model::PlacementConstraint>>,
    /// <p>The task placement strategy objects to update the service to use. If no value is
    /// specified, the existing placement strategy for the service will remain unchanged. If
    /// this value is specified, it will override the existing placement strategy defined for
    /// the service. To remove an existing placement strategy, specify an empty object.</p>
    /// <p>You can specify a maximum of five strategy rules per service.</p>
    pub placement_strategy: std::option::Option<std::vec::Vec<crate::model::PlacementStrategy>>,
    /// <p>The platform version on which your tasks in the service are running. A platform
    /// version is only specified for tasks using the Fargate launch type. If a
    /// platform version is not specified, the <code>LATEST</code> platform version is used by
    /// default. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
    /// Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub platform_version: std::option::Option<std::string::String>,
    /// <p>Whether to force a new deployment of the service. Deployments are not forced by
    /// default. You can use this option to trigger a new deployment with no service definition
    /// changes. For example, you can update a service's tasks to use a newer Docker image with
    /// the same image/tag combination (<code>my_image:latest</code>) or to roll Fargate tasks
    /// onto a newer platform version.</p>
    pub force_new_deployment: bool,
    /// <p>The period of time, in seconds, that the Amazon ECS service scheduler should ignore
    /// unhealthy Elastic Load Balancing target health checks after a task has first started. This is only valid
    /// if your service is configured to use a load balancer. If your service's tasks take a
    /// while to start and respond to Elastic Load Balancing health checks, you can specify a health check grace
    /// period of up to 2,147,483,647 seconds. During that time, the Amazon ECS service
    /// scheduler ignores the Elastic Load Balancing health check status. This grace period can prevent the ECS
    /// service scheduler from marking tasks as unhealthy and stopping them before they have
    /// time to come up.</p>
    pub health_check_grace_period_seconds: std::option::Option<i32>,
    /// <p>If <code>true</code>, this enables execute command functionality on all task
    /// containers.</p>
    /// <p>If you do not want to override the value that was set when the service was created,
    /// you can set this to <code>null</code> when performing this action.</p>
    pub enable_execute_command: std::option::Option<bool>,
}
impl std::fmt::Debug for UpdateServiceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("service", &self.service);
        formatter.field("desired_count", &self.desired_count);
        formatter.field("task_definition", &self.task_definition);
        formatter.field(
            "capacity_provider_strategy",
            &self.capacity_provider_strategy,
        );
        formatter.field("deployment_configuration", &self.deployment_configuration);
        formatter.field("network_configuration", &self.network_configuration);
        formatter.field("placement_constraints", &self.placement_constraints);
        formatter.field("placement_strategy", &self.placement_strategy);
        formatter.field("platform_version", &self.platform_version);
        formatter.field("force_new_deployment", &self.force_new_deployment);
        formatter.field(
            "health_check_grace_period_seconds",
            &self.health_check_grace_period_seconds,
        );
        formatter.field("enable_execute_command", &self.enable_execute_command);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateContainerInstancesStateInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instance to
    /// update. If you do not specify a cluster, the default cluster is assumed.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>A list of container instance IDs or full ARN entries.</p>
    pub container_instances: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The container instance state with which to update the container instance. The only
    /// valid values for this action are <code>ACTIVE</code> and <code>DRAINING</code>. A
    /// container instance can only be updated to <code>DRAINING</code> status once it has
    /// reached an <code>ACTIVE</code> state. If a container instance is in
    /// <code>REGISTERING</code>, <code>DEREGISTERING</code>, or
    /// <code>REGISTRATION_FAILED</code> state you can describe the container instance but
    /// will be unable to update the container instance state.</p>
    pub status: std::option::Option<crate::model::ContainerInstanceStatus>,
}
impl std::fmt::Debug for UpdateContainerInstancesStateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateContainerInstancesStateInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("container_instances", &self.container_instances);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateContainerAgentInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that your container instance is
    /// running on. If you do not specify a cluster, the default cluster is assumed.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The container instance ID or full ARN entries for the container instance on which
    /// you would like to update the Amazon ECS container agent.</p>
    pub container_instance: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateContainerAgentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateContainerAgentInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("container_instance", &self.container_instance);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateClusterSettingsInput {
    /// <p>The name of the cluster to modify the settings for.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The setting to use by default for a cluster. This parameter is used to enable CloudWatch
    /// Container Insights for a cluster. If this value is specified, it will override the
    /// <code>containerInsights</code> value set with <a>PutAccountSetting</a> or
    /// <a>PutAccountSettingDefault</a>.</p>
    pub settings: std::option::Option<std::vec::Vec<crate::model::ClusterSetting>>,
}
impl std::fmt::Debug for UpdateClusterSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateClusterSettingsInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("settings", &self.settings);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateClusterInput {
    /// <p>The name of the cluster to modify the settings for.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The cluster settings for your cluster.</p>
    pub settings: std::option::Option<std::vec::Vec<crate::model::ClusterSetting>>,
    /// <p>The execute command configuration for the cluster.</p>
    pub configuration: std::option::Option<crate::model::ClusterConfiguration>,
}
impl std::fmt::Debug for UpdateClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateClusterInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("settings", &self.settings);
        formatter.field("configuration", &self.configuration);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCapacityProviderInput {
    /// <p>The name of the capacity provider to update.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An object representing the parameters to update for the Auto Scaling group capacity
    /// provider.</p>
    pub auto_scaling_group_provider:
        std::option::Option<crate::model::AutoScalingGroupProviderUpdate>,
}
impl std::fmt::Debug for UpdateCapacityProviderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCapacityProviderInput");
        formatter.field("name", &self.name);
        formatter.field(
            "auto_scaling_group_provider",
            &self.auto_scaling_group_provider,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource from which to delete tags. Currently, the supported
    /// resources are Amazon ECS capacity providers, tasks, services, task definitions, clusters, and
    /// container instances.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The keys of the tags to be removed.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to which to add tags. Currently, the supported resources
    /// are Amazon ECS capacity providers, tasks, services, task definitions, clusters, and container
    /// instances.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to add to the resource. A tag is an array of key-value pairs.</p>
    /// <p>The following basic restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of tags per resource - 50</p>
    /// </li>
    /// <li>
    /// <p>For each resource, each tag key must be unique, and each tag key can have only
    /// one value.</p>
    /// </li>
    /// <li>
    /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>If your tagging schema is used across multiple services and resources,
    /// remember that other services may have restrictions on allowed characters.
    /// Generally allowed characters are: letters, numbers, and spaces representable in
    /// UTF-8, and the following characters: + - = . _ : / @.</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
    /// combination of such as a prefix for either keys or values as it is reserved for
    /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
    /// this prefix do not count against your tags per resource limit.</p>
    /// </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubmitTaskStateChangeInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The task ID or full ARN of the task in the state change request.</p>
    pub task: std::option::Option<std::string::String>,
    /// <p>The status of the state change request.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The reason for the state change request.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>Any containers associated with the state change request.</p>
    pub containers: std::option::Option<std::vec::Vec<crate::model::ContainerStateChange>>,
    /// <p>Any attachments associated with the state change request.</p>
    pub attachments: std::option::Option<std::vec::Vec<crate::model::AttachmentStateChange>>,
    /// <p>The details for the managed agent associated with the task.</p>
    pub managed_agents: std::option::Option<std::vec::Vec<crate::model::ManagedAgentStateChange>>,
    /// <p>The Unix timestamp for when the container image pull began.</p>
    pub pull_started_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Unix timestamp for when the container image pull completed.</p>
    pub pull_stopped_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Unix timestamp for when the task execution stopped.</p>
    pub execution_stopped_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for SubmitTaskStateChangeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubmitTaskStateChangeInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("task", &self.task);
        formatter.field("status", &self.status);
        formatter.field("reason", &self.reason);
        formatter.field("containers", &self.containers);
        formatter.field("attachments", &self.attachments);
        formatter.field("managed_agents", &self.managed_agents);
        formatter.field("pull_started_at", &self.pull_started_at);
        formatter.field("pull_stopped_at", &self.pull_stopped_at);
        formatter.field("execution_stopped_at", &self.execution_stopped_at);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubmitContainerStateChangeInput {
    /// <p>The short name or full ARN of the cluster that hosts the container.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The task ID or full Amazon Resource Name (ARN) of the task that hosts the container.</p>
    pub task: std::option::Option<std::string::String>,
    /// <p>The name of the container.</p>
    pub container_name: std::option::Option<std::string::String>,
    /// <p>The ID of the Docker container.</p>
    pub runtime_id: std::option::Option<std::string::String>,
    /// <p>The status of the state change request.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The exit code returned for the state change request.</p>
    pub exit_code: std::option::Option<i32>,
    /// <p>The reason for the state change request.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>The network bindings of the container.</p>
    pub network_bindings: std::option::Option<std::vec::Vec<crate::model::NetworkBinding>>,
}
impl std::fmt::Debug for SubmitContainerStateChangeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubmitContainerStateChangeInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("task", &self.task);
        formatter.field("container_name", &self.container_name);
        formatter.field("runtime_id", &self.runtime_id);
        formatter.field("status", &self.status);
        formatter.field("exit_code", &self.exit_code);
        formatter.field("reason", &self.reason);
        formatter.field("network_bindings", &self.network_bindings);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubmitAttachmentStateChangesInput {
    /// <p>The short name or full ARN of the cluster that hosts the container instance the
    /// attachment belongs to.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>Any attachments associated with the state change request.</p>
    pub attachments: std::option::Option<std::vec::Vec<crate::model::AttachmentStateChange>>,
}
impl std::fmt::Debug for SubmitAttachmentStateChangesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubmitAttachmentStateChangesInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("attachments", &self.attachments);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopTaskInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task to stop.
    /// If you do not specify a cluster, the default cluster is assumed.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The task ID or full Amazon Resource Name (ARN) of the task to stop.</p>
    pub task: std::option::Option<std::string::String>,
    /// <p>An optional message specified when a task is stopped. For example, if you are using a
    /// custom scheduler, you can use this parameter to specify the reason for stopping the task
    /// here, and the message appears in subsequent <a>DescribeTasks</a> API
    /// operations on this task. Up to 255 characters are allowed in this message.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StopTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopTaskInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("task", &self.task);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTaskInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster on which to start your task.
    /// If you do not specify a cluster, the default cluster is assumed.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The container instance IDs or full ARN entries for the container instances on which
    /// you would like to place your task. You can specify up to 10 container instances.</p>
    pub container_instances: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies whether to enable Amazon ECS managed tags for the task. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS
    /// Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub enable_ecs_managed_tags: bool,
    /// <p>Whether or not the execute command functionality is enabled for the task. If
    /// <code>true</code>, this enables execute command functionality on all containers in
    /// the task.</p>
    pub enable_execute_command: bool,
    /// <p>The name of the task group to associate with the task. The default value is the family
    /// name of the task definition (for example, family:my-family-name).</p>
    pub group: std::option::Option<std::string::String>,
    /// <p>The VPC subnet and security group configuration for tasks that receive their own
    /// elastic network interface by using the <code>awsvpc</code> networking mode.</p>
    pub network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
    /// <p>A list of container overrides in JSON format that specify the name of a container in
    /// the specified task definition and the overrides it should receive. You can override the
    /// default command for a container (that is specified in the task definition or Docker
    /// image) with a <code>command</code> override. You can also override existing environment
    /// variables (that are specified in the task definition or Docker image) on a container or
    /// add new environment variables to it with an <code>environment</code> override.</p>
    /// <note>
    /// <p>A total of 8192 characters are allowed for overrides. This limit includes the JSON
    /// formatting characters of the override structure.</p>
    /// </note>
    pub overrides: std::option::Option<crate::model::TaskOverride>,
    /// <p>Specifies whether to propagate the tags from the task definition or the service to the
    /// task. If no value is specified, the tags are not propagated.</p>
    pub propagate_tags: std::option::Option<crate::model::PropagateTags>,
    /// <p>The reference ID to use for the task.</p>
    pub reference_id: std::option::Option<std::string::String>,
    /// <p>An optional tag specified when a task is started. For example, if you automatically
    /// trigger a task to run a batch process job, you could apply a unique identifier for that
    /// job to your task with the <code>startedBy</code> parameter. You can then identify which
    /// tasks belong to that job by filtering the results of a <a>ListTasks</a> call
    /// with the <code>startedBy</code> value. Up to 36 letters (uppercase and lowercase),
    /// numbers, hyphens, and underscores are allowed.</p>
    /// <p>If a task is started by an Amazon ECS service, then the <code>startedBy</code> parameter
    /// contains the deployment ID of the service that starts it.</p>
    pub started_by: std::option::Option<std::string::String>,
    /// <p>The metadata that you apply to the task to help you categorize and organize them. Each
    /// tag consists of a key and an optional value, both of which you define.</p>
    /// <p>The following basic restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of tags per resource - 50</p>
    /// </li>
    /// <li>
    /// <p>For each resource, each tag key must be unique, and each tag key can have only
    /// one value.</p>
    /// </li>
    /// <li>
    /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>If your tagging schema is used across multiple services and resources,
    /// remember that other services may have restrictions on allowed characters.
    /// Generally allowed characters are: letters, numbers, and spaces representable in
    /// UTF-8, and the following characters: + - = . _ : / @.</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
    /// combination of such as a prefix for either keys or values as it is reserved for
    /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
    /// this prefix do not count against your tags per resource limit.</p>
    /// </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or
    /// full ARN of the task definition to start. If a <code>revision</code> is not specified,
    /// the latest <code>ACTIVE</code> revision is used.</p>
    pub task_definition: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTaskInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("container_instances", &self.container_instances);
        formatter.field("enable_ecs_managed_tags", &self.enable_ecs_managed_tags);
        formatter.field("enable_execute_command", &self.enable_execute_command);
        formatter.field("group", &self.group);
        formatter.field("network_configuration", &self.network_configuration);
        formatter.field("overrides", &self.overrides);
        formatter.field("propagate_tags", &self.propagate_tags);
        formatter.field("reference_id", &self.reference_id);
        formatter.field("started_by", &self.started_by);
        formatter.field("tags", &self.tags);
        formatter.field("task_definition", &self.task_definition);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RunTaskInput {
    /// <p>The capacity provider strategy to use for the task.</p>
    /// <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code>
    /// parameter must be omitted. If no <code>capacityProviderStrategy</code> or
    /// <code>launchType</code> is specified, the
    /// <code>defaultCapacityProviderStrategy</code> for the cluster is used.</p>
    /// <p>When you use cluster auto scaling, you must specify <code>capacityProviderStrategy</code> and not <code>launchType</code>. </p>
    /// <p>A capacity provider strategy may contain a maximum of 6 capacity providers.</p>
    pub capacity_provider_strategy:
        std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster on which to run your task.
    /// If you do not specify a cluster, the default cluster is assumed.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The number of instantiations of the specified task to place on your cluster. You can
    /// specify up to 10 tasks per call.</p>
    pub count: std::option::Option<i32>,
    /// <p>Specifies whether to enable Amazon ECS managed tags for the task. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS
    /// Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub enable_ecs_managed_tags: bool,
    /// <p>Whether or not to enable the execute command functionality for the containers in this
    /// task. If <code>true</code>, this enables execute command functionality on all containers
    /// in the task.</p>
    pub enable_execute_command: bool,
    /// <p>The name of the task group to associate with the task. The default value is the family
    /// name of the task definition (for example, <code>family:my-family-name</code>).</p>
    pub group: std::option::Option<std::string::String>,
    /// <p>The infrastructure on which to run your standalone task. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand
    /// infrastructure.</p>
    /// <note>
    /// <p>Fargate Spot infrastructure is available for use but a capacity provider
    /// strategy must be used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html">Fargate capacity providers</a> in the
    /// <i>Amazon ECS User Guide for Fargate</i>.</p>
    /// </note>
    /// <p>The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your
    /// cluster.</p>
    /// <p>The <code>EXTERNAL</code> launch type runs your tasks on your on-premise server or
    /// virtual machine (VM) capacity registered to your cluster.</p>
    /// <p>A task can use either a launch type or a capacity provider strategy. If a
    /// <code>launchType</code> is specified, the <code>capacityProviderStrategy</code>
    /// parameter must be omitted.</p>
    /// <p>When you use cluster auto scaling, you must specify <code>capacityProviderStrategy</code> and not <code>launchType</code>. </p>
    pub launch_type: std::option::Option<crate::model::LaunchType>,
    /// <p>The network configuration for the task. This parameter is required for task
    /// definitions that use the <code>awsvpc</code> network mode to receive their own elastic
    /// network interface, and it is not supported for other network modes. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task networking</a>
    /// in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
    /// <p>A list of container overrides in JSON format that specify the name of a container in
    /// the specified task definition and the overrides it should receive. You can override the
    /// default command for a container (that is specified in the task definition or Docker
    /// image) with a <code>command</code> override. You can also override existing environment
    /// variables (that are specified in the task definition or Docker image) on a container or
    /// add new environment variables to it with an <code>environment</code> override.</p>
    /// <p>A total of 8192 characters are allowed for overrides. This limit includes the JSON
    /// formatting characters of the override structure.</p>
    pub overrides: std::option::Option<crate::model::TaskOverride>,
    /// <p>An array of placement constraint objects to use for the task. You can specify up to 10
    /// constraints per task (including constraints in the task definition and those specified
    /// at runtime).</p>
    pub placement_constraints:
        std::option::Option<std::vec::Vec<crate::model::PlacementConstraint>>,
    /// <p>The placement strategy objects to use for the task. You can specify a maximum of 5
    /// strategy rules per task.</p>
    pub placement_strategy: std::option::Option<std::vec::Vec<crate::model::PlacementStrategy>>,
    /// <p>The platform version the task should use. A platform version is only specified for
    /// tasks hosted on Fargate. If one is not specified, the <code>LATEST</code>
    /// platform version is used by default. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate platform versions</a> in the
    /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub platform_version: std::option::Option<std::string::String>,
    /// <p>Specifies whether to propagate the tags from the task definition to the task. If no
    /// value is specified, the tags are not propagated. Tags can only be propagated to the task
    /// during task creation. To add tags to a task after task creation, use the <a>TagResource</a> API action.</p>
    /// <note>
    /// <p>An error will be received if you specify the <code>SERVICE</code> option when
    /// running a task.</p>
    /// </note>
    pub propagate_tags: std::option::Option<crate::model::PropagateTags>,
    /// <p>The reference ID to use for the task. The reference ID can have a maximum length of
    /// 1024 characters.</p>
    pub reference_id: std::option::Option<std::string::String>,
    /// <p>An optional tag specified when a task is started. For example, if you automatically
    /// trigger a task to run a batch process job, you could apply a unique identifier for that
    /// job to your task with the <code>startedBy</code> parameter. You can then identify which
    /// tasks belong to that job by filtering the results of a <a>ListTasks</a> call
    /// with the <code>startedBy</code> value. Up to 36 letters (uppercase and lowercase),
    /// numbers, hyphens, and underscores are allowed.</p>
    /// <p>If a task is started by an Amazon ECS service, then the <code>startedBy</code> parameter
    /// contains the deployment ID of the service that starts it.</p>
    pub started_by: std::option::Option<std::string::String>,
    /// <p>The metadata that you apply to the task to help you categorize and organize them. Each
    /// tag consists of a key and an optional value, both of which you define.</p>
    /// <p>The following basic restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of tags per resource - 50</p>
    /// </li>
    /// <li>
    /// <p>For each resource, each tag key must be unique, and each tag key can have only
    /// one value.</p>
    /// </li>
    /// <li>
    /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>If your tagging schema is used across multiple services and resources,
    /// remember that other services may have restrictions on allowed characters.
    /// Generally allowed characters are: letters, numbers, and spaces representable in
    /// UTF-8, and the following characters: + - = . _ : / @.</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
    /// combination of such as a prefix for either keys or values as it is reserved for
    /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
    /// this prefix do not count against your tags per resource limit.</p>
    /// </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or
    /// full ARN of the task definition to run. If a <code>revision</code> is not specified,
    /// the latest <code>ACTIVE</code> revision is used.</p>
    /// <p>The full ARN value must match the value that you specified ias the <code>Resource</code>
    /// of the IAM principal's permissions policy. For example, if the <code>Resource</code> is
    /// arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:*, the
    /// <code>taskDefinition</code> ARN value must be
    /// <code>arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName</code>.</p>
    pub task_definition: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RunTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RunTaskInput");
        formatter.field(
            "capacity_provider_strategy",
            &self.capacity_provider_strategy,
        );
        formatter.field("cluster", &self.cluster);
        formatter.field("count", &self.count);
        formatter.field("enable_ecs_managed_tags", &self.enable_ecs_managed_tags);
        formatter.field("enable_execute_command", &self.enable_execute_command);
        formatter.field("group", &self.group);
        formatter.field("launch_type", &self.launch_type);
        formatter.field("network_configuration", &self.network_configuration);
        formatter.field("overrides", &self.overrides);
        formatter.field("placement_constraints", &self.placement_constraints);
        formatter.field("placement_strategy", &self.placement_strategy);
        formatter.field("platform_version", &self.platform_version);
        formatter.field("propagate_tags", &self.propagate_tags);
        formatter.field("reference_id", &self.reference_id);
        formatter.field("started_by", &self.started_by);
        formatter.field("tags", &self.tags);
        formatter.field("task_definition", &self.task_definition);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterTaskDefinitionInput {
    /// <p>You must specify a <code>family</code> for a task definition, which allows you to
    /// track multiple versions of the same task definition. The <code>family</code> is used as
    /// a name for your task definition. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed.</p>
    pub family: std::option::Option<std::string::String>,
    /// <p>The short name or full Amazon Resource Name (ARN) of the IAM role that containers in this task can
    /// assume. All containers in this task are granted the permissions that are specified in
    /// this role. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Roles for
    /// Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub task_role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent
    /// permission to make Amazon Web Services API calls on your behalf. The task execution IAM role is required
    /// depending on the requirements of your task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task
    /// execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>The Docker networking mode to use for the containers in the task. The valid values are
    /// <code>none</code>, <code>bridge</code>, <code>awsvpc</code>, and <code>host</code>.
    /// If no network mode is specified, the default is <code>bridge</code>.</p>
    /// <p>For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required.
    /// For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used.  For Amazon ECS tasks on Amazon EC2 Windows instances, <code><default></code> or <code>awsvpc</code> can be used. If the network
    /// mode is set to <code>none</code>, you cannot specify port mappings in your container
    /// definitions, and the tasks containers do not have external connectivity. The
    /// <code>host</code> and <code>awsvpc</code> network modes offer the highest networking
    /// performance for containers because they use the EC2 network stack instead of the
    /// virtualized network stack provided by the <code>bridge</code> mode.</p>
    /// <p>With the <code>host</code> and <code>awsvpc</code> network modes, exposed container
    /// ports are mapped directly to the corresponding host port (for the <code>host</code>
    /// network mode) or the attached elastic network interface port (for the
    /// <code>awsvpc</code> network mode), so you cannot take advantage of dynamic host port
    /// mappings. </p>
    /// <important>
    /// <p>When using the <code>host</code> network mode, you should not run
    /// containers using the root user (UID 0). It is considered best practice
    /// to use a non-root user.</p>
    /// </important>
    /// <p>If the network mode is <code>awsvpc</code>, the task is allocated an elastic network
    /// interface, and you must specify a <a>NetworkConfiguration</a> value when you create
    /// a service or run a task with the task definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the
    /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>If the network mode is <code>host</code>, you cannot run multiple instantiations of the
    /// same task on a single container instance when port mappings are used.</p>
    /// <p>For more information, see <a href="https://docs.docker.com/engine/reference/run/#network-settings">Network
    /// settings</a> in the <i>Docker run reference</i>.</p>
    pub network_mode: std::option::Option<crate::model::NetworkMode>,
    /// <p>A list of container definitions in JSON format that describe the different containers
    /// that make up your task.</p>
    pub container_definitions:
        std::option::Option<std::vec::Vec<crate::model::ContainerDefinition>>,
    /// <p>A list of volume definitions in JSON format that containers in your task may
    /// use.</p>
    pub volumes: std::option::Option<std::vec::Vec<crate::model::Volume>>,
    /// <p>An array of placement constraint objects to use for the task. You can specify a
    /// maximum of 10 constraints per task (this limit includes constraints in the task
    /// definition and those specified at runtime).</p>
    pub placement_constraints:
        std::option::Option<std::vec::Vec<crate::model::TaskDefinitionPlacementConstraint>>,
    /// <p>The task launch type that Amazon ECS should validate the task definition against. A client
    /// exception is returned if the task definition doesn't validate against the
    /// compatibilities specified. If no value is specified, the parameter is omitted from the
    /// response.</p>
    pub requires_compatibilities: std::option::Option<std::vec::Vec<crate::model::Compatibility>>,
    /// <p>The number of CPU units used by the task. It can be expressed as an integer using CPU
    /// units, for example <code>1024</code>, or as a string using vCPUs, for example <code>1
    /// vCPU</code> or <code>1 vcpu</code>, in a task definition. String values are
    /// converted to an integer indicating the CPU units when the task definition is
    /// registered.</p>
    /// <note>
    /// <p>Task-level CPU and memory parameters are ignored for Windows containers. We
    /// recommend specifying container-level resources for Windows containers.</p>
    /// </note>
    /// <p>If you are using the EC2 launch type, this field is optional. Supported
    /// values are between <code>128</code> CPU units (<code>0.125</code> vCPUs) and
    /// <code>10240</code> CPU units (<code>10</code> vCPUs).</p>
    /// <p>If you are using the Fargate launch type, this field is required and you
    /// must use one of the following values, which determines your range of supported values
    /// for the <code>memory</code> parameter:</p>
    /// <ul>
    /// <li>
    /// <p>256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)</p>
    /// </li>
    /// <li>
    /// <p>512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)</p>
    /// </li>
    /// <li>
    /// <p>1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)</p>
    /// </li>
    /// <li>
    /// <p>2048 (2 vCPU) - Available <code>memory</code> values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)</p>
    /// </li>
    /// <li>
    /// <p>4096 (4 vCPU) - Available <code>memory</code> values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)</p>
    /// </li>
    /// </ul>
    pub cpu: std::option::Option<std::string::String>,
    /// <p>The amount of memory (in MiB) used by the task. It can be expressed as an integer
    /// using MiB, for example <code>1024</code>, or as a string using GB, for example
    /// <code>1GB</code> or <code>1 GB</code>, in a task definition. String values are
    /// converted to an integer indicating the MiB when the task definition is
    /// registered.</p>
    /// <note>
    /// <p>Task-level CPU and memory parameters are ignored for Windows containers. We
    /// recommend specifying container-level resources for Windows containers.</p>
    /// </note>
    /// <p>If using the EC2 launch type, this field is optional.</p>
    /// <p>If using the Fargate launch type, this field is required and you must
    /// use one of the following values, which determines your range of supported values for the
    /// <code>cpu</code> parameter:</p>
    /// <ul>
    /// <li>
    /// <p>512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)</p>
    /// </li>
    /// <li>
    /// <p>1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)</p>
    /// </li>
    /// <li>
    /// <p>2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available <code>cpu</code> values: 1024 (1 vCPU)</p>
    /// </li>
    /// <li>
    /// <p>Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2 vCPU)</p>
    /// </li>
    /// <li>
    /// <p>Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4 vCPU)</p>
    /// </li>
    /// </ul>
    pub memory: std::option::Option<std::string::String>,
    /// <p>The metadata that you apply to the task definition to help you categorize and organize
    /// them. Each tag consists of a key and an optional value, both of which you define.</p>
    /// <p>The following basic restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of tags per resource - 50</p>
    /// </li>
    /// <li>
    /// <p>For each resource, each tag key must be unique, and each tag key can have only
    /// one value.</p>
    /// </li>
    /// <li>
    /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>If your tagging schema is used across multiple services and resources,
    /// remember that other services may have restrictions on allowed characters.
    /// Generally allowed characters are: letters, numbers, and spaces representable in
    /// UTF-8, and the following characters: + - = . _ : / @.</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
    /// combination of such as a prefix for either keys or values as it is reserved for
    /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
    /// this prefix do not count against your tags per resource limit.</p>
    /// </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The process namespace to use for the containers in the task. The valid
    /// values are <code>host</code> or <code>task</code>. If <code>host</code>
    /// is specified, then all containers within the tasks that specified the
    /// <code>host</code> PID mode on the same container instance share the
    /// same process namespace with the host Amazon EC2 instance. If <code>task</code> is
    /// specified, all containers within the specified task share the same
    /// process namespace. If no value is specified, the default is a private
    /// namespace. For more information, see <a href="https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the <i>Docker run
    /// reference</i>.</p>
    /// <p>If the <code>host</code> PID mode is used, be aware that there is a
    /// heightened risk of undesired process namespace expose. For more
    /// information, see <a href="https://docs.docker.com/engine/security/security/">Docker
    /// security</a>.</p>
    /// <note>
    /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
    /// </note>
    pub pid_mode: std::option::Option<crate::model::PidMode>,
    /// <p>The IPC resource namespace to use for the containers in the task. The valid values are
    /// <code>host</code>, <code>task</code>, or <code>none</code>. If <code>host</code> is
    /// specified, then all containers within the tasks that specified the <code>host</code> IPC
    /// mode on the same container instance share the same IPC resources with the host Amazon EC2
    /// instance. If <code>task</code> is specified, all containers within the specified task
    /// share the same IPC resources. If <code>none</code> is specified, then IPC resources
    /// within the containers of a task are private and not shared with other containers in a
    /// task or on the container instance. If no value is specified, then the IPC resource
    /// namespace sharing depends on the Docker daemon setting on the container instance. For
    /// more information, see <a href="https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC
    /// settings</a> in the <i>Docker run reference</i>.</p>
    /// <p>If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of
    /// undesired IPC namespace expose. For more information, see <a href="https://docs.docker.com/engine/security/security/">Docker
    /// security</a>.</p>
    /// <p>If you are setting namespaced kernel parameters using <code>systemControls</code> for
    /// the containers in the task, the following will apply to your IPC resource namespace. For
    /// more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System
    /// Controls</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <ul>
    /// <li>
    /// <p>For tasks that use the <code>host</code> IPC mode, IPC namespace related
    /// <code>systemControls</code> are not supported.</p>
    /// </li>
    /// <li>
    /// <p>For tasks that use the <code>task</code> IPC mode, IPC namespace related
    /// <code>systemControls</code> will apply to all containers within a
    /// task.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>This parameter is not supported for Windows containers or tasks run on Fargate.</p>
    /// </note>
    pub ipc_mode: std::option::Option<crate::model::IpcMode>,
    /// <p>The configuration details for the App Mesh proxy.</p>
    /// <p>For tasks hosted on Amazon EC2 instances, the container instances require at least version
    /// <code>1.26.0</code> of the container agent and at least version
    /// <code>1.26.0-1</code> of the <code>ecs-init</code> package to enable a proxy
    /// configuration. If your container instances are launched from the Amazon ECS-optimized
    /// AMI version <code>20190301</code> or later, then they contain the required versions of
    /// the container agent and <code>ecs-init</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-ami-versions.html">Amazon ECS-optimized AMI versions</a> in the
    /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub proxy_configuration: std::option::Option<crate::model::ProxyConfiguration>,
    /// <p>The Elastic Inference accelerators to use for the containers in the task.</p>
    pub inference_accelerators:
        std::option::Option<std::vec::Vec<crate::model::InferenceAccelerator>>,
    /// <p>The amount of ephemeral storage to allocate for the task. This parameter is used to
    /// expand the total amount of ephemeral storage available, beyond the default amount, for
    /// tasks hosted on Fargate. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/using_data_volumes.html">Fargate task
    /// storage</a> in the <i>Amazon ECS User Guide for Fargate</i>.</p>
    /// <note>
    /// <p>This parameter is only supported for tasks hosted on Fargate using the following platform versions:</p>
    /// <ul>
    /// <li>
    /// <p>Linux platform
    /// version <code>1.4.0</code> or later.</p>
    /// </li>
    /// <li>
    /// <p>Windows platform
    /// version <code>1.0.0</code> or later.</p>
    /// </li>
    /// </ul>
    /// </note>
    pub ephemeral_storage: std::option::Option<crate::model::EphemeralStorage>,
    /// <p>The operating system  that your tasks definitions run on. A platform family is specified only for tasks using the Fargate launch type. </p>
    /// <p>When you specify a task definition in a service, this value must match the <code>runtimePlatform</code> value of the service.</p>
    pub runtime_platform: std::option::Option<crate::model::RuntimePlatform>,
}
impl std::fmt::Debug for RegisterTaskDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterTaskDefinitionInput");
        formatter.field("family", &self.family);
        formatter.field("task_role_arn", &self.task_role_arn);
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("network_mode", &self.network_mode);
        formatter.field("container_definitions", &self.container_definitions);
        formatter.field("volumes", &self.volumes);
        formatter.field("placement_constraints", &self.placement_constraints);
        formatter.field("requires_compatibilities", &self.requires_compatibilities);
        formatter.field("cpu", &self.cpu);
        formatter.field("memory", &self.memory);
        formatter.field("tags", &self.tags);
        formatter.field("pid_mode", &self.pid_mode);
        formatter.field("ipc_mode", &self.ipc_mode);
        formatter.field("proxy_configuration", &self.proxy_configuration);
        formatter.field("inference_accelerators", &self.inference_accelerators);
        formatter.field("ephemeral_storage", &self.ephemeral_storage);
        formatter.field("runtime_platform", &self.runtime_platform);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterContainerInstanceInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster with which to register your container
    /// instance. If you do not specify a cluster, the default cluster is assumed.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The instance identity document for the EC2 instance to register. This document can be
    /// found by running the following command from the instance: <code>curl
    /// http://169.254.169.254/latest/dynamic/instance-identity/document/</code>
    /// </p>
    pub instance_identity_document: std::option::Option<std::string::String>,
    /// <p>The instance identity document signature for the EC2 instance to register. This
    /// signature can be found by running the following command from the instance: <code>curl
    /// http://169.254.169.254/latest/dynamic/instance-identity/signature/</code>
    /// </p>
    pub instance_identity_document_signature: std::option::Option<std::string::String>,
    /// <p>The resources available on the instance.</p>
    pub total_resources: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    /// <p>The version information for the Amazon ECS container agent and Docker daemon running on the
    /// container instance.</p>
    pub version_info: std::option::Option<crate::model::VersionInfo>,
    /// <p>The ARN of the container instance (if it was previously registered).</p>
    pub container_instance_arn: std::option::Option<std::string::String>,
    /// <p>The container instance attributes that this container instance supports.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
    /// <p>The devices that are available on the container instance. The only supported device
    /// type is a GPU.</p>
    pub platform_devices: std::option::Option<std::vec::Vec<crate::model::PlatformDevice>>,
    /// <p>The metadata that you apply to the container instance to help you categorize and
    /// organize them. Each tag consists of a key and an optional value, both of which you
    /// define.</p>
    /// <p>The following basic restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of tags per resource - 50</p>
    /// </li>
    /// <li>
    /// <p>For each resource, each tag key must be unique, and each tag key can have only
    /// one value.</p>
    /// </li>
    /// <li>
    /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>If your tagging schema is used across multiple services and resources,
    /// remember that other services may have restrictions on allowed characters.
    /// Generally allowed characters are: letters, numbers, and spaces representable in
    /// UTF-8, and the following characters: + - = . _ : / @.</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
    /// combination of such as a prefix for either keys or values as it is reserved for
    /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
    /// this prefix do not count against your tags per resource limit.</p>
    /// </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for RegisterContainerInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterContainerInstanceInput");
        formatter.field("cluster", &self.cluster);
        formatter.field(
            "instance_identity_document",
            &self.instance_identity_document,
        );
        formatter.field(
            "instance_identity_document_signature",
            &self.instance_identity_document_signature,
        );
        formatter.field("total_resources", &self.total_resources);
        formatter.field("version_info", &self.version_info);
        formatter.field("container_instance_arn", &self.container_instance_arn);
        formatter.field("attributes", &self.attributes);
        formatter.field("platform_devices", &self.platform_devices);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutClusterCapacityProvidersInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to modify the capacity provider
    /// settings for. If you do not specify a cluster, the default cluster is assumed.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The name of one or more capacity providers to associate with the cluster.</p>
    /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity
    /// provider must already be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.</p>
    /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
    /// <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are
    /// available to all accounts and only need to be associated with a cluster to be
    /// used.</p>
    pub capacity_providers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The capacity provider strategy to use by default for the cluster.</p>
    /// <p>When creating a service or running a task on a cluster, if no capacity provider or
    /// launch type is specified then the default capacity provider strategy for the cluster is
    /// used.</p>
    /// <p>A capacity provider strategy consists of one or more capacity providers along with the
    /// <code>base</code> and <code>weight</code> to assign to them. A capacity provider
    /// must be associated with the cluster to be used in a capacity provider strategy. The
    /// <a>PutClusterCapacityProviders</a> API is used to associate a capacity
    /// provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or
    /// <code>UPDATING</code> status can be used.</p>
    /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity
    /// provider must already be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.</p>
    /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
    /// <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are
    /// available to all accounts and only need to be associated with a cluster to be
    /// used.</p>
    pub default_capacity_provider_strategy:
        std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
}
impl std::fmt::Debug for PutClusterCapacityProvidersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutClusterCapacityProvidersInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("capacity_providers", &self.capacity_providers);
        formatter.field(
            "default_capacity_provider_strategy",
            &self.default_capacity_provider_strategy,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAttributesInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that contains the resource to apply
    /// attributes. If you do not specify a cluster, the default cluster is assumed.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The attributes to apply to your resource. You can specify up to 10 custom attributes
    /// per resource. You can specify up to 10 attributes in a single call.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
}
impl std::fmt::Debug for PutAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAttributesInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAccountSettingDefaultInput {
    /// <p>The resource name for which to modify the account setting. If
    /// <code>serviceLongArnFormat</code> is specified, the ARN for your Amazon ECS services is
    /// affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID for
    /// your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is
    /// specified, the ARN and resource ID for your Amazon ECS container instances is affected. If
    /// <code>awsvpcTrunking</code> is specified, the ENI limit for your Amazon ECS container
    /// instances is affected. If <code>containerInsights</code> is specified, the default
    /// setting for CloudWatch Container Insights for your clusters is affected.</p>
    pub name: std::option::Option<crate::model::SettingName>,
    /// <p>The account setting value for the specified principal ARN. Accepted values are
    /// <code>enabled</code> and <code>disabled</code>.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutAccountSettingDefaultInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAccountSettingDefaultInput");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAccountSettingInput {
    /// <p>The Amazon ECS resource name for which to modify the account setting. If
    /// <code>serviceLongArnFormat</code> is specified, the ARN for your Amazon ECS services is
    /// affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID for
    /// your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is
    /// specified, the ARN and resource ID for your Amazon ECS container instances is affected. If
    /// <code>awsvpcTrunking</code> is specified, the elastic network interface (ENI) limit
    /// for your Amazon ECS container instances is affected. If <code>containerInsights</code> is
    /// specified, the default setting for CloudWatch Container Insights for your clusters is
    /// affected.</p>
    pub name: std::option::Option<crate::model::SettingName>,
    /// <p>The account setting value for the specified principal ARN. Accepted values are
    /// <code>enabled</code> and <code>disabled</code>.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The ARN of the principal, which can be an IAM user, IAM role, or the root user. If you
    /// specify the root user, it modifies the account setting for all IAM users, IAM roles, and
    /// the root user of the account unless an IAM user or role explicitly overrides these
    /// settings. If this field is omitted, the setting is changed only for the authenticated
    /// user.</p>
    /// <note>
    /// <p>Federated users assume the account setting of the root user and can't have
    /// explicit account settings set for them.</p>
    /// </note>
    pub principal_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutAccountSettingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAccountSettingInput");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.field("principal_arn", &self.principal_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTasksInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the
    /// <code>ListTasks</code> results. If you do not specify a cluster, the default cluster is assumed.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The container instance ID or full ARN of the container instance to use when
    /// filtering the <code>ListTasks</code> results. Specifying a
    /// <code>containerInstance</code> limits the results to tasks that belong to that
    /// container instance.</p>
    pub container_instance: std::option::Option<std::string::String>,
    /// <p>The name of the task definition family to use when filtering the
    /// <code>ListTasks</code> results. Specifying a <code>family</code> limits the results
    /// to tasks that belong to that family.</p>
    pub family: std::option::Option<std::string::String>,
    /// <p>The <code>nextToken</code> value returned from a <code>ListTasks</code> request
    /// indicating that more results are available to fulfill the request and further calls will
    /// be needed. If <code>maxResults</code> was provided, it is possible the number of results
    /// to be fewer than <code>maxResults</code>.</p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to
    /// retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of task results returned by <code>ListTasks</code> in paginated
    /// output. When this parameter is used, <code>ListTasks</code> only returns
    /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
    /// response element. The remaining results of the initial request can be seen by sending
    /// another <code>ListTasks</code> request with the returned <code>nextToken</code> value.
    /// This value can be between 1 and 100. If this parameter is
    /// not used, then <code>ListTasks</code> returns up to 100 results and a
    /// <code>nextToken</code> value if applicable.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The <code>startedBy</code> value with which to filter the task results. Specifying a
    /// <code>startedBy</code> value limits the results to tasks that were started with that
    /// value.</p>
    pub started_by: std::option::Option<std::string::String>,
    /// <p>The name of the service to use when filtering the <code>ListTasks</code> results.
    /// Specifying a <code>serviceName</code> limits the results to tasks that belong to that
    /// service.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>The task desired status to use when filtering the <code>ListTasks</code> results.
    /// Specifying a <code>desiredStatus</code> of <code>STOPPED</code> limits the results to
    /// tasks that Amazon ECS has set the desired status to <code>STOPPED</code>. This can be useful
    /// for debugging tasks that are not starting properly or have died or finished. The default
    /// status filter is <code>RUNNING</code>, which shows tasks that Amazon ECS has set the desired
    /// status to <code>RUNNING</code>.</p>
    /// <note>
    /// <p>Although you can filter results based on a desired status of <code>PENDING</code>,
    /// this does not return any results. Amazon ECS never sets the desired status of a task to
    /// that value (only a task's <code>lastStatus</code> may have a value of
    /// <code>PENDING</code>).</p>
    /// </note>
    pub desired_status: std::option::Option<crate::model::DesiredStatus>,
    /// <p>The launch type to use when filtering the <code>ListTasks</code> results.</p>
    pub launch_type: std::option::Option<crate::model::LaunchType>,
}
impl std::fmt::Debug for ListTasksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTasksInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("container_instance", &self.container_instance);
        formatter.field("family", &self.family);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("started_by", &self.started_by);
        formatter.field("service_name", &self.service_name);
        formatter.field("desired_status", &self.desired_status);
        formatter.field("launch_type", &self.launch_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTaskDefinitionsInput {
    /// <p>The full family name with which to filter the <code>ListTaskDefinitions</code>
    /// results. Specifying a <code>familyPrefix</code> limits the listed task definitions to
    /// task definition revisions that belong to that family.</p>
    pub family_prefix: std::option::Option<std::string::String>,
    /// <p>The task definition status with which to filter the <code>ListTaskDefinitions</code>
    /// results. By default, only <code>ACTIVE</code> task definitions are listed. By setting
    /// this parameter to <code>INACTIVE</code>, you can view task definitions that are
    /// <code>INACTIVE</code> as long as an active task or service still references them. If
    /// you paginate the resulting output, be sure to keep the <code>status</code> value
    /// constant in each subsequent request.</p>
    pub status: std::option::Option<crate::model::TaskDefinitionStatus>,
    /// <p>The order in which to sort the results. Valid values are <code>ASC</code> and
    /// <code>DESC</code>. By default (<code>ASC</code>), task definitions are listed
    /// lexicographically by family name and in ascending numerical order by revision so that
    /// the newest task definitions in a family are listed last. Setting this parameter to
    /// <code>DESC</code> reverses the sort order on family name and revision so that the
    /// newest task definitions in a family are listed first.</p>
    pub sort: std::option::Option<crate::model::SortOrder>,
    /// <p>The <code>nextToken</code> value returned from a <code>ListTaskDefinitions</code>
    /// request indicating that more results are available to fulfill the request and further
    /// calls will be needed. If <code>maxResults</code> was provided, it is possible the number
    /// of results to be fewer than <code>maxResults</code>.</p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to
    /// retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of task definition results returned by
    /// <code>ListTaskDefinitions</code> in paginated output. When this parameter is used,
    /// <code>ListTaskDefinitions</code> only returns <code>maxResults</code> results in a
    /// single page along with a <code>nextToken</code> response element. The remaining results
    /// of the initial request can be seen by sending another <code>ListTaskDefinitions</code>
    /// request with the returned <code>nextToken</code> value. This value can be between
    /// 1 and 100. If this parameter is not used, then
    /// <code>ListTaskDefinitions</code> returns up to 100 results and a
    /// <code>nextToken</code> value if applicable.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListTaskDefinitionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTaskDefinitionsInput");
        formatter.field("family_prefix", &self.family_prefix);
        formatter.field("status", &self.status);
        formatter.field("sort", &self.sort);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTaskDefinitionFamiliesInput {
    /// <p>The <code>familyPrefix</code> is a string that is used to filter the results of
    /// <code>ListTaskDefinitionFamilies</code>. If you specify a <code>familyPrefix</code>,
    /// only task definition family names that begin with the <code>familyPrefix</code> string
    /// are returned.</p>
    pub family_prefix: std::option::Option<std::string::String>,
    /// <p>The task definition family status with which to filter the
    /// <code>ListTaskDefinitionFamilies</code> results. By default, both
    /// <code>ACTIVE</code> and <code>INACTIVE</code> task definition families are listed.
    /// If this parameter is set to <code>ACTIVE</code>, only task definition families that have
    /// an <code>ACTIVE</code> task definition revision are returned. If this parameter is set
    /// to <code>INACTIVE</code>, only task definition families that do not have any
    /// <code>ACTIVE</code> task definition revisions are returned. If you paginate the
    /// resulting output, be sure to keep the <code>status</code> value constant in each
    /// subsequent request.</p>
    pub status: std::option::Option<crate::model::TaskDefinitionFamilyStatus>,
    /// <p>The <code>nextToken</code> value returned from a
    /// <code>ListTaskDefinitionFamilies</code> request indicating that more results are
    /// available to fulfill the request and further calls will be needed. If
    /// <code>maxResults</code> was provided, it is possible the number of results to be
    /// fewer than <code>maxResults</code>.</p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to
    /// retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of task definition family results returned by
    /// <code>ListTaskDefinitionFamilies</code> in paginated output. When this parameter is
    /// used, <code>ListTaskDefinitions</code> only returns <code>maxResults</code> results in a
    /// single page along with a <code>nextToken</code> response element. The remaining results
    /// of the initial request can be seen by sending another
    /// <code>ListTaskDefinitionFamilies</code> request with the returned
    /// <code>nextToken</code> value. This value can be between 1 and
    /// 100. If this parameter is not used, then
    /// <code>ListTaskDefinitionFamilies</code> returns up to 100 results
    /// and a <code>nextToken</code> value if applicable.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListTaskDefinitionFamiliesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTaskDefinitionFamiliesInput");
        formatter.field("family_prefix", &self.family_prefix);
        formatter.field("status", &self.status);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the
    /// supported resources are Amazon ECS tasks, services, task definitions, clusters, and container
    /// instances.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServicesInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the
    /// <code>ListServices</code> results. If you do not specify a cluster, the default cluster is assumed.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The <code>nextToken</code> value returned from a <code>ListServices</code> request
    /// indicating that more results are available to fulfill the request and further calls will
    /// be needed. If <code>maxResults</code> was provided, it is possible the number of results
    /// to be fewer than <code>maxResults</code>.</p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to
    /// retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of service results returned by <code>ListServices</code> in
    /// paginated output. When this parameter is used, <code>ListServices</code> only returns
    /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
    /// response element. The remaining results of the initial request can be seen by sending
    /// another <code>ListServices</code> request with the returned <code>nextToken</code>
    /// value. This value can be between 1 and 100. If
    /// this parameter is not used, then <code>ListServices</code> returns up to
    /// 10 results and a <code>nextToken</code> value if
    /// applicable.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The launch type to use when filtering the <code>ListServices</code> results.</p>
    pub launch_type: std::option::Option<crate::model::LaunchType>,
    /// <p>The scheduling strategy to use when filtering the <code>ListServices</code>
    /// results.</p>
    pub scheduling_strategy: std::option::Option<crate::model::SchedulingStrategy>,
}
impl std::fmt::Debug for ListServicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServicesInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("launch_type", &self.launch_type);
        formatter.field("scheduling_strategy", &self.scheduling_strategy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListContainerInstancesInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to
    /// list. If you do not specify a cluster, the default cluster is assumed.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>You can filter the results of a <code>ListContainerInstances</code> operation with
    /// cluster query language statements. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language</a> in the
    /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub filter: std::option::Option<std::string::String>,
    /// <p>The <code>nextToken</code> value returned from a <code>ListContainerInstances</code>
    /// request indicating that more results are available to fulfill the request and further
    /// calls will be needed. If <code>maxResults</code> was provided, it is possible the number
    /// of results to be fewer than <code>maxResults</code>.</p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to
    /// retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of container instance results returned by
    /// <code>ListContainerInstances</code> in paginated output. When this parameter is
    /// used, <code>ListContainerInstances</code> only returns <code>maxResults</code> results
    /// in a single page along with a <code>nextToken</code> response element. The remaining
    /// results of the initial request can be seen by sending another
    /// <code>ListContainerInstances</code> request with the returned <code>nextToken</code>
    /// value. This value can be between 1 and 100. If this
    /// parameter is not used, then <code>ListContainerInstances</code> returns up to
    /// 100 results and a <code>nextToken</code> value if applicable.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Filters the container instances by status. For example, if you specify the
    /// <code>DRAINING</code> status, the results include only container instances that have
    /// been set to <code>DRAINING</code> using <a>UpdateContainerInstancesState</a>.
    /// If you do not specify this parameter, the default is to include container instances set
    /// to all states other than <code>INACTIVE</code>.</p>
    pub status: std::option::Option<crate::model::ContainerInstanceStatus>,
}
impl std::fmt::Debug for ListContainerInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListContainerInstancesInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListClustersInput {
    /// <p>The <code>nextToken</code> value returned from a <code>ListClusters</code> request
    /// indicating that more results are available to fulfill the request and further calls will
    /// be needed. If <code>maxResults</code> was provided, it is possible the number of results
    /// to be fewer than <code>maxResults</code>.</p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to
    /// retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of cluster results returned by <code>ListClusters</code> in
    /// paginated output. When this parameter is used, <code>ListClusters</code> only returns
    /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
    /// response element. The remaining results of the initial request can be seen by sending
    /// another <code>ListClusters</code> request with the returned <code>nextToken</code>
    /// value. This value can be between 1 and 100. If this
    /// parameter is not used, then <code>ListClusters</code> returns up to
    /// 100 results and a <code>nextToken</code> value if applicable.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListClustersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListClustersInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAttributesInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to list attributes.
    /// If you do not specify a cluster, the default cluster is assumed.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The type of the target with which to list attributes.</p>
    pub target_type: std::option::Option<crate::model::TargetType>,
    /// <p>The name of the attribute with which to filter the results. </p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The value of the attribute with which to filter results. You must also specify an
    /// attribute name to use this parameter.</p>
    pub attribute_value: std::option::Option<std::string::String>,
    /// <p>The <code>nextToken</code> value returned from a <code>ListAttributes</code> request
    /// indicating that more results are available to fulfill the request and further calls will
    /// be needed. If <code>maxResults</code> was provided, it is possible the number of results
    /// to be fewer than <code>maxResults</code>.</p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to
    /// retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of cluster results returned by <code>ListAttributes</code> in
    /// paginated output. When this parameter is used, <code>ListAttributes</code> only returns
    /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
    /// response element. The remaining results of the initial request can be seen by sending
    /// another <code>ListAttributes</code> request with the returned <code>nextToken</code>
    /// value. This value can be between 1 and 100. If this
    /// parameter is not used, then <code>ListAttributes</code> returns up to
    /// 100 results and a <code>nextToken</code> value if applicable.</p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAttributesInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("target_type", &self.target_type);
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("attribute_value", &self.attribute_value);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccountSettingsInput {
    /// <p>The name of the account setting you want to list the settings for.</p>
    pub name: std::option::Option<crate::model::SettingName>,
    /// <p>The value of the account settings with which to filter results. You must also specify
    /// an account setting name to use this parameter.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The ARN of the principal, which can be an IAM user, IAM role, or the root user. If
    /// this field is omitted, the account settings are listed only for the authenticated
    /// user.</p>
    /// <note>
    /// <p>Federated users assume the account setting of the root user and can't have
    /// explicit account settings set for them.</p>
    /// </note>
    pub principal_arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether to return the effective settings. If <code>true</code>, the account
    /// settings for the root user or the default setting for the <code>principalArn</code> are
    /// returned. If <code>false</code>, the account settings for the <code>principalArn</code>
    /// are returned if they are set. Otherwise, no account settings are returned.</p>
    pub effective_settings: bool,
    /// <p>The <code>nextToken</code> value returned from a <code>ListAccountSettings</code>
    /// request indicating that more results are available to fulfill the request and further
    /// calls will be needed. If <code>maxResults</code> was provided, it is possible the number
    /// of results to be fewer than <code>maxResults</code>.</p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to
    /// retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of account setting results returned by
    /// <code>ListAccountSettings</code> in paginated output. When this parameter is used,
    /// <code>ListAccountSettings</code> only returns <code>maxResults</code> results in a
    /// single page along with a <code>nextToken</code> response element. The remaining results
    /// of the initial request can be seen by sending another <code>ListAccountSettings</code>
    /// request with the returned <code>nextToken</code> value. This value can be between
    /// 1 and 10. If this
    /// parameter is not used, then <code>ListAccountSettings</code> returns up to
    /// 10 results and a <code>nextToken</code> value
    /// if applicable.</p>
    pub max_results: i32,
}
impl std::fmt::Debug for ListAccountSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccountSettingsInput");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.field("principal_arn", &self.principal_arn);
        formatter.field("effective_settings", &self.effective_settings);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteCommandInput {
    /// <p>The Amazon Resource Name (ARN) or short name of the cluster the task is running in.
    /// If you do not specify a cluster, the default cluster is assumed.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The name of the container to execute the command on. A container name only needs to be
    /// specified for tasks containing multiple containers.</p>
    pub container: std::option::Option<std::string::String>,
    /// <p>The command to run on the container.</p>
    pub command: std::option::Option<std::string::String>,
    /// <p>Use this flag to run your command in interactive mode.</p>
    pub interactive: bool,
    /// <p>The Amazon Resource Name (ARN) or ID of the task the container is part of.</p>
    pub task: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExecuteCommandInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteCommandInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("container", &self.container);
        formatter.field("command", &self.command);
        formatter.field("interactive", &self.interactive);
        formatter.field("task", &self.task);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DiscoverPollEndpointInput {
    /// <p>The container instance ID or full ARN of the container instance.
    /// The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the container instance, the Amazon Web Services account ID of the container instance owner, the <code>container-instance</code> namespace, and then the container instance ID. For example, <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.</p>
    pub container_instance: std::option::Option<std::string::String>,
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to which the container instance
    /// belongs.</p>
    pub cluster: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DiscoverPollEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DiscoverPollEndpointInput");
        formatter.field("container_instance", &self.container_instance);
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTaskSetsInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task
    /// sets exist in.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The short name or full Amazon Resource Name (ARN) of the service that the task sets exist in.</p>
    pub service: std::option::Option<std::string::String>,
    /// <p>The ID or full Amazon Resource Name (ARN) of task sets to
    /// describe.</p>
    pub task_sets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies whether to see the resource tags for the task set. If <code>TAGS</code> is
    /// specified, the tags are included in the response. If this field is omitted, tags are not
    /// included in the response.</p>
    pub include: std::option::Option<std::vec::Vec<crate::model::TaskSetField>>,
}
impl std::fmt::Debug for DescribeTaskSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTaskSetsInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("service", &self.service);
        formatter.field("task_sets", &self.task_sets);
        formatter.field("include", &self.include);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTasksInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task or tasks to
    /// describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the task or tasks you
    /// are describing were launched in any cluster other than the default cluster.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>A list of up to 100 task IDs or full ARN entries.</p>
    pub tasks: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies whether you want to see the resource tags for the task. If <code>TAGS</code>
    /// is specified, the tags are included in the response. If this field is omitted, tags are
    /// not included in the response.</p>
    pub include: std::option::Option<std::vec::Vec<crate::model::TaskField>>,
}
impl std::fmt::Debug for DescribeTasksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTasksInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("tasks", &self.tasks);
        formatter.field("include", &self.include);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTaskDefinitionInput {
    /// <p>The <code>family</code> for the latest <code>ACTIVE</code> revision,
    /// <code>family</code> and <code>revision</code> (<code>family:revision</code>) for a
    /// specific revision in the family, or full Amazon Resource Name (ARN) of the task definition to
    /// describe.</p>
    pub task_definition: std::option::Option<std::string::String>,
    /// <p>Specifies whether to see the resource tags for the task definition. If
    /// <code>TAGS</code> is specified, the tags are included in the response. If this field
    /// is omitted, tags are not included in the response.</p>
    pub include: std::option::Option<std::vec::Vec<crate::model::TaskDefinitionField>>,
}
impl std::fmt::Debug for DescribeTaskDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTaskDefinitionInput");
        formatter.field("task_definition", &self.task_definition);
        formatter.field("include", &self.include);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServicesInput {
    /// <p>The short name or full Amazon Resource Name (ARN)the cluster that hosts the service to describe.
    /// If you do not specify a cluster, the default cluster is assumed. This parameter is required if the service or services you are
    /// describing were launched in any cluster other than the default cluster.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>A list of services to describe. You may specify up to 10 services to describe in a
    /// single operation.</p>
    pub services: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies whether you want to see the resource tags for the service. If
    /// <code>TAGS</code> is specified, the tags are included in the response. If this field
    /// is omitted, tags are not included in the response.</p>
    pub include: std::option::Option<std::vec::Vec<crate::model::ServiceField>>,
}
impl std::fmt::Debug for DescribeServicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServicesInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("services", &self.services);
        formatter.field("include", &self.include);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeContainerInstancesInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to
    /// describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the container instance
    /// or container instances you are describing were launched in any cluster other than the
    /// default cluster.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.</p>
    pub container_instances: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies whether you want to see the resource tags for the container instance. If
    /// <code>TAGS</code> is specified, the tags are included in the response. If this field
    /// is omitted, tags are not included in the response.</p>
    pub include: std::option::Option<std::vec::Vec<crate::model::ContainerInstanceField>>,
}
impl std::fmt::Debug for DescribeContainerInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeContainerInstancesInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("container_instances", &self.container_instances);
        formatter.field("include", &self.include);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClustersInput {
    /// <p>A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries.
    /// If you do not specify a cluster, the default cluster is assumed.</p>
    pub clusters: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Whether to include additional information about the clusters in the response. If this
    /// field is omitted, this information isn't included.</p>
    /// <p>If <code>ATTACHMENTS</code> is specified, the attachments for the container instances
    /// or tasks within the cluster are included.</p>
    /// <p>If <code>SETTINGS</code> is specified, the settings for the cluster are
    /// included.</p>
    /// <p>If <code>CONFIGURATIONS</code> is specified, the configuration for the cluster is
    /// included.</p>
    /// <p>If <code>STATISTICS</code> is specified, the task and service count is included,
    /// separated by launch type.</p>
    /// <p>If <code>TAGS</code> is specified, the metadata tags associated with the cluster are
    /// included.</p>
    pub include: std::option::Option<std::vec::Vec<crate::model::ClusterField>>,
}
impl std::fmt::Debug for DescribeClustersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClustersInput");
        formatter.field("clusters", &self.clusters);
        formatter.field("include", &self.include);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCapacityProvidersInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of one or more capacity providers. Up to
    /// <code>100</code> capacity providers can be described in an action.</p>
    pub capacity_providers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies whether or not you want to see the resource tags for the capacity provider.
    /// If <code>TAGS</code> is specified, the tags are included in the response. If this field
    /// is omitted, tags are not included in the response.</p>
    pub include: std::option::Option<std::vec::Vec<crate::model::CapacityProviderField>>,
    /// <p>The maximum number of account setting results returned by
    /// <code>DescribeCapacityProviders</code> in paginated output. When this parameter is
    /// used, <code>DescribeCapacityProviders</code> only returns <code>maxResults</code>
    /// results in a single page along with a <code>nextToken</code> response element. The
    /// remaining results of the initial request can be seen by sending another
    /// <code>DescribeCapacityProviders</code> request with the returned
    /// <code>nextToken</code> value. This value can be between
    /// 1 and 10. If this
    /// parameter is not used, then <code>DescribeCapacityProviders</code> returns up to
    /// 10 results and a <code>nextToken</code> value
    /// if applicable.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>DescribeCapacityProviders</code> request where <code>maxResults</code> was
    /// used and the results exceeded the value of that parameter. Pagination continues from the
    /// end of the previous results that returned the <code>nextToken</code> value.</p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to
    /// retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeCapacityProvidersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCapacityProvidersInput");
        formatter.field("capacity_providers", &self.capacity_providers);
        formatter.field("include", &self.include);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterTaskDefinitionInput {
    /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or
    /// full Amazon Resource Name (ARN) of the task definition to deregister. You must specify a
    /// <code>revision</code>.</p>
    pub task_definition: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeregisterTaskDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterTaskDefinitionInput");
        formatter.field("task_definition", &self.task_definition);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterContainerInstanceInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instance to
    /// deregister. If you do not specify a cluster, the default cluster is assumed.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The container instance ID or full ARN of the container instance to deregister.
    /// The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the Region of the container instance, the Amazon Web Services account ID of the container instance owner, the <code>container-instance</code> namespace, and then the container instance ID. For example, <code>arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID</code>.</p>
    pub container_instance: std::option::Option<std::string::String>,
    /// <p>Forces the deregistration of the container instance. If you have tasks running on the
    /// container instance when you deregister it with the <code>force</code> option, these
    /// tasks remain running until you terminate the instance or the tasks stop through some
    /// other means, but they are orphaned (no longer monitored or accounted for by Amazon ECS). If
    /// an orphaned task on your container instance is part of an Amazon ECS service, then the
    /// service scheduler starts another copy of that task, on a different container instance if
    /// possible. </p>
    /// <p>Any containers in orphaned service tasks that are registered with a Classic Load Balancer or an Application Load Balancer
    /// target group are deregistered. They begin connection draining according to the settings
    /// on the load balancer or target group.</p>
    pub force: std::option::Option<bool>,
}
impl std::fmt::Debug for DeregisterContainerInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterContainerInstanceInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("container_instance", &self.container_instance);
        formatter.field("force", &self.force);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTaskSetInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task
    /// set exists in to delete.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The short name or full Amazon Resource Name (ARN) of the service that hosts the task set to
    /// delete.</p>
    pub service: std::option::Option<std::string::String>,
    /// <p>The task set ID or full Amazon Resource Name (ARN) of the task set to delete.</p>
    pub task_set: std::option::Option<std::string::String>,
    /// <p>If <code>true</code>, this allows you to delete a task set even if it hasn't been
    /// scaled down to zero.</p>
    pub force: std::option::Option<bool>,
}
impl std::fmt::Debug for DeleteTaskSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTaskSetInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("service", &self.service);
        formatter.field("task_set", &self.task_set);
        formatter.field("force", &self.force);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServiceInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to delete.
    /// If you do not specify a cluster, the default cluster is assumed.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The name of the service to delete.</p>
    pub service: std::option::Option<std::string::String>,
    /// <p>If <code>true</code>, allows you to delete a service even if it has not been scaled
    /// down to zero tasks. It is only necessary to use this if the service is using the
    /// <code>REPLICA</code> scheduling strategy.</p>
    pub force: std::option::Option<bool>,
}
impl std::fmt::Debug for DeleteServiceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServiceInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("service", &self.service);
        formatter.field("force", &self.force);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteClusterInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster to delete.</p>
    pub cluster: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteClusterInput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCapacityProviderInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the capacity provider to delete.</p>
    pub capacity_provider: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteCapacityProviderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCapacityProviderInput");
        formatter.field("capacity_provider", &self.capacity_provider);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAttributesInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that contains the resource to delete
    /// attributes. If you do not specify a cluster, the default cluster is assumed.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The attributes to delete from your resource. You can specify up to 10 attributes per
    /// request. For custom attributes, specify the attribute name and target ID, but do not
    /// specify the value. If you specify the target ID using the short form, you must also
    /// specify the target type.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
}
impl std::fmt::Debug for DeleteAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAttributesInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccountSettingInput {
    /// <p>The resource name for which to disable the account setting. If
    /// <code>serviceLongArnFormat</code> is specified, the ARN for your Amazon ECS services is
    /// affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID for
    /// your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is
    /// specified, the ARN and resource ID for your Amazon ECS container instances is affected. If
    /// <code>awsvpcTrunking</code> is specified, the ENI limit for your Amazon ECS container
    /// instances is affected.</p>
    pub name: std::option::Option<crate::model::SettingName>,
    /// <p>The ARN of the principal, which can be an IAM user, IAM role, or the root user. If you
    /// specify the root user, it disables the account setting for all IAM users, IAM roles, and
    /// the root user of the account unless an IAM user or role explicitly overrides these
    /// settings. If this field is omitted, the setting is changed only for the authenticated
    /// user.</p>
    pub principal_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteAccountSettingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccountSettingInput");
        formatter.field("name", &self.name);
        formatter.field("principal_arn", &self.principal_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTaskSetInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the service to create the task set in.</p>
    pub service: std::option::Option<std::string::String>,
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the
    /// task set in.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>An optional non-unique tag that identifies this task set in external systems. If the
    /// task set is associated with a service discovery registry, the tasks in this task set
    /// will have the <code>ECS_TASK_SET_EXTERNAL_ID</code> Cloud Map attribute set to the provided
    /// value.</p>
    pub external_id: std::option::Option<std::string::String>,
    /// <p>The task definition for the tasks in the task set to use.</p>
    pub task_definition: std::option::Option<std::string::String>,
    /// <p>An object representing the network configuration for a task set.</p>
    pub network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
    /// <p>A load balancer object representing the load balancer to use with the task set. The
    /// supported load balancer types are either an Application Load Balancer or a Network Load Balancer.</p>
    pub load_balancers: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
    /// <p>The details of the service discovery registries to assign to this task set. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
    /// Discovery</a>.</p>
    pub service_registries: std::option::Option<std::vec::Vec<crate::model::ServiceRegistry>>,
    /// <p>The launch type that new tasks in the task set will use. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>If a <code>launchType</code> is specified, the <code>capacityProviderStrategy</code>
    /// parameter must be omitted.</p>
    pub launch_type: std::option::Option<crate::model::LaunchType>,
    /// <p>The capacity provider strategy to use for the task set.</p>
    /// <p>A capacity provider strategy consists of one or more capacity providers along with the
    /// <code>base</code> and <code>weight</code> to assign to them. A capacity provider
    /// must be associated with the cluster to be used in a capacity provider strategy. The
    /// <a>PutClusterCapacityProviders</a> API is used to associate a capacity
    /// provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or
    /// <code>UPDATING</code> status can be used.</p>
    /// <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code>
    /// parameter must be omitted. If no <code>capacityProviderStrategy</code> or
    /// <code>launchType</code> is specified, the
    /// <code>defaultCapacityProviderStrategy</code> for the cluster is used.</p>
    /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity
    /// provider must already be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.</p>
    /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
    /// <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are
    /// available to all accounts and only need to be associated with a cluster to be
    /// used.</p>
    /// <p>The <a>PutClusterCapacityProviders</a> API operation is used to update the
    /// list of available capacity providers for a cluster after the cluster is created.</p>
    pub capacity_provider_strategy:
        std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
    /// <p>The platform version that the tasks in the task set should use. A platform version is
    /// specified only for tasks using the Fargate launch type. If one isn't
    /// specified, the <code>LATEST</code> platform version is used by default.</p>
    pub platform_version: std::option::Option<std::string::String>,
    /// <p>A floating-point percentage of the desired number of tasks to place and keep running
    /// in the task set.</p>
    pub scale: std::option::Option<crate::model::Scale>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request. Up to 32 ASCII characters are allowed.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The metadata that you apply to the task set to help you categorize and organize them.
    /// Each tag consists of a key and an optional value, both of which you define. When a
    /// service is deleted, the tags are deleted as well.</p>
    /// <p>The following basic restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of tags per resource - 50</p>
    /// </li>
    /// <li>
    /// <p>For each resource, each tag key must be unique, and each tag key can have only
    /// one value.</p>
    /// </li>
    /// <li>
    /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>If your tagging schema is used across multiple services and resources,
    /// remember that other services may have restrictions on allowed characters.
    /// Generally allowed characters are: letters, numbers, and spaces representable in
    /// UTF-8, and the following characters: + - = . _ : / @.</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
    /// combination of such as a prefix for either keys or values as it is reserved for
    /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
    /// this prefix do not count against your tags per resource limit.</p>
    /// </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateTaskSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTaskSetInput");
        formatter.field("service", &self.service);
        formatter.field("cluster", &self.cluster);
        formatter.field("external_id", &self.external_id);
        formatter.field("task_definition", &self.task_definition);
        formatter.field("network_configuration", &self.network_configuration);
        formatter.field("load_balancers", &self.load_balancers);
        formatter.field("service_registries", &self.service_registries);
        formatter.field("launch_type", &self.launch_type);
        formatter.field(
            "capacity_provider_strategy",
            &self.capacity_provider_strategy,
        );
        formatter.field("platform_version", &self.platform_version);
        formatter.field("scale", &self.scale);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServiceInput {
    /// <p>The short name or full Amazon Resource Name (ARN) of the cluster on which to run your service.
    /// If you do not specify a cluster, the default cluster is assumed.</p>
    pub cluster: std::option::Option<std::string::String>,
    /// <p>The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. Service names must be unique within
    /// a cluster, but you can have similarly named services in multiple clusters within a
    /// Region or across multiple Regions.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or
    /// full ARN of the task definition to run in your service. If a <code>revision</code> is
    /// not specified, the latest <code>ACTIVE</code> revision is used.</p>
    /// <p>A task definition must be specified if the service is using either the
    /// <code>ECS</code> or <code>CODE_DEPLOY</code> deployment controllers.</p>
    pub task_definition: std::option::Option<std::string::String>,
    /// <p>A load balancer object representing the load balancers to use with your service. For
    /// more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service Load Balancing</a> in the
    /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>If the service is using the rolling update (<code>ECS</code>) deployment controller
    /// and using either an Application Load Balancer or Network Load Balancer, you must specify one or more target group ARNs to
    /// attach to the service. The service-linked role is required for services that make use of
    /// multiple target groups. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using service-linked roles for Amazon ECS</a> in the
    /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>If the service is using the <code>CODE_DEPLOY</code> deployment controller, the
    /// service is required to use either an Application Load Balancer or Network Load Balancer. When creating an CodeDeploy deployment
    /// group, you specify two target groups (referred to as a <code>targetGroupPair</code>).
    /// During a deployment, CodeDeploy determines which task set in your service has the status
    /// <code>PRIMARY</code> and associates one target group with it, and then associates
    /// the other target group with the replacement task set. The load balancer can also have up
    /// to two listeners: a required listener for production traffic and an optional listener
    /// that allows you perform validation tests with Lambda functions before routing production
    /// traffic to it.</p>
    /// <p>After you create a service using the <code>ECS</code> deployment controller, the load
    /// balancer name or target group ARN, container name, and container port specified in the
    /// service definition are immutable. If you are using the <code>CODE_DEPLOY</code>
    /// deployment controller, these values can be changed when updating the service.</p>
    /// <p>For Application Load Balancers and Network Load Balancers, this object must contain the load balancer target group ARN,
    /// the container name (as it appears in a container definition), and the container port to
    /// access from the load balancer. The load balancer name parameter must be omitted. When a
    /// task from this service is placed on a container instance, the container instance and
    /// port combination is registered as a target in the target group specified here.</p>
    /// <p>For Classic Load Balancers, this object must contain the load balancer name, the container name (as it
    /// appears in a container definition), and the container port to access from the load
    /// balancer. The target group ARN parameter must be omitted. When a task from this service
    /// is placed on a container instance, the container instance is registered with the load
    /// balancer specified here.</p>
    /// <p>Services with tasks that use the <code>awsvpc</code> network mode (for example, those
    /// with the Fargate launch type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers are
    /// not supported. Also, when you create any target groups for these services, you must
    /// choose <code>ip</code> as the target type, not <code>instance</code>, because tasks that
    /// use the <code>awsvpc</code> network mode are associated with an elastic network
    /// interface, not an Amazon EC2 instance.</p>
    pub load_balancers: std::option::Option<std::vec::Vec<crate::model::LoadBalancer>>,
    /// <p>The details of the service discovery registry to associate with this service. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
    /// discovery</a>.</p>
    /// <note>
    /// <p>Each service may be associated with one service registry. Multiple service
    /// registries per service isn't supported.</p>
    /// </note>
    pub service_registries: std::option::Option<std::vec::Vec<crate::model::ServiceRegistry>>,
    /// <p>The number of instantiations of the specified task definition to place and keep
    /// running on your cluster.</p>
    /// <p>This is required if <code>schedulingStrategy</code> is <code>REPLICA</code> or is not
    /// specified. If <code>schedulingStrategy</code> is <code>DAEMON</code> then this is not
    /// required.</p>
    pub desired_count: std::option::Option<i32>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request. Up to 32 ASCII characters are allowed.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The infrastructure on which to run your service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS
    /// launch types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// <p>The <code>FARGATE</code> launch type runs your tasks on Fargate On-Demand
    /// infrastructure.</p>
    /// <note>
    /// <p>Fargate Spot infrastructure is available for use but a capacity provider
    /// strategy must be used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html">Fargate capacity providers</a> in the
    /// <i>Amazon ECS User Guide for Fargate</i>.</p>
    /// </note>
    /// <p>The <code>EC2</code> launch type runs your tasks on Amazon EC2 instances registered to your
    /// cluster.</p>
    /// <p>The <code>EXTERNAL</code> launch type runs your tasks on your on-premise server or
    /// virtual machine (VM) capacity registered to your cluster.</p>
    /// <p>A service can use either a launch type or a capacity provider strategy. If a
    /// <code>launchType</code> is specified, the <code>capacityProviderStrategy</code>
    /// parameter must be omitted.</p>
    pub launch_type: std::option::Option<crate::model::LaunchType>,
    /// <p>The capacity provider strategy to use for the service.</p>
    /// <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code>
    /// parameter must be omitted. If no <code>capacityProviderStrategy</code> or
    /// <code>launchType</code> is specified, the
    /// <code>defaultCapacityProviderStrategy</code> for the cluster is used.</p>
    /// <p>A capacity provider strategy may contain a maximum of 6 capacity providers.</p>
    pub capacity_provider_strategy:
        std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
    /// <p>The platform version that your tasks in the service are running on. A platform version
    /// is specified only for tasks using the Fargate launch type. If one isn't
    /// specified, the <code>LATEST</code> platform version is used by default. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate platform
    /// versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub platform_version: std::option::Option<std::string::String>,
    /// <p>The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your
    /// load balancer on your behalf. This parameter is only permitted if you are using a load
    /// balancer with your service and your task definition does not use the <code>awsvpc</code>
    /// network mode. If you specify the <code>role</code> parameter, you must also specify a
    /// load balancer object with the <code>loadBalancers</code> parameter.</p>
    /// <important>
    /// <p>If your account has already created the Amazon ECS service-linked role, that role is
    /// used by default for your service unless you specify a role here. The service-linked
    /// role is required if your task definition uses the <code>awsvpc</code> network mode
    /// or if the service is configured to use service discovery, an external deployment
    /// controller, multiple target groups, or Elastic Inference accelerators in which case
    /// you should not specify a role here. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using
    /// service-linked roles for Amazon ECS</a> in the
    /// <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    /// </important>
    /// <p>If your specified role has a path other than <code>/</code>, then you must either
    /// specify the full role ARN (this is recommended) or prefix the role name with the path.
    /// For example, if a role with the name <code>bar</code> has a path of <code>/foo/</code>
    /// then you would specify <code>/foo/bar</code> as the role name. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">Friendly names and paths</a> in the <i>IAM User Guide</i>.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>Optional deployment parameters that control how many tasks run during the deployment
    /// and the ordering of stopping and starting tasks.</p>
    pub deployment_configuration: std::option::Option<crate::model::DeploymentConfiguration>,
    /// <p>An array of placement constraint objects to use for tasks in your service. You can
    /// specify a maximum of 10 constraints per task (this limit includes constraints in the
    /// task definition and those specified at runtime).</p>
    pub placement_constraints:
        std::option::Option<std::vec::Vec<crate::model::PlacementConstraint>>,
    /// <p>The placement strategy objects to use for tasks in your service. You can specify a
    /// maximum of 5 strategy rules per service.</p>
    pub placement_strategy: std::option::Option<std::vec::Vec<crate::model::PlacementStrategy>>,
    /// <p>The network configuration for the service. This parameter is required for task
    /// definitions that use the <code>awsvpc</code> network mode to receive their own elastic
    /// network interface, and it is not supported for other network modes. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task networking</a>
    /// in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
    /// <p>The period of time, in seconds, that the Amazon ECS service scheduler should ignore
    /// unhealthy Elastic Load Balancing target health checks after a task has first started. This is only used
    /// when your service is configured to use a load balancer. If your service has a load
    /// balancer defined and you don't specify a health check grace period value, the default
    /// value of <code>0</code> is used.</p>
    /// <p>If your service's tasks take a while to start and respond to Elastic Load Balancing health checks, you
    /// can specify a health check grace period of up to 2,147,483,647 seconds. During that
    /// time, the Amazon ECS service scheduler ignores health check status. This grace period can
    /// prevent the service scheduler from marking tasks as unhealthy and stopping them before
    /// they have time to come up.</p>
    pub health_check_grace_period_seconds: std::option::Option<i32>,
    /// <p>The scheduling strategy to use for the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
    /// <p>There are two service scheduler strategies available:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>REPLICA</code>-The replica scheduling strategy places and
    /// maintains the desired number of tasks across your cluster. By default, the
    /// service scheduler spreads tasks across Availability Zones. You can use task
    /// placement strategies and constraints to customize task placement decisions. This
    /// scheduler strategy is required if the service is using the
    /// <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller
    /// types.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one
    /// task on each active container instance that meets all of the task placement
    /// constraints that you specify in your cluster. The service scheduler also
    /// evaluates the task placement constraints for running tasks and will stop tasks
    /// that do not meet the placement constraints. When you're using this strategy, you
    /// don't need to specify a desired number of tasks, a task placement strategy, or
    /// use Service Auto Scaling policies.</p>
    /// <note>
    /// <p>Tasks using the Fargate launch type or the
    /// <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller
    /// types don't support the <code>DAEMON</code> scheduling strategy.</p>
    /// </note>
    /// </li>
    /// </ul>
    pub scheduling_strategy: std::option::Option<crate::model::SchedulingStrategy>,
    /// <p>The deployment controller to use for the service. If no deployment controller is
    /// specified, the default value of <code>ECS</code> is used.</p>
    pub deployment_controller: std::option::Option<crate::model::DeploymentController>,
    /// <p>The metadata that you apply to the service to help you categorize and organize them.
    /// Each tag consists of a key and an optional value, both of which you define. When a
    /// service is deleted, the tags are deleted as well.</p>
    /// <p>The following basic restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of tags per resource - 50</p>
    /// </li>
    /// <li>
    /// <p>For each resource, each tag key must be unique, and each tag key can have only
    /// one value.</p>
    /// </li>
    /// <li>
    /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>If your tagging schema is used across multiple services and resources,
    /// remember that other services may have restrictions on allowed characters.
    /// Generally allowed characters are: letters, numbers, and spaces representable in
    /// UTF-8, and the following characters: + - = . _ : / @.</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
    /// combination of such as a prefix for either keys or values as it is reserved for
    /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
    /// this prefix do not count against your tags per resource limit.</p>
    /// </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Specifies whether to enable Amazon ECS managed tags for the tasks within the service. For
    /// more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS
    /// Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub enable_ecs_managed_tags: bool,
    /// <p>Specifies whether to propagate the tags from the task definition or the service to the
    /// tasks in the service. If no value is specified, the tags are not propagated. Tags can
    /// only be propagated to the tasks within the service during service creation. To add tags
    /// to a task after service creation or task creation, use the <a>TagResource</a> API
    /// action.</p>
    pub propagate_tags: std::option::Option<crate::model::PropagateTags>,
    /// <p>Whether or not the execute command functionality is enabled for the service. If
    /// <code>true</code>, this enables execute command functionality on all containers in
    /// the service tasks.</p>
    pub enable_execute_command: bool,
}
impl std::fmt::Debug for CreateServiceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServiceInput");
        formatter.field("cluster", &self.cluster);
        formatter.field("service_name", &self.service_name);
        formatter.field("task_definition", &self.task_definition);
        formatter.field("load_balancers", &self.load_balancers);
        formatter.field("service_registries", &self.service_registries);
        formatter.field("desired_count", &self.desired_count);
        formatter.field("client_token", &self.client_token);
        formatter.field("launch_type", &self.launch_type);
        formatter.field(
            "capacity_provider_strategy",
            &self.capacity_provider_strategy,
        );
        formatter.field("platform_version", &self.platform_version);
        formatter.field("role", &self.role);
        formatter.field("deployment_configuration", &self.deployment_configuration);
        formatter.field("placement_constraints", &self.placement_constraints);
        formatter.field("placement_strategy", &self.placement_strategy);
        formatter.field("network_configuration", &self.network_configuration);
        formatter.field(
            "health_check_grace_period_seconds",
            &self.health_check_grace_period_seconds,
        );
        formatter.field("scheduling_strategy", &self.scheduling_strategy);
        formatter.field("deployment_controller", &self.deployment_controller);
        formatter.field("tags", &self.tags);
        formatter.field("enable_ecs_managed_tags", &self.enable_ecs_managed_tags);
        formatter.field("propagate_tags", &self.propagate_tags);
        formatter.field("enable_execute_command", &self.enable_execute_command);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateClusterInput {
    /// <p>The name of your cluster. If you do not specify a name for your cluster, you create a
    /// cluster named <code>default</code>. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. </p>
    pub cluster_name: std::option::Option<std::string::String>,
    /// <p>The metadata that you apply to the cluster to help you categorize and organize them.
    /// Each tag consists of a key and an optional value, both of which you define.</p>
    /// <p>The following basic restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of tags per resource - 50</p>
    /// </li>
    /// <li>
    /// <p>For each resource, each tag key must be unique, and each tag key can have only
    /// one value.</p>
    /// </li>
    /// <li>
    /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>If your tagging schema is used across multiple services and resources,
    /// remember that other services may have restrictions on allowed characters.
    /// Generally allowed characters are: letters, numbers, and spaces representable in
    /// UTF-8, and the following characters: + - = . _ : / @.</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
    /// combination of such as a prefix for either keys or values as it is reserved for
    /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
    /// this prefix do not count against your tags per resource limit.</p>
    /// </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The setting to use when creating a cluster. This parameter is used to enable CloudWatch
    /// Container Insights for a cluster. If this value is specified, it will override the
    /// <code>containerInsights</code> value set with <a>PutAccountSetting</a> or
    /// <a>PutAccountSettingDefault</a>.</p>
    pub settings: std::option::Option<std::vec::Vec<crate::model::ClusterSetting>>,
    /// <p>The execute command configuration for the cluster.</p>
    pub configuration: std::option::Option<crate::model::ClusterConfiguration>,
    /// <p>The short name of one or more capacity providers to associate with the cluster. A
    /// capacity provider must be associated with a cluster before it can be included as part of
    /// the default capacity provider strategy of the cluster or used in a capacity provider
    /// strategy when calling the <a>CreateService</a> or <a>RunTask</a>
    /// actions.</p>
    /// <p>If specifying a capacity provider that uses an Auto Scaling group, the capacity
    /// provider must already be created and not already associated with another cluster. New
    /// Auto Scaling group capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.</p>
    /// <p>To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
    /// <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are
    /// available to all accounts and only need to be associated with a cluster to be
    /// used.</p>
    /// <p>The <a>PutClusterCapacityProviders</a> API operation is used to update the
    /// list of available capacity providers for a cluster after the cluster is created.</p>
    pub capacity_providers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The capacity provider strategy to set as the default for the cluster. When a default
    /// capacity provider strategy is set for a cluster, when calling the <a>RunTask</a> or <a>CreateService</a> APIs with no capacity
    /// provider strategy or launch type specified, the default capacity provider strategy for
    /// the cluster is used.</p>
    /// <p>If a default capacity provider strategy is not defined for a cluster during creation,
    /// it can be defined later with the <a>PutClusterCapacityProviders</a> API
    /// operation.</p>
    pub default_capacity_provider_strategy:
        std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
}
impl std::fmt::Debug for CreateClusterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateClusterInput");
        formatter.field("cluster_name", &self.cluster_name);
        formatter.field("tags", &self.tags);
        formatter.field("settings", &self.settings);
        formatter.field("configuration", &self.configuration);
        formatter.field("capacity_providers", &self.capacity_providers);
        formatter.field(
            "default_capacity_provider_strategy",
            &self.default_capacity_provider_strategy,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCapacityProviderInput {
    /// <p>The name of the capacity provider. Up to 255 characters are allowed, including letters
    /// (upper and lowercase), numbers, underscores, and hyphens. The name cannot be prefixed
    /// with "<code>aws</code>", "<code>ecs</code>", or "<code>fargate</code>".</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The details of the Auto Scaling group for the capacity provider.</p>
    pub auto_scaling_group_provider: std::option::Option<crate::model::AutoScalingGroupProvider>,
    /// <p>The metadata that you apply to the capacity provider to help you categorize and
    /// organize them. Each tag consists of a key and an optional value, both of which you
    /// define.</p>
    /// <p>The following basic restrictions apply to tags:</p>
    /// <ul>
    /// <li>
    /// <p>Maximum number of tags per resource - 50</p>
    /// </li>
    /// <li>
    /// <p>For each resource, each tag key must be unique, and each tag key can have only
    /// one value.</p>
    /// </li>
    /// <li>
    /// <p>Maximum key length - 128 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>Maximum value length - 256 Unicode characters in UTF-8</p>
    /// </li>
    /// <li>
    /// <p>If your tagging schema is used across multiple services and resources,
    /// remember that other services may have restrictions on allowed characters.
    /// Generally allowed characters are: letters, numbers, and spaces representable in
    /// UTF-8, and the following characters: + - = . _ : / @.</p>
    /// </li>
    /// <li>
    /// <p>Tag keys and values are case-sensitive.</p>
    /// </li>
    /// <li>
    /// <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase
    /// combination of such as a prefix for either keys or values as it is reserved for
    /// Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with
    /// this prefix do not count against your tags per resource limit.</p>
    /// </li>
    /// </ul>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateCapacityProviderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCapacityProviderInput");
        formatter.field("name", &self.name);
        formatter.field(
            "auto_scaling_group_provider",
            &self.auto_scaling_group_provider,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
