// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchCheckLayerAvailability` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchCheckLayerAvailabilityError {
    /// Kind of error that occurred.
    pub kind: BatchCheckLayerAvailabilityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchCheckLayerAvailability` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchCheckLayerAvailabilityErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The registry does not exist.</p>
    RegistryNotFoundException(crate::error::RegistryNotFoundException),
    /// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchCheckLayerAvailabilityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchCheckLayerAvailabilityErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            BatchCheckLayerAvailabilityErrorKind::RegistryNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            BatchCheckLayerAvailabilityErrorKind::RepositoryNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            BatchCheckLayerAvailabilityErrorKind::ServerException(_inner) => _inner.fmt(f),
            BatchCheckLayerAvailabilityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchCheckLayerAvailabilityError {
    fn code(&self) -> Option<&str> {
        BatchCheckLayerAvailabilityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchCheckLayerAvailabilityError {
    /// Creates a new `BatchCheckLayerAvailabilityError`.
    pub fn new(kind: BatchCheckLayerAvailabilityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchCheckLayerAvailabilityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchCheckLayerAvailabilityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchCheckLayerAvailabilityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchCheckLayerAvailabilityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchCheckLayerAvailabilityErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCheckLayerAvailabilityErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCheckLayerAvailabilityErrorKind::RegistryNotFoundException`.
    pub fn is_registry_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCheckLayerAvailabilityErrorKind::RegistryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCheckLayerAvailabilityErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCheckLayerAvailabilityErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCheckLayerAvailabilityErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCheckLayerAvailabilityErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for BatchCheckLayerAvailabilityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchCheckLayerAvailabilityErrorKind::InvalidParameterException(_inner) => Some(_inner),
            BatchCheckLayerAvailabilityErrorKind::RegistryNotFoundException(_inner) => Some(_inner),
            BatchCheckLayerAvailabilityErrorKind::RepositoryNotFoundException(_inner) => {
                Some(_inner)
            }
            BatchCheckLayerAvailabilityErrorKind::ServerException(_inner) => Some(_inner),
            BatchCheckLayerAvailabilityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDeleteImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDeleteImageError {
    /// Kind of error that occurred.
    pub kind: BatchDeleteImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDeleteImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDeleteImageErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDeleteImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDeleteImageErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            BatchDeleteImageErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            BatchDeleteImageErrorKind::ServerException(_inner) => _inner.fmt(f),
            BatchDeleteImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDeleteImageError {
    fn code(&self) -> Option<&str> {
        BatchDeleteImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDeleteImageError {
    /// Creates a new `BatchDeleteImageError`.
    pub fn new(kind: BatchDeleteImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDeleteImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDeleteImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDeleteImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDeleteImageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDeleteImageErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteImageErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteImageErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteImageErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteImageErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, BatchDeleteImageErrorKind::ServerException(_))
    }
}
impl std::error::Error for BatchDeleteImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDeleteImageErrorKind::InvalidParameterException(_inner) => Some(_inner),
            BatchDeleteImageErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            BatchDeleteImageErrorKind::ServerException(_inner) => Some(_inner),
            BatchDeleteImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CompleteLayerUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CompleteLayerUploadError {
    /// Kind of error that occurred.
    pub kind: CompleteLayerUploadErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CompleteLayerUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CompleteLayerUploadErrorKind {
    /// <p>The specified layer upload does not contain any layer parts.</p>
    EmptyUploadException(crate::error::EmptyUploadException),
    /// <p>The layer digest calculation performed by Amazon ECR upon receipt of the image layer does not match the digest specified.</p>
    InvalidLayerException(crate::error::InvalidLayerException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The image layer already exists in the associated repository.</p>
    LayerAlreadyExistsException(crate::error::LayerAlreadyExistsException),
    /// <p>Layer parts must be at least 5 MiB in size.</p>
    LayerPartTooSmallException(crate::error::LayerPartTooSmallException),
    /// <p>The registry does not exist.</p>
    RegistryNotFoundException(crate::error::RegistryNotFoundException),
    /// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The action is not supported in this Region.</p>
    UnsupportedCommandException(crate::error::UnsupportedCommandException),
    /// <p>The upload could not be found, or the specified upload ID is not valid for this repository.</p>
    UploadNotFoundException(crate::error::UploadNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CompleteLayerUploadError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CompleteLayerUploadErrorKind::EmptyUploadException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::InvalidLayerException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::LayerAlreadyExistsException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::LayerPartTooSmallException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::RegistryNotFoundException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::ServerException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::UnsupportedCommandException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::UploadNotFoundException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CompleteLayerUploadError {
    fn code(&self) -> Option<&str> {
        CompleteLayerUploadError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CompleteLayerUploadError {
    /// Creates a new `CompleteLayerUploadError`.
    pub fn new(kind: CompleteLayerUploadErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CompleteLayerUploadError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CompleteLayerUploadErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CompleteLayerUploadError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CompleteLayerUploadErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::EmptyUploadException`.
    pub fn is_empty_upload_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteLayerUploadErrorKind::EmptyUploadException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::InvalidLayerException`.
    pub fn is_invalid_layer_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteLayerUploadErrorKind::InvalidLayerException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteLayerUploadErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::LayerAlreadyExistsException`.
    pub fn is_layer_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteLayerUploadErrorKind::LayerAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::LayerPartTooSmallException`.
    pub fn is_layer_part_too_small_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteLayerUploadErrorKind::LayerPartTooSmallException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::RegistryNotFoundException`.
    pub fn is_registry_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteLayerUploadErrorKind::RegistryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteLayerUploadErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, CompleteLayerUploadErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::UnsupportedCommandException`.
    pub fn is_unsupported_command_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteLayerUploadErrorKind::UnsupportedCommandException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::UploadNotFoundException`.
    pub fn is_upload_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteLayerUploadErrorKind::UploadNotFoundException(_)
        )
    }
}
impl std::error::Error for CompleteLayerUploadError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CompleteLayerUploadErrorKind::EmptyUploadException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::InvalidLayerException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::LayerAlreadyExistsException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::LayerPartTooSmallException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::RegistryNotFoundException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::ServerException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::UnsupportedCommandException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::UploadNotFoundException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRepositoryError {
    /// Kind of error that occurred.
    pub kind: CreateRepositoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRepositoryErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    InvalidTagParameterException(crate::error::InvalidTagParameterException),
    /// <p>The operation did not succeed because it would have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR Service Quotas</a> in the Amazon Elastic Container Registry User Guide.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified repository already exists in the specified registry.</p>
    RepositoryAlreadyExistsException(crate::error::RepositoryAlreadyExistsException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a repository is 50.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRepositoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRepositoryErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::InvalidTagParameterException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::RepositoryAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::ServerException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRepositoryError {
    fn code(&self) -> Option<&str> {
        CreateRepositoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRepositoryError {
    /// Creates a new `CreateRepositoryError`.
    pub fn new(kind: CreateRepositoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRepositoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRepositoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRepositoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRepositoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::InvalidTagParameterException`.
    pub fn is_invalid_tag_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::InvalidTagParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::RepositoryAlreadyExistsException`.
    pub fn is_repository_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::RepositoryAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, CreateRepositoryErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreateRepositoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRepositoryErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::InvalidTagParameterException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::RepositoryAlreadyExistsException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::ServerException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRepositoryError {
    /// Kind of error that occurred.
    pub kind: DeleteRepositoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRepositoryErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository contains images. To delete a repository that contains images, you must force the deletion with the <code>force</code> parameter.</p>
    RepositoryNotEmptyException(crate::error::RepositoryNotEmptyException),
    /// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRepositoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRepositoryErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::RepositoryNotEmptyException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRepositoryError {
    fn code(&self) -> Option<&str> {
        DeleteRepositoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRepositoryError {
    /// Creates a new `DeleteRepositoryError`.
    pub fn new(kind: DeleteRepositoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRepositoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRepositoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRepositoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRepositoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::RepositoryNotEmptyException`.
    pub fn is_repository_not_empty_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::RepositoryNotEmptyException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteRepositoryErrorKind::ServerException(_))
    }
}
impl std::error::Error for DeleteRepositoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRepositoryErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::RepositoryNotEmptyException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::ServerException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRepositoryPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRepositoryPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteRepositoryPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRepositoryPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRepositoryPolicyErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>The specified repository and registry combination does not have an associated repository policy.</p>
    RepositoryPolicyNotFoundException(crate::error::RepositoryPolicyNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRepositoryPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRepositoryPolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteRepositoryPolicyErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            DeleteRepositoryPolicyErrorKind::RepositoryPolicyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRepositoryPolicyErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeleteRepositoryPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRepositoryPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteRepositoryPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRepositoryPolicyError {
    /// Creates a new `DeleteRepositoryPolicyError`.
    pub fn new(kind: DeleteRepositoryPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRepositoryPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRepositoryPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRepositoryPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRepositoryPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRepositoryPolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryPolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryPolicyErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryPolicyErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryPolicyErrorKind::RepositoryPolicyNotFoundException`.
    pub fn is_repository_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryPolicyErrorKind::RepositoryPolicyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryPolicyErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryPolicyErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DeleteRepositoryPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRepositoryPolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteRepositoryPolicyErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            DeleteRepositoryPolicyErrorKind::RepositoryPolicyNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteRepositoryPolicyErrorKind::ServerException(_inner) => Some(_inner),
            DeleteRepositoryPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeImages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeImagesError {
    /// Kind of error that occurred.
    pub kind: DescribeImagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeImages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeImagesErrorKind {
    /// <p>The image requested does not exist in the specified repository.</p>
    ImageNotFoundException(crate::error::ImageNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeImagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeImagesErrorKind::ImageNotFoundException(_inner) => _inner.fmt(f),
            DescribeImagesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeImagesErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            DescribeImagesErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeImagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeImagesError {
    fn code(&self) -> Option<&str> {
        DescribeImagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeImagesError {
    /// Creates a new `DescribeImagesError`.
    pub fn new(kind: DescribeImagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeImagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeImagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeImagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeImagesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeImagesErrorKind::ImageNotFoundException`.
    pub fn is_image_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImagesErrorKind::ImageNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImagesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImagesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImagesErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImagesErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImagesErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DescribeImagesErrorKind::ServerException(_))
    }
}
impl std::error::Error for DescribeImagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeImagesErrorKind::ImageNotFoundException(_inner) => Some(_inner),
            DescribeImagesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeImagesErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            DescribeImagesErrorKind::ServerException(_inner) => Some(_inner),
            DescribeImagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeImageTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeImageTagsError {
    /// Kind of error that occurred.
    pub kind: DescribeImageTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeImageTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeImageTagsErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeImageTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeImageTagsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeImageTagsErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            DescribeImageTagsErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeImageTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeImageTagsError {
    fn code(&self) -> Option<&str> {
        DescribeImageTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeImageTagsError {
    /// Creates a new `DescribeImageTagsError`.
    pub fn new(kind: DescribeImageTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeImageTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeImageTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeImageTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeImageTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeImageTagsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImageTagsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImageTagsErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImageTagsErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImageTagsErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DescribeImageTagsErrorKind::ServerException(_))
    }
}
impl std::error::Error for DescribeImageTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeImageTagsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeImageTagsErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            DescribeImageTagsErrorKind::ServerException(_inner) => Some(_inner),
            DescribeImageTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRegistries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRegistriesError {
    /// Kind of error that occurred.
    pub kind: DescribeRegistriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRegistries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRegistriesErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The action is not supported in this Region.</p>
    UnsupportedCommandException(crate::error::UnsupportedCommandException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRegistriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRegistriesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeRegistriesErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeRegistriesErrorKind::UnsupportedCommandException(_inner) => _inner.fmt(f),
            DescribeRegistriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRegistriesError {
    fn code(&self) -> Option<&str> {
        DescribeRegistriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRegistriesError {
    /// Creates a new `DescribeRegistriesError`.
    pub fn new(kind: DescribeRegistriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRegistriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRegistriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRegistriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRegistriesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRegistriesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRegistriesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRegistriesErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DescribeRegistriesErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `DescribeRegistriesErrorKind::UnsupportedCommandException`.
    pub fn is_unsupported_command_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRegistriesErrorKind::UnsupportedCommandException(_)
        )
    }
}
impl std::error::Error for DescribeRegistriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRegistriesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeRegistriesErrorKind::ServerException(_inner) => Some(_inner),
            DescribeRegistriesErrorKind::UnsupportedCommandException(_inner) => Some(_inner),
            DescribeRegistriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRepositories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRepositoriesError {
    /// Kind of error that occurred.
    pub kind: DescribeRepositoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRepositories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRepositoriesErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRepositoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRepositoriesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeRepositoriesErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            DescribeRepositoriesErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeRepositoriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRepositoriesError {
    fn code(&self) -> Option<&str> {
        DescribeRepositoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRepositoriesError {
    /// Creates a new `DescribeRepositoriesError`.
    pub fn new(kind: DescribeRepositoriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRepositoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRepositoriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRepositoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRepositoriesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRepositoriesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRepositoriesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRepositoriesErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRepositoriesErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRepositoriesErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRepositoriesErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DescribeRepositoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRepositoriesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeRepositoriesErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            DescribeRepositoriesErrorKind::ServerException(_inner) => Some(_inner),
            DescribeRepositoriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAuthorizationToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAuthorizationTokenError {
    /// Kind of error that occurred.
    pub kind: GetAuthorizationTokenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAuthorizationToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAuthorizationTokenErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAuthorizationTokenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAuthorizationTokenErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetAuthorizationTokenErrorKind::ServerException(_inner) => _inner.fmt(f),
            GetAuthorizationTokenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAuthorizationTokenError {
    fn code(&self) -> Option<&str> {
        GetAuthorizationTokenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAuthorizationTokenError {
    /// Creates a new `GetAuthorizationTokenError`.
    pub fn new(kind: GetAuthorizationTokenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAuthorizationTokenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAuthorizationTokenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAuthorizationTokenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAuthorizationTokenErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAuthorizationTokenErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAuthorizationTokenErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAuthorizationTokenErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAuthorizationTokenErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for GetAuthorizationTokenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAuthorizationTokenErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetAuthorizationTokenErrorKind::ServerException(_inner) => Some(_inner),
            GetAuthorizationTokenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRegistryCatalogData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRegistryCatalogDataError {
    /// Kind of error that occurred.
    pub kind: GetRegistryCatalogDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRegistryCatalogData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRegistryCatalogDataErrorKind {
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The action is not supported in this Region.</p>
    UnsupportedCommandException(crate::error::UnsupportedCommandException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRegistryCatalogDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRegistryCatalogDataErrorKind::ServerException(_inner) => _inner.fmt(f),
            GetRegistryCatalogDataErrorKind::UnsupportedCommandException(_inner) => _inner.fmt(f),
            GetRegistryCatalogDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRegistryCatalogDataError {
    fn code(&self) -> Option<&str> {
        GetRegistryCatalogDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRegistryCatalogDataError {
    /// Creates a new `GetRegistryCatalogDataError`.
    pub fn new(kind: GetRegistryCatalogDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRegistryCatalogDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRegistryCatalogDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRegistryCatalogDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRegistryCatalogDataErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRegistryCatalogDataErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegistryCatalogDataErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegistryCatalogDataErrorKind::UnsupportedCommandException`.
    pub fn is_unsupported_command_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegistryCatalogDataErrorKind::UnsupportedCommandException(_)
        )
    }
}
impl std::error::Error for GetRegistryCatalogDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRegistryCatalogDataErrorKind::ServerException(_inner) => Some(_inner),
            GetRegistryCatalogDataErrorKind::UnsupportedCommandException(_inner) => Some(_inner),
            GetRegistryCatalogDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRepositoryCatalogData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRepositoryCatalogDataError {
    /// Kind of error that occurred.
    pub kind: GetRepositoryCatalogDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRepositoryCatalogData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRepositoryCatalogDataErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRepositoryCatalogDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRepositoryCatalogDataErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetRepositoryCatalogDataErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            GetRepositoryCatalogDataErrorKind::ServerException(_inner) => _inner.fmt(f),
            GetRepositoryCatalogDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRepositoryCatalogDataError {
    fn code(&self) -> Option<&str> {
        GetRepositoryCatalogDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRepositoryCatalogDataError {
    /// Creates a new `GetRepositoryCatalogDataError`.
    pub fn new(kind: GetRepositoryCatalogDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRepositoryCatalogDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRepositoryCatalogDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRepositoryCatalogDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRepositoryCatalogDataErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRepositoryCatalogDataErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryCatalogDataErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryCatalogDataErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryCatalogDataErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryCatalogDataErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryCatalogDataErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for GetRepositoryCatalogDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRepositoryCatalogDataErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetRepositoryCatalogDataErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            GetRepositoryCatalogDataErrorKind::ServerException(_inner) => Some(_inner),
            GetRepositoryCatalogDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRepositoryPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRepositoryPolicyError {
    /// Kind of error that occurred.
    pub kind: GetRepositoryPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRepositoryPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRepositoryPolicyErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>The specified repository and registry combination does not have an associated repository policy.</p>
    RepositoryPolicyNotFoundException(crate::error::RepositoryPolicyNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRepositoryPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRepositoryPolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetRepositoryPolicyErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            GetRepositoryPolicyErrorKind::RepositoryPolicyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetRepositoryPolicyErrorKind::ServerException(_inner) => _inner.fmt(f),
            GetRepositoryPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRepositoryPolicyError {
    fn code(&self) -> Option<&str> {
        GetRepositoryPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRepositoryPolicyError {
    /// Creates a new `GetRepositoryPolicyError`.
    pub fn new(kind: GetRepositoryPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRepositoryPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRepositoryPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRepositoryPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRepositoryPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRepositoryPolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryPolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryPolicyErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryPolicyErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryPolicyErrorKind::RepositoryPolicyNotFoundException`.
    pub fn is_repository_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryPolicyErrorKind::RepositoryPolicyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryPolicyErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, GetRepositoryPolicyErrorKind::ServerException(_))
    }
}
impl std::error::Error for GetRepositoryPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRepositoryPolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetRepositoryPolicyErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            GetRepositoryPolicyErrorKind::RepositoryPolicyNotFoundException(_inner) => Some(_inner),
            GetRepositoryPolicyErrorKind::ServerException(_inner) => Some(_inner),
            GetRepositoryPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `InitiateLayerUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct InitiateLayerUploadError {
    /// Kind of error that occurred.
    pub kind: InitiateLayerUploadErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `InitiateLayerUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum InitiateLayerUploadErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The registry does not exist.</p>
    RegistryNotFoundException(crate::error::RegistryNotFoundException),
    /// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The action is not supported in this Region.</p>
    UnsupportedCommandException(crate::error::UnsupportedCommandException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for InitiateLayerUploadError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            InitiateLayerUploadErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            InitiateLayerUploadErrorKind::RegistryNotFoundException(_inner) => _inner.fmt(f),
            InitiateLayerUploadErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            InitiateLayerUploadErrorKind::ServerException(_inner) => _inner.fmt(f),
            InitiateLayerUploadErrorKind::UnsupportedCommandException(_inner) => _inner.fmt(f),
            InitiateLayerUploadErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for InitiateLayerUploadError {
    fn code(&self) -> Option<&str> {
        InitiateLayerUploadError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl InitiateLayerUploadError {
    /// Creates a new `InitiateLayerUploadError`.
    pub fn new(kind: InitiateLayerUploadErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `InitiateLayerUploadError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: InitiateLayerUploadErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `InitiateLayerUploadError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: InitiateLayerUploadErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `InitiateLayerUploadErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateLayerUploadErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateLayerUploadErrorKind::RegistryNotFoundException`.
    pub fn is_registry_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateLayerUploadErrorKind::RegistryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateLayerUploadErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateLayerUploadErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateLayerUploadErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, InitiateLayerUploadErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `InitiateLayerUploadErrorKind::UnsupportedCommandException`.
    pub fn is_unsupported_command_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateLayerUploadErrorKind::UnsupportedCommandException(_)
        )
    }
}
impl std::error::Error for InitiateLayerUploadError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            InitiateLayerUploadErrorKind::InvalidParameterException(_inner) => Some(_inner),
            InitiateLayerUploadErrorKind::RegistryNotFoundException(_inner) => Some(_inner),
            InitiateLayerUploadErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            InitiateLayerUploadErrorKind::ServerException(_inner) => Some(_inner),
            InitiateLayerUploadErrorKind::UnsupportedCommandException(_inner) => Some(_inner),
            InitiateLayerUploadErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, ListTagsForResourceErrorKind::ServerException(_))
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutImageError {
    /// Kind of error that occurred.
    pub kind: PutImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutImageErrorKind {
    /// <p>The specified image has already been pushed, and there were no changes to the manifest or image tag after the last push.</p>
    ImageAlreadyExistsException(crate::error::ImageAlreadyExistsException),
    /// <p>The specified image digest does not match the digest that Amazon ECR calculated for the image.</p>
    ImageDigestDoesNotMatchException(crate::error::ImageDigestDoesNotMatchException),
    /// <p>The specified image is tagged with a tag that already exists. The repository is configured for tag immutability.</p>
    ImageTagAlreadyExistsException(crate::error::ImageTagAlreadyExistsException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified layers could not be found, or the specified layer is not valid for this repository.</p>
    LayersNotFoundException(crate::error::LayersNotFoundException),
    /// <p>The operation did not succeed because it would have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR Service Quotas</a> in the Amazon Elastic Container Registry User Guide.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The manifest list is referencing an image that does not exist.</p>
    ReferencedImagesNotFoundException(crate::error::ReferencedImagesNotFoundException),
    /// <p>The registry does not exist.</p>
    RegistryNotFoundException(crate::error::RegistryNotFoundException),
    /// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The action is not supported in this Region.</p>
    UnsupportedCommandException(crate::error::UnsupportedCommandException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutImageErrorKind::ImageAlreadyExistsException(_inner) => _inner.fmt(f),
            PutImageErrorKind::ImageDigestDoesNotMatchException(_inner) => _inner.fmt(f),
            PutImageErrorKind::ImageTagAlreadyExistsException(_inner) => _inner.fmt(f),
            PutImageErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutImageErrorKind::LayersNotFoundException(_inner) => _inner.fmt(f),
            PutImageErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutImageErrorKind::ReferencedImagesNotFoundException(_inner) => _inner.fmt(f),
            PutImageErrorKind::RegistryNotFoundException(_inner) => _inner.fmt(f),
            PutImageErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            PutImageErrorKind::ServerException(_inner) => _inner.fmt(f),
            PutImageErrorKind::UnsupportedCommandException(_inner) => _inner.fmt(f),
            PutImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutImageError {
    fn code(&self) -> Option<&str> {
        PutImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutImageError {
    /// Creates a new `PutImageError`.
    pub fn new(kind: PutImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutImageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::ImageAlreadyExistsException`.
    pub fn is_image_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutImageErrorKind::ImageAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::ImageDigestDoesNotMatchException`.
    pub fn is_image_digest_does_not_match_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutImageErrorKind::ImageDigestDoesNotMatchException(_)
        )
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::ImageTagAlreadyExistsException`.
    pub fn is_image_tag_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutImageErrorKind::ImageTagAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, PutImageErrorKind::InvalidParameterException(_))
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::LayersNotFoundException`.
    pub fn is_layers_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutImageErrorKind::LayersNotFoundException(_))
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PutImageErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::ReferencedImagesNotFoundException`.
    pub fn is_referenced_images_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutImageErrorKind::ReferencedImagesNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::RegistryNotFoundException`.
    pub fn is_registry_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutImageErrorKind::RegistryNotFoundException(_))
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutImageErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, PutImageErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::UnsupportedCommandException`.
    pub fn is_unsupported_command_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutImageErrorKind::UnsupportedCommandException(_)
        )
    }
}
impl std::error::Error for PutImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutImageErrorKind::ImageAlreadyExistsException(_inner) => Some(_inner),
            PutImageErrorKind::ImageDigestDoesNotMatchException(_inner) => Some(_inner),
            PutImageErrorKind::ImageTagAlreadyExistsException(_inner) => Some(_inner),
            PutImageErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutImageErrorKind::LayersNotFoundException(_inner) => Some(_inner),
            PutImageErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutImageErrorKind::ReferencedImagesNotFoundException(_inner) => Some(_inner),
            PutImageErrorKind::RegistryNotFoundException(_inner) => Some(_inner),
            PutImageErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            PutImageErrorKind::ServerException(_inner) => Some(_inner),
            PutImageErrorKind::UnsupportedCommandException(_inner) => Some(_inner),
            PutImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRegistryCatalogData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRegistryCatalogDataError {
    /// Kind of error that occurred.
    pub kind: PutRegistryCatalogDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRegistryCatalogData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRegistryCatalogDataErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The action is not supported in this Region.</p>
    UnsupportedCommandException(crate::error::UnsupportedCommandException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRegistryCatalogDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRegistryCatalogDataErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutRegistryCatalogDataErrorKind::ServerException(_inner) => _inner.fmt(f),
            PutRegistryCatalogDataErrorKind::UnsupportedCommandException(_inner) => _inner.fmt(f),
            PutRegistryCatalogDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRegistryCatalogDataError {
    fn code(&self) -> Option<&str> {
        PutRegistryCatalogDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRegistryCatalogDataError {
    /// Creates a new `PutRegistryCatalogDataError`.
    pub fn new(kind: PutRegistryCatalogDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRegistryCatalogDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRegistryCatalogDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRegistryCatalogDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRegistryCatalogDataErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutRegistryCatalogDataErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRegistryCatalogDataErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRegistryCatalogDataErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRegistryCatalogDataErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRegistryCatalogDataErrorKind::UnsupportedCommandException`.
    pub fn is_unsupported_command_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRegistryCatalogDataErrorKind::UnsupportedCommandException(_)
        )
    }
}
impl std::error::Error for PutRegistryCatalogDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRegistryCatalogDataErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutRegistryCatalogDataErrorKind::ServerException(_inner) => Some(_inner),
            PutRegistryCatalogDataErrorKind::UnsupportedCommandException(_inner) => Some(_inner),
            PutRegistryCatalogDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRepositoryCatalogData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRepositoryCatalogDataError {
    /// Kind of error that occurred.
    pub kind: PutRepositoryCatalogDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRepositoryCatalogData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRepositoryCatalogDataErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRepositoryCatalogDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRepositoryCatalogDataErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutRepositoryCatalogDataErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            PutRepositoryCatalogDataErrorKind::ServerException(_inner) => _inner.fmt(f),
            PutRepositoryCatalogDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRepositoryCatalogDataError {
    fn code(&self) -> Option<&str> {
        PutRepositoryCatalogDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRepositoryCatalogDataError {
    /// Creates a new `PutRepositoryCatalogDataError`.
    pub fn new(kind: PutRepositoryCatalogDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRepositoryCatalogDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRepositoryCatalogDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRepositoryCatalogDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRepositoryCatalogDataErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutRepositoryCatalogDataErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryCatalogDataErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryCatalogDataErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryCatalogDataErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryCatalogDataErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryCatalogDataErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for PutRepositoryCatalogDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRepositoryCatalogDataErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutRepositoryCatalogDataErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            PutRepositoryCatalogDataErrorKind::ServerException(_inner) => Some(_inner),
            PutRepositoryCatalogDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetRepositoryPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetRepositoryPolicyError {
    /// Kind of error that occurred.
    pub kind: SetRepositoryPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetRepositoryPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetRepositoryPolicyErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetRepositoryPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetRepositoryPolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            SetRepositoryPolicyErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            SetRepositoryPolicyErrorKind::ServerException(_inner) => _inner.fmt(f),
            SetRepositoryPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetRepositoryPolicyError {
    fn code(&self) -> Option<&str> {
        SetRepositoryPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetRepositoryPolicyError {
    /// Creates a new `SetRepositoryPolicyError`.
    pub fn new(kind: SetRepositoryPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetRepositoryPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetRepositoryPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetRepositoryPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetRepositoryPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetRepositoryPolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetRepositoryPolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `SetRepositoryPolicyErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetRepositoryPolicyErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetRepositoryPolicyErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, SetRepositoryPolicyErrorKind::ServerException(_))
    }
}
impl std::error::Error for SetRepositoryPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetRepositoryPolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            SetRepositoryPolicyErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            SetRepositoryPolicyErrorKind::ServerException(_inner) => Some(_inner),
            SetRepositoryPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    InvalidTagParameterException(crate::error::InvalidTagParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a repository is 50.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidTagParameterException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidTagParameterException`.
    pub fn is_invalid_tag_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidTagParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidTagParameterException(_inner) => Some(_inner),
            TagResourceErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ServerException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    InvalidTagParameterException(crate::error::InvalidTagParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a repository is 50.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidTagParameterException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidTagParameterException`.
    pub fn is_invalid_tag_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidTagParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidTagParameterException(_inner) => Some(_inner),
            UntagResourceErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UploadLayerPart` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UploadLayerPartError {
    /// Kind of error that occurred.
    pub kind: UploadLayerPartErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UploadLayerPart` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UploadLayerPartErrorKind {
    /// <p>The layer part size is not valid, or the first byte specified is not consecutive to the last byte of a previous layer part upload.</p>
    InvalidLayerPartException(crate::error::InvalidLayerPartException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The operation did not succeed because it would have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR Service Quotas</a> in the Amazon Elastic Container Registry User Guide.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The registry does not exist.</p>
    RegistryNotFoundException(crate::error::RegistryNotFoundException),
    /// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The action is not supported in this Region.</p>
    UnsupportedCommandException(crate::error::UnsupportedCommandException),
    /// <p>The upload could not be found, or the specified upload ID is not valid for this repository.</p>
    UploadNotFoundException(crate::error::UploadNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UploadLayerPartError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UploadLayerPartErrorKind::InvalidLayerPartException(_inner) => _inner.fmt(f),
            UploadLayerPartErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UploadLayerPartErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UploadLayerPartErrorKind::RegistryNotFoundException(_inner) => _inner.fmt(f),
            UploadLayerPartErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            UploadLayerPartErrorKind::ServerException(_inner) => _inner.fmt(f),
            UploadLayerPartErrorKind::UnsupportedCommandException(_inner) => _inner.fmt(f),
            UploadLayerPartErrorKind::UploadNotFoundException(_inner) => _inner.fmt(f),
            UploadLayerPartErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UploadLayerPartError {
    fn code(&self) -> Option<&str> {
        UploadLayerPartError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UploadLayerPartError {
    /// Creates a new `UploadLayerPartError`.
    pub fn new(kind: UploadLayerPartErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UploadLayerPartError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UploadLayerPartErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UploadLayerPartError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UploadLayerPartErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UploadLayerPartErrorKind::InvalidLayerPartException`.
    pub fn is_invalid_layer_part_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadLayerPartErrorKind::InvalidLayerPartException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadLayerPartErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadLayerPartErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadLayerPartErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadLayerPartErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadLayerPartErrorKind::RegistryNotFoundException`.
    pub fn is_registry_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadLayerPartErrorKind::RegistryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadLayerPartErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadLayerPartErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadLayerPartErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, UploadLayerPartErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `UploadLayerPartErrorKind::UnsupportedCommandException`.
    pub fn is_unsupported_command_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadLayerPartErrorKind::UnsupportedCommandException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadLayerPartErrorKind::UploadNotFoundException`.
    pub fn is_upload_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadLayerPartErrorKind::UploadNotFoundException(_)
        )
    }
}
impl std::error::Error for UploadLayerPartError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UploadLayerPartErrorKind::InvalidLayerPartException(_inner) => Some(_inner),
            UploadLayerPartErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UploadLayerPartErrorKind::LimitExceededException(_inner) => Some(_inner),
            UploadLayerPartErrorKind::RegistryNotFoundException(_inner) => Some(_inner),
            UploadLayerPartErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            UploadLayerPartErrorKind::ServerException(_inner) => Some(_inner),
            UploadLayerPartErrorKind::UnsupportedCommandException(_inner) => Some(_inner),
            UploadLayerPartErrorKind::UploadNotFoundException(_inner) => Some(_inner),
            UploadLayerPartErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The upload could not be found, or the specified upload ID is not valid for this repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UploadNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UploadNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UploadNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UploadNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UploadNotFoundException {}
/// See [`UploadNotFoundException`](crate::error::UploadNotFoundException)
pub mod upload_not_found_exception {
    /// A builder for [`UploadNotFoundException`](crate::error::UploadNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadNotFoundException`](crate::error::UploadNotFoundException)
        pub fn build(self) -> crate::error::UploadNotFoundException {
            crate::error::UploadNotFoundException {
                message: self.message,
            }
        }
    }
}
impl UploadNotFoundException {
    /// Creates a new builder-style object to manufacture [`UploadNotFoundException`](crate::error::UploadNotFoundException)
    pub fn builder() -> crate::error::upload_not_found_exception::Builder {
        crate::error::upload_not_found_exception::Builder::default()
    }
}

/// <p>The action is not supported in this Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedCommandException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedCommandException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedCommandException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedCommandException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedCommandException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedCommandException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedCommandException {}
/// See [`UnsupportedCommandException`](crate::error::UnsupportedCommandException)
pub mod unsupported_command_exception {
    /// A builder for [`UnsupportedCommandException`](crate::error::UnsupportedCommandException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedCommandException`](crate::error::UnsupportedCommandException)
        pub fn build(self) -> crate::error::UnsupportedCommandException {
            crate::error::UnsupportedCommandException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedCommandException {
    /// Creates a new builder-style object to manufacture [`UnsupportedCommandException`](crate::error::UnsupportedCommandException)
    pub fn builder() -> crate::error::unsupported_command_exception::Builder {
        crate::error::unsupported_command_exception::Builder::default()
    }
}

/// <p>These errors are usually caused by a server-side issue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServerException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServerException {}
/// See [`ServerException`](crate::error::ServerException)
pub mod server_exception {
    /// A builder for [`ServerException`](crate::error::ServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerException`](crate::error::ServerException)
        pub fn build(self) -> crate::error::ServerException {
            crate::error::ServerException {
                message: self.message,
            }
        }
    }
}
impl ServerException {
    /// Creates a new builder-style object to manufacture [`ServerException`](crate::error::ServerException)
    pub fn builder() -> crate::error::server_exception::Builder {
        crate::error::server_exception::Builder::default()
    }
}

/// <p>The specified repository could not be found. Check the spelling of the specified repository and ensure that you are performing operations on the correct registry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RepositoryNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RepositoryNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RepositoryNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RepositoryNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for RepositoryNotFoundException {}
/// See [`RepositoryNotFoundException`](crate::error::RepositoryNotFoundException)
pub mod repository_not_found_exception {
    /// A builder for [`RepositoryNotFoundException`](crate::error::RepositoryNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryNotFoundException`](crate::error::RepositoryNotFoundException)
        pub fn build(self) -> crate::error::RepositoryNotFoundException {
            crate::error::RepositoryNotFoundException {
                message: self.message,
            }
        }
    }
}
impl RepositoryNotFoundException {
    /// Creates a new builder-style object to manufacture [`RepositoryNotFoundException`](crate::error::RepositoryNotFoundException)
    pub fn builder() -> crate::error::repository_not_found_exception::Builder {
        crate::error::repository_not_found_exception::Builder::default()
    }
}

/// <p>The registry does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegistryNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RegistryNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegistryNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RegistryNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RegistryNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RegistryNotFoundException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for RegistryNotFoundException {}
/// See [`RegistryNotFoundException`](crate::error::RegistryNotFoundException)
pub mod registry_not_found_exception {
    /// A builder for [`RegistryNotFoundException`](crate::error::RegistryNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RegistryNotFoundException`](crate::error::RegistryNotFoundException)
        pub fn build(self) -> crate::error::RegistryNotFoundException {
            crate::error::RegistryNotFoundException {
                message: self.message,
            }
        }
    }
}
impl RegistryNotFoundException {
    /// Creates a new builder-style object to manufacture [`RegistryNotFoundException`](crate::error::RegistryNotFoundException)
    pub fn builder() -> crate::error::registry_not_found_exception::Builder {
        crate::error::registry_not_found_exception::Builder::default()
    }
}

/// <p>The operation did not succeed because it would have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR Service Quotas</a> in the Amazon Elastic Container Registry User Guide.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The specified parameter is invalid. Review the available parameters for the API request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterException {}
/// See [`InvalidParameterException`](crate::error::InvalidParameterException)
pub mod invalid_parameter_exception {
    /// A builder for [`InvalidParameterException`](crate::error::InvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterException`](crate::error::InvalidParameterException)
        pub fn build(self) -> crate::error::InvalidParameterException {
            crate::error::InvalidParameterException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterException`](crate::error::InvalidParameterException)
    pub fn builder() -> crate::error::invalid_parameter_exception::Builder {
        crate::error::invalid_parameter_exception::Builder::default()
    }
}

/// <p>The layer part size is not valid, or the first byte specified is not consecutive to the last byte of a previous layer part upload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidLayerPartException {
    /// <p>The AWS account ID associated with the layer part.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The upload ID associated with the layer part.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>The position of the last byte of the layer part.</p>
    pub last_valid_byte_received: std::option::Option<i64>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl InvalidLayerPartException {
    /// <p>The AWS account ID associated with the layer part.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The upload ID associated with the layer part.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>The position of the last byte of the layer part.</p>
    pub fn last_valid_byte_received(&self) -> std::option::Option<i64> {
        self.last_valid_byte_received
    }
}
impl std::fmt::Debug for InvalidLayerPartException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidLayerPartException");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("upload_id", &self.upload_id);
        formatter.field("last_valid_byte_received", &self.last_valid_byte_received);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidLayerPartException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidLayerPartException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidLayerPartException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidLayerPartException {}
/// See [`InvalidLayerPartException`](crate::error::InvalidLayerPartException)
pub mod invalid_layer_part_exception {
    /// A builder for [`InvalidLayerPartException`](crate::error::InvalidLayerPartException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) last_valid_byte_received: std::option::Option<i64>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the layer part.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the layer part.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The upload ID associated with the layer part.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The upload ID associated with the layer part.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>The position of the last byte of the layer part.</p>
        pub fn last_valid_byte_received(mut self, input: i64) -> Self {
            self.last_valid_byte_received = Some(input);
            self
        }
        /// <p>The position of the last byte of the layer part.</p>
        pub fn set_last_valid_byte_received(mut self, input: std::option::Option<i64>) -> Self {
            self.last_valid_byte_received = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidLayerPartException`](crate::error::InvalidLayerPartException)
        pub fn build(self) -> crate::error::InvalidLayerPartException {
            crate::error::InvalidLayerPartException {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                upload_id: self.upload_id,
                last_valid_byte_received: self.last_valid_byte_received,
                message: self.message,
            }
        }
    }
}
impl InvalidLayerPartException {
    /// Creates a new builder-style object to manufacture [`InvalidLayerPartException`](crate::error::InvalidLayerPartException)
    pub fn builder() -> crate::error::invalid_layer_part_exception::Builder {
        crate::error::invalid_layer_part_exception::Builder::default()
    }
}

/// <p>The list of tags on the repository is over the limit. The maximum number of tags that can be applied to a repository is 50.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTagParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTagParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTagParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTagParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTagParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTagParameterException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTagParameterException {}
/// See [`InvalidTagParameterException`](crate::error::InvalidTagParameterException)
pub mod invalid_tag_parameter_exception {
    /// A builder for [`InvalidTagParameterException`](crate::error::InvalidTagParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTagParameterException`](crate::error::InvalidTagParameterException)
        pub fn build(self) -> crate::error::InvalidTagParameterException {
            crate::error::InvalidTagParameterException {
                message: self.message,
            }
        }
    }
}
impl InvalidTagParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidTagParameterException`](crate::error::InvalidTagParameterException)
    pub fn builder() -> crate::error::invalid_tag_parameter_exception::Builder {
        crate::error::invalid_tag_parameter_exception::Builder::default()
    }
}

/// <p>The manifest list is referencing an image that does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReferencedImagesNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReferencedImagesNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReferencedImagesNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReferencedImagesNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReferencedImagesNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ReferencedImagesNotFoundException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReferencedImagesNotFoundException {}
/// See [`ReferencedImagesNotFoundException`](crate::error::ReferencedImagesNotFoundException)
pub mod referenced_images_not_found_exception {
    /// A builder for [`ReferencedImagesNotFoundException`](crate::error::ReferencedImagesNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReferencedImagesNotFoundException`](crate::error::ReferencedImagesNotFoundException)
        pub fn build(self) -> crate::error::ReferencedImagesNotFoundException {
            crate::error::ReferencedImagesNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ReferencedImagesNotFoundException {
    /// Creates a new builder-style object to manufacture [`ReferencedImagesNotFoundException`](crate::error::ReferencedImagesNotFoundException)
    pub fn builder() -> crate::error::referenced_images_not_found_exception::Builder {
        crate::error::referenced_images_not_found_exception::Builder::default()
    }
}

/// <p>The specified layers could not be found, or the specified layer is not valid for this repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LayersNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LayersNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LayersNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LayersNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LayersNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LayersNotFoundException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for LayersNotFoundException {}
/// See [`LayersNotFoundException`](crate::error::LayersNotFoundException)
pub mod layers_not_found_exception {
    /// A builder for [`LayersNotFoundException`](crate::error::LayersNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LayersNotFoundException`](crate::error::LayersNotFoundException)
        pub fn build(self) -> crate::error::LayersNotFoundException {
            crate::error::LayersNotFoundException {
                message: self.message,
            }
        }
    }
}
impl LayersNotFoundException {
    /// Creates a new builder-style object to manufacture [`LayersNotFoundException`](crate::error::LayersNotFoundException)
    pub fn builder() -> crate::error::layers_not_found_exception::Builder {
        crate::error::layers_not_found_exception::Builder::default()
    }
}

/// <p>The specified image is tagged with a tag that already exists. The repository is configured for tag immutability.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageTagAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ImageTagAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageTagAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ImageTagAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ImageTagAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ImageTagAlreadyExistsException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for ImageTagAlreadyExistsException {}
/// See [`ImageTagAlreadyExistsException`](crate::error::ImageTagAlreadyExistsException)
pub mod image_tag_already_exists_exception {
    /// A builder for [`ImageTagAlreadyExistsException`](crate::error::ImageTagAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageTagAlreadyExistsException`](crate::error::ImageTagAlreadyExistsException)
        pub fn build(self) -> crate::error::ImageTagAlreadyExistsException {
            crate::error::ImageTagAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ImageTagAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ImageTagAlreadyExistsException`](crate::error::ImageTagAlreadyExistsException)
    pub fn builder() -> crate::error::image_tag_already_exists_exception::Builder {
        crate::error::image_tag_already_exists_exception::Builder::default()
    }
}

/// <p>The specified image digest does not match the digest that Amazon ECR calculated for the image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageDigestDoesNotMatchException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ImageDigestDoesNotMatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageDigestDoesNotMatchException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ImageDigestDoesNotMatchException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ImageDigestDoesNotMatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ImageDigestDoesNotMatchException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for ImageDigestDoesNotMatchException {}
/// See [`ImageDigestDoesNotMatchException`](crate::error::ImageDigestDoesNotMatchException)
pub mod image_digest_does_not_match_exception {
    /// A builder for [`ImageDigestDoesNotMatchException`](crate::error::ImageDigestDoesNotMatchException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageDigestDoesNotMatchException`](crate::error::ImageDigestDoesNotMatchException)
        pub fn build(self) -> crate::error::ImageDigestDoesNotMatchException {
            crate::error::ImageDigestDoesNotMatchException {
                message: self.message,
            }
        }
    }
}
impl ImageDigestDoesNotMatchException {
    /// Creates a new builder-style object to manufacture [`ImageDigestDoesNotMatchException`](crate::error::ImageDigestDoesNotMatchException)
    pub fn builder() -> crate::error::image_digest_does_not_match_exception::Builder {
        crate::error::image_digest_does_not_match_exception::Builder::default()
    }
}

/// <p>The specified image has already been pushed, and there were no changes to the manifest or image tag after the last push.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ImageAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ImageAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ImageAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ImageAlreadyExistsException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for ImageAlreadyExistsException {}
/// See [`ImageAlreadyExistsException`](crate::error::ImageAlreadyExistsException)
pub mod image_already_exists_exception {
    /// A builder for [`ImageAlreadyExistsException`](crate::error::ImageAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageAlreadyExistsException`](crate::error::ImageAlreadyExistsException)
        pub fn build(self) -> crate::error::ImageAlreadyExistsException {
            crate::error::ImageAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ImageAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ImageAlreadyExistsException`](crate::error::ImageAlreadyExistsException)
    pub fn builder() -> crate::error::image_already_exists_exception::Builder {
        crate::error::image_already_exists_exception::Builder::default()
    }
}

/// <p>The specified repository and registry combination does not have an associated repository policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryPolicyNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RepositoryPolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryPolicyNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RepositoryPolicyNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RepositoryPolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RepositoryPolicyNotFoundException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for RepositoryPolicyNotFoundException {}
/// See [`RepositoryPolicyNotFoundException`](crate::error::RepositoryPolicyNotFoundException)
pub mod repository_policy_not_found_exception {
    /// A builder for [`RepositoryPolicyNotFoundException`](crate::error::RepositoryPolicyNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryPolicyNotFoundException`](crate::error::RepositoryPolicyNotFoundException)
        pub fn build(self) -> crate::error::RepositoryPolicyNotFoundException {
            crate::error::RepositoryPolicyNotFoundException {
                message: self.message,
            }
        }
    }
}
impl RepositoryPolicyNotFoundException {
    /// Creates a new builder-style object to manufacture [`RepositoryPolicyNotFoundException`](crate::error::RepositoryPolicyNotFoundException)
    pub fn builder() -> crate::error::repository_policy_not_found_exception::Builder {
        crate::error::repository_policy_not_found_exception::Builder::default()
    }
}

/// <p>The image requested does not exist in the specified repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ImageNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ImageNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ImageNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ImageNotFoundException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for ImageNotFoundException {}
/// See [`ImageNotFoundException`](crate::error::ImageNotFoundException)
pub mod image_not_found_exception {
    /// A builder for [`ImageNotFoundException`](crate::error::ImageNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageNotFoundException`](crate::error::ImageNotFoundException)
        pub fn build(self) -> crate::error::ImageNotFoundException {
            crate::error::ImageNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ImageNotFoundException {
    /// Creates a new builder-style object to manufacture [`ImageNotFoundException`](crate::error::ImageNotFoundException)
    pub fn builder() -> crate::error::image_not_found_exception::Builder {
        crate::error::image_not_found_exception::Builder::default()
    }
}

/// <p>The specified repository contains images. To delete a repository that contains images, you must force the deletion with the <code>force</code> parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryNotEmptyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RepositoryNotEmptyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryNotEmptyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RepositoryNotEmptyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RepositoryNotEmptyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RepositoryNotEmptyException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for RepositoryNotEmptyException {}
/// See [`RepositoryNotEmptyException`](crate::error::RepositoryNotEmptyException)
pub mod repository_not_empty_exception {
    /// A builder for [`RepositoryNotEmptyException`](crate::error::RepositoryNotEmptyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryNotEmptyException`](crate::error::RepositoryNotEmptyException)
        pub fn build(self) -> crate::error::RepositoryNotEmptyException {
            crate::error::RepositoryNotEmptyException {
                message: self.message,
            }
        }
    }
}
impl RepositoryNotEmptyException {
    /// Creates a new builder-style object to manufacture [`RepositoryNotEmptyException`](crate::error::RepositoryNotEmptyException)
    pub fn builder() -> crate::error::repository_not_empty_exception::Builder {
        crate::error::repository_not_empty_exception::Builder::default()
    }
}

/// <p>The specified repository already exists in the specified registry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RepositoryAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RepositoryAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RepositoryAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RepositoryAlreadyExistsException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for RepositoryAlreadyExistsException {}
/// See [`RepositoryAlreadyExistsException`](crate::error::RepositoryAlreadyExistsException)
pub mod repository_already_exists_exception {
    /// A builder for [`RepositoryAlreadyExistsException`](crate::error::RepositoryAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryAlreadyExistsException`](crate::error::RepositoryAlreadyExistsException)
        pub fn build(self) -> crate::error::RepositoryAlreadyExistsException {
            crate::error::RepositoryAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl RepositoryAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`RepositoryAlreadyExistsException`](crate::error::RepositoryAlreadyExistsException)
    pub fn builder() -> crate::error::repository_already_exists_exception::Builder {
        crate::error::repository_already_exists_exception::Builder::default()
    }
}

/// <p>Layer parts must be at least 5 MiB in size.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LayerPartTooSmallException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LayerPartTooSmallException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LayerPartTooSmallException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LayerPartTooSmallException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LayerPartTooSmallException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LayerPartTooSmallException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for LayerPartTooSmallException {}
/// See [`LayerPartTooSmallException`](crate::error::LayerPartTooSmallException)
pub mod layer_part_too_small_exception {
    /// A builder for [`LayerPartTooSmallException`](crate::error::LayerPartTooSmallException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LayerPartTooSmallException`](crate::error::LayerPartTooSmallException)
        pub fn build(self) -> crate::error::LayerPartTooSmallException {
            crate::error::LayerPartTooSmallException {
                message: self.message,
            }
        }
    }
}
impl LayerPartTooSmallException {
    /// Creates a new builder-style object to manufacture [`LayerPartTooSmallException`](crate::error::LayerPartTooSmallException)
    pub fn builder() -> crate::error::layer_part_too_small_exception::Builder {
        crate::error::layer_part_too_small_exception::Builder::default()
    }
}

/// <p>The image layer already exists in the associated repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LayerAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LayerAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LayerAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LayerAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LayerAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LayerAlreadyExistsException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for LayerAlreadyExistsException {}
/// See [`LayerAlreadyExistsException`](crate::error::LayerAlreadyExistsException)
pub mod layer_already_exists_exception {
    /// A builder for [`LayerAlreadyExistsException`](crate::error::LayerAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LayerAlreadyExistsException`](crate::error::LayerAlreadyExistsException)
        pub fn build(self) -> crate::error::LayerAlreadyExistsException {
            crate::error::LayerAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl LayerAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`LayerAlreadyExistsException`](crate::error::LayerAlreadyExistsException)
    pub fn builder() -> crate::error::layer_already_exists_exception::Builder {
        crate::error::layer_already_exists_exception::Builder::default()
    }
}

/// <p>The layer digest calculation performed by Amazon ECR upon receipt of the image layer does not match the digest specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidLayerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidLayerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidLayerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidLayerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidLayerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidLayerException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidLayerException {}
/// See [`InvalidLayerException`](crate::error::InvalidLayerException)
pub mod invalid_layer_exception {
    /// A builder for [`InvalidLayerException`](crate::error::InvalidLayerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidLayerException`](crate::error::InvalidLayerException)
        pub fn build(self) -> crate::error::InvalidLayerException {
            crate::error::InvalidLayerException {
                message: self.message,
            }
        }
    }
}
impl InvalidLayerException {
    /// Creates a new builder-style object to manufacture [`InvalidLayerException`](crate::error::InvalidLayerException)
    pub fn builder() -> crate::error::invalid_layer_exception::Builder {
        crate::error::invalid_layer_exception::Builder::default()
    }
}

/// <p>The specified layer upload does not contain any layer parts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmptyUploadException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EmptyUploadException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmptyUploadException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EmptyUploadException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EmptyUploadException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EmptyUploadException")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for EmptyUploadException {}
/// See [`EmptyUploadException`](crate::error::EmptyUploadException)
pub mod empty_upload_exception {
    /// A builder for [`EmptyUploadException`](crate::error::EmptyUploadException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EmptyUploadException`](crate::error::EmptyUploadException)
        pub fn build(self) -> crate::error::EmptyUploadException {
            crate::error::EmptyUploadException {
                message: self.message,
            }
        }
    }
}
impl EmptyUploadException {
    /// Creates a new builder-style object to manufacture [`EmptyUploadException`](crate::error::EmptyUploadException)
    pub fn builder() -> crate::error::empty_upload_exception::Builder {
        crate::error::empty_upload_exception::Builder::default()
    }
}
