// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `BatchCheckLayerAvailability`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_check_layer_availability`](crate::client::Client::batch_check_layer_availability).
///
/// See [`crate::client::fluent_builders::BatchCheckLayerAvailability`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchCheckLayerAvailability {
    _private: (),
}
impl BatchCheckLayerAvailability {
    /// Creates a new builder-style object to manufacture [`BatchCheckLayerAvailabilityInput`](crate::input::BatchCheckLayerAvailabilityInput)
    pub fn builder() -> crate::input::batch_check_layer_availability_input::Builder {
        crate::input::batch_check_layer_availability_input::Builder::default()
    }
    /// Creates a new `BatchCheckLayerAvailability` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchCheckLayerAvailability {
    type Output = std::result::Result<
        crate::output::BatchCheckLayerAvailabilityOutput,
        crate::error::BatchCheckLayerAvailabilityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_check_layer_availability_error(response)
        } else {
            crate::operation_deser::parse_batch_check_layer_availability_response(response)
        }
    }
}

/// Operation shape for `BatchDeleteImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_delete_image`](crate::client::Client::batch_delete_image).
///
/// See [`crate::client::fluent_builders::BatchDeleteImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDeleteImage {
    _private: (),
}
impl BatchDeleteImage {
    /// Creates a new builder-style object to manufacture [`BatchDeleteImageInput`](crate::input::BatchDeleteImageInput)
    pub fn builder() -> crate::input::batch_delete_image_input::Builder {
        crate::input::batch_delete_image_input::Builder::default()
    }
    /// Creates a new `BatchDeleteImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDeleteImage {
    type Output = std::result::Result<
        crate::output::BatchDeleteImageOutput,
        crate::error::BatchDeleteImageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_delete_image_error(response)
        } else {
            crate::operation_deser::parse_batch_delete_image_response(response)
        }
    }
}

/// Operation shape for `CompleteLayerUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`complete_layer_upload`](crate::client::Client::complete_layer_upload).
///
/// See [`crate::client::fluent_builders::CompleteLayerUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CompleteLayerUpload {
    _private: (),
}
impl CompleteLayerUpload {
    /// Creates a new builder-style object to manufacture [`CompleteLayerUploadInput`](crate::input::CompleteLayerUploadInput)
    pub fn builder() -> crate::input::complete_layer_upload_input::Builder {
        crate::input::complete_layer_upload_input::Builder::default()
    }
    /// Creates a new `CompleteLayerUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CompleteLayerUpload {
    type Output = std::result::Result<
        crate::output::CompleteLayerUploadOutput,
        crate::error::CompleteLayerUploadError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_complete_layer_upload_error(response)
        } else {
            crate::operation_deser::parse_complete_layer_upload_response(response)
        }
    }
}

/// Operation shape for `CreateRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_repository`](crate::client::Client::create_repository).
///
/// See [`crate::client::fluent_builders::CreateRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRepository {
    _private: (),
}
impl CreateRepository {
    /// Creates a new builder-style object to manufacture [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
    pub fn builder() -> crate::input::create_repository_input::Builder {
        crate::input::create_repository_input::Builder::default()
    }
    /// Creates a new `CreateRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRepository {
    type Output = std::result::Result<
        crate::output::CreateRepositoryOutput,
        crate::error::CreateRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_repository_error(response)
        } else {
            crate::operation_deser::parse_create_repository_response(response)
        }
    }
}

/// Operation shape for `DeleteRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_repository`](crate::client::Client::delete_repository).
///
/// See [`crate::client::fluent_builders::DeleteRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRepository {
    _private: (),
}
impl DeleteRepository {
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
    pub fn builder() -> crate::input::delete_repository_input::Builder {
        crate::input::delete_repository_input::Builder::default()
    }
    /// Creates a new `DeleteRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRepository {
    type Output = std::result::Result<
        crate::output::DeleteRepositoryOutput,
        crate::error::DeleteRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_repository_error(response)
        } else {
            crate::operation_deser::parse_delete_repository_response(response)
        }
    }
}

/// Operation shape for `DeleteRepositoryPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_repository_policy`](crate::client::Client::delete_repository_policy).
///
/// See [`crate::client::fluent_builders::DeleteRepositoryPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRepositoryPolicy {
    _private: (),
}
impl DeleteRepositoryPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryPolicyInput`](crate::input::DeleteRepositoryPolicyInput)
    pub fn builder() -> crate::input::delete_repository_policy_input::Builder {
        crate::input::delete_repository_policy_input::Builder::default()
    }
    /// Creates a new `DeleteRepositoryPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRepositoryPolicy {
    type Output = std::result::Result<
        crate::output::DeleteRepositoryPolicyOutput,
        crate::error::DeleteRepositoryPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_repository_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_repository_policy_response(response)
        }
    }
}

/// Operation shape for `DescribeImages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_images`](crate::client::Client::describe_images).
///
/// See [`crate::client::fluent_builders::DescribeImages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeImages {
    _private: (),
}
impl DescribeImages {
    /// Creates a new builder-style object to manufacture [`DescribeImagesInput`](crate::input::DescribeImagesInput)
    pub fn builder() -> crate::input::describe_images_input::Builder {
        crate::input::describe_images_input::Builder::default()
    }
    /// Creates a new `DescribeImages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeImages {
    type Output =
        std::result::Result<crate::output::DescribeImagesOutput, crate::error::DescribeImagesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_images_error(response)
        } else {
            crate::operation_deser::parse_describe_images_response(response)
        }
    }
}

/// Operation shape for `DescribeImageTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_image_tags`](crate::client::Client::describe_image_tags).
///
/// See [`crate::client::fluent_builders::DescribeImageTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeImageTags {
    _private: (),
}
impl DescribeImageTags {
    /// Creates a new builder-style object to manufacture [`DescribeImageTagsInput`](crate::input::DescribeImageTagsInput)
    pub fn builder() -> crate::input::describe_image_tags_input::Builder {
        crate::input::describe_image_tags_input::Builder::default()
    }
    /// Creates a new `DescribeImageTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeImageTags {
    type Output = std::result::Result<
        crate::output::DescribeImageTagsOutput,
        crate::error::DescribeImageTagsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_image_tags_error(response)
        } else {
            crate::operation_deser::parse_describe_image_tags_response(response)
        }
    }
}

/// Operation shape for `DescribeRegistries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_registries`](crate::client::Client::describe_registries).
///
/// See [`crate::client::fluent_builders::DescribeRegistries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRegistries {
    _private: (),
}
impl DescribeRegistries {
    /// Creates a new builder-style object to manufacture [`DescribeRegistriesInput`](crate::input::DescribeRegistriesInput)
    pub fn builder() -> crate::input::describe_registries_input::Builder {
        crate::input::describe_registries_input::Builder::default()
    }
    /// Creates a new `DescribeRegistries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRegistries {
    type Output = std::result::Result<
        crate::output::DescribeRegistriesOutput,
        crate::error::DescribeRegistriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_registries_error(response)
        } else {
            crate::operation_deser::parse_describe_registries_response(response)
        }
    }
}

/// Operation shape for `DescribeRepositories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_repositories`](crate::client::Client::describe_repositories).
///
/// See [`crate::client::fluent_builders::DescribeRepositories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRepositories {
    _private: (),
}
impl DescribeRepositories {
    /// Creates a new builder-style object to manufacture [`DescribeRepositoriesInput`](crate::input::DescribeRepositoriesInput)
    pub fn builder() -> crate::input::describe_repositories_input::Builder {
        crate::input::describe_repositories_input::Builder::default()
    }
    /// Creates a new `DescribeRepositories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRepositories {
    type Output = std::result::Result<
        crate::output::DescribeRepositoriesOutput,
        crate::error::DescribeRepositoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_repositories_error(response)
        } else {
            crate::operation_deser::parse_describe_repositories_response(response)
        }
    }
}

/// Operation shape for `GetAuthorizationToken`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_authorization_token`](crate::client::Client::get_authorization_token).
///
/// See [`crate::client::fluent_builders::GetAuthorizationToken`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAuthorizationToken {
    _private: (),
}
impl GetAuthorizationToken {
    /// Creates a new builder-style object to manufacture [`GetAuthorizationTokenInput`](crate::input::GetAuthorizationTokenInput)
    pub fn builder() -> crate::input::get_authorization_token_input::Builder {
        crate::input::get_authorization_token_input::Builder::default()
    }
    /// Creates a new `GetAuthorizationToken` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAuthorizationToken {
    type Output = std::result::Result<
        crate::output::GetAuthorizationTokenOutput,
        crate::error::GetAuthorizationTokenError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_authorization_token_error(response)
        } else {
            crate::operation_deser::parse_get_authorization_token_response(response)
        }
    }
}

/// Operation shape for `GetRegistryCatalogData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_registry_catalog_data`](crate::client::Client::get_registry_catalog_data).
///
/// See [`crate::client::fluent_builders::GetRegistryCatalogData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRegistryCatalogData {
    _private: (),
}
impl GetRegistryCatalogData {
    /// Creates a new builder-style object to manufacture [`GetRegistryCatalogDataInput`](crate::input::GetRegistryCatalogDataInput)
    pub fn builder() -> crate::input::get_registry_catalog_data_input::Builder {
        crate::input::get_registry_catalog_data_input::Builder::default()
    }
    /// Creates a new `GetRegistryCatalogData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRegistryCatalogData {
    type Output = std::result::Result<
        crate::output::GetRegistryCatalogDataOutput,
        crate::error::GetRegistryCatalogDataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_registry_catalog_data_error(response)
        } else {
            crate::operation_deser::parse_get_registry_catalog_data_response(response)
        }
    }
}

/// Operation shape for `GetRepositoryCatalogData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_repository_catalog_data`](crate::client::Client::get_repository_catalog_data).
///
/// See [`crate::client::fluent_builders::GetRepositoryCatalogData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRepositoryCatalogData {
    _private: (),
}
impl GetRepositoryCatalogData {
    /// Creates a new builder-style object to manufacture [`GetRepositoryCatalogDataInput`](crate::input::GetRepositoryCatalogDataInput)
    pub fn builder() -> crate::input::get_repository_catalog_data_input::Builder {
        crate::input::get_repository_catalog_data_input::Builder::default()
    }
    /// Creates a new `GetRepositoryCatalogData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRepositoryCatalogData {
    type Output = std::result::Result<
        crate::output::GetRepositoryCatalogDataOutput,
        crate::error::GetRepositoryCatalogDataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_repository_catalog_data_error(response)
        } else {
            crate::operation_deser::parse_get_repository_catalog_data_response(response)
        }
    }
}

/// Operation shape for `GetRepositoryPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_repository_policy`](crate::client::Client::get_repository_policy).
///
/// See [`crate::client::fluent_builders::GetRepositoryPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRepositoryPolicy {
    _private: (),
}
impl GetRepositoryPolicy {
    /// Creates a new builder-style object to manufacture [`GetRepositoryPolicyInput`](crate::input::GetRepositoryPolicyInput)
    pub fn builder() -> crate::input::get_repository_policy_input::Builder {
        crate::input::get_repository_policy_input::Builder::default()
    }
    /// Creates a new `GetRepositoryPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRepositoryPolicy {
    type Output = std::result::Result<
        crate::output::GetRepositoryPolicyOutput,
        crate::error::GetRepositoryPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_repository_policy_error(response)
        } else {
            crate::operation_deser::parse_get_repository_policy_response(response)
        }
    }
}

/// Operation shape for `InitiateLayerUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`initiate_layer_upload`](crate::client::Client::initiate_layer_upload).
///
/// See [`crate::client::fluent_builders::InitiateLayerUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InitiateLayerUpload {
    _private: (),
}
impl InitiateLayerUpload {
    /// Creates a new builder-style object to manufacture [`InitiateLayerUploadInput`](crate::input::InitiateLayerUploadInput)
    pub fn builder() -> crate::input::initiate_layer_upload_input::Builder {
        crate::input::initiate_layer_upload_input::Builder::default()
    }
    /// Creates a new `InitiateLayerUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InitiateLayerUpload {
    type Output = std::result::Result<
        crate::output::InitiateLayerUploadOutput,
        crate::error::InitiateLayerUploadError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_initiate_layer_upload_error(response)
        } else {
            crate::operation_deser::parse_initiate_layer_upload_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_image`](crate::client::Client::put_image).
///
/// See [`crate::client::fluent_builders::PutImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutImage {
    _private: (),
}
impl PutImage {
    /// Creates a new builder-style object to manufacture [`PutImageInput`](crate::input::PutImageInput)
    pub fn builder() -> crate::input::put_image_input::Builder {
        crate::input::put_image_input::Builder::default()
    }
    /// Creates a new `PutImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutImage {
    type Output = std::result::Result<crate::output::PutImageOutput, crate::error::PutImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_image_error(response)
        } else {
            crate::operation_deser::parse_put_image_response(response)
        }
    }
}

/// Operation shape for `PutRegistryCatalogData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_registry_catalog_data`](crate::client::Client::put_registry_catalog_data).
///
/// See [`crate::client::fluent_builders::PutRegistryCatalogData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutRegistryCatalogData {
    _private: (),
}
impl PutRegistryCatalogData {
    /// Creates a new builder-style object to manufacture [`PutRegistryCatalogDataInput`](crate::input::PutRegistryCatalogDataInput)
    pub fn builder() -> crate::input::put_registry_catalog_data_input::Builder {
        crate::input::put_registry_catalog_data_input::Builder::default()
    }
    /// Creates a new `PutRegistryCatalogData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutRegistryCatalogData {
    type Output = std::result::Result<
        crate::output::PutRegistryCatalogDataOutput,
        crate::error::PutRegistryCatalogDataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_registry_catalog_data_error(response)
        } else {
            crate::operation_deser::parse_put_registry_catalog_data_response(response)
        }
    }
}

/// Operation shape for `PutRepositoryCatalogData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_repository_catalog_data`](crate::client::Client::put_repository_catalog_data).
///
/// See [`crate::client::fluent_builders::PutRepositoryCatalogData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutRepositoryCatalogData {
    _private: (),
}
impl PutRepositoryCatalogData {
    /// Creates a new builder-style object to manufacture [`PutRepositoryCatalogDataInput`](crate::input::PutRepositoryCatalogDataInput)
    pub fn builder() -> crate::input::put_repository_catalog_data_input::Builder {
        crate::input::put_repository_catalog_data_input::Builder::default()
    }
    /// Creates a new `PutRepositoryCatalogData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutRepositoryCatalogData {
    type Output = std::result::Result<
        crate::output::PutRepositoryCatalogDataOutput,
        crate::error::PutRepositoryCatalogDataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_repository_catalog_data_error(response)
        } else {
            crate::operation_deser::parse_put_repository_catalog_data_response(response)
        }
    }
}

/// Operation shape for `SetRepositoryPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_repository_policy`](crate::client::Client::set_repository_policy).
///
/// See [`crate::client::fluent_builders::SetRepositoryPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetRepositoryPolicy {
    _private: (),
}
impl SetRepositoryPolicy {
    /// Creates a new builder-style object to manufacture [`SetRepositoryPolicyInput`](crate::input::SetRepositoryPolicyInput)
    pub fn builder() -> crate::input::set_repository_policy_input::Builder {
        crate::input::set_repository_policy_input::Builder::default()
    }
    /// Creates a new `SetRepositoryPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetRepositoryPolicy {
    type Output = std::result::Result<
        crate::output::SetRepositoryPolicyOutput,
        crate::error::SetRepositoryPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_repository_policy_error(response)
        } else {
            crate::operation_deser::parse_set_repository_policy_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UploadLayerPart`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`upload_layer_part`](crate::client::Client::upload_layer_part).
///
/// See [`crate::client::fluent_builders::UploadLayerPart`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UploadLayerPart {
    _private: (),
}
impl UploadLayerPart {
    /// Creates a new builder-style object to manufacture [`UploadLayerPartInput`](crate::input::UploadLayerPartInput)
    pub fn builder() -> crate::input::upload_layer_part_input::Builder {
        crate::input::upload_layer_part_input::Builder::default()
    }
    /// Creates a new `UploadLayerPart` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UploadLayerPart {
    type Output = std::result::Result<
        crate::output::UploadLayerPartOutput,
        crate::error::UploadLayerPartError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_upload_layer_part_error(response)
        } else {
            crate::operation_deser::parse_upload_layer_part_response(response)
        }
    }
}
