// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadLayerPartOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The upload ID associated with the request.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>The integer value of the last byte received in the request.</p>
    pub last_byte_received: std::option::Option<i64>,
}
impl UploadLayerPartOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The upload ID associated with the request.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>The integer value of the last byte received in the request.</p>
    pub fn last_byte_received(&self) -> std::option::Option<i64> {
        self.last_byte_received
    }
}
impl std::fmt::Debug for UploadLayerPartOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadLayerPartOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("upload_id", &self.upload_id);
        formatter.field("last_byte_received", &self.last_byte_received);
        formatter.finish()
    }
}
/// See [`UploadLayerPartOutput`](crate::output::UploadLayerPartOutput)
pub mod upload_layer_part_output {
    /// A builder for [`UploadLayerPartOutput`](crate::output::UploadLayerPartOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) last_byte_received: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The upload ID associated with the request.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The upload ID associated with the request.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>The integer value of the last byte received in the request.</p>
        pub fn last_byte_received(mut self, input: i64) -> Self {
            self.last_byte_received = Some(input);
            self
        }
        /// <p>The integer value of the last byte received in the request.</p>
        pub fn set_last_byte_received(mut self, input: std::option::Option<i64>) -> Self {
            self.last_byte_received = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadLayerPartOutput`](crate::output::UploadLayerPartOutput)
        pub fn build(self) -> crate::output::UploadLayerPartOutput {
            crate::output::UploadLayerPartOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                upload_id: self.upload_id,
                last_byte_received: self.last_byte_received,
            }
        }
    }
}
impl UploadLayerPartOutput {
    /// Creates a new builder-style object to manufacture [`UploadLayerPartOutput`](crate::output::UploadLayerPartOutput)
    pub fn builder() -> crate::output::upload_layer_part_output::Builder {
        crate::output::upload_layer_part_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetRepositoryPolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The JSON repository policy text applied to the repository.</p>
    pub policy_text: std::option::Option<std::string::String>,
}
impl SetRepositoryPolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The JSON repository policy text applied to the repository.</p>
    pub fn policy_text(&self) -> std::option::Option<&str> {
        self.policy_text.as_deref()
    }
}
impl std::fmt::Debug for SetRepositoryPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetRepositoryPolicyOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("policy_text", &self.policy_text);
        formatter.finish()
    }
}
/// See [`SetRepositoryPolicyOutput`](crate::output::SetRepositoryPolicyOutput)
pub mod set_repository_policy_output {
    /// A builder for [`SetRepositoryPolicyOutput`](crate::output::SetRepositoryPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) policy_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The JSON repository policy text applied to the repository.</p>
        pub fn policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_text = Some(input.into());
            self
        }
        /// <p>The JSON repository policy text applied to the repository.</p>
        pub fn set_policy_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_text = input;
            self
        }
        /// Consumes the builder and constructs a [`SetRepositoryPolicyOutput`](crate::output::SetRepositoryPolicyOutput)
        pub fn build(self) -> crate::output::SetRepositoryPolicyOutput {
            crate::output::SetRepositoryPolicyOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                policy_text: self.policy_text,
            }
        }
    }
}
impl SetRepositoryPolicyOutput {
    /// Creates a new builder-style object to manufacture [`SetRepositoryPolicyOutput`](crate::output::SetRepositoryPolicyOutput)
    pub fn builder() -> crate::output::set_repository_policy_output::Builder {
        crate::output::set_repository_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRepositoryCatalogDataOutput {
    /// <p>The catalog data for the repository.</p>
    pub catalog_data: std::option::Option<crate::model::RepositoryCatalogData>,
}
impl PutRepositoryCatalogDataOutput {
    /// <p>The catalog data for the repository.</p>
    pub fn catalog_data(&self) -> std::option::Option<&crate::model::RepositoryCatalogData> {
        self.catalog_data.as_ref()
    }
}
impl std::fmt::Debug for PutRepositoryCatalogDataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRepositoryCatalogDataOutput");
        formatter.field("catalog_data", &self.catalog_data);
        formatter.finish()
    }
}
/// See [`PutRepositoryCatalogDataOutput`](crate::output::PutRepositoryCatalogDataOutput)
pub mod put_repository_catalog_data_output {
    /// A builder for [`PutRepositoryCatalogDataOutput`](crate::output::PutRepositoryCatalogDataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_data: std::option::Option<crate::model::RepositoryCatalogData>,
    }
    impl Builder {
        /// <p>The catalog data for the repository.</p>
        pub fn catalog_data(mut self, input: crate::model::RepositoryCatalogData) -> Self {
            self.catalog_data = Some(input);
            self
        }
        /// <p>The catalog data for the repository.</p>
        pub fn set_catalog_data(
            mut self,
            input: std::option::Option<crate::model::RepositoryCatalogData>,
        ) -> Self {
            self.catalog_data = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRepositoryCatalogDataOutput`](crate::output::PutRepositoryCatalogDataOutput)
        pub fn build(self) -> crate::output::PutRepositoryCatalogDataOutput {
            crate::output::PutRepositoryCatalogDataOutput {
                catalog_data: self.catalog_data,
            }
        }
    }
}
impl PutRepositoryCatalogDataOutput {
    /// Creates a new builder-style object to manufacture [`PutRepositoryCatalogDataOutput`](crate::output::PutRepositoryCatalogDataOutput)
    pub fn builder() -> crate::output::put_repository_catalog_data_output::Builder {
        crate::output::put_repository_catalog_data_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRegistryCatalogDataOutput {
    /// <p>The catalog data for the public registry.</p>
    pub registry_catalog_data: std::option::Option<crate::model::RegistryCatalogData>,
}
impl PutRegistryCatalogDataOutput {
    /// <p>The catalog data for the public registry.</p>
    pub fn registry_catalog_data(&self) -> std::option::Option<&crate::model::RegistryCatalogData> {
        self.registry_catalog_data.as_ref()
    }
}
impl std::fmt::Debug for PutRegistryCatalogDataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRegistryCatalogDataOutput");
        formatter.field("registry_catalog_data", &self.registry_catalog_data);
        formatter.finish()
    }
}
/// See [`PutRegistryCatalogDataOutput`](crate::output::PutRegistryCatalogDataOutput)
pub mod put_registry_catalog_data_output {
    /// A builder for [`PutRegistryCatalogDataOutput`](crate::output::PutRegistryCatalogDataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_catalog_data: std::option::Option<crate::model::RegistryCatalogData>,
    }
    impl Builder {
        /// <p>The catalog data for the public registry.</p>
        pub fn registry_catalog_data(mut self, input: crate::model::RegistryCatalogData) -> Self {
            self.registry_catalog_data = Some(input);
            self
        }
        /// <p>The catalog data for the public registry.</p>
        pub fn set_registry_catalog_data(
            mut self,
            input: std::option::Option<crate::model::RegistryCatalogData>,
        ) -> Self {
            self.registry_catalog_data = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRegistryCatalogDataOutput`](crate::output::PutRegistryCatalogDataOutput)
        pub fn build(self) -> crate::output::PutRegistryCatalogDataOutput {
            crate::output::PutRegistryCatalogDataOutput {
                registry_catalog_data: self.registry_catalog_data,
            }
        }
    }
}
impl PutRegistryCatalogDataOutput {
    /// Creates a new builder-style object to manufacture [`PutRegistryCatalogDataOutput`](crate::output::PutRegistryCatalogDataOutput)
    pub fn builder() -> crate::output::put_registry_catalog_data_output::Builder {
        crate::output::put_registry_catalog_data_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutImageOutput {
    /// <p>Details of the image uploaded.</p>
    pub image: std::option::Option<crate::model::Image>,
}
impl PutImageOutput {
    /// <p>Details of the image uploaded.</p>
    pub fn image(&self) -> std::option::Option<&crate::model::Image> {
        self.image.as_ref()
    }
}
impl std::fmt::Debug for PutImageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutImageOutput");
        formatter.field("image", &self.image);
        formatter.finish()
    }
}
/// See [`PutImageOutput`](crate::output::PutImageOutput)
pub mod put_image_output {
    /// A builder for [`PutImageOutput`](crate::output::PutImageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image: std::option::Option<crate::model::Image>,
    }
    impl Builder {
        /// <p>Details of the image uploaded.</p>
        pub fn image(mut self, input: crate::model::Image) -> Self {
            self.image = Some(input);
            self
        }
        /// <p>Details of the image uploaded.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.image = input;
            self
        }
        /// Consumes the builder and constructs a [`PutImageOutput`](crate::output::PutImageOutput)
        pub fn build(self) -> crate::output::PutImageOutput {
            crate::output::PutImageOutput { image: self.image }
        }
    }
}
impl PutImageOutput {
    /// Creates a new builder-style object to manufacture [`PutImageOutput`](crate::output::PutImageOutput)
    pub fn builder() -> crate::output::put_image_output::Builder {
        crate::output::put_image_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags for the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags for the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitiateLayerUploadOutput {
    /// <p>The upload ID for the layer upload. This parameter is passed to further <a>UploadLayerPart</a> and <a>CompleteLayerUpload</a> operations.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>The size, in bytes, that Amazon ECR expects future layer part uploads to be.</p>
    pub part_size: std::option::Option<i64>,
}
impl InitiateLayerUploadOutput {
    /// <p>The upload ID for the layer upload. This parameter is passed to further <a>UploadLayerPart</a> and <a>CompleteLayerUpload</a> operations.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>The size, in bytes, that Amazon ECR expects future layer part uploads to be.</p>
    pub fn part_size(&self) -> std::option::Option<i64> {
        self.part_size
    }
}
impl std::fmt::Debug for InitiateLayerUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitiateLayerUploadOutput");
        formatter.field("upload_id", &self.upload_id);
        formatter.field("part_size", &self.part_size);
        formatter.finish()
    }
}
/// See [`InitiateLayerUploadOutput`](crate::output::InitiateLayerUploadOutput)
pub mod initiate_layer_upload_output {
    /// A builder for [`InitiateLayerUploadOutput`](crate::output::InitiateLayerUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) part_size: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The upload ID for the layer upload. This parameter is passed to further <a>UploadLayerPart</a> and <a>CompleteLayerUpload</a> operations.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The upload ID for the layer upload. This parameter is passed to further <a>UploadLayerPart</a> and <a>CompleteLayerUpload</a> operations.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>The size, in bytes, that Amazon ECR expects future layer part uploads to be.</p>
        pub fn part_size(mut self, input: i64) -> Self {
            self.part_size = Some(input);
            self
        }
        /// <p>The size, in bytes, that Amazon ECR expects future layer part uploads to be.</p>
        pub fn set_part_size(mut self, input: std::option::Option<i64>) -> Self {
            self.part_size = input;
            self
        }
        /// Consumes the builder and constructs a [`InitiateLayerUploadOutput`](crate::output::InitiateLayerUploadOutput)
        pub fn build(self) -> crate::output::InitiateLayerUploadOutput {
            crate::output::InitiateLayerUploadOutput {
                upload_id: self.upload_id,
                part_size: self.part_size,
            }
        }
    }
}
impl InitiateLayerUploadOutput {
    /// Creates a new builder-style object to manufacture [`InitiateLayerUploadOutput`](crate::output::InitiateLayerUploadOutput)
    pub fn builder() -> crate::output::initiate_layer_upload_output::Builder {
        crate::output::initiate_layer_upload_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRepositoryPolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The repository policy text associated with the repository. The policy text will be in
    /// JSON format.</p>
    pub policy_text: std::option::Option<std::string::String>,
}
impl GetRepositoryPolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The repository policy text associated with the repository. The policy text will be in
    /// JSON format.</p>
    pub fn policy_text(&self) -> std::option::Option<&str> {
        self.policy_text.as_deref()
    }
}
impl std::fmt::Debug for GetRepositoryPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRepositoryPolicyOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("policy_text", &self.policy_text);
        formatter.finish()
    }
}
/// See [`GetRepositoryPolicyOutput`](crate::output::GetRepositoryPolicyOutput)
pub mod get_repository_policy_output {
    /// A builder for [`GetRepositoryPolicyOutput`](crate::output::GetRepositoryPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) policy_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The repository policy text associated with the repository. The policy text will be in
        /// JSON format.</p>
        pub fn policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_text = Some(input.into());
            self
        }
        /// <p>The repository policy text associated with the repository. The policy text will be in
        /// JSON format.</p>
        pub fn set_policy_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_text = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRepositoryPolicyOutput`](crate::output::GetRepositoryPolicyOutput)
        pub fn build(self) -> crate::output::GetRepositoryPolicyOutput {
            crate::output::GetRepositoryPolicyOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                policy_text: self.policy_text,
            }
        }
    }
}
impl GetRepositoryPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetRepositoryPolicyOutput`](crate::output::GetRepositoryPolicyOutput)
    pub fn builder() -> crate::output::get_repository_policy_output::Builder {
        crate::output::get_repository_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRepositoryCatalogDataOutput {
    /// <p>The catalog metadata for the repository.</p>
    pub catalog_data: std::option::Option<crate::model::RepositoryCatalogData>,
}
impl GetRepositoryCatalogDataOutput {
    /// <p>The catalog metadata for the repository.</p>
    pub fn catalog_data(&self) -> std::option::Option<&crate::model::RepositoryCatalogData> {
        self.catalog_data.as_ref()
    }
}
impl std::fmt::Debug for GetRepositoryCatalogDataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRepositoryCatalogDataOutput");
        formatter.field("catalog_data", &self.catalog_data);
        formatter.finish()
    }
}
/// See [`GetRepositoryCatalogDataOutput`](crate::output::GetRepositoryCatalogDataOutput)
pub mod get_repository_catalog_data_output {
    /// A builder for [`GetRepositoryCatalogDataOutput`](crate::output::GetRepositoryCatalogDataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_data: std::option::Option<crate::model::RepositoryCatalogData>,
    }
    impl Builder {
        /// <p>The catalog metadata for the repository.</p>
        pub fn catalog_data(mut self, input: crate::model::RepositoryCatalogData) -> Self {
            self.catalog_data = Some(input);
            self
        }
        /// <p>The catalog metadata for the repository.</p>
        pub fn set_catalog_data(
            mut self,
            input: std::option::Option<crate::model::RepositoryCatalogData>,
        ) -> Self {
            self.catalog_data = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRepositoryCatalogDataOutput`](crate::output::GetRepositoryCatalogDataOutput)
        pub fn build(self) -> crate::output::GetRepositoryCatalogDataOutput {
            crate::output::GetRepositoryCatalogDataOutput {
                catalog_data: self.catalog_data,
            }
        }
    }
}
impl GetRepositoryCatalogDataOutput {
    /// Creates a new builder-style object to manufacture [`GetRepositoryCatalogDataOutput`](crate::output::GetRepositoryCatalogDataOutput)
    pub fn builder() -> crate::output::get_repository_catalog_data_output::Builder {
        crate::output::get_repository_catalog_data_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRegistryCatalogDataOutput {
    /// <p>The catalog metadata for the public registry.</p>
    pub registry_catalog_data: std::option::Option<crate::model::RegistryCatalogData>,
}
impl GetRegistryCatalogDataOutput {
    /// <p>The catalog metadata for the public registry.</p>
    pub fn registry_catalog_data(&self) -> std::option::Option<&crate::model::RegistryCatalogData> {
        self.registry_catalog_data.as_ref()
    }
}
impl std::fmt::Debug for GetRegistryCatalogDataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRegistryCatalogDataOutput");
        formatter.field("registry_catalog_data", &self.registry_catalog_data);
        formatter.finish()
    }
}
/// See [`GetRegistryCatalogDataOutput`](crate::output::GetRegistryCatalogDataOutput)
pub mod get_registry_catalog_data_output {
    /// A builder for [`GetRegistryCatalogDataOutput`](crate::output::GetRegistryCatalogDataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_catalog_data: std::option::Option<crate::model::RegistryCatalogData>,
    }
    impl Builder {
        /// <p>The catalog metadata for the public registry.</p>
        pub fn registry_catalog_data(mut self, input: crate::model::RegistryCatalogData) -> Self {
            self.registry_catalog_data = Some(input);
            self
        }
        /// <p>The catalog metadata for the public registry.</p>
        pub fn set_registry_catalog_data(
            mut self,
            input: std::option::Option<crate::model::RegistryCatalogData>,
        ) -> Self {
            self.registry_catalog_data = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRegistryCatalogDataOutput`](crate::output::GetRegistryCatalogDataOutput)
        pub fn build(self) -> crate::output::GetRegistryCatalogDataOutput {
            crate::output::GetRegistryCatalogDataOutput {
                registry_catalog_data: self.registry_catalog_data,
            }
        }
    }
}
impl GetRegistryCatalogDataOutput {
    /// Creates a new builder-style object to manufacture [`GetRegistryCatalogDataOutput`](crate::output::GetRegistryCatalogDataOutput)
    pub fn builder() -> crate::output::get_registry_catalog_data_output::Builder {
        crate::output::get_registry_catalog_data_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAuthorizationTokenOutput {
    /// <p>An authorization token data object that corresponds to a public registry.</p>
    pub authorization_data: std::option::Option<crate::model::AuthorizationData>,
}
impl GetAuthorizationTokenOutput {
    /// <p>An authorization token data object that corresponds to a public registry.</p>
    pub fn authorization_data(&self) -> std::option::Option<&crate::model::AuthorizationData> {
        self.authorization_data.as_ref()
    }
}
impl std::fmt::Debug for GetAuthorizationTokenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAuthorizationTokenOutput");
        formatter.field("authorization_data", &self.authorization_data);
        formatter.finish()
    }
}
/// See [`GetAuthorizationTokenOutput`](crate::output::GetAuthorizationTokenOutput)
pub mod get_authorization_token_output {
    /// A builder for [`GetAuthorizationTokenOutput`](crate::output::GetAuthorizationTokenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorization_data: std::option::Option<crate::model::AuthorizationData>,
    }
    impl Builder {
        /// <p>An authorization token data object that corresponds to a public registry.</p>
        pub fn authorization_data(mut self, input: crate::model::AuthorizationData) -> Self {
            self.authorization_data = Some(input);
            self
        }
        /// <p>An authorization token data object that corresponds to a public registry.</p>
        pub fn set_authorization_data(
            mut self,
            input: std::option::Option<crate::model::AuthorizationData>,
        ) -> Self {
            self.authorization_data = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAuthorizationTokenOutput`](crate::output::GetAuthorizationTokenOutput)
        pub fn build(self) -> crate::output::GetAuthorizationTokenOutput {
            crate::output::GetAuthorizationTokenOutput {
                authorization_data: self.authorization_data,
            }
        }
    }
}
impl GetAuthorizationTokenOutput {
    /// Creates a new builder-style object to manufacture [`GetAuthorizationTokenOutput`](crate::output::GetAuthorizationTokenOutput)
    pub fn builder() -> crate::output::get_authorization_token_output::Builder {
        crate::output::get_authorization_token_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRepositoriesOutput {
    /// <p>A list of repository objects corresponding to valid repositories.</p>
    pub repositories: std::option::Option<std::vec::Vec<crate::model::Repository>>,
    /// <p>The <code>nextToken</code> value to include in a future
    /// <code>DescribeRepositories</code> request. When the results of a
    /// <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this value can
    /// be used to retrieve the next page of results. This value is <code>null</code> when there
    /// are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeRepositoriesOutput {
    /// <p>A list of repository objects corresponding to valid repositories.</p>
    pub fn repositories(&self) -> std::option::Option<&[crate::model::Repository]> {
        self.repositories.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future
    /// <code>DescribeRepositories</code> request. When the results of a
    /// <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this value can
    /// be used to retrieve the next page of results. This value is <code>null</code> when there
    /// are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeRepositoriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRepositoriesOutput");
        formatter.field("repositories", &self.repositories);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeRepositoriesOutput`](crate::output::DescribeRepositoriesOutput)
pub mod describe_repositories_output {
    /// A builder for [`DescribeRepositoriesOutput`](crate::output::DescribeRepositoriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repositories: std::option::Option<std::vec::Vec<crate::model::Repository>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `repositories`.
        ///
        /// To override the contents of this collection use [`set_repositories`](Self::set_repositories).
        ///
        /// <p>A list of repository objects corresponding to valid repositories.</p>
        pub fn repositories(mut self, input: impl Into<crate::model::Repository>) -> Self {
            let mut v = self.repositories.unwrap_or_default();
            v.push(input.into());
            self.repositories = Some(v);
            self
        }
        /// <p>A list of repository objects corresponding to valid repositories.</p>
        pub fn set_repositories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Repository>>,
        ) -> Self {
            self.repositories = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future
        /// <code>DescribeRepositories</code> request. When the results of a
        /// <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this value can
        /// be used to retrieve the next page of results. This value is <code>null</code> when there
        /// are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future
        /// <code>DescribeRepositories</code> request. When the results of a
        /// <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this value can
        /// be used to retrieve the next page of results. This value is <code>null</code> when there
        /// are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRepositoriesOutput`](crate::output::DescribeRepositoriesOutput)
        pub fn build(self) -> crate::output::DescribeRepositoriesOutput {
            crate::output::DescribeRepositoriesOutput {
                repositories: self.repositories,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeRepositoriesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRepositoriesOutput`](crate::output::DescribeRepositoriesOutput)
    pub fn builder() -> crate::output::describe_repositories_output::Builder {
        crate::output::describe_repositories_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRegistriesOutput {
    /// <p>An object containing the details for a public registry.</p>
    pub registries: std::option::Option<std::vec::Vec<crate::model::Registry>>,
    /// <p>The <code>nextToken</code> value to include in a future
    /// <code>DescribeRepositories</code> request. When the results of a
    /// <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this value can
    /// be used to retrieve the next page of results. This value is <code>null</code> when there
    /// are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeRegistriesOutput {
    /// <p>An object containing the details for a public registry.</p>
    pub fn registries(&self) -> std::option::Option<&[crate::model::Registry]> {
        self.registries.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future
    /// <code>DescribeRepositories</code> request. When the results of a
    /// <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this value can
    /// be used to retrieve the next page of results. This value is <code>null</code> when there
    /// are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeRegistriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRegistriesOutput");
        formatter.field("registries", &self.registries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeRegistriesOutput`](crate::output::DescribeRegistriesOutput)
pub mod describe_registries_output {
    /// A builder for [`DescribeRegistriesOutput`](crate::output::DescribeRegistriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registries: std::option::Option<std::vec::Vec<crate::model::Registry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `registries`.
        ///
        /// To override the contents of this collection use [`set_registries`](Self::set_registries).
        ///
        /// <p>An object containing the details for a public registry.</p>
        pub fn registries(mut self, input: impl Into<crate::model::Registry>) -> Self {
            let mut v = self.registries.unwrap_or_default();
            v.push(input.into());
            self.registries = Some(v);
            self
        }
        /// <p>An object containing the details for a public registry.</p>
        pub fn set_registries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Registry>>,
        ) -> Self {
            self.registries = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future
        /// <code>DescribeRepositories</code> request. When the results of a
        /// <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this value can
        /// be used to retrieve the next page of results. This value is <code>null</code> when there
        /// are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future
        /// <code>DescribeRepositories</code> request. When the results of a
        /// <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this value can
        /// be used to retrieve the next page of results. This value is <code>null</code> when there
        /// are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRegistriesOutput`](crate::output::DescribeRegistriesOutput)
        pub fn build(self) -> crate::output::DescribeRegistriesOutput {
            crate::output::DescribeRegistriesOutput {
                registries: self.registries,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeRegistriesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRegistriesOutput`](crate::output::DescribeRegistriesOutput)
    pub fn builder() -> crate::output::describe_registries_output::Builder {
        crate::output::describe_registries_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImageTagsOutput {
    /// <p>The image tag details for the images in the requested repository.</p>
    pub image_tag_details: std::option::Option<std::vec::Vec<crate::model::ImageTagDetail>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>DescribeImageTags</code>
    /// request. When the results of a <code>DescribeImageTags</code> request exceed
    /// <code>maxResults</code>, this value can be used to retrieve the next page of results.
    /// This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeImageTagsOutput {
    /// <p>The image tag details for the images in the requested repository.</p>
    pub fn image_tag_details(&self) -> std::option::Option<&[crate::model::ImageTagDetail]> {
        self.image_tag_details.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>DescribeImageTags</code>
    /// request. When the results of a <code>DescribeImageTags</code> request exceed
    /// <code>maxResults</code>, this value can be used to retrieve the next page of results.
    /// This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeImageTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImageTagsOutput");
        formatter.field("image_tag_details", &self.image_tag_details);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeImageTagsOutput`](crate::output::DescribeImageTagsOutput)
pub mod describe_image_tags_output {
    /// A builder for [`DescribeImageTagsOutput`](crate::output::DescribeImageTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_tag_details:
            std::option::Option<std::vec::Vec<crate::model::ImageTagDetail>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `image_tag_details`.
        ///
        /// To override the contents of this collection use [`set_image_tag_details`](Self::set_image_tag_details).
        ///
        /// <p>The image tag details for the images in the requested repository.</p>
        pub fn image_tag_details(mut self, input: impl Into<crate::model::ImageTagDetail>) -> Self {
            let mut v = self.image_tag_details.unwrap_or_default();
            v.push(input.into());
            self.image_tag_details = Some(v);
            self
        }
        /// <p>The image tag details for the images in the requested repository.</p>
        pub fn set_image_tag_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageTagDetail>>,
        ) -> Self {
            self.image_tag_details = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>DescribeImageTags</code>
        /// request. When the results of a <code>DescribeImageTags</code> request exceed
        /// <code>maxResults</code>, this value can be used to retrieve the next page of results.
        /// This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>DescribeImageTags</code>
        /// request. When the results of a <code>DescribeImageTags</code> request exceed
        /// <code>maxResults</code>, this value can be used to retrieve the next page of results.
        /// This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImageTagsOutput`](crate::output::DescribeImageTagsOutput)
        pub fn build(self) -> crate::output::DescribeImageTagsOutput {
            crate::output::DescribeImageTagsOutput {
                image_tag_details: self.image_tag_details,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeImageTagsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeImageTagsOutput`](crate::output::DescribeImageTagsOutput)
    pub fn builder() -> crate::output::describe_image_tags_output::Builder {
        crate::output::describe_image_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImagesOutput {
    /// <p>A list of <a>ImageDetail</a> objects that contain data about the
    /// image.</p>
    pub image_details: std::option::Option<std::vec::Vec<crate::model::ImageDetail>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>DescribeImages</code>
    /// request. When the results of a <code>DescribeImages</code> request exceed
    /// <code>maxResults</code>, this value can be used to retrieve the next page of results.
    /// This value is <code>null</code> when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeImagesOutput {
    /// <p>A list of <a>ImageDetail</a> objects that contain data about the
    /// image.</p>
    pub fn image_details(&self) -> std::option::Option<&[crate::model::ImageDetail]> {
        self.image_details.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>DescribeImages</code>
    /// request. When the results of a <code>DescribeImages</code> request exceed
    /// <code>maxResults</code>, this value can be used to retrieve the next page of results.
    /// This value is <code>null</code> when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeImagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImagesOutput");
        formatter.field("image_details", &self.image_details);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeImagesOutput`](crate::output::DescribeImagesOutput)
pub mod describe_images_output {
    /// A builder for [`DescribeImagesOutput`](crate::output::DescribeImagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_details: std::option::Option<std::vec::Vec<crate::model::ImageDetail>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `image_details`.
        ///
        /// To override the contents of this collection use [`set_image_details`](Self::set_image_details).
        ///
        /// <p>A list of <a>ImageDetail</a> objects that contain data about the
        /// image.</p>
        pub fn image_details(mut self, input: impl Into<crate::model::ImageDetail>) -> Self {
            let mut v = self.image_details.unwrap_or_default();
            v.push(input.into());
            self.image_details = Some(v);
            self
        }
        /// <p>A list of <a>ImageDetail</a> objects that contain data about the
        /// image.</p>
        pub fn set_image_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageDetail>>,
        ) -> Self {
            self.image_details = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>DescribeImages</code>
        /// request. When the results of a <code>DescribeImages</code> request exceed
        /// <code>maxResults</code>, this value can be used to retrieve the next page of results.
        /// This value is <code>null</code> when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>DescribeImages</code>
        /// request. When the results of a <code>DescribeImages</code> request exceed
        /// <code>maxResults</code>, this value can be used to retrieve the next page of results.
        /// This value is <code>null</code> when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImagesOutput`](crate::output::DescribeImagesOutput)
        pub fn build(self) -> crate::output::DescribeImagesOutput {
            crate::output::DescribeImagesOutput {
                image_details: self.image_details,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeImagesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeImagesOutput`](crate::output::DescribeImagesOutput)
    pub fn builder() -> crate::output::describe_images_output::Builder {
        crate::output::describe_images_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRepositoryPolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The JSON repository policy that was deleted from the repository.</p>
    pub policy_text: std::option::Option<std::string::String>,
}
impl DeleteRepositoryPolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The JSON repository policy that was deleted from the repository.</p>
    pub fn policy_text(&self) -> std::option::Option<&str> {
        self.policy_text.as_deref()
    }
}
impl std::fmt::Debug for DeleteRepositoryPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRepositoryPolicyOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("policy_text", &self.policy_text);
        formatter.finish()
    }
}
/// See [`DeleteRepositoryPolicyOutput`](crate::output::DeleteRepositoryPolicyOutput)
pub mod delete_repository_policy_output {
    /// A builder for [`DeleteRepositoryPolicyOutput`](crate::output::DeleteRepositoryPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) policy_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The JSON repository policy that was deleted from the repository.</p>
        pub fn policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_text = Some(input.into());
            self
        }
        /// <p>The JSON repository policy that was deleted from the repository.</p>
        pub fn set_policy_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_text = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRepositoryPolicyOutput`](crate::output::DeleteRepositoryPolicyOutput)
        pub fn build(self) -> crate::output::DeleteRepositoryPolicyOutput {
            crate::output::DeleteRepositoryPolicyOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                policy_text: self.policy_text,
            }
        }
    }
}
impl DeleteRepositoryPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryPolicyOutput`](crate::output::DeleteRepositoryPolicyOutput)
    pub fn builder() -> crate::output::delete_repository_policy_output::Builder {
        crate::output::delete_repository_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRepositoryOutput {
    /// <p>The repository that was deleted.</p>
    pub repository: std::option::Option<crate::model::Repository>,
}
impl DeleteRepositoryOutput {
    /// <p>The repository that was deleted.</p>
    pub fn repository(&self) -> std::option::Option<&crate::model::Repository> {
        self.repository.as_ref()
    }
}
impl std::fmt::Debug for DeleteRepositoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRepositoryOutput");
        formatter.field("repository", &self.repository);
        formatter.finish()
    }
}
/// See [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput)
pub mod delete_repository_output {
    /// A builder for [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository: std::option::Option<crate::model::Repository>,
    }
    impl Builder {
        /// <p>The repository that was deleted.</p>
        pub fn repository(mut self, input: crate::model::Repository) -> Self {
            self.repository = Some(input);
            self
        }
        /// <p>The repository that was deleted.</p>
        pub fn set_repository(
            mut self,
            input: std::option::Option<crate::model::Repository>,
        ) -> Self {
            self.repository = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput)
        pub fn build(self) -> crate::output::DeleteRepositoryOutput {
            crate::output::DeleteRepositoryOutput {
                repository: self.repository,
            }
        }
    }
}
impl DeleteRepositoryOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput)
    pub fn builder() -> crate::output::delete_repository_output::Builder {
        crate::output::delete_repository_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRepositoryOutput {
    /// <p>The repository that was created.</p>
    pub repository: std::option::Option<crate::model::Repository>,
    /// <p>The catalog data for a repository. This data is publicly visible in the
    /// Amazon ECR Public Gallery.</p>
    pub catalog_data: std::option::Option<crate::model::RepositoryCatalogData>,
}
impl CreateRepositoryOutput {
    /// <p>The repository that was created.</p>
    pub fn repository(&self) -> std::option::Option<&crate::model::Repository> {
        self.repository.as_ref()
    }
    /// <p>The catalog data for a repository. This data is publicly visible in the
    /// Amazon ECR Public Gallery.</p>
    pub fn catalog_data(&self) -> std::option::Option<&crate::model::RepositoryCatalogData> {
        self.catalog_data.as_ref()
    }
}
impl std::fmt::Debug for CreateRepositoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRepositoryOutput");
        formatter.field("repository", &self.repository);
        formatter.field("catalog_data", &self.catalog_data);
        formatter.finish()
    }
}
/// See [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput)
pub mod create_repository_output {
    /// A builder for [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository: std::option::Option<crate::model::Repository>,
        pub(crate) catalog_data: std::option::Option<crate::model::RepositoryCatalogData>,
    }
    impl Builder {
        /// <p>The repository that was created.</p>
        pub fn repository(mut self, input: crate::model::Repository) -> Self {
            self.repository = Some(input);
            self
        }
        /// <p>The repository that was created.</p>
        pub fn set_repository(
            mut self,
            input: std::option::Option<crate::model::Repository>,
        ) -> Self {
            self.repository = input;
            self
        }
        /// <p>The catalog data for a repository. This data is publicly visible in the
        /// Amazon ECR Public Gallery.</p>
        pub fn catalog_data(mut self, input: crate::model::RepositoryCatalogData) -> Self {
            self.catalog_data = Some(input);
            self
        }
        /// <p>The catalog data for a repository. This data is publicly visible in the
        /// Amazon ECR Public Gallery.</p>
        pub fn set_catalog_data(
            mut self,
            input: std::option::Option<crate::model::RepositoryCatalogData>,
        ) -> Self {
            self.catalog_data = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput)
        pub fn build(self) -> crate::output::CreateRepositoryOutput {
            crate::output::CreateRepositoryOutput {
                repository: self.repository,
                catalog_data: self.catalog_data,
            }
        }
    }
}
impl CreateRepositoryOutput {
    /// Creates a new builder-style object to manufacture [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput)
    pub fn builder() -> crate::output::create_repository_output::Builder {
        crate::output::create_repository_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompleteLayerUploadOutput {
    /// <p>The public registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The upload ID associated with the layer.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>The <code>sha256</code> digest of the image layer.</p>
    pub layer_digest: std::option::Option<std::string::String>,
}
impl CompleteLayerUploadOutput {
    /// <p>The public registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The upload ID associated with the layer.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>The <code>sha256</code> digest of the image layer.</p>
    pub fn layer_digest(&self) -> std::option::Option<&str> {
        self.layer_digest.as_deref()
    }
}
impl std::fmt::Debug for CompleteLayerUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompleteLayerUploadOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("upload_id", &self.upload_id);
        formatter.field("layer_digest", &self.layer_digest);
        formatter.finish()
    }
}
/// See [`CompleteLayerUploadOutput`](crate::output::CompleteLayerUploadOutput)
pub mod complete_layer_upload_output {
    /// A builder for [`CompleteLayerUploadOutput`](crate::output::CompleteLayerUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) layer_digest: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The public registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The public registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The upload ID associated with the layer.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The upload ID associated with the layer.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>The <code>sha256</code> digest of the image layer.</p>
        pub fn layer_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_digest = Some(input.into());
            self
        }
        /// <p>The <code>sha256</code> digest of the image layer.</p>
        pub fn set_layer_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_digest = input;
            self
        }
        /// Consumes the builder and constructs a [`CompleteLayerUploadOutput`](crate::output::CompleteLayerUploadOutput)
        pub fn build(self) -> crate::output::CompleteLayerUploadOutput {
            crate::output::CompleteLayerUploadOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                upload_id: self.upload_id,
                layer_digest: self.layer_digest,
            }
        }
    }
}
impl CompleteLayerUploadOutput {
    /// Creates a new builder-style object to manufacture [`CompleteLayerUploadOutput`](crate::output::CompleteLayerUploadOutput)
    pub fn builder() -> crate::output::complete_layer_upload_output::Builder {
        crate::output::complete_layer_upload_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteImageOutput {
    /// <p>The image IDs of the deleted images.</p>
    pub image_ids: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
    /// <p>Any failures associated with the call.</p>
    pub failures: std::option::Option<std::vec::Vec<crate::model::ImageFailure>>,
}
impl BatchDeleteImageOutput {
    /// <p>The image IDs of the deleted images.</p>
    pub fn image_ids(&self) -> std::option::Option<&[crate::model::ImageIdentifier]> {
        self.image_ids.as_deref()
    }
    /// <p>Any failures associated with the call.</p>
    pub fn failures(&self) -> std::option::Option<&[crate::model::ImageFailure]> {
        self.failures.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteImageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteImageOutput");
        formatter.field("image_ids", &self.image_ids);
        formatter.field("failures", &self.failures);
        formatter.finish()
    }
}
/// See [`BatchDeleteImageOutput`](crate::output::BatchDeleteImageOutput)
pub mod batch_delete_image_output {
    /// A builder for [`BatchDeleteImageOutput`](crate::output::BatchDeleteImageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_ids: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        pub(crate) failures: std::option::Option<std::vec::Vec<crate::model::ImageFailure>>,
    }
    impl Builder {
        /// Appends an item to `image_ids`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>The image IDs of the deleted images.</p>
        pub fn image_ids(mut self, input: impl Into<crate::model::ImageIdentifier>) -> Self {
            let mut v = self.image_ids.unwrap_or_default();
            v.push(input.into());
            self.image_ids = Some(v);
            self
        }
        /// <p>The image IDs of the deleted images.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.image_ids = input;
            self
        }
        /// Appends an item to `failures`.
        ///
        /// To override the contents of this collection use [`set_failures`](Self::set_failures).
        ///
        /// <p>Any failures associated with the call.</p>
        pub fn failures(mut self, input: impl Into<crate::model::ImageFailure>) -> Self {
            let mut v = self.failures.unwrap_or_default();
            v.push(input.into());
            self.failures = Some(v);
            self
        }
        /// <p>Any failures associated with the call.</p>
        pub fn set_failures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageFailure>>,
        ) -> Self {
            self.failures = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteImageOutput`](crate::output::BatchDeleteImageOutput)
        pub fn build(self) -> crate::output::BatchDeleteImageOutput {
            crate::output::BatchDeleteImageOutput {
                image_ids: self.image_ids,
                failures: self.failures,
            }
        }
    }
}
impl BatchDeleteImageOutput {
    /// Creates a new builder-style object to manufacture [`BatchDeleteImageOutput`](crate::output::BatchDeleteImageOutput)
    pub fn builder() -> crate::output::batch_delete_image_output::Builder {
        crate::output::batch_delete_image_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCheckLayerAvailabilityOutput {
    /// <p>A list of image layer objects corresponding to the image layer references in the
    /// request.</p>
    pub layers: std::option::Option<std::vec::Vec<crate::model::Layer>>,
    /// <p>Any failures associated with the call.</p>
    pub failures: std::option::Option<std::vec::Vec<crate::model::LayerFailure>>,
}
impl BatchCheckLayerAvailabilityOutput {
    /// <p>A list of image layer objects corresponding to the image layer references in the
    /// request.</p>
    pub fn layers(&self) -> std::option::Option<&[crate::model::Layer]> {
        self.layers.as_deref()
    }
    /// <p>Any failures associated with the call.</p>
    pub fn failures(&self) -> std::option::Option<&[crate::model::LayerFailure]> {
        self.failures.as_deref()
    }
}
impl std::fmt::Debug for BatchCheckLayerAvailabilityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCheckLayerAvailabilityOutput");
        formatter.field("layers", &self.layers);
        formatter.field("failures", &self.failures);
        formatter.finish()
    }
}
/// See [`BatchCheckLayerAvailabilityOutput`](crate::output::BatchCheckLayerAvailabilityOutput)
pub mod batch_check_layer_availability_output {
    /// A builder for [`BatchCheckLayerAvailabilityOutput`](crate::output::BatchCheckLayerAvailabilityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) layers: std::option::Option<std::vec::Vec<crate::model::Layer>>,
        pub(crate) failures: std::option::Option<std::vec::Vec<crate::model::LayerFailure>>,
    }
    impl Builder {
        /// Appends an item to `layers`.
        ///
        /// To override the contents of this collection use [`set_layers`](Self::set_layers).
        ///
        /// <p>A list of image layer objects corresponding to the image layer references in the
        /// request.</p>
        pub fn layers(mut self, input: impl Into<crate::model::Layer>) -> Self {
            let mut v = self.layers.unwrap_or_default();
            v.push(input.into());
            self.layers = Some(v);
            self
        }
        /// <p>A list of image layer objects corresponding to the image layer references in the
        /// request.</p>
        pub fn set_layers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Layer>>,
        ) -> Self {
            self.layers = input;
            self
        }
        /// Appends an item to `failures`.
        ///
        /// To override the contents of this collection use [`set_failures`](Self::set_failures).
        ///
        /// <p>Any failures associated with the call.</p>
        pub fn failures(mut self, input: impl Into<crate::model::LayerFailure>) -> Self {
            let mut v = self.failures.unwrap_or_default();
            v.push(input.into());
            self.failures = Some(v);
            self
        }
        /// <p>Any failures associated with the call.</p>
        pub fn set_failures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LayerFailure>>,
        ) -> Self {
            self.failures = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCheckLayerAvailabilityOutput`](crate::output::BatchCheckLayerAvailabilityOutput)
        pub fn build(self) -> crate::output::BatchCheckLayerAvailabilityOutput {
            crate::output::BatchCheckLayerAvailabilityOutput {
                layers: self.layers,
                failures: self.failures,
            }
        }
    }
}
impl BatchCheckLayerAvailabilityOutput {
    /// Creates a new builder-style object to manufacture [`BatchCheckLayerAvailabilityOutput`](crate::output::BatchCheckLayerAvailabilityOutput)
    pub fn builder() -> crate::output::batch_check_layer_availability_output::Builder {
        crate::output::batch_check_layer_availability_output::Builder::default()
    }
}
