// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchCheckLayerAvailabilityInput`](crate::input::BatchCheckLayerAvailabilityInput)
pub mod batch_check_layer_availability_input {
    /// A builder for [`BatchCheckLayerAvailabilityInput`](crate::input::BatchCheckLayerAvailabilityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) layer_digests: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the public registry that contains the image layers to
        /// check. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the public registry that contains the image layers to
        /// check. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository that is associated with the image layers to check.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that is associated with the image layers to check.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Appends an item to `layer_digests`.
        ///
        /// To override the contents of this collection use [`set_layer_digests`](Self::set_layer_digests).
        ///
        /// <p>The digests of the image layers to check.</p>
        pub fn layer_digests(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.layer_digests.unwrap_or_default();
            v.push(input.into());
            self.layer_digests = Some(v);
            self
        }
        /// <p>The digests of the image layers to check.</p>
        pub fn set_layer_digests(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.layer_digests = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCheckLayerAvailabilityInput`](crate::input::BatchCheckLayerAvailabilityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchCheckLayerAvailabilityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchCheckLayerAvailabilityInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                layer_digests: self.layer_digests,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchCheckLayerAvailabilityInputOperationOutputAlias =
    crate::operation::BatchCheckLayerAvailability;
#[doc(hidden)]
pub type BatchCheckLayerAvailabilityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchCheckLayerAvailabilityInput {
    /// Consumes the builder and constructs an Operation<[`BatchCheckLayerAvailability`](crate::operation::BatchCheckLayerAvailability)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchCheckLayerAvailability,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchCheckLayerAvailabilityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchCheckLayerAvailabilityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchCheckLayerAvailabilityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.BatchCheckLayerAvailability",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_check_layer_availability(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchCheckLayerAvailability::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchCheckLayerAvailability",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchCheckLayerAvailabilityInput`](crate::input::BatchCheckLayerAvailabilityInput)
    pub fn builder() -> crate::input::batch_check_layer_availability_input::Builder {
        crate::input::batch_check_layer_availability_input::Builder::default()
    }
}

/// See [`BatchDeleteImageInput`](crate::input::BatchDeleteImageInput)
pub mod batch_delete_image_input {
    /// A builder for [`BatchDeleteImageInput`](crate::input::BatchDeleteImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_ids: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the registry that contains the image to delete.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the registry that contains the image to delete.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository in a public registry that contains the image to delete.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository in a public registry that contains the image to delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Appends an item to `image_ids`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>A list of image ID references that correspond to images to delete. The format of the
        /// <code>imageIds</code> reference is <code>imageTag=tag</code> or
        /// <code>imageDigest=digest</code>.</p>
        pub fn image_ids(mut self, input: impl Into<crate::model::ImageIdentifier>) -> Self {
            let mut v = self.image_ids.unwrap_or_default();
            v.push(input.into());
            self.image_ids = Some(v);
            self
        }
        /// <p>A list of image ID references that correspond to images to delete. The format of the
        /// <code>imageIds</code> reference is <code>imageTag=tag</code> or
        /// <code>imageDigest=digest</code>.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.image_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteImageInput`](crate::input::BatchDeleteImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDeleteImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDeleteImageInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                image_ids: self.image_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDeleteImageInputOperationOutputAlias = crate::operation::BatchDeleteImage;
#[doc(hidden)]
pub type BatchDeleteImageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchDeleteImageInput {
    /// Consumes the builder and constructs an Operation<[`BatchDeleteImage`](crate::operation::BatchDeleteImage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDeleteImage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDeleteImageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDeleteImageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDeleteImageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.BatchDeleteImage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_delete_image(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDeleteImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDeleteImage",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDeleteImageInput`](crate::input::BatchDeleteImageInput)
    pub fn builder() -> crate::input::batch_delete_image_input::Builder {
        crate::input::batch_delete_image_input::Builder::default()
    }
}

/// See [`CompleteLayerUploadInput`](crate::input::CompleteLayerUploadInput)
pub mod complete_layer_upload_input {
    /// A builder for [`CompleteLayerUploadInput`](crate::input::CompleteLayerUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) layer_digests: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the registry to which to upload layers.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the registry to which to upload layers.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository in a public registry to associate with the image
        /// layer.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository in a public registry to associate with the image
        /// layer.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
        /// associate with the image layer.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
        /// associate with the image layer.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// Appends an item to `layer_digests`.
        ///
        /// To override the contents of this collection use [`set_layer_digests`](Self::set_layer_digests).
        ///
        /// <p>The <code>sha256</code> digest of the image layer.</p>
        pub fn layer_digests(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.layer_digests.unwrap_or_default();
            v.push(input.into());
            self.layer_digests = Some(v);
            self
        }
        /// <p>The <code>sha256</code> digest of the image layer.</p>
        pub fn set_layer_digests(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.layer_digests = input;
            self
        }
        /// Consumes the builder and constructs a [`CompleteLayerUploadInput`](crate::input::CompleteLayerUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CompleteLayerUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CompleteLayerUploadInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                upload_id: self.upload_id,
                layer_digests: self.layer_digests,
            })
        }
    }
}
#[doc(hidden)]
pub type CompleteLayerUploadInputOperationOutputAlias = crate::operation::CompleteLayerUpload;
#[doc(hidden)]
pub type CompleteLayerUploadInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CompleteLayerUploadInput {
    /// Consumes the builder and constructs an Operation<[`CompleteLayerUpload`](crate::operation::CompleteLayerUpload)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CompleteLayerUpload,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CompleteLayerUploadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CompleteLayerUploadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CompleteLayerUploadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.CompleteLayerUpload",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_complete_layer_upload(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CompleteLayerUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CompleteLayerUpload",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CompleteLayerUploadInput`](crate::input::CompleteLayerUploadInput)
    pub fn builder() -> crate::input::complete_layer_upload_input::Builder {
        crate::input::complete_layer_upload_input::Builder::default()
    }
}

/// See [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
pub mod create_repository_input {
    /// A builder for [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) catalog_data: std::option::Option<crate::model::RepositoryCatalogDataInput>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name to use for the repository. This appears publicly in the Amazon ECR Public Gallery.
        /// The repository name may be specified on its own (such as <code>nginx-web-app</code>) or it
        /// can be prepended with a namespace to group the repository into a category (such as
        /// <code>project-a/nginx-web-app</code>).</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name to use for the repository. This appears publicly in the Amazon ECR Public Gallery.
        /// The repository name may be specified on its own (such as <code>nginx-web-app</code>) or it
        /// can be prepended with a namespace to group the repository into a category (such as
        /// <code>project-a/nginx-web-app</code>).</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The details about the repository that are publicly visible in the
        /// Amazon ECR Public Gallery.</p>
        pub fn catalog_data(mut self, input: crate::model::RepositoryCatalogDataInput) -> Self {
            self.catalog_data = Some(input);
            self
        }
        /// <p>The details about the repository that are publicly visible in the
        /// Amazon ECR Public Gallery.</p>
        pub fn set_catalog_data(
            mut self,
            input: std::option::Option<crate::model::RepositoryCatalogDataInput>,
        ) -> Self {
            self.catalog_data = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the repository to help you categorize and organize them.
        /// Each tag consists of a key and an optional value, both of which you define.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The metadata that you apply to the repository to help you categorize and organize them.
        /// Each tag consists of a key and an optional value, both of which you define.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRepositoryInput {
                repository_name: self.repository_name,
                catalog_data: self.catalog_data,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRepositoryInputOperationOutputAlias = crate::operation::CreateRepository;
#[doc(hidden)]
pub type CreateRepositoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`CreateRepository`](crate::operation::CreateRepository)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRepository,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.CreateRepository",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_repository(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRepository",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
    pub fn builder() -> crate::input::create_repository_input::Builder {
        crate::input::create_repository_input::Builder::default()
    }
}

/// See [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
pub mod delete_repository_input {
    /// A builder for [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) force: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the public registry that contains the repository to
        /// delete. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the public registry that contains the repository to
        /// delete. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository to delete.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p> If a repository contains images, forces the deletion.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p> If a repository contains images, forces the deletion.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRepositoryInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                force: self.force.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRepositoryInputOperationOutputAlias = crate::operation::DeleteRepository;
#[doc(hidden)]
pub type DeleteRepositoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRepository`](crate::operation::DeleteRepository)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRepository,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.DeleteRepository",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_repository(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRepository",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
    pub fn builder() -> crate::input::delete_repository_input::Builder {
        crate::input::delete_repository_input::Builder::default()
    }
}

/// See [`DeleteRepositoryPolicyInput`](crate::input::DeleteRepositoryPolicyInput)
pub mod delete_repository_policy_input {
    /// A builder for [`DeleteRepositoryPolicyInput`](crate::input::DeleteRepositoryPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the public registry that contains the repository
        /// policy to delete. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the public registry that contains the repository
        /// policy to delete. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository that is associated with the repository policy to
        /// delete.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that is associated with the repository policy to
        /// delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRepositoryPolicyInput`](crate::input::DeleteRepositoryPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRepositoryPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRepositoryPolicyInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRepositoryPolicyInputOperationOutputAlias = crate::operation::DeleteRepositoryPolicy;
#[doc(hidden)]
pub type DeleteRepositoryPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRepositoryPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRepositoryPolicy`](crate::operation::DeleteRepositoryPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRepositoryPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRepositoryPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRepositoryPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRepositoryPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.DeleteRepositoryPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_repository_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRepositoryPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRepositoryPolicy",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryPolicyInput`](crate::input::DeleteRepositoryPolicyInput)
    pub fn builder() -> crate::input::delete_repository_policy_input::Builder {
        crate::input::delete_repository_policy_input::Builder::default()
    }
}

/// See [`DescribeImagesInput`](crate::input::DescribeImagesInput)
pub mod describe_images_input {
    /// A builder for [`DescribeImagesInput`](crate::input::DescribeImagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_ids: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the public registry that contains the repository in
        /// which to describe images. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the public registry that contains the repository in
        /// which to describe images. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository that contains the images to describe.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository that contains the images to describe.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Appends an item to `image_ids`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>The list of image IDs for the requested repository.</p>
        pub fn image_ids(mut self, input: impl Into<crate::model::ImageIdentifier>) -> Self {
            let mut v = self.image_ids.unwrap_or_default();
            v.push(input.into());
            self.image_ids = Some(v);
            self
        }
        /// <p>The list of image IDs for the requested repository.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.image_ids = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeImages</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be used
        /// when you specify images with <code>imageIds</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeImages</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be used
        /// when you specify images with <code>imageIds</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeImages</code> in
        /// paginated output. When this parameter is used, <code>DescribeImages</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>DescribeImages</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 1000. If this parameter is not
        /// used, then <code>DescribeImages</code> returns up to 100 results and a
        /// <code>nextToken</code> value, if applicable. This option cannot be used when you specify
        /// images with <code>imageIds</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeImages</code> in
        /// paginated output. When this parameter is used, <code>DescribeImages</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>DescribeImages</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 1000. If this parameter is not
        /// used, then <code>DescribeImages</code> returns up to 100 results and a
        /// <code>nextToken</code> value, if applicable. This option cannot be used when you specify
        /// images with <code>imageIds</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImagesInput`](crate::input::DescribeImagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeImagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeImagesInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                image_ids: self.image_ids,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeImagesInputOperationOutputAlias = crate::operation::DescribeImages;
#[doc(hidden)]
pub type DescribeImagesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeImagesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeImages`](crate::operation::DescribeImages)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeImages,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeImagesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeImagesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeImagesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.DescribeImages",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_images(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeImages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeImages",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeImagesInput`](crate::input::DescribeImagesInput)
    pub fn builder() -> crate::input::describe_images_input::Builder {
        crate::input::describe_images_input::Builder::default()
    }
}

/// See [`DescribeImageTagsInput`](crate::input::DescribeImageTagsInput)
pub mod describe_image_tags_input {
    /// A builder for [`DescribeImageTagsInput`](crate::input::DescribeImageTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the public registry that contains the repository in
        /// which to describe images. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the public registry that contains the repository in
        /// which to describe images. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository that contains the image tag details to describe.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that contains the image tag details to describe.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeImageTags</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be used
        /// when you specify images with <code>imageIds</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeImageTags</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be used
        /// when you specify images with <code>imageIds</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeImageTags</code> in
        /// paginated output. When this parameter is used, <code>DescribeImageTags</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>DescribeImageTags</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 1000. If this parameter
        /// is not used, then <code>DescribeImageTags</code> returns up to 100
        /// results and a <code>nextToken</code> value, if applicable. This option cannot be used when
        /// you specify images with <code>imageIds</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeImageTags</code> in
        /// paginated output. When this parameter is used, <code>DescribeImageTags</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>DescribeImageTags</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 1000. If this parameter
        /// is not used, then <code>DescribeImageTags</code> returns up to 100
        /// results and a <code>nextToken</code> value, if applicable. This option cannot be used when
        /// you specify images with <code>imageIds</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImageTagsInput`](crate::input::DescribeImageTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeImageTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeImageTagsInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeImageTagsInputOperationOutputAlias = crate::operation::DescribeImageTags;
#[doc(hidden)]
pub type DescribeImageTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeImageTagsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeImageTags`](crate::operation::DescribeImageTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeImageTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeImageTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeImageTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeImageTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.DescribeImageTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_image_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeImageTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeImageTags",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeImageTagsInput`](crate::input::DescribeImageTagsInput)
    pub fn builder() -> crate::input::describe_image_tags_input::Builder {
        crate::input::describe_image_tags_input::Builder::default()
    }
}

/// See [`DescribeRegistriesInput`](crate::input::DescribeRegistriesInput)
pub mod describe_registries_input {
    /// A builder for [`DescribeRegistriesInput`](crate::input::DescribeRegistriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeRegistries</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeRegistries</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeRegistries</code> in
        /// paginated output. When this parameter is used, <code>DescribeRegistries</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>DescribeRegistries</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 1000. If this parameter
        /// is not used, then <code>DescribeRegistries</code> returns up to 100
        /// results and a <code>nextToken</code> value, if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeRegistries</code> in
        /// paginated output. When this parameter is used, <code>DescribeRegistries</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>DescribeRegistries</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 1000. If this parameter
        /// is not used, then <code>DescribeRegistries</code> returns up to 100
        /// results and a <code>nextToken</code> value, if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRegistriesInput`](crate::input::DescribeRegistriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRegistriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRegistriesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRegistriesInputOperationOutputAlias = crate::operation::DescribeRegistries;
#[doc(hidden)]
pub type DescribeRegistriesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRegistriesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRegistries`](crate::operation::DescribeRegistries)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRegistries,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRegistriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRegistriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRegistriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.DescribeRegistries",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_registries(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRegistries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRegistries",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRegistriesInput`](crate::input::DescribeRegistriesInput)
    pub fn builder() -> crate::input::describe_registries_input::Builder {
        crate::input::describe_registries_input::Builder::default()
    }
}

/// See [`DescribeRepositoriesInput`](crate::input::DescribeRepositoriesInput)
pub mod describe_repositories_input {
    /// A builder for [`DescribeRepositoriesInput`](crate::input::DescribeRepositoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the registry that contains the repositories to be
        /// described. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the registry that contains the repositories to be
        /// described. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// Appends an item to `repository_names`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p>A list of repositories to describe. If this parameter is omitted, then all repositories
        /// in a registry are described.</p>
        pub fn repository_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.repository_names.unwrap_or_default();
            v.push(input.into());
            self.repository_names = Some(v);
            self
        }
        /// <p>A list of repositories to describe. If this parameter is omitted, then all repositories
        /// in a registry are described.</p>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.repository_names = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeRepositories</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be used
        /// when you specify repositories with <code>repositoryNames</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeRepositories</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be used
        /// when you specify repositories with <code>repositoryNames</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeRepositories</code>
        /// in paginated output. When this parameter is used, <code>DescribeRepositories</code> only
        /// returns <code>maxResults</code> results in a single page along with a
        /// <code>nextToken</code> response element. The remaining results of the initial request
        /// can be seen by sending another <code>DescribeRepositories</code> request with the returned
        /// <code>nextToken</code> value. This value can be between 1 and
        /// 1000. If this parameter is not used, then <code>DescribeRepositories</code>
        /// returns up to 100 results and a <code>nextToken</code> value, if
        /// applicable. This option cannot be used when you specify repositories with
        /// <code>repositoryNames</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeRepositories</code>
        /// in paginated output. When this parameter is used, <code>DescribeRepositories</code> only
        /// returns <code>maxResults</code> results in a single page along with a
        /// <code>nextToken</code> response element. The remaining results of the initial request
        /// can be seen by sending another <code>DescribeRepositories</code> request with the returned
        /// <code>nextToken</code> value. This value can be between 1 and
        /// 1000. If this parameter is not used, then <code>DescribeRepositories</code>
        /// returns up to 100 results and a <code>nextToken</code> value, if
        /// applicable. This option cannot be used when you specify repositories with
        /// <code>repositoryNames</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRepositoriesInput`](crate::input::DescribeRepositoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRepositoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRepositoriesInput {
                registry_id: self.registry_id,
                repository_names: self.repository_names,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRepositoriesInputOperationOutputAlias = crate::operation::DescribeRepositories;
#[doc(hidden)]
pub type DescribeRepositoriesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRepositoriesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRepositories`](crate::operation::DescribeRepositories)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRepositories,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRepositoriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRepositoriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRepositoriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.DescribeRepositories",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_repositories(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRepositories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRepositories",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRepositoriesInput`](crate::input::DescribeRepositoriesInput)
    pub fn builder() -> crate::input::describe_repositories_input::Builder {
        crate::input::describe_repositories_input::Builder::default()
    }
}

/// See [`GetAuthorizationTokenInput`](crate::input::GetAuthorizationTokenInput)
pub mod get_authorization_token_input {
    /// A builder for [`GetAuthorizationTokenInput`](crate::input::GetAuthorizationTokenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetAuthorizationTokenInput`](crate::input::GetAuthorizationTokenInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAuthorizationTokenInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAuthorizationTokenInput {})
        }
    }
}
#[doc(hidden)]
pub type GetAuthorizationTokenInputOperationOutputAlias = crate::operation::GetAuthorizationToken;
#[doc(hidden)]
pub type GetAuthorizationTokenInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAuthorizationTokenInput {
    /// Consumes the builder and constructs an Operation<[`GetAuthorizationToken`](crate::operation::GetAuthorizationToken)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAuthorizationToken,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAuthorizationTokenInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAuthorizationTokenInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAuthorizationTokenInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.GetAuthorizationToken",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_authorization_token(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAuthorizationToken::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAuthorizationToken",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAuthorizationTokenInput`](crate::input::GetAuthorizationTokenInput)
    pub fn builder() -> crate::input::get_authorization_token_input::Builder {
        crate::input::get_authorization_token_input::Builder::default()
    }
}

/// See [`GetRegistryCatalogDataInput`](crate::input::GetRegistryCatalogDataInput)
pub mod get_registry_catalog_data_input {
    /// A builder for [`GetRegistryCatalogDataInput`](crate::input::GetRegistryCatalogDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetRegistryCatalogDataInput`](crate::input::GetRegistryCatalogDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRegistryCatalogDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRegistryCatalogDataInput {})
        }
    }
}
#[doc(hidden)]
pub type GetRegistryCatalogDataInputOperationOutputAlias = crate::operation::GetRegistryCatalogData;
#[doc(hidden)]
pub type GetRegistryCatalogDataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRegistryCatalogDataInput {
    /// Consumes the builder and constructs an Operation<[`GetRegistryCatalogData`](crate::operation::GetRegistryCatalogData)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRegistryCatalogData,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRegistryCatalogDataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRegistryCatalogDataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRegistryCatalogDataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.GetRegistryCatalogData",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_registry_catalog_data(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRegistryCatalogData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRegistryCatalogData",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRegistryCatalogDataInput`](crate::input::GetRegistryCatalogDataInput)
    pub fn builder() -> crate::input::get_registry_catalog_data_input::Builder {
        crate::input::get_registry_catalog_data_input::Builder::default()
    }
}

/// See [`GetRepositoryCatalogDataInput`](crate::input::GetRepositoryCatalogDataInput)
pub mod get_repository_catalog_data_input {
    /// A builder for [`GetRepositoryCatalogDataInput`](crate::input::GetRepositoryCatalogDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the registry that contains the repositories to be
        /// described. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the registry that contains the repositories to be
        /// described. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository to retrieve the catalog metadata for.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to retrieve the catalog metadata for.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRepositoryCatalogDataInput`](crate::input::GetRepositoryCatalogDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRepositoryCatalogDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRepositoryCatalogDataInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRepositoryCatalogDataInputOperationOutputAlias =
    crate::operation::GetRepositoryCatalogData;
#[doc(hidden)]
pub type GetRepositoryCatalogDataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRepositoryCatalogDataInput {
    /// Consumes the builder and constructs an Operation<[`GetRepositoryCatalogData`](crate::operation::GetRepositoryCatalogData)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRepositoryCatalogData,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRepositoryCatalogDataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRepositoryCatalogDataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRepositoryCatalogDataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.GetRepositoryCatalogData",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_repository_catalog_data(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRepositoryCatalogData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRepositoryCatalogData",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRepositoryCatalogDataInput`](crate::input::GetRepositoryCatalogDataInput)
    pub fn builder() -> crate::input::get_repository_catalog_data_input::Builder {
        crate::input::get_repository_catalog_data_input::Builder::default()
    }
}

/// See [`GetRepositoryPolicyInput`](crate::input::GetRepositoryPolicyInput)
pub mod get_repository_policy_input {
    /// A builder for [`GetRepositoryPolicyInput`](crate::input::GetRepositoryPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the public registry that contains the repository.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the public registry that contains the repository.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository with the policy to retrieve.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository with the policy to retrieve.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRepositoryPolicyInput`](crate::input::GetRepositoryPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRepositoryPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRepositoryPolicyInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRepositoryPolicyInputOperationOutputAlias = crate::operation::GetRepositoryPolicy;
#[doc(hidden)]
pub type GetRepositoryPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRepositoryPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetRepositoryPolicy`](crate::operation::GetRepositoryPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRepositoryPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRepositoryPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRepositoryPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRepositoryPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.GetRepositoryPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_repository_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRepositoryPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRepositoryPolicy",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRepositoryPolicyInput`](crate::input::GetRepositoryPolicyInput)
    pub fn builder() -> crate::input::get_repository_policy_input::Builder {
        crate::input::get_repository_policy_input::Builder::default()
    }
}

/// See [`InitiateLayerUploadInput`](crate::input::InitiateLayerUploadInput)
pub mod initiate_layer_upload_input {
    /// A builder for [`InitiateLayerUploadInput`](crate::input::InitiateLayerUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the registry to which you intend to upload layers.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the registry to which you intend to upload layers.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository to which you intend to upload layers.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to which you intend to upload layers.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`InitiateLayerUploadInput`](crate::input::InitiateLayerUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InitiateLayerUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InitiateLayerUploadInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
            })
        }
    }
}
#[doc(hidden)]
pub type InitiateLayerUploadInputOperationOutputAlias = crate::operation::InitiateLayerUpload;
#[doc(hidden)]
pub type InitiateLayerUploadInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl InitiateLayerUploadInput {
    /// Consumes the builder and constructs an Operation<[`InitiateLayerUpload`](crate::operation::InitiateLayerUpload)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InitiateLayerUpload,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::InitiateLayerUploadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::InitiateLayerUploadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::InitiateLayerUploadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.InitiateLayerUpload",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_initiate_layer_upload(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InitiateLayerUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InitiateLayerUpload",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`InitiateLayerUploadInput`](crate::input::InitiateLayerUploadInput)
    pub fn builder() -> crate::input::initiate_layer_upload_input::Builder {
        crate::input::initiate_layer_upload_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the
        /// supported resource is an Amazon ECR Public repository.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the
        /// supported resource is an Amazon ECR Public repository.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutImageInput`](crate::input::PutImageInput)
pub mod put_image_input {
    /// A builder for [`PutImageInput`](crate::input::PutImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_manifest: std::option::Option<std::string::String>,
        pub(crate) image_manifest_media_type: std::option::Option<std::string::String>,
        pub(crate) image_tag: std::option::Option<std::string::String>,
        pub(crate) image_digest: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the public registry that contains the repository in
        /// which to put the image. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the public registry that contains the repository in
        /// which to put the image. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository in which to put the image.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository in which to put the image.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The image manifest corresponding to the image to be uploaded.</p>
        pub fn image_manifest(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_manifest = Some(input.into());
            self
        }
        /// <p>The image manifest corresponding to the image to be uploaded.</p>
        pub fn set_image_manifest(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_manifest = input;
            self
        }
        /// <p>The media type of the image manifest. If you push an image manifest that does not
        /// contain the <code>mediaType</code> field, you must specify the
        /// <code>imageManifestMediaType</code> in the request.</p>
        pub fn image_manifest_media_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_manifest_media_type = Some(input.into());
            self
        }
        /// <p>The media type of the image manifest. If you push an image manifest that does not
        /// contain the <code>mediaType</code> field, you must specify the
        /// <code>imageManifestMediaType</code> in the request.</p>
        pub fn set_image_manifest_media_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_manifest_media_type = input;
            self
        }
        /// <p>The tag to associate with the image. This parameter is required for images that use the
        /// Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.</p>
        pub fn image_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_tag = Some(input.into());
            self
        }
        /// <p>The tag to associate with the image. This parameter is required for images that use the
        /// Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.</p>
        pub fn set_image_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_tag = input;
            self
        }
        /// <p>The image digest of the image manifest corresponding to the image.</p>
        pub fn image_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_digest = Some(input.into());
            self
        }
        /// <p>The image digest of the image manifest corresponding to the image.</p>
        pub fn set_image_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_digest = input;
            self
        }
        /// Consumes the builder and constructs a [`PutImageInput`](crate::input::PutImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::PutImageInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::PutImageInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                image_manifest: self.image_manifest,
                image_manifest_media_type: self.image_manifest_media_type,
                image_tag: self.image_tag,
                image_digest: self.image_digest,
            })
        }
    }
}
#[doc(hidden)]
pub type PutImageInputOperationOutputAlias = crate::operation::PutImage;
#[doc(hidden)]
pub type PutImageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutImageInput {
    /// Consumes the builder and constructs an Operation<[`PutImage`](crate::operation::PutImage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutImage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutImageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutImageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutImageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.PutImage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_image(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::PutImage::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "PutImage",
                    "ecrpublic",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutImageInput`](crate::input::PutImageInput)
    pub fn builder() -> crate::input::put_image_input::Builder {
        crate::input::put_image_input::Builder::default()
    }
}

/// See [`PutRegistryCatalogDataInput`](crate::input::PutRegistryCatalogDataInput)
pub mod put_registry_catalog_data_input {
    /// A builder for [`PutRegistryCatalogDataInput`](crate::input::PutRegistryCatalogDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) display_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The display name for a public registry. The display name is shown as the repository
        /// author in the Amazon ECR Public Gallery.</p>
        /// <note>
        /// <p>The registry display name is only publicly visible in the Amazon ECR Public Gallery for
        /// verified accounts.</p>
        /// </note>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The display name for a public registry. The display name is shown as the repository
        /// author in the Amazon ECR Public Gallery.</p>
        /// <note>
        /// <p>The registry display name is only publicly visible in the Amazon ECR Public Gallery for
        /// verified accounts.</p>
        /// </note>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRegistryCatalogDataInput`](crate::input::PutRegistryCatalogDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutRegistryCatalogDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutRegistryCatalogDataInput {
                display_name: self.display_name,
            })
        }
    }
}
#[doc(hidden)]
pub type PutRegistryCatalogDataInputOperationOutputAlias = crate::operation::PutRegistryCatalogData;
#[doc(hidden)]
pub type PutRegistryCatalogDataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutRegistryCatalogDataInput {
    /// Consumes the builder and constructs an Operation<[`PutRegistryCatalogData`](crate::operation::PutRegistryCatalogData)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutRegistryCatalogData,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutRegistryCatalogDataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutRegistryCatalogDataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutRegistryCatalogDataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.PutRegistryCatalogData",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_registry_catalog_data(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutRegistryCatalogData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutRegistryCatalogData",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutRegistryCatalogDataInput`](crate::input::PutRegistryCatalogDataInput)
    pub fn builder() -> crate::input::put_registry_catalog_data_input::Builder {
        crate::input::put_registry_catalog_data_input::Builder::default()
    }
}

/// See [`PutRepositoryCatalogDataInput`](crate::input::PutRepositoryCatalogDataInput)
pub mod put_repository_catalog_data_input {
    /// A builder for [`PutRepositoryCatalogDataInput`](crate::input::PutRepositoryCatalogDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) catalog_data: std::option::Option<crate::model::RepositoryCatalogDataInput>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the public registry the repository is in.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the public registry the repository is in.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository to create or update the catalog data for.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to create or update the catalog data for.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>An object containing the catalog data for a repository. This data is publicly visible in
        /// the Amazon ECR Public Gallery.</p>
        pub fn catalog_data(mut self, input: crate::model::RepositoryCatalogDataInput) -> Self {
            self.catalog_data = Some(input);
            self
        }
        /// <p>An object containing the catalog data for a repository. This data is publicly visible in
        /// the Amazon ECR Public Gallery.</p>
        pub fn set_catalog_data(
            mut self,
            input: std::option::Option<crate::model::RepositoryCatalogDataInput>,
        ) -> Self {
            self.catalog_data = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRepositoryCatalogDataInput`](crate::input::PutRepositoryCatalogDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutRepositoryCatalogDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutRepositoryCatalogDataInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                catalog_data: self.catalog_data,
            })
        }
    }
}
#[doc(hidden)]
pub type PutRepositoryCatalogDataInputOperationOutputAlias =
    crate::operation::PutRepositoryCatalogData;
#[doc(hidden)]
pub type PutRepositoryCatalogDataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutRepositoryCatalogDataInput {
    /// Consumes the builder and constructs an Operation<[`PutRepositoryCatalogData`](crate::operation::PutRepositoryCatalogData)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutRepositoryCatalogData,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutRepositoryCatalogDataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutRepositoryCatalogDataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutRepositoryCatalogDataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.PutRepositoryCatalogData",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_repository_catalog_data(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutRepositoryCatalogData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutRepositoryCatalogData",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutRepositoryCatalogDataInput`](crate::input::PutRepositoryCatalogDataInput)
    pub fn builder() -> crate::input::put_repository_catalog_data_input::Builder {
        crate::input::put_repository_catalog_data_input::Builder::default()
    }
}

/// See [`SetRepositoryPolicyInput`](crate::input::SetRepositoryPolicyInput)
pub mod set_repository_policy_input {
    /// A builder for [`SetRepositoryPolicyInput`](crate::input::SetRepositoryPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) policy_text: std::option::Option<std::string::String>,
        pub(crate) force: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository to receive the policy.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to receive the policy.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The JSON repository policy text to apply to the repository. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR Repository
        /// Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
        pub fn policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_text = Some(input.into());
            self
        }
        /// <p>The JSON repository policy text to apply to the repository. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR Repository
        /// Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
        pub fn set_policy_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_text = input;
            self
        }
        /// <p>If the policy you are attempting to set on a repository policy would prevent you from
        /// setting another policy in the future, you must force the <a>SetRepositoryPolicy</a> operation. This is intended to prevent accidental
        /// repository lock outs.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p>If the policy you are attempting to set on a repository policy would prevent you from
        /// setting another policy in the future, you must force the <a>SetRepositoryPolicy</a> operation. This is intended to prevent accidental
        /// repository lock outs.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// Consumes the builder and constructs a [`SetRepositoryPolicyInput`](crate::input::SetRepositoryPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetRepositoryPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetRepositoryPolicyInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                policy_text: self.policy_text,
                force: self.force.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type SetRepositoryPolicyInputOperationOutputAlias = crate::operation::SetRepositoryPolicy;
#[doc(hidden)]
pub type SetRepositoryPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetRepositoryPolicyInput {
    /// Consumes the builder and constructs an Operation<[`SetRepositoryPolicy`](crate::operation::SetRepositoryPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetRepositoryPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetRepositoryPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetRepositoryPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetRepositoryPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.SetRepositoryPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_repository_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetRepositoryPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetRepositoryPolicy",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetRepositoryPolicyInput`](crate::input::SetRepositoryPolicyInput)
    pub fn builder() -> crate::input::set_repository_policy_input::Builder {
        crate::input::set_repository_policy_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to which to add tags. Currently, the
        /// supported resource is an Amazon ECR Public repository.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which to add tags. Currently, the
        /// supported resource is an Amazon ECR Public repository.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource from which to delete tags. Currently, the supported
        /// resource is an Amazon ECR Public repository.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which to delete tags. Currently, the supported
        /// resource is an Amazon ECR Public repository.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UploadLayerPartInput`](crate::input::UploadLayerPartInput)
pub mod upload_layer_part_input {
    /// A builder for [`UploadLayerPartInput`](crate::input::UploadLayerPartInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) part_first_byte: std::option::Option<i64>,
        pub(crate) part_last_byte: std::option::Option<i64>,
        pub(crate) layer_part_blob: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the registry to which you are uploading layer parts.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the registry to which you are uploading layer parts.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository to which you are uploading layer parts.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to which you are uploading layer parts.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
        /// associate with the layer part upload.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
        /// associate with the layer part upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>The position of the first byte of the layer part witin the overall image layer.</p>
        pub fn part_first_byte(mut self, input: i64) -> Self {
            self.part_first_byte = Some(input);
            self
        }
        /// <p>The position of the first byte of the layer part witin the overall image layer.</p>
        pub fn set_part_first_byte(mut self, input: std::option::Option<i64>) -> Self {
            self.part_first_byte = input;
            self
        }
        /// <p>The position of the last byte of the layer part within the overall image layer.</p>
        pub fn part_last_byte(mut self, input: i64) -> Self {
            self.part_last_byte = Some(input);
            self
        }
        /// <p>The position of the last byte of the layer part within the overall image layer.</p>
        pub fn set_part_last_byte(mut self, input: std::option::Option<i64>) -> Self {
            self.part_last_byte = input;
            self
        }
        /// <p>The base64-encoded layer part payload.</p>
        pub fn layer_part_blob(mut self, input: aws_smithy_types::Blob) -> Self {
            self.layer_part_blob = Some(input);
            self
        }
        /// <p>The base64-encoded layer part payload.</p>
        pub fn set_layer_part_blob(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.layer_part_blob = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadLayerPartInput`](crate::input::UploadLayerPartInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UploadLayerPartInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UploadLayerPartInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                upload_id: self.upload_id,
                part_first_byte: self.part_first_byte,
                part_last_byte: self.part_last_byte,
                layer_part_blob: self.layer_part_blob,
            })
        }
    }
}
#[doc(hidden)]
pub type UploadLayerPartInputOperationOutputAlias = crate::operation::UploadLayerPart;
#[doc(hidden)]
pub type UploadLayerPartInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UploadLayerPartInput {
    /// Consumes the builder and constructs an Operation<[`UploadLayerPart`](crate::operation::UploadLayerPart)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UploadLayerPart,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UploadLayerPartInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UploadLayerPartInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UploadLayerPartInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SpencerFrontendService.UploadLayerPart",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_upload_layer_part(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UploadLayerPart::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UploadLayerPart",
            "ecrpublic",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UploadLayerPartInput`](crate::input::UploadLayerPartInput)
    pub fn builder() -> crate::input::upload_layer_part_input::Builder {
        crate::input::upload_layer_part_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadLayerPartInput {
    /// <p>The AWS account ID associated with the registry to which you are uploading layer parts.
    /// If you do not specify a registry, the default public registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository to which you are uploading layer parts.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
    /// associate with the layer part upload.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>The position of the first byte of the layer part witin the overall image layer.</p>
    pub part_first_byte: std::option::Option<i64>,
    /// <p>The position of the last byte of the layer part within the overall image layer.</p>
    pub part_last_byte: std::option::Option<i64>,
    /// <p>The base64-encoded layer part payload.</p>
    pub layer_part_blob: std::option::Option<aws_smithy_types::Blob>,
}
impl UploadLayerPartInput {
    /// <p>The AWS account ID associated with the registry to which you are uploading layer parts.
    /// If you do not specify a registry, the default public registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository to which you are uploading layer parts.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
    /// associate with the layer part upload.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>The position of the first byte of the layer part witin the overall image layer.</p>
    pub fn part_first_byte(&self) -> std::option::Option<i64> {
        self.part_first_byte
    }
    /// <p>The position of the last byte of the layer part within the overall image layer.</p>
    pub fn part_last_byte(&self) -> std::option::Option<i64> {
        self.part_last_byte
    }
    /// <p>The base64-encoded layer part payload.</p>
    pub fn layer_part_blob(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.layer_part_blob.as_ref()
    }
}
impl std::fmt::Debug for UploadLayerPartInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadLayerPartInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("upload_id", &self.upload_id);
        formatter.field("part_first_byte", &self.part_first_byte);
        formatter.field("part_last_byte", &self.part_last_byte);
        formatter.field("layer_part_blob", &self.layer_part_blob);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource from which to delete tags. Currently, the supported
    /// resource is an Amazon ECR Public repository.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The keys of the tags to be removed.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource from which to delete tags. Currently, the supported
    /// resource is an Amazon ECR Public repository.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The keys of the tags to be removed.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to which to add tags. Currently, the
    /// supported resource is an Amazon ECR Public repository.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to add to the resource. A tag is an array of key-value pairs.
    /// Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to which to add tags. Currently, the
    /// supported resource is an Amazon ECR Public repository.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags to add to the resource. A tag is an array of key-value pairs.
    /// Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetRepositoryPolicyInput {
    /// <p>The AWS account ID associated with the registry that contains the repository.
    /// If you do not specify a registry, the default public registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository to receive the policy.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The JSON repository policy text to apply to the repository. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR Repository
    /// Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    pub policy_text: std::option::Option<std::string::String>,
    /// <p>If the policy you are attempting to set on a repository policy would prevent you from
    /// setting another policy in the future, you must force the <a>SetRepositoryPolicy</a> operation. This is intended to prevent accidental
    /// repository lock outs.</p>
    pub force: bool,
}
impl SetRepositoryPolicyInput {
    /// <p>The AWS account ID associated with the registry that contains the repository.
    /// If you do not specify a registry, the default public registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository to receive the policy.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The JSON repository policy text to apply to the repository. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR Repository
    /// Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    pub fn policy_text(&self) -> std::option::Option<&str> {
        self.policy_text.as_deref()
    }
    /// <p>If the policy you are attempting to set on a repository policy would prevent you from
    /// setting another policy in the future, you must force the <a>SetRepositoryPolicy</a> operation. This is intended to prevent accidental
    /// repository lock outs.</p>
    pub fn force(&self) -> bool {
        self.force
    }
}
impl std::fmt::Debug for SetRepositoryPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetRepositoryPolicyInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("policy_text", &self.policy_text);
        formatter.field("force", &self.force);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRepositoryCatalogDataInput {
    /// <p>The AWS account ID associated with the public registry the repository is in.
    /// If you do not specify a registry, the default public registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository to create or update the catalog data for.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>An object containing the catalog data for a repository. This data is publicly visible in
    /// the Amazon ECR Public Gallery.</p>
    pub catalog_data: std::option::Option<crate::model::RepositoryCatalogDataInput>,
}
impl PutRepositoryCatalogDataInput {
    /// <p>The AWS account ID associated with the public registry the repository is in.
    /// If you do not specify a registry, the default public registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository to create or update the catalog data for.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>An object containing the catalog data for a repository. This data is publicly visible in
    /// the Amazon ECR Public Gallery.</p>
    pub fn catalog_data(&self) -> std::option::Option<&crate::model::RepositoryCatalogDataInput> {
        self.catalog_data.as_ref()
    }
}
impl std::fmt::Debug for PutRepositoryCatalogDataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRepositoryCatalogDataInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("catalog_data", &self.catalog_data);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRegistryCatalogDataInput {
    /// <p>The display name for a public registry. The display name is shown as the repository
    /// author in the Amazon ECR Public Gallery.</p>
    /// <note>
    /// <p>The registry display name is only publicly visible in the Amazon ECR Public Gallery for
    /// verified accounts.</p>
    /// </note>
    pub display_name: std::option::Option<std::string::String>,
}
impl PutRegistryCatalogDataInput {
    /// <p>The display name for a public registry. The display name is shown as the repository
    /// author in the Amazon ECR Public Gallery.</p>
    /// <note>
    /// <p>The registry display name is only publicly visible in the Amazon ECR Public Gallery for
    /// verified accounts.</p>
    /// </note>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
}
impl std::fmt::Debug for PutRegistryCatalogDataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRegistryCatalogDataInput");
        formatter.field("display_name", &self.display_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutImageInput {
    /// <p>The AWS account ID associated with the public registry that contains the repository in
    /// which to put the image. If you do not specify a registry, the default public registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository in which to put the image.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The image manifest corresponding to the image to be uploaded.</p>
    pub image_manifest: std::option::Option<std::string::String>,
    /// <p>The media type of the image manifest. If you push an image manifest that does not
    /// contain the <code>mediaType</code> field, you must specify the
    /// <code>imageManifestMediaType</code> in the request.</p>
    pub image_manifest_media_type: std::option::Option<std::string::String>,
    /// <p>The tag to associate with the image. This parameter is required for images that use the
    /// Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.</p>
    pub image_tag: std::option::Option<std::string::String>,
    /// <p>The image digest of the image manifest corresponding to the image.</p>
    pub image_digest: std::option::Option<std::string::String>,
}
impl PutImageInput {
    /// <p>The AWS account ID associated with the public registry that contains the repository in
    /// which to put the image. If you do not specify a registry, the default public registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository in which to put the image.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The image manifest corresponding to the image to be uploaded.</p>
    pub fn image_manifest(&self) -> std::option::Option<&str> {
        self.image_manifest.as_deref()
    }
    /// <p>The media type of the image manifest. If you push an image manifest that does not
    /// contain the <code>mediaType</code> field, you must specify the
    /// <code>imageManifestMediaType</code> in the request.</p>
    pub fn image_manifest_media_type(&self) -> std::option::Option<&str> {
        self.image_manifest_media_type.as_deref()
    }
    /// <p>The tag to associate with the image. This parameter is required for images that use the
    /// Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.</p>
    pub fn image_tag(&self) -> std::option::Option<&str> {
        self.image_tag.as_deref()
    }
    /// <p>The image digest of the image manifest corresponding to the image.</p>
    pub fn image_digest(&self) -> std::option::Option<&str> {
        self.image_digest.as_deref()
    }
}
impl std::fmt::Debug for PutImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutImageInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_manifest", &self.image_manifest);
        formatter.field("image_manifest_media_type", &self.image_manifest_media_type);
        formatter.field("image_tag", &self.image_tag);
        formatter.field("image_digest", &self.image_digest);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the
    /// supported resource is an Amazon ECR Public repository.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the
    /// supported resource is an Amazon ECR Public repository.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitiateLayerUploadInput {
    /// <p>The AWS account ID associated with the registry to which you intend to upload layers.
    /// If you do not specify a registry, the default public registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository to which you intend to upload layers.</p>
    pub repository_name: std::option::Option<std::string::String>,
}
impl InitiateLayerUploadInput {
    /// <p>The AWS account ID associated with the registry to which you intend to upload layers.
    /// If you do not specify a registry, the default public registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository to which you intend to upload layers.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
}
impl std::fmt::Debug for InitiateLayerUploadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitiateLayerUploadInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRepositoryPolicyInput {
    /// <p>The AWS account ID associated with the public registry that contains the repository.
    /// If you do not specify a registry, the default public registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository with the policy to retrieve.</p>
    pub repository_name: std::option::Option<std::string::String>,
}
impl GetRepositoryPolicyInput {
    /// <p>The AWS account ID associated with the public registry that contains the repository.
    /// If you do not specify a registry, the default public registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository with the policy to retrieve.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
}
impl std::fmt::Debug for GetRepositoryPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRepositoryPolicyInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRepositoryCatalogDataInput {
    /// <p>The AWS account ID associated with the registry that contains the repositories to be
    /// described. If you do not specify a registry, the default public registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository to retrieve the catalog metadata for.</p>
    pub repository_name: std::option::Option<std::string::String>,
}
impl GetRepositoryCatalogDataInput {
    /// <p>The AWS account ID associated with the registry that contains the repositories to be
    /// described. If you do not specify a registry, the default public registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository to retrieve the catalog metadata for.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
}
impl std::fmt::Debug for GetRepositoryCatalogDataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRepositoryCatalogDataInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRegistryCatalogDataInput {}
impl std::fmt::Debug for GetRegistryCatalogDataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRegistryCatalogDataInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAuthorizationTokenInput {}
impl std::fmt::Debug for GetAuthorizationTokenInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAuthorizationTokenInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRepositoriesInput {
    /// <p>The AWS account ID associated with the registry that contains the repositories to be
    /// described. If you do not specify a registry, the default public registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>A list of repositories to describe. If this parameter is omitted, then all repositories
    /// in a registry are described.</p>
    pub repository_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>DescribeRepositories</code> request where <code>maxResults</code> was used and the
    /// results exceeded the value of that parameter. Pagination continues from the end of the
    /// previous results that returned the <code>nextToken</code> value. This value is
    /// <code>null</code> when there are no more results to return. This option cannot be used
    /// when you specify repositories with <code>repositoryNames</code>.</p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of repository results returned by <code>DescribeRepositories</code>
    /// in paginated output. When this parameter is used, <code>DescribeRepositories</code> only
    /// returns <code>maxResults</code> results in a single page along with a
    /// <code>nextToken</code> response element. The remaining results of the initial request
    /// can be seen by sending another <code>DescribeRepositories</code> request with the returned
    /// <code>nextToken</code> value. This value can be between 1 and
    /// 1000. If this parameter is not used, then <code>DescribeRepositories</code>
    /// returns up to 100 results and a <code>nextToken</code> value, if
    /// applicable. This option cannot be used when you specify repositories with
    /// <code>repositoryNames</code>.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeRepositoriesInput {
    /// <p>The AWS account ID associated with the registry that contains the repositories to be
    /// described. If you do not specify a registry, the default public registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>A list of repositories to describe. If this parameter is omitted, then all repositories
    /// in a registry are described.</p>
    pub fn repository_names(&self) -> std::option::Option<&[std::string::String]> {
        self.repository_names.as_deref()
    }
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>DescribeRepositories</code> request where <code>maxResults</code> was used and the
    /// results exceeded the value of that parameter. Pagination continues from the end of the
    /// previous results that returned the <code>nextToken</code> value. This value is
    /// <code>null</code> when there are no more results to return. This option cannot be used
    /// when you specify repositories with <code>repositoryNames</code>.</p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of repository results returned by <code>DescribeRepositories</code>
    /// in paginated output. When this parameter is used, <code>DescribeRepositories</code> only
    /// returns <code>maxResults</code> results in a single page along with a
    /// <code>nextToken</code> response element. The remaining results of the initial request
    /// can be seen by sending another <code>DescribeRepositories</code> request with the returned
    /// <code>nextToken</code> value. This value can be between 1 and
    /// 1000. If this parameter is not used, then <code>DescribeRepositories</code>
    /// returns up to 100 results and a <code>nextToken</code> value, if
    /// applicable. This option cannot be used when you specify repositories with
    /// <code>repositoryNames</code>.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeRepositoriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRepositoriesInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_names", &self.repository_names);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRegistriesInput {
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>DescribeRegistries</code> request where <code>maxResults</code> was used and the
    /// results exceeded the value of that parameter. Pagination continues from the end of the
    /// previous results that returned the <code>nextToken</code> value. This value is
    /// <code>null</code> when there are no more results to return.</p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of repository results returned by <code>DescribeRegistries</code> in
    /// paginated output. When this parameter is used, <code>DescribeRegistries</code> only returns
    /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
    /// response element. The remaining results of the initial request can be seen by sending
    /// another <code>DescribeRegistries</code> request with the returned <code>nextToken</code>
    /// value. This value can be between 1 and 1000. If this parameter
    /// is not used, then <code>DescribeRegistries</code> returns up to 100
    /// results and a <code>nextToken</code> value, if applicable.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeRegistriesInput {
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>DescribeRegistries</code> request where <code>maxResults</code> was used and the
    /// results exceeded the value of that parameter. Pagination continues from the end of the
    /// previous results that returned the <code>nextToken</code> value. This value is
    /// <code>null</code> when there are no more results to return.</p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of repository results returned by <code>DescribeRegistries</code> in
    /// paginated output. When this parameter is used, <code>DescribeRegistries</code> only returns
    /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
    /// response element. The remaining results of the initial request can be seen by sending
    /// another <code>DescribeRegistries</code> request with the returned <code>nextToken</code>
    /// value. This value can be between 1 and 1000. If this parameter
    /// is not used, then <code>DescribeRegistries</code> returns up to 100
    /// results and a <code>nextToken</code> value, if applicable.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeRegistriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRegistriesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImageTagsInput {
    /// <p>The AWS account ID associated with the public registry that contains the repository in
    /// which to describe images. If you do not specify a registry, the default public registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository that contains the image tag details to describe.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>DescribeImageTags</code> request where <code>maxResults</code> was used and the
    /// results exceeded the value of that parameter. Pagination continues from the end of the
    /// previous results that returned the <code>nextToken</code> value. This value is
    /// <code>null</code> when there are no more results to return. This option cannot be used
    /// when you specify images with <code>imageIds</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of repository results returned by <code>DescribeImageTags</code> in
    /// paginated output. When this parameter is used, <code>DescribeImageTags</code> only returns
    /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
    /// response element. The remaining results of the initial request can be seen by sending
    /// another <code>DescribeImageTags</code> request with the returned <code>nextToken</code>
    /// value. This value can be between 1 and 1000. If this parameter
    /// is not used, then <code>DescribeImageTags</code> returns up to 100
    /// results and a <code>nextToken</code> value, if applicable. This option cannot be used when
    /// you specify images with <code>imageIds</code>.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeImageTagsInput {
    /// <p>The AWS account ID associated with the public registry that contains the repository in
    /// which to describe images. If you do not specify a registry, the default public registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository that contains the image tag details to describe.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>DescribeImageTags</code> request where <code>maxResults</code> was used and the
    /// results exceeded the value of that parameter. Pagination continues from the end of the
    /// previous results that returned the <code>nextToken</code> value. This value is
    /// <code>null</code> when there are no more results to return. This option cannot be used
    /// when you specify images with <code>imageIds</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of repository results returned by <code>DescribeImageTags</code> in
    /// paginated output. When this parameter is used, <code>DescribeImageTags</code> only returns
    /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
    /// response element. The remaining results of the initial request can be seen by sending
    /// another <code>DescribeImageTags</code> request with the returned <code>nextToken</code>
    /// value. This value can be between 1 and 1000. If this parameter
    /// is not used, then <code>DescribeImageTags</code> returns up to 100
    /// results and a <code>nextToken</code> value, if applicable. This option cannot be used when
    /// you specify images with <code>imageIds</code>.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeImageTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImageTagsInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImagesInput {
    /// <p>The AWS account ID associated with the public registry that contains the repository in
    /// which to describe images. If you do not specify a registry, the default public registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository that contains the images to describe.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The list of image IDs for the requested repository.</p>
    pub image_ids: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>DescribeImages</code> request where <code>maxResults</code> was used and the
    /// results exceeded the value of that parameter. Pagination continues from the end of the
    /// previous results that returned the <code>nextToken</code> value. This value is
    /// <code>null</code> when there are no more results to return. This option cannot be used
    /// when you specify images with <code>imageIds</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of repository results returned by <code>DescribeImages</code> in
    /// paginated output. When this parameter is used, <code>DescribeImages</code> only returns
    /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
    /// response element. The remaining results of the initial request can be seen by sending
    /// another <code>DescribeImages</code> request with the returned <code>nextToken</code> value.
    /// This value can be between 1 and 1000. If this parameter is not
    /// used, then <code>DescribeImages</code> returns up to 100 results and a
    /// <code>nextToken</code> value, if applicable. This option cannot be used when you specify
    /// images with <code>imageIds</code>.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeImagesInput {
    /// <p>The AWS account ID associated with the public registry that contains the repository in
    /// which to describe images. If you do not specify a registry, the default public registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository that contains the images to describe.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The list of image IDs for the requested repository.</p>
    pub fn image_ids(&self) -> std::option::Option<&[crate::model::ImageIdentifier]> {
        self.image_ids.as_deref()
    }
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>DescribeImages</code> request where <code>maxResults</code> was used and the
    /// results exceeded the value of that parameter. Pagination continues from the end of the
    /// previous results that returned the <code>nextToken</code> value. This value is
    /// <code>null</code> when there are no more results to return. This option cannot be used
    /// when you specify images with <code>imageIds</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of repository results returned by <code>DescribeImages</code> in
    /// paginated output. When this parameter is used, <code>DescribeImages</code> only returns
    /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
    /// response element. The remaining results of the initial request can be seen by sending
    /// another <code>DescribeImages</code> request with the returned <code>nextToken</code> value.
    /// This value can be between 1 and 1000. If this parameter is not
    /// used, then <code>DescribeImages</code> returns up to 100 results and a
    /// <code>nextToken</code> value, if applicable. This option cannot be used when you specify
    /// images with <code>imageIds</code>.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeImagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImagesInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_ids", &self.image_ids);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRepositoryPolicyInput {
    /// <p>The AWS account ID associated with the public registry that contains the repository
    /// policy to delete. If you do not specify a registry, the default public registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository that is associated with the repository policy to
    /// delete.</p>
    pub repository_name: std::option::Option<std::string::String>,
}
impl DeleteRepositoryPolicyInput {
    /// <p>The AWS account ID associated with the public registry that contains the repository
    /// policy to delete. If you do not specify a registry, the default public registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository that is associated with the repository policy to
    /// delete.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteRepositoryPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRepositoryPolicyInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRepositoryInput {
    /// <p>The AWS account ID associated with the public registry that contains the repository to
    /// delete. If you do not specify a registry, the default public registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository to delete.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p> If a repository contains images, forces the deletion.</p>
    pub force: bool,
}
impl DeleteRepositoryInput {
    /// <p>The AWS account ID associated with the public registry that contains the repository to
    /// delete. If you do not specify a registry, the default public registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository to delete.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p> If a repository contains images, forces the deletion.</p>
    pub fn force(&self) -> bool {
        self.force
    }
}
impl std::fmt::Debug for DeleteRepositoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRepositoryInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("force", &self.force);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRepositoryInput {
    /// <p>The name to use for the repository. This appears publicly in the Amazon ECR Public Gallery.
    /// The repository name may be specified on its own (such as <code>nginx-web-app</code>) or it
    /// can be prepended with a namespace to group the repository into a category (such as
    /// <code>project-a/nginx-web-app</code>).</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The details about the repository that are publicly visible in the
    /// Amazon ECR Public Gallery.</p>
    pub catalog_data: std::option::Option<crate::model::RepositoryCatalogDataInput>,
    /// <p>The metadata that you apply to the repository to help you categorize and organize them.
    /// Each tag consists of a key and an optional value, both of which you define.
    /// Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateRepositoryInput {
    /// <p>The name to use for the repository. This appears publicly in the Amazon ECR Public Gallery.
    /// The repository name may be specified on its own (such as <code>nginx-web-app</code>) or it
    /// can be prepended with a namespace to group the repository into a category (such as
    /// <code>project-a/nginx-web-app</code>).</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The details about the repository that are publicly visible in the
    /// Amazon ECR Public Gallery.</p>
    pub fn catalog_data(&self) -> std::option::Option<&crate::model::RepositoryCatalogDataInput> {
        self.catalog_data.as_ref()
    }
    /// <p>The metadata that you apply to the repository to help you categorize and organize them.
    /// Each tag consists of a key and an optional value, both of which you define.
    /// Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateRepositoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRepositoryInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("catalog_data", &self.catalog_data);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompleteLayerUploadInput {
    /// <p>The AWS account ID associated with the registry to which to upload layers.
    /// If you do not specify a registry, the default public registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository in a public registry to associate with the image
    /// layer.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
    /// associate with the image layer.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>The <code>sha256</code> digest of the image layer.</p>
    pub layer_digests: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CompleteLayerUploadInput {
    /// <p>The AWS account ID associated with the registry to which to upload layers.
    /// If you do not specify a registry, the default public registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository in a public registry to associate with the image
    /// layer.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
    /// associate with the image layer.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>The <code>sha256</code> digest of the image layer.</p>
    pub fn layer_digests(&self) -> std::option::Option<&[std::string::String]> {
        self.layer_digests.as_deref()
    }
}
impl std::fmt::Debug for CompleteLayerUploadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompleteLayerUploadInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("upload_id", &self.upload_id);
        formatter.field("layer_digests", &self.layer_digests);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteImageInput {
    /// <p>The AWS account ID associated with the registry that contains the image to delete.
    /// If you do not specify a registry, the default public registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository in a public registry that contains the image to delete.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>A list of image ID references that correspond to images to delete. The format of the
    /// <code>imageIds</code> reference is <code>imageTag=tag</code> or
    /// <code>imageDigest=digest</code>.</p>
    pub image_ids: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
}
impl BatchDeleteImageInput {
    /// <p>The AWS account ID associated with the registry that contains the image to delete.
    /// If you do not specify a registry, the default public registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository in a public registry that contains the image to delete.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>A list of image ID references that correspond to images to delete. The format of the
    /// <code>imageIds</code> reference is <code>imageTag=tag</code> or
    /// <code>imageDigest=digest</code>.</p>
    pub fn image_ids(&self) -> std::option::Option<&[crate::model::ImageIdentifier]> {
        self.image_ids.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteImageInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_ids", &self.image_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCheckLayerAvailabilityInput {
    /// <p>The AWS account ID associated with the public registry that contains the image layers to
    /// check. If you do not specify a registry, the default public registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository that is associated with the image layers to check.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The digests of the image layers to check.</p>
    pub layer_digests: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchCheckLayerAvailabilityInput {
    /// <p>The AWS account ID associated with the public registry that contains the image layers to
    /// check. If you do not specify a registry, the default public registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository that is associated with the image layers to check.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The digests of the image layers to check.</p>
    pub fn layer_digests(&self) -> std::option::Option<&[std::string::String]> {
        self.layer_digests.as_deref()
    }
}
impl std::fmt::Debug for BatchCheckLayerAvailabilityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCheckLayerAvailabilityInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("layer_digests", &self.layer_digests);
        formatter.finish()
    }
}
