// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon Elastic Container Registry Public
///
/// Client for invoking operations on Amazon Elastic Container Registry Public. Each operation on Amazon Elastic Container Registry Public is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_ecrpublic::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_ecrpublic::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_ecrpublic::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchCheckLayerAvailability` operation.
    ///
    /// See [`BatchCheckLayerAvailability`](crate::client::fluent_builders::BatchCheckLayerAvailability) for more information about the
    /// operation and its arguments.
    pub fn batch_check_layer_availability(
        &self,
    ) -> fluent_builders::BatchCheckLayerAvailability<C, M, R> {
        fluent_builders::BatchCheckLayerAvailability::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDeleteImage` operation.
    ///
    /// See [`BatchDeleteImage`](crate::client::fluent_builders::BatchDeleteImage) for more information about the
    /// operation and its arguments.
    pub fn batch_delete_image(&self) -> fluent_builders::BatchDeleteImage<C, M, R> {
        fluent_builders::BatchDeleteImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CompleteLayerUpload` operation.
    ///
    /// See [`CompleteLayerUpload`](crate::client::fluent_builders::CompleteLayerUpload) for more information about the
    /// operation and its arguments.
    pub fn complete_layer_upload(&self) -> fluent_builders::CompleteLayerUpload<C, M, R> {
        fluent_builders::CompleteLayerUpload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRepository` operation.
    ///
    /// See [`CreateRepository`](crate::client::fluent_builders::CreateRepository) for more information about the
    /// operation and its arguments.
    pub fn create_repository(&self) -> fluent_builders::CreateRepository<C, M, R> {
        fluent_builders::CreateRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRepository` operation.
    ///
    /// See [`DeleteRepository`](crate::client::fluent_builders::DeleteRepository) for more information about the
    /// operation and its arguments.
    pub fn delete_repository(&self) -> fluent_builders::DeleteRepository<C, M, R> {
        fluent_builders::DeleteRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRepositoryPolicy` operation.
    ///
    /// See [`DeleteRepositoryPolicy`](crate::client::fluent_builders::DeleteRepositoryPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_repository_policy(&self) -> fluent_builders::DeleteRepositoryPolicy<C, M, R> {
        fluent_builders::DeleteRepositoryPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeImages` operation.
    ///
    /// See [`DescribeImages`](crate::client::fluent_builders::DescribeImages) for more information about the
    /// operation and its arguments.
    pub fn describe_images(&self) -> fluent_builders::DescribeImages<C, M, R> {
        fluent_builders::DescribeImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeImageTags` operation.
    ///
    /// See [`DescribeImageTags`](crate::client::fluent_builders::DescribeImageTags) for more information about the
    /// operation and its arguments.
    pub fn describe_image_tags(&self) -> fluent_builders::DescribeImageTags<C, M, R> {
        fluent_builders::DescribeImageTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRegistries` operation.
    ///
    /// See [`DescribeRegistries`](crate::client::fluent_builders::DescribeRegistries) for more information about the
    /// operation and its arguments.
    pub fn describe_registries(&self) -> fluent_builders::DescribeRegistries<C, M, R> {
        fluent_builders::DescribeRegistries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRepositories` operation.
    ///
    /// See [`DescribeRepositories`](crate::client::fluent_builders::DescribeRepositories) for more information about the
    /// operation and its arguments.
    pub fn describe_repositories(&self) -> fluent_builders::DescribeRepositories<C, M, R> {
        fluent_builders::DescribeRepositories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAuthorizationToken` operation.
    ///
    /// See [`GetAuthorizationToken`](crate::client::fluent_builders::GetAuthorizationToken) for more information about the
    /// operation and its arguments.
    pub fn get_authorization_token(&self) -> fluent_builders::GetAuthorizationToken<C, M, R> {
        fluent_builders::GetAuthorizationToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRegistryCatalogData` operation.
    ///
    /// See [`GetRegistryCatalogData`](crate::client::fluent_builders::GetRegistryCatalogData) for more information about the
    /// operation and its arguments.
    pub fn get_registry_catalog_data(&self) -> fluent_builders::GetRegistryCatalogData<C, M, R> {
        fluent_builders::GetRegistryCatalogData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRepositoryCatalogData` operation.
    ///
    /// See [`GetRepositoryCatalogData`](crate::client::fluent_builders::GetRepositoryCatalogData) for more information about the
    /// operation and its arguments.
    pub fn get_repository_catalog_data(
        &self,
    ) -> fluent_builders::GetRepositoryCatalogData<C, M, R> {
        fluent_builders::GetRepositoryCatalogData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRepositoryPolicy` operation.
    ///
    /// See [`GetRepositoryPolicy`](crate::client::fluent_builders::GetRepositoryPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_repository_policy(&self) -> fluent_builders::GetRepositoryPolicy<C, M, R> {
        fluent_builders::GetRepositoryPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `InitiateLayerUpload` operation.
    ///
    /// See [`InitiateLayerUpload`](crate::client::fluent_builders::InitiateLayerUpload) for more information about the
    /// operation and its arguments.
    pub fn initiate_layer_upload(&self) -> fluent_builders::InitiateLayerUpload<C, M, R> {
        fluent_builders::InitiateLayerUpload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutImage` operation.
    ///
    /// See [`PutImage`](crate::client::fluent_builders::PutImage) for more information about the
    /// operation and its arguments.
    pub fn put_image(&self) -> fluent_builders::PutImage<C, M, R> {
        fluent_builders::PutImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutRegistryCatalogData` operation.
    ///
    /// See [`PutRegistryCatalogData`](crate::client::fluent_builders::PutRegistryCatalogData) for more information about the
    /// operation and its arguments.
    pub fn put_registry_catalog_data(&self) -> fluent_builders::PutRegistryCatalogData<C, M, R> {
        fluent_builders::PutRegistryCatalogData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutRepositoryCatalogData` operation.
    ///
    /// See [`PutRepositoryCatalogData`](crate::client::fluent_builders::PutRepositoryCatalogData) for more information about the
    /// operation and its arguments.
    pub fn put_repository_catalog_data(
        &self,
    ) -> fluent_builders::PutRepositoryCatalogData<C, M, R> {
        fluent_builders::PutRepositoryCatalogData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetRepositoryPolicy` operation.
    ///
    /// See [`SetRepositoryPolicy`](crate::client::fluent_builders::SetRepositoryPolicy) for more information about the
    /// operation and its arguments.
    pub fn set_repository_policy(&self) -> fluent_builders::SetRepositoryPolicy<C, M, R> {
        fluent_builders::SetRepositoryPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UploadLayerPart` operation.
    ///
    /// See [`UploadLayerPart`](crate::client::fluent_builders::UploadLayerPart) for more information about the
    /// operation and its arguments.
    pub fn upload_layer_part(&self) -> fluent_builders::UploadLayerPart<C, M, R> {
        fluent_builders::UploadLayerPart::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchCheckLayerAvailability`.
    ///
    /// <p>Checks the availability of one or more image layers within a repository in a public
    /// registry. When an image is pushed to a repository, each image layer is checked to verify if
    /// it has been uploaded before. If it has been uploaded, then the image layer is
    /// skipped.</p>
    /// <note>
    /// <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct BatchCheckLayerAvailability<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_check_layer_availability_input::Builder,
    }
    impl<C, M, R> BatchCheckLayerAvailability<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchCheckLayerAvailability`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCheckLayerAvailabilityOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCheckLayerAvailabilityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchCheckLayerAvailabilityInputOperationOutputAlias,
                crate::output::BatchCheckLayerAvailabilityOutput,
                crate::error::BatchCheckLayerAvailabilityError,
                crate::input::BatchCheckLayerAvailabilityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID associated with the public registry that contains the image layers to
        /// check. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The AWS account ID associated with the public registry that contains the image layers to
        /// check. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository that is associated with the image layers to check.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that is associated with the image layers to check.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `layerDigests`.
        ///
        /// To override the contents of this collection use [`set_layer_digests`](Self::set_layer_digests).
        ///
        /// <p>The digests of the image layers to check.</p>
        pub fn layer_digests(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_digests(inp);
            self
        }
        /// <p>The digests of the image layers to check.</p>
        pub fn set_layer_digests(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_layer_digests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeleteImage`.
    ///
    /// <p>Deletes a list of specified images within a repository in a public registry. Images are
    /// specified with either an <code>imageTag</code> or <code>imageDigest</code>.</p>
    /// <p>You can remove a tag from an image by specifying the image's tag in your request. When
    /// you remove the last tag from an image, the image is deleted from your repository.</p>
    /// <p>You can completely delete an image (and all of its tags) by specifying the image's
    /// digest in your request.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDeleteImage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_image_input::Builder,
    }
    impl<C, M, R> BatchDeleteImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDeleteImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteImageOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeleteImageInputOperationOutputAlias,
                crate::output::BatchDeleteImageOutput,
                crate::error::BatchDeleteImageError,
                crate::input::BatchDeleteImageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID associated with the registry that contains the image to delete.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The AWS account ID associated with the registry that contains the image to delete.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The repository in a public registry that contains the image to delete.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The repository in a public registry that contains the image to delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `imageIds`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>A list of image ID references that correspond to images to delete. The format of the
        /// <code>imageIds</code> reference is <code>imageTag=tag</code> or
        /// <code>imageDigest=digest</code>.</p>
        pub fn image_ids(mut self, inp: impl Into<crate::model::ImageIdentifier>) -> Self {
            self.inner = self.inner.image_ids(inp);
            self
        }
        /// <p>A list of image ID references that correspond to images to delete. The format of the
        /// <code>imageIds</code> reference is <code>imageTag=tag</code> or
        /// <code>imageDigest=digest</code>.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.inner = self.inner.set_image_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CompleteLayerUpload`.
    ///
    /// <p>Informs Amazon ECR that the image layer upload has completed for a specified public registry,
    /// repository name, and upload ID. You can optionally provide a <code>sha256</code> digest of
    /// the image layer for data validation purposes.</p>
    /// <p>When an image is pushed, the CompleteLayerUpload API is called once per each new image
    /// layer to verify that the upload has completed.</p>
    /// <note>
    /// <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CompleteLayerUpload<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::complete_layer_upload_input::Builder,
    }
    impl<C, M, R> CompleteLayerUpload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CompleteLayerUpload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CompleteLayerUploadOutput,
            aws_smithy_http::result::SdkError<crate::error::CompleteLayerUploadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CompleteLayerUploadInputOperationOutputAlias,
                crate::output::CompleteLayerUploadOutput,
                crate::error::CompleteLayerUploadError,
                crate::input::CompleteLayerUploadInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID associated with the registry to which to upload layers.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The AWS account ID associated with the registry to which to upload layers.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository in a public registry to associate with the image
        /// layer.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository in a public registry to associate with the image
        /// layer.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
        /// associate with the image layer.</p>
        pub fn upload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.upload_id(inp);
            self
        }
        /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
        /// associate with the image layer.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_upload_id(input);
            self
        }
        /// Appends an item to `layerDigests`.
        ///
        /// To override the contents of this collection use [`set_layer_digests`](Self::set_layer_digests).
        ///
        /// <p>The <code>sha256</code> digest of the image layer.</p>
        pub fn layer_digests(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_digests(inp);
            self
        }
        /// <p>The <code>sha256</code> digest of the image layer.</p>
        pub fn set_layer_digests(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_layer_digests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRepository`.
    ///
    /// <p>Creates a repository in a public registry. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html">Amazon ECR
    /// repositories</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_repository_input::Builder,
    }
    impl<C, M, R> CreateRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRepositoryInputOperationOutputAlias,
                crate::output::CreateRepositoryOutput,
                crate::error::CreateRepositoryError,
                crate::input::CreateRepositoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for the repository. This appears publicly in the Amazon ECR Public Gallery.
        /// The repository name may be specified on its own (such as <code>nginx-web-app</code>) or it
        /// can be prepended with a namespace to group the repository into a category (such as
        /// <code>project-a/nginx-web-app</code>).</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name to use for the repository. This appears publicly in the Amazon ECR Public Gallery.
        /// The repository name may be specified on its own (such as <code>nginx-web-app</code>) or it
        /// can be prepended with a namespace to group the repository into a category (such as
        /// <code>project-a/nginx-web-app</code>).</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The details about the repository that are publicly visible in the
        /// Amazon ECR Public Gallery.</p>
        pub fn catalog_data(mut self, inp: crate::model::RepositoryCatalogDataInput) -> Self {
            self.inner = self.inner.catalog_data(inp);
            self
        }
        /// <p>The details about the repository that are publicly visible in the
        /// Amazon ECR Public Gallery.</p>
        pub fn set_catalog_data(
            mut self,
            input: std::option::Option<crate::model::RepositoryCatalogDataInput>,
        ) -> Self {
            self.inner = self.inner.set_catalog_data(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the repository to help you categorize and organize them.
        /// Each tag consists of a key and an optional value, both of which you define.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The metadata that you apply to the repository to help you categorize and organize them.
        /// Each tag consists of a key and an optional value, both of which you define.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRepository`.
    ///
    /// <p>Deletes a repository in a public registry. If the repository contains images, you must
    /// either delete all images in the repository or use the <code>force</code> option which
    /// deletes all images on your behalf before deleting the repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_repository_input::Builder,
    }
    impl<C, M, R> DeleteRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRepositoryInputOperationOutputAlias,
                crate::output::DeleteRepositoryOutput,
                crate::error::DeleteRepositoryError,
                crate::input::DeleteRepositoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID associated with the public registry that contains the repository to
        /// delete. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The AWS account ID associated with the public registry that contains the repository to
        /// delete. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to delete.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository to delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p> If a repository contains images, forces the deletion.</p>
        pub fn force(mut self, inp: bool) -> Self {
            self.inner = self.inner.force(inp);
            self
        }
        /// <p> If a repository contains images, forces the deletion.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRepositoryPolicy`.
    ///
    /// <p>Deletes the repository policy associated with the specified repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRepositoryPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_repository_policy_input::Builder,
    }
    impl<C, M, R> DeleteRepositoryPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRepositoryPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRepositoryPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRepositoryPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRepositoryPolicyInputOperationOutputAlias,
                crate::output::DeleteRepositoryPolicyOutput,
                crate::error::DeleteRepositoryPolicyError,
                crate::input::DeleteRepositoryPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID associated with the public registry that contains the repository
        /// policy to delete. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The AWS account ID associated with the public registry that contains the repository
        /// policy to delete. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository that is associated with the repository policy to
        /// delete.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that is associated with the repository policy to
        /// delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImages`.
    ///
    /// <p>Returns metadata about the images in a repository in a public registry.</p>
    /// <note>
    /// <p>Beginning with Docker version 1.9, the Docker client compresses image layers before
    /// pushing them to a V2 Docker registry. The output of the <code>docker images</code>
    /// command shows the uncompressed image size, so it may return a larger image size than the
    /// image sizes returned by <a>DescribeImages</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeImages<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_images_input::Builder,
    }
    impl<C, M, R> DescribeImages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeImagesInputOperationOutputAlias,
                crate::output::DescribeImagesOutput,
                crate::error::DescribeImagesError,
                crate::input::DescribeImagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID associated with the public registry that contains the repository in
        /// which to describe images. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The AWS account ID associated with the public registry that contains the repository in
        /// which to describe images. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The repository that contains the images to describe.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The repository that contains the images to describe.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `imageIds`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>The list of image IDs for the requested repository.</p>
        pub fn image_ids(mut self, inp: impl Into<crate::model::ImageIdentifier>) -> Self {
            self.inner = self.inner.image_ids(inp);
            self
        }
        /// <p>The list of image IDs for the requested repository.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.inner = self.inner.set_image_ids(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeImages</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be used
        /// when you specify images with <code>imageIds</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeImages</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be used
        /// when you specify images with <code>imageIds</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeImages</code> in
        /// paginated output. When this parameter is used, <code>DescribeImages</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>DescribeImages</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 1000. If this parameter is not
        /// used, then <code>DescribeImages</code> returns up to 100 results and a
        /// <code>nextToken</code> value, if applicable. This option cannot be used when you specify
        /// images with <code>imageIds</code>.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeImages</code> in
        /// paginated output. When this parameter is used, <code>DescribeImages</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>DescribeImages</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 1000. If this parameter is not
        /// used, then <code>DescribeImages</code> returns up to 100 results and a
        /// <code>nextToken</code> value, if applicable. This option cannot be used when you specify
        /// images with <code>imageIds</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImageTags`.
    ///
    /// <p>Returns the image tag details for a repository in a public registry.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeImageTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_image_tags_input::Builder,
    }
    impl<C, M, R> DescribeImageTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeImageTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImageTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImageTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeImageTagsInputOperationOutputAlias,
                crate::output::DescribeImageTagsOutput,
                crate::error::DescribeImageTagsError,
                crate::input::DescribeImageTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID associated with the public registry that contains the repository in
        /// which to describe images. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The AWS account ID associated with the public registry that contains the repository in
        /// which to describe images. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository that contains the image tag details to describe.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that contains the image tag details to describe.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeImageTags</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be used
        /// when you specify images with <code>imageIds</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeImageTags</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be used
        /// when you specify images with <code>imageIds</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeImageTags</code> in
        /// paginated output. When this parameter is used, <code>DescribeImageTags</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>DescribeImageTags</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 1000. If this parameter
        /// is not used, then <code>DescribeImageTags</code> returns up to 100
        /// results and a <code>nextToken</code> value, if applicable. This option cannot be used when
        /// you specify images with <code>imageIds</code>.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeImageTags</code> in
        /// paginated output. When this parameter is used, <code>DescribeImageTags</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>DescribeImageTags</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 1000. If this parameter
        /// is not used, then <code>DescribeImageTags</code> returns up to 100
        /// results and a <code>nextToken</code> value, if applicable. This option cannot be used when
        /// you specify images with <code>imageIds</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRegistries`.
    ///
    /// <p>Returns details for a public registry.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRegistries<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_registries_input::Builder,
    }
    impl<C, M, R> DescribeRegistries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRegistries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRegistriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRegistriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRegistriesInputOperationOutputAlias,
                crate::output::DescribeRegistriesOutput,
                crate::error::DescribeRegistriesError,
                crate::input::DescribeRegistriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeRegistries</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeRegistries</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeRegistries</code> in
        /// paginated output. When this parameter is used, <code>DescribeRegistries</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>DescribeRegistries</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 1000. If this parameter
        /// is not used, then <code>DescribeRegistries</code> returns up to 100
        /// results and a <code>nextToken</code> value, if applicable.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeRegistries</code> in
        /// paginated output. When this parameter is used, <code>DescribeRegistries</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>DescribeRegistries</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 1000. If this parameter
        /// is not used, then <code>DescribeRegistries</code> returns up to 100
        /// results and a <code>nextToken</code> value, if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRepositories`.
    ///
    /// <p>Describes repositories in a public registry.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRepositories<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_repositories_input::Builder,
    }
    impl<C, M, R> DescribeRepositories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRepositories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRepositoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRepositoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRepositoriesInputOperationOutputAlias,
                crate::output::DescribeRepositoriesOutput,
                crate::error::DescribeRepositoriesError,
                crate::input::DescribeRepositoriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID associated with the registry that contains the repositories to be
        /// described. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The AWS account ID associated with the registry that contains the repositories to be
        /// described. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// Appends an item to `repositoryNames`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p>A list of repositories to describe. If this parameter is omitted, then all repositories
        /// in a registry are described.</p>
        pub fn repository_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_names(inp);
            self
        }
        /// <p>A list of repositories to describe. If this parameter is omitted, then all repositories
        /// in a registry are described.</p>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_repository_names(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeRepositories</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be used
        /// when you specify repositories with <code>repositoryNames</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeRepositories</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be used
        /// when you specify repositories with <code>repositoryNames</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeRepositories</code>
        /// in paginated output. When this parameter is used, <code>DescribeRepositories</code> only
        /// returns <code>maxResults</code> results in a single page along with a
        /// <code>nextToken</code> response element. The remaining results of the initial request
        /// can be seen by sending another <code>DescribeRepositories</code> request with the returned
        /// <code>nextToken</code> value. This value can be between 1 and
        /// 1000. If this parameter is not used, then <code>DescribeRepositories</code>
        /// returns up to 100 results and a <code>nextToken</code> value, if
        /// applicable. This option cannot be used when you specify repositories with
        /// <code>repositoryNames</code>.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeRepositories</code>
        /// in paginated output. When this parameter is used, <code>DescribeRepositories</code> only
        /// returns <code>maxResults</code> results in a single page along with a
        /// <code>nextToken</code> response element. The remaining results of the initial request
        /// can be seen by sending another <code>DescribeRepositories</code> request with the returned
        /// <code>nextToken</code> value. This value can be between 1 and
        /// 1000. If this parameter is not used, then <code>DescribeRepositories</code>
        /// returns up to 100 results and a <code>nextToken</code> value, if
        /// applicable. This option cannot be used when you specify repositories with
        /// <code>repositoryNames</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAuthorizationToken`.
    ///
    /// <p>Retrieves an authorization token. An authorization token represents your IAM
    /// authentication credentials and can be used to access any Amazon ECR registry that your IAM
    /// principal has access to. The authorization token is valid for 12 hours. This API requires
    /// the <code>ecr-public:GetAuthorizationToken</code> and
    /// <code>sts:GetServiceBearerToken</code> permissions.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAuthorizationToken<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_authorization_token_input::Builder,
    }
    impl<C, M, R> GetAuthorizationToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAuthorizationToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAuthorizationTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAuthorizationTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAuthorizationTokenInputOperationOutputAlias,
                crate::output::GetAuthorizationTokenOutput,
                crate::error::GetAuthorizationTokenError,
                crate::input::GetAuthorizationTokenInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetRegistryCatalogData`.
    ///
    /// <p>Retrieves catalog metadata for a public registry.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRegistryCatalogData<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_registry_catalog_data_input::Builder,
    }
    impl<C, M, R> GetRegistryCatalogData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRegistryCatalogData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRegistryCatalogDataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRegistryCatalogDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRegistryCatalogDataInputOperationOutputAlias,
                crate::output::GetRegistryCatalogDataOutput,
                crate::error::GetRegistryCatalogDataError,
                crate::input::GetRegistryCatalogDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetRepositoryCatalogData`.
    ///
    /// <p>Retrieve catalog metadata for a repository in a public registry. This metadata is
    /// displayed publicly in the Amazon ECR Public Gallery.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRepositoryCatalogData<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_repository_catalog_data_input::Builder,
    }
    impl<C, M, R> GetRepositoryCatalogData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRepositoryCatalogData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRepositoryCatalogDataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRepositoryCatalogDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRepositoryCatalogDataInputOperationOutputAlias,
                crate::output::GetRepositoryCatalogDataOutput,
                crate::error::GetRepositoryCatalogDataError,
                crate::input::GetRepositoryCatalogDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID associated with the registry that contains the repositories to be
        /// described. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The AWS account ID associated with the registry that contains the repositories to be
        /// described. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to retrieve the catalog metadata for.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository to retrieve the catalog metadata for.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRepositoryPolicy`.
    ///
    /// <p>Retrieves the repository policy for the specified repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRepositoryPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_repository_policy_input::Builder,
    }
    impl<C, M, R> GetRepositoryPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRepositoryPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRepositoryPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRepositoryPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRepositoryPolicyInputOperationOutputAlias,
                crate::output::GetRepositoryPolicyOutput,
                crate::error::GetRepositoryPolicyError,
                crate::input::GetRepositoryPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID associated with the public registry that contains the repository.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The AWS account ID associated with the public registry that contains the repository.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository with the policy to retrieve.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository with the policy to retrieve.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InitiateLayerUpload`.
    ///
    /// <p>Notifies Amazon ECR that you intend to upload an image layer.</p>
    /// <p>When an image is pushed, the InitiateLayerUpload API is called once per image layer that
    /// has not already been uploaded. Whether or not an image layer has been uploaded is
    /// determined by the BatchCheckLayerAvailability API action.</p>
    /// <note>
    /// <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct InitiateLayerUpload<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::initiate_layer_upload_input::Builder,
    }
    impl<C, M, R> InitiateLayerUpload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `InitiateLayerUpload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InitiateLayerUploadOutput,
            aws_smithy_http::result::SdkError<crate::error::InitiateLayerUploadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::InitiateLayerUploadInputOperationOutputAlias,
                crate::output::InitiateLayerUploadOutput,
                crate::error::InitiateLayerUploadError,
                crate::input::InitiateLayerUploadInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID associated with the registry to which you intend to upload layers.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The AWS account ID associated with the registry to which you intend to upload layers.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to which you intend to upload layers.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository to which you intend to upload layers.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List the tags for an Amazon ECR Public resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the
        /// supported resource is an Amazon ECR Public repository.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the
        /// supported resource is an Amazon ECR Public repository.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutImage`.
    ///
    /// <p>Creates or updates the image manifest and tags associated with an image.</p>
    /// <p>When an image is pushed and all new image layers have been uploaded, the PutImage API is
    /// called once to create or update the image manifest and the tags associated with the
    /// image.</p>
    ///
    /// <note>
    /// <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct PutImage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_image_input::Builder,
    }
    impl<C, M, R> PutImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutImageOutput,
            aws_smithy_http::result::SdkError<crate::error::PutImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutImageInputOperationOutputAlias,
                crate::output::PutImageOutput,
                crate::error::PutImageError,
                crate::input::PutImageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID associated with the public registry that contains the repository in
        /// which to put the image. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The AWS account ID associated with the public registry that contains the repository in
        /// which to put the image. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository in which to put the image.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository in which to put the image.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The image manifest corresponding to the image to be uploaded.</p>
        pub fn image_manifest(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_manifest(inp);
            self
        }
        /// <p>The image manifest corresponding to the image to be uploaded.</p>
        pub fn set_image_manifest(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_manifest(input);
            self
        }
        /// <p>The media type of the image manifest. If you push an image manifest that does not
        /// contain the <code>mediaType</code> field, you must specify the
        /// <code>imageManifestMediaType</code> in the request.</p>
        pub fn image_manifest_media_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_manifest_media_type(inp);
            self
        }
        /// <p>The media type of the image manifest. If you push an image manifest that does not
        /// contain the <code>mediaType</code> field, you must specify the
        /// <code>imageManifestMediaType</code> in the request.</p>
        pub fn set_image_manifest_media_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_manifest_media_type(input);
            self
        }
        /// <p>The tag to associate with the image. This parameter is required for images that use the
        /// Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.</p>
        pub fn image_tag(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_tag(inp);
            self
        }
        /// <p>The tag to associate with the image. This parameter is required for images that use the
        /// Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.</p>
        pub fn set_image_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_tag(input);
            self
        }
        /// <p>The image digest of the image manifest corresponding to the image.</p>
        pub fn image_digest(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_digest(inp);
            self
        }
        /// <p>The image digest of the image manifest corresponding to the image.</p>
        pub fn set_image_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_digest(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRegistryCatalogData`.
    ///
    /// <p>Create or updates the catalog data for a public registry.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutRegistryCatalogData<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_registry_catalog_data_input::Builder,
    }
    impl<C, M, R> PutRegistryCatalogData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRegistryCatalogData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRegistryCatalogDataOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRegistryCatalogDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRegistryCatalogDataInputOperationOutputAlias,
                crate::output::PutRegistryCatalogDataOutput,
                crate::error::PutRegistryCatalogDataError,
                crate::input::PutRegistryCatalogDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The display name for a public registry. The display name is shown as the repository
        /// author in the Amazon ECR Public Gallery.</p>
        /// <note>
        /// <p>The registry display name is only publicly visible in the Amazon ECR Public Gallery for
        /// verified accounts.</p>
        /// </note>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The display name for a public registry. The display name is shown as the repository
        /// author in the Amazon ECR Public Gallery.</p>
        /// <note>
        /// <p>The registry display name is only publicly visible in the Amazon ECR Public Gallery for
        /// verified accounts.</p>
        /// </note>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRepositoryCatalogData`.
    ///
    /// <p>Creates or updates the catalog data for a repository in a public registry.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutRepositoryCatalogData<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_repository_catalog_data_input::Builder,
    }
    impl<C, M, R> PutRepositoryCatalogData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRepositoryCatalogData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRepositoryCatalogDataOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRepositoryCatalogDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRepositoryCatalogDataInputOperationOutputAlias,
                crate::output::PutRepositoryCatalogDataOutput,
                crate::error::PutRepositoryCatalogDataError,
                crate::input::PutRepositoryCatalogDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID associated with the public registry the repository is in.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The AWS account ID associated with the public registry the repository is in.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to create or update the catalog data for.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository to create or update the catalog data for.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>An object containing the catalog data for a repository. This data is publicly visible in
        /// the Amazon ECR Public Gallery.</p>
        pub fn catalog_data(mut self, inp: crate::model::RepositoryCatalogDataInput) -> Self {
            self.inner = self.inner.catalog_data(inp);
            self
        }
        /// <p>An object containing the catalog data for a repository. This data is publicly visible in
        /// the Amazon ECR Public Gallery.</p>
        pub fn set_catalog_data(
            mut self,
            input: std::option::Option<crate::model::RepositoryCatalogDataInput>,
        ) -> Self {
            self.inner = self.inner.set_catalog_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetRepositoryPolicy`.
    ///
    /// <p>Applies a repository policy to the specified public repository to control access
    /// permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html">Amazon ECR Repository
    /// Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetRepositoryPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_repository_policy_input::Builder,
    }
    impl<C, M, R> SetRepositoryPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetRepositoryPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetRepositoryPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::SetRepositoryPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetRepositoryPolicyInputOperationOutputAlias,
                crate::output::SetRepositoryPolicyOutput,
                crate::error::SetRepositoryPolicyError,
                crate::input::SetRepositoryPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The AWS account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to receive the policy.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository to receive the policy.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The JSON repository policy text to apply to the repository. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR Repository
        /// Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
        pub fn policy_text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_text(inp);
            self
        }
        /// <p>The JSON repository policy text to apply to the repository. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR Repository
        /// Policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
        pub fn set_policy_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_text(input);
            self
        }
        /// <p>If the policy you are attempting to set on a repository policy would prevent you from
        /// setting another policy in the future, you must force the <a>SetRepositoryPolicy</a> operation. This is intended to prevent accidental
        /// repository lock outs.</p>
        pub fn force(mut self, inp: bool) -> Self {
            self.inner = self.inner.force(inp);
            self
        }
        /// <p>If the policy you are attempting to set on a repository policy would prevent you from
        /// setting another policy in the future, you must force the <a>SetRepositoryPolicy</a> operation. This is intended to prevent accidental
        /// repository lock outs.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates the specified tags to a resource with the specified <code>resourceArn</code>.
    /// If existing tags on a resource are not specified in the request parameters, they are not
    /// changed. When a resource is deleted, the tags associated with that resource are deleted as
    /// well.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which to add tags. Currently, the
        /// supported resource is an Amazon ECR Public repository.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which to add tags. Currently, the
        /// supported resource is an Amazon ECR Public repository.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes specified tags from a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which to delete tags. Currently, the supported
        /// resource is an Amazon ECR Public repository.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which to delete tags. Currently, the supported
        /// resource is an Amazon ECR Public repository.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UploadLayerPart`.
    ///
    /// <p>Uploads an image layer part to Amazon ECR.</p>
    /// <p>When an image is pushed, each new image layer is uploaded in parts. The maximum size of
    /// each image layer part can be 20971520 bytes (or about 20MB). The UploadLayerPart API is
    /// called once per each new image layer part.</p>
    /// <note>
    /// <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UploadLayerPart<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::upload_layer_part_input::Builder,
    }
    impl<C, M, R> UploadLayerPart<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UploadLayerPart`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UploadLayerPartOutput,
            aws_smithy_http::result::SdkError<crate::error::UploadLayerPartError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UploadLayerPartInputOperationOutputAlias,
                crate::output::UploadLayerPartOutput,
                crate::error::UploadLayerPartError,
                crate::input::UploadLayerPartInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS account ID associated with the registry to which you are uploading layer parts.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The AWS account ID associated with the registry to which you are uploading layer parts.
        /// If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to which you are uploading layer parts.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository to which you are uploading layer parts.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
        /// associate with the layer part upload.</p>
        pub fn upload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.upload_id(inp);
            self
        }
        /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
        /// associate with the layer part upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_upload_id(input);
            self
        }
        /// <p>The position of the first byte of the layer part witin the overall image layer.</p>
        pub fn part_first_byte(mut self, inp: i64) -> Self {
            self.inner = self.inner.part_first_byte(inp);
            self
        }
        /// <p>The position of the first byte of the layer part witin the overall image layer.</p>
        pub fn set_part_first_byte(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_part_first_byte(input);
            self
        }
        /// <p>The position of the last byte of the layer part within the overall image layer.</p>
        pub fn part_last_byte(mut self, inp: i64) -> Self {
            self.inner = self.inner.part_last_byte(inp);
            self
        }
        /// <p>The position of the last byte of the layer part within the overall image layer.</p>
        pub fn set_part_last_byte(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_part_last_byte(input);
            self
        }
        /// <p>The base64-encoded layer part payload.</p>
        pub fn layer_part_blob(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.layer_part_blob(inp);
            self
        }
        /// <p>The base64-encoded layer part payload.</p>
        pub fn set_layer_part_blob(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_layer_part_blob(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
