// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The metadata that you apply to a resource to help you categorize and organize them. Each
/// tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>One part of a key-value pair that make up a tag. A <code>key</code> is a general label
    /// that acts like a category for more specific tag values.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The optional part of a key-value pair that make up a tag. A <code>value</code> acts as a
    /// descriptor within a tag category (key).</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>One part of a key-value pair that make up a tag. A <code>key</code> is a general label
    /// that acts like a category for more specific tag values.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The optional part of a key-value pair that make up a tag. A <code>value</code> acts as a
    /// descriptor within a tag category (key).</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>One part of a key-value pair that make up a tag. A <code>key</code> is a general label
        /// that acts like a category for more specific tag values.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>One part of a key-value pair that make up a tag. A <code>key</code> is a general label
        /// that acts like a category for more specific tag values.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The optional part of a key-value pair that make up a tag. A <code>value</code> acts as a
        /// descriptor within a tag category (key).</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The optional part of a key-value pair that make up a tag. A <code>value</code> acts as a
        /// descriptor within a tag category (key).</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>The catalog data for a repository. This data is publicly visible in the
/// Amazon ECR Public Gallery.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryCatalogData {
    /// <p>The short description of the repository.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The architecture tags that are associated with the repository.</p>
    /// <note>
    /// <p>Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For
    /// more information, see <a>RepositoryCatalogDataInput</a>.</p>
    /// </note>
    pub architectures: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The operating system tags that are associated with the repository.</p>
    /// <note>
    /// <p>Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For
    /// more information, see <a>RepositoryCatalogDataInput</a>.</p>
    /// </note>
    pub operating_systems: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The URL containing the logo associated with the repository.</p>
    pub logo_url: std::option::Option<std::string::String>,
    /// <p>The longform description of the contents of the repository. This text appears in the
    /// repository details on the Amazon ECR Public Gallery.</p>
    pub about_text: std::option::Option<std::string::String>,
    /// <p>The longform usage details of the contents of the repository. The usage text provides
    /// context for users of the repository.</p>
    pub usage_text: std::option::Option<std::string::String>,
    /// <p>Whether or not the repository is certified by AWS Marketplace.</p>
    pub marketplace_certified: std::option::Option<bool>,
}
impl RepositoryCatalogData {
    /// <p>The short description of the repository.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The architecture tags that are associated with the repository.</p>
    /// <note>
    /// <p>Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For
    /// more information, see <a>RepositoryCatalogDataInput</a>.</p>
    /// </note>
    pub fn architectures(&self) -> std::option::Option<&[std::string::String]> {
        self.architectures.as_deref()
    }
    /// <p>The operating system tags that are associated with the repository.</p>
    /// <note>
    /// <p>Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For
    /// more information, see <a>RepositoryCatalogDataInput</a>.</p>
    /// </note>
    pub fn operating_systems(&self) -> std::option::Option<&[std::string::String]> {
        self.operating_systems.as_deref()
    }
    /// <p>The URL containing the logo associated with the repository.</p>
    pub fn logo_url(&self) -> std::option::Option<&str> {
        self.logo_url.as_deref()
    }
    /// <p>The longform description of the contents of the repository. This text appears in the
    /// repository details on the Amazon ECR Public Gallery.</p>
    pub fn about_text(&self) -> std::option::Option<&str> {
        self.about_text.as_deref()
    }
    /// <p>The longform usage details of the contents of the repository. The usage text provides
    /// context for users of the repository.</p>
    pub fn usage_text(&self) -> std::option::Option<&str> {
        self.usage_text.as_deref()
    }
    /// <p>Whether or not the repository is certified by AWS Marketplace.</p>
    pub fn marketplace_certified(&self) -> std::option::Option<bool> {
        self.marketplace_certified
    }
}
impl std::fmt::Debug for RepositoryCatalogData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryCatalogData");
        formatter.field("description", &self.description);
        formatter.field("architectures", &self.architectures);
        formatter.field("operating_systems", &self.operating_systems);
        formatter.field("logo_url", &self.logo_url);
        formatter.field("about_text", &self.about_text);
        formatter.field("usage_text", &self.usage_text);
        formatter.field("marketplace_certified", &self.marketplace_certified);
        formatter.finish()
    }
}
/// See [`RepositoryCatalogData`](crate::model::RepositoryCatalogData)
pub mod repository_catalog_data {
    /// A builder for [`RepositoryCatalogData`](crate::model::RepositoryCatalogData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) architectures: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operating_systems: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) logo_url: std::option::Option<std::string::String>,
        pub(crate) about_text: std::option::Option<std::string::String>,
        pub(crate) usage_text: std::option::Option<std::string::String>,
        pub(crate) marketplace_certified: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The short description of the repository.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The short description of the repository.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `architectures`.
        ///
        /// To override the contents of this collection use [`set_architectures`](Self::set_architectures).
        ///
        /// <p>The architecture tags that are associated with the repository.</p>
        /// <note>
        /// <p>Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For
        /// more information, see <a>RepositoryCatalogDataInput</a>.</p>
        /// </note>
        pub fn architectures(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.architectures.unwrap_or_default();
            v.push(input.into());
            self.architectures = Some(v);
            self
        }
        /// <p>The architecture tags that are associated with the repository.</p>
        /// <note>
        /// <p>Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For
        /// more information, see <a>RepositoryCatalogDataInput</a>.</p>
        /// </note>
        pub fn set_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.architectures = input;
            self
        }
        /// Appends an item to `operating_systems`.
        ///
        /// To override the contents of this collection use [`set_operating_systems`](Self::set_operating_systems).
        ///
        /// <p>The operating system tags that are associated with the repository.</p>
        /// <note>
        /// <p>Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For
        /// more information, see <a>RepositoryCatalogDataInput</a>.</p>
        /// </note>
        pub fn operating_systems(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.operating_systems.unwrap_or_default();
            v.push(input.into());
            self.operating_systems = Some(v);
            self
        }
        /// <p>The operating system tags that are associated with the repository.</p>
        /// <note>
        /// <p>Only supported operating system tags appear publicly in the Amazon ECR Public Gallery. For
        /// more information, see <a>RepositoryCatalogDataInput</a>.</p>
        /// </note>
        pub fn set_operating_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.operating_systems = input;
            self
        }
        /// <p>The URL containing the logo associated with the repository.</p>
        pub fn logo_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.logo_url = Some(input.into());
            self
        }
        /// <p>The URL containing the logo associated with the repository.</p>
        pub fn set_logo_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.logo_url = input;
            self
        }
        /// <p>The longform description of the contents of the repository. This text appears in the
        /// repository details on the Amazon ECR Public Gallery.</p>
        pub fn about_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.about_text = Some(input.into());
            self
        }
        /// <p>The longform description of the contents of the repository. This text appears in the
        /// repository details on the Amazon ECR Public Gallery.</p>
        pub fn set_about_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.about_text = input;
            self
        }
        /// <p>The longform usage details of the contents of the repository. The usage text provides
        /// context for users of the repository.</p>
        pub fn usage_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_text = Some(input.into());
            self
        }
        /// <p>The longform usage details of the contents of the repository. The usage text provides
        /// context for users of the repository.</p>
        pub fn set_usage_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.usage_text = input;
            self
        }
        /// <p>Whether or not the repository is certified by AWS Marketplace.</p>
        pub fn marketplace_certified(mut self, input: bool) -> Self {
            self.marketplace_certified = Some(input);
            self
        }
        /// <p>Whether or not the repository is certified by AWS Marketplace.</p>
        pub fn set_marketplace_certified(mut self, input: std::option::Option<bool>) -> Self {
            self.marketplace_certified = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryCatalogData`](crate::model::RepositoryCatalogData)
        pub fn build(self) -> crate::model::RepositoryCatalogData {
            crate::model::RepositoryCatalogData {
                description: self.description,
                architectures: self.architectures,
                operating_systems: self.operating_systems,
                logo_url: self.logo_url,
                about_text: self.about_text,
                usage_text: self.usage_text,
                marketplace_certified: self.marketplace_certified,
            }
        }
    }
}
impl RepositoryCatalogData {
    /// Creates a new builder-style object to manufacture [`RepositoryCatalogData`](crate::model::RepositoryCatalogData)
    pub fn builder() -> crate::model::repository_catalog_data::Builder {
        crate::model::repository_catalog_data::Builder::default()
    }
}

/// <p>An object containing the catalog data for a repository. This data is publicly visible in
/// the Amazon ECR Public Gallery.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryCatalogDataInput {
    /// <p>A short description of the contents of the repository. This text appears in both the
    /// image details and also when searching for repositories on the Amazon ECR Public Gallery.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The system architecture that the images in the repository are compatible with. On the
    /// Amazon ECR Public Gallery, the following supported architectures will appear as badges on the
    /// repository and are used as search filters.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Linux</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Windows</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>If an unsupported tag is added to your repository catalog data, it will be associated
    /// with the repository and can be retrieved using the API but will not be discoverable in
    /// the Amazon ECR Public Gallery.</p>
    /// </note>
    pub architectures: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The operating systems that the images in the repository are compatible with. On the
    /// Amazon ECR Public Gallery, the following supported operating systems will appear as badges on
    /// the repository and are used as search filters.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ARM</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ARM 64</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>x86</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>x86-64</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>If an unsupported tag is added to your repository catalog data, it will be associated
    /// with the repository and can be retrieved using the API but will not be discoverable in
    /// the Amazon ECR Public Gallery.</p>
    /// </note>
    pub operating_systems: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The base64-encoded repository logo payload.</p>
    /// <note>
    /// <p>The repository logo is only publicly visible in the Amazon ECR Public Gallery for verified
    /// accounts.</p>
    /// </note>
    pub logo_image_blob: std::option::Option<aws_smithy_types::Blob>,
    /// <p>A detailed description of the contents of the repository. It is publicly visible in the
    /// Amazon ECR Public Gallery. The text must be in markdown format.</p>
    pub about_text: std::option::Option<std::string::String>,
    /// <p>Detailed information on how to use the contents of the repository. It is publicly
    /// visible in the Amazon ECR Public Gallery. The usage text provides context, support information,
    /// and additional usage details for users of the repository. The text must be in markdown
    /// format.</p>
    pub usage_text: std::option::Option<std::string::String>,
}
impl RepositoryCatalogDataInput {
    /// <p>A short description of the contents of the repository. This text appears in both the
    /// image details and also when searching for repositories on the Amazon ECR Public Gallery.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The system architecture that the images in the repository are compatible with. On the
    /// Amazon ECR Public Gallery, the following supported architectures will appear as badges on the
    /// repository and are used as search filters.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Linux</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Windows</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>If an unsupported tag is added to your repository catalog data, it will be associated
    /// with the repository and can be retrieved using the API but will not be discoverable in
    /// the Amazon ECR Public Gallery.</p>
    /// </note>
    pub fn architectures(&self) -> std::option::Option<&[std::string::String]> {
        self.architectures.as_deref()
    }
    /// <p>The operating systems that the images in the repository are compatible with. On the
    /// Amazon ECR Public Gallery, the following supported operating systems will appear as badges on
    /// the repository and are used as search filters.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ARM</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ARM 64</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>x86</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>x86-64</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>If an unsupported tag is added to your repository catalog data, it will be associated
    /// with the repository and can be retrieved using the API but will not be discoverable in
    /// the Amazon ECR Public Gallery.</p>
    /// </note>
    pub fn operating_systems(&self) -> std::option::Option<&[std::string::String]> {
        self.operating_systems.as_deref()
    }
    /// <p>The base64-encoded repository logo payload.</p>
    /// <note>
    /// <p>The repository logo is only publicly visible in the Amazon ECR Public Gallery for verified
    /// accounts.</p>
    /// </note>
    pub fn logo_image_blob(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.logo_image_blob.as_ref()
    }
    /// <p>A detailed description of the contents of the repository. It is publicly visible in the
    /// Amazon ECR Public Gallery. The text must be in markdown format.</p>
    pub fn about_text(&self) -> std::option::Option<&str> {
        self.about_text.as_deref()
    }
    /// <p>Detailed information on how to use the contents of the repository. It is publicly
    /// visible in the Amazon ECR Public Gallery. The usage text provides context, support information,
    /// and additional usage details for users of the repository. The text must be in markdown
    /// format.</p>
    pub fn usage_text(&self) -> std::option::Option<&str> {
        self.usage_text.as_deref()
    }
}
impl std::fmt::Debug for RepositoryCatalogDataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryCatalogDataInput");
        formatter.field("description", &self.description);
        formatter.field("architectures", &self.architectures);
        formatter.field("operating_systems", &self.operating_systems);
        formatter.field("logo_image_blob", &self.logo_image_blob);
        formatter.field("about_text", &self.about_text);
        formatter.field("usage_text", &self.usage_text);
        formatter.finish()
    }
}
/// See [`RepositoryCatalogDataInput`](crate::model::RepositoryCatalogDataInput)
pub mod repository_catalog_data_input {
    /// A builder for [`RepositoryCatalogDataInput`](crate::model::RepositoryCatalogDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) architectures: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operating_systems: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) logo_image_blob: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) about_text: std::option::Option<std::string::String>,
        pub(crate) usage_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A short description of the contents of the repository. This text appears in both the
        /// image details and also when searching for repositories on the Amazon ECR Public Gallery.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A short description of the contents of the repository. This text appears in both the
        /// image details and also when searching for repositories on the Amazon ECR Public Gallery.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `architectures`.
        ///
        /// To override the contents of this collection use [`set_architectures`](Self::set_architectures).
        ///
        /// <p>The system architecture that the images in the repository are compatible with. On the
        /// Amazon ECR Public Gallery, the following supported architectures will appear as badges on the
        /// repository and are used as search filters.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Linux</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Windows</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>If an unsupported tag is added to your repository catalog data, it will be associated
        /// with the repository and can be retrieved using the API but will not be discoverable in
        /// the Amazon ECR Public Gallery.</p>
        /// </note>
        pub fn architectures(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.architectures.unwrap_or_default();
            v.push(input.into());
            self.architectures = Some(v);
            self
        }
        /// <p>The system architecture that the images in the repository are compatible with. On the
        /// Amazon ECR Public Gallery, the following supported architectures will appear as badges on the
        /// repository and are used as search filters.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Linux</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Windows</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>If an unsupported tag is added to your repository catalog data, it will be associated
        /// with the repository and can be retrieved using the API but will not be discoverable in
        /// the Amazon ECR Public Gallery.</p>
        /// </note>
        pub fn set_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.architectures = input;
            self
        }
        /// Appends an item to `operating_systems`.
        ///
        /// To override the contents of this collection use [`set_operating_systems`](Self::set_operating_systems).
        ///
        /// <p>The operating systems that the images in the repository are compatible with. On the
        /// Amazon ECR Public Gallery, the following supported operating systems will appear as badges on
        /// the repository and are used as search filters.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ARM</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ARM 64</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>x86</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>x86-64</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>If an unsupported tag is added to your repository catalog data, it will be associated
        /// with the repository and can be retrieved using the API but will not be discoverable in
        /// the Amazon ECR Public Gallery.</p>
        /// </note>
        pub fn operating_systems(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.operating_systems.unwrap_or_default();
            v.push(input.into());
            self.operating_systems = Some(v);
            self
        }
        /// <p>The operating systems that the images in the repository are compatible with. On the
        /// Amazon ECR Public Gallery, the following supported operating systems will appear as badges on
        /// the repository and are used as search filters.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ARM</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ARM 64</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>x86</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>x86-64</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>If an unsupported tag is added to your repository catalog data, it will be associated
        /// with the repository and can be retrieved using the API but will not be discoverable in
        /// the Amazon ECR Public Gallery.</p>
        /// </note>
        pub fn set_operating_systems(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.operating_systems = input;
            self
        }
        /// <p>The base64-encoded repository logo payload.</p>
        /// <note>
        /// <p>The repository logo is only publicly visible in the Amazon ECR Public Gallery for verified
        /// accounts.</p>
        /// </note>
        pub fn logo_image_blob(mut self, input: aws_smithy_types::Blob) -> Self {
            self.logo_image_blob = Some(input);
            self
        }
        /// <p>The base64-encoded repository logo payload.</p>
        /// <note>
        /// <p>The repository logo is only publicly visible in the Amazon ECR Public Gallery for verified
        /// accounts.</p>
        /// </note>
        pub fn set_logo_image_blob(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.logo_image_blob = input;
            self
        }
        /// <p>A detailed description of the contents of the repository. It is publicly visible in the
        /// Amazon ECR Public Gallery. The text must be in markdown format.</p>
        pub fn about_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.about_text = Some(input.into());
            self
        }
        /// <p>A detailed description of the contents of the repository. It is publicly visible in the
        /// Amazon ECR Public Gallery. The text must be in markdown format.</p>
        pub fn set_about_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.about_text = input;
            self
        }
        /// <p>Detailed information on how to use the contents of the repository. It is publicly
        /// visible in the Amazon ECR Public Gallery. The usage text provides context, support information,
        /// and additional usage details for users of the repository. The text must be in markdown
        /// format.</p>
        pub fn usage_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_text = Some(input.into());
            self
        }
        /// <p>Detailed information on how to use the contents of the repository. It is publicly
        /// visible in the Amazon ECR Public Gallery. The usage text provides context, support information,
        /// and additional usage details for users of the repository. The text must be in markdown
        /// format.</p>
        pub fn set_usage_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.usage_text = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryCatalogDataInput`](crate::model::RepositoryCatalogDataInput)
        pub fn build(self) -> crate::model::RepositoryCatalogDataInput {
            crate::model::RepositoryCatalogDataInput {
                description: self.description,
                architectures: self.architectures,
                operating_systems: self.operating_systems,
                logo_image_blob: self.logo_image_blob,
                about_text: self.about_text,
                usage_text: self.usage_text,
            }
        }
    }
}
impl RepositoryCatalogDataInput {
    /// Creates a new builder-style object to manufacture [`RepositoryCatalogDataInput`](crate::model::RepositoryCatalogDataInput)
    pub fn builder() -> crate::model::repository_catalog_data_input::Builder {
        crate::model::repository_catalog_data_input::Builder::default()
    }
}

/// <p>The metadata for a public registry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegistryCatalogData {
    /// <p>The display name for a public registry. This appears on the Amazon ECR Public Gallery.</p>
    /// <important>
    /// <p>Only accounts that have the verified account badge can have a registry display
    /// name.</p>
    /// </important>
    pub display_name: std::option::Option<std::string::String>,
}
impl RegistryCatalogData {
    /// <p>The display name for a public registry. This appears on the Amazon ECR Public Gallery.</p>
    /// <important>
    /// <p>Only accounts that have the verified account badge can have a registry display
    /// name.</p>
    /// </important>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
}
impl std::fmt::Debug for RegistryCatalogData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegistryCatalogData");
        formatter.field("display_name", &self.display_name);
        formatter.finish()
    }
}
/// See [`RegistryCatalogData`](crate::model::RegistryCatalogData)
pub mod registry_catalog_data {
    /// A builder for [`RegistryCatalogData`](crate::model::RegistryCatalogData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) display_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The display name for a public registry. This appears on the Amazon ECR Public Gallery.</p>
        /// <important>
        /// <p>Only accounts that have the verified account badge can have a registry display
        /// name.</p>
        /// </important>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The display name for a public registry. This appears on the Amazon ECR Public Gallery.</p>
        /// <important>
        /// <p>Only accounts that have the verified account badge can have a registry display
        /// name.</p>
        /// </important>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RegistryCatalogData`](crate::model::RegistryCatalogData)
        pub fn build(self) -> crate::model::RegistryCatalogData {
            crate::model::RegistryCatalogData {
                display_name: self.display_name,
            }
        }
    }
}
impl RegistryCatalogData {
    /// Creates a new builder-style object to manufacture [`RegistryCatalogData`](crate::model::RegistryCatalogData)
    pub fn builder() -> crate::model::registry_catalog_data::Builder {
        crate::model::registry_catalog_data::Builder::default()
    }
}

/// <p>An object representing an Amazon ECR image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Image {
    /// <p>The AWS account ID associated with the registry containing the image.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository associated with the image.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>An object containing the image tag and image digest associated with an image.</p>
    pub image_id: std::option::Option<crate::model::ImageIdentifier>,
    /// <p>The image manifest associated with the image.</p>
    pub image_manifest: std::option::Option<std::string::String>,
    /// <p>The manifest media type of the image.</p>
    pub image_manifest_media_type: std::option::Option<std::string::String>,
}
impl Image {
    /// <p>The AWS account ID associated with the registry containing the image.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository associated with the image.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>An object containing the image tag and image digest associated with an image.</p>
    pub fn image_id(&self) -> std::option::Option<&crate::model::ImageIdentifier> {
        self.image_id.as_ref()
    }
    /// <p>The image manifest associated with the image.</p>
    pub fn image_manifest(&self) -> std::option::Option<&str> {
        self.image_manifest.as_deref()
    }
    /// <p>The manifest media type of the image.</p>
    pub fn image_manifest_media_type(&self) -> std::option::Option<&str> {
        self.image_manifest_media_type.as_deref()
    }
}
impl std::fmt::Debug for Image {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Image");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_id", &self.image_id);
        formatter.field("image_manifest", &self.image_manifest);
        formatter.field("image_manifest_media_type", &self.image_manifest_media_type);
        formatter.finish()
    }
}
/// See [`Image`](crate::model::Image)
pub mod image {
    /// A builder for [`Image`](crate::model::Image)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_id: std::option::Option<crate::model::ImageIdentifier>,
        pub(crate) image_manifest: std::option::Option<std::string::String>,
        pub(crate) image_manifest_media_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the registry containing the image.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the registry containing the image.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository associated with the image.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository associated with the image.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>An object containing the image tag and image digest associated with an image.</p>
        pub fn image_id(mut self, input: crate::model::ImageIdentifier) -> Self {
            self.image_id = Some(input);
            self
        }
        /// <p>An object containing the image tag and image digest associated with an image.</p>
        pub fn set_image_id(
            mut self,
            input: std::option::Option<crate::model::ImageIdentifier>,
        ) -> Self {
            self.image_id = input;
            self
        }
        /// <p>The image manifest associated with the image.</p>
        pub fn image_manifest(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_manifest = Some(input.into());
            self
        }
        /// <p>The image manifest associated with the image.</p>
        pub fn set_image_manifest(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_manifest = input;
            self
        }
        /// <p>The manifest media type of the image.</p>
        pub fn image_manifest_media_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_manifest_media_type = Some(input.into());
            self
        }
        /// <p>The manifest media type of the image.</p>
        pub fn set_image_manifest_media_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_manifest_media_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Image`](crate::model::Image)
        pub fn build(self) -> crate::model::Image {
            crate::model::Image {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                image_id: self.image_id,
                image_manifest: self.image_manifest,
                image_manifest_media_type: self.image_manifest_media_type,
            }
        }
    }
}
impl Image {
    /// Creates a new builder-style object to manufacture [`Image`](crate::model::Image)
    pub fn builder() -> crate::model::image::Builder {
        crate::model::image::Builder::default()
    }
}

/// <p>An object with identifying information for an Amazon ECR image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageIdentifier {
    /// <p>The <code>sha256</code> digest of the image manifest.</p>
    pub image_digest: std::option::Option<std::string::String>,
    /// <p>The tag used for the image.</p>
    pub image_tag: std::option::Option<std::string::String>,
}
impl ImageIdentifier {
    /// <p>The <code>sha256</code> digest of the image manifest.</p>
    pub fn image_digest(&self) -> std::option::Option<&str> {
        self.image_digest.as_deref()
    }
    /// <p>The tag used for the image.</p>
    pub fn image_tag(&self) -> std::option::Option<&str> {
        self.image_tag.as_deref()
    }
}
impl std::fmt::Debug for ImageIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageIdentifier");
        formatter.field("image_digest", &self.image_digest);
        formatter.field("image_tag", &self.image_tag);
        formatter.finish()
    }
}
/// See [`ImageIdentifier`](crate::model::ImageIdentifier)
pub mod image_identifier {
    /// A builder for [`ImageIdentifier`](crate::model::ImageIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_digest: std::option::Option<std::string::String>,
        pub(crate) image_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>sha256</code> digest of the image manifest.</p>
        pub fn image_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_digest = Some(input.into());
            self
        }
        /// <p>The <code>sha256</code> digest of the image manifest.</p>
        pub fn set_image_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_digest = input;
            self
        }
        /// <p>The tag used for the image.</p>
        pub fn image_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_tag = Some(input.into());
            self
        }
        /// <p>The tag used for the image.</p>
        pub fn set_image_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageIdentifier`](crate::model::ImageIdentifier)
        pub fn build(self) -> crate::model::ImageIdentifier {
            crate::model::ImageIdentifier {
                image_digest: self.image_digest,
                image_tag: self.image_tag,
            }
        }
    }
}
impl ImageIdentifier {
    /// Creates a new builder-style object to manufacture [`ImageIdentifier`](crate::model::ImageIdentifier)
    pub fn builder() -> crate::model::image_identifier::Builder {
        crate::model::image_identifier::Builder::default()
    }
}

/// <p>An authorization token data object that corresponds to a public registry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizationData {
    /// <p>A base64-encoded string that contains authorization data for a public Amazon ECR registry.
    /// When the string is decoded, it is presented in the format <code>user:password</code> for
    /// public registry authentication using <code>docker login</code>.</p>
    pub authorization_token: std::option::Option<std::string::String>,
    /// <p>The Unix time in seconds and milliseconds when the authorization token expires.
    /// Authorization tokens are valid for 12 hours.</p>
    pub expires_at: std::option::Option<aws_smithy_types::Instant>,
}
impl AuthorizationData {
    /// <p>A base64-encoded string that contains authorization data for a public Amazon ECR registry.
    /// When the string is decoded, it is presented in the format <code>user:password</code> for
    /// public registry authentication using <code>docker login</code>.</p>
    pub fn authorization_token(&self) -> std::option::Option<&str> {
        self.authorization_token.as_deref()
    }
    /// <p>The Unix time in seconds and milliseconds when the authorization token expires.
    /// Authorization tokens are valid for 12 hours.</p>
    pub fn expires_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.expires_at.as_ref()
    }
}
impl std::fmt::Debug for AuthorizationData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizationData");
        formatter.field("authorization_token", &self.authorization_token);
        formatter.field("expires_at", &self.expires_at);
        formatter.finish()
    }
}
/// See [`AuthorizationData`](crate::model::AuthorizationData)
pub mod authorization_data {
    /// A builder for [`AuthorizationData`](crate::model::AuthorizationData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorization_token: std::option::Option<std::string::String>,
        pub(crate) expires_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>A base64-encoded string that contains authorization data for a public Amazon ECR registry.
        /// When the string is decoded, it is presented in the format <code>user:password</code> for
        /// public registry authentication using <code>docker login</code>.</p>
        pub fn authorization_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorization_token = Some(input.into());
            self
        }
        /// <p>A base64-encoded string that contains authorization data for a public Amazon ECR registry.
        /// When the string is decoded, it is presented in the format <code>user:password</code> for
        /// public registry authentication using <code>docker login</code>.</p>
        pub fn set_authorization_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorization_token = input;
            self
        }
        /// <p>The Unix time in seconds and milliseconds when the authorization token expires.
        /// Authorization tokens are valid for 12 hours.</p>
        pub fn expires_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expires_at = Some(input);
            self
        }
        /// <p>The Unix time in seconds and milliseconds when the authorization token expires.
        /// Authorization tokens are valid for 12 hours.</p>
        pub fn set_expires_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expires_at = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizationData`](crate::model::AuthorizationData)
        pub fn build(self) -> crate::model::AuthorizationData {
            crate::model::AuthorizationData {
                authorization_token: self.authorization_token,
                expires_at: self.expires_at,
            }
        }
    }
}
impl AuthorizationData {
    /// Creates a new builder-style object to manufacture [`AuthorizationData`](crate::model::AuthorizationData)
    pub fn builder() -> crate::model::authorization_data::Builder {
        crate::model::authorization_data::Builder::default()
    }
}

/// <p>An object representing a repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Repository {
    /// <p>The Amazon Resource Name (ARN) that identifies the repository. The ARN contains the <code>arn:aws:ecr</code> namespace, followed by the region of the repository, AWS account ID of the repository owner, repository namespace, and repository name. For example, <code>arn:aws:ecr:region:012345678910:repository/test</code>.</p>
    pub repository_arn: std::option::Option<std::string::String>,
    /// <p>The AWS account ID associated with the public registry that contains the
    /// repository.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The URI for the repository. You can use this URI for container image <code>push</code>
    /// and <code>pull</code> operations.</p>
    pub repository_uri: std::option::Option<std::string::String>,
    /// <p>The date and time, in JavaScript date format, when the repository was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
}
impl Repository {
    /// <p>The Amazon Resource Name (ARN) that identifies the repository. The ARN contains the <code>arn:aws:ecr</code> namespace, followed by the region of the repository, AWS account ID of the repository owner, repository namespace, and repository name. For example, <code>arn:aws:ecr:region:012345678910:repository/test</code>.</p>
    pub fn repository_arn(&self) -> std::option::Option<&str> {
        self.repository_arn.as_deref()
    }
    /// <p>The AWS account ID associated with the public registry that contains the
    /// repository.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The URI for the repository. You can use this URI for container image <code>push</code>
    /// and <code>pull</code> operations.</p>
    pub fn repository_uri(&self) -> std::option::Option<&str> {
        self.repository_uri.as_deref()
    }
    /// <p>The date and time, in JavaScript date format, when the repository was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
}
impl std::fmt::Debug for Repository {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Repository");
        formatter.field("repository_arn", &self.repository_arn);
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("repository_uri", &self.repository_uri);
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`Repository`](crate::model::Repository)
pub mod repository {
    /// A builder for [`Repository`](crate::model::Repository)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_arn: std::option::Option<std::string::String>,
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) repository_uri: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the repository. The ARN contains the <code>arn:aws:ecr</code> namespace, followed by the region of the repository, AWS account ID of the repository owner, repository namespace, and repository name. For example, <code>arn:aws:ecr:region:012345678910:repository/test</code>.</p>
        pub fn repository_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the repository. The ARN contains the <code>arn:aws:ecr</code> namespace, followed by the region of the repository, AWS account ID of the repository owner, repository namespace, and repository name. For example, <code>arn:aws:ecr:region:012345678910:repository/test</code>.</p>
        pub fn set_repository_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_arn = input;
            self
        }
        /// <p>The AWS account ID associated with the public registry that contains the
        /// repository.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the public registry that contains the
        /// repository.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The URI for the repository. You can use this URI for container image <code>push</code>
        /// and <code>pull</code> operations.</p>
        pub fn repository_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_uri = Some(input.into());
            self
        }
        /// <p>The URI for the repository. You can use this URI for container image <code>push</code>
        /// and <code>pull</code> operations.</p>
        pub fn set_repository_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_uri = input;
            self
        }
        /// <p>The date and time, in JavaScript date format, when the repository was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time, in JavaScript date format, when the repository was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`Repository`](crate::model::Repository)
        pub fn build(self) -> crate::model::Repository {
            crate::model::Repository {
                repository_arn: self.repository_arn,
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                repository_uri: self.repository_uri,
                created_at: self.created_at,
            }
        }
    }
}
impl Repository {
    /// Creates a new builder-style object to manufacture [`Repository`](crate::model::Repository)
    pub fn builder() -> crate::model::repository::Builder {
        crate::model::repository::Builder::default()
    }
}

/// <p>The details of a public registry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Registry {
    /// <p>The AWS account ID associated with the registry. If you do not specify a registry, the default public registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the public registry.</p>
    pub registry_arn: std::option::Option<std::string::String>,
    /// <p>The URI of a public registry. The URI contains a universal prefix and the registry
    /// alias.</p>
    pub registry_uri: std::option::Option<std::string::String>,
    /// <p>Whether the account is verified. This indicates whether the account is an AWS
    /// Marketplace vendor. If an account is verified, each public repository will received a
    /// verified account badge on the Amazon ECR Public Gallery.</p>
    pub verified: std::option::Option<bool>,
    /// <p>An array of objects representing the aliases for a public registry.</p>
    pub aliases: std::option::Option<std::vec::Vec<crate::model::RegistryAlias>>,
}
impl Registry {
    /// <p>The AWS account ID associated with the registry. If you do not specify a registry, the default public registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the public registry.</p>
    pub fn registry_arn(&self) -> std::option::Option<&str> {
        self.registry_arn.as_deref()
    }
    /// <p>The URI of a public registry. The URI contains a universal prefix and the registry
    /// alias.</p>
    pub fn registry_uri(&self) -> std::option::Option<&str> {
        self.registry_uri.as_deref()
    }
    /// <p>Whether the account is verified. This indicates whether the account is an AWS
    /// Marketplace vendor. If an account is verified, each public repository will received a
    /// verified account badge on the Amazon ECR Public Gallery.</p>
    pub fn verified(&self) -> std::option::Option<bool> {
        self.verified
    }
    /// <p>An array of objects representing the aliases for a public registry.</p>
    pub fn aliases(&self) -> std::option::Option<&[crate::model::RegistryAlias]> {
        self.aliases.as_deref()
    }
}
impl std::fmt::Debug for Registry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Registry");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("registry_arn", &self.registry_arn);
        formatter.field("registry_uri", &self.registry_uri);
        formatter.field("verified", &self.verified);
        formatter.field("aliases", &self.aliases);
        formatter.finish()
    }
}
/// See [`Registry`](crate::model::Registry)
pub mod registry {
    /// A builder for [`Registry`](crate::model::Registry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) registry_arn: std::option::Option<std::string::String>,
        pub(crate) registry_uri: std::option::Option<std::string::String>,
        pub(crate) verified: std::option::Option<bool>,
        pub(crate) aliases: std::option::Option<std::vec::Vec<crate::model::RegistryAlias>>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the registry. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the registry. If you do not specify a registry, the default public registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the public registry.</p>
        pub fn registry_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the public registry.</p>
        pub fn set_registry_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_arn = input;
            self
        }
        /// <p>The URI of a public registry. The URI contains a universal prefix and the registry
        /// alias.</p>
        pub fn registry_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_uri = Some(input.into());
            self
        }
        /// <p>The URI of a public registry. The URI contains a universal prefix and the registry
        /// alias.</p>
        pub fn set_registry_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_uri = input;
            self
        }
        /// <p>Whether the account is verified. This indicates whether the account is an AWS
        /// Marketplace vendor. If an account is verified, each public repository will received a
        /// verified account badge on the Amazon ECR Public Gallery.</p>
        pub fn verified(mut self, input: bool) -> Self {
            self.verified = Some(input);
            self
        }
        /// <p>Whether the account is verified. This indicates whether the account is an AWS
        /// Marketplace vendor. If an account is verified, each public repository will received a
        /// verified account badge on the Amazon ECR Public Gallery.</p>
        pub fn set_verified(mut self, input: std::option::Option<bool>) -> Self {
            self.verified = input;
            self
        }
        /// Appends an item to `aliases`.
        ///
        /// To override the contents of this collection use [`set_aliases`](Self::set_aliases).
        ///
        /// <p>An array of objects representing the aliases for a public registry.</p>
        pub fn aliases(mut self, input: impl Into<crate::model::RegistryAlias>) -> Self {
            let mut v = self.aliases.unwrap_or_default();
            v.push(input.into());
            self.aliases = Some(v);
            self
        }
        /// <p>An array of objects representing the aliases for a public registry.</p>
        pub fn set_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegistryAlias>>,
        ) -> Self {
            self.aliases = input;
            self
        }
        /// Consumes the builder and constructs a [`Registry`](crate::model::Registry)
        pub fn build(self) -> crate::model::Registry {
            crate::model::Registry {
                registry_id: self.registry_id,
                registry_arn: self.registry_arn,
                registry_uri: self.registry_uri,
                verified: self.verified,
                aliases: self.aliases,
            }
        }
    }
}
impl Registry {
    /// Creates a new builder-style object to manufacture [`Registry`](crate::model::Registry)
    pub fn builder() -> crate::model::registry::Builder {
        crate::model::registry::Builder::default()
    }
}

/// <p>An object representing the aliases for a public registry. A public registry is given an
/// alias upon creation but a custom alias can be set using the Amazon ECR console. For more
/// information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Registries.html">Registries</a> in the
/// <i>Amazon Elastic Container Registry User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegistryAlias {
    /// <p>The name of the registry alias.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the registry alias.</p>
    pub status: std::option::Option<crate::model::RegistryAliasStatus>,
    /// <p>Whether or not the registry alias is the primary alias for the registry. If true, the
    /// alias is the primary registry alias and is displayed in both the repository URL and the
    /// image URI used in the <code>docker pull</code> commands on the Amazon ECR Public Gallery.</p>
    /// <note>
    /// <p>A registry alias that is not the primary registry alias can be used in the repository
    /// URI in a <code>docker pull</code> command.</p>
    /// </note>
    pub primary_registry_alias: bool,
    /// <p>Whether or not the registry alias is the default alias for the registry. When the first
    /// public repository is created, your public registry is assigned a default registry
    /// alias.</p>
    pub default_registry_alias: bool,
}
impl RegistryAlias {
    /// <p>The name of the registry alias.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the registry alias.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RegistryAliasStatus> {
        self.status.as_ref()
    }
    /// <p>Whether or not the registry alias is the primary alias for the registry. If true, the
    /// alias is the primary registry alias and is displayed in both the repository URL and the
    /// image URI used in the <code>docker pull</code> commands on the Amazon ECR Public Gallery.</p>
    /// <note>
    /// <p>A registry alias that is not the primary registry alias can be used in the repository
    /// URI in a <code>docker pull</code> command.</p>
    /// </note>
    pub fn primary_registry_alias(&self) -> bool {
        self.primary_registry_alias
    }
    /// <p>Whether or not the registry alias is the default alias for the registry. When the first
    /// public repository is created, your public registry is assigned a default registry
    /// alias.</p>
    pub fn default_registry_alias(&self) -> bool {
        self.default_registry_alias
    }
}
impl std::fmt::Debug for RegistryAlias {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegistryAlias");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("primary_registry_alias", &self.primary_registry_alias);
        formatter.field("default_registry_alias", &self.default_registry_alias);
        formatter.finish()
    }
}
/// See [`RegistryAlias`](crate::model::RegistryAlias)
pub mod registry_alias {
    /// A builder for [`RegistryAlias`](crate::model::RegistryAlias)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RegistryAliasStatus>,
        pub(crate) primary_registry_alias: std::option::Option<bool>,
        pub(crate) default_registry_alias: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the registry alias.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the registry alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the registry alias.</p>
        pub fn status(mut self, input: crate::model::RegistryAliasStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the registry alias.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RegistryAliasStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Whether or not the registry alias is the primary alias for the registry. If true, the
        /// alias is the primary registry alias and is displayed in both the repository URL and the
        /// image URI used in the <code>docker pull</code> commands on the Amazon ECR Public Gallery.</p>
        /// <note>
        /// <p>A registry alias that is not the primary registry alias can be used in the repository
        /// URI in a <code>docker pull</code> command.</p>
        /// </note>
        pub fn primary_registry_alias(mut self, input: bool) -> Self {
            self.primary_registry_alias = Some(input);
            self
        }
        /// <p>Whether or not the registry alias is the primary alias for the registry. If true, the
        /// alias is the primary registry alias and is displayed in both the repository URL and the
        /// image URI used in the <code>docker pull</code> commands on the Amazon ECR Public Gallery.</p>
        /// <note>
        /// <p>A registry alias that is not the primary registry alias can be used in the repository
        /// URI in a <code>docker pull</code> command.</p>
        /// </note>
        pub fn set_primary_registry_alias(mut self, input: std::option::Option<bool>) -> Self {
            self.primary_registry_alias = input;
            self
        }
        /// <p>Whether or not the registry alias is the default alias for the registry. When the first
        /// public repository is created, your public registry is assigned a default registry
        /// alias.</p>
        pub fn default_registry_alias(mut self, input: bool) -> Self {
            self.default_registry_alias = Some(input);
            self
        }
        /// <p>Whether or not the registry alias is the default alias for the registry. When the first
        /// public repository is created, your public registry is assigned a default registry
        /// alias.</p>
        pub fn set_default_registry_alias(mut self, input: std::option::Option<bool>) -> Self {
            self.default_registry_alias = input;
            self
        }
        /// Consumes the builder and constructs a [`RegistryAlias`](crate::model::RegistryAlias)
        pub fn build(self) -> crate::model::RegistryAlias {
            crate::model::RegistryAlias {
                name: self.name,
                status: self.status,
                primary_registry_alias: self.primary_registry_alias.unwrap_or_default(),
                default_registry_alias: self.default_registry_alias.unwrap_or_default(),
            }
        }
    }
}
impl RegistryAlias {
    /// Creates a new builder-style object to manufacture [`RegistryAlias`](crate::model::RegistryAlias)
    pub fn builder() -> crate::model::registry_alias::Builder {
        crate::model::registry_alias::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RegistryAliasStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RegistryAliasStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => RegistryAliasStatus::Active,
            "PENDING" => RegistryAliasStatus::Pending,
            "REJECTED" => RegistryAliasStatus::Rejected,
            other => RegistryAliasStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RegistryAliasStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RegistryAliasStatus::from(s))
    }
}
impl RegistryAliasStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RegistryAliasStatus::Active => "ACTIVE",
            RegistryAliasStatus::Pending => "PENDING",
            RegistryAliasStatus::Rejected => "REJECTED",
            RegistryAliasStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "PENDING", "REJECTED"]
    }
}
impl AsRef<str> for RegistryAliasStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing the image tag details for an image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageTagDetail {
    /// <p>The tag associated with the image.</p>
    pub image_tag: std::option::Option<std::string::String>,
    /// <p>The time stamp indicating when the image tag was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>An object that describes the details of an image.</p>
    pub image_detail: std::option::Option<crate::model::ReferencedImageDetail>,
}
impl ImageTagDetail {
    /// <p>The tag associated with the image.</p>
    pub fn image_tag(&self) -> std::option::Option<&str> {
        self.image_tag.as_deref()
    }
    /// <p>The time stamp indicating when the image tag was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>An object that describes the details of an image.</p>
    pub fn image_detail(&self) -> std::option::Option<&crate::model::ReferencedImageDetail> {
        self.image_detail.as_ref()
    }
}
impl std::fmt::Debug for ImageTagDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageTagDetail");
        formatter.field("image_tag", &self.image_tag);
        formatter.field("created_at", &self.created_at);
        formatter.field("image_detail", &self.image_detail);
        formatter.finish()
    }
}
/// See [`ImageTagDetail`](crate::model::ImageTagDetail)
pub mod image_tag_detail {
    /// A builder for [`ImageTagDetail`](crate::model::ImageTagDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_tag: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) image_detail: std::option::Option<crate::model::ReferencedImageDetail>,
    }
    impl Builder {
        /// <p>The tag associated with the image.</p>
        pub fn image_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_tag = Some(input.into());
            self
        }
        /// <p>The tag associated with the image.</p>
        pub fn set_image_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_tag = input;
            self
        }
        /// <p>The time stamp indicating when the image tag was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time stamp indicating when the image tag was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>An object that describes the details of an image.</p>
        pub fn image_detail(mut self, input: crate::model::ReferencedImageDetail) -> Self {
            self.image_detail = Some(input);
            self
        }
        /// <p>An object that describes the details of an image.</p>
        pub fn set_image_detail(
            mut self,
            input: std::option::Option<crate::model::ReferencedImageDetail>,
        ) -> Self {
            self.image_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageTagDetail`](crate::model::ImageTagDetail)
        pub fn build(self) -> crate::model::ImageTagDetail {
            crate::model::ImageTagDetail {
                image_tag: self.image_tag,
                created_at: self.created_at,
                image_detail: self.image_detail,
            }
        }
    }
}
impl ImageTagDetail {
    /// Creates a new builder-style object to manufacture [`ImageTagDetail`](crate::model::ImageTagDetail)
    pub fn builder() -> crate::model::image_tag_detail::Builder {
        crate::model::image_tag_detail::Builder::default()
    }
}

/// <p>An object that describes the image tag details returned by a <a>DescribeImageTags</a> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReferencedImageDetail {
    /// <p>The <code>sha256</code> digest of the image manifest.</p>
    pub image_digest: std::option::Option<std::string::String>,
    /// <p>The size, in bytes, of the image in the repository.</p>
    /// <p>If the image is a manifest list, this will be the max size of all manifests in the
    /// list.</p>
    /// <note>
    /// <p>Beginning with Docker version 1.9, the Docker client compresses image layers before
    /// pushing them to a V2 Docker registry. The output of the <code>docker images</code>
    /// command shows the uncompressed image size, so it may return a larger image size than the
    /// image sizes returned by <a>DescribeImages</a>.</p>
    /// </note>
    pub image_size_in_bytes: std::option::Option<i64>,
    /// <p>The date and time, expressed in standard JavaScript date format, at which the current
    /// image tag was pushed to the repository.</p>
    pub image_pushed_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The media type of the image manifest.</p>
    pub image_manifest_media_type: std::option::Option<std::string::String>,
    /// <p>The artifact media type of the image.</p>
    pub artifact_media_type: std::option::Option<std::string::String>,
}
impl ReferencedImageDetail {
    /// <p>The <code>sha256</code> digest of the image manifest.</p>
    pub fn image_digest(&self) -> std::option::Option<&str> {
        self.image_digest.as_deref()
    }
    /// <p>The size, in bytes, of the image in the repository.</p>
    /// <p>If the image is a manifest list, this will be the max size of all manifests in the
    /// list.</p>
    /// <note>
    /// <p>Beginning with Docker version 1.9, the Docker client compresses image layers before
    /// pushing them to a V2 Docker registry. The output of the <code>docker images</code>
    /// command shows the uncompressed image size, so it may return a larger image size than the
    /// image sizes returned by <a>DescribeImages</a>.</p>
    /// </note>
    pub fn image_size_in_bytes(&self) -> std::option::Option<i64> {
        self.image_size_in_bytes
    }
    /// <p>The date and time, expressed in standard JavaScript date format, at which the current
    /// image tag was pushed to the repository.</p>
    pub fn image_pushed_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.image_pushed_at.as_ref()
    }
    /// <p>The media type of the image manifest.</p>
    pub fn image_manifest_media_type(&self) -> std::option::Option<&str> {
        self.image_manifest_media_type.as_deref()
    }
    /// <p>The artifact media type of the image.</p>
    pub fn artifact_media_type(&self) -> std::option::Option<&str> {
        self.artifact_media_type.as_deref()
    }
}
impl std::fmt::Debug for ReferencedImageDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReferencedImageDetail");
        formatter.field("image_digest", &self.image_digest);
        formatter.field("image_size_in_bytes", &self.image_size_in_bytes);
        formatter.field("image_pushed_at", &self.image_pushed_at);
        formatter.field("image_manifest_media_type", &self.image_manifest_media_type);
        formatter.field("artifact_media_type", &self.artifact_media_type);
        formatter.finish()
    }
}
/// See [`ReferencedImageDetail`](crate::model::ReferencedImageDetail)
pub mod referenced_image_detail {
    /// A builder for [`ReferencedImageDetail`](crate::model::ReferencedImageDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_digest: std::option::Option<std::string::String>,
        pub(crate) image_size_in_bytes: std::option::Option<i64>,
        pub(crate) image_pushed_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) image_manifest_media_type: std::option::Option<std::string::String>,
        pub(crate) artifact_media_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>sha256</code> digest of the image manifest.</p>
        pub fn image_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_digest = Some(input.into());
            self
        }
        /// <p>The <code>sha256</code> digest of the image manifest.</p>
        pub fn set_image_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_digest = input;
            self
        }
        /// <p>The size, in bytes, of the image in the repository.</p>
        /// <p>If the image is a manifest list, this will be the max size of all manifests in the
        /// list.</p>
        /// <note>
        /// <p>Beginning with Docker version 1.9, the Docker client compresses image layers before
        /// pushing them to a V2 Docker registry. The output of the <code>docker images</code>
        /// command shows the uncompressed image size, so it may return a larger image size than the
        /// image sizes returned by <a>DescribeImages</a>.</p>
        /// </note>
        pub fn image_size_in_bytes(mut self, input: i64) -> Self {
            self.image_size_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of the image in the repository.</p>
        /// <p>If the image is a manifest list, this will be the max size of all manifests in the
        /// list.</p>
        /// <note>
        /// <p>Beginning with Docker version 1.9, the Docker client compresses image layers before
        /// pushing them to a V2 Docker registry. The output of the <code>docker images</code>
        /// command shows the uncompressed image size, so it may return a larger image size than the
        /// image sizes returned by <a>DescribeImages</a>.</p>
        /// </note>
        pub fn set_image_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.image_size_in_bytes = input;
            self
        }
        /// <p>The date and time, expressed in standard JavaScript date format, at which the current
        /// image tag was pushed to the repository.</p>
        pub fn image_pushed_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.image_pushed_at = Some(input);
            self
        }
        /// <p>The date and time, expressed in standard JavaScript date format, at which the current
        /// image tag was pushed to the repository.</p>
        pub fn set_image_pushed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.image_pushed_at = input;
            self
        }
        /// <p>The media type of the image manifest.</p>
        pub fn image_manifest_media_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_manifest_media_type = Some(input.into());
            self
        }
        /// <p>The media type of the image manifest.</p>
        pub fn set_image_manifest_media_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_manifest_media_type = input;
            self
        }
        /// <p>The artifact media type of the image.</p>
        pub fn artifact_media_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_media_type = Some(input.into());
            self
        }
        /// <p>The artifact media type of the image.</p>
        pub fn set_artifact_media_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.artifact_media_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ReferencedImageDetail`](crate::model::ReferencedImageDetail)
        pub fn build(self) -> crate::model::ReferencedImageDetail {
            crate::model::ReferencedImageDetail {
                image_digest: self.image_digest,
                image_size_in_bytes: self.image_size_in_bytes,
                image_pushed_at: self.image_pushed_at,
                image_manifest_media_type: self.image_manifest_media_type,
                artifact_media_type: self.artifact_media_type,
            }
        }
    }
}
impl ReferencedImageDetail {
    /// Creates a new builder-style object to manufacture [`ReferencedImageDetail`](crate::model::ReferencedImageDetail)
    pub fn builder() -> crate::model::referenced_image_detail::Builder {
        crate::model::referenced_image_detail::Builder::default()
    }
}

/// <p>An object that describes an image returned by a <a>DescribeImages</a>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageDetail {
    /// <p>The AWS account ID associated with the public registry to which this image
    /// belongs.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository to which this image belongs.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The <code>sha256</code> digest of the image manifest.</p>
    pub image_digest: std::option::Option<std::string::String>,
    /// <p>The list of tags associated with this image.</p>
    pub image_tags: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The size, in bytes, of the image in the repository.</p>
    /// <p>If the image is a manifest list, this will be the max size of all manifests in the
    /// list.</p>
    /// <note>
    /// <p>Beginning with Docker version 1.9, the Docker client compresses image layers before
    /// pushing them to a V2 Docker registry. The output of the <code>docker images</code>
    /// command shows the uncompressed image size, so it may return a larger image size than the
    /// image sizes returned by <a>DescribeImages</a>.</p>
    /// </note>
    pub image_size_in_bytes: std::option::Option<i64>,
    /// <p>The date and time, expressed in standard JavaScript date format, at which the current
    /// image was pushed to the repository. </p>
    pub image_pushed_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The media type of the image manifest.</p>
    pub image_manifest_media_type: std::option::Option<std::string::String>,
    /// <p>The artifact media type of the image.</p>
    pub artifact_media_type: std::option::Option<std::string::String>,
}
impl ImageDetail {
    /// <p>The AWS account ID associated with the public registry to which this image
    /// belongs.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository to which this image belongs.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The <code>sha256</code> digest of the image manifest.</p>
    pub fn image_digest(&self) -> std::option::Option<&str> {
        self.image_digest.as_deref()
    }
    /// <p>The list of tags associated with this image.</p>
    pub fn image_tags(&self) -> std::option::Option<&[std::string::String]> {
        self.image_tags.as_deref()
    }
    /// <p>The size, in bytes, of the image in the repository.</p>
    /// <p>If the image is a manifest list, this will be the max size of all manifests in the
    /// list.</p>
    /// <note>
    /// <p>Beginning with Docker version 1.9, the Docker client compresses image layers before
    /// pushing them to a V2 Docker registry. The output of the <code>docker images</code>
    /// command shows the uncompressed image size, so it may return a larger image size than the
    /// image sizes returned by <a>DescribeImages</a>.</p>
    /// </note>
    pub fn image_size_in_bytes(&self) -> std::option::Option<i64> {
        self.image_size_in_bytes
    }
    /// <p>The date and time, expressed in standard JavaScript date format, at which the current
    /// image was pushed to the repository. </p>
    pub fn image_pushed_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.image_pushed_at.as_ref()
    }
    /// <p>The media type of the image manifest.</p>
    pub fn image_manifest_media_type(&self) -> std::option::Option<&str> {
        self.image_manifest_media_type.as_deref()
    }
    /// <p>The artifact media type of the image.</p>
    pub fn artifact_media_type(&self) -> std::option::Option<&str> {
        self.artifact_media_type.as_deref()
    }
}
impl std::fmt::Debug for ImageDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageDetail");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_digest", &self.image_digest);
        formatter.field("image_tags", &self.image_tags);
        formatter.field("image_size_in_bytes", &self.image_size_in_bytes);
        formatter.field("image_pushed_at", &self.image_pushed_at);
        formatter.field("image_manifest_media_type", &self.image_manifest_media_type);
        formatter.field("artifact_media_type", &self.artifact_media_type);
        formatter.finish()
    }
}
/// See [`ImageDetail`](crate::model::ImageDetail)
pub mod image_detail {
    /// A builder for [`ImageDetail`](crate::model::ImageDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_digest: std::option::Option<std::string::String>,
        pub(crate) image_tags: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) image_size_in_bytes: std::option::Option<i64>,
        pub(crate) image_pushed_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) image_manifest_media_type: std::option::Option<std::string::String>,
        pub(crate) artifact_media_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the public registry to which this image
        /// belongs.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the public registry to which this image
        /// belongs.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository to which this image belongs.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to which this image belongs.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The <code>sha256</code> digest of the image manifest.</p>
        pub fn image_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_digest = Some(input.into());
            self
        }
        /// <p>The <code>sha256</code> digest of the image manifest.</p>
        pub fn set_image_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_digest = input;
            self
        }
        /// Appends an item to `image_tags`.
        ///
        /// To override the contents of this collection use [`set_image_tags`](Self::set_image_tags).
        ///
        /// <p>The list of tags associated with this image.</p>
        pub fn image_tags(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.image_tags.unwrap_or_default();
            v.push(input.into());
            self.image_tags = Some(v);
            self
        }
        /// <p>The list of tags associated with this image.</p>
        pub fn set_image_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.image_tags = input;
            self
        }
        /// <p>The size, in bytes, of the image in the repository.</p>
        /// <p>If the image is a manifest list, this will be the max size of all manifests in the
        /// list.</p>
        /// <note>
        /// <p>Beginning with Docker version 1.9, the Docker client compresses image layers before
        /// pushing them to a V2 Docker registry. The output of the <code>docker images</code>
        /// command shows the uncompressed image size, so it may return a larger image size than the
        /// image sizes returned by <a>DescribeImages</a>.</p>
        /// </note>
        pub fn image_size_in_bytes(mut self, input: i64) -> Self {
            self.image_size_in_bytes = Some(input);
            self
        }
        /// <p>The size, in bytes, of the image in the repository.</p>
        /// <p>If the image is a manifest list, this will be the max size of all manifests in the
        /// list.</p>
        /// <note>
        /// <p>Beginning with Docker version 1.9, the Docker client compresses image layers before
        /// pushing them to a V2 Docker registry. The output of the <code>docker images</code>
        /// command shows the uncompressed image size, so it may return a larger image size than the
        /// image sizes returned by <a>DescribeImages</a>.</p>
        /// </note>
        pub fn set_image_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.image_size_in_bytes = input;
            self
        }
        /// <p>The date and time, expressed in standard JavaScript date format, at which the current
        /// image was pushed to the repository. </p>
        pub fn image_pushed_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.image_pushed_at = Some(input);
            self
        }
        /// <p>The date and time, expressed in standard JavaScript date format, at which the current
        /// image was pushed to the repository. </p>
        pub fn set_image_pushed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.image_pushed_at = input;
            self
        }
        /// <p>The media type of the image manifest.</p>
        pub fn image_manifest_media_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_manifest_media_type = Some(input.into());
            self
        }
        /// <p>The media type of the image manifest.</p>
        pub fn set_image_manifest_media_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_manifest_media_type = input;
            self
        }
        /// <p>The artifact media type of the image.</p>
        pub fn artifact_media_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_media_type = Some(input.into());
            self
        }
        /// <p>The artifact media type of the image.</p>
        pub fn set_artifact_media_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.artifact_media_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageDetail`](crate::model::ImageDetail)
        pub fn build(self) -> crate::model::ImageDetail {
            crate::model::ImageDetail {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                image_digest: self.image_digest,
                image_tags: self.image_tags,
                image_size_in_bytes: self.image_size_in_bytes,
                image_pushed_at: self.image_pushed_at,
                image_manifest_media_type: self.image_manifest_media_type,
                artifact_media_type: self.artifact_media_type,
            }
        }
    }
}
impl ImageDetail {
    /// Creates a new builder-style object to manufacture [`ImageDetail`](crate::model::ImageDetail)
    pub fn builder() -> crate::model::image_detail::Builder {
        crate::model::image_detail::Builder::default()
    }
}

/// <p>An object representing an Amazon ECR image failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageFailure {
    /// <p>The image ID associated with the failure.</p>
    pub image_id: std::option::Option<crate::model::ImageIdentifier>,
    /// <p>The code associated with the failure.</p>
    pub failure_code: std::option::Option<crate::model::ImageFailureCode>,
    /// <p>The reason for the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl ImageFailure {
    /// <p>The image ID associated with the failure.</p>
    pub fn image_id(&self) -> std::option::Option<&crate::model::ImageIdentifier> {
        self.image_id.as_ref()
    }
    /// <p>The code associated with the failure.</p>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::ImageFailureCode> {
        self.failure_code.as_ref()
    }
    /// <p>The reason for the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for ImageFailure {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageFailure");
        formatter.field("image_id", &self.image_id);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`ImageFailure`](crate::model::ImageFailure)
pub mod image_failure {
    /// A builder for [`ImageFailure`](crate::model::ImageFailure)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_id: std::option::Option<crate::model::ImageIdentifier>,
        pub(crate) failure_code: std::option::Option<crate::model::ImageFailureCode>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The image ID associated with the failure.</p>
        pub fn image_id(mut self, input: crate::model::ImageIdentifier) -> Self {
            self.image_id = Some(input);
            self
        }
        /// <p>The image ID associated with the failure.</p>
        pub fn set_image_id(
            mut self,
            input: std::option::Option<crate::model::ImageIdentifier>,
        ) -> Self {
            self.image_id = input;
            self
        }
        /// <p>The code associated with the failure.</p>
        pub fn failure_code(mut self, input: crate::model::ImageFailureCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The code associated with the failure.</p>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::ImageFailureCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>The reason for the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason for the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageFailure`](crate::model::ImageFailure)
        pub fn build(self) -> crate::model::ImageFailure {
            crate::model::ImageFailure {
                image_id: self.image_id,
                failure_code: self.failure_code,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl ImageFailure {
    /// Creates a new builder-style object to manufacture [`ImageFailure`](crate::model::ImageFailure)
    pub fn builder() -> crate::model::image_failure::Builder {
        crate::model::image_failure::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImageFailureCode {
    #[allow(missing_docs)] // documentation missing in model
    ImageNotFound,
    #[allow(missing_docs)] // documentation missing in model
    ImageReferencedByManifestList,
    #[allow(missing_docs)] // documentation missing in model
    ImageTagDoesNotMatchDigest,
    #[allow(missing_docs)] // documentation missing in model
    InvalidImageDigest,
    #[allow(missing_docs)] // documentation missing in model
    InvalidImageTag,
    #[allow(missing_docs)] // documentation missing in model
    KmsError,
    #[allow(missing_docs)] // documentation missing in model
    MissingDigestAndTag,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImageFailureCode {
    fn from(s: &str) -> Self {
        match s {
            "ImageNotFound" => ImageFailureCode::ImageNotFound,
            "ImageReferencedByManifestList" => ImageFailureCode::ImageReferencedByManifestList,
            "ImageTagDoesNotMatchDigest" => ImageFailureCode::ImageTagDoesNotMatchDigest,
            "InvalidImageDigest" => ImageFailureCode::InvalidImageDigest,
            "InvalidImageTag" => ImageFailureCode::InvalidImageTag,
            "KmsError" => ImageFailureCode::KmsError,
            "MissingDigestAndTag" => ImageFailureCode::MissingDigestAndTag,
            other => ImageFailureCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImageFailureCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImageFailureCode::from(s))
    }
}
impl ImageFailureCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImageFailureCode::ImageNotFound => "ImageNotFound",
            ImageFailureCode::ImageReferencedByManifestList => "ImageReferencedByManifestList",
            ImageFailureCode::ImageTagDoesNotMatchDigest => "ImageTagDoesNotMatchDigest",
            ImageFailureCode::InvalidImageDigest => "InvalidImageDigest",
            ImageFailureCode::InvalidImageTag => "InvalidImageTag",
            ImageFailureCode::KmsError => "KmsError",
            ImageFailureCode::MissingDigestAndTag => "MissingDigestAndTag",
            ImageFailureCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ImageNotFound",
            "ImageReferencedByManifestList",
            "ImageTagDoesNotMatchDigest",
            "InvalidImageDigest",
            "InvalidImageTag",
            "KmsError",
            "MissingDigestAndTag",
        ]
    }
}
impl AsRef<str> for ImageFailureCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing an Amazon ECR image layer failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LayerFailure {
    /// <p>The layer digest associated with the failure.</p>
    pub layer_digest: std::option::Option<std::string::String>,
    /// <p>The failure code associated with the failure.</p>
    pub failure_code: std::option::Option<crate::model::LayerFailureCode>,
    /// <p>The reason for the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl LayerFailure {
    /// <p>The layer digest associated with the failure.</p>
    pub fn layer_digest(&self) -> std::option::Option<&str> {
        self.layer_digest.as_deref()
    }
    /// <p>The failure code associated with the failure.</p>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::LayerFailureCode> {
        self.failure_code.as_ref()
    }
    /// <p>The reason for the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for LayerFailure {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LayerFailure");
        formatter.field("layer_digest", &self.layer_digest);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`LayerFailure`](crate::model::LayerFailure)
pub mod layer_failure {
    /// A builder for [`LayerFailure`](crate::model::LayerFailure)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) layer_digest: std::option::Option<std::string::String>,
        pub(crate) failure_code: std::option::Option<crate::model::LayerFailureCode>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The layer digest associated with the failure.</p>
        pub fn layer_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_digest = Some(input.into());
            self
        }
        /// <p>The layer digest associated with the failure.</p>
        pub fn set_layer_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_digest = input;
            self
        }
        /// <p>The failure code associated with the failure.</p>
        pub fn failure_code(mut self, input: crate::model::LayerFailureCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The failure code associated with the failure.</p>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::LayerFailureCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>The reason for the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason for the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`LayerFailure`](crate::model::LayerFailure)
        pub fn build(self) -> crate::model::LayerFailure {
            crate::model::LayerFailure {
                layer_digest: self.layer_digest,
                failure_code: self.failure_code,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl LayerFailure {
    /// Creates a new builder-style object to manufacture [`LayerFailure`](crate::model::LayerFailure)
    pub fn builder() -> crate::model::layer_failure::Builder {
        crate::model::layer_failure::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LayerFailureCode {
    #[allow(missing_docs)] // documentation missing in model
    InvalidLayerDigest,
    #[allow(missing_docs)] // documentation missing in model
    MissingLayerDigest,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LayerFailureCode {
    fn from(s: &str) -> Self {
        match s {
            "InvalidLayerDigest" => LayerFailureCode::InvalidLayerDigest,
            "MissingLayerDigest" => LayerFailureCode::MissingLayerDigest,
            other => LayerFailureCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LayerFailureCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LayerFailureCode::from(s))
    }
}
impl LayerFailureCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LayerFailureCode::InvalidLayerDigest => "InvalidLayerDigest",
            LayerFailureCode::MissingLayerDigest => "MissingLayerDigest",
            LayerFailureCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["InvalidLayerDigest", "MissingLayerDigest"]
    }
}
impl AsRef<str> for LayerFailureCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing an Amazon ECR image layer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Layer {
    /// <p>The <code>sha256</code> digest of the image layer.</p>
    pub layer_digest: std::option::Option<std::string::String>,
    /// <p>The availability status of the image layer.</p>
    pub layer_availability: std::option::Option<crate::model::LayerAvailability>,
    /// <p>The size, in bytes, of the image layer.</p>
    pub layer_size: std::option::Option<i64>,
    /// <p>The media type of the layer, such as
    /// <code>application/vnd.docker.image.rootfs.diff.tar.gzip</code> or
    /// <code>application/vnd.oci.image.layer.v1.tar+gzip</code>.</p>
    pub media_type: std::option::Option<std::string::String>,
}
impl Layer {
    /// <p>The <code>sha256</code> digest of the image layer.</p>
    pub fn layer_digest(&self) -> std::option::Option<&str> {
        self.layer_digest.as_deref()
    }
    /// <p>The availability status of the image layer.</p>
    pub fn layer_availability(&self) -> std::option::Option<&crate::model::LayerAvailability> {
        self.layer_availability.as_ref()
    }
    /// <p>The size, in bytes, of the image layer.</p>
    pub fn layer_size(&self) -> std::option::Option<i64> {
        self.layer_size
    }
    /// <p>The media type of the layer, such as
    /// <code>application/vnd.docker.image.rootfs.diff.tar.gzip</code> or
    /// <code>application/vnd.oci.image.layer.v1.tar+gzip</code>.</p>
    pub fn media_type(&self) -> std::option::Option<&str> {
        self.media_type.as_deref()
    }
}
impl std::fmt::Debug for Layer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Layer");
        formatter.field("layer_digest", &self.layer_digest);
        formatter.field("layer_availability", &self.layer_availability);
        formatter.field("layer_size", &self.layer_size);
        formatter.field("media_type", &self.media_type);
        formatter.finish()
    }
}
/// See [`Layer`](crate::model::Layer)
pub mod layer {
    /// A builder for [`Layer`](crate::model::Layer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) layer_digest: std::option::Option<std::string::String>,
        pub(crate) layer_availability: std::option::Option<crate::model::LayerAvailability>,
        pub(crate) layer_size: std::option::Option<i64>,
        pub(crate) media_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>sha256</code> digest of the image layer.</p>
        pub fn layer_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_digest = Some(input.into());
            self
        }
        /// <p>The <code>sha256</code> digest of the image layer.</p>
        pub fn set_layer_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_digest = input;
            self
        }
        /// <p>The availability status of the image layer.</p>
        pub fn layer_availability(mut self, input: crate::model::LayerAvailability) -> Self {
            self.layer_availability = Some(input);
            self
        }
        /// <p>The availability status of the image layer.</p>
        pub fn set_layer_availability(
            mut self,
            input: std::option::Option<crate::model::LayerAvailability>,
        ) -> Self {
            self.layer_availability = input;
            self
        }
        /// <p>The size, in bytes, of the image layer.</p>
        pub fn layer_size(mut self, input: i64) -> Self {
            self.layer_size = Some(input);
            self
        }
        /// <p>The size, in bytes, of the image layer.</p>
        pub fn set_layer_size(mut self, input: std::option::Option<i64>) -> Self {
            self.layer_size = input;
            self
        }
        /// <p>The media type of the layer, such as
        /// <code>application/vnd.docker.image.rootfs.diff.tar.gzip</code> or
        /// <code>application/vnd.oci.image.layer.v1.tar+gzip</code>.</p>
        pub fn media_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_type = Some(input.into());
            self
        }
        /// <p>The media type of the layer, such as
        /// <code>application/vnd.docker.image.rootfs.diff.tar.gzip</code> or
        /// <code>application/vnd.oci.image.layer.v1.tar+gzip</code>.</p>
        pub fn set_media_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.media_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Layer`](crate::model::Layer)
        pub fn build(self) -> crate::model::Layer {
            crate::model::Layer {
                layer_digest: self.layer_digest,
                layer_availability: self.layer_availability,
                layer_size: self.layer_size,
                media_type: self.media_type,
            }
        }
    }
}
impl Layer {
    /// Creates a new builder-style object to manufacture [`Layer`](crate::model::Layer)
    pub fn builder() -> crate::model::layer::Builder {
        crate::model::layer::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LayerAvailability {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Unavailable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LayerAvailability {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => LayerAvailability::Available,
            "UNAVAILABLE" => LayerAvailability::Unavailable,
            other => LayerAvailability::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LayerAvailability {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LayerAvailability::from(s))
    }
}
impl LayerAvailability {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LayerAvailability::Available => "AVAILABLE",
            LayerAvailability::Unavailable => "UNAVAILABLE",
            LayerAvailability::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "UNAVAILABLE"]
    }
}
impl AsRef<str> for LayerAvailability {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
