// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon EC2 Container Registry
///
/// Client for invoking operations on Amazon EC2 Container Registry. Each operation on Amazon EC2 Container Registry is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_ecr::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_ecr::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_ecr::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`BatchCheckLayerAvailability`](crate::client::fluent_builders::BatchCheckLayerAvailability) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::BatchCheckLayerAvailability::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::BatchCheckLayerAvailability::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the image layers to check. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::BatchCheckLayerAvailability::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::BatchCheckLayerAvailability::set_repository_name): <p>The name of the repository that is associated with the image layers to check.</p>
    ///   - [`layer_digests(Vec<String>)`](crate::client::fluent_builders::BatchCheckLayerAvailability::layer_digests) / [`set_layer_digests(Option<Vec<String>>)`](crate::client::fluent_builders::BatchCheckLayerAvailability::set_layer_digests): <p>The digests of the image layers to check.</p>
    /// - On success, responds with [`BatchCheckLayerAvailabilityOutput`](crate::output::BatchCheckLayerAvailabilityOutput) with field(s):
    ///   - [`layers(Option<Vec<Layer>>)`](crate::output::BatchCheckLayerAvailabilityOutput::layers): <p>A list of image layer objects corresponding to the image layer references in the request.</p>
    ///   - [`failures(Option<Vec<LayerFailure>>)`](crate::output::BatchCheckLayerAvailabilityOutput::failures): <p>Any failures associated with the call.</p>
    /// - On failure, responds with [`SdkError<BatchCheckLayerAvailabilityError>`](crate::error::BatchCheckLayerAvailabilityError)
    pub fn batch_check_layer_availability(&self) -> fluent_builders::BatchCheckLayerAvailability {
        fluent_builders::BatchCheckLayerAvailability::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchDeleteImage`](crate::client::fluent_builders::BatchDeleteImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::BatchDeleteImage::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::BatchDeleteImage::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the image to delete. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::BatchDeleteImage::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::BatchDeleteImage::set_repository_name): <p>The repository that contains the image to delete.</p>
    ///   - [`image_ids(Vec<ImageIdentifier>)`](crate::client::fluent_builders::BatchDeleteImage::image_ids) / [`set_image_ids(Option<Vec<ImageIdentifier>>)`](crate::client::fluent_builders::BatchDeleteImage::set_image_ids): <p>A list of image ID references that correspond to images to delete. The format of the <code>imageIds</code> reference is <code>imageTag=tag</code> or <code>imageDigest=digest</code>.</p>
    /// - On success, responds with [`BatchDeleteImageOutput`](crate::output::BatchDeleteImageOutput) with field(s):
    ///   - [`image_ids(Option<Vec<ImageIdentifier>>)`](crate::output::BatchDeleteImageOutput::image_ids): <p>The image IDs of the deleted images.</p>
    ///   - [`failures(Option<Vec<ImageFailure>>)`](crate::output::BatchDeleteImageOutput::failures): <p>Any failures associated with the call.</p>
    /// - On failure, responds with [`SdkError<BatchDeleteImageError>`](crate::error::BatchDeleteImageError)
    pub fn batch_delete_image(&self) -> fluent_builders::BatchDeleteImage {
        fluent_builders::BatchDeleteImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetImage`](crate::client::fluent_builders::BatchGetImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::BatchGetImage::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::BatchGetImage::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the images to describe. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::BatchGetImage::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::BatchGetImage::set_repository_name): <p>The repository that contains the images to describe.</p>
    ///   - [`image_ids(Vec<ImageIdentifier>)`](crate::client::fluent_builders::BatchGetImage::image_ids) / [`set_image_ids(Option<Vec<ImageIdentifier>>)`](crate::client::fluent_builders::BatchGetImage::set_image_ids): <p>A list of image ID references that correspond to images to describe. The format of the <code>imageIds</code> reference is <code>imageTag=tag</code> or <code>imageDigest=digest</code>.</p>
    ///   - [`accepted_media_types(Vec<String>)`](crate::client::fluent_builders::BatchGetImage::accepted_media_types) / [`set_accepted_media_types(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetImage::set_accepted_media_types): <p>The accepted media types for the request.</p>  <p>Valid values: <code>application/vnd.docker.distribution.manifest.v1+json</code> | <code>application/vnd.docker.distribution.manifest.v2+json</code> | <code>application/vnd.oci.image.manifest.v1+json</code> </p>
    /// - On success, responds with [`BatchGetImageOutput`](crate::output::BatchGetImageOutput) with field(s):
    ///   - [`images(Option<Vec<Image>>)`](crate::output::BatchGetImageOutput::images): <p>A list of image objects corresponding to the image references in the request.</p>
    ///   - [`failures(Option<Vec<ImageFailure>>)`](crate::output::BatchGetImageOutput::failures): <p>Any failures associated with the call.</p>
    /// - On failure, responds with [`SdkError<BatchGetImageError>`](crate::error::BatchGetImageError)
    pub fn batch_get_image(&self) -> fluent_builders::BatchGetImage {
        fluent_builders::BatchGetImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetRepositoryScanningConfiguration`](crate::client::fluent_builders::BatchGetRepositoryScanningConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_names(Vec<String>)`](crate::client::fluent_builders::BatchGetRepositoryScanningConfiguration::repository_names) / [`set_repository_names(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetRepositoryScanningConfiguration::set_repository_names): <p>One or more repository names to get the scanning configuration for.</p>
    /// - On success, responds with [`BatchGetRepositoryScanningConfigurationOutput`](crate::output::BatchGetRepositoryScanningConfigurationOutput) with field(s):
    ///   - [`scanning_configurations(Option<Vec<RepositoryScanningConfiguration>>)`](crate::output::BatchGetRepositoryScanningConfigurationOutput::scanning_configurations): <p>The scanning configuration for the requested repositories.</p>
    ///   - [`failures(Option<Vec<RepositoryScanningConfigurationFailure>>)`](crate::output::BatchGetRepositoryScanningConfigurationOutput::failures): <p>Any failures associated with the call.</p>
    /// - On failure, responds with [`SdkError<BatchGetRepositoryScanningConfigurationError>`](crate::error::BatchGetRepositoryScanningConfigurationError)
    pub fn batch_get_repository_scanning_configuration(
        &self,
    ) -> fluent_builders::BatchGetRepositoryScanningConfiguration {
        fluent_builders::BatchGetRepositoryScanningConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CompleteLayerUpload`](crate::client::fluent_builders::CompleteLayerUpload) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::CompleteLayerUpload::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::CompleteLayerUpload::set_registry_id): <p>The Amazon Web Services account ID associated with the registry to which to upload layers. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::CompleteLayerUpload::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::CompleteLayerUpload::set_repository_name): <p>The name of the repository to associate with the image layer.</p>
    ///   - [`upload_id(impl Into<String>)`](crate::client::fluent_builders::CompleteLayerUpload::upload_id) / [`set_upload_id(Option<String>)`](crate::client::fluent_builders::CompleteLayerUpload::set_upload_id): <p>The upload ID from a previous <code>InitiateLayerUpload</code> operation to associate with the image layer.</p>
    ///   - [`layer_digests(Vec<String>)`](crate::client::fluent_builders::CompleteLayerUpload::layer_digests) / [`set_layer_digests(Option<Vec<String>>)`](crate::client::fluent_builders::CompleteLayerUpload::set_layer_digests): <p>The <code>sha256</code> digest of the image layer.</p>
    /// - On success, responds with [`CompleteLayerUploadOutput`](crate::output::CompleteLayerUploadOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::CompleteLayerUploadOutput::registry_id): <p>The registry ID associated with the request.</p>
    ///   - [`repository_name(Option<String>)`](crate::output::CompleteLayerUploadOutput::repository_name): <p>The repository name associated with the request.</p>
    ///   - [`upload_id(Option<String>)`](crate::output::CompleteLayerUploadOutput::upload_id): <p>The upload ID associated with the layer.</p>
    ///   - [`layer_digest(Option<String>)`](crate::output::CompleteLayerUploadOutput::layer_digest): <p>The <code>sha256</code> digest of the image layer.</p>
    /// - On failure, responds with [`SdkError<CompleteLayerUploadError>`](crate::error::CompleteLayerUploadError)
    pub fn complete_layer_upload(&self) -> fluent_builders::CompleteLayerUpload {
        fluent_builders::CompleteLayerUpload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePullThroughCacheRule`](crate::client::fluent_builders::CreatePullThroughCacheRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ecr_repository_prefix(impl Into<String>)`](crate::client::fluent_builders::CreatePullThroughCacheRule::ecr_repository_prefix) / [`set_ecr_repository_prefix(Option<String>)`](crate::client::fluent_builders::CreatePullThroughCacheRule::set_ecr_repository_prefix): <p>The repository name prefix to use when caching images from the source registry.</p>
    ///   - [`upstream_registry_url(impl Into<String>)`](crate::client::fluent_builders::CreatePullThroughCacheRule::upstream_registry_url) / [`set_upstream_registry_url(Option<String>)`](crate::client::fluent_builders::CreatePullThroughCacheRule::set_upstream_registry_url): <p>The registry URL of the upstream public registry to use as the source for the pull through cache rule.</p>
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::CreatePullThroughCacheRule::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::CreatePullThroughCacheRule::set_registry_id): <p>The Amazon Web Services account ID associated with the registry to create the pull through cache rule for. If you do not specify a registry, the default registry is assumed.</p>
    /// - On success, responds with [`CreatePullThroughCacheRuleOutput`](crate::output::CreatePullThroughCacheRuleOutput) with field(s):
    ///   - [`ecr_repository_prefix(Option<String>)`](crate::output::CreatePullThroughCacheRuleOutput::ecr_repository_prefix): <p>The Amazon ECR repository prefix associated with the pull through cache rule.</p>
    ///   - [`upstream_registry_url(Option<String>)`](crate::output::CreatePullThroughCacheRuleOutput::upstream_registry_url): <p>The upstream registry URL associated with the pull through cache rule.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::CreatePullThroughCacheRuleOutput::created_at): <p>The date and time, in JavaScript date format, when the pull through cache rule was created.</p>
    ///   - [`registry_id(Option<String>)`](crate::output::CreatePullThroughCacheRuleOutput::registry_id): <p>The registry ID associated with the request.</p>
    /// - On failure, responds with [`SdkError<CreatePullThroughCacheRuleError>`](crate::error::CreatePullThroughCacheRuleError)
    pub fn create_pull_through_cache_rule(&self) -> fluent_builders::CreatePullThroughCacheRule {
        fluent_builders::CreatePullThroughCacheRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRepository`](crate::client::fluent_builders::CreateRepository) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::CreateRepository::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::CreateRepository::set_registry_id): <p>The Amazon Web Services account ID associated with the registry to create the repository. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::CreateRepository::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::CreateRepository::set_repository_name): <p>The name to use for the repository. The repository name may be specified on its own (such as <code>nginx-web-app</code>) or it can be prepended with a namespace to group the repository into a category (such as <code>project-a/nginx-web-app</code>).</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateRepository::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateRepository::set_tags): <p>The metadata that you apply to the repository to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    ///   - [`image_tag_mutability(ImageTagMutability)`](crate::client::fluent_builders::CreateRepository::image_tag_mutability) / [`set_image_tag_mutability(Option<ImageTagMutability>)`](crate::client::fluent_builders::CreateRepository::set_image_tag_mutability): <p>The tag mutability setting for the repository. If this parameter is omitted, the default setting of <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.</p>
    ///   - [`image_scanning_configuration(ImageScanningConfiguration)`](crate::client::fluent_builders::CreateRepository::image_scanning_configuration) / [`set_image_scanning_configuration(Option<ImageScanningConfiguration>)`](crate::client::fluent_builders::CreateRepository::set_image_scanning_configuration): <p>The image scanning configuration for the repository. This determines whether images are scanned for known vulnerabilities after being pushed to the repository.</p>
    ///   - [`encryption_configuration(EncryptionConfiguration)`](crate::client::fluent_builders::CreateRepository::encryption_configuration) / [`set_encryption_configuration(Option<EncryptionConfiguration>)`](crate::client::fluent_builders::CreateRepository::set_encryption_configuration): <p>The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.</p>
    /// - On success, responds with [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput) with field(s):
    ///   - [`repository(Option<Repository>)`](crate::output::CreateRepositoryOutput::repository): <p>The repository that was created.</p>
    /// - On failure, responds with [`SdkError<CreateRepositoryError>`](crate::error::CreateRepositoryError)
    pub fn create_repository(&self) -> fluent_builders::CreateRepository {
        fluent_builders::CreateRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLifecyclePolicy`](crate::client::fluent_builders::DeleteLifecyclePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::DeleteLifecyclePolicy::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::DeleteLifecyclePolicy::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::DeleteLifecyclePolicy::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::DeleteLifecyclePolicy::set_repository_name): <p>The name of the repository.</p>
    /// - On success, responds with [`DeleteLifecyclePolicyOutput`](crate::output::DeleteLifecyclePolicyOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::DeleteLifecyclePolicyOutput::registry_id): <p>The registry ID associated with the request.</p>
    ///   - [`repository_name(Option<String>)`](crate::output::DeleteLifecyclePolicyOutput::repository_name): <p>The repository name associated with the request.</p>
    ///   - [`lifecycle_policy_text(Option<String>)`](crate::output::DeleteLifecyclePolicyOutput::lifecycle_policy_text): <p>The JSON lifecycle policy text.</p>
    ///   - [`last_evaluated_at(Option<DateTime>)`](crate::output::DeleteLifecyclePolicyOutput::last_evaluated_at): <p>The time stamp of the last time that the lifecycle policy was run.</p>
    /// - On failure, responds with [`SdkError<DeleteLifecyclePolicyError>`](crate::error::DeleteLifecyclePolicyError)
    pub fn delete_lifecycle_policy(&self) -> fluent_builders::DeleteLifecyclePolicy {
        fluent_builders::DeleteLifecyclePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePullThroughCacheRule`](crate::client::fluent_builders::DeletePullThroughCacheRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ecr_repository_prefix(impl Into<String>)`](crate::client::fluent_builders::DeletePullThroughCacheRule::ecr_repository_prefix) / [`set_ecr_repository_prefix(Option<String>)`](crate::client::fluent_builders::DeletePullThroughCacheRule::set_ecr_repository_prefix): <p>The Amazon ECR repository prefix associated with the pull through cache rule to delete.</p>
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::DeletePullThroughCacheRule::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::DeletePullThroughCacheRule::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the pull through cache rule. If you do not specify a registry, the default registry is assumed.</p>
    /// - On success, responds with [`DeletePullThroughCacheRuleOutput`](crate::output::DeletePullThroughCacheRuleOutput) with field(s):
    ///   - [`ecr_repository_prefix(Option<String>)`](crate::output::DeletePullThroughCacheRuleOutput::ecr_repository_prefix): <p>The Amazon ECR repository prefix associated with the request.</p>
    ///   - [`upstream_registry_url(Option<String>)`](crate::output::DeletePullThroughCacheRuleOutput::upstream_registry_url): <p>The upstream registry URL associated with the pull through cache rule.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::DeletePullThroughCacheRuleOutput::created_at): <p>The timestamp associated with the pull through cache rule.</p>
    ///   - [`registry_id(Option<String>)`](crate::output::DeletePullThroughCacheRuleOutput::registry_id): <p>The registry ID associated with the request.</p>
    /// - On failure, responds with [`SdkError<DeletePullThroughCacheRuleError>`](crate::error::DeletePullThroughCacheRuleError)
    pub fn delete_pull_through_cache_rule(&self) -> fluent_builders::DeletePullThroughCacheRule {
        fluent_builders::DeletePullThroughCacheRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRegistryPolicy`](crate::client::fluent_builders::DeleteRegistryPolicy) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DeleteRegistryPolicy::send) it.

    /// - On success, responds with [`DeleteRegistryPolicyOutput`](crate::output::DeleteRegistryPolicyOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::DeleteRegistryPolicyOutput::registry_id): <p>The registry ID associated with the request.</p>
    ///   - [`policy_text(Option<String>)`](crate::output::DeleteRegistryPolicyOutput::policy_text): <p>The contents of the registry permissions policy that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteRegistryPolicyError>`](crate::error::DeleteRegistryPolicyError)
    pub fn delete_registry_policy(&self) -> fluent_builders::DeleteRegistryPolicy {
        fluent_builders::DeleteRegistryPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRepository`](crate::client::fluent_builders::DeleteRepository) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRepository::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::DeleteRepository::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the repository to delete. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::DeleteRepository::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::DeleteRepository::set_repository_name): <p>The name of the repository to delete.</p>
    ///   - [`force(bool)`](crate::client::fluent_builders::DeleteRepository::force) / [`set_force(bool)`](crate::client::fluent_builders::DeleteRepository::set_force): <p> If a repository contains images, forces the deletion.</p>
    /// - On success, responds with [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput) with field(s):
    ///   - [`repository(Option<Repository>)`](crate::output::DeleteRepositoryOutput::repository): <p>The repository that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteRepositoryError>`](crate::error::DeleteRepositoryError)
    pub fn delete_repository(&self) -> fluent_builders::DeleteRepository {
        fluent_builders::DeleteRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRepositoryPolicy`](crate::client::fluent_builders::DeleteRepositoryPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRepositoryPolicy::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::DeleteRepositoryPolicy::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the repository policy to delete. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::DeleteRepositoryPolicy::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::DeleteRepositoryPolicy::set_repository_name): <p>The name of the repository that is associated with the repository policy to delete.</p>
    /// - On success, responds with [`DeleteRepositoryPolicyOutput`](crate::output::DeleteRepositoryPolicyOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::DeleteRepositoryPolicyOutput::registry_id): <p>The registry ID associated with the request.</p>
    ///   - [`repository_name(Option<String>)`](crate::output::DeleteRepositoryPolicyOutput::repository_name): <p>The repository name associated with the request.</p>
    ///   - [`policy_text(Option<String>)`](crate::output::DeleteRepositoryPolicyOutput::policy_text): <p>The JSON repository policy that was deleted from the repository.</p>
    /// - On failure, responds with [`SdkError<DeleteRepositoryPolicyError>`](crate::error::DeleteRepositoryPolicyError)
    pub fn delete_repository_policy(&self) -> fluent_builders::DeleteRepositoryPolicy {
        fluent_builders::DeleteRepositoryPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeImageReplicationStatus`](crate::client::fluent_builders::DescribeImageReplicationStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::DescribeImageReplicationStatus::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::DescribeImageReplicationStatus::set_repository_name): <p>The name of the repository that the image is in.</p>
    ///   - [`image_id(ImageIdentifier)`](crate::client::fluent_builders::DescribeImageReplicationStatus::image_id) / [`set_image_id(Option<ImageIdentifier>)`](crate::client::fluent_builders::DescribeImageReplicationStatus::set_image_id): <p>An object with identifying information for an image in an Amazon ECR repository.</p>
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::DescribeImageReplicationStatus::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::DescribeImageReplicationStatus::set_registry_id): <p>The Amazon Web Services account ID associated with the registry. If you do not specify a registry, the default registry is assumed.</p>
    /// - On success, responds with [`DescribeImageReplicationStatusOutput`](crate::output::DescribeImageReplicationStatusOutput) with field(s):
    ///   - [`repository_name(Option<String>)`](crate::output::DescribeImageReplicationStatusOutput::repository_name): <p>The repository name associated with the request.</p>
    ///   - [`image_id(Option<ImageIdentifier>)`](crate::output::DescribeImageReplicationStatusOutput::image_id): <p>An object with identifying information for an image in an Amazon ECR repository.</p>
    ///   - [`replication_statuses(Option<Vec<ImageReplicationStatus>>)`](crate::output::DescribeImageReplicationStatusOutput::replication_statuses): <p>The replication status details for the images in the specified repository.</p>
    /// - On failure, responds with [`SdkError<DescribeImageReplicationStatusError>`](crate::error::DescribeImageReplicationStatusError)
    pub fn describe_image_replication_status(
        &self,
    ) -> fluent_builders::DescribeImageReplicationStatus {
        fluent_builders::DescribeImageReplicationStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeImages`](crate::client::fluent_builders::DescribeImages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeImages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::DescribeImages::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::DescribeImages::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to describe images. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::DescribeImages::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::DescribeImages::set_repository_name): <p>The repository that contains the images to describe.</p>
    ///   - [`image_ids(Vec<ImageIdentifier>)`](crate::client::fluent_builders::DescribeImages::image_ids) / [`set_image_ids(Option<Vec<ImageIdentifier>>)`](crate::client::fluent_builders::DescribeImages::set_image_ids): <p>The list of image IDs for the requested repository.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeImages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeImages::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeImages</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return. This option cannot be used when you specify images with <code>imageIds</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeImages::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeImages::set_max_results): <p>The maximum number of repository results returned by <code>DescribeImages</code> in paginated output. When this parameter is used, <code>DescribeImages</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeImages</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>DescribeImages</code> returns up to 100 results and a <code>nextToken</code> value, if applicable. This option cannot be used when you specify images with <code>imageIds</code>.</p>
    ///   - [`filter(DescribeImagesFilter)`](crate::client::fluent_builders::DescribeImages::filter) / [`set_filter(Option<DescribeImagesFilter>)`](crate::client::fluent_builders::DescribeImages::set_filter): <p>The filter key and value with which to filter your <code>DescribeImages</code> results.</p>
    /// - On success, responds with [`DescribeImagesOutput`](crate::output::DescribeImagesOutput) with field(s):
    ///   - [`image_details(Option<Vec<ImageDetail>>)`](crate::output::DescribeImagesOutput::image_details): <p>A list of <code>ImageDetail</code> objects that contain data about the image.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeImagesOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>DescribeImages</code> request. When the results of a <code>DescribeImages</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeImagesError>`](crate::error::DescribeImagesError)
    pub fn describe_images(&self) -> fluent_builders::DescribeImages {
        fluent_builders::DescribeImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeImageScanFindings`](crate::client::fluent_builders::DescribeImageScanFindings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeImageScanFindings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::DescribeImageScanFindings::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::DescribeImageScanFindings::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to describe the image scan findings for. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::DescribeImageScanFindings::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::DescribeImageScanFindings::set_repository_name): <p>The repository for the image for which to describe the scan findings.</p>
    ///   - [`image_id(ImageIdentifier)`](crate::client::fluent_builders::DescribeImageScanFindings::image_id) / [`set_image_id(Option<ImageIdentifier>)`](crate::client::fluent_builders::DescribeImageScanFindings::set_image_id): <p>An object with identifying information for an image in an Amazon ECR repository.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeImageScanFindings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeImageScanFindings::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeImageScanFindings</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeImageScanFindings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeImageScanFindings::set_max_results): <p>The maximum number of image scan results returned by <code>DescribeImageScanFindings</code> in paginated output. When this parameter is used, <code>DescribeImageScanFindings</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeImageScanFindings</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>DescribeImageScanFindings</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>
    /// - On success, responds with [`DescribeImageScanFindingsOutput`](crate::output::DescribeImageScanFindingsOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::DescribeImageScanFindingsOutput::registry_id): <p>The registry ID associated with the request.</p>
    ///   - [`repository_name(Option<String>)`](crate::output::DescribeImageScanFindingsOutput::repository_name): <p>The repository name associated with the request.</p>
    ///   - [`image_id(Option<ImageIdentifier>)`](crate::output::DescribeImageScanFindingsOutput::image_id): <p>An object with identifying information for an image in an Amazon ECR repository.</p>
    ///   - [`image_scan_status(Option<ImageScanStatus>)`](crate::output::DescribeImageScanFindingsOutput::image_scan_status): <p>The current state of the scan.</p>
    ///   - [`image_scan_findings(Option<ImageScanFindings>)`](crate::output::DescribeImageScanFindingsOutput::image_scan_findings): <p>The information contained in the image scan findings.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeImageScanFindingsOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>DescribeImageScanFindings</code> request. When the results of a <code>DescribeImageScanFindings</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is null when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeImageScanFindingsError>`](crate::error::DescribeImageScanFindingsError)
    pub fn describe_image_scan_findings(&self) -> fluent_builders::DescribeImageScanFindings {
        fluent_builders::DescribeImageScanFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePullThroughCacheRules`](crate::client::fluent_builders::DescribePullThroughCacheRules) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribePullThroughCacheRules::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::DescribePullThroughCacheRules::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::DescribePullThroughCacheRules::set_registry_id): <p>The Amazon Web Services account ID associated with the registry to return the pull through cache rules for. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`ecr_repository_prefixes(Vec<String>)`](crate::client::fluent_builders::DescribePullThroughCacheRules::ecr_repository_prefixes) / [`set_ecr_repository_prefixes(Option<Vec<String>>)`](crate::client::fluent_builders::DescribePullThroughCacheRules::set_ecr_repository_prefixes): <p>The Amazon ECR repository prefixes associated with the pull through cache rules to return. If no repository prefix value is specified, all pull through cache rules are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribePullThroughCacheRules::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribePullThroughCacheRules::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribePullThroughCacheRulesRequest</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribePullThroughCacheRules::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribePullThroughCacheRules::set_max_results): <p>The maximum number of pull through cache rules returned by <code>DescribePullThroughCacheRulesRequest</code> in paginated output. When this parameter is used, <code>DescribePullThroughCacheRulesRequest</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribePullThroughCacheRulesRequest</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>DescribePullThroughCacheRulesRequest</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>
    /// - On success, responds with [`DescribePullThroughCacheRulesOutput`](crate::output::DescribePullThroughCacheRulesOutput) with field(s):
    ///   - [`pull_through_cache_rules(Option<Vec<PullThroughCacheRule>>)`](crate::output::DescribePullThroughCacheRulesOutput::pull_through_cache_rules): <p>The details of the pull through cache rules.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribePullThroughCacheRulesOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>DescribePullThroughCacheRulesRequest</code> request. When the results of a <code>DescribePullThroughCacheRulesRequest</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is null when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribePullThroughCacheRulesError>`](crate::error::DescribePullThroughCacheRulesError)
    pub fn describe_pull_through_cache_rules(
        &self,
    ) -> fluent_builders::DescribePullThroughCacheRules {
        fluent_builders::DescribePullThroughCacheRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRegistry`](crate::client::fluent_builders::DescribeRegistry) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeRegistry::send) it.

    /// - On success, responds with [`DescribeRegistryOutput`](crate::output::DescribeRegistryOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::DescribeRegistryOutput::registry_id): <p>The ID of the registry.</p>
    ///   - [`replication_configuration(Option<ReplicationConfiguration>)`](crate::output::DescribeRegistryOutput::replication_configuration): <p>The replication configuration for the registry.</p>
    /// - On failure, responds with [`SdkError<DescribeRegistryError>`](crate::error::DescribeRegistryError)
    pub fn describe_registry(&self) -> fluent_builders::DescribeRegistry {
        fluent_builders::DescribeRegistry::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRepositories`](crate::client::fluent_builders::DescribeRepositories) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeRepositories::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::DescribeRepositories::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::DescribeRepositories::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the repositories to be described. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_names(Vec<String>)`](crate::client::fluent_builders::DescribeRepositories::repository_names) / [`set_repository_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeRepositories::set_repository_names): <p>A list of repositories to describe. If this parameter is omitted, then all repositories in a registry are described.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeRepositories::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeRepositories::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeRepositories</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return. This option cannot be used when you specify repositories with <code>repositoryNames</code>.</p> <note>   <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>  </note>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeRepositories::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeRepositories::set_max_results): <p>The maximum number of repository results returned by <code>DescribeRepositories</code> in paginated output. When this parameter is used, <code>DescribeRepositories</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeRepositories</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>DescribeRepositories</code> returns up to 100 results and a <code>nextToken</code> value, if applicable. This option cannot be used when you specify repositories with <code>repositoryNames</code>.</p>
    /// - On success, responds with [`DescribeRepositoriesOutput`](crate::output::DescribeRepositoriesOutput) with field(s):
    ///   - [`repositories(Option<Vec<Repository>>)`](crate::output::DescribeRepositoriesOutput::repositories): <p>A list of repository objects corresponding to valid repositories.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeRepositoriesOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>DescribeRepositories</code> request. When the results of a <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<DescribeRepositoriesError>`](crate::error::DescribeRepositoriesError)
    pub fn describe_repositories(&self) -> fluent_builders::DescribeRepositories {
        fluent_builders::DescribeRepositories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAuthorizationToken`](crate::client::fluent_builders::GetAuthorizationToken) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_ids(Vec<String>)`](crate::client::fluent_builders::GetAuthorizationToken::registry_ids) / [`set_registry_ids(Option<Vec<String>>)`](crate::client::fluent_builders::GetAuthorizationToken::set_registry_ids): <p>A list of Amazon Web Services account IDs that are associated with the registries for which to get AuthorizationData objects. If you do not specify a registry, the default registry is assumed.</p>
    /// - On success, responds with [`GetAuthorizationTokenOutput`](crate::output::GetAuthorizationTokenOutput) with field(s):
    ///   - [`authorization_data(Option<Vec<AuthorizationData>>)`](crate::output::GetAuthorizationTokenOutput::authorization_data): <p>A list of authorization token data objects that correspond to the <code>registryIds</code> values in the request.</p>
    /// - On failure, responds with [`SdkError<GetAuthorizationTokenError>`](crate::error::GetAuthorizationTokenError)
    pub fn get_authorization_token(&self) -> fluent_builders::GetAuthorizationToken {
        fluent_builders::GetAuthorizationToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDownloadUrlForLayer`](crate::client::fluent_builders::GetDownloadUrlForLayer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::GetDownloadUrlForLayer::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::GetDownloadUrlForLayer::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the image layer to download. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::GetDownloadUrlForLayer::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::GetDownloadUrlForLayer::set_repository_name): <p>The name of the repository that is associated with the image layer to download.</p>
    ///   - [`layer_digest(impl Into<String>)`](crate::client::fluent_builders::GetDownloadUrlForLayer::layer_digest) / [`set_layer_digest(Option<String>)`](crate::client::fluent_builders::GetDownloadUrlForLayer::set_layer_digest): <p>The digest of the image layer to download.</p>
    /// - On success, responds with [`GetDownloadUrlForLayerOutput`](crate::output::GetDownloadUrlForLayerOutput) with field(s):
    ///   - [`download_url(Option<String>)`](crate::output::GetDownloadUrlForLayerOutput::download_url): <p>The pre-signed Amazon S3 download URL for the requested layer.</p>
    ///   - [`layer_digest(Option<String>)`](crate::output::GetDownloadUrlForLayerOutput::layer_digest): <p>The digest of the image layer to download.</p>
    /// - On failure, responds with [`SdkError<GetDownloadUrlForLayerError>`](crate::error::GetDownloadUrlForLayerError)
    pub fn get_download_url_for_layer(&self) -> fluent_builders::GetDownloadUrlForLayer {
        fluent_builders::GetDownloadUrlForLayer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLifecyclePolicy`](crate::client::fluent_builders::GetLifecyclePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::GetLifecyclePolicy::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::GetLifecyclePolicy::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::GetLifecyclePolicy::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::GetLifecyclePolicy::set_repository_name): <p>The name of the repository.</p>
    /// - On success, responds with [`GetLifecyclePolicyOutput`](crate::output::GetLifecyclePolicyOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::GetLifecyclePolicyOutput::registry_id): <p>The registry ID associated with the request.</p>
    ///   - [`repository_name(Option<String>)`](crate::output::GetLifecyclePolicyOutput::repository_name): <p>The repository name associated with the request.</p>
    ///   - [`lifecycle_policy_text(Option<String>)`](crate::output::GetLifecyclePolicyOutput::lifecycle_policy_text): <p>The JSON lifecycle policy text.</p>
    ///   - [`last_evaluated_at(Option<DateTime>)`](crate::output::GetLifecyclePolicyOutput::last_evaluated_at): <p>The time stamp of the last time that the lifecycle policy was run.</p>
    /// - On failure, responds with [`SdkError<GetLifecyclePolicyError>`](crate::error::GetLifecyclePolicyError)
    pub fn get_lifecycle_policy(&self) -> fluent_builders::GetLifecyclePolicy {
        fluent_builders::GetLifecyclePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLifecyclePolicyPreview`](crate::client::fluent_builders::GetLifecyclePolicyPreview) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetLifecyclePolicyPreview::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::GetLifecyclePolicyPreview::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::GetLifecyclePolicyPreview::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::GetLifecyclePolicyPreview::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::GetLifecyclePolicyPreview::set_repository_name): <p>The name of the repository.</p>
    ///   - [`image_ids(Vec<ImageIdentifier>)`](crate::client::fluent_builders::GetLifecyclePolicyPreview::image_ids) / [`set_image_ids(Option<Vec<ImageIdentifier>>)`](crate::client::fluent_builders::GetLifecyclePolicyPreview::set_image_ids): <p>The list of imageIDs to be included.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetLifecyclePolicyPreview::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetLifecyclePolicyPreview::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated  <code>GetLifecyclePolicyPreviewRequest</code> request where <code>maxResults</code> was used and the  results exceeded the value of that parameter. Pagination continues from the end of the  previous results that returned the <code>nextToken</code> value. This value is  <code>null</code> when there are no more results to return. This option cannot be used when you specify images with <code>imageIds</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetLifecyclePolicyPreview::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetLifecyclePolicyPreview::set_max_results): <p>The maximum number of repository results returned by <code>GetLifecyclePolicyPreviewRequest</code> in  paginated output. When this parameter is used, <code>GetLifecyclePolicyPreviewRequest</code> only returns  <code>maxResults</code> results in a single page along with a <code>nextToken</code>  response element. The remaining results of the initial request can be seen by sending  another <code>GetLifecyclePolicyPreviewRequest</code> request with the returned <code>nextToken</code>  value. This value can be between 1 and 1000. If this  parameter is not used, then <code>GetLifecyclePolicyPreviewRequest</code> returns up to  100 results and a <code>nextToken</code> value, if  applicable. This option cannot be used when you specify images with <code>imageIds</code>.</p>
    ///   - [`filter(LifecyclePolicyPreviewFilter)`](crate::client::fluent_builders::GetLifecyclePolicyPreview::filter) / [`set_filter(Option<LifecyclePolicyPreviewFilter>)`](crate::client::fluent_builders::GetLifecyclePolicyPreview::set_filter): <p>An optional parameter that filters results based on image tag status and all tags, if tagged.</p>
    /// - On success, responds with [`GetLifecyclePolicyPreviewOutput`](crate::output::GetLifecyclePolicyPreviewOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::GetLifecyclePolicyPreviewOutput::registry_id): <p>The registry ID associated with the request.</p>
    ///   - [`repository_name(Option<String>)`](crate::output::GetLifecyclePolicyPreviewOutput::repository_name): <p>The repository name associated with the request.</p>
    ///   - [`lifecycle_policy_text(Option<String>)`](crate::output::GetLifecyclePolicyPreviewOutput::lifecycle_policy_text): <p>The JSON lifecycle policy text.</p>
    ///   - [`status(Option<LifecyclePolicyPreviewStatus>)`](crate::output::GetLifecyclePolicyPreviewOutput::status): <p>The status of the lifecycle policy preview request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetLifecyclePolicyPreviewOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>GetLifecyclePolicyPreview</code> request. When the results of a <code>GetLifecyclePolicyPreview</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    ///   - [`preview_results(Option<Vec<LifecyclePolicyPreviewResult>>)`](crate::output::GetLifecyclePolicyPreviewOutput::preview_results): <p>The results of the lifecycle policy preview request.</p>
    ///   - [`summary(Option<LifecyclePolicyPreviewSummary>)`](crate::output::GetLifecyclePolicyPreviewOutput::summary): <p>The list of images that is returned as a result of the action.</p>
    /// - On failure, responds with [`SdkError<GetLifecyclePolicyPreviewError>`](crate::error::GetLifecyclePolicyPreviewError)
    pub fn get_lifecycle_policy_preview(&self) -> fluent_builders::GetLifecyclePolicyPreview {
        fluent_builders::GetLifecyclePolicyPreview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRegistryPolicy`](crate::client::fluent_builders::GetRegistryPolicy) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetRegistryPolicy::send) it.

    /// - On success, responds with [`GetRegistryPolicyOutput`](crate::output::GetRegistryPolicyOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::GetRegistryPolicyOutput::registry_id): <p>The ID of the registry.</p>
    ///   - [`policy_text(Option<String>)`](crate::output::GetRegistryPolicyOutput::policy_text): <p>The JSON text of the permissions policy for a registry.</p>
    /// - On failure, responds with [`SdkError<GetRegistryPolicyError>`](crate::error::GetRegistryPolicyError)
    pub fn get_registry_policy(&self) -> fluent_builders::GetRegistryPolicy {
        fluent_builders::GetRegistryPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRegistryScanningConfiguration`](crate::client::fluent_builders::GetRegistryScanningConfiguration) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetRegistryScanningConfiguration::send) it.

    /// - On success, responds with [`GetRegistryScanningConfigurationOutput`](crate::output::GetRegistryScanningConfigurationOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::GetRegistryScanningConfigurationOutput::registry_id): <p>The ID of the registry.</p>
    ///   - [`scanning_configuration(Option<RegistryScanningConfiguration>)`](crate::output::GetRegistryScanningConfigurationOutput::scanning_configuration): <p>The scanning configuration for the registry.</p>
    /// - On failure, responds with [`SdkError<GetRegistryScanningConfigurationError>`](crate::error::GetRegistryScanningConfigurationError)
    pub fn get_registry_scanning_configuration(
        &self,
    ) -> fluent_builders::GetRegistryScanningConfiguration {
        fluent_builders::GetRegistryScanningConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRepositoryPolicy`](crate::client::fluent_builders::GetRepositoryPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::GetRepositoryPolicy::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::GetRepositoryPolicy::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::GetRepositoryPolicy::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::GetRepositoryPolicy::set_repository_name): <p>The name of the repository with the policy to retrieve.</p>
    /// - On success, responds with [`GetRepositoryPolicyOutput`](crate::output::GetRepositoryPolicyOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::GetRepositoryPolicyOutput::registry_id): <p>The registry ID associated with the request.</p>
    ///   - [`repository_name(Option<String>)`](crate::output::GetRepositoryPolicyOutput::repository_name): <p>The repository name associated with the request.</p>
    ///   - [`policy_text(Option<String>)`](crate::output::GetRepositoryPolicyOutput::policy_text): <p>The JSON repository policy text associated with the repository.</p>
    /// - On failure, responds with [`SdkError<GetRepositoryPolicyError>`](crate::error::GetRepositoryPolicyError)
    pub fn get_repository_policy(&self) -> fluent_builders::GetRepositoryPolicy {
        fluent_builders::GetRepositoryPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`InitiateLayerUpload`](crate::client::fluent_builders::InitiateLayerUpload) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::InitiateLayerUpload::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::InitiateLayerUpload::set_registry_id): <p>The Amazon Web Services account ID associated with the registry to which you intend to upload layers. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::InitiateLayerUpload::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::InitiateLayerUpload::set_repository_name): <p>The name of the repository to which you intend to upload layers.</p>
    /// - On success, responds with [`InitiateLayerUploadOutput`](crate::output::InitiateLayerUploadOutput) with field(s):
    ///   - [`upload_id(Option<String>)`](crate::output::InitiateLayerUploadOutput::upload_id): <p>The upload ID for the layer upload. This parameter is passed to further <code>UploadLayerPart</code> and <code>CompleteLayerUpload</code> operations.</p>
    ///   - [`part_size(Option<i64>)`](crate::output::InitiateLayerUploadOutput::part_size): <p>The size, in bytes, that Amazon ECR expects future layer part uploads to be.</p>
    /// - On failure, responds with [`SdkError<InitiateLayerUploadError>`](crate::error::InitiateLayerUploadError)
    pub fn initiate_layer_upload(&self) -> fluent_builders::InitiateLayerUpload {
        fluent_builders::InitiateLayerUpload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListImages`](crate::client::fluent_builders::ListImages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListImages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::ListImages::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::ListImages::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to list images. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::ListImages::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::ListImages::set_repository_name): <p>The repository with image IDs to be listed.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListImages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListImages::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>ListImages</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return.</p> <note>   <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>  </note>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListImages::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListImages::set_max_results): <p>The maximum number of image results returned by <code>ListImages</code> in paginated output. When this parameter is used, <code>ListImages</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListImages</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>ListImages</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>
    ///   - [`filter(ListImagesFilter)`](crate::client::fluent_builders::ListImages::filter) / [`set_filter(Option<ListImagesFilter>)`](crate::client::fluent_builders::ListImages::set_filter): <p>The filter key and value with which to filter your <code>ListImages</code> results.</p>
    /// - On success, responds with [`ListImagesOutput`](crate::output::ListImagesOutput) with field(s):
    ///   - [`image_ids(Option<Vec<ImageIdentifier>>)`](crate::output::ListImagesOutput::image_ids): <p>The list of image IDs for the requested repository.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListImagesOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListImages</code> request. When the results of a <code>ListImages</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListImagesError>`](crate::error::ListImagesError)
    pub fn list_images(&self) -> fluent_builders::ListImages {
        fluent_builders::ListImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the only supported resource is an Amazon ECR repository.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags for the resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutImage`](crate::client::fluent_builders::PutImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::PutImage::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::PutImage::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to put the image. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::PutImage::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::PutImage::set_repository_name): <p>The name of the repository in which to put the image.</p>
    ///   - [`image_manifest(impl Into<String>)`](crate::client::fluent_builders::PutImage::image_manifest) / [`set_image_manifest(Option<String>)`](crate::client::fluent_builders::PutImage::set_image_manifest): <p>The image manifest corresponding to the image to be uploaded.</p>
    ///   - [`image_manifest_media_type(impl Into<String>)`](crate::client::fluent_builders::PutImage::image_manifest_media_type) / [`set_image_manifest_media_type(Option<String>)`](crate::client::fluent_builders::PutImage::set_image_manifest_media_type): <p>The media type of the image manifest. If you push an image manifest that does not contain the <code>mediaType</code> field, you must specify the <code>imageManifestMediaType</code> in the request.</p>
    ///   - [`image_tag(impl Into<String>)`](crate::client::fluent_builders::PutImage::image_tag) / [`set_image_tag(Option<String>)`](crate::client::fluent_builders::PutImage::set_image_tag): <p>The tag to associate with the image. This parameter is required for images that use the Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.</p>
    ///   - [`image_digest(impl Into<String>)`](crate::client::fluent_builders::PutImage::image_digest) / [`set_image_digest(Option<String>)`](crate::client::fluent_builders::PutImage::set_image_digest): <p>The image digest of the image manifest corresponding to the image.</p>
    /// - On success, responds with [`PutImageOutput`](crate::output::PutImageOutput) with field(s):
    ///   - [`image(Option<Image>)`](crate::output::PutImageOutput::image): <p>Details of the image uploaded.</p>
    /// - On failure, responds with [`SdkError<PutImageError>`](crate::error::PutImageError)
    pub fn put_image(&self) -> fluent_builders::PutImage {
        fluent_builders::PutImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutImageScanningConfiguration`](crate::client::fluent_builders::PutImageScanningConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::PutImageScanningConfiguration::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::PutImageScanningConfiguration::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to update the image scanning configuration setting. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::PutImageScanningConfiguration::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::PutImageScanningConfiguration::set_repository_name): <p>The name of the repository in which to update the image scanning configuration setting.</p>
    ///   - [`image_scanning_configuration(ImageScanningConfiguration)`](crate::client::fluent_builders::PutImageScanningConfiguration::image_scanning_configuration) / [`set_image_scanning_configuration(Option<ImageScanningConfiguration>)`](crate::client::fluent_builders::PutImageScanningConfiguration::set_image_scanning_configuration): <p>The image scanning configuration for the repository. This setting determines whether images are scanned for known vulnerabilities after being pushed to the repository.</p>
    /// - On success, responds with [`PutImageScanningConfigurationOutput`](crate::output::PutImageScanningConfigurationOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::PutImageScanningConfigurationOutput::registry_id): <p>The registry ID associated with the request.</p>
    ///   - [`repository_name(Option<String>)`](crate::output::PutImageScanningConfigurationOutput::repository_name): <p>The repository name associated with the request.</p>
    ///   - [`image_scanning_configuration(Option<ImageScanningConfiguration>)`](crate::output::PutImageScanningConfigurationOutput::image_scanning_configuration): <p>The image scanning configuration setting for the repository.</p>
    /// - On failure, responds with [`SdkError<PutImageScanningConfigurationError>`](crate::error::PutImageScanningConfigurationError)
    pub fn put_image_scanning_configuration(
        &self,
    ) -> fluent_builders::PutImageScanningConfiguration {
        fluent_builders::PutImageScanningConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutImageTagMutability`](crate::client::fluent_builders::PutImageTagMutability) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::PutImageTagMutability::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::PutImageTagMutability::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to update the image tag mutability settings. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::PutImageTagMutability::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::PutImageTagMutability::set_repository_name): <p>The name of the repository in which to update the image tag mutability settings.</p>
    ///   - [`image_tag_mutability(ImageTagMutability)`](crate::client::fluent_builders::PutImageTagMutability::image_tag_mutability) / [`set_image_tag_mutability(Option<ImageTagMutability>)`](crate::client::fluent_builders::PutImageTagMutability::set_image_tag_mutability): <p>The tag mutability setting for the repository. If <code>MUTABLE</code> is specified, image tags can be overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.</p>
    /// - On success, responds with [`PutImageTagMutabilityOutput`](crate::output::PutImageTagMutabilityOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::PutImageTagMutabilityOutput::registry_id): <p>The registry ID associated with the request.</p>
    ///   - [`repository_name(Option<String>)`](crate::output::PutImageTagMutabilityOutput::repository_name): <p>The repository name associated with the request.</p>
    ///   - [`image_tag_mutability(Option<ImageTagMutability>)`](crate::output::PutImageTagMutabilityOutput::image_tag_mutability): <p>The image tag mutability setting for the repository.</p>
    /// - On failure, responds with [`SdkError<PutImageTagMutabilityError>`](crate::error::PutImageTagMutabilityError)
    pub fn put_image_tag_mutability(&self) -> fluent_builders::PutImageTagMutability {
        fluent_builders::PutImageTagMutability::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutLifecyclePolicy`](crate::client::fluent_builders::PutLifecyclePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::PutLifecyclePolicy::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::PutLifecyclePolicy::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do  not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::PutLifecyclePolicy::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::PutLifecyclePolicy::set_repository_name): <p>The name of the repository to receive the policy.</p>
    ///   - [`lifecycle_policy_text(impl Into<String>)`](crate::client::fluent_builders::PutLifecyclePolicy::lifecycle_policy_text) / [`set_lifecycle_policy_text(Option<String>)`](crate::client::fluent_builders::PutLifecyclePolicy::set_lifecycle_policy_text): <p>The JSON repository policy text to apply to the repository.</p>
    /// - On success, responds with [`PutLifecyclePolicyOutput`](crate::output::PutLifecyclePolicyOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::PutLifecyclePolicyOutput::registry_id): <p>The registry ID associated with the request.</p>
    ///   - [`repository_name(Option<String>)`](crate::output::PutLifecyclePolicyOutput::repository_name): <p>The repository name associated with the request.</p>
    ///   - [`lifecycle_policy_text(Option<String>)`](crate::output::PutLifecyclePolicyOutput::lifecycle_policy_text): <p>The JSON repository policy text.</p>
    /// - On failure, responds with [`SdkError<PutLifecyclePolicyError>`](crate::error::PutLifecyclePolicyError)
    pub fn put_lifecycle_policy(&self) -> fluent_builders::PutLifecyclePolicy {
        fluent_builders::PutLifecyclePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutRegistryPolicy`](crate::client::fluent_builders::PutRegistryPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_text(impl Into<String>)`](crate::client::fluent_builders::PutRegistryPolicy::policy_text) / [`set_policy_text(Option<String>)`](crate::client::fluent_builders::PutRegistryPolicy::set_policy_text): <p>The JSON policy text to apply to your registry. The policy text follows the same format as IAM policy text. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html">Registry permissions</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    /// - On success, responds with [`PutRegistryPolicyOutput`](crate::output::PutRegistryPolicyOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::PutRegistryPolicyOutput::registry_id): <p>The registry ID.</p>
    ///   - [`policy_text(Option<String>)`](crate::output::PutRegistryPolicyOutput::policy_text): <p>The JSON policy text for your registry.</p>
    /// - On failure, responds with [`SdkError<PutRegistryPolicyError>`](crate::error::PutRegistryPolicyError)
    pub fn put_registry_policy(&self) -> fluent_builders::PutRegistryPolicy {
        fluent_builders::PutRegistryPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutRegistryScanningConfiguration`](crate::client::fluent_builders::PutRegistryScanningConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scan_type(ScanType)`](crate::client::fluent_builders::PutRegistryScanningConfiguration::scan_type) / [`set_scan_type(Option<ScanType>)`](crate::client::fluent_builders::PutRegistryScanningConfiguration::set_scan_type): <p>The scanning type to set for the registry.</p>  <p>When a registry scanning configuration is not defined, by default the <code>BASIC</code> scan type is used. When basic scanning is used, you may specify filters to determine which individual repositories, or all repositories, are scanned when new images are pushed to those repositories. Alternatively, you can do manual scans of images with basic scanning.</p>  <p>When the <code>ENHANCED</code> scan type is set, Amazon Inspector provides automated vulnerability scanning. You may choose between continuous scanning or scan on push and you may specify filters to determine which individual repositories, or all repositories, are scanned.</p>
    ///   - [`rules(Vec<RegistryScanningRule>)`](crate::client::fluent_builders::PutRegistryScanningConfiguration::rules) / [`set_rules(Option<Vec<RegistryScanningRule>>)`](crate::client::fluent_builders::PutRegistryScanningConfiguration::set_rules): <p>The scanning rules to use for the registry. A scanning rule is used to determine which repository filters are used and at what frequency scanning will occur.</p>
    /// - On success, responds with [`PutRegistryScanningConfigurationOutput`](crate::output::PutRegistryScanningConfigurationOutput) with field(s):
    ///   - [`registry_scanning_configuration(Option<RegistryScanningConfiguration>)`](crate::output::PutRegistryScanningConfigurationOutput::registry_scanning_configuration): <p>The scanning configuration for your registry.</p>
    /// - On failure, responds with [`SdkError<PutRegistryScanningConfigurationError>`](crate::error::PutRegistryScanningConfigurationError)
    pub fn put_registry_scanning_configuration(
        &self,
    ) -> fluent_builders::PutRegistryScanningConfiguration {
        fluent_builders::PutRegistryScanningConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutReplicationConfiguration`](crate::client::fluent_builders::PutReplicationConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`replication_configuration(ReplicationConfiguration)`](crate::client::fluent_builders::PutReplicationConfiguration::replication_configuration) / [`set_replication_configuration(Option<ReplicationConfiguration>)`](crate::client::fluent_builders::PutReplicationConfiguration::set_replication_configuration): <p>An object representing the replication configuration for a registry.</p>
    /// - On success, responds with [`PutReplicationConfigurationOutput`](crate::output::PutReplicationConfigurationOutput) with field(s):
    ///   - [`replication_configuration(Option<ReplicationConfiguration>)`](crate::output::PutReplicationConfigurationOutput::replication_configuration): <p>The contents of the replication configuration for the registry.</p>
    /// - On failure, responds with [`SdkError<PutReplicationConfigurationError>`](crate::error::PutReplicationConfigurationError)
    pub fn put_replication_configuration(&self) -> fluent_builders::PutReplicationConfiguration {
        fluent_builders::PutReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetRepositoryPolicy`](crate::client::fluent_builders::SetRepositoryPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::SetRepositoryPolicy::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::SetRepositoryPolicy::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::SetRepositoryPolicy::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::SetRepositoryPolicy::set_repository_name): <p>The name of the repository to receive the policy.</p>
    ///   - [`policy_text(impl Into<String>)`](crate::client::fluent_builders::SetRepositoryPolicy::policy_text) / [`set_policy_text(Option<String>)`](crate::client::fluent_builders::SetRepositoryPolicy::set_policy_text): <p>The JSON repository policy text to apply to the repository. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR repository policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    ///   - [`force(bool)`](crate::client::fluent_builders::SetRepositoryPolicy::force) / [`set_force(bool)`](crate::client::fluent_builders::SetRepositoryPolicy::set_force): <p>If the policy you are attempting to set on a repository policy would prevent you from setting another policy in the future, you must force the <code>SetRepositoryPolicy</code> operation. This is intended to prevent accidental repository lock outs.</p>
    /// - On success, responds with [`SetRepositoryPolicyOutput`](crate::output::SetRepositoryPolicyOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::SetRepositoryPolicyOutput::registry_id): <p>The registry ID associated with the request.</p>
    ///   - [`repository_name(Option<String>)`](crate::output::SetRepositoryPolicyOutput::repository_name): <p>The repository name associated with the request.</p>
    ///   - [`policy_text(Option<String>)`](crate::output::SetRepositoryPolicyOutput::policy_text): <p>The JSON repository policy text applied to the repository.</p>
    /// - On failure, responds with [`SdkError<SetRepositoryPolicyError>`](crate::error::SetRepositoryPolicyError)
    pub fn set_repository_policy(&self) -> fluent_builders::SetRepositoryPolicy {
        fluent_builders::SetRepositoryPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartImageScan`](crate::client::fluent_builders::StartImageScan) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::StartImageScan::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::StartImageScan::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to start an image scan request. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::StartImageScan::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::StartImageScan::set_repository_name): <p>The name of the repository that contains the images to scan.</p>
    ///   - [`image_id(ImageIdentifier)`](crate::client::fluent_builders::StartImageScan::image_id) / [`set_image_id(Option<ImageIdentifier>)`](crate::client::fluent_builders::StartImageScan::set_image_id): <p>An object with identifying information for an image in an Amazon ECR repository.</p>
    /// - On success, responds with [`StartImageScanOutput`](crate::output::StartImageScanOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::StartImageScanOutput::registry_id): <p>The registry ID associated with the request.</p>
    ///   - [`repository_name(Option<String>)`](crate::output::StartImageScanOutput::repository_name): <p>The repository name associated with the request.</p>
    ///   - [`image_id(Option<ImageIdentifier>)`](crate::output::StartImageScanOutput::image_id): <p>An object with identifying information for an image in an Amazon ECR repository.</p>
    ///   - [`image_scan_status(Option<ImageScanStatus>)`](crate::output::StartImageScanOutput::image_scan_status): <p>The current state of the scan.</p>
    /// - On failure, responds with [`SdkError<StartImageScanError>`](crate::error::StartImageScanError)
    pub fn start_image_scan(&self) -> fluent_builders::StartImageScan {
        fluent_builders::StartImageScan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartLifecyclePolicyPreview`](crate::client::fluent_builders::StartLifecyclePolicyPreview) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::StartLifecyclePolicyPreview::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::StartLifecyclePolicyPreview::set_registry_id): <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::StartLifecyclePolicyPreview::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::StartLifecyclePolicyPreview::set_repository_name): <p>The name of the repository to be evaluated.</p>
    ///   - [`lifecycle_policy_text(impl Into<String>)`](crate::client::fluent_builders::StartLifecyclePolicyPreview::lifecycle_policy_text) / [`set_lifecycle_policy_text(Option<String>)`](crate::client::fluent_builders::StartLifecyclePolicyPreview::set_lifecycle_policy_text): <p>The policy to be evaluated against. If you do not specify a policy, the current policy for the repository is used.</p>
    /// - On success, responds with [`StartLifecyclePolicyPreviewOutput`](crate::output::StartLifecyclePolicyPreviewOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::StartLifecyclePolicyPreviewOutput::registry_id): <p>The registry ID associated with the request.</p>
    ///   - [`repository_name(Option<String>)`](crate::output::StartLifecyclePolicyPreviewOutput::repository_name): <p>The repository name associated with the request.</p>
    ///   - [`lifecycle_policy_text(Option<String>)`](crate::output::StartLifecyclePolicyPreviewOutput::lifecycle_policy_text): <p>The JSON repository policy text.</p>
    ///   - [`status(Option<LifecyclePolicyPreviewStatus>)`](crate::output::StartLifecyclePolicyPreviewOutput::status): <p>The status of the lifecycle policy preview request.</p>
    /// - On failure, responds with [`SdkError<StartLifecyclePolicyPreviewError>`](crate::error::StartLifecyclePolicyPreviewError)
    pub fn start_lifecycle_policy_preview(&self) -> fluent_builders::StartLifecyclePolicyPreview {
        fluent_builders::StartLifecyclePolicyPreview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the the resource to which to add tags. Currently, the only supported resource is an Amazon ECR repository.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource from which to remove tags. Currently, the only supported resource is an Amazon ECR repository.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The keys of the tags to be removed.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UploadLayerPart`](crate::client::fluent_builders::UploadLayerPart) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`registry_id(impl Into<String>)`](crate::client::fluent_builders::UploadLayerPart::registry_id) / [`set_registry_id(Option<String>)`](crate::client::fluent_builders::UploadLayerPart::set_registry_id): <p>The Amazon Web Services account ID associated with the registry to which you are uploading layer parts. If you do not specify a registry, the default registry is assumed.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::UploadLayerPart::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::UploadLayerPart::set_repository_name): <p>The name of the repository to which you are uploading layer parts.</p>
    ///   - [`upload_id(impl Into<String>)`](crate::client::fluent_builders::UploadLayerPart::upload_id) / [`set_upload_id(Option<String>)`](crate::client::fluent_builders::UploadLayerPart::set_upload_id): <p>The upload ID from a previous <code>InitiateLayerUpload</code> operation to associate with the layer part upload.</p>
    ///   - [`part_first_byte(i64)`](crate::client::fluent_builders::UploadLayerPart::part_first_byte) / [`set_part_first_byte(Option<i64>)`](crate::client::fluent_builders::UploadLayerPart::set_part_first_byte): <p>The position of the first byte of the layer part witin the overall image layer.</p>
    ///   - [`part_last_byte(i64)`](crate::client::fluent_builders::UploadLayerPart::part_last_byte) / [`set_part_last_byte(Option<i64>)`](crate::client::fluent_builders::UploadLayerPart::set_part_last_byte): <p>The position of the last byte of the layer part within the overall image layer.</p>
    ///   - [`layer_part_blob(Blob)`](crate::client::fluent_builders::UploadLayerPart::layer_part_blob) / [`set_layer_part_blob(Option<Blob>)`](crate::client::fluent_builders::UploadLayerPart::set_layer_part_blob): <p>The base64-encoded layer part payload.</p>
    /// - On success, responds with [`UploadLayerPartOutput`](crate::output::UploadLayerPartOutput) with field(s):
    ///   - [`registry_id(Option<String>)`](crate::output::UploadLayerPartOutput::registry_id): <p>The registry ID associated with the request.</p>
    ///   - [`repository_name(Option<String>)`](crate::output::UploadLayerPartOutput::repository_name): <p>The repository name associated with the request.</p>
    ///   - [`upload_id(Option<String>)`](crate::output::UploadLayerPartOutput::upload_id): <p>The upload ID associated with the request.</p>
    ///   - [`last_byte_received(Option<i64>)`](crate::output::UploadLayerPartOutput::last_byte_received): <p>The integer value of the last byte received in the request.</p>
    /// - On failure, responds with [`SdkError<UploadLayerPartError>`](crate::error::UploadLayerPartError)
    pub fn upload_layer_part(&self) -> fluent_builders::UploadLayerPart {
        fluent_builders::UploadLayerPart::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchCheckLayerAvailability`.
    ///
    /// <p>Checks the availability of one or more image layers in a repository.</p>
    /// <p>When an image is pushed to a repository, each image layer is checked to verify if it has been uploaded before. If it has been uploaded, then the image layer is skipped.</p> <note>
    /// <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchCheckLayerAvailability {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_check_layer_availability_input::Builder,
    }
    impl BatchCheckLayerAvailability {
        /// Creates a new `BatchCheckLayerAvailability`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCheckLayerAvailabilityOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCheckLayerAvailabilityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the image layers to check. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the image layers to check. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository that is associated with the image layers to check.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository that is associated with the image layers to check.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `layerDigests`.
        ///
        /// To override the contents of this collection use [`set_layer_digests`](Self::set_layer_digests).
        ///
        /// <p>The digests of the image layers to check.</p>
        pub fn layer_digests(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_digests(input.into());
            self
        }
        /// <p>The digests of the image layers to check.</p>
        pub fn set_layer_digests(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_layer_digests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeleteImage`.
    ///
    /// <p>Deletes a list of specified images within a repository. Images are specified with either an <code>imageTag</code> or <code>imageDigest</code>.</p>
    /// <p>You can remove a tag from an image by specifying the image's tag in your request. When you remove the last tag from an image, the image is deleted from your repository.</p>
    /// <p>You can completely delete an image (and all of its tags) by specifying the image's digest in your request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDeleteImage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_delete_image_input::Builder,
    }
    impl BatchDeleteImage {
        /// Creates a new `BatchDeleteImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteImageOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteImageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the image to delete. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the image to delete. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The repository that contains the image to delete.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The repository that contains the image to delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `imageIds`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>A list of image ID references that correspond to images to delete. The format of the <code>imageIds</code> reference is <code>imageTag=tag</code> or <code>imageDigest=digest</code>.</p>
        pub fn image_ids(mut self, input: crate::model::ImageIdentifier) -> Self {
            self.inner = self.inner.image_ids(input);
            self
        }
        /// <p>A list of image ID references that correspond to images to delete. The format of the <code>imageIds</code> reference is <code>imageTag=tag</code> or <code>imageDigest=digest</code>.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.inner = self.inner.set_image_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetImage`.
    ///
    /// <p>Gets detailed information for an image. Images are specified with either an <code>imageTag</code> or <code>imageDigest</code>.</p>
    /// <p>When an image is pulled, the BatchGetImage API is called once to retrieve the image manifest.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetImage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_image_input::Builder,
    }
    impl BatchGetImage {
        /// Creates a new `BatchGetImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetImageOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetImageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the images to describe. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the images to describe. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The repository that contains the images to describe.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The repository that contains the images to describe.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `imageIds`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>A list of image ID references that correspond to images to describe. The format of the <code>imageIds</code> reference is <code>imageTag=tag</code> or <code>imageDigest=digest</code>.</p>
        pub fn image_ids(mut self, input: crate::model::ImageIdentifier) -> Self {
            self.inner = self.inner.image_ids(input);
            self
        }
        /// <p>A list of image ID references that correspond to images to describe. The format of the <code>imageIds</code> reference is <code>imageTag=tag</code> or <code>imageDigest=digest</code>.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.inner = self.inner.set_image_ids(input);
            self
        }
        /// Appends an item to `acceptedMediaTypes`.
        ///
        /// To override the contents of this collection use [`set_accepted_media_types`](Self::set_accepted_media_types).
        ///
        /// <p>The accepted media types for the request.</p>
        /// <p>Valid values: <code>application/vnd.docker.distribution.manifest.v1+json</code> | <code>application/vnd.docker.distribution.manifest.v2+json</code> | <code>application/vnd.oci.image.manifest.v1+json</code> </p>
        pub fn accepted_media_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accepted_media_types(input.into());
            self
        }
        /// <p>The accepted media types for the request.</p>
        /// <p>Valid values: <code>application/vnd.docker.distribution.manifest.v1+json</code> | <code>application/vnd.docker.distribution.manifest.v2+json</code> | <code>application/vnd.oci.image.manifest.v1+json</code> </p>
        pub fn set_accepted_media_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_accepted_media_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetRepositoryScanningConfiguration`.
    ///
    /// <p>Gets the scanning configuration for one or more repositories.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetRepositoryScanningConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_repository_scanning_configuration_input::Builder,
    }
    impl BatchGetRepositoryScanningConfiguration {
        /// Creates a new `BatchGetRepositoryScanningConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetRepositoryScanningConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::BatchGetRepositoryScanningConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `repositoryNames`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p>One or more repository names to get the scanning configuration for.</p>
        pub fn repository_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_names(input.into());
            self
        }
        /// <p>One or more repository names to get the scanning configuration for.</p>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_repository_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CompleteLayerUpload`.
    ///
    /// <p>Informs Amazon ECR that the image layer upload has completed for a specified registry, repository name, and upload ID. You can optionally provide a <code>sha256</code> digest of the image layer for data validation purposes.</p>
    /// <p>When an image is pushed, the CompleteLayerUpload API is called once per each new image layer to verify that the upload has completed.</p> <note>
    /// <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CompleteLayerUpload {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::complete_layer_upload_input::Builder,
    }
    impl CompleteLayerUpload {
        /// Creates a new `CompleteLayerUpload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CompleteLayerUploadOutput,
            aws_smithy_http::result::SdkError<crate::error::CompleteLayerUploadError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry to which to upload layers. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry to which to upload layers. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to associate with the image layer.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository to associate with the image layer.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The upload ID from a previous <code>InitiateLayerUpload</code> operation to associate with the image layer.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.upload_id(input.into());
            self
        }
        /// <p>The upload ID from a previous <code>InitiateLayerUpload</code> operation to associate with the image layer.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_upload_id(input);
            self
        }
        /// Appends an item to `layerDigests`.
        ///
        /// To override the contents of this collection use [`set_layer_digests`](Self::set_layer_digests).
        ///
        /// <p>The <code>sha256</code> digest of the image layer.</p>
        pub fn layer_digests(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_digests(input.into());
            self
        }
        /// <p>The <code>sha256</code> digest of the image layer.</p>
        pub fn set_layer_digests(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_layer_digests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePullThroughCacheRule`.
    ///
    /// <p>Creates a pull through cache rule. A pull through cache rule provides a way to cache images from an external public registry in your Amazon ECR private registry.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePullThroughCacheRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_pull_through_cache_rule_input::Builder,
    }
    impl CreatePullThroughCacheRule {
        /// Creates a new `CreatePullThroughCacheRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePullThroughCacheRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePullThroughCacheRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The repository name prefix to use when caching images from the source registry.</p>
        pub fn ecr_repository_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ecr_repository_prefix(input.into());
            self
        }
        /// <p>The repository name prefix to use when caching images from the source registry.</p>
        pub fn set_ecr_repository_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ecr_repository_prefix(input);
            self
        }
        /// <p>The registry URL of the upstream public registry to use as the source for the pull through cache rule.</p>
        pub fn upstream_registry_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.upstream_registry_url(input.into());
            self
        }
        /// <p>The registry URL of the upstream public registry to use as the source for the pull through cache rule.</p>
        pub fn set_upstream_registry_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_upstream_registry_url(input);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry to create the pull through cache rule for. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry to create the pull through cache rule for. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRepository`.
    ///
    /// <p>Creates a repository. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html">Amazon ECR repositories</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRepository {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_repository_input::Builder,
    }
    impl CreateRepository {
        /// Creates a new `CreateRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRepositoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry to create the repository. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry to create the repository. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name to use for the repository. The repository name may be specified on its own (such as <code>nginx-web-app</code>) or it can be prepended with a namespace to group the repository into a category (such as <code>project-a/nginx-web-app</code>).</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name to use for the repository. The repository name may be specified on its own (such as <code>nginx-web-app</code>) or it can be prepended with a namespace to group the repository into a category (such as <code>project-a/nginx-web-app</code>).</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the repository to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The metadata that you apply to the repository to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The tag mutability setting for the repository. If this parameter is omitted, the default setting of <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.</p>
        pub fn image_tag_mutability(mut self, input: crate::model::ImageTagMutability) -> Self {
            self.inner = self.inner.image_tag_mutability(input);
            self
        }
        /// <p>The tag mutability setting for the repository. If this parameter is omitted, the default setting of <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.</p>
        pub fn set_image_tag_mutability(
            mut self,
            input: std::option::Option<crate::model::ImageTagMutability>,
        ) -> Self {
            self.inner = self.inner.set_image_tag_mutability(input);
            self
        }
        /// <p>The image scanning configuration for the repository. This determines whether images are scanned for known vulnerabilities after being pushed to the repository.</p>
        pub fn image_scanning_configuration(
            mut self,
            input: crate::model::ImageScanningConfiguration,
        ) -> Self {
            self.inner = self.inner.image_scanning_configuration(input);
            self
        }
        /// <p>The image scanning configuration for the repository. This determines whether images are scanned for known vulnerabilities after being pushed to the repository.</p>
        pub fn set_image_scanning_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageScanningConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_image_scanning_configuration(input);
            self
        }
        /// <p>The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.</p>
        pub fn encryption_configuration(
            mut self,
            input: crate::model::EncryptionConfiguration,
        ) -> Self {
            self.inner = self.inner.encryption_configuration(input);
            self
        }
        /// <p>The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_encryption_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLifecyclePolicy`.
    ///
    /// <p>Deletes the lifecycle policy associated with the specified repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLifecyclePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_lifecycle_policy_input::Builder,
    }
    impl DeleteLifecyclePolicy {
        /// Creates a new `DeleteLifecyclePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLifecyclePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLifecyclePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePullThroughCacheRule`.
    ///
    /// <p>Deletes a pull through cache rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePullThroughCacheRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_pull_through_cache_rule_input::Builder,
    }
    impl DeletePullThroughCacheRule {
        /// Creates a new `DeletePullThroughCacheRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePullThroughCacheRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePullThroughCacheRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon ECR repository prefix associated with the pull through cache rule to delete.</p>
        pub fn ecr_repository_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ecr_repository_prefix(input.into());
            self
        }
        /// <p>The Amazon ECR repository prefix associated with the pull through cache rule to delete.</p>
        pub fn set_ecr_repository_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ecr_repository_prefix(input);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the pull through cache rule. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the pull through cache rule. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRegistryPolicy`.
    ///
    /// <p>Deletes the registry permissions policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRegistryPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_registry_policy_input::Builder,
    }
    impl DeleteRegistryPolicy {
        /// Creates a new `DeleteRegistryPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRegistryPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRegistryPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteRepository`.
    ///
    /// <p>Deletes a repository. If the repository contains images, you must either delete all images in the repository or use the <code>force</code> option to delete the repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRepository {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_repository_input::Builder,
    }
    impl DeleteRepository {
        /// Creates a new `DeleteRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRepositoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository to delete. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository to delete. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to delete.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository to delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p> If a repository contains images, forces the deletion.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p> If a repository contains images, forces the deletion.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRepositoryPolicy`.
    ///
    /// <p>Deletes the repository policy associated with the specified repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRepositoryPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_repository_policy_input::Builder,
    }
    impl DeleteRepositoryPolicy {
        /// Creates a new `DeleteRepositoryPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRepositoryPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRepositoryPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository policy to delete. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository policy to delete. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository that is associated with the repository policy to delete.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository that is associated with the repository policy to delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImageReplicationStatus`.
    ///
    /// <p>Returns the replication status for a specified image.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeImageReplicationStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_image_replication_status_input::Builder,
    }
    impl DescribeImageReplicationStatus {
        /// Creates a new `DescribeImageReplicationStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImageReplicationStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImageReplicationStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that the image is in.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository that the image is in.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn image_id(mut self, input: crate::model::ImageIdentifier) -> Self {
            self.inner = self.inner.image_id(input);
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn set_image_id(
            mut self,
            input: std::option::Option<crate::model::ImageIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImages`.
    ///
    /// <p>Returns metadata about the images in a repository.</p> <note>
    /// <p>Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker registry. The output of the <code>docker images</code> command shows the uncompressed image size, so it may return a larger image size than the image sizes returned by <code>DescribeImages</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeImages {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_images_input::Builder,
    }
    impl DescribeImages {
        /// Creates a new `DescribeImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImagesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeImagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeImagesPaginator {
            crate::paginator::DescribeImagesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to describe images. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to describe images. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The repository that contains the images to describe.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The repository that contains the images to describe.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `imageIds`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>The list of image IDs for the requested repository.</p>
        pub fn image_ids(mut self, input: crate::model::ImageIdentifier) -> Self {
            self.inner = self.inner.image_ids(input);
            self
        }
        /// <p>The list of image IDs for the requested repository.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.inner = self.inner.set_image_ids(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeImages</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return. This option cannot be used when you specify images with <code>imageIds</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeImages</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return. This option cannot be used when you specify images with <code>imageIds</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeImages</code> in paginated output. When this parameter is used, <code>DescribeImages</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeImages</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>DescribeImages</code> returns up to 100 results and a <code>nextToken</code> value, if applicable. This option cannot be used when you specify images with <code>imageIds</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeImages</code> in paginated output. When this parameter is used, <code>DescribeImages</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeImages</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>DescribeImages</code> returns up to 100 results and a <code>nextToken</code> value, if applicable. This option cannot be used when you specify images with <code>imageIds</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The filter key and value with which to filter your <code>DescribeImages</code> results.</p>
        pub fn filter(mut self, input: crate::model::DescribeImagesFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>The filter key and value with which to filter your <code>DescribeImages</code> results.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::DescribeImagesFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImageScanFindings`.
    ///
    /// <p>Returns the scan findings for the specified image.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeImageScanFindings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_image_scan_findings_input::Builder,
    }
    impl DescribeImageScanFindings {
        /// Creates a new `DescribeImageScanFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImageScanFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImageScanFindingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeImageScanFindingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeImageScanFindingsPaginator {
            crate::paginator::DescribeImageScanFindingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to describe the image scan findings for. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to describe the image scan findings for. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The repository for the image for which to describe the scan findings.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The repository for the image for which to describe the scan findings.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn image_id(mut self, input: crate::model::ImageIdentifier) -> Self {
            self.inner = self.inner.image_id(input);
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn set_image_id(
            mut self,
            input: std::option::Option<crate::model::ImageIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeImageScanFindings</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeImageScanFindings</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of image scan results returned by <code>DescribeImageScanFindings</code> in paginated output. When this parameter is used, <code>DescribeImageScanFindings</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeImageScanFindings</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>DescribeImageScanFindings</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of image scan results returned by <code>DescribeImageScanFindings</code> in paginated output. When this parameter is used, <code>DescribeImageScanFindings</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeImageScanFindings</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>DescribeImageScanFindings</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePullThroughCacheRules`.
    ///
    /// <p>Returns the pull through cache rules for a registry.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePullThroughCacheRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_pull_through_cache_rules_input::Builder,
    }
    impl DescribePullThroughCacheRules {
        /// Creates a new `DescribePullThroughCacheRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePullThroughCacheRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePullThroughCacheRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribePullThroughCacheRulesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribePullThroughCacheRulesPaginator {
            crate::paginator::DescribePullThroughCacheRulesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Web Services account ID associated with the registry to return the pull through cache rules for. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry to return the pull through cache rules for. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// Appends an item to `ecrRepositoryPrefixes`.
        ///
        /// To override the contents of this collection use [`set_ecr_repository_prefixes`](Self::set_ecr_repository_prefixes).
        ///
        /// <p>The Amazon ECR repository prefixes associated with the pull through cache rules to return. If no repository prefix value is specified, all pull through cache rules are returned.</p>
        pub fn ecr_repository_prefixes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ecr_repository_prefixes(input.into());
            self
        }
        /// <p>The Amazon ECR repository prefixes associated with the pull through cache rules to return. If no repository prefix value is specified, all pull through cache rules are returned.</p>
        pub fn set_ecr_repository_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ecr_repository_prefixes(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribePullThroughCacheRulesRequest</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribePullThroughCacheRulesRequest</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of pull through cache rules returned by <code>DescribePullThroughCacheRulesRequest</code> in paginated output. When this parameter is used, <code>DescribePullThroughCacheRulesRequest</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribePullThroughCacheRulesRequest</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>DescribePullThroughCacheRulesRequest</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of pull through cache rules returned by <code>DescribePullThroughCacheRulesRequest</code> in paginated output. When this parameter is used, <code>DescribePullThroughCacheRulesRequest</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribePullThroughCacheRulesRequest</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>DescribePullThroughCacheRulesRequest</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRegistry`.
    ///
    /// <p>Describes the settings for a registry. The replication configuration for a repository can be created or updated with the <code>PutReplicationConfiguration</code> API action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRegistry {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_registry_input::Builder,
    }
    impl DescribeRegistry {
        /// Creates a new `DescribeRegistry`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRegistryOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRegistryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeRepositories`.
    ///
    /// <p>Describes image repositories in a registry.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRepositories {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_repositories_input::Builder,
    }
    impl DescribeRepositories {
        /// Creates a new `DescribeRepositories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRepositoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRepositoriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeRepositoriesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeRepositoriesPaginator {
            crate::paginator::DescribeRepositoriesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repositories to be described. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repositories to be described. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// Appends an item to `repositoryNames`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p>A list of repositories to describe. If this parameter is omitted, then all repositories in a registry are described.</p>
        pub fn repository_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_names(input.into());
            self
        }
        /// <p>A list of repositories to describe. If this parameter is omitted, then all repositories in a registry are described.</p>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_repository_names(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeRepositories</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return. This option cannot be used when you specify repositories with <code>repositoryNames</code>.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeRepositories</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return. This option cannot be used when you specify repositories with <code>repositoryNames</code>.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeRepositories</code> in paginated output. When this parameter is used, <code>DescribeRepositories</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeRepositories</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>DescribeRepositories</code> returns up to 100 results and a <code>nextToken</code> value, if applicable. This option cannot be used when you specify repositories with <code>repositoryNames</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeRepositories</code> in paginated output. When this parameter is used, <code>DescribeRepositories</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeRepositories</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>DescribeRepositories</code> returns up to 100 results and a <code>nextToken</code> value, if applicable. This option cannot be used when you specify repositories with <code>repositoryNames</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAuthorizationToken`.
    ///
    /// <p>Retrieves an authorization token. An authorization token represents your IAM authentication credentials and can be used to access any Amazon ECR registry that your IAM principal has access to. The authorization token is valid for 12 hours.</p>
    /// <p>The <code>authorizationToken</code> returned is a base64 encoded string that can be decoded and used in a <code>docker login</code> command to authenticate to a registry. The CLI offers an <code>get-login-password</code> command that simplifies the login process. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Registries.html#registry_auth">Registry authentication</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAuthorizationToken {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_authorization_token_input::Builder,
    }
    impl GetAuthorizationToken {
        /// Creates a new `GetAuthorizationToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAuthorizationTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAuthorizationTokenError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `registryIds`.
        ///
        /// To override the contents of this collection use [`set_registry_ids`](Self::set_registry_ids).
        ///
        /// <p>A list of Amazon Web Services account IDs that are associated with the registries for which to get AuthorizationData objects. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_ids(input.into());
            self
        }
        /// <p>A list of Amazon Web Services account IDs that are associated with the registries for which to get AuthorizationData objects. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_registry_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDownloadUrlForLayer`.
    ///
    /// <p>Retrieves the pre-signed Amazon S3 download URL corresponding to an image layer. You can only get URLs for image layers that are referenced in an image.</p>
    /// <p>When an image is pulled, the GetDownloadUrlForLayer API is called once per image layer that is not already cached.</p> <note>
    /// <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDownloadUrlForLayer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_download_url_for_layer_input::Builder,
    }
    impl GetDownloadUrlForLayer {
        /// Creates a new `GetDownloadUrlForLayer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDownloadUrlForLayerOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDownloadUrlForLayerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the image layer to download. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the image layer to download. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository that is associated with the image layer to download.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository that is associated with the image layer to download.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The digest of the image layer to download.</p>
        pub fn layer_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_digest(input.into());
            self
        }
        /// <p>The digest of the image layer to download.</p>
        pub fn set_layer_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_layer_digest(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLifecyclePolicy`.
    ///
    /// <p>Retrieves the lifecycle policy for the specified repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLifecyclePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_lifecycle_policy_input::Builder,
    }
    impl GetLifecyclePolicy {
        /// Creates a new `GetLifecyclePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLifecyclePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLifecyclePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLifecyclePolicyPreview`.
    ///
    /// <p>Retrieves the results of the lifecycle policy preview request for the specified repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLifecyclePolicyPreview {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_lifecycle_policy_preview_input::Builder,
    }
    impl GetLifecyclePolicyPreview {
        /// Creates a new `GetLifecyclePolicyPreview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLifecyclePolicyPreviewOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLifecyclePolicyPreviewError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetLifecyclePolicyPreviewPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetLifecyclePolicyPreviewPaginator {
            crate::paginator::GetLifecyclePolicyPreviewPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `imageIds`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>The list of imageIDs to be included.</p>
        pub fn image_ids(mut self, input: crate::model::ImageIdentifier) -> Self {
            self.inner = self.inner.image_ids(input);
            self
        }
        /// <p>The list of imageIDs to be included.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.inner = self.inner.set_image_ids(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated  <code>GetLifecyclePolicyPreviewRequest</code> request where <code>maxResults</code> was used and the  results exceeded the value of that parameter. Pagination continues from the end of the  previous results that returned the <code>nextToken</code> value. This value is  <code>null</code> when there are no more results to return. This option cannot be used when you specify images with <code>imageIds</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated  <code>GetLifecyclePolicyPreviewRequest</code> request where <code>maxResults</code> was used and the  results exceeded the value of that parameter. Pagination continues from the end of the  previous results that returned the <code>nextToken</code> value. This value is  <code>null</code> when there are no more results to return. This option cannot be used when you specify images with <code>imageIds</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of repository results returned by <code>GetLifecyclePolicyPreviewRequest</code> in  paginated output. When this parameter is used, <code>GetLifecyclePolicyPreviewRequest</code> only returns  <code>maxResults</code> results in a single page along with a <code>nextToken</code>  response element. The remaining results of the initial request can be seen by sending  another <code>GetLifecyclePolicyPreviewRequest</code> request with the returned <code>nextToken</code>  value. This value can be between 1 and 1000. If this  parameter is not used, then <code>GetLifecyclePolicyPreviewRequest</code> returns up to  100 results and a <code>nextToken</code> value, if  applicable. This option cannot be used when you specify images with <code>imageIds</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of repository results returned by <code>GetLifecyclePolicyPreviewRequest</code> in  paginated output. When this parameter is used, <code>GetLifecyclePolicyPreviewRequest</code> only returns  <code>maxResults</code> results in a single page along with a <code>nextToken</code>  response element. The remaining results of the initial request can be seen by sending  another <code>GetLifecyclePolicyPreviewRequest</code> request with the returned <code>nextToken</code>  value. This value can be between 1 and 1000. If this  parameter is not used, then <code>GetLifecyclePolicyPreviewRequest</code> returns up to  100 results and a <code>nextToken</code> value, if  applicable. This option cannot be used when you specify images with <code>imageIds</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional parameter that filters results based on image tag status and all tags, if tagged.</p>
        pub fn filter(mut self, input: crate::model::LifecyclePolicyPreviewFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>An optional parameter that filters results based on image tag status and all tags, if tagged.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::LifecyclePolicyPreviewFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRegistryPolicy`.
    ///
    /// <p>Retrieves the permissions policy for a registry.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRegistryPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_registry_policy_input::Builder,
    }
    impl GetRegistryPolicy {
        /// Creates a new `GetRegistryPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRegistryPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRegistryPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetRegistryScanningConfiguration`.
    ///
    /// <p>Retrieves the scanning configuration for a registry.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRegistryScanningConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_registry_scanning_configuration_input::Builder,
    }
    impl GetRegistryScanningConfiguration {
        /// Creates a new `GetRegistryScanningConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRegistryScanningConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRegistryScanningConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetRepositoryPolicy`.
    ///
    /// <p>Retrieves the repository policy for the specified repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRepositoryPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_repository_policy_input::Builder,
    }
    impl GetRepositoryPolicy {
        /// Creates a new `GetRepositoryPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRepositoryPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRepositoryPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository with the policy to retrieve.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository with the policy to retrieve.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InitiateLayerUpload`.
    ///
    /// <p>Notifies Amazon ECR that you intend to upload an image layer.</p>
    /// <p>When an image is pushed, the InitiateLayerUpload API is called once per image layer that has not already been uploaded. Whether or not an image layer has been uploaded is determined by the BatchCheckLayerAvailability API action.</p> <note>
    /// <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct InitiateLayerUpload {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::initiate_layer_upload_input::Builder,
    }
    impl InitiateLayerUpload {
        /// Creates a new `InitiateLayerUpload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InitiateLayerUploadOutput,
            aws_smithy_http::result::SdkError<crate::error::InitiateLayerUploadError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry to which you intend to upload layers. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry to which you intend to upload layers. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to which you intend to upload layers.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository to which you intend to upload layers.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImages`.
    ///
    /// <p>Lists all the image IDs for the specified repository.</p>
    /// <p>You can filter images based on whether or not they are tagged by using the <code>tagStatus</code> filter and specifying either <code>TAGGED</code>, <code>UNTAGGED</code> or <code>ANY</code>. For example, you can filter your results to return only <code>UNTAGGED</code> images and then pipe that result to a <code>BatchDeleteImage</code> operation to delete them. Or, you can filter your results to return only <code>TAGGED</code> images to list all of the tags in your repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListImages {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_images_input::Builder,
    }
    impl ListImages {
        /// Creates a new `ListImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImagesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListImagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListImagesPaginator {
            crate::paginator::ListImagesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to list images. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to list images. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The repository with image IDs to be listed.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The repository with image IDs to be listed.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListImages</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListImages</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of image results returned by <code>ListImages</code> in paginated output. When this parameter is used, <code>ListImages</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListImages</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>ListImages</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of image results returned by <code>ListImages</code> in paginated output. When this parameter is used, <code>ListImages</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListImages</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>ListImages</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The filter key and value with which to filter your <code>ListImages</code> results.</p>
        pub fn filter(mut self, input: crate::model::ListImagesFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>The filter key and value with which to filter your <code>ListImages</code> results.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ListImagesFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List the tags for an Amazon ECR resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the only supported resource is an Amazon ECR repository.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the only supported resource is an Amazon ECR repository.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutImage`.
    ///
    /// <p>Creates or updates the image manifest and tags associated with an image.</p>
    /// <p>When an image is pushed and all new image layers have been uploaded, the PutImage API is called once to create or update the image manifest and the tags associated with the image.</p> <note>
    /// <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutImage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_image_input::Builder,
    }
    impl PutImage {
        /// Creates a new `PutImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutImageOutput,
            aws_smithy_http::result::SdkError<crate::error::PutImageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to put the image. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to put the image. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository in which to put the image.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository in which to put the image.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The image manifest corresponding to the image to be uploaded.</p>
        pub fn image_manifest(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_manifest(input.into());
            self
        }
        /// <p>The image manifest corresponding to the image to be uploaded.</p>
        pub fn set_image_manifest(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_manifest(input);
            self
        }
        /// <p>The media type of the image manifest. If you push an image manifest that does not contain the <code>mediaType</code> field, you must specify the <code>imageManifestMediaType</code> in the request.</p>
        pub fn image_manifest_media_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_manifest_media_type(input.into());
            self
        }
        /// <p>The media type of the image manifest. If you push an image manifest that does not contain the <code>mediaType</code> field, you must specify the <code>imageManifestMediaType</code> in the request.</p>
        pub fn set_image_manifest_media_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_manifest_media_type(input);
            self
        }
        /// <p>The tag to associate with the image. This parameter is required for images that use the Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.</p>
        pub fn image_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_tag(input.into());
            self
        }
        /// <p>The tag to associate with the image. This parameter is required for images that use the Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.</p>
        pub fn set_image_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_tag(input);
            self
        }
        /// <p>The image digest of the image manifest corresponding to the image.</p>
        pub fn image_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_digest(input.into());
            self
        }
        /// <p>The image digest of the image manifest corresponding to the image.</p>
        pub fn set_image_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_digest(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutImageScanningConfiguration`.
    ///
    /// <important>
    /// <p>The <code>PutImageScanningConfiguration</code> API is being deprecated, in favor of specifying the image scanning configuration at the registry level. For more information, see <code>PutRegistryScanningConfiguration</code>.</p>
    /// </important>
    /// <p>Updates the image scanning configuration for the specified repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutImageScanningConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_image_scanning_configuration_input::Builder,
    }
    impl PutImageScanningConfiguration {
        /// Creates a new `PutImageScanningConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutImageScanningConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutImageScanningConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to update the image scanning configuration setting. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to update the image scanning configuration setting. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository in which to update the image scanning configuration setting.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository in which to update the image scanning configuration setting.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The image scanning configuration for the repository. This setting determines whether images are scanned for known vulnerabilities after being pushed to the repository.</p>
        pub fn image_scanning_configuration(
            mut self,
            input: crate::model::ImageScanningConfiguration,
        ) -> Self {
            self.inner = self.inner.image_scanning_configuration(input);
            self
        }
        /// <p>The image scanning configuration for the repository. This setting determines whether images are scanned for known vulnerabilities after being pushed to the repository.</p>
        pub fn set_image_scanning_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageScanningConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_image_scanning_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutImageTagMutability`.
    ///
    /// <p>Updates the image tag mutability settings for the specified repository. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-tag-mutability.html">Image tag mutability</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutImageTagMutability {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_image_tag_mutability_input::Builder,
    }
    impl PutImageTagMutability {
        /// Creates a new `PutImageTagMutability`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutImageTagMutabilityOutput,
            aws_smithy_http::result::SdkError<crate::error::PutImageTagMutabilityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to update the image tag mutability settings. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to update the image tag mutability settings. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository in which to update the image tag mutability settings.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository in which to update the image tag mutability settings.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The tag mutability setting for the repository. If <code>MUTABLE</code> is specified, image tags can be overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.</p>
        pub fn image_tag_mutability(mut self, input: crate::model::ImageTagMutability) -> Self {
            self.inner = self.inner.image_tag_mutability(input);
            self
        }
        /// <p>The tag mutability setting for the repository. If <code>MUTABLE</code> is specified, image tags can be overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.</p>
        pub fn set_image_tag_mutability(
            mut self,
            input: std::option::Option<crate::model::ImageTagMutability>,
        ) -> Self {
            self.inner = self.inner.set_image_tag_mutability(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLifecyclePolicy`.
    ///
    /// <p>Creates or updates the lifecycle policy for the specified repository. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html">Lifecycle policy template</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutLifecyclePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_lifecycle_policy_input::Builder,
    }
    impl PutLifecyclePolicy {
        /// Creates a new `PutLifecyclePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLifecyclePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLifecyclePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do  not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do  not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to receive the policy.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository to receive the policy.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The JSON repository policy text to apply to the repository.</p>
        pub fn lifecycle_policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lifecycle_policy_text(input.into());
            self
        }
        /// <p>The JSON repository policy text to apply to the repository.</p>
        pub fn set_lifecycle_policy_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_lifecycle_policy_text(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRegistryPolicy`.
    ///
    /// <p>Creates or updates the permissions policy for your registry.</p>
    /// <p>A registry policy is used to specify permissions for another Amazon Web Services account and is used when configuring cross-account replication. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html">Registry permissions</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutRegistryPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_registry_policy_input::Builder,
    }
    impl PutRegistryPolicy {
        /// Creates a new `PutRegistryPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRegistryPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRegistryPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The JSON policy text to apply to your registry. The policy text follows the same format as IAM policy text. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html">Registry permissions</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
        pub fn policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_text(input.into());
            self
        }
        /// <p>The JSON policy text to apply to your registry. The policy text follows the same format as IAM policy text. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html">Registry permissions</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
        pub fn set_policy_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_text(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRegistryScanningConfiguration`.
    ///
    /// <p>Creates or updates the scanning configuration for your private registry.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutRegistryScanningConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_registry_scanning_configuration_input::Builder,
    }
    impl PutRegistryScanningConfiguration {
        /// Creates a new `PutRegistryScanningConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRegistryScanningConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRegistryScanningConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The scanning type to set for the registry.</p>
        /// <p>When a registry scanning configuration is not defined, by default the <code>BASIC</code> scan type is used. When basic scanning is used, you may specify filters to determine which individual repositories, or all repositories, are scanned when new images are pushed to those repositories. Alternatively, you can do manual scans of images with basic scanning.</p>
        /// <p>When the <code>ENHANCED</code> scan type is set, Amazon Inspector provides automated vulnerability scanning. You may choose between continuous scanning or scan on push and you may specify filters to determine which individual repositories, or all repositories, are scanned.</p>
        pub fn scan_type(mut self, input: crate::model::ScanType) -> Self {
            self.inner = self.inner.scan_type(input);
            self
        }
        /// <p>The scanning type to set for the registry.</p>
        /// <p>When a registry scanning configuration is not defined, by default the <code>BASIC</code> scan type is used. When basic scanning is used, you may specify filters to determine which individual repositories, or all repositories, are scanned when new images are pushed to those repositories. Alternatively, you can do manual scans of images with basic scanning.</p>
        /// <p>When the <code>ENHANCED</code> scan type is set, Amazon Inspector provides automated vulnerability scanning. You may choose between continuous scanning or scan on push and you may specify filters to determine which individual repositories, or all repositories, are scanned.</p>
        pub fn set_scan_type(mut self, input: std::option::Option<crate::model::ScanType>) -> Self {
            self.inner = self.inner.set_scan_type(input);
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The scanning rules to use for the registry. A scanning rule is used to determine which repository filters are used and at what frequency scanning will occur.</p>
        pub fn rules(mut self, input: crate::model::RegistryScanningRule) -> Self {
            self.inner = self.inner.rules(input);
            self
        }
        /// <p>The scanning rules to use for the registry. A scanning rule is used to determine which repository filters are used and at what frequency scanning will occur.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegistryScanningRule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutReplicationConfiguration`.
    ///
    /// <p>Creates or updates the replication configuration for a registry. The existing replication configuration for a repository can be retrieved with the <code>DescribeRegistry</code> API action. The first time the PutReplicationConfiguration API is called, a service-linked IAM role is created in your account for the replication process. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/using-service-linked-roles.html">Using service-linked roles for Amazon ECR</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p> <note>
    /// <p>When configuring cross-account replication, the destination account must grant the source account permission to replicate. This permission is controlled using a registry permissions policy. For more information, see <code>PutRegistryPolicy</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutReplicationConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_replication_configuration_input::Builder,
    }
    impl PutReplicationConfiguration {
        /// Creates a new `PutReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutReplicationConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An object representing the replication configuration for a registry.</p>
        pub fn replication_configuration(
            mut self,
            input: crate::model::ReplicationConfiguration,
        ) -> Self {
            self.inner = self.inner.replication_configuration(input);
            self
        }
        /// <p>An object representing the replication configuration for a registry.</p>
        pub fn set_replication_configuration(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_replication_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetRepositoryPolicy`.
    ///
    /// <p>Applies a repository policy to the specified repository to control access permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html">Amazon ECR Repository policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetRepositoryPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_repository_policy_input::Builder,
    }
    impl SetRepositoryPolicy {
        /// Creates a new `SetRepositoryPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetRepositoryPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::SetRepositoryPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to receive the policy.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository to receive the policy.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The JSON repository policy text to apply to the repository. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR repository policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
        pub fn policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_text(input.into());
            self
        }
        /// <p>The JSON repository policy text to apply to the repository. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR repository policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
        pub fn set_policy_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_text(input);
            self
        }
        /// <p>If the policy you are attempting to set on a repository policy would prevent you from setting another policy in the future, you must force the <code>SetRepositoryPolicy</code> operation. This is intended to prevent accidental repository lock outs.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>If the policy you are attempting to set on a repository policy would prevent you from setting another policy in the future, you must force the <code>SetRepositoryPolicy</code> operation. This is intended to prevent accidental repository lock outs.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartImageScan`.
    ///
    /// <p>Starts an image vulnerability scan. An image scan can only be started once per 24 hours on an individual image. This limit includes if an image was scanned on initial push. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html">Image scanning</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartImageScan {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_image_scan_input::Builder,
    }
    impl StartImageScan {
        /// Creates a new `StartImageScan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartImageScanOutput,
            aws_smithy_http::result::SdkError<crate::error::StartImageScanError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to start an image scan request. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in which to start an image scan request. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository that contains the images to scan.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository that contains the images to scan.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn image_id(mut self, input: crate::model::ImageIdentifier) -> Self {
            self.inner = self.inner.image_id(input);
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn set_image_id(
            mut self,
            input: std::option::Option<crate::model::ImageIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartLifecyclePolicyPreview`.
    ///
    /// <p>Starts a preview of a lifecycle policy for the specified repository. This allows you to see the results before associating the lifecycle policy with the repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartLifecyclePolicyPreview {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_lifecycle_policy_preview_input::Builder,
    }
    impl StartLifecyclePolicyPreview {
        /// Creates a new `StartLifecyclePolicyPreview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartLifecyclePolicyPreviewOutput,
            aws_smithy_http::result::SdkError<crate::error::StartLifecyclePolicyPreviewError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to be evaluated.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository to be evaluated.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The policy to be evaluated against. If you do not specify a policy, the current policy for the repository is used.</p>
        pub fn lifecycle_policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lifecycle_policy_text(input.into());
            self
        }
        /// <p>The policy to be evaluated against. If you do not specify a policy, the current policy for the repository is used.</p>
        pub fn set_lifecycle_policy_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_lifecycle_policy_text(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds specified tags to a resource with the specified ARN. Existing tags on a resource are not changed if they are not specified in the request parameters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the the resource to which to add tags. Currently, the only supported resource is an Amazon ECR repository.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the the resource to which to add tags. Currently, the only supported resource is an Amazon ECR repository.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes specified tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which to remove tags. Currently, the only supported resource is an Amazon ECR repository.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which to remove tags. Currently, the only supported resource is an Amazon ECR repository.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UploadLayerPart`.
    ///
    /// <p>Uploads an image layer part to Amazon ECR.</p>
    /// <p>When an image is pushed, each new image layer is uploaded in parts. The maximum size of each image layer part can be 20971520 bytes (or about 20MB). The UploadLayerPart API is called once per each new image layer part.</p> <note>
    /// <p>This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UploadLayerPart {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::upload_layer_part_input::Builder,
    }
    impl UploadLayerPart {
        /// Creates a new `UploadLayerPart`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UploadLayerPartOutput,
            aws_smithy_http::result::SdkError<crate::error::UploadLayerPartError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry to which you are uploading layer parts. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry to which you are uploading layer parts. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to which you are uploading layer parts.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository to which you are uploading layer parts.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The upload ID from a previous <code>InitiateLayerUpload</code> operation to associate with the layer part upload.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.upload_id(input.into());
            self
        }
        /// <p>The upload ID from a previous <code>InitiateLayerUpload</code> operation to associate with the layer part upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_upload_id(input);
            self
        }
        /// <p>The position of the first byte of the layer part witin the overall image layer.</p>
        pub fn part_first_byte(mut self, input: i64) -> Self {
            self.inner = self.inner.part_first_byte(input);
            self
        }
        /// <p>The position of the first byte of the layer part witin the overall image layer.</p>
        pub fn set_part_first_byte(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_part_first_byte(input);
            self
        }
        /// <p>The position of the last byte of the layer part within the overall image layer.</p>
        pub fn part_last_byte(mut self, input: i64) -> Self {
            self.inner = self.inner.part_last_byte(input);
            self
        }
        /// <p>The position of the last byte of the layer part within the overall image layer.</p>
        pub fn set_part_last_byte(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_part_last_byte(input);
            self
        }
        /// <p>The base64-encoded layer part payload.</p>
        pub fn layer_part_blob(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.layer_part_blob(input);
            self
        }
        /// <p>The base64-encoded layer part payload.</p>
        pub fn set_layer_part_blob(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_layer_part_blob(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
