// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_check_layer_availability_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchCheckLayerAvailabilityOutput,
    crate::error::BatchCheckLayerAvailabilityError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchCheckLayerAvailabilityError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::BatchCheckLayerAvailabilityError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::BatchCheckLayerAvailabilityError {
            meta: generic,
            kind: crate::error::BatchCheckLayerAvailabilityErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchCheckLayerAvailabilityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::BatchCheckLayerAvailabilityError {
            meta: generic,
            kind: crate::error::BatchCheckLayerAvailabilityErrorKind::RepositoryNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::repository_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchCheckLayerAvailabilityError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ServerException" => {
            crate::error::BatchCheckLayerAvailabilityError {
                meta: generic,
                kind: crate::error::BatchCheckLayerAvailabilityErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchCheckLayerAvailabilityError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::BatchCheckLayerAvailabilityError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_check_layer_availability_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchCheckLayerAvailabilityOutput,
    crate::error::BatchCheckLayerAvailabilityError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_check_layer_availability_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_batch_check_layer_availability(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BatchCheckLayerAvailabilityError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_delete_image_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::BatchDeleteImageOutput, crate::error::BatchDeleteImageError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchDeleteImageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::BatchDeleteImageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::BatchDeleteImageError {
            meta: generic,
            kind: crate::error::BatchDeleteImageErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDeleteImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::BatchDeleteImageError {
            meta: generic,
            kind: crate::error::BatchDeleteImageErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDeleteImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::BatchDeleteImageError {
                meta: generic,
                kind: crate::error::BatchDeleteImageErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchDeleteImageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::BatchDeleteImageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_delete_image_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::BatchDeleteImageOutput, crate::error::BatchDeleteImageError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_delete_image_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_batch_delete_image(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BatchDeleteImageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_get_image_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::BatchGetImageOutput, crate::error::BatchGetImageError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchGetImageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::BatchGetImageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::BatchGetImageError {
            meta: generic,
            kind: crate::error::BatchGetImageErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchGetImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::BatchGetImageError {
            meta: generic,
            kind: crate::error::BatchGetImageErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchGetImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::BatchGetImageError {
                meta: generic,
                kind: crate::error::BatchGetImageErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchGetImageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::BatchGetImageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_get_image_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::BatchGetImageOutput, crate::error::BatchGetImageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_get_image_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_batch_get_image(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BatchGetImageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_get_repository_scanning_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchGetRepositoryScanningConfigurationOutput,
    crate::error::BatchGetRepositoryScanningConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchGetRepositoryScanningConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::BatchGetRepositoryScanningConfigurationError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::BatchGetRepositoryScanningConfigurationError { meta: generic, kind: crate::error::BatchGetRepositoryScanningConfigurationErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchGetRepositoryScanningConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "RepositoryNotFoundException" => crate::error::BatchGetRepositoryScanningConfigurationError { meta: generic, kind: crate::error::BatchGetRepositoryScanningConfigurationErrorKind::RepositoryNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchGetRepositoryScanningConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServerException" => crate::error::BatchGetRepositoryScanningConfigurationError { meta: generic, kind: crate::error::BatchGetRepositoryScanningConfigurationErrorKind::ServerException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchGetRepositoryScanningConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ValidationException" => crate::error::BatchGetRepositoryScanningConfigurationError { meta: generic, kind: crate::error::BatchGetRepositoryScanningConfigurationErrorKind::ValidationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::BatchGetRepositoryScanningConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::BatchGetRepositoryScanningConfigurationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_get_repository_scanning_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchGetRepositoryScanningConfigurationOutput,
    crate::error::BatchGetRepositoryScanningConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::batch_get_repository_scanning_configuration_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_batch_get_repository_scanning_configuration(response.body().as_ref(), output).map_err(crate::error::BatchGetRepositoryScanningConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_complete_layer_upload_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CompleteLayerUploadOutput,
    crate::error::CompleteLayerUploadError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CompleteLayerUploadError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CompleteLayerUploadError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EmptyUploadException" => crate::error::CompleteLayerUploadError {
            meta: generic,
            kind: crate::error::CompleteLayerUploadErrorKind::EmptyUploadException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::empty_upload_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_empty_upload_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteLayerUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidLayerException" => crate::error::CompleteLayerUploadError {
            meta: generic,
            kind: crate::error::CompleteLayerUploadErrorKind::InvalidLayerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_layer_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_layer_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteLayerUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::CompleteLayerUploadError {
            meta: generic,
            kind: crate::error::CompleteLayerUploadErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteLayerUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KmsException" => crate::error::CompleteLayerUploadError {
            meta: generic,
            kind: crate::error::CompleteLayerUploadErrorKind::KmsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_exception_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CompleteLayerUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LayerAlreadyExistsException" => crate::error::CompleteLayerUploadError {
            meta: generic,
            kind: crate::error::CompleteLayerUploadErrorKind::LayerAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::layer_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_layer_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteLayerUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LayerPartTooSmallException" => crate::error::CompleteLayerUploadError {
            meta: generic,
            kind: crate::error::CompleteLayerUploadErrorKind::LayerPartTooSmallException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::layer_part_too_small_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_layer_part_too_small_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteLayerUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::CompleteLayerUploadError {
            meta: generic,
            kind: crate::error::CompleteLayerUploadErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteLayerUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::CompleteLayerUploadError {
                meta: generic,
                kind: crate::error::CompleteLayerUploadErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteLayerUploadError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UploadNotFoundException" => crate::error::CompleteLayerUploadError {
            meta: generic,
            kind: crate::error::CompleteLayerUploadErrorKind::UploadNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::upload_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_upload_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteLayerUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CompleteLayerUploadError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_complete_layer_upload_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CompleteLayerUploadOutput,
    crate::error::CompleteLayerUploadError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::complete_layer_upload_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_complete_layer_upload(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CompleteLayerUploadError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_pull_through_cache_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePullThroughCacheRuleOutput,
    crate::error::CreatePullThroughCacheRuleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePullThroughCacheRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreatePullThroughCacheRuleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::CreatePullThroughCacheRuleError { meta: generic, kind: crate::error::CreatePullThroughCacheRuleErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePullThroughCacheRuleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LimitExceededException" => crate::error::CreatePullThroughCacheRuleError { meta: generic, kind: crate::error::CreatePullThroughCacheRuleErrorKind::LimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePullThroughCacheRuleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PullThroughCacheRuleAlreadyExistsException" => crate::error::CreatePullThroughCacheRuleError { meta: generic, kind: crate::error::CreatePullThroughCacheRuleErrorKind::PullThroughCacheRuleAlreadyExistsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::pull_through_cache_rule_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pull_through_cache_rule_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePullThroughCacheRuleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServerException" => crate::error::CreatePullThroughCacheRuleError { meta: generic, kind: crate::error::CreatePullThroughCacheRuleErrorKind::ServerException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePullThroughCacheRuleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedUpstreamRegistryException" => crate::error::CreatePullThroughCacheRuleError { meta: generic, kind: crate::error::CreatePullThroughCacheRuleErrorKind::UnsupportedUpstreamRegistryException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_upstream_registry_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_upstream_registry_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePullThroughCacheRuleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ValidationException" => crate::error::CreatePullThroughCacheRuleError { meta: generic, kind: crate::error::CreatePullThroughCacheRuleErrorKind::ValidationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreatePullThroughCacheRuleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreatePullThroughCacheRuleError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_pull_through_cache_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePullThroughCacheRuleOutput,
    crate::error::CreatePullThroughCacheRuleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_pull_through_cache_rule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_pull_through_cache_rule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePullThroughCacheRuleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_repository_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateRepositoryOutput, crate::error::CreateRepositoryError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateRepositoryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateRepositoryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::CreateRepositoryError {
            meta: generic,
            kind: crate::error::CreateRepositoryErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRepositoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagParameterException" => crate::error::CreateRepositoryError {
            meta: generic,
            kind: crate::error::CreateRepositoryErrorKind::InvalidTagParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_tag_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_tag_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRepositoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KmsException" => crate::error::CreateRepositoryError {
            meta: generic,
            kind: crate::error::CreateRepositoryErrorKind::KmsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_exception_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateRepositoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::CreateRepositoryError {
            meta: generic,
            kind: crate::error::CreateRepositoryErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRepositoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryAlreadyExistsException" => crate::error::CreateRepositoryError {
            meta: generic,
            kind: crate::error::CreateRepositoryErrorKind::RepositoryAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRepositoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::CreateRepositoryError {
                meta: generic,
                kind: crate::error::CreateRepositoryErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRepositoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyTagsException" => crate::error::CreateRepositoryError {
            meta: generic,
            kind: crate::error::CreateRepositoryErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRepositoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateRepositoryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_repository_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateRepositoryOutput, crate::error::CreateRepositoryError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_repository_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_repository(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateRepositoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_lifecycle_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLifecyclePolicyOutput,
    crate::error::DeleteLifecyclePolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteLifecyclePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteLifecyclePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::DeleteLifecyclePolicyError {
            meta: generic,
            kind: crate::error::DeleteLifecyclePolicyErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLifecyclePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LifecyclePolicyNotFoundException" => crate::error::DeleteLifecyclePolicyError {
            meta: generic,
            kind: crate::error::DeleteLifecyclePolicyErrorKind::LifecyclePolicyNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::lifecycle_policy_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_lifecycle_policy_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLifecyclePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::DeleteLifecyclePolicyError {
            meta: generic,
            kind: crate::error::DeleteLifecyclePolicyErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLifecyclePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DeleteLifecyclePolicyError {
                meta: generic,
                kind: crate::error::DeleteLifecyclePolicyErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLifecyclePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteLifecyclePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_lifecycle_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLifecyclePolicyOutput,
    crate::error::DeleteLifecyclePolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_lifecycle_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_lifecycle_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteLifecyclePolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_pull_through_cache_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeletePullThroughCacheRuleOutput,
    crate::error::DeletePullThroughCacheRuleError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePullThroughCacheRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeletePullThroughCacheRuleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::DeletePullThroughCacheRuleError { meta: generic, kind: crate::error::DeletePullThroughCacheRuleErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePullThroughCacheRuleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PullThroughCacheRuleNotFoundException" => crate::error::DeletePullThroughCacheRuleError { meta: generic, kind: crate::error::DeletePullThroughCacheRuleErrorKind::PullThroughCacheRuleNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::pull_through_cache_rule_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pull_through_cache_rule_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePullThroughCacheRuleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServerException" => crate::error::DeletePullThroughCacheRuleError { meta: generic, kind: crate::error::DeletePullThroughCacheRuleErrorKind::ServerException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePullThroughCacheRuleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ValidationException" => crate::error::DeletePullThroughCacheRuleError { meta: generic, kind: crate::error::DeletePullThroughCacheRuleErrorKind::ValidationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeletePullThroughCacheRuleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeletePullThroughCacheRuleError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_pull_through_cache_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeletePullThroughCacheRuleOutput,
    crate::error::DeletePullThroughCacheRuleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_pull_through_cache_rule_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_pull_through_cache_rule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeletePullThroughCacheRuleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_registry_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRegistryPolicyOutput,
    crate::error::DeleteRegistryPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRegistryPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteRegistryPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::DeleteRegistryPolicyError {
            meta: generic,
            kind: crate::error::DeleteRegistryPolicyErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegistryPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RegistryPolicyNotFoundException" => crate::error::DeleteRegistryPolicyError {
            meta: generic,
            kind: crate::error::DeleteRegistryPolicyErrorKind::RegistryPolicyNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::registry_policy_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_registry_policy_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegistryPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DeleteRegistryPolicyError {
                meta: generic,
                kind: crate::error::DeleteRegistryPolicyErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegistryPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ValidationException" => crate::error::DeleteRegistryPolicyError {
            meta: generic,
            kind: crate::error::DeleteRegistryPolicyErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRegistryPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteRegistryPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_registry_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRegistryPolicyOutput,
    crate::error::DeleteRegistryPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_registry_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_registry_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteRegistryPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_repository_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteRepositoryOutput, crate::error::DeleteRepositoryError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRepositoryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteRepositoryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::DeleteRepositoryError {
            meta: generic,
            kind: crate::error::DeleteRepositoryErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRepositoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KmsException" => crate::error::DeleteRepositoryError {
            meta: generic,
            kind: crate::error::DeleteRepositoryErrorKind::KmsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_exception_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::DeleteRepositoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotEmptyException" => crate::error::DeleteRepositoryError {
            meta: generic,
            kind: crate::error::DeleteRepositoryErrorKind::RepositoryNotEmptyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_empty_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_empty_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRepositoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::DeleteRepositoryError {
            meta: generic,
            kind: crate::error::DeleteRepositoryErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRepositoryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DeleteRepositoryError {
                meta: generic,
                kind: crate::error::DeleteRepositoryErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRepositoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteRepositoryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_repository_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteRepositoryOutput, crate::error::DeleteRepositoryError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_repository_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_repository(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteRepositoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_repository_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRepositoryPolicyOutput,
    crate::error::DeleteRepositoryPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRepositoryPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteRepositoryPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::DeleteRepositoryPolicyError {
            meta: generic,
            kind: crate::error::DeleteRepositoryPolicyErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRepositoryPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::DeleteRepositoryPolicyError {
            meta: generic,
            kind: crate::error::DeleteRepositoryPolicyErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRepositoryPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryPolicyNotFoundException" => crate::error::DeleteRepositoryPolicyError {
            meta: generic,
            kind: crate::error::DeleteRepositoryPolicyErrorKind::RepositoryPolicyNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::repository_policy_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_repository_policy_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRepositoryPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ServerException" => {
            crate::error::DeleteRepositoryPolicyError {
                meta: generic,
                kind: crate::error::DeleteRepositoryPolicyErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRepositoryPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteRepositoryPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_repository_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRepositoryPolicyOutput,
    crate::error::DeleteRepositoryPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_repository_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_repository_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteRepositoryPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_image_replication_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeImageReplicationStatusOutput,
    crate::error::DescribeImageReplicationStatusError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeImageReplicationStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeImageReplicationStatusError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ImageNotFoundException" => crate::error::DescribeImageReplicationStatusError {
            meta: generic,
            kind: crate::error::DescribeImageReplicationStatusErrorKind::ImageNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::image_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_image_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImageReplicationStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeImageReplicationStatusError {
            meta: generic,
            kind: crate::error::DescribeImageReplicationStatusErrorKind::InvalidParameterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImageReplicationStatusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "RepositoryNotFoundException" => crate::error::DescribeImageReplicationStatusError {
            meta: generic,
            kind:
                crate::error::DescribeImageReplicationStatusErrorKind::RepositoryNotFoundException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::repository_not_found_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImageReplicationStatusError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ServerException" => {
            crate::error::DescribeImageReplicationStatusError {
                meta: generic,
                kind: crate::error::DescribeImageReplicationStatusErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImageReplicationStatusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ValidationException" => crate::error::DescribeImageReplicationStatusError {
            meta: generic,
            kind: crate::error::DescribeImageReplicationStatusErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImageReplicationStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeImageReplicationStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_image_replication_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeImageReplicationStatusOutput,
    crate::error::DescribeImageReplicationStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_image_replication_status_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_image_replication_status(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeImageReplicationStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_images_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeImagesOutput, crate::error::DescribeImagesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeImagesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeImagesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ImageNotFoundException" => crate::error::DescribeImagesError {
            meta: generic,
            kind: crate::error::DescribeImagesErrorKind::ImageNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::image_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_image_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeImagesError {
            meta: generic,
            kind: crate::error::DescribeImagesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::DescribeImagesError {
            meta: generic,
            kind: crate::error::DescribeImagesErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DescribeImagesError {
                meta: generic,
                kind: crate::error::DescribeImagesErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImagesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeImagesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_images_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeImagesOutput, crate::error::DescribeImagesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_images_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_images(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeImagesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_image_scan_findings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeImageScanFindingsOutput,
    crate::error::DescribeImageScanFindingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeImageScanFindingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeImageScanFindingsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ImageNotFoundException" => crate::error::DescribeImageScanFindingsError {
            meta: generic,
            kind: crate::error::DescribeImageScanFindingsErrorKind::ImageNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::image_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_image_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImageScanFindingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::DescribeImageScanFindingsError {
            meta: generic,
            kind: crate::error::DescribeImageScanFindingsErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImageScanFindingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::DescribeImageScanFindingsError {
            meta: generic,
            kind: crate::error::DescribeImageScanFindingsErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImageScanFindingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ScanNotFoundException" => crate::error::DescribeImageScanFindingsError {
            meta: generic,
            kind: crate::error::DescribeImageScanFindingsErrorKind::ScanNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::scan_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_scan_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImageScanFindingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DescribeImageScanFindingsError {
                meta: generic,
                kind: crate::error::DescribeImageScanFindingsErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImageScanFindingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ValidationException" => crate::error::DescribeImageScanFindingsError {
            meta: generic,
            kind: crate::error::DescribeImageScanFindingsErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeImageScanFindingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeImageScanFindingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_image_scan_findings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeImageScanFindingsOutput,
    crate::error::DescribeImageScanFindingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_image_scan_findings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_image_scan_findings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeImageScanFindingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_pull_through_cache_rules_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribePullThroughCacheRulesOutput,
    crate::error::DescribePullThroughCacheRulesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribePullThroughCacheRulesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribePullThroughCacheRulesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::DescribePullThroughCacheRulesError { meta: generic, kind: crate::error::DescribePullThroughCacheRulesErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePullThroughCacheRulesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PullThroughCacheRuleNotFoundException" => crate::error::DescribePullThroughCacheRulesError { meta: generic, kind: crate::error::DescribePullThroughCacheRulesErrorKind::PullThroughCacheRuleNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::pull_through_cache_rule_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_pull_through_cache_rule_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePullThroughCacheRulesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServerException" => crate::error::DescribePullThroughCacheRulesError { meta: generic, kind: crate::error::DescribePullThroughCacheRulesErrorKind::ServerException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePullThroughCacheRulesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ValidationException" => crate::error::DescribePullThroughCacheRulesError { meta: generic, kind: crate::error::DescribePullThroughCacheRulesErrorKind::ValidationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribePullThroughCacheRulesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribePullThroughCacheRulesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_pull_through_cache_rules_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribePullThroughCacheRulesOutput,
    crate::error::DescribePullThroughCacheRulesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_pull_through_cache_rules_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_pull_through_cache_rules(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribePullThroughCacheRulesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_registry_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeRegistryOutput, crate::error::DescribeRegistryError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeRegistryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeRegistryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::DescribeRegistryError {
            meta: generic,
            kind: crate::error::DescribeRegistryErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRegistryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DescribeRegistryError {
                meta: generic,
                kind: crate::error::DescribeRegistryErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRegistryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ValidationException" => crate::error::DescribeRegistryError {
            meta: generic,
            kind: crate::error::DescribeRegistryErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRegistryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeRegistryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_registry_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeRegistryOutput, crate::error::DescribeRegistryError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_registry_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_registry(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeRegistryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_repositories_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeRepositoriesOutput,
    crate::error::DescribeRepositoriesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeRepositoriesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeRepositoriesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::DescribeRepositoriesError {
            meta: generic,
            kind: crate::error::DescribeRepositoriesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRepositoriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::DescribeRepositoriesError {
            meta: generic,
            kind: crate::error::DescribeRepositoriesErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRepositoriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::DescribeRepositoriesError {
                meta: generic,
                kind: crate::error::DescribeRepositoriesErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeRepositoriesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeRepositoriesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_repositories_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeRepositoriesOutput,
    crate::error::DescribeRepositoriesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_repositories_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_repositories(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeRepositoriesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_authorization_token_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAuthorizationTokenOutput,
    crate::error::GetAuthorizationTokenError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAuthorizationTokenError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAuthorizationTokenError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::GetAuthorizationTokenError {
            meta: generic,
            kind: crate::error::GetAuthorizationTokenErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAuthorizationTokenError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::GetAuthorizationTokenError {
                meta: generic,
                kind: crate::error::GetAuthorizationTokenErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAuthorizationTokenError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetAuthorizationTokenError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_authorization_token_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAuthorizationTokenOutput,
    crate::error::GetAuthorizationTokenError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_authorization_token_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_authorization_token(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAuthorizationTokenError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_download_url_for_layer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDownloadUrlForLayerOutput,
    crate::error::GetDownloadUrlForLayerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDownloadUrlForLayerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetDownloadUrlForLayerError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::GetDownloadUrlForLayerError {
            meta: generic,
            kind: crate::error::GetDownloadUrlForLayerErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDownloadUrlForLayerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LayerInaccessibleException" => crate::error::GetDownloadUrlForLayerError {
            meta: generic,
            kind: crate::error::GetDownloadUrlForLayerErrorKind::LayerInaccessibleException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::layer_inaccessible_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_layer_inaccessible_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDownloadUrlForLayerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LayersNotFoundException" => crate::error::GetDownloadUrlForLayerError {
            meta: generic,
            kind: crate::error::GetDownloadUrlForLayerErrorKind::LayersNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::layers_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_layers_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDownloadUrlForLayerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::GetDownloadUrlForLayerError {
            meta: generic,
            kind: crate::error::GetDownloadUrlForLayerErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDownloadUrlForLayerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::GetDownloadUrlForLayerError {
                meta: generic,
                kind: crate::error::GetDownloadUrlForLayerErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDownloadUrlForLayerError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetDownloadUrlForLayerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_download_url_for_layer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDownloadUrlForLayerOutput,
    crate::error::GetDownloadUrlForLayerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_download_url_for_layer_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_download_url_for_layer(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDownloadUrlForLayerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_lifecycle_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetLifecyclePolicyOutput,
    crate::error::GetLifecyclePolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetLifecyclePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetLifecyclePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::GetLifecyclePolicyError {
            meta: generic,
            kind: crate::error::GetLifecyclePolicyErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLifecyclePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LifecyclePolicyNotFoundException" => crate::error::GetLifecyclePolicyError {
            meta: generic,
            kind: crate::error::GetLifecyclePolicyErrorKind::LifecyclePolicyNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::lifecycle_policy_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_lifecycle_policy_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLifecyclePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::GetLifecyclePolicyError {
            meta: generic,
            kind: crate::error::GetLifecyclePolicyErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLifecyclePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::GetLifecyclePolicyError {
                meta: generic,
                kind: crate::error::GetLifecyclePolicyErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLifecyclePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetLifecyclePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_lifecycle_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetLifecyclePolicyOutput,
    crate::error::GetLifecyclePolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_lifecycle_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_lifecycle_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetLifecyclePolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_lifecycle_policy_preview_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetLifecyclePolicyPreviewOutput,
    crate::error::GetLifecyclePolicyPreviewError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetLifecyclePolicyPreviewError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetLifecyclePolicyPreviewError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::GetLifecyclePolicyPreviewError { meta: generic, kind: crate::error::GetLifecyclePolicyPreviewErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLifecyclePolicyPreviewError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LifecyclePolicyPreviewNotFoundException" => crate::error::GetLifecyclePolicyPreviewError { meta: generic, kind: crate::error::GetLifecyclePolicyPreviewErrorKind::LifecyclePolicyPreviewNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::lifecycle_policy_preview_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_lifecycle_policy_preview_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLifecyclePolicyPreviewError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "RepositoryNotFoundException" => crate::error::GetLifecyclePolicyPreviewError { meta: generic, kind: crate::error::GetLifecyclePolicyPreviewErrorKind::RepositoryNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLifecyclePolicyPreviewError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServerException" => crate::error::GetLifecyclePolicyPreviewError { meta: generic, kind: crate::error::GetLifecyclePolicyPreviewErrorKind::ServerException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLifecyclePolicyPreviewError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetLifecyclePolicyPreviewError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_lifecycle_policy_preview_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetLifecyclePolicyPreviewOutput,
    crate::error::GetLifecyclePolicyPreviewError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_lifecycle_policy_preview_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_lifecycle_policy_preview(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetLifecyclePolicyPreviewError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_registry_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRegistryPolicyOutput, crate::error::GetRegistryPolicyError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRegistryPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRegistryPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::GetRegistryPolicyError {
            meta: generic,
            kind: crate::error::GetRegistryPolicyErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegistryPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RegistryPolicyNotFoundException" => crate::error::GetRegistryPolicyError {
            meta: generic,
            kind: crate::error::GetRegistryPolicyErrorKind::RegistryPolicyNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::registry_policy_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_registry_policy_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegistryPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::GetRegistryPolicyError {
                meta: generic,
                kind: crate::error::GetRegistryPolicyErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegistryPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ValidationException" => crate::error::GetRegistryPolicyError {
            meta: generic,
            kind: crate::error::GetRegistryPolicyErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegistryPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRegistryPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_registry_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRegistryPolicyOutput, crate::error::GetRegistryPolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_registry_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_registry_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRegistryPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_registry_scanning_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRegistryScanningConfigurationOutput,
    crate::error::GetRegistryScanningConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRegistryScanningConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetRegistryScanningConfigurationError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::GetRegistryScanningConfigurationError {
            meta: generic,
            kind:
                crate::error::GetRegistryScanningConfigurationErrorKind::InvalidParameterException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegistryScanningConfigurationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ServerException" => {
            crate::error::GetRegistryScanningConfigurationError {
                meta: generic,
                kind: crate::error::GetRegistryScanningConfigurationErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegistryScanningConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ValidationException" => crate::error::GetRegistryScanningConfigurationError {
            meta: generic,
            kind: crate::error::GetRegistryScanningConfigurationErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegistryScanningConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRegistryScanningConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_registry_scanning_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRegistryScanningConfigurationOutput,
    crate::error::GetRegistryScanningConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_registry_scanning_configuration_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_registry_scanning_configuration(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetRegistryScanningConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_repository_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRepositoryPolicyOutput,
    crate::error::GetRepositoryPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRepositoryPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRepositoryPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::GetRepositoryPolicyError {
            meta: generic,
            kind: crate::error::GetRepositoryPolicyErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRepositoryPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::GetRepositoryPolicyError {
            meta: generic,
            kind: crate::error::GetRepositoryPolicyErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRepositoryPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryPolicyNotFoundException" => crate::error::GetRepositoryPolicyError {
            meta: generic,
            kind: crate::error::GetRepositoryPolicyErrorKind::RepositoryPolicyNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_policy_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_policy_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRepositoryPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::GetRepositoryPolicyError {
                meta: generic,
                kind: crate::error::GetRepositoryPolicyErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRepositoryPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetRepositoryPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_repository_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRepositoryPolicyOutput,
    crate::error::GetRepositoryPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_repository_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_repository_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRepositoryPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_initiate_layer_upload_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::InitiateLayerUploadOutput,
    crate::error::InitiateLayerUploadError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::InitiateLayerUploadError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::InitiateLayerUploadError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::InitiateLayerUploadError {
            meta: generic,
            kind: crate::error::InitiateLayerUploadErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateLayerUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KmsException" => crate::error::InitiateLayerUploadError {
            meta: generic,
            kind: crate::error::InitiateLayerUploadErrorKind::KmsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_exception_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::InitiateLayerUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::InitiateLayerUploadError {
            meta: generic,
            kind: crate::error::InitiateLayerUploadErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateLayerUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::InitiateLayerUploadError {
                meta: generic,
                kind: crate::error::InitiateLayerUploadErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InitiateLayerUploadError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::InitiateLayerUploadError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_initiate_layer_upload_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::InitiateLayerUploadOutput,
    crate::error::InitiateLayerUploadError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::initiate_layer_upload_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_initiate_layer_upload(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::InitiateLayerUploadError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_images_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListImagesOutput, crate::error::ListImagesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListImagesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListImagesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::ListImagesError {
            meta: generic,
            kind: crate::error::ListImagesErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListImagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::ListImagesError {
            meta: generic,
            kind: crate::error::ListImagesErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListImagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::ListImagesError {
                meta: generic,
                kind: crate::error::ListImagesErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListImagesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListImagesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_images_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListImagesOutput, crate::error::ListImagesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_images_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_images(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListImagesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::ListTagsForResourceError {
                meta: generic,
                kind: crate::error::ListTagsForResourceErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_image_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutImageOutput, crate::error::PutImageError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutImageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutImageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ImageAlreadyExistsException" => crate::error::PutImageError {
            meta: generic,
            kind: crate::error::PutImageErrorKind::ImageAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::image_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_image_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ImageDigestDoesNotMatchException" => crate::error::PutImageError {
            meta: generic,
            kind: crate::error::PutImageErrorKind::ImageDigestDoesNotMatchException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::image_digest_does_not_match_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_image_digest_does_not_match_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ImageTagAlreadyExistsException" => crate::error::PutImageError {
            meta: generic,
            kind: crate::error::PutImageErrorKind::ImageTagAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::image_tag_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_image_tag_already_exists_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::PutImageError {
            meta: generic,
            kind: crate::error::PutImageErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KmsException" => crate::error::PutImageError {
            meta: generic,
            kind: crate::error::PutImageErrorKind::KmsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_exception_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::PutImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LayersNotFoundException" => crate::error::PutImageError {
            meta: generic,
            kind: crate::error::PutImageErrorKind::LayersNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::layers_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_layers_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::PutImageError {
            meta: generic,
            kind: crate::error::PutImageErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReferencedImagesNotFoundException" => crate::error::PutImageError {
            meta: generic,
            kind: crate::error::PutImageErrorKind::ReferencedImagesNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::referenced_images_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_referenced_images_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::PutImageError {
            meta: generic,
            kind: crate::error::PutImageErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::PutImageError {
                meta: generic,
                kind: crate::error::PutImageErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutImageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::PutImageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_image_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutImageOutput, crate::error::PutImageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_image_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_image(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutImageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_image_scanning_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutImageScanningConfigurationOutput,
    crate::error::PutImageScanningConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutImageScanningConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutImageScanningConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::PutImageScanningConfigurationError {
            meta: generic,
            kind: crate::error::PutImageScanningConfigurationErrorKind::InvalidParameterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutImageScanningConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "RepositoryNotFoundException" => crate::error::PutImageScanningConfigurationError {
            meta: generic,
            kind: crate::error::PutImageScanningConfigurationErrorKind::RepositoryNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::repository_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutImageScanningConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ServerException" => {
            crate::error::PutImageScanningConfigurationError {
                meta: generic,
                kind: crate::error::PutImageScanningConfigurationErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutImageScanningConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ValidationException" => crate::error::PutImageScanningConfigurationError {
            meta: generic,
            kind: crate::error::PutImageScanningConfigurationErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutImageScanningConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutImageScanningConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_image_scanning_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutImageScanningConfigurationOutput,
    crate::error::PutImageScanningConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_image_scanning_configuration_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_put_image_scanning_configuration(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::PutImageScanningConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_image_tag_mutability_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutImageTagMutabilityOutput,
    crate::error::PutImageTagMutabilityError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutImageTagMutabilityError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutImageTagMutabilityError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::PutImageTagMutabilityError {
            meta: generic,
            kind: crate::error::PutImageTagMutabilityErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutImageTagMutabilityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::PutImageTagMutabilityError {
            meta: generic,
            kind: crate::error::PutImageTagMutabilityErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutImageTagMutabilityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::PutImageTagMutabilityError {
                meta: generic,
                kind: crate::error::PutImageTagMutabilityErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutImageTagMutabilityError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::PutImageTagMutabilityError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_image_tag_mutability_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutImageTagMutabilityOutput,
    crate::error::PutImageTagMutabilityError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_image_tag_mutability_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_image_tag_mutability(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutImageTagMutabilityError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_lifecycle_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutLifecyclePolicyOutput,
    crate::error::PutLifecyclePolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutLifecyclePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutLifecyclePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::PutLifecyclePolicyError {
            meta: generic,
            kind: crate::error::PutLifecyclePolicyErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLifecyclePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::PutLifecyclePolicyError {
            meta: generic,
            kind: crate::error::PutLifecyclePolicyErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLifecyclePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::PutLifecyclePolicyError {
                meta: generic,
                kind: crate::error::PutLifecyclePolicyErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutLifecyclePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::PutLifecyclePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_lifecycle_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutLifecyclePolicyOutput,
    crate::error::PutLifecyclePolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_lifecycle_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_lifecycle_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutLifecyclePolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_registry_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutRegistryPolicyOutput, crate::error::PutRegistryPolicyError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutRegistryPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutRegistryPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::PutRegistryPolicyError {
            meta: generic,
            kind: crate::error::PutRegistryPolicyErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutRegistryPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::PutRegistryPolicyError {
                meta: generic,
                kind: crate::error::PutRegistryPolicyErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutRegistryPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ValidationException" => crate::error::PutRegistryPolicyError {
            meta: generic,
            kind: crate::error::PutRegistryPolicyErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutRegistryPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutRegistryPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_registry_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutRegistryPolicyOutput, crate::error::PutRegistryPolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_registry_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_registry_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutRegistryPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_registry_scanning_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutRegistryScanningConfigurationOutput,
    crate::error::PutRegistryScanningConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutRegistryScanningConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutRegistryScanningConfigurationError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::PutRegistryScanningConfigurationError {
            meta: generic,
            kind:
                crate::error::PutRegistryScanningConfigurationErrorKind::InvalidParameterException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutRegistryScanningConfigurationError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ServerException" => {
            crate::error::PutRegistryScanningConfigurationError {
                meta: generic,
                kind: crate::error::PutRegistryScanningConfigurationErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutRegistryScanningConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ValidationException" => crate::error::PutRegistryScanningConfigurationError {
            meta: generic,
            kind: crate::error::PutRegistryScanningConfigurationErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutRegistryScanningConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutRegistryScanningConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_registry_scanning_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutRegistryScanningConfigurationOutput,
    crate::error::PutRegistryScanningConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::put_registry_scanning_configuration_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_put_registry_scanning_configuration(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::PutRegistryScanningConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_replication_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutReplicationConfigurationOutput,
    crate::error::PutReplicationConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutReplicationConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutReplicationConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::PutReplicationConfigurationError {
            meta: generic,
            kind: crate::error::PutReplicationConfigurationErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutReplicationConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::PutReplicationConfigurationError {
                meta: generic,
                kind: crate::error::PutReplicationConfigurationErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutReplicationConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ValidationException" => crate::error::PutReplicationConfigurationError {
            meta: generic,
            kind: crate::error::PutReplicationConfigurationErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutReplicationConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutReplicationConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_replication_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutReplicationConfigurationOutput,
    crate::error::PutReplicationConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_replication_configuration_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_replication_configuration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutReplicationConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_repository_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetRepositoryPolicyOutput,
    crate::error::SetRepositoryPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetRepositoryPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetRepositoryPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::SetRepositoryPolicyError {
            meta: generic,
            kind: crate::error::SetRepositoryPolicyErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetRepositoryPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::SetRepositoryPolicyError {
            meta: generic,
            kind: crate::error::SetRepositoryPolicyErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetRepositoryPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::SetRepositoryPolicyError {
                meta: generic,
                kind: crate::error::SetRepositoryPolicyErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetRepositoryPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::SetRepositoryPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_repository_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetRepositoryPolicyOutput,
    crate::error::SetRepositoryPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_repository_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_set_repository_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SetRepositoryPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_image_scan_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartImageScanOutput, crate::error::StartImageScanError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartImageScanError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartImageScanError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ImageNotFoundException" => crate::error::StartImageScanError {
            meta: generic,
            kind: crate::error::StartImageScanErrorKind::ImageNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::image_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_image_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartImageScanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::StartImageScanError {
            meta: generic,
            kind: crate::error::StartImageScanErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartImageScanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::StartImageScanError {
            meta: generic,
            kind: crate::error::StartImageScanErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartImageScanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::StartImageScanError {
            meta: generic,
            kind: crate::error::StartImageScanErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartImageScanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::StartImageScanError {
                meta: generic,
                kind: crate::error::StartImageScanErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartImageScanError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnsupportedImageTypeException" => crate::error::StartImageScanError {
            meta: generic,
            kind: crate::error::StartImageScanErrorKind::UnsupportedImageTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_image_type_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_image_type_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartImageScanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::StartImageScanError {
            meta: generic,
            kind: crate::error::StartImageScanErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartImageScanError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartImageScanError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_image_scan_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartImageScanOutput, crate::error::StartImageScanError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_image_scan_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_image_scan(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartImageScanError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_lifecycle_policy_preview_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartLifecyclePolicyPreviewOutput,
    crate::error::StartLifecyclePolicyPreviewError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartLifecyclePolicyPreviewError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartLifecyclePolicyPreviewError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::StartLifecyclePolicyPreviewError { meta: generic, kind: crate::error::StartLifecyclePolicyPreviewErrorKind::InvalidParameterException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartLifecyclePolicyPreviewError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LifecyclePolicyNotFoundException" => crate::error::StartLifecyclePolicyPreviewError { meta: generic, kind: crate::error::StartLifecyclePolicyPreviewErrorKind::LifecyclePolicyNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::lifecycle_policy_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_lifecycle_policy_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartLifecyclePolicyPreviewError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LifecyclePolicyPreviewInProgressException" => crate::error::StartLifecyclePolicyPreviewError { meta: generic, kind: crate::error::StartLifecyclePolicyPreviewErrorKind::LifecyclePolicyPreviewInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::lifecycle_policy_preview_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_lifecycle_policy_preview_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartLifecyclePolicyPreviewError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "RepositoryNotFoundException" => crate::error::StartLifecyclePolicyPreviewError { meta: generic, kind: crate::error::StartLifecyclePolicyPreviewErrorKind::RepositoryNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartLifecyclePolicyPreviewError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServerException" => crate::error::StartLifecyclePolicyPreviewError { meta: generic, kind: crate::error::StartLifecyclePolicyPreviewErrorKind::ServerException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartLifecyclePolicyPreviewError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::StartLifecyclePolicyPreviewError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_lifecycle_policy_preview_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartLifecyclePolicyPreviewOutput,
    crate::error::StartLifecyclePolicyPreviewError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_lifecycle_policy_preview_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_lifecycle_policy_preview(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartLifecyclePolicyPreviewError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagParameterException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidTagParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_tag_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_tag_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::TagResourceError {
                meta: generic,
                kind: crate::error::TagResourceErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyTagsException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagParameterException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidTagParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_tag_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_tag_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::UntagResourceError {
                meta: generic,
                kind: crate::error::UntagResourceErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyTagsException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upload_layer_part_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UploadLayerPartOutput, crate::error::UploadLayerPartError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UploadLayerPartError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UploadLayerPartError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidLayerPartException" => crate::error::UploadLayerPartError {
            meta: generic,
            kind: crate::error::UploadLayerPartErrorKind::InvalidLayerPartException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_layer_part_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_layer_part_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UploadLayerPartError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterException" => crate::error::UploadLayerPartError {
            meta: generic,
            kind: crate::error::UploadLayerPartErrorKind::InvalidParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UploadLayerPartError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KmsException" => crate::error::UploadLayerPartError {
            meta: generic,
            kind: crate::error::UploadLayerPartErrorKind::KmsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_exception_json_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::UploadLayerPartError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::UploadLayerPartError {
            meta: generic,
            kind: crate::error::UploadLayerPartErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UploadLayerPartError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RepositoryNotFoundException" => crate::error::UploadLayerPartError {
            meta: generic,
            kind: crate::error::UploadLayerPartErrorKind::RepositoryNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::repository_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_repository_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UploadLayerPartError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServerException" => {
            crate::error::UploadLayerPartError {
                meta: generic,
                kind: crate::error::UploadLayerPartErrorKind::ServerException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::server_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UploadLayerPartError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UploadNotFoundException" => crate::error::UploadLayerPartError {
            meta: generic,
            kind: crate::error::UploadLayerPartErrorKind::UploadNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::upload_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_upload_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UploadLayerPartError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UploadLayerPartError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upload_layer_part_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UploadLayerPartOutput, crate::error::UploadLayerPartError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::upload_layer_part_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_upload_layer_part(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UploadLayerPartError::unhandled)?;
        output.build()
    })
}
