// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadLayerPartOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The upload ID associated with the request.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>The integer value of the last byte received in the request.</p>
    pub last_byte_received: std::option::Option<i64>,
}
impl UploadLayerPartOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The upload ID associated with the request.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>The integer value of the last byte received in the request.</p>
    pub fn last_byte_received(&self) -> std::option::Option<i64> {
        self.last_byte_received
    }
}
impl std::fmt::Debug for UploadLayerPartOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadLayerPartOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("upload_id", &self.upload_id);
        formatter.field("last_byte_received", &self.last_byte_received);
        formatter.finish()
    }
}
/// See [`UploadLayerPartOutput`](crate::output::UploadLayerPartOutput)
pub mod upload_layer_part_output {
    /// A builder for [`UploadLayerPartOutput`](crate::output::UploadLayerPartOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) last_byte_received: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The upload ID associated with the request.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The upload ID associated with the request.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>The integer value of the last byte received in the request.</p>
        pub fn last_byte_received(mut self, input: i64) -> Self {
            self.last_byte_received = Some(input);
            self
        }
        /// <p>The integer value of the last byte received in the request.</p>
        pub fn set_last_byte_received(mut self, input: std::option::Option<i64>) -> Self {
            self.last_byte_received = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadLayerPartOutput`](crate::output::UploadLayerPartOutput)
        pub fn build(self) -> crate::output::UploadLayerPartOutput {
            crate::output::UploadLayerPartOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                upload_id: self.upload_id,
                last_byte_received: self.last_byte_received,
            }
        }
    }
}
impl UploadLayerPartOutput {
    /// Creates a new builder-style object to manufacture [`UploadLayerPartOutput`](crate::output::UploadLayerPartOutput)
    pub fn builder() -> crate::output::upload_layer_part_output::Builder {
        crate::output::upload_layer_part_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartLifecyclePolicyPreviewOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The JSON repository policy text.</p>
    pub lifecycle_policy_text: std::option::Option<std::string::String>,
    /// <p>The status of the lifecycle policy preview request.</p>
    pub status: std::option::Option<crate::model::LifecyclePolicyPreviewStatus>,
}
impl StartLifecyclePolicyPreviewOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The JSON repository policy text.</p>
    pub fn lifecycle_policy_text(&self) -> std::option::Option<&str> {
        self.lifecycle_policy_text.as_deref()
    }
    /// <p>The status of the lifecycle policy preview request.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::LifecyclePolicyPreviewStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for StartLifecyclePolicyPreviewOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartLifecyclePolicyPreviewOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("lifecycle_policy_text", &self.lifecycle_policy_text);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`StartLifecyclePolicyPreviewOutput`](crate::output::StartLifecyclePolicyPreviewOutput)
pub mod start_lifecycle_policy_preview_output {
    /// A builder for [`StartLifecyclePolicyPreviewOutput`](crate::output::StartLifecyclePolicyPreviewOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) lifecycle_policy_text: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::LifecyclePolicyPreviewStatus>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The JSON repository policy text.</p>
        pub fn lifecycle_policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_policy_text = Some(input.into());
            self
        }
        /// <p>The JSON repository policy text.</p>
        pub fn set_lifecycle_policy_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_policy_text = input;
            self
        }
        /// <p>The status of the lifecycle policy preview request.</p>
        pub fn status(mut self, input: crate::model::LifecyclePolicyPreviewStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the lifecycle policy preview request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LifecyclePolicyPreviewStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`StartLifecyclePolicyPreviewOutput`](crate::output::StartLifecyclePolicyPreviewOutput)
        pub fn build(self) -> crate::output::StartLifecyclePolicyPreviewOutput {
            crate::output::StartLifecyclePolicyPreviewOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                lifecycle_policy_text: self.lifecycle_policy_text,
                status: self.status,
            }
        }
    }
}
impl StartLifecyclePolicyPreviewOutput {
    /// Creates a new builder-style object to manufacture [`StartLifecyclePolicyPreviewOutput`](crate::output::StartLifecyclePolicyPreviewOutput)
    pub fn builder() -> crate::output::start_lifecycle_policy_preview_output::Builder {
        crate::output::start_lifecycle_policy_preview_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartImageScanOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
    pub image_id: std::option::Option<crate::model::ImageIdentifier>,
    /// <p>The current state of the scan.</p>
    pub image_scan_status: std::option::Option<crate::model::ImageScanStatus>,
}
impl StartImageScanOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
    pub fn image_id(&self) -> std::option::Option<&crate::model::ImageIdentifier> {
        self.image_id.as_ref()
    }
    /// <p>The current state of the scan.</p>
    pub fn image_scan_status(&self) -> std::option::Option<&crate::model::ImageScanStatus> {
        self.image_scan_status.as_ref()
    }
}
impl std::fmt::Debug for StartImageScanOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartImageScanOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_id", &self.image_id);
        formatter.field("image_scan_status", &self.image_scan_status);
        formatter.finish()
    }
}
/// See [`StartImageScanOutput`](crate::output::StartImageScanOutput)
pub mod start_image_scan_output {
    /// A builder for [`StartImageScanOutput`](crate::output::StartImageScanOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_id: std::option::Option<crate::model::ImageIdentifier>,
        pub(crate) image_scan_status: std::option::Option<crate::model::ImageScanStatus>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn image_id(mut self, input: crate::model::ImageIdentifier) -> Self {
            self.image_id = Some(input);
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn set_image_id(
            mut self,
            input: std::option::Option<crate::model::ImageIdentifier>,
        ) -> Self {
            self.image_id = input;
            self
        }
        /// <p>The current state of the scan.</p>
        pub fn image_scan_status(mut self, input: crate::model::ImageScanStatus) -> Self {
            self.image_scan_status = Some(input);
            self
        }
        /// <p>The current state of the scan.</p>
        pub fn set_image_scan_status(
            mut self,
            input: std::option::Option<crate::model::ImageScanStatus>,
        ) -> Self {
            self.image_scan_status = input;
            self
        }
        /// Consumes the builder and constructs a [`StartImageScanOutput`](crate::output::StartImageScanOutput)
        pub fn build(self) -> crate::output::StartImageScanOutput {
            crate::output::StartImageScanOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                image_id: self.image_id,
                image_scan_status: self.image_scan_status,
            }
        }
    }
}
impl StartImageScanOutput {
    /// Creates a new builder-style object to manufacture [`StartImageScanOutput`](crate::output::StartImageScanOutput)
    pub fn builder() -> crate::output::start_image_scan_output::Builder {
        crate::output::start_image_scan_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetRepositoryPolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The JSON repository policy text applied to the repository.</p>
    pub policy_text: std::option::Option<std::string::String>,
}
impl SetRepositoryPolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The JSON repository policy text applied to the repository.</p>
    pub fn policy_text(&self) -> std::option::Option<&str> {
        self.policy_text.as_deref()
    }
}
impl std::fmt::Debug for SetRepositoryPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetRepositoryPolicyOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("policy_text", &self.policy_text);
        formatter.finish()
    }
}
/// See [`SetRepositoryPolicyOutput`](crate::output::SetRepositoryPolicyOutput)
pub mod set_repository_policy_output {
    /// A builder for [`SetRepositoryPolicyOutput`](crate::output::SetRepositoryPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) policy_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The JSON repository policy text applied to the repository.</p>
        pub fn policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_text = Some(input.into());
            self
        }
        /// <p>The JSON repository policy text applied to the repository.</p>
        pub fn set_policy_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_text = input;
            self
        }
        /// Consumes the builder and constructs a [`SetRepositoryPolicyOutput`](crate::output::SetRepositoryPolicyOutput)
        pub fn build(self) -> crate::output::SetRepositoryPolicyOutput {
            crate::output::SetRepositoryPolicyOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                policy_text: self.policy_text,
            }
        }
    }
}
impl SetRepositoryPolicyOutput {
    /// Creates a new builder-style object to manufacture [`SetRepositoryPolicyOutput`](crate::output::SetRepositoryPolicyOutput)
    pub fn builder() -> crate::output::set_repository_policy_output::Builder {
        crate::output::set_repository_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutReplicationConfigurationOutput {
    /// <p>The contents of the replication configuration for the registry.</p>
    pub replication_configuration: std::option::Option<crate::model::ReplicationConfiguration>,
}
impl PutReplicationConfigurationOutput {
    /// <p>The contents of the replication configuration for the registry.</p>
    pub fn replication_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfiguration> {
        self.replication_configuration.as_ref()
    }
}
impl std::fmt::Debug for PutReplicationConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutReplicationConfigurationOutput");
        formatter.field("replication_configuration", &self.replication_configuration);
        formatter.finish()
    }
}
/// See [`PutReplicationConfigurationOutput`](crate::output::PutReplicationConfigurationOutput)
pub mod put_replication_configuration_output {
    /// A builder for [`PutReplicationConfigurationOutput`](crate::output::PutReplicationConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_configuration:
            std::option::Option<crate::model::ReplicationConfiguration>,
    }
    impl Builder {
        /// <p>The contents of the replication configuration for the registry.</p>
        pub fn replication_configuration(
            mut self,
            input: crate::model::ReplicationConfiguration,
        ) -> Self {
            self.replication_configuration = Some(input);
            self
        }
        /// <p>The contents of the replication configuration for the registry.</p>
        pub fn set_replication_configuration(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfiguration>,
        ) -> Self {
            self.replication_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PutReplicationConfigurationOutput`](crate::output::PutReplicationConfigurationOutput)
        pub fn build(self) -> crate::output::PutReplicationConfigurationOutput {
            crate::output::PutReplicationConfigurationOutput {
                replication_configuration: self.replication_configuration,
            }
        }
    }
}
impl PutReplicationConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutReplicationConfigurationOutput`](crate::output::PutReplicationConfigurationOutput)
    pub fn builder() -> crate::output::put_replication_configuration_output::Builder {
        crate::output::put_replication_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRegistryScanningConfigurationOutput {
    /// <p>The scanning configuration for your registry.</p>
    pub registry_scanning_configuration:
        std::option::Option<crate::model::RegistryScanningConfiguration>,
}
impl PutRegistryScanningConfigurationOutput {
    /// <p>The scanning configuration for your registry.</p>
    pub fn registry_scanning_configuration(
        &self,
    ) -> std::option::Option<&crate::model::RegistryScanningConfiguration> {
        self.registry_scanning_configuration.as_ref()
    }
}
impl std::fmt::Debug for PutRegistryScanningConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRegistryScanningConfigurationOutput");
        formatter.field(
            "registry_scanning_configuration",
            &self.registry_scanning_configuration,
        );
        formatter.finish()
    }
}
/// See [`PutRegistryScanningConfigurationOutput`](crate::output::PutRegistryScanningConfigurationOutput)
pub mod put_registry_scanning_configuration_output {
    /// A builder for [`PutRegistryScanningConfigurationOutput`](crate::output::PutRegistryScanningConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_scanning_configuration:
            std::option::Option<crate::model::RegistryScanningConfiguration>,
    }
    impl Builder {
        /// <p>The scanning configuration for your registry.</p>
        pub fn registry_scanning_configuration(
            mut self,
            input: crate::model::RegistryScanningConfiguration,
        ) -> Self {
            self.registry_scanning_configuration = Some(input);
            self
        }
        /// <p>The scanning configuration for your registry.</p>
        pub fn set_registry_scanning_configuration(
            mut self,
            input: std::option::Option<crate::model::RegistryScanningConfiguration>,
        ) -> Self {
            self.registry_scanning_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRegistryScanningConfigurationOutput`](crate::output::PutRegistryScanningConfigurationOutput)
        pub fn build(self) -> crate::output::PutRegistryScanningConfigurationOutput {
            crate::output::PutRegistryScanningConfigurationOutput {
                registry_scanning_configuration: self.registry_scanning_configuration,
            }
        }
    }
}
impl PutRegistryScanningConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutRegistryScanningConfigurationOutput`](crate::output::PutRegistryScanningConfigurationOutput)
    pub fn builder() -> crate::output::put_registry_scanning_configuration_output::Builder {
        crate::output::put_registry_scanning_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRegistryPolicyOutput {
    /// <p>The registry ID.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The JSON policy text for your registry.</p>
    pub policy_text: std::option::Option<std::string::String>,
}
impl PutRegistryPolicyOutput {
    /// <p>The registry ID.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The JSON policy text for your registry.</p>
    pub fn policy_text(&self) -> std::option::Option<&str> {
        self.policy_text.as_deref()
    }
}
impl std::fmt::Debug for PutRegistryPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRegistryPolicyOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("policy_text", &self.policy_text);
        formatter.finish()
    }
}
/// See [`PutRegistryPolicyOutput`](crate::output::PutRegistryPolicyOutput)
pub mod put_registry_policy_output {
    /// A builder for [`PutRegistryPolicyOutput`](crate::output::PutRegistryPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) policy_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The registry ID.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The JSON policy text for your registry.</p>
        pub fn policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_text = Some(input.into());
            self
        }
        /// <p>The JSON policy text for your registry.</p>
        pub fn set_policy_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_text = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRegistryPolicyOutput`](crate::output::PutRegistryPolicyOutput)
        pub fn build(self) -> crate::output::PutRegistryPolicyOutput {
            crate::output::PutRegistryPolicyOutput {
                registry_id: self.registry_id,
                policy_text: self.policy_text,
            }
        }
    }
}
impl PutRegistryPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutRegistryPolicyOutput`](crate::output::PutRegistryPolicyOutput)
    pub fn builder() -> crate::output::put_registry_policy_output::Builder {
        crate::output::put_registry_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutLifecyclePolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The JSON repository policy text.</p>
    pub lifecycle_policy_text: std::option::Option<std::string::String>,
}
impl PutLifecyclePolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The JSON repository policy text.</p>
    pub fn lifecycle_policy_text(&self) -> std::option::Option<&str> {
        self.lifecycle_policy_text.as_deref()
    }
}
impl std::fmt::Debug for PutLifecyclePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutLifecyclePolicyOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("lifecycle_policy_text", &self.lifecycle_policy_text);
        formatter.finish()
    }
}
/// See [`PutLifecyclePolicyOutput`](crate::output::PutLifecyclePolicyOutput)
pub mod put_lifecycle_policy_output {
    /// A builder for [`PutLifecyclePolicyOutput`](crate::output::PutLifecyclePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) lifecycle_policy_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The JSON repository policy text.</p>
        pub fn lifecycle_policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_policy_text = Some(input.into());
            self
        }
        /// <p>The JSON repository policy text.</p>
        pub fn set_lifecycle_policy_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_policy_text = input;
            self
        }
        /// Consumes the builder and constructs a [`PutLifecyclePolicyOutput`](crate::output::PutLifecyclePolicyOutput)
        pub fn build(self) -> crate::output::PutLifecyclePolicyOutput {
            crate::output::PutLifecyclePolicyOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                lifecycle_policy_text: self.lifecycle_policy_text,
            }
        }
    }
}
impl PutLifecyclePolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutLifecyclePolicyOutput`](crate::output::PutLifecyclePolicyOutput)
    pub fn builder() -> crate::output::put_lifecycle_policy_output::Builder {
        crate::output::put_lifecycle_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutImageTagMutabilityOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The image tag mutability setting for the repository.</p>
    pub image_tag_mutability: std::option::Option<crate::model::ImageTagMutability>,
}
impl PutImageTagMutabilityOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The image tag mutability setting for the repository.</p>
    pub fn image_tag_mutability(&self) -> std::option::Option<&crate::model::ImageTagMutability> {
        self.image_tag_mutability.as_ref()
    }
}
impl std::fmt::Debug for PutImageTagMutabilityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutImageTagMutabilityOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_tag_mutability", &self.image_tag_mutability);
        formatter.finish()
    }
}
/// See [`PutImageTagMutabilityOutput`](crate::output::PutImageTagMutabilityOutput)
pub mod put_image_tag_mutability_output {
    /// A builder for [`PutImageTagMutabilityOutput`](crate::output::PutImageTagMutabilityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_tag_mutability: std::option::Option<crate::model::ImageTagMutability>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The image tag mutability setting for the repository.</p>
        pub fn image_tag_mutability(mut self, input: crate::model::ImageTagMutability) -> Self {
            self.image_tag_mutability = Some(input);
            self
        }
        /// <p>The image tag mutability setting for the repository.</p>
        pub fn set_image_tag_mutability(
            mut self,
            input: std::option::Option<crate::model::ImageTagMutability>,
        ) -> Self {
            self.image_tag_mutability = input;
            self
        }
        /// Consumes the builder and constructs a [`PutImageTagMutabilityOutput`](crate::output::PutImageTagMutabilityOutput)
        pub fn build(self) -> crate::output::PutImageTagMutabilityOutput {
            crate::output::PutImageTagMutabilityOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                image_tag_mutability: self.image_tag_mutability,
            }
        }
    }
}
impl PutImageTagMutabilityOutput {
    /// Creates a new builder-style object to manufacture [`PutImageTagMutabilityOutput`](crate::output::PutImageTagMutabilityOutput)
    pub fn builder() -> crate::output::put_image_tag_mutability_output::Builder {
        crate::output::put_image_tag_mutability_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutImageScanningConfigurationOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The image scanning configuration setting for the repository.</p>
    pub image_scanning_configuration: std::option::Option<crate::model::ImageScanningConfiguration>,
}
impl PutImageScanningConfigurationOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The image scanning configuration setting for the repository.</p>
    pub fn image_scanning_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ImageScanningConfiguration> {
        self.image_scanning_configuration.as_ref()
    }
}
impl std::fmt::Debug for PutImageScanningConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutImageScanningConfigurationOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field(
            "image_scanning_configuration",
            &self.image_scanning_configuration,
        );
        formatter.finish()
    }
}
/// See [`PutImageScanningConfigurationOutput`](crate::output::PutImageScanningConfigurationOutput)
pub mod put_image_scanning_configuration_output {
    /// A builder for [`PutImageScanningConfigurationOutput`](crate::output::PutImageScanningConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_scanning_configuration:
            std::option::Option<crate::model::ImageScanningConfiguration>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The image scanning configuration setting for the repository.</p>
        pub fn image_scanning_configuration(
            mut self,
            input: crate::model::ImageScanningConfiguration,
        ) -> Self {
            self.image_scanning_configuration = Some(input);
            self
        }
        /// <p>The image scanning configuration setting for the repository.</p>
        pub fn set_image_scanning_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageScanningConfiguration>,
        ) -> Self {
            self.image_scanning_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PutImageScanningConfigurationOutput`](crate::output::PutImageScanningConfigurationOutput)
        pub fn build(self) -> crate::output::PutImageScanningConfigurationOutput {
            crate::output::PutImageScanningConfigurationOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                image_scanning_configuration: self.image_scanning_configuration,
            }
        }
    }
}
impl PutImageScanningConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutImageScanningConfigurationOutput`](crate::output::PutImageScanningConfigurationOutput)
    pub fn builder() -> crate::output::put_image_scanning_configuration_output::Builder {
        crate::output::put_image_scanning_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutImageOutput {
    /// <p>Details of the image uploaded.</p>
    pub image: std::option::Option<crate::model::Image>,
}
impl PutImageOutput {
    /// <p>Details of the image uploaded.</p>
    pub fn image(&self) -> std::option::Option<&crate::model::Image> {
        self.image.as_ref()
    }
}
impl std::fmt::Debug for PutImageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutImageOutput");
        formatter.field("image", &self.image);
        formatter.finish()
    }
}
/// See [`PutImageOutput`](crate::output::PutImageOutput)
pub mod put_image_output {
    /// A builder for [`PutImageOutput`](crate::output::PutImageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image: std::option::Option<crate::model::Image>,
    }
    impl Builder {
        /// <p>Details of the image uploaded.</p>
        pub fn image(mut self, input: crate::model::Image) -> Self {
            self.image = Some(input);
            self
        }
        /// <p>Details of the image uploaded.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.image = input;
            self
        }
        /// Consumes the builder and constructs a [`PutImageOutput`](crate::output::PutImageOutput)
        pub fn build(self) -> crate::output::PutImageOutput {
            crate::output::PutImageOutput { image: self.image }
        }
    }
}
impl PutImageOutput {
    /// Creates a new builder-style object to manufacture [`PutImageOutput`](crate::output::PutImageOutput)
    pub fn builder() -> crate::output::put_image_output::Builder {
        crate::output::put_image_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags for the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags for the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImagesOutput {
    /// <p>The list of image IDs for the requested repository.</p>
    pub image_ids: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>ListImages</code>
    /// request. When the results of a <code>ListImages</code> request exceed
    /// <code>maxResults</code>, this value can be used to retrieve the next page of
    /// results. This value is <code>null</code> when there are no more results to
    /// return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListImagesOutput {
    /// <p>The list of image IDs for the requested repository.</p>
    pub fn image_ids(&self) -> std::option::Option<&[crate::model::ImageIdentifier]> {
        self.image_ids.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>ListImages</code>
    /// request. When the results of a <code>ListImages</code> request exceed
    /// <code>maxResults</code>, this value can be used to retrieve the next page of
    /// results. This value is <code>null</code> when there are no more results to
    /// return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListImagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImagesOutput");
        formatter.field("image_ids", &self.image_ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListImagesOutput`](crate::output::ListImagesOutput)
pub mod list_images_output {
    /// A builder for [`ListImagesOutput`](crate::output::ListImagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_ids: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `image_ids`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>The list of image IDs for the requested repository.</p>
        pub fn image_ids(mut self, input: impl Into<crate::model::ImageIdentifier>) -> Self {
            let mut v = self.image_ids.unwrap_or_default();
            v.push(input.into());
            self.image_ids = Some(v);
            self
        }
        /// <p>The list of image IDs for the requested repository.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.image_ids = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListImages</code>
        /// request. When the results of a <code>ListImages</code> request exceed
        /// <code>maxResults</code>, this value can be used to retrieve the next page of
        /// results. This value is <code>null</code> when there are no more results to
        /// return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>ListImages</code>
        /// request. When the results of a <code>ListImages</code> request exceed
        /// <code>maxResults</code>, this value can be used to retrieve the next page of
        /// results. This value is <code>null</code> when there are no more results to
        /// return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImagesOutput`](crate::output::ListImagesOutput)
        pub fn build(self) -> crate::output::ListImagesOutput {
            crate::output::ListImagesOutput {
                image_ids: self.image_ids,
                next_token: self.next_token,
            }
        }
    }
}
impl ListImagesOutput {
    /// Creates a new builder-style object to manufacture [`ListImagesOutput`](crate::output::ListImagesOutput)
    pub fn builder() -> crate::output::list_images_output::Builder {
        crate::output::list_images_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitiateLayerUploadOutput {
    /// <p>The upload ID for the layer upload. This parameter is passed to further <a>UploadLayerPart</a> and <a>CompleteLayerUpload</a>
    /// operations.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>The size, in bytes, that Amazon ECR expects future layer part uploads to be.</p>
    pub part_size: std::option::Option<i64>,
}
impl InitiateLayerUploadOutput {
    /// <p>The upload ID for the layer upload. This parameter is passed to further <a>UploadLayerPart</a> and <a>CompleteLayerUpload</a>
    /// operations.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>The size, in bytes, that Amazon ECR expects future layer part uploads to be.</p>
    pub fn part_size(&self) -> std::option::Option<i64> {
        self.part_size
    }
}
impl std::fmt::Debug for InitiateLayerUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitiateLayerUploadOutput");
        formatter.field("upload_id", &self.upload_id);
        formatter.field("part_size", &self.part_size);
        formatter.finish()
    }
}
/// See [`InitiateLayerUploadOutput`](crate::output::InitiateLayerUploadOutput)
pub mod initiate_layer_upload_output {
    /// A builder for [`InitiateLayerUploadOutput`](crate::output::InitiateLayerUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) part_size: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The upload ID for the layer upload. This parameter is passed to further <a>UploadLayerPart</a> and <a>CompleteLayerUpload</a>
        /// operations.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The upload ID for the layer upload. This parameter is passed to further <a>UploadLayerPart</a> and <a>CompleteLayerUpload</a>
        /// operations.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>The size, in bytes, that Amazon ECR expects future layer part uploads to be.</p>
        pub fn part_size(mut self, input: i64) -> Self {
            self.part_size = Some(input);
            self
        }
        /// <p>The size, in bytes, that Amazon ECR expects future layer part uploads to be.</p>
        pub fn set_part_size(mut self, input: std::option::Option<i64>) -> Self {
            self.part_size = input;
            self
        }
        /// Consumes the builder and constructs a [`InitiateLayerUploadOutput`](crate::output::InitiateLayerUploadOutput)
        pub fn build(self) -> crate::output::InitiateLayerUploadOutput {
            crate::output::InitiateLayerUploadOutput {
                upload_id: self.upload_id,
                part_size: self.part_size,
            }
        }
    }
}
impl InitiateLayerUploadOutput {
    /// Creates a new builder-style object to manufacture [`InitiateLayerUploadOutput`](crate::output::InitiateLayerUploadOutput)
    pub fn builder() -> crate::output::initiate_layer_upload_output::Builder {
        crate::output::initiate_layer_upload_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRepositoryPolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The JSON repository policy text associated with the repository.</p>
    pub policy_text: std::option::Option<std::string::String>,
}
impl GetRepositoryPolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The JSON repository policy text associated with the repository.</p>
    pub fn policy_text(&self) -> std::option::Option<&str> {
        self.policy_text.as_deref()
    }
}
impl std::fmt::Debug for GetRepositoryPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRepositoryPolicyOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("policy_text", &self.policy_text);
        formatter.finish()
    }
}
/// See [`GetRepositoryPolicyOutput`](crate::output::GetRepositoryPolicyOutput)
pub mod get_repository_policy_output {
    /// A builder for [`GetRepositoryPolicyOutput`](crate::output::GetRepositoryPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) policy_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The JSON repository policy text associated with the repository.</p>
        pub fn policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_text = Some(input.into());
            self
        }
        /// <p>The JSON repository policy text associated with the repository.</p>
        pub fn set_policy_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_text = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRepositoryPolicyOutput`](crate::output::GetRepositoryPolicyOutput)
        pub fn build(self) -> crate::output::GetRepositoryPolicyOutput {
            crate::output::GetRepositoryPolicyOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                policy_text: self.policy_text,
            }
        }
    }
}
impl GetRepositoryPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetRepositoryPolicyOutput`](crate::output::GetRepositoryPolicyOutput)
    pub fn builder() -> crate::output::get_repository_policy_output::Builder {
        crate::output::get_repository_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRegistryScanningConfigurationOutput {
    /// <p>The ID of the registry.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The scanning configuration for the registry.</p>
    pub scanning_configuration: std::option::Option<crate::model::RegistryScanningConfiguration>,
}
impl GetRegistryScanningConfigurationOutput {
    /// <p>The ID of the registry.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The scanning configuration for the registry.</p>
    pub fn scanning_configuration(
        &self,
    ) -> std::option::Option<&crate::model::RegistryScanningConfiguration> {
        self.scanning_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetRegistryScanningConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRegistryScanningConfigurationOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("scanning_configuration", &self.scanning_configuration);
        formatter.finish()
    }
}
/// See [`GetRegistryScanningConfigurationOutput`](crate::output::GetRegistryScanningConfigurationOutput)
pub mod get_registry_scanning_configuration_output {
    /// A builder for [`GetRegistryScanningConfigurationOutput`](crate::output::GetRegistryScanningConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) scanning_configuration:
            std::option::Option<crate::model::RegistryScanningConfiguration>,
    }
    impl Builder {
        /// <p>The ID of the registry.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The ID of the registry.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The scanning configuration for the registry.</p>
        pub fn scanning_configuration(
            mut self,
            input: crate::model::RegistryScanningConfiguration,
        ) -> Self {
            self.scanning_configuration = Some(input);
            self
        }
        /// <p>The scanning configuration for the registry.</p>
        pub fn set_scanning_configuration(
            mut self,
            input: std::option::Option<crate::model::RegistryScanningConfiguration>,
        ) -> Self {
            self.scanning_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRegistryScanningConfigurationOutput`](crate::output::GetRegistryScanningConfigurationOutput)
        pub fn build(self) -> crate::output::GetRegistryScanningConfigurationOutput {
            crate::output::GetRegistryScanningConfigurationOutput {
                registry_id: self.registry_id,
                scanning_configuration: self.scanning_configuration,
            }
        }
    }
}
impl GetRegistryScanningConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetRegistryScanningConfigurationOutput`](crate::output::GetRegistryScanningConfigurationOutput)
    pub fn builder() -> crate::output::get_registry_scanning_configuration_output::Builder {
        crate::output::get_registry_scanning_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRegistryPolicyOutput {
    /// <p>The ID of the registry.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The JSON text of the permissions policy for a registry.</p>
    pub policy_text: std::option::Option<std::string::String>,
}
impl GetRegistryPolicyOutput {
    /// <p>The ID of the registry.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The JSON text of the permissions policy for a registry.</p>
    pub fn policy_text(&self) -> std::option::Option<&str> {
        self.policy_text.as_deref()
    }
}
impl std::fmt::Debug for GetRegistryPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRegistryPolicyOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("policy_text", &self.policy_text);
        formatter.finish()
    }
}
/// See [`GetRegistryPolicyOutput`](crate::output::GetRegistryPolicyOutput)
pub mod get_registry_policy_output {
    /// A builder for [`GetRegistryPolicyOutput`](crate::output::GetRegistryPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) policy_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the registry.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The ID of the registry.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The JSON text of the permissions policy for a registry.</p>
        pub fn policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_text = Some(input.into());
            self
        }
        /// <p>The JSON text of the permissions policy for a registry.</p>
        pub fn set_policy_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_text = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRegistryPolicyOutput`](crate::output::GetRegistryPolicyOutput)
        pub fn build(self) -> crate::output::GetRegistryPolicyOutput {
            crate::output::GetRegistryPolicyOutput {
                registry_id: self.registry_id,
                policy_text: self.policy_text,
            }
        }
    }
}
impl GetRegistryPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetRegistryPolicyOutput`](crate::output::GetRegistryPolicyOutput)
    pub fn builder() -> crate::output::get_registry_policy_output::Builder {
        crate::output::get_registry_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLifecyclePolicyPreviewOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The JSON lifecycle policy text.</p>
    pub lifecycle_policy_text: std::option::Option<std::string::String>,
    /// <p>The status of the lifecycle policy preview request.</p>
    pub status: std::option::Option<crate::model::LifecyclePolicyPreviewStatus>,
    /// <p>The <code>nextToken</code> value to include in a future
    /// <code>GetLifecyclePolicyPreview</code> request. When the results of a
    /// <code>GetLifecyclePolicyPreview</code> request exceed <code>maxResults</code>, this
    /// value can be used to retrieve the next page of results. This value is <code>null</code>
    /// when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The results of the lifecycle policy preview request.</p>
    pub preview_results:
        std::option::Option<std::vec::Vec<crate::model::LifecyclePolicyPreviewResult>>,
    /// <p>The list of images that is returned as a result of the action.</p>
    pub summary: std::option::Option<crate::model::LifecyclePolicyPreviewSummary>,
}
impl GetLifecyclePolicyPreviewOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The JSON lifecycle policy text.</p>
    pub fn lifecycle_policy_text(&self) -> std::option::Option<&str> {
        self.lifecycle_policy_text.as_deref()
    }
    /// <p>The status of the lifecycle policy preview request.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::LifecyclePolicyPreviewStatus> {
        self.status.as_ref()
    }
    /// <p>The <code>nextToken</code> value to include in a future
    /// <code>GetLifecyclePolicyPreview</code> request. When the results of a
    /// <code>GetLifecyclePolicyPreview</code> request exceed <code>maxResults</code>, this
    /// value can be used to retrieve the next page of results. This value is <code>null</code>
    /// when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The results of the lifecycle policy preview request.</p>
    pub fn preview_results(
        &self,
    ) -> std::option::Option<&[crate::model::LifecyclePolicyPreviewResult]> {
        self.preview_results.as_deref()
    }
    /// <p>The list of images that is returned as a result of the action.</p>
    pub fn summary(&self) -> std::option::Option<&crate::model::LifecyclePolicyPreviewSummary> {
        self.summary.as_ref()
    }
}
impl std::fmt::Debug for GetLifecyclePolicyPreviewOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLifecyclePolicyPreviewOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("lifecycle_policy_text", &self.lifecycle_policy_text);
        formatter.field("status", &self.status);
        formatter.field("next_token", &self.next_token);
        formatter.field("preview_results", &self.preview_results);
        formatter.field("summary", &self.summary);
        formatter.finish()
    }
}
/// See [`GetLifecyclePolicyPreviewOutput`](crate::output::GetLifecyclePolicyPreviewOutput)
pub mod get_lifecycle_policy_preview_output {
    /// A builder for [`GetLifecyclePolicyPreviewOutput`](crate::output::GetLifecyclePolicyPreviewOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) lifecycle_policy_text: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::LifecyclePolicyPreviewStatus>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) preview_results:
            std::option::Option<std::vec::Vec<crate::model::LifecyclePolicyPreviewResult>>,
        pub(crate) summary: std::option::Option<crate::model::LifecyclePolicyPreviewSummary>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The JSON lifecycle policy text.</p>
        pub fn lifecycle_policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_policy_text = Some(input.into());
            self
        }
        /// <p>The JSON lifecycle policy text.</p>
        pub fn set_lifecycle_policy_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_policy_text = input;
            self
        }
        /// <p>The status of the lifecycle policy preview request.</p>
        pub fn status(mut self, input: crate::model::LifecyclePolicyPreviewStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the lifecycle policy preview request.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LifecyclePolicyPreviewStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future
        /// <code>GetLifecyclePolicyPreview</code> request. When the results of a
        /// <code>GetLifecyclePolicyPreview</code> request exceed <code>maxResults</code>, this
        /// value can be used to retrieve the next page of results. This value is <code>null</code>
        /// when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future
        /// <code>GetLifecyclePolicyPreview</code> request. When the results of a
        /// <code>GetLifecyclePolicyPreview</code> request exceed <code>maxResults</code>, this
        /// value can be used to retrieve the next page of results. This value is <code>null</code>
        /// when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `preview_results`.
        ///
        /// To override the contents of this collection use [`set_preview_results`](Self::set_preview_results).
        ///
        /// <p>The results of the lifecycle policy preview request.</p>
        pub fn preview_results(
            mut self,
            input: impl Into<crate::model::LifecyclePolicyPreviewResult>,
        ) -> Self {
            let mut v = self.preview_results.unwrap_or_default();
            v.push(input.into());
            self.preview_results = Some(v);
            self
        }
        /// <p>The results of the lifecycle policy preview request.</p>
        pub fn set_preview_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LifecyclePolicyPreviewResult>>,
        ) -> Self {
            self.preview_results = input;
            self
        }
        /// <p>The list of images that is returned as a result of the action.</p>
        pub fn summary(mut self, input: crate::model::LifecyclePolicyPreviewSummary) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p>The list of images that is returned as a result of the action.</p>
        pub fn set_summary(
            mut self,
            input: std::option::Option<crate::model::LifecyclePolicyPreviewSummary>,
        ) -> Self {
            self.summary = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLifecyclePolicyPreviewOutput`](crate::output::GetLifecyclePolicyPreviewOutput)
        pub fn build(self) -> crate::output::GetLifecyclePolicyPreviewOutput {
            crate::output::GetLifecyclePolicyPreviewOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                lifecycle_policy_text: self.lifecycle_policy_text,
                status: self.status,
                next_token: self.next_token,
                preview_results: self.preview_results,
                summary: self.summary,
            }
        }
    }
}
impl GetLifecyclePolicyPreviewOutput {
    /// Creates a new builder-style object to manufacture [`GetLifecyclePolicyPreviewOutput`](crate::output::GetLifecyclePolicyPreviewOutput)
    pub fn builder() -> crate::output::get_lifecycle_policy_preview_output::Builder {
        crate::output::get_lifecycle_policy_preview_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLifecyclePolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The JSON lifecycle policy text.</p>
    pub lifecycle_policy_text: std::option::Option<std::string::String>,
    /// <p>The time stamp of the last time that the lifecycle policy was run.</p>
    pub last_evaluated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetLifecyclePolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The JSON lifecycle policy text.</p>
    pub fn lifecycle_policy_text(&self) -> std::option::Option<&str> {
        self.lifecycle_policy_text.as_deref()
    }
    /// <p>The time stamp of the last time that the lifecycle policy was run.</p>
    pub fn last_evaluated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_evaluated_at.as_ref()
    }
}
impl std::fmt::Debug for GetLifecyclePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLifecyclePolicyOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("lifecycle_policy_text", &self.lifecycle_policy_text);
        formatter.field("last_evaluated_at", &self.last_evaluated_at);
        formatter.finish()
    }
}
/// See [`GetLifecyclePolicyOutput`](crate::output::GetLifecyclePolicyOutput)
pub mod get_lifecycle_policy_output {
    /// A builder for [`GetLifecyclePolicyOutput`](crate::output::GetLifecyclePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) lifecycle_policy_text: std::option::Option<std::string::String>,
        pub(crate) last_evaluated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The JSON lifecycle policy text.</p>
        pub fn lifecycle_policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_policy_text = Some(input.into());
            self
        }
        /// <p>The JSON lifecycle policy text.</p>
        pub fn set_lifecycle_policy_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_policy_text = input;
            self
        }
        /// <p>The time stamp of the last time that the lifecycle policy was run.</p>
        pub fn last_evaluated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_evaluated_at = Some(input);
            self
        }
        /// <p>The time stamp of the last time that the lifecycle policy was run.</p>
        pub fn set_last_evaluated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_evaluated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLifecyclePolicyOutput`](crate::output::GetLifecyclePolicyOutput)
        pub fn build(self) -> crate::output::GetLifecyclePolicyOutput {
            crate::output::GetLifecyclePolicyOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                lifecycle_policy_text: self.lifecycle_policy_text,
                last_evaluated_at: self.last_evaluated_at,
            }
        }
    }
}
impl GetLifecyclePolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetLifecyclePolicyOutput`](crate::output::GetLifecyclePolicyOutput)
    pub fn builder() -> crate::output::get_lifecycle_policy_output::Builder {
        crate::output::get_lifecycle_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDownloadUrlForLayerOutput {
    /// <p>The pre-signed Amazon S3 download URL for the requested layer.</p>
    pub download_url: std::option::Option<std::string::String>,
    /// <p>The digest of the image layer to download.</p>
    pub layer_digest: std::option::Option<std::string::String>,
}
impl GetDownloadUrlForLayerOutput {
    /// <p>The pre-signed Amazon S3 download URL for the requested layer.</p>
    pub fn download_url(&self) -> std::option::Option<&str> {
        self.download_url.as_deref()
    }
    /// <p>The digest of the image layer to download.</p>
    pub fn layer_digest(&self) -> std::option::Option<&str> {
        self.layer_digest.as_deref()
    }
}
impl std::fmt::Debug for GetDownloadUrlForLayerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDownloadUrlForLayerOutput");
        formatter.field("download_url", &self.download_url);
        formatter.field("layer_digest", &self.layer_digest);
        formatter.finish()
    }
}
/// See [`GetDownloadUrlForLayerOutput`](crate::output::GetDownloadUrlForLayerOutput)
pub mod get_download_url_for_layer_output {
    /// A builder for [`GetDownloadUrlForLayerOutput`](crate::output::GetDownloadUrlForLayerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) download_url: std::option::Option<std::string::String>,
        pub(crate) layer_digest: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The pre-signed Amazon S3 download URL for the requested layer.</p>
        pub fn download_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.download_url = Some(input.into());
            self
        }
        /// <p>The pre-signed Amazon S3 download URL for the requested layer.</p>
        pub fn set_download_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.download_url = input;
            self
        }
        /// <p>The digest of the image layer to download.</p>
        pub fn layer_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_digest = Some(input.into());
            self
        }
        /// <p>The digest of the image layer to download.</p>
        pub fn set_layer_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_digest = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDownloadUrlForLayerOutput`](crate::output::GetDownloadUrlForLayerOutput)
        pub fn build(self) -> crate::output::GetDownloadUrlForLayerOutput {
            crate::output::GetDownloadUrlForLayerOutput {
                download_url: self.download_url,
                layer_digest: self.layer_digest,
            }
        }
    }
}
impl GetDownloadUrlForLayerOutput {
    /// Creates a new builder-style object to manufacture [`GetDownloadUrlForLayerOutput`](crate::output::GetDownloadUrlForLayerOutput)
    pub fn builder() -> crate::output::get_download_url_for_layer_output::Builder {
        crate::output::get_download_url_for_layer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAuthorizationTokenOutput {
    /// <p>A list of authorization token data objects that correspond to the
    /// <code>registryIds</code> values in the request.</p>
    pub authorization_data: std::option::Option<std::vec::Vec<crate::model::AuthorizationData>>,
}
impl GetAuthorizationTokenOutput {
    /// <p>A list of authorization token data objects that correspond to the
    /// <code>registryIds</code> values in the request.</p>
    pub fn authorization_data(&self) -> std::option::Option<&[crate::model::AuthorizationData]> {
        self.authorization_data.as_deref()
    }
}
impl std::fmt::Debug for GetAuthorizationTokenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAuthorizationTokenOutput");
        formatter.field("authorization_data", &self.authorization_data);
        formatter.finish()
    }
}
/// See [`GetAuthorizationTokenOutput`](crate::output::GetAuthorizationTokenOutput)
pub mod get_authorization_token_output {
    /// A builder for [`GetAuthorizationTokenOutput`](crate::output::GetAuthorizationTokenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorization_data:
            std::option::Option<std::vec::Vec<crate::model::AuthorizationData>>,
    }
    impl Builder {
        /// Appends an item to `authorization_data`.
        ///
        /// To override the contents of this collection use [`set_authorization_data`](Self::set_authorization_data).
        ///
        /// <p>A list of authorization token data objects that correspond to the
        /// <code>registryIds</code> values in the request.</p>
        pub fn authorization_data(
            mut self,
            input: impl Into<crate::model::AuthorizationData>,
        ) -> Self {
            let mut v = self.authorization_data.unwrap_or_default();
            v.push(input.into());
            self.authorization_data = Some(v);
            self
        }
        /// <p>A list of authorization token data objects that correspond to the
        /// <code>registryIds</code> values in the request.</p>
        pub fn set_authorization_data(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AuthorizationData>>,
        ) -> Self {
            self.authorization_data = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAuthorizationTokenOutput`](crate::output::GetAuthorizationTokenOutput)
        pub fn build(self) -> crate::output::GetAuthorizationTokenOutput {
            crate::output::GetAuthorizationTokenOutput {
                authorization_data: self.authorization_data,
            }
        }
    }
}
impl GetAuthorizationTokenOutput {
    /// Creates a new builder-style object to manufacture [`GetAuthorizationTokenOutput`](crate::output::GetAuthorizationTokenOutput)
    pub fn builder() -> crate::output::get_authorization_token_output::Builder {
        crate::output::get_authorization_token_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRepositoriesOutput {
    /// <p>A list of repository objects corresponding to valid repositories.</p>
    pub repositories: std::option::Option<std::vec::Vec<crate::model::Repository>>,
    /// <p>The <code>nextToken</code> value to include in a future
    /// <code>DescribeRepositories</code> request. When the results of a
    /// <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this value
    /// can be used to retrieve the next page of results. This value is <code>null</code> when
    /// there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeRepositoriesOutput {
    /// <p>A list of repository objects corresponding to valid repositories.</p>
    pub fn repositories(&self) -> std::option::Option<&[crate::model::Repository]> {
        self.repositories.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future
    /// <code>DescribeRepositories</code> request. When the results of a
    /// <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this value
    /// can be used to retrieve the next page of results. This value is <code>null</code> when
    /// there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeRepositoriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRepositoriesOutput");
        formatter.field("repositories", &self.repositories);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeRepositoriesOutput`](crate::output::DescribeRepositoriesOutput)
pub mod describe_repositories_output {
    /// A builder for [`DescribeRepositoriesOutput`](crate::output::DescribeRepositoriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repositories: std::option::Option<std::vec::Vec<crate::model::Repository>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `repositories`.
        ///
        /// To override the contents of this collection use [`set_repositories`](Self::set_repositories).
        ///
        /// <p>A list of repository objects corresponding to valid repositories.</p>
        pub fn repositories(mut self, input: impl Into<crate::model::Repository>) -> Self {
            let mut v = self.repositories.unwrap_or_default();
            v.push(input.into());
            self.repositories = Some(v);
            self
        }
        /// <p>A list of repository objects corresponding to valid repositories.</p>
        pub fn set_repositories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Repository>>,
        ) -> Self {
            self.repositories = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future
        /// <code>DescribeRepositories</code> request. When the results of a
        /// <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this value
        /// can be used to retrieve the next page of results. This value is <code>null</code> when
        /// there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future
        /// <code>DescribeRepositories</code> request. When the results of a
        /// <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this value
        /// can be used to retrieve the next page of results. This value is <code>null</code> when
        /// there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRepositoriesOutput`](crate::output::DescribeRepositoriesOutput)
        pub fn build(self) -> crate::output::DescribeRepositoriesOutput {
            crate::output::DescribeRepositoriesOutput {
                repositories: self.repositories,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeRepositoriesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRepositoriesOutput`](crate::output::DescribeRepositoriesOutput)
    pub fn builder() -> crate::output::describe_repositories_output::Builder {
        crate::output::describe_repositories_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRegistryOutput {
    /// <p>The ID of the registry.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The replication configuration for the registry.</p>
    pub replication_configuration: std::option::Option<crate::model::ReplicationConfiguration>,
}
impl DescribeRegistryOutput {
    /// <p>The ID of the registry.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The replication configuration for the registry.</p>
    pub fn replication_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfiguration> {
        self.replication_configuration.as_ref()
    }
}
impl std::fmt::Debug for DescribeRegistryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRegistryOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("replication_configuration", &self.replication_configuration);
        formatter.finish()
    }
}
/// See [`DescribeRegistryOutput`](crate::output::DescribeRegistryOutput)
pub mod describe_registry_output {
    /// A builder for [`DescribeRegistryOutput`](crate::output::DescribeRegistryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) replication_configuration:
            std::option::Option<crate::model::ReplicationConfiguration>,
    }
    impl Builder {
        /// <p>The ID of the registry.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The ID of the registry.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The replication configuration for the registry.</p>
        pub fn replication_configuration(
            mut self,
            input: crate::model::ReplicationConfiguration,
        ) -> Self {
            self.replication_configuration = Some(input);
            self
        }
        /// <p>The replication configuration for the registry.</p>
        pub fn set_replication_configuration(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfiguration>,
        ) -> Self {
            self.replication_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRegistryOutput`](crate::output::DescribeRegistryOutput)
        pub fn build(self) -> crate::output::DescribeRegistryOutput {
            crate::output::DescribeRegistryOutput {
                registry_id: self.registry_id,
                replication_configuration: self.replication_configuration,
            }
        }
    }
}
impl DescribeRegistryOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRegistryOutput`](crate::output::DescribeRegistryOutput)
    pub fn builder() -> crate::output::describe_registry_output::Builder {
        crate::output::describe_registry_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePullThroughCacheRulesOutput {
    /// <p>The details of the pull through cache rules.</p>
    pub pull_through_cache_rules:
        std::option::Option<std::vec::Vec<crate::model::PullThroughCacheRule>>,
    /// <p>The <code>nextToken</code> value to include in a future
    /// <code>DescribePullThroughCacheRulesRequest</code> request. When the results of a
    /// <code>DescribePullThroughCacheRulesRequest</code> request exceed
    /// <code>maxResults</code>, this value can be used to retrieve the next page of
    /// results. This value is null when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribePullThroughCacheRulesOutput {
    /// <p>The details of the pull through cache rules.</p>
    pub fn pull_through_cache_rules(
        &self,
    ) -> std::option::Option<&[crate::model::PullThroughCacheRule]> {
        self.pull_through_cache_rules.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future
    /// <code>DescribePullThroughCacheRulesRequest</code> request. When the results of a
    /// <code>DescribePullThroughCacheRulesRequest</code> request exceed
    /// <code>maxResults</code>, this value can be used to retrieve the next page of
    /// results. This value is null when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribePullThroughCacheRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePullThroughCacheRulesOutput");
        formatter.field("pull_through_cache_rules", &self.pull_through_cache_rules);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribePullThroughCacheRulesOutput`](crate::output::DescribePullThroughCacheRulesOutput)
pub mod describe_pull_through_cache_rules_output {
    /// A builder for [`DescribePullThroughCacheRulesOutput`](crate::output::DescribePullThroughCacheRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_through_cache_rules:
            std::option::Option<std::vec::Vec<crate::model::PullThroughCacheRule>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `pull_through_cache_rules`.
        ///
        /// To override the contents of this collection use [`set_pull_through_cache_rules`](Self::set_pull_through_cache_rules).
        ///
        /// <p>The details of the pull through cache rules.</p>
        pub fn pull_through_cache_rules(
            mut self,
            input: impl Into<crate::model::PullThroughCacheRule>,
        ) -> Self {
            let mut v = self.pull_through_cache_rules.unwrap_or_default();
            v.push(input.into());
            self.pull_through_cache_rules = Some(v);
            self
        }
        /// <p>The details of the pull through cache rules.</p>
        pub fn set_pull_through_cache_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PullThroughCacheRule>>,
        ) -> Self {
            self.pull_through_cache_rules = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future
        /// <code>DescribePullThroughCacheRulesRequest</code> request. When the results of a
        /// <code>DescribePullThroughCacheRulesRequest</code> request exceed
        /// <code>maxResults</code>, this value can be used to retrieve the next page of
        /// results. This value is null when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future
        /// <code>DescribePullThroughCacheRulesRequest</code> request. When the results of a
        /// <code>DescribePullThroughCacheRulesRequest</code> request exceed
        /// <code>maxResults</code>, this value can be used to retrieve the next page of
        /// results. This value is null when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePullThroughCacheRulesOutput`](crate::output::DescribePullThroughCacheRulesOutput)
        pub fn build(self) -> crate::output::DescribePullThroughCacheRulesOutput {
            crate::output::DescribePullThroughCacheRulesOutput {
                pull_through_cache_rules: self.pull_through_cache_rules,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribePullThroughCacheRulesOutput {
    /// Creates a new builder-style object to manufacture [`DescribePullThroughCacheRulesOutput`](crate::output::DescribePullThroughCacheRulesOutput)
    pub fn builder() -> crate::output::describe_pull_through_cache_rules_output::Builder {
        crate::output::describe_pull_through_cache_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImageScanFindingsOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
    pub image_id: std::option::Option<crate::model::ImageIdentifier>,
    /// <p>The current state of the scan.</p>
    pub image_scan_status: std::option::Option<crate::model::ImageScanStatus>,
    /// <p>The information contained in the image scan findings.</p>
    pub image_scan_findings: std::option::Option<crate::model::ImageScanFindings>,
    /// <p>The <code>nextToken</code> value to include in a future
    /// <code>DescribeImageScanFindings</code> request. When the results of a
    /// <code>DescribeImageScanFindings</code> request exceed <code>maxResults</code>, this
    /// value can be used to retrieve the next page of results. This value is null when there
    /// are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeImageScanFindingsOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
    pub fn image_id(&self) -> std::option::Option<&crate::model::ImageIdentifier> {
        self.image_id.as_ref()
    }
    /// <p>The current state of the scan.</p>
    pub fn image_scan_status(&self) -> std::option::Option<&crate::model::ImageScanStatus> {
        self.image_scan_status.as_ref()
    }
    /// <p>The information contained in the image scan findings.</p>
    pub fn image_scan_findings(&self) -> std::option::Option<&crate::model::ImageScanFindings> {
        self.image_scan_findings.as_ref()
    }
    /// <p>The <code>nextToken</code> value to include in a future
    /// <code>DescribeImageScanFindings</code> request. When the results of a
    /// <code>DescribeImageScanFindings</code> request exceed <code>maxResults</code>, this
    /// value can be used to retrieve the next page of results. This value is null when there
    /// are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeImageScanFindingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImageScanFindingsOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_id", &self.image_id);
        formatter.field("image_scan_status", &self.image_scan_status);
        formatter.field("image_scan_findings", &self.image_scan_findings);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeImageScanFindingsOutput`](crate::output::DescribeImageScanFindingsOutput)
pub mod describe_image_scan_findings_output {
    /// A builder for [`DescribeImageScanFindingsOutput`](crate::output::DescribeImageScanFindingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_id: std::option::Option<crate::model::ImageIdentifier>,
        pub(crate) image_scan_status: std::option::Option<crate::model::ImageScanStatus>,
        pub(crate) image_scan_findings: std::option::Option<crate::model::ImageScanFindings>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn image_id(mut self, input: crate::model::ImageIdentifier) -> Self {
            self.image_id = Some(input);
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn set_image_id(
            mut self,
            input: std::option::Option<crate::model::ImageIdentifier>,
        ) -> Self {
            self.image_id = input;
            self
        }
        /// <p>The current state of the scan.</p>
        pub fn image_scan_status(mut self, input: crate::model::ImageScanStatus) -> Self {
            self.image_scan_status = Some(input);
            self
        }
        /// <p>The current state of the scan.</p>
        pub fn set_image_scan_status(
            mut self,
            input: std::option::Option<crate::model::ImageScanStatus>,
        ) -> Self {
            self.image_scan_status = input;
            self
        }
        /// <p>The information contained in the image scan findings.</p>
        pub fn image_scan_findings(mut self, input: crate::model::ImageScanFindings) -> Self {
            self.image_scan_findings = Some(input);
            self
        }
        /// <p>The information contained in the image scan findings.</p>
        pub fn set_image_scan_findings(
            mut self,
            input: std::option::Option<crate::model::ImageScanFindings>,
        ) -> Self {
            self.image_scan_findings = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future
        /// <code>DescribeImageScanFindings</code> request. When the results of a
        /// <code>DescribeImageScanFindings</code> request exceed <code>maxResults</code>, this
        /// value can be used to retrieve the next page of results. This value is null when there
        /// are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future
        /// <code>DescribeImageScanFindings</code> request. When the results of a
        /// <code>DescribeImageScanFindings</code> request exceed <code>maxResults</code>, this
        /// value can be used to retrieve the next page of results. This value is null when there
        /// are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImageScanFindingsOutput`](crate::output::DescribeImageScanFindingsOutput)
        pub fn build(self) -> crate::output::DescribeImageScanFindingsOutput {
            crate::output::DescribeImageScanFindingsOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                image_id: self.image_id,
                image_scan_status: self.image_scan_status,
                image_scan_findings: self.image_scan_findings,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeImageScanFindingsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeImageScanFindingsOutput`](crate::output::DescribeImageScanFindingsOutput)
    pub fn builder() -> crate::output::describe_image_scan_findings_output::Builder {
        crate::output::describe_image_scan_findings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImagesOutput {
    /// <p>A list of <a>ImageDetail</a> objects that contain data about the
    /// image.</p>
    pub image_details: std::option::Option<std::vec::Vec<crate::model::ImageDetail>>,
    /// <p>The <code>nextToken</code> value to include in a future <code>DescribeImages</code>
    /// request. When the results of a <code>DescribeImages</code> request exceed
    /// <code>maxResults</code>, this value can be used to retrieve the next page of
    /// results. This value is <code>null</code> when there are no more results to
    /// return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeImagesOutput {
    /// <p>A list of <a>ImageDetail</a> objects that contain data about the
    /// image.</p>
    pub fn image_details(&self) -> std::option::Option<&[crate::model::ImageDetail]> {
        self.image_details.as_deref()
    }
    /// <p>The <code>nextToken</code> value to include in a future <code>DescribeImages</code>
    /// request. When the results of a <code>DescribeImages</code> request exceed
    /// <code>maxResults</code>, this value can be used to retrieve the next page of
    /// results. This value is <code>null</code> when there are no more results to
    /// return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeImagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImagesOutput");
        formatter.field("image_details", &self.image_details);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeImagesOutput`](crate::output::DescribeImagesOutput)
pub mod describe_images_output {
    /// A builder for [`DescribeImagesOutput`](crate::output::DescribeImagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_details: std::option::Option<std::vec::Vec<crate::model::ImageDetail>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `image_details`.
        ///
        /// To override the contents of this collection use [`set_image_details`](Self::set_image_details).
        ///
        /// <p>A list of <a>ImageDetail</a> objects that contain data about the
        /// image.</p>
        pub fn image_details(mut self, input: impl Into<crate::model::ImageDetail>) -> Self {
            let mut v = self.image_details.unwrap_or_default();
            v.push(input.into());
            self.image_details = Some(v);
            self
        }
        /// <p>A list of <a>ImageDetail</a> objects that contain data about the
        /// image.</p>
        pub fn set_image_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageDetail>>,
        ) -> Self {
            self.image_details = input;
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>DescribeImages</code>
        /// request. When the results of a <code>DescribeImages</code> request exceed
        /// <code>maxResults</code>, this value can be used to retrieve the next page of
        /// results. This value is <code>null</code> when there are no more results to
        /// return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value to include in a future <code>DescribeImages</code>
        /// request. When the results of a <code>DescribeImages</code> request exceed
        /// <code>maxResults</code>, this value can be used to retrieve the next page of
        /// results. This value is <code>null</code> when there are no more results to
        /// return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImagesOutput`](crate::output::DescribeImagesOutput)
        pub fn build(self) -> crate::output::DescribeImagesOutput {
            crate::output::DescribeImagesOutput {
                image_details: self.image_details,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeImagesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeImagesOutput`](crate::output::DescribeImagesOutput)
    pub fn builder() -> crate::output::describe_images_output::Builder {
        crate::output::describe_images_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImageReplicationStatusOutput {
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
    pub image_id: std::option::Option<crate::model::ImageIdentifier>,
    /// <p>The replication status details for the images in the specified repository.</p>
    pub replication_statuses:
        std::option::Option<std::vec::Vec<crate::model::ImageReplicationStatus>>,
}
impl DescribeImageReplicationStatusOutput {
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
    pub fn image_id(&self) -> std::option::Option<&crate::model::ImageIdentifier> {
        self.image_id.as_ref()
    }
    /// <p>The replication status details for the images in the specified repository.</p>
    pub fn replication_statuses(
        &self,
    ) -> std::option::Option<&[crate::model::ImageReplicationStatus]> {
        self.replication_statuses.as_deref()
    }
}
impl std::fmt::Debug for DescribeImageReplicationStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImageReplicationStatusOutput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_id", &self.image_id);
        formatter.field("replication_statuses", &self.replication_statuses);
        formatter.finish()
    }
}
/// See [`DescribeImageReplicationStatusOutput`](crate::output::DescribeImageReplicationStatusOutput)
pub mod describe_image_replication_status_output {
    /// A builder for [`DescribeImageReplicationStatusOutput`](crate::output::DescribeImageReplicationStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_id: std::option::Option<crate::model::ImageIdentifier>,
        pub(crate) replication_statuses:
            std::option::Option<std::vec::Vec<crate::model::ImageReplicationStatus>>,
    }
    impl Builder {
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn image_id(mut self, input: crate::model::ImageIdentifier) -> Self {
            self.image_id = Some(input);
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn set_image_id(
            mut self,
            input: std::option::Option<crate::model::ImageIdentifier>,
        ) -> Self {
            self.image_id = input;
            self
        }
        /// Appends an item to `replication_statuses`.
        ///
        /// To override the contents of this collection use [`set_replication_statuses`](Self::set_replication_statuses).
        ///
        /// <p>The replication status details for the images in the specified repository.</p>
        pub fn replication_statuses(
            mut self,
            input: impl Into<crate::model::ImageReplicationStatus>,
        ) -> Self {
            let mut v = self.replication_statuses.unwrap_or_default();
            v.push(input.into());
            self.replication_statuses = Some(v);
            self
        }
        /// <p>The replication status details for the images in the specified repository.</p>
        pub fn set_replication_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageReplicationStatus>>,
        ) -> Self {
            self.replication_statuses = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImageReplicationStatusOutput`](crate::output::DescribeImageReplicationStatusOutput)
        pub fn build(self) -> crate::output::DescribeImageReplicationStatusOutput {
            crate::output::DescribeImageReplicationStatusOutput {
                repository_name: self.repository_name,
                image_id: self.image_id,
                replication_statuses: self.replication_statuses,
            }
        }
    }
}
impl DescribeImageReplicationStatusOutput {
    /// Creates a new builder-style object to manufacture [`DescribeImageReplicationStatusOutput`](crate::output::DescribeImageReplicationStatusOutput)
    pub fn builder() -> crate::output::describe_image_replication_status_output::Builder {
        crate::output::describe_image_replication_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRepositoryPolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The JSON repository policy that was deleted from the repository.</p>
    pub policy_text: std::option::Option<std::string::String>,
}
impl DeleteRepositoryPolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The JSON repository policy that was deleted from the repository.</p>
    pub fn policy_text(&self) -> std::option::Option<&str> {
        self.policy_text.as_deref()
    }
}
impl std::fmt::Debug for DeleteRepositoryPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRepositoryPolicyOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("policy_text", &self.policy_text);
        formatter.finish()
    }
}
/// See [`DeleteRepositoryPolicyOutput`](crate::output::DeleteRepositoryPolicyOutput)
pub mod delete_repository_policy_output {
    /// A builder for [`DeleteRepositoryPolicyOutput`](crate::output::DeleteRepositoryPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) policy_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The JSON repository policy that was deleted from the repository.</p>
        pub fn policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_text = Some(input.into());
            self
        }
        /// <p>The JSON repository policy that was deleted from the repository.</p>
        pub fn set_policy_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_text = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRepositoryPolicyOutput`](crate::output::DeleteRepositoryPolicyOutput)
        pub fn build(self) -> crate::output::DeleteRepositoryPolicyOutput {
            crate::output::DeleteRepositoryPolicyOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                policy_text: self.policy_text,
            }
        }
    }
}
impl DeleteRepositoryPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryPolicyOutput`](crate::output::DeleteRepositoryPolicyOutput)
    pub fn builder() -> crate::output::delete_repository_policy_output::Builder {
        crate::output::delete_repository_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRepositoryOutput {
    /// <p>The repository that was deleted.</p>
    pub repository: std::option::Option<crate::model::Repository>,
}
impl DeleteRepositoryOutput {
    /// <p>The repository that was deleted.</p>
    pub fn repository(&self) -> std::option::Option<&crate::model::Repository> {
        self.repository.as_ref()
    }
}
impl std::fmt::Debug for DeleteRepositoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRepositoryOutput");
        formatter.field("repository", &self.repository);
        formatter.finish()
    }
}
/// See [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput)
pub mod delete_repository_output {
    /// A builder for [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository: std::option::Option<crate::model::Repository>,
    }
    impl Builder {
        /// <p>The repository that was deleted.</p>
        pub fn repository(mut self, input: crate::model::Repository) -> Self {
            self.repository = Some(input);
            self
        }
        /// <p>The repository that was deleted.</p>
        pub fn set_repository(
            mut self,
            input: std::option::Option<crate::model::Repository>,
        ) -> Self {
            self.repository = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput)
        pub fn build(self) -> crate::output::DeleteRepositoryOutput {
            crate::output::DeleteRepositoryOutput {
                repository: self.repository,
            }
        }
    }
}
impl DeleteRepositoryOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput)
    pub fn builder() -> crate::output::delete_repository_output::Builder {
        crate::output::delete_repository_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRegistryPolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The contents of the registry permissions policy that was deleted.</p>
    pub policy_text: std::option::Option<std::string::String>,
}
impl DeleteRegistryPolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The contents of the registry permissions policy that was deleted.</p>
    pub fn policy_text(&self) -> std::option::Option<&str> {
        self.policy_text.as_deref()
    }
}
impl std::fmt::Debug for DeleteRegistryPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRegistryPolicyOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("policy_text", &self.policy_text);
        formatter.finish()
    }
}
/// See [`DeleteRegistryPolicyOutput`](crate::output::DeleteRegistryPolicyOutput)
pub mod delete_registry_policy_output {
    /// A builder for [`DeleteRegistryPolicyOutput`](crate::output::DeleteRegistryPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) policy_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The contents of the registry permissions policy that was deleted.</p>
        pub fn policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_text = Some(input.into());
            self
        }
        /// <p>The contents of the registry permissions policy that was deleted.</p>
        pub fn set_policy_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_text = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRegistryPolicyOutput`](crate::output::DeleteRegistryPolicyOutput)
        pub fn build(self) -> crate::output::DeleteRegistryPolicyOutput {
            crate::output::DeleteRegistryPolicyOutput {
                registry_id: self.registry_id,
                policy_text: self.policy_text,
            }
        }
    }
}
impl DeleteRegistryPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRegistryPolicyOutput`](crate::output::DeleteRegistryPolicyOutput)
    pub fn builder() -> crate::output::delete_registry_policy_output::Builder {
        crate::output::delete_registry_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePullThroughCacheRuleOutput {
    /// <p>The Amazon ECR repository prefix associated with the request.</p>
    pub ecr_repository_prefix: std::option::Option<std::string::String>,
    /// <p>The upstream registry URL associated with the pull through cache rule.</p>
    pub upstream_registry_url: std::option::Option<std::string::String>,
    /// <p>The timestamp associated with the pull through cache rule.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
}
impl DeletePullThroughCacheRuleOutput {
    /// <p>The Amazon ECR repository prefix associated with the request.</p>
    pub fn ecr_repository_prefix(&self) -> std::option::Option<&str> {
        self.ecr_repository_prefix.as_deref()
    }
    /// <p>The upstream registry URL associated with the pull through cache rule.</p>
    pub fn upstream_registry_url(&self) -> std::option::Option<&str> {
        self.upstream_registry_url.as_deref()
    }
    /// <p>The timestamp associated with the pull through cache rule.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
}
impl std::fmt::Debug for DeletePullThroughCacheRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePullThroughCacheRuleOutput");
        formatter.field("ecr_repository_prefix", &self.ecr_repository_prefix);
        formatter.field("upstream_registry_url", &self.upstream_registry_url);
        formatter.field("created_at", &self.created_at);
        formatter.field("registry_id", &self.registry_id);
        formatter.finish()
    }
}
/// See [`DeletePullThroughCacheRuleOutput`](crate::output::DeletePullThroughCacheRuleOutput)
pub mod delete_pull_through_cache_rule_output {
    /// A builder for [`DeletePullThroughCacheRuleOutput`](crate::output::DeletePullThroughCacheRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ecr_repository_prefix: std::option::Option<std::string::String>,
        pub(crate) upstream_registry_url: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) registry_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon ECR repository prefix associated with the request.</p>
        pub fn ecr_repository_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.ecr_repository_prefix = Some(input.into());
            self
        }
        /// <p>The Amazon ECR repository prefix associated with the request.</p>
        pub fn set_ecr_repository_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ecr_repository_prefix = input;
            self
        }
        /// <p>The upstream registry URL associated with the pull through cache rule.</p>
        pub fn upstream_registry_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.upstream_registry_url = Some(input.into());
            self
        }
        /// <p>The upstream registry URL associated with the pull through cache rule.</p>
        pub fn set_upstream_registry_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.upstream_registry_url = input;
            self
        }
        /// <p>The timestamp associated with the pull through cache rule.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp associated with the pull through cache rule.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePullThroughCacheRuleOutput`](crate::output::DeletePullThroughCacheRuleOutput)
        pub fn build(self) -> crate::output::DeletePullThroughCacheRuleOutput {
            crate::output::DeletePullThroughCacheRuleOutput {
                ecr_repository_prefix: self.ecr_repository_prefix,
                upstream_registry_url: self.upstream_registry_url,
                created_at: self.created_at,
                registry_id: self.registry_id,
            }
        }
    }
}
impl DeletePullThroughCacheRuleOutput {
    /// Creates a new builder-style object to manufacture [`DeletePullThroughCacheRuleOutput`](crate::output::DeletePullThroughCacheRuleOutput)
    pub fn builder() -> crate::output::delete_pull_through_cache_rule_output::Builder {
        crate::output::delete_pull_through_cache_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLifecyclePolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The JSON lifecycle policy text.</p>
    pub lifecycle_policy_text: std::option::Option<std::string::String>,
    /// <p>The time stamp of the last time that the lifecycle policy was run.</p>
    pub last_evaluated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl DeleteLifecyclePolicyOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The JSON lifecycle policy text.</p>
    pub fn lifecycle_policy_text(&self) -> std::option::Option<&str> {
        self.lifecycle_policy_text.as_deref()
    }
    /// <p>The time stamp of the last time that the lifecycle policy was run.</p>
    pub fn last_evaluated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_evaluated_at.as_ref()
    }
}
impl std::fmt::Debug for DeleteLifecyclePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLifecyclePolicyOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("lifecycle_policy_text", &self.lifecycle_policy_text);
        formatter.field("last_evaluated_at", &self.last_evaluated_at);
        formatter.finish()
    }
}
/// See [`DeleteLifecyclePolicyOutput`](crate::output::DeleteLifecyclePolicyOutput)
pub mod delete_lifecycle_policy_output {
    /// A builder for [`DeleteLifecyclePolicyOutput`](crate::output::DeleteLifecyclePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) lifecycle_policy_text: std::option::Option<std::string::String>,
        pub(crate) last_evaluated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The JSON lifecycle policy text.</p>
        pub fn lifecycle_policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_policy_text = Some(input.into());
            self
        }
        /// <p>The JSON lifecycle policy text.</p>
        pub fn set_lifecycle_policy_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_policy_text = input;
            self
        }
        /// <p>The time stamp of the last time that the lifecycle policy was run.</p>
        pub fn last_evaluated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_evaluated_at = Some(input);
            self
        }
        /// <p>The time stamp of the last time that the lifecycle policy was run.</p>
        pub fn set_last_evaluated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_evaluated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLifecyclePolicyOutput`](crate::output::DeleteLifecyclePolicyOutput)
        pub fn build(self) -> crate::output::DeleteLifecyclePolicyOutput {
            crate::output::DeleteLifecyclePolicyOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                lifecycle_policy_text: self.lifecycle_policy_text,
                last_evaluated_at: self.last_evaluated_at,
            }
        }
    }
}
impl DeleteLifecyclePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteLifecyclePolicyOutput`](crate::output::DeleteLifecyclePolicyOutput)
    pub fn builder() -> crate::output::delete_lifecycle_policy_output::Builder {
        crate::output::delete_lifecycle_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRepositoryOutput {
    /// <p>The repository that was created.</p>
    pub repository: std::option::Option<crate::model::Repository>,
}
impl CreateRepositoryOutput {
    /// <p>The repository that was created.</p>
    pub fn repository(&self) -> std::option::Option<&crate::model::Repository> {
        self.repository.as_ref()
    }
}
impl std::fmt::Debug for CreateRepositoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRepositoryOutput");
        formatter.field("repository", &self.repository);
        formatter.finish()
    }
}
/// See [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput)
pub mod create_repository_output {
    /// A builder for [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository: std::option::Option<crate::model::Repository>,
    }
    impl Builder {
        /// <p>The repository that was created.</p>
        pub fn repository(mut self, input: crate::model::Repository) -> Self {
            self.repository = Some(input);
            self
        }
        /// <p>The repository that was created.</p>
        pub fn set_repository(
            mut self,
            input: std::option::Option<crate::model::Repository>,
        ) -> Self {
            self.repository = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput)
        pub fn build(self) -> crate::output::CreateRepositoryOutput {
            crate::output::CreateRepositoryOutput {
                repository: self.repository,
            }
        }
    }
}
impl CreateRepositoryOutput {
    /// Creates a new builder-style object to manufacture [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput)
    pub fn builder() -> crate::output::create_repository_output::Builder {
        crate::output::create_repository_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePullThroughCacheRuleOutput {
    /// <p>The Amazon ECR repository prefix associated with the pull through cache rule.</p>
    pub ecr_repository_prefix: std::option::Option<std::string::String>,
    /// <p>The upstream registry URL associated with the pull through cache rule.</p>
    pub upstream_registry_url: std::option::Option<std::string::String>,
    /// <p>The date and time, in JavaScript date format, when the pull through cache rule was
    /// created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
}
impl CreatePullThroughCacheRuleOutput {
    /// <p>The Amazon ECR repository prefix associated with the pull through cache rule.</p>
    pub fn ecr_repository_prefix(&self) -> std::option::Option<&str> {
        self.ecr_repository_prefix.as_deref()
    }
    /// <p>The upstream registry URL associated with the pull through cache rule.</p>
    pub fn upstream_registry_url(&self) -> std::option::Option<&str> {
        self.upstream_registry_url.as_deref()
    }
    /// <p>The date and time, in JavaScript date format, when the pull through cache rule was
    /// created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
}
impl std::fmt::Debug for CreatePullThroughCacheRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePullThroughCacheRuleOutput");
        formatter.field("ecr_repository_prefix", &self.ecr_repository_prefix);
        formatter.field("upstream_registry_url", &self.upstream_registry_url);
        formatter.field("created_at", &self.created_at);
        formatter.field("registry_id", &self.registry_id);
        formatter.finish()
    }
}
/// See [`CreatePullThroughCacheRuleOutput`](crate::output::CreatePullThroughCacheRuleOutput)
pub mod create_pull_through_cache_rule_output {
    /// A builder for [`CreatePullThroughCacheRuleOutput`](crate::output::CreatePullThroughCacheRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ecr_repository_prefix: std::option::Option<std::string::String>,
        pub(crate) upstream_registry_url: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) registry_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon ECR repository prefix associated with the pull through cache rule.</p>
        pub fn ecr_repository_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.ecr_repository_prefix = Some(input.into());
            self
        }
        /// <p>The Amazon ECR repository prefix associated with the pull through cache rule.</p>
        pub fn set_ecr_repository_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ecr_repository_prefix = input;
            self
        }
        /// <p>The upstream registry URL associated with the pull through cache rule.</p>
        pub fn upstream_registry_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.upstream_registry_url = Some(input.into());
            self
        }
        /// <p>The upstream registry URL associated with the pull through cache rule.</p>
        pub fn set_upstream_registry_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.upstream_registry_url = input;
            self
        }
        /// <p>The date and time, in JavaScript date format, when the pull through cache rule was
        /// created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time, in JavaScript date format, when the pull through cache rule was
        /// created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePullThroughCacheRuleOutput`](crate::output::CreatePullThroughCacheRuleOutput)
        pub fn build(self) -> crate::output::CreatePullThroughCacheRuleOutput {
            crate::output::CreatePullThroughCacheRuleOutput {
                ecr_repository_prefix: self.ecr_repository_prefix,
                upstream_registry_url: self.upstream_registry_url,
                created_at: self.created_at,
                registry_id: self.registry_id,
            }
        }
    }
}
impl CreatePullThroughCacheRuleOutput {
    /// Creates a new builder-style object to manufacture [`CreatePullThroughCacheRuleOutput`](crate::output::CreatePullThroughCacheRuleOutput)
    pub fn builder() -> crate::output::create_pull_through_cache_rule_output::Builder {
        crate::output::create_pull_through_cache_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompleteLayerUploadOutput {
    /// <p>The registry ID associated with the request.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The upload ID associated with the layer.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>The <code>sha256</code> digest of the image layer.</p>
    pub layer_digest: std::option::Option<std::string::String>,
}
impl CompleteLayerUploadOutput {
    /// <p>The registry ID associated with the request.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The upload ID associated with the layer.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>The <code>sha256</code> digest of the image layer.</p>
    pub fn layer_digest(&self) -> std::option::Option<&str> {
        self.layer_digest.as_deref()
    }
}
impl std::fmt::Debug for CompleteLayerUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompleteLayerUploadOutput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("upload_id", &self.upload_id);
        formatter.field("layer_digest", &self.layer_digest);
        formatter.finish()
    }
}
/// See [`CompleteLayerUploadOutput`](crate::output::CompleteLayerUploadOutput)
pub mod complete_layer_upload_output {
    /// A builder for [`CompleteLayerUploadOutput`](crate::output::CompleteLayerUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) layer_digest: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The registry ID associated with the request.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the request.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The upload ID associated with the layer.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The upload ID associated with the layer.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>The <code>sha256</code> digest of the image layer.</p>
        pub fn layer_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_digest = Some(input.into());
            self
        }
        /// <p>The <code>sha256</code> digest of the image layer.</p>
        pub fn set_layer_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_digest = input;
            self
        }
        /// Consumes the builder and constructs a [`CompleteLayerUploadOutput`](crate::output::CompleteLayerUploadOutput)
        pub fn build(self) -> crate::output::CompleteLayerUploadOutput {
            crate::output::CompleteLayerUploadOutput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                upload_id: self.upload_id,
                layer_digest: self.layer_digest,
            }
        }
    }
}
impl CompleteLayerUploadOutput {
    /// Creates a new builder-style object to manufacture [`CompleteLayerUploadOutput`](crate::output::CompleteLayerUploadOutput)
    pub fn builder() -> crate::output::complete_layer_upload_output::Builder {
        crate::output::complete_layer_upload_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetRepositoryScanningConfigurationOutput {
    /// <p>The scanning configuration for the requested repositories.</p>
    pub scanning_configurations:
        std::option::Option<std::vec::Vec<crate::model::RepositoryScanningConfiguration>>,
    /// <p>Any failures associated with the call.</p>
    pub failures:
        std::option::Option<std::vec::Vec<crate::model::RepositoryScanningConfigurationFailure>>,
}
impl BatchGetRepositoryScanningConfigurationOutput {
    /// <p>The scanning configuration for the requested repositories.</p>
    pub fn scanning_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::RepositoryScanningConfiguration]> {
        self.scanning_configurations.as_deref()
    }
    /// <p>Any failures associated with the call.</p>
    pub fn failures(
        &self,
    ) -> std::option::Option<&[crate::model::RepositoryScanningConfigurationFailure]> {
        self.failures.as_deref()
    }
}
impl std::fmt::Debug for BatchGetRepositoryScanningConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetRepositoryScanningConfigurationOutput");
        formatter.field("scanning_configurations", &self.scanning_configurations);
        formatter.field("failures", &self.failures);
        formatter.finish()
    }
}
/// See [`BatchGetRepositoryScanningConfigurationOutput`](crate::output::BatchGetRepositoryScanningConfigurationOutput)
pub mod batch_get_repository_scanning_configuration_output {
    /// A builder for [`BatchGetRepositoryScanningConfigurationOutput`](crate::output::BatchGetRepositoryScanningConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scanning_configurations:
            std::option::Option<std::vec::Vec<crate::model::RepositoryScanningConfiguration>>,
        pub(crate) failures: std::option::Option<
            std::vec::Vec<crate::model::RepositoryScanningConfigurationFailure>,
        >,
    }
    impl Builder {
        /// Appends an item to `scanning_configurations`.
        ///
        /// To override the contents of this collection use [`set_scanning_configurations`](Self::set_scanning_configurations).
        ///
        /// <p>The scanning configuration for the requested repositories.</p>
        pub fn scanning_configurations(
            mut self,
            input: impl Into<crate::model::RepositoryScanningConfiguration>,
        ) -> Self {
            let mut v = self.scanning_configurations.unwrap_or_default();
            v.push(input.into());
            self.scanning_configurations = Some(v);
            self
        }
        /// <p>The scanning configuration for the requested repositories.</p>
        pub fn set_scanning_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RepositoryScanningConfiguration>,
            >,
        ) -> Self {
            self.scanning_configurations = input;
            self
        }
        /// Appends an item to `failures`.
        ///
        /// To override the contents of this collection use [`set_failures`](Self::set_failures).
        ///
        /// <p>Any failures associated with the call.</p>
        pub fn failures(
            mut self,
            input: impl Into<crate::model::RepositoryScanningConfigurationFailure>,
        ) -> Self {
            let mut v = self.failures.unwrap_or_default();
            v.push(input.into());
            self.failures = Some(v);
            self
        }
        /// <p>Any failures associated with the call.</p>
        pub fn set_failures(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RepositoryScanningConfigurationFailure>,
            >,
        ) -> Self {
            self.failures = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetRepositoryScanningConfigurationOutput`](crate::output::BatchGetRepositoryScanningConfigurationOutput)
        pub fn build(self) -> crate::output::BatchGetRepositoryScanningConfigurationOutput {
            crate::output::BatchGetRepositoryScanningConfigurationOutput {
                scanning_configurations: self.scanning_configurations,
                failures: self.failures,
            }
        }
    }
}
impl BatchGetRepositoryScanningConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetRepositoryScanningConfigurationOutput`](crate::output::BatchGetRepositoryScanningConfigurationOutput)
    pub fn builder() -> crate::output::batch_get_repository_scanning_configuration_output::Builder {
        crate::output::batch_get_repository_scanning_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetImageOutput {
    /// <p>A list of image objects corresponding to the image references in the request.</p>
    pub images: std::option::Option<std::vec::Vec<crate::model::Image>>,
    /// <p>Any failures associated with the call.</p>
    pub failures: std::option::Option<std::vec::Vec<crate::model::ImageFailure>>,
}
impl BatchGetImageOutput {
    /// <p>A list of image objects corresponding to the image references in the request.</p>
    pub fn images(&self) -> std::option::Option<&[crate::model::Image]> {
        self.images.as_deref()
    }
    /// <p>Any failures associated with the call.</p>
    pub fn failures(&self) -> std::option::Option<&[crate::model::ImageFailure]> {
        self.failures.as_deref()
    }
}
impl std::fmt::Debug for BatchGetImageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetImageOutput");
        formatter.field("images", &self.images);
        formatter.field("failures", &self.failures);
        formatter.finish()
    }
}
/// See [`BatchGetImageOutput`](crate::output::BatchGetImageOutput)
pub mod batch_get_image_output {
    /// A builder for [`BatchGetImageOutput`](crate::output::BatchGetImageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) images: std::option::Option<std::vec::Vec<crate::model::Image>>,
        pub(crate) failures: std::option::Option<std::vec::Vec<crate::model::ImageFailure>>,
    }
    impl Builder {
        /// Appends an item to `images`.
        ///
        /// To override the contents of this collection use [`set_images`](Self::set_images).
        ///
        /// <p>A list of image objects corresponding to the image references in the request.</p>
        pub fn images(mut self, input: impl Into<crate::model::Image>) -> Self {
            let mut v = self.images.unwrap_or_default();
            v.push(input.into());
            self.images = Some(v);
            self
        }
        /// <p>A list of image objects corresponding to the image references in the request.</p>
        pub fn set_images(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Image>>,
        ) -> Self {
            self.images = input;
            self
        }
        /// Appends an item to `failures`.
        ///
        /// To override the contents of this collection use [`set_failures`](Self::set_failures).
        ///
        /// <p>Any failures associated with the call.</p>
        pub fn failures(mut self, input: impl Into<crate::model::ImageFailure>) -> Self {
            let mut v = self.failures.unwrap_or_default();
            v.push(input.into());
            self.failures = Some(v);
            self
        }
        /// <p>Any failures associated with the call.</p>
        pub fn set_failures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageFailure>>,
        ) -> Self {
            self.failures = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetImageOutput`](crate::output::BatchGetImageOutput)
        pub fn build(self) -> crate::output::BatchGetImageOutput {
            crate::output::BatchGetImageOutput {
                images: self.images,
                failures: self.failures,
            }
        }
    }
}
impl BatchGetImageOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetImageOutput`](crate::output::BatchGetImageOutput)
    pub fn builder() -> crate::output::batch_get_image_output::Builder {
        crate::output::batch_get_image_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteImageOutput {
    /// <p>The image IDs of the deleted images.</p>
    pub image_ids: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
    /// <p>Any failures associated with the call.</p>
    pub failures: std::option::Option<std::vec::Vec<crate::model::ImageFailure>>,
}
impl BatchDeleteImageOutput {
    /// <p>The image IDs of the deleted images.</p>
    pub fn image_ids(&self) -> std::option::Option<&[crate::model::ImageIdentifier]> {
        self.image_ids.as_deref()
    }
    /// <p>Any failures associated with the call.</p>
    pub fn failures(&self) -> std::option::Option<&[crate::model::ImageFailure]> {
        self.failures.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteImageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteImageOutput");
        formatter.field("image_ids", &self.image_ids);
        formatter.field("failures", &self.failures);
        formatter.finish()
    }
}
/// See [`BatchDeleteImageOutput`](crate::output::BatchDeleteImageOutput)
pub mod batch_delete_image_output {
    /// A builder for [`BatchDeleteImageOutput`](crate::output::BatchDeleteImageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_ids: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        pub(crate) failures: std::option::Option<std::vec::Vec<crate::model::ImageFailure>>,
    }
    impl Builder {
        /// Appends an item to `image_ids`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>The image IDs of the deleted images.</p>
        pub fn image_ids(mut self, input: impl Into<crate::model::ImageIdentifier>) -> Self {
            let mut v = self.image_ids.unwrap_or_default();
            v.push(input.into());
            self.image_ids = Some(v);
            self
        }
        /// <p>The image IDs of the deleted images.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.image_ids = input;
            self
        }
        /// Appends an item to `failures`.
        ///
        /// To override the contents of this collection use [`set_failures`](Self::set_failures).
        ///
        /// <p>Any failures associated with the call.</p>
        pub fn failures(mut self, input: impl Into<crate::model::ImageFailure>) -> Self {
            let mut v = self.failures.unwrap_or_default();
            v.push(input.into());
            self.failures = Some(v);
            self
        }
        /// <p>Any failures associated with the call.</p>
        pub fn set_failures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageFailure>>,
        ) -> Self {
            self.failures = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteImageOutput`](crate::output::BatchDeleteImageOutput)
        pub fn build(self) -> crate::output::BatchDeleteImageOutput {
            crate::output::BatchDeleteImageOutput {
                image_ids: self.image_ids,
                failures: self.failures,
            }
        }
    }
}
impl BatchDeleteImageOutput {
    /// Creates a new builder-style object to manufacture [`BatchDeleteImageOutput`](crate::output::BatchDeleteImageOutput)
    pub fn builder() -> crate::output::batch_delete_image_output::Builder {
        crate::output::batch_delete_image_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCheckLayerAvailabilityOutput {
    /// <p>A list of image layer objects corresponding to the image layer references in the
    /// request.</p>
    pub layers: std::option::Option<std::vec::Vec<crate::model::Layer>>,
    /// <p>Any failures associated with the call.</p>
    pub failures: std::option::Option<std::vec::Vec<crate::model::LayerFailure>>,
}
impl BatchCheckLayerAvailabilityOutput {
    /// <p>A list of image layer objects corresponding to the image layer references in the
    /// request.</p>
    pub fn layers(&self) -> std::option::Option<&[crate::model::Layer]> {
        self.layers.as_deref()
    }
    /// <p>Any failures associated with the call.</p>
    pub fn failures(&self) -> std::option::Option<&[crate::model::LayerFailure]> {
        self.failures.as_deref()
    }
}
impl std::fmt::Debug for BatchCheckLayerAvailabilityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCheckLayerAvailabilityOutput");
        formatter.field("layers", &self.layers);
        formatter.field("failures", &self.failures);
        formatter.finish()
    }
}
/// See [`BatchCheckLayerAvailabilityOutput`](crate::output::BatchCheckLayerAvailabilityOutput)
pub mod batch_check_layer_availability_output {
    /// A builder for [`BatchCheckLayerAvailabilityOutput`](crate::output::BatchCheckLayerAvailabilityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) layers: std::option::Option<std::vec::Vec<crate::model::Layer>>,
        pub(crate) failures: std::option::Option<std::vec::Vec<crate::model::LayerFailure>>,
    }
    impl Builder {
        /// Appends an item to `layers`.
        ///
        /// To override the contents of this collection use [`set_layers`](Self::set_layers).
        ///
        /// <p>A list of image layer objects corresponding to the image layer references in the
        /// request.</p>
        pub fn layers(mut self, input: impl Into<crate::model::Layer>) -> Self {
            let mut v = self.layers.unwrap_or_default();
            v.push(input.into());
            self.layers = Some(v);
            self
        }
        /// <p>A list of image layer objects corresponding to the image layer references in the
        /// request.</p>
        pub fn set_layers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Layer>>,
        ) -> Self {
            self.layers = input;
            self
        }
        /// Appends an item to `failures`.
        ///
        /// To override the contents of this collection use [`set_failures`](Self::set_failures).
        ///
        /// <p>Any failures associated with the call.</p>
        pub fn failures(mut self, input: impl Into<crate::model::LayerFailure>) -> Self {
            let mut v = self.failures.unwrap_or_default();
            v.push(input.into());
            self.failures = Some(v);
            self
        }
        /// <p>Any failures associated with the call.</p>
        pub fn set_failures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LayerFailure>>,
        ) -> Self {
            self.failures = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCheckLayerAvailabilityOutput`](crate::output::BatchCheckLayerAvailabilityOutput)
        pub fn build(self) -> crate::output::BatchCheckLayerAvailabilityOutput {
            crate::output::BatchCheckLayerAvailabilityOutput {
                layers: self.layers,
                failures: self.failures,
            }
        }
    }
}
impl BatchCheckLayerAvailabilityOutput {
    /// Creates a new builder-style object to manufacture [`BatchCheckLayerAvailabilityOutput`](crate::output::BatchCheckLayerAvailabilityOutput)
    pub fn builder() -> crate::output::batch_check_layer_availability_output::Builder {
        crate::output::batch_check_layer_availability_output::Builder::default()
    }
}
