// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchCheckLayerAvailability` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchCheckLayerAvailabilityError {
    /// Kind of error that occurred.
    pub kind: BatchCheckLayerAvailabilityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchCheckLayerAvailability` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchCheckLayerAvailabilityErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchCheckLayerAvailabilityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchCheckLayerAvailabilityErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            BatchCheckLayerAvailabilityErrorKind::RepositoryNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            BatchCheckLayerAvailabilityErrorKind::ServerException(_inner) => _inner.fmt(f),
            BatchCheckLayerAvailabilityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchCheckLayerAvailabilityError {
    fn code(&self) -> Option<&str> {
        BatchCheckLayerAvailabilityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchCheckLayerAvailabilityError {
    /// Creates a new `BatchCheckLayerAvailabilityError`.
    pub fn new(kind: BatchCheckLayerAvailabilityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchCheckLayerAvailabilityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchCheckLayerAvailabilityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchCheckLayerAvailabilityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchCheckLayerAvailabilityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchCheckLayerAvailabilityErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCheckLayerAvailabilityErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCheckLayerAvailabilityErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCheckLayerAvailabilityErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCheckLayerAvailabilityErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCheckLayerAvailabilityErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for BatchCheckLayerAvailabilityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchCheckLayerAvailabilityErrorKind::InvalidParameterException(_inner) => Some(_inner),
            BatchCheckLayerAvailabilityErrorKind::RepositoryNotFoundException(_inner) => {
                Some(_inner)
            }
            BatchCheckLayerAvailabilityErrorKind::ServerException(_inner) => Some(_inner),
            BatchCheckLayerAvailabilityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDeleteImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDeleteImageError {
    /// Kind of error that occurred.
    pub kind: BatchDeleteImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDeleteImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDeleteImageErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDeleteImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDeleteImageErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            BatchDeleteImageErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            BatchDeleteImageErrorKind::ServerException(_inner) => _inner.fmt(f),
            BatchDeleteImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDeleteImageError {
    fn code(&self) -> Option<&str> {
        BatchDeleteImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDeleteImageError {
    /// Creates a new `BatchDeleteImageError`.
    pub fn new(kind: BatchDeleteImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDeleteImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDeleteImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDeleteImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDeleteImageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDeleteImageErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteImageErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteImageErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteImageErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteImageErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, BatchDeleteImageErrorKind::ServerException(_))
    }
}
impl std::error::Error for BatchDeleteImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDeleteImageErrorKind::InvalidParameterException(_inner) => Some(_inner),
            BatchDeleteImageErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            BatchDeleteImageErrorKind::ServerException(_inner) => Some(_inner),
            BatchDeleteImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetImageError {
    /// Kind of error that occurred.
    pub kind: BatchGetImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetImageErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetImageErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            BatchGetImageErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            BatchGetImageErrorKind::ServerException(_inner) => _inner.fmt(f),
            BatchGetImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetImageError {
    fn code(&self) -> Option<&str> {
        BatchGetImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetImageError {
    /// Creates a new `BatchGetImageError`.
    pub fn new(kind: BatchGetImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetImageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetImageErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetImageErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetImageErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetImageErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetImageErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, BatchGetImageErrorKind::ServerException(_))
    }
}
impl std::error::Error for BatchGetImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetImageErrorKind::InvalidParameterException(_inner) => Some(_inner),
            BatchGetImageErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            BatchGetImageErrorKind::ServerException(_inner) => Some(_inner),
            BatchGetImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetRepositoryScanningConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetRepositoryScanningConfigurationError {
    /// Kind of error that occurred.
    pub kind: BatchGetRepositoryScanningConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetRepositoryScanningConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetRepositoryScanningConfigurationErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>There was an exception validating this request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetRepositoryScanningConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetRepositoryScanningConfigurationErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            BatchGetRepositoryScanningConfigurationErrorKind::RepositoryNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            BatchGetRepositoryScanningConfigurationErrorKind::ServerException(_inner) => {
                _inner.fmt(f)
            }
            BatchGetRepositoryScanningConfigurationErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            BatchGetRepositoryScanningConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetRepositoryScanningConfigurationError {
    fn code(&self) -> Option<&str> {
        BatchGetRepositoryScanningConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetRepositoryScanningConfigurationError {
    /// Creates a new `BatchGetRepositoryScanningConfigurationError`.
    pub fn new(
        kind: BatchGetRepositoryScanningConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetRepositoryScanningConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetRepositoryScanningConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetRepositoryScanningConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetRepositoryScanningConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetRepositoryScanningConfigurationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetRepositoryScanningConfigurationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetRepositoryScanningConfigurationErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetRepositoryScanningConfigurationErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetRepositoryScanningConfigurationErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetRepositoryScanningConfigurationErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetRepositoryScanningConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetRepositoryScanningConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchGetRepositoryScanningConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetRepositoryScanningConfigurationErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            BatchGetRepositoryScanningConfigurationErrorKind::RepositoryNotFoundException(
                _inner,
            ) => Some(_inner),
            BatchGetRepositoryScanningConfigurationErrorKind::ServerException(_inner) => {
                Some(_inner)
            }
            BatchGetRepositoryScanningConfigurationErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            BatchGetRepositoryScanningConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CompleteLayerUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CompleteLayerUploadError {
    /// Kind of error that occurred.
    pub kind: CompleteLayerUploadErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CompleteLayerUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CompleteLayerUploadErrorKind {
    /// <p>The specified layer upload does not contain any layer parts.</p>
    EmptyUploadException(crate::error::EmptyUploadException),
    /// <p>The layer digest calculation performed by Amazon ECR upon receipt of the image layer does
    /// not match the digest specified.</p>
    InvalidLayerException(crate::error::InvalidLayerException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The operation failed due to a KMS exception.</p>
    KmsException(crate::error::KmsException),
    /// <p>The image layer already exists in the associated repository.</p>
    LayerAlreadyExistsException(crate::error::LayerAlreadyExistsException),
    /// <p>Layer parts must be at least 5 MiB in size.</p>
    LayerPartTooSmallException(crate::error::LayerPartTooSmallException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The upload could not be found, or the specified upload ID is not valid for this
    /// repository.</p>
    UploadNotFoundException(crate::error::UploadNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CompleteLayerUploadError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CompleteLayerUploadErrorKind::EmptyUploadException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::InvalidLayerException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::KmsException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::LayerAlreadyExistsException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::LayerPartTooSmallException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::ServerException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::UploadNotFoundException(_inner) => _inner.fmt(f),
            CompleteLayerUploadErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CompleteLayerUploadError {
    fn code(&self) -> Option<&str> {
        CompleteLayerUploadError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CompleteLayerUploadError {
    /// Creates a new `CompleteLayerUploadError`.
    pub fn new(kind: CompleteLayerUploadErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CompleteLayerUploadError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CompleteLayerUploadErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CompleteLayerUploadError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CompleteLayerUploadErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::EmptyUploadException`.
    pub fn is_empty_upload_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteLayerUploadErrorKind::EmptyUploadException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::InvalidLayerException`.
    pub fn is_invalid_layer_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteLayerUploadErrorKind::InvalidLayerException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteLayerUploadErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::KmsException`.
    pub fn is_kms_exception(&self) -> bool {
        matches!(&self.kind, CompleteLayerUploadErrorKind::KmsException(_))
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::LayerAlreadyExistsException`.
    pub fn is_layer_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteLayerUploadErrorKind::LayerAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::LayerPartTooSmallException`.
    pub fn is_layer_part_too_small_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteLayerUploadErrorKind::LayerPartTooSmallException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteLayerUploadErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, CompleteLayerUploadErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `CompleteLayerUploadErrorKind::UploadNotFoundException`.
    pub fn is_upload_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CompleteLayerUploadErrorKind::UploadNotFoundException(_)
        )
    }
}
impl std::error::Error for CompleteLayerUploadError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CompleteLayerUploadErrorKind::EmptyUploadException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::InvalidLayerException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::KmsException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::LayerAlreadyExistsException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::LayerPartTooSmallException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::ServerException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::UploadNotFoundException(_inner) => Some(_inner),
            CompleteLayerUploadErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePullThroughCacheRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePullThroughCacheRuleError {
    /// Kind of error that occurred.
    pub kind: CreatePullThroughCacheRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePullThroughCacheRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePullThroughCacheRuleErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The operation did not succeed because it would have exceeded a service limit for your
    /// account. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service quotas</a> in
    /// the Amazon Elastic Container Registry User Guide.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A pull through cache rule with these settings already exists for the private
    /// registry.</p>
    PullThroughCacheRuleAlreadyExistsException(
        crate::error::PullThroughCacheRuleAlreadyExistsException,
    ),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The specified upstream registry isn't supported.</p>
    UnsupportedUpstreamRegistryException(crate::error::UnsupportedUpstreamRegistryException),
    /// <p>There was an exception validating this request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePullThroughCacheRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePullThroughCacheRuleErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreatePullThroughCacheRuleErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreatePullThroughCacheRuleErrorKind::PullThroughCacheRuleAlreadyExistsException(
                _inner,
            ) => _inner.fmt(f),
            CreatePullThroughCacheRuleErrorKind::ServerException(_inner) => _inner.fmt(f),
            CreatePullThroughCacheRuleErrorKind::UnsupportedUpstreamRegistryException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullThroughCacheRuleErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreatePullThroughCacheRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePullThroughCacheRuleError {
    fn code(&self) -> Option<&str> {
        CreatePullThroughCacheRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePullThroughCacheRuleError {
    /// Creates a new `CreatePullThroughCacheRuleError`.
    pub fn new(kind: CreatePullThroughCacheRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePullThroughCacheRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePullThroughCacheRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePullThroughCacheRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePullThroughCacheRuleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePullThroughCacheRuleErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullThroughCacheRuleErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullThroughCacheRuleErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullThroughCacheRuleErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullThroughCacheRuleErrorKind::PullThroughCacheRuleAlreadyExistsException`.
    pub fn is_pull_through_cache_rule_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullThroughCacheRuleErrorKind::PullThroughCacheRuleAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullThroughCacheRuleErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullThroughCacheRuleErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullThroughCacheRuleErrorKind::UnsupportedUpstreamRegistryException`.
    pub fn is_unsupported_upstream_registry_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullThroughCacheRuleErrorKind::UnsupportedUpstreamRegistryException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullThroughCacheRuleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullThroughCacheRuleErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreatePullThroughCacheRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePullThroughCacheRuleErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreatePullThroughCacheRuleErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreatePullThroughCacheRuleErrorKind::PullThroughCacheRuleAlreadyExistsException(
                _inner,
            ) => Some(_inner),
            CreatePullThroughCacheRuleErrorKind::ServerException(_inner) => Some(_inner),
            CreatePullThroughCacheRuleErrorKind::UnsupportedUpstreamRegistryException(_inner) => {
                Some(_inner)
            }
            CreatePullThroughCacheRuleErrorKind::ValidationException(_inner) => Some(_inner),
            CreatePullThroughCacheRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRepositoryError {
    /// Kind of error that occurred.
    pub kind: CreateRepositoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRepositoryErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters, and tag values can have
    /// a maximum length of 256 characters.</p>
    InvalidTagParameterException(crate::error::InvalidTagParameterException),
    /// <p>The operation failed due to a KMS exception.</p>
    KmsException(crate::error::KmsException),
    /// <p>The operation did not succeed because it would have exceeded a service limit for your
    /// account. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service quotas</a> in
    /// the Amazon Elastic Container Registry User Guide.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified repository already exists in the specified registry.</p>
    RepositoryAlreadyExistsException(crate::error::RepositoryAlreadyExistsException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The list of tags on the repository is over the limit. The maximum number of tags that
    /// can be applied to a repository is 50.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRepositoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRepositoryErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::InvalidTagParameterException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::KmsException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::RepositoryAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::ServerException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRepositoryError {
    fn code(&self) -> Option<&str> {
        CreateRepositoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRepositoryError {
    /// Creates a new `CreateRepositoryError`.
    pub fn new(kind: CreateRepositoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRepositoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRepositoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRepositoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRepositoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::InvalidTagParameterException`.
    pub fn is_invalid_tag_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::InvalidTagParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::KmsException`.
    pub fn is_kms_exception(&self) -> bool {
        matches!(&self.kind, CreateRepositoryErrorKind::KmsException(_))
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::RepositoryAlreadyExistsException`.
    pub fn is_repository_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::RepositoryAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, CreateRepositoryErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreateRepositoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRepositoryErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::InvalidTagParameterException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::KmsException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::RepositoryAlreadyExistsException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::ServerException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLifecyclePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLifecyclePolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteLifecyclePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLifecyclePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLifecyclePolicyErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The lifecycle policy could not be found, and no policy is set to the
    /// repository.</p>
    LifecyclePolicyNotFoundException(crate::error::LifecyclePolicyNotFoundException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLifecyclePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLifecyclePolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteLifecyclePolicyErrorKind::LifecyclePolicyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLifecyclePolicyErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            DeleteLifecyclePolicyErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeleteLifecyclePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLifecyclePolicyError {
    fn code(&self) -> Option<&str> {
        DeleteLifecyclePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLifecyclePolicyError {
    /// Creates a new `DeleteLifecyclePolicyError`.
    pub fn new(kind: DeleteLifecyclePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLifecyclePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLifecyclePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLifecyclePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLifecyclePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLifecyclePolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLifecyclePolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLifecyclePolicyErrorKind::LifecyclePolicyNotFoundException`.
    pub fn is_lifecycle_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLifecyclePolicyErrorKind::LifecyclePolicyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLifecyclePolicyErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLifecyclePolicyErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLifecyclePolicyErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLifecyclePolicyErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DeleteLifecyclePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLifecyclePolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteLifecyclePolicyErrorKind::LifecyclePolicyNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteLifecyclePolicyErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            DeleteLifecyclePolicyErrorKind::ServerException(_inner) => Some(_inner),
            DeleteLifecyclePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePullThroughCacheRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePullThroughCacheRuleError {
    /// Kind of error that occurred.
    pub kind: DeletePullThroughCacheRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePullThroughCacheRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePullThroughCacheRuleErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The pull through cache rule was not found. Specify a valid pull through cache rule and
    /// try again.</p>
    PullThroughCacheRuleNotFoundException(crate::error::PullThroughCacheRuleNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>There was an exception validating this request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePullThroughCacheRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePullThroughCacheRuleErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeletePullThroughCacheRuleErrorKind::PullThroughCacheRuleNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeletePullThroughCacheRuleErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeletePullThroughCacheRuleErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeletePullThroughCacheRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePullThroughCacheRuleError {
    fn code(&self) -> Option<&str> {
        DeletePullThroughCacheRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePullThroughCacheRuleError {
    /// Creates a new `DeletePullThroughCacheRuleError`.
    pub fn new(kind: DeletePullThroughCacheRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePullThroughCacheRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePullThroughCacheRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePullThroughCacheRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePullThroughCacheRuleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePullThroughCacheRuleErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePullThroughCacheRuleErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePullThroughCacheRuleErrorKind::PullThroughCacheRuleNotFoundException`.
    pub fn is_pull_through_cache_rule_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePullThroughCacheRuleErrorKind::PullThroughCacheRuleNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePullThroughCacheRuleErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePullThroughCacheRuleErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePullThroughCacheRuleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePullThroughCacheRuleErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeletePullThroughCacheRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePullThroughCacheRuleErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeletePullThroughCacheRuleErrorKind::PullThroughCacheRuleNotFoundException(_inner) => {
                Some(_inner)
            }
            DeletePullThroughCacheRuleErrorKind::ServerException(_inner) => Some(_inner),
            DeletePullThroughCacheRuleErrorKind::ValidationException(_inner) => Some(_inner),
            DeletePullThroughCacheRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRegistryPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRegistryPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteRegistryPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRegistryPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRegistryPolicyErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The registry doesn't have an associated registry policy.</p>
    RegistryPolicyNotFoundException(crate::error::RegistryPolicyNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>There was an exception validating this request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRegistryPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRegistryPolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteRegistryPolicyErrorKind::RegistryPolicyNotFoundException(_inner) => _inner.fmt(f),
            DeleteRegistryPolicyErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeleteRegistryPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteRegistryPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRegistryPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteRegistryPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRegistryPolicyError {
    /// Creates a new `DeleteRegistryPolicyError`.
    pub fn new(kind: DeleteRegistryPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRegistryPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRegistryPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRegistryPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRegistryPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRegistryPolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegistryPolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegistryPolicyErrorKind::RegistryPolicyNotFoundException`.
    pub fn is_registry_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegistryPolicyErrorKind::RegistryPolicyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegistryPolicyErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegistryPolicyErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRegistryPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRegistryPolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteRegistryPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRegistryPolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteRegistryPolicyErrorKind::RegistryPolicyNotFoundException(_inner) => Some(_inner),
            DeleteRegistryPolicyErrorKind::ServerException(_inner) => Some(_inner),
            DeleteRegistryPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteRegistryPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRepositoryError {
    /// Kind of error that occurred.
    pub kind: DeleteRepositoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRepositoryErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The operation failed due to a KMS exception.</p>
    KmsException(crate::error::KmsException),
    /// <p>The specified repository contains images. To delete a repository that contains images,
    /// you must force the deletion with the <code>force</code> parameter.</p>
    RepositoryNotEmptyException(crate::error::RepositoryNotEmptyException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRepositoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRepositoryErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::KmsException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::RepositoryNotEmptyException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRepositoryError {
    fn code(&self) -> Option<&str> {
        DeleteRepositoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRepositoryError {
    /// Creates a new `DeleteRepositoryError`.
    pub fn new(kind: DeleteRepositoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRepositoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRepositoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRepositoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRepositoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::KmsException`.
    pub fn is_kms_exception(&self) -> bool {
        matches!(&self.kind, DeleteRepositoryErrorKind::KmsException(_))
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::RepositoryNotEmptyException`.
    pub fn is_repository_not_empty_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::RepositoryNotEmptyException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteRepositoryErrorKind::ServerException(_))
    }
}
impl std::error::Error for DeleteRepositoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRepositoryErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::KmsException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::RepositoryNotEmptyException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::ServerException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRepositoryPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRepositoryPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteRepositoryPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRepositoryPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRepositoryPolicyErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>The specified repository and registry combination does not have an associated
    /// repository policy.</p>
    RepositoryPolicyNotFoundException(crate::error::RepositoryPolicyNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRepositoryPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRepositoryPolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteRepositoryPolicyErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            DeleteRepositoryPolicyErrorKind::RepositoryPolicyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRepositoryPolicyErrorKind::ServerException(_inner) => _inner.fmt(f),
            DeleteRepositoryPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRepositoryPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteRepositoryPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRepositoryPolicyError {
    /// Creates a new `DeleteRepositoryPolicyError`.
    pub fn new(kind: DeleteRepositoryPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRepositoryPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRepositoryPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRepositoryPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRepositoryPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRepositoryPolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryPolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryPolicyErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryPolicyErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryPolicyErrorKind::RepositoryPolicyNotFoundException`.
    pub fn is_repository_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryPolicyErrorKind::RepositoryPolicyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryPolicyErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryPolicyErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DeleteRepositoryPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRepositoryPolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteRepositoryPolicyErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            DeleteRepositoryPolicyErrorKind::RepositoryPolicyNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteRepositoryPolicyErrorKind::ServerException(_inner) => Some(_inner),
            DeleteRepositoryPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeImageReplicationStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeImageReplicationStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeImageReplicationStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeImageReplicationStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeImageReplicationStatusErrorKind {
    /// <p>The image requested does not exist in the specified repository.</p>
    ImageNotFoundException(crate::error::ImageNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>There was an exception validating this request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeImageReplicationStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeImageReplicationStatusErrorKind::ImageNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeImageReplicationStatusErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DescribeImageReplicationStatusErrorKind::RepositoryNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeImageReplicationStatusErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeImageReplicationStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeImageReplicationStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeImageReplicationStatusError {
    fn code(&self) -> Option<&str> {
        DescribeImageReplicationStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeImageReplicationStatusError {
    /// Creates a new `DescribeImageReplicationStatusError`.
    pub fn new(
        kind: DescribeImageReplicationStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeImageReplicationStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeImageReplicationStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeImageReplicationStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeImageReplicationStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeImageReplicationStatusErrorKind::ImageNotFoundException`.
    pub fn is_image_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImageReplicationStatusErrorKind::ImageNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImageReplicationStatusErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImageReplicationStatusErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImageReplicationStatusErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImageReplicationStatusErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImageReplicationStatusErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImageReplicationStatusErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImageReplicationStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImageReplicationStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeImageReplicationStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeImageReplicationStatusErrorKind::ImageNotFoundException(_inner) => Some(_inner),
            DescribeImageReplicationStatusErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DescribeImageReplicationStatusErrorKind::RepositoryNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeImageReplicationStatusErrorKind::ServerException(_inner) => Some(_inner),
            DescribeImageReplicationStatusErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeImageReplicationStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeImages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeImagesError {
    /// Kind of error that occurred.
    pub kind: DescribeImagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeImages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeImagesErrorKind {
    /// <p>The image requested does not exist in the specified repository.</p>
    ImageNotFoundException(crate::error::ImageNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeImagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeImagesErrorKind::ImageNotFoundException(_inner) => _inner.fmt(f),
            DescribeImagesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeImagesErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            DescribeImagesErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeImagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeImagesError {
    fn code(&self) -> Option<&str> {
        DescribeImagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeImagesError {
    /// Creates a new `DescribeImagesError`.
    pub fn new(kind: DescribeImagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeImagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeImagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeImagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeImagesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeImagesErrorKind::ImageNotFoundException`.
    pub fn is_image_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImagesErrorKind::ImageNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImagesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImagesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImagesErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImagesErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImagesErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DescribeImagesErrorKind::ServerException(_))
    }
}
impl std::error::Error for DescribeImagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeImagesErrorKind::ImageNotFoundException(_inner) => Some(_inner),
            DescribeImagesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeImagesErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            DescribeImagesErrorKind::ServerException(_inner) => Some(_inner),
            DescribeImagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeImageScanFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeImageScanFindingsError {
    /// Kind of error that occurred.
    pub kind: DescribeImageScanFindingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeImageScanFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeImageScanFindingsErrorKind {
    /// <p>The image requested does not exist in the specified repository.</p>
    ImageNotFoundException(crate::error::ImageNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>The specified image scan could not be found. Ensure that image scanning is enabled on
    /// the repository and try again.</p>
    ScanNotFoundException(crate::error::ScanNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>There was an exception validating this request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeImageScanFindingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeImageScanFindingsErrorKind::ImageNotFoundException(_inner) => _inner.fmt(f),
            DescribeImageScanFindingsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeImageScanFindingsErrorKind::RepositoryNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeImageScanFindingsErrorKind::ScanNotFoundException(_inner) => _inner.fmt(f),
            DescribeImageScanFindingsErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeImageScanFindingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeImageScanFindingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeImageScanFindingsError {
    fn code(&self) -> Option<&str> {
        DescribeImageScanFindingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeImageScanFindingsError {
    /// Creates a new `DescribeImageScanFindingsError`.
    pub fn new(kind: DescribeImageScanFindingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeImageScanFindingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeImageScanFindingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeImageScanFindingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeImageScanFindingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeImageScanFindingsErrorKind::ImageNotFoundException`.
    pub fn is_image_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImageScanFindingsErrorKind::ImageNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImageScanFindingsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImageScanFindingsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImageScanFindingsErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImageScanFindingsErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImageScanFindingsErrorKind::ScanNotFoundException`.
    pub fn is_scan_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImageScanFindingsErrorKind::ScanNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImageScanFindingsErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImageScanFindingsErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImageScanFindingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImageScanFindingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeImageScanFindingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeImageScanFindingsErrorKind::ImageNotFoundException(_inner) => Some(_inner),
            DescribeImageScanFindingsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeImageScanFindingsErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            DescribeImageScanFindingsErrorKind::ScanNotFoundException(_inner) => Some(_inner),
            DescribeImageScanFindingsErrorKind::ServerException(_inner) => Some(_inner),
            DescribeImageScanFindingsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeImageScanFindingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePullThroughCacheRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePullThroughCacheRulesError {
    /// Kind of error that occurred.
    pub kind: DescribePullThroughCacheRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePullThroughCacheRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePullThroughCacheRulesErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The pull through cache rule was not found. Specify a valid pull through cache rule and
    /// try again.</p>
    PullThroughCacheRuleNotFoundException(crate::error::PullThroughCacheRuleNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>There was an exception validating this request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePullThroughCacheRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePullThroughCacheRulesErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DescribePullThroughCacheRulesErrorKind::PullThroughCacheRuleNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            DescribePullThroughCacheRulesErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribePullThroughCacheRulesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribePullThroughCacheRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePullThroughCacheRulesError {
    fn code(&self) -> Option<&str> {
        DescribePullThroughCacheRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePullThroughCacheRulesError {
    /// Creates a new `DescribePullThroughCacheRulesError`.
    pub fn new(
        kind: DescribePullThroughCacheRulesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePullThroughCacheRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePullThroughCacheRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePullThroughCacheRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePullThroughCacheRulesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePullThroughCacheRulesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePullThroughCacheRulesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePullThroughCacheRulesErrorKind::PullThroughCacheRuleNotFoundException`.
    pub fn is_pull_through_cache_rule_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePullThroughCacheRulesErrorKind::PullThroughCacheRuleNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePullThroughCacheRulesErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePullThroughCacheRulesErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePullThroughCacheRulesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePullThroughCacheRulesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribePullThroughCacheRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePullThroughCacheRulesErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DescribePullThroughCacheRulesErrorKind::PullThroughCacheRuleNotFoundException(
                _inner,
            ) => Some(_inner),
            DescribePullThroughCacheRulesErrorKind::ServerException(_inner) => Some(_inner),
            DescribePullThroughCacheRulesErrorKind::ValidationException(_inner) => Some(_inner),
            DescribePullThroughCacheRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRegistry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRegistryError {
    /// Kind of error that occurred.
    pub kind: DescribeRegistryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRegistry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRegistryErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>There was an exception validating this request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRegistryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRegistryErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeRegistryErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeRegistryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeRegistryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRegistryError {
    fn code(&self) -> Option<&str> {
        DescribeRegistryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRegistryError {
    /// Creates a new `DescribeRegistryError`.
    pub fn new(kind: DescribeRegistryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRegistryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRegistryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRegistryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRegistryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRegistryErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRegistryErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRegistryErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, DescribeRegistryErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `DescribeRegistryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRegistryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeRegistryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRegistryErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeRegistryErrorKind::ServerException(_inner) => Some(_inner),
            DescribeRegistryErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeRegistryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRepositories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRepositoriesError {
    /// Kind of error that occurred.
    pub kind: DescribeRepositoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRepositories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRepositoriesErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRepositoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRepositoriesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeRepositoriesErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            DescribeRepositoriesErrorKind::ServerException(_inner) => _inner.fmt(f),
            DescribeRepositoriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRepositoriesError {
    fn code(&self) -> Option<&str> {
        DescribeRepositoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRepositoriesError {
    /// Creates a new `DescribeRepositoriesError`.
    pub fn new(kind: DescribeRepositoriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRepositoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRepositoriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRepositoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRepositoriesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRepositoriesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRepositoriesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRepositoriesErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRepositoriesErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRepositoriesErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRepositoriesErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for DescribeRepositoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRepositoriesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeRepositoriesErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            DescribeRepositoriesErrorKind::ServerException(_inner) => Some(_inner),
            DescribeRepositoriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAuthorizationToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAuthorizationTokenError {
    /// Kind of error that occurred.
    pub kind: GetAuthorizationTokenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAuthorizationToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAuthorizationTokenErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAuthorizationTokenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAuthorizationTokenErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetAuthorizationTokenErrorKind::ServerException(_inner) => _inner.fmt(f),
            GetAuthorizationTokenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAuthorizationTokenError {
    fn code(&self) -> Option<&str> {
        GetAuthorizationTokenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAuthorizationTokenError {
    /// Creates a new `GetAuthorizationTokenError`.
    pub fn new(kind: GetAuthorizationTokenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAuthorizationTokenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAuthorizationTokenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAuthorizationTokenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAuthorizationTokenErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAuthorizationTokenErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAuthorizationTokenErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAuthorizationTokenErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAuthorizationTokenErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for GetAuthorizationTokenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAuthorizationTokenErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetAuthorizationTokenErrorKind::ServerException(_inner) => Some(_inner),
            GetAuthorizationTokenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDownloadUrlForLayer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDownloadUrlForLayerError {
    /// Kind of error that occurred.
    pub kind: GetDownloadUrlForLayerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDownloadUrlForLayer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDownloadUrlForLayerErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified layer is not available because it is not associated with an image.
    /// Unassociated image layers may be cleaned up at any time.</p>
    LayerInaccessibleException(crate::error::LayerInaccessibleException),
    /// <p>The specified layers could not be found, or the specified layer is not valid for this
    /// repository.</p>
    LayersNotFoundException(crate::error::LayersNotFoundException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDownloadUrlForLayerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDownloadUrlForLayerErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetDownloadUrlForLayerErrorKind::LayerInaccessibleException(_inner) => _inner.fmt(f),
            GetDownloadUrlForLayerErrorKind::LayersNotFoundException(_inner) => _inner.fmt(f),
            GetDownloadUrlForLayerErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            GetDownloadUrlForLayerErrorKind::ServerException(_inner) => _inner.fmt(f),
            GetDownloadUrlForLayerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDownloadUrlForLayerError {
    fn code(&self) -> Option<&str> {
        GetDownloadUrlForLayerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDownloadUrlForLayerError {
    /// Creates a new `GetDownloadUrlForLayerError`.
    pub fn new(kind: GetDownloadUrlForLayerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDownloadUrlForLayerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDownloadUrlForLayerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDownloadUrlForLayerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDownloadUrlForLayerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDownloadUrlForLayerErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDownloadUrlForLayerErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDownloadUrlForLayerErrorKind::LayerInaccessibleException`.
    pub fn is_layer_inaccessible_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDownloadUrlForLayerErrorKind::LayerInaccessibleException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDownloadUrlForLayerErrorKind::LayersNotFoundException`.
    pub fn is_layers_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDownloadUrlForLayerErrorKind::LayersNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDownloadUrlForLayerErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDownloadUrlForLayerErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDownloadUrlForLayerErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDownloadUrlForLayerErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for GetDownloadUrlForLayerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDownloadUrlForLayerErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetDownloadUrlForLayerErrorKind::LayerInaccessibleException(_inner) => Some(_inner),
            GetDownloadUrlForLayerErrorKind::LayersNotFoundException(_inner) => Some(_inner),
            GetDownloadUrlForLayerErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            GetDownloadUrlForLayerErrorKind::ServerException(_inner) => Some(_inner),
            GetDownloadUrlForLayerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLifecyclePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLifecyclePolicyError {
    /// Kind of error that occurred.
    pub kind: GetLifecyclePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLifecyclePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLifecyclePolicyErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The lifecycle policy could not be found, and no policy is set to the
    /// repository.</p>
    LifecyclePolicyNotFoundException(crate::error::LifecyclePolicyNotFoundException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLifecyclePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLifecyclePolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetLifecyclePolicyErrorKind::LifecyclePolicyNotFoundException(_inner) => _inner.fmt(f),
            GetLifecyclePolicyErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            GetLifecyclePolicyErrorKind::ServerException(_inner) => _inner.fmt(f),
            GetLifecyclePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLifecyclePolicyError {
    fn code(&self) -> Option<&str> {
        GetLifecyclePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLifecyclePolicyError {
    /// Creates a new `GetLifecyclePolicyError`.
    pub fn new(kind: GetLifecyclePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLifecyclePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLifecyclePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLifecyclePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLifecyclePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLifecyclePolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLifecyclePolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLifecyclePolicyErrorKind::LifecyclePolicyNotFoundException`.
    pub fn is_lifecycle_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLifecyclePolicyErrorKind::LifecyclePolicyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLifecyclePolicyErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLifecyclePolicyErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLifecyclePolicyErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, GetLifecyclePolicyErrorKind::ServerException(_))
    }
}
impl std::error::Error for GetLifecyclePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLifecyclePolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetLifecyclePolicyErrorKind::LifecyclePolicyNotFoundException(_inner) => Some(_inner),
            GetLifecyclePolicyErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            GetLifecyclePolicyErrorKind::ServerException(_inner) => Some(_inner),
            GetLifecyclePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLifecyclePolicyPreview` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLifecyclePolicyPreviewError {
    /// Kind of error that occurred.
    pub kind: GetLifecyclePolicyPreviewErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLifecyclePolicyPreview` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLifecyclePolicyPreviewErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>There is no dry run for this repository.</p>
    LifecyclePolicyPreviewNotFoundException(crate::error::LifecyclePolicyPreviewNotFoundException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLifecyclePolicyPreviewError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLifecyclePolicyPreviewErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetLifecyclePolicyPreviewErrorKind::LifecyclePolicyPreviewNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetLifecyclePolicyPreviewErrorKind::RepositoryNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetLifecyclePolicyPreviewErrorKind::ServerException(_inner) => _inner.fmt(f),
            GetLifecyclePolicyPreviewErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLifecyclePolicyPreviewError {
    fn code(&self) -> Option<&str> {
        GetLifecyclePolicyPreviewError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLifecyclePolicyPreviewError {
    /// Creates a new `GetLifecyclePolicyPreviewError`.
    pub fn new(kind: GetLifecyclePolicyPreviewErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLifecyclePolicyPreviewError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLifecyclePolicyPreviewErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLifecyclePolicyPreviewError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLifecyclePolicyPreviewErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLifecyclePolicyPreviewErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLifecyclePolicyPreviewErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLifecyclePolicyPreviewErrorKind::LifecyclePolicyPreviewNotFoundException`.
    pub fn is_lifecycle_policy_preview_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLifecyclePolicyPreviewErrorKind::LifecyclePolicyPreviewNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLifecyclePolicyPreviewErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLifecyclePolicyPreviewErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLifecyclePolicyPreviewErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLifecyclePolicyPreviewErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for GetLifecyclePolicyPreviewError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLifecyclePolicyPreviewErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetLifecyclePolicyPreviewErrorKind::LifecyclePolicyPreviewNotFoundException(_inner) => {
                Some(_inner)
            }
            GetLifecyclePolicyPreviewErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            GetLifecyclePolicyPreviewErrorKind::ServerException(_inner) => Some(_inner),
            GetLifecyclePolicyPreviewErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRegistryPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRegistryPolicyError {
    /// Kind of error that occurred.
    pub kind: GetRegistryPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRegistryPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRegistryPolicyErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The registry doesn't have an associated registry policy.</p>
    RegistryPolicyNotFoundException(crate::error::RegistryPolicyNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>There was an exception validating this request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRegistryPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRegistryPolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetRegistryPolicyErrorKind::RegistryPolicyNotFoundException(_inner) => _inner.fmt(f),
            GetRegistryPolicyErrorKind::ServerException(_inner) => _inner.fmt(f),
            GetRegistryPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetRegistryPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRegistryPolicyError {
    fn code(&self) -> Option<&str> {
        GetRegistryPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRegistryPolicyError {
    /// Creates a new `GetRegistryPolicyError`.
    pub fn new(kind: GetRegistryPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRegistryPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRegistryPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRegistryPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRegistryPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRegistryPolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegistryPolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegistryPolicyErrorKind::RegistryPolicyNotFoundException`.
    pub fn is_registry_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegistryPolicyErrorKind::RegistryPolicyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegistryPolicyErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, GetRegistryPolicyErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `GetRegistryPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegistryPolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetRegistryPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRegistryPolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetRegistryPolicyErrorKind::RegistryPolicyNotFoundException(_inner) => Some(_inner),
            GetRegistryPolicyErrorKind::ServerException(_inner) => Some(_inner),
            GetRegistryPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            GetRegistryPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRegistryScanningConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRegistryScanningConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetRegistryScanningConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRegistryScanningConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRegistryScanningConfigurationErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>There was an exception validating this request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRegistryScanningConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRegistryScanningConfigurationErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            GetRegistryScanningConfigurationErrorKind::ServerException(_inner) => _inner.fmt(f),
            GetRegistryScanningConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetRegistryScanningConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRegistryScanningConfigurationError {
    fn code(&self) -> Option<&str> {
        GetRegistryScanningConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRegistryScanningConfigurationError {
    /// Creates a new `GetRegistryScanningConfigurationError`.
    pub fn new(
        kind: GetRegistryScanningConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRegistryScanningConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRegistryScanningConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRegistryScanningConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRegistryScanningConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRegistryScanningConfigurationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegistryScanningConfigurationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegistryScanningConfigurationErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegistryScanningConfigurationErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegistryScanningConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegistryScanningConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetRegistryScanningConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRegistryScanningConfigurationErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            GetRegistryScanningConfigurationErrorKind::ServerException(_inner) => Some(_inner),
            GetRegistryScanningConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            GetRegistryScanningConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRepositoryPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRepositoryPolicyError {
    /// Kind of error that occurred.
    pub kind: GetRepositoryPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRepositoryPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRepositoryPolicyErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>The specified repository and registry combination does not have an associated
    /// repository policy.</p>
    RepositoryPolicyNotFoundException(crate::error::RepositoryPolicyNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRepositoryPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRepositoryPolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetRepositoryPolicyErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            GetRepositoryPolicyErrorKind::RepositoryPolicyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetRepositoryPolicyErrorKind::ServerException(_inner) => _inner.fmt(f),
            GetRepositoryPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRepositoryPolicyError {
    fn code(&self) -> Option<&str> {
        GetRepositoryPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRepositoryPolicyError {
    /// Creates a new `GetRepositoryPolicyError`.
    pub fn new(kind: GetRepositoryPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRepositoryPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRepositoryPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRepositoryPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRepositoryPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRepositoryPolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryPolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryPolicyErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryPolicyErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryPolicyErrorKind::RepositoryPolicyNotFoundException`.
    pub fn is_repository_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryPolicyErrorKind::RepositoryPolicyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryPolicyErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, GetRepositoryPolicyErrorKind::ServerException(_))
    }
}
impl std::error::Error for GetRepositoryPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRepositoryPolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetRepositoryPolicyErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            GetRepositoryPolicyErrorKind::RepositoryPolicyNotFoundException(_inner) => Some(_inner),
            GetRepositoryPolicyErrorKind::ServerException(_inner) => Some(_inner),
            GetRepositoryPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `InitiateLayerUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct InitiateLayerUploadError {
    /// Kind of error that occurred.
    pub kind: InitiateLayerUploadErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `InitiateLayerUpload` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum InitiateLayerUploadErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The operation failed due to a KMS exception.</p>
    KmsException(crate::error::KmsException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for InitiateLayerUploadError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            InitiateLayerUploadErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            InitiateLayerUploadErrorKind::KmsException(_inner) => _inner.fmt(f),
            InitiateLayerUploadErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            InitiateLayerUploadErrorKind::ServerException(_inner) => _inner.fmt(f),
            InitiateLayerUploadErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for InitiateLayerUploadError {
    fn code(&self) -> Option<&str> {
        InitiateLayerUploadError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl InitiateLayerUploadError {
    /// Creates a new `InitiateLayerUploadError`.
    pub fn new(kind: InitiateLayerUploadErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `InitiateLayerUploadError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: InitiateLayerUploadErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `InitiateLayerUploadError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: InitiateLayerUploadErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `InitiateLayerUploadErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateLayerUploadErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateLayerUploadErrorKind::KmsException`.
    pub fn is_kms_exception(&self) -> bool {
        matches!(&self.kind, InitiateLayerUploadErrorKind::KmsException(_))
    }
    /// Returns `true` if the error kind is `InitiateLayerUploadErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            InitiateLayerUploadErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `InitiateLayerUploadErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, InitiateLayerUploadErrorKind::ServerException(_))
    }
}
impl std::error::Error for InitiateLayerUploadError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            InitiateLayerUploadErrorKind::InvalidParameterException(_inner) => Some(_inner),
            InitiateLayerUploadErrorKind::KmsException(_inner) => Some(_inner),
            InitiateLayerUploadErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            InitiateLayerUploadErrorKind::ServerException(_inner) => Some(_inner),
            InitiateLayerUploadErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListImages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListImagesError {
    /// Kind of error that occurred.
    pub kind: ListImagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListImages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListImagesErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListImagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListImagesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListImagesErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            ListImagesErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListImagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListImagesError {
    fn code(&self) -> Option<&str> {
        ListImagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListImagesError {
    /// Creates a new `ListImagesError`.
    pub fn new(kind: ListImagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListImagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListImagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListImagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListImagesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListImagesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListImagesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListImagesErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListImagesErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListImagesErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, ListImagesErrorKind::ServerException(_))
    }
}
impl std::error::Error for ListImagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListImagesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListImagesErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            ListImagesErrorKind::ServerException(_inner) => Some(_inner),
            ListImagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, ListTagsForResourceErrorKind::ServerException(_))
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutImageError {
    /// Kind of error that occurred.
    pub kind: PutImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutImageErrorKind {
    /// <p>The specified image has already been pushed, and there were no changes to the manifest
    /// or image tag after the last push.</p>
    ImageAlreadyExistsException(crate::error::ImageAlreadyExistsException),
    /// <p>The specified image digest does not match the digest that Amazon ECR calculated for the
    /// image.</p>
    ImageDigestDoesNotMatchException(crate::error::ImageDigestDoesNotMatchException),
    /// <p>The specified image is tagged with a tag that already exists. The repository is
    /// configured for tag immutability.</p>
    ImageTagAlreadyExistsException(crate::error::ImageTagAlreadyExistsException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The operation failed due to a KMS exception.</p>
    KmsException(crate::error::KmsException),
    /// <p>The specified layers could not be found, or the specified layer is not valid for this
    /// repository.</p>
    LayersNotFoundException(crate::error::LayersNotFoundException),
    /// <p>The operation did not succeed because it would have exceeded a service limit for your
    /// account. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service quotas</a> in
    /// the Amazon Elastic Container Registry User Guide.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The manifest list is referencing an image that does not exist.</p>
    ReferencedImagesNotFoundException(crate::error::ReferencedImagesNotFoundException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutImageErrorKind::ImageAlreadyExistsException(_inner) => _inner.fmt(f),
            PutImageErrorKind::ImageDigestDoesNotMatchException(_inner) => _inner.fmt(f),
            PutImageErrorKind::ImageTagAlreadyExistsException(_inner) => _inner.fmt(f),
            PutImageErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutImageErrorKind::KmsException(_inner) => _inner.fmt(f),
            PutImageErrorKind::LayersNotFoundException(_inner) => _inner.fmt(f),
            PutImageErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutImageErrorKind::ReferencedImagesNotFoundException(_inner) => _inner.fmt(f),
            PutImageErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            PutImageErrorKind::ServerException(_inner) => _inner.fmt(f),
            PutImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutImageError {
    fn code(&self) -> Option<&str> {
        PutImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutImageError {
    /// Creates a new `PutImageError`.
    pub fn new(kind: PutImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutImageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::ImageAlreadyExistsException`.
    pub fn is_image_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutImageErrorKind::ImageAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::ImageDigestDoesNotMatchException`.
    pub fn is_image_digest_does_not_match_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutImageErrorKind::ImageDigestDoesNotMatchException(_)
        )
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::ImageTagAlreadyExistsException`.
    pub fn is_image_tag_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutImageErrorKind::ImageTagAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, PutImageErrorKind::InvalidParameterException(_))
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::KmsException`.
    pub fn is_kms_exception(&self) -> bool {
        matches!(&self.kind, PutImageErrorKind::KmsException(_))
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::LayersNotFoundException`.
    pub fn is_layers_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutImageErrorKind::LayersNotFoundException(_))
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PutImageErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::ReferencedImagesNotFoundException`.
    pub fn is_referenced_images_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutImageErrorKind::ReferencedImagesNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutImageErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutImageErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, PutImageErrorKind::ServerException(_))
    }
}
impl std::error::Error for PutImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutImageErrorKind::ImageAlreadyExistsException(_inner) => Some(_inner),
            PutImageErrorKind::ImageDigestDoesNotMatchException(_inner) => Some(_inner),
            PutImageErrorKind::ImageTagAlreadyExistsException(_inner) => Some(_inner),
            PutImageErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutImageErrorKind::KmsException(_inner) => Some(_inner),
            PutImageErrorKind::LayersNotFoundException(_inner) => Some(_inner),
            PutImageErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutImageErrorKind::ReferencedImagesNotFoundException(_inner) => Some(_inner),
            PutImageErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            PutImageErrorKind::ServerException(_inner) => Some(_inner),
            PutImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutImageScanningConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutImageScanningConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutImageScanningConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutImageScanningConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutImageScanningConfigurationErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>There was an exception validating this request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutImageScanningConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutImageScanningConfigurationErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            PutImageScanningConfigurationErrorKind::RepositoryNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            PutImageScanningConfigurationErrorKind::ServerException(_inner) => _inner.fmt(f),
            PutImageScanningConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutImageScanningConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutImageScanningConfigurationError {
    fn code(&self) -> Option<&str> {
        PutImageScanningConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutImageScanningConfigurationError {
    /// Creates a new `PutImageScanningConfigurationError`.
    pub fn new(
        kind: PutImageScanningConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutImageScanningConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutImageScanningConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutImageScanningConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutImageScanningConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutImageScanningConfigurationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutImageScanningConfigurationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutImageScanningConfigurationErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutImageScanningConfigurationErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutImageScanningConfigurationErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutImageScanningConfigurationErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutImageScanningConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutImageScanningConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutImageScanningConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutImageScanningConfigurationErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            PutImageScanningConfigurationErrorKind::RepositoryNotFoundException(_inner) => {
                Some(_inner)
            }
            PutImageScanningConfigurationErrorKind::ServerException(_inner) => Some(_inner),
            PutImageScanningConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            PutImageScanningConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutImageTagMutability` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutImageTagMutabilityError {
    /// Kind of error that occurred.
    pub kind: PutImageTagMutabilityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutImageTagMutability` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutImageTagMutabilityErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutImageTagMutabilityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutImageTagMutabilityErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutImageTagMutabilityErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            PutImageTagMutabilityErrorKind::ServerException(_inner) => _inner.fmt(f),
            PutImageTagMutabilityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutImageTagMutabilityError {
    fn code(&self) -> Option<&str> {
        PutImageTagMutabilityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutImageTagMutabilityError {
    /// Creates a new `PutImageTagMutabilityError`.
    pub fn new(kind: PutImageTagMutabilityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutImageTagMutabilityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutImageTagMutabilityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutImageTagMutabilityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutImageTagMutabilityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutImageTagMutabilityErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutImageTagMutabilityErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutImageTagMutabilityErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutImageTagMutabilityErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutImageTagMutabilityErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutImageTagMutabilityErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for PutImageTagMutabilityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutImageTagMutabilityErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutImageTagMutabilityErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            PutImageTagMutabilityErrorKind::ServerException(_inner) => Some(_inner),
            PutImageTagMutabilityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutLifecyclePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutLifecyclePolicyError {
    /// Kind of error that occurred.
    pub kind: PutLifecyclePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutLifecyclePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutLifecyclePolicyErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutLifecyclePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutLifecyclePolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutLifecyclePolicyErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            PutLifecyclePolicyErrorKind::ServerException(_inner) => _inner.fmt(f),
            PutLifecyclePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutLifecyclePolicyError {
    fn code(&self) -> Option<&str> {
        PutLifecyclePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutLifecyclePolicyError {
    /// Creates a new `PutLifecyclePolicyError`.
    pub fn new(kind: PutLifecyclePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutLifecyclePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutLifecyclePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutLifecyclePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutLifecyclePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutLifecyclePolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLifecyclePolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLifecyclePolicyErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLifecyclePolicyErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLifecyclePolicyErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, PutLifecyclePolicyErrorKind::ServerException(_))
    }
}
impl std::error::Error for PutLifecyclePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutLifecyclePolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutLifecyclePolicyErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            PutLifecyclePolicyErrorKind::ServerException(_inner) => Some(_inner),
            PutLifecyclePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRegistryPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRegistryPolicyError {
    /// Kind of error that occurred.
    pub kind: PutRegistryPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRegistryPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRegistryPolicyErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>There was an exception validating this request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRegistryPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRegistryPolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutRegistryPolicyErrorKind::ServerException(_inner) => _inner.fmt(f),
            PutRegistryPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutRegistryPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRegistryPolicyError {
    fn code(&self) -> Option<&str> {
        PutRegistryPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRegistryPolicyError {
    /// Creates a new `PutRegistryPolicyError`.
    pub fn new(kind: PutRegistryPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRegistryPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRegistryPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRegistryPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRegistryPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutRegistryPolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRegistryPolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRegistryPolicyErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, PutRegistryPolicyErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `PutRegistryPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRegistryPolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutRegistryPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRegistryPolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutRegistryPolicyErrorKind::ServerException(_inner) => Some(_inner),
            PutRegistryPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            PutRegistryPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRegistryScanningConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRegistryScanningConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutRegistryScanningConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRegistryScanningConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRegistryScanningConfigurationErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>There was an exception validating this request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRegistryScanningConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRegistryScanningConfigurationErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            PutRegistryScanningConfigurationErrorKind::ServerException(_inner) => _inner.fmt(f),
            PutRegistryScanningConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutRegistryScanningConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRegistryScanningConfigurationError {
    fn code(&self) -> Option<&str> {
        PutRegistryScanningConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRegistryScanningConfigurationError {
    /// Creates a new `PutRegistryScanningConfigurationError`.
    pub fn new(
        kind: PutRegistryScanningConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRegistryScanningConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRegistryScanningConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRegistryScanningConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRegistryScanningConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutRegistryScanningConfigurationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRegistryScanningConfigurationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRegistryScanningConfigurationErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRegistryScanningConfigurationErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRegistryScanningConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRegistryScanningConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutRegistryScanningConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRegistryScanningConfigurationErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            PutRegistryScanningConfigurationErrorKind::ServerException(_inner) => Some(_inner),
            PutRegistryScanningConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            PutRegistryScanningConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutReplicationConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutReplicationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutReplicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutReplicationConfigurationErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>There was an exception validating this request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutReplicationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutReplicationConfigurationErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            PutReplicationConfigurationErrorKind::ServerException(_inner) => _inner.fmt(f),
            PutReplicationConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutReplicationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutReplicationConfigurationError {
    fn code(&self) -> Option<&str> {
        PutReplicationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutReplicationConfigurationError {
    /// Creates a new `PutReplicationConfigurationError`.
    pub fn new(kind: PutReplicationConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutReplicationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutReplicationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutReplicationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutReplicationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutReplicationConfigurationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutReplicationConfigurationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutReplicationConfigurationErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutReplicationConfigurationErrorKind::ServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutReplicationConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutReplicationConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutReplicationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutReplicationConfigurationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutReplicationConfigurationErrorKind::ServerException(_inner) => Some(_inner),
            PutReplicationConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            PutReplicationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetRepositoryPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetRepositoryPolicyError {
    /// Kind of error that occurred.
    pub kind: SetRepositoryPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetRepositoryPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetRepositoryPolicyErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetRepositoryPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetRepositoryPolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            SetRepositoryPolicyErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            SetRepositoryPolicyErrorKind::ServerException(_inner) => _inner.fmt(f),
            SetRepositoryPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetRepositoryPolicyError {
    fn code(&self) -> Option<&str> {
        SetRepositoryPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetRepositoryPolicyError {
    /// Creates a new `SetRepositoryPolicyError`.
    pub fn new(kind: SetRepositoryPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetRepositoryPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetRepositoryPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetRepositoryPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetRepositoryPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetRepositoryPolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetRepositoryPolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `SetRepositoryPolicyErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetRepositoryPolicyErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SetRepositoryPolicyErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, SetRepositoryPolicyErrorKind::ServerException(_))
    }
}
impl std::error::Error for SetRepositoryPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetRepositoryPolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            SetRepositoryPolicyErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            SetRepositoryPolicyErrorKind::ServerException(_inner) => Some(_inner),
            SetRepositoryPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartImageScan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartImageScanError {
    /// Kind of error that occurred.
    pub kind: StartImageScanErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartImageScan` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartImageScanErrorKind {
    /// <p>The image requested does not exist in the specified repository.</p>
    ImageNotFoundException(crate::error::ImageNotFoundException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The operation did not succeed because it would have exceeded a service limit for your
    /// account. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service quotas</a> in
    /// the Amazon Elastic Container Registry User Guide.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The image is of a type that cannot be scanned.</p>
    UnsupportedImageTypeException(crate::error::UnsupportedImageTypeException),
    /// <p>There was an exception validating this request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartImageScanError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartImageScanErrorKind::ImageNotFoundException(_inner) => _inner.fmt(f),
            StartImageScanErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StartImageScanErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartImageScanErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            StartImageScanErrorKind::ServerException(_inner) => _inner.fmt(f),
            StartImageScanErrorKind::UnsupportedImageTypeException(_inner) => _inner.fmt(f),
            StartImageScanErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartImageScanErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartImageScanError {
    fn code(&self) -> Option<&str> {
        StartImageScanError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartImageScanError {
    /// Creates a new `StartImageScanError`.
    pub fn new(kind: StartImageScanErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartImageScanError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartImageScanErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartImageScanError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartImageScanErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartImageScanErrorKind::ImageNotFoundException`.
    pub fn is_image_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImageScanErrorKind::ImageNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImageScanErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImageScanErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImageScanErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImageScanErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImageScanErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImageScanErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImageScanErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, StartImageScanErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `StartImageScanErrorKind::UnsupportedImageTypeException`.
    pub fn is_unsupported_image_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImageScanErrorKind::UnsupportedImageTypeException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImageScanErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, StartImageScanErrorKind::ValidationException(_))
    }
}
impl std::error::Error for StartImageScanError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartImageScanErrorKind::ImageNotFoundException(_inner) => Some(_inner),
            StartImageScanErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartImageScanErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartImageScanErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            StartImageScanErrorKind::ServerException(_inner) => Some(_inner),
            StartImageScanErrorKind::UnsupportedImageTypeException(_inner) => Some(_inner),
            StartImageScanErrorKind::ValidationException(_inner) => Some(_inner),
            StartImageScanErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartLifecyclePolicyPreview` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartLifecyclePolicyPreviewError {
    /// Kind of error that occurred.
    pub kind: StartLifecyclePolicyPreviewErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartLifecyclePolicyPreview` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartLifecyclePolicyPreviewErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The lifecycle policy could not be found, and no policy is set to the
    /// repository.</p>
    LifecyclePolicyNotFoundException(crate::error::LifecyclePolicyNotFoundException),
    /// <p>The previous lifecycle policy preview request has not completed. Wait and try
    /// again.</p>
    LifecyclePolicyPreviewInProgressException(
        crate::error::LifecyclePolicyPreviewInProgressException,
    ),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartLifecyclePolicyPreviewError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartLifecyclePolicyPreviewErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            StartLifecyclePolicyPreviewErrorKind::LifecyclePolicyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StartLifecyclePolicyPreviewErrorKind::LifecyclePolicyPreviewInProgressException(
                _inner,
            ) => _inner.fmt(f),
            StartLifecyclePolicyPreviewErrorKind::RepositoryNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StartLifecyclePolicyPreviewErrorKind::ServerException(_inner) => _inner.fmt(f),
            StartLifecyclePolicyPreviewErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartLifecyclePolicyPreviewError {
    fn code(&self) -> Option<&str> {
        StartLifecyclePolicyPreviewError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartLifecyclePolicyPreviewError {
    /// Creates a new `StartLifecyclePolicyPreviewError`.
    pub fn new(kind: StartLifecyclePolicyPreviewErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartLifecyclePolicyPreviewError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartLifecyclePolicyPreviewErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartLifecyclePolicyPreviewError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartLifecyclePolicyPreviewErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartLifecyclePolicyPreviewErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartLifecyclePolicyPreviewErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `StartLifecyclePolicyPreviewErrorKind::LifecyclePolicyNotFoundException`.
    pub fn is_lifecycle_policy_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartLifecyclePolicyPreviewErrorKind::LifecyclePolicyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartLifecyclePolicyPreviewErrorKind::LifecyclePolicyPreviewInProgressException`.
    pub fn is_lifecycle_policy_preview_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartLifecyclePolicyPreviewErrorKind::LifecyclePolicyPreviewInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `StartLifecyclePolicyPreviewErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartLifecyclePolicyPreviewErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartLifecyclePolicyPreviewErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartLifecyclePolicyPreviewErrorKind::ServerException(_)
        )
    }
}
impl std::error::Error for StartLifecyclePolicyPreviewError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartLifecyclePolicyPreviewErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartLifecyclePolicyPreviewErrorKind::LifecyclePolicyNotFoundException(_inner) => {
                Some(_inner)
            }
            StartLifecyclePolicyPreviewErrorKind::LifecyclePolicyPreviewInProgressException(
                _inner,
            ) => Some(_inner),
            StartLifecyclePolicyPreviewErrorKind::RepositoryNotFoundException(_inner) => {
                Some(_inner)
            }
            StartLifecyclePolicyPreviewErrorKind::ServerException(_inner) => Some(_inner),
            StartLifecyclePolicyPreviewErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters, and tag values can have
    /// a maximum length of 256 characters.</p>
    InvalidTagParameterException(crate::error::InvalidTagParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The list of tags on the repository is over the limit. The maximum number of tags that
    /// can be applied to a repository is 50.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidTagParameterException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidTagParameterException`.
    pub fn is_invalid_tag_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidTagParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidTagParameterException(_inner) => Some(_inner),
            TagResourceErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ServerException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters, and tag values can have
    /// a maximum length of 256 characters.</p>
    InvalidTagParameterException(crate::error::InvalidTagParameterException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The list of tags on the repository is over the limit. The maximum number of tags that
    /// can be applied to a repository is 50.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidTagParameterException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidTagParameterException`.
    pub fn is_invalid_tag_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidTagParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidTagParameterException(_inner) => Some(_inner),
            UntagResourceErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UploadLayerPart` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UploadLayerPartError {
    /// Kind of error that occurred.
    pub kind: UploadLayerPartErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UploadLayerPart` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UploadLayerPartErrorKind {
    /// <p>The layer part size is not valid, or the first byte specified is not consecutive to
    /// the last byte of a previous layer part upload.</p>
    InvalidLayerPartException(crate::error::InvalidLayerPartException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The operation failed due to a KMS exception.</p>
    KmsException(crate::error::KmsException),
    /// <p>The operation did not succeed because it would have exceeded a service limit for your
    /// account. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service quotas</a> in
    /// the Amazon Elastic Container Registry User Guide.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified repository could not be found. Check the spelling of the specified
    /// repository and ensure that you are performing operations on the correct registry.</p>
    RepositoryNotFoundException(crate::error::RepositoryNotFoundException),
    /// <p>These errors are usually caused by a server-side issue.</p>
    ServerException(crate::error::ServerException),
    /// <p>The upload could not be found, or the specified upload ID is not valid for this
    /// repository.</p>
    UploadNotFoundException(crate::error::UploadNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UploadLayerPartError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UploadLayerPartErrorKind::InvalidLayerPartException(_inner) => _inner.fmt(f),
            UploadLayerPartErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UploadLayerPartErrorKind::KmsException(_inner) => _inner.fmt(f),
            UploadLayerPartErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UploadLayerPartErrorKind::RepositoryNotFoundException(_inner) => _inner.fmt(f),
            UploadLayerPartErrorKind::ServerException(_inner) => _inner.fmt(f),
            UploadLayerPartErrorKind::UploadNotFoundException(_inner) => _inner.fmt(f),
            UploadLayerPartErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UploadLayerPartError {
    fn code(&self) -> Option<&str> {
        UploadLayerPartError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UploadLayerPartError {
    /// Creates a new `UploadLayerPartError`.
    pub fn new(kind: UploadLayerPartErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UploadLayerPartError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UploadLayerPartErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UploadLayerPartError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UploadLayerPartErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UploadLayerPartErrorKind::InvalidLayerPartException`.
    pub fn is_invalid_layer_part_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadLayerPartErrorKind::InvalidLayerPartException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadLayerPartErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadLayerPartErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadLayerPartErrorKind::KmsException`.
    pub fn is_kms_exception(&self) -> bool {
        matches!(&self.kind, UploadLayerPartErrorKind::KmsException(_))
    }
    /// Returns `true` if the error kind is `UploadLayerPartErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadLayerPartErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadLayerPartErrorKind::RepositoryNotFoundException`.
    pub fn is_repository_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadLayerPartErrorKind::RepositoryNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadLayerPartErrorKind::ServerException`.
    pub fn is_server_exception(&self) -> bool {
        matches!(&self.kind, UploadLayerPartErrorKind::ServerException(_))
    }
    /// Returns `true` if the error kind is `UploadLayerPartErrorKind::UploadNotFoundException`.
    pub fn is_upload_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadLayerPartErrorKind::UploadNotFoundException(_)
        )
    }
}
impl std::error::Error for UploadLayerPartError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UploadLayerPartErrorKind::InvalidLayerPartException(_inner) => Some(_inner),
            UploadLayerPartErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UploadLayerPartErrorKind::KmsException(_inner) => Some(_inner),
            UploadLayerPartErrorKind::LimitExceededException(_inner) => Some(_inner),
            UploadLayerPartErrorKind::RepositoryNotFoundException(_inner) => Some(_inner),
            UploadLayerPartErrorKind::ServerException(_inner) => Some(_inner),
            UploadLayerPartErrorKind::UploadNotFoundException(_inner) => Some(_inner),
            UploadLayerPartErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The upload could not be found, or the specified upload ID is not valid for this
/// repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadNotFoundException {
    /// <p>The error message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UploadNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UploadNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UploadNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UploadNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UploadNotFoundException {}
/// See [`UploadNotFoundException`](crate::error::UploadNotFoundException)
pub mod upload_not_found_exception {
    /// A builder for [`UploadNotFoundException`](crate::error::UploadNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadNotFoundException`](crate::error::UploadNotFoundException)
        pub fn build(self) -> crate::error::UploadNotFoundException {
            crate::error::UploadNotFoundException {
                message: self.message,
            }
        }
    }
}
impl UploadNotFoundException {
    /// Creates a new builder-style object to manufacture [`UploadNotFoundException`](crate::error::UploadNotFoundException)
    pub fn builder() -> crate::error::upload_not_found_exception::Builder {
        crate::error::upload_not_found_exception::Builder::default()
    }
}

/// <p>These errors are usually caused by a server-side issue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerException {
    /// <p>The error message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServerException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServerException {}
/// See [`ServerException`](crate::error::ServerException)
pub mod server_exception {
    /// A builder for [`ServerException`](crate::error::ServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerException`](crate::error::ServerException)
        pub fn build(self) -> crate::error::ServerException {
            crate::error::ServerException {
                message: self.message,
            }
        }
    }
}
impl ServerException {
    /// Creates a new builder-style object to manufacture [`ServerException`](crate::error::ServerException)
    pub fn builder() -> crate::error::server_exception::Builder {
        crate::error::server_exception::Builder::default()
    }
}

/// <p>The specified repository could not be found. Check the spelling of the specified
/// repository and ensure that you are performing operations on the correct registry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryNotFoundException {
    /// <p>The error message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RepositoryNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RepositoryNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RepositoryNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RepositoryNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for RepositoryNotFoundException {}
/// See [`RepositoryNotFoundException`](crate::error::RepositoryNotFoundException)
pub mod repository_not_found_exception {
    /// A builder for [`RepositoryNotFoundException`](crate::error::RepositoryNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryNotFoundException`](crate::error::RepositoryNotFoundException)
        pub fn build(self) -> crate::error::RepositoryNotFoundException {
            crate::error::RepositoryNotFoundException {
                message: self.message,
            }
        }
    }
}
impl RepositoryNotFoundException {
    /// Creates a new builder-style object to manufacture [`RepositoryNotFoundException`](crate::error::RepositoryNotFoundException)
    pub fn builder() -> crate::error::repository_not_found_exception::Builder {
        crate::error::repository_not_found_exception::Builder::default()
    }
}

/// <p>The operation did not succeed because it would have exceeded a service limit for your
/// account. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service quotas</a> in
/// the Amazon Elastic Container Registry User Guide.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    /// <p>The error message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The operation failed due to a KMS exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The error code returned by KMS.</p>
    pub kms_error: std::option::Option<std::string::String>,
}
impl KmsException {
    /// <p>The error code returned by KMS.</p>
    pub fn kms_error(&self) -> std::option::Option<&str> {
        self.kms_error.as_deref()
    }
}
impl std::fmt::Debug for KmsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsException");
        formatter.field("message", &self.message);
        formatter.field("kms_error", &self.kms_error);
        formatter.finish()
    }
}
impl KmsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsException {}
/// See [`KmsException`](crate::error::KmsException)
pub mod kms_exception {
    /// A builder for [`KmsException`](crate::error::KmsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) kms_error: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The error code returned by KMS.</p>
        pub fn kms_error(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_error = Some(input.into());
            self
        }
        /// <p>The error code returned by KMS.</p>
        pub fn set_kms_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_error = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsException`](crate::error::KmsException)
        pub fn build(self) -> crate::error::KmsException {
            crate::error::KmsException {
                message: self.message,
                kms_error: self.kms_error,
            }
        }
    }
}
impl KmsException {
    /// Creates a new builder-style object to manufacture [`KmsException`](crate::error::KmsException)
    pub fn builder() -> crate::error::kms_exception::Builder {
        crate::error::kms_exception::Builder::default()
    }
}

/// <p>The specified parameter is invalid. Review the available parameters for the API
/// request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterException {
    /// <p>The error message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterException {}
/// See [`InvalidParameterException`](crate::error::InvalidParameterException)
pub mod invalid_parameter_exception {
    /// A builder for [`InvalidParameterException`](crate::error::InvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterException`](crate::error::InvalidParameterException)
        pub fn build(self) -> crate::error::InvalidParameterException {
            crate::error::InvalidParameterException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterException`](crate::error::InvalidParameterException)
    pub fn builder() -> crate::error::invalid_parameter_exception::Builder {
        crate::error::invalid_parameter_exception::Builder::default()
    }
}

/// <p>The layer part size is not valid, or the first byte specified is not consecutive to
/// the last byte of a previous layer part upload.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidLayerPartException {
    /// <p>The registry ID associated with the exception.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository name associated with the exception.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The upload ID associated with the exception.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>The last valid byte received from the layer part upload that is associated with the
    /// exception.</p>
    pub last_valid_byte_received: std::option::Option<i64>,
    /// <p>The error message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl InvalidLayerPartException {
    /// <p>The registry ID associated with the exception.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository name associated with the exception.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The upload ID associated with the exception.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>The last valid byte received from the layer part upload that is associated with the
    /// exception.</p>
    pub fn last_valid_byte_received(&self) -> std::option::Option<i64> {
        self.last_valid_byte_received
    }
}
impl std::fmt::Debug for InvalidLayerPartException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidLayerPartException");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("upload_id", &self.upload_id);
        formatter.field("last_valid_byte_received", &self.last_valid_byte_received);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidLayerPartException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidLayerPartException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidLayerPartException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidLayerPartException {}
/// See [`InvalidLayerPartException`](crate::error::InvalidLayerPartException)
pub mod invalid_layer_part_exception {
    /// A builder for [`InvalidLayerPartException`](crate::error::InvalidLayerPartException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) last_valid_byte_received: std::option::Option<i64>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The registry ID associated with the exception.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The registry ID associated with the exception.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository name associated with the exception.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository name associated with the exception.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The upload ID associated with the exception.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The upload ID associated with the exception.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>The last valid byte received from the layer part upload that is associated with the
        /// exception.</p>
        pub fn last_valid_byte_received(mut self, input: i64) -> Self {
            self.last_valid_byte_received = Some(input);
            self
        }
        /// <p>The last valid byte received from the layer part upload that is associated with the
        /// exception.</p>
        pub fn set_last_valid_byte_received(mut self, input: std::option::Option<i64>) -> Self {
            self.last_valid_byte_received = input;
            self
        }
        /// <p>The error message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidLayerPartException`](crate::error::InvalidLayerPartException)
        pub fn build(self) -> crate::error::InvalidLayerPartException {
            crate::error::InvalidLayerPartException {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                upload_id: self.upload_id,
                last_valid_byte_received: self.last_valid_byte_received,
                message: self.message,
            }
        }
    }
}
impl InvalidLayerPartException {
    /// Creates a new builder-style object to manufacture [`InvalidLayerPartException`](crate::error::InvalidLayerPartException)
    pub fn builder() -> crate::error::invalid_layer_part_exception::Builder {
        crate::error::invalid_layer_part_exception::Builder::default()
    }
}

/// <p>The list of tags on the repository is over the limit. The maximum number of tags that
/// can be applied to a repository is 50.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>An invalid parameter has been specified. Tag keys can have a maximum character length of 128 characters, and tag values can have
/// a maximum length of 256 characters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTagParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTagParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTagParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTagParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTagParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTagParameterException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTagParameterException {}
/// See [`InvalidTagParameterException`](crate::error::InvalidTagParameterException)
pub mod invalid_tag_parameter_exception {
    /// A builder for [`InvalidTagParameterException`](crate::error::InvalidTagParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTagParameterException`](crate::error::InvalidTagParameterException)
        pub fn build(self) -> crate::error::InvalidTagParameterException {
            crate::error::InvalidTagParameterException {
                message: self.message,
            }
        }
    }
}
impl InvalidTagParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidTagParameterException`](crate::error::InvalidTagParameterException)
    pub fn builder() -> crate::error::invalid_tag_parameter_exception::Builder {
        crate::error::invalid_tag_parameter_exception::Builder::default()
    }
}

/// <p>The previous lifecycle policy preview request has not completed. Wait and try
/// again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecyclePolicyPreviewInProgressException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LifecyclePolicyPreviewInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecyclePolicyPreviewInProgressException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LifecyclePolicyPreviewInProgressException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LifecyclePolicyPreviewInProgressException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LifecyclePolicyPreviewInProgressException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for LifecyclePolicyPreviewInProgressException {}
/// See [`LifecyclePolicyPreviewInProgressException`](crate::error::LifecyclePolicyPreviewInProgressException)
pub mod lifecycle_policy_preview_in_progress_exception {
    /// A builder for [`LifecyclePolicyPreviewInProgressException`](crate::error::LifecyclePolicyPreviewInProgressException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecyclePolicyPreviewInProgressException`](crate::error::LifecyclePolicyPreviewInProgressException)
        pub fn build(self) -> crate::error::LifecyclePolicyPreviewInProgressException {
            crate::error::LifecyclePolicyPreviewInProgressException {
                message: self.message,
            }
        }
    }
}
impl LifecyclePolicyPreviewInProgressException {
    /// Creates a new builder-style object to manufacture [`LifecyclePolicyPreviewInProgressException`](crate::error::LifecyclePolicyPreviewInProgressException)
    pub fn builder() -> crate::error::lifecycle_policy_preview_in_progress_exception::Builder {
        crate::error::lifecycle_policy_preview_in_progress_exception::Builder::default()
    }
}

/// <p>The lifecycle policy could not be found, and no policy is set to the
/// repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecyclePolicyNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LifecyclePolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecyclePolicyNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LifecyclePolicyNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LifecyclePolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LifecyclePolicyNotFoundException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for LifecyclePolicyNotFoundException {}
/// See [`LifecyclePolicyNotFoundException`](crate::error::LifecyclePolicyNotFoundException)
pub mod lifecycle_policy_not_found_exception {
    /// A builder for [`LifecyclePolicyNotFoundException`](crate::error::LifecyclePolicyNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecyclePolicyNotFoundException`](crate::error::LifecyclePolicyNotFoundException)
        pub fn build(self) -> crate::error::LifecyclePolicyNotFoundException {
            crate::error::LifecyclePolicyNotFoundException {
                message: self.message,
            }
        }
    }
}
impl LifecyclePolicyNotFoundException {
    /// Creates a new builder-style object to manufacture [`LifecyclePolicyNotFoundException`](crate::error::LifecyclePolicyNotFoundException)
    pub fn builder() -> crate::error::lifecycle_policy_not_found_exception::Builder {
        crate::error::lifecycle_policy_not_found_exception::Builder::default()
    }
}

/// <p>There was an exception validating this request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The image is of a type that cannot be scanned.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedImageTypeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedImageTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedImageTypeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedImageTypeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedImageTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedImageTypeException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedImageTypeException {}
/// See [`UnsupportedImageTypeException`](crate::error::UnsupportedImageTypeException)
pub mod unsupported_image_type_exception {
    /// A builder for [`UnsupportedImageTypeException`](crate::error::UnsupportedImageTypeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedImageTypeException`](crate::error::UnsupportedImageTypeException)
        pub fn build(self) -> crate::error::UnsupportedImageTypeException {
            crate::error::UnsupportedImageTypeException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedImageTypeException {
    /// Creates a new builder-style object to manufacture [`UnsupportedImageTypeException`](crate::error::UnsupportedImageTypeException)
    pub fn builder() -> crate::error::unsupported_image_type_exception::Builder {
        crate::error::unsupported_image_type_exception::Builder::default()
    }
}

/// <p>The image requested does not exist in the specified repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ImageNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ImageNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ImageNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ImageNotFoundException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for ImageNotFoundException {}
/// See [`ImageNotFoundException`](crate::error::ImageNotFoundException)
pub mod image_not_found_exception {
    /// A builder for [`ImageNotFoundException`](crate::error::ImageNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageNotFoundException`](crate::error::ImageNotFoundException)
        pub fn build(self) -> crate::error::ImageNotFoundException {
            crate::error::ImageNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ImageNotFoundException {
    /// Creates a new builder-style object to manufacture [`ImageNotFoundException`](crate::error::ImageNotFoundException)
    pub fn builder() -> crate::error::image_not_found_exception::Builder {
        crate::error::image_not_found_exception::Builder::default()
    }
}

/// <p>The manifest list is referencing an image that does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReferencedImagesNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReferencedImagesNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReferencedImagesNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReferencedImagesNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReferencedImagesNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ReferencedImagesNotFoundException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReferencedImagesNotFoundException {}
/// See [`ReferencedImagesNotFoundException`](crate::error::ReferencedImagesNotFoundException)
pub mod referenced_images_not_found_exception {
    /// A builder for [`ReferencedImagesNotFoundException`](crate::error::ReferencedImagesNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReferencedImagesNotFoundException`](crate::error::ReferencedImagesNotFoundException)
        pub fn build(self) -> crate::error::ReferencedImagesNotFoundException {
            crate::error::ReferencedImagesNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ReferencedImagesNotFoundException {
    /// Creates a new builder-style object to manufacture [`ReferencedImagesNotFoundException`](crate::error::ReferencedImagesNotFoundException)
    pub fn builder() -> crate::error::referenced_images_not_found_exception::Builder {
        crate::error::referenced_images_not_found_exception::Builder::default()
    }
}

/// <p>The specified layers could not be found, or the specified layer is not valid for this
/// repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LayersNotFoundException {
    /// <p>The error message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LayersNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LayersNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LayersNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LayersNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LayersNotFoundException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for LayersNotFoundException {}
/// See [`LayersNotFoundException`](crate::error::LayersNotFoundException)
pub mod layers_not_found_exception {
    /// A builder for [`LayersNotFoundException`](crate::error::LayersNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LayersNotFoundException`](crate::error::LayersNotFoundException)
        pub fn build(self) -> crate::error::LayersNotFoundException {
            crate::error::LayersNotFoundException {
                message: self.message,
            }
        }
    }
}
impl LayersNotFoundException {
    /// Creates a new builder-style object to manufacture [`LayersNotFoundException`](crate::error::LayersNotFoundException)
    pub fn builder() -> crate::error::layers_not_found_exception::Builder {
        crate::error::layers_not_found_exception::Builder::default()
    }
}

/// <p>The specified image is tagged with a tag that already exists. The repository is
/// configured for tag immutability.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageTagAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ImageTagAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageTagAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ImageTagAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ImageTagAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ImageTagAlreadyExistsException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for ImageTagAlreadyExistsException {}
/// See [`ImageTagAlreadyExistsException`](crate::error::ImageTagAlreadyExistsException)
pub mod image_tag_already_exists_exception {
    /// A builder for [`ImageTagAlreadyExistsException`](crate::error::ImageTagAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageTagAlreadyExistsException`](crate::error::ImageTagAlreadyExistsException)
        pub fn build(self) -> crate::error::ImageTagAlreadyExistsException {
            crate::error::ImageTagAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ImageTagAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ImageTagAlreadyExistsException`](crate::error::ImageTagAlreadyExistsException)
    pub fn builder() -> crate::error::image_tag_already_exists_exception::Builder {
        crate::error::image_tag_already_exists_exception::Builder::default()
    }
}

/// <p>The specified image digest does not match the digest that Amazon ECR calculated for the
/// image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageDigestDoesNotMatchException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ImageDigestDoesNotMatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageDigestDoesNotMatchException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ImageDigestDoesNotMatchException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ImageDigestDoesNotMatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ImageDigestDoesNotMatchException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for ImageDigestDoesNotMatchException {}
/// See [`ImageDigestDoesNotMatchException`](crate::error::ImageDigestDoesNotMatchException)
pub mod image_digest_does_not_match_exception {
    /// A builder for [`ImageDigestDoesNotMatchException`](crate::error::ImageDigestDoesNotMatchException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageDigestDoesNotMatchException`](crate::error::ImageDigestDoesNotMatchException)
        pub fn build(self) -> crate::error::ImageDigestDoesNotMatchException {
            crate::error::ImageDigestDoesNotMatchException {
                message: self.message,
            }
        }
    }
}
impl ImageDigestDoesNotMatchException {
    /// Creates a new builder-style object to manufacture [`ImageDigestDoesNotMatchException`](crate::error::ImageDigestDoesNotMatchException)
    pub fn builder() -> crate::error::image_digest_does_not_match_exception::Builder {
        crate::error::image_digest_does_not_match_exception::Builder::default()
    }
}

/// <p>The specified image has already been pushed, and there were no changes to the manifest
/// or image tag after the last push.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageAlreadyExistsException {
    /// <p>The error message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ImageAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ImageAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ImageAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ImageAlreadyExistsException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for ImageAlreadyExistsException {}
/// See [`ImageAlreadyExistsException`](crate::error::ImageAlreadyExistsException)
pub mod image_already_exists_exception {
    /// A builder for [`ImageAlreadyExistsException`](crate::error::ImageAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageAlreadyExistsException`](crate::error::ImageAlreadyExistsException)
        pub fn build(self) -> crate::error::ImageAlreadyExistsException {
            crate::error::ImageAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ImageAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ImageAlreadyExistsException`](crate::error::ImageAlreadyExistsException)
    pub fn builder() -> crate::error::image_already_exists_exception::Builder {
        crate::error::image_already_exists_exception::Builder::default()
    }
}

/// <p>The specified repository and registry combination does not have an associated
/// repository policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryPolicyNotFoundException {
    /// <p>The error message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RepositoryPolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryPolicyNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RepositoryPolicyNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RepositoryPolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RepositoryPolicyNotFoundException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for RepositoryPolicyNotFoundException {}
/// See [`RepositoryPolicyNotFoundException`](crate::error::RepositoryPolicyNotFoundException)
pub mod repository_policy_not_found_exception {
    /// A builder for [`RepositoryPolicyNotFoundException`](crate::error::RepositoryPolicyNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryPolicyNotFoundException`](crate::error::RepositoryPolicyNotFoundException)
        pub fn build(self) -> crate::error::RepositoryPolicyNotFoundException {
            crate::error::RepositoryPolicyNotFoundException {
                message: self.message,
            }
        }
    }
}
impl RepositoryPolicyNotFoundException {
    /// Creates a new builder-style object to manufacture [`RepositoryPolicyNotFoundException`](crate::error::RepositoryPolicyNotFoundException)
    pub fn builder() -> crate::error::repository_policy_not_found_exception::Builder {
        crate::error::repository_policy_not_found_exception::Builder::default()
    }
}

/// <p>The registry doesn't have an associated registry policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegistryPolicyNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RegistryPolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegistryPolicyNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RegistryPolicyNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RegistryPolicyNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RegistryPolicyNotFoundException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for RegistryPolicyNotFoundException {}
/// See [`RegistryPolicyNotFoundException`](crate::error::RegistryPolicyNotFoundException)
pub mod registry_policy_not_found_exception {
    /// A builder for [`RegistryPolicyNotFoundException`](crate::error::RegistryPolicyNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RegistryPolicyNotFoundException`](crate::error::RegistryPolicyNotFoundException)
        pub fn build(self) -> crate::error::RegistryPolicyNotFoundException {
            crate::error::RegistryPolicyNotFoundException {
                message: self.message,
            }
        }
    }
}
impl RegistryPolicyNotFoundException {
    /// Creates a new builder-style object to manufacture [`RegistryPolicyNotFoundException`](crate::error::RegistryPolicyNotFoundException)
    pub fn builder() -> crate::error::registry_policy_not_found_exception::Builder {
        crate::error::registry_policy_not_found_exception::Builder::default()
    }
}

/// <p>There is no dry run for this repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecyclePolicyPreviewNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LifecyclePolicyPreviewNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecyclePolicyPreviewNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LifecyclePolicyPreviewNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LifecyclePolicyPreviewNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LifecyclePolicyPreviewNotFoundException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for LifecyclePolicyPreviewNotFoundException {}
/// See [`LifecyclePolicyPreviewNotFoundException`](crate::error::LifecyclePolicyPreviewNotFoundException)
pub mod lifecycle_policy_preview_not_found_exception {
    /// A builder for [`LifecyclePolicyPreviewNotFoundException`](crate::error::LifecyclePolicyPreviewNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecyclePolicyPreviewNotFoundException`](crate::error::LifecyclePolicyPreviewNotFoundException)
        pub fn build(self) -> crate::error::LifecyclePolicyPreviewNotFoundException {
            crate::error::LifecyclePolicyPreviewNotFoundException {
                message: self.message,
            }
        }
    }
}
impl LifecyclePolicyPreviewNotFoundException {
    /// Creates a new builder-style object to manufacture [`LifecyclePolicyPreviewNotFoundException`](crate::error::LifecyclePolicyPreviewNotFoundException)
    pub fn builder() -> crate::error::lifecycle_policy_preview_not_found_exception::Builder {
        crate::error::lifecycle_policy_preview_not_found_exception::Builder::default()
    }
}

/// <p>The specified layer is not available because it is not associated with an image.
/// Unassociated image layers may be cleaned up at any time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LayerInaccessibleException {
    /// <p>The error message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LayerInaccessibleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LayerInaccessibleException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LayerInaccessibleException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LayerInaccessibleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LayerInaccessibleException")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for LayerInaccessibleException {}
/// See [`LayerInaccessibleException`](crate::error::LayerInaccessibleException)
pub mod layer_inaccessible_exception {
    /// A builder for [`LayerInaccessibleException`](crate::error::LayerInaccessibleException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LayerInaccessibleException`](crate::error::LayerInaccessibleException)
        pub fn build(self) -> crate::error::LayerInaccessibleException {
            crate::error::LayerInaccessibleException {
                message: self.message,
            }
        }
    }
}
impl LayerInaccessibleException {
    /// Creates a new builder-style object to manufacture [`LayerInaccessibleException`](crate::error::LayerInaccessibleException)
    pub fn builder() -> crate::error::layer_inaccessible_exception::Builder {
        crate::error::layer_inaccessible_exception::Builder::default()
    }
}

/// <p>The pull through cache rule was not found. Specify a valid pull through cache rule and
/// try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PullThroughCacheRuleNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PullThroughCacheRuleNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PullThroughCacheRuleNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PullThroughCacheRuleNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PullThroughCacheRuleNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PullThroughCacheRuleNotFoundException")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for PullThroughCacheRuleNotFoundException {}
/// See [`PullThroughCacheRuleNotFoundException`](crate::error::PullThroughCacheRuleNotFoundException)
pub mod pull_through_cache_rule_not_found_exception {
    /// A builder for [`PullThroughCacheRuleNotFoundException`](crate::error::PullThroughCacheRuleNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PullThroughCacheRuleNotFoundException`](crate::error::PullThroughCacheRuleNotFoundException)
        pub fn build(self) -> crate::error::PullThroughCacheRuleNotFoundException {
            crate::error::PullThroughCacheRuleNotFoundException {
                message: self.message,
            }
        }
    }
}
impl PullThroughCacheRuleNotFoundException {
    /// Creates a new builder-style object to manufacture [`PullThroughCacheRuleNotFoundException`](crate::error::PullThroughCacheRuleNotFoundException)
    pub fn builder() -> crate::error::pull_through_cache_rule_not_found_exception::Builder {
        crate::error::pull_through_cache_rule_not_found_exception::Builder::default()
    }
}

/// <p>The specified image scan could not be found. Ensure that image scanning is enabled on
/// the repository and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScanNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ScanNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScanNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ScanNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ScanNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ScanNotFoundException")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for ScanNotFoundException {}
/// See [`ScanNotFoundException`](crate::error::ScanNotFoundException)
pub mod scan_not_found_exception {
    /// A builder for [`ScanNotFoundException`](crate::error::ScanNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ScanNotFoundException`](crate::error::ScanNotFoundException)
        pub fn build(self) -> crate::error::ScanNotFoundException {
            crate::error::ScanNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ScanNotFoundException {
    /// Creates a new builder-style object to manufacture [`ScanNotFoundException`](crate::error::ScanNotFoundException)
    pub fn builder() -> crate::error::scan_not_found_exception::Builder {
        crate::error::scan_not_found_exception::Builder::default()
    }
}

/// <p>The specified repository contains images. To delete a repository that contains images,
/// you must force the deletion with the <code>force</code> parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryNotEmptyException {
    /// <p>The error message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RepositoryNotEmptyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryNotEmptyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RepositoryNotEmptyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RepositoryNotEmptyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RepositoryNotEmptyException")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for RepositoryNotEmptyException {}
/// See [`RepositoryNotEmptyException`](crate::error::RepositoryNotEmptyException)
pub mod repository_not_empty_exception {
    /// A builder for [`RepositoryNotEmptyException`](crate::error::RepositoryNotEmptyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryNotEmptyException`](crate::error::RepositoryNotEmptyException)
        pub fn build(self) -> crate::error::RepositoryNotEmptyException {
            crate::error::RepositoryNotEmptyException {
                message: self.message,
            }
        }
    }
}
impl RepositoryNotEmptyException {
    /// Creates a new builder-style object to manufacture [`RepositoryNotEmptyException`](crate::error::RepositoryNotEmptyException)
    pub fn builder() -> crate::error::repository_not_empty_exception::Builder {
        crate::error::repository_not_empty_exception::Builder::default()
    }
}

/// <p>The specified repository already exists in the specified registry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryAlreadyExistsException {
    /// <p>The error message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RepositoryAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RepositoryAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RepositoryAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RepositoryAlreadyExistsException")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for RepositoryAlreadyExistsException {}
/// See [`RepositoryAlreadyExistsException`](crate::error::RepositoryAlreadyExistsException)
pub mod repository_already_exists_exception {
    /// A builder for [`RepositoryAlreadyExistsException`](crate::error::RepositoryAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryAlreadyExistsException`](crate::error::RepositoryAlreadyExistsException)
        pub fn build(self) -> crate::error::RepositoryAlreadyExistsException {
            crate::error::RepositoryAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl RepositoryAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`RepositoryAlreadyExistsException`](crate::error::RepositoryAlreadyExistsException)
    pub fn builder() -> crate::error::repository_already_exists_exception::Builder {
        crate::error::repository_already_exists_exception::Builder::default()
    }
}

/// <p>The specified upstream registry isn't supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedUpstreamRegistryException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedUpstreamRegistryException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedUpstreamRegistryException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedUpstreamRegistryException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedUpstreamRegistryException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedUpstreamRegistryException")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedUpstreamRegistryException {}
/// See [`UnsupportedUpstreamRegistryException`](crate::error::UnsupportedUpstreamRegistryException)
pub mod unsupported_upstream_registry_exception {
    /// A builder for [`UnsupportedUpstreamRegistryException`](crate::error::UnsupportedUpstreamRegistryException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedUpstreamRegistryException`](crate::error::UnsupportedUpstreamRegistryException)
        pub fn build(self) -> crate::error::UnsupportedUpstreamRegistryException {
            crate::error::UnsupportedUpstreamRegistryException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedUpstreamRegistryException {
    /// Creates a new builder-style object to manufacture [`UnsupportedUpstreamRegistryException`](crate::error::UnsupportedUpstreamRegistryException)
    pub fn builder() -> crate::error::unsupported_upstream_registry_exception::Builder {
        crate::error::unsupported_upstream_registry_exception::Builder::default()
    }
}

/// <p>A pull through cache rule with these settings already exists for the private
/// registry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PullThroughCacheRuleAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PullThroughCacheRuleAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PullThroughCacheRuleAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PullThroughCacheRuleAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PullThroughCacheRuleAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PullThroughCacheRuleAlreadyExistsException")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for PullThroughCacheRuleAlreadyExistsException {}
/// See [`PullThroughCacheRuleAlreadyExistsException`](crate::error::PullThroughCacheRuleAlreadyExistsException)
pub mod pull_through_cache_rule_already_exists_exception {
    /// A builder for [`PullThroughCacheRuleAlreadyExistsException`](crate::error::PullThroughCacheRuleAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PullThroughCacheRuleAlreadyExistsException`](crate::error::PullThroughCacheRuleAlreadyExistsException)
        pub fn build(self) -> crate::error::PullThroughCacheRuleAlreadyExistsException {
            crate::error::PullThroughCacheRuleAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl PullThroughCacheRuleAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`PullThroughCacheRuleAlreadyExistsException`](crate::error::PullThroughCacheRuleAlreadyExistsException)
    pub fn builder() -> crate::error::pull_through_cache_rule_already_exists_exception::Builder {
        crate::error::pull_through_cache_rule_already_exists_exception::Builder::default()
    }
}

/// <p>Layer parts must be at least 5 MiB in size.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LayerPartTooSmallException {
    /// <p>The error message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LayerPartTooSmallException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LayerPartTooSmallException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LayerPartTooSmallException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LayerPartTooSmallException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LayerPartTooSmallException")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for LayerPartTooSmallException {}
/// See [`LayerPartTooSmallException`](crate::error::LayerPartTooSmallException)
pub mod layer_part_too_small_exception {
    /// A builder for [`LayerPartTooSmallException`](crate::error::LayerPartTooSmallException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LayerPartTooSmallException`](crate::error::LayerPartTooSmallException)
        pub fn build(self) -> crate::error::LayerPartTooSmallException {
            crate::error::LayerPartTooSmallException {
                message: self.message,
            }
        }
    }
}
impl LayerPartTooSmallException {
    /// Creates a new builder-style object to manufacture [`LayerPartTooSmallException`](crate::error::LayerPartTooSmallException)
    pub fn builder() -> crate::error::layer_part_too_small_exception::Builder {
        crate::error::layer_part_too_small_exception::Builder::default()
    }
}

/// <p>The image layer already exists in the associated repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LayerAlreadyExistsException {
    /// <p>The error message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LayerAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LayerAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LayerAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LayerAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LayerAlreadyExistsException")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for LayerAlreadyExistsException {}
/// See [`LayerAlreadyExistsException`](crate::error::LayerAlreadyExistsException)
pub mod layer_already_exists_exception {
    /// A builder for [`LayerAlreadyExistsException`](crate::error::LayerAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LayerAlreadyExistsException`](crate::error::LayerAlreadyExistsException)
        pub fn build(self) -> crate::error::LayerAlreadyExistsException {
            crate::error::LayerAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl LayerAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`LayerAlreadyExistsException`](crate::error::LayerAlreadyExistsException)
    pub fn builder() -> crate::error::layer_already_exists_exception::Builder {
        crate::error::layer_already_exists_exception::Builder::default()
    }
}

/// <p>The layer digest calculation performed by Amazon ECR upon receipt of the image layer does
/// not match the digest specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidLayerException {
    /// <p>The error message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidLayerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidLayerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidLayerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidLayerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidLayerException")?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidLayerException {}
/// See [`InvalidLayerException`](crate::error::InvalidLayerException)
pub mod invalid_layer_exception {
    /// A builder for [`InvalidLayerException`](crate::error::InvalidLayerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidLayerException`](crate::error::InvalidLayerException)
        pub fn build(self) -> crate::error::InvalidLayerException {
            crate::error::InvalidLayerException {
                message: self.message,
            }
        }
    }
}
impl InvalidLayerException {
    /// Creates a new builder-style object to manufacture [`InvalidLayerException`](crate::error::InvalidLayerException)
    pub fn builder() -> crate::error::invalid_layer_exception::Builder {
        crate::error::invalid_layer_exception::Builder::default()
    }
}

/// <p>The specified layer upload does not contain any layer parts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmptyUploadException {
    /// <p>The error message associated with the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EmptyUploadException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmptyUploadException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EmptyUploadException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EmptyUploadException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EmptyUploadException")?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for EmptyUploadException {}
/// See [`EmptyUploadException`](crate::error::EmptyUploadException)
pub mod empty_upload_exception {
    /// A builder for [`EmptyUploadException`](crate::error::EmptyUploadException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message associated with the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message associated with the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EmptyUploadException`](crate::error::EmptyUploadException)
        pub fn build(self) -> crate::error::EmptyUploadException {
            crate::error::EmptyUploadException {
                message: self.message,
            }
        }
    }
}
impl EmptyUploadException {
    /// Creates a new builder-style object to manufacture [`EmptyUploadException`](crate::error::EmptyUploadException)
    pub fn builder() -> crate::error::empty_upload_exception::Builder {
        crate::error::empty_upload_exception::Builder::default()
    }
}
