// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon EC2 Container Registry
///
/// Client for invoking operations on Amazon EC2 Container Registry. Each operation on Amazon EC2 Container Registry is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_ecr::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_ecr::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_ecr::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchCheckLayerAvailability` operation.
    ///
    /// See [`BatchCheckLayerAvailability`](crate::client::fluent_builders::BatchCheckLayerAvailability) for more information about the
    /// operation and its arguments.
    pub fn batch_check_layer_availability(
        &self,
    ) -> fluent_builders::BatchCheckLayerAvailability<C, M, R> {
        fluent_builders::BatchCheckLayerAvailability::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDeleteImage` operation.
    ///
    /// See [`BatchDeleteImage`](crate::client::fluent_builders::BatchDeleteImage) for more information about the
    /// operation and its arguments.
    pub fn batch_delete_image(&self) -> fluent_builders::BatchDeleteImage<C, M, R> {
        fluent_builders::BatchDeleteImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetImage` operation.
    ///
    /// See [`BatchGetImage`](crate::client::fluent_builders::BatchGetImage) for more information about the
    /// operation and its arguments.
    pub fn batch_get_image(&self) -> fluent_builders::BatchGetImage<C, M, R> {
        fluent_builders::BatchGetImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetRepositoryScanningConfiguration` operation.
    ///
    /// See [`BatchGetRepositoryScanningConfiguration`](crate::client::fluent_builders::BatchGetRepositoryScanningConfiguration) for more information about the
    /// operation and its arguments.
    pub fn batch_get_repository_scanning_configuration(
        &self,
    ) -> fluent_builders::BatchGetRepositoryScanningConfiguration<C, M, R> {
        fluent_builders::BatchGetRepositoryScanningConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CompleteLayerUpload` operation.
    ///
    /// See [`CompleteLayerUpload`](crate::client::fluent_builders::CompleteLayerUpload) for more information about the
    /// operation and its arguments.
    pub fn complete_layer_upload(&self) -> fluent_builders::CompleteLayerUpload<C, M, R> {
        fluent_builders::CompleteLayerUpload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePullThroughCacheRule` operation.
    ///
    /// See [`CreatePullThroughCacheRule`](crate::client::fluent_builders::CreatePullThroughCacheRule) for more information about the
    /// operation and its arguments.
    pub fn create_pull_through_cache_rule(
        &self,
    ) -> fluent_builders::CreatePullThroughCacheRule<C, M, R> {
        fluent_builders::CreatePullThroughCacheRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRepository` operation.
    ///
    /// See [`CreateRepository`](crate::client::fluent_builders::CreateRepository) for more information about the
    /// operation and its arguments.
    pub fn create_repository(&self) -> fluent_builders::CreateRepository<C, M, R> {
        fluent_builders::CreateRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLifecyclePolicy` operation.
    ///
    /// See [`DeleteLifecyclePolicy`](crate::client::fluent_builders::DeleteLifecyclePolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_lifecycle_policy(&self) -> fluent_builders::DeleteLifecyclePolicy<C, M, R> {
        fluent_builders::DeleteLifecyclePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePullThroughCacheRule` operation.
    ///
    /// See [`DeletePullThroughCacheRule`](crate::client::fluent_builders::DeletePullThroughCacheRule) for more information about the
    /// operation and its arguments.
    pub fn delete_pull_through_cache_rule(
        &self,
    ) -> fluent_builders::DeletePullThroughCacheRule<C, M, R> {
        fluent_builders::DeletePullThroughCacheRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRegistryPolicy` operation.
    ///
    /// See [`DeleteRegistryPolicy`](crate::client::fluent_builders::DeleteRegistryPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_registry_policy(&self) -> fluent_builders::DeleteRegistryPolicy<C, M, R> {
        fluent_builders::DeleteRegistryPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRepository` operation.
    ///
    /// See [`DeleteRepository`](crate::client::fluent_builders::DeleteRepository) for more information about the
    /// operation and its arguments.
    pub fn delete_repository(&self) -> fluent_builders::DeleteRepository<C, M, R> {
        fluent_builders::DeleteRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRepositoryPolicy` operation.
    ///
    /// See [`DeleteRepositoryPolicy`](crate::client::fluent_builders::DeleteRepositoryPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_repository_policy(&self) -> fluent_builders::DeleteRepositoryPolicy<C, M, R> {
        fluent_builders::DeleteRepositoryPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeImageReplicationStatus` operation.
    ///
    /// See [`DescribeImageReplicationStatus`](crate::client::fluent_builders::DescribeImageReplicationStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_image_replication_status(
        &self,
    ) -> fluent_builders::DescribeImageReplicationStatus<C, M, R> {
        fluent_builders::DescribeImageReplicationStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeImages` operation.
    ///
    /// See [`DescribeImages`](crate::client::fluent_builders::DescribeImages) for more information about the
    /// operation and its arguments.
    pub fn describe_images(&self) -> fluent_builders::DescribeImages<C, M, R> {
        fluent_builders::DescribeImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeImageScanFindings` operation.
    ///
    /// See [`DescribeImageScanFindings`](crate::client::fluent_builders::DescribeImageScanFindings) for more information about the
    /// operation and its arguments.
    pub fn describe_image_scan_findings(
        &self,
    ) -> fluent_builders::DescribeImageScanFindings<C, M, R> {
        fluent_builders::DescribeImageScanFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePullThroughCacheRules` operation.
    ///
    /// See [`DescribePullThroughCacheRules`](crate::client::fluent_builders::DescribePullThroughCacheRules) for more information about the
    /// operation and its arguments.
    pub fn describe_pull_through_cache_rules(
        &self,
    ) -> fluent_builders::DescribePullThroughCacheRules<C, M, R> {
        fluent_builders::DescribePullThroughCacheRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRegistry` operation.
    ///
    /// See [`DescribeRegistry`](crate::client::fluent_builders::DescribeRegistry) for more information about the
    /// operation and its arguments.
    pub fn describe_registry(&self) -> fluent_builders::DescribeRegistry<C, M, R> {
        fluent_builders::DescribeRegistry::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRepositories` operation.
    ///
    /// See [`DescribeRepositories`](crate::client::fluent_builders::DescribeRepositories) for more information about the
    /// operation and its arguments.
    pub fn describe_repositories(&self) -> fluent_builders::DescribeRepositories<C, M, R> {
        fluent_builders::DescribeRepositories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAuthorizationToken` operation.
    ///
    /// See [`GetAuthorizationToken`](crate::client::fluent_builders::GetAuthorizationToken) for more information about the
    /// operation and its arguments.
    pub fn get_authorization_token(&self) -> fluent_builders::GetAuthorizationToken<C, M, R> {
        fluent_builders::GetAuthorizationToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDownloadUrlForLayer` operation.
    ///
    /// See [`GetDownloadUrlForLayer`](crate::client::fluent_builders::GetDownloadUrlForLayer) for more information about the
    /// operation and its arguments.
    pub fn get_download_url_for_layer(&self) -> fluent_builders::GetDownloadUrlForLayer<C, M, R> {
        fluent_builders::GetDownloadUrlForLayer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLifecyclePolicy` operation.
    ///
    /// See [`GetLifecyclePolicy`](crate::client::fluent_builders::GetLifecyclePolicy) for more information about the
    /// operation and its arguments.
    pub fn get_lifecycle_policy(&self) -> fluent_builders::GetLifecyclePolicy<C, M, R> {
        fluent_builders::GetLifecyclePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLifecyclePolicyPreview` operation.
    ///
    /// See [`GetLifecyclePolicyPreview`](crate::client::fluent_builders::GetLifecyclePolicyPreview) for more information about the
    /// operation and its arguments.
    pub fn get_lifecycle_policy_preview(
        &self,
    ) -> fluent_builders::GetLifecyclePolicyPreview<C, M, R> {
        fluent_builders::GetLifecyclePolicyPreview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRegistryPolicy` operation.
    ///
    /// See [`GetRegistryPolicy`](crate::client::fluent_builders::GetRegistryPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_registry_policy(&self) -> fluent_builders::GetRegistryPolicy<C, M, R> {
        fluent_builders::GetRegistryPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRegistryScanningConfiguration` operation.
    ///
    /// See [`GetRegistryScanningConfiguration`](crate::client::fluent_builders::GetRegistryScanningConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_registry_scanning_configuration(
        &self,
    ) -> fluent_builders::GetRegistryScanningConfiguration<C, M, R> {
        fluent_builders::GetRegistryScanningConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRepositoryPolicy` operation.
    ///
    /// See [`GetRepositoryPolicy`](crate::client::fluent_builders::GetRepositoryPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_repository_policy(&self) -> fluent_builders::GetRepositoryPolicy<C, M, R> {
        fluent_builders::GetRepositoryPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `InitiateLayerUpload` operation.
    ///
    /// See [`InitiateLayerUpload`](crate::client::fluent_builders::InitiateLayerUpload) for more information about the
    /// operation and its arguments.
    pub fn initiate_layer_upload(&self) -> fluent_builders::InitiateLayerUpload<C, M, R> {
        fluent_builders::InitiateLayerUpload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListImages` operation.
    ///
    /// See [`ListImages`](crate::client::fluent_builders::ListImages) for more information about the
    /// operation and its arguments.
    pub fn list_images(&self) -> fluent_builders::ListImages<C, M, R> {
        fluent_builders::ListImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutImage` operation.
    ///
    /// See [`PutImage`](crate::client::fluent_builders::PutImage) for more information about the
    /// operation and its arguments.
    pub fn put_image(&self) -> fluent_builders::PutImage<C, M, R> {
        fluent_builders::PutImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutImageScanningConfiguration` operation.
    ///
    /// See [`PutImageScanningConfiguration`](crate::client::fluent_builders::PutImageScanningConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_image_scanning_configuration(
        &self,
    ) -> fluent_builders::PutImageScanningConfiguration<C, M, R> {
        fluent_builders::PutImageScanningConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutImageTagMutability` operation.
    ///
    /// See [`PutImageTagMutability`](crate::client::fluent_builders::PutImageTagMutability) for more information about the
    /// operation and its arguments.
    pub fn put_image_tag_mutability(&self) -> fluent_builders::PutImageTagMutability<C, M, R> {
        fluent_builders::PutImageTagMutability::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutLifecyclePolicy` operation.
    ///
    /// See [`PutLifecyclePolicy`](crate::client::fluent_builders::PutLifecyclePolicy) for more information about the
    /// operation and its arguments.
    pub fn put_lifecycle_policy(&self) -> fluent_builders::PutLifecyclePolicy<C, M, R> {
        fluent_builders::PutLifecyclePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutRegistryPolicy` operation.
    ///
    /// See [`PutRegistryPolicy`](crate::client::fluent_builders::PutRegistryPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_registry_policy(&self) -> fluent_builders::PutRegistryPolicy<C, M, R> {
        fluent_builders::PutRegistryPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutRegistryScanningConfiguration` operation.
    ///
    /// See [`PutRegistryScanningConfiguration`](crate::client::fluent_builders::PutRegistryScanningConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_registry_scanning_configuration(
        &self,
    ) -> fluent_builders::PutRegistryScanningConfiguration<C, M, R> {
        fluent_builders::PutRegistryScanningConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutReplicationConfiguration` operation.
    ///
    /// See [`PutReplicationConfiguration`](crate::client::fluent_builders::PutReplicationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_replication_configuration(
        &self,
    ) -> fluent_builders::PutReplicationConfiguration<C, M, R> {
        fluent_builders::PutReplicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetRepositoryPolicy` operation.
    ///
    /// See [`SetRepositoryPolicy`](crate::client::fluent_builders::SetRepositoryPolicy) for more information about the
    /// operation and its arguments.
    pub fn set_repository_policy(&self) -> fluent_builders::SetRepositoryPolicy<C, M, R> {
        fluent_builders::SetRepositoryPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartImageScan` operation.
    ///
    /// See [`StartImageScan`](crate::client::fluent_builders::StartImageScan) for more information about the
    /// operation and its arguments.
    pub fn start_image_scan(&self) -> fluent_builders::StartImageScan<C, M, R> {
        fluent_builders::StartImageScan::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartLifecyclePolicyPreview` operation.
    ///
    /// See [`StartLifecyclePolicyPreview`](crate::client::fluent_builders::StartLifecyclePolicyPreview) for more information about the
    /// operation and its arguments.
    pub fn start_lifecycle_policy_preview(
        &self,
    ) -> fluent_builders::StartLifecyclePolicyPreview<C, M, R> {
        fluent_builders::StartLifecyclePolicyPreview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UploadLayerPart` operation.
    ///
    /// See [`UploadLayerPart`](crate::client::fluent_builders::UploadLayerPart) for more information about the
    /// operation and its arguments.
    pub fn upload_layer_part(&self) -> fluent_builders::UploadLayerPart<C, M, R> {
        fluent_builders::UploadLayerPart::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchCheckLayerAvailability`.
    ///
    /// <p>Checks the availability of one or more image layers in a repository.</p>
    /// <p>When an image is pushed to a repository, each image layer is checked to verify if it
    /// has been uploaded before. If it has been uploaded, then the image layer is
    /// skipped.</p>
    /// <note>
    /// <p>This operation is used by the Amazon ECR proxy and is not generally used by
    /// customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct BatchCheckLayerAvailability<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_check_layer_availability_input::Builder,
    }
    impl<C, M, R> BatchCheckLayerAvailability<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchCheckLayerAvailability`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCheckLayerAvailabilityOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCheckLayerAvailabilityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchCheckLayerAvailabilityInputOperationOutputAlias,
                crate::output::BatchCheckLayerAvailabilityOutput,
                crate::error::BatchCheckLayerAvailabilityError,
                crate::input::BatchCheckLayerAvailabilityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the image layers to
        /// check. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the image layers to
        /// check. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository that is associated with the image layers to check.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that is associated with the image layers to check.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `layerDigests`.
        ///
        /// To override the contents of this collection use [`set_layer_digests`](Self::set_layer_digests).
        ///
        /// <p>The digests of the image layers to check.</p>
        pub fn layer_digests(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_digests(inp);
            self
        }
        /// <p>The digests of the image layers to check.</p>
        pub fn set_layer_digests(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_layer_digests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeleteImage`.
    ///
    /// <p>Deletes a list of specified images within a repository. Images are specified with
    /// either an <code>imageTag</code> or <code>imageDigest</code>.</p>
    /// <p>You can remove a tag from an image by specifying the image's tag in your request. When
    /// you remove the last tag from an image, the image is deleted from your repository.</p>
    /// <p>You can completely delete an image (and all of its tags) by specifying the image's
    /// digest in your request.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDeleteImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_image_input::Builder,
    }
    impl<C, M, R> BatchDeleteImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDeleteImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteImageOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeleteImageInputOperationOutputAlias,
                crate::output::BatchDeleteImageOutput,
                crate::error::BatchDeleteImageError,
                crate::input::BatchDeleteImageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the image to delete.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the image to delete.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The repository that contains the image to delete.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The repository that contains the image to delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `imageIds`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>A list of image ID references that correspond to images to delete. The format of the
        /// <code>imageIds</code> reference is <code>imageTag=tag</code> or
        /// <code>imageDigest=digest</code>.</p>
        pub fn image_ids(mut self, inp: impl Into<crate::model::ImageIdentifier>) -> Self {
            self.inner = self.inner.image_ids(inp);
            self
        }
        /// <p>A list of image ID references that correspond to images to delete. The format of the
        /// <code>imageIds</code> reference is <code>imageTag=tag</code> or
        /// <code>imageDigest=digest</code>.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.inner = self.inner.set_image_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetImage`.
    ///
    /// <p>Gets detailed information for an image. Images are specified with either an
    /// <code>imageTag</code> or <code>imageDigest</code>.</p>
    /// <p>When an image is pulled, the BatchGetImage API is called once to retrieve the image
    /// manifest.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_image_input::Builder,
    }
    impl<C, M, R> BatchGetImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetImageOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetImageInputOperationOutputAlias,
                crate::output::BatchGetImageOutput,
                crate::error::BatchGetImageError,
                crate::input::BatchGetImageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the images to
        /// describe. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the images to
        /// describe. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The repository that contains the images to describe.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The repository that contains the images to describe.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `imageIds`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>A list of image ID references that correspond to images to describe. The format of the
        /// <code>imageIds</code> reference is <code>imageTag=tag</code> or
        /// <code>imageDigest=digest</code>.</p>
        pub fn image_ids(mut self, inp: impl Into<crate::model::ImageIdentifier>) -> Self {
            self.inner = self.inner.image_ids(inp);
            self
        }
        /// <p>A list of image ID references that correspond to images to describe. The format of the
        /// <code>imageIds</code> reference is <code>imageTag=tag</code> or
        /// <code>imageDigest=digest</code>.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.inner = self.inner.set_image_ids(input);
            self
        }
        /// Appends an item to `acceptedMediaTypes`.
        ///
        /// To override the contents of this collection use [`set_accepted_media_types`](Self::set_accepted_media_types).
        ///
        /// <p>The accepted media types for the request.</p>
        /// <p>Valid values: <code>application/vnd.docker.distribution.manifest.v1+json</code> |
        /// <code>application/vnd.docker.distribution.manifest.v2+json</code> |
        /// <code>application/vnd.oci.image.manifest.v1+json</code>
        /// </p>
        pub fn accepted_media_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accepted_media_types(inp);
            self
        }
        /// <p>The accepted media types for the request.</p>
        /// <p>Valid values: <code>application/vnd.docker.distribution.manifest.v1+json</code> |
        /// <code>application/vnd.docker.distribution.manifest.v2+json</code> |
        /// <code>application/vnd.oci.image.manifest.v1+json</code>
        /// </p>
        pub fn set_accepted_media_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_accepted_media_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetRepositoryScanningConfiguration`.
    ///
    /// <p>Gets the scanning configuration for one or more repositories.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetRepositoryScanningConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_repository_scanning_configuration_input::Builder,
    }
    impl<C, M, R> BatchGetRepositoryScanningConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetRepositoryScanningConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetRepositoryScanningConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::BatchGetRepositoryScanningConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetRepositoryScanningConfigurationInputOperationOutputAlias,
                crate::output::BatchGetRepositoryScanningConfigurationOutput,
                crate::error::BatchGetRepositoryScanningConfigurationError,
                crate::input::BatchGetRepositoryScanningConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `repositoryNames`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p>One or more repository names to get the scanning configuration for.</p>
        pub fn repository_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_names(inp);
            self
        }
        /// <p>One or more repository names to get the scanning configuration for.</p>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_repository_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CompleteLayerUpload`.
    ///
    /// <p>Informs Amazon ECR that the image layer upload has completed for a specified registry,
    /// repository name, and upload ID. You can optionally provide a <code>sha256</code> digest
    /// of the image layer for data validation purposes.</p>
    /// <p>When an image is pushed, the CompleteLayerUpload API is called once per each new image
    /// layer to verify that the upload has completed.</p>
    /// <note>
    /// <p>This operation is used by the Amazon ECR proxy and is not generally used by
    /// customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CompleteLayerUpload<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::complete_layer_upload_input::Builder,
    }
    impl<C, M, R> CompleteLayerUpload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CompleteLayerUpload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CompleteLayerUploadOutput,
            aws_smithy_http::result::SdkError<crate::error::CompleteLayerUploadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CompleteLayerUploadInputOperationOutputAlias,
                crate::output::CompleteLayerUploadOutput,
                crate::error::CompleteLayerUploadError,
                crate::input::CompleteLayerUploadInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry to which to upload layers.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry to which to upload layers.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to associate with the image layer.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository to associate with the image layer.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
        /// associate with the image layer.</p>
        pub fn upload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.upload_id(inp);
            self
        }
        /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
        /// associate with the image layer.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_upload_id(input);
            self
        }
        /// Appends an item to `layerDigests`.
        ///
        /// To override the contents of this collection use [`set_layer_digests`](Self::set_layer_digests).
        ///
        /// <p>The <code>sha256</code> digest of the image layer.</p>
        pub fn layer_digests(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_digests(inp);
            self
        }
        /// <p>The <code>sha256</code> digest of the image layer.</p>
        pub fn set_layer_digests(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_layer_digests(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePullThroughCacheRule`.
    ///
    /// <p>Creates a pull through cache rule. A pull through cache rule provides a way to cache
    /// images from an external public registry in your Amazon ECR private registry.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePullThroughCacheRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_pull_through_cache_rule_input::Builder,
    }
    impl<C, M, R> CreatePullThroughCacheRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePullThroughCacheRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePullThroughCacheRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePullThroughCacheRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePullThroughCacheRuleInputOperationOutputAlias,
                crate::output::CreatePullThroughCacheRuleOutput,
                crate::error::CreatePullThroughCacheRuleError,
                crate::input::CreatePullThroughCacheRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The repository name prefix to use when caching images from the source registry.</p>
        pub fn ecr_repository_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ecr_repository_prefix(inp);
            self
        }
        /// <p>The repository name prefix to use when caching images from the source registry.</p>
        pub fn set_ecr_repository_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ecr_repository_prefix(input);
            self
        }
        /// <p>The registry URL of the upstream public registry to use as the source for the pull
        /// through cache rule.</p>
        pub fn upstream_registry_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.upstream_registry_url(inp);
            self
        }
        /// <p>The registry URL of the upstream public registry to use as the source for the pull
        /// through cache rule.</p>
        pub fn set_upstream_registry_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_upstream_registry_url(input);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry to create the pull through cache
        /// rule for. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry to create the pull through cache
        /// rule for. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRepository`.
    ///
    /// <p>Creates a repository. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html">Amazon ECR repositories</a> in the
    /// <i>Amazon Elastic Container Registry User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_repository_input::Builder,
    }
    impl<C, M, R> CreateRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRepositoryInputOperationOutputAlias,
                crate::output::CreateRepositoryOutput,
                crate::error::CreateRepositoryError,
                crate::input::CreateRepositoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry to create the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry to create the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name to use for the repository. The repository name may be specified on its own
        /// (such as <code>nginx-web-app</code>) or it can be prepended with a namespace to group
        /// the repository into a category (such as <code>project-a/nginx-web-app</code>).</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name to use for the repository. The repository name may be specified on its own
        /// (such as <code>nginx-web-app</code>) or it can be prepended with a namespace to group
        /// the repository into a category (such as <code>project-a/nginx-web-app</code>).</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the repository to help you categorize and organize
        /// them. Each tag consists of a key and an optional value, both of which you define.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The metadata that you apply to the repository to help you categorize and organize
        /// them. Each tag consists of a key and an optional value, both of which you define.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The tag mutability setting for the repository. If this parameter is omitted, the
        /// default setting of <code>MUTABLE</code> will be used which will allow image tags to be
        /// overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the
        /// repository will be immutable which will prevent them from being overwritten.</p>
        pub fn image_tag_mutability(mut self, inp: crate::model::ImageTagMutability) -> Self {
            self.inner = self.inner.image_tag_mutability(inp);
            self
        }
        /// <p>The tag mutability setting for the repository. If this parameter is omitted, the
        /// default setting of <code>MUTABLE</code> will be used which will allow image tags to be
        /// overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the
        /// repository will be immutable which will prevent them from being overwritten.</p>
        pub fn set_image_tag_mutability(
            mut self,
            input: std::option::Option<crate::model::ImageTagMutability>,
        ) -> Self {
            self.inner = self.inner.set_image_tag_mutability(input);
            self
        }
        /// <p>The image scanning configuration for the repository. This determines whether images
        /// are scanned for known vulnerabilities after being pushed to the repository.</p>
        pub fn image_scanning_configuration(
            mut self,
            inp: crate::model::ImageScanningConfiguration,
        ) -> Self {
            self.inner = self.inner.image_scanning_configuration(inp);
            self
        }
        /// <p>The image scanning configuration for the repository. This determines whether images
        /// are scanned for known vulnerabilities after being pushed to the repository.</p>
        pub fn set_image_scanning_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageScanningConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_image_scanning_configuration(input);
            self
        }
        /// <p>The encryption configuration for the repository. This determines how the contents of
        /// your repository are encrypted at rest.</p>
        pub fn encryption_configuration(
            mut self,
            inp: crate::model::EncryptionConfiguration,
        ) -> Self {
            self.inner = self.inner.encryption_configuration(inp);
            self
        }
        /// <p>The encryption configuration for the repository. This determines how the contents of
        /// your repository are encrypted at rest.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_encryption_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLifecyclePolicy`.
    ///
    /// <p>Deletes the lifecycle policy associated with the specified repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLifecyclePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_lifecycle_policy_input::Builder,
    }
    impl<C, M, R> DeleteLifecyclePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLifecyclePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLifecyclePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLifecyclePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLifecyclePolicyInputOperationOutputAlias,
                crate::output::DeleteLifecyclePolicyOutput,
                crate::error::DeleteLifecyclePolicyError,
                crate::input::DeleteLifecyclePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePullThroughCacheRule`.
    ///
    /// <p>Deletes a pull through cache rule.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePullThroughCacheRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_pull_through_cache_rule_input::Builder,
    }
    impl<C, M, R> DeletePullThroughCacheRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePullThroughCacheRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePullThroughCacheRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePullThroughCacheRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePullThroughCacheRuleInputOperationOutputAlias,
                crate::output::DeletePullThroughCacheRuleOutput,
                crate::error::DeletePullThroughCacheRuleError,
                crate::input::DeletePullThroughCacheRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon ECR repository prefix associated with the pull through cache rule to
        /// delete.</p>
        pub fn ecr_repository_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ecr_repository_prefix(inp);
            self
        }
        /// <p>The Amazon ECR repository prefix associated with the pull through cache rule to
        /// delete.</p>
        pub fn set_ecr_repository_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ecr_repository_prefix(input);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the pull through cache
        /// rule. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the pull through cache
        /// rule. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRegistryPolicy`.
    ///
    /// <p>Deletes the registry permissions policy.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRegistryPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_registry_policy_input::Builder,
    }
    impl<C, M, R> DeleteRegistryPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRegistryPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRegistryPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRegistryPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRegistryPolicyInputOperationOutputAlias,
                crate::output::DeleteRegistryPolicyOutput,
                crate::error::DeleteRegistryPolicyError,
                crate::input::DeleteRegistryPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteRepository`.
    ///
    /// <p>Deletes a repository. If the repository contains images, you must either delete all
    /// images in the repository or use the <code>force</code> option to delete the
    /// repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_repository_input::Builder,
    }
    impl<C, M, R> DeleteRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRepositoryInputOperationOutputAlias,
                crate::output::DeleteRepositoryOutput,
                crate::error::DeleteRepositoryError,
                crate::input::DeleteRepositoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository to
        /// delete. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository to
        /// delete. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to delete.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository to delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p> If a repository contains images, forces the deletion.</p>
        pub fn force(mut self, inp: bool) -> Self {
            self.inner = self.inner.force(inp);
            self
        }
        /// <p> If a repository contains images, forces the deletion.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRepositoryPolicy`.
    ///
    /// <p>Deletes the repository policy associated with the specified repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRepositoryPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_repository_policy_input::Builder,
    }
    impl<C, M, R> DeleteRepositoryPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRepositoryPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRepositoryPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRepositoryPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRepositoryPolicyInputOperationOutputAlias,
                crate::output::DeleteRepositoryPolicyOutput,
                crate::error::DeleteRepositoryPolicyError,
                crate::input::DeleteRepositoryPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository policy
        /// to delete. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository policy
        /// to delete. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository that is associated with the repository policy to
        /// delete.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that is associated with the repository policy to
        /// delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImageReplicationStatus`.
    ///
    /// <p>Returns the replication status for a specified image.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeImageReplicationStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_image_replication_status_input::Builder,
    }
    impl<C, M, R> DescribeImageReplicationStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeImageReplicationStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImageReplicationStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImageReplicationStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeImageReplicationStatusInputOperationOutputAlias,
                crate::output::DescribeImageReplicationStatusOutput,
                crate::error::DescribeImageReplicationStatusError,
                crate::input::DescribeImageReplicationStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that the image is in.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that the image is in.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn image_id(mut self, inp: crate::model::ImageIdentifier) -> Self {
            self.inner = self.inner.image_id(inp);
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn set_image_id(
            mut self,
            input: std::option::Option<crate::model::ImageIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImages`.
    ///
    /// <p>Returns metadata about the images in a repository.</p>
    /// <note>
    /// <p>Beginning with Docker version 1.9, the Docker client compresses image layers
    /// before pushing them to a V2 Docker registry. The output of the <code>docker
    /// images</code> command shows the uncompressed image size, so it may return a
    /// larger image size than the image sizes returned by <a>DescribeImages</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeImages<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_images_input::Builder,
    }
    impl<C, M, R> DescribeImages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeImagesInputOperationOutputAlias,
                crate::output::DescribeImagesOutput,
                crate::error::DescribeImagesError,
                crate::input::DescribeImagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to describe images. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to describe images. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The repository that contains the images to describe.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The repository that contains the images to describe.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `imageIds`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>The list of image IDs for the requested repository.</p>
        pub fn image_ids(mut self, inp: impl Into<crate::model::ImageIdentifier>) -> Self {
            self.inner = self.inner.image_ids(inp);
            self
        }
        /// <p>The list of image IDs for the requested repository.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.inner = self.inner.set_image_ids(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeImages</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be
        /// used when you specify images with <code>imageIds</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeImages</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be
        /// used when you specify images with <code>imageIds</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeImages</code> in
        /// paginated output. When this parameter is used, <code>DescribeImages</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>DescribeImages</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 1000. If this
        /// parameter is not used, then <code>DescribeImages</code> returns up to
        /// 100 results and a <code>nextToken</code> value, if applicable. This
        /// option cannot be used when you specify images with <code>imageIds</code>.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeImages</code> in
        /// paginated output. When this parameter is used, <code>DescribeImages</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>DescribeImages</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 1000. If this
        /// parameter is not used, then <code>DescribeImages</code> returns up to
        /// 100 results and a <code>nextToken</code> value, if applicable. This
        /// option cannot be used when you specify images with <code>imageIds</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The filter key and value with which to filter your <code>DescribeImages</code>
        /// results.</p>
        pub fn filter(mut self, inp: crate::model::DescribeImagesFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>The filter key and value with which to filter your <code>DescribeImages</code>
        /// results.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::DescribeImagesFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImageScanFindings`.
    ///
    /// <p>Returns the scan findings for the specified image.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeImageScanFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_image_scan_findings_input::Builder,
    }
    impl<C, M, R> DescribeImageScanFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeImageScanFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImageScanFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImageScanFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeImageScanFindingsInputOperationOutputAlias,
                crate::output::DescribeImageScanFindingsOutput,
                crate::error::DescribeImageScanFindingsError,
                crate::input::DescribeImageScanFindingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to describe the image scan findings for. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to describe the image scan findings for. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The repository for the image for which to describe the scan findings.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The repository for the image for which to describe the scan findings.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn image_id(mut self, inp: crate::model::ImageIdentifier) -> Self {
            self.inner = self.inner.image_id(inp);
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn set_image_id(
            mut self,
            input: std::option::Option<crate::model::ImageIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeImageScanFindings</code> request where <code>maxResults</code> was
        /// used and the results exceeded the value of that parameter. Pagination continues from the
        /// end of the previous results that returned the <code>nextToken</code> value. This value
        /// is null when there are no more results to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeImageScanFindings</code> request where <code>maxResults</code> was
        /// used and the results exceeded the value of that parameter. Pagination continues from the
        /// end of the previous results that returned the <code>nextToken</code> value. This value
        /// is null when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of image scan results returned by
        /// <code>DescribeImageScanFindings</code> in paginated output. When this parameter is
        /// used, <code>DescribeImageScanFindings</code> only returns <code>maxResults</code>
        /// results in a single page along with a <code>nextToken</code> response element. The
        /// remaining results of the initial request can be seen by sending another
        /// <code>DescribeImageScanFindings</code> request with the returned
        /// <code>nextToken</code> value. This value can be between 1 and 1000. If this
        /// parameter is not used, then <code>DescribeImageScanFindings</code> returns up to 100
        /// results and a <code>nextToken</code> value, if applicable.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of image scan results returned by
        /// <code>DescribeImageScanFindings</code> in paginated output. When this parameter is
        /// used, <code>DescribeImageScanFindings</code> only returns <code>maxResults</code>
        /// results in a single page along with a <code>nextToken</code> response element. The
        /// remaining results of the initial request can be seen by sending another
        /// <code>DescribeImageScanFindings</code> request with the returned
        /// <code>nextToken</code> value. This value can be between 1 and 1000. If this
        /// parameter is not used, then <code>DescribeImageScanFindings</code> returns up to 100
        /// results and a <code>nextToken</code> value, if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePullThroughCacheRules`.
    ///
    /// <p>Returns the pull through cache rules for a registry.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePullThroughCacheRules<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_pull_through_cache_rules_input::Builder,
    }
    impl<C, M, R> DescribePullThroughCacheRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePullThroughCacheRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePullThroughCacheRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePullThroughCacheRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePullThroughCacheRulesInputOperationOutputAlias,
                crate::output::DescribePullThroughCacheRulesOutput,
                crate::error::DescribePullThroughCacheRulesError,
                crate::input::DescribePullThroughCacheRulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry to return the pull through cache
        /// rules for. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry to return the pull through cache
        /// rules for. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// Appends an item to `ecrRepositoryPrefixes`.
        ///
        /// To override the contents of this collection use [`set_ecr_repository_prefixes`](Self::set_ecr_repository_prefixes).
        ///
        /// <p>The Amazon ECR repository prefixes associated with the pull through cache rules to return.
        /// If no repository prefix value is specified, all pull through cache rules are
        /// returned.</p>
        pub fn ecr_repository_prefixes(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ecr_repository_prefixes(inp);
            self
        }
        /// <p>The Amazon ECR repository prefixes associated with the pull through cache rules to return.
        /// If no repository prefix value is specified, all pull through cache rules are
        /// returned.</p>
        pub fn set_ecr_repository_prefixes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ecr_repository_prefixes(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribePullThroughCacheRulesRequest</code> request where
        /// <code>maxResults</code> was used and the results exceeded the value of that
        /// parameter. Pagination continues from the end of the previous results that returned the
        /// <code>nextToken</code> value. This value is null when there are no more results to
        /// return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribePullThroughCacheRulesRequest</code> request where
        /// <code>maxResults</code> was used and the results exceeded the value of that
        /// parameter. Pagination continues from the end of the previous results that returned the
        /// <code>nextToken</code> value. This value is null when there are no more results to
        /// return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of pull through cache rules returned by
        /// <code>DescribePullThroughCacheRulesRequest</code> in paginated output. When this
        /// parameter is used, <code>DescribePullThroughCacheRulesRequest</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>DescribePullThroughCacheRulesRequest</code> request with the returned
        /// <code>nextToken</code> value. This value can be between 1 and 1000. If this
        /// parameter is not used, then <code>DescribePullThroughCacheRulesRequest</code> returns up
        /// to 100 results and a <code>nextToken</code> value, if applicable.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of pull through cache rules returned by
        /// <code>DescribePullThroughCacheRulesRequest</code> in paginated output. When this
        /// parameter is used, <code>DescribePullThroughCacheRulesRequest</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>DescribePullThroughCacheRulesRequest</code> request with the returned
        /// <code>nextToken</code> value. This value can be between 1 and 1000. If this
        /// parameter is not used, then <code>DescribePullThroughCacheRulesRequest</code> returns up
        /// to 100 results and a <code>nextToken</code> value, if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRegistry`.
    ///
    /// <p>Describes the settings for a registry. The replication configuration for a repository
    /// can be created or updated with the <a>PutReplicationConfiguration</a> API
    /// action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRegistry<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_registry_input::Builder,
    }
    impl<C, M, R> DescribeRegistry<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRegistry`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRegistryOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRegistryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRegistryInputOperationOutputAlias,
                crate::output::DescribeRegistryOutput,
                crate::error::DescribeRegistryError,
                crate::input::DescribeRegistryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeRepositories`.
    ///
    /// <p>Describes image repositories in a registry.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRepositories<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_repositories_input::Builder,
    }
    impl<C, M, R> DescribeRepositories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRepositories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRepositoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRepositoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRepositoriesInputOperationOutputAlias,
                crate::output::DescribeRepositoriesOutput,
                crate::error::DescribeRepositoriesError,
                crate::input::DescribeRepositoriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repositories to be
        /// described. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repositories to be
        /// described. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// Appends an item to `repositoryNames`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p>A list of repositories to describe. If this parameter is omitted, then all
        /// repositories in a registry are described.</p>
        pub fn repository_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_names(inp);
            self
        }
        /// <p>A list of repositories to describe. If this parameter is omitted, then all
        /// repositories in a registry are described.</p>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_repository_names(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeRepositories</code> request where <code>maxResults</code> was used and
        /// the results exceeded the value of that parameter. Pagination continues from the end of
        /// the previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be
        /// used when you specify repositories with <code>repositoryNames</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeRepositories</code> request where <code>maxResults</code> was used and
        /// the results exceeded the value of that parameter. Pagination continues from the end of
        /// the previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be
        /// used when you specify repositories with <code>repositoryNames</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeRepositories</code>
        /// in paginated output. When this parameter is used, <code>DescribeRepositories</code> only
        /// returns <code>maxResults</code> results in a single page along with a
        /// <code>nextToken</code> response element. The remaining results of the initial
        /// request can be seen by sending another <code>DescribeRepositories</code> request with
        /// the returned <code>nextToken</code> value. This value can be between 1
        /// and 1000. If this parameter is not used, then
        /// <code>DescribeRepositories</code> returns up to 100 results and a
        /// <code>nextToken</code> value, if applicable. This option cannot be used when you
        /// specify repositories with <code>repositoryNames</code>.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeRepositories</code>
        /// in paginated output. When this parameter is used, <code>DescribeRepositories</code> only
        /// returns <code>maxResults</code> results in a single page along with a
        /// <code>nextToken</code> response element. The remaining results of the initial
        /// request can be seen by sending another <code>DescribeRepositories</code> request with
        /// the returned <code>nextToken</code> value. This value can be between 1
        /// and 1000. If this parameter is not used, then
        /// <code>DescribeRepositories</code> returns up to 100 results and a
        /// <code>nextToken</code> value, if applicable. This option cannot be used when you
        /// specify repositories with <code>repositoryNames</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAuthorizationToken`.
    ///
    /// <p>Retrieves an authorization token. An authorization token represents your IAM
    /// authentication credentials and can be used to access any Amazon ECR registry that your IAM
    /// principal has access to. The authorization token is valid for 12 hours.</p>
    /// <p>The <code>authorizationToken</code> returned is a base64 encoded string that can be
    /// decoded and used in a <code>docker login</code> command to authenticate to a registry.
    /// The CLI offers an <code>get-login-password</code> command that simplifies the login
    /// process. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Registries.html#registry_auth">Registry
    /// authentication</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAuthorizationToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_authorization_token_input::Builder,
    }
    impl<C, M, R> GetAuthorizationToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAuthorizationToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAuthorizationTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAuthorizationTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAuthorizationTokenInputOperationOutputAlias,
                crate::output::GetAuthorizationTokenOutput,
                crate::error::GetAuthorizationTokenError,
                crate::input::GetAuthorizationTokenInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `registryIds`.
        ///
        /// To override the contents of this collection use [`set_registry_ids`](Self::set_registry_ids).
        ///
        /// <p>A list of Amazon Web Services account IDs that are associated with the registries for which to get
        /// AuthorizationData objects. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_ids(inp);
            self
        }
        /// <p>A list of Amazon Web Services account IDs that are associated with the registries for which to get
        /// AuthorizationData objects. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_registry_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDownloadUrlForLayer`.
    ///
    /// <p>Retrieves the pre-signed Amazon S3 download URL corresponding to an image layer. You can
    /// only get URLs for image layers that are referenced in an image.</p>
    /// <p>When an image is pulled, the GetDownloadUrlForLayer API is called once per image layer
    /// that is not already cached.</p>
    /// <note>
    /// <p>This operation is used by the Amazon ECR proxy and is not generally used by
    /// customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetDownloadUrlForLayer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_download_url_for_layer_input::Builder,
    }
    impl<C, M, R> GetDownloadUrlForLayer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDownloadUrlForLayer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDownloadUrlForLayerOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDownloadUrlForLayerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDownloadUrlForLayerInputOperationOutputAlias,
                crate::output::GetDownloadUrlForLayerOutput,
                crate::error::GetDownloadUrlForLayerError,
                crate::input::GetDownloadUrlForLayerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the image layer to
        /// download. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the image layer to
        /// download. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository that is associated with the image layer to download.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that is associated with the image layer to download.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The digest of the image layer to download.</p>
        pub fn layer_digest(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_digest(inp);
            self
        }
        /// <p>The digest of the image layer to download.</p>
        pub fn set_layer_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_layer_digest(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLifecyclePolicy`.
    ///
    /// <p>Retrieves the lifecycle policy for the specified repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLifecyclePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_lifecycle_policy_input::Builder,
    }
    impl<C, M, R> GetLifecyclePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLifecyclePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLifecyclePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLifecyclePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLifecyclePolicyInputOperationOutputAlias,
                crate::output::GetLifecyclePolicyOutput,
                crate::error::GetLifecyclePolicyError,
                crate::input::GetLifecyclePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLifecyclePolicyPreview`.
    ///
    /// <p>Retrieves the results of the lifecycle policy preview request for the specified
    /// repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLifecyclePolicyPreview<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_lifecycle_policy_preview_input::Builder,
    }
    impl<C, M, R> GetLifecyclePolicyPreview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLifecyclePolicyPreview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLifecyclePolicyPreviewOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLifecyclePolicyPreviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLifecyclePolicyPreviewInputOperationOutputAlias,
                crate::output::GetLifecyclePolicyPreviewOutput,
                crate::error::GetLifecyclePolicyPreviewError,
                crate::input::GetLifecyclePolicyPreviewInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `imageIds`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>The list of imageIDs to be included.</p>
        pub fn image_ids(mut self, inp: impl Into<crate::model::ImageIdentifier>) -> Self {
            self.inner = self.inner.image_ids(inp);
            self
        }
        /// <p>The list of imageIDs to be included.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.inner = self.inner.set_image_ids(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>GetLifecyclePolicyPreviewRequest</code> request where <code>maxResults</code>
        /// was used and the  results exceeded the value of that parameter. Pagination continues
        /// from the end of the  previous results that returned the <code>nextToken</code> value.
        /// This value is  <code>null</code> when there are no more results to return. This option
        /// cannot be used when you specify images with <code>imageIds</code>.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>GetLifecyclePolicyPreviewRequest</code> request where <code>maxResults</code>
        /// was used and the  results exceeded the value of that parameter. Pagination continues
        /// from the end of the  previous results that returned the <code>nextToken</code> value.
        /// This value is  <code>null</code> when there are no more results to return. This option
        /// cannot be used when you specify images with <code>imageIds</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of repository results returned by
        /// <code>GetLifecyclePolicyPreviewRequest</code> in  paginated output. When this
        /// parameter is used, <code>GetLifecyclePolicyPreviewRequest</code> only returns
        /// <code>maxResults</code> results in a single page along with a
        /// <code>nextToken</code>  response element. The remaining results of the initial request
        /// can be seen by sending  another <code>GetLifecyclePolicyPreviewRequest</code> request
        /// with the returned <code>nextToken</code>  value. This value can be between
        /// 1 and 1000. If this  parameter is not used, then
        /// <code>GetLifecyclePolicyPreviewRequest</code> returns up to  100
        /// results and a <code>nextToken</code> value, if  applicable. This option cannot be used
        /// when you specify images with <code>imageIds</code>.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of repository results returned by
        /// <code>GetLifecyclePolicyPreviewRequest</code> in  paginated output. When this
        /// parameter is used, <code>GetLifecyclePolicyPreviewRequest</code> only returns
        /// <code>maxResults</code> results in a single page along with a
        /// <code>nextToken</code>  response element. The remaining results of the initial request
        /// can be seen by sending  another <code>GetLifecyclePolicyPreviewRequest</code> request
        /// with the returned <code>nextToken</code>  value. This value can be between
        /// 1 and 1000. If this  parameter is not used, then
        /// <code>GetLifecyclePolicyPreviewRequest</code> returns up to  100
        /// results and a <code>nextToken</code> value, if  applicable. This option cannot be used
        /// when you specify images with <code>imageIds</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An optional parameter that filters results based on image tag status and all tags, if
        /// tagged.</p>
        pub fn filter(mut self, inp: crate::model::LifecyclePolicyPreviewFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>An optional parameter that filters results based on image tag status and all tags, if
        /// tagged.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::LifecyclePolicyPreviewFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRegistryPolicy`.
    ///
    /// <p>Retrieves the permissions policy for a registry.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRegistryPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_registry_policy_input::Builder,
    }
    impl<C, M, R> GetRegistryPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRegistryPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRegistryPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRegistryPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRegistryPolicyInputOperationOutputAlias,
                crate::output::GetRegistryPolicyOutput,
                crate::error::GetRegistryPolicyError,
                crate::input::GetRegistryPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetRegistryScanningConfiguration`.
    ///
    /// <p>Retrieves the scanning configuration for a registry.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRegistryScanningConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_registry_scanning_configuration_input::Builder,
    }
    impl<C, M, R> GetRegistryScanningConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRegistryScanningConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRegistryScanningConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRegistryScanningConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRegistryScanningConfigurationInputOperationOutputAlias,
                crate::output::GetRegistryScanningConfigurationOutput,
                crate::error::GetRegistryScanningConfigurationError,
                crate::input::GetRegistryScanningConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetRepositoryPolicy`.
    ///
    /// <p>Retrieves the repository policy for the specified repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRepositoryPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_repository_policy_input::Builder,
    }
    impl<C, M, R> GetRepositoryPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRepositoryPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRepositoryPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRepositoryPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRepositoryPolicyInputOperationOutputAlias,
                crate::output::GetRepositoryPolicyOutput,
                crate::error::GetRepositoryPolicyError,
                crate::input::GetRepositoryPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository with the policy to retrieve.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository with the policy to retrieve.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InitiateLayerUpload`.
    ///
    /// <p>Notifies Amazon ECR that you intend to upload an image layer.</p>
    /// <p>When an image is pushed, the InitiateLayerUpload API is called once per image layer
    /// that has not already been uploaded. Whether or not an image layer has been uploaded is
    /// determined by the BatchCheckLayerAvailability API action.</p>
    /// <note>
    /// <p>This operation is used by the Amazon ECR proxy and is not generally used by
    /// customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct InitiateLayerUpload<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::initiate_layer_upload_input::Builder,
    }
    impl<C, M, R> InitiateLayerUpload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `InitiateLayerUpload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InitiateLayerUploadOutput,
            aws_smithy_http::result::SdkError<crate::error::InitiateLayerUploadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::InitiateLayerUploadInputOperationOutputAlias,
                crate::output::InitiateLayerUploadOutput,
                crate::error::InitiateLayerUploadError,
                crate::input::InitiateLayerUploadInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry to which you intend to upload
        /// layers. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry to which you intend to upload
        /// layers. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to which you intend to upload layers.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository to which you intend to upload layers.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImages`.
    ///
    /// <p>Lists all the image IDs for the specified repository.</p>
    /// <p>You can filter images based on whether or not they are tagged by using the
    /// <code>tagStatus</code> filter and specifying either <code>TAGGED</code>,
    /// <code>UNTAGGED</code> or <code>ANY</code>. For example, you can filter your results
    /// to return only <code>UNTAGGED</code> images and then pipe that result to a <a>BatchDeleteImage</a> operation to delete them. Or, you can filter your
    /// results to return only <code>TAGGED</code> images to list all of the tags in your
    /// repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListImages<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_images_input::Builder,
    }
    impl<C, M, R> ListImages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListImagesInputOperationOutputAlias,
                crate::output::ListImagesOutput,
                crate::error::ListImagesError,
                crate::input::ListImagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to list images. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to list images. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The repository with image IDs to be listed.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The repository with image IDs to be listed.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListImages</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListImages</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of image results returned by <code>ListImages</code> in paginated
        /// output. When this parameter is used, <code>ListImages</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>ListImages</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 1000. If this parameter is
        /// not used, then <code>ListImages</code> returns up to 100 results and a
        /// <code>nextToken</code> value, if applicable.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of image results returned by <code>ListImages</code> in paginated
        /// output. When this parameter is used, <code>ListImages</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>ListImages</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 1000. If this parameter is
        /// not used, then <code>ListImages</code> returns up to 100 results and a
        /// <code>nextToken</code> value, if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The filter key and value with which to filter your <code>ListImages</code>
        /// results.</p>
        pub fn filter(mut self, inp: crate::model::ListImagesFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>The filter key and value with which to filter your <code>ListImages</code>
        /// results.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ListImagesFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List the tags for an Amazon ECR resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the
        /// only supported resource is an Amazon ECR repository.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the
        /// only supported resource is an Amazon ECR repository.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutImage`.
    ///
    /// <p>Creates or updates the image manifest and tags associated with an image.</p>
    /// <p>When an image is pushed and all new image layers have been uploaded, the PutImage API
    /// is called once to create or update the image manifest and the tags associated with the
    /// image.</p>
    ///
    /// <note>
    /// <p>This operation is used by the Amazon ECR proxy and is not generally used by
    /// customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct PutImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_image_input::Builder,
    }
    impl<C, M, R> PutImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutImageOutput,
            aws_smithy_http::result::SdkError<crate::error::PutImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutImageInputOperationOutputAlias,
                crate::output::PutImageOutput,
                crate::error::PutImageError,
                crate::input::PutImageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to put the image. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to put the image. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository in which to put the image.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository in which to put the image.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The image manifest corresponding to the image to be uploaded.</p>
        pub fn image_manifest(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_manifest(inp);
            self
        }
        /// <p>The image manifest corresponding to the image to be uploaded.</p>
        pub fn set_image_manifest(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_manifest(input);
            self
        }
        /// <p>The media type of the image manifest. If you push an image manifest that does not
        /// contain the <code>mediaType</code> field, you must specify the
        /// <code>imageManifestMediaType</code> in the request.</p>
        pub fn image_manifest_media_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_manifest_media_type(inp);
            self
        }
        /// <p>The media type of the image manifest. If you push an image manifest that does not
        /// contain the <code>mediaType</code> field, you must specify the
        /// <code>imageManifestMediaType</code> in the request.</p>
        pub fn set_image_manifest_media_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_manifest_media_type(input);
            self
        }
        /// <p>The tag to associate with the image. This parameter is required for images that use
        /// the Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.</p>
        pub fn image_tag(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_tag(inp);
            self
        }
        /// <p>The tag to associate with the image. This parameter is required for images that use
        /// the Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.</p>
        pub fn set_image_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_tag(input);
            self
        }
        /// <p>The image digest of the image manifest corresponding to the image.</p>
        pub fn image_digest(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_digest(inp);
            self
        }
        /// <p>The image digest of the image manifest corresponding to the image.</p>
        pub fn set_image_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_digest(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutImageScanningConfiguration`.
    ///
    /// <p>Updates the image scanning configuration for the specified repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutImageScanningConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_image_scanning_configuration_input::Builder,
    }
    impl<C, M, R> PutImageScanningConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutImageScanningConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutImageScanningConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutImageScanningConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutImageScanningConfigurationInputOperationOutputAlias,
                crate::output::PutImageScanningConfigurationOutput,
                crate::error::PutImageScanningConfigurationError,
                crate::input::PutImageScanningConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to update the image scanning configuration setting.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to update the image scanning configuration setting.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository in which to update the image scanning configuration
        /// setting.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository in which to update the image scanning configuration
        /// setting.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The image scanning configuration for the repository. This setting determines whether
        /// images are scanned for known vulnerabilities after being pushed to the
        /// repository.</p>
        pub fn image_scanning_configuration(
            mut self,
            inp: crate::model::ImageScanningConfiguration,
        ) -> Self {
            self.inner = self.inner.image_scanning_configuration(inp);
            self
        }
        /// <p>The image scanning configuration for the repository. This setting determines whether
        /// images are scanned for known vulnerabilities after being pushed to the
        /// repository.</p>
        pub fn set_image_scanning_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageScanningConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_image_scanning_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutImageTagMutability`.
    ///
    /// <p>Updates the image tag mutability settings for the specified repository. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-tag-mutability.html">Image tag
    /// mutability</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutImageTagMutability<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_image_tag_mutability_input::Builder,
    }
    impl<C, M, R> PutImageTagMutability<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutImageTagMutability`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutImageTagMutabilityOutput,
            aws_smithy_http::result::SdkError<crate::error::PutImageTagMutabilityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutImageTagMutabilityInputOperationOutputAlias,
                crate::output::PutImageTagMutabilityOutput,
                crate::error::PutImageTagMutabilityError,
                crate::input::PutImageTagMutabilityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to update the image tag mutability settings. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to update the image tag mutability settings. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository in which to update the image tag mutability
        /// settings.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository in which to update the image tag mutability
        /// settings.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The tag mutability setting for the repository. If <code>MUTABLE</code> is specified,
        /// image tags can be overwritten. If <code>IMMUTABLE</code> is specified, all image tags
        /// within the repository will be immutable which will prevent them from being
        /// overwritten.</p>
        pub fn image_tag_mutability(mut self, inp: crate::model::ImageTagMutability) -> Self {
            self.inner = self.inner.image_tag_mutability(inp);
            self
        }
        /// <p>The tag mutability setting for the repository. If <code>MUTABLE</code> is specified,
        /// image tags can be overwritten. If <code>IMMUTABLE</code> is specified, all image tags
        /// within the repository will be immutable which will prevent them from being
        /// overwritten.</p>
        pub fn set_image_tag_mutability(
            mut self,
            input: std::option::Option<crate::model::ImageTagMutability>,
        ) -> Self {
            self.inner = self.inner.set_image_tag_mutability(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLifecyclePolicy`.
    ///
    /// <p>Creates or updates the lifecycle policy for the specified repository. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html">Lifecycle policy
    /// template</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutLifecyclePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_lifecycle_policy_input::Builder,
    }
    impl<C, M, R> PutLifecyclePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutLifecyclePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLifecyclePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLifecyclePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutLifecyclePolicyInputOperationOutputAlias,
                crate::output::PutLifecyclePolicyOutput,
                crate::error::PutLifecyclePolicyError,
                crate::input::PutLifecyclePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you
        /// do  not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you
        /// do  not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to receive the policy.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository to receive the policy.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The JSON repository policy text to apply to the repository.</p>
        pub fn lifecycle_policy_text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lifecycle_policy_text(inp);
            self
        }
        /// <p>The JSON repository policy text to apply to the repository.</p>
        pub fn set_lifecycle_policy_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_lifecycle_policy_text(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRegistryPolicy`.
    ///
    /// <p>Creates or updates the permissions policy for your registry.</p>
    /// <p>A registry policy is used to specify permissions for another Amazon Web Services account and is used
    /// when configuring cross-account replication. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html">Registry permissions</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutRegistryPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_registry_policy_input::Builder,
    }
    impl<C, M, R> PutRegistryPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRegistryPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRegistryPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRegistryPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRegistryPolicyInputOperationOutputAlias,
                crate::output::PutRegistryPolicyOutput,
                crate::error::PutRegistryPolicyError,
                crate::input::PutRegistryPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The JSON policy text to apply to your registry. The policy text follows the same
        /// format as IAM policy text. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html">Registry
        /// permissions</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
        pub fn policy_text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_text(inp);
            self
        }
        /// <p>The JSON policy text to apply to your registry. The policy text follows the same
        /// format as IAM policy text. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html">Registry
        /// permissions</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
        pub fn set_policy_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_text(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRegistryScanningConfiguration`.
    ///
    /// <p>Creates or updates the scanning configuration for your private registry.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutRegistryScanningConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_registry_scanning_configuration_input::Builder,
    }
    impl<C, M, R> PutRegistryScanningConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRegistryScanningConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRegistryScanningConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRegistryScanningConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRegistryScanningConfigurationInputOperationOutputAlias,
                crate::output::PutRegistryScanningConfigurationOutput,
                crate::error::PutRegistryScanningConfigurationError,
                crate::input::PutRegistryScanningConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The scanning type to set for the registry.</p>
        /// <p>By default, the <code>BASIC</code> scan type is used. When basic scanning is set, you
        /// may specify filters to determine which individual repositories, or all repositories, are
        /// scanned when new images are pushed. Alternatively, you can do manual scans of images
        /// with basic scanning.</p>
        /// <p>When the <code>ENHANCED</code> scan type is set, Amazon Inspector provides automated, continuous
        /// scanning of all repositories in your registry.</p>
        pub fn scan_type(mut self, inp: crate::model::ScanType) -> Self {
            self.inner = self.inner.scan_type(inp);
            self
        }
        /// <p>The scanning type to set for the registry.</p>
        /// <p>By default, the <code>BASIC</code> scan type is used. When basic scanning is set, you
        /// may specify filters to determine which individual repositories, or all repositories, are
        /// scanned when new images are pushed. Alternatively, you can do manual scans of images
        /// with basic scanning.</p>
        /// <p>When the <code>ENHANCED</code> scan type is set, Amazon Inspector provides automated, continuous
        /// scanning of all repositories in your registry.</p>
        pub fn set_scan_type(mut self, input: std::option::Option<crate::model::ScanType>) -> Self {
            self.inner = self.inner.set_scan_type(input);
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The scanning rules to use for the registry. A scanning rule is used to determine which
        /// repository filters are used and at what frequency scanning will occur.</p>
        pub fn rules(mut self, inp: impl Into<crate::model::RegistryScanningRule>) -> Self {
            self.inner = self.inner.rules(inp);
            self
        }
        /// <p>The scanning rules to use for the registry. A scanning rule is used to determine which
        /// repository filters are used and at what frequency scanning will occur.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegistryScanningRule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutReplicationConfiguration`.
    ///
    /// <p>Creates or updates the replication configuration for a registry. The existing
    /// replication configuration for a repository can be retrieved with the <a>DescribeRegistry</a> API action. The first time the
    /// PutReplicationConfiguration API is called, a service-linked IAM role is created in
    /// your account for the replication process. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/using-service-linked-roles.html">Using
    /// service-linked roles for Amazon ECR</a> in the
    /// <i>Amazon Elastic Container Registry User Guide</i>.</p>
    /// <note>
    /// <p>When configuring cross-account replication, the destination account must grant the
    /// source account permission to replicate. This permission is controlled using a
    /// registry permissions policy. For more information, see <a>PutRegistryPolicy</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct PutReplicationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_replication_configuration_input::Builder,
    }
    impl<C, M, R> PutReplicationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutReplicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutReplicationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutReplicationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutReplicationConfigurationInputOperationOutputAlias,
                crate::output::PutReplicationConfigurationOutput,
                crate::error::PutReplicationConfigurationError,
                crate::input::PutReplicationConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An object representing the replication configuration for a registry.</p>
        pub fn replication_configuration(
            mut self,
            inp: crate::model::ReplicationConfiguration,
        ) -> Self {
            self.inner = self.inner.replication_configuration(inp);
            self
        }
        /// <p>An object representing the replication configuration for a registry.</p>
        pub fn set_replication_configuration(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_replication_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetRepositoryPolicy`.
    ///
    /// <p>Applies a repository policy to the specified repository to control access permissions.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html">Amazon ECR Repository
    /// policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetRepositoryPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_repository_policy_input::Builder,
    }
    impl<C, M, R> SetRepositoryPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetRepositoryPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetRepositoryPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::SetRepositoryPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetRepositoryPolicyInputOperationOutputAlias,
                crate::output::SetRepositoryPolicyOutput,
                crate::error::SetRepositoryPolicyError,
                crate::input::SetRepositoryPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to receive the policy.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository to receive the policy.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The JSON repository policy text to apply to the repository. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR repository
        /// policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
        pub fn policy_text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_text(inp);
            self
        }
        /// <p>The JSON repository policy text to apply to the repository. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR repository
        /// policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
        pub fn set_policy_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_text(input);
            self
        }
        /// <p>If the policy you are attempting to set on a repository policy would prevent you from
        /// setting another policy in the future, you must force the <a>SetRepositoryPolicy</a> operation. This is intended to prevent accidental
        /// repository lock outs.</p>
        pub fn force(mut self, inp: bool) -> Self {
            self.inner = self.inner.force(inp);
            self
        }
        /// <p>If the policy you are attempting to set on a repository policy would prevent you from
        /// setting another policy in the future, you must force the <a>SetRepositoryPolicy</a> operation. This is intended to prevent accidental
        /// repository lock outs.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartImageScan`.
    ///
    /// <p>Starts an image vulnerability scan. An image scan can only be started once per 24
    /// hours on an individual image. This limit includes if an image was scanned on initial
    /// push. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html">Image scanning</a> in the
    /// <i>Amazon Elastic Container Registry User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartImageScan<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_image_scan_input::Builder,
    }
    impl<C, M, R> StartImageScan<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartImageScan`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartImageScanOutput,
            aws_smithy_http::result::SdkError<crate::error::StartImageScanError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartImageScanInputOperationOutputAlias,
                crate::output::StartImageScanOutput,
                crate::error::StartImageScanError,
                crate::input::StartImageScanInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to start an image scan request. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to start an image scan request. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository that contains the images to scan.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that contains the images to scan.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn image_id(mut self, inp: crate::model::ImageIdentifier) -> Self {
            self.inner = self.inner.image_id(inp);
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn set_image_id(
            mut self,
            input: std::option::Option<crate::model::ImageIdentifier>,
        ) -> Self {
            self.inner = self.inner.set_image_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartLifecyclePolicyPreview`.
    ///
    /// <p>Starts a preview of a lifecycle policy for the specified repository. This allows you
    /// to see the results before associating the lifecycle policy with the repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartLifecyclePolicyPreview<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_lifecycle_policy_preview_input::Builder,
    }
    impl<C, M, R> StartLifecyclePolicyPreview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartLifecyclePolicyPreview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartLifecyclePolicyPreviewOutput,
            aws_smithy_http::result::SdkError<crate::error::StartLifecyclePolicyPreviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartLifecyclePolicyPreviewInputOperationOutputAlias,
                crate::output::StartLifecyclePolicyPreviewOutput,
                crate::error::StartLifecyclePolicyPreviewError,
                crate::input::StartLifecyclePolicyPreviewInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to be evaluated.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository to be evaluated.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The policy to be evaluated against. If you do not specify a policy, the current policy
        /// for the repository is used.</p>
        pub fn lifecycle_policy_text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lifecycle_policy_text(inp);
            self
        }
        /// <p>The policy to be evaluated against. If you do not specify a policy, the current policy
        /// for the repository is used.</p>
        pub fn set_lifecycle_policy_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_lifecycle_policy_text(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds specified tags to a resource with the specified ARN. Existing tags on a resource
    /// are not changed if they are not specified in the request parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the the resource to which to add tags. Currently, the only supported
        /// resource is an Amazon ECR repository.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the the resource to which to add tags. Currently, the only supported
        /// resource is an Amazon ECR repository.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes specified tags from a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which to remove tags. Currently, the only supported
        /// resource is an Amazon ECR repository.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which to remove tags. Currently, the only supported
        /// resource is an Amazon ECR repository.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UploadLayerPart`.
    ///
    /// <p>Uploads an image layer part to Amazon ECR.</p>
    /// <p>When an image is pushed, each new image layer is uploaded in parts. The maximum size
    /// of each image layer part can be 20971520 bytes (or about 20MB). The UploadLayerPart API
    /// is called once per each new image layer part.</p>
    /// <note>
    /// <p>This operation is used by the Amazon ECR proxy and is not generally used by
    /// customers for pulling and pushing images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UploadLayerPart<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::upload_layer_part_input::Builder,
    }
    impl<C, M, R> UploadLayerPart<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UploadLayerPart`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UploadLayerPartOutput,
            aws_smithy_http::result::SdkError<crate::error::UploadLayerPartError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UploadLayerPartInputOperationOutputAlias,
                crate::output::UploadLayerPartOutput,
                crate::error::UploadLayerPartError,
                crate::input::UploadLayerPartInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the registry to which you are uploading layer
        /// parts. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.registry_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry to which you are uploading layer
        /// parts. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_registry_id(input);
            self
        }
        /// <p>The name of the repository to which you are uploading layer parts.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository to which you are uploading layer parts.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
        /// associate with the layer part upload.</p>
        pub fn upload_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.upload_id(inp);
            self
        }
        /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
        /// associate with the layer part upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_upload_id(input);
            self
        }
        /// <p>The position of the first byte of the layer part witin the overall image layer.</p>
        pub fn part_first_byte(mut self, inp: i64) -> Self {
            self.inner = self.inner.part_first_byte(inp);
            self
        }
        /// <p>The position of the first byte of the layer part witin the overall image layer.</p>
        pub fn set_part_first_byte(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_part_first_byte(input);
            self
        }
        /// <p>The position of the last byte of the layer part within the overall image layer.</p>
        pub fn part_last_byte(mut self, inp: i64) -> Self {
            self.inner = self.inner.part_last_byte(inp);
            self
        }
        /// <p>The position of the last byte of the layer part within the overall image layer.</p>
        pub fn set_part_last_byte(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_part_last_byte(input);
            self
        }
        /// <p>The base64-encoded layer part payload.</p>
        pub fn layer_part_blob(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.layer_part_blob(inp);
            self
        }
        /// <p>The base64-encoded layer part payload.</p>
        pub fn set_layer_part_blob(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_layer_part_blob(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
