// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchCheckLayerAvailabilityInput`](crate::input::BatchCheckLayerAvailabilityInput)
pub mod batch_check_layer_availability_input {
    /// A builder for [`BatchCheckLayerAvailabilityInput`](crate::input::BatchCheckLayerAvailabilityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) layer_digests: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the image layers to
        /// check. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the image layers to
        /// check. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository that is associated with the image layers to check.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that is associated with the image layers to check.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Appends an item to `layer_digests`.
        ///
        /// To override the contents of this collection use [`set_layer_digests`](Self::set_layer_digests).
        ///
        /// <p>The digests of the image layers to check.</p>
        pub fn layer_digests(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.layer_digests.unwrap_or_default();
            v.push(input.into());
            self.layer_digests = Some(v);
            self
        }
        /// <p>The digests of the image layers to check.</p>
        pub fn set_layer_digests(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.layer_digests = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCheckLayerAvailabilityInput`](crate::input::BatchCheckLayerAvailabilityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchCheckLayerAvailabilityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchCheckLayerAvailabilityInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                layer_digests: self.layer_digests,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchCheckLayerAvailabilityInputOperationOutputAlias =
    crate::operation::BatchCheckLayerAvailability;
#[doc(hidden)]
pub type BatchCheckLayerAvailabilityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchCheckLayerAvailabilityInput {
    /// Consumes the builder and constructs an Operation<[`BatchCheckLayerAvailability`](crate::operation::BatchCheckLayerAvailability)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchCheckLayerAvailability,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchCheckLayerAvailabilityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchCheckLayerAvailabilityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchCheckLayerAvailabilityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.BatchCheckLayerAvailability",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_check_layer_availability(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchCheckLayerAvailability::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchCheckLayerAvailability",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchCheckLayerAvailabilityInput`](crate::input::BatchCheckLayerAvailabilityInput)
    pub fn builder() -> crate::input::batch_check_layer_availability_input::Builder {
        crate::input::batch_check_layer_availability_input::Builder::default()
    }
}

/// See [`BatchDeleteImageInput`](crate::input::BatchDeleteImageInput)
pub mod batch_delete_image_input {
    /// A builder for [`BatchDeleteImageInput`](crate::input::BatchDeleteImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_ids: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the image to delete.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the image to delete.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository that contains the image to delete.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository that contains the image to delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Appends an item to `image_ids`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>A list of image ID references that correspond to images to delete. The format of the
        /// <code>imageIds</code> reference is <code>imageTag=tag</code> or
        /// <code>imageDigest=digest</code>.</p>
        pub fn image_ids(mut self, input: impl Into<crate::model::ImageIdentifier>) -> Self {
            let mut v = self.image_ids.unwrap_or_default();
            v.push(input.into());
            self.image_ids = Some(v);
            self
        }
        /// <p>A list of image ID references that correspond to images to delete. The format of the
        /// <code>imageIds</code> reference is <code>imageTag=tag</code> or
        /// <code>imageDigest=digest</code>.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.image_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteImageInput`](crate::input::BatchDeleteImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDeleteImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDeleteImageInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                image_ids: self.image_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDeleteImageInputOperationOutputAlias = crate::operation::BatchDeleteImage;
#[doc(hidden)]
pub type BatchDeleteImageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchDeleteImageInput {
    /// Consumes the builder and constructs an Operation<[`BatchDeleteImage`](crate::operation::BatchDeleteImage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDeleteImage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDeleteImageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDeleteImageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDeleteImageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.BatchDeleteImage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_delete_image(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDeleteImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDeleteImage",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDeleteImageInput`](crate::input::BatchDeleteImageInput)
    pub fn builder() -> crate::input::batch_delete_image_input::Builder {
        crate::input::batch_delete_image_input::Builder::default()
    }
}

/// See [`BatchGetImageInput`](crate::input::BatchGetImageInput)
pub mod batch_get_image_input {
    /// A builder for [`BatchGetImageInput`](crate::input::BatchGetImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_ids: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        pub(crate) accepted_media_types: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the images to
        /// describe. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the images to
        /// describe. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository that contains the images to describe.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository that contains the images to describe.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Appends an item to `image_ids`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>A list of image ID references that correspond to images to describe. The format of the
        /// <code>imageIds</code> reference is <code>imageTag=tag</code> or
        /// <code>imageDigest=digest</code>.</p>
        pub fn image_ids(mut self, input: impl Into<crate::model::ImageIdentifier>) -> Self {
            let mut v = self.image_ids.unwrap_or_default();
            v.push(input.into());
            self.image_ids = Some(v);
            self
        }
        /// <p>A list of image ID references that correspond to images to describe. The format of the
        /// <code>imageIds</code> reference is <code>imageTag=tag</code> or
        /// <code>imageDigest=digest</code>.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.image_ids = input;
            self
        }
        /// Appends an item to `accepted_media_types`.
        ///
        /// To override the contents of this collection use [`set_accepted_media_types`](Self::set_accepted_media_types).
        ///
        /// <p>The accepted media types for the request.</p>
        /// <p>Valid values: <code>application/vnd.docker.distribution.manifest.v1+json</code> |
        /// <code>application/vnd.docker.distribution.manifest.v2+json</code> |
        /// <code>application/vnd.oci.image.manifest.v1+json</code>
        /// </p>
        pub fn accepted_media_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.accepted_media_types.unwrap_or_default();
            v.push(input.into());
            self.accepted_media_types = Some(v);
            self
        }
        /// <p>The accepted media types for the request.</p>
        /// <p>Valid values: <code>application/vnd.docker.distribution.manifest.v1+json</code> |
        /// <code>application/vnd.docker.distribution.manifest.v2+json</code> |
        /// <code>application/vnd.oci.image.manifest.v1+json</code>
        /// </p>
        pub fn set_accepted_media_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.accepted_media_types = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetImageInput`](crate::input::BatchGetImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetImageInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                image_ids: self.image_ids,
                accepted_media_types: self.accepted_media_types,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetImageInputOperationOutputAlias = crate::operation::BatchGetImage;
#[doc(hidden)]
pub type BatchGetImageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchGetImageInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetImage`](crate::operation::BatchGetImage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetImage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGetImageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGetImageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGetImageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.BatchGetImage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_get_image(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetImage",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGetImageInput`](crate::input::BatchGetImageInput)
    pub fn builder() -> crate::input::batch_get_image_input::Builder {
        crate::input::batch_get_image_input::Builder::default()
    }
}

/// See [`CompleteLayerUploadInput`](crate::input::CompleteLayerUploadInput)
pub mod complete_layer_upload_input {
    /// A builder for [`CompleteLayerUploadInput`](crate::input::CompleteLayerUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) layer_digests: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry to which to upload layers.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry to which to upload layers.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository to associate with the image layer.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to associate with the image layer.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
        /// associate with the image layer.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
        /// associate with the image layer.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// Appends an item to `layer_digests`.
        ///
        /// To override the contents of this collection use [`set_layer_digests`](Self::set_layer_digests).
        ///
        /// <p>The <code>sha256</code> digest of the image layer.</p>
        pub fn layer_digests(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.layer_digests.unwrap_or_default();
            v.push(input.into());
            self.layer_digests = Some(v);
            self
        }
        /// <p>The <code>sha256</code> digest of the image layer.</p>
        pub fn set_layer_digests(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.layer_digests = input;
            self
        }
        /// Consumes the builder and constructs a [`CompleteLayerUploadInput`](crate::input::CompleteLayerUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CompleteLayerUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CompleteLayerUploadInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                upload_id: self.upload_id,
                layer_digests: self.layer_digests,
            })
        }
    }
}
#[doc(hidden)]
pub type CompleteLayerUploadInputOperationOutputAlias = crate::operation::CompleteLayerUpload;
#[doc(hidden)]
pub type CompleteLayerUploadInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CompleteLayerUploadInput {
    /// Consumes the builder and constructs an Operation<[`CompleteLayerUpload`](crate::operation::CompleteLayerUpload)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CompleteLayerUpload,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CompleteLayerUploadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CompleteLayerUploadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CompleteLayerUploadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.CompleteLayerUpload",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_complete_layer_upload(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CompleteLayerUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CompleteLayerUpload",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CompleteLayerUploadInput`](crate::input::CompleteLayerUploadInput)
    pub fn builder() -> crate::input::complete_layer_upload_input::Builder {
        crate::input::complete_layer_upload_input::Builder::default()
    }
}

/// See [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
pub mod create_repository_input {
    /// A builder for [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) image_tag_mutability: std::option::Option<crate::model::ImageTagMutability>,
        pub(crate) image_scanning_configuration:
            std::option::Option<crate::model::ImageScanningConfiguration>,
        pub(crate) encryption_configuration:
            std::option::Option<crate::model::EncryptionConfiguration>,
    }
    impl Builder {
        /// <p>The AWS account ID associated with the registry to create the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID associated with the registry to create the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name to use for the repository. The repository name may be specified on its own
        /// (such as <code>nginx-web-app</code>) or it can be prepended with a namespace to group
        /// the repository into a category (such as <code>project-a/nginx-web-app</code>).</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name to use for the repository. The repository name may be specified on its own
        /// (such as <code>nginx-web-app</code>) or it can be prepended with a namespace to group
        /// the repository into a category (such as <code>project-a/nginx-web-app</code>).</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the repository to help you categorize and organize
        /// them. Each tag consists of a key and an optional value, both of which you define.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The metadata that you apply to the repository to help you categorize and organize
        /// them. Each tag consists of a key and an optional value, both of which you define.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The tag mutability setting for the repository. If this parameter is omitted, the
        /// default setting of <code>MUTABLE</code> will be used which will allow image tags to be
        /// overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the
        /// repository will be immutable which will prevent them from being overwritten.</p>
        pub fn image_tag_mutability(mut self, input: crate::model::ImageTagMutability) -> Self {
            self.image_tag_mutability = Some(input);
            self
        }
        /// <p>The tag mutability setting for the repository. If this parameter is omitted, the
        /// default setting of <code>MUTABLE</code> will be used which will allow image tags to be
        /// overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the
        /// repository will be immutable which will prevent them from being overwritten.</p>
        pub fn set_image_tag_mutability(
            mut self,
            input: std::option::Option<crate::model::ImageTagMutability>,
        ) -> Self {
            self.image_tag_mutability = input;
            self
        }
        /// <p>The image scanning configuration for the repository. This determines whether images
        /// are scanned for known vulnerabilities after being pushed to the repository.</p>
        pub fn image_scanning_configuration(
            mut self,
            input: crate::model::ImageScanningConfiguration,
        ) -> Self {
            self.image_scanning_configuration = Some(input);
            self
        }
        /// <p>The image scanning configuration for the repository. This determines whether images
        /// are scanned for known vulnerabilities after being pushed to the repository.</p>
        pub fn set_image_scanning_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageScanningConfiguration>,
        ) -> Self {
            self.image_scanning_configuration = input;
            self
        }
        /// <p>The encryption configuration for the repository. This determines how the contents of
        /// your repository are encrypted at rest.</p>
        pub fn encryption_configuration(
            mut self,
            input: crate::model::EncryptionConfiguration,
        ) -> Self {
            self.encryption_configuration = Some(input);
            self
        }
        /// <p>The encryption configuration for the repository. This determines how the contents of
        /// your repository are encrypted at rest.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfiguration>,
        ) -> Self {
            self.encryption_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRepositoryInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                tags: self.tags,
                image_tag_mutability: self.image_tag_mutability,
                image_scanning_configuration: self.image_scanning_configuration,
                encryption_configuration: self.encryption_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRepositoryInputOperationOutputAlias = crate::operation::CreateRepository;
#[doc(hidden)]
pub type CreateRepositoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`CreateRepository`](crate::operation::CreateRepository)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRepository,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.CreateRepository",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_repository(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRepository",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
    pub fn builder() -> crate::input::create_repository_input::Builder {
        crate::input::create_repository_input::Builder::default()
    }
}

/// See [`DeleteLifecyclePolicyInput`](crate::input::DeleteLifecyclePolicyInput)
pub mod delete_lifecycle_policy_input {
    /// A builder for [`DeleteLifecyclePolicyInput`](crate::input::DeleteLifecyclePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLifecyclePolicyInput`](crate::input::DeleteLifecyclePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLifecyclePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLifecyclePolicyInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLifecyclePolicyInputOperationOutputAlias = crate::operation::DeleteLifecyclePolicy;
#[doc(hidden)]
pub type DeleteLifecyclePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteLifecyclePolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLifecyclePolicy`](crate::operation::DeleteLifecyclePolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLifecyclePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteLifecyclePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteLifecyclePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteLifecyclePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.DeleteLifecyclePolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_lifecycle_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLifecyclePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLifecyclePolicy",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteLifecyclePolicyInput`](crate::input::DeleteLifecyclePolicyInput)
    pub fn builder() -> crate::input::delete_lifecycle_policy_input::Builder {
        crate::input::delete_lifecycle_policy_input::Builder::default()
    }
}

/// See [`DeleteRegistryPolicyInput`](crate::input::DeleteRegistryPolicyInput)
pub mod delete_registry_policy_input {
    /// A builder for [`DeleteRegistryPolicyInput`](crate::input::DeleteRegistryPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRegistryPolicyInput`](crate::input::DeleteRegistryPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRegistryPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRegistryPolicyInput {})
        }
    }
}
#[doc(hidden)]
pub type DeleteRegistryPolicyInputOperationOutputAlias = crate::operation::DeleteRegistryPolicy;
#[doc(hidden)]
pub type DeleteRegistryPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRegistryPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRegistryPolicy`](crate::operation::DeleteRegistryPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRegistryPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRegistryPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRegistryPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRegistryPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.DeleteRegistryPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_registry_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRegistryPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRegistryPolicy",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRegistryPolicyInput`](crate::input::DeleteRegistryPolicyInput)
    pub fn builder() -> crate::input::delete_registry_policy_input::Builder {
        crate::input::delete_registry_policy_input::Builder::default()
    }
}

/// See [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
pub mod delete_repository_input {
    /// A builder for [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) force: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository to
        /// delete. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository to
        /// delete. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository to delete.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p> If a repository contains images, forces the deletion.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p> If a repository contains images, forces the deletion.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRepositoryInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                force: self.force.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRepositoryInputOperationOutputAlias = crate::operation::DeleteRepository;
#[doc(hidden)]
pub type DeleteRepositoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRepository`](crate::operation::DeleteRepository)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRepository,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.DeleteRepository",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_repository(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRepository",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
    pub fn builder() -> crate::input::delete_repository_input::Builder {
        crate::input::delete_repository_input::Builder::default()
    }
}

/// See [`DeleteRepositoryPolicyInput`](crate::input::DeleteRepositoryPolicyInput)
pub mod delete_repository_policy_input {
    /// A builder for [`DeleteRepositoryPolicyInput`](crate::input::DeleteRepositoryPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository policy
        /// to delete. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository policy
        /// to delete. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository that is associated with the repository policy to
        /// delete.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that is associated with the repository policy to
        /// delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRepositoryPolicyInput`](crate::input::DeleteRepositoryPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRepositoryPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRepositoryPolicyInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRepositoryPolicyInputOperationOutputAlias = crate::operation::DeleteRepositoryPolicy;
#[doc(hidden)]
pub type DeleteRepositoryPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRepositoryPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRepositoryPolicy`](crate::operation::DeleteRepositoryPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRepositoryPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRepositoryPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRepositoryPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRepositoryPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.DeleteRepositoryPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_repository_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRepositoryPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRepositoryPolicy",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryPolicyInput`](crate::input::DeleteRepositoryPolicyInput)
    pub fn builder() -> crate::input::delete_repository_policy_input::Builder {
        crate::input::delete_repository_policy_input::Builder::default()
    }
}

/// See [`DescribeImageReplicationStatusInput`](crate::input::DescribeImageReplicationStatusInput)
pub mod describe_image_replication_status_input {
    /// A builder for [`DescribeImageReplicationStatusInput`](crate::input::DescribeImageReplicationStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_id: std::option::Option<crate::model::ImageIdentifier>,
        pub(crate) registry_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository that the image is in.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that the image is in.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn image_id(mut self, input: crate::model::ImageIdentifier) -> Self {
            self.image_id = Some(input);
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn set_image_id(
            mut self,
            input: std::option::Option<crate::model::ImageIdentifier>,
        ) -> Self {
            self.image_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImageReplicationStatusInput`](crate::input::DescribeImageReplicationStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeImageReplicationStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeImageReplicationStatusInput {
                repository_name: self.repository_name,
                image_id: self.image_id,
                registry_id: self.registry_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeImageReplicationStatusInputOperationOutputAlias =
    crate::operation::DescribeImageReplicationStatus;
#[doc(hidden)]
pub type DescribeImageReplicationStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeImageReplicationStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeImageReplicationStatus`](crate::operation::DescribeImageReplicationStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeImageReplicationStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeImageReplicationStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeImageReplicationStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeImageReplicationStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.DescribeImageReplicationStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_image_replication_status(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeImageReplicationStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeImageReplicationStatus",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeImageReplicationStatusInput`](crate::input::DescribeImageReplicationStatusInput)
    pub fn builder() -> crate::input::describe_image_replication_status_input::Builder {
        crate::input::describe_image_replication_status_input::Builder::default()
    }
}

/// See [`DescribeImagesInput`](crate::input::DescribeImagesInput)
pub mod describe_images_input {
    /// A builder for [`DescribeImagesInput`](crate::input::DescribeImagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_ids: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filter: std::option::Option<crate::model::DescribeImagesFilter>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to describe images. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to describe images. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository that contains the images to describe.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository that contains the images to describe.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Appends an item to `image_ids`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>The list of image IDs for the requested repository.</p>
        pub fn image_ids(mut self, input: impl Into<crate::model::ImageIdentifier>) -> Self {
            let mut v = self.image_ids.unwrap_or_default();
            v.push(input.into());
            self.image_ids = Some(v);
            self
        }
        /// <p>The list of image IDs for the requested repository.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.image_ids = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeImages</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be
        /// used when you specify images with <code>imageIds</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeImages</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be
        /// used when you specify images with <code>imageIds</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeImages</code> in
        /// paginated output. When this parameter is used, <code>DescribeImages</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>DescribeImages</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 1000. If this
        /// parameter is not used, then <code>DescribeImages</code> returns up to
        /// 100 results and a <code>nextToken</code> value, if applicable. This
        /// option cannot be used when you specify images with <code>imageIds</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeImages</code> in
        /// paginated output. When this parameter is used, <code>DescribeImages</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>DescribeImages</code> request with the returned <code>nextToken</code>
        /// value. This value can be between 1 and 1000. If this
        /// parameter is not used, then <code>DescribeImages</code> returns up to
        /// 100 results and a <code>nextToken</code> value, if applicable. This
        /// option cannot be used when you specify images with <code>imageIds</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The filter key and value with which to filter your <code>DescribeImages</code>
        /// results.</p>
        pub fn filter(mut self, input: crate::model::DescribeImagesFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>The filter key and value with which to filter your <code>DescribeImages</code>
        /// results.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::DescribeImagesFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImagesInput`](crate::input::DescribeImagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeImagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeImagesInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                image_ids: self.image_ids,
                next_token: self.next_token,
                max_results: self.max_results,
                filter: self.filter,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeImagesInputOperationOutputAlias = crate::operation::DescribeImages;
#[doc(hidden)]
pub type DescribeImagesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeImagesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeImages`](crate::operation::DescribeImages)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeImages,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeImagesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeImagesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeImagesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.DescribeImages",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_images(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeImages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeImages",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeImagesInput`](crate::input::DescribeImagesInput)
    pub fn builder() -> crate::input::describe_images_input::Builder {
        crate::input::describe_images_input::Builder::default()
    }
}

/// See [`DescribeImageScanFindingsInput`](crate::input::DescribeImageScanFindingsInput)
pub mod describe_image_scan_findings_input {
    /// A builder for [`DescribeImageScanFindingsInput`](crate::input::DescribeImageScanFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_id: std::option::Option<crate::model::ImageIdentifier>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to describe the image scan findings for. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to describe the image scan findings for. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository for the image for which to describe the scan findings.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository for the image for which to describe the scan findings.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn image_id(mut self, input: crate::model::ImageIdentifier) -> Self {
            self.image_id = Some(input);
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn set_image_id(
            mut self,
            input: std::option::Option<crate::model::ImageIdentifier>,
        ) -> Self {
            self.image_id = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeImageScanFindings</code> request where <code>maxResults</code> was
        /// used and the results exceeded the value of that parameter. Pagination continues from the
        /// end of the previous results that returned the <code>nextToken</code> value. This value
        /// is null when there are no more results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeImageScanFindings</code> request where <code>maxResults</code> was
        /// used and the results exceeded the value of that parameter. Pagination continues from the
        /// end of the previous results that returned the <code>nextToken</code> value. This value
        /// is null when there are no more results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of image scan results returned by
        /// <code>DescribeImageScanFindings</code> in paginated output. When this parameter is
        /// used, <code>DescribeImageScanFindings</code> only returns <code>maxResults</code>
        /// results in a single page along with a <code>nextToken</code> response element. The
        /// remaining results of the initial request can be seen by sending another
        /// <code>DescribeImageScanFindings</code> request with the returned
        /// <code>nextToken</code> value. This value can be between 1 and 1000. If this
        /// parameter is not used, then <code>DescribeImageScanFindings</code> returns up to 100
        /// results and a <code>nextToken</code> value, if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of image scan results returned by
        /// <code>DescribeImageScanFindings</code> in paginated output. When this parameter is
        /// used, <code>DescribeImageScanFindings</code> only returns <code>maxResults</code>
        /// results in a single page along with a <code>nextToken</code> response element. The
        /// remaining results of the initial request can be seen by sending another
        /// <code>DescribeImageScanFindings</code> request with the returned
        /// <code>nextToken</code> value. This value can be between 1 and 1000. If this
        /// parameter is not used, then <code>DescribeImageScanFindings</code> returns up to 100
        /// results and a <code>nextToken</code> value, if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImageScanFindingsInput`](crate::input::DescribeImageScanFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeImageScanFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeImageScanFindingsInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                image_id: self.image_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeImageScanFindingsInputOperationOutputAlias =
    crate::operation::DescribeImageScanFindings;
#[doc(hidden)]
pub type DescribeImageScanFindingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeImageScanFindingsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeImageScanFindings`](crate::operation::DescribeImageScanFindings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeImageScanFindings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeImageScanFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeImageScanFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeImageScanFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.DescribeImageScanFindings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_image_scan_findings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeImageScanFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeImageScanFindings",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeImageScanFindingsInput`](crate::input::DescribeImageScanFindingsInput)
    pub fn builder() -> crate::input::describe_image_scan_findings_input::Builder {
        crate::input::describe_image_scan_findings_input::Builder::default()
    }
}

/// See [`DescribeRegistryInput`](crate::input::DescribeRegistryInput)
pub mod describe_registry_input {
    /// A builder for [`DescribeRegistryInput`](crate::input::DescribeRegistryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeRegistryInput`](crate::input::DescribeRegistryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRegistryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRegistryInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeRegistryInputOperationOutputAlias = crate::operation::DescribeRegistry;
#[doc(hidden)]
pub type DescribeRegistryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRegistryInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRegistry`](crate::operation::DescribeRegistry)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRegistry,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRegistryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRegistryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRegistryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.DescribeRegistry",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_registry(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRegistry::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRegistry",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRegistryInput`](crate::input::DescribeRegistryInput)
    pub fn builder() -> crate::input::describe_registry_input::Builder {
        crate::input::describe_registry_input::Builder::default()
    }
}

/// See [`DescribeRepositoriesInput`](crate::input::DescribeRepositoriesInput)
pub mod describe_repositories_input {
    /// A builder for [`DescribeRepositoriesInput`](crate::input::DescribeRepositoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repositories to be
        /// described. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repositories to be
        /// described. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// Appends an item to `repository_names`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p>A list of repositories to describe. If this parameter is omitted, then all
        /// repositories in a registry are described.</p>
        pub fn repository_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.repository_names.unwrap_or_default();
            v.push(input.into());
            self.repository_names = Some(v);
            self
        }
        /// <p>A list of repositories to describe. If this parameter is omitted, then all
        /// repositories in a registry are described.</p>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.repository_names = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeRepositories</code> request where <code>maxResults</code> was used and
        /// the results exceeded the value of that parameter. Pagination continues from the end of
        /// the previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be
        /// used when you specify repositories with <code>repositoryNames</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>DescribeRepositories</code> request where <code>maxResults</code> was used and
        /// the results exceeded the value of that parameter. Pagination continues from the end of
        /// the previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return. This option cannot be
        /// used when you specify repositories with <code>repositoryNames</code>.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeRepositories</code>
        /// in paginated output. When this parameter is used, <code>DescribeRepositories</code> only
        /// returns <code>maxResults</code> results in a single page along with a
        /// <code>nextToken</code> response element. The remaining results of the initial
        /// request can be seen by sending another <code>DescribeRepositories</code> request with
        /// the returned <code>nextToken</code> value. This value can be between 1
        /// and 1000. If this parameter is not used, then
        /// <code>DescribeRepositories</code> returns up to 100 results and a
        /// <code>nextToken</code> value, if applicable. This option cannot be used when you
        /// specify repositories with <code>repositoryNames</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of repository results returned by <code>DescribeRepositories</code>
        /// in paginated output. When this parameter is used, <code>DescribeRepositories</code> only
        /// returns <code>maxResults</code> results in a single page along with a
        /// <code>nextToken</code> response element. The remaining results of the initial
        /// request can be seen by sending another <code>DescribeRepositories</code> request with
        /// the returned <code>nextToken</code> value. This value can be between 1
        /// and 1000. If this parameter is not used, then
        /// <code>DescribeRepositories</code> returns up to 100 results and a
        /// <code>nextToken</code> value, if applicable. This option cannot be used when you
        /// specify repositories with <code>repositoryNames</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRepositoriesInput`](crate::input::DescribeRepositoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRepositoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRepositoriesInput {
                registry_id: self.registry_id,
                repository_names: self.repository_names,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRepositoriesInputOperationOutputAlias = crate::operation::DescribeRepositories;
#[doc(hidden)]
pub type DescribeRepositoriesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRepositoriesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRepositories`](crate::operation::DescribeRepositories)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRepositories,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRepositoriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRepositoriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRepositoriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.DescribeRepositories",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_repositories(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRepositories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRepositories",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRepositoriesInput`](crate::input::DescribeRepositoriesInput)
    pub fn builder() -> crate::input::describe_repositories_input::Builder {
        crate::input::describe_repositories_input::Builder::default()
    }
}

/// See [`GetAuthorizationTokenInput`](crate::input::GetAuthorizationTokenInput)
pub mod get_authorization_token_input {
    /// A builder for [`GetAuthorizationTokenInput`](crate::input::GetAuthorizationTokenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `registry_ids`.
        ///
        /// To override the contents of this collection use [`set_registry_ids`](Self::set_registry_ids).
        ///
        /// <p>A list of Amazon Web Services account IDs that are associated with the registries for which to get
        /// AuthorizationData objects. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.registry_ids.unwrap_or_default();
            v.push(input.into());
            self.registry_ids = Some(v);
            self
        }
        /// <p>A list of Amazon Web Services account IDs that are associated with the registries for which to get
        /// AuthorizationData objects. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.registry_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAuthorizationTokenInput`](crate::input::GetAuthorizationTokenInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAuthorizationTokenInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAuthorizationTokenInput {
                registry_ids: self.registry_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAuthorizationTokenInputOperationOutputAlias = crate::operation::GetAuthorizationToken;
#[doc(hidden)]
pub type GetAuthorizationTokenInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAuthorizationTokenInput {
    /// Consumes the builder and constructs an Operation<[`GetAuthorizationToken`](crate::operation::GetAuthorizationToken)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAuthorizationToken,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAuthorizationTokenInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAuthorizationTokenInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAuthorizationTokenInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.GetAuthorizationToken",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_authorization_token(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAuthorizationToken::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAuthorizationToken",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAuthorizationTokenInput`](crate::input::GetAuthorizationTokenInput)
    pub fn builder() -> crate::input::get_authorization_token_input::Builder {
        crate::input::get_authorization_token_input::Builder::default()
    }
}

/// See [`GetDownloadUrlForLayerInput`](crate::input::GetDownloadUrlForLayerInput)
pub mod get_download_url_for_layer_input {
    /// A builder for [`GetDownloadUrlForLayerInput`](crate::input::GetDownloadUrlForLayerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) layer_digest: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the image layer to
        /// download. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the image layer to
        /// download. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository that is associated with the image layer to download.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that is associated with the image layer to download.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The digest of the image layer to download.</p>
        pub fn layer_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_digest = Some(input.into());
            self
        }
        /// <p>The digest of the image layer to download.</p>
        pub fn set_layer_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_digest = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDownloadUrlForLayerInput`](crate::input::GetDownloadUrlForLayerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDownloadUrlForLayerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDownloadUrlForLayerInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                layer_digest: self.layer_digest,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDownloadUrlForLayerInputOperationOutputAlias = crate::operation::GetDownloadUrlForLayer;
#[doc(hidden)]
pub type GetDownloadUrlForLayerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDownloadUrlForLayerInput {
    /// Consumes the builder and constructs an Operation<[`GetDownloadUrlForLayer`](crate::operation::GetDownloadUrlForLayer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDownloadUrlForLayer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDownloadUrlForLayerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDownloadUrlForLayerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDownloadUrlForLayerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.GetDownloadUrlForLayer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_download_url_for_layer(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDownloadUrlForLayer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDownloadUrlForLayer",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDownloadUrlForLayerInput`](crate::input::GetDownloadUrlForLayerInput)
    pub fn builder() -> crate::input::get_download_url_for_layer_input::Builder {
        crate::input::get_download_url_for_layer_input::Builder::default()
    }
}

/// See [`GetLifecyclePolicyInput`](crate::input::GetLifecyclePolicyInput)
pub mod get_lifecycle_policy_input {
    /// A builder for [`GetLifecyclePolicyInput`](crate::input::GetLifecyclePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLifecyclePolicyInput`](crate::input::GetLifecyclePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLifecyclePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLifecyclePolicyInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLifecyclePolicyInputOperationOutputAlias = crate::operation::GetLifecyclePolicy;
#[doc(hidden)]
pub type GetLifecyclePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetLifecyclePolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetLifecyclePolicy`](crate::operation::GetLifecyclePolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLifecyclePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetLifecyclePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetLifecyclePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetLifecyclePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.GetLifecyclePolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_lifecycle_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLifecyclePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLifecyclePolicy",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetLifecyclePolicyInput`](crate::input::GetLifecyclePolicyInput)
    pub fn builder() -> crate::input::get_lifecycle_policy_input::Builder {
        crate::input::get_lifecycle_policy_input::Builder::default()
    }
}

/// See [`GetLifecyclePolicyPreviewInput`](crate::input::GetLifecyclePolicyPreviewInput)
pub mod get_lifecycle_policy_preview_input {
    /// A builder for [`GetLifecyclePolicyPreviewInput`](crate::input::GetLifecyclePolicyPreviewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_ids: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filter: std::option::Option<crate::model::LifecyclePolicyPreviewFilter>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Appends an item to `image_ids`.
        ///
        /// To override the contents of this collection use [`set_image_ids`](Self::set_image_ids).
        ///
        /// <p>The list of imageIDs to be included.</p>
        pub fn image_ids(mut self, input: impl Into<crate::model::ImageIdentifier>) -> Self {
            let mut v = self.image_ids.unwrap_or_default();
            v.push(input.into());
            self.image_ids = Some(v);
            self
        }
        /// <p>The list of imageIDs to be included.</p>
        pub fn set_image_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
        ) -> Self {
            self.image_ids = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>GetLifecyclePolicyPreviewRequest</code> request where <code>maxResults</code>
        /// was used and the  results exceeded the value of that parameter. Pagination continues
        /// from the end of the  previous results that returned the <code>nextToken</code> value.
        /// This value is  <code>null</code> when there are no more results to return. This option
        /// cannot be used when you specify images with <code>imageIds</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>GetLifecyclePolicyPreviewRequest</code> request where <code>maxResults</code>
        /// was used and the  results exceeded the value of that parameter. Pagination continues
        /// from the end of the  previous results that returned the <code>nextToken</code> value.
        /// This value is  <code>null</code> when there are no more results to return. This option
        /// cannot be used when you specify images with <code>imageIds</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of repository results returned by
        /// <code>GetLifecyclePolicyPreviewRequest</code> in  paginated output. When this
        /// parameter is used, <code>GetLifecyclePolicyPreviewRequest</code> only returns
        /// <code>maxResults</code> results in a single page along with a
        /// <code>nextToken</code>  response element. The remaining results of the initial request
        /// can be seen by sending  another <code>GetLifecyclePolicyPreviewRequest</code> request
        /// with the returned <code>nextToken</code>  value. This value can be between
        /// 1 and 1000. If this  parameter is not used, then
        /// <code>GetLifecyclePolicyPreviewRequest</code> returns up to  100
        /// results and a <code>nextToken</code> value, if  applicable. This option cannot be used
        /// when you specify images with <code>imageIds</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of repository results returned by
        /// <code>GetLifecyclePolicyPreviewRequest</code> in  paginated output. When this
        /// parameter is used, <code>GetLifecyclePolicyPreviewRequest</code> only returns
        /// <code>maxResults</code> results in a single page along with a
        /// <code>nextToken</code>  response element. The remaining results of the initial request
        /// can be seen by sending  another <code>GetLifecyclePolicyPreviewRequest</code> request
        /// with the returned <code>nextToken</code>  value. This value can be between
        /// 1 and 1000. If this  parameter is not used, then
        /// <code>GetLifecyclePolicyPreviewRequest</code> returns up to  100
        /// results and a <code>nextToken</code> value, if  applicable. This option cannot be used
        /// when you specify images with <code>imageIds</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An optional parameter that filters results based on image tag status and all tags, if
        /// tagged.</p>
        pub fn filter(mut self, input: crate::model::LifecyclePolicyPreviewFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>An optional parameter that filters results based on image tag status and all tags, if
        /// tagged.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::LifecyclePolicyPreviewFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLifecyclePolicyPreviewInput`](crate::input::GetLifecyclePolicyPreviewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLifecyclePolicyPreviewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLifecyclePolicyPreviewInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                image_ids: self.image_ids,
                next_token: self.next_token,
                max_results: self.max_results,
                filter: self.filter,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLifecyclePolicyPreviewInputOperationOutputAlias =
    crate::operation::GetLifecyclePolicyPreview;
#[doc(hidden)]
pub type GetLifecyclePolicyPreviewInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetLifecyclePolicyPreviewInput {
    /// Consumes the builder and constructs an Operation<[`GetLifecyclePolicyPreview`](crate::operation::GetLifecyclePolicyPreview)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLifecyclePolicyPreview,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetLifecyclePolicyPreviewInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetLifecyclePolicyPreviewInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetLifecyclePolicyPreviewInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.GetLifecyclePolicyPreview",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_lifecycle_policy_preview(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLifecyclePolicyPreview::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLifecyclePolicyPreview",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetLifecyclePolicyPreviewInput`](crate::input::GetLifecyclePolicyPreviewInput)
    pub fn builder() -> crate::input::get_lifecycle_policy_preview_input::Builder {
        crate::input::get_lifecycle_policy_preview_input::Builder::default()
    }
}

/// See [`GetRegistryPolicyInput`](crate::input::GetRegistryPolicyInput)
pub mod get_registry_policy_input {
    /// A builder for [`GetRegistryPolicyInput`](crate::input::GetRegistryPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetRegistryPolicyInput`](crate::input::GetRegistryPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRegistryPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRegistryPolicyInput {})
        }
    }
}
#[doc(hidden)]
pub type GetRegistryPolicyInputOperationOutputAlias = crate::operation::GetRegistryPolicy;
#[doc(hidden)]
pub type GetRegistryPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRegistryPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetRegistryPolicy`](crate::operation::GetRegistryPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRegistryPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRegistryPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRegistryPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRegistryPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.GetRegistryPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_registry_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRegistryPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRegistryPolicy",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRegistryPolicyInput`](crate::input::GetRegistryPolicyInput)
    pub fn builder() -> crate::input::get_registry_policy_input::Builder {
        crate::input::get_registry_policy_input::Builder::default()
    }
}

/// See [`GetRepositoryPolicyInput`](crate::input::GetRepositoryPolicyInput)
pub mod get_repository_policy_input {
    /// A builder for [`GetRepositoryPolicyInput`](crate::input::GetRepositoryPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository with the policy to retrieve.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository with the policy to retrieve.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRepositoryPolicyInput`](crate::input::GetRepositoryPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRepositoryPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRepositoryPolicyInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRepositoryPolicyInputOperationOutputAlias = crate::operation::GetRepositoryPolicy;
#[doc(hidden)]
pub type GetRepositoryPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRepositoryPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetRepositoryPolicy`](crate::operation::GetRepositoryPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRepositoryPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRepositoryPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRepositoryPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRepositoryPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.GetRepositoryPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_repository_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRepositoryPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRepositoryPolicy",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRepositoryPolicyInput`](crate::input::GetRepositoryPolicyInput)
    pub fn builder() -> crate::input::get_repository_policy_input::Builder {
        crate::input::get_repository_policy_input::Builder::default()
    }
}

/// See [`InitiateLayerUploadInput`](crate::input::InitiateLayerUploadInput)
pub mod initiate_layer_upload_input {
    /// A builder for [`InitiateLayerUploadInput`](crate::input::InitiateLayerUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry to which you intend to upload
        /// layers. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry to which you intend to upload
        /// layers. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository to which you intend to upload layers.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to which you intend to upload layers.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`InitiateLayerUploadInput`](crate::input::InitiateLayerUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InitiateLayerUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InitiateLayerUploadInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
            })
        }
    }
}
#[doc(hidden)]
pub type InitiateLayerUploadInputOperationOutputAlias = crate::operation::InitiateLayerUpload;
#[doc(hidden)]
pub type InitiateLayerUploadInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl InitiateLayerUploadInput {
    /// Consumes the builder and constructs an Operation<[`InitiateLayerUpload`](crate::operation::InitiateLayerUpload)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InitiateLayerUpload,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::InitiateLayerUploadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::InitiateLayerUploadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::InitiateLayerUploadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.InitiateLayerUpload",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_initiate_layer_upload(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InitiateLayerUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InitiateLayerUpload",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`InitiateLayerUploadInput`](crate::input::InitiateLayerUploadInput)
    pub fn builder() -> crate::input::initiate_layer_upload_input::Builder {
        crate::input::initiate_layer_upload_input::Builder::default()
    }
}

/// See [`ListImagesInput`](crate::input::ListImagesInput)
pub mod list_images_input {
    /// A builder for [`ListImagesInput`](crate::input::ListImagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filter: std::option::Option<crate::model::ListImagesFilter>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to list images. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to list images. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The repository with image IDs to be listed.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository with image IDs to be listed.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListImages</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated
        /// <code>ListImages</code> request where <code>maxResults</code> was used and the
        /// results exceeded the value of that parameter. Pagination continues from the end of the
        /// previous results that returned the <code>nextToken</code> value. This value is
        /// <code>null</code> when there are no more results to return.</p>
        /// <note>
        /// <p>This token should be treated as an opaque identifier that is only used to
        /// retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of image results returned by <code>ListImages</code> in paginated
        /// output. When this parameter is used, <code>ListImages</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>ListImages</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 1000. If this parameter is
        /// not used, then <code>ListImages</code> returns up to 100 results and a
        /// <code>nextToken</code> value, if applicable.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of image results returned by <code>ListImages</code> in paginated
        /// output. When this parameter is used, <code>ListImages</code> only returns
        /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
        /// response element. The remaining results of the initial request can be seen by sending
        /// another <code>ListImages</code> request with the returned <code>nextToken</code> value.
        /// This value can be between 1 and 1000. If this parameter is
        /// not used, then <code>ListImages</code> returns up to 100 results and a
        /// <code>nextToken</code> value, if applicable.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The filter key and value with which to filter your <code>ListImages</code>
        /// results.</p>
        pub fn filter(mut self, input: crate::model::ListImagesFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>The filter key and value with which to filter your <code>ListImages</code>
        /// results.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ListImagesFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImagesInput`](crate::input::ListImagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListImagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListImagesInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                next_token: self.next_token,
                max_results: self.max_results,
                filter: self.filter,
            })
        }
    }
}
#[doc(hidden)]
pub type ListImagesInputOperationOutputAlias = crate::operation::ListImages;
#[doc(hidden)]
pub type ListImagesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListImagesInput {
    /// Consumes the builder and constructs an Operation<[`ListImages`](crate::operation::ListImages)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListImages,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListImagesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListImagesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListImagesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.ListImages",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_images(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListImages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListImages",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListImagesInput`](crate::input::ListImagesInput)
    pub fn builder() -> crate::input::list_images_input::Builder {
        crate::input::list_images_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the
        /// only supported resource is an Amazon ECR repository.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the
        /// only supported resource is an Amazon ECR repository.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutImageInput`](crate::input::PutImageInput)
pub mod put_image_input {
    /// A builder for [`PutImageInput`](crate::input::PutImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_manifest: std::option::Option<std::string::String>,
        pub(crate) image_manifest_media_type: std::option::Option<std::string::String>,
        pub(crate) image_tag: std::option::Option<std::string::String>,
        pub(crate) image_digest: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to put the image. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to put the image. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository in which to put the image.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository in which to put the image.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The image manifest corresponding to the image to be uploaded.</p>
        pub fn image_manifest(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_manifest = Some(input.into());
            self
        }
        /// <p>The image manifest corresponding to the image to be uploaded.</p>
        pub fn set_image_manifest(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_manifest = input;
            self
        }
        /// <p>The media type of the image manifest. If you push an image manifest that does not
        /// contain the <code>mediaType</code> field, you must specify the
        /// <code>imageManifestMediaType</code> in the request.</p>
        pub fn image_manifest_media_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_manifest_media_type = Some(input.into());
            self
        }
        /// <p>The media type of the image manifest. If you push an image manifest that does not
        /// contain the <code>mediaType</code> field, you must specify the
        /// <code>imageManifestMediaType</code> in the request.</p>
        pub fn set_image_manifest_media_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_manifest_media_type = input;
            self
        }
        /// <p>The tag to associate with the image. This parameter is required for images that use
        /// the Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.</p>
        pub fn image_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_tag = Some(input.into());
            self
        }
        /// <p>The tag to associate with the image. This parameter is required for images that use
        /// the Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.</p>
        pub fn set_image_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_tag = input;
            self
        }
        /// <p>The image digest of the image manifest corresponding to the image.</p>
        pub fn image_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_digest = Some(input.into());
            self
        }
        /// <p>The image digest of the image manifest corresponding to the image.</p>
        pub fn set_image_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_digest = input;
            self
        }
        /// Consumes the builder and constructs a [`PutImageInput`](crate::input::PutImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::PutImageInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::PutImageInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                image_manifest: self.image_manifest,
                image_manifest_media_type: self.image_manifest_media_type,
                image_tag: self.image_tag,
                image_digest: self.image_digest,
            })
        }
    }
}
#[doc(hidden)]
pub type PutImageInputOperationOutputAlias = crate::operation::PutImage;
#[doc(hidden)]
pub type PutImageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutImageInput {
    /// Consumes the builder and constructs an Operation<[`PutImage`](crate::operation::PutImage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutImage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutImageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutImageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutImageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.PutImage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_image(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::PutImage::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("PutImage", "ecr"));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutImageInput`](crate::input::PutImageInput)
    pub fn builder() -> crate::input::put_image_input::Builder {
        crate::input::put_image_input::Builder::default()
    }
}

/// See [`PutImageScanningConfigurationInput`](crate::input::PutImageScanningConfigurationInput)
pub mod put_image_scanning_configuration_input {
    /// A builder for [`PutImageScanningConfigurationInput`](crate::input::PutImageScanningConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_scanning_configuration:
            std::option::Option<crate::model::ImageScanningConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to update the image scanning configuration setting.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to update the image scanning configuration setting.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository in which to update the image scanning configuration
        /// setting.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository in which to update the image scanning configuration
        /// setting.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The image scanning configuration for the repository. This setting determines whether
        /// images are scanned for known vulnerabilities after being pushed to the
        /// repository.</p>
        pub fn image_scanning_configuration(
            mut self,
            input: crate::model::ImageScanningConfiguration,
        ) -> Self {
            self.image_scanning_configuration = Some(input);
            self
        }
        /// <p>The image scanning configuration for the repository. This setting determines whether
        /// images are scanned for known vulnerabilities after being pushed to the
        /// repository.</p>
        pub fn set_image_scanning_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageScanningConfiguration>,
        ) -> Self {
            self.image_scanning_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PutImageScanningConfigurationInput`](crate::input::PutImageScanningConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutImageScanningConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutImageScanningConfigurationInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                image_scanning_configuration: self.image_scanning_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type PutImageScanningConfigurationInputOperationOutputAlias =
    crate::operation::PutImageScanningConfiguration;
#[doc(hidden)]
pub type PutImageScanningConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutImageScanningConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutImageScanningConfiguration`](crate::operation::PutImageScanningConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutImageScanningConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutImageScanningConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutImageScanningConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutImageScanningConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.PutImageScanningConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_image_scanning_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutImageScanningConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutImageScanningConfiguration",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutImageScanningConfigurationInput`](crate::input::PutImageScanningConfigurationInput)
    pub fn builder() -> crate::input::put_image_scanning_configuration_input::Builder {
        crate::input::put_image_scanning_configuration_input::Builder::default()
    }
}

/// See [`PutImageTagMutabilityInput`](crate::input::PutImageTagMutabilityInput)
pub mod put_image_tag_mutability_input {
    /// A builder for [`PutImageTagMutabilityInput`](crate::input::PutImageTagMutabilityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_tag_mutability: std::option::Option<crate::model::ImageTagMutability>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to update the image tag mutability settings. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to update the image tag mutability settings. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository in which to update the image tag mutability
        /// settings.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository in which to update the image tag mutability
        /// settings.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The tag mutability setting for the repository. If <code>MUTABLE</code> is specified,
        /// image tags can be overwritten. If <code>IMMUTABLE</code> is specified, all image tags
        /// within the repository will be immutable which will prevent them from being
        /// overwritten.</p>
        pub fn image_tag_mutability(mut self, input: crate::model::ImageTagMutability) -> Self {
            self.image_tag_mutability = Some(input);
            self
        }
        /// <p>The tag mutability setting for the repository. If <code>MUTABLE</code> is specified,
        /// image tags can be overwritten. If <code>IMMUTABLE</code> is specified, all image tags
        /// within the repository will be immutable which will prevent them from being
        /// overwritten.</p>
        pub fn set_image_tag_mutability(
            mut self,
            input: std::option::Option<crate::model::ImageTagMutability>,
        ) -> Self {
            self.image_tag_mutability = input;
            self
        }
        /// Consumes the builder and constructs a [`PutImageTagMutabilityInput`](crate::input::PutImageTagMutabilityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutImageTagMutabilityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutImageTagMutabilityInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                image_tag_mutability: self.image_tag_mutability,
            })
        }
    }
}
#[doc(hidden)]
pub type PutImageTagMutabilityInputOperationOutputAlias = crate::operation::PutImageTagMutability;
#[doc(hidden)]
pub type PutImageTagMutabilityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutImageTagMutabilityInput {
    /// Consumes the builder and constructs an Operation<[`PutImageTagMutability`](crate::operation::PutImageTagMutability)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutImageTagMutability,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutImageTagMutabilityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutImageTagMutabilityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutImageTagMutabilityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.PutImageTagMutability",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_image_tag_mutability(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutImageTagMutability::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutImageTagMutability",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutImageTagMutabilityInput`](crate::input::PutImageTagMutabilityInput)
    pub fn builder() -> crate::input::put_image_tag_mutability_input::Builder {
        crate::input::put_image_tag_mutability_input::Builder::default()
    }
}

/// See [`PutLifecyclePolicyInput`](crate::input::PutLifecyclePolicyInput)
pub mod put_lifecycle_policy_input {
    /// A builder for [`PutLifecyclePolicyInput`](crate::input::PutLifecyclePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) lifecycle_policy_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you
        /// do  not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you
        /// do  not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository to receive the policy.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to receive the policy.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The JSON repository policy text to apply to the repository.</p>
        pub fn lifecycle_policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_policy_text = Some(input.into());
            self
        }
        /// <p>The JSON repository policy text to apply to the repository.</p>
        pub fn set_lifecycle_policy_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_policy_text = input;
            self
        }
        /// Consumes the builder and constructs a [`PutLifecyclePolicyInput`](crate::input::PutLifecyclePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutLifecyclePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutLifecyclePolicyInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                lifecycle_policy_text: self.lifecycle_policy_text,
            })
        }
    }
}
#[doc(hidden)]
pub type PutLifecyclePolicyInputOperationOutputAlias = crate::operation::PutLifecyclePolicy;
#[doc(hidden)]
pub type PutLifecyclePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutLifecyclePolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutLifecyclePolicy`](crate::operation::PutLifecyclePolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutLifecyclePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutLifecyclePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutLifecyclePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutLifecyclePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.PutLifecyclePolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_lifecycle_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutLifecyclePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutLifecyclePolicy",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutLifecyclePolicyInput`](crate::input::PutLifecyclePolicyInput)
    pub fn builder() -> crate::input::put_lifecycle_policy_input::Builder {
        crate::input::put_lifecycle_policy_input::Builder::default()
    }
}

/// See [`PutRegistryPolicyInput`](crate::input::PutRegistryPolicyInput)
pub mod put_registry_policy_input {
    /// A builder for [`PutRegistryPolicyInput`](crate::input::PutRegistryPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The JSON policy text to apply to your registry. The policy text follows the same
        /// format as IAM policy text. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html">Registry
        /// permissions</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
        pub fn policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_text = Some(input.into());
            self
        }
        /// <p>The JSON policy text to apply to your registry. The policy text follows the same
        /// format as IAM policy text. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html">Registry
        /// permissions</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
        pub fn set_policy_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_text = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRegistryPolicyInput`](crate::input::PutRegistryPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutRegistryPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutRegistryPolicyInput {
                policy_text: self.policy_text,
            })
        }
    }
}
#[doc(hidden)]
pub type PutRegistryPolicyInputOperationOutputAlias = crate::operation::PutRegistryPolicy;
#[doc(hidden)]
pub type PutRegistryPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutRegistryPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutRegistryPolicy`](crate::operation::PutRegistryPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutRegistryPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutRegistryPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutRegistryPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutRegistryPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.PutRegistryPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_registry_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutRegistryPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutRegistryPolicy",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutRegistryPolicyInput`](crate::input::PutRegistryPolicyInput)
    pub fn builder() -> crate::input::put_registry_policy_input::Builder {
        crate::input::put_registry_policy_input::Builder::default()
    }
}

/// See [`PutReplicationConfigurationInput`](crate::input::PutReplicationConfigurationInput)
pub mod put_replication_configuration_input {
    /// A builder for [`PutReplicationConfigurationInput`](crate::input::PutReplicationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_configuration:
            std::option::Option<crate::model::ReplicationConfiguration>,
    }
    impl Builder {
        /// <p>An object representing the replication configuration for a registry.</p>
        pub fn replication_configuration(
            mut self,
            input: crate::model::ReplicationConfiguration,
        ) -> Self {
            self.replication_configuration = Some(input);
            self
        }
        /// <p>An object representing the replication configuration for a registry.</p>
        pub fn set_replication_configuration(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfiguration>,
        ) -> Self {
            self.replication_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PutReplicationConfigurationInput`](crate::input::PutReplicationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutReplicationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutReplicationConfigurationInput {
                replication_configuration: self.replication_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type PutReplicationConfigurationInputOperationOutputAlias =
    crate::operation::PutReplicationConfiguration;
#[doc(hidden)]
pub type PutReplicationConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutReplicationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutReplicationConfiguration`](crate::operation::PutReplicationConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutReplicationConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutReplicationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutReplicationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutReplicationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.PutReplicationConfiguration",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_replication_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutReplicationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutReplicationConfiguration",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutReplicationConfigurationInput`](crate::input::PutReplicationConfigurationInput)
    pub fn builder() -> crate::input::put_replication_configuration_input::Builder {
        crate::input::put_replication_configuration_input::Builder::default()
    }
}

/// See [`SetRepositoryPolicyInput`](crate::input::SetRepositoryPolicyInput)
pub mod set_repository_policy_input {
    /// A builder for [`SetRepositoryPolicyInput`](crate::input::SetRepositoryPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) policy_text: std::option::Option<std::string::String>,
        pub(crate) force: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository to receive the policy.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to receive the policy.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The JSON repository policy text to apply to the repository. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR repository
        /// policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
        pub fn policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_text = Some(input.into());
            self
        }
        /// <p>The JSON repository policy text to apply to the repository. For more information, see
        /// <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR repository
        /// policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
        pub fn set_policy_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_text = input;
            self
        }
        /// <p>If the policy you are attempting to set on a repository policy would prevent you from
        /// setting another policy in the future, you must force the <a>SetRepositoryPolicy</a> operation. This is intended to prevent accidental
        /// repository lock outs.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p>If the policy you are attempting to set on a repository policy would prevent you from
        /// setting another policy in the future, you must force the <a>SetRepositoryPolicy</a> operation. This is intended to prevent accidental
        /// repository lock outs.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// Consumes the builder and constructs a [`SetRepositoryPolicyInput`](crate::input::SetRepositoryPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetRepositoryPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetRepositoryPolicyInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                policy_text: self.policy_text,
                force: self.force.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type SetRepositoryPolicyInputOperationOutputAlias = crate::operation::SetRepositoryPolicy;
#[doc(hidden)]
pub type SetRepositoryPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SetRepositoryPolicyInput {
    /// Consumes the builder and constructs an Operation<[`SetRepositoryPolicy`](crate::operation::SetRepositoryPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetRepositoryPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SetRepositoryPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SetRepositoryPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SetRepositoryPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.SetRepositoryPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_set_repository_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetRepositoryPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetRepositoryPolicy",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SetRepositoryPolicyInput`](crate::input::SetRepositoryPolicyInput)
    pub fn builder() -> crate::input::set_repository_policy_input::Builder {
        crate::input::set_repository_policy_input::Builder::default()
    }
}

/// See [`StartImageScanInput`](crate::input::StartImageScanInput)
pub mod start_image_scan_input {
    /// A builder for [`StartImageScanInput`](crate::input::StartImageScanInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) image_id: std::option::Option<crate::model::ImageIdentifier>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to start an image scan request. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
        /// which to start an image scan request. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository that contains the images to scan.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that contains the images to scan.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn image_id(mut self, input: crate::model::ImageIdentifier) -> Self {
            self.image_id = Some(input);
            self
        }
        /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
        pub fn set_image_id(
            mut self,
            input: std::option::Option<crate::model::ImageIdentifier>,
        ) -> Self {
            self.image_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartImageScanInput`](crate::input::StartImageScanInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartImageScanInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartImageScanInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                image_id: self.image_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StartImageScanInputOperationOutputAlias = crate::operation::StartImageScan;
#[doc(hidden)]
pub type StartImageScanInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartImageScanInput {
    /// Consumes the builder and constructs an Operation<[`StartImageScan`](crate::operation::StartImageScan)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartImageScan,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartImageScanInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartImageScanInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartImageScanInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.StartImageScan",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_image_scan(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartImageScan::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartImageScan",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartImageScanInput`](crate::input::StartImageScanInput)
    pub fn builder() -> crate::input::start_image_scan_input::Builder {
        crate::input::start_image_scan_input::Builder::default()
    }
}

/// See [`StartLifecyclePolicyPreviewInput`](crate::input::StartLifecyclePolicyPreviewInput)
pub mod start_lifecycle_policy_preview_input {
    /// A builder for [`StartLifecyclePolicyPreviewInput`](crate::input::StartLifecyclePolicyPreviewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) lifecycle_policy_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
        /// If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository to be evaluated.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to be evaluated.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The policy to be evaluated against. If you do not specify a policy, the current policy
        /// for the repository is used.</p>
        pub fn lifecycle_policy_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_policy_text = Some(input.into());
            self
        }
        /// <p>The policy to be evaluated against. If you do not specify a policy, the current policy
        /// for the repository is used.</p>
        pub fn set_lifecycle_policy_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_policy_text = input;
            self
        }
        /// Consumes the builder and constructs a [`StartLifecyclePolicyPreviewInput`](crate::input::StartLifecyclePolicyPreviewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartLifecyclePolicyPreviewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartLifecyclePolicyPreviewInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                lifecycle_policy_text: self.lifecycle_policy_text,
            })
        }
    }
}
#[doc(hidden)]
pub type StartLifecyclePolicyPreviewInputOperationOutputAlias =
    crate::operation::StartLifecyclePolicyPreview;
#[doc(hidden)]
pub type StartLifecyclePolicyPreviewInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartLifecyclePolicyPreviewInput {
    /// Consumes the builder and constructs an Operation<[`StartLifecyclePolicyPreview`](crate::operation::StartLifecyclePolicyPreview)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartLifecyclePolicyPreview,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartLifecyclePolicyPreviewInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartLifecyclePolicyPreviewInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartLifecyclePolicyPreviewInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.StartLifecyclePolicyPreview",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_lifecycle_policy_preview(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartLifecyclePolicyPreview::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartLifecyclePolicyPreview",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartLifecyclePolicyPreviewInput`](crate::input::StartLifecyclePolicyPreviewInput)
    pub fn builder() -> crate::input::start_lifecycle_policy_preview_input::Builder {
        crate::input::start_lifecycle_policy_preview_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the the resource to which to add tags. Currently, the only supported
        /// resource is an Amazon ECR repository.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the the resource to which to add tags. Currently, the only supported
        /// resource is an Amazon ECR repository.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs.
        /// Tag keys can have a maximum character length of 128 characters, and tag values can have
        /// a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource from which to remove tags. Currently, the only supported
        /// resource is an Amazon ECR repository.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which to remove tags. Currently, the only supported
        /// resource is an Amazon ECR repository.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UploadLayerPartInput`](crate::input::UploadLayerPartInput)
pub mod upload_layer_part_input {
    /// A builder for [`UploadLayerPartInput`](crate::input::UploadLayerPartInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registry_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) part_first_byte: std::option::Option<i64>,
        pub(crate) part_last_byte: std::option::Option<i64>,
        pub(crate) layer_part_blob: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the registry to which you are uploading layer
        /// parts. If you do not specify a registry, the default registry is assumed.</p>
        pub fn registry_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.registry_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the registry to which you are uploading layer
        /// parts. If you do not specify a registry, the default registry is assumed.</p>
        pub fn set_registry_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.registry_id = input;
            self
        }
        /// <p>The name of the repository to which you are uploading layer parts.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to which you are uploading layer parts.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
        /// associate with the layer part upload.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
        /// associate with the layer part upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>The position of the first byte of the layer part witin the overall image layer.</p>
        pub fn part_first_byte(mut self, input: i64) -> Self {
            self.part_first_byte = Some(input);
            self
        }
        /// <p>The position of the first byte of the layer part witin the overall image layer.</p>
        pub fn set_part_first_byte(mut self, input: std::option::Option<i64>) -> Self {
            self.part_first_byte = input;
            self
        }
        /// <p>The position of the last byte of the layer part within the overall image layer.</p>
        pub fn part_last_byte(mut self, input: i64) -> Self {
            self.part_last_byte = Some(input);
            self
        }
        /// <p>The position of the last byte of the layer part within the overall image layer.</p>
        pub fn set_part_last_byte(mut self, input: std::option::Option<i64>) -> Self {
            self.part_last_byte = input;
            self
        }
        /// <p>The base64-encoded layer part payload.</p>
        pub fn layer_part_blob(mut self, input: aws_smithy_types::Blob) -> Self {
            self.layer_part_blob = Some(input);
            self
        }
        /// <p>The base64-encoded layer part payload.</p>
        pub fn set_layer_part_blob(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.layer_part_blob = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadLayerPartInput`](crate::input::UploadLayerPartInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UploadLayerPartInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UploadLayerPartInput {
                registry_id: self.registry_id,
                repository_name: self.repository_name,
                upload_id: self.upload_id,
                part_first_byte: self.part_first_byte,
                part_last_byte: self.part_last_byte,
                layer_part_blob: self.layer_part_blob,
            })
        }
    }
}
#[doc(hidden)]
pub type UploadLayerPartInputOperationOutputAlias = crate::operation::UploadLayerPart;
#[doc(hidden)]
pub type UploadLayerPartInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UploadLayerPartInput {
    /// Consumes the builder and constructs an Operation<[`UploadLayerPart`](crate::operation::UploadLayerPart)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UploadLayerPart,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UploadLayerPartInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UploadLayerPartInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UploadLayerPartInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonEC2ContainerRegistry_V20150921.UploadLayerPart",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_upload_layer_part(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UploadLayerPart::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UploadLayerPart",
            "ecr",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UploadLayerPartInput`](crate::input::UploadLayerPartInput)
    pub fn builder() -> crate::input::upload_layer_part_input::Builder {
        crate::input::upload_layer_part_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadLayerPartInput {
    /// <p>The Amazon Web Services account ID associated with the registry to which you are uploading layer
    /// parts. If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository to which you are uploading layer parts.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
    /// associate with the layer part upload.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>The position of the first byte of the layer part witin the overall image layer.</p>
    pub part_first_byte: std::option::Option<i64>,
    /// <p>The position of the last byte of the layer part within the overall image layer.</p>
    pub part_last_byte: std::option::Option<i64>,
    /// <p>The base64-encoded layer part payload.</p>
    pub layer_part_blob: std::option::Option<aws_smithy_types::Blob>,
}
impl UploadLayerPartInput {
    /// <p>The Amazon Web Services account ID associated with the registry to which you are uploading layer
    /// parts. If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository to which you are uploading layer parts.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
    /// associate with the layer part upload.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>The position of the first byte of the layer part witin the overall image layer.</p>
    pub fn part_first_byte(&self) -> std::option::Option<i64> {
        self.part_first_byte
    }
    /// <p>The position of the last byte of the layer part within the overall image layer.</p>
    pub fn part_last_byte(&self) -> std::option::Option<i64> {
        self.part_last_byte
    }
    /// <p>The base64-encoded layer part payload.</p>
    pub fn layer_part_blob(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.layer_part_blob.as_ref()
    }
}
impl std::fmt::Debug for UploadLayerPartInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadLayerPartInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("upload_id", &self.upload_id);
        formatter.field("part_first_byte", &self.part_first_byte);
        formatter.field("part_last_byte", &self.part_last_byte);
        formatter.field("layer_part_blob", &self.layer_part_blob);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource from which to remove tags. Currently, the only supported
    /// resource is an Amazon ECR repository.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The keys of the tags to be removed.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource from which to remove tags. Currently, the only supported
    /// resource is an Amazon ECR repository.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The keys of the tags to be removed.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the the resource to which to add tags. Currently, the only supported
    /// resource is an Amazon ECR repository.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to add to the resource. A tag is an array of key-value pairs.
    /// Tag keys can have a maximum character length of 128 characters, and tag values can have
    /// a maximum length of 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the the resource to which to add tags. Currently, the only supported
    /// resource is an Amazon ECR repository.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags to add to the resource. A tag is an array of key-value pairs.
    /// Tag keys can have a maximum character length of 128 characters, and tag values can have
    /// a maximum length of 256 characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartLifecyclePolicyPreviewInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository to be evaluated.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The policy to be evaluated against. If you do not specify a policy, the current policy
    /// for the repository is used.</p>
    pub lifecycle_policy_text: std::option::Option<std::string::String>,
}
impl StartLifecyclePolicyPreviewInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository to be evaluated.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The policy to be evaluated against. If you do not specify a policy, the current policy
    /// for the repository is used.</p>
    pub fn lifecycle_policy_text(&self) -> std::option::Option<&str> {
        self.lifecycle_policy_text.as_deref()
    }
}
impl std::fmt::Debug for StartLifecyclePolicyPreviewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartLifecyclePolicyPreviewInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("lifecycle_policy_text", &self.lifecycle_policy_text);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartImageScanInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
    /// which to start an image scan request. If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository that contains the images to scan.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
    pub image_id: std::option::Option<crate::model::ImageIdentifier>,
}
impl StartImageScanInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
    /// which to start an image scan request. If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository that contains the images to scan.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
    pub fn image_id(&self) -> std::option::Option<&crate::model::ImageIdentifier> {
        self.image_id.as_ref()
    }
}
impl std::fmt::Debug for StartImageScanInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartImageScanInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_id", &self.image_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetRepositoryPolicyInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository to receive the policy.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The JSON repository policy text to apply to the repository. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR repository
    /// policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    pub policy_text: std::option::Option<std::string::String>,
    /// <p>If the policy you are attempting to set on a repository policy would prevent you from
    /// setting another policy in the future, you must force the <a>SetRepositoryPolicy</a> operation. This is intended to prevent accidental
    /// repository lock outs.</p>
    pub force: bool,
}
impl SetRepositoryPolicyInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository to receive the policy.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The JSON repository policy text to apply to the repository. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Amazon ECR repository
    /// policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    pub fn policy_text(&self) -> std::option::Option<&str> {
        self.policy_text.as_deref()
    }
    /// <p>If the policy you are attempting to set on a repository policy would prevent you from
    /// setting another policy in the future, you must force the <a>SetRepositoryPolicy</a> operation. This is intended to prevent accidental
    /// repository lock outs.</p>
    pub fn force(&self) -> bool {
        self.force
    }
}
impl std::fmt::Debug for SetRepositoryPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetRepositoryPolicyInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("policy_text", &self.policy_text);
        formatter.field("force", &self.force);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutReplicationConfigurationInput {
    /// <p>An object representing the replication configuration for a registry.</p>
    pub replication_configuration: std::option::Option<crate::model::ReplicationConfiguration>,
}
impl PutReplicationConfigurationInput {
    /// <p>An object representing the replication configuration for a registry.</p>
    pub fn replication_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationConfiguration> {
        self.replication_configuration.as_ref()
    }
}
impl std::fmt::Debug for PutReplicationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutReplicationConfigurationInput");
        formatter.field("replication_configuration", &self.replication_configuration);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRegistryPolicyInput {
    /// <p>The JSON policy text to apply to your registry. The policy text follows the same
    /// format as IAM policy text. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html">Registry
    /// permissions</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    pub policy_text: std::option::Option<std::string::String>,
}
impl PutRegistryPolicyInput {
    /// <p>The JSON policy text to apply to your registry. The policy text follows the same
    /// format as IAM policy text. For more information, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html">Registry
    /// permissions</a> in the <i>Amazon Elastic Container Registry User Guide</i>.</p>
    pub fn policy_text(&self) -> std::option::Option<&str> {
        self.policy_text.as_deref()
    }
}
impl std::fmt::Debug for PutRegistryPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRegistryPolicyInput");
        formatter.field("policy_text", &self.policy_text);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutLifecyclePolicyInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you
    /// do  not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository to receive the policy.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The JSON repository policy text to apply to the repository.</p>
    pub lifecycle_policy_text: std::option::Option<std::string::String>,
}
impl PutLifecyclePolicyInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository. If you
    /// do  not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository to receive the policy.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The JSON repository policy text to apply to the repository.</p>
    pub fn lifecycle_policy_text(&self) -> std::option::Option<&str> {
        self.lifecycle_policy_text.as_deref()
    }
}
impl std::fmt::Debug for PutLifecyclePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutLifecyclePolicyInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("lifecycle_policy_text", &self.lifecycle_policy_text);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutImageTagMutabilityInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
    /// which to update the image tag mutability settings. If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository in which to update the image tag mutability
    /// settings.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The tag mutability setting for the repository. If <code>MUTABLE</code> is specified,
    /// image tags can be overwritten. If <code>IMMUTABLE</code> is specified, all image tags
    /// within the repository will be immutable which will prevent them from being
    /// overwritten.</p>
    pub image_tag_mutability: std::option::Option<crate::model::ImageTagMutability>,
}
impl PutImageTagMutabilityInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
    /// which to update the image tag mutability settings. If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository in which to update the image tag mutability
    /// settings.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The tag mutability setting for the repository. If <code>MUTABLE</code> is specified,
    /// image tags can be overwritten. If <code>IMMUTABLE</code> is specified, all image tags
    /// within the repository will be immutable which will prevent them from being
    /// overwritten.</p>
    pub fn image_tag_mutability(&self) -> std::option::Option<&crate::model::ImageTagMutability> {
        self.image_tag_mutability.as_ref()
    }
}
impl std::fmt::Debug for PutImageTagMutabilityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutImageTagMutabilityInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_tag_mutability", &self.image_tag_mutability);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutImageScanningConfigurationInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
    /// which to update the image scanning configuration setting.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository in which to update the image scanning configuration
    /// setting.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The image scanning configuration for the repository. This setting determines whether
    /// images are scanned for known vulnerabilities after being pushed to the
    /// repository.</p>
    pub image_scanning_configuration: std::option::Option<crate::model::ImageScanningConfiguration>,
}
impl PutImageScanningConfigurationInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
    /// which to update the image scanning configuration setting.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository in which to update the image scanning configuration
    /// setting.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The image scanning configuration for the repository. This setting determines whether
    /// images are scanned for known vulnerabilities after being pushed to the
    /// repository.</p>
    pub fn image_scanning_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ImageScanningConfiguration> {
        self.image_scanning_configuration.as_ref()
    }
}
impl std::fmt::Debug for PutImageScanningConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutImageScanningConfigurationInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field(
            "image_scanning_configuration",
            &self.image_scanning_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutImageInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
    /// which to put the image. If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository in which to put the image.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The image manifest corresponding to the image to be uploaded.</p>
    pub image_manifest: std::option::Option<std::string::String>,
    /// <p>The media type of the image manifest. If you push an image manifest that does not
    /// contain the <code>mediaType</code> field, you must specify the
    /// <code>imageManifestMediaType</code> in the request.</p>
    pub image_manifest_media_type: std::option::Option<std::string::String>,
    /// <p>The tag to associate with the image. This parameter is required for images that use
    /// the Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.</p>
    pub image_tag: std::option::Option<std::string::String>,
    /// <p>The image digest of the image manifest corresponding to the image.</p>
    pub image_digest: std::option::Option<std::string::String>,
}
impl PutImageInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
    /// which to put the image. If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository in which to put the image.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The image manifest corresponding to the image to be uploaded.</p>
    pub fn image_manifest(&self) -> std::option::Option<&str> {
        self.image_manifest.as_deref()
    }
    /// <p>The media type of the image manifest. If you push an image manifest that does not
    /// contain the <code>mediaType</code> field, you must specify the
    /// <code>imageManifestMediaType</code> in the request.</p>
    pub fn image_manifest_media_type(&self) -> std::option::Option<&str> {
        self.image_manifest_media_type.as_deref()
    }
    /// <p>The tag to associate with the image. This parameter is required for images that use
    /// the Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.</p>
    pub fn image_tag(&self) -> std::option::Option<&str> {
        self.image_tag.as_deref()
    }
    /// <p>The image digest of the image manifest corresponding to the image.</p>
    pub fn image_digest(&self) -> std::option::Option<&str> {
        self.image_digest.as_deref()
    }
}
impl std::fmt::Debug for PutImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutImageInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_manifest", &self.image_manifest);
        formatter.field("image_manifest_media_type", &self.image_manifest_media_type);
        formatter.field("image_tag", &self.image_tag);
        formatter.field("image_digest", &self.image_digest);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the
    /// only supported resource is an Amazon ECR repository.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the
    /// only supported resource is an Amazon ECR repository.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImagesInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
    /// which to list images. If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository with image IDs to be listed.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>ListImages</code> request where <code>maxResults</code> was used and the
    /// results exceeded the value of that parameter. Pagination continues from the end of the
    /// previous results that returned the <code>nextToken</code> value. This value is
    /// <code>null</code> when there are no more results to return.</p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to
    /// retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of image results returned by <code>ListImages</code> in paginated
    /// output. When this parameter is used, <code>ListImages</code> only returns
    /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
    /// response element. The remaining results of the initial request can be seen by sending
    /// another <code>ListImages</code> request with the returned <code>nextToken</code> value.
    /// This value can be between 1 and 1000. If this parameter is
    /// not used, then <code>ListImages</code> returns up to 100 results and a
    /// <code>nextToken</code> value, if applicable.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The filter key and value with which to filter your <code>ListImages</code>
    /// results.</p>
    pub filter: std::option::Option<crate::model::ListImagesFilter>,
}
impl ListImagesInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
    /// which to list images. If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository with image IDs to be listed.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>ListImages</code> request where <code>maxResults</code> was used and the
    /// results exceeded the value of that parameter. Pagination continues from the end of the
    /// previous results that returned the <code>nextToken</code> value. This value is
    /// <code>null</code> when there are no more results to return.</p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to
    /// retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of image results returned by <code>ListImages</code> in paginated
    /// output. When this parameter is used, <code>ListImages</code> only returns
    /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
    /// response element. The remaining results of the initial request can be seen by sending
    /// another <code>ListImages</code> request with the returned <code>nextToken</code> value.
    /// This value can be between 1 and 1000. If this parameter is
    /// not used, then <code>ListImages</code> returns up to 100 results and a
    /// <code>nextToken</code> value, if applicable.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The filter key and value with which to filter your <code>ListImages</code>
    /// results.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::ListImagesFilter> {
        self.filter.as_ref()
    }
}
impl std::fmt::Debug for ListImagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImagesInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InitiateLayerUploadInput {
    /// <p>The Amazon Web Services account ID associated with the registry to which you intend to upload
    /// layers. If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository to which you intend to upload layers.</p>
    pub repository_name: std::option::Option<std::string::String>,
}
impl InitiateLayerUploadInput {
    /// <p>The Amazon Web Services account ID associated with the registry to which you intend to upload
    /// layers. If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository to which you intend to upload layers.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
}
impl std::fmt::Debug for InitiateLayerUploadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InitiateLayerUploadInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRepositoryPolicyInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository with the policy to retrieve.</p>
    pub repository_name: std::option::Option<std::string::String>,
}
impl GetRepositoryPolicyInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository with the policy to retrieve.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
}
impl std::fmt::Debug for GetRepositoryPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRepositoryPolicyInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRegistryPolicyInput {}
impl std::fmt::Debug for GetRegistryPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRegistryPolicyInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLifecyclePolicyPreviewInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The list of imageIDs to be included.</p>
    pub image_ids: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>GetLifecyclePolicyPreviewRequest</code> request where <code>maxResults</code>
    /// was used and the  results exceeded the value of that parameter. Pagination continues
    /// from the end of the  previous results that returned the <code>nextToken</code> value.
    /// This value is  <code>null</code> when there are no more results to return. This option
    /// cannot be used when you specify images with <code>imageIds</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of repository results returned by
    /// <code>GetLifecyclePolicyPreviewRequest</code> in  paginated output. When this
    /// parameter is used, <code>GetLifecyclePolicyPreviewRequest</code> only returns
    /// <code>maxResults</code> results in a single page along with a
    /// <code>nextToken</code>  response element. The remaining results of the initial request
    /// can be seen by sending  another <code>GetLifecyclePolicyPreviewRequest</code> request
    /// with the returned <code>nextToken</code>  value. This value can be between
    /// 1 and 1000. If this  parameter is not used, then
    /// <code>GetLifecyclePolicyPreviewRequest</code> returns up to  100
    /// results and a <code>nextToken</code> value, if  applicable. This option cannot be used
    /// when you specify images with <code>imageIds</code>.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An optional parameter that filters results based on image tag status and all tags, if
    /// tagged.</p>
    pub filter: std::option::Option<crate::model::LifecyclePolicyPreviewFilter>,
}
impl GetLifecyclePolicyPreviewInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The list of imageIDs to be included.</p>
    pub fn image_ids(&self) -> std::option::Option<&[crate::model::ImageIdentifier]> {
        self.image_ids.as_deref()
    }
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>GetLifecyclePolicyPreviewRequest</code> request where <code>maxResults</code>
    /// was used and the  results exceeded the value of that parameter. Pagination continues
    /// from the end of the  previous results that returned the <code>nextToken</code> value.
    /// This value is  <code>null</code> when there are no more results to return. This option
    /// cannot be used when you specify images with <code>imageIds</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of repository results returned by
    /// <code>GetLifecyclePolicyPreviewRequest</code> in  paginated output. When this
    /// parameter is used, <code>GetLifecyclePolicyPreviewRequest</code> only returns
    /// <code>maxResults</code> results in a single page along with a
    /// <code>nextToken</code>  response element. The remaining results of the initial request
    /// can be seen by sending  another <code>GetLifecyclePolicyPreviewRequest</code> request
    /// with the returned <code>nextToken</code>  value. This value can be between
    /// 1 and 1000. If this  parameter is not used, then
    /// <code>GetLifecyclePolicyPreviewRequest</code> returns up to  100
    /// results and a <code>nextToken</code> value, if  applicable. This option cannot be used
    /// when you specify images with <code>imageIds</code>.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>An optional parameter that filters results based on image tag status and all tags, if
    /// tagged.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::LifecyclePolicyPreviewFilter> {
        self.filter.as_ref()
    }
}
impl std::fmt::Debug for GetLifecyclePolicyPreviewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLifecyclePolicyPreviewInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_ids", &self.image_ids);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLifecyclePolicyInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository.</p>
    pub repository_name: std::option::Option<std::string::String>,
}
impl GetLifecyclePolicyInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
}
impl std::fmt::Debug for GetLifecyclePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLifecyclePolicyInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDownloadUrlForLayerInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the image layer to
    /// download. If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository that is associated with the image layer to download.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The digest of the image layer to download.</p>
    pub layer_digest: std::option::Option<std::string::String>,
}
impl GetDownloadUrlForLayerInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the image layer to
    /// download. If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository that is associated with the image layer to download.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The digest of the image layer to download.</p>
    pub fn layer_digest(&self) -> std::option::Option<&str> {
        self.layer_digest.as_deref()
    }
}
impl std::fmt::Debug for GetDownloadUrlForLayerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDownloadUrlForLayerInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("layer_digest", &self.layer_digest);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAuthorizationTokenInput {
    /// <p>A list of Amazon Web Services account IDs that are associated with the registries for which to get
    /// AuthorizationData objects. If you do not specify a registry, the default registry is assumed.</p>
    pub registry_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetAuthorizationTokenInput {
    /// <p>A list of Amazon Web Services account IDs that are associated with the registries for which to get
    /// AuthorizationData objects. If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.registry_ids.as_deref()
    }
}
impl std::fmt::Debug for GetAuthorizationTokenInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAuthorizationTokenInput");
        formatter.field("registry_ids", &self.registry_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRepositoriesInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repositories to be
    /// described. If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>A list of repositories to describe. If this parameter is omitted, then all
    /// repositories in a registry are described.</p>
    pub repository_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>DescribeRepositories</code> request where <code>maxResults</code> was used and
    /// the results exceeded the value of that parameter. Pagination continues from the end of
    /// the previous results that returned the <code>nextToken</code> value. This value is
    /// <code>null</code> when there are no more results to return. This option cannot be
    /// used when you specify repositories with <code>repositoryNames</code>.</p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to
    /// retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of repository results returned by <code>DescribeRepositories</code>
    /// in paginated output. When this parameter is used, <code>DescribeRepositories</code> only
    /// returns <code>maxResults</code> results in a single page along with a
    /// <code>nextToken</code> response element. The remaining results of the initial
    /// request can be seen by sending another <code>DescribeRepositories</code> request with
    /// the returned <code>nextToken</code> value. This value can be between 1
    /// and 1000. If this parameter is not used, then
    /// <code>DescribeRepositories</code> returns up to 100 results and a
    /// <code>nextToken</code> value, if applicable. This option cannot be used when you
    /// specify repositories with <code>repositoryNames</code>.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeRepositoriesInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repositories to be
    /// described. If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>A list of repositories to describe. If this parameter is omitted, then all
    /// repositories in a registry are described.</p>
    pub fn repository_names(&self) -> std::option::Option<&[std::string::String]> {
        self.repository_names.as_deref()
    }
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>DescribeRepositories</code> request where <code>maxResults</code> was used and
    /// the results exceeded the value of that parameter. Pagination continues from the end of
    /// the previous results that returned the <code>nextToken</code> value. This value is
    /// <code>null</code> when there are no more results to return. This option cannot be
    /// used when you specify repositories with <code>repositoryNames</code>.</p>
    /// <note>
    /// <p>This token should be treated as an opaque identifier that is only used to
    /// retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of repository results returned by <code>DescribeRepositories</code>
    /// in paginated output. When this parameter is used, <code>DescribeRepositories</code> only
    /// returns <code>maxResults</code> results in a single page along with a
    /// <code>nextToken</code> response element. The remaining results of the initial
    /// request can be seen by sending another <code>DescribeRepositories</code> request with
    /// the returned <code>nextToken</code> value. This value can be between 1
    /// and 1000. If this parameter is not used, then
    /// <code>DescribeRepositories</code> returns up to 100 results and a
    /// <code>nextToken</code> value, if applicable. This option cannot be used when you
    /// specify repositories with <code>repositoryNames</code>.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeRepositoriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRepositoriesInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_names", &self.repository_names);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRegistryInput {}
impl std::fmt::Debug for DescribeRegistryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRegistryInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImageScanFindingsInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
    /// which to describe the image scan findings for. If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository for the image for which to describe the scan findings.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
    pub image_id: std::option::Option<crate::model::ImageIdentifier>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>DescribeImageScanFindings</code> request where <code>maxResults</code> was
    /// used and the results exceeded the value of that parameter. Pagination continues from the
    /// end of the previous results that returned the <code>nextToken</code> value. This value
    /// is null when there are no more results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of image scan results returned by
    /// <code>DescribeImageScanFindings</code> in paginated output. When this parameter is
    /// used, <code>DescribeImageScanFindings</code> only returns <code>maxResults</code>
    /// results in a single page along with a <code>nextToken</code> response element. The
    /// remaining results of the initial request can be seen by sending another
    /// <code>DescribeImageScanFindings</code> request with the returned
    /// <code>nextToken</code> value. This value can be between 1 and 1000. If this
    /// parameter is not used, then <code>DescribeImageScanFindings</code> returns up to 100
    /// results and a <code>nextToken</code> value, if applicable.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeImageScanFindingsInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
    /// which to describe the image scan findings for. If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository for the image for which to describe the scan findings.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
    pub fn image_id(&self) -> std::option::Option<&crate::model::ImageIdentifier> {
        self.image_id.as_ref()
    }
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>DescribeImageScanFindings</code> request where <code>maxResults</code> was
    /// used and the results exceeded the value of that parameter. Pagination continues from the
    /// end of the previous results that returned the <code>nextToken</code> value. This value
    /// is null when there are no more results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of image scan results returned by
    /// <code>DescribeImageScanFindings</code> in paginated output. When this parameter is
    /// used, <code>DescribeImageScanFindings</code> only returns <code>maxResults</code>
    /// results in a single page along with a <code>nextToken</code> response element. The
    /// remaining results of the initial request can be seen by sending another
    /// <code>DescribeImageScanFindings</code> request with the returned
    /// <code>nextToken</code> value. This value can be between 1 and 1000. If this
    /// parameter is not used, then <code>DescribeImageScanFindings</code> returns up to 100
    /// results and a <code>nextToken</code> value, if applicable.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeImageScanFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImageScanFindingsInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_id", &self.image_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImagesInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
    /// which to describe images. If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository that contains the images to describe.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The list of image IDs for the requested repository.</p>
    pub image_ids: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>DescribeImages</code> request where <code>maxResults</code> was used and the
    /// results exceeded the value of that parameter. Pagination continues from the end of the
    /// previous results that returned the <code>nextToken</code> value. This value is
    /// <code>null</code> when there are no more results to return. This option cannot be
    /// used when you specify images with <code>imageIds</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of repository results returned by <code>DescribeImages</code> in
    /// paginated output. When this parameter is used, <code>DescribeImages</code> only returns
    /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
    /// response element. The remaining results of the initial request can be seen by sending
    /// another <code>DescribeImages</code> request with the returned <code>nextToken</code>
    /// value. This value can be between 1 and 1000. If this
    /// parameter is not used, then <code>DescribeImages</code> returns up to
    /// 100 results and a <code>nextToken</code> value, if applicable. This
    /// option cannot be used when you specify images with <code>imageIds</code>.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The filter key and value with which to filter your <code>DescribeImages</code>
    /// results.</p>
    pub filter: std::option::Option<crate::model::DescribeImagesFilter>,
}
impl DescribeImagesInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository in
    /// which to describe images. If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository that contains the images to describe.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The list of image IDs for the requested repository.</p>
    pub fn image_ids(&self) -> std::option::Option<&[crate::model::ImageIdentifier]> {
        self.image_ids.as_deref()
    }
    /// <p>The <code>nextToken</code> value returned from a previous paginated
    /// <code>DescribeImages</code> request where <code>maxResults</code> was used and the
    /// results exceeded the value of that parameter. Pagination continues from the end of the
    /// previous results that returned the <code>nextToken</code> value. This value is
    /// <code>null</code> when there are no more results to return. This option cannot be
    /// used when you specify images with <code>imageIds</code>.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of repository results returned by <code>DescribeImages</code> in
    /// paginated output. When this parameter is used, <code>DescribeImages</code> only returns
    /// <code>maxResults</code> results in a single page along with a <code>nextToken</code>
    /// response element. The remaining results of the initial request can be seen by sending
    /// another <code>DescribeImages</code> request with the returned <code>nextToken</code>
    /// value. This value can be between 1 and 1000. If this
    /// parameter is not used, then <code>DescribeImages</code> returns up to
    /// 100 results and a <code>nextToken</code> value, if applicable. This
    /// option cannot be used when you specify images with <code>imageIds</code>.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The filter key and value with which to filter your <code>DescribeImages</code>
    /// results.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::DescribeImagesFilter> {
        self.filter.as_ref()
    }
}
impl std::fmt::Debug for DescribeImagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImagesInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_ids", &self.image_ids);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImageReplicationStatusInput {
    /// <p>The name of the repository that the image is in.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
    pub image_id: std::option::Option<crate::model::ImageIdentifier>,
    /// <p>The Amazon Web Services account ID associated with the registry. If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
}
impl DescribeImageReplicationStatusInput {
    /// <p>The name of the repository that the image is in.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>An object with identifying information for an image in an Amazon ECR repository.</p>
    pub fn image_id(&self) -> std::option::Option<&crate::model::ImageIdentifier> {
        self.image_id.as_ref()
    }
    /// <p>The Amazon Web Services account ID associated with the registry. If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeImageReplicationStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImageReplicationStatusInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_id", &self.image_id);
        formatter.field("registry_id", &self.registry_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRepositoryPolicyInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository policy
    /// to delete. If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository that is associated with the repository policy to
    /// delete.</p>
    pub repository_name: std::option::Option<std::string::String>,
}
impl DeleteRepositoryPolicyInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository policy
    /// to delete. If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository that is associated with the repository policy to
    /// delete.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteRepositoryPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRepositoryPolicyInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRepositoryInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository to
    /// delete. If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository to delete.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p> If a repository contains images, forces the deletion.</p>
    pub force: bool,
}
impl DeleteRepositoryInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository to
    /// delete. If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository to delete.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p> If a repository contains images, forces the deletion.</p>
    pub fn force(&self) -> bool {
        self.force
    }
}
impl std::fmt::Debug for DeleteRepositoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRepositoryInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("force", &self.force);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRegistryPolicyInput {}
impl std::fmt::Debug for DeleteRegistryPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRegistryPolicyInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLifecyclePolicyInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository.</p>
    pub repository_name: std::option::Option<std::string::String>,
}
impl DeleteLifecyclePolicyInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the repository.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteLifecyclePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLifecyclePolicyInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRepositoryInput {
    /// <p>The AWS account ID associated with the registry to create the repository.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name to use for the repository. The repository name may be specified on its own
    /// (such as <code>nginx-web-app</code>) or it can be prepended with a namespace to group
    /// the repository into a category (such as <code>project-a/nginx-web-app</code>).</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The metadata that you apply to the repository to help you categorize and organize
    /// them. Each tag consists of a key and an optional value, both of which you define.
    /// Tag keys can have a maximum character length of 128 characters, and tag values can have
    /// a maximum length of 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The tag mutability setting for the repository. If this parameter is omitted, the
    /// default setting of <code>MUTABLE</code> will be used which will allow image tags to be
    /// overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the
    /// repository will be immutable which will prevent them from being overwritten.</p>
    pub image_tag_mutability: std::option::Option<crate::model::ImageTagMutability>,
    /// <p>The image scanning configuration for the repository. This determines whether images
    /// are scanned for known vulnerabilities after being pushed to the repository.</p>
    pub image_scanning_configuration: std::option::Option<crate::model::ImageScanningConfiguration>,
    /// <p>The encryption configuration for the repository. This determines how the contents of
    /// your repository are encrypted at rest.</p>
    pub encryption_configuration: std::option::Option<crate::model::EncryptionConfiguration>,
}
impl CreateRepositoryInput {
    /// <p>The AWS account ID associated with the registry to create the repository.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name to use for the repository. The repository name may be specified on its own
    /// (such as <code>nginx-web-app</code>) or it can be prepended with a namespace to group
    /// the repository into a category (such as <code>project-a/nginx-web-app</code>).</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The metadata that you apply to the repository to help you categorize and organize
    /// them. Each tag consists of a key and an optional value, both of which you define.
    /// Tag keys can have a maximum character length of 128 characters, and tag values can have
    /// a maximum length of 256 characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The tag mutability setting for the repository. If this parameter is omitted, the
    /// default setting of <code>MUTABLE</code> will be used which will allow image tags to be
    /// overwritten. If <code>IMMUTABLE</code> is specified, all image tags within the
    /// repository will be immutable which will prevent them from being overwritten.</p>
    pub fn image_tag_mutability(&self) -> std::option::Option<&crate::model::ImageTagMutability> {
        self.image_tag_mutability.as_ref()
    }
    /// <p>The image scanning configuration for the repository. This determines whether images
    /// are scanned for known vulnerabilities after being pushed to the repository.</p>
    pub fn image_scanning_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ImageScanningConfiguration> {
        self.image_scanning_configuration.as_ref()
    }
    /// <p>The encryption configuration for the repository. This determines how the contents of
    /// your repository are encrypted at rest.</p>
    pub fn encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionConfiguration> {
        self.encryption_configuration.as_ref()
    }
}
impl std::fmt::Debug for CreateRepositoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRepositoryInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("tags", &self.tags);
        formatter.field("image_tag_mutability", &self.image_tag_mutability);
        formatter.field(
            "image_scanning_configuration",
            &self.image_scanning_configuration,
        );
        formatter.field("encryption_configuration", &self.encryption_configuration);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompleteLayerUploadInput {
    /// <p>The Amazon Web Services account ID associated with the registry to which to upload layers.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository to associate with the image layer.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
    /// associate with the image layer.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>The <code>sha256</code> digest of the image layer.</p>
    pub layer_digests: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CompleteLayerUploadInput {
    /// <p>The Amazon Web Services account ID associated with the registry to which to upload layers.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository to associate with the image layer.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The upload ID from a previous <a>InitiateLayerUpload</a> operation to
    /// associate with the image layer.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>The <code>sha256</code> digest of the image layer.</p>
    pub fn layer_digests(&self) -> std::option::Option<&[std::string::String]> {
        self.layer_digests.as_deref()
    }
}
impl std::fmt::Debug for CompleteLayerUploadInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompleteLayerUploadInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("upload_id", &self.upload_id);
        formatter.field("layer_digests", &self.layer_digests);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetImageInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the images to
    /// describe. If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository that contains the images to describe.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>A list of image ID references that correspond to images to describe. The format of the
    /// <code>imageIds</code> reference is <code>imageTag=tag</code> or
    /// <code>imageDigest=digest</code>.</p>
    pub image_ids: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
    /// <p>The accepted media types for the request.</p>
    /// <p>Valid values: <code>application/vnd.docker.distribution.manifest.v1+json</code> |
    /// <code>application/vnd.docker.distribution.manifest.v2+json</code> |
    /// <code>application/vnd.oci.image.manifest.v1+json</code>
    /// </p>
    pub accepted_media_types: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchGetImageInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the images to
    /// describe. If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository that contains the images to describe.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>A list of image ID references that correspond to images to describe. The format of the
    /// <code>imageIds</code> reference is <code>imageTag=tag</code> or
    /// <code>imageDigest=digest</code>.</p>
    pub fn image_ids(&self) -> std::option::Option<&[crate::model::ImageIdentifier]> {
        self.image_ids.as_deref()
    }
    /// <p>The accepted media types for the request.</p>
    /// <p>Valid values: <code>application/vnd.docker.distribution.manifest.v1+json</code> |
    /// <code>application/vnd.docker.distribution.manifest.v2+json</code> |
    /// <code>application/vnd.oci.image.manifest.v1+json</code>
    /// </p>
    pub fn accepted_media_types(&self) -> std::option::Option<&[std::string::String]> {
        self.accepted_media_types.as_deref()
    }
}
impl std::fmt::Debug for BatchGetImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetImageInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_ids", &self.image_ids);
        formatter.field("accepted_media_types", &self.accepted_media_types);
        formatter.finish()
    }
}

/// <p>Deletes specified images within a specified repository. Images are specified with
/// either the <code>imageTag</code> or <code>imageDigest</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteImageInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the image to delete.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The repository that contains the image to delete.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>A list of image ID references that correspond to images to delete. The format of the
    /// <code>imageIds</code> reference is <code>imageTag=tag</code> or
    /// <code>imageDigest=digest</code>.</p>
    pub image_ids: std::option::Option<std::vec::Vec<crate::model::ImageIdentifier>>,
}
impl BatchDeleteImageInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the image to delete.
    /// If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The repository that contains the image to delete.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>A list of image ID references that correspond to images to delete. The format of the
    /// <code>imageIds</code> reference is <code>imageTag=tag</code> or
    /// <code>imageDigest=digest</code>.</p>
    pub fn image_ids(&self) -> std::option::Option<&[crate::model::ImageIdentifier]> {
        self.image_ids.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteImageInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("image_ids", &self.image_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCheckLayerAvailabilityInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the image layers to
    /// check. If you do not specify a registry, the default registry is assumed.</p>
    pub registry_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository that is associated with the image layers to check.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The digests of the image layers to check.</p>
    pub layer_digests: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchCheckLayerAvailabilityInput {
    /// <p>The Amazon Web Services account ID associated with the registry that contains the image layers to
    /// check. If you do not specify a registry, the default registry is assumed.</p>
    pub fn registry_id(&self) -> std::option::Option<&str> {
        self.registry_id.as_deref()
    }
    /// <p>The name of the repository that is associated with the image layers to check.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The digests of the image layers to check.</p>
    pub fn layer_digests(&self) -> std::option::Option<&[std::string::String]> {
        self.layer_digests.as_deref()
    }
}
impl std::fmt::Debug for BatchCheckLayerAvailabilityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCheckLayerAvailabilityInput");
        formatter.field("registry_id", &self.registry_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("layer_digests", &self.layer_digests);
        formatter.finish()
    }
}
