// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `BatchCheckLayerAvailability`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_check_layer_availability`](crate::client::Client::batch_check_layer_availability).
///
/// See [`crate::client::fluent_builders::BatchCheckLayerAvailability`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchCheckLayerAvailability {
    _private: (),
}
impl BatchCheckLayerAvailability {
    /// Creates a new builder-style object to manufacture [`BatchCheckLayerAvailabilityInput`](crate::input::BatchCheckLayerAvailabilityInput)
    pub fn builder() -> crate::input::batch_check_layer_availability_input::Builder {
        crate::input::batch_check_layer_availability_input::Builder::default()
    }
    /// Creates a new `BatchCheckLayerAvailability` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchCheckLayerAvailability {
    type Output = std::result::Result<
        crate::output::BatchCheckLayerAvailabilityOutput,
        crate::error::BatchCheckLayerAvailabilityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_check_layer_availability_error(response)
        } else {
            crate::operation_deser::parse_batch_check_layer_availability_response(response)
        }
    }
}

/// Operation shape for `BatchDeleteImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_delete_image`](crate::client::Client::batch_delete_image).
///
/// See [`crate::client::fluent_builders::BatchDeleteImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDeleteImage {
    _private: (),
}
impl BatchDeleteImage {
    /// Creates a new builder-style object to manufacture [`BatchDeleteImageInput`](crate::input::BatchDeleteImageInput)
    pub fn builder() -> crate::input::batch_delete_image_input::Builder {
        crate::input::batch_delete_image_input::Builder::default()
    }
    /// Creates a new `BatchDeleteImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDeleteImage {
    type Output = std::result::Result<
        crate::output::BatchDeleteImageOutput,
        crate::error::BatchDeleteImageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_delete_image_error(response)
        } else {
            crate::operation_deser::parse_batch_delete_image_response(response)
        }
    }
}

/// Operation shape for `BatchGetImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_image`](crate::client::Client::batch_get_image).
///
/// See [`crate::client::fluent_builders::BatchGetImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetImage {
    _private: (),
}
impl BatchGetImage {
    /// Creates a new builder-style object to manufacture [`BatchGetImageInput`](crate::input::BatchGetImageInput)
    pub fn builder() -> crate::input::batch_get_image_input::Builder {
        crate::input::batch_get_image_input::Builder::default()
    }
    /// Creates a new `BatchGetImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetImage {
    type Output =
        std::result::Result<crate::output::BatchGetImageOutput, crate::error::BatchGetImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_image_error(response)
        } else {
            crate::operation_deser::parse_batch_get_image_response(response)
        }
    }
}

/// Operation shape for `CompleteLayerUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`complete_layer_upload`](crate::client::Client::complete_layer_upload).
///
/// See [`crate::client::fluent_builders::CompleteLayerUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CompleteLayerUpload {
    _private: (),
}
impl CompleteLayerUpload {
    /// Creates a new builder-style object to manufacture [`CompleteLayerUploadInput`](crate::input::CompleteLayerUploadInput)
    pub fn builder() -> crate::input::complete_layer_upload_input::Builder {
        crate::input::complete_layer_upload_input::Builder::default()
    }
    /// Creates a new `CompleteLayerUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CompleteLayerUpload {
    type Output = std::result::Result<
        crate::output::CompleteLayerUploadOutput,
        crate::error::CompleteLayerUploadError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_complete_layer_upload_error(response)
        } else {
            crate::operation_deser::parse_complete_layer_upload_response(response)
        }
    }
}

/// Operation shape for `CreateRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_repository`](crate::client::Client::create_repository).
///
/// See [`crate::client::fluent_builders::CreateRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRepository {
    _private: (),
}
impl CreateRepository {
    /// Creates a new builder-style object to manufacture [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
    pub fn builder() -> crate::input::create_repository_input::Builder {
        crate::input::create_repository_input::Builder::default()
    }
    /// Creates a new `CreateRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRepository {
    type Output = std::result::Result<
        crate::output::CreateRepositoryOutput,
        crate::error::CreateRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_repository_error(response)
        } else {
            crate::operation_deser::parse_create_repository_response(response)
        }
    }
}

/// Operation shape for `DeleteLifecyclePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_lifecycle_policy`](crate::client::Client::delete_lifecycle_policy).
///
/// See [`crate::client::fluent_builders::DeleteLifecyclePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLifecyclePolicy {
    _private: (),
}
impl DeleteLifecyclePolicy {
    /// Creates a new builder-style object to manufacture [`DeleteLifecyclePolicyInput`](crate::input::DeleteLifecyclePolicyInput)
    pub fn builder() -> crate::input::delete_lifecycle_policy_input::Builder {
        crate::input::delete_lifecycle_policy_input::Builder::default()
    }
    /// Creates a new `DeleteLifecyclePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLifecyclePolicy {
    type Output = std::result::Result<
        crate::output::DeleteLifecyclePolicyOutput,
        crate::error::DeleteLifecyclePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_lifecycle_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_lifecycle_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteRegistryPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_registry_policy`](crate::client::Client::delete_registry_policy).
///
/// See [`crate::client::fluent_builders::DeleteRegistryPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRegistryPolicy {
    _private: (),
}
impl DeleteRegistryPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteRegistryPolicyInput`](crate::input::DeleteRegistryPolicyInput)
    pub fn builder() -> crate::input::delete_registry_policy_input::Builder {
        crate::input::delete_registry_policy_input::Builder::default()
    }
    /// Creates a new `DeleteRegistryPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRegistryPolicy {
    type Output = std::result::Result<
        crate::output::DeleteRegistryPolicyOutput,
        crate::error::DeleteRegistryPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_registry_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_registry_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_repository`](crate::client::Client::delete_repository).
///
/// See [`crate::client::fluent_builders::DeleteRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRepository {
    _private: (),
}
impl DeleteRepository {
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
    pub fn builder() -> crate::input::delete_repository_input::Builder {
        crate::input::delete_repository_input::Builder::default()
    }
    /// Creates a new `DeleteRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRepository {
    type Output = std::result::Result<
        crate::output::DeleteRepositoryOutput,
        crate::error::DeleteRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_repository_error(response)
        } else {
            crate::operation_deser::parse_delete_repository_response(response)
        }
    }
}

/// Operation shape for `DeleteRepositoryPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_repository_policy`](crate::client::Client::delete_repository_policy).
///
/// See [`crate::client::fluent_builders::DeleteRepositoryPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRepositoryPolicy {
    _private: (),
}
impl DeleteRepositoryPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryPolicyInput`](crate::input::DeleteRepositoryPolicyInput)
    pub fn builder() -> crate::input::delete_repository_policy_input::Builder {
        crate::input::delete_repository_policy_input::Builder::default()
    }
    /// Creates a new `DeleteRepositoryPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRepositoryPolicy {
    type Output = std::result::Result<
        crate::output::DeleteRepositoryPolicyOutput,
        crate::error::DeleteRepositoryPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_repository_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_repository_policy_response(response)
        }
    }
}

/// Operation shape for `DescribeImageReplicationStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_image_replication_status`](crate::client::Client::describe_image_replication_status).
///
/// See [`crate::client::fluent_builders::DescribeImageReplicationStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeImageReplicationStatus {
    _private: (),
}
impl DescribeImageReplicationStatus {
    /// Creates a new builder-style object to manufacture [`DescribeImageReplicationStatusInput`](crate::input::DescribeImageReplicationStatusInput)
    pub fn builder() -> crate::input::describe_image_replication_status_input::Builder {
        crate::input::describe_image_replication_status_input::Builder::default()
    }
    /// Creates a new `DescribeImageReplicationStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeImageReplicationStatus {
    type Output = std::result::Result<
        crate::output::DescribeImageReplicationStatusOutput,
        crate::error::DescribeImageReplicationStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_image_replication_status_error(response)
        } else {
            crate::operation_deser::parse_describe_image_replication_status_response(response)
        }
    }
}

/// Operation shape for `DescribeImages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_images`](crate::client::Client::describe_images).
///
/// See [`crate::client::fluent_builders::DescribeImages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeImages {
    _private: (),
}
impl DescribeImages {
    /// Creates a new builder-style object to manufacture [`DescribeImagesInput`](crate::input::DescribeImagesInput)
    pub fn builder() -> crate::input::describe_images_input::Builder {
        crate::input::describe_images_input::Builder::default()
    }
    /// Creates a new `DescribeImages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeImages {
    type Output =
        std::result::Result<crate::output::DescribeImagesOutput, crate::error::DescribeImagesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_images_error(response)
        } else {
            crate::operation_deser::parse_describe_images_response(response)
        }
    }
}

/// Operation shape for `DescribeImageScanFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_image_scan_findings`](crate::client::Client::describe_image_scan_findings).
///
/// See [`crate::client::fluent_builders::DescribeImageScanFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeImageScanFindings {
    _private: (),
}
impl DescribeImageScanFindings {
    /// Creates a new builder-style object to manufacture [`DescribeImageScanFindingsInput`](crate::input::DescribeImageScanFindingsInput)
    pub fn builder() -> crate::input::describe_image_scan_findings_input::Builder {
        crate::input::describe_image_scan_findings_input::Builder::default()
    }
    /// Creates a new `DescribeImageScanFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeImageScanFindings {
    type Output = std::result::Result<
        crate::output::DescribeImageScanFindingsOutput,
        crate::error::DescribeImageScanFindingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_image_scan_findings_error(response)
        } else {
            crate::operation_deser::parse_describe_image_scan_findings_response(response)
        }
    }
}

/// Operation shape for `DescribeRegistry`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_registry`](crate::client::Client::describe_registry).
///
/// See [`crate::client::fluent_builders::DescribeRegistry`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRegistry {
    _private: (),
}
impl DescribeRegistry {
    /// Creates a new builder-style object to manufacture [`DescribeRegistryInput`](crate::input::DescribeRegistryInput)
    pub fn builder() -> crate::input::describe_registry_input::Builder {
        crate::input::describe_registry_input::Builder::default()
    }
    /// Creates a new `DescribeRegistry` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRegistry {
    type Output = std::result::Result<
        crate::output::DescribeRegistryOutput,
        crate::error::DescribeRegistryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_registry_error(response)
        } else {
            crate::operation_deser::parse_describe_registry_response(response)
        }
    }
}

/// Operation shape for `DescribeRepositories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_repositories`](crate::client::Client::describe_repositories).
///
/// See [`crate::client::fluent_builders::DescribeRepositories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRepositories {
    _private: (),
}
impl DescribeRepositories {
    /// Creates a new builder-style object to manufacture [`DescribeRepositoriesInput`](crate::input::DescribeRepositoriesInput)
    pub fn builder() -> crate::input::describe_repositories_input::Builder {
        crate::input::describe_repositories_input::Builder::default()
    }
    /// Creates a new `DescribeRepositories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRepositories {
    type Output = std::result::Result<
        crate::output::DescribeRepositoriesOutput,
        crate::error::DescribeRepositoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_repositories_error(response)
        } else {
            crate::operation_deser::parse_describe_repositories_response(response)
        }
    }
}

/// Operation shape for `GetAuthorizationToken`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_authorization_token`](crate::client::Client::get_authorization_token).
///
/// See [`crate::client::fluent_builders::GetAuthorizationToken`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAuthorizationToken {
    _private: (),
}
impl GetAuthorizationToken {
    /// Creates a new builder-style object to manufacture [`GetAuthorizationTokenInput`](crate::input::GetAuthorizationTokenInput)
    pub fn builder() -> crate::input::get_authorization_token_input::Builder {
        crate::input::get_authorization_token_input::Builder::default()
    }
    /// Creates a new `GetAuthorizationToken` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAuthorizationToken {
    type Output = std::result::Result<
        crate::output::GetAuthorizationTokenOutput,
        crate::error::GetAuthorizationTokenError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_authorization_token_error(response)
        } else {
            crate::operation_deser::parse_get_authorization_token_response(response)
        }
    }
}

/// Operation shape for `GetDownloadUrlForLayer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_download_url_for_layer`](crate::client::Client::get_download_url_for_layer).
///
/// See [`crate::client::fluent_builders::GetDownloadUrlForLayer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDownloadUrlForLayer {
    _private: (),
}
impl GetDownloadUrlForLayer {
    /// Creates a new builder-style object to manufacture [`GetDownloadUrlForLayerInput`](crate::input::GetDownloadUrlForLayerInput)
    pub fn builder() -> crate::input::get_download_url_for_layer_input::Builder {
        crate::input::get_download_url_for_layer_input::Builder::default()
    }
    /// Creates a new `GetDownloadUrlForLayer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDownloadUrlForLayer {
    type Output = std::result::Result<
        crate::output::GetDownloadUrlForLayerOutput,
        crate::error::GetDownloadUrlForLayerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_download_url_for_layer_error(response)
        } else {
            crate::operation_deser::parse_get_download_url_for_layer_response(response)
        }
    }
}

/// Operation shape for `GetLifecyclePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_lifecycle_policy`](crate::client::Client::get_lifecycle_policy).
///
/// See [`crate::client::fluent_builders::GetLifecyclePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLifecyclePolicy {
    _private: (),
}
impl GetLifecyclePolicy {
    /// Creates a new builder-style object to manufacture [`GetLifecyclePolicyInput`](crate::input::GetLifecyclePolicyInput)
    pub fn builder() -> crate::input::get_lifecycle_policy_input::Builder {
        crate::input::get_lifecycle_policy_input::Builder::default()
    }
    /// Creates a new `GetLifecyclePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLifecyclePolicy {
    type Output = std::result::Result<
        crate::output::GetLifecyclePolicyOutput,
        crate::error::GetLifecyclePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_lifecycle_policy_error(response)
        } else {
            crate::operation_deser::parse_get_lifecycle_policy_response(response)
        }
    }
}

/// Operation shape for `GetLifecyclePolicyPreview`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_lifecycle_policy_preview`](crate::client::Client::get_lifecycle_policy_preview).
///
/// See [`crate::client::fluent_builders::GetLifecyclePolicyPreview`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLifecyclePolicyPreview {
    _private: (),
}
impl GetLifecyclePolicyPreview {
    /// Creates a new builder-style object to manufacture [`GetLifecyclePolicyPreviewInput`](crate::input::GetLifecyclePolicyPreviewInput)
    pub fn builder() -> crate::input::get_lifecycle_policy_preview_input::Builder {
        crate::input::get_lifecycle_policy_preview_input::Builder::default()
    }
    /// Creates a new `GetLifecyclePolicyPreview` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLifecyclePolicyPreview {
    type Output = std::result::Result<
        crate::output::GetLifecyclePolicyPreviewOutput,
        crate::error::GetLifecyclePolicyPreviewError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_lifecycle_policy_preview_error(response)
        } else {
            crate::operation_deser::parse_get_lifecycle_policy_preview_response(response)
        }
    }
}

/// Operation shape for `GetRegistryPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_registry_policy`](crate::client::Client::get_registry_policy).
///
/// See [`crate::client::fluent_builders::GetRegistryPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRegistryPolicy {
    _private: (),
}
impl GetRegistryPolicy {
    /// Creates a new builder-style object to manufacture [`GetRegistryPolicyInput`](crate::input::GetRegistryPolicyInput)
    pub fn builder() -> crate::input::get_registry_policy_input::Builder {
        crate::input::get_registry_policy_input::Builder::default()
    }
    /// Creates a new `GetRegistryPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRegistryPolicy {
    type Output = std::result::Result<
        crate::output::GetRegistryPolicyOutput,
        crate::error::GetRegistryPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_registry_policy_error(response)
        } else {
            crate::operation_deser::parse_get_registry_policy_response(response)
        }
    }
}

/// Operation shape for `GetRepositoryPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_repository_policy`](crate::client::Client::get_repository_policy).
///
/// See [`crate::client::fluent_builders::GetRepositoryPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRepositoryPolicy {
    _private: (),
}
impl GetRepositoryPolicy {
    /// Creates a new builder-style object to manufacture [`GetRepositoryPolicyInput`](crate::input::GetRepositoryPolicyInput)
    pub fn builder() -> crate::input::get_repository_policy_input::Builder {
        crate::input::get_repository_policy_input::Builder::default()
    }
    /// Creates a new `GetRepositoryPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRepositoryPolicy {
    type Output = std::result::Result<
        crate::output::GetRepositoryPolicyOutput,
        crate::error::GetRepositoryPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_repository_policy_error(response)
        } else {
            crate::operation_deser::parse_get_repository_policy_response(response)
        }
    }
}

/// Operation shape for `InitiateLayerUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`initiate_layer_upload`](crate::client::Client::initiate_layer_upload).
///
/// See [`crate::client::fluent_builders::InitiateLayerUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InitiateLayerUpload {
    _private: (),
}
impl InitiateLayerUpload {
    /// Creates a new builder-style object to manufacture [`InitiateLayerUploadInput`](crate::input::InitiateLayerUploadInput)
    pub fn builder() -> crate::input::initiate_layer_upload_input::Builder {
        crate::input::initiate_layer_upload_input::Builder::default()
    }
    /// Creates a new `InitiateLayerUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InitiateLayerUpload {
    type Output = std::result::Result<
        crate::output::InitiateLayerUploadOutput,
        crate::error::InitiateLayerUploadError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_initiate_layer_upload_error(response)
        } else {
            crate::operation_deser::parse_initiate_layer_upload_response(response)
        }
    }
}

/// Operation shape for `ListImages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_images`](crate::client::Client::list_images).
///
/// See [`crate::client::fluent_builders::ListImages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListImages {
    _private: (),
}
impl ListImages {
    /// Creates a new builder-style object to manufacture [`ListImagesInput`](crate::input::ListImagesInput)
    pub fn builder() -> crate::input::list_images_input::Builder {
        crate::input::list_images_input::Builder::default()
    }
    /// Creates a new `ListImages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListImages {
    type Output =
        std::result::Result<crate::output::ListImagesOutput, crate::error::ListImagesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_images_error(response)
        } else {
            crate::operation_deser::parse_list_images_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_image`](crate::client::Client::put_image).
///
/// See [`crate::client::fluent_builders::PutImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutImage {
    _private: (),
}
impl PutImage {
    /// Creates a new builder-style object to manufacture [`PutImageInput`](crate::input::PutImageInput)
    pub fn builder() -> crate::input::put_image_input::Builder {
        crate::input::put_image_input::Builder::default()
    }
    /// Creates a new `PutImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutImage {
    type Output = std::result::Result<crate::output::PutImageOutput, crate::error::PutImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_image_error(response)
        } else {
            crate::operation_deser::parse_put_image_response(response)
        }
    }
}

/// Operation shape for `PutImageScanningConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_image_scanning_configuration`](crate::client::Client::put_image_scanning_configuration).
///
/// See [`crate::client::fluent_builders::PutImageScanningConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutImageScanningConfiguration {
    _private: (),
}
impl PutImageScanningConfiguration {
    /// Creates a new builder-style object to manufacture [`PutImageScanningConfigurationInput`](crate::input::PutImageScanningConfigurationInput)
    pub fn builder() -> crate::input::put_image_scanning_configuration_input::Builder {
        crate::input::put_image_scanning_configuration_input::Builder::default()
    }
    /// Creates a new `PutImageScanningConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutImageScanningConfiguration {
    type Output = std::result::Result<
        crate::output::PutImageScanningConfigurationOutput,
        crate::error::PutImageScanningConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_image_scanning_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_image_scanning_configuration_response(response)
        }
    }
}

/// Operation shape for `PutImageTagMutability`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_image_tag_mutability`](crate::client::Client::put_image_tag_mutability).
///
/// See [`crate::client::fluent_builders::PutImageTagMutability`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutImageTagMutability {
    _private: (),
}
impl PutImageTagMutability {
    /// Creates a new builder-style object to manufacture [`PutImageTagMutabilityInput`](crate::input::PutImageTagMutabilityInput)
    pub fn builder() -> crate::input::put_image_tag_mutability_input::Builder {
        crate::input::put_image_tag_mutability_input::Builder::default()
    }
    /// Creates a new `PutImageTagMutability` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutImageTagMutability {
    type Output = std::result::Result<
        crate::output::PutImageTagMutabilityOutput,
        crate::error::PutImageTagMutabilityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_image_tag_mutability_error(response)
        } else {
            crate::operation_deser::parse_put_image_tag_mutability_response(response)
        }
    }
}

/// Operation shape for `PutLifecyclePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_lifecycle_policy`](crate::client::Client::put_lifecycle_policy).
///
/// See [`crate::client::fluent_builders::PutLifecyclePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutLifecyclePolicy {
    _private: (),
}
impl PutLifecyclePolicy {
    /// Creates a new builder-style object to manufacture [`PutLifecyclePolicyInput`](crate::input::PutLifecyclePolicyInput)
    pub fn builder() -> crate::input::put_lifecycle_policy_input::Builder {
        crate::input::put_lifecycle_policy_input::Builder::default()
    }
    /// Creates a new `PutLifecyclePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutLifecyclePolicy {
    type Output = std::result::Result<
        crate::output::PutLifecyclePolicyOutput,
        crate::error::PutLifecyclePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_lifecycle_policy_error(response)
        } else {
            crate::operation_deser::parse_put_lifecycle_policy_response(response)
        }
    }
}

/// Operation shape for `PutRegistryPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_registry_policy`](crate::client::Client::put_registry_policy).
///
/// See [`crate::client::fluent_builders::PutRegistryPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutRegistryPolicy {
    _private: (),
}
impl PutRegistryPolicy {
    /// Creates a new builder-style object to manufacture [`PutRegistryPolicyInput`](crate::input::PutRegistryPolicyInput)
    pub fn builder() -> crate::input::put_registry_policy_input::Builder {
        crate::input::put_registry_policy_input::Builder::default()
    }
    /// Creates a new `PutRegistryPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutRegistryPolicy {
    type Output = std::result::Result<
        crate::output::PutRegistryPolicyOutput,
        crate::error::PutRegistryPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_registry_policy_error(response)
        } else {
            crate::operation_deser::parse_put_registry_policy_response(response)
        }
    }
}

/// Operation shape for `PutReplicationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_replication_configuration`](crate::client::Client::put_replication_configuration).
///
/// See [`crate::client::fluent_builders::PutReplicationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutReplicationConfiguration {
    _private: (),
}
impl PutReplicationConfiguration {
    /// Creates a new builder-style object to manufacture [`PutReplicationConfigurationInput`](crate::input::PutReplicationConfigurationInput)
    pub fn builder() -> crate::input::put_replication_configuration_input::Builder {
        crate::input::put_replication_configuration_input::Builder::default()
    }
    /// Creates a new `PutReplicationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutReplicationConfiguration {
    type Output = std::result::Result<
        crate::output::PutReplicationConfigurationOutput,
        crate::error::PutReplicationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_replication_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_replication_configuration_response(response)
        }
    }
}

/// Operation shape for `SetRepositoryPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_repository_policy`](crate::client::Client::set_repository_policy).
///
/// See [`crate::client::fluent_builders::SetRepositoryPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetRepositoryPolicy {
    _private: (),
}
impl SetRepositoryPolicy {
    /// Creates a new builder-style object to manufacture [`SetRepositoryPolicyInput`](crate::input::SetRepositoryPolicyInput)
    pub fn builder() -> crate::input::set_repository_policy_input::Builder {
        crate::input::set_repository_policy_input::Builder::default()
    }
    /// Creates a new `SetRepositoryPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetRepositoryPolicy {
    type Output = std::result::Result<
        crate::output::SetRepositoryPolicyOutput,
        crate::error::SetRepositoryPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_repository_policy_error(response)
        } else {
            crate::operation_deser::parse_set_repository_policy_response(response)
        }
    }
}

/// Operation shape for `StartImageScan`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_image_scan`](crate::client::Client::start_image_scan).
///
/// See [`crate::client::fluent_builders::StartImageScan`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartImageScan {
    _private: (),
}
impl StartImageScan {
    /// Creates a new builder-style object to manufacture [`StartImageScanInput`](crate::input::StartImageScanInput)
    pub fn builder() -> crate::input::start_image_scan_input::Builder {
        crate::input::start_image_scan_input::Builder::default()
    }
    /// Creates a new `StartImageScan` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartImageScan {
    type Output =
        std::result::Result<crate::output::StartImageScanOutput, crate::error::StartImageScanError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_image_scan_error(response)
        } else {
            crate::operation_deser::parse_start_image_scan_response(response)
        }
    }
}

/// Operation shape for `StartLifecyclePolicyPreview`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_lifecycle_policy_preview`](crate::client::Client::start_lifecycle_policy_preview).
///
/// See [`crate::client::fluent_builders::StartLifecyclePolicyPreview`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartLifecyclePolicyPreview {
    _private: (),
}
impl StartLifecyclePolicyPreview {
    /// Creates a new builder-style object to manufacture [`StartLifecyclePolicyPreviewInput`](crate::input::StartLifecyclePolicyPreviewInput)
    pub fn builder() -> crate::input::start_lifecycle_policy_preview_input::Builder {
        crate::input::start_lifecycle_policy_preview_input::Builder::default()
    }
    /// Creates a new `StartLifecyclePolicyPreview` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartLifecyclePolicyPreview {
    type Output = std::result::Result<
        crate::output::StartLifecyclePolicyPreviewOutput,
        crate::error::StartLifecyclePolicyPreviewError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_lifecycle_policy_preview_error(response)
        } else {
            crate::operation_deser::parse_start_lifecycle_policy_preview_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UploadLayerPart`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`upload_layer_part`](crate::client::Client::upload_layer_part).
///
/// See [`crate::client::fluent_builders::UploadLayerPart`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UploadLayerPart {
    _private: (),
}
impl UploadLayerPart {
    /// Creates a new builder-style object to manufacture [`UploadLayerPartInput`](crate::input::UploadLayerPartInput)
    pub fn builder() -> crate::input::upload_layer_part_input::Builder {
        crate::input::upload_layer_part_input::Builder::default()
    }
    /// Creates a new `UploadLayerPart` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UploadLayerPart {
    type Output = std::result::Result<
        crate::output::UploadLayerPartOutput,
        crate::error::UploadLayerPartError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_upload_layer_part_error(response)
        } else {
            crate::operation_deser::parse_upload_layer_part_response(response)
        }
    }
}
