// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `SendSerialConsoleSSHPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendSerialConsoleSSHPublicKeyError {
    /// Kind of error that occurred.
    pub kind: SendSerialConsoleSSHPublicKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendSerialConsoleSSHPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendSerialConsoleSSHPublicKeyErrorKind {
    /// <p>Either your AWS credentials are not valid or you do not have access to the EC2 instance.</p>
    AuthException(crate::error::AuthException),
    /// <p>The specified instance was not found.</p>
    Ec2InstanceNotFoundException(crate::error::Ec2InstanceNotFoundException),
    /// <p>The instance type is not supported for connecting via the serial console. Only Nitro
    /// instance types are currently supported.</p>
    Ec2InstanceTypeInvalidException(crate::error::Ec2InstanceTypeInvalidException),
    /// <p>One of the parameters is not valid.</p>
    InvalidArgsException(crate::error::InvalidArgsException),
    /// <p>Your account is not authorized to use the EC2 Serial Console. To authorize your
    /// account, run the EnableSerialConsoleAccess API. For more information, see
    /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableSerialConsoleAccess.html">EnableSerialConsoleAccess</a> in the <i>Amazon EC2 API Reference</i>.</p>
    SerialConsoleAccessDisabledException(crate::error::SerialConsoleAccessDisabledException),
    /// <p>The instance currently has 1 active serial console session. Only 1 session is supported at a time.</p>
    SerialConsoleSessionLimitExceededException(
        crate::error::SerialConsoleSessionLimitExceededException,
    ),
    /// <p>Unable to start a serial console session. Please try again.</p>
    SerialConsoleSessionUnavailableException(
        crate::error::SerialConsoleSessionUnavailableException,
    ),
    /// <p>The service encountered an error. Follow the instructions in the error message and try again.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The requests were made too frequently and have been throttled. Wait a while and try again.
    /// To increase the limit on your request frequency, contact AWS Support.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendSerialConsoleSSHPublicKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendSerialConsoleSSHPublicKeyErrorKind::AuthException(_inner) => _inner.fmt(f),
            SendSerialConsoleSSHPublicKeyErrorKind::Ec2InstanceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            SendSerialConsoleSSHPublicKeyErrorKind::Ec2InstanceTypeInvalidException(_inner) => {
                _inner.fmt(f)
            }
            SendSerialConsoleSSHPublicKeyErrorKind::InvalidArgsException(_inner) => _inner.fmt(f),
            SendSerialConsoleSSHPublicKeyErrorKind::SerialConsoleAccessDisabledException(
                _inner,
            ) => _inner.fmt(f),
            SendSerialConsoleSSHPublicKeyErrorKind::SerialConsoleSessionLimitExceededException(
                _inner,
            ) => _inner.fmt(f),
            SendSerialConsoleSSHPublicKeyErrorKind::SerialConsoleSessionUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            SendSerialConsoleSSHPublicKeyErrorKind::ServiceException(_inner) => _inner.fmt(f),
            SendSerialConsoleSSHPublicKeyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SendSerialConsoleSSHPublicKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendSerialConsoleSSHPublicKeyError {
    fn code(&self) -> Option<&str> {
        SendSerialConsoleSSHPublicKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendSerialConsoleSSHPublicKeyError {
    /// Creates a new `SendSerialConsoleSSHPublicKeyError`.
    pub fn new(
        kind: SendSerialConsoleSSHPublicKeyErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendSerialConsoleSSHPublicKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendSerialConsoleSSHPublicKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendSerialConsoleSSHPublicKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendSerialConsoleSSHPublicKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendSerialConsoleSSHPublicKeyErrorKind::AuthException`.
    pub fn is_auth_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendSerialConsoleSSHPublicKeyErrorKind::AuthException(_)
        )
    }
    /// Returns `true` if the error kind is `SendSerialConsoleSSHPublicKeyErrorKind::Ec2InstanceNotFoundException`.
    pub fn is_ec2_instance_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendSerialConsoleSSHPublicKeyErrorKind::Ec2InstanceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SendSerialConsoleSSHPublicKeyErrorKind::Ec2InstanceTypeInvalidException`.
    pub fn is_ec2_instance_type_invalid_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendSerialConsoleSSHPublicKeyErrorKind::Ec2InstanceTypeInvalidException(_)
        )
    }
    /// Returns `true` if the error kind is `SendSerialConsoleSSHPublicKeyErrorKind::InvalidArgsException`.
    pub fn is_invalid_args_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendSerialConsoleSSHPublicKeyErrorKind::InvalidArgsException(_)
        )
    }
    /// Returns `true` if the error kind is `SendSerialConsoleSSHPublicKeyErrorKind::SerialConsoleAccessDisabledException`.
    pub fn is_serial_console_access_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendSerialConsoleSSHPublicKeyErrorKind::SerialConsoleAccessDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `SendSerialConsoleSSHPublicKeyErrorKind::SerialConsoleSessionLimitExceededException`.
    pub fn is_serial_console_session_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendSerialConsoleSSHPublicKeyErrorKind::SerialConsoleSessionLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `SendSerialConsoleSSHPublicKeyErrorKind::SerialConsoleSessionUnavailableException`.
    pub fn is_serial_console_session_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendSerialConsoleSSHPublicKeyErrorKind::SerialConsoleSessionUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `SendSerialConsoleSSHPublicKeyErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendSerialConsoleSSHPublicKeyErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `SendSerialConsoleSSHPublicKeyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendSerialConsoleSSHPublicKeyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for SendSerialConsoleSSHPublicKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendSerialConsoleSSHPublicKeyErrorKind::AuthException(_inner) => Some(_inner),
            SendSerialConsoleSSHPublicKeyErrorKind::Ec2InstanceNotFoundException(_inner) => {
                Some(_inner)
            }
            SendSerialConsoleSSHPublicKeyErrorKind::Ec2InstanceTypeInvalidException(_inner) => {
                Some(_inner)
            }
            SendSerialConsoleSSHPublicKeyErrorKind::InvalidArgsException(_inner) => Some(_inner),
            SendSerialConsoleSSHPublicKeyErrorKind::SerialConsoleAccessDisabledException(
                _inner,
            ) => Some(_inner),
            SendSerialConsoleSSHPublicKeyErrorKind::SerialConsoleSessionLimitExceededException(
                _inner,
            ) => Some(_inner),
            SendSerialConsoleSSHPublicKeyErrorKind::SerialConsoleSessionUnavailableException(
                _inner,
            ) => Some(_inner),
            SendSerialConsoleSSHPublicKeyErrorKind::ServiceException(_inner) => Some(_inner),
            SendSerialConsoleSSHPublicKeyErrorKind::ThrottlingException(_inner) => Some(_inner),
            SendSerialConsoleSSHPublicKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendSSHPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendSSHPublicKeyError {
    /// Kind of error that occurred.
    pub kind: SendSSHPublicKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendSSHPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendSSHPublicKeyErrorKind {
    /// <p>Either your AWS credentials are not valid or you do not have access to the EC2 instance.</p>
    AuthException(crate::error::AuthException),
    /// <p>The specified instance was not found.</p>
    Ec2InstanceNotFoundException(crate::error::Ec2InstanceNotFoundException),
    /// <p>One of the parameters is not valid.</p>
    InvalidArgsException(crate::error::InvalidArgsException),
    /// <p>The service encountered an error. Follow the instructions in the error message and try again.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The requests were made too frequently and have been throttled. Wait a while and try again.
    /// To increase the limit on your request frequency, contact AWS Support.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendSSHPublicKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendSSHPublicKeyErrorKind::AuthException(_inner) => _inner.fmt(f),
            SendSSHPublicKeyErrorKind::Ec2InstanceNotFoundException(_inner) => _inner.fmt(f),
            SendSSHPublicKeyErrorKind::InvalidArgsException(_inner) => _inner.fmt(f),
            SendSSHPublicKeyErrorKind::ServiceException(_inner) => _inner.fmt(f),
            SendSSHPublicKeyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SendSSHPublicKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendSSHPublicKeyError {
    fn code(&self) -> Option<&str> {
        SendSSHPublicKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendSSHPublicKeyError {
    /// Creates a new `SendSSHPublicKeyError`.
    pub fn new(kind: SendSSHPublicKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendSSHPublicKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendSSHPublicKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendSSHPublicKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendSSHPublicKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendSSHPublicKeyErrorKind::AuthException`.
    pub fn is_auth_exception(&self) -> bool {
        matches!(&self.kind, SendSSHPublicKeyErrorKind::AuthException(_))
    }
    /// Returns `true` if the error kind is `SendSSHPublicKeyErrorKind::Ec2InstanceNotFoundException`.
    pub fn is_ec2_instance_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendSSHPublicKeyErrorKind::Ec2InstanceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SendSSHPublicKeyErrorKind::InvalidArgsException`.
    pub fn is_invalid_args_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendSSHPublicKeyErrorKind::InvalidArgsException(_)
        )
    }
    /// Returns `true` if the error kind is `SendSSHPublicKeyErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, SendSSHPublicKeyErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `SendSSHPublicKeyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendSSHPublicKeyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for SendSSHPublicKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendSSHPublicKeyErrorKind::AuthException(_inner) => Some(_inner),
            SendSSHPublicKeyErrorKind::Ec2InstanceNotFoundException(_inner) => Some(_inner),
            SendSSHPublicKeyErrorKind::InvalidArgsException(_inner) => Some(_inner),
            SendSSHPublicKeyErrorKind::ServiceException(_inner) => Some(_inner),
            SendSSHPublicKeyErrorKind::ThrottlingException(_inner) => Some(_inner),
            SendSSHPublicKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The requests were made too frequently and have been throttled. Wait a while and try again.
/// To increase the limit on your request frequency, contact AWS Support.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The service encountered an error. Follow the instructions in the error message and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceException {}
/// See [`ServiceException`](crate::error::ServiceException)
pub mod service_exception {
    /// A builder for [`ServiceException`](crate::error::ServiceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceException`](crate::error::ServiceException)
        pub fn build(self) -> crate::error::ServiceException {
            crate::error::ServiceException {
                message: self.message,
            }
        }
    }
}
impl ServiceException {
    /// Creates a new builder-style object to manufacture [`ServiceException`](crate::error::ServiceException)
    pub fn builder() -> crate::error::service_exception::Builder {
        crate::error::service_exception::Builder::default()
    }
}

/// <p>One of the parameters is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidArgsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidArgsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidArgsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidArgsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidArgsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidArgsException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidArgsException {}
/// See [`InvalidArgsException`](crate::error::InvalidArgsException)
pub mod invalid_args_exception {
    /// A builder for [`InvalidArgsException`](crate::error::InvalidArgsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidArgsException`](crate::error::InvalidArgsException)
        pub fn build(self) -> crate::error::InvalidArgsException {
            crate::error::InvalidArgsException {
                message: self.message,
            }
        }
    }
}
impl InvalidArgsException {
    /// Creates a new builder-style object to manufacture [`InvalidArgsException`](crate::error::InvalidArgsException)
    pub fn builder() -> crate::error::invalid_args_exception::Builder {
        crate::error::invalid_args_exception::Builder::default()
    }
}

/// <p>The specified instance was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2InstanceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Ec2InstanceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2InstanceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl Ec2InstanceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for Ec2InstanceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "Ec2InstanceNotFoundException [EC2InstanceNotFoundException]"
        )?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for Ec2InstanceNotFoundException {}
/// See [`Ec2InstanceNotFoundException`](crate::error::Ec2InstanceNotFoundException)
pub mod ec2_instance_not_found_exception {
    /// A builder for [`Ec2InstanceNotFoundException`](crate::error::Ec2InstanceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2InstanceNotFoundException`](crate::error::Ec2InstanceNotFoundException)
        pub fn build(self) -> crate::error::Ec2InstanceNotFoundException {
            crate::error::Ec2InstanceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl Ec2InstanceNotFoundException {
    /// Creates a new builder-style object to manufacture [`Ec2InstanceNotFoundException`](crate::error::Ec2InstanceNotFoundException)
    pub fn builder() -> crate::error::ec2_instance_not_found_exception::Builder {
        crate::error::ec2_instance_not_found_exception::Builder::default()
    }
}

/// <p>Either your AWS credentials are not valid or you do not have access to the EC2 instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AuthException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AuthException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AuthException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AuthException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AuthException {}
/// See [`AuthException`](crate::error::AuthException)
pub mod auth_exception {
    /// A builder for [`AuthException`](crate::error::AuthException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthException`](crate::error::AuthException)
        pub fn build(self) -> crate::error::AuthException {
            crate::error::AuthException {
                message: self.message,
            }
        }
    }
}
impl AuthException {
    /// Creates a new builder-style object to manufacture [`AuthException`](crate::error::AuthException)
    pub fn builder() -> crate::error::auth_exception::Builder {
        crate::error::auth_exception::Builder::default()
    }
}

/// <p>Unable to start a serial console session. Please try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SerialConsoleSessionUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SerialConsoleSessionUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SerialConsoleSessionUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SerialConsoleSessionUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SerialConsoleSessionUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SerialConsoleSessionUnavailableException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for SerialConsoleSessionUnavailableException {}
/// See [`SerialConsoleSessionUnavailableException`](crate::error::SerialConsoleSessionUnavailableException)
pub mod serial_console_session_unavailable_exception {
    /// A builder for [`SerialConsoleSessionUnavailableException`](crate::error::SerialConsoleSessionUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SerialConsoleSessionUnavailableException`](crate::error::SerialConsoleSessionUnavailableException)
        pub fn build(self) -> crate::error::SerialConsoleSessionUnavailableException {
            crate::error::SerialConsoleSessionUnavailableException {
                message: self.message,
            }
        }
    }
}
impl SerialConsoleSessionUnavailableException {
    /// Creates a new builder-style object to manufacture [`SerialConsoleSessionUnavailableException`](crate::error::SerialConsoleSessionUnavailableException)
    pub fn builder() -> crate::error::serial_console_session_unavailable_exception::Builder {
        crate::error::serial_console_session_unavailable_exception::Builder::default()
    }
}

/// <p>The instance currently has 1 active serial console session. Only 1 session is supported at a time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SerialConsoleSessionLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SerialConsoleSessionLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SerialConsoleSessionLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SerialConsoleSessionLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SerialConsoleSessionLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SerialConsoleSessionLimitExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for SerialConsoleSessionLimitExceededException {}
/// See [`SerialConsoleSessionLimitExceededException`](crate::error::SerialConsoleSessionLimitExceededException)
pub mod serial_console_session_limit_exceeded_exception {
    /// A builder for [`SerialConsoleSessionLimitExceededException`](crate::error::SerialConsoleSessionLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SerialConsoleSessionLimitExceededException`](crate::error::SerialConsoleSessionLimitExceededException)
        pub fn build(self) -> crate::error::SerialConsoleSessionLimitExceededException {
            crate::error::SerialConsoleSessionLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl SerialConsoleSessionLimitExceededException {
    /// Creates a new builder-style object to manufacture [`SerialConsoleSessionLimitExceededException`](crate::error::SerialConsoleSessionLimitExceededException)
    pub fn builder() -> crate::error::serial_console_session_limit_exceeded_exception::Builder {
        crate::error::serial_console_session_limit_exceeded_exception::Builder::default()
    }
}

/// <p>Your account is not authorized to use the EC2 Serial Console. To authorize your
/// account, run the EnableSerialConsoleAccess API. For more information, see
/// <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableSerialConsoleAccess.html">EnableSerialConsoleAccess</a> in the <i>Amazon EC2 API Reference</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SerialConsoleAccessDisabledException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SerialConsoleAccessDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SerialConsoleAccessDisabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SerialConsoleAccessDisabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SerialConsoleAccessDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SerialConsoleAccessDisabledException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for SerialConsoleAccessDisabledException {}
/// See [`SerialConsoleAccessDisabledException`](crate::error::SerialConsoleAccessDisabledException)
pub mod serial_console_access_disabled_exception {
    /// A builder for [`SerialConsoleAccessDisabledException`](crate::error::SerialConsoleAccessDisabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SerialConsoleAccessDisabledException`](crate::error::SerialConsoleAccessDisabledException)
        pub fn build(self) -> crate::error::SerialConsoleAccessDisabledException {
            crate::error::SerialConsoleAccessDisabledException {
                message: self.message,
            }
        }
    }
}
impl SerialConsoleAccessDisabledException {
    /// Creates a new builder-style object to manufacture [`SerialConsoleAccessDisabledException`](crate::error::SerialConsoleAccessDisabledException)
    pub fn builder() -> crate::error::serial_console_access_disabled_exception::Builder {
        crate::error::serial_console_access_disabled_exception::Builder::default()
    }
}

/// <p>The instance type is not supported for connecting via the serial console. Only Nitro
/// instance types are currently supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2InstanceTypeInvalidException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Ec2InstanceTypeInvalidException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2InstanceTypeInvalidException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl Ec2InstanceTypeInvalidException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for Ec2InstanceTypeInvalidException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "Ec2InstanceTypeInvalidException [EC2InstanceTypeInvalidException]"
        )?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for Ec2InstanceTypeInvalidException {}
/// See [`Ec2InstanceTypeInvalidException`](crate::error::Ec2InstanceTypeInvalidException)
pub mod ec2_instance_type_invalid_exception {
    /// A builder for [`Ec2InstanceTypeInvalidException`](crate::error::Ec2InstanceTypeInvalidException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2InstanceTypeInvalidException`](crate::error::Ec2InstanceTypeInvalidException)
        pub fn build(self) -> crate::error::Ec2InstanceTypeInvalidException {
            crate::error::Ec2InstanceTypeInvalidException {
                message: self.message,
            }
        }
    }
}
impl Ec2InstanceTypeInvalidException {
    /// Creates a new builder-style object to manufacture [`Ec2InstanceTypeInvalidException`](crate::error::Ec2InstanceTypeInvalidException)
    pub fn builder() -> crate::error::ec2_instance_type_invalid_exception::Builder {
        crate::error::ec2_instance_type_invalid_exception::Builder::default()
    }
}
